# ![LMMS Logo](http://lmms.sourceforge.net/Lmms_logo.png) LMMS

[![Build status](https://img.shields.io/travis/LMMS/lmms.svg?maxAge=3600)](https://travis-ci.org/LMMS/lmms)
[![Latest stable release](https://img.shields.io/github/release/LMMS/lmms.svg?maxAge=3600)](https://lmms.io/download)
[![Overall downloads on Github](https://img.shields.io/github/downloads/LMMS/lmms/total.svg?maxAge=3600)](https://github.com/LMMS/lmms/releases)
[![Join the chat at Discord](https://img.shields.io/badge/chat-on%20discord-7289DA.svg)](https://discord.gg/3sc5su7)
[![Localise on transifex](https://img.shields.io/badge/localise-on_transifex-green.svg)](https://www.transifex.com/lmms/lmms/)

What is LMMS?
--------------

LMMS is a free cross-platform alternative to commercial programs like
FL Studio®, which allow you to produce music with your computer. This includes
the creation of melodies and beats, the synthesis and mixing of sounds, and
arranging of samples. You can have fun with your MIDI-keyboard and much more;
all in a user-friendly and modern interface.

[Homepage](https://lmms.io)<br>
[Downloads/Releases](https://github.com/LMMS/lmms/releases)<br>
[Developer Wiki](https://github.com/LMMS/lmms/wiki)<br>
[Artist & User Wiki/Documentation](https://lmms.io/documentation)<br>
[Sound Demos](https://lmms.io/showcase/)<br>
[LMMS Sharing Platform](https://lmms.io/lsp/) Share your songs!

Features
---------

* Song-Editor for composing songs
* A Beat+Bassline-Editor for creating beats and basslines
* An easy-to-use Piano-Roll for editing patterns and melodies
* An FX mixer with unlimited FX channels and arbitrary number of effects
* Many powerful instrument and effect-plugins out of the box
* Full user-defined track-based automation and computer-controlled automation sources
* Compatible with many standards such as SoundFont2, VST(i), LADSPA, GUS Patches, and full MIDI support
* MIDI file importing and exporting

Building
---------

See [Compiling LMMS](https://github.com/LMMS/lmms/wiki/Compiling) on our
wiki for information on how to build LMMS.


Join LMMS-development
----------------------

If you are interested in LMMS, its programming, artwork, testing, writing demo
songs, (and improving this README...) or something like that, you're welcome
to participate in the development of LMMS!

Information about what you can do and how can be found in the
[wiki](https://github.com/LMMS/lmms/wiki).

Before coding a new big feature, please _always_
[file an issue](https://github.com/LMMS/lmms/issues/new) for your idea and
suggestions about your feature and about the intended implementation on GitHub
or post to the LMMS developers mailinglist (lmms-devel@lists.sourceforge.net)
and wait for replies! Maybe there are different ideas, improvements, hints or
maybe your feature is not welcome/needed at the moment.
