; NOTE: Assertions have been autogenerated by utils/update_test_checks.py
; RUN: opt -O3 -S < %s                    | FileCheck %s --check-prefixes=ANY,OLDPM
; RUN: opt -passes='default<O3>' -S < %s  | FileCheck %s --check-prefixes=ANY,NEWPM

; This should become a single funnel shift through a combination
; of aggressive-instcombine, simplifycfg, and instcombine.
; https://bugs.llvm.org/show_bug.cgi?id=34924
; These are equivalent, but the value name with the new-pm shows a bug -
; this code should not have been converted to a speculative select with
; an intermediate transform.

define i32 @rotl(i32 %a, i32 %b) {
; OLDPM-LABEL: @rotl(
; OLDPM-NEXT:  entry:
; OLDPM-NEXT:    [[TMP0:%.*]] = tail call i32 @llvm.fshl.i32(i32 [[A:%.*]], i32 [[A]], i32 [[B:%.*]])
; OLDPM-NEXT:    ret i32 [[TMP0]]
;
; NEWPM-LABEL: @rotl(
; NEWPM-NEXT:  entry:
; NEWPM-NEXT:    [[SPEC_SELECT:%.*]] = tail call i32 @llvm.fshl.i32(i32 [[A:%.*]], i32 [[A]], i32 [[B:%.*]])
; NEWPM-NEXT:    ret i32 [[SPEC_SELECT]]
;
entry:
  %cmp = icmp eq i32 %b, 0
  br i1 %cmp, label %end, label %rotbb

rotbb:
  %sub = sub i32 32, %b
  %shr = lshr i32 %a, %sub
  %shl = shl i32 %a, %b
  %or = or i32 %shr, %shl
  br label %end

end:
  %cond = phi i32 [ %or, %rotbb ], [ %a, %entry ]
  ret i32 %cond
}

