; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc -mtriple=mips-mti-linux-gnu -mcpu=mips32r2 -mattr=+dsp < %s | FileCheck %s --check-prefix=DSP
; RUN: llc -mtriple=mips-mti-linux-gnu -mcpu=mips32r2 -mattr=+dsp,+micromips < %s | FileCheck %s --check-prefix=MMDSP

define i64 @n(i64 %a, i64 %b) {
; DSP-LABEL: n:
; DSP:       # %bb.0: # %entry
; DSP-NEXT:    addsc $3, $7, $5
; DSP-NEXT:    addwc $2, $6, $4
; DSP-NEXT:    jr $ra
; DSP-NEXT:    nop
;
; MMDSP-LABEL: n:
; MMDSP:       # %bb.0: # %entry
; MMDSP-NEXT:    addsc $3, $7, $5
; MMDSP-NEXT:    addwc $2, $6, $4
; MMDSP-NEXT:    jrc $ra
entry:
  %add = add i64 %b, %a
  ret i64 %add
}

define i128 @m(i128 zeroext %a, i128 zeroext %b) {
; DSP-LABEL: m:
; DSP:       # %bb.0: # %entry
; DSP-NEXT:    lw $1, 28($sp)
; DSP-NEXT:    lw $2, 24($sp)
; DSP-NEXT:    addsc $1, $1, $7
; DSP-NEXT:    addwc $6, $2, $6
; DSP-NEXT:    rddsp $2, 1
; DSP-NEXT:    ext $3, $2, 20, 1
; DSP-NEXT:    ins $3, $2, 6, 1
; DSP-NEXT:    ins $3, $zero, 20, 1
; DSP-NEXT:    lw $2, 20($sp)
; DSP-NEXT:    wrdsp $3, 1
; DSP-NEXT:    addwc $3, $2, $5
; DSP-NEXT:    rddsp $2, 1
; DSP-NEXT:    ext $5, $2, 20, 1
; DSP-NEXT:    lw $7, 16($sp)
; DSP-NEXT:    ins $5, $2, 6, 1
; DSP-NEXT:    ins $5, $zero, 20, 1
; DSP-NEXT:    wrdsp $5, 1
; DSP-NEXT:    addwc $2, $7, $4
; DSP-NEXT:    move $4, $6
; DSP-NEXT:    jr $ra
; DSP-NEXT:    move $5, $1
;
; MMDSP-LABEL: m:
; MMDSP:       # %bb.0: # %entry
; MMDSP-NEXT:    lw $1, 28($sp)
; MMDSP-NEXT:    lw $2, 24($sp)
; MMDSP-NEXT:    addsc $1, $1, $7
; MMDSP-NEXT:    addwc $6, $2, $6
; MMDSP-NEXT:    rddsp $2, 1
; MMDSP-NEXT:    ext $3, $2, 20, 1
; MMDSP-NEXT:    ins $3, $2, 6, 1
; MMDSP-NEXT:    ins $3, $zero, 20, 1
; MMDSP-NEXT:    lw $2, 20($sp)
; MMDSP-NEXT:    wrdsp $3, 1
; MMDSP-NEXT:    addwc $3, $2, $5
; MMDSP-NEXT:    rddsp $2, 1
; MMDSP-NEXT:    ext $5, $2, 20, 1
; MMDSP-NEXT:    lw $7, 16($sp)
; MMDSP-NEXT:    ins $5, $2, 6, 1
; MMDSP-NEXT:    ins $5, $zero, 20, 1
; MMDSP-NEXT:    wrdsp $5, 1
; MMDSP-NEXT:    addwc $2, $7, $4
; MMDSP-NEXT:    move $4, $6
; MMDSP-NEXT:    move $5, $1
; MMDSP-NEXT:    jrc $ra
entry:
  %add = add i128 %b, %a
  ret i128 %add
}
