/*
 * Copyright (c) 2007 - 2015 Joseph Gaeddert
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 */

//
// fftfilt_crcf_data_h13x256.c: autotest fftfilt data
//

#include <complex.h>

float fftfilt_crcf_data_h13x256_h[] = {
    0.078415364027,
   -0.038823145628,
   -0.051182097197,
   -0.126747608185,
   -0.044354891777,
    0.008586834371,
    0.093218648434,
    0.013351599872,
    0.104246592522,
   -0.147247779369,
   -0.015137273073,
   -0.079225271940,
    0.060841810703};

float complex fftfilt_crcf_data_h13x256_x[] = {
    0.085537636280 +  -0.046111658216*_Complex_I,
    0.225455975533 +  -0.212855386734*_Complex_I,
   -0.057062256336 +   0.128235316277*_Complex_I,
   -0.133161616325 +   0.161920166016*_Complex_I,
   -0.111347568035 +   0.016286674142*_Complex_I,
   -0.123166453838 +  -0.175749886036*_Complex_I,
   -0.127994334698 +  -0.038678660989*_Complex_I,
    0.001753777266 +   0.177034842968*_Complex_I,
   -0.060360968113 +   0.043074116111*_Complex_I,
   -0.019538708031 +   0.103789019585*_Complex_I,
   -0.014221027493 +  -0.063071894646*_Complex_I,
    0.068899226189 +  -0.026364141703*_Complex_I,
    0.115704405308 +  -0.004594086856*_Complex_I,
    0.007105919719 +  -0.147161698341*_Complex_I,
   -0.108864045143 +   0.057467007637*_Complex_I,
   -0.068811172247 +  -0.147289085388*_Complex_I,
   -0.230341863632 +  -0.117713248730*_Complex_I,
    0.212086534500 +   0.075316011906*_Complex_I,
    0.111719250679 +  -0.054894649982*_Complex_I,
   -0.058907771111 +   0.011760091782*_Complex_I,
    0.040262156725 +   0.204210424423*_Complex_I,
    0.056027442217 +  -0.155560147762*_Complex_I,
    0.086805480719 +  -0.004523682222*_Complex_I,
    0.036359512806 +   0.141219484806*_Complex_I,
   -0.220814013481 +  -0.062183243036*_Complex_I,
    0.153262519836 +  -0.046371394396*_Complex_I,
    0.026782101393 +  -0.145832955837*_Complex_I,
    0.065809303522 +   0.160269105434*_Complex_I,
   -0.350135111809 +  -0.025641095638*_Complex_I,
   -0.014225926995 +  -0.006095404923*_Complex_I,
    0.025032842159 +   0.079940289259*_Complex_I,
   -0.153848528862 +   0.047698283195*_Complex_I,
   -0.074249881506 +  -0.036540001631*_Complex_I,
   -0.058573323488 +  -0.038949799538*_Complex_I,
   -0.004152575880 +   0.284297037125*_Complex_I,
   -0.135746490955 +   0.021615330875*_Complex_I,
    0.016607114673 +  -0.020308291912*_Complex_I,
    0.152347302437 +   0.127957522869*_Complex_I,
   -0.010453918576 +   0.027730533481*_Complex_I,
    0.014759464562 +   0.026369267702*_Complex_I,
    0.082868421078 +   0.018653041124*_Complex_I,
    0.036655226350 +   0.110286545753*_Complex_I,
   -0.089152860641 +  -0.036632573605*_Complex_I,
    0.039231717587 +   0.077600806952*_Complex_I,
   -0.081070268154 +  -0.003452447802*_Complex_I,
    0.000562082976 +   0.017119739950*_Complex_I,
    0.144655835629 +   0.104714202881*_Complex_I,
    0.014049226046 +   0.166446399689*_Complex_I,
    0.088486814499 +  -0.014644494653*_Complex_I,
    0.057762199640 +  -0.093236494064*_Complex_I,
    0.047099858522 +  -0.028719729185*_Complex_I,
    0.106528282166 +   0.020991277695*_Complex_I,
    0.138301646709 +  -0.257377123833*_Complex_I,
    0.080518740416 +   0.154109323025*_Complex_I,
   -0.024190089107 +  -0.061511921883*_Complex_I,
    0.000458766706 +   0.001026612055*_Complex_I,
    0.099718827009 +  -0.065688782930*_Complex_I,
   -0.029233866930 +  -0.195329236984*_Complex_I,
   -0.066604834795 +   0.089790678024*_Complex_I,
   -0.068512433767 +   0.076835018396*_Complex_I,
    0.050179117918 +   0.095668357611*_Complex_I,
   -0.025827249885 +   0.161506593227*_Complex_I,
   -0.044248852134 +  -0.043011960387*_Complex_I,
   -0.065869921446 +  -0.124157130718*_Complex_I,
   -0.022857676446 +   0.034576061368*_Complex_I,
   -0.092982125282 +   0.081510609388*_Complex_I,
    0.197520732880 +   0.040147519112*_Complex_I,
    0.064278131723 +  -0.020518574119*_Complex_I,
   -0.044479858875 +  -0.093625146151*_Complex_I,
    0.006783248484 +   0.080368715525*_Complex_I,
    0.015499952435 +   0.014531745017*_Complex_I,
    0.097499859333 +   0.031322878599*_Complex_I,
    0.075692665577 +   0.103051352501*_Complex_I,
   -0.127897429466 +   0.147205972672*_Complex_I,
   -0.227601456642 +  -0.086447989941*_Complex_I,
    0.079460048676 +   0.009285532683*_Complex_I,
   -0.104196500778 +  -0.062360990047*_Complex_I,
   -0.003569463268 +  -0.159094834328*_Complex_I,
   -0.015271052718 +   0.053798562288*_Complex_I,
    0.038455364108 +   0.154173243046*_Complex_I,
    0.055872535706 +  -0.233663058281*_Complex_I,
   -0.008917537332 +   0.091611146927*_Complex_I,
    0.086029797792 +  -0.039757794142*_Complex_I,
    0.049558714032 +  -0.151712751389*_Complex_I,
    0.080167847872 +   0.034949752688*_Complex_I,
   -0.050086444616 +   0.050132060051*_Complex_I,
    0.083901208639 +   0.046979528666*_Complex_I,
   -0.132237958908 +   0.095516347885*_Complex_I,
    0.091105806828 +   0.120565533638*_Complex_I,
    0.043457311392 +  -0.141374385357*_Complex_I,
   -0.013054405153 +  -0.100194096565*_Complex_I,
   -0.159590744972 +   0.033074292541*_Complex_I,
    0.000640281662 +  -0.032389008999*_Complex_I,
    0.003084850125 +   0.021032336354*_Complex_I,
   -0.185569190979 +   0.124299430847*_Complex_I,
   -0.011914233118 +  -0.237578940392*_Complex_I,
   -0.171687960625 +  -0.104329741001*_Complex_I,
   -0.069582682848 +  -0.225686883926*_Complex_I,
   -0.113897264004 +   0.090501463413*_Complex_I,
    0.093735665083 +   0.154317796230*_Complex_I,
    0.014358232915 +  -0.103527617455*_Complex_I,
   -0.008946143836 +   0.126785087585*_Complex_I,
   -0.137021541595 +  -0.133091437817*_Complex_I,
   -0.093204009533 +  -0.052661812305*_Complex_I,
   -0.017306408286 +   0.105603075027*_Complex_I,
   -0.070221811533 +  -0.083750408888*_Complex_I,
    0.026400086284 +  -0.231271290779*_Complex_I,
   -0.067720073462 +   0.057201570272*_Complex_I,
   -0.048747465014 +  -0.065235435963*_Complex_I,
    0.043681365252 +  -0.104784011841*_Complex_I,
   -0.090612548590 +  -0.275935935974*_Complex_I,
   -0.003840988874 +   0.110235190392*_Complex_I,
    0.175717639923 +   0.039627754688*_Complex_I,
   -0.095855474472 +  -0.109507787228*_Complex_I,
   -0.103805732727 +   0.047046291828*_Complex_I,
    0.102693021297 +  -0.121691584587*_Complex_I,
    0.205679154396 +   0.105767965317*_Complex_I,
   -0.076863563061 +  -0.109635329247*_Complex_I,
    0.008887568116 +  -0.008115684241*_Complex_I,
    0.115569293499 +  -0.002244588919*_Complex_I,
    0.114743447304 +   0.110550260544*_Complex_I,
   -0.207589817047 +   0.076551246643*_Complex_I,
    0.001820044219 +   0.039755198359*_Complex_I,
    0.120840430260 +   0.207095527649*_Complex_I,
    0.060907727480 +   0.108076405525*_Complex_I,
   -0.068012183905 +  -0.004220475256*_Complex_I,
   -0.075779396296 +   0.192010104656*_Complex_I,
    0.176728832722 +  -0.014139008522*_Complex_I,
    0.003537797555 +  -0.008619928360*_Complex_I,
    0.105585181713 +  -0.044047874212*_Complex_I,
   -0.042796334624 +   0.104850161076*_Complex_I,
   -0.051997685432 +   0.156431221962*_Complex_I,
    0.020244561136 +   0.167572557926*_Complex_I,
    0.145088231564 +   0.027772811055*_Complex_I,
    0.037466460466 +   0.109766936302*_Complex_I,
   -0.098527204990 +  -0.032260373235*_Complex_I,
    0.009477450699 +  -0.035027536750*_Complex_I,
   -0.016112615168 +   0.085437601805*_Complex_I,
    0.143263375759 +   0.075950628519*_Complex_I,
    0.106226658821 +   0.103723526001*_Complex_I,
    0.000303745759 +  -0.010642482340*_Complex_I,
    0.108046162128 +  -0.032960096002*_Complex_I,
   -0.003579319268 +   0.113042652607*_Complex_I,
    0.004739668965 +  -0.090823930502*_Complex_I,
   -0.075828909874 +  -0.005588034540*_Complex_I,
   -0.085471099615 +  -0.016970762610*_Complex_I,
    0.011292902380 +  -0.025727859139*_Complex_I,
   -0.003472129628 +  -0.066497987509*_Complex_I,
    0.052674955130 +   0.053410953283*_Complex_I,
    0.171188580990 +   0.164189565182*_Complex_I,
   -0.031832432747 +  -0.106380403042*_Complex_I,
    0.104630780220 +  -0.005379130691*_Complex_I,
    0.146008169651 +  -0.016912537813*_Complex_I,
    0.001029302273 +   0.191088676453*_Complex_I,
   -0.189716017246 +  -0.017046442628*_Complex_I,
   -0.098682647943 +   0.001545182616*_Complex_I,
    0.017514893413 +  -0.091537868977*_Complex_I,
    0.046101492643 +  -0.087318551540*_Complex_I,
    0.006703664362 +  -0.168205010891*_Complex_I,
   -0.017618760467 +   0.027586823702*_Complex_I,
   -0.131682169437 +   0.043349444866*_Complex_I,
    0.050538945198 +   0.176133990288*_Complex_I,
   -0.053573626280 +  -0.126223480701*_Complex_I,
    0.196893954277 +  -0.158274137974*_Complex_I,
   -0.148222410679 +   0.046666064858*_Complex_I,
    0.095723485947 +   0.036118236184*_Complex_I,
   -0.072401177883 +  -0.081512874365*_Complex_I,
    0.057588219643 +   0.215086269379*_Complex_I,
    0.082906532288 +   0.065297931433*_Complex_I,
   -0.031125253439 +   0.089076888561*_Complex_I,
   -0.022213415802 +  -0.206439447403*_Complex_I,
   -0.128299164772 +   0.021574760973*_Complex_I,
    0.044257754087 +   0.042379784584*_Complex_I,
    0.201319956779 +  -0.054105019569*_Complex_I,
    0.028415796161 +  -0.068978685141*_Complex_I,
   -0.011957987398 +   0.176460993290*_Complex_I,
    0.090524059534 +  -0.115864157677*_Complex_I,
   -0.107446074486 +  -0.129327297211*_Complex_I,
    0.089880418777 +   0.060228496790*_Complex_I,
   -0.030561709404 +   0.026375296712*_Complex_I,
    0.098281121254 +  -0.215652251244*_Complex_I,
   -0.007009872049 +  -0.074216008186*_Complex_I,
   -0.004887212813 +   0.159088206291*_Complex_I,
    0.056175363064 +   0.101569080353*_Complex_I,
   -0.062076961994 +  -0.057750892639*_Complex_I,
   -0.126010406017 +   0.065122300386*_Complex_I,
   -0.049417442083 +   0.079578405619*_Complex_I,
    0.104471850395 +  -0.222810673714*_Complex_I,
    0.008511145413 +   0.109938132763*_Complex_I,
    0.037150239944 +   0.084586590528*_Complex_I,
    0.050007992983 +  -0.057158488035*_Complex_I,
   -0.035429692268 +   0.058791869879*_Complex_I,
   -0.155366706848 +   0.118630039692*_Complex_I,
    0.047825142741 +  -0.105882799625*_Complex_I,
   -0.109545922279 +  -0.002970626391*_Complex_I,
    0.130073928833 +   0.085777258873*_Complex_I,
   -0.039974737167 +   0.114924871922*_Complex_I,
    0.082493311167 +  -0.066850924492*_Complex_I,
    0.094225972891 +  -0.016298688948*_Complex_I,
   -0.196156990528 +  -0.039484533668*_Complex_I,
    0.221052432060 +   0.012097968161*_Complex_I,
    0.011275211722 +  -0.101457715034*_Complex_I,
    0.009068550915 +   0.102877616882*_Complex_I,
    0.233158087730 +   0.028579771519*_Complex_I,
    0.103334558010 +   0.013103367388*_Complex_I,
    0.113383591175 +   0.299872016907*_Complex_I,
    0.003663517535 +  -0.053204262257*_Complex_I,
    0.016009953618 +  -0.204974889755*_Complex_I,
   -0.129484927654 +  -0.081961399317*_Complex_I,
    0.043841245770 +  -0.172690594196*_Complex_I,
    0.016576626897 +   0.178835308552*_Complex_I,
    0.021964907646 +  -0.018969631195*_Complex_I,
    0.040968599916 +   0.013126873970*_Complex_I,
   -0.139588427544 +   0.084010922909*_Complex_I,
   -0.119654500484 +   0.023274496198*_Complex_I,
   -0.069549763203 +   0.014241448045*_Complex_I,
    0.061426883936 +   0.037087076902*_Complex_I,
   -0.101361310482 +  -0.062185329199*_Complex_I,
   -0.112329518795 +  -0.115670502186*_Complex_I,
    0.134469640255 +   0.146243238449*_Complex_I,
    0.069860440493 +  -0.059987205267*_Complex_I,
    0.002678702772 +   0.026742336154*_Complex_I,
   -0.100598180294 +   0.019916568696*_Complex_I,
    0.112527644634 +   0.158179092407*_Complex_I,
   -0.044148188829 +   0.048926886916*_Complex_I,
   -0.036606773734 +  -0.143591856956*_Complex_I,
    0.058808875084 +   0.019581055641*_Complex_I,
    0.036360570788 +   0.014478833973*_Complex_I,
    0.175481355190 +   0.010096323490*_Complex_I,
    0.108694136143 +  -0.070673483610*_Complex_I,
    0.090956181288 +  -0.025260141492*_Complex_I,
   -0.051956391335 +  -0.102067518234*_Complex_I,
   -0.136262392998 +  -0.047263675928*_Complex_I,
   -0.003427351639 +  -0.120171773434*_Complex_I,
   -0.056164652109 +   0.211695027351*_Complex_I,
    0.122092783451 +   0.066175770760*_Complex_I,
    0.058047491312 +   0.006997314841*_Complex_I,
   -0.052954304218 +  -0.022754417360*_Complex_I,
    0.142856597900 +   0.108723735809*_Complex_I,
   -0.034428742528 +  -0.054634892941*_Complex_I,
   -0.060924202204 +   0.031046575308*_Complex_I,
   -0.200955986977 +  -0.117396569252*_Complex_I,
   -0.088245415688 +   0.019958937168*_Complex_I,
   -0.020239216089 +   0.041008698940*_Complex_I,
    0.016120427847 +  -0.252910399437*_Complex_I,
   -0.005489441007 +  -0.005252978206*_Complex_I,
    0.146177339554 +  -0.124855351448*_Complex_I,
    0.008751311898 +   0.021546928585*_Complex_I,
   -0.045790722966 +  -0.055281382799*_Complex_I,
    0.020690375566 +   0.076892906427*_Complex_I,
    0.021331049502 +  -0.009237347543*_Complex_I,
    0.055180394650 +  -0.023450747132*_Complex_I,
   -0.200542330742 +  -0.096801882982*_Complex_I,
    0.010742266476 +   0.088201242685*_Complex_I,
    0.072365719080 +   0.038520815969*_Complex_I,
    0.174543678761 +  -0.139873552322*_Complex_I};

float complex fftfilt_crcf_data_h13x256_y[] = {
    0.006707464887 +  -0.003615862465*_Complex_I,
    0.014358372283 +  -0.014900933014*_Complex_I,
   -0.017605463388 +   0.020679426057*_Complex_I,
   -0.030607580793 +   0.024457457884*_Complex_I,
   -0.033011059558 +   0.017451711642*_Complex_I,
   -0.000552862047 +  -0.029909500040*_Complex_I,
    0.029762551415 +  -0.029380501742*_Complex_I,
    0.053098771667 +  -0.004223742190*_Complex_I,
    0.027764068736 +   0.025733123329*_Complex_I,
    0.019184165051 +   0.011649528617*_Complex_I,
   -0.045468748657 +   0.015676561918*_Complex_I,
   -0.015208315362 +  -0.029868068751*_Complex_I,
   -0.005074731196 +  -0.025633738248*_Complex_I,
    0.016953787198 +  -0.036545469115*_Complex_I,
   -0.015051143400 +   0.040438104378*_Complex_I,
   -0.000389921114 +   0.040583727841*_Complex_I,
   -0.018476482937 +   0.001605043113*_Complex_I,
    0.059276110787 +   0.008087486852*_Complex_I,
    0.032014951529 +  -0.026016763072*_Complex_I,
    0.028169341465 +   0.019691597843*_Complex_I,
   -0.027575406956 +   0.014924607884*_Complex_I,
   -0.044969293038 +  -0.034038723353*_Complex_I,
   -0.035957879305 +   0.009864897267*_Complex_I,
    0.015551833890 +  -0.025044401657*_Complex_I,
   -0.025072135741 +   0.016447641694*_Complex_I,
    0.067713809538 +   0.015047662589*_Complex_I,
   -0.014827314512 +  -0.006159133526*_Complex_I,
    0.017417617315 +   0.018940542198*_Complex_I,
   -0.051497901101 +   0.013839514218*_Complex_I,
    0.006425931128 +  -0.012107460374*_Complex_I,
    0.003778314165 +   0.004734451148*_Complex_I,
    0.024107174779 +  -0.007035831300*_Complex_I,
   -0.010365520171 +  -0.022195343173*_Complex_I,
    0.051580386373 +  -0.008087616648*_Complex_I,
   -0.021776665000 +  -0.003115102667*_Complex_I,
    0.023266451034 +   0.047344342773*_Complex_I,
   -0.053848275959 +  -0.026819242730*_Complex_I,
    0.063009256294 +  -0.009944000506*_Complex_I,
    0.006746963810 +  -0.032158195839*_Complex_I,
    0.003429372021 +  -0.000544080428*_Complex_I,
   -0.021562011789 +  -0.003250402475*_Complex_I,
   -0.014790441461 +  -0.003085695467*_Complex_I,
    0.010008967449 +   0.023823269718*_Complex_I,
   -0.008293948136 +  -0.022998494726*_Complex_I,
    0.011452965518 +  -0.020435253906*_Complex_I,
    0.025061888640 +  -0.008646415119*_Complex_I,
    0.009417229303 +   0.002491707097*_Complex_I,
   -0.001052856194 +   0.014974027706*_Complex_I,
   -0.009405958690 +  -0.029993691331*_Complex_I,
   -0.014721142637 +  -0.008638802539*_Complex_I,
   -0.036054668791 +  -0.043505364136*_Complex_I,
    0.002937162197 +   0.016396266668*_Complex_I,
   -0.004075444532 +  -0.014475666608*_Complex_I,
    0.011656769213 +   0.056296896866*_Complex_I,
   -0.011068622206 +   0.001107236820*_Complex_I,
   -0.029464500491 +   0.023806584861*_Complex_I,
   -0.001234548257 +  -0.043088390782*_Complex_I,
   -0.013592614491 +  -0.029832033410*_Complex_I,
    0.009582371751 +   0.002336669503*_Complex_I,
   -0.007665271794 +   0.050333730164*_Complex_I,
    0.006935919041 +   0.000935532598*_Complex_I,
   -0.003952523598 +   0.051259768228*_Complex_I,
   -0.006392118058 +  -0.064666858821*_Complex_I,
   -0.009497007771 +  -0.021680677945*_Complex_I,
    0.009619420930 +  -0.042495568141*_Complex_I,
   -0.014045975317 +   0.022418973657*_Complex_I,
    0.028464744316 +   0.062481882056*_Complex_I,
    0.001067687053 +   0.012760185564*_Complex_I,
    0.016381591820 +  -0.014605527050*_Complex_I,
   -0.034415502412 +  -0.026979376550*_Complex_I,
   -0.017681907434 +  -0.024441169492*_Complex_I,
   -0.005897651761 +   0.007001263045*_Complex_I,
    0.033278467741 +   0.020304401627*_Complex_I,
   -0.015372239067 +   0.016871371540*_Complex_I,
    0.004123217473 +  -0.031815284855*_Complex_I,
   -0.015306721649 +  -0.031111950511*_Complex_I,
    0.004503865148 +  -0.033058697462*_Complex_I,
    0.029142795487 +   0.022150281542*_Complex_I,
    0.019772837268 +   0.022699222634*_Complex_I,
    0.015820827834 +   0.046069967481*_Complex_I,
   -0.023442270401 +  -0.016297278519*_Complex_I,
   -0.026038769435 +   0.011214015864*_Complex_I,
   -0.021468228990 +  -0.057542563457*_Complex_I,
    0.034028743864 +  -0.002254875536*_Complex_I,
   -0.006908951528 +   0.001680565517*_Complex_I,
    0.007793730477 +   0.032660744962*_Complex_I,
   -0.019663600279 +   0.025988218786*_Complex_I,
   -0.003368100468 +   0.026542388675*_Complex_I,
    0.013438824633 +  -0.047413054472*_Complex_I,
   -0.004063114270 +  -0.015525778855*_Complex_I,
    0.018830244631 +  -0.044104705319*_Complex_I,
   -0.032245213510 +   0.016288658540*_Complex_I,
    0.007245432060 +   0.024854569789*_Complex_I,
   -0.027446572547 +   0.041850280938*_Complex_I,
    0.029419010658 +   0.028727610740*_Complex_I,
   -0.010452476889 +  -0.044041749123*_Complex_I,
    0.030615778213 +  -0.021544600594*_Complex_I,
   -0.006420674173 +  -0.051315896975*_Complex_I,
    0.016696184929 +   0.047238754510*_Complex_I,
    0.005689845758 +   0.063096109099*_Complex_I,
    0.028255169043 +   0.036125238544*_Complex_I,
    0.012724807027 +  -0.010983186848*_Complex_I,
   -0.042681639075 +  -0.046834116871*_Complex_I,
   -0.000989952691 +  -0.059638193499*_Complex_I,
   -0.014509988842 +   0.030996292286*_Complex_I,
    0.058136967808 +   0.004841843998*_Complex_I,
    0.016711224472 +   0.056418115581*_Complex_I,
    0.042240824058 +   0.015983263464*_Complex_I,
   -0.022083897958 +  -0.024086928202*_Complex_I,
   -0.001789727311 +   0.023860817657*_Complex_I,
   -0.029894590649 +  -0.040496551187*_Complex_I,
    0.018773801669 +   0.051847548401*_Complex_I,
    0.031709831384 +   0.011373889090*_Complex_I,
   -0.004023229281 +   0.020313196377*_Complex_I,
   -0.001577893158 +  -0.019338873041*_Complex_I,
   -0.016653147805 +   0.001029965867*_Complex_I,
    0.022914141726 +  -0.002104645021*_Complex_I,
    0.004474041805 +   0.010394883929*_Complex_I,
   -0.007920863082 +  -0.015181966976*_Complex_I,
   -0.013430955196 +   0.050824400632*_Complex_I,
    0.008429368466 +   0.016663178667*_Complex_I,
   -0.040384189162 +  -0.005524017450*_Complex_I,
    0.002595592227 +  -0.002667437393*_Complex_I,
    0.009304373200 +  -0.026400357126*_Complex_I,
    0.048184754654 +   0.020873671678*_Complex_I,
   -0.030489638011 +  -0.058480052355*_Complex_I,
   -0.016679991101 +   0.018809245099*_Complex_I,
   -0.008746544102 +  -0.035440693217*_Complex_I,
    0.015062452407 +   0.019391877795*_Complex_I,
   -0.022136074513 +  -0.020072882619*_Complex_I,
    0.000436956008 +   0.007335145893*_Complex_I,
   -0.008872275506 +   0.020549897080*_Complex_I,
   -0.002241620183 +   0.006218861440*_Complex_I,
   -0.001175415969 +  -0.040479462629*_Complex_I,
    0.000083899519 +  -0.021882526156*_Complex_I,
    0.025794092443 +  -0.065356864610*_Complex_I,
   -0.035076022000 +  -0.002349257653*_Complex_I,
   -0.003341037071 +  -0.006590144581*_Complex_I,
   -0.014034503634 +   0.051948837186*_Complex_I,
    0.030633439581 +   0.013809324577*_Complex_I,
   -0.002962173263 +  -0.011885141436*_Complex_I,
   -0.000277152583 +  -0.057872949989*_Complex_I,
   -0.041128587589 +  -0.009986479197*_Complex_I,
   -0.032666587947 +  -0.028631352014*_Complex_I,
   -0.000937363608 +   0.018495486941*_Complex_I,
    0.007753441209 +   0.008806508191*_Complex_I,
    0.037266455064 +   0.010636476395*_Complex_I,
    0.006587066115 +  -0.001705926814*_Complex_I,
    0.003108159036 +  -0.006628853141*_Complex_I,
    0.010939472752 +   0.006955405461*_Complex_I,
   -0.035625089431 +   0.003442599966*_Complex_I,
   -0.008902105887 +  -0.028853630235*_Complex_I,
   -0.032226114328 +  -0.009004482236*_Complex_I,
   -0.005180831436 +   0.005500644217*_Complex_I,
   -0.013588249735 +   0.016986170136*_Complex_I,
   -0.001619772072 +   0.000519931731*_Complex_I,
    0.016514152427 +  -0.020852436461*_Complex_I,
    0.046615752684 +  -0.000490623097*_Complex_I,
    0.005417795160 +  -0.036933916369*_Complex_I,
    0.007190900949 +   0.046477922845*_Complex_I,
   -0.045185383594 +   0.017921427684*_Complex_I,
   -0.014537612941 +   0.075949416617*_Complex_I,
   -0.029141623074 +  -0.059957316195*_Complex_I,
    0.049424271568 +  -0.033258736817*_Complex_I,
    0.012029563939 +  -0.050271746506*_Complex_I,
    0.023861869121 +   0.035334845394*_Complex_I,
   -0.046542548410 +   0.016947426572*_Complex_I,
    0.004060617093 +   0.071512899954*_Complex_I,
   -0.014037223962 +  -0.012127913597*_Complex_I,
    0.039889046850 +   0.005706366222*_Complex_I,
   -0.028460519816 +  -0.096256824265*_Complex_I,
    0.022664509438 +  -0.011714722989*_Complex_I,
   -0.050769105818 +   0.012359859521*_Complex_I,
    0.066087653016 +   0.054750882096*_Complex_I,
   -0.020633352616 +   0.001005601365*_Complex_I,
    0.024688652114 +   0.040909798080*_Complex_I,
   -0.040302384002 +  -0.048949559759*_Complex_I,
   -0.040499641156 +   0.001157352899*_Complex_I,
    0.003027817515 +  -0.057483585836*_Complex_I,
   -0.004425501836 +   0.047349196316*_Complex_I,
    0.050482303632 +  -0.003841475384*_Complex_I,
    0.006892893469 +   0.023406378381*_Complex_I,
   -0.016436659880 +  -0.003310696286*_Complex_I,
   -0.033973819400 +   0.045991336264*_Complex_I,
   -0.006077224480 +  -0.023680985792*_Complex_I,
   -0.024572808359 +  -0.010230339465*_Complex_I,
    0.032481213736 +  -0.024751506834*_Complex_I,
   -0.000140080804 +  -0.013756951783*_Complex_I,
    0.045204061251 +  -0.001863065274*_Complex_I,
   -0.014671178560 +   0.022868286772*_Complex_I,
   -0.008200142546 +   0.040201740584*_Complex_I,
   -0.028297364362 +   0.011407262105*_Complex_I,
   -0.031979428685 +  -0.029902785287*_Complex_I,
    0.007876129419 +  -0.034552491520*_Complex_I,
    0.011879957596 +   0.002102523326*_Complex_I,
    0.065685674192 +  -0.021696600034*_Complex_I,
   -0.004436318677 +   0.044689761692*_Complex_I,
    0.006444035464 +  -0.009625205044*_Complex_I,
   -0.031610428157 +  -0.001954799840*_Complex_I,
   -0.028459000697 +  -0.034725990869*_Complex_I,
   -0.011174251949 +   0.010299896743*_Complex_I,
    0.023757183405 +  -0.012151501352*_Complex_I,
   -0.001899448573 +   0.033748924229*_Complex_I,
    0.045121542184 +   0.003981235350*_Complex_I,
   -0.039350108228 +   0.019225662049*_Complex_I,
    0.000272360769 +  -0.022187283938*_Complex_I,
   -0.039963184290 +  -0.025512380416*_Complex_I,
   -0.048539833099 +  -0.045287358543*_Complex_I,
    0.014614456311 +  -0.006244097705*_Complex_I,
   -0.005955795663 +  -0.016811959796*_Complex_I,
    0.034965200850 +   0.085058210904*_Complex_I,
    0.019869783149 +   0.033565877203*_Complex_I,
   -0.007450313153 +   0.019794672596*_Complex_I,
   -0.024234527340 +  -0.013904685967*_Complex_I,
   -0.056857838231 +  -0.065401336188*_Complex_I,
    0.008081702581 +  -0.037938012149*_Complex_I,
    0.013228639879 +   0.003618896346*_Complex_I,
    0.047207180558 +   0.006639688435*_Complex_I,
    0.005206139690 +   0.048614164213*_Complex_I,
    0.012317627070 +  -0.009658873466*_Complex_I,
   -0.008051197208 +   0.015338520918*_Complex_I,
   -0.017767221557 +  -0.001246156194*_Complex_I,
   -0.012973491018 +  -0.004457537375*_Complex_I,
   -0.001247711756 +  -0.000324872382*_Complex_I,
    0.015217577217 +  -0.018849976281*_Complex_I,
   -0.000220920310 +  -0.022284388072*_Complex_I,
    0.007337925412 +  -0.022911190749*_Complex_I,
    0.026359365671 +   0.027517236286*_Complex_I,
    0.008511664801 +  -0.000024345933*_Complex_I,
   -0.006523939632 +   0.027431135887*_Complex_I,
   -0.045640085613 +  -0.016594833325*_Complex_I,
   -0.011370492419 +   0.008910655275*_Complex_I,
   -0.045188661133 +  -0.014169350102*_Complex_I,
    0.006126649841 +  -0.018848731487*_Complex_I,
    0.020184591301 +   0.049393686574*_Complex_I,
    0.050790767045 +   0.013516083838*_Complex_I,
    0.030911878104 +   0.013274684518*_Complex_I,
   -0.032128201429 +  -0.056563309721*_Complex_I,
   -0.024604150985 +  -0.007862317966*_Complex_I,
   -0.053074476432 +  -0.026948064488*_Complex_I,
   -0.016714258122 +   0.036960212668*_Complex_I,
    0.003641941365 +  -0.017652191591*_Complex_I,
    0.014976615622 +   0.055005028639*_Complex_I,
    0.047122774118 +  -0.019075872589*_Complex_I,
    0.027958265929 +  -0.005155130760*_Complex_I,
    0.006577988759 +  -0.021876641490*_Complex_I,
    0.018186494518 +   0.020647216102*_Complex_I,
   -0.047150707407 +   0.008796453305*_Complex_I,
   -0.018231362190 +   0.025611832961*_Complex_I,
   -0.044254892960 +  -0.000932158388*_Complex_I,
    0.029538101318 +   0.008693714282*_Complex_I,
    0.025472319724 +  -0.006973878349*_Complex_I,
    0.012287778194 +  -0.046541397503*_Complex_I,
   -0.003318140133 +   0.036850102200*_Complex_I,
    0.015644777552 +  -0.006720827246*_Complex_I,
    0.011761450619 +   0.045924263037*_Complex_I};

