/*Copyright (c) 2016 PM Larsen

Permission is hereby granted, free of charge, to any person obtaining a copy of this software and associated documentation files (the "Software"), to deal in the Software without restriction, including without limitation the rights to use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies of the Software, and to permit persons to whom the Software is furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
*/

#include "ptm_graph_data.h"


namespace ptm {

int8_t automorphisms[65][17] = {
        {  0,  1,  2,  3,  4,  5,  6,  7,  8,  9, 10, 11, 12, 13, 14, 15, 16},
        {  0,  1,  2,  3,  4,  5,  6,  7,  8,  9, 10, 11, 12, -1, -1, -1, -1},
        {  0,  1, 11,  7,  4,  8, 10, 12,  6,  5,  9,  3,  2, -1, -1, -1, -1},
        {  0,  5,  4,  6,  2,  1,  3, 10,  9,  8,  7, 12, 11, -1, -1, -1, -1},
        {  0,  7,  1, 11, 10,  4,  8,  2, 12,  3,  5,  9,  6, -1, -1, -1, -1},
        {  0, 11,  7,  1,  8, 10,  4,  6,  2,  9,  3,  5, 12, -1, -1, -1, -1},
        {  0,  1,  2,  3,  4,  5,  6,  7,  8,  9, 10, 11, 12, -1, -1, -1, -1},
        {  0,  6,  5,  9, 10,  2,  1, 11, 12,  3,  4,  7,  8, -1, -1, -1, -1},
        {  0,  1,  2,  3,  4,  5,  6,  7,  8,  9, 10, 11, 12, -1, -1, -1, -1},
        {  0,  1,  3,  4,  7,  8,  6, 12, 11,  5,  9, 10,  2, -1, -1, -1, -1},
        {  0,  1,  4,  7, 12, 11,  6,  2, 10,  8,  5,  9,  3, -1, -1, -1, -1},
        {  0,  8,  3,  6, 12,  7,  2, 10, 11,  4,  5,  1,  9, -1, -1, -1, -1},
        {  0,  9,  6,  4,  8,  5,  7, 11,  1,  3,  2, 10, 12, -1, -1, -1, -1},
        {  0, 10,  6,  3,  5,  9,  4,  8,  1,  2, 12, 11,  7, -1, -1, -1, -1},
        {  0, 10,  7,  6,  3,  2,  4,  5,  9, 12, 11,  1,  8, -1, -1, -1, -1},
        {  0, 11,  4,  6,  2, 12,  3,  9, 10,  7,  8,  1,  5, -1, -1, -1, -1},
        {  0, 11,  6,  2,  9, 10,  3,  5,  1, 12,  7,  8,  4, -1, -1, -1, -1},
        {  0, 12,  4,  3,  9,  2,  5,  1, 10,  6,  7, 11,  8, -1, -1, -1, -1},
        {  0,  1,  2,  3,  4,  5,  6,  7,  8,  9, 10, 11, 12, -1, -1, -1, -1},
        {  0, 12,  8,  7,  6, 11,  4,  3,  2, 10,  9,  5,  1, -1, -1, -1, -1},
        {  0,  1,  2,  3,  4,  5,  6,  7,  8,  9, 10, 11, 12, -1, -1, -1, -1},
        {  0,  1,  7, 11, 12, 10,  6,  2,  9,  8,  5,  3,  4, -1, -1, -1, -1},
        {  0,  1,  2,  3,  4,  5,  6,  7,  8,  9, 10, 11, 12, -1, -1, -1, -1},
        {  0,  1,  3,  7,  8,  4,  6, 11, 10,  5,  9, 12,  2, -1, -1, -1, -1},
        {  0,  8,  3,  6, 11,  7,  2, 12, 10,  4,  1,  9,  5, -1, -1, -1, -1},
        {  0,  9,  3,  4,  1,  5,  7,  8, 10,  2, 12, 11,  6, -1, -1, -1, -1},
        {  0,  9,  6,  3,  5,  2,  7,  4,  1, 12, 10,  8, 11, -1, -1, -1, -1},
        {  0, 10,  4,  7, 11,  8,  3,  6, 12,  1,  9,  2,  5, -1, -1, -1, -1},
        {  0, 10,  6,  2,  9, 12,  3,  5,  1, 11,  8,  4,  7, -1, -1, -1, -1},
        {  0, 10,  7,  6, 12, 11,  3,  2,  9,  8,  1,  5,  4, -1, -1, -1, -1},
        {  0, 11,  4,  3,  6,  7,  5,  2, 12,  8, 10,  9,  1, -1, -1, -1, -1},
        {  0, 12,  7,  3,  2,  6,  4,  5,  9, 11, 10,  1,  8, -1, -1, -1, -1},
        {  0,  1,  2,  3,  4,  5,  6,  7,  8,  9, 10, 11, 12, 13, 14, -1, -1},
        {  0,  2,  6, 13, 14,  7,  1,  8,  5,  4,  3, 11, 12, 10,  9, -1, -1},
        {  0,  6,  1, 10,  9,  8,  2,  5,  7, 14, 13, 11, 12,  3,  4, -1, -1},
        {  0,  8,  1, 14, 13,  5,  6,  2,  7, 12, 11,  3,  4,  9, 10, -1, -1},
        {  0,  1,  2,  3,  4,  5,  6,  7,  8,  9, 10, 11, 12, 13, 14, -1, -1},
        {  0, 12, 14,  4,  3,  9, 10, 11, 13,  5,  6,  7,  1,  8,  2, -1, -1},
        {  0,  1,  2,  3,  4,  5,  6,  7,  8,  9, 10, 11, 12, 13, 14, -1, -1},
        {  0, 13,  9,  4,  3, 11, 12, 14, 10,  2,  8,  5,  6,  1,  7, -1, -1},
        {  0,  1,  2,  3,  4,  5,  6,  7,  8,  9, 10, 11, 12, 13, 14, -1, -1},
        {  0,  6,  8, 11, 12,  7,  1,  5,  2, 10,  9,  3,  4, 14, 13, -1, -1},
        {  0,  1,  2,  3,  4,  5,  6,  7,  8,  9, 10, 11, 12, 13, 14, -1, -1},
        {  0, 12, 14,  4,  3,  9, 10, 11, 13,  5,  6,  7,  1,  8,  2, -1, -1},
        {  0,  1,  2,  3,  4,  5,  6,  7,  8,  9, 10, 11, 12, 13, 14, -1, -1},
        {  0, 13,  9,  4,  3, 11, 12, 14, 10,  2,  8,  5,  6,  1,  7, -1, -1},
        {  0,  1,  2,  3,  4,  5,  6,  7,  8,  9, 10, 11, 12, 13, 14, -1, -1},
        {  0,  3, 13, 14,  5,  9,  2, 10,  7,  8,  4, 11, 12,  1,  6, -1, -1},
        {  0, 13,  6,  1, 10,  4, 14,  8,  9,  5,  7, 11, 12,  2,  3, -1, -1},
        {  0,  1,  2,  3,  4,  5,  6,  7,  8,  9, 10, 11, 12, 13, 14, -1, -1},
        {  0,  9, 13,  3,  4, 12, 11, 10, 14,  8,  2,  1,  7,  5,  6, -1, -1},
        {  0,  1,  2,  3,  4,  5,  6,  7,  8,  9, 10, 11, 12, 13, 14, -1, -1},
        {  0, 13, 10, 11, 12,  5,  6, 14,  9,  1,  7,  2,  8,  4,  3, -1, -1},
        {  0,  1,  2,  3,  4,  5,  6,  7,  8,  9, 10, 11, 12, 13, 14, 15, 16},
        {  0,  2,  1,  4,  3,  9, 10,  8,  7,  5,  6, 14, 15, 16, 11, 12, 13},
        {  0,  1,  2,  3,  4,  5,  6,  7,  8,  9, 10, 11, 12, 13, 14, 15, 16},
        {  0,  1,  3,  4,  2,  6,  7,  5, 13, 12, 11, 16, 14, 15,  9,  8, 10},
        {  0,  2,  4,  3,  1, 10,  8,  9, 16, 15, 14, 13, 11, 12,  5,  7,  6},
        {  0,  4,  1,  3,  2, 14, 16, 15,  6,  7,  5, 12, 13, 11, 10,  9,  8},
        {  0,  1,  2,  3,  4,  5,  6,  7,  8,  9, 10, 11, 12, 13, 14, 15, 16},
        {  0,  1,  3,  4,  2,  6,  7,  5, 13, 12, 11, 15, 16, 14,  8, 10,  9},
        {  0,  2,  4,  3,  1, 10,  8,  9, 15, 14, 16, 13, 11, 12,  7,  6,  5},
        {  0,  4,  2,  1,  3, 14, 16, 15,  9, 10,  8,  5,  7,  6, 11, 12, 13},
        {  0,  1,  2,  3,  4,  5,  6,  7,  8,  9, 10, 11, 12, 13, 14, 15, 16},
        {  0,  3,  4,  1,  2, 13, 12, 11, 16, 15, 14,  7,  6,  5, 10,  9,  8},
};

graph_t graphs_sc[NUM_SC_GRAPHS] = {

{0,
0,
0,
1,
{0, 0, 0, 0, 0, 0, 0},
{{1,3,4},{1,3,5},{0,3,4},{0,3,5},{1,2,5},{1,2,4},{0,2,4},{0,2,5}}},

};

graph_t graphs_ico[NUM_ICO_GRAPHS] = {

{0,
0,
0,
1,
{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
{{0,5,7},{0,5,9},{2,5,7},{1,4,6},{1,6,10},{5,9,10},{6,9,10},{2,5,10},{1,2,10},{0,7,11},{3,6,9},{0,3,9},{3,4,6},{0,3,11},{3,4,11},{1,2,8},{2,7,8},{1,4,8},{4,8,11},{7,8,11}}},

};

graph_t graphs_fcc[NUM_FCC_GRAPHS] = {

{0,
0,
0,
1,
{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
{{0,1,2},{3,4,5},{5,6,10},{3,7,8},{1,6,8},{0,10,11},{2,7,9},{4,9,11},{0,6,10},{0,1,6},{1,7,8},{1,2,7},{3,6,8},{3,5,6},{4,10,11},{4,5,10},{4,7,9},{3,4,7},{2,9,11},{0,2,11}}},

{1,
0,
0,
1,
{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
{{0,1,2},{3,4,5},{5,6,10},{3,7,8},{1,6,8},{0,10,11},{2,7,9},{4,9,11},{0,6,10},{0,1,6},{1,7,8},{1,2,7},{3,6,8},{3,5,6},{4,10,11},{4,5,10},{4,7,9},{3,4,7},{0,9,11},{0,2,9}}},

{2,
0,
0,
1,
{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
{{0,1,2},{3,4,5},{5,6,10},{3,7,8},{1,6,8},{0,10,11},{2,7,9},{4,9,11},{0,6,10},{0,1,6},{1,7,8},{1,2,7},{3,6,8},{3,5,6},{4,10,11},{4,5,10},{3,7,9},{3,4,9},{2,9,11},{0,2,11}}},

{3,
0,
0,
1,
{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
{{0,1,2},{3,4,5},{5,6,10},{3,7,8},{1,6,8},{0,10,11},{2,7,9},{4,9,11},{0,6,10},{0,1,6},{1,7,8},{1,2,7},{3,6,8},{3,5,6},{4,10,11},{4,5,10},{3,7,9},{3,4,9},{0,9,11},{0,2,9}}},

{4,
0,
0,
1,
{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
{{0,1,2},{3,4,5},{5,6,10},{3,7,8},{1,6,8},{0,10,11},{2,7,9},{4,9,11},{0,6,10},{0,1,6},{1,7,8},{1,2,7},{3,6,8},{3,5,6},{5,10,11},{4,5,11},{4,7,9},{3,4,7},{2,9,11},{0,2,11}}},

{5,
0,
0,
1,
{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
{{0,1,2},{3,4,5},{5,6,10},{3,7,8},{1,6,8},{0,10,11},{2,7,9},{4,9,11},{0,6,10},{0,1,6},{1,7,8},{1,2,7},{3,6,8},{3,5,6},{5,10,11},{4,5,11},{3,7,9},{3,4,9},{0,9,11},{0,2,9}}},

{6,
0,
1,
5,
{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
{{0,1,2},{3,4,5},{5,6,10},{3,7,8},{1,6,8},{0,10,11},{2,7,9},{4,9,11},{0,6,10},{0,1,6},{1,7,8},{1,2,7},{5,6,8},{3,5,8},{4,10,11},{4,5,10},{3,7,9},{3,4,9},{2,9,11},{0,2,11}}},

{7,
0,
0,
1,
{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
{{0,1,2},{3,4,5},{5,6,10},{3,7,8},{1,6,8},{0,10,11},{2,7,9},{4,9,11},{0,6,10},{0,1,6},{1,7,8},{1,2,7},{5,6,8},{3,5,8},{5,10,11},{4,5,11},{4,7,9},{3,4,7},{0,9,11},{0,2,9}}},

};

graph_t graphs_hcp[NUM_HCP_GRAPHS] = {

{0,
0,
0,
1,
{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
{{1,2,5},{1,5,11},{3,6,7},{2,3,4},{9,10,11},{6,7,10},{0,4,8},{0,8,9},{3,5,6},{2,3,5},{6,10,11},{5,6,11},{1,9,11},{1,8,9},{1,4,8},{1,2,4},{7,9,10},{0,7,9},{3,4,7},{0,4,7}}},

{1,
0,
0,
1,
{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
{{1,2,5},{1,5,11},{3,6,7},{2,3,4},{9,10,11},{6,7,10},{0,4,8},{0,8,9},{3,5,6},{2,3,5},{6,10,11},{5,6,11},{1,9,11},{1,8,9},{1,4,8},{1,2,4},{7,9,10},{0,7,9},{0,3,7},{0,3,4}}},

{2,
0,
6,
2,
{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
{{1,2,5},{1,5,11},{3,6,7},{2,3,4},{9,10,11},{6,7,10},{0,4,8},{0,8,9},{3,5,6},{2,3,5},{6,10,11},{5,6,11},{1,9,11},{1,8,9},{1,4,8},{1,2,4},{0,9,10},{0,7,10},{3,4,7},{0,4,7}}},

{3,
0,
0,
1,
{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
{{1,2,5},{1,5,11},{3,6,7},{2,3,4},{9,10,11},{6,7,10},{0,4,8},{0,8,9},{3,5,6},{2,3,5},{6,10,11},{5,6,11},{1,9,11},{1,8,9},{1,4,8},{1,2,4},{0,9,10},{0,7,10},{0,3,7},{0,3,4}}},

{4,
0,
0,
1,
{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
{{1,2,5},{1,5,11},{3,6,7},{2,3,4},{9,10,11},{6,7,10},{0,4,8},{0,8,9},{3,5,6},{2,3,5},{6,10,11},{5,6,11},{1,9,11},{1,8,9},{2,4,8},{1,2,8},{7,9,10},{0,7,9},{0,3,7},{0,3,4}}},

{5,
0,
8,
10,
{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
{{1,2,5},{1,5,11},{3,6,7},{2,3,4},{9,10,11},{6,7,10},{0,4,8},{0,8,9},{3,5,6},{2,3,5},{6,10,11},{5,6,11},{1,9,11},{1,8,9},{2,4,8},{1,2,8},{0,9,10},{0,7,10},{3,4,7},{0,4,7}}},

{6,
0,
0,
1,
{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
{{1,2,5},{1,5,11},{3,6,7},{2,3,4},{9,10,11},{6,7,10},{0,4,8},{0,8,9},{3,5,6},{2,3,5},{6,10,11},{5,6,11},{8,9,11},{1,8,11},{1,4,8},{1,2,4},{7,9,10},{0,7,9},{0,3,7},{0,3,4}}},

{7,
0,
0,
1,
{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
{{1,2,5},{1,5,11},{3,6,7},{2,3,4},{9,10,11},{6,7,10},{0,4,8},{0,8,9},{3,5,6},{2,3,5},{6,10,11},{5,6,11},{8,9,11},{1,8,11},{1,4,8},{1,2,4},{0,9,10},{0,7,10},{0,3,7},{0,3,4}}},

{8,
0,
0,
1,
{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
{{1,2,5},{1,5,11},{3,6,7},{2,3,4},{9,10,11},{6,7,10},{0,4,8},{0,8,9},{3,5,6},{2,3,5},{6,10,11},{5,6,11},{8,9,11},{1,8,11},{2,4,8},{1,2,8},{0,9,10},{0,7,10},{0,3,7},{0,3,4}}},

{9,
0,
0,
1,
{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
{{1,2,5},{1,5,11},{3,6,7},{2,3,4},{9,10,11},{6,7,10},{0,4,8},{0,8,9},{3,5,6},{2,3,5},{5,10,11},{5,6,10},{1,9,11},{1,8,9},{1,4,8},{1,2,4},{7,9,10},{0,7,9},{3,4,7},{0,4,7}}},

{10,
0,
0,
1,
{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
{{1,2,5},{1,5,11},{3,6,7},{2,3,4},{9,10,11},{6,7,10},{0,4,8},{0,8,9},{3,5,6},{2,3,5},{5,10,11},{5,6,10},{1,9,11},{1,8,9},{1,4,8},{1,2,4},{7,9,10},{0,7,9},{0,3,7},{0,3,4}}},

{11,
0,
0,
1,
{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
{{1,2,5},{1,5,11},{3,6,7},{2,3,4},{9,10,11},{6,7,10},{0,4,8},{0,8,9},{3,5,6},{2,3,5},{5,10,11},{5,6,10},{8,9,11},{1,8,11},{1,4,8},{1,2,4},{7,9,10},{0,7,9},{3,4,7},{0,4,7}}},

{12,
0,
18,
2,
{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
{{1,2,5},{1,5,11},{3,6,7},{2,3,4},{9,10,11},{6,7,10},{0,4,8},{0,8,9},{3,5,6},{2,3,5},{5,10,11},{5,6,10},{8,9,11},{1,8,11},{1,4,8},{1,2,4},{7,9,10},{0,7,9},{0,3,7},{0,3,4}}},

{13,
0,
0,
1,
{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
{{1,2,5},{1,5,11},{3,6,7},{2,3,4},{9,10,11},{6,7,10},{0,4,8},{0,8,9},{3,5,6},{2,3,5},{5,10,11},{5,6,10},{8,9,11},{1,8,11},{1,4,8},{1,2,4},{0,9,10},{0,7,10},{0,3,7},{0,3,4}}},

{14,
0,
20,
2,
{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
{{1,2,5},{1,5,11},{3,6,7},{2,3,4},{9,10,11},{6,7,10},{0,4,8},{0,8,9},{3,5,6},{2,3,5},{5,10,11},{5,6,10},{8,9,11},{1,8,11},{2,4,8},{1,2,8},{7,9,10},{0,7,9},{3,4,7},{0,4,7}}},

{15,
0,
22,
10,
{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
{{1,2,5},{1,5,11},{3,6,7},{2,3,4},{9,10,11},{6,7,10},{0,4,8},{0,8,9},{2,5,6},{2,3,6},{5,10,11},{5,6,10},{8,9,11},{1,8,11},{1,4,8},{1,2,4},{7,9,10},{0,7,9},{0,3,7},{0,3,4}}},

};

graph_t graphs_bcc[NUM_BCC_GRAPHS] = {

{0,
0,
0,
1,
{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
{{1,10,12},{0,10,12},{5,9,10},{1,9,10},{2,8,10},{0,8,10},{5,10,13},{2,10,13},{4,8,12},{0,8,12},{3,9,12},{1,9,12},{4,11,12},{3,11,12},{6,9,13},{5,9,13},{6,9,11},{3,9,11},{7,8,13},{2,8,13},{7,8,11},{4,8,11},{7,11,13},{6,11,13}}},

{1,
0,
0,
1,
{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
{{1,10,12},{0,10,12},{5,9,10},{1,9,10},{2,8,10},{0,8,10},{5,10,13},{2,10,13},{4,8,12},{0,8,12},{3,9,12},{1,9,12},{4,11,12},{3,11,12},{6,9,13},{5,9,13},{6,9,11},{3,9,11},{7,8,13},{2,8,13},{7,8,11},{4,8,11},{6,7,13},{6,7,11}}},

{2,
0,
0,
1,
{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
{{1,10,12},{0,10,12},{5,9,10},{1,9,10},{2,8,10},{0,8,10},{5,10,13},{2,10,13},{4,8,12},{0,8,12},{3,9,12},{1,9,12},{4,11,12},{3,11,12},{6,9,13},{5,9,13},{6,9,11},{3,9,11},{7,8,13},{2,8,13},{4,7,11},{4,7,8},{6,7,13},{6,7,11}}},

{3,
0,
0,
1,
{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
{{1,10,12},{0,10,12},{5,9,10},{1,9,10},{2,8,10},{0,8,10},{5,10,13},{2,10,13},{4,8,12},{0,8,12},{3,9,12},{1,9,12},{4,11,12},{3,11,12},{6,9,13},{5,9,13},{6,9,11},{3,9,11},{2,7,13},{2,7,8},{4,7,11},{4,7,8},{6,7,13},{6,7,11}}},

{4,
0,
0,
1,
{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
{{1,10,12},{0,10,12},{5,9,10},{1,9,10},{2,8,10},{0,8,10},{5,10,13},{2,10,13},{4,8,12},{0,8,12},{3,9,12},{1,9,12},{4,11,12},{3,11,12},{6,9,13},{5,9,13},{3,6,11},{3,6,9},{7,8,13},{2,8,13},{4,7,11},{4,7,8},{7,11,13},{6,11,13}}},

{5,
0,
0,
1,
{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
{{1,10,12},{0,10,12},{5,9,10},{1,9,10},{2,8,10},{0,8,10},{5,10,13},{2,10,13},{4,8,12},{0,8,12},{3,9,12},{1,9,12},{4,11,12},{3,11,12},{6,9,13},{5,9,13},{3,6,11},{3,6,9},{7,8,13},{2,8,13},{4,7,11},{4,7,8},{6,7,13},{6,7,11}}},

{6,
0,
0,
1,
{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
{{1,10,12},{0,10,12},{5,9,10},{1,9,10},{2,8,10},{0,8,10},{5,10,13},{2,10,13},{4,8,12},{0,8,12},{3,9,12},{1,9,12},{4,11,12},{3,11,12},{6,9,13},{5,9,13},{3,6,11},{3,6,9},{2,7,13},{2,7,8},{7,8,11},{4,8,11},{7,11,13},{6,11,13}}},

{7,
0,
0,
1,
{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
{{1,10,12},{0,10,12},{5,9,10},{1,9,10},{2,8,10},{0,8,10},{5,10,13},{2,10,13},{4,8,12},{0,8,12},{3,9,12},{1,9,12},{4,11,12},{3,11,12},{6,9,13},{5,9,13},{3,6,11},{3,6,9},{2,7,13},{2,7,8},{7,8,11},{4,8,11},{6,7,13},{6,7,11}}},

{8,
0,
0,
1,
{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
{{1,10,12},{0,10,12},{5,9,10},{1,9,10},{2,8,10},{0,8,10},{5,10,13},{2,10,13},{4,8,12},{0,8,12},{3,9,12},{1,9,12},{4,11,12},{3,11,12},{6,9,13},{5,9,13},{3,6,11},{3,6,9},{2,7,13},{2,7,8},{4,7,11},{4,7,8},{7,11,13},{6,11,13}}},

{9,
0,
0,
1,
{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
{{1,10,12},{0,10,12},{5,9,10},{1,9,10},{2,8,10},{0,8,10},{5,10,13},{2,10,13},{4,8,12},{0,8,12},{3,9,12},{1,9,12},{4,11,12},{3,11,12},{6,9,13},{5,9,13},{3,6,11},{3,6,9},{2,7,13},{2,7,8},{4,7,11},{4,7,8},{6,7,13},{6,7,11}}},

{10,
0,
0,
1,
{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
{{1,10,12},{0,10,12},{5,9,10},{1,9,10},{2,8,10},{0,8,10},{5,10,13},{2,10,13},{4,8,12},{0,8,12},{3,9,12},{1,9,12},{4,11,12},{3,11,12},{5,6,13},{5,6,9},{6,9,11},{3,9,11},{7,8,13},{2,8,13},{4,7,11},{4,7,8},{7,11,13},{6,11,13}}},

{11,
0,
0,
1,
{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
{{1,10,12},{0,10,12},{5,9,10},{1,9,10},{2,8,10},{0,8,10},{5,10,13},{2,10,13},{4,8,12},{0,8,12},{3,9,12},{1,9,12},{4,11,12},{3,11,12},{5,6,13},{5,6,9},{6,9,11},{3,9,11},{7,8,13},{2,8,13},{4,7,11},{4,7,8},{6,7,13},{6,7,11}}},

{12,
0,
0,
1,
{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
{{1,10,12},{0,10,12},{5,9,10},{1,9,10},{2,8,10},{0,8,10},{5,10,13},{2,10,13},{4,8,12},{0,8,12},{3,9,12},{1,9,12},{4,11,12},{3,11,12},{5,6,13},{5,6,9},{6,9,11},{3,9,11},{2,7,13},{2,7,8},{4,7,11},{4,7,8},{7,11,13},{6,11,13}}},

{13,
0,
0,
1,
{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
{{1,10,12},{0,10,12},{5,9,10},{1,9,10},{2,8,10},{0,8,10},{5,10,13},{2,10,13},{4,8,12},{0,8,12},{3,9,12},{1,9,12},{4,11,12},{3,11,12},{5,6,13},{5,6,9},{6,9,11},{3,9,11},{2,7,13},{2,7,8},{4,7,11},{4,7,8},{6,7,13},{6,7,11}}},

{14,
0,
0,
1,
{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
{{1,10,12},{0,10,12},{5,9,10},{1,9,10},{2,8,10},{0,8,10},{5,10,13},{2,10,13},{4,8,12},{0,8,12},{3,9,12},{1,9,12},{4,11,12},{3,11,12},{5,6,13},{5,6,9},{3,6,11},{3,6,9},{2,7,13},{2,7,8},{4,7,11},{4,7,8},{7,11,13},{6,11,13}}},

{15,
0,
0,
1,
{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
{{1,10,12},{0,10,12},{5,9,10},{1,9,10},{2,8,10},{0,8,10},{5,10,13},{2,10,13},{4,8,12},{0,8,12},{3,9,12},{1,9,12},{4,11,12},{3,11,12},{5,6,13},{5,6,9},{3,6,11},{3,6,9},{2,7,13},{2,7,8},{4,7,11},{4,7,8},{6,7,13},{6,7,11}}},

{16,
0,
0,
1,
{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
{{1,10,12},{0,10,12},{5,9,10},{1,9,10},{2,8,10},{0,8,10},{5,10,13},{2,10,13},{4,8,12},{0,8,12},{3,9,12},{1,9,12},{3,4,12},{3,4,11},{6,9,13},{5,9,13},{3,6,11},{3,6,9},{7,8,13},{2,8,13},{4,7,11},{4,7,8},{6,7,13},{6,7,11}}},

{17,
0,
0,
1,
{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
{{1,10,12},{0,10,12},{5,9,10},{1,9,10},{2,8,10},{0,8,10},{5,10,13},{2,10,13},{4,8,12},{0,8,12},{3,9,12},{1,9,12},{3,4,12},{3,4,11},{6,9,13},{5,9,13},{3,6,11},{3,6,9},{2,7,13},{2,7,8},{7,8,11},{4,8,11},{7,11,13},{6,11,13}}},

{18,
0,
0,
1,
{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
{{1,10,12},{0,10,12},{5,9,10},{1,9,10},{2,8,10},{0,8,10},{5,10,13},{2,10,13},{4,8,12},{0,8,12},{3,9,12},{1,9,12},{3,4,12},{3,4,11},{6,9,13},{5,9,13},{3,6,11},{3,6,9},{2,7,13},{2,7,8},{7,8,11},{4,8,11},{6,7,13},{6,7,11}}},

{19,
0,
0,
1,
{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
{{1,10,12},{0,10,12},{5,9,10},{1,9,10},{2,8,10},{0,8,10},{5,10,13},{2,10,13},{4,8,12},{0,8,12},{3,9,12},{1,9,12},{3,4,12},{3,4,11},{6,9,13},{5,9,13},{3,6,11},{3,6,9},{2,7,13},{2,7,8},{4,7,11},{4,7,8},{7,11,13},{6,11,13}}},

{20,
0,
0,
1,
{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
{{1,10,12},{0,10,12},{5,9,10},{1,9,10},{2,8,10},{0,8,10},{5,10,13},{2,10,13},{4,8,12},{0,8,12},{3,9,12},{1,9,12},{3,4,12},{3,4,11},{6,9,13},{5,9,13},{3,6,11},{3,6,9},{2,7,13},{2,7,8},{4,7,11},{4,7,8},{6,7,13},{6,7,11}}},

{21,
0,
0,
1,
{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
{{1,10,12},{0,10,12},{5,9,10},{1,9,10},{2,8,10},{0,8,10},{5,10,13},{2,10,13},{4,8,12},{0,8,12},{3,9,12},{1,9,12},{3,4,12},{3,4,11},{5,6,13},{5,6,9},{6,9,11},{3,9,11},{2,7,13},{2,7,8},{7,8,11},{4,8,11},{7,11,13},{6,11,13}}},

{22,
0,
0,
1,
{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
{{1,10,12},{0,10,12},{5,9,10},{1,9,10},{2,8,10},{0,8,10},{5,10,13},{2,10,13},{4,8,12},{0,8,12},{3,9,12},{1,9,12},{3,4,12},{3,4,11},{5,6,13},{5,6,9},{6,9,11},{3,9,11},{2,7,13},{2,7,8},{7,8,11},{4,8,11},{6,7,13},{6,7,11}}},

{23,
0,
0,
1,
{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
{{1,10,12},{0,10,12},{5,9,10},{1,9,10},{2,8,10},{0,8,10},{5,10,13},{2,10,13},{4,8,12},{0,8,12},{3,9,12},{1,9,12},{3,4,12},{3,4,11},{5,6,13},{5,6,9},{6,9,11},{3,9,11},{2,7,13},{2,7,8},{4,7,11},{4,7,8},{7,11,13},{6,11,13}}},

{24,
0,
0,
1,
{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
{{1,10,12},{0,10,12},{5,9,10},{1,9,10},{2,8,10},{0,8,10},{5,10,13},{2,10,13},{4,8,12},{0,8,12},{3,9,12},{1,9,12},{3,4,12},{3,4,11},{5,6,13},{5,6,9},{6,9,11},{3,9,11},{2,7,13},{2,7,8},{4,7,11},{4,7,8},{6,7,13},{6,7,11}}},

{25,
0,
0,
1,
{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
{{1,10,12},{0,10,12},{5,9,10},{1,9,10},{2,8,10},{0,8,10},{5,10,13},{2,10,13},{4,8,12},{0,8,12},{3,9,12},{1,9,12},{3,4,12},{3,4,11},{5,6,13},{5,6,9},{3,6,11},{3,6,9},{2,7,13},{2,7,8},{7,8,11},{4,8,11},{7,11,13},{6,11,13}}},

{26,
0,
0,
1,
{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
{{1,10,12},{0,10,12},{5,9,10},{1,9,10},{2,8,10},{0,8,10},{5,10,13},{2,10,13},{4,8,12},{0,8,12},{3,9,12},{1,9,12},{3,4,12},{3,4,11},{5,6,13},{5,6,9},{3,6,11},{3,6,9},{2,7,13},{2,7,8},{7,8,11},{4,8,11},{6,7,13},{6,7,11}}},

{27,
0,
0,
1,
{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
{{1,10,12},{0,10,12},{5,9,10},{1,9,10},{2,8,10},{0,8,10},{5,10,13},{2,10,13},{4,8,12},{0,8,12},{3,9,12},{1,9,12},{3,4,12},{3,4,11},{5,6,13},{5,6,9},{3,6,11},{3,6,9},{2,7,13},{2,7,8},{4,7,11},{4,7,8},{7,11,13},{6,11,13}}},

{28,
0,
0,
1,
{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
{{1,10,12},{0,10,12},{5,9,10},{1,9,10},{2,8,10},{0,8,10},{5,10,13},{2,10,13},{4,8,12},{0,8,12},{3,9,12},{1,9,12},{3,4,12},{3,4,11},{5,6,13},{5,6,9},{3,6,11},{3,6,9},{2,7,13},{2,7,8},{4,7,11},{4,7,8},{6,7,13},{6,7,11}}},

{29,
0,
0,
1,
{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
{{1,10,12},{0,10,12},{5,9,10},{1,9,10},{2,8,10},{0,8,10},{5,10,13},{2,10,13},{4,8,12},{0,8,12},{1,3,12},{1,3,9},{4,11,12},{3,11,12},{6,9,13},{5,9,13},{6,9,11},{3,9,11},{2,7,13},{2,7,8},{7,8,11},{4,8,11},{7,11,13},{6,11,13}}},

{30,
0,
0,
1,
{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
{{1,10,12},{0,10,12},{5,9,10},{1,9,10},{2,8,10},{0,8,10},{5,10,13},{2,10,13},{4,8,12},{0,8,12},{1,3,12},{1,3,9},{4,11,12},{3,11,12},{6,9,13},{5,9,13},{6,9,11},{3,9,11},{2,7,13},{2,7,8},{7,8,11},{4,8,11},{6,7,13},{6,7,11}}},

{31,
0,
0,
1,
{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
{{1,10,12},{0,10,12},{5,9,10},{1,9,10},{2,8,10},{0,8,10},{5,10,13},{2,10,13},{4,8,12},{0,8,12},{1,3,12},{1,3,9},{4,11,12},{3,11,12},{6,9,13},{5,9,13},{6,9,11},{3,9,11},{2,7,13},{2,7,8},{4,7,11},{4,7,8},{7,11,13},{6,11,13}}},

{32,
0,
0,
1,
{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
{{1,10,12},{0,10,12},{5,9,10},{1,9,10},{2,8,10},{0,8,10},{5,10,13},{2,10,13},{4,8,12},{0,8,12},{1,3,12},{1,3,9},{4,11,12},{3,11,12},{6,9,13},{5,9,13},{6,9,11},{3,9,11},{2,7,13},{2,7,8},{4,7,11},{4,7,8},{6,7,13},{6,7,11}}},

{33,
0,
0,
1,
{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
{{1,10,12},{0,10,12},{5,9,10},{1,9,10},{2,8,10},{0,8,10},{5,10,13},{2,10,13},{4,8,12},{0,8,12},{1,3,12},{1,3,9},{4,11,12},{3,11,12},{6,9,13},{5,9,13},{3,6,11},{3,6,9},{2,7,13},{2,7,8},{7,8,11},{4,8,11},{6,7,13},{6,7,11}}},

{34,
0,
0,
1,
{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
{{1,10,12},{0,10,12},{5,9,10},{1,9,10},{2,8,10},{0,8,10},{5,10,13},{2,10,13},{4,8,12},{0,8,12},{1,3,12},{1,3,9},{4,11,12},{3,11,12},{6,9,13},{5,9,13},{3,6,11},{3,6,9},{2,7,13},{2,7,8},{4,7,11},{4,7,8},{7,11,13},{6,11,13}}},

{35,
0,
0,
1,
{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
{{1,10,12},{0,10,12},{5,9,10},{1,9,10},{2,8,10},{0,8,10},{5,10,13},{2,10,13},{4,8,12},{0,8,12},{1,3,12},{1,3,9},{4,11,12},{3,11,12},{6,9,13},{5,9,13},{3,6,11},{3,6,9},{2,7,13},{2,7,8},{4,7,11},{4,7,8},{6,7,13},{6,7,11}}},

{36,
0,
0,
1,
{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
{{1,10,12},{0,10,12},{5,9,10},{1,9,10},{2,8,10},{0,8,10},{5,10,13},{2,10,13},{4,8,12},{0,8,12},{1,3,12},{1,3,9},{4,11,12},{3,11,12},{5,6,13},{5,6,9},{6,9,11},{3,9,11},{2,7,13},{2,7,8},{7,8,11},{4,8,11},{7,11,13},{6,11,13}}},

{37,
0,
0,
1,
{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
{{1,10,12},{0,10,12},{5,9,10},{1,9,10},{2,8,10},{0,8,10},{5,10,13},{2,10,13},{4,8,12},{0,8,12},{1,3,12},{1,3,9},{4,11,12},{3,11,12},{5,6,13},{5,6,9},{6,9,11},{3,9,11},{2,7,13},{2,7,8},{7,8,11},{4,8,11},{6,7,13},{6,7,11}}},

{38,
0,
0,
1,
{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
{{1,10,12},{0,10,12},{5,9,10},{1,9,10},{2,8,10},{0,8,10},{5,10,13},{2,10,13},{4,8,12},{0,8,12},{1,3,12},{1,3,9},{4,11,12},{3,11,12},{5,6,13},{5,6,9},{6,9,11},{3,9,11},{2,7,13},{2,7,8},{4,7,11},{4,7,8},{7,11,13},{6,11,13}}},

{39,
0,
0,
1,
{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
{{1,10,12},{0,10,12},{5,9,10},{1,9,10},{2,8,10},{0,8,10},{5,10,13},{2,10,13},{4,8,12},{0,8,12},{1,3,12},{1,3,9},{4,11,12},{3,11,12},{5,6,13},{5,6,9},{6,9,11},{3,9,11},{2,7,13},{2,7,8},{4,7,11},{4,7,8},{6,7,13},{6,7,11}}},

{40,
0,
0,
1,
{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
{{1,10,12},{0,10,12},{5,9,10},{1,9,10},{2,8,10},{0,8,10},{5,10,13},{2,10,13},{4,8,12},{0,8,12},{1,3,12},{1,3,9},{4,11,12},{3,11,12},{5,6,13},{5,6,9},{3,6,11},{3,6,9},{2,7,13},{2,7,8},{7,8,11},{4,8,11},{7,11,13},{6,11,13}}},

{41,
0,
0,
1,
{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
{{1,10,12},{0,10,12},{5,9,10},{1,9,10},{2,8,10},{0,8,10},{5,10,13},{2,10,13},{4,8,12},{0,8,12},{1,3,12},{1,3,9},{4,11,12},{3,11,12},{5,6,13},{5,6,9},{3,6,11},{3,6,9},{2,7,13},{2,7,8},{7,8,11},{4,8,11},{6,7,13},{6,7,11}}},

{42,
0,
0,
1,
{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
{{1,10,12},{0,10,12},{5,9,10},{1,9,10},{2,8,10},{0,8,10},{5,10,13},{2,10,13},{4,8,12},{0,8,12},{1,3,12},{1,3,9},{4,11,12},{3,11,12},{5,6,13},{5,6,9},{3,6,11},{3,6,9},{2,7,13},{2,7,8},{4,7,11},{4,7,8},{7,11,13},{6,11,13}}},

{43,
0,
0,
1,
{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
{{1,10,12},{0,10,12},{5,9,10},{1,9,10},{2,8,10},{0,8,10},{5,10,13},{2,10,13},{4,8,12},{0,8,12},{1,3,12},{1,3,9},{4,11,12},{3,11,12},{5,6,13},{5,6,9},{3,6,11},{3,6,9},{2,7,13},{2,7,8},{4,7,11},{4,7,8},{6,7,13},{6,7,11}}},

{44,
0,
0,
1,
{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
{{1,10,12},{0,10,12},{5,9,10},{1,9,10},{2,8,10},{0,8,10},{5,10,13},{2,10,13},{4,8,12},{0,8,12},{1,3,12},{1,3,9},{3,4,12},{3,4,11},{6,9,13},{5,9,13},{6,9,11},{3,9,11},{2,7,13},{2,7,8},{7,8,11},{4,8,11},{6,7,13},{6,7,11}}},

{45,
0,
0,
1,
{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
{{1,10,12},{0,10,12},{5,9,10},{1,9,10},{2,8,10},{0,8,10},{5,10,13},{2,10,13},{4,8,12},{0,8,12},{1,3,12},{1,3,9},{3,4,12},{3,4,11},{6,9,13},{5,9,13},{6,9,11},{3,9,11},{2,7,13},{2,7,8},{4,7,11},{4,7,8},{6,7,13},{6,7,11}}},

{46,
0,
0,
1,
{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
{{1,10,12},{0,10,12},{5,9,10},{1,9,10},{2,8,10},{0,8,10},{5,10,13},{2,10,13},{4,8,12},{0,8,12},{1,3,12},{1,3,9},{3,4,12},{3,4,11},{6,9,13},{5,9,13},{3,6,11},{3,6,9},{2,7,13},{2,7,8},{4,7,11},{4,7,8},{6,7,13},{6,7,11}}},

{47,
0,
0,
1,
{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
{{1,10,12},{0,10,12},{5,9,10},{1,9,10},{2,8,10},{0,8,10},{5,10,13},{2,10,13},{4,8,12},{0,8,12},{1,3,12},{1,3,9},{3,4,12},{3,4,11},{5,6,13},{5,6,9},{6,9,11},{3,9,11},{2,7,13},{2,7,8},{7,8,11},{4,8,11},{7,11,13},{6,11,13}}},

{48,
0,
0,
1,
{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
{{1,10,12},{0,10,12},{5,9,10},{1,9,10},{2,8,10},{0,8,10},{5,10,13},{2,10,13},{4,8,12},{0,8,12},{1,3,12},{1,3,9},{3,4,12},{3,4,11},{5,6,13},{5,6,9},{6,9,11},{3,9,11},{2,7,13},{2,7,8},{7,8,11},{4,8,11},{6,7,13},{6,7,11}}},

{49,
0,
0,
1,
{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
{{1,10,12},{0,10,12},{5,9,10},{1,9,10},{2,8,10},{0,8,10},{5,10,13},{2,10,13},{4,8,12},{0,8,12},{1,3,12},{1,3,9},{3,4,12},{3,4,11},{5,6,13},{5,6,9},{6,9,11},{3,9,11},{2,7,13},{2,7,8},{4,7,11},{4,7,8},{7,11,13},{6,11,13}}},

{50,
0,
0,
1,
{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
{{1,10,12},{0,10,12},{5,9,10},{1,9,10},{2,8,10},{0,8,10},{5,10,13},{2,10,13},{4,8,12},{0,8,12},{1,3,12},{1,3,9},{3,4,12},{3,4,11},{5,6,13},{5,6,9},{6,9,11},{3,9,11},{2,7,13},{2,7,8},{4,7,11},{4,7,8},{6,7,13},{6,7,11}}},

{51,
0,
0,
1,
{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
{{1,10,12},{0,10,12},{5,9,10},{1,9,10},{2,8,10},{0,8,10},{5,10,13},{2,10,13},{4,8,12},{0,8,12},{1,3,12},{1,3,9},{3,4,12},{3,4,11},{5,6,13},{5,6,9},{3,6,11},{3,6,9},{2,7,13},{2,7,8},{7,8,11},{4,8,11},{7,11,13},{6,11,13}}},

{52,
0,
0,
1,
{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
{{1,10,12},{0,10,12},{5,9,10},{1,9,10},{2,8,10},{0,8,10},{5,10,13},{2,10,13},{4,8,12},{0,8,12},{1,3,12},{1,3,9},{3,4,12},{3,4,11},{5,6,13},{5,6,9},{3,6,11},{3,6,9},{2,7,13},{2,7,8},{7,8,11},{4,8,11},{6,7,13},{6,7,11}}},

{53,
0,
0,
1,
{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
{{1,10,12},{0,10,12},{5,9,10},{1,9,10},{2,8,10},{0,8,10},{5,10,13},{2,10,13},{4,8,12},{0,8,12},{1,3,12},{1,3,9},{3,4,12},{3,4,11},{5,6,13},{5,6,9},{3,6,11},{3,6,9},{2,7,13},{2,7,8},{4,7,11},{4,7,8},{7,11,13},{6,11,13}}},

{54,
0,
0,
1,
{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
{{1,10,12},{0,10,12},{5,9,10},{1,9,10},{2,8,10},{0,8,10},{5,10,13},{2,10,13},{4,8,12},{0,8,12},{1,3,12},{1,3,9},{3,4,12},{3,4,11},{5,6,13},{5,6,9},{3,6,11},{3,6,9},{2,7,13},{2,7,8},{4,7,11},{4,7,8},{6,7,13},{6,7,11}}},

{55,
0,
0,
1,
{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
{{1,10,12},{0,10,12},{5,9,10},{1,9,10},{2,8,10},{0,8,10},{5,10,13},{2,10,13},{0,4,12},{0,4,8},{1,3,12},{1,3,9},{4,11,12},{3,11,12},{5,6,13},{5,6,9},{6,9,11},{3,9,11},{2,7,13},{2,7,8},{7,8,11},{4,8,11},{7,11,13},{6,11,13}}},

{56,
0,
0,
1,
{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
{{1,10,12},{0,10,12},{5,9,10},{1,9,10},{2,8,10},{0,8,10},{5,10,13},{2,10,13},{0,4,12},{0,4,8},{1,3,12},{1,3,9},{4,11,12},{3,11,12},{5,6,13},{5,6,9},{6,9,11},{3,9,11},{2,7,13},{2,7,8},{7,8,11},{4,8,11},{6,7,13},{6,7,11}}},

{57,
0,
0,
1,
{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
{{1,10,12},{0,10,12},{5,9,10},{1,9,10},{2,8,10},{0,8,10},{5,10,13},{2,10,13},{0,4,12},{0,4,8},{1,3,12},{1,3,9},{4,11,12},{3,11,12},{5,6,13},{5,6,9},{6,9,11},{3,9,11},{2,7,13},{2,7,8},{4,7,11},{4,7,8},{6,7,13},{6,7,11}}},

{58,
0,
0,
1,
{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
{{1,10,12},{0,10,12},{5,9,10},{1,9,10},{2,8,10},{0,8,10},{5,10,13},{2,10,13},{0,4,12},{0,4,8},{1,3,12},{1,3,9},{4,11,12},{3,11,12},{5,6,13},{5,6,9},{3,6,11},{3,6,9},{2,7,13},{2,7,8},{4,7,11},{4,7,8},{7,11,13},{6,11,13}}},

{59,
0,
0,
1,
{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
{{1,10,12},{0,10,12},{5,9,10},{1,9,10},{2,8,10},{0,8,10},{5,10,13},{2,10,13},{0,4,12},{0,4,8},{1,3,12},{1,3,9},{4,11,12},{3,11,12},{5,6,13},{5,6,9},{3,6,11},{3,6,9},{2,7,13},{2,7,8},{4,7,11},{4,7,8},{6,7,13},{6,7,11}}},

{60,
0,
0,
1,
{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
{{1,10,12},{0,10,12},{5,9,10},{1,9,10},{2,8,10},{0,8,10},{5,10,13},{2,10,13},{0,4,12},{0,4,8},{1,3,12},{1,3,9},{3,4,12},{3,4,11},{5,6,13},{5,6,9},{3,6,11},{3,6,9},{2,7,13},{2,7,8},{4,7,11},{4,7,8},{6,7,13},{6,7,11}}},

{61,
0,
0,
1,
{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
{{1,10,12},{0,10,12},{5,9,10},{1,9,10},{2,8,10},{0,8,10},{2,5,13},{2,5,10},{4,8,12},{0,8,12},{3,9,12},{1,9,12},{3,4,12},{3,4,11},{6,9,13},{5,9,13},{3,6,11},{3,6,9},{7,8,13},{2,8,13},{4,7,11},{4,7,8},{7,11,13},{6,11,13}}},

{62,
0,
0,
1,
{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
{{1,10,12},{0,10,12},{5,9,10},{1,9,10},{2,8,10},{0,8,10},{2,5,13},{2,5,10},{4,8,12},{0,8,12},{3,9,12},{1,9,12},{3,4,12},{3,4,11},{6,9,13},{5,9,13},{3,6,11},{3,6,9},{7,8,13},{2,8,13},{4,7,11},{4,7,8},{6,7,13},{6,7,11}}},

{63,
0,
0,
1,
{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
{{1,10,12},{0,10,12},{5,9,10},{1,9,10},{2,8,10},{0,8,10},{2,5,13},{2,5,10},{4,8,12},{0,8,12},{3,9,12},{1,9,12},{3,4,12},{3,4,11},{6,9,13},{5,9,13},{3,6,11},{3,6,9},{2,7,13},{2,7,8},{7,8,11},{4,8,11},{7,11,13},{6,11,13}}},

{64,
0,
0,
1,
{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
{{1,10,12},{0,10,12},{5,9,10},{1,9,10},{2,8,10},{0,8,10},{2,5,13},{2,5,10},{4,8,12},{0,8,12},{3,9,12},{1,9,12},{3,4,12},{3,4,11},{6,9,13},{5,9,13},{3,6,11},{3,6,9},{2,7,13},{2,7,8},{7,8,11},{4,8,11},{6,7,13},{6,7,11}}},

{65,
0,
0,
1,
{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
{{1,10,12},{0,10,12},{5,9,10},{1,9,10},{2,8,10},{0,8,10},{2,5,13},{2,5,10},{4,8,12},{0,8,12},{3,9,12},{1,9,12},{3,4,12},{3,4,11},{6,9,13},{5,9,13},{3,6,11},{3,6,9},{2,7,13},{2,7,8},{4,7,11},{4,7,8},{7,11,13},{6,11,13}}},

{66,
0,
0,
1,
{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
{{1,10,12},{0,10,12},{5,9,10},{1,9,10},{2,8,10},{0,8,10},{2,5,13},{2,5,10},{4,8,12},{0,8,12},{3,9,12},{1,9,12},{3,4,12},{3,4,11},{6,9,13},{5,9,13},{3,6,11},{3,6,9},{2,7,13},{2,7,8},{4,7,11},{4,7,8},{6,7,13},{6,7,11}}},

{67,
0,
0,
1,
{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
{{1,10,12},{0,10,12},{5,9,10},{1,9,10},{2,8,10},{0,8,10},{2,5,13},{2,5,10},{4,8,12},{0,8,12},{3,9,12},{1,9,12},{3,4,12},{3,4,11},{5,6,13},{5,6,9},{6,9,11},{3,9,11},{7,8,13},{2,8,13},{4,7,11},{4,7,8},{7,11,13},{6,11,13}}},

{68,
0,
0,
1,
{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
{{1,10,12},{0,10,12},{5,9,10},{1,9,10},{2,8,10},{0,8,10},{2,5,13},{2,5,10},{4,8,12},{0,8,12},{3,9,12},{1,9,12},{3,4,12},{3,4,11},{5,6,13},{5,6,9},{6,9,11},{3,9,11},{7,8,13},{2,8,13},{4,7,11},{4,7,8},{6,7,13},{6,7,11}}},

{69,
0,
0,
1,
{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
{{1,10,12},{0,10,12},{5,9,10},{1,9,10},{2,8,10},{0,8,10},{2,5,13},{2,5,10},{4,8,12},{0,8,12},{3,9,12},{1,9,12},{3,4,12},{3,4,11},{5,6,13},{5,6,9},{6,9,11},{3,9,11},{2,7,13},{2,7,8},{4,7,11},{4,7,8},{7,11,13},{6,11,13}}},

{70,
0,
0,
1,
{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
{{1,10,12},{0,10,12},{5,9,10},{1,9,10},{2,8,10},{0,8,10},{2,5,13},{2,5,10},{4,8,12},{0,8,12},{3,9,12},{1,9,12},{3,4,12},{3,4,11},{5,6,13},{5,6,9},{6,9,11},{3,9,11},{2,7,13},{2,7,8},{4,7,11},{4,7,8},{6,7,13},{6,7,11}}},

{71,
0,
0,
1,
{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
{{1,10,12},{0,10,12},{5,9,10},{1,9,10},{2,8,10},{0,8,10},{2,5,13},{2,5,10},{4,8,12},{0,8,12},{3,9,12},{1,9,12},{3,4,12},{3,4,11},{5,6,13},{5,6,9},{3,6,11},{3,6,9},{2,7,13},{2,7,8},{4,7,11},{4,7,8},{7,11,13},{6,11,13}}},

{72,
0,
0,
1,
{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
{{1,10,12},{0,10,12},{5,9,10},{1,9,10},{2,8,10},{0,8,10},{2,5,13},{2,5,10},{4,8,12},{0,8,12},{3,9,12},{1,9,12},{3,4,12},{3,4,11},{5,6,13},{5,6,9},{3,6,11},{3,6,9},{2,7,13},{2,7,8},{4,7,11},{4,7,8},{6,7,13},{6,7,11}}},

{73,
0,
0,
1,
{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
{{1,10,12},{0,10,12},{5,9,10},{1,9,10},{2,8,10},{0,8,10},{2,5,13},{2,5,10},{4,8,12},{0,8,12},{1,3,12},{1,3,9},{4,11,12},{3,11,12},{6,9,13},{5,9,13},{6,9,11},{3,9,11},{7,8,13},{2,8,13},{4,7,11},{4,7,8},{7,11,13},{6,11,13}}},

{74,
0,
0,
1,
{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
{{1,10,12},{0,10,12},{5,9,10},{1,9,10},{2,8,10},{0,8,10},{2,5,13},{2,5,10},{4,8,12},{0,8,12},{1,3,12},{1,3,9},{4,11,12},{3,11,12},{6,9,13},{5,9,13},{6,9,11},{3,9,11},{7,8,13},{2,8,13},{4,7,11},{4,7,8},{6,7,13},{6,7,11}}},

{75,
0,
0,
1,
{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
{{1,10,12},{0,10,12},{5,9,10},{1,9,10},{2,8,10},{0,8,10},{2,5,13},{2,5,10},{4,8,12},{0,8,12},{1,3,12},{1,3,9},{4,11,12},{3,11,12},{6,9,13},{5,9,13},{6,9,11},{3,9,11},{2,7,13},{2,7,8},{4,7,11},{4,7,8},{7,11,13},{6,11,13}}},

{76,
0,
0,
1,
{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
{{1,10,12},{0,10,12},{5,9,10},{1,9,10},{2,8,10},{0,8,10},{2,5,13},{2,5,10},{4,8,12},{0,8,12},{1,3,12},{1,3,9},{4,11,12},{3,11,12},{6,9,13},{5,9,13},{6,9,11},{3,9,11},{2,7,13},{2,7,8},{4,7,11},{4,7,8},{6,7,13},{6,7,11}}},

{77,
0,
0,
1,
{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
{{1,10,12},{0,10,12},{5,9,10},{1,9,10},{2,8,10},{0,8,10},{2,5,13},{2,5,10},{4,8,12},{0,8,12},{1,3,12},{1,3,9},{4,11,12},{3,11,12},{6,9,13},{5,9,13},{3,6,11},{3,6,9},{7,8,13},{2,8,13},{4,7,11},{4,7,8},{6,7,13},{6,7,11}}},

{78,
0,
0,
1,
{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
{{1,10,12},{0,10,12},{5,9,10},{1,9,10},{2,8,10},{0,8,10},{2,5,13},{2,5,10},{4,8,12},{0,8,12},{1,3,12},{1,3,9},{4,11,12},{3,11,12},{6,9,13},{5,9,13},{3,6,11},{3,6,9},{2,7,13},{2,7,8},{4,7,11},{4,7,8},{7,11,13},{6,11,13}}},

{79,
0,
0,
1,
{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
{{1,10,12},{0,10,12},{5,9,10},{1,9,10},{2,8,10},{0,8,10},{2,5,13},{2,5,10},{4,8,12},{0,8,12},{1,3,12},{1,3,9},{4,11,12},{3,11,12},{6,9,13},{5,9,13},{3,6,11},{3,6,9},{2,7,13},{2,7,8},{4,7,11},{4,7,8},{6,7,13},{6,7,11}}},

{80,
0,
0,
1,
{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
{{1,10,12},{0,10,12},{5,9,10},{1,9,10},{2,8,10},{0,8,10},{2,5,13},{2,5,10},{4,8,12},{0,8,12},{1,3,12},{1,3,9},{4,11,12},{3,11,12},{5,6,13},{5,6,9},{6,9,11},{3,9,11},{2,7,13},{2,7,8},{4,7,11},{4,7,8},{7,11,13},{6,11,13}}},

{81,
0,
0,
1,
{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
{{1,10,12},{0,10,12},{5,9,10},{1,9,10},{2,8,10},{0,8,10},{2,5,13},{2,5,10},{4,8,12},{0,8,12},{1,3,12},{1,3,9},{4,11,12},{3,11,12},{5,6,13},{5,6,9},{6,9,11},{3,9,11},{2,7,13},{2,7,8},{4,7,11},{4,7,8},{6,7,13},{6,7,11}}},

{82,
0,
0,
1,
{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
{{1,10,12},{0,10,12},{5,9,10},{1,9,10},{2,8,10},{0,8,10},{2,5,13},{2,5,10},{4,8,12},{0,8,12},{1,3,12},{1,3,9},{4,11,12},{3,11,12},{5,6,13},{5,6,9},{3,6,11},{3,6,9},{7,8,13},{2,8,13},{4,7,11},{4,7,8},{6,7,13},{6,7,11}}},

{83,
0,
0,
1,
{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
{{1,10,12},{0,10,12},{5,9,10},{1,9,10},{2,8,10},{0,8,10},{2,5,13},{2,5,10},{4,8,12},{0,8,12},{1,3,12},{1,3,9},{4,11,12},{3,11,12},{5,6,13},{5,6,9},{3,6,11},{3,6,9},{2,7,13},{2,7,8},{4,7,11},{4,7,8},{7,11,13},{6,11,13}}},

{84,
0,
0,
1,
{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
{{1,10,12},{0,10,12},{5,9,10},{1,9,10},{2,8,10},{0,8,10},{2,5,13},{2,5,10},{4,8,12},{0,8,12},{1,3,12},{1,3,9},{4,11,12},{3,11,12},{5,6,13},{5,6,9},{3,6,11},{3,6,9},{2,7,13},{2,7,8},{4,7,11},{4,7,8},{6,7,13},{6,7,11}}},

{85,
0,
0,
1,
{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
{{1,10,12},{0,10,12},{5,9,10},{1,9,10},{2,8,10},{0,8,10},{2,5,13},{2,5,10},{4,8,12},{0,8,12},{1,3,12},{1,3,9},{3,4,12},{3,4,11},{6,9,13},{5,9,13},{6,9,11},{3,9,11},{2,7,13},{2,7,8},{7,8,11},{4,8,11},{7,11,13},{6,11,13}}},

{86,
0,
0,
1,
{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
{{1,10,12},{0,10,12},{5,9,10},{1,9,10},{2,8,10},{0,8,10},{2,5,13},{2,5,10},{4,8,12},{0,8,12},{1,3,12},{1,3,9},{3,4,12},{3,4,11},{6,9,13},{5,9,13},{6,9,11},{3,9,11},{2,7,13},{2,7,8},{7,8,11},{4,8,11},{6,7,13},{6,7,11}}},

{87,
0,
0,
1,
{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
{{1,10,12},{0,10,12},{5,9,10},{1,9,10},{2,8,10},{0,8,10},{2,5,13},{2,5,10},{4,8,12},{0,8,12},{1,3,12},{1,3,9},{3,4,12},{3,4,11},{6,9,13},{5,9,13},{6,9,11},{3,9,11},{2,7,13},{2,7,8},{4,7,11},{4,7,8},{7,11,13},{6,11,13}}},

{88,
0,
0,
1,
{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
{{1,10,12},{0,10,12},{5,9,10},{1,9,10},{2,8,10},{0,8,10},{2,5,13},{2,5,10},{4,8,12},{0,8,12},{1,3,12},{1,3,9},{3,4,12},{3,4,11},{6,9,13},{5,9,13},{6,9,11},{3,9,11},{2,7,13},{2,7,8},{4,7,11},{4,7,8},{6,7,13},{6,7,11}}},

{89,
0,
0,
1,
{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
{{1,10,12},{0,10,12},{5,9,10},{1,9,10},{2,8,10},{0,8,10},{2,5,13},{2,5,10},{4,8,12},{0,8,12},{1,3,12},{1,3,9},{3,4,12},{3,4,11},{6,9,13},{5,9,13},{3,6,11},{3,6,9},{2,7,13},{2,7,8},{7,8,11},{4,8,11},{7,11,13},{6,11,13}}},

{90,
0,
0,
1,
{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
{{1,10,12},{0,10,12},{5,9,10},{1,9,10},{2,8,10},{0,8,10},{2,5,13},{2,5,10},{4,8,12},{0,8,12},{1,3,12},{1,3,9},{3,4,12},{3,4,11},{6,9,13},{5,9,13},{3,6,11},{3,6,9},{2,7,13},{2,7,8},{7,8,11},{4,8,11},{6,7,13},{6,7,11}}},

{91,
0,
0,
1,
{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
{{1,10,12},{0,10,12},{5,9,10},{1,9,10},{2,8,10},{0,8,10},{2,5,13},{2,5,10},{4,8,12},{0,8,12},{1,3,12},{1,3,9},{3,4,12},{3,4,11},{6,9,13},{5,9,13},{3,6,11},{3,6,9},{2,7,13},{2,7,8},{4,7,11},{4,7,8},{7,11,13},{6,11,13}}},

{92,
0,
0,
1,
{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
{{1,10,12},{0,10,12},{5,9,10},{1,9,10},{2,8,10},{0,8,10},{2,5,13},{2,5,10},{4,8,12},{0,8,12},{1,3,12},{1,3,9},{3,4,12},{3,4,11},{6,9,13},{5,9,13},{3,6,11},{3,6,9},{2,7,13},{2,7,8},{4,7,11},{4,7,8},{6,7,13},{6,7,11}}},

{93,
0,
0,
1,
{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
{{1,10,12},{0,10,12},{5,9,10},{1,9,10},{2,8,10},{0,8,10},{2,5,13},{2,5,10},{4,8,12},{0,8,12},{1,3,12},{1,3,9},{3,4,12},{3,4,11},{5,6,13},{5,6,9},{6,9,11},{3,9,11},{2,7,13},{2,7,8},{7,8,11},{4,8,11},{7,11,13},{6,11,13}}},

{94,
0,
0,
1,
{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
{{1,10,12},{0,10,12},{5,9,10},{1,9,10},{2,8,10},{0,8,10},{2,5,13},{2,5,10},{4,8,12},{0,8,12},{1,3,12},{1,3,9},{3,4,12},{3,4,11},{5,6,13},{5,6,9},{6,9,11},{3,9,11},{2,7,13},{2,7,8},{7,8,11},{4,8,11},{6,7,13},{6,7,11}}},

{95,
0,
0,
1,
{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
{{1,10,12},{0,10,12},{5,9,10},{1,9,10},{2,8,10},{0,8,10},{2,5,13},{2,5,10},{4,8,12},{0,8,12},{1,3,12},{1,3,9},{3,4,12},{3,4,11},{5,6,13},{5,6,9},{6,9,11},{3,9,11},{2,7,13},{2,7,8},{4,7,11},{4,7,8},{7,11,13},{6,11,13}}},

{96,
0,
0,
1,
{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
{{1,10,12},{0,10,12},{5,9,10},{1,9,10},{2,8,10},{0,8,10},{2,5,13},{2,5,10},{4,8,12},{0,8,12},{1,3,12},{1,3,9},{3,4,12},{3,4,11},{5,6,13},{5,6,9},{6,9,11},{3,9,11},{2,7,13},{2,7,8},{4,7,11},{4,7,8},{6,7,13},{6,7,11}}},

{97,
0,
0,
1,
{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
{{1,10,12},{0,10,12},{5,9,10},{1,9,10},{2,8,10},{0,8,10},{2,5,13},{2,5,10},{4,8,12},{0,8,12},{1,3,12},{1,3,9},{3,4,12},{3,4,11},{5,6,13},{5,6,9},{3,6,11},{3,6,9},{2,7,13},{2,7,8},{7,8,11},{4,8,11},{7,11,13},{6,11,13}}},

{98,
0,
0,
1,
{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
{{1,10,12},{0,10,12},{5,9,10},{1,9,10},{2,8,10},{0,8,10},{2,5,13},{2,5,10},{4,8,12},{0,8,12},{1,3,12},{1,3,9},{3,4,12},{3,4,11},{5,6,13},{5,6,9},{3,6,11},{3,6,9},{2,7,13},{2,7,8},{7,8,11},{4,8,11},{6,7,13},{6,7,11}}},

{99,
0,
0,
1,
{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
{{1,10,12},{0,10,12},{5,9,10},{1,9,10},{2,8,10},{0,8,10},{2,5,13},{2,5,10},{4,8,12},{0,8,12},{1,3,12},{1,3,9},{3,4,12},{3,4,11},{5,6,13},{5,6,9},{3,6,11},{3,6,9},{2,7,13},{2,7,8},{4,7,11},{4,7,8},{7,11,13},{6,11,13}}},

{100,
0,
0,
1,
{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
{{1,10,12},{0,10,12},{5,9,10},{1,9,10},{2,8,10},{0,8,10},{2,5,13},{2,5,10},{4,8,12},{0,8,12},{1,3,12},{1,3,9},{3,4,12},{3,4,11},{5,6,13},{5,6,9},{3,6,11},{3,6,9},{2,7,13},{2,7,8},{4,7,11},{4,7,8},{6,7,13},{6,7,11}}},

{101,
0,
0,
1,
{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
{{1,10,12},{0,10,12},{5,9,10},{1,9,10},{2,8,10},{0,8,10},{2,5,13},{2,5,10},{0,4,12},{0,4,8},{3,9,12},{1,9,12},{4,11,12},{3,11,12},{6,9,13},{5,9,13},{3,6,11},{3,6,9},{7,8,13},{2,8,13},{7,8,11},{4,8,11},{7,11,13},{6,11,13}}},

{102,
0,
0,
1,
{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
{{1,10,12},{0,10,12},{5,9,10},{1,9,10},{2,8,10},{0,8,10},{2,5,13},{2,5,10},{0,4,12},{0,4,8},{3,9,12},{1,9,12},{4,11,12},{3,11,12},{6,9,13},{5,9,13},{3,6,11},{3,6,9},{7,8,13},{2,8,13},{7,8,11},{4,8,11},{6,7,13},{6,7,11}}},

{103,
0,
0,
1,
{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
{{1,10,12},{0,10,12},{5,9,10},{1,9,10},{2,8,10},{0,8,10},{2,5,13},{2,5,10},{0,4,12},{0,4,8},{3,9,12},{1,9,12},{4,11,12},{3,11,12},{6,9,13},{5,9,13},{3,6,11},{3,6,9},{7,8,13},{2,8,13},{4,7,11},{4,7,8},{6,7,13},{6,7,11}}},

{104,
0,
0,
1,
{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
{{1,10,12},{0,10,12},{5,9,10},{1,9,10},{2,8,10},{0,8,10},{2,5,13},{2,5,10},{0,4,12},{0,4,8},{3,9,12},{1,9,12},{4,11,12},{3,11,12},{6,9,13},{5,9,13},{3,6,11},{3,6,9},{2,7,13},{2,7,8},{4,7,11},{4,7,8},{6,7,13},{6,7,11}}},

{105,
0,
0,
1,
{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
{{1,10,12},{0,10,12},{5,9,10},{1,9,10},{2,8,10},{0,8,10},{2,5,13},{2,5,10},{0,4,12},{0,4,8},{3,9,12},{1,9,12},{4,11,12},{3,11,12},{5,6,13},{5,6,9},{3,6,11},{3,6,9},{7,8,13},{2,8,13},{7,8,11},{4,8,11},{7,11,13},{6,11,13}}},

{106,
0,
0,
1,
{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
{{1,10,12},{0,10,12},{5,9,10},{1,9,10},{2,8,10},{0,8,10},{2,5,13},{2,5,10},{0,4,12},{0,4,8},{3,9,12},{1,9,12},{4,11,12},{3,11,12},{5,6,13},{5,6,9},{3,6,11},{3,6,9},{7,8,13},{2,8,13},{7,8,11},{4,8,11},{6,7,13},{6,7,11}}},

{107,
0,
0,
1,
{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
{{1,10,12},{0,10,12},{5,9,10},{1,9,10},{2,8,10},{0,8,10},{2,5,13},{2,5,10},{0,4,12},{0,4,8},{3,9,12},{1,9,12},{4,11,12},{3,11,12},{5,6,13},{5,6,9},{3,6,11},{3,6,9},{7,8,13},{2,8,13},{4,7,11},{4,7,8},{7,11,13},{6,11,13}}},

{108,
0,
0,
1,
{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
{{1,10,12},{0,10,12},{5,9,10},{1,9,10},{2,8,10},{0,8,10},{2,5,13},{2,5,10},{0,4,12},{0,4,8},{3,9,12},{1,9,12},{4,11,12},{3,11,12},{5,6,13},{5,6,9},{3,6,11},{3,6,9},{7,8,13},{2,8,13},{4,7,11},{4,7,8},{6,7,13},{6,7,11}}},

{109,
0,
0,
1,
{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
{{1,10,12},{0,10,12},{5,9,10},{1,9,10},{2,8,10},{0,8,10},{2,5,13},{2,5,10},{0,4,12},{0,4,8},{3,9,12},{1,9,12},{4,11,12},{3,11,12},{5,6,13},{5,6,9},{3,6,11},{3,6,9},{2,7,13},{2,7,8},{7,8,11},{4,8,11},{7,11,13},{6,11,13}}},

{110,
0,
0,
1,
{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
{{1,10,12},{0,10,12},{5,9,10},{1,9,10},{2,8,10},{0,8,10},{2,5,13},{2,5,10},{0,4,12},{0,4,8},{3,9,12},{1,9,12},{4,11,12},{3,11,12},{5,6,13},{5,6,9},{3,6,11},{3,6,9},{2,7,13},{2,7,8},{7,8,11},{4,8,11},{6,7,13},{6,7,11}}},

{111,
0,
0,
1,
{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
{{1,10,12},{0,10,12},{5,9,10},{1,9,10},{2,8,10},{0,8,10},{2,5,13},{2,5,10},{0,4,12},{0,4,8},{3,9,12},{1,9,12},{4,11,12},{3,11,12},{5,6,13},{5,6,9},{3,6,11},{3,6,9},{2,7,13},{2,7,8},{4,7,11},{4,7,8},{7,11,13},{6,11,13}}},

{112,
0,
0,
1,
{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
{{1,10,12},{0,10,12},{5,9,10},{1,9,10},{2,8,10},{0,8,10},{2,5,13},{2,5,10},{0,4,12},{0,4,8},{3,9,12},{1,9,12},{4,11,12},{3,11,12},{5,6,13},{5,6,9},{3,6,11},{3,6,9},{2,7,13},{2,7,8},{4,7,11},{4,7,8},{6,7,13},{6,7,11}}},

{113,
0,
0,
1,
{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
{{1,10,12},{0,10,12},{5,9,10},{1,9,10},{2,8,10},{0,8,10},{2,5,13},{2,5,10},{0,4,12},{0,4,8},{3,9,12},{1,9,12},{3,4,12},{3,4,11},{5,6,13},{5,6,9},{3,6,11},{3,6,9},{7,8,13},{2,8,13},{7,8,11},{4,8,11},{7,11,13},{6,11,13}}},

{114,
0,
0,
1,
{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
{{1,10,12},{0,10,12},{5,9,10},{1,9,10},{2,8,10},{0,8,10},{2,5,13},{2,5,10},{0,4,12},{0,4,8},{3,9,12},{1,9,12},{3,4,12},{3,4,11},{5,6,13},{5,6,9},{3,6,11},{3,6,9},{7,8,13},{2,8,13},{7,8,11},{4,8,11},{6,7,13},{6,7,11}}},

{115,
0,
0,
1,
{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
{{1,10,12},{0,10,12},{5,9,10},{1,9,10},{2,8,10},{0,8,10},{2,5,13},{2,5,10},{0,4,12},{0,4,8},{3,9,12},{1,9,12},{3,4,12},{3,4,11},{5,6,13},{5,6,9},{3,6,11},{3,6,9},{7,8,13},{2,8,13},{4,7,11},{4,7,8},{7,11,13},{6,11,13}}},

{116,
0,
0,
1,
{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
{{1,10,12},{0,10,12},{5,9,10},{1,9,10},{2,8,10},{0,8,10},{2,5,13},{2,5,10},{0,4,12},{0,4,8},{3,9,12},{1,9,12},{3,4,12},{3,4,11},{5,6,13},{5,6,9},{3,6,11},{3,6,9},{7,8,13},{2,8,13},{4,7,11},{4,7,8},{6,7,13},{6,7,11}}},

{117,
0,
0,
1,
{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
{{1,10,12},{0,10,12},{5,9,10},{1,9,10},{2,8,10},{0,8,10},{2,5,13},{2,5,10},{0,4,12},{0,4,8},{3,9,12},{1,9,12},{3,4,12},{3,4,11},{5,6,13},{5,6,9},{3,6,11},{3,6,9},{2,7,13},{2,7,8},{7,8,11},{4,8,11},{7,11,13},{6,11,13}}},

{118,
0,
0,
1,
{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
{{1,10,12},{0,10,12},{5,9,10},{1,9,10},{2,8,10},{0,8,10},{2,5,13},{2,5,10},{0,4,12},{0,4,8},{3,9,12},{1,9,12},{3,4,12},{3,4,11},{5,6,13},{5,6,9},{3,6,11},{3,6,9},{2,7,13},{2,7,8},{7,8,11},{4,8,11},{6,7,13},{6,7,11}}},

{119,
0,
0,
1,
{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
{{1,10,12},{0,10,12},{5,9,10},{1,9,10},{2,8,10},{0,8,10},{2,5,13},{2,5,10},{0,4,12},{0,4,8},{3,9,12},{1,9,12},{3,4,12},{3,4,11},{5,6,13},{5,6,9},{3,6,11},{3,6,9},{2,7,13},{2,7,8},{4,7,11},{4,7,8},{7,11,13},{6,11,13}}},

{120,
0,
0,
1,
{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
{{1,10,12},{0,10,12},{5,9,10},{1,9,10},{2,8,10},{0,8,10},{2,5,13},{2,5,10},{0,4,12},{0,4,8},{3,9,12},{1,9,12},{3,4,12},{3,4,11},{5,6,13},{5,6,9},{3,6,11},{3,6,9},{2,7,13},{2,7,8},{4,7,11},{4,7,8},{6,7,13},{6,7,11}}},

{121,
0,
0,
1,
{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
{{1,10,12},{0,10,12},{5,9,10},{1,9,10},{2,8,10},{0,8,10},{2,5,13},{2,5,10},{0,4,12},{0,4,8},{1,3,12},{1,3,9},{4,11,12},{3,11,12},{6,9,13},{5,9,13},{6,9,11},{3,9,11},{7,8,13},{2,8,13},{7,8,11},{4,8,11},{6,7,13},{6,7,11}}},

{122,
0,
0,
1,
{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
{{1,10,12},{0,10,12},{5,9,10},{1,9,10},{2,8,10},{0,8,10},{2,5,13},{2,5,10},{0,4,12},{0,4,8},{1,3,12},{1,3,9},{4,11,12},{3,11,12},{6,9,13},{5,9,13},{6,9,11},{3,9,11},{7,8,13},{2,8,13},{4,7,11},{4,7,8},{6,7,13},{6,7,11}}},

{123,
0,
0,
1,
{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
{{1,10,12},{0,10,12},{5,9,10},{1,9,10},{2,8,10},{0,8,10},{2,5,13},{2,5,10},{0,4,12},{0,4,8},{1,3,12},{1,3,9},{4,11,12},{3,11,12},{6,9,13},{5,9,13},{6,9,11},{3,9,11},{2,7,13},{2,7,8},{7,8,11},{4,8,11},{6,7,13},{6,7,11}}},

{124,
0,
0,
1,
{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
{{1,10,12},{0,10,12},{5,9,10},{1,9,10},{2,8,10},{0,8,10},{2,5,13},{2,5,10},{0,4,12},{0,4,8},{1,3,12},{1,3,9},{4,11,12},{3,11,12},{6,9,13},{5,9,13},{6,9,11},{3,9,11},{2,7,13},{2,7,8},{4,7,11},{4,7,8},{6,7,13},{6,7,11}}},

{125,
0,
0,
1,
{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
{{1,10,12},{0,10,12},{5,9,10},{1,9,10},{2,8,10},{0,8,10},{2,5,13},{2,5,10},{0,4,12},{0,4,8},{1,3,12},{1,3,9},{4,11,12},{3,11,12},{6,9,13},{5,9,13},{3,6,11},{3,6,9},{7,8,13},{2,8,13},{7,8,11},{4,8,11},{6,7,13},{6,7,11}}},

{126,
0,
0,
1,
{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
{{1,10,12},{0,10,12},{5,9,10},{1,9,10},{2,8,10},{0,8,10},{2,5,13},{2,5,10},{0,4,12},{0,4,8},{1,3,12},{1,3,9},{4,11,12},{3,11,12},{6,9,13},{5,9,13},{3,6,11},{3,6,9},{7,8,13},{2,8,13},{4,7,11},{4,7,8},{7,11,13},{6,11,13}}},

{127,
0,
0,
1,
{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
{{1,10,12},{0,10,12},{5,9,10},{1,9,10},{2,8,10},{0,8,10},{2,5,13},{2,5,10},{0,4,12},{0,4,8},{1,3,12},{1,3,9},{4,11,12},{3,11,12},{6,9,13},{5,9,13},{3,6,11},{3,6,9},{7,8,13},{2,8,13},{4,7,11},{4,7,8},{6,7,13},{6,7,11}}},

{128,
0,
0,
1,
{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
{{1,10,12},{0,10,12},{5,9,10},{1,9,10},{2,8,10},{0,8,10},{2,5,13},{2,5,10},{0,4,12},{0,4,8},{1,3,12},{1,3,9},{4,11,12},{3,11,12},{6,9,13},{5,9,13},{3,6,11},{3,6,9},{2,7,13},{2,7,8},{7,8,11},{4,8,11},{7,11,13},{6,11,13}}},

{129,
0,
0,
1,
{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
{{1,10,12},{0,10,12},{5,9,10},{1,9,10},{2,8,10},{0,8,10},{2,5,13},{2,5,10},{0,4,12},{0,4,8},{1,3,12},{1,3,9},{4,11,12},{3,11,12},{6,9,13},{5,9,13},{3,6,11},{3,6,9},{2,7,13},{2,7,8},{7,8,11},{4,8,11},{6,7,13},{6,7,11}}},

{130,
0,
0,
1,
{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
{{1,10,12},{0,10,12},{5,9,10},{1,9,10},{2,8,10},{0,8,10},{2,5,13},{2,5,10},{0,4,12},{0,4,8},{1,3,12},{1,3,9},{4,11,12},{3,11,12},{6,9,13},{5,9,13},{3,6,11},{3,6,9},{2,7,13},{2,7,8},{4,7,11},{4,7,8},{7,11,13},{6,11,13}}},

{131,
0,
0,
1,
{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
{{1,10,12},{0,10,12},{5,9,10},{1,9,10},{2,8,10},{0,8,10},{2,5,13},{2,5,10},{0,4,12},{0,4,8},{1,3,12},{1,3,9},{4,11,12},{3,11,12},{6,9,13},{5,9,13},{3,6,11},{3,6,9},{2,7,13},{2,7,8},{4,7,11},{4,7,8},{6,7,13},{6,7,11}}},

{132,
0,
0,
1,
{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
{{1,10,12},{0,10,12},{5,9,10},{1,9,10},{2,8,10},{0,8,10},{2,5,13},{2,5,10},{0,4,12},{0,4,8},{1,3,12},{1,3,9},{4,11,12},{3,11,12},{5,6,13},{5,6,9},{6,9,11},{3,9,11},{7,8,13},{2,8,13},{4,7,11},{4,7,8},{7,11,13},{6,11,13}}},

{133,
0,
0,
1,
{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
{{1,10,12},{0,10,12},{5,9,10},{1,9,10},{2,8,10},{0,8,10},{2,5,13},{2,5,10},{0,4,12},{0,4,8},{1,3,12},{1,3,9},{4,11,12},{3,11,12},{5,6,13},{5,6,9},{6,9,11},{3,9,11},{7,8,13},{2,8,13},{4,7,11},{4,7,8},{6,7,13},{6,7,11}}},

{134,
0,
0,
1,
{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
{{1,10,12},{0,10,12},{5,9,10},{1,9,10},{2,8,10},{0,8,10},{2,5,13},{2,5,10},{0,4,12},{0,4,8},{1,3,12},{1,3,9},{4,11,12},{3,11,12},{5,6,13},{5,6,9},{6,9,11},{3,9,11},{2,7,13},{2,7,8},{7,8,11},{4,8,11},{6,7,13},{6,7,11}}},

{135,
0,
0,
1,
{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
{{1,10,12},{0,10,12},{5,9,10},{1,9,10},{2,8,10},{0,8,10},{2,5,13},{2,5,10},{0,4,12},{0,4,8},{1,3,12},{1,3,9},{4,11,12},{3,11,12},{5,6,13},{5,6,9},{6,9,11},{3,9,11},{2,7,13},{2,7,8},{4,7,11},{4,7,8},{7,11,13},{6,11,13}}},

{136,
0,
0,
1,
{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
{{1,10,12},{0,10,12},{5,9,10},{1,9,10},{2,8,10},{0,8,10},{2,5,13},{2,5,10},{0,4,12},{0,4,8},{1,3,12},{1,3,9},{4,11,12},{3,11,12},{5,6,13},{5,6,9},{6,9,11},{3,9,11},{2,7,13},{2,7,8},{4,7,11},{4,7,8},{6,7,13},{6,7,11}}},

{137,
0,
0,
1,
{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
{{1,10,12},{0,10,12},{5,9,10},{1,9,10},{2,8,10},{0,8,10},{2,5,13},{2,5,10},{0,4,12},{0,4,8},{1,3,12},{1,3,9},{4,11,12},{3,11,12},{5,6,13},{5,6,9},{3,6,11},{3,6,9},{7,8,13},{2,8,13},{7,8,11},{4,8,11},{6,7,13},{6,7,11}}},

{138,
0,
0,
1,
{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
{{1,10,12},{0,10,12},{5,9,10},{1,9,10},{2,8,10},{0,8,10},{2,5,13},{2,5,10},{0,4,12},{0,4,8},{1,3,12},{1,3,9},{4,11,12},{3,11,12},{5,6,13},{5,6,9},{3,6,11},{3,6,9},{7,8,13},{2,8,13},{4,7,11},{4,7,8},{7,11,13},{6,11,13}}},

{139,
0,
0,
1,
{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
{{1,10,12},{0,10,12},{5,9,10},{1,9,10},{2,8,10},{0,8,10},{2,5,13},{2,5,10},{0,4,12},{0,4,8},{1,3,12},{1,3,9},{4,11,12},{3,11,12},{5,6,13},{5,6,9},{3,6,11},{3,6,9},{7,8,13},{2,8,13},{4,7,11},{4,7,8},{6,7,13},{6,7,11}}},

{140,
0,
0,
1,
{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
{{1,10,12},{0,10,12},{5,9,10},{1,9,10},{2,8,10},{0,8,10},{2,5,13},{2,5,10},{0,4,12},{0,4,8},{1,3,12},{1,3,9},{4,11,12},{3,11,12},{5,6,13},{5,6,9},{3,6,11},{3,6,9},{2,7,13},{2,7,8},{7,8,11},{4,8,11},{7,11,13},{6,11,13}}},

{141,
0,
0,
1,
{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
{{1,10,12},{0,10,12},{5,9,10},{1,9,10},{2,8,10},{0,8,10},{2,5,13},{2,5,10},{0,4,12},{0,4,8},{1,3,12},{1,3,9},{4,11,12},{3,11,12},{5,6,13},{5,6,9},{3,6,11},{3,6,9},{2,7,13},{2,7,8},{7,8,11},{4,8,11},{6,7,13},{6,7,11}}},

{142,
0,
0,
1,
{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
{{1,10,12},{0,10,12},{5,9,10},{1,9,10},{2,8,10},{0,8,10},{2,5,13},{2,5,10},{0,4,12},{0,4,8},{1,3,12},{1,3,9},{4,11,12},{3,11,12},{5,6,13},{5,6,9},{3,6,11},{3,6,9},{2,7,13},{2,7,8},{4,7,11},{4,7,8},{7,11,13},{6,11,13}}},

{143,
0,
0,
1,
{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
{{1,10,12},{0,10,12},{5,9,10},{1,9,10},{2,8,10},{0,8,10},{2,5,13},{2,5,10},{0,4,12},{0,4,8},{1,3,12},{1,3,9},{4,11,12},{3,11,12},{5,6,13},{5,6,9},{3,6,11},{3,6,9},{2,7,13},{2,7,8},{4,7,11},{4,7,8},{6,7,13},{6,7,11}}},

{144,
0,
0,
1,
{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
{{1,10,12},{0,10,12},{5,9,10},{1,9,10},{2,8,10},{0,8,10},{2,5,13},{2,5,10},{0,4,12},{0,4,8},{1,3,12},{1,3,9},{3,4,12},{3,4,11},{6,9,13},{5,9,13},{6,9,11},{3,9,11},{2,7,13},{2,7,8},{7,8,11},{4,8,11},{6,7,13},{6,7,11}}},

{145,
0,
0,
1,
{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
{{1,10,12},{0,10,12},{5,9,10},{1,9,10},{2,8,10},{0,8,10},{2,5,13},{2,5,10},{0,4,12},{0,4,8},{1,3,12},{1,3,9},{3,4,12},{3,4,11},{6,9,13},{5,9,13},{6,9,11},{3,9,11},{2,7,13},{2,7,8},{4,7,11},{4,7,8},{6,7,13},{6,7,11}}},

{146,
0,
0,
1,
{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
{{1,10,12},{0,10,12},{5,9,10},{1,9,10},{2,8,10},{0,8,10},{2,5,13},{2,5,10},{0,4,12},{0,4,8},{1,3,12},{1,3,9},{3,4,12},{3,4,11},{6,9,13},{5,9,13},{3,6,11},{3,6,9},{7,8,13},{2,8,13},{4,7,11},{4,7,8},{7,11,13},{6,11,13}}},

{147,
0,
0,
1,
{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
{{1,10,12},{0,10,12},{5,9,10},{1,9,10},{2,8,10},{0,8,10},{2,5,13},{2,5,10},{0,4,12},{0,4,8},{1,3,12},{1,3,9},{3,4,12},{3,4,11},{6,9,13},{5,9,13},{3,6,11},{3,6,9},{7,8,13},{2,8,13},{4,7,11},{4,7,8},{6,7,13},{6,7,11}}},

{148,
0,
0,
1,
{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
{{1,10,12},{0,10,12},{5,9,10},{1,9,10},{2,8,10},{0,8,10},{2,5,13},{2,5,10},{0,4,12},{0,4,8},{1,3,12},{1,3,9},{3,4,12},{3,4,11},{6,9,13},{5,9,13},{3,6,11},{3,6,9},{2,7,13},{2,7,8},{7,8,11},{4,8,11},{7,11,13},{6,11,13}}},

{149,
0,
0,
1,
{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
{{1,10,12},{0,10,12},{5,9,10},{1,9,10},{2,8,10},{0,8,10},{2,5,13},{2,5,10},{0,4,12},{0,4,8},{1,3,12},{1,3,9},{3,4,12},{3,4,11},{6,9,13},{5,9,13},{3,6,11},{3,6,9},{2,7,13},{2,7,8},{7,8,11},{4,8,11},{6,7,13},{6,7,11}}},

{150,
0,
0,
1,
{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
{{1,10,12},{0,10,12},{5,9,10},{1,9,10},{2,8,10},{0,8,10},{2,5,13},{2,5,10},{0,4,12},{0,4,8},{1,3,12},{1,3,9},{3,4,12},{3,4,11},{6,9,13},{5,9,13},{3,6,11},{3,6,9},{2,7,13},{2,7,8},{4,7,11},{4,7,8},{7,11,13},{6,11,13}}},

{151,
0,
0,
1,
{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
{{1,10,12},{0,10,12},{5,9,10},{1,9,10},{2,8,10},{0,8,10},{2,5,13},{2,5,10},{0,4,12},{0,4,8},{1,3,12},{1,3,9},{3,4,12},{3,4,11},{6,9,13},{5,9,13},{3,6,11},{3,6,9},{2,7,13},{2,7,8},{4,7,11},{4,7,8},{6,7,13},{6,7,11}}},

{152,
0,
0,
1,
{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
{{1,10,12},{0,10,12},{5,9,10},{1,9,10},{2,8,10},{0,8,10},{2,5,13},{2,5,10},{0,4,12},{0,4,8},{1,3,12},{1,3,9},{3,4,12},{3,4,11},{5,6,13},{5,6,9},{6,9,11},{3,9,11},{7,8,13},{2,8,13},{7,8,11},{4,8,11},{6,7,13},{6,7,11}}},

{153,
0,
0,
1,
{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
{{1,10,12},{0,10,12},{5,9,10},{1,9,10},{2,8,10},{0,8,10},{2,5,13},{2,5,10},{0,4,12},{0,4,8},{1,3,12},{1,3,9},{3,4,12},{3,4,11},{5,6,13},{5,6,9},{6,9,11},{3,9,11},{7,8,13},{2,8,13},{4,7,11},{4,7,8},{7,11,13},{6,11,13}}},

{154,
0,
0,
1,
{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
{{1,10,12},{0,10,12},{5,9,10},{1,9,10},{2,8,10},{0,8,10},{2,5,13},{2,5,10},{0,4,12},{0,4,8},{1,3,12},{1,3,9},{3,4,12},{3,4,11},{5,6,13},{5,6,9},{6,9,11},{3,9,11},{7,8,13},{2,8,13},{4,7,11},{4,7,8},{6,7,13},{6,7,11}}},

{155,
0,
0,
1,
{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
{{1,10,12},{0,10,12},{5,9,10},{1,9,10},{2,8,10},{0,8,10},{2,5,13},{2,5,10},{0,4,12},{0,4,8},{1,3,12},{1,3,9},{3,4,12},{3,4,11},{5,6,13},{5,6,9},{6,9,11},{3,9,11},{2,7,13},{2,7,8},{7,8,11},{4,8,11},{7,11,13},{6,11,13}}},

{156,
0,
0,
1,
{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
{{1,10,12},{0,10,12},{5,9,10},{1,9,10},{2,8,10},{0,8,10},{2,5,13},{2,5,10},{0,4,12},{0,4,8},{1,3,12},{1,3,9},{3,4,12},{3,4,11},{5,6,13},{5,6,9},{6,9,11},{3,9,11},{2,7,13},{2,7,8},{7,8,11},{4,8,11},{6,7,13},{6,7,11}}},

{157,
0,
0,
1,
{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
{{1,10,12},{0,10,12},{5,9,10},{1,9,10},{2,8,10},{0,8,10},{2,5,13},{2,5,10},{0,4,12},{0,4,8},{1,3,12},{1,3,9},{3,4,12},{3,4,11},{5,6,13},{5,6,9},{6,9,11},{3,9,11},{2,7,13},{2,7,8},{4,7,11},{4,7,8},{7,11,13},{6,11,13}}},

{158,
0,
0,
1,
{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
{{1,10,12},{0,10,12},{5,9,10},{1,9,10},{2,8,10},{0,8,10},{2,5,13},{2,5,10},{0,4,12},{0,4,8},{1,3,12},{1,3,9},{3,4,12},{3,4,11},{5,6,13},{5,6,9},{6,9,11},{3,9,11},{2,7,13},{2,7,8},{4,7,11},{4,7,8},{6,7,13},{6,7,11}}},

{159,
0,
0,
1,
{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
{{1,10,12},{0,10,12},{5,9,10},{1,9,10},{2,8,10},{0,8,10},{2,5,13},{2,5,10},{0,4,12},{0,4,8},{1,3,12},{1,3,9},{3,4,12},{3,4,11},{5,6,13},{5,6,9},{3,6,11},{3,6,9},{7,8,13},{2,8,13},{7,8,11},{4,8,11},{6,7,13},{6,7,11}}},

{160,
0,
0,
1,
{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
{{1,10,12},{0,10,12},{5,9,10},{1,9,10},{2,8,10},{0,8,10},{2,5,13},{2,5,10},{0,4,12},{0,4,8},{1,3,12},{1,3,9},{3,4,12},{3,4,11},{5,6,13},{5,6,9},{3,6,11},{3,6,9},{7,8,13},{2,8,13},{4,7,11},{4,7,8},{7,11,13},{6,11,13}}},

{161,
0,
0,
1,
{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
{{1,10,12},{0,10,12},{5,9,10},{1,9,10},{2,8,10},{0,8,10},{2,5,13},{2,5,10},{0,4,12},{0,4,8},{1,3,12},{1,3,9},{3,4,12},{3,4,11},{5,6,13},{5,6,9},{3,6,11},{3,6,9},{7,8,13},{2,8,13},{4,7,11},{4,7,8},{6,7,13},{6,7,11}}},

{162,
0,
0,
1,
{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
{{1,10,12},{0,10,12},{5,9,10},{1,9,10},{2,8,10},{0,8,10},{2,5,13},{2,5,10},{0,4,12},{0,4,8},{1,3,12},{1,3,9},{3,4,12},{3,4,11},{5,6,13},{5,6,9},{3,6,11},{3,6,9},{2,7,13},{2,7,8},{7,8,11},{4,8,11},{7,11,13},{6,11,13}}},

{163,
0,
0,
1,
{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
{{1,10,12},{0,10,12},{5,9,10},{1,9,10},{2,8,10},{0,8,10},{2,5,13},{2,5,10},{0,4,12},{0,4,8},{1,3,12},{1,3,9},{3,4,12},{3,4,11},{5,6,13},{5,6,9},{3,6,11},{3,6,9},{2,7,13},{2,7,8},{7,8,11},{4,8,11},{6,7,13},{6,7,11}}},

{164,
0,
0,
1,
{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
{{1,10,12},{0,10,12},{5,9,10},{1,9,10},{2,8,10},{0,8,10},{2,5,13},{2,5,10},{0,4,12},{0,4,8},{1,3,12},{1,3,9},{3,4,12},{3,4,11},{5,6,13},{5,6,9},{3,6,11},{3,6,9},{2,7,13},{2,7,8},{4,7,11},{4,7,8},{7,11,13},{6,11,13}}},

{165,
0,
0,
1,
{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
{{1,10,12},{0,10,12},{5,9,10},{1,9,10},{2,8,10},{0,8,10},{2,5,13},{2,5,10},{0,4,12},{0,4,8},{1,3,12},{1,3,9},{3,4,12},{3,4,11},{5,6,13},{5,6,9},{3,6,11},{3,6,9},{2,7,13},{2,7,8},{4,7,11},{4,7,8},{6,7,13},{6,7,11}}},

{166,
0,
0,
1,
{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
{{1,10,12},{0,10,12},{5,9,10},{1,9,10},{0,2,10},{0,2,8},{2,5,13},{2,5,10},{4,8,12},{0,8,12},{1,3,12},{1,3,9},{3,4,12},{3,4,11},{6,9,13},{5,9,13},{3,6,11},{3,6,9},{7,8,13},{2,8,13},{4,7,11},{4,7,8},{6,7,13},{6,7,11}}},

{167,
0,
32,
4,
{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
{{1,10,12},{0,10,12},{5,9,10},{1,9,10},{0,2,10},{0,2,8},{2,5,13},{2,5,10},{4,8,12},{0,8,12},{1,3,12},{1,3,9},{3,4,12},{3,4,11},{6,9,13},{5,9,13},{3,6,11},{3,6,9},{2,7,13},{2,7,8},{7,8,11},{4,8,11},{7,11,13},{6,11,13}}},

{168,
0,
0,
1,
{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
{{1,10,12},{0,10,12},{5,9,10},{1,9,10},{0,2,10},{0,2,8},{2,5,13},{2,5,10},{4,8,12},{0,8,12},{1,3,12},{1,3,9},{3,4,12},{3,4,11},{6,9,13},{5,9,13},{3,6,11},{3,6,9},{2,7,13},{2,7,8},{7,8,11},{4,8,11},{6,7,13},{6,7,11}}},

{169,
0,
0,
1,
{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
{{1,10,12},{0,10,12},{5,9,10},{1,9,10},{0,2,10},{0,2,8},{2,5,13},{2,5,10},{4,8,12},{0,8,12},{1,3,12},{1,3,9},{3,4,12},{3,4,11},{6,9,13},{5,9,13},{3,6,11},{3,6,9},{2,7,13},{2,7,8},{4,7,11},{4,7,8},{7,11,13},{6,11,13}}},

{170,
0,
0,
1,
{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
{{1,10,12},{0,10,12},{5,9,10},{1,9,10},{0,2,10},{0,2,8},{2,5,13},{2,5,10},{4,8,12},{0,8,12},{1,3,12},{1,3,9},{3,4,12},{3,4,11},{6,9,13},{5,9,13},{3,6,11},{3,6,9},{2,7,13},{2,7,8},{4,7,11},{4,7,8},{6,7,13},{6,7,11}}},

{171,
0,
0,
1,
{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
{{1,10,12},{0,10,12},{5,9,10},{1,9,10},{0,2,10},{0,2,8},{2,5,13},{2,5,10},{4,8,12},{0,8,12},{1,3,12},{1,3,9},{3,4,12},{3,4,11},{5,6,13},{5,6,9},{6,9,11},{3,9,11},{7,8,13},{2,8,13},{4,7,11},{4,7,8},{7,11,13},{6,11,13}}},

{172,
0,
0,
1,
{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
{{1,10,12},{0,10,12},{5,9,10},{1,9,10},{0,2,10},{0,2,8},{2,5,13},{2,5,10},{4,8,12},{0,8,12},{1,3,12},{1,3,9},{3,4,12},{3,4,11},{5,6,13},{5,6,9},{6,9,11},{3,9,11},{7,8,13},{2,8,13},{4,7,11},{4,7,8},{6,7,13},{6,7,11}}},

{173,
0,
0,
1,
{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
{{1,10,12},{0,10,12},{5,9,10},{1,9,10},{0,2,10},{0,2,8},{2,5,13},{2,5,10},{4,8,12},{0,8,12},{1,3,12},{1,3,9},{3,4,12},{3,4,11},{5,6,13},{5,6,9},{6,9,11},{3,9,11},{2,7,13},{2,7,8},{4,7,11},{4,7,8},{7,11,13},{6,11,13}}},

{174,
0,
0,
1,
{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
{{1,10,12},{0,10,12},{5,9,10},{1,9,10},{0,2,10},{0,2,8},{2,5,13},{2,5,10},{4,8,12},{0,8,12},{1,3,12},{1,3,9},{3,4,12},{3,4,11},{5,6,13},{5,6,9},{6,9,11},{3,9,11},{2,7,13},{2,7,8},{4,7,11},{4,7,8},{6,7,13},{6,7,11}}},

{175,
0,
0,
1,
{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
{{1,10,12},{0,10,12},{5,9,10},{1,9,10},{0,2,10},{0,2,8},{2,5,13},{2,5,10},{4,8,12},{0,8,12},{1,3,12},{1,3,9},{3,4,12},{3,4,11},{5,6,13},{5,6,9},{3,6,11},{3,6,9},{2,7,13},{2,7,8},{4,7,11},{4,7,8},{7,11,13},{6,11,13}}},

{176,
0,
36,
2,
{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
{{1,10,12},{0,10,12},{5,9,10},{1,9,10},{0,2,10},{0,2,8},{2,5,13},{2,5,10},{4,8,12},{0,8,12},{1,3,12},{1,3,9},{3,4,12},{3,4,11},{5,6,13},{5,6,9},{3,6,11},{3,6,9},{2,7,13},{2,7,8},{4,7,11},{4,7,8},{6,7,13},{6,7,11}}},

{177,
0,
0,
1,
{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
{{1,10,12},{0,10,12},{5,9,10},{1,9,10},{0,2,10},{0,2,8},{2,5,13},{2,5,10},{0,4,12},{0,4,8},{3,9,12},{1,9,12},{3,4,12},{3,4,11},{5,6,13},{5,6,9},{3,6,11},{3,6,9},{7,8,13},{2,8,13},{7,8,11},{4,8,11},{7,11,13},{6,11,13}}},

{178,
0,
0,
1,
{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
{{1,10,12},{0,10,12},{5,9,10},{1,9,10},{0,2,10},{0,2,8},{2,5,13},{2,5,10},{0,4,12},{0,4,8},{3,9,12},{1,9,12},{3,4,12},{3,4,11},{5,6,13},{5,6,9},{3,6,11},{3,6,9},{7,8,13},{2,8,13},{7,8,11},{4,8,11},{6,7,13},{6,7,11}}},

{179,
0,
0,
1,
{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
{{1,10,12},{0,10,12},{5,9,10},{1,9,10},{0,2,10},{0,2,8},{2,5,13},{2,5,10},{0,4,12},{0,4,8},{3,9,12},{1,9,12},{3,4,12},{3,4,11},{5,6,13},{5,6,9},{3,6,11},{3,6,9},{7,8,13},{2,8,13},{4,7,11},{4,7,8},{6,7,13},{6,7,11}}},

{180,
0,
0,
1,
{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
{{1,10,12},{0,10,12},{5,9,10},{1,9,10},{0,2,10},{0,2,8},{2,5,13},{2,5,10},{0,4,12},{0,4,8},{3,9,12},{1,9,12},{3,4,12},{3,4,11},{5,6,13},{5,6,9},{3,6,11},{3,6,9},{2,7,13},{2,7,8},{4,7,11},{4,7,8},{6,7,13},{6,7,11}}},

{181,
0,
0,
1,
{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
{{1,10,12},{0,10,12},{5,9,10},{1,9,10},{0,2,10},{0,2,8},{2,5,13},{2,5,10},{0,4,12},{0,4,8},{1,3,12},{1,3,9},{4,11,12},{3,11,12},{6,9,13},{5,9,13},{3,6,11},{3,6,9},{7,8,13},{2,8,13},{7,8,11},{4,8,11},{6,7,13},{6,7,11}}},

{182,
0,
0,
1,
{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
{{1,10,12},{0,10,12},{5,9,10},{1,9,10},{0,2,10},{0,2,8},{2,5,13},{2,5,10},{0,4,12},{0,4,8},{1,3,12},{1,3,9},{4,11,12},{3,11,12},{6,9,13},{5,9,13},{3,6,11},{3,6,9},{7,8,13},{2,8,13},{4,7,11},{4,7,8},{6,7,13},{6,7,11}}},

{183,
0,
0,
1,
{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
{{1,10,12},{0,10,12},{5,9,10},{1,9,10},{0,2,10},{0,2,8},{2,5,13},{2,5,10},{0,4,12},{0,4,8},{1,3,12},{1,3,9},{4,11,12},{3,11,12},{6,9,13},{5,9,13},{3,6,11},{3,6,9},{2,7,13},{2,7,8},{7,8,11},{4,8,11},{6,7,13},{6,7,11}}},

{184,
0,
0,
1,
{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
{{1,10,12},{0,10,12},{5,9,10},{1,9,10},{0,2,10},{0,2,8},{2,5,13},{2,5,10},{0,4,12},{0,4,8},{1,3,12},{1,3,9},{4,11,12},{3,11,12},{6,9,13},{5,9,13},{3,6,11},{3,6,9},{2,7,13},{2,7,8},{4,7,11},{4,7,8},{6,7,13},{6,7,11}}},

{185,
0,
0,
1,
{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
{{1,10,12},{0,10,12},{5,9,10},{1,9,10},{0,2,10},{0,2,8},{2,5,13},{2,5,10},{0,4,12},{0,4,8},{1,3,12},{1,3,9},{4,11,12},{3,11,12},{5,6,13},{5,6,9},{6,9,11},{3,9,11},{7,8,13},{2,8,13},{4,7,11},{4,7,8},{6,7,13},{6,7,11}}},

{186,
0,
0,
1,
{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
{{1,10,12},{0,10,12},{5,9,10},{1,9,10},{0,2,10},{0,2,8},{2,5,13},{2,5,10},{0,4,12},{0,4,8},{1,3,12},{1,3,9},{4,11,12},{3,11,12},{5,6,13},{5,6,9},{6,9,11},{3,9,11},{2,7,13},{2,7,8},{4,7,11},{4,7,8},{6,7,13},{6,7,11}}},

{187,
0,
0,
1,
{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
{{1,10,12},{0,10,12},{5,9,10},{1,9,10},{0,2,10},{0,2,8},{2,5,13},{2,5,10},{0,4,12},{0,4,8},{1,3,12},{1,3,9},{4,11,12},{3,11,12},{5,6,13},{5,6,9},{3,6,11},{3,6,9},{7,8,13},{2,8,13},{4,7,11},{4,7,8},{7,11,13},{6,11,13}}},

{188,
0,
0,
1,
{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
{{1,10,12},{0,10,12},{5,9,10},{1,9,10},{0,2,10},{0,2,8},{2,5,13},{2,5,10},{0,4,12},{0,4,8},{1,3,12},{1,3,9},{4,11,12},{3,11,12},{5,6,13},{5,6,9},{3,6,11},{3,6,9},{7,8,13},{2,8,13},{4,7,11},{4,7,8},{6,7,13},{6,7,11}}},

{189,
0,
0,
1,
{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
{{1,10,12},{0,10,12},{5,9,10},{1,9,10},{0,2,10},{0,2,8},{2,5,13},{2,5,10},{0,4,12},{0,4,8},{1,3,12},{1,3,9},{4,11,12},{3,11,12},{5,6,13},{5,6,9},{3,6,11},{3,6,9},{2,7,13},{2,7,8},{7,8,11},{4,8,11},{6,7,13},{6,7,11}}},

{190,
0,
0,
1,
{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
{{1,10,12},{0,10,12},{5,9,10},{1,9,10},{0,2,10},{0,2,8},{2,5,13},{2,5,10},{0,4,12},{0,4,8},{1,3,12},{1,3,9},{4,11,12},{3,11,12},{5,6,13},{5,6,9},{3,6,11},{3,6,9},{2,7,13},{2,7,8},{4,7,11},{4,7,8},{7,11,13},{6,11,13}}},

{191,
0,
0,
1,
{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
{{1,10,12},{0,10,12},{5,9,10},{1,9,10},{0,2,10},{0,2,8},{2,5,13},{2,5,10},{0,4,12},{0,4,8},{1,3,12},{1,3,9},{4,11,12},{3,11,12},{5,6,13},{5,6,9},{3,6,11},{3,6,9},{2,7,13},{2,7,8},{4,7,11},{4,7,8},{6,7,13},{6,7,11}}},

{192,
0,
0,
1,
{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
{{1,10,12},{0,10,12},{5,9,10},{1,9,10},{0,2,10},{0,2,8},{2,5,13},{2,5,10},{0,4,12},{0,4,8},{1,3,12},{1,3,9},{3,4,12},{3,4,11},{6,9,13},{5,9,13},{3,6,11},{3,6,9},{2,7,13},{2,7,8},{7,8,11},{4,8,11},{6,7,13},{6,7,11}}},

{193,
0,
38,
2,
{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
{{1,10,12},{0,10,12},{5,9,10},{1,9,10},{0,2,10},{0,2,8},{2,5,13},{2,5,10},{0,4,12},{0,4,8},{1,3,12},{1,3,9},{3,4,12},{3,4,11},{6,9,13},{5,9,13},{3,6,11},{3,6,9},{2,7,13},{2,7,8},{4,7,11},{4,7,8},{6,7,13},{6,7,11}}},

{194,
0,
0,
1,
{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
{{1,10,12},{0,10,12},{5,9,10},{1,9,10},{0,2,10},{0,2,8},{2,5,13},{2,5,10},{0,4,12},{0,4,8},{1,3,12},{1,3,9},{3,4,12},{3,4,11},{5,6,13},{5,6,9},{6,9,11},{3,9,11},{7,8,13},{2,8,13},{7,8,11},{4,8,11},{6,7,13},{6,7,11}}},

{195,
0,
0,
1,
{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
{{1,10,12},{0,10,12},{5,9,10},{1,9,10},{0,2,10},{0,2,8},{2,5,13},{2,5,10},{0,4,12},{0,4,8},{1,3,12},{1,3,9},{3,4,12},{3,4,11},{5,6,13},{5,6,9},{6,9,11},{3,9,11},{7,8,13},{2,8,13},{4,7,11},{4,7,8},{6,7,13},{6,7,11}}},

{196,
0,
0,
1,
{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
{{1,10,12},{0,10,12},{5,9,10},{1,9,10},{0,2,10},{0,2,8},{2,5,13},{2,5,10},{0,4,12},{0,4,8},{1,3,12},{1,3,9},{3,4,12},{3,4,11},{5,6,13},{5,6,9},{6,9,11},{3,9,11},{2,7,13},{2,7,8},{7,8,11},{4,8,11},{6,7,13},{6,7,11}}},

{197,
0,
0,
1,
{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
{{1,10,12},{0,10,12},{5,9,10},{1,9,10},{0,2,10},{0,2,8},{2,5,13},{2,5,10},{0,4,12},{0,4,8},{1,3,12},{1,3,9},{3,4,12},{3,4,11},{5,6,13},{5,6,9},{6,9,11},{3,9,11},{2,7,13},{2,7,8},{4,7,11},{4,7,8},{7,11,13},{6,11,13}}},

{198,
0,
0,
1,
{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
{{1,10,12},{0,10,12},{5,9,10},{1,9,10},{0,2,10},{0,2,8},{2,5,13},{2,5,10},{0,4,12},{0,4,8},{1,3,12},{1,3,9},{3,4,12},{3,4,11},{5,6,13},{5,6,9},{6,9,11},{3,9,11},{2,7,13},{2,7,8},{4,7,11},{4,7,8},{6,7,13},{6,7,11}}},

{199,
0,
0,
1,
{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
{{1,10,12},{0,10,12},{5,9,10},{1,9,10},{0,2,10},{0,2,8},{2,5,13},{2,5,10},{0,4,12},{0,4,8},{1,3,12},{1,3,9},{3,4,12},{3,4,11},{5,6,13},{5,6,9},{3,6,11},{3,6,9},{7,8,13},{2,8,13},{7,8,11},{4,8,11},{6,7,13},{6,7,11}}},

{200,
0,
0,
1,
{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
{{1,10,12},{0,10,12},{5,9,10},{1,9,10},{0,2,10},{0,2,8},{2,5,13},{2,5,10},{0,4,12},{0,4,8},{1,3,12},{1,3,9},{3,4,12},{3,4,11},{5,6,13},{5,6,9},{3,6,11},{3,6,9},{7,8,13},{2,8,13},{4,7,11},{4,7,8},{7,11,13},{6,11,13}}},

{201,
0,
0,
1,
{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
{{1,10,12},{0,10,12},{5,9,10},{1,9,10},{0,2,10},{0,2,8},{2,5,13},{2,5,10},{0,4,12},{0,4,8},{1,3,12},{1,3,9},{3,4,12},{3,4,11},{5,6,13},{5,6,9},{3,6,11},{3,6,9},{7,8,13},{2,8,13},{4,7,11},{4,7,8},{6,7,13},{6,7,11}}},

{202,
0,
40,
2,
{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
{{1,10,12},{0,10,12},{5,9,10},{1,9,10},{0,2,10},{0,2,8},{2,5,13},{2,5,10},{0,4,12},{0,4,8},{1,3,12},{1,3,9},{3,4,12},{3,4,11},{5,6,13},{5,6,9},{3,6,11},{3,6,9},{2,7,13},{2,7,8},{7,8,11},{4,8,11},{7,11,13},{6,11,13}}},

{203,
0,
42,
2,
{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
{{1,10,12},{0,10,12},{5,9,10},{1,9,10},{0,2,10},{0,2,8},{2,5,13},{2,5,10},{0,4,12},{0,4,8},{1,3,12},{1,3,9},{3,4,12},{3,4,11},{5,6,13},{5,6,9},{3,6,11},{3,6,9},{2,7,13},{2,7,8},{7,8,11},{4,8,11},{6,7,13},{6,7,11}}},

{204,
0,
44,
2,
{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
{{1,10,12},{0,10,12},{5,9,10},{1,9,10},{0,2,10},{0,2,8},{2,5,13},{2,5,10},{0,4,12},{0,4,8},{1,3,12},{1,3,9},{3,4,12},{3,4,11},{5,6,13},{5,6,9},{3,6,11},{3,6,9},{2,7,13},{2,7,8},{4,7,11},{4,7,8},{7,11,13},{6,11,13}}},

{205,
0,
0,
1,
{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
{{1,10,12},{0,10,12},{5,9,10},{1,9,10},{0,2,10},{0,2,8},{2,5,13},{2,5,10},{0,4,12},{0,4,8},{1,3,12},{1,3,9},{3,4,12},{3,4,11},{5,6,13},{5,6,9},{3,6,11},{3,6,9},{2,7,13},{2,7,8},{4,7,11},{4,7,8},{6,7,13},{6,7,11}}},

{206,
0,
0,
1,
{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
{{1,10,12},{0,10,12},{1,5,10},{1,5,9},{0,2,10},{0,2,8},{5,10,13},{2,10,13},{0,4,12},{0,4,8},{1,3,12},{1,3,9},{4,11,12},{3,11,12},{5,6,13},{5,6,9},{3,6,11},{3,6,9},{2,7,13},{2,7,8},{4,7,11},{4,7,8},{7,11,13},{6,11,13}}},

{207,
0,
0,
1,
{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
{{1,10,12},{0,10,12},{1,5,10},{1,5,9},{0,2,10},{0,2,8},{5,10,13},{2,10,13},{0,4,12},{0,4,8},{1,3,12},{1,3,9},{4,11,12},{3,11,12},{5,6,13},{5,6,9},{3,6,11},{3,6,9},{2,7,13},{2,7,8},{4,7,11},{4,7,8},{6,7,13},{6,7,11}}},

{208,
0,
46,
3,
{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
{{1,10,12},{0,10,12},{1,5,10},{1,5,9},{0,2,10},{0,2,8},{5,10,13},{2,10,13},{0,4,12},{0,4,8},{1,3,12},{1,3,9},{3,4,12},{3,4,11},{5,6,13},{5,6,9},{6,9,11},{3,9,11},{2,7,13},{2,7,8},{7,8,11},{4,8,11},{6,7,13},{6,7,11}}},

{209,
0,
0,
1,
{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
{{1,10,12},{0,10,12},{1,5,10},{1,5,9},{0,2,10},{0,2,8},{5,10,13},{2,10,13},{0,4,12},{0,4,8},{1,3,12},{1,3,9},{3,4,12},{3,4,11},{5,6,13},{5,6,9},{6,9,11},{3,9,11},{2,7,13},{2,7,8},{4,7,11},{4,7,8},{6,7,13},{6,7,11}}},

{210,
0,
0,
1,
{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
{{1,10,12},{0,10,12},{1,5,10},{1,5,9},{0,2,10},{0,2,8},{5,10,13},{2,10,13},{0,4,12},{0,4,8},{1,3,12},{1,3,9},{3,4,12},{3,4,11},{5,6,13},{5,6,9},{3,6,11},{3,6,9},{2,7,13},{2,7,8},{4,7,11},{4,7,8},{6,7,13},{6,7,11}}},

{211,
0,
49,
2,
{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
{{1,10,12},{0,10,12},{1,5,10},{1,5,9},{0,2,10},{0,2,8},{2,5,13},{2,5,10},{0,4,12},{0,4,8},{1,3,12},{1,3,9},{3,4,12},{3,4,11},{6,9,13},{5,9,13},{3,6,11},{3,6,9},{2,7,13},{2,7,8},{7,8,11},{4,8,11},{6,7,13},{6,7,11}}},

{212,
0,
0,
1,
{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
{{1,10,12},{0,10,12},{1,5,10},{1,5,9},{0,2,10},{0,2,8},{2,5,13},{2,5,10},{0,4,12},{0,4,8},{1,3,12},{1,3,9},{3,4,12},{3,4,11},{6,9,13},{5,9,13},{3,6,11},{3,6,9},{2,7,13},{2,7,8},{4,7,11},{4,7,8},{6,7,13},{6,7,11}}},

{213,
0,
51,
2,
{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
{{1,10,12},{0,10,12},{1,5,10},{1,5,9},{0,2,10},{0,2,8},{2,5,13},{2,5,10},{0,4,12},{0,4,8},{1,3,12},{1,3,9},{3,4,12},{3,4,11},{5,6,13},{5,6,9},{6,9,11},{3,9,11},{7,8,13},{2,8,13},{4,7,11},{4,7,8},{6,7,13},{6,7,11}}},

{214,
0,
0,
1,
{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
{{1,10,12},{0,10,12},{1,5,10},{1,5,9},{0,2,10},{0,2,8},{2,5,13},{2,5,10},{0,4,12},{0,4,8},{1,3,12},{1,3,9},{3,4,12},{3,4,11},{5,6,13},{5,6,9},{6,9,11},{3,9,11},{2,7,13},{2,7,8},{4,7,11},{4,7,8},{6,7,13},{6,7,11}}},

{215,
0,
0,
1,
{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
{{1,10,12},{0,10,12},{1,5,10},{1,5,9},{0,2,10},{0,2,8},{2,5,13},{2,5,10},{0,4,12},{0,4,8},{1,3,12},{1,3,9},{3,4,12},{3,4,11},{5,6,13},{5,6,9},{3,6,11},{3,6,9},{2,7,13},{2,7,8},{4,7,11},{4,7,8},{7,11,13},{6,11,13}}},

{216,
0,
0,
1,
{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
{{1,10,12},{0,10,12},{1,5,10},{1,5,9},{0,2,10},{0,2,8},{2,5,13},{2,5,10},{0,4,12},{0,4,8},{1,3,12},{1,3,9},{3,4,12},{3,4,11},{5,6,13},{5,6,9},{3,6,11},{3,6,9},{2,7,13},{2,7,8},{4,7,11},{4,7,8},{6,7,13},{6,7,11}}},

{217,
0,
0,
1,
{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
{{0,1,12},{0,1,10},{1,5,10},{1,5,9},{0,2,10},{0,2,8},{2,5,13},{2,5,10},{0,4,12},{0,4,8},{1,3,12},{1,3,9},{3,4,12},{3,4,11},{5,6,13},{5,6,9},{3,6,11},{3,6,9},{2,7,13},{2,7,8},{4,7,11},{4,7,8},{6,7,13},{6,7,11}}},

};

graph_t graphs_dcub[NUM_DCUB_GRAPHS] = {

{0,
0,
0,
1,
{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
{{0,4,5},{0,5,6},{0,4,6},{4,9,15},{5,12,14},{6,8,11},{1,7,8},{1,8,9},{1,7,9},{7,10,13},{2,10,11},{2,11,12},{2,10,12},{3,13,14},{3,14,15},{3,13,15},{7,9,15},{7,13,15},{4,6,8},{4,8,9},{10,12,14},{10,13,14},{4,5,14},{4,14,15},{5,6,11},{5,11,12},{7,8,11},{7,10,11}}},

{1,
0,
0,
1,
{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
{{0,4,5},{0,5,6},{0,4,6},{4,9,15},{5,12,14},{6,8,11},{1,7,8},{1,8,9},{1,7,9},{7,10,13},{2,10,11},{2,11,12},{2,10,12},{3,13,14},{3,14,15},{3,13,15},{7,9,15},{7,13,15},{4,6,8},{4,8,9},{10,12,14},{10,13,14},{4,5,14},{4,14,15},{5,6,11},{5,11,12},{7,8,10},{8,10,11}}},

{2,
0,
0,
1,
{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
{{0,4,5},{0,5,6},{0,4,6},{4,9,15},{5,12,14},{6,8,11},{1,7,8},{1,8,9},{1,7,9},{7,10,13},{2,10,11},{2,11,12},{2,10,12},{3,13,14},{3,14,15},{3,13,15},{7,9,15},{7,13,15},{4,6,8},{4,8,9},{10,12,14},{10,13,14},{4,5,14},{4,14,15},{5,6,12},{6,11,12},{7,8,11},{7,10,11}}},

{3,
0,
0,
1,
{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
{{0,4,5},{0,5,6},{0,4,6},{4,9,15},{5,12,14},{6,8,11},{1,7,8},{1,8,9},{1,7,9},{7,10,13},{2,10,11},{2,11,12},{2,10,12},{3,13,14},{3,14,15},{3,13,15},{7,9,15},{7,13,15},{4,6,8},{4,8,9},{10,12,14},{10,13,14},{4,5,14},{4,14,15},{5,6,12},{6,11,12},{7,8,10},{8,10,11}}},

{4,
0,
0,
1,
{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
{{0,4,5},{0,5,6},{0,4,6},{4,9,15},{5,12,14},{6,8,11},{1,7,8},{1,8,9},{1,7,9},{7,10,13},{2,10,11},{2,11,12},{2,10,12},{3,13,14},{3,14,15},{3,13,15},{7,9,15},{7,13,15},{4,6,8},{4,8,9},{10,12,14},{10,13,14},{4,5,15},{5,14,15},{5,6,11},{5,11,12},{7,8,11},{7,10,11}}},

{5,
0,
0,
1,
{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
{{0,4,5},{0,5,6},{0,4,6},{4,9,15},{5,12,14},{6,8,11},{1,7,8},{1,8,9},{1,7,9},{7,10,13},{2,10,11},{2,11,12},{2,10,12},{3,13,14},{3,14,15},{3,13,15},{7,9,15},{7,13,15},{4,6,8},{4,8,9},{10,12,14},{10,13,14},{4,5,15},{5,14,15},{5,6,12},{6,11,12},{7,8,11},{7,10,11}}},

{6,
0,
0,
1,
{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
{{0,4,5},{0,5,6},{0,4,6},{4,9,15},{5,12,14},{6,8,11},{1,7,8},{1,8,9},{1,7,9},{7,10,13},{2,10,11},{2,11,12},{2,10,12},{3,13,14},{3,14,15},{3,13,15},{7,9,15},{7,13,15},{4,6,8},{4,8,9},{10,12,13},{12,13,14},{4,5,14},{4,14,15},{5,6,11},{5,11,12},{7,8,11},{7,10,11}}},

{7,
0,
0,
1,
{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
{{0,4,5},{0,5,6},{0,4,6},{4,9,15},{5,12,14},{6,8,11},{1,7,8},{1,8,9},{1,7,9},{7,10,13},{2,10,11},{2,11,12},{2,10,12},{3,13,14},{3,14,15},{3,13,15},{7,9,15},{7,13,15},{4,6,8},{4,8,9},{10,12,13},{12,13,14},{4,5,14},{4,14,15},{5,6,11},{5,11,12},{7,8,10},{8,10,11}}},

{8,
0,
0,
1,
{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
{{0,4,5},{0,5,6},{0,4,6},{4,9,15},{5,12,14},{6,8,11},{1,7,8},{1,8,9},{1,7,9},{7,10,13},{2,10,11},{2,11,12},{2,10,12},{3,13,14},{3,14,15},{3,13,15},{7,9,15},{7,13,15},{4,6,8},{4,8,9},{10,12,13},{12,13,14},{4,5,14},{4,14,15},{5,6,12},{6,11,12},{7,8,11},{7,10,11}}},

{9,
0,
0,
1,
{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
{{0,4,5},{0,5,6},{0,4,6},{4,9,15},{5,12,14},{6,8,11},{1,7,8},{1,8,9},{1,7,9},{7,10,13},{2,10,11},{2,11,12},{2,10,12},{3,13,14},{3,14,15},{3,13,15},{7,9,15},{7,13,15},{4,6,8},{4,8,9},{10,12,13},{12,13,14},{4,5,15},{5,14,15},{5,6,12},{6,11,12},{7,8,10},{8,10,11}}},

{10,
0,
0,
1,
{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
{{0,4,5},{0,5,6},{0,4,6},{4,9,15},{5,12,14},{6,8,11},{1,7,8},{1,8,9},{1,7,9},{7,10,13},{2,10,11},{2,11,12},{2,10,12},{3,13,14},{3,14,15},{3,13,15},{7,9,15},{7,13,15},{4,6,9},{6,8,9},{10,12,13},{12,13,14},{4,5,14},{4,14,15},{5,6,11},{5,11,12},{7,8,10},{8,10,11}}},

{11,
0,
0,
1,
{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
{{0,4,5},{0,5,6},{0,4,6},{4,9,15},{5,12,14},{6,8,11},{1,7,8},{1,8,9},{1,7,9},{7,10,13},{2,10,11},{2,11,12},{2,10,12},{3,13,14},{3,14,15},{3,13,15},{7,9,13},{9,13,15},{4,6,8},{4,8,9},{10,12,14},{10,13,14},{4,5,15},{5,14,15},{5,6,12},{6,11,12},{7,8,11},{7,10,11}}},

};

graph_t graphs_dhex[NUM_DHEX_GRAPHS] = {

{0,
0,
0,
1,
{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
{{0,4,5},{0,5,6},{0,4,6},{4,6,15},{5,8,10},{1,7,8},{1,8,9},{1,7,9},{7,9,13},{2,10,11},{2,11,12},{2,10,12},{11,12,14},{3,13,14},{3,14,15},{3,13,15},{7,12,14},{7,13,14},{4,9,13},{4,13,15},{4,5,8},{4,8,9},{7,8,10},{7,10,12},{6,11,14},{6,14,15},{5,6,11},{5,10,11}}},

{1,
0,
0,
1,
{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
{{0,4,5},{0,5,6},{0,4,6},{4,6,15},{5,8,10},{1,7,8},{1,8,9},{1,7,9},{7,9,13},{2,10,11},{2,11,12},{2,10,12},{11,12,14},{3,13,14},{3,14,15},{3,13,15},{7,12,14},{7,13,14},{4,9,13},{4,13,15},{4,5,8},{4,8,9},{7,8,10},{7,10,12},{6,11,14},{6,14,15},{5,6,10},{6,10,11}}},

{2,
0,
0,
1,
{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
{{0,4,5},{0,5,6},{0,4,6},{4,6,15},{5,8,10},{1,7,8},{1,8,9},{1,7,9},{7,9,13},{2,10,11},{2,11,12},{2,10,12},{11,12,14},{3,13,14},{3,14,15},{3,13,15},{7,12,14},{7,13,14},{4,9,13},{4,13,15},{4,5,8},{4,8,9},{7,8,10},{7,10,12},{6,11,15},{11,14,15},{5,6,11},{5,10,11}}},

{3,
0,
0,
1,
{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
{{0,4,5},{0,5,6},{0,4,6},{4,6,15},{5,8,10},{1,7,8},{1,8,9},{1,7,9},{7,9,13},{2,10,11},{2,11,12},{2,10,12},{11,12,14},{3,13,14},{3,14,15},{3,13,15},{7,12,14},{7,13,14},{4,9,13},{4,13,15},{4,5,8},{4,8,9},{7,8,10},{7,10,12},{6,11,15},{11,14,15},{5,6,10},{6,10,11}}},

{4,
0,
0,
1,
{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
{{0,4,5},{0,5,6},{0,4,6},{4,6,15},{5,8,10},{1,7,8},{1,8,9},{1,7,9},{7,9,13},{2,10,11},{2,11,12},{2,10,12},{11,12,14},{3,13,14},{3,14,15},{3,13,15},{7,12,14},{7,13,14},{4,9,13},{4,13,15},{4,5,8},{4,8,9},{7,8,12},{8,10,12},{6,11,14},{6,14,15},{5,6,11},{5,10,11}}},

{5,
0,
0,
1,
{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
{{0,4,5},{0,5,6},{0,4,6},{4,6,15},{5,8,10},{1,7,8},{1,8,9},{1,7,9},{7,9,13},{2,10,11},{2,11,12},{2,10,12},{11,12,14},{3,13,14},{3,14,15},{3,13,15},{7,12,14},{7,13,14},{4,9,13},{4,13,15},{4,5,8},{4,8,9},{7,8,12},{8,10,12},{6,11,14},{6,14,15},{5,6,10},{6,10,11}}},

{6,
0,
53,
2,
{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
{{0,4,5},{0,5,6},{0,4,6},{4,6,15},{5,8,10},{1,7,8},{1,8,9},{1,7,9},{7,9,13},{2,10,11},{2,11,12},{2,10,12},{11,12,14},{3,13,14},{3,14,15},{3,13,15},{7,12,14},{7,13,14},{4,9,13},{4,13,15},{4,5,8},{4,8,9},{7,8,12},{8,10,12},{6,11,15},{11,14,15},{5,6,10},{6,10,11}}},

{7,
0,
0,
1,
{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
{{0,4,5},{0,5,6},{0,4,6},{4,6,15},{5,8,10},{1,7,8},{1,8,9},{1,7,9},{7,9,13},{2,10,11},{2,11,12},{2,10,12},{11,12,14},{3,13,14},{3,14,15},{3,13,15},{7,12,14},{7,13,14},{4,9,13},{4,13,15},{4,5,9},{5,8,9},{7,8,10},{7,10,12},{6,11,14},{6,14,15},{5,6,11},{5,10,11}}},

{8,
0,
0,
1,
{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
{{0,4,5},{0,5,6},{0,4,6},{4,6,15},{5,8,10},{1,7,8},{1,8,9},{1,7,9},{7,9,13},{2,10,11},{2,11,12},{2,10,12},{11,12,14},{3,13,14},{3,14,15},{3,13,15},{7,12,14},{7,13,14},{4,9,13},{4,13,15},{4,5,9},{5,8,9},{7,8,10},{7,10,12},{6,11,14},{6,14,15},{5,6,10},{6,10,11}}},

{9,
0,
0,
1,
{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
{{0,4,5},{0,5,6},{0,4,6},{4,6,15},{5,8,10},{1,7,8},{1,8,9},{1,7,9},{7,9,13},{2,10,11},{2,11,12},{2,10,12},{11,12,14},{3,13,14},{3,14,15},{3,13,15},{7,12,14},{7,13,14},{4,9,13},{4,13,15},{4,5,9},{5,8,9},{7,8,12},{8,10,12},{6,11,14},{6,14,15},{5,6,11},{5,10,11}}},

{10,
0,
0,
1,
{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
{{0,4,5},{0,5,6},{0,4,6},{4,6,15},{5,8,10},{1,7,8},{1,8,9},{1,7,9},{7,9,13},{2,10,11},{2,11,12},{2,10,12},{11,12,14},{3,13,14},{3,14,15},{3,13,15},{7,12,14},{7,13,14},{4,9,13},{4,13,15},{4,5,9},{5,8,9},{7,8,12},{8,10,12},{6,11,14},{6,14,15},{5,6,10},{6,10,11}}},

{11,
0,
55,
4,
{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
{{0,4,5},{0,5,6},{0,4,6},{4,6,15},{5,8,10},{1,7,8},{1,8,9},{1,7,9},{7,9,13},{2,10,11},{2,11,12},{2,10,12},{11,12,14},{3,13,14},{3,14,15},{3,13,15},{7,12,14},{7,13,14},{4,9,13},{4,13,15},{4,5,9},{5,8,9},{7,8,12},{8,10,12},{6,11,15},{11,14,15},{5,6,10},{6,10,11}}},

{12,
0,
0,
1,
{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
{{0,4,5},{0,5,6},{0,4,6},{4,6,15},{5,8,10},{1,7,8},{1,8,9},{1,7,9},{7,9,13},{2,10,11},{2,11,12},{2,10,12},{11,12,14},{3,13,14},{3,14,15},{3,13,15},{7,12,14},{7,13,14},{4,9,15},{9,13,15},{4,5,8},{4,8,9},{7,8,10},{7,10,12},{6,11,14},{6,14,15},{5,6,11},{5,10,11}}},

{13,
0,
0,
1,
{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
{{0,4,5},{0,5,6},{0,4,6},{4,6,15},{5,8,10},{1,7,8},{1,8,9},{1,7,9},{7,9,13},{2,10,11},{2,11,12},{2,10,12},{11,12,14},{3,13,14},{3,14,15},{3,13,15},{7,12,14},{7,13,14},{4,9,15},{9,13,15},{4,5,8},{4,8,9},{7,8,10},{7,10,12},{6,11,14},{6,14,15},{5,6,10},{6,10,11}}},

{14,
0,
0,
1,
{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
{{0,4,5},{0,5,6},{0,4,6},{4,6,15},{5,8,10},{1,7,8},{1,8,9},{1,7,9},{7,9,13},{2,10,11},{2,11,12},{2,10,12},{11,12,14},{3,13,14},{3,14,15},{3,13,15},{7,12,14},{7,13,14},{4,9,15},{9,13,15},{4,5,8},{4,8,9},{7,8,12},{8,10,12},{6,11,14},{6,14,15},{5,6,11},{5,10,11}}},

{15,
0,
0,
1,
{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
{{0,4,5},{0,5,6},{0,4,6},{4,6,15},{5,8,10},{1,7,8},{1,8,9},{1,7,9},{7,9,13},{2,10,11},{2,11,12},{2,10,12},{11,12,14},{3,13,14},{3,14,15},{3,13,15},{7,12,14},{7,13,14},{4,9,15},{9,13,15},{4,5,8},{4,8,9},{7,8,12},{8,10,12},{6,11,14},{6,14,15},{5,6,10},{6,10,11}}},

{16,
0,
0,
1,
{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
{{0,4,5},{0,5,6},{0,4,6},{4,6,15},{5,8,10},{1,7,8},{1,8,9},{1,7,9},{7,9,13},{2,10,11},{2,11,12},{2,10,12},{11,12,14},{3,13,14},{3,14,15},{3,13,15},{7,12,14},{7,13,14},{4,9,15},{9,13,15},{4,5,9},{5,8,9},{7,8,10},{7,10,12},{6,11,14},{6,14,15},{5,6,11},{5,10,11}}},

{17,
0,
0,
1,
{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
{{0,4,5},{0,5,6},{0,4,6},{4,6,15},{5,8,10},{1,7,8},{1,8,9},{1,7,9},{7,9,13},{2,10,11},{2,11,12},{2,10,12},{11,12,14},{3,13,14},{3,14,15},{3,13,15},{7,12,14},{7,13,14},{4,9,15},{9,13,15},{4,5,9},{5,8,9},{7,8,10},{7,10,12},{6,11,14},{6,14,15},{5,6,10},{6,10,11}}},

{18,
0,
0,
1,
{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
{{0,4,5},{0,5,6},{0,4,6},{4,6,15},{5,8,10},{1,7,8},{1,8,9},{1,7,9},{7,9,13},{2,10,11},{2,11,12},{2,10,12},{11,12,14},{3,13,14},{3,14,15},{3,13,15},{7,12,14},{7,13,14},{4,9,15},{9,13,15},{4,5,9},{5,8,9},{7,8,12},{8,10,12},{6,11,14},{6,14,15},{5,6,11},{5,10,11}}},

{19,
0,
0,
1,
{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
{{0,4,5},{0,5,6},{0,4,6},{4,6,15},{5,8,10},{1,7,8},{1,8,9},{1,7,9},{7,9,13},{2,10,11},{2,11,12},{2,10,12},{11,12,14},{3,13,14},{3,14,15},{3,13,15},{7,12,14},{7,13,14},{4,9,15},{9,13,15},{4,5,9},{5,8,9},{7,8,12},{8,10,12},{6,11,14},{6,14,15},{5,6,10},{6,10,11}}},

{20,
0,
59,
4,
{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
{{0,4,5},{0,5,6},{0,4,6},{4,6,15},{5,8,10},{1,7,8},{1,8,9},{1,7,9},{7,9,13},{2,10,11},{2,11,12},{2,10,12},{11,12,14},{3,13,14},{3,14,15},{3,13,15},{7,12,13},{12,13,14},{4,9,15},{9,13,15},{4,5,8},{4,8,9},{7,8,10},{7,10,12},{6,11,14},{6,14,15},{5,6,11},{5,10,11}}},

{21,
0,
63,
2,
{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
{{0,4,5},{0,5,6},{0,4,6},{4,6,15},{5,8,10},{1,7,8},{1,8,9},{1,7,9},{7,9,13},{2,10,11},{2,11,12},{2,10,12},{11,12,14},{3,13,14},{3,14,15},{3,13,15},{7,12,13},{12,13,14},{4,9,15},{9,13,15},{4,5,8},{4,8,9},{7,8,10},{7,10,12},{6,11,14},{6,14,15},{5,6,10},{6,10,11}}},

{22,
0,
0,
1,
{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
{{0,4,5},{0,5,6},{0,4,6},{4,6,15},{5,8,10},{1,7,8},{1,8,9},{1,7,9},{7,9,13},{2,10,11},{2,11,12},{2,10,12},{11,12,14},{3,13,14},{3,14,15},{3,13,15},{7,12,13},{12,13,14},{4,9,15},{9,13,15},{4,5,8},{4,8,9},{7,8,12},{8,10,12},{6,11,14},{6,14,15},{5,6,10},{6,10,11}}},

{23,
0,
0,
1,
{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
{{0,4,5},{0,5,6},{0,4,6},{4,6,15},{5,8,10},{1,7,8},{1,8,9},{1,7,9},{7,9,13},{2,10,11},{2,11,12},{2,10,12},{11,12,14},{3,13,14},{3,14,15},{3,13,15},{7,12,13},{12,13,14},{4,9,15},{9,13,15},{4,5,9},{5,8,9},{7,8,12},{8,10,12},{6,11,14},{6,14,15},{5,6,10},{6,10,11}}},

};

}

