/*
 * Copyright 2010-2019 JetBrains s.r.o. Use of this source code is governed by the Apache 2.0 license
 * that can be found in the license/LICENSE.txt file.
 */

package org.jetbrains.kotlin.idea.quickfix;

import com.intellij.testFramework.TestDataPath;
import org.jetbrains.kotlin.test.JUnit3RunnerWithInners;
import org.jetbrains.kotlin.test.KotlinTestUtils;
import org.jetbrains.kotlin.test.TargetBackend;
import org.jetbrains.kotlin.test.TestMetadata;
import org.junit.runner.RunWith;

import java.io.File;
import java.util.regex.Pattern;

/** This class is generated by {@link org.jetbrains.kotlin.generators.tests.TestsPackage}. DO NOT MODIFY MANUALLY */
@SuppressWarnings("all")
@TestMetadata("idea/testData/quickfix")
@TestDataPath("$PROJECT_ROOT")
@RunWith(JUnit3RunnerWithInners.class)
public class QuickFixTestGenerated extends AbstractQuickFixTest {
    private void runTest(String testDataFilePath) throws Exception {
        KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
    }

    public void testAllFilesPresentInQuickfix() throws Exception {
        KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/quickfix"), Pattern.compile("^([\\w\\-_]+)\\.kt$"), TargetBackend.ANY, true);
    }

    @TestMetadata("idea/testData/quickfix/abstract")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class Abstract extends AbstractQuickFixTest {
        private void runTest(String testDataFilePath) throws Exception {
            KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
        }

        @TestMetadata("abstractFunctionInNonAbstractClass.kt")
        public void testAbstractFunctionInNonAbstractClass() throws Exception {
            runTest("idea/testData/quickfix/abstract/abstractFunctionInNonAbstractClass.kt");
        }

        @TestMetadata("abstractFunctionWithBody.kt")
        public void testAbstractFunctionWithBody() throws Exception {
            runTest("idea/testData/quickfix/abstract/abstractFunctionWithBody.kt");
        }

        @TestMetadata("abstractFunctionWithBody2.kt")
        public void testAbstractFunctionWithBody2() throws Exception {
            runTest("idea/testData/quickfix/abstract/abstractFunctionWithBody2.kt");
        }

        @TestMetadata("abstractFunctionWithBody3.kt")
        public void testAbstractFunctionWithBody3() throws Exception {
            runTest("idea/testData/quickfix/abstract/abstractFunctionWithBody3.kt");
        }

        @TestMetadata("abstractFunctionWithBodyWithComments.kt")
        public void testAbstractFunctionWithBodyWithComments() throws Exception {
            runTest("idea/testData/quickfix/abstract/abstractFunctionWithBodyWithComments.kt");
        }

        @TestMetadata("abstractFunctionWithBodyWithComments2.kt")
        public void testAbstractFunctionWithBodyWithComments2() throws Exception {
            runTest("idea/testData/quickfix/abstract/abstractFunctionWithBodyWithComments2.kt");
        }

        @TestMetadata("abstractPropertyInCompanionObject.kt")
        public void testAbstractPropertyInCompanionObject() throws Exception {
            runTest("idea/testData/quickfix/abstract/abstractPropertyInCompanionObject.kt");
        }

        @TestMetadata("abstractPropertyInNonAbstractClass1.kt")
        public void testAbstractPropertyInNonAbstractClass1() throws Exception {
            runTest("idea/testData/quickfix/abstract/abstractPropertyInNonAbstractClass1.kt");
        }

        @TestMetadata("abstractPropertyInNonAbstractClass2.kt")
        public void testAbstractPropertyInNonAbstractClass2() throws Exception {
            runTest("idea/testData/quickfix/abstract/abstractPropertyInNonAbstractClass2.kt");
        }

        @TestMetadata("abstractPropertyInNonAbstractClass3.kt")
        public void testAbstractPropertyInNonAbstractClass3() throws Exception {
            runTest("idea/testData/quickfix/abstract/abstractPropertyInNonAbstractClass3.kt");
        }

        @TestMetadata("abstractPropertyInPrimaryConstructorParameters.kt")
        public void testAbstractPropertyInPrimaryConstructorParameters() throws Exception {
            runTest("idea/testData/quickfix/abstract/abstractPropertyInPrimaryConstructorParameters.kt");
        }

        @TestMetadata("abstractPropertyNotInClass.kt")
        public void testAbstractPropertyNotInClass() throws Exception {
            runTest("idea/testData/quickfix/abstract/abstractPropertyNotInClass.kt");
        }

        @TestMetadata("abstractPropertyWIthInitializer2.kt")
        public void testAbstractPropertyWIthInitializer2() throws Exception {
            runTest("idea/testData/quickfix/abstract/abstractPropertyWIthInitializer2.kt");
        }

        @TestMetadata("abstractPropertyWIthInitializer3.kt")
        public void testAbstractPropertyWIthInitializer3() throws Exception {
            runTest("idea/testData/quickfix/abstract/abstractPropertyWIthInitializer3.kt");
        }

        @TestMetadata("abstractPropertyWithGetter1.kt")
        public void testAbstractPropertyWithGetter1() throws Exception {
            runTest("idea/testData/quickfix/abstract/abstractPropertyWithGetter1.kt");
        }

        @TestMetadata("abstractPropertyWithGetter2.kt")
        public void testAbstractPropertyWithGetter2() throws Exception {
            runTest("idea/testData/quickfix/abstract/abstractPropertyWithGetter2.kt");
        }

        @TestMetadata("abstractPropertyWithInitializer1.kt")
        public void testAbstractPropertyWithInitializer1() throws Exception {
            runTest("idea/testData/quickfix/abstract/abstractPropertyWithInitializer1.kt");
        }

        @TestMetadata("abstractPropertyWithSetter.kt")
        public void testAbstractPropertyWithSetter() throws Exception {
            runTest("idea/testData/quickfix/abstract/abstractPropertyWithSetter.kt");
        }

        public void testAllFilesPresentInAbstract() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/quickfix/abstract"), Pattern.compile("^([\\w\\-_]+)\\.kt$"), TargetBackend.ANY, true);
        }

        @TestMetadata("makeEnumEntryAbstract.kt")
        public void testMakeEnumEntryAbstract() throws Exception {
            runTest("idea/testData/quickfix/abstract/makeEnumEntryAbstract.kt");
        }

        @TestMetadata("makeInlineClassAbstract.kt")
        public void testMakeInlineClassAbstract() throws Exception {
            runTest("idea/testData/quickfix/abstract/makeInlineClassAbstract.kt");
        }

        @TestMetadata("makeObjectMemberAbstract.kt")
        public void testMakeObjectMemberAbstract() throws Exception {
            runTest("idea/testData/quickfix/abstract/makeObjectMemberAbstract.kt");
        }

        @TestMetadata("makeTopLevelAbstract.kt")
        public void testMakeTopLevelAbstract() throws Exception {
            runTest("idea/testData/quickfix/abstract/makeTopLevelAbstract.kt");
        }

        @TestMetadata("manyImpl.kt")
        public void testManyImpl() throws Exception {
            runTest("idea/testData/quickfix/abstract/manyImpl.kt");
        }

        @TestMetadata("mustBeInitializedOrBeAbstract.kt")
        public void testMustBeInitializedOrBeAbstract() throws Exception {
            runTest("idea/testData/quickfix/abstract/mustBeInitializedOrBeAbstract.kt");
        }

        @TestMetadata("mustBeInitializedOrBeAbstractInFinalClass.kt")
        public void testMustBeInitializedOrBeAbstractInFinalClass() throws Exception {
            runTest("idea/testData/quickfix/abstract/mustBeInitializedOrBeAbstractInFinalClass.kt");
        }

        @TestMetadata("mustBeInitializedOrBeAbstractInOpenClass.kt")
        public void testMustBeInitializedOrBeAbstractInOpenClass() throws Exception {
            runTest("idea/testData/quickfix/abstract/mustBeInitializedOrBeAbstractInOpenClass.kt");
        }

        @TestMetadata("mustBeInitializedOrBeAbstractInSealedClass.kt")
        public void testMustBeInitializedOrBeAbstractInSealedClass() throws Exception {
            runTest("idea/testData/quickfix/abstract/mustBeInitializedOrBeAbstractInSealedClass.kt");
        }

        @TestMetadata("nonAbstractFunctionWithNoBody.kt")
        public void testNonAbstractFunctionWithNoBody() throws Exception {
            runTest("idea/testData/quickfix/abstract/nonAbstractFunctionWithNoBody.kt");
        }

        @TestMetadata("nonMemberAbstractFunction.kt")
        public void testNonMemberAbstractFunction() throws Exception {
            runTest("idea/testData/quickfix/abstract/nonMemberAbstractFunction.kt");
        }

        @TestMetadata("nonMemberFunctionNoBody.kt")
        public void testNonMemberFunctionNoBody() throws Exception {
            runTest("idea/testData/quickfix/abstract/nonMemberFunctionNoBody.kt");
        }

        @TestMetadata("notImplementedMember.kt")
        public void testNotImplementedMember() throws Exception {
            runTest("idea/testData/quickfix/abstract/notImplementedMember.kt");
        }

        @TestMetadata("notImplementedMemberFromAbstractClass.kt")
        public void testNotImplementedMemberFromAbstractClass() throws Exception {
            runTest("idea/testData/quickfix/abstract/notImplementedMemberFromAbstractClass.kt");
        }

        @TestMetadata("replaceOpen.kt")
        public void testReplaceOpen() throws Exception {
            runTest("idea/testData/quickfix/abstract/replaceOpen.kt");
        }
    }

    @TestMetadata("idea/testData/quickfix/addAnnotationTarget")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class AddAnnotationTarget extends AbstractQuickFixTest {
        private void runTest(String testDataFilePath) throws Exception {
            KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
        }

        public void testAllFilesPresentInAddAnnotationTarget() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/quickfix/addAnnotationTarget"), Pattern.compile("^([\\w\\-_]+)\\.kt$"), TargetBackend.ANY, true);
        }

        @TestMetadata("basic1.kt")
        public void testBasic1() throws Exception {
            runTest("idea/testData/quickfix/addAnnotationTarget/basic1.kt");
        }

        @TestMetadata("basic2.kt")
        public void testBasic2() throws Exception {
            runTest("idea/testData/quickfix/addAnnotationTarget/basic2.kt");
        }

        @TestMetadata("basic3.kt")
        public void testBasic3() throws Exception {
            runTest("idea/testData/quickfix/addAnnotationTarget/basic3.kt");
        }

        @TestMetadata("basic4.kt")
        public void testBasic4() throws Exception {
            runTest("idea/testData/quickfix/addAnnotationTarget/basic4.kt");
        }

        @TestMetadata("expression.kt")
        public void testExpression() throws Exception {
            runTest("idea/testData/quickfix/addAnnotationTarget/expression.kt");
        }

        @TestMetadata("expression2.kt")
        public void testExpression2() throws Exception {
            runTest("idea/testData/quickfix/addAnnotationTarget/expression2.kt");
        }

        @TestMetadata("expression3.kt")
        public void testExpression3() throws Exception {
            runTest("idea/testData/quickfix/addAnnotationTarget/expression3.kt");
        }

        @TestMetadata("file.kt")
        public void testFile() throws Exception {
            runTest("idea/testData/quickfix/addAnnotationTarget/file.kt");
        }

        @TestMetadata("fromLib.kt")
        public void testFromLib() throws Exception {
            runTest("idea/testData/quickfix/addAnnotationTarget/fromLib.kt");
        }

        @TestMetadata("hasAnnotationTarget1.kt")
        public void testHasAnnotationTarget1() throws Exception {
            runTest("idea/testData/quickfix/addAnnotationTarget/hasAnnotationTarget1.kt");
        }

        @TestMetadata("hasAnnotationTarget2.kt")
        public void testHasAnnotationTarget2() throws Exception {
            runTest("idea/testData/quickfix/addAnnotationTarget/hasAnnotationTarget2.kt");
        }

        @TestMetadata("noBackingField.kt")
        public void testNoBackingField() throws Exception {
            runTest("idea/testData/quickfix/addAnnotationTarget/noBackingField.kt");
        }

        @TestMetadata("use-site_delegate.kt")
        public void testUse_site_delegate() throws Exception {
            runTest("idea/testData/quickfix/addAnnotationTarget/use-site_delegate.kt");
        }

        @TestMetadata("use-site_field.kt")
        public void testUse_site_field() throws Exception {
            runTest("idea/testData/quickfix/addAnnotationTarget/use-site_field.kt");
        }

        @TestMetadata("use-site_field_member.kt")
        public void testUse_site_field_member() throws Exception {
            runTest("idea/testData/quickfix/addAnnotationTarget/use-site_field_member.kt");
        }

        @TestMetadata("use-site_field_member_with_delegate.kt")
        public void testUse_site_field_member_with_delegate() throws Exception {
            runTest("idea/testData/quickfix/addAnnotationTarget/use-site_field_member_with_delegate.kt");
        }

        @TestMetadata("use-site_field_member_without_backing.kt")
        public void testUse_site_field_member_without_backing() throws Exception {
            runTest("idea/testData/quickfix/addAnnotationTarget/use-site_field_member_without_backing.kt");
        }

        @TestMetadata("use-site_field_toplevel.kt")
        public void testUse_site_field_toplevel() throws Exception {
            runTest("idea/testData/quickfix/addAnnotationTarget/use-site_field_toplevel.kt");
        }

        @TestMetadata("use-site_field_toplevel_with_delegate.kt")
        public void testUse_site_field_toplevel_with_delegate() throws Exception {
            runTest("idea/testData/quickfix/addAnnotationTarget/use-site_field_toplevel_with_delegate.kt");
        }

        @TestMetadata("use-site_field_toplevel_without_backing.kt")
        public void testUse_site_field_toplevel_without_backing() throws Exception {
            runTest("idea/testData/quickfix/addAnnotationTarget/use-site_field_toplevel_without_backing.kt");
        }

        @TestMetadata("use-site_file.kt")
        public void testUse_site_file() throws Exception {
            runTest("idea/testData/quickfix/addAnnotationTarget/use-site_file.kt");
        }

        @TestMetadata("use-site_get.kt")
        public void testUse_site_get() throws Exception {
            runTest("idea/testData/quickfix/addAnnotationTarget/use-site_get.kt");
        }

        @TestMetadata("use-site_invalid.kt")
        public void testUse_site_invalid() throws Exception {
            runTest("idea/testData/quickfix/addAnnotationTarget/use-site_invalid.kt");
        }

        @TestMetadata("use-site_param.kt")
        public void testUse_site_param() throws Exception {
            runTest("idea/testData/quickfix/addAnnotationTarget/use-site_param.kt");
        }

        @TestMetadata("use-site_property.kt")
        public void testUse_site_property() throws Exception {
            runTest("idea/testData/quickfix/addAnnotationTarget/use-site_property.kt");
        }

        @TestMetadata("use-site_receiver.kt")
        public void testUse_site_receiver() throws Exception {
            runTest("idea/testData/quickfix/addAnnotationTarget/use-site_receiver.kt");
        }

        @TestMetadata("use-site_set.kt")
        public void testUse_site_set() throws Exception {
            runTest("idea/testData/quickfix/addAnnotationTarget/use-site_set.kt");
        }

        @TestMetadata("use-site_setparam.kt")
        public void testUse_site_setparam() throws Exception {
            runTest("idea/testData/quickfix/addAnnotationTarget/use-site_setparam.kt");
        }
    }

    @TestMetadata("idea/testData/quickfix/addCrossinline")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class AddCrossinline extends AbstractQuickFixTest {
        private void runTest(String testDataFilePath) throws Exception {
            KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
        }

        public void testAllFilesPresentInAddCrossinline() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/quickfix/addCrossinline"), Pattern.compile("^([\\w\\-_]+)\\.kt$"), TargetBackend.ANY, true);
        }

        @TestMetadata("basic.kt")
        public void testBasic() throws Exception {
            runTest("idea/testData/quickfix/addCrossinline/basic.kt");
        }

        @TestMetadata("suspend.kt")
        public void testSuspend() throws Exception {
            runTest("idea/testData/quickfix/addCrossinline/suspend.kt");
        }
    }

    @TestMetadata("idea/testData/quickfix/addDataModifier")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class AddDataModifier extends AbstractQuickFixTest {
        private void runTest(String testDataFilePath) throws Exception {
            KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
        }

        @TestMetadata("abstract.kt")
        public void testAbstract() throws Exception {
            runTest("idea/testData/quickfix/addDataModifier/abstract.kt");
        }

        public void testAllFilesPresentInAddDataModifier() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/quickfix/addDataModifier"), Pattern.compile("^([\\w\\-_]+)\\.kt$"), TargetBackend.ANY, true);
        }

        @TestMetadata("inner.kt")
        public void testInner() throws Exception {
            runTest("idea/testData/quickfix/addDataModifier/inner.kt");
        }

        @TestMetadata("invisibleParameter.kt")
        public void testInvisibleParameter() throws Exception {
            runTest("idea/testData/quickfix/addDataModifier/invisibleParameter.kt");
        }

        @TestMetadata("invisibleParameter2.kt")
        public void testInvisibleParameter2() throws Exception {
            runTest("idea/testData/quickfix/addDataModifier/invisibleParameter2.kt");
        }

        @TestMetadata("noParameter.kt")
        public void testNoParameter() throws Exception {
            runTest("idea/testData/quickfix/addDataModifier/noParameter.kt");
        }

        @TestMetadata("notVarVal.kt")
        public void testNotVarVal() throws Exception {
            runTest("idea/testData/quickfix/addDataModifier/notVarVal.kt");
        }

        @TestMetadata("open.kt")
        public void testOpen() throws Exception {
            runTest("idea/testData/quickfix/addDataModifier/open.kt");
        }

        @TestMetadata("sealed.kt")
        public void testSealed() throws Exception {
            runTest("idea/testData/quickfix/addDataModifier/sealed.kt");
        }

        @TestMetadata("test1.kt")
        public void testTest1() throws Exception {
            runTest("idea/testData/quickfix/addDataModifier/test1.kt");
        }

        @TestMetadata("test2.kt")
        public void testTest2() throws Exception {
            runTest("idea/testData/quickfix/addDataModifier/test2.kt");
        }

        @TestMetadata("test3.kt")
        public void testTest3() throws Exception {
            runTest("idea/testData/quickfix/addDataModifier/test3.kt");
        }

        @TestMetadata("test4.kt")
        public void testTest4() throws Exception {
            runTest("idea/testData/quickfix/addDataModifier/test4.kt");
        }

        @TestMetadata("test5.kt")
        public void testTest5() throws Exception {
            runTest("idea/testData/quickfix/addDataModifier/test5.kt");
        }

        @TestMetadata("test6.kt")
        public void testTest6() throws Exception {
            runTest("idea/testData/quickfix/addDataModifier/test6.kt");
        }

        @TestMetadata("test7.kt")
        public void testTest7() throws Exception {
            runTest("idea/testData/quickfix/addDataModifier/test7.kt");
        }

        @TestMetadata("vararg.kt")
        public void testVararg() throws Exception {
            runTest("idea/testData/quickfix/addDataModifier/vararg.kt");
        }
    }

    @TestMetadata("idea/testData/quickfix/addDefaultConstructor")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class AddDefaultConstructor extends AbstractQuickFixTest {
        private void runTest(String testDataFilePath) throws Exception {
            KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
        }

        public void testAllFilesPresentInAddDefaultConstructor() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/quickfix/addDefaultConstructor"), Pattern.compile("^([\\w\\-_]+)\\.kt$"), TargetBackend.ANY, true);
        }

        @TestMetadata("expect.kt")
        public void testExpect() throws Exception {
            runTest("idea/testData/quickfix/addDefaultConstructor/expect.kt");
        }

        @TestMetadata("expectInterface.kt")
        public void testExpectInterface() throws Exception {
            runTest("idea/testData/quickfix/addDefaultConstructor/expectInterface.kt");
        }

        @TestMetadata("interface.kt")
        public void testInterface() throws Exception {
            runTest("idea/testData/quickfix/addDefaultConstructor/interface.kt");
        }
    }

    @TestMetadata("idea/testData/quickfix/addExclExclCall")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class AddExclExclCall extends AbstractQuickFixTest {
        private void runTest(String testDataFilePath) throws Exception {
            KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
        }

        public void testAllFilesPresentInAddExclExclCall() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/quickfix/addExclExclCall"), Pattern.compile("^([\\w\\-_]+)\\.kt$"), TargetBackend.ANY, true);
        }

        @TestMetadata("array.kt")
        public void testArray() throws Exception {
            runTest("idea/testData/quickfix/addExclExclCall/array.kt");
        }

        @TestMetadata("array2.kt")
        public void testArray2() throws Exception {
            runTest("idea/testData/quickfix/addExclExclCall/array2.kt");
        }

        @TestMetadata("array3.kt")
        public void testArray3() throws Exception {
            runTest("idea/testData/quickfix/addExclExclCall/array3.kt");
        }

        @TestMetadata("array4.kt")
        public void testArray4() throws Exception {
            runTest("idea/testData/quickfix/addExclExclCall/array4.kt");
        }

        @TestMetadata("implicit.kt")
        public void testImplicit() throws Exception {
            runTest("idea/testData/quickfix/addExclExclCall/implicit.kt");
        }

        @TestMetadata("implicitFunctionCall.kt")
        public void testImplicitFunctionCall() throws Exception {
            runTest("idea/testData/quickfix/addExclExclCall/implicitFunctionCall.kt");
        }

        @TestMetadata("normal.kt")
        public void testNormal() throws Exception {
            runTest("idea/testData/quickfix/addExclExclCall/normal.kt");
        }

        @TestMetadata("normal2.kt")
        public void testNormal2() throws Exception {
            runTest("idea/testData/quickfix/addExclExclCall/normal2.kt");
        }

        @TestMetadata("null.kt")
        public void testNull() throws Exception {
            runTest("idea/testData/quickfix/addExclExclCall/null.kt");
        }

        @TestMetadata("nullExpression.kt")
        public void testNullExpression() throws Exception {
            runTest("idea/testData/quickfix/addExclExclCall/nullExpression.kt");
        }

        @TestMetadata("operationIn.kt")
        public void testOperationIn() throws Exception {
            runTest("idea/testData/quickfix/addExclExclCall/operationIn.kt");
        }
    }

    @TestMetadata("idea/testData/quickfix/addGenericUpperBound")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class AddGenericUpperBound extends AbstractQuickFixTest {
        private void runTest(String testDataFilePath) throws Exception {
            KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
        }

        public void testAllFilesPresentInAddGenericUpperBound() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/quickfix/addGenericUpperBound"), Pattern.compile("^([\\w\\-_]+)\\.kt$"), TargetBackend.ANY, true);
        }

        @TestMetadata("basic.kt")
        public void testBasic() throws Exception {
            runTest("idea/testData/quickfix/addGenericUpperBound/basic.kt");
        }

        @TestMetadata("boundAlreadyExists.kt")
        public void testBoundAlreadyExists() throws Exception {
            runTest("idea/testData/quickfix/addGenericUpperBound/boundAlreadyExists.kt");
        }

        @TestMetadata("inferenceTwoParams.kt")
        public void testInferenceTwoParams() throws Exception {
            runTest("idea/testData/quickfix/addGenericUpperBound/inferenceTwoParams.kt");
        }

        @TestMetadata("kClassRuntime.kt")
        public void testKClassRuntime() throws Exception {
            runTest("idea/testData/quickfix/addGenericUpperBound/kClassRuntime.kt");
        }

        @TestMetadata("paramAsBound.kt")
        public void testParamAsBound() throws Exception {
            runTest("idea/testData/quickfix/addGenericUpperBound/paramAsBound.kt");
        }

        @TestMetadata("withinDeclaration.kt")
        public void testWithinDeclaration() throws Exception {
            runTest("idea/testData/quickfix/addGenericUpperBound/withinDeclaration.kt");
        }
    }

    @TestMetadata("idea/testData/quickfix/addInitializer")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class AddInitializer extends AbstractQuickFixTest {
        private void runTest(String testDataFilePath) throws Exception {
            KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
        }

        public void testAllFilesPresentInAddInitializer() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/quickfix/addInitializer"), Pattern.compile("^([\\w\\-_]+)\\.kt$"), TargetBackend.ANY, true);
        }

        @TestMetadata("localVar.kt")
        public void testLocalVar() throws Exception {
            runTest("idea/testData/quickfix/addInitializer/localVar.kt");
        }

        @TestMetadata("memberExtensionProperty.kt")
        public void testMemberExtensionProperty() throws Exception {
            runTest("idea/testData/quickfix/addInitializer/memberExtensionProperty.kt");
        }

        @TestMetadata("memberExtensionPropertyVarGetterOnly.kt")
        public void testMemberExtensionPropertyVarGetterOnly() throws Exception {
            runTest("idea/testData/quickfix/addInitializer/memberExtensionPropertyVarGetterOnly.kt");
        }

        @TestMetadata("memberExtensionPropertyVarSetterOnly.kt")
        public void testMemberExtensionPropertyVarSetterOnly() throws Exception {
            runTest("idea/testData/quickfix/addInitializer/memberExtensionPropertyVarSetterOnly.kt");
        }

        @TestMetadata("memberProperty.kt")
        public void testMemberProperty() throws Exception {
            runTest("idea/testData/quickfix/addInitializer/memberProperty.kt");
        }

        @TestMetadata("memberPropertyVarGetterOnly.kt")
        public void testMemberPropertyVarGetterOnly() throws Exception {
            runTest("idea/testData/quickfix/addInitializer/memberPropertyVarGetterOnly.kt");
        }

        @TestMetadata("memberPropertyVarSetterOnly.kt")
        public void testMemberPropertyVarSetterOnly() throws Exception {
            runTest("idea/testData/quickfix/addInitializer/memberPropertyVarSetterOnly.kt");
        }

        @TestMetadata("memberPropertyWithAccessor.kt")
        public void testMemberPropertyWithAccessor() throws Exception {
            runTest("idea/testData/quickfix/addInitializer/memberPropertyWithAccessor.kt");
        }

        @TestMetadata("memberPropertyWithDelegateRuntime.kt")
        public void testMemberPropertyWithDelegateRuntime() throws Exception {
            runTest("idea/testData/quickfix/addInitializer/memberPropertyWithDelegateRuntime.kt");
        }

        @TestMetadata("topLevelExtensionProperty.kt")
        public void testTopLevelExtensionProperty() throws Exception {
            runTest("idea/testData/quickfix/addInitializer/topLevelExtensionProperty.kt");
        }

        @TestMetadata("topLevelExtensionPropertySetterOnly.kt")
        public void testTopLevelExtensionPropertySetterOnly() throws Exception {
            runTest("idea/testData/quickfix/addInitializer/topLevelExtensionPropertySetterOnly.kt");
        }

        @TestMetadata("topLevelProperty.kt")
        public void testTopLevelProperty() throws Exception {
            runTest("idea/testData/quickfix/addInitializer/topLevelProperty.kt");
        }

        @TestMetadata("topLevelPropertyVarGetterOnly.kt")
        public void testTopLevelPropertyVarGetterOnly() throws Exception {
            runTest("idea/testData/quickfix/addInitializer/topLevelPropertyVarGetterOnly.kt");
        }

        @TestMetadata("topLevelPropertyVarSetterOnly.kt")
        public void testTopLevelPropertyVarSetterOnly() throws Exception {
            runTest("idea/testData/quickfix/addInitializer/topLevelPropertyVarSetterOnly.kt");
        }

        @TestMetadata("topLevelPropertyWithDelegateRuntime.kt")
        public void testTopLevelPropertyWithDelegateRuntime() throws Exception {
            runTest("idea/testData/quickfix/addInitializer/topLevelPropertyWithDelegateRuntime.kt");
        }

        @TestMetadata("topLevelPropertyWithGetter.kt")
        public void testTopLevelPropertyWithGetter() throws Exception {
            runTest("idea/testData/quickfix/addInitializer/topLevelPropertyWithGetter.kt");
        }
    }

    @TestMetadata("idea/testData/quickfix/addInline")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class AddInline extends AbstractQuickFixTest {
        private void runTest(String testDataFilePath) throws Exception {
            KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
        }

        public void testAllFilesPresentInAddInline() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/quickfix/addInline"), Pattern.compile("^([\\w\\-_]+)\\.kt$"), TargetBackend.ANY, true);
        }

        @TestMetadata("basic.kt")
        public void testBasic() throws Exception {
            runTest("idea/testData/quickfix/addInline/basic.kt");
        }

        @TestMetadata("local.kt")
        public void testLocal() throws Exception {
            runTest("idea/testData/quickfix/addInline/local.kt");
        }
    }

    @TestMetadata("idea/testData/quickfix/addInlineToReifiedFunctionFix")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class AddInlineToReifiedFunctionFix extends AbstractQuickFixTest {
        private void runTest(String testDataFilePath) throws Exception {
            KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
        }

        public void testAllFilesPresentInAddInlineToReifiedFunctionFix() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/quickfix/addInlineToReifiedFunctionFix"), Pattern.compile("^([\\w\\-_]+)\\.kt$"), TargetBackend.ANY, true);
        }

        @TestMetadata("basic.kt")
        public void testBasic() throws Exception {
            runTest("idea/testData/quickfix/addInlineToReifiedFunctionFix/basic.kt");
        }
    }

    @TestMetadata("idea/testData/quickfix/addIsToWhenCondition")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class AddIsToWhenCondition extends AbstractQuickFixTest {
        private void runTest(String testDataFilePath) throws Exception {
            KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
        }

        public void testAllFilesPresentInAddIsToWhenCondition() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/quickfix/addIsToWhenCondition"), Pattern.compile("^([\\w\\-_]+)\\.kt$"), TargetBackend.ANY, true);
        }

        @TestMetadata("class.kt")
        public void testClass() throws Exception {
            runTest("idea/testData/quickfix/addIsToWhenCondition/class.kt");
        }
    }

    @TestMetadata("idea/testData/quickfix/addJvmDefault")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class AddJvmDefault extends AbstractQuickFixTest {
        private void runTest(String testDataFilePath) throws Exception {
            KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
        }

        public void testAllFilesPresentInAddJvmDefault() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/quickfix/addJvmDefault"), Pattern.compile("^([\\w\\-_]+)\\.kt$"), TargetBackend.ANY, true);
        }

        @TestMetadata("functionOverride.kt")
        public void testFunctionOverride() throws Exception {
            runTest("idea/testData/quickfix/addJvmDefault/functionOverride.kt");
        }

        @TestMetadata("propertyOverride.kt")
        public void testPropertyOverride() throws Exception {
            runTest("idea/testData/quickfix/addJvmDefault/propertyOverride.kt");
        }
    }

    @TestMetadata("idea/testData/quickfix/addNewLineAfterAnnotations")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class AddNewLineAfterAnnotations extends AbstractQuickFixTest {
        private void runTest(String testDataFilePath) throws Exception {
            KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
        }

        public void testAllFilesPresentInAddNewLineAfterAnnotations() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/quickfix/addNewLineAfterAnnotations"), Pattern.compile("^([\\w\\-_]+)\\.kt$"), TargetBackend.ANY, true);
        }

        @TestMetadata("basic.kt")
        public void testBasic() throws Exception {
            runTest("idea/testData/quickfix/addNewLineAfterAnnotations/basic.kt");
        }

        @TestMetadata("manyAnnotations.kt")
        public void testManyAnnotations() throws Exception {
            runTest("idea/testData/quickfix/addNewLineAfterAnnotations/manyAnnotations.kt");
        }

        @TestMetadata("poorlyFormattedExpression.kt")
        public void testPoorlyFormattedExpression() throws Exception {
            runTest("idea/testData/quickfix/addNewLineAfterAnnotations/poorlyFormattedExpression.kt");
        }

        @TestMetadata("preserveComments.kt")
        public void testPreserveComments() throws Exception {
            runTest("idea/testData/quickfix/addNewLineAfterAnnotations/preserveComments.kt");
        }
    }

    @TestMetadata("idea/testData/quickfix/addNoinline")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class AddNoinline extends AbstractQuickFixTest {
        private void runTest(String testDataFilePath) throws Exception {
            KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
        }

        public void testAllFilesPresentInAddNoinline() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/quickfix/addNoinline"), Pattern.compile("^([\\w\\-_]+)\\.kt$"), TargetBackend.ANY, true);
        }

        @TestMetadata("basic.kt")
        public void testBasic() throws Exception {
            runTest("idea/testData/quickfix/addNoinline/basic.kt");
        }

        @TestMetadata("suspend.kt")
        public void testSuspend() throws Exception {
            runTest("idea/testData/quickfix/addNoinline/suspend.kt");
        }
    }

    @TestMetadata("idea/testData/quickfix/addPropertyToSupertype")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class AddPropertyToSupertype extends AbstractQuickFixTest {
        private void runTest(String testDataFilePath) throws Exception {
            KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
        }

        @TestMetadata("abstractClass.kt")
        public void testAbstractClass() throws Exception {
            runTest("idea/testData/quickfix/addPropertyToSupertype/abstractClass.kt");
        }

        public void testAllFilesPresentInAddPropertyToSupertype() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/quickfix/addPropertyToSupertype"), Pattern.compile("^([\\w\\-_]+)\\.kt$"), TargetBackend.ANY, true);
        }

        @TestMetadata("interface.kt")
        public void testInterface() throws Exception {
            runTest("idea/testData/quickfix/addPropertyToSupertype/interface.kt");
        }

        @TestMetadata("openClass.kt")
        public void testOpenClass() throws Exception {
            runTest("idea/testData/quickfix/addPropertyToSupertype/openClass.kt");
        }
    }

    @TestMetadata("idea/testData/quickfix/addReifiedToTypeParameterOfFunctionFix")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class AddReifiedToTypeParameterOfFunctionFix extends AbstractQuickFixTest {
        private void runTest(String testDataFilePath) throws Exception {
            KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
        }

        public void testAllFilesPresentInAddReifiedToTypeParameterOfFunctionFix() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/quickfix/addReifiedToTypeParameterOfFunctionFix"), Pattern.compile("^([\\w\\-_]+)\\.kt$"), TargetBackend.ANY, true);
        }

        @TestMetadata("doubleColonClass.kt")
        public void testDoubleColonClass() throws Exception {
            runTest("idea/testData/quickfix/addReifiedToTypeParameterOfFunctionFix/doubleColonClass.kt");
        }

        @TestMetadata("secondTypeParameter.kt")
        public void testSecondTypeParameter() throws Exception {
            runTest("idea/testData/quickfix/addReifiedToTypeParameterOfFunctionFix/secondTypeParameter.kt");
        }

        @TestMetadata("toTypedArray.kt")
        public void testToTypedArray() throws Exception {
            runTest("idea/testData/quickfix/addReifiedToTypeParameterOfFunctionFix/toTypedArray.kt");
        }
    }

    @TestMetadata("idea/testData/quickfix/addReturnToLastExpressionInFunction")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class AddReturnToLastExpressionInFunction extends AbstractQuickFixTest {
        private void runTest(String testDataFilePath) throws Exception {
            KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
        }

        public void testAllFilesPresentInAddReturnToLastExpressionInFunction() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/quickfix/addReturnToLastExpressionInFunction"), Pattern.compile("^([\\w\\-_]+)\\.kt$"), TargetBackend.ANY, true);
        }

        @TestMetadata("notSubtype.kt")
        public void testNotSubtype() throws Exception {
            runTest("idea/testData/quickfix/addReturnToLastExpressionInFunction/notSubtype.kt");
        }

        @TestMetadata("nothing.kt")
        public void testNothing() throws Exception {
            runTest("idea/testData/quickfix/addReturnToLastExpressionInFunction/nothing.kt");
        }

        @TestMetadata("simpleBoolean.kt")
        public void testSimpleBoolean() throws Exception {
            runTest("idea/testData/quickfix/addReturnToLastExpressionInFunction/simpleBoolean.kt");
        }

        @TestMetadata("subtype.kt")
        public void testSubtype() throws Exception {
            runTest("idea/testData/quickfix/addReturnToLastExpressionInFunction/subtype.kt");
        }

        @TestMetadata("typeError.kt")
        public void testTypeError() throws Exception {
            runTest("idea/testData/quickfix/addReturnToLastExpressionInFunction/typeError.kt");
        }

        @TestMetadata("typeError2.kt")
        public void testTypeError2() throws Exception {
            runTest("idea/testData/quickfix/addReturnToLastExpressionInFunction/typeError2.kt");
        }
    }

    @TestMetadata("idea/testData/quickfix/addReturnToUnusedLastExpressionInFunction")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class AddReturnToUnusedLastExpressionInFunction extends AbstractQuickFixTest {
        private void runTest(String testDataFilePath) throws Exception {
            KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
        }

        public void testAllFilesPresentInAddReturnToUnusedLastExpressionInFunction() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/quickfix/addReturnToUnusedLastExpressionInFunction"), Pattern.compile("^([\\w\\-_]+)\\.kt$"), TargetBackend.ANY, true);
        }

        @TestMetadata("notSubtype.kt")
        public void testNotSubtype() throws Exception {
            runTest("idea/testData/quickfix/addReturnToUnusedLastExpressionInFunction/notSubtype.kt");
        }

        @TestMetadata("nothing.kt")
        public void testNothing() throws Exception {
            runTest("idea/testData/quickfix/addReturnToUnusedLastExpressionInFunction/nothing.kt");
        }

        @TestMetadata("simpleBoolean.kt")
        public void testSimpleBoolean() throws Exception {
            runTest("idea/testData/quickfix/addReturnToUnusedLastExpressionInFunction/simpleBoolean.kt");
        }

        @TestMetadata("subtype.kt")
        public void testSubtype() throws Exception {
            runTest("idea/testData/quickfix/addReturnToUnusedLastExpressionInFunction/subtype.kt");
        }

        @TestMetadata("typeError.kt")
        public void testTypeError() throws Exception {
            runTest("idea/testData/quickfix/addReturnToUnusedLastExpressionInFunction/typeError.kt");
        }

        @TestMetadata("typeError2.kt")
        public void testTypeError2() throws Exception {
            runTest("idea/testData/quickfix/addReturnToUnusedLastExpressionInFunction/typeError2.kt");
        }
    }

    @TestMetadata("idea/testData/quickfix/addRunBeforeLambda")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class AddRunBeforeLambda extends AbstractQuickFixTest {
        private void runTest(String testDataFilePath) throws Exception {
            KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
        }

        public void testAllFilesPresentInAddRunBeforeLambda() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/quickfix/addRunBeforeLambda"), Pattern.compile("^([\\w\\-_]+)\\.kt$"), TargetBackend.ANY, true);
        }

        @TestMetadata("basic.kt")
        public void testBasic() throws Exception {
            runTest("idea/testData/quickfix/addRunBeforeLambda/basic.kt");
        }
    }

    @TestMetadata("idea/testData/quickfix/addStarProjections")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class AddStarProjections extends AbstractQuickFixTest {
        private void runTest(String testDataFilePath) throws Exception {
            KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
        }

        public void testAllFilesPresentInAddStarProjections() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/quickfix/addStarProjections"), Pattern.compile("^([\\w\\-_]+)\\.kt$"), TargetBackend.ANY, true);
        }

        @TestMetadata("qualifiedArrayList.kt")
        public void testQualifiedArrayList() throws Exception {
            runTest("idea/testData/quickfix/addStarProjections/qualifiedArrayList.kt");
        }

        @TestMetadata("qualifiedList.kt")
        public void testQualifiedList() throws Exception {
            runTest("idea/testData/quickfix/addStarProjections/qualifiedList.kt");
        }

        @TestMetadata("qualifiedMap.kt")
        public void testQualifiedMap() throws Exception {
            runTest("idea/testData/quickfix/addStarProjections/qualifiedMap.kt");
        }

        @TestMetadata("unqualifiedList.kt")
        public void testUnqualifiedList() throws Exception {
            runTest("idea/testData/quickfix/addStarProjections/unqualifiedList.kt");
        }

        @TestMetadata("unqualifiedMap.kt")
        public void testUnqualifiedMap() throws Exception {
            runTest("idea/testData/quickfix/addStarProjections/unqualifiedMap.kt");
        }

        @TestMetadata("unqualifiedMapOneArg.kt")
        public void testUnqualifiedMapOneArg() throws Exception {
            runTest("idea/testData/quickfix/addStarProjections/unqualifiedMapOneArg.kt");
        }

        @TestMetadata("idea/testData/quickfix/addStarProjections/cast")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class Cast extends AbstractQuickFixTest {
            private void runTest(String testDataFilePath) throws Exception {
                KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
            }

            public void testAllFilesPresentInCast() throws Exception {
                KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/quickfix/addStarProjections/cast"), Pattern.compile("^([\\w\\-_]+)\\.kt$"), TargetBackend.ANY, true);
            }

            @TestMetadata("changeFunctionalToStarProjection.kt")
            public void testChangeFunctionalToStarProjection() throws Exception {
                runTest("idea/testData/quickfix/addStarProjections/cast/changeFunctionalToStarProjection.kt");
            }

            @TestMetadata("changeToStarProjection.kt")
            public void testChangeToStarProjection() throws Exception {
                runTest("idea/testData/quickfix/addStarProjections/cast/changeToStarProjection.kt");
            }

            @TestMetadata("changeToStarProjectionNullable.kt")
            public void testChangeToStarProjectionNullable() throws Exception {
                runTest("idea/testData/quickfix/addStarProjections/cast/changeToStarProjectionNullable.kt");
            }

            @TestMetadata("extensionReceiver.kt")
            public void testExtensionReceiver() throws Exception {
                runTest("idea/testData/quickfix/addStarProjections/cast/extensionReceiver.kt");
            }

            @TestMetadata("extensionReceiver2.kt")
            public void testExtensionReceiver2() throws Exception {
                runTest("idea/testData/quickfix/addStarProjections/cast/extensionReceiver2.kt");
            }

            @TestMetadata("extensionReceiver3.kt")
            public void testExtensionReceiver3() throws Exception {
                runTest("idea/testData/quickfix/addStarProjections/cast/extensionReceiver3.kt");
            }

            @TestMetadata("extensionReceiver4.kt")
            public void testExtensionReceiver4() throws Exception {
                runTest("idea/testData/quickfix/addStarProjections/cast/extensionReceiver4.kt");
            }

            @TestMetadata("extensionReceiver5.kt")
            public void testExtensionReceiver5() throws Exception {
                runTest("idea/testData/quickfix/addStarProjections/cast/extensionReceiver5.kt");
            }

            @TestMetadata("uncheckedCastOnTypeParameter.kt")
            public void testUncheckedCastOnTypeParameter() throws Exception {
                runTest("idea/testData/quickfix/addStarProjections/cast/uncheckedCastOnTypeParameter.kt");
            }

            @TestMetadata("valueArgument.kt")
            public void testValueArgument() throws Exception {
                runTest("idea/testData/quickfix/addStarProjections/cast/valueArgument.kt");
            }

            @TestMetadata("valueArgument2.kt")
            public void testValueArgument2() throws Exception {
                runTest("idea/testData/quickfix/addStarProjections/cast/valueArgument2.kt");
            }

            @TestMetadata("valueArgument3.kt")
            public void testValueArgument3() throws Exception {
                runTest("idea/testData/quickfix/addStarProjections/cast/valueArgument3.kt");
            }

            @TestMetadata("valueArgument4.kt")
            public void testValueArgument4() throws Exception {
                runTest("idea/testData/quickfix/addStarProjections/cast/valueArgument4.kt");
            }

            @TestMetadata("valueArgument5.kt")
            public void testValueArgument5() throws Exception {
                runTest("idea/testData/quickfix/addStarProjections/cast/valueArgument5.kt");
            }

            @TestMetadata("valueArgument6.kt")
            public void testValueArgument6() throws Exception {
                runTest("idea/testData/quickfix/addStarProjections/cast/valueArgument6.kt");
            }
        }

        @TestMetadata("idea/testData/quickfix/addStarProjections/checkType")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class CheckType extends AbstractQuickFixTest {
            private void runTest(String testDataFilePath) throws Exception {
                KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
            }

            public void testAllFilesPresentInCheckType() throws Exception {
                KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/quickfix/addStarProjections/checkType"), Pattern.compile("^([\\w\\-_]+)\\.kt$"), TargetBackend.ANY, true);
            }

            @TestMetadata("changeToStarProjectionMultipleParameters.kt")
            public void testChangeToStarProjectionMultipleParameters() throws Exception {
                runTest("idea/testData/quickfix/addStarProjections/checkType/changeToStarProjectionMultipleParameters.kt");
            }

            @TestMetadata("changeToStarProjectionNullable.kt")
            public void testChangeToStarProjectionNullable() throws Exception {
                runTest("idea/testData/quickfix/addStarProjections/checkType/changeToStarProjectionNullable.kt");
            }

            @TestMetadata("changeToStarProjectionSingleParameter.kt")
            public void testChangeToStarProjectionSingleParameter() throws Exception {
                runTest("idea/testData/quickfix/addStarProjections/checkType/changeToStarProjectionSingleParameter.kt");
            }
        }

        @TestMetadata("idea/testData/quickfix/addStarProjections/inner")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class Inner extends AbstractQuickFixTest {
            private void runTest(String testDataFilePath) throws Exception {
                KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
            }

            public void testAllFilesPresentInInner() throws Exception {
                KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/quickfix/addStarProjections/inner"), Pattern.compile("^([\\w\\-_]+)\\.kt$"), TargetBackend.ANY, true);
            }

            @TestMetadata("inner1.kt")
            public void testInner1() throws Exception {
                runTest("idea/testData/quickfix/addStarProjections/inner/inner1.kt");
            }

            @TestMetadata("inner2.kt")
            public void testInner2() throws Exception {
                runTest("idea/testData/quickfix/addStarProjections/inner/inner2.kt");
            }

            @TestMetadata("inner3.kt")
            public void testInner3() throws Exception {
                runTest("idea/testData/quickfix/addStarProjections/inner/inner3.kt");
            }

            @TestMetadata("inner4.kt")
            public void testInner4() throws Exception {
                runTest("idea/testData/quickfix/addStarProjections/inner/inner4.kt");
            }

            @TestMetadata("inner5.kt")
            public void testInner5() throws Exception {
                runTest("idea/testData/quickfix/addStarProjections/inner/inner5.kt");
            }

            @TestMetadata("inner6.kt")
            public void testInner6() throws Exception {
                runTest("idea/testData/quickfix/addStarProjections/inner/inner6.kt");
            }

            @TestMetadata("inner7.kt")
            public void testInner7() throws Exception {
                runTest("idea/testData/quickfix/addStarProjections/inner/inner7.kt");
            }

            @TestMetadata("inner8.kt")
            public void testInner8() throws Exception {
                runTest("idea/testData/quickfix/addStarProjections/inner/inner8.kt");
            }
        }

        @TestMetadata("idea/testData/quickfix/addStarProjections/when")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class When extends AbstractQuickFixTest {
            private void runTest(String testDataFilePath) throws Exception {
                KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
            }

            public void testAllFilesPresentInWhen() throws Exception {
                KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/quickfix/addStarProjections/when"), Pattern.compile("^([\\w\\-_]+)\\.kt$"), TargetBackend.ANY, true);
            }

            @TestMetadata("qualifiedArrayList.kt")
            public void testQualifiedArrayList() throws Exception {
                runTest("idea/testData/quickfix/addStarProjections/when/qualifiedArrayList.kt");
            }

            @TestMetadata("qualifiedList.kt")
            public void testQualifiedList() throws Exception {
                runTest("idea/testData/quickfix/addStarProjections/when/qualifiedList.kt");
            }

            @TestMetadata("qualifiedMap.kt")
            public void testQualifiedMap() throws Exception {
                runTest("idea/testData/quickfix/addStarProjections/when/qualifiedMap.kt");
            }

            @TestMetadata("unqualifiedList.kt")
            public void testUnqualifiedList() throws Exception {
                runTest("idea/testData/quickfix/addStarProjections/when/unqualifiedList.kt");
            }

            @TestMetadata("unqualifiedMap.kt")
            public void testUnqualifiedMap() throws Exception {
                runTest("idea/testData/quickfix/addStarProjections/when/unqualifiedMap.kt");
            }

            @TestMetadata("unqualifiedMapOneArg.kt")
            public void testUnqualifiedMapOneArg() throws Exception {
                runTest("idea/testData/quickfix/addStarProjections/when/unqualifiedMapOneArg.kt");
            }
        }
    }

    @TestMetadata("idea/testData/quickfix/addSuspend")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class AddSuspend extends AbstractQuickFixTest {
        private void runTest(String testDataFilePath) throws Exception {
            KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
        }

        public void testAllFilesPresentInAddSuspend() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/quickfix/addSuspend"), Pattern.compile("^([\\w\\-_]+)\\.kt$"), TargetBackend.ANY, true);
        }

        @TestMetadata("fakeOverride.kt")
        public void testFakeOverride() throws Exception {
            runTest("idea/testData/quickfix/addSuspend/fakeOverride.kt");
        }

        @TestMetadata("fakeOverride2.kt")
        public void testFakeOverride2() throws Exception {
            runTest("idea/testData/quickfix/addSuspend/fakeOverride2.kt");
        }

        @TestMetadata("middleClass.kt")
        public void testMiddleClass() throws Exception {
            runTest("idea/testData/quickfix/addSuspend/middleClass.kt");
        }

        @TestMetadata("middleClass2.kt")
        public void testMiddleClass2() throws Exception {
            runTest("idea/testData/quickfix/addSuspend/middleClass2.kt");
        }

        @TestMetadata("nonOverridden.kt")
        public void testNonOverridden() throws Exception {
            runTest("idea/testData/quickfix/addSuspend/nonOverridden.kt");
        }

        @TestMetadata("nonOverridden2.kt")
        public void testNonOverridden2() throws Exception {
            runTest("idea/testData/quickfix/addSuspend/nonOverridden2.kt");
        }
    }

    @TestMetadata("idea/testData/quickfix/addTypeAnnotationToValueParameter")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class AddTypeAnnotationToValueParameter extends AbstractQuickFixTest {
        private void runTest(String testDataFilePath) throws Exception {
            KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
        }

        public void testAllFilesPresentInAddTypeAnnotationToValueParameter() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/quickfix/addTypeAnnotationToValueParameter"), Pattern.compile("^([\\w\\-_]+)\\.kt$"), TargetBackend.ANY, true);
        }

        @TestMetadata("annotationWithArrayLiteralDouble.kt")
        public void testAnnotationWithArrayLiteralDouble() throws Exception {
            runTest("idea/testData/quickfix/addTypeAnnotationToValueParameter/annotationWithArrayLiteralDouble.kt");
        }

        @TestMetadata("annotationWithArrayLiteralInt.kt")
        public void testAnnotationWithArrayLiteralInt() throws Exception {
            runTest("idea/testData/quickfix/addTypeAnnotationToValueParameter/annotationWithArrayLiteralInt.kt");
        }

        @TestMetadata("annotationWithArrayLiteralString.kt")
        public void testAnnotationWithArrayLiteralString() throws Exception {
            runTest("idea/testData/quickfix/addTypeAnnotationToValueParameter/annotationWithArrayLiteralString.kt");
        }

        @TestMetadata("annotationWithVarargArrayLiteralDouble.kt")
        public void testAnnotationWithVarargArrayLiteralDouble() throws Exception {
            runTest("idea/testData/quickfix/addTypeAnnotationToValueParameter/annotationWithVarargArrayLiteralDouble.kt");
        }

        @TestMetadata("annotationWithVarargArrayLiteralInt.kt")
        public void testAnnotationWithVarargArrayLiteralInt() throws Exception {
            runTest("idea/testData/quickfix/addTypeAnnotationToValueParameter/annotationWithVarargArrayLiteralInt.kt");
        }

        @TestMetadata("annotationWithVarargArrayLiteralString.kt")
        public void testAnnotationWithVarargArrayLiteralString() throws Exception {
            runTest("idea/testData/quickfix/addTypeAnnotationToValueParameter/annotationWithVarargArrayLiteralString.kt");
        }

        @TestMetadata("annotationWithVarargDoubleArray.kt")
        public void testAnnotationWithVarargDoubleArray() throws Exception {
            runTest("idea/testData/quickfix/addTypeAnnotationToValueParameter/annotationWithVarargDoubleArray.kt");
        }

        @TestMetadata("annotationWithVarargIntArray.kt")
        public void testAnnotationWithVarargIntArray() throws Exception {
            runTest("idea/testData/quickfix/addTypeAnnotationToValueParameter/annotationWithVarargIntArray.kt");
        }

        @TestMetadata("noDefaultValue.kt")
        public void testNoDefaultValue() throws Exception {
            runTest("idea/testData/quickfix/addTypeAnnotationToValueParameter/noDefaultValue.kt");
        }

        @TestMetadata("simple.kt")
        public void testSimple() throws Exception {
            runTest("idea/testData/quickfix/addTypeAnnotationToValueParameter/simple.kt");
        }
    }

    @TestMetadata("idea/testData/quickfix/addValVar")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class AddValVar extends AbstractQuickFixTest {
        private void runTest(String testDataFilePath) throws Exception {
            KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
        }

        @TestMetadata("addVal.kt")
        public void testAddVal() throws Exception {
            runTest("idea/testData/quickfix/addValVar/addVal.kt");
        }

        @TestMetadata("addValAfterVarArg.kt")
        public void testAddValAfterVarArg() throws Exception {
            runTest("idea/testData/quickfix/addValVar/addValAfterVarArg.kt");
        }

        public void testAllFilesPresentInAddValVar() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/quickfix/addValVar"), Pattern.compile("^([\\w\\-_]+)\\.kt$"), TargetBackend.ANY, true);
        }
    }

    @TestMetadata("idea/testData/quickfix/addVarianceModifier")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class AddVarianceModifier extends AbstractQuickFixTest {
        private void runTest(String testDataFilePath) throws Exception {
            KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
        }

        @TestMetadata("abstractIn.kt")
        public void testAbstractIn() throws Exception {
            runTest("idea/testData/quickfix/addVarianceModifier/abstractIn.kt");
        }

        @TestMetadata("abstractOut.kt")
        public void testAbstractOut() throws Exception {
            runTest("idea/testData/quickfix/addVarianceModifier/abstractOut.kt");
        }

        public void testAllFilesPresentInAddVarianceModifier() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/quickfix/addVarianceModifier"), Pattern.compile("^([\\w\\-_]+)\\.kt$"), TargetBackend.ANY, true);
        }

        @TestMetadata("emptyTest.kt")
        public void testEmptyTest() throws Exception {
            runTest("idea/testData/quickfix/addVarianceModifier/emptyTest.kt");
        }
    }

    @TestMetadata("idea/testData/quickfix/assignOperatorAmbiguity")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class AssignOperatorAmbiguity extends AbstractQuickFixTest {
        private void runTest(String testDataFilePath) throws Exception {
            KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
        }

        public void testAllFilesPresentInAssignOperatorAmbiguity() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/quickfix/assignOperatorAmbiguity"), Pattern.compile("^([\\w\\-_]+)\\.kt$"), TargetBackend.ANY, true);
        }

        @TestMetadata("idea/testData/quickfix/assignOperatorAmbiguity/changeToVal")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class ChangeToVal extends AbstractQuickFixTest {
            private void runTest(String testDataFilePath) throws Exception {
                KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
            }

            public void testAllFilesPresentInChangeToVal() throws Exception {
                KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/quickfix/assignOperatorAmbiguity/changeToVal"), Pattern.compile("^([\\w\\-_]+)\\.kt$"), TargetBackend.ANY, true);
            }

            @TestMetadata("arrayList.kt")
            public void testArrayList() throws Exception {
                runTest("idea/testData/quickfix/assignOperatorAmbiguity/changeToVal/arrayList.kt");
            }

            @TestMetadata("classVariable.kt")
            public void testClassVariable() throws Exception {
                runTest("idea/testData/quickfix/assignOperatorAmbiguity/changeToVal/classVariable.kt");
            }

            @TestMetadata("hashMap.kt")
            public void testHashMap() throws Exception {
                runTest("idea/testData/quickfix/assignOperatorAmbiguity/changeToVal/hashMap.kt");
            }

            @TestMetadata("hashSet.kt")
            public void testHashSet() throws Exception {
                runTest("idea/testData/quickfix/assignOperatorAmbiguity/changeToVal/hashSet.kt");
            }

            @TestMetadata("mutableList.kt")
            public void testMutableList() throws Exception {
                runTest("idea/testData/quickfix/assignOperatorAmbiguity/changeToVal/mutableList.kt");
            }

            @TestMetadata("mutableMap.kt")
            public void testMutableMap() throws Exception {
                runTest("idea/testData/quickfix/assignOperatorAmbiguity/changeToVal/mutableMap.kt");
            }

            @TestMetadata("mutableSet.kt")
            public void testMutableSet() throws Exception {
                runTest("idea/testData/quickfix/assignOperatorAmbiguity/changeToVal/mutableSet.kt");
            }
        }

        @TestMetadata("idea/testData/quickfix/assignOperatorAmbiguity/replaceWithAssignCall")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class ReplaceWithAssignCall extends AbstractQuickFixTest {
            private void runTest(String testDataFilePath) throws Exception {
                KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
            }

            public void testAllFilesPresentInReplaceWithAssignCall() throws Exception {
                KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/quickfix/assignOperatorAmbiguity/replaceWithAssignCall"), Pattern.compile("^([\\w\\-_]+)\\.kt$"), TargetBackend.ANY, true);
            }

            @TestMetadata("arrayList.kt")
            public void testArrayList() throws Exception {
                runTest("idea/testData/quickfix/assignOperatorAmbiguity/replaceWithAssignCall/arrayList.kt");
            }

            @TestMetadata("hashMap.kt")
            public void testHashMap() throws Exception {
                runTest("idea/testData/quickfix/assignOperatorAmbiguity/replaceWithAssignCall/hashMap.kt");
            }

            @TestMetadata("hashSet.kt")
            public void testHashSet() throws Exception {
                runTest("idea/testData/quickfix/assignOperatorAmbiguity/replaceWithAssignCall/hashSet.kt");
            }

            @TestMetadata("mutableList.kt")
            public void testMutableList() throws Exception {
                runTest("idea/testData/quickfix/assignOperatorAmbiguity/replaceWithAssignCall/mutableList.kt");
            }

            @TestMetadata("mutableMap.kt")
            public void testMutableMap() throws Exception {
                runTest("idea/testData/quickfix/assignOperatorAmbiguity/replaceWithAssignCall/mutableMap.kt");
            }

            @TestMetadata("mutableSet.kt")
            public void testMutableSet() throws Exception {
                runTest("idea/testData/quickfix/assignOperatorAmbiguity/replaceWithAssignCall/mutableSet.kt");
            }
        }
    }

    @TestMetadata("idea/testData/quickfix/assignToProperty")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class AssignToProperty extends AbstractQuickFixTest {
        private void runTest(String testDataFilePath) throws Exception {
            KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
        }

        public void testAllFilesPresentInAssignToProperty() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/quickfix/assignToProperty"), Pattern.compile("^([\\w\\-_]+)\\.kt$"), TargetBackend.ANY, true);
        }

        @TestMetadata("differentNameProperty.kt")
        public void testDifferentNameProperty() throws Exception {
            runTest("idea/testData/quickfix/assignToProperty/differentNameProperty.kt");
        }

        @TestMetadata("differentNameProperty2.kt")
        public void testDifferentNameProperty2() throws Exception {
            runTest("idea/testData/quickfix/assignToProperty/differentNameProperty2.kt");
        }

        @TestMetadata("differentTypeProperty.kt")
        public void testDifferentTypeProperty() throws Exception {
            runTest("idea/testData/quickfix/assignToProperty/differentTypeProperty.kt");
        }

        @TestMetadata("differentTypeProperty2.kt")
        public void testDifferentTypeProperty2() throws Exception {
            runTest("idea/testData/quickfix/assignToProperty/differentTypeProperty2.kt");
        }

        @TestMetadata("inSecondaryConstructor.kt")
        public void testInSecondaryConstructor() throws Exception {
            runTest("idea/testData/quickfix/assignToProperty/inSecondaryConstructor.kt");
        }

        @TestMetadata("noProperty.kt")
        public void testNoProperty() throws Exception {
            runTest("idea/testData/quickfix/assignToProperty/noProperty.kt");
        }

        @TestMetadata("qualifiedThis.kt")
        public void testQualifiedThis() throws Exception {
            runTest("idea/testData/quickfix/assignToProperty/qualifiedThis.kt");
        }

        @TestMetadata("sameProperty.kt")
        public void testSameProperty() throws Exception {
            runTest("idea/testData/quickfix/assignToProperty/sameProperty.kt");
        }

        @TestMetadata("sameProperty2.kt")
        public void testSameProperty2() throws Exception {
            runTest("idea/testData/quickfix/assignToProperty/sameProperty2.kt");
        }

        @TestMetadata("sameProperty3.kt")
        public void testSameProperty3() throws Exception {
            runTest("idea/testData/quickfix/assignToProperty/sameProperty3.kt");
        }

        @TestMetadata("valProperty.kt")
        public void testValProperty() throws Exception {
            runTest("idea/testData/quickfix/assignToProperty/valProperty.kt");
        }

        @TestMetadata("valProperty2.kt")
        public void testValProperty2() throws Exception {
            runTest("idea/testData/quickfix/assignToProperty/valProperty2.kt");
        }
    }

    @TestMetadata("idea/testData/quickfix/autoImports")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class AutoImports extends AbstractQuickFixTest {
        private void runTest(String testDataFilePath) throws Exception {
            KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
        }

        public void testAllFilesPresentInAutoImports() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/quickfix/autoImports"), Pattern.compile("^([\\w\\-_]+)\\.kt$"), TargetBackend.ANY, true);
        }

        @TestMetadata("checkNoStackOverflowInImportInnerClassInCurrentFile.kt")
        public void testCheckNoStackOverflowInImportInnerClassInCurrentFile() throws Exception {
            runTest("idea/testData/quickfix/autoImports/checkNoStackOverflowInImportInnerClassInCurrentFile.kt");
        }

        @TestMetadata("enumEntries.kt")
        public void testEnumEntries() throws Exception {
            runTest("idea/testData/quickfix/autoImports/enumEntries.kt");
        }

        @TestMetadata("enumEntriesJsRuntime.kt")
        public void testEnumEntriesJsRuntime() throws Exception {
            runTest("idea/testData/quickfix/autoImports/enumEntriesJsRuntime.kt");
        }

        @TestMetadata("excludedCoroutineImpl.kt")
        public void testExcludedCoroutineImpl() throws Exception {
            runTest("idea/testData/quickfix/autoImports/excludedCoroutineImpl.kt");
        }

        @TestMetadata("excludedCoroutineIntrinsics.kt")
        public void testExcludedCoroutineIntrinsics() throws Exception {
            runTest("idea/testData/quickfix/autoImports/excludedCoroutineIntrinsics.kt");
        }

        @TestMetadata("excludedFromImport.kt")
        public void testExcludedFromImport() throws Exception {
            runTest("idea/testData/quickfix/autoImports/excludedFromImport.kt");
        }

        @TestMetadata("inPrimaryConstructor.kt")
        public void testInPrimaryConstructor() throws Exception {
            runTest("idea/testData/quickfix/autoImports/inPrimaryConstructor.kt");
        }

        @TestMetadata("infixCallAndObject.kt")
        public void testInfixCallAndObject() throws Exception {
            runTest("idea/testData/quickfix/autoImports/infixCallAndObject.kt");
        }

        @TestMetadata("kt17525.kt")
        public void testKt17525() throws Exception {
            runTest("idea/testData/quickfix/autoImports/kt17525.kt");
        }

        @TestMetadata("libraryPropertyJsRuntime.kt")
        public void testLibraryPropertyJsRuntime() throws Exception {
            runTest("idea/testData/quickfix/autoImports/libraryPropertyJsRuntime.kt");
        }

        @TestMetadata("libraryPropertyRuntime.kt")
        public void testLibraryPropertyRuntime() throws Exception {
            runTest("idea/testData/quickfix/autoImports/libraryPropertyRuntime.kt");
        }

        @TestMetadata("libraryTopLevelFunctionImportJsRuntime.kt")
        public void testLibraryTopLevelFunctionImportJsRuntime() throws Exception {
            runTest("idea/testData/quickfix/autoImports/libraryTopLevelFunctionImportJsRuntime.kt");
        }

        @TestMetadata("libraryTopLevelFunctionImportRuntime.kt")
        public void testLibraryTopLevelFunctionImportRuntime() throws Exception {
            runTest("idea/testData/quickfix/autoImports/libraryTopLevelFunctionImportRuntime.kt");
        }

        @TestMetadata("namelessClass.kt")
        public void testNamelessClass() throws Exception {
            runTest("idea/testData/quickfix/autoImports/namelessClass.kt");
        }

        @TestMetadata("namelessFunction.kt")
        public void testNamelessFunction() throws Exception {
            runTest("idea/testData/quickfix/autoImports/namelessFunction.kt");
        }

        @TestMetadata("namelessObject.kt")
        public void testNamelessObject() throws Exception {
            runTest("idea/testData/quickfix/autoImports/namelessObject.kt");
        }

        @TestMetadata("namelessParameter.kt")
        public void testNamelessParameter() throws Exception {
            runTest("idea/testData/quickfix/autoImports/namelessParameter.kt");
        }

        @TestMetadata("namelessProperty.kt")
        public void testNamelessProperty() throws Exception {
            runTest("idea/testData/quickfix/autoImports/namelessProperty.kt");
        }

        @TestMetadata("noImportForAlreadyImported.kt")
        public void testNoImportForAlreadyImported() throws Exception {
            runTest("idea/testData/quickfix/autoImports/noImportForAlreadyImported.kt");
        }

        @TestMetadata("noImportForIndex.kt")
        public void testNoImportForIndex() throws Exception {
            runTest("idea/testData/quickfix/autoImports/noImportForIndex.kt");
        }

        @TestMetadata("notExcludedFromImportWhenInternalUse.kt")
        public void testNotExcludedFromImportWhenInternalUse() throws Exception {
            runTest("idea/testData/quickfix/autoImports/notExcludedFromImportWhenInternalUse.kt");
        }

        @TestMetadata("notForThisLabel.kt")
        public void testNotForThisLabel() throws Exception {
            runTest("idea/testData/quickfix/autoImports/notForThisLabel.kt");
        }

        @TestMetadata("sAMConstructorFromLambda.kt")
        public void testSAMConstructorFromLambda() throws Exception {
            runTest("idea/testData/quickfix/autoImports/sAMConstructorFromLambda.kt");
        }

        @TestMetadata("unresolvedReferenceInCall.kt")
        public void testUnresolvedReferenceInCall() throws Exception {
            runTest("idea/testData/quickfix/autoImports/unresolvedReferenceInCall.kt");
        }

        @TestMetadata("idea/testData/quickfix/autoImports/kt21515")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class Kt21515 extends AbstractQuickFixTest {
            private void runTest(String testDataFilePath) throws Exception {
                KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
            }

            public void testAllFilesPresentInKt21515() throws Exception {
                KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/quickfix/autoImports/kt21515"), Pattern.compile("^([\\w\\-_]+)\\.kt$"), TargetBackend.ANY, true);
            }

            @TestMetadata("callableReferenceFromDeprecated.kt")
            public void testCallableReferenceFromDeprecated() throws Exception {
                runTest("idea/testData/quickfix/autoImports/kt21515/callableReferenceFromDeprecated.kt");
            }

            @TestMetadata("classifierFromCompanionObjectDeprecationEnabled.kt")
            public void testClassifierFromCompanionObjectDeprecationEnabled() throws Exception {
                runTest("idea/testData/quickfix/autoImports/kt21515/classifierFromCompanionObjectDeprecationEnabled.kt");
            }

            @TestMetadata("constructorFromDeprecated.kt")
            public void testConstructorFromDeprecated() throws Exception {
                runTest("idea/testData/quickfix/autoImports/kt21515/constructorFromDeprecated.kt");
            }
        }

        @TestMetadata("idea/testData/quickfix/autoImports/mismatchingArgs")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class MismatchingArgs extends AbstractQuickFixTest {
            private void runTest(String testDataFilePath) throws Exception {
                KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
            }

            public void testAllFilesPresentInMismatchingArgs() throws Exception {
                KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/quickfix/autoImports/mismatchingArgs"), Pattern.compile("^([\\w\\-_]+)\\.kt$"), TargetBackend.ANY, true);
            }
        }
    }

    @TestMetadata("idea/testData/quickfix/canBeParameter")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class CanBeParameter extends AbstractQuickFixTest {
        private void runTest(String testDataFilePath) throws Exception {
            KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
        }

        public void testAllFilesPresentInCanBeParameter() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/quickfix/canBeParameter"), Pattern.compile("^([\\w\\-_]+)\\.kt$"), TargetBackend.ANY, true);
        }

        @TestMetadata("usedInDerivedClass.kt")
        public void testUsedInDerivedClass() throws Exception {
            runTest("idea/testData/quickfix/canBeParameter/usedInDerivedClass.kt");
        }

        @TestMetadata("usedInProperty.kt")
        public void testUsedInProperty() throws Exception {
            runTest("idea/testData/quickfix/canBeParameter/usedInProperty.kt");
        }

        @TestMetadata("usedPrivateInInitializer.kt")
        public void testUsedPrivateInInitializer() throws Exception {
            runTest("idea/testData/quickfix/canBeParameter/usedPrivateInInitializer.kt");
        }

        @TestMetadata("usedVarArg.kt")
        public void testUsedVarArg() throws Exception {
            runTest("idea/testData/quickfix/canBeParameter/usedVarArg.kt");
        }
    }

    @TestMetadata("idea/testData/quickfix/canBePrimaryConstructorProperty")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class CanBePrimaryConstructorProperty extends AbstractQuickFixTest {
        private void runTest(String testDataFilePath) throws Exception {
            KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
        }

        public void testAllFilesPresentInCanBePrimaryConstructorProperty() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/quickfix/canBePrimaryConstructorProperty"), Pattern.compile("^([\\w\\-_]+)\\.kt$"), TargetBackend.ANY, true);
        }

        @TestMetadata("commentAfter.kt")
        public void testCommentAfter() throws Exception {
            runTest("idea/testData/quickfix/canBePrimaryConstructorProperty/commentAfter.kt");
        }

        @TestMetadata("commentAhead.kt")
        public void testCommentAhead() throws Exception {
            runTest("idea/testData/quickfix/canBePrimaryConstructorProperty/commentAhead.kt");
        }

        @TestMetadata("protectedOpenVar.kt")
        public void testProtectedOpenVar() throws Exception {
            runTest("idea/testData/quickfix/canBePrimaryConstructorProperty/protectedOpenVar.kt");
        }

        @TestMetadata("simple.kt")
        public void testSimple() throws Exception {
            runTest("idea/testData/quickfix/canBePrimaryConstructorProperty/simple.kt");
        }

        @TestMetadata("vararg.kt")
        public void testVararg() throws Exception {
            runTest("idea/testData/quickfix/canBePrimaryConstructorProperty/vararg.kt");
        }
    }

    @TestMetadata("idea/testData/quickfix/changeFeatureSupport")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class ChangeFeatureSupport extends AbstractQuickFixTest {
        private void runTest(String testDataFilePath) throws Exception {
            KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
        }

        public void testAllFilesPresentInChangeFeatureSupport() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/quickfix/changeFeatureSupport"), Pattern.compile("^([\\w\\-_]+)\\.kt$"), TargetBackend.ANY, true);
        }

        @TestMetadata("inlineClass.kt")
        public void testInlineClass() throws Exception {
            runTest("idea/testData/quickfix/changeFeatureSupport/inlineClass.kt");
        }
    }

    @TestMetadata("idea/testData/quickfix/changeSignature")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class ChangeSignature extends AbstractQuickFixTest {
        private void runTest(String testDataFilePath) throws Exception {
            KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
        }

        @TestMetadata("addConstructorParameter.kt")
        public void testAddConstructorParameter() throws Exception {
            runTest("idea/testData/quickfix/changeSignature/addConstructorParameter.kt");
        }

        @TestMetadata("addEnumConstructorParameter.kt")
        public void testAddEnumConstructorParameter() throws Exception {
            runTest("idea/testData/quickfix/changeSignature/addEnumConstructorParameter.kt");
        }

        @TestMetadata("addEnumConstructorParameter2.kt")
        public void testAddEnumConstructorParameter2() throws Exception {
            runTest("idea/testData/quickfix/changeSignature/addEnumConstructorParameter2.kt");
        }

        @TestMetadata("addEnumConstructorParameter3.kt")
        public void testAddEnumConstructorParameter3() throws Exception {
            runTest("idea/testData/quickfix/changeSignature/addEnumConstructorParameter3.kt");
        }

        @TestMetadata("addEnumConstructorParameter4.kt")
        public void testAddEnumConstructorParameter4() throws Exception {
            runTest("idea/testData/quickfix/changeSignature/addEnumConstructorParameter4.kt");
        }

        @TestMetadata("addEnumConstructorParameter5.kt")
        public void testAddEnumConstructorParameter5() throws Exception {
            runTest("idea/testData/quickfix/changeSignature/addEnumConstructorParameter5.kt");
        }

        @TestMetadata("addFunctionParameter.kt")
        public void testAddFunctionParameter() throws Exception {
            runTest("idea/testData/quickfix/changeSignature/addFunctionParameter.kt");
        }

        @TestMetadata("addFunctionParameterAndChangeTypes.kt")
        public void testAddFunctionParameterAndChangeTypes() throws Exception {
            runTest("idea/testData/quickfix/changeSignature/addFunctionParameterAndChangeTypes.kt");
        }

        @TestMetadata("addFunctionParameterLongNameRuntime.kt")
        public void testAddFunctionParameterLongNameRuntime() throws Exception {
            runTest("idea/testData/quickfix/changeSignature/addFunctionParameterLongNameRuntime.kt");
        }

        @TestMetadata("addFunctionParameterWithSmartCast.kt")
        public void testAddFunctionParameterWithSmartCast() throws Exception {
            runTest("idea/testData/quickfix/changeSignature/addFunctionParameterWithSmartCast.kt");
        }

        @TestMetadata("addFunctionParameterWithSmartcastedArgument.kt")
        public void testAddFunctionParameterWithSmartcastedArgument() throws Exception {
            runTest("idea/testData/quickfix/changeSignature/addFunctionParameterWithSmartcastedArgument.kt");
        }

        @TestMetadata("addNothingReturnType.kt")
        public void testAddNothingReturnType() throws Exception {
            runTest("idea/testData/quickfix/changeSignature/addNothingReturnType.kt");
        }

        @TestMetadata("addParameterNotAvailableForBuiltins.kt")
        public void testAddParameterNotAvailableForBuiltins() throws Exception {
            runTest("idea/testData/quickfix/changeSignature/addParameterNotAvailableForBuiltins.kt");
        }

        @TestMetadata("addParameterNotAvailableForLibrary.kt")
        public void testAddParameterNotAvailableForLibrary() throws Exception {
            runTest("idea/testData/quickfix/changeSignature/addParameterNotAvailableForLibrary.kt");
        }

        @TestMetadata("addParameterToFakeOverride.kt")
        public void testAddParameterToFakeOverride() throws Exception {
            runTest("idea/testData/quickfix/changeSignature/addParameterToFakeOverride.kt");
        }

        public void testAllFilesPresentInChangeSignature() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/quickfix/changeSignature"), Pattern.compile("^([\\w\\-_]+)\\.kt$"), TargetBackend.ANY, true);
        }

        @TestMetadata("changeFunctionLiteralParameters1.kt")
        public void testChangeFunctionLiteralParameters1() throws Exception {
            runTest("idea/testData/quickfix/changeSignature/changeFunctionLiteralParameters1.kt");
        }

        @TestMetadata("changeFunctionLiteralParameters2.kt")
        public void testChangeFunctionLiteralParameters2() throws Exception {
            runTest("idea/testData/quickfix/changeSignature/changeFunctionLiteralParameters2.kt");
        }

        @TestMetadata("complexHierarchy.kt")
        public void testComplexHierarchy() throws Exception {
            runTest("idea/testData/quickfix/changeSignature/complexHierarchy.kt");
        }

        @TestMetadata("complexHierarchyHead.kt")
        public void testComplexHierarchyHead() throws Exception {
            runTest("idea/testData/quickfix/changeSignature/complexHierarchyHead.kt");
        }

        @TestMetadata("complexHierarchyTail.kt")
        public void testComplexHierarchyTail() throws Exception {
            runTest("idea/testData/quickfix/changeSignature/complexHierarchyTail.kt");
        }

        @TestMetadata("fixExtensionLambdaSignature.kt")
        public void testFixExtensionLambdaSignature() throws Exception {
            runTest("idea/testData/quickfix/changeSignature/fixExtensionLambdaSignature.kt");
        }

        @TestMetadata("linearHierarchy.kt")
        public void testLinearHierarchy() throws Exception {
            runTest("idea/testData/quickfix/changeSignature/linearHierarchy.kt");
        }

        @TestMetadata("notAvailableForSynthesized.kt")
        public void testNotAvailableForSynthesized() throws Exception {
            runTest("idea/testData/quickfix/changeSignature/notAvailableForSynthesized.kt");
        }

        @TestMetadata("notEditable.kt")
        public void testNotEditable() throws Exception {
            runTest("idea/testData/quickfix/changeSignature/notEditable.kt");
        }

        @TestMetadata("removeConstructorParameter.kt")
        public void testRemoveConstructorParameter() throws Exception {
            runTest("idea/testData/quickfix/changeSignature/removeConstructorParameter.kt");
        }

        @TestMetadata("removeFunctionFirstParameter.kt")
        public void testRemoveFunctionFirstParameter() throws Exception {
            runTest("idea/testData/quickfix/changeSignature/removeFunctionFirstParameter.kt");
        }

        @TestMetadata("removeFunctionSecondParameter1.kt")
        public void testRemoveFunctionSecondParameter1() throws Exception {
            runTest("idea/testData/quickfix/changeSignature/removeFunctionSecondParameter1.kt");
        }

        @TestMetadata("removeFunctionSecondParameter2.kt")
        public void testRemoveFunctionSecondParameter2() throws Exception {
            runTest("idea/testData/quickfix/changeSignature/removeFunctionSecondParameter2.kt");
        }

        @TestMetadata("removeNamedParameter.kt")
        public void testRemoveNamedParameter() throws Exception {
            runTest("idea/testData/quickfix/changeSignature/removeNamedParameter.kt");
        }

        @TestMetadata("removeParameterFromExtension.kt")
        public void testRemoveParameterFromExtension() throws Exception {
            runTest("idea/testData/quickfix/changeSignature/removeParameterFromExtension.kt");
        }

        @TestMetadata("removeParameterFromFakeOverride.kt")
        public void testRemoveParameterFromFakeOverride() throws Exception {
            runTest("idea/testData/quickfix/changeSignature/removeParameterFromFakeOverride.kt");
        }

        @TestMetadata("removeParameterNotAvailableForBuiltins.kt")
        public void testRemoveParameterNotAvailableForBuiltins() throws Exception {
            runTest("idea/testData/quickfix/changeSignature/removeParameterNotAvailableForBuiltins.kt");
        }

        @TestMetadata("removeUnusedConstructorParameterWithUsage.kt")
        public void testRemoveUnusedConstructorParameterWithUsage() throws Exception {
            runTest("idea/testData/quickfix/changeSignature/removeUnusedConstructorParameterWithUsage.kt");
        }

        @TestMetadata("removeUnusedExtensionParameter.kt")
        public void testRemoveUnusedExtensionParameter() throws Exception {
            runTest("idea/testData/quickfix/changeSignature/removeUnusedExtensionParameter.kt");
        }

        @TestMetadata("removeUnusedInternalConstructorParameter.kt")
        public void testRemoveUnusedInternalConstructorParameter() throws Exception {
            runTest("idea/testData/quickfix/changeSignature/removeUnusedInternalConstructorParameter.kt");
        }

        @TestMetadata("removeUnusedParameter.kt")
        public void testRemoveUnusedParameter() throws Exception {
            runTest("idea/testData/quickfix/changeSignature/removeUnusedParameter.kt");
        }

        @TestMetadata("removeUnusedParameterOfPropertySetter.kt")
        public void testRemoveUnusedParameterOfPropertySetter() throws Exception {
            runTest("idea/testData/quickfix/changeSignature/removeUnusedParameterOfPropertySetter.kt");
        }

        @TestMetadata("removeUnusedParameterWithTypeParameter.kt")
        public void testRemoveUnusedParameterWithTypeParameter() throws Exception {
            runTest("idea/testData/quickfix/changeSignature/removeUnusedParameterWithTypeParameter.kt");
        }

        @TestMetadata("removeUnusedParameterWithTypeParameter2.kt")
        public void testRemoveUnusedParameterWithTypeParameter2() throws Exception {
            runTest("idea/testData/quickfix/changeSignature/removeUnusedParameterWithTypeParameter2.kt");
        }

        @TestMetadata("removeUnusedParameterWithTypeParameter3.kt")
        public void testRemoveUnusedParameterWithTypeParameter3() throws Exception {
            runTest("idea/testData/quickfix/changeSignature/removeUnusedParameterWithTypeParameter3.kt");
        }

        @TestMetadata("removeUnusedParameterWithTypeParameter4.kt")
        public void testRemoveUnusedParameterWithTypeParameter4() throws Exception {
            runTest("idea/testData/quickfix/changeSignature/removeUnusedParameterWithTypeParameter4.kt");
        }

        @TestMetadata("removeUnusedParameterWithTypeParameter5.kt")
        public void testRemoveUnusedParameterWithTypeParameter5() throws Exception {
            runTest("idea/testData/quickfix/changeSignature/removeUnusedParameterWithTypeParameter5.kt");
        }

        @TestMetadata("removeUnusedParameterWithTypeParameter6.kt")
        public void testRemoveUnusedParameterWithTypeParameter6() throws Exception {
            runTest("idea/testData/quickfix/changeSignature/removeUnusedParameterWithTypeParameter6.kt");
        }

        @TestMetadata("removeUnusedParameterWithTypeParameter7.kt")
        public void testRemoveUnusedParameterWithTypeParameter7() throws Exception {
            runTest("idea/testData/quickfix/changeSignature/removeUnusedParameterWithTypeParameter7.kt");
        }

        @TestMetadata("removeUnusedParameterWithTypeParameterAndTypeConstraint.kt")
        public void testRemoveUnusedParameterWithTypeParameterAndTypeConstraint() throws Exception {
            runTest("idea/testData/quickfix/changeSignature/removeUnusedParameterWithTypeParameterAndTypeConstraint.kt");
        }

        @TestMetadata("removeUnusedParameterWithTypeParameterAndTypeConstraint2.kt")
        public void testRemoveUnusedParameterWithTypeParameterAndTypeConstraint2() throws Exception {
            runTest("idea/testData/quickfix/changeSignature/removeUnusedParameterWithTypeParameterAndTypeConstraint2.kt");
        }

        @TestMetadata("removeUnusedPrimaryConstructorParameter.kt")
        public void testRemoveUnusedPrimaryConstructorParameter() throws Exception {
            runTest("idea/testData/quickfix/changeSignature/removeUnusedPrimaryConstructorParameter.kt");
        }

        @TestMetadata("removeUnusedPrimaryConstructorParameter2.kt")
        public void testRemoveUnusedPrimaryConstructorParameter2() throws Exception {
            runTest("idea/testData/quickfix/changeSignature/removeUnusedPrimaryConstructorParameter2.kt");
        }

        @TestMetadata("idea/testData/quickfix/changeSignature/jk")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class Jk extends AbstractQuickFixTest {
            private void runTest(String testDataFilePath) throws Exception {
                KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
            }

            public void testAllFilesPresentInJk() throws Exception {
                KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/quickfix/changeSignature/jk"), Pattern.compile("^([\\w\\-_]+)\\.kt$"), TargetBackend.ANY, true);
            }
        }

        @TestMetadata("idea/testData/quickfix/changeSignature/kj")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class Kj extends AbstractQuickFixTest {
            private void runTest(String testDataFilePath) throws Exception {
                KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
            }

            public void testAllFilesPresentInKj() throws Exception {
                KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/quickfix/changeSignature/kj"), Pattern.compile("^([\\w\\-_]+)\\.kt$"), TargetBackend.ANY, true);
            }
        }
    }

    @TestMetadata("idea/testData/quickfix/changeSuperTypeListEntryTypeArgument")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class ChangeSuperTypeListEntryTypeArgument extends AbstractQuickFixTest {
        private void runTest(String testDataFilePath) throws Exception {
            KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
        }

        public void testAllFilesPresentInChangeSuperTypeListEntryTypeArgument() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/quickfix/changeSuperTypeListEntryTypeArgument"), Pattern.compile("^([\\w\\-_]+)\\.kt$"), TargetBackend.ANY, true);
        }

        @TestMetadata("propertyTypeMismatchOnOverride.kt")
        public void testPropertyTypeMismatchOnOverride() throws Exception {
            runTest("idea/testData/quickfix/changeSuperTypeListEntryTypeArgument/propertyTypeMismatchOnOverride.kt");
        }

        @TestMetadata("propertyTypeMismatchOnOverride2.kt")
        public void testPropertyTypeMismatchOnOverride2() throws Exception {
            runTest("idea/testData/quickfix/changeSuperTypeListEntryTypeArgument/propertyTypeMismatchOnOverride2.kt");
        }

        @TestMetadata("returnTypeMismatchOnOverride.kt")
        public void testReturnTypeMismatchOnOverride() throws Exception {
            runTest("idea/testData/quickfix/changeSuperTypeListEntryTypeArgument/returnTypeMismatchOnOverride.kt");
        }

        @TestMetadata("returnTypeMismatchOnOverride2.kt")
        public void testReturnTypeMismatchOnOverride2() throws Exception {
            runTest("idea/testData/quickfix/changeSuperTypeListEntryTypeArgument/returnTypeMismatchOnOverride2.kt");
        }
    }

    @TestMetadata("idea/testData/quickfix/changeToLabeledReturn")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class ChangeToLabeledReturn extends AbstractQuickFixTest {
        private void runTest(String testDataFilePath) throws Exception {
            KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
        }

        public void testAllFilesPresentInChangeToLabeledReturn() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/quickfix/changeToLabeledReturn"), Pattern.compile("^([\\w\\-_]+)\\.kt$"), TargetBackend.ANY, true);
        }

        @TestMetadata("multipleInner.kt")
        public void testMultipleInner() throws Exception {
            runTest("idea/testData/quickfix/changeToLabeledReturn/multipleInner.kt");
        }

        @TestMetadata("multipleOuter.kt")
        public void testMultipleOuter() throws Exception {
            runTest("idea/testData/quickfix/changeToLabeledReturn/multipleOuter.kt");
        }

        @TestMetadata("noCandidates.kt")
        public void testNoCandidates() throws Exception {
            runTest("idea/testData/quickfix/changeToLabeledReturn/noCandidates.kt");
        }

        @TestMetadata("normal.kt")
        public void testNormal() throws Exception {
            runTest("idea/testData/quickfix/changeToLabeledReturn/normal.kt");
        }
    }

    @TestMetadata("idea/testData/quickfix/changeToMutableCollection")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class ChangeToMutableCollection extends AbstractQuickFixTest {
        private void runTest(String testDataFilePath) throws Exception {
            KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
        }

        public void testAllFilesPresentInChangeToMutableCollection() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/quickfix/changeToMutableCollection"), Pattern.compile("^([\\w\\-_]+)\\.kt$"), TargetBackend.ANY, true);
        }

        @TestMetadata("list.kt")
        public void testList() throws Exception {
            runTest("idea/testData/quickfix/changeToMutableCollection/list.kt");
        }

        @TestMetadata("list2.kt")
        public void testList2() throws Exception {
            runTest("idea/testData/quickfix/changeToMutableCollection/list2.kt");
        }

        @TestMetadata("map.kt")
        public void testMap() throws Exception {
            runTest("idea/testData/quickfix/changeToMutableCollection/map.kt");
        }

        @TestMetadata("map2.kt")
        public void testMap2() throws Exception {
            runTest("idea/testData/quickfix/changeToMutableCollection/map2.kt");
        }

        @TestMetadata("set.kt")
        public void testSet() throws Exception {
            runTest("idea/testData/quickfix/changeToMutableCollection/set.kt");
        }
    }

    @TestMetadata("idea/testData/quickfix/changeToUseSpreadOperator")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class ChangeToUseSpreadOperator extends AbstractQuickFixTest {
        private void runTest(String testDataFilePath) throws Exception {
            KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
        }

        public void testAllFilesPresentInChangeToUseSpreadOperator() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/quickfix/changeToUseSpreadOperator"), Pattern.compile("^([\\w\\-_]+)\\.kt$"), TargetBackend.ANY, true);
        }

        @TestMetadata("differentTypeParameter.kt")
        public void testDifferentTypeParameter() throws Exception {
            runTest("idea/testData/quickfix/changeToUseSpreadOperator/differentTypeParameter.kt");
        }

        @TestMetadata("mapOf.kt")
        public void testMapOf() throws Exception {
            runTest("idea/testData/quickfix/changeToUseSpreadOperator/mapOf.kt");
        }

        @TestMetadata("multipleParams.kt")
        public void testMultipleParams() throws Exception {
            runTest("idea/testData/quickfix/changeToUseSpreadOperator/multipleParams.kt");
        }

        @TestMetadata("nonArray.kt")
        public void testNonArray() throws Exception {
            runTest("idea/testData/quickfix/changeToUseSpreadOperator/nonArray.kt");
        }

        @TestMetadata("nonVarArg.kt")
        public void testNonVarArg() throws Exception {
            runTest("idea/testData/quickfix/changeToUseSpreadOperator/nonVarArg.kt");
        }

        @TestMetadata("normal.kt")
        public void testNormal() throws Exception {
            runTest("idea/testData/quickfix/changeToUseSpreadOperator/normal.kt");
        }

        @TestMetadata("stdlibMapOf.kt")
        public void testStdlibMapOf() throws Exception {
            runTest("idea/testData/quickfix/changeToUseSpreadOperator/stdlibMapOf.kt");
        }

        @TestMetadata("vararg.kt")
        public void testVararg() throws Exception {
            runTest("idea/testData/quickfix/changeToUseSpreadOperator/vararg.kt");
        }
    }

    @TestMetadata("idea/testData/quickfix/checkArguments")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class CheckArguments extends AbstractQuickFixTest {
        private void runTest(String testDataFilePath) throws Exception {
            KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
        }

        public void testAllFilesPresentInCheckArguments() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/quickfix/checkArguments"), Pattern.compile("^([\\w\\-_]+)\\.kt$"), TargetBackend.ANY, true);
        }

        @TestMetadata("nonVarargSpread.kt")
        public void testNonVarargSpread() throws Exception {
            runTest("idea/testData/quickfix/checkArguments/nonVarargSpread.kt");
        }

        @TestMetadata("idea/testData/quickfix/checkArguments/addNameToArgument")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class AddNameToArgument extends AbstractQuickFixTest {
            private void runTest(String testDataFilePath) throws Exception {
                KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
            }

            public void testAllFilesPresentInAddNameToArgument() throws Exception {
                KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/quickfix/checkArguments/addNameToArgument"), Pattern.compile("^([\\w\\-_]+)\\.kt$"), TargetBackend.ANY, true);
            }

            @TestMetadata("invokeOnString.kt")
            public void testInvokeOnString() throws Exception {
                runTest("idea/testData/quickfix/checkArguments/addNameToArgument/invokeOnString.kt");
            }

            @TestMetadata("mixedNamedAndPositionalArguments.kt")
            public void testMixedNamedAndPositionalArguments() throws Exception {
                runTest("idea/testData/quickfix/checkArguments/addNameToArgument/mixedNamedAndPositionalArguments.kt");
            }

            @TestMetadata("mixedNamedAndPositionalArgumentsConstructor.kt")
            public void testMixedNamedAndPositionalArgumentsConstructor() throws Exception {
                runTest("idea/testData/quickfix/checkArguments/addNameToArgument/mixedNamedAndPositionalArgumentsConstructor.kt");
            }

            @TestMetadata("mixedNamedAndPositionalArgumentsMultiple.kt")
            public void testMixedNamedAndPositionalArgumentsMultiple() throws Exception {
                runTest("idea/testData/quickfix/checkArguments/addNameToArgument/mixedNamedAndPositionalArgumentsMultiple.kt");
            }

            @TestMetadata("mixedNamedAndPositionalArgumentsSubtype.kt")
            public void testMixedNamedAndPositionalArgumentsSubtype() throws Exception {
                runTest("idea/testData/quickfix/checkArguments/addNameToArgument/mixedNamedAndPositionalArgumentsSubtype.kt");
            }

            @TestMetadata("mixedNamedAndPositionalArgumentsUsedNamed.kt")
            public void testMixedNamedAndPositionalArgumentsUsedNamed() throws Exception {
                runTest("idea/testData/quickfix/checkArguments/addNameToArgument/mixedNamedAndPositionalArgumentsUsedNamed.kt");
            }

            @TestMetadata("mixedNamedAndPositionalArgumentsUsedPositional.kt")
            public void testMixedNamedAndPositionalArgumentsUsedPositional() throws Exception {
                runTest("idea/testData/quickfix/checkArguments/addNameToArgument/mixedNamedAndPositionalArgumentsUsedPositional.kt");
            }
        }
    }

    @TestMetadata("idea/testData/quickfix/conflictingImports")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class ConflictingImports extends AbstractQuickFixTest {
        private void runTest(String testDataFilePath) throws Exception {
            KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
        }

        public void testAllFilesPresentInConflictingImports() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/quickfix/conflictingImports"), Pattern.compile("^([\\w\\-_]+)\\.kt$"), TargetBackend.ANY, true);
        }

        @TestMetadata("removeConflictingImport.kt")
        public void testRemoveConflictingImport() throws Exception {
            runTest("idea/testData/quickfix/conflictingImports/removeConflictingImport.kt");
        }

        @TestMetadata("removeDuplicateImport.kt")
        public void testRemoveDuplicateImport() throws Exception {
            runTest("idea/testData/quickfix/conflictingImports/removeDuplicateImport.kt");
        }

        @TestMetadata("removeDuplicateImportWithAlias.kt")
        public void testRemoveDuplicateImportWithAlias() throws Exception {
            runTest("idea/testData/quickfix/conflictingImports/removeDuplicateImportWithAlias.kt");
        }
    }

    @TestMetadata("idea/testData/quickfix/convertJavaInterfaceToClass")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class ConvertJavaInterfaceToClass extends AbstractQuickFixTest {
        private void runTest(String testDataFilePath) throws Exception {
            KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
        }

        public void testAllFilesPresentInConvertJavaInterfaceToClass() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/quickfix/convertJavaInterfaceToClass"), Pattern.compile("^([\\w\\-_]+)\\.kt$"), TargetBackend.ANY, true);
        }
    }

    @TestMetadata("idea/testData/quickfix/convertPropertyInitializerToGetter")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class ConvertPropertyInitializerToGetter extends AbstractQuickFixTest {
        private void runTest(String testDataFilePath) throws Exception {
            KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
        }

        public void testAllFilesPresentInConvertPropertyInitializerToGetter() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/quickfix/convertPropertyInitializerToGetter"), Pattern.compile("^([\\w\\-_]+)\\.kt$"), TargetBackend.ANY, true);
        }

        @TestMetadata("val.kt")
        public void testVal() throws Exception {
            runTest("idea/testData/quickfix/convertPropertyInitializerToGetter/val.kt");
        }

        @TestMetadata("var.kt")
        public void testVar() throws Exception {
            runTest("idea/testData/quickfix/convertPropertyInitializerToGetter/var.kt");
        }

        @TestMetadata("varWithSetter.kt")
        public void testVarWithSetter() throws Exception {
            runTest("idea/testData/quickfix/convertPropertyInitializerToGetter/varWithSetter.kt");
        }
    }

    @TestMetadata("idea/testData/quickfix/convertToAnonymousObject")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class ConvertToAnonymousObject extends AbstractQuickFixTest {
        private void runTest(String testDataFilePath) throws Exception {
            KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
        }

        public void testAllFilesPresentInConvertToAnonymousObject() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/quickfix/convertToAnonymousObject"), Pattern.compile("^([\\w\\-_]+)\\.kt$"), TargetBackend.ANY, true);
        }

        @TestMetadata("labeledReturn.kt")
        public void testLabeledReturn() throws Exception {
            runTest("idea/testData/quickfix/convertToAnonymousObject/labeledReturn.kt");
        }

        @TestMetadata("multiMethod.kt")
        public void testMultiMethod() throws Exception {
            runTest("idea/testData/quickfix/convertToAnonymousObject/multiMethod.kt");
        }

        @TestMetadata("parameter.kt")
        public void testParameter() throws Exception {
            runTest("idea/testData/quickfix/convertToAnonymousObject/parameter.kt");
        }

        @TestMetadata("simple.kt")
        public void testSimple() throws Exception {
            runTest("idea/testData/quickfix/convertToAnonymousObject/simple.kt");
        }

        @TestMetadata("unit.kt")
        public void testUnit() throws Exception {
            runTest("idea/testData/quickfix/convertToAnonymousObject/unit.kt");
        }
    }

    @TestMetadata("idea/testData/quickfix/createFromUsage")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class CreateFromUsage extends AbstractQuickFixTest {
        private void runTest(String testDataFilePath) throws Exception {
            KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
        }

        public void testAllFilesPresentInCreateFromUsage() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/quickfix/createFromUsage"), Pattern.compile("^([\\w\\-_]+)\\.kt$"), TargetBackend.ANY, true);
        }

        @TestMetadata("idea/testData/quickfix/createFromUsage/createClass")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class CreateClass extends AbstractQuickFixTest {
            private void runTest(String testDataFilePath) throws Exception {
                KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
            }

            public void testAllFilesPresentInCreateClass() throws Exception {
                KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/quickfix/createFromUsage/createClass"), Pattern.compile("^([\\w\\-_]+)\\.kt$"), TargetBackend.ANY, true);
            }

            @TestMetadata("idea/testData/quickfix/createFromUsage/createClass/annotationEntry")
            @TestDataPath("$PROJECT_ROOT")
            @RunWith(JUnit3RunnerWithInners.class)
            public static class AnnotationEntry extends AbstractQuickFixTest {
                private void runTest(String testDataFilePath) throws Exception {
                    KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
                }

                public void testAllFilesPresentInAnnotationEntry() throws Exception {
                    KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/quickfix/createFromUsage/createClass/annotationEntry"), Pattern.compile("^([\\w\\-_]+)\\.kt$"), TargetBackend.ANY, true);
                }

                @TestMetadata("annotationNoBrackets.kt")
                public void testAnnotationNoBrackets() throws Exception {
                    runTest("idea/testData/quickfix/createFromUsage/createClass/annotationEntry/annotationNoBrackets.kt");
                }

                @TestMetadata("annotationNoParamList.kt")
                public void testAnnotationNoParamList() throws Exception {
                    runTest("idea/testData/quickfix/createFromUsage/createClass/annotationEntry/annotationNoParamList.kt");
                }

                @TestMetadata("annotationNoParams.kt")
                public void testAnnotationNoParams() throws Exception {
                    runTest("idea/testData/quickfix/createFromUsage/createClass/annotationEntry/annotationNoParams.kt");
                }

                @TestMetadata("annotationWithParams.kt")
                public void testAnnotationWithParams() throws Exception {
                    runTest("idea/testData/quickfix/createFromUsage/createClass/annotationEntry/annotationWithParams.kt");
                }

                @TestMetadata("annotationWithTypeParams.kt")
                public void testAnnotationWithTypeParams() throws Exception {
                    runTest("idea/testData/quickfix/createFromUsage/createClass/annotationEntry/annotationWithTypeParams.kt");
                }

                @TestMetadata("notAnnotation.kt")
                public void testNotAnnotation() throws Exception {
                    runTest("idea/testData/quickfix/createFromUsage/createClass/annotationEntry/notAnnotation.kt");
                }

                @TestMetadata("singleArgAnnotation.kt")
                public void testSingleArgAnnotation() throws Exception {
                    runTest("idea/testData/quickfix/createFromUsage/createClass/annotationEntry/singleArgAnnotation.kt");
                }

                @TestMetadata("singleNamedArgAnnotation.kt")
                public void testSingleNamedArgAnnotation() throws Exception {
                    runTest("idea/testData/quickfix/createFromUsage/createClass/annotationEntry/singleNamedArgAnnotation.kt");
                }
            }

            @TestMetadata("idea/testData/quickfix/createFromUsage/createClass/callExpression")
            @TestDataPath("$PROJECT_ROOT")
            @RunWith(JUnit3RunnerWithInners.class)
            public static class CallExpression extends AbstractQuickFixTest {
                private void runTest(String testDataFilePath) throws Exception {
                    KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
                }

                public void testAllFilesPresentInCallExpression() throws Exception {
                    KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/quickfix/createFromUsage/createClass/callExpression"), Pattern.compile("^([\\w\\-_]+)\\.kt$"), TargetBackend.ANY, true);
                }

                @TestMetadata("callInAnnotationEntry.kt")
                public void testCallInAnnotationEntry() throws Exception {
                    runTest("idea/testData/quickfix/createFromUsage/createClass/callExpression/callInAnnotationEntry.kt");
                }

                @TestMetadata("callInLambda.kt")
                public void testCallInLambda() throws Exception {
                    runTest("idea/testData/quickfix/createFromUsage/createClass/callExpression/callInLambda.kt");
                }

                @TestMetadata("callInLocalFunNoReceiver.kt")
                public void testCallInLocalFunNoReceiver() throws Exception {
                    runTest("idea/testData/quickfix/createFromUsage/createClass/callExpression/callInLocalFunNoReceiver.kt");
                }

                @TestMetadata("callInMemberFunNoReceiver.kt")
                public void testCallInMemberFunNoReceiver() throws Exception {
                    runTest("idea/testData/quickfix/createFromUsage/createClass/callExpression/callInMemberFunNoReceiver.kt");
                }

                @TestMetadata("callInMemberValDelegateRuntime.kt")
                public void testCallInMemberValDelegateRuntime() throws Exception {
                    runTest("idea/testData/quickfix/createFromUsage/createClass/callExpression/callInMemberValDelegateRuntime.kt");
                }

                @TestMetadata("callInMemberVarDelegateRuntime.kt")
                public void testCallInMemberVarDelegateRuntime() throws Exception {
                    runTest("idea/testData/quickfix/createFromUsage/createClass/callExpression/callInMemberVarDelegateRuntime.kt");
                }

                @TestMetadata("callInWhenEntry.kt")
                public void testCallInWhenEntry() throws Exception {
                    runTest("idea/testData/quickfix/createFromUsage/createClass/callExpression/callInWhenEntry.kt");
                }

                @TestMetadata("callNoReceiver.kt")
                public void testCallNoReceiver() throws Exception {
                    runTest("idea/testData/quickfix/createFromUsage/createClass/callExpression/callNoReceiver.kt");
                }

                @TestMetadata("callWithClassQualifier.kt")
                public void testCallWithClassQualifier() throws Exception {
                    runTest("idea/testData/quickfix/createFromUsage/createClass/callExpression/callWithClassQualifier.kt");
                }

                @TestMetadata("callWithExplicitParamNames.kt")
                public void testCallWithExplicitParamNames() throws Exception {
                    runTest("idea/testData/quickfix/createFromUsage/createClass/callExpression/callWithExplicitParamNames.kt");
                }

                @TestMetadata("callWithExtraArgs.kt")
                public void testCallWithExtraArgs() throws Exception {
                    runTest("idea/testData/quickfix/createFromUsage/createClass/callExpression/callWithExtraArgs.kt");
                }

                @TestMetadata("callWithFinalSupertype.kt")
                public void testCallWithFinalSupertype() throws Exception {
                    runTest("idea/testData/quickfix/createFromUsage/createClass/callExpression/callWithFinalSupertype.kt");
                }

                @TestMetadata("callWithGenericReceiver.kt")
                public void testCallWithGenericReceiver() throws Exception {
                    runTest("idea/testData/quickfix/createFromUsage/createClass/callExpression/callWithGenericReceiver.kt");
                }

                @TestMetadata("callWithLambdaArg.kt")
                public void testCallWithLambdaArg() throws Exception {
                    runTest("idea/testData/quickfix/createFromUsage/createClass/callExpression/callWithLambdaArg.kt");
                }

                @TestMetadata("callWithLambdaArgOnly.kt")
                public void testCallWithLambdaArgOnly() throws Exception {
                    runTest("idea/testData/quickfix/createFromUsage/createClass/callExpression/callWithLambdaArgOnly.kt");
                }

                @TestMetadata("callWithLibClassQualifier.kt")
                public void testCallWithLibClassQualifier() throws Exception {
                    runTest("idea/testData/quickfix/createFromUsage/createClass/callExpression/callWithLibClassQualifier.kt");
                }

                @TestMetadata("callWithMissingArgs.kt")
                public void testCallWithMissingArgs() throws Exception {
                    runTest("idea/testData/quickfix/createFromUsage/createClass/callExpression/callWithMissingArgs.kt");
                }

                @TestMetadata("callWithObjectQualifier.kt")
                public void testCallWithObjectQualifier() throws Exception {
                    runTest("idea/testData/quickfix/createFromUsage/createClass/callExpression/callWithObjectQualifier.kt");
                }

                @TestMetadata("callWithPackageName.kt")
                public void testCallWithPackageName() throws Exception {
                    runTest("idea/testData/quickfix/createFromUsage/createClass/callExpression/callWithPackageName.kt");
                }

                @TestMetadata("callWithReceiver.kt")
                public void testCallWithReceiver() throws Exception {
                    runTest("idea/testData/quickfix/createFromUsage/createClass/callExpression/callWithReceiver.kt");
                }

                @TestMetadata("callWithSuperclassNoConstructorParams.kt")
                public void testCallWithSuperclassNoConstructorParams() throws Exception {
                    runTest("idea/testData/quickfix/createFromUsage/createClass/callExpression/callWithSuperclassNoConstructorParams.kt");
                }

                @TestMetadata("callWithSuperclassWithConstructorParams.kt")
                public void testCallWithSuperclassWithConstructorParams() throws Exception {
                    runTest("idea/testData/quickfix/createFromUsage/createClass/callExpression/callWithSuperclassWithConstructorParams.kt");
                }

                @TestMetadata("callWithSupertrait.kt")
                public void testCallWithSupertrait() throws Exception {
                    runTest("idea/testData/quickfix/createFromUsage/createClass/callExpression/callWithSupertrait.kt");
                }

                @TestMetadata("callWithThisReceiverInClass.kt")
                public void testCallWithThisReceiverInClass() throws Exception {
                    runTest("idea/testData/quickfix/createFromUsage/createClass/callExpression/callWithThisReceiverInClass.kt");
                }

                @TestMetadata("callWithThisReceiverInExtension.kt")
                public void testCallWithThisReceiverInExtension() throws Exception {
                    runTest("idea/testData/quickfix/createFromUsage/createClass/callExpression/callWithThisReceiverInExtension.kt");
                }

                @TestMetadata("callWithThisReceiverInNestedClass1.kt")
                public void testCallWithThisReceiverInNestedClass1() throws Exception {
                    runTest("idea/testData/quickfix/createFromUsage/createClass/callExpression/callWithThisReceiverInNestedClass1.kt");
                }

                @TestMetadata("callWithThisReceiverInNestedClass2.kt")
                public void testCallWithThisReceiverInNestedClass2() throws Exception {
                    runTest("idea/testData/quickfix/createFromUsage/createClass/callExpression/callWithThisReceiverInNestedClass2.kt");
                }

                @TestMetadata("callWithTypeArgsInAnnotationEntry.kt")
                public void testCallWithTypeArgsInAnnotationEntry() throws Exception {
                    runTest("idea/testData/quickfix/createFromUsage/createClass/callExpression/callWithTypeArgsInAnnotationEntry.kt");
                }

                @TestMetadata("createNestedClass.kt")
                public void testCreateNestedClass() throws Exception {
                    runTest("idea/testData/quickfix/createFromUsage/createClass/callExpression/createNestedClass.kt");
                }

                @TestMetadata("createNestedClassInInner.kt")
                public void testCreateNestedClassInInner() throws Exception {
                    runTest("idea/testData/quickfix/createFromUsage/createClass/callExpression/createNestedClassInInner.kt");
                }

                @TestMetadata("expectedTypeBySuperFunction.kt")
                public void testExpectedTypeBySuperFunction() throws Exception {
                    runTest("idea/testData/quickfix/createFromUsage/createClass/callExpression/expectedTypeBySuperFunction.kt");
                }

                @TestMetadata("inReturn.kt")
                public void testInReturn() throws Exception {
                    runTest("idea/testData/quickfix/createFromUsage/createClass/callExpression/inReturn.kt");
                }

                @TestMetadata("inReturn2.kt")
                public void testInReturn2() throws Exception {
                    runTest("idea/testData/quickfix/createFromUsage/createClass/callExpression/inReturn2.kt");
                }

                @TestMetadata("notApplicableInReturn.kt")
                public void testNotApplicableInReturn() throws Exception {
                    runTest("idea/testData/quickfix/createFromUsage/createClass/callExpression/notApplicableInReturn.kt");
                }

                @TestMetadata("quotedName.kt")
                public void testQuotedName() throws Exception {
                    runTest("idea/testData/quickfix/createFromUsage/createClass/callExpression/quotedName.kt");
                }

                @TestMetadata("singleArgCallInAnnotationEntry.kt")
                public void testSingleArgCallInAnnotationEntry() throws Exception {
                    runTest("idea/testData/quickfix/createFromUsage/createClass/callExpression/singleArgCallInAnnotationEntry.kt");
                }

                @TestMetadata("singleNamedArgCallInAnnotationEntry.kt")
                public void testSingleNamedArgCallInAnnotationEntry() throws Exception {
                    runTest("idea/testData/quickfix/createFromUsage/createClass/callExpression/singleNamedArgCallInAnnotationEntry.kt");
                }

                @TestMetadata("unusedCallResult.kt")
                public void testUnusedCallResult() throws Exception {
                    runTest("idea/testData/quickfix/createFromUsage/createClass/callExpression/unusedCallResult.kt");
                }

                @TestMetadata("idea/testData/quickfix/createFromUsage/createClass/callExpression/typeArguments")
                @TestDataPath("$PROJECT_ROOT")
                @RunWith(JUnit3RunnerWithInners.class)
                public static class TypeArguments extends AbstractQuickFixTest {
                    private void runTest(String testDataFilePath) throws Exception {
                        KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
                    }

                    public void testAllFilesPresentInTypeArguments() throws Exception {
                        KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/quickfix/createFromUsage/createClass/callExpression/typeArguments"), Pattern.compile("^([\\w\\-_]+)\\.kt$"), TargetBackend.ANY, true);
                    }

                    @TestMetadata("callWithStarProjection.kt")
                    public void testCallWithStarProjection() throws Exception {
                        runTest("idea/testData/quickfix/createFromUsage/createClass/callExpression/typeArguments/callWithStarProjection.kt");
                    }

                    @TestMetadata("classMember.kt")
                    public void testClassMember() throws Exception {
                        runTest("idea/testData/quickfix/createFromUsage/createClass/callExpression/typeArguments/classMember.kt");
                    }

                    @TestMetadata("classMemberInner.kt")
                    public void testClassMemberInner() throws Exception {
                        runTest("idea/testData/quickfix/createFromUsage/createClass/callExpression/typeArguments/classMemberInner.kt");
                    }

                    @TestMetadata("classMemberInnerPartialSubstitution.kt")
                    public void testClassMemberInnerPartialSubstitution() throws Exception {
                        runTest("idea/testData/quickfix/createFromUsage/createClass/callExpression/typeArguments/classMemberInnerPartialSubstitution.kt");
                    }

                    @TestMetadata("classMemberInnerWithReceiverArg.kt")
                    public void testClassMemberInnerWithReceiverArg() throws Exception {
                        runTest("idea/testData/quickfix/createFromUsage/createClass/callExpression/typeArguments/classMemberInnerWithReceiverArg.kt");
                    }

                    @TestMetadata("classMemberPartialSubstitution.kt")
                    public void testClassMemberPartialSubstitution() throws Exception {
                        runTest("idea/testData/quickfix/createFromUsage/createClass/callExpression/typeArguments/classMemberPartialSubstitution.kt");
                    }

                    @TestMetadata("extension.kt")
                    public void testExtension() throws Exception {
                        runTest("idea/testData/quickfix/createFromUsage/createClass/callExpression/typeArguments/extension.kt");
                    }

                    @TestMetadata("noReceiver.kt")
                    public void testNoReceiver() throws Exception {
                        runTest("idea/testData/quickfix/createFromUsage/createClass/callExpression/typeArguments/noReceiver.kt");
                    }

                    @TestMetadata("noReceiverExtraArgs.kt")
                    public void testNoReceiverExtraArgs() throws Exception {
                        runTest("idea/testData/quickfix/createFromUsage/createClass/callExpression/typeArguments/noReceiverExtraArgs.kt");
                    }

                    @TestMetadata("noReceiverLongName.kt")
                    public void testNoReceiverLongName() throws Exception {
                        runTest("idea/testData/quickfix/createFromUsage/createClass/callExpression/typeArguments/noReceiverLongName.kt");
                    }

                    @TestMetadata("noReceiverPartialSubstitution.kt")
                    public void testNoReceiverPartialSubstitution() throws Exception {
                        runTest("idea/testData/quickfix/createFromUsage/createClass/callExpression/typeArguments/noReceiverPartialSubstitution.kt");
                    }

                    @TestMetadata("withExpectedTypeNoReceiver.kt")
                    public void testWithExpectedTypeNoReceiver() throws Exception {
                        runTest("idea/testData/quickfix/createFromUsage/createClass/callExpression/typeArguments/withExpectedTypeNoReceiver.kt");
                    }
                }
            }

            @TestMetadata("idea/testData/quickfix/createFromUsage/createClass/delegationSpecifier")
            @TestDataPath("$PROJECT_ROOT")
            @RunWith(JUnit3RunnerWithInners.class)
            public static class DelegationSpecifier extends AbstractQuickFixTest {
                private void runTest(String testDataFilePath) throws Exception {
                    KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
                }

                public void testAllFilesPresentInDelegationSpecifier() throws Exception {
                    KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/quickfix/createFromUsage/createClass/delegationSpecifier"), Pattern.compile("^([\\w\\-_]+)\\.kt$"), TargetBackend.ANY, true);
                }

                @TestMetadata("classDelegatorToSuperclass.kt")
                public void testClassDelegatorToSuperclass() throws Exception {
                    runTest("idea/testData/quickfix/createFromUsage/createClass/delegationSpecifier/classDelegatorToSuperclass.kt");
                }

                @TestMetadata("createSuperclassInsideSubclass.kt")
                public void testCreateSuperclassInsideSubclass() throws Exception {
                    runTest("idea/testData/quickfix/createFromUsage/createClass/delegationSpecifier/createSuperclassInsideSubclass.kt");
                }

                @TestMetadata("delegatorToSupercallNoReceiver.kt")
                public void testDelegatorToSupercallNoReceiver() throws Exception {
                    runTest("idea/testData/quickfix/createFromUsage/createClass/delegationSpecifier/delegatorToSupercallNoReceiver.kt");
                }

                @TestMetadata("delegatorToSupercallWithClassQualifier.kt")
                public void testDelegatorToSupercallWithClassQualifier() throws Exception {
                    runTest("idea/testData/quickfix/createFromUsage/createClass/delegationSpecifier/delegatorToSupercallWithClassQualifier.kt");
                }

                @TestMetadata("delegatorToSupercallWithPackageQualifier.kt")
                public void testDelegatorToSupercallWithPackageQualifier() throws Exception {
                    runTest("idea/testData/quickfix/createFromUsage/createClass/delegationSpecifier/delegatorToSupercallWithPackageQualifier.kt");
                }

                @TestMetadata("delegatorToSupercallWithParamNames.kt")
                public void testDelegatorToSupercallWithParamNames() throws Exception {
                    runTest("idea/testData/quickfix/createFromUsage/createClass/delegationSpecifier/delegatorToSupercallWithParamNames.kt");
                }

                @TestMetadata("delegatorToSupercallWithTypeParams.kt")
                public void testDelegatorToSupercallWithTypeParams() throws Exception {
                    runTest("idea/testData/quickfix/createFromUsage/createClass/delegationSpecifier/delegatorToSupercallWithTypeParams.kt");
                }

                @TestMetadata("traitDelegatorToSuperclass.kt")
                public void testTraitDelegatorToSuperclass() throws Exception {
                    runTest("idea/testData/quickfix/createFromUsage/createClass/delegationSpecifier/traitDelegatorToSuperclass.kt");
                }

                @TestMetadata("traitDelegatorToSuperclass2.kt")
                public void testTraitDelegatorToSuperclass2() throws Exception {
                    runTest("idea/testData/quickfix/createFromUsage/createClass/delegationSpecifier/traitDelegatorToSuperclass2.kt");
                }
            }

            @TestMetadata("idea/testData/quickfix/createFromUsage/createClass/importDirective")
            @TestDataPath("$PROJECT_ROOT")
            @RunWith(JUnit3RunnerWithInners.class)
            public static class ImportDirective extends AbstractQuickFixTest {
                private void runTest(String testDataFilePath) throws Exception {
                    KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
                }

                public void testAllFilesPresentInImportDirective() throws Exception {
                    KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/quickfix/createFromUsage/createClass/importDirective"), Pattern.compile("^([\\w\\-_]+)\\.kt$"), TargetBackend.ANY, true);
                }

                @TestMetadata("annotationInPackage.kt")
                public void testAnnotationInPackage() throws Exception {
                    runTest("idea/testData/quickfix/createFromUsage/createClass/importDirective/annotationInPackage.kt");
                }

                @TestMetadata("annotationWithQualifier.kt")
                public void testAnnotationWithQualifier() throws Exception {
                    runTest("idea/testData/quickfix/createFromUsage/createClass/importDirective/annotationWithQualifier.kt");
                }

                @TestMetadata("classInPackage.kt")
                public void testClassInPackage() throws Exception {
                    runTest("idea/testData/quickfix/createFromUsage/createClass/importDirective/classInPackage.kt");
                }

                @TestMetadata("classWithQualifier.kt")
                public void testClassWithQualifier() throws Exception {
                    runTest("idea/testData/quickfix/createFromUsage/createClass/importDirective/classWithQualifier.kt");
                }

                @TestMetadata("enumEntryInEnum.kt")
                public void testEnumEntryInEnum() throws Exception {
                    runTest("idea/testData/quickfix/createFromUsage/createClass/importDirective/enumEntryInEnum.kt");
                }

                @TestMetadata("enumEntryInPackage.kt")
                public void testEnumEntryInPackage() throws Exception {
                    runTest("idea/testData/quickfix/createFromUsage/createClass/importDirective/enumEntryInPackage.kt");
                }

                @TestMetadata("enumEntryWithQualifier.kt")
                public void testEnumEntryWithQualifier() throws Exception {
                    runTest("idea/testData/quickfix/createFromUsage/createClass/importDirective/enumEntryWithQualifier.kt");
                }

                @TestMetadata("enumInPackage.kt")
                public void testEnumInPackage() throws Exception {
                    runTest("idea/testData/quickfix/createFromUsage/createClass/importDirective/enumInPackage.kt");
                }

                @TestMetadata("enumWithQualifier.kt")
                public void testEnumWithQualifier() throws Exception {
                    runTest("idea/testData/quickfix/createFromUsage/createClass/importDirective/enumWithQualifier.kt");
                }

                @TestMetadata("objectInPackage.kt")
                public void testObjectInPackage() throws Exception {
                    runTest("idea/testData/quickfix/createFromUsage/createClass/importDirective/objectInPackage.kt");
                }

                @TestMetadata("objectWithQualifier.kt")
                public void testObjectWithQualifier() throws Exception {
                    runTest("idea/testData/quickfix/createFromUsage/createClass/importDirective/objectWithQualifier.kt");
                }

                @TestMetadata("traitInPackage.kt")
                public void testTraitInPackage() throws Exception {
                    runTest("idea/testData/quickfix/createFromUsage/createClass/importDirective/traitInPackage.kt");
                }

                @TestMetadata("traitWithQualifier.kt")
                public void testTraitWithQualifier() throws Exception {
                    runTest("idea/testData/quickfix/createFromUsage/createClass/importDirective/traitWithQualifier.kt");
                }

                @TestMetadata("idea/testData/quickfix/createFromUsage/createClass/importDirective/kt21515")
                @TestDataPath("$PROJECT_ROOT")
                @RunWith(JUnit3RunnerWithInners.class)
                public static class Kt21515 extends AbstractQuickFixTest {
                    private void runTest(String testDataFilePath) throws Exception {
                        KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
                    }

                    public void testAllFilesPresentInKt21515() throws Exception {
                        KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/quickfix/createFromUsage/createClass/importDirective/kt21515"), Pattern.compile("^([\\w\\-_]+)\\.kt$"), TargetBackend.ANY, true);
                    }

                    @TestMetadata("callableReferenceOnClass.kt")
                    public void testCallableReferenceOnClass() throws Exception {
                        runTest("idea/testData/quickfix/createFromUsage/createClass/importDirective/kt21515/callableReferenceOnClass.kt");
                    }

                    @TestMetadata("callableReferenceOnClassWithCompanion.kt")
                    public void testCallableReferenceOnClassWithCompanion() throws Exception {
                        runTest("idea/testData/quickfix/createFromUsage/createClass/importDirective/kt21515/callableReferenceOnClassWithCompanion.kt");
                    }

                    @TestMetadata("callableReferenceOnObject.kt")
                    public void testCallableReferenceOnObject() throws Exception {
                        runTest("idea/testData/quickfix/createFromUsage/createClass/importDirective/kt21515/callableReferenceOnObject.kt");
                    }

                    @TestMetadata("constructor.kt")
                    public void testConstructor() throws Exception {
                        runTest("idea/testData/quickfix/createFromUsage/createClass/importDirective/kt21515/constructor.kt");
                    }

                    @TestMetadata("typeReference.kt")
                    public void testTypeReference() throws Exception {
                        runTest("idea/testData/quickfix/createFromUsage/createClass/importDirective/kt21515/typeReference.kt");
                    }
                }
            }

            @TestMetadata("idea/testData/quickfix/createFromUsage/createClass/referenceExpression")
            @TestDataPath("$PROJECT_ROOT")
            @RunWith(JUnit3RunnerWithInners.class)
            public static class ReferenceExpression extends AbstractQuickFixTest {
                private void runTest(String testDataFilePath) throws Exception {
                    KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
                }

                public void testAllFilesPresentInReferenceExpression() throws Exception {
                    KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/quickfix/createFromUsage/createClass/referenceExpression"), Pattern.compile("^([\\w\\-_]+)\\.kt$"), TargetBackend.ANY, true);
                }

                @TestMetadata("annotationByClassLiteral.kt")
                public void testAnnotationByClassLiteral() throws Exception {
                    runTest("idea/testData/quickfix/createFromUsage/createClass/referenceExpression/annotationByClassLiteral.kt");
                }

                @TestMetadata("annotationNoReceiver.kt")
                public void testAnnotationNoReceiver() throws Exception {
                    runTest("idea/testData/quickfix/createFromUsage/createClass/referenceExpression/annotationNoReceiver.kt");
                }

                @TestMetadata("classByClassLiteral.kt")
                public void testClassByClassLiteral() throws Exception {
                    runTest("idea/testData/quickfix/createFromUsage/createClass/referenceExpression/classByClassLiteral.kt");
                }

                @TestMetadata("classByNestedQualifier.kt")
                public void testClassByNestedQualifier() throws Exception {
                    runTest("idea/testData/quickfix/createFromUsage/createClass/referenceExpression/classByNestedQualifier.kt");
                }

                @TestMetadata("classByQualifier.kt")
                public void testClassByQualifier() throws Exception {
                    runTest("idea/testData/quickfix/createFromUsage/createClass/referenceExpression/classByQualifier.kt");
                }

                @TestMetadata("classInPackage.kt")
                public void testClassInPackage() throws Exception {
                    runTest("idea/testData/quickfix/createFromUsage/createClass/referenceExpression/classInPackage.kt");
                }

                @TestMetadata("classInPrimaryConstructor.kt")
                public void testClassInPrimaryConstructor() throws Exception {
                    runTest("idea/testData/quickfix/createFromUsage/createClass/referenceExpression/classInPrimaryConstructor.kt");
                }

                @TestMetadata("classNoReceiver.kt")
                public void testClassNoReceiver() throws Exception {
                    runTest("idea/testData/quickfix/createFromUsage/createClass/referenceExpression/classNoReceiver.kt");
                }

                @TestMetadata("classWithQualifier.kt")
                public void testClassWithQualifier() throws Exception {
                    runTest("idea/testData/quickfix/createFromUsage/createClass/referenceExpression/classWithQualifier.kt");
                }

                @TestMetadata("classWithReceiver.kt")
                public void testClassWithReceiver() throws Exception {
                    runTest("idea/testData/quickfix/createFromUsage/createClass/referenceExpression/classWithReceiver.kt");
                }

                @TestMetadata("createNestedObject.kt")
                public void testCreateNestedObject() throws Exception {
                    runTest("idea/testData/quickfix/createFromUsage/createClass/referenceExpression/createNestedObject.kt");
                }

                @TestMetadata("createNestedObjectInInner.kt")
                public void testCreateNestedObjectInInner() throws Exception {
                    runTest("idea/testData/quickfix/createFromUsage/createClass/referenceExpression/createNestedObjectInInner.kt");
                }

                @TestMetadata("enumByClassLiteral.kt")
                public void testEnumByClassLiteral() throws Exception {
                    runTest("idea/testData/quickfix/createFromUsage/createClass/referenceExpression/enumByClassLiteral.kt");
                }

                @TestMetadata("enumByQualifier.kt")
                public void testEnumByQualifier() throws Exception {
                    runTest("idea/testData/quickfix/createFromUsage/createClass/referenceExpression/enumByQualifier.kt");
                }

                @TestMetadata("enumEntryAddComma.kt")
                public void testEnumEntryAddComma() throws Exception {
                    runTest("idea/testData/quickfix/createFromUsage/createClass/referenceExpression/enumEntryAddComma.kt");
                }

                @TestMetadata("enumEntryHasComma.kt")
                public void testEnumEntryHasComma() throws Exception {
                    runTest("idea/testData/quickfix/createFromUsage/createClass/referenceExpression/enumEntryHasComma.kt");
                }

                @TestMetadata("enumEntryNoReceiver.kt")
                public void testEnumEntryNoReceiver() throws Exception {
                    runTest("idea/testData/quickfix/createFromUsage/createClass/referenceExpression/enumEntryNoReceiver.kt");
                }

                @TestMetadata("enumEntryWithEnumQualifier.kt")
                public void testEnumEntryWithEnumQualifier() throws Exception {
                    runTest("idea/testData/quickfix/createFromUsage/createClass/referenceExpression/enumEntryWithEnumQualifier.kt");
                }

                @TestMetadata("enumEntryWithEnumQualifierAndParams.kt")
                public void testEnumEntryWithEnumQualifierAndParams() throws Exception {
                    runTest("idea/testData/quickfix/createFromUsage/createClass/referenceExpression/enumEntryWithEnumQualifierAndParams.kt");
                }

                @TestMetadata("enumEntryWithEnumSuperclass.kt")
                public void testEnumEntryWithEnumSuperclass() throws Exception {
                    runTest("idea/testData/quickfix/createFromUsage/createClass/referenceExpression/enumEntryWithEnumSuperclass.kt");
                }

                @TestMetadata("enumEntryWithQualifier.kt")
                public void testEnumEntryWithQualifier() throws Exception {
                    runTest("idea/testData/quickfix/createFromUsage/createClass/referenceExpression/enumEntryWithQualifier.kt");
                }

                @TestMetadata("enumEntryWithReceiver.kt")
                public void testEnumEntryWithReceiver() throws Exception {
                    runTest("idea/testData/quickfix/createFromUsage/createClass/referenceExpression/enumEntryWithReceiver.kt");
                }

                @TestMetadata("enumEntryWithSuperclass.kt")
                public void testEnumEntryWithSuperclass() throws Exception {
                    runTest("idea/testData/quickfix/createFromUsage/createClass/referenceExpression/enumEntryWithSuperclass.kt");
                }

                @TestMetadata("enumNoReceiver.kt")
                public void testEnumNoReceiver() throws Exception {
                    runTest("idea/testData/quickfix/createFromUsage/createClass/referenceExpression/enumNoReceiver.kt");
                }

                @TestMetadata("interfaceByClassLiteral.kt")
                public void testInterfaceByClassLiteral() throws Exception {
                    runTest("idea/testData/quickfix/createFromUsage/createClass/referenceExpression/interfaceByClassLiteral.kt");
                }

                @TestMetadata("objectByClassLiteral.kt")
                public void testObjectByClassLiteral() throws Exception {
                    runTest("idea/testData/quickfix/createFromUsage/createClass/referenceExpression/objectByClassLiteral.kt");
                }

                @TestMetadata("objectByQualifier.kt")
                public void testObjectByQualifier() throws Exception {
                    runTest("idea/testData/quickfix/createFromUsage/createClass/referenceExpression/objectByQualifier.kt");
                }

                @TestMetadata("objectInPackage.kt")
                public void testObjectInPackage() throws Exception {
                    runTest("idea/testData/quickfix/createFromUsage/createClass/referenceExpression/objectInPackage.kt");
                }

                @TestMetadata("objectNoReceiver.kt")
                public void testObjectNoReceiver() throws Exception {
                    runTest("idea/testData/quickfix/createFromUsage/createClass/referenceExpression/objectNoReceiver.kt");
                }

                @TestMetadata("objectWithQualifier.kt")
                public void testObjectWithQualifier() throws Exception {
                    runTest("idea/testData/quickfix/createFromUsage/createClass/referenceExpression/objectWithQualifier.kt");
                }

                @TestMetadata("objectWithReceiver.kt")
                public void testObjectWithReceiver() throws Exception {
                    runTest("idea/testData/quickfix/createFromUsage/createClass/referenceExpression/objectWithReceiver.kt");
                }

                @TestMetadata("objectWithSuperclass.kt")
                public void testObjectWithSuperclass() throws Exception {
                    runTest("idea/testData/quickfix/createFromUsage/createClass/referenceExpression/objectWithSuperclass.kt");
                }

                @TestMetadata("objectWithSupertrait.kt")
                public void testObjectWithSupertrait() throws Exception {
                    runTest("idea/testData/quickfix/createFromUsage/createClass/referenceExpression/objectWithSupertrait.kt");
                }

                @TestMetadata("recursiveBound.kt")
                public void testRecursiveBound() throws Exception {
                    runTest("idea/testData/quickfix/createFromUsage/createClass/referenceExpression/recursiveBound.kt");
                }

                @TestMetadata("traitByQualifier.kt")
                public void testTraitByQualifier() throws Exception {
                    runTest("idea/testData/quickfix/createFromUsage/createClass/referenceExpression/traitByQualifier.kt");
                }

                @TestMetadata("traitNoReceiver.kt")
                public void testTraitNoReceiver() throws Exception {
                    runTest("idea/testData/quickfix/createFromUsage/createClass/referenceExpression/traitNoReceiver.kt");
                }

                @TestMetadata("unusedReference.kt")
                public void testUnusedReference() throws Exception {
                    runTest("idea/testData/quickfix/createFromUsage/createClass/referenceExpression/unusedReference.kt");
                }

                @TestMetadata("valDelegateExpressionRuntime.kt")
                public void testValDelegateExpressionRuntime() throws Exception {
                    runTest("idea/testData/quickfix/createFromUsage/createClass/referenceExpression/valDelegateExpressionRuntime.kt");
                }

                @TestMetadata("varDelegateExpressionRuntime.kt")
                public void testVarDelegateExpressionRuntime() throws Exception {
                    runTest("idea/testData/quickfix/createFromUsage/createClass/referenceExpression/varDelegateExpressionRuntime.kt");
                }
            }

            @TestMetadata("idea/testData/quickfix/createFromUsage/createClass/typeReference")
            @TestDataPath("$PROJECT_ROOT")
            @RunWith(JUnit3RunnerWithInners.class)
            public static class TypeReference extends AbstractQuickFixTest {
                private void runTest(String testDataFilePath) throws Exception {
                    KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
                }

                public void testAllFilesPresentInTypeReference() throws Exception {
                    KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/quickfix/createFromUsage/createClass/typeReference"), Pattern.compile("^([\\w\\-_]+)\\.kt$"), TargetBackend.ANY, true);
                }

                @TestMetadata("annotationNotQualifierNoTypeArgs.kt")
                public void testAnnotationNotQualifierNoTypeArgs() throws Exception {
                    runTest("idea/testData/quickfix/createFromUsage/createClass/typeReference/annotationNotQualifierNoTypeArgs.kt");
                }

                @TestMetadata("annotationNotQualifierWithTypeArgs.kt")
                public void testAnnotationNotQualifierWithTypeArgs() throws Exception {
                    runTest("idea/testData/quickfix/createFromUsage/createClass/typeReference/annotationNotQualifierWithTypeArgs.kt");
                }

                @TestMetadata("annotationQualifierNoTypeArgs.kt")
                public void testAnnotationQualifierNoTypeArgs() throws Exception {
                    runTest("idea/testData/quickfix/createFromUsage/createClass/typeReference/annotationQualifierNoTypeArgs.kt");
                }

                @TestMetadata("classCurrentPackageReceiver.kt")
                public void testClassCurrentPackageReceiver() throws Exception {
                    runTest("idea/testData/quickfix/createFromUsage/createClass/typeReference/classCurrentPackageReceiver.kt");
                }

                @TestMetadata("classLibTypeReceiver.kt")
                public void testClassLibTypeReceiver() throws Exception {
                    runTest("idea/testData/quickfix/createFromUsage/createClass/typeReference/classLibTypeReceiver.kt");
                }

                @TestMetadata("classNotQualifierNoTypeArgs.kt")
                public void testClassNotQualifierNoTypeArgs() throws Exception {
                    runTest("idea/testData/quickfix/createFromUsage/createClass/typeReference/classNotQualifierNoTypeArgs.kt");
                }

                @TestMetadata("classNotQualifierWithStarProjection.kt")
                public void testClassNotQualifierWithStarProjection() throws Exception {
                    runTest("idea/testData/quickfix/createFromUsage/createClass/typeReference/classNotQualifierWithStarProjection.kt");
                }

                @TestMetadata("classNotQualifierWithTypeArgs.kt")
                public void testClassNotQualifierWithTypeArgs() throws Exception {
                    runTest("idea/testData/quickfix/createFromUsage/createClass/typeReference/classNotQualifierWithTypeArgs.kt");
                }

                @TestMetadata("classQualifierNoTypeArgs.kt")
                public void testClassQualifierNoTypeArgs() throws Exception {
                    runTest("idea/testData/quickfix/createFromUsage/createClass/typeReference/classQualifierNoTypeArgs.kt");
                }

                @TestMetadata("classUserTypeReceiver.kt")
                public void testClassUserTypeReceiver() throws Exception {
                    runTest("idea/testData/quickfix/createFromUsage/createClass/typeReference/classUserTypeReceiver.kt");
                }

                @TestMetadata("classUserTypeReceiverNoBody.kt")
                public void testClassUserTypeReceiverNoBody() throws Exception {
                    runTest("idea/testData/quickfix/createFromUsage/createClass/typeReference/classUserTypeReceiverNoBody.kt");
                }

                @TestMetadata("createNestedClass.kt")
                public void testCreateNestedClass() throws Exception {
                    runTest("idea/testData/quickfix/createFromUsage/createClass/typeReference/createNestedClass.kt");
                }

                @TestMetadata("createNestedClassInInner.kt")
                public void testCreateNestedClassInInner() throws Exception {
                    runTest("idea/testData/quickfix/createFromUsage/createClass/typeReference/createNestedClassInInner.kt");
                }

                @TestMetadata("enumEntryNotQualifierNoTypeArgs.kt")
                public void testEnumEntryNotQualifierNoTypeArgs() throws Exception {
                    runTest("idea/testData/quickfix/createFromUsage/createClass/typeReference/enumEntryNotQualifierNoTypeArgs.kt");
                }

                @TestMetadata("enumNotQualifierNoTypeArgs.kt")
                public void testEnumNotQualifierNoTypeArgs() throws Exception {
                    runTest("idea/testData/quickfix/createFromUsage/createClass/typeReference/enumNotQualifierNoTypeArgs.kt");
                }

                @TestMetadata("enumNotQualifierWithTypeArgs.kt")
                public void testEnumNotQualifierWithTypeArgs() throws Exception {
                    runTest("idea/testData/quickfix/createFromUsage/createClass/typeReference/enumNotQualifierWithTypeArgs.kt");
                }

                @TestMetadata("nestedClassByTypeArgumentRefNoBody.kt")
                public void testNestedClassByTypeArgumentRefNoBody() throws Exception {
                    runTest("idea/testData/quickfix/createFromUsage/createClass/typeReference/nestedClassByTypeArgumentRefNoBody.kt");
                }

                @TestMetadata("nestedClassByTypeArgumentRefWithBody.kt")
                public void testNestedClassByTypeArgumentRefWithBody() throws Exception {
                    runTest("idea/testData/quickfix/createFromUsage/createClass/typeReference/nestedClassByTypeArgumentRefWithBody.kt");
                }

                @TestMetadata("noAnnotationForTypeBound.kt")
                public void testNoAnnotationForTypeBound() throws Exception {
                    runTest("idea/testData/quickfix/createFromUsage/createClass/typeReference/noAnnotationForTypeBound.kt");
                }

                @TestMetadata("noAnnotationForTypeConstraint.kt")
                public void testNoAnnotationForTypeConstraint() throws Exception {
                    runTest("idea/testData/quickfix/createFromUsage/createClass/typeReference/noAnnotationForTypeConstraint.kt");
                }

                @TestMetadata("noEnumForTypeBound.kt")
                public void testNoEnumForTypeBound() throws Exception {
                    runTest("idea/testData/quickfix/createFromUsage/createClass/typeReference/noEnumForTypeBound.kt");
                }

                @TestMetadata("noEnumForTypeConstraint.kt")
                public void testNoEnumForTypeConstraint() throws Exception {
                    runTest("idea/testData/quickfix/createFromUsage/createClass/typeReference/noEnumForTypeConstraint.kt");
                }

                @TestMetadata("noObjectForTypeBound.kt")
                public void testNoObjectForTypeBound() throws Exception {
                    runTest("idea/testData/quickfix/createFromUsage/createClass/typeReference/noObjectForTypeBound.kt");
                }

                @TestMetadata("noObjectForTypeConstraint.kt")
                public void testNoObjectForTypeConstraint() throws Exception {
                    runTest("idea/testData/quickfix/createFromUsage/createClass/typeReference/noObjectForTypeConstraint.kt");
                }

                @TestMetadata("objectNotQualifierNoTypeArgs.kt")
                public void testObjectNotQualifierNoTypeArgs() throws Exception {
                    runTest("idea/testData/quickfix/createFromUsage/createClass/typeReference/objectNotQualifierNoTypeArgs.kt");
                }

                @TestMetadata("objectNotQualifierWithTypeArgs.kt")
                public void testObjectNotQualifierWithTypeArgs() throws Exception {
                    runTest("idea/testData/quickfix/createFromUsage/createClass/typeReference/objectNotQualifierWithTypeArgs.kt");
                }

                @TestMetadata("objectQualifierNoTypeArgs.kt")
                public void testObjectQualifierNoTypeArgs() throws Exception {
                    runTest("idea/testData/quickfix/createFromUsage/createClass/typeReference/objectQualifierNoTypeArgs.kt");
                }

                @TestMetadata("traitNotQualifierNoTypeArgs.kt")
                public void testTraitNotQualifierNoTypeArgs() throws Exception {
                    runTest("idea/testData/quickfix/createFromUsage/createClass/typeReference/traitNotQualifierNoTypeArgs.kt");
                }

                @TestMetadata("typeArgumentWithBound.kt")
                public void testTypeArgumentWithBound() throws Exception {
                    runTest("idea/testData/quickfix/createFromUsage/createClass/typeReference/typeArgumentWithBound.kt");
                }

                @TestMetadata("typeArgumentWithMultipleBounds.kt")
                public void testTypeArgumentWithMultipleBounds() throws Exception {
                    runTest("idea/testData/quickfix/createFromUsage/createClass/typeReference/typeArgumentWithMultipleBounds.kt");
                }
            }
        }

        @TestMetadata("idea/testData/quickfix/createFromUsage/createFunction")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class CreateFunction extends AbstractQuickFixTest {
            private void runTest(String testDataFilePath) throws Exception {
                KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
            }

            public void testAllFilesPresentInCreateFunction() throws Exception {
                KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/quickfix/createFromUsage/createFunction"), Pattern.compile("^([\\w\\-_]+)\\.kt$"), TargetBackend.ANY, true);
            }

            @TestMetadata("idea/testData/quickfix/createFromUsage/createFunction/binaryOperations")
            @TestDataPath("$PROJECT_ROOT")
            @RunWith(JUnit3RunnerWithInners.class)
            public static class BinaryOperations extends AbstractQuickFixTest {
                private void runTest(String testDataFilePath) throws Exception {
                    KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
                }

                public void testAllFilesPresentInBinaryOperations() throws Exception {
                    KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/quickfix/createFromUsage/createFunction/binaryOperations"), Pattern.compile("^([\\w\\-_]+)\\.kt$"), TargetBackend.ANY, true);
                }

                @TestMetadata("customOperationOnUserType.kt")
                public void testCustomOperationOnUserType() throws Exception {
                    runTest("idea/testData/quickfix/createFromUsage/createFunction/binaryOperations/customOperationOnUserType.kt");
                }

                @TestMetadata("greaterOrEqualOnUserType.kt")
                public void testGreaterOrEqualOnUserType() throws Exception {
                    runTest("idea/testData/quickfix/createFromUsage/createFunction/binaryOperations/greaterOrEqualOnUserType.kt");
                }

                @TestMetadata("inOnUserType.kt")
                public void testInOnUserType() throws Exception {
                    runTest("idea/testData/quickfix/createFromUsage/createFunction/binaryOperations/inOnUserType.kt");
                }

                @TestMetadata("lessOnUserType.kt")
                public void testLessOnUserType() throws Exception {
                    runTest("idea/testData/quickfix/createFromUsage/createFunction/binaryOperations/lessOnUserType.kt");
                }

                @TestMetadata("notInOnUserType.kt")
                public void testNotInOnUserType() throws Exception {
                    runTest("idea/testData/quickfix/createFromUsage/createFunction/binaryOperations/notInOnUserType.kt");
                }

                @TestMetadata("plusAssignOnUserType.kt")
                public void testPlusAssignOnUserType() throws Exception {
                    runTest("idea/testData/quickfix/createFromUsage/createFunction/binaryOperations/plusAssignOnUserType.kt");
                }

                @TestMetadata("plusExtraArgs.kt")
                public void testPlusExtraArgs() throws Exception {
                    runTest("idea/testData/quickfix/createFromUsage/createFunction/binaryOperations/plusExtraArgs.kt");
                }

                @TestMetadata("plusForAssignmentOnUserType.kt")
                public void testPlusForAssignmentOnUserType() throws Exception {
                    runTest("idea/testData/quickfix/createFromUsage/createFunction/binaryOperations/plusForAssignmentOnUserType.kt");
                }

                @TestMetadata("plusMissingArgs.kt")
                public void testPlusMissingArgs() throws Exception {
                    runTest("idea/testData/quickfix/createFromUsage/createFunction/binaryOperations/plusMissingArgs.kt");
                }

                @TestMetadata("plusOnLibType.kt")
                public void testPlusOnLibType() throws Exception {
                    runTest("idea/testData/quickfix/createFromUsage/createFunction/binaryOperations/plusOnLibType.kt");
                }

                @TestMetadata("plusOnUserType.kt")
                public void testPlusOnUserType() throws Exception {
                    runTest("idea/testData/quickfix/createFromUsage/createFunction/binaryOperations/plusOnUserType.kt");
                }

                @TestMetadata("plusOnUserTypeWithTypeParams.kt")
                public void testPlusOnUserTypeWithTypeParams() throws Exception {
                    runTest("idea/testData/quickfix/createFromUsage/createFunction/binaryOperations/plusOnUserTypeWithTypeParams.kt");
                }

                @TestMetadata("quotedName.kt")
                public void testQuotedName() throws Exception {
                    runTest("idea/testData/quickfix/createFromUsage/createFunction/binaryOperations/quotedName.kt");
                }

                @TestMetadata("typeMismatch.kt")
                public void testTypeMismatch() throws Exception {
                    runTest("idea/testData/quickfix/createFromUsage/createFunction/binaryOperations/typeMismatch.kt");
                }

                @TestMetadata("whenInOnUserType.kt")
                public void testWhenInOnUserType() throws Exception {
                    runTest("idea/testData/quickfix/createFromUsage/createFunction/binaryOperations/whenInOnUserType.kt");
                }

                @TestMetadata("whenNotInOnUserType.kt")
                public void testWhenNotInOnUserType() throws Exception {
                    runTest("idea/testData/quickfix/createFromUsage/createFunction/binaryOperations/whenNotInOnUserType.kt");
                }
            }

            @TestMetadata("idea/testData/quickfix/createFromUsage/createFunction/call")
            @TestDataPath("$PROJECT_ROOT")
            @RunWith(JUnit3RunnerWithInners.class)
            public static class Call extends AbstractQuickFixTest {
                private void runTest(String testDataFilePath) throws Exception {
                    KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
                }

                public void testAllFilesPresentInCall() throws Exception {
                    KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/quickfix/createFromUsage/createFunction/call"), Pattern.compile("^([\\w\\-_]+)\\.kt$"), TargetBackend.ANY, true);
                }

                @TestMetadata("approximateAnonymousObjectRuntime.kt")
                public void testApproximateAnonymousObjectRuntime() throws Exception {
                    runTest("idea/testData/quickfix/createFromUsage/createFunction/call/approximateAnonymousObjectRuntime.kt");
                }

                @TestMetadata("approximateLocalClassRuntime.kt")
                public void testApproximateLocalClassRuntime() throws Exception {
                    runTest("idea/testData/quickfix/createFromUsage/createFunction/call/approximateLocalClassRuntime.kt");
                }

                @TestMetadata("argumentTypeMismatch.kt")
                public void testArgumentTypeMismatch() throws Exception {
                    runTest("idea/testData/quickfix/createFromUsage/createFunction/call/argumentTypeMismatch.kt");
                }

                @TestMetadata("callInAnnotationEntry.kt")
                public void testCallInAnnotationEntry() throws Exception {
                    runTest("idea/testData/quickfix/createFromUsage/createFunction/call/callInAnnotationEntry.kt");
                }

                @TestMetadata("callInStringTemplateRuntime.kt")
                public void testCallInStringTemplateRuntime() throws Exception {
                    runTest("idea/testData/quickfix/createFromUsage/createFunction/call/callInStringTemplateRuntime.kt");
                }

                @TestMetadata("callWithClassLiteral.kt")
                public void testCallWithClassLiteral() throws Exception {
                    runTest("idea/testData/quickfix/createFromUsage/createFunction/call/callWithClassLiteral.kt");
                }

                @TestMetadata("callWithLambdaArg.kt")
                public void testCallWithLambdaArg() throws Exception {
                    runTest("idea/testData/quickfix/createFromUsage/createFunction/call/callWithLambdaArg.kt");
                }

                @TestMetadata("callWithLambdaArgOnly.kt")
                public void testCallWithLambdaArgOnly() throws Exception {
                    runTest("idea/testData/quickfix/createFromUsage/createFunction/call/callWithLambdaArgOnly.kt");
                }

                @TestMetadata("doNotStripPrefix.kt")
                public void testDoNotStripPrefix() throws Exception {
                    runTest("idea/testData/quickfix/createFromUsage/createFunction/call/doNotStripPrefix.kt");
                }

                @TestMetadata("extensionFunOnTrait.kt")
                public void testExtensionFunOnTrait() throws Exception {
                    runTest("idea/testData/quickfix/createFromUsage/createFunction/call/extensionFunOnTrait.kt");
                }

                @TestMetadata("extensionRefInImport.kt")
                public void testExtensionRefInImport() throws Exception {
                    runTest("idea/testData/quickfix/createFromUsage/createFunction/call/extensionRefInImport.kt");
                }

                @TestMetadata("funExtraArgs.kt")
                public void testFunExtraArgs() throws Exception {
                    runTest("idea/testData/quickfix/createFromUsage/createFunction/call/funExtraArgs.kt");
                }

                @TestMetadata("funInInlineInternalFun.kt")
                public void testFunInInlineInternalFun() throws Exception {
                    runTest("idea/testData/quickfix/createFromUsage/createFunction/call/funInInlineInternalFun.kt");
                }

                @TestMetadata("funInInlinePrivateFun.kt")
                public void testFunInInlinePrivateFun() throws Exception {
                    runTest("idea/testData/quickfix/createFromUsage/createFunction/call/funInInlinePrivateFun.kt");
                }

                @TestMetadata("funInInlineProtectedFun.kt")
                public void testFunInInlineProtectedFun() throws Exception {
                    runTest("idea/testData/quickfix/createFromUsage/createFunction/call/funInInlineProtectedFun.kt");
                }

                @TestMetadata("funInInlinePublicFun.kt")
                public void testFunInInlinePublicFun() throws Exception {
                    runTest("idea/testData/quickfix/createFromUsage/createFunction/call/funInInlinePublicFun.kt");
                }

                @TestMetadata("funMissingArgs.kt")
                public void testFunMissingArgs() throws Exception {
                    runTest("idea/testData/quickfix/createFromUsage/createFunction/call/funMissingArgs.kt");
                }

                @TestMetadata("funOnClassNoClassObject.kt")
                public void testFunOnClassNoClassObject() throws Exception {
                    runTest("idea/testData/quickfix/createFromUsage/createFunction/call/funOnClassNoClassObject.kt");
                }

                @TestMetadata("funOnClassObject.kt")
                public void testFunOnClassObject() throws Exception {
                    runTest("idea/testData/quickfix/createFromUsage/createFunction/call/funOnClassObject.kt");
                }

                @TestMetadata("funOnLibObject.kt")
                public void testFunOnLibObject() throws Exception {
                    runTest("idea/testData/quickfix/createFromUsage/createFunction/call/funOnLibObject.kt");
                }

                @TestMetadata("funOnLibType.kt")
                public void testFunOnLibType() throws Exception {
                    runTest("idea/testData/quickfix/createFromUsage/createFunction/call/funOnLibType.kt");
                }

                @TestMetadata("funOnTrait.kt")
                public void testFunOnTrait() throws Exception {
                    runTest("idea/testData/quickfix/createFromUsage/createFunction/call/funOnTrait.kt");
                }

                @TestMetadata("funOnUserObject.kt")
                public void testFunOnUserObject() throws Exception {
                    runTest("idea/testData/quickfix/createFromUsage/createFunction/call/funOnUserObject.kt");
                }

                @TestMetadata("funOnUserType.kt")
                public void testFunOnUserType() throws Exception {
                    runTest("idea/testData/quickfix/createFromUsage/createFunction/call/funOnUserType.kt");
                }

                @TestMetadata("funOnUserTypeWithDeclarations.kt")
                public void testFunOnUserTypeWithDeclarations() throws Exception {
                    runTest("idea/testData/quickfix/createFromUsage/createFunction/call/funOnUserTypeWithDeclarations.kt");
                }

                @TestMetadata("funOnUserTypeWithTypeParams.kt")
                public void testFunOnUserTypeWithTypeParams() throws Exception {
                    runTest("idea/testData/quickfix/createFromUsage/createFunction/call/funOnUserTypeWithTypeParams.kt");
                }

                @TestMetadata("funPlacement.kt")
                public void testFunPlacement() throws Exception {
                    runTest("idea/testData/quickfix/createFromUsage/createFunction/call/funPlacement.kt");
                }

                @TestMetadata("funWithExplicitParamNamesOnUserType.kt")
                public void testFunWithExplicitParamNamesOnUserType() throws Exception {
                    runTest("idea/testData/quickfix/createFromUsage/createFunction/call/funWithExplicitParamNamesOnUserType.kt");
                }

                @TestMetadata("funWithNullableParamType.kt")
                public void testFunWithNullableParamType() throws Exception {
                    runTest("idea/testData/quickfix/createFromUsage/createFunction/call/funWithNullableParamType.kt");
                }

                @TestMetadata("funWithNullableType.kt")
                public void testFunWithNullableType() throws Exception {
                    runTest("idea/testData/quickfix/createFromUsage/createFunction/call/funWithNullableType.kt");
                }

                @TestMetadata("funWithNullableTypeParameter.kt")
                public void testFunWithNullableTypeParameter() throws Exception {
                    runTest("idea/testData/quickfix/createFromUsage/createFunction/call/funWithNullableTypeParameter.kt");
                }

                @TestMetadata("funWithPackageName.kt")
                public void testFunWithPackageName() throws Exception {
                    runTest("idea/testData/quickfix/createFromUsage/createFunction/call/funWithPackageName.kt");
                }

                @TestMetadata("functionalType.kt")
                public void testFunctionalType() throws Exception {
                    runTest("idea/testData/quickfix/createFromUsage/createFunction/call/functionalType.kt");
                }

                @TestMetadata("functionalTypeInReceiver.kt")
                public void testFunctionalTypeInReceiver() throws Exception {
                    runTest("idea/testData/quickfix/createFromUsage/createFunction/call/functionalTypeInReceiver.kt");
                }

                @TestMetadata("inAnonymousFunBlockWithExpectedType.kt")
                public void testInAnonymousFunBlockWithExpectedType() throws Exception {
                    runTest("idea/testData/quickfix/createFromUsage/createFunction/call/inAnonymousFunBlockWithExpectedType.kt");
                }

                @TestMetadata("inAnonymousFunExprWithExpectedType.kt")
                public void testInAnonymousFunExprWithExpectedType() throws Exception {
                    runTest("idea/testData/quickfix/createFromUsage/createFunction/call/inAnonymousFunExprWithExpectedType.kt");
                }

                @TestMetadata("inLambda.kt")
                public void testInLambda() throws Exception {
                    runTest("idea/testData/quickfix/createFromUsage/createFunction/call/inLambda.kt");
                }

                @TestMetadata("inLambdaWithExpectedType.kt")
                public void testInLambdaWithExpectedType() throws Exception {
                    runTest("idea/testData/quickfix/createFromUsage/createFunction/call/inLambdaWithExpectedType.kt");
                }

                @TestMetadata("inconsistentTypes.kt")
                public void testInconsistentTypes() throws Exception {
                    runTest("idea/testData/quickfix/createFromUsage/createFunction/call/inconsistentTypes.kt");
                }

                @TestMetadata("insideIfCondition.kt")
                public void testInsideIfCondition() throws Exception {
                    runTest("idea/testData/quickfix/createFromUsage/createFunction/call/insideIfCondition.kt");
                }

                @TestMetadata("kt10983.kt")
                public void testKt10983() throws Exception {
                    runTest("idea/testData/quickfix/createFromUsage/createFunction/call/kt10983.kt");
                }

                @TestMetadata("localFunNoReceiver.kt")
                public void testLocalFunNoReceiver() throws Exception {
                    runTest("idea/testData/quickfix/createFromUsage/createFunction/call/localFunNoReceiver.kt");
                }

                @TestMetadata("memberFunNoReceiver.kt")
                public void testMemberFunNoReceiver() throws Exception {
                    runTest("idea/testData/quickfix/createFromUsage/createFunction/call/memberFunNoReceiver.kt");
                }

                @TestMetadata("memberValDelegateRuntime.kt")
                public void testMemberValDelegateRuntime() throws Exception {
                    runTest("idea/testData/quickfix/createFromUsage/createFunction/call/memberValDelegateRuntime.kt");
                }

                @TestMetadata("memberVarDelegateRuntime.kt")
                public void testMemberVarDelegateRuntime() throws Exception {
                    runTest("idea/testData/quickfix/createFromUsage/createFunction/call/memberVarDelegateRuntime.kt");
                }

                @TestMetadata("notExactArgument.kt")
                public void testNotExactArgument() throws Exception {
                    runTest("idea/testData/quickfix/createFromUsage/createFunction/call/notExactArgument.kt");
                }

                @TestMetadata("nullableReceiver.kt")
                public void testNullableReceiver() throws Exception {
                    runTest("idea/testData/quickfix/createFromUsage/createFunction/call/nullableReceiver.kt");
                }

                @TestMetadata("objectMemberFunNoReceiver.kt")
                public void testObjectMemberFunNoReceiver() throws Exception {
                    runTest("idea/testData/quickfix/createFromUsage/createFunction/call/objectMemberFunNoReceiver.kt");
                }

                @TestMetadata("privateForMembers.kt")
                public void testPrivateForMembers() throws Exception {
                    runTest("idea/testData/quickfix/createFromUsage/createFunction/call/privateForMembers.kt");
                }

                @TestMetadata("propertyOnUserType.kt")
                public void testPropertyOnUserType() throws Exception {
                    runTest("idea/testData/quickfix/createFromUsage/createFunction/call/propertyOnUserType.kt");
                }

                @TestMetadata("qualifiedCallInStringTemplateRuntime.kt")
                public void testQualifiedCallInStringTemplateRuntime() throws Exception {
                    runTest("idea/testData/quickfix/createFromUsage/createFunction/call/qualifiedCallInStringTemplateRuntime.kt");
                }

                @TestMetadata("receiverWithSmartCast.kt")
                public void testReceiverWithSmartCast() throws Exception {
                    runTest("idea/testData/quickfix/createFromUsage/createFunction/call/receiverWithSmartCast.kt");
                }

                @TestMetadata("refInImport.kt")
                public void testRefInImport() throws Exception {
                    runTest("idea/testData/quickfix/createFromUsage/createFunction/call/refInImport.kt");
                }

                @TestMetadata("smartCastWithIs.kt")
                public void testSmartCastWithIs() throws Exception {
                    runTest("idea/testData/quickfix/createFromUsage/createFunction/call/smartCastWithIs.kt");
                }

                @TestMetadata("smartCastWithNullCheck.kt")
                public void testSmartCastWithNullCheck() throws Exception {
                    runTest("idea/testData/quickfix/createFromUsage/createFunction/call/smartCastWithNullCheck.kt");
                }

                @TestMetadata("stripPrefix.kt")
                public void testStripPrefix() throws Exception {
                    runTest("idea/testData/quickfix/createFromUsage/createFunction/call/stripPrefix.kt");
                }

                @TestMetadata("thisInClass.kt")
                public void testThisInClass() throws Exception {
                    runTest("idea/testData/quickfix/createFromUsage/createFunction/call/thisInClass.kt");
                }

                @TestMetadata("thisInExtension.kt")
                public void testThisInExtension() throws Exception {
                    runTest("idea/testData/quickfix/createFromUsage/createFunction/call/thisInExtension.kt");
                }

                @TestMetadata("thisInNestedClass1.kt")
                public void testThisInNestedClass1() throws Exception {
                    runTest("idea/testData/quickfix/createFromUsage/createFunction/call/thisInNestedClass1.kt");
                }

                @TestMetadata("thisInNestedClass2.kt")
                public void testThisInNestedClass2() throws Exception {
                    runTest("idea/testData/quickfix/createFromUsage/createFunction/call/thisInNestedClass2.kt");
                }

                @TestMetadata("topLevelFunNoReceiver.kt")
                public void testTopLevelFunNoReceiver() throws Exception {
                    runTest("idea/testData/quickfix/createFromUsage/createFunction/call/topLevelFunNoReceiver.kt");
                }

                @TestMetadata("topLevelFunPlacement.kt")
                public void testTopLevelFunPlacement() throws Exception {
                    runTest("idea/testData/quickfix/createFromUsage/createFunction/call/topLevelFunPlacement.kt");
                }

                @TestMetadata("unitFun.kt")
                public void testUnitFun() throws Exception {
                    runTest("idea/testData/quickfix/createFromUsage/createFunction/call/unitFun.kt");
                }

                @TestMetadata("unknownType.kt")
                public void testUnknownType() throws Exception {
                    runTest("idea/testData/quickfix/createFromUsage/createFunction/call/unknownType.kt");
                }

                @TestMetadata("unresolvedSupertype.kt")
                public void testUnresolvedSupertype() throws Exception {
                    runTest("idea/testData/quickfix/createFromUsage/createFunction/call/unresolvedSupertype.kt");
                }

                @TestMetadata("idea/testData/quickfix/createFromUsage/createFunction/call/abstract")
                @TestDataPath("$PROJECT_ROOT")
                @RunWith(JUnit3RunnerWithInners.class)
                public static class Abstract extends AbstractQuickFixTest {
                    private void runTest(String testDataFilePath) throws Exception {
                        KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
                    }

                    public void testAllFilesPresentInAbstract() throws Exception {
                        KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/quickfix/createFromUsage/createFunction/call/abstract"), Pattern.compile("^([\\w\\-_]+)\\.kt$"), TargetBackend.ANY, true);
                    }

                    @TestMetadata("classNoExplicitReceiver.kt")
                    public void testClassNoExplicitReceiver() throws Exception {
                        runTest("idea/testData/quickfix/createFromUsage/createFunction/call/abstract/classNoExplicitReceiver.kt");
                    }

                    @TestMetadata("explicitReceiverOfContainingClass.kt")
                    public void testExplicitReceiverOfContainingClass() throws Exception {
                        runTest("idea/testData/quickfix/createFromUsage/createFunction/call/abstract/explicitReceiverOfContainingClass.kt");
                    }

                    @TestMetadata("inAbstractSuperclass.kt")
                    public void testInAbstractSuperclass() throws Exception {
                        runTest("idea/testData/quickfix/createFromUsage/createFunction/call/abstract/inAbstractSuperclass.kt");
                    }

                    @TestMetadata("inBaseInterface.kt")
                    public void testInBaseInterface() throws Exception {
                        runTest("idea/testData/quickfix/createFromUsage/createFunction/call/abstract/inBaseInterface.kt");
                    }

                    @TestMetadata("interfaceNoExplicitReceiver.kt")
                    public void testInterfaceNoExplicitReceiver() throws Exception {
                        runTest("idea/testData/quickfix/createFromUsage/createFunction/call/abstract/interfaceNoExplicitReceiver.kt");
                    }

                    @TestMetadata("noAbstractSuperclass.kt")
                    public void testNoAbstractSuperclass() throws Exception {
                        runTest("idea/testData/quickfix/createFromUsage/createFunction/call/abstract/noAbstractSuperclass.kt");
                    }

                    @TestMetadata("notAbstractClass.kt")
                    public void testNotAbstractClass() throws Exception {
                        runTest("idea/testData/quickfix/createFromUsage/createFunction/call/abstract/notAbstractClass.kt");
                    }

                    @TestMetadata("otherExplicitReceiver.kt")
                    public void testOtherExplicitReceiver() throws Exception {
                        runTest("idea/testData/quickfix/createFromUsage/createFunction/call/abstract/otherExplicitReceiver.kt");
                    }
                }

                @TestMetadata("idea/testData/quickfix/createFromUsage/createFunction/call/extensionByExtensionReceiver")
                @TestDataPath("$PROJECT_ROOT")
                @RunWith(JUnit3RunnerWithInners.class)
                public static class ExtensionByExtensionReceiver extends AbstractQuickFixTest {
                    private void runTest(String testDataFilePath) throws Exception {
                        KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
                    }

                    public void testAllFilesPresentInExtensionByExtensionReceiver() throws Exception {
                        KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/quickfix/createFromUsage/createFunction/call/extensionByExtensionReceiver"), Pattern.compile("^([\\w\\-_]+)\\.kt$"), TargetBackend.ANY, true);
                    }

                    @TestMetadata("extensionFunction.kt")
                    public void testExtensionFunction() throws Exception {
                        runTest("idea/testData/quickfix/createFromUsage/createFunction/call/extensionByExtensionReceiver/extensionFunction.kt");
                    }

                    @TestMetadata("extensionLambda.kt")
                    public void testExtensionLambda() throws Exception {
                        runTest("idea/testData/quickfix/createFromUsage/createFunction/call/extensionByExtensionReceiver/extensionLambda.kt");
                    }

                    @TestMetadata("extensionPropertyGetter.kt")
                    public void testExtensionPropertyGetter() throws Exception {
                        runTest("idea/testData/quickfix/createFromUsage/createFunction/call/extensionByExtensionReceiver/extensionPropertyGetter.kt");
                    }

                    @TestMetadata("extensionPropertySetter.kt")
                    public void testExtensionPropertySetter() throws Exception {
                        runTest("idea/testData/quickfix/createFromUsage/createFunction/call/extensionByExtensionReceiver/extensionPropertySetter.kt");
                    }

                    @TestMetadata("notExtensionCallable.kt")
                    public void testNotExtensionCallable() throws Exception {
                        runTest("idea/testData/quickfix/createFromUsage/createFunction/call/extensionByExtensionReceiver/notExtensionCallable.kt");
                    }
                }

                @TestMetadata("idea/testData/quickfix/createFromUsage/createFunction/call/typeArguments")
                @TestDataPath("$PROJECT_ROOT")
                @RunWith(JUnit3RunnerWithInners.class)
                public static class TypeArguments extends AbstractQuickFixTest {
                    private void runTest(String testDataFilePath) throws Exception {
                        KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
                    }

                    public void testAllFilesPresentInTypeArguments() throws Exception {
                        KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/quickfix/createFromUsage/createFunction/call/typeArguments"), Pattern.compile("^([\\w\\-_]+)\\.kt$"), TargetBackend.ANY, true);
                    }

                    @TestMetadata("callWithStarProjection.kt")
                    public void testCallWithStarProjection() throws Exception {
                        runTest("idea/testData/quickfix/createFromUsage/createFunction/call/typeArguments/callWithStarProjection.kt");
                    }

                    @TestMetadata("classMember.kt")
                    public void testClassMember() throws Exception {
                        runTest("idea/testData/quickfix/createFromUsage/createFunction/call/typeArguments/classMember.kt");
                    }

                    @TestMetadata("classMemberInFunctionLiteralWithReceiver.kt")
                    public void testClassMemberInFunctionLiteralWithReceiver() throws Exception {
                        runTest("idea/testData/quickfix/createFromUsage/createFunction/call/typeArguments/classMemberInFunctionLiteralWithReceiver.kt");
                    }

                    @TestMetadata("classMemberPartialSubstitution.kt")
                    public void testClassMemberPartialSubstitution() throws Exception {
                        runTest("idea/testData/quickfix/createFromUsage/createFunction/call/typeArguments/classMemberPartialSubstitution.kt");
                    }

                    @TestMetadata("classMemberWithReceiverArg.kt")
                    public void testClassMemberWithReceiverArg() throws Exception {
                        runTest("idea/testData/quickfix/createFromUsage/createFunction/call/typeArguments/classMemberWithReceiverArg.kt");
                    }

                    @TestMetadata("extension.kt")
                    public void testExtension() throws Exception {
                        runTest("idea/testData/quickfix/createFromUsage/createFunction/call/typeArguments/extension.kt");
                    }

                    @TestMetadata("extensionPartialSubstitution.kt")
                    public void testExtensionPartialSubstitution() throws Exception {
                        runTest("idea/testData/quickfix/createFromUsage/createFunction/call/typeArguments/extensionPartialSubstitution.kt");
                    }

                    @TestMetadata("extensionWithReceiverArg.kt")
                    public void testExtensionWithReceiverArg() throws Exception {
                        runTest("idea/testData/quickfix/createFromUsage/createFunction/call/typeArguments/extensionWithReceiverArg.kt");
                    }

                    @TestMetadata("extensionWithTypeParameterAsReceiver.kt")
                    public void testExtensionWithTypeParameterAsReceiver() throws Exception {
                        runTest("idea/testData/quickfix/createFromUsage/createFunction/call/typeArguments/extensionWithTypeParameterAsReceiver.kt");
                    }

                    @TestMetadata("memberWithTypeParameterAsReceiver.kt")
                    public void testMemberWithTypeParameterAsReceiver() throws Exception {
                        runTest("idea/testData/quickfix/createFromUsage/createFunction/call/typeArguments/memberWithTypeParameterAsReceiver.kt");
                    }

                    @TestMetadata("noReceiver.kt")
                    public void testNoReceiver() throws Exception {
                        runTest("idea/testData/quickfix/createFromUsage/createFunction/call/typeArguments/noReceiver.kt");
                    }

                    @TestMetadata("noReceiverExtraArgs.kt")
                    public void testNoReceiverExtraArgs() throws Exception {
                        runTest("idea/testData/quickfix/createFromUsage/createFunction/call/typeArguments/noReceiverExtraArgs.kt");
                    }

                    @TestMetadata("noReceiverLongName.kt")
                    public void testNoReceiverLongName() throws Exception {
                        runTest("idea/testData/quickfix/createFromUsage/createFunction/call/typeArguments/noReceiverLongName.kt");
                    }

                    @TestMetadata("noReceiverPartialSubstitution.kt")
                    public void testNoReceiverPartialSubstitution() throws Exception {
                        runTest("idea/testData/quickfix/createFromUsage/createFunction/call/typeArguments/noReceiverPartialSubstitution.kt");
                    }
                }
            }

            @TestMetadata("idea/testData/quickfix/createFromUsage/createFunction/callableReferences")
            @TestDataPath("$PROJECT_ROOT")
            @RunWith(JUnit3RunnerWithInners.class)
            public static class CallableReferences extends AbstractQuickFixTest {
                private void runTest(String testDataFilePath) throws Exception {
                    KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
                }

                public void testAllFilesPresentInCallableReferences() throws Exception {
                    KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/quickfix/createFromUsage/createFunction/callableReferences"), Pattern.compile("^([\\w\\-_]+)\\.kt$"), TargetBackend.ANY, true);
                }

                @TestMetadata("extensionNoReceiverInCallableRef.kt")
                public void testExtensionNoReceiverInCallableRef() throws Exception {
                    runTest("idea/testData/quickfix/createFromUsage/createFunction/callableReferences/extensionNoReceiverInCallableRef.kt");
                }

                @TestMetadata("extensionWithReceiverInCallableRef.kt")
                public void testExtensionWithReceiverInCallableRef() throws Exception {
                    runTest("idea/testData/quickfix/createFromUsage/createFunction/callableReferences/extensionWithReceiverInCallableRef.kt");
                }

                @TestMetadata("noExpectedReturnType.kt")
                public void testNoExpectedReturnType() throws Exception {
                    runTest("idea/testData/quickfix/createFromUsage/createFunction/callableReferences/noExpectedReturnType.kt");
                }

                @TestMetadata("noFunctionalType.kt")
                public void testNoFunctionalType() throws Exception {
                    runTest("idea/testData/quickfix/createFromUsage/createFunction/callableReferences/noFunctionalType.kt");
                }

                @TestMetadata("nonExtensionWithReceiverInCallableRef.kt")
                public void testNonExtensionWithReceiverInCallableRef() throws Exception {
                    runTest("idea/testData/quickfix/createFromUsage/createFunction/callableReferences/nonExtensionWithReceiverInCallableRef.kt");
                }

                @TestMetadata("withExpectedReturnType.kt")
                public void testWithExpectedReturnType() throws Exception {
                    runTest("idea/testData/quickfix/createFromUsage/createFunction/callableReferences/withExpectedReturnType.kt");
                }
            }

            @TestMetadata("idea/testData/quickfix/createFromUsage/createFunction/component")
            @TestDataPath("$PROJECT_ROOT")
            @RunWith(JUnit3RunnerWithInners.class)
            public static class Component extends AbstractQuickFixTest {
                private void runTest(String testDataFilePath) throws Exception {
                    KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
                }

                public void testAllFilesPresentInComponent() throws Exception {
                    KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/quickfix/createFromUsage/createFunction/component"), Pattern.compile("^([\\w\\-_]+)\\.kt$"), TargetBackend.ANY, true);
                }

                @TestMetadata("createComponentFromUsage1.kt")
                public void testCreateComponentFromUsage1() throws Exception {
                    runTest("idea/testData/quickfix/createFromUsage/createFunction/component/createComponentFromUsage1.kt");
                }

                @TestMetadata("createComponentFromUsage2.kt")
                public void testCreateComponentFromUsage2() throws Exception {
                    runTest("idea/testData/quickfix/createFromUsage/createFunction/component/createComponentFromUsage2.kt");
                }

                @TestMetadata("createComponentFromUsage3.kt")
                public void testCreateComponentFromUsage3() throws Exception {
                    runTest("idea/testData/quickfix/createFromUsage/createFunction/component/createComponentFromUsage3.kt");
                }
            }

            @TestMetadata("idea/testData/quickfix/createFromUsage/createFunction/delegateAccessors")
            @TestDataPath("$PROJECT_ROOT")
            @RunWith(JUnit3RunnerWithInners.class)
            public static class DelegateAccessors extends AbstractQuickFixTest {
                private void runTest(String testDataFilePath) throws Exception {
                    KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
                }

                public void testAllFilesPresentInDelegateAccessors() throws Exception {
                    KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/quickfix/createFromUsage/createFunction/delegateAccessors"), Pattern.compile("^([\\w\\-_]+)\\.kt$"), TargetBackend.ANY, true);
                }

                @TestMetadata("localVal.kt")
                public void testLocalVal() throws Exception {
                    runTest("idea/testData/quickfix/createFromUsage/createFunction/delegateAccessors/localVal.kt");
                }

                @TestMetadata("localVar.kt")
                public void testLocalVar() throws Exception {
                    runTest("idea/testData/quickfix/createFromUsage/createFunction/delegateAccessors/localVar.kt");
                }

                @TestMetadata("val.kt")
                public void testVal() throws Exception {
                    runTest("idea/testData/quickfix/createFromUsage/createFunction/delegateAccessors/val.kt");
                }

                @TestMetadata("var.kt")
                public void testVar() throws Exception {
                    runTest("idea/testData/quickfix/createFromUsage/createFunction/delegateAccessors/var.kt");
                }

                @TestMetadata("varMissingGet.kt")
                public void testVarMissingGet() throws Exception {
                    runTest("idea/testData/quickfix/createFromUsage/createFunction/delegateAccessors/varMissingGet.kt");
                }

                @TestMetadata("varMissingSet.kt")
                public void testVarMissingSet() throws Exception {
                    runTest("idea/testData/quickfix/createFromUsage/createFunction/delegateAccessors/varMissingSet.kt");
                }
            }

            @TestMetadata("idea/testData/quickfix/createFromUsage/createFunction/fromJava")
            @TestDataPath("$PROJECT_ROOT")
            @RunWith(JUnit3RunnerWithInners.class)
            public static class FromJava extends AbstractQuickFixTest {
                private void runTest(String testDataFilePath) throws Exception {
                    KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
                }

                public void testAllFilesPresentInFromJava() throws Exception {
                    KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/quickfix/createFromUsage/createFunction/fromJava"), Pattern.compile("^([\\w\\-_]+)\\.kt$"), TargetBackend.ANY, true);
                }
            }

            @TestMetadata("idea/testData/quickfix/createFromUsage/createFunction/get")
            @TestDataPath("$PROJECT_ROOT")
            @RunWith(JUnit3RunnerWithInners.class)
            public static class Get extends AbstractQuickFixTest {
                private void runTest(String testDataFilePath) throws Exception {
                    KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
                }

                public void testAllFilesPresentInGet() throws Exception {
                    KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/quickfix/createFromUsage/createFunction/get"), Pattern.compile("^([\\w\\-_]+)\\.kt$"), TargetBackend.ANY, true);
                }

                @TestMetadata("createGetFromUsage1.kt")
                public void testCreateGetFromUsage1() throws Exception {
                    runTest("idea/testData/quickfix/createFromUsage/createFunction/get/createGetFromUsage1.kt");
                }

                @TestMetadata("createGetFromUsage10.kt")
                public void testCreateGetFromUsage10() throws Exception {
                    runTest("idea/testData/quickfix/createFromUsage/createFunction/get/createGetFromUsage10.kt");
                }

                @TestMetadata("createGetFromUsage11.kt")
                public void testCreateGetFromUsage11() throws Exception {
                    runTest("idea/testData/quickfix/createFromUsage/createFunction/get/createGetFromUsage11.kt");
                }

                @TestMetadata("createGetFromUsage12.kt")
                public void testCreateGetFromUsage12() throws Exception {
                    runTest("idea/testData/quickfix/createFromUsage/createFunction/get/createGetFromUsage12.kt");
                }

                @TestMetadata("createGetFromUsage13.kt")
                public void testCreateGetFromUsage13() throws Exception {
                    runTest("idea/testData/quickfix/createFromUsage/createFunction/get/createGetFromUsage13.kt");
                }

                @TestMetadata("createGetFromUsage2.kt")
                public void testCreateGetFromUsage2() throws Exception {
                    runTest("idea/testData/quickfix/createFromUsage/createFunction/get/createGetFromUsage2.kt");
                }

                @TestMetadata("createGetFromUsage3.kt")
                public void testCreateGetFromUsage3() throws Exception {
                    runTest("idea/testData/quickfix/createFromUsage/createFunction/get/createGetFromUsage3.kt");
                }

                @TestMetadata("createGetFromUsage4.kt")
                public void testCreateGetFromUsage4() throws Exception {
                    runTest("idea/testData/quickfix/createFromUsage/createFunction/get/createGetFromUsage4.kt");
                }

                @TestMetadata("createGetFromUsage5.kt")
                public void testCreateGetFromUsage5() throws Exception {
                    runTest("idea/testData/quickfix/createFromUsage/createFunction/get/createGetFromUsage5.kt");
                }

                @TestMetadata("createGetFromUsage7.kt")
                public void testCreateGetFromUsage7() throws Exception {
                    runTest("idea/testData/quickfix/createFromUsage/createFunction/get/createGetFromUsage7.kt");
                }

                @TestMetadata("createGetFromUsage8.kt")
                public void testCreateGetFromUsage8() throws Exception {
                    runTest("idea/testData/quickfix/createFromUsage/createFunction/get/createGetFromUsage8.kt");
                }

                @TestMetadata("createGetFromUsage9.kt")
                public void testCreateGetFromUsage9() throws Exception {
                    runTest("idea/testData/quickfix/createFromUsage/createFunction/get/createGetFromUsage9.kt");
                }

                @TestMetadata("typeMismatch.kt")
                public void testTypeMismatch() throws Exception {
                    runTest("idea/testData/quickfix/createFromUsage/createFunction/get/typeMismatch.kt");
                }
            }

            @TestMetadata("idea/testData/quickfix/createFromUsage/createFunction/hasNext")
            @TestDataPath("$PROJECT_ROOT")
            @RunWith(JUnit3RunnerWithInners.class)
            public static class HasNext extends AbstractQuickFixTest {
                private void runTest(String testDataFilePath) throws Exception {
                    KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
                }

                public void testAllFilesPresentInHasNext() throws Exception {
                    KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/quickfix/createFromUsage/createFunction/hasNext"), Pattern.compile("^([\\w\\-_]+)\\.kt$"), TargetBackend.ANY, true);
                }

                @TestMetadata("createHasNextFromUsage1.kt")
                public void testCreateHasNextFromUsage1() throws Exception {
                    runTest("idea/testData/quickfix/createFromUsage/createFunction/hasNext/createHasNextFromUsage1.kt");
                }

                @TestMetadata("createHasNextFromUsage2.kt")
                public void testCreateHasNextFromUsage2() throws Exception {
                    runTest("idea/testData/quickfix/createFromUsage/createFunction/hasNext/createHasNextFromUsage2.kt");
                }
            }

            @TestMetadata("idea/testData/quickfix/createFromUsage/createFunction/invoke")
            @TestDataPath("$PROJECT_ROOT")
            @RunWith(JUnit3RunnerWithInners.class)
            public static class Invoke extends AbstractQuickFixTest {
                private void runTest(String testDataFilePath) throws Exception {
                    KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
                }

                public void testAllFilesPresentInInvoke() throws Exception {
                    KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/quickfix/createFromUsage/createFunction/invoke"), Pattern.compile("^([\\w\\-_]+)\\.kt$"), TargetBackend.ANY, true);
                }

                @TestMetadata("invokeOnLibType.kt")
                public void testInvokeOnLibType() throws Exception {
                    runTest("idea/testData/quickfix/createFromUsage/createFunction/invoke/invokeOnLibType.kt");
                }

                @TestMetadata("invokeOnUserType.kt")
                public void testInvokeOnUserType() throws Exception {
                    runTest("idea/testData/quickfix/createFromUsage/createFunction/invoke/invokeOnUserType.kt");
                }

                @TestMetadata("invokeOnUserTypeWithTypeParams.kt")
                public void testInvokeOnUserTypeWithTypeParams() throws Exception {
                    runTest("idea/testData/quickfix/createFromUsage/createFunction/invoke/invokeOnUserTypeWithTypeParams.kt");
                }

                @TestMetadata("invokeWithExplicitParamNamesOnUserType.kt")
                public void testInvokeWithExplicitParamNamesOnUserType() throws Exception {
                    runTest("idea/testData/quickfix/createFromUsage/createFunction/invoke/invokeWithExplicitParamNamesOnUserType.kt");
                }

                @TestMetadata("lambdaArgument.kt")
                public void testLambdaArgument() throws Exception {
                    runTest("idea/testData/quickfix/createFromUsage/createFunction/invoke/lambdaArgument.kt");
                }
            }

            @TestMetadata("idea/testData/quickfix/createFromUsage/createFunction/iterator")
            @TestDataPath("$PROJECT_ROOT")
            @RunWith(JUnit3RunnerWithInners.class)
            public static class Iterator extends AbstractQuickFixTest {
                private void runTest(String testDataFilePath) throws Exception {
                    KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
                }

                public void testAllFilesPresentInIterator() throws Exception {
                    KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/quickfix/createFromUsage/createFunction/iterator"), Pattern.compile("^([\\w\\-_]+)\\.kt$"), TargetBackend.ANY, true);
                }

                @TestMetadata("createIteratorFromUsage1.kt")
                public void testCreateIteratorFromUsage1() throws Exception {
                    runTest("idea/testData/quickfix/createFromUsage/createFunction/iterator/createIteratorFromUsage1.kt");
                }

                @TestMetadata("createIteratorFromUsage2.kt")
                public void testCreateIteratorFromUsage2() throws Exception {
                    runTest("idea/testData/quickfix/createFromUsage/createFunction/iterator/createIteratorFromUsage2.kt");
                }

                @TestMetadata("createIteratorFromUsage3.kt")
                public void testCreateIteratorFromUsage3() throws Exception {
                    runTest("idea/testData/quickfix/createFromUsage/createFunction/iterator/createIteratorFromUsage3.kt");
                }
            }

            @TestMetadata("idea/testData/quickfix/createFromUsage/createFunction/next")
            @TestDataPath("$PROJECT_ROOT")
            @RunWith(JUnit3RunnerWithInners.class)
            public static class Next extends AbstractQuickFixTest {
                private void runTest(String testDataFilePath) throws Exception {
                    KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
                }

                public void testAllFilesPresentInNext() throws Exception {
                    KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/quickfix/createFromUsage/createFunction/next"), Pattern.compile("^([\\w\\-_]+)\\.kt$"), TargetBackend.ANY, true);
                }

                @TestMetadata("createNextFromUsage1.kt")
                public void testCreateNextFromUsage1() throws Exception {
                    runTest("idea/testData/quickfix/createFromUsage/createFunction/next/createNextFromUsage1.kt");
                }

                @TestMetadata("createNextFromUsage2.kt")
                public void testCreateNextFromUsage2() throws Exception {
                    runTest("idea/testData/quickfix/createFromUsage/createFunction/next/createNextFromUsage2.kt");
                }
            }

            @TestMetadata("idea/testData/quickfix/createFromUsage/createFunction/set")
            @TestDataPath("$PROJECT_ROOT")
            @RunWith(JUnit3RunnerWithInners.class)
            public static class Set extends AbstractQuickFixTest {
                private void runTest(String testDataFilePath) throws Exception {
                    KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
                }

                public void testAllFilesPresentInSet() throws Exception {
                    KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/quickfix/createFromUsage/createFunction/set"), Pattern.compile("^([\\w\\-_]+)\\.kt$"), TargetBackend.ANY, true);
                }

                @TestMetadata("createSetFromUsage1.kt")
                public void testCreateSetFromUsage1() throws Exception {
                    runTest("idea/testData/quickfix/createFromUsage/createFunction/set/createSetFromUsage1.kt");
                }

                @TestMetadata("createSetFromUsage2.kt")
                public void testCreateSetFromUsage2() throws Exception {
                    runTest("idea/testData/quickfix/createFromUsage/createFunction/set/createSetFromUsage2.kt");
                }

                @TestMetadata("setterForIncrement.kt")
                public void testSetterForIncrement() throws Exception {
                    runTest("idea/testData/quickfix/createFromUsage/createFunction/set/setterForIncrement.kt");
                }

                @TestMetadata("typeMismatch.kt")
                public void testTypeMismatch() throws Exception {
                    runTest("idea/testData/quickfix/createFromUsage/createFunction/set/typeMismatch.kt");
                }
            }

            @TestMetadata("idea/testData/quickfix/createFromUsage/createFunction/unaryOperations")
            @TestDataPath("$PROJECT_ROOT")
            @RunWith(JUnit3RunnerWithInners.class)
            public static class UnaryOperations extends AbstractQuickFixTest {
                private void runTest(String testDataFilePath) throws Exception {
                    KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
                }

                public void testAllFilesPresentInUnaryOperations() throws Exception {
                    KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/quickfix/createFromUsage/createFunction/unaryOperations"), Pattern.compile("^([\\w\\-_]+)\\.kt$"), TargetBackend.ANY, true);
                }

                @TestMetadata("incOnUserType.kt")
                public void testIncOnUserType() throws Exception {
                    runTest("idea/testData/quickfix/createFromUsage/createFunction/unaryOperations/incOnUserType.kt");
                }

                @TestMetadata("minusMissingArgs.kt")
                public void testMinusMissingArgs() throws Exception {
                    runTest("idea/testData/quickfix/createFromUsage/createFunction/unaryOperations/minusMissingArgs.kt");
                }

                @TestMetadata("minusOnLibType.kt")
                public void testMinusOnLibType() throws Exception {
                    runTest("idea/testData/quickfix/createFromUsage/createFunction/unaryOperations/minusOnLibType.kt");
                }

                @TestMetadata("minusOnUserType.kt")
                public void testMinusOnUserType() throws Exception {
                    runTest("idea/testData/quickfix/createFromUsage/createFunction/unaryOperations/minusOnUserType.kt");
                }

                @TestMetadata("minusOnUserTypeWithTypeParams.kt")
                public void testMinusOnUserTypeWithTypeParams() throws Exception {
                    runTest("idea/testData/quickfix/createFromUsage/createFunction/unaryOperations/minusOnUserTypeWithTypeParams.kt");
                }
            }
        }

        @TestMetadata("idea/testData/quickfix/createFromUsage/createSecondaryConstructor")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class CreateSecondaryConstructor extends AbstractQuickFixTest {
            private void runTest(String testDataFilePath) throws Exception {
                KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
            }

            public void testAllFilesPresentInCreateSecondaryConstructor() throws Exception {
                KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/quickfix/createFromUsage/createSecondaryConstructor"), Pattern.compile("^([\\w\\-_]+)\\.kt$"), TargetBackend.ANY, true);
            }

            @TestMetadata("argumentTypeMismatch.kt")
            public void testArgumentTypeMismatch() throws Exception {
                runTest("idea/testData/quickfix/createFromUsage/createSecondaryConstructor/argumentTypeMismatch.kt");
            }

            @TestMetadata("callWithExpectedType.kt")
            public void testCallWithExpectedType() throws Exception {
                runTest("idea/testData/quickfix/createFromUsage/createSecondaryConstructor/callWithExpectedType.kt");
            }

            @TestMetadata("callWithTypeArguments.kt")
            public void testCallWithTypeArguments() throws Exception {
                runTest("idea/testData/quickfix/createFromUsage/createSecondaryConstructor/callWithTypeArguments.kt");
            }

            @TestMetadata("classWithBody.kt")
            public void testClassWithBody() throws Exception {
                runTest("idea/testData/quickfix/createFromUsage/createSecondaryConstructor/classWithBody.kt");
            }

            @TestMetadata("classWithoutBody.kt")
            public void testClassWithoutBody() throws Exception {
                runTest("idea/testData/quickfix/createFromUsage/createSecondaryConstructor/classWithoutBody.kt");
            }

            @TestMetadata("delegatorToSuperCall.kt")
            public void testDelegatorToSuperCall() throws Exception {
                runTest("idea/testData/quickfix/createFromUsage/createSecondaryConstructor/delegatorToSuperCall.kt");
            }

            @TestMetadata("delegatorToSuperCallNoClass.kt")
            public void testDelegatorToSuperCallNoClass() throws Exception {
                runTest("idea/testData/quickfix/createFromUsage/createSecondaryConstructor/delegatorToSuperCallNoClass.kt");
            }

            @TestMetadata("noParametersImplicitSuperCall.kt")
            public void testNoParametersImplicitSuperCall() throws Exception {
                runTest("idea/testData/quickfix/createFromUsage/createSecondaryConstructor/noParametersImplicitSuperCall.kt");
            }

            @TestMetadata("noParametersSuperCall.kt")
            public void testNoParametersSuperCall() throws Exception {
                runTest("idea/testData/quickfix/createFromUsage/createSecondaryConstructor/noParametersSuperCall.kt");
            }

            @TestMetadata("noParametersThisCall.kt")
            public void testNoParametersThisCall() throws Exception {
                runTest("idea/testData/quickfix/createFromUsage/createSecondaryConstructor/noParametersThisCall.kt");
            }

            @TestMetadata("noneApplicable.kt")
            public void testNoneApplicable() throws Exception {
                runTest("idea/testData/quickfix/createFromUsage/createSecondaryConstructor/noneApplicable.kt");
            }

            @TestMetadata("superCall.kt")
            public void testSuperCall() throws Exception {
                runTest("idea/testData/quickfix/createFromUsage/createSecondaryConstructor/superCall.kt");
            }

            @TestMetadata("superCallNoClass.kt")
            public void testSuperCallNoClass() throws Exception {
                runTest("idea/testData/quickfix/createFromUsage/createSecondaryConstructor/superCallNoClass.kt");
            }

            @TestMetadata("superCallNoneApplicable.kt")
            public void testSuperCallNoneApplicable() throws Exception {
                runTest("idea/testData/quickfix/createFromUsage/createSecondaryConstructor/superCallNoneApplicable.kt");
            }

            @TestMetadata("thisCall.kt")
            public void testThisCall() throws Exception {
                runTest("idea/testData/quickfix/createFromUsage/createSecondaryConstructor/thisCall.kt");
            }

            @TestMetadata("wrongExpectedType.kt")
            public void testWrongExpectedType() throws Exception {
                runTest("idea/testData/quickfix/createFromUsage/createSecondaryConstructor/wrongExpectedType.kt");
            }
        }

        @TestMetadata("idea/testData/quickfix/createFromUsage/createTypeAlias")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class CreateTypeAlias extends AbstractQuickFixTest {
            private void runTest(String testDataFilePath) throws Exception {
                KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
            }

            public void testAllFilesPresentInCreateTypeAlias() throws Exception {
                KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/quickfix/createFromUsage/createTypeAlias"), Pattern.compile("^([\\w\\-_]+)\\.kt$"), TargetBackend.ANY, true);
            }

            @TestMetadata("idea/testData/quickfix/createFromUsage/createTypeAlias/typeReference")
            @TestDataPath("$PROJECT_ROOT")
            @RunWith(JUnit3RunnerWithInners.class)
            public static class TypeReference extends AbstractQuickFixTest {
                private void runTest(String testDataFilePath) throws Exception {
                    KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
                }

                public void testAllFilesPresentInTypeReference() throws Exception {
                    KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/quickfix/createFromUsage/createTypeAlias/typeReference"), Pattern.compile("^([\\w\\-_]+)\\.kt$"), TargetBackend.ANY, true);
                }

                @TestMetadata("currentPackageReceiver.kt")
                public void testCurrentPackageReceiver() throws Exception {
                    runTest("idea/testData/quickfix/createFromUsage/createTypeAlias/typeReference/currentPackageReceiver.kt");
                }

                @TestMetadata("libTypeReceiver.kt")
                public void testLibTypeReceiver() throws Exception {
                    runTest("idea/testData/quickfix/createFromUsage/createTypeAlias/typeReference/libTypeReceiver.kt");
                }

                @TestMetadata("notQualifierNoTypeArgs.kt")
                public void testNotQualifierNoTypeArgs() throws Exception {
                    runTest("idea/testData/quickfix/createFromUsage/createTypeAlias/typeReference/notQualifierNoTypeArgs.kt");
                }

                @TestMetadata("notQualifierWithStarProjection.kt")
                public void testNotQualifierWithStarProjection() throws Exception {
                    runTest("idea/testData/quickfix/createFromUsage/createTypeAlias/typeReference/notQualifierWithStarProjection.kt");
                }

                @TestMetadata("notQualifierWithTypeArgs.kt")
                public void testNotQualifierWithTypeArgs() throws Exception {
                    runTest("idea/testData/quickfix/createFromUsage/createTypeAlias/typeReference/notQualifierWithTypeArgs.kt");
                }

                @TestMetadata("qualifierNoTypeArgs.kt")
                public void testQualifierNoTypeArgs() throws Exception {
                    runTest("idea/testData/quickfix/createFromUsage/createTypeAlias/typeReference/qualifierNoTypeArgs.kt");
                }

                @TestMetadata("recursiveTypeBound1.kt")
                public void testRecursiveTypeBound1() throws Exception {
                    runTest("idea/testData/quickfix/createFromUsage/createTypeAlias/typeReference/recursiveTypeBound1.kt");
                }

                @TestMetadata("recursiveTypeBound2.kt")
                public void testRecursiveTypeBound2() throws Exception {
                    runTest("idea/testData/quickfix/createFromUsage/createTypeAlias/typeReference/recursiveTypeBound2.kt");
                }

                @TestMetadata("typeParameterDependency.kt")
                public void testTypeParameterDependency() throws Exception {
                    runTest("idea/testData/quickfix/createFromUsage/createTypeAlias/typeReference/typeParameterDependency.kt");
                }

                @TestMetadata("userTypeReceiver.kt")
                public void testUserTypeReceiver() throws Exception {
                    runTest("idea/testData/quickfix/createFromUsage/createTypeAlias/typeReference/userTypeReceiver.kt");
                }

                @TestMetadata("userTypeReceiverNoBody.kt")
                public void testUserTypeReceiverNoBody() throws Exception {
                    runTest("idea/testData/quickfix/createFromUsage/createTypeAlias/typeReference/userTypeReceiverNoBody.kt");
                }
            }
        }

        @TestMetadata("idea/testData/quickfix/createFromUsage/createTypeParameter")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class CreateTypeParameter extends AbstractQuickFixTest {
            private void runTest(String testDataFilePath) throws Exception {
                KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
            }

            public void testAllFilesPresentInCreateTypeParameter() throws Exception {
                KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/quickfix/createFromUsage/createTypeParameter"), Pattern.compile("^([\\w\\-_]+)\\.kt$"), TargetBackend.ANY, true);
            }

            @TestMetadata("idea/testData/quickfix/createFromUsage/createTypeParameter/inContainingDeclaration")
            @TestDataPath("$PROJECT_ROOT")
            @RunWith(JUnit3RunnerWithInners.class)
            public static class InContainingDeclaration extends AbstractQuickFixTest {
                private void runTest(String testDataFilePath) throws Exception {
                    KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
                }

                public void testAllFilesPresentInInContainingDeclaration() throws Exception {
                    KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/quickfix/createFromUsage/createTypeParameter/inContainingDeclaration"), Pattern.compile("^([\\w\\-_]+)\\.kt$"), TargetBackend.ANY, true);
                }

                @TestMetadata("classNoExplication.kt")
                public void testClassNoExplication() throws Exception {
                    runTest("idea/testData/quickfix/createFromUsage/createTypeParameter/inContainingDeclaration/classNoExplication.kt");
                }

                @TestMetadata("classWithExplication.kt")
                public void testClassWithExplication() throws Exception {
                    runTest("idea/testData/quickfix/createFromUsage/createTypeParameter/inContainingDeclaration/classWithExplication.kt");
                }

                @TestMetadata("classWithExplicationAndRecursiveUpperBound.kt")
                public void testClassWithExplicationAndRecursiveUpperBound() throws Exception {
                    runTest("idea/testData/quickfix/createFromUsage/createTypeParameter/inContainingDeclaration/classWithExplicationAndRecursiveUpperBound.kt");
                }

                @TestMetadata("classWithExplicationAndUpperBound.kt")
                public void testClassWithExplicationAndUpperBound() throws Exception {
                    runTest("idea/testData/quickfix/createFromUsage/createTypeParameter/inContainingDeclaration/classWithExplicationAndUpperBound.kt");
                }

                @TestMetadata("functionNoExplication.kt")
                public void testFunctionNoExplication() throws Exception {
                    runTest("idea/testData/quickfix/createFromUsage/createTypeParameter/inContainingDeclaration/functionNoExplication.kt");
                }

                @TestMetadata("functionWithExplication.kt")
                public void testFunctionWithExplication() throws Exception {
                    runTest("idea/testData/quickfix/createFromUsage/createTypeParameter/inContainingDeclaration/functionWithExplication.kt");
                }

                @TestMetadata("functionWithExplicationAndRecursiveUpperBound.kt")
                public void testFunctionWithExplicationAndRecursiveUpperBound() throws Exception {
                    runTest("idea/testData/quickfix/createFromUsage/createTypeParameter/inContainingDeclaration/functionWithExplicationAndRecursiveUpperBound.kt");
                }

                @TestMetadata("functionWithExplicationAndUpperBound.kt")
                public void testFunctionWithExplicationAndUpperBound() throws Exception {
                    runTest("idea/testData/quickfix/createFromUsage/createTypeParameter/inContainingDeclaration/functionWithExplicationAndUpperBound.kt");
                }

                @TestMetadata("inAnnotation.kt")
                public void testInAnnotation() throws Exception {
                    runTest("idea/testData/quickfix/createFromUsage/createTypeParameter/inContainingDeclaration/inAnnotation.kt");
                }

                @TestMetadata("inSuperTypeEntry.kt")
                public void testInSuperTypeEntry() throws Exception {
                    runTest("idea/testData/quickfix/createFromUsage/createTypeParameter/inContainingDeclaration/inSuperTypeEntry.kt");
                }

                @TestMetadata("qualifiedType.kt")
                public void testQualifiedType() throws Exception {
                    runTest("idea/testData/quickfix/createFromUsage/createTypeParameter/inContainingDeclaration/qualifiedType.kt");
                }

                @TestMetadata("typeQualifier.kt")
                public void testTypeQualifier() throws Exception {
                    runTest("idea/testData/quickfix/createFromUsage/createTypeParameter/inContainingDeclaration/typeQualifier.kt");
                }

                @TestMetadata("withTypeArguments.kt")
                public void testWithTypeArguments() throws Exception {
                    runTest("idea/testData/quickfix/createFromUsage/createTypeParameter/inContainingDeclaration/withTypeArguments.kt");
                }
            }

            @TestMetadata("idea/testData/quickfix/createFromUsage/createTypeParameter/inReferencedDeclaration")
            @TestDataPath("$PROJECT_ROOT")
            @RunWith(JUnit3RunnerWithInners.class)
            public static class InReferencedDeclaration extends AbstractQuickFixTest {
                private void runTest(String testDataFilePath) throws Exception {
                    KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
                }

                @TestMetadata("addMultiple.kt")
                public void testAddMultiple() throws Exception {
                    runTest("idea/testData/quickfix/createFromUsage/createTypeParameter/inReferencedDeclaration/addMultiple.kt");
                }

                @TestMetadata("addSingle.kt")
                public void testAddSingle() throws Exception {
                    runTest("idea/testData/quickfix/createFromUsage/createTypeParameter/inReferencedDeclaration/addSingle.kt");
                }

                @TestMetadata("addToFunction.kt")
                public void testAddToFunction() throws Exception {
                    runTest("idea/testData/quickfix/createFromUsage/createTypeParameter/inReferencedDeclaration/addToFunction.kt");
                }

                public void testAllFilesPresentInInReferencedDeclaration() throws Exception {
                    KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/quickfix/createFromUsage/createTypeParameter/inReferencedDeclaration"), Pattern.compile("^([\\w\\-_]+)\\.kt$"), TargetBackend.ANY, true);
                }

                @TestMetadata("missingArguments.kt")
                public void testMissingArguments() throws Exception {
                    runTest("idea/testData/quickfix/createFromUsage/createTypeParameter/inReferencedDeclaration/missingArguments.kt");
                }

                @TestMetadata("notOnTypeArgumentList.kt")
                public void testNotOnTypeArgumentList() throws Exception {
                    runTest("idea/testData/quickfix/createFromUsage/createTypeParameter/inReferencedDeclaration/notOnTypeArgumentList.kt");
                }
            }
        }

        @TestMetadata("idea/testData/quickfix/createFromUsage/createVariable")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class CreateVariable extends AbstractQuickFixTest {
            private void runTest(String testDataFilePath) throws Exception {
                KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
            }

            public void testAllFilesPresentInCreateVariable() throws Exception {
                KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/quickfix/createFromUsage/createVariable"), Pattern.compile("^([\\w\\-_]+)\\.kt$"), TargetBackend.ANY, true);
            }

            @TestMetadata("idea/testData/quickfix/createFromUsage/createVariable/localVariable")
            @TestDataPath("$PROJECT_ROOT")
            @RunWith(JUnit3RunnerWithInners.class)
            public static class LocalVariable extends AbstractQuickFixTest {
                private void runTest(String testDataFilePath) throws Exception {
                    KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
                }

                public void testAllFilesPresentInLocalVariable() throws Exception {
                    KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/quickfix/createFromUsage/createVariable/localVariable"), Pattern.compile("^([\\w\\-_]+)\\.kt$"), TargetBackend.ANY, true);
                }

                @TestMetadata("assignedInFun.kt")
                public void testAssignedInFun() throws Exception {
                    runTest("idea/testData/quickfix/createFromUsage/createVariable/localVariable/assignedInFun.kt");
                }

                @TestMetadata("callableRef.kt")
                public void testCallableRef() throws Exception {
                    runTest("idea/testData/quickfix/createFromUsage/createVariable/localVariable/callableRef.kt");
                }

                @TestMetadata("inAccessor.kt")
                public void testInAccessor() throws Exception {
                    runTest("idea/testData/quickfix/createFromUsage/createVariable/localVariable/inAccessor.kt");
                }

                @TestMetadata("inAccessorWithExpressionBody.kt")
                public void testInAccessorWithExpressionBody() throws Exception {
                    runTest("idea/testData/quickfix/createFromUsage/createVariable/localVariable/inAccessorWithExpressionBody.kt");
                }

                @TestMetadata("inAnnotation.kt")
                public void testInAnnotation() throws Exception {
                    runTest("idea/testData/quickfix/createFromUsage/createVariable/localVariable/inAnnotation.kt");
                }

                @TestMetadata("inBinaryOperation.kt")
                public void testInBinaryOperation() throws Exception {
                    runTest("idea/testData/quickfix/createFromUsage/createVariable/localVariable/inBinaryOperation.kt");
                }

                @TestMetadata("inClass.kt")
                public void testInClass() throws Exception {
                    runTest("idea/testData/quickfix/createFromUsage/createVariable/localVariable/inClass.kt");
                }

                @TestMetadata("inFun.kt")
                public void testInFun() throws Exception {
                    runTest("idea/testData/quickfix/createFromUsage/createVariable/localVariable/inFun.kt");
                }

                @TestMetadata("inFunWithExpressionBody.kt")
                public void testInFunWithExpressionBody() throws Exception {
                    runTest("idea/testData/quickfix/createFromUsage/createVariable/localVariable/inFunWithExpressionBody.kt");
                }

                @TestMetadata("inLabelRef.kt")
                public void testInLabelRef() throws Exception {
                    runTest("idea/testData/quickfix/createFromUsage/createVariable/localVariable/inLabelRef.kt");
                }

                @TestMetadata("inLambdaNoParams.kt")
                public void testInLambdaNoParams() throws Exception {
                    runTest("idea/testData/quickfix/createFromUsage/createVariable/localVariable/inLambdaNoParams.kt");
                }

                @TestMetadata("inLambdaWithParams.kt")
                public void testInLambdaWithParams() throws Exception {
                    runTest("idea/testData/quickfix/createFromUsage/createVariable/localVariable/inLambdaWithParams.kt");
                }

                @TestMetadata("inMultiLineLambdaNoParams.kt")
                public void testInMultiLineLambdaNoParams() throws Exception {
                    runTest("idea/testData/quickfix/createFromUsage/createVariable/localVariable/inMultiLineLambdaNoParams.kt");
                }

                @TestMetadata("inMultiLineLambdaWithParams.kt")
                public void testInMultiLineLambdaWithParams() throws Exception {
                    runTest("idea/testData/quickfix/createFromUsage/createVariable/localVariable/inMultiLineLambdaWithParams.kt");
                }

                @TestMetadata("inWhen.kt")
                public void testInWhen() throws Exception {
                    runTest("idea/testData/quickfix/createFromUsage/createVariable/localVariable/inWhen.kt");
                }

                @TestMetadata("localWithPackageName.kt")
                public void testLocalWithPackageName() throws Exception {
                    runTest("idea/testData/quickfix/createFromUsage/createVariable/localVariable/localWithPackageName.kt");
                }

                @TestMetadata("nonIdentifier.kt")
                public void testNonIdentifier() throws Exception {
                    runTest("idea/testData/quickfix/createFromUsage/createVariable/localVariable/nonIdentifier.kt");
                }

                @TestMetadata("nullableType.kt")
                public void testNullableType() throws Exception {
                    runTest("idea/testData/quickfix/createFromUsage/createVariable/localVariable/nullableType.kt");
                }

                @TestMetadata("onTopLevel.kt")
                public void testOnTopLevel() throws Exception {
                    runTest("idea/testData/quickfix/createFromUsage/createVariable/localVariable/onTopLevel.kt");
                }

                @TestMetadata("positionNextToUsage.kt")
                public void testPositionNextToUsage() throws Exception {
                    runTest("idea/testData/quickfix/createFromUsage/createVariable/localVariable/positionNextToUsage.kt");
                }

                @TestMetadata("qualifiedInFun.kt")
                public void testQualifiedInFun() throws Exception {
                    runTest("idea/testData/quickfix/createFromUsage/createVariable/localVariable/qualifiedInFun.kt");
                }

                @TestMetadata("unitTypedInFun.kt")
                public void testUnitTypedInFun() throws Exception {
                    runTest("idea/testData/quickfix/createFromUsage/createVariable/localVariable/unitTypedInFun.kt");
                }
            }

            @TestMetadata("idea/testData/quickfix/createFromUsage/createVariable/parameter")
            @TestDataPath("$PROJECT_ROOT")
            @RunWith(JUnit3RunnerWithInners.class)
            public static class Parameter extends AbstractQuickFixTest {
                private void runTest(String testDataFilePath) throws Exception {
                    KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
                }

                public void testAllFilesPresentInParameter() throws Exception {
                    KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/quickfix/createFromUsage/createVariable/parameter"), Pattern.compile("^([\\w\\-_]+)\\.kt$"), TargetBackend.ANY, true);
                }

                @TestMetadata("assignedInFun.kt")
                public void testAssignedInFun() throws Exception {
                    runTest("idea/testData/quickfix/createFromUsage/createVariable/parameter/assignedInFun.kt");
                }

                @TestMetadata("assignedInFunInClass.kt")
                public void testAssignedInFunInClass() throws Exception {
                    runTest("idea/testData/quickfix/createFromUsage/createVariable/parameter/assignedInFunInClass.kt");
                }

                @TestMetadata("callableRef.kt")
                public void testCallableRef() throws Exception {
                    runTest("idea/testData/quickfix/createFromUsage/createVariable/parameter/callableRef.kt");
                }

                @TestMetadata("dataClassPropertyByDestructuringEntry.kt")
                public void testDataClassPropertyByDestructuringEntry() throws Exception {
                    runTest("idea/testData/quickfix/createFromUsage/createVariable/parameter/dataClassPropertyByDestructuringEntry.kt");
                }

                @TestMetadata("dataClassPropertyByDestructuringEntryWithSkippedIndex.kt")
                public void testDataClassPropertyByDestructuringEntryWithSkippedIndex() throws Exception {
                    runTest("idea/testData/quickfix/createFromUsage/createVariable/parameter/dataClassPropertyByDestructuringEntryWithSkippedIndex.kt");
                }

                @TestMetadata("dataClassPropertyByDestructuringEntryWithType.kt")
                public void testDataClassPropertyByDestructuringEntryWithType() throws Exception {
                    runTest("idea/testData/quickfix/createFromUsage/createVariable/parameter/dataClassPropertyByDestructuringEntryWithType.kt");
                }

                @TestMetadata("dataClassPropertyByNamedArgument.kt")
                public void testDataClassPropertyByNamedArgument() throws Exception {
                    runTest("idea/testData/quickfix/createFromUsage/createVariable/parameter/dataClassPropertyByNamedArgument.kt");
                }

                @TestMetadata("inAccessorInClass.kt")
                public void testInAccessorInClass() throws Exception {
                    runTest("idea/testData/quickfix/createFromUsage/createVariable/parameter/inAccessorInClass.kt");
                }

                @TestMetadata("inAccessorInClassObject.kt")
                public void testInAccessorInClassObject() throws Exception {
                    runTest("idea/testData/quickfix/createFromUsage/createVariable/parameter/inAccessorInClassObject.kt");
                }

                @TestMetadata("inAccessorInGenClass.kt")
                public void testInAccessorInGenClass() throws Exception {
                    runTest("idea/testData/quickfix/createFromUsage/createVariable/parameter/inAccessorInGenClass.kt");
                }

                @TestMetadata("inAccessorInObject.kt")
                public void testInAccessorInObject() throws Exception {
                    runTest("idea/testData/quickfix/createFromUsage/createVariable/parameter/inAccessorInObject.kt");
                }

                @TestMetadata("inAccessorInTrait.kt")
                public void testInAccessorInTrait() throws Exception {
                    runTest("idea/testData/quickfix/createFromUsage/createVariable/parameter/inAccessorInTrait.kt");
                }

                @TestMetadata("inAccessorNoClass.kt")
                public void testInAccessorNoClass() throws Exception {
                    runTest("idea/testData/quickfix/createFromUsage/createVariable/parameter/inAccessorNoClass.kt");
                }

                @TestMetadata("inAccessorWithExpressionBodyInClass.kt")
                public void testInAccessorWithExpressionBodyInClass() throws Exception {
                    runTest("idea/testData/quickfix/createFromUsage/createVariable/parameter/inAccessorWithExpressionBodyInClass.kt");
                }

                @TestMetadata("inAnonymousObject.kt")
                public void testInAnonymousObject() throws Exception {
                    runTest("idea/testData/quickfix/createFromUsage/createVariable/parameter/inAnonymousObject.kt");
                }

                @TestMetadata("inAnonymousObjectInSecondaryConstructor.kt")
                public void testInAnonymousObjectInSecondaryConstructor() throws Exception {
                    runTest("idea/testData/quickfix/createFromUsage/createVariable/parameter/inAnonymousObjectInSecondaryConstructor.kt");
                }

                @TestMetadata("inBinaryOperation.kt")
                public void testInBinaryOperation() throws Exception {
                    runTest("idea/testData/quickfix/createFromUsage/createVariable/parameter/inBinaryOperation.kt");
                }

                @TestMetadata("inClassInitializer.kt")
                public void testInClassInitializer() throws Exception {
                    runTest("idea/testData/quickfix/createFromUsage/createVariable/parameter/inClassInitializer.kt");
                }

                @TestMetadata("inClassObjectInitializer.kt")
                public void testInClassObjectInitializer() throws Exception {
                    runTest("idea/testData/quickfix/createFromUsage/createVariable/parameter/inClassObjectInitializer.kt");
                }

                @TestMetadata("inFun.kt")
                public void testInFun() throws Exception {
                    runTest("idea/testData/quickfix/createFromUsage/createVariable/parameter/inFun.kt");
                }

                @TestMetadata("inFunInClass.kt")
                public void testInFunInClass() throws Exception {
                    runTest("idea/testData/quickfix/createFromUsage/createVariable/parameter/inFunInClass.kt");
                }

                @TestMetadata("inFunInGenClass.kt")
                public void testInFunInGenClass() throws Exception {
                    runTest("idea/testData/quickfix/createFromUsage/createVariable/parameter/inFunInGenClass.kt");
                }

                @TestMetadata("inGenAccessorInClass.kt")
                public void testInGenAccessorInClass() throws Exception {
                    runTest("idea/testData/quickfix/createFromUsage/createVariable/parameter/inGenAccessorInClass.kt");
                }

                @TestMetadata("inGenAccessorInGenClass.kt")
                public void testInGenAccessorInGenClass() throws Exception {
                    runTest("idea/testData/quickfix/createFromUsage/createVariable/parameter/inGenAccessorInGenClass.kt");
                }

                @TestMetadata("inGenFunInClass.kt")
                public void testInGenFunInClass() throws Exception {
                    runTest("idea/testData/quickfix/createFromUsage/createVariable/parameter/inGenFunInClass.kt");
                }

                @TestMetadata("inGenFunInGenClass.kt")
                public void testInGenFunInGenClass() throws Exception {
                    runTest("idea/testData/quickfix/createFromUsage/createVariable/parameter/inGenFunInGenClass.kt");
                }

                @TestMetadata("inLabelRef.kt")
                public void testInLabelRef() throws Exception {
                    runTest("idea/testData/quickfix/createFromUsage/createVariable/parameter/inLabelRef.kt");
                }

                @TestMetadata("inLambdaNoParams.kt")
                public void testInLambdaNoParams() throws Exception {
                    runTest("idea/testData/quickfix/createFromUsage/createVariable/parameter/inLambdaNoParams.kt");
                }

                @TestMetadata("inLambdaWithIt.kt")
                public void testInLambdaWithIt() throws Exception {
                    runTest("idea/testData/quickfix/createFromUsage/createVariable/parameter/inLambdaWithIt.kt");
                }

                @TestMetadata("inLambdaWithParams.kt")
                public void testInLambdaWithParams() throws Exception {
                    runTest("idea/testData/quickfix/createFromUsage/createVariable/parameter/inLambdaWithParams.kt");
                }

                @TestMetadata("inLambdaWithTypedParams.kt")
                public void testInLambdaWithTypedParams() throws Exception {
                    runTest("idea/testData/quickfix/createFromUsage/createVariable/parameter/inLambdaWithTypedParams.kt");
                }

                @TestMetadata("inMultiLineLambdaNoParams.kt")
                public void testInMultiLineLambdaNoParams() throws Exception {
                    runTest("idea/testData/quickfix/createFromUsage/createVariable/parameter/inMultiLineLambdaNoParams.kt");
                }

                @TestMetadata("inPropertyInitializerInClass.kt")
                public void testInPropertyInitializerInClass() throws Exception {
                    runTest("idea/testData/quickfix/createFromUsage/createVariable/parameter/inPropertyInitializerInClass.kt");
                }

                @TestMetadata("inPropertyInitializerInClassObject.kt")
                public void testInPropertyInitializerInClassObject() throws Exception {
                    runTest("idea/testData/quickfix/createFromUsage/createVariable/parameter/inPropertyInitializerInClassObject.kt");
                }

                @TestMetadata("inPropertyInitializerInEnumClass.kt")
                public void testInPropertyInitializerInEnumClass() throws Exception {
                    runTest("idea/testData/quickfix/createFromUsage/createVariable/parameter/inPropertyInitializerInEnumClass.kt");
                }

                @TestMetadata("inPropertyInitializerInEnumEntry.kt")
                public void testInPropertyInitializerInEnumEntry() throws Exception {
                    runTest("idea/testData/quickfix/createFromUsage/createVariable/parameter/inPropertyInitializerInEnumEntry.kt");
                }

                @TestMetadata("inPropertyInitializerInGenClass.kt")
                public void testInPropertyInitializerInGenClass() throws Exception {
                    runTest("idea/testData/quickfix/createFromUsage/createVariable/parameter/inPropertyInitializerInGenClass.kt");
                }

                @TestMetadata("inPropertyInitializerInNestedClass.kt")
                public void testInPropertyInitializerInNestedClass() throws Exception {
                    runTest("idea/testData/quickfix/createFromUsage/createVariable/parameter/inPropertyInitializerInNestedClass.kt");
                }

                @TestMetadata("inPropertyInitializerInObject.kt")
                public void testInPropertyInitializerInObject() throws Exception {
                    runTest("idea/testData/quickfix/createFromUsage/createVariable/parameter/inPropertyInitializerInObject.kt");
                }

                @TestMetadata("inPropertyInitializerNoClass.kt")
                public void testInPropertyInitializerNoClass() throws Exception {
                    runTest("idea/testData/quickfix/createFromUsage/createVariable/parameter/inPropertyInitializerNoClass.kt");
                }

                @TestMetadata("inSecondaryConstructor.kt")
                public void testInSecondaryConstructor() throws Exception {
                    runTest("idea/testData/quickfix/createFromUsage/createVariable/parameter/inSecondaryConstructor.kt");
                }

                @TestMetadata("namedArgInConstructorCall.kt")
                public void testNamedArgInConstructorCall() throws Exception {
                    runTest("idea/testData/quickfix/createFromUsage/createVariable/parameter/namedArgInConstructorCall.kt");
                }

                @TestMetadata("namedArgInFunctionCall.kt")
                public void testNamedArgInFunctionCall() throws Exception {
                    runTest("idea/testData/quickfix/createFromUsage/createVariable/parameter/namedArgInFunctionCall.kt");
                }

                @TestMetadata("nonIdentifier.kt")
                public void testNonIdentifier() throws Exception {
                    runTest("idea/testData/quickfix/createFromUsage/createVariable/parameter/nonIdentifier.kt");
                }

                @TestMetadata("nullableType.kt")
                public void testNullableType() throws Exception {
                    runTest("idea/testData/quickfix/createFromUsage/createVariable/parameter/nullableType.kt");
                }

                @TestMetadata("parameterFromClassDelegationSpecifier.kt")
                public void testParameterFromClassDelegationSpecifier() throws Exception {
                    runTest("idea/testData/quickfix/createFromUsage/createVariable/parameter/parameterFromClassDelegationSpecifier.kt");
                }

                @TestMetadata("parameterFromEnumEntryDelegationSpecifier.kt")
                public void testParameterFromEnumEntryDelegationSpecifier() throws Exception {
                    runTest("idea/testData/quickfix/createFromUsage/createVariable/parameter/parameterFromEnumEntryDelegationSpecifier.kt");
                }

                @TestMetadata("parameterFromObjectDelegationSpecifier.kt")
                public void testParameterFromObjectDelegationSpecifier() throws Exception {
                    runTest("idea/testData/quickfix/createFromUsage/createVariable/parameter/parameterFromObjectDelegationSpecifier.kt");
                }

                @TestMetadata("qualifiedInFun.kt")
                public void testQualifiedInFun() throws Exception {
                    runTest("idea/testData/quickfix/createFromUsage/createVariable/parameter/qualifiedInFun.kt");
                }

                @TestMetadata("quotedName.kt")
                public void testQuotedName() throws Exception {
                    runTest("idea/testData/quickfix/createFromUsage/createVariable/parameter/quotedName.kt");
                }

                @TestMetadata("recursiveBound.kt")
                public void testRecursiveBound() throws Exception {
                    runTest("idea/testData/quickfix/createFromUsage/createVariable/parameter/recursiveBound.kt");
                }

                @TestMetadata("withPackageName.kt")
                public void testWithPackageName() throws Exception {
                    runTest("idea/testData/quickfix/createFromUsage/createVariable/parameter/withPackageName.kt");
                }

                @TestMetadata("wrongReceiver.kt")
                public void testWrongReceiver() throws Exception {
                    runTest("idea/testData/quickfix/createFromUsage/createVariable/parameter/wrongReceiver.kt");
                }
            }

            @TestMetadata("idea/testData/quickfix/createFromUsage/createVariable/primaryParameter")
            @TestDataPath("$PROJECT_ROOT")
            @RunWith(JUnit3RunnerWithInners.class)
            public static class PrimaryParameter extends AbstractQuickFixTest {
                private void runTest(String testDataFilePath) throws Exception {
                    KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
                }

                public void testAllFilesPresentInPrimaryParameter() throws Exception {
                    KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/quickfix/createFromUsage/createVariable/primaryParameter"), Pattern.compile("^([\\w\\-_]+)\\.kt$"), TargetBackend.ANY, true);
                }

                @TestMetadata("localValNoReceiver.kt")
                public void testLocalValNoReceiver() throws Exception {
                    runTest("idea/testData/quickfix/createFromUsage/createVariable/primaryParameter/localValNoReceiver.kt");
                }

                @TestMetadata("memberValNoReceiver.kt")
                public void testMemberValNoReceiver() throws Exception {
                    runTest("idea/testData/quickfix/createFromUsage/createVariable/primaryParameter/memberValNoReceiver.kt");
                }

                @TestMetadata("memberVarNoReceiver.kt")
                public void testMemberVarNoReceiver() throws Exception {
                    runTest("idea/testData/quickfix/createFromUsage/createVariable/primaryParameter/memberVarNoReceiver.kt");
                }

                @TestMetadata("objectMemberValNoReceiver.kt")
                public void testObjectMemberValNoReceiver() throws Exception {
                    runTest("idea/testData/quickfix/createFromUsage/createVariable/primaryParameter/objectMemberValNoReceiver.kt");
                }

                @TestMetadata("thisInClass.kt")
                public void testThisInClass() throws Exception {
                    runTest("idea/testData/quickfix/createFromUsage/createVariable/primaryParameter/thisInClass.kt");
                }

                @TestMetadata("thisInExtension.kt")
                public void testThisInExtension() throws Exception {
                    runTest("idea/testData/quickfix/createFromUsage/createVariable/primaryParameter/thisInExtension.kt");
                }

                @TestMetadata("thisInNestedClass1.kt")
                public void testThisInNestedClass1() throws Exception {
                    runTest("idea/testData/quickfix/createFromUsage/createVariable/primaryParameter/thisInNestedClass1.kt");
                }

                @TestMetadata("thisInNestedClass2.kt")
                public void testThisInNestedClass2() throws Exception {
                    runTest("idea/testData/quickfix/createFromUsage/createVariable/primaryParameter/thisInNestedClass2.kt");
                }

                @TestMetadata("topLevelValNoReceiver.kt")
                public void testTopLevelValNoReceiver() throws Exception {
                    runTest("idea/testData/quickfix/createFromUsage/createVariable/primaryParameter/topLevelValNoReceiver.kt");
                }

                @TestMetadata("valOnCompanionObject.kt")
                public void testValOnCompanionObject() throws Exception {
                    runTest("idea/testData/quickfix/createFromUsage/createVariable/primaryParameter/valOnCompanionObject.kt");
                }

                @TestMetadata("valOnLibType.kt")
                public void testValOnLibType() throws Exception {
                    runTest("idea/testData/quickfix/createFromUsage/createVariable/primaryParameter/valOnLibType.kt");
                }

                @TestMetadata("valOnUserType.kt")
                public void testValOnUserType() throws Exception {
                    runTest("idea/testData/quickfix/createFromUsage/createVariable/primaryParameter/valOnUserType.kt");
                }

                @TestMetadata("varOnUserType.kt")
                public void testVarOnUserType() throws Exception {
                    runTest("idea/testData/quickfix/createFromUsage/createVariable/primaryParameter/varOnUserType.kt");
                }
            }

            @TestMetadata("idea/testData/quickfix/createFromUsage/createVariable/property")
            @TestDataPath("$PROJECT_ROOT")
            @RunWith(JUnit3RunnerWithInners.class)
            public static class Property extends AbstractQuickFixTest {
                private void runTest(String testDataFilePath) throws Exception {
                    KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
                }

                public void testAllFilesPresentInProperty() throws Exception {
                    KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/quickfix/createFromUsage/createVariable/property"), Pattern.compile("^([\\w\\-_]+)\\.kt$"), TargetBackend.ANY, true);
                }

                @TestMetadata("callOnUserType.kt")
                public void testCallOnUserType() throws Exception {
                    runTest("idea/testData/quickfix/createFromUsage/createVariable/property/callOnUserType.kt");
                }

                @TestMetadata("callableRef.kt")
                public void testCallableRef() throws Exception {
                    runTest("idea/testData/quickfix/createFromUsage/createVariable/property/callableRef.kt");
                }

                @TestMetadata("extensionRefInImport.kt")
                public void testExtensionRefInImport() throws Exception {
                    runTest("idea/testData/quickfix/createFromUsage/createVariable/property/extensionRefInImport.kt");
                }

                @TestMetadata("extensionWithTypeParameterAsReceiver.kt")
                public void testExtensionWithTypeParameterAsReceiver() throws Exception {
                    runTest("idea/testData/quickfix/createFromUsage/createVariable/property/extensionWithTypeParameterAsReceiver.kt");
                }

                @TestMetadata("inBinaryOperation.kt")
                public void testInBinaryOperation() throws Exception {
                    runTest("idea/testData/quickfix/createFromUsage/createVariable/property/inBinaryOperation.kt");
                }

                @TestMetadata("inLabelRef.kt")
                public void testInLabelRef() throws Exception {
                    runTest("idea/testData/quickfix/createFromUsage/createVariable/property/inLabelRef.kt");
                }

                @TestMetadata("inconsistentTypes.kt")
                public void testInconsistentTypes() throws Exception {
                    runTest("idea/testData/quickfix/createFromUsage/createVariable/property/inconsistentTypes.kt");
                }

                @TestMetadata("localValDelegateRuntime.kt")
                public void testLocalValDelegateRuntime() throws Exception {
                    runTest("idea/testData/quickfix/createFromUsage/createVariable/property/localValDelegateRuntime.kt");
                }

                @TestMetadata("localValNoReceiver.kt")
                public void testLocalValNoReceiver() throws Exception {
                    runTest("idea/testData/quickfix/createFromUsage/createVariable/property/localValNoReceiver.kt");
                }

                @TestMetadata("memberValDelegateRuntime.kt")
                public void testMemberValDelegateRuntime() throws Exception {
                    runTest("idea/testData/quickfix/createFromUsage/createVariable/property/memberValDelegateRuntime.kt");
                }

                @TestMetadata("memberValNoReceiver.kt")
                public void testMemberValNoReceiver() throws Exception {
                    runTest("idea/testData/quickfix/createFromUsage/createVariable/property/memberValNoReceiver.kt");
                }

                @TestMetadata("memberVarDelegateRuntime.kt")
                public void testMemberVarDelegateRuntime() throws Exception {
                    runTest("idea/testData/quickfix/createFromUsage/createVariable/property/memberVarDelegateRuntime.kt");
                }

                @TestMetadata("memberWithTypeParameterAsReceiver.kt")
                public void testMemberWithTypeParameterAsReceiver() throws Exception {
                    runTest("idea/testData/quickfix/createFromUsage/createVariable/property/memberWithTypeParameterAsReceiver.kt");
                }

                @TestMetadata("nonAbstractInInterface.kt")
                public void testNonAbstractInInterface() throws Exception {
                    runTest("idea/testData/quickfix/createFromUsage/createVariable/property/nonAbstractInInterface.kt");
                }

                @TestMetadata("nullableReceiver.kt")
                public void testNullableReceiver() throws Exception {
                    runTest("idea/testData/quickfix/createFromUsage/createVariable/property/nullableReceiver.kt");
                }

                @TestMetadata("objectMemberValNoReceiver.kt")
                public void testObjectMemberValNoReceiver() throws Exception {
                    runTest("idea/testData/quickfix/createFromUsage/createVariable/property/objectMemberValNoReceiver.kt");
                }

                @TestMetadata("privateForMembers.kt")
                public void testPrivateForMembers() throws Exception {
                    runTest("idea/testData/quickfix/createFromUsage/createVariable/property/privateForMembers.kt");
                }

                @TestMetadata("qualifiedRefInStringTemplateRuntime.kt")
                public void testQualifiedRefInStringTemplateRuntime() throws Exception {
                    runTest("idea/testData/quickfix/createFromUsage/createVariable/property/qualifiedRefInStringTemplateRuntime.kt");
                }

                @TestMetadata("quotedName.kt")
                public void testQuotedName() throws Exception {
                    runTest("idea/testData/quickfix/createFromUsage/createVariable/property/quotedName.kt");
                }

                @TestMetadata("recursiveBound.kt")
                public void testRecursiveBound() throws Exception {
                    runTest("idea/testData/quickfix/createFromUsage/createVariable/property/recursiveBound.kt");
                }

                @TestMetadata("refInImport.kt")
                public void testRefInImport() throws Exception {
                    runTest("idea/testData/quickfix/createFromUsage/createVariable/property/refInImport.kt");
                }

                @TestMetadata("refInStringTemplateRuntime.kt")
                public void testRefInStringTemplateRuntime() throws Exception {
                    runTest("idea/testData/quickfix/createFromUsage/createVariable/property/refInStringTemplateRuntime.kt");
                }

                @TestMetadata("thisInClass.kt")
                public void testThisInClass() throws Exception {
                    runTest("idea/testData/quickfix/createFromUsage/createVariable/property/thisInClass.kt");
                }

                @TestMetadata("thisInClassAlreadyExistsAfter.kt")
                public void testThisInClassAlreadyExistsAfter() throws Exception {
                    runTest("idea/testData/quickfix/createFromUsage/createVariable/property/thisInClassAlreadyExistsAfter.kt");
                }

                @TestMetadata("thisInClassAlreadyExistsAfterAndBefore.kt")
                public void testThisInClassAlreadyExistsAfterAndBefore() throws Exception {
                    runTest("idea/testData/quickfix/createFromUsage/createVariable/property/thisInClassAlreadyExistsAfterAndBefore.kt");
                }

                @TestMetadata("thisInClassAlreadyExistsBefore.kt")
                public void testThisInClassAlreadyExistsBefore() throws Exception {
                    runTest("idea/testData/quickfix/createFromUsage/createVariable/property/thisInClassAlreadyExistsBefore.kt");
                }

                @TestMetadata("thisInExtension.kt")
                public void testThisInExtension() throws Exception {
                    runTest("idea/testData/quickfix/createFromUsage/createVariable/property/thisInExtension.kt");
                }

                @TestMetadata("thisInNestedClass1.kt")
                public void testThisInNestedClass1() throws Exception {
                    runTest("idea/testData/quickfix/createFromUsage/createVariable/property/thisInNestedClass1.kt");
                }

                @TestMetadata("thisInNestedClass2.kt")
                public void testThisInNestedClass2() throws Exception {
                    runTest("idea/testData/quickfix/createFromUsage/createVariable/property/thisInNestedClass2.kt");
                }

                @TestMetadata("topLevelValNoReceiver.kt")
                public void testTopLevelValNoReceiver() throws Exception {
                    runTest("idea/testData/quickfix/createFromUsage/createVariable/property/topLevelValNoReceiver.kt");
                }

                @TestMetadata("topLevelValNoReceiverAlreadyExistsAfter.kt")
                public void testTopLevelValNoReceiverAlreadyExistsAfter() throws Exception {
                    runTest("idea/testData/quickfix/createFromUsage/createVariable/property/topLevelValNoReceiverAlreadyExistsAfter.kt");
                }

                @TestMetadata("topLevelValNoReceiverAlreadyExistsBefore.kt")
                public void testTopLevelValNoReceiverAlreadyExistsBefore() throws Exception {
                    runTest("idea/testData/quickfix/createFromUsage/createVariable/property/topLevelValNoReceiverAlreadyExistsBefore.kt");
                }

                @TestMetadata("topLevelValWithPackageName.kt")
                public void testTopLevelValWithPackageName() throws Exception {
                    runTest("idea/testData/quickfix/createFromUsage/createVariable/property/topLevelValWithPackageName.kt");
                }

                @TestMetadata("valOnClassNoClassObject.kt")
                public void testValOnClassNoClassObject() throws Exception {
                    runTest("idea/testData/quickfix/createFromUsage/createVariable/property/valOnClassNoClassObject.kt");
                }

                @TestMetadata("valOnClassObject.kt")
                public void testValOnClassObject() throws Exception {
                    runTest("idea/testData/quickfix/createFromUsage/createVariable/property/valOnClassObject.kt");
                }

                @TestMetadata("valOnLibObject.kt")
                public void testValOnLibObject() throws Exception {
                    runTest("idea/testData/quickfix/createFromUsage/createVariable/property/valOnLibObject.kt");
                }

                @TestMetadata("valOnLibType.kt")
                public void testValOnLibType() throws Exception {
                    runTest("idea/testData/quickfix/createFromUsage/createVariable/property/valOnLibType.kt");
                }

                @TestMetadata("valOnUserObject.kt")
                public void testValOnUserObject() throws Exception {
                    runTest("idea/testData/quickfix/createFromUsage/createVariable/property/valOnUserObject.kt");
                }

                @TestMetadata("valOnUserType.kt")
                public void testValOnUserType() throws Exception {
                    runTest("idea/testData/quickfix/createFromUsage/createVariable/property/valOnUserType.kt");
                }

                @TestMetadata("valOnUserTypeWithTypeParams.kt")
                public void testValOnUserTypeWithTypeParams() throws Exception {
                    runTest("idea/testData/quickfix/createFromUsage/createVariable/property/valOnUserTypeWithTypeParams.kt");
                }

                @TestMetadata("valWithNullableType.kt")
                public void testValWithNullableType() throws Exception {
                    runTest("idea/testData/quickfix/createFromUsage/createVariable/property/valWithNullableType.kt");
                }

                @TestMetadata("varOnLibType.kt")
                public void testVarOnLibType() throws Exception {
                    runTest("idea/testData/quickfix/createFromUsage/createVariable/property/varOnLibType.kt");
                }

                @TestMetadata("varOnUserType.kt")
                public void testVarOnUserType() throws Exception {
                    runTest("idea/testData/quickfix/createFromUsage/createVariable/property/varOnUserType.kt");
                }

                @TestMetadata("idea/testData/quickfix/createFromUsage/createVariable/property/abstract")
                @TestDataPath("$PROJECT_ROOT")
                @RunWith(JUnit3RunnerWithInners.class)
                public static class Abstract extends AbstractQuickFixTest {
                    private void runTest(String testDataFilePath) throws Exception {
                        KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
                    }

                    public void testAllFilesPresentInAbstract() throws Exception {
                        KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/quickfix/createFromUsage/createVariable/property/abstract"), Pattern.compile("^([\\w\\-_]+)\\.kt$"), TargetBackend.ANY, true);
                    }

                    @TestMetadata("classNoExplicitReceiver.kt")
                    public void testClassNoExplicitReceiver() throws Exception {
                        runTest("idea/testData/quickfix/createFromUsage/createVariable/property/abstract/classNoExplicitReceiver.kt");
                    }

                    @TestMetadata("explicitReceiverOfContainingClass.kt")
                    public void testExplicitReceiverOfContainingClass() throws Exception {
                        runTest("idea/testData/quickfix/createFromUsage/createVariable/property/abstract/explicitReceiverOfContainingClass.kt");
                    }

                    @TestMetadata("interfaceNoExplicitReceiver.kt")
                    public void testInterfaceNoExplicitReceiver() throws Exception {
                        runTest("idea/testData/quickfix/createFromUsage/createVariable/property/abstract/interfaceNoExplicitReceiver.kt");
                    }

                    @TestMetadata("notAbstractClass.kt")
                    public void testNotAbstractClass() throws Exception {
                        runTest("idea/testData/quickfix/createFromUsage/createVariable/property/abstract/notAbstractClass.kt");
                    }

                    @TestMetadata("otherExplicitReceiver.kt")
                    public void testOtherExplicitReceiver() throws Exception {
                        runTest("idea/testData/quickfix/createFromUsage/createVariable/property/abstract/otherExplicitReceiver.kt");
                    }
                }

                @TestMetadata("idea/testData/quickfix/createFromUsage/createVariable/property/fieldFromJava")
                @TestDataPath("$PROJECT_ROOT")
                @RunWith(JUnit3RunnerWithInners.class)
                public static class FieldFromJava extends AbstractQuickFixTest {
                    private void runTest(String testDataFilePath) throws Exception {
                        KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
                    }

                    public void testAllFilesPresentInFieldFromJava() throws Exception {
                        KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/quickfix/createFromUsage/createVariable/property/fieldFromJava"), Pattern.compile("^([\\w\\-_]+)\\.kt$"), TargetBackend.ANY, true);
                    }
                }
            }
        }
    }

    @TestMetadata("idea/testData/quickfix/createLabel")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class CreateLabel extends AbstractQuickFixTest {
        private void runTest(String testDataFilePath) throws Exception {
            KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
        }

        public void testAllFilesPresentInCreateLabel() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/quickfix/createLabel"), Pattern.compile("^([\\w\\-_]+)\\.kt$"), TargetBackend.ANY, true);
        }

        @TestMetadata("breakInLoop.kt")
        public void testBreakInLoop() throws Exception {
            runTest("idea/testData/quickfix/createLabel/breakInLoop.kt");
        }

        @TestMetadata("breakInOuterLoop.kt")
        public void testBreakInOuterLoop() throws Exception {
            runTest("idea/testData/quickfix/createLabel/breakInOuterLoop.kt");
        }

        @TestMetadata("breakInlambdaBeforeLoop.kt")
        public void testBreakInlambdaBeforeLoop() throws Exception {
            runTest("idea/testData/quickfix/createLabel/breakInlambdaBeforeLoop.kt");
        }

        @TestMetadata("breakNoLoop.kt")
        public void testBreakNoLoop() throws Exception {
            runTest("idea/testData/quickfix/createLabel/breakNoLoop.kt");
        }

        @TestMetadata("continueInLoop.kt")
        public void testContinueInLoop() throws Exception {
            runTest("idea/testData/quickfix/createLabel/continueInLoop.kt");
        }

        @TestMetadata("continueNoLoop.kt")
        public void testContinueNoLoop() throws Exception {
            runTest("idea/testData/quickfix/createLabel/continueNoLoop.kt");
        }

        @TestMetadata("returnInLambda.kt")
        public void testReturnInLambda() throws Exception {
            runTest("idea/testData/quickfix/createLabel/returnInLambda.kt");
        }

        @TestMetadata("returnInOuterLambda.kt")
        public void testReturnInOuterLambda() throws Exception {
            runTest("idea/testData/quickfix/createLabel/returnInOuterLambda.kt");
        }

        @TestMetadata("returnNoLambda.kt")
        public void testReturnNoLambda() throws Exception {
            runTest("idea/testData/quickfix/createLabel/returnNoLambda.kt");
        }
    }

    @TestMetadata("idea/testData/quickfix/declarationCantBeInlined")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class DeclarationCantBeInlined extends AbstractQuickFixTest {
        private void runTest(String testDataFilePath) throws Exception {
            KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
        }

        public void testAllFilesPresentInDeclarationCantBeInlined() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/quickfix/declarationCantBeInlined"), Pattern.compile("^([\\w\\-_]+)\\.kt$"), TargetBackend.ANY, true);
        }

        @TestMetadata("inClass.kt")
        public void testInClass() throws Exception {
            runTest("idea/testData/quickfix/declarationCantBeInlined/inClass.kt");
        }

        @TestMetadata("inInterface.kt")
        public void testInInterface() throws Exception {
            runTest("idea/testData/quickfix/declarationCantBeInlined/inInterface.kt");
        }
    }

    @TestMetadata("idea/testData/quickfix/decreaseVisibility")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class DecreaseVisibility extends AbstractQuickFixTest {
        private void runTest(String testDataFilePath) throws Exception {
            KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
        }

        public void testAllFilesPresentInDecreaseVisibility() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/quickfix/decreaseVisibility"), Pattern.compile("^([\\w\\-_]+)\\.kt$"), TargetBackend.ANY, true);
        }

        @TestMetadata("exposedParameterType.kt")
        public void testExposedParameterType() throws Exception {
            runTest("idea/testData/quickfix/decreaseVisibility/exposedParameterType.kt");
        }

        @TestMetadata("exposedPropertyType.kt")
        public void testExposedPropertyType() throws Exception {
            runTest("idea/testData/quickfix/decreaseVisibility/exposedPropertyType.kt");
        }

        @TestMetadata("exposedReceiverType.kt")
        public void testExposedReceiverType() throws Exception {
            runTest("idea/testData/quickfix/decreaseVisibility/exposedReceiverType.kt");
        }

        @TestMetadata("exposedReturnType.kt")
        public void testExposedReturnType() throws Exception {
            runTest("idea/testData/quickfix/decreaseVisibility/exposedReturnType.kt");
        }

        @TestMetadata("exposedSuperClass.kt")
        public void testExposedSuperClass() throws Exception {
            runTest("idea/testData/quickfix/decreaseVisibility/exposedSuperClass.kt");
        }

        @TestMetadata("exposedSuperClassProtectedBase.kt")
        public void testExposedSuperClassProtectedBase() throws Exception {
            runTest("idea/testData/quickfix/decreaseVisibility/exposedSuperClassProtectedBase.kt");
        }

        @TestMetadata("exposedSuperClassProtectedInAnother.kt")
        public void testExposedSuperClassProtectedInAnother() throws Exception {
            runTest("idea/testData/quickfix/decreaseVisibility/exposedSuperClassProtectedInAnother.kt");
        }

        @TestMetadata("exposedSuperInterface.kt")
        public void testExposedSuperInterface() throws Exception {
            runTest("idea/testData/quickfix/decreaseVisibility/exposedSuperInterface.kt");
        }

        @TestMetadata("exposedSuperInterfacePrivate.kt")
        public void testExposedSuperInterfacePrivate() throws Exception {
            runTest("idea/testData/quickfix/decreaseVisibility/exposedSuperInterfacePrivate.kt");
        }

        @TestMetadata("exposedTypeInAnnotation.kt")
        public void testExposedTypeInAnnotation() throws Exception {
            runTest("idea/testData/quickfix/decreaseVisibility/exposedTypeInAnnotation.kt");
        }

        @TestMetadata("exposedTypeParameterBound.kt")
        public void testExposedTypeParameterBound() throws Exception {
            runTest("idea/testData/quickfix/decreaseVisibility/exposedTypeParameterBound.kt");
        }
    }

    @TestMetadata("idea/testData/quickfix/deprecatedJavaAnnotation")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class DeprecatedJavaAnnotation extends AbstractQuickFixTest {
        private void runTest(String testDataFilePath) throws Exception {
            KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
        }

        public void testAllFilesPresentInDeprecatedJavaAnnotation() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/quickfix/deprecatedJavaAnnotation"), Pattern.compile("^([\\w\\-_]+)\\.kt$"), TargetBackend.ANY, true);
        }

        @TestMetadata("withArgument.kt")
        public void testWithArgument() throws Exception {
            runTest("idea/testData/quickfix/deprecatedJavaAnnotation/withArgument.kt");
        }

        @TestMetadata("withoutArguments.kt")
        public void testWithoutArguments() throws Exception {
            runTest("idea/testData/quickfix/deprecatedJavaAnnotation/withoutArguments.kt");
        }
    }

    @TestMetadata("idea/testData/quickfix/deprecatedSymbolUsage")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class DeprecatedSymbolUsage extends AbstractQuickFixTest {
        private void runTest(String testDataFilePath) throws Exception {
            KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
        }

        @TestMetadata("addImplicitReceiverNested.kt")
        public void testAddImplicitReceiverNested() throws Exception {
            runTest("idea/testData/quickfix/deprecatedSymbolUsage/addImplicitReceiverNested.kt");
        }

        public void testAllFilesPresentInDeprecatedSymbolUsage() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/quickfix/deprecatedSymbolUsage"), Pattern.compile("^([\\w\\-_]+)\\.kt$"), TargetBackend.ANY, true);
        }

        @TestMetadata("callChainBug.kt")
        public void testCallChainBug() throws Exception {
            runTest("idea/testData/quickfix/deprecatedSymbolUsage/callChainBug.kt");
        }

        @TestMetadata("callWithError.kt")
        public void testCallWithError() throws Exception {
            runTest("idea/testData/quickfix/deprecatedSymbolUsage/callWithError.kt");
        }

        @TestMetadata("changeThis1.kt")
        public void testChangeThis1() throws Exception {
            runTest("idea/testData/quickfix/deprecatedSymbolUsage/changeThis1.kt");
        }

        @TestMetadata("changeThis2.kt")
        public void testChangeThis2() throws Exception {
            runTest("idea/testData/quickfix/deprecatedSymbolUsage/changeThis2.kt");
        }

        @TestMetadata("changeThisToOuterThis.kt")
        public void testChangeThisToOuterThis() throws Exception {
            runTest("idea/testData/quickfix/deprecatedSymbolUsage/changeThisToOuterThis.kt");
        }

        @TestMetadata("classLiteralAndTypeArgsRuntime.kt")
        public void testClassLiteralAndTypeArgsRuntime() throws Exception {
            runTest("idea/testData/quickfix/deprecatedSymbolUsage/classLiteralAndTypeArgsRuntime.kt");
        }

        @TestMetadata("deprecationLevel.kt")
        public void testDeprecationLevel() throws Exception {
            runTest("idea/testData/quickfix/deprecatedSymbolUsage/deprecationLevel.kt");
        }

        @TestMetadata("doNotShortenUserReferences.kt")
        public void testDoNotShortenUserReferences() throws Exception {
            runTest("idea/testData/quickfix/deprecatedSymbolUsage/doNotShortenUserReferences.kt");
        }

        @TestMetadata("doNotShortenUsersExplicitThis.kt")
        public void testDoNotShortenUsersExplicitThis() throws Exception {
            runTest("idea/testData/quickfix/deprecatedSymbolUsage/doNotShortenUsersExplicitThis.kt");
        }

        @TestMetadata("dropReceiver.kt")
        public void testDropReceiver() throws Exception {
            runTest("idea/testData/quickfix/deprecatedSymbolUsage/dropReceiver.kt");
        }

        @TestMetadata("extensionForGenericClass.kt")
        public void testExtensionForGenericClass() throws Exception {
            runTest("idea/testData/quickfix/deprecatedSymbolUsage/extensionForGenericClass.kt");
        }

        @TestMetadata("implicitCompanionObjectThis.kt")
        public void testImplicitCompanionObjectThis() throws Exception {
            runTest("idea/testData/quickfix/deprecatedSymbolUsage/implicitCompanionObjectThis.kt");
        }

        @TestMetadata("implicitQualifiedThisRuntime.kt")
        public void testImplicitQualifiedThisRuntime() throws Exception {
            runTest("idea/testData/quickfix/deprecatedSymbolUsage/implicitQualifiedThisRuntime.kt");
        }

        @TestMetadata("incorrectArgs.kt")
        public void testIncorrectArgs() throws Exception {
            runTest("idea/testData/quickfix/deprecatedSymbolUsage/incorrectArgs.kt");
        }

        @TestMetadata("incorrectReplacement.kt")
        public void testIncorrectReplacement() throws Exception {
            runTest("idea/testData/quickfix/deprecatedSymbolUsage/incorrectReplacement.kt");
        }

        @TestMetadata("infixCall.kt")
        public void testInfixCall() throws Exception {
            runTest("idea/testData/quickfix/deprecatedSymbolUsage/infixCall.kt");
        }

        @TestMetadata("keepArgumentNamed.kt")
        public void testKeepArgumentNamed() throws Exception {
            runTest("idea/testData/quickfix/deprecatedSymbolUsage/keepArgumentNamed.kt");
        }

        @TestMetadata("keepInfixCall.kt")
        public void testKeepInfixCall() throws Exception {
            runTest("idea/testData/quickfix/deprecatedSymbolUsage/keepInfixCall.kt");
        }

        @TestMetadata("localFun.kt")
        public void testLocalFun() throws Exception {
            runTest("idea/testData/quickfix/deprecatedSymbolUsage/localFun.kt");
        }

        @TestMetadata("mailformedExpression.kt")
        public void testMailformedExpression() throws Exception {
            runTest("idea/testData/quickfix/deprecatedSymbolUsage/mailformedExpression.kt");
        }

        @TestMetadata("memberFunction.kt")
        public void testMemberFunction() throws Exception {
            runTest("idea/testData/quickfix/deprecatedSymbolUsage/memberFunction.kt");
        }

        @TestMetadata("memberFunctionImplicitReceiver.kt")
        public void testMemberFunctionImplicitReceiver() throws Exception {
            runTest("idea/testData/quickfix/deprecatedSymbolUsage/memberFunctionImplicitReceiver.kt");
        }

        @TestMetadata("memberFunctionInGenericClass.kt")
        public void testMemberFunctionInGenericClass() throws Exception {
            runTest("idea/testData/quickfix/deprecatedSymbolUsage/memberFunctionInGenericClass.kt");
        }

        @TestMetadata("methodToProperty.kt")
        public void testMethodToProperty() throws Exception {
            runTest("idea/testData/quickfix/deprecatedSymbolUsage/methodToProperty.kt");
        }

        @TestMetadata("noReplacement.kt")
        public void testNoReplacement() throws Exception {
            runTest("idea/testData/quickfix/deprecatedSymbolUsage/noReplacement.kt");
        }

        @TestMetadata("objects.kt")
        public void testObjects() throws Exception {
            runTest("idea/testData/quickfix/deprecatedSymbolUsage/objects.kt");
        }

        @TestMetadata("objectsInQualified.kt")
        public void testObjectsInQualified() throws Exception {
            runTest("idea/testData/quickfix/deprecatedSymbolUsage/objectsInQualified.kt");
        }

        @TestMetadata("operatorCall.kt")
        public void testOperatorCall() throws Exception {
            runTest("idea/testData/quickfix/deprecatedSymbolUsage/operatorCall.kt");
        }

        @TestMetadata("operatorCall2.kt")
        public void testOperatorCall2() throws Exception {
            runTest("idea/testData/quickfix/deprecatedSymbolUsage/operatorCall2.kt");
        }

        @TestMetadata("parameters.kt")
        public void testParameters() throws Exception {
            runTest("idea/testData/quickfix/deprecatedSymbolUsage/parameters.kt");
        }

        @TestMetadata("propertyAssignment.kt")
        public void testPropertyAssignment() throws Exception {
            runTest("idea/testData/quickfix/deprecatedSymbolUsage/propertyAssignment.kt");
        }

        @TestMetadata("propertyAssignmentDefaultSetter.kt")
        public void testPropertyAssignmentDefaultSetter() throws Exception {
            runTest("idea/testData/quickfix/deprecatedSymbolUsage/propertyAssignmentDefaultSetter.kt");
        }

        @TestMetadata("propertyAssignmentNoReceiver.kt")
        public void testPropertyAssignmentNoReceiver() throws Exception {
            runTest("idea/testData/quickfix/deprecatedSymbolUsage/propertyAssignmentNoReceiver.kt");
        }

        @TestMetadata("propertyAssignmentNoSetter.kt")
        public void testPropertyAssignmentNoSetter() throws Exception {
            runTest("idea/testData/quickfix/deprecatedSymbolUsage/propertyAssignmentNoSetter.kt");
        }

        @TestMetadata("propertyModification.kt")
        public void testPropertyModification() throws Exception {
            runTest("idea/testData/quickfix/deprecatedSymbolUsage/propertyModification.kt");
        }

        @TestMetadata("propertyToMethod.kt")
        public void testPropertyToMethod() throws Exception {
            runTest("idea/testData/quickfix/deprecatedSymbolUsage/propertyToMethod.kt");
        }

        @TestMetadata("propertyToSyntheticExtension.kt")
        public void testPropertyToSyntheticExtension() throws Exception {
            runTest("idea/testData/quickfix/deprecatedSymbolUsage/propertyToSyntheticExtension.kt");
        }

        @TestMetadata("replaceCallWithArgument.kt")
        public void testReplaceCallWithArgument() throws Exception {
            runTest("idea/testData/quickfix/deprecatedSymbolUsage/replaceCallWithArgument.kt");
        }

        @TestMetadata("replaceCallWithReceiver.kt")
        public void testReplaceCallWithReceiver() throws Exception {
            runTest("idea/testData/quickfix/deprecatedSymbolUsage/replaceCallWithReceiver.kt");
        }

        @TestMetadata("replaceModToRem.kt")
        public void testReplaceModToRem() throws Exception {
            runTest("idea/testData/quickfix/deprecatedSymbolUsage/replaceModToRem.kt");
        }

        @TestMetadata("shortenReferences.kt")
        public void testShortenReferences() throws Exception {
            runTest("idea/testData/quickfix/deprecatedSymbolUsage/shortenReferences.kt");
        }

        @TestMetadata("simple.kt")
        public void testSimple() throws Exception {
            runTest("idea/testData/quickfix/deprecatedSymbolUsage/simple.kt");
        }

        @TestMetadata("stringTemplate.kt")
        public void testStringTemplate() throws Exception {
            runTest("idea/testData/quickfix/deprecatedSymbolUsage/stringTemplate.kt");
        }

        @TestMetadata("suspendLambda.kt")
        public void testSuspendLambda() throws Exception {
            runTest("idea/testData/quickfix/deprecatedSymbolUsage/suspendLambda.kt");
        }

        @TestMetadata("toOuterClassMethod.kt")
        public void testToOuterClassMethod() throws Exception {
            runTest("idea/testData/quickfix/deprecatedSymbolUsage/toOuterClassMethod.kt");
        }

        @TestMetadata("twoValuesCombined.kt")
        public void testTwoValuesCombined() throws Exception {
            runTest("idea/testData/quickfix/deprecatedSymbolUsage/twoValuesCombined.kt");
        }

        @TestMetadata("usageInDerivedClass.kt")
        public void testUsageInDerivedClass() throws Exception {
            runTest("idea/testData/quickfix/deprecatedSymbolUsage/usageInDerivedClass.kt");
        }

        @TestMetadata("usageInDerivedClassGeneric.kt")
        public void testUsageInDerivedClassGeneric() throws Exception {
            runTest("idea/testData/quickfix/deprecatedSymbolUsage/usageInDerivedClassGeneric.kt");
        }

        @TestMetadata("idea/testData/quickfix/deprecatedSymbolUsage/argumentSideEffects")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class ArgumentSideEffects extends AbstractQuickFixTest {
            private void runTest(String testDataFilePath) throws Exception {
                KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
            }

            public void testAllFilesPresentInArgumentSideEffects() throws Exception {
                KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/quickfix/deprecatedSymbolUsage/argumentSideEffects"), Pattern.compile("^([\\w\\-_]+)\\.kt$"), TargetBackend.ANY, true);
            }

            @TestMetadata("complexExpressionNotUsed1.kt")
            public void testComplexExpressionNotUsed1() throws Exception {
                runTest("idea/testData/quickfix/deprecatedSymbolUsage/argumentSideEffects/complexExpressionNotUsed1.kt");
            }

            @TestMetadata("complexExpressionNotUsed2.kt")
            public void testComplexExpressionNotUsed2() throws Exception {
                runTest("idea/testData/quickfix/deprecatedSymbolUsage/argumentSideEffects/complexExpressionNotUsed2.kt");
            }

            @TestMetadata("complexExpressionNotUsed3Runtime.kt")
            public void testComplexExpressionNotUsed3Runtime() throws Exception {
                runTest("idea/testData/quickfix/deprecatedSymbolUsage/argumentSideEffects/complexExpressionNotUsed3Runtime.kt");
            }

            @TestMetadata("complexExpressionNotUsed4Runtime.kt")
            public void testComplexExpressionNotUsed4Runtime() throws Exception {
                runTest("idea/testData/quickfix/deprecatedSymbolUsage/argumentSideEffects/complexExpressionNotUsed4Runtime.kt");
            }

            @TestMetadata("complexExpressionNotUsed5Runtime.kt")
            public void testComplexExpressionNotUsed5Runtime() throws Exception {
                runTest("idea/testData/quickfix/deprecatedSymbolUsage/argumentSideEffects/complexExpressionNotUsed5Runtime.kt");
            }

            @TestMetadata("complexExpressionNotUsedSafeCall.kt")
            public void testComplexExpressionNotUsedSafeCall() throws Exception {
                runTest("idea/testData/quickfix/deprecatedSymbolUsage/argumentSideEffects/complexExpressionNotUsedSafeCall.kt");
            }

            @TestMetadata("complexExpressionNotUsedSafeCall2Runtime.kt")
            public void testComplexExpressionNotUsedSafeCall2Runtime() throws Exception {
                runTest("idea/testData/quickfix/deprecatedSymbolUsage/argumentSideEffects/complexExpressionNotUsedSafeCall2Runtime.kt");
            }

            @TestMetadata("complexExpressionNotUsedShortenRefsRuntime.kt")
            public void testComplexExpressionNotUsedShortenRefsRuntime() throws Exception {
                runTest("idea/testData/quickfix/deprecatedSymbolUsage/argumentSideEffects/complexExpressionNotUsedShortenRefsRuntime.kt");
            }

            @TestMetadata("complexExpressionUsedTwice.kt")
            public void testComplexExpressionUsedTwice() throws Exception {
                runTest("idea/testData/quickfix/deprecatedSymbolUsage/argumentSideEffects/complexExpressionUsedTwice.kt");
            }

            @TestMetadata("complexExpressionUsedTwice2.kt")
            public void testComplexExpressionUsedTwice2() throws Exception {
                runTest("idea/testData/quickfix/deprecatedSymbolUsage/argumentSideEffects/complexExpressionUsedTwice2.kt");
            }

            @TestMetadata("complexExpressionUsedTwice3Runtime.kt")
            public void testComplexExpressionUsedTwice3Runtime() throws Exception {
                runTest("idea/testData/quickfix/deprecatedSymbolUsage/argumentSideEffects/complexExpressionUsedTwice3Runtime.kt");
            }

            @TestMetadata("complexExpressionUsedTwice4.kt")
            public void testComplexExpressionUsedTwice4() throws Exception {
                runTest("idea/testData/quickfix/deprecatedSymbolUsage/argumentSideEffects/complexExpressionUsedTwice4.kt");
            }

            @TestMetadata("complexExpressionUsedTwice5Runtime.kt")
            public void testComplexExpressionUsedTwice5Runtime() throws Exception {
                runTest("idea/testData/quickfix/deprecatedSymbolUsage/argumentSideEffects/complexExpressionUsedTwice5Runtime.kt");
            }

            @TestMetadata("complexExpressionUsedTwice6Runtime.kt")
            public void testComplexExpressionUsedTwice6Runtime() throws Exception {
                runTest("idea/testData/quickfix/deprecatedSymbolUsage/argumentSideEffects/complexExpressionUsedTwice6Runtime.kt");
            }

            @TestMetadata("simpleExpressionNotUsed.kt")
            public void testSimpleExpressionNotUsed() throws Exception {
                runTest("idea/testData/quickfix/deprecatedSymbolUsage/argumentSideEffects/simpleExpressionNotUsed.kt");
            }

            @TestMetadata("simpleExpressionUsedTwice.kt")
            public void testSimpleExpressionUsedTwice() throws Exception {
                runTest("idea/testData/quickfix/deprecatedSymbolUsage/argumentSideEffects/simpleExpressionUsedTwice.kt");
            }

            @TestMetadata("stringLiteralUsedTwice.kt")
            public void testStringLiteralUsedTwice() throws Exception {
                runTest("idea/testData/quickfix/deprecatedSymbolUsage/argumentSideEffects/stringLiteralUsedTwice.kt");
            }

            @TestMetadata("stringTemplateUsedTwice.kt")
            public void testStringTemplateUsedTwice() throws Exception {
                runTest("idea/testData/quickfix/deprecatedSymbolUsage/argumentSideEffects/stringTemplateUsedTwice.kt");
            }

            @TestMetadata("stringTemplateUsedTwice2.kt")
            public void testStringTemplateUsedTwice2() throws Exception {
                runTest("idea/testData/quickfix/deprecatedSymbolUsage/argumentSideEffects/stringTemplateUsedTwice2.kt");
            }
        }

        @TestMetadata("idea/testData/quickfix/deprecatedSymbolUsage/classUsages")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class ClassUsages extends AbstractQuickFixTest {
            private void runTest(String testDataFilePath) throws Exception {
                KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
            }

            public void testAllFilesPresentInClassUsages() throws Exception {
                KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/quickfix/deprecatedSymbolUsage/classUsages"), Pattern.compile("^([\\w\\-_]+)\\.kt$"), TargetBackend.ANY, true);
            }

            @TestMetadata("annotation1.kt")
            public void testAnnotation1() throws Exception {
                runTest("idea/testData/quickfix/deprecatedSymbolUsage/classUsages/annotation1.kt");
            }

            @TestMetadata("annotation2.kt")
            public void testAnnotation2() throws Exception {
                runTest("idea/testData/quickfix/deprecatedSymbolUsage/classUsages/annotation2.kt");
            }

            @TestMetadata("annotation3.kt")
            public void testAnnotation3() throws Exception {
                runTest("idea/testData/quickfix/deprecatedSymbolUsage/classUsages/annotation3.kt");
            }

            @TestMetadata("annotation4.kt")
            public void testAnnotation4() throws Exception {
                runTest("idea/testData/quickfix/deprecatedSymbolUsage/classUsages/annotation4.kt");
            }

            @TestMetadata("annotationKeepNamedArgs.kt")
            public void testAnnotationKeepNamedArgs() throws Exception {
                runTest("idea/testData/quickfix/deprecatedSymbolUsage/classUsages/annotationKeepNamedArgs.kt");
            }

            @TestMetadata("constructorUsage1.kt")
            public void testConstructorUsage1() throws Exception {
                runTest("idea/testData/quickfix/deprecatedSymbolUsage/classUsages/constructorUsage1.kt");
            }

            @TestMetadata("constructorUsage2.kt")
            public void testConstructorUsage2() throws Exception {
                runTest("idea/testData/quickfix/deprecatedSymbolUsage/classUsages/constructorUsage2.kt");
            }

            @TestMetadata("constructorUsage3.kt")
            public void testConstructorUsage3() throws Exception {
                runTest("idea/testData/quickfix/deprecatedSymbolUsage/classUsages/constructorUsage3.kt");
            }

            @TestMetadata("constructorUsage4.kt")
            public void testConstructorUsage4() throws Exception {
                runTest("idea/testData/quickfix/deprecatedSymbolUsage/classUsages/constructorUsage4.kt");
            }

            @TestMetadata("imports.kt")
            public void testImports() throws Exception {
                runTest("idea/testData/quickfix/deprecatedSymbolUsage/classUsages/imports.kt");
            }

            @TestMetadata("inAliasSimple.kt")
            public void testInAliasSimple() throws Exception {
                runTest("idea/testData/quickfix/deprecatedSymbolUsage/classUsages/inAliasSimple.kt");
            }

            @TestMetadata("inAliasWithOwnReplaceForConstructorForAliasArguments.kt")
            public void testInAliasWithOwnReplaceForConstructorForAliasArguments() throws Exception {
                runTest("idea/testData/quickfix/deprecatedSymbolUsage/classUsages/inAliasWithOwnReplaceForConstructorForAliasArguments.kt");
            }

            @TestMetadata("inAliasWithOwnReplaceForConstructorUnused.kt")
            public void testInAliasWithOwnReplaceForConstructorUnused() throws Exception {
                runTest("idea/testData/quickfix/deprecatedSymbolUsage/classUsages/inAliasWithOwnReplaceForConstructorUnused.kt");
            }

            @TestMetadata("inAliasWithOwnReplaceForConstructorUsed.kt")
            public void testInAliasWithOwnReplaceForConstructorUsed() throws Exception {
                runTest("idea/testData/quickfix/deprecatedSymbolUsage/classUsages/inAliasWithOwnReplaceForConstructorUsed.kt");
            }

            @TestMetadata("inAliasWithOwnReplaceForSecondaryConstructorUnused.kt")
            public void testInAliasWithOwnReplaceForSecondaryConstructorUnused() throws Exception {
                runTest("idea/testData/quickfix/deprecatedSymbolUsage/classUsages/inAliasWithOwnReplaceForSecondaryConstructorUnused.kt");
            }

            @TestMetadata("inAliasWithOwnReplaceForSecondaryConstructorUsed.kt")
            public void testInAliasWithOwnReplaceForSecondaryConstructorUsed() throws Exception {
                runTest("idea/testData/quickfix/deprecatedSymbolUsage/classUsages/inAliasWithOwnReplaceForSecondaryConstructorUsed.kt");
            }

            @TestMetadata("inTypeArgument.kt")
            public void testInTypeArgument() throws Exception {
                runTest("idea/testData/quickfix/deprecatedSymbolUsage/classUsages/inTypeArgument.kt");
            }

            @TestMetadata("nestedClassToNestedClass.kt")
            public void testNestedClassToNestedClass() throws Exception {
                runTest("idea/testData/quickfix/deprecatedSymbolUsage/classUsages/nestedClassToNestedClass.kt");
            }

            @TestMetadata("noAnnotationConstructorUsage.kt")
            public void testNoAnnotationConstructorUsage() throws Exception {
                runTest("idea/testData/quickfix/deprecatedSymbolUsage/classUsages/noAnnotationConstructorUsage.kt");
            }

            @TestMetadata("qualifiedClassName.kt")
            public void testQualifiedClassName() throws Exception {
                runTest("idea/testData/quickfix/deprecatedSymbolUsage/classUsages/qualifiedClassName.kt");
            }

            @TestMetadata("qualifiedClassNameInPattern.kt")
            public void testQualifiedClassNameInPattern() throws Exception {
                runTest("idea/testData/quickfix/deprecatedSymbolUsage/classUsages/qualifiedClassNameInPattern.kt");
            }

            @TestMetadata("simple.kt")
            public void testSimple() throws Exception {
                runTest("idea/testData/quickfix/deprecatedSymbolUsage/classUsages/simple.kt");
            }

            @TestMetadata("idea/testData/quickfix/deprecatedSymbolUsage/classUsages/wholeProject")
            @TestDataPath("$PROJECT_ROOT")
            @RunWith(JUnit3RunnerWithInners.class)
            public static class WholeProject extends AbstractQuickFixTest {
                private void runTest(String testDataFilePath) throws Exception {
                    KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
                }

                public void testAllFilesPresentInWholeProject() throws Exception {
                    KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/quickfix/deprecatedSymbolUsage/classUsages/wholeProject"), Pattern.compile("^([\\w\\-_]+)\\.kt$"), TargetBackend.ANY, true);
                }

                @TestMetadata("inheritance.kt")
                public void testInheritance() throws Exception {
                    runTest("idea/testData/quickfix/deprecatedSymbolUsage/classUsages/wholeProject/inheritance.kt");
                }
            }
        }

        @TestMetadata("idea/testData/quickfix/deprecatedSymbolUsage/functionLiteralArguments")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class FunctionLiteralArguments extends AbstractQuickFixTest {
            private void runTest(String testDataFilePath) throws Exception {
                KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
            }

            public void testAllFilesPresentInFunctionLiteralArguments() throws Exception {
                KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/quickfix/deprecatedSymbolUsage/functionLiteralArguments"), Pattern.compile("^([\\w\\-_]+)\\.kt$"), TargetBackend.ANY, true);
            }

            @TestMetadata("cannotKeepOutside.kt")
            public void testCannotKeepOutside() throws Exception {
                runTest("idea/testData/quickfix/deprecatedSymbolUsage/functionLiteralArguments/cannotKeepOutside.kt");
            }

            @TestMetadata("keepInside.kt")
            public void testKeepInside() throws Exception {
                runTest("idea/testData/quickfix/deprecatedSymbolUsage/functionLiteralArguments/keepInside.kt");
            }

            @TestMetadata("keepOutside.kt")
            public void testKeepOutside() throws Exception {
                runTest("idea/testData/quickfix/deprecatedSymbolUsage/functionLiteralArguments/keepOutside.kt");
            }
        }

        @TestMetadata("idea/testData/quickfix/deprecatedSymbolUsage/imports")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class Imports extends AbstractQuickFixTest {
            private void runTest(String testDataFilePath) throws Exception {
                KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
            }

            public void testAllFilesPresentInImports() throws Exception {
                KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/quickfix/deprecatedSymbolUsage/imports"), Pattern.compile("^([\\w\\-_]+)\\.kt$"), TargetBackend.ANY, true);
            }
        }

        @TestMetadata("idea/testData/quickfix/deprecatedSymbolUsage/keepComments")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class KeepComments extends AbstractQuickFixTest {
            private void runTest(String testDataFilePath) throws Exception {
                KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
            }

            @TestMetadata("addArguments.kt")
            public void testAddArguments() throws Exception {
                runTest("idea/testData/quickfix/deprecatedSymbolUsage/keepComments/addArguments.kt");
            }

            public void testAllFilesPresentInKeepComments() throws Exception {
                KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/quickfix/deprecatedSymbolUsage/keepComments"), Pattern.compile("^([\\w\\-_]+)\\.kt$"), TargetBackend.ANY, true);
            }

            @TestMetadata("commentBeforeArgument.kt")
            public void testCommentBeforeArgument() throws Exception {
                runTest("idea/testData/quickfix/deprecatedSymbolUsage/keepComments/commentBeforeArgument.kt");
            }

            @TestMetadata("dropArgument.kt")
            public void testDropArgument() throws Exception {
                runTest("idea/testData/quickfix/deprecatedSymbolUsage/keepComments/dropArgument.kt");
            }

            @TestMetadata("multipleArguments.kt")
            public void testMultipleArguments() throws Exception {
                runTest("idea/testData/quickfix/deprecatedSymbolUsage/keepComments/multipleArguments.kt");
            }

            @TestMetadata("simple.kt")
            public void testSimple() throws Exception {
                runTest("idea/testData/quickfix/deprecatedSymbolUsage/keepComments/simple.kt");
            }

            @TestMetadata("usedTwice.kt")
            public void testUsedTwice() throws Exception {
                runTest("idea/testData/quickfix/deprecatedSymbolUsage/keepComments/usedTwice.kt");
            }

            @TestMetadata("variableForArgument.kt")
            public void testVariableForArgument() throws Exception {
                runTest("idea/testData/quickfix/deprecatedSymbolUsage/keepComments/variableForArgument.kt");
            }
        }

        @TestMetadata("idea/testData/quickfix/deprecatedSymbolUsage/keepLineBreaks")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class KeepLineBreaks extends AbstractQuickFixTest {
            private void runTest(String testDataFilePath) throws Exception {
                KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
            }

            @TestMetadata("addArgument.kt")
            public void testAddArgument() throws Exception {
                runTest("idea/testData/quickfix/deprecatedSymbolUsage/keepLineBreaks/addArgument.kt");
            }

            public void testAllFilesPresentInKeepLineBreaks() throws Exception {
                KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/quickfix/deprecatedSymbolUsage/keepLineBreaks"), Pattern.compile("^([\\w\\-_]+)\\.kt$"), TargetBackend.ANY, true);
            }

            @TestMetadata("lineBreakAfterReceiverRuntime.kt")
            public void testLineBreakAfterReceiverRuntime() throws Exception {
                runTest("idea/testData/quickfix/deprecatedSymbolUsage/keepLineBreaks/lineBreakAfterReceiverRuntime.kt");
            }

            @TestMetadata("simple.kt")
            public void testSimple() throws Exception {
                runTest("idea/testData/quickfix/deprecatedSymbolUsage/keepLineBreaks/simple.kt");
            }
        }

        @TestMetadata("idea/testData/quickfix/deprecatedSymbolUsage/operatorCalls")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class OperatorCalls extends AbstractQuickFixTest {
            private void runTest(String testDataFilePath) throws Exception {
                KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
            }

            public void testAllFilesPresentInOperatorCalls() throws Exception {
                KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/quickfix/deprecatedSymbolUsage/operatorCalls"), Pattern.compile("^([\\w\\-_]+)\\.kt$"), TargetBackend.ANY, true);
            }

            @TestMetadata("in.kt")
            public void testIn() throws Exception {
                runTest("idea/testData/quickfix/deprecatedSymbolUsage/operatorCalls/in.kt");
            }

            @TestMetadata("plusAssign.kt")
            public void testPlusAssign() throws Exception {
                runTest("idea/testData/quickfix/deprecatedSymbolUsage/operatorCalls/plusAssign.kt");
            }
        }

        @TestMetadata("idea/testData/quickfix/deprecatedSymbolUsage/optionalParameters")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class OptionalParameters extends AbstractQuickFixTest {
            private void runTest(String testDataFilePath) throws Exception {
                KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
            }

            public void testAllFilesPresentInOptionalParameters() throws Exception {
                KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/quickfix/deprecatedSymbolUsage/optionalParameters"), Pattern.compile("^([\\w\\-_]+)\\.kt$"), TargetBackend.ANY, true);
            }

            @TestMetadata("dropAll.kt")
            public void testDropAll() throws Exception {
                runTest("idea/testData/quickfix/deprecatedSymbolUsage/optionalParameters/dropAll.kt");
            }

            @TestMetadata("functionalLiteralArgument.kt")
            public void testFunctionalLiteralArgument() throws Exception {
                runTest("idea/testData/quickfix/deprecatedSymbolUsage/optionalParameters/functionalLiteralArgument.kt");
            }

            @TestMetadata("namedArgument.kt")
            public void testNamedArgument() throws Exception {
                runTest("idea/testData/quickfix/deprecatedSymbolUsage/optionalParameters/namedArgument.kt");
            }

            @TestMetadata("optionalParameterAndLambda.kt")
            public void testOptionalParameterAndLambda() throws Exception {
                runTest("idea/testData/quickfix/deprecatedSymbolUsage/optionalParameters/optionalParameterAndLambda.kt");
            }

            @TestMetadata("optionalParameterAndLambdaComplex.kt")
            public void testOptionalParameterAndLambdaComplex() throws Exception {
                runTest("idea/testData/quickfix/deprecatedSymbolUsage/optionalParameters/optionalParameterAndLambdaComplex.kt");
            }

            @TestMetadata("optionalParameters1.kt")
            public void testOptionalParameters1() throws Exception {
                runTest("idea/testData/quickfix/deprecatedSymbolUsage/optionalParameters/optionalParameters1.kt");
            }

            @TestMetadata("optionalParameters2.kt")
            public void testOptionalParameters2() throws Exception {
                runTest("idea/testData/quickfix/deprecatedSymbolUsage/optionalParameters/optionalParameters2.kt");
            }

            @TestMetadata("optionalParameters3.kt")
            public void testOptionalParameters3() throws Exception {
                runTest("idea/testData/quickfix/deprecatedSymbolUsage/optionalParameters/optionalParameters3.kt");
            }

            @TestMetadata("optionalParameters4.kt")
            public void testOptionalParameters4() throws Exception {
                runTest("idea/testData/quickfix/deprecatedSymbolUsage/optionalParameters/optionalParameters4.kt");
            }

            @TestMetadata("optionalParameters5.kt")
            public void testOptionalParameters5() throws Exception {
                runTest("idea/testData/quickfix/deprecatedSymbolUsage/optionalParameters/optionalParameters5.kt");
            }

            @TestMetadata("optionalParameters7.kt")
            public void testOptionalParameters7() throws Exception {
                runTest("idea/testData/quickfix/deprecatedSymbolUsage/optionalParameters/optionalParameters7.kt");
            }

            @TestMetadata("optionalParameters9.kt")
            public void testOptionalParameters9() throws Exception {
                runTest("idea/testData/quickfix/deprecatedSymbolUsage/optionalParameters/optionalParameters9.kt");
            }

            @TestMetadata("overridingMethod.kt")
            public void testOverridingMethod() throws Exception {
                runTest("idea/testData/quickfix/deprecatedSymbolUsage/optionalParameters/overridingMethod.kt");
            }
        }

        @TestMetadata("idea/testData/quickfix/deprecatedSymbolUsage/properties")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class Properties extends AbstractQuickFixTest {
            private void runTest(String testDataFilePath) throws Exception {
                KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
            }

            public void testAllFilesPresentInProperties() throws Exception {
                KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/quickfix/deprecatedSymbolUsage/properties"), Pattern.compile("^([\\w\\-_]+)\\.kt$"), TargetBackend.ANY, true);
            }

            @TestMetadata("callInAssignmentToProperty.kt")
            public void testCallInAssignmentToProperty() throws Exception {
                runTest("idea/testData/quickfix/deprecatedSymbolUsage/properties/callInAssignmentToProperty.kt");
            }

            @TestMetadata("callToCustomProperty.kt")
            public void testCallToCustomProperty() throws Exception {
                runTest("idea/testData/quickfix/deprecatedSymbolUsage/properties/callToCustomProperty.kt");
            }

            @TestMetadata("callToProperty.kt")
            public void testCallToProperty() throws Exception {
                runTest("idea/testData/quickfix/deprecatedSymbolUsage/properties/callToProperty.kt");
            }

            @TestMetadata("extensionPropertyToProperty.kt")
            public void testExtensionPropertyToProperty() throws Exception {
                runTest("idea/testData/quickfix/deprecatedSymbolUsage/properties/extensionPropertyToProperty.kt");
            }

            @TestMetadata("extensionPropertyWriteToProperty.kt")
            public void testExtensionPropertyWriteToProperty() throws Exception {
                runTest("idea/testData/quickfix/deprecatedSymbolUsage/properties/extensionPropertyWriteToProperty.kt");
            }
        }

        @TestMetadata("idea/testData/quickfix/deprecatedSymbolUsage/publishedApi")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class PublishedApi extends AbstractQuickFixTest {
            private void runTest(String testDataFilePath) throws Exception {
                KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
            }

            public void testAllFilesPresentInPublishedApi() throws Exception {
                KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/quickfix/deprecatedSymbolUsage/publishedApi"), Pattern.compile("^([\\w\\-_]+)\\.kt$"), TargetBackend.ANY, true);
            }

            @TestMetadata("existingStub.kt")
            public void testExistingStub() throws Exception {
                runTest("idea/testData/quickfix/deprecatedSymbolUsage/publishedApi/existingStub.kt");
            }

            @TestMetadata("existingStubForVar.kt")
            public void testExistingStubForVar() throws Exception {
                runTest("idea/testData/quickfix/deprecatedSymbolUsage/publishedApi/existingStubForVar.kt");
            }

            @TestMetadata("extension.kt")
            public void testExtension() throws Exception {
                runTest("idea/testData/quickfix/deprecatedSymbolUsage/publishedApi/extension.kt");
            }

            @TestMetadata("extensionVar.kt")
            public void testExtensionVar() throws Exception {
                runTest("idea/testData/quickfix/deprecatedSymbolUsage/publishedApi/extensionVar.kt");
            }

            @TestMetadata("generic.kt")
            public void testGeneric() throws Exception {
                runTest("idea/testData/quickfix/deprecatedSymbolUsage/publishedApi/generic.kt");
            }

            @TestMetadata("genericDerived.kt")
            public void testGenericDerived() throws Exception {
                runTest("idea/testData/quickfix/deprecatedSymbolUsage/publishedApi/genericDerived.kt");
            }

            @TestMetadata("genericFunction.kt")
            public void testGenericFunction() throws Exception {
                runTest("idea/testData/quickfix/deprecatedSymbolUsage/publishedApi/genericFunction.kt");
            }

            @TestMetadata("simple.kt")
            public void testSimple() throws Exception {
                runTest("idea/testData/quickfix/deprecatedSymbolUsage/publishedApi/simple.kt");
            }

            @TestMetadata("simpleVal.kt")
            public void testSimpleVal() throws Exception {
                runTest("idea/testData/quickfix/deprecatedSymbolUsage/publishedApi/simpleVal.kt");
            }

            @TestMetadata("simpleVar.kt")
            public void testSimpleVar() throws Exception {
                runTest("idea/testData/quickfix/deprecatedSymbolUsage/publishedApi/simpleVar.kt");
            }
        }

        @TestMetadata("idea/testData/quickfix/deprecatedSymbolUsage/safeCall")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class SafeCall extends AbstractQuickFixTest {
            private void runTest(String testDataFilePath) throws Exception {
                KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
            }

            public void testAllFilesPresentInSafeCall() throws Exception {
                KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/quickfix/deprecatedSymbolUsage/safeCall"), Pattern.compile("^([\\w\\-_]+)\\.kt$"), TargetBackend.ANY, true);
            }

            @TestMetadata("changeThisSafeCall.kt")
            public void testChangeThisSafeCall() throws Exception {
                runTest("idea/testData/quickfix/deprecatedSymbolUsage/safeCall/changeThisSafeCall.kt");
            }

            @TestMetadata("changeThisSafeCallWithValue1Runtime.kt")
            public void testChangeThisSafeCallWithValue1Runtime() throws Exception {
                runTest("idea/testData/quickfix/deprecatedSymbolUsage/safeCall/changeThisSafeCallWithValue1Runtime.kt");
            }

            @TestMetadata("changeThisSafeCallWithValue2Runtime.kt")
            public void testChangeThisSafeCallWithValue2Runtime() throws Exception {
                runTest("idea/testData/quickfix/deprecatedSymbolUsage/safeCall/changeThisSafeCallWithValue2Runtime.kt");
            }

            @TestMetadata("changeThisSafeCallWithValue3Runtime.kt")
            public void testChangeThisSafeCallWithValue3Runtime() throws Exception {
                runTest("idea/testData/quickfix/deprecatedSymbolUsage/safeCall/changeThisSafeCallWithValue3Runtime.kt");
            }

            @TestMetadata("changeThisSafeCallWithValue4Runtime.kt")
            public void testChangeThisSafeCallWithValue4Runtime() throws Exception {
                runTest("idea/testData/quickfix/deprecatedSymbolUsage/safeCall/changeThisSafeCallWithValue4Runtime.kt");
            }

            @TestMetadata("changeThisSafeCallWithValueRuntime.kt")
            public void testChangeThisSafeCallWithValueRuntime() throws Exception {
                runTest("idea/testData/quickfix/deprecatedSymbolUsage/safeCall/changeThisSafeCallWithValueRuntime.kt");
            }

            @TestMetadata("dropReceiverSafeCall.kt")
            public void testDropReceiverSafeCall() throws Exception {
                runTest("idea/testData/quickfix/deprecatedSymbolUsage/safeCall/dropReceiverSafeCall.kt");
            }

            @TestMetadata("safeCall.kt")
            public void testSafeCall() throws Exception {
                runTest("idea/testData/quickfix/deprecatedSymbolUsage/safeCall/safeCall.kt");
            }
        }

        @TestMetadata("idea/testData/quickfix/deprecatedSymbolUsage/typeAliases")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class TypeAliases extends AbstractQuickFixTest {
            private void runTest(String testDataFilePath) throws Exception {
                KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
            }

            public void testAllFilesPresentInTypeAliases() throws Exception {
                KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/quickfix/deprecatedSymbolUsage/typeAliases"), Pattern.compile("^([\\w\\-_]+)\\.kt$"), TargetBackend.ANY, true);
            }

            @TestMetadata("compoundWithDeprecatedArgumentsAndConstructor.kt")
            public void testCompoundWithDeprecatedArgumentsAndConstructor() throws Exception {
                runTest("idea/testData/quickfix/deprecatedSymbolUsage/typeAliases/compoundWithDeprecatedArgumentsAndConstructor.kt");
            }

            @TestMetadata("conflictOnTypeAndAlias.kt")
            public void testConflictOnTypeAndAlias() throws Exception {
                runTest("idea/testData/quickfix/deprecatedSymbolUsage/typeAliases/conflictOnTypeAndAlias.kt");
            }

            @TestMetadata("constructorUsage.kt")
            public void testConstructorUsage() throws Exception {
                runTest("idea/testData/quickfix/deprecatedSymbolUsage/typeAliases/constructorUsage.kt");
            }

            @TestMetadata("constructorUsageWithConflict.kt")
            public void testConstructorUsageWithConflict() throws Exception {
                runTest("idea/testData/quickfix/deprecatedSymbolUsage/typeAliases/constructorUsageWithConflict.kt");
            }

            @TestMetadata("constructorUsageWithConflict1.kt")
            public void testConstructorUsageWithConflict1() throws Exception {
                runTest("idea/testData/quickfix/deprecatedSymbolUsage/typeAliases/constructorUsageWithConflict1.kt");
            }

            @TestMetadata("objectAliased.kt")
            public void testObjectAliased() throws Exception {
                runTest("idea/testData/quickfix/deprecatedSymbolUsage/typeAliases/objectAliased.kt");
            }

            @TestMetadata("onlyAliasDeprecated.kt")
            public void testOnlyAliasDeprecated() throws Exception {
                runTest("idea/testData/quickfix/deprecatedSymbolUsage/typeAliases/onlyAliasDeprecated.kt");
            }

            @TestMetadata("transitiveFromClass.kt")
            public void testTransitiveFromClass() throws Exception {
                runTest("idea/testData/quickfix/deprecatedSymbolUsage/typeAliases/transitiveFromClass.kt");
            }

            @TestMetadata("transitiveLong.kt")
            public void testTransitiveLong() throws Exception {
                runTest("idea/testData/quickfix/deprecatedSymbolUsage/typeAliases/transitiveLong.kt");
            }

            @TestMetadata("typeAliasWithAllGenericParams.kt")
            public void testTypeAliasWithAllGenericParams() throws Exception {
                runTest("idea/testData/quickfix/deprecatedSymbolUsage/typeAliases/typeAliasWithAllGenericParams.kt");
            }

            @TestMetadata("idea/testData/quickfix/deprecatedSymbolUsage/typeAliases/wholeProject")
            @TestDataPath("$PROJECT_ROOT")
            @RunWith(JUnit3RunnerWithInners.class)
            public static class WholeProject extends AbstractQuickFixTest {
                private void runTest(String testDataFilePath) throws Exception {
                    KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
                }

                public void testAllFilesPresentInWholeProject() throws Exception {
                    KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/quickfix/deprecatedSymbolUsage/typeAliases/wholeProject"), Pattern.compile("^([\\w\\-_]+)\\.kt$"), TargetBackend.ANY, true);
                }
            }
        }

        @TestMetadata("idea/testData/quickfix/deprecatedSymbolUsage/typeArguments")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class TypeArguments extends AbstractQuickFixTest {
            private void runTest(String testDataFilePath) throws Exception {
                KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
            }

            public void testAllFilesPresentInTypeArguments() throws Exception {
                KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/quickfix/deprecatedSymbolUsage/typeArguments"), Pattern.compile("^([\\w\\-_]+)\\.kt$"), TargetBackend.ANY, true);
            }

            @TestMetadata("emptyVarargRuntime.kt")
            public void testEmptyVarargRuntime() throws Exception {
                runTest("idea/testData/quickfix/deprecatedSymbolUsage/typeArguments/emptyVarargRuntime.kt");
            }

            @TestMetadata("explicitInPatternImplicitInUsage.kt")
            public void testExplicitInPatternImplicitInUsage() throws Exception {
                runTest("idea/testData/quickfix/deprecatedSymbolUsage/typeArguments/explicitInPatternImplicitInUsage.kt");
            }

            @TestMetadata("explicitTypeArg.kt")
            public void testExplicitTypeArg() throws Exception {
                runTest("idea/testData/quickfix/deprecatedSymbolUsage/typeArguments/explicitTypeArg.kt");
            }

            @TestMetadata("keepInUserCodeRuntime.kt")
            public void testKeepInUserCodeRuntime() throws Exception {
                runTest("idea/testData/quickfix/deprecatedSymbolUsage/typeArguments/keepInUserCodeRuntime.kt");
            }

            @TestMetadata("keepOriginalIfQualified.kt")
            public void testKeepOriginalIfQualified() throws Exception {
                runTest("idea/testData/quickfix/deprecatedSymbolUsage/typeArguments/keepOriginalIfQualified.kt");
            }

            @TestMetadata("noImplicitTypeArgImportRuntime.kt")
            public void testNoImplicitTypeArgImportRuntime() throws Exception {
                runTest("idea/testData/quickfix/deprecatedSymbolUsage/typeArguments/noImplicitTypeArgImportRuntime.kt");
            }

            @TestMetadata("nonEmptyVarargRuntime.kt")
            public void testNonEmptyVarargRuntime() throws Exception {
                runTest("idea/testData/quickfix/deprecatedSymbolUsage/typeArguments/nonEmptyVarargRuntime.kt");
            }
        }

        @TestMetadata("idea/testData/quickfix/deprecatedSymbolUsage/vararg")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class Vararg extends AbstractQuickFixTest {
            private void runTest(String testDataFilePath) throws Exception {
                KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
            }

            @TestMetadata("addedNamedArgumentAfterRuntime.kt")
            public void testAddedNamedArgumentAfterRuntime() throws Exception {
                runTest("idea/testData/quickfix/deprecatedSymbolUsage/vararg/addedNamedArgumentAfterRuntime.kt");
            }

            @TestMetadata("addedPositionalArgumentAfterRuntime.kt")
            public void testAddedPositionalArgumentAfterRuntime() throws Exception {
                runTest("idea/testData/quickfix/deprecatedSymbolUsage/vararg/addedPositionalArgumentAfterRuntime.kt");
            }

            @TestMetadata("addedSpreadArgumentAfterRuntime.kt")
            public void testAddedSpreadArgumentAfterRuntime() throws Exception {
                runTest("idea/testData/quickfix/deprecatedSymbolUsage/vararg/addedSpreadArgumentAfterRuntime.kt");
            }

            public void testAllFilesPresentInVararg() throws Exception {
                KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/quickfix/deprecatedSymbolUsage/vararg"), Pattern.compile("^([\\w\\-_]+)\\.kt$"), TargetBackend.ANY, true);
            }

            @TestMetadata("booleanArrayRuntime.kt")
            public void testBooleanArrayRuntime() throws Exception {
                runTest("idea/testData/quickfix/deprecatedSymbolUsage/vararg/booleanArrayRuntime.kt");
            }

            @TestMetadata("byteArrayRuntime.kt")
            public void testByteArrayRuntime() throws Exception {
                runTest("idea/testData/quickfix/deprecatedSymbolUsage/vararg/byteArrayRuntime.kt");
            }

            @TestMetadata("doNotShortenUserReferences2Runtime.kt")
            public void testDoNotShortenUserReferences2Runtime() throws Exception {
                runTest("idea/testData/quickfix/deprecatedSymbolUsage/vararg/doNotShortenUserReferences2Runtime.kt");
            }

            @TestMetadata("doNotShortenUserReferencesRuntime.kt")
            public void testDoNotShortenUserReferencesRuntime() throws Exception {
                runTest("idea/testData/quickfix/deprecatedSymbolUsage/vararg/doNotShortenUserReferencesRuntime.kt");
            }

            @TestMetadata("doNotSimplifyOriginalCallRuntime.kt")
            public void testDoNotSimplifyOriginalCallRuntime() throws Exception {
                runTest("idea/testData/quickfix/deprecatedSymbolUsage/vararg/doNotSimplifyOriginalCallRuntime.kt");
            }

            @TestMetadata("doubleArrayRuntime.kt")
            public void testDoubleArrayRuntime() throws Exception {
                runTest("idea/testData/quickfix/deprecatedSymbolUsage/vararg/doubleArrayRuntime.kt");
            }

            @TestMetadata("floatArrayRuntime.kt")
            public void testFloatArrayRuntime() throws Exception {
                runTest("idea/testData/quickfix/deprecatedSymbolUsage/vararg/floatArrayRuntime.kt");
            }

            @TestMetadata("longArrayRuntime.kt")
            public void testLongArrayRuntime() throws Exception {
                runTest("idea/testData/quickfix/deprecatedSymbolUsage/vararg/longArrayRuntime.kt");
            }

            @TestMetadata("multipleSpreadArguments2Runtime.kt")
            public void testMultipleSpreadArguments2Runtime() throws Exception {
                runTest("idea/testData/quickfix/deprecatedSymbolUsage/vararg/multipleSpreadArguments2Runtime.kt");
            }

            @TestMetadata("multipleSpreadArgumentsRuntime.kt")
            public void testMultipleSpreadArgumentsRuntime() throws Exception {
                runTest("idea/testData/quickfix/deprecatedSymbolUsage/vararg/multipleSpreadArgumentsRuntime.kt");
            }

            @TestMetadata("noImportRuntime.kt")
            public void testNoImportRuntime() throws Exception {
                runTest("idea/testData/quickfix/deprecatedSymbolUsage/vararg/noImportRuntime.kt");
            }

            @TestMetadata("shortArrayRuntime.kt")
            public void testShortArrayRuntime() throws Exception {
                runTest("idea/testData/quickfix/deprecatedSymbolUsage/vararg/shortArrayRuntime.kt");
            }

            @TestMetadata("vararg1Runtime.kt")
            public void testVararg1Runtime() throws Exception {
                runTest("idea/testData/quickfix/deprecatedSymbolUsage/vararg/vararg1Runtime.kt");
            }

            @TestMetadata("vararg2Runtime.kt")
            public void testVararg2Runtime() throws Exception {
                runTest("idea/testData/quickfix/deprecatedSymbolUsage/vararg/vararg2Runtime.kt");
            }

            @TestMetadata("vararg3Runtime.kt")
            public void testVararg3Runtime() throws Exception {
                runTest("idea/testData/quickfix/deprecatedSymbolUsage/vararg/vararg3Runtime.kt");
            }

            @TestMetadata("vararg4.kt")
            public void testVararg4() throws Exception {
                runTest("idea/testData/quickfix/deprecatedSymbolUsage/vararg/vararg4.kt");
            }

            @TestMetadata("vararg5.kt")
            public void testVararg5() throws Exception {
                runTest("idea/testData/quickfix/deprecatedSymbolUsage/vararg/vararg5.kt");
            }

            @TestMetadata("vararg6Runtime.kt")
            public void testVararg6Runtime() throws Exception {
                runTest("idea/testData/quickfix/deprecatedSymbolUsage/vararg/vararg6Runtime.kt");
            }

            @TestMetadata("vararg7.kt")
            public void testVararg7() throws Exception {
                runTest("idea/testData/quickfix/deprecatedSymbolUsage/vararg/vararg7.kt");
            }

            @TestMetadata("vararg8Runtime.kt")
            public void testVararg8Runtime() throws Exception {
                runTest("idea/testData/quickfix/deprecatedSymbolUsage/vararg/vararg8Runtime.kt");
            }
        }

        @TestMetadata("idea/testData/quickfix/deprecatedSymbolUsage/wholeProject")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class WholeProject extends AbstractQuickFixTest {
            private void runTest(String testDataFilePath) throws Exception {
                KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
            }

            public void testAllFilesPresentInWholeProject() throws Exception {
                KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/quickfix/deprecatedSymbolUsage/wholeProject"), Pattern.compile("^([\\w\\-_]+)\\.kt$"), TargetBackend.ANY, true);
            }
        }
    }

    @TestMetadata("idea/testData/quickfix/experimental")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class Experimental extends AbstractQuickFixTest {
        private void runTest(String testDataFilePath) throws Exception {
            KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
        }

        public void testAllFilesPresentInExperimental() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/quickfix/experimental"), Pattern.compile("^([\\w\\-_]+)\\.kt$"), TargetBackend.ANY, true);
        }

        @TestMetadata("annotationInTopLevelProperty.kt")
        public void testAnnotationInTopLevelProperty() throws Exception {
            runTest("idea/testData/quickfix/experimental/annotationInTopLevelProperty.kt");
        }

        @TestMetadata("basicFunction.kt")
        public void testBasicFunction() throws Exception {
            runTest("idea/testData/quickfix/experimental/basicFunction.kt");
        }

        @TestMetadata("basicFunctionContainingClass.kt")
        public void testBasicFunctionContainingClass() throws Exception {
            runTest("idea/testData/quickfix/experimental/basicFunctionContainingClass.kt");
        }

        @TestMetadata("basicFunctionNotApplicable.kt")
        public void testBasicFunctionNotApplicable() throws Exception {
            runTest("idea/testData/quickfix/experimental/basicFunctionNotApplicable.kt");
        }

        @TestMetadata("basicModule.kt")
        public void testBasicModule() throws Exception {
            runTest("idea/testData/quickfix/experimental/basicModule.kt");
        }

        @TestMetadata("basicUseExperimental.kt")
        public void testBasicUseExperimental() throws Exception {
            runTest("idea/testData/quickfix/experimental/basicUseExperimental.kt");
        }

        @TestMetadata("classUseExperimental.kt")
        public void testClassUseExperimental() throws Exception {
            runTest("idea/testData/quickfix/experimental/classUseExperimental.kt");
        }

        @TestMetadata("doNotSwitchOn.kt")
        public void testDoNotSwitchOn() throws Exception {
            runTest("idea/testData/quickfix/experimental/doNotSwitchOn.kt");
        }

        @TestMetadata("experimentalUnused.kt")
        public void testExperimentalUnused() throws Exception {
            runTest("idea/testData/quickfix/experimental/experimentalUnused.kt");
        }

        @TestMetadata("experimentalUnused2.kt")
        public void testExperimentalUnused2() throws Exception {
            runTest("idea/testData/quickfix/experimental/experimentalUnused2.kt");
        }

        @TestMetadata("functionInLocalClass.kt")
        public void testFunctionInLocalClass() throws Exception {
            runTest("idea/testData/quickfix/experimental/functionInLocalClass.kt");
        }

        @TestMetadata("localFunction.kt")
        public void testLocalFunction() throws Exception {
            runTest("idea/testData/quickfix/experimental/localFunction.kt");
        }

        @TestMetadata("nestedClasses.kt")
        public void testNestedClasses() throws Exception {
            runTest("idea/testData/quickfix/experimental/nestedClasses.kt");
        }

        @TestMetadata("override.kt")
        public void testOverride() throws Exception {
            runTest("idea/testData/quickfix/experimental/override.kt");
        }

        @TestMetadata("propertyInConstructor.kt")
        public void testPropertyInConstructor() throws Exception {
            runTest("idea/testData/quickfix/experimental/propertyInConstructor.kt");
        }

        @TestMetadata("switchOn.kt")
        public void testSwitchOn() throws Exception {
            runTest("idea/testData/quickfix/experimental/switchOn.kt");
        }

        @TestMetadata("typeAlias.kt")
        public void testTypeAlias() throws Exception {
            runTest("idea/testData/quickfix/experimental/typeAlias.kt");
        }

        @TestMetadata("typeInTopLevelProperty.kt")
        public void testTypeInTopLevelProperty() throws Exception {
            runTest("idea/testData/quickfix/experimental/typeInTopLevelProperty.kt");
        }
    }

    @TestMetadata("idea/testData/quickfix/expressions")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class Expressions extends AbstractQuickFixTest {
        private void runTest(String testDataFilePath) throws Exception {
            KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
        }

        public void testAllFilesPresentInExpressions() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/quickfix/expressions"), Pattern.compile("^([\\w\\-_]+)\\.kt$"), TargetBackend.ANY, true);
        }

        @TestMetadata("fixNullableBinaryWithExclExcl.kt")
        public void testFixNullableBinaryWithExclExcl() throws Exception {
            runTest("idea/testData/quickfix/expressions/fixNullableBinaryWithExclExcl.kt");
        }

        @TestMetadata("fixNullableInfixWithExclExcl.kt")
        public void testFixNullableInfixWithExclExcl() throws Exception {
            runTest("idea/testData/quickfix/expressions/fixNullableInfixWithExclExcl.kt");
        }

        @TestMetadata("fixNullableIterableGenericWithExclExcl.kt")
        public void testFixNullableIterableGenericWithExclExcl() throws Exception {
            runTest("idea/testData/quickfix/expressions/fixNullableIterableGenericWithExclExcl.kt");
        }

        @TestMetadata("fixNullableIterableWithExclExcl.kt")
        public void testFixNullableIterableWithExclExcl() throws Exception {
            runTest("idea/testData/quickfix/expressions/fixNullableIterableWithExclExcl.kt");
        }

        @TestMetadata("fixNullableUnaryWithExclExcl.kt")
        public void testFixNullableUnaryWithExclExcl() throws Exception {
            runTest("idea/testData/quickfix/expressions/fixNullableUnaryWithExclExcl.kt");
        }

        @TestMetadata("fixNullableWithExclExclAbsentWithBadIterator.kt")
        public void testFixNullableWithExclExclAbsentWithBadIterator() throws Exception {
            runTest("idea/testData/quickfix/expressions/fixNullableWithExclExclAbsentWithBadIterator.kt");
        }

        @TestMetadata("fixNullableWithIteratorWithExclExcl.kt")
        public void testFixNullableWithIteratorWithExclExcl() throws Exception {
            runTest("idea/testData/quickfix/expressions/fixNullableWithIteratorWithExclExcl.kt");
        }

        @TestMetadata("kt11594.kt")
        public void testKt11594() throws Exception {
            runTest("idea/testData/quickfix/expressions/kt11594.kt");
        }

        @TestMetadata("removeUselessCast.kt")
        public void testRemoveUselessCast() throws Exception {
            runTest("idea/testData/quickfix/expressions/removeUselessCast.kt");
        }

        @TestMetadata("removeUselessCastForLambdaInParens1.kt")
        public void testRemoveUselessCastForLambdaInParens1() throws Exception {
            runTest("idea/testData/quickfix/expressions/removeUselessCastForLambdaInParens1.kt");
        }

        @TestMetadata("removeUselessCastForLambdaInParens2.kt")
        public void testRemoveUselessCastForLambdaInParens2() throws Exception {
            runTest("idea/testData/quickfix/expressions/removeUselessCastForLambdaInParens2.kt");
        }

        @TestMetadata("removeUselessCastForLambdaInParens3.kt")
        public void testRemoveUselessCastForLambdaInParens3() throws Exception {
            runTest("idea/testData/quickfix/expressions/removeUselessCastForLambdaInParens3.kt");
        }

        @TestMetadata("removeUselessCastForLambdaInParens4.kt")
        public void testRemoveUselessCastForLambdaInParens4() throws Exception {
            runTest("idea/testData/quickfix/expressions/removeUselessCastForLambdaInParens4.kt");
        }

        @TestMetadata("removeUselessCastForLambdaInParens5.kt")
        public void testRemoveUselessCastForLambdaInParens5() throws Exception {
            runTest("idea/testData/quickfix/expressions/removeUselessCastForLambdaInParens5.kt");
        }

        @TestMetadata("removeUselessCastForLambdaInParens6.kt")
        public void testRemoveUselessCastForLambdaInParens6() throws Exception {
            runTest("idea/testData/quickfix/expressions/removeUselessCastForLambdaInParens6.kt");
        }

        @TestMetadata("removeUselessCastInParens.kt")
        public void testRemoveUselessCastInParens() throws Exception {
            runTest("idea/testData/quickfix/expressions/removeUselessCastInParens.kt");
        }

        @TestMetadata("removeUselessCastUnderSmartCast.kt")
        public void testRemoveUselessCastUnderSmartCast() throws Exception {
            runTest("idea/testData/quickfix/expressions/removeUselessCastUnderSmartCast.kt");
        }

        @TestMetadata("removeUselessIsCheck.kt")
        public void testRemoveUselessIsCheck() throws Exception {
            runTest("idea/testData/quickfix/expressions/removeUselessIsCheck.kt");
        }

        @TestMetadata("removeUselessIsCheckInWhen.kt")
        public void testRemoveUselessIsCheckInWhen() throws Exception {
            runTest("idea/testData/quickfix/expressions/removeUselessIsCheckInWhen.kt");
        }

        @TestMetadata("removeUselessIsCheckInWhenExpressionless.kt")
        public void testRemoveUselessIsCheckInWhenExpressionless() throws Exception {
            runTest("idea/testData/quickfix/expressions/removeUselessIsCheckInWhenExpressionless.kt");
        }

        @TestMetadata("removeUselessIsCheckInWhenExpressionlessNegate.kt")
        public void testRemoveUselessIsCheckInWhenExpressionlessNegate() throws Exception {
            runTest("idea/testData/quickfix/expressions/removeUselessIsCheckInWhenExpressionlessNegate.kt");
        }

        @TestMetadata("removeUselessIsCheckInWhenNegate.kt")
        public void testRemoveUselessIsCheckInWhenNegate() throws Exception {
            runTest("idea/testData/quickfix/expressions/removeUselessIsCheckInWhenNegate.kt");
        }

        @TestMetadata("removeUselessIsCheckNegate.kt")
        public void testRemoveUselessIsCheckNegate() throws Exception {
            runTest("idea/testData/quickfix/expressions/removeUselessIsCheckNegate.kt");
        }

        @TestMetadata("unnecessaryNonNullAssertion1.kt")
        public void testUnnecessaryNonNullAssertion1() throws Exception {
            runTest("idea/testData/quickfix/expressions/unnecessaryNonNullAssertion1.kt");
        }

        @TestMetadata("unnecessaryNonNullAssertion2.kt")
        public void testUnnecessaryNonNullAssertion2() throws Exception {
            runTest("idea/testData/quickfix/expressions/unnecessaryNonNullAssertion2.kt");
        }

        @TestMetadata("unnecessaryNonNullAssertion3.kt")
        public void testUnnecessaryNonNullAssertion3() throws Exception {
            runTest("idea/testData/quickfix/expressions/unnecessaryNonNullAssertion3.kt");
        }

        @TestMetadata("unnecessarySafeCall1.kt")
        public void testUnnecessarySafeCall1() throws Exception {
            runTest("idea/testData/quickfix/expressions/unnecessarySafeCall1.kt");
        }

        @TestMetadata("unsafeCall1.kt")
        public void testUnsafeCall1() throws Exception {
            runTest("idea/testData/quickfix/expressions/unsafeCall1.kt");
        }

        @TestMetadata("unsafeCall2.kt")
        public void testUnsafeCall2() throws Exception {
            runTest("idea/testData/quickfix/expressions/unsafeCall2.kt");
        }

        @TestMetadata("unsafeCall3.kt")
        public void testUnsafeCall3() throws Exception {
            runTest("idea/testData/quickfix/expressions/unsafeCall3.kt");
        }

        @TestMetadata("unsafeCall4.kt")
        public void testUnsafeCall4() throws Exception {
            runTest("idea/testData/quickfix/expressions/unsafeCall4.kt");
        }

        @TestMetadata("unsafeCall5.kt")
        public void testUnsafeCall5() throws Exception {
            runTest("idea/testData/quickfix/expressions/unsafeCall5.kt");
        }

        @TestMetadata("uselessCastStaticAssertIsFine.kt")
        public void testUselessCastStaticAssertIsFine() throws Exception {
            runTest("idea/testData/quickfix/expressions/uselessCastStaticAssertIsFine.kt");
        }

        @TestMetadata("uselessElvis.kt")
        public void testUselessElvis() throws Exception {
            runTest("idea/testData/quickfix/expressions/uselessElvis.kt");
        }
    }

    @TestMetadata("idea/testData/quickfix/foldTryCatch")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class FoldTryCatch extends AbstractQuickFixTest {
        private void runTest(String testDataFilePath) throws Exception {
            KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
        }

        public void testAllFilesPresentInFoldTryCatch() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/quickfix/foldTryCatch"), Pattern.compile("^([\\w\\-_]+)\\.kt$"), TargetBackend.ANY, true);
        }

        @TestMetadata("conditional.kt")
        public void testConditional() throws Exception {
            runTest("idea/testData/quickfix/foldTryCatch/conditional.kt");
        }

        @TestMetadata("emptyFinally.kt")
        public void testEmptyFinally() throws Exception {
            runTest("idea/testData/quickfix/foldTryCatch/emptyFinally.kt");
        }

        @TestMetadata("multipleExceptions.kt")
        public void testMultipleExceptions() throws Exception {
            runTest("idea/testData/quickfix/foldTryCatch/multipleExceptions.kt");
        }

        @TestMetadata("shadow.kt")
        public void testShadow() throws Exception {
            runTest("idea/testData/quickfix/foldTryCatch/shadow.kt");
        }

        @TestMetadata("simple.kt")
        public void testSimple() throws Exception {
            runTest("idea/testData/quickfix/foldTryCatch/simple.kt");
        }
    }

    @TestMetadata("idea/testData/quickfix/functionWithLambdaExpressionBody")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class FunctionWithLambdaExpressionBody extends AbstractQuickFixTest {
        private void runTest(String testDataFilePath) throws Exception {
            KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
        }

        public void testAllFilesPresentInFunctionWithLambdaExpressionBody() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/quickfix/functionWithLambdaExpressionBody"), Pattern.compile("^([\\w\\-_]+)\\.kt$"), TargetBackend.ANY, true);
        }

        @TestMetadata("idea/testData/quickfix/functionWithLambdaExpressionBody/removeBraces")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class RemoveBraces extends AbstractQuickFixTest {
            private void runTest(String testDataFilePath) throws Exception {
                KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
            }

            public void testAllFilesPresentInRemoveBraces() throws Exception {
                KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/quickfix/functionWithLambdaExpressionBody/removeBraces"), Pattern.compile("^([\\w\\-_]+)\\.kt$"), TargetBackend.ANY, true);
            }

            @TestMetadata("functionHasComment.kt")
            public void testFunctionHasComment() throws Exception {
                runTest("idea/testData/quickfix/functionWithLambdaExpressionBody/removeBraces/functionHasComment.kt");
            }

            @TestMetadata("functionHasMultiStatements.kt")
            public void testFunctionHasMultiStatements() throws Exception {
                runTest("idea/testData/quickfix/functionWithLambdaExpressionBody/removeBraces/functionHasMultiStatements.kt");
            }

            @TestMetadata("functionHasNoStatement.kt")
            public void testFunctionHasNoStatement() throws Exception {
                runTest("idea/testData/quickfix/functionWithLambdaExpressionBody/removeBraces/functionHasNoStatement.kt");
            }

            @TestMetadata("funtionIsUsed.kt")
            public void testFuntionIsUsed() throws Exception {
                runTest("idea/testData/quickfix/functionWithLambdaExpressionBody/removeBraces/funtionIsUsed.kt");
            }

            @TestMetadata("getterHasComment.kt")
            public void testGetterHasComment() throws Exception {
                runTest("idea/testData/quickfix/functionWithLambdaExpressionBody/removeBraces/getterHasComment.kt");
            }

            @TestMetadata("getterHasMultiStatements.kt")
            public void testGetterHasMultiStatements() throws Exception {
                runTest("idea/testData/quickfix/functionWithLambdaExpressionBody/removeBraces/getterHasMultiStatements.kt");
            }

            @TestMetadata("getterHasNoStatement.kt")
            public void testGetterHasNoStatement() throws Exception {
                runTest("idea/testData/quickfix/functionWithLambdaExpressionBody/removeBraces/getterHasNoStatement.kt");
            }

            @TestMetadata("getterIsUsed.kt")
            public void testGetterIsUsed() throws Exception {
                runTest("idea/testData/quickfix/functionWithLambdaExpressionBody/removeBraces/getterIsUsed.kt");
            }
        }

        @TestMetadata("idea/testData/quickfix/functionWithLambdaExpressionBody/wrapRun")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class WrapRun extends AbstractQuickFixTest {
            private void runTest(String testDataFilePath) throws Exception {
                KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
            }

            public void testAllFilesPresentInWrapRun() throws Exception {
                KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/quickfix/functionWithLambdaExpressionBody/wrapRun"), Pattern.compile("^([\\w\\-_]+)\\.kt$"), TargetBackend.ANY, true);
            }

            @TestMetadata("funtionIsUsed.kt")
            public void testFuntionIsUsed() throws Exception {
                runTest("idea/testData/quickfix/functionWithLambdaExpressionBody/wrapRun/funtionIsUsed.kt");
            }

            @TestMetadata("getterIsUsed.kt")
            public void testGetterIsUsed() throws Exception {
                runTest("idea/testData/quickfix/functionWithLambdaExpressionBody/wrapRun/getterIsUsed.kt");
            }
        }
    }

    @TestMetadata("idea/testData/quickfix/implement")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class Implement extends AbstractQuickFixTest {
        private void runTest(String testDataFilePath) throws Exception {
            KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
        }

        @TestMetadata("abstract.kt")
        public void testAbstract() throws Exception {
            runTest("idea/testData/quickfix/implement/abstract.kt");
        }

        public void testAllFilesPresentInImplement() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/quickfix/implement"), Pattern.compile("^([\\w\\-_]+)\\.kt$"), TargetBackend.ANY, true);
        }

        @TestMetadata("annotation.kt")
        public void testAnnotation() throws Exception {
            runTest("idea/testData/quickfix/implement/annotation.kt");
        }

        @TestMetadata("doNotAddExpectForVal.kt")
        public void testDoNotAddExpectForVal() throws Exception {
            runTest("idea/testData/quickfix/implement/doNotAddExpectForVal.kt");
        }

        @TestMetadata("doNotAddHeader.kt")
        public void testDoNotAddHeader() throws Exception {
            runTest("idea/testData/quickfix/implement/doNotAddHeader.kt");
        }

        @TestMetadata("enum.kt")
        public void testEnum() throws Exception {
            runTest("idea/testData/quickfix/implement/enum.kt");
        }

        @TestMetadata("finalClass.kt")
        public void testFinalClass() throws Exception {
            runTest("idea/testData/quickfix/implement/finalClass.kt");
        }

        @TestMetadata("inCompanion.kt")
        public void testInCompanion() throws Exception {
            runTest("idea/testData/quickfix/implement/inCompanion.kt");
        }

        @TestMetadata("inInternalCompanion.kt")
        public void testInInternalCompanion() throws Exception {
            runTest("idea/testData/quickfix/implement/inInternalCompanion.kt");
        }

        @TestMetadata("inPrivateCompanion.kt")
        public void testInPrivateCompanion() throws Exception {
            runTest("idea/testData/quickfix/implement/inPrivateCompanion.kt");
        }

        @TestMetadata("inProtectedCompanion.kt")
        public void testInProtectedCompanion() throws Exception {
            runTest("idea/testData/quickfix/implement/inProtectedCompanion.kt");
        }

        @TestMetadata("incorrectRange.kt")
        public void testIncorrectRange() throws Exception {
            runTest("idea/testData/quickfix/implement/incorrectRange.kt");
        }

        @TestMetadata("inner.kt")
        public void testInner() throws Exception {
            runTest("idea/testData/quickfix/implement/inner.kt");
        }

        @TestMetadata("interface.kt")
        public void testInterface() throws Exception {
            runTest("idea/testData/quickfix/implement/interface.kt");
        }

        @TestMetadata("local.kt")
        public void testLocal() throws Exception {
            runTest("idea/testData/quickfix/implement/local.kt");
        }

        @TestMetadata("nested.kt")
        public void testNested() throws Exception {
            runTest("idea/testData/quickfix/implement/nested.kt");
        }

        @TestMetadata("nestedPrivateInterface.kt")
        public void testNestedPrivateInterface() throws Exception {
            runTest("idea/testData/quickfix/implement/nestedPrivateInterface.kt");
        }

        @TestMetadata("noDefaultConstructor.kt")
        public void testNoDefaultConstructor() throws Exception {
            runTest("idea/testData/quickfix/implement/noDefaultConstructor.kt");
        }

        @TestMetadata("private.kt")
        public void testPrivate() throws Exception {
            runTest("idea/testData/quickfix/implement/private.kt");
        }

        @TestMetadata("privateConstructor.kt")
        public void testPrivateConstructor() throws Exception {
            runTest("idea/testData/quickfix/implement/privateConstructor.kt");
        }

        @TestMetadata("privateNested.kt")
        public void testPrivateNested() throws Exception {
            runTest("idea/testData/quickfix/implement/privateNested.kt");
        }

        @TestMetadata("privateNestedWithConflict.kt")
        public void testPrivateNestedWithConflict() throws Exception {
            runTest("idea/testData/quickfix/implement/privateNestedWithConflict.kt");
        }

        @TestMetadata("protected.kt")
        public void testProtected() throws Exception {
            runTest("idea/testData/quickfix/implement/protected.kt");
        }

        @TestMetadata("sealed.kt")
        public void testSealed() throws Exception {
            runTest("idea/testData/quickfix/implement/sealed.kt");
        }

        @TestMetadata("sealedEmpty.kt")
        public void testSealedEmpty() throws Exception {
            runTest("idea/testData/quickfix/implement/sealedEmpty.kt");
        }

        @TestMetadata("sealedWithConflict.kt")
        public void testSealedWithConflict() throws Exception {
            runTest("idea/testData/quickfix/implement/sealedWithConflict.kt");
        }

        @TestMetadata("typeParameter.kt")
        public void testTypeParameter() throws Exception {
            runTest("idea/testData/quickfix/implement/typeParameter.kt");
        }

        @TestMetadata("typeParameterOut.kt")
        public void testTypeParameterOut() throws Exception {
            runTest("idea/testData/quickfix/implement/typeParameterOut.kt");
        }

        @TestMetadata("typeParameterWhere.kt")
        public void testTypeParameterWhere() throws Exception {
            runTest("idea/testData/quickfix/implement/typeParameterWhere.kt");
        }

        @TestMetadata("typeParametersClass.kt")
        public void testTypeParametersClass() throws Exception {
            runTest("idea/testData/quickfix/implement/typeParametersClass.kt");
        }
    }

    @TestMetadata("idea/testData/quickfix/increaseVisibility")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class IncreaseVisibility extends AbstractQuickFixTest {
        private void runTest(String testDataFilePath) throws Exception {
            KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
        }

        public void testAllFilesPresentInIncreaseVisibility() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/quickfix/increaseVisibility"), Pattern.compile("^([\\w\\-_]+)\\.kt$"), TargetBackend.ANY, true);
        }

        @TestMetadata("exposedParameterType.kt")
        public void testExposedParameterType() throws Exception {
            runTest("idea/testData/quickfix/increaseVisibility/exposedParameterType.kt");
        }

        @TestMetadata("exposedParameterTypePublic.kt")
        public void testExposedParameterTypePublic() throws Exception {
            runTest("idea/testData/quickfix/increaseVisibility/exposedParameterTypePublic.kt");
        }

        @TestMetadata("exposedPropertyType.kt")
        public void testExposedPropertyType() throws Exception {
            runTest("idea/testData/quickfix/increaseVisibility/exposedPropertyType.kt");
        }

        @TestMetadata("exposedReceiverType.kt")
        public void testExposedReceiverType() throws Exception {
            runTest("idea/testData/quickfix/increaseVisibility/exposedReceiverType.kt");
        }

        @TestMetadata("exposedReturnType.kt")
        public void testExposedReturnType() throws Exception {
            runTest("idea/testData/quickfix/increaseVisibility/exposedReturnType.kt");
        }

        @TestMetadata("exposedSuperClass.kt")
        public void testExposedSuperClass() throws Exception {
            runTest("idea/testData/quickfix/increaseVisibility/exposedSuperClass.kt");
        }

        @TestMetadata("exposedSuperClassProtectedBase.kt")
        public void testExposedSuperClassProtectedBase() throws Exception {
            runTest("idea/testData/quickfix/increaseVisibility/exposedSuperClassProtectedBase.kt");
        }

        @TestMetadata("exposedSuperClassProtectedInAnother.kt")
        public void testExposedSuperClassProtectedInAnother() throws Exception {
            runTest("idea/testData/quickfix/increaseVisibility/exposedSuperClassProtectedInAnother.kt");
        }

        @TestMetadata("exposedSuperClassProtectedInAnotherFromPrivate.kt")
        public void testExposedSuperClassProtectedInAnotherFromPrivate() throws Exception {
            runTest("idea/testData/quickfix/increaseVisibility/exposedSuperClassProtectedInAnotherFromPrivate.kt");
        }

        @TestMetadata("exposedSuperInterface.kt")
        public void testExposedSuperInterface() throws Exception {
            runTest("idea/testData/quickfix/increaseVisibility/exposedSuperInterface.kt");
        }

        @TestMetadata("exposedTypeParameterBound.kt")
        public void testExposedTypeParameterBound() throws Exception {
            runTest("idea/testData/quickfix/increaseVisibility/exposedTypeParameterBound.kt");
        }

        @TestMetadata("invalidSealedClassInheritance.kt")
        public void testInvalidSealedClassInheritance() throws Exception {
            runTest("idea/testData/quickfix/increaseVisibility/invalidSealedClassInheritance.kt");
        }

        @TestMetadata("overriddenProtectedMemberToPublicSingleFile.kt")
        public void testOverriddenProtectedMemberToPublicSingleFile() throws Exception {
            runTest("idea/testData/quickfix/increaseVisibility/overriddenProtectedMemberToPublicSingleFile.kt");
        }

        @TestMetadata("privateMemberToInternalSingleFile.kt")
        public void testPrivateMemberToInternalSingleFile() throws Exception {
            runTest("idea/testData/quickfix/increaseVisibility/privateMemberToInternalSingleFile.kt");
        }

        @TestMetadata("privateMemberToInternalWithExposed.kt")
        public void testPrivateMemberToInternalWithExposed() throws Exception {
            runTest("idea/testData/quickfix/increaseVisibility/privateMemberToInternalWithExposed.kt");
        }

        @TestMetadata("privateMemberToPublicSingleFile.kt")
        public void testPrivateMemberToPublicSingleFile() throws Exception {
            runTest("idea/testData/quickfix/increaseVisibility/privateMemberToPublicSingleFile.kt");
        }

        @TestMetadata("privateSealedClassInheritance.kt")
        public void testPrivateSealedClassInheritance() throws Exception {
            runTest("idea/testData/quickfix/increaseVisibility/privateSealedClassInheritance.kt");
        }

        @TestMetadata("protectedMemberToPublicSingleFile.kt")
        public void testProtectedMemberToPublicSingleFile() throws Exception {
            runTest("idea/testData/quickfix/increaseVisibility/protectedMemberToPublicSingleFile.kt");
        }

        @TestMetadata("idea/testData/quickfix/increaseVisibility/invisibleFake")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class InvisibleFake extends AbstractQuickFixTest {
            private void runTest(String testDataFilePath) throws Exception {
                KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
            }

            public void testAllFilesPresentInInvisibleFake() throws Exception {
                KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/quickfix/increaseVisibility/invisibleFake"), Pattern.compile("^([\\w\\-_]+)\\.kt$"), TargetBackend.ANY, true);
            }

            @TestMetadata("methodToInternal.kt")
            public void testMethodToInternal() throws Exception {
                runTest("idea/testData/quickfix/increaseVisibility/invisibleFake/methodToInternal.kt");
            }

            @TestMetadata("methodToNotProtected.kt")
            public void testMethodToNotProtected() throws Exception {
                runTest("idea/testData/quickfix/increaseVisibility/invisibleFake/methodToNotProtected.kt");
            }

            @TestMetadata("methodToProtected.kt")
            public void testMethodToProtected() throws Exception {
                runTest("idea/testData/quickfix/increaseVisibility/invisibleFake/methodToProtected.kt");
            }

            @TestMetadata("methodToProtected2.kt")
            public void testMethodToProtected2() throws Exception {
                runTest("idea/testData/quickfix/increaseVisibility/invisibleFake/methodToProtected2.kt");
            }

            @TestMetadata("methodToPublic.kt")
            public void testMethodToPublic() throws Exception {
                runTest("idea/testData/quickfix/increaseVisibility/invisibleFake/methodToPublic.kt");
            }

            @TestMetadata("propertyToInternal.kt")
            public void testPropertyToInternal() throws Exception {
                runTest("idea/testData/quickfix/increaseVisibility/invisibleFake/propertyToInternal.kt");
            }

            @TestMetadata("propertyToNotProtected.kt")
            public void testPropertyToNotProtected() throws Exception {
                runTest("idea/testData/quickfix/increaseVisibility/invisibleFake/propertyToNotProtected.kt");
            }

            @TestMetadata("propertyToProtected.kt")
            public void testPropertyToProtected() throws Exception {
                runTest("idea/testData/quickfix/increaseVisibility/invisibleFake/propertyToProtected.kt");
            }

            @TestMetadata("propertyToProtected2.kt")
            public void testPropertyToProtected2() throws Exception {
                runTest("idea/testData/quickfix/increaseVisibility/invisibleFake/propertyToProtected2.kt");
            }

            @TestMetadata("propertyToPublic.kt")
            public void testPropertyToPublic() throws Exception {
                runTest("idea/testData/quickfix/increaseVisibility/invisibleFake/propertyToPublic.kt");
            }
        }
    }

    @TestMetadata("idea/testData/quickfix/initializeWithConstructorParameter")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class InitializeWithConstructorParameter extends AbstractQuickFixTest {
        private void runTest(String testDataFilePath) throws Exception {
            KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
        }

        public void testAllFilesPresentInInitializeWithConstructorParameter() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/quickfix/initializeWithConstructorParameter"), Pattern.compile("^([\\w\\-_]+)\\.kt$"), TargetBackend.ANY, true);
        }

        @TestMetadata("constructorWithThisDelegation.kt")
        public void testConstructorWithThisDelegation() throws Exception {
            runTest("idea/testData/quickfix/initializeWithConstructorParameter/constructorWithThisDelegation.kt");
        }

        @TestMetadata("genericParameterInScope.kt")
        public void testGenericParameterInScope() throws Exception {
            runTest("idea/testData/quickfix/initializeWithConstructorParameter/genericParameterInScope.kt");
        }

        @TestMetadata("localVar.kt")
        public void testLocalVar() throws Exception {
            runTest("idea/testData/quickfix/initializeWithConstructorParameter/localVar.kt");
        }

        @TestMetadata("memberPropertyInClassNameClashInPrimaryConstructor.kt")
        public void testMemberPropertyInClassNameClashInPrimaryConstructor() throws Exception {
            runTest("idea/testData/quickfix/initializeWithConstructorParameter/memberPropertyInClassNameClashInPrimaryConstructor.kt");
        }

        @TestMetadata("memberPropertyInClassNameClashInSecondaryConstructor.kt")
        public void testMemberPropertyInClassNameClashInSecondaryConstructor() throws Exception {
            runTest("idea/testData/quickfix/initializeWithConstructorParameter/memberPropertyInClassNameClashInSecondaryConstructor.kt");
        }

        @TestMetadata("memberPropertyInClassNoConstructors.kt")
        public void testMemberPropertyInClassNoConstructors() throws Exception {
            runTest("idea/testData/quickfix/initializeWithConstructorParameter/memberPropertyInClassNoConstructors.kt");
        }

        @TestMetadata("memberPropertyInClassPrimaryAndSecondaryConstructors.kt")
        public void testMemberPropertyInClassPrimaryAndSecondaryConstructors() throws Exception {
            runTest("idea/testData/quickfix/initializeWithConstructorParameter/memberPropertyInClassPrimaryAndSecondaryConstructors.kt");
        }

        @TestMetadata("memberPropertyInClassPrimaryConstructorOnly.kt")
        public void testMemberPropertyInClassPrimaryConstructorOnly() throws Exception {
            runTest("idea/testData/quickfix/initializeWithConstructorParameter/memberPropertyInClassPrimaryConstructorOnly.kt");
        }

        @TestMetadata("memberPropertyInClassSecondaryConstructorsOnly.kt")
        public void testMemberPropertyInClassSecondaryConstructorsOnly() throws Exception {
            runTest("idea/testData/quickfix/initializeWithConstructorParameter/memberPropertyInClassSecondaryConstructorsOnly.kt");
        }

        @TestMetadata("memberPropertyInInterface.kt")
        public void testMemberPropertyInInterface() throws Exception {
            runTest("idea/testData/quickfix/initializeWithConstructorParameter/memberPropertyInInterface.kt");
        }

        @TestMetadata("memberPropertyInObject.kt")
        public void testMemberPropertyInObject() throws Exception {
            runTest("idea/testData/quickfix/initializeWithConstructorParameter/memberPropertyInObject.kt");
        }

        @TestMetadata("memberPropertyNoAccessorsInClassNoConstructors.kt")
        public void testMemberPropertyNoAccessorsInClassNoConstructors() throws Exception {
            runTest("idea/testData/quickfix/initializeWithConstructorParameter/memberPropertyNoAccessorsInClassNoConstructors.kt");
        }

        @TestMetadata("memberPropertyNoAccessorsInClassPrimaryAndSecondaryConstructors.kt")
        public void testMemberPropertyNoAccessorsInClassPrimaryAndSecondaryConstructors() throws Exception {
            runTest("idea/testData/quickfix/initializeWithConstructorParameter/memberPropertyNoAccessorsInClassPrimaryAndSecondaryConstructors.kt");
        }

        @TestMetadata("memberPropertyNoAccessorsInClassPrimaryConstructorOnly.kt")
        public void testMemberPropertyNoAccessorsInClassPrimaryConstructorOnly() throws Exception {
            runTest("idea/testData/quickfix/initializeWithConstructorParameter/memberPropertyNoAccessorsInClassPrimaryConstructorOnly.kt");
        }

        @TestMetadata("memberPropertyWithDelegateRuntime.kt")
        public void testMemberPropertyWithDelegateRuntime() throws Exception {
            runTest("idea/testData/quickfix/initializeWithConstructorParameter/memberPropertyWithDelegateRuntime.kt");
        }

        @TestMetadata("topLevelProperty.kt")
        public void testTopLevelProperty() throws Exception {
            runTest("idea/testData/quickfix/initializeWithConstructorParameter/topLevelProperty.kt");
        }
    }

    @TestMetadata("idea/testData/quickfix/inlineTypeParameterFix")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class InlineTypeParameterFix extends AbstractQuickFixTest {
        private void runTest(String testDataFilePath) throws Exception {
            KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
        }

        public void testAllFilesPresentInInlineTypeParameterFix() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/quickfix/inlineTypeParameterFix"), Pattern.compile("^([\\w\\-_]+)\\.kt$"), TargetBackend.ANY, true);
        }

        @TestMetadata("basic.kt")
        public void testBasic() throws Exception {
            runTest("idea/testData/quickfix/inlineTypeParameterFix/basic.kt");
        }

        @TestMetadata("basicMultipleDef.kt")
        public void testBasicMultipleDef() throws Exception {
            runTest("idea/testData/quickfix/inlineTypeParameterFix/basicMultipleDef.kt");
        }

        @TestMetadata("function.kt")
        public void testFunction() throws Exception {
            runTest("idea/testData/quickfix/inlineTypeParameterFix/function.kt");
        }
    }

    @TestMetadata("idea/testData/quickfix/insertDelegationCall")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class InsertDelegationCall extends AbstractQuickFixTest {
        private void runTest(String testDataFilePath) throws Exception {
            KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
        }

        public void testAllFilesPresentInInsertDelegationCall() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/quickfix/insertDelegationCall"), Pattern.compile("^([\\w\\-_]+)\\.kt$"), TargetBackend.ANY, true);
        }

        @TestMetadata("nonApplicableInsertSuper.kt")
        public void testNonApplicableInsertSuper() throws Exception {
            runTest("idea/testData/quickfix/insertDelegationCall/nonApplicableInsertSuper.kt");
        }

        @TestMetadata("nonApplicableInsertThis.kt")
        public void testNonApplicableInsertThis() throws Exception {
            runTest("idea/testData/quickfix/insertDelegationCall/nonApplicableInsertThis.kt");
        }

        @TestMetadata("nonApplicableOnEmpty.kt")
        public void testNonApplicableOnEmpty() throws Exception {
            runTest("idea/testData/quickfix/insertDelegationCall/nonApplicableOnEmpty.kt");
        }

        @TestMetadata("nonApplicableWithOneConstructor.kt")
        public void testNonApplicableWithOneConstructor() throws Exception {
            runTest("idea/testData/quickfix/insertDelegationCall/nonApplicableWithOneConstructor.kt");
        }

        @TestMetadata("primaryRequiredNoSuper.kt")
        public void testPrimaryRequiredNoSuper() throws Exception {
            runTest("idea/testData/quickfix/insertDelegationCall/primaryRequiredNoSuper.kt");
        }

        @TestMetadata("primaryRequiredParameterless.kt")
        public void testPrimaryRequiredParameterless() throws Exception {
            runTest("idea/testData/quickfix/insertDelegationCall/primaryRequiredParameterless.kt");
        }

        @TestMetadata("primaryRequiredWithBody.kt")
        public void testPrimaryRequiredWithBody() throws Exception {
            runTest("idea/testData/quickfix/insertDelegationCall/primaryRequiredWithBody.kt");
        }

        @TestMetadata("primaryRequiredWithParameter.kt")
        public void testPrimaryRequiredWithParameter() throws Exception {
            runTest("idea/testData/quickfix/insertDelegationCall/primaryRequiredWithParameter.kt");
        }
    }

    @TestMetadata("idea/testData/quickfix/kdocMissingDocumentation")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class KdocMissingDocumentation extends AbstractQuickFixTest {
        private void runTest(String testDataFilePath) throws Exception {
            KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
        }

        public void testAllFilesPresentInKdocMissingDocumentation() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/quickfix/kdocMissingDocumentation"), Pattern.compile("^([\\w\\-_]+)\\.kt$"), TargetBackend.ANY, true);
        }

        @TestMetadata("simple.kt")
        public void testSimple() throws Exception {
            runTest("idea/testData/quickfix/kdocMissingDocumentation/simple.kt");
        }

        @TestMetadata("withIndentation.kt")
        public void testWithIndentation() throws Exception {
            runTest("idea/testData/quickfix/kdocMissingDocumentation/withIndentation.kt");
        }
    }

    @TestMetadata("idea/testData/quickfix/lateinit")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class Lateinit extends AbstractQuickFixTest {
        private void runTest(String testDataFilePath) throws Exception {
            KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
        }

        public void testAllFilesPresentInLateinit() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/quickfix/lateinit"), Pattern.compile("^([\\w\\-_]+)\\.kt$"), TargetBackend.ANY, true);
        }

        @TestMetadata("nullable.kt")
        public void testNullable() throws Exception {
            runTest("idea/testData/quickfix/lateinit/nullable.kt");
        }

        @TestMetadata("val.kt")
        public void testVal() throws Exception {
            runTest("idea/testData/quickfix/lateinit/val.kt");
        }

        @TestMetadata("withGetter.kt")
        public void testWithGetter() throws Exception {
            runTest("idea/testData/quickfix/lateinit/withGetter.kt");
        }

        @TestMetadata("withGetterSetter.kt")
        public void testWithGetterSetter() throws Exception {
            runTest("idea/testData/quickfix/lateinit/withGetterSetter.kt");
        }

        @TestMetadata("withInitializer.kt")
        public void testWithInitializer() throws Exception {
            runTest("idea/testData/quickfix/lateinit/withInitializer.kt");
        }

        @TestMetadata("withSetter.kt")
        public void testWithSetter() throws Exception {
            runTest("idea/testData/quickfix/lateinit/withSetter.kt");
        }
    }

    @TestMetadata("idea/testData/quickfix/leakingThis")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class LeakingThis extends AbstractQuickFixTest {
        private void runTest(String testDataFilePath) throws Exception {
            KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
        }

        @TestMetadata("accessOpenProperty.kt")
        public void testAccessOpenProperty() throws Exception {
            runTest("idea/testData/quickfix/leakingThis/accessOpenProperty.kt");
        }

        @TestMetadata("accessOpenPropertyClass.kt")
        public void testAccessOpenPropertyClass() throws Exception {
            runTest("idea/testData/quickfix/leakingThis/accessOpenPropertyClass.kt");
        }

        @TestMetadata("accessOverriddenProperty.kt")
        public void testAccessOverriddenProperty() throws Exception {
            runTest("idea/testData/quickfix/leakingThis/accessOverriddenProperty.kt");
        }

        public void testAllFilesPresentInLeakingThis() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/quickfix/leakingThis"), Pattern.compile("^([\\w\\-_]+)\\.kt$"), TargetBackend.ANY, true);
        }

        @TestMetadata("callOpenMethod.kt")
        public void testCallOpenMethod() throws Exception {
            runTest("idea/testData/quickfix/leakingThis/callOpenMethod.kt");
        }

        @TestMetadata("callOpenMethodClass.kt")
        public void testCallOpenMethodClass() throws Exception {
            runTest("idea/testData/quickfix/leakingThis/callOpenMethodClass.kt");
        }

        @TestMetadata("inAbstract.kt")
        public void testInAbstract() throws Exception {
            runTest("idea/testData/quickfix/leakingThis/inAbstract.kt");
        }

        @TestMetadata("inNonFinal.kt")
        public void testInNonFinal() throws Exception {
            runTest("idea/testData/quickfix/leakingThis/inNonFinal.kt");
        }

        @TestMetadata("inOverridden.kt")
        public void testInOverridden() throws Exception {
            runTest("idea/testData/quickfix/leakingThis/inOverridden.kt");
        }
    }

    @TestMetadata("idea/testData/quickfix/libraries")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class Libraries extends AbstractQuickFixTest {
        private void runTest(String testDataFilePath) throws Exception {
            KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
        }

        public void testAllFilesPresentInLibraries() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/quickfix/libraries"), Pattern.compile("^([\\w\\-_]+)\\.kt$"), TargetBackend.ANY, true);
        }

        @TestMetadata("junit.kt")
        public void testJunit() throws Exception {
            runTest("idea/testData/quickfix/libraries/junit.kt");
        }

        @TestMetadata("testNG.kt")
        public void testTestNG() throws Exception {
            runTest("idea/testData/quickfix/libraries/testNG.kt");
        }
    }

    @TestMetadata("idea/testData/quickfix/localVariableWithTypeParameters")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class LocalVariableWithTypeParameters extends AbstractQuickFixTest {
        private void runTest(String testDataFilePath) throws Exception {
            KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
        }

        public void testAllFilesPresentInLocalVariableWithTypeParameters() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/quickfix/localVariableWithTypeParameters"), Pattern.compile("^([\\w\\-_]+)\\.kt$"), TargetBackend.ANY, true);
        }

        @TestMetadata("removeTypeParametersFromLocalVariable.kt")
        public void testRemoveTypeParametersFromLocalVariable() throws Exception {
            runTest("idea/testData/quickfix/localVariableWithTypeParameters/removeTypeParametersFromLocalVariable.kt");
        }
    }

    @TestMetadata("idea/testData/quickfix/makeConstructorParameterProperty")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class MakeConstructorParameterProperty extends AbstractQuickFixTest {
        private void runTest(String testDataFilePath) throws Exception {
            KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
        }

        public void testAllFilesPresentInMakeConstructorParameterProperty() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/quickfix/makeConstructorParameterProperty"), Pattern.compile("^([\\w\\-_]+)\\.kt$"), TargetBackend.ANY, true);
        }

        @TestMetadata("inner.kt")
        public void testInner() throws Exception {
            runTest("idea/testData/quickfix/makeConstructorParameterProperty/inner.kt");
        }

        @TestMetadata("override.kt")
        public void testOverride() throws Exception {
            runTest("idea/testData/quickfix/makeConstructorParameterProperty/override.kt");
        }

        @TestMetadata("val.kt")
        public void testVal() throws Exception {
            runTest("idea/testData/quickfix/makeConstructorParameterProperty/val.kt");
        }

        @TestMetadata("var.kt")
        public void testVar() throws Exception {
            runTest("idea/testData/quickfix/makeConstructorParameterProperty/var.kt");
        }

        @TestMetadata("vararg.kt")
        public void testVararg() throws Exception {
            runTest("idea/testData/quickfix/makeConstructorParameterProperty/vararg.kt");
        }
    }

    @TestMetadata("idea/testData/quickfix/makeTypeParameterReified")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class MakeTypeParameterReified extends AbstractQuickFixTest {
        private void runTest(String testDataFilePath) throws Exception {
            KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
        }

        public void testAllFilesPresentInMakeTypeParameterReified() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/quickfix/makeTypeParameterReified"), Pattern.compile("^([\\w\\-_]+)\\.kt$"), TargetBackend.ANY, true);
        }

        @TestMetadata("noTypeParameter.kt")
        public void testNoTypeParameter() throws Exception {
            runTest("idea/testData/quickfix/makeTypeParameterReified/noTypeParameter.kt");
        }

        @TestMetadata("noTypeParameter2.kt")
        public void testNoTypeParameter2() throws Exception {
            runTest("idea/testData/quickfix/makeTypeParameterReified/noTypeParameter2.kt");
        }

        @TestMetadata("typeParameter.kt")
        public void testTypeParameter() throws Exception {
            runTest("idea/testData/quickfix/makeTypeParameterReified/typeParameter.kt");
        }
    }

    @TestMetadata("idea/testData/quickfix/memberVisibilityCanBePrivate")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class MemberVisibilityCanBePrivate extends AbstractQuickFixTest {
        private void runTest(String testDataFilePath) throws Exception {
            KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
        }

        public void testAllFilesPresentInMemberVisibilityCanBePrivate() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/quickfix/memberVisibilityCanBePrivate"), Pattern.compile("^([\\w\\-_]+)\\.kt$"), TargetBackend.ANY, true);
        }

        @TestMetadata("constructorParam.kt")
        public void testConstructorParam() throws Exception {
            runTest("idea/testData/quickfix/memberVisibilityCanBePrivate/constructorParam.kt");
        }

        @TestMetadata("internal.kt")
        public void testInternal() throws Exception {
            runTest("idea/testData/quickfix/memberVisibilityCanBePrivate/internal.kt");
        }

        @TestMetadata("noModifier.kt")
        public void testNoModifier() throws Exception {
            runTest("idea/testData/quickfix/memberVisibilityCanBePrivate/noModifier.kt");
        }

        @TestMetadata("protected.kt")
        public void testProtected() throws Exception {
            runTest("idea/testData/quickfix/memberVisibilityCanBePrivate/protected.kt");
        }

        @TestMetadata("public.kt")
        public void testPublic() throws Exception {
            runTest("idea/testData/quickfix/memberVisibilityCanBePrivate/public.kt");
        }
    }

    @TestMetadata("idea/testData/quickfix/migration")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class Migration extends AbstractQuickFixTest {
        private void runTest(String testDataFilePath) throws Exception {
            KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
        }

        public void testAllFilesPresentInMigration() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/quickfix/migration"), Pattern.compile("^([\\w\\-_]+)\\.kt$"), TargetBackend.ANY, true);
        }

        @TestMetadata("idea/testData/quickfix/migration/commasInWhenWithoutArgument")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class CommasInWhenWithoutArgument extends AbstractQuickFixTest {
            private void runTest(String testDataFilePath) throws Exception {
                KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
            }

            public void testAllFilesPresentInCommasInWhenWithoutArgument() throws Exception {
                KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/quickfix/migration/commasInWhenWithoutArgument"), Pattern.compile("^([\\w\\-_]+)\\.kt$"), TargetBackend.ANY, true);
            }

            @TestMetadata("commasInConditionWithNoArguments.kt")
            public void testCommasInConditionWithNoArguments() throws Exception {
                runTest("idea/testData/quickfix/migration/commasInWhenWithoutArgument/commasInConditionWithNoArguments.kt");
            }

            @TestMetadata("commasInConditionWithNoArguments2.kt")
            public void testCommasInConditionWithNoArguments2() throws Exception {
                runTest("idea/testData/quickfix/migration/commasInWhenWithoutArgument/commasInConditionWithNoArguments2.kt");
            }
        }

        @TestMetadata("idea/testData/quickfix/migration/conflictingExtension")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class ConflictingExtension extends AbstractQuickFixTest {
            private void runTest(String testDataFilePath) throws Exception {
                KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
            }

            public void testAllFilesPresentInConflictingExtension() throws Exception {
                KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/quickfix/migration/conflictingExtension"), Pattern.compile("^([\\w\\-_]+)\\.kt$"), TargetBackend.ANY, true);
            }

            @TestMetadata("explicitThis.kt")
            public void testExplicitThis() throws Exception {
                runTest("idea/testData/quickfix/migration/conflictingExtension/explicitThis.kt");
            }

            @TestMetadata("markHiddenAndDeprecated.kt")
            public void testMarkHiddenAndDeprecated() throws Exception {
                runTest("idea/testData/quickfix/migration/conflictingExtension/markHiddenAndDeprecated.kt");
            }

            @TestMetadata("memberExtension.kt")
            public void testMemberExtension() throws Exception {
                runTest("idea/testData/quickfix/migration/conflictingExtension/memberExtension.kt");
            }

            @TestMetadata("returnInGetter.kt")
            public void testReturnInGetter() throws Exception {
                runTest("idea/testData/quickfix/migration/conflictingExtension/returnInGetter.kt");
            }

            @TestMetadata("setterWithExpressionBody.kt")
            public void testSetterWithExpressionBody() throws Exception {
                runTest("idea/testData/quickfix/migration/conflictingExtension/setterWithExpressionBody.kt");
            }

            @TestMetadata("simple.kt")
            public void testSimple() throws Exception {
                runTest("idea/testData/quickfix/migration/conflictingExtension/simple.kt");
            }

            @TestMetadata("valInsteadOfVar.kt")
            public void testValInsteadOfVar() throws Exception {
                runTest("idea/testData/quickfix/migration/conflictingExtension/valInsteadOfVar.kt");
            }

            @TestMetadata("varInsteadOfVal.kt")
            public void testVarInsteadOfVal() throws Exception {
                runTest("idea/testData/quickfix/migration/conflictingExtension/varInsteadOfVal.kt");
            }

            @TestMetadata("withSetter.kt")
            public void testWithSetter() throws Exception {
                runTest("idea/testData/quickfix/migration/conflictingExtension/withSetter.kt");
            }

            @TestMetadata("wrongExplicitThis.kt")
            public void testWrongExplicitThis() throws Exception {
                runTest("idea/testData/quickfix/migration/conflictingExtension/wrongExplicitThis.kt");
            }

            @TestMetadata("wrongExplicitThis2.kt")
            public void testWrongExplicitThis2() throws Exception {
                runTest("idea/testData/quickfix/migration/conflictingExtension/wrongExplicitThis2.kt");
            }

            @TestMetadata("wrongGetter.kt")
            public void testWrongGetter() throws Exception {
                runTest("idea/testData/quickfix/migration/conflictingExtension/wrongGetter.kt");
            }

            @TestMetadata("wrongGetter2.kt")
            public void testWrongGetter2() throws Exception {
                runTest("idea/testData/quickfix/migration/conflictingExtension/wrongGetter2.kt");
            }

            @TestMetadata("wrongSetter.kt")
            public void testWrongSetter() throws Exception {
                runTest("idea/testData/quickfix/migration/conflictingExtension/wrongSetter.kt");
            }
        }

        @TestMetadata("idea/testData/quickfix/migration/javaAnnotationPositionedArguments")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class JavaAnnotationPositionedArguments extends AbstractQuickFixTest {
            private void runTest(String testDataFilePath) throws Exception {
                KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
            }

            public void testAllFilesPresentInJavaAnnotationPositionedArguments() throws Exception {
                KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/quickfix/migration/javaAnnotationPositionedArguments"), Pattern.compile("^([\\w\\-_]+)\\.kt$"), TargetBackend.ANY, true);
            }
        }

        @TestMetadata("idea/testData/quickfix/migration/jsExternal")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class JsExternal extends AbstractQuickFixTest {
            private void runTest(String testDataFilePath) throws Exception {
                KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
            }

            public void testAllFilesPresentInJsExternal() throws Exception {
                KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/quickfix/migration/jsExternal"), Pattern.compile("^([\\w\\-_]+)\\.kt$"), TargetBackend.ANY, true);
            }

            @TestMetadata("externalExtensionFunJsRuntime.kt")
            public void testExternalExtensionFunJsRuntime() throws Exception {
                runTest("idea/testData/quickfix/migration/jsExternal/externalExtensionFunJsRuntime.kt");
            }

            @TestMetadata("externalExtensionFunParamsJsRuntime.kt")
            public void testExternalExtensionFunParamsJsRuntime() throws Exception {
                runTest("idea/testData/quickfix/migration/jsExternal/externalExtensionFunParamsJsRuntime.kt");
            }

            @TestMetadata("externalExtensionVarJsRuntime.kt")
            public void testExternalExtensionVarJsRuntime() throws Exception {
                runTest("idea/testData/quickfix/migration/jsExternal/externalExtensionVarJsRuntime.kt");
            }

            @TestMetadata("funPlacementOnCompanionObjectJsRuntime.kt")
            public void testFunPlacementOnCompanionObjectJsRuntime() throws Exception {
                runTest("idea/testData/quickfix/migration/jsExternal/funPlacementOnCompanionObjectJsRuntime.kt");
            }

            @TestMetadata("funPlacementOnExternalClassJsRuntime.kt")
            public void testFunPlacementOnExternalClassJsRuntime() throws Exception {
                runTest("idea/testData/quickfix/migration/jsExternal/funPlacementOnExternalClassJsRuntime.kt");
            }

            @TestMetadata("funPlacementOnExternalObjectJsRuntime.kt")
            public void testFunPlacementOnExternalObjectJsRuntime() throws Exception {
                runTest("idea/testData/quickfix/migration/jsExternal/funPlacementOnExternalObjectJsRuntime.kt");
            }

            @TestMetadata("nativeExtensionFunBlockBodyJsRuntime.kt")
            public void testNativeExtensionFunBlockBodyJsRuntime() throws Exception {
                runTest("idea/testData/quickfix/migration/jsExternal/nativeExtensionFunBlockBodyJsRuntime.kt");
            }

            @TestMetadata("nativeExtensionFunJsName.kt")
            public void testNativeExtensionFunJsName() throws Exception {
                runTest("idea/testData/quickfix/migration/jsExternal/nativeExtensionFunJsName.kt");
            }

            @TestMetadata("nativeExtensionFunJsRuntime.kt")
            public void testNativeExtensionFunJsRuntime() throws Exception {
                runTest("idea/testData/quickfix/migration/jsExternal/nativeExtensionFunJsRuntime.kt");
            }

            @TestMetadata("nativeExtensionFunParamsJsRuntime.kt")
            public void testNativeExtensionFunParamsJsRuntime() throws Exception {
                runTest("idea/testData/quickfix/migration/jsExternal/nativeExtensionFunParamsJsRuntime.kt");
            }

            @TestMetadata("nativeExtensionVaslJsRuntime.kt")
            public void testNativeExtensionVaslJsRuntime() throws Exception {
                runTest("idea/testData/quickfix/migration/jsExternal/nativeExtensionVaslJsRuntime.kt");
            }

            @TestMetadata("nativeGetterExtensionFunJsRuntime.kt")
            public void testNativeGetterExtensionFunJsRuntime() throws Exception {
                runTest("idea/testData/quickfix/migration/jsExternal/nativeGetterExtensionFunJsRuntime.kt");
            }

            @TestMetadata("nativeInvokeExtensionFunJsRuntime.kt")
            public void testNativeInvokeExtensionFunJsRuntime() throws Exception {
                runTest("idea/testData/quickfix/migration/jsExternal/nativeInvokeExtensionFunJsRuntime.kt");
            }

            @TestMetadata("nativeMemberAll01.kt")
            public void testNativeMemberAll01() throws Exception {
                runTest("idea/testData/quickfix/migration/jsExternal/nativeMemberAll01.kt");
            }

            @TestMetadata("nativeMemberAll02.kt")
            public void testNativeMemberAll02() throws Exception {
                runTest("idea/testData/quickfix/migration/jsExternal/nativeMemberAll02.kt");
            }

            @TestMetadata("nativeMemberAll03.kt")
            public void testNativeMemberAll03() throws Exception {
                runTest("idea/testData/quickfix/migration/jsExternal/nativeMemberAll03.kt");
            }

            @TestMetadata("nativeMemberGetter.kt")
            public void testNativeMemberGetter() throws Exception {
                runTest("idea/testData/quickfix/migration/jsExternal/nativeMemberGetter.kt");
            }

            @TestMetadata("nativeMemberInvoke.kt")
            public void testNativeMemberInvoke() throws Exception {
                runTest("idea/testData/quickfix/migration/jsExternal/nativeMemberInvoke.kt");
            }

            @TestMetadata("nativeMemberInvokeGenericClass.kt")
            public void testNativeMemberInvokeGenericClass() throws Exception {
                runTest("idea/testData/quickfix/migration/jsExternal/nativeMemberInvokeGenericClass.kt");
            }

            @TestMetadata("nativeMemberInvokeGenericClassAndFun.kt")
            public void testNativeMemberInvokeGenericClassAndFun() throws Exception {
                runTest("idea/testData/quickfix/migration/jsExternal/nativeMemberInvokeGenericClassAndFun.kt");
            }

            @TestMetadata("nativeMemberInvokeGenericFun.kt")
            public void testNativeMemberInvokeGenericFun() throws Exception {
                runTest("idea/testData/quickfix/migration/jsExternal/nativeMemberInvokeGenericFun.kt");
            }

            @TestMetadata("nativeMemberNative.kt")
            public void testNativeMemberNative() throws Exception {
                runTest("idea/testData/quickfix/migration/jsExternal/nativeMemberNative.kt");
            }

            @TestMetadata("nativeMemberSetter.kt")
            public void testNativeMemberSetter() throws Exception {
                runTest("idea/testData/quickfix/migration/jsExternal/nativeMemberSetter.kt");
            }

            @TestMetadata("nativeSetterExtensionFunJsRuntime.kt")
            public void testNativeSetterExtensionFunJsRuntime() throws Exception {
                runTest("idea/testData/quickfix/migration/jsExternal/nativeSetterExtensionFunJsRuntime.kt");
            }

            @TestMetadata("nestedExtension01.kt")
            public void testNestedExtension01() throws Exception {
                runTest("idea/testData/quickfix/migration/jsExternal/nestedExtension01.kt");
            }
        }

        @TestMetadata("idea/testData/quickfix/migration/missingConstructorKeyword")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class MissingConstructorKeyword extends AbstractQuickFixTest {
            private void runTest(String testDataFilePath) throws Exception {
                KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
            }

            public void testAllFilesPresentInMissingConstructorKeyword() throws Exception {
                KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/quickfix/migration/missingConstructorKeyword"), Pattern.compile("^([\\w\\-_]+)\\.kt$"), TargetBackend.ANY, true);
            }

            @TestMetadata("basic.kt")
            public void testBasic() throws Exception {
                runTest("idea/testData/quickfix/migration/missingConstructorKeyword/basic.kt");
            }
        }

        @TestMetadata("idea/testData/quickfix/migration/obsoleteLabelSyntax")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class ObsoleteLabelSyntax extends AbstractQuickFixTest {
            private void runTest(String testDataFilePath) throws Exception {
                KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
            }

            public void testAllFilesPresentInObsoleteLabelSyntax() throws Exception {
                KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/quickfix/migration/obsoleteLabelSyntax"), Pattern.compile("^([\\w\\-_]+)\\.kt$"), TargetBackend.ANY, true);
            }

            @TestMetadata("lambda.kt")
            public void testLambda() throws Exception {
                runTest("idea/testData/quickfix/migration/obsoleteLabelSyntax/lambda.kt");
            }

            @TestMetadata("loop.kt")
            public void testLoop() throws Exception {
                runTest("idea/testData/quickfix/migration/obsoleteLabelSyntax/loop.kt");
            }
        }

        @TestMetadata("idea/testData/quickfix/migration/removeNameFromFunctionExpression")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class RemoveNameFromFunctionExpression extends AbstractQuickFixTest {
            private void runTest(String testDataFilePath) throws Exception {
                KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
            }

            public void testAllFilesPresentInRemoveNameFromFunctionExpression() throws Exception {
                KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/quickfix/migration/removeNameFromFunctionExpression"), Pattern.compile("^([\\w\\-_]+)\\.kt$"), TargetBackend.ANY, true);
            }

            @TestMetadata("basic.kt")
            public void testBasic() throws Exception {
                runTest("idea/testData/quickfix/migration/removeNameFromFunctionExpression/basic.kt");
            }
        }

        @TestMetadata("idea/testData/quickfix/migration/typeParameterList")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class TypeParameterList extends AbstractQuickFixTest {
            private void runTest(String testDataFilePath) throws Exception {
                KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
            }

            public void testAllFilesPresentInTypeParameterList() throws Exception {
                KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/quickfix/migration/typeParameterList"), Pattern.compile("^([\\w\\-_]+)\\.kt$"), TargetBackend.ANY, true);
            }

            @TestMetadata("basic.kt")
            public void testBasic() throws Exception {
                runTest("idea/testData/quickfix/migration/typeParameterList/basic.kt");
            }

            @TestMetadata("extension.kt")
            public void testExtension() throws Exception {
                runTest("idea/testData/quickfix/migration/typeParameterList/extension.kt");
            }
        }
    }

    @TestMetadata("idea/testData/quickfix/missingConstructorBrackets")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class MissingConstructorBrackets extends AbstractQuickFixTest {
        private void runTest(String testDataFilePath) throws Exception {
            KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
        }

        public void testAllFilesPresentInMissingConstructorBrackets() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/quickfix/missingConstructorBrackets"), Pattern.compile("^([\\w\\-_]+)\\.kt$"), TargetBackend.ANY, true);
        }

        @TestMetadata("basic.kt")
        public void testBasic() throws Exception {
            runTest("idea/testData/quickfix/missingConstructorBrackets/basic.kt");
        }
    }

    @TestMetadata("idea/testData/quickfix/modifiers")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class Modifiers extends AbstractQuickFixTest {
        private void runTest(String testDataFilePath) throws Exception {
            KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
        }

        @TestMetadata("abstractModifierInEnum.kt")
        public void testAbstractModifierInEnum() throws Exception {
            runTest("idea/testData/quickfix/modifiers/abstractModifierInEnum.kt");
        }

        @TestMetadata("addLateinit.kt")
        public void testAddLateinit() throws Exception {
            runTest("idea/testData/quickfix/modifiers/addLateinit.kt");
        }

        public void testAllFilesPresentInModifiers() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/quickfix/modifiers"), Pattern.compile("^([\\w\\-_]+)\\.kt$"), TargetBackend.ANY, true);
        }

        @TestMetadata("cannotMakeClassAnnotation.kt")
        public void testCannotMakeClassAnnotation() throws Exception {
            runTest("idea/testData/quickfix/modifiers/cannotMakeClassAnnotation.kt");
        }

        @TestMetadata("finalTrait.kt")
        public void testFinalTrait() throws Exception {
            runTest("idea/testData/quickfix/modifiers/finalTrait.kt");
        }

        @TestMetadata("illegalEnumAnnotation1.kt")
        public void testIllegalEnumAnnotation1() throws Exception {
            runTest("idea/testData/quickfix/modifiers/illegalEnumAnnotation1.kt");
        }

        @TestMetadata("illegalEnumAnnotation2.kt")
        public void testIllegalEnumAnnotation2() throws Exception {
            runTest("idea/testData/quickfix/modifiers/illegalEnumAnnotation2.kt");
        }

        @TestMetadata("infixModifier.kt")
        public void testInfixModifier() throws Exception {
            runTest("idea/testData/quickfix/modifiers/infixModifier.kt");
        }

        @TestMetadata("kt10409.kt")
        public void testKt10409() throws Exception {
            runTest("idea/testData/quickfix/modifiers/kt10409.kt");
        }

        @TestMetadata("nestedAbstractClass.kt")
        public void testNestedAbstractClass() throws Exception {
            runTest("idea/testData/quickfix/modifiers/nestedAbstractClass.kt");
        }

        @TestMetadata("nestedAnnotationClass.kt")
        public void testNestedAnnotationClass() throws Exception {
            runTest("idea/testData/quickfix/modifiers/nestedAnnotationClass.kt");
        }

        @TestMetadata("nestedClassNotAllowed.kt")
        public void testNestedClassNotAllowed() throws Exception {
            runTest("idea/testData/quickfix/modifiers/nestedClassNotAllowed.kt");
        }

        @TestMetadata("nestedDataClass.kt")
        public void testNestedDataClass() throws Exception {
            runTest("idea/testData/quickfix/modifiers/nestedDataClass.kt");
        }

        @TestMetadata("nestedEnumClass.kt")
        public void testNestedEnumClass() throws Exception {
            runTest("idea/testData/quickfix/modifiers/nestedEnumClass.kt");
        }

        @TestMetadata("nestedInterface.kt")
        public void testNestedInterface() throws Exception {
            runTest("idea/testData/quickfix/modifiers/nestedInterface.kt");
        }

        @TestMetadata("nestedObject.kt")
        public void testNestedObject() throws Exception {
            runTest("idea/testData/quickfix/modifiers/nestedObject.kt");
        }

        @TestMetadata("nestedSealedClass.kt")
        public void testNestedSealedClass() throws Exception {
            runTest("idea/testData/quickfix/modifiers/nestedSealedClass.kt");
        }

        @TestMetadata("noAbstractForAnonymousObject.kt")
        public void testNoAbstractForAnonymousObject() throws Exception {
            runTest("idea/testData/quickfix/modifiers/noAbstractForAnonymousObject.kt");
        }

        @TestMetadata("noAbstractForObject.kt")
        public void testNoAbstractForObject() throws Exception {
            runTest("idea/testData/quickfix/modifiers/noAbstractForObject.kt");
        }

        @TestMetadata("noLateinitOnNullable.kt")
        public void testNoLateinitOnNullable() throws Exception {
            runTest("idea/testData/quickfix/modifiers/noLateinitOnNullable.kt");
        }

        @TestMetadata("noLateinitOnPrimitive.kt")
        public void testNoLateinitOnPrimitive() throws Exception {
            runTest("idea/testData/quickfix/modifiers/noLateinitOnPrimitive.kt");
        }

        @TestMetadata("notAnAnnotationClass.kt")
        public void testNotAnAnnotationClass() throws Exception {
            runTest("idea/testData/quickfix/modifiers/notAnAnnotationClass.kt");
        }

        @TestMetadata("openMemberInFinalClass1.kt")
        public void testOpenMemberInFinalClass1() throws Exception {
            runTest("idea/testData/quickfix/modifiers/openMemberInFinalClass1.kt");
        }

        @TestMetadata("openMemberInFinalClass2.kt")
        public void testOpenMemberInFinalClass2() throws Exception {
            runTest("idea/testData/quickfix/modifiers/openMemberInFinalClass2.kt");
        }

        @TestMetadata("openMemberInFinalClass3.kt")
        public void testOpenMemberInFinalClass3() throws Exception {
            runTest("idea/testData/quickfix/modifiers/openMemberInFinalClass3.kt");
        }

        @TestMetadata("openMemberInFinalClass4.kt")
        public void testOpenMemberInFinalClass4() throws Exception {
            runTest("idea/testData/quickfix/modifiers/openMemberInFinalClass4.kt");
        }

        @TestMetadata("openModifierInEnum.kt")
        public void testOpenModifierInEnum() throws Exception {
            runTest("idea/testData/quickfix/modifiers/openModifierInEnum.kt");
        }

        @TestMetadata("openVarWithPrivateSetter.kt")
        public void testOpenVarWithPrivateSetter() throws Exception {
            runTest("idea/testData/quickfix/modifiers/openVarWithPrivateSetter.kt");
        }

        @TestMetadata("operatorModifier.kt")
        public void testOperatorModifier() throws Exception {
            runTest("idea/testData/quickfix/modifiers/operatorModifier.kt");
        }

        @TestMetadata("operatorModifierCollection.kt")
        public void testOperatorModifierCollection() throws Exception {
            runTest("idea/testData/quickfix/modifiers/operatorModifierCollection.kt");
        }

        @TestMetadata("operatorModifierComponent.kt")
        public void testOperatorModifierComponent() throws Exception {
            runTest("idea/testData/quickfix/modifiers/operatorModifierComponent.kt");
        }

        @TestMetadata("operatorModifierGet.kt")
        public void testOperatorModifierGet() throws Exception {
            runTest("idea/testData/quickfix/modifiers/operatorModifierGet.kt");
        }

        @TestMetadata("operatorModifierInherited.kt")
        public void testOperatorModifierInherited() throws Exception {
            runTest("idea/testData/quickfix/modifiers/operatorModifierInherited.kt");
        }

        @TestMetadata("overrideWithPrivateSetter.kt")
        public void testOverrideWithPrivateSetter() throws Exception {
            runTest("idea/testData/quickfix/modifiers/overrideWithPrivateSetter.kt");
        }

        @TestMetadata("packageMemberCannotBeProtected.kt")
        public void testPackageMemberCannotBeProtected() throws Exception {
            runTest("idea/testData/quickfix/modifiers/packageMemberCannotBeProtected.kt");
        }

        @TestMetadata("redundantOpenInInterface.kt")
        public void testRedundantOpenInInterface() throws Exception {
            runTest("idea/testData/quickfix/modifiers/redundantOpenInInterface.kt");
        }

        @TestMetadata("removeAbstractModifier.kt")
        public void testRemoveAbstractModifier() throws Exception {
            runTest("idea/testData/quickfix/modifiers/removeAbstractModifier.kt");
        }

        @TestMetadata("removeConst.kt")
        public void testRemoveConst() throws Exception {
            runTest("idea/testData/quickfix/modifiers/removeConst.kt");
        }

        @TestMetadata("removeIncompatibleModifier.kt")
        public void testRemoveIncompatibleModifier() throws Exception {
            runTest("idea/testData/quickfix/modifiers/removeIncompatibleModifier.kt");
        }

        @TestMetadata("removeInnerForClassInTrait.kt")
        public void testRemoveInnerForClassInTrait() throws Exception {
            runTest("idea/testData/quickfix/modifiers/removeInnerForClassInTrait.kt");
        }

        @TestMetadata("removeModifierFromForbiddenOperatorMod.kt")
        public void testRemoveModifierFromForbiddenOperatorMod() throws Exception {
            runTest("idea/testData/quickfix/modifiers/removeModifierFromForbiddenOperatorMod.kt");
        }

        @TestMetadata("removeModifierFromOperatorMod.kt")
        public void testRemoveModifierFromOperatorMod() throws Exception {
            runTest("idea/testData/quickfix/modifiers/removeModifierFromOperatorMod.kt");
        }

        @TestMetadata("removeModifierFromOperatorModAssign.kt")
        public void testRemoveModifierFromOperatorModAssign() throws Exception {
            runTest("idea/testData/quickfix/modifiers/removeModifierFromOperatorModAssign.kt");
        }

        @TestMetadata("removeProtectedModifier.kt")
        public void testRemoveProtectedModifier() throws Exception {
            runTest("idea/testData/quickfix/modifiers/removeProtectedModifier.kt");
        }

        @TestMetadata("removeRedundantModifier1.kt")
        public void testRemoveRedundantModifier1() throws Exception {
            runTest("idea/testData/quickfix/modifiers/removeRedundantModifier1.kt");
        }

        @TestMetadata("removeRedundantModifier2.kt")
        public void testRemoveRedundantModifier2() throws Exception {
            runTest("idea/testData/quickfix/modifiers/removeRedundantModifier2.kt");
        }

        @TestMetadata("removeRedundantModifier3.kt")
        public void testRemoveRedundantModifier3() throws Exception {
            runTest("idea/testData/quickfix/modifiers/removeRedundantModifier3.kt");
        }

        @TestMetadata("removeSupertype1.kt")
        public void testRemoveSupertype1() throws Exception {
            runTest("idea/testData/quickfix/modifiers/removeSupertype1.kt");
        }

        @TestMetadata("removeSupertype2.kt")
        public void testRemoveSupertype2() throws Exception {
            runTest("idea/testData/quickfix/modifiers/removeSupertype2.kt");
        }

        @TestMetadata("removeSupertype3.kt")
        public void testRemoveSupertype3() throws Exception {
            runTest("idea/testData/quickfix/modifiers/removeSupertype3.kt");
        }

        @TestMetadata("removeSupertype4.kt")
        public void testRemoveSupertype4() throws Exception {
            runTest("idea/testData/quickfix/modifiers/removeSupertype4.kt");
        }

        @TestMetadata("visibilityModifer1.kt")
        public void testVisibilityModifer1() throws Exception {
            runTest("idea/testData/quickfix/modifiers/visibilityModifer1.kt");
        }

        @TestMetadata("visibilityModifer2.kt")
        public void testVisibilityModifer2() throws Exception {
            runTest("idea/testData/quickfix/modifiers/visibilityModifer2.kt");
        }

        @TestMetadata("visibilityModiferOverrideJavaRuntime.kt")
        public void testVisibilityModiferOverrideJavaRuntime() throws Exception {
            runTest("idea/testData/quickfix/modifiers/visibilityModiferOverrideJavaRuntime.kt");
        }

        @TestMetadata("visibilityModiferParameter.kt")
        public void testVisibilityModiferParameter() throws Exception {
            runTest("idea/testData/quickfix/modifiers/visibilityModiferParameter.kt");
        }

        @TestMetadata("idea/testData/quickfix/modifiers/addOpenToClassDeclaration")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class AddOpenToClassDeclaration extends AbstractQuickFixTest {
            private void runTest(String testDataFilePath) throws Exception {
                KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
            }

            public void testAllFilesPresentInAddOpenToClassDeclaration() throws Exception {
                KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/quickfix/modifiers/addOpenToClassDeclaration"), Pattern.compile("^([\\w\\-_]+)\\.kt$"), TargetBackend.ANY, true);
            }

            @TestMetadata("dataSuperType.kt")
            public void testDataSuperType() throws Exception {
                runTest("idea/testData/quickfix/modifiers/addOpenToClassDeclaration/dataSuperType.kt");
            }

            @TestMetadata("enumSupertype.kt")
            public void testEnumSupertype() throws Exception {
                runTest("idea/testData/quickfix/modifiers/addOpenToClassDeclaration/enumSupertype.kt");
            }

            @TestMetadata("enumUpperBound.kt")
            public void testEnumUpperBound() throws Exception {
                runTest("idea/testData/quickfix/modifiers/addOpenToClassDeclaration/enumUpperBound.kt");
            }

            @TestMetadata("explicitlyFinalSupertype.kt")
            public void testExplicitlyFinalSupertype() throws Exception {
                runTest("idea/testData/quickfix/modifiers/addOpenToClassDeclaration/explicitlyFinalSupertype.kt");
            }

            @TestMetadata("explicitlyFinalUpperBound.kt")
            public void testExplicitlyFinalUpperBound() throws Exception {
                runTest("idea/testData/quickfix/modifiers/addOpenToClassDeclaration/explicitlyFinalUpperBound.kt");
            }

            @TestMetadata("finalLibrarySupertype.kt")
            public void testFinalLibrarySupertype() throws Exception {
                runTest("idea/testData/quickfix/modifiers/addOpenToClassDeclaration/finalLibrarySupertype.kt");
            }

            @TestMetadata("finalLibraryUpperBound.kt")
            public void testFinalLibraryUpperBound() throws Exception {
                runTest("idea/testData/quickfix/modifiers/addOpenToClassDeclaration/finalLibraryUpperBound.kt");
            }

            @TestMetadata("finalSupertype.kt")
            public void testFinalSupertype() throws Exception {
                runTest("idea/testData/quickfix/modifiers/addOpenToClassDeclaration/finalSupertype.kt");
            }

            @TestMetadata("finalUpperBound.kt")
            public void testFinalUpperBound() throws Exception {
                runTest("idea/testData/quickfix/modifiers/addOpenToClassDeclaration/finalUpperBound.kt");
            }

            @TestMetadata("implementTraitFinalSupertype.kt")
            public void testImplementTraitFinalSupertype() throws Exception {
                runTest("idea/testData/quickfix/modifiers/addOpenToClassDeclaration/implementTraitFinalSupertype.kt");
            }

            @TestMetadata("nestedFinalClass.kt")
            public void testNestedFinalClass() throws Exception {
                runTest("idea/testData/quickfix/modifiers/addOpenToClassDeclaration/nestedFinalClass.kt");
            }

            @TestMetadata("openInCompanion.kt")
            public void testOpenInCompanion() throws Exception {
                runTest("idea/testData/quickfix/modifiers/addOpenToClassDeclaration/openInCompanion.kt");
            }

            @TestMetadata("secondaryCtrDelegationInHeader.kt")
            public void testSecondaryCtrDelegationInHeader() throws Exception {
                runTest("idea/testData/quickfix/modifiers/addOpenToClassDeclaration/secondaryCtrDelegationInHeader.kt");
            }

            @TestMetadata("secondaryCtrDelegationInSecondary.kt")
            public void testSecondaryCtrDelegationInSecondary() throws Exception {
                runTest("idea/testData/quickfix/modifiers/addOpenToClassDeclaration/secondaryCtrDelegationInSecondary.kt");
            }

            @TestMetadata("withConstructor.kt")
            public void testWithConstructor() throws Exception {
                runTest("idea/testData/quickfix/modifiers/addOpenToClassDeclaration/withConstructor.kt");
            }
        }

        @TestMetadata("idea/testData/quickfix/modifiers/suspend")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class Suspend extends AbstractQuickFixTest {
            private void runTest(String testDataFilePath) throws Exception {
                KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
            }

            public void testAllFilesPresentInSuspend() throws Exception {
                KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/quickfix/modifiers/suspend"), Pattern.compile("^([\\w\\-_]+)\\.kt$"), TargetBackend.ANY, true);
            }

            @TestMetadata("base.kt")
            public void testBase() throws Exception {
                runTest("idea/testData/quickfix/modifiers/suspend/base.kt");
            }

            @TestMetadata("createCoroutine.kt")
            public void testCreateCoroutine() throws Exception {
                runTest("idea/testData/quickfix/modifiers/suspend/createCoroutine.kt");
            }

            @TestMetadata("init.kt")
            public void testInit() throws Exception {
                runTest("idea/testData/quickfix/modifiers/suspend/init.kt");
            }

            @TestMetadata("open.kt")
            public void testOpen() throws Exception {
                runTest("idea/testData/quickfix/modifiers/suspend/open.kt");
            }

            @TestMetadata("override.kt")
            public void testOverride() throws Exception {
                runTest("idea/testData/quickfix/modifiers/suspend/override.kt");
            }

            @TestMetadata("public.kt")
            public void testPublic() throws Exception {
                runTest("idea/testData/quickfix/modifiers/suspend/public.kt");
            }

            @TestMetadata("startCoroutine.kt")
            public void testStartCoroutine() throws Exception {
                runTest("idea/testData/quickfix/modifiers/suspend/startCoroutine.kt");
            }

            @TestMetadata("startCoroutineNoImport.kt")
            public void testStartCoroutineNoImport() throws Exception {
                runTest("idea/testData/quickfix/modifiers/suspend/startCoroutineNoImport.kt");
            }

            @TestMetadata("topLevel.kt")
            public void testTopLevel() throws Exception {
                runTest("idea/testData/quickfix/modifiers/suspend/topLevel.kt");
            }
        }
    }

    @TestMetadata("idea/testData/quickfix/moveMemberToCompanionObject")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class MoveMemberToCompanionObject extends AbstractQuickFixTest {
        private void runTest(String testDataFilePath) throws Exception {
            KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
        }

        public void testAllFilesPresentInMoveMemberToCompanionObject() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/quickfix/moveMemberToCompanionObject"), Pattern.compile("^([\\w\\-_]+)\\.kt$"), TargetBackend.ANY, true);
        }

        @TestMetadata("simple.kt")
        public void testSimple() throws Exception {
            runTest("idea/testData/quickfix/moveMemberToCompanionObject/simple.kt");
        }
    }

    @TestMetadata("idea/testData/quickfix/moveReceiverAnnotation")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class MoveReceiverAnnotation extends AbstractQuickFixTest {
        private void runTest(String testDataFilePath) throws Exception {
            KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
        }

        public void testAllFilesPresentInMoveReceiverAnnotation() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/quickfix/moveReceiverAnnotation"), Pattern.compile("^([\\w\\-_]+)\\.kt$"), TargetBackend.ANY, true);
        }

        @TestMetadata("fun.kt")
        public void testFun() throws Exception {
            runTest("idea/testData/quickfix/moveReceiverAnnotation/fun.kt");
        }

        @TestMetadata("notExtensionFun.kt")
        public void testNotExtensionFun() throws Exception {
            runTest("idea/testData/quickfix/moveReceiverAnnotation/notExtensionFun.kt");
        }

        @TestMetadata("notExtensionVal.kt")
        public void testNotExtensionVal() throws Exception {
            runTest("idea/testData/quickfix/moveReceiverAnnotation/notExtensionVal.kt");
        }

        @TestMetadata("val.kt")
        public void testVal() throws Exception {
            runTest("idea/testData/quickfix/moveReceiverAnnotation/val.kt");
        }
    }

    @TestMetadata("idea/testData/quickfix/moveToConstructorParameters")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class MoveToConstructorParameters extends AbstractQuickFixTest {
        private void runTest(String testDataFilePath) throws Exception {
            KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
        }

        public void testAllFilesPresentInMoveToConstructorParameters() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/quickfix/moveToConstructorParameters"), Pattern.compile("^([\\w\\-_]+)\\.kt$"), TargetBackend.ANY, true);
        }

        @TestMetadata("localVar.kt")
        public void testLocalVar() throws Exception {
            runTest("idea/testData/quickfix/moveToConstructorParameters/localVar.kt");
        }

        @TestMetadata("memberExtensionProperty.kt")
        public void testMemberExtensionProperty() throws Exception {
            runTest("idea/testData/quickfix/moveToConstructorParameters/memberExtensionProperty.kt");
        }

        @TestMetadata("memberPropertyInClassNameClash.kt")
        public void testMemberPropertyInClassNameClash() throws Exception {
            runTest("idea/testData/quickfix/moveToConstructorParameters/memberPropertyInClassNameClash.kt");
        }

        @TestMetadata("memberPropertyInClassNoPrimaryConstructor.kt")
        public void testMemberPropertyInClassNoPrimaryConstructor() throws Exception {
            runTest("idea/testData/quickfix/moveToConstructorParameters/memberPropertyInClassNoPrimaryConstructor.kt");
        }

        @TestMetadata("memberPropertyInClassWithConstructorDelegatingToSuper.kt")
        public void testMemberPropertyInClassWithConstructorDelegatingToSuper() throws Exception {
            runTest("idea/testData/quickfix/moveToConstructorParameters/memberPropertyInClassWithConstructorDelegatingToSuper.kt");
        }

        @TestMetadata("memberPropertyInClassWithImplicitlyDelegatingConstructor.kt")
        public void testMemberPropertyInClassWithImplicitlyDelegatingConstructor() throws Exception {
            runTest("idea/testData/quickfix/moveToConstructorParameters/memberPropertyInClassWithImplicitlyDelegatingConstructor.kt");
        }

        @TestMetadata("memberPropertyInClassWithPrimaryConstructor.kt")
        public void testMemberPropertyInClassWithPrimaryConstructor() throws Exception {
            runTest("idea/testData/quickfix/moveToConstructorParameters/memberPropertyInClassWithPrimaryConstructor.kt");
        }

        @TestMetadata("memberPropertyInInterface.kt")
        public void testMemberPropertyInInterface() throws Exception {
            runTest("idea/testData/quickfix/moveToConstructorParameters/memberPropertyInInterface.kt");
        }

        @TestMetadata("memberPropertyInObject.kt")
        public void testMemberPropertyInObject() throws Exception {
            runTest("idea/testData/quickfix/moveToConstructorParameters/memberPropertyInObject.kt");
        }

        @TestMetadata("memberPropertyWithDelegateRuntime.kt")
        public void testMemberPropertyWithDelegateRuntime() throws Exception {
            runTest("idea/testData/quickfix/moveToConstructorParameters/memberPropertyWithDelegateRuntime.kt");
        }

        @TestMetadata("propertyWithModifiersAndComments.kt")
        public void testPropertyWithModifiersAndComments() throws Exception {
            runTest("idea/testData/quickfix/moveToConstructorParameters/propertyWithModifiersAndComments.kt");
        }

        @TestMetadata("topLevelProperty.kt")
        public void testTopLevelProperty() throws Exception {
            runTest("idea/testData/quickfix/moveToConstructorParameters/topLevelProperty.kt");
        }
    }

    @TestMetadata("idea/testData/quickfix/nullables")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class Nullables extends AbstractQuickFixTest {
        private void runTest(String testDataFilePath) throws Exception {
            KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
        }

        public void testAllFilesPresentInNullables() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/quickfix/nullables"), Pattern.compile("^([\\w\\-_]+)\\.kt$"), TargetBackend.ANY, true);
        }

        @TestMetadata("removeRedundantNullable.kt")
        public void testRemoveRedundantNullable() throws Exception {
            runTest("idea/testData/quickfix/nullables/removeRedundantNullable.kt");
        }

        @TestMetadata("removeSupertypeNullable1.kt")
        public void testRemoveSupertypeNullable1() throws Exception {
            runTest("idea/testData/quickfix/nullables/removeSupertypeNullable1.kt");
        }

        @TestMetadata("removeSupertypeNullable2.kt")
        public void testRemoveSupertypeNullable2() throws Exception {
            runTest("idea/testData/quickfix/nullables/removeSupertypeNullable2.kt");
        }

        @TestMetadata("removeUselessNullable.kt")
        public void testRemoveUselessNullable() throws Exception {
            runTest("idea/testData/quickfix/nullables/removeUselessNullable.kt");
        }

        @TestMetadata("idea/testData/quickfix/nullables/unsafeInfixCall")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class UnsafeInfixCall extends AbstractQuickFixTest {
            private void runTest(String testDataFilePath) throws Exception {
                KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
            }

            public void testAllFilesPresentInUnsafeInfixCall() throws Exception {
                KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/quickfix/nullables/unsafeInfixCall"), Pattern.compile("^([\\w\\-_]+)\\.kt$"), TargetBackend.ANY, true);
            }

            @TestMetadata("noComparison.kt")
            public void testNoComparison() throws Exception {
                runTest("idea/testData/quickfix/nullables/unsafeInfixCall/noComparison.kt");
            }

            @TestMetadata("unsafeComparisonInCondition.kt")
            public void testUnsafeComparisonInCondition() throws Exception {
                runTest("idea/testData/quickfix/nullables/unsafeInfixCall/unsafeComparisonInCondition.kt");
            }

            @TestMetadata("unsafeComparisonInLogic.kt")
            public void testUnsafeComparisonInLogic() throws Exception {
                runTest("idea/testData/quickfix/nullables/unsafeInfixCall/unsafeComparisonInLogic.kt");
            }

            @TestMetadata("unsafeComparisonInWhen.kt")
            public void testUnsafeComparisonInWhen() throws Exception {
                runTest("idea/testData/quickfix/nullables/unsafeInfixCall/unsafeComparisonInWhen.kt");
            }

            @TestMetadata("unsafeComparisonInWhile.kt")
            public void testUnsafeComparisonInWhile() throws Exception {
                runTest("idea/testData/quickfix/nullables/unsafeInfixCall/unsafeComparisonInWhile.kt");
            }

            @TestMetadata("unsafeGet.kt")
            public void testUnsafeGet() throws Exception {
                runTest("idea/testData/quickfix/nullables/unsafeInfixCall/unsafeGet.kt");
            }

            @TestMetadata("unsafeInfixCall.kt")
            public void testUnsafeInfixCall() throws Exception {
                runTest("idea/testData/quickfix/nullables/unsafeInfixCall/unsafeInfixCall.kt");
            }

            @TestMetadata("unsafeInvoke.kt")
            public void testUnsafeInvoke() throws Exception {
                runTest("idea/testData/quickfix/nullables/unsafeInfixCall/unsafeInvoke.kt");
            }

            @TestMetadata("unsafeInvokeWithImplicitReceiver.kt")
            public void testUnsafeInvokeWithImplicitReceiver() throws Exception {
                runTest("idea/testData/quickfix/nullables/unsafeInfixCall/unsafeInvokeWithImplicitReceiver.kt");
            }

            @TestMetadata("unsafeInvokeWithReceiver.kt")
            public void testUnsafeInvokeWithReceiver() throws Exception {
                runTest("idea/testData/quickfix/nullables/unsafeInfixCall/unsafeInvokeWithReceiver.kt");
            }

            @TestMetadata("unsafePlus.kt")
            public void testUnsafePlus() throws Exception {
                runTest("idea/testData/quickfix/nullables/unsafeInfixCall/unsafePlus.kt");
            }

            @TestMetadata("unsafeSet.kt")
            public void testUnsafeSet() throws Exception {
                runTest("idea/testData/quickfix/nullables/unsafeInfixCall/unsafeSet.kt");
            }
        }
    }

    @TestMetadata("idea/testData/quickfix/obsoleteCoroutines")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class ObsoleteCoroutines extends AbstractQuickFixTest {
        private void runTest(String testDataFilePath) throws Exception {
            KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
        }

        public void testAllFilesPresentInObsoleteCoroutines() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/quickfix/obsoleteCoroutines"), Pattern.compile("^([\\w\\-_]+)\\.kt$"), TargetBackend.ANY, true);
        }

        @TestMetadata("buildIteratorImport.kt")
        public void testBuildIteratorImport() throws Exception {
            runTest("idea/testData/quickfix/obsoleteCoroutines/buildIteratorImport.kt");
        }

        @TestMetadata("buildSequence.kt")
        public void testBuildSequence() throws Exception {
            runTest("idea/testData/quickfix/obsoleteCoroutines/buildSequence.kt");
        }

        @TestMetadata("buildSequenceImport.kt")
        public void testBuildSequenceImport() throws Exception {
            runTest("idea/testData/quickfix/obsoleteCoroutines/buildSequenceImport.kt");
        }

        @TestMetadata("inProjectFix.kt")
        public void testInProjectFix() throws Exception {
            runTest("idea/testData/quickfix/obsoleteCoroutines/inProjectFix.kt");
        }

        @TestMetadata("resume.kt")
        public void testResume() throws Exception {
            runTest("idea/testData/quickfix/obsoleteCoroutines/resume.kt");
        }

        @TestMetadata("resumeWithException.kt")
        public void testResumeWithException() throws Exception {
            runTest("idea/testData/quickfix/obsoleteCoroutines/resumeWithException.kt");
        }

        @TestMetadata("starImport.kt")
        public void testStarImport() throws Exception {
            runTest("idea/testData/quickfix/obsoleteCoroutines/starImport.kt");
        }

        @TestMetadata("unresolvedKotlinxImport.kt")
        public void testUnresolvedKotlinxImport() throws Exception {
            runTest("idea/testData/quickfix/obsoleteCoroutines/unresolvedKotlinxImport.kt");
        }
    }

    @TestMetadata("idea/testData/quickfix/optimizeImports")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class OptimizeImports extends AbstractQuickFixTest {
        private void runTest(String testDataFilePath) throws Exception {
            KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
        }

        public void testAllFilesPresentInOptimizeImports() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/quickfix/optimizeImports"), Pattern.compile("^([\\w\\-_]+)\\.kt$"), TargetBackend.ANY, true);
        }

        @TestMetadata("destructuringAtTop.kt")
        public void testDestructuringAtTop() throws Exception {
            runTest("idea/testData/quickfix/optimizeImports/destructuringAtTop.kt");
        }

        @TestMetadata("fileRuntime.kt")
        public void testFileRuntime() throws Exception {
            runTest("idea/testData/quickfix/optimizeImports/fileRuntime.kt");
        }
    }

    @TestMetadata("idea/testData/quickfix/override")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class Override extends AbstractQuickFixTest {
        private void runTest(String testDataFilePath) throws Exception {
            KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
        }

        public void testAllFilesPresentInOverride() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/quickfix/override"), Pattern.compile("^([\\w\\-_]+)\\.kt$"), TargetBackend.ANY, true);
        }

        @TestMetadata("changeToInvocation.kt")
        public void testChangeToInvocation() throws Exception {
            runTest("idea/testData/quickfix/override/changeToInvocation.kt");
        }

        @TestMetadata("dontOfferToImplementMembersForExpectedClass.kt")
        public void testDontOfferToImplementMembersForExpectedClass() throws Exception {
            runTest("idea/testData/quickfix/override/dontOfferToImplementMembersForExpectedClass.kt");
        }

        @TestMetadata("implemenAsConstructorParameter.kt")
        public void testImplemenAsConstructorParameter() throws Exception {
            runTest("idea/testData/quickfix/override/implemenAsConstructorParameter.kt");
        }

        @TestMetadata("implemenAsConstructorParameterFunction.kt")
        public void testImplemenAsConstructorParameterFunction() throws Exception {
            runTest("idea/testData/quickfix/override/implemenAsConstructorParameterFunction.kt");
        }

        @TestMetadata("implemenAsConstructorParameterInObject.kt")
        public void testImplemenAsConstructorParameterInObject() throws Exception {
            runTest("idea/testData/quickfix/override/implemenAsConstructorParameterInObject.kt");
        }

        @TestMetadata("implementMember.kt")
        public void testImplementMember() throws Exception {
            runTest("idea/testData/quickfix/override/implementMember.kt");
        }

        @TestMetadata("implementMemberFromAbstractClass.kt")
        public void testImplementMemberFromAbstractClass() throws Exception {
            runTest("idea/testData/quickfix/override/implementMemberFromAbstractClass.kt");
        }

        @TestMetadata("overriddingMultipleFinalMethods.kt")
        public void testOverriddingMultipleFinalMethods() throws Exception {
            runTest("idea/testData/quickfix/override/overriddingMultipleFinalMethods.kt");
        }

        @TestMetadata("overridingDelegatedMethod.kt")
        public void testOverridingDelegatedMethod() throws Exception {
            runTest("idea/testData/quickfix/override/overridingDelegatedMethod.kt");
        }

        @TestMetadata("overridingFakeOverride.kt")
        public void testOverridingFakeOverride() throws Exception {
            runTest("idea/testData/quickfix/override/overridingFakeOverride.kt");
        }

        @TestMetadata("overridingFinalJavaMethod.kt")
        public void testOverridingFinalJavaMethod() throws Exception {
            runTest("idea/testData/quickfix/override/overridingFinalJavaMethod.kt");
        }

        @TestMetadata("overridingFinalMethod.kt")
        public void testOverridingFinalMethod() throws Exception {
            runTest("idea/testData/quickfix/override/overridingFinalMethod.kt");
        }

        @TestMetadata("overridingFinalMethodInLocal.kt")
        public void testOverridingFinalMethodInLocal() throws Exception {
            runTest("idea/testData/quickfix/override/overridingFinalMethodInLocal.kt");
        }

        @TestMetadata("overridingFinalProperty.kt")
        public void testOverridingFinalProperty() throws Exception {
            runTest("idea/testData/quickfix/override/overridingFinalProperty.kt");
        }

        @TestMetadata("overridingOpenMethodInFinalClass.kt")
        public void testOverridingOpenMethodInFinalClass() throws Exception {
            runTest("idea/testData/quickfix/override/overridingOpenMethodInFinalClass.kt");
        }

        @TestMetadata("parameterNameChangedAmbiguousRename.kt")
        public void testParameterNameChangedAmbiguousRename() throws Exception {
            runTest("idea/testData/quickfix/override/parameterNameChangedAmbiguousRename.kt");
        }

        @TestMetadata("parameterNameChangedMultipleOverrideRenamePossible.kt")
        public void testParameterNameChangedMultipleOverrideRenamePossible() throws Exception {
            runTest("idea/testData/quickfix/override/parameterNameChangedMultipleOverrideRenamePossible.kt");
        }

        @TestMetadata("parameterNameChangedRenamePossible.kt")
        public void testParameterNameChangedRenamePossible() throws Exception {
            runTest("idea/testData/quickfix/override/parameterNameChangedRenamePossible.kt");
        }

        @TestMetadata("virtualMethodHidden.kt")
        public void testVirtualMethodHidden() throws Exception {
            runTest("idea/testData/quickfix/override/virtualMethodHidden.kt");
        }

        @TestMetadata("idea/testData/quickfix/override/nothingToOverride")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class NothingToOverride extends AbstractQuickFixTest {
            private void runTest(String testDataFilePath) throws Exception {
                KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
            }

            @TestMetadata("addFunction.kt")
            public void testAddFunction() throws Exception {
                runTest("idea/testData/quickfix/override/nothingToOverride/addFunction.kt");
            }

            @TestMetadata("addFunctionAbstractClass.kt")
            public void testAddFunctionAbstractClass() throws Exception {
                runTest("idea/testData/quickfix/override/nothingToOverride/addFunctionAbstractClass.kt");
            }

            @TestMetadata("addFunctionInLocalDeclaration.kt")
            public void testAddFunctionInLocalDeclaration() throws Exception {
                runTest("idea/testData/quickfix/override/nothingToOverride/addFunctionInLocalDeclaration.kt");
            }

            @TestMetadata("addFunctionNoBody.kt")
            public void testAddFunctionNoBody() throws Exception {
                runTest("idea/testData/quickfix/override/nothingToOverride/addFunctionNoBody.kt");
            }

            @TestMetadata("addFunctionNonUnitReturnType.kt")
            public void testAddFunctionNonUnitReturnType() throws Exception {
                runTest("idea/testData/quickfix/override/nothingToOverride/addFunctionNonUnitReturnType.kt");
            }

            @TestMetadata("addFunctionTrait.kt")
            public void testAddFunctionTrait() throws Exception {
                runTest("idea/testData/quickfix/override/nothingToOverride/addFunctionTrait.kt");
            }

            @TestMetadata("addFunctionTwoSuperclasses.kt")
            public void testAddFunctionTwoSuperclasses() throws Exception {
                runTest("idea/testData/quickfix/override/nothingToOverride/addFunctionTwoSuperclasses.kt");
            }

            @TestMetadata("addFunctionTwoTraits.kt")
            public void testAddFunctionTwoTraits() throws Exception {
                runTest("idea/testData/quickfix/override/nothingToOverride/addFunctionTwoTraits.kt");
            }

            @TestMetadata("addParameter.kt")
            public void testAddParameter() throws Exception {
                runTest("idea/testData/quickfix/override/nothingToOverride/addParameter.kt");
            }

            @TestMetadata("addParameterGenericClass.kt")
            public void testAddParameterGenericClass() throws Exception {
                runTest("idea/testData/quickfix/override/nothingToOverride/addParameterGenericClass.kt");
            }

            @TestMetadata("addParameterMultiple.kt")
            public void testAddParameterMultiple() throws Exception {
                runTest("idea/testData/quickfix/override/nothingToOverride/addParameterMultiple.kt");
            }

            @TestMetadata("addParameterPreserveVisibility.kt")
            public void testAddParameterPreserveVisibility() throws Exception {
                runTest("idea/testData/quickfix/override/nothingToOverride/addParameterPreserveVisibility.kt");
            }

            @TestMetadata("addParameterTwoSupertraits.kt")
            public void testAddParameterTwoSupertraits() throws Exception {
                runTest("idea/testData/quickfix/override/nothingToOverride/addParameterTwoSupertraits.kt");
            }

            @TestMetadata("addParameterTwoSupertypes.kt")
            public void testAddParameterTwoSupertypes() throws Exception {
                runTest("idea/testData/quickfix/override/nothingToOverride/addParameterTwoSupertypes.kt");
            }

            public void testAllFilesPresentInNothingToOverride() throws Exception {
                KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/quickfix/override/nothingToOverride"), Pattern.compile("^([\\w\\-_]+)\\.kt$"), TargetBackend.ANY, true);
            }

            @TestMetadata("changeParameterType.kt")
            public void testChangeParameterType() throws Exception {
                runTest("idea/testData/quickfix/override/nothingToOverride/changeParameterType.kt");
            }

            @TestMetadata("changeParameterTypeAbstractSuperclass.kt")
            public void testChangeParameterTypeAbstractSuperclass() throws Exception {
                runTest("idea/testData/quickfix/override/nothingToOverride/changeParameterTypeAbstractSuperclass.kt");
            }

            @TestMetadata("changeParameterTypeInTrait.kt")
            public void testChangeParameterTypeInTrait() throws Exception {
                runTest("idea/testData/quickfix/override/nothingToOverride/changeParameterTypeInTrait.kt");
            }

            @TestMetadata("changeParameterTypeMatchNames.kt")
            public void testChangeParameterTypeMatchNames() throws Exception {
                runTest("idea/testData/quickfix/override/nothingToOverride/changeParameterTypeMatchNames.kt");
            }

            @TestMetadata("changeParameterTypeModifyOrder.kt")
            public void testChangeParameterTypeModifyOrder() throws Exception {
                runTest("idea/testData/quickfix/override/nothingToOverride/changeParameterTypeModifyOrder.kt");
            }

            @TestMetadata("changeParameterTypeOpenOverride.kt")
            public void testChangeParameterTypeOpenOverride() throws Exception {
                runTest("idea/testData/quickfix/override/nothingToOverride/changeParameterTypeOpenOverride.kt");
            }

            @TestMetadata("changeParameterTypeSingleExpressionFunction.kt")
            public void testChangeParameterTypeSingleExpressionFunction() throws Exception {
                runTest("idea/testData/quickfix/override/nothingToOverride/changeParameterTypeSingleExpressionFunction.kt");
            }

            @TestMetadata("changeParameterTypeSuperTrait.kt")
            public void testChangeParameterTypeSuperTrait() throws Exception {
                runTest("idea/testData/quickfix/override/nothingToOverride/changeParameterTypeSuperTrait.kt");
            }

            @TestMetadata("changeReturnType.kt")
            public void testChangeReturnType() throws Exception {
                runTest("idea/testData/quickfix/override/nothingToOverride/changeReturnType.kt");
            }

            @TestMetadata("doNotLooseAnnotations.kt")
            public void testDoNotLooseAnnotations() throws Exception {
                runTest("idea/testData/quickfix/override/nothingToOverride/doNotLooseAnnotations.kt");
            }

            @TestMetadata("noDefaultValuesInOverride.kt")
            public void testNoDefaultValuesInOverride() throws Exception {
                runTest("idea/testData/quickfix/override/nothingToOverride/noDefaultValuesInOverride.kt");
            }

            @TestMetadata("noOpenSuperFunction.kt")
            public void testNoOpenSuperFunction() throws Exception {
                runTest("idea/testData/quickfix/override/nothingToOverride/noOpenSuperFunction.kt");
            }

            @TestMetadata("overrideJavaMethod.kt")
            public void testOverrideJavaMethod() throws Exception {
                runTest("idea/testData/quickfix/override/nothingToOverride/overrideJavaMethod.kt");
            }

            @TestMetadata("removeFunctionReciever.kt")
            public void testRemoveFunctionReciever() throws Exception {
                runTest("idea/testData/quickfix/override/nothingToOverride/removeFunctionReciever.kt");
            }

            @TestMetadata("removeOverride.kt")
            public void testRemoveOverride() throws Exception {
                runTest("idea/testData/quickfix/override/nothingToOverride/removeOverride.kt");
            }

            @TestMetadata("removeParameter.kt")
            public void testRemoveParameter() throws Exception {
                runTest("idea/testData/quickfix/override/nothingToOverride/removeParameter.kt");
            }

            @TestMetadata("removeParameterTwoTraits.kt")
            public void testRemoveParameterTwoTraits() throws Exception {
                runTest("idea/testData/quickfix/override/nothingToOverride/removeParameterTwoTraits.kt");
            }

            @TestMetadata("swapParametersGenericClass.kt")
            public void testSwapParametersGenericClass() throws Exception {
                runTest("idea/testData/quickfix/override/nothingToOverride/swapParametersGenericClass.kt");
            }
        }

        @TestMetadata("idea/testData/quickfix/override/typeMismatchOnOverride")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class TypeMismatchOnOverride extends AbstractQuickFixTest {
            private void runTest(String testDataFilePath) throws Exception {
                KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
            }

            public void testAllFilesPresentInTypeMismatchOnOverride() throws Exception {
                KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/quickfix/override/typeMismatchOnOverride"), Pattern.compile("^([\\w\\-_]+)\\.kt$"), TargetBackend.ANY, true);
            }

            @TestMetadata("cantChangeMultipleOverriddenPropertiesTypes.kt")
            public void testCantChangeMultipleOverriddenPropertiesTypes() throws Exception {
                runTest("idea/testData/quickfix/override/typeMismatchOnOverride/cantChangeMultipleOverriddenPropertiesTypes.kt");
            }

            @TestMetadata("cantChangeOverriddenPropertyTypeToMatchOverridingProperty.kt")
            public void testCantChangeOverriddenPropertyTypeToMatchOverridingProperty() throws Exception {
                runTest("idea/testData/quickfix/override/typeMismatchOnOverride/cantChangeOverriddenPropertyTypeToMatchOverridingProperty.kt");
            }

            @TestMetadata("cantChangePropertyTypeToMatchOverridenProperties.kt")
            public void testCantChangePropertyTypeToMatchOverridenProperties() throws Exception {
                runTest("idea/testData/quickfix/override/typeMismatchOnOverride/cantChangePropertyTypeToMatchOverridenProperties.kt");
            }

            @TestMetadata("cantChangeReturnTypeOfOverriddenFunction.kt")
            public void testCantChangeReturnTypeOfOverriddenFunction() throws Exception {
                runTest("idea/testData/quickfix/override/typeMismatchOnOverride/cantChangeReturnTypeOfOverriddenFunction.kt");
            }

            @TestMetadata("changeOverriddenPropertyType1.kt")
            public void testChangeOverriddenPropertyType1() throws Exception {
                runTest("idea/testData/quickfix/override/typeMismatchOnOverride/changeOverriddenPropertyType1.kt");
            }

            @TestMetadata("changeOverriddenPropertyType2.kt")
            public void testChangeOverriddenPropertyType2() throws Exception {
                runTest("idea/testData/quickfix/override/typeMismatchOnOverride/changeOverriddenPropertyType2.kt");
            }

            @TestMetadata("changeOverridingPropertyTypeToFunctionType.kt")
            public void testChangeOverridingPropertyTypeToFunctionType() throws Exception {
                runTest("idea/testData/quickfix/override/typeMismatchOnOverride/changeOverridingPropertyTypeToFunctionType.kt");
            }

            @TestMetadata("changeReturnTypeOfOverriddenFunction.kt")
            public void testChangeReturnTypeOfOverriddenFunction() throws Exception {
                runTest("idea/testData/quickfix/override/typeMismatchOnOverride/changeReturnTypeOfOverriddenFunction.kt");
            }

            @TestMetadata("namedFunctionReturnOverrideInsideVariableInitializer.kt")
            public void testNamedFunctionReturnOverrideInsideVariableInitializer() throws Exception {
                runTest("idea/testData/quickfix/override/typeMismatchOnOverride/namedFunctionReturnOverrideInsideVariableInitializer.kt");
            }

            @TestMetadata("objectInsideBody.kt")
            public void testObjectInsideBody() throws Exception {
                runTest("idea/testData/quickfix/override/typeMismatchOnOverride/objectInsideBody.kt");
            }

            @TestMetadata("propertyReturnTypeMismatchOnOverride.kt")
            public void testPropertyReturnTypeMismatchOnOverride() throws Exception {
                runTest("idea/testData/quickfix/override/typeMismatchOnOverride/propertyReturnTypeMismatchOnOverride.kt");
            }

            @TestMetadata("propertyTypeMismatchOnOverrideIntLong.kt")
            public void testPropertyTypeMismatchOnOverrideIntLong() throws Exception {
                runTest("idea/testData/quickfix/override/typeMismatchOnOverride/propertyTypeMismatchOnOverrideIntLong.kt");
            }

            @TestMetadata("propertyTypeMismatchOnOverrideIntUnit.kt")
            public void testPropertyTypeMismatchOnOverrideIntUnit() throws Exception {
                runTest("idea/testData/quickfix/override/typeMismatchOnOverride/propertyTypeMismatchOnOverrideIntUnit.kt");
            }

            @TestMetadata("returnTypeMismatchOnMultipleOverride.kt")
            public void testReturnTypeMismatchOnMultipleOverride() throws Exception {
                runTest("idea/testData/quickfix/override/typeMismatchOnOverride/returnTypeMismatchOnMultipleOverride.kt");
            }

            @TestMetadata("returnTypeMismatchOnMultipleOverrideAmbiguity.kt")
            public void testReturnTypeMismatchOnMultipleOverrideAmbiguity() throws Exception {
                runTest("idea/testData/quickfix/override/typeMismatchOnOverride/returnTypeMismatchOnMultipleOverrideAmbiguity.kt");
            }

            @TestMetadata("returnTypeMismatchOnOverrideIntLong.kt")
            public void testReturnTypeMismatchOnOverrideIntLong() throws Exception {
                runTest("idea/testData/quickfix/override/typeMismatchOnOverride/returnTypeMismatchOnOverrideIntLong.kt");
            }

            @TestMetadata("returnTypeMismatchOnOverrideIntUnit.kt")
            public void testReturnTypeMismatchOnOverrideIntUnit() throws Exception {
                runTest("idea/testData/quickfix/override/typeMismatchOnOverride/returnTypeMismatchOnOverrideIntUnit.kt");
            }

            @TestMetadata("returnTypeMismatchOnOverrideUnitInt.kt")
            public void testReturnTypeMismatchOnOverrideUnitInt() throws Exception {
                runTest("idea/testData/quickfix/override/typeMismatchOnOverride/returnTypeMismatchOnOverrideUnitInt.kt");
            }
        }
    }

    @TestMetadata("idea/testData/quickfix/platformClasses")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class PlatformClasses extends AbstractQuickFixTest {
        private void runTest(String testDataFilePath) throws Exception {
            KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
        }

        public void testAllFilesPresentInPlatformClasses() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/quickfix/platformClasses"), Pattern.compile("^([\\w\\-_]+)\\.kt$"), TargetBackend.ANY, true);
        }

        @TestMetadata("mapPlatformClassToKotlin1.kt")
        public void testMapPlatformClassToKotlin1() throws Exception {
            runTest("idea/testData/quickfix/platformClasses/mapPlatformClassToKotlin1.kt");
        }

        @TestMetadata("mapPlatformClassToKotlin2.kt")
        public void testMapPlatformClassToKotlin2() throws Exception {
            runTest("idea/testData/quickfix/platformClasses/mapPlatformClassToKotlin2.kt");
        }

        @TestMetadata("mapPlatformClassToKotlin3.kt")
        public void testMapPlatformClassToKotlin3() throws Exception {
            runTest("idea/testData/quickfix/platformClasses/mapPlatformClassToKotlin3.kt");
        }

        @TestMetadata("mapPlatformClassToKotlin4.kt")
        public void testMapPlatformClassToKotlin4() throws Exception {
            runTest("idea/testData/quickfix/platformClasses/mapPlatformClassToKotlin4.kt");
        }
    }

    @TestMetadata("idea/testData/quickfix/platformTypesInspection")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class PlatformTypesInspection extends AbstractQuickFixTest {
        private void runTest(String testDataFilePath) throws Exception {
            KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
        }

        public void testAllFilesPresentInPlatformTypesInspection() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/quickfix/platformTypesInspection"), Pattern.compile("^([\\w\\-_]+)\\.kt$"), TargetBackend.ANY, true);
        }

        @TestMetadata("nestedNoAssertRuntime.kt")
        public void testNestedNoAssertRuntime() throws Exception {
            runTest("idea/testData/quickfix/platformTypesInspection/nestedNoAssertRuntime.kt");
        }

        @TestMetadata("nestedRuntime.kt")
        public void testNestedRuntime() throws Exception {
            runTest("idea/testData/quickfix/platformTypesInspection/nestedRuntime.kt");
        }

        @TestMetadata("nullableAssertRuntime.kt")
        public void testNullableAssertRuntime() throws Exception {
            runTest("idea/testData/quickfix/platformTypesInspection/nullableAssertRuntime.kt");
        }

        @TestMetadata("nullableRuntime.kt")
        public void testNullableRuntime() throws Exception {
            runTest("idea/testData/quickfix/platformTypesInspection/nullableRuntime.kt");
        }
    }

    @TestMetadata("idea/testData/quickfix/primitiveCastToConversion")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class PrimitiveCastToConversion extends AbstractQuickFixTest {
        private void runTest(String testDataFilePath) throws Exception {
            KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
        }

        public void testAllFilesPresentInPrimitiveCastToConversion() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/quickfix/primitiveCastToConversion"), Pattern.compile("^([\\w\\-_]+)\\.kt$"), TargetBackend.ANY, true);
        }

        @TestMetadata("boolean.kt")
        public void testBoolean() throws Exception {
            runTest("idea/testData/quickfix/primitiveCastToConversion/boolean.kt");
        }

        @TestMetadata("charToShort.kt")
        public void testCharToShort() throws Exception {
            runTest("idea/testData/quickfix/primitiveCastToConversion/charToShort.kt");
        }

        @TestMetadata("intToByte.kt")
        public void testIntToByte() throws Exception {
            runTest("idea/testData/quickfix/primitiveCastToConversion/intToByte.kt");
        }

        @TestMetadata("longToFloat.kt")
        public void testLongToFloat() throws Exception {
            runTest("idea/testData/quickfix/primitiveCastToConversion/longToFloat.kt");
        }
    }

    @TestMetadata("idea/testData/quickfix/properties")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class Properties extends AbstractQuickFixTest {
        private void runTest(String testDataFilePath) throws Exception {
            KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
        }

        public void testAllFilesPresentInProperties() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/quickfix/properties"), Pattern.compile("^([\\w\\-_]+)\\.kt$"), TargetBackend.ANY, true);
        }

        @TestMetadata("idea/testData/quickfix/properties/extensionPropertyInitializerToGetter")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class ExtensionPropertyInitializerToGetter extends AbstractQuickFixTest {
            private void runTest(String testDataFilePath) throws Exception {
                KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
            }

            public void testAllFilesPresentInExtensionPropertyInitializerToGetter() throws Exception {
                KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/quickfix/properties/extensionPropertyInitializerToGetter"), Pattern.compile("^([\\w\\-_]+)\\.kt$"), TargetBackend.ANY, true);
            }

            @TestMetadata("baseCase.kt")
            public void testBaseCase() throws Exception {
                runTest("idea/testData/quickfix/properties/extensionPropertyInitializerToGetter/baseCase.kt");
            }

            @TestMetadata("baseCaseVar.kt")
            public void testBaseCaseVar() throws Exception {
                runTest("idea/testData/quickfix/properties/extensionPropertyInitializerToGetter/baseCaseVar.kt");
            }

            @TestMetadata("baseCaseWithoutTypeAnnotation.kt")
            public void testBaseCaseWithoutTypeAnnotation() throws Exception {
                runTest("idea/testData/quickfix/properties/extensionPropertyInitializerToGetter/baseCaseWithoutTypeAnnotation.kt");
            }

            @TestMetadata("dontShowQuickfixOnExistingAccessors.kt")
            public void testDontShowQuickfixOnExistingAccessors() throws Exception {
                runTest("idea/testData/quickfix/properties/extensionPropertyInitializerToGetter/dontShowQuickfixOnExistingAccessors.kt");
            }

            @TestMetadata("insertGetterBeforeExistingSetter.kt")
            public void testInsertGetterBeforeExistingSetter() throws Exception {
                runTest("idea/testData/quickfix/properties/extensionPropertyInitializerToGetter/insertGetterBeforeExistingSetter.kt");
            }
        }
    }

    @TestMetadata("idea/testData/quickfix/protectedInFinal")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class ProtectedInFinal extends AbstractQuickFixTest {
        private void runTest(String testDataFilePath) throws Exception {
            KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
        }

        public void testAllFilesPresentInProtectedInFinal() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/quickfix/protectedInFinal"), Pattern.compile("^([\\w\\-_]+)\\.kt$"), TargetBackend.ANY, true);
        }

        @TestMetadata("protected.kt")
        public void testProtected() throws Exception {
            runTest("idea/testData/quickfix/protectedInFinal/protected.kt");
        }

        @TestMetadata("protected2.kt")
        public void testProtected2() throws Exception {
            runTest("idea/testData/quickfix/protectedInFinal/protected2.kt");
        }
    }

    @TestMetadata("idea/testData/quickfix/redundantIf")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class RedundantIf extends AbstractQuickFixTest {
        private void runTest(String testDataFilePath) throws Exception {
            KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
        }

        public void testAllFilesPresentInRedundantIf() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/quickfix/redundantIf"), Pattern.compile("^([\\w\\-_]+)\\.kt$"), TargetBackend.ANY, true);
        }

        @TestMetadata("assignExpression.kt")
        public void testAssignExpression() throws Exception {
            runTest("idea/testData/quickfix/redundantIf/assignExpression.kt");
        }

        @TestMetadata("assignment.kt")
        public void testAssignment() throws Exception {
            runTest("idea/testData/quickfix/redundantIf/assignment.kt");
        }

        @TestMetadata("assignmentFake.kt")
        public void testAssignmentFake() throws Exception {
            runTest("idea/testData/quickfix/redundantIf/assignmentFake.kt");
        }

        @TestMetadata("expression.kt")
        public void testExpression() throws Exception {
            runTest("idea/testData/quickfix/redundantIf/expression.kt");
        }

        @TestMetadata("expressionBody.kt")
        public void testExpressionBody() throws Exception {
            runTest("idea/testData/quickfix/redundantIf/expressionBody.kt");
        }

        @TestMetadata("labeledReturn.kt")
        public void testLabeledReturn() throws Exception {
            runTest("idea/testData/quickfix/redundantIf/labeledReturn.kt");
        }

        @TestMetadata("negate.kt")
        public void testNegate() throws Exception {
            runTest("idea/testData/quickfix/redundantIf/negate.kt");
        }

        @TestMetadata("simple.kt")
        public void testSimple() throws Exception {
            runTest("idea/testData/quickfix/redundantIf/simple.kt");
        }
    }

    @TestMetadata("idea/testData/quickfix/redundantInline")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class RedundantInline extends AbstractQuickFixTest {
        private void runTest(String testDataFilePath) throws Exception {
            KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
        }

        public void testAllFilesPresentInRedundantInline() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/quickfix/redundantInline"), Pattern.compile("^([\\w\\-_]+)\\.kt$"), TargetBackend.ANY, true);
        }

        @TestMetadata("function.kt")
        public void testFunction() throws Exception {
            runTest("idea/testData/quickfix/redundantInline/function.kt");
        }
    }

    @TestMetadata("idea/testData/quickfix/redundantLateinit")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class RedundantLateinit extends AbstractQuickFixTest {
        private void runTest(String testDataFilePath) throws Exception {
            KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
        }

        public void testAllFilesPresentInRedundantLateinit() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/quickfix/redundantLateinit"), Pattern.compile("^([\\w\\-_]+)\\.kt$"), TargetBackend.ANY, true);
        }

        @TestMetadata("simple.kt")
        public void testSimple() throws Exception {
            runTest("idea/testData/quickfix/redundantLateinit/simple.kt");
        }
    }

    @TestMetadata("idea/testData/quickfix/redundantModalityModifier")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class RedundantModalityModifier extends AbstractQuickFixTest {
        private void runTest(String testDataFilePath) throws Exception {
            KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
        }

        public void testAllFilesPresentInRedundantModalityModifier() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/quickfix/redundantModalityModifier"), Pattern.compile("^([\\w\\-_]+)\\.kt$"), TargetBackend.ANY, true);
        }

        @TestMetadata("redundantAbstract.kt")
        public void testRedundantAbstract() throws Exception {
            runTest("idea/testData/quickfix/redundantModalityModifier/redundantAbstract.kt");
        }

        @TestMetadata("simple.kt")
        public void testSimple() throws Exception {
            runTest("idea/testData/quickfix/redundantModalityModifier/simple.kt");
        }
    }

    @TestMetadata("idea/testData/quickfix/redundantSemicolon")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class RedundantSemicolon extends AbstractQuickFixTest {
        private void runTest(String testDataFilePath) throws Exception {
            KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
        }

        @TestMetadata("afterImport.kt")
        public void testAfterImport() throws Exception {
            runTest("idea/testData/quickfix/redundantSemicolon/afterImport.kt");
        }

        @TestMetadata("afterStatement.kt")
        public void testAfterStatement() throws Exception {
            runTest("idea/testData/quickfix/redundantSemicolon/afterStatement.kt");
        }

        public void testAllFilesPresentInRedundantSemicolon() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/quickfix/redundantSemicolon"), Pattern.compile("^([\\w\\-_]+)\\.kt$"), TargetBackend.ANY, true);
        }
    }

    @TestMetadata("idea/testData/quickfix/redundantSuspend")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class RedundantSuspend extends AbstractQuickFixTest {
        private void runTest(String testDataFilePath) throws Exception {
            KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
        }

        public void testAllFilesPresentInRedundantSuspend() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/quickfix/redundantSuspend"), Pattern.compile("^([\\w\\-_]+)\\.kt$"), TargetBackend.ANY, true);
        }

        @TestMetadata("inline.kt")
        public void testInline() throws Exception {
            runTest("idea/testData/quickfix/redundantSuspend/inline.kt");
        }
    }

    @TestMetadata("idea/testData/quickfix/redundantVisibilityModifier")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class RedundantVisibilityModifier extends AbstractQuickFixTest {
        private void runTest(String testDataFilePath) throws Exception {
            KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
        }

        public void testAllFilesPresentInRedundantVisibilityModifier() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/quickfix/redundantVisibilityModifier"), Pattern.compile("^([\\w\\-_]+)\\.kt$"), TargetBackend.ANY, true);
        }

        @TestMetadata("simple.kt")
        public void testSimple() throws Exception {
            runTest("idea/testData/quickfix/redundantVisibilityModifier/simple.kt");
        }
    }

    @TestMetadata("idea/testData/quickfix/removeAnnotation")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class RemoveAnnotation extends AbstractQuickFixTest {
        private void runTest(String testDataFilePath) throws Exception {
            KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
        }

        public void testAllFilesPresentInRemoveAnnotation() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/quickfix/removeAnnotation"), Pattern.compile("^([\\w\\-_]+)\\.kt$"), TargetBackend.ANY, true);
        }

        @TestMetadata("jvmOverloads.kt")
        public void testJvmOverloads() throws Exception {
            runTest("idea/testData/quickfix/removeAnnotation/jvmOverloads.kt");
        }

        @TestMetadata("jvmOverloadsOnAnnotationClassConstructor.kt")
        public void testJvmOverloadsOnAnnotationClassConstructor() throws Exception {
            runTest("idea/testData/quickfix/removeAnnotation/jvmOverloadsOnAnnotationClassConstructor.kt");
        }
    }

    @TestMetadata("idea/testData/quickfix/removeAtFromAnnotationArgument")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class RemoveAtFromAnnotationArgument extends AbstractQuickFixTest {
        private void runTest(String testDataFilePath) throws Exception {
            KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
        }

        public void testAllFilesPresentInRemoveAtFromAnnotationArgument() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/quickfix/removeAtFromAnnotationArgument"), Pattern.compile("^([\\w\\-_]+)\\.kt$"), TargetBackend.ANY, true);
        }

        @TestMetadata("arrayParam.kt")
        public void testArrayParam() throws Exception {
            runTest("idea/testData/quickfix/removeAtFromAnnotationArgument/arrayParam.kt");
        }

        @TestMetadata("namedParam.kt")
        public void testNamedParam() throws Exception {
            runTest("idea/testData/quickfix/removeAtFromAnnotationArgument/namedParam.kt");
        }

        @TestMetadata("simple.kt")
        public void testSimple() throws Exception {
            runTest("idea/testData/quickfix/removeAtFromAnnotationArgument/simple.kt");
        }
    }

    @TestMetadata("idea/testData/quickfix/removeDefaultParameterValue")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class RemoveDefaultParameterValue extends AbstractQuickFixTest {
        private void runTest(String testDataFilePath) throws Exception {
            KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
        }

        @TestMetadata("actualFunctionWithDefaultArguments.kt")
        public void testActualFunctionWithDefaultArguments() throws Exception {
            runTest("idea/testData/quickfix/removeDefaultParameterValue/actualFunctionWithDefaultArguments.kt");
        }

        public void testAllFilesPresentInRemoveDefaultParameterValue() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/quickfix/removeDefaultParameterValue"), Pattern.compile("^([\\w\\-_]+)\\.kt$"), TargetBackend.ANY, true);
        }

        @TestMetadata("defaultValueNotAllowedInOverride.kt")
        public void testDefaultValueNotAllowedInOverride() throws Exception {
            runTest("idea/testData/quickfix/removeDefaultParameterValue/defaultValueNotAllowedInOverride.kt");
        }

        @TestMetadata("hasComment.kt")
        public void testHasComment() throws Exception {
            runTest("idea/testData/quickfix/removeDefaultParameterValue/hasComment.kt");
        }
    }

    @TestMetadata("idea/testData/quickfix/removeFinalUpperBound")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class RemoveFinalUpperBound extends AbstractQuickFixTest {
        private void runTest(String testDataFilePath) throws Exception {
            KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
        }

        public void testAllFilesPresentInRemoveFinalUpperBound() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/quickfix/removeFinalUpperBound"), Pattern.compile("^([\\w\\-_]+)\\.kt$"), TargetBackend.ANY, true);
        }

        @TestMetadata("basic.kt")
        public void testBasic() throws Exception {
            runTest("idea/testData/quickfix/removeFinalUpperBound/basic.kt");
        }

        @TestMetadata("function.kt")
        public void testFunction() throws Exception {
            runTest("idea/testData/quickfix/removeFinalUpperBound/function.kt");
        }
    }

    @TestMetadata("idea/testData/quickfix/removeNoConstructor")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class RemoveNoConstructor extends AbstractQuickFixTest {
        private void runTest(String testDataFilePath) throws Exception {
            KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
        }

        public void testAllFilesPresentInRemoveNoConstructor() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/quickfix/removeNoConstructor"), Pattern.compile("^([\\w\\-_]+)\\.kt$"), TargetBackend.ANY, true);
        }

        @TestMetadata("basic.kt")
        public void testBasic() throws Exception {
            runTest("idea/testData/quickfix/removeNoConstructor/basic.kt");
        }
    }

    @TestMetadata("idea/testData/quickfix/removeRedundantAssignment")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class RemoveRedundantAssignment extends AbstractQuickFixTest {
        private void runTest(String testDataFilePath) throws Exception {
            KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
        }

        public void testAllFilesPresentInRemoveRedundantAssignment() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/quickfix/removeRedundantAssignment"), Pattern.compile("^([\\w\\-_]+)\\.kt$"), TargetBackend.ANY, true);
        }

        @TestMetadata("constant.kt")
        public void testConstant() throws Exception {
            runTest("idea/testData/quickfix/removeRedundantAssignment/constant.kt");
        }

        @TestMetadata("functionCall.kt")
        public void testFunctionCall() throws Exception {
            runTest("idea/testData/quickfix/removeRedundantAssignment/functionCall.kt");
        }

        @TestMetadata("notRedundant.kt")
        public void testNotRedundant() throws Exception {
            runTest("idea/testData/quickfix/removeRedundantAssignment/notRedundant.kt");
        }

        @TestMetadata("simpleRef.kt")
        public void testSimpleRef() throws Exception {
            runTest("idea/testData/quickfix/removeRedundantAssignment/simpleRef.kt");
        }
    }

    @TestMetadata("idea/testData/quickfix/removeRedundantInitializer")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class RemoveRedundantInitializer extends AbstractQuickFixTest {
        private void runTest(String testDataFilePath) throws Exception {
            KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
        }

        public void testAllFilesPresentInRemoveRedundantInitializer() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/quickfix/removeRedundantInitializer"), Pattern.compile("^([\\w\\-_]+)\\.kt$"), TargetBackend.ANY, true);
        }

        @TestMetadata("simple.kt")
        public void testSimple() throws Exception {
            runTest("idea/testData/quickfix/removeRedundantInitializer/simple.kt");
        }
    }

    @TestMetadata("idea/testData/quickfix/removeSingleLambdaParameter")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class RemoveSingleLambdaParameter extends AbstractQuickFixTest {
        private void runTest(String testDataFilePath) throws Exception {
            KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
        }

        public void testAllFilesPresentInRemoveSingleLambdaParameter() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/quickfix/removeSingleLambdaParameter"), Pattern.compile("^([\\w\\-_]+)\\.kt$"), TargetBackend.ANY, true);
        }

        @TestMetadata("multiple.kt")
        public void testMultiple() throws Exception {
            runTest("idea/testData/quickfix/removeSingleLambdaParameter/multiple.kt");
        }

        @TestMetadata("propertyWithExplicitType.kt")
        public void testPropertyWithExplicitType() throws Exception {
            runTest("idea/testData/quickfix/removeSingleLambdaParameter/propertyWithExplicitType.kt");
        }

        @TestMetadata("propertyWithImplicitType.kt")
        public void testPropertyWithImplicitType() throws Exception {
            runTest("idea/testData/quickfix/removeSingleLambdaParameter/propertyWithImplicitType.kt");
        }

        @TestMetadata("simple.kt")
        public void testSimple() throws Exception {
            runTest("idea/testData/quickfix/removeSingleLambdaParameter/simple.kt");
        }
    }

    @TestMetadata("idea/testData/quickfix/removeSuspend")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class RemoveSuspend extends AbstractQuickFixTest {
        private void runTest(String testDataFilePath) throws Exception {
            KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
        }

        public void testAllFilesPresentInRemoveSuspend() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/quickfix/removeSuspend"), Pattern.compile("^([\\w\\-_]+)\\.kt$"), TargetBackend.ANY, true);
        }

        @TestMetadata("fakeOverride.kt")
        public void testFakeOverride() throws Exception {
            runTest("idea/testData/quickfix/removeSuspend/fakeOverride.kt");
        }

        @TestMetadata("fakeOverride2.kt")
        public void testFakeOverride2() throws Exception {
            runTest("idea/testData/quickfix/removeSuspend/fakeOverride2.kt");
        }

        @TestMetadata("middleClass.kt")
        public void testMiddleClass() throws Exception {
            runTest("idea/testData/quickfix/removeSuspend/middleClass.kt");
        }

        @TestMetadata("middleClass2.kt")
        public void testMiddleClass2() throws Exception {
            runTest("idea/testData/quickfix/removeSuspend/middleClass2.kt");
        }

        @TestMetadata("nonOverridden.kt")
        public void testNonOverridden() throws Exception {
            runTest("idea/testData/quickfix/removeSuspend/nonOverridden.kt");
        }

        @TestMetadata("nonOverridden2.kt")
        public void testNonOverridden2() throws Exception {
            runTest("idea/testData/quickfix/removeSuspend/nonOverridden2.kt");
        }
    }

    @TestMetadata("idea/testData/quickfix/removeToStringInStringTemplate")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class RemoveToStringInStringTemplate extends AbstractQuickFixTest {
        private void runTest(String testDataFilePath) throws Exception {
            KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
        }

        public void testAllFilesPresentInRemoveToStringInStringTemplate() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/quickfix/removeToStringInStringTemplate"), Pattern.compile("^([\\w\\-_]+)\\.kt$"), TargetBackend.ANY, true);
        }

        @TestMetadata("call.kt")
        public void testCall() throws Exception {
            runTest("idea/testData/quickfix/removeToStringInStringTemplate/call.kt");
        }

        @TestMetadata("name.kt")
        public void testName() throws Exception {
            runTest("idea/testData/quickfix/removeToStringInStringTemplate/name.kt");
        }

        @TestMetadata("nameWithPostfix.kt")
        public void testNameWithPostfix() throws Exception {
            runTest("idea/testData/quickfix/removeToStringInStringTemplate/nameWithPostfix.kt");
        }

        @TestMetadata("necessaryBrackets1.kt")
        public void testNecessaryBrackets1() throws Exception {
            runTest("idea/testData/quickfix/removeToStringInStringTemplate/necessaryBrackets1.kt");
        }

        @TestMetadata("necessaryBrackets2.kt")
        public void testNecessaryBrackets2() throws Exception {
            runTest("idea/testData/quickfix/removeToStringInStringTemplate/necessaryBrackets2.kt");
        }

        @TestMetadata("simple.kt")
        public void testSimple() throws Exception {
            runTest("idea/testData/quickfix/removeToStringInStringTemplate/simple.kt");
        }
    }

    @TestMetadata("idea/testData/quickfix/removeTypeVariance")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class RemoveTypeVariance extends AbstractQuickFixTest {
        private void runTest(String testDataFilePath) throws Exception {
            KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
        }

        public void testAllFilesPresentInRemoveTypeVariance() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/quickfix/removeTypeVariance"), Pattern.compile("^([\\w\\-_]+)\\.kt$"), TargetBackend.ANY, true);
        }

        @TestMetadata("in.kt")
        public void testIn() throws Exception {
            runTest("idea/testData/quickfix/removeTypeVariance/in.kt");
        }

        @TestMetadata("out.kt")
        public void testOut() throws Exception {
            runTest("idea/testData/quickfix/removeTypeVariance/out.kt");
        }
    }

    @TestMetadata("idea/testData/quickfix/removeUnused")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class RemoveUnused extends AbstractQuickFixTest {
        private void runTest(String testDataFilePath) throws Exception {
            KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
        }

        public void testAllFilesPresentInRemoveUnused() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/quickfix/removeUnused"), Pattern.compile("^([\\w\\-_]+)\\.kt$"), TargetBackend.ANY, true);
        }

        @TestMetadata("deledage.kt")
        public void testDeledage() throws Exception {
            runTest("idea/testData/quickfix/removeUnused/deledage.kt");
        }

        @TestMetadata("importEnumValues.kt")
        public void testImportEnumValues() throws Exception {
            runTest("idea/testData/quickfix/removeUnused/importEnumValues.kt");
        }

        @TestMetadata("importObjectFun.kt")
        public void testImportObjectFun() throws Exception {
            runTest("idea/testData/quickfix/removeUnused/importObjectFun.kt");
        }

        @TestMetadata("notTriangle.kt")
        public void testNotTriangle() throws Exception {
            runTest("idea/testData/quickfix/removeUnused/notTriangle.kt");
        }

        @TestMetadata("triangle.kt")
        public void testTriangle() throws Exception {
            runTest("idea/testData/quickfix/removeUnused/triangle.kt");
        }

        @TestMetadata("triangle2.kt")
        public void testTriangle2() throws Exception {
            runTest("idea/testData/quickfix/removeUnused/triangle2.kt");
        }

        @TestMetadata("unusedClass.kt")
        public void testUnusedClass() throws Exception {
            runTest("idea/testData/quickfix/removeUnused/unusedClass.kt");
        }

        @TestMetadata("unusedConstructor.kt")
        public void testUnusedConstructor() throws Exception {
            runTest("idea/testData/quickfix/removeUnused/unusedConstructor.kt");
        }

        @TestMetadata("unusedDelegatedConstructor.kt")
        public void testUnusedDelegatedConstructor() throws Exception {
            runTest("idea/testData/quickfix/removeUnused/unusedDelegatedConstructor.kt");
        }

        @TestMetadata("unusedDelegatedConstructorSuper.kt")
        public void testUnusedDelegatedConstructorSuper() throws Exception {
            runTest("idea/testData/quickfix/removeUnused/unusedDelegatedConstructorSuper.kt");
        }

        @TestMetadata("unusedFunction.kt")
        public void testUnusedFunction() throws Exception {
            runTest("idea/testData/quickfix/removeUnused/unusedFunction.kt");
        }

        @TestMetadata("unusedProperty.kt")
        public void testUnusedProperty() throws Exception {
            runTest("idea/testData/quickfix/removeUnused/unusedProperty.kt");
        }

        @TestMetadata("unusedPropertyAsConstructorParameter.kt")
        public void testUnusedPropertyAsConstructorParameter() throws Exception {
            runTest("idea/testData/quickfix/removeUnused/unusedPropertyAsConstructorParameter.kt");
        }

        @TestMetadata("unusedPropertyAsConstructorParameter2.kt")
        public void testUnusedPropertyAsConstructorParameter2() throws Exception {
            runTest("idea/testData/quickfix/removeUnused/unusedPropertyAsConstructorParameter2.kt");
        }

        @TestMetadata("unusedTypeParameter.kt")
        public void testUnusedTypeParameter() throws Exception {
            runTest("idea/testData/quickfix/removeUnused/unusedTypeParameter.kt");
        }

        @TestMetadata("usedClassAsAlias.kt")
        public void testUsedClassAsAlias() throws Exception {
            runTest("idea/testData/quickfix/removeUnused/usedClassAsAlias.kt");
        }

        @TestMetadata("usedFunAsAlias.kt")
        public void testUsedFunAsAlias() throws Exception {
            runTest("idea/testData/quickfix/removeUnused/usedFunAsAlias.kt");
        }

        @TestMetadata("usedObjectAsAlias.kt")
        public void testUsedObjectAsAlias() throws Exception {
            runTest("idea/testData/quickfix/removeUnused/usedObjectAsAlias.kt");
        }

        @TestMetadata("usedVarAsAlias.kt")
        public void testUsedVarAsAlias() throws Exception {
            runTest("idea/testData/quickfix/removeUnused/usedVarAsAlias.kt");
        }
    }

    @TestMetadata("idea/testData/quickfix/removeUnusedReceiver")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class RemoveUnusedReceiver extends AbstractQuickFixTest {
        private void runTest(String testDataFilePath) throws Exception {
            KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
        }

        public void testAllFilesPresentInRemoveUnusedReceiver() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/quickfix/removeUnusedReceiver"), Pattern.compile("^([\\w\\-_]+)\\.kt$"), TargetBackend.ANY, true);
        }

        @TestMetadata("inFunction.kt")
        public void testInFunction() throws Exception {
            runTest("idea/testData/quickfix/removeUnusedReceiver/inFunction.kt");
        }

        @TestMetadata("inProperty.kt")
        public void testInProperty() throws Exception {
            runTest("idea/testData/quickfix/removeUnusedReceiver/inProperty.kt");
        }
    }

    @TestMetadata("idea/testData/quickfix/renameToRem")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class RenameToRem extends AbstractQuickFixTest {
        private void runTest(String testDataFilePath) throws Exception {
            KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
        }

        public void testAllFilesPresentInRenameToRem() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/quickfix/renameToRem"), Pattern.compile("^([\\w\\-_]+)\\.kt$"), TargetBackend.ANY, true);
        }

        @TestMetadata("forbiddenModAsMember.kt")
        public void testForbiddenModAsMember() throws Exception {
            runTest("idea/testData/quickfix/renameToRem/forbiddenModAsMember.kt");
        }

        @TestMetadata("modAsExtension.kt")
        public void testModAsExtension() throws Exception {
            runTest("idea/testData/quickfix/renameToRem/modAsExtension.kt");
        }

        @TestMetadata("modAsMember.kt")
        public void testModAsMember() throws Exception {
            runTest("idea/testData/quickfix/renameToRem/modAsMember.kt");
        }

        @TestMetadata("modAssignAsMember.kt")
        public void testModAssignAsMember() throws Exception {
            runTest("idea/testData/quickfix/renameToRem/modAssignAsMember.kt");
        }
    }

    @TestMetadata("idea/testData/quickfix/renameToUnderscore")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class RenameToUnderscore extends AbstractQuickFixTest {
        private void runTest(String testDataFilePath) throws Exception {
            KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
        }

        public void testAllFilesPresentInRenameToUnderscore() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/quickfix/renameToUnderscore"), Pattern.compile("^([\\w\\-_]+)\\.kt$"), TargetBackend.ANY, true);
        }

        @TestMetadata("commonDestructuring.kt")
        public void testCommonDestructuring() throws Exception {
            runTest("idea/testData/quickfix/renameToUnderscore/commonDestructuring.kt");
        }

        @TestMetadata("forDestructuring.kt")
        public void testForDestructuring() throws Exception {
            runTest("idea/testData/quickfix/renameToUnderscore/forDestructuring.kt");
        }

        @TestMetadata("functionExpressionParameterNoRemoveParameter.kt")
        public void testFunctionExpressionParameterNoRemoveParameter() throws Exception {
            runTest("idea/testData/quickfix/renameToUnderscore/functionExpressionParameterNoRemoveParameter.kt");
        }

        @TestMetadata("lambdaDestructuring.kt")
        public void testLambdaDestructuring() throws Exception {
            runTest("idea/testData/quickfix/renameToUnderscore/lambdaDestructuring.kt");
        }

        @TestMetadata("lambdaParameter.kt")
        public void testLambdaParameter() throws Exception {
            runTest("idea/testData/quickfix/renameToUnderscore/lambdaParameter.kt");
        }

        @TestMetadata("lambdaParameterNoRemoveParameter.kt")
        public void testLambdaParameterNoRemoveParameter() throws Exception {
            runTest("idea/testData/quickfix/renameToUnderscore/lambdaParameterNoRemoveParameter.kt");
        }

        @TestMetadata("noActionForCommonFunction.kt")
        public void testNoActionForCommonFunction() throws Exception {
            runTest("idea/testData/quickfix/renameToUnderscore/noActionForCommonFunction.kt");
        }

        @TestMetadata("noActionForCommonVal.kt")
        public void testNoActionForCommonVal() throws Exception {
            runTest("idea/testData/quickfix/renameToUnderscore/noActionForCommonVal.kt");
        }
    }

    @TestMetadata("idea/testData/quickfix/renameUnresolvedReference")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class RenameUnresolvedReference extends AbstractQuickFixTest {
        private void runTest(String testDataFilePath) throws Exception {
            KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
        }

        public void testAllFilesPresentInRenameUnresolvedReference() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/quickfix/renameUnresolvedReference"), Pattern.compile("^([\\w\\-_]+)\\.kt$"), TargetBackend.ANY, true);
        }

        @TestMetadata("qualifiedFunRef.kt")
        public void testQualifiedFunRef() throws Exception {
            runTest("idea/testData/quickfix/renameUnresolvedReference/qualifiedFunRef.kt");
        }

        @TestMetadata("qualifiedPropertyRef.kt")
        public void testQualifiedPropertyRef() throws Exception {
            runTest("idea/testData/quickfix/renameUnresolvedReference/qualifiedPropertyRef.kt");
        }

        @TestMetadata("typeRef.kt")
        public void testTypeRef() throws Exception {
            runTest("idea/testData/quickfix/renameUnresolvedReference/typeRef.kt");
        }

        @TestMetadata("unqualifiedFunRef.kt")
        public void testUnqualifiedFunRef() throws Exception {
            runTest("idea/testData/quickfix/renameUnresolvedReference/unqualifiedFunRef.kt");
        }

        @TestMetadata("unqualifiedPropertyRef.kt")
        public void testUnqualifiedPropertyRef() throws Exception {
            runTest("idea/testData/quickfix/renameUnresolvedReference/unqualifiedPropertyRef.kt");
        }

        @TestMetadata("unqualifiedPropertyRefWithPackageError.kt")
        public void testUnqualifiedPropertyRefWithPackageError() throws Exception {
            runTest("idea/testData/quickfix/renameUnresolvedReference/unqualifiedPropertyRefWithPackageError.kt");
        }
    }

    @TestMetadata("idea/testData/quickfix/replaceInfixOrOperatorCall")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class ReplaceInfixOrOperatorCall extends AbstractQuickFixTest {
        private void runTest(String testDataFilePath) throws Exception {
            KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
        }

        public void testAllFilesPresentInReplaceInfixOrOperatorCall() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/quickfix/replaceInfixOrOperatorCall"), Pattern.compile("^([\\w\\-_]+)\\.kt$"), TargetBackend.ANY, true);
        }

        @TestMetadata("array.kt")
        public void testArray() throws Exception {
            runTest("idea/testData/quickfix/replaceInfixOrOperatorCall/array.kt");
        }

        @TestMetadata("arraySet.kt")
        public void testArraySet() throws Exception {
            runTest("idea/testData/quickfix/replaceInfixOrOperatorCall/arraySet.kt");
        }

        @TestMetadata("assignmentArray.kt")
        public void testAssignmentArray() throws Exception {
            runTest("idea/testData/quickfix/replaceInfixOrOperatorCall/assignmentArray.kt");
        }

        @TestMetadata("assignmentBinaryOperator.kt")
        public void testAssignmentBinaryOperator() throws Exception {
            runTest("idea/testData/quickfix/replaceInfixOrOperatorCall/assignmentBinaryOperator.kt");
        }

        @TestMetadata("assignmentCallExpression.kt")
        public void testAssignmentCallExpression() throws Exception {
            runTest("idea/testData/quickfix/replaceInfixOrOperatorCall/assignmentCallExpression.kt");
        }

        @TestMetadata("assignmentList.kt")
        public void testAssignmentList() throws Exception {
            runTest("idea/testData/quickfix/replaceInfixOrOperatorCall/assignmentList.kt");
        }

        @TestMetadata("binaryOperator.kt")
        public void testBinaryOperator() throws Exception {
            runTest("idea/testData/quickfix/replaceInfixOrOperatorCall/binaryOperator.kt");
        }

        @TestMetadata("callExpression.kt")
        public void testCallExpression() throws Exception {
            runTest("idea/testData/quickfix/replaceInfixOrOperatorCall/callExpression.kt");
        }

        @TestMetadata("list.kt")
        public void testList() throws Exception {
            runTest("idea/testData/quickfix/replaceInfixOrOperatorCall/list.kt");
        }
    }

    @TestMetadata("idea/testData/quickfix/replaceJvmFieldWithConst")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class ReplaceJvmFieldWithConst extends AbstractQuickFixTest {
        private void runTest(String testDataFilePath) throws Exception {
            KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
        }

        public void testAllFilesPresentInReplaceJvmFieldWithConst() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/quickfix/replaceJvmFieldWithConst"), Pattern.compile("^([\\w\\-_]+)\\.kt$"), TargetBackend.ANY, true);
        }

        @TestMetadata("class.kt")
        public void testClass() throws Exception {
            runTest("idea/testData/quickfix/replaceJvmFieldWithConst/class.kt");
        }

        @TestMetadata("companionInInterface.kt")
        public void testCompanionInInterface() throws Exception {
            runTest("idea/testData/quickfix/replaceJvmFieldWithConst/companionInInterface.kt");
        }

        @TestMetadata("getter.kt")
        public void testGetter() throws Exception {
            runTest("idea/testData/quickfix/replaceJvmFieldWithConst/getter.kt");
        }

        @TestMetadata("nonConstantInitializer.kt")
        public void testNonConstantInitializer() throws Exception {
            runTest("idea/testData/quickfix/replaceJvmFieldWithConst/nonConstantInitializer.kt");
        }

        @TestMetadata("nullable.kt")
        public void testNullable() throws Exception {
            runTest("idea/testData/quickfix/replaceJvmFieldWithConst/nullable.kt");
        }

        @TestMetadata("object.kt")
        public void testObject() throws Exception {
            runTest("idea/testData/quickfix/replaceJvmFieldWithConst/object.kt");
        }

        @TestMetadata("stringTemplateWithConstants.kt")
        public void testStringTemplateWithConstants() throws Exception {
            runTest("idea/testData/quickfix/replaceJvmFieldWithConst/stringTemplateWithConstants.kt");
        }

        @TestMetadata("stringTemplateWithVal.kt")
        public void testStringTemplateWithVal() throws Exception {
            runTest("idea/testData/quickfix/replaceJvmFieldWithConst/stringTemplateWithVal.kt");
        }

        @TestMetadata("toplevel.kt")
        public void testToplevel() throws Exception {
            runTest("idea/testData/quickfix/replaceJvmFieldWithConst/toplevel.kt");
        }
    }

    @TestMetadata("idea/testData/quickfix/replaceWithArrayCallInAnnotation")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class ReplaceWithArrayCallInAnnotation extends AbstractQuickFixTest {
        private void runTest(String testDataFilePath) throws Exception {
            KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
        }

        public void testAllFilesPresentInReplaceWithArrayCallInAnnotation() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/quickfix/replaceWithArrayCallInAnnotation"), Pattern.compile("^([\\w\\-_]+)\\.kt$"), TargetBackend.ANY, true);
        }

        @TestMetadata("emptyLiteral.kt")
        public void testEmptyLiteral() throws Exception {
            runTest("idea/testData/quickfix/replaceWithArrayCallInAnnotation/emptyLiteral.kt");
        }

        @TestMetadata("literalWithValues.kt")
        public void testLiteralWithValues() throws Exception {
            runTest("idea/testData/quickfix/replaceWithArrayCallInAnnotation/literalWithValues.kt");
        }

        @TestMetadata("replaceForbiddenAssignmentWithArrayLiteral.kt")
        public void testReplaceForbiddenAssignmentWithArrayLiteral() throws Exception {
            runTest("idea/testData/quickfix/replaceWithArrayCallInAnnotation/replaceForbiddenAssignmentWithArrayLiteral.kt");
        }

        @TestMetadata("replaceSingleElementInNamedForm.kt")
        public void testReplaceSingleElementInNamedForm() throws Exception {
            runTest("idea/testData/quickfix/replaceWithArrayCallInAnnotation/replaceSingleElementInNamedForm.kt");
        }
    }

    @TestMetadata("idea/testData/quickfix/replaceWithDotCall")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class ReplaceWithDotCall extends AbstractQuickFixTest {
        private void runTest(String testDataFilePath) throws Exception {
            KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
        }

        public void testAllFilesPresentInReplaceWithDotCall() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/quickfix/replaceWithDotCall"), Pattern.compile("^([\\w\\-_]+)\\.kt$"), TargetBackend.ANY, true);
        }

        @TestMetadata("functionCall.kt")
        public void testFunctionCall() throws Exception {
            runTest("idea/testData/quickfix/replaceWithDotCall/functionCall.kt");
        }

        @TestMetadata("normal.kt")
        public void testNormal() throws Exception {
            runTest("idea/testData/quickfix/replaceWithDotCall/normal.kt");
        }
    }

    @TestMetadata("idea/testData/quickfix/replaceWithSafeCall")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class ReplaceWithSafeCall extends AbstractQuickFixTest {
        private void runTest(String testDataFilePath) throws Exception {
            KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
        }

        public void testAllFilesPresentInReplaceWithSafeCall() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/quickfix/replaceWithSafeCall"), Pattern.compile("^([\\w\\-_]+)\\.kt$"), TargetBackend.ANY, true);
        }

        @TestMetadata("apply.kt")
        public void testApply() throws Exception {
            runTest("idea/testData/quickfix/replaceWithSafeCall/apply.kt");
        }

        @TestMetadata("applyWithImplicitParameter.kt")
        public void testApplyWithImplicitParameter() throws Exception {
            runTest("idea/testData/quickfix/replaceWithSafeCall/applyWithImplicitParameter.kt");
        }

        @TestMetadata("applyWithImplicitParameterFunctionCall.kt")
        public void testApplyWithImplicitParameterFunctionCall() throws Exception {
            runTest("idea/testData/quickfix/replaceWithSafeCall/applyWithImplicitParameterFunctionCall.kt");
        }

        @TestMetadata("assignment.kt")
        public void testAssignment() throws Exception {
            runTest("idea/testData/quickfix/replaceWithSafeCall/assignment.kt");
        }

        @TestMetadata("assignmentFromImplicitParameter.kt")
        public void testAssignmentFromImplicitParameter() throws Exception {
            runTest("idea/testData/quickfix/replaceWithSafeCall/assignmentFromImplicitParameter.kt");
        }

        @TestMetadata("assignmentToNullable.kt")
        public void testAssignmentToNullable() throws Exception {
            runTest("idea/testData/quickfix/replaceWithSafeCall/assignmentToNullable.kt");
        }

        @TestMetadata("assignmentToProperty.kt")
        public void testAssignmentToProperty() throws Exception {
            runTest("idea/testData/quickfix/replaceWithSafeCall/assignmentToProperty.kt");
        }

        @TestMetadata("expression.kt")
        public void testExpression() throws Exception {
            runTest("idea/testData/quickfix/replaceWithSafeCall/expression.kt");
        }

        @TestMetadata("extFunction.kt")
        public void testExtFunction() throws Exception {
            runTest("idea/testData/quickfix/replaceWithSafeCall/extFunction.kt");
        }

        @TestMetadata("functionCall.kt")
        public void testFunctionCall() throws Exception {
            runTest("idea/testData/quickfix/replaceWithSafeCall/functionCall.kt");
        }

        @TestMetadata("invokeOperator.kt")
        public void testInvokeOperator() throws Exception {
            runTest("idea/testData/quickfix/replaceWithSafeCall/invokeOperator.kt");
        }

        @TestMetadata("let.kt")
        public void testLet() throws Exception {
            runTest("idea/testData/quickfix/replaceWithSafeCall/let.kt");
        }

        @TestMetadata("letWithParameter.kt")
        public void testLetWithParameter() throws Exception {
            runTest("idea/testData/quickfix/replaceWithSafeCall/letWithParameter.kt");
        }

        @TestMetadata("noReplaceWithSafeCallForImplicitReceiver.kt")
        public void testNoReplaceWithSafeCallForImplicitReceiver() throws Exception {
            runTest("idea/testData/quickfix/replaceWithSafeCall/noReplaceWithSafeCallForImplicitReceiver.kt");
        }

        @TestMetadata("normal.kt")
        public void testNormal() throws Exception {
            runTest("idea/testData/quickfix/replaceWithSafeCall/normal.kt");
        }
    }

    @TestMetadata("idea/testData/quickfix/replaceWithSafeCallForScopeFunction")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class ReplaceWithSafeCallForScopeFunction extends AbstractQuickFixTest {
        private void runTest(String testDataFilePath) throws Exception {
            KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
        }

        public void testAllFilesPresentInReplaceWithSafeCallForScopeFunction() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/quickfix/replaceWithSafeCallForScopeFunction"), Pattern.compile("^([\\w\\-_]+)\\.kt$"), TargetBackend.ANY, true);
        }

        @TestMetadata("also.kt")
        public void testAlso() throws Exception {
            runTest("idea/testData/quickfix/replaceWithSafeCallForScopeFunction/also.kt");
        }

        @TestMetadata("applyWithFake.kt")
        public void testApplyWithFake() throws Exception {
            runTest("idea/testData/quickfix/replaceWithSafeCallForScopeFunction/applyWithFake.kt");
        }

        @TestMetadata("applyWithThis.kt")
        public void testApplyWithThis() throws Exception {
            runTest("idea/testData/quickfix/replaceWithSafeCallForScopeFunction/applyWithThis.kt");
        }

        @TestMetadata("applyWithThisAndArrow.kt")
        public void testApplyWithThisAndArrow() throws Exception {
            runTest("idea/testData/quickfix/replaceWithSafeCallForScopeFunction/applyWithThisAndArrow.kt");
        }

        @TestMetadata("applyWithThisLabeled.kt")
        public void testApplyWithThisLabeled() throws Exception {
            runTest("idea/testData/quickfix/replaceWithSafeCallForScopeFunction/applyWithThisLabeled.kt");
        }

        @TestMetadata("applyWithThisLabeledFake.kt")
        public void testApplyWithThisLabeledFake() throws Exception {
            runTest("idea/testData/quickfix/replaceWithSafeCallForScopeFunction/applyWithThisLabeledFake.kt");
        }

        @TestMetadata("applyWithoutThis.kt")
        public void testApplyWithoutThis() throws Exception {
            runTest("idea/testData/quickfix/replaceWithSafeCallForScopeFunction/applyWithoutThis.kt");
        }

        @TestMetadata("applyWithoutThisMethodCall.kt")
        public void testApplyWithoutThisMethodCall() throws Exception {
            runTest("idea/testData/quickfix/replaceWithSafeCallForScopeFunction/applyWithoutThisMethodCall.kt");
        }

        @TestMetadata("assignment.kt")
        public void testAssignment() throws Exception {
            runTest("idea/testData/quickfix/replaceWithSafeCallForScopeFunction/assignment.kt");
        }

        @TestMetadata("let.kt")
        public void testLet() throws Exception {
            runTest("idea/testData/quickfix/replaceWithSafeCallForScopeFunction/let.kt");
        }

        @TestMetadata("letWithParam.kt")
        public void testLetWithParam() throws Exception {
            runTest("idea/testData/quickfix/replaceWithSafeCallForScopeFunction/letWithParam.kt");
        }

        @TestMetadata("letWithWrongImplicitThis.kt")
        public void testLetWithWrongImplicitThis() throws Exception {
            runTest("idea/testData/quickfix/replaceWithSafeCallForScopeFunction/letWithWrongImplicitThis.kt");
        }

        @TestMetadata("letWithWrongParam.kt")
        public void testLetWithWrongParam() throws Exception {
            runTest("idea/testData/quickfix/replaceWithSafeCallForScopeFunction/letWithWrongParam.kt");
        }

        @TestMetadata("notInsideScope.kt")
        public void testNotInsideScope() throws Exception {
            runTest("idea/testData/quickfix/replaceWithSafeCallForScopeFunction/notInsideScope.kt");
        }

        @TestMetadata("run.kt")
        public void testRun() throws Exception {
            runTest("idea/testData/quickfix/replaceWithSafeCallForScopeFunction/run.kt");
        }
    }

    @TestMetadata("idea/testData/quickfix/simplifyComparison")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class SimplifyComparison extends AbstractQuickFixTest {
        private void runTest(String testDataFilePath) throws Exception {
            KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
        }

        public void testAllFilesPresentInSimplifyComparison() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/quickfix/simplifyComparison"), Pattern.compile("^([\\w\\-_]+)\\.kt$"), TargetBackend.ANY, true);
        }

        @TestMetadata("doubleNull.kt")
        public void testDoubleNull() throws Exception {
            runTest("idea/testData/quickfix/simplifyComparison/doubleNull.kt");
        }

        @TestMetadata("notNull.kt")
        public void testNotNull() throws Exception {
            runTest("idea/testData/quickfix/simplifyComparison/notNull.kt");
        }

        @TestMetadata("nullOrNotNull.kt")
        public void testNullOrNotNull() throws Exception {
            runTest("idea/testData/quickfix/simplifyComparison/nullOrNotNull.kt");
        }

        @TestMetadata("somethingAndNotNull.kt")
        public void testSomethingAndNotNull() throws Exception {
            runTest("idea/testData/quickfix/simplifyComparison/somethingAndNotNull.kt");
        }

        @TestMetadata("withAssertion.kt")
        public void testWithAssertion() throws Exception {
            runTest("idea/testData/quickfix/simplifyComparison/withAssertion.kt");
        }

        @TestMetadata("withAssertion2.kt")
        public void testWithAssertion2() throws Exception {
            runTest("idea/testData/quickfix/simplifyComparison/withAssertion2.kt");
        }

        @TestMetadata("withAssertion3.kt")
        public void testWithAssertion3() throws Exception {
            runTest("idea/testData/quickfix/simplifyComparison/withAssertion3.kt");
        }
    }

    @TestMetadata("idea/testData/quickfix/smartCastImpossibleInIfThen")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class SmartCastImpossibleInIfThen extends AbstractQuickFixTest {
        private void runTest(String testDataFilePath) throws Exception {
            KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
        }

        public void testAllFilesPresentInSmartCastImpossibleInIfThen() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/quickfix/smartCastImpossibleInIfThen"), Pattern.compile("^([\\w\\-_]+)\\.kt$"), TargetBackend.ANY, true);
        }

        @TestMetadata("ifThen.kt")
        public void testIfThen() throws Exception {
            runTest("idea/testData/quickfix/smartCastImpossibleInIfThen/ifThen.kt");
        }

        @TestMetadata("ifThen2.kt")
        public void testIfThen2() throws Exception {
            runTest("idea/testData/quickfix/smartCastImpossibleInIfThen/ifThen2.kt");
        }

        @TestMetadata("ifThen3.kt")
        public void testIfThen3() throws Exception {
            runTest("idea/testData/quickfix/smartCastImpossibleInIfThen/ifThen3.kt");
        }

        @TestMetadata("ifThen4.kt")
        public void testIfThen4() throws Exception {
            runTest("idea/testData/quickfix/smartCastImpossibleInIfThen/ifThen4.kt");
        }

        @TestMetadata("ifThen5.kt")
        public void testIfThen5() throws Exception {
            runTest("idea/testData/quickfix/smartCastImpossibleInIfThen/ifThen5.kt");
        }

        @TestMetadata("ifThenElse.kt")
        public void testIfThenElse() throws Exception {
            runTest("idea/testData/quickfix/smartCastImpossibleInIfThen/ifThenElse.kt");
        }

        @TestMetadata("ifThenElse2.kt")
        public void testIfThenElse2() throws Exception {
            runTest("idea/testData/quickfix/smartCastImpossibleInIfThen/ifThenElse2.kt");
        }

        @TestMetadata("ifThenElse3.kt")
        public void testIfThenElse3() throws Exception {
            runTest("idea/testData/quickfix/smartCastImpossibleInIfThen/ifThenElse3.kt");
        }

        @TestMetadata("ifThenElse4.kt")
        public void testIfThenElse4() throws Exception {
            runTest("idea/testData/quickfix/smartCastImpossibleInIfThen/ifThenElse4.kt");
        }

        @TestMetadata("ifThenElse5.kt")
        public void testIfThenElse5() throws Exception {
            runTest("idea/testData/quickfix/smartCastImpossibleInIfThen/ifThenElse5.kt");
        }

        @TestMetadata("ifThenElseMultiStatement.kt")
        public void testIfThenElseMultiStatement() throws Exception {
            runTest("idea/testData/quickfix/smartCastImpossibleInIfThen/ifThenElseMultiStatement.kt");
        }

        @TestMetadata("ifThenMultiStatement.kt")
        public void testIfThenMultiStatement() throws Exception {
            runTest("idea/testData/quickfix/smartCastImpossibleInIfThen/ifThenMultiStatement.kt");
        }
    }

    @TestMetadata("idea/testData/quickfix/specifyOverrideExplicitly")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class SpecifyOverrideExplicitly extends AbstractQuickFixTest {
        private void runTest(String testDataFilePath) throws Exception {
            KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
        }

        public void testAllFilesPresentInSpecifyOverrideExplicitly() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/quickfix/specifyOverrideExplicitly"), Pattern.compile("^([\\w\\-_]+)\\.kt$"), TargetBackend.ANY, true);
        }

        @TestMetadata("base.kt")
        public void testBase() throws Exception {
            runTest("idea/testData/quickfix/specifyOverrideExplicitly/base.kt");
        }

        @TestMetadata("global.kt")
        public void testGlobal() throws Exception {
            runTest("idea/testData/quickfix/specifyOverrideExplicitly/global.kt");
        }

        @TestMetadata("lists.kt")
        public void testLists() throws Exception {
            runTest("idea/testData/quickfix/specifyOverrideExplicitly/lists.kt");
        }

        @TestMetadata("lists2.kt")
        public void testLists2() throws Exception {
            runTest("idea/testData/quickfix/specifyOverrideExplicitly/lists2.kt");
        }

        @TestMetadata("notPossible.kt")
        public void testNotPossible() throws Exception {
            runTest("idea/testData/quickfix/specifyOverrideExplicitly/notPossible.kt");
        }

        @TestMetadata("outer.kt")
        public void testOuter() throws Exception {
            runTest("idea/testData/quickfix/specifyOverrideExplicitly/outer.kt");
        }

        @TestMetadata("property.kt")
        public void testProperty() throws Exception {
            runTest("idea/testData/quickfix/specifyOverrideExplicitly/property.kt");
        }
    }

    @TestMetadata("idea/testData/quickfix/superTypeIsExtensionType")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class SuperTypeIsExtensionType extends AbstractQuickFixTest {
        private void runTest(String testDataFilePath) throws Exception {
            KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
        }

        public void testAllFilesPresentInSuperTypeIsExtensionType() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/quickfix/superTypeIsExtensionType"), Pattern.compile("^([\\w\\-_]+)\\.kt$"), TargetBackend.ANY, true);
        }

        @TestMetadata("typeWith1Argument.kt")
        public void testTypeWith1Argument() throws Exception {
            runTest("idea/testData/quickfix/superTypeIsExtensionType/typeWith1Argument.kt");
        }

        @TestMetadata("typeWithNoArgument.kt")
        public void testTypeWithNoArgument() throws Exception {
            runTest("idea/testData/quickfix/superTypeIsExtensionType/typeWithNoArgument.kt");
        }

        @TestMetadata("typeWithTypeArgument.kt")
        public void testTypeWithTypeArgument() throws Exception {
            runTest("idea/testData/quickfix/superTypeIsExtensionType/typeWithTypeArgument.kt");
        }
    }

    @TestMetadata("idea/testData/quickfix/supercalls")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class Supercalls extends AbstractQuickFixTest {
        private void runTest(String testDataFilePath) throws Exception {
            KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
        }

        public void testAllFilesPresentInSupercalls() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/quickfix/supercalls"), Pattern.compile("^([\\w\\-_]+)\\.kt$"), TargetBackend.ANY, true);
        }

        @TestMetadata("typeArgumentsRedundantInSuperQualifier.kt")
        public void testTypeArgumentsRedundantInSuperQualifier() throws Exception {
            runTest("idea/testData/quickfix/supercalls/typeArgumentsRedundantInSuperQualifier.kt");
        }
    }

    @TestMetadata("idea/testData/quickfix/supertypeInitialization")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class SupertypeInitialization extends AbstractQuickFixTest {
        private void runTest(String testDataFilePath) throws Exception {
            KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
        }

        @TestMetadata("addImport.kt")
        public void testAddImport() throws Exception {
            runTest("idea/testData/quickfix/supertypeInitialization/addImport.kt");
        }

        @TestMetadata("addParameters.kt")
        public void testAddParameters() throws Exception {
            runTest("idea/testData/quickfix/supertypeInitialization/addParameters.kt");
        }

        @TestMetadata("addParenthesis.kt")
        public void testAddParenthesis() throws Exception {
            runTest("idea/testData/quickfix/supertypeInitialization/addParenthesis.kt");
        }

        @TestMetadata("addParenthesisDefaultParameters.kt")
        public void testAddParenthesisDefaultParameters() throws Exception {
            runTest("idea/testData/quickfix/supertypeInitialization/addParenthesisDefaultParameters.kt");
        }

        @TestMetadata("addParenthesisEmptyConstructor.kt")
        public void testAddParenthesisEmptyConstructor() throws Exception {
            runTest("idea/testData/quickfix/supertypeInitialization/addParenthesisEmptyConstructor.kt");
        }

        @TestMetadata("addParenthesisExpectClass.kt")
        public void testAddParenthesisExpectClass() throws Exception {
            runTest("idea/testData/quickfix/supertypeInitialization/addParenthesisExpectClass.kt");
        }

        @TestMetadata("addParenthesisForInvalidSealedClass.kt")
        public void testAddParenthesisForInvalidSealedClass() throws Exception {
            runTest("idea/testData/quickfix/supertypeInitialization/addParenthesisForInvalidSealedClass.kt");
        }

        @TestMetadata("addParenthesisForInvalidSealedClass2.kt")
        public void testAddParenthesisForInvalidSealedClass2() throws Exception {
            runTest("idea/testData/quickfix/supertypeInitialization/addParenthesisForInvalidSealedClass2.kt");
        }

        @TestMetadata("addParenthesisForLocalClass.kt")
        public void testAddParenthesisForLocalClass() throws Exception {
            runTest("idea/testData/quickfix/supertypeInitialization/addParenthesisForLocalClass.kt");
        }

        @TestMetadata("addParenthesisForObjectExpression.kt")
        public void testAddParenthesisForObjectExpression() throws Exception {
            runTest("idea/testData/quickfix/supertypeInitialization/addParenthesisForObjectExpression.kt");
        }

        @TestMetadata("addParenthesisForSealedClass.kt")
        public void testAddParenthesisForSealedClass() throws Exception {
            runTest("idea/testData/quickfix/supertypeInitialization/addParenthesisForSealedClass.kt");
        }

        public void testAllFilesPresentInSupertypeInitialization() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/quickfix/supertypeInitialization"), Pattern.compile("^([\\w\\-_]+)\\.kt$"), TargetBackend.ANY, true);
        }

        @TestMetadata("baseConstructorError.kt")
        public void testBaseConstructorError() throws Exception {
            runTest("idea/testData/quickfix/supertypeInitialization/baseConstructorError.kt");
        }

        @TestMetadata("createConstructor.kt")
        public void testCreateConstructor() throws Exception {
            runTest("idea/testData/quickfix/supertypeInitialization/createConstructor.kt");
        }

        @TestMetadata("displayLongSignatures1.kt")
        public void testDisplayLongSignatures1() throws Exception {
            runTest("idea/testData/quickfix/supertypeInitialization/displayLongSignatures1.kt");
        }

        @TestMetadata("displayLongSignatures2.kt")
        public void testDisplayLongSignatures2() throws Exception {
            runTest("idea/testData/quickfix/supertypeInitialization/displayLongSignatures2.kt");
        }

        @TestMetadata("genericClass.kt")
        public void testGenericClass() throws Exception {
            runTest("idea/testData/quickfix/supertypeInitialization/genericClass.kt");
        }

        @TestMetadata("incompleteConstructor.kt")
        public void testIncompleteConstructor() throws Exception {
            runTest("idea/testData/quickfix/supertypeInitialization/incompleteConstructor.kt");
        }

        @TestMetadata("keywordName.kt")
        public void testKeywordName() throws Exception {
            runTest("idea/testData/quickfix/supertypeInitialization/keywordName.kt");
        }

        @TestMetadata("multipleConstructors.kt")
        public void testMultipleConstructors() throws Exception {
            runTest("idea/testData/quickfix/supertypeInitialization/multipleConstructors.kt");
        }

        @TestMetadata("noAccessibleConstructors.kt")
        public void testNoAccessibleConstructors() throws Exception {
            runTest("idea/testData/quickfix/supertypeInitialization/noAccessibleConstructors.kt");
        }

        @TestMetadata("noParameters.kt")
        public void testNoParameters() throws Exception {
            runTest("idea/testData/quickfix/supertypeInitialization/noParameters.kt");
        }

        @TestMetadata("primaryConstructorInaccessible.kt")
        public void testPrimaryConstructorInaccessible() throws Exception {
            runTest("idea/testData/quickfix/supertypeInitialization/primaryConstructorInaccessible.kt");
        }

        @TestMetadata("someParametersAlreadyExist.kt")
        public void testSomeParametersAlreadyExist() throws Exception {
            runTest("idea/testData/quickfix/supertypeInitialization/someParametersAlreadyExist.kt");
        }

        @TestMetadata("vararg1.kt")
        public void testVararg1() throws Exception {
            runTest("idea/testData/quickfix/supertypeInitialization/vararg1.kt");
        }

        @TestMetadata("vararg2.kt")
        public void testVararg2() throws Exception {
            runTest("idea/testData/quickfix/supertypeInitialization/vararg2.kt");
        }

        @TestMetadata("vararg3.kt")
        public void testVararg3() throws Exception {
            runTest("idea/testData/quickfix/supertypeInitialization/vararg3.kt");
        }
    }

    @TestMetadata("idea/testData/quickfix/suppress")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class Suppress extends AbstractQuickFixTest {
        private void runTest(String testDataFilePath) throws Exception {
            KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
        }

        public void testAllFilesPresentInSuppress() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/quickfix/suppress"), Pattern.compile("^([\\w\\-_]+)\\.kt$"), TargetBackend.ANY, true);
        }

        @TestMetadata("idea/testData/quickfix/suppress/annotationPosition")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class AnnotationPosition extends AbstractQuickFixTest {
            private void runTest(String testDataFilePath) throws Exception {
                KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
            }

            public void testAllFilesPresentInAnnotationPosition() throws Exception {
                KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/quickfix/suppress/annotationPosition"), Pattern.compile("^([\\w\\-_]+)\\.kt$"), TargetBackend.ANY, true);
            }

            @TestMetadata("paramWithModifier.kt")
            public void testParamWithModifier() throws Exception {
                runTest("idea/testData/quickfix/suppress/annotationPosition/paramWithModifier.kt");
            }

            @TestMetadata("topLevelFunctionModifierOnThePreviousLine.kt")
            public void testTopLevelFunctionModifierOnThePreviousLine() throws Exception {
                runTest("idea/testData/quickfix/suppress/annotationPosition/topLevelFunctionModifierOnThePreviousLine.kt");
            }

            @TestMetadata("topLevelFunctionModifierOnTheSameLine.kt")
            public void testTopLevelFunctionModifierOnTheSameLine() throws Exception {
                runTest("idea/testData/quickfix/suppress/annotationPosition/topLevelFunctionModifierOnTheSameLine.kt");
            }

            @TestMetadata("topLevelFunctionNoModifiers.kt")
            public void testTopLevelFunctionNoModifiers() throws Exception {
                runTest("idea/testData/quickfix/suppress/annotationPosition/topLevelFunctionNoModifiers.kt");
            }

            @TestMetadata("topLevelFunctionSuppressAnotherPreviousLine.kt")
            public void testTopLevelFunctionSuppressAnotherPreviousLine() throws Exception {
                runTest("idea/testData/quickfix/suppress/annotationPosition/topLevelFunctionSuppressAnotherPreviousLine.kt");
            }

            @TestMetadata("topLevelFunctionSuppressEmptyArgsPreviousLine.kt")
            public void testTopLevelFunctionSuppressEmptyArgsPreviousLine() throws Exception {
                runTest("idea/testData/quickfix/suppress/annotationPosition/topLevelFunctionSuppressEmptyArgsPreviousLine.kt");
            }

            @TestMetadata("topLevelFunctionSuppressNoArgsPreviousLine.kt")
            public void testTopLevelFunctionSuppressNoArgsPreviousLine() throws Exception {
                runTest("idea/testData/quickfix/suppress/annotationPosition/topLevelFunctionSuppressNoArgsPreviousLine.kt");
            }

            @TestMetadata("topLevelFunctionSuppressNoArgsPreviousLineBare.kt")
            public void testTopLevelFunctionSuppressNoArgsPreviousLineBare() throws Exception {
                runTest("idea/testData/quickfix/suppress/annotationPosition/topLevelFunctionSuppressNoArgsPreviousLineBare.kt");
            }

            @TestMetadata("topLevelFunctionSuppressNoArgsTheSameLine.kt")
            public void testTopLevelFunctionSuppressNoArgsTheSameLine() throws Exception {
                runTest("idea/testData/quickfix/suppress/annotationPosition/topLevelFunctionSuppressNoArgsTheSameLine.kt");
            }

            @TestMetadata("topLevelFunctionSuppressNoArgsTheSameLineBare.kt")
            public void testTopLevelFunctionSuppressNoArgsTheSameLineBare() throws Exception {
                runTest("idea/testData/quickfix/suppress/annotationPosition/topLevelFunctionSuppressNoArgsTheSameLineBare.kt");
            }

            @TestMetadata("topLevelFunctionSuppressOnFile.kt")
            public void testTopLevelFunctionSuppressOnFile() throws Exception {
                runTest("idea/testData/quickfix/suppress/annotationPosition/topLevelFunctionSuppressOnFile.kt");
            }

            @TestMetadata("topLevelFunctionSuppressOnFileOtherAnnotation.kt")
            public void testTopLevelFunctionSuppressOnFileOtherAnnotation() throws Exception {
                runTest("idea/testData/quickfix/suppress/annotationPosition/topLevelFunctionSuppressOnFileOtherAnnotation.kt");
            }

            @TestMetadata("topLevelFunctionSuppressOnFileWithPackage.kt")
            public void testTopLevelFunctionSuppressOnFileWithPackage() throws Exception {
                runTest("idea/testData/quickfix/suppress/annotationPosition/topLevelFunctionSuppressOnFileWithPackage.kt");
            }

            @TestMetadata("topLevelFunctionSuppressOnFileWithSuppress.kt")
            public void testTopLevelFunctionSuppressOnFileWithSuppress() throws Exception {
                runTest("idea/testData/quickfix/suppress/annotationPosition/topLevelFunctionSuppressOnFileWithSuppress.kt");
            }

            @TestMetadata("topLevelFunctionUnrelatedAnnotation.kt")
            public void testTopLevelFunctionUnrelatedAnnotation() throws Exception {
                runTest("idea/testData/quickfix/suppress/annotationPosition/topLevelFunctionUnrelatedAnnotation.kt");
            }

            @TestMetadata("topLevelFunctionUnrelatedAnnotationBare.kt")
            public void testTopLevelFunctionUnrelatedAnnotationBare() throws Exception {
                runTest("idea/testData/quickfix/suppress/annotationPosition/topLevelFunctionUnrelatedAnnotationBare.kt");
            }
        }

        @TestMetadata("idea/testData/quickfix/suppress/availability")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class Availability extends AbstractQuickFixTest {
            private void runTest(String testDataFilePath) throws Exception {
                KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
            }

            public void testAllFilesPresentInAvailability() throws Exception {
                KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/quickfix/suppress/availability"), Pattern.compile("^([\\w\\-_]+)\\.kt$"), TargetBackend.ANY, true);
            }

            @TestMetadata("localFunSuppressForLocal.kt")
            public void testLocalFunSuppressForLocal() throws Exception {
                runTest("idea/testData/quickfix/suppress/availability/localFunSuppressForLocal.kt");
            }

            @TestMetadata("localFunSuppressForOuter.kt")
            public void testLocalFunSuppressForOuter() throws Exception {
                runTest("idea/testData/quickfix/suppress/availability/localFunSuppressForOuter.kt");
            }

            @TestMetadata("localValSuppressForFun.kt")
            public void testLocalValSuppressForFun() throws Exception {
                runTest("idea/testData/quickfix/suppress/availability/localValSuppressForFun.kt");
            }

            @TestMetadata("localValSuppressForVal.kt")
            public void testLocalValSuppressForVal() throws Exception {
                runTest("idea/testData/quickfix/suppress/availability/localValSuppressForVal.kt");
            }

            @TestMetadata("memberOfNestedSuppressForMember.kt")
            public void testMemberOfNestedSuppressForMember() throws Exception {
                runTest("idea/testData/quickfix/suppress/availability/memberOfNestedSuppressForMember.kt");
            }

            @TestMetadata("memberOfNestedSuppressForNested.kt")
            public void testMemberOfNestedSuppressForNested() throws Exception {
                runTest("idea/testData/quickfix/suppress/availability/memberOfNestedSuppressForNested.kt");
            }

            @TestMetadata("memberOfNestedSuppressForOuter.kt")
            public void testMemberOfNestedSuppressForOuter() throws Exception {
                runTest("idea/testData/quickfix/suppress/availability/memberOfNestedSuppressForOuter.kt");
            }

            @TestMetadata("memberSuppressForClass.kt")
            public void testMemberSuppressForClass() throws Exception {
                runTest("idea/testData/quickfix/suppress/availability/memberSuppressForClass.kt");
            }

            @TestMetadata("memberSuppressForMember.kt")
            public void testMemberSuppressForMember() throws Exception {
                runTest("idea/testData/quickfix/suppress/availability/memberSuppressForMember.kt");
            }

            @TestMetadata("topLevelFunctionAlreadySuppressed.kt")
            public void testTopLevelFunctionAlreadySuppressed() throws Exception {
                runTest("idea/testData/quickfix/suppress/availability/topLevelFunctionAlreadySuppressed.kt");
            }
        }

        @TestMetadata("idea/testData/quickfix/suppress/declarationKinds")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class DeclarationKinds extends AbstractQuickFixTest {
            private void runTest(String testDataFilePath) throws Exception {
                KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
            }

            public void testAllFilesPresentInDeclarationKinds() throws Exception {
                KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/quickfix/suppress/declarationKinds"), Pattern.compile("^([\\w\\-_]+)\\.kt$"), TargetBackend.ANY, true);
            }

            @TestMetadata("class.kt")
            public void testClass() throws Exception {
                runTest("idea/testData/quickfix/suppress/declarationKinds/class.kt");
            }

            @TestMetadata("classObject.kt")
            public void testClassObject() throws Exception {
                runTest("idea/testData/quickfix/suppress/declarationKinds/classObject.kt");
            }

            @TestMetadata("enumEntry.kt")
            public void testEnumEntry() throws Exception {
                runTest("idea/testData/quickfix/suppress/declarationKinds/enumEntry.kt");
            }

            @TestMetadata("fun.kt")
            public void testFun() throws Exception {
                runTest("idea/testData/quickfix/suppress/declarationKinds/fun.kt");
            }

            @TestMetadata("multiVal.kt")
            public void testMultiVal() throws Exception {
                runTest("idea/testData/quickfix/suppress/declarationKinds/multiVal.kt");
            }

            @TestMetadata("multiVar.kt")
            public void testMultiVar() throws Exception {
                runTest("idea/testData/quickfix/suppress/declarationKinds/multiVar.kt");
            }

            @TestMetadata("object.kt")
            public void testObject() throws Exception {
                runTest("idea/testData/quickfix/suppress/declarationKinds/object.kt");
            }

            @TestMetadata("param.kt")
            public void testParam() throws Exception {
                runTest("idea/testData/quickfix/suppress/declarationKinds/param.kt");
            }

            @TestMetadata("secondaryConstructor.kt")
            public void testSecondaryConstructor() throws Exception {
                runTest("idea/testData/quickfix/suppress/declarationKinds/secondaryConstructor.kt");
            }

            @TestMetadata("trait.kt")
            public void testTrait() throws Exception {
                runTest("idea/testData/quickfix/suppress/declarationKinds/trait.kt");
            }

            @TestMetadata("val.kt")
            public void testVal() throws Exception {
                runTest("idea/testData/quickfix/suppress/declarationKinds/val.kt");
            }

            @TestMetadata("var.kt")
            public void testVar() throws Exception {
                runTest("idea/testData/quickfix/suppress/declarationKinds/var.kt");
            }
        }

        @TestMetadata("idea/testData/quickfix/suppress/errorRecovery")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class ErrorRecovery extends AbstractQuickFixTest {
            private void runTest(String testDataFilePath) throws Exception {
                KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
            }

            public void testAllFilesPresentInErrorRecovery() throws Exception {
                KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/quickfix/suppress/errorRecovery"), Pattern.compile("^([\\w\\-_]+)\\.kt$"), TargetBackend.ANY, true);
            }

            @TestMetadata("nonStringInSuppress.kt")
            public void testNonStringInSuppress() throws Exception {
                runTest("idea/testData/quickfix/suppress/errorRecovery/nonStringInSuppress.kt");
            }

            @TestMetadata("unresolvedAnnotation.kt")
            public void testUnresolvedAnnotation() throws Exception {
                runTest("idea/testData/quickfix/suppress/errorRecovery/unresolvedAnnotation.kt");
            }
        }

        @TestMetadata("idea/testData/quickfix/suppress/external")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class External extends AbstractQuickFixTest {
            private void runTest(String testDataFilePath) throws Exception {
                KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
            }

            public void testAllFilesPresentInExternal() throws Exception {
                KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/quickfix/suppress/external"), Pattern.compile("^([\\w\\-_]+)\\.kt$"), TargetBackend.ANY, true);
            }

            @TestMetadata("suppressActive.kt")
            public void testSuppressActive() throws Exception {
                runTest("idea/testData/quickfix/suppress/external/suppressActive.kt");
            }

            @TestMetadata("suppressAvailable.kt")
            public void testSuppressAvailable() throws Exception {
                runTest("idea/testData/quickfix/suppress/external/suppressAvailable.kt");
            }
        }

        @TestMetadata("idea/testData/quickfix/suppress/forStatement")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class ForStatement extends AbstractQuickFixTest {
            private void runTest(String testDataFilePath) throws Exception {
                KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
            }

            public void testAllFilesPresentInForStatement() throws Exception {
                KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/quickfix/suppress/forStatement"), Pattern.compile("^([\\w\\-_]+)\\.kt$"), TargetBackend.ANY, true);
            }

            @TestMetadata("andAnd.kt")
            public void testAndAnd() throws Exception {
                runTest("idea/testData/quickfix/suppress/forStatement/andAnd.kt");
            }

            @TestMetadata("annotatedExpr.kt")
            public void testAnnotatedExpr() throws Exception {
                runTest("idea/testData/quickfix/suppress/forStatement/annotatedExpr.kt");
            }

            @TestMetadata("annotatedExprWithSuppress.kt")
            public void testAnnotatedExprWithSuppress() throws Exception {
                runTest("idea/testData/quickfix/suppress/forStatement/annotatedExprWithSuppress.kt");
            }

            @TestMetadata("arrayRead.kt")
            public void testArrayRead() throws Exception {
                runTest("idea/testData/quickfix/suppress/forStatement/arrayRead.kt");
            }

            @TestMetadata("as.kt")
            public void testAs() throws Exception {
                runTest("idea/testData/quickfix/suppress/forStatement/as.kt");
            }

            @TestMetadata("asSafe.kt")
            public void testAsSafe() throws Exception {
                runTest("idea/testData/quickfix/suppress/forStatement/asSafe.kt");
            }

            @TestMetadata("assign.kt")
            public void testAssign() throws Exception {
                runTest("idea/testData/quickfix/suppress/forStatement/assign.kt");
            }

            @TestMetadata("call.kt")
            public void testCall() throws Exception {
                runTest("idea/testData/quickfix/suppress/forStatement/call.kt");
            }

            @TestMetadata("doWhile.kt")
            public void testDoWhile() throws Exception {
                runTest("idea/testData/quickfix/suppress/forStatement/doWhile.kt");
            }

            @TestMetadata("dotQualified.kt")
            public void testDotQualified() throws Exception {
                runTest("idea/testData/quickfix/suppress/forStatement/dotQualified.kt");
            }

            @TestMetadata("elvis.kt")
            public void testElvis() throws Exception {
                runTest("idea/testData/quickfix/suppress/forStatement/elvis.kt");
            }

            @TestMetadata("eqEq.kt")
            public void testEqEq() throws Exception {
                runTest("idea/testData/quickfix/suppress/forStatement/eqEq.kt");
            }

            @TestMetadata("for.kt")
            public void testFor() throws Exception {
                runTest("idea/testData/quickfix/suppress/forStatement/for.kt");
            }

            @TestMetadata("if.kt")
            public void testIf() throws Exception {
                runTest("idea/testData/quickfix/suppress/forStatement/if.kt");
            }

            @TestMetadata("in.kt")
            public void testIn() throws Exception {
                runTest("idea/testData/quickfix/suppress/forStatement/in.kt");
            }

            @TestMetadata("infix.kt")
            public void testInfix() throws Exception {
                runTest("idea/testData/quickfix/suppress/forStatement/infix.kt");
            }

            @TestMetadata("is.kt")
            public void testIs() throws Exception {
                runTest("idea/testData/quickfix/suppress/forStatement/is.kt");
            }

            @TestMetadata("labeled.kt")
            public void testLabeled() throws Exception {
                runTest("idea/testData/quickfix/suppress/forStatement/labeled.kt");
            }

            @TestMetadata("less.kt")
            public void testLess() throws Exception {
                runTest("idea/testData/quickfix/suppress/forStatement/less.kt");
            }

            @TestMetadata("mul.kt")
            public void testMul() throws Exception {
                runTest("idea/testData/quickfix/suppress/forStatement/mul.kt");
            }

            @TestMetadata("orOr.kt")
            public void testOrOr() throws Exception {
                runTest("idea/testData/quickfix/suppress/forStatement/orOr.kt");
            }

            @TestMetadata("parenthesized.kt")
            public void testParenthesized() throws Exception {
                runTest("idea/testData/quickfix/suppress/forStatement/parenthesized.kt");
            }

            @TestMetadata("plus.kt")
            public void testPlus() throws Exception {
                runTest("idea/testData/quickfix/suppress/forStatement/plus.kt");
            }

            @TestMetadata("postfix.kt")
            public void testPostfix() throws Exception {
                runTest("idea/testData/quickfix/suppress/forStatement/postfix.kt");
            }

            @TestMetadata("postfixPlusPlus.kt")
            public void testPostfixPlusPlus() throws Exception {
                runTest("idea/testData/quickfix/suppress/forStatement/postfixPlusPlus.kt");
            }

            @TestMetadata("prefixPlusPlus.kt")
            public void testPrefixPlusPlus() throws Exception {
                runTest("idea/testData/quickfix/suppress/forStatement/prefixPlusPlus.kt");
            }

            @TestMetadata("range.kt")
            public void testRange() throws Exception {
                runTest("idea/testData/quickfix/suppress/forStatement/range.kt");
            }

            @TestMetadata("return.kt")
            public void testReturn() throws Exception {
                runTest("idea/testData/quickfix/suppress/forStatement/return.kt");
            }

            @TestMetadata("safeQualified.kt")
            public void testSafeQualified() throws Exception {
                runTest("idea/testData/quickfix/suppress/forStatement/safeQualified.kt");
            }

            @TestMetadata("simpleName.kt")
            public void testSimpleName() throws Exception {
                runTest("idea/testData/quickfix/suppress/forStatement/simpleName.kt");
            }

            @TestMetadata("stringTemplate.kt")
            public void testStringTemplate() throws Exception {
                runTest("idea/testData/quickfix/suppress/forStatement/stringTemplate.kt");
            }

            @TestMetadata("throw.kt")
            public void testThrow() throws Exception {
                runTest("idea/testData/quickfix/suppress/forStatement/throw.kt");
            }

            @TestMetadata("try.kt")
            public void testTry() throws Exception {
                runTest("idea/testData/quickfix/suppress/forStatement/try.kt");
            }

            @TestMetadata("whenExpressionEntry.kt")
            public void testWhenExpressionEntry() throws Exception {
                runTest("idea/testData/quickfix/suppress/forStatement/whenExpressionEntry.kt");
            }

            @TestMetadata("whenInEntry.kt")
            public void testWhenInEntry() throws Exception {
                runTest("idea/testData/quickfix/suppress/forStatement/whenInEntry.kt");
            }

            @TestMetadata("whenIsEntry.kt")
            public void testWhenIsEntry() throws Exception {
                runTest("idea/testData/quickfix/suppress/forStatement/whenIsEntry.kt");
            }

            @TestMetadata("whenSubject.kt")
            public void testWhenSubject() throws Exception {
                runTest("idea/testData/quickfix/suppress/forStatement/whenSubject.kt");
            }

            @TestMetadata("while.kt")
            public void testWhile() throws Exception {
                runTest("idea/testData/quickfix/suppress/forStatement/while.kt");
            }

            @TestMetadata("idea/testData/quickfix/suppress/forStatement/unavailable")
            @TestDataPath("$PROJECT_ROOT")
            @RunWith(JUnit3RunnerWithInners.class)
            public static class Unavailable extends AbstractQuickFixTest {
                private void runTest(String testDataFilePath) throws Exception {
                    KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
                }

                public void testAllFilesPresentInUnavailable() throws Exception {
                    KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/quickfix/suppress/forStatement/unavailable"), Pattern.compile("^([\\w\\-_]+)\\.kt$"), TargetBackend.ANY, true);
                }

                @TestMetadata("inAnnotationArgument.kt")
                public void testInAnnotationArgument() throws Exception {
                    runTest("idea/testData/quickfix/suppress/forStatement/unavailable/inAnnotationArgument.kt");
                }

                @TestMetadata("inClassHeader.kt")
                public void testInClassHeader() throws Exception {
                    runTest("idea/testData/quickfix/suppress/forStatement/unavailable/inClassHeader.kt");
                }

                @TestMetadata("inDefaultArgument.kt")
                public void testInDefaultArgument() throws Exception {
                    runTest("idea/testData/quickfix/suppress/forStatement/unavailable/inDefaultArgument.kt");
                }

                @TestMetadata("inExpressionBody.kt")
                public void testInExpressionBody() throws Exception {
                    runTest("idea/testData/quickfix/suppress/forStatement/unavailable/inExpressionBody.kt");
                }

                @TestMetadata("inLocalValInitializer.kt")
                public void testInLocalValInitializer() throws Exception {
                    runTest("idea/testData/quickfix/suppress/forStatement/unavailable/inLocalValInitializer.kt");
                }

                @TestMetadata("inParameterType.kt")
                public void testInParameterType() throws Exception {
                    runTest("idea/testData/quickfix/suppress/forStatement/unavailable/inParameterType.kt");
                }

                @TestMetadata("inParameterTypeInFunctionLiteral.kt")
                public void testInParameterTypeInFunctionLiteral() throws Exception {
                    runTest("idea/testData/quickfix/suppress/forStatement/unavailable/inParameterTypeInFunctionLiteral.kt");
                }

                @TestMetadata("inPropertyInitializer.kt")
                public void testInPropertyInitializer() throws Exception {
                    runTest("idea/testData/quickfix/suppress/forStatement/unavailable/inPropertyInitializer.kt");
                }

                @TestMetadata("objectLiteral.kt")
                public void testObjectLiteral() throws Exception {
                    runTest("idea/testData/quickfix/suppress/forStatement/unavailable/objectLiteral.kt");
                }

                @TestMetadata("objectLiteralInsideExpression.kt")
                public void testObjectLiteralInsideExpression() throws Exception {
                    runTest("idea/testData/quickfix/suppress/forStatement/unavailable/objectLiteralInsideExpression.kt");
                }

                @TestMetadata("supretype.kt")
                public void testSupretype() throws Exception {
                    runTest("idea/testData/quickfix/suppress/forStatement/unavailable/supretype.kt");
                }
            }
        }

        @TestMetadata("idea/testData/quickfix/suppress/inspections")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class Inspections extends AbstractQuickFixTest {
            private void runTest(String testDataFilePath) throws Exception {
                KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
            }

            public void testAllFilesPresentInInspections() throws Exception {
                KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/quickfix/suppress/inspections"), Pattern.compile("^([\\w\\-_]+)\\.kt$"), TargetBackend.ANY, true);
            }

            @TestMetadata("ifNullToElvis.kt")
            public void testIfNullToElvis() throws Exception {
                runTest("idea/testData/quickfix/suppress/inspections/ifNullToElvis.kt");
            }

            @TestMetadata("unusedImports.kt")
            public void testUnusedImports() throws Exception {
                runTest("idea/testData/quickfix/suppress/inspections/unusedImports.kt");
            }
        }
    }

    @TestMetadata("idea/testData/quickfix/surroundWithArrayOfForNamedArgumentsToVarargs")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class SurroundWithArrayOfForNamedArgumentsToVarargs extends AbstractQuickFixTest {
        private void runTest(String testDataFilePath) throws Exception {
            KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
        }

        public void testAllFilesPresentInSurroundWithArrayOfForNamedArgumentsToVarargs() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/quickfix/surroundWithArrayOfForNamedArgumentsToVarargs"), Pattern.compile("^([\\w\\-_]+)\\.kt$"), TargetBackend.ANY, true);
        }

        @TestMetadata("replaceForVarargOfAny.kt")
        public void testReplaceForVarargOfAny() throws Exception {
            runTest("idea/testData/quickfix/surroundWithArrayOfForNamedArgumentsToVarargs/replaceForVarargOfAny.kt");
        }

        @TestMetadata("replaceForbiddenAssigningIntoArrayCall.kt")
        public void testReplaceForbiddenAssigningIntoArrayCall() throws Exception {
            runTest("idea/testData/quickfix/surroundWithArrayOfForNamedArgumentsToVarargs/replaceForbiddenAssigningIntoArrayCall.kt");
        }

        @TestMetadata("replaceToArrayOfPrimitiveTypes.kt")
        public void testReplaceToArrayOfPrimitiveTypes() throws Exception {
            runTest("idea/testData/quickfix/surroundWithArrayOfForNamedArgumentsToVarargs/replaceToArrayOfPrimitiveTypes.kt");
        }

        @TestMetadata("simpleNamedArgumentToVararg.kt")
        public void testSimpleNamedArgumentToVararg() throws Exception {
            runTest("idea/testData/quickfix/surroundWithArrayOfForNamedArgumentsToVarargs/simpleNamedArgumentToVararg.kt");
        }

        @TestMetadata("surroundWithSpreadForConstructorCall.kt")
        public void testSurroundWithSpreadForConstructorCall() throws Exception {
            runTest("idea/testData/quickfix/surroundWithArrayOfForNamedArgumentsToVarargs/surroundWithSpreadForConstructorCall.kt");
        }
    }

    @TestMetadata("idea/testData/quickfix/surroundWithNullCheck")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class SurroundWithNullCheck extends AbstractQuickFixTest {
        private void runTest(String testDataFilePath) throws Exception {
            KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
        }

        public void testAllFilesPresentInSurroundWithNullCheck() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/quickfix/surroundWithNullCheck"), Pattern.compile("^([\\w\\-_]+)\\.kt$"), TargetBackend.ANY, true);
        }

        @TestMetadata("argumentNullable.kt")
        public void testArgumentNullable() throws Exception {
            runTest("idea/testData/quickfix/surroundWithNullCheck/argumentNullable.kt");
        }

        @TestMetadata("chainedUnsafeCall.kt")
        public void testChainedUnsafeCall() throws Exception {
            runTest("idea/testData/quickfix/surroundWithNullCheck/chainedUnsafeCall.kt");
        }

        @TestMetadata("expressionUnsafeCall.kt")
        public void testExpressionUnsafeCall() throws Exception {
            runTest("idea/testData/quickfix/surroundWithNullCheck/expressionUnsafeCall.kt");
        }

        @TestMetadata("infixUnsafeCall.kt")
        public void testInfixUnsafeCall() throws Exception {
            runTest("idea/testData/quickfix/surroundWithNullCheck/infixUnsafeCall.kt");
        }

        @TestMetadata("invokeFuncUnsafe.kt")
        public void testInvokeFuncUnsafe() throws Exception {
            runTest("idea/testData/quickfix/surroundWithNullCheck/invokeFuncUnsafe.kt");
        }

        @TestMetadata("invokeUnsafe.kt")
        public void testInvokeUnsafe() throws Exception {
            runTest("idea/testData/quickfix/surroundWithNullCheck/invokeUnsafe.kt");
        }

        @TestMetadata("iteratorUnsafe.kt")
        public void testIteratorUnsafe() throws Exception {
            runTest("idea/testData/quickfix/surroundWithNullCheck/iteratorUnsafe.kt");
        }

        @TestMetadata("nullableInCondition.kt")
        public void testNullableInCondition() throws Exception {
            runTest("idea/testData/quickfix/surroundWithNullCheck/nullableInCondition.kt");
        }

        @TestMetadata("objectNestedQualifiers.kt")
        public void testObjectNestedQualifiers() throws Exception {
            runTest("idea/testData/quickfix/surroundWithNullCheck/objectNestedQualifiers.kt");
        }

        @TestMetadata("objectQualifier.kt")
        public void testObjectQualifier() throws Exception {
            runTest("idea/testData/quickfix/surroundWithNullCheck/objectQualifier.kt");
        }

        @TestMetadata("simpleUnsafeCall.kt")
        public void testSimpleUnsafeCall() throws Exception {
            runTest("idea/testData/quickfix/surroundWithNullCheck/simpleUnsafeCall.kt");
        }

        @TestMetadata("unsafeCallInBinary.kt")
        public void testUnsafeCallInBinary() throws Exception {
            runTest("idea/testData/quickfix/surroundWithNullCheck/unsafeCallInBinary.kt");
        }

        @TestMetadata("unsafeCallInDeclaration.kt")
        public void testUnsafeCallInDeclaration() throws Exception {
            runTest("idea/testData/quickfix/surroundWithNullCheck/unsafeCallInDeclaration.kt");
        }

        @TestMetadata("unsafeCallInGetter.kt")
        public void testUnsafeCallInGetter() throws Exception {
            runTest("idea/testData/quickfix/surroundWithNullCheck/unsafeCallInGetter.kt");
        }

        @TestMetadata("unsafeCallInsideAnonymous.kt")
        public void testUnsafeCallInsideAnonymous() throws Exception {
            runTest("idea/testData/quickfix/surroundWithNullCheck/unsafeCallInsideAnonymous.kt");
        }

        @TestMetadata("unsafeCallInsideIf.kt")
        public void testUnsafeCallInsideIf() throws Exception {
            runTest("idea/testData/quickfix/surroundWithNullCheck/unsafeCallInsideIf.kt");
        }

        @TestMetadata("unsafeCallInsideWhen.kt")
        public void testUnsafeCallInsideWhen() throws Exception {
            runTest("idea/testData/quickfix/surroundWithNullCheck/unsafeCallInsideWhen.kt");
        }

        @TestMetadata("unsafeCallInsideWhile.kt")
        public void testUnsafeCallInsideWhile() throws Exception {
            runTest("idea/testData/quickfix/surroundWithNullCheck/unsafeCallInsideWhile.kt");
        }

        @TestMetadata("unstableValue.kt")
        public void testUnstableValue() throws Exception {
            runTest("idea/testData/quickfix/surroundWithNullCheck/unstableValue.kt");
        }
    }

    @TestMetadata("idea/testData/quickfix/suspiciousCollectionReassignment")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class SuspiciousCollectionReassignment extends AbstractQuickFixTest {
        private void runTest(String testDataFilePath) throws Exception {
            KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
        }

        public void testAllFilesPresentInSuspiciousCollectionReassignment() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/quickfix/suspiciousCollectionReassignment"), Pattern.compile("^([\\w\\-_]+)\\.kt$"), TargetBackend.ANY, true);
        }

        @TestMetadata("idea/testData/quickfix/suspiciousCollectionReassignment/changeTypeToMutable")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class ChangeTypeToMutable extends AbstractQuickFixTest {
            private void runTest(String testDataFilePath) throws Exception {
                KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
            }

            public void testAllFilesPresentInChangeTypeToMutable() throws Exception {
                KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/quickfix/suspiciousCollectionReassignment/changeTypeToMutable"), Pattern.compile("^([\\w\\-_]+)\\.kt$"), TargetBackend.ANY, true);
            }

            @TestMetadata("hasType.kt")
            public void testHasType() throws Exception {
                runTest("idea/testData/quickfix/suspiciousCollectionReassignment/changeTypeToMutable/hasType.kt");
            }

            @TestMetadata("hasType2.kt")
            public void testHasType2() throws Exception {
                runTest("idea/testData/quickfix/suspiciousCollectionReassignment/changeTypeToMutable/hasType2.kt");
            }

            @TestMetadata("mutableListOf.kt")
            public void testMutableListOf() throws Exception {
                runTest("idea/testData/quickfix/suspiciousCollectionReassignment/changeTypeToMutable/mutableListOf.kt");
            }

            @TestMetadata("mutableMapOf.kt")
            public void testMutableMapOf() throws Exception {
                runTest("idea/testData/quickfix/suspiciousCollectionReassignment/changeTypeToMutable/mutableMapOf.kt");
            }

            @TestMetadata("mutableSetOf.kt")
            public void testMutableSetOf() throws Exception {
                runTest("idea/testData/quickfix/suspiciousCollectionReassignment/changeTypeToMutable/mutableSetOf.kt");
            }

            @TestMetadata("noInitializer.kt")
            public void testNoInitializer() throws Exception {
                runTest("idea/testData/quickfix/suspiciousCollectionReassignment/changeTypeToMutable/noInitializer.kt");
            }

            @TestMetadata("notLocal.kt")
            public void testNotLocal() throws Exception {
                runTest("idea/testData/quickfix/suspiciousCollectionReassignment/changeTypeToMutable/notLocal.kt");
            }

            @TestMetadata("toMutableList.kt")
            public void testToMutableList() throws Exception {
                runTest("idea/testData/quickfix/suspiciousCollectionReassignment/changeTypeToMutable/toMutableList.kt");
            }

            @TestMetadata("toMutableList2.kt")
            public void testToMutableList2() throws Exception {
                runTest("idea/testData/quickfix/suspiciousCollectionReassignment/changeTypeToMutable/toMutableList2.kt");
            }

            @TestMetadata("toMutableMap.kt")
            public void testToMutableMap() throws Exception {
                runTest("idea/testData/quickfix/suspiciousCollectionReassignment/changeTypeToMutable/toMutableMap.kt");
            }

            @TestMetadata("toMutableSet.kt")
            public void testToMutableSet() throws Exception {
                runTest("idea/testData/quickfix/suspiciousCollectionReassignment/changeTypeToMutable/toMutableSet.kt");
            }
        }

        @TestMetadata("idea/testData/quickfix/suspiciousCollectionReassignment/joinWithInitializer")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class JoinWithInitializer extends AbstractQuickFixTest {
            private void runTest(String testDataFilePath) throws Exception {
                KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
            }

            public void testAllFilesPresentInJoinWithInitializer() throws Exception {
                KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/quickfix/suspiciousCollectionReassignment/joinWithInitializer"), Pattern.compile("^([\\w\\-_]+)\\.kt$"), TargetBackend.ANY, true);
            }

            @TestMetadata("noInitializer.kt")
            public void testNoInitializer() throws Exception {
                runTest("idea/testData/quickfix/suspiciousCollectionReassignment/joinWithInitializer/noInitializer.kt");
            }

            @TestMetadata("notLocal.kt")
            public void testNotLocal() throws Exception {
                runTest("idea/testData/quickfix/suspiciousCollectionReassignment/joinWithInitializer/notLocal.kt");
            }

            @TestMetadata("simple.kt")
            public void testSimple() throws Exception {
                runTest("idea/testData/quickfix/suspiciousCollectionReassignment/joinWithInitializer/simple.kt");
            }

            @TestMetadata("used.kt")
            public void testUsed() throws Exception {
                runTest("idea/testData/quickfix/suspiciousCollectionReassignment/joinWithInitializer/used.kt");
            }
        }

        @TestMetadata("idea/testData/quickfix/suspiciousCollectionReassignment/replaceWithAssignment")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class ReplaceWithAssignment extends AbstractQuickFixTest {
            private void runTest(String testDataFilePath) throws Exception {
                KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
            }

            public void testAllFilesPresentInReplaceWithAssignment() throws Exception {
                KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/quickfix/suspiciousCollectionReassignment/replaceWithAssignment"), Pattern.compile("^([\\w\\-_]+)\\.kt$"), TargetBackend.ANY, true);
            }

            @TestMetadata("differentType.kt")
            public void testDifferentType() throws Exception {
                runTest("idea/testData/quickfix/suspiciousCollectionReassignment/replaceWithAssignment/differentType.kt");
            }

            @TestMetadata("emptyList.kt")
            public void testEmptyList() throws Exception {
                runTest("idea/testData/quickfix/suspiciousCollectionReassignment/replaceWithAssignment/emptyList.kt");
            }

            @TestMetadata("emptyListOf.kt")
            public void testEmptyListOf() throws Exception {
                runTest("idea/testData/quickfix/suspiciousCollectionReassignment/replaceWithAssignment/emptyListOf.kt");
            }

            @TestMetadata("emptyMap.kt")
            public void testEmptyMap() throws Exception {
                runTest("idea/testData/quickfix/suspiciousCollectionReassignment/replaceWithAssignment/emptyMap.kt");
            }

            @TestMetadata("emptyMapOf.kt")
            public void testEmptyMapOf() throws Exception {
                runTest("idea/testData/quickfix/suspiciousCollectionReassignment/replaceWithAssignment/emptyMapOf.kt");
            }

            @TestMetadata("emptySet.kt")
            public void testEmptySet() throws Exception {
                runTest("idea/testData/quickfix/suspiciousCollectionReassignment/replaceWithAssignment/emptySet.kt");
            }

            @TestMetadata("emptySetOf.kt")
            public void testEmptySetOf() throws Exception {
                runTest("idea/testData/quickfix/suspiciousCollectionReassignment/replaceWithAssignment/emptySetOf.kt");
            }

            @TestMetadata("listOf.kt")
            public void testListOf() throws Exception {
                runTest("idea/testData/quickfix/suspiciousCollectionReassignment/replaceWithAssignment/listOf.kt");
            }

            @TestMetadata("mapOf.kt")
            public void testMapOf() throws Exception {
                runTest("idea/testData/quickfix/suspiciousCollectionReassignment/replaceWithAssignment/mapOf.kt");
            }

            @TestMetadata("minusEq.kt")
            public void testMinusEq() throws Exception {
                runTest("idea/testData/quickfix/suspiciousCollectionReassignment/replaceWithAssignment/minusEq.kt");
            }

            @TestMetadata("noInitializer.kt")
            public void testNoInitializer() throws Exception {
                runTest("idea/testData/quickfix/suspiciousCollectionReassignment/replaceWithAssignment/noInitializer.kt");
            }

            @TestMetadata("notEmpty.kt")
            public void testNotEmpty() throws Exception {
                runTest("idea/testData/quickfix/suspiciousCollectionReassignment/replaceWithAssignment/notEmpty.kt");
            }

            @TestMetadata("notLocal.kt")
            public void testNotLocal() throws Exception {
                runTest("idea/testData/quickfix/suspiciousCollectionReassignment/replaceWithAssignment/notLocal.kt");
            }

            @TestMetadata("setOf.kt")
            public void testSetOf() throws Exception {
                runTest("idea/testData/quickfix/suspiciousCollectionReassignment/replaceWithAssignment/setOf.kt");
            }

            @TestMetadata("used.kt")
            public void testUsed() throws Exception {
                runTest("idea/testData/quickfix/suspiciousCollectionReassignment/replaceWithAssignment/used.kt");
            }
        }

        @TestMetadata("idea/testData/quickfix/suspiciousCollectionReassignment/replaceWithFilter")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class ReplaceWithFilter extends AbstractQuickFixTest {
            private void runTest(String testDataFilePath) throws Exception {
                KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
            }

            public void testAllFilesPresentInReplaceWithFilter() throws Exception {
                KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/quickfix/suspiciousCollectionReassignment/replaceWithFilter"), Pattern.compile("^([\\w\\-_]+)\\.kt$"), TargetBackend.ANY, true);
            }

            @TestMetadata("map.kt")
            public void testMap() throws Exception {
                runTest("idea/testData/quickfix/suspiciousCollectionReassignment/replaceWithFilter/map.kt");
            }

            @TestMetadata("minusEq.kt")
            public void testMinusEq() throws Exception {
                runTest("idea/testData/quickfix/suspiciousCollectionReassignment/replaceWithFilter/minusEq.kt");
            }

            @TestMetadata("notIterable.kt")
            public void testNotIterable() throws Exception {
                runTest("idea/testData/quickfix/suspiciousCollectionReassignment/replaceWithFilter/notIterable.kt");
            }

            @TestMetadata("plusEq.kt")
            public void testPlusEq() throws Exception {
                runTest("idea/testData/quickfix/suspiciousCollectionReassignment/replaceWithFilter/plusEq.kt");
            }
        }

        @TestMetadata("idea/testData/quickfix/suspiciousCollectionReassignment/replaceWithOrdinaryAssignment")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class ReplaceWithOrdinaryAssignment extends AbstractQuickFixTest {
            private void runTest(String testDataFilePath) throws Exception {
                KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
            }

            public void testAllFilesPresentInReplaceWithOrdinaryAssignment() throws Exception {
                KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/quickfix/suspiciousCollectionReassignment/replaceWithOrdinaryAssignment"), Pattern.compile("^([\\w\\-_]+)\\.kt$"), TargetBackend.ANY, true);
            }

            @TestMetadata("simple.kt")
            public void testSimple() throws Exception {
                runTest("idea/testData/quickfix/suspiciousCollectionReassignment/replaceWithOrdinaryAssignment/simple.kt");
            }
        }
    }

    @TestMetadata("idea/testData/quickfix/toString")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class ToString extends AbstractQuickFixTest {
        private void runTest(String testDataFilePath) throws Exception {
            KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
        }

        public void testAllFilesPresentInToString() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/quickfix/toString"), Pattern.compile("^([\\w\\-_]+)\\.kt$"), TargetBackend.ANY, true);
        }

        @TestMetadata("notNullableExpectedNullable.kt")
        public void testNotNullableExpectedNullable() throws Exception {
            runTest("idea/testData/quickfix/toString/notNullableExpectedNullable.kt");
        }

        @TestMetadata("nullableExpectedNotNullable.kt")
        public void testNullableExpectedNotNullable() throws Exception {
            runTest("idea/testData/quickfix/toString/nullableExpectedNotNullable.kt");
        }

        @TestMetadata("nullableExpectedNullable.kt")
        public void testNullableExpectedNullable() throws Exception {
            runTest("idea/testData/quickfix/toString/nullableExpectedNullable.kt");
        }

        @TestMetadata("simple.kt")
        public void testSimple() throws Exception {
            runTest("idea/testData/quickfix/toString/simple.kt");
        }
    }

    @TestMetadata("idea/testData/quickfix/tooLongCharLiteralToString")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class TooLongCharLiteralToString extends AbstractQuickFixTest {
        private void runTest(String testDataFilePath) throws Exception {
            KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
        }

        public void testAllFilesPresentInTooLongCharLiteralToString() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/quickfix/tooLongCharLiteralToString"), Pattern.compile("^([\\w\\-_]+)\\.kt$"), TargetBackend.ANY, true);
        }

        @TestMetadata("backslash.kt")
        public void testBackslash() throws Exception {
            runTest("idea/testData/quickfix/tooLongCharLiteralToString/backslash.kt");
        }

        @TestMetadata("backslashShouldNotBeEscaped.kt")
        public void testBackslashShouldNotBeEscaped() throws Exception {
            runTest("idea/testData/quickfix/tooLongCharLiteralToString/backslashShouldNotBeEscaped.kt");
        }

        @TestMetadata("dollarShouldNotBeEscaped.kt")
        public void testDollarShouldNotBeEscaped() throws Exception {
            runTest("idea/testData/quickfix/tooLongCharLiteralToString/dollarShouldNotBeEscaped.kt");
        }

        @TestMetadata("doubleQuotesShouldBeEscaped.kt")
        public void testDoubleQuotesShouldBeEscaped() throws Exception {
            runTest("idea/testData/quickfix/tooLongCharLiteralToString/doubleQuotesShouldBeEscaped.kt");
        }

        @TestMetadata("ecapedDoubleQuotesShouldNotBeEscaped.kt")
        public void testEcapedDoubleQuotesShouldNotBeEscaped() throws Exception {
            runTest("idea/testData/quickfix/tooLongCharLiteralToString/ecapedDoubleQuotesShouldNotBeEscaped.kt");
        }

        @TestMetadata("startWithBackslash.kt")
        public void testStartWithBackslash() throws Exception {
            runTest("idea/testData/quickfix/tooLongCharLiteralToString/startWithBackslash.kt");
        }

        @TestMetadata("startWithBackslashInString.kt")
        public void testStartWithBackslashInString() throws Exception {
            runTest("idea/testData/quickfix/tooLongCharLiteralToString/startWithBackslashInString.kt");
        }
    }

    @TestMetadata("idea/testData/quickfix/typeAddition")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class TypeAddition extends AbstractQuickFixTest {
        private void runTest(String testDataFilePath) throws Exception {
            KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
        }

        public void testAllFilesPresentInTypeAddition() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/quickfix/typeAddition"), Pattern.compile("^([\\w\\-_]+)\\.kt$"), TargetBackend.ANY, true);
        }

        @TestMetadata("ambiguousFunctionReturnType.kt")
        public void testAmbiguousFunctionReturnType() throws Exception {
            runTest("idea/testData/quickfix/typeAddition/ambiguousFunctionReturnType.kt");
        }

        @TestMetadata("ambiguousPropertyReturnType.kt")
        public void testAmbiguousPropertyReturnType() throws Exception {
            runTest("idea/testData/quickfix/typeAddition/ambiguousPropertyReturnType.kt");
        }

        @TestMetadata("changeAccessorTypeToFunctionType.kt")
        public void testChangeAccessorTypeToFunctionType() throws Exception {
            runTest("idea/testData/quickfix/typeAddition/changeAccessorTypeToFunctionType.kt");
        }

        @TestMetadata("noAddErrorType.kt")
        public void testNoAddErrorType() throws Exception {
            runTest("idea/testData/quickfix/typeAddition/noAddErrorType.kt");
        }

        @TestMetadata("propertyHasType.kt")
        public void testPropertyHasType() throws Exception {
            runTest("idea/testData/quickfix/typeAddition/propertyHasType.kt");
        }

        @TestMetadata("propertyWithGetterWithBlockBody.kt")
        public void testPropertyWithGetterWithBlockBody() throws Exception {
            runTest("idea/testData/quickfix/typeAddition/propertyWithGetterWithBlockBody.kt");
        }

        @TestMetadata("propertyWithGetterWithInferredType.kt")
        public void testPropertyWithGetterWithInferredType() throws Exception {
            runTest("idea/testData/quickfix/typeAddition/propertyWithGetterWithInferredType.kt");
        }

        @TestMetadata("propertyWithGetterWithoutType.kt")
        public void testPropertyWithGetterWithoutType() throws Exception {
            runTest("idea/testData/quickfix/typeAddition/propertyWithGetterWithoutType.kt");
        }

        @TestMetadata("propertyWithRecursiveGetter.kt")
        public void testPropertyWithRecursiveGetter() throws Exception {
            runTest("idea/testData/quickfix/typeAddition/propertyWithRecursiveGetter.kt");
        }

        @TestMetadata("propertyWithSetterWithoutType.kt")
        public void testPropertyWithSetterWithoutType() throws Exception {
            runTest("idea/testData/quickfix/typeAddition/propertyWithSetterWithoutType.kt");
        }

        @TestMetadata("protectedFunWithoutReturnType.kt")
        public void testProtectedFunWithoutReturnType() throws Exception {
            runTest("idea/testData/quickfix/typeAddition/protectedFunWithoutReturnType.kt");
        }

        @TestMetadata("publicFunWithoutBody.kt")
        public void testPublicFunWithoutBody() throws Exception {
            runTest("idea/testData/quickfix/typeAddition/publicFunWithoutBody.kt");
        }

        @TestMetadata("publicFunWithoutReturnType.kt")
        public void testPublicFunWithoutReturnType() throws Exception {
            runTest("idea/testData/quickfix/typeAddition/publicFunWithoutReturnType.kt");
        }

        @TestMetadata("publicFunWithoutReturnTypeCaretOnParameter.kt")
        public void testPublicFunWithoutReturnTypeCaretOnParameter() throws Exception {
            runTest("idea/testData/quickfix/typeAddition/publicFunWithoutReturnTypeCaretOnParameter.kt");
        }

        @TestMetadata("publicValWithoutReturnType.kt")
        public void testPublicValWithoutReturnType() throws Exception {
            runTest("idea/testData/quickfix/typeAddition/publicValWithoutReturnType.kt");
        }

        @TestMetadata("publicValWithoutReturnTypeCaretOnPublic.kt")
        public void testPublicValWithoutReturnTypeCaretOnPublic() throws Exception {
            runTest("idea/testData/quickfix/typeAddition/publicValWithoutReturnTypeCaretOnPublic.kt");
        }

        @TestMetadata("wrongGetterParameterType.kt")
        public void testWrongGetterParameterType() throws Exception {
            runTest("idea/testData/quickfix/typeAddition/wrongGetterParameterType.kt");
        }

        @TestMetadata("wrongGetterParameterTypeLongNameRuntime.kt")
        public void testWrongGetterParameterTypeLongNameRuntime() throws Exception {
            runTest("idea/testData/quickfix/typeAddition/wrongGetterParameterTypeLongNameRuntime.kt");
        }

        @TestMetadata("wrongSetterParameterType.kt")
        public void testWrongSetterParameterType() throws Exception {
            runTest("idea/testData/quickfix/typeAddition/wrongSetterParameterType.kt");
        }
    }

    @TestMetadata("idea/testData/quickfix/typeImports")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class TypeImports extends AbstractQuickFixTest {
        private void runTest(String testDataFilePath) throws Exception {
            KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
        }

        public void testAllFilesPresentInTypeImports() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/quickfix/typeImports"), Pattern.compile("^([\\w\\-_]+)\\.kt$"), TargetBackend.ANY, true);
        }

        @TestMetadata("hasThisImport.kt")
        public void testHasThisImport() throws Exception {
            runTest("idea/testData/quickfix/typeImports/hasThisImport.kt");
        }

        @TestMetadata("noImportFromTheSameFile.kt")
        public void testNoImportFromTheSameFile() throws Exception {
            runTest("idea/testData/quickfix/typeImports/noImportFromTheSameFile.kt");
        }

        @TestMetadata("noImportJavaLang.kt")
        public void testNoImportJavaLang() throws Exception {
            runTest("idea/testData/quickfix/typeImports/noImportJavaLang.kt");
        }

        @TestMetadata("noImportJetStandard.kt")
        public void testNoImportJetStandard() throws Exception {
            runTest("idea/testData/quickfix/typeImports/noImportJetStandard.kt");
        }

        @TestMetadata("toImport1.kt")
        public void testToImport1() throws Exception {
            runTest("idea/testData/quickfix/typeImports/toImport1.kt");
        }
    }

    @TestMetadata("idea/testData/quickfix/typeInferenceExpectedTypeMismatch")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class TypeInferenceExpectedTypeMismatch extends AbstractQuickFixTest {
        private void runTest(String testDataFilePath) throws Exception {
            KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
        }

        public void testAllFilesPresentInTypeInferenceExpectedTypeMismatch() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/quickfix/typeInferenceExpectedTypeMismatch"), Pattern.compile("^([\\w\\-_]+)\\.kt$"), TargetBackend.ANY, true);
        }

        @TestMetadata("convertClassToKClass1Runtime.kt")
        public void testConvertClassToKClass1Runtime() throws Exception {
            runTest("idea/testData/quickfix/typeInferenceExpectedTypeMismatch/convertClassToKClass1Runtime.kt");
        }
    }

    @TestMetadata("idea/testData/quickfix/typeMismatch")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class TypeMismatch extends AbstractQuickFixTest {
        private void runTest(String testDataFilePath) throws Exception {
            KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
        }

        @TestMetadata("accessibleLocalClassInReturn.kt")
        public void testAccessibleLocalClassInReturn() throws Exception {
            runTest("idea/testData/quickfix/typeMismatch/accessibleLocalClassInReturn.kt");
        }

        @TestMetadata("addArrayOfType.kt")
        public void testAddArrayOfType() throws Exception {
            runTest("idea/testData/quickfix/typeMismatch/addArrayOfType.kt");
        }

        @TestMetadata("addArrayOfTypeForNamedParameter.kt")
        public void testAddArrayOfTypeForNamedParameter() throws Exception {
            runTest("idea/testData/quickfix/typeMismatch/addArrayOfTypeForNamedParameter.kt");
        }

        @TestMetadata("addExclExclToQualifiedArgument.kt")
        public void testAddExclExclToQualifiedArgument() throws Exception {
            runTest("idea/testData/quickfix/typeMismatch/addExclExclToQualifiedArgument.kt");
        }

        @TestMetadata("addExclExclToRemoveNullability.kt")
        public void testAddExclExclToRemoveNullability() throws Exception {
            runTest("idea/testData/quickfix/typeMismatch/addExclExclToRemoveNullability.kt");
        }

        @TestMetadata("addExclExclToRemoveNullabilityDisabledWhenItCannotHelp.kt")
        public void testAddExclExclToRemoveNullabilityDisabledWhenItCannotHelp() throws Exception {
            runTest("idea/testData/quickfix/typeMismatch/addExclExclToRemoveNullabilityDisabledWhenItCannotHelp.kt");
        }

        @TestMetadata("addExclExclToRemoveNullabilityForGeneric.kt")
        public void testAddExclExclToRemoveNullabilityForGeneric() throws Exception {
            runTest("idea/testData/quickfix/typeMismatch/addExclExclToRemoveNullabilityForGeneric.kt");
        }

        @TestMetadata("addExclExclToRemoveNullabilityForSubclass.kt")
        public void testAddExclExclToRemoveNullabilityForSubclass() throws Exception {
            runTest("idea/testData/quickfix/typeMismatch/addExclExclToRemoveNullabilityForSubclass.kt");
        }

        @TestMetadata("addExclExclWhenSmartCastImpossible.kt")
        public void testAddExclExclWhenSmartCastImpossible() throws Exception {
            runTest("idea/testData/quickfix/typeMismatch/addExclExclWhenSmartCastImpossible.kt");
        }

        @TestMetadata("addIntArrayOf.kt")
        public void testAddIntArrayOf() throws Exception {
            runTest("idea/testData/quickfix/typeMismatch/addIntArrayOf.kt");
        }

        public void testAllFilesPresentInTypeMismatch() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/quickfix/typeMismatch"), Pattern.compile("^([\\w\\-_]+)\\.kt$"), TargetBackend.ANY, true);
        }

        @TestMetadata("anonymousObjectInCall.kt")
        public void testAnonymousObjectInCall() throws Exception {
            runTest("idea/testData/quickfix/typeMismatch/anonymousObjectInCall.kt");
        }

        @TestMetadata("anonymousObjectInInfixCall.kt")
        public void testAnonymousObjectInInfixCall() throws Exception {
            runTest("idea/testData/quickfix/typeMismatch/anonymousObjectInInfixCall.kt");
        }

        @TestMetadata("anonymousObjectInInitializer.kt")
        public void testAnonymousObjectInInitializer() throws Exception {
            runTest("idea/testData/quickfix/typeMismatch/anonymousObjectInInitializer.kt");
        }

        @TestMetadata("anonymousObjectInReturn.kt")
        public void testAnonymousObjectInReturn() throws Exception {
            runTest("idea/testData/quickfix/typeMismatch/anonymousObjectInReturn.kt");
        }

        @TestMetadata("anyInReturn.kt")
        public void testAnyInReturn() throws Exception {
            runTest("idea/testData/quickfix/typeMismatch/anyInReturn.kt");
        }

        @TestMetadata("changeFunctionLiteralParameterTypeToFunctionType.kt")
        public void testChangeFunctionLiteralParameterTypeToFunctionType() throws Exception {
            runTest("idea/testData/quickfix/typeMismatch/changeFunctionLiteralParameterTypeToFunctionType.kt");
        }

        @TestMetadata("changeFunctionLiteralParameterTypeToFunctionTypeLongNameRuntime.kt")
        public void testChangeFunctionLiteralParameterTypeToFunctionTypeLongNameRuntime() throws Exception {
            runTest("idea/testData/quickfix/typeMismatch/changeFunctionLiteralParameterTypeToFunctionTypeLongNameRuntime.kt");
        }

        @TestMetadata("changeFunctionReturnTypeToMatchExpectedTypeOfCall.kt")
        public void testChangeFunctionReturnTypeToMatchExpectedTypeOfCall() throws Exception {
            runTest("idea/testData/quickfix/typeMismatch/changeFunctionReturnTypeToMatchExpectedTypeOfCall.kt");
        }

        @TestMetadata("changeFunctionReturnTypeToMatchExpectedTypeOfCallLongNameRuntime.kt")
        public void testChangeFunctionReturnTypeToMatchExpectedTypeOfCallLongNameRuntime() throws Exception {
            runTest("idea/testData/quickfix/typeMismatch/changeFunctionReturnTypeToMatchExpectedTypeOfCallLongNameRuntime.kt");
        }

        @TestMetadata("changeReturnTypeForTypeInference.kt")
        public void testChangeReturnTypeForTypeInference() throws Exception {
            runTest("idea/testData/quickfix/typeMismatch/changeReturnTypeForTypeInference.kt");
        }

        @TestMetadata("changeReturnTypeForTypeMismatch.kt")
        public void testChangeReturnTypeForTypeMismatch() throws Exception {
            runTest("idea/testData/quickfix/typeMismatch/changeReturnTypeForTypeMismatch.kt");
        }

        @TestMetadata("changeReturnTypeNoFqNameForAnonymousObject.kt")
        public void testChangeReturnTypeNoFqNameForAnonymousObject() throws Exception {
            runTest("idea/testData/quickfix/typeMismatch/changeReturnTypeNoFqNameForAnonymousObject.kt");
        }

        @TestMetadata("changeReturnTypeNoFqNameForCompanionObject.kt")
        public void testChangeReturnTypeNoFqNameForCompanionObject() throws Exception {
            runTest("idea/testData/quickfix/typeMismatch/changeReturnTypeNoFqNameForCompanionObject.kt");
        }

        @TestMetadata("changeReturnTypeNoFqNameForLocalClass.kt")
        public void testChangeReturnTypeNoFqNameForLocalClass() throws Exception {
            runTest("idea/testData/quickfix/typeMismatch/changeReturnTypeNoFqNameForLocalClass.kt");
        }

        @TestMetadata("changeReturnTypeNoFqNameForNestedClass.kt")
        public void testChangeReturnTypeNoFqNameForNestedClass() throws Exception {
            runTest("idea/testData/quickfix/typeMismatch/changeReturnTypeNoFqNameForNestedClass.kt");
        }

        @TestMetadata("changeReturnTypeNoFqNameForTopLevelClass.kt")
        public void testChangeReturnTypeNoFqNameForTopLevelClass() throws Exception {
            runTest("idea/testData/quickfix/typeMismatch/changeReturnTypeNoFqNameForTopLevelClass.kt");
        }

        @TestMetadata("changeReturnTypeToSpecificNullable.kt")
        public void testChangeReturnTypeToSpecificNullable() throws Exception {
            runTest("idea/testData/quickfix/typeMismatch/changeReturnTypeToSpecificNullable.kt");
        }

        @TestMetadata("changeReturnTypeWhenFunctionNameIsMissing.kt")
        public void testChangeReturnTypeWhenFunctionNameIsMissing() throws Exception {
            runTest("idea/testData/quickfix/typeMismatch/changeReturnTypeWhenFunctionNameIsMissing.kt");
        }

        @TestMetadata("changeReturnTypeWhenValueParameterListIsAbsent.kt")
        public void testChangeReturnTypeWhenValueParameterListIsAbsent() throws Exception {
            runTest("idea/testData/quickfix/typeMismatch/changeReturnTypeWhenValueParameterListIsAbsent.kt");
        }

        @TestMetadata("compareToTypeMismatch.kt")
        public void testCompareToTypeMismatch() throws Exception {
            runTest("idea/testData/quickfix/typeMismatch/compareToTypeMismatch.kt");
        }

        @TestMetadata("constantTypeMismatch.kt")
        public void testConstantTypeMismatch() throws Exception {
            runTest("idea/testData/quickfix/typeMismatch/constantTypeMismatch.kt");
        }

        @TestMetadata("dontChangeOverriddenPropertyTypeToErrorType.kt")
        public void testDontChangeOverriddenPropertyTypeToErrorType() throws Exception {
            runTest("idea/testData/quickfix/typeMismatch/dontChangeOverriddenPropertyTypeToErrorType.kt");
        }

        @TestMetadata("expectedParameterTypeMismatch.kt")
        public void testExpectedParameterTypeMismatch() throws Exception {
            runTest("idea/testData/quickfix/typeMismatch/expectedParameterTypeMismatch.kt");
        }

        @TestMetadata("expectedParameterTypeMismatchLongNameRuntime.kt")
        public void testExpectedParameterTypeMismatchLongNameRuntime() throws Exception {
            runTest("idea/testData/quickfix/typeMismatch/expectedParameterTypeMismatchLongNameRuntime.kt");
        }

        @TestMetadata("functionExtensionType.kt")
        public void testFunctionExtensionType() throws Exception {
            runTest("idea/testData/quickfix/typeMismatch/functionExtensionType.kt");
        }

        @TestMetadata("functionNestedType.kt")
        public void testFunctionNestedType() throws Exception {
            runTest("idea/testData/quickfix/typeMismatch/functionNestedType.kt");
        }

        @TestMetadata("functionNestedType2.kt")
        public void testFunctionNestedType2() throws Exception {
            runTest("idea/testData/quickfix/typeMismatch/functionNestedType2.kt");
        }

        @TestMetadata("functionReflectType.kt")
        public void testFunctionReflectType() throws Exception {
            runTest("idea/testData/quickfix/typeMismatch/functionReflectType.kt");
        }

        @TestMetadata("functionType.kt")
        public void testFunctionType() throws Exception {
            runTest("idea/testData/quickfix/typeMismatch/functionType.kt");
        }

        @TestMetadata("hasNextFunctionReturnTypeMismatch.kt")
        public void testHasNextFunctionReturnTypeMismatch() throws Exception {
            runTest("idea/testData/quickfix/typeMismatch/hasNextFunctionReturnTypeMismatch.kt");
        }

        @TestMetadata("intToShortTypeMismatch.kt")
        public void testIntToShortTypeMismatch() throws Exception {
            runTest("idea/testData/quickfix/typeMismatch/intToShortTypeMismatch.kt");
        }

        @TestMetadata("kt17404.kt")
        public void testKt17404() throws Exception {
            runTest("idea/testData/quickfix/typeMismatch/kt17404.kt");
        }

        @TestMetadata("kt25928.kt")
        public void testKt25928() throws Exception {
            runTest("idea/testData/quickfix/typeMismatch/kt25928.kt");
        }

        @TestMetadata("letClassImplementAdditionalInterface.kt")
        public void testLetClassImplementAdditionalInterface() throws Exception {
            runTest("idea/testData/quickfix/typeMismatch/letClassImplementAdditionalInterface.kt");
        }

        @TestMetadata("letClassImplementGenericInterface.kt")
        public void testLetClassImplementGenericInterface() throws Exception {
            runTest("idea/testData/quickfix/typeMismatch/letClassImplementGenericInterface.kt");
        }

        @TestMetadata("letClassImplementGenericInterfaceTwice.kt")
        public void testLetClassImplementGenericInterfaceTwice() throws Exception {
            runTest("idea/testData/quickfix/typeMismatch/letClassImplementGenericInterfaceTwice.kt");
        }

        @TestMetadata("letClassImplementGenericStarInterface.kt")
        public void testLetClassImplementGenericStarInterface() throws Exception {
            runTest("idea/testData/quickfix/typeMismatch/letClassImplementGenericStarInterface.kt");
        }

        @TestMetadata("letClassImplementIndirectlyInheritedInterface.kt")
        public void testLetClassImplementIndirectlyInheritedInterface() throws Exception {
            runTest("idea/testData/quickfix/typeMismatch/letClassImplementIndirectlyInheritedInterface.kt");
        }

        @TestMetadata("letClassImplementInterface.kt")
        public void testLetClassImplementInterface() throws Exception {
            runTest("idea/testData/quickfix/typeMismatch/letClassImplementInterface.kt");
        }

        @TestMetadata("letClassImplementInterfaceNullable.kt")
        public void testLetClassImplementInterfaceNullable() throws Exception {
            runTest("idea/testData/quickfix/typeMismatch/letClassImplementInterfaceNullable.kt");
        }

        @TestMetadata("letInterfaceExtendInterface.kt")
        public void testLetInterfaceExtendInterface() throws Exception {
            runTest("idea/testData/quickfix/typeMismatch/letInterfaceExtendInterface.kt");
        }

        @TestMetadata("letObjectImplementAdditionalInterface.kt")
        public void testLetObjectImplementAdditionalInterface() throws Exception {
            runTest("idea/testData/quickfix/typeMismatch/letObjectImplementAdditionalInterface.kt");
        }

        @TestMetadata("letObjectLiteralImplementInterface.kt")
        public void testLetObjectLiteralImplementInterface() throws Exception {
            runTest("idea/testData/quickfix/typeMismatch/letObjectLiteralImplementInterface.kt");
        }

        @TestMetadata("letStringImplementInterface.kt")
        public void testLetStringImplementInterface() throws Exception {
            runTest("idea/testData/quickfix/typeMismatch/letStringImplementInterface.kt");
        }

        @TestMetadata("localClassInReturn1.kt")
        public void testLocalClassInReturn1() throws Exception {
            runTest("idea/testData/quickfix/typeMismatch/localClassInReturn1.kt");
        }

        @TestMetadata("localClassInReturn2.kt")
        public void testLocalClassInReturn2() throws Exception {
            runTest("idea/testData/quickfix/typeMismatch/localClassInReturn2.kt");
        }

        @TestMetadata("longToDoubleTypeMismatch.kt")
        public void testLongToDoubleTypeMismatch() throws Exception {
            runTest("idea/testData/quickfix/typeMismatch/longToDoubleTypeMismatch.kt");
        }

        @TestMetadata("longToIntTypeMismatch.kt")
        public void testLongToIntTypeMismatch() throws Exception {
            runTest("idea/testData/quickfix/typeMismatch/longToIntTypeMismatch.kt");
        }

        @TestMetadata("makeReturnTypeNullable.kt")
        public void testMakeReturnTypeNullable() throws Exception {
            runTest("idea/testData/quickfix/typeMismatch/makeReturnTypeNullable.kt");
        }

        @TestMetadata("noReturnInFunctionWithBlockBody.kt")
        public void testNoReturnInFunctionWithBlockBody() throws Exception {
            runTest("idea/testData/quickfix/typeMismatch/noReturnInFunctionWithBlockBody.kt");
        }

        @TestMetadata("nullArgumentForNonNullParameter.kt")
        public void testNullArgumentForNonNullParameter() throws Exception {
            runTest("idea/testData/quickfix/typeMismatch/nullArgumentForNonNullParameter.kt");
        }

        @TestMetadata("paramTypeLambdaMatch.kt")
        public void testParamTypeLambdaMatch() throws Exception {
            runTest("idea/testData/quickfix/typeMismatch/paramTypeLambdaMatch.kt");
        }

        @TestMetadata("paramTypeLambdaMatchInt.kt")
        public void testParamTypeLambdaMatchInt() throws Exception {
            runTest("idea/testData/quickfix/typeMismatch/paramTypeLambdaMatchInt.kt");
        }

        @TestMetadata("paramTypeLambdaMatchNullable.kt")
        public void testParamTypeLambdaMatchNullable() throws Exception {
            runTest("idea/testData/quickfix/typeMismatch/paramTypeLambdaMatchNullable.kt");
        }

        @TestMetadata("paramTypeLambdaMatchSubclass.kt")
        public void testParamTypeLambdaMatchSubclass() throws Exception {
            runTest("idea/testData/quickfix/typeMismatch/paramTypeLambdaMatchSubclass.kt");
        }

        @TestMetadata("paramTypeLambdaMismatch.kt")
        public void testParamTypeLambdaMismatch() throws Exception {
            runTest("idea/testData/quickfix/typeMismatch/paramTypeLambdaMismatch.kt");
        }

        @TestMetadata("paramTypeLambdaMismatchNull.kt")
        public void testParamTypeLambdaMismatchNull() throws Exception {
            runTest("idea/testData/quickfix/typeMismatch/paramTypeLambdaMismatchNull.kt");
        }

        @TestMetadata("parameterDefaultValue.kt")
        public void testParameterDefaultValue() throws Exception {
            runTest("idea/testData/quickfix/typeMismatch/parameterDefaultValue.kt");
        }

        @TestMetadata("propertyTypeMismatch.kt")
        public void testPropertyTypeMismatch() throws Exception {
            runTest("idea/testData/quickfix/typeMismatch/propertyTypeMismatch.kt");
        }

        @TestMetadata("propertyTypeMismatchLongNameRuntime.kt")
        public void testPropertyTypeMismatchLongNameRuntime() throws Exception {
            runTest("idea/testData/quickfix/typeMismatch/propertyTypeMismatchLongNameRuntime.kt");
        }

        @TestMetadata("resolvableTypeParams.kt")
        public void testResolvableTypeParams() throws Exception {
            runTest("idea/testData/quickfix/typeMismatch/resolvableTypeParams.kt");
        }

        @TestMetadata("returnTypeMismatch.kt")
        public void testReturnTypeMismatch() throws Exception {
            runTest("idea/testData/quickfix/typeMismatch/returnTypeMismatch.kt");
        }

        @TestMetadata("shortToByteTypeMismatch.kt")
        public void testShortToByteTypeMismatch() throws Exception {
            runTest("idea/testData/quickfix/typeMismatch/shortToByteTypeMismatch.kt");
        }

        @TestMetadata("tooManyArgumentsException.kt")
        public void testTooManyArgumentsException() throws Exception {
            runTest("idea/testData/quickfix/typeMismatch/tooManyArgumentsException.kt");
        }

        @TestMetadata("unresolvableTypeParams.kt")
        public void testUnresolvableTypeParams() throws Exception {
            runTest("idea/testData/quickfix/typeMismatch/unresolvableTypeParams.kt");
        }

        @TestMetadata("when.kt")
        public void testWhen() throws Exception {
            runTest("idea/testData/quickfix/typeMismatch/when.kt");
        }

        @TestMetadata("when2.kt")
        public void testWhen2() throws Exception {
            runTest("idea/testData/quickfix/typeMismatch/when2.kt");
        }

        @TestMetadata("when3.kt")
        public void testWhen3() throws Exception {
            runTest("idea/testData/quickfix/typeMismatch/when3.kt");
        }

        @TestMetadata("wrapWithArrayLiteral.kt")
        public void testWrapWithArrayLiteral() throws Exception {
            runTest("idea/testData/quickfix/typeMismatch/wrapWithArrayLiteral.kt");
        }

        @TestMetadata("idea/testData/quickfix/typeMismatch/casts")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class Casts extends AbstractQuickFixTest {
            private void runTest(String testDataFilePath) throws Exception {
                KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
            }

            public void testAllFilesPresentInCasts() throws Exception {
                KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/quickfix/typeMismatch/casts"), Pattern.compile("^([\\w\\-_]+)\\.kt$"), TargetBackend.ANY, true);
            }

            @TestMetadata("castQualifiedArgument.kt")
            public void testCastQualifiedArgument() throws Exception {
                runTest("idea/testData/quickfix/typeMismatch/casts/castQualifiedArgument.kt");
            }

            @TestMetadata("castToFunctionType.kt")
            public void testCastToFunctionType() throws Exception {
                runTest("idea/testData/quickfix/typeMismatch/casts/castToFunctionType.kt");
            }

            @TestMetadata("preferExclExcl.kt")
            public void testPreferExclExcl() throws Exception {
                runTest("idea/testData/quickfix/typeMismatch/casts/preferExclExcl.kt");
            }

            @TestMetadata("smartcastImpossible1.kt")
            public void testSmartcastImpossible1() throws Exception {
                runTest("idea/testData/quickfix/typeMismatch/casts/smartcastImpossible1.kt");
            }

            @TestMetadata("smartcastImpossible2.kt")
            public void testSmartcastImpossible2() throws Exception {
                runTest("idea/testData/quickfix/typeMismatch/casts/smartcastImpossible2.kt");
            }

            @TestMetadata("smartcastImpossible3.kt")
            public void testSmartcastImpossible3() throws Exception {
                runTest("idea/testData/quickfix/typeMismatch/casts/smartcastImpossible3.kt");
            }

            @TestMetadata("typeMismatch1.kt")
            public void testTypeMismatch1() throws Exception {
                runTest("idea/testData/quickfix/typeMismatch/casts/typeMismatch1.kt");
            }

            @TestMetadata("typeMismatch2.kt")
            public void testTypeMismatch2() throws Exception {
                runTest("idea/testData/quickfix/typeMismatch/casts/typeMismatch2.kt");
            }

            @TestMetadata("typeMismatch3.kt")
            public void testTypeMismatch3() throws Exception {
                runTest("idea/testData/quickfix/typeMismatch/casts/typeMismatch3.kt");
            }

            @TestMetadata("typeMismatch4.kt")
            public void testTypeMismatch4() throws Exception {
                runTest("idea/testData/quickfix/typeMismatch/casts/typeMismatch4.kt");
            }

            @TestMetadata("typeMismatchLongNameRuntime.kt")
            public void testTypeMismatchLongNameRuntime() throws Exception {
                runTest("idea/testData/quickfix/typeMismatch/casts/typeMismatchLongNameRuntime.kt");
            }

            @TestMetadata("unsigned.kt")
            public void testUnsigned() throws Exception {
                runTest("idea/testData/quickfix/typeMismatch/casts/unsigned.kt");
            }
        }

        @TestMetadata("idea/testData/quickfix/typeMismatch/componentFunctionReturnTypeMismatch")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class ComponentFunctionReturnTypeMismatch extends AbstractQuickFixTest {
            private void runTest(String testDataFilePath) throws Exception {
                KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
            }

            public void testAllFilesPresentInComponentFunctionReturnTypeMismatch() throws Exception {
                KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/quickfix/typeMismatch/componentFunctionReturnTypeMismatch"), Pattern.compile("^([\\w\\-_]+)\\.kt$"), TargetBackend.ANY, true);
            }

            @TestMetadata("componentFunctionReturnTypeMismatch1.kt")
            public void testComponentFunctionReturnTypeMismatch1() throws Exception {
                runTest("idea/testData/quickfix/typeMismatch/componentFunctionReturnTypeMismatch/componentFunctionReturnTypeMismatch1.kt");
            }

            @TestMetadata("componentFunctionReturnTypeMismatch2.kt")
            public void testComponentFunctionReturnTypeMismatch2() throws Exception {
                runTest("idea/testData/quickfix/typeMismatch/componentFunctionReturnTypeMismatch/componentFunctionReturnTypeMismatch2.kt");
            }

            @TestMetadata("componentFunctionReturnTypeMismatch3.kt")
            public void testComponentFunctionReturnTypeMismatch3() throws Exception {
                runTest("idea/testData/quickfix/typeMismatch/componentFunctionReturnTypeMismatch/componentFunctionReturnTypeMismatch3.kt");
            }

            @TestMetadata("componentFunctionReturnTypeMismatch4.kt")
            public void testComponentFunctionReturnTypeMismatch4() throws Exception {
                runTest("idea/testData/quickfix/typeMismatch/componentFunctionReturnTypeMismatch/componentFunctionReturnTypeMismatch4.kt");
            }

            @TestMetadata("componentFunctionReturnTypeMismatch5.kt")
            public void testComponentFunctionReturnTypeMismatch5() throws Exception {
                runTest("idea/testData/quickfix/typeMismatch/componentFunctionReturnTypeMismatch/componentFunctionReturnTypeMismatch5.kt");
            }

            @TestMetadata("dataClass.kt")
            public void testDataClass() throws Exception {
                runTest("idea/testData/quickfix/typeMismatch/componentFunctionReturnTypeMismatch/dataClass.kt");
            }
        }

        @TestMetadata("idea/testData/quickfix/typeMismatch/convertCollection")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class ConvertCollection extends AbstractQuickFixTest {
            private void runTest(String testDataFilePath) throws Exception {
                KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
            }

            public void testAllFilesPresentInConvertCollection() throws Exception {
                KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/quickfix/typeMismatch/convertCollection"), Pattern.compile("^([\\w\\-_]+)\\.kt$"), TargetBackend.ANY, true);
            }

            @TestMetadata("arrayToCollection.kt")
            public void testArrayToCollection() throws Exception {
                runTest("idea/testData/quickfix/typeMismatch/convertCollection/arrayToCollection.kt");
            }

            @TestMetadata("arrayToIterable.kt")
            public void testArrayToIterable() throws Exception {
                runTest("idea/testData/quickfix/typeMismatch/convertCollection/arrayToIterable.kt");
            }

            @TestMetadata("arrayToList.kt")
            public void testArrayToList() throws Exception {
                runTest("idea/testData/quickfix/typeMismatch/convertCollection/arrayToList.kt");
            }

            @TestMetadata("arrayToSequence.kt")
            public void testArrayToSequence() throws Exception {
                runTest("idea/testData/quickfix/typeMismatch/convertCollection/arrayToSequence.kt");
            }

            @TestMetadata("iterableToArray.kt")
            public void testIterableToArray() throws Exception {
                runTest("idea/testData/quickfix/typeMismatch/convertCollection/iterableToArray.kt");
            }

            @TestMetadata("listToArray.kt")
            public void testListToArray() throws Exception {
                runTest("idea/testData/quickfix/typeMismatch/convertCollection/listToArray.kt");
            }

            @TestMetadata("listToArrayBinary.kt")
            public void testListToArrayBinary() throws Exception {
                runTest("idea/testData/quickfix/typeMismatch/convertCollection/listToArrayBinary.kt");
            }

            @TestMetadata("listToMutableList.kt")
            public void testListToMutableList() throws Exception {
                runTest("idea/testData/quickfix/typeMismatch/convertCollection/listToMutableList.kt");
            }

            @TestMetadata("listToSequence.kt")
            public void testListToSequence() throws Exception {
                runTest("idea/testData/quickfix/typeMismatch/convertCollection/listToSequence.kt");
            }

            @TestMetadata("sequenceToArray.kt")
            public void testSequenceToArray() throws Exception {
                runTest("idea/testData/quickfix/typeMismatch/convertCollection/sequenceToArray.kt");
            }

            @TestMetadata("sequenceToList.kt")
            public void testSequenceToList() throws Exception {
                runTest("idea/testData/quickfix/typeMismatch/convertCollection/sequenceToList.kt");
            }
        }

        @TestMetadata("idea/testData/quickfix/typeMismatch/fixOverloadedOperator")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class FixOverloadedOperator extends AbstractQuickFixTest {
            private void runTest(String testDataFilePath) throws Exception {
                KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
            }

            public void testAllFilesPresentInFixOverloadedOperator() throws Exception {
                KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/quickfix/typeMismatch/fixOverloadedOperator"), Pattern.compile("^([\\w\\-_]+)\\.kt$"), TargetBackend.ANY, true);
            }

            @TestMetadata("changeNotFunctionReturnType.kt")
            public void testChangeNotFunctionReturnType() throws Exception {
                runTest("idea/testData/quickfix/typeMismatch/fixOverloadedOperator/changeNotFunctionReturnType.kt");
            }

            @TestMetadata("changePlusFunctionReturnType.kt")
            public void testChangePlusFunctionReturnType() throws Exception {
                runTest("idea/testData/quickfix/typeMismatch/fixOverloadedOperator/changePlusFunctionReturnType.kt");
            }

            @TestMetadata("changeTimesFunctionParameterType.kt")
            public void testChangeTimesFunctionParameterType() throws Exception {
                runTest("idea/testData/quickfix/typeMismatch/fixOverloadedOperator/changeTimesFunctionParameterType.kt");
            }
        }

        @TestMetadata("idea/testData/quickfix/typeMismatch/genericVarianceViolation")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class GenericVarianceViolation extends AbstractQuickFixTest {
            private void runTest(String testDataFilePath) throws Exception {
                KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
            }

            public void testAllFilesPresentInGenericVarianceViolation() throws Exception {
                KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/quickfix/typeMismatch/genericVarianceViolation"), Pattern.compile("^([\\w\\-_]+)\\.kt$"), TargetBackend.ANY, true);
            }
        }

        @TestMetadata("idea/testData/quickfix/typeMismatch/numberConversion")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class NumberConversion extends AbstractQuickFixTest {
            private void runTest(String testDataFilePath) throws Exception {
                KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
            }

            public void testAllFilesPresentInNumberConversion() throws Exception {
                KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/quickfix/typeMismatch/numberConversion"), Pattern.compile("^([\\w\\-_]+)\\.kt$"), TargetBackend.ANY, true);
            }

            @TestMetadata("convertBinaryExpression.kt")
            public void testConvertBinaryExpression() throws Exception {
                runTest("idea/testData/quickfix/typeMismatch/numberConversion/convertBinaryExpression.kt");
            }

            @TestMetadata("convertExpression.kt")
            public void testConvertExpression() throws Exception {
                runTest("idea/testData/quickfix/typeMismatch/numberConversion/convertExpression.kt");
            }

            @TestMetadata("convertToSigned.kt")
            public void testConvertToSigned() throws Exception {
                runTest("idea/testData/quickfix/typeMismatch/numberConversion/convertToSigned.kt");
            }

            @TestMetadata("convertToUnsigned.kt")
            public void testConvertToUnsigned() throws Exception {
                runTest("idea/testData/quickfix/typeMismatch/numberConversion/convertToUnsigned.kt");
            }
        }

        @TestMetadata("idea/testData/quickfix/typeMismatch/parameterTypeMismatch")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class ParameterTypeMismatch extends AbstractQuickFixTest {
            private void runTest(String testDataFilePath) throws Exception {
                KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
            }

            public void testAllFilesPresentInParameterTypeMismatch() throws Exception {
                KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/quickfix/typeMismatch/parameterTypeMismatch"), Pattern.compile("^([\\w\\-_]+)\\.kt$"), TargetBackend.ANY, true);
            }

            @TestMetadata("changeFunctionParameterType1.kt")
            public void testChangeFunctionParameterType1() throws Exception {
                runTest("idea/testData/quickfix/typeMismatch/parameterTypeMismatch/changeFunctionParameterType1.kt");
            }

            @TestMetadata("changeFunctionParameterType2.kt")
            public void testChangeFunctionParameterType2() throws Exception {
                runTest("idea/testData/quickfix/typeMismatch/parameterTypeMismatch/changeFunctionParameterType2.kt");
            }

            @TestMetadata("changeFunctionParameterType3.kt")
            public void testChangeFunctionParameterType3() throws Exception {
                runTest("idea/testData/quickfix/typeMismatch/parameterTypeMismatch/changeFunctionParameterType3.kt");
            }

            @TestMetadata("changeFunctionParameterType4.kt")
            public void testChangeFunctionParameterType4() throws Exception {
                runTest("idea/testData/quickfix/typeMismatch/parameterTypeMismatch/changeFunctionParameterType4.kt");
            }

            @TestMetadata("changeParameterTypeLongNameRuntime.kt")
            public void testChangeParameterTypeLongNameRuntime() throws Exception {
                runTest("idea/testData/quickfix/typeMismatch/parameterTypeMismatch/changeParameterTypeLongNameRuntime.kt");
            }

            @TestMetadata("changePrimaryConstructorParameterType.kt")
            public void testChangePrimaryConstructorParameterType() throws Exception {
                runTest("idea/testData/quickfix/typeMismatch/parameterTypeMismatch/changePrimaryConstructorParameterType.kt");
            }

            @TestMetadata("multiFakeOverride.kt")
            public void testMultiFakeOverride() throws Exception {
                runTest("idea/testData/quickfix/typeMismatch/parameterTypeMismatch/multiFakeOverride.kt");
            }

            @TestMetadata("unsigned.kt")
            public void testUnsigned() throws Exception {
                runTest("idea/testData/quickfix/typeMismatch/parameterTypeMismatch/unsigned.kt");
            }
        }

        @TestMetadata("idea/testData/quickfix/typeMismatch/typeMismatchOnReturnedExpression")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class TypeMismatchOnReturnedExpression extends AbstractQuickFixTest {
            private void runTest(String testDataFilePath) throws Exception {
                KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
            }

            public void testAllFilesPresentInTypeMismatchOnReturnedExpression() throws Exception {
                KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/quickfix/typeMismatch/typeMismatchOnReturnedExpression"), Pattern.compile("^([\\w\\-_]+)\\.kt$"), TargetBackend.ANY, true);
            }

            @TestMetadata("assignmentTypeMismatch.kt")
            public void testAssignmentTypeMismatch() throws Exception {
                runTest("idea/testData/quickfix/typeMismatch/typeMismatchOnReturnedExpression/assignmentTypeMismatch.kt");
            }

            @TestMetadata("changeFunctionReturnTypeToFunctionType.kt")
            public void testChangeFunctionReturnTypeToFunctionType() throws Exception {
                runTest("idea/testData/quickfix/typeMismatch/typeMismatchOnReturnedExpression/changeFunctionReturnTypeToFunctionType.kt");
            }

            @TestMetadata("changeFunctionReturnTypeToMatchReturnTypeOfReturnedLiteral.kt")
            public void testChangeFunctionReturnTypeToMatchReturnTypeOfReturnedLiteral() throws Exception {
                runTest("idea/testData/quickfix/typeMismatch/typeMismatchOnReturnedExpression/changeFunctionReturnTypeToMatchReturnTypeOfReturnedLiteral.kt");
            }

            @TestMetadata("dontChangeFunctionReturnTypeToErrorType.kt")
            public void testDontChangeFunctionReturnTypeToErrorType() throws Exception {
                runTest("idea/testData/quickfix/typeMismatch/typeMismatchOnReturnedExpression/dontChangeFunctionReturnTypeToErrorType.kt");
            }

            @TestMetadata("literalPropertyWithGetter.kt")
            public void testLiteralPropertyWithGetter() throws Exception {
                runTest("idea/testData/quickfix/typeMismatch/typeMismatchOnReturnedExpression/literalPropertyWithGetter.kt");
            }

            @TestMetadata("multiFakeOverride.kt")
            public void testMultiFakeOverride() throws Exception {
                runTest("idea/testData/quickfix/typeMismatch/typeMismatchOnReturnedExpression/multiFakeOverride.kt");
            }

            @TestMetadata("multiFakeOverrideForOperatorConvention.kt")
            public void testMultiFakeOverrideForOperatorConvention() throws Exception {
                runTest("idea/testData/quickfix/typeMismatch/typeMismatchOnReturnedExpression/multiFakeOverrideForOperatorConvention.kt");
            }

            @TestMetadata("nonLocalReturnRuntime.kt")
            public void testNonLocalReturnRuntime() throws Exception {
                runTest("idea/testData/quickfix/typeMismatch/typeMismatchOnReturnedExpression/nonLocalReturnRuntime.kt");
            }

            @TestMetadata("nonLocalReturnWithLabelRuntime.kt")
            public void testNonLocalReturnWithLabelRuntime() throws Exception {
                runTest("idea/testData/quickfix/typeMismatch/typeMismatchOnReturnedExpression/nonLocalReturnWithLabelRuntime.kt");
            }

            @TestMetadata("notApplicableToConstructor.kt")
            public void testNotApplicableToConstructor() throws Exception {
                runTest("idea/testData/quickfix/typeMismatch/typeMismatchOnReturnedExpression/notApplicableToConstructor.kt");
            }

            @TestMetadata("propertyGetterInitializerTypeMismatch.kt")
            public void testPropertyGetterInitializerTypeMismatch() throws Exception {
                runTest("idea/testData/quickfix/typeMismatch/typeMismatchOnReturnedExpression/propertyGetterInitializerTypeMismatch.kt");
            }

            @TestMetadata("returnedExpressionTypeMismatchFunctionParameterType.kt")
            public void testReturnedExpressionTypeMismatchFunctionParameterType() throws Exception {
                runTest("idea/testData/quickfix/typeMismatch/typeMismatchOnReturnedExpression/returnedExpressionTypeMismatchFunctionParameterType.kt");
            }

            @TestMetadata("typeMismatchInIfStatementReturnedByFunction.kt")
            public void testTypeMismatchInIfStatementReturnedByFunction() throws Exception {
                runTest("idea/testData/quickfix/typeMismatch/typeMismatchOnReturnedExpression/typeMismatchInIfStatementReturnedByFunction.kt");
            }

            @TestMetadata("typeMismatchInIfStatementReturnedByLiteral.kt")
            public void testTypeMismatchInIfStatementReturnedByLiteral() throws Exception {
                runTest("idea/testData/quickfix/typeMismatch/typeMismatchOnReturnedExpression/typeMismatchInIfStatementReturnedByLiteral.kt");
            }

            @TestMetadata("typeMismatchInInitializer.kt")
            public void testTypeMismatchInInitializer() throws Exception {
                runTest("idea/testData/quickfix/typeMismatch/typeMismatchOnReturnedExpression/typeMismatchInInitializer.kt");
            }

            @TestMetadata("typeMismatchInReturnStatement.kt")
            public void testTypeMismatchInReturnStatement() throws Exception {
                runTest("idea/testData/quickfix/typeMismatch/typeMismatchOnReturnedExpression/typeMismatchInReturnStatement.kt");
            }
        }

        @TestMetadata("idea/testData/quickfix/typeMismatch/wrapWithCollectionLiteral")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class WrapWithCollectionLiteral extends AbstractQuickFixTest {
            private void runTest(String testDataFilePath) throws Exception {
                KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
            }

            public void testAllFilesPresentInWrapWithCollectionLiteral() throws Exception {
                KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/quickfix/typeMismatch/wrapWithCollectionLiteral"), Pattern.compile("^([\\w\\-_]+)\\.kt$"), TargetBackend.ANY, true);
            }

            @TestMetadata("inAnnotation.kt")
            public void testInAnnotation() throws Exception {
                runTest("idea/testData/quickfix/typeMismatch/wrapWithCollectionLiteral/inAnnotation.kt");
            }

            @TestMetadata("noMutableList.kt")
            public void testNoMutableList() throws Exception {
                runTest("idea/testData/quickfix/typeMismatch/wrapWithCollectionLiteral/noMutableList.kt");
            }

            @TestMetadata("nullToListOfNullable.kt")
            public void testNullToListOfNullable() throws Exception {
                runTest("idea/testData/quickfix/typeMismatch/wrapWithCollectionLiteral/nullToListOfNullable.kt");
            }

            @TestMetadata("returnEmptyArray.kt")
            public void testReturnEmptyArray() throws Exception {
                runTest("idea/testData/quickfix/typeMismatch/wrapWithCollectionLiteral/returnEmptyArray.kt");
            }

            @TestMetadata("returnEmptyCollection.kt")
            public void testReturnEmptyCollection() throws Exception {
                runTest("idea/testData/quickfix/typeMismatch/wrapWithCollectionLiteral/returnEmptyCollection.kt");
            }

            @TestMetadata("returnEmptyList.kt")
            public void testReturnEmptyList() throws Exception {
                runTest("idea/testData/quickfix/typeMismatch/wrapWithCollectionLiteral/returnEmptyList.kt");
            }

            @TestMetadata("returnEmptySequence.kt")
            public void testReturnEmptySequence() throws Exception {
                runTest("idea/testData/quickfix/typeMismatch/wrapWithCollectionLiteral/returnEmptySequence.kt");
            }

            @TestMetadata("returnEmptySet.kt")
            public void testReturnEmptySet() throws Exception {
                runTest("idea/testData/quickfix/typeMismatch/wrapWithCollectionLiteral/returnEmptySet.kt");
            }

            @TestMetadata("toArray.kt")
            public void testToArray() throws Exception {
                runTest("idea/testData/quickfix/typeMismatch/wrapWithCollectionLiteral/toArray.kt");
            }

            @TestMetadata("toCollection.kt")
            public void testToCollection() throws Exception {
                runTest("idea/testData/quickfix/typeMismatch/wrapWithCollectionLiteral/toCollection.kt");
            }

            @TestMetadata("toList.kt")
            public void testToList() throws Exception {
                runTest("idea/testData/quickfix/typeMismatch/wrapWithCollectionLiteral/toList.kt");
            }

            @TestMetadata("toListInapplicableType.kt")
            public void testToListInapplicableType() throws Exception {
                runTest("idea/testData/quickfix/typeMismatch/wrapWithCollectionLiteral/toListInapplicableType.kt");
            }

            @TestMetadata("toSequence.kt")
            public void testToSequence() throws Exception {
                runTest("idea/testData/quickfix/typeMismatch/wrapWithCollectionLiteral/toSequence.kt");
            }

            @TestMetadata("toSet.kt")
            public void testToSet() throws Exception {
                runTest("idea/testData/quickfix/typeMismatch/wrapWithCollectionLiteral/toSet.kt");
            }
        }

        @TestMetadata("idea/testData/quickfix/typeMismatch/wrongPrimitive")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class WrongPrimitive extends AbstractQuickFixTest {
            private void runTest(String testDataFilePath) throws Exception {
                KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
            }

            public void testAllFilesPresentInWrongPrimitive() throws Exception {
                KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/quickfix/typeMismatch/wrongPrimitive"), Pattern.compile("^([\\w\\-_]+)\\.kt$"), TargetBackend.ANY, true);
            }

            @TestMetadata("doubleToIntDecimalPlaces.kt")
            public void testDoubleToIntDecimalPlaces() throws Exception {
                runTest("idea/testData/quickfix/typeMismatch/wrongPrimitive/doubleToIntDecimalPlaces.kt");
            }

            @TestMetadata("doubleToLongNotInRange.kt")
            public void testDoubleToLongNotInRange() throws Exception {
                runTest("idea/testData/quickfix/typeMismatch/wrongPrimitive/doubleToLongNotInRange.kt");
            }

            @TestMetadata("doubleToShortNotInRange.kt")
            public void testDoubleToShortNotInRange() throws Exception {
                runTest("idea/testData/quickfix/typeMismatch/wrongPrimitive/doubleToShortNotInRange.kt");
            }

            @TestMetadata("floatToDoubleWithDecimal.kt")
            public void testFloatToDoubleWithDecimal() throws Exception {
                runTest("idea/testData/quickfix/typeMismatch/wrongPrimitive/floatToDoubleWithDecimal.kt");
            }

            @TestMetadata("floatToInt.kt")
            public void testFloatToInt() throws Exception {
                runTest("idea/testData/quickfix/typeMismatch/wrongPrimitive/floatToInt.kt");
            }

            @TestMetadata("floatToInt2.kt")
            public void testFloatToInt2() throws Exception {
                runTest("idea/testData/quickfix/typeMismatch/wrongPrimitive/floatToInt2.kt");
            }

            @TestMetadata("floatToLong.kt")
            public void testFloatToLong() throws Exception {
                runTest("idea/testData/quickfix/typeMismatch/wrongPrimitive/floatToLong.kt");
            }

            @TestMetadata("hexToFloat.kt")
            public void testHexToFloat() throws Exception {
                runTest("idea/testData/quickfix/typeMismatch/wrongPrimitive/hexToFloat.kt");
            }

            @TestMetadata("intToFloat.kt")
            public void testIntToFloat() throws Exception {
                runTest("idea/testData/quickfix/typeMismatch/wrongPrimitive/intToFloat.kt");
            }

            @TestMetadata("intToUnsigned.kt")
            public void testIntToUnsigned() throws Exception {
                runTest("idea/testData/quickfix/typeMismatch/wrongPrimitive/intToUnsigned.kt");
            }

            @TestMetadata("longToDouble.kt")
            public void testLongToDouble() throws Exception {
                runTest("idea/testData/quickfix/typeMismatch/wrongPrimitive/longToDouble.kt");
            }

            @TestMetadata("longToInt.kt")
            public void testLongToInt() throws Exception {
                runTest("idea/testData/quickfix/typeMismatch/wrongPrimitive/longToInt.kt");
            }

            @TestMetadata("longToIntBinary.kt")
            public void testLongToIntBinary() throws Exception {
                runTest("idea/testData/quickfix/typeMismatch/wrongPrimitive/longToIntBinary.kt");
            }

            @TestMetadata("unsignedToInt.kt")
            public void testUnsignedToInt() throws Exception {
                runTest("idea/testData/quickfix/typeMismatch/wrongPrimitive/unsignedToInt.kt");
            }
        }
    }

    @TestMetadata("idea/testData/quickfix/typeOfAnnotationMember")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class TypeOfAnnotationMember extends AbstractQuickFixTest {
        private void runTest(String testDataFilePath) throws Exception {
            KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
        }

        public void testAllFilesPresentInTypeOfAnnotationMember() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/quickfix/typeOfAnnotationMember"), Pattern.compile("^([\\w\\-_]+)\\.kt$"), TargetBackend.ANY, true);
        }

        @TestMetadata("boolean.kt")
        public void testBoolean() throws Exception {
            runTest("idea/testData/quickfix/typeOfAnnotationMember/boolean.kt");
        }

        @TestMetadata("byte.kt")
        public void testByte() throws Exception {
            runTest("idea/testData/quickfix/typeOfAnnotationMember/byte.kt");
        }

        @TestMetadata("char.kt")
        public void testChar() throws Exception {
            runTest("idea/testData/quickfix/typeOfAnnotationMember/char.kt");
        }

        @TestMetadata("float.kt")
        public void testFloat() throws Exception {
            runTest("idea/testData/quickfix/typeOfAnnotationMember/float.kt");
        }

        @TestMetadata("int.kt")
        public void testInt() throws Exception {
            runTest("idea/testData/quickfix/typeOfAnnotationMember/int.kt");
        }

        @TestMetadata("long.kt")
        public void testLong() throws Exception {
            runTest("idea/testData/quickfix/typeOfAnnotationMember/long.kt");
        }

        @TestMetadata("short.kt")
        public void testShort() throws Exception {
            runTest("idea/testData/quickfix/typeOfAnnotationMember/short.kt");
        }

        @TestMetadata("star.kt")
        public void testStar() throws Exception {
            runTest("idea/testData/quickfix/typeOfAnnotationMember/star.kt");
        }

        @TestMetadata("string.kt")
        public void testString() throws Exception {
            runTest("idea/testData/quickfix/typeOfAnnotationMember/string.kt");
        }
    }

    @TestMetadata("idea/testData/quickfix/typeParameters")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class TypeParameters extends AbstractQuickFixTest {
        private void runTest(String testDataFilePath) throws Exception {
            KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
        }

        public void testAllFilesPresentInTypeParameters() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/quickfix/typeParameters"), Pattern.compile("^([\\w\\-_]+)\\.kt$"), TargetBackend.ANY, true);
        }

        @TestMetadata("misplacedClassTypeParameter.kt")
        public void testMisplacedClassTypeParameter() throws Exception {
            runTest("idea/testData/quickfix/typeParameters/misplacedClassTypeParameter.kt");
        }

        @TestMetadata("misplacedFunctionTypeParameter.kt")
        public void testMisplacedFunctionTypeParameter() throws Exception {
            runTest("idea/testData/quickfix/typeParameters/misplacedFunctionTypeParameter.kt");
        }
    }

    @TestMetadata("idea/testData/quickfix/typeProjection")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class TypeProjection extends AbstractQuickFixTest {
        private void runTest(String testDataFilePath) throws Exception {
            KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
        }

        public void testAllFilesPresentInTypeProjection() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/quickfix/typeProjection"), Pattern.compile("^([\\w\\-_]+)\\.kt$"), TargetBackend.ANY, true);
        }

        @TestMetadata("conflictingProjection.kt")
        public void testConflictingProjection() throws Exception {
            runTest("idea/testData/quickfix/typeProjection/conflictingProjection.kt");
        }

        @TestMetadata("projectionInImmediateArgumentToSupertype.kt")
        public void testProjectionInImmediateArgumentToSupertype() throws Exception {
            runTest("idea/testData/quickfix/typeProjection/projectionInImmediateArgumentToSupertype.kt");
        }

        @TestMetadata("projectionOnNonClassTypeArgument1.kt")
        public void testProjectionOnNonClassTypeArgument1() throws Exception {
            runTest("idea/testData/quickfix/typeProjection/projectionOnNonClassTypeArgument1.kt");
        }

        @TestMetadata("projectionOnNonClassTypeArgument2.kt")
        public void testProjectionOnNonClassTypeArgument2() throws Exception {
            runTest("idea/testData/quickfix/typeProjection/projectionOnNonClassTypeArgument2.kt");
        }

        @TestMetadata("removeRedundantProjection1.kt")
        public void testRemoveRedundantProjection1() throws Exception {
            runTest("idea/testData/quickfix/typeProjection/removeRedundantProjection1.kt");
        }

        @TestMetadata("removeRedundantProjection2.kt")
        public void testRemoveRedundantProjection2() throws Exception {
            runTest("idea/testData/quickfix/typeProjection/removeRedundantProjection2.kt");
        }

        @TestMetadata("removeVariance.kt")
        public void testRemoveVariance() throws Exception {
            runTest("idea/testData/quickfix/typeProjection/removeVariance.kt");
        }
    }

    @TestMetadata("idea/testData/quickfix/unnecessaryLateinit")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class UnnecessaryLateinit extends AbstractQuickFixTest {
        private void runTest(String testDataFilePath) throws Exception {
            KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
        }

        public void testAllFilesPresentInUnnecessaryLateinit() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/quickfix/unnecessaryLateinit"), Pattern.compile("^([\\w\\-_]+)\\.kt$"), TargetBackend.ANY, true);
        }

        @TestMetadata("lateinitWithConstructor.kt")
        public void testLateinitWithConstructor() throws Exception {
            runTest("idea/testData/quickfix/unnecessaryLateinit/lateinitWithConstructor.kt");
        }

        @TestMetadata("lateinitWithInit.kt")
        public void testLateinitWithInit() throws Exception {
            runTest("idea/testData/quickfix/unnecessaryLateinit/lateinitWithInit.kt");
        }

        @TestMetadata("lateinitWithMultipleConstructors.kt")
        public void testLateinitWithMultipleConstructors() throws Exception {
            runTest("idea/testData/quickfix/unnecessaryLateinit/lateinitWithMultipleConstructors.kt");
        }

        @TestMetadata("lateinitWithMultipleConstructorsAndDelegation.kt")
        public void testLateinitWithMultipleConstructorsAndDelegation() throws Exception {
            runTest("idea/testData/quickfix/unnecessaryLateinit/lateinitWithMultipleConstructorsAndDelegation.kt");
        }

        @TestMetadata("lateinitWithMultipleInit.kt")
        public void testLateinitWithMultipleInit() throws Exception {
            runTest("idea/testData/quickfix/unnecessaryLateinit/lateinitWithMultipleInit.kt");
        }

        @TestMetadata("secondaryConstructorDelegateItself.kt")
        public void testSecondaryConstructorDelegateItself() throws Exception {
            runTest("idea/testData/quickfix/unnecessaryLateinit/secondaryConstructorDelegateItself.kt");
        }
    }

    @TestMetadata("idea/testData/quickfix/unusedSuppressAnnotation")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class UnusedSuppressAnnotation extends AbstractQuickFixTest {
        private void runTest(String testDataFilePath) throws Exception {
            KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
        }

        public void testAllFilesPresentInUnusedSuppressAnnotation() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/quickfix/unusedSuppressAnnotation"), Pattern.compile("^([\\w\\-_]+)\\.kt$"), TargetBackend.ANY, true);
        }

        @TestMetadata("notForDeprecated.kt")
        public void testNotForDeprecated() throws Exception {
            runTest("idea/testData/quickfix/unusedSuppressAnnotation/notForDeprecated.kt");
        }

        @TestMetadata("notForJava.kt")
        public void testNotForJava() throws Exception {
            runTest("idea/testData/quickfix/unusedSuppressAnnotation/notForJava.kt");
        }

        @TestMetadata("notForJetBrains.kt")
        public void testNotForJetBrains() throws Exception {
            runTest("idea/testData/quickfix/unusedSuppressAnnotation/notForJetBrains.kt");
        }

        @TestMetadata("simple.kt")
        public void testSimple() throws Exception {
            runTest("idea/testData/quickfix/unusedSuppressAnnotation/simple.kt");
        }
    }

    @TestMetadata("idea/testData/quickfix/variables")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class Variables extends AbstractQuickFixTest {
        private void runTest(String testDataFilePath) throws Exception {
            KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
        }

        public void testAllFilesPresentInVariables() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/quickfix/variables"), Pattern.compile("^([\\w\\-_]+)\\.kt$"), TargetBackend.ANY, true);
        }

        @TestMetadata("unusedVariableWithAnonymousFunctionInitialize1.kt")
        public void testUnusedVariableWithAnonymousFunctionInitialize1() throws Exception {
            runTest("idea/testData/quickfix/variables/unusedVariableWithAnonymousFunctionInitialize1.kt");
        }

        @TestMetadata("unusedVariableWithAnonymousFunctionInitialize2.kt")
        public void testUnusedVariableWithAnonymousFunctionInitialize2() throws Exception {
            runTest("idea/testData/quickfix/variables/unusedVariableWithAnonymousFunctionInitialize2.kt");
        }

        @TestMetadata("unusedVariableWithConstantInitializer.kt")
        public void testUnusedVariableWithConstantInitializer() throws Exception {
            runTest("idea/testData/quickfix/variables/unusedVariableWithConstantInitializer.kt");
        }

        @TestMetadata("unusedVariableWithInitializer.kt")
        public void testUnusedVariableWithInitializer() throws Exception {
            runTest("idea/testData/quickfix/variables/unusedVariableWithInitializer.kt");
        }

        @TestMetadata("unusedVariableWithInitializerAndComment.kt")
        public void testUnusedVariableWithInitializerAndComment() throws Exception {
            runTest("idea/testData/quickfix/variables/unusedVariableWithInitializerAndComment.kt");
        }

        @TestMetadata("unusedVariableWithLambdaInitializer1.kt")
        public void testUnusedVariableWithLambdaInitializer1() throws Exception {
            runTest("idea/testData/quickfix/variables/unusedVariableWithLambdaInitializer1.kt");
        }

        @TestMetadata("unusedVariableWithLambdaInitializer2.kt")
        public void testUnusedVariableWithLambdaInitializer2() throws Exception {
            runTest("idea/testData/quickfix/variables/unusedVariableWithLambdaInitializer2.kt");
        }

        @TestMetadata("unusedVariableWithNullInitializer.kt")
        public void testUnusedVariableWithNullInitializer() throws Exception {
            runTest("idea/testData/quickfix/variables/unusedVariableWithNullInitializer.kt");
        }

        @TestMetadata("unusedVariableWithoutInitializer.kt")
        public void testUnusedVariableWithoutInitializer() throws Exception {
            runTest("idea/testData/quickfix/variables/unusedVariableWithoutInitializer.kt");
        }

        @TestMetadata("idea/testData/quickfix/variables/changeMutability")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class ChangeMutability extends AbstractQuickFixTest {
            private void runTest(String testDataFilePath) throws Exception {
                KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
            }

            public void testAllFilesPresentInChangeMutability() throws Exception {
                KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/quickfix/variables/changeMutability"), Pattern.compile("^([\\w\\-_]+)\\.kt$"), TargetBackend.ANY, true);
            }

            @TestMetadata("capturedMemberValInitialization.kt")
            public void testCapturedMemberValInitialization() throws Exception {
                runTest("idea/testData/quickfix/variables/changeMutability/capturedMemberValInitialization.kt");
            }

            @TestMetadata("capturedValInitialization.kt")
            public void testCapturedValInitialization() throws Exception {
                runTest("idea/testData/quickfix/variables/changeMutability/capturedValInitialization.kt");
            }

            @TestMetadata("funParameter.kt")
            public void testFunParameter() throws Exception {
                runTest("idea/testData/quickfix/variables/changeMutability/funParameter.kt");
            }

            @TestMetadata("localInGetter.kt")
            public void testLocalInGetter() throws Exception {
                runTest("idea/testData/quickfix/variables/changeMutability/localInGetter.kt");
            }

            @TestMetadata("valOverrideVar.kt")
            public void testValOverrideVar() throws Exception {
                runTest("idea/testData/quickfix/variables/changeMutability/valOverrideVar.kt");
            }

            @TestMetadata("valOverrideVarConstructorParameter.kt")
            public void testValOverrideVarConstructorParameter() throws Exception {
                runTest("idea/testData/quickfix/variables/changeMutability/valOverrideVarConstructorParameter.kt");
            }

            @TestMetadata("valReassignmentLocal.kt")
            public void testValReassignmentLocal() throws Exception {
                runTest("idea/testData/quickfix/variables/changeMutability/valReassignmentLocal.kt");
            }

            @TestMetadata("valReassignmentOuterDecl.kt")
            public void testValReassignmentOuterDecl() throws Exception {
                runTest("idea/testData/quickfix/variables/changeMutability/valReassignmentOuterDecl.kt");
            }

            @TestMetadata("valReassignmentProperty.kt")
            public void testValReassignmentProperty() throws Exception {
                runTest("idea/testData/quickfix/variables/changeMutability/valReassignmentProperty.kt");
            }

            @TestMetadata("valReassignmentPropertyConstructorParameter.kt")
            public void testValReassignmentPropertyConstructorParameter() throws Exception {
                runTest("idea/testData/quickfix/variables/changeMutability/valReassignmentPropertyConstructorParameter.kt");
            }

            @TestMetadata("valWithSetter.kt")
            public void testValWithSetter() throws Exception {
                runTest("idea/testData/quickfix/variables/changeMutability/valWithSetter.kt");
            }

            @TestMetadata("idea/testData/quickfix/variables/changeMutability/canBeVal")
            @TestDataPath("$PROJECT_ROOT")
            @RunWith(JUnit3RunnerWithInners.class)
            public static class CanBeVal extends AbstractQuickFixTest {
                private void runTest(String testDataFilePath) throws Exception {
                    KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
                }

                public void testAllFilesPresentInCanBeVal() throws Exception {
                    KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/quickfix/variables/changeMutability/canBeVal"), Pattern.compile("^([\\w\\-_]+)\\.kt$"), TargetBackend.ANY, true);
                }

                @TestMetadata("const.kt")
                public void testConst() throws Exception {
                    runTest("idea/testData/quickfix/variables/changeMutability/canBeVal/const.kt");
                }

                @TestMetadata("delegatedProperty.kt")
                public void testDelegatedProperty() throws Exception {
                    runTest("idea/testData/quickfix/variables/changeMutability/canBeVal/delegatedProperty.kt");
                }

                @TestMetadata("delegatedProperty2.kt")
                public void testDelegatedProperty2() throws Exception {
                    runTest("idea/testData/quickfix/variables/changeMutability/canBeVal/delegatedProperty2.kt");
                }

                @TestMetadata("delegatedProperty3.kt")
                public void testDelegatedProperty3() throws Exception {
                    runTest("idea/testData/quickfix/variables/changeMutability/canBeVal/delegatedProperty3.kt");
                }

                @TestMetadata("multiVariable.kt")
                public void testMultiVariable() throws Exception {
                    runTest("idea/testData/quickfix/variables/changeMutability/canBeVal/multiVariable.kt");
                }

                @TestMetadata("singleVariable.kt")
                public void testSingleVariable() throws Exception {
                    runTest("idea/testData/quickfix/variables/changeMutability/canBeVal/singleVariable.kt");
                }
            }
        }

        @TestMetadata("idea/testData/quickfix/variables/changeToFunctionInvocation")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class ChangeToFunctionInvocation extends AbstractQuickFixTest {
            private void runTest(String testDataFilePath) throws Exception {
                KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
            }

            public void testAllFilesPresentInChangeToFunctionInvocation() throws Exception {
                KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/quickfix/variables/changeToFunctionInvocation"), Pattern.compile("^([\\w\\-_]+)\\.kt$"), TargetBackend.ANY, true);
            }

            @TestMetadata("funInvWithoutParentheses.kt")
            public void testFunInvWithoutParentheses() throws Exception {
                runTest("idea/testData/quickfix/variables/changeToFunctionInvocation/funInvWithoutParentheses.kt");
            }

            @TestMetadata("inStringTemplate.kt")
            public void testInStringTemplate() throws Exception {
                runTest("idea/testData/quickfix/variables/changeToFunctionInvocation/inStringTemplate.kt");
            }

            @TestMetadata("inStringTemplate2.kt")
            public void testInStringTemplate2() throws Exception {
                runTest("idea/testData/quickfix/variables/changeToFunctionInvocation/inStringTemplate2.kt");
            }

            @TestMetadata("inStringTemplate3.kt")
            public void testInStringTemplate3() throws Exception {
                runTest("idea/testData/quickfix/variables/changeToFunctionInvocation/inStringTemplate3.kt");
            }

            @TestMetadata("inStringTemplate4.kt")
            public void testInStringTemplate4() throws Exception {
                runTest("idea/testData/quickfix/variables/changeToFunctionInvocation/inStringTemplate4.kt");
            }

            @TestMetadata("inStringTemplate5.kt")
            public void testInStringTemplate5() throws Exception {
                runTest("idea/testData/quickfix/variables/changeToFunctionInvocation/inStringTemplate5.kt");
            }
        }

        @TestMetadata("idea/testData/quickfix/variables/changeToPropertyAccess")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class ChangeToPropertyAccess extends AbstractQuickFixTest {
            private void runTest(String testDataFilePath) throws Exception {
                KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
            }

            public void testAllFilesPresentInChangeToPropertyAccess() throws Exception {
                KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/quickfix/variables/changeToPropertyAccess"), Pattern.compile("^([\\w\\-_]+)\\.kt$"), TargetBackend.ANY, true);
            }

            @TestMetadata("enumEntryCall.kt")
            public void testEnumEntryCall() throws Exception {
                runTest("idea/testData/quickfix/variables/changeToPropertyAccess/enumEntryCall.kt");
            }

            @TestMetadata("nonSimpleName.kt")
            public void testNonSimpleName() throws Exception {
                runTest("idea/testData/quickfix/variables/changeToPropertyAccess/nonSimpleName.kt");
            }

            @TestMetadata("objectCall.kt")
            public void testObjectCall() throws Exception {
                runTest("idea/testData/quickfix/variables/changeToPropertyAccess/objectCall.kt");
            }

            @TestMetadata("propertyCall.kt")
            public void testPropertyCall() throws Exception {
                runTest("idea/testData/quickfix/variables/changeToPropertyAccess/propertyCall.kt");
            }

            @TestMetadata("propertyCallWithArguments.kt")
            public void testPropertyCallWithArguments() throws Exception {
                runTest("idea/testData/quickfix/variables/changeToPropertyAccess/propertyCallWithArguments.kt");
            }
        }

        @TestMetadata("idea/testData/quickfix/variables/removeValVarFromParameter")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class RemoveValVarFromParameter extends AbstractQuickFixTest {
            private void runTest(String testDataFilePath) throws Exception {
                KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
            }

            public void testAllFilesPresentInRemoveValVarFromParameter() throws Exception {
                KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/quickfix/variables/removeValVarFromParameter"), Pattern.compile("^([\\w\\-_]+)\\.kt$"), TargetBackend.ANY, true);
            }

            @TestMetadata("catchParameter.kt")
            public void testCatchParameter() throws Exception {
                runTest("idea/testData/quickfix/variables/removeValVarFromParameter/catchParameter.kt");
            }

            @TestMetadata("constructorParameter.kt")
            public void testConstructorParameter() throws Exception {
                runTest("idea/testData/quickfix/variables/removeValVarFromParameter/constructorParameter.kt");
            }

            @TestMetadata("funParameter.kt")
            public void testFunParameter() throws Exception {
                runTest("idea/testData/quickfix/variables/removeValVarFromParameter/funParameter.kt");
            }

            @TestMetadata("loopMultiParameter.kt")
            public void testLoopMultiParameter() throws Exception {
                runTest("idea/testData/quickfix/variables/removeValVarFromParameter/loopMultiParameter.kt");
            }

            @TestMetadata("loopParameter.kt")
            public void testLoopParameter() throws Exception {
                runTest("idea/testData/quickfix/variables/removeValVarFromParameter/loopParameter.kt");
            }

            @TestMetadata("parameterWithComment.kt")
            public void testParameterWithComment() throws Exception {
                runTest("idea/testData/quickfix/variables/removeValVarFromParameter/parameterWithComment.kt");
            }

            @TestMetadata("secondaryConstructorParameter.kt")
            public void testSecondaryConstructorParameter() throws Exception {
                runTest("idea/testData/quickfix/variables/removeValVarFromParameter/secondaryConstructorParameter.kt");
            }
        }
    }

    @TestMetadata("idea/testData/quickfix/when")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class When extends AbstractQuickFixTest {
        private void runTest(String testDataFilePath) throws Exception {
            KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
        }

        @TestMetadata("addElseBranchEnumStatement.kt")
        public void testAddElseBranchEnumStatement() throws Exception {
            runTest("idea/testData/quickfix/when/addElseBranchEnumStatement.kt");
        }

        @TestMetadata("addRemainingBranchesBlankLine.kt")
        public void testAddRemainingBranchesBlankLine() throws Exception {
            runTest("idea/testData/quickfix/when/addRemainingBranchesBlankLine.kt");
        }

        @TestMetadata("addRemainingBranchesBlankLineWithComment.kt")
        public void testAddRemainingBranchesBlankLineWithComment() throws Exception {
            runTest("idea/testData/quickfix/when/addRemainingBranchesBlankLineWithComment.kt");
        }

        @TestMetadata("addRemainingBranchesBoolean.kt")
        public void testAddRemainingBranchesBoolean() throws Exception {
            runTest("idea/testData/quickfix/when/addRemainingBranchesBoolean.kt");
        }

        @TestMetadata("addRemainingBranchesEnum.kt")
        public void testAddRemainingBranchesEnum() throws Exception {
            runTest("idea/testData/quickfix/when/addRemainingBranchesEnum.kt");
        }

        @TestMetadata("addRemainingBranchesEnumBackTicks.kt")
        public void testAddRemainingBranchesEnumBackTicks() throws Exception {
            runTest("idea/testData/quickfix/when/addRemainingBranchesEnumBackTicks.kt");
        }

        @TestMetadata("addRemainingBranchesEnumImport1.kt")
        public void testAddRemainingBranchesEnumImport1() throws Exception {
            runTest("idea/testData/quickfix/when/addRemainingBranchesEnumImport1.kt");
        }

        @TestMetadata("addRemainingBranchesEnumImport2.kt")
        public void testAddRemainingBranchesEnumImport2() throws Exception {
            runTest("idea/testData/quickfix/when/addRemainingBranchesEnumImport2.kt");
        }

        @TestMetadata("addRemainingBranchesEnumImport3.kt")
        public void testAddRemainingBranchesEnumImport3() throws Exception {
            runTest("idea/testData/quickfix/when/addRemainingBranchesEnumImport3.kt");
        }

        @TestMetadata("addRemainingBranchesEnumImport4.kt")
        public void testAddRemainingBranchesEnumImport4() throws Exception {
            runTest("idea/testData/quickfix/when/addRemainingBranchesEnumImport4.kt");
        }

        @TestMetadata("addRemainingBranchesEnumStatement.kt")
        public void testAddRemainingBranchesEnumStatement() throws Exception {
            runTest("idea/testData/quickfix/when/addRemainingBranchesEnumStatement.kt");
        }

        @TestMetadata("addRemainingBranchesInNonDefaultPackage.kt")
        public void testAddRemainingBranchesInNonDefaultPackage() throws Exception {
            runTest("idea/testData/quickfix/when/addRemainingBranchesInNonDefaultPackage.kt");
        }

        @TestMetadata("addRemainingBranchesSealed.kt")
        public void testAddRemainingBranchesSealed() throws Exception {
            runTest("idea/testData/quickfix/when/addRemainingBranchesSealed.kt");
        }

        @TestMetadata("addRemainingBranchesSealedBackTicks.kt")
        public void testAddRemainingBranchesSealedBackTicks() throws Exception {
            runTest("idea/testData/quickfix/when/addRemainingBranchesSealedBackTicks.kt");
        }

        @TestMetadata("addRemainingBranchesSealedStatement.kt")
        public void testAddRemainingBranchesSealedStatement() throws Exception {
            runTest("idea/testData/quickfix/when/addRemainingBranchesSealedStatement.kt");
        }

        public void testAllFilesPresentInWhen() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/quickfix/when"), Pattern.compile("^([\\w\\-_]+)\\.kt$"), TargetBackend.ANY, true);
        }

        @TestMetadata("breakInWhen.kt")
        public void testBreakInWhen() throws Exception {
            runTest("idea/testData/quickfix/when/breakInWhen.kt");
        }

        @TestMetadata("breakInWhenInLabeled.kt")
        public void testBreakInWhenInLabeled() throws Exception {
            runTest("idea/testData/quickfix/when/breakInWhenInLabeled.kt");
        }

        @TestMetadata("commasInConditionWithNoArguments.kt")
        public void testCommasInConditionWithNoArguments() throws Exception {
            runTest("idea/testData/quickfix/when/commasInConditionWithNoArguments.kt");
        }

        @TestMetadata("commasInConditionWithNoArguments2.kt")
        public void testCommasInConditionWithNoArguments2() throws Exception {
            runTest("idea/testData/quickfix/when/commasInConditionWithNoArguments2.kt");
        }

        @TestMetadata("continueInWhen.kt")
        public void testContinueInWhen() throws Exception {
            runTest("idea/testData/quickfix/when/continueInWhen.kt");
        }

        @TestMetadata("continueInWhenInLabeled.kt")
        public void testContinueInWhenInLabeled() throws Exception {
            runTest("idea/testData/quickfix/when/continueInWhenInLabeled.kt");
        }

        @TestMetadata("continueInWhenWithLabel.kt")
        public void testContinueInWhenWithLabel() throws Exception {
            runTest("idea/testData/quickfix/when/continueInWhenWithLabel.kt");
        }

        @TestMetadata("elseNotLastInWhen.kt")
        public void testElseNotLastInWhen() throws Exception {
            runTest("idea/testData/quickfix/when/elseNotLastInWhen.kt");
        }

        @TestMetadata("noElseInWhenWithBranches.kt")
        public void testNoElseInWhenWithBranches() throws Exception {
            runTest("idea/testData/quickfix/when/noElseInWhenWithBranches.kt");
        }

        @TestMetadata("noElseInWhenWithoutBranches.kt")
        public void testNoElseInWhenWithoutBranches() throws Exception {
            runTest("idea/testData/quickfix/when/noElseInWhenWithoutBranches.kt");
        }

        @TestMetadata("removeRedundantElse.kt")
        public void testRemoveRedundantElse() throws Exception {
            runTest("idea/testData/quickfix/when/removeRedundantElse.kt");
        }

        @TestMetadata("twoElseBranchesInWhen.kt")
        public void testTwoElseBranchesInWhen() throws Exception {
            runTest("idea/testData/quickfix/when/twoElseBranchesInWhen.kt");
        }
    }

    @TestMetadata("idea/testData/quickfix/wrapWithSafeLetCall")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class WrapWithSafeLetCall extends AbstractQuickFixTest {
        private void runTest(String testDataFilePath) throws Exception {
            KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
        }

        public void testAllFilesPresentInWrapWithSafeLetCall() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/quickfix/wrapWithSafeLetCall"), Pattern.compile("^([\\w\\-_]+)\\.kt$"), TargetBackend.ANY, true);
        }

        @TestMetadata("argumentNullable.kt")
        public void testArgumentNullable() throws Exception {
            runTest("idea/testData/quickfix/wrapWithSafeLetCall/argumentNullable.kt");
        }

        @TestMetadata("chainedCallTypeMismatch.kt")
        public void testChainedCallTypeMismatch() throws Exception {
            runTest("idea/testData/quickfix/wrapWithSafeLetCall/chainedCallTypeMismatch.kt");
        }

        @TestMetadata("chainedUnsafeCall.kt")
        public void testChainedUnsafeCall() throws Exception {
            runTest("idea/testData/quickfix/wrapWithSafeLetCall/chainedUnsafeCall.kt");
        }

        @TestMetadata("expressionUnsafeCall.kt")
        public void testExpressionUnsafeCall() throws Exception {
            runTest("idea/testData/quickfix/wrapWithSafeLetCall/expressionUnsafeCall.kt");
        }

        @TestMetadata("extensionMethod.kt")
        public void testExtensionMethod() throws Exception {
            runTest("idea/testData/quickfix/wrapWithSafeLetCall/extensionMethod.kt");
        }

        @TestMetadata("extentionFunctionCall.kt")
        public void testExtentionFunctionCall() throws Exception {
            runTest("idea/testData/quickfix/wrapWithSafeLetCall/extentionFunctionCall.kt");
        }

        @TestMetadata("extentionFunctionCall2.kt")
        public void testExtentionFunctionCall2() throws Exception {
            runTest("idea/testData/quickfix/wrapWithSafeLetCall/extentionFunctionCall2.kt");
        }

        @TestMetadata("insideLet.kt")
        public void testInsideLet() throws Exception {
            runTest("idea/testData/quickfix/wrapWithSafeLetCall/insideLet.kt");
        }

        @TestMetadata("invokeFuncUnsafe.kt")
        public void testInvokeFuncUnsafe() throws Exception {
            runTest("idea/testData/quickfix/wrapWithSafeLetCall/invokeFuncUnsafe.kt");
        }

        @TestMetadata("invokeUnsafe.kt")
        public void testInvokeUnsafe() throws Exception {
            runTest("idea/testData/quickfix/wrapWithSafeLetCall/invokeUnsafe.kt");
        }

        @TestMetadata("objectQualifier.kt")
        public void testObjectQualifier() throws Exception {
            runTest("idea/testData/quickfix/wrapWithSafeLetCall/objectQualifier.kt");
        }

        @TestMetadata("unstableValue.kt")
        public void testUnstableValue() throws Exception {
            runTest("idea/testData/quickfix/wrapWithSafeLetCall/unstableValue.kt");
        }
    }

    @TestMetadata("idea/testData/quickfix/wrongLongSuffix")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class WrongLongSuffix extends AbstractQuickFixTest {
        private void runTest(String testDataFilePath) throws Exception {
            KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
        }

        public void testAllFilesPresentInWrongLongSuffix() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/quickfix/wrongLongSuffix"), Pattern.compile("^([\\w\\-_]+)\\.kt$"), TargetBackend.ANY, true);
        }

        @TestMetadata("simple.kt")
        public void testSimple() throws Exception {
            runTest("idea/testData/quickfix/wrongLongSuffix/simple.kt");
        }
    }

    @TestMetadata("idea/testData/quickfix/yieldUnsupported")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class YieldUnsupported extends AbstractQuickFixTest {
        private void runTest(String testDataFilePath) throws Exception {
            KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
        }

        public void testAllFilesPresentInYieldUnsupported() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/quickfix/yieldUnsupported"), Pattern.compile("^([\\w\\-_]+)\\.kt$"), TargetBackend.ANY, true);
        }

        @TestMetadata("yieldAsSimpleName.kt")
        public void testYieldAsSimpleName() throws Exception {
            runTest("idea/testData/quickfix/yieldUnsupported/yieldAsSimpleName.kt");
        }

        @TestMetadata("yieldBeforeLambda.kt")
        public void testYieldBeforeLambda() throws Exception {
            runTest("idea/testData/quickfix/yieldUnsupported/yieldBeforeLambda.kt");
        }
    }
}
