/***************************************************************************
*   Copyright (C) 2007-2010 by Thomas Thelliez aka jblud                  *
*   Contact : <admin.kontrol@gmail.com>                                   *
*                                                                         *
*   This program is free software; you can redistribute it and/or modify  *
*   it under the terms of the GNU General Public License as               *
*   published by the Free Software Foundation; either version 2.0 of      *
*   the License, or (at your option) any later version.                   *
*                                                                         *
*   This program is distributed in the hope that it will be useful,       *
*   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
*   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU     *
*   General Public License for more details.                              *
*                                                                         *
*   You should have received a copy of the GNU General Public             *
*   License along with this program; if not, write to                     *
*   the Free Software Foundation, Inc.,                                   *
*   51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA          *
***************************************************************************/

#include "tab_dialog.h"

TabDialog::TabDialog(QList<RemoteComputerInfo*> clientsList)
    : remote_info_list(clientsList)
{
#ifdef WIN32
    QFont font("Arial", 8, true);
#elif defined __APPLE__
    QFont font = QFont();
#else
    QFont font("Arial", 10, true);
#endif
    QLabel *label = new QLabel(tr("<strong>Connect to remote computer securely<br /></strong>"), this);
    QLabel *labelIp = new QLabel(tr("Server IP address :"), this);
    QLabel *labelPort = new QLabel(tr("Server port :"), this);
    QLabel *labelPortFile = new QLabel(tr("Server port File :"), this);
    QLabel *labelPassword = new QLabel(tr("Server master password :"), this);
    label->setFont(font);
    labelIp->setFont(font);
    labelPassword->setFont(font);
    labelPort->setFont(font);
    labelPortFile->setFont(font);

    QStandardItemModel *model = new QStandardItemModel(this);
    for (int l = 0; l < remote_info_list.size(); l++) {
        RemoteComputerInfo* remoteComputerInfo = remote_info_list.at(l);
        QStandardItem *item;
        if (remoteComputerInfo->system.startsWith(QString(LINUX), Qt::CaseSensitive)) {
             item = new QStandardItem(QIcon(":/images/linux.png"),remoteComputerInfo->ip);
        } else if (remoteComputerInfo->system.startsWith(WINDOWS, Qt::CaseSensitive)) {
            item = new QStandardItem(QIcon(":/images/windows.png"),remoteComputerInfo->ip);
        }else if (remoteComputerInfo->system.startsWith(MACOSX, Qt::CaseSensitive)) {
            item = new QStandardItem(QIcon(":/images/finder.png"),remoteComputerInfo->ip);
        }
        model->appendRow(item);
    }
    QCompleter *completer = new QCompleter(this);
    completer->setCompletionMode(QCompleter::UnfilteredPopupCompletion);
    completer->setModel(model);

    password = new QLineEdit(this);
    ipAddress =  new QLineEdit(this);
    ipAddress->setCompleter(completer);
    port = new QLineEdit(this);
    portFile = new QLineEdit(this);
    ipAddress->setFont(font);
    port->setFont(font);
    portFile->setFont(font);
    portFile->setValidator(new QIntValidator(1, 65535, this));
    port->setValidator(new QIntValidator(1, 65535, this));
    password->setFont(font);
    password->setEchoMode(QLineEdit::Password);

    QPushButton *button = new QPushButton(tr("Connect to remote server"));
    button->setMinimumHeight(70);
    button->setFont(font);
    QFrame *upFrame = new QFrame( this );
    upFrame->setFrameStyle( QFrame::HLine | QFrame::Sunken );
    QFrame *downFrame = new QFrame( this );
    downFrame->setFrameStyle( QFrame::HLine | QFrame::Sunken );
    port->setText("17984");
    portFile->setText("17985");
    QGridLayout *layout = new QGridLayout;
    layout->addWidget(label, 0, 0, 1, 2);
    layout->addWidget(upFrame, 1, 0, 1, 2);
    layout->addWidget(labelPassword, 2, 0);
    layout->addWidget(password, 2, 1);
    layout->addWidget(labelIp, 3, 0);
    layout->addWidget(ipAddress, 3, 1);
    setWindowTitle(tr("Connect to remote computer"));
    setWindowIcon(QIcon(":/images/kontrolpack.png"));
    layout->addWidget(labelPort, 4, 0);
    layout->addWidget(port, 4, 1);
    layout->addWidget(labelPortFile, 5, 0);
    layout->addWidget(portFile, 5, 1);
    layout->addWidget(downFrame, 6, 0, 1, 2);
    layout->addWidget(button, 7, 0, 6, 2);
    setLayout(layout);
    connect(button, SIGNAL(clicked()), this, SLOT(hideDialogBox()));
}

void TabDialog::hideDialogBox()
{
    if (ipAddress->text() != "") {
        if (port->text() != "") {
            if (portFile->text() != "") {
                if (password->text() != "") {
                    if (password->text().size() < 30) {
                        this->hide();
                        emit add_tab_signal(ipAddress->text(), port->text(), portFile->text(), password->text());
                    } else {
                        QMessageBox::information(this, tr("Warning"), tr("Password length must be smaller than 30 digits."));
                    }
                } else {
                    QMessageBox::information(this, tr("Warning"), tr("Input a password in the field above to connect."));
                }
            } else {
                QMessageBox::information(this, tr("Warning"), tr("Input a port number in the field above to connect."));
            }
        } else {
            QMessageBox::information(this, tr("Warning"), tr("Input a port number in the field above to connect."));
        }
    } else {
        QMessageBox::information(this, tr("Warning"), tr("Input an IP address in the field above to connect."));
    }
}

void TabDialog::centerOnScreen()
{
    QDesktopWidget screen;
    QRect screenGeom = screen.screenGeometry(this);
    int screenCenterX = screenGeom.center().x();
    int screenCenterY = screenGeom.center().y();
    move(screenCenterX - width () / 2,
         screenCenterY - height() / 2);
}

void TabDialog::closeEvent(QCloseEvent *event)
{
    hide();
    event->ignore();
}
