/* SPDX-FileCopyrightText: 2010-2022 Sébastien Wilmet
 * SPDX-License-Identifier: GPL-3.0-or-later
 */

using Gtk;

namespace PreferencesDialog
{
    public void fill (Tepl.PrefsDialog prefs_dialog)
    {
        // reset all button
        Button reset_button = new Button.with_mnemonic (_("_Reset All"));
        reset_button.set_tooltip_text (_("Reset all preferences"));
        reset_button.show_all ();
        reset_button.clicked.connect (reset_all);
        HeaderBar headerbar = prefs_dialog.get_header_bar () as HeaderBar;
        headerbar.pack_start (reset_button);

        // content
        Gtk.Box content_area = prefs_dialog.get_content_area () as Gtk.Box;
        content_area.pack_start (Gtex.prefs_create_notebook ());
    }

    private void reset_all ()
    {
        Tepl.PrefsDialog prefs_dialog = Tepl.PrefsDialog.get_singleton ();

        Dialog dialog = new MessageDialog (prefs_dialog, DialogFlags.DESTROY_WITH_PARENT,
            MessageType.QUESTION, ButtonsType.NONE,
            "%s", _("Do you really want to reset all preferences?"));

        dialog.add_button (_("_Cancel"), ResponseType.CANCEL);
        dialog.add_button (_("_Reset All"), ResponseType.YES);

        int resp = dialog.run ();
        dialog.destroy ();
        if (resp != ResponseType.YES)
            return;

        string[] settings_str =
        {
            "org.gnome.enter_tex.preferences.editor",
            "org.gnome.enter_tex.preferences.latex"
        };

        foreach (string setting_str in settings_str)
        {
            GLib.Settings settings = new GLib.Settings (setting_str);
            string[] keys = settings.list_keys ();
            foreach (string key in keys)
                settings.reset (key);
        }
    }
}
