/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.webservices.dns.client.util;

import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Path {
    private final String path;
    private final Map<String, String> queryArgs;

    public Path(String path) {
        this(path, new HashMap<String, String>());
    }

    public Path(String value, Map<String, String> queryArgs) {
        this.path = value;
        this.queryArgs = queryArgs;
    }

    public String getValue() {
        return this.path + this.getQueryString();
    }

    private String getQueryString() {
        StringBuilder queryString = new StringBuilder();
        for (Map.Entry<String, String> entry : this.queryArgs.entrySet()) {
            queryString.append("&").append(entry.getKey()).append("=").append(entry.getValue());
        }
        return this.queryArgs.size() == 0 ? "" : "?" + queryString.substring(1);
    }

    public final boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Path rhs = (Path)obj;
        return new EqualsBuilder().append((Object)this.getValue(), (Object)rhs.getValue()).isEquals();
    }

    public final int hashCode() {
        return new HashCodeBuilder(39, 49).append((Object)this.getValue()).toHashCode();
    }

    public final String toString() {
        return this.getValue();
    }
}

