// A Bison parser, made by GNU Bison 3.3.2.

// Skeleton interface for Bison LALR(1) parsers in C++

// Copyright (C) 2002-2015, 2018-2019 Free Software Foundation, Inc.

// This program is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.

// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.

// You should have received a copy of the GNU General Public License
// along with this program.  If not, see <http://www.gnu.org/licenses/>.

// As a special exception, you may create a larger work that contains
// part or all of the Bison parser skeleton and distribute that work
// under terms of your choice, so long as that work isn't itself a
// parser generator using the skeleton or a modified version thereof
// as a parser skeleton.  Alternatively, if you modify or redistribute
// the parser skeleton itself, you may (at your option) remove this
// special exception, which will cause the skeleton and the resulting
// Bison output files to be licensed under the GNU General Public
// License without this special exception.

// This special exception was added by the Free Software Foundation in
// version 2.2 of Bison.


/**
 ** \file DynareBison.hh
 ** Define the Dynare::parser class.
 */

// C++ LALR(1) parser skeleton written by Akim Demaille.

// Undocumented macros, especially those whose name start with YY_,
// are private implementation details.  Do not rely on them.

#ifndef YY_YY_DYNAREBISON_HH_INCLUDED
# define YY_YY_DYNAREBISON_HH_INCLUDED
// //                    "%code requires" blocks.
#line 34 "DynareBison.yy" // lalr1.cc:401

#include "ExprNode.hh"
#include "CodeInterpreter.hh"

#line 53 "DynareBison.hh" // lalr1.cc:401

# include <cassert>
# include <cstdlib> // std::abort
# include <iostream>
# include <stdexcept>
# include <string>
# include <vector>

#if defined __cplusplus
# define YY_CPLUSPLUS __cplusplus
#else
# define YY_CPLUSPLUS 199711L
#endif

// Support move semantics when possible.
#if 201103L <= YY_CPLUSPLUS
# define YY_MOVE           std::move
# define YY_MOVE_OR_COPY   move
# define YY_MOVE_REF(Type) Type&&
# define YY_RVREF(Type)    Type&&
# define YY_COPY(Type)     Type
#else
# define YY_MOVE
# define YY_MOVE_OR_COPY   copy
# define YY_MOVE_REF(Type) Type&
# define YY_RVREF(Type)    const Type&
# define YY_COPY(Type)     const Type&
#endif

// Support noexcept when possible.
#if 201103L <= YY_CPLUSPLUS
# define YY_NOEXCEPT noexcept
# define YY_NOTHROW
#else
# define YY_NOEXCEPT
# define YY_NOTHROW throw ()
#endif

// Support constexpr when possible.
#if 201703 <= YY_CPLUSPLUS
# define YY_CONSTEXPR constexpr
#else
# define YY_CONSTEXPR
#endif
# include "location.hh"
#include <typeinfo>
#ifndef YYASSERT
# include <cassert>
# define YYASSERT assert
#endif


#ifndef YY_ATTRIBUTE
# if (defined __GNUC__                                               \
      && (2 < __GNUC__ || (__GNUC__ == 2 && 96 <= __GNUC_MINOR__)))  \
     || defined __SUNPRO_C && 0x5110 <= __SUNPRO_C
#  define YY_ATTRIBUTE(Spec) __attribute__(Spec)
# else
#  define YY_ATTRIBUTE(Spec) /* empty */
# endif
#endif

#ifndef YY_ATTRIBUTE_PURE
# define YY_ATTRIBUTE_PURE   YY_ATTRIBUTE ((__pure__))
#endif

#ifndef YY_ATTRIBUTE_UNUSED
# define YY_ATTRIBUTE_UNUSED YY_ATTRIBUTE ((__unused__))
#endif

/* Suppress unused-variable warnings by "using" E.  */
#if ! defined lint || defined __GNUC__
# define YYUSE(E) ((void) (E))
#else
# define YYUSE(E) /* empty */
#endif

#if defined __GNUC__ && ! defined __ICC && 407 <= __GNUC__ * 100 + __GNUC_MINOR__
/* Suppress an incorrect diagnostic about yylval being uninitialized.  */
# define YY_IGNORE_MAYBE_UNINITIALIZED_BEGIN \
    _Pragma ("GCC diagnostic push") \
    _Pragma ("GCC diagnostic ignored \"-Wuninitialized\"")\
    _Pragma ("GCC diagnostic ignored \"-Wmaybe-uninitialized\"")
# define YY_IGNORE_MAYBE_UNINITIALIZED_END \
    _Pragma ("GCC diagnostic pop")
#else
# define YY_INITIAL_VALUE(Value) Value
#endif
#ifndef YY_IGNORE_MAYBE_UNINITIALIZED_BEGIN
# define YY_IGNORE_MAYBE_UNINITIALIZED_BEGIN
# define YY_IGNORE_MAYBE_UNINITIALIZED_END
#endif
#ifndef YY_INITIAL_VALUE
# define YY_INITIAL_VALUE(Value) /* Nothing. */
#endif

# ifndef YY_NULLPTR
#  if defined __cplusplus
#   if 201103L <= __cplusplus
#    define YY_NULLPTR nullptr
#   else
#    define YY_NULLPTR 0
#   endif
#  else
#   define YY_NULLPTR ((void*)0)
#  endif
# endif

/* Debug traces.  */
#ifndef YYDEBUG
# define YYDEBUG 1
#endif

#line 25 "DynareBison.yy" // lalr1.cc:401
namespace Dynare {
#line 169 "DynareBison.hh" // lalr1.cc:401



  /// A Bison parser.
  class parser
  {
  public:
#ifndef YYSTYPE
  /// A buffer to store and retrieve objects.
  ///
  /// Sort of a variant, but does not keep track of the nature
  /// of the stored data, since that knowledge is available
  /// via the current parser state.
  class semantic_type
  {
  public:
    /// Type of *this.
    typedef semantic_type self_type;

    /// Empty construction.
    semantic_type () YY_NOEXCEPT
      : yybuffer_ ()
      , yytypeid_ (YY_NULLPTR)
    {}

    /// Construct and fill.
    template <typename T>
    semantic_type (YY_RVREF (T) t)
      : yytypeid_ (&typeid (T))
    {
      YYASSERT (sizeof (T) <= size);
      new (yyas_<T> ()) T (YY_MOVE (t));
    }

    /// Destruction, allowed only if empty.
    ~semantic_type () YY_NOEXCEPT
    {
      YYASSERT (!yytypeid_);
    }

# if 201103L <= YY_CPLUSPLUS
    /// Instantiate a \a T in here from \a t.
    template <typename T, typename... U>
    T&
    emplace (U&&... u)
    {
      YYASSERT (!yytypeid_);
      YYASSERT (sizeof (T) <= size);
      yytypeid_ = & typeid (T);
      return *new (yyas_<T> ()) T (std::forward <U>(u)...);
    }
# else
    /// Instantiate an empty \a T in here.
    template <typename T>
    T&
    emplace ()
    {
      YYASSERT (!yytypeid_);
      YYASSERT (sizeof (T) <= size);
      yytypeid_ = & typeid (T);
      return *new (yyas_<T> ()) T ();
    }

    /// Instantiate a \a T in here from \a t.
    template <typename T>
    T&
    emplace (const T& t)
    {
      YYASSERT (!yytypeid_);
      YYASSERT (sizeof (T) <= size);
      yytypeid_ = & typeid (T);
      return *new (yyas_<T> ()) T (t);
    }
# endif

    /// Instantiate an empty \a T in here.
    /// Obsolete, use emplace.
    template <typename T>
    T&
    build ()
    {
      return emplace<T> ();
    }

    /// Instantiate a \a T in here from \a t.
    /// Obsolete, use emplace.
    template <typename T>
    T&
    build (const T& t)
    {
      return emplace<T> (t);
    }

    /// Accessor to a built \a T.
    template <typename T>
    T&
    as () YY_NOEXCEPT
    {
      YYASSERT (yytypeid_);
      YYASSERT (*yytypeid_ == typeid (T));
      YYASSERT (sizeof (T) <= size);
      return *yyas_<T> ();
    }

    /// Const accessor to a built \a T (for %printer).
    template <typename T>
    const T&
    as () const YY_NOEXCEPT
    {
      YYASSERT (yytypeid_);
      YYASSERT (*yytypeid_ == typeid (T));
      YYASSERT (sizeof (T) <= size);
      return *yyas_<T> ();
    }

    /// Swap the content with \a that, of same type.
    ///
    /// Both variants must be built beforehand, because swapping the actual
    /// data requires reading it (with as()), and this is not possible on
    /// unconstructed variants: it would require some dynamic testing, which
    /// should not be the variant's responsibility.
    /// Swapping between built and (possibly) non-built is done with
    /// self_type::move ().
    template <typename T>
    void
    swap (self_type& that) YY_NOEXCEPT
    {
      YYASSERT (yytypeid_);
      YYASSERT (*yytypeid_ == *that.yytypeid_);
      std::swap (as<T> (), that.as<T> ());
    }

    /// Move the content of \a that to this.
    ///
    /// Destroys \a that.
    template <typename T>
    void
    move (self_type& that)
    {
# if 201103L <= YY_CPLUSPLUS
      emplace<T> (std::move (that.as<T> ()));
# else
      emplace<T> ();
      swap<T> (that);
# endif
      that.destroy<T> ();
    }

# if 201103L <= YY_CPLUSPLUS
    /// Move the content of \a that to this.
    template <typename T>
    void
    move (self_type&& that)
    {
      emplace<T> (std::move (that.as<T> ()));
      that.destroy<T> ();
    }
#endif

    /// Copy the content of \a that to this.
    template <typename T>
    void
    copy (const self_type& that)
    {
      emplace<T> (that.as<T> ());
    }

    /// Destroy the stored \a T.
    template <typename T>
    void
    destroy ()
    {
      as<T> ().~T ();
      yytypeid_ = YY_NULLPTR;
    }

  private:
    /// Prohibit blind copies.
    self_type& operator= (const self_type&);
    semantic_type (const self_type&);

    /// Accessor to raw memory as \a T.
    template <typename T>
    T*
    yyas_ () YY_NOEXCEPT
    {
      void *yyp = yybuffer_.yyraw;
      return static_cast<T*> (yyp);
     }

    /// Const accessor to raw memory as \a T.
    template <typename T>
    const T*
    yyas_ () const YY_NOEXCEPT
    {
      const void *yyp = yybuffer_.yyraw;
      return static_cast<const T*> (yyp);
     }

    /// An auxiliary type to compute the largest semantic type.
    union union_type
    {
      // prior_distribution
      // prior_pdf
      char dummy1[sizeof (PriorDistributions)];

      // change_type_arg
      char dummy2[sizeof (SymbolType)];

      // expression
      // expression_or_empty
      // equation
      // hand_side
      char dummy3[sizeof (expr_t)];

      // calibration_range
      char dummy4[sizeof (pair<expr_t,expr_t>)];

      // named_var_elem
      // subsamples_eq_opt
      // integer_range_w_inf
      char dummy5[sizeof (pair<string,string>)];

      // FLOAT_NUMBER
      // DATES
      // INT_NUMBER
      // NAME
      // QUOTED_STRING
      // TEX_NAME
      // ALPHA
      // BETA
      // ABAND
      // NINV
      // CMS
      // NCMS
      // CNUM
      // GAMMA
      // INV_GAMMA
      // INV_GAMMA1
      // INV_GAMMA2
      // NORMAL
      // UNIFORM
      // EPS
      // PDF
      // FIG
      // DR
      // NONE
      // PRIOR
      // PRIOR_VARIANCE
      // HESSIAN
      // IDENTITY_MATRIX
      // DIRICHLET
      // DIAGONAL
      // OPTIMAL
      // signed_integer
      // non_negative_number
      // signed_number
      // signed_inf
      // signed_number_w_inf
      // date_str
      // date_expr
      // list_sub_sampling_option
      // sub_sampling_options
      // filename
      // namespace_qualified_symbol
      // namespace_qualified_filename
      // range
      // integer_range
      // signed_integer_range
      // vec_value_1
      // vec_value
      // vec_value_list
      // vec_of_vec_value
      // vec_value_1_w_inf
      // vec_value_w_inf
      // symbol
      // number
      char dummy6[sizeof (string)];

      // prior_eq_opt
      // options_eq_opt
      char dummy7[sizeof (tuple<string,string,string,string>)];

      // vec_int_number
      // vec_int_elem
      // vec_int_1
      // vec_int
      char dummy8[sizeof (vector<int>)];

      // named_var_1
      // named_var
      char dummy9[sizeof (vector<pair<string,string>>)];

      // SYMBOL_VEC
      // change_type_var_list
      // vec_str_1
      // vec_str
      char dummy10[sizeof (vector<string>)];
    };

    /// The size of the largest semantic type.
    enum { size = sizeof (union_type) };

    /// A buffer to store semantic values.
    union
    {
      /// Strongest alignment constraints.
      long double yyalign_me;
      /// A buffer large enough to store any of the semantic values.
      char yyraw[size];
    } yybuffer_;

    /// Whether the content is built: if defined, the name of the stored type.
    const std::type_info *yytypeid_;
  };

#else
    typedef YYSTYPE semantic_type;
#endif
    /// Symbol locations.
    typedef location location_type;

    /// Syntax errors thrown from user actions.
    struct syntax_error : std::runtime_error
    {
      syntax_error (const location_type& l, const std::string& m)
        : std::runtime_error (m)
        , location (l)
      {}

      syntax_error (const syntax_error& s)
        : std::runtime_error (s.what ())
        , location (s.location)
      {}

      ~syntax_error () YY_NOEXCEPT YY_NOTHROW;

      location_type location;
    };

    /// Tokens.
    struct token
    {
      enum yytokentype
      {
        AIM_SOLVER = 258,
        ANALYTIC_DERIVATION = 259,
        ANALYTIC_DERIVATION_MODE = 260,
        AR = 261,
        POSTERIOR_SAMPLING_METHOD = 262,
        BALANCED_GROWTH_TEST_TOL = 263,
        BAYESIAN_IRF = 264,
        BETA_PDF = 265,
        BLOCK = 266,
        USE_CALIBRATION = 267,
        SILENT_OPTIMIZER = 268,
        BVAR_DENSITY = 269,
        BVAR_FORECAST = 270,
        NODECOMPOSITION = 271,
        DR_DISPLAY_TOL = 272,
        HUGE_NUMBER = 273,
        FIG_NAME = 274,
        WRITE_XLS = 275,
        BVAR_PRIOR_DECAY = 276,
        BVAR_PRIOR_FLAT = 277,
        BVAR_PRIOR_LAMBDA = 278,
        INTERACTIVE = 279,
        SCREEN_SHOCKS = 280,
        STEADYSTATE = 281,
        BVAR_PRIOR_MU = 282,
        BVAR_PRIOR_OMEGA = 283,
        BVAR_PRIOR_TAU = 284,
        BVAR_PRIOR_TRAIN = 285,
        DETAIL_PLOT = 286,
        TYPE = 287,
        BVAR_REPLIC = 288,
        BYTECODE = 289,
        ALL_VALUES_REQUIRED = 290,
        PROPOSAL_DISTRIBUTION = 291,
        REALTIME = 292,
        VINTAGE = 293,
        CALIB_SMOOTHER = 294,
        CHANGE_TYPE = 295,
        CHECK = 296,
        CONDITIONAL_FORECAST = 297,
        CONDITIONAL_FORECAST_PATHS = 298,
        CONF_SIG = 299,
        CONSTANT = 300,
        CONTROLLED_VAREXO = 301,
        CORR = 302,
        CUTOFF = 303,
        CYCLE_REDUCTION = 304,
        LOGARITHMIC_REDUCTION = 305,
        COMMA = 306,
        CONSIDER_ALL_ENDOGENOUS = 307,
        CONSIDER_ONLY_OBSERVED = 308,
        INITIAL_CONDITION_DECOMPOSITION = 309,
        DATAFILE = 310,
        FILE = 311,
        SERIES = 312,
        DOUBLING = 313,
        DR_CYCLE_REDUCTION_TOL = 314,
        DR_LOGARITHMIC_REDUCTION_TOL = 315,
        DR_LOGARITHMIC_REDUCTION_MAXITER = 316,
        DR_ALGO = 317,
        DROP = 318,
        DSAMPLE = 319,
        DYNASAVE = 320,
        DYNATYPE = 321,
        CALIBRATION = 322,
        DIFFERENTIATE_FORWARD_VARS = 323,
        END = 324,
        ENDVAL = 325,
        EQUAL = 326,
        ESTIMATION = 327,
        ESTIMATED_PARAMS = 328,
        ESTIMATED_PARAMS_BOUNDS = 329,
        ESTIMATED_PARAMS_INIT = 330,
        EXTENDED_PATH = 331,
        ENDOGENOUS_PRIOR = 332,
        EXPRESSION = 333,
        FILENAME = 334,
        DIRNAME = 335,
        FILTER_STEP_AHEAD = 336,
        FILTERED_VARS = 337,
        FIRST_OBS = 338,
        LAST_OBS = 339,
        SET_TIME = 340,
        OSR_PARAMS_BOUNDS = 341,
        KEEP_KALMAN_ALGO_IF_SINGULARITY_IS_DETECTED = 342,
        FLOAT_NUMBER = 343,
        DATES = 344,
        DEFAULT = 345,
        FIXED_POINT = 346,
        FLIP = 347,
        OPT_ALGO = 348,
        COMPILATION_SETUP = 349,
        COMPILER = 350,
        ADD_FLAGS = 351,
        SUBSTITUTE_FLAGS = 352,
        ADD_LIBS = 353,
        SUBSTITUTE_LIBS = 354,
        FORECAST = 355,
        K_ORDER_SOLVER = 356,
        INSTRUMENTS = 357,
        SHIFT = 358,
        MEAN = 359,
        STDEV = 360,
        VARIANCE = 361,
        MODE = 362,
        INTERVAL = 363,
        SHAPE = 364,
        DOMAINN = 365,
        GAMMA_PDF = 366,
        GRAPH = 367,
        GRAPH_FORMAT = 368,
        CONDITIONAL_VARIANCE_DECOMPOSITION = 369,
        NOCHECK = 370,
        STD = 371,
        HISTVAL = 372,
        HISTVAL_FILE = 373,
        HOMOTOPY_SETUP = 374,
        HOMOTOPY_MODE = 375,
        HOMOTOPY_STEPS = 376,
        HOMOTOPY_FORCE_CONTINUE = 377,
        HP_FILTER = 378,
        HP_NGRID = 379,
        FILTERED_THEORETICAL_MOMENTS_GRID = 380,
        HYBRID = 381,
        ONE_SIDED_HP_FILTER = 382,
        IDENTIFICATION = 383,
        INF_CONSTANT = 384,
        INITVAL = 385,
        INITVAL_FILE = 386,
        BOUNDS = 387,
        JSCALE = 388,
        INIT = 389,
        INFILE = 390,
        INVARS = 391,
        INT_NUMBER = 392,
        INV_GAMMA_PDF = 393,
        INV_GAMMA1_PDF = 394,
        INV_GAMMA2_PDF = 395,
        IRF = 396,
        IRF_SHOCKS = 397,
        IRF_PLOT_THRESHOLD = 398,
        IRF_CALIBRATION = 399,
        FAST_KALMAN_FILTER = 400,
        KALMAN_ALGO = 401,
        KALMAN_TOL = 402,
        DIFFUSE_KALMAN_TOL = 403,
        SUBSAMPLES = 404,
        OPTIONS = 405,
        TOLF = 406,
        TOLX = 407,
        PLOT_INIT_DATE = 408,
        PLOT_END_DATE = 409,
        LAPLACE = 410,
        LIK_ALGO = 411,
        LIK_INIT = 412,
        LINEAR = 413,
        LINEAR_DECOMPOSITION = 414,
        LOAD_IDENT_FILES = 415,
        LOAD_MH_FILE = 416,
        LOAD_RESULTS_AFTER_LOAD_MH = 417,
        LOAD_PARAMS_AND_STEADY_STATE = 418,
        LOGLINEAR = 419,
        LOGDATA = 420,
        LYAPUNOV = 421,
        LINEAR_APPROXIMATION = 422,
        LYAPUNOV_FIXED_POINT_TOL = 423,
        LYAPUNOV_DOUBLING_TOL = 424,
        LOG_DEFLATOR = 425,
        LOG_TREND_VAR = 426,
        LOG_GROWTH_FACTOR = 427,
        MARKOWITZ = 428,
        MARGINAL_DENSITY = 429,
        MAX = 430,
        MAXIT = 431,
        MFS = 432,
        MH_CONF_SIG = 433,
        MH_DROP = 434,
        MH_INIT_SCALE = 435,
        MH_JSCALE = 436,
        MH_TUNE_JSCALE = 437,
        MH_MODE = 438,
        MH_NBLOCKS = 439,
        MH_REPLIC = 440,
        MH_RECOVER = 441,
        POSTERIOR_MAX_SUBSAMPLE_DRAWS = 442,
        MIN = 443,
        MINIMAL_SOLVING_PERIODS = 444,
        MODE_CHECK = 445,
        MODE_CHECK_NEIGHBOURHOOD_SIZE = 446,
        MODE_CHECK_SYMMETRIC_PLOTS = 447,
        MODE_CHECK_NUMBER_OF_POINTS = 448,
        MODE_COMPUTE = 449,
        MODE_FILE = 450,
        MODEL = 451,
        MODEL_COMPARISON = 452,
        MODEL_INFO = 453,
        MSHOCKS = 454,
        ABS = 455,
        SIGN = 456,
        MODEL_DIAGNOSTICS = 457,
        MODIFIEDHARMONICMEAN = 458,
        MOMENTS_VARENDO = 459,
        CONTEMPORANEOUS_CORRELATION = 460,
        DIFFUSE_FILTER = 461,
        SUB_DRAWS = 462,
        TAPER_STEPS = 463,
        GEWEKE_INTERVAL = 464,
        RAFTERY_LEWIS_QRS = 465,
        RAFTERY_LEWIS_DIAGNOSTICS = 466,
        MCMC_JUMPING_COVARIANCE = 467,
        MOMENT_CALIBRATION = 468,
        NUMBER_OF_PARTICLES = 469,
        RESAMPLING = 470,
        SYSTEMATIC = 471,
        GENERIC = 472,
        RESAMPLING_THRESHOLD = 473,
        RESAMPLING_METHOD = 474,
        KITAGAWA = 475,
        STRATIFIED = 476,
        SMOOTH = 477,
        CPF_WEIGHTS = 478,
        AMISANOTRISTANI = 479,
        MURRAYJONESPARSLOW = 480,
        WRITE_EQUATION_TAGS = 481,
        NONLINEAR_FILTER_INITIALIZATION = 482,
        FILTER_ALGORITHM = 483,
        PROPOSAL_APPROXIMATION = 484,
        CUBATURE = 485,
        UNSCENTED = 486,
        MONTECARLO = 487,
        DISTRIBUTION_APPROXIMATION = 488,
        NAME = 489,
        USE_PENALIZED_OBJECTIVE_FOR_HESSIAN = 490,
        INIT_STATE = 491,
        FAST_REALTIME = 492,
        RESCALE_PREDICTION_ERROR_COVARIANCE = 493,
        GENERATE_IRFS = 494,
        NAN_CONSTANT = 495,
        NO_STATIC = 496,
        NOBS = 497,
        NOCONSTANT = 498,
        NODISPLAY = 499,
        NOCORR = 500,
        NODIAGNOSTIC = 501,
        NOFUNCTIONS = 502,
        NO_HOMOTOPY = 503,
        NOGRAPH = 504,
        POSTERIOR_NOGRAPH = 505,
        POSTERIOR_GRAPH = 506,
        NOMOMENTS = 507,
        NOPRINT = 508,
        NORMAL_PDF = 509,
        SAVE_DRAWS = 510,
        MODEL_NAME = 511,
        STDERR_MULTIPLES = 512,
        DIAGONAL_ONLY = 513,
        OBSERVATION_TRENDS = 514,
        OPTIM = 515,
        OPTIM_WEIGHTS = 516,
        ORDER = 517,
        OSR = 518,
        OSR_PARAMS = 519,
        MAX_DIM_COVA_GROUP = 520,
        ADVANCED = 521,
        OUTFILE = 522,
        OUTVARS = 523,
        OVERWRITE = 524,
        DISCOUNT = 525,
        PARALLEL_LOCAL_FILES = 526,
        PARAMETERS = 527,
        PARAMETER_SET = 528,
        PARTIAL_INFORMATION = 529,
        PERIODS = 530,
        PERIOD = 531,
        PLANNER_OBJECTIVE = 532,
        PLOT_CONDITIONAL_FORECAST = 533,
        PLOT_PRIORS = 534,
        PREFILTER = 535,
        PRESAMPLE = 536,
        PERFECT_FORESIGHT_SETUP = 537,
        PERFECT_FORESIGHT_SOLVER = 538,
        NO_POSTERIOR_KERNEL_DENSITY = 539,
        FUNCTION = 540,
        PRINT = 541,
        PRIOR_MC = 542,
        PRIOR_TRUNC = 543,
        PRIOR_MODE = 544,
        PRIOR_MEAN = 545,
        POSTERIOR_MODE = 546,
        POSTERIOR_MEAN = 547,
        POSTERIOR_MEDIAN = 548,
        MLE_MODE = 549,
        PRUNING = 550,
        QUOTED_STRING = 551,
        QZ_CRITERIUM = 552,
        QZ_ZERO_THRESHOLD = 553,
        DSGE_VAR = 554,
        DSGE_VARLAG = 555,
        DSGE_PRIOR_WEIGHT = 556,
        TRUNCATE = 557,
        PIPE_E = 558,
        PIPE_X = 559,
        PIPE_P = 560,
        RELATIVE_IRF = 561,
        REPLIC = 562,
        SIMUL_REPLIC = 563,
        RPLOT = 564,
        SAVE_PARAMS_AND_STEADY_STATE = 565,
        PARAMETER_UNCERTAINTY = 566,
        TARGETS = 567,
        SHOCKS = 568,
        SHOCK_DECOMPOSITION = 569,
        SHOCK_GROUPS = 570,
        USE_SHOCK_GROUPS = 571,
        SIGMA_E = 572,
        SIMUL = 573,
        SIMUL_ALGO = 574,
        SIMUL_SEED = 575,
        ENDOGENOUS_TERMINAL_PERIOD = 576,
        SMOOTHER = 577,
        SMOOTHER2HISTVAL = 578,
        SQUARE_ROOT_SOLVER = 579,
        STACK_SOLVE_ALGO = 580,
        STEADY_STATE_MODEL = 581,
        SOLVE_ALGO = 582,
        SOLVER_PERIODS = 583,
        ROBUST_LIN_SOLVE = 584,
        STDERR = 585,
        STEADY = 586,
        STOCH_SIMUL = 587,
        SYLVESTER = 588,
        SYLVESTER_FIXED_POINT_TOL = 589,
        REGIMES = 590,
        REGIME = 591,
        REALTIME_SHOCK_DECOMPOSITION = 592,
        CONDITIONAL = 593,
        UNCONDITIONAL = 594,
        TEX = 595,
        RAMSEY_MODEL = 596,
        RAMSEY_POLICY = 597,
        RAMSEY_CONSTRAINTS = 598,
        PLANNER_DISCOUNT = 599,
        PLANNER_DISCOUNT_LATEX_NAME = 600,
        DISCRETIONARY_POLICY = 601,
        DISCRETIONARY_TOL = 602,
        EVALUATE_PLANNER_OBJECTIVE = 603,
        TEX_NAME = 604,
        UNIFORM_PDF = 605,
        UNIT_ROOT_VARS = 606,
        USE_DLL = 607,
        USEAUTOCORR = 608,
        GSA_SAMPLE_FILE = 609,
        USE_UNIVARIATE_FILTERS_IF_SINGULARITY_IS_DETECTED = 610,
        VALUES = 611,
        VAR = 612,
        VAREXO = 613,
        VAREXO_DET = 614,
        VARIABLE = 615,
        VAROBS = 616,
        VAREXOBS = 617,
        PREDETERMINED_VARIABLES = 618,
        VAR_EXPECTATION = 619,
        VAR_EXPECTATION_MODEL = 620,
        PLOT_SHOCK_DECOMPOSITION = 621,
        MODEL_LOCAL_VARIABLE = 622,
        WRITE_LATEX_DYNAMIC_MODEL = 623,
        WRITE_LATEX_STATIC_MODEL = 624,
        WRITE_LATEX_ORIGINAL_MODEL = 625,
        CROSSEQUATIONS = 626,
        COVARIANCE = 627,
        WRITE_LATEX_STEADY_STATE_MODEL = 628,
        XLS_SHEET = 629,
        XLS_RANGE = 630,
        LMMCP = 631,
        OCCBIN = 632,
        BANDPASS_FILTER = 633,
        COLORMAP = 634,
        VAR_MODEL = 635,
        PAC_MODEL = 636,
        QOQ = 637,
        YOY = 638,
        AOA = 639,
        PAC_EXPECTATION = 640,
        TREND_COMPONENT_MODEL = 641,
        EQUAL_EQUAL = 642,
        EXCLAMATION_EQUAL = 643,
        LESS = 644,
        GREATER = 645,
        LESS_EQUAL = 646,
        GREATER_EQUAL = 647,
        PLUS = 648,
        MINUS = 649,
        TIMES = 650,
        DIVIDE = 651,
        UNARY = 652,
        POWER = 653,
        EXP = 654,
        LOG = 655,
        LN = 656,
        LOG10 = 657,
        SIN = 658,
        COS = 659,
        TAN = 660,
        ASIN = 661,
        ACOS = 662,
        ATAN = 663,
        ERF = 664,
        DIFF = 665,
        ADL = 666,
        AUXILIARY_MODEL_NAME = 667,
        SQRT = 668,
        CBRT = 669,
        NORMCDF = 670,
        NORMPDF = 671,
        STEADY_STATE = 672,
        EXPECTATION = 673,
        VAR_ESTIMATION = 674,
        DYNARE_SENSITIVITY = 675,
        MORRIS = 676,
        STAB = 677,
        REDFORM = 678,
        PPRIOR = 679,
        PRIOR_RANGE = 680,
        PPOST = 681,
        ILPTAU = 682,
        MORRIS_NLIV = 683,
        MORRIS_NTRA = 684,
        NSAM = 685,
        LOAD_REDFORM = 686,
        LOAD_RMSE = 687,
        LOAD_STAB = 688,
        ALPHA2_STAB = 689,
        LOGTRANS_REDFORM = 690,
        THRESHOLD_REDFORM = 691,
        KSSTAT_REDFORM = 692,
        ALPHA2_REDFORM = 693,
        NAMENDO = 694,
        NAMLAGENDO = 695,
        NAMEXO = 696,
        RMSE = 697,
        LIK_ONLY = 698,
        VAR_RMSE = 699,
        PFILT_RMSE = 700,
        ISTART_RMSE = 701,
        ALPHA_RMSE = 702,
        ALPHA2_RMSE = 703,
        FREQ = 704,
        INITIAL_YEAR = 705,
        INITIAL_SUBPERIOD = 706,
        FINAL_YEAR = 707,
        FINAL_SUBPERIOD = 708,
        DATA = 709,
        VLIST = 710,
        VLISTLOG = 711,
        VLISTPER = 712,
        SPECTRAL_DENSITY = 713,
        INIT2SHOCKS = 714,
        RESTRICTION = 715,
        RESTRICTION_FNAME = 716,
        CROSS_RESTRICTIONS = 717,
        NLAGS = 718,
        CONTEMP_REDUCED_FORM = 719,
        REAL_PSEUDO_FORECAST = 720,
        DUMMY_OBS = 721,
        NSTATES = 722,
        INDXSCALESSTATES = 723,
        NO_BAYESIAN_PRIOR = 724,
        SPECIFICATION = 725,
        SIMS_ZHA = 726,
        ALPHA = 727,
        BETA = 728,
        ABAND = 729,
        NINV = 730,
        CMS = 731,
        NCMS = 732,
        CNUM = 733,
        GAMMA = 734,
        INV_GAMMA = 735,
        INV_GAMMA1 = 736,
        INV_GAMMA2 = 737,
        NORMAL = 738,
        UNIFORM = 739,
        EPS = 740,
        PDF = 741,
        FIG = 742,
        DR = 743,
        NONE = 744,
        PRIOR = 745,
        PRIOR_VARIANCE = 746,
        HESSIAN = 747,
        IDENTITY_MATRIX = 748,
        DIRICHLET = 749,
        DIAGONAL = 750,
        OPTIMAL = 751,
        GSIG2_LMDM = 752,
        Q_DIAG = 753,
        FLAT_PRIOR = 754,
        NCSK = 755,
        NSTD = 756,
        WEIBULL = 757,
        WEIBULL_PDF = 758,
        INDXPARR = 759,
        INDXOVR = 760,
        INDXAP = 761,
        APBAND = 762,
        INDXIMF = 763,
        INDXFORE = 764,
        FOREBAND = 765,
        INDXGFOREHAT = 766,
        INDXGIMFHAT = 767,
        INDXESTIMA = 768,
        INDXGDLS = 769,
        EQ_MS = 770,
        FILTER_COVARIANCE = 771,
        FILTER_DECOMPOSITION = 772,
        SMOOTHED_STATE_UNCERTAINTY = 773,
        EQ_CMS = 774,
        TLINDX = 775,
        TLNUMBER = 776,
        RESTRICTIONS = 777,
        POSTERIOR_SAMPLER_OPTIONS = 778,
        OUTPUT_FILE_TAG = 779,
        HORIZON = 780,
        SBVAR = 781,
        TREND_VAR = 782,
        DEFLATOR = 783,
        GROWTH_FACTOR = 784,
        MS_IRF = 785,
        MS_VARIANCE_DECOMPOSITION = 786,
        GROWTH = 787,
        MS_ESTIMATION = 788,
        MS_SIMULATION = 789,
        MS_COMPUTE_MDD = 790,
        MS_COMPUTE_PROBABILITIES = 791,
        MS_FORECAST = 792,
        SVAR_IDENTIFICATION = 793,
        EQUATION = 794,
        EXCLUSION = 795,
        LAG = 796,
        UPPER_CHOLESKY = 797,
        LOWER_CHOLESKY = 798,
        MONTHLY = 799,
        QUARTERLY = 800,
        MARKOV_SWITCHING = 801,
        CHAIN = 802,
        DURATION = 803,
        NUMBER_OF_REGIMES = 804,
        NUMBER_OF_LAGS = 805,
        EPILOGUE = 806,
        SVAR = 807,
        SVAR_GLOBAL_IDENTIFICATION_CHECK = 808,
        COEFF = 809,
        COEFFICIENTS = 810,
        VARIANCES = 811,
        CONSTANTS = 812,
        EQUATIONS = 813,
        EXTERNAL_FUNCTION = 814,
        EXT_FUNC_NAME = 815,
        EXT_FUNC_NARGS = 816,
        FIRST_DERIV_PROVIDED = 817,
        SECOND_DERIV_PROVIDED = 818,
        SELECTED_VARIABLES_ONLY = 819,
        COVA_COMPUTE = 820,
        SIMULATION_FILE_TAG = 821,
        FILE_TAG = 822,
        NO_ERROR_BANDS = 823,
        ERROR_BAND_PERCENTILES = 824,
        SHOCKS_PER_PARAMETER = 825,
        NO_CREATE_INIT = 826,
        SHOCK_DRAWS = 827,
        FREE_PARAMETERS = 828,
        MEDIAN = 829,
        DATA_OBS_NBR = 830,
        NEIGHBORHOOD_WIDTH = 831,
        PVALUE_KS = 832,
        PVALUE_CORR = 833,
        FILTERED_PROBABILITIES = 834,
        REAL_TIME_SMOOTHED = 835,
        PRIOR_FUNCTION = 836,
        POSTERIOR_FUNCTION = 837,
        SAMPLING_DRAWS = 838,
        PROPOSAL_TYPE = 839,
        PROPOSAL_UPPER_BOUND = 840,
        PROPOSAL_LOWER_BOUND = 841,
        PROPOSAL_DRAWS = 842,
        USE_MEAN_CENTER = 843,
        ADAPTIVE_MH_DRAWS = 844,
        THINNING_FACTOR = 845,
        COEFFICIENTS_PRIOR_HYPERPARAMETERS = 846,
        SMM_ESTIMATION = 847,
        GMM_ESTIMATION = 848,
        CONVERGENCE_STARTING_VALUE = 849,
        CONVERGENCE_ENDING_VALUE = 850,
        CONVERGENCE_INCREMENT_VALUE = 851,
        MAX_ITERATIONS_STARTING_VALUE = 852,
        MAX_ITERATIONS_INCREMENT_VALUE = 853,
        MAX_BLOCK_ITERATIONS = 854,
        MAX_REPEATED_OPTIMIZATION_RUNS = 855,
        FUNCTION_CONVERGENCE_CRITERION = 856,
        SAVE_REALTIME = 857,
        PARAMETER_CONVERGENCE_CRITERION = 858,
        NUMBER_OF_LARGE_PERTURBATIONS = 859,
        NUMBER_OF_SMALL_PERTURBATIONS = 860,
        NUMBER_OF_POSTERIOR_DRAWS_AFTER_PERTURBATION = 861,
        MAX_NUMBER_OF_STAGES = 862,
        RANDOM_FUNCTION_CONVERGENCE_CRITERION = 863,
        RANDOM_PARAMETER_CONVERGENCE_CRITERION = 864,
        CENTERED_MOMENTS = 865,
        AUTOLAG = 866,
        RECURSIVE_ORDER_ESTIMATION = 867,
        BARTLETT_KERNEL_LAG = 868,
        WEIGHTING_MATRIX = 869,
        PENALIZED_ESTIMATOR = 870,
        VERBOSE = 871,
        SIMULATION_MULTIPLE = 872,
        SEED = 873,
        BOUNDED_SHOCK_SUPPORT = 874,
        EQTAGS = 875,
        STEADY_STATE_GROWTH = 876,
        ANALYTICAL_GIRF = 877,
        IRF_IN_PERCENT = 878,
        EMAS_GIRF = 879,
        EMAS_DROP = 880,
        EMAS_TOLF = 881,
        EMAS_MAX_ITER = 882,
        NO_IDENTIFICATION_STRENGTH = 883,
        NO_IDENTIFICATION_REDUCEDFORM = 884,
        NO_IDENTIFICATION_MOMENTS = 885,
        NO_IDENTIFICATION_MINIMAL = 886,
        NO_IDENTIFICATION_SPECTRUM = 887,
        NORMALIZE_JACOBIANS = 888,
        GRID_NBR = 889,
        TOL_RANK = 890,
        TOL_DERIV = 891,
        TOL_SV = 892,
        CHECKS_VIA_SUBSETS = 893,
        MAX_DIM_SUBSETS_GROUPS = 894,
        MAX_NROWS = 895,
        SQUEEZE_SHOCK_DECOMPOSITION = 896,
        WITH_EPILOGUE = 897,
        SYMBOL_VEC = 898
      };
    };

    /// (External) token type, as returned by yylex.
    typedef token::yytokentype token_type;

    /// Symbol type: an internal symbol number.
    typedef int symbol_number_type;

    /// The symbol type number to denote an empty symbol.
    enum { empty_symbol = -2 };

    /// Internal symbol number for tokens (subsumed by symbol_number_type).
    typedef unsigned short token_number_type;

    /// A complete symbol.
    ///
    /// Expects its Base type to provide access to the symbol type
    /// via type_get ().
    ///
    /// Provide access to semantic value and location.
    template <typename Base>
    struct basic_symbol : Base
    {
      /// Alias to Base.
      typedef Base super_type;

      /// Default constructor.
      basic_symbol ()
        : value ()
        , location ()
      {}

#if 201103L <= YY_CPLUSPLUS
      /// Move constructor.
      basic_symbol (basic_symbol&& that);
#endif

      /// Copy constructor.
      basic_symbol (const basic_symbol& that);

      /// Constructor for valueless symbols, and symbols from each type.
#if 201103L <= YY_CPLUSPLUS
      basic_symbol (typename Base::kind_type t, location_type&& l)
        : Base (t)
        , location (std::move (l))
      {}
#else
      basic_symbol (typename Base::kind_type t, const location_type& l)
        : Base (t)
        , location (l)
      {}
#endif
#if 201103L <= YY_CPLUSPLUS
      basic_symbol (typename Base::kind_type t, PriorDistributions&& v, location_type&& l)
        : Base (t)
        , value (std::move (v))
        , location (std::move (l))
      {}
#else
      basic_symbol (typename Base::kind_type t, const PriorDistributions& v, const location_type& l)
        : Base (t)
        , value (v)
        , location (l)
      {}
#endif
#if 201103L <= YY_CPLUSPLUS
      basic_symbol (typename Base::kind_type t, SymbolType&& v, location_type&& l)
        : Base (t)
        , value (std::move (v))
        , location (std::move (l))
      {}
#else
      basic_symbol (typename Base::kind_type t, const SymbolType& v, const location_type& l)
        : Base (t)
        , value (v)
        , location (l)
      {}
#endif
#if 201103L <= YY_CPLUSPLUS
      basic_symbol (typename Base::kind_type t, expr_t&& v, location_type&& l)
        : Base (t)
        , value (std::move (v))
        , location (std::move (l))
      {}
#else
      basic_symbol (typename Base::kind_type t, const expr_t& v, const location_type& l)
        : Base (t)
        , value (v)
        , location (l)
      {}
#endif
#if 201103L <= YY_CPLUSPLUS
      basic_symbol (typename Base::kind_type t, pair<expr_t,expr_t>&& v, location_type&& l)
        : Base (t)
        , value (std::move (v))
        , location (std::move (l))
      {}
#else
      basic_symbol (typename Base::kind_type t, const pair<expr_t,expr_t>& v, const location_type& l)
        : Base (t)
        , value (v)
        , location (l)
      {}
#endif
#if 201103L <= YY_CPLUSPLUS
      basic_symbol (typename Base::kind_type t, pair<string,string>&& v, location_type&& l)
        : Base (t)
        , value (std::move (v))
        , location (std::move (l))
      {}
#else
      basic_symbol (typename Base::kind_type t, const pair<string,string>& v, const location_type& l)
        : Base (t)
        , value (v)
        , location (l)
      {}
#endif
#if 201103L <= YY_CPLUSPLUS
      basic_symbol (typename Base::kind_type t, string&& v, location_type&& l)
        : Base (t)
        , value (std::move (v))
        , location (std::move (l))
      {}
#else
      basic_symbol (typename Base::kind_type t, const string& v, const location_type& l)
        : Base (t)
        , value (v)
        , location (l)
      {}
#endif
#if 201103L <= YY_CPLUSPLUS
      basic_symbol (typename Base::kind_type t, tuple<string,string,string,string>&& v, location_type&& l)
        : Base (t)
        , value (std::move (v))
        , location (std::move (l))
      {}
#else
      basic_symbol (typename Base::kind_type t, const tuple<string,string,string,string>& v, const location_type& l)
        : Base (t)
        , value (v)
        , location (l)
      {}
#endif
#if 201103L <= YY_CPLUSPLUS
      basic_symbol (typename Base::kind_type t, vector<int>&& v, location_type&& l)
        : Base (t)
        , value (std::move (v))
        , location (std::move (l))
      {}
#else
      basic_symbol (typename Base::kind_type t, const vector<int>& v, const location_type& l)
        : Base (t)
        , value (v)
        , location (l)
      {}
#endif
#if 201103L <= YY_CPLUSPLUS
      basic_symbol (typename Base::kind_type t, vector<pair<string,string>>&& v, location_type&& l)
        : Base (t)
        , value (std::move (v))
        , location (std::move (l))
      {}
#else
      basic_symbol (typename Base::kind_type t, const vector<pair<string,string>>& v, const location_type& l)
        : Base (t)
        , value (v)
        , location (l)
      {}
#endif
#if 201103L <= YY_CPLUSPLUS
      basic_symbol (typename Base::kind_type t, vector<string>&& v, location_type&& l)
        : Base (t)
        , value (std::move (v))
        , location (std::move (l))
      {}
#else
      basic_symbol (typename Base::kind_type t, const vector<string>& v, const location_type& l)
        : Base (t)
        , value (v)
        , location (l)
      {}
#endif

      /// Destroy the symbol.
      ~basic_symbol ()
      {
        clear ();
      }

      /// Destroy contents, and record that is empty.
      void clear ()
      {
        // User destructor.
        symbol_number_type yytype = this->type_get ();
        basic_symbol<Base>& yysym = *this;
        (void) yysym;
        switch (yytype)
        {
       default:
          break;
        }

        // Type destructor.
switch (yytype)
    {
      case 837: // prior_distribution
      case 838: // prior_pdf
        value.template destroy< PriorDistributions > ();
        break;

      case 712: // change_type_arg
        value.template destroy< SymbolType > ();
        break;

      case 716: // expression
      case 719: // expression_or_empty
      case 743: // equation
      case 746: // hand_side
        value.template destroy< expr_t > ();
        break;

      case 1003: // calibration_range
        value.template destroy< pair<expr_t,expr_t> > ();
        break;

      case 702: // named_var_elem
      case 847: // subsamples_eq_opt
      case 1468: // integer_range_w_inf
        value.template destroy< pair<string,string> > ();
        break;

      case 88: // FLOAT_NUMBER
      case 89: // DATES
      case 137: // INT_NUMBER
      case 234: // NAME
      case 296: // QUOTED_STRING
      case 349: // TEX_NAME
      case 472: // ALPHA
      case 473: // BETA
      case 474: // ABAND
      case 475: // NINV
      case 476: // CMS
      case 477: // NCMS
      case 478: // CNUM
      case 479: // GAMMA
      case 480: // INV_GAMMA
      case 481: // INV_GAMMA1
      case 482: // INV_GAMMA2
      case 483: // NORMAL
      case 484: // UNIFORM
      case 485: // EPS
      case 486: // PDF
      case 487: // FIG
      case 488: // DR
      case 489: // NONE
      case 490: // PRIOR
      case 491: // PRIOR_VARIANCE
      case 492: // HESSIAN
      case 493: // IDENTITY_MATRIX
      case 494: // DIRICHLET
      case 495: // DIAGONAL
      case 496: // OPTIMAL
      case 817: // signed_integer
      case 818: // non_negative_number
      case 819: // signed_number
      case 820: // signed_inf
      case 821: // signed_number_w_inf
      case 839: // date_str
      case 840: // date_expr
      case 873: // list_sub_sampling_option
      case 874: // sub_sampling_options
      case 901: // filename
      case 902: // namespace_qualified_symbol
      case 903: // namespace_qualified_filename
      case 1466: // range
      case 1467: // integer_range
      case 1469: // signed_integer_range
      case 1476: // vec_value_1
      case 1477: // vec_value
      case 1478: // vec_value_list
      case 1479: // vec_of_vec_value
      case 1480: // vec_value_1_w_inf
      case 1481: // vec_value_w_inf
      case 1482: // symbol
      case 1483: // number
        value.template destroy< string > ();
        break;

      case 862: // prior_eq_opt
      case 867: // options_eq_opt
        value.template destroy< tuple<string,string,string,string> > ();
        break;

      case 1470: // vec_int_number
      case 1471: // vec_int_elem
      case 1472: // vec_int_1
      case 1473: // vec_int
        value.template destroy< vector<int> > ();
        break;

      case 703: // named_var_1
      case 704: // named_var
        value.template destroy< vector<pair<string,string>> > ();
        break;

      case 643: // SYMBOL_VEC
      case 713: // change_type_var_list
      case 1474: // vec_str_1
      case 1475: // vec_str
        value.template destroy< vector<string> > ();
        break;

      default:
        break;
    }

        Base::clear ();
      }

      /// Whether empty.
      bool empty () const YY_NOEXCEPT;

      /// Destructive move, \a s is emptied into this.
      void move (basic_symbol& s);

      /// The semantic value.
      semantic_type value;

      /// The location.
      location_type location;

    private:
#if YY_CPLUSPLUS < 201103L
      /// Assignment operator.
      basic_symbol& operator= (const basic_symbol& that);
#endif
    };

    /// Type access provider for token (enum) based symbols.
    struct by_type
    {
      /// Default constructor.
      by_type ();

#if 201103L <= YY_CPLUSPLUS
      /// Move constructor.
      by_type (by_type&& that);
#endif

      /// Copy constructor.
      by_type (const by_type& that);

      /// The symbol type as needed by the constructor.
      typedef token_type kind_type;

      /// Constructor from (external) token numbers.
      by_type (kind_type t);

      /// Record that this symbol is empty.
      void clear ();

      /// Steal the symbol type from \a that.
      void move (by_type& that);

      /// The (internal) type number (corresponding to \a type).
      /// \a empty when empty.
      symbol_number_type type_get () const YY_NOEXCEPT;

      /// The token.
      token_type token () const YY_NOEXCEPT;

      /// The symbol type.
      /// \a empty_symbol when empty.
      /// An int, not token_number_type, to be able to store empty_symbol.
      int type;
    };

    /// "External" symbols: returned by the scanner.
    struct symbol_type : basic_symbol<by_type>
    {
      /// Superclass.
      typedef basic_symbol<by_type> super_type;

      /// Empty symbol.
      symbol_type () {}

      /// Constructor for valueless symbols, and symbols from each type.
#if 201103L <= YY_CPLUSPLUS
      symbol_type (int tok, location_type l)
        : super_type(token_type (tok), std::move (l))
      {
        YYASSERT (tok == 0 || tok == token::AIM_SOLVER || tok == token::ANALYTIC_DERIVATION || tok == token::ANALYTIC_DERIVATION_MODE || tok == token::AR || tok == token::POSTERIOR_SAMPLING_METHOD || tok == token::BALANCED_GROWTH_TEST_TOL || tok == token::BAYESIAN_IRF || tok == token::BETA_PDF || tok == token::BLOCK || tok == token::USE_CALIBRATION || tok == token::SILENT_OPTIMIZER || tok == token::BVAR_DENSITY || tok == token::BVAR_FORECAST || tok == token::NODECOMPOSITION || tok == token::DR_DISPLAY_TOL || tok == token::HUGE_NUMBER || tok == token::FIG_NAME || tok == token::WRITE_XLS || tok == token::BVAR_PRIOR_DECAY || tok == token::BVAR_PRIOR_FLAT || tok == token::BVAR_PRIOR_LAMBDA || tok == token::INTERACTIVE || tok == token::SCREEN_SHOCKS || tok == token::STEADYSTATE || tok == token::BVAR_PRIOR_MU || tok == token::BVAR_PRIOR_OMEGA || tok == token::BVAR_PRIOR_TAU || tok == token::BVAR_PRIOR_TRAIN || tok == token::DETAIL_PLOT || tok == token::TYPE || tok == token::BVAR_REPLIC || tok == token::BYTECODE || tok == token::ALL_VALUES_REQUIRED || tok == token::PROPOSAL_DISTRIBUTION || tok == token::REALTIME || tok == token::VINTAGE || tok == token::CALIB_SMOOTHER || tok == token::CHANGE_TYPE || tok == token::CHECK || tok == token::CONDITIONAL_FORECAST || tok == token::CONDITIONAL_FORECAST_PATHS || tok == token::CONF_SIG || tok == token::CONSTANT || tok == token::CONTROLLED_VAREXO || tok == token::CORR || tok == token::CUTOFF || tok == token::CYCLE_REDUCTION || tok == token::LOGARITHMIC_REDUCTION || tok == token::COMMA || tok == token::CONSIDER_ALL_ENDOGENOUS || tok == token::CONSIDER_ONLY_OBSERVED || tok == token::INITIAL_CONDITION_DECOMPOSITION || tok == token::DATAFILE || tok == token::FILE || tok == token::SERIES || tok == token::DOUBLING || tok == token::DR_CYCLE_REDUCTION_TOL || tok == token::DR_LOGARITHMIC_REDUCTION_TOL || tok == token::DR_LOGARITHMIC_REDUCTION_MAXITER || tok == token::DR_ALGO || tok == token::DROP || tok == token::DSAMPLE || tok == token::DYNASAVE || tok == token::DYNATYPE || tok == token::CALIBRATION || tok == token::DIFFERENTIATE_FORWARD_VARS || tok == token::END || tok == token::ENDVAL || tok == token::EQUAL || tok == token::ESTIMATION || tok == token::ESTIMATED_PARAMS || tok == token::ESTIMATED_PARAMS_BOUNDS || tok == token::ESTIMATED_PARAMS_INIT || tok == token::EXTENDED_PATH || tok == token::ENDOGENOUS_PRIOR || tok == token::EXPRESSION || tok == token::FILENAME || tok == token::DIRNAME || tok == token::FILTER_STEP_AHEAD || tok == token::FILTERED_VARS || tok == token::FIRST_OBS || tok == token::LAST_OBS || tok == token::SET_TIME || tok == token::OSR_PARAMS_BOUNDS || tok == token::KEEP_KALMAN_ALGO_IF_SINGULARITY_IS_DETECTED || tok == token::DEFAULT || tok == token::FIXED_POINT || tok == token::FLIP || tok == token::OPT_ALGO || tok == token::COMPILATION_SETUP || tok == token::COMPILER || tok == token::ADD_FLAGS || tok == token::SUBSTITUTE_FLAGS || tok == token::ADD_LIBS || tok == token::SUBSTITUTE_LIBS || tok == token::FORECAST || tok == token::K_ORDER_SOLVER || tok == token::INSTRUMENTS || tok == token::SHIFT || tok == token::MEAN || tok == token::STDEV || tok == token::VARIANCE || tok == token::MODE || tok == token::INTERVAL || tok == token::SHAPE || tok == token::DOMAINN || tok == token::GAMMA_PDF || tok == token::GRAPH || tok == token::GRAPH_FORMAT || tok == token::CONDITIONAL_VARIANCE_DECOMPOSITION || tok == token::NOCHECK || tok == token::STD || tok == token::HISTVAL || tok == token::HISTVAL_FILE || tok == token::HOMOTOPY_SETUP || tok == token::HOMOTOPY_MODE || tok == token::HOMOTOPY_STEPS || tok == token::HOMOTOPY_FORCE_CONTINUE || tok == token::HP_FILTER || tok == token::HP_NGRID || tok == token::FILTERED_THEORETICAL_MOMENTS_GRID || tok == token::HYBRID || tok == token::ONE_SIDED_HP_FILTER || tok == token::IDENTIFICATION || tok == token::INF_CONSTANT || tok == token::INITVAL || tok == token::INITVAL_FILE || tok == token::BOUNDS || tok == token::JSCALE || tok == token::INIT || tok == token::INFILE || tok == token::INVARS || tok == token::INV_GAMMA_PDF || tok == token::INV_GAMMA1_PDF || tok == token::INV_GAMMA2_PDF || tok == token::IRF || tok == token::IRF_SHOCKS || tok == token::IRF_PLOT_THRESHOLD || tok == token::IRF_CALIBRATION || tok == token::FAST_KALMAN_FILTER || tok == token::KALMAN_ALGO || tok == token::KALMAN_TOL || tok == token::DIFFUSE_KALMAN_TOL || tok == token::SUBSAMPLES || tok == token::OPTIONS || tok == token::TOLF || tok == token::TOLX || tok == token::PLOT_INIT_DATE || tok == token::PLOT_END_DATE || tok == token::LAPLACE || tok == token::LIK_ALGO || tok == token::LIK_INIT || tok == token::LINEAR || tok == token::LINEAR_DECOMPOSITION || tok == token::LOAD_IDENT_FILES || tok == token::LOAD_MH_FILE || tok == token::LOAD_RESULTS_AFTER_LOAD_MH || tok == token::LOAD_PARAMS_AND_STEADY_STATE || tok == token::LOGLINEAR || tok == token::LOGDATA || tok == token::LYAPUNOV || tok == token::LINEAR_APPROXIMATION || tok == token::LYAPUNOV_FIXED_POINT_TOL || tok == token::LYAPUNOV_DOUBLING_TOL || tok == token::LOG_DEFLATOR || tok == token::LOG_TREND_VAR || tok == token::LOG_GROWTH_FACTOR || tok == token::MARKOWITZ || tok == token::MARGINAL_DENSITY || tok == token::MAX || tok == token::MAXIT || tok == token::MFS || tok == token::MH_CONF_SIG || tok == token::MH_DROP || tok == token::MH_INIT_SCALE || tok == token::MH_JSCALE || tok == token::MH_TUNE_JSCALE || tok == token::MH_MODE || tok == token::MH_NBLOCKS || tok == token::MH_REPLIC || tok == token::MH_RECOVER || tok == token::POSTERIOR_MAX_SUBSAMPLE_DRAWS || tok == token::MIN || tok == token::MINIMAL_SOLVING_PERIODS || tok == token::MODE_CHECK || tok == token::MODE_CHECK_NEIGHBOURHOOD_SIZE || tok == token::MODE_CHECK_SYMMETRIC_PLOTS || tok == token::MODE_CHECK_NUMBER_OF_POINTS || tok == token::MODE_COMPUTE || tok == token::MODE_FILE || tok == token::MODEL || tok == token::MODEL_COMPARISON || tok == token::MODEL_INFO || tok == token::MSHOCKS || tok == token::ABS || tok == token::SIGN || tok == token::MODEL_DIAGNOSTICS || tok == token::MODIFIEDHARMONICMEAN || tok == token::MOMENTS_VARENDO || tok == token::CONTEMPORANEOUS_CORRELATION || tok == token::DIFFUSE_FILTER || tok == token::SUB_DRAWS || tok == token::TAPER_STEPS || tok == token::GEWEKE_INTERVAL || tok == token::RAFTERY_LEWIS_QRS || tok == token::RAFTERY_LEWIS_DIAGNOSTICS || tok == token::MCMC_JUMPING_COVARIANCE || tok == token::MOMENT_CALIBRATION || tok == token::NUMBER_OF_PARTICLES || tok == token::RESAMPLING || tok == token::SYSTEMATIC || tok == token::GENERIC || tok == token::RESAMPLING_THRESHOLD || tok == token::RESAMPLING_METHOD || tok == token::KITAGAWA || tok == token::STRATIFIED || tok == token::SMOOTH || tok == token::CPF_WEIGHTS || tok == token::AMISANOTRISTANI || tok == token::MURRAYJONESPARSLOW || tok == token::WRITE_EQUATION_TAGS || tok == token::NONLINEAR_FILTER_INITIALIZATION || tok == token::FILTER_ALGORITHM || tok == token::PROPOSAL_APPROXIMATION || tok == token::CUBATURE || tok == token::UNSCENTED || tok == token::MONTECARLO || tok == token::DISTRIBUTION_APPROXIMATION || tok == token::USE_PENALIZED_OBJECTIVE_FOR_HESSIAN || tok == token::INIT_STATE || tok == token::FAST_REALTIME || tok == token::RESCALE_PREDICTION_ERROR_COVARIANCE || tok == token::GENERATE_IRFS || tok == token::NAN_CONSTANT || tok == token::NO_STATIC || tok == token::NOBS || tok == token::NOCONSTANT || tok == token::NODISPLAY || tok == token::NOCORR || tok == token::NODIAGNOSTIC || tok == token::NOFUNCTIONS || tok == token::NO_HOMOTOPY || tok == token::NOGRAPH || tok == token::POSTERIOR_NOGRAPH || tok == token::POSTERIOR_GRAPH || tok == token::NOMOMENTS || tok == token::NOPRINT || tok == token::NORMAL_PDF || tok == token::SAVE_DRAWS || tok == token::MODEL_NAME || tok == token::STDERR_MULTIPLES || tok == token::DIAGONAL_ONLY || tok == token::OBSERVATION_TRENDS || tok == token::OPTIM || tok == token::OPTIM_WEIGHTS || tok == token::ORDER || tok == token::OSR || tok == token::OSR_PARAMS || tok == token::MAX_DIM_COVA_GROUP || tok == token::ADVANCED || tok == token::OUTFILE || tok == token::OUTVARS || tok == token::OVERWRITE || tok == token::DISCOUNT || tok == token::PARALLEL_LOCAL_FILES || tok == token::PARAMETERS || tok == token::PARAMETER_SET || tok == token::PARTIAL_INFORMATION || tok == token::PERIODS || tok == token::PERIOD || tok == token::PLANNER_OBJECTIVE || tok == token::PLOT_CONDITIONAL_FORECAST || tok == token::PLOT_PRIORS || tok == token::PREFILTER || tok == token::PRESAMPLE || tok == token::PERFECT_FORESIGHT_SETUP || tok == token::PERFECT_FORESIGHT_SOLVER || tok == token::NO_POSTERIOR_KERNEL_DENSITY || tok == token::FUNCTION || tok == token::PRINT || tok == token::PRIOR_MC || tok == token::PRIOR_TRUNC || tok == token::PRIOR_MODE || tok == token::PRIOR_MEAN || tok == token::POSTERIOR_MODE || tok == token::POSTERIOR_MEAN || tok == token::POSTERIOR_MEDIAN || tok == token::MLE_MODE || tok == token::PRUNING || tok == token::QZ_CRITERIUM || tok == token::QZ_ZERO_THRESHOLD || tok == token::DSGE_VAR || tok == token::DSGE_VARLAG || tok == token::DSGE_PRIOR_WEIGHT || tok == token::TRUNCATE || tok == token::PIPE_E || tok == token::PIPE_X || tok == token::PIPE_P || tok == token::RELATIVE_IRF || tok == token::REPLIC || tok == token::SIMUL_REPLIC || tok == token::RPLOT || tok == token::SAVE_PARAMS_AND_STEADY_STATE || tok == token::PARAMETER_UNCERTAINTY || tok == token::TARGETS || tok == token::SHOCKS || tok == token::SHOCK_DECOMPOSITION || tok == token::SHOCK_GROUPS || tok == token::USE_SHOCK_GROUPS || tok == token::SIGMA_E || tok == token::SIMUL || tok == token::SIMUL_ALGO || tok == token::SIMUL_SEED || tok == token::ENDOGENOUS_TERMINAL_PERIOD || tok == token::SMOOTHER || tok == token::SMOOTHER2HISTVAL || tok == token::SQUARE_ROOT_SOLVER || tok == token::STACK_SOLVE_ALGO || tok == token::STEADY_STATE_MODEL || tok == token::SOLVE_ALGO || tok == token::SOLVER_PERIODS || tok == token::ROBUST_LIN_SOLVE || tok == token::STDERR || tok == token::STEADY || tok == token::STOCH_SIMUL || tok == token::SYLVESTER || tok == token::SYLVESTER_FIXED_POINT_TOL || tok == token::REGIMES || tok == token::REGIME || tok == token::REALTIME_SHOCK_DECOMPOSITION || tok == token::CONDITIONAL || tok == token::UNCONDITIONAL || tok == token::TEX || tok == token::RAMSEY_MODEL || tok == token::RAMSEY_POLICY || tok == token::RAMSEY_CONSTRAINTS || tok == token::PLANNER_DISCOUNT || tok == token::PLANNER_DISCOUNT_LATEX_NAME || tok == token::DISCRETIONARY_POLICY || tok == token::DISCRETIONARY_TOL || tok == token::EVALUATE_PLANNER_OBJECTIVE || tok == token::UNIFORM_PDF || tok == token::UNIT_ROOT_VARS || tok == token::USE_DLL || tok == token::USEAUTOCORR || tok == token::GSA_SAMPLE_FILE || tok == token::USE_UNIVARIATE_FILTERS_IF_SINGULARITY_IS_DETECTED || tok == token::VALUES || tok == token::VAR || tok == token::VAREXO || tok == token::VAREXO_DET || tok == token::VARIABLE || tok == token::VAROBS || tok == token::VAREXOBS || tok == token::PREDETERMINED_VARIABLES || tok == token::VAR_EXPECTATION || tok == token::VAR_EXPECTATION_MODEL || tok == token::PLOT_SHOCK_DECOMPOSITION || tok == token::MODEL_LOCAL_VARIABLE || tok == token::WRITE_LATEX_DYNAMIC_MODEL || tok == token::WRITE_LATEX_STATIC_MODEL || tok == token::WRITE_LATEX_ORIGINAL_MODEL || tok == token::CROSSEQUATIONS || tok == token::COVARIANCE || tok == token::WRITE_LATEX_STEADY_STATE_MODEL || tok == token::XLS_SHEET || tok == token::XLS_RANGE || tok == token::LMMCP || tok == token::OCCBIN || tok == token::BANDPASS_FILTER || tok == token::COLORMAP || tok == token::VAR_MODEL || tok == token::PAC_MODEL || tok == token::QOQ || tok == token::YOY || tok == token::AOA || tok == token::PAC_EXPECTATION || tok == token::TREND_COMPONENT_MODEL || tok == token::EQUAL_EQUAL || tok == token::EXCLAMATION_EQUAL || tok == token::LESS || tok == token::GREATER || tok == token::LESS_EQUAL || tok == token::GREATER_EQUAL || tok == token::PLUS || tok == token::MINUS || tok == token::TIMES || tok == token::DIVIDE || tok == token::UNARY || tok == token::POWER || tok == token::EXP || tok == token::LOG || tok == token::LN || tok == token::LOG10 || tok == token::SIN || tok == token::COS || tok == token::TAN || tok == token::ASIN || tok == token::ACOS || tok == token::ATAN || tok == token::ERF || tok == token::DIFF || tok == token::ADL || tok == token::AUXILIARY_MODEL_NAME || tok == token::SQRT || tok == token::CBRT || tok == token::NORMCDF || tok == token::NORMPDF || tok == token::STEADY_STATE || tok == token::EXPECTATION || tok == token::VAR_ESTIMATION || tok == token::DYNARE_SENSITIVITY || tok == token::MORRIS || tok == token::STAB || tok == token::REDFORM || tok == token::PPRIOR || tok == token::PRIOR_RANGE || tok == token::PPOST || tok == token::ILPTAU || tok == token::MORRIS_NLIV || tok == token::MORRIS_NTRA || tok == token::NSAM || tok == token::LOAD_REDFORM || tok == token::LOAD_RMSE || tok == token::LOAD_STAB || tok == token::ALPHA2_STAB || tok == token::LOGTRANS_REDFORM || tok == token::THRESHOLD_REDFORM || tok == token::KSSTAT_REDFORM || tok == token::ALPHA2_REDFORM || tok == token::NAMENDO || tok == token::NAMLAGENDO || tok == token::NAMEXO || tok == token::RMSE || tok == token::LIK_ONLY || tok == token::VAR_RMSE || tok == token::PFILT_RMSE || tok == token::ISTART_RMSE || tok == token::ALPHA_RMSE || tok == token::ALPHA2_RMSE || tok == token::FREQ || tok == token::INITIAL_YEAR || tok == token::INITIAL_SUBPERIOD || tok == token::FINAL_YEAR || tok == token::FINAL_SUBPERIOD || tok == token::DATA || tok == token::VLIST || tok == token::VLISTLOG || tok == token::VLISTPER || tok == token::SPECTRAL_DENSITY || tok == token::INIT2SHOCKS || tok == token::RESTRICTION || tok == token::RESTRICTION_FNAME || tok == token::CROSS_RESTRICTIONS || tok == token::NLAGS || tok == token::CONTEMP_REDUCED_FORM || tok == token::REAL_PSEUDO_FORECAST || tok == token::DUMMY_OBS || tok == token::NSTATES || tok == token::INDXSCALESSTATES || tok == token::NO_BAYESIAN_PRIOR || tok == token::SPECIFICATION || tok == token::SIMS_ZHA || tok == token::GSIG2_LMDM || tok == token::Q_DIAG || tok == token::FLAT_PRIOR || tok == token::NCSK || tok == token::NSTD || tok == token::WEIBULL || tok == token::WEIBULL_PDF || tok == token::INDXPARR || tok == token::INDXOVR || tok == token::INDXAP || tok == token::APBAND || tok == token::INDXIMF || tok == token::INDXFORE || tok == token::FOREBAND || tok == token::INDXGFOREHAT || tok == token::INDXGIMFHAT || tok == token::INDXESTIMA || tok == token::INDXGDLS || tok == token::EQ_MS || tok == token::FILTER_COVARIANCE || tok == token::FILTER_DECOMPOSITION || tok == token::SMOOTHED_STATE_UNCERTAINTY || tok == token::EQ_CMS || tok == token::TLINDX || tok == token::TLNUMBER || tok == token::RESTRICTIONS || tok == token::POSTERIOR_SAMPLER_OPTIONS || tok == token::OUTPUT_FILE_TAG || tok == token::HORIZON || tok == token::SBVAR || tok == token::TREND_VAR || tok == token::DEFLATOR || tok == token::GROWTH_FACTOR || tok == token::MS_IRF || tok == token::MS_VARIANCE_DECOMPOSITION || tok == token::GROWTH || tok == token::MS_ESTIMATION || tok == token::MS_SIMULATION || tok == token::MS_COMPUTE_MDD || tok == token::MS_COMPUTE_PROBABILITIES || tok == token::MS_FORECAST || tok == token::SVAR_IDENTIFICATION || tok == token::EQUATION || tok == token::EXCLUSION || tok == token::LAG || tok == token::UPPER_CHOLESKY || tok == token::LOWER_CHOLESKY || tok == token::MONTHLY || tok == token::QUARTERLY || tok == token::MARKOV_SWITCHING || tok == token::CHAIN || tok == token::DURATION || tok == token::NUMBER_OF_REGIMES || tok == token::NUMBER_OF_LAGS || tok == token::EPILOGUE || tok == token::SVAR || tok == token::SVAR_GLOBAL_IDENTIFICATION_CHECK || tok == token::COEFF || tok == token::COEFFICIENTS || tok == token::VARIANCES || tok == token::CONSTANTS || tok == token::EQUATIONS || tok == token::EXTERNAL_FUNCTION || tok == token::EXT_FUNC_NAME || tok == token::EXT_FUNC_NARGS || tok == token::FIRST_DERIV_PROVIDED || tok == token::SECOND_DERIV_PROVIDED || tok == token::SELECTED_VARIABLES_ONLY || tok == token::COVA_COMPUTE || tok == token::SIMULATION_FILE_TAG || tok == token::FILE_TAG || tok == token::NO_ERROR_BANDS || tok == token::ERROR_BAND_PERCENTILES || tok == token::SHOCKS_PER_PARAMETER || tok == token::NO_CREATE_INIT || tok == token::SHOCK_DRAWS || tok == token::FREE_PARAMETERS || tok == token::MEDIAN || tok == token::DATA_OBS_NBR || tok == token::NEIGHBORHOOD_WIDTH || tok == token::PVALUE_KS || tok == token::PVALUE_CORR || tok == token::FILTERED_PROBABILITIES || tok == token::REAL_TIME_SMOOTHED || tok == token::PRIOR_FUNCTION || tok == token::POSTERIOR_FUNCTION || tok == token::SAMPLING_DRAWS || tok == token::PROPOSAL_TYPE || tok == token::PROPOSAL_UPPER_BOUND || tok == token::PROPOSAL_LOWER_BOUND || tok == token::PROPOSAL_DRAWS || tok == token::USE_MEAN_CENTER || tok == token::ADAPTIVE_MH_DRAWS || tok == token::THINNING_FACTOR || tok == token::COEFFICIENTS_PRIOR_HYPERPARAMETERS || tok == token::SMM_ESTIMATION || tok == token::GMM_ESTIMATION || tok == token::CONVERGENCE_STARTING_VALUE || tok == token::CONVERGENCE_ENDING_VALUE || tok == token::CONVERGENCE_INCREMENT_VALUE || tok == token::MAX_ITERATIONS_STARTING_VALUE || tok == token::MAX_ITERATIONS_INCREMENT_VALUE || tok == token::MAX_BLOCK_ITERATIONS || tok == token::MAX_REPEATED_OPTIMIZATION_RUNS || tok == token::FUNCTION_CONVERGENCE_CRITERION || tok == token::SAVE_REALTIME || tok == token::PARAMETER_CONVERGENCE_CRITERION || tok == token::NUMBER_OF_LARGE_PERTURBATIONS || tok == token::NUMBER_OF_SMALL_PERTURBATIONS || tok == token::NUMBER_OF_POSTERIOR_DRAWS_AFTER_PERTURBATION || tok == token::MAX_NUMBER_OF_STAGES || tok == token::RANDOM_FUNCTION_CONVERGENCE_CRITERION || tok == token::RANDOM_PARAMETER_CONVERGENCE_CRITERION || tok == token::CENTERED_MOMENTS || tok == token::AUTOLAG || tok == token::RECURSIVE_ORDER_ESTIMATION || tok == token::BARTLETT_KERNEL_LAG || tok == token::WEIGHTING_MATRIX || tok == token::PENALIZED_ESTIMATOR || tok == token::VERBOSE || tok == token::SIMULATION_MULTIPLE || tok == token::SEED || tok == token::BOUNDED_SHOCK_SUPPORT || tok == token::EQTAGS || tok == token::STEADY_STATE_GROWTH || tok == token::ANALYTICAL_GIRF || tok == token::IRF_IN_PERCENT || tok == token::EMAS_GIRF || tok == token::EMAS_DROP || tok == token::EMAS_TOLF || tok == token::EMAS_MAX_ITER || tok == token::NO_IDENTIFICATION_STRENGTH || tok == token::NO_IDENTIFICATION_REDUCEDFORM || tok == token::NO_IDENTIFICATION_MOMENTS || tok == token::NO_IDENTIFICATION_MINIMAL || tok == token::NO_IDENTIFICATION_SPECTRUM || tok == token::NORMALIZE_JACOBIANS || tok == token::GRID_NBR || tok == token::TOL_RANK || tok == token::TOL_DERIV || tok == token::TOL_SV || tok == token::CHECKS_VIA_SUBSETS || tok == token::MAX_DIM_SUBSETS_GROUPS || tok == token::MAX_NROWS || tok == token::SQUEEZE_SHOCK_DECOMPOSITION || tok == token::WITH_EPILOGUE || tok == 59 || tok == 40 || tok == 41 || tok == 91 || tok == 93 || tok == 35 || tok == 58 || tok == 46);
      }
#else
      symbol_type (int tok, const location_type& l)
        : super_type(token_type (tok), l)
      {
        YYASSERT (tok == 0 || tok == token::AIM_SOLVER || tok == token::ANALYTIC_DERIVATION || tok == token::ANALYTIC_DERIVATION_MODE || tok == token::AR || tok == token::POSTERIOR_SAMPLING_METHOD || tok == token::BALANCED_GROWTH_TEST_TOL || tok == token::BAYESIAN_IRF || tok == token::BETA_PDF || tok == token::BLOCK || tok == token::USE_CALIBRATION || tok == token::SILENT_OPTIMIZER || tok == token::BVAR_DENSITY || tok == token::BVAR_FORECAST || tok == token::NODECOMPOSITION || tok == token::DR_DISPLAY_TOL || tok == token::HUGE_NUMBER || tok == token::FIG_NAME || tok == token::WRITE_XLS || tok == token::BVAR_PRIOR_DECAY || tok == token::BVAR_PRIOR_FLAT || tok == token::BVAR_PRIOR_LAMBDA || tok == token::INTERACTIVE || tok == token::SCREEN_SHOCKS || tok == token::STEADYSTATE || tok == token::BVAR_PRIOR_MU || tok == token::BVAR_PRIOR_OMEGA || tok == token::BVAR_PRIOR_TAU || tok == token::BVAR_PRIOR_TRAIN || tok == token::DETAIL_PLOT || tok == token::TYPE || tok == token::BVAR_REPLIC || tok == token::BYTECODE || tok == token::ALL_VALUES_REQUIRED || tok == token::PROPOSAL_DISTRIBUTION || tok == token::REALTIME || tok == token::VINTAGE || tok == token::CALIB_SMOOTHER || tok == token::CHANGE_TYPE || tok == token::CHECK || tok == token::CONDITIONAL_FORECAST || tok == token::CONDITIONAL_FORECAST_PATHS || tok == token::CONF_SIG || tok == token::CONSTANT || tok == token::CONTROLLED_VAREXO || tok == token::CORR || tok == token::CUTOFF || tok == token::CYCLE_REDUCTION || tok == token::LOGARITHMIC_REDUCTION || tok == token::COMMA || tok == token::CONSIDER_ALL_ENDOGENOUS || tok == token::CONSIDER_ONLY_OBSERVED || tok == token::INITIAL_CONDITION_DECOMPOSITION || tok == token::DATAFILE || tok == token::FILE || tok == token::SERIES || tok == token::DOUBLING || tok == token::DR_CYCLE_REDUCTION_TOL || tok == token::DR_LOGARITHMIC_REDUCTION_TOL || tok == token::DR_LOGARITHMIC_REDUCTION_MAXITER || tok == token::DR_ALGO || tok == token::DROP || tok == token::DSAMPLE || tok == token::DYNASAVE || tok == token::DYNATYPE || tok == token::CALIBRATION || tok == token::DIFFERENTIATE_FORWARD_VARS || tok == token::END || tok == token::ENDVAL || tok == token::EQUAL || tok == token::ESTIMATION || tok == token::ESTIMATED_PARAMS || tok == token::ESTIMATED_PARAMS_BOUNDS || tok == token::ESTIMATED_PARAMS_INIT || tok == token::EXTENDED_PATH || tok == token::ENDOGENOUS_PRIOR || tok == token::EXPRESSION || tok == token::FILENAME || tok == token::DIRNAME || tok == token::FILTER_STEP_AHEAD || tok == token::FILTERED_VARS || tok == token::FIRST_OBS || tok == token::LAST_OBS || tok == token::SET_TIME || tok == token::OSR_PARAMS_BOUNDS || tok == token::KEEP_KALMAN_ALGO_IF_SINGULARITY_IS_DETECTED || tok == token::DEFAULT || tok == token::FIXED_POINT || tok == token::FLIP || tok == token::OPT_ALGO || tok == token::COMPILATION_SETUP || tok == token::COMPILER || tok == token::ADD_FLAGS || tok == token::SUBSTITUTE_FLAGS || tok == token::ADD_LIBS || tok == token::SUBSTITUTE_LIBS || tok == token::FORECAST || tok == token::K_ORDER_SOLVER || tok == token::INSTRUMENTS || tok == token::SHIFT || tok == token::MEAN || tok == token::STDEV || tok == token::VARIANCE || tok == token::MODE || tok == token::INTERVAL || tok == token::SHAPE || tok == token::DOMAINN || tok == token::GAMMA_PDF || tok == token::GRAPH || tok == token::GRAPH_FORMAT || tok == token::CONDITIONAL_VARIANCE_DECOMPOSITION || tok == token::NOCHECK || tok == token::STD || tok == token::HISTVAL || tok == token::HISTVAL_FILE || tok == token::HOMOTOPY_SETUP || tok == token::HOMOTOPY_MODE || tok == token::HOMOTOPY_STEPS || tok == token::HOMOTOPY_FORCE_CONTINUE || tok == token::HP_FILTER || tok == token::HP_NGRID || tok == token::FILTERED_THEORETICAL_MOMENTS_GRID || tok == token::HYBRID || tok == token::ONE_SIDED_HP_FILTER || tok == token::IDENTIFICATION || tok == token::INF_CONSTANT || tok == token::INITVAL || tok == token::INITVAL_FILE || tok == token::BOUNDS || tok == token::JSCALE || tok == token::INIT || tok == token::INFILE || tok == token::INVARS || tok == token::INV_GAMMA_PDF || tok == token::INV_GAMMA1_PDF || tok == token::INV_GAMMA2_PDF || tok == token::IRF || tok == token::IRF_SHOCKS || tok == token::IRF_PLOT_THRESHOLD || tok == token::IRF_CALIBRATION || tok == token::FAST_KALMAN_FILTER || tok == token::KALMAN_ALGO || tok == token::KALMAN_TOL || tok == token::DIFFUSE_KALMAN_TOL || tok == token::SUBSAMPLES || tok == token::OPTIONS || tok == token::TOLF || tok == token::TOLX || tok == token::PLOT_INIT_DATE || tok == token::PLOT_END_DATE || tok == token::LAPLACE || tok == token::LIK_ALGO || tok == token::LIK_INIT || tok == token::LINEAR || tok == token::LINEAR_DECOMPOSITION || tok == token::LOAD_IDENT_FILES || tok == token::LOAD_MH_FILE || tok == token::LOAD_RESULTS_AFTER_LOAD_MH || tok == token::LOAD_PARAMS_AND_STEADY_STATE || tok == token::LOGLINEAR || tok == token::LOGDATA || tok == token::LYAPUNOV || tok == token::LINEAR_APPROXIMATION || tok == token::LYAPUNOV_FIXED_POINT_TOL || tok == token::LYAPUNOV_DOUBLING_TOL || tok == token::LOG_DEFLATOR || tok == token::LOG_TREND_VAR || tok == token::LOG_GROWTH_FACTOR || tok == token::MARKOWITZ || tok == token::MARGINAL_DENSITY || tok == token::MAX || tok == token::MAXIT || tok == token::MFS || tok == token::MH_CONF_SIG || tok == token::MH_DROP || tok == token::MH_INIT_SCALE || tok == token::MH_JSCALE || tok == token::MH_TUNE_JSCALE || tok == token::MH_MODE || tok == token::MH_NBLOCKS || tok == token::MH_REPLIC || tok == token::MH_RECOVER || tok == token::POSTERIOR_MAX_SUBSAMPLE_DRAWS || tok == token::MIN || tok == token::MINIMAL_SOLVING_PERIODS || tok == token::MODE_CHECK || tok == token::MODE_CHECK_NEIGHBOURHOOD_SIZE || tok == token::MODE_CHECK_SYMMETRIC_PLOTS || tok == token::MODE_CHECK_NUMBER_OF_POINTS || tok == token::MODE_COMPUTE || tok == token::MODE_FILE || tok == token::MODEL || tok == token::MODEL_COMPARISON || tok == token::MODEL_INFO || tok == token::MSHOCKS || tok == token::ABS || tok == token::SIGN || tok == token::MODEL_DIAGNOSTICS || tok == token::MODIFIEDHARMONICMEAN || tok == token::MOMENTS_VARENDO || tok == token::CONTEMPORANEOUS_CORRELATION || tok == token::DIFFUSE_FILTER || tok == token::SUB_DRAWS || tok == token::TAPER_STEPS || tok == token::GEWEKE_INTERVAL || tok == token::RAFTERY_LEWIS_QRS || tok == token::RAFTERY_LEWIS_DIAGNOSTICS || tok == token::MCMC_JUMPING_COVARIANCE || tok == token::MOMENT_CALIBRATION || tok == token::NUMBER_OF_PARTICLES || tok == token::RESAMPLING || tok == token::SYSTEMATIC || tok == token::GENERIC || tok == token::RESAMPLING_THRESHOLD || tok == token::RESAMPLING_METHOD || tok == token::KITAGAWA || tok == token::STRATIFIED || tok == token::SMOOTH || tok == token::CPF_WEIGHTS || tok == token::AMISANOTRISTANI || tok == token::MURRAYJONESPARSLOW || tok == token::WRITE_EQUATION_TAGS || tok == token::NONLINEAR_FILTER_INITIALIZATION || tok == token::FILTER_ALGORITHM || tok == token::PROPOSAL_APPROXIMATION || tok == token::CUBATURE || tok == token::UNSCENTED || tok == token::MONTECARLO || tok == token::DISTRIBUTION_APPROXIMATION || tok == token::USE_PENALIZED_OBJECTIVE_FOR_HESSIAN || tok == token::INIT_STATE || tok == token::FAST_REALTIME || tok == token::RESCALE_PREDICTION_ERROR_COVARIANCE || tok == token::GENERATE_IRFS || tok == token::NAN_CONSTANT || tok == token::NO_STATIC || tok == token::NOBS || tok == token::NOCONSTANT || tok == token::NODISPLAY || tok == token::NOCORR || tok == token::NODIAGNOSTIC || tok == token::NOFUNCTIONS || tok == token::NO_HOMOTOPY || tok == token::NOGRAPH || tok == token::POSTERIOR_NOGRAPH || tok == token::POSTERIOR_GRAPH || tok == token::NOMOMENTS || tok == token::NOPRINT || tok == token::NORMAL_PDF || tok == token::SAVE_DRAWS || tok == token::MODEL_NAME || tok == token::STDERR_MULTIPLES || tok == token::DIAGONAL_ONLY || tok == token::OBSERVATION_TRENDS || tok == token::OPTIM || tok == token::OPTIM_WEIGHTS || tok == token::ORDER || tok == token::OSR || tok == token::OSR_PARAMS || tok == token::MAX_DIM_COVA_GROUP || tok == token::ADVANCED || tok == token::OUTFILE || tok == token::OUTVARS || tok == token::OVERWRITE || tok == token::DISCOUNT || tok == token::PARALLEL_LOCAL_FILES || tok == token::PARAMETERS || tok == token::PARAMETER_SET || tok == token::PARTIAL_INFORMATION || tok == token::PERIODS || tok == token::PERIOD || tok == token::PLANNER_OBJECTIVE || tok == token::PLOT_CONDITIONAL_FORECAST || tok == token::PLOT_PRIORS || tok == token::PREFILTER || tok == token::PRESAMPLE || tok == token::PERFECT_FORESIGHT_SETUP || tok == token::PERFECT_FORESIGHT_SOLVER || tok == token::NO_POSTERIOR_KERNEL_DENSITY || tok == token::FUNCTION || tok == token::PRINT || tok == token::PRIOR_MC || tok == token::PRIOR_TRUNC || tok == token::PRIOR_MODE || tok == token::PRIOR_MEAN || tok == token::POSTERIOR_MODE || tok == token::POSTERIOR_MEAN || tok == token::POSTERIOR_MEDIAN || tok == token::MLE_MODE || tok == token::PRUNING || tok == token::QZ_CRITERIUM || tok == token::QZ_ZERO_THRESHOLD || tok == token::DSGE_VAR || tok == token::DSGE_VARLAG || tok == token::DSGE_PRIOR_WEIGHT || tok == token::TRUNCATE || tok == token::PIPE_E || tok == token::PIPE_X || tok == token::PIPE_P || tok == token::RELATIVE_IRF || tok == token::REPLIC || tok == token::SIMUL_REPLIC || tok == token::RPLOT || tok == token::SAVE_PARAMS_AND_STEADY_STATE || tok == token::PARAMETER_UNCERTAINTY || tok == token::TARGETS || tok == token::SHOCKS || tok == token::SHOCK_DECOMPOSITION || tok == token::SHOCK_GROUPS || tok == token::USE_SHOCK_GROUPS || tok == token::SIGMA_E || tok == token::SIMUL || tok == token::SIMUL_ALGO || tok == token::SIMUL_SEED || tok == token::ENDOGENOUS_TERMINAL_PERIOD || tok == token::SMOOTHER || tok == token::SMOOTHER2HISTVAL || tok == token::SQUARE_ROOT_SOLVER || tok == token::STACK_SOLVE_ALGO || tok == token::STEADY_STATE_MODEL || tok == token::SOLVE_ALGO || tok == token::SOLVER_PERIODS || tok == token::ROBUST_LIN_SOLVE || tok == token::STDERR || tok == token::STEADY || tok == token::STOCH_SIMUL || tok == token::SYLVESTER || tok == token::SYLVESTER_FIXED_POINT_TOL || tok == token::REGIMES || tok == token::REGIME || tok == token::REALTIME_SHOCK_DECOMPOSITION || tok == token::CONDITIONAL || tok == token::UNCONDITIONAL || tok == token::TEX || tok == token::RAMSEY_MODEL || tok == token::RAMSEY_POLICY || tok == token::RAMSEY_CONSTRAINTS || tok == token::PLANNER_DISCOUNT || tok == token::PLANNER_DISCOUNT_LATEX_NAME || tok == token::DISCRETIONARY_POLICY || tok == token::DISCRETIONARY_TOL || tok == token::EVALUATE_PLANNER_OBJECTIVE || tok == token::UNIFORM_PDF || tok == token::UNIT_ROOT_VARS || tok == token::USE_DLL || tok == token::USEAUTOCORR || tok == token::GSA_SAMPLE_FILE || tok == token::USE_UNIVARIATE_FILTERS_IF_SINGULARITY_IS_DETECTED || tok == token::VALUES || tok == token::VAR || tok == token::VAREXO || tok == token::VAREXO_DET || tok == token::VARIABLE || tok == token::VAROBS || tok == token::VAREXOBS || tok == token::PREDETERMINED_VARIABLES || tok == token::VAR_EXPECTATION || tok == token::VAR_EXPECTATION_MODEL || tok == token::PLOT_SHOCK_DECOMPOSITION || tok == token::MODEL_LOCAL_VARIABLE || tok == token::WRITE_LATEX_DYNAMIC_MODEL || tok == token::WRITE_LATEX_STATIC_MODEL || tok == token::WRITE_LATEX_ORIGINAL_MODEL || tok == token::CROSSEQUATIONS || tok == token::COVARIANCE || tok == token::WRITE_LATEX_STEADY_STATE_MODEL || tok == token::XLS_SHEET || tok == token::XLS_RANGE || tok == token::LMMCP || tok == token::OCCBIN || tok == token::BANDPASS_FILTER || tok == token::COLORMAP || tok == token::VAR_MODEL || tok == token::PAC_MODEL || tok == token::QOQ || tok == token::YOY || tok == token::AOA || tok == token::PAC_EXPECTATION || tok == token::TREND_COMPONENT_MODEL || tok == token::EQUAL_EQUAL || tok == token::EXCLAMATION_EQUAL || tok == token::LESS || tok == token::GREATER || tok == token::LESS_EQUAL || tok == token::GREATER_EQUAL || tok == token::PLUS || tok == token::MINUS || tok == token::TIMES || tok == token::DIVIDE || tok == token::UNARY || tok == token::POWER || tok == token::EXP || tok == token::LOG || tok == token::LN || tok == token::LOG10 || tok == token::SIN || tok == token::COS || tok == token::TAN || tok == token::ASIN || tok == token::ACOS || tok == token::ATAN || tok == token::ERF || tok == token::DIFF || tok == token::ADL || tok == token::AUXILIARY_MODEL_NAME || tok == token::SQRT || tok == token::CBRT || tok == token::NORMCDF || tok == token::NORMPDF || tok == token::STEADY_STATE || tok == token::EXPECTATION || tok == token::VAR_ESTIMATION || tok == token::DYNARE_SENSITIVITY || tok == token::MORRIS || tok == token::STAB || tok == token::REDFORM || tok == token::PPRIOR || tok == token::PRIOR_RANGE || tok == token::PPOST || tok == token::ILPTAU || tok == token::MORRIS_NLIV || tok == token::MORRIS_NTRA || tok == token::NSAM || tok == token::LOAD_REDFORM || tok == token::LOAD_RMSE || tok == token::LOAD_STAB || tok == token::ALPHA2_STAB || tok == token::LOGTRANS_REDFORM || tok == token::THRESHOLD_REDFORM || tok == token::KSSTAT_REDFORM || tok == token::ALPHA2_REDFORM || tok == token::NAMENDO || tok == token::NAMLAGENDO || tok == token::NAMEXO || tok == token::RMSE || tok == token::LIK_ONLY || tok == token::VAR_RMSE || tok == token::PFILT_RMSE || tok == token::ISTART_RMSE || tok == token::ALPHA_RMSE || tok == token::ALPHA2_RMSE || tok == token::FREQ || tok == token::INITIAL_YEAR || tok == token::INITIAL_SUBPERIOD || tok == token::FINAL_YEAR || tok == token::FINAL_SUBPERIOD || tok == token::DATA || tok == token::VLIST || tok == token::VLISTLOG || tok == token::VLISTPER || tok == token::SPECTRAL_DENSITY || tok == token::INIT2SHOCKS || tok == token::RESTRICTION || tok == token::RESTRICTION_FNAME || tok == token::CROSS_RESTRICTIONS || tok == token::NLAGS || tok == token::CONTEMP_REDUCED_FORM || tok == token::REAL_PSEUDO_FORECAST || tok == token::DUMMY_OBS || tok == token::NSTATES || tok == token::INDXSCALESSTATES || tok == token::NO_BAYESIAN_PRIOR || tok == token::SPECIFICATION || tok == token::SIMS_ZHA || tok == token::GSIG2_LMDM || tok == token::Q_DIAG || tok == token::FLAT_PRIOR || tok == token::NCSK || tok == token::NSTD || tok == token::WEIBULL || tok == token::WEIBULL_PDF || tok == token::INDXPARR || tok == token::INDXOVR || tok == token::INDXAP || tok == token::APBAND || tok == token::INDXIMF || tok == token::INDXFORE || tok == token::FOREBAND || tok == token::INDXGFOREHAT || tok == token::INDXGIMFHAT || tok == token::INDXESTIMA || tok == token::INDXGDLS || tok == token::EQ_MS || tok == token::FILTER_COVARIANCE || tok == token::FILTER_DECOMPOSITION || tok == token::SMOOTHED_STATE_UNCERTAINTY || tok == token::EQ_CMS || tok == token::TLINDX || tok == token::TLNUMBER || tok == token::RESTRICTIONS || tok == token::POSTERIOR_SAMPLER_OPTIONS || tok == token::OUTPUT_FILE_TAG || tok == token::HORIZON || tok == token::SBVAR || tok == token::TREND_VAR || tok == token::DEFLATOR || tok == token::GROWTH_FACTOR || tok == token::MS_IRF || tok == token::MS_VARIANCE_DECOMPOSITION || tok == token::GROWTH || tok == token::MS_ESTIMATION || tok == token::MS_SIMULATION || tok == token::MS_COMPUTE_MDD || tok == token::MS_COMPUTE_PROBABILITIES || tok == token::MS_FORECAST || tok == token::SVAR_IDENTIFICATION || tok == token::EQUATION || tok == token::EXCLUSION || tok == token::LAG || tok == token::UPPER_CHOLESKY || tok == token::LOWER_CHOLESKY || tok == token::MONTHLY || tok == token::QUARTERLY || tok == token::MARKOV_SWITCHING || tok == token::CHAIN || tok == token::DURATION || tok == token::NUMBER_OF_REGIMES || tok == token::NUMBER_OF_LAGS || tok == token::EPILOGUE || tok == token::SVAR || tok == token::SVAR_GLOBAL_IDENTIFICATION_CHECK || tok == token::COEFF || tok == token::COEFFICIENTS || tok == token::VARIANCES || tok == token::CONSTANTS || tok == token::EQUATIONS || tok == token::EXTERNAL_FUNCTION || tok == token::EXT_FUNC_NAME || tok == token::EXT_FUNC_NARGS || tok == token::FIRST_DERIV_PROVIDED || tok == token::SECOND_DERIV_PROVIDED || tok == token::SELECTED_VARIABLES_ONLY || tok == token::COVA_COMPUTE || tok == token::SIMULATION_FILE_TAG || tok == token::FILE_TAG || tok == token::NO_ERROR_BANDS || tok == token::ERROR_BAND_PERCENTILES || tok == token::SHOCKS_PER_PARAMETER || tok == token::NO_CREATE_INIT || tok == token::SHOCK_DRAWS || tok == token::FREE_PARAMETERS || tok == token::MEDIAN || tok == token::DATA_OBS_NBR || tok == token::NEIGHBORHOOD_WIDTH || tok == token::PVALUE_KS || tok == token::PVALUE_CORR || tok == token::FILTERED_PROBABILITIES || tok == token::REAL_TIME_SMOOTHED || tok == token::PRIOR_FUNCTION || tok == token::POSTERIOR_FUNCTION || tok == token::SAMPLING_DRAWS || tok == token::PROPOSAL_TYPE || tok == token::PROPOSAL_UPPER_BOUND || tok == token::PROPOSAL_LOWER_BOUND || tok == token::PROPOSAL_DRAWS || tok == token::USE_MEAN_CENTER || tok == token::ADAPTIVE_MH_DRAWS || tok == token::THINNING_FACTOR || tok == token::COEFFICIENTS_PRIOR_HYPERPARAMETERS || tok == token::SMM_ESTIMATION || tok == token::GMM_ESTIMATION || tok == token::CONVERGENCE_STARTING_VALUE || tok == token::CONVERGENCE_ENDING_VALUE || tok == token::CONVERGENCE_INCREMENT_VALUE || tok == token::MAX_ITERATIONS_STARTING_VALUE || tok == token::MAX_ITERATIONS_INCREMENT_VALUE || tok == token::MAX_BLOCK_ITERATIONS || tok == token::MAX_REPEATED_OPTIMIZATION_RUNS || tok == token::FUNCTION_CONVERGENCE_CRITERION || tok == token::SAVE_REALTIME || tok == token::PARAMETER_CONVERGENCE_CRITERION || tok == token::NUMBER_OF_LARGE_PERTURBATIONS || tok == token::NUMBER_OF_SMALL_PERTURBATIONS || tok == token::NUMBER_OF_POSTERIOR_DRAWS_AFTER_PERTURBATION || tok == token::MAX_NUMBER_OF_STAGES || tok == token::RANDOM_FUNCTION_CONVERGENCE_CRITERION || tok == token::RANDOM_PARAMETER_CONVERGENCE_CRITERION || tok == token::CENTERED_MOMENTS || tok == token::AUTOLAG || tok == token::RECURSIVE_ORDER_ESTIMATION || tok == token::BARTLETT_KERNEL_LAG || tok == token::WEIGHTING_MATRIX || tok == token::PENALIZED_ESTIMATOR || tok == token::VERBOSE || tok == token::SIMULATION_MULTIPLE || tok == token::SEED || tok == token::BOUNDED_SHOCK_SUPPORT || tok == token::EQTAGS || tok == token::STEADY_STATE_GROWTH || tok == token::ANALYTICAL_GIRF || tok == token::IRF_IN_PERCENT || tok == token::EMAS_GIRF || tok == token::EMAS_DROP || tok == token::EMAS_TOLF || tok == token::EMAS_MAX_ITER || tok == token::NO_IDENTIFICATION_STRENGTH || tok == token::NO_IDENTIFICATION_REDUCEDFORM || tok == token::NO_IDENTIFICATION_MOMENTS || tok == token::NO_IDENTIFICATION_MINIMAL || tok == token::NO_IDENTIFICATION_SPECTRUM || tok == token::NORMALIZE_JACOBIANS || tok == token::GRID_NBR || tok == token::TOL_RANK || tok == token::TOL_DERIV || tok == token::TOL_SV || tok == token::CHECKS_VIA_SUBSETS || tok == token::MAX_DIM_SUBSETS_GROUPS || tok == token::MAX_NROWS || tok == token::SQUEEZE_SHOCK_DECOMPOSITION || tok == token::WITH_EPILOGUE || tok == 59 || tok == 40 || tok == 41 || tok == 91 || tok == 93 || tok == 35 || tok == 58 || tok == 46);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      symbol_type (int tok, string v, location_type l)
        : super_type(token_type (tok), std::move (v), std::move (l))
      {
        YYASSERT (tok == token::FLOAT_NUMBER || tok == token::DATES || tok == token::INT_NUMBER || tok == token::NAME || tok == token::QUOTED_STRING || tok == token::TEX_NAME || tok == token::ALPHA || tok == token::BETA || tok == token::ABAND || tok == token::NINV || tok == token::CMS || tok == token::NCMS || tok == token::CNUM || tok == token::GAMMA || tok == token::INV_GAMMA || tok == token::INV_GAMMA1 || tok == token::INV_GAMMA2 || tok == token::NORMAL || tok == token::UNIFORM || tok == token::EPS || tok == token::PDF || tok == token::FIG || tok == token::DR || tok == token::NONE || tok == token::PRIOR || tok == token::PRIOR_VARIANCE || tok == token::HESSIAN || tok == token::IDENTITY_MATRIX || tok == token::DIRICHLET || tok == token::DIAGONAL || tok == token::OPTIMAL);
      }
#else
      symbol_type (int tok, const string& v, const location_type& l)
        : super_type(token_type (tok), v, l)
      {
        YYASSERT (tok == token::FLOAT_NUMBER || tok == token::DATES || tok == token::INT_NUMBER || tok == token::NAME || tok == token::QUOTED_STRING || tok == token::TEX_NAME || tok == token::ALPHA || tok == token::BETA || tok == token::ABAND || tok == token::NINV || tok == token::CMS || tok == token::NCMS || tok == token::CNUM || tok == token::GAMMA || tok == token::INV_GAMMA || tok == token::INV_GAMMA1 || tok == token::INV_GAMMA2 || tok == token::NORMAL || tok == token::UNIFORM || tok == token::EPS || tok == token::PDF || tok == token::FIG || tok == token::DR || tok == token::NONE || tok == token::PRIOR || tok == token::PRIOR_VARIANCE || tok == token::HESSIAN || tok == token::IDENTITY_MATRIX || tok == token::DIRICHLET || tok == token::DIAGONAL || tok == token::OPTIMAL);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      symbol_type (int tok, vector<string> v, location_type l)
        : super_type(token_type (tok), std::move (v), std::move (l))
      {
        YYASSERT (tok == token::SYMBOL_VEC);
      }
#else
      symbol_type (int tok, const vector<string>& v, const location_type& l)
        : super_type(token_type (tok), v, l)
      {
        YYASSERT (tok == token::SYMBOL_VEC);
      }
#endif
    };

    /// Build a parser object.
    parser (ParsingDriver &driver_yyarg);
    virtual ~parser ();

    /// Parse.  An alias for parse ().
    /// \returns  0 iff parsing succeeded.
    int operator() ();

    /// Parse.
    /// \returns  0 iff parsing succeeded.
    virtual int parse ();

#if YYDEBUG
    /// The current debugging stream.
    std::ostream& debug_stream () const YY_ATTRIBUTE_PURE;
    /// Set the current debugging stream.
    void set_debug_stream (std::ostream &);

    /// Type for debugging levels.
    typedef int debug_level_type;
    /// The current debugging level.
    debug_level_type debug_level () const YY_ATTRIBUTE_PURE;
    /// Set the current debugging level.
    void set_debug_level (debug_level_type l);
#endif

    /// Report a syntax error.
    /// \param loc    where the syntax error is found.
    /// \param msg    a description of the syntax error.
    virtual void error (const location_type& loc, const std::string& msg);

    /// Report a syntax error.
    void error (const syntax_error& err);

    // Implementation of make_symbol for each symbol type.
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_AIM_SOLVER (location_type l)
      {
        return symbol_type (token::AIM_SOLVER, std::move (l));
      }
#else
      static
      symbol_type
      make_AIM_SOLVER (const location_type& l)
      {
        return symbol_type (token::AIM_SOLVER, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_ANALYTIC_DERIVATION (location_type l)
      {
        return symbol_type (token::ANALYTIC_DERIVATION, std::move (l));
      }
#else
      static
      symbol_type
      make_ANALYTIC_DERIVATION (const location_type& l)
      {
        return symbol_type (token::ANALYTIC_DERIVATION, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_ANALYTIC_DERIVATION_MODE (location_type l)
      {
        return symbol_type (token::ANALYTIC_DERIVATION_MODE, std::move (l));
      }
#else
      static
      symbol_type
      make_ANALYTIC_DERIVATION_MODE (const location_type& l)
      {
        return symbol_type (token::ANALYTIC_DERIVATION_MODE, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_AR (location_type l)
      {
        return symbol_type (token::AR, std::move (l));
      }
#else
      static
      symbol_type
      make_AR (const location_type& l)
      {
        return symbol_type (token::AR, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_POSTERIOR_SAMPLING_METHOD (location_type l)
      {
        return symbol_type (token::POSTERIOR_SAMPLING_METHOD, std::move (l));
      }
#else
      static
      symbol_type
      make_POSTERIOR_SAMPLING_METHOD (const location_type& l)
      {
        return symbol_type (token::POSTERIOR_SAMPLING_METHOD, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_BALANCED_GROWTH_TEST_TOL (location_type l)
      {
        return symbol_type (token::BALANCED_GROWTH_TEST_TOL, std::move (l));
      }
#else
      static
      symbol_type
      make_BALANCED_GROWTH_TEST_TOL (const location_type& l)
      {
        return symbol_type (token::BALANCED_GROWTH_TEST_TOL, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_BAYESIAN_IRF (location_type l)
      {
        return symbol_type (token::BAYESIAN_IRF, std::move (l));
      }
#else
      static
      symbol_type
      make_BAYESIAN_IRF (const location_type& l)
      {
        return symbol_type (token::BAYESIAN_IRF, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_BETA_PDF (location_type l)
      {
        return symbol_type (token::BETA_PDF, std::move (l));
      }
#else
      static
      symbol_type
      make_BETA_PDF (const location_type& l)
      {
        return symbol_type (token::BETA_PDF, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_BLOCK (location_type l)
      {
        return symbol_type (token::BLOCK, std::move (l));
      }
#else
      static
      symbol_type
      make_BLOCK (const location_type& l)
      {
        return symbol_type (token::BLOCK, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_USE_CALIBRATION (location_type l)
      {
        return symbol_type (token::USE_CALIBRATION, std::move (l));
      }
#else
      static
      symbol_type
      make_USE_CALIBRATION (const location_type& l)
      {
        return symbol_type (token::USE_CALIBRATION, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_SILENT_OPTIMIZER (location_type l)
      {
        return symbol_type (token::SILENT_OPTIMIZER, std::move (l));
      }
#else
      static
      symbol_type
      make_SILENT_OPTIMIZER (const location_type& l)
      {
        return symbol_type (token::SILENT_OPTIMIZER, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_BVAR_DENSITY (location_type l)
      {
        return symbol_type (token::BVAR_DENSITY, std::move (l));
      }
#else
      static
      symbol_type
      make_BVAR_DENSITY (const location_type& l)
      {
        return symbol_type (token::BVAR_DENSITY, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_BVAR_FORECAST (location_type l)
      {
        return symbol_type (token::BVAR_FORECAST, std::move (l));
      }
#else
      static
      symbol_type
      make_BVAR_FORECAST (const location_type& l)
      {
        return symbol_type (token::BVAR_FORECAST, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_NODECOMPOSITION (location_type l)
      {
        return symbol_type (token::NODECOMPOSITION, std::move (l));
      }
#else
      static
      symbol_type
      make_NODECOMPOSITION (const location_type& l)
      {
        return symbol_type (token::NODECOMPOSITION, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_DR_DISPLAY_TOL (location_type l)
      {
        return symbol_type (token::DR_DISPLAY_TOL, std::move (l));
      }
#else
      static
      symbol_type
      make_DR_DISPLAY_TOL (const location_type& l)
      {
        return symbol_type (token::DR_DISPLAY_TOL, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_HUGE_NUMBER (location_type l)
      {
        return symbol_type (token::HUGE_NUMBER, std::move (l));
      }
#else
      static
      symbol_type
      make_HUGE_NUMBER (const location_type& l)
      {
        return symbol_type (token::HUGE_NUMBER, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_FIG_NAME (location_type l)
      {
        return symbol_type (token::FIG_NAME, std::move (l));
      }
#else
      static
      symbol_type
      make_FIG_NAME (const location_type& l)
      {
        return symbol_type (token::FIG_NAME, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_WRITE_XLS (location_type l)
      {
        return symbol_type (token::WRITE_XLS, std::move (l));
      }
#else
      static
      symbol_type
      make_WRITE_XLS (const location_type& l)
      {
        return symbol_type (token::WRITE_XLS, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_BVAR_PRIOR_DECAY (location_type l)
      {
        return symbol_type (token::BVAR_PRIOR_DECAY, std::move (l));
      }
#else
      static
      symbol_type
      make_BVAR_PRIOR_DECAY (const location_type& l)
      {
        return symbol_type (token::BVAR_PRIOR_DECAY, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_BVAR_PRIOR_FLAT (location_type l)
      {
        return symbol_type (token::BVAR_PRIOR_FLAT, std::move (l));
      }
#else
      static
      symbol_type
      make_BVAR_PRIOR_FLAT (const location_type& l)
      {
        return symbol_type (token::BVAR_PRIOR_FLAT, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_BVAR_PRIOR_LAMBDA (location_type l)
      {
        return symbol_type (token::BVAR_PRIOR_LAMBDA, std::move (l));
      }
#else
      static
      symbol_type
      make_BVAR_PRIOR_LAMBDA (const location_type& l)
      {
        return symbol_type (token::BVAR_PRIOR_LAMBDA, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_INTERACTIVE (location_type l)
      {
        return symbol_type (token::INTERACTIVE, std::move (l));
      }
#else
      static
      symbol_type
      make_INTERACTIVE (const location_type& l)
      {
        return symbol_type (token::INTERACTIVE, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_SCREEN_SHOCKS (location_type l)
      {
        return symbol_type (token::SCREEN_SHOCKS, std::move (l));
      }
#else
      static
      symbol_type
      make_SCREEN_SHOCKS (const location_type& l)
      {
        return symbol_type (token::SCREEN_SHOCKS, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_STEADYSTATE (location_type l)
      {
        return symbol_type (token::STEADYSTATE, std::move (l));
      }
#else
      static
      symbol_type
      make_STEADYSTATE (const location_type& l)
      {
        return symbol_type (token::STEADYSTATE, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_BVAR_PRIOR_MU (location_type l)
      {
        return symbol_type (token::BVAR_PRIOR_MU, std::move (l));
      }
#else
      static
      symbol_type
      make_BVAR_PRIOR_MU (const location_type& l)
      {
        return symbol_type (token::BVAR_PRIOR_MU, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_BVAR_PRIOR_OMEGA (location_type l)
      {
        return symbol_type (token::BVAR_PRIOR_OMEGA, std::move (l));
      }
#else
      static
      symbol_type
      make_BVAR_PRIOR_OMEGA (const location_type& l)
      {
        return symbol_type (token::BVAR_PRIOR_OMEGA, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_BVAR_PRIOR_TAU (location_type l)
      {
        return symbol_type (token::BVAR_PRIOR_TAU, std::move (l));
      }
#else
      static
      symbol_type
      make_BVAR_PRIOR_TAU (const location_type& l)
      {
        return symbol_type (token::BVAR_PRIOR_TAU, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_BVAR_PRIOR_TRAIN (location_type l)
      {
        return symbol_type (token::BVAR_PRIOR_TRAIN, std::move (l));
      }
#else
      static
      symbol_type
      make_BVAR_PRIOR_TRAIN (const location_type& l)
      {
        return symbol_type (token::BVAR_PRIOR_TRAIN, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_DETAIL_PLOT (location_type l)
      {
        return symbol_type (token::DETAIL_PLOT, std::move (l));
      }
#else
      static
      symbol_type
      make_DETAIL_PLOT (const location_type& l)
      {
        return symbol_type (token::DETAIL_PLOT, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_TYPE (location_type l)
      {
        return symbol_type (token::TYPE, std::move (l));
      }
#else
      static
      symbol_type
      make_TYPE (const location_type& l)
      {
        return symbol_type (token::TYPE, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_BVAR_REPLIC (location_type l)
      {
        return symbol_type (token::BVAR_REPLIC, std::move (l));
      }
#else
      static
      symbol_type
      make_BVAR_REPLIC (const location_type& l)
      {
        return symbol_type (token::BVAR_REPLIC, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_BYTECODE (location_type l)
      {
        return symbol_type (token::BYTECODE, std::move (l));
      }
#else
      static
      symbol_type
      make_BYTECODE (const location_type& l)
      {
        return symbol_type (token::BYTECODE, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_ALL_VALUES_REQUIRED (location_type l)
      {
        return symbol_type (token::ALL_VALUES_REQUIRED, std::move (l));
      }
#else
      static
      symbol_type
      make_ALL_VALUES_REQUIRED (const location_type& l)
      {
        return symbol_type (token::ALL_VALUES_REQUIRED, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_PROPOSAL_DISTRIBUTION (location_type l)
      {
        return symbol_type (token::PROPOSAL_DISTRIBUTION, std::move (l));
      }
#else
      static
      symbol_type
      make_PROPOSAL_DISTRIBUTION (const location_type& l)
      {
        return symbol_type (token::PROPOSAL_DISTRIBUTION, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_REALTIME (location_type l)
      {
        return symbol_type (token::REALTIME, std::move (l));
      }
#else
      static
      symbol_type
      make_REALTIME (const location_type& l)
      {
        return symbol_type (token::REALTIME, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_VINTAGE (location_type l)
      {
        return symbol_type (token::VINTAGE, std::move (l));
      }
#else
      static
      symbol_type
      make_VINTAGE (const location_type& l)
      {
        return symbol_type (token::VINTAGE, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_CALIB_SMOOTHER (location_type l)
      {
        return symbol_type (token::CALIB_SMOOTHER, std::move (l));
      }
#else
      static
      symbol_type
      make_CALIB_SMOOTHER (const location_type& l)
      {
        return symbol_type (token::CALIB_SMOOTHER, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_CHANGE_TYPE (location_type l)
      {
        return symbol_type (token::CHANGE_TYPE, std::move (l));
      }
#else
      static
      symbol_type
      make_CHANGE_TYPE (const location_type& l)
      {
        return symbol_type (token::CHANGE_TYPE, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_CHECK (location_type l)
      {
        return symbol_type (token::CHECK, std::move (l));
      }
#else
      static
      symbol_type
      make_CHECK (const location_type& l)
      {
        return symbol_type (token::CHECK, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_CONDITIONAL_FORECAST (location_type l)
      {
        return symbol_type (token::CONDITIONAL_FORECAST, std::move (l));
      }
#else
      static
      symbol_type
      make_CONDITIONAL_FORECAST (const location_type& l)
      {
        return symbol_type (token::CONDITIONAL_FORECAST, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_CONDITIONAL_FORECAST_PATHS (location_type l)
      {
        return symbol_type (token::CONDITIONAL_FORECAST_PATHS, std::move (l));
      }
#else
      static
      symbol_type
      make_CONDITIONAL_FORECAST_PATHS (const location_type& l)
      {
        return symbol_type (token::CONDITIONAL_FORECAST_PATHS, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_CONF_SIG (location_type l)
      {
        return symbol_type (token::CONF_SIG, std::move (l));
      }
#else
      static
      symbol_type
      make_CONF_SIG (const location_type& l)
      {
        return symbol_type (token::CONF_SIG, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_CONSTANT (location_type l)
      {
        return symbol_type (token::CONSTANT, std::move (l));
      }
#else
      static
      symbol_type
      make_CONSTANT (const location_type& l)
      {
        return symbol_type (token::CONSTANT, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_CONTROLLED_VAREXO (location_type l)
      {
        return symbol_type (token::CONTROLLED_VAREXO, std::move (l));
      }
#else
      static
      symbol_type
      make_CONTROLLED_VAREXO (const location_type& l)
      {
        return symbol_type (token::CONTROLLED_VAREXO, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_CORR (location_type l)
      {
        return symbol_type (token::CORR, std::move (l));
      }
#else
      static
      symbol_type
      make_CORR (const location_type& l)
      {
        return symbol_type (token::CORR, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_CUTOFF (location_type l)
      {
        return symbol_type (token::CUTOFF, std::move (l));
      }
#else
      static
      symbol_type
      make_CUTOFF (const location_type& l)
      {
        return symbol_type (token::CUTOFF, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_CYCLE_REDUCTION (location_type l)
      {
        return symbol_type (token::CYCLE_REDUCTION, std::move (l));
      }
#else
      static
      symbol_type
      make_CYCLE_REDUCTION (const location_type& l)
      {
        return symbol_type (token::CYCLE_REDUCTION, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_LOGARITHMIC_REDUCTION (location_type l)
      {
        return symbol_type (token::LOGARITHMIC_REDUCTION, std::move (l));
      }
#else
      static
      symbol_type
      make_LOGARITHMIC_REDUCTION (const location_type& l)
      {
        return symbol_type (token::LOGARITHMIC_REDUCTION, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_COMMA (location_type l)
      {
        return symbol_type (token::COMMA, std::move (l));
      }
#else
      static
      symbol_type
      make_COMMA (const location_type& l)
      {
        return symbol_type (token::COMMA, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_CONSIDER_ALL_ENDOGENOUS (location_type l)
      {
        return symbol_type (token::CONSIDER_ALL_ENDOGENOUS, std::move (l));
      }
#else
      static
      symbol_type
      make_CONSIDER_ALL_ENDOGENOUS (const location_type& l)
      {
        return symbol_type (token::CONSIDER_ALL_ENDOGENOUS, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_CONSIDER_ONLY_OBSERVED (location_type l)
      {
        return symbol_type (token::CONSIDER_ONLY_OBSERVED, std::move (l));
      }
#else
      static
      symbol_type
      make_CONSIDER_ONLY_OBSERVED (const location_type& l)
      {
        return symbol_type (token::CONSIDER_ONLY_OBSERVED, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_INITIAL_CONDITION_DECOMPOSITION (location_type l)
      {
        return symbol_type (token::INITIAL_CONDITION_DECOMPOSITION, std::move (l));
      }
#else
      static
      symbol_type
      make_INITIAL_CONDITION_DECOMPOSITION (const location_type& l)
      {
        return symbol_type (token::INITIAL_CONDITION_DECOMPOSITION, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_DATAFILE (location_type l)
      {
        return symbol_type (token::DATAFILE, std::move (l));
      }
#else
      static
      symbol_type
      make_DATAFILE (const location_type& l)
      {
        return symbol_type (token::DATAFILE, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_FILE (location_type l)
      {
        return symbol_type (token::FILE, std::move (l));
      }
#else
      static
      symbol_type
      make_FILE (const location_type& l)
      {
        return symbol_type (token::FILE, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_SERIES (location_type l)
      {
        return symbol_type (token::SERIES, std::move (l));
      }
#else
      static
      symbol_type
      make_SERIES (const location_type& l)
      {
        return symbol_type (token::SERIES, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_DOUBLING (location_type l)
      {
        return symbol_type (token::DOUBLING, std::move (l));
      }
#else
      static
      symbol_type
      make_DOUBLING (const location_type& l)
      {
        return symbol_type (token::DOUBLING, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_DR_CYCLE_REDUCTION_TOL (location_type l)
      {
        return symbol_type (token::DR_CYCLE_REDUCTION_TOL, std::move (l));
      }
#else
      static
      symbol_type
      make_DR_CYCLE_REDUCTION_TOL (const location_type& l)
      {
        return symbol_type (token::DR_CYCLE_REDUCTION_TOL, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_DR_LOGARITHMIC_REDUCTION_TOL (location_type l)
      {
        return symbol_type (token::DR_LOGARITHMIC_REDUCTION_TOL, std::move (l));
      }
#else
      static
      symbol_type
      make_DR_LOGARITHMIC_REDUCTION_TOL (const location_type& l)
      {
        return symbol_type (token::DR_LOGARITHMIC_REDUCTION_TOL, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_DR_LOGARITHMIC_REDUCTION_MAXITER (location_type l)
      {
        return symbol_type (token::DR_LOGARITHMIC_REDUCTION_MAXITER, std::move (l));
      }
#else
      static
      symbol_type
      make_DR_LOGARITHMIC_REDUCTION_MAXITER (const location_type& l)
      {
        return symbol_type (token::DR_LOGARITHMIC_REDUCTION_MAXITER, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_DR_ALGO (location_type l)
      {
        return symbol_type (token::DR_ALGO, std::move (l));
      }
#else
      static
      symbol_type
      make_DR_ALGO (const location_type& l)
      {
        return symbol_type (token::DR_ALGO, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_DROP (location_type l)
      {
        return symbol_type (token::DROP, std::move (l));
      }
#else
      static
      symbol_type
      make_DROP (const location_type& l)
      {
        return symbol_type (token::DROP, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_DSAMPLE (location_type l)
      {
        return symbol_type (token::DSAMPLE, std::move (l));
      }
#else
      static
      symbol_type
      make_DSAMPLE (const location_type& l)
      {
        return symbol_type (token::DSAMPLE, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_DYNASAVE (location_type l)
      {
        return symbol_type (token::DYNASAVE, std::move (l));
      }
#else
      static
      symbol_type
      make_DYNASAVE (const location_type& l)
      {
        return symbol_type (token::DYNASAVE, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_DYNATYPE (location_type l)
      {
        return symbol_type (token::DYNATYPE, std::move (l));
      }
#else
      static
      symbol_type
      make_DYNATYPE (const location_type& l)
      {
        return symbol_type (token::DYNATYPE, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_CALIBRATION (location_type l)
      {
        return symbol_type (token::CALIBRATION, std::move (l));
      }
#else
      static
      symbol_type
      make_CALIBRATION (const location_type& l)
      {
        return symbol_type (token::CALIBRATION, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_DIFFERENTIATE_FORWARD_VARS (location_type l)
      {
        return symbol_type (token::DIFFERENTIATE_FORWARD_VARS, std::move (l));
      }
#else
      static
      symbol_type
      make_DIFFERENTIATE_FORWARD_VARS (const location_type& l)
      {
        return symbol_type (token::DIFFERENTIATE_FORWARD_VARS, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_END (location_type l)
      {
        return symbol_type (token::END, std::move (l));
      }
#else
      static
      symbol_type
      make_END (const location_type& l)
      {
        return symbol_type (token::END, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_ENDVAL (location_type l)
      {
        return symbol_type (token::ENDVAL, std::move (l));
      }
#else
      static
      symbol_type
      make_ENDVAL (const location_type& l)
      {
        return symbol_type (token::ENDVAL, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_EQUAL (location_type l)
      {
        return symbol_type (token::EQUAL, std::move (l));
      }
#else
      static
      symbol_type
      make_EQUAL (const location_type& l)
      {
        return symbol_type (token::EQUAL, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_ESTIMATION (location_type l)
      {
        return symbol_type (token::ESTIMATION, std::move (l));
      }
#else
      static
      symbol_type
      make_ESTIMATION (const location_type& l)
      {
        return symbol_type (token::ESTIMATION, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_ESTIMATED_PARAMS (location_type l)
      {
        return symbol_type (token::ESTIMATED_PARAMS, std::move (l));
      }
#else
      static
      symbol_type
      make_ESTIMATED_PARAMS (const location_type& l)
      {
        return symbol_type (token::ESTIMATED_PARAMS, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_ESTIMATED_PARAMS_BOUNDS (location_type l)
      {
        return symbol_type (token::ESTIMATED_PARAMS_BOUNDS, std::move (l));
      }
#else
      static
      symbol_type
      make_ESTIMATED_PARAMS_BOUNDS (const location_type& l)
      {
        return symbol_type (token::ESTIMATED_PARAMS_BOUNDS, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_ESTIMATED_PARAMS_INIT (location_type l)
      {
        return symbol_type (token::ESTIMATED_PARAMS_INIT, std::move (l));
      }
#else
      static
      symbol_type
      make_ESTIMATED_PARAMS_INIT (const location_type& l)
      {
        return symbol_type (token::ESTIMATED_PARAMS_INIT, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_EXTENDED_PATH (location_type l)
      {
        return symbol_type (token::EXTENDED_PATH, std::move (l));
      }
#else
      static
      symbol_type
      make_EXTENDED_PATH (const location_type& l)
      {
        return symbol_type (token::EXTENDED_PATH, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_ENDOGENOUS_PRIOR (location_type l)
      {
        return symbol_type (token::ENDOGENOUS_PRIOR, std::move (l));
      }
#else
      static
      symbol_type
      make_ENDOGENOUS_PRIOR (const location_type& l)
      {
        return symbol_type (token::ENDOGENOUS_PRIOR, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_EXPRESSION (location_type l)
      {
        return symbol_type (token::EXPRESSION, std::move (l));
      }
#else
      static
      symbol_type
      make_EXPRESSION (const location_type& l)
      {
        return symbol_type (token::EXPRESSION, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_FILENAME (location_type l)
      {
        return symbol_type (token::FILENAME, std::move (l));
      }
#else
      static
      symbol_type
      make_FILENAME (const location_type& l)
      {
        return symbol_type (token::FILENAME, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_DIRNAME (location_type l)
      {
        return symbol_type (token::DIRNAME, std::move (l));
      }
#else
      static
      symbol_type
      make_DIRNAME (const location_type& l)
      {
        return symbol_type (token::DIRNAME, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_FILTER_STEP_AHEAD (location_type l)
      {
        return symbol_type (token::FILTER_STEP_AHEAD, std::move (l));
      }
#else
      static
      symbol_type
      make_FILTER_STEP_AHEAD (const location_type& l)
      {
        return symbol_type (token::FILTER_STEP_AHEAD, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_FILTERED_VARS (location_type l)
      {
        return symbol_type (token::FILTERED_VARS, std::move (l));
      }
#else
      static
      symbol_type
      make_FILTERED_VARS (const location_type& l)
      {
        return symbol_type (token::FILTERED_VARS, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_FIRST_OBS (location_type l)
      {
        return symbol_type (token::FIRST_OBS, std::move (l));
      }
#else
      static
      symbol_type
      make_FIRST_OBS (const location_type& l)
      {
        return symbol_type (token::FIRST_OBS, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_LAST_OBS (location_type l)
      {
        return symbol_type (token::LAST_OBS, std::move (l));
      }
#else
      static
      symbol_type
      make_LAST_OBS (const location_type& l)
      {
        return symbol_type (token::LAST_OBS, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_SET_TIME (location_type l)
      {
        return symbol_type (token::SET_TIME, std::move (l));
      }
#else
      static
      symbol_type
      make_SET_TIME (const location_type& l)
      {
        return symbol_type (token::SET_TIME, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_OSR_PARAMS_BOUNDS (location_type l)
      {
        return symbol_type (token::OSR_PARAMS_BOUNDS, std::move (l));
      }
#else
      static
      symbol_type
      make_OSR_PARAMS_BOUNDS (const location_type& l)
      {
        return symbol_type (token::OSR_PARAMS_BOUNDS, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_KEEP_KALMAN_ALGO_IF_SINGULARITY_IS_DETECTED (location_type l)
      {
        return symbol_type (token::KEEP_KALMAN_ALGO_IF_SINGULARITY_IS_DETECTED, std::move (l));
      }
#else
      static
      symbol_type
      make_KEEP_KALMAN_ALGO_IF_SINGULARITY_IS_DETECTED (const location_type& l)
      {
        return symbol_type (token::KEEP_KALMAN_ALGO_IF_SINGULARITY_IS_DETECTED, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_FLOAT_NUMBER (string v, location_type l)
      {
        return symbol_type (token::FLOAT_NUMBER, std::move (v), std::move (l));
      }
#else
      static
      symbol_type
      make_FLOAT_NUMBER (const string& v, const location_type& l)
      {
        return symbol_type (token::FLOAT_NUMBER, v, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_DATES (string v, location_type l)
      {
        return symbol_type (token::DATES, std::move (v), std::move (l));
      }
#else
      static
      symbol_type
      make_DATES (const string& v, const location_type& l)
      {
        return symbol_type (token::DATES, v, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_DEFAULT (location_type l)
      {
        return symbol_type (token::DEFAULT, std::move (l));
      }
#else
      static
      symbol_type
      make_DEFAULT (const location_type& l)
      {
        return symbol_type (token::DEFAULT, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_FIXED_POINT (location_type l)
      {
        return symbol_type (token::FIXED_POINT, std::move (l));
      }
#else
      static
      symbol_type
      make_FIXED_POINT (const location_type& l)
      {
        return symbol_type (token::FIXED_POINT, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_FLIP (location_type l)
      {
        return symbol_type (token::FLIP, std::move (l));
      }
#else
      static
      symbol_type
      make_FLIP (const location_type& l)
      {
        return symbol_type (token::FLIP, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_OPT_ALGO (location_type l)
      {
        return symbol_type (token::OPT_ALGO, std::move (l));
      }
#else
      static
      symbol_type
      make_OPT_ALGO (const location_type& l)
      {
        return symbol_type (token::OPT_ALGO, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_COMPILATION_SETUP (location_type l)
      {
        return symbol_type (token::COMPILATION_SETUP, std::move (l));
      }
#else
      static
      symbol_type
      make_COMPILATION_SETUP (const location_type& l)
      {
        return symbol_type (token::COMPILATION_SETUP, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_COMPILER (location_type l)
      {
        return symbol_type (token::COMPILER, std::move (l));
      }
#else
      static
      symbol_type
      make_COMPILER (const location_type& l)
      {
        return symbol_type (token::COMPILER, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_ADD_FLAGS (location_type l)
      {
        return symbol_type (token::ADD_FLAGS, std::move (l));
      }
#else
      static
      symbol_type
      make_ADD_FLAGS (const location_type& l)
      {
        return symbol_type (token::ADD_FLAGS, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_SUBSTITUTE_FLAGS (location_type l)
      {
        return symbol_type (token::SUBSTITUTE_FLAGS, std::move (l));
      }
#else
      static
      symbol_type
      make_SUBSTITUTE_FLAGS (const location_type& l)
      {
        return symbol_type (token::SUBSTITUTE_FLAGS, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_ADD_LIBS (location_type l)
      {
        return symbol_type (token::ADD_LIBS, std::move (l));
      }
#else
      static
      symbol_type
      make_ADD_LIBS (const location_type& l)
      {
        return symbol_type (token::ADD_LIBS, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_SUBSTITUTE_LIBS (location_type l)
      {
        return symbol_type (token::SUBSTITUTE_LIBS, std::move (l));
      }
#else
      static
      symbol_type
      make_SUBSTITUTE_LIBS (const location_type& l)
      {
        return symbol_type (token::SUBSTITUTE_LIBS, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_FORECAST (location_type l)
      {
        return symbol_type (token::FORECAST, std::move (l));
      }
#else
      static
      symbol_type
      make_FORECAST (const location_type& l)
      {
        return symbol_type (token::FORECAST, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_K_ORDER_SOLVER (location_type l)
      {
        return symbol_type (token::K_ORDER_SOLVER, std::move (l));
      }
#else
      static
      symbol_type
      make_K_ORDER_SOLVER (const location_type& l)
      {
        return symbol_type (token::K_ORDER_SOLVER, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_INSTRUMENTS (location_type l)
      {
        return symbol_type (token::INSTRUMENTS, std::move (l));
      }
#else
      static
      symbol_type
      make_INSTRUMENTS (const location_type& l)
      {
        return symbol_type (token::INSTRUMENTS, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_SHIFT (location_type l)
      {
        return symbol_type (token::SHIFT, std::move (l));
      }
#else
      static
      symbol_type
      make_SHIFT (const location_type& l)
      {
        return symbol_type (token::SHIFT, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_MEAN (location_type l)
      {
        return symbol_type (token::MEAN, std::move (l));
      }
#else
      static
      symbol_type
      make_MEAN (const location_type& l)
      {
        return symbol_type (token::MEAN, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_STDEV (location_type l)
      {
        return symbol_type (token::STDEV, std::move (l));
      }
#else
      static
      symbol_type
      make_STDEV (const location_type& l)
      {
        return symbol_type (token::STDEV, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_VARIANCE (location_type l)
      {
        return symbol_type (token::VARIANCE, std::move (l));
      }
#else
      static
      symbol_type
      make_VARIANCE (const location_type& l)
      {
        return symbol_type (token::VARIANCE, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_MODE (location_type l)
      {
        return symbol_type (token::MODE, std::move (l));
      }
#else
      static
      symbol_type
      make_MODE (const location_type& l)
      {
        return symbol_type (token::MODE, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_INTERVAL (location_type l)
      {
        return symbol_type (token::INTERVAL, std::move (l));
      }
#else
      static
      symbol_type
      make_INTERVAL (const location_type& l)
      {
        return symbol_type (token::INTERVAL, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_SHAPE (location_type l)
      {
        return symbol_type (token::SHAPE, std::move (l));
      }
#else
      static
      symbol_type
      make_SHAPE (const location_type& l)
      {
        return symbol_type (token::SHAPE, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_DOMAINN (location_type l)
      {
        return symbol_type (token::DOMAINN, std::move (l));
      }
#else
      static
      symbol_type
      make_DOMAINN (const location_type& l)
      {
        return symbol_type (token::DOMAINN, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_GAMMA_PDF (location_type l)
      {
        return symbol_type (token::GAMMA_PDF, std::move (l));
      }
#else
      static
      symbol_type
      make_GAMMA_PDF (const location_type& l)
      {
        return symbol_type (token::GAMMA_PDF, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_GRAPH (location_type l)
      {
        return symbol_type (token::GRAPH, std::move (l));
      }
#else
      static
      symbol_type
      make_GRAPH (const location_type& l)
      {
        return symbol_type (token::GRAPH, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_GRAPH_FORMAT (location_type l)
      {
        return symbol_type (token::GRAPH_FORMAT, std::move (l));
      }
#else
      static
      symbol_type
      make_GRAPH_FORMAT (const location_type& l)
      {
        return symbol_type (token::GRAPH_FORMAT, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_CONDITIONAL_VARIANCE_DECOMPOSITION (location_type l)
      {
        return symbol_type (token::CONDITIONAL_VARIANCE_DECOMPOSITION, std::move (l));
      }
#else
      static
      symbol_type
      make_CONDITIONAL_VARIANCE_DECOMPOSITION (const location_type& l)
      {
        return symbol_type (token::CONDITIONAL_VARIANCE_DECOMPOSITION, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_NOCHECK (location_type l)
      {
        return symbol_type (token::NOCHECK, std::move (l));
      }
#else
      static
      symbol_type
      make_NOCHECK (const location_type& l)
      {
        return symbol_type (token::NOCHECK, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_STD (location_type l)
      {
        return symbol_type (token::STD, std::move (l));
      }
#else
      static
      symbol_type
      make_STD (const location_type& l)
      {
        return symbol_type (token::STD, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_HISTVAL (location_type l)
      {
        return symbol_type (token::HISTVAL, std::move (l));
      }
#else
      static
      symbol_type
      make_HISTVAL (const location_type& l)
      {
        return symbol_type (token::HISTVAL, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_HISTVAL_FILE (location_type l)
      {
        return symbol_type (token::HISTVAL_FILE, std::move (l));
      }
#else
      static
      symbol_type
      make_HISTVAL_FILE (const location_type& l)
      {
        return symbol_type (token::HISTVAL_FILE, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_HOMOTOPY_SETUP (location_type l)
      {
        return symbol_type (token::HOMOTOPY_SETUP, std::move (l));
      }
#else
      static
      symbol_type
      make_HOMOTOPY_SETUP (const location_type& l)
      {
        return symbol_type (token::HOMOTOPY_SETUP, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_HOMOTOPY_MODE (location_type l)
      {
        return symbol_type (token::HOMOTOPY_MODE, std::move (l));
      }
#else
      static
      symbol_type
      make_HOMOTOPY_MODE (const location_type& l)
      {
        return symbol_type (token::HOMOTOPY_MODE, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_HOMOTOPY_STEPS (location_type l)
      {
        return symbol_type (token::HOMOTOPY_STEPS, std::move (l));
      }
#else
      static
      symbol_type
      make_HOMOTOPY_STEPS (const location_type& l)
      {
        return symbol_type (token::HOMOTOPY_STEPS, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_HOMOTOPY_FORCE_CONTINUE (location_type l)
      {
        return symbol_type (token::HOMOTOPY_FORCE_CONTINUE, std::move (l));
      }
#else
      static
      symbol_type
      make_HOMOTOPY_FORCE_CONTINUE (const location_type& l)
      {
        return symbol_type (token::HOMOTOPY_FORCE_CONTINUE, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_HP_FILTER (location_type l)
      {
        return symbol_type (token::HP_FILTER, std::move (l));
      }
#else
      static
      symbol_type
      make_HP_FILTER (const location_type& l)
      {
        return symbol_type (token::HP_FILTER, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_HP_NGRID (location_type l)
      {
        return symbol_type (token::HP_NGRID, std::move (l));
      }
#else
      static
      symbol_type
      make_HP_NGRID (const location_type& l)
      {
        return symbol_type (token::HP_NGRID, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_FILTERED_THEORETICAL_MOMENTS_GRID (location_type l)
      {
        return symbol_type (token::FILTERED_THEORETICAL_MOMENTS_GRID, std::move (l));
      }
#else
      static
      symbol_type
      make_FILTERED_THEORETICAL_MOMENTS_GRID (const location_type& l)
      {
        return symbol_type (token::FILTERED_THEORETICAL_MOMENTS_GRID, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_HYBRID (location_type l)
      {
        return symbol_type (token::HYBRID, std::move (l));
      }
#else
      static
      symbol_type
      make_HYBRID (const location_type& l)
      {
        return symbol_type (token::HYBRID, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_ONE_SIDED_HP_FILTER (location_type l)
      {
        return symbol_type (token::ONE_SIDED_HP_FILTER, std::move (l));
      }
#else
      static
      symbol_type
      make_ONE_SIDED_HP_FILTER (const location_type& l)
      {
        return symbol_type (token::ONE_SIDED_HP_FILTER, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_IDENTIFICATION (location_type l)
      {
        return symbol_type (token::IDENTIFICATION, std::move (l));
      }
#else
      static
      symbol_type
      make_IDENTIFICATION (const location_type& l)
      {
        return symbol_type (token::IDENTIFICATION, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_INF_CONSTANT (location_type l)
      {
        return symbol_type (token::INF_CONSTANT, std::move (l));
      }
#else
      static
      symbol_type
      make_INF_CONSTANT (const location_type& l)
      {
        return symbol_type (token::INF_CONSTANT, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_INITVAL (location_type l)
      {
        return symbol_type (token::INITVAL, std::move (l));
      }
#else
      static
      symbol_type
      make_INITVAL (const location_type& l)
      {
        return symbol_type (token::INITVAL, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_INITVAL_FILE (location_type l)
      {
        return symbol_type (token::INITVAL_FILE, std::move (l));
      }
#else
      static
      symbol_type
      make_INITVAL_FILE (const location_type& l)
      {
        return symbol_type (token::INITVAL_FILE, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_BOUNDS (location_type l)
      {
        return symbol_type (token::BOUNDS, std::move (l));
      }
#else
      static
      symbol_type
      make_BOUNDS (const location_type& l)
      {
        return symbol_type (token::BOUNDS, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_JSCALE (location_type l)
      {
        return symbol_type (token::JSCALE, std::move (l));
      }
#else
      static
      symbol_type
      make_JSCALE (const location_type& l)
      {
        return symbol_type (token::JSCALE, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_INIT (location_type l)
      {
        return symbol_type (token::INIT, std::move (l));
      }
#else
      static
      symbol_type
      make_INIT (const location_type& l)
      {
        return symbol_type (token::INIT, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_INFILE (location_type l)
      {
        return symbol_type (token::INFILE, std::move (l));
      }
#else
      static
      symbol_type
      make_INFILE (const location_type& l)
      {
        return symbol_type (token::INFILE, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_INVARS (location_type l)
      {
        return symbol_type (token::INVARS, std::move (l));
      }
#else
      static
      symbol_type
      make_INVARS (const location_type& l)
      {
        return symbol_type (token::INVARS, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_INT_NUMBER (string v, location_type l)
      {
        return symbol_type (token::INT_NUMBER, std::move (v), std::move (l));
      }
#else
      static
      symbol_type
      make_INT_NUMBER (const string& v, const location_type& l)
      {
        return symbol_type (token::INT_NUMBER, v, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_INV_GAMMA_PDF (location_type l)
      {
        return symbol_type (token::INV_GAMMA_PDF, std::move (l));
      }
#else
      static
      symbol_type
      make_INV_GAMMA_PDF (const location_type& l)
      {
        return symbol_type (token::INV_GAMMA_PDF, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_INV_GAMMA1_PDF (location_type l)
      {
        return symbol_type (token::INV_GAMMA1_PDF, std::move (l));
      }
#else
      static
      symbol_type
      make_INV_GAMMA1_PDF (const location_type& l)
      {
        return symbol_type (token::INV_GAMMA1_PDF, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_INV_GAMMA2_PDF (location_type l)
      {
        return symbol_type (token::INV_GAMMA2_PDF, std::move (l));
      }
#else
      static
      symbol_type
      make_INV_GAMMA2_PDF (const location_type& l)
      {
        return symbol_type (token::INV_GAMMA2_PDF, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_IRF (location_type l)
      {
        return symbol_type (token::IRF, std::move (l));
      }
#else
      static
      symbol_type
      make_IRF (const location_type& l)
      {
        return symbol_type (token::IRF, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_IRF_SHOCKS (location_type l)
      {
        return symbol_type (token::IRF_SHOCKS, std::move (l));
      }
#else
      static
      symbol_type
      make_IRF_SHOCKS (const location_type& l)
      {
        return symbol_type (token::IRF_SHOCKS, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_IRF_PLOT_THRESHOLD (location_type l)
      {
        return symbol_type (token::IRF_PLOT_THRESHOLD, std::move (l));
      }
#else
      static
      symbol_type
      make_IRF_PLOT_THRESHOLD (const location_type& l)
      {
        return symbol_type (token::IRF_PLOT_THRESHOLD, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_IRF_CALIBRATION (location_type l)
      {
        return symbol_type (token::IRF_CALIBRATION, std::move (l));
      }
#else
      static
      symbol_type
      make_IRF_CALIBRATION (const location_type& l)
      {
        return symbol_type (token::IRF_CALIBRATION, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_FAST_KALMAN_FILTER (location_type l)
      {
        return symbol_type (token::FAST_KALMAN_FILTER, std::move (l));
      }
#else
      static
      symbol_type
      make_FAST_KALMAN_FILTER (const location_type& l)
      {
        return symbol_type (token::FAST_KALMAN_FILTER, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_KALMAN_ALGO (location_type l)
      {
        return symbol_type (token::KALMAN_ALGO, std::move (l));
      }
#else
      static
      symbol_type
      make_KALMAN_ALGO (const location_type& l)
      {
        return symbol_type (token::KALMAN_ALGO, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_KALMAN_TOL (location_type l)
      {
        return symbol_type (token::KALMAN_TOL, std::move (l));
      }
#else
      static
      symbol_type
      make_KALMAN_TOL (const location_type& l)
      {
        return symbol_type (token::KALMAN_TOL, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_DIFFUSE_KALMAN_TOL (location_type l)
      {
        return symbol_type (token::DIFFUSE_KALMAN_TOL, std::move (l));
      }
#else
      static
      symbol_type
      make_DIFFUSE_KALMAN_TOL (const location_type& l)
      {
        return symbol_type (token::DIFFUSE_KALMAN_TOL, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_SUBSAMPLES (location_type l)
      {
        return symbol_type (token::SUBSAMPLES, std::move (l));
      }
#else
      static
      symbol_type
      make_SUBSAMPLES (const location_type& l)
      {
        return symbol_type (token::SUBSAMPLES, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_OPTIONS (location_type l)
      {
        return symbol_type (token::OPTIONS, std::move (l));
      }
#else
      static
      symbol_type
      make_OPTIONS (const location_type& l)
      {
        return symbol_type (token::OPTIONS, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_TOLF (location_type l)
      {
        return symbol_type (token::TOLF, std::move (l));
      }
#else
      static
      symbol_type
      make_TOLF (const location_type& l)
      {
        return symbol_type (token::TOLF, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_TOLX (location_type l)
      {
        return symbol_type (token::TOLX, std::move (l));
      }
#else
      static
      symbol_type
      make_TOLX (const location_type& l)
      {
        return symbol_type (token::TOLX, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_PLOT_INIT_DATE (location_type l)
      {
        return symbol_type (token::PLOT_INIT_DATE, std::move (l));
      }
#else
      static
      symbol_type
      make_PLOT_INIT_DATE (const location_type& l)
      {
        return symbol_type (token::PLOT_INIT_DATE, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_PLOT_END_DATE (location_type l)
      {
        return symbol_type (token::PLOT_END_DATE, std::move (l));
      }
#else
      static
      symbol_type
      make_PLOT_END_DATE (const location_type& l)
      {
        return symbol_type (token::PLOT_END_DATE, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_LAPLACE (location_type l)
      {
        return symbol_type (token::LAPLACE, std::move (l));
      }
#else
      static
      symbol_type
      make_LAPLACE (const location_type& l)
      {
        return symbol_type (token::LAPLACE, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_LIK_ALGO (location_type l)
      {
        return symbol_type (token::LIK_ALGO, std::move (l));
      }
#else
      static
      symbol_type
      make_LIK_ALGO (const location_type& l)
      {
        return symbol_type (token::LIK_ALGO, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_LIK_INIT (location_type l)
      {
        return symbol_type (token::LIK_INIT, std::move (l));
      }
#else
      static
      symbol_type
      make_LIK_INIT (const location_type& l)
      {
        return symbol_type (token::LIK_INIT, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_LINEAR (location_type l)
      {
        return symbol_type (token::LINEAR, std::move (l));
      }
#else
      static
      symbol_type
      make_LINEAR (const location_type& l)
      {
        return symbol_type (token::LINEAR, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_LINEAR_DECOMPOSITION (location_type l)
      {
        return symbol_type (token::LINEAR_DECOMPOSITION, std::move (l));
      }
#else
      static
      symbol_type
      make_LINEAR_DECOMPOSITION (const location_type& l)
      {
        return symbol_type (token::LINEAR_DECOMPOSITION, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_LOAD_IDENT_FILES (location_type l)
      {
        return symbol_type (token::LOAD_IDENT_FILES, std::move (l));
      }
#else
      static
      symbol_type
      make_LOAD_IDENT_FILES (const location_type& l)
      {
        return symbol_type (token::LOAD_IDENT_FILES, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_LOAD_MH_FILE (location_type l)
      {
        return symbol_type (token::LOAD_MH_FILE, std::move (l));
      }
#else
      static
      symbol_type
      make_LOAD_MH_FILE (const location_type& l)
      {
        return symbol_type (token::LOAD_MH_FILE, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_LOAD_RESULTS_AFTER_LOAD_MH (location_type l)
      {
        return symbol_type (token::LOAD_RESULTS_AFTER_LOAD_MH, std::move (l));
      }
#else
      static
      symbol_type
      make_LOAD_RESULTS_AFTER_LOAD_MH (const location_type& l)
      {
        return symbol_type (token::LOAD_RESULTS_AFTER_LOAD_MH, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_LOAD_PARAMS_AND_STEADY_STATE (location_type l)
      {
        return symbol_type (token::LOAD_PARAMS_AND_STEADY_STATE, std::move (l));
      }
#else
      static
      symbol_type
      make_LOAD_PARAMS_AND_STEADY_STATE (const location_type& l)
      {
        return symbol_type (token::LOAD_PARAMS_AND_STEADY_STATE, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_LOGLINEAR (location_type l)
      {
        return symbol_type (token::LOGLINEAR, std::move (l));
      }
#else
      static
      symbol_type
      make_LOGLINEAR (const location_type& l)
      {
        return symbol_type (token::LOGLINEAR, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_LOGDATA (location_type l)
      {
        return symbol_type (token::LOGDATA, std::move (l));
      }
#else
      static
      symbol_type
      make_LOGDATA (const location_type& l)
      {
        return symbol_type (token::LOGDATA, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_LYAPUNOV (location_type l)
      {
        return symbol_type (token::LYAPUNOV, std::move (l));
      }
#else
      static
      symbol_type
      make_LYAPUNOV (const location_type& l)
      {
        return symbol_type (token::LYAPUNOV, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_LINEAR_APPROXIMATION (location_type l)
      {
        return symbol_type (token::LINEAR_APPROXIMATION, std::move (l));
      }
#else
      static
      symbol_type
      make_LINEAR_APPROXIMATION (const location_type& l)
      {
        return symbol_type (token::LINEAR_APPROXIMATION, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_LYAPUNOV_FIXED_POINT_TOL (location_type l)
      {
        return symbol_type (token::LYAPUNOV_FIXED_POINT_TOL, std::move (l));
      }
#else
      static
      symbol_type
      make_LYAPUNOV_FIXED_POINT_TOL (const location_type& l)
      {
        return symbol_type (token::LYAPUNOV_FIXED_POINT_TOL, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_LYAPUNOV_DOUBLING_TOL (location_type l)
      {
        return symbol_type (token::LYAPUNOV_DOUBLING_TOL, std::move (l));
      }
#else
      static
      symbol_type
      make_LYAPUNOV_DOUBLING_TOL (const location_type& l)
      {
        return symbol_type (token::LYAPUNOV_DOUBLING_TOL, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_LOG_DEFLATOR (location_type l)
      {
        return symbol_type (token::LOG_DEFLATOR, std::move (l));
      }
#else
      static
      symbol_type
      make_LOG_DEFLATOR (const location_type& l)
      {
        return symbol_type (token::LOG_DEFLATOR, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_LOG_TREND_VAR (location_type l)
      {
        return symbol_type (token::LOG_TREND_VAR, std::move (l));
      }
#else
      static
      symbol_type
      make_LOG_TREND_VAR (const location_type& l)
      {
        return symbol_type (token::LOG_TREND_VAR, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_LOG_GROWTH_FACTOR (location_type l)
      {
        return symbol_type (token::LOG_GROWTH_FACTOR, std::move (l));
      }
#else
      static
      symbol_type
      make_LOG_GROWTH_FACTOR (const location_type& l)
      {
        return symbol_type (token::LOG_GROWTH_FACTOR, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_MARKOWITZ (location_type l)
      {
        return symbol_type (token::MARKOWITZ, std::move (l));
      }
#else
      static
      symbol_type
      make_MARKOWITZ (const location_type& l)
      {
        return symbol_type (token::MARKOWITZ, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_MARGINAL_DENSITY (location_type l)
      {
        return symbol_type (token::MARGINAL_DENSITY, std::move (l));
      }
#else
      static
      symbol_type
      make_MARGINAL_DENSITY (const location_type& l)
      {
        return symbol_type (token::MARGINAL_DENSITY, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_MAX (location_type l)
      {
        return symbol_type (token::MAX, std::move (l));
      }
#else
      static
      symbol_type
      make_MAX (const location_type& l)
      {
        return symbol_type (token::MAX, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_MAXIT (location_type l)
      {
        return symbol_type (token::MAXIT, std::move (l));
      }
#else
      static
      symbol_type
      make_MAXIT (const location_type& l)
      {
        return symbol_type (token::MAXIT, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_MFS (location_type l)
      {
        return symbol_type (token::MFS, std::move (l));
      }
#else
      static
      symbol_type
      make_MFS (const location_type& l)
      {
        return symbol_type (token::MFS, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_MH_CONF_SIG (location_type l)
      {
        return symbol_type (token::MH_CONF_SIG, std::move (l));
      }
#else
      static
      symbol_type
      make_MH_CONF_SIG (const location_type& l)
      {
        return symbol_type (token::MH_CONF_SIG, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_MH_DROP (location_type l)
      {
        return symbol_type (token::MH_DROP, std::move (l));
      }
#else
      static
      symbol_type
      make_MH_DROP (const location_type& l)
      {
        return symbol_type (token::MH_DROP, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_MH_INIT_SCALE (location_type l)
      {
        return symbol_type (token::MH_INIT_SCALE, std::move (l));
      }
#else
      static
      symbol_type
      make_MH_INIT_SCALE (const location_type& l)
      {
        return symbol_type (token::MH_INIT_SCALE, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_MH_JSCALE (location_type l)
      {
        return symbol_type (token::MH_JSCALE, std::move (l));
      }
#else
      static
      symbol_type
      make_MH_JSCALE (const location_type& l)
      {
        return symbol_type (token::MH_JSCALE, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_MH_TUNE_JSCALE (location_type l)
      {
        return symbol_type (token::MH_TUNE_JSCALE, std::move (l));
      }
#else
      static
      symbol_type
      make_MH_TUNE_JSCALE (const location_type& l)
      {
        return symbol_type (token::MH_TUNE_JSCALE, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_MH_MODE (location_type l)
      {
        return symbol_type (token::MH_MODE, std::move (l));
      }
#else
      static
      symbol_type
      make_MH_MODE (const location_type& l)
      {
        return symbol_type (token::MH_MODE, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_MH_NBLOCKS (location_type l)
      {
        return symbol_type (token::MH_NBLOCKS, std::move (l));
      }
#else
      static
      symbol_type
      make_MH_NBLOCKS (const location_type& l)
      {
        return symbol_type (token::MH_NBLOCKS, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_MH_REPLIC (location_type l)
      {
        return symbol_type (token::MH_REPLIC, std::move (l));
      }
#else
      static
      symbol_type
      make_MH_REPLIC (const location_type& l)
      {
        return symbol_type (token::MH_REPLIC, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_MH_RECOVER (location_type l)
      {
        return symbol_type (token::MH_RECOVER, std::move (l));
      }
#else
      static
      symbol_type
      make_MH_RECOVER (const location_type& l)
      {
        return symbol_type (token::MH_RECOVER, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_POSTERIOR_MAX_SUBSAMPLE_DRAWS (location_type l)
      {
        return symbol_type (token::POSTERIOR_MAX_SUBSAMPLE_DRAWS, std::move (l));
      }
#else
      static
      symbol_type
      make_POSTERIOR_MAX_SUBSAMPLE_DRAWS (const location_type& l)
      {
        return symbol_type (token::POSTERIOR_MAX_SUBSAMPLE_DRAWS, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_MIN (location_type l)
      {
        return symbol_type (token::MIN, std::move (l));
      }
#else
      static
      symbol_type
      make_MIN (const location_type& l)
      {
        return symbol_type (token::MIN, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_MINIMAL_SOLVING_PERIODS (location_type l)
      {
        return symbol_type (token::MINIMAL_SOLVING_PERIODS, std::move (l));
      }
#else
      static
      symbol_type
      make_MINIMAL_SOLVING_PERIODS (const location_type& l)
      {
        return symbol_type (token::MINIMAL_SOLVING_PERIODS, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_MODE_CHECK (location_type l)
      {
        return symbol_type (token::MODE_CHECK, std::move (l));
      }
#else
      static
      symbol_type
      make_MODE_CHECK (const location_type& l)
      {
        return symbol_type (token::MODE_CHECK, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_MODE_CHECK_NEIGHBOURHOOD_SIZE (location_type l)
      {
        return symbol_type (token::MODE_CHECK_NEIGHBOURHOOD_SIZE, std::move (l));
      }
#else
      static
      symbol_type
      make_MODE_CHECK_NEIGHBOURHOOD_SIZE (const location_type& l)
      {
        return symbol_type (token::MODE_CHECK_NEIGHBOURHOOD_SIZE, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_MODE_CHECK_SYMMETRIC_PLOTS (location_type l)
      {
        return symbol_type (token::MODE_CHECK_SYMMETRIC_PLOTS, std::move (l));
      }
#else
      static
      symbol_type
      make_MODE_CHECK_SYMMETRIC_PLOTS (const location_type& l)
      {
        return symbol_type (token::MODE_CHECK_SYMMETRIC_PLOTS, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_MODE_CHECK_NUMBER_OF_POINTS (location_type l)
      {
        return symbol_type (token::MODE_CHECK_NUMBER_OF_POINTS, std::move (l));
      }
#else
      static
      symbol_type
      make_MODE_CHECK_NUMBER_OF_POINTS (const location_type& l)
      {
        return symbol_type (token::MODE_CHECK_NUMBER_OF_POINTS, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_MODE_COMPUTE (location_type l)
      {
        return symbol_type (token::MODE_COMPUTE, std::move (l));
      }
#else
      static
      symbol_type
      make_MODE_COMPUTE (const location_type& l)
      {
        return symbol_type (token::MODE_COMPUTE, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_MODE_FILE (location_type l)
      {
        return symbol_type (token::MODE_FILE, std::move (l));
      }
#else
      static
      symbol_type
      make_MODE_FILE (const location_type& l)
      {
        return symbol_type (token::MODE_FILE, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_MODEL (location_type l)
      {
        return symbol_type (token::MODEL, std::move (l));
      }
#else
      static
      symbol_type
      make_MODEL (const location_type& l)
      {
        return symbol_type (token::MODEL, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_MODEL_COMPARISON (location_type l)
      {
        return symbol_type (token::MODEL_COMPARISON, std::move (l));
      }
#else
      static
      symbol_type
      make_MODEL_COMPARISON (const location_type& l)
      {
        return symbol_type (token::MODEL_COMPARISON, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_MODEL_INFO (location_type l)
      {
        return symbol_type (token::MODEL_INFO, std::move (l));
      }
#else
      static
      symbol_type
      make_MODEL_INFO (const location_type& l)
      {
        return symbol_type (token::MODEL_INFO, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_MSHOCKS (location_type l)
      {
        return symbol_type (token::MSHOCKS, std::move (l));
      }
#else
      static
      symbol_type
      make_MSHOCKS (const location_type& l)
      {
        return symbol_type (token::MSHOCKS, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_ABS (location_type l)
      {
        return symbol_type (token::ABS, std::move (l));
      }
#else
      static
      symbol_type
      make_ABS (const location_type& l)
      {
        return symbol_type (token::ABS, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_SIGN (location_type l)
      {
        return symbol_type (token::SIGN, std::move (l));
      }
#else
      static
      symbol_type
      make_SIGN (const location_type& l)
      {
        return symbol_type (token::SIGN, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_MODEL_DIAGNOSTICS (location_type l)
      {
        return symbol_type (token::MODEL_DIAGNOSTICS, std::move (l));
      }
#else
      static
      symbol_type
      make_MODEL_DIAGNOSTICS (const location_type& l)
      {
        return symbol_type (token::MODEL_DIAGNOSTICS, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_MODIFIEDHARMONICMEAN (location_type l)
      {
        return symbol_type (token::MODIFIEDHARMONICMEAN, std::move (l));
      }
#else
      static
      symbol_type
      make_MODIFIEDHARMONICMEAN (const location_type& l)
      {
        return symbol_type (token::MODIFIEDHARMONICMEAN, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_MOMENTS_VARENDO (location_type l)
      {
        return symbol_type (token::MOMENTS_VARENDO, std::move (l));
      }
#else
      static
      symbol_type
      make_MOMENTS_VARENDO (const location_type& l)
      {
        return symbol_type (token::MOMENTS_VARENDO, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_CONTEMPORANEOUS_CORRELATION (location_type l)
      {
        return symbol_type (token::CONTEMPORANEOUS_CORRELATION, std::move (l));
      }
#else
      static
      symbol_type
      make_CONTEMPORANEOUS_CORRELATION (const location_type& l)
      {
        return symbol_type (token::CONTEMPORANEOUS_CORRELATION, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_DIFFUSE_FILTER (location_type l)
      {
        return symbol_type (token::DIFFUSE_FILTER, std::move (l));
      }
#else
      static
      symbol_type
      make_DIFFUSE_FILTER (const location_type& l)
      {
        return symbol_type (token::DIFFUSE_FILTER, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_SUB_DRAWS (location_type l)
      {
        return symbol_type (token::SUB_DRAWS, std::move (l));
      }
#else
      static
      symbol_type
      make_SUB_DRAWS (const location_type& l)
      {
        return symbol_type (token::SUB_DRAWS, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_TAPER_STEPS (location_type l)
      {
        return symbol_type (token::TAPER_STEPS, std::move (l));
      }
#else
      static
      symbol_type
      make_TAPER_STEPS (const location_type& l)
      {
        return symbol_type (token::TAPER_STEPS, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_GEWEKE_INTERVAL (location_type l)
      {
        return symbol_type (token::GEWEKE_INTERVAL, std::move (l));
      }
#else
      static
      symbol_type
      make_GEWEKE_INTERVAL (const location_type& l)
      {
        return symbol_type (token::GEWEKE_INTERVAL, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_RAFTERY_LEWIS_QRS (location_type l)
      {
        return symbol_type (token::RAFTERY_LEWIS_QRS, std::move (l));
      }
#else
      static
      symbol_type
      make_RAFTERY_LEWIS_QRS (const location_type& l)
      {
        return symbol_type (token::RAFTERY_LEWIS_QRS, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_RAFTERY_LEWIS_DIAGNOSTICS (location_type l)
      {
        return symbol_type (token::RAFTERY_LEWIS_DIAGNOSTICS, std::move (l));
      }
#else
      static
      symbol_type
      make_RAFTERY_LEWIS_DIAGNOSTICS (const location_type& l)
      {
        return symbol_type (token::RAFTERY_LEWIS_DIAGNOSTICS, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_MCMC_JUMPING_COVARIANCE (location_type l)
      {
        return symbol_type (token::MCMC_JUMPING_COVARIANCE, std::move (l));
      }
#else
      static
      symbol_type
      make_MCMC_JUMPING_COVARIANCE (const location_type& l)
      {
        return symbol_type (token::MCMC_JUMPING_COVARIANCE, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_MOMENT_CALIBRATION (location_type l)
      {
        return symbol_type (token::MOMENT_CALIBRATION, std::move (l));
      }
#else
      static
      symbol_type
      make_MOMENT_CALIBRATION (const location_type& l)
      {
        return symbol_type (token::MOMENT_CALIBRATION, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_NUMBER_OF_PARTICLES (location_type l)
      {
        return symbol_type (token::NUMBER_OF_PARTICLES, std::move (l));
      }
#else
      static
      symbol_type
      make_NUMBER_OF_PARTICLES (const location_type& l)
      {
        return symbol_type (token::NUMBER_OF_PARTICLES, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_RESAMPLING (location_type l)
      {
        return symbol_type (token::RESAMPLING, std::move (l));
      }
#else
      static
      symbol_type
      make_RESAMPLING (const location_type& l)
      {
        return symbol_type (token::RESAMPLING, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_SYSTEMATIC (location_type l)
      {
        return symbol_type (token::SYSTEMATIC, std::move (l));
      }
#else
      static
      symbol_type
      make_SYSTEMATIC (const location_type& l)
      {
        return symbol_type (token::SYSTEMATIC, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_GENERIC (location_type l)
      {
        return symbol_type (token::GENERIC, std::move (l));
      }
#else
      static
      symbol_type
      make_GENERIC (const location_type& l)
      {
        return symbol_type (token::GENERIC, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_RESAMPLING_THRESHOLD (location_type l)
      {
        return symbol_type (token::RESAMPLING_THRESHOLD, std::move (l));
      }
#else
      static
      symbol_type
      make_RESAMPLING_THRESHOLD (const location_type& l)
      {
        return symbol_type (token::RESAMPLING_THRESHOLD, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_RESAMPLING_METHOD (location_type l)
      {
        return symbol_type (token::RESAMPLING_METHOD, std::move (l));
      }
#else
      static
      symbol_type
      make_RESAMPLING_METHOD (const location_type& l)
      {
        return symbol_type (token::RESAMPLING_METHOD, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_KITAGAWA (location_type l)
      {
        return symbol_type (token::KITAGAWA, std::move (l));
      }
#else
      static
      symbol_type
      make_KITAGAWA (const location_type& l)
      {
        return symbol_type (token::KITAGAWA, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_STRATIFIED (location_type l)
      {
        return symbol_type (token::STRATIFIED, std::move (l));
      }
#else
      static
      symbol_type
      make_STRATIFIED (const location_type& l)
      {
        return symbol_type (token::STRATIFIED, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_SMOOTH (location_type l)
      {
        return symbol_type (token::SMOOTH, std::move (l));
      }
#else
      static
      symbol_type
      make_SMOOTH (const location_type& l)
      {
        return symbol_type (token::SMOOTH, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_CPF_WEIGHTS (location_type l)
      {
        return symbol_type (token::CPF_WEIGHTS, std::move (l));
      }
#else
      static
      symbol_type
      make_CPF_WEIGHTS (const location_type& l)
      {
        return symbol_type (token::CPF_WEIGHTS, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_AMISANOTRISTANI (location_type l)
      {
        return symbol_type (token::AMISANOTRISTANI, std::move (l));
      }
#else
      static
      symbol_type
      make_AMISANOTRISTANI (const location_type& l)
      {
        return symbol_type (token::AMISANOTRISTANI, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_MURRAYJONESPARSLOW (location_type l)
      {
        return symbol_type (token::MURRAYJONESPARSLOW, std::move (l));
      }
#else
      static
      symbol_type
      make_MURRAYJONESPARSLOW (const location_type& l)
      {
        return symbol_type (token::MURRAYJONESPARSLOW, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_WRITE_EQUATION_TAGS (location_type l)
      {
        return symbol_type (token::WRITE_EQUATION_TAGS, std::move (l));
      }
#else
      static
      symbol_type
      make_WRITE_EQUATION_TAGS (const location_type& l)
      {
        return symbol_type (token::WRITE_EQUATION_TAGS, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_NONLINEAR_FILTER_INITIALIZATION (location_type l)
      {
        return symbol_type (token::NONLINEAR_FILTER_INITIALIZATION, std::move (l));
      }
#else
      static
      symbol_type
      make_NONLINEAR_FILTER_INITIALIZATION (const location_type& l)
      {
        return symbol_type (token::NONLINEAR_FILTER_INITIALIZATION, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_FILTER_ALGORITHM (location_type l)
      {
        return symbol_type (token::FILTER_ALGORITHM, std::move (l));
      }
#else
      static
      symbol_type
      make_FILTER_ALGORITHM (const location_type& l)
      {
        return symbol_type (token::FILTER_ALGORITHM, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_PROPOSAL_APPROXIMATION (location_type l)
      {
        return symbol_type (token::PROPOSAL_APPROXIMATION, std::move (l));
      }
#else
      static
      symbol_type
      make_PROPOSAL_APPROXIMATION (const location_type& l)
      {
        return symbol_type (token::PROPOSAL_APPROXIMATION, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_CUBATURE (location_type l)
      {
        return symbol_type (token::CUBATURE, std::move (l));
      }
#else
      static
      symbol_type
      make_CUBATURE (const location_type& l)
      {
        return symbol_type (token::CUBATURE, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_UNSCENTED (location_type l)
      {
        return symbol_type (token::UNSCENTED, std::move (l));
      }
#else
      static
      symbol_type
      make_UNSCENTED (const location_type& l)
      {
        return symbol_type (token::UNSCENTED, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_MONTECARLO (location_type l)
      {
        return symbol_type (token::MONTECARLO, std::move (l));
      }
#else
      static
      symbol_type
      make_MONTECARLO (const location_type& l)
      {
        return symbol_type (token::MONTECARLO, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_DISTRIBUTION_APPROXIMATION (location_type l)
      {
        return symbol_type (token::DISTRIBUTION_APPROXIMATION, std::move (l));
      }
#else
      static
      symbol_type
      make_DISTRIBUTION_APPROXIMATION (const location_type& l)
      {
        return symbol_type (token::DISTRIBUTION_APPROXIMATION, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_NAME (string v, location_type l)
      {
        return symbol_type (token::NAME, std::move (v), std::move (l));
      }
#else
      static
      symbol_type
      make_NAME (const string& v, const location_type& l)
      {
        return symbol_type (token::NAME, v, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_USE_PENALIZED_OBJECTIVE_FOR_HESSIAN (location_type l)
      {
        return symbol_type (token::USE_PENALIZED_OBJECTIVE_FOR_HESSIAN, std::move (l));
      }
#else
      static
      symbol_type
      make_USE_PENALIZED_OBJECTIVE_FOR_HESSIAN (const location_type& l)
      {
        return symbol_type (token::USE_PENALIZED_OBJECTIVE_FOR_HESSIAN, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_INIT_STATE (location_type l)
      {
        return symbol_type (token::INIT_STATE, std::move (l));
      }
#else
      static
      symbol_type
      make_INIT_STATE (const location_type& l)
      {
        return symbol_type (token::INIT_STATE, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_FAST_REALTIME (location_type l)
      {
        return symbol_type (token::FAST_REALTIME, std::move (l));
      }
#else
      static
      symbol_type
      make_FAST_REALTIME (const location_type& l)
      {
        return symbol_type (token::FAST_REALTIME, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_RESCALE_PREDICTION_ERROR_COVARIANCE (location_type l)
      {
        return symbol_type (token::RESCALE_PREDICTION_ERROR_COVARIANCE, std::move (l));
      }
#else
      static
      symbol_type
      make_RESCALE_PREDICTION_ERROR_COVARIANCE (const location_type& l)
      {
        return symbol_type (token::RESCALE_PREDICTION_ERROR_COVARIANCE, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_GENERATE_IRFS (location_type l)
      {
        return symbol_type (token::GENERATE_IRFS, std::move (l));
      }
#else
      static
      symbol_type
      make_GENERATE_IRFS (const location_type& l)
      {
        return symbol_type (token::GENERATE_IRFS, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_NAN_CONSTANT (location_type l)
      {
        return symbol_type (token::NAN_CONSTANT, std::move (l));
      }
#else
      static
      symbol_type
      make_NAN_CONSTANT (const location_type& l)
      {
        return symbol_type (token::NAN_CONSTANT, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_NO_STATIC (location_type l)
      {
        return symbol_type (token::NO_STATIC, std::move (l));
      }
#else
      static
      symbol_type
      make_NO_STATIC (const location_type& l)
      {
        return symbol_type (token::NO_STATIC, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_NOBS (location_type l)
      {
        return symbol_type (token::NOBS, std::move (l));
      }
#else
      static
      symbol_type
      make_NOBS (const location_type& l)
      {
        return symbol_type (token::NOBS, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_NOCONSTANT (location_type l)
      {
        return symbol_type (token::NOCONSTANT, std::move (l));
      }
#else
      static
      symbol_type
      make_NOCONSTANT (const location_type& l)
      {
        return symbol_type (token::NOCONSTANT, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_NODISPLAY (location_type l)
      {
        return symbol_type (token::NODISPLAY, std::move (l));
      }
#else
      static
      symbol_type
      make_NODISPLAY (const location_type& l)
      {
        return symbol_type (token::NODISPLAY, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_NOCORR (location_type l)
      {
        return symbol_type (token::NOCORR, std::move (l));
      }
#else
      static
      symbol_type
      make_NOCORR (const location_type& l)
      {
        return symbol_type (token::NOCORR, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_NODIAGNOSTIC (location_type l)
      {
        return symbol_type (token::NODIAGNOSTIC, std::move (l));
      }
#else
      static
      symbol_type
      make_NODIAGNOSTIC (const location_type& l)
      {
        return symbol_type (token::NODIAGNOSTIC, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_NOFUNCTIONS (location_type l)
      {
        return symbol_type (token::NOFUNCTIONS, std::move (l));
      }
#else
      static
      symbol_type
      make_NOFUNCTIONS (const location_type& l)
      {
        return symbol_type (token::NOFUNCTIONS, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_NO_HOMOTOPY (location_type l)
      {
        return symbol_type (token::NO_HOMOTOPY, std::move (l));
      }
#else
      static
      symbol_type
      make_NO_HOMOTOPY (const location_type& l)
      {
        return symbol_type (token::NO_HOMOTOPY, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_NOGRAPH (location_type l)
      {
        return symbol_type (token::NOGRAPH, std::move (l));
      }
#else
      static
      symbol_type
      make_NOGRAPH (const location_type& l)
      {
        return symbol_type (token::NOGRAPH, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_POSTERIOR_NOGRAPH (location_type l)
      {
        return symbol_type (token::POSTERIOR_NOGRAPH, std::move (l));
      }
#else
      static
      symbol_type
      make_POSTERIOR_NOGRAPH (const location_type& l)
      {
        return symbol_type (token::POSTERIOR_NOGRAPH, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_POSTERIOR_GRAPH (location_type l)
      {
        return symbol_type (token::POSTERIOR_GRAPH, std::move (l));
      }
#else
      static
      symbol_type
      make_POSTERIOR_GRAPH (const location_type& l)
      {
        return symbol_type (token::POSTERIOR_GRAPH, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_NOMOMENTS (location_type l)
      {
        return symbol_type (token::NOMOMENTS, std::move (l));
      }
#else
      static
      symbol_type
      make_NOMOMENTS (const location_type& l)
      {
        return symbol_type (token::NOMOMENTS, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_NOPRINT (location_type l)
      {
        return symbol_type (token::NOPRINT, std::move (l));
      }
#else
      static
      symbol_type
      make_NOPRINT (const location_type& l)
      {
        return symbol_type (token::NOPRINT, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_NORMAL_PDF (location_type l)
      {
        return symbol_type (token::NORMAL_PDF, std::move (l));
      }
#else
      static
      symbol_type
      make_NORMAL_PDF (const location_type& l)
      {
        return symbol_type (token::NORMAL_PDF, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_SAVE_DRAWS (location_type l)
      {
        return symbol_type (token::SAVE_DRAWS, std::move (l));
      }
#else
      static
      symbol_type
      make_SAVE_DRAWS (const location_type& l)
      {
        return symbol_type (token::SAVE_DRAWS, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_MODEL_NAME (location_type l)
      {
        return symbol_type (token::MODEL_NAME, std::move (l));
      }
#else
      static
      symbol_type
      make_MODEL_NAME (const location_type& l)
      {
        return symbol_type (token::MODEL_NAME, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_STDERR_MULTIPLES (location_type l)
      {
        return symbol_type (token::STDERR_MULTIPLES, std::move (l));
      }
#else
      static
      symbol_type
      make_STDERR_MULTIPLES (const location_type& l)
      {
        return symbol_type (token::STDERR_MULTIPLES, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_DIAGONAL_ONLY (location_type l)
      {
        return symbol_type (token::DIAGONAL_ONLY, std::move (l));
      }
#else
      static
      symbol_type
      make_DIAGONAL_ONLY (const location_type& l)
      {
        return symbol_type (token::DIAGONAL_ONLY, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_OBSERVATION_TRENDS (location_type l)
      {
        return symbol_type (token::OBSERVATION_TRENDS, std::move (l));
      }
#else
      static
      symbol_type
      make_OBSERVATION_TRENDS (const location_type& l)
      {
        return symbol_type (token::OBSERVATION_TRENDS, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_OPTIM (location_type l)
      {
        return symbol_type (token::OPTIM, std::move (l));
      }
#else
      static
      symbol_type
      make_OPTIM (const location_type& l)
      {
        return symbol_type (token::OPTIM, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_OPTIM_WEIGHTS (location_type l)
      {
        return symbol_type (token::OPTIM_WEIGHTS, std::move (l));
      }
#else
      static
      symbol_type
      make_OPTIM_WEIGHTS (const location_type& l)
      {
        return symbol_type (token::OPTIM_WEIGHTS, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_ORDER (location_type l)
      {
        return symbol_type (token::ORDER, std::move (l));
      }
#else
      static
      symbol_type
      make_ORDER (const location_type& l)
      {
        return symbol_type (token::ORDER, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_OSR (location_type l)
      {
        return symbol_type (token::OSR, std::move (l));
      }
#else
      static
      symbol_type
      make_OSR (const location_type& l)
      {
        return symbol_type (token::OSR, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_OSR_PARAMS (location_type l)
      {
        return symbol_type (token::OSR_PARAMS, std::move (l));
      }
#else
      static
      symbol_type
      make_OSR_PARAMS (const location_type& l)
      {
        return symbol_type (token::OSR_PARAMS, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_MAX_DIM_COVA_GROUP (location_type l)
      {
        return symbol_type (token::MAX_DIM_COVA_GROUP, std::move (l));
      }
#else
      static
      symbol_type
      make_MAX_DIM_COVA_GROUP (const location_type& l)
      {
        return symbol_type (token::MAX_DIM_COVA_GROUP, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_ADVANCED (location_type l)
      {
        return symbol_type (token::ADVANCED, std::move (l));
      }
#else
      static
      symbol_type
      make_ADVANCED (const location_type& l)
      {
        return symbol_type (token::ADVANCED, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_OUTFILE (location_type l)
      {
        return symbol_type (token::OUTFILE, std::move (l));
      }
#else
      static
      symbol_type
      make_OUTFILE (const location_type& l)
      {
        return symbol_type (token::OUTFILE, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_OUTVARS (location_type l)
      {
        return symbol_type (token::OUTVARS, std::move (l));
      }
#else
      static
      symbol_type
      make_OUTVARS (const location_type& l)
      {
        return symbol_type (token::OUTVARS, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_OVERWRITE (location_type l)
      {
        return symbol_type (token::OVERWRITE, std::move (l));
      }
#else
      static
      symbol_type
      make_OVERWRITE (const location_type& l)
      {
        return symbol_type (token::OVERWRITE, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_DISCOUNT (location_type l)
      {
        return symbol_type (token::DISCOUNT, std::move (l));
      }
#else
      static
      symbol_type
      make_DISCOUNT (const location_type& l)
      {
        return symbol_type (token::DISCOUNT, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_PARALLEL_LOCAL_FILES (location_type l)
      {
        return symbol_type (token::PARALLEL_LOCAL_FILES, std::move (l));
      }
#else
      static
      symbol_type
      make_PARALLEL_LOCAL_FILES (const location_type& l)
      {
        return symbol_type (token::PARALLEL_LOCAL_FILES, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_PARAMETERS (location_type l)
      {
        return symbol_type (token::PARAMETERS, std::move (l));
      }
#else
      static
      symbol_type
      make_PARAMETERS (const location_type& l)
      {
        return symbol_type (token::PARAMETERS, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_PARAMETER_SET (location_type l)
      {
        return symbol_type (token::PARAMETER_SET, std::move (l));
      }
#else
      static
      symbol_type
      make_PARAMETER_SET (const location_type& l)
      {
        return symbol_type (token::PARAMETER_SET, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_PARTIAL_INFORMATION (location_type l)
      {
        return symbol_type (token::PARTIAL_INFORMATION, std::move (l));
      }
#else
      static
      symbol_type
      make_PARTIAL_INFORMATION (const location_type& l)
      {
        return symbol_type (token::PARTIAL_INFORMATION, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_PERIODS (location_type l)
      {
        return symbol_type (token::PERIODS, std::move (l));
      }
#else
      static
      symbol_type
      make_PERIODS (const location_type& l)
      {
        return symbol_type (token::PERIODS, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_PERIOD (location_type l)
      {
        return symbol_type (token::PERIOD, std::move (l));
      }
#else
      static
      symbol_type
      make_PERIOD (const location_type& l)
      {
        return symbol_type (token::PERIOD, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_PLANNER_OBJECTIVE (location_type l)
      {
        return symbol_type (token::PLANNER_OBJECTIVE, std::move (l));
      }
#else
      static
      symbol_type
      make_PLANNER_OBJECTIVE (const location_type& l)
      {
        return symbol_type (token::PLANNER_OBJECTIVE, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_PLOT_CONDITIONAL_FORECAST (location_type l)
      {
        return symbol_type (token::PLOT_CONDITIONAL_FORECAST, std::move (l));
      }
#else
      static
      symbol_type
      make_PLOT_CONDITIONAL_FORECAST (const location_type& l)
      {
        return symbol_type (token::PLOT_CONDITIONAL_FORECAST, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_PLOT_PRIORS (location_type l)
      {
        return symbol_type (token::PLOT_PRIORS, std::move (l));
      }
#else
      static
      symbol_type
      make_PLOT_PRIORS (const location_type& l)
      {
        return symbol_type (token::PLOT_PRIORS, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_PREFILTER (location_type l)
      {
        return symbol_type (token::PREFILTER, std::move (l));
      }
#else
      static
      symbol_type
      make_PREFILTER (const location_type& l)
      {
        return symbol_type (token::PREFILTER, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_PRESAMPLE (location_type l)
      {
        return symbol_type (token::PRESAMPLE, std::move (l));
      }
#else
      static
      symbol_type
      make_PRESAMPLE (const location_type& l)
      {
        return symbol_type (token::PRESAMPLE, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_PERFECT_FORESIGHT_SETUP (location_type l)
      {
        return symbol_type (token::PERFECT_FORESIGHT_SETUP, std::move (l));
      }
#else
      static
      symbol_type
      make_PERFECT_FORESIGHT_SETUP (const location_type& l)
      {
        return symbol_type (token::PERFECT_FORESIGHT_SETUP, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_PERFECT_FORESIGHT_SOLVER (location_type l)
      {
        return symbol_type (token::PERFECT_FORESIGHT_SOLVER, std::move (l));
      }
#else
      static
      symbol_type
      make_PERFECT_FORESIGHT_SOLVER (const location_type& l)
      {
        return symbol_type (token::PERFECT_FORESIGHT_SOLVER, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_NO_POSTERIOR_KERNEL_DENSITY (location_type l)
      {
        return symbol_type (token::NO_POSTERIOR_KERNEL_DENSITY, std::move (l));
      }
#else
      static
      symbol_type
      make_NO_POSTERIOR_KERNEL_DENSITY (const location_type& l)
      {
        return symbol_type (token::NO_POSTERIOR_KERNEL_DENSITY, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_FUNCTION (location_type l)
      {
        return symbol_type (token::FUNCTION, std::move (l));
      }
#else
      static
      symbol_type
      make_FUNCTION (const location_type& l)
      {
        return symbol_type (token::FUNCTION, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_PRINT (location_type l)
      {
        return symbol_type (token::PRINT, std::move (l));
      }
#else
      static
      symbol_type
      make_PRINT (const location_type& l)
      {
        return symbol_type (token::PRINT, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_PRIOR_MC (location_type l)
      {
        return symbol_type (token::PRIOR_MC, std::move (l));
      }
#else
      static
      symbol_type
      make_PRIOR_MC (const location_type& l)
      {
        return symbol_type (token::PRIOR_MC, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_PRIOR_TRUNC (location_type l)
      {
        return symbol_type (token::PRIOR_TRUNC, std::move (l));
      }
#else
      static
      symbol_type
      make_PRIOR_TRUNC (const location_type& l)
      {
        return symbol_type (token::PRIOR_TRUNC, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_PRIOR_MODE (location_type l)
      {
        return symbol_type (token::PRIOR_MODE, std::move (l));
      }
#else
      static
      symbol_type
      make_PRIOR_MODE (const location_type& l)
      {
        return symbol_type (token::PRIOR_MODE, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_PRIOR_MEAN (location_type l)
      {
        return symbol_type (token::PRIOR_MEAN, std::move (l));
      }
#else
      static
      symbol_type
      make_PRIOR_MEAN (const location_type& l)
      {
        return symbol_type (token::PRIOR_MEAN, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_POSTERIOR_MODE (location_type l)
      {
        return symbol_type (token::POSTERIOR_MODE, std::move (l));
      }
#else
      static
      symbol_type
      make_POSTERIOR_MODE (const location_type& l)
      {
        return symbol_type (token::POSTERIOR_MODE, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_POSTERIOR_MEAN (location_type l)
      {
        return symbol_type (token::POSTERIOR_MEAN, std::move (l));
      }
#else
      static
      symbol_type
      make_POSTERIOR_MEAN (const location_type& l)
      {
        return symbol_type (token::POSTERIOR_MEAN, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_POSTERIOR_MEDIAN (location_type l)
      {
        return symbol_type (token::POSTERIOR_MEDIAN, std::move (l));
      }
#else
      static
      symbol_type
      make_POSTERIOR_MEDIAN (const location_type& l)
      {
        return symbol_type (token::POSTERIOR_MEDIAN, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_MLE_MODE (location_type l)
      {
        return symbol_type (token::MLE_MODE, std::move (l));
      }
#else
      static
      symbol_type
      make_MLE_MODE (const location_type& l)
      {
        return symbol_type (token::MLE_MODE, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_PRUNING (location_type l)
      {
        return symbol_type (token::PRUNING, std::move (l));
      }
#else
      static
      symbol_type
      make_PRUNING (const location_type& l)
      {
        return symbol_type (token::PRUNING, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_QUOTED_STRING (string v, location_type l)
      {
        return symbol_type (token::QUOTED_STRING, std::move (v), std::move (l));
      }
#else
      static
      symbol_type
      make_QUOTED_STRING (const string& v, const location_type& l)
      {
        return symbol_type (token::QUOTED_STRING, v, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_QZ_CRITERIUM (location_type l)
      {
        return symbol_type (token::QZ_CRITERIUM, std::move (l));
      }
#else
      static
      symbol_type
      make_QZ_CRITERIUM (const location_type& l)
      {
        return symbol_type (token::QZ_CRITERIUM, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_QZ_ZERO_THRESHOLD (location_type l)
      {
        return symbol_type (token::QZ_ZERO_THRESHOLD, std::move (l));
      }
#else
      static
      symbol_type
      make_QZ_ZERO_THRESHOLD (const location_type& l)
      {
        return symbol_type (token::QZ_ZERO_THRESHOLD, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_DSGE_VAR (location_type l)
      {
        return symbol_type (token::DSGE_VAR, std::move (l));
      }
#else
      static
      symbol_type
      make_DSGE_VAR (const location_type& l)
      {
        return symbol_type (token::DSGE_VAR, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_DSGE_VARLAG (location_type l)
      {
        return symbol_type (token::DSGE_VARLAG, std::move (l));
      }
#else
      static
      symbol_type
      make_DSGE_VARLAG (const location_type& l)
      {
        return symbol_type (token::DSGE_VARLAG, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_DSGE_PRIOR_WEIGHT (location_type l)
      {
        return symbol_type (token::DSGE_PRIOR_WEIGHT, std::move (l));
      }
#else
      static
      symbol_type
      make_DSGE_PRIOR_WEIGHT (const location_type& l)
      {
        return symbol_type (token::DSGE_PRIOR_WEIGHT, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_TRUNCATE (location_type l)
      {
        return symbol_type (token::TRUNCATE, std::move (l));
      }
#else
      static
      symbol_type
      make_TRUNCATE (const location_type& l)
      {
        return symbol_type (token::TRUNCATE, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_PIPE_E (location_type l)
      {
        return symbol_type (token::PIPE_E, std::move (l));
      }
#else
      static
      symbol_type
      make_PIPE_E (const location_type& l)
      {
        return symbol_type (token::PIPE_E, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_PIPE_X (location_type l)
      {
        return symbol_type (token::PIPE_X, std::move (l));
      }
#else
      static
      symbol_type
      make_PIPE_X (const location_type& l)
      {
        return symbol_type (token::PIPE_X, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_PIPE_P (location_type l)
      {
        return symbol_type (token::PIPE_P, std::move (l));
      }
#else
      static
      symbol_type
      make_PIPE_P (const location_type& l)
      {
        return symbol_type (token::PIPE_P, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_RELATIVE_IRF (location_type l)
      {
        return symbol_type (token::RELATIVE_IRF, std::move (l));
      }
#else
      static
      symbol_type
      make_RELATIVE_IRF (const location_type& l)
      {
        return symbol_type (token::RELATIVE_IRF, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_REPLIC (location_type l)
      {
        return symbol_type (token::REPLIC, std::move (l));
      }
#else
      static
      symbol_type
      make_REPLIC (const location_type& l)
      {
        return symbol_type (token::REPLIC, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_SIMUL_REPLIC (location_type l)
      {
        return symbol_type (token::SIMUL_REPLIC, std::move (l));
      }
#else
      static
      symbol_type
      make_SIMUL_REPLIC (const location_type& l)
      {
        return symbol_type (token::SIMUL_REPLIC, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_RPLOT (location_type l)
      {
        return symbol_type (token::RPLOT, std::move (l));
      }
#else
      static
      symbol_type
      make_RPLOT (const location_type& l)
      {
        return symbol_type (token::RPLOT, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_SAVE_PARAMS_AND_STEADY_STATE (location_type l)
      {
        return symbol_type (token::SAVE_PARAMS_AND_STEADY_STATE, std::move (l));
      }
#else
      static
      symbol_type
      make_SAVE_PARAMS_AND_STEADY_STATE (const location_type& l)
      {
        return symbol_type (token::SAVE_PARAMS_AND_STEADY_STATE, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_PARAMETER_UNCERTAINTY (location_type l)
      {
        return symbol_type (token::PARAMETER_UNCERTAINTY, std::move (l));
      }
#else
      static
      symbol_type
      make_PARAMETER_UNCERTAINTY (const location_type& l)
      {
        return symbol_type (token::PARAMETER_UNCERTAINTY, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_TARGETS (location_type l)
      {
        return symbol_type (token::TARGETS, std::move (l));
      }
#else
      static
      symbol_type
      make_TARGETS (const location_type& l)
      {
        return symbol_type (token::TARGETS, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_SHOCKS (location_type l)
      {
        return symbol_type (token::SHOCKS, std::move (l));
      }
#else
      static
      symbol_type
      make_SHOCKS (const location_type& l)
      {
        return symbol_type (token::SHOCKS, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_SHOCK_DECOMPOSITION (location_type l)
      {
        return symbol_type (token::SHOCK_DECOMPOSITION, std::move (l));
      }
#else
      static
      symbol_type
      make_SHOCK_DECOMPOSITION (const location_type& l)
      {
        return symbol_type (token::SHOCK_DECOMPOSITION, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_SHOCK_GROUPS (location_type l)
      {
        return symbol_type (token::SHOCK_GROUPS, std::move (l));
      }
#else
      static
      symbol_type
      make_SHOCK_GROUPS (const location_type& l)
      {
        return symbol_type (token::SHOCK_GROUPS, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_USE_SHOCK_GROUPS (location_type l)
      {
        return symbol_type (token::USE_SHOCK_GROUPS, std::move (l));
      }
#else
      static
      symbol_type
      make_USE_SHOCK_GROUPS (const location_type& l)
      {
        return symbol_type (token::USE_SHOCK_GROUPS, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_SIGMA_E (location_type l)
      {
        return symbol_type (token::SIGMA_E, std::move (l));
      }
#else
      static
      symbol_type
      make_SIGMA_E (const location_type& l)
      {
        return symbol_type (token::SIGMA_E, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_SIMUL (location_type l)
      {
        return symbol_type (token::SIMUL, std::move (l));
      }
#else
      static
      symbol_type
      make_SIMUL (const location_type& l)
      {
        return symbol_type (token::SIMUL, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_SIMUL_ALGO (location_type l)
      {
        return symbol_type (token::SIMUL_ALGO, std::move (l));
      }
#else
      static
      symbol_type
      make_SIMUL_ALGO (const location_type& l)
      {
        return symbol_type (token::SIMUL_ALGO, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_SIMUL_SEED (location_type l)
      {
        return symbol_type (token::SIMUL_SEED, std::move (l));
      }
#else
      static
      symbol_type
      make_SIMUL_SEED (const location_type& l)
      {
        return symbol_type (token::SIMUL_SEED, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_ENDOGENOUS_TERMINAL_PERIOD (location_type l)
      {
        return symbol_type (token::ENDOGENOUS_TERMINAL_PERIOD, std::move (l));
      }
#else
      static
      symbol_type
      make_ENDOGENOUS_TERMINAL_PERIOD (const location_type& l)
      {
        return symbol_type (token::ENDOGENOUS_TERMINAL_PERIOD, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_SMOOTHER (location_type l)
      {
        return symbol_type (token::SMOOTHER, std::move (l));
      }
#else
      static
      symbol_type
      make_SMOOTHER (const location_type& l)
      {
        return symbol_type (token::SMOOTHER, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_SMOOTHER2HISTVAL (location_type l)
      {
        return symbol_type (token::SMOOTHER2HISTVAL, std::move (l));
      }
#else
      static
      symbol_type
      make_SMOOTHER2HISTVAL (const location_type& l)
      {
        return symbol_type (token::SMOOTHER2HISTVAL, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_SQUARE_ROOT_SOLVER (location_type l)
      {
        return symbol_type (token::SQUARE_ROOT_SOLVER, std::move (l));
      }
#else
      static
      symbol_type
      make_SQUARE_ROOT_SOLVER (const location_type& l)
      {
        return symbol_type (token::SQUARE_ROOT_SOLVER, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_STACK_SOLVE_ALGO (location_type l)
      {
        return symbol_type (token::STACK_SOLVE_ALGO, std::move (l));
      }
#else
      static
      symbol_type
      make_STACK_SOLVE_ALGO (const location_type& l)
      {
        return symbol_type (token::STACK_SOLVE_ALGO, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_STEADY_STATE_MODEL (location_type l)
      {
        return symbol_type (token::STEADY_STATE_MODEL, std::move (l));
      }
#else
      static
      symbol_type
      make_STEADY_STATE_MODEL (const location_type& l)
      {
        return symbol_type (token::STEADY_STATE_MODEL, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_SOLVE_ALGO (location_type l)
      {
        return symbol_type (token::SOLVE_ALGO, std::move (l));
      }
#else
      static
      symbol_type
      make_SOLVE_ALGO (const location_type& l)
      {
        return symbol_type (token::SOLVE_ALGO, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_SOLVER_PERIODS (location_type l)
      {
        return symbol_type (token::SOLVER_PERIODS, std::move (l));
      }
#else
      static
      symbol_type
      make_SOLVER_PERIODS (const location_type& l)
      {
        return symbol_type (token::SOLVER_PERIODS, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_ROBUST_LIN_SOLVE (location_type l)
      {
        return symbol_type (token::ROBUST_LIN_SOLVE, std::move (l));
      }
#else
      static
      symbol_type
      make_ROBUST_LIN_SOLVE (const location_type& l)
      {
        return symbol_type (token::ROBUST_LIN_SOLVE, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_STDERR (location_type l)
      {
        return symbol_type (token::STDERR, std::move (l));
      }
#else
      static
      symbol_type
      make_STDERR (const location_type& l)
      {
        return symbol_type (token::STDERR, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_STEADY (location_type l)
      {
        return symbol_type (token::STEADY, std::move (l));
      }
#else
      static
      symbol_type
      make_STEADY (const location_type& l)
      {
        return symbol_type (token::STEADY, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_STOCH_SIMUL (location_type l)
      {
        return symbol_type (token::STOCH_SIMUL, std::move (l));
      }
#else
      static
      symbol_type
      make_STOCH_SIMUL (const location_type& l)
      {
        return symbol_type (token::STOCH_SIMUL, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_SYLVESTER (location_type l)
      {
        return symbol_type (token::SYLVESTER, std::move (l));
      }
#else
      static
      symbol_type
      make_SYLVESTER (const location_type& l)
      {
        return symbol_type (token::SYLVESTER, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_SYLVESTER_FIXED_POINT_TOL (location_type l)
      {
        return symbol_type (token::SYLVESTER_FIXED_POINT_TOL, std::move (l));
      }
#else
      static
      symbol_type
      make_SYLVESTER_FIXED_POINT_TOL (const location_type& l)
      {
        return symbol_type (token::SYLVESTER_FIXED_POINT_TOL, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_REGIMES (location_type l)
      {
        return symbol_type (token::REGIMES, std::move (l));
      }
#else
      static
      symbol_type
      make_REGIMES (const location_type& l)
      {
        return symbol_type (token::REGIMES, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_REGIME (location_type l)
      {
        return symbol_type (token::REGIME, std::move (l));
      }
#else
      static
      symbol_type
      make_REGIME (const location_type& l)
      {
        return symbol_type (token::REGIME, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_REALTIME_SHOCK_DECOMPOSITION (location_type l)
      {
        return symbol_type (token::REALTIME_SHOCK_DECOMPOSITION, std::move (l));
      }
#else
      static
      symbol_type
      make_REALTIME_SHOCK_DECOMPOSITION (const location_type& l)
      {
        return symbol_type (token::REALTIME_SHOCK_DECOMPOSITION, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_CONDITIONAL (location_type l)
      {
        return symbol_type (token::CONDITIONAL, std::move (l));
      }
#else
      static
      symbol_type
      make_CONDITIONAL (const location_type& l)
      {
        return symbol_type (token::CONDITIONAL, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_UNCONDITIONAL (location_type l)
      {
        return symbol_type (token::UNCONDITIONAL, std::move (l));
      }
#else
      static
      symbol_type
      make_UNCONDITIONAL (const location_type& l)
      {
        return symbol_type (token::UNCONDITIONAL, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_TEX (location_type l)
      {
        return symbol_type (token::TEX, std::move (l));
      }
#else
      static
      symbol_type
      make_TEX (const location_type& l)
      {
        return symbol_type (token::TEX, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_RAMSEY_MODEL (location_type l)
      {
        return symbol_type (token::RAMSEY_MODEL, std::move (l));
      }
#else
      static
      symbol_type
      make_RAMSEY_MODEL (const location_type& l)
      {
        return symbol_type (token::RAMSEY_MODEL, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_RAMSEY_POLICY (location_type l)
      {
        return symbol_type (token::RAMSEY_POLICY, std::move (l));
      }
#else
      static
      symbol_type
      make_RAMSEY_POLICY (const location_type& l)
      {
        return symbol_type (token::RAMSEY_POLICY, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_RAMSEY_CONSTRAINTS (location_type l)
      {
        return symbol_type (token::RAMSEY_CONSTRAINTS, std::move (l));
      }
#else
      static
      symbol_type
      make_RAMSEY_CONSTRAINTS (const location_type& l)
      {
        return symbol_type (token::RAMSEY_CONSTRAINTS, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_PLANNER_DISCOUNT (location_type l)
      {
        return symbol_type (token::PLANNER_DISCOUNT, std::move (l));
      }
#else
      static
      symbol_type
      make_PLANNER_DISCOUNT (const location_type& l)
      {
        return symbol_type (token::PLANNER_DISCOUNT, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_PLANNER_DISCOUNT_LATEX_NAME (location_type l)
      {
        return symbol_type (token::PLANNER_DISCOUNT_LATEX_NAME, std::move (l));
      }
#else
      static
      symbol_type
      make_PLANNER_DISCOUNT_LATEX_NAME (const location_type& l)
      {
        return symbol_type (token::PLANNER_DISCOUNT_LATEX_NAME, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_DISCRETIONARY_POLICY (location_type l)
      {
        return symbol_type (token::DISCRETIONARY_POLICY, std::move (l));
      }
#else
      static
      symbol_type
      make_DISCRETIONARY_POLICY (const location_type& l)
      {
        return symbol_type (token::DISCRETIONARY_POLICY, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_DISCRETIONARY_TOL (location_type l)
      {
        return symbol_type (token::DISCRETIONARY_TOL, std::move (l));
      }
#else
      static
      symbol_type
      make_DISCRETIONARY_TOL (const location_type& l)
      {
        return symbol_type (token::DISCRETIONARY_TOL, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_EVALUATE_PLANNER_OBJECTIVE (location_type l)
      {
        return symbol_type (token::EVALUATE_PLANNER_OBJECTIVE, std::move (l));
      }
#else
      static
      symbol_type
      make_EVALUATE_PLANNER_OBJECTIVE (const location_type& l)
      {
        return symbol_type (token::EVALUATE_PLANNER_OBJECTIVE, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_TEX_NAME (string v, location_type l)
      {
        return symbol_type (token::TEX_NAME, std::move (v), std::move (l));
      }
#else
      static
      symbol_type
      make_TEX_NAME (const string& v, const location_type& l)
      {
        return symbol_type (token::TEX_NAME, v, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_UNIFORM_PDF (location_type l)
      {
        return symbol_type (token::UNIFORM_PDF, std::move (l));
      }
#else
      static
      symbol_type
      make_UNIFORM_PDF (const location_type& l)
      {
        return symbol_type (token::UNIFORM_PDF, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_UNIT_ROOT_VARS (location_type l)
      {
        return symbol_type (token::UNIT_ROOT_VARS, std::move (l));
      }
#else
      static
      symbol_type
      make_UNIT_ROOT_VARS (const location_type& l)
      {
        return symbol_type (token::UNIT_ROOT_VARS, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_USE_DLL (location_type l)
      {
        return symbol_type (token::USE_DLL, std::move (l));
      }
#else
      static
      symbol_type
      make_USE_DLL (const location_type& l)
      {
        return symbol_type (token::USE_DLL, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_USEAUTOCORR (location_type l)
      {
        return symbol_type (token::USEAUTOCORR, std::move (l));
      }
#else
      static
      symbol_type
      make_USEAUTOCORR (const location_type& l)
      {
        return symbol_type (token::USEAUTOCORR, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_GSA_SAMPLE_FILE (location_type l)
      {
        return symbol_type (token::GSA_SAMPLE_FILE, std::move (l));
      }
#else
      static
      symbol_type
      make_GSA_SAMPLE_FILE (const location_type& l)
      {
        return symbol_type (token::GSA_SAMPLE_FILE, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_USE_UNIVARIATE_FILTERS_IF_SINGULARITY_IS_DETECTED (location_type l)
      {
        return symbol_type (token::USE_UNIVARIATE_FILTERS_IF_SINGULARITY_IS_DETECTED, std::move (l));
      }
#else
      static
      symbol_type
      make_USE_UNIVARIATE_FILTERS_IF_SINGULARITY_IS_DETECTED (const location_type& l)
      {
        return symbol_type (token::USE_UNIVARIATE_FILTERS_IF_SINGULARITY_IS_DETECTED, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_VALUES (location_type l)
      {
        return symbol_type (token::VALUES, std::move (l));
      }
#else
      static
      symbol_type
      make_VALUES (const location_type& l)
      {
        return symbol_type (token::VALUES, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_VAR (location_type l)
      {
        return symbol_type (token::VAR, std::move (l));
      }
#else
      static
      symbol_type
      make_VAR (const location_type& l)
      {
        return symbol_type (token::VAR, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_VAREXO (location_type l)
      {
        return symbol_type (token::VAREXO, std::move (l));
      }
#else
      static
      symbol_type
      make_VAREXO (const location_type& l)
      {
        return symbol_type (token::VAREXO, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_VAREXO_DET (location_type l)
      {
        return symbol_type (token::VAREXO_DET, std::move (l));
      }
#else
      static
      symbol_type
      make_VAREXO_DET (const location_type& l)
      {
        return symbol_type (token::VAREXO_DET, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_VARIABLE (location_type l)
      {
        return symbol_type (token::VARIABLE, std::move (l));
      }
#else
      static
      symbol_type
      make_VARIABLE (const location_type& l)
      {
        return symbol_type (token::VARIABLE, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_VAROBS (location_type l)
      {
        return symbol_type (token::VAROBS, std::move (l));
      }
#else
      static
      symbol_type
      make_VAROBS (const location_type& l)
      {
        return symbol_type (token::VAROBS, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_VAREXOBS (location_type l)
      {
        return symbol_type (token::VAREXOBS, std::move (l));
      }
#else
      static
      symbol_type
      make_VAREXOBS (const location_type& l)
      {
        return symbol_type (token::VAREXOBS, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_PREDETERMINED_VARIABLES (location_type l)
      {
        return symbol_type (token::PREDETERMINED_VARIABLES, std::move (l));
      }
#else
      static
      symbol_type
      make_PREDETERMINED_VARIABLES (const location_type& l)
      {
        return symbol_type (token::PREDETERMINED_VARIABLES, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_VAR_EXPECTATION (location_type l)
      {
        return symbol_type (token::VAR_EXPECTATION, std::move (l));
      }
#else
      static
      symbol_type
      make_VAR_EXPECTATION (const location_type& l)
      {
        return symbol_type (token::VAR_EXPECTATION, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_VAR_EXPECTATION_MODEL (location_type l)
      {
        return symbol_type (token::VAR_EXPECTATION_MODEL, std::move (l));
      }
#else
      static
      symbol_type
      make_VAR_EXPECTATION_MODEL (const location_type& l)
      {
        return symbol_type (token::VAR_EXPECTATION_MODEL, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_PLOT_SHOCK_DECOMPOSITION (location_type l)
      {
        return symbol_type (token::PLOT_SHOCK_DECOMPOSITION, std::move (l));
      }
#else
      static
      symbol_type
      make_PLOT_SHOCK_DECOMPOSITION (const location_type& l)
      {
        return symbol_type (token::PLOT_SHOCK_DECOMPOSITION, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_MODEL_LOCAL_VARIABLE (location_type l)
      {
        return symbol_type (token::MODEL_LOCAL_VARIABLE, std::move (l));
      }
#else
      static
      symbol_type
      make_MODEL_LOCAL_VARIABLE (const location_type& l)
      {
        return symbol_type (token::MODEL_LOCAL_VARIABLE, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_WRITE_LATEX_DYNAMIC_MODEL (location_type l)
      {
        return symbol_type (token::WRITE_LATEX_DYNAMIC_MODEL, std::move (l));
      }
#else
      static
      symbol_type
      make_WRITE_LATEX_DYNAMIC_MODEL (const location_type& l)
      {
        return symbol_type (token::WRITE_LATEX_DYNAMIC_MODEL, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_WRITE_LATEX_STATIC_MODEL (location_type l)
      {
        return symbol_type (token::WRITE_LATEX_STATIC_MODEL, std::move (l));
      }
#else
      static
      symbol_type
      make_WRITE_LATEX_STATIC_MODEL (const location_type& l)
      {
        return symbol_type (token::WRITE_LATEX_STATIC_MODEL, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_WRITE_LATEX_ORIGINAL_MODEL (location_type l)
      {
        return symbol_type (token::WRITE_LATEX_ORIGINAL_MODEL, std::move (l));
      }
#else
      static
      symbol_type
      make_WRITE_LATEX_ORIGINAL_MODEL (const location_type& l)
      {
        return symbol_type (token::WRITE_LATEX_ORIGINAL_MODEL, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_CROSSEQUATIONS (location_type l)
      {
        return symbol_type (token::CROSSEQUATIONS, std::move (l));
      }
#else
      static
      symbol_type
      make_CROSSEQUATIONS (const location_type& l)
      {
        return symbol_type (token::CROSSEQUATIONS, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_COVARIANCE (location_type l)
      {
        return symbol_type (token::COVARIANCE, std::move (l));
      }
#else
      static
      symbol_type
      make_COVARIANCE (const location_type& l)
      {
        return symbol_type (token::COVARIANCE, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_WRITE_LATEX_STEADY_STATE_MODEL (location_type l)
      {
        return symbol_type (token::WRITE_LATEX_STEADY_STATE_MODEL, std::move (l));
      }
#else
      static
      symbol_type
      make_WRITE_LATEX_STEADY_STATE_MODEL (const location_type& l)
      {
        return symbol_type (token::WRITE_LATEX_STEADY_STATE_MODEL, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_XLS_SHEET (location_type l)
      {
        return symbol_type (token::XLS_SHEET, std::move (l));
      }
#else
      static
      symbol_type
      make_XLS_SHEET (const location_type& l)
      {
        return symbol_type (token::XLS_SHEET, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_XLS_RANGE (location_type l)
      {
        return symbol_type (token::XLS_RANGE, std::move (l));
      }
#else
      static
      symbol_type
      make_XLS_RANGE (const location_type& l)
      {
        return symbol_type (token::XLS_RANGE, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_LMMCP (location_type l)
      {
        return symbol_type (token::LMMCP, std::move (l));
      }
#else
      static
      symbol_type
      make_LMMCP (const location_type& l)
      {
        return symbol_type (token::LMMCP, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_OCCBIN (location_type l)
      {
        return symbol_type (token::OCCBIN, std::move (l));
      }
#else
      static
      symbol_type
      make_OCCBIN (const location_type& l)
      {
        return symbol_type (token::OCCBIN, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_BANDPASS_FILTER (location_type l)
      {
        return symbol_type (token::BANDPASS_FILTER, std::move (l));
      }
#else
      static
      symbol_type
      make_BANDPASS_FILTER (const location_type& l)
      {
        return symbol_type (token::BANDPASS_FILTER, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_COLORMAP (location_type l)
      {
        return symbol_type (token::COLORMAP, std::move (l));
      }
#else
      static
      symbol_type
      make_COLORMAP (const location_type& l)
      {
        return symbol_type (token::COLORMAP, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_VAR_MODEL (location_type l)
      {
        return symbol_type (token::VAR_MODEL, std::move (l));
      }
#else
      static
      symbol_type
      make_VAR_MODEL (const location_type& l)
      {
        return symbol_type (token::VAR_MODEL, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_PAC_MODEL (location_type l)
      {
        return symbol_type (token::PAC_MODEL, std::move (l));
      }
#else
      static
      symbol_type
      make_PAC_MODEL (const location_type& l)
      {
        return symbol_type (token::PAC_MODEL, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_QOQ (location_type l)
      {
        return symbol_type (token::QOQ, std::move (l));
      }
#else
      static
      symbol_type
      make_QOQ (const location_type& l)
      {
        return symbol_type (token::QOQ, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_YOY (location_type l)
      {
        return symbol_type (token::YOY, std::move (l));
      }
#else
      static
      symbol_type
      make_YOY (const location_type& l)
      {
        return symbol_type (token::YOY, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_AOA (location_type l)
      {
        return symbol_type (token::AOA, std::move (l));
      }
#else
      static
      symbol_type
      make_AOA (const location_type& l)
      {
        return symbol_type (token::AOA, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_PAC_EXPECTATION (location_type l)
      {
        return symbol_type (token::PAC_EXPECTATION, std::move (l));
      }
#else
      static
      symbol_type
      make_PAC_EXPECTATION (const location_type& l)
      {
        return symbol_type (token::PAC_EXPECTATION, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_TREND_COMPONENT_MODEL (location_type l)
      {
        return symbol_type (token::TREND_COMPONENT_MODEL, std::move (l));
      }
#else
      static
      symbol_type
      make_TREND_COMPONENT_MODEL (const location_type& l)
      {
        return symbol_type (token::TREND_COMPONENT_MODEL, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_EQUAL_EQUAL (location_type l)
      {
        return symbol_type (token::EQUAL_EQUAL, std::move (l));
      }
#else
      static
      symbol_type
      make_EQUAL_EQUAL (const location_type& l)
      {
        return symbol_type (token::EQUAL_EQUAL, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_EXCLAMATION_EQUAL (location_type l)
      {
        return symbol_type (token::EXCLAMATION_EQUAL, std::move (l));
      }
#else
      static
      symbol_type
      make_EXCLAMATION_EQUAL (const location_type& l)
      {
        return symbol_type (token::EXCLAMATION_EQUAL, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_LESS (location_type l)
      {
        return symbol_type (token::LESS, std::move (l));
      }
#else
      static
      symbol_type
      make_LESS (const location_type& l)
      {
        return symbol_type (token::LESS, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_GREATER (location_type l)
      {
        return symbol_type (token::GREATER, std::move (l));
      }
#else
      static
      symbol_type
      make_GREATER (const location_type& l)
      {
        return symbol_type (token::GREATER, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_LESS_EQUAL (location_type l)
      {
        return symbol_type (token::LESS_EQUAL, std::move (l));
      }
#else
      static
      symbol_type
      make_LESS_EQUAL (const location_type& l)
      {
        return symbol_type (token::LESS_EQUAL, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_GREATER_EQUAL (location_type l)
      {
        return symbol_type (token::GREATER_EQUAL, std::move (l));
      }
#else
      static
      symbol_type
      make_GREATER_EQUAL (const location_type& l)
      {
        return symbol_type (token::GREATER_EQUAL, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_PLUS (location_type l)
      {
        return symbol_type (token::PLUS, std::move (l));
      }
#else
      static
      symbol_type
      make_PLUS (const location_type& l)
      {
        return symbol_type (token::PLUS, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_MINUS (location_type l)
      {
        return symbol_type (token::MINUS, std::move (l));
      }
#else
      static
      symbol_type
      make_MINUS (const location_type& l)
      {
        return symbol_type (token::MINUS, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_TIMES (location_type l)
      {
        return symbol_type (token::TIMES, std::move (l));
      }
#else
      static
      symbol_type
      make_TIMES (const location_type& l)
      {
        return symbol_type (token::TIMES, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_DIVIDE (location_type l)
      {
        return symbol_type (token::DIVIDE, std::move (l));
      }
#else
      static
      symbol_type
      make_DIVIDE (const location_type& l)
      {
        return symbol_type (token::DIVIDE, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_UNARY (location_type l)
      {
        return symbol_type (token::UNARY, std::move (l));
      }
#else
      static
      symbol_type
      make_UNARY (const location_type& l)
      {
        return symbol_type (token::UNARY, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_POWER (location_type l)
      {
        return symbol_type (token::POWER, std::move (l));
      }
#else
      static
      symbol_type
      make_POWER (const location_type& l)
      {
        return symbol_type (token::POWER, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_EXP (location_type l)
      {
        return symbol_type (token::EXP, std::move (l));
      }
#else
      static
      symbol_type
      make_EXP (const location_type& l)
      {
        return symbol_type (token::EXP, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_LOG (location_type l)
      {
        return symbol_type (token::LOG, std::move (l));
      }
#else
      static
      symbol_type
      make_LOG (const location_type& l)
      {
        return symbol_type (token::LOG, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_LN (location_type l)
      {
        return symbol_type (token::LN, std::move (l));
      }
#else
      static
      symbol_type
      make_LN (const location_type& l)
      {
        return symbol_type (token::LN, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_LOG10 (location_type l)
      {
        return symbol_type (token::LOG10, std::move (l));
      }
#else
      static
      symbol_type
      make_LOG10 (const location_type& l)
      {
        return symbol_type (token::LOG10, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_SIN (location_type l)
      {
        return symbol_type (token::SIN, std::move (l));
      }
#else
      static
      symbol_type
      make_SIN (const location_type& l)
      {
        return symbol_type (token::SIN, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_COS (location_type l)
      {
        return symbol_type (token::COS, std::move (l));
      }
#else
      static
      symbol_type
      make_COS (const location_type& l)
      {
        return symbol_type (token::COS, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_TAN (location_type l)
      {
        return symbol_type (token::TAN, std::move (l));
      }
#else
      static
      symbol_type
      make_TAN (const location_type& l)
      {
        return symbol_type (token::TAN, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_ASIN (location_type l)
      {
        return symbol_type (token::ASIN, std::move (l));
      }
#else
      static
      symbol_type
      make_ASIN (const location_type& l)
      {
        return symbol_type (token::ASIN, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_ACOS (location_type l)
      {
        return symbol_type (token::ACOS, std::move (l));
      }
#else
      static
      symbol_type
      make_ACOS (const location_type& l)
      {
        return symbol_type (token::ACOS, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_ATAN (location_type l)
      {
        return symbol_type (token::ATAN, std::move (l));
      }
#else
      static
      symbol_type
      make_ATAN (const location_type& l)
      {
        return symbol_type (token::ATAN, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_ERF (location_type l)
      {
        return symbol_type (token::ERF, std::move (l));
      }
#else
      static
      symbol_type
      make_ERF (const location_type& l)
      {
        return symbol_type (token::ERF, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_DIFF (location_type l)
      {
        return symbol_type (token::DIFF, std::move (l));
      }
#else
      static
      symbol_type
      make_DIFF (const location_type& l)
      {
        return symbol_type (token::DIFF, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_ADL (location_type l)
      {
        return symbol_type (token::ADL, std::move (l));
      }
#else
      static
      symbol_type
      make_ADL (const location_type& l)
      {
        return symbol_type (token::ADL, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_AUXILIARY_MODEL_NAME (location_type l)
      {
        return symbol_type (token::AUXILIARY_MODEL_NAME, std::move (l));
      }
#else
      static
      symbol_type
      make_AUXILIARY_MODEL_NAME (const location_type& l)
      {
        return symbol_type (token::AUXILIARY_MODEL_NAME, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_SQRT (location_type l)
      {
        return symbol_type (token::SQRT, std::move (l));
      }
#else
      static
      symbol_type
      make_SQRT (const location_type& l)
      {
        return symbol_type (token::SQRT, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_CBRT (location_type l)
      {
        return symbol_type (token::CBRT, std::move (l));
      }
#else
      static
      symbol_type
      make_CBRT (const location_type& l)
      {
        return symbol_type (token::CBRT, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_NORMCDF (location_type l)
      {
        return symbol_type (token::NORMCDF, std::move (l));
      }
#else
      static
      symbol_type
      make_NORMCDF (const location_type& l)
      {
        return symbol_type (token::NORMCDF, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_NORMPDF (location_type l)
      {
        return symbol_type (token::NORMPDF, std::move (l));
      }
#else
      static
      symbol_type
      make_NORMPDF (const location_type& l)
      {
        return symbol_type (token::NORMPDF, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_STEADY_STATE (location_type l)
      {
        return symbol_type (token::STEADY_STATE, std::move (l));
      }
#else
      static
      symbol_type
      make_STEADY_STATE (const location_type& l)
      {
        return symbol_type (token::STEADY_STATE, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_EXPECTATION (location_type l)
      {
        return symbol_type (token::EXPECTATION, std::move (l));
      }
#else
      static
      symbol_type
      make_EXPECTATION (const location_type& l)
      {
        return symbol_type (token::EXPECTATION, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_VAR_ESTIMATION (location_type l)
      {
        return symbol_type (token::VAR_ESTIMATION, std::move (l));
      }
#else
      static
      symbol_type
      make_VAR_ESTIMATION (const location_type& l)
      {
        return symbol_type (token::VAR_ESTIMATION, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_DYNARE_SENSITIVITY (location_type l)
      {
        return symbol_type (token::DYNARE_SENSITIVITY, std::move (l));
      }
#else
      static
      symbol_type
      make_DYNARE_SENSITIVITY (const location_type& l)
      {
        return symbol_type (token::DYNARE_SENSITIVITY, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_MORRIS (location_type l)
      {
        return symbol_type (token::MORRIS, std::move (l));
      }
#else
      static
      symbol_type
      make_MORRIS (const location_type& l)
      {
        return symbol_type (token::MORRIS, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_STAB (location_type l)
      {
        return symbol_type (token::STAB, std::move (l));
      }
#else
      static
      symbol_type
      make_STAB (const location_type& l)
      {
        return symbol_type (token::STAB, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_REDFORM (location_type l)
      {
        return symbol_type (token::REDFORM, std::move (l));
      }
#else
      static
      symbol_type
      make_REDFORM (const location_type& l)
      {
        return symbol_type (token::REDFORM, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_PPRIOR (location_type l)
      {
        return symbol_type (token::PPRIOR, std::move (l));
      }
#else
      static
      symbol_type
      make_PPRIOR (const location_type& l)
      {
        return symbol_type (token::PPRIOR, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_PRIOR_RANGE (location_type l)
      {
        return symbol_type (token::PRIOR_RANGE, std::move (l));
      }
#else
      static
      symbol_type
      make_PRIOR_RANGE (const location_type& l)
      {
        return symbol_type (token::PRIOR_RANGE, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_PPOST (location_type l)
      {
        return symbol_type (token::PPOST, std::move (l));
      }
#else
      static
      symbol_type
      make_PPOST (const location_type& l)
      {
        return symbol_type (token::PPOST, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_ILPTAU (location_type l)
      {
        return symbol_type (token::ILPTAU, std::move (l));
      }
#else
      static
      symbol_type
      make_ILPTAU (const location_type& l)
      {
        return symbol_type (token::ILPTAU, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_MORRIS_NLIV (location_type l)
      {
        return symbol_type (token::MORRIS_NLIV, std::move (l));
      }
#else
      static
      symbol_type
      make_MORRIS_NLIV (const location_type& l)
      {
        return symbol_type (token::MORRIS_NLIV, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_MORRIS_NTRA (location_type l)
      {
        return symbol_type (token::MORRIS_NTRA, std::move (l));
      }
#else
      static
      symbol_type
      make_MORRIS_NTRA (const location_type& l)
      {
        return symbol_type (token::MORRIS_NTRA, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_NSAM (location_type l)
      {
        return symbol_type (token::NSAM, std::move (l));
      }
#else
      static
      symbol_type
      make_NSAM (const location_type& l)
      {
        return symbol_type (token::NSAM, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_LOAD_REDFORM (location_type l)
      {
        return symbol_type (token::LOAD_REDFORM, std::move (l));
      }
#else
      static
      symbol_type
      make_LOAD_REDFORM (const location_type& l)
      {
        return symbol_type (token::LOAD_REDFORM, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_LOAD_RMSE (location_type l)
      {
        return symbol_type (token::LOAD_RMSE, std::move (l));
      }
#else
      static
      symbol_type
      make_LOAD_RMSE (const location_type& l)
      {
        return symbol_type (token::LOAD_RMSE, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_LOAD_STAB (location_type l)
      {
        return symbol_type (token::LOAD_STAB, std::move (l));
      }
#else
      static
      symbol_type
      make_LOAD_STAB (const location_type& l)
      {
        return symbol_type (token::LOAD_STAB, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_ALPHA2_STAB (location_type l)
      {
        return symbol_type (token::ALPHA2_STAB, std::move (l));
      }
#else
      static
      symbol_type
      make_ALPHA2_STAB (const location_type& l)
      {
        return symbol_type (token::ALPHA2_STAB, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_LOGTRANS_REDFORM (location_type l)
      {
        return symbol_type (token::LOGTRANS_REDFORM, std::move (l));
      }
#else
      static
      symbol_type
      make_LOGTRANS_REDFORM (const location_type& l)
      {
        return symbol_type (token::LOGTRANS_REDFORM, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_THRESHOLD_REDFORM (location_type l)
      {
        return symbol_type (token::THRESHOLD_REDFORM, std::move (l));
      }
#else
      static
      symbol_type
      make_THRESHOLD_REDFORM (const location_type& l)
      {
        return symbol_type (token::THRESHOLD_REDFORM, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_KSSTAT_REDFORM (location_type l)
      {
        return symbol_type (token::KSSTAT_REDFORM, std::move (l));
      }
#else
      static
      symbol_type
      make_KSSTAT_REDFORM (const location_type& l)
      {
        return symbol_type (token::KSSTAT_REDFORM, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_ALPHA2_REDFORM (location_type l)
      {
        return symbol_type (token::ALPHA2_REDFORM, std::move (l));
      }
#else
      static
      symbol_type
      make_ALPHA2_REDFORM (const location_type& l)
      {
        return symbol_type (token::ALPHA2_REDFORM, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_NAMENDO (location_type l)
      {
        return symbol_type (token::NAMENDO, std::move (l));
      }
#else
      static
      symbol_type
      make_NAMENDO (const location_type& l)
      {
        return symbol_type (token::NAMENDO, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_NAMLAGENDO (location_type l)
      {
        return symbol_type (token::NAMLAGENDO, std::move (l));
      }
#else
      static
      symbol_type
      make_NAMLAGENDO (const location_type& l)
      {
        return symbol_type (token::NAMLAGENDO, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_NAMEXO (location_type l)
      {
        return symbol_type (token::NAMEXO, std::move (l));
      }
#else
      static
      symbol_type
      make_NAMEXO (const location_type& l)
      {
        return symbol_type (token::NAMEXO, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_RMSE (location_type l)
      {
        return symbol_type (token::RMSE, std::move (l));
      }
#else
      static
      symbol_type
      make_RMSE (const location_type& l)
      {
        return symbol_type (token::RMSE, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_LIK_ONLY (location_type l)
      {
        return symbol_type (token::LIK_ONLY, std::move (l));
      }
#else
      static
      symbol_type
      make_LIK_ONLY (const location_type& l)
      {
        return symbol_type (token::LIK_ONLY, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_VAR_RMSE (location_type l)
      {
        return symbol_type (token::VAR_RMSE, std::move (l));
      }
#else
      static
      symbol_type
      make_VAR_RMSE (const location_type& l)
      {
        return symbol_type (token::VAR_RMSE, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_PFILT_RMSE (location_type l)
      {
        return symbol_type (token::PFILT_RMSE, std::move (l));
      }
#else
      static
      symbol_type
      make_PFILT_RMSE (const location_type& l)
      {
        return symbol_type (token::PFILT_RMSE, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_ISTART_RMSE (location_type l)
      {
        return symbol_type (token::ISTART_RMSE, std::move (l));
      }
#else
      static
      symbol_type
      make_ISTART_RMSE (const location_type& l)
      {
        return symbol_type (token::ISTART_RMSE, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_ALPHA_RMSE (location_type l)
      {
        return symbol_type (token::ALPHA_RMSE, std::move (l));
      }
#else
      static
      symbol_type
      make_ALPHA_RMSE (const location_type& l)
      {
        return symbol_type (token::ALPHA_RMSE, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_ALPHA2_RMSE (location_type l)
      {
        return symbol_type (token::ALPHA2_RMSE, std::move (l));
      }
#else
      static
      symbol_type
      make_ALPHA2_RMSE (const location_type& l)
      {
        return symbol_type (token::ALPHA2_RMSE, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_FREQ (location_type l)
      {
        return symbol_type (token::FREQ, std::move (l));
      }
#else
      static
      symbol_type
      make_FREQ (const location_type& l)
      {
        return symbol_type (token::FREQ, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_INITIAL_YEAR (location_type l)
      {
        return symbol_type (token::INITIAL_YEAR, std::move (l));
      }
#else
      static
      symbol_type
      make_INITIAL_YEAR (const location_type& l)
      {
        return symbol_type (token::INITIAL_YEAR, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_INITIAL_SUBPERIOD (location_type l)
      {
        return symbol_type (token::INITIAL_SUBPERIOD, std::move (l));
      }
#else
      static
      symbol_type
      make_INITIAL_SUBPERIOD (const location_type& l)
      {
        return symbol_type (token::INITIAL_SUBPERIOD, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_FINAL_YEAR (location_type l)
      {
        return symbol_type (token::FINAL_YEAR, std::move (l));
      }
#else
      static
      symbol_type
      make_FINAL_YEAR (const location_type& l)
      {
        return symbol_type (token::FINAL_YEAR, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_FINAL_SUBPERIOD (location_type l)
      {
        return symbol_type (token::FINAL_SUBPERIOD, std::move (l));
      }
#else
      static
      symbol_type
      make_FINAL_SUBPERIOD (const location_type& l)
      {
        return symbol_type (token::FINAL_SUBPERIOD, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_DATA (location_type l)
      {
        return symbol_type (token::DATA, std::move (l));
      }
#else
      static
      symbol_type
      make_DATA (const location_type& l)
      {
        return symbol_type (token::DATA, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_VLIST (location_type l)
      {
        return symbol_type (token::VLIST, std::move (l));
      }
#else
      static
      symbol_type
      make_VLIST (const location_type& l)
      {
        return symbol_type (token::VLIST, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_VLISTLOG (location_type l)
      {
        return symbol_type (token::VLISTLOG, std::move (l));
      }
#else
      static
      symbol_type
      make_VLISTLOG (const location_type& l)
      {
        return symbol_type (token::VLISTLOG, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_VLISTPER (location_type l)
      {
        return symbol_type (token::VLISTPER, std::move (l));
      }
#else
      static
      symbol_type
      make_VLISTPER (const location_type& l)
      {
        return symbol_type (token::VLISTPER, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_SPECTRAL_DENSITY (location_type l)
      {
        return symbol_type (token::SPECTRAL_DENSITY, std::move (l));
      }
#else
      static
      symbol_type
      make_SPECTRAL_DENSITY (const location_type& l)
      {
        return symbol_type (token::SPECTRAL_DENSITY, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_INIT2SHOCKS (location_type l)
      {
        return symbol_type (token::INIT2SHOCKS, std::move (l));
      }
#else
      static
      symbol_type
      make_INIT2SHOCKS (const location_type& l)
      {
        return symbol_type (token::INIT2SHOCKS, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_RESTRICTION (location_type l)
      {
        return symbol_type (token::RESTRICTION, std::move (l));
      }
#else
      static
      symbol_type
      make_RESTRICTION (const location_type& l)
      {
        return symbol_type (token::RESTRICTION, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_RESTRICTION_FNAME (location_type l)
      {
        return symbol_type (token::RESTRICTION_FNAME, std::move (l));
      }
#else
      static
      symbol_type
      make_RESTRICTION_FNAME (const location_type& l)
      {
        return symbol_type (token::RESTRICTION_FNAME, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_CROSS_RESTRICTIONS (location_type l)
      {
        return symbol_type (token::CROSS_RESTRICTIONS, std::move (l));
      }
#else
      static
      symbol_type
      make_CROSS_RESTRICTIONS (const location_type& l)
      {
        return symbol_type (token::CROSS_RESTRICTIONS, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_NLAGS (location_type l)
      {
        return symbol_type (token::NLAGS, std::move (l));
      }
#else
      static
      symbol_type
      make_NLAGS (const location_type& l)
      {
        return symbol_type (token::NLAGS, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_CONTEMP_REDUCED_FORM (location_type l)
      {
        return symbol_type (token::CONTEMP_REDUCED_FORM, std::move (l));
      }
#else
      static
      symbol_type
      make_CONTEMP_REDUCED_FORM (const location_type& l)
      {
        return symbol_type (token::CONTEMP_REDUCED_FORM, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_REAL_PSEUDO_FORECAST (location_type l)
      {
        return symbol_type (token::REAL_PSEUDO_FORECAST, std::move (l));
      }
#else
      static
      symbol_type
      make_REAL_PSEUDO_FORECAST (const location_type& l)
      {
        return symbol_type (token::REAL_PSEUDO_FORECAST, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_DUMMY_OBS (location_type l)
      {
        return symbol_type (token::DUMMY_OBS, std::move (l));
      }
#else
      static
      symbol_type
      make_DUMMY_OBS (const location_type& l)
      {
        return symbol_type (token::DUMMY_OBS, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_NSTATES (location_type l)
      {
        return symbol_type (token::NSTATES, std::move (l));
      }
#else
      static
      symbol_type
      make_NSTATES (const location_type& l)
      {
        return symbol_type (token::NSTATES, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_INDXSCALESSTATES (location_type l)
      {
        return symbol_type (token::INDXSCALESSTATES, std::move (l));
      }
#else
      static
      symbol_type
      make_INDXSCALESSTATES (const location_type& l)
      {
        return symbol_type (token::INDXSCALESSTATES, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_NO_BAYESIAN_PRIOR (location_type l)
      {
        return symbol_type (token::NO_BAYESIAN_PRIOR, std::move (l));
      }
#else
      static
      symbol_type
      make_NO_BAYESIAN_PRIOR (const location_type& l)
      {
        return symbol_type (token::NO_BAYESIAN_PRIOR, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_SPECIFICATION (location_type l)
      {
        return symbol_type (token::SPECIFICATION, std::move (l));
      }
#else
      static
      symbol_type
      make_SPECIFICATION (const location_type& l)
      {
        return symbol_type (token::SPECIFICATION, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_SIMS_ZHA (location_type l)
      {
        return symbol_type (token::SIMS_ZHA, std::move (l));
      }
#else
      static
      symbol_type
      make_SIMS_ZHA (const location_type& l)
      {
        return symbol_type (token::SIMS_ZHA, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_ALPHA (string v, location_type l)
      {
        return symbol_type (token::ALPHA, std::move (v), std::move (l));
      }
#else
      static
      symbol_type
      make_ALPHA (const string& v, const location_type& l)
      {
        return symbol_type (token::ALPHA, v, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_BETA (string v, location_type l)
      {
        return symbol_type (token::BETA, std::move (v), std::move (l));
      }
#else
      static
      symbol_type
      make_BETA (const string& v, const location_type& l)
      {
        return symbol_type (token::BETA, v, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_ABAND (string v, location_type l)
      {
        return symbol_type (token::ABAND, std::move (v), std::move (l));
      }
#else
      static
      symbol_type
      make_ABAND (const string& v, const location_type& l)
      {
        return symbol_type (token::ABAND, v, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_NINV (string v, location_type l)
      {
        return symbol_type (token::NINV, std::move (v), std::move (l));
      }
#else
      static
      symbol_type
      make_NINV (const string& v, const location_type& l)
      {
        return symbol_type (token::NINV, v, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_CMS (string v, location_type l)
      {
        return symbol_type (token::CMS, std::move (v), std::move (l));
      }
#else
      static
      symbol_type
      make_CMS (const string& v, const location_type& l)
      {
        return symbol_type (token::CMS, v, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_NCMS (string v, location_type l)
      {
        return symbol_type (token::NCMS, std::move (v), std::move (l));
      }
#else
      static
      symbol_type
      make_NCMS (const string& v, const location_type& l)
      {
        return symbol_type (token::NCMS, v, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_CNUM (string v, location_type l)
      {
        return symbol_type (token::CNUM, std::move (v), std::move (l));
      }
#else
      static
      symbol_type
      make_CNUM (const string& v, const location_type& l)
      {
        return symbol_type (token::CNUM, v, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_GAMMA (string v, location_type l)
      {
        return symbol_type (token::GAMMA, std::move (v), std::move (l));
      }
#else
      static
      symbol_type
      make_GAMMA (const string& v, const location_type& l)
      {
        return symbol_type (token::GAMMA, v, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_INV_GAMMA (string v, location_type l)
      {
        return symbol_type (token::INV_GAMMA, std::move (v), std::move (l));
      }
#else
      static
      symbol_type
      make_INV_GAMMA (const string& v, const location_type& l)
      {
        return symbol_type (token::INV_GAMMA, v, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_INV_GAMMA1 (string v, location_type l)
      {
        return symbol_type (token::INV_GAMMA1, std::move (v), std::move (l));
      }
#else
      static
      symbol_type
      make_INV_GAMMA1 (const string& v, const location_type& l)
      {
        return symbol_type (token::INV_GAMMA1, v, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_INV_GAMMA2 (string v, location_type l)
      {
        return symbol_type (token::INV_GAMMA2, std::move (v), std::move (l));
      }
#else
      static
      symbol_type
      make_INV_GAMMA2 (const string& v, const location_type& l)
      {
        return symbol_type (token::INV_GAMMA2, v, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_NORMAL (string v, location_type l)
      {
        return symbol_type (token::NORMAL, std::move (v), std::move (l));
      }
#else
      static
      symbol_type
      make_NORMAL (const string& v, const location_type& l)
      {
        return symbol_type (token::NORMAL, v, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_UNIFORM (string v, location_type l)
      {
        return symbol_type (token::UNIFORM, std::move (v), std::move (l));
      }
#else
      static
      symbol_type
      make_UNIFORM (const string& v, const location_type& l)
      {
        return symbol_type (token::UNIFORM, v, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_EPS (string v, location_type l)
      {
        return symbol_type (token::EPS, std::move (v), std::move (l));
      }
#else
      static
      symbol_type
      make_EPS (const string& v, const location_type& l)
      {
        return symbol_type (token::EPS, v, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_PDF (string v, location_type l)
      {
        return symbol_type (token::PDF, std::move (v), std::move (l));
      }
#else
      static
      symbol_type
      make_PDF (const string& v, const location_type& l)
      {
        return symbol_type (token::PDF, v, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_FIG (string v, location_type l)
      {
        return symbol_type (token::FIG, std::move (v), std::move (l));
      }
#else
      static
      symbol_type
      make_FIG (const string& v, const location_type& l)
      {
        return symbol_type (token::FIG, v, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_DR (string v, location_type l)
      {
        return symbol_type (token::DR, std::move (v), std::move (l));
      }
#else
      static
      symbol_type
      make_DR (const string& v, const location_type& l)
      {
        return symbol_type (token::DR, v, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_NONE (string v, location_type l)
      {
        return symbol_type (token::NONE, std::move (v), std::move (l));
      }
#else
      static
      symbol_type
      make_NONE (const string& v, const location_type& l)
      {
        return symbol_type (token::NONE, v, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_PRIOR (string v, location_type l)
      {
        return symbol_type (token::PRIOR, std::move (v), std::move (l));
      }
#else
      static
      symbol_type
      make_PRIOR (const string& v, const location_type& l)
      {
        return symbol_type (token::PRIOR, v, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_PRIOR_VARIANCE (string v, location_type l)
      {
        return symbol_type (token::PRIOR_VARIANCE, std::move (v), std::move (l));
      }
#else
      static
      symbol_type
      make_PRIOR_VARIANCE (const string& v, const location_type& l)
      {
        return symbol_type (token::PRIOR_VARIANCE, v, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_HESSIAN (string v, location_type l)
      {
        return symbol_type (token::HESSIAN, std::move (v), std::move (l));
      }
#else
      static
      symbol_type
      make_HESSIAN (const string& v, const location_type& l)
      {
        return symbol_type (token::HESSIAN, v, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_IDENTITY_MATRIX (string v, location_type l)
      {
        return symbol_type (token::IDENTITY_MATRIX, std::move (v), std::move (l));
      }
#else
      static
      symbol_type
      make_IDENTITY_MATRIX (const string& v, const location_type& l)
      {
        return symbol_type (token::IDENTITY_MATRIX, v, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_DIRICHLET (string v, location_type l)
      {
        return symbol_type (token::DIRICHLET, std::move (v), std::move (l));
      }
#else
      static
      symbol_type
      make_DIRICHLET (const string& v, const location_type& l)
      {
        return symbol_type (token::DIRICHLET, v, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_DIAGONAL (string v, location_type l)
      {
        return symbol_type (token::DIAGONAL, std::move (v), std::move (l));
      }
#else
      static
      symbol_type
      make_DIAGONAL (const string& v, const location_type& l)
      {
        return symbol_type (token::DIAGONAL, v, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_OPTIMAL (string v, location_type l)
      {
        return symbol_type (token::OPTIMAL, std::move (v), std::move (l));
      }
#else
      static
      symbol_type
      make_OPTIMAL (const string& v, const location_type& l)
      {
        return symbol_type (token::OPTIMAL, v, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_GSIG2_LMDM (location_type l)
      {
        return symbol_type (token::GSIG2_LMDM, std::move (l));
      }
#else
      static
      symbol_type
      make_GSIG2_LMDM (const location_type& l)
      {
        return symbol_type (token::GSIG2_LMDM, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_Q_DIAG (location_type l)
      {
        return symbol_type (token::Q_DIAG, std::move (l));
      }
#else
      static
      symbol_type
      make_Q_DIAG (const location_type& l)
      {
        return symbol_type (token::Q_DIAG, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_FLAT_PRIOR (location_type l)
      {
        return symbol_type (token::FLAT_PRIOR, std::move (l));
      }
#else
      static
      symbol_type
      make_FLAT_PRIOR (const location_type& l)
      {
        return symbol_type (token::FLAT_PRIOR, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_NCSK (location_type l)
      {
        return symbol_type (token::NCSK, std::move (l));
      }
#else
      static
      symbol_type
      make_NCSK (const location_type& l)
      {
        return symbol_type (token::NCSK, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_NSTD (location_type l)
      {
        return symbol_type (token::NSTD, std::move (l));
      }
#else
      static
      symbol_type
      make_NSTD (const location_type& l)
      {
        return symbol_type (token::NSTD, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_WEIBULL (location_type l)
      {
        return symbol_type (token::WEIBULL, std::move (l));
      }
#else
      static
      symbol_type
      make_WEIBULL (const location_type& l)
      {
        return symbol_type (token::WEIBULL, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_WEIBULL_PDF (location_type l)
      {
        return symbol_type (token::WEIBULL_PDF, std::move (l));
      }
#else
      static
      symbol_type
      make_WEIBULL_PDF (const location_type& l)
      {
        return symbol_type (token::WEIBULL_PDF, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_INDXPARR (location_type l)
      {
        return symbol_type (token::INDXPARR, std::move (l));
      }
#else
      static
      symbol_type
      make_INDXPARR (const location_type& l)
      {
        return symbol_type (token::INDXPARR, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_INDXOVR (location_type l)
      {
        return symbol_type (token::INDXOVR, std::move (l));
      }
#else
      static
      symbol_type
      make_INDXOVR (const location_type& l)
      {
        return symbol_type (token::INDXOVR, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_INDXAP (location_type l)
      {
        return symbol_type (token::INDXAP, std::move (l));
      }
#else
      static
      symbol_type
      make_INDXAP (const location_type& l)
      {
        return symbol_type (token::INDXAP, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_APBAND (location_type l)
      {
        return symbol_type (token::APBAND, std::move (l));
      }
#else
      static
      symbol_type
      make_APBAND (const location_type& l)
      {
        return symbol_type (token::APBAND, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_INDXIMF (location_type l)
      {
        return symbol_type (token::INDXIMF, std::move (l));
      }
#else
      static
      symbol_type
      make_INDXIMF (const location_type& l)
      {
        return symbol_type (token::INDXIMF, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_INDXFORE (location_type l)
      {
        return symbol_type (token::INDXFORE, std::move (l));
      }
#else
      static
      symbol_type
      make_INDXFORE (const location_type& l)
      {
        return symbol_type (token::INDXFORE, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_FOREBAND (location_type l)
      {
        return symbol_type (token::FOREBAND, std::move (l));
      }
#else
      static
      symbol_type
      make_FOREBAND (const location_type& l)
      {
        return symbol_type (token::FOREBAND, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_INDXGFOREHAT (location_type l)
      {
        return symbol_type (token::INDXGFOREHAT, std::move (l));
      }
#else
      static
      symbol_type
      make_INDXGFOREHAT (const location_type& l)
      {
        return symbol_type (token::INDXGFOREHAT, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_INDXGIMFHAT (location_type l)
      {
        return symbol_type (token::INDXGIMFHAT, std::move (l));
      }
#else
      static
      symbol_type
      make_INDXGIMFHAT (const location_type& l)
      {
        return symbol_type (token::INDXGIMFHAT, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_INDXESTIMA (location_type l)
      {
        return symbol_type (token::INDXESTIMA, std::move (l));
      }
#else
      static
      symbol_type
      make_INDXESTIMA (const location_type& l)
      {
        return symbol_type (token::INDXESTIMA, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_INDXGDLS (location_type l)
      {
        return symbol_type (token::INDXGDLS, std::move (l));
      }
#else
      static
      symbol_type
      make_INDXGDLS (const location_type& l)
      {
        return symbol_type (token::INDXGDLS, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_EQ_MS (location_type l)
      {
        return symbol_type (token::EQ_MS, std::move (l));
      }
#else
      static
      symbol_type
      make_EQ_MS (const location_type& l)
      {
        return symbol_type (token::EQ_MS, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_FILTER_COVARIANCE (location_type l)
      {
        return symbol_type (token::FILTER_COVARIANCE, std::move (l));
      }
#else
      static
      symbol_type
      make_FILTER_COVARIANCE (const location_type& l)
      {
        return symbol_type (token::FILTER_COVARIANCE, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_FILTER_DECOMPOSITION (location_type l)
      {
        return symbol_type (token::FILTER_DECOMPOSITION, std::move (l));
      }
#else
      static
      symbol_type
      make_FILTER_DECOMPOSITION (const location_type& l)
      {
        return symbol_type (token::FILTER_DECOMPOSITION, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_SMOOTHED_STATE_UNCERTAINTY (location_type l)
      {
        return symbol_type (token::SMOOTHED_STATE_UNCERTAINTY, std::move (l));
      }
#else
      static
      symbol_type
      make_SMOOTHED_STATE_UNCERTAINTY (const location_type& l)
      {
        return symbol_type (token::SMOOTHED_STATE_UNCERTAINTY, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_EQ_CMS (location_type l)
      {
        return symbol_type (token::EQ_CMS, std::move (l));
      }
#else
      static
      symbol_type
      make_EQ_CMS (const location_type& l)
      {
        return symbol_type (token::EQ_CMS, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_TLINDX (location_type l)
      {
        return symbol_type (token::TLINDX, std::move (l));
      }
#else
      static
      symbol_type
      make_TLINDX (const location_type& l)
      {
        return symbol_type (token::TLINDX, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_TLNUMBER (location_type l)
      {
        return symbol_type (token::TLNUMBER, std::move (l));
      }
#else
      static
      symbol_type
      make_TLNUMBER (const location_type& l)
      {
        return symbol_type (token::TLNUMBER, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_RESTRICTIONS (location_type l)
      {
        return symbol_type (token::RESTRICTIONS, std::move (l));
      }
#else
      static
      symbol_type
      make_RESTRICTIONS (const location_type& l)
      {
        return symbol_type (token::RESTRICTIONS, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_POSTERIOR_SAMPLER_OPTIONS (location_type l)
      {
        return symbol_type (token::POSTERIOR_SAMPLER_OPTIONS, std::move (l));
      }
#else
      static
      symbol_type
      make_POSTERIOR_SAMPLER_OPTIONS (const location_type& l)
      {
        return symbol_type (token::POSTERIOR_SAMPLER_OPTIONS, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_OUTPUT_FILE_TAG (location_type l)
      {
        return symbol_type (token::OUTPUT_FILE_TAG, std::move (l));
      }
#else
      static
      symbol_type
      make_OUTPUT_FILE_TAG (const location_type& l)
      {
        return symbol_type (token::OUTPUT_FILE_TAG, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_HORIZON (location_type l)
      {
        return symbol_type (token::HORIZON, std::move (l));
      }
#else
      static
      symbol_type
      make_HORIZON (const location_type& l)
      {
        return symbol_type (token::HORIZON, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_SBVAR (location_type l)
      {
        return symbol_type (token::SBVAR, std::move (l));
      }
#else
      static
      symbol_type
      make_SBVAR (const location_type& l)
      {
        return symbol_type (token::SBVAR, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_TREND_VAR (location_type l)
      {
        return symbol_type (token::TREND_VAR, std::move (l));
      }
#else
      static
      symbol_type
      make_TREND_VAR (const location_type& l)
      {
        return symbol_type (token::TREND_VAR, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_DEFLATOR (location_type l)
      {
        return symbol_type (token::DEFLATOR, std::move (l));
      }
#else
      static
      symbol_type
      make_DEFLATOR (const location_type& l)
      {
        return symbol_type (token::DEFLATOR, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_GROWTH_FACTOR (location_type l)
      {
        return symbol_type (token::GROWTH_FACTOR, std::move (l));
      }
#else
      static
      symbol_type
      make_GROWTH_FACTOR (const location_type& l)
      {
        return symbol_type (token::GROWTH_FACTOR, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_MS_IRF (location_type l)
      {
        return symbol_type (token::MS_IRF, std::move (l));
      }
#else
      static
      symbol_type
      make_MS_IRF (const location_type& l)
      {
        return symbol_type (token::MS_IRF, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_MS_VARIANCE_DECOMPOSITION (location_type l)
      {
        return symbol_type (token::MS_VARIANCE_DECOMPOSITION, std::move (l));
      }
#else
      static
      symbol_type
      make_MS_VARIANCE_DECOMPOSITION (const location_type& l)
      {
        return symbol_type (token::MS_VARIANCE_DECOMPOSITION, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_GROWTH (location_type l)
      {
        return symbol_type (token::GROWTH, std::move (l));
      }
#else
      static
      symbol_type
      make_GROWTH (const location_type& l)
      {
        return symbol_type (token::GROWTH, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_MS_ESTIMATION (location_type l)
      {
        return symbol_type (token::MS_ESTIMATION, std::move (l));
      }
#else
      static
      symbol_type
      make_MS_ESTIMATION (const location_type& l)
      {
        return symbol_type (token::MS_ESTIMATION, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_MS_SIMULATION (location_type l)
      {
        return symbol_type (token::MS_SIMULATION, std::move (l));
      }
#else
      static
      symbol_type
      make_MS_SIMULATION (const location_type& l)
      {
        return symbol_type (token::MS_SIMULATION, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_MS_COMPUTE_MDD (location_type l)
      {
        return symbol_type (token::MS_COMPUTE_MDD, std::move (l));
      }
#else
      static
      symbol_type
      make_MS_COMPUTE_MDD (const location_type& l)
      {
        return symbol_type (token::MS_COMPUTE_MDD, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_MS_COMPUTE_PROBABILITIES (location_type l)
      {
        return symbol_type (token::MS_COMPUTE_PROBABILITIES, std::move (l));
      }
#else
      static
      symbol_type
      make_MS_COMPUTE_PROBABILITIES (const location_type& l)
      {
        return symbol_type (token::MS_COMPUTE_PROBABILITIES, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_MS_FORECAST (location_type l)
      {
        return symbol_type (token::MS_FORECAST, std::move (l));
      }
#else
      static
      symbol_type
      make_MS_FORECAST (const location_type& l)
      {
        return symbol_type (token::MS_FORECAST, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_SVAR_IDENTIFICATION (location_type l)
      {
        return symbol_type (token::SVAR_IDENTIFICATION, std::move (l));
      }
#else
      static
      symbol_type
      make_SVAR_IDENTIFICATION (const location_type& l)
      {
        return symbol_type (token::SVAR_IDENTIFICATION, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_EQUATION (location_type l)
      {
        return symbol_type (token::EQUATION, std::move (l));
      }
#else
      static
      symbol_type
      make_EQUATION (const location_type& l)
      {
        return symbol_type (token::EQUATION, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_EXCLUSION (location_type l)
      {
        return symbol_type (token::EXCLUSION, std::move (l));
      }
#else
      static
      symbol_type
      make_EXCLUSION (const location_type& l)
      {
        return symbol_type (token::EXCLUSION, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_LAG (location_type l)
      {
        return symbol_type (token::LAG, std::move (l));
      }
#else
      static
      symbol_type
      make_LAG (const location_type& l)
      {
        return symbol_type (token::LAG, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_UPPER_CHOLESKY (location_type l)
      {
        return symbol_type (token::UPPER_CHOLESKY, std::move (l));
      }
#else
      static
      symbol_type
      make_UPPER_CHOLESKY (const location_type& l)
      {
        return symbol_type (token::UPPER_CHOLESKY, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_LOWER_CHOLESKY (location_type l)
      {
        return symbol_type (token::LOWER_CHOLESKY, std::move (l));
      }
#else
      static
      symbol_type
      make_LOWER_CHOLESKY (const location_type& l)
      {
        return symbol_type (token::LOWER_CHOLESKY, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_MONTHLY (location_type l)
      {
        return symbol_type (token::MONTHLY, std::move (l));
      }
#else
      static
      symbol_type
      make_MONTHLY (const location_type& l)
      {
        return symbol_type (token::MONTHLY, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_QUARTERLY (location_type l)
      {
        return symbol_type (token::QUARTERLY, std::move (l));
      }
#else
      static
      symbol_type
      make_QUARTERLY (const location_type& l)
      {
        return symbol_type (token::QUARTERLY, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_MARKOV_SWITCHING (location_type l)
      {
        return symbol_type (token::MARKOV_SWITCHING, std::move (l));
      }
#else
      static
      symbol_type
      make_MARKOV_SWITCHING (const location_type& l)
      {
        return symbol_type (token::MARKOV_SWITCHING, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_CHAIN (location_type l)
      {
        return symbol_type (token::CHAIN, std::move (l));
      }
#else
      static
      symbol_type
      make_CHAIN (const location_type& l)
      {
        return symbol_type (token::CHAIN, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_DURATION (location_type l)
      {
        return symbol_type (token::DURATION, std::move (l));
      }
#else
      static
      symbol_type
      make_DURATION (const location_type& l)
      {
        return symbol_type (token::DURATION, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_NUMBER_OF_REGIMES (location_type l)
      {
        return symbol_type (token::NUMBER_OF_REGIMES, std::move (l));
      }
#else
      static
      symbol_type
      make_NUMBER_OF_REGIMES (const location_type& l)
      {
        return symbol_type (token::NUMBER_OF_REGIMES, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_NUMBER_OF_LAGS (location_type l)
      {
        return symbol_type (token::NUMBER_OF_LAGS, std::move (l));
      }
#else
      static
      symbol_type
      make_NUMBER_OF_LAGS (const location_type& l)
      {
        return symbol_type (token::NUMBER_OF_LAGS, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_EPILOGUE (location_type l)
      {
        return symbol_type (token::EPILOGUE, std::move (l));
      }
#else
      static
      symbol_type
      make_EPILOGUE (const location_type& l)
      {
        return symbol_type (token::EPILOGUE, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_SVAR (location_type l)
      {
        return symbol_type (token::SVAR, std::move (l));
      }
#else
      static
      symbol_type
      make_SVAR (const location_type& l)
      {
        return symbol_type (token::SVAR, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_SVAR_GLOBAL_IDENTIFICATION_CHECK (location_type l)
      {
        return symbol_type (token::SVAR_GLOBAL_IDENTIFICATION_CHECK, std::move (l));
      }
#else
      static
      symbol_type
      make_SVAR_GLOBAL_IDENTIFICATION_CHECK (const location_type& l)
      {
        return symbol_type (token::SVAR_GLOBAL_IDENTIFICATION_CHECK, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_COEFF (location_type l)
      {
        return symbol_type (token::COEFF, std::move (l));
      }
#else
      static
      symbol_type
      make_COEFF (const location_type& l)
      {
        return symbol_type (token::COEFF, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_COEFFICIENTS (location_type l)
      {
        return symbol_type (token::COEFFICIENTS, std::move (l));
      }
#else
      static
      symbol_type
      make_COEFFICIENTS (const location_type& l)
      {
        return symbol_type (token::COEFFICIENTS, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_VARIANCES (location_type l)
      {
        return symbol_type (token::VARIANCES, std::move (l));
      }
#else
      static
      symbol_type
      make_VARIANCES (const location_type& l)
      {
        return symbol_type (token::VARIANCES, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_CONSTANTS (location_type l)
      {
        return symbol_type (token::CONSTANTS, std::move (l));
      }
#else
      static
      symbol_type
      make_CONSTANTS (const location_type& l)
      {
        return symbol_type (token::CONSTANTS, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_EQUATIONS (location_type l)
      {
        return symbol_type (token::EQUATIONS, std::move (l));
      }
#else
      static
      symbol_type
      make_EQUATIONS (const location_type& l)
      {
        return symbol_type (token::EQUATIONS, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_EXTERNAL_FUNCTION (location_type l)
      {
        return symbol_type (token::EXTERNAL_FUNCTION, std::move (l));
      }
#else
      static
      symbol_type
      make_EXTERNAL_FUNCTION (const location_type& l)
      {
        return symbol_type (token::EXTERNAL_FUNCTION, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_EXT_FUNC_NAME (location_type l)
      {
        return symbol_type (token::EXT_FUNC_NAME, std::move (l));
      }
#else
      static
      symbol_type
      make_EXT_FUNC_NAME (const location_type& l)
      {
        return symbol_type (token::EXT_FUNC_NAME, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_EXT_FUNC_NARGS (location_type l)
      {
        return symbol_type (token::EXT_FUNC_NARGS, std::move (l));
      }
#else
      static
      symbol_type
      make_EXT_FUNC_NARGS (const location_type& l)
      {
        return symbol_type (token::EXT_FUNC_NARGS, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_FIRST_DERIV_PROVIDED (location_type l)
      {
        return symbol_type (token::FIRST_DERIV_PROVIDED, std::move (l));
      }
#else
      static
      symbol_type
      make_FIRST_DERIV_PROVIDED (const location_type& l)
      {
        return symbol_type (token::FIRST_DERIV_PROVIDED, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_SECOND_DERIV_PROVIDED (location_type l)
      {
        return symbol_type (token::SECOND_DERIV_PROVIDED, std::move (l));
      }
#else
      static
      symbol_type
      make_SECOND_DERIV_PROVIDED (const location_type& l)
      {
        return symbol_type (token::SECOND_DERIV_PROVIDED, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_SELECTED_VARIABLES_ONLY (location_type l)
      {
        return symbol_type (token::SELECTED_VARIABLES_ONLY, std::move (l));
      }
#else
      static
      symbol_type
      make_SELECTED_VARIABLES_ONLY (const location_type& l)
      {
        return symbol_type (token::SELECTED_VARIABLES_ONLY, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_COVA_COMPUTE (location_type l)
      {
        return symbol_type (token::COVA_COMPUTE, std::move (l));
      }
#else
      static
      symbol_type
      make_COVA_COMPUTE (const location_type& l)
      {
        return symbol_type (token::COVA_COMPUTE, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_SIMULATION_FILE_TAG (location_type l)
      {
        return symbol_type (token::SIMULATION_FILE_TAG, std::move (l));
      }
#else
      static
      symbol_type
      make_SIMULATION_FILE_TAG (const location_type& l)
      {
        return symbol_type (token::SIMULATION_FILE_TAG, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_FILE_TAG (location_type l)
      {
        return symbol_type (token::FILE_TAG, std::move (l));
      }
#else
      static
      symbol_type
      make_FILE_TAG (const location_type& l)
      {
        return symbol_type (token::FILE_TAG, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_NO_ERROR_BANDS (location_type l)
      {
        return symbol_type (token::NO_ERROR_BANDS, std::move (l));
      }
#else
      static
      symbol_type
      make_NO_ERROR_BANDS (const location_type& l)
      {
        return symbol_type (token::NO_ERROR_BANDS, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_ERROR_BAND_PERCENTILES (location_type l)
      {
        return symbol_type (token::ERROR_BAND_PERCENTILES, std::move (l));
      }
#else
      static
      symbol_type
      make_ERROR_BAND_PERCENTILES (const location_type& l)
      {
        return symbol_type (token::ERROR_BAND_PERCENTILES, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_SHOCKS_PER_PARAMETER (location_type l)
      {
        return symbol_type (token::SHOCKS_PER_PARAMETER, std::move (l));
      }
#else
      static
      symbol_type
      make_SHOCKS_PER_PARAMETER (const location_type& l)
      {
        return symbol_type (token::SHOCKS_PER_PARAMETER, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_NO_CREATE_INIT (location_type l)
      {
        return symbol_type (token::NO_CREATE_INIT, std::move (l));
      }
#else
      static
      symbol_type
      make_NO_CREATE_INIT (const location_type& l)
      {
        return symbol_type (token::NO_CREATE_INIT, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_SHOCK_DRAWS (location_type l)
      {
        return symbol_type (token::SHOCK_DRAWS, std::move (l));
      }
#else
      static
      symbol_type
      make_SHOCK_DRAWS (const location_type& l)
      {
        return symbol_type (token::SHOCK_DRAWS, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_FREE_PARAMETERS (location_type l)
      {
        return symbol_type (token::FREE_PARAMETERS, std::move (l));
      }
#else
      static
      symbol_type
      make_FREE_PARAMETERS (const location_type& l)
      {
        return symbol_type (token::FREE_PARAMETERS, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_MEDIAN (location_type l)
      {
        return symbol_type (token::MEDIAN, std::move (l));
      }
#else
      static
      symbol_type
      make_MEDIAN (const location_type& l)
      {
        return symbol_type (token::MEDIAN, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_DATA_OBS_NBR (location_type l)
      {
        return symbol_type (token::DATA_OBS_NBR, std::move (l));
      }
#else
      static
      symbol_type
      make_DATA_OBS_NBR (const location_type& l)
      {
        return symbol_type (token::DATA_OBS_NBR, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_NEIGHBORHOOD_WIDTH (location_type l)
      {
        return symbol_type (token::NEIGHBORHOOD_WIDTH, std::move (l));
      }
#else
      static
      symbol_type
      make_NEIGHBORHOOD_WIDTH (const location_type& l)
      {
        return symbol_type (token::NEIGHBORHOOD_WIDTH, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_PVALUE_KS (location_type l)
      {
        return symbol_type (token::PVALUE_KS, std::move (l));
      }
#else
      static
      symbol_type
      make_PVALUE_KS (const location_type& l)
      {
        return symbol_type (token::PVALUE_KS, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_PVALUE_CORR (location_type l)
      {
        return symbol_type (token::PVALUE_CORR, std::move (l));
      }
#else
      static
      symbol_type
      make_PVALUE_CORR (const location_type& l)
      {
        return symbol_type (token::PVALUE_CORR, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_FILTERED_PROBABILITIES (location_type l)
      {
        return symbol_type (token::FILTERED_PROBABILITIES, std::move (l));
      }
#else
      static
      symbol_type
      make_FILTERED_PROBABILITIES (const location_type& l)
      {
        return symbol_type (token::FILTERED_PROBABILITIES, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_REAL_TIME_SMOOTHED (location_type l)
      {
        return symbol_type (token::REAL_TIME_SMOOTHED, std::move (l));
      }
#else
      static
      symbol_type
      make_REAL_TIME_SMOOTHED (const location_type& l)
      {
        return symbol_type (token::REAL_TIME_SMOOTHED, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_PRIOR_FUNCTION (location_type l)
      {
        return symbol_type (token::PRIOR_FUNCTION, std::move (l));
      }
#else
      static
      symbol_type
      make_PRIOR_FUNCTION (const location_type& l)
      {
        return symbol_type (token::PRIOR_FUNCTION, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_POSTERIOR_FUNCTION (location_type l)
      {
        return symbol_type (token::POSTERIOR_FUNCTION, std::move (l));
      }
#else
      static
      symbol_type
      make_POSTERIOR_FUNCTION (const location_type& l)
      {
        return symbol_type (token::POSTERIOR_FUNCTION, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_SAMPLING_DRAWS (location_type l)
      {
        return symbol_type (token::SAMPLING_DRAWS, std::move (l));
      }
#else
      static
      symbol_type
      make_SAMPLING_DRAWS (const location_type& l)
      {
        return symbol_type (token::SAMPLING_DRAWS, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_PROPOSAL_TYPE (location_type l)
      {
        return symbol_type (token::PROPOSAL_TYPE, std::move (l));
      }
#else
      static
      symbol_type
      make_PROPOSAL_TYPE (const location_type& l)
      {
        return symbol_type (token::PROPOSAL_TYPE, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_PROPOSAL_UPPER_BOUND (location_type l)
      {
        return symbol_type (token::PROPOSAL_UPPER_BOUND, std::move (l));
      }
#else
      static
      symbol_type
      make_PROPOSAL_UPPER_BOUND (const location_type& l)
      {
        return symbol_type (token::PROPOSAL_UPPER_BOUND, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_PROPOSAL_LOWER_BOUND (location_type l)
      {
        return symbol_type (token::PROPOSAL_LOWER_BOUND, std::move (l));
      }
#else
      static
      symbol_type
      make_PROPOSAL_LOWER_BOUND (const location_type& l)
      {
        return symbol_type (token::PROPOSAL_LOWER_BOUND, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_PROPOSAL_DRAWS (location_type l)
      {
        return symbol_type (token::PROPOSAL_DRAWS, std::move (l));
      }
#else
      static
      symbol_type
      make_PROPOSAL_DRAWS (const location_type& l)
      {
        return symbol_type (token::PROPOSAL_DRAWS, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_USE_MEAN_CENTER (location_type l)
      {
        return symbol_type (token::USE_MEAN_CENTER, std::move (l));
      }
#else
      static
      symbol_type
      make_USE_MEAN_CENTER (const location_type& l)
      {
        return symbol_type (token::USE_MEAN_CENTER, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_ADAPTIVE_MH_DRAWS (location_type l)
      {
        return symbol_type (token::ADAPTIVE_MH_DRAWS, std::move (l));
      }
#else
      static
      symbol_type
      make_ADAPTIVE_MH_DRAWS (const location_type& l)
      {
        return symbol_type (token::ADAPTIVE_MH_DRAWS, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_THINNING_FACTOR (location_type l)
      {
        return symbol_type (token::THINNING_FACTOR, std::move (l));
      }
#else
      static
      symbol_type
      make_THINNING_FACTOR (const location_type& l)
      {
        return symbol_type (token::THINNING_FACTOR, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_COEFFICIENTS_PRIOR_HYPERPARAMETERS (location_type l)
      {
        return symbol_type (token::COEFFICIENTS_PRIOR_HYPERPARAMETERS, std::move (l));
      }
#else
      static
      symbol_type
      make_COEFFICIENTS_PRIOR_HYPERPARAMETERS (const location_type& l)
      {
        return symbol_type (token::COEFFICIENTS_PRIOR_HYPERPARAMETERS, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_SMM_ESTIMATION (location_type l)
      {
        return symbol_type (token::SMM_ESTIMATION, std::move (l));
      }
#else
      static
      symbol_type
      make_SMM_ESTIMATION (const location_type& l)
      {
        return symbol_type (token::SMM_ESTIMATION, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_GMM_ESTIMATION (location_type l)
      {
        return symbol_type (token::GMM_ESTIMATION, std::move (l));
      }
#else
      static
      symbol_type
      make_GMM_ESTIMATION (const location_type& l)
      {
        return symbol_type (token::GMM_ESTIMATION, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_CONVERGENCE_STARTING_VALUE (location_type l)
      {
        return symbol_type (token::CONVERGENCE_STARTING_VALUE, std::move (l));
      }
#else
      static
      symbol_type
      make_CONVERGENCE_STARTING_VALUE (const location_type& l)
      {
        return symbol_type (token::CONVERGENCE_STARTING_VALUE, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_CONVERGENCE_ENDING_VALUE (location_type l)
      {
        return symbol_type (token::CONVERGENCE_ENDING_VALUE, std::move (l));
      }
#else
      static
      symbol_type
      make_CONVERGENCE_ENDING_VALUE (const location_type& l)
      {
        return symbol_type (token::CONVERGENCE_ENDING_VALUE, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_CONVERGENCE_INCREMENT_VALUE (location_type l)
      {
        return symbol_type (token::CONVERGENCE_INCREMENT_VALUE, std::move (l));
      }
#else
      static
      symbol_type
      make_CONVERGENCE_INCREMENT_VALUE (const location_type& l)
      {
        return symbol_type (token::CONVERGENCE_INCREMENT_VALUE, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_MAX_ITERATIONS_STARTING_VALUE (location_type l)
      {
        return symbol_type (token::MAX_ITERATIONS_STARTING_VALUE, std::move (l));
      }
#else
      static
      symbol_type
      make_MAX_ITERATIONS_STARTING_VALUE (const location_type& l)
      {
        return symbol_type (token::MAX_ITERATIONS_STARTING_VALUE, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_MAX_ITERATIONS_INCREMENT_VALUE (location_type l)
      {
        return symbol_type (token::MAX_ITERATIONS_INCREMENT_VALUE, std::move (l));
      }
#else
      static
      symbol_type
      make_MAX_ITERATIONS_INCREMENT_VALUE (const location_type& l)
      {
        return symbol_type (token::MAX_ITERATIONS_INCREMENT_VALUE, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_MAX_BLOCK_ITERATIONS (location_type l)
      {
        return symbol_type (token::MAX_BLOCK_ITERATIONS, std::move (l));
      }
#else
      static
      symbol_type
      make_MAX_BLOCK_ITERATIONS (const location_type& l)
      {
        return symbol_type (token::MAX_BLOCK_ITERATIONS, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_MAX_REPEATED_OPTIMIZATION_RUNS (location_type l)
      {
        return symbol_type (token::MAX_REPEATED_OPTIMIZATION_RUNS, std::move (l));
      }
#else
      static
      symbol_type
      make_MAX_REPEATED_OPTIMIZATION_RUNS (const location_type& l)
      {
        return symbol_type (token::MAX_REPEATED_OPTIMIZATION_RUNS, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_FUNCTION_CONVERGENCE_CRITERION (location_type l)
      {
        return symbol_type (token::FUNCTION_CONVERGENCE_CRITERION, std::move (l));
      }
#else
      static
      symbol_type
      make_FUNCTION_CONVERGENCE_CRITERION (const location_type& l)
      {
        return symbol_type (token::FUNCTION_CONVERGENCE_CRITERION, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_SAVE_REALTIME (location_type l)
      {
        return symbol_type (token::SAVE_REALTIME, std::move (l));
      }
#else
      static
      symbol_type
      make_SAVE_REALTIME (const location_type& l)
      {
        return symbol_type (token::SAVE_REALTIME, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_PARAMETER_CONVERGENCE_CRITERION (location_type l)
      {
        return symbol_type (token::PARAMETER_CONVERGENCE_CRITERION, std::move (l));
      }
#else
      static
      symbol_type
      make_PARAMETER_CONVERGENCE_CRITERION (const location_type& l)
      {
        return symbol_type (token::PARAMETER_CONVERGENCE_CRITERION, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_NUMBER_OF_LARGE_PERTURBATIONS (location_type l)
      {
        return symbol_type (token::NUMBER_OF_LARGE_PERTURBATIONS, std::move (l));
      }
#else
      static
      symbol_type
      make_NUMBER_OF_LARGE_PERTURBATIONS (const location_type& l)
      {
        return symbol_type (token::NUMBER_OF_LARGE_PERTURBATIONS, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_NUMBER_OF_SMALL_PERTURBATIONS (location_type l)
      {
        return symbol_type (token::NUMBER_OF_SMALL_PERTURBATIONS, std::move (l));
      }
#else
      static
      symbol_type
      make_NUMBER_OF_SMALL_PERTURBATIONS (const location_type& l)
      {
        return symbol_type (token::NUMBER_OF_SMALL_PERTURBATIONS, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_NUMBER_OF_POSTERIOR_DRAWS_AFTER_PERTURBATION (location_type l)
      {
        return symbol_type (token::NUMBER_OF_POSTERIOR_DRAWS_AFTER_PERTURBATION, std::move (l));
      }
#else
      static
      symbol_type
      make_NUMBER_OF_POSTERIOR_DRAWS_AFTER_PERTURBATION (const location_type& l)
      {
        return symbol_type (token::NUMBER_OF_POSTERIOR_DRAWS_AFTER_PERTURBATION, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_MAX_NUMBER_OF_STAGES (location_type l)
      {
        return symbol_type (token::MAX_NUMBER_OF_STAGES, std::move (l));
      }
#else
      static
      symbol_type
      make_MAX_NUMBER_OF_STAGES (const location_type& l)
      {
        return symbol_type (token::MAX_NUMBER_OF_STAGES, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_RANDOM_FUNCTION_CONVERGENCE_CRITERION (location_type l)
      {
        return symbol_type (token::RANDOM_FUNCTION_CONVERGENCE_CRITERION, std::move (l));
      }
#else
      static
      symbol_type
      make_RANDOM_FUNCTION_CONVERGENCE_CRITERION (const location_type& l)
      {
        return symbol_type (token::RANDOM_FUNCTION_CONVERGENCE_CRITERION, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_RANDOM_PARAMETER_CONVERGENCE_CRITERION (location_type l)
      {
        return symbol_type (token::RANDOM_PARAMETER_CONVERGENCE_CRITERION, std::move (l));
      }
#else
      static
      symbol_type
      make_RANDOM_PARAMETER_CONVERGENCE_CRITERION (const location_type& l)
      {
        return symbol_type (token::RANDOM_PARAMETER_CONVERGENCE_CRITERION, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_CENTERED_MOMENTS (location_type l)
      {
        return symbol_type (token::CENTERED_MOMENTS, std::move (l));
      }
#else
      static
      symbol_type
      make_CENTERED_MOMENTS (const location_type& l)
      {
        return symbol_type (token::CENTERED_MOMENTS, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_AUTOLAG (location_type l)
      {
        return symbol_type (token::AUTOLAG, std::move (l));
      }
#else
      static
      symbol_type
      make_AUTOLAG (const location_type& l)
      {
        return symbol_type (token::AUTOLAG, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_RECURSIVE_ORDER_ESTIMATION (location_type l)
      {
        return symbol_type (token::RECURSIVE_ORDER_ESTIMATION, std::move (l));
      }
#else
      static
      symbol_type
      make_RECURSIVE_ORDER_ESTIMATION (const location_type& l)
      {
        return symbol_type (token::RECURSIVE_ORDER_ESTIMATION, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_BARTLETT_KERNEL_LAG (location_type l)
      {
        return symbol_type (token::BARTLETT_KERNEL_LAG, std::move (l));
      }
#else
      static
      symbol_type
      make_BARTLETT_KERNEL_LAG (const location_type& l)
      {
        return symbol_type (token::BARTLETT_KERNEL_LAG, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_WEIGHTING_MATRIX (location_type l)
      {
        return symbol_type (token::WEIGHTING_MATRIX, std::move (l));
      }
#else
      static
      symbol_type
      make_WEIGHTING_MATRIX (const location_type& l)
      {
        return symbol_type (token::WEIGHTING_MATRIX, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_PENALIZED_ESTIMATOR (location_type l)
      {
        return symbol_type (token::PENALIZED_ESTIMATOR, std::move (l));
      }
#else
      static
      symbol_type
      make_PENALIZED_ESTIMATOR (const location_type& l)
      {
        return symbol_type (token::PENALIZED_ESTIMATOR, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_VERBOSE (location_type l)
      {
        return symbol_type (token::VERBOSE, std::move (l));
      }
#else
      static
      symbol_type
      make_VERBOSE (const location_type& l)
      {
        return symbol_type (token::VERBOSE, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_SIMULATION_MULTIPLE (location_type l)
      {
        return symbol_type (token::SIMULATION_MULTIPLE, std::move (l));
      }
#else
      static
      symbol_type
      make_SIMULATION_MULTIPLE (const location_type& l)
      {
        return symbol_type (token::SIMULATION_MULTIPLE, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_SEED (location_type l)
      {
        return symbol_type (token::SEED, std::move (l));
      }
#else
      static
      symbol_type
      make_SEED (const location_type& l)
      {
        return symbol_type (token::SEED, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_BOUNDED_SHOCK_SUPPORT (location_type l)
      {
        return symbol_type (token::BOUNDED_SHOCK_SUPPORT, std::move (l));
      }
#else
      static
      symbol_type
      make_BOUNDED_SHOCK_SUPPORT (const location_type& l)
      {
        return symbol_type (token::BOUNDED_SHOCK_SUPPORT, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_EQTAGS (location_type l)
      {
        return symbol_type (token::EQTAGS, std::move (l));
      }
#else
      static
      symbol_type
      make_EQTAGS (const location_type& l)
      {
        return symbol_type (token::EQTAGS, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_STEADY_STATE_GROWTH (location_type l)
      {
        return symbol_type (token::STEADY_STATE_GROWTH, std::move (l));
      }
#else
      static
      symbol_type
      make_STEADY_STATE_GROWTH (const location_type& l)
      {
        return symbol_type (token::STEADY_STATE_GROWTH, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_ANALYTICAL_GIRF (location_type l)
      {
        return symbol_type (token::ANALYTICAL_GIRF, std::move (l));
      }
#else
      static
      symbol_type
      make_ANALYTICAL_GIRF (const location_type& l)
      {
        return symbol_type (token::ANALYTICAL_GIRF, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_IRF_IN_PERCENT (location_type l)
      {
        return symbol_type (token::IRF_IN_PERCENT, std::move (l));
      }
#else
      static
      symbol_type
      make_IRF_IN_PERCENT (const location_type& l)
      {
        return symbol_type (token::IRF_IN_PERCENT, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_EMAS_GIRF (location_type l)
      {
        return symbol_type (token::EMAS_GIRF, std::move (l));
      }
#else
      static
      symbol_type
      make_EMAS_GIRF (const location_type& l)
      {
        return symbol_type (token::EMAS_GIRF, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_EMAS_DROP (location_type l)
      {
        return symbol_type (token::EMAS_DROP, std::move (l));
      }
#else
      static
      symbol_type
      make_EMAS_DROP (const location_type& l)
      {
        return symbol_type (token::EMAS_DROP, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_EMAS_TOLF (location_type l)
      {
        return symbol_type (token::EMAS_TOLF, std::move (l));
      }
#else
      static
      symbol_type
      make_EMAS_TOLF (const location_type& l)
      {
        return symbol_type (token::EMAS_TOLF, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_EMAS_MAX_ITER (location_type l)
      {
        return symbol_type (token::EMAS_MAX_ITER, std::move (l));
      }
#else
      static
      symbol_type
      make_EMAS_MAX_ITER (const location_type& l)
      {
        return symbol_type (token::EMAS_MAX_ITER, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_NO_IDENTIFICATION_STRENGTH (location_type l)
      {
        return symbol_type (token::NO_IDENTIFICATION_STRENGTH, std::move (l));
      }
#else
      static
      symbol_type
      make_NO_IDENTIFICATION_STRENGTH (const location_type& l)
      {
        return symbol_type (token::NO_IDENTIFICATION_STRENGTH, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_NO_IDENTIFICATION_REDUCEDFORM (location_type l)
      {
        return symbol_type (token::NO_IDENTIFICATION_REDUCEDFORM, std::move (l));
      }
#else
      static
      symbol_type
      make_NO_IDENTIFICATION_REDUCEDFORM (const location_type& l)
      {
        return symbol_type (token::NO_IDENTIFICATION_REDUCEDFORM, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_NO_IDENTIFICATION_MOMENTS (location_type l)
      {
        return symbol_type (token::NO_IDENTIFICATION_MOMENTS, std::move (l));
      }
#else
      static
      symbol_type
      make_NO_IDENTIFICATION_MOMENTS (const location_type& l)
      {
        return symbol_type (token::NO_IDENTIFICATION_MOMENTS, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_NO_IDENTIFICATION_MINIMAL (location_type l)
      {
        return symbol_type (token::NO_IDENTIFICATION_MINIMAL, std::move (l));
      }
#else
      static
      symbol_type
      make_NO_IDENTIFICATION_MINIMAL (const location_type& l)
      {
        return symbol_type (token::NO_IDENTIFICATION_MINIMAL, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_NO_IDENTIFICATION_SPECTRUM (location_type l)
      {
        return symbol_type (token::NO_IDENTIFICATION_SPECTRUM, std::move (l));
      }
#else
      static
      symbol_type
      make_NO_IDENTIFICATION_SPECTRUM (const location_type& l)
      {
        return symbol_type (token::NO_IDENTIFICATION_SPECTRUM, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_NORMALIZE_JACOBIANS (location_type l)
      {
        return symbol_type (token::NORMALIZE_JACOBIANS, std::move (l));
      }
#else
      static
      symbol_type
      make_NORMALIZE_JACOBIANS (const location_type& l)
      {
        return symbol_type (token::NORMALIZE_JACOBIANS, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_GRID_NBR (location_type l)
      {
        return symbol_type (token::GRID_NBR, std::move (l));
      }
#else
      static
      symbol_type
      make_GRID_NBR (const location_type& l)
      {
        return symbol_type (token::GRID_NBR, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_TOL_RANK (location_type l)
      {
        return symbol_type (token::TOL_RANK, std::move (l));
      }
#else
      static
      symbol_type
      make_TOL_RANK (const location_type& l)
      {
        return symbol_type (token::TOL_RANK, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_TOL_DERIV (location_type l)
      {
        return symbol_type (token::TOL_DERIV, std::move (l));
      }
#else
      static
      symbol_type
      make_TOL_DERIV (const location_type& l)
      {
        return symbol_type (token::TOL_DERIV, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_TOL_SV (location_type l)
      {
        return symbol_type (token::TOL_SV, std::move (l));
      }
#else
      static
      symbol_type
      make_TOL_SV (const location_type& l)
      {
        return symbol_type (token::TOL_SV, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_CHECKS_VIA_SUBSETS (location_type l)
      {
        return symbol_type (token::CHECKS_VIA_SUBSETS, std::move (l));
      }
#else
      static
      symbol_type
      make_CHECKS_VIA_SUBSETS (const location_type& l)
      {
        return symbol_type (token::CHECKS_VIA_SUBSETS, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_MAX_DIM_SUBSETS_GROUPS (location_type l)
      {
        return symbol_type (token::MAX_DIM_SUBSETS_GROUPS, std::move (l));
      }
#else
      static
      symbol_type
      make_MAX_DIM_SUBSETS_GROUPS (const location_type& l)
      {
        return symbol_type (token::MAX_DIM_SUBSETS_GROUPS, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_MAX_NROWS (location_type l)
      {
        return symbol_type (token::MAX_NROWS, std::move (l));
      }
#else
      static
      symbol_type
      make_MAX_NROWS (const location_type& l)
      {
        return symbol_type (token::MAX_NROWS, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_SQUEEZE_SHOCK_DECOMPOSITION (location_type l)
      {
        return symbol_type (token::SQUEEZE_SHOCK_DECOMPOSITION, std::move (l));
      }
#else
      static
      symbol_type
      make_SQUEEZE_SHOCK_DECOMPOSITION (const location_type& l)
      {
        return symbol_type (token::SQUEEZE_SHOCK_DECOMPOSITION, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_WITH_EPILOGUE (location_type l)
      {
        return symbol_type (token::WITH_EPILOGUE, std::move (l));
      }
#else
      static
      symbol_type
      make_WITH_EPILOGUE (const location_type& l)
      {
        return symbol_type (token::WITH_EPILOGUE, l);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_SYMBOL_VEC (vector<string> v, location_type l)
      {
        return symbol_type (token::SYMBOL_VEC, std::move (v), std::move (l));
      }
#else
      static
      symbol_type
      make_SYMBOL_VEC (const vector<string>& v, const location_type& l)
      {
        return symbol_type (token::SYMBOL_VEC, v, l);
      }
#endif


  private:
    /// This class is not copyable.
    parser (const parser&);
    parser& operator= (const parser&);

    /// State numbers.
    typedef int state_type;

    /// Generate an error message.
    /// \param yystate   the state where the error occurred.
    /// \param yyla      the lookahead token.
    virtual std::string yysyntax_error_ (state_type yystate,
                                         const symbol_type& yyla) const;

    /// Compute post-reduction state.
    /// \param yystate   the current state
    /// \param yysym     the nonterminal to push on the stack
    state_type yy_lr_goto_state_ (state_type yystate, int yysym);

    /// Whether the given \c yypact_ value indicates a defaulted state.
    /// \param yyvalue   the value to check
    static bool yy_pact_value_is_default_ (int yyvalue);

    /// Whether the given \c yytable_ value indicates a syntax error.
    /// \param yyvalue   the value to check
    static bool yy_table_value_is_error_ (int yyvalue);

    static const short yypact_ninf_;
    static const short yytable_ninf_;

    /// Convert a scanner token number \a t to a symbol number.
    static token_number_type yytranslate_ (int t);

    // Tables.
  // YYPACT[STATE-NUM] -- Index in YYTABLE of the portion describing
  // STATE-NUM.
  static const short yypact_[];

  // YYDEFACT[STATE-NUM] -- Default reduction number in state STATE-NUM.
  // Performed when YYTABLE does not specify something else to do.  Zero
  // means the default is an error.
  static const unsigned short yydefact_[];

  // YYPGOTO[NTERM-NUM].
  static const short yypgoto_[];

  // YYDEFGOTO[NTERM-NUM].
  static const short yydefgoto_[];

  // YYTABLE[YYPACT[STATE-NUM]] -- What to do in state STATE-NUM.  If
  // positive, shift that token.  If negative, reduce the rule whose
  // number is the opposite.  If YYTABLE_NINF, syntax error.
  static const short yytable_[];

  static const short yycheck_[];

  // YYSTOS[STATE-NUM] -- The (internal number of the) accessing
  // symbol of state STATE-NUM.
  static const unsigned short yystos_[];

  // YYR1[YYN] -- Symbol number of symbol that rule YYN derives.
  static const unsigned short yyr1_[];

  // YYR2[YYN] -- Number of symbols on the right hand side of rule YYN.
  static const unsigned char yyr2_[];


    /// Convert the symbol name \a n to a form suitable for a diagnostic.
    static std::string yytnamerr_ (const char *n);


    /// For a symbol, its name in clear.
    static const char* const yytname_[];
#if YYDEBUG
  // YYRLINE[YYN] -- Source line where rule number YYN was defined.
  static const unsigned short yyrline_[];
    /// Report on the debug stream that the rule \a r is going to be reduced.
    virtual void yy_reduce_print_ (int r);
    /// Print the state stack on the debug stream.
    virtual void yystack_print_ ();

    /// Debugging level.
    int yydebug_;
    /// Debug stream.
    std::ostream* yycdebug_;

    /// \brief Display a symbol type, value and location.
    /// \param yyo    The output stream.
    /// \param yysym  The symbol.
    template <typename Base>
    void yy_print_ (std::ostream& yyo, const basic_symbol<Base>& yysym) const;
#endif

    /// \brief Reclaim the memory associated to a symbol.
    /// \param yymsg     Why this token is reclaimed.
    ///                  If null, print nothing.
    /// \param yysym     The symbol.
    template <typename Base>
    void yy_destroy_ (const char* yymsg, basic_symbol<Base>& yysym) const;

  private:
    /// Type access provider for state based symbols.
    struct by_state
    {
      /// Default constructor.
      by_state () YY_NOEXCEPT;

      /// The symbol type as needed by the constructor.
      typedef state_type kind_type;

      /// Constructor.
      by_state (kind_type s) YY_NOEXCEPT;

      /// Copy constructor.
      by_state (const by_state& that) YY_NOEXCEPT;

      /// Record that this symbol is empty.
      void clear () YY_NOEXCEPT;

      /// Steal the symbol type from \a that.
      void move (by_state& that);

      /// The (internal) type number (corresponding to \a state).
      /// \a empty_symbol when empty.
      symbol_number_type type_get () const YY_NOEXCEPT;

      /// The state number used to denote an empty symbol.
      enum { empty_state = -1 };

      /// The state.
      /// \a empty when empty.
      state_type state;
    };

    /// "Internal" symbol: element of the stack.
    struct stack_symbol_type : basic_symbol<by_state>
    {
      /// Superclass.
      typedef basic_symbol<by_state> super_type;
      /// Construct an empty symbol.
      stack_symbol_type ();
      /// Move or copy construction.
      stack_symbol_type (YY_RVREF (stack_symbol_type) that);
      /// Steal the contents from \a sym to build this.
      stack_symbol_type (state_type s, YY_MOVE_REF (symbol_type) sym);
#if YY_CPLUSPLUS < 201103L
      /// Assignment, needed by push_back by some old implementations.
      /// Moves the contents of that.
      stack_symbol_type& operator= (stack_symbol_type& that);
#endif
    };

    /// A stack with random access from its top.
    template <typename T, typename S = std::vector<T> >
    class stack
    {
    public:
      // Hide our reversed order.
      typedef typename S::reverse_iterator iterator;
      typedef typename S::const_reverse_iterator const_iterator;
      typedef typename S::size_type size_type;

      stack (size_type n = 200)
        : seq_ (n)
      {}

      /// Random access.
      ///
      /// Index 0 returns the topmost element.
      T&
      operator[] (size_type i)
      {
        return seq_[size () - 1 - i];
      }

      /// Random access.
      ///
      /// Index 0 returns the topmost element.
      T&
      operator[] (int i)
      {
        return operator[] (size_type (i));
      }

      /// Random access.
      ///
      /// Index 0 returns the topmost element.
      const T&
      operator[] (size_type i) const
      {
        return seq_[size () - 1 - i];
      }

      /// Random access.
      ///
      /// Index 0 returns the topmost element.
      const T&
      operator[] (int i) const
      {
        return operator[] (size_type (i));
      }

      /// Steal the contents of \a t.
      ///
      /// Close to move-semantics.
      void
      push (YY_MOVE_REF (T) t)
      {
        seq_.push_back (T ());
        operator[] (0).move (t);
      }

      /// Pop elements from the stack.
      void
      pop (int n = 1) YY_NOEXCEPT
      {
        for (; 0 < n; --n)
          seq_.pop_back ();
      }

      /// Pop all elements from the stack.
      void
      clear () YY_NOEXCEPT
      {
        seq_.clear ();
      }

      /// Number of elements on the stack.
      size_type
      size () const YY_NOEXCEPT
      {
        return seq_.size ();
      }

      /// Iterator on top of the stack (going downwards).
      const_iterator
      begin () const YY_NOEXCEPT
      {
        return seq_.rbegin ();
      }

      /// Bottom of the stack.
      const_iterator
      end () const YY_NOEXCEPT
      {
        return seq_.rend ();
      }

      /// Present a slice of the top of a stack.
      class slice
      {
      public:
        slice (const stack& stack, int range)
          : stack_ (stack)
          , range_ (range)
        {}

        const T&
        operator[] (int i) const
        {
          return stack_[range_ - i];
        }

      private:
        const stack& stack_;
        int range_;
      };

    private:
      stack (const stack&);
      stack& operator= (const stack&);
      /// The wrapped container.
      S seq_;
    };


    /// Stack type.
    typedef stack<stack_symbol_type> stack_type;

    /// The stack.
    stack_type yystack_;

    /// Push a new state on the stack.
    /// \param m    a debug message to display
    ///             if null, no trace is output.
    /// \param sym  the symbol
    /// \warning the contents of \a s.value is stolen.
    void yypush_ (const char* m, YY_MOVE_REF (stack_symbol_type) sym);

    /// Push a new look ahead token on the state on the stack.
    /// \param m    a debug message to display
    ///             if null, no trace is output.
    /// \param s    the state
    /// \param sym  the symbol (for its value and location).
    /// \warning the contents of \a sym.value is stolen.
    void yypush_ (const char* m, state_type s, YY_MOVE_REF (symbol_type) sym);

    /// Pop \a n symbols from the stack.
    void yypop_ (int n = 1);

    /// Constants.
    enum
    {
      yyeof_ = 0,
      yylast_ = 13554,     ///< Last index in yytable_.
      yynnts_ = 832,  ///< Number of nonterminal symbols.
      yyfinal_ = 431, ///< Termination state number.
      yyterror_ = 1,
      yyerrcode_ = 256,
      yyntokens_ = 652  ///< Number of tokens.
    };


    // User arguments.
    ParsingDriver &driver;
  };


#line 25 "DynareBison.yy" // lalr1.cc:401
} // Dynare
#line 11557 "DynareBison.hh" // lalr1.cc:401




#endif // !YY_YY_DYNAREBISON_HH_INCLUDED
