package org.apache.maven.doxia.site.decoration.inheritance;

/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

import java.io.File;

import junit.framework.TestCase;

/**
 *
 * @author ltheussl
 * @version $Id: PathUtilsTest.java 798148 2009-07-27 14:19:43Z ltheussl $
 */
public class PathUtilsTest
        extends TestCase
{
    private static final String SLASH = File.separator;

    /** @throws Exception */
    public void testConvertPath()
            throws Exception
    {
        PathDescriptor oldPath = new PathDescriptor( (String) null, "base" );
        PathDescriptor newPath = new PathDescriptor( "/tmp", "target" );
        assertEquals( oldPath, PathUtils.convertPath( oldPath, newPath ) );
        assertEquals( newPath, PathUtils.convertPath( newPath, oldPath ) );
    }

    /** @throws Exception */
    public void testGetRelativePath()
            throws Exception
    {
        PathDescriptor oldPath = new PathDescriptor( "/tmp/foo", "base" );
        PathDescriptor newPath = new PathDescriptor( "/tmp", "target" );
        assertEquals( ".." + SLASH + ".." + SLASH + "target",
                PathUtils.getRelativePath( oldPath, newPath ) );

        oldPath = new PathDescriptor( (String) null, "base" );
        assertNull( PathUtils.getRelativePath( oldPath, newPath ) );
        assertNull( PathUtils.getRelativePath( newPath, oldPath ) );

        oldPath = new PathDescriptor( "/tmp/foo", null );
        assertEquals( ".." + SLASH + "target", PathUtils.getRelativePath( oldPath, newPath ) );
        assertEquals( ".." + SLASH + "foo", PathUtils.getRelativePath( newPath, oldPath ) );
    }
}
