/* doscan - Denial Of Service Capable Auditing of Networks
 * Copyright (C) 2003 Florian Weimer
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#ifndef RESULTS_H
#define RESULTS_H

#include "ipv4.h"
#include "ticks.h"

#include <cstdio>
#include <cstdlib>
#include <string>

#define RESULTS_ERROR_NOMATCH (-1)
#define RESULTS_ERROR_NODATA (-2)

void results_style (const char *style);
/* Set the output style (e.g. "unsorted"). */

void results_format (const char *);
/* Sets the output format, for the --output option. */

void results_add (ticks_t, ipv4_t, int, const char *, size_t);
/* Record error and/or message from host.  Stores a duplicate of the
   input data. */

void results_add (ipv4_t, int, const std::string&);
void results_add (ipv4_t, const std::string&);
/* Like above.  Uses ticks_get_cached().  The second variant does not
   signal an error.*/

void results_add_unquoted (ipv4_t, const std::string&);
void results_add_unquoted (ipv4_t, int, const std::string&);
/* Adds the string to the result list without quoting.  Uses
 * ticks_get_cached(). */

void results_print (void);
/* Prints all results to stdout. */

unsigned results_count (void);
/* Counts the number of result records recorded so far. */

#endif /* RESULTS_H */

/* arch-tag: f8f0b4f6-ee39-4485-9bce-9e54793d2970
 */
