
# browser
    import "github.com/pkg/browser"

Package browser provides helpers to open files, readers, and urls in a browser window.

The choice of which browser is started is entirely client dependant.





## Variables
``` go
var Stderr io.Writer = os.Stderr
```
Stderr is the io.Writer to which executed commands write standard error.

``` go
var Stdout io.Writer = os.Stdout
```
Stdout is the io.Writer to which executed commands write standard output.


## func OpenFile
``` go
func OpenFile(path string) error
```
OpenFile opens new browser window for the file path.


## func OpenReader
``` go
func OpenReader(r io.Reader) error
```
OpenReader consumes the contents of r and presents the
results in a new browser window.


## func OpenURL
``` go
func OpenURL(url string) error
```
OpenURL opens a new browser window pointing to url.









- - -
Generated by [godoc2md](http://godoc.org/github.com/davecheney/godoc2md)
