//
// C++ Interface: settingsdialog
//
// Description: 
//
//
// Author: Rikard Bjorklind <olof@users.sourceforge.net>, (C) 2006
//
// Copyright: See COPYING file that comes with this distribution
//
//
#ifndef SETTINGSDIALOG_H
#define SETTINGSDIALOG_H

#include <QDialog>
#include <boost/shared_ptr.hpp>
#include "ui_settings.h"
#include "backendconnection.h"
#include "shareitemmodel.h"

class QShowEvent;
class ShareItemModel;
class QMenu;

/**
	The settings dialog.
	@author Rikard Bjorklind <olof@users.sourceforge.net>
*/
class SettingsDialog : public QDialog
{
Q_OBJECT
public:
	//! Constructor
    SettingsDialog(boost::shared_ptr<BackendConnection> aBackendConnection,QWidget *parent = 0);
    //! Destructor
	virtual ~SettingsDialog();
	enum BackendConnectionType {USE_LOCAL_BACKEND,USE_REMOTE_BACKEND};
	
public slots:
	//! Called when new settings arrive from the RpcDriver.
	void settingsInfo(const QList<QString>&,const QList<QVariant>&);
	//! Called when the shared dirs arrive.
	void sharedDirs(const QList<ShareItem>);	
	
protected:
	//! Requests settings data from the backend.
	virtual void showEvent(QShowEvent *event);

private:
	Ui::SettingsDialog ui;
	//! Returns a list of setting keys required for normal operation.
	QList<QString> getRequiredSettings();
	boost::shared_ptr<BackendConnection> backendConnection;
	ShareItemModel* shareItemModel;
	QMenu *contextMenu;
	
	
private slots:
	void on_dldirButton_pressed();
	void on_finisheddirButton_pressed();
	
	//! Called when the ok button is pressed.
	//! Stores the settings and accepts the dialog.
	void on_okButton_pressed();
	
	void onDirDropped(const QString&);
	void onLeftMouse();
	void onContextMenu(const QPoint&);
};

#endif
