/******************************************************************************
 * Top contributors (to current version):
 *   Andrew Reynolds, Aina Niemetz
 *
 * This file is part of the cvc5 project.
 *
 * Copyright (c) 2009-2023 by the authors listed in the file AUTHORS
 * in the top-level source directory and their institutional affiliations.
 * All rights reserved.  See the file COPYING in the top-level source
 * directory for licensing information.
 * ****************************************************************************
 *
 * Expression miner manager, which manages individual expression miners.
 */

#include "cvc5_private.h"

#ifndef CVC5__THEORY__QUANTIFIERS__EXPR_MINER_MANAGER_H
#define CVC5__THEORY__QUANTIFIERS__EXPR_MINER_MANAGER_H

#include "expr/node.h"
#include "smt/env_obj.h"
#include "theory/quantifiers/solution_filter.h"

namespace cvc5::internal {
namespace theory {
namespace quantifiers {

/**
 * ExpressionMinerManager
 *
 * NOTE: this should be renamed to "solution filter".
 */
class ExpressionMinerManager : protected EnvObj
{
 public:
  ExpressionMinerManager(Env& env);
  ~ExpressionMinerManager() {}
  /** Initialize this class, sygus version
   *
   * Initializes this class, informing it that the terms added to this class
   * via calls to addTerm will be generated by the grammar of f. The method
   * takes a pointer to the quantifiers engine qe. If the argument useSygusType
   * is true, the terms added to this class are the sygus datatype terms.
   * If useSygusType is false, the terms are the builtin equivalent of these
   * terms. The argument nsamples is used to initialize the sampler.
   */
  void initializeSygus(const TypeNode& tn);
  /** add term
   *
   * Expression miners may print information on the output stream out, for
   * instance, candidate-rewrites. The method returns true if the term sol is
   * distinct (up to T-equivalence) with all previous terms added to this class,
   * which is computed based on the miners that this manager enables.
   */
  bool addTerm(Node sol);

 private:
  /** filter strong solutions (--sygus-filter-sol=strong) */
  void enableFilterStrongSolutions();
  /** filter weak solutions (--sygus-filter-sol=weak) */
  void enableFilterWeakSolutions();
  /** whether we are filtering solutions based on logical strength */
  bool d_doFilterLogicalStrength;
  /** solution filter based on logical strength */
  SolutionFilterStrength d_sols;
  /** The variables */
  std::vector<Node> d_vars;
};

}  // namespace quantifiers
}  // namespace theory
}  // namespace cvc5::internal

#endif /* CVC5__THEORY__QUANTIFIERS__EXPR_MINER_MANAGER_H */
