/***************************************************************************
 *     Copyright (c) 1999-2009, Broadcom Corporation
 *
 **********************************************************************
 * This file is part of the crystalhd device driver.
 *
 * This driver is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, version 2 of the License.
 *
 * This driver is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this driver.  If not, see <http://www.gnu.org/licenses/>.
 **********************************************************************
 *
 * $brcm_Workfile: bchp_mfd.h $
 * $brcm_Revision: Hydra_Software_Devel/1 $
 * $brcm_Date: 7/17/09 8:11p $
 *
 * Module Description:
 *                     DO NOT EDIT THIS FILE DIRECTLY
 *
 * This module was generated magically with RDB from a source description
 * file. You must edit the source file for changes to be made to this file.
 *
 *
 * Date:           Generated on         Fri Jul 17 19:42:31 2009
 *                 MD5 Checksum         2914699efc3fb3edefca5cb4f4f38b34
 *
 * Compiled with:  RDB Utility          combo_header.pl
 *                 RDB Parser           3.0
 *                 unknown              unknown
 *                 Perl Interpreter     5.008008
 *                 Operating System     linux
 *
 * Revision History:
 *
 * $brcm_Log: /magnum/basemodules/chp/70015/rdb/a0/bchp_mfd.h $
 * 
 * Hydra_Software_Devel/1   7/17/09 8:11p albertl
 * PR56880: Initial revision.
 *
 ***************************************************************************/

#ifndef BCHP_MFD_H__
#define BCHP_MFD_H__

/***************************************************************************
 *MFD - MPEG Feeder Registers
 ***************************************************************************/
#define BCHP_MFD_REVISION_ID                     0x00540000 /* MPEG/Video Feeder Revision Register */
#define BCHP_MFD_FEEDER_CNTL                     0x00540004 /* MPEG/Video Feeder Control Register */
#define BCHP_MFD_FIXED_COLOUR                    0x00540008 /* MPEG/Video Feeder Fixed Colour Value Register */
#define BCHP_MFD_LAC_CNTL                        0x0054000c /* MPEG/Video Feeder LAC Control Register */
#define BCHP_MFD_STRIDE                          0x00540010 /* MPEG/Video Feeder Stride Register */
#define BCHP_MFD_DISP_HSIZE                      0x00540014 /* MPEG/Video Feeder Horizontal Display Size Register */
#define BCHP_MFD_PICTURE0_DISP_VERT_WINDOW       0x00540018 /* MPEG/Video Feeder Display Vertical Window Register */
#define BCHP_MFD_PICTURE0_LINE_ADDR_0            0x0054001c /* MPEG/Video Feeder Line Address0 Register */
#define BCHP_MFD_PICTURE0_LINE_ADDR_1            0x00540020 /* MPEG/Video Feeder Line Address1 Register */
#define BCHP_MFD_CHROMA_SAMPLING_CNTL            0x00540024 /* MPEG Feeder Chroma Sampling Control Register */
#define BCHP_MFD_LUMA_NMBY                       0x00540028 /* MPEG Feeder Luma NMBY Size Register */
#define BCHP_MFD_CHROMA_NMBY                     0x0054002c /* MPEG Feeder Chroma NMBY Size Register */
#define BCHP_MFD_PIC_FEED_CMD                    0x00540030 /* MPEG/Video Feeder Picture Feed Command Register */
#define BCHP_MFD_CRC_CTRL                        0x00540034 /* MPEG/Video Feeder CRC Control Register */
#define BCHP_MFD_CRC_SEED                        0x00540038 /* MPEG/Video Feeder CRC Seed Register */
#define BCHP_MFD_LUMA_CRC                        0x0054003c /* MPEG/Video Feeder Luma CRC Register */
#define BCHP_MFD_CHROMA_CRC                      0x00540040 /* MPEG/Video Feeder Chroma CRC Register */
#define BCHP_MFD_DATA_MODE                       0x00540044 /* MPEG/Video Feeder Data Mode Register */
#define BCHP_MFD_PIC_OFFSET                      0x00540048 /* MPEG/Video Feeder Picture Offset Register */
#define BCHP_MFD_RANGE_EXP_REMAP_CNTL            0x0054004c /* MPEG/Video Feeder Range Expansion / Remapping Control Register */
#define BCHP_MFD_FEED_STATUS                     0x00540050 /* MPEG/Video Feeder Feed Status Register */
#define BCHP_MFD_PICTURE0_LAC_LINE_ADDR_0        0x00540054 /* MPEG/Video Feeder Line Address Computer Line Address0 Register */
#define BCHP_MFD_PICTURE0_LAC_LINE_ADDR_1        0x00540058 /* MPEG/Video Feeder Line Address Computer Line Address1 Register */
#define BCHP_MFD_PICTURE0_LAC_CHROMA_VERT_FILTER_CONFIG 0x0054005c /* MPEG/Video Feeder Line Address Computer Chroma Vertical Filter Configuration Register */
#define BCHP_MFD_LAC_LINE_FEED_CNTL              0x00540060 /* MPEG/Video Feeder Line Address Computer Line Feed Control Register */
#define BCHP_MFD_FEEDER_TIMEOUT_REPEAT_PIC_CNTL  0x00540064 /* MPEG/Video Feeder Timeout and Repeat Picture Control Register */
#define BCHP_MFD_BVB_RX_STALL_TIMEOUT_CNTL       0x00540068 /* MPEG/Video Feeder BVB Receiver Stall Timeout Control Register */
#define BCHP_MFD_FEEDER_ERROR_INTERRUPT_STATUS   0x0054006c /* MPEG/Video Feeder Error Interrupt Status Register */
#define BCHP_MFD_FEEDER_BVB_STATUS               0x00540070 /* MPEG/Video Feeder BVB Status Register */
#define BCHP_MFD_TEST_MODE_CNTL                  0x00540074 /* MPEG/Video Feeder Test Mode Control Register */
#define BCHP_MFD_BVB_SAMPLE_DATA                 0x00540078 /* MPEG/Video Feeder BVB Output Sample Data Register */
#define BCHP_MFD_TEST_PORT_CNTL                  0x0054007c /* MPEG/Video Feeder Test port Control Register */
#define BCHP_MFD_TEST_PORT_DATA                  0x00540080 /* MPEG/Video Feeder Test port Data Register */
#define BCHP_MFD_SCRATCH_REGISTER_0              0x005400f8 /* MPEG/Video Feeder Scratch 0 Register */
#define BCHP_MFD_SCRATCH_REGISTER_1              0x005400fc /* MPEG/Video Feeder Scratch 1 Register */

/***************************************************************************
 *REVISION_ID - MPEG/Video Feeder Revision Register
 ***************************************************************************/
/* MFD :: REVISION_ID :: reserved0 [31:16] */
#define BCHP_MFD_REVISION_ID_reserved0_MASK                        0xffff0000
#define BCHP_MFD_REVISION_ID_reserved0_SHIFT                       16

/* MFD :: REVISION_ID :: MAJOR [15:08] */
#define BCHP_MFD_REVISION_ID_MAJOR_MASK                            0x0000ff00
#define BCHP_MFD_REVISION_ID_MAJOR_SHIFT                           8

/* MFD :: REVISION_ID :: MINOR [07:00] */
#define BCHP_MFD_REVISION_ID_MINOR_MASK                            0x000000ff
#define BCHP_MFD_REVISION_ID_MINOR_SHIFT                           0

/***************************************************************************
 *FEEDER_CNTL - MPEG/Video Feeder Control Register
 ***************************************************************************/
/* MFD :: FEEDER_CNTL :: reserved0 [31:04] */
#define BCHP_MFD_FEEDER_CNTL_reserved0_MASK                        0xfffffff0
#define BCHP_MFD_FEEDER_CNTL_reserved0_SHIFT                       4

/* MFD :: FEEDER_CNTL :: FIXED_COLOUR_ENABLE [03:03] */
#define BCHP_MFD_FEEDER_CNTL_FIXED_COLOUR_ENABLE_MASK              0x00000008
#define BCHP_MFD_FEEDER_CNTL_FIXED_COLOUR_ENABLE_SHIFT             3
#define BCHP_MFD_FEEDER_CNTL_FIXED_COLOUR_ENABLE_OFF               0
#define BCHP_MFD_FEEDER_CNTL_FIXED_COLOUR_ENABLE_ON                1

/* MFD :: FEEDER_CNTL :: PACKING_TYPE [02:01] */
#define BCHP_MFD_FEEDER_CNTL_PACKING_TYPE_MASK                     0x00000006
#define BCHP_MFD_FEEDER_CNTL_PACKING_TYPE_SHIFT                    1
#define BCHP_MFD_FEEDER_CNTL_PACKING_TYPE_U0_Y0_V0_Y1              0
#define BCHP_MFD_FEEDER_CNTL_PACKING_TYPE_V0_Y0_U0_Y1              1
#define BCHP_MFD_FEEDER_CNTL_PACKING_TYPE_Y0_U0_Y1_V0              2
#define BCHP_MFD_FEEDER_CNTL_PACKING_TYPE_Y0_V0_Y1_U0              3

/* MFD :: FEEDER_CNTL :: IMAGE_FORMAT [00:00] */
#define BCHP_MFD_FEEDER_CNTL_IMAGE_FORMAT_MASK                     0x00000001
#define BCHP_MFD_FEEDER_CNTL_IMAGE_FORMAT_SHIFT                    0
#define BCHP_MFD_FEEDER_CNTL_IMAGE_FORMAT_AVC_MPEG                 0
#define BCHP_MFD_FEEDER_CNTL_IMAGE_FORMAT_PACKED                   1

/***************************************************************************
 *FIXED_COLOUR - MPEG/Video Feeder Fixed Colour Value Register
 ***************************************************************************/
/* MFD :: FIXED_COLOUR :: reserved0 [31:24] */
#define BCHP_MFD_FIXED_COLOUR_reserved0_MASK                       0xff000000
#define BCHP_MFD_FIXED_COLOUR_reserved0_SHIFT                      24

/* MFD :: FIXED_COLOUR :: LUMA [23:16] */
#define BCHP_MFD_FIXED_COLOUR_LUMA_MASK                            0x00ff0000
#define BCHP_MFD_FIXED_COLOUR_LUMA_SHIFT                           16

/* MFD :: FIXED_COLOUR :: CB [15:08] */
#define BCHP_MFD_FIXED_COLOUR_CB_MASK                              0x0000ff00
#define BCHP_MFD_FIXED_COLOUR_CB_SHIFT                             8

/* MFD :: FIXED_COLOUR :: CR [07:00] */
#define BCHP_MFD_FIXED_COLOUR_CR_MASK                              0x000000ff
#define BCHP_MFD_FIXED_COLOUR_CR_SHIFT                             0

/***************************************************************************
 *LAC_CNTL - MPEG/Video Feeder LAC Control Register
 ***************************************************************************/
/* MFD :: LAC_CNTL :: reserved0 [31:11] */
#define BCHP_MFD_LAC_CNTL_reserved0_MASK                           0xfffff800
#define BCHP_MFD_LAC_CNTL_reserved0_SHIFT                          11

/* MFD :: LAC_CNTL :: STRIPE_WIDTH_SEL [10:10] */
#define BCHP_MFD_LAC_CNTL_STRIPE_WIDTH_SEL_MASK                    0x00000400
#define BCHP_MFD_LAC_CNTL_STRIPE_WIDTH_SEL_SHIFT                   10
#define BCHP_MFD_LAC_CNTL_STRIPE_WIDTH_SEL_BYTES_64                0
#define BCHP_MFD_LAC_CNTL_STRIPE_WIDTH_SEL_BYTES_128               1

/* MFD :: LAC_CNTL :: SKIP_LINE_SIZE [09:06] */
#define BCHP_MFD_LAC_CNTL_SKIP_LINE_SIZE_MASK                      0x000003c0
#define BCHP_MFD_LAC_CNTL_SKIP_LINE_SIZE_SHIFT                     6

/* MFD :: LAC_CNTL :: reserved1 [05:05] */
#define BCHP_MFD_LAC_CNTL_reserved1_MASK                           0x00000020
#define BCHP_MFD_LAC_CNTL_reserved1_SHIFT                          5

/* MFD :: LAC_CNTL :: CHROMA_VERT_POSITION [04:04] */
#define BCHP_MFD_LAC_CNTL_CHROMA_VERT_POSITION_MASK                0x00000010
#define BCHP_MFD_LAC_CNTL_CHROMA_VERT_POSITION_SHIFT               4
#define BCHP_MFD_LAC_CNTL_CHROMA_VERT_POSITION_COLOCATED_WITH_LUMA 0
#define BCHP_MFD_LAC_CNTL_CHROMA_VERT_POSITION_HALF_PIXEL_GRID_BETWEEN_LUMA 1

/* MFD :: LAC_CNTL :: CHROMA_INTERPOLATION [03:03] */
#define BCHP_MFD_LAC_CNTL_CHROMA_INTERPOLATION_MASK                0x00000008
#define BCHP_MFD_LAC_CNTL_CHROMA_INTERPOLATION_SHIFT               3
#define BCHP_MFD_LAC_CNTL_CHROMA_INTERPOLATION_FIELD               0
#define BCHP_MFD_LAC_CNTL_CHROMA_INTERPOLATION_FRAME               1

/* MFD :: LAC_CNTL :: OUTPUT_FIELD_POLARITY [02:02] */
#define BCHP_MFD_LAC_CNTL_OUTPUT_FIELD_POLARITY_MASK               0x00000004
#define BCHP_MFD_LAC_CNTL_OUTPUT_FIELD_POLARITY_SHIFT              2
#define BCHP_MFD_LAC_CNTL_OUTPUT_FIELD_POLARITY_TOP                0
#define BCHP_MFD_LAC_CNTL_OUTPUT_FIELD_POLARITY_BOTTOM             1

/* MFD :: LAC_CNTL :: OUTPUT_TYPE [01:01] */
#define BCHP_MFD_LAC_CNTL_OUTPUT_TYPE_MASK                         0x00000002
#define BCHP_MFD_LAC_CNTL_OUTPUT_TYPE_SHIFT                        1
#define BCHP_MFD_LAC_CNTL_OUTPUT_TYPE_INTERLACED                   0
#define BCHP_MFD_LAC_CNTL_OUTPUT_TYPE_PROGRESSIVE                  1

/* MFD :: LAC_CNTL :: CHROMA_TYPE [00:00] */
#define BCHP_MFD_LAC_CNTL_CHROMA_TYPE_MASK                         0x00000001
#define BCHP_MFD_LAC_CNTL_CHROMA_TYPE_SHIFT                        0
#define BCHP_MFD_LAC_CNTL_CHROMA_TYPE_CHROMA_420                   0
#define BCHP_MFD_LAC_CNTL_CHROMA_TYPE_CHROMA_422                   1

/***************************************************************************
 *STRIDE - MPEG/Video Feeder Stride Register
 ***************************************************************************/
/* union - case AVC_MPEG [31:00] */
/* MFD :: STRIDE :: AVC_MPEG :: CHROMA_LINE_STRIDE [31:16] */
#define BCHP_MFD_STRIDE_AVC_MPEG_CHROMA_LINE_STRIDE_MASK           0xffff0000
#define BCHP_MFD_STRIDE_AVC_MPEG_CHROMA_LINE_STRIDE_SHIFT          16

/* MFD :: STRIDE :: AVC_MPEG :: LUMA_LINE_STRIDE [15:00] */
#define BCHP_MFD_STRIDE_AVC_MPEG_LUMA_LINE_STRIDE_MASK             0x0000ffff
#define BCHP_MFD_STRIDE_AVC_MPEG_LUMA_LINE_STRIDE_SHIFT            0

/* union - case PACKED [31:00] */
/* MFD :: STRIDE :: PACKED :: reserved0 [31:16] */
#define BCHP_MFD_STRIDE_PACKED_reserved0_MASK                      0xffff0000
#define BCHP_MFD_STRIDE_PACKED_reserved0_SHIFT                     16

/* MFD :: STRIDE :: PACKED :: LINE_STRIDE [15:00] */
#define BCHP_MFD_STRIDE_PACKED_LINE_STRIDE_MASK                    0x0000ffff
#define BCHP_MFD_STRIDE_PACKED_LINE_STRIDE_SHIFT                   0

/***************************************************************************
 *DISP_HSIZE - MPEG/Video Feeder Horizontal Display Size Register
 ***************************************************************************/
/* MFD :: DISP_HSIZE :: reserved0 [31:13] */
#define BCHP_MFD_DISP_HSIZE_reserved0_MASK                         0xffffe000
#define BCHP_MFD_DISP_HSIZE_reserved0_SHIFT                        13

/* MFD :: DISP_HSIZE :: VALUE [12:00] */
#define BCHP_MFD_DISP_HSIZE_VALUE_MASK                             0x00001fff
#define BCHP_MFD_DISP_HSIZE_VALUE_SHIFT                            0

/***************************************************************************
 *PICTURE0_DISP_VERT_WINDOW - MPEG/Video Feeder Display Vertical Window Register
 ***************************************************************************/
/* MFD :: PICTURE0_DISP_VERT_WINDOW :: reserved0 [31:29] */
#define BCHP_MFD_PICTURE0_DISP_VERT_WINDOW_reserved0_MASK          0xe0000000
#define BCHP_MFD_PICTURE0_DISP_VERT_WINDOW_reserved0_SHIFT         29

/* MFD :: PICTURE0_DISP_VERT_WINDOW :: START [28:16] */
#define BCHP_MFD_PICTURE0_DISP_VERT_WINDOW_START_MASK              0x1fff0000
#define BCHP_MFD_PICTURE0_DISP_VERT_WINDOW_START_SHIFT             16

/* MFD :: PICTURE0_DISP_VERT_WINDOW :: reserved1 [15:13] */
#define BCHP_MFD_PICTURE0_DISP_VERT_WINDOW_reserved1_MASK          0x0000e000
#define BCHP_MFD_PICTURE0_DISP_VERT_WINDOW_reserved1_SHIFT         13

/* MFD :: PICTURE0_DISP_VERT_WINDOW :: END [12:00] */
#define BCHP_MFD_PICTURE0_DISP_VERT_WINDOW_END_MASK                0x00001fff
#define BCHP_MFD_PICTURE0_DISP_VERT_WINDOW_END_SHIFT               0

/***************************************************************************
 *PICTURE0_LINE_ADDR_0 - MPEG/Video Feeder Line Address0 Register
 ***************************************************************************/
/* union - case AVC_MPEG [31:00] */
/* MFD :: PICTURE0_LINE_ADDR_0 :: AVC_MPEG :: LUMA_ADDR [31:00] */
#define BCHP_MFD_PICTURE0_LINE_ADDR_0_AVC_MPEG_LUMA_ADDR_MASK      0xffffffff
#define BCHP_MFD_PICTURE0_LINE_ADDR_0_AVC_MPEG_LUMA_ADDR_SHIFT     0

/* union - case PACKED [31:00] */
/* MFD :: PICTURE0_LINE_ADDR_0 :: PACKED :: LUMA_CHROMA_ADDR [31:00] */
#define BCHP_MFD_PICTURE0_LINE_ADDR_0_PACKED_LUMA_CHROMA_ADDR_MASK 0xffffffff
#define BCHP_MFD_PICTURE0_LINE_ADDR_0_PACKED_LUMA_CHROMA_ADDR_SHIFT 0

/***************************************************************************
 *PICTURE0_LINE_ADDR_1 - MPEG/Video Feeder Line Address1 Register
 ***************************************************************************/
/* union - case AVC_MPEG [31:00] */
/* MFD :: PICTURE0_LINE_ADDR_1 :: AVC_MPEG :: CHROMA_ADDR [31:00] */
#define BCHP_MFD_PICTURE0_LINE_ADDR_1_AVC_MPEG_CHROMA_ADDR_MASK    0xffffffff
#define BCHP_MFD_PICTURE0_LINE_ADDR_1_AVC_MPEG_CHROMA_ADDR_SHIFT   0

/* union - case PACKED [31:00] */
/* MFD :: PICTURE0_LINE_ADDR_1 :: PACKED :: reserved0 [31:00] */
#define BCHP_MFD_PICTURE0_LINE_ADDR_1_PACKED_reserved0_MASK        0xffffffff
#define BCHP_MFD_PICTURE0_LINE_ADDR_1_PACKED_reserved0_SHIFT       0

/***************************************************************************
 *CHROMA_SAMPLING_CNTL - MPEG Feeder Chroma Sampling Control Register
 ***************************************************************************/
/* MFD :: CHROMA_SAMPLING_CNTL :: reserved0 [31:01] */
#define BCHP_MFD_CHROMA_SAMPLING_CNTL_reserved0_MASK               0xfffffffe
#define BCHP_MFD_CHROMA_SAMPLING_CNTL_reserved0_SHIFT              1

/* MFD :: CHROMA_SAMPLING_CNTL :: CHROMA_REPOSITION_ENABLE [00:00] */
#define BCHP_MFD_CHROMA_SAMPLING_CNTL_CHROMA_REPOSITION_ENABLE_MASK 0x00000001
#define BCHP_MFD_CHROMA_SAMPLING_CNTL_CHROMA_REPOSITION_ENABLE_SHIFT 0
#define BCHP_MFD_CHROMA_SAMPLING_CNTL_CHROMA_REPOSITION_ENABLE_OFF 0
#define BCHP_MFD_CHROMA_SAMPLING_CNTL_CHROMA_REPOSITION_ENABLE_ON  1

/***************************************************************************
 *LUMA_NMBY - MPEG Feeder Luma NMBY Size Register
 ***************************************************************************/
/* MFD :: LUMA_NMBY :: reserved0 [31:10] */
#define BCHP_MFD_LUMA_NMBY_reserved0_MASK                          0xfffffc00
#define BCHP_MFD_LUMA_NMBY_reserved0_SHIFT                         10

/* MFD :: LUMA_NMBY :: VALUE [09:00] */
#define BCHP_MFD_LUMA_NMBY_VALUE_MASK                              0x000003ff
#define BCHP_MFD_LUMA_NMBY_VALUE_SHIFT                             0

/***************************************************************************
 *CHROMA_NMBY - MPEG Feeder Chroma NMBY Size Register
 ***************************************************************************/
/* MFD :: CHROMA_NMBY :: reserved0 [31:10] */
#define BCHP_MFD_CHROMA_NMBY_reserved0_MASK                        0xfffffc00
#define BCHP_MFD_CHROMA_NMBY_reserved0_SHIFT                       10

/* MFD :: CHROMA_NMBY :: VALUE [09:00] */
#define BCHP_MFD_CHROMA_NMBY_VALUE_MASK                            0x000003ff
#define BCHP_MFD_CHROMA_NMBY_VALUE_SHIFT                           0

/***************************************************************************
 *PIC_FEED_CMD - MPEG/Video Feeder Picture Feed Command Register
 ***************************************************************************/
/* MFD :: PIC_FEED_CMD :: reserved0 [31:01] */
#define BCHP_MFD_PIC_FEED_CMD_reserved0_MASK                       0xfffffffe
#define BCHP_MFD_PIC_FEED_CMD_reserved0_SHIFT                      1

/* MFD :: PIC_FEED_CMD :: START_FEED [00:00] */
#define BCHP_MFD_PIC_FEED_CMD_START_FEED_MASK                      0x00000001
#define BCHP_MFD_PIC_FEED_CMD_START_FEED_SHIFT                     0

/***************************************************************************
 *CRC_CTRL - MPEG/Video Feeder CRC Control Register
 ***************************************************************************/
/* MFD :: CRC_CTRL :: reserved0 [31:03] */
#define BCHP_MFD_CRC_CTRL_reserved0_MASK                           0xfffffff8
#define BCHP_MFD_CRC_CTRL_reserved0_SHIFT                          3

/* MFD :: CRC_CTRL :: ENABLE [02:02] */
#define BCHP_MFD_CRC_CTRL_ENABLE_MASK                              0x00000004
#define BCHP_MFD_CRC_CTRL_ENABLE_SHIFT                             2
#define BCHP_MFD_CRC_CTRL_ENABLE_OFF                               0
#define BCHP_MFD_CRC_CTRL_ENABLE_ON                                1

/* MFD :: CRC_CTRL :: MODE [01:01] */
#define BCHP_MFD_CRC_CTRL_MODE_MASK                                0x00000002
#define BCHP_MFD_CRC_CTRL_MODE_SHIFT                               1
#define BCHP_MFD_CRC_CTRL_MODE_DISPLAY                             0
#define BCHP_MFD_CRC_CTRL_MODE_DEBUG                               1

/* MFD :: CRC_CTRL :: LOAD_CRC_SEED [00:00] */
#define BCHP_MFD_CRC_CTRL_LOAD_CRC_SEED_MASK                       0x00000001
#define BCHP_MFD_CRC_CTRL_LOAD_CRC_SEED_SHIFT                      0
#define BCHP_MFD_CRC_CTRL_LOAD_CRC_SEED_AT_SOF                     0
#define BCHP_MFD_CRC_CTRL_LOAD_CRC_SEED_ONCE                       1

/***************************************************************************
 *CRC_SEED - MPEG/Video Feeder CRC Seed Register
 ***************************************************************************/
/* MFD :: CRC_SEED :: VALUE [31:00] */
#define BCHP_MFD_CRC_SEED_VALUE_MASK                               0xffffffff
#define BCHP_MFD_CRC_SEED_VALUE_SHIFT                              0

/***************************************************************************
 *LUMA_CRC - MPEG/Video Feeder Luma CRC Register
 ***************************************************************************/
/* MFD :: LUMA_CRC :: VALUE [31:00] */
#define BCHP_MFD_LUMA_CRC_VALUE_MASK                               0xffffffff
#define BCHP_MFD_LUMA_CRC_VALUE_SHIFT                              0

/***************************************************************************
 *CHROMA_CRC - MPEG/Video Feeder Chroma CRC Register
 ***************************************************************************/
/* MFD :: CHROMA_CRC :: VALUE [31:00] */
#define BCHP_MFD_CHROMA_CRC_VALUE_MASK                             0xffffffff
#define BCHP_MFD_CHROMA_CRC_VALUE_SHIFT                            0

/***************************************************************************
 *DATA_MODE - MPEG/Video Feeder Data Mode Register
 ***************************************************************************/
/* MFD :: DATA_MODE :: reserved0 [31:01] */
#define BCHP_MFD_DATA_MODE_reserved0_MASK                          0xfffffffe
#define BCHP_MFD_DATA_MODE_reserved0_SHIFT                         1

/* MFD :: DATA_MODE :: PIXEL_WIDTH [00:00] */
#define BCHP_MFD_DATA_MODE_PIXEL_WIDTH_MASK                        0x00000001
#define BCHP_MFD_DATA_MODE_PIXEL_WIDTH_SHIFT                       0
#define BCHP_MFD_DATA_MODE_PIXEL_WIDTH_MODE_8_BIT                  0
#define BCHP_MFD_DATA_MODE_PIXEL_WIDTH_MODE_10_BIT                 1

/***************************************************************************
 *PIC_OFFSET - MPEG/Video Feeder Picture Offset Register
 ***************************************************************************/
/* MFD :: PIC_OFFSET :: reserved0 [31:03] */
#define BCHP_MFD_PIC_OFFSET_reserved0_MASK                         0xfffffff8
#define BCHP_MFD_PIC_OFFSET_reserved0_SHIFT                        3

/* MFD :: PIC_OFFSET :: H_OFFSET [02:00] */
#define BCHP_MFD_PIC_OFFSET_H_OFFSET_MASK                          0x00000007
#define BCHP_MFD_PIC_OFFSET_H_OFFSET_SHIFT                         0

/***************************************************************************
 *RANGE_EXP_REMAP_CNTL - MPEG/Video Feeder Range Expansion / Remapping Control Register
 ***************************************************************************/
/* MFD :: RANGE_EXP_REMAP_CNTL :: reserved0 [31:10] */
#define BCHP_MFD_RANGE_EXP_REMAP_CNTL_reserved0_MASK               0xfffffc00
#define BCHP_MFD_RANGE_EXP_REMAP_CNTL_reserved0_SHIFT              10

/* MFD :: RANGE_EXP_REMAP_CNTL :: SCALE_C [09:05] */
#define BCHP_MFD_RANGE_EXP_REMAP_CNTL_SCALE_C_MASK                 0x000003e0
#define BCHP_MFD_RANGE_EXP_REMAP_CNTL_SCALE_C_SHIFT                5

/* MFD :: RANGE_EXP_REMAP_CNTL :: SCALE_Y [04:00] */
#define BCHP_MFD_RANGE_EXP_REMAP_CNTL_SCALE_Y_MASK                 0x0000001f
#define BCHP_MFD_RANGE_EXP_REMAP_CNTL_SCALE_Y_SHIFT                0

/***************************************************************************
 *FEED_STATUS - MPEG/Video Feeder Feed Status Register
 ***************************************************************************/
/* MFD :: FEED_STATUS :: reserved0 [31:30] */
#define BCHP_MFD_FEED_STATUS_reserved0_MASK                        0xc0000000
#define BCHP_MFD_FEED_STATUS_reserved0_SHIFT                       30

/* MFD :: FEED_STATUS :: LAST_LINE [29:29] */
#define BCHP_MFD_FEED_STATUS_LAST_LINE_MASK                        0x20000000
#define BCHP_MFD_FEED_STATUS_LAST_LINE_SHIFT                       29

/* MFD :: FEED_STATUS :: reserved1 [28:13] */
#define BCHP_MFD_FEED_STATUS_reserved1_MASK                        0x1fffe000
#define BCHP_MFD_FEED_STATUS_reserved1_SHIFT                       13

/* MFD :: FEED_STATUS :: LINE_COUNT [12:00] */
#define BCHP_MFD_FEED_STATUS_LINE_COUNT_MASK                       0x00001fff
#define BCHP_MFD_FEED_STATUS_LINE_COUNT_SHIFT                      0

/***************************************************************************
 *PICTURE0_LAC_LINE_ADDR_0 - MPEG/Video Feeder Line Address Computer Line Address0 Register
 ***************************************************************************/
/* union - case AVC_MPEG [31:00] */
/* MFD :: PICTURE0_LAC_LINE_ADDR_0 :: AVC_MPEG :: LUMA_ADDR [31:00] */
#define BCHP_MFD_PICTURE0_LAC_LINE_ADDR_0_AVC_MPEG_LUMA_ADDR_MASK  0xffffffff
#define BCHP_MFD_PICTURE0_LAC_LINE_ADDR_0_AVC_MPEG_LUMA_ADDR_SHIFT 0

/* union - case PACKED [31:00] */
/* MFD :: PICTURE0_LAC_LINE_ADDR_0 :: PACKED :: LUMA_CHROMA_ADDR [31:00] */
#define BCHP_MFD_PICTURE0_LAC_LINE_ADDR_0_PACKED_LUMA_CHROMA_ADDR_MASK 0xffffffff
#define BCHP_MFD_PICTURE0_LAC_LINE_ADDR_0_PACKED_LUMA_CHROMA_ADDR_SHIFT 0

/***************************************************************************
 *PICTURE0_LAC_LINE_ADDR_1 - MPEG/Video Feeder Line Address Computer Line Address1 Register
 ***************************************************************************/
/* union - case AVC_MPEG [31:00] */
/* MFD :: PICTURE0_LAC_LINE_ADDR_1 :: AVC_MPEG :: CHROMA_ADDR [31:00] */
#define BCHP_MFD_PICTURE0_LAC_LINE_ADDR_1_AVC_MPEG_CHROMA_ADDR_MASK 0xffffffff
#define BCHP_MFD_PICTURE0_LAC_LINE_ADDR_1_AVC_MPEG_CHROMA_ADDR_SHIFT 0

/* union - case PACKED [31:00] */
/* MFD :: PICTURE0_LAC_LINE_ADDR_1 :: PACKED :: reserved0 [31:00] */
#define BCHP_MFD_PICTURE0_LAC_LINE_ADDR_1_PACKED_reserved0_MASK    0xffffffff
#define BCHP_MFD_PICTURE0_LAC_LINE_ADDR_1_PACKED_reserved0_SHIFT   0

/***************************************************************************
 *PICTURE0_LAC_CHROMA_VERT_FILTER_CONFIG - MPEG/Video Feeder Line Address Computer Chroma Vertical Filter Configuration Register
 ***************************************************************************/
/* MFD :: PICTURE0_LAC_CHROMA_VERT_FILTER_CONFIG :: reserved0 [31:20] */
#define BCHP_MFD_PICTURE0_LAC_CHROMA_VERT_FILTER_CONFIG_reserved0_MASK 0xfff00000
#define BCHP_MFD_PICTURE0_LAC_CHROMA_VERT_FILTER_CONFIG_reserved0_SHIFT 20

/* MFD :: PICTURE0_LAC_CHROMA_VERT_FILTER_CONFIG :: CLB_RD_ADDR_UPDATE_1 [19:19] */
#define BCHP_MFD_PICTURE0_LAC_CHROMA_VERT_FILTER_CONFIG_CLB_RD_ADDR_UPDATE_1_MASK 0x00080000
#define BCHP_MFD_PICTURE0_LAC_CHROMA_VERT_FILTER_CONFIG_CLB_RD_ADDR_UPDATE_1_SHIFT 19
#define BCHP_MFD_PICTURE0_LAC_CHROMA_VERT_FILTER_CONFIG_CLB_RD_ADDR_UPDATE_1_OFF 0
#define BCHP_MFD_PICTURE0_LAC_CHROMA_VERT_FILTER_CONFIG_CLB_RD_ADDR_UPDATE_1_ON 1

/* MFD :: PICTURE0_LAC_CHROMA_VERT_FILTER_CONFIG :: CLB_RD_ADDR_UPDATE_0 [18:18] */
#define BCHP_MFD_PICTURE0_LAC_CHROMA_VERT_FILTER_CONFIG_CLB_RD_ADDR_UPDATE_0_MASK 0x00040000
#define BCHP_MFD_PICTURE0_LAC_CHROMA_VERT_FILTER_CONFIG_CLB_RD_ADDR_UPDATE_0_SHIFT 18
#define BCHP_MFD_PICTURE0_LAC_CHROMA_VERT_FILTER_CONFIG_CLB_RD_ADDR_UPDATE_0_OFF 0
#define BCHP_MFD_PICTURE0_LAC_CHROMA_VERT_FILTER_CONFIG_CLB_RD_ADDR_UPDATE_0_ON 1

/* MFD :: PICTURE0_LAC_CHROMA_VERT_FILTER_CONFIG :: CLB_WREN_1 [17:17] */
#define BCHP_MFD_PICTURE0_LAC_CHROMA_VERT_FILTER_CONFIG_CLB_WREN_1_MASK 0x00020000
#define BCHP_MFD_PICTURE0_LAC_CHROMA_VERT_FILTER_CONFIG_CLB_WREN_1_SHIFT 17
#define BCHP_MFD_PICTURE0_LAC_CHROMA_VERT_FILTER_CONFIG_CLB_WREN_1_ENABLE 0
#define BCHP_MFD_PICTURE0_LAC_CHROMA_VERT_FILTER_CONFIG_CLB_WREN_1_DISABLE 1

/* MFD :: PICTURE0_LAC_CHROMA_VERT_FILTER_CONFIG :: CLB_WREN_0 [16:16] */
#define BCHP_MFD_PICTURE0_LAC_CHROMA_VERT_FILTER_CONFIG_CLB_WREN_0_MASK 0x00010000
#define BCHP_MFD_PICTURE0_LAC_CHROMA_VERT_FILTER_CONFIG_CLB_WREN_0_SHIFT 16
#define BCHP_MFD_PICTURE0_LAC_CHROMA_VERT_FILTER_CONFIG_CLB_WREN_0_ENABLE 0
#define BCHP_MFD_PICTURE0_LAC_CHROMA_VERT_FILTER_CONFIG_CLB_WREN_0_DISABLE 1

/* MFD :: PICTURE0_LAC_CHROMA_VERT_FILTER_CONFIG :: CR_COEFF_TOP [15:12] */
#define BCHP_MFD_PICTURE0_LAC_CHROMA_VERT_FILTER_CONFIG_CR_COEFF_TOP_MASK 0x0000f000
#define BCHP_MFD_PICTURE0_LAC_CHROMA_VERT_FILTER_CONFIG_CR_COEFF_TOP_SHIFT 12

/* MFD :: PICTURE0_LAC_CHROMA_VERT_FILTER_CONFIG :: CR_COEFF_BOT [11:08] */
#define BCHP_MFD_PICTURE0_LAC_CHROMA_VERT_FILTER_CONFIG_CR_COEFF_BOT_MASK 0x00000f00
#define BCHP_MFD_PICTURE0_LAC_CHROMA_VERT_FILTER_CONFIG_CR_COEFF_BOT_SHIFT 8

/* MFD :: PICTURE0_LAC_CHROMA_VERT_FILTER_CONFIG :: CB_COEFF_TOP [07:04] */
#define BCHP_MFD_PICTURE0_LAC_CHROMA_VERT_FILTER_CONFIG_CB_COEFF_TOP_MASK 0x000000f0
#define BCHP_MFD_PICTURE0_LAC_CHROMA_VERT_FILTER_CONFIG_CB_COEFF_TOP_SHIFT 4

/* MFD :: PICTURE0_LAC_CHROMA_VERT_FILTER_CONFIG :: CB_COEFF_BOT [03:00] */
#define BCHP_MFD_PICTURE0_LAC_CHROMA_VERT_FILTER_CONFIG_CB_COEFF_BOT_MASK 0x0000000f
#define BCHP_MFD_PICTURE0_LAC_CHROMA_VERT_FILTER_CONFIG_CB_COEFF_BOT_SHIFT 0

/***************************************************************************
 *LAC_LINE_FEED_CNTL - MPEG/Video Feeder Line Address Computer Line Feed Control Register
 ***************************************************************************/
/* MFD :: LAC_LINE_FEED_CNTL :: reserved0 [31:02] */
#define BCHP_MFD_LAC_LINE_FEED_CNTL_reserved0_MASK                 0xfffffffc
#define BCHP_MFD_LAC_LINE_FEED_CNTL_reserved0_SHIFT                2

/* MFD :: LAC_LINE_FEED_CNTL :: FIRST_LINE [01:01] */
#define BCHP_MFD_LAC_LINE_FEED_CNTL_FIRST_LINE_MASK                0x00000002
#define BCHP_MFD_LAC_LINE_FEED_CNTL_FIRST_LINE_SHIFT               1

/* MFD :: LAC_LINE_FEED_CNTL :: START_LINE_FEED [00:00] */
#define BCHP_MFD_LAC_LINE_FEED_CNTL_START_LINE_FEED_MASK           0x00000001
#define BCHP_MFD_LAC_LINE_FEED_CNTL_START_LINE_FEED_SHIFT          0
#define BCHP_MFD_LAC_LINE_FEED_CNTL_START_LINE_FEED_PENDING        0
#define BCHP_MFD_LAC_LINE_FEED_CNTL_START_LINE_FEED_COMPLETE       1

/***************************************************************************
 *FEEDER_TIMEOUT_REPEAT_PIC_CNTL - MPEG/Video Feeder Timeout and Repeat Picture Control Register
 ***************************************************************************/
/* MFD :: FEEDER_TIMEOUT_REPEAT_PIC_CNTL :: reserved0 [31:26] */
#define BCHP_MFD_FEEDER_TIMEOUT_REPEAT_PIC_CNTL_reserved0_MASK     0xfc000000
#define BCHP_MFD_FEEDER_TIMEOUT_REPEAT_PIC_CNTL_reserved0_SHIFT    26

/* MFD :: FEEDER_TIMEOUT_REPEAT_PIC_CNTL :: FEEDER_TIMEOUT_ENABLE [25:25] */
#define BCHP_MFD_FEEDER_TIMEOUT_REPEAT_PIC_CNTL_FEEDER_TIMEOUT_ENABLE_MASK 0x02000000
#define BCHP_MFD_FEEDER_TIMEOUT_REPEAT_PIC_CNTL_FEEDER_TIMEOUT_ENABLE_SHIFT 25
#define BCHP_MFD_FEEDER_TIMEOUT_REPEAT_PIC_CNTL_FEEDER_TIMEOUT_ENABLE_OFF 0
#define BCHP_MFD_FEEDER_TIMEOUT_REPEAT_PIC_CNTL_FEEDER_TIMEOUT_ENABLE_ON 1

/* MFD :: FEEDER_TIMEOUT_REPEAT_PIC_CNTL :: REPEAT_PIC_ENABLE [24:24] */
#define BCHP_MFD_FEEDER_TIMEOUT_REPEAT_PIC_CNTL_REPEAT_PIC_ENABLE_MASK 0x01000000
#define BCHP_MFD_FEEDER_TIMEOUT_REPEAT_PIC_CNTL_REPEAT_PIC_ENABLE_SHIFT 24
#define BCHP_MFD_FEEDER_TIMEOUT_REPEAT_PIC_CNTL_REPEAT_PIC_ENABLE_OFF 0
#define BCHP_MFD_FEEDER_TIMEOUT_REPEAT_PIC_CNTL_REPEAT_PIC_ENABLE_ON 1

/* MFD :: FEEDER_TIMEOUT_REPEAT_PIC_CNTL :: TIMEOUT_COUNT [23:00] */
#define BCHP_MFD_FEEDER_TIMEOUT_REPEAT_PIC_CNTL_TIMEOUT_COUNT_MASK 0x00ffffff
#define BCHP_MFD_FEEDER_TIMEOUT_REPEAT_PIC_CNTL_TIMEOUT_COUNT_SHIFT 0

/***************************************************************************
 *BVB_RX_STALL_TIMEOUT_CNTL - MPEG/Video Feeder BVB Receiver Stall Timeout Control Register
 ***************************************************************************/
/* MFD :: BVB_RX_STALL_TIMEOUT_CNTL :: reserved0 [31:25] */
#define BCHP_MFD_BVB_RX_STALL_TIMEOUT_CNTL_reserved0_MASK          0xfe000000
#define BCHP_MFD_BVB_RX_STALL_TIMEOUT_CNTL_reserved0_SHIFT         25

/* MFD :: BVB_RX_STALL_TIMEOUT_CNTL :: RX_STALL_TIMEOUT_ENABLE [24:24] */
#define BCHP_MFD_BVB_RX_STALL_TIMEOUT_CNTL_RX_STALL_TIMEOUT_ENABLE_MASK 0x01000000
#define BCHP_MFD_BVB_RX_STALL_TIMEOUT_CNTL_RX_STALL_TIMEOUT_ENABLE_SHIFT 24
#define BCHP_MFD_BVB_RX_STALL_TIMEOUT_CNTL_RX_STALL_TIMEOUT_ENABLE_OFF 0
#define BCHP_MFD_BVB_RX_STALL_TIMEOUT_CNTL_RX_STALL_TIMEOUT_ENABLE_ON 1

/* MFD :: BVB_RX_STALL_TIMEOUT_CNTL :: TIMEOUT_COUNT [23:00] */
#define BCHP_MFD_BVB_RX_STALL_TIMEOUT_CNTL_TIMEOUT_COUNT_MASK      0x00ffffff
#define BCHP_MFD_BVB_RX_STALL_TIMEOUT_CNTL_TIMEOUT_COUNT_SHIFT     0

/***************************************************************************
 *FEEDER_ERROR_INTERRUPT_STATUS - MPEG/Video Feeder Error Interrupt Status Register
 ***************************************************************************/
/* MFD :: FEEDER_ERROR_INTERRUPT_STATUS :: reserved0 [31:03] */
#define BCHP_MFD_FEEDER_ERROR_INTERRUPT_STATUS_reserved0_MASK      0xfffffff8
#define BCHP_MFD_FEEDER_ERROR_INTERRUPT_STATUS_reserved0_SHIFT     3

/* MFD :: FEEDER_ERROR_INTERRUPT_STATUS :: PIC_FEED_CMD_OVER_WR [02:02] */
#define BCHP_MFD_FEEDER_ERROR_INTERRUPT_STATUS_PIC_FEED_CMD_OVER_WR_MASK 0x00000004
#define BCHP_MFD_FEEDER_ERROR_INTERRUPT_STATUS_PIC_FEED_CMD_OVER_WR_SHIFT 2

/* MFD :: FEEDER_ERROR_INTERRUPT_STATUS :: RX_STALL_TIMEOUT [01:01] */
#define BCHP_MFD_FEEDER_ERROR_INTERRUPT_STATUS_RX_STALL_TIMEOUT_MASK 0x00000002
#define BCHP_MFD_FEEDER_ERROR_INTERRUPT_STATUS_RX_STALL_TIMEOUT_SHIFT 1

/* MFD :: FEEDER_ERROR_INTERRUPT_STATUS :: FEEDER_TIMEOUT [00:00] */
#define BCHP_MFD_FEEDER_ERROR_INTERRUPT_STATUS_FEEDER_TIMEOUT_MASK 0x00000001
#define BCHP_MFD_FEEDER_ERROR_INTERRUPT_STATUS_FEEDER_TIMEOUT_SHIFT 0

/***************************************************************************
 *FEEDER_BVB_STATUS - MPEG/Video Feeder BVB Status Register
 ***************************************************************************/
/* MFD :: FEEDER_BVB_STATUS :: reserved0 [31:02] */
#define BCHP_MFD_FEEDER_BVB_STATUS_reserved0_MASK                  0xfffffffc
#define BCHP_MFD_FEEDER_BVB_STATUS_reserved0_SHIFT                 2

/* MFD :: FEEDER_BVB_STATUS :: EOF [01:01] */
#define BCHP_MFD_FEEDER_BVB_STATUS_EOF_MASK                        0x00000002
#define BCHP_MFD_FEEDER_BVB_STATUS_EOF_SHIFT                       1

/* MFD :: FEEDER_BVB_STATUS :: EOL [00:00] */
#define BCHP_MFD_FEEDER_BVB_STATUS_EOL_MASK                        0x00000001
#define BCHP_MFD_FEEDER_BVB_STATUS_EOL_SHIFT                       0

/***************************************************************************
 *TEST_MODE_CNTL - MPEG/Video Feeder Test Mode Control Register
 ***************************************************************************/
/* MFD :: TEST_MODE_CNTL :: reserved0 [31:04] */
#define BCHP_MFD_TEST_MODE_CNTL_reserved0_MASK                     0xfffffff0
#define BCHP_MFD_TEST_MODE_CNTL_reserved0_SHIFT                    4

/* MFD :: TEST_MODE_CNTL :: BVB_TEST_MODE [03:03] */
#define BCHP_MFD_TEST_MODE_CNTL_BVB_TEST_MODE_MASK                 0x00000008
#define BCHP_MFD_TEST_MODE_CNTL_BVB_TEST_MODE_SHIFT                3

/* MFD :: TEST_MODE_CNTL :: PIXEL_SATURATION_ENABLE [02:02] */
#define BCHP_MFD_TEST_MODE_CNTL_PIXEL_SATURATION_ENABLE_MASK       0x00000004
#define BCHP_MFD_TEST_MODE_CNTL_PIXEL_SATURATION_ENABLE_SHIFT      2
#define BCHP_MFD_TEST_MODE_CNTL_PIXEL_SATURATION_ENABLE_OFF        0
#define BCHP_MFD_TEST_MODE_CNTL_PIXEL_SATURATION_ENABLE_ON         1

/* MFD :: TEST_MODE_CNTL :: ACCEPT_STATE [01:01] */
#define BCHP_MFD_TEST_MODE_CNTL_ACCEPT_STATE_MASK                  0x00000002
#define BCHP_MFD_TEST_MODE_CNTL_ACCEPT_STATE_SHIFT                 1

/* MFD :: TEST_MODE_CNTL :: ACCEPT_PULSE [00:00] */
#define BCHP_MFD_TEST_MODE_CNTL_ACCEPT_PULSE_MASK                  0x00000001
#define BCHP_MFD_TEST_MODE_CNTL_ACCEPT_PULSE_SHIFT                 0

/***************************************************************************
 *BVB_SAMPLE_DATA - MPEG/Video Feeder BVB Output Sample Data Register
 ***************************************************************************/
/* MFD :: BVB_SAMPLE_DATA :: reserved0 [31:26] */
#define BCHP_MFD_BVB_SAMPLE_DATA_reserved0_MASK                    0xfc000000
#define BCHP_MFD_BVB_SAMPLE_DATA_reserved0_SHIFT                   26

/* MFD :: BVB_SAMPLE_DATA :: PICTURE_SYNC [25:24] */
#define BCHP_MFD_BVB_SAMPLE_DATA_PICTURE_SYNC_MASK                 0x03000000
#define BCHP_MFD_BVB_SAMPLE_DATA_PICTURE_SYNC_SHIFT                24
#define BCHP_MFD_BVB_SAMPLE_DATA_PICTURE_SYNC_NORMAL_PIXEL         0
#define BCHP_MFD_BVB_SAMPLE_DATA_PICTURE_SYNC_FIRST_PIXEL          1
#define BCHP_MFD_BVB_SAMPLE_DATA_PICTURE_SYNC_LAST_PIXEL           2

/* MFD :: BVB_SAMPLE_DATA :: LINE_SYNC [23:22] */
#define BCHP_MFD_BVB_SAMPLE_DATA_LINE_SYNC_MASK                    0x00c00000
#define BCHP_MFD_BVB_SAMPLE_DATA_LINE_SYNC_SHIFT                   22
#define BCHP_MFD_BVB_SAMPLE_DATA_LINE_SYNC_NORMAL_PIXEL            0
#define BCHP_MFD_BVB_SAMPLE_DATA_LINE_SYNC_FIRST_PIXEL             1
#define BCHP_MFD_BVB_SAMPLE_DATA_LINE_SYNC_LAST_PIXEL              2

/* MFD :: BVB_SAMPLE_DATA :: COLOUR_SYNC [21:20] */
#define BCHP_MFD_BVB_SAMPLE_DATA_COLOUR_SYNC_MASK                  0x00300000
#define BCHP_MFD_BVB_SAMPLE_DATA_COLOUR_SYNC_SHIFT                 20
#define BCHP_MFD_BVB_SAMPLE_DATA_COLOUR_SYNC_FIRST_BEAT            0
#define BCHP_MFD_BVB_SAMPLE_DATA_COLOUR_SYNC_SECOND_BEAT           1
#define BCHP_MFD_BVB_SAMPLE_DATA_COLOUR_SYNC_THIRD_BEAT            2
#define BCHP_MFD_BVB_SAMPLE_DATA_COLOUR_SYNC_FOURTH_BEAT           3

/* MFD :: BVB_SAMPLE_DATA :: LUMA [19:10] */
#define BCHP_MFD_BVB_SAMPLE_DATA_LUMA_MASK                         0x000ffc00
#define BCHP_MFD_BVB_SAMPLE_DATA_LUMA_SHIFT                        10

/* MFD :: BVB_SAMPLE_DATA :: CHROMA [09:00] */
#define BCHP_MFD_BVB_SAMPLE_DATA_CHROMA_MASK                       0x000003ff
#define BCHP_MFD_BVB_SAMPLE_DATA_CHROMA_SHIFT                      0

/***************************************************************************
 *TEST_PORT_CNTL - MPEG/Video Feeder Test port Control Register
 ***************************************************************************/
/* MFD :: TEST_PORT_CNTL :: reserved0 [31:04] */
#define BCHP_MFD_TEST_PORT_CNTL_reserved0_MASK                     0xfffffff0
#define BCHP_MFD_TEST_PORT_CNTL_reserved0_SHIFT                    4

/* MFD :: TEST_PORT_CNTL :: ADDR_SEL [03:03] */
#define BCHP_MFD_TEST_PORT_CNTL_ADDR_SEL_MASK                      0x00000008
#define BCHP_MFD_TEST_PORT_CNTL_ADDR_SEL_SHIFT                     3
#define BCHP_MFD_TEST_PORT_CNTL_ADDR_SEL_PIN_INPUT                 0
#define BCHP_MFD_TEST_PORT_CNTL_ADDR_SEL_SOFT_INPUT                1

/* MFD :: TEST_PORT_CNTL :: TP_ADDR [02:00] */
#define BCHP_MFD_TEST_PORT_CNTL_TP_ADDR_MASK                       0x00000007
#define BCHP_MFD_TEST_PORT_CNTL_TP_ADDR_SHIFT                      0
#define BCHP_MFD_TEST_PORT_CNTL_TP_ADDR_HAC_0                      0
#define BCHP_MFD_TEST_PORT_CNTL_TP_ADDR_HAC_1                      1
#define BCHP_MFD_TEST_PORT_CNTL_TP_ADDR_LAC_HAC_2                  2
#define BCHP_MFD_TEST_PORT_CNTL_TP_ADDR_PX_RD_SM                   3
#define BCHP_MFD_TEST_PORT_CNTL_TP_ADDR_PX_RD_BVB                  4
#define BCHP_MFD_TEST_PORT_CNTL_TP_ADDR_CLB_0                      5
#define BCHP_MFD_TEST_PORT_CNTL_TP_ADDR_CLB_1                      6
#define BCHP_MFD_TEST_PORT_CNTL_TP_ADDR_BVB_OUT                    7

/***************************************************************************
 *TEST_PORT_DATA - MPEG/Video Feeder Test port Data Register
 ***************************************************************************/
/* union - case HAC_0 [31:00] */
/* MFD :: TEST_PORT_DATA :: HAC_0 :: HAC_LUMA_ADDR [31:00] */
#define BCHP_MFD_TEST_PORT_DATA_HAC_0_HAC_LUMA_ADDR_MASK           0xffffffff
#define BCHP_MFD_TEST_PORT_DATA_HAC_0_HAC_LUMA_ADDR_SHIFT          0

/* union - case HAC_1 [31:00] */
/* MFD :: TEST_PORT_DATA :: HAC_1 :: HAC_CHROMA_ADDR [31:00] */
#define BCHP_MFD_TEST_PORT_DATA_HAC_1_HAC_CHROMA_ADDR_MASK         0xffffffff
#define BCHP_MFD_TEST_PORT_DATA_HAC_1_HAC_CHROMA_ADDR_SHIFT        0

/* union - case LAC_HAC_2 [31:00] */
/* MFD :: TEST_PORT_DATA :: LAC_HAC_2 :: reserved0 [31:30] */
#define BCHP_MFD_TEST_PORT_DATA_LAC_HAC_2_reserved0_MASK           0xc0000000
#define BCHP_MFD_TEST_PORT_DATA_LAC_HAC_2_reserved0_SHIFT          30

/* MFD :: TEST_PORT_DATA :: LAC_HAC_2 :: FIRST_LINE_TRIG [29:29] */
#define BCHP_MFD_TEST_PORT_DATA_LAC_HAC_2_FIRST_LINE_TRIG_MASK     0x20000000
#define BCHP_MFD_TEST_PORT_DATA_LAC_HAC_2_FIRST_LINE_TRIG_SHIFT    29

/* MFD :: TEST_PORT_DATA :: LAC_HAC_2 :: LAC_SOL [28:28] */
#define BCHP_MFD_TEST_PORT_DATA_LAC_HAC_2_LAC_SOL_MASK             0x10000000
#define BCHP_MFD_TEST_PORT_DATA_LAC_HAC_2_LAC_SOL_SHIFT            28

/* MFD :: TEST_PORT_DATA :: LAC_HAC_2 :: LAC_BUSY [27:27] */
#define BCHP_MFD_TEST_PORT_DATA_LAC_HAC_2_LAC_BUSY_MASK            0x08000000
#define BCHP_MFD_TEST_PORT_DATA_LAC_HAC_2_LAC_BUSY_SHIFT           27

/* MFD :: TEST_PORT_DATA :: LAC_HAC_2 :: reserved1 [26:26] */
#define BCHP_MFD_TEST_PORT_DATA_LAC_HAC_2_reserved1_MASK           0x04000000
#define BCHP_MFD_TEST_PORT_DATA_LAC_HAC_2_reserved1_SHIFT          26

/* MFD :: TEST_PORT_DATA :: LAC_HAC_2 :: LINE_ADDR_SEL [25:25] */
#define BCHP_MFD_TEST_PORT_DATA_LAC_HAC_2_LINE_ADDR_SEL_MASK       0x02000000
#define BCHP_MFD_TEST_PORT_DATA_LAC_HAC_2_LINE_ADDR_SEL_SHIFT      25

/* MFD :: TEST_PORT_DATA :: LAC_HAC_2 :: LINE_ADDR_INCR [24:23] */
#define BCHP_MFD_TEST_PORT_DATA_LAC_HAC_2_LINE_ADDR_INCR_MASK      0x01800000
#define BCHP_MFD_TEST_PORT_DATA_LAC_HAC_2_LINE_ADDR_INCR_SHIFT     23
#define BCHP_MFD_TEST_PORT_DATA_LAC_HAC_2_LINE_ADDR_INCR_NO_UPDATE 0
#define BCHP_MFD_TEST_PORT_DATA_LAC_HAC_2_LINE_ADDR_INCR_PACKED_LINE_STRIDE 1
#define BCHP_MFD_TEST_PORT_DATA_LAC_HAC_2_LINE_ADDR_INCR_AVC_MPEG_LUMA_LINE_STRIDE 2
#define BCHP_MFD_TEST_PORT_DATA_LAC_HAC_2_LINE_ADDR_INCR_AVC_MPEG_CHROMA_LINE_STRIDE 3

/* MFD :: TEST_PORT_DATA :: LAC_HAC_2 :: CSM_TRIG [22:22] */
#define BCHP_MFD_TEST_PORT_DATA_LAC_HAC_2_CSM_TRIG_MASK            0x00400000
#define BCHP_MFD_TEST_PORT_DATA_LAC_HAC_2_CSM_TRIG_SHIFT           22

/* MFD :: TEST_PORT_DATA :: LAC_HAC_2 :: LUMA_LINE_PHASE [21:21] */
#define BCHP_MFD_TEST_PORT_DATA_LAC_HAC_2_LUMA_LINE_PHASE_MASK     0x00200000
#define BCHP_MFD_TEST_PORT_DATA_LAC_HAC_2_LUMA_LINE_PHASE_SHIFT    21
#define BCHP_MFD_TEST_PORT_DATA_LAC_HAC_2_LUMA_LINE_PHASE_EVEN     0
#define BCHP_MFD_TEST_PORT_DATA_LAC_HAC_2_LUMA_LINE_PHASE_ODD      1

/* MFD :: TEST_PORT_DATA :: LAC_HAC_2 :: BUF_AVIAL [20:20] */
#define BCHP_MFD_TEST_PORT_DATA_LAC_HAC_2_BUF_AVIAL_MASK           0x00100000
#define BCHP_MFD_TEST_PORT_DATA_LAC_HAC_2_BUF_AVIAL_SHIFT          20

/* MFD :: TEST_PORT_DATA :: LAC_HAC_2 :: CURRENT_BUF [19:19] */
#define BCHP_MFD_TEST_PORT_DATA_LAC_HAC_2_CURRENT_BUF_MASK         0x00080000
#define BCHP_MFD_TEST_PORT_DATA_LAC_HAC_2_CURRENT_BUF_SHIFT        19

/* MFD :: TEST_PORT_DATA :: LAC_HAC_2 :: DBUF_DEPTH [18:17] */
#define BCHP_MFD_TEST_PORT_DATA_LAC_HAC_2_DBUF_DEPTH_MASK          0x00060000
#define BCHP_MFD_TEST_PORT_DATA_LAC_HAC_2_DBUF_DEPTH_SHIFT         17
#define BCHP_MFD_TEST_PORT_DATA_LAC_HAC_2_DBUF_DEPTH_EMPTY         0
#define BCHP_MFD_TEST_PORT_DATA_LAC_HAC_2_DBUF_DEPTH_HALF_FULL     1
#define BCHP_MFD_TEST_PORT_DATA_LAC_HAC_2_DBUF_DEPTH_FULL          2

/* MFD :: TEST_PORT_DATA :: LAC_HAC_2 :: WSM_TRIG [16:16] */
#define BCHP_MFD_TEST_PORT_DATA_LAC_HAC_2_WSM_TRIG_MASK            0x00010000
#define BCHP_MFD_TEST_PORT_DATA_LAC_HAC_2_WSM_TRIG_SHIFT           16

/* MFD :: TEST_PORT_DATA :: LAC_HAC_2 :: WSM_WR_DONE [15:15] */
#define BCHP_MFD_TEST_PORT_DATA_LAC_HAC_2_WSM_WR_DONE_MASK         0x00008000
#define BCHP_MFD_TEST_PORT_DATA_LAC_HAC_2_WSM_WR_DONE_SHIFT        15

/* MFD :: TEST_PORT_DATA :: LAC_HAC_2 :: WSM_CUR_STATE [14:13] */
#define BCHP_MFD_TEST_PORT_DATA_LAC_HAC_2_WSM_CUR_STATE_MASK       0x00006000
#define BCHP_MFD_TEST_PORT_DATA_LAC_HAC_2_WSM_CUR_STATE_SHIFT      13
#define BCHP_MFD_TEST_PORT_DATA_LAC_HAC_2_WSM_CUR_STATE_IDLE       0
#define BCHP_MFD_TEST_PORT_DATA_LAC_HAC_2_WSM_CUR_STATE_DBUF_WRITE 1
#define BCHP_MFD_TEST_PORT_DATA_LAC_HAC_2_WSM_CUR_STATE_BUF_AVAIL  2

/* MFD :: TEST_PORT_DATA :: LAC_HAC_2 :: LUMA_HORZ_CURSOR [12:00] */
#define BCHP_MFD_TEST_PORT_DATA_LAC_HAC_2_LUMA_HORZ_CURSOR_MASK    0x00001fff
#define BCHP_MFD_TEST_PORT_DATA_LAC_HAC_2_LUMA_HORZ_CURSOR_SHIFT   0

/* union - case PX_RD_SM [31:00] */
/* MFD :: TEST_PORT_DATA :: PX_RD_SM :: reserved0 [31:30] */
#define BCHP_MFD_TEST_PORT_DATA_PX_RD_SM_reserved0_MASK            0xc0000000
#define BCHP_MFD_TEST_PORT_DATA_PX_RD_SM_reserved0_SHIFT           30

/* MFD :: TEST_PORT_DATA :: PX_RD_SM :: BUF_READY [29:29] */
#define BCHP_MFD_TEST_PORT_DATA_PX_RD_SM_BUF_READY_MASK            0x20000000
#define BCHP_MFD_TEST_PORT_DATA_PX_RD_SM_BUF_READY_SHIFT           29

/* MFD :: TEST_PORT_DATA :: PX_RD_SM :: NUM_ACTIVE_PIXEL [28:19] */
#define BCHP_MFD_TEST_PORT_DATA_PX_RD_SM_NUM_ACTIVE_PIXEL_MASK     0x1ff80000
#define BCHP_MFD_TEST_PORT_DATA_PX_RD_SM_NUM_ACTIVE_PIXEL_SHIFT    19

/* MFD :: TEST_PORT_DATA :: PX_RD_SM :: INIT_PIX_OFFSET [18:15] */
#define BCHP_MFD_TEST_PORT_DATA_PX_RD_SM_INIT_PIX_OFFSET_MASK      0x00078000
#define BCHP_MFD_TEST_PORT_DATA_PX_RD_SM_INIT_PIX_OFFSET_SHIFT     15

/* MFD :: TEST_PORT_DATA :: PX_RD_SM :: RSM_CUR_STATE [14:12] */
#define BCHP_MFD_TEST_PORT_DATA_PX_RD_SM_RSM_CUR_STATE_MASK        0x00007000
#define BCHP_MFD_TEST_PORT_DATA_PX_RD_SM_RSM_CUR_STATE_SHIFT       12
#define BCHP_MFD_TEST_PORT_DATA_PX_RD_SM_RSM_CUR_STATE_IDLE        0
#define BCHP_MFD_TEST_PORT_DATA_PX_RD_SM_RSM_CUR_STATE_SEND_FIXED_COLOUR 1
#define BCHP_MFD_TEST_PORT_DATA_PX_RD_SM_RSM_CUR_STATE_READ_BUF_CHECK 2
#define BCHP_MFD_TEST_PORT_DATA_PX_RD_SM_RSM_CUR_STATE_PRIME_LUMA_BUF 3
#define BCHP_MFD_TEST_PORT_DATA_PX_RD_SM_RSM_CUR_STATE_PRIME_CHROMA_BUF 4
#define BCHP_MFD_TEST_PORT_DATA_PX_RD_SM_RSM_CUR_STATE_SEND_PIXEL  5
#define BCHP_MFD_TEST_PORT_DATA_PX_RD_SM_RSM_CUR_STATE_BUFFER_READ_DONE 6

/* MFD :: TEST_PORT_DATA :: PX_RD_SM :: DBUF_RD_ON [11:11] */
#define BCHP_MFD_TEST_PORT_DATA_PX_RD_SM_DBUF_RD_ON_MASK           0x00000800
#define BCHP_MFD_TEST_PORT_DATA_PX_RD_SM_DBUF_RD_ON_SHIFT          11

/* MFD :: TEST_PORT_DATA :: PX_RD_SM :: RD_PIXEL_CNT [10:01] */
#define BCHP_MFD_TEST_PORT_DATA_PX_RD_SM_RD_PIXEL_CNT_MASK         0x000007fe
#define BCHP_MFD_TEST_PORT_DATA_PX_RD_SM_RD_PIXEL_CNT_SHIFT        1

/* MFD :: TEST_PORT_DATA :: PX_RD_SM :: BUF_RD_DONE [00:00] */
#define BCHP_MFD_TEST_PORT_DATA_PX_RD_SM_BUF_RD_DONE_MASK          0x00000001
#define BCHP_MFD_TEST_PORT_DATA_PX_RD_SM_BUF_RD_DONE_SHIFT         0

/* union - case PX_RD_BVB [31:00] */
/* MFD :: TEST_PORT_DATA :: PX_RD_BVB :: reserved0 [31:30] */
#define BCHP_MFD_TEST_PORT_DATA_PX_RD_BVB_reserved0_MASK           0xc0000000
#define BCHP_MFD_TEST_PORT_DATA_PX_RD_BVB_reserved0_SHIFT          30

/* MFD :: TEST_PORT_DATA :: PX_RD_BVB :: CSM_CUR_STATE [29:27] */
#define BCHP_MFD_TEST_PORT_DATA_PX_RD_BVB_CSM_CUR_STATE_MASK       0x38000000
#define BCHP_MFD_TEST_PORT_DATA_PX_RD_BVB_CSM_CUR_STATE_SHIFT      27
#define BCHP_MFD_TEST_PORT_DATA_PX_RD_BVB_CSM_CUR_STATE_IDLE       0
#define BCHP_MFD_TEST_PORT_DATA_PX_RD_BVB_CSM_CUR_STATE_BUF_CHECK  1
#define BCHP_MFD_TEST_PORT_DATA_PX_RD_BVB_CSM_CUR_STATE_WAIT_ACK_LUMA 2
#define BCHP_MFD_TEST_PORT_DATA_PX_RD_BVB_CSM_CUR_STATE_REQ_CHROMA 3
#define BCHP_MFD_TEST_PORT_DATA_PX_RD_BVB_CSM_CUR_STATE_WAIT_ACK_CHROMA 4
#define BCHP_MFD_TEST_PORT_DATA_PX_RD_BVB_CSM_CUR_STATE_WAIT_WSM_DONE_CHROMA 5

/* MFD :: TEST_PORT_DATA :: PX_RD_BVB :: DBUF_WR_ADDR [26:21] */
#define BCHP_MFD_TEST_PORT_DATA_PX_RD_BVB_DBUF_WR_ADDR_MASK        0x07e00000
#define BCHP_MFD_TEST_PORT_DATA_PX_RD_BVB_DBUF_WR_ADDR_SHIFT       21

/* MFD :: TEST_PORT_DATA :: PX_RD_BVB :: DBUF_RD_ADDR [20:15] */
#define BCHP_MFD_TEST_PORT_DATA_PX_RD_BVB_DBUF_RD_ADDR_MASK        0x001f8000
#define BCHP_MFD_TEST_PORT_DATA_PX_RD_BVB_DBUF_RD_ADDR_SHIFT       15

/* MFD :: TEST_PORT_DATA :: PX_RD_BVB :: FIRST_BUF [14:14] */
#define BCHP_MFD_TEST_PORT_DATA_PX_RD_BVB_FIRST_BUF_MASK           0x00004000
#define BCHP_MFD_TEST_PORT_DATA_PX_RD_BVB_FIRST_BUF_SHIFT          14

/* MFD :: TEST_PORT_DATA :: PX_RD_BVB :: LAST_BUF [13:13] */
#define BCHP_MFD_TEST_PORT_DATA_PX_RD_BVB_LAST_BUF_MASK            0x00002000
#define BCHP_MFD_TEST_PORT_DATA_PX_RD_BVB_LAST_BUF_SHIFT           13

/* MFD :: TEST_PORT_DATA :: PX_RD_BVB :: PIXEL_STROBE [12:12] */
#define BCHP_MFD_TEST_PORT_DATA_PX_RD_BVB_PIXEL_STROBE_MASK        0x00001000
#define BCHP_MFD_TEST_PORT_DATA_PX_RD_BVB_PIXEL_STROBE_SHIFT       12

/* MFD :: TEST_PORT_DATA :: PX_RD_BVB :: CHROMA_PHASE [11:11] */
#define BCHP_MFD_TEST_PORT_DATA_PX_RD_BVB_CHROMA_PHASE_MASK        0x00000800
#define BCHP_MFD_TEST_PORT_DATA_PX_RD_BVB_CHROMA_PHASE_SHIFT       11

/* MFD :: TEST_PORT_DATA :: PX_RD_BVB :: FIRST_PIXEL [10:10] */
#define BCHP_MFD_TEST_PORT_DATA_PX_RD_BVB_FIRST_PIXEL_MASK         0x00000400
#define BCHP_MFD_TEST_PORT_DATA_PX_RD_BVB_FIRST_PIXEL_SHIFT        10

/* MFD :: TEST_PORT_DATA :: PX_RD_BVB :: LAST_PIXEL [09:09] */
#define BCHP_MFD_TEST_PORT_DATA_PX_RD_BVB_LAST_PIXEL_MASK          0x00000200
#define BCHP_MFD_TEST_PORT_DATA_PX_RD_BVB_LAST_PIXEL_SHIFT         9

/* MFD :: TEST_PORT_DATA :: PX_RD_BVB :: FIRST_LINE [08:08] */
#define BCHP_MFD_TEST_PORT_DATA_PX_RD_BVB_FIRST_LINE_MASK          0x00000100
#define BCHP_MFD_TEST_PORT_DATA_PX_RD_BVB_FIRST_LINE_SHIFT         8

/* MFD :: TEST_PORT_DATA :: PX_RD_BVB :: LAST_LINE [07:07] */
#define BCHP_MFD_TEST_PORT_DATA_PX_RD_BVB_LAST_LINE_MASK           0x00000080
#define BCHP_MFD_TEST_PORT_DATA_PX_RD_BVB_LAST_LINE_SHIFT          7

/* MFD :: TEST_PORT_DATA :: PX_RD_BVB :: FIFO_FULL [06:06] */
#define BCHP_MFD_TEST_PORT_DATA_PX_RD_BVB_FIFO_FULL_MASK           0x00000040
#define BCHP_MFD_TEST_PORT_DATA_PX_RD_BVB_FIFO_FULL_SHIFT          6

/* MFD :: TEST_PORT_DATA :: PX_RD_BVB :: FIFO_EMPTY [05:05] */
#define BCHP_MFD_TEST_PORT_DATA_PX_RD_BVB_FIFO_EMPTY_MASK          0x00000020
#define BCHP_MFD_TEST_PORT_DATA_PX_RD_BVB_FIFO_EMPTY_SHIFT         5

/* MFD :: TEST_PORT_DATA :: PX_RD_BVB :: FIFO_DEPTH_CNT [04:03] */
#define BCHP_MFD_TEST_PORT_DATA_PX_RD_BVB_FIFO_DEPTH_CNT_MASK      0x00000018
#define BCHP_MFD_TEST_PORT_DATA_PX_RD_BVB_FIFO_DEPTH_CNT_SHIFT     3

/* MFD :: TEST_PORT_DATA :: PX_RD_BVB :: PIXEL_STOP [02:02] */
#define BCHP_MFD_TEST_PORT_DATA_PX_RD_BVB_PIXEL_STOP_MASK          0x00000004
#define BCHP_MFD_TEST_PORT_DATA_PX_RD_BVB_PIXEL_STOP_SHIFT         2

/* MFD :: TEST_PORT_DATA :: PX_RD_BVB :: BVB_EOL [01:01] */
#define BCHP_MFD_TEST_PORT_DATA_PX_RD_BVB_BVB_EOL_MASK             0x00000002
#define BCHP_MFD_TEST_PORT_DATA_PX_RD_BVB_BVB_EOL_SHIFT            1

/* MFD :: TEST_PORT_DATA :: PX_RD_BVB :: BVB_EOF [00:00] */
#define BCHP_MFD_TEST_PORT_DATA_PX_RD_BVB_BVB_EOF_MASK             0x00000001
#define BCHP_MFD_TEST_PORT_DATA_PX_RD_BVB_BVB_EOF_SHIFT            0

/* union - case CLB_0 [31:00] */
/* MFD :: TEST_PORT_DATA :: CLB_0 :: reserved0 [31:31] */
#define BCHP_MFD_TEST_PORT_DATA_CLB_0_reserved0_MASK               0x80000000
#define BCHP_MFD_TEST_PORT_DATA_CLB_0_reserved0_SHIFT              31

/* MFD :: TEST_PORT_DATA :: CLB_0 :: BURST_SIZE [30:26] */
#define BCHP_MFD_TEST_PORT_DATA_CLB_0_BURST_SIZE_MASK              0x7c000000
#define BCHP_MFD_TEST_PORT_DATA_CLB_0_BURST_SIZE_SHIFT             26

/* MFD :: TEST_PORT_DATA :: CLB_0 :: TOP_TAP_SEL [25:24] */
#define BCHP_MFD_TEST_PORT_DATA_CLB_0_TOP_TAP_SEL_MASK             0x03000000
#define BCHP_MFD_TEST_PORT_DATA_CLB_0_TOP_TAP_SEL_SHIFT            24
#define BCHP_MFD_TEST_PORT_DATA_CLB_0_TOP_TAP_SEL_LIVE_CHROMA      0
#define BCHP_MFD_TEST_PORT_DATA_CLB_0_TOP_TAP_SEL_CLB0_CHROMA      1
#define BCHP_MFD_TEST_PORT_DATA_CLB_0_TOP_TAP_SEL_CLB1_CHROMA      2

/* MFD :: TEST_PORT_DATA :: CLB_0 :: BOT_TAP_SEL [23:22] */
#define BCHP_MFD_TEST_PORT_DATA_CLB_0_BOT_TAP_SEL_MASK             0x00c00000
#define BCHP_MFD_TEST_PORT_DATA_CLB_0_BOT_TAP_SEL_SHIFT            22
#define BCHP_MFD_TEST_PORT_DATA_CLB_0_BOT_TAP_SEL_LIVE_CHROMA      0
#define BCHP_MFD_TEST_PORT_DATA_CLB_0_BOT_TAP_SEL_CLB0_CHROMA      1
#define BCHP_MFD_TEST_PORT_DATA_CLB_0_BOT_TAP_SEL_CLB1_CHROMA      2

/* MFD :: TEST_PORT_DATA :: CLB_0 :: ADDR_A [21:12] */
#define BCHP_MFD_TEST_PORT_DATA_CLB_0_ADDR_A_MASK                  0x003ff000
#define BCHP_MFD_TEST_PORT_DATA_CLB_0_ADDR_A_SHIFT                 12

/* MFD :: TEST_PORT_DATA :: CLB_0 :: ADDR_B [11:02] */
#define BCHP_MFD_TEST_PORT_DATA_CLB_0_ADDR_B_MASK                  0x00000ffc
#define BCHP_MFD_TEST_PORT_DATA_CLB_0_ADDR_B_SHIFT                 2

/* MFD :: TEST_PORT_DATA :: CLB_0 :: WR_RDB_A [01:01] */
#define BCHP_MFD_TEST_PORT_DATA_CLB_0_WR_RDB_A_MASK                0x00000002
#define BCHP_MFD_TEST_PORT_DATA_CLB_0_WR_RDB_A_SHIFT               1
#define BCHP_MFD_TEST_PORT_DATA_CLB_0_WR_RDB_A_READ                0
#define BCHP_MFD_TEST_PORT_DATA_CLB_0_WR_RDB_A_WRITE               1

/* MFD :: TEST_PORT_DATA :: CLB_0 :: WR_RDB_B [00:00] */
#define BCHP_MFD_TEST_PORT_DATA_CLB_0_WR_RDB_B_MASK                0x00000001
#define BCHP_MFD_TEST_PORT_DATA_CLB_0_WR_RDB_B_SHIFT               0
#define BCHP_MFD_TEST_PORT_DATA_CLB_0_WR_RDB_B_READ                0
#define BCHP_MFD_TEST_PORT_DATA_CLB_0_WR_RDB_B_WRITE               1

/* union - case CLB_1 [31:00] */
/* MFD :: TEST_PORT_DATA :: CLB_1 :: WR_DATA_A [31:16] */
#define BCHP_MFD_TEST_PORT_DATA_CLB_1_WR_DATA_A_MASK               0xffff0000
#define BCHP_MFD_TEST_PORT_DATA_CLB_1_WR_DATA_A_SHIFT              16

/* MFD :: TEST_PORT_DATA :: CLB_1 :: RD_DATA_B [15:00] */
#define BCHP_MFD_TEST_PORT_DATA_CLB_1_RD_DATA_B_MASK               0x0000ffff
#define BCHP_MFD_TEST_PORT_DATA_CLB_1_RD_DATA_B_SHIFT              0

/* union - case BVB_OUT [31:00] */
/* MFD :: TEST_PORT_DATA :: BVB_OUT :: reserved0 [31:28] */
#define BCHP_MFD_TEST_PORT_DATA_BVB_OUT_reserved0_MASK             0xf0000000
#define BCHP_MFD_TEST_PORT_DATA_BVB_OUT_reserved0_SHIFT            28

/* MFD :: TEST_PORT_DATA :: BVB_OUT :: ACCEPT [27:27] */
#define BCHP_MFD_TEST_PORT_DATA_BVB_OUT_ACCEPT_MASK                0x08000000
#define BCHP_MFD_TEST_PORT_DATA_BVB_OUT_ACCEPT_SHIFT               27

/* MFD :: TEST_PORT_DATA :: BVB_OUT :: READY [26:26] */
#define BCHP_MFD_TEST_PORT_DATA_BVB_OUT_READY_MASK                 0x04000000
#define BCHP_MFD_TEST_PORT_DATA_BVB_OUT_READY_SHIFT                26

/* MFD :: TEST_PORT_DATA :: BVB_OUT :: PICTURE_SYNC [25:24] */
#define BCHP_MFD_TEST_PORT_DATA_BVB_OUT_PICTURE_SYNC_MASK          0x03000000
#define BCHP_MFD_TEST_PORT_DATA_BVB_OUT_PICTURE_SYNC_SHIFT         24
#define BCHP_MFD_TEST_PORT_DATA_BVB_OUT_PICTURE_SYNC_NORMAL_PIXEL  0
#define BCHP_MFD_TEST_PORT_DATA_BVB_OUT_PICTURE_SYNC_FIRST_PIXEL   1
#define BCHP_MFD_TEST_PORT_DATA_BVB_OUT_PICTURE_SYNC_LAST_PIXEL    2

/* MFD :: TEST_PORT_DATA :: BVB_OUT :: LINE_SYNC [23:22] */
#define BCHP_MFD_TEST_PORT_DATA_BVB_OUT_LINE_SYNC_MASK             0x00c00000
#define BCHP_MFD_TEST_PORT_DATA_BVB_OUT_LINE_SYNC_SHIFT            22
#define BCHP_MFD_TEST_PORT_DATA_BVB_OUT_LINE_SYNC_NORMAL_PIXEL     0
#define BCHP_MFD_TEST_PORT_DATA_BVB_OUT_LINE_SYNC_FIRST_PIXEL      1
#define BCHP_MFD_TEST_PORT_DATA_BVB_OUT_LINE_SYNC_LAST_PIXEL       2

/* MFD :: TEST_PORT_DATA :: BVB_OUT :: COLOUR_SYNC [21:20] */
#define BCHP_MFD_TEST_PORT_DATA_BVB_OUT_COLOUR_SYNC_MASK           0x00300000
#define BCHP_MFD_TEST_PORT_DATA_BVB_OUT_COLOUR_SYNC_SHIFT          20
#define BCHP_MFD_TEST_PORT_DATA_BVB_OUT_COLOUR_SYNC_FIRST_BEAT     0
#define BCHP_MFD_TEST_PORT_DATA_BVB_OUT_COLOUR_SYNC_SECOND_BEAT    1
#define BCHP_MFD_TEST_PORT_DATA_BVB_OUT_COLOUR_SYNC_THIRD_BEAT     2
#define BCHP_MFD_TEST_PORT_DATA_BVB_OUT_COLOUR_SYNC_FOURTH_BEAT    3

/* MFD :: TEST_PORT_DATA :: BVB_OUT :: LUMA_DATA [19:10] */
#define BCHP_MFD_TEST_PORT_DATA_BVB_OUT_LUMA_DATA_MASK             0x000ffc00
#define BCHP_MFD_TEST_PORT_DATA_BVB_OUT_LUMA_DATA_SHIFT            10

/* MFD :: TEST_PORT_DATA :: BVB_OUT :: CHROMA_DATA [09:00] */
#define BCHP_MFD_TEST_PORT_DATA_BVB_OUT_CHROMA_DATA_MASK           0x000003ff
#define BCHP_MFD_TEST_PORT_DATA_BVB_OUT_CHROMA_DATA_SHIFT          0

/***************************************************************************
 *SCRATCH_REGISTER_0 - MPEG/Video Feeder Scratch 0 Register
 ***************************************************************************/
/* MFD :: SCRATCH_REGISTER_0 :: VALUE [31:00] */
#define BCHP_MFD_SCRATCH_REGISTER_0_VALUE_MASK                     0xffffffff
#define BCHP_MFD_SCRATCH_REGISTER_0_VALUE_SHIFT                    0

/***************************************************************************
 *SCRATCH_REGISTER_1 - MPEG/Video Feeder Scratch 1 Register
 ***************************************************************************/
/* MFD :: SCRATCH_REGISTER_1 :: VALUE [31:00] */
#define BCHP_MFD_SCRATCH_REGISTER_1_VALUE_MASK                     0xffffffff
#define BCHP_MFD_SCRATCH_REGISTER_1_VALUE_SHIFT                    0

#endif /* #ifndef BCHP_MFD_H__ */

/* End of File */
