/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.trans;

import java.io.Serializable;
import net.sf.saxon.Configuration;
import net.sf.saxon.expr.Binding;
import net.sf.saxon.expr.BindingReference;
import net.sf.saxon.expr.VariableDeclaration;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.om.ValueRepresentation;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.value.EmptySequence;
import net.sf.saxon.value.QNameValue;
import net.sf.saxon.value.SequenceType;
import net.sf.saxon.value.Value;

public final class Variable
implements VariableDeclaration,
Binding,
Serializable {
    private QNameValue name;
    private ValueRepresentation value;
    private Configuration config;
    private int slotNumber;
    private boolean useStack = false;

    private Variable() {
    }

    public static Variable make(QNameValue qNameValue, Configuration configuration) {
        Variable variable = new Variable();
        variable.name = qNameValue;
        variable.config = configuration;
        return variable;
    }

    public void setUseStack(boolean bl) {
        this.useStack = true;
    }

    public boolean isGlobal() {
        return true;
    }

    public final boolean isAssignable() {
        return false;
    }

    public void setSlotNumber(int n) {
        this.slotNumber = n;
    }

    public int getLocalSlotNumber() {
        return this.slotNumber;
    }

    public String getVariableName() {
        return this.name.toString();
    }

    public int getNameCode() {
        return this.name.allocateNameCode(this.config.getNamePool());
    }

    public void setValue(Object object) throws XPathException {
        this.value = Value.convertJavaObjectToXPath(object, SequenceType.ANY_SEQUENCE, this.config);
        if (this.value == null) {
            this.value = EmptySequence.getInstance();
        }
    }

    public void setXPathValue(ValueRepresentation valueRepresentation) {
        this.value = valueRepresentation;
        if (this.value == null) {
            this.value = EmptySequence.getInstance();
        }
    }

    public void registerReference(BindingReference bindingReference) {
        bindingReference.setStaticType(SequenceType.ANY_SEQUENCE, null, 0);
        bindingReference.fixup(this);
    }

    public ValueRepresentation evaluateVariable(XPathContext xPathContext) {
        if (this.useStack) {
            return xPathContext.evaluateLocalVariable(this.slotNumber);
        }
        return this.value;
    }
}

