/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.expr;

import java.io.PrintStream;
import java.util.Arrays;
import java.util.Iterator;
import net.sf.saxon.Configuration;
import net.sf.saxon.expr.ComputedExpression;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.ExpressionTool;
import net.sf.saxon.expr.Optimizer;
import net.sf.saxon.expr.PromotionOffer;
import net.sf.saxon.expr.StaticContext;
import net.sf.saxon.om.NamePool;
import net.sf.saxon.trans.StaticError;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.value.SequenceExtent;
import net.sf.saxon.value.Value;

public abstract class FunctionCall
extends ComputedExpression {
    private int nameCode;
    protected Expression[] argument;

    public final void setFunctionNameCode(int n) {
        this.nameCode = n;
    }

    public final int getFunctionNameCode() {
        return this.nameCode;
    }

    public final int getNumberOfArguments() {
        return this.argument.length;
    }

    public void setArguments(Expression[] expressionArray) {
        this.argument = expressionArray;
        for (int i = 0; i < expressionArray.length; ++i) {
            this.adoptChildExpression(expressionArray[i]);
        }
    }

    public Expression[] getArguments() {
        return this.argument;
    }

    public Expression simplify(StaticContext staticContext) throws XPathException {
        return this.simplifyArguments(staticContext);
    }

    protected final Expression simplifyArguments(StaticContext staticContext) throws XPathException {
        for (int i = 0; i < this.argument.length; ++i) {
            Expression expression = this.argument[i].simplify(staticContext);
            if (expression == this.argument[i]) continue;
            this.adoptChildExpression(expression);
            this.argument[i] = expression;
        }
        return this;
    }

    public Expression typeCheck(StaticContext staticContext, ItemType itemType) throws XPathException {
        boolean bl = true;
        for (int i = 0; i < this.argument.length; ++i) {
            Expression expression = this.argument[i].typeCheck(staticContext, itemType);
            if (expression != this.argument[i]) {
                this.adoptChildExpression(expression);
                this.argument[i] = expression;
            }
            if (this.argument[i] instanceof Value) continue;
            bl = false;
        }
        this.checkArguments(staticContext);
        if (bl) {
            return this.preEvaluate(staticContext);
        }
        return this;
    }

    public Expression optimize(Optimizer optimizer, StaticContext staticContext, ItemType itemType) throws XPathException {
        boolean bl = true;
        for (int i = 0; i < this.argument.length; ++i) {
            Expression expression = this.argument[i].optimize(optimizer, staticContext, itemType);
            if (expression != this.argument[i]) {
                this.adoptChildExpression(expression);
                this.argument[i] = expression;
            }
            if (!bl || this.argument[i] instanceof Value) continue;
            bl = false;
        }
        this.checkArguments(staticContext);
        if (bl) {
            return this.preEvaluate(staticContext);
        }
        return this;
    }

    public Expression preEvaluate(StaticContext staticContext) throws XPathException {
        return Value.asValue(SequenceExtent.makeSequenceExtent(this.iterate(staticContext.makeEarlyEvaluationContext())));
    }

    public Expression promote(PromotionOffer promotionOffer) throws XPathException {
        Expression expression = promotionOffer.accept(this);
        if (expression != null) {
            return expression;
        }
        if (promotionOffer.action != 13) {
            for (int i = 0; i < this.argument.length; ++i) {
                this.argument[i] = this.doPromotion(this.argument[i], promotionOffer);
            }
        }
        return this;
    }

    protected abstract void checkArguments(StaticContext var1) throws XPathException;

    protected int checkArgumentCount(int n, int n2, StaticContext staticContext) throws XPathException {
        int n3 = this.argument.length;
        if (n == n2 && n3 != n) {
            throw new StaticError("Function " + this.getDisplayName(staticContext.getNamePool()) + " must have " + n + FunctionCall.pluralArguments(n), ExpressionTool.getLocator(this));
        }
        if (n3 < n) {
            throw new StaticError("Function " + this.getDisplayName(staticContext.getNamePool()) + " must have at least " + n + FunctionCall.pluralArguments(n), ExpressionTool.getLocator(this));
        }
        if (n3 > n2) {
            throw new StaticError("Function " + this.getDisplayName(staticContext.getNamePool()) + " must have no more than " + n2 + FunctionCall.pluralArguments(n2), ExpressionTool.getLocator(this));
        }
        return n3;
    }

    private static String pluralArguments(int n) {
        if (n == 1) {
            return " argument";
        }
        return " arguments";
    }

    public Iterator iterateSubExpressions() {
        return Arrays.asList(this.argument).iterator();
    }

    public boolean replaceSubExpression(Expression expression, Expression expression2) {
        boolean bl = false;
        for (int i = 0; i < this.argument.length; ++i) {
            if (this.argument[i] != expression) continue;
            this.argument[i] = expression2;
            bl = true;
        }
        return bl;
    }

    public final String getDisplayName(NamePool namePool) {
        return namePool.getDisplayName(this.getFunctionNameCode());
    }

    public void display(int n, PrintStream printStream, Configuration configuration) {
        printStream.println(ExpressionTool.indent(n) + "function " + this.getDisplayName(configuration.getNamePool()));
        for (int i = 0; i < this.argument.length; ++i) {
            this.argument[i].display(n + 1, printStream, configuration);
        }
    }
}

