#!/usr/bin/env python

import tempfile
import shutil
import os
import sys
import re
import string
from optparse import OptionParser

cmake_pattern = """cmake_minimum_required(VERSION 2.8.8)

set(CMAKE_MODULE_PATH ${CMAKE_MODULE_PATH} "${PROJECT_SOURCE_DIR}")

project({APP_NAME})

install (DIRECTORY ${PROJECT_SOURCE_DIR}/www DESTINATION share/{APP_NAME})
install (FILES ${PROJECT_SOURCE_DIR}/{APP_NAME}.desktop DESTINATION share/applications/)
install (FILES ${PROJECT_SOURCE_DIR}/{ICON_NAME} DESTINATION share/{APP_NAME})

set (CPACK_DEBIAN_BUILD_DEPENDS debhelper cmake)
set (CPACK_PACKAGE_NAME {APP_NAME})
set (CPACK_PACKAGE_CONTACT "{APP_MAINTAINER}")
set (CPACK_PACKAGE_VERSION {APP_VERSION})
set (CPACK_DEBIAN_PACKAGE_DEPENDS "cordova-ubuntu-{CORDOVA_VERSION}")
set (CPACK_DEBIAN_PACKAGE_ARCHITECTURE "all")
set (DPUT_HOST "ppa:campo/1.0")
set(CPACK_DEBIAN_DISTRIBUTION_NAME ubuntu)
set(CPACK_DEBIAN_DISTRIBUTION_RELEASES raring saucy)

INCLUDE(CPack)
INCLUDE(DebSourcePPA)
"""

def fix_ref(path, version):
    source = string.join(open(path).readlines(), '')
    re.sub('src=["\']cordova-\d\.\d\.\d(rc\d)?.js["\']', r'src="file:///usr/share/cordova-ubuntu-' + version + '/www/cordova-' + version + '.js"', source)
    with open(path, 'w') as f:
        f.write(source)

def cordova_runtime_path_for(version):
    return '/usr/share/cordova-ubuntu-' + version + '/www/cordova-' + version + '.js'

def make_package(version, app_name, app_version, www_dir, maintainer, icon_path, dput, fix_refs):
    if re.match(r'.*\s.*', 'app-demo'):
        print 'Application name should not contain any spaces'
        return

    if not os.path.isfile(cordova_runtime_path_for(version)):
        print 'Invalid version number, could not find qtcordova runtime installed with version: ' + str(version)
        return

    if not os.path.isfile(icon_path):
        print "Missing icon file path (or file does not exist)"
        return

    if not os.path.exists(www_dir):
        print "Invalid path to package: '", www_dir, "'"
        return

    tmp_path = tempfile.mkdtemp()

    if fix_refs:
        shutil.copytree(www_dir, os.path.join(tmp_path, 'www'), ignore = shutil.ignore_patterns("cordova*.js", ".git", ".bzr"))
    else:
        shutil.copytree(www_dir, os.path.join(tmp_path, 'www'), ignore = shutil.ignore_patterns(".git", ".bzr"))
    icon = os.path.join(tmp_path, os.path.basename(icon_path))
    shutil.copyfile(icon_path, icon)

    if fix_refs:
        for root, dirs, files in os.walk(www_dir):
            for file in files:
                if re.match('.+\\.html$', file):
                    fix_ref(os.path.join(root, file), version)

    prefix = os.path.join('/usr/share/', app_name)

    with open(os.path.join(tmp_path, app_name + '.desktop'), 'w') as f:
        content = "[Desktop Entry]\nName={0}\nType=Application\nExec=/usr/bin/cordova-ubuntu-{3} {1}\nIcon={2}\nX-Ubuntu-Touch=true"
        content = content.format(app_name, os.path.join(prefix, 'www'), os.path.join(prefix, os.path.basename(icon_path)), version)
        f.write(content)
    with open(os.path.join(tmp_path, "CMakeLists.txt"), 'w') as f:
        cmake = cmake_pattern.format(APP_NAME = app_name, APP_VERSION = app_version, CORDOVA_VERSION = version, PROJECT_SOURCE_DIR = "{CMAKE_SOURCE_DIR}",
                                     APP_MAINTAINER = maintainer, ICON_NAME = os.path.basename(icon), CMAKE_MODULE_PATH="{CMAKE_MODULE_PATH}")
        f.write(cmake)

    shutil.copyfile(os.path.join(os.path.dirname(os.path.realpath(__file__)), 'DebSourcePPA.cmake'), os.path.join(tmp_path, 'DebSourcePPA.cmake'))
    build_tmp_dir = tempfile.mkdtemp()

    os.system('cd {0}; cmake {1}; cpack -G DEB; cp {2}*.deb {3}'.format(build_tmp_dir, tmp_path, app_name, os.getcwd()))
    if dput:
        os.system('cd {0}; make dput'.format(build_tmp_dir, tmp_path, app_name, os.getcwd()))

    shutil.rmtree(tmp_path)
    shutil.rmtree(build_tmp_dir)

if __name__ == '__main__':
    usage='Usage: package.py --dput_to_ppa --fix-refs cordova_version app_name app_version path_to_www maintainer icon_path'
    parser = OptionParser(usage=usage)
    parser.add_option("--dput_to_ppa", action="store_true", dest="dput")
    parser.add_option("--fix-refs", action="store_true", dest="fix_refs")
    (options, args) = parser.parse_args()

    if len(args) == 6:
        version = args[0]
        app_name = args[1]
        app_version = args[2]
        www_dir = args[3]
        maintainer = args[4]
        icon_path = args[5]
        dput = options.dput
        fix_refs = options.fix_refs

        make_package(version, app_name, app_version, www_dir, maintainer, icon_path, dput, fix_refs)
    else:
        print "Invalid argument count:"
        print "\t", usage
