/*
 * boiltime.cpp is part of Brewtarget, and is Copyright the following
 * authors 2009-2014
 * - Aidan Roberts <aidanr67@gmail.com>
 *
 * Brewtarget is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * Brewtarget is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#ifndef BOILTIME_H
#define BOILTIME_H

#include <QObject>
#include <QTimer>
/*!
 * \brief Used by TimerMainDialog and TimerWidget
 * \author Aidan Roberts
 *
 * Makes it possible to trigger multiple timers using one QTimer
 */

class BoilTime : public QObject
{
    Q_OBJECT
public:
    BoilTime(QObject * parent);
    void setBoilTime(int boilTime);
    int getTime();
    bool isStarted();
    bool isCompleted();
    void startTimer();
    void stopTimer();

private slots:
    void decrementTime();

signals:
    void BoilTimeChanged();
    void timesUp();

private:
    QTimer* timer;
    unsigned int time;
    bool started;
    bool completed;
};

#endif // BOILTIME_H
