//  ************************************************************************************************
//
//  BornAgain: simulate and fit reflection and scattering
//
//! @file      Sample/StandardSamples/LatticeBuilder.cpp
//! @brief     Implements class Lattice1DBuilder.
//!
//! @homepage  http://www.bornagainproject.org
//! @license   GNU General Public License v3 or higher (see COPYING)
//! @copyright Forschungszentrum Jülich GmbH 2018
//! @authors   Scientific Computing Group at MLZ (see CITATION, AUTHORS)
//
//  ************************************************************************************************

#include "Sample/StandardSamples/LatticeBuilder.h"
#include "Base/Const/Units.h"
#include "Sample/Aggregate/Interference1DLattice.h"
#include "Sample/Aggregate/ParticleLayout.h"
#include "Sample/Correlations/Profiles1D.h"
#include "Sample/Correlations/Profiles2D.h"
#include "Sample/HardParticle/Cylinder.h"
#include "Sample/Multilayer/Layer.h"
#include "Sample/Multilayer/MultiLayer.h"
#include "Sample/Particle/Particle.h"
#include "Sample/StandardSamples/ReferenceMaterials.h"

using Units::deg;

MultiLayer* ExemplarySamples::createLattice1D()
{
    const double length(20.0);
    const double xi(10.0 * deg);
    const double corr_length(1000.0);
    const double cylinder_height(5);
    const double cylinder_radius(5);

    Layer vacuum_layer(refMat::Vacuum);
    Layer substrate_layer(refMat::Substrate);

    Interference1DLattice interparticle(length, xi);
    Profile1DCauchy pdf(corr_length);
    interparticle.setDecayFunction(pdf);

    Cylinder ff_cylinder(cylinder_radius, cylinder_height);
    Particle cylinder(refMat::Particle, ff_cylinder);

    ParticleLayout particle_layout(cylinder);
    particle_layout.setInterference(interparticle);

    vacuum_layer.addLayout(particle_layout);

    auto* sample = new MultiLayer();
    sample->addLayer(vacuum_layer);
    sample->addLayer(substrate_layer);
    return sample;
}
