#include "Bdef.h"
void dgupk_amx2(MatInf, buff)
MATINFO  *MatInf;
char  *buff;
{
   int m, n, lda, i, j;
   double *A, *v, diff;

   m = MatInf->M;
   n = MatInf->N;
   lda = MatInf->lda;
   A = (double *) MatInf->A;
   v = (double *) buff;

   if (m != 1)
   {
      for(j=n; j; j--)
      {
	 i = pvm_upkdouble(v, m, 1);
	 Mpvmerror(i, "pvm_upkdouble", __LINE__, __FILE__);
         for (i=0; i != m; i++)
         {
            diff = Rabs(A[i]) - Rabs(v[i]);
            if (diff < 0) A[i] = v[i];
            else if (diff == 0) if (A[i] < v[i]) A[i] = v[i];
         }
	 A += lda;
      }
   }
   else
   {
      i = pvm_upkdouble(v, n, 1);
      Mpvmerror(i, "pvm_upkdouble", __LINE__, __FILE__);
      for (i=j=0; j != n; j++, i += lda)
      {
         diff = Rabs(A[i]) - Rabs(v[j]);
         if (diff < 0) A[i] = v[j];
         else if (diff == 0) if (A[i] < v[j]) A[i] = v[j];
      }
   }
}
