/****************************************************************
**
** Attal : Lords of Doom
**
** loadGame.ccppp
** manage loading of scenarii and campaigns
**
** Version : $Id: loadGame.cpp,v 1.30 2008/02/20 23:52:24 lusum Exp $
**
** Author(s) : Sardi Carlo
**
** Date : 11/10/2006
**
** Licence :
**	This program is free software; you can redistribute it and/or modify
**   	it under the terms of the GNU General Public License as published by
**     	the Free Software Foundation; either version 2, or (at your option)
**      any later version.
**
**	This program is distributed in the hope that it will be useful,
** 	but WITHOUT ANY WARRANTY; without even the implied warranty of
**	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**	GNU General Public License for more details.
**
****************************************************************/

#include "loadGame.h"

// generic include files
// include files for QT
#include <QApplication>
#include <QFileDialog>
#include <QMessageBox>
// application specific includes
#include "libCommon/log.h"
#include "libCommon/campaign.h"

#include "engine.h"

extern QString THEME;
extern QString SCENARIO_PATH;
extern QString CAMPAIGN_PATH;
extern QString SAVE_PATH;
extern QString PORT;


LoadGame::LoadGame()
{
	_aiDbg = false;
	_inLoad = false;
	_winner = true;
	_readyIn = true;
	_readyOut = true;
	_server = NULL;
	_engine = NULL;
}

LoadGame::~LoadGame()
{
}

void LoadGame::load(const QString & filename)
{
	TRACE("void LoadGame::load(QString filename %s", qPrintable(  filename ));

	if( ( _server->getNbSocket() > 0 ) && ( !filename.isNull() ) ) {
		/* semaphore to avoid process 2 signal at same time */
		if(!_inLoad) {
			_inLoad = true;
			fillWithAI(filename);
restart:
			if( _engine->loadGame( filename, false ) ) {
				/* keep these istructions in this order */
				adjustWidgetLoading( W_ENGINE );
				_engine->startGame();
			} else {
				if ( _aiDbg ) {
					QMessageBox msb(  "Problem" , "Do you want to continue game (control right number of AI)?" , QMessageBox::Warning, QMessageBox::Yes | 			QMessageBox::Default, QMessageBox::No | QMessageBox::Escape, 0, 0 );
					if( msb.exec() == QMessageBox::Yes){
						goto restart;
					}
				}
			}
			_inLoad = false;
		}
	}

}

void LoadGame::loadCampaign(QString filename)
{
	TRACE("filename %s",filename.toLatin1().constData());

	if( ( _server->getNbSocket() == 1 ) && ( ! filename.isNull() ) ) {
		if( _engine && _engine->loadCampaign( filename ) ) {
			if( _engine->getCampaign() ) {
				continueCampaign( false );
			}
		}
	}
}

void LoadGame::loadSingle(const QString & filename)
{
	TRACE("LoadGame::loadSingle filename %s", qPrintable( filename ) );

	//newEngine();
	load( filename );
}

void LoadGame::addInternalAI()
{
	_readyIn = true;
}

bool LoadGame::fillWithAI(const QString & filename)
{
	TRACE("bool LoadGame::fillWithAI(QString filename %s)",qPrintable(filename));

	if ( !_engine->checkGamePlayers( filename ) ) {
		int nplay = _engine->getNumFillPlayers();
		TRACE("LoadGame::fillWithAI nplay %d",nplay);
		if( nplay > 0 ) {
			//QTimer::singleShot( (nplay+2)* 1000, this, SLOT( slot_ready() ) );
			for( int i = 0; i < nplay; i++ ) {
				_readyIn = false;
				TRACE("ai %d",i);
				addInternalAI();	
				while( !_readyIn ){
					qApp->processEvents();
				}
			}	
			return true;
		}
	}
	return false;
}

void LoadGame::loadScenario( int /* num */)
{
}

void LoadGame::autosave()
{
		
	TRACE("void LoadGame::autosave");

	if( _engine ) {
		QString numTurn = QString::number(_engine->getTurn());
		while( numTurn.size() < 3 ) {
			numTurn.prepend('0');
		}
		
		QString gamename = _engine->getScenarioName();
		QString savename  = gamename + "-turn-" + numTurn +".gam";

		TRACE("void LoadGame::savename %s", savename.toLatin1().constData());

		save( QString( SAVE_PATH + savename ) );
		save( QString( SAVE_PATH + "autosave.gam") );
	}
}

void LoadGame::save()
{
	if(_engine) {
		QString filen;
		filen = QFileDialog::getSaveFileName( 0 ,"", SAVE_PATH , "*.gam" );
		save( filen );
	}
	
}

void LoadGame::save(QString filename)
{
	if(_engine) {
		_engine->saveGame( filename );
	}

}

void LoadGame::handleResult( bool result )
{
	TRACE("LoadGame::handleResult( bool result %d)", result);

	_winner = result;
	
	if( _engine && _engine->getCampaign()) {
	
		TRACE("handleResult  isCampaign");
		int nbScen = _engine->getCampaign()->getScenarioNumber();
		int actScen = _engine->getCampaign()->getCurrentScenario();
		
		if( !_winner || actScen >= nbScen ) {
			endGame();
		} else if( _winner ) {
			continueCampaign( true );
		}
	} else {
		endGame();
	}
}

void LoadGame::endGame()
{
	TRACE("LoadGame::endGame");

	reinitStatus();

	if( _engine ) {
		_engine->deleteCampaign();
		endEngine();
		endServer();
	} 

}
/*
void LoadGame::endEngine()
{
}
*/
void LoadGame::reinitStatus()
{
	TRACE("LoadGame::reinitStatus");

	_readyOut = true;

	if(!_aiDbg) {
		disconnectAI();
	}
				
	while( !_readyOut ){
		qApp->processEvents();
	}

	if(!_aiDbg) {
		killAI();
	}
	
	_winner = true;
	adjustWidgetLoading( W_NORMAL );

}

QString LoadGame::getFileName(QString filename)
{
	filename = filename.section(QDir::separator(),-1,-1);

	if(filename.contains(".gam")){
		filename.remove(".gam");
	}
	
	if(filename.contains(".scn")){
		filename.remove(".scn");
	}
	return filename;
}
	
void LoadGame::continueCampaign( bool next )
{
	
	TRACE("LoadGame::continueCampaign( bool next %d)", next );

	reinitStatus();

	QString currentPath;
	QString filename;

	
	int actScen = _engine->getCampaign()->getCurrentScenario();
 	int nbScen = _engine->getCampaign()->getScenarioNumber();
	
	if( next ) {
		actScen++;
	}

	if( actScen < nbScen) {
		currentPath = CAMPAIGN_PATH;
		_engine->getCampaign()->setCurrentScenario( actScen );
		filename = _engine->getCampaign()->getScenario( actScen );
		if(filename.contains(".gam")){
			currentPath = SAVE_PATH;
		}

		load( currentPath + filename );

	} else {
		endGame();
	}
}

void LoadGame::newEngine()
{	
	TRACE("LoadGame::newEngine()");

	_engine = new Engine( _server );
	qsrand(time(NULL));
	int id = qrand() % INT_MAX;
	_engine->setGameId( id );
	_engine->start();
}
