// This file is part of PUMA.
// Copyright (C) 1999-2003  The PUMA developer team.
//                                                                
// This program is free software;  you can redistribute it and/or 
// modify it under the terms of the GNU General Public License as 
// published by the Free Software Foundation; either version 2 of 
// the License, or (at your option) any later version.            
//                                                                
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of 
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the  
// GNU General Public License for more details.                   
//                                                                
// You should have received a copy of the GNU General Public      
// License along with this program; if not, write to the Free     
// Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, 
// MA  02111-1307  USA                                            

#ifndef __str_col__
#define __str_col__

// Collection of functions handling strings.

namespace Puma {


class Unit;

class StrCol {
protected:
  StrCol () {}

public:
  // Return true if c is a white space character.
  static bool isSpace (const char c);

  // Return true if the string consists only of spaces.
  static bool onlySpaces (const char *);

  // Return true if the two strings differ not only in spaces.
  static bool effectivelyDifferent (const char *, const char *);

  // Build a string from a unit.
  static char *buildString (Unit *);

  // Duplicate a string
  static char *dup (const char *);
  static char *dup (const char *, int);

  // Calculate a hash for a string
  static unsigned int hash (const char *);
  static unsigned int hash (const char *, int);
};


} // namespace Puma

#endif /* __str_col__ */
