/*
 * This file was automatically generated by EvoSuite
 * Fri Jan 12 16:16:47 GMT 2018
 */

package uk.ac.sanger.artemis.plot;

import org.junit.Test;
import static org.junit.Assert.*;
import static org.evosuite.runtime.EvoAssertions.*;
import java.awt.Color;
import java.awt.Graphics;
import javax.swing.JLayeredPane;
import org.biojava.bio.symbol.DoubleAlphabet;
import org.biojava.bio.symbol.SymbolList;
import org.evosuite.runtime.EvoRunner;
import org.evosuite.runtime.EvoRunnerParameters;
import org.junit.runner.RunWith;
import uk.ac.sanger.artemis.io.BioJavaSequence;
import uk.ac.sanger.artemis.io.EmblStreamSequence;
import uk.ac.sanger.artemis.io.GenbankStreamSequence;
import uk.ac.sanger.artemis.io.PartialSequence;
import uk.ac.sanger.artemis.io.Sequence;
import uk.ac.sanger.artemis.plot.NcAlgorithm;
import uk.ac.sanger.artemis.sequence.Bases;
import uk.ac.sanger.artemis.sequence.Strand;

@RunWith(EvoRunner.class) @EvoRunnerParameters(mockJVMNonDeterminism = true, useVFS = true, useVNET = true, resetStaticState = true, separateClassLoader = true, useJEE = true) 
public class NcAlgorithm_ESTest extends NcAlgorithm_ESTest_scaffolding {

  @Test(timeout = 4000)
  public void test00()  throws Throwable  {
      GenbankStreamSequence genbankStreamSequence0 = new GenbankStreamSequence("gcC%");
      Bases bases0 = new Bases(genbankStreamSequence0);
      Strand strand0 = bases0.getReverseStrand();
      NcAlgorithm ncAlgorithm0 = new NcAlgorithm(strand0);
      float[] floatArray0 = new float[4];
      // Undeclared exception!
      try { 
        ncAlgorithm0.getValues(1001, 0, floatArray0);
        fail("Expecting exception: Error");
      
      } catch(Error e) {
         //
         // internal error - unexpected exception: org.evosuite.runtime.mock.java.lang.MockThrowable: start: 4 > end: -996
         //
         verifyException("uk.ac.sanger.artemis.plot.NcAlgorithm", e);
      }
  }

  @Test(timeout = 4000)
  public void test01()  throws Throwable  {
      EmblStreamSequence emblStreamSequence0 = new EmblStreamSequence("~KL1E\"4?rzM2U9'j<");
      Bases bases0 = new Bases(emblStreamSequence0);
      Strand strand0 = bases0.getForwardStrand();
      NcAlgorithm ncAlgorithm0 = new NcAlgorithm(strand0);
      float[] floatArray0 = new float[0];
      // Undeclared exception!
      try { 
        ncAlgorithm0.getValues((-5), 0, floatArray0);
        fail("Expecting exception: ArrayIndexOutOfBoundsException");
      
      } catch(ArrayIndexOutOfBoundsException e) {
         //
         // 0
         //
         verifyException("uk.ac.sanger.artemis.plot.NcAlgorithm", e);
      }
  }

  @Test(timeout = 4000)
  public void test02()  throws Throwable  {
      NcAlgorithm ncAlgorithm0 = null;
      try {
        ncAlgorithm0 = new NcAlgorithm((Strand) null);
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("uk.ac.sanger.artemis.plot.NcAlgorithm", e);
      }
  }

  @Test(timeout = 4000)
  public void test03()  throws Throwable  {
      GenbankStreamSequence genbankStreamSequence0 = new GenbankStreamSequence("gcC%");
      Bases bases0 = new Bases(genbankStreamSequence0);
      Strand strand0 = bases0.getReverseStrand();
      NcAlgorithm ncAlgorithm0 = new NcAlgorithm(strand0);
      Integer integer0 = ncAlgorithm0.getDefaultStepSize(1638);
      assertNotNull(integer0);
      assertEquals(24, (int)integer0);
      assertTrue(ncAlgorithm0.scalingFlag());
      assertEquals("Reverse Effective Codon Number(Nc)", ncAlgorithm0.getAlgorithmName());
  }

  @Test(timeout = 4000)
  public void test04()  throws Throwable  {
      EmblStreamSequence emblStreamSequence0 = new EmblStreamSequence("~KL1E\"4?rzM2U9'j<");
      Bases bases0 = new Bases(emblStreamSequence0);
      Strand strand0 = bases0.getForwardStrand();
      NcAlgorithm ncAlgorithm0 = new NcAlgorithm(strand0);
      Integer integer0 = ncAlgorithm0.getDefaultStepSize(2);
      assertTrue(ncAlgorithm0.scalingFlag());
      assertNull(integer0);
      assertEquals("Effective Codon Number(Nc)", ncAlgorithm0.getAlgorithmName());
  }

  @Test(timeout = 4000)
  public void test05()  throws Throwable  {
      GenbankStreamSequence genbankStreamSequence0 = new GenbankStreamSequence("gcC%");
      Bases bases0 = new Bases(genbankStreamSequence0);
      Strand strand0 = bases0.getReverseStrand();
      NcAlgorithm ncAlgorithm0 = new NcAlgorithm(strand0);
      Integer integer0 = ncAlgorithm0.getDefaultMinWindowSize();
      assertEquals("Reverse Effective Codon Number(Nc)", ncAlgorithm0.getAlgorithmName());
      assertTrue(ncAlgorithm0.scalingFlag());
      assertNotNull(integer0);
      assertEquals(24, (int)integer0);
  }

  @Test(timeout = 4000)
  public void test06()  throws Throwable  {
      GenbankStreamSequence genbankStreamSequence0 = new GenbankStreamSequence("gcC%");
      Bases bases0 = new Bases(genbankStreamSequence0);
      Strand strand0 = bases0.getReverseStrand();
      NcAlgorithm ncAlgorithm0 = new NcAlgorithm(strand0);
      Integer integer0 = ncAlgorithm0.getDefaultMaxWindowSize();
      assertEquals(5000, (int)integer0);
      assertTrue(ncAlgorithm0.scalingFlag());
      assertEquals("Reverse Effective Codon Number(Nc)", ncAlgorithm0.getAlgorithmName());
      assertNotNull(integer0);
  }

  @Test(timeout = 4000)
  public void test07()  throws Throwable  {
      Bases bases0 = new Bases((Sequence) null);
      Strand strand0 = bases0.getForwardStrand();
      NcAlgorithm ncAlgorithm0 = new NcAlgorithm(strand0);
      Integer integer0 = ncAlgorithm0.getDefaultWindowSize();
      assertEquals("Effective Codon Number(Nc)", ncAlgorithm0.getAlgorithmName());
      assertNotNull(integer0);
      assertEquals(500, (int)integer0);
      assertTrue(ncAlgorithm0.scalingFlag());
  }

  @Test(timeout = 4000)
  public void test08()  throws Throwable  {
      GenbankStreamSequence genbankStreamSequence0 = new GenbankStreamSequence("gcC%");
      Bases bases0 = new Bases(genbankStreamSequence0);
      Strand strand0 = bases0.getReverseStrand();
      NcAlgorithm ncAlgorithm0 = new NcAlgorithm(strand0);
      float[] floatArray0 = new float[4];
      ncAlgorithm0.getValues((-5), 2, floatArray0);
      assertEquals("Reverse Effective Codon Number(Nc)", ncAlgorithm0.getAlgorithmName());
      assertTrue(ncAlgorithm0.scalingFlag());
  }

  @Test(timeout = 4000)
  public void test09()  throws Throwable  {
      GenbankStreamSequence genbankStreamSequence0 = new GenbankStreamSequence("gcC%");
      Bases bases0 = new Bases(genbankStreamSequence0);
      Strand strand0 = bases0.getReverseStrand();
      NcAlgorithm ncAlgorithm0 = new NcAlgorithm(strand0);
      Float float0 = ncAlgorithm0.getMaximumInternal();
      assertEquals("Reverse Effective Codon Number(Nc)", ncAlgorithm0.getAlgorithmName());
      assertEquals(1.0E7F, (float)float0, 0.01F);
      assertTrue(ncAlgorithm0.scalingFlag());
  }

  @Test(timeout = 4000)
  public void test10()  throws Throwable  {
      char[] charArray0 = new char[9];
      Short short0 = new Short((short)660);
      Integer integer0 = JLayeredPane.PALETTE_LAYER;
      PartialSequence partialSequence0 = new PartialSequence(charArray0, 99, 4096, short0, integer0);
      Bases bases0 = new Bases(partialSequence0);
      Strand strand0 = bases0.getReverseStrand();
      NcAlgorithm ncAlgorithm0 = new NcAlgorithm(strand0);
      Color[] colorArray0 = new Color[6];
      ncAlgorithm0.drawLegend((Graphics) null, 4096, 4096, colorArray0);
      assertTrue(ncAlgorithm0.scalingFlag());
      assertEquals("Reverse Effective Codon Number(Nc)", ncAlgorithm0.getAlgorithmName());
  }

  @Test(timeout = 4000)
  public void test11()  throws Throwable  {
      GenbankStreamSequence genbankStreamSequence0 = new GenbankStreamSequence("gcC%");
      Bases bases0 = new Bases(genbankStreamSequence0);
      Strand strand0 = bases0.getReverseStrand();
      NcAlgorithm ncAlgorithm0 = new NcAlgorithm(strand0);
      ncAlgorithm0.getAverage();
      assertTrue(ncAlgorithm0.scalingFlag());
      assertEquals("Reverse Effective Codon Number(Nc)", ncAlgorithm0.getAlgorithmName());
  }

  @Test(timeout = 4000)
  public void test12()  throws Throwable  {
      EmblStreamSequence emblStreamSequence0 = new EmblStreamSequence("Nc");
      Bases bases0 = new Bases(emblStreamSequence0);
      Strand strand0 = bases0.getForwardStrand();
      NcAlgorithm ncAlgorithm0 = new NcAlgorithm(strand0);
      int int0 = ncAlgorithm0.getValueCount();
      assertEquals(3, int0);
      assertTrue(ncAlgorithm0.scalingFlag());
      assertEquals("Effective Codon Number(Nc)", ncAlgorithm0.getAlgorithmName());
  }

  @Test(timeout = 4000)
  public void test13()  throws Throwable  {
      GenbankStreamSequence genbankStreamSequence0 = new GenbankStreamSequence("gcC%");
      Bases bases0 = new Bases(genbankStreamSequence0);
      Strand strand0 = bases0.getReverseStrand();
      NcAlgorithm ncAlgorithm0 = new NcAlgorithm(strand0);
      Float float0 = ncAlgorithm0.getMinimumInternal();
      assertTrue(ncAlgorithm0.scalingFlag());
      assertEquals(0.0F, (float)float0, 0.01F);
      assertEquals("Reverse Effective Codon Number(Nc)", ncAlgorithm0.getAlgorithmName());
  }

  @Test(timeout = 4000)
  public void test14()  throws Throwable  {
      SymbolList symbolList0 = DoubleAlphabet.fromArray((double[]) null);
      BioJavaSequence bioJavaSequence0 = new BioJavaSequence(symbolList0);
      Bases bases0 = new Bases(bioJavaSequence0);
      Strand strand0 = bases0.getForwardStrand();
      NcAlgorithm ncAlgorithm0 = new NcAlgorithm(strand0);
      float[] floatArray0 = new float[8];
      // Undeclared exception!
      try { 
        ncAlgorithm0.getValues((-2898), 1, floatArray0);
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("org.biojava.bio.symbol.DoubleAlphabet$DoubleArray", e);
      }
  }
}
