package Argus::Archive;
#
###########################################################################
###########################################################################

use Argus;
use vars qw($OS %Lang %Curr %Cnf);

###########################################################################

require 2.00;
require Exporter;
@ISA = qw(Exporter);
@EXPORT = qw(
   Argus_Get_File_List
);

use strict;
use integer;
use Carp;

use IO::File;
use Date::Manip;

Date_Init("DateFormat = NONUS");  #change to US for mm/dd

use vars qw($VERSION);
$VERSION="2.00";

########################################################################
########################################################################

$Curr{"InitLang"}      = 1;     # Whether a language is being init'ed
$Curr{"InitFilesRead"} = 0;
$Curr{"ResetWorkDay"}  = 1;
$Curr{"Debug"}         = "";
$Curr{"DebugVal"}      = "";


########################################################################
########################################################################
# THESE ARE THE MAIN ROUTINES
########################################################################
########################################################################

# Get rid of a problem with old versions of perl
no strict "vars";
# This sorts from longest to shortest element
sub sortByLength {
  return (length $b <=> length $a);
}
use strict "vars";

sub ArgusArchiveVersion {
  print "DEBUG: ArgusArchiveVersion\n"  if ($Curr{"Debug"} =~ /trace/);
  return $VERSION;
}

sub Archive_Init {
  print "DEBUG: Archive_Init\n"  if ($Curr{"Debug"} =~ /trace/);
  $Curr{"Debug"}="";

  my(@args)=@_;
  $Curr{"InitDone"}=1;
}

########################################################################
#
# Argus::Archive.Get_Archive_Directory
# 
# The strategy will be to look to see if $ARGUSHOME/data/achive
# or @arg/data/archive exists.  If so then we've got our dir.
#
# This need work, obviously.
#

sub Get_Archive_Directory {

   my ($start) = @_;
   my $archive;

   if( ! defined $Argus::Archive_root ) {
      if( ! defined $start ) {
         $start=$ENV{ARGUSARCHIVE};
         if( ! defined $start ) {
            $start = "/usr/local/argus";
         }
      }

      if ( -d $start ) {
         $archive="$start";
      }
   } else {
      $archive="$Argus::Archive_root";
   }

   return $archive;
}

########################################################################
#
# Argus::Archive::Set_Archive_Directory
# 
# Override paths set in Argus.pm
#

sub Set_Archive_Directory {

   my ($start) = @_;

   if( -d "$start" ) {
       $Argus::Archive_root = $start;
       return 1;
   } else {
       warn "'$start' is not a directory";
       return 0;
   }
}


########################################################################
#
# Argus::Archive::Get_File_List
#
# Takes two dates or a special period names and returns a list of
# argus archive files (in time order) that cover the period
#
# So far, this routine takes the start date and looks in
# ArgusArchiveDir/YYYY/mm/dd and grabs all the files there.
# 
# If give a time range, it should return all the files between
# the two dates.
#
# This needs work. cb
#

sub Get_File_List {
    my ($first, $last ) = @_;
    my @files;

    my ( $sdate, $fdate);

    my $today = ParseDate('today');

    if( ! defined $first ) {
        printf "No start date given";
        return undef;
    }

    if ( $first eq 'thisweek' ){
        $sdate = Date_GetPrev($today, 'Mon', 1);
        $fdate =  $today;
    } elsif(  $first eq 'thismonth' ){
        $sdate = ParseDate('1st');
        $fdate = ParseDate('today') ;
        $fdate = Date_SetTime($fdate, '23:59:59');
    } elsif(  $first eq 'lastweek' ){
        $fdate = Date_GetPrev($today, 'Mon', 1);
        $sdate =  Date_GetPrev($fdate, 'Mon', 0);
    } elsif(  $first eq 'lastmonth' ){
        $fdate = ParseDate('1st');
        $sdate =  DateCalc($fdate, '- 1 month');
    } else {
        $sdate =ParseDate($first);
        printf  "Invalid date '$first'" if ! $sdate;

        if( defined $last ) {
            $fdate =ParseDate($last);
            printf  "Invalid finish date '$last'" if ! $fdate;
        } else {
            $fdate = $sdate;
        }
    }

   for (my $date=Date_SetTime($sdate, '00:00:00');

   $date le $fdate; $date=DateCalc($date, '+ 1 day')) {

      my $target = "$Argus::Archive_root/" . UnixDate($date, $Argus::Archive_dir_template); 

      if( -d $target ) { 
         if( opendir(DIR, $target) ) {
            foreach my $f ( sort grep(/$Argus::Archive_file_template/, 
                           readdir(DIR))){
               push(@files, "$target/$f");
            }
         }
         closedir(DIR);
      } else {
         printf "Argus::Archive: Failed to open '$target':$!";
         return undef;
      }
   }

   return @files;
}
1;

