/*
 * Decompiled with CFR 0.152.
 */
package android.databinding.tool.expr;

import android.databinding.tool.expr.Dependency;
import android.databinding.tool.expr.Expr;
import android.databinding.tool.expr.StaticIdentifierExpr;
import android.databinding.tool.reflection.Callable;
import android.databinding.tool.reflection.ModelAnalyzer;
import android.databinding.tool.reflection.ModelClass;
import android.databinding.tool.util.L;
import java.util.List;

public class FieldAccessExpr
extends Expr {
    String mName;
    Callable mGetter;
    final boolean mIsObservableField;

    FieldAccessExpr(Expr parent, String name) {
        super(parent);
        this.mName = name;
        this.mIsObservableField = false;
    }

    FieldAccessExpr(Expr parent, String name, boolean isObservableField) {
        super(parent);
        this.mName = name;
        this.mIsObservableField = isObservableField;
    }

    public Expr getChild() {
        return this.getChildren().get(0);
    }

    public Callable getGetter() {
        if (this.mGetter == null) {
            this.getResolvedType();
        }
        return this.mGetter;
    }

    @Override
    public boolean isDynamic() {
        if (this.mGetter == null) {
            this.getResolvedType();
        }
        if (this.mGetter.type != Callable.Type.FIELD) {
            return true;
        }
        if (this.getChild().isDynamic()) {
            return !this.mGetter.isStatic() || this.mGetter.isDynamic();
        }
        return this.mGetter.isDynamic();
    }

    @Override
    protected List<Dependency> constructDependencies() {
        List<Dependency> dependencies = this.constructDynamicChildrenDependencies();
        for (Dependency dependency : dependencies) {
            if (dependency.getOther() != this.getChild()) continue;
            dependency.setMandatory(true);
        }
        return dependencies;
    }

    @Override
    protected String computeUniqueKey() {
        if (this.mIsObservableField) {
            return sUniqueKeyJoiner.join(this.mName, "..", super.computeUniqueKey());
        }
        return sUniqueKeyJoiner.join(this.mName, ".", super.computeUniqueKey());
    }

    public String getName() {
        return this.mName;
    }

    @Override
    public void updateExpr(ModelAnalyzer modelAnalyzer) {
        this.resolveType(modelAnalyzer);
        super.updateExpr(modelAnalyzer);
    }

    @Override
    protected ModelClass resolveType(ModelAnalyzer modelAnalyzer) {
        if (this.mGetter == null) {
            Expr child = this.getChild();
            child.resolveType(modelAnalyzer);
            boolean isStatic = child instanceof StaticIdentifierExpr;
            ModelClass resolvedType = child.getResolvedType();
            L.d("resolving %s. Resolved class type: %s", this, resolvedType);
            this.mGetter = resolvedType.findGetterOrField(this.mName, isStatic);
            if (this.mGetter.resolvedType.isObservableField()) {
                child.getParents().remove(this);
                this.getChildren().remove(child);
                FieldAccessExpr observableField = this.getModel().observableField(child, this.mName);
                observableField.mGetter = this.mGetter;
                this.getChildren().add(observableField);
                observableField.getParents().add(this);
                this.mGetter = this.mGetter.resolvedType.findGetterOrField("get", false);
                this.mName = "";
            }
        }
        return this.mGetter.resolvedType;
    }

    @Override
    protected String asPackage() {
        String parentPackage = this.getChild().asPackage();
        return parentPackage == null ? null : parentPackage + "." + this.mName;
    }
}

