; Documentation for the ACL2 Theorem Prover
; WARNING: GENERATED FILE, DO NOT HAND EDIT!
; The contents of this file are derived from ACL2 Community Book
; books/system/doc/acl2-doc.lisp.

; ACL2 Version 8.5 -- A Computational Logic for Applicative Common Lisp
; Copyright (C) 2022, Regents of the University of Texas

; This version of ACL2 is a descendent of ACL2 Version 1.9, Copyright
; (C) 1997 Computational Logic, Inc.  See the documentation topic NOTE-2-0.

; This program is free software; you can redistribute it and/or modify
; it under the terms of the LICENSE file distributed with ACL2.

; This program is distributed in the hope that it will be useful,
; but WITHOUT ANY WARRANTY; without even the implied warranty of
; MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
; LICENSE for more details.

; Here are the original authors of books/system/doc/acl2-doc.lisp.
; Additional contributions may have been made to that file by members
; of the ACL2 community.

; Written by:  Matt Kaufmann               and J Strother Moore
; email:       Kaufmann@cs.utexas.edu      and Moore@cs.utexas.edu
; Department of Computer Science
; University of Texas at Austin
; Austin, TX 78701 U.S.A.

; WARNING: This file is generated from ACL2 Community Book
; books/system/doc/acl2-doc.lisp.  To edit ACL2 documentation modify
; that file, not this one!  Instructions are just above the in-package
; form in that book.

(in-package "ACL2")

(defconst *acl2-system-documentation* '
((&ALLOW-OTHER-KEYS (POINTERS)
                    "See [macro-args].")
 (&BODY (POINTERS) "See [macro-args].")
 (&KEY (POINTERS) "See [macro-args].")
 (&OPTIONAL (POINTERS)
            "See [macro-args].")
 (&REST (POINTERS) "See [macro-args].")
 (&WHOLE (POINTERS) "See [macro-args].")
 (*
  (NUMBERS ACL2-BUILT-INS)
  "Multiplication macro

  * is really a macro that expands to calls of the function [binary-*].
  So for example

    (* x y 4 z)

  represents the same term as

    (binary-* x (binary-* y (binary-* 4 z))).

  See [binary-*].

  * is a Common Lisp function.  See any Common Lisp documentation for
  more information.


Subtopics

  [Binary-*]
      Multiplication function")
 (*ACL2-EXPORTS*
  (PACKAGES ACL2-BUILT-INS)
  "Symbols that are often imported into new [packages] to provide easy
  access to ACL2 functionality.

  When you define a new package for your own work with [defpkg], you
  will usually want to import many symbols from the \"ACL2\" package;
  for instance you will usually want to be able to use symbols like
  [defthm], [in-theory], [xargs], [state], etc., without an acl2::
  prefix.

  The constant *acl2-exports* lists 1558 symbols, including most
  documented ACL2 system constants, functions, and macros.  You will
  typically also want to import many symbols from Common Lisp; see
  [*common-lisp-symbols-from-main-lisp-package*].

  Those who write code using built-in ACL2 functions (see
  [ACL2-built-ins]) may wish to import symbols into their package
  from the large list [*ACL2-system-exports*].

    (& &allow-other-keys &aux &body &key
       &optional &rest &whole * *acl2-exports*
       *common-lisp-specials-and-constants*
       *common-lisp-symbols-from-main-lisp-package*
       *main-lisp-package-name*
       *standard-chars* *standard-ci*
       *standard-co* *standard-oi*
       + - / /= 1+ 1- 32-bit-integer-listp
       32-bit-integer-listp-forward-to-integer-listp
       32-bit-integer-stack
       32-bit-integer-stack-length
       32-bit-integer-stack-length1
       32-bit-integerp
       32-bit-integerp-forward-to-integerp
       < <-on-others
       <= = > >= ?-fn @ a! abort! abort-soft
       abs access accumulated-persistence
       accumulated-persistence-oops
       acl2-count acl2-input-channel-package
       acl2-number-listp acl2-numberp
       acl2-oracle acl2-output-channel-package
       acl2-package acl2-unwind-protect
       acons active-or-non-runep active-runep
       add-binop add-custom-keyword-hint
       add-default-hints
       add-default-hints! add-include-book-dir
       add-include-book-dir!
       add-invisible-fns add-ld-keyword-alias
       add-ld-keyword-alias!
       add-macro-alias add-macro-fn
       add-match-free-override add-nth-alias
       add-override-hints add-override-hints!
       add-pair add-pair-preserves-all-boundp
       add-suffix add-suffix-to-fn add-timers
       add-to-set add-to-set-eq add-to-set-eql
       add-to-set-equal adjust-ld-history
       alistp alistp-forward-to-true-listp
       all-attachments
       all-boundp all-boundp-preserves-assoc
       all-vars all-vars1 all-vars1-lst
       allocate-fixnum-range alpha-char-p
       alpha-char-p-forward-to-characterp
       alphorder always$ always$+
       and and-macro append append$ append$+
       apply$ apply$-guard apply$-lambda
       apply$-lambda-guard apply$-userfn
       aref-32-bit-integer-stack aref-t-stack
       aref1 aref2 args arities-okp arity
       array1p array1p-cons array1p-forward
       array1p-linear array2p array2p-cons
       array2p-forward array2p-linear
       aset-32-bit-integer-stack aset-t-stack
       aset1 aset1-trusted aset2 ash assert$
       assert* assert-event assign assoc
       assoc-add-pair assoc-eq assoc-eq-equal
       assoc-eq-equal-alistp assoc-equal
       assoc-keyword assoc-string-equal assoc2
       associativity-of-* associativity-of-+
       assume atom atom-listp
       atom-listp-forward-to-true-listp
       backchain-limit badge badge-userfn
       big-clock-entry big-clock-negative-p
       binary-* binary-+ binary-append
       bind-free bit bitp boole$ boolean-listp
       boolean-listp-cons boolean-listp-forward
       boolean-listp-forward-to-symbol-listp
       booleanp booleanp-characterp
       booleanp-compound-recognizer
       bounded-integer-alistp
       bounded-integer-alistp-forward-to-eqlable-alistp
       bounded-integer-alistp2
       boundp-global boundp-global1 break$
       break-on-error brr brr-evisc-tuple
       brr@ build-state1 butlast
       caaaar caaadr caaar caadar caaddr
       caadr caar cadaar cadadr cadar caddar
       cadddr caddr cadr canonical-pathname
       car car-cdr-elim car-cons case
       case-list case-list-check case-match
       case-split case-split-limitations
       case-test cbd cdaaar cdaadr
       cdaar cdadar cdaddr cdadr cdar cddaar
       cddadr cddar cdddar cddddr cdddr cddr
       cdr cdr-cons cdrn ceiling certify-book
       certify-book! change char char-code
       char-code-code-char-is-identity
       char-code-linear char-downcase
       char-equal char-upcase char< char<=
       char> char>= character character-alistp
       character-listp character-listp-append
       character-listp-coerce
       character-listp-forward-to-eqlable-listp
       character-listp-remove-duplicates-eql
       character-listp-revappend
       character-listp-string-downcase-1
       character-listp-string-upcase1-1
       characterp characterp-char-downcase
       characterp-char-upcase characterp-nth
       characterp-page characterp-return
       characterp-rubout characterp-tab
       check-invariant-risk check-vars-not-free
       checkpoint-forced-goals
       checkpoint-summary-limit
       clause clear-memoize-statistics
       clear-memoize-table clear-memoize-tables
       close-input-channel close-output-channel
       close-trace-file closure code-char
       code-char-char-code-is-identity
       code-char-type coerce coerce-inverse-1
       coerce-inverse-2 coerce-object-to-state
       coerce-state-to-object
       collect$ collect$+ comment
       community-books commutativity-of-*
       commutativity-of-+ comp completion-of-*
       completion-of-+ completion-of-<
       completion-of-car completion-of-cdr
       completion-of-char-code
       completion-of-code-char
       completion-of-coerce
       completion-of-complex
       completion-of-denominator
       completion-of-imagpart
       completion-of-intern-in-package-of-symbol
       completion-of-numerator
       completion-of-realpart
       completion-of-symbol-name
       completion-of-symbol-package-name
       completion-of-unary-/
       completion-of-unary-minus
       complex complex-0
       complex-definition complex-equal
       complex-implies1 complex-rationalp
       complex/complex-rationalp
       compress1 compress11 compress2
       compress21 compress211 concatenate
       cond cond-clausesp cond-macro
       conjugate cons cons-equal cons-subtrees
       cons-with-hint consp consp-assoc-equal
       constraint-info corollary count-keys
       cpu-core-count ctx ctxp current-package
       current-theory cw cw! cw!+ cw+ cw-gstack
       cw-print-base-radix cw-print-base-radix!
       d< declare decrement-big-clock defabbrev
       defabsstobj defabsstobj-missing-events
       defattach defattach-system
       default default-*-1 default-*-2
       default-+-1 default-+-2 default-<-1
       default-<-2 default-backchain-limit
       default-car default-cdr
       default-char-code default-coerce-1
       default-coerce-2 default-coerce-3
       default-compile-fns default-complex-1
       default-complex-2 default-defun-mode
       default-defun-mode-from-state
       default-denominator
       default-hints default-imagpart
       default-measure-function
       default-numerator default-print-prompt
       default-realpart default-ruler-extenders
       default-state-vars default-symbol-name
       default-symbol-package-name
       default-total-parallelism-work-limit
       default-unary-/ default-unary-minus
       default-verify-guards-eagerness
       default-well-founded-relation
       defaxiom defbadge defchoose defcong
       defconst defequiv defevaluator defexec
       define-pc-atomic-macro define-pc-help
       define-pc-macro define-pc-meta
       define-trusted-clause-processor
       deflabel deflock defmacro
       defmacro-last defmacro-untouchable
       defn defnd defpkg defproxy defrec
       defrefinement defstobj defstub deftheory
       deftheory-static defthm defthm-std
       defthmd defthy defttag defun defun$
       defun-inline defun-notinline defun-nx
       defun-sk defun-std defund defund-inline
       defund-notinline defund-nx defuns
       defuns-std defwarrant delete-assoc
       delete-assoc-eq delete-assoc-equal
       delete-file$ delete-include-book-dir
       delete-include-book-dir!
       denominator digit-char-p digit-to-char
       dimensions disable disable-forcing
       disable-immediate-force-modep
       disable-ubt disabledp disassemble$
       distributivity dmr-start dmr-stop do$
       doc doc! docs doppelganger-apply$-userfn
       doppelganger-badge-userfn double-rewrite
       doublet-listp dumb-occur dumb-occur-var
       duplicates e/d e0-ord-< e0-ordinalp
       ec-call eighth eliminate-destructors
       eliminate-irrelevance
       enable enable-forcing
       enable-immediate-force-modep
       encapsulate endp eq eql eqlable-alistp
       eqlable-alistp-forward-to-alistp
       eqlable-listp
       eqlable-listp-forward-to-atom-listp
       eqlablep
       eqlablep-recog equal equal-char-code
       er er-cmp er-let* er-let*-cmp er-progn
       er-progn-cmp er-progn-fn er-progn-fn@par
       er-progn@par er-soft er-soft-logic ev$
       ev$-list evenp evens event evisc-tuple
       executable-counterpart-theory
       exists exit explode-atom
       explode-nonnegative-integer expt
       expt-type-prescription-non-zero-base
       extend-32-bit-integer-stack
       extend-pe-table
       extend-t-stack extend-world
       extra-info f-boundp-global f-get-global
       f-put-global fast-alist-clean
       fast-alist-clean! fast-alist-fork
       fast-alist-fork! fast-alist-free
       fast-alist-free-on-exit fast-alist-len
       fast-alist-summary fc-report fertilize
       fgetprop fifth file-clock file-clock-p
       file-clock-p-forward-to-integerp
       file-length$
       file-write-date$ finalize-event-user
       first first-n-ac fix fix-pkg
       fix-true-list flet floor flush-compress
       flush-hons-get-hash-table-link fms fms!
       fms!-to-string fms-to-string fmt fmt!
       fmt!-to-string fmt-hard-right-margin
       fmt-soft-right-margin
       fmt-to-comment-window
       fmt-to-comment-window!
       fmt-to-comment-window!+
       fmt-to-comment-window+
       fmt-to-string fmt1
       fmt1! fmt1!-to-string fmt1-to-string
       fmx fmx!-cw fmx-cw fn-equal
       fncall-term forall force formula
       fourth function-symbolp function-theory
       gag-mode gc$ gc-strategy gc-verbose
       gcs generalize get-check-invariant-risk
       get-command-sequence get-defun-event
       get-enforce-redundancy get-event-data
       get-global get-guard-checking
       get-in-theory-redundant-okp
       get-output-stream-string$
       get-register-invariant-risk
       get-serialize-character
       get-slow-alist-action get-timer
       get-wormhole-status getenv$ getprop
       getprop-default getpropc getprops
       getprops1 global-table global-table-cars
       global-table-cars1 global-val
       good-atom-listp good-bye granularity
       ground-zero gthm guard guard-obligation
       guard-theorem hard-error
       has-propsp has-propsp1 header help
       hide hist hons hons-acons hons-acons!
       hons-assoc-equal hons-clear hons-clear!
       hons-copy hons-copy-persistent
       hons-equal hons-equal-lite
       hons-get hons-resize hons-resize-fn
       hons-shrink-alist hons-shrink-alist!
       hons-summary hons-wash
       hons-wash! i-am-here i-close i-large
       i-limited i-small id idates identity
       if if* iff iff-implies-equal-implies-1
       iff-implies-equal-implies-2
       iff-implies-equal-not
       iff-is-an-equivalence ifix ignorable
       ignore illegal imagpart imagpart-complex
       immediate-force-modep implies
       improper-consp in-arithmetic-theory
       in-package in-tau-intervalp
       in-theory include-book incompatible
       incompatible! increment-timer
       induct induction-depth-limit
       initialize-event-user
       int= integer integer-0 integer-1
       integer-abs integer-implies-rational
       integer-length integer-listp
       integer-listp-forward-to-rational-listp
       integer-range-p
       integer-step integerp intern
       intern$ intern-in-package-of-symbol
       intern-in-package-of-symbol-symbol-name
       intersection$
       intersection-eq intersection-equal
       intersection-theories intersectp
       intersectp-eq intersectp-equal
       inverse-of-* inverse-of-+
       invisible-fns-table irrelevant
       keyword-package keyword-value-listp
       keyword-value-listp-assoc-keyword
       keyword-value-listp-forward-to-true-listp
       keywordp keywordp-forward-to-symbolp
       known-package-alist known-package-alistp
       known-package-alistp-forward-to-true-list-listp-and-alistp
       kwote kwote-lst l< lambda lambda$ last
       last-prover-steps ld ld-error-action
       ld-error-triples ld-evisc-tuple
       ld-history ld-history-entry-error-flg
       ld-history-entry-input
       ld-history-entry-stobjs-out
       ld-history-entry-stobjs-out/value
       ld-history-entry-user-data
       ld-history-entry-value
       ld-keyword-aliases
       ld-missing-input-ok ld-post-eval-print
       ld-pre-eval-filter ld-pre-eval-print
       ld-prompt ld-query-control-alist
       ld-redefinition-action ld-skip-proofsp
       ld-verbose legal-case-clausesp
       len len-update-nth length let
       let* let-mbe lex-fix lexorder lexp list
       list* list*-macro list-all-package-names
       list-all-package-names-lst
       list-macro listp local logand
       logandc1 logandc2 logbitp logcount
       logeqv logic logic-fns-list-listp
       logic-fns-listp logic-fnsp
       logic-term-list-listp logic-term-listp
       logic-termp logior lognand lognor lognot
       logorc1 logorc2 logtest logxor loop$
       lower-case-p lower-case-p-char-downcase
       lower-case-p-forward-to-alpha-char-p
       lowest-terms lp
       macro-aliases macro-args magic-ev-fncall
       main-timer main-timer-type-prescription
       make make-character-list
       make-character-list-make-character-list
       make-event
       make-fast-alist make-fmt-bindings
       make-input-channel make-list
       make-list-ac make-mv-nths make-ord
       make-output-channel make-summary-data
       make-tau-interval make-var-lst
       make-var-lst1 make-wormhole-status
       makunbound-global max maximum-length
       may-need-slashes maybe-convert-to-mv
       maybe-flush-and-compress1
       mbe mbt mbt* member member-eq
       member-equal member-symbol-name
       memoize memoize-partial memoize-summary
       memsum meta-extract-contextual-fact
       meta-extract-formula
       meta-extract-global-fact
       meta-extract-global-fact+
       meta-extract-rw+-term mfc mfc-ancestors
       mfc-ap mfc-clause mfc-rdepth
       mfc-relieve-hyp mfc-rw mfc-rw+ mfc-ts
       mfc-type-alist mfc-unify-subst mfc-world
       min minimal-theory minusp mod mod-expt
       monitor monitor! monitored-runes more
       more! more-doc msg msgp must-be-equal
       mutual-recursion mutual-recursion-guardp
       mv mv-let mv-list mv-nth mv? mv?-let
       nat-listp natp near-misses needs-slashes
       never-memoize newline nfix nfix-list nil
       nil-is-not-circular ninth no-duplicatesp
       no-duplicatesp-eq no-duplicatesp-equal
       non-exec nonnegative-integer-quotient
       nonnegative-product nonzero-imagpart
       not nqthm-to-acl2 nth nth-0-cons
       nth-0-read-run-time-type-prescription
       nth-add1 nth-aliases nth-update-nth
       nthcdr null number-subtrees numerator
       o-finp o-first-coeff o-first-expt o-infp
       o-p o-rst o< o<= o> o>= observation
       observation-cw oddp odds ok-if
       oops open-channel-listp open-channel1
       open-channel1-forward-to-true-listp-and-consp
       open-channels-p open-channels-p-forward
       open-input-channel
       open-input-channel-any-p
       open-input-channel-any-p1
       open-input-channel-p
       open-input-channel-p1
       open-input-channels
       open-output-channel open-output-channel!
       open-output-channel-any-p
       open-output-channel-any-p1
       open-output-channel-p
       open-output-channel-p1
       open-output-channels
       open-trace-file optimize
       or or-macro ordered-symbol-alistp
       ordered-symbol-alistp-add-pair
       ordered-symbol-alistp-add-pair-forward
       ordered-symbol-alistp-forward-to-symbol-alistp
       ordered-symbol-alistp-getprops
       ordered-symbol-alistp-remove1-assoc-eq
       otherwise our-digit-char-p
       override-hints p! pairlis$
       pairlis2 pand pargs partial-encapsulate
       partition-rest-and-keyword-args
       pbt pc pcb pcb!
       pcs pe pe! peek-char$ pf pkg-imports
       pkg-witness pl pl2 plet plist-worldp
       plist-worldp-forward-to-assoc-eq-equal-alistp
       plusp pointers pop-timer por position
       position-ac position-eq position-eq-ac
       position-equal position-equal-ac
       positive posp power-eval pprogn pr
       pr! preprocess prin1$ prin1-with-slashes
       prin1-with-slashes1 princ$ print-base-p
       print-cl-cache print-gv print-object$
       print-object$+ print-object$-fn
       print-object$-preserving-case
       print-rational-as-decimal
       print-timer profile
       prog2$ progn progn! progn$ program
       proof-tree proofs-co proper-consp
       props prove pseudo-term-listp
       pseudo-term-listp-forward-to-true-listp
       pseudo-termp
       pso pso! psof psog pspv pstack
       puff puff* push-timer push-untouchable
       put-assoc put-assoc-eq put-assoc-eql
       put-assoc-equal put-global putprop
       quick-and-dirty-subsumption-replacement-step
       quit quote quotep
       quote~ r-eqlable-alistp r-symbol-alistp
       random$ rassoc rassoc-eq rassoc-equal
       ratio rational rational-implies1
       rational-implies2 rational-listp
       rational-listp-forward-to-true-listp
       rationalp rationalp-* rationalp-+
       rationalp-expt-type-prescription
       rationalp-implies-acl2-numberp
       rationalp-unary--
       rationalp-unary-/ read-acl2-oracle
       read-acl2-oracle-preserves-state-p1
       read-byte$ read-char$
       read-file-into-string read-file-listp
       read-file-listp-forward-to-true-list-listp
       read-file-listp1
       read-file-listp1-forward-to-true-listp-and-consp
       read-files read-files-p
       read-files-p-forward-to-read-file-listp
       read-idate
       read-object read-object-suppress
       read-object-with-case read-run-time
       read-run-time-preserves-state-p1
       readable-file
       readable-file-forward-to-true-listp-and-consp
       readable-files readable-files-listp
       readable-files-listp-forward-to-true-list-listp-and-alistp
       readable-files-p
       readable-files-p-forward-to-readable-files-listp
       real-listp
       real/rationalp realfix realpart
       realpart-complex realpart-imagpart-elim
       rebuild redef redef! redef+
       redef- redo-flat regenerate-tau-database
       rem remove remove-assoc
       remove-assoc-eq remove-assoc-equal
       remove-binop remove-custom-keyword-hint
       remove-default-hints
       remove-default-hints!
       remove-duplicates remove-duplicates-eq
       remove-duplicates-eql
       remove-duplicates-equal remove-eq
       remove-equal remove-guard-holders
       remove-invisible-fns
       remove-macro-alias remove-macro-fn
       remove-nth-alias remove-override-hints
       remove-override-hints!
       remove-untouchable remove1 remove1-assoc
       remove1-assoc-eq remove1-assoc-equal
       remove1-eq remove1-equal
       reset-fc-reporting reset-kill-ring
       reset-ld-specials reset-prehistory
       reset-print-control resize-list
       rest restore-memoization-settings
       retract-world
       retrieve return-last return-last-table
       revappend reverse revert-world
       rewrite-equiv rewrite-quoted-constant
       rewrite-stack-limit
       rfix round rw-cache satisfies
       save-and-clear-memoization-settings
       save-exec search second serialize-read
       serialize-write set-absstobj-debug
       set-accumulated-persistence
       set-backchain-limit
       set-bad-lisp-consp-memoize
       set-body set-bogus-defun-hints-ok
       set-bogus-measure-ok
       set-bogus-mutual-recursion-ok
       set-brr-evisc-tuple
       set-case-split-limitations
       set-cbd set-check-invariant-risk
       set-checkpoint-summary-limit
       set-compile-fns
       set-compiler-enabled set-debugger-enable
       set-default-backchain-limit
       set-default-hints set-default-hints!
       set-deferred-ttag-notes set-difference$
       set-difference-eq set-difference-equal
       set-difference-theories
       set-duplicate-keys-action
       set-duplicate-keys-action!
       set-enforce-redundancy
       set-equalp-equal set-evisc-tuple
       set-fc-criteria set-fc-report-on-the-fly
       set-fmt-hard-right-margin
       set-fmt-soft-right-margin set-gag-mode
       set-gc-strategy set-guard-checking
       set-guard-msg set-ignore-ok
       set-in-theory-redundant-okp
       set-induction-depth-limit
       set-induction-depth-limit!
       set-inhibit-er-soft set-inhibit-er-soft!
       set-inhibit-output-lst
       set-inhibit-warnings
       set-inhibit-warnings!
       set-inhibited-summary-types
       set-invisible-fns-table
       set-iprint set-irrelevant-formals-ok
       set-ld-keyword-aliases
       set-ld-keyword-aliases!
       set-ld-prompt set-ld-redefinition-action
       set-ld-skip-proofs
       set-ld-skip-proofsp set-let*-abstraction
       set-let*-abstractionp
       set-match-free-default
       set-match-free-error
       set-measure-function
       set-non-linear set-non-linearp
       set-override-hints set-override-hints!
       set-parallel-execution
       set-print-base set-print-base-radix
       set-print-case set-print-circle
       set-print-clause-ids set-print-escape
       set-print-gv-defaults set-print-length
       set-print-level set-print-lines
       set-print-radix set-print-readably
       set-print-right-margin
       set-prover-step-limit
       set-raw-mode set-raw-mode-on
       set-raw-mode-on! set-raw-proof-format
       set-raw-warning-format
       set-register-invariant-risk
       set-rewrite-stack-limit
       set-ruler-extenders
       set-rw-cache-state set-rw-cache-state!
       set-serialize-character
       set-serialize-character-system
       set-skip-meta-termp-checks
       set-skip-meta-termp-checks!
       set-slow-alist-action
       set-splitter-output set-state-ok
       set-tau-auto-mode set-temp-touchable-fns
       set-temp-touchable-vars set-timer
       set-total-parallelism-work-limit
       set-total-parallelism-work-limit-error
       set-trace-evisc-tuple
       set-verify-guards-eagerness
       set-w set-waterfall-parallelism
       set-waterfall-parallelism-hacks-enabled
       set-waterfall-parallelism-hacks-enabled!
       set-waterfall-printing
       set-well-founded-relation
       set-wormhole-data
       set-wormhole-entry-code
       set-write-acl2x setenv$ seventh sgetprop
       show-accumulated-persistence show-bdd
       show-bodies show-brr-evisc-tuple
       show-custom-keyword-hint-expansion
       show-fc-criteria
       shrink-32-bit-integer-stack
       shrink-t-stack signed-byte
       signed-byte-p signum simplify
       sixth skip-proofs sleep some-slashable
       spec-mv-let splitter-output
       stable-under-simplificationp
       standard-char standard-char-listp
       standard-char-listp-append
       standard-char-listp-forward-to-character-listp
       standard-char-p
       standard-char-p+ standard-char-p-nth
       standard-co standard-oi
       standard-part standard-string-alistp
       standard-string-alistp-forward-to-alistp
       standardp
       start-proof-tree state state-global-let*
       state-global-let*-cleanup
       state-global-let*-get-globals
       state-global-let*-put-globals state-p
       state-p-implies-and-forward-to-state-p1
       state-p1 state-p1-forward
       state-p1-update-main-timer
       state-p1-update-nth-2-world step-limit
       stobj-let stobj-table stop-proof-tree
       string string-append string-append-lst
       string-downcase string-downcase1
       string-equal string-equal1
       string-is-not-circular string-listp
       string-upcase string-upcase1
       string< string<-irreflexive
       string<-l string<-l-asymmetric
       string<-l-irreflexive
       string<-l-transitive
       string<-l-trichotomy
       string<= string> string>=
       stringp stringp-symbol-package-name
       strip-cars strip-cdrs sublis sublis-fn
       sublis-fn-lst-simple sublis-fn-simple
       subseq subseq-list subsequencep
       subsetp subsetp-eq subsetp-equal
       subst substitute substitute-ac
       suitably-tamep-listp sum$ sum$+
       summary swap-stobjs symbol symbol-alistp
       symbol-alistp-forward-to-eqlable-alistp
       symbol-doublet-listp
       symbol-equality symbol-listp
       symbol-listp-forward-to-true-listp
       symbol-name
       symbol-name-intern-in-package-of-symbol
       symbol-name-lst symbol-package-name
       symbol< symbol<-asymmetric
       symbol<-irreflexive symbol<-transitive
       symbol<-trichotomy symbolp
       symbolp-intern-in-package-of-symbol synp
       syntaxp sys-call sys-call* sys-call+
       sys-call-status t t-stack t-stack-length
       t-stack-length1 table table-alist
       take tamep tamep-functionp tamep-lambdap
       tau-data tau-database tau-interval-dom
       tau-interval-hi tau-interval-hi-rel
       tau-interval-lo tau-interval-lo-rel
       tau-intervalp tau-status tau-system
       tenth term-list-listp term-listp
       term-order termination-theorem termp
       the the-check the-fixnum the-fixnum!
       theory theory-invariant thereis$
       thereis$+ third thm time$ time-tracker
       time-tracker-tau timer-alistp
       timer-alistp-forward-to-true-list-listp-and-symbol-alistp
       toggle-inhibit-er-soft
       toggle-inhibit-er-soft!
       toggle-inhibit-warning
       toggle-inhibit-warning!
       toggle-pc-macro top-level
       trace! trace$ trace* trans trans!
       trans-eval trans-eval-default-warning
       trans-eval-no-warning
       trans1 translam translate-and-test
       trichotomy true-list-fix true-list-listp
       true-list-listp-forward-to-true-listp
       true-list-listp-forward-to-true-listp-assoc-equal
       true-listp
       true-listp-cadr-assoc-eq-for-open-channels-p
       true-listp-update-nth truncate trust-mfc
       ttag ttags-seen tthm type typed-io-listp
       typed-io-listp-forward-to-true-listp
       typespec-check u ubt ubt! ubt-prehistory
       ubt? ubu ubu! ubu? unary-- unary-/
       unary-function-symbol-listp unicity-of-0
       unicity-of-1 union$ union-eq union-equal
       union-theories universal-theory
       unmemoize unmonitor unquote
       unsave unsigned-byte unsigned-byte-p
       until$ until$+ untouchable-marker
       untrace$ untrans-table
       untranslate update-32-bit-integer-stack
       update-acl2-oracle
       update-acl2-oracle-preserves-state-p1
       update-big-clock-entry update-file-clock
       update-global-table update-idates
       update-list-all-package-names-lst
       update-nth update-nth-array
       update-open-input-channels
       update-open-output-channels
       update-read-files
       update-t-stack update-user-stobj-alist
       update-user-stobj-alist1
       update-written-files
       upper-case-p upper-case-p-char-upcase
       upper-case-p-forward-to-alpha-char-p
       user-stobj-alist user-stobj-alist1 value
       value-cmp value-triple verbose-pstack
       verify verify-guard-implication
       verify-guards verify-guards+
       verify-guards-formula verify-termination
       w walkabout warning! warrant
       waterfall-parallelism waterfall-printing
       weak-ld-history-entry-p
       well-formed-lambda-objectp
       wet when$ when$+ with-fast-alist
       with-global-stobj with-guard-checking
       with-guard-checking-error-triple
       with-guard-checking-event
       with-live-state
       with-local-state with-local-stobj
       with-output with-output!
       with-output-lock with-prover-step-limit
       with-prover-step-limit!
       with-prover-time-limit
       with-serialize-character
       with-stolen-alist without-evisc
       wof world wormhole wormhole-data
       wormhole-entry-code wormhole-eval
       wormhole-p wormhole-statusp
       wormhole1 writable-file-listp
       writable-file-listp-forward-to-true-list-listp
       writable-file-listp1
       writable-file-listp1-forward-to-true-listp-and-consp
       write-byte$
       writeable-files writeable-files-p
       writeable-files-p-forward-to-writable-file-listp
       written-file
       written-file-forward-to-true-listp-and-consp
       written-file-listp
       written-file-listp-forward-to-true-list-listp-and-alistp
       written-files written-files-p
       written-files-p-forward-to-written-file-listp
       xargs xor xxxjoin zero zerop zip zp zpf)")
 (*COMMON-LISP-SYMBOLS-FROM-MAIN-LISP-PACKAGE*
  (PACKAGES ACL2-BUILT-INS)
  "Symbols that are often imported into new packages to provide easy
  access to Common Lisp functionality.

  When you define a new package for your own work with [defpkg], you
  will usually want to import many symbols from the \"COMMON-LISP\"
  package so that you can access them without a common-lisp:: or
  acl2:: prefix.

  The constant *common-lisp-symbols-from-main-lisp-package* lists the
  978 symbols of the COMMON-LISP package found in {dpAns |
  http://dx.doi.org/10.1145/147135.147249}.  You will typically also
  want to import many symbols from ACL2; see [*ACL2-exports*].

    (&allow-other-keys *print-miser-width*
                       &aux *print-pprint-dispatch*
                       &body *print-pretty*
                       &environment *print-radix*
                       &key *print-readably* &optional
                       *print-right-margin* &rest *query-io*
                       &whole *random-state* * *read-base*
                       ** *read-default-float-format*
                       *** *read-eval* *break-on-signals*
                       *read-suppress* *compile-file-pathname*
                       *readtable* *compile-file-truename*
                       *standard-input* *compile-print*
                       *standard-output* *compile-verbose*
                       *terminal-io* *debug-io*
                       *trace-output* *debugger-hook*
                       + *default-pathname-defaults*
                       ++ *error-output* +++ *features*
                       - *gensym-counter* / *load-pathname*
                       // *load-print* /// *load-truename*
                       /= *load-verbose* 1+ *macroexpand-hook*
                       1- *modules* < *package*
                       <= *print-array* = *print-base*
                       > *print-case* >= *print-circle*
                       abort *print-escape* abs *print-gensym*
                       acons *print-length* acos *print-level*
                       acosh *print-lines* add-method adjoin
                       atom boundp adjust-array base-char
                       break adjustable-array-p base-string
                       broadcast-stream allocate-instance
                       bignum broadcast-stream-streams
                       alpha-char-p bit built-in-class
                       alphanumericp bit-and butlast
                       and bit-andc1 byte append bit-andc2
                       byte-position apply bit-eqv byte-size
                       apropos bit-ior caaaar apropos-list
                       bit-nand caaadr aref bit-nor
                       caaar arithmetic-error bit-not caadar
                       arithmetic-error-operands bit-orc1
                       caaddr arithmetic-error-operation
                       bit-orc2 caadr array bit-vector
                       caar array-dimension bit-vector-p
                       cadaar array-dimension-limit
                       bit-xor cadadr array-dimensions
                       block cadar array-displacement
                       boole caddar array-element-type
                       boole-1 cadddr array-has-fill-pointer-p
                       boole-2 caddr array-in-bounds-p
                       boole-and cadr array-rank
                       boole-andc1 call-arguments-limit
                       array-rank-limit boole-andc2 call-method
                       array-row-major-index boole-c1
                       call-next-method array-total-size
                       boole-c2 car array-total-size-limit
                       boole-clr case arrayp
                       boole-eqv catch ash boole-ior ccase
                       asin boole-nand cdaaar asinh boole-nor
                       cdaadr assert boole-orc1 cdaar assoc
                       boole-orc2 cdadar assoc-if boole-set
                       cdaddr assoc-if-not boole-xor cdadr
                       atan boolean cdar atanh both-case-p
                       cddaar cddadr clear-input copy-tree
                       cddar clear-output cos cdddar close cosh
                       cddddr clrhash count cdddr code-char
                       count-if cddr coerce count-if-not
                       cdr compilation-speed ctypecase
                       ceiling compile debug cell-error
                       compile-file decf cell-error-name
                       compile-file-pathname declaim
                       cerror compiled-function declaration
                       change-class compiled-function-p
                       declare char compiler-macro decode-float
                       char-code compiler-macro-function
                       decode-universal-time
                       char-code-limit complement defclass
                       char-downcase complex defconstant
                       char-equal complexp defgeneric
                       char-greaterp compute-applicable-methods
                       define-compiler-macro
                       char-int compute-restarts
                       define-condition char-lessp
                       concatenate define-method-combination
                       char-name concatenated-stream
                       define-modify-macro char-not-equal
                       concatenated-stream-streams
                       define-setf-expander char-not-greaterp
                       cond define-symbol-macro char-not-lessp
                       condition defmacro char-upcase conjugate
                       defmethod char/= cons defpackage
                       char< consp defparameter char<=
                       constantly defsetf char= constantp
                       defstruct char> continue deftype
                       char>= control-error defun character
                       copy-alist defvar characterp copy-list
                       delete check-type copy-pprint-dispatch
                       delete-duplicates cis copy-readtable
                       delete-file class copy-seq delete-if
                       class-name copy-structure delete-if-not
                       class-of copy-symbol delete-package
                       denominator eq deposit-field
                       eql describe equal describe-object
                       equalp destructuring-bind
                       error digit-char etypecase
                       digit-char-p eval directory eval-when
                       directory-namestring evenp disassemble
                       every division-by-zero exp do export
                       do* expt do-all-symbols extended-char
                       do-external-symbols fboundp do-symbols
                       fceiling documentation fdefinition
                       dolist ffloor dotimes fifth double-float
                       file-author double-float-epsilon
                       file-error double-float-negative-epsilon
                       file-error-pathname dpb file-length
                       dribble file-namestring dynamic-extent
                       file-position ecase file-stream
                       echo-stream file-string-length
                       echo-stream-input-stream file-write-date
                       echo-stream-output-stream
                       fill ed fill-pointer
                       eighth find elt find-all-symbols
                       encode-universal-time find-class
                       end-of-file find-if endp find-if-not
                       enough-namestring find-method
                       ensure-directories-exist find-package
                       ensure-generic-function find-restart
                       find-symbol get-internal-run-time
                       finish-output get-macro-character
                       first get-output-stream-string fixnum
                       get-properties flet get-setf-expansion
                       float get-universal-time float-digits
                       getf float-precision gethash
                       float-radix go float-sign graphic-char-p
                       floating-point-inexact handler-bind
                       floating-point-invalid-operation
                       handler-case floating-point-overflow
                       hash-table floating-point-underflow
                       hash-table-count floatp hash-table-p
                       floor hash-table-rehash-size fmakunbound
                       hash-table-rehash-threshold force-output
                       hash-table-size format hash-table-test
                       formatter host-namestring
                       fourth identity fresh-line
                       if fround ignorable ftruncate ignore
                       ftype ignore-errors funcall imagpart
                       function import function-keywords
                       in-package function-lambda-expression
                       incf functionp initialize-instance
                       gcd inline generic-function
                       input-stream-p gensym inspect
                       gentemp integer get integer-decode-float
                       get-decoded-time integer-length
                       get-dispatch-macro-character
                       integerp get-internal-real-time
                       interactive-stream-p
                       intern lisp-implementation-type
                       internal-time-units-per-second
                       lisp-implementation-version
                       intersection list invalid-method-error
                       list* invoke-debugger
                       list-all-packages invoke-restart
                       list-length invoke-restart-interactively
                       listen isqrt listp keyword load keywordp
                       load-logical-pathname-translations
                       labels load-time-value
                       lambda locally lambda-list-keywords
                       log lambda-parameters-limit
                       logand last logandc1 lcm
                       logandc2 ldb logbitp ldb-test logcount
                       ldiff logeqv least-negative-double-float
                       logical-pathname
                       least-negative-long-float
                       logical-pathname-translations
                       least-negative-normalized-double-float
                       logior
                       least-negative-normalized-long-float
                       lognand
                       least-negative-normalized-short-float
                       lognor
                       least-negative-normalized-single-float
                       lognot least-negative-short-float
                       logorc1 least-negative-single-float
                       logorc2 least-positive-double-float
                       logtest least-positive-long-float logxor
                       least-positive-normalized-double-float
                       long-float
                       least-positive-normalized-long-float
                       long-float-epsilon
                       least-positive-normalized-short-float
                       long-float-negative-epsilon
                       least-positive-normalized-single-float
                       long-site-name
                       least-positive-short-float loop
                       least-positive-single-float loop-finish
                       length lower-case-p let machine-instance
                       let* machine-type machine-version
                       mask-field macro-function
                       max macroexpand member macroexpand-1
                       member-if macrolet member-if-not
                       make-array merge make-broadcast-stream
                       merge-pathnames make-concatenated-stream
                       method make-condition method-combination
                       make-dispatch-macro-character
                       method-combination-error
                       make-echo-stream method-qualifiers
                       make-hash-table min make-instance
                       minusp make-instances-obsolete
                       mismatch make-list mod make-load-form
                       most-negative-double-float
                       make-load-form-saving-slots
                       most-negative-fixnum
                       make-method most-negative-long-float
                       make-package most-negative-short-float
                       make-pathname most-negative-single-float
                       make-random-state
                       most-positive-double-float
                       make-sequence most-positive-fixnum
                       make-string most-positive-long-float
                       make-string-input-stream
                       most-positive-short-float
                       make-string-output-stream
                       most-positive-single-float
                       make-symbol muffle-warning
                       make-synonym-stream multiple-value-bind
                       make-two-way-stream multiple-value-call
                       makunbound multiple-value-list
                       map multiple-value-prog1
                       map-into multiple-value-setq mapc
                       multiple-values-limit mapcan name-char
                       mapcar namestring mapcon nbutlast
                       maphash nconc mapl next-method-p
                       maplist nil nintersection package-error
                       ninth package-error-package
                       no-applicable-method package-name
                       no-next-method package-nicknames
                       not package-shadowing-symbols
                       notany package-use-list notevery
                       package-used-by-list notinline packagep
                       nreconc pairlis nreverse parse-error
                       nset-difference parse-integer
                       nset-exclusive-or parse-namestring
                       nstring-capitalize pathname
                       nstring-downcase pathname-device
                       nstring-upcase pathname-directory
                       nsublis pathname-host nsubst
                       pathname-match-p nsubst-if pathname-name
                       nsubst-if-not pathname-type nsubstitute
                       pathname-version nsubstitute-if
                       pathnamep nsubstitute-if-not
                       peek-char nth phase nth-value pi nthcdr
                       plusp null pop number position numberp
                       position-if numerator position-if-not
                       nunion pprint oddp pprint-dispatch
                       open pprint-exit-if-list-exhausted
                       open-stream-p pprint-fill
                       optimize pprint-indent or pprint-linear
                       otherwise pprint-logical-block
                       output-stream-p pprint-newline
                       package pprint-pop pprint-tab read-char
                       pprint-tabular read-char-no-hang
                       prin1 read-delimited-list
                       prin1-to-string read-from-string
                       princ read-line princ-to-string
                       read-preserving-whitespace
                       print read-sequence print-not-readable
                       reader-error print-not-readable-object
                       readtable print-object
                       readtable-case print-unreadable-object
                       readtablep probe-file
                       real proclaim realp prog realpart
                       prog* reduce prog1 reinitialize-instance
                       prog2 rem progn remf program-error
                       remhash progv remove provide
                       remove-duplicates psetf remove-if
                       psetq remove-if-not push remove-method
                       pushnew remprop quote rename-file
                       random rename-package random-state
                       replace random-state-p require rassoc
                       rest rassoc-if restart rassoc-if-not
                       restart-bind ratio restart-case
                       rational restart-name rationalize return
                       rationalp return-from read revappend
                       read-byte reverse room simple-bit-vector
                       rotatef simple-bit-vector-p
                       round simple-condition row-major-aref
                       simple-condition-format-arguments
                       rplaca simple-condition-format-control
                       rplacd simple-error
                       safety simple-string satisfies
                       simple-string-p sbit simple-type-error
                       scale-float simple-vector schar
                       simple-vector-p search simple-warning
                       second sin sequence single-float
                       serious-condition single-float-epsilon
                       set single-float-negative-epsilon
                       set-difference
                       sinh set-dispatch-macro-character
                       sixth set-exclusive-or
                       sleep set-macro-character slot-boundp
                       set-pprint-dispatch slot-exists-p
                       set-syntax-from-char slot-makunbound
                       setf slot-missing setq slot-unbound
                       seventh slot-value shadow software-type
                       shadowing-import software-version
                       shared-initialize some shiftf sort
                       short-float space short-float-epsilon
                       special short-float-negative-epsilon
                       special-operator-p short-site-name
                       speed signal sqrt signed-byte
                       stable-sort signum standard simple-array
                       standard-char simple-base-string
                       standard-char-p standard-class
                       sublis standard-generic-function subseq
                       standard-method subsetp standard-object
                       subst step subst-if storage-condition
                       subst-if-not store-value substitute
                       stream substitute-if stream-element-type
                       substitute-if-not stream-error
                       subtypep stream-error-stream
                       svref stream-external-format
                       sxhash streamp symbol
                       string symbol-function string-capitalize
                       symbol-macrolet string-downcase
                       symbol-name string-equal symbol-package
                       string-greaterp symbol-plist
                       string-left-trim symbol-value
                       string-lessp symbolp string-not-equal
                       synonym-stream string-not-greaterp
                       synonym-stream-symbol string-not-lessp t
                       string-right-trim tagbody string-stream
                       tailp string-trim tan string-upcase
                       tanh string/= tenth string< terpri
                       string<= the string= third string>
                       throw string>= time stringp trace
                       structure translate-logical-pathname
                       structure-class
                       translate-pathname structure-object
                       tree-equal style-warning truename
                       truncate values-list two-way-stream
                       variable two-way-stream-input-stream
                       vector two-way-stream-output-stream
                       vector-pop type vector-push type-error
                       vector-push-extend type-error-datum
                       vectorp type-error-expected-type
                       warn type-of warning typecase
                       when typep wild-pathname-p unbound-slot
                       with-accessors unbound-slot-instance
                       with-compilation-unit
                       unbound-variable with-condition-restarts
                       undefined-function
                       with-hash-table-iterator
                       unexport with-input-from-string unintern
                       with-open-file union with-open-stream
                       unless with-output-to-string unread-char
                       with-package-iterator unsigned-byte
                       with-simple-restart untrace with-slots
                       unuse-package with-standard-io-syntax
                       unwind-protect write
                       update-instance-for-different-class
                       write-byte
                       update-instance-for-redefined-class
                       write-char upgraded-array-element-type
                       write-line upgraded-complex-part-type
                       write-sequence upper-case-p
                       write-string use-package write-to-string
                       use-value y-or-n-p user-homedir-pathname
                       yes-or-no-p values zerop)")
 (*STANDARD-CI*
  (IO ACL2-BUILT-INS)
  "An ACL2 character-based analogue of CLTL's *standard-input*

  The value of the ACL2 constant *standard-ci* is an open character
  input channel that is synonymous to Common Lisp's *standard-input*.

  ACL2 character input from *standard-ci* is actually obtained by
  reading [characters] from the stream named by Common Lisp's
  *standard-input*.  That is, by changing the setting of
  *standard-input* in raw Common Lisp you can change the source from
  which ACL2 reads on the channel *standard-ci*.  See
  [*standard-co*].")
 (*STANDARD-CO*
  (IO ACL2-BUILT-INS)
  "The ACL2 analogue of CLTL's *standard-output*

  The value of the ACL2 constant *standard-co* is an open character
  output channel that is synonymous to Common Lisp's
  *standard-output*.

  ACL2 character output to *standard-co* will go to the stream named by
  Common Lisp's *standard-output*.  That is, by changing the setting
  of *standard-output* in raw Common Lisp you can change the actual
  destination of ACL2 output on the channel named by *standard-co*.
  Observe that this happens without changing the logical value of
  *standard-co* (which is some channel symbol).  Changing the setting
  of *standard-output* in raw Common Lisp essentially just changes
  the map that relates ACL2 to the physical world of terminals,
  files, etc.

  To see the value of this observation, consider the following.
  Suppose you write an ACL2 function which does character output to
  the constant channel *standard-co*.  During testing you see that
  the output actually goes to your terminal.  Can you use the
  function to output to a file?  Yes, if you are willing to do a
  little work in raw Common Lisp: open a stream to the file in
  question, set *standard-output* to that stream, call your ACL2
  function, and then close the stream and restore *standard-output*
  to its nominal value.  Similar observations can be made about the
  two ACL2 input channels, [*standard-oi*] and [*standard-ci*], which
  are analogues of *standard-input*.

  Another reason you might have for wanting to change the actual
  streams associated with [*standard-oi*] and *standard-co* is to
  drive the ACL2 top-level loop, [ld], on alternative input and
  output streams.  This end can be accomplished easily within ACL2 by
  either calling [ld] on the desired channels or file names or by
  resetting the ACL2 [state] global variables '[standard-oi] and
  '[standard-co] which are used by [ld].  See [standard-oi] and see
  [standard-co].")
 (*STANDARD-OI*
  (IO ACL2-BUILT-INS)
  "An ACL2 object-based analogue of CLTL's *standard-input*

  The value of the ACL2 constant *standard-oi* is an open object input
  channel that is synonymous to Common Lisp's *standard-input*.

  ACL2 object input from *standard-oi* is actually obtained by reading
  from the stream named by Common Lisp's *standard-input*.  That is,
  by changing the setting of *standard-input* in raw Common Lisp you
  can change the source from which ACL2 reads on the channel
  *standard-oi*.  See [*standard-co*].")
 (+
  (NUMBERS ACL2-BUILT-INS)
  "Addition macro

  + is really a macro that expands to calls of the function [binary-+].
  So for example

    (+ x y 4 z)

  represents the same term as

    (binary-+ x (binary-+ y (binary-+ 4 z))).

  See [binary-+].

  Macro: <+>

    (defmacro + (&rest rst)
              (if rst
                  (if (cdr rst)
                      (xxxjoin 'binary-+ rst)
                      (cons 'binary-+
                            (cons 0 (cons (car rst) nil))))
                  0))


Subtopics

  [Binary-+]
      Addition function")
 (-
  (NUMBERS ACL2-BUILT-INS)
  "Macro for subtraction and negation

  See [binary-+] for addition and see [unary--] for negation.

  Note that - represents subtraction as follows:

    (- x y)

  represents the same term as

    (+ x (- y))

  which is really

    (binary-+ x (unary-- y)).

  Also note that - represents arithmetic negation as follows:

    (- x)

  expands to

    (unary-- x).

  Macro: <->

    (defmacro
         - (x &optional (y 'nil binary-casep))
         (if binary-casep
             (let ((y (if (and (consp y)
                               (eq (car y) 'quote)
                               (consp (cdr y))
                               (acl2-numberp (car (cdr y)))
                               (eq (cdr (cdr y)) nil))
                          (car (cdr y))
                          y)))
                  (if (acl2-numberp y)
                      (cons 'binary-+
                            (cons (unary-- y) (cons x nil)))
                      (cons 'binary-+
                            (cons x
                                  (cons (cons 'unary-- (cons y nil))
                                        nil)))))
             (let ((x (if (and (consp x)
                               (eq (car x) 'quote)
                               (consp (cdr x))
                               (acl2-numberp (car (cdr x)))
                               (eq (cdr (cdr x)) nil))
                          (car (cdr x))
                          x)))
                  (if (acl2-numberp x)
                      (unary-- x)
                      (cons 'unary-- (cons x nil))))))")
 (/
  (NUMBERS ACL2-BUILT-INS)
  "Macro for division and reciprocal

  See [binary-*] for multiplication and see [unary-/] for reciprocal.

  Note that / represents division as follows:

    (/ x y)

  represents the same term as

    (* x (/ y))

  which is really

    (binary-* x (unary-/ y)).

  Also note that / represents reciprocal as follows:

    (/ x)

  expands to

    (unary-/ x).

  / is a Common Lisp macro.  See any Common Lisp documentation for more
  information.

  Macro: </>

    (defmacro / (x &optional (y 'nil binary-casep))
              (cond (binary-casep (list 'binary-* x (list 'unary-/ y)))
                    (t (list 'unary-/ x))))")
 (/=
  (NUMBERS ACL2-BUILT-INS)
  "Test inequality of two numbers

  (/= x y) is logically equivalent to (not (equal x y)).

  Unlike [equal], /= has a [guard] requiring both of its arguments to
  be numbers.  Generally, /= is executed more efficiently than a
  combination of [not] and [equal].

  For a discussion of the various ways to test against 0, See
  [zero-test-idioms].

  /= is a Common Lisp function.  See any Common Lisp documentation for
  more information.

  Function: </=>

    (defun /= (x y)
           (declare (xargs :guard (and (acl2-numberp x)
                                       (acl2-numberp y))))
           (not (equal x y)))")
 (1+
  (NUMBERS ACL2-BUILT-INS)
  "Increment by 1

  (1+ x) is the same as (+ 1 x).  See [+].

  1+ is a Common Lisp function.  See any Common Lisp documentation for
  more information.

  Macro: <1+>

    (defmacro 1+ (x) (list '+ 1 x))")
 (1-
  (NUMBERS ACL2-BUILT-INS)
  "Decrement by 1

  (1- x) is the same as (- x 1).  See [-].

  1- is a Common Lisp function.  See any Common Lisp documentation for
  more information.

  Macro: <1->

    (defmacro 1- (x) (list '- x 1))")
 (<
  (NUMBERS ACL2-BUILT-INS)
  "Less-than

  Completion Axiom (completion-of-<):

    (equal (< x y)
           (if (and (rationalp x)
                    (rationalp y))
               (< x y)
             (let ((x1 (if (acl2-numberp x) x 0))
                   (y1 (if (acl2-numberp y) y 0)))
               (or (< (realpart x1) (realpart y1))
                   (and (equal (realpart x1) (realpart y1))
                        (< (imagpart x1) (imagpart y1)))))))

  [Guard] for (< x y):

    (and (rationalp x) (rationalp y))

  Notice that like all arithmetic functions, < treats non-numeric
  inputs as 0. Thus, the following are theorems.

    (thm (equal (< (fix x) y) (< x y)))
    (thm (equal (< x (fix y)) (< x y)))

  This function has the usual meaning on the rational numbers, but is
  extended to the complex rational numbers using the lexicographic
  order: first the real parts are compared, and if they are equal,
  then the imaginary parts are compared.")
 (<=
  (NUMBERS ACL2-BUILT-INS)
  "Less-than-or-equal test

  <= is a macro, and (<= x y) expands to the same thing as (not (< y
  x)).  See [<].

  <= is a Common Lisp function.  See any Common Lisp documentation for
  more information.

  Macro: <<=>

    (defmacro <= (x y)
              (list 'not (list '< y x)))")
 (=
  (NUMBERS EQUAL EQUALITY-VARIANTS ACL2-BUILT-INS)
  "Test equality of two numbers

  (= x y) is logically equivalent to (equal x y).

  Unlike [equal], = has a [guard] requiring both of its arguments to be
  numbers.  Generally, = is executed more efficiently than [equal].

  For a discussion of the various ways to test against 0, See
  [zero-test-idioms].

  = is a Common Lisp function.  See any Common Lisp documentation for
  more information.

  Function: <=>

    (defun = (x y)
           (declare (xargs :guard (and (acl2-numberp x)
                                       (acl2-numberp y))))
           (equal x y))")
 (>
  (NUMBERS ACL2-BUILT-INS)
  "Greater-than test

  > is a macro, and (> x y) expands to the same thing as (< y x).  See
  [<].

  > is a Common Lisp function.  See any Common Lisp documentation for
  more information.

  Macro: <>>

    (defmacro > (x y) (list '< y x))")
 (>=
  (NUMBERS ACL2-BUILT-INS)
  "Greater-than-or-equal test

  >= is a macro, and (>= x y) expands to the same thing as (not (< x
  y)).  See [<].

  >= is a Common Lisp function.  See any Common Lisp documentation for
  more information.

  Macro: <>=>

    (defmacro >= (x y)
              (list 'not (list '< x y)))")
 (@
  (PROGRAMMING-WITH-STATE ACL2-BUILT-INS)
  "Get the value of a global variable in [state]

    Examples:
    (+ (@ y) 1)
    (assign a (aset1 'ascii-map-array (@ a) 66 'Upper-case-B))

    General Form:
    (@ symbol)

  where symbol is any symbol to which you have [assign]ed a global
  value.  This macro expands into (f-get-global 'symbol state), which
  retrieves the stored value of the symbol.

  The macro f-get-global is closely related to [@]: (@ var)
  macroexpands to (f-get-global 'var state).

  The macro [assign] makes it convenient to set the value of a symbol.
  The :[ubt] operation has no effect on the global-table of [state].
  Thus, you may use these globals to hang onto useful data structures
  even though you may undo back past where you computed and saved
  them.")
 (A!
  (LD)
  "To return to the top-level of ACL2's command loop

  When (a!) is evaluated inside of ACL2's command loop, the current
  computation is aborted and control returns to the top of the
  command loop, exactly as though the user had interrupted and
  aborted the current computation.  (Note: Versions of ACL2 up to
  Version_3.4 provided `#.' for this purpose, but no longer; see
  [sharp-dot-reader].)

  If you are at an ACL2 prompt (as opposed to a raw Lisp break), then
  you may type :a! in place of (a!); see [keyword-commands].

  For a related feature that only pops up one level, see [p!].

  Logically speaking, (a!) = nil.  But imagine that it is defined in
  such a way that it causes a stack overflow or other resource
  exhaustion when called.")
 (ABORT!
  (LD)
  "To return to the top-level of ACL2's command loop

  This is an alias for a!; see [a!].  For a related feature that only
  pops up one level, see [p!].")
 (ABORT-SOFT
  (MISCELLANEOUS)
  "Control how interrupts are handled in proofs

  ACL2 arranges by default that when a proof is interrupted (with
  Control-C), a ``soft'' abort occurs in the following sense: the
  message below is printed and then the proof attempt continues
  temporarily before ultimately failing (usually very soon
  thereafter).

    ***********************************************
    Note:  interrupt signal
      Will attempt to exit the proof in progress;
      otherwise, the next interrupt will abort the proof.
      For an immediate abort see :DOC abort-soft.
    ***********************************************

  This default behavior supports proper operation of the utility,
  [redo-flat], when a proof is interrupted.  It also supports more
  complete summaries than would be obtained with an immediate abort.
  If you nevertheless want proofs to abort immediately, you may
  evaluate the form (assign abort-soft nil).  To restore the default
  behavior, evaluate (assign abort-soft t).

  Remarks for system hackers.

    * An important effect of having evaluated (assign abort-soft nil) is
      that an interrupt will send you immediately back to the ACL2
      read-eval-print loop, in contrast to the default behavior where
      the prover returns an [error-triple] whose error component is
      non-nil.
    * It may be preferable to bind [state] global abort-soft rather than to
      assign it globally.  See the implementation of [prove$]
      (specifically, the definition of prove$-fn in [community-book]
      books/tools/prove-dollar.lisp) for an example.")
 (ABOUT-ACL2
  (ACL2)
  "General information About ACL2

  This is ACL2 Version 8.5, [copyright] (C) 2022, Regents of the
  University of Texas, authored by Matt Kaufmann and J Strother
  Moore.

  See the {ACL2 home page | http://www.cs.utexas.edu/users/moore/acl2/}
  for additional information including tutorials, installation
  instructions, mailing lists, related publications, ACL2 workshops
  and seminars, acknowledgments, and other ACL2 releases.

  See [documentation] for how to access the ACL2 User's Manual.

  For statistics on ACL2 code size, see file doc/acl2-code-size.txt.


Subtopics

  [Acknowledgments]
      Some contributors to the well-being of ACL2

  [ACL2-help]
      The acl2-help mailing list

  [Bibliography]
      Reports about ACL2

  [Building-ACL2]
      How to build an ACL2 executable

  [Common-lisp]
      Relation to Common Lisp, including deviations from the spec

  [Copyright]
      ACL2 copyright, license, sponsorship

  [Git-quick-start]
      Git quick start guide

  [Release-notes]
      Pointers to what has changed

  [Version]
      ACL2 Version Number")
 (ABOUT_MODELS
  (PAGES_WRITTEN_ESPECIALLY_FOR_THE_TOURS)
  "About Models

  {IMAGE} (see [Models_of_Computer_Hardware_and_Software])

  ACL2 is used to construct mathematical models of computer hardware
  and software (i.e., ``digital systems'').

  {IMAGE}

  A mathematical model is a set of mathematical formulas used to
  predict the behavior of some artifact.

  The use of mathematical models allows faster and cheaper delivery of
  better systems.

  Models need not be complete or perfectly accurate to be useful to the
  trained engineer.

  Click here (see [Models_in_Engineering]) for more discussion of these
  assertions in an engineering context.

  {IMAGE} (see [Models_of_Computer_Hardware_and_Software])")
 (ABOUT_THE_ACL2_HOME_PAGE
  (PAGES_WRITTEN_ESPECIALLY_FOR_THE_TOURS)
  "About the ACL2 Home Page

  {IMAGE} (see [What_Is_ACL2{Q}])

  The {ACL2 Home Page | http://www.cs.utexas.edu/users/moore/acl2/} on
  the web contains links to demos, publications, mailing lists,,
  installation instructions, and more --- and, especially, to the
  extensive {online documentation |
  https://www.cs.utexas.edu/users/moore/acl2/v8-5/acl2-doc.html#User's-Manual}
  for ACL2 and its libraries, known as ``books''.

  For example, to use the online documentation to find out about
  [rewrite] {ICON} (see [A_Tiny_Warning_Sign]) rules you could click
  on the link.  (If you do that, remember to use your browser's Back
  Button to come back here.)

  The tiny warning signs {ICON} (see [A_Tiny_Warning_Sign]) mark links
  that lead out of the introductory-level material and into the user
  documentation.  We advise against following such links upon your
  first reading of the documentation.

  At the end of the tours you will have a chance to revisit them
  quickly to explore alternative paths more fully.

  {IMAGE} (see [What_Is_ACL2{Q}])")
 (ABOUT_THE_ADMISSION_OF_RECURSIVE_DEFINITIONS
  (PAGES_WRITTEN_ESPECIALLY_FOR_THE_TOURS)
  "About the Admission of Recursive Definitions

  You can't just add any formula as an axiom or definition and expect
  the logic to stay sound!  For example, if we were permitted to
  define (APP X Y) so that it was equal to (NOT (APP X Y)) then we
  could prove anything.  The purported ``definition'' of APP must
  have several properties to be admitted to the logic as a new axiom.

  The key property a recursive definition must have is that the
  recursion terminate.  This, along with some syntactic criteria,
  ensures us that there exists a function satisfying the definition.

  Termination must be proved before the definition is admitted.  This
  is done in general by finding a measure of the arguments of the
  function and a well-founded relation such that the arguments ``get
  smaller'' every time a recursive branch is taken.

  For app the measure is the ``size'' of the first argument, x, as
  determined by the primitive function [ACL2-count] {ICON} (see
  [A_Tiny_Warning_Sign]).  The well-founded relation used in this
  example is [o-p] {ICON} (see [A_Tiny_Warning_Sign]), which is the
  standard ordering on the ordinals less than ``epsilon naught.''
  These particular choices for app were made ``automatically'' by
  ACL2.  But they are in fact determined by various ``default''
  settings.  The user of ACL2 can change the defaults or specify a
  ``hint'' to the [defun] {ICON} (see [A_Tiny_Warning_Sign]) command
  to specify the measure and relation.

  You should now return to the Walking Tour (see
  [Revisiting_the_Admission_of_App]).")
 (ABOUT_THE_PROMPT
  (PAGES_WRITTEN_ESPECIALLY_FOR_THE_TOURS)
  "About the Prompt

  The string ``ACL2 !>'' is the ACL2 prompt.

  The prompt tells the user that an ACL2 [command] {ICON} (see
  [A_Tiny_Warning_Sign]) is expected.  In addition, the prompt tells
  us a little about the current state of the ACL2 command
  interpreter.  We explain the prompt briefly below.  But first we
  talk about the command interpreter.

  An ACL2 command is generally a Lisp expression to be evaluated.
  There are some unusual commands (such as :[q] {ICON} (see
  [A_Tiny_Warning_Sign]) for quitting ACL2) which cause other
  behavior.  But most commands are read, evaluated, and then have
  their results printed.  Thus, we call the command interpreter a
  ``read-eval-print loop.'' The ACL2 command interpreter is named
  [ld] {ICON} (see [A_Tiny_Warning_Sign]) (after Lisp's ``load'').

  When a command is read, all the symbols in it are converted to
  uppercase.  Thus, typing (defun app ...) is the same as typing
  (DEFUN APP ...) or (defun App ...).  There are ways to force
  lowercase case characters into symbols but we won't discuss them
  here.  A consequence of Common Lisp's default uppercasing is that
  you'll see a general lack of concern over the case used when
  symbols are displayed in this documentation.

  In addition, symbols ``belong'' to ``packages'' which give the user a
  way to control namespaces.  The prompt tells us which package is
  the default one, namely \"ACL2\".  That means when we call car, for
  example, we are invoking the standard definition of that symbol.
  If the packager were \"JONES\" then car would refer to the definition
  of that symbol in that package (which may or may not be different
  depending on what symbols were imported into that package.

  A command like (defun app (x y) ...) causes ACL2 to evaluate the
  [defun] {ICON} (see [A_Tiny_Warning_Sign]) function on app, (x y)
  and ....  When that command is evaluated it prints some information
  to the terminal explaining the processing of the proposed
  definition.  It returns the symbol APP as its value, which is
  printed by the command interpreter.  (Actually, defun is not a
  function but a macro (see [DEFMACRO]) {ICON} (see
  [A_Tiny_Warning_Sign]) which expands to a form that involves
  [state] {ICON} (see [A_Tiny_Warning_Sign]), a necessary
  precondition to printing output to the terminal and to ``changing''
  the set of axioms.  But we do not discuss this further here.)

  The defun command is an example of a special kind of command called
  an ``event.'' [Events] {ICON} (see [A_Tiny_Warning_Sign]) are those
  commands that change the ``logical world'' by adding such things as
  axioms or theorems to ACL2's database.  See [world] {ICON} (see
  [A_Tiny_Warning_Sign]).  But not every command is an event command.

  A command like (app '(1 2 3) '(4 5 6 7)) is an example of a
  non-event.  It is processed the same general way: the function app
  is applied to the indicated arguments and the result is printed.
  The function app does not print anything and does not change the
  ``world.''

  A third kind of command is one that display information about the
  current logical world or that ``roll back'' to previous versions of
  the world.  Such commands are called ``[history]'' {ICON} (see
  [A_Tiny_Warning_Sign]) commands.

  What does the ACL2 prompt tell us about the read-eval-print loop?
  The prompt ``ACL2 !>'' tells us that the command will be read with
  [current-package] {ICON} (see [A_Tiny_Warning_Sign]) set to \"ACL2\",
  that guard checking (see [set-guard-checking] {ICON} (see
  [A_Tiny_Warning_Sign])) is on (``!''), and that we are at the
  top-level (there is only one ``>'').  For more about the prompt,
  see [default-print-prompt] {ICON} (see [A_Tiny_Warning_Sign]).

  You should now return to the Walking Tour (see
  [Revisiting_the_Admission_of_App]).")
 (ABOUT_TYPES
  (PAGES_WRITTEN_ESPECIALLY_FOR_THE_TOURS)
  "About Types

  The universe of ACL2 objects includes objects of many different
  types.  For example, t is a ``symbol'' and 3 is an ``integer.''
  Roughly speaking the objects of ACL2 can be partitioned into the
  following types:

    * Numbers (see [Numbers_in_ACL2]) such as 3, -22/7, #c(3 5/2).
    * Characters (see [ACL2_Characters]) such as #\\A, #\\a, #\\Space.
    * Strings (see [ACL2_Strings]) such as \"This is a string.\".
    * Symbols (see [ACL2_Symbols]) such as 'abc, 'smith::abc.
    * Conses (or Ordered Pairs) (see [ACL2_Conses_or_Ordered_Pairs]) such
      as '((a . 1) (b . 2)).

  When proving theorems it is important to know the types of object
  returned by a term.  ACL2 uses a complicated heuristic algorithm,
  called [type-set] {ICON} (see [A_Tiny_Warning_Sign]), to determine
  what types of objects a term may produce.  The user can more or
  less program the type-set algorithm by proving [type-prescription]
  {ICON} (see [A_Tiny_Warning_Sign]) rules.

  ACL2 is an ``untyped'' logic in the sense that the syntax is not
  typed: It is legal to apply a function symbol of n arguments to any
  n terms, regardless of the types of the argument terms.  Thus, it
  is permitted to write such odd expressions as (+ t 3) which sums
  the symbol t and the integer 3.  Common Lisp does not prohibit such
  expressions.  We like untyped languages because they are simple to
  describe, though proving theorems about them can be awkward
  because, unless one is careful in the way one defines or states
  things, unusual cases (like (+ t 3)) can arise.

  To make theorem proving easier in ACL2, the axioms actually define a
  value for such terms.  The value of (+ t 3) is 3; under the ACL2
  axioms, non-numeric arguments to + are treated as though they were
  0.

  You might immediately wonder about our claim that ACL2 is Common
  Lisp, since (+ t 3) is ``an error'' (and will sometimes even
  ``signal an error'') in Common Lisp.  It is to handle this problem
  that ACL2 has guards.  We will discuss guards later in the Walking
  Tour.  However, many new users simply ignore the issue of guards
  entirely and that is what we recommend for now.

  You should now return to the Walking Tour (see
  [Revisiting_the_Admission_of_App]).")
 (ABS
  (NUMBERS ACL2-BUILT-INS)
  "The absolute value of a real number

  (Abs x) is -x if x is negative and is x otherwise.

  The [guard] for abs requires its argument to be a rational ([real],
  in ACL2(r)) number.

  Abs is a Common Lisp function.  See any Common Lisp documentation for
  more information.

  From ``Common Lisp the Language'' page 205, we must not allow complex
  x as an argument to abs in ACL2, because if we did we would have to
  return a number that might be a floating point number and hence not
  an ACL2 object.

  Function: <abs>

    (defun abs (x)
           (declare (xargs :guard (real/rationalp x)))
           (if (minusp x) (- x) x))")
 (ABSTRACT-STOBJ (POINTERS)
                 "See [defabsstobj].")
 (ACCESS
  (DEFREC ACL2-BUILT-INS)
  "Accessor macro for [defrec] structures.

  The access macro is built into ACL2, and allows you to access
  particular fields from structures that have been introduced with
  [defrec].  For instance:

    (access employee x :name)

  would return the name field from the employee x.  See [defrec] for
  more information.")
 (ACCUMULATED-PERSISTENCE
  (DEBUGGING)
  "To get statistics on which [rune]s are being tried

    Useful Forms:
    (accumulated-persistence t)              ; Activate statistics gathering.
    (accumulated-persistence :all)           ; As above, ``enhanced'' (see below)

    (show-accumulated-persistence :frames)   ; Display statistics ordered by
    (show-accumulated-persistence :tries)    ; frames built, times tried,
    (show-accumulated-persistence :ratio)    ; or their ratio.
    (show-accumulated-persistence)           ; Same as supplying :frames argument.

    (accumulated-persistence nil)            ; Deactivate.

    (accumulated-persistence-oops)           ; Undo the clearing effect of
                                             ; (accumulated-persistence t).

    Advanced forms:
    (show-accumulated-persistence :frames-s) ; The `s', `f', and `a' suffixes
    (show-accumulated-persistence :frames-f) ; stand for `success' (`useful'),
    (show-accumulated-persistence :frames-a) ; `failure' (`useless'), and `all',
    (show-accumulated-persistence :tries-s)  ; respectively.  The only effect of
    (show-accumulated-persistence :tries-f)  ; the `s' and `f' versions is to
    (show-accumulated-persistence :tries-a)  ; sort first by useful or useless
                                             ; applications, respectively (see
                                             ; below).  The `a' versions avoid
                                             ; showing the useful/useless
                                             ; breakdown.

    (show-accumulated-persistence :runes)    ; Just show runes alphabetically.
    (show-accumulated-persistence :useless)  ; Just show useless runes.
    (show-accumulated-persistence :useless :list)
                                             ; Just show useless runes as a list.

  In summary, (accumulated-persistence t) turns on fresh statistics
  gathering for rules, (accumulated-persistence nil) turns it off,
  (show-accumulated-persistence) displays the statistics that were
  gathered, and (accumulated-persistence-oops) restores the
  statistics, if any, that were cleared by (accumulated-persistence
  t) or (accumulated-persistence :all).

  In general, if the optional second argument of
  show-accumulated-persistence is supplied as :list, then instead of
  the result being displayed a ``pretty'' human-readable format, the
  result will be displayed as a corresponding list of entries of the
  form (frames tries xrune).

  Note: set-accumulated-persistence is equivalent to
  accumulated-persistence.

  See the end of this item for a discussion of ``enhanced statistics
  gathering,'' which can be useful for more fine-grained proof
  debugging.

  Generally speaking, the more ACL2 knows, the slower it runs.  That is
  because the search space grows with the number of alternative
  rules.  Often, the system tries to apply rules that you have
  forgotten were even there, if you knew about them in the first
  place!  ``Accumulated-persistence'' is a statistic (originally
  developed for Nqthm) that helps you identify the rules that are
  causing ACL2's search space to explode.

  For other proof debugging utilities, see [break-rewrite] and see
  [dmr].

  Accumulated persistence tracking can be turned on or off.  It is
  generally off.  When on, proofs may take a little more time than
  otherwise.  (We measured approximately 11% more time in a so-called
  ``everything'' regression run in May 2020.)  But some useful
  numbers are collected.  When it is turned on, by

    ACL2 !>(accumulated-persistence t)

  an accumulation site is initialized and henceforth data about which
  rules are being tried is accumulated into that site.  That
  accumulated data can be displayed with
  show-accumulated-persistence, as described in detail below.  When
  accumulated persistence is turned off, with
  (accumulated-persistence nil), the accumulation site is wiped out
  and the data in it is lost.

  The ``accumulated persistence'' of a [rune] is the number of [rune]s
  the system has attempted to apply (since accumulated persistence
  was last activated) while the given [rune] was being tried.

  Consider a :[rewrite] rule named [rune].  For simplicity, let us
  imagine that [rune] is tried only once in the period during which
  accumulated persistence is being monitored.  Recall that to apply a
  rewrite rule we must match the left-hand side of the conclusion to
  some term we are trying to rewrite, establish the hypotheses of
  [rune] by rewriting, and, if successful, then rewrite the
  right-hand side of the conclusion.  We say [rune] is ``being
  tried'' from the time we have matched its left-hand side to the
  time we have either abandoned the attempt or finished rewriting its
  right-hand side.  (By ``match'' we mean to include any loop-stopper
  requirement; see [loop-stopper].)  During that period of time other
  rules might be tried, e.g., to establish the hypotheses.  The rules
  tried while [rune] is being tried are ``billed'' to [rune] in the
  sense that they are being considered here only because of the
  demands of [rune].  Thus, if no other rules are tried during that
  period, the accumulated persistence of [rune] is 1 --- we ``bill''
  [rune] once for its own application attempt.  If, on the other
  hand, we tried 10 rules on behalf of that application of [rune],
  then [rune]'s accumulated persistence would be 11.

  One way to envision accumulated persistence is to imagine that every
  time a [rune] is tried it is pushed onto a stack.  The rules tried
  on behalf of a given application of a [rune] are thus pushed and
  popped on the stack above that [rune].  A lot of work might be done
  on its behalf --- the stack above the [rune] grows and shrinks
  repeatedly as the search continues for a way to use the [rune].
  All the while, the [rune] itself ``persists'' in the stack, until
  we finish with the attempt to apply it, at which time we pop it
  off.  The accumulated persistence of a [rune] application is thus
  the number of stack frames built while that [rune] was on the
  stack.

  Note that accumulated persistence is tallied whether or not the
  attempt to apply a [rune] is successful.  Each of the rules tried
  on its behalf might have failed and the attempt to apply the [rune]
  might have also failed.  The ACL2 proof script would make no
  mention of the [rune] or the rules tried on its behalf because they
  did not contribute to the proof.  But time was spent pursuing the
  possible application of the [rune] and accumulated persistence is a
  measure of that time.

  A high accumulated persistence might come about in two extreme ways.
  One is that the rule causes a great deal of work every time it is
  tried.  The other is that the rule is ``cheap'' but is tried very
  often.  We therefore keep track of the number of times each rule is
  tried as well as its persistence.  The ratio between the two is the
  average amount of work done on behalf of the rule each time it is
  tried.

  We do not claim that tracking of runes for accumulated-persistence is
  perfect.  In practice, we believe it is quite reliable with the
  exception of [congruence] runes and, in some cases
  [executable-counterpart] runes. (For the latter, details are in a
  comment in the ACL2 source definition of function
  print-useless-runes.)

  When the accumulated persistence totals are displayed by the function
  show-accumulated-persistence we sort them so that the most
  expensive [rune]s are shown first.  We can sort according to one of
  three basic keys:

    :frames - the number of frames built on behalf of the rune
    :tries  - the number of times the rune was tried
    :ratio  - frames built per try

  The key simply determines the order in which the information is
  presented.  If no argument is supplied to
  show-accumulated-persistence, :frames is used.

  The display breaks each total into ``useful'' and ``useless''
  subtotals.  A ``useful'' rule try is one that is viewed as
  contributing to the progress of the proof, and the rest are
  ``useless'' rule applications.  For example, if a :[rewrite] rule
  is tried but its hypotheses are not successfully relieved, then
  that rule application and all work done on behalf of those
  hypotheses is ``useless'' work.  In general, an attempt to apply a
  [rune] is viewed as ``useful'' unless the attempt fails or the
  attempt is on the stack (as described above) for a [rune]
  application that ultimately fails.  A large number of ``useless''
  :frames or :tries along with correspondingly small ``useful''
  counts may suggest [rune]s to consider disabling (see [disable] and
  see [in-theory]).  Thus, here is a more complete list of the
  arguments that may be supplied to show-accumulated-persistence.
  Suffixes ``s'', ``f'', and ``a'' are intended to suggest
  ``success'' (``useful''), ``failure'' (``useless''), and ``all''.

    :frames     - sort by the number of frames built on behalf of the rune
       :frames-s -   as above, but sort by useful applications
       :frames-f -   as above, but sort by useless applications
       :frames-a -   as above, but inhibit display of ``useful'' and
                     ``useless'' subtotals
    :tries      - sort by the number of times the rune was tried
       :tries-s  -   as above, but sort by useful applications
       :tries-f  -   as above, but sort by useless applications
       :tries-a  -   as above, but inhibit display of ``useful'' and
                     ``useless'' subtotals
    :ratio      - sort by frames built per try
    :useless    - show only the runes tried whose tries were all ``useless''

  For a given line of the report, every frame credited to a ``useful''
  (respectively, ``useless'') rule application is considered
  ``useful'' (respectively, ``useless'').  We illustrate with the
  following example.

    (progn
      (defstub hyp (x) t)
      (defstub concl (x) t)
      (defstub bad (x) t)
      (defstub good (x) t)
      (defaxiom good-ax
        (implies (good x) (hyp x)))
      (defaxiom bad-ax
        (implies (bad x) (hyp x)))
      (defaxiom hyp-implies-concl
        (implies (hyp x) (concl x)))
      )
    (accumulated-persistence t)
    (thm (implies (good x) (concl x)))
    (show-accumulated-persistence)

  To prove the [thm] form, ACL2 attempts to rewrite (concl x) to true
  by applying rule hyp-implies-concl.  It then attempts to establish
  (hyp x) first by trying rule bad-ax, which fails, and second by
  trying rule good-ax, which succeeds.  As expected, the report
  labels as ``useless'' the failure of the attempt to establish the
  hypothesis, (bad x).

    --------------------------------
          1        1 (    1.00) (:REWRITE BAD-AX)
          0        0    [useful]
          1        1    [useless]
    --------------------------------

  Now consider the top-level application of rule hyp-implies-concl.
  Even though the above report shows the application of bad-ax as
  ``useless'', note that this rule was applied on behalf of the
  successful (``useful'') application of hyp-implies-concl, and hence
  is incorporated into the ``useful'' line for hyp-implies-concl, as
  follows.

    --------------------------------
          3        1 (    3.00) (:REWRITE HYP-IMPLIES-CONCL)
          3        1    [useful]
          0        0    [useless]
    --------------------------------

  In summary: categorization of :frames as ``useful'' or ``useless'' is
  based on whether they support ``useful'' or ``useless'' :tries.

  See [useless-runes] for a way to speed up proofs by automatically
  turning off useless rules.

  Note that a [rune] with high accumulated persistence may not actually
  be the ``culprit.'' For example, suppose rune1 is reported to have
  a :ratio of 101, meaning that on the average a hundred and one
  frames were built each time rune1 was tried.  Suppose rune2 has a
  :ratio of 100.  It could be that the attempt to apply rune1
  resulted in the attempted application of rune2 and no other [rune].
  Thus, in some sense, rune1 is ``cheap'' and rune2 is the
  ``culprit'' even though it is reported as costing less than rune1.

  If a proof is aborted, then in general,
  [show-accumulated-persistence] will only display totals for runes
  whose attempted application is complete: that is, if the rewriter
  was in the process of relieving hypotheses for a rule, then
  information for that rule will not be included in the tally.  We
  say ``in general'' because, as indicated near the top of the output
  from [show-accumulated-persistence] when such incomplete
  information is omitted, you can get this information by using
  argument :frames-a or :tries-a.

  There are other subtleties in how rune applications are tallied,
  documented elsewhere: see [accumulated-persistence-subtleties].

  We conclude with a discussion of ``enhanced'' statistics gathering,
  which is enabled by supplying accumulated-persistence the argument
  :ALL:

    (accumulated-persistence :all)

  At some additional performance expense (but probably well under a
  factor of 2 altogether), ACL2 then gathers additional statistics
  for individual hypotheses of rules as well as their conclusions.
  To understand how this works, suppose rn is a [rune].  Then we
  prepend the keyword :CONC to rn to form what we call its
  ``conclusion xrune'', and for its I-th hypothesis we prepend :HYP I
  to rn to form its I-th ``hypothesis xrune.'' Here, ``xrune'' is
  pronounced ``ex rune'', and is mnemonic for ``extended rune.'' For
  example, if (REWRITE FOO) is a [rune] then (:CONC REWRITE FOO) is
  its conclusion xrune, and (:HYP 2 REWRITE FOO) is a hypothesis
  xrune corresponding to the second hypothesis of the corresponding
  rewrite rule.

  With (accumulated-persistence :all), we instruct ACL2 to track not
  only runes but also xrunes.  Then, (show-accumulated-persistence)
  will display information for all xrunes in a format that we
  consider to be ``raw'', in the sense that data for xrunes are
  displayed just as for runes.  But a ``merged'' format is also
  available.  Here is a summary of display commands, followed below
  by further discussion.

    (show-accumulated-persistence :frames t) ; t is optional, i.e., the default
       ; Display enhanced statistics sorted by frames, in a ``raw'' format.
    (show-accumulated-persistence :frames :merge)
       ; Display enhanced statistics sorted by frames, in a ``merged'' format.
    (show-accumulated-persistence :frames nil)
       ; Display regular statistics sorted by frames
       ; (runes only, that is, without the enhancements).
    (show-accumulated-persistence :frames :merge)
       ; Display a list of entries (frames tries xrune), sorted by frames

    ; More generally, the descriptions just above apply for any legal first
    ; argument:

    (show-accumulated-persistence KEY t)
    (show-accumulated-persistence KEY :merge)
    (show-accumulated-persistence KEY nil)
    (show-accumulated-persistence KEY :list)

    ; Note also these alternate forms, equivalent to the first of the two forms
    ; just above, i.e., the form with second argument of t:
    (show-accumulated-persistence KEY :raw)
    (show-accumulated-persistence KEY)

  There is a significant difference between how runes are tracked and
  how ACL2 tracks hypothesis and conclusion xrunes: unlike regular
  runes, these xrunes do not contribute to the accumulated :frames
  counts.  Rather, they serve as accumulation sites without
  contributing their :tries to any accumulation.  Consider for
  example the snippet below, taken from a report created with the
  :merge option (to be discussed further below), i.e., by evaluating
  the form (show-accumulated-persistence :frames :merge).

    :frames   :tries    :ratio  rune
    --------------------------------
        462      211 (    2.18) (:REWRITE PERM-MEM)
         13        6    [useful]
        449      205    [useless]
       .............................
        251       47 (    5.34) (:HYP 2 :REWRITE PERM-MEM)
          6        6    [useful]
        245       41    [useless]
       .............................
          0      211 (    0.00) (:HYP 1 :REWRITE PERM-MEM)
          0        6    [useful]
          0      205    [useless]
       .............................
          0        7 (    0.00) (:CONC :REWRITE PERM-MEM)
          0        6    [useful]
          0        1    [useless]
    --------------------------------

  Notice that while :tries are recorded for the xrune (:HYP 1 :REWRITE
  PERM-MEM), no :frames are recorded.  This is because no stack
  frames were built for runes while this xrune was on the stack ---
  only for the xrune itself, which as we explained above is not
  accumulated into the total :frames counts.  As it turns out, this
  lack of stack frames is explained by the fact that the rewrite rule
  PERM-MEM has a free variable in the first hypothesis.

    ACL2 !>:pe perm-mem
             18  (DEFTHM PERM-MEM
                         (IMPLIES (AND (PERM X Y) (MEM A X))
                                  (MEM A Y))
                         :RULE-CLASSES ((:REWRITE :MATCH-FREE :ONCE)))
    ACL2 !>

  The second hypothesis, however, does cause additional rewriting in
  order to rewrite it to true, resulting in 251 stack frames for
  runes.  We see that the conclusion does not lead to creation of any
  rune stack frames, which might seem to suggest that only 251 stack
  frames for runes were created on behalf of this rule application
  --- yet, we see that 462 frames were actually created.  The
  difference is the 211 frames created for the rewrite rule itself.
  Even if the total had been a bit more than 462, one need not be
  surprised, as there could be some work recorded during application
  of the rewrite rule, such as type-prescription reasoning, that is
  not done during rewriting of a hypothesis or the conclusion.

  Now suppose we have executed (accumulated-persistence :all) and
  attempted some proofs, and now we are ready to see statistics.  The
  form (show-accumulated-persistence) displays statistics exactly as
  described above, treating these extra xrunes just as though they
  are runes; similarly for the form (show-accumulated-persistence
  KEY), for any legal KEY.  A second optional argument may however be
  supplied to show-accumulated-persistence.  The default for that
  second argument is t, and a second argument of :raw is treated the
  same as t; thus, these arguments provide the behavior just
  described, where data for xrunes are displayed just as for runes.
  You may restrict output to runes, ignoring hypothesis and
  conclusion xrunes, by giving a second argument of nil.  (This gives
  the same behavior as if we had started with the command
  (accumulated-persistence t) instead of the command
  (accumulated-persistence :all).)  You may give a second argument of
  :merge, in which case output will be sorted and displayed as though
  only runes were tracked (not the extra xrunes), but each data item
  for a non-rune xrune will be merged so that it is displayed in
  suitable order just below its corresponding rune, as in the
  PERM-MEM example displayed above.  Finally, you may give a second
  argument of :list, which is equivalent to the default second
  argument of t, except that the results are printed as a list of
  entries (frames tries xrune).

  We close by mentioning two aspects of enhanced statistics display for
  :CONC xrunes that have potential to be confusing.  First consider
  the following example.

      :frames   :tries    :ratio  rune
    --------------------------------
         14        4 (    3.50) (:REWRITE DEFAULT-+-2)
          0        0    [useful]
         14        4    [useless]
       .............................
         10        4 (    2.50) (:HYP 1 :REWRITE DEFAULT-+-2)
          0        0    [useful]
         10        4    [useless]
    --------------------------------

  It may be surprising that no data is displayed for the corresponding
  :CONC xrune.  The explanation, however, is simple: the hypothesis
  never rewrote to true, so the conclusion was never rewritten.  This
  is consistent with the marking as ``useless'' of all :frames and
  :tries for the rune and the hypothesis xrune.  Note by the way,
  once again, that the hypothesis xrune does not contribute to any
  :frames count.

  Another reason not to see data displayed for a :CONC xrune is that if
  a rule has no hypotheses, then no such data is collected.  This
  decision was made because in the case of no hypotheses, we expect
  it to be very rare that information for the :CONC xrune will add
  any useful insight.

  On a final note: (show-accumulated-persistence :runes) may be used
  simply to see a list of all [rune]s (or xrunes) displayed
  alphabetically.

  Users are encouraged to think about other meters we could install in
  ACL2 to help diagnose performance problems.


Subtopics

  [Accumulated-persistence-subtleties]
      Some subtle aspects of the counting done by
      [accumulated-persistence]

  [Dmr]
      Dynamically monitor rewrites and other prover activity

  [Useless-runes]
      Speed up proofs by disabling useless [rune]s")
 (ACCUMULATED-PERSISTENCE-OOPS (POINTERS)
                               "See [accumulated-persistence].")
 (ACCUMULATED-PERSISTENCE-SUBTLETIES
  (ACCUMULATED-PERSISTENCE)
  "Some subtle aspects of the counting done by [accumulated-persistence]

  In this topic we cover the overcounting of ``useful'' [rune]
  application attempts, and we describe how ``useless'' rune
  application attempts can actually be critical for a proof's
  success.  We conclude with a few words about counting frames when
  there are nested (recursive) applications of a rune.

  Overcounting of ``useful'' rune application attempts. Not every
  [rune] application may be necessary for a proof's success.
  Consider for example:

    (thm (equal (car (cons a (cdr (cons b x))))
                a))

  Then show-accumulated-persistence will tell us that :[rewrite] rules
  car-cons and cdr-cons each had one useful application.  However,
  the rule cdr-cons is used to simplify (cdr (cons b x)) to x, and
  this simplification is unnecessary for the proof.  Indeed, the
  proof succeeds even when preceded by the event: (in-theory (disable
  cdr-cons)).  We thus see that a [rune] application labeled as
  ``useful'' may be simplifying a term that is not relevant to the
  proof.

  As of this writing, we consider every :[forward-chaining] rule
  application to be ``useful'', for simplicity of the implementation.
  Moreover, our counting of these rules is such that a single rule
  may be counted more than once.

  How ``useless'' attempts can be critical for a proof's success. The
  command (accumulated-persistence :useless) will list rules that did
  not contribute directly to the proof (see
  [accumulated-persistence], in particular the discussion of
  ``useless'' there).  However, a ``useless'' rule can on rare
  occasions be critical to the success of a proof.  In the following
  example, we have a ``bad'' rule that can take the proof in the
  wrong direction, but a ``useless'' rule does a rewrite that
  prevents the successful relieving of a hypothesis of the ``bad''
  rule.  In summary:

    ; Assume p0.  We want to prove p1.

    ; Key rule:
    p0 -> p1 = t

    ; Bad rule that could ruin the proof:
    p3 -> p1 = p2

    ; But unfortunately, we know p3:
    p0 -> p3

    ; Important ``useless'' rule, preventing ``bad rule'' above from firing:
    p3 = p4

  The following event captures the rules described above.

    (encapsulate
     ((p0 (x) t)
      (p1 (x) t)
      (p2 (x) t)
      (p3 (x) t)
      (p4 (x) t))
     (local (defun p0 (x) x))
     (local (defun p1 (x) x))
     (local (defun p2 (x) x))
     (local (defun p3 (x) x))
     (local (defun p4 (x) x))

    ; Key rule:
     (defthm p0-implies-p1
       (implies (p0 x)
                (p1 x)))

    ; Bad rule that could ruin the proof:
     (defthm p3-implies-p1-is-p2
       (implies (p3 x)
                (equal (p1 x) (p2 x))))

    ; But unfortunately, we know p3:
     (defthm p0-implies-p3
       (implies (p0 x)
                (p3 x)))

    ; Important ``useless'' rule, preventing p3-implies-p1-is-p2 from firing:
     (defthm p3-is-p4
       (equal (p3 x) (p4 x))))

  Now we can see that p3-is-p4 is labeled as ``useless'', by evaluating
  these commands.

    (accumulated-persistence t)
    (thm (implies (p0 x) (p1 x)))
    (show-accumulated-persistence)

  If instead we first evaluate (in-theory (disable p3-is-p4)) before
  the thm above, then the proof fails, even though p3-is-p4 was
  labeled as ``useless''!

  Nevertheless, in general it is probably safe to disable rules
  reported as ``useless'' by (show-accumulated-persistence :useless),
  and doing so may speed up a proof considerably.

  Remark. The example above suggests a surprising fact: on rare
  occasions, a proof may fail when you give an :[in-theory] hint
  consisting of exactly the [rune]s reported in a proof that
  succeeds.  For, imagine a rule R that is needed in part of the
  proof but is ``bad'' in a second part, and that some other,
  ``useless'' rule prevents the application of R in that second part.
  The example above suggests that disabling this ``useless'' rule can
  allow the second application of R, thus preventing the proof.

  Finally we discuss accumulation into frame counts in the case of a
  nested (recursive) application of a rule: that is, the case that
  during the application of a rule, the rule is applied again --- in
  particular, while relieving a hypothesis or rewriting the
  right-hand side from the original rule application.  Recall that
  the implementation of [accumulated-persistence] keeps a stack of
  [rune]s currently being applied; thus, we are considering here the
  case that a rune is pushed onto a stack on which it already
  resides.  In that case, we count tries as usual but we avoid
  accumulating until we reach the outermost (topmost) application of
  that rune.  Consider the following example.

    (defun mem (a x)
      (if (atom x)
          nil
        (or (equal a (car x)) (mem a (cdr x)))))

  Now suppose we consider the theorem (mem a (list 1 2 3 a)).  Each
  time the definition of mem is applied, a new stack frame is pushed.
  We avoid accumulating into the :frames count for that stack frame
  unless it is the topmost stack frame for that definition.
  Otherwise the final :frames count would be the sum of the counts
  for those individual frames, which form a linear sequence whose sum
  would therefore be quadratic in the number of applications of the
  definition of mem.")
 (ACKNOWLEDGMENTS
  (ABOUT-ACL2)
  "Some contributors to the well-being of ACL2

  The development of ACL2 was initially made possible by funding from
  the U. S. Department of Defense, including ARPA and ONR.  We thank
  all the organizations that have contributed support, including the
  following (in alphabetical order).

    * AMD, for providing significant time over several years for Matt
      Kaufmann to carry out ACL2 research, support, and development
    * Computational Logic, Inc. and its president, Don Good, where the
      first eight years of ACL2 development occurred
    * Centaur Technology
    * Collins Aerospace
    * DARPA
    * Digital Equipment Corporation
    * EDS, which provided some time for Matt Kaufmann's ACL2 work 1998-1999
    * ForrestHunt and, more generally, Warren A. Hunt, Jr. (see below)
    * IBM
    * Intel
    * Kestrel Institute
    * Kestrel Technology
    * NSF (see below)
    * ONR
    * SRC
    * Sun Microsystems
    * U.S. Army, in particular ARL
    * University of Texas at Austin (in particular support to J Moore
      through the Admiral B. R.  Inman Chair of Computing Theory)

  Regarding NSF:

    * This material is based upon work supported by the National Science
      Foundation under Grant Nos. CCF-1526760, CNS-1525472,
      CCF-1153558, EIA-0303609, CNS-0429591, ISS-0417413,
      CCF-0945316, and CNS-0910913.
    * Any opinions, findings and conclusions or recomendations expressed in
      this material are those of the authors and do not necessarily
      reflect the views of the National Science Foundation.

  We are especially grateful to Warren A. Hunt, Jr. for his unrivaled
  efforts in securing support for the entire ACL2 research group at
  both Computational Logic, Inc., and the University of Texas at
  Austin.  Without his efforts, we would have spent less time working
  on the system and fewer students would have been funded to apply
  it.

  ACL2 was started in August, 1989 by Boyer and Moore working together.
  They co-authored the first versions of axioms.lisp and basis.lisp,
  with Boyer taking the lead in the formalization of ``[state]'' and
  the most primitive [io] functions.  Boyer also had a significant
  hand in the development of the early versions of the files
  interface-raw.lisp and translate.lisp.  For several years, Moore
  alone was responsible for developing the ACL2 system code, though
  he consulted often with both Boyer and Kaufmann.  In August, 1993,
  Kaufmann became jointly responsible with Moore for developing the
  system.  Boyer has continued to provide valuable consulting on an
  informal basis.

  Bishop Brock was the heaviest early user of ACL2, and provided many
  suggestions for improvements.  In particular, the :cases and
  :restrict [hints] were his idea; he developed an early version of
  congruence-based reasoning for Nqthm; and he helped in the
  development of some early [books] about arithmetic.  In a
  demonstration of his courage and faith in us, he pushed for
  Computational Logic, Inc., to agree to the Motorola CAP contract
  --- which required formalizing a commercial DSP in the untested
  ACL2 --- and moved to Scottsdale, AZ, to do the work with the
  Motorola design team.  His demonstration of ACL2's utility was an
  inspiration, even to those of us designing ACL2.

  John Cowles also helped in the development of some early [books]
  about arithmetic, and also provided valuable feedback and bug
  reports.

  Other early users of ACL2 at Computational Logic, Inc. helped
  influence its development.  In particular, Warren Hunt helped with
  the port to Macintosh Common Lisp, and Art Flatau and Mike Smith
  provided useful general feedback.

  Mike Smith helped develop the Emacs portion of the implementation of
  proof trees.

  ACL2 depends on the availability of robust Common Lisp
  implementations, so we are grateful to the developers of those
  implementations.  Early in ACL2's history, Bill Schelter made some
  enhancements to AKCL (now GCL) that helped to enhance ACL2
  performance in that Common Lisp implementation, and more generally,
  responded helpfully to our bug reports.  Camm Maguire has since
  provided wonderful GCL support, and has created a Debian package
  for ACL2 built on GCL.  Gary Byers and R. Matthew Emerson have
  continually improved Clozure Common Lisp (CCL), often based on
  feedback from the ACL2 community.  We are also grateful to
  developers of other Common Lisp implementations.

  Kent Pitman helped in our interaction with the ANSI Common Lisp
  standardization committee, X3J13.

  John Cowles helped with the port to Windows (98) by answering
  questions and running tests.

  Ruben Gamboa created a modification of ACL2 to allow reasoning about
  the real numbers using non-standard analysis.  His work has been
  incorporated into the ACL2 distribution; see [real].

  Rob Sumners has made numerous useful suggestions.  In particular, he
  has designed and implemented improvements for [stobj]s and been key
  in our development of locally-bound stobjs; see [note-2-6].

  Robert Krug has designed and implemented many changes in the vicinity
  of the linear arithmetic package and its connection to type-set and
  rewrite.  He was also instrumental in the development of
  [extended-metafunctions].

  Pete Manolios has made numerous useful suggestions.  In particular,
  Pete helped us to organize the first workshop and was a wonderful
  equal partner with the two of us (Kaufmann and Moore) in producing
  the books that arose from that workshop.  Pete and his student,
  Daron Vroon, provided the current implementation of [ordinals].

  Jared Davis, Sol Swords, and David Rager have our gratitude for
  starting the {ACL2+Books repository |
  https://github.com/acl2/acl2/}.

  We thank David L. Rager for contributing an initial version of the
  support for [parallelism] in an experimental extension of ACL2.

  Bob Boyer and Warren A. Hunt, Jr. developed a canonical
  representation for ACL2 data objects, applicative hash tables, and
  a function memoization mechanism to facilitate reuse of previously
  computed results.  Subsequently, Jared Davis and Sol Swords made
  further contributions.  We thank them all for this work, most of
  which has been incorporated into ACL2; see [hons-and-memoization].

  Other contributions to the ACL2 system continue to be made by members
  of the ACL2 community.  In particular, following the first
  Developers Workshop in May, 2017 through the time of this writing
  in November, 2019, such contributors include Alessandro Coglio,
  Keshav Kini, Mihir Mehta, Pete Manolios, and especially Sol Swords,
  while Eric Smith and many others have suggested changes that we
  have implemented, often by providing helpful examples.  The
  [release-notes] detail such contributions as well as many
  suggestions from the community for improvements that we ultimately
  implemented.

  We also thank the contributors to the ACL2 workshops for some
  suggested improvements and for the extensive collection of publicly
  distributed benchmark problems.  And we thank participants at the
  ACL2 seminar at the University of Texas for useful feedback.  More
  generally, we thank the ACL2 community for feedback, contributed
  [books] (see [community-books]), and their interest in the ACL2
  project.

  Regarding the documentation:

      Bill Young wrote significant portions of the original acl2-tutorial
      section of the ACL2 documentation, including what is now called
      [alternative-introduction].  This was an especially important
      task in the early years when there was no guide for how to use
      ACL2 and we are very grateful.  He, Bishop Brock, Rich Cohen,
      and Noah Friedman read over considerable amounts of the
      documentation, and made many useful comments.  Others,
      particularly Bill Bevier and John Cowles, have also made useful
      comments on the [documentation].

      Art Flatau helped develop the ACL2 markup language in which ACL2
      [documentation] was originally developed, along with
      translators from that language to Texinfo and HTML.  Michael
      ``Bogo'' Bogomolny created a search engine, beginning with
      Version 2.6, and for that purpose modified the HTML translator
      to create one file per topic (a good idea in any case).

      Laura Lawless provided many hours of help in marking up appropriate
      parts of the [documentation] in typewriter font.

      Noah Friedman developed an Emacs tool that helped us insert
      ``invisible links'' into the [documentation], which improve the
      usability of that documentation under HTML readers such as
      Mosaic.

      Richard Stallman contributed a texinfo patch, to be found in the file
      doc/texinfo.tex.

      Jared Davis created the [xdoc] system that is now the basis not only
      for the ACL2 system [documentation] (file
      books/system/doc/acl2-doc.lisp), but also for the
      [community-books] documentation.

  We thank Blake Grugett for designing the current version of the ACL2
  logo (which for example appears on the ACL2 home page), based on an
  original design created in the 1990s by Computational Logic, Inc.")
 (ACL2
  NIL
  "ACL2 documentation (system only, not including the community books)

  This is the ACL2 documentation.  For the ACL2+Books Manual, which
  that includes both the ACL2 documentation and the ACL2
  [community-books], see the {ACL2+Books Manual |
  http://www.cs.utexas.edu/users/moore/acl2/v8-5/combined-manual/index.html}.


Subtopics

  [About-ACL2]
      General information About ACL2

  [ACL2-tutorial]
      Tutorial introduction to ACL2

  [Bdd]
      Ordered binary decision diagrams with rewriting

  [Books]
      Books are files of ACL2 [events]---they are the main way to split up
      large ACL2 developments into separate modules.

  [Debugging]
      Tools for debugging failed or slow proofs, or misbehaving functions.

  [Documentation]
      Information about options for downloading and viewing the ACL2
      documentation, contributing documentation, and the available
      tools for documenting your own books.

  [Events]
      Functions that extend the logic

  [History]
      Functions to display or change contents of the logical [world]

  [Hons-and-memoization]
      Hash cons, function memoization, and applicative hash tables

  [Interfacing-tools]
      Libraries and tools for doing basic file i/o (see [STD/IO]), using
      raw Common Lisp libraries (see [QUICKLISP]), working with the
      operating system (see [OSLIB]), and interfacing with other
      programs (see [BRIDGE]).

  [Macros]
      Macros allow you to extend the syntax of ACL2.

  [Miscellaneous]
      A miscellany of documented functions and concepts (often cited in
      more accessible [documentation])

  [Output-controls]
      Methods for controlling the output produced by the ACL2 prover

  [Parallelism]
      Experimental extension for parallel execution and proofs

  [Programming]
      Programming in ACL2

  [Proof-builder]
      An interactive tool for controlling ACL2's proof processes.

  [Real]
      ACL2(r) support for real numbers

  [Rule-classes]
      Adding rules to the database

  [Theories]
      Sets of [rune]s to [enable]/[disable] in concert")
 (ACL2-AS-STANDALONE-PROGRAM
  (ACL2-TUTORIAL)
  "Calling ACL2 from another program

  ACL2 is intended for interactive use.  It is generally unrealistic to
  expect it to prove theorems fully automatically; see [the-method],
  and see [introduction-to-the-theorem-prover] for a more detailed
  tutorial.

  Nevertheless, here we describe an approach for how to call the ACL2
  theorem prover noninteractively.  These steps can of course be
  modified according to your needs.  Here, we illustrate how to call
  ACL2 from another Lisp program (or an arbitrary program) to attempt
  to prove an arithmetic theorem.

  See also [interfacing-tools].  In particular, if you want to make a
  command-line tool to ACL2 with options, you may be interested in
  [oslib::argv], [getopt], and especially [getopt-demo::demo2].
  Alternately, if you want to develop a server application on top of
  ACL2, you might consider [bridge].


Step 1

  Build a suitable ACL2 image by starting ACL2 and then executing the
  following forms.  In particular, these define a macro, try-thm,
  that causes ACL2 to exit with an exit status indicating success or
  failure of a proof attempt.

    (include-book \"arithmetic-5/top\" :dir :system)
    (defmacro try-thm (&rest args)
      `(mv-let (erp val state)
               (with-prover-time-limit 3 (thm ,@args))
               (declare (ignore val))
               (prog2$ (if erp (exit 1) (exit 0)) state))))
    (reset-prehistory) ; optional
    :q
    (save-exec \"arith-acl2\" \"Included arithmetic-4/top\")

  If you prefer, above you can replace 3 by some other number of
  seconds as a time limit for the prover.  Also, you can replace

    (with-prover-time-limit 3 (thm ,@args))

  by

    (with-output :off :all (with-prover-time-limit 3 (thm ,@args)))

  if you want to turn off output.  It may be best to leave the output
  on, instead eliminating it in the calling program (see Step 3
  below).


Step 2

  Try a little test.  In that same directory try this:

    echo '(try-thm (equal x x))' | ./arith-acl2
    echo $?

  The exit status should be 0, indicating success.  Now try this:

    echo '(try-thm (not (equal x x)))' | ./arith-acl2
    echo $?

  The exit status should be 1, indicating failure.


Step 3

  Create a shell script that automates Step 2, for example:

    #!/bin/sh
    (echo \"(try-thm $1)\" | ./arith-acl2) >& /dev/null
    exit $?


Step 4

  Try your script from a Lisp program, if you like.  Here is how you
  can do it in SBCL, for example.  (Different Lisps have different
  ways to do this, as summarized in function system-call in ACL2
  source file acl2-init.lisp.)

    (defun provable? (x)
      (let ((status
             (process-exit-code
              (sb-ext:run-program \"./try-thm.sh\" (list (format nil \"~s\" x))
                                  :output t :search t))))
        (eql status 0)))

  Then here is a log:

    * (provable? '(equal x y))

    NIL
    * (provable? '(equal x x))

    T
    *

  Certainly refinements are possible --- for example the above doesn't
  distinguish between unprovable and ill-formed input.  But it's a
  start.")
 (ACL2-BUILT-INS
  (PROGRAMMING)
  "''Catch-all'' topic for built-in ACL2 functions

  This [documentation] topic is a parent topic under which we include
  documentation for built-in functions, macros, and special forms
  that are typically used in [programming].  For others, including
  those typically used as top-level commands or those that create
  [events] ([defun], [defmacro], [defthm], and so on), documentation
  may be found as a subtopic of some other parent topic.  We do not
  document some of the more obscure functions provided by ACL2 that
  do not correspond to functions of Common Lisp.

  If you are already familiar with Common Lisp (or even some other Lisp
  variant), then you may find it helpful to start with the topic,
  [introduction-to-programming-in-ACL2-for-those-who-know-lisp].

  See any documentation for Common Lisp for more details on many of
  these functions.


Subtopics

  [*]
      Multiplication macro

  [*ACL2-exports*]
      Symbols that are often imported into new [packages] to provide easy
      access to ACL2 functionality.

  [*common-lisp-symbols-from-main-lisp-package*]
      Symbols that are often imported into new packages to provide easy
      access to Common Lisp functionality.

  [*standard-ci*]
      An ACL2 character-based analogue of CLTL's *standard-input*

  [*standard-co*]
      The ACL2 analogue of CLTL's *standard-output*

  [*standard-oi*]
      An ACL2 object-based analogue of CLTL's *standard-input*

  [+]
      Addition macro

  [-]
      Macro for subtraction and negation

  [/]
      Macro for division and reciprocal

  [/=]
      Test inequality of two numbers

  [1+]
      Increment by 1

  [1-]
      Decrement by 1

  [<]
      Less-than

  [<=]
      Less-than-or-equal test

  [=]
      Test equality of two numbers

  [>]
      Greater-than test

  [>=]
      Greater-than-or-equal test

  [@]
      Get the value of a global variable in [state]

  [Abs]
      The absolute value of a real number

  [Access]
      Accessor macro for [defrec] structures.

  [ACL2-count]
      A commonly used measure for justifying recursion

  [ACL2-number-listp]
      Recognizer for a true list of numbers

  [ACL2-numberp]
      Recognizer for numbers

  [Acons]
      Constructor for association lists

  [Add-to-set]
      Add a symbol to a list

  [Alist-keys-subsetp]
      Check that all keys of the alist belong to a given set

  [Alist-to-doublets]
      Convert an alist to a list of two-element lists

  [Alistp]
      Recognizer for association lists

  [Allocate-fixnum-range]
      Set aside fixnums in GCL

  [Alpha-char-p]
      Recognizer for alphabetic characters

  [Alphorder]
      Total order on atoms

  [And]
      Conjunction

  [Append]
      [concatenate] zero or more lists

  [Apply$]
      Apply a badged function or tame lambda to arguments

  [Aref1]
      Access the elements of a 1-dimensional array

  [Aref2]
      Access the elements of a 2-dimensional array

  [Arities-okp]
      check the arities of given function symbols

  [Arity]
      number of arguments of a function symbol

  [Array1p]
      Recognize a 1-dimensional array

  [Array2p]
      Recognize a 2-dimensional array

  [Aset1]
      Set the elements of a 1-dimensional array

  [Aset1-trusted]
      Set the elements of a 1-dimensional array without [invariant-risk]

  [Aset2]
      Set the elements of a 2-dimensional array

  [Ash]
      Arithmetic shift operation

  [Assert$]
      Cause a hard error if the given test is false

  [Assert*]
      Create a [guard] proof obligation that given test holds

  [Assign]
      Assign to a global variable in [state]

  [Assoc]
      Look up key in association list

  [Assoc-keyword]
      Look up key in a [keyword-value-listp]

  [Assoc-string-equal]
      Look up key, a string, in association list

  [Atom]
      Recognizer for atoms

  [Atom-listp]
      Recognizer for a true list of [atom]s

  [Binary-*]
      Multiplication function

  [Binary-+]
      Addition function

  [Binary-append]
      [concatenate] two lists

  [Bitp]
      A recognizer for the set of bits, {0,1}

  [Boole$]
      Perform a bit-wise logical operation on 2 two's complement integers

  [Boolean-listp]
      Recognizer for a true list of booleans

  [Booleanp]
      Recognizer for booleans

  [Break$]
      Cause an immediate Lisp break

  [Break-on-error]
      Break when encountering a hard or soft error caused by ACL2

  [Butlast]
      All but a final segment of a list

  [Caaaar]
      [car] of the [caaar]

  [Caaadr]
      [car] of the [caadr]

  [Caaar]
      [car] of the [caar]

  [Caadar]
      [car] of the [cadar]

  [Caaddr]
      [car] of the [caddr]

  [Caadr]
      [car] of the [cadr]

  [Caar]
      [car] of the [car]

  [Cadaar]
      [car] of the [cdaar]

  [Cadadr]
      [car] of the [cdadr]

  [Cadar]
      [car] of the [cdar]

  [Caddar]
      [car] of the [cddar]

  [Cadddr]
      [car] of the [cdddr]

  [Caddr]
      [car] of the [cddr]

  [Cadr]
      [car] of the [cdr]

  [Canonical-pathname]
      The true absolute filename, with soft links resolved

  [Car]
      Returns the first element of a non-empty list, else nil

  [Case]
      Conditional based on if-then-else using [eql]

  [Case-match]
      Pattern matching or destructuring

  [Cbd]
      Connected book directory string

  [Cdaaar]
      [cdr] of the [caaar]

  [Cdaadr]
      [cdr] of the [caadr]

  [Cdaar]
      [cdr] of the [caar]

  [Cdadar]
      [cdr] of the [cadar]

  [Cdaddr]
      [cdr] of the [caddr]

  [Cdadr]
      [cdr] of the [cadr]

  [Cdar]
      [cdr] of the [car]

  [Cddaar]
      [cdr] of the [cdaar]

  [Cddadr]
      [cdr] of the [cdadr]

  [Cddar]
      [cdr] of the [cdar]

  [Cdddar]
      [cdr] of the [cddar]

  [Cddddr]
      [cdr] of the [cdddr]

  [Cdddr]
      [cdr] of the [cddr]

  [Cddr]
      [cdr] of the [cdr]

  [Cdr]
      Returns the second element of a [cons] pair, else nil

  [Ceiling]
      Division returning an integer by truncating toward positive infinity

  [Change]
      Mutator macro for [defrec] structures.

  [Char]
      The [nth] element (zero-based) of a string

  [Char-code]
      The numeric code for a given character

  [Char-downcase]
      Turn upper-case [characters] into lower-case [characters]

  [Char-equal]
      Character equality without regard to case

  [Char-upcase]
      Turn lower-case [characters] into upper-case [characters]

  [Char<]
      Less-than test for [characters]

  [Char<=]
      Less-than-or-equal test for [characters]

  [Char>]
      Greater-than test for [characters]

  [Char>=]
      Greater-than-or-equal test for [characters]

  [Character-alistp]
      Recognizer for association lists with characters as keys

  [Character-listp]
      Recognizer for a true list of characters

  [Characterp]
      Recognizer for [characters]

  [Code-char]
      The character corresponding to a given numeric code

  [Coerce]
      Coerce a character list to a string and a string to a list

  [Comment]
      Variant of [prog2$] to help debug evaluation failures during proofs

  [Comp]
      Compile some ACL2 functions

  [Comp-gcl]
      Compile some ACL2 functions leaving .c and .h files

  [Complex]
      Create an ACL2 number

  [Complex-rationalp]
      Recognizes complex rational numbers

  [Complex/complex-rationalp]
      Recognizer for complex numbers

  [Compress1]
      Remove irrelevant pairs from a 1-dimensional array

  [Compress2]
      Remove irrelevant pairs from a 2-dimensional array

  [Concatenate]
      Concatenate lists or strings together

  [Cond]
      Conditional based on if-then-else

  [Conjugate]
      Complex number conjugate

  [Cons]
      Pair and list constructor

  [Cons-count-bounded]
      Count the number of conses (up to a limit)

  [Cons-subtrees]
      Build a fast alist whose keys are the subtrees of X

  [Cons-with-hint]
      Alternative to [cons] that tries to avoid consing when a suitable
      cons structure is provided as a hint.

  [Consp]
      Recognizer for [cons] pairs

  [Count]
      Count the number of occurrences of an item in a string or true-list

  [Count-keys]
      Count the number of keys in association list

  [Cpu-core-count]
      The number of cpu cores

  [Cw]
      Print to the comment window

  [Cw!]
      Print readably to the comment window

  [Cw!+]
      Print readably and uninhibited to the comment window

  [Cw+]
      Print uninhibited to the comment window

  [Cw-print-base-radix]
      Print to the comment window in a given print-base

  [Cw-print-base-radix!]
      Print to the comment window in a given print-base

  [Declare]
      Extra declarations that can occur in function definitions, [let]
      bindings, and so forth.

  [Default]
      Return the :default from the [header] of a 1- or 2-dimensional array

  [Defbadge]
      Issue a badge for a function so [apply$] can evaluate with it

  [Defwarrant]
      Issue a warrant for a function so [apply$] can use it in proofs

  [Delete-assoc]
      Deprecated version of [remove1-assoc]

  [Denominator]
      Divisor of a ratio in lowest terms

  [Digit-char-p]
      The number, if any, corresponding to a given character

  [Digit-to-char]
      Map a digit to a character

  [Dimensions]
      Return the :dimensions from the [header] of a 1- or 2-dimensional
      array

  [Ec-call]
      Execute a call in the ACL2 logic instead of raw Lisp

  [Eighth]
      Eighth member of the list

  [Endp]
      Recognizer for empty lists

  [Eq]
      Equality of symbols

  [Eql]
      Test equality (of two numbers, symbols, or [characters])

  [Eqlable-alistp]
      Recognizer for a true list of pairs whose [car]s are suitable for
      [eql]

  [Eqlable-listp]
      Recognizer for a true list of objects each suitable for [eql]

  [Eqlablep]
      The [guard] for the function [eql]

  [Equal]
      True equality

  [Er]
      Print an error message and ``cause an error''

  [Er-progn]
      Perform a sequence of state-changing ``error triples''

  [Er-soft]
      Print an error message and ``cause a soft error''

  [Error1]
      Print an error message and cause a ``soft error''

  [Evenp]
      Test whether an integer is even

  [Evens]
      The even-indexed members of a list

  [Explode-atom]
      Convert any [atom] into a [character-listp] that contains its
      printed representation, rendering numbers in your choice of
      print base.

  [Explode-nonnegative-integer]
      The list of [characters] in the radix-r form of a number

  [Expt]
      Exponential function

  [F-boundp-global]
      Check whether a global variable in [state] has a value

  [F-get-global]
      Get the value of a global variable in [state]

  [F-put-global]
      Assign to a global variable in [state]

  [Fast-alist-clean]
      (fast-alist-clean alist) can be used to eliminate \"shadowed pairs\"
      from a fast alist.

  [Fast-alist-clean!]
      (fast-alist-clean! alist) is an alternative to [fast-alist-clean]
      that produces a [normed] result.

  [Fast-alist-fork]
      (fast-alist-fork alist ans) can be used to eliminate \"shadowed
      pairs\" from an alist or to copy [fast-alists].

  [Fast-alist-fork!]
      (fast-alist-fork! alist ans) is an alternative to [fast-alist-fork]
      that produces a [normed] result.

  [Fast-alist-free]
      (fast-alist-free alist) throws away the hash table associated with a
      fast alist.

  [Fast-alist-free-on-exit]
      Free a fast alist after the completion of some form.

  [Fast-alist-len]
      (fast-alist-len alist) counts the number of unique keys in a fast
      alist.

  [Fast-alist-summary]
      (fast-alist-summary) prints some basic statistics about any current
      fast alists.

  [Fifth]
      Fifth member of the list

  [First]
      First member of the list

  [Fix]
      Coerce to a number

  [Fix-true-list]
      Coerce to a true list

  [Flet]
      Local binding of function symbols

  [Floor]
      Division returning an integer by truncating toward negative infinity

  [Flush-compress]
      Flush the under-the-hood array for the given name

  [Flush-hons-get-hash-table-link]
      Deprecated feature

  [Fms]
      (fms str alist co-channel state evisc) => state

  [Fms!]
      (fms! str alist co-channel state evisc) => state

  [Fmt]
      Formatted printing

  [Fmt!]
      (fmt! str alist co-channel state evisc) => state

  [Fmt-to-comment-window]
      Print to the comment window

  [Fmt-to-comment-window!]
      Print readably to the comment window

  [Fmt-to-comment-window!+]
      Print readably and uninhibited to the comment window

  [Fmt-to-comment-window+]
      Print uninhibited to the comment window

  [Fmt1]
      (fmt1 str alist col co-channel state evisc) => (mv col state)

  [Fmt1!]
      (fmt1! str alist col channel state evisc) => (mv col state)

  [Fmx]
      (fmx str &rest args) => state

  [Fmx-cw]
      (fmx-cw str &rest args) => state

  [Formula]
      The formula of a name or [rune]

  [Fourth]
      Fourth member of the list

  [Gc$]
      Invoke the garbage collector

  [Gc-strategy]
      The garbage collection strategy

  [Get-internal-time]
      Runtime vs. realtime in ACL2 timings

  [Getenv$]
      Read an environment variable

  [Getprop]
      Access fast property lists

  [Getpropc]
      Access fast property lists

  [Good-atom-listp]
      Recognizer for a true list of ``good'' [atom]s

  [Good-bye]
      Quit entirely out of Lisp

  [Hard-error]
      Print an error message and stop execution

  [Header]
      Return the header of a 1- or 2-dimensional array

  [Hons]
      (hons x y) returns a [normed] object equal to (cons x y).

  [Hons-acons]
      (hons-acons key val alist) is the main way to create or extend
      [fast-alists].

  [Hons-acons!]
      (hons-acons! key val alist) is an alternative to [hons-acons] that
      produces [normed], fast alists.

  [Hons-assoc-equal]
      (hons-assoc-equal key alist) is not fast; it serves as the logical
      definition for [hons-get].

  [Hons-clear]
      (hons-clear gc) is a drastic garbage collection mechanism that
      clears out the underlying Hons Space.

  [Hons-clear!]
      A version of [hons-clear] for [parallel] execution

  [Hons-copy]
      (hons-copy x) returns a [normed] object that is equal to X.

  [Hons-copy-persistent]
      (hons-copy-persistent x) returns a [normed] object that is equal to
      X and which will be re-normed after any calls to [hons-clear].

  [Hons-equal]
      (hons-equal x y) is a recursive equality check that optimizes when
      parts of its arguments are [normed].

  [Hons-get]
      (hons-get key alist) is the efficient lookup operation for
      [fast-alists].

  [Hons-resize]
      (hons-resize ...) can be used to manually adjust the sizes of the
      hash tables that govern which ACL2 Objects are considered
      [normed].

  [Hons-shrink-alist]
      Deprecated feature

  [Hons-shrink-alist!]
      Deprecated feature

  [Hons-summary]
      (hons-summary) prints basic information about the sizes of the
      tables in the current Hons Space.

  [Hons-wash]
      (hons-wash) is like [gc$] but can also garbage collect [normed]
      objects (CCL and GCL Only).

  [Hons-wash!]
      A version of [hons-wash] for [parallel] execution

  [Identity]
      The identity function

  [If]
      If-then-else function

  [Iff]
      Logical ``if and only if''

  [Ifix]
      Coerce to an integer

  [Illegal]
      Print an error message and stop execution

  [Imagpart]
      Imaginary part of a complex number

  [Implies]
      Logical implication

  [Improper-consp]
      Recognizer for improper (non-nil-terminated) non-empty lists

  [In-package]
      Select current package

  [In-tau-intervalp]
      Boolean membership in a tau interval

  [Int=]
      Test equality of two integers

  [Integer-length]
      Number of bits in two's complement integer representation

  [Integer-listp]
      Recognizer for a true list of integers

  [Integer-range-p]
      Recognizer for integers between two bounds.

  [Integerp]
      Recognizer for whole numbers

  [Intern]
      Create a new symbol in a given package

  [Intern$]
      Create a new symbol in a given package

  [Intern-in-package-of-symbol]
      Create a symbol with a given name

  [Intersection$]
      Elements common to the given lists

  [Intersectp]
      Test whether two lists intersect

  [Keyword-listp]
      Recognizer for true lists of keywords

  [Keyword-value-listp]
      Recognizer for true lists whose even-position elements are keywords

  [Keywordp]
      Recognizer for keywords

  [Kwote]
      Quote an arbitrary object

  [Kwote-lst]
      Quote an arbitrary true list of objects

  [Last]
      The last [cons] (not element) of a list

  [Last-prover-steps]
      The number of prover steps most recently taken

  [Len]
      Length of a list

  [Length]
      Length of a string or proper list

  [Let]
      Binding of lexically scoped (local) variables

  [Let*]
      Binding of lexically scoped (local) variables

  [Lexorder]
      Total order on ACL2 objects

  [List]
      Build a list

  [List*]
      Build a list

  [Listp]
      Recognizer for (not necessarily proper) lists

  [Logand]
      Bitwise logical `and' of zero or more integers

  [Logandc1]
      Bitwise logical `and' of two ints, complementing the first

  [Logandc2]
      Bitwise logical `and' of two ints, complementing the second

  [Logbitp]
      The ith bit of an integer

  [Logcount]
      Number of ``on'' bits in a two's complement number

  [Logeqv]
      Bitwise logical equivalence of zero or more integers

  [Logic-fns-list-listp]
      Recognizer for when a given list of lists of [term]s calls only
      :[logic]-mode function symbols

  [Logic-fns-listp]
      Recognizer for when a given list of [term]s calls only :[logic]-mode
      function symbols

  [Logic-fnsp]
      Recognizer for when a given [term] calls only :[logic]-mode function
      symbols

  [Logic-term-list-listp]
      Recognizer for lists of lists of [term]s that call only
      :[logic]-mode function symbols

  [Logic-term-listp]
      Recognizer for lists of [term]s that call only :[logic]-mode
      function symbols

  [Logic-termp]
      Recognizer for [term]s that call only :[logic]-mode function symbols

  [Logior]
      Bitwise logical inclusive or of zero or more integers

  [Lognand]
      Bitwise logical `nand' of two integers

  [Lognor]
      Bitwise logical `nor' of two integers

  [Lognot]
      Bitwise not of a two's complement number

  [Logorc1]
      Bitwise logical inclusive or of two ints, complementing the first

  [Logorc2]
      Bitwise logical inclusive or of two ints, complementing the second

  [Logtest]
      Test if two integers share a `1' bit

  [Logxor]
      Bitwise logical exclusive or of zero or more integers

  [Loop$]
      Iteration with an analogue of the Common Lisp loop macro

  [Lower-case-p]
      Recognizer for lower case characters

  [Make]
      Constructor macro for [defrec] structures.

  [Make-character-list]
      [coerce] to a list of characters

  [Make-fast-alist]
      (make-fast-alist alist) creates a fast-alist from the input alist,
      returning alist itself or, in some cases, a new object equal to
      it.

  [Make-list]
      Make a list of a given size

  [Make-ord]
      A constructor for ordinals.

  [Make-tau-interval]
      Make a tau interval

  [Makunbound-global]
      Remove the value assigned to a global variable in [state]

  [Max]
      The larger of two numbers

  [Maximum-length]
      Return the :maximum-length from the [header] of an array

  [Maybe-flush-and-compress1]
      Compress a one-dimensional array only if necessary

  [Mbe]
      Attach code for execution

  [Mbe1]
      Attach code for execution

  [Mbt]
      Introduce a test into the logic that, however, evaluates to t

  [Mbt*]
      Introduce a guard proof obligation

  [Member]
      Membership predicate

  [Merge-sort-lexorder]
      Sort a list

  [Min]
      The smaller of two numbers

  [Minusp]
      Test whether a number is negative

  [Mod]
      Remainder using [floor]

  [Mod-expt]
      Exponential function

  [Msg]
      Construct a ``message'' suitable for the ~@ directive of [fmt]

  [Msgp]
      Recognizer for a ``message''

  [Must-be-equal]
      Attach code for execution

  [Mv]
      Returning a multiple value

  [Mv-let]
      Calling multi-valued ACL2 functions

  [Mv-list]
      Converting [multiple-value] result to a single-value list

  [Mv-nth]
      The mv-nth element (zero-based) of a list

  [Mv?]
      Return one or more values

  [Mv?-let]
      Calling possibly multi-valued ACL2 functions

  [Nat-listp]
      Recognizer for a true list of natural numbers

  [Natp]
      A recognizer for the natural numbers

  [Nfix]
      Coerce to a natural number

  [Ninth]
      Ninth member of the list

  [No-duplicatesp]
      Check for duplicates in a list

  [Non-exec]
      Mark code as non-executable

  [Nonnegative-integer-quotient]
      Natural number division function

  [Not]
      Logical negation

  [Nth]
      The nth element (zero-based) of a list

  [Nthcdr]
      Final segment of a list

  [Null]
      Recognizer for the empty list

  [Number-subtrees]
      (number-subtrees x) returns the number of distinct subtrees of X, in
      the sense of [equal]

  [Numerator]
      Dividend of a ratio in lowest terms

  [O-finp]
      Recognizes if an ordinal is finite

  [O-first-coeff]
      Returns the first coefficient of an ordinal

  [O-first-expt]
      The first exponent of an ordinal

  [O-infp]
      Recognizes if an ordinal is infinite

  [O-p]
      A recognizer for the ordinals up to epsilon-0

  [O-rst]
      Returns the rest of an infinite ordinal

  [O<]
      The well-founded less-than relation on ordinals up to epsilon-0

  [O<=]
      The less-than-or-equal relation for the ordinals

  [O>]
      The greater-than relation for the ordinals

  [O>=]
      The greater-than-or-equal relation for the ordinals

  [Observation]
      Print an observation

  [Oddp]
      Test whether an integer is odd

  [Odds]
      The odd-indexed members of a list

  [Open-output-channel!]
      When trust tags are needed to open output channels

  [Or]
      Disjunction

  [Packn]
      Build a symbol from a list

  [Packn-pos]
      Build a symbol in a specified package from a list

  [Pairlis$]
      Zipper together two lists

  [Pairlis-x1]
      Cons a given element to each member of a list

  [Pairlis-x2]
      Cons each element of a list with a given element

  [Pand]
      Parallel, Boolean version of [and]

  [Pargs]
      Parallel evaluation of arguments in a function call

  [Pkg-witness]
      Return a specific symbol in the indicated package

  [Plet]
      Parallel version of [let]

  [Plusp]
      Test whether a number is positive

  [Por]
      Parallel, Boolean version of [or]

  [Pos-listp]
      Recognizer for a true list of positive integers

  [Position]
      Position of an item in a string or a list

  [Posp]
      A recognizer for the positive integers

  [Pprogn]
      Evaluate a sequence of forms that return [state]

  [Primitive]
      Primitive functions built into ACL2 without definitions

  [Princ$]
      Print an atom

  [Print-base-p]
      Recognizer for print bases that are understood by functions such as
      [explode-nonnegative-integer] and [explode-atom].

  [Print-object$]
      Print an an object to an open object output channel

  [Print-object$+]
      Print an an object to an open output channel in a specified manner

  [Prog2$]
      Execute two forms and return the value of the second one

  [Progn$]
      Execute a sequence of forms and return the value of the last one

  [Proofs-co]
      The proofs character output channel

  [Proper-consp]
      Recognizer for proper (nil-terminated) non-empty lists

  [Pseudo-term-listp]
      A predicate for recognizing lists of term-like s-expressions

  [Pseudo-termp]
      A predicate for recognizing term-like s-expressions

  [Put-assoc]
      Modify an association list by associating a value with a key

  [Putprop]
      Update fast property lists

  [Quote]
      Create a constant

  [R-eqlable-alistp]
      Recognizer for a true list of pairs whose [cdr]s are suitable for
      [eql]

  [R-symbol-alistp]
      Recognizer for association lists with symbols as values

  [Random$]
      Obtain a random value

  [Rassoc]
      Look up value in association list

  [Rational-listp]
      Recognizer for a true list of rational numbers

  [Rationalp]
      Recognizer for rational numbers (ratios and integers)

  [Read-ACL2-oracle]
      Pop the oracle field of the state

  [Read-run-time]
      Read elapsed runtime

  [Real-listp]
      ACL2(r) recognizer for a true list of real numbers

  [Real/rationalp]
      Recognizer for rational numbers (including real number in ACL2(r))

  [Realfix]
      Coerce to a real number

  [Realpart]
      Real part of a complex number

  [Rem]
      Remainder using [truncate]

  [Remove]
      Remove all occurrences

  [Remove-assoc]
      Remove all pairs with a given key from an association list

  [Remove-duplicates]
      Remove duplicates from a string or a list

  [Remove1]
      Remove first occurrences, testing using [eql]

  [Remove1-assoc]
      Remove the first pair with a given key from an association list

  [Resize-list]
      List resizer in support of [stobj]s

  [Rest]
      Rest ([cdr]) of the list

  [Return-last]
      Return the last argument, perhaps with side effects

  [Revappend]
      Concatenate the [reverse] of one list to another

  [Reverse]
      Reverse a list or string

  [Rfix]
      Coerce to a rational number

  [Round]
      Division returning an integer by rounding off

  [Search]
      Search for a string or list in another string or list

  [Second]
      Second member of the list

  [Serialize-read]
      Read a serialized ACL2 object from a file

  [Serialize-write]
      Write an ACL2 object into a file

  [Set-difference$]
      Elements of one list that are not elements of another

  [Set-fmt-hard-right-margin]
      Set the right margin for formatted output

  [Set-fmt-soft-right-margin]
      Set the soft right margin for formatted output

  [Set-gc-strategy]
      Set the garbage collection strategy (CCL only)

  [Set-print-base]
      Control radix in which numbers are printed

  [Set-print-base-radix]
      Control radix in which numbers are printed and printing of the radix

  [Set-print-case]
      Control whether symbols are printed in upper case or in lower case

  [Set-print-radix]
      Control printing of the radix for numbers

  [Setenv$]
      Set an environment variable

  [Seventh]
      Seventh member of the list

  [Signed-byte-p]
      Recognizer for signed integers that fit in a specified bit width

  [Signum]
      Indicator for positive, negative, or zero

  [Sixth]
      Sixth member of the list

  [Spec-mv-let]
      Modification of [mv-let] supporting speculative and parallel
      execution

  [Standard-char-listp]
      Recognizer for a true list of standard characters

  [Standard-char-p]
      Recognizer for standard characters

  [Standard-char-p+]
      Recognizer for standard characters whose guard is t

  [Standard-co]
      The character output channel to which [ld] prints

  [Standard-oi]
      The standard object input ``channel''

  [Standard-string-alistp]
      Recognizer for association lists with standard strings as keys

  [State-global-let*]
      Bind [state] global variables

  [String]
      [coerce] to a string

  [String-append]
      [concatenate] two strings

  [String-downcase]
      In a given string, turn upper-case [characters] into lower-case

  [String-equal]
      String equality without regard to case

  [String-listp]
      Recognizer for a true list of strings

  [String-upcase]
      In a given string, turn lower-case [characters] into upper-case

  [String<]
      Less-than test for strings

  [String<=]
      Less-than-or-equal test for strings

  [String>]
      Greater-than test for strings

  [String>=]
      Less-than-or-equal test for strings

  [Stringp]
      Recognizer for strings

  [Strip-cars]
      Collect up all first components of pairs in a list

  [Strip-cdrs]
      Collect up all second components of pairs in a list

  [Sublis]
      Substitute an alist into a tree

  [Subseq]
      Subsequence of a string or list

  [Subsetp]
      Test if every [member] of one list is a [member] of the other

  [Subst]
      A single substitution into a tree

  [Substitute]
      Substitute into a string or a list, using [eql] as test

  [Swap-stobjs]
      Swap two congruent [stobj]s

  [Symbol-alistp]
      Recognizer for association lists with symbols as keys

  [Symbol-listp]
      Recognizer for a true list of symbols

  [Symbol-name]
      The name of a symbol (a string)

  [Symbol-name-lst]
      Lift [symbol-name] to lists

  [Symbol-package-name]
      The name of the package of a symbol (a string)

  [Symbol<]
      Less-than test for symbols

  [Symbolp]
      Recognizer for symbols

  [Sys-call]
      Make a system call to the host operating system

  [Sys-call*]
      Make a system call to the host OS, returning a status

  [Sys-call+]
      Make a system call to the host OS, returning status and output

  [Sys-call-status]
      Exit status from the preceding system call

  [Take]
      Initial segment (first n elements) of a list

  [Tenth]
      Tenth member of the list

  [Term-list-listp]
      recognizer for a list of clauses

  [Term-listp]
      recognizer for a list of quotations of terms and of clauses

  [Term-order]
      The ordering relation on terms used by ACL2

  [Termp]
      recognizer for the quotation of a [term]

  [The]
      The is a special form that can be used to optimize the execution
      efficiency of [guard]-verified ACL2 definitions, or (less
      frequently) to carry out a low-level run-time type checks.
      (Advanced)

  [Third]
      Third member of the list

  [Time$]
      Time an evaluation

  [Time-tracker]
      Display time spent during specified evaluation

  [True-list-listp]
      Recognizer for true (proper) lists of true lists

  [True-listp]
      Recognizer for proper (nil-terminated) lists

  [Truncate]
      Division returning an integer by truncating toward 0

  [Unary--]
      Arithmetic negation function

  [Unary-/]
      Reciprocal function

  [Union$]
      A list that contains exactly the elements of the given lists

  [Unquote]
      Obtain the object being quoted

  [Unsigned-byte-p]
      Recognizer for natural numbers that fit in a specified bit width

  [Update-nth]
      Modify a list by putting the given value at the given position

  [Update-nth-array]
      Update a stobj array

  [Upper-case-p]
      Recognizer for upper case characters

  [Value-triple]
      Compute a value, optionally checking that it is not nil

  [With-fast-alist]
      (with-fast-alist name form) causes name to be a fast alist for the
      execution of form.

  [With-global-stobj]
      Operate on a global single-threaded object

  [With-guard-checking]
      Suppress or enable guard-checking for a form

  [With-guard-checking-error-triple]
      Suppress or enable guard-checking for a form

  [With-guard-checking-event]
      Suppress or enable guard-checking for an event form

  [With-live-state]
      Allow a reference to state in raw Lisp

  [With-local-state]
      Locally bind state

  [With-local-stobj]
      Locally bind a single-threaded object

  [With-output-lock]
      Provides a mutual-exclusion mechanism for performing output in
      parallel

  [With-serialize-character]
      Control output mode for print-object$

  [With-stolen-alist]
      (with-stolen-alist name form) ensures that name is a fast alist at
      the start of the execution of form.  At the end of execution,
      it ensures that name is a fast alist if and only if it was
      originally.  That is, if name was not a fast alist originally,
      its hash table link is freed, and if it was a fast alist
      originally but its table was modified during the execution of
      form, that table is restored.  Note that any extended table
      created from the original fast alist during form must be
      manually freed.

  [Without-evisc]
      Print output in full

  [Xor]
      Logical ``exclusive or''

  [Zerop]
      Test an acl2-number against 0

  [Zip]
      Testing an ``integer'' against 0

  [Zp]
      Testing a ``natural'' against 0

  [Zpf]
      Testing a nonnegative fixnum against 0")
 (ACL2-COUNT
  (BASICS ACL2-BUILT-INS)
  "A commonly used measure for justifying recursion

  (Acl2-count x) returns a nonnegative integer that indicates the
  ``size'' of its argument x.

  All [characters] and symbols have acl2-count 0.  The acl2-count of a
  string is the number of [characters] in it, i.e., its length.  The
  acl2-count of a [cons] is one greater than the sum of the
  acl2-counts of the [car] and [cdr].  The acl2-count of an integer
  is its absolute value.  The acl2-count of a rational is the sum of
  the acl2-counts of the numerator and denominator.  The acl2-count
  of a complex rational is one greater than the sum of the
  acl2-counts of the real and imaginary parts.

  Function: <acl2-count>

    (defun acl2-count (x)
           (declare (xargs :guard t))
           (if (consp x)
               (+ 1 (acl2-count (car x))
                  (acl2-count (cdr x)))
               (if (rationalp x)
                   (if (integerp x)
                       (integer-abs x)
                       (+ (integer-abs (numerator x))
                          (denominator x)))
                   (if (complex/complex-rationalp x)
                       (+ 1 (acl2-count (realpart x))
                          (acl2-count (imagpart x)))
                       (if (stringp x) (length x) 0)))))")
 (ACL2-CUSTOMIZATION
  (MISCELLANEOUS)
  "File of initial commands for ACL2 to run at [startup]

  ACL2 provides a mechanism to load automatically a so-called ``ACL2
  customization file,'' via [ld], the first time [lp] is called in an
  ACL2 session.  ACL2 looks for this file as follows.

   1. If the host Lisp reads a non-empty value for the system's environment
      variable ACL2_CUSTOMIZATION, then that string value is used for
      the customization file name.  In this case, if the file does
      not exist or if the string is \"NONE\" then there is no
      customization file.  Notes:
        * If the customization file name is a relative pathname (see
          [pathname]), then the pathname is considered relative to
          the connected book directory (see [cbd]).
        * If this variable is not already defined, then its value is set to
          NONE when books are certified using [build::cert.pl] or
          other, legacy Make-based certification tools.

   2. Otherwise (empty environment variable value), file
      \"acl2-customization.lsp\" or \"acl2-customization.lisp\" on the
      connected book directory (see [cbd]), generally the current
      directory, is the customization file (in that order) if either
      exists.
   3. Otherwise file \"acl2-customization.lsp\" or \"acl2-customization.lisp\"
      on your home directory is the customization file (in that
      order), if either exists (except, this case is skipped on
      Windows operating systems.

  Except for the fact that this [ld] command is not typed explicitly by
  you, it is a standard [ld] command except that any settings of [ld]
  specials are remembered once this call of [ld] has completed other
  than [ld-error-action], which will always be :command-conventions
  after that call of ld completes.  For example, suppose that you
  start your customization file with (set-ld-skip-proofsp t state),
  so that proofs are skipped as it is loaded with [ld].  Then the
  [ld] special [ld-skip-proofsp] will remain t after the [ld] has
  completed, causing proofs to be skipped in your ACL2 session,
  unless your customization file sets this variable back to nil, say
  with (set-ld-skip-proofsp nil state).

  If the customization file exists, it is loaded with [ld] using the
  usual default values for the [ld] specials (see [ld]) except that
  :ld-error-action is :error.  If an error is encountered, then no
  subsequent forms in the file will be evaluated and ACL2 will quit
  immediately.

  To create a customization file it is recommended that you first give
  it a name other than \"acl2-customization.lsp\" or
  \"acl2-customization.lisp\" so that ACL2 does not try to include it
  prematurely when you next enter [lp].  Then, while in the
  uncustomized [lp], explicitly invoke [ld] on your evolving (but
  renamed) customization file until all forms are successfully
  evaluated.  The same procedure is recommended if for some reason
  ACL2 cannot successfully evaluate all forms in your customization
  file: temporarily rename your customization file so that ACL2 does
  not try to [ld] it automatically and then debug the new file by
  explicit calls to [ld].

  WARNING!  If you certify a book after the (automatic) loading of a
  customization file, the forms in that file will be part of the
  [portcullis] of the [books] you certify!  That is, the forms in
  your customization file at certification time will be loaded
  whenever anybody uses the [books] you are certifying.  Since
  customization files generally contain idiosyncratic [command]s, you
  may not want yours to be part of the [books] you create for others.
  Thus, if you have a customization file then you may want to invoke
  :[ubt] 1 before certifying any [books]; alternatively, see
  [certify-book!] for automatic invocation of [ubt].

  On the other hand, if you wish to prevent undoing commands from the
  customization file, see [reset-prehistory].

  Note that except on Windows-based systems, if there is a file
  acl2-init.lsp in your home directory, then it will be loaded into
  raw Lisp when ACL2 is invoked.


Silent loading of ACL2 customization files

  When the environment variable ACL2_CUSTOMIZATION_QUIET is set and not
  \"\", there will generally be no output from ACL2 customization.  A
  special value of \"all\" for this variable will cause continued
  minimal output after startup, as explained in the following remark.

  Technical Remark.  For quiet loading of acl2-customization files,
  [ld] specials are bound to the following values.

    ld-verbose = nil
    ld-pre-eval-print = :never
    ld-post-eval-print = nil
    ld-prompt = nil

  These ld specials are returned to their normal values after loading
  an ACL2 customization file, with one exception: if
  ACL2_CUSTOMIZATION_QUIET has value \"ALL\" (or \"all\"; the case is
  irrelevant), then those values are retained in the ACL2 loop even
  after customization completes.")
 (ACL2-DEFAULTS-TABLE
  (TABLE)
  "A [table] specifying certain defaults, e.g., the default [defun-mode]

    Example Forms:
    (table acl2-defaults-table :defun-mode) ; current default defun-mode
    (table acl2-defaults-table :defun-mode :program)
               ; set default defun-mode to :program

  See [table] for a discussion of tables in general.  The legal keys
  for this [table] are shown below.  They may be accessed and changed
  via the general mechanisms provided by [table]s.  However, there
  are often more convenient ways to access and/or change the
  defaults.  (See also the note below.)

    :user

  The :user key is for ACL2 users; the system does not consult this key
  or set it (other than as part of general acl2-defaults-table
  maintenance).  Its value is required to be an association list
  ([alistp]), so that different users can read and write their
  ``own'' keys.  For example, suppose user Joe uses key :j while user
  Mary uses key :m; then we could see a value for :user of ((:j . 3)
  (:m . 4)) after Joe sets his value to 3 and Mary sets her value to
  4.

    :defun-mode

  the default [defun-mode], which must be :[program] or :[logic].  See
  [defun-mode] for a general discussion of [defun-mode]s.  The
  :[defun-mode] key may be conveniently set by keyword commands
  naming the new [defun-mode], :[program] and :[logic].  See
  [program] and see [logic].

    :enforce-redundancy

  if t, cause ACL2 to insist that most events are redundant (see
  [redundant-events]); if :warn, cause a warning instead of an error
  for such non-redundant events; else, nil.  See
  [set-enforce-redundancy].

    :verify-guards-eagerness

  an integer between 0 and 2 indicating how eager the system is to
  verify the [guard]s of a [defun] event.  See
  [set-verify-guards-eagerness].

    :compile-fns

  When this key's value is t, functions are compiled when they are
  [defun]'d; otherwise, the value is nil.  (Except, this key's value
  is ignored when explicit compilation is suppressed; see
  [compilation].)  To set the flag, see [set-compile-fns].

    :measure-function

  the default measure function used by [defun] when no :measure is
  supplied in [xargs].  The default measure function must be a
  function symbol of one argument. Let mfn be the default measure
  function and suppose no :measure is supplied with some recursive
  function definition.  Then [defun] finds the first formal, var,
  that is tested along every branch and changed in each recursive
  call.  The system then ``guesses'' that (mfn var) is the :measure
  for that [defun].

    :well-founded-relation

  the default well-founded relation used by [defun] when no
  :well-founded-relation is supplied in [xargs].  The default
  well-founded relation must be a function symbol, rel, of two
  arguments about which a :well-founded-relation rule has been
  proved.  See [well-founded-relation-rule].

    :bogus-defun-hints-ok

  When this key's value is t, ACL2 allows :hints and also :measure for
  nonrecursive function definitions.  Otherwise, the value is nil
  (the default) or :warn (which makes the check but merely warns when
  the check fails).  See [set-bogus-defun-hints-ok] and
  [set-bogus-measure-ok].

    :bogus-mutual-recursion-ok

  When this key's value is t, ACL2 skips the check that every function
  in a [mutual-recursion] (or [defuns]) ``clique'' calls at least one
  other function in that ``clique.'' Otherwise, the value is nil (the
  default) or :warn (which makes the check but merely warns when the
  check fails).  See [set-bogus-mutual-recursion-ok].

    :irrelevant-formals-ok

  When this key's value is t, the check for irrelevant formals is
  bypassed; otherwise, the value is the keyword nil (the default) or
  :warn (which makes the check but merely warns when the check
  fails).  See [irrelevant-formals] and see
  [set-irrelevant-formals-ok].

    :ignore-ok

  When this key's value is t, the check for ignored variables is
  bypassed; otherwise, the value is the keyword nil (the default) or
  :warn (which makes the check but merely warns when the check
  fails).  See [set-ignore-ok].

    :bdd-constructors

  This key's value is a list of function symbols used to define the
  notion of ``BDD normal form.'' See [bdd-algorithm] and see [hints].

    :ttag

  This key's value, when non-nil, allows certain operations that extend
  the trusted code base beyond what is provided by ACL2.  See
  [defttag].  See [defttag].

    :state-ok

  This key's value is either t or nil and indicates whether the user is
  aware of the syntactic restrictions on the variable symbol STATE.
  See [set-state-ok].

    :backchain-limit

  This key's value is a list of two ``numbers.'' Either ``number'' may
  optionally be nil, which is treated like positive infinity.  The
  numbers control backchaining through hypotheses during type-set
  reasoning and rewriting.  See [backchain-limit].

    :default-backchain-limit

  This key's value is a list of two ``numbers.'' Either ``number'' may
  optionally be nil, which is treated like positive infinity.  The
  numbers are used respectively to set the backchain limit of a rule
  if one has not been specified. See [backchain-limit].

    :step-limit

  This key's value is either nil or a natural number not exceeding the
  value of *default-step-limit*.  If the value is nil or the value of
  *default-step-limit*, there is no limit on the number of ``steps''
  that ACL2 counts during a proof: currently, the number of top-level
  rewriting calls.  Otherwise, the value is the maximum number of
  such calls allowed during evaluation of any event.  See
  [set-prover-step-limit].

    :rewrite-stack-limit

  This key's value is a nonnegative integer less than (expt 2 28).  It
  is used to limit the depth of calls of ACL2 rewriter functions.
  See [rewrite-stack-limit].

    :let*-abstractionp

  This key affects how the system displays subgoals.  The value is
  either t or nil.  When t, let* expressions are introduced before
  printing to eliminate common subexpressions.  The actual goal being
  worked on is unchanged.

    :case-split-limitations

  This key's value is a list of two ``numbers.'' Either ``number'' may
  optionally be nil, which is treated like positive infinity.  The
  numbers control how the system handles case splits in the
  simplifier.  See [set-case-split-limitations].

    :include-book-dir-alist

  This key's value is used by [include-book]'s :DIR argument to
  associate a directory with a keyword.  An exception is the keyword
  :SYSTEM for the books/ directory; see [include-book], in particular
  the section on ``Books Directory.'' Also see [add-include-book-dir]
  and [add-include-book-dir!].

    :match-free-default

  This key's value is either :all, :once, or nil.  See
  [set-match-free-default].

    :match-free-override

  This key's value is a list of runes.  See [add-match-free-override].

    :match-free-override-nume

  This key's value is an integer used in the implementation of
  [add-match-free-override], so that only existing runes are affected
  by that event.

    :non-linearp

  This key's value is either t or nil and indicates whether the user
  wishes ACL2 to extend the linear arithmetic decision procedure to
  include non-linear reasoning.  See [non-linear-arithmetic].

    :tau-auto-modep

  This key's value is either t or nil and indicates whether the user
  wishes ACL2 to look for opportunities to create :[tau-system] rules
  from all suitable defuns and from all suitable defthms (with
  non-nil :[rule-classes]).  See [set-tau-auto-mode].

    :ruler-extenders

  This key's value may be a list of symbols, indicating those function
  symbols that are not to block the collection of rulers; see
  [defun].  Otherwise the value is :all to indicate all function
  symbols, i.e., so that no function symbol blocks the collection of
  rulers.  If a list is specified (rather than :all), then it may
  contain the keyword :lambdas, which has the special role of
  specifying all lambda applications.  No other keyword is permitted
  in the list.  See [rulers].

    :memoize-ideal-okp

  This key's value must be either t, nil, or :warn.  If the value is
  nil or not present, then it is illegal by default to [memoize] a
  :[logic] mode function that has not been [guard]-verified (see
  [verify-guards]), sometimes called an ``ideal-mode'' function.
  This illegality is the default because such calls of such functions
  in the ACL2 loop are generally evaluated in the logic (using
  executable counterpart definitions; see [evaluation]), rather than
  directly by executing calls of the corresponding (memoized) raw
  Lisp function.  However, such a raw Lisp call can be made when the
  function is called by a :[program] mode function, so we allow you
  to override the default behavior by associating the value t or
  :warn with the key :memoize-ideal-okp, where with :warn you get a
  suitable warning.  Note that you can also allow memoization of
  ideal-mode functions by supplying argument :ideal-okp to your
  memoization event (see [memoize]), in which case the value of
  :memoize-ideal-okp in the acl2-defaults-table is irrelevant.

    :check-invariant-risk

  For an explanation of this key, see [set-check-invariant-risk].

    :register-invariant-risk

  For an explanation of this key, see [set-register-invariant-risk].

    :in-theory-redundant-okp

  When this key's value is t, an [in-theory] event may be redundant.
  See [set-in-theory-redundant-okp].

  Note: Unlike all other [table]s, acl2-defaults-table can affect the
  soundness of the system.  The [table] mechanism therefore enforces
  on it a restriction not imposed on other [table]s: when [table] is
  used to update the acl2-defaults-table, the key and value must be
  variable-free forms.  Thus, while

    (table acl2-defaults-table :defun-mode :program),

    (table acl2-defaults-table :defun-mode ':program), and

    (table acl2-defaults-table :defun-mode (compute-mode *my-data*))

  are all examples of legal [events] (assuming compute-mode is a
  function of one non-[state] argument that produces a [defun-mode]
  as its single value),

    (table acl2-defaults-table :defun-mode (compute-mode (w state)))

  is not legal because the value form is [state]-sensitive.

  Consider for example the following three [events] which one might
  make into the text of a book.

    (in-package \"ACL2\")

    (table acl2-defaults-table
      :defun-mode
      (if (ld-skip-proofsp state) :logic :program))

    (defun crash-and-burn (x) (car x))

  The second event is illegal because its value form is
  [state]-sensitive.  If it were not illegal, then it would set the
  :[defun-mode] to :[program] when the book was being certified but
  would set the [defun-mode] to :[logic] when the book was being
  loaded by [include-book].  That is because during certification,
  [ld-skip-proofsp] is nil (proof obligations are generated and
  proved), but during book inclusion [ld-skip-proofsp] is non-nil
  (those obligations are assumed to have been satisfied.)  Thus, the
  above book, when loaded, would create a function in :[logic] mode
  that does not actually meet the conditions for such status.

  For similar reasons, [table] [events] affecting acl2-defaults-table
  are illegal within the scope of [local] forms.  That is, the text

    (in-package \"ACL2\")

    (local (table acl2-defaults-table :defun-mode :program))

    (defun crash-and-burn (x) (car x))

  is illegal because acl2-defaults-table is changed locally.  If this
  text were acceptable as a book, then when the book was certified,
  crash-and-burn would be processed in :[program] mode, but when the
  certified book was included later, crash-and-burn would have
  :[logic] mode because the [local] event would be skipped.

  The text

    (in-package \"ACL2\")

    (program) ;which is (table acl2-defaults-table :defun-mode :program)

    (defun crash-and-burn (x) (car x))

  is acceptable and defines crash-and-burn in :[program] mode, both
  during certification and subsequent inclusion.

  We conclude with important observations about the interaction of the
  acl2-defaults-table with [include-book], [certify-book], and
  [encapsulate].  If the acl2-defaults-table has value V and you
  evaluate a call of [include-book], [certify-book], or
  [encapsulate], then the acl2-defaults-table has value V when that
  call returns.  Thus, if you want to set the acl2-defaults-table in
  a way that persists, you need to do so using [command]s that are
  not inside [books].  It may be useful to set your favorite defaults
  in your [ACL2-customization] file; see [ACL2-customization].

  ACL2 disallows (for logical reasons) setting of the
  acl2-defaults-table in the context of LOCAL.  Often it is easy
  simply to avoid wrapping an acl2-defaults-table event, or a macro
  that generates such an event, inside a LOCAL; after all, a local
  context is not useful when setting the acl2-defaults-table, since
  that table is restored as discussed above upon completion of
  [include-book], [certify-book], and [encapsulate] forms.
  Occasionally a bit more thought is required to work around this
  restriction, but usually it's not difficult to do so.  Suppose for
  example that you attempt to put following event form into a book.

    (local (progn (defttag t) (defun foo (x) (sys-call x nil))))

  ACL2 responds with the following error message.

    ACL2 Error in ( PROGN (DEFTTAG T) ...):  The form (DEFTTAG T)
    is not an embedded event form in the context of LOCAL
    because it implicitly sets the acl2-defaults-table in
    a local context; see :DOC acl2-defaults-table, in particular
    the explanation about this error message.  See :DOC
    embedded-event-form.

  A solution is to use [encapsulate] instead of (or in addition to)
  [progn], because [encapsulate] establishes a new context that is
  not considered within a surrounding LOCAL.  For example, the
  following replacement for the form above is legal in a book.

    (local (encapsulate () (defttag t) (defun foo (x) (sys-call x nil))))

  To see that this works, try creating a file \"foo.lisp\" whose first
  form is (in-package \"ACL2\") and whose only other form is the one
  displayed just above.  Then the command (certify-book \"foo\" 0 t
  :ttags :all) will successfully certify that book.")
 (ACL2-DOC
  (DOCUMENTATION)
  "A custom Emacs browser for reading ACL2 [documentation]

  As discussed elsewhere (see [documentation]), the web-based
  {ACL2+Books Manual |
  http://www.cs.utexas.edu/users/moore/acl2/v8-5/combined-manual/index.html}
  provides a way to browse the combined documentation for the ACL2
  system and community books.  Such documentation can also be read at
  the terminal using the :[doc] command, though documentation for
  [books] will only be included for those books that have been
  included in the session.  In this topic we describe how to browse
  the documentation using ACL2-Doc, a browser for reading
  documentation inside Emacs.  It supports reading the combined
  documentation (ACL2 plus books), but it also supports reading the
  ACL2-only manual as well as custom manuals.  We assume some
  familiarity with Emacs, for example, the notion of a ``prefix
  argument'': a numeric value given first with the meta key (or,
  probably the control key), for example, meta-0 control-t g or
  control-3 control-t /.

  While ACL2-Doc is much like Emacs Info, it is a separate system that
  provides some additional functionality.  ACL2-Doc is text-based.
  Any word that names a topic is a link: you can hit the <Return> key
  while standing on that topic to go to the page of documentation for
  that topic.  However, many links are shown explicitly, inside
  square brackets.  For example, here is a link that will take you to
  the BOOKS topic; it should show up surrounded by square brackets if
  you are now reading at the terminal or in ACL2-Doc, but there are
  no square brackets for this link if you are reading on the web.

      [books]

  It should be very rare for square brackets to be intended simply as
  square brackets, not as link indicators.

  In order to use ACL2-Doc, load into Emacs the distributed file
  acl2-doc.el from an appropriate directory; see [emacs].  This will
  happen automatically if you load emacs-acl2.el from an appropriate
  directory; again, see [emacs].  Then to start the browser at the
  top-level topic, either execute the Emacs command

    meta-x acl2-doc

  or else type:

    Control-t g

  Thus, you can put the following form in your .emacs file if you want
  acl2-doc to run automatically when Emacs starts up.

    (acl2-doc)

  By default you will browse the ACL2+Books Manual, though if you are
  using a git version between ACL2 releases then you may be queried;
  more on that below.  Or, see below for how to set a variable in
  your .emacs file, *acl2-doc-manual-name*, so that you will browse a
  custom manual.  You can enter the ACL2-Doc browser at a specific
  documentation topic as follows (in analogy to Emacs command
  Meta-.):

    Control-t .

  In each of the cases above, you will now be in a buffer called
  \"acl2-doc\", which will be displaying the top-level ACL2 topic in a
  special mode, the ACL2-Doc major mode.  That mode provides the
  following key bindings; you can also see these by typing Control-h
  m while in that buffer.

    <Return>        acl2-doc-go!
    Shift-<Return>  acl2-doc-go!-new-buffer
    g               acl2-doc-go
    h               acl2-doc-help
    ?               acl2-doc-summary
    i               acl2-doc-index
    ,               acl2-doc-index-next
    <               acl2-doc-index-previous
    l               acl2-doc-last
    n               acl2-doc-search-next
    p               acl2-doc-search-previous
    q               acl2-doc-quit
    K               acl2-doc-kill-buffers
    r               acl2-doc-return
    s               acl2-doc-search
    S               acl2-doc-re-search
    t               acl2-doc-top
    u               acl2-doc-up
    w               acl2-doc-where
    SPC             scroll-up
    TAB             acl2-doc-tab
    <backtab> (which often is Shift-TAB):
                    acl2-doc-tab-back
    D               acl2-doc-rendered-combined-download
    H               acl2-doc-history
    I               acl2-doc-initialize
    /               acl2-doc-definition
    Control-t /     acl2-doc-definition
    W               acl2-doc-where-definition

  You can see the documentation for each of these in the usual way,
  using Control-h k {key} or Control-h f {command}.  Here is what you
  will find in each case if you do that.

    <Return>      acl2-doc-go!
       Go to the topic occurring at the cursor position.  In the case
       of <NAME>, instead go to the source code definition of NAME for
       the current manual (as for `/', but without a minibuffer query).

    Shift-<Return>  acl2-doc-go!-new-buffer
       Go to the topic occurring at the cursor position in a new buffer.  In the
       case of <NAME>, instead go to the source code definition of NAME for the
       current manual (as for `/', but without a minibuffer query).

    g             acl2-doc-go
       Go to the specified topic; performs completion.

    h             acl2-doc-help
       Go to the ACL2-DOC topic to read about how to use the ACL2-Doc browser.

    ?             acl2-doc-summary
       Go to the ACL2-Doc-summary topic for one-line summaries of ACL2-Doc
       browser commands.

    i             acl2-doc-index
       Go to the specified topic or else one containing it as a substring;
       performs completion.  If the empty string is supplied, then go to the
       index buffer.  Otherwise, with prefix argument, consider only descendents
       of the topic supplied in response to a prompt.  Note that the index buffer
       is in ACL2-Doc mode; thus, in particular, you can type <RETURN> while
       standing on a topic in order to go directly to that topic.

    ,             acl2-doc-index-next
       Find the next topic containing, as a substring, the topic of the most
       recent i command.  Note: if this is the first \",\" or \"<\" after an
       exact match from \"i\", then start the topic search alphabetically from
       the beginning, but avoid a second hit on the original topic.  Also note
       that this command is buffer-local; it will follow the most recent i
       command executed in the current ACL2-Doc buffer.

    <             acl2-doc-index-previous
       Find the previous topic containing, as a substring, the topic of the most
       recent i command.  Note: if this is the first \",\" or \"<\" after an
       exact match from \"i\", then start the topic search alphabetically
       (backwards) from that exact match.  Also note that this command is
       buffer-local like the \",\" command.

    l             acl2-doc-last
       Go to the last topic visited in the current buffer.  This command is
       buffer-local.

    n             acl2-doc-search-next
       Find the next occurrence for the most recent search or regular expression
       search.  Note that this command is buffer-local; it will follow the most
       recent search initiated in the current buffer.

    p             acl2-doc-search-previous
       Find the previous occurrence for the most recent search or regular
       expression search.  Note: as for \"n\", the cursor will end up at the end
       of the match, and this command is buffer-local.

    q             acl2-doc-quit
       Quit the current ACL2-Doc buffer.

    K             acl2-doc-kill-buffers
       Kill all background ACL2-Doc buffers.  If invoked in an ACl2-Doc buffer,
       all ACl2-Doc buffers except the current one will be killed.  If invoked in
       any other buffer, all ACL2-Doc buffers will be killed.  With prefix
       argument, avoid a query that asks for confirmation.

    r             acl2-doc-return
       Return to the last topic visited in the current buffer, popping the stack
       of such topics.  This command is buffer-local.

    s             acl2-doc-search
       Search forward from the top of the manual for the input string.  If the
       search succeeds, then go to that topic with the cursor put immediately
       after the found text, with the topic name displayed in the minibuffer.
       With prefix argument, consider (also for subsequent \"n\" and \"p\"
       commands) only descendents of the topic supplied in response to a prompt.

    S             acl2-doc-re-search
       Perform a regular expression search, forward from the top of the manual,
       for the input string.  If the search succeeds, then go to that topic with
       the cursor put immediately after the found text, with the topic name
       displayed in the minibuffer.  With prefix argument, consider (also for
       subsequent \"n\" and \"p\" commands) only descendents of the topic
       supplied in response to a prompt.

    t             acl2-doc-top
       Go to the top topic.

    u             acl2-doc-up
       Go to the parent of the current topic.

    w             acl2-doc-where
       Display the topic name in the minibuffer, together with the manual name
       (ACL2+Books Manual or ACL2 User's Manual)

    SPC           scroll-up
       Scroll up (same as Control-v)

    TAB           acl2-doc-tab
       Visit the next link after the cursor on the current page, searching from
       the top if no link is below the cursor.

    <backtab> (which often is Shift-TAB):
                  acl2-doc-tab-back
       Visit the previous link before the cursor on the current page, searching
       from the bottom if no link is below the cursor.

    D
       Download the ``bleeding edge'' ACL2+Books Manual from the web; then
       restart the ACL2-Doc browser to view that manual.  If this fails,
       evaluate Emacs variable acl2-doc-download-error for information on
       how to perform the download without Emacs.

    H             acl2-doc-history
       Visit a buffer that displays the names of all topics visited (in any
       ACL2-Doc buffer) in order, newest at the bottom.  That buffer is in
       acl2-doc mode; thus the usual acl2-doc commands may be used.  In
       particular, you can visit a displayed topic name by putting your cursor on
       it and typing <RETURN>.

    I             acl2-doc-initialize
       Restart the ACL2-Doc browser, clearing its state.  With a prefix argument,
       a query asks you to select the name of an available manual, using
       completion.  See the section on \"Selecting a Manual\", below,
       for more information.

    /             acl2-doc-definition
    (also control-t /)
       Find an ACL2 definition (in analogy to built-in Emacs command meta-.).
       With numeric prefix argument, find the next matching definition;
       otherwise, the user is prompted, where the default is the name at
       the cursor, obtained after stripping off any enclosing square
       brackets ([..]), angle brackets (<..>) as from srclink tags, and
       package prefixes.  With control-u prefix argument, search only
       ACL2 source definitions; otherwise, books are searched as well.
       As with built-in Emacs command meta-. , exact matches are given
       priority.  For more information, see the Section on \"Selecting a
       Manual\" in the acl2-doc online XDOC-based documentation.

    W             acl2-doc-where-definition
       Find an ACL2 definition.  This is the same as
       acl2-doc-definition (the acl2-doc `/' command, as well as
       control-t /), except that the default comes from the name of the
       current page's topic instead of the cursor position.  Searches
       are continued identically when control-t / is given a numeric
       prefix argument, regardless of whether the first command was /,
       control-t /, or W; thus, a search started with W can be continued
       with, for example, meta-3 control-t /.

  Selecting a Manual, Tags Files, and Custom Manuals

  ACL2-Doc can display the ACL2 User's Manual, which includes
  documentation for the ACL2 system but not for the
  [community-books].  But by default, ACL2-Doc will display the
  ACL2+Books Manual, which includes documentation for those books as
  well.  To change which of these two manuals you display, just give
  a prefix argument to the `I' command, as described briefly above.

  For the `/' and `W' commands, you will need tags table files.  These
  come with the ACL2 gzipped tarfile distribution, but if you obtain
  ACL2 from github then you will need to build them.  The file \"TAGS\"
  is used when these commands are given a prefix argument (to search
  only the ACL2 sources), and is generated when building the
  saved_acl2 executable with `make'.  Without a prefix argument the
  file \"TAGS-acl2-doc\" is used for searching both the ACL2 sources
  and the books, and is created automatically if you build the manual
  by certifying community book books/doc/top.lisp.  You can also
  build \"TAGS-acl2-doc\" by running the command
  bin/make-tags-acl2-doc.sh, or by building the ACL2 executable after
  setting variable TAGS_ACL2_DOC to a non-empty value other than SKIP
  either on the command line with `make' or, for example, by putting
  one of the following forms in your ~/.cshrc or ~/.bashrc,
  respectively.

    setenv TAGS_ACL2_DOC t

    export TAGS_ACL2_DOC=t

  If you are using a git version of ACL2 and the books, between
  releases, then you may need to download an extra file in order to
  browse the ACL2+Books Manual.  Most likely you will just answer y
  when queried about downloading the file when first using ACL2-Doc.
  If you want more details, see the last of the notes in the
  ``Notes'' section below.

  As mentioned above, you can give the `I' command a prefix argument in
  order to select a specific manual.  You will be asked for a name,
  which by default will be the most recently selected such name, if
  any.  As noted above, the only two manuals initially known to
  acl2-doc are the ACL2+Books Manual and the ACL2 User's Manual.
  These have the names `combined' and `acl2-only', respectively.  You
  can also tell acl2-doc about a custom manual, by evaluating (in
  Emacs) the following form, e.g., by adding it to your ~/.emacs file
  before starting Emacs.  Here, filename is the pathname of a file
  typically created by calling [xdoc::save-rendered].

    (extend-acl2-doc-manual-alist
     'name          ; the name of the manual
     filename       ; documentation source, typically of the form *doc*.lsp
     'top           ; the top node name, typically TOP
     printname      ; optional print name (user-level name) of manual
     url            ; optional URL of gzipped file to download into filename
     tags-file-name ; optional tags filename (from output of etags)
     acl2-tags-file-name ; as above, but without files from books/ directory
     )

  For example, acl2-doc is initially built with the following two
  forms, which is why you can respond to the query mentioned above
  with `combined' or `acl2-only'.

    (extend-acl2-doc-manual-alist
     'combined
     (concat *acl2-sources-dir*
             \"books/system/doc/rendered-doc-combined.lsp\")
     'TOP
     \"ACL2+Books Manual\"
     \"http://www.cs.utexas.edu/users/moore/acl2/manuals/current/rendered-doc-combined.lsp.gz\"
     (concat *acl2-sources-dir* \"TAGS-acl2-doc\")
     (concat *acl2-sources-dir* \"TAGS\"))

    (extend-acl2-doc-manual-alist
     'acl2-only
     (concat *acl2-sources-dir* \"doc.lisp\")
     'ACL2
     \"ACL2 User's Manual\"
     nil
     nil
     (concat *acl2-sources-dir* \"TAGS\"))

  Note that the first of these forms specifies the location of the
  \"TAGS-acl2-doc\" and \"TAGS\" files mentioned above, but the second
  only specifies \"TAGS\" since the second form is for an ACL2-only
  manual (no books).

  If you want a specific manual to come up when you first run acl2-doc
  in an Emacs session, you can put the following into your .emacs
  file, where 'name is the name a manual for which you have included
  a form (extend-acl2-doc-manual-alist 'name ...) in your .emacs
  file.

    (setq *acl2-doc-manual-name* 'name)

  Color

  By default, links (indeed, any text) in square brackets will be shown
  in blue.  You can customize this behavior by setting (e.g., in your
  .emacs file) the Emacs variable *acl2-doc-link-color* to the
  desired link color, or to nil if you don't want the links to be in
  color.  For example:

    (setq *acl2-doc-link-color* \"#FF0000\") ; red
    (setq *acl2-doc-link-color* \"Green\")   ; green
    (setq *acl2-doc-link-color* nil)         ; no special color for links

  Notes

    * You might find that when you attempt to follow some-broken-link, you
      find yourself at the [broken-link] topic.  If you are using the
      ACL2 User's Manual rather than the ACL2+Books Manual, the
      reason might be that some-broken-link is documented in a book,
      not in the ACL2 system.  In that case, the broken-link page
      will show you where to find that book; but if you want to read
      the documentation for some-broken-link in the ACL2-Doc browser,
      you can do so by switching to the ACL2+Books Manual.  See the I
      command, documented above.

    * Files with names ending in .acl2-doc will come up in ACL2-Doc mode.
      Thus, you may wish to save a file with that extension, for
      example bookmarks.acl2-doc, that contains your favorite
      bookmarks.  You may wish to use the history command (H) to
      obtain a list of names of visited topics, in order to create an
      initial such file.

    * Many commands offer defaults, and many offer completion.  The default
      is determined by cursor position: if the cursor is sitting on a
      letter of a documentation topic name, or on a space character
      immediately after it, then that name will be offered as the
      default.  Completion tips:

        * Completion is carried out with the usual emacs ``completing-read'';
          thus, for example, the character `?' is a help key, so if
          you want that character as part of your topic name, prefix
          it with control-q.  For example, after the `g' command you
          can go to the topic [mv?] by typing the character sequence
          <m,v,control-q ?>.
        * To find completions that have package prefixes, type a colon (:) in
          the front, and completion will show matching topics.  For
          example, \"g\" followed by \":rew\" and then two tabs will
          show, at least in recent versions of Emacs, a list of
          topics that includes \"ACL2-PC::REWRITE\".

    * Square brackets typically indicate documentation topic names, for
      example: [acl2-doc].  (As mentioned above, there are occasional
      exceptions, where square brackets are simply part of the
      intended documentation text.)  The square brackets are really
      there, for example when you are searching using \"s\", \"S\", or
      \"n\".  However, for purposes of determining the default name
      (see above), the only effect of the enclosing square brackets
      is to extend the region in which the default is offered.  For
      example, consider the string \"[acl2-doc]\": the default name of
      \"acl2-doc\" is offered if the cursor is on either square
      bracket.  But links have some idiosyncrasies.

       1. Topic names, including links `[..]' to topic names, are printed
          relative to the ACL2 package.  Especially in the case of
          the ACL2+Books Manual, you may therefore see links that
          include package prefixes.  Here, for example, is a sentence
          from the documentation for [gl] in the ACL2+Books Manual.

              We call these structures [gl::symbolic-objects].

          The \"gl\" package prefix allows commands to pick up
          \"gl::symbolic-objects\" as the name to use as a default, so
          that for example, hitting <Return> will take you to that
          topic.  But when reading the sentence, for best results you
          should ignore package prefixes.  So for example, you would
          read the sentence above as follows.

              We call these structures symbolic-objects.

       2. Inside ACL2-Doc, topic names that originally contained spaces now
          have underscores in place of the spaces.  So for example,
          the topic [ACL2-tutorial] in the ACL2+Books Manual contains
          a link to the topic originally named as follows.
          |Pages Written Especially for the Tours|
          This link shows up in the ACL2-Doc browser as:
          [Pages_Written_Especially_for_the_Tours].

      Of course, the web-based browser avoids these idiosyncrasies (see
      [xdoc::save]); in particular, that browser is best for
      ``Tours'' pages like the one shown above and its subtopics, in
      part because that way you may see images.  Hence the web-based
      browser may be more appropriate for some topics, and for those
      who have no particular preference for using Emacs to browse the
      documentation.

    * Searching using the \"s\" or \"S\" command is carried out by searching
      top-to-bottom in a hidden Emacs buffer that contains all of the
      documentation.  The topics are listed in the following order
      according to topic name:

       1. All topics whose names reside in the \"ACL2\" package;
       2. All topics whose names reside in the \"ACL2-PC\" package; and, for the
          ACL2+Books Manual,
       3. All other topics, sorted by [symbol-name] and then by
          [symbol-package-name].

    * You may be queried, regarding whether you want to browse the
      ACL2+Books Manual, which is preferred, or the ACL2 User's
      Manual, which omits documentation for the books.  Both of these
      manuals are based on files that you will have if you are using
      a released version of ACL2 (after Version 6.3).  But if you are
      using a {git version | https://github.com/acl2/acl2/}, then to
      use the ACL2+Books Manual you will need an extra file.  You can
      build this file yourself, as described below but you may prefer
      to download it: for example, when you start ACL2-Doc, you may
      be given the option of downloading {a tarball for the latest
      ``bleeding edge'' copy |
      http://www.cs.utexas.edu/users/moore/acl2/manuals/current/rendered-doc-combined.lsp.gz}
      and extracting into directory system/doc/ of your community
      books directory.  Indeed, the system will do all this for you
      if you answer y to that query.  Alternatively, you can insist
      on a download of a ``bleeding edge'' version by using the `D'
      command.  However, if you prefer to browse the ACL2 User's
      Manual (without the books), you can put the following form into
      your ~/.emacs file, above the form that loads the code for
      ACL2-Doc (see above).

          (defvar *acl2-doc-manual-name* 'acl2-only)

      If you prefer to build rendered-doc-combined.lsp yourself, you can
      do so as follows.

       1. Build ACL2:

              make

       2. Build the file books/system/doc/rendered-doc-combined.lsp while
          standing in the books/ directory, as follows.  If \"acl2\"
          invokes the ACL2 executable that you just built, then you
          may omit \"ACL2=acl2\" below; otherwise replace \"acl2\" by a
          suitable executable.  On a multi-core machine you may wish
          to use -j, e.g., make -j 4 ....

              cd books
              make doc/top.cert USE_QUICKLISP=1 ACL2=acl2")
 (ACL2-DOC-SUMMARY
  (DOCUMENTATION)
  "Summary of [ACL2-doc] commands

  See [ACL2-doc] for information about the custom Emacs browser for
  viewing ACL2 [documentation].  In the present topic we list the
  commands with extremely abbreviation documentation: only a single
  line for each.  For even briefer summaries, you can use the
  standard Emacs command, Control-h m.

    <Return>      acl2-doc-go!
       Go to the topic occurring at the cursor position.
    g             acl2-doc-go
       Go to the specified topic; performs completion.
    h             acl2-doc-help
       Go to the ACL2-Doc topic to read about how to use the ACL2-Doc browser.
    ?             acl2-doc-summary
       Go to the ACL2-Doc-summary topic for one-line summaries of commands.
    i             acl2-doc-index
       Go to the specified topic or else one containing it as a substring.
    ,             acl2-doc-index-next
       Continue to the next topic for the most recent i command.
    <             acl2-doc-index-previous
       Return to the preceding topic for the most recent i command.
    l             acl2-doc-last
       Go to the last topic visited.
    n             acl2-doc-search-next
       Find the next occurrence for the most recent search.
    p             acl2-doc-search-previous
       Find the previous occurrence for the most recent search.
    q             acl2-doc-quit
       Quit the ACL2-Doc browser.
    r             acl2-doc-return
       Return to the last topic visited, popping the stack of such topics.
    s             acl2-doc-search
       Search for the input string (with prefix arg: under a given topic).
    S             acl2-doc-re-search
       Regular-expression search (with prefix arg: under a given topic).
    t             acl2-doc-top
       Go to the top topic.
    u             acl2-doc-up
       Go to the parent of the current topic.
    w             acl2-doc-where
       Display the topic and manual name in the minibuffer.
    SPC           scroll-up
       Scroll up (same as Control-v)
    TAB           acl2-doc-tab
       Visit the next link on the current page.
    <backtab> (which often is Shift-TAB): acl2-doc-tab-back
       Visit the previous link on the current page.
    D
       Download the manual from the web; then restart ACL2-Doc.
    H             acl2-doc-history
       Visit the History buffer, with names of all visited topics in order.
    I             acl2-doc-initialize
       Restart ACL2-Doc.  With a prefix argument, choose which manual.
    /             acl2-doc-definition
       Find an ACL2 definition (in analogy to built-in Emacs command meta-.).
    W             acl2-doc-where-definition
       Find an ACL2 definition, with default from current page's topic.")
 (ACL2-HELP
  (ABOUT-ACL2)
  "The acl2-help mailing list

  You can email questions about ACL2 usage to the acl2-help mailing
  list: acl2-help@utlists.utexas.edu.  If you have more general
  questions about ACL2, for example, about projects completed using
  ACL2, you may prefer the acl2 mailing list,
  acl2@utlists.utexas.edu, which tends to have wider distribution.")
 (ACL2-NUMBER-LISTP
  (NUMBERS LISTS ACL2-BUILT-INS)
  "Recognizer for a true list of numbers

  The predicate acl2-number-listp tests whether its argument is a true
  list of numbers.

  Function: <acl2-number-listp>

    (defun acl2-number-listp (l)
           (declare (xargs :guard t))
           (cond ((atom l) (eq l nil))
                 (t (and (acl2-numberp (car l))
                         (acl2-number-listp (cdr l))))))")
 (ACL2-NUMBERP
  (NUMBERS ACL2-BUILT-INS)
  "Recognizer for numbers

  (acl2-numberp x) is true if and only if x is a number, i.e., a
  rational or complex rational number.")
 (ACL2-SEDAN
  (ACL2-TUTORIAL)
  "ACL2 Sedan interface

  Many successful ACL2 users run in an shell under Emacs; see [emacs].
  However, those not familiar with Emacs may prefer to start with an
  Eclipse-based interface initially developed by Peter Dillinger and
  Pete Manolios called the {ACL2 Sedan |
  http://acl2s.ccs.neu.edu/acl2s/doc/} or ``ACL2s''.

  ACL2 sessions in the ACL2 Sedan can utilize non-standard extensions
  and enhancements, especially geared toward new users, termination
  reasoning, and attaching rich user interfaces.  These extensions
  are {generally available |
  http://acl2s.ccs.neu.edu/acl2s/src/acl2-extensions} as certifiable
  ACL2 books.  (Some code originating from this project has been
  migrated to the ACL2 community books, but only after it was quite
  stable.)  Thanks to Peter Dillinger, Pete Manolios, Daron Vroon,
  and Harsh Raju Chamarthi for their work on the ACL2 Sedan and for
  making their books available to ACL2 users.")
 (ACL2-TUTORIAL
  (ACL2)
  "Tutorial introduction to ACL2

  To learn about ACL2, read at least the following two links.

    * Industrial Applications of ACL2 (see [INTERESTING-APPLICATIONS]) (10
      minutes) to help you understand what sophisticated users can
      do;
    * A Flying Tour (see [A_Flying_Tour_of_ACL2]) (10 minutes) to get an
      overview of the system and what skills the user must have.

  Alternatively, or in addition, there are [talks] that you can peruse,
  many of them introductory in nature.

  If you want to learn how to use ACL2, we recommend that you read a
  selection of the materials referenced below, depending on your
  learning style, and do suggested exercises.

    * A Walking Tour (see [A_Walking_Tour_of_ACL2]) (1 hour) provides an
      overview of the theorem prover.
    * The {Try ACL2 | http://tryacl2.org} web site provides interactive
      lessons to get you started using ACL2.
    * See [introduction-to-the-theorem-prover] (10-40 hours) for
      instruction on how to interact with the system.  Unlike the
      three documents above, this document expects you to think!  It
      cites the necessary background pages on programming in ACL2 and
      on the logic and then instructs you in [the-method], which is
      how expert users use ACL2.  It concludes with some challenge
      problems for the ACL2 beginner (including solutions) and an
      FAQ.  Most users will spend several hours a day for several
      days working through this material.
    * The book {Computer-Aided Reasoning: An Approach |
      http://www.cs.utexas.edu/users/moore/publications/acl2-books/car/index.html}
      is worth a careful read, as you work exercises and learn
      [the-method].
    * Annotated ACL2 Scripts and Demos (see [ANNOTATED-ACL2-SCRIPTS])
      contains relatively elementary proof scripts that have been
      annotated to help train the newcomer.
    * Many files (``books'') in the ACL2 community books (see
      [community-books]) are extensively annotated.
    * An Alternative Introduction (see [ALTERNATIVE-INTRODUCTION])
      document, while largely subsumed by the Introduction to the
      Theorem Prover (see [INTRODUCTION-TO-THE-THEOREM-PROVER])
      mentioned above, still might be useful because it covers much
      of the tutorial material in a different way.

  At this point you are probably ready to use ACL2 on your own small
  projects.  A common mistake for beginners is to browse the
  documentation and then try to do something that is too big!  Think
  of a very small project and then simplify it!

  Note that ACL2 has a very supportive user network.  See the link to
  ``Mailing Lists'' on the {ACL2 home page |
  http://www.cs.utexas.edu/users/moore/acl2}.

  The topics listed below are a hodge podge, developed over time.
  Although some of these are not mentioned above, you might find some
  to be useful as well.


Subtopics

  [ACL2-as-standalone-program]
      Calling ACL2 from another program

  [ACL2-sedan]
      ACL2 Sedan interface

  [Advanced-features]
      Some advanced features of ACL2

  [Alternative-introduction]
      Introduction to ACL2

  [Annotated-ACL2-scripts]
      Examples of ACL2 scripts

  [Emacs]
      Emacs support for ACL2

  [Interesting-applications]
      Some industrial examples of ACL2 use

  [Introduction-to-the-theorem-prover]
      How the theorem prover works --- level 0

  [Nqthm-to-ACL2]
      ACL2 analogues of Nqthm functions and commands

  [Pages_Written_Especially_for_the_Tours]
      Pages Written Especially for the Tours

  [Startup]
      How to start using ACL2; the ACL2 [command] loop

  [Talks]
      Some talks about ACL2

  [The-method]
      How to find proofs

  [Tidbits]
      Some basic hints for using ACL2

  [Tips]
      Some hints for using the ACL2 prover")
 (ACL2-UNWIND-PROTECT (POINTERS)
                      "See [system-utilities].")
 (ACL2-USER
  (PACKAGES)
  "A package the ACL2 user may prefer

  This package imports the standard Common Lisp symbols that ACL2
  supports and also a few symbols from package \"ACL2\" that are
  commonly used when interacting with ACL2.  You may prefer to select
  this as your current package so as to avoid colliding with ACL2
  system names.

  This package imports the symbols listed in
  *common-lisp-symbols-from-main-lisp-package*, which contains
  hundreds of CLTL function and macro names including those supported
  by ACL2 such as [cons], [car], and [cdr].  It also imports the
  symbols in *acl2-exports*, which contains a few symbols that are
  frequently used while interacting with the ACL2 system, such as
  [implies], [defthm], and [rewrite].  It imports nothing else.

  Thus, names such as [alistp], [member-equal], and [type-set], which
  are defined in the \"ACL2\" package are not present here.  If you
  find yourself frequently colliding with names that are defined in
  \"ACL2\" you might consider selecting \"ACL2-USER\" as your current
  package (see [in-package]).  If you select \"ACL2-USER\" as the
  current package, you may then simply type [member-equal] to refer
  to acl2-user::member-equal, which you may define as you see fit.
  Of course, should you desire to refer to the \"ACL2\" version of
  [member-equal], you will have to use the \"ACL2::\" prefix, e.g.,
  acl2::member-equal.

  If, while using \"ACL2-USER\" as the current package, you find that
  there are symbols from \"ACL2\" that you wish we had imported into it
  (because they are frequently used in interaction), please bring
  those symbols to our attention.  For example, should
  [union-theories] and [universal-theory] be imported?  Except for
  stabilizing on the ``frequently used'' names from \"ACL2\", we intend
  never to define a symbol whose [symbol-package-name] is
  \"ACL2-USER\".")
 (ACL2P-KEY-CHECKPOINTS
  (PARALLEL-PROOF)
  "Key checkpoints in ACL2(p)

  This [documentation] topic relates to the experimental extension of
  ACL2 supporting parallel execution and proof; see [parallelism].

  For printing output, the parallel version of the waterfall follows
  the precedent of [gag-mode].  The idea behind gag mode is to print
  only the subgoals most relevant to debugging a failed proof
  attempt.  These subgoals are called 'key checkpoints' (see
  [set-gag-mode] for the definition of ``key'' and ``checkpoint''),
  and we restrict the default output mode for the parallel version of
  the waterfall to printing checkpoints similar to these key
  checkpoints.

  As of this writing, we are aware of exactly one discrepancy between
  gag mode's key checkpoints and the parallel version of the
  waterfall's checkpoints.  This discrepancy occurs when using ``by''
  hints (see [hints]).  As an example, take the following form, which
  attempts to prove a non-theorem:

    (thm (equal (append x y z) (append z (append y x)))
         :hints ((\"Subgoal *1/2'''\" :by nil)))

  With waterfall parallelism enabled, Subgoal *1/2'' will be printed as
  a key checkpoint.  This is different from using [gag-mode] while
  running the serial version of the waterfall, which skips printing
  the subgoal as a checkpoint.

  For those familiar with the ACL2 waterfall, we note that the parallel
  version of the waterfall prints key checkpoints that are unproved
  in the following sense: a subgoal is a key checkpoint if it leads,
  in the current call of the waterfall, to a goal that is pushed for
  induction.")
 (ACL2S (POINTERS) "See [ACL2-sedan].")
 (ACL2_AS_AN_INTERACTIVE_THEOREM_PROVER
  (PAGES_WRITTEN_ESPECIALLY_FOR_THE_TOURS)
  "ACL2 as an Interactive Theorem Prover

  The ACL2 theorem prover finds proofs in the ACL2 logic.  It can be
  automatic.  But most often the user must help it.

  {IMAGE}

  The user usually guides ACL2 by suggesting that it first prove key
  lemmas.  Lemmas are just theorems used in the proofs of other
  theorems.")
 (ACL2_AS_AN_INTERACTIVE_THEOREM_PROVER_{CONT}
  (PAGES_WRITTEN_ESPECIALLY_FOR_THE_TOURS)
  "ACL2 as an Interactive Theorem Prover (cont)

  {IMAGE} (see [ACL2_System_Architecture])

  When ACL2 proves a lemma, it is converted into one or more rules and
  stored in a database.  The theorem prover is rule-driven.  By
  proving lemmas you can configure ACL2 to behave in certain ways
  when it is trying to prove formulas in a certain problem domain.
  The expert user can make ACL2 do amazingly ``smart'' looking
  things.

  But it would be wrong to think that ACL2 knows the mathematical
  content of a formula just because it has proved it.  What ACL2
  knows --- all ACL2 knows --- is what is encoded in its rules.
  There are many types of rules (see [rule-classes] {ICON} (see
  [A_Tiny_Warning_Sign])).

  Many formulas can be effectively coded as rules.  But by the same
  token, it is possible to encode a formula as a rule that is so
  ineffective it cannot even prove itself!

  The way a formula is stored as a rule is entirely up to the user.
  That is, you determine how ACL2 should use each formula that it
  proves.

  The most common kind of rule is the rewrite rule.  It is so common
  that if you don't tell ACL2 how to store a formula, it stores it as
  a rewrite rule.

  {IMAGE} (see [ACL2_System_Architecture])")
 (ACL2_CHARACTERS
  (PAGES_WRITTEN_ESPECIALLY_FOR_THE_TOURS)
  "ACL2 Characters

  ACL2 accepts 256 distinct characters, which are the characters
  obtained by applying the function [code-char] {ICON} (see
  [A_Tiny_Warning_Sign]) to each integer from 0 to 255.  Among these,
  Common Lisp designates certain ones as *standard-characters*,
  namely those of the form (code-char n) where n is from 33 to 126,
  together with #\\Newline and #\\Space.  The actual standard
  characters may be viewed by evaluating the constant expression
  *standard-chars*.

  The standard character constants are written by writing a hash mark
  followed by a backslash (#\\) followed by the character.

  The function [characterp] {ICON} (see [A_Tiny_Warning_Sign])
  recognizes characters.  For more details, See [characters] {ICON}
  (see [A_Tiny_Warning_Sign]).")
 (ACL2_CONSES_OR_ORDERED_PAIRS
  (PAGES_WRITTEN_ESPECIALLY_FOR_THE_TOURS)
  "ACL2 Conses or Ordered Pairs

  The function [cons] {ICON} (see [A_Tiny_Warning_Sign]) creates an
  ordered pair.  [Car] {ICON} (see [A_Tiny_Warning_Sign]) and [cdr]
  {ICON} (see [A_Tiny_Warning_Sign]) return the first and second
  components, respectively, of an ordered pair.  The function [consp]
  {ICON} (see [A_Tiny_Warning_Sign]) recognizes ordered pairs.

  Ordered pairs are used to represent lists and trees.  See any Common
  Lisp documentation for a discussion of how list constants are
  written and for the many list processing functions available.
  Also, see [programming] {ICON} (see [A_Tiny_Warning_Sign]) where we
  list all the ACL2 primitive functions.

  Here are some examples of list constants to suggest their syntax.

    '(a . b)                ; a pair whose car is 'a and cdr is 'b
    '(a . nil)              ; a pair whose car is 'a and cdr is nil
    '(a)                    ; another way to write the same thing
    '(a b)                  ; a pair whose car is 'a and cdr is '(b)
    '(a b c)                ; a pair whose car is 'a and cdr is '(b c)
                            ;  i.e., a list of three symbols, a, b, and c.
    '((a . 1) (b . 2))      ; a list of two pairs

  It is useful to distinguish ``proper'' conses from ``improper'' ones,
  the former being those cons trees whose right-most branch
  terminates with nil.  A ``true list'' (see [true-listp] {ICON} (see
  [A_Tiny_Warning_Sign])) is either nil or a proper cons.  (A b c .
  7) is an improper cons and hence not a true list.")
 (ACL2_IS_AN_UNTYPED_LANGUAGE
  (PAGES_WRITTEN_ESPECIALLY_FOR_THE_TOURS)
  "ACL2 is an Untyped Language

  The example

    ACL2 !>(app '(a b c) 27)
    (A B C . 27)

  illustrates the fact that ACL2's logic is untyped (click here (see
  [About_Types]) for a brief discussion of the typed versus untyped
  nature of the logic).

  The definition of app makes no restriction of the arguments to lists.
  The definition says that if the first argument satisfies [endp]
  {ICON} (see [A_Tiny_Warning_Sign]) then return the second argument.
  In this example, when app has recursed three times down the cdr of
  its first argument, '(a b c), it reaches the final nil, which
  satisfies endp, and so 27 is returned.  It is naturally consed into
  the emerging list as the function returns from successive recursive
  calls (since cons does not require its arguments to be lists,
  either).  The result is an ``improper'' list, (a b c . 27).

  You can think of (app x y) as building a binary tree by replacing the
  right-most tip of the tree x with the tree y.")
 (ACL2_STRINGS
  (PAGES_WRITTEN_ESPECIALLY_FOR_THE_TOURS)
  "ACL2 Strings

  Strings of ACL2 characters (see [ACL2_Characters]) are written as
  sequences of characters delimited by ``double quotation marks''
  (\").  To put a double quotation mark in a string (or, any other
  character such as backslash or newline that seems to cause
  problems), escape it by preceding it with a backslash (\\).

  The function [stringp] {ICON} (see [A_Tiny_Warning_Sign]) recognizes
  strings and [char] {ICON} (see [A_Tiny_Warning_Sign]) will fetch
  the nth character of a string.  There are many other primitives for
  handling strings, such as [string<] {ICON} (see
  [A_Tiny_Warning_Sign]) for comparing two strings lexicographically.
  We suggest you See [programming] {ICON} (see [A_Tiny_Warning_Sign])
  where we list all of the primitive ACL2 functions.  Alternatively,
  see any Common Lisp language documentation.")
 (ACL2_SYMBOLS
  (PAGES_WRITTEN_ESPECIALLY_FOR_THE_TOURS)
  "ACL2 Symbols

  Common Lisp's symbols are a data type representing words.  They are
  frequently regarded as atomic objects in the sense that they are
  not frequently broken down into their constituents.  Often the only
  important properties of symbols is that they are not numbers,
  characters, strings, or lists and that two symbols are not equal if
  they look different (!).  Examples of symbols include PLUS and
  SMITH::ABC.  All function and variable names in ACL2 are symbols.
  When symbols are used as constants they must be quoted, as in
  'PLUS.

  The symbol T is commonly used as the Boolean ``true.'' The symbol NIL
  is commonly used both as the Boolean ``false'' and as the ``empty
  list.'' Despite sometimes being called the ``empty list'' NIL is a
  symbol not an ``empty cons.'' Unlike other symbols, T and NIL may
  be used as constants without quoting them.

  Usually, symbols are written as sequences of alphanumeric characters
  other than those denoting numbers.  Thus, A12, +1A and 1+ are
  symbols but +12 is a number.  Roughly speaking, when symbols are
  read lower case characters are converted to upper case, so we
  frequently do not distinguish ABC from Abc or abc.  Click here (see
  [Conversion]) for information about case conversion when symbols
  are read.  However, any character can be used in a symbol, but some
  characters must be ``escaped'' to allow the Lisp reader to parse
  the sequence as a symbol.  For example, |Abc| is a symbol whose
  first character is capitalized and whose remaining characters are
  in lower case.  |An odd duck| is a symbol containing two #\\Space
  characters.  See any Common Lisp documentation for the syntactic
  rules for symbols.

  Technically, a symbol is a special kind of pair consisting of a
  package name (which is a string) and a symbol name (which is also a
  string).  (See [symbol-package-name] {ICON} (see
  [A_Tiny_Warning_Sign]) and see [symbol-name] {ICON} (see
  [A_Tiny_Warning_Sign]).)  The symbol SMITH::ABC is said to be in
  package \"SMITH\" and to have the symbol name \"ABC\".  The symbol ABC
  in package \"SMITH\" is generally not equal to the symbol ABC in
  package \"JONES\".  However, it is possible to ``import'' symbols
  from one package into another one, but in ACL2 this can only be
  done when the package is created.  (See [defpkg] {ICON} (see
  [A_Tiny_Warning_Sign]).)  If the [current-package] {ICON} (see
  [A_Tiny_Warning_Sign]) is \"SMITH\" then SMITH::ABC may be more
  briefly written as just ABC.  [Intern] {ICON} (see
  [A_Tiny_Warning_Sign]) ``creates'' a symbol of a given name in a
  given package.")
 (ACL2_SYSTEM_ARCHITECTURE
  (PAGES_WRITTEN_ESPECIALLY_FOR_THE_TOURS)
  "ACL2 System Architecture

  {IMAGE} (see [Rewrite_Rules_are_Generated_from_DEFTHM_Events])

  {IMAGE}

  The user interacts with the theorem prover by giving it definitions,
  theorems and advice.  Most often the advice is about how to store
  each proved theorem as a rule.  Sometimes the advice is about how
  to prove a specific theorem.

  The database consists of all the rules ACL2 ``knows.'' It is possible
  to include in the database all of the rules in some certified file
  of other events.  Such certified files are called [books] {ICON}
  (see [A_Tiny_Warning_Sign]).

  Interesting proofs are usually built on top of many books, some of
  which are written especially for that problem domain and others of
  which are about oft-used domains, like arithmetic or list
  processing.  ACL2's distribution includes many books written by
  users.  See the ``books'' link under the Lemma Libraries and
  Utilities {ICON} (see [A_Tiny_Warning_Sign]) link of the ACL2 home
  page.

  {IMAGE} (see [Rewrite_Rules_are_Generated_from_DEFTHM_Events])")
 (ACONS
  (ALISTS ACL2-BUILT-INS)
  "Constructor for association lists

  (Acons key datum alist) equals the result of consing the pair (cons
  key datum) to the front of the association list alist.

  (Acons key datum alist) has a [guard] of (alistp alist).  Acons is a
  Common Lisp function.  See any Common Lisp documentation for more
  information.

  Function: <acons>

    (defun acons (key datum alist)
           (declare (xargs :guard (alistp alist)))
           (cons (cons key datum) alist))")
 (ACTIVE-OR-NON-RUNEP
  (THEORIES)
  "Require a [rune] to exist, and check that it is [enable]d

  This variant of active-runep causes an error if its argument is not a
  [rune].  See [active-runep].")
 (ACTIVE-RUNEP
  (THEORIES)
  "Check that a [rune] exists and is [enable]d

    Example:
    (active-runep '(:rewrite left-to-right))

    General Form:
    (active-runep rune &optional strict)

  where rune has the shape of a [rune].  This macro expands to an
  expression using the variables ens and state, and returns non-nil
  when the given rune exists and is [enable]d (according to the given
  ``enabled structure,'' ens, and the current logical [world] of the
  given [state]).  See [theory-invariant] for how this macro can be
  of use.

  When the optional argument is nil or is omitted, then although the
  argument is required to have the shape of a [rune], it need not be
  a rune.  For example, if there is no rewrite rule named
  left-to-right, then (active-runep '(:rewrite left-to-right)) will
  simply return nil.  If instead you'd like this call to cause an
  error, use a non-nil optional argument or, equivalently, use
  [active-or-non-runep].")
 (ADD-BINOP
  (MACROS)
  "Associate a function name with a macro name

  The form (add-binop macro macro-fn) is an abbreviation for the form
  (add-macro-fn macro macro-fn t).  See [add-macro-fn].")
 (ADD-CUSTOM-KEYWORD-HINT
  (EVENTS)
  "Add a new custom keyword hint

    Examples:
    (add-custom-keyword-hint :my-hint (my-hint-fn val ...))

    (add-custom-keyword-hint :my-hint
                             (my-hint-fn val ...)
                             :checker (my-hint-checker-fn val ...))

    General Form:
    (add-custom-keyword-hint :key term1 :checker term2)

  where :key is a [keywordp] not among the primitive keyword hints
  listed in *hint-keywords*, the :checker argument is optional, and
  term1 and (if supplied) term2 are terms with certain free-variable
  and signature restrictions described below.  Henceforth, :key is
  treated as a custom keyword hint, e.g., the user can employ :key in
  hints to [defthm], such as:

    (defthm name ...
      :hints ((\"Subgoal *1/1'\" ... :key val ...))).

  Custom keyword hints are complicated.  To use them you must
  understand [state], multiple values (e.g., [mv] and [mv-let]),
  ACL2's notion of error triples (see [programming-with-state]), how
  to generate ``soft'' errors with [er], how to use [fmt]-strings to
  control output, how to use computed hints (see [computed-hints])
  and some aspects of ACL2's internal event processing.  Furthermore,
  it is possible to implement a custom keyword hint that can make an
  event non-reproducible!  So we recommend that these hints be
  developed by ACL2 experts.  Basically the custom keyword feature
  allows the implementors and other experts to extend the hint
  facility without modifying the ACL2 sources.

  Term1 is called the ``generator'' term and term2 is called the
  ``checker'' term of the custom keyword hint :key.  Together they
  specify the semantics of the new custom keyword hint :key.  Roughly
  speaking, when a custom keyword hint is supplied by the user, as in

    (defthm name ...
      :hints ((\"Subgoal *1/1'\" ... :my-hint val ...))).

  the checker term is evaluated on val to check that val is of the
  expected shape.  Provided val passes the check, the generator term
  is used to compute a standard hint.  Like computed hints, the
  generator of a custom keyword hint is allowed to inspect the actual
  clause on which it is being fired.  Indeed, it is allowed to
  inspect the entire list of hints (standard and custom) supplied for
  that clause.  Thus, in the most general case, a custom keyword hint
  is just a very special kind of computed hint.

  The generator, term1, must have no free variables other than:

    (val keyword-alist
     id clause world stable-under-simplificationp
     hist pspv ctx state).

  Moreover, either term1 must evaluate to a single non-[stobj] value,
  or else it must be single-threaded in state and have the standard
  [error-triple] output signature, (mv * * state).

  The restrictions on the checker, term2, are that it be
  single-threaded in state, have the standard [error-triple] output
  signature, (mv * * state), and have no free variables other than:

    (val world ctx state).

  For examples, see the community books directory books/hints/, in
  particular basic-tests.lisp.

  To delete a previously added custom keyword hint, see
  [remove-custom-keyword-hint].

  The community book hints/merge-hint.lisp can be useful in writing
  custom keyword hints.  See the examples near the of the file.

  Note: This is an event!  It does not print the usual event [summary]
  but nevertheless changes the ACL2 logical [world] and is so
  recorded.")
 (ADD-DEFAULT-HINTS
  (DEFAULT-HINTS)
  "Add to the default hints

    Examples:
    (add-default-hints '((computed-hint-1 clause)
                         (computed-hint-2 clause
                                          stable-under-simplificationp)))
    (add-default-hints '((computed-hint-3 id clause world))
                       :at-end t)

  Note: This is an event!  It does not print the usual event [summary]
  but nevertheless changes the ACL2 logical [world] and is so
  recorded.  It is [local] to the book or [encapsulate] form in which
  it occurs (see [add-default-hints!] for a corresponding non-[local]
  event).

    General Forms:
    (add-default-hints lst)
    (add-default-hints lst :at-end flg)

  where lst is a list.  Generally speaking, the elements of lst should
  be suitable for use as [computed-hints].

  This event is completely analogous to [set-default-hints], the
  difference being that add-default-hints appends the indicated hints
  to the front of the list of default hints, so that they are tried
  first --- or, if flg is supplied and evaluates to other than nil,
  at the end of the list, so that they are tried last --- rather than
  replacing the default hints with the indicated hints.  Each new
  hint is thus considered after each existing hints when both are
  applied to the same goal.  Also See [set-default-hints], see
  [remove-default-hints], and see [default-hints].

  Finally, note that the effects of set-default-hints,
  [add-default-hints], and [remove-default-hints] are [local] to the
  book in which they appear.  Thus, users who include a book with
  such forms will not have their default hints affected by such
  forms.  In order to export the effect of setting the default hints,
  use [set-default-hints!], [add-default-hints!], or
  [remove-default-hints!].

  For a related feature, which however is only for advanced system
  builders, see [override-hints].")
 (ADD-DEFAULT-HINTS!
  (DEFAULT-HINTS)
  "Add to the default hints non-[local]ly

  Please see [add-default-hints], which is the same as
  add-default-hints! except that the latter is not [local] to the
  [encapsulate] or the book in which it occurs.  Probably
  [add-default-hints] is to be preferred unless you have a good
  reason for wanting to export the effect of this event outside the
  enclosing [encapsulate] or book.")
 (ADD-DIVE-INTO-MACRO
  (DIVE-INTO-MACROS-TABLE)
  "Associate [proof-builder] diving function with macro name

    Examples:
    (add-dive-into-macro cat expand-address-cat)

  This feature is used so that the interactive [proof-builder]'s DV
  command and numeric diving commands (e.g., 3) will dive properly
  into subterms.  Please see [dive-into-macros-table].")
 (ADD-INCLUDE-BOOK-DIR
  (BOOKS-REFERENCE)
  "Link keyword for :dir argument of [ld] and [include-book]

    Example Forms:

    ; For (include-book \"foo\" :dir :smith), prepend \"/u/smith/\" to \"foo\".
    (add-include-book-dir :smith \"/u/smith/\")

    ; For (include-book \"bar\" :dir :util), prepend absolute directory pathname
    ; corresponding to the relative pathname, \"utilities/\".
    (add-include-book-dir :util \"utilities\")

  Note: This is an event!  It does not print the usual event [summary]
  but nevertheless changes the ACL2 logical [world] and is so
  recorded.  It is [local] to the book or [encapsulate] form in which
  it occurs.  See [add-include-book-dir!] for a corresponding
  non-[local] event.

    General Form:
    (add-include-book-dir kwd dir)

  where kwd is a [keywordp] and dir is a relative or absolute
  [pathname] for a directory, optionally using the syntax (:system .
  filename) described in [full-book-name].  If the final '/' is
  missing for the resulting directory, ACL2 will add it for you.  The
  effect of this event is to modify the meaning of the :dir keyword
  argument of [include-book] or [ld] as indicated by the examples
  above, that is, by associating the indicated directory with the
  indicated keyword for purposes of the :dir argument.  By the
  ``indicated directory'' we mean, in the case that the pathname is a
  relative pathname, the directory relative to the current connected
  book directory; see [cbd].  See [delete-include-book-dir] for how
  to undo this effect.

  For a keyword already associated with a directory string by a
  previous invocation of add-include-book-dir or
  [add-include-book-dir!], it is illegal to associate a different
  directory string until removing the existing association; see
  [delete-include-book-dir] (and see [delete-include-book-dir!] if
  the existing association was made by [add-include-book-dir!].  If
  however the new directory string is identical with the existing
  one, which was already assigned by add-include-book-dir, then the
  new call of add-include-book-dir will be redundant (see
  [redundant-events]).

  The keyword :system can never be redefined.  It will always point to
  the absolute pathname of the system books directory, which by
  default is immediately under the directory where the ACL2
  executable was originally built (see [include-book], in particular
  the discussion there of ``books directory'').

  This macro generates a [table] event that updates the table
  include-book-dir!-table, which associates keywords with absolute
  pathnames.  However, as with [add-include-book-dir], direct table
  updates are disallowed; you must use add-include-book-dir! to add
  to the table and [delete-include-book-dir!] to remove from the
  table.

  It is illegal to call add-include-book-dir! in a [local] context.
  (If you are tempted to do that, consider using
  [add-include-book-dir] instead.)  To understand this restriction,
  imagine a book that contains the following sequence of [events].

    (add-include-book-dir! :my-dir \"path/to/BAD/dir\")
    (local (delete-include-book-dir! :my-dir))
    (local (add-include-book-dir! :my-dir \"path/to/GOOD/dir\"))
    (include-book \"foo\" :dir :my-dir)
    (defthm f-def
      (equal (f x) x))

  During the first (proof) pass of [certify-book], the book
  path/to/GOOD/dir/foo.lisp will be included.  But on the second
  pass, the book path/to/BAD/dir/foo.lisp will be included.  Now
  imagine that the ``good'' version contains the event (defun f (x)
  x) but the ``bad'' version instead contains the event (defun f (x)
  (not x)).  Then we can easily prove nil from the theorem f-def!
  Although it is likely that [book-hash] values could catch this
  error at [include-book] time, we prefer not to rely on these for
  soundness.")
 (ADD-INCLUDE-BOOK-DIR!
  (BOOKS-REFERENCE)
  "Non-[local]ly link keyword for :dir argument of [ld] and
  [include-book]

  Please see [add-include-book-dir], which has completely analogous
  syntax and semantics, except that add-include-book-dir! is not
  [local] to the [encapsulate] or the book in which it occurs.
  Probably [add-include-book-dir] is to be preferred unless you have
  a good reason for wanting to export the effect of this event
  outside the enclosing [encapsulate] or book.

  Note: This is an event!  It does not print the usual event [summary]
  but nevertheless changes the ACL2 logical [world] and is so
  recorded.

  This macro is essentially a [table] event that updates the table
  include-book-dir!-table, which associates keywords with absolute
  pathnames.  However, as with [add-include-book-dir], direct table
  updates are disallowed; you must use add-include-book-dir! to add
  to the table and [delete-include-book-dir!] to remove from the
  table.

  It is illegal to call add-include-book-dir! in a [local] context.
  (If you are tempted to do that, consider using
  [add-include-book-dir] instead.)  To understand this restriction,
  imagine a book that contains the following sequence of [events].

    (add-include-book-dir! :my-dir \"path/to/BAD/dir\")
    (local (delete-include-book-dir! :my-dir))
    (local (add-include-book-dir! :my-dir \"path/to/GOOD/dir\"))
    (include-book \"foo\" :dir :my-dir)
    (defthm f-def
      (equal (f x) x))

  During the first (proof) pass of [certify-book], the book
  path/to/GOOD/dir/foo.lisp will be included.  But on the second
  pass, the book path/to/BAD/dir/foo.lisp will be included.  Now
  imagine that the ``good'' version contains the event (defun f (x)
  x) but the ``bad'' version instead contains the event (defun f (x)
  (not x)).  Then we can easily prove nil from the theorem f-def!
  Although it is likely that [book-hash] values could catch this
  error at [include-book] time, we prefer not to rely on these for
  soundness.")
 (ADD-INVISIBLE-FNS
  (LOOP-STOPPER)
  "Make some unary functions invisible to the [loop-stopper] algorithm

    Examples:
    (add-invisible-fns binary-+ unary-- foo)
    (add-invisible-fns + unary-- foo)

  Each of the [events] above makes unary functions [unary--] and foo
  ``invisible'' for the purposes of applying permutative :[rewrite]
  rules to [binary-+] trees.  Thus, arg and (unary-- arg) will be
  given the same weight and will be permuted so as to be adjacent.

    General Form:
    (add-invisible-fns top-fn unary-fn1 ... unary-fnk)

  where top-fn is a function symbol and the unary-fni are unary
  function symbols, or more generally, these are all macro aliases
  for such function symbols (see [macro-aliases-table]).

  For more information see [invisible-fns-table].  Also see
  [set-invisible-fns-table], which explains how to set the entire
  table in a single event, and see [remove-invisible-fns].")
 (ADD-LD-KEYWORD-ALIAS (POINTERS)
                       "See [ld-keyword-aliases].")
 (ADD-LD-KEYWORD-ALIAS! (POINTERS)
                        "See [ld-keyword-aliases].")
 (ADD-MACRO-ALIAS
  (MACROS)
  "Associate a function name with a macro name

    Example:
    (add-macro-alias append binary-append)

  This example associates the function symbol [binary-append] with the
  macro name [append].  As a result, the name [append] may be used as
  a runic designator (see [theories]) by the various theory
  functions.  See [macro-aliases-table] for more details.  Also see
  [add-macro-fn] for an extension of this utility that also affects
  printing.

    General Form:
    (add-macro-alias macro-name function-name)

  This is a convenient way to add an entry to [macro-aliases-table].
  See [macro-aliases-table] and also see [remove-macro-alias].")
 (ADD-MACRO-FN
  (MACROS)
  "Associate a function name with a macro name

    Examples:
    (add-macro-fn append binary-append)
    (add-macro-fn append binary-append t)

  These examples each associate the function symbol [binary-append]
  with the macro name [append].  As a result, theory functions will
  understand that append refers to binary-append --- see
  [add-macro-alias] --- and moreover, proof output will be printed
  using append rather than binary-append.  In the first case, (append
  x (append y z)) is printed rather than (append x y z).  In the
  second case, right-associated arguments are printed flat: (append x
  y z).  Such right-association is considered only for binary
  function symbols; otherwise the optional third argument is ignored.

    General Forms:
    (add-macro-fn macro-name function-name)
    (add-macro-fn macro-name function-name nil) ; same as above
    (add-macro-fn macro-name function-name t)

  This is a convenient way to add an entry to [macro-aliases-table] and
  at the same time extend the [untrans-table].  As suggested by the
  example above, calls of a function in this table will be printed as
  corresponding calls of macros, with right-associated arguments
  printed flat in the case of a binary function symbol if the
  optional third argument is t.  In that case, for a binary function
  symbol fn associated with macro name mac, then a call (fn arg1 (fn
  arg2 (... (fn argk arg)))) will be displayed to the user as though
  the ``term'' were (mac arg1 arg2 ... argk arg).  For a call (f a1
  ... ak) of a function symbol that is not binary, or the optional
  argument is not supplied as t, then the effect is simply to replace
  f by the corresponding macro symbol.  See [add-macro-alias], which
  is invoked on the first two arguments.  Also see
  [remove-macro-alias], see [untrans-table], and see
  [remove-macro-fn].")
 (ADD-MATCH-FREE-OVERRIDE
  (FREE-VARIABLES)
  "Set :match-free value to :once or :all in existing rules

    Example Forms:
    (add-match-free-override :once t)
        ; Try only the first binding of free variables when relieving hypotheses
        ; of any rule of class :rewrite, :linear, or :forward-chaining.
    (add-match-free-override :all (:rewrite foo) (:rewrite bar))
        ; For rewrite rules foo and bar, try all bindings of free variables when
        ; relieving hypotheses.
    (add-match-free-override :clear)
        ; Restore :match-free to what was originally stored for each rule (either
        ; :all or :once).

  As described elsewhere (see [free-variables]), a [rewrite], [linear],
  or [forward-chaining] rule may have free variables in its
  hypotheses, and ACL2 can be directed either to try all bindings
  (``:all'') or just the first (``:once'') when relieving a
  hypothesis, as a basis for relieving subsequent hypotheses.  This
  direction is generally provided by specifying either :match-free
  :once or :match-free :all in the :[rule-classes] of the rule, or by
  using the most recent [set-match-free-default] event.  Also see
  [rule-classes].

  However, if a proof is going slowly, you may want to modify the
  behavior of some such rules so that they use only the first match
  for free variables in a hypothesis when relieving subsequent
  hypotheses, rather than backtracking and trying additional matches
  as necessary.  (But note: add-match-free-override is not relevant
  for [type-prescription] rules.)  The event (add-match-free-override
  :once t) has that effect.  Or at the other extreme, perhaps you
  want to specify all rules as :all rules except for a some specific
  exceptions.  Then you can execute (add-match-free-override :all t)
  followed by, say, (add-match-free-override :once (:rewrite foo)
  (:linear bar)).

    General Forms:
    (add-match-free-override :clear)
    (add-match-free-override flg t)
    (add-match-free-override flg rune1 rune2 ... runek)

  where flg is :once or :all and the runei are [rune]s.  If :clear is
  specified then all rules will have the :all/:once behavior from
  when they were first stored.  The second general form causes all
  [rewrite] [linear], and [forward-chaining] rules to have the
  behavior specified by flg (:all or :once).  Finally, the last of
  these, where runes are specified, is additive in the sense that
  only the indicated rules are affected; all others keep the behavior
  they had just before this event was executed (possible because of
  earlier add-match-free-override events).

  At the conclusion of this event, ACL2 prints out the list of all
  :[linear], :[rewrite], and :[forward-chaining] runes whose rules
  contain free variables in hypotheses that are to be bound :once,
  except that if there are no overrides (value :clear was used), then
  :clear is printed.

  This event only affects rules that exist at the time it is executed.
  Future rules are not affected by the override.

  Note: This is an event!  It does not print the usual event [summary]
  but nevertheless changes the ACL2 logical [world] and is so
  recorded.  It uses the [ACL2-defaults-table], and hence its effect
  is [local] to the book or [encapsulate] form in which it occurs.

  Remarks

  Lists of the :[rewrite], :[linear], and :[forward-chaining] [rune]s
  whose behavior was originally :once or :all are returned by the
  following forms, respectively.

    (free-var-runes :once (w state))
    (free-var-runes :all  (w state))

  The form

    (match-free-override (w state))

  evaluates to a pair, whose [car] is a number used by ACL2 to
  determine whether a [rune] is sufficiently old to be affected by
  the override, and whose [cdr] is the list of [rune]s whose behavior
  is specified as :once by add-match-free-override; except, if no
  runes have been overridden, then the keyword :clear is returned.")
 (ADD-NTH-ALIAS
  (NTH-ALIASES-TABLE)
  "Associate one symbol with another for printing of [nth]/[update-nth]
  terms

    Example:
    (add-nth-alias st0 st)

  This example associates the symbol st0 with the symbol st for
  purposes of printing certain terms of the form (nth n st0) and
  (update-nth n val st0).

    General Form:
    (add-nth-alias alias-name name)

  This is a convenient way to add an entry to [nth-aliases-table].  See
  [nth-aliases-table] and also see [remove-nth-alias].")
 (ADD-OVERRIDE-HINTS
  (OVERRIDE-HINTS)
  "Add to the [override-hints]

  See [override-hints] for a discussion of override-hints.  Here we
  describe how to extend the list of override-hints.  Note that the
  effects of add-override-hints [events] are [local] to the [books]
  or encapsulate [events] in which they reside; see
  [add-override-hints!] to avoid that restriction.  Also see
  [set-override-hints] to set a new list of override-hints to it,
  ignoring the present list rather than adding to it.

    General Forms:
    (add-override-hints form)
    (add-override-hints form :at-end t)
    (add-override-hints form :at-end nil) ; default for :at-end

  where form evaluates to a list of computed hint forms.  The effect of
  this event is to extend the current list of [override-hints] by
  appending the result of that evaluation.  The default is to append
  the evaluation result to the front of the current list of
  override-hints, but if :at-end t is specified, then the evaluation
  result is appended to the end of the current list.")
 (ADD-OVERRIDE-HINTS!
  (OVERRIDE-HINTS)
  "Add non-[local]ly to the [override-hints]

  Add-override-hints! is the same as [add-override-hints], except that
  the former is not [local] to [books] or [encapsulate] [events] in
  which it occurs.  See [add-override-hints]; also see
  [set-override-hints].")
 (ADD-SUFFIX (POINTERS)
             "See [system-utilities].")
 (ADD-SUFFIX-TO-FN (POINTERS)
                   "See [system-utilities].")
 (ADD-TO-SET
  (LISTS SYMBOLS ACL2-BUILT-INS)
  "Add a symbol to a list

    General Forms:
    (add-to-set x lst)
    (add-to-set x lst :test 'eql)   ; same as above (eql as equality test)
    (add-to-set x lst :test 'eq)    ; same, but eq is equality test
    (add-to-set x lst :test 'equal) ; same, but equal is equality test

  For a symbol x and an object lst, (add-to-set-eq x lst) is the result
  of [cons]ing x on to the front of lst, unless x is already a
  [member] of lst, in which case the result is lst. The optional
  keyword, :TEST, has no effect logically, but provides the test
  (default [eql]) used for comparing x with successive elements of
  lst.

  The [guard] for a call of add-to-set depends on the test.  In all
  cases, the second argument must satisfy [true-listp].  If the test
  is [eql], then either the first argument must be suitable for [eql]
  (see [eqlablep]) or the second argument must satisfy
  [eqlable-listp].  If the test is [eq], then either the first
  argument must be a symbol or the second argument must satisfy
  [symbol-listp].

  See [equality-variants] for a discussion of the relation between
  add-to-set and its variants:

      (add-to-set-eq x lst) is equivalent to (add-to-set x lst :test 'eq);

      (add-to-set-equal x lst) is equivalent to (add-to-set x lst :test
      'equal).

  In particular, reasoning about any of these primitives reduces to
  reasoning about the function add-to-set-equal.")
 (ADD-TO-SET-EQ (POINTERS)
                "See [add-to-set].")
 (ADD-TO-SET-EQL (POINTERS)
                 "See [add-to-set].")
 (ADD-TO-SET-EQUAL (POINTERS)
                   "See [add-to-set].")
 (ADJUST-LD-HISTORY (POINTERS)
                    "See [ld-history].")
 (ADVANCED-FEATURES
  (ACL2-TUTORIAL PROGRAMMING)
  "Some advanced features of ACL2

  Maybe you've been using ACL2 for awhile, and you wonder if there are
  lesser-known features that you might find useful.  Then this topic
  is for you.  We present below a ``laundry list'' of some such
  features, with brief descriptions and links to [documentation]
  topics.

  Although the list below is long, it is not intended to be complete,
  and indeed some topics have been deliberately excluded.  Some have
  fallen out of use, perhaps for good reason, such as [obdd].  Others
  are already likely to be discovered when needed, such as [getenv$]
  and perhaps [double-rewrite].  Some topics are referenced by
  documentation for others in the list, such as [mbt], which is
  referenced by [mbe].  Some utilities such as [pstack] and
  [verbose-pstack] seem too low-level to be worthy of inclusion
  below.

  For an extensive introduction to using the prover, which may include
  some aspects new to you, see [introduction-to-the-theorem-prover].
  A shorter topic contains highlights for efficient prover usage: see
  [tips].  Also see [ACL2-sedan] for an extension of ACL2 (written by
  others), ACL2s, that includes an Eclipse-based interface, more
  powerful and automatic termination reasoning, and other features.

  We now move on to the list.


Top-level commands and utilities:

    * See [a!] and see [p!] to abort or pop.
    * See [ACL2-customization] for initial commands to run at startup.
    * See [keyword-commands] for how keyword commands are processed.
    * See [ld] for many ways to control the top-level loop.
    * See [compilation] for a discussion of set-compiler-enabled and other
      compiler-related utilities.
    * For useful reader macros `#!', `#.', and `#u', see
      [sharp-bang-reader], see [sharp-dot-reader], and see
      [sharp-u-reader].
    * To save and use an ACL2 executable, see [ACL2-as-standalone-program]
      and see [save-exec].
    * For utilities related to timing, see [time$], see
      [with-prover-time-limit], see [with-prover-step-limit], and see
      [set-prover-step-limit].
    * To query and manage the database, see [history] (which discusses many
      useful utilities, such as :[pbt] and :[pl]), and see
      [dead-events].
    * See [add-include-book-dir] for linking keyword for :dir argument of
      [ld] and [include-book].
    * See [rebuild] for a fast way to load a file without waiting for
      proofs.
    * For parallel certification, see [books-certification] for use of the
      -j option of `make'; also see [provisional-certification].


Some relatively less common events

    * See [reset-prehistory] to reset the prehistory.
    * See [assert-event] to assert that a given form returns a non-nil
      value.
    * See [defattach] to execute constrained functions using corresponding
      attached functions.
    * See [defun-sk] to define a function whose body has an outermost
      quantifier.
    * See [defchoose] to define a Skolem (witnessing) function.
    * See [set-verify-guards-eagerness] to specify when [guard]
      verification is tried by default.


Output and its control (see [io] for additional information)

    * See [with-output] to suppress or turn on specified output for an
      event.
    * See [evisc-table] for support for abbreviated output.
    * See [nth-aliases-table] for a table used to associate names for
      [nth]/[update-nth] printing.
    * See [output-to-file] to redirect output to a file.
    * See [print-control] to control ACL2 printing.
    * See [set-evisc-tuple] to control suppression of details when
      printing.
    * See [set-inhibit-output-lst] to control output by type.
    * See [set-iprint] to allow abbreviated output to be read back in.
    * See [set-print-base-radix] (also [set-print-base] and
      [set-print-radix]) to control the radix in which numbers are
      printed.
    * See [set-print-case] to control whether symbols are printed in upper
      case or in lower case.


On proving termination for definitions:

    * See [ordinals] for a discussion of ordinals in ACL2.
    * See [ruler-extenders] for a control on ACL2's termination and
      induction analyses.
    * See [set-well-founded-relation] to set the default well-founded
      relation for termination analysis.
    * See [ACL2-sedan] for a related tool that provides extra automation
      for termination proofs.


Proof debugging and output control:

    * See [accumulated-persistence] to get statistics on which runes are
      being tried.
    * See [add-macro-fn] and see [add-macro-alias] to associate a function
      name with a macro name.
    * See [break-rewrite] for how to monitor rewrite rules.
    * See [dmr] for dynamic monitoring of rewriting and other prover
      activity.
    * See [forward-chaining-reports] to see reports about the forward
      chaining process.
    * See [guard-debug] and [measure-debug] to generate markers to indicate
      sources of [guard] and termination proof obligations.
    * See [proof-builder] for support for low-level interaction.
    * See [redo-flat] for redo on failure of a [progn], [encapsulate], or
      [certify-book].
    * See [set-gag-mode] and see [pso] to abbreviate or restore proof
      output.
    * See [set-inhibit-output-lst], see [set-inhibit-warnings], see
      [set-inhibit-er-soft], and see [set-inhibited-summary-types] to
      inhibit various types of output.
    * See [set-raw-proof-format] to make proof output display lists of
      [rune]s.
    * See [set-raw-warning-format] to make some warnings display in a
      ``raw'' s-expression format.
    * See [skip-proofs] to skip proofs for a given form.


Program debugging:

    * See [break$] to cause an immediate Lisp break.
    * See [break-on-error] to break when encountering a hard or soft error
      caused by ACL2.
    * See [disassemble$] to disassemble a function.
    * See [print-gv] to print a form whose evaluation caused a guard
      violation.
    * See [profile] to turn on profiling for one function.
    * See [trace$] and see [open-trace-file] to [trace] function
      evaluations, possibly sending trace output to a file.
    * See [wet] to evaluate a form and print a subsequent error trace.


Programming and evaluation idioms, support, utilities

  (also see [programming] for more utilities, e.g., [random$]).

    * See [arrays] and See [defstobj] for introductions to ACL2 arrays and
      single-threaded objects (stobjs), respectively, each of which
      provides efficient destructive operations in an applicative
      setting.  Also see [with-local-stobj] for a way to create local
      stobjs.
    * See [assert$] to cause a hard error if the given test is false.
    * See [canonical-pathname] to obtain the true absolute filename, with
      soft links resolved.
    * See [case-match] for a utility providing pattern matching and
      destructuring.
    * See [defpun] to define a tail-recursive function symbol.
    * See [ec-call] to execute a call in the ACL2 logic instead of raw
      Lisp.
    * See [er] to print an error message and ``cause an error''.
    * See [flet] to provide local binding of function symbols.
    * See [gc$] to invoke the garbage collector.
    * See [mbe] to attach code for execution.
    * See [mv-list] to convert a [multiple-value] result to a single-value
      list.
    * See [mv?] to return one or more values.
    * For non-executable code, see [defun-nx] and see [non-exec].
    * See [prog2$] and see [progn$] to execute two or more forms and return
      the value of the last one.
    * See [programming-with-state] for how to program using the von
      Neumannesque ACL2 [state] object.
    * See [top-level] to evaluate a top-level form as a function body.
    * See [with-guard-checking] to suppress or enable guard-checking for a
      form.
    * For ways to fake access to the state see [wormhole], see
      [with-local-state], see [cw], see [cw!], see
      [printing-to-strings], see [observation-cw], and (dangerous!)
      see [with-live-state].


Connecting with the underlying host Lisp, and doing other evil:

    * See [defttag] to introduce a trust tag (ttag).
    * See [defmacro-last] to define a macro that returns its last argument,
      but with side effects.
    * See [progn!] to evaluate forms that are not necessarily [events].
    * See [return-last] to return the last argument, perhaps with side
      effects.
    * See [set-raw-mode] to enter or exit ``raw mode,'' a raw Lisp
      environment.
    * See [sys-call], [sys-call+], and [sys-call*] to make a system call to
      the host operating system.


Macros and related utilities:

    * See [defabbrev] for a convenient form of macro definition for simple
      expansions.
    * See [macro-args] for the formals list of a macro definition (see
      [defmacro]).
    * See [make-event] for a sort of extension of [defmacro] that allows
      access to the [state], by evaluating (expanding) a given form
      and then evaluate the result of that expansion.
    * See [trans], see [trans!], and see [trans1] to print the
      macroexpansion of a form.


Additional capabilities:

    * See [hons-and-memoization] for a discussion of the [hons-enabled]
      features providing hash cons, function memoization, and
      applicative hash tables.  In particular, see [memoize] for
      efficient function memoization and see [profile] for profiling.
    * See [real] for ACL2(r), which supports the real numbers.
    * See [parallelism] for ACL2(p), which supports parallel evaluation and
      proof.


Database control and query:

    * See [disabledp] to determine whether a given name or rune is
      disabled.
    * For redefinition support see [redef], see [redef!], see [redef+], see
      [redef-], and see [redefined-names].
    * See [table] for user-managed tables.
    * See [guard-formula-utilities] for how to view a guard proof
      obligation without doing the proof.


Prover control

    * For congruence-based reasoning see [defcong], see [congruence], see
      [equivalence], see [defequiv], and see [defrefinement].
    * For meta rules and clause processors see [meta], see [defevaluator],
      see [clause-processor], see [define-trusted-clause-processor]
      (for connecting with external tools, such as SAT solvers), and
      See [extended-metafunctions] (for [state] and context-sensitive
      metafunctions).
    * For theory control, see [theories] for detailed information, but in
      particular see [deftheory], see [theory-functions], see
      [in-arithmetic-theory] (and see [non-linear-arithmetic]), and
      see [theory-invariant].
    * See [hints] for a complete list of prover hints, including some of
      the more obscure ones such as :restrict, :[clause-processor],
      :nonlinearp, :backchain-limit-rw, :reorder, and :backtrack.
      Also see [hints-and-the-waterfall] for an explanation of how
      hints interact with the ACL2 proof process.  For other topics
      related to hints, see [override-hints], see
      [add-custom-keyword-hint], see [default-hints], and see
      [computed-hints] and [using-computed-hints].
    * See [bind-free] to bind [free-variables] of a [rewrite] or [linear]
      rule.
    * See [case-split] for a utility like [force] that immediately splits
      the top-level goal on the indicated hypothesis.
    * See [case-split-limitations] for a way to the number of cases
      produced at once
    * See [default-backchain-limit] to specify the backchain limit for a
      rule.
    * See [force] for an identity function used to force a hypothesis.
    * See [otf-flg] for a way to push more than one initial subgoal for
      induction.
    * See [rule-classes] to add various kinds of rules to the database,
      including more unusual sorts such as :[built-in-clause] rules
      and :[induction] rules.
    * See [set-backchain-limit] to set the backchain-limit used by the
      type-set and rewriting mechanisms.
    * See [set-body] to set an alternate definition body for :expand
      [hints].
    * See [set-rewrite-stack-limit] to set the [rewrite] stack depth used
      by the rewriter.
    * See [syntaxp] to attach a heuristic filter on a :[rewrite], :[meta],
      or :[linear] rule.


Subtopics

  [Invariant-risk]
      Potential slowdown for [program]-mode updates to [stobj]s or
      [arrays]

  [Program-wrapper]
      Avoiding expensive [guard] checks using [program]-mode functions

  [Set-check-invariant-risk]
      Affect certain [program]-mode updates to [stobj]s or [arrays]

  [Set-duplicate-keys-action]
      Control action for macro calls with duplicate keyword arguments

  [Set-register-invariant-risk]
      Avoid [invariant-risk] checking for specified functions")
 (ALIST-KEYS-SUBSETP
  (ALISTS ACL2-BUILT-INS)
  "Check that all keys of the alist belong to a given set

  The call (alist-keys-subsetp alist keys) returns t when each key of
  the given alist belongs to the given list of keys; else it returns
  nil.  This is Boolean-equivalent to (subsetp-eq (strip-cars alist)
  keys), but it avoids consing up the keys of alist.")
 (ALIST-TO-DOUBLETS
  (ALISTS ACL2-BUILT-INS)
  "Convert an alist to a list of two-element lists

  The call (alist-to-doublets alist) returns the result of replacing
  each pair (x . y) in the given alist by the two-element list (x y).
  The order is preserved, i.e., the following is a theorem.

    (implies (and (natp i) (< i (len alist)))
             (equal (nth i (alist-to-doublets alist))
                    (let ((pair (nth i alist)))
                      (list (car pair) (cdr pair)))))")
 (ALISTP
  (ALISTS ACL2-BUILT-INS)
  "Recognizer for association lists

  (alistp x) is true if and only if x is a list of [cons] pairs.

  (alistp x) has a [guard] of t.

  Function: <alistp>

    (defun alistp (l)
           (declare (xargs :guard t))
           (cond ((atom l) (eq l nil))
                 (t (and (consp (car l))
                         (alistp (cdr l))))))")
 (ALISTS
  (PROGRAMMING)
  "Operations on association lists, which bind keys to values.


Subtopics

  [Acons]
      Constructor for association lists

  [Alist-keys-subsetp]
      Check that all keys of the alist belong to a given set

  [Alist-to-doublets]
      Convert an alist to a list of two-element lists

  [Alistp]
      Recognizer for association lists

  [Assoc]
      Look up key in association list

  [Assoc-string-equal]
      Look up key, a string, in association list

  [Character-alistp]
      Recognizer for association lists with characters as keys

  [Delete-assoc]
      Deprecated version of [remove1-assoc]

  [Eqlable-alistp]
      Recognizer for a true list of pairs whose [car]s are suitable for
      [eql]

  [Fast-alists]
      Alists with hidden hash tables for faster execution

  [Pairlis]
      See [pairlis$]

  [Pairlis$]
      Zipper together two lists

  [Pairlis-x1]
      Cons a given element to each member of a list

  [Pairlis-x2]
      Cons each element of a list with a given element

  [Put-assoc]
      Modify an association list by associating a value with a key

  [R-eqlable-alistp]
      Recognizer for a true list of pairs whose [cdr]s are suitable for
      [eql]

  [R-symbol-alistp]
      Recognizer for association lists with symbols as values

  [Rassoc]
      Look up value in association list

  [Remove-assoc]
      Remove all pairs with a given key from an association list

  [Remove1-assoc]
      Remove the first pair with a given key from an association list

  [Standard-string-alistp]
      Recognizer for association lists with standard strings as keys

  [Strip-cars]
      Collect up all first components of pairs in a list

  [Strip-cdrs]
      Collect up all second components of pairs in a list

  [Sublis]
      Substitute an alist into a tree

  [Symbol-alistp]
      Recognizer for association lists with symbols as keys")
 (ALL-ATTACHMENTS (POINTERS)
                  "See [system-utilities].")
 (ALL-CALLS (POINTERS)
            "See [system-utilities].")
 (ALL-FNNAMES (POINTERS)
              "See [system-utilities].")
 (ALL-FNNAMES-LST (POINTERS)
                  "See [system-utilities].")
 (ALL-FNNAMES1 (POINTERS)
               "See [system-utilities].")
 (ALL-VARS (POINTERS)
           "See [system-utilities].")
 (ALLOCATE-FIXNUM-RANGE
  (NUMBERS ACL2-BUILT-INS)
  "Set aside fixnums in GCL

  (Allocate-fixnum-range fixnum-lo fixnum-hi) causes Gnu Common Lisp
  (GCL) to create a persistent table for the integers between
  fixnum-lo and fixnum-hi (both bounds inclusive). This table is
  referenced first when any integer is boxed and the existing box in
  the table is used if the integer is in bounds.  This can speed up
  GCL considerably by avoiding wasteful fixnum boxing.  Here,
  fixnum-lo and fixnum-hi should be fixnums.  On 32-bit machines it
  would be good for them to be of type (signed-byte 30), with
  fixnum-lo <= fixnum-hi.

  When this function is executed in a Lisp implementation other than
  GCL, it has no side effect.  This function always returns nil.")
 (ALPHA-CHAR-P
  (CHARACTERS ACL2-BUILT-INS)
  "Recognizer for alphabetic characters

  (Alpha-char-p x) is true for a standard character x if and only if x
  is alphabetic, i.e., one of the [characters] #\\a, #\\b, ..., #\\z,
  #\\A, #\\B, ..., #\\Z.

  The [guard] for alpha-char-p requires its argument to be a standard
  character (see [standard-char-p]).

  Alpha-char-p is a Common Lisp function.  See any Common Lisp
  documentation for more information.

  Function: <alpha-char-p>

    (defun alpha-char-p (x)
           (declare (xargs :guard (and (characterp x)
                                       (standard-char-p x))))
           (and (member x
                        '(#\\a #\\b #\\c
                              #\\d #\\e #\\f #\\g #\\h #\\i #\\j #\\k #\\l #\\m
                              #\\n #\\o #\\p #\\q #\\r #\\s #\\t #\\u #\\v #\\w
                              #\\x #\\y #\\z #\\A #\\B #\\C #\\D #\\E #\\F #\\G
                              #\\H #\\I #\\J #\\K #\\L #\\M #\\N #\\O #\\P #\\Q
                              #\\R #\\S #\\T #\\U #\\V #\\W #\\X #\\Y #\\Z))
                t))")
 (ALPHORDER
  (<< ACL2-BUILT-INS)
  "Total order on atoms

  Alphorder is a non-strict total order, a ``less than or equal,'' on
  atoms.  By ``non-strict total order'' we mean a function that
  always returns t or nil and satisfies the following properties.

    * Antisymmetry: XrY & YrX -> X=Y
    * Transitivity: XrY & YrZ -> XrZ
    * Trichotomy: XrY v YrX

  Also see [lexorder], which extends alphorder to all objects.

  (Alphorder x y) has a guard of (and (atom x) (atom y)).

  Within a single type: rationals are compared arithmetically, complex
  rationals are compared lexicographically, characters are compared
  via their char-codes, and strings and symbols are compared with
  alphabetic ordering.  Across types, rationals come before
  complexes, complexes come before characters, characters before
  strings, and strings before symbols.  We also allow for ``bad
  atoms,'' i.e., atoms that are not legal Lisp objects but make sense
  in the ACL2 logic; these come at the end, after symbols.

  Function: <alphorder>

    (defun alphorder (x y)
           (declare (xargs :guard (and (atom x) (atom y))))
           (cond ((real/rationalp x)
                  (cond ((real/rationalp y) (<= x y))
                        (t t)))
                 ((real/rationalp y) nil)
                 ((complex/complex-rationalp x)
                  (cond ((complex/complex-rationalp y)
                         (or (< (realpart x) (realpart y))
                             (and (= (realpart x) (realpart y))
                                  (<= (imagpart x) (imagpart y)))))
                        (t t)))
                 ((complex/complex-rationalp y) nil)
                 ((characterp x)
                  (cond ((characterp y)
                         (<= (char-code x) (char-code y)))
                        (t t)))
                 ((characterp y) nil)
                 ((stringp x)
                  (cond ((stringp y) (and (string<= x y) t))
                        (t t)))
                 ((stringp y) nil)
                 (t (cond ((symbolp x)
                           (cond ((symbolp y) (not (symbol< y x)))
                                 (t t)))
                          ((symbolp y) nil)
                          (t (bad-atom<= x y))))))")
 (ALTERNATIVE-INTRODUCTION
  (ACL2-TUTORIAL)
  "Introduction to ACL2

  This section contains introductory material on ACL2 including what
  ACL2 is, how to get started using the system, how to read the
  output, and other introductory topics.  It was written almost
  entirely by Bill Young of Computational Logic, Inc.

  You might also find CLI Technical Report 101 helpful, especially if
  you are familiar with Nqthm.  If you would like more familiarity
  with Nqthm, we suggest CLI Technical Report 100.

  OVERVIEW

  ACL2 is an automated reasoning system developed (for the first 9
  years) at Computational Logic, Inc. and (from January, 1997) at the
  University of Texas at Austin.  It is the successor to the Nqthm
  (or Boyer-Moore) logic and proof system and its Pc-Nqthm
  interactive enhancement.  The acronym ACL2 actually stands for ``A
  Computational Logic for Applicative Common Lisp''.  This title
  suggests several distinct but related aspects of ACL2.

  We assume that readers of the ACL2 [documentation] have at least a
  very slight familiarity with some Lisp-like language.  We will
  address the issue of prerequisites further, in ``ABOUT THIS
  TUTORIAL'' below.

  As a logic, ACL2 is a formal system with rigorously defined syntax
  and semantics.  In mathematical parlance, the ACL2 logic is a
  first-order logic of total recursive functions providing
  mathematical induction on the ordinals up to epsilon-0 and two
  extension principles: one for recursive definition and one for
  constrained introduction of new function symbols, here called
  encapsulation.  The syntax of ACL2 is that of Common Lisp; ACL2
  specifications are ``also'' Common Lisp programs in a way that we
  will make clear later.  In less formal language, the ACL2 logic is
  an integrated collection of rules for defining (or axiomatizing)
  recursive functions, stating properties of those functions, and
  rigorously establishing those properties.  Each of these activities
  is mechanically supported.

  As a specification language, ACL2 supports modeling of systems of
  various kinds.  An ACL2 function can equally be used to express
  purely formal relationships among mathematical entities, to
  describe algorithms, or to capture the intended behavior of digital
  systems.  For digital systems, an ACL2 specification is a
  mathematical model that is intended to formalize relevant aspects
  of system behavior.  Just as physics allows us to model the
  behavior of continuous physical systems, ACL2 allows us to model
  digital systems, including many with physical realizations such as
  computer hardware.  As early as the 1930's Church, Kleene, Turing
  and others established that recursive functions provide an
  expressive formalism for modeling digital computation.  Digital
  computation should be understood in a broad sense, covering a wide
  variety of activities including almost any systematic or
  algorithmic activity, or activity that can be reasonably
  approximated in that way.  This ranges from the behavior of a
  digital circuit to the behavior of a programming language compiler
  to the behavior of a controller for a physical system (as long as
  the system can be adequately modeled discretely).  All of these
  have been modeled using ACL2 or its predecessor Nqthm.

  ACL2 is a computational logic in at least three distinct senses.
  First, the theory of recursive functions is often considered the
  mathematics of computation.  Church conjectured that any
  ``effective computation'' can be modeled as a recursive function.
  Thus, ACL2 provides an expressive language for modeling digital
  systems.  Second, many ACL2 specifications are executable.  In
  fact, recursive functions written in ACL2 are Common Lisp functions
  that can be submitted to any compliant Common Lisp compiler and
  executed (in an environment where suitable ACL2-specific macros and
  functions are defined).  Third, ACL2 is computational in the sense
  that calculation is heavily integrated into the reasoning process.
  Thus, an expression with explicit constant values but no free
  variables can be simplified by calculation rather than by complex
  logical manipulations.

  ACL2 is a powerful, automated theorem prover or proof checker.  This
  means that a competent user can utilize the ACL2 system to discover
  proofs of theorems stated in the ACL2 logic or to check previously
  discovered proofs.  The basic deductive steps in an ACL2-checked
  proof are often quite large, due to the sophisticated combination
  of decision procedures, conditional rewriting, mathematical and
  structural induction, propositional simplification, and complex
  heuristics to orchestrate the interactions of these capabilities.
  Unlike some automated proof systems, ACL2 does not produce a formal
  proof.  However, we believe that if ACL2 certifies the
  ``theoremhood'' of a given conjecture, then such a formal proof
  exists and, therefore, the theorem is valid.  The ultimate result
  of an ACL2 proof session is a collection of ``[events],'' possibly
  grouped into ``[books],'' that can be replayed in ACL2.  Therefore,
  a proof can be independently validated by any ACL2 user.

  ACL2 may be used in purely automated mode in the shallow sense that
  conjectures are submitted to the prover and the user does not
  interact with the proof attempt (except possibly to stop it) until
  the proof succeeds or fails.  However, any non-trivial proof
  attempt is actually interactive, since successful proof
  ``[events]'' influence the subsequent behavior of the prover.  For
  example, proving a lemma may introduce a rule that subsequently is
  used automatically by the prover.  Thus, any realistic proof
  attempt, even in ``automatic'' mode, is really an interactive
  dialogue with the prover to craft a sequence of [events] building
  an appropriate theory and proof rules leading up to the proof of
  the desired result.  Also, ACL2 supports annotating a theorem with
  ``[hints]'' designed to guide the proof attempt.  By supplying
  appropriate [hints], the user can suggest proof strategies that the
  prover would not discover automatically.  There is a
  ``[proof-tree]'' facility (see [proof-tree]) that allows the user
  to [monitor] the progress and structure of a proof attempt in
  real-time.  Exploring failed proof attempts is actually where
  heavy-duty ACL2 users spend most of their time.

  ACL2 can also be used in a more explicitly interactive mode.  The
  interactive [proof-builder] subsystem of ACL2 allows exploration of
  a proof on a fairly low level including expanding calls of selected
  function symbols, invoking specific [rewrite] rules, and
  selectively navigating around the proof.  This facility can be used
  to gain sufficient insight into the proof to construct an automatic
  version, or to generate a detailed interactive-style proof that can
  be replayed in batch mode.

  Because ACL2 is all of these things --- computational logic,
  specification language, [programming] system, and theorem prover
  --- it is more than the sum of its parts.  The careful integration
  of these diverse aspects has produced a versatile automated
  reasoning system suitable for building highly reliable digital
  systems.  In the remainder of this tutorial, we will illustrate
  some simple uses of this automated reasoning system.

  ABOUT THIS TUTORIAL

  ACL2 is a complex system with a vast array of features, bells and
  whistles.  However, it is possible to perform productive work with
  the system using only a small portion of the available
  functionality.  The goals of this tutorial are to:

      familiarize the new user with the most basic features of and modes of
      interaction with ACL2;

      familiarize her with the form of output of the system; and

      work through a graduated series of examples.

  The more knowledge the user brings to this system, the easier it will
  be to become proficient.  On one extreme: the ideal user of ACL2 is
  an expert Common Lisp programmer, has deep understanding of
  automated reasoning, and is intimately familiar with the earlier
  Nqthm system.  Such ideal users are unlikely to need this tutorial.
  However, without some background knowledge, the beginning user is
  likely to become extremely confused and frustrated by this system.
  We suggest that a new user of ACL2 should:

      (a) have a little familiarity with Lisp, including basic Lisp
      programming and prefix notation (a Lisp reference manual such
      as Guy Steele's ``Common Lisp: The Language'' is also helpful);

      (b) be convinced of the utility of formal modeling; and

      (c) be willing to gain familiarity with basic automated theorem
      proving topics such as rewriting and algebraic simplification.

  We will not assume any deep familiarity with Nqthm (the so-called
  ``Boyer-Moore Theorem Prover''), though the book ``A Computational
  Logic Handbook'' by Boyer and Moore (Academic Press, 1988) is an
  extremely useful reference for many of the topics required to
  become a competent ACL2 user.  We'll refer to it as ACLH below.

  As we said in the introduction, ACL2 has various facets.  For
  example, it can be used as a Common Lisp [programming] system to
  construct application programs.  In fact, the ACL2 system itself is
  a large Common Lisp program constructed almost entirely within
  ACL2.  Another use of ACL2 is as a specification and modeling tool.
  That is the aspect we will concentrate on in the remainder of this
  tutorial.

  GETTING STARTED

  This section is an abridged version of what's available elsewhere;
  feel free to see [startup] for more details.

  How you start ACL2 will be system dependent, but you'll probably type
  something like ``acl2'' at your operating system prompt.  Consult
  your system administrator for details.

  When you start up ACL2, you'll probably find yourself inside the ACL2
  [command] loop, as indicated by the following [prompt].

    ACL2 !>

  If not, you should type (LP).  See [lp], which has a lot more
  information about the ACL2 [command] loop.

  There are two ``modes'' for using ACL2, :[logic] and :[program].
  When you begin ACL2, you will ordinarily be in the :[logic] mode.
  This means that any new function defined is not only executable but
  also is axiomatically defined in the ACL2 logic.  (See [defun-mode]
  and see [default-defun-mode].)  Roughly speaking, :[program] mode
  is available for using ACL2 as a [programming] language without
  some of the logical burdens necessary for formal reasoning.  In
  this tutorial we will assume that we always remain in :[logic] mode
  and that our purpose is to write formal models of digital systems
  and to reason about them.

  Now, within the ACL2 [command] loop you can carry out various kinds
  of activities, including the following.  (We'll see examples later
  of many of these.)

      define new functions (see [defun]);

      execute functions on concrete data;

      pose and attempt to prove conjectures about previously defined
      functions (see [defthm]);

      query the ACL2 ``[world]'' or database (e.g., see [pe]); and

      numerous other things.

  In addition, there is extensive on-line [documentation], of which
  this tutorial introduction is a part.

  INTERACTING WITH ACL2

  The standard means of interacting with ACL2 is to submit a sequence
  of forms for processing by the ACL2 system.  These forms are
  checked for syntactic and semantic acceptability and appropriately
  processed by the system.  These forms can be typed directly at the
  ACL2 [prompt].  However, most successful ACL2 users prefer to do
  their work using the Emacs text editor, maintaining an Emacs
  ``working'' buffer in which forms are edited.  Those forms are then
  copied to the ACL2 interaction buffer, which is often the \"*shell*\"
  buffer.

  In some cases, processing succeeds and makes some change to the ACL2
  ``logical [world],'' which affects the processing of subsequent
  forms.  How can this processing fail?  For example, a proposed
  theorem will be rejected unless all function symbols mentioned have
  been previously defined.  Also the ability of ACL2 to discover the
  proof of a theorem may depend on the user previously having proved
  other theorems.  Thus, the order in which forms are submitted to
  ACL2 is quite important.  Maintaining forms in an appropriate order
  in your working buffer will be helpful for re-playing the proof
  later.

  One of the most common [events] in constructing a model is
  introducing new functions.  New functions are usually introduced
  using the [defun] form; we'll encounter some exceptions later.
  Proposed function definitions are checked to make sure that they
  are syntactically and semantically acceptable (e.g., that all
  mentioned functions have been previously defined) and, for
  recursive functions, that their recursive calls terminate.  A
  recursive function definition is guaranteed to terminate if there
  is some some ``measure'' of the arguments and a ``well-founded''
  ordering such that the arguments to the function get smaller in
  each recursive call.  See [well-founded-relation-rule].

  For example, suppose that we need a function that will append two
  lists together.  (We already have one in the ACL2 [append]
  function; but suppose perversely that we decide to define our own.)
  Suppose we submit the following definition (you should do so as
  well and study the system output):

    (defun my-app (x y)
      (if (atom x)
          y
        (cons (car x) (my-app x y))))

  The system responds with the following message:

    ACL2 Error in ( DEFUN MY-APP ...):  No :MEASURE was supplied with
    the definition of MY-APP.  Our heuristics for guessing one have not
    made any suggestions.  No argument of the function is tested along
    every branch and occurs as a proper subterm at the same argument
    position in every recursive call.  You must specify a :MEASURE.  See
    :DOC defun.

  This means that the system could not find an expression involving the
  formal parameters x and y that decreases under some well-founded
  order in every recursive call (there is only one such call).  It
  should be clear that there is no such measure in this case because
  the only recursive call doesn't change the arguments at all.  The
  definition is obviously flawed; if it were accepted and executed it
  would loop forever.  Notice that a definition that is rejected is
  not stored in the system database; there is no need to take any
  action to have it ``thrown away.'' Let's try again with the correct
  definition.  The interaction now looks like (we're also putting in
  the ACL2 [prompt]; you don't type that):

    ACL2 !>(defun my-app (x y)
             (if (atom x)
                 y
               (cons (car x) (my-app (cdr x) y))))

    The admission of MY-APP is trivial, using the relation O<
    (which is known to be well-founded on the domain recognized by
    O-P) and the measure (ACL2-COUNT X).  We observe that the
    type of MY-APP is described by the theorem
    (OR (CONSP (MY-APP X Y)) (EQUAL (MY-APP X Y) Y)).
    We used primitive type reasoning.

    Summary
    Form:  ( DEFUN MY-APP ...)
    Rules: ((:FAKE-RUNE-FOR-TYPE-SET NIL))
    Warnings:  None
    Time:  0.07 seconds (prove: 0.00, print: 0.00, other: 0.07)
    MY-APP

  Notice that this time the function definition was accepted.  We
  didn't have to supply a measure explicitly; the system inferred one
  from the form of the definition.  On complex functions it may be
  necessary to supply a measure explicitly.  (See [xargs].)

  The system output provides several pieces of information.

      The revised definition is acceptable.  The system realized that there
      is a particular measure (namely, (acl2-count x)) and a
      well-founded relation (o<) under which the arguments of my-app
      get smaller in recursion.  Actually, the theorem prover proved
      several theorems to admit my-app.  The main one was that when
      (atom x) is false the acl2-count of (cdr x) is less than (in
      the o< sense) the acl2-count of x.  [Acl2-count] is the most
      commonly used measure of the ``size`` of an ACL2 object.  [o<]
      is the ordering relation on ordinals less than epsilon-0.  On
      the natural numbers it is just ordinary ``<''.

      The observation printed about ``the type of MY-APP'' means that calls
      of the function my-app will always return a value that is
      either a [cons] pair or is equal to the second parameter.

      The [summary] provides information about which previously introduced
      definitions and lemmas were used in this proof, about some
      notable things to watch out for (the Warnings), and about how
      long this event took to process.

  Usually, it's not important to read this information.  However, it is
  a good habit to scan it briefly to see if the type information is
  surprising to you or if there are Warnings.  We'll see an example
  of them later.

  After a function is accepted, it is stored in the database and
  available for use in other function definitions or lemmas.  To see
  the definition of any function use the :[pe] command (see [pe]).
  For example,

    ACL2 !>:pe my-app
     L       73:x(DEFUN MY-APP (X Y)
                        (IF (ATOM X)
                            Y (CONS (CAR X) (MY-APP (CDR X) Y))))

  This displays the definition along with some other relevant
  information.  In this case, we know that this definition was
  processed in :[logic] mode (the ``L'') and was the 73rd [command]
  processed in the current session.

  We can also try out our newly defined function on some sample data.
  To do that, just submit a form to be evaluated to ACL2.  For
  example,

    ACL2 !>(my-app '(0 1 2) '(3 4 5))
    (0 1 2 3 4 5)
    ACL2 !>(my-app nil nil)
    NIL
    ACL2 !>

  Now suppose we want to prove something about the function just
  introduced.  We conjecture, for example, that the length of the
  [append] of two lists is the sum of their lengths.  We can
  formulate this conjecture in the form of the following ACL2
  [defthm] form.

    (defthm my-app-length
      (equal (len (my-app x y))
             (+ (len x) (len y))))

  First of all, how did we know about the functions len and [+], etc.?
  The answer to that is somewhat unsatisfying --- we know them from
  our past experience in using Common Lisp and ACL2.  It's hard to
  know that a function such as len exists without first knowing some
  Common Lisp.  If we'd guessed that the appropriate function was
  called [length] (say, from our knowledge of Lisp) and tried :pe
  length, we would have seen that [length] is defined in terms of
  len, and we could have explored from there.  Luckily, you can write
  a lot of ACL2 functions without knowing too many of the primitive
  functions.

  Secondly, why don't we need some ``type'' hypotheses?  Does it make
  sense to append things that are not lists?  Well, yes.  ACL2 and
  Lisp are both quite weakly typed.  For example, inspection of the
  definition of my-app shows that if x is not a [cons] pair, then
  (my-app x y) always returns y, no matter what y is.

  Thirdly, would it matter if we rewrote the lemma with the equality
  reversed, as follows?

    (defthm my-app-length2
      (equal (+ (len x) (len y))
             (len (my-app x y)))).

  The two are logically equivalent, but...yes, it would make a big
  difference.  Recall our remark that a lemma is not only a ``fact''
  to be proved; it also is used by the system to prove other later
  lemmas.  The current lemma would be stored as a [rewrite] rule.
  (See [rule-classes].)  For a [rewrite] rule, a conclusion of the
  form (EQUAL LHS RHS) means to replace instances of the LHS by the
  appropriate instance of the RHS.  Presumably, it's better to
  [rewrite] (len (my-app x y)) to (+ (len x) (len y)) than the other
  way around.  The reason is that the system ``knows'' more about [+]
  than it does about the new function symbol my-app.

  So let's see if we can prove this lemma.  Submitting our preferred
  [defthm] to ACL2 (do it!), we get the following interaction:

              --------------------------------------------------
    ACL2 !>(defthm my-app-length
      (equal (len (my-app x y))
             (+ (len x) (len y))))

    Name the formula above *1.

    Perhaps we can prove *1 by induction.  Three induction schemes are
    suggested by this conjecture.  These merge into two derived
    induction schemes.  However, one of these is flawed and so we are
    left with one viable candidate.

    We will induct according to a scheme suggested by (LEN X), but
    modified to accommodate (MY-APP X Y).  If we let (:P X Y) denote *1
    above then the induction scheme we'll use is
    (AND (IMPLIES (NOT (CONSP X)) (:P X Y))
         (IMPLIES (AND (CONSP X) (:P (CDR X) Y))
                  (:P X Y))).
    This induction is justified by the same argument used to admit LEN,
    namely, the measure (ACL2-COUNT X) is decreasing according to the
    relation O< (which is known to be well-founded on the domain
    recognized by O-P).  When applied to the goal at hand the
    above induction scheme produces the following two nontautological
    subgoals.

    Subgoal *1/2
    (IMPLIES (NOT (CONSP X))
             (EQUAL (LEN (MY-APP X Y))
                    (+ (LEN X) (LEN Y)))).

    But simplification reduces this to T, using the :definitions of FIX,
    LEN and MY-APP, the :type-prescription rule LEN, the :rewrite rule
    UNICITY-OF-0 and primitive type reasoning.

    Subgoal *1/1
    (IMPLIES (AND (CONSP X)
                  (EQUAL (LEN (MY-APP (CDR X) Y))
                         (+ (LEN (CDR X)) (LEN Y))))
             (EQUAL (LEN (MY-APP X Y))
                    (+ (LEN X) (LEN Y)))).

    This simplifies, using the :definitions of LEN and MY-APP, primitive
    type reasoning and the :rewrite rules COMMUTATIVITY-OF-+ and
    CDR-CONS, to

    Subgoal *1/1'
    (IMPLIES (AND (CONSP X)
                  (EQUAL (LEN (MY-APP (CDR X) Y))
                         (+ (LEN Y) (LEN (CDR X)))))
             (EQUAL (+ 1 (LEN (MY-APP (CDR X) Y)))
                    (+ (LEN Y) 1 (LEN (CDR X))))).

    But simplification reduces this to T, using linear arithmetic,
    primitive type reasoning and the :type-prescription rule LEN.

    That completes the proof of *1.

    Q.E.D.

    Summary
    Form:  ( DEFTHM MY-APP-LENGTH ...)
    Rules: ((:REWRITE UNICITY-OF-0)
            (:DEFINITION FIX)
            (:REWRITE COMMUTATIVITY-OF-+)
            (:DEFINITION LEN)
            (:REWRITE CDR-CONS)
            (:DEFINITION MY-APP)
            (:TYPE-PRESCRIPTION LEN)
            (:FAKE-RUNE-FOR-TYPE-SET NIL)
            (:FAKE-RUNE-FOR-LINEAR NIL))
    Warnings:  None
    Time:  0.30 seconds (prove: 0.13, print: 0.05, other: 0.12)
     MY-APP-LENGTH
              --------------------------------------------------

  Wow, it worked!  In brief, the system first tried to [rewrite] and
  simplify as much as possible.  Nothing changed; we know that
  because it said ``Name the formula above *1.'' Whenever the system
  decides to name a formula in this way, we know that it has run out
  of techniques to use other than proof by induction.

  The induction performed by ACL2 is structural or ``Noetherian''
  induction.  You don't need to know much about that except that it
  is induction based on the structure of some object.  The heuristics
  infer the structure of the object from the way the object is
  recursively decomposed by the functions used in the conjecture.
  The heuristics of ACL2 are reasonably good at selecting an
  induction scheme in simple cases.  It is possible to override the
  heuristic choice by providing an :induction hint (see [hints]).  In
  the case of the theorem above, the system inducts on the structure
  of x as suggested by the decomposition of x in both (my-app x y)
  and (len x).  In the base case, we assume that x is not a [consp].
  In the inductive case, we assume that it is a [consp] and assume
  that the conjecture holds for (cdr x).

  There is a close connection between the analysis that goes on when a
  function like my-app is accepted and when we try to prove something
  inductively about it.  That connection is spelled out well in Boyer
  and Moore's book ``A Computational Logic,'' if you'd like to look
  it up.  But it's pretty intuitive.  We accepted my-app because the
  ``size'' of the first argument x decreases in the recursive call.
  That tells us that when we need to prove something inductively
  about my-app, it's a good idea to try an induction on the size of
  the first argument.  Of course, when you have a theorem involving
  several functions, it may be necessary to concoct a more
  complicated [induction] schema, taking several of them into
  account.  That's what's meant by ``merging'' the induction schemas.

  The proof involves two cases: the base case, and the inductive case.
  You'll notice that the subgoal numbers go down rather than up, so
  you always know how many subgoals are left to process.  The base
  case (Subgoal *1/2) is handled by opening up the function
  definitions, simplifying, doing a little rewriting, and performing
  some reasoning based on the types of the arguments.  You'll often
  encounter references to system defined lemmas (like unicity-of-0).
  You can always look at those with :[pe]; but, in general, assume
  that there's a lot of simplification power under the hood that's
  not too important to understand fully.

  The inductive case (Subgoal *1/1) is also dispatched pretty easily.
  Here we assume the conjecture true for the [cdr] of the list and
  try to prove it for the entire list.  Notice that the prover does
  some simplification and then prints out an updated version of the
  goal (Subgoal *1/1').  Examining these gives you a pretty good idea
  of what's going on in the proof.

  Sometimes one goal is split into a number of subgoals, as happened
  with the induction above.  Sometimes after some initial processing
  the prover decides it needs to prove a subgoal by induction; this
  subgoal is given a name and pushed onto a stack of goals.  Some
  steps, like generalization (see ACLH), are not necessarily validity
  preserving; that is, the system may adopt a false subgoal while
  trying to prove a true one.  (Note that this is ok in the sense
  that it is not ``unsound.'' The system will fail in its attempt to
  establish the false subgoal and the main proof attempt will fail.)
  As you gain facility with using the prover, you'll get pretty good
  at recognizing what to look for when reading a proof script.  The
  prover's [proof-tree] utility helps with monitoring an ongoing
  proof and jumping to designated locations in the proof (see
  [proof-tree]).  See [tips] for a number of useful pointers on using
  the theorem prover effectively.

  When the prover has successfully proved all subgoals, the proof is
  finished.  As with a [defun], a [summary] of the proof is printed.
  This was an extremely simple proof, needing no additional guidance.
  More realistic examples typically require the user to look
  carefully at the failed proof log to find ways to influence the
  prover to do better on its next attempt.  This means either:
  proving some rules that will then be available to the prover,
  changing the global state in ways that will affect the proof, or
  providing some [hints] locally that will influence the prover's
  behavior.  Proving this lemma (my-app-length) is an example of the
  first.  Since this is a [rewrite] rule, whenever in a later proof
  an instance of the form (LEN (MY-APP X Y)) is encountered, it will
  be rewritten to the corresponding instance of (+ (LEN X) (LEN Y)).
  Disabling the rule by executing the [command]

    (in-theory (disable my-app-length)),

  is an example of a global change to the behavior of the prover since
  this [rewrite] will not be performed subsequently (unless the rule
  is again [enable]d).  Finally, we can add a (local) [disable]
  ``hint'' to a [defthm], meaning to [disable] the lemma only in the
  proof of one or more subgoals.  For example:

    (defthm my-app-length-commutativity
      (equal (len (my-app x y))
             (len (my-app y x)))
      :hints ((\"Goal\" :in-theory (disable my-app-length))))

  In this case, the hint supplied is a bad idea since the proof is much
  harder with the hint than without it.  Try it both ways.

  By the way, to undo the previous event use :u (see [u]).  To undo
  back to some earlier event use :ubt (see [ubt]).  To view the
  current event use :pe :here.  To list several [events] use :pbt
  (see [pbt]).

  Notice the form of the hint in the previous example (see [hints]).
  It specifies a goal to which the hint applies.  \"Goal\" refers to
  the top-level goal of the theorem.  Subgoals are given unique names
  as they are generated.  It may be useful to suggest that a function
  symbol be [disable]d only for Subgoal 1.3.9, say, and a different
  function [enable]d only on Subgoal 5.2.8.  Overuse of such [hints]
  often suggests a poor global proof strategy.

  We now recommend that you visit [documentation] on additional
  examples.  See [annotated-ACL2-scripts].")
 (ALWAYS$ (POINTERS) "See [loop$].")
 (ALWAYS$+ (POINTERS) "See [loop$].")
 (ANALYZING_COMMON_LISP_MODELS
  (PAGES_WRITTEN_ESPECIALLY_FOR_THE_TOURS)
  "Analyzing Common Lisp Models

  To analyze a model you must be able to reason about the operations
  and relations involved.  Perhaps, for example, some aspect of the
  model depends upon the fact that the concatenation operation is
  associative.

  In any Common Lisp you can confirm that

    (app '(A B) (app '(C D) '(E F)))

  and

    (app (app '(A B) '(C D)) '(E F)))

  both evaluate to the same thing, (A B C D E F).

  But what distinguishes ACL2 (the logic) from applicative Common Lisp
  (the language) is that in ACL2 you can prove that the concatenation
  function app is associative when its arguments are true-lists,
  whereas in Common Lisp all you can do is test that proposition.

  That is, in ACL2 it makes sense to say that the following formula is
  a ``theorem.''

    Theorem Associativity of App
    (implies (and (true-listp a)
                  (true-listp b))
             (equal (app (app a b) c)
                    (app a (app b c))))

  Theorems about the properties of models are proved by symbolically
  manipulating the operations and relations involved.  If the
  concatenation of sequences is involved in your model, then you may
  well need the theorem above in order to that your model has some
  particular property.")
 (AND
  (BASICS ACL2-BUILT-INS)
  "Conjunction

  And is the macro for conjunctions.  And takes any number of
  arguments.  And returns nil if one of the arguments is nil, but
  otherwise returns the last argument.  If there are no arguments,
  and returns t.

  And is a Common Lisp macro.  See any Common Lisp documentation for
  more information.

  Macro: <and>

    (defmacro and (&rest args)
              (and-macro args))

  Function: <and-macro>

    (defun and-macro (lst)
           (declare (xargs :guard t))
           (if (consp lst)
               (if (consp (cdr lst))
                   (list 'if
                         (car lst)
                         (and-macro (cdr lst))
                         nil)
                   (car lst))
               t))")
 (ANNOTATED-ACL2-SCRIPTS
  (ACL2-TUTORIAL)
  "Examples of ACL2 scripts

  Beginning users may find these annotated scripts useful.  We suggest
  that you read these in the following order:

    [Tutorial1-Towers-of-Hanoi]
    [Tutorial2-Eights-Problem]
    [Tutorial3-Phonebook-Example]
    [Tutorial4-Defun-Sk-Example]
    [Tutorial5-Miscellaneous-Examples]

  You can also find useful demos in the [community-books] directory,
  books/demos/, and its subdirectories.

  The web page {Brief ACL2 Tutorial |
  http://www.cs.utexas.edu/users/moore/publications/tutorial/rev3.html}
  contains a script that illustrates how it feels to use The Method
  to prove an unusual list reverse function correct.  The screen
  shots of ACL2's proof output are outdated --- in the version shown,
  ACL2 does not print Key Checkpoints, but the concept of key
  checkpoint is clear in the discussion and the behavior of the user.

  See {Polishing Proofs Tutorial |
  http://www.cs.utexas.edu/users/moore/acl2/contrib/POLISHING-PROOFS-TUTORIAL.html}
  for a tutorial on becoming successful at approaching a
  formalization and proof problem in ACL2.  That tutorial, written by
  Shilpi Goel and Sandip Ray, has two parts: it illustrates how to
  guide the theorem prover to a successful proof, and it shows how to
  clean up the proof in order to facilitate maintenance and extension
  of the resulting book (see [books]).

  The {ACL2 Demo Given at TPHOLs 2008 |
  http://www.cs.utexas.edu/users/moore/publications/tutorial/kaufmann-TPHOLs08/index.html}
  by Matt Kaufmann includes scripts and a gzipped tar file containing
  the entire contents of the demos.

  The {sort equivalence demo |
  http://www.cs.utexas.edu/users/moore/publications/tutorial/sort-equivalence}
  is a collection of scripts illustrating both high-level strategy
  and lower-level tactics dealing with the functional equivalence of
  various list sorting algorithms.  Start with the README on that
  directory.  There is also a {gzipped tar file |
  http://www.cs.utexas.edu/users/moore/publications/tutorial/sort-equivalence.tgz}
  with all of these scripts.

  When you feel you have read enough examples, you might want to try
  the following very simple example on your own. (See
  [solution-to-simple-example] for a solution, after you work on this
  example.)  First define the notion of the ``fringe'' of a tree,
  where we identify trees simply as [cons] structures, with [atom]s
  at the leaves.  For example:

    ACL2 !>(fringe '((a . b) c . d))
    (A B C D)

  Next, define the notion of a ``leaf'' of a tree, i.e., a predicate
  leaf-p that is true of an atom if and only if that atom appears at
  the tip of the tree.  Define this notion without referencing the
  function fringe.  Finally, prove the following theorem, whose proof
  may well be automatic (i.e., not require any lemmas).

    (defthm leaf-p-iff-member-fringe
      (iff (leaf-p atm x)
           (member-equal atm (fringe x))))


Subtopics

  [Solution-to-simple-example]
      Solution to a simple example

  [Tutorial1-towers-of-hanoi]
      The Towers of Hanoi Example

  [Tutorial2-eights-problem]
      The Eights Problem Example

  [Tutorial3-phonebook-example]
      A Phonebook Specification

  [Tutorial4-defun-sk-example]
      Example of quantified notions

  [Tutorial5-miscellaneous-examples]
      Miscellaneous ACL2 examples")
 (AN_EXAMPLE_COMMON_LISP_FUNCTION_DEFINITION
  (PAGES_WRITTEN_ESPECIALLY_FOR_THE_TOURS)
  "An Example Common Lisp Function Definition

  {IMAGE} (see [An_Example_of_ACL2_in_Use])

  Consider the binary trees x and y below.

  {IMAGE}

  In Lisp, x is written as the list '(A B) or, equivalently, as '(A B .
  NIL).  Similarly, y may be written '(C D E).  Suppose we wish to
  replace the right-most tip of x by the entire tree y.  This is
  denoted (app x y), where app stands for ``append''.

  {IMAGE}

  We can define app with:

    (defun app (x y)                           ; Concatenate x and y.
      (declare (type (satisfies true-listp) x)); We expect x to end in NIL.
      (cond ((endp x) y)                       ; If x is empty, return y.
            (t (cons (car x)                   ; Else, copy first node
                     (app (cdr x) y)))))       ;  and recur into next.

  If you defined this function in some Common Lisp, then to run app on
  the x and y above you could then type

    (app '(A B) '(C D E))

  and Common Lisp will print the result (A B C D E).

  {IMAGE} (see [An_Example_of_ACL2_in_Use])")
 (AN_EXAMPLE_OF_ACL2_IN_USE
  (PAGES_WRITTEN_ESPECIALLY_FOR_THE_TOURS)
  "An Example of ACL2 in Use

  {IMAGE} (see [How_To_Find_Out_about_ACL2_Functions])

  To introduce you to ACL2 we will consider the app function discussed
  in the Common Lisp (see [Common_Lisp]) page, except we will omit
  for the moment the declare form, which in ACL2 is called a guard.

  Guards are arbitrary ACL2 terms that express the ``intended domain''
  of functions.  In that sense, guards are akin to type signatures.
  However, Common Lisp and ACL2 are untyped programming languages:
  while the language supports several different data types and the
  types of objects can be determined by predicates at runtime, any
  type of object may be passed to any function.  Thus, guards are
  ``extra-logical.'' Recognizing both the practical and intellectual
  value of knowing that your functions are applied to the kinds of
  objects you intend, ACL2 imposes guards on Common Lisp and provides
  a means of proving that functions are used as intended.  But the
  story is necessarily complicated and we do not recommend it to the
  new user.  Get used to the fact that any ACL2 function may be
  applied to any objects and program accordingly.  Read about guards
  later.

  Here is the definition again

    (defun app (x y)
      (cond ((endp x) y)
            (t (cons (car x)
                     (app (cdr x) y)))))

  The next few stops along the Walking Tour will show you

    * how to use the ACL2 documentation,
    * what happens when the above definition is submitted to ACL2,
    * what happens when you evaluate calls of app,
    * what one simple theorem about app looks like,
    * how ACL2 proves the theorem, and
    * how that theorem can be used in another proof.

  Along the way we will talk about the definitional principle, types,
  the ACL2 read-eval-print loop, and how the theorem prover works.

  When we complete this part of the tour we will return briefly to the
  notion of guards and revisit several of the topics above in that
  context.

  {IMAGE} (see [How_To_Find_Out_about_ACL2_Functions])")
 (APPEND
  (LISTS ACL2-BUILT-INS)
  "[concatenate] zero or more lists

  Append, which takes zero or more arguments, expects all the arguments
  except perhaps the last to be true (nil-terminated) lists.  It
  returns the result of concatenating all the elements of all the
  given lists into a single list.  Actually, in ACL2 append is a
  macro that expands into calls of the binary function
  [binary-append] if there are at least two arguments; if there is
  just one argument then the expansion is that argument; and finally,
  (append) expands to nil.

  Append is a Common Lisp function.  See any Common Lisp documentation
  for more information.  See [append-without-guard] for a version of
  append that has a guard of t.

  Macro: <append>

    (defmacro append (&rest rst)
              (cond ((null rst) nil)
                    ((null (cdr rst)) (car rst))
                    (t (xxxjoin 'binary-append rst))))

  Function: <binary-append>

    (defun binary-append (x y)
           (declare (xargs :guard (true-listp x)))
           (cond ((endp x) y)
                 (t (cons (car x)
                          (binary-append (cdr x) y)))))


Subtopics

  [Binary-append]
      [concatenate] two lists")
 (APPEND$ (POINTERS) "See [loop$].")
 (APPEND$+ (POINTERS) "See [loop$].")
 (APPLY$
  (ACL2-BUILT-INS PROGRAMMING)
  "Apply a badged function or tame lambda to arguments

  We recommend that you read the paper {``Limited Second-Order
  Functionality in a First-Order Setting'' |
  http://www.cs.utexas.edu/users/kaufmann/papers/apply/index.html} by
  Matt Kaufmann and J Strother Moore for both motivation and
  foundational details.  You might also read
  [introduction-to-apply$]!

  This documentation starts with a glossary of terms.  Then we provide
  some examples and present the specification of apply$.  Next, we
  deal with issues related to apply$ in definitions, stating and
  proving theorems, guards and guard verification, and top-level
  evaluation.  Finally we exhibit the formal definitions apply$ and
  some related concepts.  We have sprinkled in a little tutorial
  material for readability but have not provided much motivation for
  some design decisions.


Glossary

  Here is a brief glossary of terms used in the semantics of apply$.
  While we provide links to the documentation of the concepts, we
  urge you not to follow those links until you've understood the big
  picture!

    * apply$ --- the ACL2 function that takes two arguments, one
      representing a function and the other listing actuals to be fed
      to that function.  Under certain conditions, apply$ applies the
      function to the arguments and returns the result.  Apply$ is
      mutually recursive with [apply$-lambda], [ev$], and [ev$-list].
      Apply$'s ``badge'' (see below) is (APPLY$-BADGE 2 1 :FN NIL)
      its arity is 2, its ``out arity'' is 1 (i.e., it returns 1
      result), its first argument has ``ilk'' :FN and is thus treated
      as a ``function;'' its second argument has ilk NIL and is thus
      treated as an ordinary object.
    * [badge] --- an object associated with some function symbols
      indicating that apply$ can ``handle'' them and under what
      conditions.  The badge of a function symbol specifies its
      arity, its ``out arity,'' (i.e., the number of results the
      function returns), and the [ilk] of each argument position
      telling apply$ how each argument is treated.  The ilks are :FN,
      :EXPR and NIL.  The association between a non-primitive
      function symbol and its badge is manged by [warrant]s.  In
      proofs, apply$ must have a warrant for every non-primitive
      function symbol to be applied.  Those warrants are provided as
      hypotheses to the theorem being proved.  Symbols without badges
      cannot be apply$d.  Badges are generated, when possible, by
      [defwarrant].  (Badges can be generated for :program mode
      functions by [defbadge], allowing apply$ to handle such
      functions in top level evaluation not in proofs.)  Not every
      function symbol can have a badge.
    * compiled LAMBDA cache (or simply cache in this context) --- a cache
      in the raw Lisp under ACL2 that supports the application of
      apply$ on well-formed, guard verified LAMBDA objects.  Later in
      this Glossary we define ``lambda expression,'' ``LAMBDA
      object,'' and ``lambda$ expression'' --- three similar looking
      phrases with very different meanings.  See [print-cl-cache] for
      some details of the cache.
    * evaluation theory --- the logical theory in which expressions
      submitted at the top level of the ACL2 read-eval-print loop are
      evaluated.  The evaluation theory is a consistent extension of
      the proof theory, the latter being the logical theory in which
      the ACL2 theorem prover operates.  The evaluation theory was
      introduced in ACL2 when [defattach] was added, but it was
      changed with the introduction of apply$.  All [warrant]s
      introduced by defwarrant are assumed true in the evaluation
      theory but not in the proof theory.  This means ACL2 can
      execute calls of apply$ that arise in the evaluation of
      top-level input, but ACL2 cannot evaluate all calls of apply$
      that arise in proofs unless the appropriate warrants are
      available as hypotheses.  See
      [guarantees-of-the-top-level-loop] for some details of the
      evaluation theory and how it differs from the proof theory
      supported by the ACL2 theorem prover.
    * lambda expression --- an integral part of ACL2's formal term syntax,
      lambda expressions are the way let expressions and other
      variable-binding idioms are translated into formal terms.
      Lambda expressions have nothing to do with apply$!  See
      [lambda] for a discussion of three confusingly similar but
      different concepts: lambda expressions, LAMBDA objects, and
      lambda$ expressions.  Read carefully anytime you see the word
      ``lambda!''
    * LAMBDA object --- an ACL2 list constant, typically of the form
      (LAMBDA vars body) or (LAMBDA vars dcl body) that may be used
      as a ``function'' by apply$.  Apply$ treats any [consp] object
      in its first argument position as though it were a LAMBDA
      object.  But it only gives sensible meanings to [tame] LAMBDA
      objects.  And only well-formed LAMBDA objects are executed
      efficiently.  But well-formed LAMBDA objects are hard to type
      by hand --- there are many constraints to keep in mind to
      guarantee well-formedness.  See [well-formed-lambda-objectp] if
      you really want to see all the rules.  But that is generally
      unnecessary.  We strongly recommend not entering LAMBDA objects
      as quoted constants, e.g., '(LAMBDA (X) (+ 1 X)) --- which is
      actually ill-formed!  Instead, use [lambda$], as in (lambda$
      (x) (+ 1 x)).  See also [lambda] for some clarifications.
    * [lambda$] expression --- an ACL2 macro that allows you to enter
      quoted well-formed LAMBDA objects into your terms by typing
      untranslated expressions that resemble lambda expressions.  The
      lambda$ expression (lambda$ (x) (+ 1 x)) essentially translates
      into the quoted LAMBDA object '(LAMBDA (X) (BINARY-+ '1 X)).
      We say ``essentially'' because lambda$ always inserts a
      (DECLARE (IGNORABLE v1 ... vn)) listing every formal and tags
      the body with a [return-last] form that indicates it came from
      a translated lambda$. See also [lambda] for some
      clarifications.
    * [scion] --- a function that is ancestrally dependent on apply$.  In
      the early days of apply$ we called scions ``mapping functions''
      but in the Lisp community that implies iteration over a list
      and scions are more general.  Of course, a function that
      iterates over a list apply$ing a ``function'' to each element
      and collecting the results is an example of a scion.  But so is
      function that takes a ``function'' and applies it in one
      special situation, e.g., as a test or base case.  Any function
      ancestrally dependent on apply$ is a scion whether or not it
      takes a ``function'' as an argument or maps over a domain.
    * [tame] --- the class of functions that apply$ knows about; we
      actually talk about ``tame functions,'' ``tame LAMBDA
      objects,'' and ``tame expressions.'' The last are expressions
      that are evaluable by an interpreter named [ev$] that is
      mutually-recursive with apply$.  Apply$ cannot handle all
      defineable functions: ACL2 is first order and if apply$ were
      able to ``handle'' certain functions the logic would be
      inconsistent.
    * [warrant] --- a 0-ary predicate associated with some user-defined
      function symbols that must be a hypothesis of any theorem whose
      proof involves ``expanding'' apply$ on such symbols; the
      warrant gives apply$ ``permission'' to expand if the arguments
      to which the function is applied are appropriately [tame].  The
      warrant for a function specifies the function's [badge] and how
      apply$ behaves on the function symbol.  Warrants (and badges)
      are computed and introduced by the [defwarrant] event.  Not all
      function symbols can be warranted.

  You will get a much better understanding of these concepts if you
  read the paper cited above.


Examples

  To illustrate apply$ and some related concepts we need some
  user-defined functions.  We therefore imagine that the following
  events have been successfully admitted.

  We strongly recommend that you include the following book in any
  session in which you intend to use or reason about apply$.

    (include-book \"projects/apply/top\" :dir :system)

    (defun$ sq (x) (* x x))

    (defun$ collect$ (fn lst)
      (if (endp lst)
          nil
          (cons (apply$ fn (list (car lst)))
                (collect$ fn (cdr lst)))))

    (defun$ foldr (lst fn init)
      (if (endp lst)
          init
          (apply$ fn
                  (list (car lst)
                        (foldr (cdr lst) fn init)))))

    (defun$ russell (fn x)
      (not (apply$ fn (list x x))))

  Note: Collect$ is pre-defined in ACL2 because it is part of the
  support for the [loop$] statement.

  Collect$ and foldr might informally be called ``mapping functions''
  because they map a given function over some domain and accumulate
  the answers somehow.  They are useful examples of what we call
  scions of apply$ or simply scions: functions in which apply$ is
  ancestral, i.e., functions that call apply$ or call functions that
  call apply$, etc.  Russell is also a scion.  See [scion] for more.

  Here are some evaluations carried out at the top-level of the ACL2
  loop after the events above.  Top-level evaluations take place in
  ACL2's evaluation theory (see the discussion of the semantics of
  [defattach]), which is an extension of the theory in which proofs
  are conducted.  Put more bluntly, the following evaluations won't
  be carried out in proofs unless you have the right hypotheses!

    ACL2 !>(apply$ 'sq '(5))
    25

    ACL2 !>(collect$ 'sq '(1 2 3 4 5))
    (1 4 9 16 25)

    ACL2 !>(collect$ (lambda$ (x) (* x x)) '(1 2 3 4 5))
    (1 4 9 16 25)

    ACL2 !>(foldr '(1 2 3) 'cons '(4 5 6))
    (1 2 3 4 5 6)

    ACL2 !>(foldr '(1 2 3 4 5)
                  (lambda$ (x y)
                    (cons (sq x) y))
                  nil)
    (1 4 9 16 25)

    ACL2 !>(foldr '(1 2 3 4)
                  (lambda$ (x y) (foldr y 'cons (list x)))
                  nil)
    (4 3 2 1)

    ACL2 !>(russell 'natp 3)
    NIL

    ACL2 !>(russell 'consp 3)
    T

  Apply$ doesn't always work the way you might want!

    ACL2 !>(let ((x 'russell))(russell x x))

    ACL2 Error in TOP-LEVEL:  The value of APPLY$-USERFN is not specified when
    the first argument, fn, is RUSSELL, and the second argument, args,
    is (RUSSELL RUSSELL).  Fn has badge (APPLY$-BADGE 2 1 :FN NIL) and
    args is not known to satisfy the tameness requirement of that badge.

  [Apply$-userfn] is the undefined function called by apply$ when it
  is asked to apply a user-defined function symbol instead of a
  builtin function symbol.  The [warrant] for russell actually
  specifies the value of (apply$-userfn 'russell ...) under the
  [tame]ness requirements, and those requirements are violated above.
  This is necessary to preserve the consistency of the logic.
  Otherwise:

    (russell 'russell 'russell)
    = {by defun of russell}
    (not (apply$ 'russell (list 'russell 'russell)))
    =  {by the naive expectation that apply$ always ``works''}
    (not (russell 'russell 'russell))
    Contradiction!

  Top-level evaluation of apply$ expressions raises problems not seen
  anywhere else in ACL2's execution model: While executing
  syntactically legal terms the evaluator can encounter undefined
  functions or weirdly ill-formed terms not caught by the usual ACL2
  translation mechanism.  The ACL2 translation mechanism checks the
  well-formedness of [lambda$] expressions (and user-typed quoted
  LAMBDA objects) that occur in positions of ilk :FN and are
  therefore destined for apply$.  But the translation checks can be
  defeated.  The LAMBDA object below contains a call of the undefined
  function foo but the error is not caught at translation time; it is
  caught only when the form executed.

    ACL2 !>(apply$ `(lambda (x) (foo x)) '(5))

    ACL2 Error in TOP-LEVEL:  The value of BADGE-USERFN is not specified
    on FOO because FOO is not a known function symbol.

  Note the backquote on the LAMBDA object.  This defeats the check of
  well-formedness because the LAMBDA object is not quoted.  We could
  have equally written

    ACL2 !>(apply$ (list 'lambda '(x) (cons 'foo '(x))) '(5))

  with the same result.  There is nothing unsound about this.  Apply$
  can take any objects as arguments.  But it won't always ``behave''
  as you might expect.  One way to explore the edge cases of apply$
  is to execute it on ill-formed input.  In addition, some theorems
  may require consing up a LAMBDA object in terms of objects used
  elsewhere in the theorem.  See example theorem [3] below.

  A peculiar aspect of LAMBDA objects is that they can be written as
  legal ACL2 constants before they are well-formed LAMBDA objects,
  e.g., by referring to undefined functions, :program mode functions,
  unbadged functions, etc.  They are, after all, just arbitrary
  quoted objects and any value in ACL2 can be quoted.  But an
  ill-formed object can become well-formed if the world is
  appropriately extended, e.g., the appropriate defuns, defbadges,
  and defwarrants are made.  Perhaps worse, they can be well-formed
  and then become ill-formed by an undo.  So at runtime apply$ has to
  check that the function symbol or LAMBDA object is appropriate.
  There is a sophisticated cache behind the execution machinery for
  LAMBDA objects in the evaluation theory.  See [print-cl-cache].

  Here are some theorems that can be proved about these concepts.  The
  last of the theorems shown below requires two lemmas, named
  weird-little-lemma1 and weird-little-lemma2, shown in
  books/projects/apply/report.lisp.

    ; [1] SQ squares, if you have the warrant for sq!  Imagine for a moment that
    ; we could prove (equal (apply$ 'SQ (list i)) (* i i)) without the warrant
    ; hypothesis shown below.  And imagine that we did so in an encapsulated
    ; environment in which sq was locally defined to be (* x x).  Then imagine we
    ; exported the simpler theorem out of that encapsulate and defined sq to be
    ; (+ 1 (* x x)).  Then ACL2 would be unsound.  Exporting a theorem requires
    ; that the theorem be ancestrally independent of every locally defined
    ; function and the simpler hypothetical theorem is, because the symbol 'SQ is
    ; not ancestrally dependent on sq.  But ACL2 cannot prove the simpler
    ; theorem!  It cannot ``open'' apply$ on 'SQ without the warrant for sq and
    ; the warrant for sq is ancestrally dependent on sq.  So the theorem below
    ; cannot be exported from an environment in which sq is locally defined.
    ; Thus warrants solve the so-called ``LOCAL problem.''

    (thm (implies (warrant sq)
                  (equal (apply$ 'SQ (list i))
                         (* i i))))

    ; [2] Collect$ distributes over append for any fn.

    (thm (equal (collect$ fn (append a b))
                (append (collect$ fn a)
                        (collect$ fn b))))

    ; [3] Foldr can be used to collect$, but the collection must
    ; be with an ``ok'' function (a tame function of one
    ; argument).  Note the backquote on the LAMBDA.  This is
    ; a theorem that requires us to cons up a LAMBDA object.

    (thm (implies (ok-fnp fn)
                  (equal (foldr lst
                                `(LAMBDA (X Y) (CONS (,fn X) Y))
                                nil)
                         (collect$ fn lst))))


Specification of APPLY$

  We strongly recommend that you include the following book in any
  session in which you intend to use or reason about apply$.

    (include-book \"projects/apply/top\" :dir :system)

    General Form:
    (apply$ fn args)

  where fn is some function symbol or LAMBDA object and args is a true
  list.  Informally, apply$ applies the function named by the first
  argument to the appropriate number of elements taken from the
  second argument.  We might express this as:

    Naive Specification (for a single-valued function):
    (apply$ 'fn args) = (fn (nth 0 args) ... (nth (- n 1) args))

    Naive Specification (for a multi-valued function):
    (apply$ 'fn args) = (mv-list k (fn (nth 0 args) ... (nth (- n 1) args)))

  where fn is of arity n and k is the ``out arity'' of fn (the number
  of returned values).  However, these naive specifications are
  guaranteed only if either (i) fn is a function symbol that has a
  [badge] and args satisfies the [tame]ness requirements of the
  badge, or (ii) fn is a well-formed LAMBDA object that returns 1
  result.  The tameness requirement is that if an element of args is
  in an argument position of fn with ilk :FN then the element must
  satisfy tamep-functionp and if the element is in an argument
  position of ilk :EXPR it must satisfy tamep.  See [badge] for
  further discussion of condition (i).  As for (ii), rather than
  explain ``well-formed LAMBDA object'' here we encourage you to
  write [lambda$] expressions when you want to apply$ a LAMBDA
  object.

  The [ilk]s of apply$ are :FN and NIL respectively, telling us that
  apply$ treats its first argument as a ``function'' and its second
  as an ordinary object (never as a function).  Initially apply$ and
  several functions used in the translation of loop$ statements are
  the only symbols in ACL2 with an ilk of :FN.  However as
  [defwarrant] is used successfully on [scion]s --- functions that
  somehow call apply$ --- user-defined symbols can have ilk :FN too.

  Apply$ has a guard, namely (apply$-guard fn args).  This is an
  exceptionally weak guard, requiring only that args be a true-list
  and, if fn is a cons --- which is automatically treated as a LAMBDA
  object --- the length of args be the length of the second element
  of fn.  We discuss guards and guard verification in a subsequent
  section.

  Note for Experts: Technically, apply$ treats any consp object as a
  LAMBDA object.  But the results are as you'd naively expect only if
  the object is a [tame] LAMBDA object.  However, we frequently write
  as though the object must be well-formed, which is different from
  but implies tameness.  What's going on?  The reason for this and
  related discrepancies in the documentation is that there is a
  tension between the logical definition of apply$ and the practical
  business of executing it.  The former involves the existence of a
  model, soundness, and the difficulty of proving theorems about
  apply$.  The latter involves the Common Lisp compiler.  We want the
  logical foundations to be simple to make it easier to reason about
  apply$, but the compiler imposes unavoidable and complicated
  restrictions.  The upshot is that the logical foundations assign
  meaning to LAMBDA objects that cannot be compiled.  Applying merely
  ``tame'' LAMBDAs is slower than applying ``well-formed'' ones.  In
  a sense, by acting like ``tame LAMBDA objects'' and ``well-formed
  LAMBDA objects'' are synonymous we're trying to trick you!  If you
  ever have occasion to formally express the restrictions on apply$
  in some theorem, use tamep-functionp.  But when you write concrete
  LAMBDA constants, try to keep them well-formed.  We encourage this
  by providing [lambda$] and by enforcing full blown well-formedness
  checks --- not just tameness checks --- in translate on every
  quoted LAMBDA object entered in a :FN slot.  And we give you ways
  to circumvent these checks --- see
  [gratuitous-lambda-object-restrictions] --- if you really mean to
  supply ill-formed LAMBDA objects to :FN slots.

  Badges are assigned by [defwarrant], and also by [defbadge].  See
  [badge] for documentation about how to find out whether a function
  has a badge and how to interpret a badge.  The terms ``out arity''
  and ``tameness requirements,'' used above, are explained there too.

  Intuitively, the badge of fn tells apply$ how each formal of fn is
  used in the definition of fn and there are only three ``ilks'' of
  use.  Ilk :FN means the formal is used exclusively as a function,
  meaning the formal can be passed into :FN slots of other functions
  and eventually reaches apply$, but it is never touched by other
  ACL2 functions.  Ilk :EXPR means the formal is used exclusively as
  an expression, meaning the formal may be passed into :EXPR slots of
  other functions and eventually reaches [ev$], but is never
  otherwise touched.  Finally, ilk NIL means the formal is treated as
  an ordinary ACL2 object and, in particular, never used as either a
  function or an expression.  The ``tameness requirement'' on each
  actual is determined by the ilk of the corresponding formal:
  actuals in :FN slots must satisfy tamep-functionp, actuals in :EXPR
  slots must satisfy tamep, and there are no requirements on actuals
  in ilk NIL slots.  For discussions of tamep-functionp and tamep see
  the topic [tame].

  Generally speaking, if you want to be able to apply$ a function you
  should introduce it with [defun] and then call [defwarrant] on the
  function name, or use [defun$], which is a convenient abbreviation
  for the above sequence of events.  But defun$ only works for :logic
  mode functions because defwarrant enforces that restriction.  If
  you want to apply$ a :program mode function you should define it
  with defun and then call defbadge on its name.

  We summarize the specification of apply$ with an example.  Consider

    (apply$ 'foldr
            '((1 2 3)     ; actual 1
              cons        ; actual 2
              (4 5 6)))   ; actual 3

  The badge of foldr, computed by (badge 'foldr), is (APPLY$-BADGE 3 1
  NIL :FN NIL).  The arity is 3, the out arity is 1 (foldr is
  single-valued) and the ilks list is (NIL :FN NIL).  Thus the first
  and third formals have ilk NIL and are treated as ordinary objects;
  the second formal has ilk :FN and is treated as a function.  Thus,
  the tameness requirement is that the second actual to a call of
  foldr must satisfy tamep-functionp.  Referring to the specification
  above, we see that the apply$ term has the ``naive specification''
  since foldr has a badge, its out arity is 1, and its second actual,
  cons, satisfies tamep-functionp. That is,

    (apply$ 'foldr
            '((1 2 3)     ; actual 1
              cons        ; actual 2
              (4 5 6)))   ; actual 3
    =
    (foldr '(1 2 3) 'cons '(4 5 6))
    =
    '(1 2 3 4 5 6)

  The first equation above is just the naive specification of apply$
  and the second equation is just the definition of foldr.

  Formals are classified by [defwarrant] when it tries to compute the
  badge of a function.  What are the rules that lead to a formal
  being assigned ilk :FN, for example?  What does ilk :FN actually
  signify?

  Let v be the i th formal parameter of a badged function fn.  If the
  badge says that v has ilk :FN then we know that v  is ``used as a
  function'' in the definition of fn , i.e., the value of v
  eventually makes its way into the first argument of apply$.
  Furthermore, v  is never used any other way: every place v  occurs
  in the body it is treated as a function.  And finally, in every
  recursive call of fn  v  is passed identically in the i th argument
  position of every recursive call.

  If the badge says that formal variable v  has ilk :EXPR then it
  signifies analogous conditions except that instead of eventually
  getting into the first argument of apply$ it eventually gets into
  the first argument of ev$.  We say such formals are ``used as
  expressions.'' [Ev$] is the natural notion of evaluation in this
  context: look up the values of variables in the alist argument to
  ev$, return quoted constants, and otherwise apply$ function symbols
  and lambda objects to the recursively obtained list of values
  returned by evaluating the actuals.  However, ev$ first checks that
  the expression is [tamep].

  If the badge says a formal v  has ilk NIL in the definition of fn
  then v  is never used  as a function or as an expression in the
  definition.

  It is the job of [defwarrant] to analyze a definition and assign
  ilks, if possible.  But it may not be possible!  For example,

    (defun foo (x) (apply$ x (list x)))

  is such a definition.  The formal x is used as a function in its
  first occurrence but is not used as a function in its second.  Thus

    (defwarrant foo)

  will fail.

  When successful, [defwarrant] also defines the [warrant] function for
  the function it analyzed.  Warrants are crucial to stating and
  proving theorems about function symbols being applied with apply$.
  We illustrated warrants in the ``Examples'' section above and
  discuss them further in the section on ``Theorems Involving
  Apply$'' below.  See also [warrant].

  Apply$ is a defined function in the ACL2 source code.  We exhibit its
  definition at the end of this documentation but you may also see
  its definition by doing

    ACL2 !>:pe apply$

  The definition is mutually recursive with

    * [apply$-lambda]: used by apply$ to handle the case when the first
      argument to apply$ is a LAMBDA object.
    * [ev$]: used by apply$-lambda to evaluate the body of a LAMBDA object
      in an environment binding the object's formal variables to the
      actuals.
    * [ev$-list]: used by ev$ to evaluate a list of expressions in an
      environment binding formals to actuals.

  Apply$ calls three undefined functions:

    * [apply$-userfn]: used by apply$ when it is asked to apply anything
      other than a LAMBDA object or a built-in function symbol.  In
      the evaluation theory, we attach a function to apply$-userfn
      that explicitly enforces the tameness requirements for each
      user-defined :logic mode function symbol that has had a badge
      computed by [defwarrant] and, if those requirements are met,
      applies the corresponding function.  Magically, that attachment
      to apply$-userfn can also evaluate :program mode functions with
      badges created by [defbadge].  We say ``magically'' because
      there are no axioms that explain this behavior, just as there
      are no axioms that explain how you can evaluate ordinary calls
      of :program mode functions in the evaluation theory.  But in
      the proof theory apply$-userfn remains undefined.  The value of
      (apply$-userfn 'fn ...), and thus of (apply$ 'fn ...), is
      specified by a special hypothesis, called the ``warrant for
      fn.'' You can't prove anything interesting about the behavior
      of apply$ on a user-defined function symbol fn unless the
      warrant for fn is a governing hypothesis.  We discuss warrants
      in [warrant].  See also [defwarrant].
    * untame-apply$: used by apply$ when it is asked to deal with a
      situation in which tameness is violated.
    * untame-ev$: used by ev$ when it is asked to deal with a situation in
      which tameness is violated.


Definitions Involving on Apply$

  In one sense, apply$ is just an ordinary ACL2 function that takes two
  arguments and returns one result.  Like all ACL2 functions, apply$
  is untyped.  You can supply any two objects as arguments and the
  axioms tell you what the result is --- though sometimes the result
  is delivered by an undefined function.

  But in a deeper sense, if you want apply$ to ``behave,'' and in
  particular if you want functions that use apply$ to ``behave,'' you
  have to follow certain rules.  For example, ACL2 must be able to
  determine whether a formal parameter is ``used as a function'' in a
  given definition.  Basically, you will want every :logic mode
  function that you define to be processed by defwarrant so that it
  gets a badge and warrant if at all possible and at least has a
  chance of being applied as expected by apply$.

  The macro defun$ is just an abbreviation for a defun followed by a
  defwarrant and it is easy to imagine the other ACL2 definitional
  idioms introduced in the ACL2 Community Books eventually being
  extended to include a subsequent defwarrant.

  So the question becomes ``What rules must a defun obey in order to be
  processed successfully by defwarrant?'' The full answer is given in
  the documentation for [defwarrant].  But here are some guidelines
  to follow:

    * use :logic mode,
    * use a measure that either returns a natural number or a lexicographic
      combination of natural numbers as defined by the llist function
      in the Community Books at books/ordinals/,
    * make sure every function used in the definition has a badge,
    * ensure that every :FN slot in the body is occupied either by a formal
      parameter or a quoted, badged function symbol or [lambda$]
      expression, and
    * ensure that no parameter occupying a :FN slot is ever used in a slot
      of any other ilk, and
    * ensure that every parameter passed into a :FN slot is passed into the
      same argument position in any recursive calls of the function
      being defined.

  You can certainly violate some of these rules and still get an
  admissible definition.  For example (defun rus (x) (not (apply$ x
  (list x)))) is admissible and you can run it on some arguments,
  e.g., (rus 'consp) evaluates to T.  You can even prove (equal (rus
  'consp) t).  But (defwarrant rus) fails because rus violates the
  rules.  So you will not be able to apply$ 'rus.

  Note for Experts: One may wonder why it is possible to warrant a
  function, fn, that calls badged but unwarranted functions.  Naively
  one might expect the semantics of (apply$ 'fn args would involve
  the ev$ of the body of fn and therefore require the successful
  application (via apply$) of subfunctions in the body.  But that
  expectation is incorrect.  The semantics of (apply$ 'fn args) as
  formalized by the warrant for fn says that (under restrictions on
  the tameness of the arguments) (apply$ 'fn args) is (fn (car args)
  (cadr args) ...).


Theorems Involving Apply$

  Because apply$ is undefined on user-defined function symbols and
  warrant hypotheses specify the tameness requirements and value of
  apply$ on such symbols, you can't prove much about the application
  of particular user-defined symbols unless you provide the
  corresponding warrants as hypotheses.

  To emphasize this point, suppose sq has been introduced with defun$
  as shown above, then the following top-level evaluation is
  possible:

    ACL2 !>(apply$ 'sq '(5))
    25

  You might expect to be able to prove the obvious little theorem

    (thm (equal (apply$ 'sq '(5)) 25))

  However, you would be wrong!  While ACL2's evaluation theory assumes
  all warrants, the proof theory does not.  (If it did we could
  suffer the LOCAL problem mentioned in example theorem [1] above and
  in [introduction-to-apply$].)  Logically, there is no connection
  between the symbol 'SQ and the user-defined function sq.  That
  connection is established by warrant.  All the necessary warrants
  must be explicitly provided as hypotheses by the user.

  The warranted version of the little theorem above is easily proved.

    (thm (implies (warrant sq) (equal (apply$ 'sq '(5)) 25)))

  Here (warrant sq) is just an abbreviation for a call of the 0-ary
  function symbol apply$-warrant-sq which is the name of the warrant
  for sq.  Apply$-warrant-sq is introduced when (defwarrant sq)
  completes successfully.  In particular, the following is a theorem:

      (warrant sq)
    <-->
      (apply$-warrant-sq)
    <-->
      (((badge 'SQ) = '(APPLY$-BADGE 1 1 . T))
       &
       ((apply$ 'SQ args) = (sq (car args))))

  Thus, the warrant for sq specifies the value of (badge 'sq) and of
  (apply$ 'sq ...).

  If you try to prove the unwarranted version of the little theorem
  about 'sq it fails in a forcing round with

    [1]Goal
    (APPLY$-WARRANT-SQ)

  This is a clear indication that you forgot to provide the warrant.

  You might worry that theorems burdened by warrants are vacuously
  valid because it might be impossible to satisfy all the warrant
  hypotheses.  You needn't worry about this.  There is a model of
  apply$ and all of its scions that makes every warrant issued by
  defwarrant valid. The proof of this is sketched in {``Limited
  Second-Order Functionality in a First-Order Setting'' |
  http://www.cs.utexas.edu/users/kaufmann/papers/apply/index.html} by
  Matt Kaufmann and J Strother Moore and fully fleshed out in the
  comment titled Essay on Admitting a Model for Apply$ and the
  Functions that Use It in the ACL2 source file apply-raw.lisp.

  So there are four lessons here:

  Lesson 1: When stating theorems involving apply$ or scions on
  concrete user-defined functions, provide as additional hypotheses
  the warrants for all user-defined functions that apply$ will
  encounter during the proof.  This generally means you should add
  the hypothesis (warrant fn1 fn2 ... fnk) typically listing every
  function symbol that appears inside a quoted constant destined for
  apply$ or ev$ in your conjecture.  In particular, you should
  include every quoted function symbol appearing in a :FN slot of
  apply$ or any scion, including every function symbol appearing in
  the body of any LAMBDA object or lambda$ term or any until, when,
  or body expressions of loop$s.  (Macro expansion in lambda$s and
  loop$s may introduce function symbols not evident in the
  untranslated forms.  See :[translam] and :[trans].)

  Lesson 2: You need not worry that adding warrant hypotheses makes
  your theorems vacuously valid!  There is a model of apply$ and all
  your scions in which all warrants are valid.

  Lesson 3: If a proof involving apply$ or a scion fails in a forcing
  round with a checkpoint whose conclusion is the warrant for some
  function, you should remember Lesson 1 and include the warrant for
  that function symbol in the hypotheses of your conjecture!  That
  is, if you forget to supply a warrant but your conjecture is
  otherwise provable, ACL2's checkpoints will often remind you.  (It
  is possible, in the absence of an explict warrant hypothesis, for a
  proof to fail before the prover detects that only the warrant is
  missing.)

  Lesson 4: If a proof involving apply$ or a scion fails here are some
  things to think about.  The basic question is whether something is
  ``wrong'' with one or more function symbols supposedly handled by
  apply$.  You have to identify which quoted function symbols are not
  being simplified or expanded.  Typically you'll see a checkpoint
  with a term like (apply$ 'fn ...) or (ev$ '(fn ...)  ...) that you
  expect would be expanded into an actual call of fn.  In that case,
  fn is of interest.  Here are some questions you should ask yourself
  about fn.

    * Is fn defined and in :logic mode?  If fn is in :program mode it is
      treated by the prover as an undefined symbol.  You should try
      to convert it :logic mode with [verify-termination].
    * Is fn warranted?  If not, see [defwarrant].  If fn is warranted then
      it is possible fn is not the problem.  Maybe the warrant for fn
      was not provided as a hypothesis?  Normally, missing warrant
      hypotheses are forced, but the proof might have failed for
      other reasons before the warrant for fn was forced.  But you
      should ask whether forcing is disabled; see [force].
    * If you see (apply$ 'fn ...) then perhaps the rewrite rule APPLY$-fn
      is disabled.  That rule is the one that forces the warrant for
      fn and it was proved when fn was warranted.

  These issues are discussed further in the documentation for
  [warrant].

  An unfortunate implication of the need for warrants is highlighted
  during the proofs of measure conjectures while admitting new
  definitions.  Consider

    (defun$ my-cdr (x) (cdr x))

    (defun$ my-len (x)
      (if (endp x)
          0
          (+ 1 (my-len (apply$ 'my-cdr (list x))))))

  The definition of my-len fails!  The reason is that without the
  warrant for my-cdr we cannot prove that the measure decreases in
  the recursion above.  Unfortunately, there is no way to provide a
  warrant in a definition.  At the moment we advise users to avoid
  the use of apply$ --- and functions that use apply$ --- in
  ``termination-critical'' roles.  By that we mean do not use apply$
  if its properties are important to proofs of your measure
  conjectures.  This is easy advice to implement in the case of
  my-len, i.e., replace the recursive call above by (my-len (my-cdr
  x)).  However, in more sophisticated definitions, e.g., where a
  [loop$] is being used in recursive calls and the loop$ calls
  user-defined functions in its body, following this advice means
  replacing that loop$s by a recursive function.  That is unfortunate
  since the whole point of loop$ is to avoid the introduction of such
  functions!  We hope to address this limitation in the future, e.g.,
  by making the definition of my-len above be conditional on the
  warrant for my-cdr.


Guards and Guard Verification

  As noted, apply$ has a guard of (apply$-guard fn args) and is itself
  guard verified.  The guard is weak, basically requiring that fn
  either be a symbol or a LAMBDA object, that args be a true-list,
  and, when fn is a LAMBDA object, the length of the list of formals
  is equal to the length of args.  To verify the guards of a scion
  you must make sure these properties hold of every application of
  anything in a :FN slot.  Mainly you must make sure that every time
  a function object is apply$d, it is applied to a list of the right
  length.

  Note also that [mixed-mode-functions], i.e., :logic mode functions
  that use :program mode functions in slots of [ilk] :FN or :EXPR,
  cannot be guard verified.

  But guards arise in another way in connection with apply$.  How does
  (apply$ fn args) behave when fn has guards?  The short answer is:
  logically speaking, apply$ completely ignores guards.  Guards in
  ACL2 are ``extra-logical.''

  Let's define and warrant a well-guarded version of ``square'',

    (defun$ squ (n) (declare (xargs :guard (natp n))) (* n n))

  Squ is guard verified.  Now let's consider the little conjecture:

    (thm (implies (warrant squ) (equal (apply$ 'SQU (list x)) (* x x))))

  Do we need need to require (natp x)?  We would if the logical
  definition of apply$ checked the guard of fn before interpretting
  it.  But it does not check.  It just behaves as specified above.
  So, regardless of whether the guard is satisfied or not, (apply$
  'squ (list x)) naively expands (under the warrant) to (squ x), from
  which the rest of the proof follows.

  However, now let's do a top-level evaluation of this apply$ term:

    ACL2 !>(apply$ 'SQU (list 'NAN))

    ACL2 Error in TOP-LEVEL:  The guard for the function call
    (SQU N), which is (NATP N), is violated by the arguments
    in the call (SQU 'NAN).

  (Remember that ACL2's evaluation theory effectively assumes all
  warrants.)  What happened?  Apply$ expanded to (SQU 'NAN) and that
  caused the usual guard violation, given the default configuration
  of [set-guard-checking].

  A similar guard violation error is signalled if a guarded LAMBDA
  object is apply$ed to something violating its guard.

  But now consider

    (defun$ strange (x)
      (declare (xargs :guard t))
      (apply$ 'SQU (list x)))

  This succeeds and strange is now a guard verified, warranted
  function, with a guard of T.  This might be surprising since (a)
  the guard of strange tells us nothing about x, (b) SQU is applied
  to x, and (c) we know the guard of SQU requires its argument to be
  a natp.  Guard verification ignores the guards of a quoted function
  symbol being applied by a scion.  This may be particularly
  offensive to one's intuitions when the scion is apply$ itself,
  since the appropriate information is available.  But consider a
  call of an arbitrary user-defined scion, e.g., (my-scion 'SQU x).
  To what arguments will my-scion apply$ SQU?  And how can the
  definition of my-scion even specify what functional objects are
  acceptable in its first argument?  This is a limitation suffered by
  ACL2 that a logic with a suitably expressive type system would not
  suffer.  Our way of coping with it is to ignore the guard here and
  make sure that when apply$ applies the function symbol executes it
  checks the guard of the symbol.

  Guard verification does not ignore guards of a quoted lambda object
  being apply$ed.  Thus, for example, while strange can be guard
  verified,

    (defun$ stranger (x)
      (declare (xargs :guard t))
      (apply$ (lambda$ (e) (SQU e)) (list x)))

  cannot be guard verified, because guard verification tries to verify
  the guards of every lambda object in a :FN slot so that the lambda
  object can be marked as guard verified in the compiled lambda cache
  (see [print-cl-cache]).  But guards of lambda objects must be
  verified independently of the context in which they are used.  To
  be specific, even

    (defun$ stranger (x)
      (declare (xargs :guard (natp x)))
      (apply$ (lambda$ (e) (SQU e)) (list x)))

  cannot be guard verified because the lambda object's guards are
  verified independently of the context.  The lambda object must
  carry its own guard, as in

    (defun$ stranger (x)
      (declare (xargs :guard (natp x)))
      (apply$ (lambda$ (e)
                (declare (xargs :guard (natp e)))
                (SQU e))
              (list x)))

  The last definition of stranger can be guard verified, the lambda
  object is so marked in the cache and compiled, and if that lambda
  object is used in any other context it is recognized as being guard
  verified.  The guard for that lambda is checked when the object is
  apply$ed but if the check approves then the body of the lambda is
  executed as compiled code without further guard checking.

  While apply$ is not evident in a [loop$] statement like

    (loop$ for e in lst collect (SQU e))

  similar treatment is given.  In particular, the loop$ above cannot be
  guard verified but

    (loop$ for e in lst collect :guard (natp e) (SQU e))

  can be and is compiled into a Common Lisp loop.  Recall also from the
  [loop$] documentation that the formal semantics of the above
  statement is essentially

    (collect$ (lambda$ (e)
                (declare (xargs :guard (natp e)))
                (SQU e))
              lst)

  so guard verification of the loop$ also compiles and marks that
  lambda expression as guard verified.

  So now let's return to consideration of

    (defun$ strange (x)
      (declare (xargs :guard t))
      (apply$ 'SQU (list x)))

  which we've seen is guard verified despite the fact that SQU expects
  a natural number and will not necessarily be given one.  What
  happens when we call strange on a non-natural?

    ACL2 !>(strange 'NAN)

    ACL2 Error in TOP-LEVEL:  The guard for the function call (SQU N),
    which is (NATP N), is violated by the arguments in the call (SQU 'NAN).

    ACL2 !>:q

    Exiting the ACL2 read-eval-print loop.  To re-enter, execute (LP).
    ? (strange 'nan)

    ACL2 Error in ACL2-INTERFACE:  The guard for the function call (SQU N),
    which is (NATP N), is violated by the arguments in the call (SQU 'NAN).

  We see that we can provoke a guard violation with strange even though
  it is guard verified with a guard of T.  Furthermore, we get the
  error both in the ACL2 read-eval-print loop and in the raw Lisp
  under ACL2.

  This might at first violate your understanding of the link between
  ACL2 and Common Lisp.  Naively, a guard verified ACL2 function with
  a guard of T never causes a runtime error in Common Lisp.  But
  that's not quite what the guarantee is.  Such a function will never
  cause a hard Lisp error, other than possibly resource errors like
  running out of memory or stack space.  Neither of the errors above
  were signalled by Common Lisp.  They were ``soft'' ACL2 errors.  In
  particular, when apply$ calls squ above, even when running in raw
  Lisp, it actually calls the executable counterpart of squ, which
  checks guards at runtime and executes properly under the ACL2
  axioms.

    ACL2 !>(set-guard-checking :none)

    Turning off guard checking entirely.

    ACL2 >(strange 'nan)
    0

  The last evaluation can be explained by the fact that ACL2
  multiplication defaults non-numbers to 0.

  We discuss the evaluation of ground apply$ terms in the evaluation
  theory further below.

  When the guard conjectures of a function are proved all necessary
  warrants are assumed.  This is unlike what happens when the measure
  conjectures are proved.  The reason we can assume warrants during
  guard verification is that guard verification is relevant in the
  evaluation theory, where attachments are allowed and all warrants
  have true attachments.


Top-Level Evaluation of Apply$

  As noted, ACL2's evaluation theory implicitly assumes all warrants
  produced by [defwarrant].  See [guarantees-of-the-top-level-loop].
  Since top-level evaluation in ACL2 is conducted in the evaluation
  theory, ground calls of apply$ --- whether literally in top-level
  input to the ACL2 read-eval-print loop or hidden inside scions
  called from the top-level --- can be evaluated on quoted warranted
  function symbols and [lambda$] expressions --- provided the
  [tame]ness restrictions are met.  This is in contrast to
  opportunities for evaluation of ground apply$ expressions arising
  in proofs, where warrant hypotheses must be explicit.

  In this section we focus on calls of apply$ arising in the evaluation
  theory.  We start with a discussion of the use of apply$ with
  warranted :logic mode functions.  We then describe how apply$
  handles badged :program mode functions.  Note that a mere badge is
  not sufficient for evaluation when using apply$ on a :logic mode
  function that is not warranted; see [defbadge] and
  [guarantees-of-the-top-level-loop] for discussion of this case.  In
  short: evaluation involving :logic mode functions is expected to
  respect the evaluation theory, and while defwarrant extends the
  evaluation theory appropriately, defbadge does not.

  Evaluation of apply$ terms in the evaluation theory respects guards
  on quoted function symbols and [lambda$] expressions (which is to
  say, on the quoted well-formed LAMBDA objects that [lambda$]
  produces).  So consider a call of apply$ on fn and args in the
  evaluation theory, where fn is a warranted function symbol or a
  well-formed (and thus tame) LAMBDA object.  Here's what happens.
  Except where noted, the description below applies both to warranted
  :logic and badged :program mode functions.

  Apply$ determines whether fn's tameness restrictions are met by args.
  Tameness is a syntactic property and so can be checked.  If the
  function's tameness restrictions are not met, an error is caused.

  If the tameness restrictions are met, apply$ determines whether fn
  has been guard verified.  In the case of function symbols this is a
  simple lookup on the property list of fn.  (Of course, this check
  fails for :program mode functions.)  In the case of LAMBDA objects
  it is a cache query (see [print-cl-cache]) and if the query reveals
  that we have not yet tried to verify the guards of this LAMBDA
  object, apply$ uses tau reasoning alone (see
  [introduction-to-the-tau-system]) to try to verify the guard
  conjectures.

  Note:An important distinction between the runtime handling of
  function symbols versus LAMBDA objects by apply$ is that function
  symbols can only be guard verified by prior events, e.g., the
  introductory [defun] or a subsequent verify-guards, but apply$
  tries to verify the guards of LAMBDA objects on the fly!  The
  reason for this distinction is that we anticipate that many LAMBDA
  objects will not be associated with any event.  For example, an
  ACL2 macro might generate a call of a scion on a never-before-seen
  LAMBDA object and that LAMBDA object may only be seen by the
  top-level evaluator.  We discuss this further in [verify-guards]

  If fn is guard verified, apply$ next checks whether fn's guard holds
  of the actuals in args.  This is done by evaluation of the compiled
  code for the guard on args.

  If the guard check of args succeeds, a compiled version of fn is
  applied to args.  If the check fails, a guard violation is
  signalled or else the application of fn to args is interpreted
  under the definitional axioms of apply$ and ev$, depending on how
  [set-guard-checking] has been configured.

  Finally, if fn is not guard verified, the application of fn to args
  is interpreted under the definitional axioms of apply$ and ev$.

  We discuss the cache that supports LAMBDA application in
  [print-cl-cache].  See also the discussion of guard verification in
  [lambda$].  It should be noted that a LAMBDA object can also be
  guard verified using the [verify-guards] event.  This brings the
  full power of the prover to bear on the guard verification of the
  LAMBDA object, instead of relying just on the tau system.

  Users are accustomed to executing :program mode functions at the
  top-level of the ACL2 read-eval-print loop.  Indeed, the prover
  itself and the various event commands are mostly written in
  :program mode.  Furthermore, the evaluation theory is described as
  an extension of the proof theory, i.e., as an axiomatic theory.
  And yet no part of that axiomatization explains how :program mode
  functions are run!  It simply isn't important.  The implementation
  supports it and no questions are asked.  We, the implementors of
  ACL2, view top-level evaluation of :program mode functions as a
  convenience not affecting the consistency of the proof theory.  No
  inconsistency results from starting a non-terminating computation
  because you can never inspect the result, whereas if you added the
  corresponding definition as an axiom you might be able to prove
  something contradictory.  So we regard the seamless execution of
  :program mode functions as a convenience to the user who might use
  them to inspect the ACL2 logical world, gather data, experiment
  with constrained formal models by attaching executable code to
  unspecified functions, prototype something to be formalized, etc.
  In that spirit, we have arranged for apply$ to handle :program mode
  functions provided they have badges.  Badges are critical because
  it means that execution of the functions won't ``go outside the
  sandbox.'' However, apply$ runs :program mode functions in
  [safe-mode] to ensure the functional substitutivity of apply$:
  identical calls must always yield identical results.

  It may seem counterintuitive that a top-level apply$ of a :logic mode
  function cannot be executed unless defwarrant has succeeded but a
  top-level apply$ of a :program mode function can be executed.  As
  noted earlier, the reason is simple: execution of :logic mode
  functions is justified by the axioms of the evaluation theory while
  no such assurances are offered for :program mode functions.


Logical Definitions

  In the following definitions, apply$-userfn is an undefined function
  that is constrained by warrants to describe the tameness
  requirement and behavior of apply$ on specific function symbols.
  The functions untame-apply$ and untame-ev$ are simply undefined
  functions for giving unspecified values when untame objects are
  being used.

  Function: <apply$>

    (defun apply$ (fn args)
           (declare (xargs :guard (apply$-guard fn args)))
           (cond ((consp fn) (apply$-lambda fn args))
                 ((apply$-primp fn)
                  (apply$-prim fn args))
                 ((eq fn 'badge) (badge (car args)))
                 ((eq fn 'tamep) (tamep (car args)))
                 ((eq fn 'tamep-functionp)
                  (tamep-functionp (car args)))
                 ((eq fn 'suitably-tamep-listp)
                  (ec-call (suitably-tamep-listp (car args)
                                                 (cadr args)
                                                 (caddr args))))
                 ((eq fn 'apply$)
                  (if (tamep-functionp (car args))
                      (ec-call (apply$ (car args) (cadr args)))
                      (untame-apply$ fn args)))
                 ((eq fn 'ev$)
                  (if (tamep (car args))
                      (ev$ (car args) (cadr args))
                      (untame-apply$ fn args)))
                 (t (apply$-userfn fn args))))

  Function: <apply$-lambda>

    (defun apply$-lambda (fn args)
           (declare (xargs :guard (apply$-lambda-guard fn args)))
           (apply$-lambda-logical fn args))

  Macro: <apply$-lambda-logical>

    (defmacro
     apply$-lambda-logical (fn args)
     (declare (xargs :guard (symbolp fn)))
     (cons
        'ev$
        (cons (cons 'lambda-object-body
                    (cons fn 'nil))
              (cons (cons 'ec-call
                          (cons (cons 'pairlis$
                                      (cons (cons 'lambda-object-formals
                                                  (cons fn 'nil))
                                            (cons args 'nil)))
                                'nil))
                    'nil))))

  Function: <ev$>

    (defun ev$ (x a)
           (declare (xargs :guard t))
           (cond ((not (tamep x)) (untame-ev$ x a))
                 ((variablep x)
                  (ec-call (cdr (ec-call (assoc-equal x a)))))
                 ((fquotep x) (cadr x))
                 ((eq (car x) 'if)
                  (if (ev$ (cadr x) a)
                      (ev$ (caddr x) a)
                      (ev$ (cadddr x) a)))
                 ((eq (car x) 'apply$)
                  (apply$ 'apply$
                          (list (cadr (cadr x))
                                (ev$ (caddr x) a))))
                 ((eq (car x) 'ev$)
                  (apply$ 'ev$
                          (list (cadr (cadr x))
                                (ev$ (caddr x) a))))
                 (t (apply$ (car x) (ev$-list (cdr x) a)))))

  Function: <ev$-list>

    (defun ev$-list (x a)
           (declare (xargs :guard t))
           (cond ((atom x) nil)
                 (t (cons (ev$ (car x) a)
                          (ev$-list (cdr x) a)))))

  Function: <apply$-guard>

    (defun apply$-guard (fn args)
           (declare (xargs :guard t))
           (if (atom fn)
               (true-listp args)
               (apply$-lambda-guard fn args)))

  Function: <apply$-lambda-guard>

    (defun apply$-lambda-guard (fn args)
           (declare (xargs :guard t))
           (and (consp fn)
                (consp (cdr fn))
                (true-listp args)
                (equal (len (cadr fn)) (length args))))


Subtopics

  [Apply$-guard]
      The guard on apply$

  [Apply$-lambda]
      Used by apply$ on LAMBDA objects

  [Apply$-lambda-guard]
      The guard on apply$-lambda

  [Apply$-userfn]
      Undefined function used by apply$ on non-primitives

  [Badge]
      Syntactic requirements on a function symbol to be used by apply$

  [Badge-userfn]
      Undefined function used by badge on non-primitives

  [Defbadge]
      Issue a badge for a function so [apply$] can evaluate with it

  [Defun$]
      Define a function symbol and generate a warrant

  [Defwarrant]
      Issue a warrant for a function so [apply$] can use it in proofs

  [Ev$]
      Evaluate a tame expression using apply$

  [Fn-equal]
      Equivalence relation on tame functions

  [Gratuitous-lambda-object-restrictions]
      Enforcement of logically unnecessary restrictions on :FN slots

  [Ilk]
      Indicator of how an argument is used

  [Introduction-to-apply$]
      Background knowledge on how to use [apply$], [defwarrant], etc.

  [L<]
      Ordering on naturals or lists of naturals

  [Lambda]
      Lambda expressions, LAMBDA objects, and lambda$ expressions

  [Lambda$]
      Lambda object constructor for use with apply$

  [Mixed-mode-functions]
      :[logic] mode functions can [apply$] :[program] mode functions

  [Print-cl-cache]
      Information about the cache supporting apply$

  [Scion]
      A function ancestrally dependent on apply$

  [Tame]
      Definitions of the various notions of tameness

  [Translam]
      Print the translation of a lambda$ expression

  [Warrant]
      Giving [apply$] permission to handle a user-defined function in
      proofs

  [Well-formed-lambda-objectp]
      Predicate for recognizing well-formed LAMBDA objects")
 (APPLY$-GUARD
  (APPLY$)
  "The guard on apply$

  The guard on (apply$ fn lst) is (apply$-guard fn lst) which is
  extraordinarily weak.

  Function: <apply$-guard>

    (defun apply$-guard (fn args)
           (declare (xargs :guard t))
           (if (atom fn)
               (true-listp args)
               (apply$-lambda-guard fn args)))

  where

  Function: <apply$-lambda-guard>

    (defun apply$-lambda-guard (fn args)
           (declare (xargs :guard t))
           (and (consp fn)
                (consp (cdr fn))
                (true-listp args)
                (equal (len (cadr fn)) (length args))))

  This guard is just strong enough to allow the definitions of the
  functions in the apply$ clique to be guard verified.  It does not
  guarantee that fn is tame or well-formed or that args satisfy the
  guard of fn.  The last condition is in fact impossible to state
  given the untyped nature of ACL2.  Thus, (apply$ fn args) has to
  check tameness, well-formedness, guard verified, and that fn's
  guard is satisfied by args when the apply$ is executed in the
  evaluation theory.

  The issue of guards and guard verification of definitions involving
  apply$ is further discussed in [apply$] and in [verify-guards].")
 (APPLY$-LAMBDA
  (APPLY$)
  "Used by apply$ on LAMBDA objects

  When apply$ is given a consp object as its first argument it treats
  it as a LAMBDA expression and calls this function to apply it.
  This function evaluates the body of the object with ev$ under an
  alist binding the formals of the object to the actuals.  See
  [apply$] for details.")
 (APPLY$-LAMBDA-GUARD
  (APPLY$)
  "The guard on apply$-lambda

  The guard on (apply$-lambda fn lst) is (apply$-lambda-guard fn lst)
  which is extraordinarily weak.

  Function: <apply$-lambda-guard>

    (defun apply$-lambda-guard (fn args)
           (declare (xargs :guard t))
           (and (consp fn)
                (consp (cdr fn))
                (true-listp args)
                (equal (len (cadr fn)) (length args))))

  This guard is just strong enough to allow the definitions of the
  functions in the apply$ clique to be guard verified.  It does not
  guarantee that fn is tame or well-formed or that args satisfy the
  guard of fn.  The last condition is in fact impossible to state
  given the untyped nature of ACL2.  Thus, (apply$ fn args) has to
  check tameness, well-formedness, guard verified and that fn's guard
  is satisfied by args when the apply$ is executed in the evaluation
  theory.

  The issue of guards and guard verification of definitions involving
  apply$ is further discussed in [apply$] and in [verify-guards].")
 (APPLY$-USERFN
  (APPLY$)
  "Undefined function used by apply$ on non-primitives

  When apply$ is given a non-primitive function symbol it calls this
  function to determine the results of applying that symbol to the
  given arguments.  But this function is undefined.  In the proof
  theory, its value on a given function symbol fn is specified, if at
  all, by the [warrant] for fn which must be available as a
  hypothesis in the formula being proved.  In the evaluation theory,
  apply$-userfn has an attachment that makes it behave as though all
  warrants are assumed.  See [apply$] for details.")
 (APROPOS (POINTERS)
          "See [finding-documentation].")
 (ARCHITECTURE-OF-THE-PROVER
  (INTRODUCTION-TO-THE-THEOREM-PROVER)
  "A simple overview of how the prover works

  Six built-in proof techniques are used by ACL2 to decompose the goal
  formula into subgoals.

    * simplification --- decision procedures and rewriting with previously
      proved rules, but actually including a host of other techniques
      under your control.  Simplification is the only proof technique
      that can reduce a formula to 0 subgoals (i.e., prove it) rather
      than just transform it to other formulas.  The predominant
      activity in most proofs is simplification.  There are many ways
      you can affect what the simplifier does to your formulas.  Good
      users spend most of their time thinking about how to control
      the simplifier.
    * destructor elimination --- getting rid of ``destructor terms'' like
      (CAR X) and (CDR X) by replacing a variable, e.g., X, by a
      ``constructor'' term, e.g., (CONS A B).  But you can tell ACL2
      about new destructor/constructor combinations.
    * fertilization --- using an equivalence hypothesis by substituting one
      side for the other in the goal.  When under induction, ACL2 may
      decide to restrict the substitution as follows, using its
      so-called cross-fertilization heuristic: substitute only into
      one side of the conclusion, thus using an inductive hypothesis
      in preparation for possible generalization in advance of
      another induction.  Note that cross-fertilization is used only
      when generalization is enabled: with the hint :do-not
      '(generalize), only full fertilization is applied.
    * generalization --- replacing a term by a new variable and restricting
      the new variable to have some of the properties of the term.
      You can control the restrictions imposed on the new variable.
      This is a heuristic that prepares the goal for another
      induction.
    * elimination of irrelevance --- throwing away unnecessary hypotheses.
      This is a heuristic that prepares the goal for another
      induction.
    * induction --- selecting an induction scheme to prove a formula.
      Inductions are ``suggested'' by the recursive functions
      appearing in the formula.  But you can control what inductions
      are suggested by terms.

  But you can add additional techniques, called clause processors.

  The various techniques are tried in turn, with simplification first
  and induction last.  Each technique reports one of three outcomes:
  it found nothing to change (i.e., the technique doesn't apply to
  that subgoal), it decided to abort the proof attempt (typically
  because there is reason to believe the proof is failing), or it
  decomposed the goal into k subgoals.

  The last outcome has a special case: if k is 0 then the technique
  proved the goal.  Whenever k is non-0, the process starts over
  again with simplification on each of the k subgoals.  However, it
  saves up all the subgoals for which induction is the only proof
  technique left to try. That way you see how it performs on every
  base case and induction step of one induction before it launches
  into another induction.

  It runs until you or one of the proof techniques aborts the proof
  attempt or until all subgoals have been proved.

  Note that if simplification produces a subgoal, that subgoal is
  re-simplified.  This process continues until the subgoal cannot be
  simplified further.  Only then is the next proof technique is
  tried.  Such subgoals are said to be stable under simplification.

  While this is happening, the prover prints an English narrative
  describing the process.  Basically, after each goal is printed, the
  system prints an English paragraph that names the next applicable
  proof technique, gives a brief description of what that technique
  does to the subgoal, and says how many new subgoals are produced.
  Then each subgoal is dealt with in turn.

  If the proof is successful, you could read this log as a proof of the
  conjecture.  But output from successful proofs is generally never
  read because it is not important to The Method described in
  [introduction-to-the-theorem-prover].

  The output of an unsuccessful proof attempt concludes with some key
  checkpoints which usually bear looking at.

  For more information about how ACL2 orchestrates its proof
  techniques, see [hints-and-the-waterfall].")
 (AREF1
  (ARRAYS ACL2-BUILT-INS)
  "Access the elements of a 1-dimensional array

    Example Form:
    (aref1 'delta1 a (+ i k))

    General Form:
    (aref1 name alist index)

  where name is a symbol, alist is a 1-dimensional array and index is a
  legal index into alist.  This function returns the value associated
  with index in alist, or else the default value of the array.  See
  [arrays] for details.

  This function executes in virtually constant time if alist is in fact
  the ``semantic value'' associated with name (see [arrays]).  When
  it is not, aref1 must do a linear search through alist.  In that
  case the correct answer is returned but a slow array comment is
  printed to the comment window.  See [slow-array-warning].

  Function: <aref1>

    (defun
         aref1 (name l n)
         (declare (xargs :guard (and (array1p name l)
                                     (integerp n)
                                     (>= n 0)
                                     (< n (car (dimensions name l))))))
         (let ((x (and (not (eq n :header)) (assoc n l))))
              (cond ((null x) (default name l))
                    (t (cdr x)))))")
 (AREF2
  (ARRAYS ACL2-BUILT-INS)
  "Access the elements of a 2-dimensional array

    Example Form:
    (aref2 'delta1 a i j)

    General Form:
    (aref2 name alist i j)

  where name is a symbol, alist is a 2-dimensional array and i and j
  are legal indices into alist.  This function returns the value
  associated with (i . j) in alist, or else the default value of the
  array.  See [arrays] for details.

  This function executes in virtually constant time if alist is in fact
  the ``semantic value'' associated with name (see [arrays]).  When
  it is not, aref2 must do a linear search through alist.  In that
  case the correct answer is returned but a slow array comment is
  printed to the comment window.  See [slow-array-warning].

  Function: <aref2>

    (defun
         aref2 (name l i j)
         (declare (xargs :guard (and (array2p name l)
                                     (integerp i)
                                     (>= i 0)
                                     (< i (car (dimensions name l)))
                                     (integerp j)
                                     (>= j 0)
                                     (< j (cadr (dimensions name l))))))
         (let ((x (assoc2 i j l)))
              (cond ((null x) (default name l))
                    (t (cdr x)))))")
 (ARGLISTP (POINTERS)
           "See [system-utilities].")
 (ARGS
  (DOCUMENTATION)
  "args, [guard], type, [constraint], etc., of a function symbol

    Example:
    :args assoc-eq

  Args takes one argument, a symbol which must be the name of a
  function or macro, and prints out some information about it
  including the formal parameters, the [guard] expression, the output
  [signature], the deduced type, the [constraint] (if any), and its
  [badge] and [warrant], if any.")
 (ARITIES-OKP
  (ACL2-BUILT-INS)
  "check the arities of given function symbols

    Example:
    (arities-okp '((IF . 3) (CAR . 1) (CONS . 2)) (w state))

    General Form:
    (arities-okp alist w)

  where alist is a [symbol-alistp] and w is an ACL2 logical [world].
  The alist is presumed to pair :[logic]-mode function symbols with
  arities.  The result is t or nil according to whether each symbol
  in the alist is a :logic-mode function symbol with the associated
  arity as its [arity] in w.  See [well-formedness-guarantee].

  Function: <arities-okp>

    (defun arities-okp (user-table w)
           (declare (xargs :guard (and (symbol-alistp user-table)
                                       (plist-worldp-with-formals w))))
           (cond ((endp user-table) t)
                 (t (and (equal (arity (car (car user-table)) w)
                                (cdr (car user-table)))
                         (logicp (car (car user-table)) w)
                         (arities-okp (cdr user-table) w)))))")
 (ARITY
  (ACL2-BUILT-INS)
  "number of arguments of a function symbol

    Examples:
    (arity 'IF (w state))
    (arity '(LAMBDA (X) (CONS X X)) (w state))

    General Form:
    (arity fn w)

  where fn is a function symbol or a lambda expression and w is an ACL2
  logical [world].  The result is the number of arguments the
  function or lambda expression takes, or nil if the function symbol
  is not defined in w.

See [arity+] for a variant of arity with a stronger [guard].")
 (ARRAY (POINTERS) "See [arrays].")
 (ARRAY1P
  (ARRAYS ACL2-BUILT-INS)
  "Recognize a 1-dimensional array

    Example Form:
    (array1p 'delta1 a)

    General Form:
    (array1p name alist)

  where name and alist are arbitrary objects.  This function returns t
  if alist is a 1-dimensional ACL2 array.  Otherwise it returns nil.
  The function operates in constant time if alist is the semantic
  value of name.  See [arrays].

  Function: <array1p>

    (defun
     array1p (name l)
     (declare (xargs :guard t))
     (and
      (symbolp name)
      (alistp l)
      (let
       ((header-keyword-list (cdr (assoc-eq :header l))))
       (and
        (keyword-value-listp header-keyword-list)
        (let
         ((dimensions
               (cadr (assoc-keyword :dimensions header-keyword-list)))
          (maximum-length
            (cadr (assoc-keyword :maximum-length header-keyword-list))))
         (and (true-listp dimensions)
              (equal (length dimensions) 1)
              (integerp (car dimensions))
              (integerp maximum-length)
              (< 0 (car dimensions))
              (< (car dimensions) maximum-length)
              (<= maximum-length
                  *maximum-positive-32-bit-integer*)
              (bounded-integer-alistp l (car dimensions))))))))")
 (ARRAY2P
  (ARRAYS ACL2-BUILT-INS)
  "Recognize a 2-dimensional array

    Example Form:
    (array2p 'delta1 a)

    General Form:
    (array2p name alist)

  where name and alist are arbitrary objects.  This function returns t
  if alist is a 2-dimensional ACL2 array.  Otherwise it returns nil.
  The function operates in constant time if alist is the semantic
  value of name.  See [arrays].

  Function: <array2p>

    (defun
     array2p (name l)
     (declare (xargs :guard t))
     (and
      (symbolp name)
      (alistp l)
      (let
       ((header-keyword-list (cdr (assoc-eq :header l))))
       (and
        (keyword-value-listp header-keyword-list)
        (let
         ((dimensions
               (cadr (assoc-keyword :dimensions header-keyword-list)))
          (maximum-length
            (cadr (assoc-keyword :maximum-length header-keyword-list))))
         (and (true-listp dimensions)
              (equal (length dimensions) 2)
              (let ((d1 (car dimensions))
                    (d2 (cadr dimensions)))
                   (and (integerp d1)
                        (integerp d2)
                        (integerp maximum-length)
                        (< 0 d1)
                        (< 0 d2)
                        (< (* d1 d2) maximum-length)
                        (<= maximum-length
                            *maximum-positive-32-bit-integer*)
                        (bounded-integer-alistp2 l d1 d2)))))))))")
 (ARRAYS
  (PROGRAMMING)
  "ACL2 arrays and operations on them

  Below we begin a detailed presentation of ACL2 arrays.  ACL2's
  single-threaded objects (see [stobj]) provide a similar
  functionality that is generally more efficient when there are
  updates (writes), but is also more restrictive.

  See [arrays-example] for a brief introduction illustrating the use of
  ACL2 arrays.

  ACL2 provides relatively efficient 1- and 2-dimensional arrays.
  Arrays are awkward to provide efficiently in an applicative
  language because the programmer rightly expects to be able to
  ``modify'' an array object with the effect of changing the behavior
  of the element accessing function on that object.  This, of course,
  does not make any sense in an applicative setting.  The element
  accessing function is, after all, a function, and its behavior on a
  given object is immutable.  To ``modify'' an array object in an
  applicative setting we must actually produce a new array object.
  Arranging for this to be done efficiently is a challenge to the
  implementors of the language.  In addition, the programmer
  accustomed to the von Neumann view of arrays must learn how to use
  immutable applicative arrays efficiently.

  In this note we explain 1-dimensional arrays.  In particular, we
  explain briefly how to create, access, and ``modify'' them, how
  they are implemented, and how to program with them.  2-dimensional
  arrays are dealt with by analogy.


The Logical Description of ACL2 Arrays

  An ACL2 1-dimensional array is an object that associates arbitrary
  objects with certain integers, called ``indices.'' Every array has
  a dimension, dim, which is a positive integer.  The indices of an
  array are the consecutive integers from 0 through dim-1.  To obtain
  the object associated with the index i in an array a, one uses
  (aref1 name a i).  Name is a symbol that is irrelevant to the
  semantics of [aref1] but affects the speed with which it computes.
  We will talk more about array ``names'' later.  To produce a new
  array object that is like a but which associates val with index i,
  one uses (aset1 name a i val).

  An ACL2 1-dimensional array is actually an alist.  There is no
  special ACL2 function for creating arrays; they are generally built
  with the standard list processing functions [list] and [cons].
  However, there is a special ACL2 function, called [compress1], for
  speeding up access to the elements of such an alist.  We discuss
  [compress1] later.

  One element of the alist must be the ``header'' of the array.  The
  [header] of a 1-dimensional array with dimension dim is of the
  form:

    (:HEADER :DIMENSIONS (dim)
             :MAXIMUM-LENGTH max
             :DEFAULT obj ; optional
             :NAME name   ; optional
             :ORDER order ; optional values are < (the default), >, or :none/nil
             ).

  Obj may be any object and is called the ``default value'' of the
  array.  [Max] must be an integer greater than dim.  Name must be a
  symbol.  The :[default] and :name entries are optional; if
  :[default] is omitted, the default value is nil.  The function
  [header], when given a name and a 1- or 2-dimensional array,
  returns the [header] of the array.  The functions [dimensions],
  [maximum-length], and [default] are similar and return the
  corresponding fields of the [header] of the array.  The role of the
  :[dimensions] field is obvious: it specifies the legal indices into
  the array.  The roles played by the :[maximum-length] and
  :[default] fields are described below.

  Aside from the [header], the other elements of the alist must each be
  of the form (i . val), where i is an integer and 0 <= i < dim, and
  val is an arbitrary object.

  The :order field of the header is ignored for 2-dimensional arrays.
  For 1-dimensional arrays, it specifies the order of keys (i, above)
  when the array is compressed as with [compress1], as described
  below.  An :order of :none or nil specifies no reordering of the
  alist by [compress1], and an order of > specifies reordering by
  [compress1] so that keys are in descending order.  Otherwise, the
  alist is reordered by [compress1] so that keys are in ascending
  order.

  (Aref1 name a i) is [guard]ed so that name must be a symbol, a must
  be an array and i must be an index into a.  The value of (aref1
  name a i) is either (cdr (assoc i a)) or else is the default value
  of a, depending on whether there is a pair in a whose [car] is i.
  Note that name is irrelevant to the value of an [aref1] expression.
  You might :pe aref1 to see how simple the definition is.

  (Aset1 name a i val) is [guard]ed analogously to the [aref1]
  expression.  The value of the [aset1] expression is essentially
  (cons (cons i val) a).  Again, name is irrelevant.  Note (aset1
  name a i val) is an array, a', with the property that (aref1 name
  a' i) is val and, except for index i, all other indices into a'
  produce the same value as in a.  Note also that if a is viewed as
  an alist (which it is) the pair ``binding'' i to its old value is
  in a' but ``covered up'' by the new pair.  Thus, the length of an
  array grows by one when [aset1] is done.

  Because [aset1] covers old values with new ones, an array produced by
  a sequence of [aset1] calls may have many irrelevant pairs in it.
  The function [compress1] can remove these irrelevant pairs.  Thus,
  (compress1 name a) returns an array that is equivalent (vis-a-vis
  [aref1]) to a but which may be shorter.  For technical reasons, the
  alist returned by [compress1] may also list the pairs in a
  different order than listed in a.

  To prevent arrays from growing excessively long due to repeated
  [aset1] operations, [aset1] essentially calls [compress1] on the
  new alist whenever the length of the new alist exceeds the
  :[maximum-length] entry, [max], in the [header] of the array.  See
  the definition of [aset1] (for example by using :[pe]).  This is
  primarily just a mechanism for freeing up [cons] space consumed
  while doing [aset1] operations.  Note however that this [compress1]
  call is replaced by a hard error if the header specifies an :order
  of :none or nil.

  This completes the logical description of 1-dimensional arrays.
  2-dimensional arrays are analogous.  The :[dimensions] entry of the
  [header] of a 2-dimensional array should be (dim1 dim2).  A pair of
  indices, i and j, is legal iff 0 <= i < dim1 and 0 <= j < dim2.
  The :[maximum-length] must be greater than dim1*dim2.  [Aref2],
  [aset2], and [compress2] are like their counterparts but take an
  additional index argument.  Finally, the pairs in a 2-dimensional
  array are of the form ((i . j) . val).


The Implementation of ACL2 Arrays

  Very informally speaking, the function [compress1] ``creates'' an
  ACL2 array that provides fast access, while the function [aref1]
  ``maintains'' fast access.  We now describe this informal idea more
  carefully.

  [Aref1] is essentially [assoc].  If [aref1] were implemented naively
  the time taken to access an array element would be linear in the
  dimension of the array and the number of ``assignments'' to it (the
  number of [aset1] calls done to create the array from the initial
  alist).  This is intolerable; arrays are ``supposed'' to provide
  constant-time access and change.

  The apparently irrelevant names associated with ACL2 arrays allow us
  to provide constant-time access and change when arrays are used in
  ``conventional'' ways.  The implementation of arrays makes it clear
  what we mean by ``conventional.''

  Recall that array names are symbols.  Behind the scenes, ACL2
  associates two objects with each ACL2 array name.  The first object
  is called the ``semantic value'' of the name and is an alist.  The
  second object is called the ``raw lisp array'' and is a Common Lisp
  array.

  When (compress1 name alist) builds a new alist, a', it sets the
  semantic value of name to that new alist.  Furthermore, it writes
  into a Common Lisp array all of the index/value pairs of a',
  initializing unassigned indices with the default value.  In general
  this is a new array, which becomes the raw lisp array of name.
  However, if a raw lisp array is already associated with name and is
  at least as long as the dimension specified in the [header], then
  that array is reused and all indices out of range are ignored.
  (Such reuse can be avoided; see [flush-compress] for how to remove
  the existing association of a raw lisp array with a name.)  Either
  way, [compress1] then returns a', the semantic value, as its
  result, as required by the definition of [compress1].

  When (aref1 name a i) is invoked, [aref1] first determines whether
  the semantic value of name is a (i.e., is [eq] to the alist a).  If
  so, [aref1] can determine the ith element of a by invoking Common
  Lisp's aref function on the raw lisp array associated with name.
  Note that no linear search of the alist a is required; the
  operation is done in constant time and involves retrieval of two
  global variables, an [eq] test and jump, and a raw lisp array
  access.  In fact, an ACL2 array access of this sort is about 5
  times slower than a C array access.  On the other hand, if name has
  no semantic value or if it is different from a, then [aref1]
  determines the answer by linear search of a as suggested by the
  assoc-like definition of [aref1].  Thus, [aref1] always returns the
  axiomatically specified result.  It returns in constant time if the
  array being accessed is the current semantic value of the name
  used.  The ramifications of this are discussed after we deal with
  [aset1].

  When (aset1 name a i val) is invoked, [aset1] does two [cons]es to
  create the new array.  Call that array a'.  It will be returned as
  the answer.  (In this discussion we ignore the case in which
  [aset1] does a [compress1].)  However, before returning, [aset1]
  determines if name's semantic value is a.  If so, it makes the new
  semantic value of name be a' and it smashes the raw lisp array of
  name with val at index i, before returning a' as the result.  Thus,
  after doing an [aset1] and obtaining a new semantic value a', all
  [aref1]s on that new array will be fast.  Any [aref1]s on the old
  semantic value, a, will be slow.

  To understand the performance implications of this design, consider
  the chronological sequence in which ACL2 (Common Lisp) evaluates
  expressions: basically inner-most first, left-to-right,
  call-by-value.  An array use, such as (aref1 name a i), is ``fast''
  (constant-time) if the alist supplied, a, is the value returned by
  the most recently executed [compress1] or [aset1] on the name
  supplied.  In the functional expression of ``conventional'' array
  processing, all uses of an array are fast.

  The :name field of the [header] of an array is completely irrelevant.
  Our convention is to store in that field the symbol we mean to use
  as the name of the raw lisp array.  But no ACL2 function inspects
  :name and its primary value is that it allows the user, by
  inspecting the semantic value of the array --- the alist --- to
  recall the name of the raw array that probably holds that value.
  We say ``probably'' since there is no enforcement that the alist
  was compressed under the name in the [header] or that all asets
  used that name.  Such enforcement would be inefficient.


Some Programming Examples

  In the following examples we will use ACL2 ``global variables'' to
  hold several arrays.  See [@], and see [assign].

  Let the [state] global variable a be the 1-dimensional compressed
  array of dimension 5 constructed below.

    ACL2 !>(assign a (compress1 'demo
                                '((:header :dimensions (5)
                                           :maximum-length 15
                                           :default uninitialized
                                           :name demo)
                                  (0 . zero))))

  Then (aref1 'demo (@ a) 0) is zero and (aref1 'demo (@ a) 1) is
  uninitialized.

  Now execute

    ACL2 !>(assign b (aset1 'demo (@ a) 1 'one))

  Then (aref1 'demo (@ b) 0) is zero and (aref1 'demo (@ b) 1) is one.

  All of the [aref1]s done so far have been ``fast.''

  Note that we now have two array objects, one in the global variable a
  and one in the global variable b.  B was obtained by assigning to
  a.  That assignment does not affect the alist a because this is an
  applicative language.  Thus, (aref1 'demo (@ a) 1) must still be
  uninitialized.  And if you execute that expression in ACL2 you will
  see that indeed it is.  However, a rather ugly comment is printed,
  namely that this array access is ``slow.'' The reason it is slow is
  that the raw lisp array associated with the name demo is the array
  we are calling b.  To access the elements of a, [aref1] must now do
  a linear search.  Any reference to a as an array is now
  ``unconventional;'' in a conventional language like Ada or Common
  Lisp it would simply be impossible to refer to the value of the
  array before the assignment that produced our b.

  Now let us define a function that counts how many times a given
  object, x, occurs in an array.  For simplicity, we will pass in the
  name and highest index of the array:

    ACL2 !>(defun cnt (name a i x)
             (declare (xargs :guard
                             (and (array1p name a)
                                  (integerp i)
                                  (>= i -1)
                                  (< i (car (dimensions name a))))
                             :mode :logic
                             :measure (nfix (+ 1 i))))
             (cond ((zp (1+ i)) 0) ; return 0 if i is at most -1
                   ((equal x (aref1 name a i))
                    (1+ (cnt name a (1- i) x)))
                   (t (cnt name a (1- i) x))))

  To determine how many times zero appears in (@ b) we can execute:

    ACL2 !>(cnt 'demo (@ b) 4 'zero)

  The answer is 1.  How many times does uninitialized appear in (@ b)?

    ACL2 !>(cnt 'demo (@ b) 4 'uninitialized)

  The answer is 3, because positions 2, 3 and 4 of the array contain
  that default value.

  Now imagine that we want to assign 'two to index 2 and then count how
  many times the 2nd element of the array occurs in the array.  This
  specification is actually ambiguous.  In assigning to b we produce
  a new array, which we might call c.  Do we mean to count the
  occurrences in c of the 2nd element of b or the 2nd element of c?
  That is, do we count the occurrences of uninitialized or the
  occurrences of two?  If we mean the former the correct answer is 2
  (positions 3 and 4 are uninitialized in c); if we mean the latter,
  the correct answer is 1 (there is only one occurrence of two in c).

  Below are ACL2 renderings of the two meanings, which we call [former]
  and [latter].  (Warning: Our description of these examples, and of
  an example [fast former] that follows, assumes that only one of
  these three examples is actually executed; for example, they are
  not executed in sequence.  See ``A Word of Warning'' below for more
  about this issue.)

    (cnt 'demo (aset1 'demo (@ b) 2 'two) 4 (aref1 'demo (@ b) 2))  ; [former]

    (let ((c (aset1 'demo (@ b) 2 'two)))                           ; [latter]
      (cnt 'demo c 4 (aref1 'demo c 2)))

  Note that in [former] we create c in the second argument of the call
  to cnt (although we do not give it a name) and then refer to b in
  the fourth argument.  This is unconventional because the second
  reference to b in [former] is no longer the semantic value of demo.
  While ACL2 computes the correct answer, namely 2, the execution of
  the [aref1] expression in [former] is done slowly.

  A conventional rendering with the same meaning is

    (let ((x (aref1 'demo (@ b) 2)))                           ; [fast former]
      (cnt 'demo (aset1 'demo (@ b) 2 'two) 4 x))

  which fetches the 2nd element of b before creating c by assignment.
  It is important to understand that [former] and [fast former] mean
  exactly the same thing: both count the number of occurrences of
  uninitialized in c.  Both are legal ACL2 and both compute the same
  answer, 2.  Indeed, we can symbolically transform [fast former]
  into [former] merely by substituting the binding of x for x in the
  body of the [let].  But [fast former] can be evaluated faster than
  [former] because all of the references to demo use the then-current
  semantic value of demo, which is b in the first line and c
  throughout the execution of the cnt in the second line.  [Fast
  former] is the preferred form, both because of its execution speed
  and its clarity.  If you were writing in a conventional language
  you would have to write something like [fast former] because there
  is no way to refer to the 2nd element of the old value of b after
  smashing b unless it had been saved first.

  We turn now to [latter].  It is both clear and efficient.  It creates
  c by assignment to b and then it fetches the 2nd element of c, two,
  and proceeds to count the number of occurrences in c.  The answer
  is 1.  [Latter] is a good example of typical ACL2 array
  manipulation: after the assignment to b that creates c, c is used
  throughout.

  It takes a while to get used to this because most of us have grown
  accustomed to the peculiar semantics of arrays in conventional
  languages.  For example, in raw lisp we might have written
  something like the following, treating b as a ``global variable'':

    (cnt 'demo (aset 'demo b 2 'two) 4 (aref 'demo b 2))

  which sort of resembles [former] but actually has the semantics of
  [latter] because the b from which aref fetches the 2nd element is
  not the same b used in the aset!  The array b is destroyed by the
  aset and b henceforth refers to the array produced by the aset, as
  written more clearly in [latter].

  A Word of Warning: Users must exercise care when experimenting with
  [former], [latter] and [fast former].  Suppose you have just
  created b with the assignment shown above,

    ACL2 !>(assign b (aset1 'demo (@ a) 1 'one))

  If you then evaluate [former] in ACL2 it will complain that the
  [aref1] is slow and compute the answer, as discussed.  Then suppose
  you evaluate [latter] in ACL2.  From our discussion you might
  expect it to execute fast --- i.e., issue no complaint.  But in
  fact you will find that it complains repeatedly.  The problem is
  that the evaluation of [former] changed the semantic value of demo
  so that it is no longer b.  To try the experiment correctly you
  must make b be the semantic value of demo again before the next
  example is evaluated.  One way to do that is to execute

    ACL2 !>(assign b (compress1 'demo (@ b)))

  before each expression.  Because of issues like this it is often hard
  to experiment with ACL2 arrays at the top-level.  We find it easier
  to write functions that use arrays correctly and efficiently than
  to so use them interactively.

  This last assignment also illustrates a very common use of
  [compress1].  While it was introduced as a means of removing
  irrelevant pairs from an array built up by repeated assignments, it
  is actually most useful as a way of insuring fast access to the
  elements of an array.

  Many array processing tasks can be divided into two parts.  During
  the first part the array is built.  During the second part the
  array is used extensively but not modified.  If your [programming]
  task can be so divided, it might be appropriate to construct the
  array entirely with list processing, thereby saving the cost of
  maintaining the semantic value of the name while few references are
  being made.  Once the alist has stabilized, it might be worthwhile
  to treat it as an array by calling [compress1], thereby gaining
  constant time access to it.

  ACL2's theorem prover uses this technique in connection with its
  implementation of the notion of whether a [rune] is [disable]d or
  not.  Associated with every [rune] is a unique integer index,
  called its ``nume.'' When each rule is stored, the corresponding
  nume is stored as a component of the rule.  [Theories] are lists of
  [rune]s and membership in the ``current theory'' indicates that the
  corresponding rule is [enable]d.  But these lists are very long and
  membership is a linear-time operation.  So just before a proof
  begins we map the list of [rune]s in the current theory into an
  alist that pairs the corresponding numes with t.  Then we compress
  this alist into an array.  Thus, given a rule we can obtain its
  nume (because it is a component) and then determine in constant
  time whether it is [enable]d.  The array is never modified during
  the proof, i.e., [aset1] is never used in this example.  From the
  logical perspective this code looks quite odd: we have replaced a
  linear-time membership test with an apparently linear-time [assoc]
  after going to the trouble of mapping from a list of [rune]s to an
  alist of numes.  But because the alist of numes is an array, the
  ``apparently linear-time [assoc]'' is more apparent than real; the
  operation is constant-time.


Subtopics

  [Aref1]
      Access the elements of a 1-dimensional array

  [Aref2]
      Access the elements of a 2-dimensional array

  [Array1p]
      Recognize a 1-dimensional array

  [Array2p]
      Recognize a 2-dimensional array

  [Arrays-example]
      An example illustrating ACL2 arrays

  [Aset1]
      Set the elements of a 1-dimensional array

  [Aset1-trusted]
      Set the elements of a 1-dimensional array without [invariant-risk]

  [Aset2]
      Set the elements of a 2-dimensional array

  [Compress1]
      Remove irrelevant pairs from a 1-dimensional array

  [Compress2]
      Remove irrelevant pairs from a 2-dimensional array

  [Default]
      Return the :default from the [header] of a 1- or 2-dimensional array

  [Dimensions]
      Return the :dimensions from the [header] of a 1- or 2-dimensional
      array

  [Flush-compress]
      Flush the under-the-hood array for the given name

  [Header]
      Return the header of a 1- or 2-dimensional array

  [Maximum-length]
      Return the :maximum-length from the [header] of an array

  [Maybe-flush-and-compress1]
      Compress a one-dimensional array only if necessary

  [Slow-array-warning]
      A warning or error issued when [arrays] are used inefficiently")
 (ARRAYS-EXAMPLE
  (ARRAYS)
  "An example illustrating ACL2 arrays

  The example below illustrates the use of ACL2 arrays.  It is not, of
  course, a substitute for the detailed explanations provided
  elsewhere (see [arrays], including subtopics).

    ACL2 !>(defun defarray (name size initial-element)
             (compress1 name
                        (cons (list :HEADER
                                    :DIMENSIONS (list size)
                                    :MAXIMUM-LENGTH (1+ size)
                                    :DEFAULT initial-element
                                    :NAME name)
                              nil)))

    Since DEFARRAY is non-recursive, its admission is trivial.  We observe
    that the type of DEFARRAY is described by the theorem
    (AND (CONSP (DEFARRAY NAME SIZE INITIAL-ELEMENT))
         (TRUE-LISTP (DEFARRAY NAME SIZE INITIAL-ELEMENT))).
    We used the :type-prescription rule COMPRESS1.

    Summary
    Form:  ( DEFUN DEFARRAY ...)
    Rules: ((:TYPE-PRESCRIPTION COMPRESS1))
    Warnings:  None
    Time:  0.02 seconds (prove: 0.00, print: 0.02, other: 0.00)
     DEFARRAY
    ACL2 !>(assign my-ar (defarray 'a1 5 17))
     ((:HEADER :DIMENSIONS (5)
               :MAXIMUM-LENGTH 6 :DEFAULT 17 :NAME A1))
    ACL2 !>(aref1 'a1 (@ my-ar) 3)
    17
    ACL2 !>(aref1 'a1 (@ my-ar) 8)

    ACL2 Error in TOP-LEVEL:  The guard for the function symbol AREF1,
    which is
    (AND (ARRAY1P NAME L) (INTEGERP N) (>= N 0) (< N (CAR (DIMENSIONS NAME L)))),
    is violated by the arguments in the call (AREF1 'A1 '(#) 8).

    ACL2 !>(assign my-ar (aset1 'a1 (@ my-ar) 3 'xxx))
     ((3 . XXX)
      (:HEADER :DIMENSIONS (5)
               :MAXIMUM-LENGTH 6 :DEFAULT 17 :NAME A1))
    ACL2 !>(aref1 'a1 (@ my-ar) 3)
    XXX
    ACL2 !>(aset1 'a1 (@ my-ar) 3 'yyy) ; BAD: (@ my-ar) now points to
                                        ;      an old copy of the array!
    ((3 . YYY)
     (3 . XXX)
     (:HEADER :DIMENSIONS (5)
              :MAXIMUM-LENGTH 6 :DEFAULT 17 :NAME A1))
    ACL2 !>(aref1 'a1 (@ my-ar) 3) ; Because of \"BAD\" above, the array
                                   ; access is done using assoc rather
                                   ; than Lisp aref, hence is slower;
                                   ; but the answer is still correct,
                                   ; reflecting the value in (@ my-ar),
                                   ; which was not changed above.

    **********************************************************
    Slow Array Access!  A call of AREF1 on an array named
    A1 is being executed slowly.  See :DOC slow-array-warning
    **********************************************************

    XXX
    ACL2 !>")
 (ASET1
  (ARRAYS ACL2-BUILT-INS)
  "Set the elements of a 1-dimensional array

    Example Form:
    (aset1 'delta1 a (+ i k) 27)

    General Form:
    (aset1 name alist index val)

  where name is a symbol, alist is a 1-dimensional array named name,
  index is a legal index into alist, and val is an arbitrary object.
  See [arrays] for details.  Roughly speaking this function
  ``modifies'' alist so that the value associated with index is val.
  More precisely, it returns a new array, alist', of the same name
  and dimension as alist that, under [aref1], is everywhere equal to
  alist except at index where the result is val.  That is, (aref1
  name alist' i) is (aref1 name alist i) for all legal indices i
  except index, where (aref1 name alist' i) is val.

  In order to ``modify'' alist, aset1 [cons]es a new pair onto the
  front.  If the length of the resulting alist exceeds the
  :[maximum-length] entry in the array [header], aset1 compresses the
  array as with [compress1].

  It is generally expected that the ``semantic value'' of name will be
  alist (see [arrays]).  This function operates in virtually constant
  time whether this condition is true or not (unless the [compress1]
  operation is required).  But the value returned by this function
  cannot be used efficiently by subsequent aset1 operations unless
  alist is the semantic value of name when aset1 is executed.  Thus,
  if the condition is not true, aset1 prints a slow array warning to
  the comment window.  See [slow-array-warning].

  Note that [aset1] is marked as having [invariant-risk], which can
  affect the execution of :[program]-mode functions.  To get around
  this problem (but only with great care!), see [aset1-trusted].

  Function: <aset1>

    (defun
         aset1 (name l n val)
         (declare (xargs :guard (and (array1p name l)
                                     (integerp n)
                                     (>= n 0)
                                     (< n (car (dimensions name l))))))
         (let ((l (cons (cons n val) l)))
              (cond ((> (length l) (maximum-length name l))
                     (compress1 name l))
                    (t l))))


Subtopics

  [Aset1-trusted]
      Set the elements of a 1-dimensional array without [invariant-risk]")
 (ASET1-TRUSTED
  (ARRAYS ACL2-BUILT-INS ASET1)
  "Set the elements of a 1-dimensional array without [invariant-risk]

    Example Form:
    (aset1-trusted 'delta1 a (+ i k) 27)

    General Form:
    (aset1-trusted name alist index val)

  This utility is identical to [aset1]; in fact, it has the same guard.
  The difference is that it does not carry [invariant-risk].  Because
  of that, functions that call aset1-trusted may suffer from
  invariant-risk but not be noted by the system as carrying
  invariant-risk.  Therefore, aset1-trusted it is [untouchable] and
  should be used with great care.  If your system consists of
  :[logic]-mode functions, then there is no reason to use
  aset1-trusted, because only :[program]-mode functions truly carry
  invariant-risk.

  Function: <aset1-trusted>

    (defun
         aset1-trusted (name l n val)
         (declare (xargs :guard (and (array1p name l)
                                     (integerp n)
                                     (>= n 0)
                                     (< n (car (dimensions name l))))))
         (aset1 name l n val))")
 (ASET2
  (ARRAYS ACL2-BUILT-INS)
  "Set the elements of a 2-dimensional array

    Example Form:
    (aset2 'delta1 a i j 27)

    General Form:
    (aset2 name alist i j val)

  where name is a symbol, alist is a 2-dimensional array named name, i
  and j are legal indices into alist, and val is an arbitrary object.
  See [arrays] for details.  Roughly speaking this function
  ``modifies'' alist so that the value associated with (i . j) is
  val.  More precisely, it returns a new array, alist', of the same
  name and dimension as alist that, under [aref2], is everywhere
  equal to alist except at (i . j) where the result is val.  That is,
  (aref2 name alist' x y) is (aref2 name alist x y) for all legal
  indices x y except i and j where (aref2 name alist' i j) is val.

  In order to ``modify'' alist, aset2 [cons]es a new pair onto the
  front.  If the length of the resulting alist exceeds the
  :[maximum-length] entry in the array [header], aset2 compresses the
  array as with [compress2].

  It is generally expected that the ``semantic value'' of name will be
  alist (see [arrays]).  This function operates in virtually constant
  time whether this condition is true or not (unless the [compress2]
  operation is required).  But the value returned by this function
  cannot be used efficiently by subsequent aset2 operations unless
  alist is the semantic value of name when aset2 is executed.  Thus,
  if the condition is not true, aset2 prints a slow array warning to
  the comment window.  See [slow-array-warning].

  Function: <aset2>

    (defun
         aset2 (name l i j val)
         (declare (xargs :guard (and (array2p name l)
                                     (integerp i)
                                     (>= i 0)
                                     (< i (car (dimensions name l)))
                                     (integerp j)
                                     (>= j 0)
                                     (< j (cadr (dimensions name l))))))
         (let ((l (cons (cons (cons i j) val) l)))
              (cond ((> (length l) (maximum-length name l))
                     (compress2 name l))
                    (t l))))")
 (ASH
  (NUMBERS ACL2-BUILT-INS)
  "Arithmetic shift operation

  (ash i c) is the result of taking the two's complement representation
  of the integer i and shifting it by c bits: shifting left and
  padding with c 0 bits if c is positive, shifting right and dropping
  (abs c) bits if c is negative, and simply returning i if c is 0.

  The [guard] for ash requires that its arguments are integers.

  Ash is a Common Lisp function.  See any Common Lisp documentation for
  more information.

  Function: <ash>

    (defun ash (i c)
           (declare (xargs :guard (and (integerp i) (integerp c))))
           (floor (* (ifix i) (expt 2 c)) 1))")
 (ASSERT$
  (ERRORS ACL2-BUILT-INS)
  "Cause a hard error if the given test is false

    General Form:
    (assert$ test form)

  where test returns a single value and form is arbitrary.
  Semantically, this call of assert$ is equivalent to form.  However,
  it causes a hard error if the value of test is nil.  That hard
  error invokes the function [illegal], which has a [guard] that is
  equal to nil; so if you use assert$ in code for which you verify
  guards, then a proof obligation will be that the occurrence of test
  is never nil.

  See also [assert*].  Both [assert$] and [assert*] create a [guard]
  proof obligation (when used in a definition made in [logic]-mode).
  However, assert$ checks the assertion at runtime, while assert*
  does not.

  Also see [assert-event] for an assertion-checking utility that is an
  [event].")
 (ASSERT*
  (ERRORS ACL2-BUILT-INS)
  "Create a [guard] proof obligation that given test holds

    General Form:
    (assert* test form)

  where test returns a single value and form is arbitrary.
  Semantically, this call of assert* is equivalent to form.  However,
  a [guard] proof obligation is created that test holds, when used in
  a definition made in [logic]-mode.

  For a related utility, see [assert$].  Both assert$ and assert*
  create a [guard] proof obligation (when used in a definition made
  in [logic]-mode).  However, assert$ checks the assertion at
  runtime, while assert* does not.

  Also see [assert-event] for an assertion-checking utility that is an
  [event].

  Macro: <assert*>

    (defmacro assert* (test form)
              (cons 'and
                    (cons (cons 'mbt* (cons test 'nil))
                          (cons form 'nil))))")
 (ASSERT-EVENT
  (EVENTS ERRORS)
  "Assert that a given form returns a non-nil value

  Assert-event provides a flexible way to check that evaluation of an
  expression returns a non-nil value, causing an error otherwise.
  Calls of assert-event are [event] forms; thus, they may occur in
  [books] as well as [encapsulate] and [progn] events.  See also
  [assert!] and [assert!-stobj] for simple interfaces to
  assert-event.  See [assert$] and [assert*] for assertion-checking
  utilities to use in programs.

  Basic calls of assert-event will take just one argument, called an
  ``assertion'', which is a form that evaluates to a single value
  that is not a [stobj].  The following log shows a successful
  invocation --- one where the assertion evaluates to a non-nil
  value.

    ACL2 !>(assert-event (equal (+ 3 4) 7))
     :PASSED
    ACL2 !>

  Such a use of assert-event will probably suffice for most users, that
  is, where the form evaluates to a single non-stobj value and there
  are no keyword arguments.  The keyword arguments, which are
  optional and discussed below, extend that functionality, for
  example: multiple values are permitted by keyword :stobjs-out, and
  keyword :on-skip-proofs can override the default behavior of
  ignoring assertions when proofs are being skipped.

    General Form:
    (assert-event assertion
                  :event event           ; default nil
                  ;; evaluated keyword arguments:
                  :ctx                   ; default 'assert-event
                  :msg msg               ; default t
                  :on-skip-proofs sp     ; default nil
                  :safe-mode safe-mode   ; default :same
                  :stobjs-out stobjs-out ; default nil
                  )

  where assertion and event are not evaluated but all the other
  arguments are evaluated, with the defaults shown above
  corresponding to values after evaluation.

  The following example illustrates all of the keyword arguments, which
  are documented below.

    (assert-event (mv (equal (+ 3 4) 7) state)
                  :event (defun f (x) (cons x x))
                  :ctx '(assert-event . <some-mv>)
                  :msg (msg \"Oops, I forgot what ~x0+~x1 is!\" 3 4)
                  :on-skip-proofs t
                  :safe-mode nil
                  :stobjs-out '(nil state))

  Assert-event is a macro whose expansion directly produces a call of
  the primitive event, value-triple, where: if a call of assert-event
  speifies :msg msg, then the corresponding call of value-triple
  specifies :check (or msg t).  But unlike value-triple, assert-event
  can specify an event to evaluate when the assertion has non-nil
  value, using the :event keyword.  (You can get a sense of the
  value-triple call generated from an assert-event call by using
  :[trans1] on the assert-event form.)  The remaining keyword
  arguments of assert-event are also arguments of value-triple.  Here
  is a brief summary of the keyword arguments, but NOTE: see
  [value-triple] for more detailed explanations of keywords other
  than :EVENT.

  :EVENT event (default nil): When event is not nil, it should be an
  [event], that is, a form that may be in a book or a call of
  [encapsulate] or [progn].  If the assertion evaluates to a non-nil
  value (or to multiple values where the first value is not a stobj
  and is non-nil; see :STOBJS-OUT below), then event is evaluated;
  otherwise the evaluation results in an error.

  :CTX ctx (default: 'assert-event): context for error messages.

  :MSG msg (default: t): message to print when there is an error
  (equivalent to keyword argument :CHECK of [value-triple]).

  :ON-SKIP-PROOFS sp (default: nil): supply t to evaluate the assertion
  even when skipping proofs (i.e., during [include-book] or the
  second pass of an [encapsulate] event, or after invoking
  [set-ld-skip-proofsp] to skip proofs).

  :SAFE-MODE safe-mode (default: :same): provides backward
  compatibility, but is probably best ignored.

  :STOBJS-OUT stobjs-out (default: nil): specify :auto to allow any
  return, even with multiple values provided the first return value
  is not a [stobj]; or specify a list starting with nil,
  corresponding to the multiple values returned, with stobjs in stobj
  positions and nil elsewhere.  A stobjs-out of nil is treated as
  (nil).  The first return value is the one checked to be non-nil
  with one exception: when an [error-triple] (mv erp val state) is
  returned, erp must be nil and it is val that is checked to be
  non-nil.")
 (ASSERTIONS (POINTERS) "See [errors].")
 (ASSIGN
  (PROGRAMMING-WITH-STATE ACL2-BUILT-INS)
  "Assign to a global variable in [state]

    Examples:
    (assign x (expt 2 10))
    (assign a (aset1 'ascii-map-array (@ a) 66 'Upper-case-B))

    General Form:
    (assign symbol term)

  where symbol is any symbol (with certain enforced exclusions to avoid
  overwriting ACL2 system ``globals'') and term is any ACL2 term that
  could be evaluated at the top-level.  Assign evaluates the term,
  stores the result as the value of the given symbol in the
  global-table of [state], and returns the result.  (Note: the actual
  implementation of the storage of this value is much more efficient
  than this discussion of the logic might suggest.)  Assign is a
  macro that effectively expands to the more complicated but
  understandable:

    (pprogn (f-put-global 'symbol term state)
            (mv nil (f-get-global 'symbol state) state)).

  The macro f-put-global is closely related to [assign]: (assign var
  val) macroexpands to (f-put-global 'var val state).

  The macro [@] gives convenient access to the value of such globals.
  The :[ubt] operation has no effect on the global-table of [state].
  Thus, you may use these globals to hang onto useful data structures
  even though you may undo back past where you computed and saved
  them.")
 (ASSOC
  (ALISTS ACL2-BUILT-INS)
  "Look up key in association list

    General Forms:
    (assoc x alist)
    (assoc x alist :test 'eql)   ; same as above (eql as equality test)
    (assoc x alist :test 'eq)    ; same, but eq is equality test
    (assoc x alist :test 'equal) ; same, but equal is equality test

  (Assoc x alist) is the first member of alist whose [car] is x, or nil
  if no such member exists.  The optional keyword, :TEST, has no
  effect logically, but provides the test (default [eql]) used for
  comparing x with the [car]s of successive elements of alist.

  The [guard] for a call of assoc depends on the test.  In all cases,
  the second argument must satisfy [alistp].  If the test is [eql],
  then either the first argument must be suitable for [eql] (see
  [eqlablep]) or the second argument must satisfy [eqlable-alistp].
  If the test is [eq], then either the first argument must be a
  symbol or the second argument must satisfy [symbol-alistp].

  See [equality-variants] for a discussion of the relation between
  assoc and its variants:

      (assoc-eq x alist) is equivalent to (assoc x alist :test 'eq);

      (assoc-equal x alist) is equivalent to (assoc x alist :test 'equal).

  In particular, reasoning about any of these primitives reduces to
  reasoning about the function assoc-equal.

  Assoc is defined by Common Lisp.  See any Common Lisp documentation
  for more information.

  Function: <assoc-equal>

    (defun assoc-equal (x alist)
           (declare (xargs :guard (alistp alist)))
           (cond ((endp alist) nil)
                 ((equal x (car (car alist)))
                  (car alist))
                 (t (assoc-equal x (cdr alist)))))")
 (ASSOC-EQ (POINTERS) "See [assoc].")
 (ASSOC-EQUAL (POINTERS) "See [assoc].")
 (ASSOC-KEYWORD
  (KEYWORD-VALUE-LISTP ACL2-BUILT-INS)
  "Look up key in a [keyword-value-listp]

  If l is a list of even length of the form (k1 a1 k2 a2 ... kn an),
  where each ki is a keyword, then (assoc-keyword key l) is the first
  tail of l starting with key if key is some ki, and is nil
  otherwise.

  The [guard] for (assoc-keyword key l) is (keyword-value-listp l).

  Function: <assoc-keyword>

    (defun assoc-keyword (key l)
           (declare (xargs :guard (keyword-value-listp l)))
           (cond ((endp l) nil)
                 ((eq key (car l)) l)
                 (t (assoc-keyword key (cddr l)))))")
 (ASSOC-STRING-EQUAL
  (ALISTS ACL2-BUILT-INS)
  "Look up key, a string, in association list

  (Assoc-string-equal x alist) is similar to [assoc-equal].  However,
  for string x and alist alist, the comparison of x with successive
  keys in alist is done using [string-equal] rather than [equal].

  The [guard] for assoc-string-equal requires that x is a string and
  alist is an alist.

  Function: <assoc-string-equal>

    (defun assoc-string-equal (str alist)
           (declare (xargs :guard (and (stringp str)
                                       (standard-string-p str)
                                       (standard-string-alistp alist))))
           (cond ((endp alist) nil)
                 ((string-equal str (car (car alist)))
                  (car alist))
                 (t (assoc-string-equal str (cdr alist)))))")
 (ATOM
  (CONSES ACL2-BUILT-INS)
  "Recognizer for atoms

  (atom x) is true if and only if x is an atom, i.e., not a [cons]
  pair.

  Atom has a [guard] of t, and is a Common Lisp function.  See any
  Common Lisp documentation for more information.

  Function: <atom>

    (defun atom (x)
           (declare (xargs :guard t))
           (not (consp x)))


Subtopics

  [Atom-listp]
      Recognizer for a true list of [atom]s

  [Good-atom-listp]
      Recognizer for a true list of ``good'' [atom]s")
 (ATOM-LISTP
  (ATOM LISTS ACL2-BUILT-INS)
  "Recognizer for a true list of [atom]s

  The predicate atom-listp tests whether its argument is a [true-listp]
  of [atom]s, i.e., of non-conses.

  Also see [good-atom-listp].

  Function: <atom-listp>

    (defun atom-listp (lst)
           (declare (xargs :guard t))
           (cond ((atom lst) (eq lst nil))
                 (t (and (atom (car lst))
                         (atom-listp (cdr lst))))))")
 (AUTO-INSTANCE (POINTERS)
                "See [defthm<w].")
 (A_FLYING_TOUR_OF_ACL2
  (PAGES_WRITTEN_ESPECIALLY_FOR_THE_TOURS)
  "A Flying Tour of ACL2

  {IMAGE} (see [About_the_ACL2_Home_Page])

  On this tour you will learn a little about what ACL2 is for rather
  than how ACL2 works.  At the top and bottom of the ``page'' there
  are ``flying tour'' icons.  Click on either icon to go to the next
  page of the tour.

  The tour visits the following topics sequentially.  But on your first
  reading, don't navigate through the tour by clicking on these
  links; they are shown as live links only so that later you can
  determine what you've visited.  Instead, just use the flying tour
  icons.

    The Flight Plan
    * This Documentation (see [About_the_ACL2_Home_Page])
    * What is ACL2? (see [What_Is_ACL2{Q}])
    * Mathematical Logic (see [What_is_a_Mathematical_Logic{Q}])
    * Mechanical Theorem Proving (see [What_is_a_Mechanical_Theorem_Prover{Q}])
    * Mathematical Models in General (see [About_Models])
    * Mathematical Models of Computing Machines (see [Models_of_Computer_Hardware_and_Software])
         Formalizing Models (see [A_Typical_State])
         Running Models (see [Running_Models])
         Symbolic Execution of Models (see [Symbolic_Execution_of_Models])
         Proving Theorems about Models (see [Proving_Theorems_about_Models])
    * Requirements of ACL2
         The User's Skills (see [What_is_Required_of_the_User{Q}])
         Training (see [How_Long_Does_It_Take_to_Become_an_Effective_User{Q}])
         Host System (see [Other_Requirements])

  On your first reading, don't explore other links you see in the tour.
  Some of them lead to the Walking Tour, which you can take
  coherently when you finish this tour.  Others lead into the
  extensive hypertext documentation and you are liable to get lost
  there unless you're trying to answer a specific question.  We
  intend the tour to take about 10 minutes of your time.

  {IMAGE} (see [About_the_ACL2_Home_Page])")
 (A_SKETCH_OF_HOW_THE_REWRITER_WORKS
  (PAGES_WRITTEN_ESPECIALLY_FOR_THE_TOURS)
  "A Sketch of How the Rewriter Works

  Below we show the first target term, extracted from the current
  conjecture.  Below it we show the associativity rule.

  {IMAGE}

  The variables of the rewrite rule are instantiated so that the
  left-hand side of the rule matches the target:

    variable          term from target
      a                     x1
      b                     x2
      c                     (app x3 x4)

  Then the target is replaced by the instantiated right-hand side of
  the rule.

  Sometimes rules have hypotheses.  To make a long story short, if the
  rule has hypotheses, then after matching the left-hand side, the
  rewriter instantiates the hypotheses and rewrites them recursively.
  This is called backchaining.  If they all rewrite to true, then the
  target is replaced as above.

  We discuss the rewriter in more detail in the extended introduction
  to how to use the theorem prover, see
  [introduction-to-the-theorem-prover], which we will recommend you
  work through after you have finished the two tours.")
 (A_TINY_WARNING_SIGN
  (PAGES_WRITTEN_ESPECIALLY_FOR_THE_TOURS)
  "A Tiny Warning Sign

  {IMAGE}

  This warning sign, which usually appears as ``{ICON}'', indicates
  that the link it marks takes you into ACL2's online documentation.

  The documentation is a vast graph of documented topics intended to
  help the user of ACL2 rather than the potential user.  If you are
  exploring ACL2's home page to learn about the system, perhaps you
  should go back rather than follow the link marked with this sign.
  But you are welcome to explore the online documentation as well.
  Good luck.")
 (A_TRIVIAL_PROOF (PAGES_WRITTEN_ESPECIALLY_FOR_THE_TOURS)
                  "A Trivial Proof

  {IMAGE}")
 (A_TYPICAL_STATE
  (PAGES_WRITTEN_ESPECIALLY_FOR_THE_TOURS)
  "A Typical State

  {IMAGE} (see [Functions_for_Manipulating_these_Objects])

  {IMAGE}

  Observe that the states in typical models talk about

    booleans    integers   vectors     records   caches
    bits        symbols    arrays      stacks    files
    characters  strings    sequences   tables    directories

  These objects are discrete rather than continuous; furthermore they
  are built incrementally or inductively by repeatedly using
  primitive operations to put together smaller pieces.

  The functions we need to manipulate these objects do things like
  concatenate, reverse, sort, search, count, etc.

  {IMAGE} (see [Functions_for_Manipulating_these_Objects])")
 (A_WALKING_TOUR_OF_ACL2
  (PAGES_WRITTEN_ESPECIALLY_FOR_THE_TOURS)
  "A Walking Tour of ACL2

  {IMAGE} (see [Common_Lisp])

  On this tour you will learn a little more about the ACL2 logic, the
  theorem prover, and the user interface.

  This time we will stick with really simple things, such as the
  associativity of list concatenation.

  We assume you have taken the Flying Tour but that you did not
  necessarily follow all the ``off-tour'' links because we encouraged
  you not to.  With the Walking Tour we encourage you to visit
  off-tour links --- provided they are not marked with the tiny
  warning sign ({ICON} (see [A_Tiny_Warning_Sign])).  But they are
  ``branches'' in the tour that lead to ``dead ends.'' When you reach
  a dead end, remember to use your browser's Back Button to return to
  the Walking Tour to continue.

  When you get to the end of the tour we'll give you a chance to repeat
  quickly both the Flying and the Walking Tours to visit any off-tour
  links still of interest.

  {IMAGE} (see [Common_Lisp])")
 (BACKCHAIN-LIMIT
  (REWRITE META LINEAR TYPE-PRESCRIPTION)
  "Limiting the effort expended on relieving hypotheses

  Before ACL2 can apply a rule with hypotheses, it must establish that
  the hypotheses are true.  (We ignore the relaxing of this
  requirement afforded by [case-split]s and [force]d hypotheses.)
  ACL2 typically establishes each hypothesis by backchaining ---
  instantiating the hypothesis and then rewriting it recursively.
  Here we describe how ACL2 allows the user to limit backchaining.
  At the end, below, we describe the function [backchain-limit].

  Each hypothesis of a [rewrite], [meta], [linear], or
  [type-prescription] rule is assigned a backchain-limit when the
  rule is stored.  By default, this limit is nil, denoting infinity
  (no limit).  However, the value used for the default may be set to
  a non-negative integer (or to nil) by the user; see
  [set-default-backchain-limit].  The default is overridden when a
  :backchain-limit-lst is supplied explicitly with the rule; see
  [rule-classes].  The number of recursive applications of
  backchaining starting with the hypothesis of a rule is limited to
  the backchain-limit associated with that hypothesis.

  Moreover, the user may set global backchain-limits that limit the
  total backchaining depth.  See [set-backchain-limit].  One limit is
  for the use of [rewrite], [meta], and [linear] rules, while the
  other limit is for so-called ``[type-set] reasoning'', which uses
  rules of class [type-prescription] rules.  The two limits operate
  independently.  Below, we discuss the first kind of backchain
  limits, i.e., for other than [type-prescription] rules, except as
  otherwise indicated; but the mechanism for those rules is similar.

  Below we lay out the precise sense in which a global backchain-limit
  interacts with the backchain-limits of individual rules in order to
  limit backchaining.  But first we note that when further
  backchaining is disallowed, ACL2 can still prove a hypothesis in a
  given context by using that contextual information.  In fact,
  [type-set] reasoning may be used (except that a weaker version of
  it is used in the second case above, i.e., where we are already
  doing type-set reasoning).  Thus, the relieving of hypotheses may
  be limited to the use of contextual information (without
  backchaining, i.e., without recursively rewriting hypotheses) by
  executing :set-backchain-limit 0.

  Recall that there are two sorts of backchain limits: those applied to
  hypotheses of individual rules, as assigned by their
  :[rule-classes] or else taken from the default (see
  [set-default-backchain-limit]); and the global limit, initially nil
  (no limit) but settable with :[set-backchain-limit].  Here is how
  these two types of limits interact to limit backchaining, i.e.,
  recursive rewriting of hypotheses.  ACL2 maintains a current
  backchain limit, which is the limit on the depth of recursive calls
  to the rewriter, as well as a current backchain depth, which is
  initially 0 and is incremented each time ACL2 backchains (and is
  decremented when a backchain completes).  When ACL2 begins to
  rewrite a literal (crudely, one of the ``top-level'' terms of the
  goal currently being worked on), it sets the current
  backchain-limit to the global value, which is initially nil but can
  be set using :[set-backchain-limit].  When ACL2 is preparing to
  relieve a hypothesis by backchaining (hence, after it has already
  tried type-set reasoning), it first makes sure that the current
  backchain limit is greater than the current backchain depth.  If
  not, then it refuses to relieve that hypothesis.  Otherwise, it
  increments the current backchain depth and calculates a new current
  backchain-limit by taking the minimum of two values: the existing
  current backchain-limit, and the sum of the current backchain depth
  and the backchain-limit associated with the hypothesis.  Thus, ACL2
  only modifies the current backchain-limit if it is necessary to
  decrease that limit in order to respect the backchain limit
  associated with the hypothesis.

  We illustrate with the following examples.

    ; We stub out some functions so that we can reason about them.

    (defstub p0 (x) t)
    (defstub p1 (x) t)
    (defstub p2 (x) t)
    (defstub p3 (x) t)

    ; Initially, the default-backchain-limit is nil, or infinite.

    (defaxiom p2-implies-p1-limitless
      (implies (p2 x)
               (p1 x)))

    ; The following rule will have a backchain-limit of 0.

    (defaxiom p1-implies-p0-limit-0
      (implies (p1 x)
               (p0 x))
      :rule-classes ((:rewrite :backchain-limit-lst 0)))

    ; We have (p2 x) ==> (p1 x) ==> (p0 x).  We wish to establish that
    ; (p2 x) ==> (p0 x).  Normally, this would be no problem, but here
    ; we fail because ACL2 cannot establish (p0 x) by type-set reasoning
    ; alone.

    (thm
      (implies (p2 x)
               (p0 x)))

    ; We set the default-backchain-limit (for rewriting) to 1.

    :set-default-backchain-limit 1

    ; The following is more powerful than p1-implies-p0-limit-0
    ; because it can use rewrite rules to establish (p1 x).

    (defaxiom p1-implies-p0-limit-1
      (implies (p1 x)
               (p0 x)))

    ; This theorem will succeed:

    (thm
      (implies (p2 x)
               (p0 x)))

    ; We return the default-backchain-limit to its initial value.

    :set-default-backchain-limit nil

    ; Here is our last axiom.

    (defaxiom p3-implies-p2-limitless
      (implies (p3 x)
               (p2 x)))

    ; We now have (p3 x) ==> (p2 x) ==> (p1 x) ==> (p0 x).  However the
    ; rule p1-implies-p0-limit-1 has a backchain-limit of 1; hence we
    ; are not allowed to backchain far enough back to use
    ; p3-implies-p2-limitless.  We therefore lose.

    (defthm will-fail
      (implies (p3 x)
               (p0 x)))

  Finally, we remark that to see the current global backchain-limits,
  issue the following commands.

    (backchain-limit wrld :ts) ; backchain limit for type-set reasoning
    (backchain-limit wrld :rewrite) ; backchain limit for rewriting


Subtopics

  [Set-backchain-limit]
      Sets the backchain-limit used by the type-set and rewriting
      mechanisms

  [Set-default-backchain-limit]
      Sets the default backchain-limit used when admitting a rule")
 (BACKCHAIN-LIMIT-RW
      (POINTERS)
      "See [hints] for information about the keyword :backchain-limit-rw.")
 (BACKCHAINING
  (RULE-CLASSES)
  "Attempting to relieve the hypotheses of a rule

  When the theorem prover attempts to apply a rule (e.g., a [rewrite]
  rule), it must relieve (prove) the hypotheses of that rule.  In the
  ACL2 community, this process of relieving hypotheses is called
  backchaining.

  There is no such thing as a backchaining or backward-chaining rule
  class (see [rule-classes]) in ACL2.")
 (BACKQUOTE
  (READER)
  "Variant of quotation introducing templates for data structures

  ACL2 supports the backquote (`) construct of Common Lisp.  See any
  Common Lisp documentation for details, for example, its {discussion
  in the Common Lisp HyperSpec |
  http://www.lispworks.com/documentation/HyperSpec/Body/02_df.htm}.
  Here we give only a brief introduction.

  Together with the use of comma (,) and comma-atsign (,@), backquote
  provides a variant of quote that supports an escape mechanism, as
  illustrated by the following examples.

    ACL2 !>`(a b c)
    (A B C)
    ACL2 !>(let ((x '(a b c))) `(1 ,(cdr x) 2))
    (1 (B C) 2)
    ACL2 !>(let ((x '(a b c))) `(1 ,@(cdr x) 2))
    (1 B C 2)
    ACL2 !>

  The first example above illustrates that backquote is much like
  quote.  The second example shows how a comma escapes from the
  quotation, inserting the value of the object that follows the
  comma.  The third example is similar to the second, except that it
  uses comma followed by an atsign, which splices in the value (which
  must satisfy [true-listp]) rather than inserting it.")
 (BACKTRACK (POINTERS)
            "See [hints] for information about the keyword :backtrack.")
 (BADGE
  (APPLY$)
  "Syntactic requirements on a function symbol to be used by apply$

  ``Badge'' is both the name of an ACL2 function and the name of a
  concept key to the [apply$] machinery.  We discuss the function
  named badge first.  The discussion also mentions the concept of
  warrants, which are easily confused with badges.  See the
  discussion of Badges versus Warrants at the top of defbadge.  But
  roughly put, badges extend the ACL2 syntax and warrants extend the
  proof theory.  You'll need a badge for fn to allow the system to
  syntactically analyze (apply$ 'fn ...).  You'll need a both a badge
  and a warrant for fn if you wish to reason about that term with
  ACL2.

  General Form:

    (badge fn)

  The argument, fn, is expected to be a function symbol.  If fn is one
  of about 800 ACL2 primitives (discussed below) or is a user-defined
  function successfully processed by either the event [defbadge] or
  the event [defwarrant], the result is an object, called the
  ``badge'' of fn, which among other things specifies the [ilk] of
  each formal of fn.  Otherwise, an error is caused.  We explain
  below, where we define the concepts of the ``out arity,'' ``ilks,''
  and ``tameness requirements'' of fn's badge.

  A function symbol must have a badge in order to apply$ the symbol and
  it is up to you, the user, to invoke an event that will assign a
  badge to your user-defined functions, if possible.  Defbadge will
  assign a badge to a function symbol, if possible, and defwarrant
  will assign both a badge (if the function symbol doesn't already
  have one) and a [warrant], if possible.  The macro [defun$] is just
  an abbreviation for a defun followed by a defwarrant.  Almost all
  primitive system functions already have badges.

  The complete list of badged primitives can be seen by evaluating

    (append '(BADGE TAMEP TAMEP-FUNCTIONP SUITABLY-TAMEP-LISTP
                    APPLY$ EV$)
            (strip-cars *badge-prim-falist*))

  Badge is a defined function in ACL2.  You can inspect its definition
  with

    ACL2 !>:pe badge

  and see that after handling the built-in symbols it defers to the
  undefined function [badge-userfn].  In the evaluation theory,
  badge-userfn has an attachment that returns the badge computed by
  defbadge or defwarrant.  But in the proof theory, badge-userfn is
  undefined and the [warrant] for fn specifies the badge of fn.
  Thus, in the proof theory, you cannot reason about the application
  of a non-primitive function unless there is a warrant for the
  function available as a hypothesis.

  The rest of this documentation illustrates and explains what badges
  mean, starting with a few examples.

    ACL2 !>(badge 'cons)
    (APPLY$-BADGE 2 1 . T)

    ACL2 !>(badge 'apply$)
    (APPLY$-BADGE 2 1 :FN NIL)

    ACL2 !>(badge 'foldr)
    (APPLY$-BADGE 3 1 NIL :FN NIL)

  The last example assumes that foldr has been defined with

    (defun$ foldr (lst fn init)
      (if (endp lst)
          init
          (apply$ fn
                  (list (car lst)
                        (foldr (cdr lst) fn init)))))

  In general, badges have the form (APPLY$-BADGE n k . ilks), where n
  is the arity of fn, k is the out arity (i.e., the number of results
  returned by fn) and ilks is either T or a list of n tokens.  Each
  token is either :FN, :EXPR, or NIL.

  The badge of fn, if any, is computed when the event (defbadge fn) or
  (defwarrant fn) completes successfully.  See [defbadge] for a
  sketch of the algorithm used to compute badges.  Here though we are
  just concerned with how badges impact apply$.

  The ilks of a function, fn, determines the ``tameness requirements''
  mentioned in the specification of [apply$].  When the ilks
  component of fn's badge is a list, it has as many elements as there
  are formals to fn and each successive element is called the ilk of
  the corresponding formal.  For example, given the definition of
  foldr above and the badge shown for it, the first and third
  formals, lst and init, each have ilk NIL and the second formal, fn,
  has ilk :FN.  In the special case that ilks is not a list it is T
  and we just say each formal has ilk NIL -- treating that T as a
  suitably long list of NILs.

  Each non-NIL ilk imposes a tameness requirement on (apply$ fn args).
  If a formal has ilk :FN the corresponding element of args must
  satisfy tamep-functionp.  If a formal has ilk :EXPR the
  corresponding element of args must satisfy tamep.  Ilk NIL imposes
  no requirement.  (Thus, if the ilks of fn's badge is T, as it is
  for cons for example, there is no tameness requirement at all.)
  See [tame] for a discussion of the various notions of tameness.

  Informally, if a formal's ilk is :FN, the corresponding element of
  args must be a tame function symbol or well-formed LAMBDA object.
  If a formal's ilk is :EXPR, the corresponding element of args must
  be a tame expression.

  If a formal has ilk :FN then you are allowed to put a [lambda$]
  expression in that slot.  Any quoted LAMBDA object you explicitly
  write in such a slot must be well-formed (see
  [well-formed-lambda-objectp]).  Well-formedness can be hard to
  achieve in quoted hand-written LAMBDA objects; we recommend that
  you use lambda$!  But the restrictions on what can occupy a :FN
  slot are enforced when user input is translated into formal terms.
  It is possible to circumvent these syntactic checks without
  endangering soundness: axiomatically apply$ puts no restrictions on
  its arguments, it just doesn't behave the way you might expect on
  ill-formed LAMBDA objects.  See
  [gratuitous-lambda-object-restrictions].

  Clarification: The careful reader will note that the formal
  requirement on a :FN argument is that it must satisfy
  tamep-functionp.  Inspection of the definition of tamep-functionp
  reveals that the argument must either be badged symbol with ilks T
  or else be a tame LAMBDA object.  But in the informal description
  above we said that it must be a ``tame function symbol or a
  well-formed LAMBDA object.'' Well-formedness implies tameness but
  they are not the same.  What's going on?  The reason for this and
  related discrepancies in the documentation is that there is a
  tension between the logical definition of apply$ and the practical
  business of executing it.  The former involves the existence of a
  model, soundness, and the difficulty of proving theorems about
  apply$.  The latter involves the Common Lisp compiler.  We want the
  logical foundations to be simple so we -- and you -- can reason
  about apply$, but the compiler imposes unavoidable and complicated
  restrictions.  The upshot is that the logical foundations assign
  meaning to LAMBDA objects that cannot be compiled.  Applying merely
  ``tame'' LAMBDAs is slower than applying ``well-formed'' ones.  In
  a sense by acting like ``tame LAMBDA objects'' and ``well-formed
  LAMBDA objects'' are the same thing we're trying to trick you!  If
  you ever have occasion to formally express the restrictions on
  apply$ in some theorem, use tamep-functionp.  But when you write
  concrete LAMBDA constants, try to keep them well-formed.  We try to
  encourage this by providing [lambda$], which guarantees
  well-formedness at translate-time, and by implementing full
  well-formedness checks -- not just tameness checks -- on quoted
  LAMBDA objects in :FN slots.  And we give you ways to circumvent
  these checks -- see [gratuitous-lambda-object-restrictions] -- if
  you really mean to.")
 (BADGE-USERFN
  (APPLY$)
  "Undefined function used by badge on non-primitives

  When [badge] is given a non-primitive function symbol fn it calls
  this function to determine the badge of fn.  But this function is
  undefined.  In the proof theory, its value on a given function
  symbol fn is specified, if at all, by the [warrant] for fn which
  must be available as a hypothesis in the formula being proved.  In
  the evaluation theory, badge-userfn has an attachment that makes it
  behave as though all warrants are assumed.  See [badge] for
  details.")
 (BASICS
  (PROGRAMMING)
  "Basic control structures for [programming] like [if] and [cond],
  binding operators like [let] and [flet], multiple-value constructs
  like [mv], and so forth.


Subtopics

  [ACL2-count]
      A commonly used measure for justifying recursion

  [And]
      Conjunction

  [Booleanp]
      Recognizer for booleans

  [Case]
      Conditional based on if-then-else using [eql]

  [Case-match]
      Pattern matching or destructuring

  [Cond]
      Conditional based on if-then-else

  [Equal]
      True equality

  [Flet]
      Local binding of function symbols

  [Good-bye]
      Quit entirely out of Lisp

  [Identity]
      The identity function

  [If]
      If-then-else function

  [Iff]
      Logical ``if and only if''

  [Implies]
      Logical implication

  [Let]
      Binding of lexically scoped (local) variables

  [Let*]
      Binding of lexically scoped (local) variables

  [Mv]
      Returning a multiple value

  [Mv-let]
      Calling multi-valued ACL2 functions

  [Not]
      Logical negation

  [Null]
      Recognizer for the empty list

  [Or]
      Disjunction

  [Progn$]
      Execute a sequence of forms and return the value of the last one

  [Quote]
      Create a constant

  [Return-last]
      Return the last argument, perhaps with side effects

  [Xor]
      Logical ``exclusive or''")
 (BDD
  (ACL2)
  "Ordered binary decision diagrams with rewriting

  Note.  The ACL2 bdd capability has been essentially superseded by GL;
  see [gl].

  Ordered binary decision diagrams (OBDDs, often simply called BDDs)
  are a technique, originally published by Randy Bryant, for the
  efficient simplification of Boolean expressions.  In ACL2 we
  combine this technique with rewriting to handle arbitrary ACL2
  terms that can represent not only Boolean values, but non-Boolean
  values as well.  In particular, we provide a setting for deciding
  equality of bit vectors (lists of Boolean values).

  An introduction to BDDs for the automated reasoning community may be
  found in ``Introduction to the OBDD Algorithm for the ATP
  Community'' by J Moore, Journal of Automated Reasoning (1994), pp.
  33--45.  (This paper also appears as Technical Report #84 from
  Computational Logic, Inc.)

  Further information about BDDs in ACL2 can be found in the subtopics
  of this [documentation] section.  In particular, see
  [bdd-introduction] for a good starting place that provides a number
  of examples.

  See [hints] for a description of :bdd hints.  For quick reference,
  here is an example; but only the :vars part of the hint is
  required, as explained in the documentation for [hints].  The
  values shown are the defaults.

    (:vars nil :bdd-constructors (cons) :prove t :literal :all)

  We suggest that you next visit the documentation topic
  [bdd-introduction].


Subtopics

  [Bdd-algorithm]
      Summary of the BDD algorithm in ACL2

  [Bdd-introduction]
      Examples illustrating the use of BDDs in ACL2

  [If*]
      For conditional rewriting with BDDs

  [Obdd]
      Ordered binary decision diagrams with rewriting

  [Show-bdd]
      Inspect failed BDD proof attempts")
 (BDD-ALGORITHM
  (BDD)
  "Summary of the BDD algorithm in ACL2

  The BDD algorithm in ACL2 uses a combination of manipulation of IF
  terms and unconditional rewriting.  In this discussion we begin
  with some relevant mathematical theory.  This is followed by a
  description of how ACL2 does BDDs, including concluding discussions
  of soundness, completeness, and efficiency.

  We recommend that you read the other documentation about BDDs in ACL2
  before reading the rather technical material that follows.  See
  [bdd].

  Here is an outline of our presentation.  Readers who want a user
  perspective, without undue mathematical theory, may wish to skip to
  Part (B), referring to Part (A) only on occasion if necessary.

  (A) Mathematical Considerations

      (A1) BDD term order

      (A2) BDD-constructors and BDD terms, and their connection with
      aborting the BDD algorithm

      (A3) Canonical BDD terms

      (A4) A theorem stating the equivalence of provable and syntactic
      equality for canonical BDD terms

  (B) Algorithmic Considerations

      (B1) BDD rules (rules used by the rewriting portion of the ACL2 BDD
      algorithm)

      (B2) Terms ``known to be Boolean''

      (B3) An ``IF-lifting'' operation used by the algorithm, as well as an
      iterative version of that operation

      (B4) The ACL2 BDD algorithm

      (B5) Soundness and Completeness of the ACL2 BDD algorithm

      (B6) Efficiency considerations

  (A) Mathematical Considerations

  (A1) BDD term order

  Our BDD algorithm creates a total ``BDD term order'' on ACL2 terms,
  on the fly.  We use this order in our discussions below of
  IF-lifting and of canonical BDD terms, and in the algorithm's use
  of commutativity.  The particular order is unimportant, except that
  we guarantee (for purposes of commutative functions) that constants
  are smaller in this order than non-constants.

  (A2) BDD-constructors (assumed to be '(cons)) and BDD terms

  We take as given a list of function symbols that we call the
  ``BDD-constructors.'' By default, the only BDD-constructor is
  [cons], although it is legal to specify any list of function
  symbols as the BDD-constructors, either by using the
  [ACL2-defaults-table] (see [ACL2-defaults-table]) or by supplying a
  :BDD-CONSTRUCTORS hint (see [hints]).  Warning: this capability is
  largely untested and may produce undesirable results.  Henceforth,
  except when explicitly stated to the contrary, we assume that
  BDD-constructors is '(cons).

  Roughly speaking, a [bdd] term is the sort of [term] produced by our
  BDD algorithm, namely a tree with all [cons] nodes lying above all
  non-CONS nodes.  More formally, a [term] is said to be a [bdd] term
  if it contains no subterm of either of the following forms, where f
  is not CONS.

    (f ... (CONS ...) ...)

    (f ... 'x ...)  ; where (consp x) = t

  We will see that whenever the BDD algorithm attempts to create a
  [term] that is not a [bdd] term, it aborts instead.  Thus, whenever
  the algorithm completes without aborting, it creates a [bdd] term.

  (A3) Canonical BDD terms

  We can strengthen the notion of ``BDD term'' to a notion of
  ``canonical BDD term'' by imposing the following additional
  requirements, for every subterm of the form (IF x y z):

      (a) x is a variable, and it precedes (in the BDD term order) every
      variable occurring in y or z;

      (b) y and z are syntactically distinct; and,

      (c) it is not the case that y is t and z is nil.

  We claim that it follows easily from our description of the BDD
  algorithm that every term it creates is a canonical BDD term,
  assuming that the variables occurring in all such terms are treated
  by the algorithm as being Boolean (see (B2) below) and that the
  terms contain no function symbols other than IF and CONS.  Thus,
  under those assumptions the following theorem shows that the BDD
  algorithm never creates distinct terms that are provably equal, a
  property that is useful for completeness and efficiency (as we
  explain in (B5) and (B6) below).

  (A4) Provably equal canonical BDD terms are identical

  We believe that the following theorem and proof are routine
  extensions of a standard result and proof to terms that allow calls
  of CONS.

  Theorem.  Suppose that t1 and t2 are canonical BDD terms that contain
  no function symbols other than IF and CONS.  Also suppose that
  (EQUAL t1 t2) is a theorem.  Then t1 and t2 are syntactically
  identical.

  Proof of theorem: By induction on the total number of symbols
  occurring in these two terms.  First suppose that at least one term
  is a variable; without loss of generality let it be t1.  We must
  prove that t2 is syntactically the same as t1.  Now it is clearly
  consistent that (EQUAL t1 t2) is false if t2 is a call of CONS (to
  see this, simply let t1 be an value that is not a CONSP).
  Similarly, t2 cannot be a constant or a variable other than t1.
  The remaining possibility to rule out is that t2 is of the form (IF
  t3 t4 t5), since by assumption its function symbol must be IF or
  CONS and we have already handled the latter case.  Since t2 is
  canonical, we know that t3 is a variable.  Since (EQUAL t1 t2) is
  provable, i.e.,

    (EQUAL t1 (if t3 t4 t5))

  is provable, it follows that we may substitute either t or nil for t3
  into this equality to obtain two new provable equalities.  First,
  suppose that t1 and t3 are distinct variables.  Then these
  substitutions show that t1 is provably equal to both t4 and t5
  (since t3 does not occur in t4 or t5 by property (a) above, as t2
  is canonical), and hence t4 and t5 are provably equal to each
  other, which implies by the inductive hypothesis that they are the
  same term --- and this contradicts the assumption that t2 is
  canonical (property (b)).  Therefore t1 and t3 are the same
  variable, i.e., the equality displayed above is actually (EQUAL t1
  (if t1 t4 t5)).  Substituting t and then nil for t1 into this
  provable equality lets us prove (EQUAL t t4) and (EQUAL nil t5),
  which by the inductive hypothesis implies that t4 is
  (syntactically) the term t and t5 is nil.  That is, t2 is (IF t1 t
  nil), which contradicts the assumption that t2 is canonical
  (property (c)).

  Next, suppose that at least one term is a call of IF.  Our first
  observation is that the other term is also a call of IF.  For if
  the other is a call of CONS, then they cannot be provably equal,
  because the former has no function symbols other than IF and hence
  is Boolean when all its variables are assigned Boolean values.
  Also, if the other is a constant, then both branches of the IF term
  are provably equal to that constant and hence these branches are
  syntactically identical by the inductive hypothesis, contradicting
  property (b).  Hence, we may assume for this case that both terms
  are calls of IF; let us write them as follows.

    t0:  (IF t1 t2 t3)
    u0:  (IF u1 u2 u3)

  Note that t1 and u1 are variables, by property (a) of canonical BDD
  terms.  First we claim that t1 does not strictly precede u1 in the
  BDD term order.  For suppose t1 does strictly precede u1.  Then
  property (a) of canonical BDD terms guarantees that t1 does not
  occur in u0.  Hence, an argument much like one used above shows
  that u0 is provably equal to both t2 (substituting t for t1) and t3
  (substituting nil for t1), and hence t2 and t3 are provably equal.
  That implies that they are identical terms, by the inductive
  hypothesis, which then contradicts property (b) for t0.  Similarly,
  u1 does not strictly precede t1 in the BDD term order.  Therefore,
  t1 and u1 are the same variable.  By substituting t for this
  variable we see that t2 and u2 are provably equal, and hence they
  are equal by the inductive hypothesis.  Similarly, by substituting
  nil for t1 (and u1) we see that t3 and u3 are provably, hence
  syntactically, equal.

  We have covered all cases in which at least one term is a variable or
  at least one term is a call of IF.  If both terms are constants,
  then provable and syntactic equality are clearly equivalent.
  Finally, then, we may assume that one term is a call of CONS and
  the other is a constant or a call of CONS.  The constant case is
  similar to the CONS case if the constant is a CONSP, so we omit it;
  while if the constant is not a CONSP then it is not provably equal
  to a call of CONS; in fact it is provably not equal!

  So, we are left with a final case, in which canonical BDD terms (CONS
  t1 t2) and (CONS u1 u2) are provably equal, and we want to show
  that t1 and u1 are syntactically equal as are t2 and u2.  These
  conclusions are easy consequences of the inductive hypothesis,
  since the ACL2 axiom CONS-EQUAL (which you can inspect using :[pe])
  shows that equality of the given terms is equivalent to the
  conjunction of (EQUAL t1 t2) and (EQUAL u1 u2).  Q.E.D.

  (B) Algorithmic Considerations

  (B1) BDD rules

  A rule of class :[rewrite] (see [rule-classes]) is said to be a
  ``[bdd] rewrite rule'' if and only if it satisfies the following
  criteria.  (1) The rule is [enable]d.  (2) Its [equivalence]
  relation is [equal].  (3) It has no hypotheses.  (4) Its
  :[loop-stopper] field is nil, i.e., it is not a permutative rule.
  (5) All variables occurring in the rule occur in its left-hand side
  (i.e., there are no ``free variables''; see [rewrite]).  A rule of
  class :[definition] (see [rule-classes]) is said to be a ``[bdd]
  definition rule'' if it satisfies all the criteria above (except
  (4), which does not apply), and moreover the top function symbol of
  the left-hand side was not recursively (or mutually recursively)
  defined.  Technical point: Note that this additional criterion is
  independent of whether or not the indicated function symbol
  actually occurs in the right-hand side of the rule.

  Both BDD rewrite rules and BDD definition rules are said to be ``BDD
  rules.''

  (B2) Terms ''known to be Boolean''

  We apply the BDD algorithm in the context of a top-level goal to
  prove, namely, the goal at which the :BDD hint is attached.  As we
  run the BDD algorithm, we allow ourselves to say that a set of
  [term]s is ``known to be Boolean'' if we can verify that the goal
  is provable from the assumption that at least one of the terms is
  not Boolean.  Equivalently, we allow ourselves to say that a set of
  terms is ``known to be Boolean'' if we can verify that the original
  goal is provably equivalent to the assertion that if all terms in
  the set are Boolean, then the goal holds.  The notion ``known to be
  Boolean'' is conservative in the sense that there are generally
  sets of terms for which the above equivalent criteria hold and yet
  the sets of terms are not noted as as being ``known to be
  Boolean.'' However, ACL2 uses a number of tricks, including
  [type-set] reasoning and analysis of the structure of the top-level
  goal, to attempt to establish that a sufficiently inclusive set of
  terms is known to be Boolean.

  From a practical standpoint, the algorithm determines a set of terms
  known to be Boolean; we allow ourselves to say that each term in
  this set is ``known to be Boolean.'' The algorithm assumes that
  these terms are indeed Boolean, and can make use of that
  assumption.  For example, if t1 is known to be Boolean then the
  algorithm simplifies (IF t1 t nil) to t1; see (iv) in the
  discussion immediately below.

  (B3) IF-lifting and the IF-lifting-for-IF loop

  Suppose that one has a [term] of the form (f ... (IF test x y) ...),
  where f is a function symbol other than CONS.  Then we say that
  ``IF-lifting'' test ``from'' this term produces the following term,
  which is provably equal to the given term.

    (if test
        (f ... x ...)  ; resulting true branch
        (f ... y ...)) ; resulting false branch

  Here, we replace each argument of f of the form (IF test .. ..), for
  the same test, in the same way.  In this case we say that
  ``IF-lifting applies to'' the given term, ``yielding the test''
  test and with the ``resulting two branches'' displayed above.
  Whenever we apply IF-lifting, we do so for the available test that
  is least in the BDD term order (see (A1) above).

  We consider arguments v of f that are ``known to be Boolean'' (see
  above) to be replaced by (IF v t nil) for the purposes of
  IF-lifting, i.e., before IF-lifting is applied.

  There is one special case, however, for IF-lifting.  Suppose that the
  given term is of the form (IF v y z) where v is a variable and is
  the test to be lifted out (i.e., it is least in the BDD term order
  among the potential tests).  Moreover, suppose that neither y nor z
  is of the form (IF v W1 W2) for that same v.  Then IF-lifting does
  not apply to the given term.

  We may now describe the IF-lifting-for-IF loop, which applies to
  terms of the form (IF test tbr fbr) where the algorithm has already
  produced test, tbr, and fbr.  First, if test is nil then we return
  fbr, while if test is a non-nil constant or a call of CONS then we
  return tbr.  Otherwise, we see if IF-lifting applies.  If
  IF-lifting does not apply, then we return (IF test tbr fbr).
  Otherwise, we apply IF-lifting to obtain a term of the form (IF x y
  z), by lifting out the appropriate test.  Now we recursively apply
  the IF-lifting-for-IF loop to the term (IF x y z), unless any of
  the following special cases apply.

      (i) If y and z are the same term, then return y.

      (ii) Otherwise, if x and z are the same term, then replace z by nil
      before recursively applying IF-lifting-for-IF.

      (iii) Otherwise, if x and y are the same term and y is known to be
      Boolean, then replace y by t before recursively applying
      IF-lifting-for-IF.

      (iv) If z is nil and either x and y are the same term or x is ``known
      to be Boolean'' and y is t, then return x.

  NOTE: When a variable x is known to be Boolean, it is easy to see
  that the form (IF x t nil) is always reduced to x by this
  algorithm.

  (B4) The ACL2 BDD algorithm

  We are now ready to present the BDD algorithm for ACL2.  It is given
  an ACL2 [term], x, as well as an association list va that maps
  variables to terms, including all variables occurring in x.  We
  maintain the invariant that whenever a variable is mapped by va to
  a term, that term has already been constructed by the algorithm,
  except: initially va maps every variable occurring in the top-level
  term to itself.  The algorithm proceeds as follows.  We implicitly
  ordain that whenever the BDD algorithm attempts to create a [term]
  that is not a [bdd] term (as defined above in (A2)), it aborts
  instead.  Thus, whenever the algorithm completes without aborting,
  it creates a [bdd] term.

      If x is a variable, return the result of looking it up in va.

      If x is a constant, return x.

      If x is of the form (IF test tbr fbr), then first run the algorithm
      on test with the given va to obtain test'.  If test' is nil,
      then return the result fbr' of running the algorithm on fbr
      with the given va.  If test' is a constant other than nil, or
      is a call of CONS, then return the result tbr' of running the
      algorithm on tbr with the given va.  If tbr is identical to
      fbr, return tbr.  Otherwise, return the result of applying the
      IF-lifting-for-IF loop (described above) to the term (IF test'
      tbr' fbr').

      If x is of the form (IF* test tbr fbr), then compute the result
      exactly as though [if] were used rather than [if*], except that
      if test' is not a constant or a call of CONS (see paragraph
      above), then abort the BDD computation.  Informally, the tests
      of [if*] terms are expected to ``resolve.'' NOTE: This
      description shows how [if*] can be used to implement
      conditional rewriting in the BDD algorithm.

      If x is a LAMBDA expression ((LAMBDA vars body) . args) (which often
      corresponds to a [let] term; see [let]), then first form an
      alist va' by binding each v in vars to the result of running
      the algorithm on the corresponding member of args, with the
      current alist va.  Then, return the result of the algorithm on
      body in the alist va'.

      Otherwise, x is of the form (f x1 x2 ... xn), where f is a function
      symbol other than [if] or [if*].  In that case, let xi' be the
      result of running the algorithm on xi, for i from 1 to n, using
      the given alist va.  First there are a few special cases.  If f
      is [equal] then we return t if x1' is syntactically identical
      to x2' (where this test is very fast; see (B6) below); we
      return x1' if it is known to be Boolean and x2' is t; and
      similarly, we return x2' if it is known to be Boolean and x1'
      is t.  Next, if each xi' is a constant and the
      :[executable-counterpart] of f is enabled, then the result is
      obtained by computation.  Next, if f is [booleanp] and x1' is
      known to be Boolean, t is returned.  Otherwise, we proceed as
      follows, first possibly swapping the arguments if they are out
      of (the BDD term) order and if f is known to be commutative
      (see below).  If a BDD rewrite rule (as defined above) matches
      the term (f x1'... xn'), then the most recently stored such
      rule is applied.  If there is no such match and f is a
      BDD-constructor, then we return (f x1'... xn').  Otherwise, if
      a BDD definition rule matches this term, then the most recently
      stored such rule (which will usually be the original definition
      for most users) is applied.  If none of the above applies and
      neither does IF-lifting, then we return (f x1'... xn').
      Otherwise we apply IF-lifting to (f x1'... xn') to obtain a
      term (IF test tbr fbr); but we aren't done yet.  Rather, we run
      the BDD algorithm (using the same alist) on tbr and fbr to
      obtain terms tbr' and fbr', and we return (IF test tbr' fbr')
      unless tbr' is syntactically identical to fbr', in which case
      we return tbr'.

  When is it the case that, as said above, ``f is known to be
  commutative''?  This happens when an enabled rewrite rule is of the
  form (EQUAL (f X Y) (f Y X)).  Regarding swapping the arguments in
  that case: recall that we may assume very little about the BDD term
  order, essentially only that we swap the two arguments when the
  second is a constant and the first is not, for example, in (+ x 1).
  Other than that situation, one cannot expect to predict accurately
  when the arguments of commutative operators will be swapped.

  (B5) Soundness and Completeness of the ACL2 BDD algorithm

  Roughly speaking, ``soundness'' means that the BDD algorithm should
  give correct answers, and ``completeness'' means that it should be
  powerful enough to prove all true facts.  Let us make the soundness
  claim a little more precise, and then we'll address completeness
  under suitable hypotheses.

  Claim (Soundness).  If the ACL2 BDD algorithm runs to completion on
  an input term t0, then it produces a result that is provably equal
  to t0.

  We leave the proof of this claim to the reader.  The basic idea is
  simply to check that each step of the algorithm preserves the
  meaning of the term under the bindings in the given alist.

  Let us start our discussion of completeness by recalling the theorem
  proved above in (A4).

  Theorem.  Suppose that t1 and t2 are canonical BDD terms that contain
  no function symbols other than IF and CONS.  Also suppose that
  (EQUAL t1 t2) is a theorem.  Then t1 and t2 are syntactically
  identical.

  Below we show how this theorem implies the following completeness
  property of the ACL2 BDD algorithm.  We continue to assume that
  CONS is the only BDD-constructor.

  Claim (Completeness).  Suppose that t1 and t2 are provably equal
  terms, under the assumption that all their variables are known to
  be Boolean.  Assume further that under this same assumption,
  top-level runs of the ACL2 BDD algorithm on these terms return
  terms that contain only the function symbols IF and CONS.  Then the
  algorithm returns the same term for both t1 and t2, and the
  algorithm reduces (EQUAL t1 t2) to t.

  Why is this claim true?  First, notice that the second part of the
  conclusion follows immediately from the first, by definition of the
  algorithm.  Next, notice that the terms u1 and u2 obtained by
  running the algorithm on t1 and t2, respectively, are provably
  equal to t1 and t2, respectively, by the Soundness Claim.  It
  follows that u1 and u2 are provably equal to each other.  Since
  these terms contain no function symbols other than IF or CONS, by
  hypothesis, the Claim now follows from the Theorem above together
  with the following lemma.

  Lemma.  Suppose that the result of running the ACL2 BDD algorithm on
  a top-level term t0 is a term u0 that contains only the function
  symbols IF and CONS, where all variables of t0 are known to be
  Boolean.  Then u0 is a canonical BDD term.

  Proof: left to the reader.  Simply follow the definition of the
  algorithm, with a separate argument for the IF-lifting-for-IF loop.

  Finally, let us remark on the assumptions of the Completeness Claim
  above.  The assumption that all variables are known to be Boolean
  is often true; in fact, the system uses the forward-chaining rule
  boolean-listp-forward (you can see it using :[pe]) to try to
  establish this assumption, if your theorem has a form such as the
  following.

    (let ((x (list x0 x1 ...))
          (y (list y0 y1 ...)))
      (implies (and (boolean-listp x)
                    (boolean-listp y))
               ...))

  Moreover, the :BDD hint can be used to force the prover to abort if
  it cannot check that the indicated variables are known to be
  Boolean; see [hints].

  Finally, consider the effect in practice of the assumption that the
  terms resulting from application of the algorithm contain calls of
  IF and CONS only.  Typical use of BDDs in ACL2 takes place in a
  theory (see [theories]) in which all relevant non-recursive
  function symbols are enabled and all recursive function symbols
  possess enabled BDD rewrite rules that tell them how open up.  For
  example, such a rule may say how to expand on a given function
  call's argument that has the form (CONS a x), while another may say
  how to expand when that argument is nil).  (See for example the
  rules append-cons and append-nil in the documentation for [if*].)
  We leave it to future work to formulate a theorem that guarantees
  that the BDD algorithm produces terms containing calls only of IF
  and CONS assuming a suitably ``complete'' collection of rewrite
  rules.

  (B6) Efficiency considerations

  Following Bryant's algorithm, we use a graph representation of
  [term]s created by the BDD algorithm's computation.  This
  representation enjoys some important properties.

      (Time efficiency) The test for syntactic equality of BDD terms is
      very fast.

      (Space efficiency) Equal BDD data structures are stored identically
      in memory.

  Implementation note. The representation actually uses a sort of hash
  table for BDD terms that is implemented as an ACL2 1-dimensional
  array.  See [arrays].  In addition, we use a second such hash table
  to avoid recomputing the result of applying a function symbol to
  the result of running the algorithm on its arguments.  We believe
  that these uses of hash tables are standard.  They are also
  discussed in Moore's paper on BDDs; see [bdd] for the reference.")
 (BDD-INTRODUCTION
  (BDD)
  "Examples illustrating the use of BDDs in ACL2

  See [bdd] for a brief introduction to BDDs in ACL2 and for pointers
  to other documentation on BDDs in ACL2.  Here, we illustrate the
  use of BDDs in ACL2 by way of some examples.  For a further
  example, see [if*].

  Let us begin with a really simple example.  (We will explain the :bdd
  hint (:vars nil) below.)

    ACL2 !>(thm (equal (if a b c) (if (not a) c b))
                :hints ((\"Goal\" :bdd (:vars nil)))) ; Prove with BDDs

    [Note:  A hint was supplied for our processing of the goal above.
    Thanks!]

    But simplification with BDDs (7 nodes) reduces this to T, using the
    :definitions EQUAL and NOT.

    Q.E.D.

    Summary
    Form:  ( THM ...)
    Rules: ((:DEFINITION EQUAL) (:DEFINITION NOT))
    Warnings:  None
    Time:  0.18 seconds (prove: 0.05, print: 0.02, other: 0.12)

    Proof succeeded.
    ACL2 !>

  The :bdd hint (:vars nil) indicates that BDDs are to be used on the
  indicated goal, and that any so-called ``variable ordering'' may be
  used: ACL2 may use a convenient order that is far from optimal.  It
  is beyond the scope of the present documentation to address the
  issue of how the user may choose good variable orderings.  Someday
  our implementation of BDDs may be improved to include
  heuristically-chosen variable orderings rather than rather random
  ones.

  Here is a more interesting example.

    (defun v-not (x)
    ; Complement every element of a list of Booleans.
      (if (consp x)
          (cons (not (car x)) (v-not (cdr x)))
        nil))

    ; Now we prove a rewrite rule that explains how to open up v-not on
    ; a consp.
    (defthm v-not-cons
      (equal (v-not (cons x y))
             (cons (not x) (v-not y))))

    ; Finally, we prove for 7-bit lists that v-not is self-inverting.
    (thm
     (let ((x (list x0 x1 x2 x3 x4 x5 x6)))
       (implies (boolean-listp x)
                (equal (v-not (v-not x)) x)))
     :hints ((\"Goal\" :bdd
                     ;; Note that this time we specify a variable order.
                     (:vars (x0 x1 x2 x3 x4 x5 x6)))))

  It turns out that the variable order doesn't seem to matter in this
  example; using several orders we found that 30 nodes were created,
  and the proof time was about 1/10 of a second on a (somewhat
  enhanced) Sparc 2.  The same proof took about a minute and a half
  without any :bdd hint!  This observation is a bit misleading
  perhaps, since the theorem for arbitrary x,

    (thm
     (implies (boolean-listp x)
              (equal (v-not (v-not x)) x)))

  only takes about 1.5 times as long as the :bdd proof for 7 bits,
  above!  Nevertheless, BDDs can be very useful in reducing proof
  time, especially when there is no regular structure to facilitate
  proof by induction, or when the induction scheme is so complicated
  to construct that significant user effort is required to get the
  proof by induction to go through.

  Finally, consider the preceding example, with a :bdd hint of (say)
  (:vars nil), but with the rewrite rule v-not-cons above disabled.
  In that case, the proof fails, as we see below.  That is because
  the BDD algorithm in ACL2 uses hypothesis-free :[rewrite] rules,
  :[executable-counterpart]s, and nonrecursive definitions, but it
  does not use recursive definitions.

  Notice that when we issue the (show-bdd) command, the system's
  response clearly shows that we need a rewrite rule for simplifying
  terms of the form (v-not (cons ...)).

    ACL2 !>(thm
            (let ((x (list x0 x1 x2 x3 x4 x5 x6)))
              (implies (boolean-listp x)
                       (equal (v-not (v-not x)) x)))
            :hints ((\"Goal\" :bdd (:vars nil)
                     :in-theory (disable v-not-cons))))

    [Note:  A hint was supplied for our processing of the goal above.
    Thanks!]

    ACL2 Error in ( THM ...):  Attempted to create V-NOT node during BDD
    processing with an argument that is a call of a bdd-constructor,
    which would produce a non-BDD term (as defined in :DOC
    bdd-algorithm).  See :DOC show-bdd.

    Summary
    Form:  ( THM ...)
    Rules: NIL
    Warnings:  None
    Time:  0.58 seconds (prove: 0.13, print: 0.00, other: 0.45)

    ******** FAILED ********  See :DOC failure  ******** FAILED ********
    ACL2 !>(show-bdd)

    BDD computation on Goal yielded 17 nodes.
    ------------------------------

    BDD computation was aborted on Goal, and hence there is no
    falsifying assignment that can be constructed.  Here is a backtrace
    of calls, starting with the top-level call and ending with the one
    that led to the abort.  See :DOC show-bdd.

    (LET ((X (LIST X0 X1 X2 X3 X4 X5 ...)))
         (IMPLIES (BOOLEAN-LISTP X)
                  (EQUAL (V-NOT (V-NOT X)) X)))
      alist: ((X6 X6) (X5 X5) (X4 X4) (X3 X3) (X2 X2) (X1 X1) (X0 X0))

    (EQUAL (V-NOT (V-NOT X)) X)
      alist: ((X (LIST X0 X1 X2 X3 X4 X5 ...)))

    (V-NOT (V-NOT X))
      alist: ((X (LIST X0 X1 X2 X3 X4 X5 ...)))

    (V-NOT X)
      alist: ((X (LIST X0 X1 X2 X3 X4 X5 ...)))
    ACL2 !>

  The term that has caused the BDD algorithm to abort is thus (V-NOT
  X), where X has the value (LIST X0 X1 X2 X3 X4 X5 ...), i.e., (CONS
  X0 (LIST X1 X2 X3 X4 X5 ...)).  Thus, we see the utility of
  introducing a rewrite rule to simplify terms of the form (V-NOT
  (CONS ...)).  The moral of this story is that if you get an error
  of the sort shown above, you may find it useful to execute the
  command (show-bdd) and use the result as advice that suggests the
  left hand side of a rewrite rule.

  Here is another sort of failed proof.  In this version we have
  omitted the hypothesis that the input is a bit vector.  Below we
  use show-bdd to see what went wrong, and use the resulting
  information to construct a counterexample.  This failed proof
  corresponds to a slightly modified input theorem, in which x is
  bound to the 4-element list (list x0 x1 x2 x3).

    ACL2 !>(thm
            (let ((x (list x0 x1 x2 x3)))
              (equal (v-not (v-not x)) x))
            :hints ((\"Goal\" :bdd
                     ;; This time we do not specify a variable order.
                     (:vars nil))))

    [Note:  A hint was supplied for our processing of the goal above.
    Thanks!]

    ACL2 Error in ( THM ...):  The :BDD hint for the current goal has
    successfully simplified this goal, but has failed to prove it.
    Consider using (SHOW-BDD) to suggest a counterexample; see :DOC
    show-bdd.

    Summary
    Form:  ( THM ...)
    Rules: NIL
    Warnings:  None
    Time:  0.18 seconds (prove: 0.07, print: 0.00, other: 0.12)

    ******** FAILED ********  See :DOC failure  ******** FAILED ********
    ACL2 !>(show-bdd)

    BDD computation on Goal yielded 73 nodes.
    ------------------------------

    Falsifying constraints:
    ((X0 \"Some non-nil value\")
     (X1 \"Some non-nil value\")
     (X2 \"Some non-nil value\")
     (X3 \"Some non-nil value\")
     ((EQUAL 'T X0) T)
     ((EQUAL 'T X1) T)
     ((EQUAL 'T X2) T)
     ((EQUAL 'T X3) NIL))

    ------------------------------

    Term obtained from BDD computation on Goal:

    (IF X0
        (IF X1
            (IF X2 (IF X3 (IF # # #) (IF X3 # #))
                (IF X2 'NIL (IF X3 # #)))
            (IF X1 'NIL
                (IF X2 (IF X3 # #) (IF X2 # #))))
        (IF X0 'NIL
            (IF X1 (IF X2 (IF X3 # #) (IF X2 # #))
                (IF X1 'NIL (IF X2 # #)))))

    ACL2 Query (:SHOW-BDD):  Print the term in full?  (N, Y, W or ?):
    n ; I've seen enough.  The assignment shown above suggests
      ; (though not conclusively) that if we bind x3 to a non-nil
      ; value other than T, and bind x0, x1, and x2 to t, then we
      ; this may give us a counterexample.
    ACL2 !>(let ((x0 t) (x1 t) (x2 t) (x3 7))
             (let ((x (list x0 x1 x2 x3)))
               ;; Let's use LIST instead of EQUAL to see how the two
               ;; lists differ.
               (list (v-not (v-not x)) x)))
    ((T T T T) (T T T 7))
    ACL2 !>

  See [if*] for another example.")
 (BIBLIOGRAPHY
  (ABOUT-ACL2)
  "Reports about ACL2

  The ACL2 home page includes a {list of notes and reports about ACL2 |
  http://www.cs.utexas.edu/users/moore/publications/acl2-papers.html}.")
 (BINARY-*
  (* ACL2-BUILT-INS)
  "Multiplication function

  Completion Axiom (completion-of-*):

    (equal (binary-* x y)
           (if (acl2-numberp x)
               (if (acl2-numberp y)
                   (binary-* x y)
                 0)
             0))

  [Guard] for (binary-* x y):

    (and (acl2-numberp x) (acl2-numberp y))

  Notice that like all arithmetic functions, binary-* treats
  non-numeric inputs as 0.

  Calls of the macro [*] expand to calls of binary-*; see [*].")
 (BINARY-+
  (+ ACL2-BUILT-INS)
  "Addition function

  Completion Axiom (completion-of-+):

    (equal (binary-+ x y)
           (if (acl2-numberp x)
               (if (acl2-numberp y)
                   (binary-+ x y)
                 x)
             (if (acl2-numberp y)
                 y
               0)))

  [Guard] for (binary-+ x y):

    (and (acl2-numberp x) (acl2-numberp y))

  Notice that like all arithmetic functions, binary-+ treats
  non-numeric inputs as 0. Thus, the following are theorems.

    (thm (equal (+ (fix x) y) (+ x y)))
    (thm (equal (+ x (fix y)) (+ x y)))

  Calls of the macro [+] expand to calls of binary-+; see [+].")
 (BINARY-APPEND
  (APPEND ACL2-BUILT-INS)
  "[concatenate] two lists

  This binary function implements [append], which is a macro in ACL2.
  See [append]

  The [guard] for binary-append requires the first argument to be a
  [true-listp].

  Function: <binary-append>

    (defun binary-append (x y)
           (declare (xargs :guard (true-listp x)))
           (cond ((endp x) y)
                 (t (cons (car x)
                          (binary-append (cdr x) y)))))")
 (BIND-FREE
  (REWRITE LINEAR DEFINITION)
  "To bind free variables of a rewrite, definition, or linear rule

    Examples:
    (IMPLIES (AND (RATIONALP LHS)
                  (RATIONALP RHS)
                  (BIND-FREE (FIND-MATCH-IN-PLUS-NESTS LHS RHS) (X)))
             (EQUAL (EQUAL LHS RHS)
                    (EQUAL (+ (- X) LHS) (+ (- X) RHS))))

    (IMPLIES (AND (BIND-FREE
                    (FIND-RATIONAL-MATCH-IN-TIMES-NESTS LHS RHS MFC STATE)
                    (X))
                  (RATIONALP X)
                  (CASE-SPLIT (NOT (EQUAL X 0))))
             (EQUAL (< LHS RHS)
                    (IF (< 0 X)
                        (< (* (/ X) LHS) (* (/ X) RHS))
                       (< (* (/ X) RHS) (* (/ X) LHS)))))

  General Forms:

    (BIND-FREE term var-list)
    (BIND-FREE term t)
    (BIND-FREE term)

  A rule which uses a bind-free hypothesis has similarities to both a
  rule which uses a [syntaxp] hypothesis and to a :[meta] rule.
  Bind-free is like [syntaxp], in that it logically always returns t
  but may affect the application of a :[rewrite], :[definition], or
  :[linear] rule when it is called at the top-level of a hypothesis.
  It is like a :[meta] rule, in that it allows the user to perform
  transformations of terms under programmatic control.

  Note that a bind-free hypothesis does not, in general, deal with the
  meaning or semantics or values of the terms, but rather with their
  syntactic forms.  Before attempting to write a rule which uses
  bind-free, the user should be familiar with [syntaxp] and the
  internal form that ACL2 uses for terms.  This internal form is
  similar to what the user sees, but there are subtle and important
  differences.  [Trans] can be used to view this internal form.

  Just as for a [syntaxp] hypothesis, there are two basic types of
  bind-free hypotheses.  The simpler type of bind-free hypothesis may
  be used as the nth hypothesis in a :[rewrite], :[definition], or
  :[linear] rule whose :[corollary] is (implies (and hyp1 ... hypn
  ... hypk) (equiv lhs rhs)) provided term is a term, term contains
  at least one variable, and every variable occurring freely in term
  occurs freely in lhs or in some hypi, i<n.  In addition, term must
  not use any stobjs.  Later below we will describe the second type,
  an extended bind-free hypothesis, which is similar except that it
  may use [state] and [mfc].  Whether simple or extended, a bind-free
  hypothesis may return an alist that binds free variables, as
  explained below, or it may return a list of such alists.  We focus
  on the first of these cases: return of a single binding alist.  We
  conclude our discussion with a section that covers the other case:
  return of a list of alists.

  We begin our description of bind-free by examining the first example
  above in some detail.

  We wish to write a rule which will cancel ``like'' addends from both
  sides of an equality.  Clearly, one could write a series of rules
  such as

    (DEFTHM THE-HARD-WAY-2-1
       (EQUAL (EQUAL (+ A X B)
                     (+ X C))
              (EQUAL (+ A B)
                     (FIX C))))

  with one rule for each combination of positions the matching addends
  might be found in (if one knew before-hand the maximum number of
  addends that would appear in a sum).  But there is a better way.
  (In what follows, we assume the presence of an appropriate set of
  rules for simplifying sums.)

  Consider the following definitions and theorem:

    (DEFUN INTERSECTION-EQUAL (X Y)
      (COND ((ENDP X)
             NIL)
            ((MEMBER-EQUAL (CAR X) Y)
             (CONS (CAR X) (INTERSECTION-EQUAL (CDR X) Y)))
            (T
             (INTERSECTION-EQUAL (CDR X) Y))))

    (DEFUN PLUS-LEAVES (TERM)
      (IF (EQ (FN-SYMB TERM) 'BINARY-+)
          (CONS (FARGN TERM 1)
                (PLUS-LEAVES (FARGN TERM 2)))
        (LIST TERM)))

    (DEFUN FIND-MATCH-IN-PLUS-NESTS (LHS RHS)
      (IF (AND (EQ (FN-SYMB LHS) 'BINARY-+)
               (EQ (FN-SYMB RHS) 'BINARY-+))
          (LET ((COMMON-ADDENDS (INTERSECTION-EQUAL (PLUS-LEAVES LHS)
                                                    (PLUS-LEAVES RHS))))
            (IF COMMON-ADDENDS
                (LIST (CONS 'X (CAR COMMON-ADDENDS)))
              NIL))
        NIL))

    (DEFTHM CANCEL-MATCHING-ADDENDS-EQUAL
      (IMPLIES (AND (RATIONALP LHS)
                    (RATIONALP RHS)
                    (BIND-FREE (FIND-MATCH-IN-PLUS-NESTS LHS RHS) (X)))
               (EQUAL (EQUAL LHS RHS)
                      (EQUAL (+ (- X) LHS) (+ (- X) RHS)))))

  How is this rule applied to the following term?

    (equal (+ 3 (expt a n) (foo a c))
           (+ (bar b) (expt a n)))

  As mentioned above, the internal form of an ACL2 term is not always
  what one sees printed out by ACL2.  In this case, by using :[trans]
  one can see that the term is stored internally as

    (equal (binary-+ '3
                     (binary-+ (expt a n) (foo a c)))
           (binary-+ (bar b) (expt a n))).

  When ACL2 attempts to apply cancel-matching-addends-equal to the term
  under discussion, it first forms a substitution that instantiates
  the left-hand side of the conclusion so that it is identical to the
  target term.  This substitution is kept track of by the
  substitution alist:

    ((LHS . (binary-+ '3
                       (binary-+ (expt a n) (foo a c))))
     (RHS . (binary-+ (bar b) (expt a n)))).

  ACL2 then attempts to relieve the hypotheses in the order they were
  given.  Ordinarily this means that we instantiate each hypothesis
  with our substitution and then attempt to rewrite the resulting
  instance to true.  Thus, in order to relieve the first hypothesis,
  we rewrite:

    (RATIONALP (binary-+ '3
                          (binary-+ (expt a n) (foo a c)))).

  Let us assume that the first two hypotheses rewrite to t.  How do we
  relieve the bind-free hypothesis?  Just as for a [syntaxp]
  hypothesis, ACL2 evaluates (find-match-in-plus-nests lhs rhs) in an
  environment where lhs and rhs are instantiated as determined by the
  substitution.  In this case we evaluate

    (FIND-MATCH-IN-PLUS-NESTS '(binary-+ '3
                                          (binary-+ (expt a n) (foo a c)))
                              '(binary-+ (bar b) (expt a n))).

  Observe that, just as in the case of a [syntaxp] hypothesis, we
  substitute the quotation of the variables bindings into the term to
  be evaluated.  See [syntaxp] for the reasons for this.  The result
  of this evaluation, ((X . (EXPT A N))), is then used to extend the
  substitution alist:

    ((X . (EXPT A N))
     (LHS . (binary-+ '3
                       (binary-+ (expt a n) (foo a c))))
     (RHS . (binary-+ (bar b) (expt a n)))),

  and this extended substitution determines
  cancel-matching-addends-equal's result:

    (EQUAL (+ (- X) LHS) (+ (- X) RHS))
    ==>
    (EQUAL (+ (- (EXPT A N)) 3 (EXPT A N) (FOO A C))
           (+ (- (EXPT A N)) (BAR B) (EXPT A N))).

  Question: What is the internal form of this result?
  Hint: Use :[trans].

  When this rule fires, it adds the negation of a common term to both
  sides of the equality by selecting a binding for the otherwise-free
  variable x, under programmatic control.  Note that other mechanisms
  such as the binding of [free-variables] may also extend the
  substitution alist.

  Just as for a [syntaxp] test, a bind-free form signals failure by
  returning nil.  However, while a [syntaxp] test signals success by
  returning true, a bind-free form signals success by returning an
  alist which is used to extend the current substitution alist.
  Because of this use of the alist, there are several restrictions on
  it --- in particular the alist must only bind variables, these
  variables must not be already bound by the substitution alist, and
  the variables must be bound to ACL2 terms.  If term returns an
  alist and the alist meets these restrictions, we append the alist
  to the substitution alist and use the result as the new current
  substitution alist.  This new current substitution alist is then
  used when we attempt to relieve the next hypothesis or, if there
  are no more, instantiate the right hand side of the rule.

  There is also a second, optional, var-list argument to a bind-free
  hypothesis.  If provided, it must be either t, nil, or a non-empty
  list of variables.  If it is not provided, it defaults to t; and it
  is also treated as t if the value provided is nil.  If it is a
  non-empty list of variables, this second argument is used to place
  a further restriction on the possible values of the alist to be
  returned by term: any variables bound in the alist must be present
  in that list of variables.  We strongly recommend the use of this
  list of variables, as that list is considered to contribute to the
  list of variables in the hypotheses of a linear rule; see [linear],
  in particular condition (b) mentioned there regarding a requirement
  that maximal terms and hypotheses must suffice for instantiating
  all the variables in the conclusion.  If var-list is t (either
  explicitly or implicitly, as described above), then that condition
  is considered to be met trivially; this could prevent ACL2 from
  rejecting ineffective linear rules.

  An extended bind-free hypothesis is similar to the simple type
  described above, but it uses two additional variables, mfc and
  state, which must not be bound by the left hand side or an earlier
  hypothesis of the rule.  They must be the last two variables
  mentioned by term: first mfc, then state.  These two variables give
  access to the functions mfc-xxx; see [extended-metafunctions].  As
  described there, mfc is bound to the so-called metafunction-context
  and state to ACL2's [state].  See [bind-free-examples] for examples
  of the use of these extended bind-free hypotheses.

  SECTION: Returning a list of alists.

  As promised above, we conclude with a discussion of the case that
  evaluation of the bind-free term produces a list of alists, x,
  rather than a single alist.  In this case each member b of x is
  considered in turn, starting with the first and proceeding through
  the list.  Each such b is handled exactly as discussed above, as
  though it were the result of evaluating the bind-free term.  Thus,
  each b extends the current variable binding alist, and all
  remaining hypotheses are then relieved, as though b had been the
  value obtained by evaluating the bind-free term.  As soon as one
  such b leads to successful relieving of all remaining hypotheses,
  the process of relieving hypotheses concludes, so no further
  members of x are considered.

  We illustrate with a simple pedagogical example.  First introduce
  functions p1 and p2 such that a rewrite rule specifies that p2
  implies p1, but with a free variable.

    (defstub p1 (x) t)
    (defstub p2 (x y) t)

    (defaxiom p2-implies-p1
      (implies (p2 x y)
               (p1 x)))

  If we add the following axiom, then (p1 x) follows logically for all
  x.

    (defaxiom p2-instance
      (p2 v (cons v 4)))

  Unfortunately, evaluation of (thm (p1 a)) fails, because ACL2 fails
  to bind the free variable y in order to apply the rule p2-instance.

  Let's define a function that produces a list of alists, each binding
  the variable y.  Of course, we know that only the middle one below
  is necessary in this simple example.  In more complex examples, one
  might use heuristics to construct such a list of alists.

    (defun my-alists (x)
      (list (list (cons 'y (fcons-term* 'cons x ''3)))
            (list (cons 'y (fcons-term* 'cons x ''4)))
            (list (cons 'y (fcons-term* 'cons x ''5)))))

  The following rewrite rule uses bind-free to return a list of
  candidate alists binding y.

    (defthm p2-implies-p1-better
      (implies (and (bind-free (my-alists x)
                               (y)) ; the second argument, (y), is optional
                    (p2 x y))
               (p1 x)))

  Now the proof succeeds for (thm (p1 a)).  Why?  When ACL2 applies the
  rewrite rule p2-implies-p1-better, it evaluates my-alists, as we
  can see from the following [trace], to bind y in three different
  alists.

    ACL2 !>(thm (p1 a))
    1> (ACL2_*1*_ACL2::MY-ALISTS A)
    <1 (ACL2_*1*_ACL2::MY-ALISTS (((Y CONS A '3))
                                  ((Y CONS A '4))
                                  ((Y CONS A '5))))

    Q.E.D.

  The first alist, binding y to (cons a '3), fails to allow the
  hypothesis (p2 x y) to be proved.  But the next binding of y, to
  (cons a '4), succeeds: then the current binding alist is ((x . a)
  (y . (cons a '4))), for which the hypothesis (p2 x y) rewrites to
  true using the rewrite rule p2-instance.


Subtopics

  [Bind-free-examples]
      Examples pertaining to [bind-free] hypotheses")
 (BIND-FREE-EXAMPLES
  (BIND-FREE)
  "Examples pertaining to [bind-free] hypotheses

  See [bind-free] for a basic discussion of the use of bind-free to
  control rewriting.

  Note that the examples below all illustrate the common case in which
  a bind-free hypothesis generates a binding alist.  See [bind-free],
  in particular the final section, for a discussion of the case that
  instead a list of binding alists is generated.

  We give examples of the use of [bind-free] hypotheses from the
  perspective of a user interested in reasoning about arithmetic, but
  it should be clear that [bind-free] can be used for many other
  purposes also.

  EXAMPLE 1: Cancel a common factor.

    (defun bind-divisor (a b)

    ; If a and b are polynomials with a common factor c, we return a
    ; binding for x.  We could imagine writing get-factor to compute the
    ; gcd, or simply to return a single non-invertible factor.

      (let ((c (get-factor a b)))
        (and c (list (cons 'x c)))))

    (defthm cancel-factor
      ;; We use case-split here to ensure that, once we have selected
      ;; a binding for x, the rest of the hypotheses will be relieved.
      (implies (and (acl2-numberp a)
                    (acl2-numberp b)
                    (bind-free (bind-divisor a b) (x))
                    (case-split (not (equal x 0)))
                    (case-split (acl2-numberp x)))
               (iff (equal a b)
                    (equal (/ a x) (/ b x)))))

  EXAMPLE 2: Pull integer summand out of floor.  Note: This example has
  an extended [bind-free] hypothesis, which uses the term
  (find-int-in-sum sum mfc state).

    (defun fl (x)
      ;; This function is defined, and used, in the IHS books.
      (floor x 1))

    (defun int-binding (term mfc state)
      ;; The call to mfc-ts returns the encoded type of term. ;
      ;; Thus, we are asking if term is known by type reasoning to ;
      ;; be an integer. ;
      (declare (xargs :stobjs (state) :mode :program))
      (if (ts-subsetp (mfc-ts term mfc state)
                      *ts-integer*)
          (list (cons 'int term))
        nil))

    (defun find-int-in-sum (sum mfc state)
      (declare (xargs :stobjs (state) :mode :program))
      (if (and (nvariablep sum)
               (not (fquotep sum))
               (eq (ffn-symb sum) 'binary-+))
          (or (int-binding (fargn sum 1) mfc state)
              (find-int-in-sum (fargn sum 2) mfc state))
        (int-binding sum mfc state)))

    ; Some additional work is required to prove the following.  So for
    ; purposes of illustration, we wrap skip-proofs around the defthm.

    (skip-proofs
     (defthm cancel-fl-int
      ;; The use of case-split is probably not needed, since we should
      ;; know that int is an integer by the way we selected it.  But this
      ;; is safer.
       (implies (and (acl2-numberp sum)
                     (bind-free (find-int-in-sum sum mfc state) (int))
                     (case-split (integerp int)))
                (equal (fl sum)
                       (+ int (fl (- sum int)))))
       :rule-classes ((:rewrite :match-free :all)))
    )

    ; Arithmetic libraries will have this sort of lemma.
    (defthm hack (equal (+ (- x) x y) (fix y)))

    (in-theory (disable fl))

    (thm (implies (and (integerp x) (acl2-numberp y))
                  (equal (fl (+ x y)) (+ x (fl y)))))

  EXAMPLE 3: Simplify terms such as (equal (+ a (* a b)) 0)

    (defun factors (product)
      ;; We return a list of all the factors of product.  We do not
      ;; require that product actually be a product.
      (if (eq (fn-symb product) 'BINARY-*)
          (cons (fargn product 1)
                (factors (fargn product 2)))
        (list product)))

    (defun make-product (factors)
      ;; Factors is assumed to be a list of ACL2 terms.  We return an
      ;; ACL2 term which is the product of all the elements of the
      ;; list factors.
      (cond ((atom factors)
             ''1)
            ((null (cdr factors))
             (car factors))
            ((null (cddr factors))
             (list 'BINARY-* (car factors) (cadr factors)))
            (t
             (list 'BINARY-* (car factors) (make-product (cdr factors))))))

    (defun quotient (common-factors sum)
      ;; Common-factors is a list of ACL2 terms.   Sum is an ACL2 term each
      ;; of whose addends have common-factors as factors.  We return
      ;; (/ sum (make-product common-factors)).
      (if (eq (fn-symb sum) 'BINARY-+)
          (let ((first (make-product (set-difference-equal (factors (fargn sum 1))
                                                           common-factors))))
            (list 'BINARY-+ first (quotient common-factors (fargn sum 2))))
        (make-product (set-difference-equal (factors sum)
                                            common-factors))))

    (defun intersection-equal (x y)
      (cond ((endp x)
             nil)
            ((member-equal (car x) y)
             (cons (car x) (intersection-equal (cdr x) y)))
            (t
             (intersection-equal (cdr x) y))))

    (defun common-factors (factors sum)
      ;; Factors is a list of the factors common to all of the addends
      ;; examined so far.  On entry, factors is a list of the factors in
      ;; the first addend of the original sum, and sum is the rest of the
      ;; addends.  We sweep through sum, trying to find a set of factors
      ;; common to all the addends of sum.
      (declare (xargs :measure (acl2-count sum)))
      (cond ((null factors)
             nil)
            ((eq (fn-symb sum) 'BINARY-+)
             (common-factors (intersection-equal factors (factors (fargn sum 1)))
                             (fargn sum 2)))
            (t
             (intersection-equal factors (factors sum)))))

    (defun simplify-terms-such-as-a+ab-rel-0-fn (sum)
      ;; If we can find a set of factors common to all the addends of sum,
      ;; we return an alist binding common to the product of these common
      ;; factors and binding quotient to (/ sum common).
      (if (eq (fn-symb sum) 'BINARY-+)
          (let ((common-factors (common-factors (factors (fargn sum 1))
                                                (fargn sum 2))))
            (if common-factors
                (let ((common (make-product common-factors))
                      (quotient (quotient common-factors sum)))
                  (list (cons 'common common)
                        (cons 'quotient quotient)))
              nil))
        nil))

    (defthm simplify-terms-such-as-a+ab-=-0
      (implies (and (bind-free
                     (simplify-terms-such-as-a+ab-rel-0-fn sum)
                     (common quotient))
                    (case-split (acl2-numberp common))
                    (case-split (acl2-numberp quotient))
                    (case-split (equal sum
                                       (* common quotient))))
               (equal (equal sum 0)
                      (or (equal common 0)
                          (equal quotient 0)))))

    (thm (equal (equal (+ u (* u v)) 0)
          (or (equal u 0) (equal v -1))))")
 (BITP
  (NUMBERS ACL2-BUILT-INS)
  "A recognizer for the set of bits, {0,1}

  Bitp returns t if and only its argument is 0 or 1, and nil otherwise.

  Note that this is a predicate form of the [type-spec] declaration
  (TYPE BIT b).

  Function: <bitp>

    (defun bitp (x)
           (declare (xargs :guard t))
           (or (eql x 0) (eql x 1)))")
 (BODY (POINTERS)
       "See [system-utilities].")
 (BOOK-COMPILED-FILE
  (BOOKS-REFERENCE)
  "Creating and loading of compiled and expansion files for [books]

  An effect of [compilation] is to speed up the execution of the
  functions defined in a book.  Compilation can also remove tail
  recursion, thus avoiding stack overflows.  The presence of compiled
  code for the functions in the book should not otherwise affect the
  performance of ACL2.  See [guard] for a discussion; also see
  [compilation].

  By default, the [certify-book] command compiles the book that it
  certifies.  see [certify-book] for how to control this behavior.

  By default, the [include-book] command loads the compiled file for
  the book.  The details of how this loading works are subtle, and do
  not need to be understood by most users.  The ACL2 source code
  contains an ``Essay on Hash Table Support for Compilation'' that
  explains such details for those interested.  All that users should
  generally need to know about this is that the compiled file is
  always the result of compiling a so-called ``expansion file'',
  which contains certain additional code besides the book itself.
  The relevance to users of the expansion file is that it can be
  loaded if the compiled file is missing (except when
  :load-compiled-file t is specified by the [include-book] form), and
  its existence is required in order for [include-book] to create a
  book's compiled file, as described below.

  Most users can skip the remainder of this documentation topic, which
  addresses the uncommon activity of using [include-book] to compile
  books.

  Include-book can be made to compile a book by supplying its keyword
  argument :load-compiled-file the value :comp.  However, a compiled
  file can only be produced if there is already an expansion file
  that is at least as recent as the book's [certificate].  Such a
  file, whose name happens to be the result of concatenating the
  string \"@expansion.lsp\" to the book name (without the \".lisp\"
  suffix), is created by [certify-book] when state global variable
  'save-expansion-file has a non-nil value.  That will be the case if
  ACL2 started up when environment variable ACL2_SAVE_EXPANSION was t
  (or any value that is not the empty string and whose
  [string-upcase] is not \"NIL\"), until the time (if any) that
  'save-expansion-file is assigned a different value by the user.  In
  most respects, the :comp setting is treated exactly the same as
  :warn; but after all events in the book are processed, the
  expansion file is compiled if a compiled file was not loaded, after
  which the resulting compiled file is loaded.

  One can thus, for example, compile books for several different host
  Lisps --- useful when installing ACL2 executables at the same site
  that are built on different host Lisps.  A convenient way to do
  this in an environment that provides Gnu `make' is to certify the
  community books using the shell command ``make regression'' in the
  acl2-sources/ directory, after setting environment variable
  ACL2_SAVE_EXPANSION to t, and then moving to the books directory
  and executing the appropriate `make' commands to compile the books
  (targets fasl, o, and so on, according to the compiled file
  extension for the host Lisp).

  We conclude by saying more about the :load-compiled-file argument of
  [include-book].  We assume that [state] global 'compiler-enabled
  has a non-nil value; otherwise :load-compiled-file is always
  treated as nil.

  We do not consider raw mode below (see [set-raw-mode]), which
  presents a special case: ACL2 will attempt to load the book itself
  whenever it would otherwise load the expansion or compiled file,
  but cannot (either because the :load-compiled-file argument is nil,
  or for each of the expansion and compiled files, either it does not
  exist or it is out of date with respect to the .cert file).

  The :load-compiled-file argument is not recursive: calls of
  include-book that are inside the book supplied to include-book use
  their own :load-compiled-file arguments.  However, those subsidiary
  include-book calls can nevertheless be sensitive to the
  :load-compiled-file arguments of enclosing include-book calls, as
  follows.  If :load-compiled-file has value t, then every subsidiary
  include-book is required to load a compiled file.  Moreover, if a
  book's compiled file or expansion file is loaded in raw Lisp, then
  an attempt will be made to load the compiled file or expansion file
  for any [include-book] form encountered during that load.  If that
  attempt fails, then that load immediately aborts, as does its
  parent load, and so on up the chain.  If, when going up the chain,
  an [include-book] is aborted for which keyword argument
  :load-compiled-file has value t, then an error occurs.

  When loading a book's compiled file or expansion file, FILE, it is
  possible to encounter an [include-book] form for a book that has no
  suitable compiled file or expansion file.  In that case, the load
  of FILE is aborted at that point.  Similarly, the load of FILE is
  aborted in the case that this include-book form has a suitable
  compiled file or expansion file whose load is itself aborted.
  Thus, whenever any include-book aborts, so do all of its parent
  include-books, up the chain.  Such an abort causes an error when
  the include-book form specifies a :load-compiled-file value of t.")
 (BOOK-CONTENTS
  (BOOKS-TOUR)
  "Restrictions on the forms inside [books]

    Example Book:

    ; This book defines my app function and the theorem that it is
    ; associative.  One irrelevant help lemma is proved first but
    ; it is local and so not seen by include-book.  I depend on the
    ; inferior book \"weird-list-primitives\" from which I get
    ; definitions of hd and tl.

    (in-package \"MY-PKG\")

    (include-book \"weird-list-primitives\")

    (defun app (x y) (if (consp x) (cons (hd x) (app (tl x) y)) y))

    (local
     (defthm help-lemma
       (implies (true-listp x) (equal (app x nil) x))))

    (defthm app-is-associative
      (equal (app (app a b) c) (app a (app b c))))

  The first form in a book must be (in-package \"pkg\") where \"pkg\" is
  some package name known to ACL2 whenever the book is certified.
  The rest of the forms in a book are embedded event forms, i.e.,
  [defun]s, [defthm]s, etc., some of which may be marked [local].
  See [embedded-event-form].  The usual Common Lisp commenting
  conventions are provided.  Note that since a book consists of
  embedded event forms, we can talk about the ``[local]'' and
  ``non-local'' [events] of a book.

  Because [in-package] is not an embedded event form, the only
  [in-package] in a book is the initial one.  Because [defpkg] is not
  an embedded event form, a book can never contain a [defpkg] form.
  Because [include-book] is an embedded event form, [books] may
  contain references to other [books].  This makes [books] structured
  objects.

  When the forms in a book are read from the file, they are read with
  [current-package] set to the package named in the [in-package] form
  at the top of the file.  The effect of this is that all symbols are
  [intern]ed in that package, except those whose packages are given
  explicitly with the ``::'' notation.  For example, if a book begins
  with (in-package \"ACL2-X\") and then contains the form

    (defun fn (x)
      (acl2::list 'car x))

  then [defun], fn, x, and [car] are all [intern]ed in the \"ACL2-X\"
  package.  I.e., it is as though the following form were read
  instead:

    (acl2-x::defun acl2-x::fn (acl2-x::x)
        (acl2::list 'acl2-x::car acl2-x::x)).

  Of course, acl2-x::defun would be the same symbol as acl2::defun if
  the \"ACL2-X\" package imported acl2::defun.

  If each book has its own unique package name and all the names
  defined within the book are in that package, then name clashes
  between [books] are completely avoided.  This permits the
  construction of useful logical [world]s by the successive inclusion
  of many [books].  Although it is often too much trouble to manage
  several packages, their judicious use is a way to minimize name
  clashes.  Often, a better way is to use local; see [local].

  How does [include-book] know the definitions of the packages used in
  a book, since [defpkg]s cannot be among the forms?  More generally,
  how do we know that the forms in a book will be admissible in the
  host logical [world] of an [include-book]?  See [certificate] for
  answers to these questions.")
 (BOOK-EXAMPLE
  (BOOKS-TOUR)
  "How to create, certify, and use a simple book

  Suppose you have developed a sequence of admissible [events] which
  you want to turn into a book.  We call this ``publishing'' the
  book.  This note explains how to do that.

  A key idea of [books] is that they are ``incremental'' in the sense
  that when you include a book in a host logical [world], the [world]
  is incrementally extended by the results established in that book.
  This is allowed only if every name defined by the incoming book is
  either new or is already identically defined.  See
  [redundant-events].  This is exactly the same problem faced by a
  programmer who wishes to provide a utility to other people: how can
  he make sure he doesn't create name conflicts?  The solution, in
  Common Lisp, is also the same: use packages.  While [books] and
  packages have a very tenuous formal connection (every book must
  start with an [in-package]), the creation of a book is intimately
  concerned with the package issue.  Having motivated what would
  otherwise appear as an unnecessary fascination with packages below,
  we now proceed with a description of how to publish a book.

  Just to be concrete, let's suppose you have already gotten ACL2 to
  accept the following sequence of [command]s, starting in the ACL2
  initial [state].

    (defpkg \"ACL2-MY-BOOK\"
            (union-eq *common-lisp-symbols-from-main-lisp-package*
                      *acl2-exports*))
    (in-package \"ACL2-MY-BOOK\")
    (defun app (x y)
      (if (consp x) (cons (car x) (app (cdr x) y)) y))
    (defun rev (x)
      (if (consp x) (app (rev (cdr x)) (list (car x))) nil))
    (defthm rev-app-hack
      (equal (rev (app a (list x))) (cons x (rev a))))
    (defthm rev-rev
      (implies (acl2::true-listp x) (equal (rev (rev x)) x)))

  Observe that the first form above defines a package (which imports
  the symbols defined in CLTL such as [if] and [cons] and the symbols
  used to [command] ACL2 such as [defun] and [defthm]).  The second
  form selects that package as the current one.  All subsequent forms
  are read into that package.  The remaining forms are just event
  forms: [defun]s and [defthm]s in this case.

  Typically you would have created a file with Emacs containing these
  forms and you will have submitted each of them interactively to
  ACL2 to confirm that they are all admissible.  That interactive
  verification should start in ACL2's initial [world] --- although
  you might, of course, start your sequence of [events] with some
  [include-book]s to build a more elaborate [world].

  The first step towards publishing a book containing the results above
  is to create a file that starts with the [in-package] and then
  contains the rest of the forms.  Let's call that file
  \"my-book.lisp\".  The name is unimportant, except it must end with
  \".lisp\".  If there are [events] that you do not wish to be
  available to the user of the book --- e.g., lemmas you proved on
  your way toward proving the main ones --- you may so mark them by
  enclosing them in [local] forms.  See [local].  Let us suppose you
  wish to hide rev-app-hack above.  You may also add standard Lisp
  comments to the file.  The final content of \"my-book.lisp\" might
  be:

    ; This book contains my app and rev functions and the theorem
    ; that rev is its own inverse.

      (in-package \"ACL2-MY-BOOK\")
      (defun app (x y)
        (if (consp x) (cons (car x) (app (cdr x) y)) y))
      (defun rev (x)
        (if (consp x) (app (rev (cdr x)) (list (car x))) nil))

    ; The following hack is not exported.
      (local (defthm rev-app-hack
        (equal (rev (app a (list x))) (cons x (rev a)))))

      (defthm rev-rev
        (implies (acl2::true-listp x) (equal (rev (rev x)) x)))

  The file shown above is the book.  By the time this note is done you
  will have seen how to certify that the book is correct, how to
  compile it, and how to use it in other host [world]s.  Observe that
  the [defpkg] is not in the book.  It cannot be: Common Lisp
  compilers disagree on how to treat new package definitions
  appearing in files to be compiled.

  Since a book is just a source file typed by the user, ACL2 provides a
  mechanism for checking that the [events] are all admissible and
  then marking the file as checked.  This is called certification.
  To certify \"my-book.lisp\" you should first get into ACL2 with an
  initial [world].  Then, define the package needed by the book, by
  typing the following [defpkg] to the ACL2 [prompt]:

    ACL2 !>(defpkg \"ACL2-MY-BOOK\"
                   (union-eq *common-lisp-symbols-from-main-lisp-package*
                             *acl2-exports*))

  Then execute the [command]:

    ACL2 !>(certify-book \"my-book\" 1 t) ; the `t' is in fact the default

  Observe that you do not type the \".lisp\" part of the file name.  For
  purposes of [books], the book's name is \"my-book\" and by the time
  all is said and done, there will be several extensions in addition
  to the \".lisp\" extension associated with it.

  The 1 tells [certify-book] that you acknowledge that there is one
  command in this ``certification [world]'' (namely the [defpkg]).
  To use the book, any prospective host [world] must be extended by
  the addition of whatever [command]s occurred before certification.
  It would be a pity to certify a book in a [world] containing junk
  because that junk will become the ``[portcullis]'' guarding
  entrance to the book.  The t above tells [certify-book] that you
  wish to compile \"my-book.lisp\" also (but see [compilation] for an
  exception).  [Certify-book] makes many checks but by far the most
  important and time-consuming one is that it ``proves'' every event
  in the file.

  When [certify-book] is done it will have created two new files.  The
  first will be called \"my-book.cert\" and contains the
  ``[certificate]'' attesting to the admissibility of the [events] in
  \"my-book.lisp\".  The [certificate] contains the [defpkg] and any
  other forms necessary to construct the certification [world].  It
  also contains so-called [book-hash] values that are used to help
  you keep track of which version of \"my-book.lisp\" was certified.

  The second file that may be created by [certify-book] is the compiled
  version of \"my-book.lisp\" and will have a name that is assigned by
  the host compiler (e.g., \"my-book.o\" in GCL, \"my-book.fasl\" in
  SBCL).  [Certify-book] will also load this object file.  When
  [certify-book] is done, you may throw away the logical [world] it
  created, for example by executing the [command] :u.

  To use the book later in any ACL2 session, just execute the event
  (include-book \"my-book\").  This will do the necessary [defpkg],
  load the non-[local] [events] in \"my-book.lisp\" and then may load
  the compiled code for the non-local functions defined in that file.
  Checks are made to ensure that the [certificate] file exists and
  describes the version of \"my-book.lisp\" that is read.  The compiled
  code is loaded if and only if it exists and has a later write date
  than the source file (but see [compilation] for an exception).

  Since [include-book] is itself an event, you may put such forms into
  other [books].  Thus it is possible for the inclusion of a single
  book to lead to the inclusion of many others.  The [book-hash]
  information maintained in [certificate]s helps deal with the
  version control problem of the referenced [books].  I.e., if this
  version of \"my-book\" is used during the certification of
  \"your-book\", then the [certificate] for \"your-book\" includes the
  book-hash for this version of \"my-book\".  If a later (include-book
  \"your-book\") finds a version of \"my-book\" with a different
  book-hash, an error is signaled.  But book-hash values are not
  perfect and the insecurity of the host file system prevents ACL2
  from guaranteeing the logical soundness of an [include-book] event,
  even for a book that appears to have a valid [certificate] (they
  can be forged, after all).  (See [certificate] for further
  discussion.)

  This concludes the example of how to create, certify and use a book.
  If you wish, you could now review the [documentation] for
  book-related topics (see [books]) and browse through them.  They'll
  probably make sense in this context.  Alternatively, you could
  continue the ``guided tour'' through the rest of the
  [documentation] of [books].  See [book-name], following the pointer
  given at the conclusion.")
 (BOOK-HASH
  (BOOKS)
  "Assigning ``often unique'' fingerprints to [books]

  ACL2 provides a certification process for recording into a
  [certificate] file that a book is valid.  That process records
  certain ``fingerprint'' values for the book and the books that it
  includes, in order to give some confidence in the book's validity.
  We call that value the ``book-hash'' for the book.  By default, a
  book-hash is an alist that records, for a given book (.lisp file),
  its file size (in bytes) and its write-date.

  You can arrange for a book-hash to be a checksum instead of an alist,
  which gives a bit greater security, as illustrated in an example
  provided below.  See [checksum].  Nevertheless, the (default) use
  of book-hash alists may be worthwhile, in spite of the decreased
  security, because of faster times for [certify-book] and
  [include-book] when using book-hash alists instead of checksums.
  If you want to use checksums, however, there are these two ways to
  do so.

    * Before starting ACL2, set environment variable ACL2_BOOK_HASH_ALISTP
      to NIL (or nil; actually it suffices that [string-upcase]
      applied to the indicated string is \"NIL\").  A common way to get
      this effect is to supply the argument ACL2_BOOK_HASH_ALISTP=NIL
      with your \"make\" command.
    * After starting ACL2, set [state] global variable book-hash-alistp to
      nil, e.g.: (assign book-hash-alistp nil).  (Set this variable
      to t to revert to the default behavior: (assign
      book-hash-alistp t).)

  The simple example below illustrates the potential weakness of
  book-hash alists (as compared to checksums), by exploiting the fact
  that these alists do not hash information in the [certificate]
  itself.  (Book-hash alists also ignore [portcullis] [command]s and
  the corresponding .acl2x file, if any (see [set-write-ACL2x]); but
  we don't exploit these facts in this example.)  We start with the
  following book, \"foo.lisp\".

    (in-package \"ACL2\")
    (make-event '(defun foo (x) (cons x x)))

  Now start ACL2 and run these commands.

    (assign book-hash-alistp t) ; a no-op, by default
    (certify-book \"foo\")
    (read-file \"foo.cert\" state)
    (quit)

  Next, replace the contents of \"foo.cert\" by the values in the list
  printed by the read-file form above (hence, without the outer
  parentheses).  Further edit that file by twice changing (cons x x)
  to x.  Also, update the write-date on the compiled file, e.g. with
  touch foo.dx64fsl, if you want to avoid a warning.  Then submit
  (include-book \"foo\").  We get the following contradictory behavior,
  without any warnings.

    ACL2 !>(foo 3)
    (3 . 3)
    ACL2 !>(thm (equal (foo x) x))

    Q.E.D.

    Summary
    Form:  ( THM ...)
    Rules: ((:DEFINITION FOO))
    Time:  0.00 seconds (prove: 0.00, print: 0.00, other: 0.00)
    Prover steps counted:  5

    Proof succeeded.
    ACL2 !>

  For more information about connections between book-hash values and
  certification status, see [book-hash-mismatch].


Subtopics

  [Book-hash-mismatch]
      Deeming a book uncertified because of a [book-hash] mismatch")
 (BOOK-HASH-MISMATCH
  (BOOK-HASH)
  "Deeming a book uncertified because of a [book-hash] mismatch

  When [include-book] is invoked, the specified book may be considered
  uncertified by ACL2 because its [book-hash] --- which by default is
  an alist specifying the book's size and write-date, but could be a
  checksum --- does not match what was expected.  In that case you
  will typically see a warning such as the following, which instead
  will be an error if this occurs during certification.  In this
  topic, we explain how this warning can occur.

    ACL2 Warning [Uncertified] in ( INCLUDE-BOOK \"foo\" ...):
    The certificate for \"/Users/kaufmann/temp/foo.lisp\" lists the book-
    hash of that book as ((:BOOK-LENGTH . 38) (:BOOK-WRITE-DATE . 3674050905)).
    But its book-hash is now computed to be
    ((:BOOK-LENGTH . 39) (:BOOK-WRITE-DATE . 3674050914)).
    See :DOC book-hash-mismatch.

  Probably the simplest way for such a mismatch to occur is if you
  change the book after certifying it, and then try to include the
  book.  In the example message displayed above, the book-hash for
  foo.lisp stored into foo.cert was 516310554.  But then foo.lisp was
  edited (in this case, by adding a single newline character), and
  ACL2 complained because at include-book time it computed a
  different book-hash for that book.

  The mismatch might occur on a book that is being included while
  including a superior book.  For example, suppose that the act of
  evaluating (include-book \"bk1\") triggers evaluation of the event
  (include-book \"bk2\") from bk1.lisp, which similarly in turn causes
  evaluation of the event (include-book \"bk3\") from bk2.lisp.  Now
  certify bk3.lisp, then bk2.lisp, and finally bk1.lisp.  So far, so
  good.  But now suppose we edit the lowest-level book, bk3.lisp.  We
  will likely get a warning (or error, if during book certification)
  such as the one displayed above when evaluating (include-book
  \"bk1\"), complaining that the book-hash for bk3.lisp has changed ---
  followed by warnings complaining about inclusions of uncertified
  books by superior books.

  There are several ways for a book-hash in a .cert file to become
  invalid, that is, to fail to match a recomputation of the book-hash
  when later including the book.  All such mismatches are due to a
  difference between the value of a book-hash at certification time
  and at later include-book time; see [book-hash].

  Note that it is possible to mix alist and checksum book-hash values.
  The key is to avoid conflicts between book-hash values stored for
  the same book in different .cert files.  The following example
  works fine, because there is no such conflict: the book \"sub\" is
  associated with a book-hash checksum in sub.cert, which provides
  that same checksum as the book-hash value for \"sub\" in top.cert;
  and the book \"top\" is associated with a book-hash alist in
  top.cert.

    (certify-book \"sub\")
    (u)
    (assign book-hash-alistp t)
    (certify-book \"top\") ; contains the event (include-book \"sub\")
    (u)
    (include-book \"top\") ; no problem!

  However, if we instead evaluate the following forms in a fresh ACL2
  session, the last one causes an error, because a checksum serves as
  the book-hash for \"sub\" in top.cert, but at include-book time the
  book-hash for \"sub\" in sub.cert is an alist, not a checksum.

    (certify-book \"sub\")
    :u
    (certify-book \"top\") ; contains the event (include-book \"sub\")
    :u
    (assign book-hash-alistp t)
    (certify-book \"sub\") ; now the book-hash for sub is an alist
    :u
    ; Error: mismatch for book-hash values for \"sub\" in
    ;        new sub.cert and earlier top.cert.
    (include-book \"top\")

  That said, ACL2 does not care about the current value of state global
  book-hash-alistp at include-book time.  For example, the following
  works without error: ACL2 sees the checksum stored in sub.cert, so
  at include-book time it computes a checksum for the book \"sub\", not
  an alist, even though 'book-hash-alistp has value t.

    (assign book-hash-alistp nil)
    (certify-book \"foo\")
    (assign book-hash-alistp t)
    (include-book \"foo\")

  We conclude by discussing a rather insidious book-hash mismatch that
  can occur when including a book using an ACL2 executable that
  differs from the executable that was used when certified the book.
  Here is an example.  Consider a book, \"foo.lisp\", containing the
  event (include-book \"tools/remove-hyps\" :dir :system).  Suppose we
  have ACL2 executables acl2-cksum and acl2-alist, in different ACL2
  directories.  Also suppose that we have certified (disjoint copies
  of) the [community-books] with each of these ACL2 executables,
  where we used ACL2_BOOK_HASH_ALISTP=NIL in our \"make\" command with
  acl2-cksum but not with acl2-alist.  Now suppose we certify
  \"foo.lisp\" using acl2-cksum but then, in a session with acl2-alist,
  we include that same book.  Then we will see a warning beginning as
  displayed below.  It complains that the book-hash required of
  books/tools/remove-hyps.cert according to foo.cert --- which was
  created using acl2-cksum --- differs from the book-hash in the
  .cert file of the copy of that book that is under the directory of
  the currently running ACL2, acl2-alist.

    ACL2 Warning [Uncertified] in ( INCLUDE-BOOK \"foo\" ...):  After including
    the book \"/Users/smith/temp/foo.lisp\":

    -- its certificate requires the book \"/Users/smith/acl2/books/tools/remove-
    hyps.lisp\" with certificate annotations
      ((:SKIPPED-PROOFSP) (:AXIOMSP) (:TTAGS))
    and book hash 1958615726, but we have included a version of \"remove-hyps\"
    with certificate annotations
      ((:SKIPPED-PROOFSP) (:AXIOMSP) (:TTAGS))
    and book-hash ((:BOOK-LENGTH . 14650) (:BOOK-WRITE-DATE . 3656629263)),
    so book recertification is probably required;")
 (BOOK-MAKEFILES (POINTERS)
                 "See [books-certification].")
 (BOOK-NAME
  (BOOKS-TOUR)
  "Conventions associated with book names

    Examples:
    \"list-processing\"
    \"/usr/home/smith/my-arith\"

  Book names are string constants that can be elaborated into file
  names.  We elaborate book names by concatenating the ``connected
  book directory'' (see [cbd]) string on the left and some
  ``extension,'' such as \".lisp\", on the right.  However, the
  connected book directory is not added if the book name itself
  already represents an absolute file name.  Furthermore,
  [include-book] and [certify-book] temporarily reset the connected
  book directory to be the directory of the book being processed.
  This allows [include-book] forms to use file names without explicit
  mention of the enclosing book's directory.  This in turn allows
  [books] (together with those that they include, using
  [include-book]) to be moved between directories while maintaining
  their certification and utility.

  You may wish to read elsewhere for details of ACL2 file name
  conventions (see [pathname]), for a discussion of the filename that
  is the result of the elaboration described here (see
  [full-book-name]), and for details of the concept of the connected
  book directory (see [cbd]).  For details of how [include-book] (see
  [include-book]) and [certify-book] (see [certify-book]) use these
  concepts, see below.

  Often a book name is simply the familiar name of the file.  (See
  [full-book-name] for discussion of the notions of ``directory
  string,'' ``familiar name,'' and ``extension''.  These concepts are
  not on the guided tour through [books] and you should read them
  separately.)  However, it is permitted for book names to include a
  directory or part of a directory name.  Book names never include
  the extension, since ACL2 must routinely tack several different
  extensions onto the name during [include-book].  For example,
  [include-book] uses the \".lisp\", \".cert\" and possibly the \".o\" or
  \".lbin\" extensions of the book name.

  Book names are elaborated into full file names by [include-book] and
  [certify-book].  This elaboration is sensitive to the ``connected
  book directory.'' The connected book directory is an absolute
  filename string (see [pathname]) that is part of the ACL2 [state].
  (You may wish to see [cbd] and to see [set-cbd] --- note that these
  are not on the guided tour).  If a book name is an absolute
  filename string, ACL2 elaborates it simply by appending the desired
  extension to the right.  If a book name is a relative filename
  string, ACL2 appends the connected book directory on the left and
  the desired extension on the right.

  Note that it is possible that the book name includes some partial
  specification of the directory.  For example, if the connected book
  directory is \"/usr/home/smith/\" then the book name
  \"project/task-1/arith\" is a book name that will be elaborated to

    \"/usr/home/smith/project/task-1/arith.lisp\".

  Observe that while the [events] in this \"arith\" book are being
  processed the connected book directory will temporarily be set to

    \"/usr/home/smith/project/task-1/\".

  Thus, if the book requires other [books], e.g.,

    (include-book \"naturals\")

  then it is not necessary to specify the directory on which they
  reside provided that directory is the same as the superior book.

  This inheritance of the connected book directory and its use to
  elaborate the names of inferior [books] makes it possible to move
  [books] and their inferiors to new directories, provided they
  maintain the same relative relationship.  It is even possible to
  move with ease whole collections of [books] to different
  filesystems that use a different operating system than the one
  under which the original certification was performed.

  The \".cert\" extension of a book, if it exists, is presumed to contain
  the most recent [certificate] for the book.  See [certificate] (or,
  if you are on the guided tour, wait until the tour gets there).

  See [book-contents] to continue the guided tour.")
 (BOOKDATA
  (BOOKS)
  "An optional tool for writing out small files with meta-data about the
  books that are being certified.

  ACL2 provides a primitive capability for writing out a file of data
  associated with a book.  This information might be useful, for
  example, in building a database that allows you to search for name
  conflicts.  See [community-books] directory
  books/tools/book-conflicts/ for an application of this capability
  by Dave Greve.  If you use this capability and have ideas for
  enhancing it, please feel free to send them to the ACL2 developers.

  If the book has the name BK, then the output file is named
  BK__bookdata.out.  That file is generated in the same directory as
  BK, by certifying BK when [state] global 'write-bookdata has a
  non-nil value, for example as follows.

    (assign write-bookdata t)
    (certify-book \"BK\" ...)

  The resulting file will contain a single form of the following shape,
  although not necessarily in the following order, according to the
  description that follows below.

    (\"...BK.lisp\"
     :PKGS          pkgs-val
     :BOOKS         book-val
     :PORT-BOOKS    port-book-val
     :CONSTS        consts-val
     :PORT-CONSTS   port-consts-val
     :FNS           fns-val
     :PORT-FNS      port-fns-val
     :LABELS        labels-val
     :PORT-LABELS   port-labels-val
     :MACROS        macros-val
     :PORT-MACROS   port-macros-val
     :STOBJS        stobjs-val
     :PORT-STOBJS   port-stobjs-val
     :THEORIES      theories-val
     :PORT-THEORIES port-theories-val
     :THMS          thms-val
     :PORT-THMS     port-thms-val

)
  The first entry in the form will always be the full book name (see
  [full-book-name]) of the certified book, BK.

  Subsequent values in the form are based on [events] introduced by
  including BK.  For various values of xxx as described below,
  port-xxx-val is a list of values corresponding to [events]
  introduced in the certification [world] for BK (see [portcullis]),
  and xxx-val is a list of values corresponding to [events]
  introduced non-[local]ly by BK.  These lists include only
  ``top-level'' events, not those that are introduced by a book
  included either in BK or its certification world.

  pkgs-val is a list of names of packages introduced in the
  certification world (at the top level, not in an included book).
  Note that no packages are introduced in a book itself, so no
  distinction is made between pkgs-val and port-pkgs-val.  Both
  port-book-val and book-val are lists of full book names (see
  [full-book-name]) of included books.  The values associated with
  the other keywords are, themselves, association lists (see
  [alistp]) such that each key is a package name, which is associated
  with a list of [symbol-name]s for symbols in that package that are
  introduced for that keyword.  For example, fns-val may be the alist

    ((\"ACL2\" \"F1\" \"F2\")
     (\"MY-PKG\" \"G1\" \"G2\"))

  if the function symbols introduced in the book are F1 and F2 in the
  \"ACL2\" package, as well as G1 and G2 in the \"MY-PKG\" package.

  We next explain what kinds of symbols are introduced for each keyword
  :xxx.  Each such symbol would be associated with either the keyword
  :port-xxx or the keyword :xxx depending respectively on whether the
  symbol is introduced at the top level of the certification world
  for BK or BK itself.

    :CONSTS
      constant symbol introduced by defconst
    :FNS
      function symbol: introduced by defun, defuns, or defchoose; or
      constrained (by an [encapsulate] event)
    :LABELS
      symbol introduced by deflabel
    :MACROS
      macro name introduced by defmacro
    :STOBJS
      stobj name introduced by defstobj or defabsstobj
    :THEORIES
      theory name introduced by deftheory
    :THMS
      theorem name, which may be introduced by defthm or a macro call
      expanding to a call of defthm, such as see [defequiv] or
      defaxiom; but may be introduced by [defpkg], for example, with
      name \"MYPKG-PACKAGE\" if the package name is \"MYPKG\"

  Our hope is that people in the ACL2 community will generate and use
  this data to improve the ACL2 [community-books].  Here is an
  example illustrating how to generate bookdata files for those books
  as a byproduct of a regression run.  Below, we write {DIR} as an
  abbreviation for the ACL2 sources directory, and assume that this
  command is run from that directory.  Of course, you may wish to use
  make options like -j 8 and make variable settings like
  ACL2={DIR}/my-saved_acl2; see [books-certification] for details.

    make regression-fresh \\
    ACL2_CUSTOMIZATION={DIR}/acl2-customization-files/bookdata.lisp")
 (BOOKS
  (ACL2)
  "Books are files of ACL2 [events]---they are the main way to split up
  large ACL2 developments into separate modules.

  This [documentation] topic is about ACL2 {source code |
  https://en.wikipedia.org/wiki/Source_code} files.  However, there
  are also {traditional, paper books |
  http://www.cs.utexas.edu/users/moore/publications/acl2-papers.html#Books}
  published about ACL2 and its applications.

  You will almost surely want to organize your own ACL2 work into
  books.  They facilitate reuse, allow you to reload proofs more
  quickly, allow you to rebuild parts of your proof in parallel, and
  so forth.  You will also want to be aware of the many community
  books, which provide useful tools and lemmas to build upon.  See
  [community-books] for more information, including how to
  contribute.


Introduction

  A book is a file of ACL2 forms.  Books are prepared entirely by the
  user of the system, i.e., they are source files not object files.
  Some of the forms in a book are marked [local] and the others are
  considered ``non-local.''

  [Include-book] lets you load a book into any ACL2 [world].  A
  successful include-book extends the logic of the host [world] by
  adding just the non-local [events] in the book.  Ordinarily, you
  might include a variety of books to load all of their definitions
  and rules.

  Successful book inclusion is consistency preserving, provided that
  the book itself is consistent, as discussed later.  However,
  [include-book] assumes the [events] in a book are valid, so if you
  include a book that contains an inconsistency (e.g., an
  inadmissible definition) then the resulting theory is inconsistent!

  [Certify-book] lets you certify a book to guarantee that its
  successful inclusion is consistency preserving.  During
  certification, both the [local] and non-local forms are processed.
  This lets you mark as [local] any [events] you need for
  certification, but that you want to hide from users of the
  book---e.g., the hacks, crocks, and kludges on the way to a good
  set of [rewrite] rules.

  Certification can also compile (see [COMPILATION]) a book to speed up
  the execution of the functions defined within it.  The desire to
  compile books is largely responsible for the restrictions we put on
  the forms allowed in books.

  Extensive [documentation] is available on the various aspects of
  books.  We recommend that you read it all before using books.  It
  has been written so as to make sense when read in a certain linear
  sequence, called the ``guided tour'', though in general you may
  browse through it randomly.  If you are on the guided tour, you
  should next read [book-example].


Subtopics

  [Book-hash]
      Assigning ``often unique'' fingerprints to [books]

  [Bookdata]
      An optional tool for writing out small files with meta-data about
      the books that are being certified.

  [Books-reference]
      Reference guide for ACL2 functionality related to books, e.g.,
      [include-book], [certify-book], [cbd], etc.

  [Books-tour]
      The guided tour of concepts related to ACL2 [books].

  [Community-books]
      Libraries of ACL2 [books] developed by the ACL2 community.

  [Uncertified-books]
      Invalid [certificate]s and uncertified [books]")
 (BOOKS-CERTIFICATION
  (COMMUNITY-BOOKS)
  "Instructions for certifying the ACL2 [community-books].

  The Community Books (see [COMMUNITY-BOOKS]) provides a make system,
  which is recommended for certifying a specified subset of those
  books from the books/ directory of your ACL2 distribution.
  Alternate instructions are however available for certifying from
  the top-level directory (see [books-certification-alt]).

  Below are instructions for certifying various sets of books.  They
  all have the following form in common.  Note: If there is a
  suitable \"acl2\" executable on your Unix PATH --- for example, if
  the bin subdirectory of the main ACL2 directory is on your PATH, so
  that bin/acl2 may be your executable --- then you can omit
  \"ACL2=...\" below.

    cd /path/to/acl2-sources/books
    make ACL2=/path/to/acl2-sources/saved_acl2 ...

  For example, the section ``A Full Build'', below, says to do the
  following if you would like to make a change to the
  [community-books] (where the -j argument is optional).

    $ cd /path/to/acl2-sources/books
    $ make ACL2=/path/to/acl2-sources/saved_acl2 -j 2 all

  Success is indicated by a Linux exit status of 0.  Equivalently,
  there should be no failures in the log.  Failures may be found by
  searching for **; for example, if output is redirected to a log
  file make-regression.log, then the following should provide no
  output.

    fgrep -a '**' make-regression.log

  Unusual books that create output in the log file should not produce
  the string ** except upon failure.

  By default, make commands for certifying books take advantage of
  files *@useless-runes.lsp.  See [useless-runes].


Prerequisites

  We assume that you have already downloaded and installed ACL2 as per
  the {ACL2 installation instructions |
  http://www.cs.utexas.edu/users/moore/acl2/v8-5/HTML/installation/installation.html}
  on the ACL2 home page.

  We assume you know the path to your ACL2 executable.  Typically this
  is a script named saved_acl2 in your acl2-sources directory.

  We assume the ACL2 [community-books] are installed in the books/
  subdirectory of your ACL2 distribution, as is the case when you
  have followed the ACL2 installation instructions above.

  The instructions below are suitable for ACL2 and all of its
  experimental extensions, e.g., ACL2(p) and ACL2(r).

  It may be preferable to avoid being logged in as root, since
  developers do not test as root and at least one community book
  (books/oslib/tests/copy.lisp) has failed to certify when logged in
  as root.


A Basic Build

  Before ACL2 Version 6.4, building the Community Books could take
  several hours.  Now, the default make target in books/GNUmakefile,
  called basic, is much faster --- it excludes many books and
  certifies only books listed below, which tend to be widely used.
  WARNING: the basic target of books/GNUmakefile is insufficient for
  validating changes that will go into the [community-books]; for
  that, use the all target.

    * arithmetic
    * arithmetic-3
    * arithmetic-5
    * [ihs]
    * misc
    * tools (mostly)
    * [std]
    * [xdoc] (in part)
    * data-structures

  To certify these books, you should be able to run make as follows.
  The -j 2 part of this command is suitable for a computer with two
  cores.  If you have, e.g., a quad-core computer, you should
  probably use -j 4 instead, and so on.

    $ cd /path/to/acl2-sources/books
    $ make ACL2=/path/to/acl2-sources/saved_acl2 -j 2 basic

  If you configure your PATH so that you can launch ACL2 by typing
  acl2, then you may omit the ACL2=... part.


Certifying Additional Books

  We expect that most ACL2 users will want to certify at least the
  basic books described above.  But what if you also need other
  books?  One option is to do a full build (see below).  But it is
  usually much faster to simply tell make to build the books you
  actually want to use.

  There are make targets corresponding to most directory names.  For
  instance, to build the books under coi and rtl and cgen, you can
  run:

    $ cd /path/to/acl2-sources/books
    $ make ACL2=/path/to/acl2-sources/saved_acl2 coi rtl cgen -j 2

  For finer grained control, you can name individual books.  This works
  particularly well for libraries that have top books.  For instance,
  if you want the rtl/rel9 library, you could run:

    $ cd /path/to/acl2-sources/books
    $ make ACL2=/path/to/acl2-sources/saved_acl2 rtl/rel9/lib/top.cert -j 2


Books that Require ACL2 Extensions

  Some books require experimental extensions to ACL2, such as ACL2(p)
  (see [parallelism]) or ACL2(r) (see [real]).  Other books require
  certain additional software.

  The build system will automatically determine which kind of ACL2 you
  are running (ACL2, ACL2(p), or ACL2(r)) and, based on this, may
  prevent incompatible books from being certified.  The output of
  make should explain which books are being excluded and why.

  These kinds of book requirements are controlled by special
  [build::cert_param] comments.


Books that Require Quicklisp

  Some books, especially [interfacing-tools] like [oslib] and the ACL2
  [bridge], require certain Common Lisp libraries.

  These libraries are now bundled with ACL2 via [quicklisp], so you
  should not need to download anything extra to use them.  They are
  enabled by default for all host Lisps except GCL, but you can avoid
  books that depend on Quicklisp libraries by setting USE_QUICKLISP=0
  in your make command.

  Using Quicklisp should definitely work if the host Lisp is CCL or
  SBCL.  (Note however that certification of [books] that use
  Quicklisp may require openssl to be installed if it is not already
  on your system.)  There is some chance it will work with Allegro
  CL, LispWorks, and CMUCL.  It will almost certainly not work for
  GCL (at least as of 2018).


Books that Require Additional Software

  Some other books based on [satlink] and [gl] require a SAT solver,
  typically Glucose, to be installed; see
  [satlink::sat-solver-options] for installation options.  The build
  system should automatically determine if Glucose is installed on
  your system, and will avoid trying to certify these books unless
  Glucose is present.


Building the manual

  If you just want to get a copy of the ACL2+Books manual for local
  viewing, you probably don't need to build it yourself because you
  can just {download | download/} a copy.  If for some reason you do
  want to build the manual yourself, you should be able to do so as
  follows, provided you have installed glucose.  (That requirement
  might be eliminated in the future.)

    $ cd /path/to/acl2-sources/books
    $ make manual -j 4

  Building the manual should work on at least CCL and SBCL on Linux and
  Mac OS X.  It may not work for some other OS/Lisp combinations.  In
  particular, building the manual requires some features from [oslib]
  and [quicklisp] that may not be available on some other Lisps.

  The resulting web-based manual may be found in:

    acl2-sources/books/doc/manual/index.html

  See also [ACL2-doc] for details about how to build your own
  Emacs-based manual, and [xdoc::save] for general information about
  how to build and distribute custom XDOC manuals, e.g., manuals that
  additionally include your own unreleased books.


A Full Build

  Building all of the books can take hours and is usually unnecessary.
  That said, it is easy to do: just run make all, for example as
  follows.  (But as noted above, you may omit \"ACL2=...\" if a
  suitable executable named acl2 is on your Unix PATH, such as
  bin/acl2.)

    $ cd /path/to/acl2-sources/books
    $ make ACL2=/path/to/acl2-sources/saved_acl2 -j 2 all

  This includes a few books that are quite slow to certify.  You can
  exclude those by replacing ``all'' by ``regression'' in the command
  above.


Cleaning Up

  If you want to delete generated files, you can run make clean to
  remove certificates, compiled files, and build logs.

  If you just want to remove the files in a particular subdirectory
  (and its subdirectories), you can go into that directory and then
  run the build/clean.pl script.  This will delete, starting from
  your current directory, recursively, all certificates, logs,
  compiled files, etc.

  Note that make clean doesn't remove some files, e.g., [xdoc] manuals.
  To remove everything, try make moreclean.


Debugging Failed Certifications

  If a book fails to certify, you may want to try certifying it in an
  interactive session.  The most reliable way to do this is to
  replicate the environment and commands that the build system used.
  This information can be found at the top of the [bookname].cert.out
  file.  For instance:

    ;; foo.cert.out
    -*- Mode: auto-revert -*-
    ...
    Environment variables:
    ACL2_CUSTOMIZATION=NONE                 ;; <-- first configure your
    ACL2_SYSTEM_BOOKS=/path/to/acl2/books   ;;     environment to match
    ACL2=/path/to/saved_acl2                ;;     these settings
    ...
    Temp lisp file:
    (acl2::value :q)                 ;; <--- then submit these commands to
    (acl2::in-package \"ACL2\")      ;;      $ACL2 to debug the failure
    ...                              ;;      interactively
    --- End temp lisp file ---

  Some other notes/tips:

    * Make sure the ACL2 image you run is the same as the one listed as
      ACL2 in those environment variables!
    * You may wish to set the environment variables for only the duration
      of your ACL2 session by using the \"env\" command.
    * You may wish to edit some of the commands for better debugging
      purposes; e.g. you may modify the [set-inhibit-output-lst]
      command, or insert a [set-debugger-enable] command, etc.
    * If you don't want your session to exit after a successful
      certification, replace the last form (er-progn (time$
      (certify-book ... with just the (time$ (certify-book ...))
      part.


Further Resources

  The build system is largely based on [build::cert.pl].  There is
  considerable documentation about cert.pl, and we highly recommend
  using it to manage your own ACL2 projects.

  The main build script is books/GNUmakefile.  There are many comments
  at the start of this file, and you can also inspect it to see what
  targets are available.

  Please feel absolutely free to contact the [ACL2-help] mailing list
  with any questions about building the community books.


Subtopics

  [Books-certification-alt]
      Alternate instructions for certifying the [community-books], from
      the perspective of the acl2-sources directory.

  [Books-certification-classic]
      Classic ACL2 `make'-based certification of [books]

  [Provisional-certification]
      Certify a book in stages for improved book-level parallelism")
 (BOOKS-CERTIFICATION-ALT
  (BOOKS-CERTIFICATION)
  "Alternate instructions for certifying the [community-books], from the
  perspective of the acl2-sources directory.

  WARNING: Parts of this documentation are probably obsolete, but parts
  are still relevant.  See [books-certification] as the primary
  source of information on how to certify the [community-books].

  For background on the ACL2 community books, see [community-books].
  Here we explain how to certify those books, or some of those books,
  with ACL2.  We thank Bishop Brock, Jared Davis, and Sol Swords for
  their substantial contributions to this methodology.  See
  books/GNUmakefile, in the community books, for more about ``Credits
  and History'', and for additional technical details not covered in
  this topic.

  For more information about installing ACL2, see the {ACL2
  installation instructions |
  http://www.cs.utexas.edu/users/moore/acl2/v8-5/HTML/installation/installation.html}.
  For information about so-called ``classic ACL2 `make'-based
  certification'', which provides support for certifying directories
  of books but may disappear in a future ACL2 release, see
  [books-certification-classic].

  The Basics

  We make the following assumptions.

    * Gnu `make' is available on your system via the `make' command (rather
      than some other flavor of `make').  (Execute `make --version to
      verify this.)
    * You have built or obtained an ACL2 executable.
    * The ACL2 [community-books] are installed in the books/ subdirectory
      of your ACL2 distribution, as is the case when you have
      followed the standard installation instructions.

  Note: All commands shown below are issued in the top-level (ACL2
  sources) directory of your ACL2 distribution.

  By default the ACL2 executable is file saved_acl2 in your ACL2
  sources directory, and you can issue the following command to the
  shell in order to do a ``regression run'' that certifies all of the
  community books using that executable.

    make regression

  Better yet, save a log file in case there are problems, for example
  as follows.

    (make regression) >& make-regression.log

  or perhaps better yet:

    (time nice make regression) >& make-regression.log

  For the sake of brevity, below we'll skip mentioning any of `time',
  `nice', or `>& make-regression.log'.  But saving a log file, in
  particular, is useful in case you encounter problems to report.

  If you fetched the community books using git, then you will have a
  directories such books/workshops/ that is not necessary for
  certifying the most widely-included books.  You can certify just
  such books as follows.

    (time nice make basic) >& make-basic.log

  Whether you use target `regression' or target `basic', then for each
  book foo.lisp whose certification is attempted, a file foo.cert.out
  in the same directory will contain the output from the book's
  certification attempt.

  A regression run may take a few hours, but if you have a
  multiprocessing computer, you can speed it up by certifying some
  books in parallel, by providing a value for `make' option -j.  For
  example, if you have 8 hardware threads then you might want to
  issue the following command.

    make regression -j 8

  Specifying the ACL2 Executable

  If your ACL2 executable is not file saved_acl2 in the ACL2 sources
  directory, then you will need to specify that executable.  You can
  do that by setting variable ACL2, either as an environment variable
  or, as displayed below, as a `make' variable.  Either way, you will
  need to avoid relative pathnames.  For example, the first two forms
  below are legal, but the third is not, assuming that my-acl2 is on
  your PATH in a Unix-like environment (e.g., linux or MacOS) and
  that my-saved_acl2 is just a pathname relative to your ACL2 sources
  directory, which is not on your path.

    make regression -j 8 ACL2=my-acl2
    make regression -j 8 ACL2=/u/smith/bin/acl2
    # The following only works if my-saved_acl2 is on your path (see above).
    make regression -j 8 ACL2=my-saved_acl2

  Cleaning

  You can delete files generated by book certification (including .cert
  files, .out files, compiled files, and more) by issuing the
  following command (again, in your ACL2 sources directory).

    make clean-books

  Alternatively, if you want to cause such deletion and then do a
  regression, simply replace the `regression' target by
  `regression-fresh.

  If however you only want to clean up generated files residing under a
  given directory (or its subdirectories, and recursively), you can
  issue the following command while standing in that directory, where
  DIR is a pathname of your books directory.

    DIR/clean.pl

  For example, to clean up generated files under books/arithmetic, you
  could do the following.

    cd books/arithmetic
    ../clean.pl
    cd - # to return to the ACL2 sources directory, if you wish to do so

  Restricting to Specific Directories and Books

  You can specify which books you want certified by using any or all of
  the variables EXCLUDED_PREFIXES, ACL2_BOOK_CERTS, or
  ACL2_BOOK_DIRS.  First, the set of desired .cert files is
  restricted to those that do not start with any string that is one
  of the words in the value of EXCLUDED_PREFIXES.  Then
  ACL2_BOOK_CERTS and ACL2_BOOK_DIRS, if supplied, specify which
  books should be certified, as illustrated by the following example.

    make -j 8 regression-fresh \\
     ACL2_BOOK_DIRS=\"symbolic paco\" \\
     ACL2_BOOK_CERTS=\" \\
      workshops/2006/cowles-gamboa-euclid/Euclid/ed6a.cert \\
      workshops/2006/cowles-gamboa-euclid/Euclid/ed4bb.cert \\
      \"

  Then all book in directories symbolic and paco will be certified, as
  will the books workshops/2006/cowles-gamboa-euclid/Euclid/ed6a.lisp
  and workshops/2006/cowles-gamboa-euclid/Euclid/ed4bb.lisp.  Note
  that all pathnames should be relative to your community books
  directory; in particular, they should not be absolute pathnames.
  Also notice the .cert extension used in files supplied for
  ACL2_BOOK_CERTS.

  Alternatively, you may wish to invoke books/cert.pl while standing in
  a directory under which you want to certify books.  This will
  certify not only those books, but all supporting books --- even
  those not under the current directory --- that do not have
  up-to-date .cert files.  The following is a simple command to
  invoke that will certify all books in the current directory, where
  if the books/ directory is not on your path, you will need to
  provide a suitable filename, e.g. ../../cert.pl or
  ~/acl2/books/cert.pl.

    cert.pl -j 4 *.lisp

  Here is a more complex command, which illustrates a way to certify
  books in subdirectories (as well as the current directory), the use
  of provisional certification (see [provisional-certification]), and
  `make'-level parallelism (in this case specifying four parallel
  processes).

    cert.pl --pcert-all -j 4 `find . -name '*.lisp'`

  Note that with this approach, unlike classic ACL2 `make'-based
  certification (see [books-certification-classic], out-of-date .cert
  files that are not under the current directory will also be built.
  For documentation of cert.pl invoke:

    cert.pl -h

  See the top of cert.pl for authorship and copyright information.

  Finally, we give a brief summary of how to use so-called ``classic
  ACL2 `make'-based certification'' for community books; see
  [books-certification-classic] for details.  Note that support for
  this approach might be eliminated in a future ACL2 release.  We
  welcome comments from the ACL2 community about whether or not that
  would be a good thing to do.  See the discussion above about
  ACL2_BOOK_DIRS for the ``modern'' way to accomplish the same thing.

  Many community book directories have a Makefile.  If you modify books
  only in such a directory, you can recertify by standing in that
  directory and issuing a `make' command.  This command can
  optionally specify an ACL2 executable as well as parallelism, for
  example as follows, where the first line (make clean) is optional.

    make clean
    (time nice make -j 8 ACL2=my-acl2)

  ACL2 Customization Files

  By default, your acl2-customization file (see [ACL2-customization])
  is ignored by all flavors of ``make regression''.  However, you can
  specify the use of an acl2-customization file by setting the value
  of environment variable ACL2_CUSTOMIZATION to the empty string,
  indicating a default such file, or to the desired absolute
  pathname.  For example:

    make regression ACL2_CUSTOMIZATION=''
    make regression ACL2_CUSTOMIZATION='~/acl2-customization.lisp'

  Regressions for Variants of ACL2

  The discussion above also pertains to using ACL2(p) (see [parallel])
  or ACL2(r) (see [real]), in which case the default is saved_acl2p
  or saved_acl2r respectively, rather than saved_acl2.  However, we
  recommend that you use ACL2, not ACL2(p), for your regression.
  Then you can use ACL2(p) for your own proof developments.  However,
  if you want to use ACL2(p) or for your regression, see
  [waterfall-parallelism-for-book-certification].

  Provisional Certification

  To use provisional certification (see [provisional-certification]),
  supply ACL2_PCERT=t with your `make' command.  Here is an example.

    time nice make regression -j 4 ACL2_BOOK_DIRS=deduction ACL2_PCERT=t

  Miscellany

  Other control of the certification process may be found by perusing
  community books file books/make_cert.  In particular, the INHIBIT
  variable may be set to a call of [set-inhibit-output-lst], for
  example as follows to obtain the output one would get by default in
  an (interactive) ACL2 session.

    time nice make regression -j 4 ACL2_BOOK_DIRS=arithmetic \\
      INHIBIT='(set-inhibit-output-lst proof-tree)'

  Troubleshooting

  If you run into problems, you can get help by joining the acl2-help
  email list (follow the link from the ACL2 home page) and sending a
  message to that list.  Also consider trying another version of GNU
  `make'; for example, we have found that versions 3.81 and 3.82
  sometimes cause errors on Linux where version 3.80 does not.  Note
  however that Version 3.80 does not print certain informational
  messages that are printed by later versions.")
 (BOOKS-CERTIFICATION-CLASSIC
  (BOOKS-CERTIFICATION)
  "Classic ACL2 `make'-based certification of [books]

  This [documentation] topic explains an approach to certifying
  directories of books, which we call ``classic ACL2 `make'-based
  certification''.

  Warning: The capability described in this section might be replaced
  at any time by a capability based on corresponding support for
  community books (see [books-certification]).  If you think that
  would be a hardship, please contact the ACL2 implementors.

  This topic discusses a way to certify a directory of books other than
  the ACL2 community books.  See [books-certification] for how to
  certify the set of ACL2 community [books].  There is also a section
  in that [documentation] topic, ``Restricting to Specific
  Directories and Books'', that provides an alternative to classic
  ACL2 `make'-based certification (as discussed in the present topic)
  for certifying specified sets of books.

  We assume here a familiarity with Unix/Linux `make'.  We also assume
  that you are using GNU `make' rather than some other flavor of
  `make'.  And finally, we assume, as is typically the case by
  following the standard installation instructions, that you install
  the ACL2 community books in the books/ subdirectory of your ACL2
  distribution.  We will refer below to that directory as BOOKS.

  In summary: to use `make' to certify [books] under a given directory,
  you may create a simple Makefile in that directory (as explained
  below) so that when you stand in that directory, you can submit the
  command, `make', to certify those books.  If you have a
  multi-processor machine or the like, then you can use the `-j flag
  `make'-level parallelism by specifying the number of concurrent
  processes.  For example:

    make -j 4

  For each book foo.lisp, a file foo.out in the same directory as
  foo.lisp will contain the output from the corresponding
  certification attempt.  If you have previously executed such a
  command, then you might first want to delete [certificate] files
  and other generated files by executing the following command.

    make clean

  Note that when you run `make', then by default, the first error will
  cause the process to stop.  You can use make -i to force `make' to
  ignore errors, thus continuing past them.  Or, use make -k to keep
  going, but skipping certification for any book that includes
  another whose certification has failed.

  By default, your acl2-customization file (see [ACL2-customization])
  is ignored by such `make' commands.  However, you can specify the
  use of an acl2-customization file by setting the value of
  environment variable ACL2_CUSTOMIZATION to the empty string,
  indicating a default such file, or to the desired absolute
  pathname.  For example:

    make ACL2_CUSTOMIZATION=''
    make ACL2_CUSTOMIZATION='~/acl2-customization.lisp'

  We now discuss how to create makefiles to support `make' commands as
  discussed above.

  First we give five steps for creating a Makefile to support
  certification of a directory of books, without subdirectories.  For
  examples of such Makefiles you can look in community book
  directories (which, however, might disappear in future versions of
  ACL2).

      1. Include the file Makefile-generic from the books/ subdirectory of
      your ACL2 sources directory, but first perhaps define the
      variable `ACL2'.  Consider the following example.

        ACL2 ?= /Users/john_doe/acl2/acl2-sources/saved_acl2
        include /Users/john_doe/acl2/acl2-sources/books/Makefile-generic

      In this example, you can omit the first line, because the default
      ACL2 executable is file saved_acl2 in the directory immediately
      above the directory of the specified Makefile-generic file.
      Indeed, that is the common case.  Note the use of ?= instead of
      = or :=, so that ACL2 can instead be defined by the environment
      or provided on the command line as part of the `make' command.

      2. (Optional; usually skipped.)  Set the INHIBIT variable if you want
      to see more than the [summary] output.  For example, if you
      want to see the same output as you would normally see at the
      terminal, put this line in your Makefile after the `include'
      lines.

        INHIBIT = (assign inhibit-output-lst (list (quote proof-tree)))

      For other values to use for INHIBIT, see [set-inhibit-output-lst] and
      see the original setting of INHIBIT in books/Makefile-generic.

      3. Specify the books to be certified.  Normally, every file with
      extension .lisp will be a book that you want to certify, in
      which case you can skip this step.  Otherwise, put a line in
      your Makefile after the ones above that specifies the books to
      be certified.  The following example, from an old version of
      community books file books/finite-set-theory/osets/Makefile,
      should make this clear.

        BOOKS = computed-hints fast instance map membership outer primitives \\
                quantify set-order sets sort

      But better yet, use the extension .lsp for any Lisp or ACL2 files
      that are not to be certified, so that the definition of BOOKS
      can be omitted.

      4. Create .acl2 files for books that are to be certified in other
      than the initial ACL2 world (see [portcullis]).  For example,
      if you look in community books file
      books/arithmetic/equalities.acl2 you will see [defpkg] forms
      followed by a [certify-book] command, because it was determined
      that [defpkg] forms were necessary in the certification world
      in order to certify the equalities book.  In general, for each
      <book-name>.lisp whose certification requires a non-initial
      certification world, you will need a corresponding
      <book-name>.acl2 file that ends with the appropriate
      [certify-book] command.

      You also have the option of creating a file cert.acl2 that has a
      special role.  When file <book-name>.lisp is certified, if
      there is no file <book-name>.acl2 but there is a file
      cert.acl2, then cert.acl2 will be used as <book-name>.acl2
      would have been used, as described in the preceding paragraph,
      except that the appropriate [certify-book] command will be
      generated automatically.  Thus, no certify-book command should
      occur in cert.acl2.

      It is actually allowed to put raw lisp forms in a .acl2 file
      (presumably preceded by :q or (value :q) and followed by (lp)).
      But this is not recommended; we make no guarantees about
      certification performed any time after raw Lisp has been
      entered in the ACL2 session.

      5. Generally, the next step is to include the following line after
      the `include' of Makefile-generic (see the first step above).

        -include Makefile-deps

      This will cause `make' to create and then include a file
      Makefile-deps that contains ``dependency'' lines needed by
      `make'.  If those dependencies are somehow flawed, it may be
      because you have [include-book] forms that are not truly
      including books, for example in multi-line comments (#|..|#).
      These will be ignored if preceded by a semicolon (;), or if you
      add a line break after ``include-book.'' But instead of adding
      the `-include' line above, you can create dependency lines
      yourself by running the command

        make dependencies

      and pasting the result into the end of your Makefile, and editing as
      you see fit.

  This concludes the basic instructions for creating a Makefile in a
  directory including books.  Here are some other capabilities
  offered by community books file books/Makefile-subdirs.  Not
  included below is a discussion of how to increase parallelism by
  avoiding the need to certify included books before certifying a
  given book; see [provisional-certification].

  Subdirectory Support

  There is support for using `make' to certify books in subdirectories.
  Consider the following example.

    DIRS = pass1 bind-free floor-mod
    include ../Makefile-subdirs

  This indicates that we are to run `make' in subdirectories pass1/,
  bind-free/, and floor-mod/ of the current directory.

  You can combine this subdirectory support with the support already
  discussed for certifying books in the top-level directory.  Here is
  an example, which as of this writing is in community books file
  books/arithmetic-3/Makefile contains the following lines.

    arith-top: top all
    all: top

    DIRS = pass1 bind-free floor-mod
    include ../Makefile-subdirs
    include ../Makefile-generic

    -include Makefile-deps

  The `top' target is defined in ../Makefile-subdirs to call `make' in
  each subdirectory specified in DIRS.  We have set the default
  target in the example above to a new name, arith-top, that makes
  that top target before making the `all' target which, in turn, is
  the default target in any Makefile-generic, and is responsible for
  certifying books in the current directory as discussed in the five
  steps displayed above.

  Use Makefile-psubdirs instead of Makefile-subdirs if certification of
  a book in a subdirectory never depends on certification of a book
  in a different subdirectory, because then the -j option of `make'
  can allow subdirectories to be processed in parallel.

  Cleaning Up

  We note that there is a clean target.  Thus,

    make clean

  will remove generated files including .cert, .out files, and compiled
  files.

  System Books

  An environment variable ACL2_SYSTEM_BOOKS is generally set
  automatically, so you can probably skip reading the following
  paragraph unless your attempt to certify books fails to locate
  those books properly.

  The environment variable ACL2_SYSTEM_BOOKS can be set to the
  top-level directory of the ACL2 community books.  A Unix-style
  pathname, typically ending in books/ or books, is permissible.  In
  most cases, your ACL2 executable is a small script in which you can
  set this environment variable just above the line on which the
  actual ACL2 image is invoked, for example:

    export ACL2_SYSTEM_BOOKS
    ACL2_SYSTEM_BOOKS=/home/acl2/v3-2/acl2-sources/books

  However, you can also set ACL2_SYSTEM_BOOKS as a `make' variable, by
  setting it in your Makefile before the first target definition,
  e.g.:

    ACL2_SYSTEM_BOOKS ?= /home/acl2/v3-2/acl2-sources/books

  Compilation Support

  The file books/Makefile-generic provides support for compiling books
  that are already certified (but see [compilation] for an
  exception).  For example, suppose that you have certified books
  using GCL as the host Lisp, resulting in compiled files with the .o
  extension.  Now suppose you would like to compile the books for
  Allegro Common Lisp, whose compiled files have the .fasl extension.
  The following command will work if you have included
  books/Makefile-generic in your Makefile.

    make fasl

  In general, the compiled file extension for a Lisp supported by ACL2
  will be a target name for building compiled files for all your
  books (after certifying the books, if not already up-to-date on
  certification).

  If you run into problems, you can get help by joining the acl2-help
  email list (follow the link from the ACL2 home page) and sending a
  message to that list.  Also consider trying another version of GNU
  `make'; for example, we have found that versions 3.81 and 3.82
  sometimes cause errors on Linux where version 3.80 does not.")
 (BOOKS-REFERENCE
  (BOOKS)
  "Reference guide for ACL2 functionality related to books, e.g.,
  [include-book], [certify-book], [cbd], etc.


Subtopics

  [Add-include-book-dir]
      Link keyword for :dir argument of [ld] and [include-book]

  [Add-include-book-dir!]
      Non-[local]ly link keyword for :dir argument of [ld] and
      [include-book]

  [Book-compiled-file]
      Creating and loading of compiled and expansion files for [books]

  [Cbd]
      Connected book directory string

  [Certify-book]
      How to produce a [certificate] for a book

  [Certify-book-debug]
      Some possible ways to work around [certify-book] failures

  [Delete-include-book-dir]
      Unlink keyword for :dir argument of [ld] and [include-book]

  [Delete-include-book-dir!]
      Non-[local]ly unlink keyword for :dir argument of [ld] and
      [include-book]

  [Full-book-name]
      Book naming conventions assumed by ACL2

  [Include-book]
      Load the [events] in a file

  [Pathname]
      Introduction to filename conventions in ACL2

  [Set-cbd]
      To set the connected book directory

  [Set-write-ACL2x]
      Cause [certify-book] to write out a .acl2x file")
 (BOOKS-TOUR
  (BOOKS)
  "The guided tour of concepts related to ACL2 [books].

  The tour begins with [book-example].


Subtopics

  [Book-contents]
      Restrictions on the forms inside [books]

  [Book-example]
      How to create, certify, and use a simple book

  [Book-name]
      Conventions associated with book names

  [Certificate]
      A file specifying validity of a given book

  [Certify-book]
      How to produce a [certificate] for a book

  [Include-book]
      Load the [events] in a file

  [Keep]
      How we know if [include-book] read the correct files

  [Portcullis]
      The gate guarding the entrance to a certified book")
 (BOOLE$
  (NUMBERS ACL2-BUILT-INS)
  "Perform a bit-wise logical operation on 2 two's complement integers

  When integers x and y are viewed in their two's complement
  representation, (boole$ op x y) returns the result of applying the
  bit-wise logical operation specified by op.  The following table is
  adapted from documentation for the analogous Common Lisp function
  {boole |
  http://www.lispworks.com/documentation/HyperSpec/Body/f_boole.htm}
  in the {Common Lisp Hyperspec |
  http://www.lispworks.com/documentation/HyperSpec/}.  Note that the
  values of op for boole$ are ACL2 constants, rather than
  corresponding values of op for the Common Lisp function boole.

    op               result
    -----------      ---------
    *boole-1*        x
    *boole-2*        y
    *boole-andc1*    and complement of x with y
    *boole-andc2*    and x with complement of y
    *boole-and*      and
    *boole-c1*       complement of x
    *boole-c2*       complement of y
    *boole-clr*      the constant 0 (all zero bits)
    *boole-eqv*      equivalence (exclusive nor)
    *boole-ior*      inclusive or
    *boole-nand*     not-and
    *boole-nor*      not-or
    *boole-orc1*     or complement of x with y
    *boole-orc2*     or x with complement of y
    *boole-set*      the constant -1 (all one bits)
    *boole-xor*      exclusive or

  The guard of boole$ specifies that op is the value of one of the
  constants above and that x and y are integers.

  See any Common Lisp documentation for analogous information about
  Common Lisp function boole.

  Function: <boole$>

    (defun boole$ (op i1 i2)
           (declare (type (integer 0 15) op)
                    (type integer i1 i2))
           (cond ((eql op *boole-1*) i1)
                 ((eql op *boole-2*) i2)
                 ((eql op *boole-and*) (logand i1 i2))
                 ((eql op *boole-andc1*)
                  (logandc1 i1 i2))
                 ((eql op *boole-andc2*)
                  (logandc2 i1 i2))
                 ((eql op *boole-c1*) (lognot i1))
                 ((eql op *boole-c2*) (lognot i2))
                 ((eql op *boole-clr*) 0)
                 ((eql op *boole-eqv*) (logeqv i1 i2))
                 ((eql op *boole-ior*) (logior i1 i2))
                 ((eql op *boole-nand*) (lognand i1 i2))
                 ((eql op *boole-nor*) (lognor i1 i2))
                 ((eql op *boole-orc1*) (logorc1 i1 i2))
                 ((eql op *boole-orc2*) (logorc2 i1 i2))
                 ((eql op *boole-set*) 1)
                 ((eql op *boole-xor*) (logxor i1 i2))
                 (t 0)))")
 (BOOLEAN-LISTP
  (BOOLEANP LISTS ACL2-BUILT-INS)
  "Recognizer for a true list of booleans

  The predicate boolean-listp tests whether its argument is a
  [true-listp] of objects each or which satisfies [booleanp], i.e.,
  is t or nil.

  Function: <boolean-listp>

    (defun boolean-listp (lst)
           (declare (xargs :guard t))
           (cond ((atom lst) (eq lst nil))
                 (t (and (or (eq (car lst) t) (eq (car lst) nil))
                         (boolean-listp (cdr lst))))))")
 (BOOLEANP
  (BASICS ACL2-BUILT-INS)
  "Recognizer for booleans

  (Booleanp x) is t if x is t or nil, and is nil otherwise.

  See [generalized-booleans] for a discussion of a potential soundness
  problem for ACL2 related to the question: Which Common Lisp
  functions are known to return Boolean values?

  Function: <booleanp>

    (defun booleanp (x)
           (declare (xargs :guard t))
           (if (eq x t) t (eq x nil)))


Subtopics

  [Boolean-listp]
      Recognizer for a true list of booleans")
 (BOUNDERS
  (TAU-SYSTEM)
  "Intervals, bounder functions, and bounder correctness

    Bounder Forms 1 and 2:
    (implies (and (tau-intervalp i1)
                  ...
                  (or (equal (tau-interval-dom i1) 'dom1-1)
                      ...)
                  ...
                  (in-tau-intervalp x1 i1)
                  ...)
             (and (tau-intervalp (bounder-fn i1 ...))
                  (in-tau-intervalp target
                                    (bounder-fn i1 ...))))

  where target is either (fn x1 ... y1 ...) or (mv-nth 'n (fn x1 ... y1
  ...)), depending on whether we are in the Form 1 or Form 2 case,
  respectively.  However, the shape above is meant just as a
  reminder.  Details are given below.

  This topic first explains the basic shape of Bounder Form 1.  Then it
  illustrates Bounder Form 2.  Finally, it deals briefly with proving
  bounder correctness theorems.  The community book
  tau-bounders/elementary-bounders contains bounders for various
  elementary functions including [+], [*], [/], [floor], [mod],
  [logand], [lognot], [logior], [logorc1], [logeqv], [logxor], and
  [ash].  You might look at or include this book to see more example
  theorems, to see how proofs of such theorems are managed, and to
  experiment with their effects on proving theorems involving
  arithmetic over finite or half-finite intervals.

  A bounder correctness theorem establishes that bounder-fn is a
  ``bounder'' for the function fn.  That means that when trying to
  compute a tau for a call of fn (or, in the case of Form 2, for the
  nth component of the multiple-value vector returned by a call of
  fn) the tau system can call bounder-fn on the intervals containing
  certain arguments of fn.

  Let us start with an example.  Let fn be the addition function, +
  (actually, [binary-+]).  Consider the target term (+ x y) and
  contemplate the question: if you know intervals containing x and y,
  say intx and inty respectively, what is an interval containing
  their sum?  The answer is pretty easy to state in English: the
  domain of the answer interval is the less restrictive of the
  domains of intx and inty.  The lower bound of the answer interval
  is the sum of the lower bounds of intx and inty, and the lower
  relation is the stronger of the lower relations of intx and inty.
  Analogous comments define the upper bound and relation of the
  answer interval.  So for example, if x is an INTEGERP such that 0
  <= x <= 10 and y is a RATIONALP such that 0 < y <= 20, then (+ x y)
  is a RATIONALP such that 0 < (+ x y) <= 30.

  Defining this precisely is more tedious than describing it in English
  because one must make precise the notions of ``less restrictive''
  domains, ``weaker'' relations, and the possibility that either or
  both of the bounds could be ``infinite.'' But we can easily imagine
  defining the function bounder-for-+ that returns the answer
  interval described, given intx and inty.

  Then the following Bounder Form 1 formula establishes the correctness
  of bounder-for-+ and allows the tau system to use it to produce
  bounds in the tau computed for +-expressions:

    (implies (and (tau-intervalp intx)
                  (tau-intervalp inty)
                  (in-tau-intervalp x intx)
                  (in-tau-intervalp y inty))
             (and (tau-intervalp (bounder-for-+ intx inty))
                  (in-tau-intervalp (+ x y)
                                    (bounder-for-+ intx inty))))

  For example, suppose we have a formula with the following hypotheses

    (and (integerp a)
         (<= 0 a)
         (<= a 10)
         (rationalp b)
         (< 0 b)
         (<= b 20))

  and suppose the tau system encounters the term (+ a b).  When the
  term is encountered, the tau for a would include an INTEGERP
  interval such that 0 <= a <= 10 and the tau for b would include a
  RATIONALP interval such that 0 < b <= 20.  In its most primitive
  configuration, the tau system would only know that the tau for (+ a
  b) includes the recognizer RATIONALP (and all that it is known to
  imply).  But after the bounder theorem above is proved and
  available as a :tau-system rule the tau system would infer that (+
  a b) was in the RATIONALP interval such that 0 < (+ a b) <= 30.

  Thus, by defining bounder functions and proving them correct the user
  can give the tau system the ability to compute the bounds on
  function calls as a function of the known bounds on their actuals.

  It is sometimes useful to restrict the domains of the intervals to be
  considered.  For example, in bounding *-expressions it is
  simplifying to restrict one's attention to intervals over the
  integers or rationals (and thus exclude the complex rationals so
  one need not think about the getting negative bounds by multiplying
  two ``positive'' complex rationals or how to ``round up'' from
  complex bounds to the rationals required by our intervals).

  If we were to define bounder-for-* so that it works correctly to
  bound *-expressions, but only for integer or rational arguments,
  its correctness theorem would be:

    (implies (and (tau-intervalp intx)                             ; (a)
                  (tau-intervalp inty)
                  (or (equal (tau-interval-dom intx) 'INTEGERP)    ; (b)
                      (equal (tau-interval-dom intx) 'RATIONALP))
                  (or (equal (tau-interval-dom inty) 'INTEGERP)
                      (equal (tau-interval-dom inty) 'RATIONALP))
                  (in-tau-intervalp x intx)                        ; (c)
                  (in-tau-intervalp y inty))
             (and (tau-intervalp (bounder-for-* intx inty))       ; (d)
                  (in-tau-intervalp (* x y)                        ; (e)
                                    (bounder-for-* intx inty))))

  In this case, bounder-for-* would be applied to the intervals for x
  and y only if those intervals were over the integers or the
  rationals.

  The above theorem for bounder-for-* begins to suggest the general
  form of a bounder theorem and we will use it to explain the general
  form.

  The hypotheses of a bounder theorem must be a conjunction and the
  conjuncts must be partitionable into three parts, (a), (b), and
  (c).  The conclusion, must be a conjunction, must contain at least
  two conjuncts, (d) and (e), and is allowed to contain others that
  are simply ignored for purposes of bounders.  (See the note below
  about why we allow but ignore additional conjuncts in the
  conclusion.)

  Part (a) introduces some distinct ``interval variables,'' here called
  ``ivars,'' that are known to denote intervals; for the example
  above, the ivars are intx and inty.  Each hypothesis in part (a) is
  of the form (TAU-INTERVALP ivar).

  Part (b) allows us to restrict the domains of some of the intervals.
  Each hypothesis in part (b) must be a disjunction and each of the
  disjuncts must be of the form (EQUAL (TAU-INTERVAL-DOM ivar) 'dom),
  where ivar is one of the interval variables and dom is one of
  INTEGERP, RATIONALP, ACL2-NUMBERP, or NIL.  It is not necessary to
  restrict every interval variable.  Indeed, part (b) may be empty,
  as in the theorem for bounder-for-+ above.

  Part (c) consists of a set of (IN-TAU-INTERVALP avar ivar) hypotheses
  where each avar is a variable and no two hypotheses in part (c) use
  the same avar or ivar.  We call the set of all such avar the
  ``actual variables'' or ``avars.'' The avars and ivars must be
  distinct.  Part (c) sets up a correspondence between the avars and
  the ivars, each avar is in an interval denoted by one ivar.

  Part (d) introduces the name of the bounder function, here
  bounder-for-*, and the order of its ivar arguments.  We see that
  bounder-for-* takes two arguments and they correspond, in order, to
  the intervals containing x and y.  Part (d) also establishes that
  the bounder function always returns an interval under hypotheses
  (a), (b), and (c).  Note that it is sometimes useful to return the
  ``universal interval'' (one that contains everything) if you don't
  want to compute a better interval for some case; see
  [tau-intervalp] or [in-tau-intervalp].

  Part (e) introduces the name of the function being bounded, here *,
  and the order of its arguments.  It establishes that the function
  being bounded really is bounded by the interval computed by the
  bounder function.  In general, the function being bounded may take
  additional arguments.  It is possible that the function being
  bounded takes some arguments that do not affect the bounds of its
  output.

  Thus, parts (c) and (e) together establish a mapping between the
  actuals of a call of the function being bounded and the intervals
  to be supplied to the bounder.

  The parts identified above may be presented in any order and the
  literals constituting those parts may be mingled.  Thus, for
  example, here is another version of the theorem above that
  generates the same bounding information for the tau system.  In
  this version, the hypotheses and conclusions are rearranged,
  bounder-for-* takes its arguments in the opposite order, and the
  theorem includes an additional conclusion.

    (implies (and (tau-intervalp intx)                             ; (a)
                  (or (equal (tau-interval-dom intx) 'INTEGERP)    ; (b)
                      (equal (tau-interval-dom intx) 'RATIONALP))
                  (in-tau-intervalp x intx)                        ; (c)

                  (tau-intervalp inty)                             ; (a)
                  (or (equal (tau-interval-dom inty) 'INTEGERP)    ; (b)
                      (equal (tau-interval-dom inty) 'RATIONALP))
                  (in-tau-intervalp y inty))
             (and (in-tau-intervalp (* x y)                        ; (e)
                                    (bounder-for-* inty intx))
                  (tau-intervalp (bounder-for-* inty intx))        ; (d)))

                  (or (equal (tau-interval-dom (bounder-for-* inty intx))
                             'INTEGERP)
                      (equal (tau-interval-dom (bounder-for-* inty intx))
                             'RATIONALP))

  Note on why bounder forms allow additional conjuncts in the
  conclusion: It is often the case that one creates bounders by
  composing other bounders.  To prove compositional bounds correct
  one must often prove more than the mere correctness of the
  components.  For example, one might need to prove that the domain
  of the new bounding interval is INTEGERP or otherwise restricted.
  We allow such ``unnecessary'' conclusions simply to save the user
  the burden of stating multiple theorems.

  An Illustration of Bounder Form 2: Suppose (quad i) is defined so
  that truncates the integer i to the largest multiple of 4 weakly
  below i and, additionally, returns the remainder.  For example,
  (quad 26) returns (mv 24 2).  Then here are bounders for each of
  its return values:

    (defun quad-bounds-0 (i)
      (cond ((and (tau-interval-lo i)
                  (<= 0 (tau-interval-lo i)))
             (make-tau-interval 'integerp nil 0 nil (tau-interval-hi i)))
            (t (make-tau-interval nil nil nil nil nil))))

    (defun quad-bounds-1 (i)
      (cond ((and (tau-interval-lo i)
                  (<= 0 (tau-interval-lo i)))
             (make-tau-interval 'integerp nil 0 nil 3))
            (t (make-tau-interval nil nil nil nil nil))))

  Note that the bounders assume i is an INTEGERP and return the
  universal interval when i is not a natural.

  As noted in the discussion below about how to prove bounder
  correctness theorems, proving these bounders correct will require
  an arithmetic book, e.g.,

    (include-book \"arithmetic-5/top\" :dir :system)

  Here then are two bounder correctness theorems of Form 2:

    (defthm quad-bounds-0-correct
      (implies (and (tau-intervalp i)
                    (equal (tau-interval-dom i) 'INTEGERP)
                    (in-tau-intervalp x i))
               (and (tau-intervalp (quad-bounds-0 i))
                    (in-tau-intervalp (mv-nth 0 (quad x))
                                      (quad-bounds-0 i))))
      :rule-classes :tau-system)

    (defthm quad-bounds-1-correct
      (implies (and (tau-intervalp i)
                    (equal (tau-interval-dom i) 'INTEGERP)
                    (in-tau-intervalp x i))
               (and (tau-intervalp (quad-bounds-1 i))
                    (in-tau-intervalp (mv-nth 1 (quad x)) (quad-bounds-1 i))))
      :rule-classes :tau-system)

  As noted above, if these bounders are to be used in constructing
  other bounders, we might include (in the first theorem) an
  additional concluding conjunct, such as

    (equal (tau-interval-dom (quad-bounds-0 i)) 'INTEGERP)

  so that we can keep quad-bounds-0 disabled to allow us to use
  quad-bounds-0-correct as a :rewrite or other rule and still relieve
  hypotheses about the domain of the interval it produces.  These
  hypotheses would arise if some other verified bounder was called on
  the produced interval.  In addition, as noted below, we might
  replace the :rule-classes above with

    :rule-classes
     ((:rewrite)
      (:forward-chaining :trigger-terms ((quad-bounds-0 i))))

  Since the theorem is being stored as some kind of rule and since it
  satisfies the Bounder Form 2 shape, it will additionally be stored
  as a :tau-system rule.

  Note on proving bounder theorems: Proving bounder theorems is just
  like proving any other arithmetic theorem and you will need
  whatever libraries are appropriate for the problem domain you are
  working in.  Do not expect the tau system to be of much use in
  proving bounder theorems.  A typical bounder theorem might require
  you to prove a subgoal like (< (fn x y) (g (tau-interval-hi int1)
  int2)).  But tau deals with inequalities relating terms to
  constants, e.g., (< ... 16).  A bounder theorem is a sort of
  ``metatheorem'' about how to construct bounded intervals from other
  bounded intervals.  So when you undertake to define a bounder and
  prove it correct, go into the project with your eyes open!

  But bounder functions can be broadly divided into two classes, those
  defined in terms of arithmetic on the interval bounds and those
  defined in terms of other bounders.  For example, given that

    (LOGXOR x y) = (LOGNOT (LOGEQV x y))

  an interval for bounding LOGXOR can be constructed by composing the
  constructions of intervals for LOGEQV and LOGNOT.  So some bounder
  correctness proofs will involve direct manipulation of arithmetic
  inequalities and others might involve appeal to the correctness of
  other bounders, depending on how the new bounder is defined.

  Regardless of which style of bounder we are dealing with, we have
  found it useful to prove the basic theorems relating the tau
  interval accessors to [make-tau-interval], e.g.,

    (equal (tau-interval-dom (make-tau-interval dom lo-rel lo hi-rel hi)) dom)

  and then disable those functions to avoid seeing excessive cars and
  cdrs.

  When dealing with bounders defined in the direct, arithmetic style,
  we tend to keep [tau-intervalp] and [in-tau-intervalp] enabled so
  they unfold and expose the algebra.

  When dealing with bounders defined compositionally in terms of other
  verified bounders, we tend to keep [tau-intervalp] and
  [in-tau-intervalp] disabled so we can rely on the previously proved
  bounder theorems as rewrite and forward chaining rules.

  Note that this last remark means that when you prove bounder
  correctness theorems you should include corollaries that are useful
  :rewrite and possibly :forward-chaining rules if you anticipate
  using that bounder in more complex ones.  We tend to trigger the
  forward chaining with the bounder expression itself, rather than
  one of the hypotheses.  For example in the rule above for
  bounder-for-* we would include (:forward-chaining :trigger-terms
  ((tau-bounder-expt2 int2))) and let the in-tau-intervalp hypotheses
  select the free variables x and y.")
 (BREAK$
  (ERRORS ACL2-BUILT-INS)
  "Cause an immediate Lisp break

  ACL2 users are generally advised to avoid breaking into raw Lisp.
  Advanced users may, on occasion, see the need to do so.  Evaluating
  (break$) will have that effect.  (Exception: break$ is disabled
  after evaluation of (set-debugger-enable :never); see
  [set-debugger-enable].)  Break$ returns nil.

  Function: <break$>

    (defun break$ nil (declare (xargs :guard t))
           nil)")
 (BREAK-LEMMA
  (BREAK-REWRITE)
  "A quick introduction to breaking rewrite rules in ACL2

    Example:
    :brr t                          ; if you haven't done that yet
    :monitor (:rewrite lemma12) t   ; to install a break point on the
                                    ;   rule named (:rewrite lemma12)
    :monitor! (:rewrite lemma12) t  ; quiet version of :monitor that
                                    ;   invokes :brr t

  ACL2 does not support Nqthm's break-lemma but supports a very similar
  and more powerful break facility.  Suppose some proof is failing;
  apparently some particular rule is not being used and you wish to
  learn why.  Then you need the ACL2 [break-rewrite] facility.  See
  [break-rewrite] and all of its associated :[doc] topics for
  details.  The following basic steps are required.

  (1) To enable the ``break rewrite'' feature, you must first execute

    ACL2 !>:brr t

  at the top-level of ACL2.  Equivalently, evaluate (brr t).
  [Break-rewrite] stays enabled until you disable it with (brr nil).
  When [break-rewrite] is enabled the ACL2 rewriter will run slower
  than normal but you will be able to [monitor] the attempts to apply
  specified rules.

  (2) Decide what [rune]s (see [rune]) you wish to [monitor].  For
  example, you might want to know why (:rewrite lemma12 . 2) is not
  being used in the attempted proof.  That, by the way, is the name
  of the second rewrite rule generated from the event named lemma12.

  The command

    ACL2 !>:monitor (:rewrite lemma12 . 2) t

  will install an ``unconditional'' break point on that rule.  The
  ``t'' at the end of the command means it is unconditional, i.e., a
  break will occur every time the rule is tried.  ACL2 supports
  conditional breaks also, in which case the t is replaced by an
  expression that evaluates to non-nil when you wish for a break to
  occur.  See [monitor].  The above keyword command is, of course,
  equivalent to

    ACL2 !>(monitor '(:rewrite lemma12 . 2) t)

  which you may also type.  You may install breaks on as many rules as
  you wish.  You must use [monitor] on each rule.  You may also
  change the break condition on a rule with [monitor].  Use
  [unmonitor] (see [unmonitor]) to remove a rule from the list of
  [monitor]ed rules.

  (3) Then try the proof again.  When a [monitor]ed rule is tried by
  the rewriter you will enter an interactive break, called
  [break-rewrite].  See [break-rewrite] for a detailed description.
  Very simply, [break-rewrite] lets you inspect the context of the
  attempted application both before and after the attempt.  When
  [break-rewrite] is entered it will print out the ``target'' term
  being rewritten.  If you type :go [break-rewrite] will try the rule
  and then exit, telling you (a) whether the rule was applied, (b) if
  so, how the target was rewritten, and (c) if not, why the rule
  failed.  There are many other commands.  See [brr-commands].

  (4) When you have finished using the [break-rewrite] feature you
  should disable it to speed up the rewriter.  You can disable it
  with

    ACL2 !>:brr nil

  The list of [monitor]ed rules and their break conditions persists but
  is ignored.  If you enable [break-rewrite] later, the list of
  [monitor]ed rules will be displayed and will be used again by
  rewrite.

  You should disable the [break-rewrite] feature whenever you are not
  intending to use it, even if the list of [monitor]ed rules is
  empty, because the rewriter is slowed down as long as
  [break-rewrite] is enabled.

  If you get a stack overflow, see [cw-gstack].")
 (BREAK-ON-ERROR
  (TRACE ACL2-BUILT-INS)
  "Break when encountering a hard or soft error caused by ACL2

    General forms:
    (break-on-error t)    ; installs a trace causing a continuable error (break)
                          ;   when an error is invoked by ACL2.
    (break-on-error)      ; same as above
    (break-on-error :all) ; same as above, but even when inside the prover
    (break-on-error nil)  ; uninstall any above trace

  (Break-on-error) generates a suitable trace of error functions.
  Evaluate (trace$) after (break-on-error) if you want to see the
  specific trace forms (which you can modify and then submit directly
  to trace$, if you wish).  This [trace] should cause entry to the
  Lisp debugger whenever ACL2 calls its error routines, except for
  certain errors when inside the theorem prover, and also at those
  times if option :all is supplied.

  NOTE: For technical reasons, you may see some error messages more
  than once.

  Finally, note that you are welcome to define your own version of
  break-on-error by modifying a copy of the source definition (search
  for ``(defmacro break-on-error'' in ACL2 source file
  other-events.lisp).  Please feel free to send your version of
  break-on-error to the ACL2 implementors, for possible inclusion
  into ACL2.

  Break-on-error is implemented using ACL2 [trace$].  See [trace!] if
  you want an explanation of the ``TTAG NOTE'' that is printed.

  The argument, if supplied, is evaluated and must evaluate to t, nil,
  or :all.

  Also see [set-debugger-enable] for how to get raw-Lisp backtrace
  information when an error occurs as a result of break-on-error, or
  even of a raw Lisp error, by calling set-debugger-enable with
  argument :bt, :bt-break, or :break-bt.  Note that for ACL2 errors
  (as opposed to raw Lisp errors), i.e. errors affected by
  break-on-error, all three of those keyword values are treated
  equivalently (and, all are ignored for non-ANSI GCL; see
  [set-debugger-enable]).")
 (BREAK-REWRITE
  (DEBUGGING)
  "The read-eval-print loop entered to [monitor] rules

  ACL2 allows the user to [monitor] the application of [rewrite],
  [definition], and [linear] rules.  When [monitor]ed rules are about
  to be tried by the rewriter, an interactive break occurs and the
  user is allowed to watch and, in a limited sense, control the
  attempt to apply the rule.  This interactive loop, which is
  technically just a call of the standard top-level ACL2
  read-eval-print loop, [ld], on a ``[wormhole] [state]'' (see
  [wormhole]), is called ``break-rewrite.'' While in break-rewrite,
  certain keyword commands are available for accessing information
  about the context in which the lemma is being tried.  These
  keywords are called break-rewrite ``commands''; see [brr-commands].

  For a related utility, see [dmr] (Dynamically Monitor Rewrites),
  which allows you to watch progress of the rewriter in real time.

  To abort from inside break-rewrite at any time, execute :[a!].

  Output from break-rewrite is abbreviated by default, but that can be
  changed.  See [set-brr-evisc-tuple].

  For further information, see the related :[doc] topics listed below.

  It is possible to cause the ACL2 rewriter to [monitor] the attempted
  application of selected rules.  When such a rule is about to be
  tried, the rewriter evaluates its break condition and if the result
  is non-nil, break-rewrite is entered.

  Break-rewrite permits the user to inspect the current [state] by
  evaluating break-rewrite commands.  Type :help in break-rewrite to
  see what the break-rewrite commands are.  However, break-rewrite is
  actually just a call of the general ACL2 read-eval-print loop,
  [ld], on a certain [state] and the break-rewrite commands are
  simply aliases provided by ld-keyword-aliases [table] (see
  [ld-keyword-aliases]).  See [ld] for details about this
  read-eval-print loop.  Thus, with a few exceptions, anything you
  can do at the ACL2 top-level can be done within break-rewrite.  For
  example, you can evaluate arbitrary expressions, use the keyword
  command hack, access [documentation], print [events], and even
  define functions and prove theorems.  However, the ``certain
  [state]'' upon which [ld] was called is a ``wormhole state'' (see
  [wormhole]) because break-rewrite is not allowed to have any effect
  upon the behavior of rewrite.  What this means, at a high level, is
  that break-rewrite operates on a copy of the [state] being used by
  rewrite and when break-rewrite exits the [wormhole] closes and the
  [state] ``produced'' by break-rewrite disappears.  For example, all
  invocations of [trace$] and [untrace$] that are made during a break
  at a [monitor]ed [rune] are undone when proceeding from that break.
  Thus, break-rewrite lets you query the state of the rewriter and
  even do experiments involving proofs, etc., but these experiments
  have no effect on the ongoing proof attempt.

  There are however exceptions to this loss of state when exiting a
  break.  One exception is that the effect of turning on iprinting in
  a break (see [set-iprint]) will persist even after exiting the
  break.  The other exceptions pertain to setting the
  [brr-evisc-tuple] or invoking [monitor] or [unmonitor]: if these
  are done inside the break-rewrite loop at level 1 of interaction
  (i.e., at the top level) then their effects will persist even after
  exiting the break.

  When you first enter break-rewrite a simple herald is printed such
  as:

    (3 Breaking (:rewrite lemma12) on (delta a (+ 1 j)):

  The integer after the open parenthesis indicates the depth of nested
  break-rewrite calls.  In this discussion we use 3 consistently for
  this integer.  Unless you abort or somehow enter unbalanced
  parentheses into the script, the entire session at a given depth
  will be enclosed in balanced parentheses, making it easy to skip
  over them in Emacs.

  You then will see the break-rewrite [prompt]:

    3 ACL2 !>

  The leading integer is, again, the depth.  Because breaks often occur
  recursively it is convenient always to know the level with which
  you are interacting.

  You may type arbitrary commands as in the top-level ACL2 loop.  For
  example, you might type:

    3 ACL2 !>:help

  or

    3 ACL2 !>:pe lemma12

  Exceptions are that :[ubt] and related commands such as :[ubu], as
  well as [puff] and [puff*], are only allowed to touch [command]s
  issued after entering the interactive break.  (Technical detail:
  that is because [disable-ubt] is invoked when entering the break.)

  More likely than typing a history command, upon entering
  break-rewrite you will determine the context of the attempted
  application.  Here are some useful commands:

    3 ACL2 >:target           ; the term being rewritten
    3 ACL2 >:unify-subst      ; the unifying substitution
    3 ACL2 >:path             ; the stack of goals pursued by the rewriter
                              ; starting at the top-level clause being simplified
                              ; and ending with the current application

  At this point in the interaction the system has not yet tried to
  apply the [monitor]ed rule.  That is, it has not tried to establish
  the hypotheses, considered the heuristic cost of backchaining,
  rewritten the right-hand side of the conclusion, etc.  When you are
  ready for it to try the rule you can type one of several different
  ``proceed'' commands.  The basic proceed commands are :ok, :go, and
  :eval.

    :ok

  exits break-rewrite without further interaction.  When break-rewrite
  exits it prints ``3)'', closing the parenthesis that opened the
  level 3 interaction.

    :go

  exits break-rewrite without further interaction, but prints out the
  result of the application attempt, i.e., whether the application
  succeeded, if so, what the :target term was rewritten to, and if
  not why the rule was not applicable.

    :eval

  causes break-rewrite to attempt to apply the rule but interaction at
  this level of break-rewrite resumes when the attempt is complete.
  When control returns to this level of break-rewrite a message
  indicating the result of the application attempt (just as in :go)
  is printed, followed by the [prompt] for additional user input.

  Generally speaking, :ok and :go are used when the break in question
  is routine or uninteresting and :eval is used when the break is one
  that the user anticipates is causing trouble.  For example, if you
  are trying to determine why a lemma isn't being applied to a given
  term and the :target of the current break-rewrite is the term in
  question, you would usually :eval the rule and if break-rewrite
  reports that the rule failed then you are in a position to
  determine why, for example by carefully inspecting the
  :[type-alist] of governing assumptions or why some hypothesis of
  the rule could not be established.

  It is often the case that when you are in break-rewrite you wish to
  change the set of [monitor]ed [rune]s.  This can be done by using
  :[monitor] and :[unmonitor] as noted above.  For example, you might
  want to [monitor] a certain rule, say hyp-reliever, just when it is
  being used while attempting to apply another rule, say main-lemma.
  Typically then you would [monitor] main-lemma at the ACL2
  top-level, start the proof-attempt, and then in the break-rewrite
  in which main-lemma is about to be tried, you would install a
  [monitor] on hyp-reliever.  If during the ensuing :eval
  hyp-reliever is broken you will know it is being used under the
  attempt to apply main-lemma.

  However, once hyp-reliever is being [monitor]ed it will be
  [monitor]ed even after main-lemma has been tried.  That is, if you
  let the proof attempt proceed then you may see many other breaks on
  hyp-reliever, breaks that are not ``under'' the attempt to apply
  main-lemma.  One way to prevent this is to :eval the application of
  main-lemma and then :[unmonitor] hyp-reliever before exiting.  But
  this case arises so often that ACL2 supports several additional
  ``flavors'' of proceed commands.

  :Ok!, :go!, and :eval! are just like their counterparts (:ok, :go,
  and :eval, respectively), except that while processing the rule
  that is currently broken no [rune]s are [monitor]ed.  When
  consideration of the current rule is complete, the set of
  [monitor]ed [rune]s is restored to its original setting.

  :Ok$, :go$, and :eval$ are similar but take an additional argument
  which must be a list of [rune]s.  An example usage of :eval$ is

    3 ACL2 !>:eval$ ((:rewrite hyp-reliever))

  These three commands temporarily install unconditional breaks on the
  [rune]s listed, proceed with the consideration of the currently
  broken rule, and then restore the set of [monitor]ed rules to its
  original setting.

  Thus, there are nine ways to proceed from the initial entry into
  break-rewrite although we often speak as though there are two, :ok
  and :eval, and leave the others implicit.  We group :go with :ok
  because in all their flavors they exit break-rewrite without
  further interaction (at the current level).  All the flavors of
  :eval require further interaction after the rule has been tried.

  To abort a proof attempt and return to the top-level of ACL2 you may
  at any time type (a!) followed by a carriage return.  If you are
  not in a raw Lisp break, you may type :a! instead.  The utility p!
  is completely analogous to a! except that it pops up only one [ld]
  level.  If you have just entered the break-rewrite loop, this will
  pop you out of that loop, back to the proof.  See [a!] and see
  [p!].

  We now address ourselves to the post-:eval interaction with
  break-rewrite.  As noted, that interaction begins with
  break-rewrite's report on the results of applying the rule: whether
  it worked and either what it produced or why it failed.  This
  information is also printed by certain keyword commands available
  after :eval, namely :wonp, :rewritten-rhs or (for [linear] rules)
  :poly-list, and :failure-reason.  In addition, by using [brr@] you
  can obtain this information in the form of ACL2 data objects.  This
  allows the development of more sophisticated ``break conditions'';
  see [monitor] for examples.  In this connection we point out the
  macro form (ok-if term).  See [ok-if].  This command exits
  break-rewrite if term evaluates to non-nil and otherwise does not
  exit.  Thus it is possible to define macros that provide other
  kinds of exits from break-rewrite.  The only way to exit
  break-rewrite after :eval is :ok (or, equivalently, the use of
  [ok-if]).

  Note that when inside break-rewrite, all [history] commands, such as
  :[pe], show the [enable]d status of rules with respect to the
  current point in the proof attempt.  For example, if you break
  while the prover is working on Subgoal 3, and the [hints] supplied
  for the proof specify (\"Subgoal 3\" :in-theory (disable foo)) for
  some rule foo, then :[pe] will indicate that foo is [disable]d:
  even though foo may be enabled globally, it is shown as disabled
  because it is disabled during Subgoal 3.  See subtopics of
  [history] for a list of all such history commands.  In addition to
  those commands, the function [disabledp] is also evaluated inside
  break-rewrite with respect to the current enabled state of the
  prover.

  ACL2 users who wish to know more about break-rewrite so that they can
  develop more convenient ways to [monitor] rules are encouraged to
  speak to J Moore.

  The rest of this [documentation] discusses a few implementation
  details of break-rewrite and may not be interesting to the typical
  user.

  There is no ACL2 function named break-rewrite.  It is an illusion
  created by appropriate calls to two functions named brkpt1 and
  brkpt2.  As previously noted, break-rewrite is [ld] operating on a
  [wormhole] [state].  One might therefore wonder how break-rewrite
  can apply a rule and then communicate the results back to the
  rewriter running in the external [state].  The answer is that it
  cannot.  Nothing can be communicated through a [wormhole].  In
  fact, brkpt1 and brkpt2 are each calls of [ld] running on
  [wormhole] [state]s.  Brkpt1 implements the pre-:eval break-rewrite
  and brkpt2 implements the post-:eval break-rewrite.  The rewriter
  actually calls brkpt1 before attempting to apply a rule and calls
  brkpt2 afterwards.  In both cases, the rewriter passes into the
  [wormhole] the relevant information about the current context.
  Logically brkpt1 and brkpt2 are no-ops and [rewrite] ignores the
  nil they return.  But while control is in them, the execution of
  [rewrite] is suspended and cannot proceed until the break-rewrite
  interactions complete.

  This design causes a certain anomaly that might be troubling.
  Suppose that inside break-rewrite before :evaling a rule (i.e., in
  the brkpt1 [wormhole] [state]) you define some function, foo.
  Suppose then you :eval the rule and eventually control returns to
  break-rewrite (i.e., to brkpt2 on a [wormhole] [state] with the
  results of the application in it).  You will discover that foo is
  no longer defined!  That is because the [wormhole] [state] created
  during your pre-:eval interaction is lost when we exit the
  [wormhole] to resume the proof attempt.  The post-:eval [wormhole]
  [state] is in fact identical to the initial pre-:eval [state]
  (except for the results of the application) because [rewrite] did
  not change the external [state] and both [wormhole] [state]s are
  copies of it.  A similar issue occurs with the use of [trace]
  utilities: all effects of calling [trace$] and [untrace$] are
  erased when you proceed from a break in the break-rewrite loop.

  See the subtopics listed below to learn more about break-rewrite.


Subtopics

  [Break-lemma]
      A quick introduction to breaking rewrite rules in ACL2

  [Brr]
      To enable or disable the breaking of rewrite rules

  [Brr-commands]
      [Break-Rewrite] Commands

  [Brr@]
      To access context sensitive information within [break-rewrite]

  [Cw-gstack]
      Debug a rewriting loop or stack overflow

  [Dmr]
      Dynamically monitor rewrites and other prover activity

  [Monitor]
      To monitor the attempted application of a rule name

  [Monitor!]
      A quiet combination of [monitor] and [brr]

  [Monitored-runes]
      Print the [monitor]ed [rune]s and their break conditions

  [Ok-if]
      Conditional exit from break-rewrite

  [Unmonitor]
      To stop monitoring a rule name

  [Why-brr]
      An explanation of why ACL2 has an explicit [brr] mode

  [Windows-installation]
      Installing ACL2 on Windows")
 (BREAKS
  (ERRORS)
  "Common Lisp breaks

    Example:
    Broken at PROVE.  Type :H for Help.
    >>:Q

    ACL2 !>

  You may interrupt the system by typing various control character
  sequences.  The precise sequences are determined by the host Lisp
  and operating system environment.  For example, in GCL and Allegro
  Common Lisp, a console interrupt is caused by typing ``ctrl-c''.
  If, however, the GCL or Allegro is running in an Emacs shell
  buffer, one must type ``ctrl-c ctrl-c''.

  If a break occurs, for example because of a bug in ACL2 or a user
  interrupt, the break will run a Common Lisp read-eval-print loop,
  not an ACL2 read-eval-print loop.  This may not be obvious if the
  [prompt]s in the two loops are similar.  Because you are typing to
  a Common Lisp evaluator, you must be careful.  It is possible to
  damage your ACL2 state in irreparable ways by executing non-ACL2
  Common Lisp.  It is even possible to disrupt and render inaccurate
  the interrupted evaluation of a simple ACL2 expression.

  For ACL2 built on most host Common Lisps, you will see the string
  [RAW LISP] in the [prompt] at a break, to emphasize that one is
  inside a break and hence should quit from the break.  For some host
  Common Lisps, the top-level prompt also contains the string [RAW
  LISP].  See [prompt] for how to control printing of that string.

  The most reliable way to return to the ACL2 top level is by executing
  the following command: ([abort!]).  Appropriate cleanup will then
  be done, which should leave you in an appropriate state.

  However, you may be able to quit from the break in the normal Lisp
  manner (as with :q in GCL or CCL, :reset in Allegro CL, and q in
  CMU CL).  If this attempt to quit is successful, it will return you
  to the innermost ACL2 read-eval-print loop, with appropriate
  cleanup performed first.  Note that if you are within a [brr]
  environment when the break occurs, quitting from the break will
  only return you to that environment, not to the top of ACL2's
  read-eval-print loop.")
 (BROKEN-LINK
  (DOCUMENTATION)
  "Placeholder for link to documentation that resides in the community
  books

  You may have attempted to access information about the ACL2
  [community-books] while looking at the ACL2 User's Manual, which
  contains [documentation] only about the ACL2 system, and does not
  include documentation from the [community-books].  Please point
  your browser at the {ACL2+Books Manual |
  http://www.cs.utexas.edu/users/moore/acl2/v8-5/combined-manual/index.html}
  (or if browsing in [ACL2-Doc], switch to that manual with meta-0 I)
  to access the desired topic.

  If you want information about the book where your missing topic is
  defined, see [broken-link-table].


Subtopics

  [Broken-link-table]
      Map [documentation] topics to the community books that define them")
 (BROKEN-LINK-TABLE
  (BROKEN-LINK)
  "Map [documentation] topics to the community books that define them

  The table below maps topics to book locations that reside only in the
  ACL2+Books combined manual, not the ACL2 User's Manual.  For
  example, the entry

    (b* \"[books]/std/util/bstar.lisp\")

  signifies that the topic B* is documented in the community book
  std/util/bstar.lisp.

      ((*acl2-system-exports* \"[books]/system/acl2-system-exports.lisp\")
       (<< \"[books]/misc/total-order.lisp\")
       (add-io-pairs \"[books]/std/util/add-io-pairs.lisp\")
       (append-without-guard \"[books]/std/lists/flatten.lisp\")
       (oslib::argv \"[books]/oslib/argv-logic.lisp\")
       (arith-equivs \"[books]/std/basic/arith-equiv-defs.lisp\")
       (arithmetic \"[books]/doc/more-topics.lisp\")
       (arithmetic-1 \"[books]/arithmetic/top.lisp\")
       (arithmetic/natp-posp \"[books]/arithmetic/natp-posp.lisp\")
       (arity+ \"[books]/kestrel/std/system/arity-plus.lisp\")
       (assert! \"[books]/std/testing/assert-bang.lisp\")
       (assert!-stobj \"[books]/std/testing/assert-bang-stobj.lisp\")
       (b* \"[books]/std/util/bstar.lisp\")
       (bridge \"[books]/centaur/bridge/top.lisp\")
       (build::cert.pl \"[books]/build/doc.lisp\")
       (build::cert_param \"[books]/build/doc.lisp\")
       (cgen \"[books]/acl2s/cgen/top.lisp\")
       (checkpoint-list \"[books]/kestrel/utilities/checkpoints-doc.lisp\")
       (consideration \"[books]/hints/consider-hint.lisp\")
       (build::custom-certify-book-commands \"[books]/build/doc.lisp\")
       (std::defaggregate \"[books]/std/util/defaggregate.lisp\")
       (defconsts \"[books]/std/util/defconsts.lisp\")
       (defdata \"[books]/acl2s/defdata/top.lisp\")
       (define \"[books]/std/util/define.lisp\")
       (defmac \"[books]/misc/defmac.lisp\")
       (defmacroq \"[books]/kestrel/utilities/defmacroq.lisp\")
       (fty::defprod \"[books]/centaur/fty/top.lisp\")
       (defpun \"[books]/misc/defpun.lisp\")
       (defthm<w \"[books]/kestrel/utilities/auto-instance.lisp\")
       (defthmg \"[books]/tools/defthmg.lisp\")
       (acl2s::defunc \"[books]/acl2s/defunc.lisp\")
       (defxdoc \"[books]/xdoc/topics.lisp\")
       (getopt-demo::demo2 \"[books]/centaur/getopt/demo2.lisp\")
       (developers-guide \"[books]/system/doc/developers-guide.lisp\")
       (developers-guide-utilities
            \"[books]/system/doc/developers-guide.lisp\")
       (do-not-hint \"[books]/tools/do-not.lisp\")
       (easy-simplify-term \"[books]/tools/easy-simplify.lisp\")
       (er-soft+ \"[books]/kestrel/utilities/er-soft-plus.lisp\")
       (er-soft-logic \"[books]/tools/er-soft-logic.lisp\")
       (final-cdr \"[books]/std/lists/final-cdr.lisp\")
       (fty \"[books]/centaur/fty/top.lisp\")
       (getopt \"[books]/centaur/getopt/top.lisp\")
       (gl \"[books]/centaur/gl/doc.lisp\")
       (hacker \"[books]/hacking/hacking-xdoc.lisp\")
       (ihs \"[books]/ihs/ihs-doc-topic.lisp\")
       (include-raw \"[books]/tools/include-raw.lisp\")
       (install-not-normalized \"[books]/misc/install-not-normalized.lisp\")
       (list-equiv \"[books]/std/lists/equiv.lisp\")
       (list-fix \"[books]/std/lists/list-fix.lisp\")
       (logbitp-reasoning \"[books]/centaur/bitops/equal-by-logbitp.lisp\")
       (make-flag \"[books]/tools/flag.lisp\")
       (make-termination-theorem
            \"[books]/kestrel/utilities/make-termination-theorem.lisp\")
       (memoized-prover-fns \"[books]/tools/memoize-prover-fns.lisp\")
       (must-fail \"[books]/std/testing/must-fail.lisp\")
       (str::nat-to-dec-string \"[books]/std/strings/decimal.lisp\")
       (non-parallel-book \"[books]/std/system/non-parallel-book.lisp\")
       (note-6-4-books \"[books]/doc/relnotes.lisp\")
       (note-6-5-books \"[books]/doc/relnotes.lisp\")
       (note-7-0-books \"[books]/doc/relnotes.lisp\")
       (note-7-1-books \"[books]/doc/relnotes.lisp\")
       (note-7-2-books \"[books]/doc/relnotes.lisp\")
       (note-8-0-books \"[books]/doc/relnotes.lisp\")
       (note-8-1-books \"[books]/doc/relnotes.lisp\")
       (note-8-2-books \"[books]/doc/relnotes.lisp\")
       (note-8-3-books \"[books]/doc/relnotes.lisp\")
       (note-8-4-books \"[books]/doc/relnotes.lisp\")
       (note-8-5-books \"[books]/doc/relnotes.lisp\")
       (str::numbers \"[books]/std/strings/top.lisp\")
       (open-trace-file! \"[books]/tools/open-trace-file-bang.lisp\")
       (oracle-timelimit \"[books]/tools/oracle-timelimit.lisp\")
       (oslib \"[books]/oslib/top-logic.lisp\")
       (patbind-the \"[books]/std/util/bstar.lisp\")
       (build::pre-certify-book-commands \"[books]/build/doc.lisp\")
       (xdoc::preprocessor \"[books]/xdoc/topics.lisp\")
       (str::pretty \"[books]/std/strings/pretty.lisp\")
       (str::pretty-printing \"[books]/std/strings/pretty.lisp\")
       (profile-acl2 \"[books]/centaur/memoize/old/profile.lisp\")
       (profile-all \"[books]/centaur/memoize/old/profile.lisp\")
       (prove$ \"[books]/tools/prove-dollar.lisp\")
       (quicklisp \"[books]/quicklisp/top.lisp\")
       (release-notes-books \"[books]/doc/relnotes.lisp\")
       (removable-runes \"[books]/tools/removable-runes.lisp\")
       (remove-hyps \"[books]/tools/remove-hyps.lisp\")
       (rewrite$ \"[books]/tools/rewrite-dollar.lisp\")
       (rewrite-equiv-hint \"[books]/coi/util/rewrite-equiv.lisp\")
       (run-script \"[books]/tools/run-script.lisp\")
       (satlink::sat-solver-options \"[books]/centaur/satlink/top.lisp\")
       (satlink \"[books]/centaur/satlink/top.lisp\")
       (xdoc::save \"[books]/xdoc/topics.lisp\")
       (xdoc::save-rendered \"[books]/xdoc/topics.lisp\")
       (xdoc::save-rendered-event \"[books]/xdoc/topics.lisp\")
       (set-max-mem \"[books]/centaur/misc/memory-mgmt-logic.lisp\")
       (spacewalk \"[books]/centaur/misc/spacewalk.lisp\")
       (std \"[books]/std/top.lisp\")
       (std/io \"[books]/std/io/top.lisp\")
       (std/strings \"[books]/std/strings/top.lisp\")
       (std/util \"[books]/std/util/top.lisp\")
       (std::strict-list-recognizers \"[books]/std/util/deflist-base.lisp\")
       (subseq-list \"[books]/std/lists/subseq.lisp\")
       (trans-eval-error-triple
            \"[books]/kestrel/utilities/trans-eval-error-triple.lisp\")
       (trans-eval-state
            \"[books]/kestrel/utilities/trans-eval-error-triple.lisp\")
       (unsound-read \"[books]/std/io/unsound-read.lisp\")
       (untranslate-patterns \"[books]/misc/untranslate-patterns.lisp\")
       (use-trivial-ancestors-check
            \"[books]/tools/trivial-ancestors-check.lisp\")
       (build::using-extended-acl2-images \"[books]/build/doc.lisp\")
       (with-raw-mode \"[books]/hacking/hacking-xdoc.lisp\")
       (with-redef-allowed \"[books]/hacking/hacking-xdoc.lisp\")
       (with-timeout \"[books]/acl2s/cgen/with-timeout.lisp\")
       (without-subsumption \"[books]/tools/without-subsumption.lisp\")
       (working-with-packages \"[books]/doc/practices.lisp\")
       (write-list \"[books]/misc/file-io.lisp\")
       (xdoc \"[books]/xdoc/topics.lisp\"))")
 (BRR
  (BREAK-REWRITE)
  "To enable or disable the breaking of rewrite rules

    Example:
    :brr t       ; enable
    (brr t)      ; enable (same as above)
    (brr t t)    ; enable with less output (rarely invoked interactively)
    :brr nil     ; disable

    General Form:
    (brr flg &optional quietp)

  where flg and the optional quietp argument evaluate to t or nil.
  This function modifies [state] so that the attempted application of
  certain rewrite rules are ``broken.'' ``Brr'' stands for
  ``break-rewrite'' and can be thought of as a mode with two
  settings.  The normal mode is ``disabled.''

  For a more thorough introduction to the break rewrite system see
  [break-rewrite].

  When brr mode is ``enabled'' the ACL2 rewriter monitors the attempts
  to apply certain rules and advises the user of those attempts by
  entering an interactive wormhole break.  From within this break the
  user can watch selected application attempts.  The user can also
  interact with the system during brr breaks via [brr-commands].

  The rules monitored are selected by using the [monitor] and
  [unmonitor] commands.  It is possible to break a rune
  ``conditionally'' in the sense that an interactive break will occur
  only if a specified predicate is true of the environment at the
  time of the attempted application.  See [monitor] and see
  [unmonitor].

  Even if a non-empty set of rules has been selected, no breaks will
  occur unless brr mode is enabled.  Thus, the first time in a
  session that you wish to monitor a rewrite rule, use :brr t to
  enable brr mode.  Thereafter you may select runes to be monitored
  with [monitor] and [unmonitor] with the effect that whenever
  monitored rules are tried (and their break conditions are met) an
  interactive break will occur.  Be advised that when brr mode is
  enabled the rewriter is somewhat slower than normal.  Furthermore,
  that sluggishness persists even if no runes are monitored.  You may
  regain normal performance --- regardless of what runes are
  monitored --- by disabling brr mode with :brr nil.

  Why isn't brr mode disabled automatically when no runes are
  monitored?  More generally, why does ACL2 have brr mode at all?
  Why not just test whether there are monitored runes?  If you care
  about the answers, see [why-brr].

  BRR Mode, Console Interrupts, and Subsidiary Prover Calls: If the
  system is operating in brr mode and you break into raw Lisp (as by
  causing a console interrupt or happening upon a signaled Lisp
  error; see [breaks]), you can return to the ACL2 top-level, outside
  any brr environment, by executing ([abort!]).  Otherwise, the
  normal way to quit from such a break (for example :q in GCL, :reset
  in Allegro CL, and q in CMU CL) will return to the innermost ACL2
  read-eval-print loop, which may or may not be the top-level of your
  ACL2 session!  In particular, if the break happens to occur while
  ACL2 is within the brr environment (in which it is preparing to
  read [brr-commands]), the abort will merely return to that brr
  environment.  Upon exiting that environment, normal theorem proving
  is continued (and the brr environment may be entered again in
  response to subsequent monitored rule applications).  Before
  returning to the brr environment, ACL2 ``cleans up'' from the
  interrupted brr processing.  However, it is not possible (given the
  current implementation) to clean up perfectly.  This may have two
  side-effects.  First, the system may occasionally print the
  self-explanatory ``Cryptic BRR Message 1'' (or 2), informing you
  that the system has attempted to recover from an aborted brr
  environment.  Second, it is possible that subsequent brr behavior
  in that proof will be erroneous because the cleanup was done
  incorrectly.  The moral is that you should not trust what you learn
  from brr if you have interrupted and aborted brr processing during
  the proof.  Such ``clean up'' may also occur when you call the
  prover from within the brr environment (for example using [defthm]
  or [thm], or even [defun] or any other [event] that invoke the
  prover), unless you invoke :brr nil before making that call.  These
  issues do not affect the behavior or soundness of the theorem
  prover.


Subtopics

  [Brr-evisc-tuple]
      Determines partial suppression of output from [brr-commands]

  [Set-brr-evisc-tuple]
      Set the [brr-evisc-tuple]

  [Show-brr-evisc-tuple]
      Display the [brr-evisc-tuple]")
 (BRR-COMMANDS
  (BREAK-REWRITE)
  "[Break-Rewrite] Commands

  Many commands display terms that are abbreviated (``eviscerated'') by
  default.  These have corresponding commands with a ``+'' suffix
  that avoid such abbreviation, as shown below; also see
  [brr-evisc-tuple].  For example, the notation ``:ancestors[+]''
  below indicates that the :ancestors command may abbreviate terms
  but the :ancestors+ command does not.

    :a!                abort to ACL2 top-level
    :ancestors[+]      negations of backchaining hypotheses being pursued
    :btm[+]            bottom-most frame in :path
    :eval              try rule and re-enter break afterwards
    :eval!             :eval but no recursive breaks
    :eval$ runes       :eval with runes monitored during recursion
    :failure-reason[+] reason rule failed (after :eval)
    :final-ttree[+]    ttree after :eval (see :DOC ttree)
    :frame[+] i        ith frame in :path
    :go                exit break, printing result
    :go!               :go but no recursive breaks
    :go$ runes         :go with runes monitored during recursion
    :help              this message
    :hyp i             ith hypothesis of the rule
    :hyps              hypotheses of the rule
    :initial-ttree[+]  ttree before :eval (see :DOC ttree)
    :lhs               left-hand side of rule's conclusion (or, in the case
                         of :rewrite-quoted-constant rules of form [2], the
                         right-hand side!)
    :ok                exit break
    :ok!               :ok but no recursive breaks
    :ok$ runes         :ok with runes monitored during recursion
    :p!                pop one level (exits a top-level break-rewrite loop)
    :path[+]           rewriter's path from top clause to :target
    :poly-list[+]      list of polynomials (after :eval) of a linear rule,
                         where the leading term of each is enclosed in an
                         extra set of parentheses
    :rewritten-rhs[+]  rewritten :rhs (after :eval) of a rewrite rule
    :rhs               right-hand side of rule's conclusion (or, in the case
                         of :rewrite-quoted-constant rules of form [2], the
                         left-hand side!)
    :standard-help     :help message from ACL2 top-level
    :target[+]         term being rewritten
    :top[+]            top-most frame in :path
    :type-alist[+]     type assumptions governing :target
    :unify-subst[+]    substitution making :lhs equal :target
    :wonp              indicates whether application succeeded (after :eval)

  See the discussion of form [2] :[rewrite-quoted-constant] rules for
  an explanation of the swapped meanings of ``:lhs'' and ``:rhs.''

  [Break-rewrite] is just a call of the standard ACL2 read-eval-print
  loop, [ld], on a ``[wormhole]'' [state].  Thus, you may execute
  most commands you might normally execute at the top-level of ACL2.
  However, all [state] changes you cause from within [break-rewrite]
  are lost when you exit or :eval the rule.  You cannot modify
  [stobj]s from within the break.  See [break-rewrite] for more
  details and see [ld] for general information about the standard
  ACL2 read-eval-print loop.  Also see [brr@] for a utility that can
  return a value for many of the keywords above, instead of merely
  printing to the screen.

  Note that if you are breaking on a [monitor]ed [linear] rule, several
  of the commands listed above do not apply: :lhs, :rhs,
  :initial-ttree, and :final-ttree.  Moreover, :rewritten-rhs also
  does not apply, but instead, :poly-list shows the result of
  applying the linear lemma as a list of polynomials, implicitly
  conjoined.  The leading term of each polynomial is enclosed in an
  extra set of parentheses.")
 (BRR-EVISC-TUPLE
  (BRR EVISC-TUPLE)
  "Determines partial suppression of output from [brr-commands]

  See [evisc-tuple] for relevant background on ``evisceration'':
  eliding of subexpressions during printing.  Also see
  [break-rewrite] for background on the break-rewrite loop.

  One of the settable evisc-tuples (see [set-evisc-tuple]) can control
  output from [brr-commands]: the brr-evisc-tuple.  Unlike most other
  evisc-tuples, if you set the brr-evisc-tuple inside the
  break-rewrite loop at level 1 of interaction (i.e., at the top
  level; see [break-rewrite]), then its effect will persist even
  after you exit the break.

  A special value, :default, is legal for this evisc-tuple, and is its
  initial value.  In that case the actual evisc-tuple used during
  output from [brr-commands] --- which we call the effective value of
  the brr-evisc-tuple --- is the value of the evisc-tuple for terms.
  See [set-evisc-tuple], in particular, the discussion of the :term
  site for setting evisc-tuples.

  You can see the effective value of the brr-evisc-tuple by evaluating
  the form, (show-brr-evisc-tuple).  Note that this value is only
  printed by such evaluation as a side-effect, not returned.
  (Technical note: This is because the brr-evisc-tuple is maintained
  entirely within the break-rewrite [wormhole].  That implementation
  enables the persistence of this evisc-tuple within and without the
  break-rewrite loop.)


Subtopics

  [Set-brr-evisc-tuple]
      Set the [brr-evisc-tuple]

  [Show-brr-evisc-tuple]
      Display the [brr-evisc-tuple]")
 (BRR@
  (BREAK-REWRITE)
  "To access context sensitive information within [break-rewrite]

    Example:
    (brr@ :target)      ; the term being rewritten
    (brr@ :unify-subst) ; the unifying substitution

    General Form:
    (brr@ :symbol)

  where :symbol is one of the keywords displayed below.  This utility
  may be most useful for system hackers; see [brr-commands] for
  queries that are more at a user level.  In particular, keywords
  marked below with * probably require an implementor's knowledge of
  the system to use effectively.  They are supported but not well
  documented.  More is said on this topic following the table.  For
  background on the notion of ``translated'' term, see [term].

    :symbol             (brr@ :symbol)
    -------             ---------------------

    :target             the term to be rewritten.  This term is an
                        instantiation of the left-hand side of the
                        conclusion of the rewrite-rule being broken.
                        This term is in translated form!  Thus, if
                        you are expecting (equal x nil) -- and your
                        expectation is almost right -- you will see
                        (equal x 'nil); similarly, instead of (cadr a)
                        you will see (car (cdr a)).  In translated
                        forms, all constants are quoted (even nil, t,
                        strings and numbers) and all macros are
                        expanded.

    :unify-subst        the substitution that, when applied to :target,
                        produces the left-hand side of the rule being
                        broken.  This substitution is an alist pairing
                        variable symbols to translated (!) terms.

    :wonp               t or nil indicating whether the rune was
                        successfully applied.  (brr@ :wonp) returns
                        nil if evaluated before :EVALing the rule.

    :rewritten-rhs      the result of successfully applying the rewrite
                        rule or else nil if (brr@ :wonp) is nil.  The
                        result of successfully applying the rule is
                        always a translated (!) term and is never nil.

    :poly-list          the result of successfully applying the linear
                        rule or else nil if (brr@ :wonp) is nil.  This
                        result represents the list of polynomials
                        produced by the rule application.  The leading
                        term of each polynomial is enclosed in an extra
                        set of parentheses.

    :failure-reason     some non-nil lisp object indicating why the rule
                        was not applied or else nil.  Before the rule is
                        :EVALed, (brr@ :failure-reason) is nil.  After
                        :EVALing the rule, (brr@ :failure-reason) is nil
                        if (brr@ :wonp) is t.  Rather than document the
                        various non-nil objects returned as the failure
                        reason, we encourage you simply to evaluate
                        (brr@ :failure-reason) in the contexts of interest.
                        Alternatively, study the ACL2 function tilde-@-
                        failure-reason-phrase.

    :lemma           *  the rewrite rule being broken.  For example,
                        (access rewrite-rule (brr@ :lemma) :lhs) will
                        return the left-hand side of the conclusion
                        of the rule.

    :type-alist      *  a display of the type-alist governing :target.
                        Elements on the displayed list are of the form
                        (term type), where term is a term and type
                        describes information about term assumed to hold in
                        the current context.  (See also the documentation for
                        type-alist.)  The type-alist may be used to determine
                        the current assumptions, e.g., whether A is a CONSP.

    :ancestors       *  a stack of frames indicating the backchain history
                        of the current context.  The theorem prover is in
                        the process of trying to establish each hypothesis
                        in this stack.  Thus, the negation of each hypothesis
                        can be assumed false.  Each frame also records the
                        rules on behalf of which this backchaining is being
                        done and the weight (function symbol count) of the
                        hypothesis.  All three items are involved in the
                        heuristic for preventing infinite backchaining.
                        Exception:  Some frames are ``binding hypotheses''
                        (equal var term) or (equiv var (double-rewrite term))
                        that bind variable var to the result of rewriting
                        term.  The ACL2 source code has a definition
                        (defrec ancestor ...) that may provide some relevant
                        insight.

    :initial-ttree   *  the initial and (after :EVAL) final tag trees,
    :final-ttree        respectively.  (Tag trees are low-level data structures
                        that store lemmas used and other information, as
                        documented in topic TTREE.)

    :gstack          *  the current goal stack.  The gstack is maintained
                        by rewrite and is the data structure printed as the
                        current ``path.''  Thus, any information derivable
                        from the :path brr command is derivable from gstack.
                        For example, from gstack one might determine that
                        the current term is the second hypothesis of a
                        certain rewrite rule.

  In general brr@-expressions are used in break conditions, the
  expressions that determine whether interactive breaks occur when
  [monitor]ed [rune]s are applied.  See [monitor].  For example, you
  might want to break only those attempts in which one particular
  term is being rewritten or only those attempts in which the binding
  for the variable a is known to be a [consp].  Such conditions can
  be expressed using ACL2 system functions and the information
  provided by brr@.  Unfortunately, digging some of this information
  out of the internal data structures may be awkward or may, at
  least, require intimate knowledge of the system functions.  But
  since conditional expressions may employ arbitrary functions and
  macros, we anticipate that a set of convenient primitives will
  gradually evolve within the ACL2 community.  It is to encourage
  this evolution that brr@ provides access to the *'d data.")
 (BUILDING-ACL2
  (ABOUT-ACL2)
  "How to build an ACL2 executable

  To build an ACL2 executable, submit the following command while
  standing in the main ACL2 directory, where <my-lisp> invokes your
  Lisp executable (default: ccl).

    make LISP=<my-lisp>

  You should find \"Initialization SUCCEEDED.\" near the end the of the
  log.  Note: There may be ACL2 warnings, for example: \"ACL2 Warning
  [Skip-proofs] in....\".  These may be safely ignored.

  Note that you will want to certify [books] in order to take full
  advantage of ACL2.  See [books-certification].


Subtopics

  [Ccl-installation]
      Installing Clozure Common Lisp (CCL)")
 (BUILT-IN-CLAUSE
  (RULE-CLASSES)
  "To build a clause into the simplifier

  See [rule-classes] for a general discussion of rule classes,
  including how they are used to build rules from formulas and a
  discussion of the various keywords in a rule class description.

    Example:
    (defthm acl2-count-abl
      (and (implies (and (true-listp x)
                         (not (equal x nil)))
                    (< (acl2-count (abl x))
                       (acl2-count x)))
           (implies (and (true-listp x)
                         (not (equal nil x)))
                    (< (acl2-count (abl x))
                       (acl2-count x))))
      :rule-classes :built-in-clause)

  A :built-in-clause rule can be built from any formula other than
  propositional tautologies.  Roughly speaking, the system uses the
  list of built-in clauses as the first method of proof when
  attacking a new goal.  Any goal that is subsumed by a built in
  clause is proved ``silently.''

  ACL2 maintains a set of ``built-in'' clauses that are used to
  short-circuit certain theorem proving tasks.  We discuss this at
  length below.  When a theorem is given the rule class
  :built-in-clause ACL2 flattens the [implies] and [and] structure of
  the :[corollary] formula so as to obtain a set of formulas whose
  conjunction is equivalent to the given corollary.  It then converts
  each of these to clausal form and adds each clause to the set of
  built-in clauses.

  The example above (regardless of the definition of abl) will build in
  two clauses,

    {(not (true-listp x))
     (equal x nil)
     (< (acl2-count (abl x)) (acl2-count x))}

  and

    {(not (true-listp x))
     (equal nil x)
     (< (acl2-count (abl x)) (acl2-count x))}.

  We now give more background.

  Recall that a clause is a set of terms, implicitly representing the
  disjunction of the terms.  Clause c1 is ``subsumed'' by clause c2
  if some instance of c2 is a subset c1.

  For example, let c1 be

    {(not (consp l))
     (equal a (car l))
     (< (acl2-count (cdr l)) (acl2-count l))}.

  Then c1 is subsumed by c2, shown below,

    {(not (consp x))
     ; second term omitted here
     (< (acl2-count (cdr x)) (acl2-count x))}

  because we can instantiate x in c2 with l to obtain a subset of c1.

  Observe that c1 is the clausal form of

    (implies (and (consp l)
                  (not (equal a (car l))))
             (< (acl2-count (cdr l)) (acl2-count l))),

  c2 is the clausal form of

    (implies (consp l)
             (< (acl2-count (cdr l)) (acl2-count l)))

  and the subsumption property just means that c1 follows trivially
  from c2 by instantiation.

  The set of built-in clauses is just a set of known theorems in
  clausal form.  Any formula that is subsumed by a built-in clause is
  thus a theorem.  If the set of built-in theorems is reasonably
  small, this little theorem prover is fast.  ACL2 uses the
  ``built-in clause check'' in four places: (1) at the top of the
  iteration in the prover --- thus if a built-in clause is generated
  as a subgoal it will be recognized when that goal is considered,
  (2) within the simplifier so that no built-in clause is ever
  generated by simplification, (3) as a filter on the clauses
  generated to prove the termination of recursively [defun]'d
  functions and (4) as a filter on the clauses generated to verify
  the guards of a function.

  The latter two uses are the ones that most often motivate an
  extension to the set of built-in clauses.  Frequently a given
  formalization problem requires the definition of many functions
  which require virtually identical termination and/or guard proofs.
  These proofs can be short-circuited by extending the set of
  built-in clauses to contain the most general forms of the clauses
  generated by the definitional schemes in use.

  The attentive user might have noticed that there are some recursive
  schemes, e.g., recursion by [cdr] after testing [consp], that ACL2
  just seems to ``know'' are ok, while for others it generates
  measure clauses to prove.  Actually, it always generates measure
  clauses but then filters out any that pass the built-in clause
  check.  When ACL2 is initialized, the clause justifying [cdr]
  recursion after a [consp] test is added to the set of built-in
  clauses.  (That clause is c2 above.)

  Note that only a subsumption check is made; no rewriting or
  simplification is done.  Thus, if we want the system to ``know''
  that [cdr] recursion is ok after a negative [atom] test (which, by
  the definition of [atom], is the same as a [consp] test), we have
  to build in a second clause.  The subsumption algorithm does not
  ``know'' about commutative functions.  Thus, for predictability, we
  have built in commuted versions of each clause involving
  commutative functions.  For example, we build in both

    {(not (integerp x))
     (< 0 x)
     (= x 0)
     (< (acl2-count (+ -1 x)) (acl2-count x))}

  and the commuted version

    {(not (integerp x))
     (< 0 x)
     (= 0 x)
     (< (acl2-count (+ -1 x)) (acl2-count x))}

  so that the user need not worry whether to write (= x 0) or (= 0 x)
  in definitions.

  :built-in-clause rules added by the user can be enabled and disabled.")
 (BUTLAST
  (LISTS ACL2-BUILT-INS)
  "All but a final segment of a list

  (Butlast l n) is the list obtained by removing the last n elements
  from the true list l.  The following are theorems.

    (implies (and (integerp n)
                  (<= 0 n)
                  (true-listp l))
             (equal (length (butlast l n))
                    (if (< n (length l))
                        (- (length l) n)
                      0)))

    (equal (len (butlast l n)) (nfix (- (len l) (nfix n)))))

  For related functions, see [take] and see [nthcdr].

  The [guard] for (butlast l n) requires that n is a nonnegative
  integer and lst is a true list.

  Butlast is a Common Lisp function.  See any Common Lisp documentation
  for more information.  Note: In Common Lisp the second argument of
  butlast is optional, but in ACL2 it is required.

  Function: <butlast>

    (defun butlast (lst n)
           (declare (xargs :guard (and (true-listp lst)
                                       (integerp n)
                                       (<= 0 n))))
           (let ((lng (len lst)) (n (nfix n)))
                (if (<= lng n)
                    nil (take (- lng n) lst))))")
 (BY (POINTERS)
     "See [hints] for information about the keyword :by.")
 (CAAAAR
    (CONSES ACL2-BUILT-INS)
    "[car] of the [caaar]

  See any Common Lisp documentation for details.")
 (CAAADR
    (CONSES ACL2-BUILT-INS)
    "[car] of the [caadr]

  See any Common Lisp documentation for details.")
 (CAAAR
     (CONSES ACL2-BUILT-INS)
     "[car] of the [caar]

  See any Common Lisp documentation for details.")
 (CAADAR
    (CONSES ACL2-BUILT-INS)
    "[car] of the [cadar]

  See any Common Lisp documentation for details.")
 (CAADDR
    (CONSES ACL2-BUILT-INS)
    "[car] of the [caddr]

  See any Common Lisp documentation for details.")
 (CAADR
     (CONSES ACL2-BUILT-INS)
     "[car] of the [cadr]

  See any Common Lisp documentation for details.")
 (CAAR
      (CONSES ACL2-BUILT-INS)
      "[car] of the [car]

  See any Common Lisp documentation for details.")
 (CADAAR
    (CONSES ACL2-BUILT-INS)
    "[car] of the [cdaar]

  See any Common Lisp documentation for details.")
 (CADADR
    (CONSES ACL2-BUILT-INS)
    "[car] of the [cdadr]

  See any Common Lisp documentation for details.")
 (CADAR
     (CONSES ACL2-BUILT-INS)
     "[car] of the [cdar]

  See any Common Lisp documentation for details.")
 (CADDAR
    (CONSES ACL2-BUILT-INS)
    "[car] of the [cddar]

  See any Common Lisp documentation for details.")
 (CADDDR
    (CONSES ACL2-BUILT-INS)
    "[car] of the [cdddr]

  See any Common Lisp documentation for details.")
 (CADDR
     (CONSES ACL2-BUILT-INS)
     "[car] of the [cddr]

  See any Common Lisp documentation for details.")
 (CADR
      (CONSES ACL2-BUILT-INS)
      "[car] of the [cdr]

  See any Common Lisp documentation for details.")
 (CALLING-LD-IN-BAD-CONTEXTS
  (LD)
  "Errors caused by calling [ld] in inappropriate contexts

  The macro [ld] was designed to be called directly in the top-level
  ACL2 loop, although there may be a few occasions for calling it
  from functions.  ACL2 cannot cope with invocations of [ld] during
  the process of loading a compiled file for a book, so that is an
  error.

  Specifically: ACL2 will cause an error in the following two
  circumstances:

    * when calling [ld] inside [progn!] unless state global ld-okp is first
      set to t, e.g., using (assign ld-okp t); also,
    * when calling ld while inside raw Lisp, e.g., when loading a compiled
      file during an invocation of [include-book].

  Consider for example the following book, where file const.lsp
  contains the single form (defconst *foo* '(a b)) after its initial
  [in-package] form.

    (in-package \"ACL2\")
    (defttag t)
    (progn! (ld \"const.lsp\"))

  An attempt to certify this book as follows

    (certify-book \"const-wrapper\" 0 t :ttags :all)

  will cause an error:

    ACL2 Error in LD:  It is illegal to call LD in this context.  See :DOC
    calling-ld-in-bad-contexts.

  However, that error can be avoided by expanding the [progn!] call as
  follows.

    (progn! (assign ld-okp t)
            (ld \"const.lsp\"))

  Now certification succeeds; however, any subsequent call of
  [include-book] will fail to load the compiled file for the book.
  Again, that is necessary because of how ACL2 is designed; in this
  case, the [ld] call would interfere with tracking of constant
  definitions when loading the compiled file for the book.  To avoid
  warnings about loading compiled files, either certify the book
  without creating a compiled file or else include the book without
  loading the compiled file; see [certify-book] and [include-book].

  Note that it is legal to put a definition such as the following into
  a book, where ld is called in the body of a function; the two
  conditions above do not prohibit this.

    (defun foo (state)
      (declare (xargs :guard t :stobjs state :mode :program))
      (ld '((defun h (x) x)) :ld-user-stobjs-modified-warning t))

  One can then include the book, evaluate (foo state), and then
  evaluate calls of h.")
 (CANONICAL-PATHNAME
  (PROGRAMMING-WITH-STATE ACL2-BUILT-INS)
  "The true absolute filename, with soft links resolved

  For the name fname of a file, the form (Canonical-pathname fname nil
  state) evaluates to a Unix-style absolute filename representing the
  same file as fname, but generally without any use of soft links in
  the name.  (Below, we explain the qualifier ``generally''.)  If
  however the file indicated by fname does not exist,
  (canonical-pathname fname nil state) is nil.  Thus,
  canonical-pathname can be used as one would use the raw Lisp
  function probe-file.

  The specification of (Canonical-pathname fname dir-p state) when
  dir-p is not nil is similar, except that if the specified file
  exists but is not a directory, then the result is nil.

  The function canonical-pathname has a guard of t, though the second
  argument must be the ACL2 [state].  This function is introduced
  with the following properties.

    (defthm canonical-pathname-is-idempotent
      (equal (canonical-pathname (canonical-pathname x dir-p state) dir-p state)
             (canonical-pathname x dir-p state)))
    (defthm canonical-pathname-type
      (or (equal (canonical-pathname x dir-p state) nil)
          (stringp (canonical-pathname x dir-p state)))
      :rule-classes :type-prescription)

  We use the qualifier ``generally'', above, because there is no
  guarantee that the filename will be canonical without soft links,
  though we expect this to be true in practice.  ACL2 attempts to
  compute the desired result and then checks that the input and
  result have the same Common Lisp ``truename''.  This check is
  expected to succeed, but if it fails then the input string is
  returned unchanged, and to be conservative, the value returned is
  nil in this case if dir-p is true.")
 (CAR
  (CONSES ACL2-BUILT-INS)
  "Returns the first element of a non-empty list, else nil

  Completion Axiom (completion-of-car):

    (equal (car x)
           (cond
            ((consp x)
             (car x))
            (t nil)))

  [Guard]:

    (or (consp x) (equal x nil))

  Notice that in the ACL2 logic, car returns nil for every [atom].")
 (CASE
  (BASICS ACL2-BUILT-INS)
  "Conditional based on if-then-else using [eql]

    Example Form:
    (case typ
      ((:character foo)
       (open file-name :direction :output))
      (bar (open-for-bar file-name))
      (otherwise
       (my-error \"Illegal.\")))

  is the same as

    (cond ((member typ '(:character foo))
           (open file-name :direction :output))
          ((eql typ 'bar)
           (open-for-bar file-name))
          (t (my-error \"Illegal.\")))

  which in turn is the same as

    (if (member typ '(:character foo))
        (open file-name :direction :output)
        (if (eql typ 'bar)
            (open-for-bar file-name)
            (my-error \"Illegal.\")))

  Notice the quotations that appear in the example above: '(:character
  foo) and 'bar.  Indeed, a case expression expands to a [cond]
  expression in which each tested form is quoted, and [eql] is used
  as the test.

    General Forms:
    (case expr
      (x1 val-1)
      ...
      (xk val-k)
      (otherwise val-k+1))

    (case expr
      (x1 val-1)
      ...
      (xk val-k)
      (t val-k+1))

    (case expr
      (x1 val-1)
      ...
      (xk val-k))

  where each xi is either [eqlablep] or a true list of [eqlablep]
  objects.  The final otherwise or t case is optional.

  Case is defined in Common Lisp.  See any Common Lisp documentation
  for more information.")
 (CASE-MATCH
  (BASICS ACL2-BUILT-INS)
  "Pattern matching or destructuring

    General Form:
    (case-match x
      (pat1 dcl1 body1)
      ...
      (patk dclk bodyk))

  where x is a variable symbol, the pati are structural patterns as
  described below, the dcli are optional [declare] forms and the
  bodyi are terms.  The legal declare forms are the same as for
  [let]: ignore, ignorable, and type.  Return the value(s) of the
  bodyi corresponding to the first pati matching x, or nil if none
  matches.

  Pattern Language:
  With the few special exceptions described below, matching requires
  that the [cons] structure of x be isomorphic to that of the
  pattern, down to the [atom]s in the pattern.  Non-symbol [atom]s in
  the pattern match only themselves.  Symbols in the pattern denote
  variables which match anything and which are bound by a successful
  match to the corresponding substructure of x.  Variables that occur
  more than once must match the same ([equal]) structure in every
  occurrence.

    Exceptions:
    &               Matches anything and is not bound.  Repeated
                      occurrences of & in a pattern may match different
                      structures.
    nil, t, *sym*, :sym
                    These symbols cannot be bound and match only their
                      global values.
    !sym            where sym is a symbol that is already bound in the
                      context of the case-match, matches only the
                      current binding of sym.
    'obj            Matches only itself.  This is the same as (QUOTE obj).
    (QUOTE~ sym)    where sym is a symbol, is like (QUOTE sym) except it
                      matches any symbol with the same symbol-name as sym.
                      Note that QUOTE~ is in the \"ACL2\" package.

  Some examples are shown below.

  Below we show some sample patterns and examples of things they match
  and do not match.

    pattern       matches         non-matches
    (x y y)       (ABC 3 3)       (ABC 3 4)    ; 3 is not 4
    (fn x . rst)  (P (A I) B C)   (ABC)        ; NIL is not (x . rst)
                  (J (A I))                    ; rst matches nil
    ('fn (g x) 3) (FN (H 4) 3)    (GN (G X) 3) ; 'fn matches only itself
    (& t & !x)    ((A) T (B) (C))              ; provided x is '(C)

  Consider the two binary trees that contain three leaves.  They might
  be described as (x . (y . z)) and ((x . y) . z), where x, y, and z
  are atomic.  Suppose we wished to recognize those trees.  The
  following case-match would do:

    (case-match tree
      ((x . (y . z))
       (and (atom x) (atom y) (atom z)))
      (((x . y) . z)
       (and (atom x) (atom y) (atom z))))

  Suppose we wished to recognize such trees where all three tips are
  identical.  Suppose further we wish to return the tip if the tree
  is one of those recognized ones and to return the number 7
  otherwise.

    (case-match tree
      ((x . (x . x))
       (if (atom x) x 7))
      (((x . x) . x)
       (if (atom x) x 7))
      (& 7))

  Note that case-match returns nil if no pati matches.  Thus if we must
  return 7 in that case, we have to add as the final pattern the &,
  which always matches anything.

  Technical point: The symbol sym referenced by the symbol !sym is in
  the same package as !sym but with the leading exclamation point
  character, \\#!, removed from the [symbol-name] of !sym.")
 (CASE-SPLIT
  (REWRITE LINEAR TYPE-PRESCRIPTION
           DEFINITION META FORWARD-CHAINING)
  "Like force but immediately splits the top-level goal on the
  hypothesis

  Case-split is a variant of [force], which has similar special
  treatment in hypotheses of rules for the same [rule-classes] as for
  force (see [force]).  This treatment takes place for rule classes
  :[rewrite], :[linear], :[type-prescription], :[definition], :[meta]
  (actually in that case, the result of evaluating the hypothesis
  metafunction call), and :[forward-chaining].

  When a hypothesis of a conditional rule (of one of the classes listed
  above) has the form (case-split hyp) it is logically equivalent to
  hyp.  However it affects the application of the rule generated as
  follows: if ACL2 attempts to apply the rule but cannot establish
  that the required instance of hyp holds in the current context, it
  considers the hypothesis true anyhow, but (assuming all hypotheses
  are seen to be true and the rule is applied) creates a subgoal in
  which that instance of hyp is assumed false.  (There are
  exceptions, noted below.)

  For example, given the rule

    (defthm p1->p2
      (implies (case-split (p1 x))
               (p2 x)))

  then an attempt to prove

    (implies (p3 x) (p2 (car x)))

  can give rise to a single subgoal:

    (IMPLIES (AND (NOT (P1 (CAR X))) (P3 X))
             (P2 (CAR X))).

  Unlike [force], case-split does not delay the ``false case'' to a
  forcing round but tackles it more or less immediately.

  The special ``split'' treatment of case-split can be disabled by
  disabling forcing: see [force] for a discussion of disabling
  forcing, and also see [disable-forcing].  Finally, we should
  mention that the rewriter is never willing to split when there is
  an [if] term present in the goal being simplified.  Since [and]
  terms and [or] terms are merely abbreviations for [if] terms, they
  also prevent splitting.  Note that [if] terms are ultimately
  eliminated using the ordinary flow of the proof (but see
  [set-case-split-limitations]), so case-split will ultimately
  function as intended.

  When in the interactive [proof-builder], case-split behaves like
  force.

  Function: <case-split>

    (defun case-split (x)
           (declare (xargs :guard t))
           x)")
 (CASE-SPLIT-LIMITATIONS
  (MISCELLANEOUS)
  "Limiting the number of immediate subgoals

    Examples:
    ACL2 !>(case-split-limitations (w state))
    (500 100)

  With the setting above, which is the default, clausify will not try
  subsumption/replacement if more than 500 clauses are involved.
  Furthermore, the simplifier, as it sweeps over a clause, will
  inhibit further case splits when it has accumulated 100 subgoals.
  To implement this inhibition, ACL2 refuses to rewrite subsequent
  literals, although it continues to split on any IF calls in those
  literals.

  The following example illustrates how the latter restriction ---
  specifically, not rewriting subsequent literals to avoid further
  case splits --- can work.  We define a (rather nonsensical)
  function whose body introduces several cases.

    (defun f1 (a b c)
      (if a
          (if b (equal c 0) (equal c 1))
        (if b (equal c 2) (equal c 3))))

    (set-case-split-limitations '(500 10))

    (set-gag-mode nil)

    (thm (or (equal (f1 a b c) xxx)
             (equal (f1 d e f) yyy)
             (equal (f1 g h i) zzz))
         :hints ((\"Goal\" :in-theory (disable f1))
                 (\"Goal'\" :in-theory (enable f1)))
         :otf-flg t)

  We show the output below.  The simplification of the original goal to
  Goal' replaces the original goal, which is the clause (i.e.,
  disjunction) consisting of the single literal (i.e., term) shown
  above, to the clause consisting of three literals, namely, the
  list:

    ; Goal', as a clause (disjunction of three literals)
    ((EQUAL (F1 A B C) XXX)
     (EQUAL (F1 D E F) YYY)
     (EQUAL (F1 G H I) ZZZ))

  That simplification is reflected in the value printed (as an
  implication) for Goal' in the output, below.  If we omit the call
  of [set-case-split-limitations] above, then we get 64 cases, from
  opening up the calls of f1 and splitting on the variables a, b, d,
  e, g, and h.  But with the limit of 10 provided by
  set-case-split-limitations above, fewer cases are generated because
  rewriting of literals is inhibited, as explained below.  Here is
  the first part of the output for that limit of 10.

    [Note:  A hint was supplied for our processing of the goal above.
    Thanks!]

    This simplifies, using trivial observations, to

    [Note:  A hint was supplied for our processing of the goal below.
    Thanks!]

    Goal'
    (IMPLIES (AND (NOT (EQUAL (F1 A B C) XXX))
                  (NOT (EQUAL (F1 D E F) YYY)))
             (EQUAL (F1 G H I) ZZZ)).

    This simplifies, using the :definition F1 (if-intro), to the following
    thirteen conjectures.

    Subgoal 13
    (IMPLIES (AND A B (NOT (EQUAL (EQUAL C 0) XXX))
                  (NOT (EQUAL (F1 D E F) YYY)))
             (EQUAL (F1 G H I) ZZZ)).

  Why, though, are there 13 cases, even though the limit was specified
  as 10?  Initially, the first literal (EQUAL (F1 A B C) XXX) was
  rewritten, splitting into four cases; and for each of those cases,
  the second literal was rewritten, splitting further; and so on.
  However, the first time more than 10 cases were generated was when
  there were 10 cases generated so far and a literal generated four
  cases --- then since that one literal generated four cases, 4-1 = 3
  cases were added to the 10 already generated.  From that point on,
  further rewriting of literals did not take place.

  In short: the first time a literal splits into enough cases so that
  the accumulated number of cases exceeds the limit, rewriting stops
  --- but that last split can put us significantly past the limit
  specified.

  See [set-case-split-limitations] for a more general discussion.")
 (CASES (POINTERS)
        "See [hints] for information about the keyword :cases.")
 (CBD
  (BOOKS-REFERENCE PROGRAMMING-WITH-STATE ACL2-BUILT-INS)
  "Connected book directory string

    Example:
    ACL2 !>:cbd
    \"/usr/home/smith/\"

  The connected book directory is a nonempty string that specifies a
  directory as an absolute pathname.  (See [pathname] for a
  discussion of file naming conventions.)  When [include-book] is
  given a relative book name it elaborates it into a full book name,
  essentially by appending the connected book directory string to the
  left and \".lisp\" to the right.  (For details, see [book-name] and
  also see [full-book-name].)  Similarly, [ld] elaborates relative
  pathnames into full pathnames using the connected book directory
  string.  (The effect of the cbd on ld carries over to utilities
  that invoke ld as well, notably, [rebuild].)  Furthermore,
  [include-book] and [ld] temporarily set the connected book
  directory to the directory string of the resulting full pathname so
  that references to files in the same directory may omit the
  directory.  See [set-cbd] for how to set the connected book
  directory string.

    General Form:
    (cbd)

  This is a macro that expands into a term involving the single free
  variable [state].  It returns the connected book directory string.

  The connected book directory (henceforth called the ``cbd'') is used
  by [include-book] to elaborate the supplied book name into a full
  book name (see [full-book-name]); similarly for [ld].  For example,
  if the cbd is \"/usr/home/smith/\" then the elaboration of the
  [book-name] \"project/task-1/arith\" (to the \".lisp\" extension) is
  \"/usr/home/smith/project/task-1/arith.lisp\".  That [full-book-name]
  is what [include-book] opens to read the source text for the book.

  The cbd may be changed using [set-cbd] (see [set-cbd]).  Furthermore,
  during the processing of the [events] in a book, [include-book]
  sets the cbd to be the directory string of the [full-book-name] of
  the book; similarly for [ld].  Thus, if the cbd is
  \"/usr/home/smith/\" then during the processing of [events] by

    (include-book \"project/task-1/arith\")

  the cbd will be set to \"/usr/home/smith/project/task-1/\".  Note that
  if \"arith\" recursively includes a sub-book, say \"naturals\", that
  resides on the same directory, the [include-book] event for it may
  omit the specification of that directory.  For example, \"arith\"
  might contain the event

    (include-book \"naturals\").

  In general, suppose we have a superior book and several inferior
  [books] which are included by [events] in the superior book.  Any
  inferior book residing on the same directory as the superior book
  may be referenced in the superior without specification of the
  directory.

  We call this a ``relative'' as opposed to ``absolute'' naming.  The
  use of relative naming is preferred because it permits [books] (and
  their accompanying inferiors) to be moved between directories while
  maintaining their [certificate]s and utility.  Certified [books]
  that reference inferiors by absolute file names are unusable (and
  rendered uncertified) if the inferiors are moved to new
  directories.

  Technical Note and a Challenge to Users:

  After elaborating the book name to a full book name, [include-book]
  opens a channel to the file to process the [events] in it.  In some
  host Common Lisps, the actual file opened depends upon a notion of
  ``connected directory'' similar to our connected book directory.
  Our intention in always elaborating book names into absolute
  filename strings (see [pathname] for terminology) is to circumvent
  the sensitivity to the connected directory.  But we may have
  insufficient control over this since the ultimate file naming
  conventions are determined by the host operating system rather than
  Common Lisp (though, we do check that the operating system
  ``appears'' to be one that we ``know'' about).  Here is a question,
  which we'll pose assuming that we have an operating system that
  calls itself ``Unix.'' Suppose we have a file name, filename, that
  begins with a slash, e.g., \"/usr/home/smith/...\".  Consider two
  successive invocations of CLTL's

    (open filename :direction :input)

  separated only by a change to the operating system's notion of
  connected directory.  Must these two invocations produce streams to
  the same file?  A candidate string might be something like
  \"/usr/home/smith/*/usr/local/src/foo.lisp\" which includes some
  operating system-specific special character to mean ``here insert
  the connected directory'' or, more generally, ``here make the name
  dependent on some non-ACL2 aspect of the host's state.'' If such
  ``tricky'' name strings beginning with a slash exist, then we have
  failed to isolate ACL2 adequately from the operating system's file
  naming conventions.  Once upon a time, ACL2 did not insist that the
  cbd begin with a slash and that allowed the string \"foo.lisp\" to be
  tricky because if one were connected to \"/usr/home/smith/\" then
  with the empty cbd \"foo.lisp\" is a full book name that names the
  same file as \"/usr/home/smith/foo.lisp\".  If the actual file one
  reads is determined by the operating system's state then it is
  possible for ACL2 to have two distinct ``full book names'' for the
  same file, the ``real'' name and the ``tricky'' name.  This can
  cause ACL2 to include the same book twice, not recognizing the
  second one as redundant.")
 (CCL-INSTALLATION
  (BUILDING-ACL2)
  "Installing Clozure Common Lisp (CCL)

  For those who use ACL2 built on CCL as the host Common Lisp
  implementation, it has been common practice to use the latest
  GitHub version of CCL.  We provide the following instructions for
  you to choose from.  The ``brief'' instructions for Linux or Mac
  (according to your operating system) might well suffice; the
  ``elaborate'' instructions have helped with version control.

    * [ccl-installation-linux-brief]
    * [ccl-installation-mac-brief]
    * [ccl-installation-linux-elaborate]
    * [ccl-installation-mac-elaborate]

  You may prefer instead to look at the {CCL Releases |
  https://github.com/Clozure/ccl/releases} page, using links above
  only as needed (e.g., for Linux-specific information or for
  discussion of CCL_DEFAULT_DIRECTORY).

  One of the links listed above should generally suffice.  But if you
  would like additional information on CCL installation and
  implementation, see [ccl-installation-extra].


Subtopics

  [Ccl-installation-extra]
      Clozure Common Lisp (CCL) installation and implementation details

  [Ccl-installation-linux-brief]
      Installing Clozure Common Lisp (CCL) on Linux (brief version)

  [Ccl-installation-linux-elaborate]
      Installing Clozure Common Lisp (CCL) on Linux (elaborate version)

  [Ccl-installation-mac-brief]
      Installing Clozure Common Lisp (CCL) on Mac (brief version)

  [Ccl-installation-mac-elaborate]
      Installing Clozure Common Lisp (CCL) on Mac (elaborate version)")
 (CCL-INSTALLATION-EXTRA
  (CCL-INSTALLATION)
  "Clozure Common Lisp (CCL) installation and implementation details

  This topic, contributed by Warren A. Hunt, Jr., extends the basic
  information given in [ccl-installation].  It may be useful to some,
  especially those who use ACL2 in ways that particularly stress
  memory.  Another resource may be found on {this page |
  https://github.com/Clozure/ccl/releases/}.

  Below we provide instructions to build CCL on FreeBSD and MacOS;
  building on Linux will be similar.  Before providing the build
  instructions, we mention a few facts about CCL's implementation.

  CCL's implementation can't expand stack space automatically.  The
  sizes of various stacks are set at thread creation time.  Most
  programs don't need very big stacks.  The CCL default value and
  temp stack sizes may be too small for compute-intensive
  applications.

  The various stack sizes are set when creating a thread with code in
  CCL::MAKE-PROCESS and CCL::PROCESS-RUN-FUNCTION, and they set the
  three stack sizes of the initial listener thread that is created
  when CCL starts.

  The value stack is used for data in deeply-nested lisp recursion.
  ACL2 can benefit from an increase in the size of the value stack.

  The temp stack is used for dynamic-extent objects.  This might need
  need to be larger than the default.

  The control stack is used to run C and binary code; it would be
  surprising to need to increase its size.

  If only one or two threads are needed, giant (e.g., 4 GB) stacks can
  be OK, but with many threads large stacks use lots of memory.
  Below are the stacks along with their current (April, 2020) default
  sizes.

    ccl::*default-control-stack-size*                    ;; default 2^21
    ccl::*initial-listener-default-control-stack-size*   ;; default 2^21

    ccl::*default-value-stack-size*                      ;; default 2^21
    ccl::*initial-listener-default-value-stack-size*     ;; default 2^21

    ccl::*initial-listener-default-temp-stack-size*      ;; default 2^20
    ccl::*default-temp-stack-size*                       ;; default 2^20

  If we are running on a 32-bit platform, we set the stack sizes
  modestly.  If we are on a 64-bit platform, we set the stack sizes
  to much larger values.  See the later discussion about
  ``configure-ccl.lisp'' below to see how to alter (increase) stack
  sizes.


MacOS Build Instructions:

    git clone https://github.com/Clozure/ccl.git ccl-dev
    curl -L -O https://github.com/Clozure/ccl/releases/download/v1.12-dev.5/darwinx86.tar.gz
    cd ccl-dev ; tar xf ../darwinx86.tar.gz

  Rebuild C-based, Lisp kernel

  To rebuild the Lisp-code part of the kernel, do...

    cd lisp-kernel/darwinx8664 ; make ; cd ../..

  Unlike for FreeBSD and Linux, we exclude ``:full t'' from the
  ``rebuild-ccl'' command just below Matt Emerson (a CCL expert)
  writes:

      After looking at your log, I was able to duplicate the problem
      myself.  For some reason I do not understand, it appears that
      on Catalina, removing the running lisp kernel binary causes
      run-program to break (trying to run external programs gets
      signal 9).  This surprises me very much.

      One of the effects of running (rebuild-ccl :full t), is that it first
      does a \"make clean\" in the lisp kernel directory, and then does
      a regular make.  This has worked for years, and I do not know
      why it has stopped working.

  To avoid this, rebuild the lisp with (rebuild-ccl :clean t) instead.
  Do not specify ``:full t''.  Since you have already built the lisp
  kernel, you gain nothing from ``:full t'' doing it again.  So, once
  the C-based, Lisp kernel is built, then do:

    echo \"(in-package :ccl) (rebuild-ccl :verbose t :clean t)\" | \\
          ./dx86cl64 -n |& tee ./ccl-build-compile.log

  Matt Emerson suggests that one re-build again.  We asked Matt a
  long-simmering question: we have been told that it is a good idea
  to compile CCL twice.  Is that so that the CCL compiler produced by
  pass one on the target system is used to compile the CCL system
  that will be used (on the target system)?  Or, is compiling twice
  some silly myth?  Matt Emerson responded:

      It's not entirely mythic.  Some rare changes do need the lisp to be
      rebuilt twice for bootstrapping purposes, but usually it isn't
      required.

  Thus, we recommend you re-build (compile) the Lisp code again.

    echo \"(in-package :ccl) (rebuild-ccl :verbose t :clean t)\" | \\
          ./dx86cl64 -n |& tee ./ccl-build-compile-2.log

  Finally, one may specialize the final image by:

    cat configure-ccl.lisp | ./dx86cl64 -n |& tee ~/ccl-build-specialize.log

  where ``configure-ccl.lisp'' (not supplied) contains whatever CCL
  specialization commands you wish to have in the version of CCL you
  use for ACL2 or other work.  See the end of this note for an
  example of ``configure-ccl.lisp''.


FreeBSD Build Instructions:

  The FreeBSD build instructions are similar to the MacOS build
  instruction, but the names are changed appropriately.

    git clone https://github.com/Clozure/ccl.git ccl-dev
    curl -L -O https://github.com/Clozure/ccl/releases/download/v1.12-dev.5/freebsd12-x8664.tar.gz
    cd ccl-dev
    tar xf ../freebsd12-x8664.tar.gz

  Rebuild C-based Lisp kernel

    cd lisp-kernel/freebsdx8664 ; make ; cd ../..

  To rebuild the Lisp-code part of the kernel, do...

    echo \"(in-package :ccl) (rebuild-ccl :full t :verbose t :clean t)\" | \\
          ./fx86cl64 -n |& tee ./ccl-build-compile.log

  FreeBSD is OK with the ``:full t'' flag, which as of MacOS 10.15
  breaks (but used to work on earlier versions of MacOS).  So, this
  option persists on the FreeBSD build.

  Matt Emerson recommends building the Lisp code a second time; see the
  ``MacOS Build Instructions'' above for his rationale.

    echo \"(in-package :ccl) (rebuild-ccl :full t :verbose t :clean t)\" | \\
          ./fx86cl64 -n |& tee ./ccl-build-compile-2.log

  Finally, one may specialize the final image by:

    cat ~/a/scripts/configure-ccl.lisp | ./fx86cl64 -n |& tee ~/ccl-build-specialize.log

  where ``configure-ccl.lisp'' (not supplied) contains whatever CCL
  specialization commands you wish to have in the version of CCL you
  use for ACL2 or other work.


configure-ccl.lisp

  Sample ``configure-ccl.lisp'' file for 64-bit implementation:

    (progn
      ;; Parameters to configure CCL for use on FreeBSD and MacOS

      (in-package :ccl)

      ;; Enlarge stack sizes
      (setq *default-value-stack-size*                    (expt 2 28))
      (setq *initial-listener-value-stack-size*           (expt 2 28))

      (setq *default-temp-stack-size*                     (expt 2 24))
      (setq *initial-listener-temp-stack-size*            (expt 2 24))

      (setq *default-control-stack-size*                  (expt 2 24))
      (setq *initial-listener-default-control-stack-size* (expt 2 24))

      ;; For CCL double precision
      (setf *read-default-float-format* 'double-float)

      ;; Make DEFUN save the source code for later recovery via
      ;; FUNCTION-LAMBDA-EXPRESSION.
      (setq *save-definitions* t)
      (setq *fasl-save-definitions* t)

      ;; Make GC verbose; see ACL2 documentation topic GC-VERBOSE.
      (gc-verbose t t)

      ;; Dump executable heap image; see ACL2 documentation topic SAVE-EXEC.
      (save-exec *heap-image-name* \"Modification string to print at startup\")
      )")
 (CCL-INSTALLATION-LINUX-BRIEF
  (CCL-INSTALLATION)
  "Installing Clozure Common Lisp (CCL) on Linux (brief version)

  See [ccl-installation] for introductory remarks.  The instructions
  below describe how to install CCL on Linux.  For more elaborate
  ``cookbook'' instructions see [ccl-installation-linux-elaborate].

  Note: Linux users may need to install m4.

  Fetch CCL from GitHub into a fresh subdirectory, ccl/.

    git clone https://github.com/Clozure/ccl

  Next fetch and extract a development snapshot in the new ccl
  directory.  The version below is current as of this writing (April,
  2021), but see {https://github.com/Clozure/ccl/releases/ |
  https://github.com/Clozure/ccl/releases/} for the latest snapshots.

    cd ccl
    wget https://github.com/Clozure/ccl/releases/download/v1.12/linuxx86.tar.gz
    tar xfz linuxx86.tar.gz

  Rebuild and quit, twice.

    echo '(rebuild-ccl :full t)' | ./lx86cl64
    echo '(rebuild-ccl :full t)' | ./lx86cl64

  Create the following executable script, which you will probably want
  to name \"ccl\", where <DIR> is the absolute pathname (without using
  ``~'') of the directory in which you issued the ``git clone''
  command.  Place this script wherever you wish, though putting it in
  a directory on your Unix PATH might be helpful (since then you can
  invoke it as, say \"ccl\").

    #!/bin/sh

    export CCL_DEFAULT_DIRECTORY=<DIR>/ccl
    ${CCL_DEFAULT_DIRECTORY}/scripts/ccl64 \"$@\"

  You're done!  (Note however that certification of [books] that use
  [Quicklisp] may require openssl to be installed if it is not
  already on your system.)")
 (CCL-INSTALLATION-LINUX-ELABORATE
  (CCL-INSTALLATION)
  "Installing Clozure Common Lisp (CCL) on Linux (elaborate version)

  See [ccl-installation] for introductory remarks.  The ``cookbook''
  instructions below give you one way to install CCL on Linux without
  any knowledge of git or CCL.  For more streamlined instructions see
  [ccl-installation-linux-brief].

  Note: Linux users may need to install m4.

  First fetch CCL from GitHub as follows.  (You may prefer to use ``git
  pull'' if you previously did this step.  In that case you probably
  won't want to do the optional renaming of the directory, mentioned
  below.)

    # Obtain a ccl distribution in a fresh directory:
    mkdir temp
    cd temp
    git clone https://github.com/Clozure/ccl
    # Optionally rename that directory as suggested below, after
    # executing the following three commands.
    cd ccl
    git rev-parse HEAD
    cd ../../
    # Optionally change directory name, and then go back to ccl directory:
    # You'll want the last 10 hex digits to match those of the
    # output from the ``git rev-parse HEAD'' command above: do
    # that twice here and once further below.
    mv temp 2017-12-07-6be8298fe5
    cd 2017-12-07-6be8298fe5/ccl

  Next fetch and extract a development snapshot.  The version below is
  current as of this writing (December, 2021), but see
  {https://github.com/Clozure/ccl/releases/ |
  https://github.com/Clozure/ccl/releases/} for the latest snapshots.

    wget https://github.com/Clozure/ccl/releases/download/v1.12.1/linuxx86.tar.gz
    tar xfz linuxx86.tar.gz

  Rebuild and quit, twice.

    echo '(rebuild-ccl :full t)' | ./lx86cl64
    echo '(rebuild-ccl :full t)' | ./lx86cl64

  Create an executable script like the following.  You might want to
  call it ``ccl'' and put it into a directory on your path.  Be sure
  to change the name (shown as ``2017-12-07-6be8298fe5'' above) to
  match the name change already made above.

    #!/bin/sh

    export CCL_DEFAULT_DIRECTORY=/projects/acl2/lisps/ccl/2017-12-07-6be8298fe5/ccl
    ${CCL_DEFAULT_DIRECTORY}/scripts/ccl64 \"$@\"

  Now ensure that your script is executable, e.g.:

    chmod +x my-script

  You're done!  (Note however that certification of [books] that use
  [Quicklisp] may require openssl to be installed if it is not
  already on your system.)")
 (CCL-INSTALLATION-MAC-BRIEF
  (CCL-INSTALLATION)
  "Installing Clozure Common Lisp (CCL) on Mac (brief version)

  See [ccl-installation] for introductory remarks.  The instructions
  below describe how to install CCL on a Mac (Darwin).  For more
  elaborate ``cookbook'' instructions see
  [ccl-installation-mac-elaborate].

  Fetch CCL from GitHub into a fresh subdirectory, ccl/.

    git clone https://github.com/Clozure/ccl

  Next fetch and extract a development snapshot in the new ccl
  directory.  The version below is current as of this writing (April,
  2021), but see {https://github.com/Clozure/ccl/releases/ |
  https://github.com/Clozure/ccl/releases/} for the latest snapshots.

    cd ccl
    curl -O -L https://github.com/Clozure/ccl/releases/download/v1.12/darwinx86.tar.gz
    tar xfz darwinx86.tar.gz

  Rebuild the lisp kernel by hand before trying to rebuild the lisp.

    cd lisp-kernel/darwinx8664; make clean; make
    cd -

  Rebuild and quit, twice.

    echo '(rebuild-ccl :clean t)' | ./dx86cl64
    echo '(rebuild-ccl :clean t)' | ./dx86cl64

  Create the following executable script, which you will probably want
  to name \"ccl\", where <DIR> is the absolute pathname (without using
  ``~'') of the directory in which you issued the ``git clone''
  command.  Place this script wherever you wish, though putting it in
  a directory on your Unix PATH might be helpful (since then you can
  invoke it as, say \"ccl\").

    #!/bin/sh

    export CCL_DEFAULT_DIRECTORY=<DIR>/ccl
    ${CCL_DEFAULT_DIRECTORY}/scripts/ccl64 \"$@\"

  You're done!  (Note however that certification of [books] that use
  [Quicklisp] may require openssl to be installed if it is not
  already on your system.)")
 (CCL-INSTALLATION-MAC-ELABORATE
  (CCL-INSTALLATION)
  "Installing Clozure Common Lisp (CCL) on Mac (elaborate version)

  See [ccl-installation] for introductory remarks.  The ``cookbook''
  instructions below give you one way to install CCL on a Mac
  (Darwin) without any knowledge of git or CCL.  For more streamlined
  instructions see [ccl-installation-mac-brief].

  First fetch CCL from GitHub as follows.  (You may prefer to use ``git
  pull'' if you previously did this step.  In that case you probably
  won't want to do the optional renaming of the directory, mentioned
  below.)

    # Obtain a ccl distribution in a fresh directory:
    mkdir temp
    cd temp
    git clone https://github.com/Clozure/ccl
    # Optionally rename that directory as suggested below, after
    # executing the following three commands.
    cd ccl
    git rev-parse HEAD
    cd ../../
    # Optionally change directory name, and then go back to ccl directory:
    # You'll want the last 10 hex digits to match those of the
    # output from the ``git rev-parse HEAD'' command above: do
    # that twice here and once further below.
    mv temp 2017-12-07-6be8298fe5
    cd 2017-12-07-6be8298fe5/ccl

  Next fetch and extract a development snapshot.  The version below is
  current as of this writing (December, 2021), but see
  {https://github.com/Clozure/ccl/releases/ |
  https://github.com/Clozure/ccl/releases/} for the latest snapshots.

    curl -L -O https://github.com/Clozure/ccl/releases/download/v1.12.1/darwinx86.tar.gz
    tar xfz darwinx86.tar.gz

  Rebuild the lisp kernel by hand before trying to rebuild the lisp.
  (Note: This step was formerly unnecessary and might become
  unnecessary again, but it seems to have been necessary on MacOS
  Catalina (10.15).

    cd lisp-kernel/darwinx8664; make clean; make
    cd -

  Rebuild and quit, twice.

    echo '(rebuild-ccl :clean t)' | ./dx86cl64
    echo '(rebuild-ccl :clean t)' | ./dx86cl64

  Create an executable script like the following.  You might want to
  call it ``ccl'' and put it into a directory on your path.  Be sure
  to change the name (shown as ``2017-12-07-6be8298fe5'' above) to
  match the name change already made above.

    #!/bin/sh

    export CCL_DEFAULT_DIRECTORY=/projects/acl2/lisps/ccl/2017-12-07-6be8298fe5/ccl
    ${CCL_DEFAULT_DIRECTORY}/scripts/ccl64 \"$@\"

  Now ensure that your script is executable, e.g.:

    chmod +x my-script

  You're done!  (Note however that certification of [books] that use
  [Quicklisp] may require openssl to be installed if it is not
  already on your system.)")
 (CCL-UPDATES (POINTERS)
              "See [ccl-installation].")
 (CDAAAR
    (CONSES ACL2-BUILT-INS)
    "[cdr] of the [caaar]

  See any Common Lisp documentation for details.")
 (CDAADR
    (CONSES ACL2-BUILT-INS)
    "[cdr] of the [caadr]

  See any Common Lisp documentation for details.")
 (CDAAR
     (CONSES ACL2-BUILT-INS)
     "[cdr] of the [caar]

  See any Common Lisp documentation for details.")
 (CDADAR
    (CONSES ACL2-BUILT-INS)
    "[cdr] of the [cadar]

  See any Common Lisp documentation for details.")
 (CDADDR
    (CONSES ACL2-BUILT-INS)
    "[cdr] of the [caddr]

  See any Common Lisp documentation for details.")
 (CDADR
     (CONSES ACL2-BUILT-INS)
     "[cdr] of the [cadr]

  See any Common Lisp documentation for details.")
 (CDAR
      (CONSES ACL2-BUILT-INS)
      "[cdr] of the [car]

  See any Common Lisp documentation for details.")
 (CDDAAR
    (CONSES ACL2-BUILT-INS)
    "[cdr] of the [cdaar]

  See any Common Lisp documentation for details.")
 (CDDADR
    (CONSES ACL2-BUILT-INS)
    "[cdr] of the [cdadr]

  See any Common Lisp documentation for details.")
 (CDDAR
     (CONSES ACL2-BUILT-INS)
     "[cdr] of the [cdar]

  See any Common Lisp documentation for details.")
 (CDDDAR
    (CONSES ACL2-BUILT-INS)
    "[cdr] of the [cddar]

  See any Common Lisp documentation for details.")
 (CDDDDR
    (CONSES ACL2-BUILT-INS)
    "[cdr] of the [cdddr]

  See any Common Lisp documentation for details.")
 (CDDDR
     (CONSES ACL2-BUILT-INS)
     "[cdr] of the [cddr]

  See any Common Lisp documentation for details.")
 (CDDR
      (CONSES ACL2-BUILT-INS)
      "[cdr] of the [cdr]

  See any Common Lisp documentation for details.")
 (CDR
  (CONSES ACL2-BUILT-INS)
  "Returns the second element of a [cons] pair, else nil

  Completion Axiom (completion-of-cdr):

    (equal (cdr x)
           (cond
            ((consp x)
             (cdr x))
            (t nil)))

  [Guard]:

    (or (consp x) (equal x nil))

  Notice that in the ACL2 logic, cdr returns nil for every [atom].")
 (CEILING
  (NUMBERS ACL2-BUILT-INS)
  "Division returning an integer by truncating toward positive infinity

    Example Forms:
    ACL2 !>(ceiling 14 3)
    5
    ACL2 !>(ceiling -14 3)
    -4
    ACL2 !>(ceiling 14 -3)
    -4
    ACL2 !>(ceiling -14 -3)
    5
    ACL2 !>(ceiling -15 -3)
    5

  (Ceiling i j) is the result of taking the quotient of i and j and
  returning the smallest integer that is at least as great as that
  quotient.  For example, the quotient of -14 by 3 is -4 2/3, and the
  smallest integer at least that great is -4.

  The [guard] for (ceiling i j) requires that i and j are rational
  ([real], in ACL2(r)) numbers and j is non-zero.

  Ceiling is a Common Lisp function.  See any Common Lisp documentation
  for more information.  However, note that unlike Common Lisp, the
  ACL2 ceiling function returns only a single value,

  Function: <ceiling>

    (defun ceiling (i j)
           (declare (xargs :guard (and (real/rationalp i)
                                       (real/rationalp j)
                                       (not (eql j 0)))))
           (let* ((q (* i (/ j)))
                  (n (numerator q))
                  (d (denominator q)))
                 (cond ((= d 1) n)
                       ((>= n 0)
                        (+ (nonnegative-integer-quotient n d)
                           1))
                       (t (- (nonnegative-integer-quotient (- n)
                                                           d))))))")
 (CERTIFICATE
  (BOOKS-TOUR)
  "A file specifying validity of a given book

  A book, say \"arith\", is said to have a ``certificate'' if there is a
  file named \"arith.cert\".  Certificates are created by the function
  [certify-book] and inspected by [include-book].  [Book-hash] values
  are used to help ensure that certificates are legitimate and that
  the corresponding book has not been modified since certification.
  But because the file system is insecure and book-hash values are
  not perfect, it is possible for the inclusion of a book to cause
  inconsistency even though the book carries an impeccable
  certificate.

  The certificate includes the version number of the certifying ACL2.
  A book is considered uncertified if it is included in an ACL2 with
  a different [version] number.

  The presence of a ``valid'' certificate file for a book attests to
  two things: all of the [events] of the book are admissible in a
  certain extension of the initial ACL2 logic, and the non-[local]
  [events] of the book are independent of the [local] ones (see
  [local-incompatibility]).  In addition, the certificate contains
  the [command]s used to construct the [world] in which certification
  occurred.  Among those [command]s, of course, are the [defpkg]s
  defining the packages used in the book.  When a book is included
  into a host [world], that [world] is first extended by the
  [command]s listed in the certificate for the book.  Unless that
  causes an error due to name conflicts, the extension ensures that
  all the packages used by the book are identically defined in the
  host [world].

  Security:

  Because the host file system is insecure, there is no way ACL2 can
  guarantee that the contents of a book remain the same as when its
  certificate was written.  That is, between the time a book is
  certified and the time it is used, it may be modified.
  Furthermore, certificates can be counterfeited.  [Book-hash] values
  are used to help detect such problems, but provide imperfect
  security: two different files can have the same book-hash.

  Therefore, from the strictly logical point of view, one must consider
  even the inclusion of certified [books] as placing a burden on the
  user:

      The non-erroneous inclusion of a certified book is consistency
      preserving provided (a) the objects read by [include-book] from
      the certificate were the objects written there by a
      [certify-book] and (b) the forms read by [include-book] from
      the book itself are the forms read by the corresponding
      [certify-book].

  We say that a given execution of [include-book] is ``certified'' if a
  certificate file for the book is present and well-formed and the
  [book-hash] information contained within it supports the conclusion
  that the [events] read by the [include-book] are the ones checked
  by [certify-book].  When an uncertified [include-book] occurs,
  warnings are printed or errors are caused.  But even if no warning
  is printed, you must accept burdens (a) and (b) if you use [books].
  These burdens are easier to live with if you protect your [books]
  so that other users cannot write to them, you abstain from running
  concurrent ACL2 jobs, and you abstain from counterfeiting
  certificates.  But even on a single user uniprocessor, you can
  shoot yourself in the foot by using the ACL2 [io] primitives to
  fabricate an inconsistent book and the corresponding certificate.

  Note that part (a) of the burden described above implies, in
  particular, that there are no guarantees when a certificate is
  copied.  When [books] are renamed (as by copying them), it is
  recommended that their certificates be removed and the [books] be
  recertified.  The expectation is that recertification will go
  through without a hitch if relative [pathname]s are used.  See
  [pathname], which is not on the guided tour.

  Certificates contain a [portcullis] and a [keep], each documented
  later in this guided tour through [books].  We mention here two
  other parts, which we do not document elsewhere because we view
  them as implementation details: an expansion-alist, which records
  [make-event] expansions; and cert-data, which contains logical
  information associated with the book.  (Those curious about
  cert-data are invited to look at the ``Essay on Cert-data'' in the
  source code.)

  See [portcullis] to continue the guided tour through [books].


Subtopics

  [Checksum]
      Assigning ``often unique'' integers to files and objects")
 (CERTIFY-BOOK
  (BOOKS-REFERENCE BOOKS-TOUR)
  "How to produce a [certificate] for a book

  Also see [certificate] for information about the \".cert\" file
  produced by certify-book, in particular for information about the
  use of [book-hash] values to help ensure that the corresponding
  book has not been modified since certification.  See
  [certify-book-debug] for some potential remedies for failures of
  certify-book.

    Examples:
    (certify-book \"my-arith\")          ; certify in a world with 0 commands
    (certify-book \"my-arith\" 3)        ; ... in a world with 3 commands
    (certify-book \"my-arith\" ?)        ; ... in a world without checking the
                                       ;     number of commands
    (certify-book \"my-arith\" 0 nil)    ; ... without compilation
    (certify-book \"my-arith\" 0 t)      ; ... with compilation (default)
    (certify-book \"my-arith\" 0 t :ttags (foo))
                                       ; ... allowing trust tag (ttag) foo
    (certify-book \"my-arith\" 0 t :ttags :all)
                                       ; ... allowing all trust tags (ttags)
    (certify-book \"my-arith\" 0 nil :acl2x t)
                                       ; ... writing or reading a .acl2x file
    (certify-book \"my-arith\" 0 t :useless-runes :write)
                                       ; ... write file to speed up future proofs
    (certify-book \"my-arith\" 0 t :useless-runes :read)
                                       ; ... read file to speed up future proofs

    General Form:
    (certify-book book-name
                  k                       ; [default 0]
                  compile-flg             ; [default t]
                  :defaxioms-okp t/nil    ; [default nil]
                  :skip-proofs-okp t/nil  ; [default nil]
                  :ttags ttags            ; [default nil]
                  :acl2x t/nil            ; [default nil]
                  :ttagsx ttags           ; [default nil]
                  :pcert pcert            ; [default nil]
                  :write-port t/nil       ; [default t unless pcert is non-nil]
                  :useless-runes          ; :write/:read/:read?/n/-n/nil
                                          ;   (-100 < n < 0 or 0 < n <= 100)
                                          ;   [default nil or from environment]
                  )

  where book-name is a book name (see [book-name]), k is used to
  indicate your approval of the ``certification [world],'' and
  compile-flg can control whether the book is to be compiled.  The
  defaults for compile-flg, skip-proofs-okp, acl2x, write-port,
  pcert, and :useless-runes can be affected by environment variables.
  All of these arguments are described in detail below, except for
  :pcert and :useless-runes: see [provisional-certification] and
  [useless-runes], respectively, for the effects of these two
  arguments and their corresponding environment variables, as we
  ignore those effects in the present topic.

  Certification occurs in some logical [world], called the
  ``certification [world].'' That [world] must contain the [defpkg]s
  needed to read and execute the forms in the book.  The [command]s
  necessary to recreate that [world] from the ACL2 initial [world]
  are called the ``[portcullis] commands,'' and will be copied into
  the [certificate] created for the book.  Those [command]s will be
  re-executed whenever the book is included, to ensure that the
  appropriate packages (and all other names used in the certification
  [world]) are correctly defined.  Note that Step 1 of certify-book
  will fail if a package mentioned in the book is not defined before
  attempting the certification, i.e., defined by a portcullis command
  in the certification world.  For example, suppose that your book
  contains the symbol FOO::X, but the package \"FOO\" is not currently
  defined.  Then an error message will likely complain either about a
  missing package \"FOO\", or about a symbol FOO::X that is ``not in
  any of the packages known to ACL2.'' A solution is to define the
  package \"FOO\", perhaps directly using [defpkg] or by including a
  book that defines this package, before attempting the
  certification.

  The certified book will be more often usable if the certification
  [world] is kept to a minimal extension of the ACL2 initial [world]
  (for example, to prevent name clashes with functions defined in
  other books, or to avoid including undesired rules).
  Alternatively, use [local] [events] to build your certification
  world, as these will be skipped when including the certified book.
  But perhaps it's simplest just to get into the initial ACL2 [world]
  (e.g., with :ubt 1 or by just starting a new ACL2 run), then define
  the desired packages (directly with [defpkg] or by including books
  that define the packages), and finally invoke certify-book.

  The k argument to certify-book has default value 0, and it must be
  either a nonnegative integer or else the symbol ? in any package.
  If k is an integer, then it must be the number of [command]s that
  have been executed after the initial ACL2 [world] to create the
  [world] in which certify-book was called.  One way to obtain this
  number is by doing :pbt :start to see all the [command]s back to
  the first one.

  Otherwise, k is ? (or any symbol whose [symbol-name] is \"?\").  In
  that case there is no check made on the certification world.  This
  can be a nice convenience but at the cost of eliminating a
  potentially valuable check that the certification [world] may be as
  expected.

  We next describe the meaning of compile-flg and how it defaults.  If
  explicit compilation has been suppressed by (set-compiler-enabled
  nil state), then compile-flg is coerced to nil; see [compilation].
  Otherwise compile-flg may be given the value of t (or :all, which
  is equivalent to t except during provisional certification; see
  [provisional-certification]), indicating that the book is to be
  compiled, or else nil.  (Note that compilation initially creates a
  compiled file with a temporary file name, and then moves that
  temporary file to the final compiled file name obtained by adding a
  suitable extension to the book name.  Thus, a compiled file will
  appear atomically in its intended location.)  Finally, suppose that
  compile-flg is not supplied (or is :default).  If environment
  variable ACL2_COMPILE_FLG is defined and not the empty string, then
  its value should be T, NIL, or ALL after converting to upper case,
  in which case compile-flg is considered to have value t, nil, or
  :all (respectively).  Otherwise compile-flg defaults to t.  Note
  that the value :all is equivalent to t except for during the
  Convert procedure of provisional certification; see
  [provisional-certification].

  Two keyword arguments, :defaxioms-okp and :skip-proofs-okp, determine
  how the system handles the inclusion of [defaxiom] events and
  [skip-proofs] events, respectively, in the book.  The value t
  allows such events, but prints a warning message.  The value nil
  causes an error if such an event is found.  Nil is the default
  unless keyword argument :acl2x t is provided and state global
  'write-acl2x is a cons (see [set-write-ACL2x]), in which case the
  default is t.

  The keyword argument :ttags may normally be omitted.  A few
  constructs, used for example if you are building your own system
  based on ACL2, may require it.  See [defttag] for an explanation of
  this argument.

  When book B is certified with value t (the default, unless the value
  used for pcert is non-nil) for keyword argument :write-port, a file
  B.port is written by certification process.  This file contains all
  of the [portcullis] [command]s for B, i.e., all user commands
  present in the ACL2 logical [world] at the time certify-book is
  called.  If B.lisp later becomes uncertified, say because [events]
  from that file or an included book have been edited, then
  (include-book \"B\") will consult B.port to evaluate forms in that
  file before evaluating the events in B.lisp.  On the other hand,
  B.port is ignored when including B if B is certified.

  If you use [guard]s, please note certify-book is executed as though
  (set-guard-checking t) has been evaluated; see
  [set-guard-checking].  If you want to run with different
  guard-checking, consider using ld instead, or in addition; see
  [ld].

  For a general discussion of books, see [books].  Certify-book is akin
  to what we have historically called a ``proveall'': all the forms
  in the book are ``proved'' to guarantee their admissibility.  More
  precisely, certify-book (1) reads the forms in the book, confirming
  that the appropriate packages are defined in the certification
  [world]; (2) does the full admissibility checks on each form
  (proving termination of recursive functions, proving theorems,
  etc.), checking as it goes that each form is an embedded event form
  (see [embedded-event-form]); (3) may roll back the [world] (how
  far? --- see below) and perform an [include-book] to check for
  [local] incompatibilities (see [local-incompatibility]); (4) writes
  a [certificate] recording not only that the book was certified but
  also recording the [command]s necessary to recreate the
  certification [world] (so the appropriate packages can be defined
  when the book is included in other [world]s) and a [book-hash] for
  each of the [books] involved (see [certificate]); and (5) compiles
  the book if so directed (and then loads the object file in that
  case).

  Certify-book is a macro that returns an [error-triple], where success
  is indicated by an error component of nil and has the effect of
  extending the [world] with a corresponding [include-book] event.
  If you don't want the included book's [events] in your present
  [world], simply execute :[u].

  Technical Remark.  Step 3 above mentions rolling the logical [world]
  back to check for local incompatibilities.  For efficiency, this
  retraction to an initial segment of the the world is skipped if a
  local event is not encountered, and otherwise the world is rolled
  back through the first local event past the boot-strap world ---
  see [local-incompatibility] --- before the book is included to
  check for local incompatibilities.  Note that if that first local
  event is in the certification world, then all commands from that
  event onward will be undone by the certify-book call.  End of
  Technical Remark.

  A utility is provided to assist in debugging failures of
  certify-book; see [redo-flat].)

  Certify-book requires that the default [defun-mode] (see
  [default-defun-mode]) be :[logic] when certification is attempted.
  If the mode is not :[logic], an error is signaled.

  An error will occur if certify-book has to deal with any uncertified
  book other than the one on which it was called.  For example, if
  the book being certified includes another book, that sub-book must
  already have been certified; that is, that sub-book must have a
  valid [certificate] file.

  If you have a certified book that has remained unchanged for some
  time you might well not remember the appropriate [defpkg]s for it,
  though they are stored in the [certificate] file and (by default)
  also in the .port file.  If you begin to change the book, don't
  throw away its [certificate] file just because it has become
  invalid!  It is an important historical document until the book is
  re-certified.  More important, don't throw away the .port file, as
  it will provide the [portcullis] commands when including the book
  as an uncertified book; see [include-book].

  When certify-book is directed to produce a compiled file, it calls
  the Common Lisp function compile-file on the original source file.
  This creates a compiled file with an extension known to ACL2, e.g.,
  if the book is named \"my-book\" then the source file is
  \"my-book.lisp\" and the compiled file under GCL will be \"my-book.o\"
  while under SBCL it will be \"my-book.fasl\".  The compiled file is
  then loaded.  When [include-book] is used later on \"my-book\" it
  will automatically load the compiled file, provided the compiled
  file has a later write date than the source file.  The only effect
  of such [compilation] and loading is that the functions defined in
  the book execute faster.  See [guard] for a discussion of the
  issues, and if you want more details about [books] and compilation,
  see [book-compiled-file].

  When certify-book is directed not to produce a compiled file, it will
  delete any existing compiled file for the book, so as not to
  mislead [include-book] into loading the now outdated compiled file.
  Otherwise, certify-book will create a temporary ``expansion file''
  to compile, obtained by appending the string \"@expansion.lsp\" to
  the end of the book name.  Remark: Users may ignore that file,
  which is automatically deleted unless [state] global variable
  'save-expansion-file has been set, presumably by a system
  developer, to a non-nil value; see [book-compiled-file] for more
  information about hit issue, including the role of environment
  variable ACL2_SAVE_EXPANSION.

  After execution of a certify-book form, the value of
  [ACL2-defaults-table] is restored to what it was immediately before
  that certify-book form was executed.  See [ACL2-defaults-table].

  Those who use the relatively advanced features of trust tags (see
  [defttag]) and [make-event] may wish to know how to create a
  [certificate] file that avoids dependence on trust tags that are
  used only during [make-event] expansion.  For this, including
  documentation of the :acl2x and :ttagsx keyword arguments for
  certify-book, see [set-write-ACL2x].

  This completes the tour through the [documentation] of [books].


Subtopics

  [Certify-book!]
      A variant of [certify-book]

  [Certify-book-debug]
      Some possible ways to work around [certify-book] failures

  [Useless-runes]
      Speed up proofs by disabling useless [rune]s")
 (CERTIFY-BOOK!
  (CERTIFY-BOOK)
  "A variant of [certify-book]

    Examples:
    (certify-book! \"my-arith\" 3)     ;Certify in a world with 3
                                       ; commands, starting in a world
                                       ; with at least 3 commands.
    (certify-book! \"my-arith\")       ;Certify in the initial world.

    General Form:
    (certify-book! book-name k compile-flg)

  where book-name is a book name (see [book-name]), k is a nonnegative
  integer used to indicate the ``certification [world],'' and
  compile-flg indicates whether you wish to compile the (functions in
  the) book.

  This [command] is identical to [certify-book], except that the second
  argument k may not be t in certify-book! and if k exceeds the
  current [command] number, then an appropriate [ubt!] will be
  executed first.  See [certify-book] and see [ubt!].")
 (CERTIFY-BOOK-DEBUG
  (CERTIFY-BOOK BOOKS-REFERENCE)
  "Some possible ways to work around [certify-book] failures

  This topic provides some ideas for how to deal with [certify-book]
  failures.  Ideally, this topic will continue to grow over time.

  Stack overflows may show up as follows.

    ***********************************************
    ************ ABORTING from raw Lisp ***********
    ********** (see :DOC raw-lisp-error) **********
    Error:  Stack overflow on value stack.
    ***********************************************

  When this occurs during book certification, it could be during an
  attempt to handle large objects, in particular by the [serialize]
  writer or by a [memoize]d version of the check for ``bad'' objects.
  These two potential causes can be remedied by first evaluating the
  following forms, respectively.

    (set-serialize-character-system nil state)
    (set-bad-lisp-consp-memoize nil)

  If the large object is in an event in the book under certification,
  then you may need to avoid printing it, as follows.

    (set-inhibit-output-lst '(proof-tree event))

  Other failures of certify-book may have error messages that point to
  the problem.  When that is not the case, it would be good to
  explain possible workarounds in this topic!")
 (CERTIFY-BOOK-FAILURE (POINTERS)
                       "See [certify-book-debug].")
 (CERTIFYING-BOOKS (POINTERS)
                   "See [books-certification].")
 (CHANGE
  (DEFREC ACL2-BUILT-INS)
  "Mutator macro for [defrec] structures.

  The change macro is built into ACL2, and allows you to \"modify\"
  instances of structures that have been introduced with [defrec].
  Of course, since ACL2 is applicative, the original structure is not
  actually changed---instead, a new structure is constructed, copying
  some fields from the original structure and installing new values
  for other fields.

  For instance, suppose we first use [make] to create an employee
  structure, e.g.,:

    (defconst *jimmy* (make employee :name \"Jimmy\"
                                     :salary 0
                                     :position \"Unpaid Intern\")

  Then we can use change to mutate this structure, e.g.,:

    (change employee *jimmy* :salary 300000
                             :position \"Vice President\")

  Produces a new employee structure where the name is still \"Jimmy\",
  but where the salary and position have been updated to 300000 and
  \"Vice President\", respectively.

  See [defrec] for more information.")
 (CHAR
  (STRINGS CHARACTERS ACL2-BUILT-INS)
  "The [nth] element (zero-based) of a string

  (Char s n) is the nth element of s, zero-based.  If n is greater than
  or equal to the length of s, then char returns nil.

  (Char s n) has a [guard] that n is a non-negative integer and s is a
  [stringp].

  Char is a Common Lisp function.  See any Common Lisp documentation
  for more information.

  Function: <char>

    (defun char (s n)
           (declare (xargs :guard (and (stringp s)
                                       (integerp n)
                                       (>= n 0)
                                       (< n (length s)))))
           (nth n (coerce s 'list)))")
 (CHAR-CODE
  (CHARACTERS NUMBERS ACL2-BUILT-INS)
  "The numeric code for a given character

  This function maps a character to its code, for example: (char-code
  #\\A) evaluates to 65.  See [code-char] for a sort of inverse
  function, which maps a code to the corresponding character.

  Completion Axiom (completion-of-char-code):

    (equal (char-code x)
           (if (characterp x)
               (char-code x)
             0))

  [Guard] for (char-code x):

    (characterp x)

  This function maps all non-characters to 0.")
 (CHAR-DOWNCASE
  (CHARACTERS ACL2-BUILT-INS)
  "Turn upper-case [characters] into lower-case [characters]

  (Char-downcase x) is equal to #\\a when x is #\\A, #\\b when x is #\\B,
  ..., and #\\z when x is #\\Z, and is x for any other character.

  The [guard] for char-downcase requires its argument to be a standard
  character (see [standard-char-p]).

  Char-downcase is a Common Lisp function.  See any Common Lisp
  documentation for more information.

  Function: <char-downcase>

    (defun char-downcase (x)
           (declare (xargs :guard (and (characterp x)
                                       (standard-char-p x))))
           (let ((pair (assoc x
                              '((#\\A . #\\a)
                                (#\\B . #\\b)
                                (#\\C . #\\c)
                                (#\\D . #\\d)
                                (#\\E . #\\e)
                                (#\\F . #\\f)
                                (#\\G . #\\g)
                                (#\\H . #\\h)
                                (#\\I . #\\i)
                                (#\\J . #\\j)
                                (#\\K . #\\k)
                                (#\\L . #\\l)
                                (#\\M . #\\m)
                                (#\\N . #\\n)
                                (#\\O . #\\o)
                                (#\\P . #\\p)
                                (#\\Q . #\\q)
                                (#\\R . #\\r)
                                (#\\S . #\\s)
                                (#\\T . #\\t)
                                (#\\U . #\\u)
                                (#\\V . #\\v)
                                (#\\W . #\\w)
                                (#\\X . #\\x)
                                (#\\Y . #\\y)
                                (#\\Z . #\\z)))))
                (cond (pair (cdr pair))
                      ((characterp x) x)
                      (t (code-char 0)))))")
 (CHAR-EQUAL
  (CHARACTERS ACL2-BUILT-INS)
  "Character equality without regard to case

  For [characters] x and y, (char-equal x y) is true if and only if x
  and y are the same except perhaps for their case.

  The [guard] on char-equal requires that its arguments are both
  standard [characters] (see [standard-char-p]).

  Char-equal is a Common Lisp function.  See any Common Lisp
  documentation for more information.

  Function: <char-equal>

    (defun char-equal (x y)
           (declare (xargs :guard (and (characterp x)
                                       (standard-char-p x)
                                       (characterp y)
                                       (standard-char-p y))))
           (eql (char-downcase x)
                (char-downcase y)))")
 (CHAR-UPCASE
  (CHARACTERS ACL2-BUILT-INS)
  "Turn lower-case [characters] into upper-case [characters]

  (Char-upcase x) is equal to #\\A when x is #\\a, #\\B when x is #\\b,
  ..., and #\\Z when x is #\\z, and is x for any other character.

  The [guard] for char-upcase requires its argument to be a standard
  character (see [standard-char-p]).

  Char-upcase is a Common Lisp function.  See any Common Lisp
  documentation for more information.

  Function: <char-upcase>

    (defun char-upcase (x)
           (declare (xargs :guard (and (characterp x)
                                       (standard-char-p x))))
           (let ((pair (assoc x
                              '((#\\a . #\\A)
                                (#\\b . #\\B)
                                (#\\c . #\\C)
                                (#\\d . #\\D)
                                (#\\e . #\\E)
                                (#\\f . #\\F)
                                (#\\g . #\\G)
                                (#\\h . #\\H)
                                (#\\i . #\\I)
                                (#\\j . #\\J)
                                (#\\k . #\\K)
                                (#\\l . #\\L)
                                (#\\m . #\\M)
                                (#\\n . #\\N)
                                (#\\o . #\\O)
                                (#\\p . #\\P)
                                (#\\q . #\\Q)
                                (#\\r . #\\R)
                                (#\\s . #\\S)
                                (#\\t . #\\T)
                                (#\\u . #\\U)
                                (#\\v . #\\V)
                                (#\\w . #\\W)
                                (#\\x . #\\X)
                                (#\\y . #\\Y)
                                (#\\z . #\\Z)))))
                (cond (pair (cdr pair))
                      ((characterp x) x)
                      (t (code-char 0)))))")
 (CHAR<
  (CHARACTERS ACL2-BUILT-INS)
  "Less-than test for [characters]

  (char< x y) is true if and only if the character code of x is less
  than that of y.  See [char-code].

  The [guard] for char< specifies that its arguments are [characters].

  Char< is a Common Lisp function.  See any Common Lisp documentation
  for more information.

  Function: <char<>

    (defun char< (x y)
           (declare (xargs :guard (and (characterp x) (characterp y))))
           (< (char-code x) (char-code y)))")
 (CHAR<=
  (CHARACTERS ACL2-BUILT-INS)
  "Less-than-or-equal test for [characters]

  (char<= x y) is true if and only if the character code of x is less
  than or equal to that of y.  See [char-code].

  The [guard] for char<= specifies that its arguments are [characters].

  Char<= is a Common Lisp function.  See any Common Lisp documentation
  for more information.

  Function: <char<=>

    (defun char<= (x y)
           (declare (xargs :guard (and (characterp x) (characterp y))))
           (<= (char-code x) (char-code y)))")
 (CHAR>
  (CHARACTERS ACL2-BUILT-INS)
  "Greater-than test for [characters]

  (char> x y) is true if and only if the character code of x is greater
  than that of y.  See [char-code].

  The [guard] for char> specifies that its arguments are [characters].

  Char> is a Common Lisp function.  See any Common Lisp documentation
  for more information.

  Function: <char>>

    (defun char> (x y)
           (declare (xargs :guard (and (characterp x) (characterp y))))
           (> (char-code x) (char-code y)))")
 (CHAR>=
  (CHARACTERS ACL2-BUILT-INS)
  "Greater-than-or-equal test for [characters]

  (char>= x y) is true if and only if the character code of x is
  greater than or equal to that of y.  See [char-code].

  The [guard] for char>= specifies that its arguments are [characters].

  Char>= is a Common Lisp function.  See any Common Lisp documentation
  for more information.

  Function: <char>=>

    (defun char>= (x y)
           (declare (xargs :guard (and (characterp x) (characterp y))))
           (>= (char-code x) (char-code y)))")
 (CHARACTER-ALISTP
  (CHARACTERS ALISTS ACL2-BUILT-INS)
  "Recognizer for association lists with characters as keys

  (Character-alistp x) is true if and only if x is a list of pairs of
  the form (cons key val) where key is a [characterp].

  Function: <character-alistp>

    (defun character-alistp (x)
           (declare (xargs :guard t))
           (cond ((atom x) (eq x nil))
                 (t (and (consp (car x))
                         (characterp (car (car x)))
                         (character-alistp (cdr x))))))")
 (CHARACTER-ENCODING
  (IO)
  "How bytes are parsed into characters

  When the Common Lisp reader comes across bytes in a file or at the
  terminal, they are parsed into characters.  The simplest case is
  when each byte that is read is a standard character (see
  [standard-char-p]).  It is actually quite common that each byte
  that is read corresponds to a single character.  The parsing of
  bytes into characters is based on a character encoding, that is, a
  mapping that associates one or more bytes with each legal
  character.

  In order to help guarantee the portability of files (including
  [books]), ACL2 installs a common character encoding for reading
  files, often known as ISO-8859-1 or Latin-1.  For some host Lisps
  this character encoding is also used for reading from the terminal;
  but, sadly, this may not hold for all host Lisps, and may not even
  be possible for some of them.

  The use of the above encoding could in principle cause problems if
  one's editor produces files using an encoding other than
  ISO-8859-1, at least if one uses non-standard characters.  In
  particular, the default Emacs buffer encoding may be utf-8.  If
  your file has non-standard characters, then in Emacs you can
  evaluate the form

    (setq save-buffer-coding-system 'iso-8859-1)

  before saving the buffer into a file.  This will happen automatically
  for users who load distributed file emacs-acl2.el (from a suitable
  directory; see [emacs]) into their Emacs sessions.

  For an example of character encodings in action, see the community
  book books/misc/character-encoding-test.lisp.")
 (CHARACTER-LISTP
  (CHARACTERS LISTS ACL2-BUILT-INS)
  "Recognizer for a true list of characters

  The predicate character-listp tests whether its argument is a true
  list of [characters].

  Function: <character-listp>

    (defun character-listp (l)
           (declare (xargs :guard t))
           (cond ((atom l) (equal l nil))
                 (t (and (characterp (car l))
                         (character-listp (cdr l))))))")
 (CHARACTERP
  (CHARACTERS ACL2-BUILT-INS)
  "Recognizer for [characters]

  (characterp x) is true if and only if x is a character.")
 (CHARACTERS
  (PROGRAMMING)
  "Characters in ACL2 and operations on them

  ACL2 accepts 256 distinct characters, which are the characters
  obtained by applying the function [code-char] to each integer from
  0 to 255.  Among these, Common Lisp designates certain ones as
  standard characters, namely those of the form (code-char n) where n
  is from 33 to 126, together with #\\Newline and #\\Space.  The actual
  standard characters may be viewed by evaluating the [defconst]
  *standard-chars*.

  To be more precise, Common Lisp does not specify the precise
  relationship between [code-char] and the standard characters.
  However, we check that the underlying Common Lisp implementation
  uses a particular relationship that extends the usual ASCII coding
  of characters.  We also check that Space, Tab, Newline, Page,
  Rubout, and Return correspond to characters with respective
  [char-code]s 32, 9, 10, 12, 127, and 13.

  [Code-char] has an inverse, [char-code].  Thus, when [char-code] is
  applied to an ACL2 character, c, it returns a number n between 0
  and 255 inclusive such that (code-char n) = c.

  The preceding paragraph implies that there is only one ACL2 character
  with a given character code.  CLTL allows for ``attributes'' for
  characters, which could allow distinct characters with the same
  code, but ACL2 does not allow this.

  The Character Reader

  ACL2 supports the `#\\' notation for characters provided by Common
  Lisp, with some restrictions.  First of all, for every character c,
  the notation

    #\\c

  may be used to denote the character object c.  That is, the user may
  type in this notation and ACL2 will read it as denoting the
  character object c.  In this case, the character immediately
  following c must be one of the following ``terminating
  characters'': a Tab, a Newline, a Page character, a space, or one
  of the characters:

    \"  '  (  )  ;  `  ,

  Other than the notation above, ACL2 accepts alternate notation for
  five characters.

    #\\Space
    #\\Tab
    #\\Newline
    #\\Page
    #\\Rubout
    #\\Return

  Again, in each of these cases the next character must be from among
  the set of ``terminating characters'' described in the
  single-character case.  Our implementation is consistent with
  ISO-8859-1, even though we don't provide #\\ syntax for entering
  characters other than that described above.

  Finally, we note that it is our intention that any object printed by
  ACL2's top-level-loop may be read back into ACL2.  Please notify
  the implementors if you find a counterexample to this claim.


Subtopics

  [Alpha-char-p]
      Recognizer for alphabetic characters

  [Char]
      The [nth] element (zero-based) of a string

  [Char-code]
      The numeric code for a given character

  [Char-downcase]
      Turn upper-case [characters] into lower-case [characters]

  [Char-equal]
      Character equality without regard to case

  [Char-upcase]
      Turn lower-case [characters] into upper-case [characters]

  [Char<]
      Less-than test for [characters]

  [Char<=]
      Less-than-or-equal test for [characters]

  [Char>]
      Greater-than test for [characters]

  [Char>=]
      Greater-than-or-equal test for [characters]

  [Character-alistp]
      Recognizer for association lists with characters as keys

  [Character-listp]
      Recognizer for a true list of characters

  [Characterp]
      Recognizer for [characters]

  [Code-char]
      The character corresponding to a given numeric code

  [Coerce]
      Coerce a character list to a string and a string to a list

  [Digit-char-p]
      The number, if any, corresponding to a given character

  [Digit-to-char]
      Map a digit to a character

  [Explode-atom]
      Convert any [atom] into a [character-listp] that contains its
      printed representation, rendering numbers in your choice of
      print base.

  [Explode-nonnegative-integer]
      The list of [characters] in the radix-r form of a number

  [Lower-case-p]
      Recognizer for lower case characters

  [Make-character-list]
      [coerce] to a list of characters

  [Standard-char-listp]
      Recognizer for a true list of standard characters

  [Standard-char-p]
      Recognizer for standard characters

  [Standard-char-p+]
      Recognizer for standard characters whose guard is t

  [Upper-case-p]
      Recognizer for upper case characters")
 (CHECK-INVARIANT-RISK (POINTERS)
                       "See [set-check-invariant-risk].")
 (CHECK-SUM (POINTERS) "See [checksum].")
 (CHECK-VARS-NOT-FREE
  (MACROS)
  "Avoid variable capture in macro calls

  Check-vars-not-free is a macro that is useful for avoiding capture of
  variables in macro calls.  We explain using a running example,
  after which we give a precise explanation (at the end of this
  documentation topic).  These definitions are rather contrived but
  are designed to illustrate how check-vars-not-free can be useful.

    (defmacro has-length (x n)
      `(let ((k (len ,x)))
         (equal k ,n)))
    (defun f1 (u v)
      (and (natp v)
           (has-length u (* 2 v))))
    (defun f2 (lst k)
      (and (natp k)
           (has-length lst (* 2 k))))

  One might expect f1 and f2 to be the same function, since the only
  change seems to be from the choices of formal parameters.  However,
  consider these evaluations.

    ACL2 !>(f1 '(a b c d e f) 3)
    T
    ACL2 !>(f2 '(a b c d e f) 3)
    NIL
    ACL2 !>

  The problem becomes clear if we expand the macro call in the body of
  f2.

    ACL2 !>:trans1 (has-length lst (* 2 k))
     (LET ((K (LEN LST))) (EQUAL K (* 2 K)))
    ACL2 !>

  We see that when expanding the call of the macro has-length in the
  body of f2, the substitution of (* 2 k) for ,n causes k to
  be``captured'' by the binding of k to (len lst).

  The macro check-vars-not-free is designed to enforce that no such
  capture takes place.  An improved definition of has-length is as
  follows, since it insists that the variable k must not appear in
  the term that replaces ,n.

    (defmacro has-length (x n)
      `(let ((k (len ,x)))
         (equal k (check-vars-not-free (k) ,n))))

  Now, the attempt to define f2 as above causes an error.

    ACL2 !>(defun f2 (lst k)
       (and (natp k)
            (has-length lst (* 2 k))))


    ACL2 Error in ( DEFUN F2 ...):  CHECK-VARS-NOT-FREE failed:
    It is forbidden to use K in (BINARY-* '2 K).  Note:  this error occurred
    in the context (CHECK-VARS-NOT-FREE (K) (* 2 K)).


    Summary
    Form:  ( DEFUN F2 ...)
    Rules: NIL
    Time:  0.00 seconds (prove: 0.00, print: 0.00, other: 0.00)

    ACL2 Error in ( DEFUN F2 ...):  See :DOC failure.

    ******** FAILED ********
    ACL2 !>

  The error message shows that the check performed by
  check-vars-not-free has failed, because the variable k occurs in
  the expression (* 2 k).  More precisely, what is checked is that k
  does not occur in the translation to a [term] of the expression (*
  2 k), namely, (binary-* '2 k).

  The general form of a call of check-vars-not-free is

    (check-vars-not-free (var_1 ... var_n) expr)

  where var_1, ..., var_n are variables and expr is an expression.
  This call is equivalent to expr --- indeed, there is no effect on
  the code generated when using this call in place of expr --- but
  ACL2 requires that the indicated variables do not occur free in the
  translation of expr to a term.")
 (CHECKPOINT-FORCED-GOALS
  (PROOF-TREE)
  "Cause forcing goals to be checkpointed in proof trees

    Example forms:
    (checkpoint-forced-goals t)
    (checkpoint-forced-goals nil)

  Also see [proof-tree].

  By default, goals are not marked as checkpoints by a proof tree
  display (as described elsewhere; see [proof-tree]) merely because
  they [force] some hypotheses, thus possibly contributing to a
  forcing round.  However, some users may want such behavior, which
  will occur once the command (checkpoint-forced-goals t) has been
  executed.  To return to the default behavior, use the command
  (checkpoint-forced-goals nil).")
 (CHECKPOINT-SUMMARY-LIMIT
  (SUMMARY SET-GAG-MODE)
  "Control printing of key checkpoints upon a proof's failure

  See [set-checkpoint-summary-limit] for a discussion of the
  checkpoint-summary-limit.  Evaluation of the form
  (checkpoint-summary-limit) produces the current
  checkpoint-summary-limit, and can be invoked with the keyword hack
  (see [keyword-commands]).  For example:

    ACL2 !>:checkpoint-summary-limit
    (NIL . 3)
    ACL2 !>")
 (CHECKSUM
  (CERTIFICATE)
  "Assigning ``often unique'' integers to files and objects

  See [book-hash] for a discussion of how ACL2 can use checksums
  (though not by default) to increase security in the [books]
  mechanism.

  A checksum is an integer in some fixed range computed from the
  printed representation of an object, e.g., the sum, modulo 2**32,
  of the ascii codes of all the [characters] in the printed
  representation.

  Ideally, you would like the checksum of an object to be uniquely
  associated with that object, like a fingerprint.  It could then be
  used as a convenient way to recognize the object in the future: you
  could remember the checksum (which is relatively small) and when an
  object is presented to you and alleged to be the special one you
  could compute its checksum and see if indeed it was.  Alas, there
  are many more objects than checksums (after all, each checksum is
  an object, and then there's t).  So you try to design a checksum
  algorithm that maps similar looking objects far apart, in the hopes
  that corruptions and counterfeits --- which appear to be similar to
  the object --- have different checksums.  Nevertheless, the best
  you can do is a many-to-one map.  If an object with a different
  checksum is presented, you can be positive it is not the special
  object.  But if an object with the same checksum is presented, you
  have no grounds for positive identification.

  The basic checksum algorithm in ACL2 is called check-sum-obj, which
  computes the checksum of an ACL2 object.  Roughly speaking, we scan
  the print representation of the object and, for each character
  encountered, we multiply the ascii code of the character times its
  position in the stream (modulo a certain prime) and then add
  (modulo a certain prime) that into the running sum.  This is
  inaccurate in many senses (for example, we don't always use the
  ascii code and we see numbers as though they were printed in base
  127) but indicates the basic idea.")
 (CLAUSE-IDENTIFIER
  (GOAL-SPEC)
  "The internal form of a [goal-spec]

  To each goal-spec, str, there corresponds a clause-identifier
  produced by (parse-clause-id str).  For example,

    (parse-clause-id \"[2]Subgoal *4.5.6/7.8.9'''\")

  returns ((2 4 5 6) (7 8 9) . 3).

  The function string-for-tilde-@-clause-id-phrase inverts
  parse-clause-id in the sense that given a clause identifier it
  returns the corresponding goal-spec.

  As noted in the documentation for [goal-spec], each clause printed in
  the theorem prover's proof attempt is identified by a name.  When
  these names are represented as strings they are called ``goal
  specs.'' Such strings are used to specify where in the proof
  attempt a given hint is to be applied.  The function
  parse-clause-id converts goal-specs into clause identifiers, which
  are cons-trees containing natural numbers.

  Examples of goal-specs and their corresponding clause identifiers are
  shown below.

                 parse-clause-id
                       -->

    \"Goal\"                       ((0) NIL . 0)
    \"Subgoal 3.2.1'\"             ((0) (3 2 1) . 1)
    \"[2]Subgoal *4.5.6/7.8.9'''\" ((2 4 5 6) (7 8 9) . 3)

                       <--
          string-for-tilde-@-clause-id-phrase

  The caar of a clause id specifies the forcing round, the cdar
  specifies the goal being proved by induction, the cadr specifies
  the particular subgoal, and the cddr is the number of primes in
  that subgoal.

  Internally, the system maintains clause ids, not goal-specs.  The
  system prints clause ids in the form shown by goal-specs.  When a
  goal-spec is used in a hint, it is parsed (before the proof attempt
  begins) into a clause id.  During the proof attempt, the system
  watches for the clause id and uses the corresponding hint when the
  id arises.  (Because of the expense of creating and garbage
  collecting a lot of strings, this design is more efficient than the
  alternative.)")
 (CLAUSE-PROCESSOR
  (RULE-CLASSES)
  "Make or apply a :clause-processor rule (goal-level simplifier)

  See [rule-classes] for a general discussion of rule classes,
  including how they are used to build rules from formulas and a
  discussion of the various keywords in a rule class description.

  We will introduce clause-processor rules by way of the following
  example.  But note that the clause-processor utility is more
  general than this example may suggest; for example, the second
  argument of evl0 in the hypothesis need not be the same as its
  second argument in the conclusion.

    ; Example (which we'll return to, below):
    (defthm correctness-of-note-fact-clause-processor
      (implies (and (pseudo-term-listp cl)
                    (alistp a)
                    (evl0 (conjoin-clauses
                           (note-fact-clause-processor cl term))
                          a))
               (evl0 (disjoin cl) a))
      :rule-classes :clause-processor)

  We begin this documentation with an introduction, focusing on the
  example above, and then conclude with a detailed general discussion
  of clause-processor rules.  You might find it most useful simply to
  look at the examples in community books directory
  books/clause-processors/; see file Readme.lsp in that directory.

  Also see [define-trusted-clause-processor] for documentation of an
  analogous utility that does not require the clause-processor to be
  proved correct.  But please read the present documentation before
  reading about that utility.  Both utilities designate functions as
  ``clause-processors''.  Such functions must be executable --- hence
  not constrained by virtue of being introduced in the [signature] of
  an [encapsulate] --- and must respect [stobj] and output arity
  restrictions.  For example, something like (car (mv ...)) is
  illegal; also see [signature].

  INTRODUCTION

  A :clause-processor rule installs a simplifier at the level of goals,
  where a goal is represented as a clause: a list of [term]s that is
  implicitly viewed as a disjunction (the application of [or]).  For
  example, if ACL2 prints a goal in the form (implies (and p q) r),
  then the clause might be the one-element list containing the
  internal representation of this term --- (implies (if p q 'nil) r)
  --- but more likely, the corresponding clause is ((not p) (not q)
  r).  Note that the members of a clause are translated terms; see
  [term] and [termp].  For example, they do not contain calls of the
  macro AND, and constants are quoted.  The result of running a
  clause-processor must be a list of legal clauses; see [meta] for a
  discussion of translated terms, and for related discussion about
  ``forbidden'' function symbols, [set-skip-meta-termp-checks].

  The recognizer for a clause is the function [term-listp] and the
  recognizer for a list of clauses is [term-list-listp].

  Note that clause-processor simplifiers are similar to metafunctions,
  and similar efficiency considerations apply.  See [meta], in
  particular the discussion on how to ``make a metafunction maximally
  efficient.''

  Unlike rules of class :[meta], rules of class :clause-processor must
  be applied by explicit :clause-processor [hints]; they are not
  applied automatically (unless by way of computed hints; see
  [computed-hints]).  But :clause-processor rules can be useful in
  situations for which it is more convenient to code a simplifier
  that manipulates the entire goal clause rather than individual
  subterms of terms in the clause.

  We begin with a simple illustrative example: a clause-processor that
  assumes an alleged fact (named term in the example) and creates a
  separate goal to prove that fact.  We can extend the hypotheses of
  the current goal (named cl in the example) with a term by adding
  the negation of that term to the clause (disjunctive)
  representation of that goal.  So the following returns a list of
  two clauses: the result of adding term as a hypothesis to the input
  clause, as just described, and a second clause consisting only of
  that term.  This list of two clauses can be viewed as the
  conjunction of the first clause and the second clause (where again,
  each clause is viewed as a disjunction).

    (defun note-fact-clause-processor (cl term)
      (declare (xargs :guard t)) ; optional, for better efficiency
      (list (cons (list 'not term)
                  cl)
            (list term)))

  As with :[meta] rules, we need to introduce a suitable evaluator; see
  [defevaluator] if you want details.  Since we expect to reason
  about the function [not], because of its role in
  note-fact-clause-processor as defined above, we include NOT in the
  set of functions known to this evaluator.  We also include IF, as
  is often a good idea.

    (defevaluator evl0 evl0-list
      ((not x) (if x y z)))

  ACL2 can now prove the following theorem automatically.  (This is the
  example displayed at the outset of this [documentation] topic.)  Of
  course, :clause-processor rules about clause-processor functions
  less trivial than note-fact-clause-processor may require lemmas to
  be proved first!  The function disjoin takes a clause and returns
  its disjunction (the result of applying [or] to its members), and
  conjoin-clauses applies disjoin to every element of a given list of
  clauses and then conjoins (applies AND) to the corresponding list
  of resulting terms.

    (defthm correctness-of-note-fact-clause-processor
      (implies (and (pseudo-term-listp cl)
                    (alistp a)
                    (evl0 (conjoin-clauses
                           (note-fact-clause-processor cl term))
                          a))
               (evl0 (disjoin cl) a))
      :rule-classes :clause-processor)

  Now let us submit a silly but illustrative example theorem to ACL2,
  to show how a corresponding :clause-processor hint is applied.  The
  hint says to apply the clause-processor function,
  note-fact-clause-processor, to the current goal clause and a ``user
  hint'' as the second argument of that function, in this case (equal
  a a).  Thus, a specific variable, clause, is always bound to the
  current goal clause for the evaluation of the :clause-processor
  hint, to produce a list of clauses.  Since two subgoals are created
  below, we know that this list contained two clauses.  Indeed, these
  are the clauses returned when note-fact-clause-processor is applied
  to two arguments: the current clause, which is the one-element list
  ((equal (car (cons x y)) x)), and the user hint, (equal a a).

    ACL2 !>(thm (equal (car (cons x y))
                       x)
                :hints
                ((\"Goal\"
                  :clause-processor
                  (note-fact-clause-processor clause '(equal a a)))))

    [Note:  A hint was supplied for our processing of the goal above.
    Thanks!]

    We now apply the verified :CLAUSE-PROCESSOR function NOTE-FACT-CLAUSE-
    PROCESSOR to produce two new subgoals.

    Subgoal 2
    (IMPLIES (EQUAL A A)
             (EQUAL (CAR (CONS X Y)) X)).

    But we reduce the conjecture to T, by the :executable-counterpart of
    IF and the simple :rewrite rule CAR-CONS.

    Subgoal 1
    (EQUAL A A).

    But we reduce the conjecture to T, by primitive type reasoning.

    Q.E.D.

    Summary
    Form:  ( THM ...)
    Rules: ((:EXECUTABLE-COUNTERPART IF)
            (:EXECUTABLE-COUNTERPART NOT)
            (:FAKE-RUNE-FOR-TYPE-SET NIL)
            (:REWRITE CAR-CONS))
    Warnings:  None
    Time:  0.00 seconds (prove: 0.00, print: 0.00, other: 0.00)

    Proof succeeded.
    ACL2 !>

  That concludes our introduction to clause-processor rules and hints.
  We turn now to detailed documentation.

  DETAILED DOCUMENTATION

  The [signature] of a clause-processor function, CL-PROC, must have
  one of the following forms.  Here, each st_i is a [stobj] (possibly
  [state]) while the other parameters and results are not stobjs (see
  [stobj]).  Note that there need not be input stobjs in [3] ---
  i.e., k can be 0 --- and even if there are, there need not be
  output stobjs.  In most ways [3] and [3+] are treated similarly;
  see [make-summary-data] for a discussion of the form of d in [3+]
  and, more generally, for how [3+] differs from [3] by enhancing the
  [summary].

    [1]  ((CL-PROC cl) => cl-list)

    [2]  ((CL-PROC cl hint) => cl-list)

    [3]  ((CL-PROC cl hint st_1 ... st_k) => (mv erp cl-list st_i1 ... st_in))

    [3+] ((CL-PROC cl hint st_1 ... st_k) => (mv erp cl-list st_i1 ... st_in d))

  We call cl-list the clauses-result.  In [3] and [3+], we think of the
  first component of the result as an error flag.  Indeed, a proof
  will instantly abort if that error flag is not nil.

  We next discuss the legal forms of :clause-processor rules, followed
  below by a discussion of :clause-processor [hints].  In the
  discussion below, we use lower-case names to represent specific
  symbols, for example implies, and also to represent [stobj] names;
  and we use upper-case names to represent arbitrary pieces of syntax
  (which we will describe), for example, CL.

  If a :[rule-classes] specification includes :clause-processor, then
  the corresponding term must have the following form.  (Additional
  ``meta-extract'' hypotheses, not shown or discussed below, may be
  included as desired in order to use facts from the logical [world]
  to help prove the rule; see [meta-extract] for explanation of this
  advanced feature.)

    ; General Form (omitting possible meta-extract hypotheses)
    (implies (and (pseudo-term-listp CL)
                  (alistp A)
                  (EVL (conjoin-clauses <CL-LIST>)
                        B))
             (EVL (disjoin CL) A))

  Here EVL is a known evaluator; CL and A are distinct non-stobj
  variables; and <CL-LIST> is an expression representing the clauses
  returned by the clause-processor function CL-PROC, whose form
  depends on the [signature] of that function, as follows.  Typically
  B is A, but it can be any term (useful when generalization is
  occurring; see the example ``Test generalizing alist'' in community
  book books/clause-processors/basic-examples.lisp).  For cases [1]
  and [2] above, <CL-LIST> is of the form (CL-PROC CL) or (CL-PROC CL
  HINT), respectively, where in the latter case HINT is a non-stobj
  variable distinct from the variables CL and A.  For cases [3] and
  [3+], <CL-LIST> is the result of wrapping the function
  clauses-result around a call of CL-PROC:

    (clauses-result (CL-PROC CL HINT ...))

  Logically, clauses-result returns the [cadr] if the [car] is NIL, and
  otherwise (for the error case) returns a list containing the empty
  (false) clause.  So in the non-error case, clauses-result picks out
  the second result, denoted cl-list in [3] and [3+] above, and in
  the error case the implication above trivially holds.

  In the above theorem, we are asked to prove (EVL (disjoin CL) A)
  assuming that the conjunction of all clauses produced by the clause
  processor evaluates to a non-nil value under some alist B.  In
  fact, we can choose B so as to allow us to assume evaluations of
  the generated clauses over many different alists.  This technique
  is discussed in the community book
  books/clause-processors/multi-env-trick.lisp, which introduces some
  macros that may be helpful in accomplishing proofs of this type.

  The clause-processor function, CL, must have a guard that ACL2 can
  trivially prove from the hypotheses that the first argument of CL
  is known to be a pseudo-term-listp and any [stobj] arguments are
  assumed to satisfy their stobj predicates.

  Next we specify the legal forms for :clause-processor [hints].  The
  basic form is :clause-processor TERM, such that the translation of
  TERM to a legal ACL2 term yields a call of a clause-processor
  function (CL-PROC clause) or (CL-PROC clause HINT ...), where HINT
  is a term whose only non-stobj free variable (if any) is the
  symbol, clause.  Note that the first argument of the call is
  literally the variable, clause.  Recall that at the time the
  :clause-processor hint is applied to the clausal form CL of the
  current subgoal, clause is bound to CL; moreover, any stobj names
  will be bound to the corresponding stobjs.

  But there are two additional general forms for :clause-processor
  hints, which may viewed as abbreviations for the basic form
  discussed above.  The first additional general form, which we call
  the ``:function form'', includes the following two classes of
  expressions.

    :clause-processor (:function F)
    :clause-processor (:function F :hint HINT)

  The first of these :function forms abbreviates the following hint,
  where either F is a macro-alias for the function symbol CL-PROC
  (see [add-macro-alias]), and otherwise CL-PROC is just the function
  symbol F.

    :clause-processor (CL-PROC clause)

  Similarly the second of the :function forms above abbreviates the
  following, where CL-PROC is as above and the output signature of
  CL-PROC is (nil nil st_1 ... st_k).

    :clause-processor (CL-PROC clause HINT st_1 ... st_k)

  Besides the ``:function form'', there is one more additional general
  form for :clause-processor hint: a symbol, as follows.

    :clause-processor F

  This expands to a basic form as follows, depending on F.

    * If F is a macro with one required argument or a function symbol with
      one argument:
      :clause-processor (F clause)
    * If F is a macro with two required arguments or a function symbol with
      two arguments:
      :clause-processor (F clause nil)
    * If F is a function symbol with inputs of the form [3] or [3+] above,
      that is, with input signature (nil nil st_1 ... st_k):
      :clause-processor (F clause nil st_1 ... st_k)

  For examples of these syntactic forms, see community book
  books/clause-processors/basic-examples.lisp).  We turn now to
  discussion of when a :clause-processor hint causes an abort.

  A :clause-processor hint causes the proof to abort if the
  clauses-result is not a list of clauses, i.e., a list of
  (translated) [term] lists in the current logical [world].  This
  test is done explicitly every time a clause processor is run unless
  a :[well-formedness-guarantee] has been provided with the
  :clause-processor rule or [set-skip-meta-termp-checks] has been
  used with an active trust tag to skip the check at the user's risk.

  The proof also aborts when the clause-processor function returns at
  least two values and the first value returned --- the ``erp'' value
  from cases [3] and [3+] above --- is not nil.  In that case, erp is
  used for printing an error message as follows: if it is a string,
  then that string is printed; but if it is a non-empty true list
  whose first element is a string, then it is printed as though by
  (fmt ~@0 (list (cons #\\0 erp)) ...) (see [fmt]).  Otherwise, a
  non-nil erp value causes a generic error message to be printed.

  If there is no error as above, but the CL-PROC call returns a clause
  list whose single element is equal to the input clause, then the
  hint is ignored since we are left with the goal with which we
  started.  In that case, the other prover processes are then applied
  as usual (see [hints-and-the-waterfall]).

  You can see all current :clause-processor rules by issuing the
  following command: (print-clause-processor-rules).

  The following paper discusses ACL2 clause-processors at a high level
  suitable for a non-ACL2 audience:

      M. Kaufmann, J S. Moore, S. Ray, and E. Reeber, ``Integrating
      External Deduction Tools with ACL2.'' Journal of Applied Logic
      (Special Issue: Empirically Successful Computerized Reasoning),
      Volume 7, Issue 1, March 2009, pp. 3--25.  Also published
      online (DOI 10.1016/j.jal.2007.07.002).  Preliminary version
      in: Proceedings of the 6th International Workshop on the
      Implementation of Logics (IWIL 2006) (C. Benzmueller, B.
      Fischer, and G. Sutcliffe, editors), {CEUR Workshop Proceedings
      Vol. 212 | http://ceur-ws.org/Vol-212/}, Phnom Penh, Cambodia,
      pp. 7--26, November 2006.


Subtopics

  [Make-summary-data]
      Return summary data from a [clause-processor] function

  [Meta-extract]
      Meta reasoning using valid terms extracted from context or [world]

  [Set-skip-meta-termp-checks]
      Skip output checks for [meta] functions and [clause-processor]s

  [Set-skip-meta-termp-checks!]
      Skip output checks non-[local]ly for [meta] functions and
      [clause-processor]s")
 (CLEAR-HASH-TABLES
  (MEMOIZE)
  "Deprecated feature

  Deprecated.  Calls [clear-memoize-tables] and then [hons-clear] or
  [hons-wash], whichever makes sense for the underlying Common Lisp.")
 (CLEAR-MEMOIZE-STATISTICS
  (MEMOIZE)
  "Clears all profiling info displayed by ([memoize-summary])

  Logically, this function just returns nil.  It clears all profiling
  info displayed by ([memoize-summary])

  Function: <clear-memoize-statistics>

    (defun clear-memoize-statistics
           nil (declare (xargs :guard t))
           nil)")
 (CLEAR-MEMOIZE-TABLE
  (MEMOIZE)
  "Forget values remembered for the given function

  This function returns its argument, fn, unchanged.  The values
  memoized for fn are forgotten.

  Function: <clear-memoize-table>

    (defun clear-memoize-table (fn)
           (declare (xargs :guard t))
           fn)")
 (CLEAR-MEMOIZE-TABLES
  (MEMOIZE)
  "Forget values remembered for all the memoized functions

  Clear-memoize-tables is a logical no-op.  All memoized values are
  forgotten.  It returns nil, invoking [clear-memoize-table] for each
  memoized function.

  Function: <clear-memoize-tables>

    (defun clear-memoize-tables
           nil (declare (xargs :guard t))
           nil)")
 (CLOSE-INPUT-CHANNEL (POINTERS)
                      "See [io].")
 (CLOSE-OUTPUT-CHANNEL (POINTERS)
                       "See [io].")
 (CLOSE-TRACE-FILE
  (TRACE)
  "Stop redirecting trace output to a file

    General Form:
    (close-trace-file) ; trace output is no longer redirected to a file

  Output from [trace$] normally goes to the screen, or more precisely,
  [standard-co].  It can be redirected to a file; see
  [open-trace-file].  Use close-trace-file to redirect trace output
  to [standard-co].")
 (CODE-CHAR
  (CHARACTERS NUMBERS ACL2-BUILT-INS)
  "The character corresponding to a given numeric code

  This function maps a numeric code to the corresponding character, for
  example: (code-char 65) evaluates to #\\A.  See [char-code] for a
  sort of inverse function, which maps a character to its code.

  Completion Axiom (completion-of-code-char):

    (equal (code-char x)
           (if (and (integerp x)
                    (>= x 0)
                    (< x 256))
               (code-char x)
             (code-char 0)))

  [Guard] for (code-char x):

    (and (integerp x)
         (>= x 0)
         (< x 256))

  ACL2 supports 8-bit [characters].  Inputs not between 0 and 255 are
  treated as 0.")
 (COERCE
  (STRINGS CHARACTERS ACL2-BUILT-INS)
  "Coerce a character list to a string and a string to a list

  Completion Axiom (completion-of-coerce):

    (equal (coerce x y)
           (cond
            ((equal y 'list)
             (if (stringp x)
                 (coerce x 'list)
               nil))
            (t
             (coerce (make-character-list x) 'string))))

  [Guard] for (coerce x y):

    (if (equal y 'list)
        (stringp x)
      (if (equal y 'string)
          (character-listp x)
        nil))

  Also see community book books/misc/fast-coerce.lisp, contributed by
  Jared Davis, for a version of coerce that may be faster for Common
  Lisp implementations other than CCL 1.3 or later, if the second
  argument is 'list (for coercing a string to a list).

  Logical Note

  The function coerce can be viewed as the constructor for strings.  As
  discussed in Section 7 of \"{A Precise Description of the ACL2 Logic
  | http://www.cs.utexas.edu/users/moore/publications/km97a.pdf}\"
  (Matt Kaufmann and J Moore, April, 1998), a string may be built by
  coercing its list of characters: for example, \"abc\" is (coerce
  '(#\\a #\\b #\\c) 'string).  More precisely, \"abc\" is an abbreviation
  for (coerce '(#\\a #\\b #\\c) 'string), where even more pedantically,
  '(#\\a #\\b #\\c) is an abbreviation for (cons '#\\a (cons '#\\b (cons
  '#\\c 'nil))).")
 (COLLECT$ (POINTERS) "See [loop$].")
 (COLLECT$+ (POINTERS) "See [loop$].")
 (COMMA (POINTERS) "See [backquote].")
 (COMMA-ATSIGN (POINTERS)
               "See [backquote].")
 (COMMAND
  (HISTORY)
  "Forms you type at the top-level, but...

  ...the word ``command'' usually refers to a top-level form whose
  evaluation produces a new logical [world].

    Typical commands are:
    (defun foo (x) (cons x x))
    (defthm consp-foo (consp (foo x)))
    (defrec pair (hd . tl) nil)

  The first two forms are examples of commands that are in fact
  primitive [events].  See [events].  Defrec, on the other hand, is a
  macro that expands into a [progn] of several primitive [events].
  In general, a [world] extending command generates one or more
  [events].

  Both [events] and commands leave landmarks on the [world] that enable
  us to determine how the given [world] was created from the previous
  one.  Most of your interactions will occur at the command level,
  i.e., you type commands, you print previous commands, and you undo
  back through commands.  Commands are denoted by command
  descriptors.  See [command-descriptor].")
 (COMMAND-DESCRIPTOR
  (HISTORY)
  "An object describing a particular [command] typed by the user

    Examples:

    :max      ; the command most recently typed by the user
    :x        ; synonymous with :max
    (:x -1)   ; the command before the most recent one
    (:x -2)   ; the command before that
    :x-2      ; synonymous with (:x -2)
    5         ; the fifth command typed by the user
    1         ; the first command typed by the user
    0         ; the last command of the system initialization
    -1        ; the next-to-last initialization command
    :min      ; the first command of the initialization
    :start    ; the last command of the initial ACL2 logical world
    fn        ; the command that introduced the logical name fn
    (:search (defmacro foo-bar))
              ; the first command encountered in a search from :max to
              ; 0 that either contains defmacro and foo-bar in the
              ; command form or contains defmacro and foo-bar in some
              ; event within its block.

  The recorded [history] of your interactions with the top-level ACL2
  [command] loop is marked by the [command]s you typed that changed
  the logical [world].  Each such [command] generated one or more
  [events], since the only way for you to change the logical [world]
  is to execute an event function.  See [command] and see [events].
  We divide [history] into ``[command] blocks,'' grouping together
  each [world] changing [command] and its [events].  A ``[command]
  descriptor'' is an object that can be used to describe a particular
  [command] in the [history] of the ongoing session.

  Each [command] is assigned a unique integer called its ``[command]
  number'' which indicates the [command]'s position in the
  chronological ordering of all of the [command]s ever executed in
  this session (including those executed to initialize the system).
  We assign the number 1 to the first [command] you type to ACL2.  We
  assign 2 to the second and so on.  The non-positive integers are
  assigned to ``prehistoric'' [command]s, i.e., the [command]s used
  to initialize the ACL2 system: 0 is the last [command] of the
  initialization, -1 is the one before that, etc.

  The legal [command] descriptors are described below.  We use n to
  denote any integer, sym to denote any logical name (see
  [logical-name]), and cd to denote, recursively, any [command]
  descriptor.

     command                   command
    descriptor                described

    :max   -- the most recently executed command (i.e., the one with
              the largest command number)
    :x     -- synonymous with :max
    :x-k   -- synonymous with (:x -k), if k is an integer and k>0
    :min   -- the earliest command (i.e., the one with the smallest
              command number and hence the first command of the system
              initialization)
    :start -- the last command when ACL2 starts up
    n      -- command number n  (If n is not in the
              range :min<=n<=:max, n is replaced by the nearest of :min
              and :max.)
    sym    -- the command that introduced the logical name sym
    (cd n) -- the command whose number is n plus the command number of
              the command described by cd
    (:search pat cd1 cd2)
              In this command descriptor, pat must be either an atom or
              a true list of atoms and cd1 and cd2 must be command
              descriptors.  We search the interval from cd1 through cd2
              for the first command that matches pat.  Note that if cd1
              occurs chronologically after cd2, the search is
              ``backwards'' through history while if cd1 occurs
              chronologically before cd2, the search is ``forwards''.  A
              backwards search will find the most recent match; a
              forward search will find the chronologically earliest
              match.  A command matches pat if either the command form
              itself or one of the events in the block contains pat (or
              all of the atoms in pat if pat is a list).
    (:search pat)
              the command found by (:search pat :max 0), i.e., the most
              recent command matching pat that was part of the user's
              session, not part of the system initialization.")
 (COMMAND-LINE
  (INTERFACING-TOOLS)
  "Handling of command-line arguments when ACL2 is invoked

  You may provide command-line arguments when invoking ACL2, which are
  passed to the host Lisp.  For more information on this topic, along
  with a discussion of how to save an ACL2 executable that avoids
  passing command-line arguments to the host Lisp, see [save-exec].


Subtopics

  [Save-exec]
      Save an executable image and a wrapper script")
 (COMMENT
  (HIDE ACL2-BUILT-INS)
  "Variant of [prog2$] to help debug evaluation failures during proofs

  Semantically, (comment x y) equals y; the value of x is ignored.
  Thus comment is much like [prog2$].  However, when you see a call
  of comment in ACL2 proof output, it will likely be under a call of
  [hide], with information that may be helpful in understanding why
  the call of hide was inserted.  Below we illustrate the various
  ways in which ACL2 may replace a term tm by (hide (comment \"...\"
  tm)).  (On occasion you will simply see (hide tm); such cases are
  not discussed here.)

  Also see [hide] for further discussion of how to avoid such proof
  failures, and for how to keep the prover from inserting a comment
  call under a call of [hide].


Evaluation during proofs

  Forms:

    (HIDE (COMMENT \"Failed attempt to call constrained function <fn>\" <term>))
    (HIDE (COMMENT \"Failed attempt to call non-executable function <fn>\" <term>))

  Consider the following example.

    (defstub f (x) t)
    (defun g (x) (cons (f x) x))
    (defun h (x) (cons x (cdr (g x))))
    (thm (equal (h 3) '(3 . 3)))

  The proof attempt fails for the [thm] call, indicating the checkpoint
  shown below.

    *** Key checkpoint at the top level: ***

    Goal'
    (EQUAL (HIDE (COMMENT \"Failed attempt to call constrained function F\"
                          (H 3)))
           '(3 . 3))

  The first argument of equal is logically just (h 3).  But the comment
  and hide wrappers are telling us that evaluation of (h 3) failed
  because it led to a call of the constrained function f.  It is easy
  to see why in this case, by looking at the definitions, where h
  calls g, which calls f.  But more complicated such failures may be
  difficult to understand without such information.  In very
  complicated cases, one might even want to use the Lisp debugger
  after designating a [break$] call using [trace$], like this (here,
  shown using host Lisp CCL).

    ACL2 !>(trace$ (f :entry (break$)))
     ((F :ENTRY (BREAK$)))
    ACL2 !>(thm (equal (h 3) '(3 . 3)))

    > Break: Break
    > While executing: BREAK$, in process listener(1).
    > Type :GO to continue, :POP to abort, :R for a list of available restarts.
    > If continued: Return from BREAK.
    > Type :? for other options.
    1 > :b ; user input to get backtrace
     (262932A0) : 0 (BREAK$) 157
     (262932F0) : 1 (F 3) 141
     (26293338) : 2 (FUNCALL #'#<(:INTERNAL ACL2_*1*_ACL2::G ACL2_*1*_ACL2::G)> 3) 37
     (26293350) : 3 (FUNCALL #'#<(:INTERNAL ACL2_*1*_ACL2::H ACL2_*1*_ACL2::H)> 3) 37
     (26293368) : 4 (RAW-EV-FNCALL H (3) NIL NIL [[.. output elided ..]]

  This output from Lisp is quite low-level, but reading from the bottom
  up provides the following sequence of events.

    * 4. Call h with argument list (3).
    * 3. Call the [executable-counterpart] of h.
    * 2. Call the [executable-counterpart] of g.
    * 1. Attempt to call the constrained function, f.

  An easy way to avoid this proof failure is to avoid execution of
  calls of h and g, as follows.

    (thm (equal (h 3) '(3 . 3))
         :hints ((\"Goal\" :in-theory (disable (:e g) (:e h)))))

  (It actually suffices to disable only (:e h), but the workings of the
  ACL2 rewriter are out of scope here.)

  Note that if the offending function is [non-executable] rather than
  constrained, in particular if that function is defined using
  [defun-nx], then in the first argument of comment you will see
  ``non-executable'' instead of ``constrained''.


Evaluation during building a term

  Form:

    (HIDE
     (COMMENT
      \"Failed attempt (when building a term) to call constrained function <fn>\"
      <term>))

  Consider how ACL2 approaches the proof of the non-theorem below.

    (defstub foo (x) t)
    (defund bar (x) (foo x))
    (thm (implies (equal x 3) (equal (bar x) yyy)))

  The prover attacks the [thm] event by substituting the constant '3
  for x.  But the prover attempts to evaluate (bar 3) when doing that
  substitution, and the evaluation fails because bar calls the
  undefined function foo.  The checkpoint is as follows.

    (EQUAL
     (HIDE
      (COMMENT
         \"Failed attempt (when building a term) to call constrained function FOO\"
         (BAR 3)))
     YYY)


Failure to expand using a rule

  Form:

    (HIDE (COMMENT \"Unable to expand using the rule <name>\"
                   <term>))

  Consider how ACL2 approaches the proof for the second event below.

    (defthm nth-open (implies (and (consp x) (posp n))
                              (equal (nth n x) (nth (1- n) (cdr x))))
      :rule-classes ((:definition :controller-alist ((nth t t)) :install-body t)))
    (thm (equal (nth i y) zzz)
         :hints ((\"Goal\" :expand (nth i y) :do-not-induct t)))

  The checkpoint is as follows.  What happened is that the rule
  nth-open had a hypothesis that was false when the rule was
  attempted for the term (nth i y).

    (IMPLIES (NOT (CONSP Y))
             (EQUAL (HIDE (COMMENT \"Unable to expand using the rule NTH-OPEN\"
                                   (NTH I Y)))
                    ZZZ))


Failure due to disabled or missing warrants

  Forms:

    (HIDE (COMMENT \"Call failed because the rule apply$-<fn> is disabled\"
          <term>))
    (HIDE (COMMENT \"Call failed because the warrant for <fn> is not known to be true\"
          <term>))

  The first of these forms may appear when an attempt to evaluate a
  call of [apply$] fails because a necessary [warrant] is disable)d.
  The second form may appear when the warrant is not known to be true
  in the present context, either because it is known to be false or
  because it cannot be assumed true because forcing is [disable]d.
  In the following example, the attempt to simplify the call of
  apply$ in the theorem ultimately leads to an attempt to evaluate a
  call of [ev$], which ultimately fails because it leads to a call to
  evaluate (apply$ 'bar '(3)) bar.  That call causes an error because
  the warrant is unavailable, because the rule apply$-bar is
  disabled, hence cannot rewrite a term (apply$ 'bar args) to (bar
  (car args)).

    (include-book \"projects/apply/top\" :dir :system)
    (defun$ bar (x) x)
    (thm (implies (warrant bar)
                  (equal (apply$ '(lambda (y) (bar y)) '(3)) 3))
         :hints ((\"Goal\" :in-theory (disable apply$-bar ev$))))

  The checkpoint in the proof for the thm just above is as follows.

    (IMPLIES
      (APPLY$-WARRANT-BAR)
      (EQUAL (HIDE (COMMENT \"Call failed because the rule APPLY$-BAR is disabled\"
                            (EV$ '(BAR Y) '((Y . 3)))))
             3))

  Similarly, if we instead submit the following event, we see the other
  such message, in this case about a false warrant.

    (thm (implies (not (warrant bar))
                  (equal (apply$ '(lambda (y) (bar y)) '(3)) 3))
         :hints ((\"Goal\" :in-theory (disable ev$))))

  Here is the resulting checkpoint.

    (IMPLIES
     (NOT (APPLY$-WARRANT-BAR))
     (EQUAL (HIDE (COMMENT \"Call failed because the warrant for BAR is not known to be true\"
                           (EV$ '(BAR Y) '((Y . 3)))))
            3))

  Our final example illustrates a failure due to forcing being
  disabled.  The use of [loop$] in the definition of bar expands to
  create a call of [ev$], which cannot be simplified during the proof
  of the [thm] below because the necessary warrant hypothesis is
  missing and cannot be forced, since forcing is disabled (see also
  [disable-forcing]).

    (defun$ hello (x)
       (declare (xargs :guard t))
       (list 'hi x))

    (defun bar (lst)
       (declare (xargs :guard (true-listp lst)))
       (loop$ for name in lst collect (hello name))))

    (thm (equal (bar '(john))
                '((hi john)))
         :hints ((\"Goal\" :in-theory (disable (:e force)))))

  Here is the resulting checkpoint.

    (EQUAL
     (HIDE
         (COMMENT
              \"Call failed because the warrant for HELLO is not known to be true\"
              (EV$ '(HELLO LOOP$-IVAR)
                   '((LOOP$-IVAR . JOHN)))))
     '(HI JOHN))")
 (COMMON-LISP
  (ABOUT-ACL2)
  "Relation to Common Lisp, including deviations from the spec

  ACL2 is a logic, a theorem prover, and a programming language based
  on Common Lisp.  A connection with Common Lisp is established with
  guards (see [guard]).

  However, here we document potential deviations from Common Lisp
  semantics even in the presence of verified guards.  Our view is
  that these deviations are extremely unlikely to manifest; indeed,
  as of this writing we are unaware of any cases in which these
  issues arise in practice.  However, we feel obligated to
  acknowledge their possibility, which could result in surprises
  during evaluation or even proof.

  The Common Lisp spec allows certain predicates to return what it
  calls ``generalized Booleans,'' which are really arbitrary values
  that are to be viewed as either nil or non-nil.  However, in ACL2
  these functions are assumed to return nil or t.  For details, see
  [generalized-booleans].

  The execution of forms with :[program] mode functions can result in
  calls of functions on arguments that do not satisfy their [guard]s.
  In practice, this simply causes hard Lisp errors.  But in principle
  one could imagine a damaged Lisp image that operates incorrectly.
  See [defun-mode-caveat].

  The Common Lisp spec, specifically Section {Section 3.2.2.3 |
  http://www.lispworks.com/documentation/HyperSpec/Body/03_bbc.htm}
  of the {Common Lisp Hyperspec |
  http://www.lispworks.com/documentation/HyperSpec/Front}, allows for
  undefined results when a function is ``multiply defined'' in a
  compiled file.  ACL2 allows redundant [defun]s in a book, and in
  general [books] are compiled by certify-book (but see
  [certify-book] and see [compilation] for how to control such
  compilation).  Moreover, ACL2 provides a redefinition capability
  (see [ld-redefinition-action] and see [redef]), and the above
  section also allows for undefined results when a function is
  defined in a compiled file and then redefined, presumably (for
  example) because of inlining.


Subtopics

  [Defun-mode-caveat]
      Potential soundness issue for functions with [defun-mode] :[program]

  [Escape-to-common-lisp]
      Escaping to Common Lisp

  [Generalized-booleans]
      Potential soundness issues related to ACL2 predicates

  [Raw-lisp-error]
      Raw lisp errors")
 (COMMON_LISP
  (PAGES_WRITTEN_ESPECIALLY_FOR_THE_TOURS)
  "Common Lisp

  {IMAGE} (see [An_Example_Common_Lisp_Function_Definition])

  The logic of ACL2 is based on Common Lisp.

  Common Lisp is the standard list processing programming language.  It
  is documented in: Guy L. Steele, {Common Lisp The Language | },
  Digital Press, 12 Crosby Drive, Bedford, MA 01730, 1990.

  ACL2 formalizes only a subset of Common Lisp.  It includes such
  familiar Lisp functions as cons, car and cdr for creating and
  manipulating list structures, various arithmetic primitives such as
  +, *, expt and <=, and intern and symbol-name for creating and
  manipulating symbols.  Control primitives include cond, case and
  if, as well as function call, including recursion.  New functions
  are defined with defun and macros with defmacro.  See [programming]
  {ICON} (see [A_Tiny_Warning_Sign]) for a list of the Common Lisp
  primitives supported by ACL2.

  ACL2 supports five of Common Lisp's datatypes:

  * the precisely represented, unbounded numbers (integers, rationals,
  and the complex numbers with rational components, called the
  ``complex rationals'' here),

  * the characters with ASCII codes between 0 and 255

  * strings of such characters

  * symbols (including packages)

  * conses

  ACL2 is a large subset of the first-order applicative part of Common
  Lisp.  (Roughly speaking, a language is applicative if it follows
  the rules of function application.  For example, f(x) must be equal
  to f(x), which means, among other things, that the value of f must
  not be affected by ``global variables'' and the object x must not
  change over time.)  It does not support higher-order features of
  Common Lisp, like functional objects and apply.  It does not
  support Common Lisp primitives that have side-effects such as setq,
  setf, the Common Lisp Object System, etc.  However, ACL2 does
  provide some special features that can be used efficiently to do
  many of the same jobs as these omitted Common Lisp primitives.  The
  ACL2 system is largely implemented in the language it supports.

  {IMAGE} (see [An_Example_Common_Lisp_Function_Definition])")
 (COMMON_LISP_AS_A_MODELING_LANGUAGE
  (PAGES_WRITTEN_ESPECIALLY_FOR_THE_TOURS)
  "Common Lisp as a Modeling Language

  In ACL2 we have adopted Common Lisp as the basis of our modeling
  language.  If you have already read our brief note on Common Lisp
  and recall the example of app, please proceed.  Otherwise click
  here (see [Common_Lisp]) for an exceedingly brief introduction to
  Common Lisp and then come back here.

  In Common Lisp it is very easy to write systems of formulas that
  manipulate discrete, inductively constructed data objects.  In
  building a model you might need to formalize the notion of
  sequences and define such operations as concatenation, length,
  whether one is a permutation of the other, etc.  It is easy to do
  this in Common Lisp.  Furthermore, if you have a Common Lisp
  ``theory of sequences'' you can run the operations and relations
  you define.  That is, you can execute the functions on concrete
  data to see what results your formulas produce.

  If you define the function app as shown above and then type

    (app '(A B) '(C D E))

  in any Common Lisp, the answer will be computed and will be (A B C D
  E).

  The executable nature of Common Lisp and thus of ACL2 is very handy
  when producing models.

  But executability is not enough for a modeling language because the
  purpose of models is to permit analysis.

  Click here (see [Analyzing_Common_Lisp_Models]) to continue.")
 (COMMUNITY-BOOK (POINTERS)
                 "See [community-books].")
 (COMMUNITY-BOOKS
  (BOOKS)
  "Libraries of ACL2 [books] developed by the ACL2 community.

  ACL2 [books] are files of ACL2 [events] like definitions and
  theorems.

  The ACL2 Community Books are the canonical set of open-source books
  for ACL2, developed since the early 1990s by members of the ACL2
  community.  They include libraries for reasoning in many domains,
  macro libraries for more quickly writing and documenting code,
  interfacing tools for connecting ACL2 to other systems,
  productivity tools for better proof automation and debugging, and
  specialty libraries for areas like hardware verification.

  From the {github ACL2 project | https://github.com/acl2/acl2/} web
  site you can:

    * Download the Community Books;
    * Learn how to contribute books to the ACL2 community; and
    * Obtain updates between ACL2 releases.

  See [git-quick-start] for information about how to download the
  ``bleeding edge'' ACL2 system and community books.


Subtopics

  [Books-certification]
      Instructions for certifying the ACL2 [community-books].")
 (COMP
  (COMPILATION EVENTS ACL2-BUILT-INS)
  "Compile some ACL2 functions

  NOTE: Comp is a no-op if explicit compilation is suppressed; see
  [compilation].  The documentation here assumes that this is not the
  case.  See [evaluation] for background on executable-counterpart
  and submitted functions.

    Examples:
    :comp t          ; compile all uncompiled ACL2 functions
    (comp t)         ; same as above, but can be put into a book
    (comp :exec)     ; compile all uncompiled executable-counterpart definitions
    :comp foo        ; compile the defined function foo (both its submitted and
                     ; executable-counterpart functions)
    :comp (:raw foo) ; compile the submitted function for the defined function foo
                     ; but not the corresponding executable-counterpart
    :comp (foo bar)  ; compile the defined functions foo and bar
    :comp (foo (:raw bar))  ; compile the defined functions foo and bar, but for
                            ; bar do not compile the executable-counterpart

    General Form:
    :comp specifier
    where specifier is one of the following:

      t                     compile all user-defined ACL2 functions that are
                              currently uncompiled (redefined built-in functions
                              are not recompiled)
      :exec                 same as t, except that only executable-counterparts
                              are compiled (see below), not submitted definitions
      :raw                  same as t, except that only submitted definitions are
                              compiled, not executable-counterparts
      (name-1 ... name-k)   a non-empty list of names of functions defined by
                              DEFUN in ACL2, except that each name-i can be of
                              the form (:raw sym) or (:exec sym), where sym is
                            the name of such a function
      name                  same as (name)

  When you define a function in ACL2, you are really causing two
  definitions to be made ``under the hood'' in Common Lisp: the
  definition is submitted explicitly to raw Lisp, but so is a
  corresponding executable-counterpart; see [evaluation].  If guards
  have not been verified, then only the executable-counterpart will
  be evaluated; see [evaluation] and see [guards-and-evaluation], in
  particular the section titled ``Guards and evaluation V: efficiency
  issues''.

  Thus, if you are not verifying [guard]s and you want the benefit of
  Lisp compilation for speed and space efficiency, then you may want
  to place the form (comp :exec) in your [books].

  Generally it is not necessary to place the form (comp t), or the form
  (comp :raw), in a book, because [certify-book] compiles the raw
  Lisp definitions anyhow, by default.  But you may wish to put (comp
  t) or (comp fn1 fn2 ... fnk) in a book when such a form precedes
  expensive calls of functions, for example for proofs involving
  calls of functions on large constants, or to support
  computationally expensive macroexpansion.

  As suggested by the examples above, if a function specifier is of the
  form (:raw fn), then fn will be compiled in raw Common Lisp but its
  corresponding executable-counterpart definition will not be
  compiled; and for (:exec fn), it's the other way around.

  The use of :comp may create various files whose names start with
  ``TMP*'', but it then deletes them.  If you want to save these
  files, evaluate (assign keep-tmp-files t).

  Also see [set-compile-fns] for a way to compile each function as it
  is defined.  But note that set-compile-fns is ignored during
  [include-book].

  Note that if functions are traced (see [trace$]), then comp will
  first untrace the functions that are to be compiled, then will do
  the compile(s), and finally will re-trace the functions that it
  untraced (using their original trace specs).  In particular, if you
  have traced a function and then you compile it using :comp, the
  resulting traced function will be compiled as well unless you
  specified :compile nil in your trace spec; and after you untrace
  the function it will definitely run compiled.

  We conclude with a technical remark only for those who use trust tags
  to write raw Lisp code.  :Comp generally creates files to compile
  unless it is given a single function to compile.  Those files
  contain the ACL2 definitions of all functions to compile, omitting
  those in the lists obtained by evaluating the forms (@
  logic-fns-with-raw-code) and (@ program-fns-with-raw-code).  :Comp
  skips compilation for functions that are already compiled, as is
  typically the case when you redefine functions in raw Lisp using
  [include-raw].  But if you define interpreted (as opposed to
  compiled) functions with raw Lisp code, say by using trust tags
  (see [defttag]) and [progn!], then you are advised to add all such
  symbols to one of the lists stored in the two [state] globals
  above: to logic-fns-with-raw-code if the function symbol is in
  :[logic] mode, else to program-fns-with-raw-code.  Then, instead of
  the corresponding ACL2 definition (without raw Lisp code) being
  written to a file, the function symbol will be passed directly to
  the Lisp compile function.  Note that the above two state globals
  are both untouchable, so you may need to deal with that before
  modifying them, for example as follows (also see
  [remove-untouchable]).

    (defttag t)
    (progn!
     :state-global-bindings
     ((acl2::temp-touchable-vars t acl2::set-temp-touchable-vars))
     (f-put-global 'acl2::logic-fns-with-raw-code
                   (cons 'my-fn (@ acl2::logic-fns-with-raw-code))
                   state))")
 (COMP-GCL
  (COMPILATION ACL2-BUILT-INS)
  "Compile some ACL2 functions leaving .c and .h files

  Comp-gcl is for use by experts who want to examine the results of GCL
  compilation, and it may only be used with ACL2 implementations
  built on top of GCL.  It takes exactly the same arguments as
  [comp], and has the same basic functionality (see [comp]), but has
  two additional effects.  First, files \"TMP.lisp\" and \"TMP1.lisp\"
  are always created, even when a single function is specified.
  Second, comp-gcl always leaves files \"TMP.c\", \"TMP.h\", \"TMP1.c\",
  and \"TMP1.h\" when compilation is complete.")
 (COMPILATION
  (PROGRAMMING)
  "Compiling ACL2 functions

  ACL2 has several mechanisms to speed up the evaluation of function
  calls by compiling functions: see [comp], see [set-compile-fns],
  and see [certify-book].  The intention is that compilation never
  changes the value returned by a function call, though it could
  cause the call to succeed rather than fail, for example by avoiding
  a stack overflow.

  The [state] global variable 'compiler-enabled is set automatically
  when the system is built, and may depend on the underlying Lisp
  implementation.  (In order to disable the compiler at build time,
  which will defeat the speed-up but usually be pretty harmless when
  the host Lisp is CCL or SBCL, see the discussion of
  ACL2_COMPILER_DISABLED in distributed file GNUmakefile.)  The value
  of 'compiler-enabled, as returned by (@ compiler-enabled), can be
  t, :books, or nil.  If the value is nil, then [include-book] and
  [certify-book] coerce their arguments :load-compile-file and
  compile-flg arguments (respectively) to nil.  Otherwise, the value
  is :books or t and there is no such coercion; but if the value is
  not t, then [comp] and [set-compile-fns] are no-ops, which is
  probably desirable for Lisps such as CCL and SBCL that compile
  on-the-fly even when the compiler is not explicitly invoked.

  However, you may have reason to want to change the above (default)
  behavior.  To enable compilation by default for [certify-book] and
  [include-book] but not for [comp] or [set-compile-fns]:

    (set-compiler-enabled :books state)

  To enable compilation not only as above but also for [comp] and
  [set-compile-fns]:

    (set-compiler-enabled t state)

  To suppress compilation and loading of compiled files by
  [include-book] (for example, if you get a raw Lisp error such as
  ``Wrong FASL version''):

    (set-compiler-enabled nil state)

  Remark for users of [make-event].  If set-compiler-enabled is invoked
  during make-event expansion, its effect on [state] global variable
  'compiler-enabled will persist after evaluation completes for that
  make-event form.  So for example, one might use the following idiom
  in a book so that for all books included on behalf of a given
  [include-book] form, no compiled files are loaded, but (optionally)
  no such effect takes place for later include-book forms in that
  book.

    (make-event
     (pprogn (f-put-global 'saved-compiler-enabled (@ compiler-enabled) state)
             (set-compiler-enabled nil state)
             (value '(value-triple nil)))
     :check-expansion t)
    (include-book \"my-book\")
    ; optional
    (make-event
     (pprogn (set-compiler-enabled (@ saved-compiler-enabled) state)
             (value '(value-triple nil)))
     :check-expansion t)

  Upon completion of an invocation of [include-book] or [certify-book],
  the value of [state] global variable 'compiler-enabled is restored
  to the value it had immediately before that invocation.

  See [book-compiled-file] for more discussion about compilation and
  [books].

  We close with a discussion of a feature that allows control over the
  loading of .port files in close analogy to how loading of compiled
  files is controlled by set-compiler-enabled, as described above.
  (See [uncertified-books] for a discussion of .port files.)  A
  [state] global variable, 'port-file-enabled exists for this
  purpose, and it is set as follows.

    (set-port-file-enabled t state)   ; permit loading of .port files (default)
    (set-port-file-enabled nil state) ; skip loading of .port files

  Just as described above for state global compiler-enabled, the value
  of 'port-file-enabled persists after [make-event] expansion and is
  restored after [certify-book] and [include-book].  The idiom
  displayed above, for avoiding loading of compiled files, can be
  modified or extended in the obvious way to avoid loading of .port
  files.


Subtopics

  [Comp]
      Compile some ACL2 functions

  [Comp-gcl]
      Compile some ACL2 functions leaving .c and .h files

  [Disassemble$]
      Disassemble a function

  [Set-compile-fns]
      Have each function compiled as you go along.

  [Set-compiler-enabled]
      Disable [compilation].

  [The]
      The is a special form that can be used to optimize the execution
      efficiency of [guard]-verified ACL2 definitions, or (less
      frequently) to carry out a low-level run-time type checks.
      (Advanced)")
 (COMPILING-ACL2P
  (PARALLELISM)
  "Compiling ACL2(p)

  This [documentation] topic relates to the experimental extension of
  ACL2 supporting parallel execution and proof; see [parallelism].
  See [parallelism-tutorial] for an introduction to parallel
  programming in ACL2.

  You can build an experimental version of ACL2 that supports parallel
  execution in the following host Common Lisp implementations:

      * CCL (OpenMCL)

      * Lispworks 6.0

      * SBCL with threads (feature :sb-thread)

  The command below will compile ACL2 to support parallel execution,
  including parallel execution during proofs.  Any non-empty string
  may be used in place of t, and the value of LISP (shown here as
  ccl) is any Lisp executable on which one can build ACL2(p) (see
  [parallelism]).

    make ACL2_PAR=t LISP=ccl

  So for example, to make an executable image and also documentation
  (which will appear in subdirectories doc/EMACS and doc/HTML), using
  the Lisp executable ccl:

    make large DOC ACL2_PAR=t LISP=ccl")
 (COMPLEX
  (NUMBERS ACL2-BUILT-INS)
  "Create an ACL2 number

    Examples:
    (complex x 3) ; x + 3i, where i is the principal square root of -1
    (complex x y) ; x + yi
    (complex x 0) ; same as x, for rational numbers x

  The function complex takes two rational number arguments and returns
  an ACL2 number.  This number will be of type (complex rational) [as
  defined in the Common Lisp language], except that if the second
  argument is zero, then complex returns its first argument.  The
  function [complex-rationalp] is a recognizer for complex rational
  numbers, i.e. for ACL2 numbers that are not rational numbers.

  The reader macro #C (which is the same as #c) provides a convenient
  way for typing in complex numbers.  For explicit rational numbers x
  and y, #C(x y) is read to the same value as (complex x y).

  The functions [realpart] and [imagpart] return the real and imaginary
  parts (respectively) of a complex (possibly rational) number.  So
  for example, (realpart #C(3 4)) = 3, (imagpart #C(3 4)) = 4,
  (realpart 3/4) = 3/4, and (imagpart 3/4) = 0.

  The following built-in axiom may be useful for reasoning about
  complex numbers.

    (defaxiom complex-definition
      (implies (and (real/rationalp x)
                    (real/rationalp y))
               (equal (complex x y)
                      (+ x (* #c(0 1) y))))
      :rule-classes nil)

  A completion axiom that shows what complex returns on arguments
  violating its [guard] (which says that both arguments are rational
  numbers) is the following, named completion-of-complex.

    (equal (complex x y)
           (complex (if (rationalp x) x 0)
                    (if (rationalp y) y 0)))")
 (COMPLEX-RATIONALP
  (NUMBERS ACL2-BUILT-INS)
  "Recognizes complex rational numbers

    Examples:
    (complex-rationalp 3)       ; nil, as 3 is rational, not complex rational
    (complex-rationalp #c(3 0)) ; nil, since #c(3 0) is the same as 3
    (complex-rationalp t)       ; nil
    (complex-rationalp #c(3 1)) ; t, as #c(3 1) is the complex number 3 + i

  See [complex] for more about complex rationals in ACL2.")
 (COMPLEX/COMPLEX-RATIONALP
  (NUMBERS ACL2-BUILT-INS)
  "Recognizer for complex numbers

  For most ACL2 users, this is a macro abbreviating complex-rationalp;
  see [complex-rationalp].  In ACL2(r) (see [real]), a complex number
  x may have irrational real and imaginary parts.  This macro
  abbreviates the predicate complexp in ACL2(r), which holds for such
  x.  Most ACL2 users can ignore this macro and use
  [complex-rationalp] instead.  Some community books use
  complex/complex-rationalp so that they are suitable for ACL2(r) as
  well.")
 (COMPOUND-RECOGNIZER
  (RULE-CLASSES)
  "Make a rule used by the typing mechanism

  See [rule-classes] for a general discussion of rule classes,
  including how they are used to build rules from formulas and a
  discussion of the various keywords in a rule class description.

    Examples:
    (defthm alistp-implies-true-listp-compound-recognizer
      (implies (alistp x)                 ; When (alistp x) is assumed true, add
               (true-listp x))            ; the additional hypothesis that x is
      :rule-classes :compound-recognizer) ; of primitive type true-listp.

    (defthm natp-compound-recognizer      ; See discussion below.
      (equal (natp x)
             (and (integerp x)
                  (<= 0 x)))
      :rule-classes :compound-recognizer)

  Before presenting the General Forms, we start with a motivating
  example: the second [defthm] form above, which provides a nice
  example of a :compound-recognizer rule that is built into ACL2.  To
  see how this rule might be useful, consider the following
  (admittedly very simple) [events].

    (defun triple (x)
      (* 3 x))

    (defthm triple-preserves-integerp
      (implies (integerp x)
               (integerp (triple x))))

    (in-theory (disable triple natp))

  If the above :compound-recognizer rule is disabled, then the
  following trivial theorem fails as shown; we explain below.

    (thm (implies (natp x)
                  (integerp (triple x)))
      :hints ((\"Goal\" :in-theory (disable natp-compound-recognizer))))

  The problem is that when ACL2 tries to rewrite the term (integerp
  (triple x)) using the :[rewrite] rule triple-preserves-integerp, it
  needs to rewrite the hypothesis (integerp x) to t, but instead what
  is known is (natp x).  If we remove the hint, then the proof
  succeeds because the above :compound-recognizer rule tells ACL2
  that when assuming (natp x) to be true, it should actually assume
  both (integerp x) and (<= 0 x) to be true.

    General Forms:
    (implies (fn x) concl)               ; (1)
    (implies (not (fn x)) concl)         ; (2)
    (and (implies (fn x) concl1)         ; (3)
         (implies (not (fn x)) concl2))
    (if (fn x) concl1 concl2)            ; (4)
    (iff (fn x) concl)                   ; (5)
    (equal (fn x) concl)                 ; (6)

  where fn is a Boolean valued function of one argument, x is a
  variable symbol, and the system can deduce some restriction on the
  primitive type of x from the assumption that concl holds.  The last
  restriction is vague but one way to understand it is to strengthen
  it a little to ``and concl is a non-tautological disjunction of the
  primitive type recognizers listed below.''

  The primitive ACL2 types and a suitable primitive recognizing
  expression for each are listed below.

    type                suitable primitive recognizer

    zero                    (equal x 0)
    one                     (equal x 1)
    negative integers       (and (integerp x) (< x 0))
    positive integers > 1   (and (integerp x) (> x 1))
    negative ratio          (and (rationalp x)
                                 (not (integerp x))
                                 (< x 0))
    positive ratio          (and (rationalp x)
                                 (not (integerp x))
                                 (> x 0))
    complex rational        (complex-rationalp x)
    nil                     (equal x nil)
    t                       (equal x t)
    other symbols           (and (symbolp x)
                                 (not (equal x nil))
                                 (not (equal x t)))
    proper conses           (and (consp x)
                                 (true-listp x))
    improper conses         (and (consp x)
                                 (not (true-listp x)))
    strings                 (stringp x)
    characters              (characterp x)

  Thus, since the naturals comprise the types zero, one, and positive
  integers > 1, a suitable concl to recognize the naturals would be

    (or (equal x 0)
        (equal x 1)
        (and (integerp x) (> x 1)))

  However, it turns out that we also permit (and (integerp x) (>= x
  0)), i.e. concl doesn't literally need to be formed as a direct
  disjunction of terms from the table above.

  Similarly, the true-lists could be specified by

    (or (equal x nil)
        (and (consp x)
             (true-listp x)))

  but we in fact allow (true-listp x) as well.  When time permits we
  may document more fully what is allowed or implement a macro that
  permits direct specification of the desired type in terms of the
  primitives.

  There are essentially four forms of :compound-recognizer rules, as
  the forms labeled (3) and (4) above are equivalent, as are those
  labeled (5) and (6).  We explain how such rules are used by
  considering the individual forms.

  Consider form (1), (implies (fn x) concl).  The effect of such a rule
  is that when the rewriter assumes (fn x) true, as it would while
  diving through (if (fn x) xxx ...) to rewrite xxx, it restricts the
  type of x as specified by concl.  For example, if concl is the term
  (integerp x), then when rewriting xxx, x will be assumed to be an
  integer.  However, when assuming (fn x) false, as necessary in (if
  (fn x) ... xxx), the rule permits no additional assumptions about
  the type of x.  For example, if fn is primep, i.e., the predicate
  that recognizes prime numbers, then (implies (primep x) (and
  (integerp x) (>= x 0))) is a compound recognizer rule of the first
  form.  When (primep x) is assumed true, the rewriter gains the
  additional information that x is a natural number.  When (primep x)
  is assumed false, no additional information is gained --- since x
  may be a non-prime natural or may not even be a natural.

  Form (2) is the symmetric case, when assuming (fn x) false permits
  type restrictions on x but assuming (fn x) true permits no such
  restrictions.  For example, if we defined exprp to be the
  recognizer for well-formed expressions for some language in which
  all symbols, numbers, character objects and strings were
  well-formed --- e.g., the well-formedness rules only put
  restrictions on expressions represented by [consp]s --- then the
  theorem (implies (not (exprp x)) (consp x)) is a rule of the second
  form.  Assuming (exprp x) true tells us nothing about the type of
  x; assuming it false tells us x is a [consp].

  Forms (3) and (4), which are really equivalent, address themselves to
  the case where one type may be deduced from (fn x) and a generally
  unrelated type may be deduced from its negation.  If we modified
  the expression recognizer above so that character objects are
  illegal, then rules of the forms (3) and (4) are

    (and (implies (exprp x) (not (characterp x)))
         (implies (not (exprp x)) (or (consp x) (characterp x)))).
    (if (exprp x)
        (not (characterp x))
      (or (consp x) (characterp x)))

  Finally, rules of forms (5) and (6) address the case where fn
  recognizes all and only the objects whose type is described.  In
  these cases, fn is really just a new name for some ``compound
  recognizers.'' The classic example is (booleanp x), which is just a
  handy combination of two primitive types:

    (iff (booleanp x) (or (equal x t) (equal x nil))).

  Often it is best to disable fn after proving that it is a compound
  recognizer, since otherwise the term (fn x) will be expanded and
  thus disappear.

  Every time you prove a new compound recognizer rule about fn it
  overrides all previously proved compound recognizer rules about fn.
  Thus, if you want to establish the type implied by (fn x) and you
  want to establish the type implied by (not (fn x)), you must prove
  a compound recognizer rule of the third, fourth, fifth, or sixth
  forms.  Proving a rule of the first form followed by one of the
  second only leaves the second fact in the database.

  Compound recognizer rules can be disabled with the effect that older
  rules about fn, if any, are exposed.

  If you prove more than one compound recognizer rule for a function,
  you may see a warning message to the effect that the new rule is
  not as ``restrictive'' as the old.  That is, the new rules do not
  give the rewriter strictly more type information than it already
  had.  The new rule is stored anyway, overriding the old, if
  enabled.  You may be playing subtle games with enabling or
  rewriting.  But two other interpretations are more likely, we
  think.  One is that you have forgotten about an earlier rule and
  should merely print it out to make sure it says what you intend,
  and then discard your new rule.  The other is that you meant to
  give the system more information and the system has simply been
  unable to extract the intended type information from the term you
  placed in the conclusion of the new rule.  Given our lack of
  specificity in saying how type information is extracted from rules,
  you can hardly blame yourself for this problem.  Sorry.  If you
  suspect you've been burned this way, you should rephrase the new
  rule in terms of the primitive recognizing expressions above and
  see if the warning is still given.  It would also be helpful to let
  us see your example so we can consider it as we redesign this
  stuff.

  Compound recognizer rules are similar to :[forward-chaining] rules in
  that the system deduces new information from the act of assuming
  something true or false.  If a compound recognizer rule were stored
  as a forward chaining rule it would have essentially the same
  effect as described, when it has any effect at all.  The important
  point is that :[forward-chaining] rules, because of their more
  general and expensive form, are used ``at the top level'' of the
  simplification process: we forward chain from assumptions in the
  goal being proved.  But compound recognizer rules are built in at
  the bottom-most level of the simplifier, where type reasoning is
  done.

  All that said, compound recognizer rules are a rather fancy,
  specialized mechanism.  It may be more appropriate to create
  :[forward-chaining] rules instead of :compound-recognizer rules.")
 (COMPRESS1
  (ARRAYS ACL2-BUILT-INS)
  "Remove irrelevant pairs from a 1-dimensional array

    Example Form:
    (compress1 'delta1 a)

    General Form:
    (compress1 name alist)

  where name is a symbol and alist is a 1-dimensional array, generally
  named name.  See [arrays] for details.  Logically speaking, this
  function can remove irrelevant pairs from alist, possibly
  shortening it.  The function returns a new array, alist', with the
  same [header] (including name and dimension) as alist, that, under
  [aref1], is everywhere equal to alist.  That is, (aref1 name alist'
  i) is (aref1 name alist i), for all legal indices i.  Alist' may be
  shorter than alist and the non-irrelevant pairs may occur in a
  different order than in alist.

  Practically speaking, this function plays an important role in the
  efficient implementation of [aref1].  In addition to creating the
  new array, alist', compress1 makes that array the ``semantic
  value'' of name and allocates a raw lisp array to name.  For each
  legal index, i, that raw lisp array contains (aref1 name alist' i)
  in slot i.  Thus, subsequent [aref1] operations can be executed in
  virtually constant time provided they are given name and the alist'
  returned by the most recently executed compress1 or [aset1] on
  name.  See [arrays].

  In general, compress1 returns an alist whose [cdr] is an association
  list whose keys are nonnegative integers in ascending order.
  However, if the [header] specifies an :order of > then the keys
  will occur in descending order; and if the :order is :none or nil
  then the keys will not be sorted and the header may appear anywhere
  (even more than once), i.e., compress1 is logically the identity
  function (though it still attaches an array under the hood).  Note
  however that a [compress1] call is replaced by a hard error if the
  header specifies an :order of :none or nil and the array's length
  exceeds the [maximum-length] field of its [header].

  We close with a remark concerning efficiency in the case that the
  :ORDER specified by the given [array]'s [header] is < or > and the
  alist is properly ordered: header occurring only first, then
  ascending (for :ORDER <) or descending (for :ORDER >) order of
  indices, with no value in the alist equal to the :DEFAULT specified
  by the header.  In particular, this can cut the time to run
  compress1 on an alist containing only the header by more than half.

  Function: <compress1>

    (defun
     compress1 (name l)
     (declare (xargs :guard (array1p name l)))
     (case
      (array-order (header name l))
      (< (cons (header name l)
               (compress11 name l 0 (car (dimensions name l))
                           (default name l))))
      (> (cons (header name l)
               (reverse (compress11 name l 0 (car (dimensions name l))
                                    (default name l)))))
      (t
       (prog2$
        (and
         (> (length l) (maximum-length name l))
         (hard-error
          'compress1
          \"Attempted to compress a one-dimensional array named ~
                            ~x0 whose header specifies :ORDER ~x1 and whose ~
                            length, ~x2, exceeds its maximum-length, ~x3.\"
          (list (cons #\\0 name)
                (cons #\\1 nil)
                (cons #\\2 (length l))
                (cons #\\3 (maximum-length name l)))))
        l))))")
 (COMPRESS2
  (ARRAYS ACL2-BUILT-INS)
  "Remove irrelevant pairs from a 2-dimensional array

    Example Form:
    (compress2 'delta1 a)

    General Form:
    (compress2 name alist)

  where name is a symbol and alist is a 2-dimensional array, generally
  named name.  See [arrays] for details.  Logically speaking, this
  function removes irrelevant pairs from alist, possibly shortening
  it.  The function returns a new array, alist', with the same
  [header] (including name and dimension) as alist, that, under
  [aref2], is everywhere equal to alist.  That is, (aref2 name alist'
  i j) is (aref2 name alist i j), for all legal indices i and j.
  Alist' may be shorter than alist and the non-irrelevant pairs may
  occur in a different order in alist' than in alist.

  Practically speaking, this function plays an important role in the
  efficient implementation of [aref2].  In addition to creating the
  new array, alist', compress2 makes that array the ``semantic
  value'' of name and allocates a raw lisp array to name.  For all
  legal indices, i and j, that raw lisp array contains (aref2 name
  alist' i j) in slot i,j.  Thus, subsequent [aref2] operations can
  be executed in virtually constant time provided they are given name
  and the alist' returned by the most recently executed compress2 or
  [aset2] on name.  See [arrays].

  Function: <compress2>

    (defun compress2 (name l)
           (declare (xargs :guard (array2p name l)))
           (cons (header name l)
                 (compress21 name l 0 (car (dimensions name l))
                             (cadr (dimensions name l))
                             (default name l))))")
 (COMPUTED-HINT (POINTERS)
                "See [computed-hints].")
 (COMPUTED-HINTS
  (HINTS)
  "Computing advice to the theorem proving process

    General Form of :hints:
    (hint1 hint2 ... hintk)

  Each element, hinti, must be either a common hint or a computed hint.

  A common hint is of the form

    (goal-spec :key1 val1 ... :keyn valn)

  where goal-spec is as specified in [goal-spec] and each :keyi and
  vali is as specified in [hints].  Among the ``common hints'' we
  include both the primitive hints and user-defined custom keyword
  hints (see [custom-keyword-hints]).

  A computed hint may be a function symbol, fn, of three, four or seven
  arguments.  Otherwise, a computed hint is a term with the following
  properties:

  (a) the only free variables allowed in the term are ID, CLAUSE,
  WORLD, STABLE-UNDER-SIMPLIFICATIONP, HIST, PSPV, CTX, and [state];

  (b) the output signature of the term is either (MV * * STATE), which
  is to be treated as an error triple (see below), or is *, denoting
  a single non-[stobj] value; and

  (c) in the former case of (b) above, the term is single-threaded in
  [state].

  If a computed hint is a function symbol fn, whose arity n is
  therefore three, four, or seven, then it is treated as the term
  resulting from applying that fn to the first n variables shown in
  (a) above.  Notice that it must then return a single non-[stobj]
  value, not an error triple, since state is not one of the first
  seven variables shown in (a).

  Note: Error triples are an ACL2 idiom for implementing ``errors'';
  see [error-triple].  If a computation returns (mv erp val state) in
  a context in which ACL2 is respecting the error triple convention
  (see [ld-error-triples] and see [ld-error-action]), then an error
  is deemed to have occurred if erp is non-nil.  The computation is
  expected to have printed an appropriate error message to [state]
  and further computation is aborted.  On the other hand, if a
  computation returns an error triple in which erp is nil, then
  ``value'' of the computation is taken to be the second component,
  val, of the triple (along with the possibly modified [state]), and
  computation continues.  For more information about programming with
  error triples, see [programming-with-state].

  The function symbol cases are treated as abbreviations of the term
  (fn ID CLAUSE WORLD), (fn ID CLAUSE WORLD
  STABLE-UNDER-SIMPLIFICATIONP), or (fn ID CLAUSE WORLD
  STABLE-UNDER-SIMPLIFICATIONP HIST PSPV CTX) as appropriate for the
  arity of fn.  (Note that this tells you which argument of fn is
  which.)  Moreover, in these cases the value returned must be a
  single ordinary (non-[stobj]) value, not an error triple.  In the
  discussion below we assume all computed hints are of the term form.
  Indeed, we almost assume all computed hints are of the 3 and 4
  argument forms.  We only comment briefly on the 7 argument form in
  [using-computed-hints-8].

  The semantics of a computed hint term is as follows.  On every
  subgoal, the term is evaluated in an environment in which the
  variables mentioned in (a) above are bound to context-sensitive
  values explained below.  Either the computed hint signals an error,
  in which the proof attempt aborts, or else it returns a value, val
  and a new state, [state].  Any changes to those parts of [state]
  that affect logical soundness are undone; more specifically, the
  values of symbols (sometimes called ``state global variables'') in
  the list *protected-system-state-globals* in the global table of
  the state (see [state]) are restored when changed during
  evaluation.  The value, val, of a non-erroneous computed hint
  calculation is either nil, which means the computed hint did not
  apply to the subgoal in question, or it is an alternating list of
  :keyi vali pairs as specified in [hints].  With one exception,
  those new hints are applied to the given subgoal as though the user
  had typed them explicitly.

  The exception is that the first keyword in the returned val is
  allowed to be :COMPUTED-HINT-REPLACEMENT.  Its value should be nil,
  t, or a list of terms.  If this keyword is not present, the default
  value of nil is provided.  We explain :COMPUTED-HINT-REPLACEMENT
  below.

  The evaluation of a hint term is done with guard checking turned off
  (see [set-guard-checking]); e.g., the form (car 23) in a computed
  hint returns nil as per the axioms.

  When a non-nil value is returned, the keyword/value pairs (other than
  the optional :COMPUTED-HINT-REPLACEMENT) are used as the hint for
  the subgoal in question.  Thus, your job as the programmer of
  computed hints is either to cause an error, typically by invoking
  [er], or to return a non-erroneous value triple whose value is the
  list of keys and values you would have typed had you supplied a
  common hint for the subgoal. (In particular, any theory expressions
  in it are evaluated with respect to the global current-theory, not
  whatever theory is active at the subgoal in question.)  If the
  generated list of keywords and values is illegal, an error will be
  signaled and the proof attempt will be aborted.

  The purpose of the :COMPUTED-HINT-REPLACEMENT keyword and its value,
  chr, is to change the list of hints.  If chr is nil, then the
  computed hint which was applied is removed from the list of hints
  that is passed down to the children of the subgoal in question.
  This is the default.  If chr is t, then the computed hint is left
  in the list of hints.  This means that the same computed hint may
  act on the children of the subgoal.  Otherwise, chr must be a list
  of terms, each of which is treated as a computed hint.  The
  computed hint which was applied is deleted from the list of hints
  and the computed hints in chr are added to the list of hints passed
  to the children of the subgoal.  The ability to generate new
  computed hints and pass them down allows strange and wonderful
  behavior.  Notice that certain hints, for example :in-theory and
  :expand hints, which appear in the computed hint will continue to
  take effect even when chr is nil.  This might give one the false
  impression that a removed computed hint still hangs around.  See
  [hints-and-the-waterfall] for a more detailed discussion about how
  :in-theory and other hints are handled in the waterfall.

  For these purposes, the goals produced by induction and the top-level
  goals of forcing rounds are not considered children; all original
  hints are available to them.

  Only the first hint applicable to a goal, as specified in the
  user-supplied list of :hints followed by the [default-hints-table],
  will be applied to that goal.  (For an advanced exception, see
  [override-hints].)

  It remains only to describe the bindings of the free variables.

  Suppose the theorem prover is working on some clause, clause, named
  by some [goal-spec], e.g., \"Subgoal *1/2'''\" in some logical world,
  world.  Corresponding to the printed goal-spec is an internal data
  structure called a ``clause identifier'' id.  See
  [clause-identifier].

  In the case of a common hint, the hint applies if the goal-spec of
  the hint is the same as the goal-spec of the clause in question.

  In the case of a computed hint, the variable ID is bound to the
  clause id, the variable CLAUSE is bound to the (translated form of
  the) clause, and the variable WORLD is bound to the current ACL2
  world.  The variable STABLE-UNDER-SIMPLIFICATIONP is bound to t or
  nil.  It is bound to t only if the clause is known to be stable
  under simplification.  That is, the simplifier has been applied to
  the clause and did not change it.  Such a clause is sometimes known
  as a ``simplification checkpoint.'' It is frequently useful to
  inject hints (e.g., to enable a rule or provide a :use hint) only
  when the goal in question has stabilized.  If a hint is provided,
  the processing of the clause starts over with simplification.

  As for CTX and [state], they are provided so that you can pass them
  to the [er] macro to print error messages.  We recommend not
  writing computed hints that otherwise change [state]!

  The remaining variables, HIST and PSPV are not documented yet.  Only
  users familiar with the internals of ACL2 are likely to need them
  or understand their values.

  For some instruction about how to use computed hints, see
  [using-computed-hints].


Subtopics

  [Using-computed-hints]
      How to use computed hints")
 (CONCATENATE
  (LISTS STRINGS ACL2-BUILT-INS)
  "Concatenate lists or strings together

    Examples:
    (concatenate 'string \"ab\" \"cd\" \"ef\")     ; equals \"abcdef\"
    (concatenate 'string \"ab\")               ; equals \"ab\"
    (concatenate 'list '(a b) '(c d) '(e f)) ; equals '(a b c d e f)
    (concatenate 'list)                      ; equals nil

    General Form:
    (concatenate result-type x1 x2 ... xn)

  where n >= 0 and either: result-type is '[string] and each xi is a
  string; or result-type is '[list] and each xi is a true list.
  Concatenate simply concatenates its arguments to form the result
  string or list.  Also see [append] and see [string-append].  (The
  latter immediately generates a call to concatenate when applied to
  strings.)

  Note: We do *not* try to comply with the Lisp language's insistence
  that concatenate copies its arguments.  Not only are we in an
  applicative setting, where this issue shouldn't matter for the
  logic, but also we do not actually modify the underlying lisp
  implementation of concatenate; we merely provide a definition for
  it.

  Concatenate is a Common Lisp function.  See any Common Lisp
  documentation for more information.

  Macro: <concatenate>

    (defmacro concatenate
              (result-type &rest sequences)
              (declare (xargs :guard (or (equal result-type ''string)
                                         (equal result-type ''list))))
              (cond ((equal result-type ''string)
                     (cond ((and sequences (cdr sequences)
                                 (null (cddr sequences)))
                            (list 'string-append
                                  (car sequences)
                                  (cadr sequences)))
                           (t (list 'string-append-lst
                                    (cons 'list sequences)))))
                    ((endp sequences) nil)
                    (t (cons 'append
                             (append sequences (list nil))))))")
 (COND
  (BASICS ACL2-BUILT-INS)
  "Conditional based on if-then-else

  Cond is the construct for IF, THEN, ELSE IF, ...  The test is against
  nil.  The argument list for cond is a list of ``clauses'', each of
  which is a list.  In ACL2, clauses must have length 1 or 2.

    ; Example 1.  The form
      (COND ((CONSP X) (FOO X Y))
            ((SYMBOLP X) (BAR X Y))
            (T (LIST X Y)))
    ; abbreviates the following.
      (IF (CONSP X)
          (FOO X Y)
          (IF (SYMBOLP X)
              (BAR X Y)
              (LIST X Y)))

    ; Example 2.  The form
      (COND ((CONSP X))
            ((SYMBOLP X) (BAR X Y)))
    ; abbreviates the following.
      (OR (CONSP X)
          (IF (SYMBOLP X) (BAR X Y) NIL))

  The results above were obtained by typing :trans1 followed by the
  form in the ACL2 loop, and then hitting <RETURN>.  See [trans1].
  You can experiment in this way to see other such examples.

  Cond is a Common Lisp macro.  See any Common Lisp documentation for
  more information.

  Macro: <cond>

    (defmacro cond (&rest clauses)
              (declare (xargs :guard (cond-clausesp clauses)))
              (cond-macro clauses))

  Function: <cond-macro>

    (defun cond-macro (clauses)
           (declare (xargs :guard (cond-clausesp clauses)))
           (if (consp clauses)
               (if (and (eq (car (car clauses)) t)
                        (eq (cdr clauses) nil))
                   (if (cdr (car clauses))
                       (car (cdr (car clauses)))
                       (car (car clauses)))
                   (if (cdr (car clauses))
                       (list 'if
                             (car (car clauses))
                             (car (cdr (car clauses)))
                             (cond-macro (cdr clauses)))
                       (list 'or
                             (car (car clauses))
                             (cond-macro (cdr clauses)))))
               nil))")
 (CONGRUENCE
  (RULE-CLASSES)
  "The relations to maintain while simplifying arguments

  See [rule-classes] for a general discussion of rule classes and how
  they are used to build rules from formulas.  An example
  :[corollary] formula from which a rule of class :congruence might
  be built, assuming that set-equal is a known [equivalence]
  relation, is:

    Example:
    (defthm set-equal-implies-iff-memb-2
      (implies (set-equal x y)
               (iff (memb e x) (memb e y)))
      :rule-classes :congruence)

  Also see [defcong] and see [equivalence].

  NOTE: This topic discusses so-called ``classic'' congruence rules.  A
  more general class of rules, so-called ``patterned'' congruence
  rules, is supported.  We discuss only classic congruence rules
  below; for a discussion of patterned congruence rules, first read
  the present topic and then see [patterned-congruence].

    General Form:
    (implies (equiv1 xk xk-equiv)
             (equiv2 (fn x1... xk       ...xn)
                     (fn x1... xk-equiv ...xn)))

  where equiv1 and equiv2 are known equivalence relations, fn is an
  n-ary function symbol other than if, and the xi and xk-equiv are
  all distinct variables.  The effect of such a rule is to record
  that the equiv2-equivalence of fn-expressions can be maintained if,
  while rewriting the kth argument position, equiv1-equivalence is
  maintained.  See [equivalence] for a general discussion of the
  issues.  We say that equiv2, above, is the ``outside equivalence''
  in the rule and equiv1 is the ``inside equivalence for the kth
  argument.''

  The macro form (defcong equiv1 equiv2 (fn x1 ... x1) k) is an
  abbreviation for a [defthm] of rule-class :congruence that attempts
  to establish that equiv2 is maintained by maintaining equiv1 in
  fn's kth argument.  The [defcong] macro automatically generates the
  general formula shown above.  See [defcong].

  The memb example above tells us that (memb e x) is propositionally
  equivalent to (memb e y), provided x and y are set-equal.  The
  outside equivalence is [iff] and the inside equivalence for the
  second argument is set-equal.  If we see a memb expression in a
  propositional context, e.g., as a literal of a clause or test of an
  [if] (but not, for example, as an argument to [cons]), we can
  rewrite its second argument maintaining set-equality.  For example,
  a rule stating the commutativity of [append] (modulo set-equality)
  could be applied in this context.  Since equality is a refinement
  of all equivalence relations, all equality rules are always
  available.  See [refinement].

  All known congruence rules about a given outside equivalence and fn
  can be used independently.  That is, consider two congruence rules
  with the same outside equivalence, equiv, and about the same
  function fn.  Suppose one says that equiv1 is the inside
  equivalence for the first argument and the other says equiv2 is the
  inside equivalence for the second argument.  Then (fn a b) is equiv
  (fn a' b') provided a is equiv1 to a' and b is equiv2 to b'.  This
  is an easy consequence of the transitivity of equiv.  It permits
  you to think independently about the inside equivalences.

  Furthermore, it is possible that more than one inside equivalence for
  a given argument slot will maintain a given outside equivalence.
  For example, (length a) is equal to (length a') if a and a' are
  related either by list-equal or by [string-equal].  You may prove
  two (or more) congruence rules for the same slot of a function.
  The result is that the system uses a new, ``generated'' equivalence
  relation for that slot with the result that rules of both (or all)
  kinds are available while rewriting.

  Congruence rules can be [disable]d.  For example, if you have two
  different inside equivalences for a given argument position and you
  find that the :[rewrite] rules for one are unexpectedly preventing
  the application of the desired rule, you can disable the rule that
  introduced the unwanted inside equivalence.

  NOTE however that unlike other rules, the tracking of congruence
  rules is incomplete.  Specifically: when congruence rules are used
  by the rewriter as it descends through terms, to maintain the
  generated equivalence relation used for rewriting, ACL2 does not
  track the congruence rules that are used, even though it is
  relevant that they are all [enable]d.  Congruence rules that are
  used only in this way will therefore not appear in the [summary].

  Remark on Replacing IFF by EQUAL. You may encounter a warning
  suggesting that a congruence rule ``can be strengthened by
  replacing the second equivalence relation, IFF, by EQUAL.'' Suppose
  for example that this warning occurs when you submit the following
  rule:

    (defcong equiv1 iff (fn x y) 2)

  which is shorthand for the following:

    (defthm equiv1-implies-iff-fn-2
           (implies (equiv1 y y-equiv)
                    (iff (fn x y) (fn x y-equiv)))
           :rule-classes (:congruence))

  The warning is telling you that ACL2 was able to deduce that fn
  always returns a Boolean, and hence a trivial but useful
  consequence is obtained by replacing [iff] by [equal] ---

    (defcong equiv1 equal (fn x y) 2)

  --- which is shorthand for the following:

    (defthm equiv1-implies-equal-fn-2
           (implies (equiv1 y y-equiv)
                    (equal (fn x y) (fn x y-equiv)))
           :rule-classes (:congruence))

  If you have difficulty proving the latter directly, you can derive it
  from the former by giving a suitable hint, minimally as follows.

    (defcong equiv1 equal (fn x y) 2
      :hints ((\"Goal\"
               :use equiv1-implies-iff-fn-2
               :in-theory
               (union-theories '((:type-prescription fn))
                               (theory 'minimal-theory)))))

  By heeding this warning, you may avoid unnecessary [double-rewrite]
  warnings later.  We now explain why, but see [double-rewrite] for
  relevant background material.

  For example, suppose you have proved the ``iff'' version of the
  congruence rule above, and later you submit the following rewrite
  rule.

    (defthm equal-list-perm
      (implies (equiv1 x y)
               (fn x y)))

  Since fn is known to return a Boolean, ACL2 performs an optimization
  that stores this rule as though it were the following.

    (defthm equal-list-perm
      (implies (equiv1 x y)
               (equal (fn x y) t)))

  Thus, if ACL2's rewriter sees a term (fn a b) in a context where the
  equivalence relation [iff] is not being maintained, then it cannot
  use rule equiv1-implies-iff-fn-2, so it rewrites argument a without
  the benefit of knowing that it suffices to maintain equiv1; and
  then it caches the result.  When ACL2 subsequently attempts to
  relieve the hypothesis (equiv1 x y), it will rewrite x simply by
  returning the rewritten value of a from the result cache.  This is
  unfortunate if a could have been rewritten more completely under
  maintenance of the equivalence relation equiv1 --- which is legal
  in the hypothesis since a is an argument of equiv1, which is an
  [equivalence] relation.  The user who observes the warning from
  rule equiv1-implies-iff-fn-2, and replaces it with
  equiv1-implies-equal-fn-2, will avoid this unfortunate case.")
 (CONJOIN (POINTERS)
          "See [system-utilities].")
 (CONJOIN2 (POINTERS)
           "See [system-utilities].")
 (CONJUGATE
  (NUMBERS ACL2-BUILT-INS)
  "Complex number conjugate

  Conjugate takes an ACL2 number as an argument, and returns its
  complex conjugate (i.e., the result of negating its imaginary
  part.).

  Conjugate is a Common Lisp function.  See any Common Lisp
  documentation for more information.

  Function: <conjugate>

    (defun conjugate (x)
           (declare (xargs :guard (acl2-numberp x)))
           (complex (realpart x) (- (imagpart x))))")
 (CONS
  (CONSES ACL2-BUILT-INS)
  "Pair and list constructor

  (cons x y) is a pair whose first component is x and second component
  is y.  If y is a list, then (cons x y) is a list that has an
  additional element x on the front.")
 (CONS-COUNT-BOUNDED
  (CONSES ACL2-BUILT-INS)
  "Count the number of conses (up to a limit)

  The call (cons-count-bounded x) returns the number of cons nodes in x
  (without accounting for sharing), but truncated above by the value
  of (fn-count-evg-max-val), which is 200,000 as of this writing.")
 (CONS-SUBTREES
  (FAST-ALISTS ACL2-BUILT-INS)
  "Build a fast alist whose keys are the subtrees of X

  (cons-subtrees x nil) builds a fast alist that associates each
  subtree of X with T, without duplication.

  Function: <cons-subtrees>

    (defun
         cons-subtrees (x al)
         (declare (xargs :guard t))
         (cond ((atom x) al)
               ((hons-get x al) al)
               (t (cons-subtrees (car x)
                                 (cons-subtrees (cdr x)
                                                (hons-acons x t al))))))")
 (CONS-TERM (POINTERS)
            "See [system-utilities].")
 (CONS-TERM* (POINTERS)
             "See [system-utilities].")
 (CONS-WITH-HINT
  (CONSES ACL2-BUILT-INS)
  "Alternative to [cons] that tries to avoid consing when a suitable
  cons structure is provided as a hint.

  This is a special purpose function that is intended to help with
  reducing the memory usage of functions that modify existing cons
  tree structures.  Also see [hons] for a way to share [cons]
  structures; however, cons-with-hint is likely much cheaper than
  hons and hence can be useful for reducing consing without the
  overhead of hons.

  Logically (cons-with-hint x y hint) is just (cons x y); hint is
  completely irrelevant and ignored.  We generally expect that
  cons-with-hint will just be left [enable]d, so you should never
  have to reason about it.

  But cons-with-hint has a special raw Common Lisp definition that
  tries to avoid consing by using your hint.  Specifically: if hint
  is the cons (x . y), then hint is returned without creating a new
  cons.  Equality checking against x and y is done using [eql], which
  makes it a fast but incomplete check for equality.

  What good is this?  A fairly common operation in ACL2 is to
  ``change'' an existing data structure by consing together a new
  structure that is similar to it, but perhaps with some subtrees
  replaced.  In many cases, some portion of the structure does not
  need to change.

  For instance, consider a function like [remove-equal], which updates
  a list by removing all copies of some element from it.  The
  definition of remove-equal is as follows (in the logic; it has a
  slightly different definition in raw Lisp).

  Function: <remove-equal>

    (defun remove-equal (x l)
           (declare (xargs :guard (true-listp l)))
           (cond ((endp l) nil)
                 ((equal x (car l))
                  (remove-equal x (cdr l)))
                 (t (cons (car l)
                          (remove-equal x (cdr l))))))

  You can see that if l doesn't have any copies of x, this function
  will essentially make a fresh copy of the whole list x.  That could
  waste a lot of memory when x is long.  The choice was made to
  define remove-equal ``under the hood'' to call Common Lisp's
  function, remove; but it is easy to write a new version of
  remove-equal that uses cons-with-hint:

    (defun remove-equal-with-hint (x l)
      (declare (xargs :guard (true-listp l)))
      (mbe :logic (remove-equal x l)
           :exec (cond ((endp l) nil)
                       ((equal x (car l))
                        (remove-equal-with-hint x (cdr l)))
                       (t
                        (cons-with-hint (car l)
                                        (remove-equal-with-hint x (cdr l))
                                        l)))))

  This new version avoids consing in the case that we are not dropping
  an element.  For example, at the time of this writing, we found the
  following memory usages on our copy of ACL2 built on CCL:

    :q

    ;; 16 MB of memory allocated
    (let ((list (make-list 1000 :initial-element 0)))
      (time (loop for i from 1 to 1000 do (remove-equal i list))))

    ;; 0 MB of memory allocated
    (let ((list (make-list 1000 :initial-element 0)))
      (time (loop for i from 1 to 1000 do (remove-equal-with-hint i list))))

  This memory usage is not very surprising when you consider that the
  list does not change when no removal takes place.  For example
  (still in raw Lisp):

    ? (let ((x '(a b c d e))) (eq x (remove-equal-with-hint 3 x)))
    T
    ?

  Note that ACL2 asks Lisp to inline calls of cons-with-hint, so there
  will likely be no function call overhead for using cons-with-hint.")
 (CONSERVATIVITY-OF-DEFCHOOSE
  (DEFCHOOSE)
  "Proof of conservativity of [defchoose]

  This documentation topic provides underlying theory.  It is of
  theoretical interest only; it has no relationship to the effective
  use of ACL2.

  The argument below for the conservativity of [defchoose] replaces the
  terse and somewhat misleading reference to a forcing argument in
  Appendix B of the paper by ACL2 authors Kaufmann and Moore,
  ``Structured Theory Development for a Mechanized Logic'' (Journal
  of Automated Reasoning 26, no. 2 (2001), pp. 161--203).

  Our basic idea is to take a (countable) first-order structure for
  ACL2, M, together with a function symbol, f, introduced by
  [defchoose], and find a way to expand M with an interpretation of f
  (without changing the universe of M) so that e0-induction continues
  to hold in the expansion.  A remark at the end of this
  documentation topic shows why care is necessary.  A concept called
  ``forcing'', originally introduced by Paul Cohen for set theory,
  has long since been adapted by logicians (in a simplified form) to
  model theory.  This simplified model-theoretic forcing provides the
  means for making our careful expansion.

  The forcing argument presented below is intended to be completely
  self-contained for those familiar with basic first-order logic and
  ACL2; in particular, see [defchoose].  No background in forcing
  (model-theoretic or otherwise) is expected, though we do expect a
  rudimentary background in first-order logic and familiarity with
  the following.

  Preliminaries.  We write s[p<-p0] to denote the result of extending
  or modifying the assignment s by binding p to p0.  Now let A be a
  subset of the universe U of a first-order structure M.  A is said
  to be ``first-order definable with parameters'' in M if for some
  formula phi, variable x, and assignment s binding the free
  variables of phi except perhaps for x, A = {a \\in U: M |=
  phi[s[x<-a]]}.  Note that we are writing ``\\in'' to denote set
  membership.  Finally, we indicate the end of a proof (or of a
  theorem statement, when the proof is omitted) with the symbol
  ``-|''.

  We gratefully acknowledge very helpful feedback from John Cowles, who
  found several errors in a draft of this note and suggested the
  exercises.  We also thank Ruben Gamboa for helpful feedback, and we
  thank Jim Schmerl for an observation that led us directly to this
  proof in the first place.

  We are given a consistent first-order theory T, extending the ACL2
  ground-zero theory, that satisfies the e0-induction scheme.  We
  wish to show that the extension of T by the following arbitrary
  defchoose event is conservative, where g is a new function symbol.

    (defchoose g <bound-vars> <free-vars> <body>)

  Note that by ``the extension of T'' here we mean the extension of T
  by not only the new defchoose axiom displayed just below, but also
  the addition of e0-induction axioms for formulas in the expanded
  language obtained by including the new defchoose function symbol,
  g.

    <body> -> (LET <bound-vars> = g(<free-vars>) in <body>)

  By definition of conservativity, since proofs are finite, it clearly
  suffices to consider an arbitrary finite subset of T.  Then by the
  completeness, soundness, and downward Lowenheim-Skolem theorems of
  first-order logic, it suffices to show that an arbitrary countable
  model of T can be expanded (i.e., by interpreting the new symbol g
  without changing the universe of the model) to a model of the
  corresponding defchoose axiom above, in which all e0-induction
  axioms hold in the language of that model (i.e., the expanded
  language).

  Below, we will carry out a so-called forcing construction, which
  allows us to expand any countable model M of T to a model M[G] for
  the expanded language that satisfies e0-induction (in the expanded
  language) and also satisfies the axiom displayed above, generated
  from the defchoose event.  The ideas in this argument are standard
  in model theory; no novelty is claimed here.

  Fix a countable model M of a theory T that satisfies e0-induction for
  its countable language and extends the ACL2 ground-zero theory.
  Also fix the above defchoose axiom, where g is not in the language
  of T.

  We start by defining a partial order P as follows.  Let Nb and Nf be
  the lengths of <bound-vars> and <free-vars>, respectively.  P
  consists of all fn in M such that the following formula is true in
  M.  Roughly speaking, it says that fn is a finite function that
  witnesses, on its domain, the requirement above for g.

    alistp(fn) &
    no-duplicatesp-equal(strip-cars(fn)) &
    (forall <bound-vars>, <free-vars> .
       (member-equal(cons(<free-vars>,<bound-vars>), fn) ->
        (length(<bound-vars>) = Nb &
         length(<free-vars>)  = Nf &
         ((exists <bound-vars> . <body>) ->
          (LET <bound-vars> = g(<free-vars>) in <body>)))))

  P is ordered by subset, i.e., we say that p2 extends p1 if p1 is a
  subset (not necessarily proper) of p2 (more precisely, M |=
  subsetp-equal(p1,p2)).

  Remark.  The original argument in Appendix B of the aforementioned
  paper can essentially be salvaged, as we now show.  The key
  observation is that the particular choice of P is nearly irrelevant
  for the argument that follows below.  In particular, we can instead
  define P to consist of finite one-one functions with domain
  contained in the set of natural numbers.  More precisely, consider
  the following definitions.

    (defun function-p (fn)
      (and (alistp fn)
           (no-duplicatesp-equal (strip-cars fn))))

    (defun nat-function-p (x)
      (and (function-p x)
           (nat-listp (strip-cars x))))

  and define an inverse function on alists as follows.

    (defun inverse (fn)
      (if (endp fn)
          nil
        (cons (cons (cdar fn) (caar fn))
              (inverse (cdr fn)))))

  Then P may instead be defined to consist of those fn for which
  nat-function-p(fn) & function-p(inverse(fn)).  With this alternate
  definition of P, the argument below then goes through virtually
  unchanged, and we get an expansion M[G] of M in which there is a
  definable enumeration of the universe.  The conservativity of
  defchoose then follows easily because the function being introduced
  can be defined explicitly using that enumeration (namely, always
  pick the least witness in the sense of the enumeration).

  End of Remark.

  Next we present the relevant forcing concepts from model theory.

  A dense subset of P is a subset D of P such that for every p \\in P,
  there is d \\in D such that d extends p.  A subset G of P is generic
  with respect to a collection Ds of dense subsets of P, also written
  ``G is Ds-generic,'' if G is closed under subset (if p2 \\in G and
  p2 extends p1 then p1 \\in G), G is pairwise compatible (the
  union-equal of any two elements of G is in G), and every set in Ds
  has non-empty intersection with G.

  For p \\in P, we say that a subset D of P is dense beyond p if for all
  p1 extending p there exists p2 extending p1 such that p2 \\in D.
  This notion makes sense even for D not a subset of P if we treat
  elements of D not in P as nil.

  Proposition 1.  For any partial order P and countable collection Ds
  of dense subsets of P, there is a Ds-generic subset of P.

  Proof.  Let Ds = {D0,D1,D2,...}.  Define a sequence <p_0,p_1,...>
  such that for all i, p_i \\in Di and p_(i+1) extends p_i.  Let G =
  {p \\in P: for some i, pi extends p}.  Then G is Ds-generic. -|

  Note that P is first-order definable (with parameters) in M.  Let Df
  be the set of dense subsets of P that are first-order definable
  (with parameters) in M.  A standard argument shows there are only
  countably many first-order definitions with parameters in a
  countable model M whose language is countable --- for example, we
  can Goedel number all terms and then all formulas --- hence, Df is
  countable.

  By Proposition 1, let G be Df-generic.  Notice that for any list x of
  length Nf in M, the set of elements f of P for which x is in the
  domain of f is dense and first-order definable.  We may thus define
  a function g0 as follows: g0(x_1,...,x_Nf) = y if there is some
  element of G containing the pair ((x_1 ... x_Nf) . y).  It is easy
  to see that g0 is a total function on M.  Let L be the language of
  T and let L[g] be the union of L with a set containing a single new
  function symbol, g.  Let M[G] be the expansion of M to L[g]
  obtained by interpreting g to be g0 (see also Proposition 5 below).

  So now we have fixed M, P, Df, G, and g0, where G is Df-generic.

  Proposition 2.  Let Df be the set of dense subsets of P that are
  first-order definable (with parameters) in M.  Suppose that p \\in G
  and D \\in Df.  Then for some q \\in G extending p, q \\in D.

  Proof.  Let D0 be the set of p' \\in D that either extend p or have no
  extension in D that extends p.  We leave it as a straightforward
  exercise to show that D0 is dense, and D0 is clearly first-order
  definable (with parameters) in M.  So by genericity of G, we may
  pick q \\in D0 such that q \\in G.  Thus q \\in D.  By definition of
  generic, some extension q1 of both p and q belongs to G.  Pick q2
  \\in D extending q1; thus q has an extension in D that extends p
  (namely, q2), so by definition of D0, q extends p. -|

  Definition of forcing.  Let phi(x1,...,xk) be a first-order formula
  in L[g] and let p \\in P.  We define a formula of L, denoted ``p ||-
  phi'' (``p forces phi''), by recursion on phi (in the metatheory)
  as follows.  (Here, we view ``or'' and ``forall'' as
  abbreviations.)

      If phi is atomic, then let phi'(A) be the result of replacing,
      inside-out, each subterm of the form g(x_1,...,x_Nb) with the
      term (cdr (assoc-equal (list x_1 ... x_Nb) A)), where A is
      neither p nor a variable occurring in phi.  Then p ||- phi is
      defined as follows: ``The set {A \\in P: A extends p and
      phi'(A)} is dense beyond p''.  That is, p ||- phi is the
      following formula:

        (forall p1 \\in P extending p)
         (exists p2 \\in P extending p1) phi'(p2).

      p ||- ~phi is: (forall p' \\in P extending p) ~(p' ||- phi)

      p ||- phi_1 & phi_2 is: (p ||- phi_1) & (p ||- phi_2)

      p ||- (exists x) phi is: (exists x) (p ||- phi)

  We will need the following definition later.

  Definition.  p ||-w phi (p weakly forces phi) is an abbreviation for
  p ||- ~~phi.

  The following exercises were suggested by John Cowles as a means for
  gaining familiarity with the definition of forcing.

  Exercise 1. Consider the formula (phi_1 OR phi_2) as an abbreviation
  for ~(~phi_1 & ~phi_2), Show that p ||- (phi_1 OR phi_2) is
  equivalent to the following.

    (forall p' \\in P extending p) (exists p'' \\in P extending p')
     ((p'' ||- phi_1) OR (p'' ||- phi_2))

  Exercise 2. Consider the formula (forall x)phi as an abbreviation for
  ~(exists x)~phi, Show that p ||- (forall x)phi is equivalent to the
  following.

    (forall x)
     (forall p1 \\in P extending p)
      (exists p2 \\in P extending p1) (p2 ||- phi).

  Exercise 3. Prove that p ||-w phi is equivalent to the following.

    (forall p' \\in P extending p)
     (exists p'' \\in P extending p') (p'' ||- phi).

  Exercise 4. Let phi be a formula of L[g].  Prove: M |= (p ||-
  phi)[s[p<-p0]] implies M |= (p ||-w phi)[s[p<-p0]].

  Exercise 5. Let phi be a formula of L[g].  Prove: M |= (p ||-
  ~phi)[s[p<-p0]] iff M |= (p ||-w ~phi)[s[p<-p0]].

  [End of exercises.]

  The definition of forcing stipulates how to view ``p ||-
  phi(x1,...,xk)'' as a new formula theta(p,x1,...,xk).  That is,
  ``||-'' transforms formulas, so for any first-order formula phi,
  ``p ||- phi'' is just another first-order formula.  That
  observation shows that a formula such as ((p ||- phi) OR (p ||-
  ~phi)) is really just another first-order formula.  The following
  proposition thus follows easily.

  Proposition 3. For any formula phi of L[g], {p0: M |= ((p ||- phi) OR
  (p ||- ~phi))[s[p<-p0]]]} is a dense subset of P, which (since it
  is first-order definable with parameters in M) intersects G. -|

  The following proposition is easily proved by a structural induction
  on phi, and is left to the reader.

  Proposition 4. Let phi be a formula of L[g].  Suppose p0 \\in P, p1
  \\in P,
  M |= (p ||- phi)[s[p<-p0]],
  and p1 extends p0.  Then
  M |= (p ||- phi)[s[p<-p1]]. -|

  We will also need the following.

  Proposition 5. The following is dense for any finite set S of
  Nf-tuples: {p \\in P: for some <x_1 ... x_Nf> \\in S, (list x_1 ...
  x_Nf) \\in strip-cars(p)}.  Thus, the function g0 is a total
  function. -|

  The next lemma tells us that the sentences true in M[G] are those
  that are forced by an element of G.

  Truth Lemma.  Let phi be a formula in L[g], let s be an assignment to
  the free variables of phi, and let p be a variable not in the
  domain of s.  Then M[G] |= phi[s] iff for some p0 \\in G, M |= (p
  ||- phi)[s[p<-p0]].

  Proof.  The proof is by induction on the structure of phi.  First
  suppose phi is atomic.  Let D* be the set of elements p0 \\in P such
  that every assoc-equal evaluation from the definition of forcing
  phi returns a pair when A is bound to p0.  (Intuitively, this means
  that p0 is a sufficiently large approximation from any G containing
  p0 to make sense of phi in M[G].)  We make the following claim.

    (*)   For all p0 \\in G such that p0 \\in D*,
          M[G] |= phi[s] iff M |= (p ||- phi)[s[p<-p0]].

  To prove the claim, fix p0 in both G and D*, and recall the function
  g0 constructed from G in the definition of M[G].  Suppose that t_1,
  ..., t_Nf are terms and g(t_1, ..., t_Nf) is a subterm of phi.
  Then s assigns a value in M to each of the t_i.  Let a_i be the
  value assigned by s to t_i.  Then g0(a_1, ..., a_Nf) = (cdr
  (assoc-equal (list a_1 ... a_Nf) p0)), as the assoc-equal is a pair
  (since p0 \\in D*) and has the indicated value (because p0 \\in G).
  It follows by the definition of formula phi' in the definition of
  forcing:

    M[G] |= phi[s]  iff  M |= phi'(p)[s[p<-p0]]

  Moreover, because p0 \\in D* it is clear that this holds if p0 is
  replaced by an arbitrary extension of p0.  Then (*) easily follows.

  By Proposition 5, D* is dense, so there is some p0 in the
  intersection of D* and G.  The forward direction of the conclusion
  then follows by (*).  The reverse direction is clear from (*) by
  application of Proposition 2 to D* and Proposition 4.

  Next, suppose M[G] |= ~phi[x].  Then it is not the case that M[G] |=
  phi, so by the inductive hypothesis, there is no p0 \\in G for which
  M |= (p ||- phi)[s[p<-p0]].  By Proposition 3, there is p0 \\in G
  for which M |= (p ||- ~phi)[s[p<-p0]].  For the other direction,
  suppose it is not the case that M[G] |= ~phi[s].  So M[G] |=
  phi[s], and by the inductive hypothesis, there is p0 \\in G for
  which M |= (p ||- phi)[s[p<-p0]].  It follows that there is no p1
  \\in G for which M |= (p ||- ~phi)[s[p<-p1]], since from such p1 we
  can find a common extension p2 of p0 and p1 (since G is generic),
  and since p2 extends p0 then by Proposition 4, M |= (p ||-
  phi)[s[p<-p2]], contradicting (by definition of forcing) M |= (p
  ||- ~phi)[s[p<-p1]] since p2 extends p1.

  The case (phi_1 & phi_2) follows easily from the inductive
  hypothesis.  For the forward direction, apply Proposition 4 and the
  observation that by genericity, if p0 \\in G and p1 \\in G then p0
  and p1 they have a common extension in G.

  Finally, the case (exists x) phi follows trivially from the inductive
  hypothesis. -|

  Truth Lemma Corollary.  The Truth Lemma holds with ||-w replacing
  ||-.

  Proof.  This is clear by applying the Truth Lemma to ~~phi. -|

  Here is our main theorem.  Recall that all first-order theories in
  our ACL2 context satisfy the e0-induction scheme.

  Theorem.  M[G] satisfies e0-induction.

  Proof.  We consider an arbitrary instance of e0-induction in L[g],
  stated using a strict well-founded relation <| and a formula phi.
  We write phi(y) to indicate that y may be among the free variables
  of phi, and phi(y<-x) to denote the result of substituting x for y
  in phi.

    theta:   (forall y) [((forall x <| y) phi(y<-x)) -> phi(y)]
          -> (forall y) phi(y)

  Our goal is to prove that theta holds in M[G].

  Below, we abuse notation by leaving assignments implicit and by
  writing ``p ||- phi(y0)'' to signify that the formula (p ||-
  phi(y)) is true in M under the extension of the explicit assignment
  that binds y to y0.  We believe that the intended meaning will be
  clear.

  Consider the following set D.

    D = {p \\in P: either p ||-w phi(y0) for all y0,
                  or else
                  for some y0, p ||- ~phi(y0) and
                               for all y1 <| y0 p ||-w phi(y1)}.

  The set D is clearly first-order definable (with parameters) in M.
  We claim that D is a dense subset of P.  For suppose p0 \\in P; we
  find p1 \\in D extending p0, as follows.  If p0 ||-w phi(y0) for all
  y0, then we may take p1 to be p0.  Otherwise, by definition of ||-w
  and ||-, there is some y0 such that for some extension p0' of p0,
  p0' ||- ~phi(y0).  Pick a <|-minimal such y0, and correspondingly
  pick p1 so that p1 extends p0 and p1 ||- ~phi(y0).  In order to
  show that p1 \\in D, it remains to show that for all y1 <| y0, p1
  ||-w phi(y1), i.e., there is no q extending p1 such that q ||-
  ~phi(y1).  This is indeed the case since otherwise q and y1 would
  contradict the <|-minimality of y0.

  Applying the genericity of G and just-proved density of D, pick p0
  \\in G such that p0 \\in D.  If p0 ||-w phi(y0) for all y0, then by
  the Truth Lemma Corollary, M[G] |= phi(y0) for all y0, and thus
  M[G] |= theta.  Otherwise, since p0 \\in D we may choose y0 such
  that p0 ||- ~phi(y0) and for all y1 <| y0, p0 ||-w phi(y1).  By the
  Truth Lemma and its corollary, since p0 \\in G we have:

    (1)   M[G] |= ~phi(y0).
    (2)   For all y1 <| y0, M[G] |= phi(y1).

  It follows that the antecedent of theta is false in M[G], as
  witnessed by y = y0; thus M[G] |= theta. -|

  Remark.  We close by returning, as promised above, to the question of
  why so much care is necessary in constructing an expansion of M.
  We assume familiarity here with the notion of a ``non-standard''
  natural number of M, i.e., one that is greater than the
  interpretation of any term that has the form (+ 1 1 1 ... 1).  Here
  is a very simple example that illustrates the need for some care.
  Consider the following event, which introduces a function foo with
  the following property: for all x, if natp(x) then natp(foo(x)).

    (defchoose foo (y) (x)
      (implies (natp x) (natp y)))

  Certainly we can build a model of the above property from a model M
  of the ground-zero theory, by interpreting foo so that for all x
  for which M satisfies natp(x), foo(x) is also a natp in M.  But
  suppose we start with a non-standard model M of the ground-zero
  theory, and we happen to define foo(x) to be 1 for all non-standard
  natural numbers x and 0 for all other x.  The resulting expansion
  of M will not satisfy the e0-induction scheme or even the ordinary
  natural number induction scheme: foo(0)=0 holds in that expansion
  as does the implication foo(n)=0 => foo(n+1)=0 for every natural
  number n of M, standard or not; and yet foo(k)=0 fails for every
  non-standard natural number k of M.")
 (CONSES
  (PROGRAMMING)
  "A cons is an ordered pair.  In ACL2, data structures like [lists],
  [alists], etc., are made up of conses.


Subtopics

  [Atom]
      Recognizer for atoms

  [Caaaar]
      [car] of the [caaar]

  [Caaadr]
      [car] of the [caadr]

  [Caaar]
      [car] of the [caar]

  [Caadar]
      [car] of the [cadar]

  [Caaddr]
      [car] of the [caddr]

  [Caadr]
      [car] of the [cadr]

  [Caar]
      [car] of the [car]

  [Cadaar]
      [car] of the [cdaar]

  [Cadadr]
      [car] of the [cdadr]

  [Cadar]
      [car] of the [cdar]

  [Caddar]
      [car] of the [cddar]

  [Cadddr]
      [car] of the [cdddr]

  [Caddr]
      [car] of the [cddr]

  [Cadr]
      [car] of the [cdr]

  [Car]
      Returns the first element of a non-empty list, else nil

  [Cdaaar]
      [cdr] of the [caaar]

  [Cdaadr]
      [cdr] of the [caadr]

  [Cdaar]
      [cdr] of the [caar]

  [Cdadar]
      [cdr] of the [cadar]

  [Cdaddr]
      [cdr] of the [caddr]

  [Cdadr]
      [cdr] of the [cadr]

  [Cdar]
      [cdr] of the [car]

  [Cddaar]
      [cdr] of the [cdaar]

  [Cddadr]
      [cdr] of the [cdadr]

  [Cddar]
      [cdr] of the [cdar]

  [Cdddar]
      [cdr] of the [cddar]

  [Cddddr]
      [cdr] of the [cdddr]

  [Cdddr]
      [cdr] of the [cddr]

  [Cddr]
      [cdr] of the [cdr]

  [Cdr]
      Returns the second element of a [cons] pair, else nil

  [Cons]
      Pair and list constructor

  [Cons-count-bounded]
      Count the number of conses (up to a limit)

  [Cons-with-hint]
      Alternative to [cons] that tries to avoid consing when a suitable
      cons structure is provided as a hint.

  [Consp]
      Recognizer for [cons] pairs

  [Listp]
      Recognizer for (not necessarily proper) lists

  [Subst]
      A single substitution into a tree")
 (CONSP
  (CONSES ACL2-BUILT-INS)
  "Recognizer for [cons] pairs

  (consp x) is true if and only if x is a [cons] pair.")
 (CONSTRAINT
  (ENCAPSULATE)
  "Restrictions on certain functions introduced in [encapsulate]
  [events]

  Suppose that a given theorem, thm, is to be functionally instantiated
  using a given functional substitution, alist.  (See
  [lemma-instance], or for an example, see
  [functional-instantiation-example].)  What is the set of proof
  obligations generated?  It is the set obtained by applying alist to
  all terms, tm, such that (a) tm mentions some function symbol in
  the domain of alist, and (b) either (i) tm is the ``constraint''
  (see below) on a function symbol ancestral in thm or in some
  [defaxiom] or (ii) tm is the body of a [defaxiom].  Here, a
  function symbol is ``ancestral'' in thm if either it occurs in thm,
  or it occurs in the definition of some function symbol that occurs
  in thm, and so on.

  The remainder of this note explains what we mean by ``constraint'' in
  the words above.  For a utility that obtains the constraint for a
  given function symbol, see [constraint-info].

  In a certain sense, function symbols are introduced in essentially
  two ways.  The most common way is to use [defun] (or when there is
  mutual recursion, [mutual-recursion] or [defuns]).  There is also a
  mechanism for introducing ``witness functions''; see [defchoose].
  The documentation for these [events] describes the axioms they
  introduce, which we will call here their ``definitional axioms.''
  These definitional axioms are generally the constraints on the
  function symbols that these axioms introduce.

  However, when a function symbol is introduced in the scope of an
  [encapsulate] event, its constraints may differ from the
  definitional axioms introduced for it.  For example, suppose that a
  function's definition is [local] to the [encapsulate]; that is,
  suppose the function is introduced in the [signature] of the
  [encapsulate].  Then its constraints include, at the least, those
  non-[local] theorems and definitions in the [encapsulate] that
  mention the function symbol.

  Actually, it will follow from the discussion below that if the
  [signature] is empty for an [encapsulate], then the constraint on
  each of its new function symbols is exactly the definitional axiom
  introduced for it.  Intuitively, we view such encapsulates just as
  we view [include-book] [events].  But the general case, where the
  [signature] is not empty, is more complicated.

  In the discussion that follows we describe in detail exactly which
  constraints are associated with which function symbols that are
  introduced in the scope of an [encapsulate] event.  In order to
  simplify the exposition we make two cuts at it.  In the first cut
  we present an over-simplified explanation that nevertheless
  captures the main ideas.  In the second cut we complete our
  explanation by explaining how we view certain [events] as being
  ``lifted'' out of the [encapsulate], resulting in a possibly
  smaller [encapsulate], which becomes the target of the algorithm
  described in the first cut.

  At the end of this note we present an example showing why a more
  naive approach is unsound.

  Finally, before we start our ``first cut,'' we note that any
  information you want ``exported'' outside an [encapsulate] event
  must be there as an explicit definition or theorem.  For example,
  even if a function foo has output type (mv t t) in its [signature],
  the system will not know (true-listp (foo x)) merely on account of
  this information.  Thus, if you are using functions like foo
  (constrained [mv] functions), then you may find it useful to prove
  (inside the encapsulate, to be exported) a :[type-prescription]
  rule for the constrained function, for example, the
  :[type-prescription] rule (true-listp (foo x)).

  First cut at constraint-assigning algorithm. Consider the set of
  formulas introduced by all [events] in the scope of an
  [encapsulate]:

    * for every [defthm] and [defaxiom] event, include its formula as well
      as the formulas of all its corollaries;
    * for every [defun] event, include the formula that equates the body
      with the application of the function applied to the formals;
    * for every defchoose event, include the axiom that it adds (see
      [defchoose]);
    * and so on, including axioms added by [defpkg] and (recursively) any
      subsidiary encapsulate events.

  Then quite simply, all such formulas are conjoined, and each function
  symbol introduced by the [encapsulate] is assigned that conjunction
  as its constraint.

  Clearly this is a rather severe algorithm.  Let us consider two
  possible optimizations in an informal manner before presenting our
  second cut.

  Consider the (rather artificial) event below.  The function before1
  does not refer at all, even indirectly, to the locally-introduced
  function sig-fn, so it is unfortunate to saddle it with constraints
  about sig-fn.

    (encapsulate
     (((sig-fn *) => *))

     (defun before1 (x)
       (if (consp x)
           (before1 (cdr x))
         x))

     (local (defun sig-fn (x) (cons x x)))

     (defthm sig-fn-prop
       (consp (sig-fn x)))
     )

  We would like to imagine moving the definition of before1 to just in
  front of this [encapsulate], as follows.

    (defun before1 (x)
      (if (consp x)
          (before1 (cdr x))
        x))

    (encapsulate
     (((sig-fn *) => *))

     (local (defun sig-fn (x) (cons x x)))

     (defthm sig-fn-prop
       (consp (sig-fn x)))
     )

  Thus, we will only assign the constraint (consp (sig-fn x)), from the
  theorem sig-fn-prop, to the function sig-fn, not to the function
  before1.

  More generally, suppose an event in an [encapsulate] event does not
  mention any function symbol in the [signature] of the
  [encapsulate], nor any function symbol that mentions any such
  function symbol, and so on.  (We might say that no function symbol
  from the [signature] is an ``ancestor'' of any function symbol
  occurring in the event.)  Then we imagine moving the event, so that
  it appears in front of the [encapsulate].  We don't actually move
  it, but we pretend we do when it comes time to assign constraints.
  Thus, such definitions only introduce definitional axioms as the
  constraints on the function symbols being defined.  In the example
  above, the event sig-fn-prop introduces no constraints on function
  before1.

  Once this first optimization is performed, we have in mind a set of
  ``constrained functions.'' These are the functions introduced in
  the [encapsulate] that would remain after moving some of them in
  front, as indicated above.  Consider the collection of all formulas
  introduced by the [encapsulate], except the definitional axioms,
  that mention these constrained functions.  So for example, in the
  event below, no such formula mentions the function symbol after1.

    (encapsulate
     (((sig-fn *) => *))

     (local (defun sig-fn (x) (cons x x)))

     (defthm sig-fn-prop
       (consp (sig-fn x)))

     (defun after1 (x)
       (sig-fn x))
     )

  We can see that there is really no harm in imagining that we move the
  definition of after1 out of the [encapsulate], to just after the
  [encapsulate].

  Many subtle aspects of this rearrangement process have been omitted.
  For example, suppose the function fn uses sig-fn, the latter being
  a function in the signature of the encapsulation.  Suppose a
  formula about fn is proved in the encapsulation.  Then from the
  discussion above fn is among the constrained functions of the
  encapsulate: it cannot be moved before the encapsulate and it
  cannot be moved after the encapsulation.  But why is fn
  constrained?  The reason is that the theorem proved about fn may
  impose or express constraints on sig-fn.  That is, the theorem
  proved about fn may depend upon properties of the witness used for
  sig-fn.  Here is a simple example:

    (encapsulate
     (((sig-fn *) => *))

     (local (defun sig-fn (x) (declare (ignore x)) 0))

     (defun fn (lst)
       (if (endp lst)
           t
           (and (integerp (sig-fn (car lst)))
                (fn (cdr lst)))))

     (defthm fn-always-true
       (fn lst)))

  In this example, there are no [defthm] events that mention sig-fn
  explicitly.  One might therefore conclude that it is completely
  unconstrained.  But the witness we chose for it always returns an
  integer.  The function fn uses sig-fn and we prove that fn always
  returns true.  Of course, the proof of this theorem depends upon
  the properties of the witness for sig-fn, even though those
  properties were not explicitly ``called out'' in theorems proved
  about sig-fn.  It would be unsound to move fn-always-true after the
  encapsulate.  It would also be unsound to constrain sig-fn to
  satisfy just fn-always-true without including in the constraint the
  relation between sig-fn and fn.  Hence both sig-fn and fn are
  constrained by this encapsulation and the constraint imposed on
  each is the same and states the relation between the two as
  characterized by the equation defining fn as well as the property
  that fn always returns true.  Suppose, later, one proved a theorem
  about sig-fn and wished to functionally instantiate it.  Then one
  must also functionally instantiate fn, even if it is not involved
  in the theorem, because it is only through fn that sig-fn inherits
  its constrained properties.

  This is a pathological example that illustrate a trap into which one
  may easily fall: rather than identify the key properties of the
  constrained function the user has foreshadowed its intended
  application and constrained those notions.  Clearly, the user
  wishing to introduce the sig-fn above would be well-advised to use
  the following instead:

    (encapsulate
     (((sig-fn *) => *))
     (local (defun sig-fn (x) (declare (ignore x)) 0))
     (defthm integerp-sig-fn
       (integerp (sig-fn x))))

    (defun fn (lst)
      (if (endp lst)
          t
        (and (integerp (sig-fn (car lst)))
             (fn (cdr lst)))))

    (defthm fn-always-true
       (fn lst)))

  Note that sig-fn is constrained merely to be an integer.  It is the
  only constrained function.  Now fn is introduced after the
  encapsulation, as a simple function that uses sig-fn.  We prove
  that fn always returns true, but this fact does not constrain
  sig-fn.  Future uses of sig-fn do not have to consider fn at all.

  Sometimes it is necessary to introduce a function such as fn within
  the encapsulate merely to state the key properties of the undefined
  function sig-fn.  But that is unusual and the user should
  understand that both functions are being constrained.

  Another subtle aspect of encapsulation that has been brushed over so
  far has to do with exactly how functions defined within the
  encapsulation use the signature functions.  For example, above we
  say ``Consider the collection of all formulas introduced by the
  encapsulate, except the definitional axioms, that mention these
  constrained functions.'' We seem to suggest that a definitional
  axiom which mentions a constrained function can be moved out of the
  encapsulation and considered part of the ``post-encapsulation''
  extension of the logical [world], if the defined function is not
  used in any non-definitional formula proved in the encapsulation.
  For example, in the encapsulation above that constrained sig-fn and
  introduced fn within the encapsulation, fn was constrained because
  we proved the formula fn-always-true within the encapsulation.  Had
  we not proved fn-always-true within the encapsulation, fn could
  have been moved after the encapsulation.  But this suggests an
  unsound rule because whether such a function can be moved after the
  encapsulate depend on whether its admission used properties of the
  witnesses!  In particular, we say a function is ``subversive'' if
  any of its governing tests or the actuals in any recursive call
  involve a function in which the signature functions are ancestral.
  See [infected-constraints] and see [subversive-recursions].

  (Aside: The definition of fn in the first encapsulation above that
  defines fn, i.e., the encapsulation with fn-always-true inside, is
  subversive because the call of the macro [and] expands to a call of
  IF that governs a recursive call of fn, in this case:

    (defun fn (lst)
      (if (endp lst)
          t
          (if (integerp (sig-fn (car lst)))
              (fn (cdr lst))
            nil))).

  If we switch the order of conjuncts in fn, then the definition of fn
  is no longer subversive, but it still ``infects'' the constraint
  generated for the encapsulation, hence for sig-fn, because
  fn-always-true blocks the definition of fn from being moved back
  (to after the encapsulation).  Also see [infected-constraints].  If
  we both switch the order of conjuncts and drop fn-always-true from
  the encapsulation, then the definition of fn is in essence moved
  back to after the encapsulation, and the constraint for sig-fn no
  longer includes the definition of fn.  End of aside.)

  Another aspect we have not discussed is what happens to nested
  encapsulations when each introduces constrained functions.  We say
  an encapsulate event is ``trivial'' if it introduces no constrained
  functions, i.e., if its signatures is nil.  Trivial encapsulations
  are just a way to wrap up a collection of events into a single
  event.

  From the foregoing discussion we see we are interested in exactly how
  we can ``rearrange'' the events in a non-trivial encapsulation ---
  moving some ``before'' the encapsulation and others ``after'' the
  encapsulation.  We are also interested in which functions
  introduced by the encapsulation are ``constrained'' and what the
  ``constraints'' on each are.  We may summarize the observations
  above as follows, after which we conclude with a more elaborate
  example.

  Second cut at constraint-assigning algorithm. First, we focus only on
  non-trivial encapsulations that neither contain nor are contained
  in non-trivial encapsulations.  (Nested non-trivial encapsulations
  are not rearranged at all: do not put anything in such a nest
  unless you mean for it to become part of the constraints
  generated.)  Second, in what follows we only consider the non-local
  events of such an encapsulate, assuming that they satisfy the
  restriction of using no locally defined function symbols other than
  the signature functions.  Given such an encapsulate event, move, to
  just in front of it and in the same order, all definitions and
  theorems for which none of the signature functions is ancestral.
  Now collect up all formulas (theorems) introduced in the
  [encapsulate] other than definitional axioms.  Add to this set any
  of those definitional equations that is either subversive or
  defines a function used in a formula in the set.  The conjunction
  of the resulting set of formulas is called the ``constraint'' and
  the set of all the signature functions of the encapsulate together
  with all function symbols defined in the encapsulate and mentioned
  in the constraint is called the ``constrained functions.'' Assign
  the constraint to each of the constrained functions.  Move, to just
  after the encapsulate, the definitions of all function symbols
  defined in the encapsulate that have been omitted from the
  constraint.

  Implementation note.  In the implementation we do not actually move
  [events], but we create constraints that pretend that we did.

  Here is an example illustrating our constraint-assigning algorithm.
  It builds on the preceding examples.

    (encapsulate
     (((sig-fn *) => *))

     (defun before1 (x)
       (if (consp x)
           (before1 (cdr x))
         x))

     (local (defun sig-fn (x) (cons x x)))

     (defthm sig-fn-prop
       (consp (sig-fn x)))

     (defun during (x)
       (if (consp x)
           x
         (cons (car (sig-fn x))
               17)))

     (defun before2 (x)
       (before1 x))

     (defthm before2-prop
       (atom (before2 x)))

     (defthm during-prop
       (implies (and (atom x)
                     (before2 x))
                (equal (car (during x))
                       (car (sig-fn x)))))

     (defun after1 (x)
       (sig-fn x))

     (defchoose after2 (x) (u)
       (and (< u x) (during x)))
     )

  Only the functions sig-fn and during receive extra constraints.  The
  functions before1 and before2 are viewed as moving in front of the
  [encapsulate], as is the theorem before2-prop.  The functions
  after1 and after2 are viewed as being moved past the [encapsulate].
  The implementation reports the following.

    In addition to SIG-FN, we export AFTER2, AFTER1, BEFORE2, DURING and
    BEFORE1.

    The following constraint is associated with both of the functions DURING and
    SIG-FN:

    (AND (EQUAL (DURING X)
                (IF (CONSP X)
                    X (CONS (CAR (SIG-FN X)) 17)))
         (CONSP (SIG-FN X))
         (IMPLIES (AND (ATOM X) (BEFORE2 X))
                  (EQUAL (CAR (DURING X))
                         (CAR (SIG-FN X)))))

  Notice that the formula (consp (during x)) is not a conjunct of the
  constraint.  During the first pass of the encapsulate, this formula
  is stored as a :[type-prescription] rule deduced during the
  definition of the function during.  However, the rule is not
  exported because of a rather subtle soundness issue.  (If you are
  interested in details, see the comments in source function
  putprop-type-prescription-lst.)

  We conclude by asking (and to a certain extent, answering) the
  following question: Isn't there an approach to assigning
  constraints that avoids over-constraining more simply than our
  ``second cut'' above?  Perhaps it seems that given an
  [encapsulate], we should simply assign to each locally defined
  function the theorems exported about that function.  If we adopted
  that simple approach the events below would be admissible.

    (encapsulate
     (((foo *) => *))
     (local (defun foo (x) x))
     (defun bar (x)
       (foo x))
     (defthm bar-prop
       (equal (bar x) x)
       :rule-classes nil))

    (defthm foo-id
      (equal (foo x) x)
      :hints ((\"Goal\" :use bar-prop)))

    ; The following event is not admissible in ACL2.

    (defthm ouch!
      nil
      :rule-classes nil
      :hints
      ((\"Goal\" :use
        ((:functional-instance foo-id
                               (foo (lambda (x) (cons x x))))))))

  Under the simple approach we have in mind, bar is constrained to
  satisfy both its definition and bar-prop because bar mentions a
  function declared in the signature list of the encapsulation.  In
  fact, bar is so-constrained in the ACL2 semantics of encapsulation
  and the first two events above (the encapsulate and the consequence
  that foo must be the identity function) are actually admissible.
  But under the simple approach to assigning constraints, foo is
  unconstrained because no theorem about it is exported.  Under that
  approach, ouch! is provable because foo can be instantiated in
  foo-id to a function other than the identity function.

  It's tempting to think we can fix this by including definitions, not
  just theorems, in constraints.  But consider the following slightly
  more elaborate example.  The problem is that we need to include as
  a constraint on foo not only the definition of bar, which mentions
  foo explicitly, but also abc, which has foo as an ancestor.

    (encapsulate
     (((foo *) => *))
     (local (defun foo (x) x))
     (local (defthm foo-prop
              (equal (foo x) x)))
     (defun bar (x)
       (foo x))
     (defun abc (x)
       (bar x))
     (defthm abc-prop
       (equal (abc x) x)
       :rule-classes nil))

    (defthm foo-id
      (equal (foo x) x)
      :hints ((\"Goal\" :use abc-prop)))

    ; The following event is not admissible in ACL2.

    (defthm ouch!
      nil
      :rule-classes nil
      :hints
      ((\"Goal\" :use
        ((:functional-instance foo-id
                               (foo (lambda (x) (cons x x)))
                               (bar (lambda (x) (cons x x))))))))


Subtopics

  [Constraint-info]
      Obtaining the [constraint] on a function symbol")
 (CONSTRAINT-INFO
  (SYSTEM-UTILITIES CONSTRAINT)
  "Obtaining the [constraint] on a function symbol

  For a function symbol, fn, and a logical [world], wrld --- for
  example, the current world, (w state) --- evaluation of the form
  (constraint-info fn wrld) returns (mv flg c), where c is the list
  of [constraint]s on fn (implicitly conjoined), and flg is nil if fn
  is a defined function and otherwise is a function symbol with that
  same list of constraints (possibly fn itself).  See [constraint]
  for relevant background.

  We illustrate with the following example.

    (encapsulate
      (((f1 *) => *)
       ((f3 *) => *))
      (local (defun f1 (x) x))
      (defun f2 (x) (f1 x))
      (local (defun f3 (x) x))
      (defun f4 (x) (f3 x))
      (defthm f1-prop (equal (f1 x) (f4 x))))

  Then we can see the results of constraint-info on each introduced
  function symbol, as follows.

    ACL2 !>(let ((wrld (w state)))
              (list
               'result
               'f1 (mv-let (flg1 c1) (constraint-info 'f1 wrld) (list flg1 c1))
               'f2 (mv-let (flg2 c2) (constraint-info 'f2 wrld) (list flg2 c2))
               'f3 (mv-let (flg3 c3) (constraint-info 'f3 wrld) (list flg3 c3))
               'f4 (mv-let (flg4 c4) (constraint-info 'f4 wrld) (list flg4 c4))))
    (RESULT F1
            (F1 ((EQUAL (F4 X) (F3 X))
                 (EQUAL (F1 X) (F4 X))))
            F2 (NIL (EQUAL (F2 X) (F1 X)))
            F3
            (F1 ((EQUAL (F4 X) (F3 X))
                 (EQUAL (F1 X) (F4 X))))
            F4
            (F1 ((EQUAL (F4 X) (F3 X))
                 (EQUAL (F1 X) (F4 X)))))
    ACL2 !>

  Notice that the flag (first result) for f2 is nil, because even
  though the definition of f2 is lexically inside the encapsulate, it
  doesn't affect the constraints because it can be safely moved to
  just after the encapsulate.  However, the definition of f4 does
  affect (or ``infect''; see [subversive-recursions]) the
  constraints: it can't be moved to after the encapsulate because of
  the defthm after it.

  Also see [constraint].  For more details, see comments in the
  definition of constraint-info in the ACL2 source code.")
 (CONTEXT (POINTERS) "See [ctx].")
 (CONTEXT-MESSAGE-PAIR
  (KESTREL-UTILITIES SYSTEM-UTILITIES-NON-BUILT-IN)
  "A common ACL2 programming idiom: [error-triple]s without [state]

  Context-message pairs are of the form (mv erp val), where there are
  the following two cases: the first indicates a successful
  computation and the second indicates an error.

    * Normal case: erp is nil and val is what we call the ``value'' of that
      context-message pair.
    * Error case: erp is not nil.  Val may be nil; otherwise val is a
      message (see [msgp]) suitable for printing with [fmt] and
      related functions using the ~@ directive, and erp is a context
      suitable for error messages (see [ctx]).  A convention
      generally observed (for example, by ACL2 system function
      cmp-to-error-triple, which converts a context-message pair to
      an [error-triple] that may be printed in the error case) is
      when erp and val are both non-nil, then erp is not t.

  To see how this works let us consider the ACL2 source function,
  translate-cmp, whose input is a user-level (``untranslated'') term
  as input and returns a context-message pair.  In the non-error
  case, the value returned is the internal (``translated'') form of
  that input; see [term].  The log below first shows a successful
  translation, returning multiple values (mv nil (binary-+ x '3)),
  thus illustrating the ``Normal case'' above, where the first value
  returned (the error indicator) is nil and the second is the value
  of the pair.  The second example in the log shows an error case
  returning a context and a message.  Don't worry about the various
  arguments of translate-cmp; the examples are merely to illustrate
  programming with context-message pairs, not to explain
  translate-cmp!

    ACL2 !>(translate-cmp '(+ x 3)
                          t t t 'top (w state)
                          (default-state-vars state))
    (NIL (BINARY-+ X '3))
    ACL2 !>(translate-cmp '(quote 3 4)
                          t t t 'top (w state)
                          (default-state-vars state))
    (TOP (\"The proper form of a quoted constant is (quote x), but ~
                         ~x0 is not of this form.\"
              (#0 QUOTE 3 4)))
    ACL2 !>

  The following macros are useful when programming with context-message
  pairs.

    * (value-cmp x): same as (mv nil x).  Example:

          ACL2 !>(value-cmp (* 3 4))
          (NIL 12)
          ACL2 !>

    * (er-cmp ctx str &rest args): Return (mv ctx msg) where msg is formed
      from str and args.  Example:

          ACL2 !>(er-cmp 'example
                         \"I don't like 3-element lists like ~x0.~|\"
                         (make-list 3))
          (EXAMPLE (\"I don't like 3-element lists like ~x0.~|\" (#0 NIL NIL NIL)))
          ACL2 !>(mv-let (ctx msg)
                   (er-cmp 'example
                           \"I don't like 3-element lists like ~x0.~|\"
                           (make-list 3))
                   (fmx \"Error in ~x0: ~@1\" ctx msg))
          Error in EXAMPLE: I don't like 3-element lists like (NIL NIL NIL).
          (0 <state>)
          ACL2 !>

    * (er-let*-cmp alist body): Analogue of [er-let*] for context-message
      pairs.  So, it evaluates the bindings in alist much as
      [let*]-bindings would be evaluated, but where each expression
      should return a context-message pair and so should body.  If
      any of those expression evaluations returns a pair with a
      non-nil first value, then that pair is returned.  Otherwise,
      body --- which should return a context-message pair --- is
      evaluated with respect to the resulting bindings.  Examples
      (refer to previous examples that use translate-cmp):

          ACL2 !>(er-let*-cmp ((x (value-cmp '(+ x 3)))
                               (val (translate-cmp x
                                                   t t t 'top (w state)
                                                   (default-state-vars state)))
                               (y (value-cmp (list :term val))))
                              (value-cmp (list :result y)))
          (NIL (:RESULT (:TERM (BINARY-+ X '3))))
          ACL2 !>(er-let*-cmp ((x (value-cmp '(quote 3 4)))
                               (val (translate-cmp x
                                                   t t t 'top (w state)
                                                   (default-state-vars state)))
                               (y (value-cmp (list :term val))))
                              (value-cmp (list :result y)))
          (TOP (\"The proper form of a quoted constant is (quote x), but ~
                               ~x0 is not of this form.\"
                    (#0 QUOTE 3 4)))
          ACL2 !>

    * (er-progn-cmp form1 ... formk): Each formi should evaluate to a
      context-message pair.  If any of these evaluations produces a
      pair with a non-nil first component (thus indicating an error),
      return that pair.  Otherwise return the context-message pair
      produced by evaluating formk.  Examples:

          ACL2 !>(er-progn-cmp (value-cmp (+ 2 8))
                               (er-cmp 'top \"Ouch\")
                               (value-cmp (* 3 4)))
          (TOP (\"Ouch\"))
          ACL2 !>(er-progn-cmp (value-cmp (+ 2 8))
                               (value-cmp (* 3 4)))
          (NIL 12)
          ACL2 !>")
 (CONVERSION
  (PAGES_WRITTEN_ESPECIALLY_FOR_THE_TOURS)
  "Conversion to Uppercase

  When symbols are read by Common Lisp they are converted to upper
  case.  Note carefully that this remark applies to the characters in
  symbols.  The characters in strings are not converted upper case.

  To type a symbol containing lower case characters you can enclose the
  symbol in vertical bars, as in |AbC| or you can put a ``backslash''
  before each lower case character you wish to preserve, as in A\\bC.
  |AbC| and A\\bC are two different ways of writing the same symbol
  (just like 2/4 and 1/2 are two different ways of writing the same
  rational and 123 and 0123 are two different ways to write the same
  natural number).  The symbol has three characters in its name, the
  middle one of which is a lower case b.")
 (COPYRIGHT
  (ABOUT-ACL2)
  "ACL2 copyright, license, sponsorship

  This topic provides information about copyright, license, authorship,
  and sponsorship of the ACL2 system.  For information about
  copyright and authorship of [documentation], see
  [documentation-copyright], which notes that there are many
  documentation authors.

  ACL2 Version 8.5 --- A Computational Logic for Applicative Common
  Lisp

  Copyright (C) 2022, Regents of the University of Texas

  This version of ACL2 is a descendant of ACL2 Version 1.9, Copyright
  (C) 1997 Computational Logic, Inc.  See the documentation topic
  NOTE-2-0.

  This program is free software; you can redistribute it and/or modify
  it under the terms of the LICENSE file distributed with ACL2.

  This program is distributed in the hope that it will be useful, but
  WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  LICENSE for more details.

  Written by: Matt Kaufmann and J Strother Moore
  email: Kaufmann@cs.utexas.edu and Moore@cs.utexas.edu
  Department of Computer Science
  University of Texas at Austin
  Austin, TX 78712 U.S.A.

  Please also see [acknowledgments].


Subtopics

  [Documentation-copyright]
      Copyright and authorship of documentation")
 (COROLLARY
  (RULE-CLASSES)
  "The corollary formula of a [rune]

  See [formula].  This is a low-level system function at the present
  time.  See [pr] and see [pr!] instead.  Also see [rule-classes] for
  the use of the symbol :corollary in specifying a rule class.")
 (CORROBORATING_MODELS
  (PAGES_WRITTEN_ESPECIALLY_FOR_THE_TOURS)
  "Corroborating Models

  {IMAGE} (see [Models_of_Computer_Hardware_and_Software])

  After producing a model, it must be corroborated against reality.
  The Falling Body Model has been corroborated by a vast number of
  experiments in which the time and distance were measured and
  compared according to the formula.  In general all models must be
  corroborated by experiment.

  The Falling Body Model can be derived from deeper models, namely
  Newton's laws of motion and the assertion that, over the limited
  distances concerned, gravitation exerts a constant acceleration on
  the object.  When the model in question can be derived from other
  models, it is the other models that are being corroborated by our
  experiments.

  Because nature is not formal, we cannot prove that our models of it
  are correct.  All we can do is test our models against nature's
  behavior.

  Such testing often exposes restrictions on the applicability of our
  models.  For example, the Falling Body Model is inaccurate if air
  resistance is significant.  Thus, we learn not to use that model to
  predict how long it takes a feather to fall from a 200 foot tower
  in the earth's atmosphere.

  In addition, attempts at corroboration might reveal that the model is
  actually incorrect.  Careful measurements might expose the fact
  that the gravitational force increases as the body falls closer to
  earth.  Very careful measurements might reveal relativistic
  effects.  Technically, the familiar Falling Body Model is just
  wrong, even under excessive restrictions such as ``in a perfect
  vacuum'' and ``over small distances.'' But it is an incredibly
  useful model nonetheless.

  There are several morals here.

  Models need not be complete to be useful.

  Models need not be perfectly accurate to be useful.

  The user of a model must understand its limitations.

  {IMAGE} (see [Models_of_Computer_Hardware_and_Software])")
 (COUNT
  (LISTS STRINGS ACL2-BUILT-INS)
  "Count the number of occurrences of an item in a string or true-list

    Example Forms:
    (count #\\D \"DabcDefcDe\")                 ; = 3
    (count #\\D \"DabcDefcDe\" :start 1)        ; = 2
    (count #\\D \"DabcDefcDe\" :start 1 :end 5) ; = 1
    (count #\\D \"DabcDefcDe\" :start 1 :end 4) ; = 0
    (count #\\z \"DabcDefcDe\")                 ; = 0
    (count '(a b) '(17 (a b) 23 (a b) (c d)))   ; = 2

    General Form:
    (count item sequence &key start end)

  (Count item sequence) returns the number of times item occurs in
  sequence.  The [guard] for calls of count (which is actually a
  macro in ACL2) specifies that sequence is a string or a true-list,
  and that start, which defaults to 0, and end, which defaults to the
  length of sequence, are valid indices into sequence.

  See any Common Lisp documentation for more information about count,
  which is a Common Lisp utility.  At this time ACL2 does not support
  keyword arguments for count other than :start and :end; we may add
  support for the :from-end keyword upon request.

  Macro: <count>

    (defmacro count
              (item sequence &key (start '0) end)
              (cons 'count-fn
                    (cons item
                          (cons sequence
                                (cons start (cons end 'nil))))))")
 (COUNT-KEYS
  (STOBJ ACL2-BUILT-INS)
  "Count the number of keys in association list

  (Count-keys al) returns the number of distinct keys in an association
  list.

  Count-keys has a guard of t.  This function is called in the body of
  function, <h>-count where <h> is a hash-table field of a [stobj].
  See [defstobj].

  Function: <hons-remove-assoc>

    (defun hons-remove-assoc (k x)
           (declare (xargs :guard t))
           (if (atom x)
               nil
               (if (and (consp (car x))
                        (not (equal k (caar x))))
                   (cons (car x)
                         (hons-remove-assoc k (cdr x)))
                   (hons-remove-assoc k (cdr x)))))

  Function: <count-keys>

    (defun
         count-keys (al)
         (declare (xargs :guard t))
         (if (atom al)
             0
             (if (consp (car al))
                 (+ 1
                    (count-keys (hons-remove-assoc (caar al) (cdr al))))
                 (count-keys (cdr al)))))")
 (CPU-CORE-COUNT
  (PARALLELISM ACL2-BUILT-INS)
  "The number of cpu cores

  This [documentation] topic relates to the experimental extension of
  ACL2 supporting parallel execution and proof; see [parallelism].

  Unless the ACL2 executable supports parallel execution (see
  [parallelism]), this function returns (mv 1 state).  Otherwise:

  (Cpu-core-count state) returns (mv core-count state), where
  core-count is determined as follows.  If environment variable
  ACL2_CORE_COUNT has a non-empty value, then that value should
  represent a positive integer (else an error occurs), which is the
  returned core-count.  Otherwise, the returned core-count may be
  obtained from the underlying Common Lisp implementation, else as a
  positive integer value from [state] global variable 'cpu-core-count
  (see [assign]).  Otherwise an error occurs.

    Example:
    (cpu-core-count state) ==> (mv 4 state)

  Cpu-core-count has the following logical definition.

  Function: <cpu-core-count>

    (defun cpu-core-count (state)
           (declare (xargs :stobjs state :guard t))
           (mv-let (nullp val state)
                   (read-acl2-oracle state)
                   (declare (ignore nullp))
                   (mv val state)))")
 (CTX
  (ERRORS)
  "Context object for error messages

  Calls of [er], such as (er soft ctx ...), take a context argument,
  typically called ctx, for the initial part of the message: \"ACL2
  Error in\".  If ctx is nil, only \"ACL2 Error:\" is printed for that
  initial part of the message.  Otherwise, the string printed after
  \"in\" depends on the form of that context, as follows.  (See [ctxp]
  for the definition of a valid context.)

    * If ctx is a symbol, print it with [fmt] using \"~x\".
    * If ctx is a pair whose car is a symbol, use [fmt] to print \"(~x0 ~x1
      ...)\", with #\\0 and #\\1 bound respectively to the car and cdr
      of ctx.  Exception: if the car is a member of the value of
      constant *fmt-ctx-spacers*, then a space is printed after the
      left parenthesis.  That explains why there is a space, for
      example, in \"( DEFUN\" in error messages starting with:

          ACL2 Error in ( DEFUN FOO ...):

    * Otherwise, print ctx with fmt using \"~@\".")
 (CTXP
  (ERRORS)
  "Recognizer for context objects for error messages

  See [ctx] for relevant background.  The function ctxp returns t when
  ctx is a valid context according to the definition below (also see
  [msgp]), else nil.

  Function: <ctxp>

    (defun ctxp (x)
           (declare (xargs :guard t))
           (or (symbolp x)
               (and (consp x) (symbolp (car x)))
               (msgp x)))")
 (CURRENT-PACKAGE
  (LD)
  "The package used for reading and printing

  Current-package is an [ld] special (see [ld]).  The accessor is
  (current-package state) and the updater is (set-current-package val
  state), or more conventionally, (in-package val).  The value of
  current-package is actually the string that names the package.
  (Common Lisp's ``package'' objects do not exist in ACL2.)  The
  current package must be known to ACL2, i.e., it must be one of the
  initial packages or a package defined with [defpkg] by the user.

  When printing symbols, the package prefix is displayed if it is not
  the current-package and may be optionally displayed otherwise.
  Thus, if current-package is \"ACL2\" then the symbol 'ACL2::SYMB may
  be printed as SYMB or ACL2::SYMB, while 'MY-PKG::SYMB must be
  printed as MY-PKG::SYMB.  But if current-package is \"MY-PKG\" then
  the former symbol must be printed as ACL2::SYMB while the latter
  may be printed as SYMB.

  In Common Lisp, current-package also affects how objects are read
  from character streams.  Roughly speaking, read and print are
  inverses if the current-package is fixed, so reading from a stream
  produced by printing an object must produce an equal object.

  In ACL2, the situation is more complicated because we never read
  objects from character streams, we only read them from object
  ``streams'' (channels).  Logically speaking, the objects in such a
  channel are fixed regardless of the setting of current-package.
  However, our host file systems do not support the idea of Lisp
  object files and instead only support character files.  So when you
  open an object input channel to a given (character file) we must
  somehow convert it to a list of ACL2 objects.  This is done by a
  deus ex machina (``a person or thing that appears or is introduced
  suddenly and unexpectedly and provides a contrived solution to an
  apparently insoluble difficulty,'' Webster's Ninth New Collegiate
  Dictionary).  Roughly speaking, the deus ex machina determines what
  sequence of calls to read-object will occur in the future and what
  the current-package will be during each of those calls, and then
  produces a channel containing the sequence of objects produced by
  an analogous sequence of Common Lisp reads with *current-package*
  bound appropriately for each.

  A simple rule suffices to make sane file [io] possible: before you
  read an object from an object channel to a file created by printing
  to a character channel, make sure the current-package at read-time
  is the same as it was at print-time.")
 (CURRENT-THEORY
  (THEORIES THEORY-FUNCTIONS)
  "Currently [enable]d rules as of logical name

    Examples:
    (current-theory :here)
    (current-theory 'lemma3)

  See [logical-name].

    General Form:
    (current-theory logical-name)

  Returns the current theory as it existed immediately after the
  introduction of [logical-name] provided it is evaluated in an
  environment in which the variable symbol WORLD is bound to the
  current ACL2 logical world, (w state).  Thus,

    ACL2 !>(current-theory :here)

  will cause an (unbound variable) error while

    ACL2 !>(let ((world (w state))) (current-theory :here))

  will return the current theory in world.

  See [theories] and see [logical-name] for a discussion of theories in
  general and why the commonly used ``theory functions'' such as
  current-theory are really macros that expand into terms involving
  the variable world.

  The theory returned by current-theory is in fact the theory selected
  by the [in-theory] event most recently preceding logical name,
  extended by the rules introduced up through [logical-name].

  You may experience a fencepost problem in deciding which logical name
  to use.  [Deflabel] can always be used to mark unambiguously for
  future reference a particular point in the development of your
  theory.  The order of [events] in the vicinity of an [encapsulate]
  is confusing.  See [encapsulate].

  This ``function'' is actually a macro that expands to a term
  mentioning the single free variable [world].  When theory
  expressions are evaluated by [in-theory] or the :[in-theory] hint,
  [world] is bound to the current ACL2 [world].")
 (CUSTOM-KEYWORD-HINTS
  (HINTS)
  "User-defined hints

  See [add-custom-keyword-hint] for a discussion of how advanced users
  can define their own hint keywords.  For examples, see the
  community books directory books/hints/, in particular
  basic-tests.lisp.


Subtopics

  [Show-custom-keyword-hint-expansion]
      Print out custom keyword hints when they are expanded")
 (CW
  (IO ACL2-BUILT-INS)
  "Print to the comment window

  Cw is a macro that expands to a function whose guard is t.  For a
  guarded variant of cw, see [fmx-cw].  For variants of cw that
  provide readable output (suffix \"!\") and are never inhibited
  (suffix \"+\"), see [cw!], [cw+], and [cw!+].  For corresponding
  functions see [fmt-to-comment-window], [fmt-to-comment-window!],
  [fmt-to-comment-window+], and [fmt-to-comment-window!+].

  Example:

    (cw \"The goal is ~x0 and the alist is ~x1.~%\"
        (untranslate term t nil)
        unify-subst)

  Logically, this expression is equivalent to nil.  However, it has the
  effect of first printing to the so-called ``comment window'' the
  [fmt] string as indicated.  Thus, cw is like fmt (see [fmt]) except
  in four important ways.  First, it is a macro whose calls expand to
  calls of a :[logic] mode function.  Second, it neither takes nor
  returns the ACL2 [state]; logically cw simply returns nil, although
  it prints to a comment window that just happens to share the
  terminal screen with the standard character output [*standard-co*].
  Third, its fmt args are positional references, so that for example

    (cw \"Answers: ~x0 and ~x1\" ans1 ans2)

  prints in the same manner as:

    (fmt \"Answers: ~x0 and ~x1\"
         (list (cons #\\0 ans1) (cons #\\1 ans2))
         *standard-co* state nil)

  And finally, output from cw is suppressed if the COMMENT type of
  output is suppressed; see [set-inhibit-output-lst].

  Typically, calls of cw are embedded in [prog2$] forms, e.g.,

    (prog2$ (cw ...)
            (mv a b c))

  which has the side-effect of printing to the comment window and
  logically returning (mv a b c).

    General Form:
    (cw fmt-string arg1 arg2 ... argn)

  where n is between 0 and 9 (inclusive).  The macro uses
  [fmt-to-comment-window], passing it the column 0 and [evisc-tuple]
  nil, after assembling the appropriate alist binding the [fmt] vars
  #\\0 through #\\9; see [fmt].  If you want

    (a) more than 10 vars,
    (b) vars other than the digit chars,
    (c) a different column, or
    (d) a different evisc-tuple,

  then call [fmt-to-comment-window] instead.

  Finally, we discuss another way to create formatted output that also
  avoids the need to pass in the ACL2 [state].  The idea is to use
  wormholes; see [wormhole].  Below is a function you can write,
  along with some calls, providing an illustration of this approach.

    (defun my-fmt-to-comment-window (str alist)
      (wormhole 'my-fmt-to-comment-window
                '(lambda (whs) whs)
                (list str alist)
                '(pprogn
                  (fms (car (@ wormhole-input))
                       (cadr (@ wormhole-input))
                       *standard-co*
                       state
                       nil)
                  (value :q))
                :ld-verbose nil
                :ld-error-action :return ; harmless return on error
                :ld-prompt nil))

    ; A non-erroneous call:
    (my-fmt-to-comment-window \"Here is ~x0 for your inspection~%\"
                              (list (cons #\\0 'foo)))

    ; An error inside the fmt string (unbound fmt var); note that even
    ; with the error, the wormhole is exited.
    (my-fmt-to-comment-window \"Here is ~x1 for your inspection~%\"
                              (list (cons #\\0 'foo)))

    ; A guard violation in the binding; note that even with the error,
    ; the wormhole is exited.
    (my-fmt-to-comment-window \"Here is ~x0 for your inspection~%\"
                              (list (cons #\\0 (car 'foo))))


Subtopics

  [Cw!]
      Print readably to the comment window

  [Cw!+]
      Print readably and uninhibited to the comment window

  [Cw+]
      Print uninhibited to the comment window

  [Fmt-to-comment-window]
      Print to the comment window

  [Fmt-to-comment-window!]
      Print readably to the comment window

  [Fmt-to-comment-window!+]
      Print readably and uninhibited to the comment window

  [Fmt-to-comment-window+]
      Print uninhibited to the comment window")
 (CW!
  (CW IO ACL2-BUILT-INS)
  "Print readably to the comment window

  See [cw] for important background.

  This is nearly the same as [cw], but cw! avoids inserting backslash
  (\\) characters when forced to print past the right margin.  Use cw!
  if you want to be able to read the forms back in.")
 (CW!+
  (CW IO ACL2-BUILT-INS)
  "Print readably and uninhibited to the comment window

  See [cw] for important background.

  This is nearly the same as [cw], but cw+ always produces readable
  output (like [cw!]), even when the COMMENT output type is inhibited
  (like [cw+]).")
 (CW+
  (CW IO ACL2-BUILT-INS)
  "Print uninhibited to the comment window

  See [cw] for important background.

  This is nearly the same as [cw], but cw+ always produces output, even
  when the COMMENT output type is inhibited (see
  [set-inhibit-output-lst]).")
 (CW-GSTACK
  (BREAK-REWRITE DEBUGGING)
  "Debug a rewriting loop or stack overflow

  After [break-rewrite] is enabled (with :[brr] t), cw-gstack can be
  invoked to show a stack backtrace when a proof is interrupted
  (because of control-c or because of a loop).

    Example Forms:
    (cw-gstack)
    (cw-gstack :frames 10)       ; show only the top 10 frames
    (cw-gstack :frames '(1 10))  ; same as above:  show only frames 1 through 10
    (cw-gstack :frames '(10 20)) ; show only frames 10 through 20
    (cw-gstack :evisc-tuple (evisc-tuple 3 4 nil nil))
                                 ; print with print-level 3 and print-length 4
    (cw-gstack :evisc-tuple nil) ; print using default ``evisceration'',
                                 ;   essentially the same as just above
    (cw-gstack :evisc-tuple '(nil 3 4 (hide)))
                                 ; same as just above

    General Form:
    (cw-gstack :frames frames :evisc-tuple evisc-tuple)

  where :frames and :evisc-tuple are optional, but if they are
  supplied, their values are evaluated.  The value of frames should
  be either a natural number or a list of two natural numbers, the
  first less than the second; and the value of evisc-tuple should be
  an evisc-tuple (see [evisc-tuple]).  If :evisc-tuple is omitted,
  then by default, substructures deeper than 3 are replaced by ``#''
  and those longer than 4 are replaced by ``...'', and terms of the
  form (hide ...) are printed as <hidden>; this behavior can be
  changed by setting the :TERM [evisc-tuple] (see [set-evisc-tuple]).
  Also see [set-iprint] for an alternative to printing ``#'' and
  ``...''.

  Stack overflows may occur, perhaps caused by looping rewrite rules.
  In some Lisps, stack overflows may manifest themselves as
  segmentation faults, causing the entire ACL2 image to crash.
  Finding looping rewrite rules can be tricky, especially if you are
  using books supplied by other people.  (However, see
  [set-rewrite-stack-limit] for a way to avoid stack overflows caused
  by rewriter loops.)

  Normally, a stack overflow will cause the printing of an error
  message that suggests how to proceed.  Just follow those
  instructions, and you will generally be able to see what is causing
  the loop.

  Suggestion: Once you have found the loop and fixed it, you should
  execute the ACL2 command :[brr] nil, so that you don't slow down
  subsequent proof attempts.")
 (CW-PRINT-BASE-RADIX
  (IO ACL2-BUILT-INS)
  "Print to the comment window in a given print-base

  See [cw] for relevant background.  This variant of cw requires
  specification of a print-base and, optionally, a print-radix (see
  [set-print-base], [set-print-radix], and [set-print-base-radix]).

  The following examples show that cw-print-base-radix is just like
  [cw], except that there is a new argument in the first position
  that specifies the print-base and can, for that print-base,
  override the default print-radix.

    ACL2 !>(cw-print-base-radix 16 \"~x0~%\" '(3 12 16 17))
    (#x3 #xC #x10 #x11)
    NIL
    ACL2 !>(cw-print-base-radix '(16 . t) \"~x0~%\" '(3 12 16 17))
    (#x3 #xC #x10 #x11)
    NIL
    ACL2 !>(cw-print-base-radix '(16 . nil) \"~x0~%\" '(3 12 16 17))
    (3 C 10 11)
    NIL
    ACL2 !>(cw-print-base-radix 10 \"~x0~%\" '(3 12 16 17))
    (3 12 16 17)
    NIL
    ACL2 !>(cw-print-base-radix '(10 . t) \"~x0~%\" '(3 12 16 17))
    (3. 12. 16. 17.)
    NIL
    ACL2 !>(cw-print-base-radix '(10 . nil) \"~x0~%\" '(3 12 16 17))
    (3 12 16 17)
    NIL
    ACL2 !>

    @({
    General Forms:

    (cw-print-base-radix print-base fmt-string arg1 arg2 ... argn)
    (cw-print-base-radix print-base/print-radix fmt-string arg1 arg2 ... argn)

  where all arguments of this macro are evaluated; print-base is a
  legal print-base as recognized by [print-base-p];
  print-base/print-radix is a cons whose car is a legal print-base;
  fmt-string is a string suitable for passing to [fmt]; and arg1
  through argn (where n is at most 9) are corresponding arguments for
  fmt-string.  Printing is done according to the specified
  print-base, which is the first argument in the first general form
  and is the car of the first argument in the second general form.
  The print-radix value that is used for printing in the first
  general form is the print-radix as specified for
  [set-print-base-radix], while in the second general form, it is the
  cdr.")
 (CW-PRINT-BASE-RADIX!
  (IO ACL2-BUILT-INS)
  "Print to the comment window in a given print-base

  This is nearly the same as [cw-print-base-radix], but
  cw-print-base-radix! avoids inserting backslash (\\) characters when
  forced to print past the right margin.  Use cw-print-base-radix! if
  you want to be able to read the forms back in.")
 (D< (POINTERS) "See [l<].")
 (DEAD-EVENTS
  (DEBUGGING)
  "Using proof supporters to identify dead code and unused theorems

  Below, when we talk about ``an event A'', we mean an event whose name
  is A.

  When event A is used in a proof performed to admit event B that you
  submit to ACL2, we say that A is a ``proof-supporter'' of B.  ACL2
  stores an association list such that for every event B with at
  least one proof-supporter, B is associated with a list of all of
  its proof-supporters, sorted by [symbol<].  The following form
  evaluates to that alist, which is called the
  ``proof-supporters-alist''.

    (global-val 'proof-supporters-alist (w state))

  By ``used in a proof'' above, we mean: applied as a rule or supplied
  explicitly via [hints] of type :use, :by, or :clause-processor.
  That is, the [events] ``used in a proof'' for admitting an event E
  are those listed in the [summary] printed at the conclusion of
  admitting E.

  Note that if proofs are skipped when admitting event E, say because
  the last admission of E was done by [include-book] (or
  certify-book, which ends with an [include-book]), then there will
  be no entry in that alist for E.  (An exception is made however for
  [encapsulate] [events], where proof-supporters are remembered from
  the first pass; see below.)  So if you want the
  proof-supporters-alist to include supporters for events in a book,
  use [ld] rather than [include-book] or [certify-book] to process
  the events in that book.  If however you are interested in the
  proof-supporters FROM a book that support a later event, then it is
  fine to include that book.

  The case for [encapsulate] is slightly tricky.  Consider an example
  of the following form.

    A ; event preceding the encapsulate
    (encapsulate
     ()
     B
     (local C) ; uses A and B in a proof
     D ; uses C in a proof
     )

  At the conclusion of this [encapsulate] event, the
  proof-supporters-alist associates D with A and B, but not C (which
  has disappeared, since it is [local]).

  Note that this sort of ``transitive closure'' operation is only
  performed when necessary due to the disappearance of [local]
  [events].  For example, if we replace (local C) above by just C,
  then D is associated in the proof-supporters-alist only with C, not
  with A or B.  If you want the transitive closure of the relation
  computed by the proof-supporters-alist, you have to compute it
  yourself. (This was a deliberate design decision, in order to avoid
  slowing down event processing.)  However, there is help available
  on how to do such a computation:

  A community book, books/tools/dead-events.lisp, does such a
  transitive closure, and moreover uses that information to find
  ``dead events'' relative to a list of ``desired'' events.  For
  example, suppose you use [ld] to process the events, with proofs,
  in a book intended to prove theorems MAIN-1 and MAIN-2.  (Remember,
  [certify-book] will not save such information.)  Suppose
  furthermore that the book begins with some [include-book] forms
  followed by (deflabel book-start).  You could evaluate this form:

    (dead-events '(main-1 main-2) :start 'book-start)

  The result is a list of events that you probably can delete from the
  book without causing any proofs to fail.  See the dead-events.lisp
  book for further documentation.

  You might also find the code in the above book to be helpful for
  writing your own utilities based on the proof-supporters-alist.")
 (DEALING-WITH-KEY-COMBINATIONS-OF-FUNCTION-SYMBOLS
  (INTRODUCTION-TO-THE-THEOREM-PROVER)
  "How to get rid of key combinations of function symbols

  Suppose REV reverses a list, MEMBER checks that its first argument is
  an element of its second, and SQUARES-PLUS-3P is some complicated
  predicate.  Suppose you're proving some Main Theorem that involves
  those concepts and the theorem prover presents you with the
  following hideous formula as a key checkpoint.  What action should
  you take?

  Hint: Don't read the formula ``for sense,'' i.e., don't try to
  understand what this formula is saying!  Just look at every subterm
  involving a nest of two function symbols and ask if you know
  something about those two symbols that allows you to simplify that
  one subterm.

    (IMPLIES (AND (CONSP X)
                  (MEMBER (+ 3 (* I I)) (REV X))
                  (LIST-OF-INTEGERS X)
                  (INTEGERP I)
                  (<= 0 I)
                  (INTEGERP K)
                  (<= 0 K)
                  (< I K)
                  (SQUARES-PLUS-3P K X)
                  (NOT (EQUAL (CAR X) (+ 3 (* I I))))
                  (NOT (MEMBER (+ 3 (* I I)) X)))
             (SQUARES-PLUS-3P K (REV X)))?

  The experienced ACL2 user will stop reading at the second hypothesis!

    (MEMBER (+ 3 (* I I)) (REV X))

  The combination of MEMBER and REV can be simplified.  The question
  ``is e a member of (REV x)'' can be answered by asking ``is e a
  member of x''.  The two questions are equivalent.  This insight
  comes from your intuition about the semantics of REV --- it just
  reorders the elements but doesn't add or delete any.  The second
  question is simpler since it doesn't mention REV, so this is a good
  transformation to make.  And the theorem that they are equivalent
  is simpler than the key checkpoint above because it involves fewer
  functions and smaller expressions.

  You might formalize this insight as

    (equal (member e (rev x))
           (member e x))

  But this conjecture is not a theorem, because (member e x) returns
  the cdr of x that begins with e, not just a Boolean (t or nil)
  indicating whether e is an element of x.  The location of the first
  e in (rev x) is generally different than the location in x.  So
  when we say the two questions are ``equivalent'' we don't mean they
  are equal.  We mean that they're propositionally equivalent: both
  nil or both non-nil.  This sense of equivalence is called ``if and
  only if'' and is checked by the function iff.

  So our intuitive insight can be phrased as this theorem:

    (iff (member e (rev x))
         (member e x))

  Suggesting that this formulation of the insight is ``obvious'' begs
  many questions.  Mathematically, we could have avoided iff and just
  written two implications:

    (and (implies (member e x) (member e (rev x)))
         (implies (member e (rev x)) (member e x))).

  or

    (and (implies (member e x) (member e (rev x)))
         (implies (not (member e x))  (not (member e (rev x))))).

  Or we could have used iff but ``oriented'' it the other way:

    (iff (member e x)
         (member e (rev x)))

  We choose to write

    (iff (member e (rev x))
         (member e x))

  because of our knowledge of how ACL2 turns formulas into rules!

  We deal with this at greater length later.  But just to drive the
  point home, if we issue the command:

    (defthm member-rev
      (iff (member e (rev x))
           (member e x)))

  ACL2 will build in a rule that causes every propositional occurrence
  of (MEMBER e (REV x)) to be replaced by (MEMBER e x).  (By
  ``propositional occurrence'' we mean an occurrence in which the
  value is tested, as by IF or the propositional connectives.
  Remember, one might use member to determine the location of an
  element too.)

  Note carefully: if you do not tell ACL2 how to make a rule from a
  theorem, it makes a rewrite rule.  Rewrite rules always replace
  instances of the left-hand side by the corresponding instances of
  the right-hand side.  That is, when interpreted as a rewrite rule,
  (iff alpha beta) makes ACL2 replace alpha by beta.

  Probably the biggest mistake new users make is forgetting that every
  theorem they prove creates a very specific rule.  You must remember
  that you are programming ACL2 with these rules.  Being careless in
  your statement of theorems is tantamount to being careless in your
  programming.  What you get is a mess.

  Had we proved the same equivalence, but with the iff commuted, we
  would be giving ACL2 bad advice.  We would be telling it ``replace
  instances of (MEMBER e x) by the corresponding instances of (MEMBER
  e (REV x))''!  If ACL2 had that rule and ever tried to simplify any
  member expression, e.g., (MEMBER A B), it would get into an
  infinite loop, e.g., producing the following sequence of
  transformations:

    (MEMBER A B)
    (MEMBER A (REV B))
    (MEMBER A (REV (REV B)))
    ...

  until it eventually exhausted some resource.

  Recall that we entertained the idea of phrasing our insight about
  member and rev with implications rather than iff.  Generally
  speaking, implications produce weaker rules --- rules that apply
  less often.  We discuss that later.

  Now suppose we've proved member-rev, oriented so as to rewrite
  (member e (rev x)) to (member e x), and built it in as a rewrite
  rule.  Then suppose we repeated the attempt to prove our Main
  Theorem.  This time, when the prover is processing the hideous Key
  Checkpoint printed above, our new lemma, member-rev, will hit it.
  It will transform the formula to:

    (IMPLIES (AND (CONSP X)
                  (MEMBER (+ 3 (* I I)) X)   ; <-- the hyp has simplified
                  (LIST-OF-INTEGERS X)
                  (INTEGERP I)
                  (<= 0 I)
                  (INTEGERP K)
                  (<= 0 K)
                  (< I K)
                  (SQUARES-PLUS-3P K X)
                  (NOT (EQUAL (CAR X) (+ 3 (* I I))))
                  (NOT (MEMBER (+ 3 (* I I)) X)))
             (SQUARES-PLUS-3P K (REV X)))?

  and then that will collapse to T, since the IMPLIES has contradictory
  hypotheses (note the last hypothesis above).

  By proving member-rev we proved the hideous checkpoint.  We never had
  to look at the rest of the formula or think about why it is a
  theorem.  Furthermore, attacking the main theorem again, from
  scratch, with member-rev in the database, may eliminate other
  checkpoints that came up the last time we tried to prove our main
  goal.  So we recommend addressing one checkpoint at a time.

  This example illustrates that purely local thinking --- looking for
  simplifiable combinations of function symbols --- can sometimes
  lead to proofs and should always be your first reaction to a key
  checkpoint: what local fact do you know that would clean up the
  formula?  Don't think about deep questions like ``why is this
  true?'' until you can't see any way to make it simpler.

  It is important to train yourself to see combinations of function
  symbols and to create strong rules for eliminating them.  We will
  give you opportunities to practice this later in the tutorial.

  If you have been reading the tutorial introduction to the theorem
  prover, use your browser's Back Button now to return to
  [introduction-to-key-checkpoints].")
 (DEALING-WITH-TAU-PROBLEMS
  (INTRODUCTION-TO-THE-TAU-SYSTEM)
  "Some advice on dealing with problems caused by the tau system

  For background on the tau system, see
  [introduction-to-the-tau-system].  The two most common problems
  caused by the tau system have to do with the system's interaction
  with ``legacy'' proof scripts.  Such scripts may suffer because
  they were not designed to exploit tau reasoning and which may
  configure the tau database in quite incomplete and arbitrary ways.
  The two most common problems we have seen are (a) significant slow
  downs in a few proofs and (b) failed proof attempts due to hints
  being misapplied because the tau system caused subgoals to be
  renumbered.

  We discuss the rather limited means of dealing with these problems
  here.  In [future-work-related-to-the-tau-system] we list some
  major inadequacies of the tau system.

  If the tau system contributes to a proof, the [rune]
  (:[executable-counterpart] tau-system) will be listed among the
  Rules in the [Summary].  However, merely by being attempted the tau
  system can slow down proofs in which it makes no contribution.

  The most brutal and fool-proof way to isolate a proof from the tau
  system is to disable the entire system.  This can be done globally
  by

    (in-theory (disable (tau-system)))  ; (:executable-counterpart tau-system)

  or locally with a subgoal specific hint:

    ...
    :hints ((\"...subgoal id...\" :in-theory (disable (tau-system))))

  Conducting a proof with and without the participation of the tau
  system can help you determine whether tau reasoning is helping or
  hurting.

  Dealing with Slowdowns

  The [time-tracker] utility was added to allow users to investigate
  whether excessive amounts of time are being spent in a given
  function.  It was then used to annotate the code for the tau system
  as described in [time-tracker-tau].  The result is that if
  ``excessive'' time is spent in tau reasoning, messages to that
  effect will be printed to the proof log.  The question is: aside
  from disabling the tau system how can the proof be sped up?

  There are two common causes of slowdown in the tau system.  The first
  stems from the system's use of :[executable-counterpart]s to
  determine whether a constant has a given tau.  Recall that a tau is
  a conjunction of monadic predicates.  To determine whether some
  constant satisfies the tau, the predicates are executed.  If you
  have a hard-to-compute predicate this can be very slow.  The most
  typical such predicates in ACL2 applications are those that check
  invariants, e.g., that recognize ``good states'' or ``well-formed
  data.'' These are often written inefficiently because they are
  intended only for used in theorems and, before the tau system was
  added, they may have never been applied to constants.  The most
  common constants tau predicates are applied to are 0, T, and NIL,
  although different models may stress other constants.  To
  understand why NIL for example is frequently tested, if the test of
  an IF-expression is computed to have tau s then the next question
  we ask is ``does nil satisfy s?''

  You may determine whether the tau system is spending time executing
  tau predicates by observing the rewriter --- see [dmr] --- or by
  interrupting the system and getting a backtrace (see
  [set-debugger-enable]).

  If excessive time is being spent in a tau predicate, a draconian
  solution is to disable the :[executable-counterpart] of that
  predicate, for example in either of these equivalent ways.  The tau
  system does not execute disabled :[executable-counterpart]s.

    (in-theory (disable (:executable-counterpart foo)))
    (in-theory (disable (foo)))

  In either case above, you may prefer to provide local :[in-theory]
  :[hints] rather than :in-theory [events].

  Disabling the executable-counterpart of expensive tau predicates will
  weaken the tau system, probably only negligibly, because it can no
  longer run the predicates to determine whether they admits given
  constants.

  A more sophisticated solution is to make the tau system record values
  of the :[logic]-mode function in question, so that the system will
  look up the necessary values rather than running the function every
  time the question arises.  It will look up recorded values whether
  the executable-counterpart of the tau predicate is enabled or
  disabled.  Here is an example of a lemma that can provide such a
  solution.  See the discussion of the Eval form of :[tau-system]
  rules.

    (defthm lemma
      (and (foo 0)
           (foo 17)
           (foo t)
           (not (foo '(a b c))))
      :rule-classes :tau-system)

  It might be difficult to determine which constants are being
  repeatedly tested, although tracing ([trace$]) suspected tau
  predicates will show what they are being called on.

  At the moment there are no better user-level tools to discover this.
  However, some users may wish to consider the following hack: In the
  ACL2 source file tau.lisp, immediately after the definition of the
  system function ev-fncall-w-tau-recog, there is a comment which
  contains some raw Lisp code that can be used to investigate whether
  tau's use of evaluation on constants is causing a problem and to
  determine which constants are involved.

  The second main cause of slowdowns by the tau system is that the
  system contains ``too many'' conjunctive rules (see the Conjunctive
  form in [tau-system]).  Unfortunately, we have no tools for either
  identifying the problem or addressing it!  That said, let us tell
  you what we do know!

  Conjunctive rules are used to ``complete'' each tau as it is built.
  Referring to the weekdayp example in [tau-system], if a tau is
  constructed that recognizes weekdays but not MON, TUE, THU, or FRI,
  it is completed by adding that the tau recognizes (only) WED.  This
  means that when we construct a tau we scan all known conjunctive
  rules and see whether all but one of the literals of any
  conjunctive rule are present.  This can be expensive.  To mitigate
  this expense, the tau system caches the computation on a per proof
  basis (the cache is cleared after every proof).

  To learn what conjunctive rules there are in your system, evaluate

    (assoc 'tau-conjunctive-rules (tau-database (w state)))

  Perhaps by sending the implementors that list, we can think of ways
  to index the conjunctive rules to save time.

  Dealing with Misapplied Hints

  The second common problem caused by the tau system in legacy proof
  scripts is that it can cause subgoals to be renumbered and thus
  cause hints to be missed.  The only ways to address this problem is
  either to disable the tau system (locally or globally by disabling
  (:executable-counterpart tau-system)) or change the legacy hints to
  use the new subgoal names.")
 (DEBUGGING
  (TOP ACL2)
  "Tools for debugging failed or slow proofs, or misbehaving functions.


Subtopics

  [Accumulated-persistence]
      To get statistics on which [rune]s are being tried

  [Break-rewrite]
      The read-eval-print loop entered to [monitor] rules

  [Cw-gstack]
      Debug a rewriting loop or stack overflow

  [Dead-events]
      Using proof supporters to identify dead code and unused theorems

  [Disassemble$]
      Disassemble a function

  [Dmr]
      Dynamically monitor rewrites and other prover activity

  [Efficiency]
      Efficiency considerations

  [Failed-forcing]
      How to deal with a proof [failure] in a forcing round

  [Failure]
      How to deal with a failure to admit an event

  [Forward-chaining-reports]
      To see reports about the forward chaining process

  [Guard-debug]
      Generate markers to indicate sources of [guard] proof obligations

  [Invariant-risk]
      Potential slowdown for [program]-mode updates to [stobj]s or
      [arrays]

  [Measure-debug]
      Generate markers to indicate sources of [measure] proof obligations

  [Near-misses]
      Approximate event name matches

  [Nil-goal]
      How to proceed when the prover generates a goal of NIL

  [Print-gv]
      Print a form whose evaluation caused a guard violation

  [Proof-builder]
      An interactive tool for controlling ACL2's proof processes.

  [Proof-tree]
      Proof tree displays

  [Pstack]
      Seeing what the prover is up to

  [Quick-and-dirty-subsumption-replacement-step]
      (advanced topic) controlling a heuristic in the prover's clausifier

  [Redo-flat]
      Redo on failure of a [progn], [encapsulate], or [certify-book]

  [Set-check-invariant-risk]
      Affect certain [program]-mode updates to [stobj]s or [arrays]

  [Set-debugger-enable]
      Control whether Lisp errors and breaks invoke the Lisp debugger

  [Set-guard-msg]
      Specify what is printed when a [guard] is violated

  [Set-print-gv-defaults]
      Set default keyword values for [print-gv]

  [Set-register-invariant-risk]
      Avoid [invariant-risk] checking for specified functions

  [Splitter]
      Reporting of rules whose application may have caused case splits

  [Tail-biting]
      Rewriting a true term to NIL

  [Time-tracker]
      Display time spent during specified evaluation

  [Trace]
      Tracing functions in ACL2

  [Type-prescription-debugging]
      Improve a built-in [type-prescription] rule

  [Walkabout]
      Explore an ACL2 cons tree")
 (DECLARATION (POINTERS)
              "See [declare].")
 (DECLARE
  (PROGRAMMING ACL2-BUILT-INS)
  "Extra declarations that can occur in function definitions, [let]
  bindings, and so forth.

  Common Lisp provides a declaration mechanism that allows the
  programmer to explain additional information to the compiler.  For
  instance:

    * The programmer might declare that some variable always has some
      particular type.  The compiler might then, depending on its
      optimization/safety settings, either add run-time checks to
      ensure that this really is true, or optimize the compiled code
      by assuming the variable has the correct type.
    * The programmer might declare that some variable is ignored.  The
      compiler might then, instead of warning the programmer that the
      variable is never used, explicitly check to make sure that it
      really is never used.

  ACL2 supports the above kinds of declarations, and also adds its own
  kinds of declarations for specifying things like the [guard]s and
  [measure]s of functions, as described in [xargs].

  There are also other kinds of Common Lisp declarations that ACL2 does
  not support, e.g., pertaining to inlining, safety settings,
  variable lifetime, and so forth.


Usage

  Examples:

    (declare (ignore x y z))
    (declare (ignorable x y z)
             (irrelevant w) ; for DEFUN only
             (type integer i j k)
             (type (satisfies integerp) m1 m2))
    (declare (xargs :guard (and (integerp i)
                                (<= 0 i))
                    :guard-hints ((\"Goal\" :use (:instance lemma3
                                                  (x (+ i j)))))))

  General Form:

    (declare d1 ... dn)

  where, in ACL2, each di is of one of the following forms:

    (ignore v1 ... vn)
      where each vi is a variable introduced in the immediately superior
      lexical environment.  These variables must not occur free in
      the scope of the declaration.  This declaration can be useful
      for inhibiting compiler warnings; see also [set-ignore-ok].
    (ignorable v1 ... vn)
      where each vi is a variable introduced in the immediately superior
      lexical environment.  These variables need not occur free in
      the scope of the declaration.  This declaration can be useful
      for inhibiting compiler warnings; see also [set-ignore-ok].
    (irrelevant v1 ... vn)
      where each vi is a formal parameter declared at the top level of a
      surrounding [defun] form, as shown below.  See
      [irrelevant-formals] for more information.
    (type type-spec v1 ... vn)
      where each vi is a variable introduced in the immediately superior
      lexical environment and type-spec is a type specifier (as
      described in the documentation for [type-spec]).  This
      declaration can be useful for optimizing Common Lisp execution
      speed.  See also [the].
    (xargs :key1 val1 ... :keyn valn)
      where the legal values of the keys and values are described in the
      documentation for [xargs].  These declarations are only allowed
      at the top level of definitions ([defun] and [defmacro], as
      shown below), and convey information such as the [guard] and
      [measure] for a function.
    (optimize ...)
      for example, (optimize (safety 3)).  This is allowed only at the top
      level of [defun] forms and is probably only rarely of any
      interest.  See any Common Lisp documentation for more
      information.

  Declarations in ACL2 may occur only where dcl occurs in the following
  display (not including lambda objects, discussed later below):

    * (DEFUN name args doc-string dcl ... dcl body)
    * (DEFMACRO name args doc-string dcl ... dcl body)
    * (LET ((v1 t1) ...) dcl ... dcl body)
    * (MV-LET (v1 ...) term dcl ... dcl body)
    * (FLET ((name args dcl ... dcl body) ...))

  Each of the cases above permits certain declarations, as follows.

    * DEFUN: (ignore ignorable irrelevant type optimize xargs)
    * DEFMACRO: (ignore ignorable type xargs)
    * LET: (ignore ignorable type)
    * MV-LET: (ignore ignorable type)
    * FLET: (ignore ignorable type)

  Of course, declarations are permitted in macro calls to the extent
  that they are permitted in the macroexpansions.  For example,
  declare forms generated by calls of [let*] and [case-match] may
  wind up in corresponding [let] forms in the macroexpansions, where
  they would be subject to the restrictions on declare forms for let
  shown just above.

  Also see [lambda] for discussion of lambda objects and their legal
  declare forms.

  Declare is defined in Common Lisp.  See any Common Lisp documentation
  for more information.


Subtopics

  [Declare-stobjs]
      Declaring a formal parameter name to be a single-threaded object

  [Set-ignore-ok]
      Allow unused formals and locals without an ignore or ignorable
      declaration

  [Set-irrelevant-formals-ok]
      Allow irrelevant formals in definitions

  [Type-spec]
      Type specifiers can be used in Common Lisp type declarations and
      [the] forms, and may result in improved efficiency of
      execution.

  [Xargs]
      Extra arguments, for example to give [hints] to [defun]")
 (DECLARE-STOBJS
  (STOBJ DECLARE)
  "Declaring a formal parameter name to be a single-threaded object

  When a [defun] uses one of its formals as a single-threaded object
  ([stobj]), the defun must include a declaration that the formal is
  to be so used.  An exception is the formal ``[state],'' which if
  not declared as explained below, may still be used provided an
  appropriate global ``declaration'' is issued: see [set-state-ok].

  If the formal in question is counters then an appropriate declaration
  is

    (declare (xargs :stobjs counters))

  or, more generally,

    (declare (xargs :stobjs (... counters ...)))

  where all the single-threaded formals are listed.

  For such a declaration to be legal it must be the case that all the
  names have previously been defined as single-threaded objects with
  [defstobj].

  When an argument is declared to be single-threaded the guard of the
  function is augmented by conjoining to it the condition that the
  argument satisfy the recognizer for the single-threaded object.
  Furthermore, the syntactic checks done to enforce the legal use of
  single-threaded objects are also sufficient to allow these guard
  conjuncts to be automatically proved.

  The obvious question arises: Why does ACL2 insist that you declare
  stobj names before using them in defuns if you can only declare
  names that have already been defined with defstobj?  What would go
  wrong if a formal were treated as a single-threaded object if and
  only if it had already been so defined?

  Suppose that one user, say Jones, creates a book in which counters is
  defined as a single-threaded object.  Suppose another user, Smith,
  creates a book in which counters is used as an ordinary formal
  parameter.  Finally, suppose a third user, Brown, wishes to use
  both books.  If Brown includes Jones' book first and then Smith's,
  then Smith's function treats counters as single-threaded.  But if
  Brown includes Smith's book first, the argument is treated as
  ordinary.

  ACL2 insists on the declaration to ensure that the definition is
  processed the same way no matter what the context.")
 (DEFABBREV
  (MACROS EVENTS PROGRAMMING)
  "A convenient form of macro definition for simple expansions

    Examples:
    (defabbrev snoc (x y) (append y (list x)))
    (defabbrev sq (x) (declare (type (signed-byte 8) x)) (* x x))

    General Form:
    (defabbrev name (v1 ... vn) doc-string decl1 ... declk body)

  where name is a new function symbol, the vi are distinct variable
  symbols, and body is a term.  The decli, if supplied, should be
  legal declare forms; see [declare].  Doc-string, if non-nil, is an
  optional string that can provide documentation but is essentially
  ignored by ACL2.

  Roughly speaking, the defabbrev event is akin to defining f so that
  (f v1 ... vn) = body.  But rather than do this by adding a new
  axiom, defabbrev defines f to be a macro so that (f a1 ... an)
  expands to body, with the ``formals,'' vi, replaced by the
  ``actuals,'' ai.

  For example, if snoc is defined as shown in the first example above,
  then (snoc (+ i j) temp) is just an abbreviation for

    (append temp (list (+ i j))).

  In order to generate efficiently executable Lisp code, the macro that
  defabbrev introduces uses a [let] to bind the ``formals'' to the
  ``actuals.'' Consider the second example above.  Logically
  speaking, (sq (ack i j)) is an abbreviation for (* (ack i j) (ack i
  j)).  But in fact the macro for sq introduced by defabbrev actually
  arranges for (sq (ack i j)) to expand to:

    (let ((x (ack i j)))
      (* x x))

  which executes more efficiently than (* (ack i j) (ack i j)).

  In the theorem prover, the let above expands to

    ((lambda (x) (* x x)) (ack i j))

  and thence to (* (ack i j) (ack i j)).

  It is important to note that the term in body should not contain a
  call of name --- i.e., defabbrev should not be used in place of
  defun when the function is recursive.  ACL2 will not complain when
  the defabbrev form is processed, but instead ACL2 will more than
  likely go into an infinite loop during macroexpansion of any form
  that has a call of name.

  It is also important to note that the parameters of any call of a
  macro defined by defabbrev will, as is the case for the parameters
  of a function call, be evaluated before the body is evaluated,
  since this is the evaluation order of [let].  This may lead to some
  errors or unexpected inefficiencies during evaluation if the body
  contains any conditionally evaluated forms like cond, case, or if.
  Consider the following example.

    (defabbrev foo (x y)
      (if (test x) (bar y) nil))

  Notice a typical one-step expansion of a call of foo (see [trans1]):

    ACL2 !>:trans1 (foo expr1 expr2)
     (LET ((X EXPR1) (Y EXPR2))
          (IF (TEST X) (BAR Y) NIL))
    ACL2 !>

  Now imagine that expr2 is a complicated expression whose evaluation
  is intended only when the predicate test holds of expr1.  The
  expansion above suggests that expr2 will always be evaluated by the
  call (foo expr1 expr2), which may be inefficient (since perhaps we
  only need that value when test is true of expr1).  The evaluation
  of expr2 may even cause an error, for example in :[program] mode if
  the expression expr2 has been constructed in a manner that could
  cause a guard violation unless test holds of expr1.")
 (DEFABSSTOBJ
  (EVENTS STOBJ)
  "Define a new abstract single-threaded object

  We assume familiarity with single-threaded objects; see [stobj] and
  see [defstobj].  The event defabsstobj defines a so-called
  ``abstract stobj'', a notion we introduce briefly now and then
  explain in more depth below.

  Recall that a [defstobj] event produces logical definitions for
  several functions: a recognizer, which characterizes the [stobj] in
  terms of lists; a creator, which produces an initial suitable list
  structure; and field accessors and updaters, defined in terms of
  [nth] and [update-nth].  Defabsstobj provides a way to define
  alternate definitions for ``stobj primitives'' for a corresponding
  single-threaded object.  These stobj primitives include a
  recognizer, a creator, and other ``exported'' functions.  In
  essence, defabsstobj establishes interface functions, or
  ``exports'', on a new stobj that is a copy of an existing stobj,
  its ``foundation'', which is either concrete (introduced by
  [defstobj]) or abstract (introduced by defabsstobj).

  We begin below with an introduction to abstract [stobj]s.  We then
  explain the [defabsstobj] event by way of an example.  We conclude
  by giving summary documentation for the defabsstobj event.

  For another introduction to abstract stobjs, see the paper ``Abstract
  Stobjs and Their Application to ISA Modeling'' by Shilpi Goel,
  Warren A. Hunt, Jr., and Matt Kaufmann, in the proceedings of {ACL2
  Workshop 2013 | http://www.cs.uwyo.edu/~ruben/acl2-13}.

  INTRODUCTION

  We start with a brief review of [stobj]s and some potential problems
  with them, followed by an introduction to abstract stobjs and how
  they can avoid these problems.  Prior experience with stobjs will
  probably help the reader to absorb the ideas below.

  Recall that single-threaded objects, or [stobj]s, provide a way for
  ACL2 users to stay within the ACL2 logic --- where every data
  object is an atom or a [cons] of data objects --- while obtaining
  the benefits of fast evaluation through destructive updates.
  Consider for example this very simple event.

    (defstobj st fld)

  This event introduces a recognizer, stp, and a creator, create-st,
  for a data structure consisting of a single field accessed and
  updated by functions fld and update-fld, respectively.  Each of
  these four primitive functions has both a logical definition, which
  is used when the prover reasons about the function, and an
  executable definition, which is used in raw Lisp.  In the logic,
  stp recognizes objects that have the requisite fields.  In raw
  Lisp, there is a ``live stobj'', which is typically an array object
  whose fields correspond to those specified by the [defstobj] event.
  (If there is a single stobj field that is an array or hash-table
  field, then that field is the entire stobj in raw Lisp; but we
  ignore that case below.)

  Here are the logical definition and the executable definition,
  respectively, that are introduced for the field accessor, fld,
  introduced above.  Notice that since a stobj is represented in raw
  Lisp using an array, the raw Lisp accessor uses a raw Lisp array
  accessor, svref.  (You can see all the logical and executable
  definitions by evaluating the form (trace$ defstobj-axiomatic-defs
  defstobj-raw-defs) before evaluating the [defstobj] form.)

    ; logical definition
    (defun fld (st)
      (declare (xargs :guard (stp st)
                      :verify-guards t))
      (nth 0 st))

    ; executable (raw Lisp) definition
    (defun fld (st)
      (svref st 0))

  Sophisticated programming with stobjs can provide efficient
  implementations of algorithms, but may require the preservation of
  a complex invariant.  One can, of course, define a function to
  implement such an invariant after introducing the stobj, as
  follows.

    ; Introduce a stobj.
    (defstobj st fld1 ... fldk)

    ; Define an invariant on that stobj.
    (defun good-stp (st)
      (declare (xargs :stobjs st))
      ...)

    ; Define some basic functions that update the stobj and preserve the
    ; invariant.
    (defun update-st (... st ...)
      (declare (xargs :stobjs st
                      :guard (and (good-stp st) ...)))
      ...)
    ...

    ; Prove that the invariant is indeed preserved by those basic functions.
    (defthm good-stp-update-st
      (implies (and (good-stp st)
                    ...)
               (good-stp (update-st ... st ...))))
    ...

    ; Implement algorithms built on the basic functions.
    (defun foo (... st ...)
      (declare (xargs :stobjs st
                      :guard (and (good-stp st) ...)))
      ... (update-st ... st ...) ...)

    ; Prove invariance theorems about these algorithms.
    (defthm good-stp-foo
      (implies (and (good-stp st)
                    ...)
               (good-stp (foo ... st ...))))
    ...

    ; Prove other properties of these algorithms.
    (defthm foo-is-correct
      (implies (and (good-stp st)
                    ...)
               (some-property (foo ... st ...))))
    ...

  But there are at least two potential difficulties in using stobjs as
  described above.

   1. When foo is executed on concrete data in the ACL2 loop, the guard
      check may be expensive because (good-stp st) is expensive.
   2. Reasoning about foo (using rules like foo-is-correct above) involves
      proving hypotheses of invariance theorems, which may be
      complicated for the user to manage or slow for the theorem
      prover.

  The defabsstobj event offers an opportunity to address these issues.
  It introduces a new stobj, which we call an ``abstract stobj'',
  which is associated with a corresponding ``foundational stobj''
  introduced by an earlier [defstobj] or defabsstobj event.  The
  defabsstobj event specifies a logical (:LOGIC) and an executable
  (:EXEC) definition for each primitive operation, or ``stobj
  primitive'', involving that stobj.  As is the case for [defstobj],
  the logical definition is what ACL2 reasons about, and is
  appropriate to apply to an ACL2 object satisfying the logical
  definition of the recognizer function for the stobj.  The
  executable definition is applied in raw Lisp to a live stobj (as
  discussed above).

  Remark.  It is common to use ``a'' and ``c'' in a suffix to suggest
  ``abstract'' and ``concrete'', respectively.  The foundational
  stobj was, at one time, called the ``corresponding concrete
  stobj''.  That old terminology may still be appropriate in the
  common case that the foundational stobj is a concrete stobj (rather
  than another abstract stobj).  So below, a name like st$c0 suggests
  a foundational (``concrete'') stobj for an abstract stobj named st,
  whose abstract stobj recognizer is st$ap, and so on.  End of
  Remark.

  We can picture a sequence of updates to an abstract stobj and its
  foundational stobj.  Initially in this picture, st$a0 and st$c0 are
  an abstract stobj and its foundation (respectively).  Then an
  update, u1, is applied with :LOGIC and :EXEC functions u$a1 and
  u$c1, respectively.  The resulting abstract and foundational stobj,
  st$a1 and st$c1, correspond as before.  Then a second update, u2,
  is applied with :LOGIC and :EXEC functions u$a2 and u$c2,
  respectively --- again preserving the correspondence.  And so on.

    Abstract               u$a1       u$a2       u$a3
    (:logic)         st$a0  --> st$a1  --> st$a2  -->   ...

                       ^          ^          ^               ^
    Correspondence     |          |          |          ...  |
                       v          v          v               v

                           u$c1       u$c2       u$c3
    Foundation       st$c0  --> st$c1  --> st$c2  -->   ...
    (:exec)

  We conclude this introduction with some remarks about implementation.
  Consider an abstract stobj st with corresponding foundation st$c.
  The live stobjs for st and st$c have the same structure, but are
  distinct arrays.  Indeed, the raw Lisp creator function for st$c is
  called to create a new initial live stobj for st.  As we will see
  below, reads and writes in raw Lisp to the live stobj for st are
  ultimately performed using the primitive accessors and updaters
  defined for st$c.  One might think of the live stobjs for st and
  st$c as being congruent stobjs (see [defstobj]), except that the
  stobjs themselves are not truly congruent: in particular, the stobj
  primitives introduced for st may be applied to st, but field
  updaters of st$c may not.  As one might expect, the :EXEC function
  for an exported function is applied to the live stobj for st in raw
  Lisp.

  EXAMPLE

  We present examples, with detailed comments intended to explain
  abstract stobjs, in two community books:
  books/demos/defabsstobj-example-1.lisp and
  books/demos/defabsstobj-example-2.lisp.  In this section we outline
  the first of these.  We suggest that after you finish this
  [documentation] topic, you read through those two books.  There are
  other books books/dmeos/defabsstobj-example-*.lisp that may be
  helpful to read; in particular,
  books/demos/defabsstobj-example-5.lisp illustrates building an
  abstract stobj on top of another abstract stobj (as its so-called
  ``foundation'', as described below).

  Here is the first of two closely related defabsstobj [events] from
  the book defabsstobj-example-1.lisp, but in expanded form.  We will
  show the abbreviated form later, which omits most of the data in
  the form that is immediately below.  Thus most of the information
  shown here is default information.  We believe that the comments
  below explain most or all of what you need to know in order to
  start using defabsstobj, and that you will learn the remainder when
  you see error messages.  For example, we do not say in the comments
  below that every :LOGIC and :EXEC function must be
  [guard]-verified, but that is indeed a requirement.

    (defabsstobj st ; The new abstract stobj is named st.

    ; The foundational stobj for st is st$c:

      :foundation st$c

    ; The recognizer for the new abstract stobj is stp, which is defined to be
    ; st$ap in the logic, and is executed on the live stobj in raw Lisp using
    ; st$cp.

      :recognizer (stp :logic st$ap :exec st$cp)

    ; The initial stobj is defined as create-st (a function of no arguments),
    ; which is defined logically as create-st$a, though create-st$c is invoked to
    ; create the initial live stobj for st.  The :correspondence and :preserved
    ; keywords refer to proof obligations, discussed below.

      :creator (create-st :logic create-st$a :exec create-st$c
                          :correspondence create-st{correspondence}
                          :preserved create-st{preserved})

    ; Proof obligations are generated that involve a correspondence between the
    ; new abstract stobj and corresponding foundational stobj.  The function
    ; st$corr, which need not be executable (see :DOC defun-nx), takes two
    ; arguments, a foundational stobj and an abstract stobj.  This function symbol
    ; is used in the statements of the proof obligations.

      :corr-fn st$corr

    ; In this example we have four exports.  In each case a new function is
    ; introduced that has the same signature as its :EXEC function, except that
    ; st$c is replaced by st.  The :LOGIC and :EXEC functions are as specified,
    ; and the other keywords refer to proof obligations that we discuss below.

      :exports ((lookup :logic lookup$a
                        :exec mem$ci
                        :correspondence lookup{correspondence}
                        :guard-thm lookup{guard-thm})
                (update :logic update$a
                        :exec update-mem$ci
                        :correspondence update{correspondence}
                        :preserved update{preserved}
                        :guard-thm update{guard-thm})
                (misc :logic misc$a
                      :exec misc$c
                      :correspondence misc{correspondence})
                (update-misc :logic update-misc$a
                             :exec update-misc$c
                             :correspondence update-misc{correspondence}
                             :preserved update-misc{preserved})))

  Note that all stobj primitives (recognizer, creator, and exported
  functions) are defined in the ACL2 loop in terms of their :LOGIC
  functions and in raw Lisp in terms of their :EXEC functions.  In
  the ACL2 loop, a [defun] form defines a function, while in raw
  Lisp, a [defmacro] form defines a macro (for efficiency).  We first
  illustrate how that works for the recognizer.  (You can see all the
  logical and executable definitions by evaluating the form (trace$
  defabsstobj-axiomatic-defs defabsstobj-raw-defs) before evaluating
  the [defstobj] form.)

    ; In the ACL2 loop:
    (defun stp (st)
      (declare (xargs :guard 't))
      (st$ap st))

    ; In raw Lisp:
    (defmacro stp (&rest args) (cons 'st$cp args))

  The definitions are made similarly for exported functions.  [Guard]s
  are derived from their :LOGIC functions as follows.  Consider the
  exported function update in our example.  Its :LOGIC function,
  update$a, has formals (k val st$a) and the following guard.

    (and (and (integerp k) (<= 0 k) (<= k 49))
         (and (integerp val) (<= 0 val))
         (st$ap st$a)
         (mem$c-entryp val))

  The formals of update are obtained by starting with the formals of
  its :EXEC function, update-mem$ci --- which are (i v st$c) --- and
  replacing the foundational stobj name st$c by the new stobj name
  st.  The formals of update are thus (i v st).  The guard for update
  is obtained in two steps.  The first step is to substitute the
  formals of update for the formals of update$a in the guard for
  update$a, to obtain the following.

    (and (and (integerp i) (<= 0 i) (<= i 49))
         (and (integerp v) (<= 0 v))
         (st$ap st)
         (mem$c-entryp v))

  The second step is to replace, for each new stobj primitive p, the
  :LOGIC function for p by p itself.  The only :LOGIC function
  occurring in the formula just above is st$ap, which is the :LOGIC
  function for stp.  The guard for update is thus as follows.

    (and (and (integerp i) (<= 0 i) (<= i 49))
         (and (integerp v) (<= 0 v))
         (stp st)
         (mem$c-entryp v))

  Note that the :EXEC version of an abstract [stobj] export must not
  include the abstract stobj name among its formals.

  We turn now to the proof obligations, as promised above.  There are
  three types: :CORRESPONDENCE, :PRESERVED, and :GUARD-THM.  All
  required lemmas may be printed simply by defining the necessary
  :LOGIC and :EXEC functions and then submitting the defabsstobj
  event.  (To advanced users: also see [defabsstobj-missing-events]
  for a utility that returns the required formulas in translated
  form.)  Although the defabsstobj event will fail if the required
  lemmas have not been proved, first it will print the [defthm] forms
  that must be admitted in order to complete submission of the
  defabsstobj event.  (Note that although those theorems are stated
  exactly in the form expected by the system, you are welcome to
  supply whatever :[rule-classes] you prefer, even though the system
  creates :rule-classes nil by default.)

  The detailed theory explaining the need for these lemmas may be found
  in ACL2 source file other-events.lisp, in a comment entitled
  ``Essay on the Correctness of Abstract Stobjs''.  Here, we give an
  informal sense of the importance of these lemmas as we present
  examples of them.  Fundamental is the notion of evaluation in the
  logic versus evaluation using live stobjs, where one imagines
  tracking the current value of each abstract stobj during each of
  these two evaluations.

  We start with the :CORRESPONDENCE lemmas.  These guarantee that
  evaluation in the logic agrees with evaluation using live stobjs,
  in the sense that the only difference is between a logical stobj
  and a live stobj, where the two correspond in the sense of the
  function specified by :CORR-FN.  We start with the :CREATOR
  function where the statement is quite simple, stating that the
  :CORR-FN holds initially.

    (defthm create-st{correspondence}
      (st$corr (create-st$c) (create-st$a)))

  For the exported functions, there are essentially two cases.  If an
  exported function returns other than the new abstract stobj, then
  the theorem asserts the equality of the results of applying the
  :LOGIC and :EXEC functions for the exported function.  Hypotheses
  include the :CORR-FN correspondence followed by the [guard] for the
  :LOGIC function, which is stated in terms of the formal parameters
  of the :EXEC function except using the abstract stobj (here, st) in
  place of the foundational stobj (here, st$c).  The conclusion uses
  the :EXEC formals, modified in the call of the :LOGIC function
  (here, lookup$a) to use the abstract stobj, as in the hypotheses.

    (defthm lookup{correspondence}
      (implies (and (st$corr st$c st)
                    (integerp i) (<= 0 i) (<= i 49)
                    (st$ap st))
               (equal (mem$ci i st$c)
                      (lookup$a i st)))
      :rule-classes nil)

  By contrast, if the exported function returns the new abstract stobj,
  then the conclusion uses the correspondence function instead of
  EQUAL, as in the following.

    (defthm update{correspondence}
      (implies (and (st$corr st$c st)
                    (integerp i) (<= 0 i) (<= i 49)
                    (integerp v) (<= 0 v)
                    (st$ap st)
                    (mem$c-entryp v))
               (st$corr (update-mem$ci i v st$c)
                        (update$a i v st)))
      :rule-classes nil)

  For exported functions that return multiple values, such conclusions
  are conjoined together over the returned values.

  The :PRESERVED lemmas guarantee that updates to the abstract stobj
  preserve its recognizer.  The fact that every exported function has
  this property provides justification for an optimization performed
  by ACL2 during generation of proof obligations for [guard]
  verification, by assuming that the recognizer always holds.  The
  :PRESERVED lemma for the :CREATOR shows that the recognizer holds
  initially.

    (defthm create-st{preserved}
      (st$ap (create-st$a)))

  Here is a typical such lemma, for the exported function update.  Note
  that there is no such lemma for lookup, since lookup does not
  return st.

    (defthm update{preserved}
      (implies (and (integerp i) (<= 0 i) (<= i 49)
                    (integerp v) (<= 0 v)
                    (st$ap st)
                    (mem$c-entryp v))
               (st$ap (update$a i v st))))

  Finally, we consider the :GUARD-THM lemmas.  These serve to guarantee
  that the [guard] holds for each call of an :EXEC function.  During
  guard verification, logical definitions are used; in particular,
  since each exported function is defined in the logic as the
  corresponding call of its :LOGIC function, guard verification shows
  that each call of the :LOGIC function for an exported function
  satisfies that function's guard.  But why is this true for raw Lisp
  evaluation using live stobjs, where the :EXEC function is called
  for an exported function?  The :GUARD-THM lemmas provide the
  answer, as they state that if the :LOGIC function's guard holds,
  then the :EXEC function's guard holds.  Here is an example.  Note
  that the hypotheses come from the correspondence of the
  foundational and abstract function as guaranteed by the :CORR
  function, together with the guard of the :LOGIC function; and the
  conclusion comes from the guard of the :EXEC function.

    (defthm lookup{guard-thm}
      (implies (and (st$corr st$c c)
                    (integerp i)
                    (<= 0 i)
                    (<= i 49)
                    (st$ap st))
               (and (integerp i)
                    (<= 0 i)
                    (< i (mem$c-length st$c))))
      :rule-classes nil)

  We conclude this EXAMPLE section by showing a short form for the
  defabsstobj form displayed above.

    (defabsstobj st
      :exports ((lookup :exec mem$ci)
                (update :exec update-mem$ci)
                misc update-misc))

  SUMMARY DOCUMENTATION

  The General Form is as shown below, where the order of keywords is
  unimportant.  Duplicate keywords are discouraged; while permitted,
  only the first (leftmost) occurrence of a given keyword is used.
  Only the :exports keyword is required.

    (defabsstobj st
      :foundation foundation
      :recognizer recognizer
      :creator creator
      :corr-fn corr-fn
      :congruent-to congruent-to
      :protect-default protect-default
      :exports (e1 ... ek))

  The keyword argument :EXPORTS must be supplied, and missing or nil
  keyword arguments have defaults as indicated below.  All arguments
  must satisfy the conditions below.

  Before we describe the arguments, we define a notion of a ``function
  spec'' and its ``completion''.  A function spec is either a symbol
  or else a list of the form

    (fn :kwd1 val1 ... :kwdn valn),

  that is, a symbol followed by a [keyword-value-listp].  We view the
  case of a symbol, s, as the function spec (s), with no keywords.
  There must be no duplicate keywords.  In each case that we expect a
  function spec, the context provides a set of valid keywords for
  that function spec; it is an error to provide any other keyword in
  the function spec.  Each function spec is interpreted as its
  ``completion'', obtained by extending the function spec with a
  default value for each valid keyword as indicated below.  With that
  interpretation, the ``exported function'' of a function spec is its
  car, and that function symbol and each keyword value must be a
  guard-verified function symbol; and moreover, the :EXEC function
  must not include the new abstract stobj name, st, among its
  formals.

  We are ready to describe the arguments of defabsstobj.

      St is a symbol, which names the new abstract stobj.

      Foundation is the name of an existing stobj, which may have been
      introduced either with [defstobj] or with defabsstobj.

      Recognizer is a function spec (for the recognizer function).  The
      valid keywords are :LOGIC and :EXEC.  The default for
      recognizer is obtained by adding the suffix \"P\" to name.  The
      default value for :LOGIC is formed by adding the suffix \"$AP\"
      to recognizer; for :EXEC, by adding the suffix \"$CP\".  The
      :EXEC function must be the recognizer for the foundational
      stobj (which can be specified using the :FOUNDATION keyword).

      Creator is a function spec (for the creator function).  The valid
      keywords are :LOGIC and :EXEC.  The default for creator is
      obtained by adding the prefix \"CREATE-\" to name.  The default
      value for :LOGIC is formed by adding the suffix \"$A\" to
      creator; for :EXEC, by adding the suffix \"$C\".  The :EXEC
      function must be the creator for the foundational stobj (which
      can be specified using the :FOUNDATION keyword).

      Corr-fn is a known function symbol that takes two arguments (for the
      correspondence theorems).  The default for corr-fn is obtained
      by adding the suffix \"$CORR\" to name.

      Congruent-to should either be nil (the default) or the name of an
      abstract stobj previously introduced (by [defabsstobj]).  In
      the latter case, the current and previous abstract stobj should
      have the same foundational stobj (not merely congruent
      foundational stobjs), and their :EXPORTS fields should have the
      same length and also correspond, as follows: the ith export of
      each should have the same :LOGIC and :EXEC symbols.  See
      [defstobj] for more about congruent stobjs.  Note that if two
      names are congruent, then they are either both ordinary stobjs
      or both abstract stobjs.

      Protect-default should either be nil (the default) or t.  It provides
      the value of keyword :PROTECT for each member of exports that
      does not explicitly specify :PROTECT.  See the discussion of
      exports below.

      An important aspect of the congruent-to parameter is that if it is
      not nil, then the checks for lemmas --- {CORRESPONDENCE},
      {GUARD-THM}, and {PRESERVED} --- are omitted.  Thus, the values
      of keyword :CORR-FN, and the values of keywords
      :CORRESPONDENCE, :GUARD-THM, and :PRESERVED in each export (as
      we discuss next), are irrelevant; they are not inferred and
      they need not be supplied.

      The value of :EXPORTS is a non-empty true list.  Each ei is a
      function spec (for an exported function).  The valid keywords
      are :LOGIC, :EXEC, :CORRESPONDENCE, and :GUARD-THM, :PROTECT,
      :UPDATER, and also :PRESERVED if and only if the specified
      :EXEC function returns the foundational stobj.  The default
      values for all of these keywords except :UPDATER and :PROTECT
      are obtained by respectively adding the suffix \"$A\" \"$C\",
      \"{CORRESPONDENCE}\", \"{GUARD-THM}\", or \"{PRESERVED}\".  For
      :PROTECT, the default is nil unless the defabsstobj event
      specifies :PROTECT-DEFAULT t.  If :UPDATER upd is supplied and
      upd is not nil, then function exported by the function spec is
      a child stobj accessor whose corresponding updater is upd; see
      the discussion of :UPDATER in [nested-stobjs].

  Not shown is the keyword, :MISSING; the effect of :missing t is to
  turn the call of defabsstobj into a corresponding call of
  [defabsstobj-missing-events].

  Note that a defabsstobj event will fail if the required lemmas ---
  that is, those for valid keywords :CORRESPONDENCE, :GUARD-THM, and
  :PRESERVED --- have not been proved, unless proofs are being
  skipped.  The exemption when skipping proofs allows the supporting
  lemmas to be [local] to [books] and [encapsulate] [events].  If the
  [ld] special [ld-skip-proofsp] is t, then the missing [events] are
  printed with a warning before the defabsstobj event is admitted;
  but if ld-skip-proofsp is the symbol INCLUDE-BOOK, then that
  warning is omitted.  (Also see [skip-proofs] and see
  [ld-skip-proofsp].)  If however proofs are not being skipped, then
  the defabsstobj event will fail after printing the missing events.
  Advanced users may wish to see [defabsstobj-missing-events] for a
  utility that returns a data structure containing the missing
  lemmas.

  Let st be an abstract stobj with corresponding foundational stobj
  st$c.  Let f be an exported function for st and let f$a and f$c be
  the corresponding :LOGIC and :EXEC functions, respectively.  The
  formals of f are obtained by taking the formals of f$c and
  replacing st$c by st.  The [guard] for f is derived as follows from
  the guard of f$a.  First, the formals of f$a are replaced by the
  formals of f in the guard of f$a, to obtain a term we denote here
  as guard-pre.  Now for each exported function symbol g of st with
  corresponding :LOGIC function g$a, form a functional substitution
  by consing g$a with g.  Finally, apply that functional substitution
  to guard-pre; the result is the guard of f.  That guard must
  satisfy the usual conditions of a guard: thus, it must return a
  single non-[stobj] value and satisfy normal syntactic restrictions,
  including single-threadedness in its handling of stobjs.

  Remark.  Because of how guards are created for exported functions,
  and in particular because :LOGIC functions are replaced as
  discussed above, a good discipline is to define :LOGIC functions
  that are not intended for general use, but are intended only for
  use as :LOGIC functions of corresponding stobj primitives.  For
  example, suppose that you use length as the :LOGIC function for
  some stobj primitive, f (as opposed to using your own function,
  say, foo-length or foo$a).  Then every call of length will be
  replaced by f when creating the guard of a stobj primitive from the
  guard of its :LOGIC function.  This might not be what you intended
  if you were using length in that guard simply to compute the length
  of an ordinary list.

  Additional restrictions include the following.

    * All exported function names must be new (unless redefinition is on;
      see [ld-redefinition-action]), and there must be no duplicates
      among them.
    * The foundational stobj name must be a formal parameter of the :EXEC
      function of every function spec, except for the :CREATOR
      function spec.
    * The :LOGIC and :EXEC function for a function spec must agree on both
      the number of inputs and the number of outputs.
    * The foundational stobj must not be a [declare]d stobj of the :LOGIC
      function of any function spec.  (This restriction could perhaps
      be removed, but it is convenient for the implementation of the
      events generated by a call of defabsstobj.)
    * The :PROTECT keyword is something that you should ignore unless you
      get an error message about it, pertaining to modifying the
      foundational stobj non-atomically.  In that case, you can
      eliminate the error by providing :PROTECT t in the function
      spec, or by providing defabsstobj keyword argument
      :PROTECT-DEFAULT t at the top level, in order to restore the
      required atomicity.  The above explanation is probably all you
      need to know about :PROTECT, but just below is a more complete
      explanation for those who desire it.  Further information is
      also available if you need it; see [set-absstobj-debug], and
      see the example uses of these keywords in community book
      books/demos/defabsstobj-example-2.lisp.

  For those who are interested, here is a more detailed discussion of
  :PROTECT and :PROTECT-DEFAULT, as promised above.  It applies to
  any function spec for an export (hence not to the :CREATOR function
  spec).  If the :EXEC function is a stobj primitive, then clearly
  the following property holds: any execution of a call of that
  function can only update the foundational stobj at most once ---
  i.e., modification of the foundational stobj is atomic.  ACL2 can
  deduce this property not only for stobj primitives but for many
  other functions as well.  However, if ACL2 cannot deduce this
  property, then it will cause an error saying that the :EXEC
  function ``appears capable of modifying the foundational stobj,
  <stobj_name>, non-atomically.'' That message also explains how to
  eliminate this error: provide :PROTECT t for the function spec.
  Alternatively, all function specs without an explicit :PROTECT
  keyword can be implicitly supplied :PROTECT t by supplying the
  value t for the :PROTECT-DEFAULT keyword parameter of the
  defabsstobj event.  However, beware that when :PROTECT is t, the
  generated raw Lisp code runs slightly less efficiently --- though
  perhaps with negligible efficiency loss if the :EXEC function is
  not trivial.  Community books
  books/demos/defabsstobj-example-3.lisp and
  books/demos/defabsstobj-example-4.lisp provide related information.
  Also see [set-absstobj-debug] for a potentially dangerous way to
  eliminate that inefficiency using argument :ignore.

  We conclude with some remarks.

  Unlike [defstobj], there is no :renaming argument.  Instead, the
  scheme described above provides a flexible way to assign names.
  Also unlike [defstobj], there is no :inline or :non-memoizable
  argument; :inline is essentially t, in the sense that stobj
  primitives are macros in raw Lisp; and the :non-memoizable argument
  is derived implicitly, to agree with non-memoizability of the
  foundational stobj.

  Those who use [hons-enabled] features, including function memoization
  (see [memoize]), may be aware that the memo table for a function is
  flushed whenever it is the case that one of its stobj inputs is
  updated.  In fact, such flushing happens even when a stobj that is
  congruent to one of its stobj inputs is updated.  For that purpose,
  an abstract stobj is considered to be congruent to its foundational
  stobj.


Subtopics

  [Illegal-state]
      Illegal ACL2 state

  [Set-absstobj-debug]
      Get more information when atomic update fails for an abstract stobj")
 (DEFABSSTOBJ-MISSING-EVENTS
  (EVENTS)
  "Obtain the [events] needed to admit a [defabsstobj] event

  We assume familiarity with [defabsstobj].  Defabsstobj-missing-events
  is a macro is for advanced users (who, for example, understand the
  role of the translate and untranslate functions), who want
  programmatic access to the [defthm] events required to admit a
  specific defabsstobj event.

  This macro has the same syntax as [defabsstobj] --- to use it, just
  replace a call of [defabsstobj] by a call of
  defabsstobj-missing-events on the same arguments.  The result is an
  error triple (mv erp val state).  If erp is nil, then val is the
  list of all objects (name formula . old-formula), where a [defthm]
  event named name remains to be admitted whose translated formula is
  formula, and where old-formula is nil unless the indicated event
  already exists (hence with a different formula), in which case
  old-formula is the existing translated formula.

  To build a [defthm] event from the above value, val, we suggest
  evaluating a form like (untranslate formula t (w state)).")
 (DEFATTACH
  (EVENTS)
  "Execute constrained functions using corresponding attached functions

    General Forms:
    (defattach f g)   ; single attach or, if g is nil, unattach
    (defattach (f1 g1 :kwd val ...)
               ...
               (fk gk :kwd' val' ...)
               :kwd'' val'' ...)

  where each indicated keyword-value pair is optional and each keyword
  is in the list (:hints :instructions :otf-flg :attach :skip-checks
  :system-ok).  More details are in the ``Syntax and Semantics''
  section below.

  A related utility can cause a function call to be evaluated using an
  alternate, provably equal function.  See [memoize], option :INVOKE.

  This [documentation] topic is organized into the following sections:

    * Introductory Example.
    * Syntax and Semantics of Defattach.
    * Three Primary Uses of Defattach.
    * Miscellaneous Remarks, with discussion of possible user errors.

  Please see [encapsulate] if you intend to use defattach but are not
  already familiar with the use of encapsulate to introduce
  constrained functions.  It may also be helpful to see [evaluation].

  See community book books/misc/defattach-example.lisp for a small
  example.  it illustrates how defattach may be used to build
  something like ``higher-order'' programs, in which constrained
  functions may be refined to different executable functions.  More
  uses of defattach may be found in the ACL2 source code,
  specifically, file boot-strap-pass-2-a.lisp.


Introductory Example.

  We begin with a short log illustrating the use of defattach.  Notice
  that after evaluating the event (defattach f g), a call of the
  constrained function f is evaluated by instead calling g on the
  arguments.

    ACL2 !>(encapsulate
            ((f (x) t :guard (true-listp x)))
            (local (defun f (x) x))
            (defthm f-property
              (implies (consp x) (consp (f x)))))
    [... output omitted ...]
     T
    ACL2 !>(defun g (x)
             (declare (xargs :guard (or (consp x) (null x))))
             (cons 17 (car x)))
    [... output omitted ...]
     G
    ACL2 !>(f '(3 4)) ; undefined function error

    ACL2 Error in TOP-LEVEL:  ACL2 cannot ev the call of undefined function
    F on argument list:

    ((3 4))

    To debug see :DOC print-gv, see :DOC trace, and see :DOC wet.

    ACL2 !>(defattach f g)
    [... output omitted ...]
     :ATTACHMENTS-RECORDED
    ACL2 !>(f '(3 4)) ; f is evaluated using g
    (17 . 3)
    ACL2 !>(trace$ f g)
     ((F) (G))
    ACL2 !>(f '(3 4)) ; f is evaluated using g
    1> (ACL2_*1*_ACL2::F (3 4))
      2> (ACL2_*1*_ACL2::G (3 4))
        3> (G (3 4))
        <3 (G (17 . 3))
      <2 (ACL2_*1*_ACL2::G (17 . 3))
    <1 (ACL2_*1*_ACL2::F (17 . 3))
    (17 . 3)
    ACL2 !>(defattach f nil) ; unattach f (remove its attachment)
    [... output omitted ...]
     :ATTACHMENTS-RECORDED
    ACL2 !>(f '(3 4)) ; undefined function error once again
    1> (ACL2_*1*_ACL2::F (3 4))

    ACL2 Error in TOP-LEVEL:  ACL2 cannot ev the call of undefined function
    F on argument list:

    ((3 4))

    To debug see :DOC print-gv, see :DOC trace, and see :DOC wet.

    ACL2 !>


Syntax and Semantics of Defattach.

  The log above shows that the event (defattach f g) allows g to be
  used for evaluating calls of f.  From a logical perspective, the
  evaluation takes place in the addition to the current session of an
  ``attachment equation'' axiom (universally quantified over all x)
  for each defattach event:

    (equal (f x) (g x)) ;;; attachment equation axiom for (defattach f g)

  Below we explain defattach in some detail.  But it is important to
  keep in mind that evaluation with the attachment equations takes
  place in an extension of the logical theory of the session.  ACL2
  guarantees that this so-called ``evaluation theory'' remains
  consistent, assuming the absence of [defaxiom] [events] from the
  user.  This guarantee is a consequence of a more general guarantee:
  an ACL2 logical [world] exists in which (loosely speaking) the
  attachment equation for (defattach f g), as (defun f (...) (g
  ...)), takes the place of the original defining event for f, for
  each defattach event.  This more general guarantee holds even if
  there are [defaxiom] events, though as explained below, no function
  symbol that syntactically supports a defaxiom formula is allowed to
  get an attachment.  A deeper discussion of the logical issues is
  available (but not intended to be read by most users) in a long
  comment in the ACL2 source code labeled ``Essay on Defattach.''

    Example Forms:
    (defattach f g)   ; call g in place of calling constrained function f
    (defattach (f g)) ; same as just above
    (defattach (f g :hints ((\"Goal\" :in-theory (enable foo)))))
                      ; equivalent to first form above, except with hints for the
                      ; proof that the guard of f implies the guard of g
    (defattach (f g :hints ((\"Goal\" :in-theory (enable foo)))
                    :otf-flg t))
                      ; as above, except with an :otf-flg of t for the proof that
                      ; the guard of f implies the guard of g
    (defattach (f g)
               :hints ((\"Goal\" :use my-thm)))
                      ; equivalent to first form above, except with hints for the
                      ; proof that the constraints on f hold for g
    (defattach (f g)
               :hints ((\"Goal\" :use my-thm))
               :otf-flg t)
                      ; as above, except with an :otf-flg of t for the proof that
                      ; the constraints on f hold for g
    (defattach (f g)
               (h j)) ; Attach g to f and attach j to h
    (defattach (f g :attach nil)
               (h j)) ; Same as just above, including the same proof obligations,
                      ; except for one difference: because of :attach nil, calls
                      ; of f will not be evaluated, i.e., there will be no
                      ; executable attachment of g to f
    (defattach (f nil)
               (h j)) ; Attach j to h and unattach f
    (defattach (f g :hints ((\"Goal\" :in-theory (enable foo))))
               (h j :hints ((\"Goal\" :in-theory (enable bar))))
               :hints ((\"Goal\" :use my-thm)))
                      ; Attach g to f and attach j to h, with hints:
                      ; - For proving that the guard of f implies the guard of g,
                      ;   enable foo;
                      ; - For proving that the guard of h implies the guard of j,
                      ;   enable bar; and
                      ; - For proving that the constraints on f and h hold for
                      ;   g and j (respectively), use theorem my-thm.

    (defattach f nil)   ; remove the attachment of f, if any (e.g., g above)
    (defattach (f nil)) ; same as just above

    General Forms:
    (defattach f g)   ; single attach or, if g is nil, unattach
    (defattach (f1 g1 :kwd11 val11 ...)
               ...
               (fk gk :kwdk1 valk1 ...)
               :kwd1 val1 ...)

  where each indicated keyword-value pair is optional and each keyword
  is in the list (:hints :instructions :otf-flg :attach :skip-checks
  :system-ok).  We distinguish between keywords within the (fi gi
  :kwdi1 vali1 ...), which we call guard keywords, and keywords at
  the top level, shown above as :kwd1 val1 ..., which we call
  top-level keywords.

    * The guard keywords are in the list (:hints :instructions :otf-flg
      :attach).  The :[hints], :[instructions], and :[otf-flg]
      keywords in (fi gi ...) are used in the proofs of the guard
      proof obligation for the attachment of gi to fi.  They have
      their usual values and meanings, as when used (for example) in
      [defthm] [events].  The value of each :attach keyword is either
      t or nil.  We discuss the :attach keyword later in this
      [documentation] topic.
    * The top-level keywords :hints, :instructions, and :otf-flg are used
      in the constraint proof obligations just as described above for
      the guard proof obligations.  When :attach is used as a
      top-level keyword, its value serves as a default for entries
      (fi gi ...) that do not specify :attach.  :Skip-checks and
      :system-ok are described below.

  No keyword may occur twice in the same context: that is, neither
  twice as a guard keyword in the same (fi gi ...) entry, nor twice
  as a top-level keyword.  Moreover, :instructions may not occur in
  the same context with :hints or :otf-flg.

  The argument :skip-checks t enables easy experimentation with
  defattach, by permitting use of :[program] mode functions and the
  skipping of semantic checks.  Also permitted is :skip-checks nil
  (the default) and :skip-checks :cycles, which turns off only the
  update of the extended ancestor relation and hence the check for
  cycles in this relation; see below.  We do not make any logical
  claims when the value of :skip-checks is non-nil; indeed, a trust
  tag is then required (see [defttag]).  Note that the interaction of
  [memoization] and attachments is not tracked for attachments
  introduced with a non-nil value of :skip-checks.  For more
  discussion of :skip-checks t, see [defproxy]; we do not discuss
  :skip-checks further, here.

  The argument :system-ok t allows attachment to system functions.
  Without this argument, the defattach event will fail if any fi is a
  built-in ACL2 function.  Rather than supplying this argument
  directly, it is recommended to use [defattach-system], which has
  the same syntax as defattach with two exceptions: it adds
  :system-ok t automatically, that is, :system-ok is implicit; and it
  expands to a [local] call of defattach.  The latter is important so
  that the attachment does not affect system behavior outside a book
  containing the defattach event.  Of course, if it is truly intended
  to affect such behavior, the argument :system-ok t may be given
  directly to defattach, without a surrounding use of local.

  The first General Form above is simply an abbreviation for the form
  (defattach (f g)), which is an instance of the second General Form
  above.  For the second General Form we say that gi is ``attached
  to'' fi (by the defattach event) if gi is not nil, and otherwise we
  say that fi is ``unattached'' (by the defattach event).  It is also
  convenient to refer to <fi,gi> as an ``attachment pair'' (of the
  event) if gi is not nil.  We may refer to the set of fi as the
  ``attachment nest'' of each fi.

  We start with a brief introduction to the first General Form in the
  case that g is not nil.  This form arranges that during evaluation,
  with exceptions noted below, every call of the constrained function
  symbol f will in essence be replaced by a call of the function
  symbol g on the same arguments.  We may then refer to g as the
  ``attachment of'' f, or say that ``g is attached to f.'' Notable
  exceptions, where we do not use attachments during evaluation, are
  for macroexpansion, evaluation of [defconst] and [defpkg] terms,
  evaluation during [table] events, some [stobj] operations including
  all updates (see [STOBJ]), and especially evaluation of ground
  terms (terms without free variables) during proofs.  However, even
  for these cases we allow the use of attachments in the first
  argument of [prog2$] and, more generally, the next-to-last (i.e.,
  second) argument of [return-last] when its first argument is not of
  the form 'm for some macro, m.

  To see why attachments are disallowed during evaluation of ground
  terms during proofs (except for the [prog2$] and [return-last]
  cases mentioned above), consider the following example.

    (defstub f (x) t)
    (defun g (x) (+ 3 x))
    (defattach f g)

  If the form (f 2) is submitted at the ACL2 prompt, the result will be
  5 because the attachment g of f is called on the argument, 2.
  However, during a proof the term (f 2) will not be simplified to 5,
  since that would be unsound, as there are no axioms about f that
  would justify such a simplification.

  For the case that g is nil in the first General Form above, the
  result is the removal of the existing attachment to f, if any.
  After this removal, calls of f will once again cause errors saying
  that ``ACL2 cannot ev the call of undefined function f ...''.  In
  this case not only is the previous attachment to f removed;
  moreover, for every function symbol f' in the attachment nest of f
  in the defattach event that introduced the existing attachment to
  f, then f' is unattached.  (An example near the end of this
  [documentation] topic shows why this unattachment needs to be
  done.) Such removal takes place before the current defattach is
  processed, but is restored if the new event fails to be admitted.

  We focus henceforth on the second General Form.  There must be at
  least one attachment, i.e., i must be at least 1.  All keywords are
  optional; their role is described below.  The fi must be distinct
  constrained function symbols, that is, function symbols all
  introduced in [signature]s of [encapsulate] [events] (or macros
  such as [defstub] that generate [encapsulate] events).  Each
  non-nil gi is a :[logic]-mode function symbol that has had its
  guards verified, with the same [signature] as fi (though formal
  parameters for fi and gi may have different names).  (Note: The
  macro defattach!, defined in community book
  books/misc/defattach-bang, avoids this restriction.)  This event
  generates proof obligations and an ordering check, both described
  below.  The effect of this event is first to remove any existing
  attachments for all the function symbols fi, as described above for
  the first General Form, and then to attach each gi to fi.

  Proof obligations must be checked before making attachments.  For
  this discussion we assume that each gi is non-nil (otherwise first
  remove all attachment pairs <fi,gi> for which gi is nil).  Let s be
  the functional substitution mapping each fi to gi.  For any term u,
  we write u\\s for the result of applying s to u; that is, u\\s is the
  ``functional instance'' obtained by replacing each fi by gi in u.
  Let G_fi and G_gi be the guards of fi and gi, respectively.  Let
  G_fi' be the result of replacing each formal of fi by the
  corresponding formal of gi in G_fi.  ACL2 first proves, for each i
  (in order), the formula (implies G_fi' G_gi)\\s.  If this sequence
  of proofs succeeds, then the remaining formula to prove is the
  functional instance C\\s of the conjunction C of the constraints on
  the symbols fi; see [constraint].  This last proof obligation is
  thus similar to the one generated by functional instantiation (see
  [constraint]).  As with functional instantiation, ACL2 stores the
  fact that such proofs have been done so that they are avoided in
  future events (see [lemma-instance]).  Thus, you will likely avoid
  some proofs with the sequence

    (defattach f g)
    (defattach f nil)
    (defattach f g)
    (defattach f nil)
    ...

  rather than the sequence:

    (defattach f g)
    :u
    (defattach f g)
    :u
    ...

  It remains to describe an ordering check.  We begin with the
  following motivating example.

    (defstub f (x) t) ; constrained function with no constraints
    (defun g (x) (declare (xargs :guard t)) (not (f x)))
    (defattach f g) ; ILLEGAL!

  Were the above defattach event to succeed, the evaluation theory
  (discussed above) would be inconsistent: (f x) equals (g x) by the
  new attachment equation, which in turn equals (not (f x)) by
  definition of g.  The evaluation would therefore be meaningless.
  Also, from a practical perspective, there would be an infinite loop
  resulting from any call of f.

  We consider a function symbol g to be an ``extended immediate
  ancestor of'' a function symbol f if either of the following two
  criteria is met: (a) g occurs in the formula that introduces f
  (i.e., definition body or constraint) and g is introduced by an
  event different from (earlier than) the event introducing f; or (b)
  g is attached to f.  For a proposed defattach event, we check that
  this relation has no cycles, where for condition (b) we include all
  attachment pairs that would result, including those remaining from
  earlier defattach events.

  Of course, a special case is that no function symbol may be attached
  to itself.  Similarly, no function symbol may be attached to any of
  its ``siblings'' --- function symbols introduced by the same event
  --- as siblings are considered equivalent for purposes of the
  acyclicity check.


Three Primary Uses of Defattach.

  We anticipate three uses of defattach:

   1. Constrained function execution
   2. Sound modification of the ACL2 system
   3. Program refinement

  We discuss these in turn.

   1. The example at the beginning of this [documentation] illustrates
      constrained function execution.
   2. ACL2 is written essentially in itself.  Thus, there is an opportunity
      to attaching to system functions.  For example, encapsulated
      function too-many-ifs-post-rewrite, in the ACL2 source code,
      receives an attachment of too-many-ifs-post-rewrite-builtin,
      which implements a heuristic used in the rewriter.  To find all
      such examples, search the source code for the string
      `-builtin'.
      Over time, we expect to continue replacing ACL2 source code in a
      similar manner.  We invite the ACL2 community to assist in this
      ``open architecture'' enterprise; feel free to email the ACL2
      implementors if you are interested in such activity.
   3. Recall that for an attachment pair <f,g>, a proof obligation is
      (speaking informally) that g satisfies the constraint on f.
      Yet more informally speaking, g is ``more defined'' than f; we
      can think of g as ``refining'' f.  With these informal notions
      as motivation, we can view defattach as providing refinement
      through the following formal observation: the evaluation theory
      extends the theory of the ACL2 session, specifically by the
      addition of all attachment equations.  For the logic-inclined,
      it may be useful to think model-theoretically: The class of
      models of the evaluation theory is non-empty but is a subset of
      the class of models of the current session theory.


Miscellaneous Remarks, with discussion of possible user errors.

  We conclude with remarks on some details.

  A defattach event is never redundant (see [redundant-events]); in
  that sense it is analogous to [in-theory].

  As mentioned above, the use of attachments is disabled for evaluation
  of ground terms during proofs.  However, attachments can be used on
  code during the proof process, essentially when the ``program
  refinement'' is on theorem prover code rather than on functions we
  are reasoning about.  The attachment to too-many-ifs-post-rewrite
  described above provides one example of such attachments.  Meta
  functions and clause-processor functions can also have attachments,
  with the restriction that no common ancestor with the evaluator can
  have an attachment; see [evaluator-restrictions].

  For an attachment pair <f,g>, evaluation of f never consults the
  [guard] of f.  Rather, control passes to g, whose guard is checked
  if necessary.  The proof obligation related to guards, as described
  above, guarantees that any legal call of f is also a legal call of
  g.  Thus for guard-verified code that results in calls of f in raw
  Lisp, it is sound to replace these calls with corresponding calls
  of g.

  Defattach events are illegal inside any [encapsulate] event with a
  non-empty [signature] unless they are [local] to the [encapsulate].

  (Of interest only to users of [apply$].)  Special handling is applied
  when attempting to attach to a so-called warrant, which is produced
  by an appication of [defwarrant] (or [defun$]).  In that case it is
  legal to attach the function true-apply$-warrant to the warrant,
  without any proof obligation.  This attachment is actually
  performed automatically by defwarrant, so users (even users of
  apply$) need not deal explicitly with such attachments.  However,
  these attachments make warrants executable in the loop; for
  example, after (defwarrant foo), (warrant foo) will evaluate to t
  in the loop.

  We next discuss a restriction based on a notion of a function symbol
  syntactically supporting an event.  Function symbol f is ancestral
  in event E if either f occurs in E, or (recursively) f occurs in an
  event E' that introduces some function symbol g that is ancestral
  in E.  We require that no function symbol ancestral in the formula
  of a [defaxiom] event may have an attachment.  Theoretical reasons
  are discussed in comments in the ACL2 source code, but here we give
  a little example showing the need for some such restriction:
  without it, we show how to prove nil!

    (defn g1 () 1)
    (defn g2 () 2)
    (defstub f1 () t)
    (defstub f2 () t)
    (defund p (x)
      (declare (ignore x))
      t)
    (defevaluator evl evl-list
      ((p x)))
    (defaxiom f1-is-f2
      (equal (f1) (f2)))
    (defun meta-fn (x)
      (cond ((equal (f1) (f2))
             x)
            (t *nil*)))
    (defthm bad-meta-rule
      (equal (evl x a)
             (evl (meta-fn x) a))
      :rule-classes ((:meta :trigger-fns (p))))
    (defattach f1 g1)
    (defattach f2 g2)
    (defthm contradiction
      nil
      :hints ((\"Goal\" :use ((:instance (:theorem (not (p x)))
                                       (x t)))))
      :rule-classes nil)

  The form (all-attachments (w state)) evaluates to the list of all
  attachments except in two cases: [warrant]s, and attachments
  introduced with a non-nil value of :skip-checks.  To obtain the
  attachment to a function symbol FN, without the above restrictions
  and with value nil if there is no attachment to FN: (cdr
  (attachment-pair 'FN (w state))).

  Next we discuss the :ATTACH keyword.  There is rarely if ever a
  reason to specify :ATTACH T, but the following (admittedly
  contrived) example shows why it may be necessary to specify :ATTACH
  NIL.  First we introduce three new function symbols.

    (defstub f (x) t)

    (defun g (x)
      (f x))

    (encapsulate ((h (x) t))
      (local (defun h (x) (g x)))
      (defthm h-prop
        (equal (h x) (g x))))

  Now suppose we want to attach the function [ACL2-numberp] to both f
  and h.

    (defattach (f acl2-numberp) (h acl2-numberp))

  Such an attempt fails, because the following constraint is generated
  but is not a theorem: (EQUAL (ACL2-NUMBERP X) (G X)).  Clearly we
  also need to attach to g as well.

    (defattach (f acl2-numberp) (h acl2-numberp) (g acl2-numberp))

  But this fails for a different reason, as explained by the error
  message:

    ACL2 Error in ( DEFATTACH (F ACL2-NUMBERP) ...):  It is illegal to
    attach to function symbol G, because it was introduced with DEFUN.
    See :DOC defattach.

  That is: logically, we need to attach acl2-numberp to g, but we
  cannot actually attach to g because it was not introduced with
  [encapsulate] (it was introduced with [defun]).  So we specify
  :ATTACH NIL for the attachment to g, saying that no actual
  attachment should be made to the code for g, even though for
  logical purposes we should consider that g has been given the
  indicated attachment.

    (defattach (f acl2-numberp) (h acl2-numberp) (g acl2-numberp :attach nil))

  Finally, we can check that f, g, and h execute as expected.

    ACL2 !>(assert-event (and (f 3)
                       (not (f t))
                       (g 3)
                       (not (g t))
                       (h 3)
                       (not (h t))))
     :PASSED
    ACL2 !>

  The advanced feature, [with-global-stobj], imposes certain
  restrictions on a defattach event.  You can probably ignore this
  point unless you get an error pertaining to with-global-stobj.  For
  relevant documentation see [with-global-stobj], specifically the
  section on ``Constrained Functions and Defattach''.

  We conclude with an example promised above, showing why it is
  necessary in general to unattach all function symbols in an
  existing attachment nest when unattaching any one of those function
  symbols.  Consider the following example.

    (defstub f1 () t)
    (encapsulate ((f2 () t))
      (local (defun f2 () (f1)))
      (defthm f2=f1 (equal (f2) (f1))))
    (encapsulate ((f3 () t))
      (local (defun f3 () (f1)))
      (defthm f3=f1 (equal (f3) (f1))))
    (defun four () (declare (xargs :guard t)) 4)
    (defun five () (declare (xargs :guard t)) 5)
    (defattach (f1 four) (f2 four))
    (defattach (f1 five) (f3 five))

  The second defattach erases the existing attachment pair <f1,four>
  before installing the new attachment pairs <f1,five> and <f3,five>.
  After the second defattach, both (f1) and (f3) evaluate to 5.  Now
  suppose that the attachment pair <f2,four> were not erased.  Then
  we would have (f1) evaluating to 5 and (f2) evaluating to 4,
  contradicting the constraint f2=f1.  The evaluation theory would
  thus be inconsistent, and at a more concrete level, the user might
  well be surprised by evaluation results if the code were written
  with the assumption specified in the constraint f2=f1.


Subtopics

  [Defattach-system]
      Attach to built-in, system-level, constrained functions

  [Ignored-attachment]
      Why attachments are sometimes not used

  [System-attachments]
      System-level algorithms that users can modify with attachments")
 (DEFATTACH-SYSTEM
  (DEFATTACH)
  "Attach to built-in, system-level, constrained functions

  For background on attachments, see [defattach].  The macro
  defattach-system is a convenient way to attach to built-in
  functions.  The event (defattach f g) will fail if f is built into
  ACL2.  This failure can be overcome by specifying top-level keyword
  argument :system-ok t, for example: (defattach (f g) :system-ok t).
  However, rather than supplying this argument directly, it is
  recommended to use defattach-system, which has the same syntax as
  defattach with two exceptions: it adds :system-ok t automatically,
  that is, :system-ok is implicit; and it expands to a [local] call
  of defattach.  The latter is important so that the attachment does
  not affect system behavior outside a book containing the defattach
  event.  Of course, if it is truly intended to affect such behavior,
  the argument :system-ok t may be given directly to defattach,
  without a surrounding use of local.

  See [system-attachments] for discussion of system attachments.  Also
  see [efficiency] for how to use attachments to modify the prover's
  behavior.")
 (DEFAULT
  (ARRAYS ACL2-BUILT-INS)
  "Return the :default from the [header] of a 1- or 2-dimensional array

    Example Form:
    (default 'delta1 a)

    General Form:
    (default name alist)

  where name is an arbitrary object and alist is a 1- or 2-dimensional
  array.  This function returns the contents of the :default field of
  the [header] of alist.  When [aref1] or [aref2] is used to obtain a
  value for an index (or index pair) not bound in alist, the default
  value is returned instead.  Thus, the array alist may be thought of
  as having been initialized with the default value.  default
  operates in virtually constant time if alist is the semantic value
  of name.  See [arrays].

  Function: <default>

    (defun
         default (name l)
         (declare (xargs :guard (or (array1p name l) (array2p name l))))
         (cadr (assoc-keyword :default (cdr (header name l)))))")
 (DEFAULT-BACKCHAIN-LIMIT
  (RULE-CLASSES)
  "Specifying the backchain limit for a rule

  See [backchain-limit].

  The initial value is (nil nil).  To inspect the current value (as
  explained elsewhere; see [backchain-limit]):

    (default-backchain-limit wrld :ts) ; for type-set reasoning
    (default-backchain-limit wrld :rewrite) ; for rewriting")
 (DEFAULT-DEFUN-MODE
  (MISCELLANEOUS)
  "The default [defun-mode] of [defun]'d functions

  When a [defun] is processed and no :mode xarg is supplied, the
  function default-defun-mode is used.  To find the default
  [defun-mode] of the current ACL2 [world], type (default-defun-mode
  (w state)).  See [defun-mode] for a discussion of [defun-mode]s.
  To change the default [defun-mode] of the ACL2 [world], type one of
  the keywords :[program] or :[logic].

  The default ACL2 [prompt] displays the current default [defun-mode]
  by showing the character p for :[program] mode, and omitting it for
  :[logic] mode; see [default-print-prompt].  The default
  [defun-mode] may be changed using the keyword [command]s :[program]
  and :[logic], which are equivalent to the [command]s (program) and
  (logic).  Each of these names is documented separately: see
  [program] and see [logic].  The default [defun-mode] is stored in
  the [table] [ACL2-defaults-table] and hence may also be changed by
  a [table] [command].  See [table] and also see
  [ACL2-defaults-table].  Both mode-changing [command]s are [events].

  While [events] that change the default [defun-mode] are permitted
  within an [encapsulate] or the text of a book, their effects are
  [local] in scope to the duration of the encapsulation or inclusion.
  For example, if the default [defun-mode] is :[logic] and a book is
  included that contains the event (program), then subsequent
  [events] within the book are processed with the default
  [defun-mode] :[program]; but when the [include-book] event
  completes, the default [defun-mode] will still be :[logic].
  [Command]s that change the default [defun-mode] are not permitted
  inside [local] forms.")
 (DEFAULT-HINTS
  (HINTS)
  "A list of hints added to every proof attempt

    Examples:
    ACL2 !>(default-hints (w state))
    ((computed-hint-1 clause)
     (computed-hint-2 clause stable-under-simplificationp))

  The value returned by this function is added to the right of the
  :[hints] argument of every [defthm] and [thm] command, and to hints
  provided to [defun]s as well (:hints, :guard-hints, and (for
  ACL2(r)) :std-hints).

  See [set-default-hints] for a more general discussion.  Advanced
  users only: see [override-hints] for an advanced variant of default
  hints that are not superseded by :[hints] arguments.


Subtopics

  [Add-default-hints]
      Add to the default hints

  [Add-default-hints!]
      Add to the default hints non-[local]ly

  [Default-hints-table]
      A [table] used to provide [hints] for proofs

  [Remove-default-hints]
      Remove from the default hints

  [Remove-default-hints!]
      Remove from the default hints non-[local]ly

  [Set-default-hints]
      Set the default hints

  [Set-default-hints!]
      Set the default hints non-[local]ly")
 (DEFAULT-HINTS-TABLE
  (DEFAULT-HINTS)
  "A [table] used to provide [hints] for proofs

  Please see [set-default-hints], see [add-default-hints], and see
  [remove-default-hints] for how to use this table.  For
  completeness, we mentio