(in-package "ACL2")

(include-book "lop2")

; The following is not strictly necessary.  But with the (current)
; default setting of (500 100) the proof of BITN-LAM0, below, takes
; several times longer than it does with the setting of nil.  The
; reason is that if no limit is imposed, the subsumption/replacement
; loop is used to pare down over 2500 clauses into under 500, while if
; a small limit is imposed then all 2500 are attacked by the rewriter.

(set-case-split-limitations nil)

(defun LAMT (a b e)
  (logxor a (comp1 b (1+ e))))

(defun LAMG (a b e)
  (logand a (comp1 b (1+ e))))

(defun LAMZ (a b e)
  (comp1 (logior a (comp1 b (1+ e))) (1+ e)))

(defun LAM1 (a b e)
  (logand (bits (lamt a b e) e 2)
	  (logand (bits (lamg a b e) (1- e) 1)
		  (comp1 (bits (lamz a b e) (- e 2) 0) (1- e)))))

(defun LAM2 (a b e)
  (logand (comp1 (bits (lamt a b e) e 2) (1- e))
	  (logand (bits (lamz a b e) (1- e) 1)
		  (comp1 (bits (lamz a b e) (- e 2) 0) (1- e)))))

(defun LAM3 (a b e)
  (logand (bits (lamt a b e) e 2)
	  (logand (bits (lamz a b e) (1- e) 1)
		  (comp1 (bits (lamg a b e) (- e 2) 0) (1- e)))))

(defun LAM4 (a b e)
  (logand (comp1 (bits (lamt a b e) e 2) (1- e))
	  (logand (bits (lamg a b e) (1- e) 1)
		  (comp1 (bits (lamg a b e) (- e 2) 0) (1- e)))))

(defun LAM0 (a b e)
  (logior (lam1 a b e)
	  (logior (lam2 a b e)
		  (logior (lam3 a b e)
			  (lam4 a b e)))))

(defun LAMB (a b e)
  (+ (* 2 (lam0 a b e))
     (comp1 (bitn (lamt a b e) 0) 1)))

(local (defthm bitn-lamt
    (implies (and (integerp a)
		  (> a 0)
		  (integerp b)
		  (> b 0)
		  (not (= a b))
		  (= e (expo a))
		  (= e (expo b))
		  (> e 0)
		  (integerp k)
		  (>= k 0)
		  (<= k e))
	     (iff (= (bitn (lamt a b e) k) 1)
		  (= (c k a b) 0)))
  :rule-classes ()
  :hints (("Goal" :in-theory (disable logxor)
		  :use ((:instance bitn-comp1 (x b) (n (1+ e)))
			(:instance bitn-0-1 (x a) (n k))
			(:instance bitn-0-1 (x b) (n k))
			(:instance bitn-0-1 (x (comp1 b (1+ e))) (n k))
			(:instance expo-upper-bound (x b))
			(:instance bitn-logxor (x a) (y (comp1 b (1+ e))) (n k)))))))

(defthm LAMT-NAT
    (implies (and (integerp a)
		  (> a 0)
		  (integerp b)
		  (> b 0)
		  (not (= a b))
		  (= e (expo a))
		  (= e (expo b))
		  (> e 0))
	     (and (integerp (lamt a b e))
		  (>= (lamt a b e) 0)))
  :rule-classes ()
  :hints (("Goal" :use ((:instance expo-upper-bound (x b))
			(:instance logxor-nat (i a) (j (comp1 b (1+ e))))))))

(local (defthm bitn-lamg
    (implies (and (integerp a)
		  (> a 0)
		  (integerp b)
		  (> b 0)
		  (not (= a b))
		  (= e (expo a))
		  (= e (expo b))
		  (> e 0)
		  (integerp k)
		  (>= k 0)
		  (<= k e))
	     (iff (= (bitn (lamg a b e) k) 1)
		  (= (c k a b) 1)))
  :rule-classes ()
  :hints (("Goal" :in-theory (disable logand)
		  :use ((:instance bitn-comp1 (x b) (n (1+ e)))
			(:instance bitn-0-1 (x a) (n k))
			(:instance bitn-0-1 (x b) (n k))
			(:instance bitn-0-1 (x (comp1 b (1+ e))) (n k))
			(:instance expo-upper-bound (x b))
			(:instance bit-dist-a (x a) (y (comp1 b (1+ e))) (n k)))))))

(defthm LAMG-NAT
    (implies (and (integerp a)
		  (> a 0)
		  (integerp b)
		  (> b 0)
		  (not (= a b))
		  (= e (expo a))
		  (= e (expo b))
		  (> e 0))
	     (and (integerp (lamg a b e))
		  (>= (lamg a b e) 0)))
  :rule-classes ()
  :hints (("Goal" :use ((:instance expo-upper-bound (x b))
			(:instance logand-nat (i a) (j (comp1 b (1+ e))))))))

(local (defthm bitn-lamz-1
    (implies (and (integerp a)
		  (> a 0)
		  (integerp b)
		  (> b 0)
		  (not (= a b))
		  (= e (expo a))
		  (= e (expo b))
		  (> e 0)
		  (integerp k)
		  (>= k 0)
		  (<= k e))
	     (iff (= (bitn (logior a (comp1 b (1+ e))) k) 0)
		  (= (c k a b) -1)))
  :rule-classes ()
  :hints (("Goal" :in-theory (disable logior)
		  :use ((:instance bitn-comp1 (x b) (n (1+ e)))
			(:instance bitn-0-1 (x a) (n k))
			(:instance bitn-0-1 (x b) (n k))
			(:instance bitn-0-1 (x (comp1 b (1+ e))) (n k))
			(:instance expo-upper-bound (x b))
			(:instance bit-dist-b (x a) (y (comp1 b (1+ e))) (n k)))))))

(local (defthm bitn-lamz
    (implies (and (integerp a)
		  (> a 0)
		  (integerp b)
		  (> b 0)
		  (not (= a b))
		  (= e (expo a))
		  (= e (expo b))
		  (> e 0)
		  (integerp k)
		  (>= k 0)
		  (<= k e))
	     (iff (= (bitn (lamz a b e) k) 1)
		  (= (c k a b) -1)))
  :rule-classes ()
  :hints (("Goal" :in-theory (disable c logior)
		  :use (bitn-lamz-1
			(:instance bitn-comp1 (x (logior a (comp1 b (1+ e)))) (n (1+ e)))
			(:instance logior-nat (i a) (j (comp1 b (1+ e))))
			(:instance bitn-0-1 (x (lamz a b e)) (n k))
			(:instance bitn-0-1 (x (logior a (comp1 b (1+ e)))) (n k))
			(:instance expo-upper-bound (x b))
			(:instance or-dist-a (x a) (y (comp1 b (1+ e))) (n (1+ e)))
			(:instance expo-upper-bound (x a)))))))

(defthm LAMZ-NAT
    (implies (and (integerp a)
		  (> a 0)
		  (integerp b)
		  (> b 0)
		  (not (= a b))
		  (= e (expo a))
		  (= e (expo b))
		  (> e 0))
	     (and (integerp (lamz a b e))
		  (>= (lamz a b e) 0)))
  :rule-classes ()
  :hints (("Goal" :use ((:instance expo-upper-bound (x b))
			(:instance logior-nat (i a) (j (comp1 b (1+ e))))
			(:instance or-dist-a (x a) (y (comp1 b (1+ e))) (n (1+ e)))
			(:instance expo-upper-bound (x a))))))

(local (in-theory (disable lamt lamz lamg)))

(local (defthm bitn-lam1-1
    (implies (and (integerp a)
		  (> a 0)
		  (integerp b)
		  (> b 0)
		  (not (= a b))
		  (= e (expo a))
		  (= e (expo b))
		  (> e 1)
		  (integerp k)
		  (>= k 0))
	     (equal (bitn (lam1 a b e) k)
		    (logand (bitn (bits (lamt a b e) e 2) k)
			    (logand (bitn (bits (lamg a b e) (1- e) 1) k)
				    (bitn (comp1 (bits (lamz a b e) (- e 2) 0) (1- e)) k)))))
  :hints (("Goal" :in-theory (disable bits logand)
		  :use (lamz-nat
			lamt-nat
			lamg-nat
			(:instance bits-nat (x (lamt a b e)) (i e) (j 2))
			(:instance bits-nat (x (lamg a b e)) (i (1- e)) (j 1))
			(:instance bits-nat (x (lamz a b e)) (i (- e 2)) (j 0))
			(:instance bits< (x (lamz a b e)) (i (- e 2)) (j 0))
			(:instance logand-nat
				   (i (bits (lamg a b e) (1- e) 1))
				   (j (comp1 (bits (lamz a b e) (- e 2) 0) (1- e))))
			(:instance bit-dist-a
				   (x (bits (lamt a b e) e 2))
				   (y (logand (bits (lamg a b e) (1- e) 1)
					      (comp1 (bits (lamz a b e) (- e 2) 0) (1- e))))
				   (n k))
			(:instance bit-dist-a
				   (x (bits (lamg a b e) (1- e) 1))
				   (y (comp1 (bits (lamz a b e) (- e 2) 0) (1- e)))
				   (n k)))))))

(local (defthm bitn-lam1-2
    (implies (and (integerp a)
		  (> a 0)
		  (integerp b)
		  (> b 0)
		  (not (= a b))
		  (= e (expo a))
		  (= e (expo b))
		  (> e 1)
		  (integerp k)
		  (>= k 0))
	     (iff (= (bitn (lam1 a b e) k) 1)
		  (and (= (bitn (bits (lamt a b e) e 2) k) 1)
		       (= (bitn (bits (lamg a b e) (1- e) 1) k) 1)
		       (= (bitn (comp1 (bits (lamz a b e) (- e 2) 0) (1- e)) k) 1))))
  :rule-classes ()
  :hints (("Goal" :in-theory (disable bits lam1 logand)
		  :use ((:instance bitn-0-1 (x (bits (lamt a b e) e 2)) (n k))
			(:instance bitn-0-1 (x (bits (lamg a b e) (1- e) 1)) (n k))
			(:instance bitn-0-1 (x (comp1 (bits (lamz a b e) (- e 2) 0) (1- e))) (n k)))))))

(local (in-theory (disable bitn-lam1-1)))

(local (defthm bitn-lam1-3
    (implies (and (integerp a)
		  (> a 0)
		  (integerp b)
		  (> b 0)
		  (not (= a b))
		  (= e (expo a))
		  (= e (expo b))
		  (> e 1)
		  (integerp k)
		  (<= k (- e 2))
		  (>= k 0))
	     (iff (= (bitn (lam1 a b e) k) 1)
		  (and (= (bitn (bits (lamt a b e) e 2) k) 1)
		       (= (bitn (bits (lamg a b e) (1- e) 1) k) 1)
		       (= (bitn (bits (lamz a b e) (- e 2) 0) k) 0))))
  :rule-classes ()
  :hints (("Goal" :in-theory (disable lam1 bits comp1 logand)
		  :use (lamz-nat
			bitn-lam1-2
			(:instance bits-nat (x (lamz a b e)) (i (- e 2)) (j 0))
			(:instance bits< (x (lamz a b e)) (i (- e 2)) (j 0))
			(:instance bitn-0-1 (x (comp1 (bits (lamz a b e) (- e 2) 0) (1- e))) (n k))
			(:instance bitn-comp1 (x (bits (lamz a b e) (- e 2) 0)) (n (1- e)))
			(:instance bitn-0-1 (x (bits (lamz a b e) (- e 2) 0)) (n k)))))))

(local (defthm bitn-lam1
    (implies (and (integerp a)
		  (> a 0)
		  (integerp b)
		  (> b 0)
		  (not (= a b))
		  (= e (expo a))
		  (= e (expo b))
		  (> e 1)
		  (integerp k)
		  (<= k (- e 2))
		  (>= k 0))
	     (iff (= (bitn (lam1 a b e) k) 1)
		  (and (= (bitn (lamt a b e) (+ k 2)) 1)
		       (= (bitn (lamg a b e) (+ k 1)) 1)
		       (= (bitn (lamz a b e) k) 0))))
  :rule-classes ()
  :hints (("Goal" :in-theory (disable lam1 bits logand)
		  :use (lamz-nat
			lamt-nat
			lamg-nat
			bitn-lam1-3
			(:instance bits-nat (x (lamz a b e)) (i (- e 2)) (j 0))
			(:instance bits< (x (lamz a b e)) (i (- e 2)) (j 0))
			(:instance bitn-0-1 (x (lamz a b e)) (n k))
			(:instance bit-bits-b (x (lamt a b e)) (i e) (j 2))
			(:instance bit-bits-b (x (lamg a b e)) (i (- e 1)) (j 1))
			(:instance bit-bits-b (x (lamz a b e)) (i (- e 2)) (j 0)))))))

(defthm LAM1-NAT
    (implies (and (integerp a)
		  (> a 0)
		  (integerp b)
		  (> b 0)
		  (not (= a b))
		  (= e (expo a))
		  (= e (expo b))
		  (> e 1)
		  (integerp k)
		  (<= k (- e 2))
		  (>= k 0))
	     (and (integerp (lam1 a b e))
		  (>= (lam1 a b e) 0)))
  :rule-classes ()
  :hints (("Goal" :in-theory (disable bits logand)
		  :use (lamz-nat
			lamt-nat
			lamg-nat
			(:instance bits-nat (x (lamt a b e)) (i e) (j 2))
			(:instance bits-nat (x (lamg a b e)) (i (1- e)) (j 1))
			(:instance bits-nat (x (lamz a b e)) (i (- e 2)) (j 0))
			(:instance bits< (x (lamz a b e)) (i (- e 2)) (j 0))
			(:instance logand-nat
				   (i (bits (lamt a b e) e 2))
				   (j (logand (bits (lamg a b e) (1- e) 1)
					      (comp1 (bits (lamz a b e) (- e 2) 0) (1- e)))))
			(:instance logand-nat
				   (i (bits (lamg a b e) (1- e) 1))
				   (j (comp1 (bits (lamz a b e) (- e 2) 0) (1- e))))))))

(local (defthm bitn-lam3-1
    (implies (and (integerp a)
		  (> a 0)
		  (integerp b)
		  (> b 0)
		  (not (= a b))
		  (= e (expo a))
		  (= e (expo b))
		  (> e 1)
		  (integerp k)
		  (>= k 0))
	     (equal (bitn (lam3 a b e) k)
		    (logand (bitn (bits (lamt a b e) e 2) k)
			    (logand (bitn (bits (lamz a b e) (1- e) 1) k)
				    (bitn (comp1 (bits (lamg a b e) (- e 2) 0) (1- e)) k)))))
  :hints (("Goal" :in-theory (disable bits logand)
		  :use (lamg-nat
			lamt-nat
			lamz-nat
			(:instance bits-nat (x (lamt a b e)) (i e) (j 2))
			(:instance bits-nat (x (lamz a b e)) (i (1- e)) (j 1))
			(:instance bits-nat (x (lamg a b e)) (i (- e 2)) (j 0))
			(:instance bits< (x (lamg a b e)) (i (- e 2)) (j 0))
			(:instance logand-nat
				   (i (bits (lamz a b e) (1- e) 1))
				   (j (comp1 (bits (lamg a b e) (- e 2) 0) (1- e))))
			(:instance bit-dist-a
				   (x (bits (lamt a b e) e 2))
				   (y (logand (bits (lamz a b e) (1- e) 1)
					      (comp1 (bits (lamg a b e) (- e 2) 0) (1- e))))
				   (n k))
			(:instance bit-dist-a
				   (x (bits (lamz a b e) (1- e) 1))
				   (y (comp1 (bits (lamg a b e) (- e 2) 0) (1- e)))
				   (n k)))))))

(local (defthm bitn-lam3-2
    (implies (and (integerp a)
		  (> a 0)
		  (integerp b)
		  (> b 0)
		  (not (= a b))
		  (= e (expo a))
		  (= e (expo b))
		  (> e 1)
		  (integerp k)
		  (>= k 0))
	     (iff (= (bitn (lam3 a b e) k) 1)
		  (and (= (bitn (bits (lamt a b e) e 2) k) 1)
		       (= (bitn (bits (lamz a b e) (1- e) 1) k) 1)
		       (= (bitn (comp1 (bits (lamg a b e) (- e 2) 0) (1- e)) k) 1))))
  :rule-classes ()
  :hints (("Goal" :in-theory (disable bits lam3 logand)
		  :use ((:instance bitn-0-1 (x (bits (lamt a b e) e 2)) (n k))
			(:instance bitn-0-1 (x (bits (lamz a b e) (1- e) 1)) (n k))
			(:instance bitn-0-1 (x (comp1 (bits (lamg a b e) (- e 2) 0) (1- e))) (n k)))))))

(local (in-theory (disable bitn-lam3-1)))

(local (defthm bitn-lam3-3
    (implies (and (integerp a)
		  (> a 0)
		  (integerp b)
		  (> b 0)
		  (not (= a b))
		  (= e (expo a))
		  (= e (expo b))
		  (> e 1)
		  (integerp k)
		  (<= k (- e 2))
		  (>= k 0))
	     (iff (= (bitn (lam3 a b e) k) 1)
		  (and (= (bitn (bits (lamt a b e) e 2) k) 1)
		       (= (bitn (bits (lamz a b e) (1- e) 1) k) 1)
		       (= (bitn (bits (lamg a b e) (- e 2) 0) k) 0))))
  :rule-classes ()
  :hints (("Goal" :in-theory (disable lam3 bits comp1 logand)
		  :use (lamg-nat
			bitn-lam3-2
			(:instance bits-nat (x (lamg a b e)) (i (- e 2)) (j 0))
			(:instance bits< (x (lamg a b e)) (i (- e 2)) (j 0))
			(:instance bitn-0-1 (x (comp1 (bits (lamg a b e) (- e 2) 0) (1- e))) (n k))
			(:instance bitn-comp1 (x (bits (lamg a b e) (- e 2) 0)) (n (1- e)))
			(:instance bitn-0-1 (x (bits (lamg a b e) (- e 2) 0)) (n k)))))))

(local (defthm bitn-lam3
    (implies (and (integerp a)
		  (> a 0)
		  (integerp b)
		  (> b 0)
		  (not (= a b))
		  (= e (expo a))
		  (= e (expo b))
		  (> e 1)
		  (integerp k)
		  (<= k (- e 2))
		  (>= k 0))
	     (iff (= (bitn (lam3 a b e) k) 1)
		  (and (= (bitn (lamt a b e) (+ k 2)) 1)
		       (= (bitn (lamz a b e) (+ k 1)) 1)
		       (= (bitn (lamg a b e) k) 0))))
  :rule-classes ()
  :hints (("Goal" :in-theory (disable lam3 bits logand)
		  :use (lamg-nat
			lamt-nat
			lamz-nat
			bitn-lam3-3
			(:instance bits-nat (x (lamg a b e)) (i (- e 2)) (j 0))
			(:instance bits< (x (lamg a b e)) (i (- e 2)) (j 0))
			(:instance bitn-0-1 (x (lamg a b e)) (n k))
			(:instance bit-bits-b (x (lamt a b e)) (i e) (j 2))
			(:instance bit-bits-b (x (lamz a b e)) (i (- e 1)) (j 1))
			(:instance bit-bits-b (x (lamg a b e)) (i (- e 2)) (j 0)))))))

(defthm LAM3-NAT
    (implies (and (integerp a)
		  (> a 0)
		  (integerp b)
		  (> b 0)
		  (not (= a b))
		  (= e (expo a))
		  (= e (expo b))
		  (> e 1)
		  (integerp k)
		  (<= k (- e 2))
		  (>= k 0))
	     (and (integerp (lam3 a b e))
		  (>= (lam3 a b e) 0)))
  :rule-classes ()
  :hints (("Goal" :in-theory (disable bits logand)
		  :use (lamg-nat
			lamt-nat
			lamz-nat
			(:instance bits-nat (x (lamt a b e)) (i e) (j 2))
			(:instance bits-nat (x (lamz a b e)) (i (1- e)) (j 1))
			(:instance bits-nat (x (lamg a b e)) (i (- e 2)) (j 0))
			(:instance bits< (x (lamg a b e)) (i (- e 2)) (j 0))
			(:instance logand-nat
				   (i (bits (lamt a b e) e 2))
				   (j (logand (bits (lamz a b e) (1- e) 1)
					      (comp1 (bits (lamg a b e) (- e 2) 0) (1- e)))))
			(:instance logand-nat
				   (i (bits (lamz a b e) (1- e) 1))
				   (j (comp1 (bits (lamg a b e) (- e 2) 0) (1- e))))))))

(local (defthm bitn-lam2-1
    (implies (and (integerp a)
		  (> a 0)
		  (integerp b)
		  (> b 0)
		  (not (= a b))
		  (= e (expo a))
		  (= e (expo b))
		  (> e 1)
		  (integerp k)
		  (>= k 0))
	     (equal (bitn (lam2 a b e) k)
		    (logand (bitn (comp1 (bits (lamt a b e) e 2) (1- e)) k)
			    (logand (bitn (bits (lamz a b e) (1- e) 1) k)
				    (bitn (comp1 (bits (lamz a b e) (- e 2) 0) (1- e)) k)))))
  :hints (("Goal" :in-theory (disable bits logand)
		  :use (lamz-nat
			lamt-nat
			(:instance bits-nat (x (lamt a b e)) (i e) (j 2))
			(:instance bits< (x (lamt a b e)) (i e) (j 2))
			(:instance bits-nat (x (lamz a b e)) (i (1- e)) (j 1))
			(:instance bits-nat (x (lamz a b e)) (i (- e 2)) (j 0))
			(:instance bits< (x (lamz a b e)) (i (- e 2)) (j 0))
			(:instance logand-nat
				   (i (bits (lamz a b e) (1- e) 1))
				   (j (comp1 (bits (lamz a b e) (- e 2) 0) (1- e))))
			(:instance bit-dist-a
				   (x (comp1 (bits (lamt a b e) e 2) (1- e)))
				   (y (logand (bits (lamz a b e) (1- e) 1)
					      (comp1 (bits (lamz a b e) (- e 2) 0) (1- e))))
				   (n k))
			(:instance bit-dist-a
				   (x (bits (lamz a b e) (1- e) 1))
				   (y (comp1 (bits (lamz a b e) (- e 2) 0) (1- e)))
				   (n k)))))))

(local (defthm bitn-lam2-2
    (implies (and (integerp a)
		  (> a 0)
		  (integerp b)
		  (> b 0)
		  (not (= a b))
		  (= e (expo a))
		  (= e (expo b))
		  (> e 1)
		  (integerp k)
		  (>= k 0))
	     (iff (= (bitn (lam2 a b e) k) 1)
		  (and (= (bitn (comp1 (bits (lamt a b e) e 2) (1- e)) k) 1)
		       (= (bitn (bits (lamz a b e) (1- e) 1) k) 1)
		       (= (bitn (comp1 (bits (lamz a b e) (- e 2) 0) (1- e)) k) 1))))
  :rule-classes ()
  :hints (("Goal" :in-theory (disable bits lam2 logand)
		  :use ((:instance bitn-0-1 (x (comp1 (bits (lamt a b e) e 2) (1- e))) (n k))
			(:instance bitn-0-1 (x (bits (lamz a b e) (1- e) 1)) (n k))
			(:instance bitn-0-1 (x (comp1 (bits (lamz a b e) (- e 2) 0) (1- e))) (n k)))))))

(local (in-theory (disable bitn-lam2-1)))

(local (defthm bitn-lam2-3
    (implies (and (integerp a)
		  (> a 0)
		  (integerp b)
		  (> b 0)
		  (not (= a b))
		  (= e (expo a))
		  (= e (expo b))
		  (> e 1)
		  (integerp k)
		  (<= k (- e 2))
		  (>= k 0))
	     (iff (= (bitn (lam2 a b e) k) 1)
		  (and (= (bitn (bits (lamt a b e) e 2) k) 0)
		       (= (bitn (bits (lamz a b e) (1- e) 1) k) 1)
		       (= (bitn (bits (lamz a b e) (- e 2) 0) k) 0))))
  :rule-classes ()
  :hints (("Goal" :in-theory (disable lam2 bits comp1 logand)
		  :use (lamz-nat
			lamt-nat
			bitn-lam2-2
			(:instance bits-nat (x (lamt a b e)) (i e) (j 2))
			(:instance bits< (x (lamt a b e)) (i e) (j 2))
			(:instance bitn-0-1 (x (comp1 (bits (lamt a b e) e 2) (1- e))) (n k))
			(:instance bitn-comp1 (x (bits (lamt a b e) e 2)) (n (1- e)))
			(:instance bitn-0-1 (x (bits (lamt a b e) e 2)) (n k))
			(:instance bits-nat (x (lamz a b e)) (i (- e 2)) (j 0))
			(:instance bits< (x (lamz a b e)) (i (- e 2)) (j 0))
			(:instance bitn-0-1 (x (comp1 (bits (lamz a b e) (- e 2) 0) (1- e))) (n k))
			(:instance bitn-comp1 (x (bits (lamz a b e) (- e 2) 0)) (n (1- e)))
			(:instance bitn-0-1 (x (bits (lamz a b e) (- e 2) 0)) (n k)))))))

(local (defthm bitn-lam2
    (implies (and (integerp a)
		  (> a 0)
		  (integerp b)
		  (> b 0)
		  (not (= a b))
		  (= e (expo a))
		  (= e (expo b))
		  (> e 1)
		  (integerp k)
		  (<= k (- e 2))
		  (>= k 0))
	     (iff (= (bitn (lam2 a b e) k) 1)
		  (and (= (bitn (lamt a b e) (+ k 2)) 0)
		       (= (bitn (lamz a b e) (+ k 1)) 1)
		       (= (bitn (lamz a b e) k) 0))))
  :rule-classes ()
  :hints (("Goal" :in-theory (disable lam2 bits logand)
		  :use (lamz-nat
			lamt-nat
			bitn-lam2-3
			(:instance bits-nat (x (lamz a b e)) (i (- e 2)) (j 0))
			(:instance bits< (x (lamz a b e)) (i (- e 2)) (j 0))
			(:instance bitn-0-1 (x (lamz a b e)) (n k))
			(:instance bit-bits-b (x (lamt a b e)) (i e) (j 2))
			(:instance bit-bits-b (x (lamz a b e)) (i (- e 1)) (j 1))
			(:instance bit-bits-b (x (lamz a b e)) (i (- e 2)) (j 0)))))))

(defthm LAM2-NAT
    (implies (and (integerp a)
		  (> a 0)
		  (integerp b)
		  (> b 0)
		  (not (= a b))
		  (= e (expo a))
		  (= e (expo b))
		  (> e 1)
		  (integerp k)
		  (<= k (- e 2))
		  (>= k 0))
	     (and (integerp (lam2 a b e))
		  (>= (lam2 a b e) 0)))
  :rule-classes ()
  :hints (("Goal" :in-theory (disable bits logand)
		  :use (lamz-nat
			lamt-nat
			(:instance bits-nat (x (lamt a b e)) (i e) (j 2))
			(:instance bits< (x (lamt a b e)) (i e) (j 2))
			(:instance bits-nat (x (lamz a b e)) (i (1- e)) (j 1))
			(:instance bits-nat (x (lamz a b e)) (i (- e 2)) (j 0))
			(:instance bits< (x (lamz a b e)) (i (- e 2)) (j 0))
			(:instance logand-nat
				   (i (comp1 (bits (lamt a b e) e 2) (1- e)))
				   (j (logand (bits (lamz a b e) (1- e) 1)
					      (comp1 (bits (lamz a b e) (- e 2) 0) (1- e)))))
			(:instance logand-nat
				   (i (bits (lamz a b e) (1- e) 1))
				   (j (comp1 (bits (lamz a b e) (- e 2) 0) (1- e))))))))

(local (defthm bitn-lam4-1
    (implies (and (integerp a)
		  (> a 0)
		  (integerp b)
		  (> b 0)
		  (not (= a b))
		  (= e (expo a))
		  (= e (expo b))
		  (> e 1)
		  (integerp k)
		  (>= k 0))
	     (equal (bitn (lam4 a b e) k)
		    (logand (bitn (comp1 (bits (lamt a b e) e 2) (1- e)) k)
			    (logand (bitn (bits (lamg a b e) (1- e) 1) k)
				    (bitn (comp1 (bits (lamg a b e) (- e 2) 0) (1- e)) k)))))
  :hints (("Goal" :in-theory (disable bits logand)
		  :use (lamg-nat
			lamt-nat
			(:instance bits-nat (x (lamt a b e)) (i e) (j 2))
			(:instance bits< (x (lamt a b e)) (i e) (j 2))
			(:instance bits-nat (x (lamg a b e)) (i (1- e)) (j 1))
			(:instance bits-nat (x (lamg a b e)) (i (- e 2)) (j 0))
			(:instance bits< (x (lamg a b e)) (i (- e 2)) (j 0))
			(:instance logand-nat
				   (i (bits (lamg a b e) (1- e) 1))
				   (j (comp1 (bits (lamg a b e) (- e 2) 0) (1- e))))
			(:instance bit-dist-a
				   (x (comp1 (bits (lamt a b e) e 2) (1- e)))
				   (y (logand (bits (lamg a b e) (1- e) 1)
					      (comp1 (bits (lamg a b e) (- e 2) 0) (1- e))))
				   (n k))
			(:instance bit-dist-a
				   (x (bits (lamg a b e) (1- e) 1))
				   (y (comp1 (bits (lamg a b e) (- e 2) 0) (1- e)))
				   (n k)))))))

(local (defthm bitn-lam4-2
    (implies (and (integerp a)
		  (> a 0)
		  (integerp b)
		  (> b 0)
		  (not (= a b))
		  (= e (expo a))
		  (= e (expo b))
		  (> e 1)
		  (integerp k)
		  (>= k 0))
	     (iff (= (bitn (lam4 a b e) k) 1)
		  (and (= (bitn (comp1 (bits (lamt a b e) e 2) (1- e)) k) 1)
		       (= (bitn (bits (lamg a b e) (1- e) 1) k) 1)
		       (= (bitn (comp1 (bits (lamg a b e) (- e 2) 0) (1- e)) k) 1))))
  :rule-classes ()
  :hints (("Goal" :in-theory (disable bits lam4 logand)
		  :use ((:instance bitn-0-1 (x (comp1 (bits (lamt a b e) e 2) (1- e))) (n k))
			(:instance bitn-0-1 (x (bits (lamg a b e) (1- e) 1)) (n k))
			(:instance bitn-0-1 (x (comp1 (bits (lamg a b e) (- e 2) 0) (1- e))) (n k)))))))

(local (in-theory (disable bitn-lam4-1)))

(local (defthm bitn-lam4-3
    (implies (and (integerp a)
		  (> a 0)
		  (integerp b)
		  (> b 0)
		  (not (= a b))
		  (= e (expo a))
		  (= e (expo b))
		  (> e 1)
		  (integerp k)
		  (<= k (- e 2))
		  (>= k 0))
	     (iff (= (bitn (lam4 a b e) k) 1)
		  (and (= (bitn (bits (lamt a b e) e 2) k) 0)
		       (= (bitn (bits (lamg a b e) (1- e) 1) k) 1)
		       (= (bitn (bits (lamg a b e) (- e 2) 0) k) 0))))
  :rule-classes ()
  :hints (("Goal" :in-theory (disable lam4 bits comp1 logand)
		  :use (lamg-nat
			lamt-nat
			bitn-lam4-2
			(:instance bits-nat (x (lamt a b e)) (i e) (j 2))
			(:instance bits< (x (lamt a b e)) (i e) (j 2))
			(:instance bitn-0-1 (x (comp1 (bits (lamt a b e) e 2) (1- e))) (n k))
			(:instance bitn-comp1 (x (bits (lamt a b e) e 2)) (n (1- e)))
			(:instance bitn-0-1 (x (bits (lamt a b e) e 2)) (n k))
			(:instance bits-nat (x (lamg a b e)) (i (- e 2)) (j 0))
			(:instance bits< (x (lamg a b e)) (i (- e 2)) (j 0))
			(:instance bitn-0-1 (x (comp1 (bits (lamg a b e) (- e 2) 0) (1- e))) (n k))
			(:instance bitn-comp1 (x (bits (lamg a b e) (- e 2) 0)) (n (1- e)))
			(:instance bitn-0-1 (x (bits (lamg a b e) (- e 2) 0)) (n k)))))))

(local (defthm bitn-lam4
    (implies (and (integerp a)
		  (> a 0)
		  (integerp b)
		  (> b 0)
		  (not (= a b))
		  (= e (expo a))
		  (= e (expo b))
		  (> e 1)
		  (integerp k)
		  (<= k (- e 2))
		  (>= k 0))
	     (iff (= (bitn (lam4 a b e) k) 1)
		  (and (= (bitn (lamt a b e) (+ k 2)) 0)
		       (= (bitn (lamg a b e) (+ k 1)) 1)
		       (= (bitn (lamg a b e) k) 0))))
  :rule-classes ()
  :hints (("Goal" :in-theory (disable lam4 bits logand)
		  :use (lamg-nat
			lamt-nat
			bitn-lam4-3
			(:instance bits-nat (x (lamg a b e)) (i (- e 2)) (j 0))
			(:instance bits< (x (lamg a b e)) (i (- e 2)) (j 0))
			(:instance bitn-0-1 (x (lamg a b e)) (n k))
			(:instance bit-bits-b (x (lamt a b e)) (i e) (j 2))
			(:instance bit-bits-b (x (lamg a b e)) (i (- e 1)) (j 1))
			(:instance bit-bits-b (x (lamg a b e)) (i (- e 2)) (j 0)))))))

(defthm LAM4-NAT
    (implies (and (integerp a)
		  (> a 0)
		  (integerp b)
		  (> b 0)
		  (not (= a b))
		  (= e (expo a))
		  (= e (expo b))
		  (> e 1)
		  (integerp k)
		  (<= k (- e 2))
		  (>= k 0))
	     (and (integerp (lam4 a b e))
		  (>= (lam4 a b e) 0)))
  :rule-classes ()
  :hints (("Goal" :in-theory (disable bits logand)
		  :use (lamg-nat
			lamt-nat
			(:instance bits-nat (x (lamt a b e)) (i e) (j 2))
			(:instance bits< (x (lamt a b e)) (i e) (j 2))
			(:instance bits-nat (x (lamg a b e)) (i (1- e)) (j 1))
			(:instance bits-nat (x (lamg a b e)) (i (- e 2)) (j 0))
			(:instance bits< (x (lamg a b e)) (i (- e 2)) (j 0))
			(:instance logand-nat
				   (i (comp1 (bits (lamt a b e) e 2) (1- e)))
				   (j (logand (bits (lamg a b e) (1- e) 1)
					      (comp1 (bits (lamg a b e) (- e 2) 0) (1- e)))))
			(:instance logand-nat
				   (i (bits (lamg a b e) (1- e) 1))
				   (j (comp1 (bits (lamg a b e) (- e 2) 0) (1- e))))))))

(local (in-theory (disable lam1 lam2 lam3 lam4)))

(local (defthm bitn-lam0-1
    (implies (and (integerp a)
		  (> a 0)
		  (integerp b)
		  (> b 0)
		  (not (= a b))
		  (= e (expo a))
		  (= e (expo b))
		  (> e 1)
		  (integerp k)
		  (<= k (- e 2))
		  (>= k 0))
	     (equal (bitn (lam0 a b e) k)
		    (logior (bitn (lam1 a b e) k)
			    (logior (bitn (lam2 a b e) k)
				    (logior (bitn (lam3 a b e) k)
					    (bitn (lam4 a b e) k))))))
  :hints (("Goal" :in-theory (disable logior bits)
		  :use (lam1-nat
			lam2-nat
			lam3-nat
			lam4-nat
			(:instance bit-dist-b
				   (x (lam1 a b e))
				   (y (logior (lam2 a b e)
					      (logior (lam3 a b e)
						      (lam4 a b e))))
				   (n k))
			(:instance bit-dist-b
				   (x (lam2 a b e))
				   (y (logior (lam3 a b e) (lam4 a b e)))
				   (n k))
			(:instance bit-dist-b
				   (x (lam3 a b e))
				   (y (lam4 a b e))
				   (n k))
			(:instance logior-nat
				   (i (lam2 a b e))
				   (j (logior (lam3 a b e) (lam4 a b e))))
			(:instance logior-nat (i (lam3 a b e)) (j (lam4 a b e))))))))

(local (defthm bitn-lam0-2
    (implies (and (integerp a)
		  (> a 0)
		  (integerp b)
		  (> b 0)
		  (not (= a b))
		  (= e (expo a))
		  (= e (expo b))
		  (> e 1)
		  (integerp k)
		  (<= k (- e 2))
		  (>= k 0))
	     (iff (= (bitn (lam0 a b e) k) 1)
		  (or (= (bitn (lam1 a b e) k) 1)
		      (= (bitn (lam2 a b e) k) 1)
		      (= (bitn (lam3 a b e) k) 1)
		      (= (bitn (lam4 a b e) k) 1))))
  :hints (("Goal" :in-theory (disable logior lam0)
		  :use (lam1-nat
			lam2-nat
			lam3-nat
			lam4-nat
			(:instance bitn-0-1 (x (lam1 a b e)) (n k))
			(:instance bitn-0-1 (x (lam2 a b e)) (n k))
			(:instance bitn-0-1 (x (lam3 a b e)) (n k))
			(:instance bitn-0-1 (x (lam4 a b e)) (n k)))))))

(local (in-theory (disable bitn-lam0-1)))

(local (defthm bitn-lam0-3
    (implies (and (integerp a)
		  (> a 0)
		  (integerp b)
		  (> b 0)
		  (not (= a b))
		  (= e (expo a))
		  (= e (expo b))
		  (> e 1)
		  (integerp k)
		  (<= k (- e 2))
		  (>= k 0))
	     (iff (= (bitn (lam0 a b e) k) 1)
		  (or (and (= (bitn (lamt a b e) (+ k 2)) 1)
			   (= (bitn (lamg a b e) (+ k 1)) 1)
			   (= (bitn (lamz a b e) k) 0))
		      (and (= (bitn (lamt a b e) (+ k 2)) 0)
			   (= (bitn (lamz a b e) (+ k 1)) 1)
			   (= (bitn (lamz a b e) k) 0))
		      (and (= (bitn (lamt a b e) (+ k 2)) 1)
			   (= (bitn (lamz a b e) (+ k 1)) 1)
			   (= (bitn (lamg a b e) k) 0))
		      (and (= (bitn (lamt a b e) (+ k 2)) 0)
			   (= (bitn (lamg a b e) (+ k 1)) 1)
			   (= (bitn (lamg a b e) k) 0)))))
  :hints (("Goal" :in-theory (disable lam0)
		  :use (bitn-lam0-2 bitn-lam1 bitn-lam2 bitn-lam3 bitn-lam4)))))

(local (defthm bitn-lam0-4
    (implies (and (integerp a)
		  (> a 0)
		  (integerp b)
		  (> b 0)
		  (not (= a b))
		  (= e (expo a))
		  (= e (expo b))
		  (> e 1)
		  (integerp k)
		  (<= k (- e 2))
		  (>= k 0))
	     (iff (= (bitn (lam0 a b e) k) 1)
		  (or (and (= (bitn (lamt a b e) (+ k 2)) 1)
			   (= (bitn (lamg a b e) (+ k 1)) 1)
			   (not (= (bitn (lamz a b e) k) 1)))
		      (and (not (= (bitn (lamt a b e) (+ k 2)) 1))
			   (= (bitn (lamz a b e) (+ k 1)) 1)
			   (not (= (bitn (lamz a b e) k) 1)))
		      (and (= (bitn (lamt a b e) (+ k 2)) 1)
			   (= (bitn (lamz a b e) (+ k 1)) 1)
			   (not (= (bitn (lamg a b e) k) 1)))
		      (and (not (= (bitn (lamt a b e) (+ k 2)) 1))
			   (= (bitn (lamg a b e) (+ k 1)) 1)
			   (not (= (bitn (lamg a b e) k) 1))))))
  :hints (("Goal" :in-theory (disable lam0)
		  :use (bitn-lam0-3
			(:instance bitn-0-1 (x (lamz a b e)) (n k))
			(:instance bitn-0-1 (x (lamg a b e)) (n k))
			(:instance bitn-0-1 (x (lamt a b e)) (n (+ k 2))))))))

(local (defthm c-0-1
    (or (= (c k a b) 0)
	(= (c k a b) 1)
	(= (c k a b) -1))
  :rule-classes ()
  :hints (("Goal" :use ((:instance bitn-0-1 (x a) (n k))
			(:instance bitn-0-1 (x b) (n k)))))))

(local (defthm bitn-lam0
    (implies (and (integerp a)
		  (> a 0)
		  (integerp b)
		  (> b 0)
		  (not (= a b))
		  (= e (expo a))
		  (= e (expo b))
		  (> e 1)
		  (integerp k)
		  (<= k (- e 2))
		  (>= k 0))
	     (iff (= (bitn (lam0 a b e) k) 1)
		  (and (not (= (c (1+ k) a b) 0))
		       (not (= (c (1+ k) a b)
			       (if (= (c (+ k 2) a b) 0)
				   (- (c k a b))
				 (c k a b)))))))
  :hints (("Goal" :in-theory (disable c lam0)
		  :use (bitn-lam0-4
			bitn-lamg
			bitn-lamz
			c-0-1
			(:instance c-0-1 (k (+ k 1)))
			(:instance c-0-1 (k (+ k 2)))
			(:instance bitn-lamt (k (+ k 2)))
			(:instance bitn-lamz (k (1+ k)))
			(:instance bitn-lamg (k (1+ k))))))))

(defthm LAM0-NAT
    (implies (and (integerp a)
		  (> a 0)
		  (integerp b)
		  (> b 0)
		  (not (= a b))
		  (= e (expo a))
		  (= e (expo b))
		  (> e 1))
	     (and (integerp (lam0 a b e))
		  (>= (lam0 a b e) 0)))
  :rule-classes ()
  :hints (("Goal" :in-theory (disable logior)
		  :use ((:instance lam1-nat (k 0))
			(:instance lam2-nat (k 0))
			(:instance lam3-nat (k 0))
			(:instance lam4-nat (k 0))
			(:instance logior-nat
				   (i (lam1 a b e))
				   (j (logior (lam2 a b e)
					      (logior (lam3 a b e)
						      (lam4 a b e)))))
			(:instance logior-nat
				   (i (lam2 a b e))
				   (j (logior (lam3 a b e) (lam4 a b e))))
			(:instance logior-nat (i (lam3 a b e)) (j (lam4 a b e)))))))

(local (in-theory (disable lam0)))

(defthm LAMB-NAT
    (implies (and (integerp a)
		  (> a 0)
		  (integerp b)
		  (> b 0)
		  (not (= a b))
		  (= e (expo a))
		  (= e (expo b))
		  (> e 1))
	     (and (integerp (lamb a b e))
		  (>= (lamb a b e) 0)))
  :rule-classes ()
  :hints (("Goal" :use (lam0-nat
			(:instance bitn-0-1 (x (lamt a b e)) (n 0))))))

(local (defthm bitn-lamb-1
    (implies (and (integerp a)
		  (> a 0)
		  (integerp b)
		  (> b 0)
		  (not (= a b))
		  (= e (expo a))
		  (= e (expo b))
		  (> e 1))
	     (= (fl (/ (lamb a b e) 2))
		(lam0 a b e)))
  :hints (("Goal" :use (lam0-nat
			(:instance fl-unique (x (/ (lamb a b e) 2)) (n (lam0 a b e)))
			(:instance bitn-0-1 (x (lamt a b e)) (n 0)))))))

(local (defthm bitn-lamb-2
    (implies (and (integerp a)
		  (> a 0)
		  (integerp b)
		  (> b 0)
		  (not (= a b))
		  (= e (expo a))
		  (= e (expo b))
		  (> e 1)
		  (integerp n)
		  (> n 0))
	     (= (bitn (lamb a b e) n)
		(bitn (lam0 a b e) (1- n))))
  :hints (("Goal" :use (lamb-nat
			bitn-lamb-1
			(:instance bitn-alt-pos (x (lamb a b e)) (k n)))))))

(local (defthm bitn-lamb
    (implies (and (integerp a)
		  (> a 0)
		  (integerp b)
		  (> b 0)
		  (not (= a b))
		  (= e (expo a))
		  (= e (expo b))
		  (> e 1)
		  (integerp n)
		  (<= n (- e 1))
		  (> n 0))
	     (iff (= (bitn (lamb a b e) n) 1)
		  (and (not (= (c n a b) 0))
		       (not (= (c n a b)
			       (if (= (c (+ n 1) a b) 0)
				   (- (c (1- n) a b))
				 (c (1- n) a b)))))))
  :rule-classes ()
  :hints (("Goal" :in-theory (disable c lamb)
		  :use (bitn-lamb-2
			(:instance bitn-lam0 (k (1- n))))))))

(local (defun nat-induct (k)
  (if (and (integerp k) (>= k 0))
      (if (= k 0)
	  0
	(nat-induct (1- k)))
    0)))

(local (defthm rem-n+1-1
    (implies (and (integerp a)
		  (>= a 0)
		  (integerp n)
		  (>= n 0))
	     (< (/ (rem a (expt 2 (1+ n))) (expt 2 n))
		2))
  :rule-classes ()
  :hints (("Goal" :use ((:instance rem<n (m a) (n (expt 2  (1+ n))))
			(:instance expt-pos (x (1+ n)))
			(:instance expt-pos (x n))
			(:instance *-weakly-monotonic
				   (x (expt 2 n))
				   (y 2)
				   (y+ (/ (rem a (expt 2 (1+ n))) (expt 2 n)))))))))

(local (defthm rem-n+1-2
    (implies (and (integerp a)
		  (>= a 0)
		  (integerp n)
		  (>= n 0))
	     (< (fl (/ (rem a (expt 2 (1+ n))) (expt 2 n)))
		2))
  :rule-classes ()
  :hints (("Goal" :use (rem-n+1-1)))))

(local (defthm rem-n+1-3
    (implies (and (integerp a)
		  (>= a 0)
		  (integerp n)
		  (>= n 0))
	     (<= 0 (fl (/ (rem a (expt 2 (1+ n))) (expt 2 n)))))
  :rule-classes ()
  :hints (("Goal" :use ((:instance rem>=0 (m a) (n (expt 2 (1+ n))))
			(:instance expt-pos (x (1+ n)))
			(:instance expt-pos (x n)))))))

(local (defthm rem-n+1-4
    (implies (and (integerp a)
		  (>= a 0)
		  (integerp n)
		  (>= n 0))
	     (or (= (fl (/ (rem a (expt 2 (1+ n))) (expt 2 n))) 0)
		 (= (fl (/ (rem a (expt 2 (1+ n))) (expt 2 n))) 1)))
  :rule-classes ()
  :hints (("Goal" :use (rem-n+1-2
			rem-n+1-3)))))

(local (defthm rem-n+1-5
    (implies (and (integerp a)
		  (>= a 0)
		  (integerp n)
		  (>= n 0))
	     (= (fl (/ (rem a (expt 2 (1+ n))) (expt 2 n)))
		(rem (fl (/ (rem a (expt 2 (1+ n))) (expt 2 n))) 2)))
  :rule-classes ()
  :hints (("Goal" :use (rem-n+1-4)))))

(local (defthm rem-n+1-6
    (implies (and (integerp a)
		  (>= a 0)
		  (integerp n)
		  (>= n 0))
	     (= (fl (/ (rem a (expt 2 (1+ n))) (expt 2 n)))
		(bitn (rem a (expt 2 (1+ n))) n)))
  :rule-classes ()
  :hints (("Goal" :use (rem-n+1-5
			(:instance rem>=0 (m a) (n (expt 2 (1+ n))))
			(:instance bitn-def (x (rem a (expt 2 (1+ n)))) (k n)))))))

(local (defthm rem-n+1-7
    (implies (and (integerp a)
		  (>= a 0)
		  (integerp n)
		  (>= n 0))
	     (= (fl (/ (rem a (expt 2 (1+ n))) (expt 2 n)))
		(bitn a n)))
  :rule-classes ()
  :hints (("Goal" :use (rem-n+1-6
			(:instance bitn-rem (x a) (k (1+ n)) (j n)))))))

(local (defthm rem-n+1-8
    (implies (and (integerp a)
		  (>= a 0)
		  (integerp n)
		  (> n 0))
	     (= (rem (rem a (expt 2 (1+ n))) (expt 2 n))
		(rem a (expt 2 n))))
  :rule-classes ()
  :hints (("Goal" :use ((:instance rem-rem (x a) (a (1+ n)) (b n)))))))

(defthm REM-N+1
    (implies (and (integerp a)
		  (>= a 0)
		  (integerp n)
		  (> n 0))
	     (= (rem a (expt 2 (1+ n)))
		(+ (* (bitn a n) (expt 2 n))
		   (rem a (expt 2 n)))))
  :rule-classes ()
  :hints (("Goal" :use (rem-n+1-8
			rem-n+1-7
			(:instance rem-fl (m (rem a (expt 2 (1+ n)))) (n (expt 2 n)))))))

(local (defthm lop3-1
    (implies (and (integerp a)
		  (>= a 0)
		  (integerp b)
		  (>= b 0)
		  (integerp n)
		  (> n 0)
		  (= (rem a (expt 2 n)) (rem b (expt 2 n)))
		  (= (bitn a n) (bitn b n)))
	     (= (rem a (expt 2 (1+ n)))
		(rem b (expt 2 (1+ n)))))
  :rule-classes ()
  :hints (("Goal" :use (rem-n+1
			(:instance rem-n+1 (a b)))))))

(local (defthm lop3-2
    (implies (and (integerp x)
		  (>= x 0)
		  (integerp n)
		  (> n 0)
		  (= (bitn x n) 1))
	     (= (expo (rem x (expt 2 (1+ n))))
		n))
  :rule-classes ()
  :hints (("Goal" :use ((:instance rem>=0 (m x) (n (expt 2 (1+ n))))
			(:instance rem<n (m x) (n (expt 2 (1+ n))))
			(:instance expo-squeeze (x (rem x (expt 2 (1+ n)))))
			(:instance bitn-rem (k (1+ n)) (j n))
			(:instance bit-expo-a (x (rem x (expt 2 (1+ n))))))))))

(local (defthm lop3-3
	   (IMPLIES (AND (INTEGERP N)
			 (< 0 N)
			 (= (c n a b) 0)
			 (IMPLIES (AND (INTEGERP A)
				       (< 0 A)
				       (INTEGERP B)
				       (< 0 B)
				       (= E (EXPO A))
				       (= E (EXPO B))
				       (< 0 E)
				       (INTEGERP (+ -1 N))
				       (<= 0 (+ -1 N))
				       (< (+ -1 N) E)
				       (NOT (= (REM A (EXPT 2 (+ 1 -1 N)))
					       (REM B (EXPT 2 (+ 1 -1 N))))))
				  (and (not (= (REM (LAMB A B E) (EXPT 2 (+ 1 -1 N))) 0))
				       (= (EXPO (REM (LAMB A B E) (EXPT 2 (+ 1 -1 N))))
					  (IF (OR (= (C (+ -1 N) A B) 0)
						  (= (C (+ 1 -1 N) A B) 0))
					      (PHI A B (C (+ -1 N) A B) (+ -1 N))
					      (PHI A B (- (C (+ -1 N) A B))
						   (+ -1 N))))))
			 (INTEGERP A)
			 (< 0 A)
			 (INTEGERP B)
			 (< 0 B)
			 (= E (EXPO A))
			 (= E (EXPO B))
			 (< 0 E)
			 (INTEGERP N)
			 (<= 0 N)
			 (< N E)
			 (NOT (= (REM A (EXPT 2 (+ 1 N)))
				 (REM B (EXPT 2 (+ 1 N))))))
		    (and (not (= (REM (LAMB A B E) (EXPT 2 N)) 0))
			 (= (EXPO (REM (LAMB A B E) (EXPT 2 N)))
			    (phi a b (c (1- n) a b) (1- n)))))
	 :rule-classes ()
	 :hints (("Goal" :use (lop3-1)))))

(local (defthm lop3-4
    (IMPLIES (AND (INTEGERP N)
		  (< 0 N)
		  (= (c n a b) 0)
		  (INTEGERP A)
		  (< 0 A)
		  (INTEGERP B)
		  (< 0 B)
		  (= E (EXPO A))
		  (= E (EXPO B))
		  (< 0 E)
		  (INTEGERP N)
		  (<= 0 N)
		  (< N E)
		  (NOT (= (REM A (EXPT 2 (+ 1 N)))
			  (REM B (EXPT 2 (+ 1 N))))))
	     (= (bitn (lamb a b e) n) 0))
  :rule-classes ()
  :hints (("Goal" :use (bitn-lamb
			(:instance bitn-0-1 (x (lamb a b e))))))))

(local (defthm lop3-5
    (IMPLIES (AND (INTEGERP N)
		  (< 0 N)
		  (= (c n a b) 0)
		  (INTEGERP A)
		  (< 0 A)
		  (INTEGERP B)
		  (< 0 B)
		  (= E (EXPO A))
		  (= E (EXPO B))
		  (< 0 E)
		  (INTEGERP N)
		  (<= 0 N)
		  (< N E)
		  (NOT (= (REM A (EXPT 2 (+ 1 N)))
			  (REM B (EXPT 2 (+ 1 N))))))
	     (= (rem (lamb a b e) (expt 2 (1+ n)))
		(rem (lamb a b e) (expt 2 n))))
  :rule-classes ()
  :hints (("Goal" :use (lop3-4
			lamb-nat
			(:instance rem-n+1 (a (lamb a b e))))))))

(local (defthm lop3-6
    (IMPLIES (AND (INTEGERP N)
		  (< 0 N)
		  (= (c n a b) 0)
		  (INTEGERP A)
		  (< 0 A)
		  (INTEGERP B)
		  (< 0 B)
		  (= E (EXPO A))
		  (= E (EXPO B))
		  (< 0 E)
		  (INTEGERP N)
		  (<= 0 N)
		  (< N E)
		  (NOT (= (REM A (EXPT 2 (+ 1 N)))
			  (REM B (EXPT 2 (+ 1 N))))))
	     (= (phi a b (c n a b) n)
		(phi a b (c (1- n) a b) (1- n))))
  :rule-classes ()))

(local (defthm lop3-7
	   (IMPLIES (AND (INTEGERP N)
			 (< 0 N)
			 (= (c n a b) 0)
			 (IMPLIES (AND (INTEGERP A)
				       (< 0 A)
				       (INTEGERP B)
				       (< 0 B)
				       (= E (EXPO A))
				       (= E (EXPO B))
				       (< 0 E)
				       (INTEGERP (+ -1 N))
				       (<= 0 (+ -1 N))
				       (< (+ -1 N) E)
				       (NOT (= (REM A (EXPT 2 (+ 1 -1 N)))
					       (REM B (EXPT 2 (+ 1 -1 N))))))
				  (and (not (= (REM (LAMB A B E) (EXPT 2 (+ 1 -1 N))) 0))
				       (= (EXPO (REM (LAMB A B E) (EXPT 2 (+ 1 -1 N))))
					  (IF (OR (= (C (+ -1 N) A B) 0)
						  (= (C (+ 1 -1 N) A B) 0))
					      (PHI A B (C (+ -1 N) A B) (+ -1 N))
					      (PHI A B (- (C (+ -1 N) A B))
						   (+ -1 N))))))
			 (INTEGERP A)
			 (< 0 A)
			 (INTEGERP B)
			 (< 0 B)
			 (= E (EXPO A))
			 (= E (EXPO B))
			 (< 0 E)
			 (INTEGERP N)
			 (<= 0 N)
			 (< N E)
			 (NOT (= (REM A (EXPT 2 (+ 1 N)))
				 (REM B (EXPT 2 (+ 1 N))))))
		    (and (not (= (REM (LAMB A B E) (EXPT 2 (+ 1 N))) 0))
			 (= (EXPO (REM (LAMB A B E) (EXPT 2 (+ 1 N))))
			    (IF (OR (= (C N A B) 0)
				    (= (C (+ 1 N) A B) 0))
				(PHI A B (C N A B) N)
				(PHI A B (- (C N A B)) N)))))
	 :rule-classes ()
	 :hints (("Goal" :in-theory (disable phi)
			 :use (lop3-3 lop3-5 lop3-6)))))

(local (defthm lop3-8
    (implies (and (integerp a)
		  (>= a 0)
		  (integerp b)
		  (>= b 0)
		  (integerp n)
		  (>= n 0)
		  (= (rem a (expt 2 (1+ n))) (rem b (expt 2 (1+ n)))))
	     (= (bitn a n) (bitn b n)))
  :rule-classes ()
  :hints (("Goal" :use ((:instance bitn-rem (x a) (k (1+ n)) (j n))
			(:instance bitn-rem (x b) (k (1+ n)) (j n)))))))

(local (defthm lop3-8-1
    (implies (and (integerp a)
		  (> a 0)
		  (integerp b)
		  (integerp n)
		  (> n 0)
		  (> b 0)
		  (not (= a b))
		  (= e (expo a))
		  (= e (expo b))
		  (> e 1)
		  (not (= (rem (lamb a b e) (expt 2 n)) 0)))
	     (not (= (rem (lamb a b e) (expt 2 (1+ n))) 0)))
  :rule-classes ()
  :hints (("Goal" :in-theory (disable lamb)
		  :use (lamb-nat
			(:instance rem< (m 0) (n (expt 2 n)))
			(:instance rem-rem (x (lamb a b e)) (a (1+ n)) (b n)))))))

(local (defthm lop3-9
	   (IMPLIES (AND (INTEGERP N)
			 (< 0 N)
			 (not (= (c n a b) 0))
			 (= (c (1+ n) a b) 0)
			 (= (c (1- n) a b) (- (c n a b)))
			 (IMPLIES (AND (INTEGERP A)
				       (< 0 A)
				       (INTEGERP B)
				       (< 0 B)
				       (= E (EXPO A))
				       (= E (EXPO B))
				       (< 0 E)
				       (INTEGERP (+ -1 N))
				       (<= 0 (+ -1 N))
				       (< (+ -1 N) E)
				       (NOT (= (REM A (EXPT 2 (+ 1 -1 N)))
					       (REM B (EXPT 2 (+ 1 -1 N))))))
				  (and (not (= (REM (LAMB A B E) (EXPT 2 (+ 1 -1 N))) 0))
				       (= (EXPO (REM (LAMB A B E) (EXPT 2 (+ 1 -1 N))))
					  (IF (OR (= (C (+ -1 N) A B) 0)
						  (= (C (+ 1 -1 N) A B) 0))
					      (PHI A B (C (+ -1 N) A B) (+ -1 N))
					      (PHI A B (- (C (+ -1 N) A B))
						   (+ -1 N))))))
			 (INTEGERP A)
			 (< 0 A)
			 (INTEGERP B)
			 (< 0 B)
			 (= E (EXPO A))
			 (= E (EXPO B))
			 (< 0 E)
			 (INTEGERP N)
			 (<= 0 N)
			 (< N E)
			 (NOT (= (REM A (EXPT 2 (+ 1 N)))
				 (REM B (EXPT 2 (+ 1 N))))))
		    (and (not (= (REM (LAMB A B E) (EXPT 2 (+ 1 N))) 0))
			 (= (EXPO (REM (LAMB A B E) (EXPT 2 N)))
			    (phi a b (- (c (1- n) a b)) (1- n)))))
	 :rule-classes ()
	 :hints (("Goal" :use (lop3-8-1
			       (:instance lop3-8 (n (1- n))))))))

(local (defthm lop3-10
    (IMPLIES (AND (INTEGERP N)
		  (< 0 N)
		  (not (= (c n a b) 0))
		  (= (c (1+ n) a b) 0)
		  (= (c (1- n) a b) (- (c n a b)))
		  (INTEGERP A)
		  (< 0 A)
		  (INTEGERP B)
		  (< 0 B)
		  (= E (EXPO A))
		  (= E (EXPO B))
		  (< 0 E)
		  (INTEGERP N)
		  (<= 0 N)
		  (< N E)
		  (NOT (= (REM A (EXPT 2 (+ 1 N)))
			  (REM B (EXPT 2 (+ 1 N))))))
	     (= (bitn (lamb a b e) n) 0))
  :rule-classes ()
  :hints (("Goal" :use (bitn-lamb
			(:instance bitn-0-1 (x (lamb a b e))))))))

(local (defthm lop3-11
    (IMPLIES (AND (INTEGERP N)
		  (< 0 N)
		  (not (= (c n a b) 0))
		  (= (c (1+ n) a b) 0)
		  (= (c (1- n) a b) (- (c n a b)))
		  (INTEGERP A)
		  (< 0 A)
		  (INTEGERP B)
		  (< 0 B)
		  (= E (EXPO A))
		  (= E (EXPO B))
		  (< 0 E)
		  (INTEGERP N)
		  (<= 0 N)
		  (< N E)
		  (NOT (= (REM A (EXPT 2 (+ 1 N)))
			  (REM B (EXPT 2 (+ 1 N))))))
	     (= (rem (lamb a b e) (expt 2 (1+ n)))
		(rem (lamb a b e) (expt 2 n))))
  :rule-classes ()
  :hints (("Goal" :use (lop3-10
			lamb-nat
			(:instance rem-n+1 (a (lamb a b e))))))))

(local (defthm lop3-12
    (IMPLIES (AND (INTEGERP N)
		  (< 0 N)
		  (not (= (c n a b) 0))
		  (= (c (1+ n) a b) 0)
		  (= (c (1- n) a b) (- (c n a b)))
		  (INTEGERP A)
		  (< 0 A)
		  (INTEGERP B)
		  (< 0 B)
		  (= E (EXPO A))
		  (= E (EXPO B))
		  (< 0 E)
		  (INTEGERP N)
		  (<= 0 N)
		  (< N E)
		  (NOT (= (REM A (EXPT 2 (+ 1 N)))
			  (REM B (EXPT 2 (+ 1 N))))))
	     (= (phi a b (- (c (1- n) a b)) n)
		(phi a b (- (c (1- n) a b)) (1- n))))
  :rule-classes ()))

(local (defthm lop3-13
    (IMPLIES (AND (INTEGERP N)
		  (< 0 N)
		  (not (= (c n a b) 0))
		  (= (c (1+ n) a b) 0)
		  (= (c (1- n) a b) (- (c n a b)))
		  (INTEGERP A)
		  (< 0 A)
		  (INTEGERP B)
		  (< 0 B)
		  (INTEGERP N)
		  (<= 0 N))
	     (EQUAL (PHI A B (* -1 (C (+ -1 N) A B)) (+ -1 N))
		    (PHI A B (C N A B) N)))))

(local (defthm lop3-14
	   (IMPLIES (AND (INTEGERP N)
			 (< 0 N)
			 (not (= (c n a b) 0))
			 (= (c (1+ n) a b) 0)
			 (= (c (1- n) a b) (- (c n a b)))
			 (IMPLIES (AND (INTEGERP A)
				       (< 0 A)
				       (INTEGERP B)
				       (< 0 B)
				       (= E (EXPO A))
				       (= E (EXPO B))
				       (< 0 E)
				       (INTEGERP (+ -1 N))
				       (<= 0 (+ -1 N))
				       (< (+ -1 N) E)
				       (NOT (= (REM A (EXPT 2 (+ 1 -1 N)))
					       (REM B (EXPT 2 (+ 1 -1 N))))))
				  (and (not (= (REM (LAMB A B E) (EXPT 2 (+ 1 -1 N))) 0))
				       (= (EXPO (REM (LAMB A B E) (EXPT 2 (+ 1 -1 N))))
					  (IF (OR (= (C (+ -1 N) A B) 0)
						  (= (C (+ 1 -1 N) A B) 0))
					      (PHI A B (C (+ -1 N) A B) (+ -1 N))
					      (PHI A B (- (C (+ -1 N) A B))
						   (+ -1 N))))))
			 (INTEGERP A)
			 (< 0 A)
			 (INTEGERP B)
			 (< 0 B)
			 (= E (EXPO A))
			 (= E (EXPO B))
			 (< 0 E)
			 (INTEGERP N)
			 (<= 0 N)
			 (< N E)
			 (NOT (= (REM A (EXPT 2 (+ 1 N)))
				 (REM B (EXPT 2 (+ 1 N))))))
		    (and (not (= (REM (LAMB A B E) (EXPT 2 (+ 1 N))) 0))
			 (= (EXPO (REM (LAMB A B E) (EXPT 2 (+ 1 N))))
			    (IF (OR (= (C N A B) 0)
				    (= (C (+ 1 N) A B) 0))
				(PHI A B (C N A B) N)
				(PHI A B (- (C N A B)) N)))))
	 :rule-classes ()
	 :hints (("Goal" :in-theory (disable phi c)
			 :use (lop3-9 lop3-11 lop3-12)))))

(local (defthm lop3-15
    (IMPLIES (AND (INTEGERP N)
		  (< 0 N)
		  (not (= (c n a b) 0))
		  (= (c (1+ n) a b) 0)
		  (not (= (c (1- n) a b) (- (c n a b))))
		  (INTEGERP A)
		  (< 0 A)
		  (INTEGERP B)
		  (< 0 B)
		  (= E (EXPO A))
		  (= E (EXPO B))
		  (< 0 E)
		  (INTEGERP N)
		  (<= 0 N)
		  (< N E)
		  (NOT (= (REM A (EXPT 2 (+ 1 N)))
			  (REM B (EXPT 2 (+ 1 N))))))
	     (= (bitn (lamb a b e) n) 1))
  :rule-classes ()
  :hints (("Goal" :use (bitn-lamb)))))

(local (defthm lop3-16
    (IMPLIES (AND (INTEGERP N)
		  (< 0 N)
		  (not (= (c n a b) 0))
		  (= (c (1+ n) a b) 0)
		  (not (= (c (1- n) a b) (- (c n a b))))
		  (INTEGERP A)
		  (< 0 A)
		  (INTEGERP B)
		  (< 0 B)
		  (= E (EXPO A))
		  (= E (EXPO B))
		  (< 0 E)
		  (INTEGERP N)
		  (<= 0 N)
		  (< N E)
		  (NOT (= (REM A (EXPT 2 (+ 1 N)))
			  (REM B (EXPT 2 (+ 1 N))))))
	     (and (not (= (rem (lamb a b e) (expt 2 (1+ n))) 0))
		  (= (expo (rem (lamb a b e) (expt 2 (1+ n)))) n)))
  :rule-classes ()
  :hints (("Goal" :use (lop3-15
			lamb-nat
			(:instance lop3-2 (x (lamb a b e))))))))

(local (defthm lop3-17
    (IMPLIES (AND (INTEGERP N)
		  (< 0 N)
		  (not (= (c n a b) 0))
		  (= (c (1+ n) a b) 0)
		  (not (= (c (1- n) a b) (- (c n a b))))
		  (INTEGERP A)
		  (< 0 A)
		  (INTEGERP B)
		  (< 0 B)
		  (= E (EXPO A))
		  (= E (EXPO B))
		  (< 0 E)
		  (INTEGERP N)
		  (<= 0 N)
		  (< N E)
		  (NOT (= (REM A (EXPT 2 (+ 1 N)))
			  (REM B (EXPT 2 (+ 1 N))))))
	     (= (phi a b (c n a b) n) n))
  :rule-classes ()))

(local (defthm lop3-18
	   (IMPLIES (AND (INTEGERP N)
			 (< 0 N)
			 (not (= (c n a b) 0))
			 (= (c (1+ n) a b) 0)
			 (not (= (c (1- n) a b) (- (c n a b))))
			 (INTEGERP A)
			 (< 0 A)
			 (INTEGERP B)
			 (< 0 B)
			 (= E (EXPO A))
			 (= E (EXPO B))
			 (< 0 E)
			 (INTEGERP N)
			 (<= 0 N)
			 (< N E)
			 (NOT (= (REM A (EXPT 2 (+ 1 N)))
				 (REM B (EXPT 2 (+ 1 N))))))
		    (and (not (= (rem (lamb a b e) (expt 2 (1+ n))) 0))
			 (= (EXPO (REM (LAMB A B E) (EXPT 2 (+ 1 N))))
			    (IF (OR (= (C N A B) 0)
				    (= (C (+ 1 N) A B) 0))
				(PHI A B (C N A B) N)
				(PHI A B (- (C N A B)) N)))))
	 :rule-classes ()
	 :hints (("Goal" :in-theory (disable phi c)
			 :use (lop3-16 lop3-17)))))

(local (defthm lop3-19
	   (IMPLIES (AND (INTEGERP N)
			 (< 0 N)
			 (not (= (c n a b) 0))
			 (= (c (1+ n) a b) 0)
			 (IMPLIES (AND (INTEGERP A)
				       (< 0 A)
				       (INTEGERP B)
				       (< 0 B)
				       (= E (EXPO A))
				       (= E (EXPO B))
				       (< 0 E)
				       (INTEGERP (+ -1 N))
				       (<= 0 (+ -1 N))
				       (< (+ -1 N) E)
				       (NOT (= (REM A (EXPT 2 (+ 1 -1 N)))
					       (REM B (EXPT 2 (+ 1 -1 N))))))
				  (and (not (= (REM (LAMB A B E) (EXPT 2 (+ 1 -1 N))) 0))
				       (= (EXPO (REM (LAMB A B E) (EXPT 2 (+ 1 -1 N))))
					  (IF (OR (= (C (+ -1 N) A B) 0)
						  (= (C (+ 1 -1 N) A B) 0))
					      (PHI A B (C (+ -1 N) A B) (+ -1 N))
					      (PHI A B (- (C (+ -1 N) A B))
						   (+ -1 N))))))
			 (INTEGERP A)
			 (< 0 A)
			 (INTEGERP B)
			 (< 0 B)
			 (= E (EXPO A))
			 (= E (EXPO B))
			 (< 0 E)
			 (INTEGERP N)
			 (<= 0 N)
			 (< N E)
			 (NOT (= (REM A (EXPT 2 (+ 1 N)))
				 (REM B (EXPT 2 (+ 1 N))))))
		    (and (not (= (rem (lamb a b e) (expt 2 (1+ n))) 0))
			 (= (EXPO (REM (LAMB A B E) (EXPT 2 (+ 1 N))))
			    (IF (OR (= (C N A B) 0)
				    (= (C (+ 1 N) A B) 0))
				(PHI A B (C N A B) N)
				(PHI A B (- (C N A B)) N)))))
	 :rule-classes ()
	 :hints (("Goal" :in-theory (disable phi c)
			 :use (lop3-14 lop3-18)))))

(local (defthm lop3-20
	   (IMPLIES (AND (INTEGERP N)
			 (< 0 N)
			 (not (= (c n a b) 0))
			 (not (= (c (1+ n) a b) 0))
			 (= (c (1- n) a b) (c n a b))
			 (IMPLIES (AND (INTEGERP A)
				       (< 0 A)
				       (INTEGERP B)
				       (< 0 B)
				       (= E (EXPO A))
				       (= E (EXPO B))
				       (< 0 E)
				       (INTEGERP (+ -1 N))
				       (<= 0 (+ -1 N))
				       (< (+ -1 N) E)
				       (NOT (= (REM A (EXPT 2 (+ 1 -1 N)))
					       (REM B (EXPT 2 (+ 1 -1 N))))))
				  (and (not (= (REM (LAMB A B E) (EXPT 2 (+ 1 -1 N))) 0))
				       (= (EXPO (REM (LAMB A B E) (EXPT 2 (+ 1 -1 N))))
					  (IF (OR (= (C (+ -1 N) A B) 0)
						  (= (C (+ 1 -1 N) A B) 0))
					      (PHI A B (C (+ -1 N) A B) (+ -1 N))
					      (PHI A B (- (C (+ -1 N) A B))
						   (+ -1 N))))))
			 (INTEGERP A)
			 (< 0 A)
			 (INTEGERP B)
			 (< 0 B)
			 (= E (EXPO A))
			 (= E (EXPO B))
			 (< 0 E)
			 (INTEGERP N)
			 (<= 0 N)
			 (< N E)
			 (NOT (= (REM A (EXPT 2 (+ 1 N)))
				 (REM B (EXPT 2 (+ 1 N))))))
		    (and (not (= (rem (lamb a b e) (expt 2 (1+ n))) 0))
			 (= (EXPO (REM (LAMB A B E) (EXPT 2 N)))
			    (phi a b (- (c (1- n) a b)) (1- n)))))
	 :rule-classes ()
	 :hints (("Goal" :use (lop3-8-1
			       (:instance lop3-8 (n (1- n))))))))

(local (defthm lop3-21
    (IMPLIES (AND (INTEGERP N)
		  (< 0 N)
		  (not (= (c n a b) 0))
		  (not (= (c (1+ n) a b) 0))
		  (= (c (1- n) a b) (c n a b))
		  (INTEGERP A)
		  (< 0 A)
		  (INTEGERP B)
		  (< 0 B)
		  (= E (EXPO A))
		  (= E (EXPO B))
		  (< 0 E)
		  (INTEGERP N)
		  (<= 0 N)
		  (< N E)
		  (NOT (= (REM A (EXPT 2 (+ 1 N)))
			  (REM B (EXPT 2 (+ 1 N))))))
	     (= (bitn (lamb a b e) n) 0))
  :rule-classes ()
  :hints (("Goal" :use (bitn-lamb
			(:instance bitn-0-1 (x (lamb a b e))))))))

(local (defthm lop3-22
    (IMPLIES (AND (INTEGERP N)
		  (< 0 N)
		  (not (= (c n a b) 0))
		  (not (= (c (1+ n) a b) 0))
		  (= (c (1- n) a b) (c n a b))
		  (INTEGERP A)
		  (< 0 A)
		  (INTEGERP B)
		  (< 0 B)
		  (= E (EXPO A))
		  (= E (EXPO B))
		  (< 0 E)
		  (INTEGERP N)
		  (<= 0 N)
		  (< N E)
		  (NOT (= (REM A (EXPT 2 (+ 1 N)))
			  (REM B (EXPT 2 (+ 1 N))))))
	     (= (rem (lamb a b e) (expt 2 (1+ n)))
		(rem (lamb a b e) (expt 2 n))))
  :rule-classes ()
  :hints (("Goal" :use (lop3-21
			lamb-nat
			(:instance rem-n+1 (a (lamb a b e))))))))

(local (defthm lop3-23
    (IMPLIES (AND (INTEGERP N)
		  (< 0 N)
		  (not (= (c n a b) 0))
		  (not (= (c (1+ n) a b) 0))
		  (= (c (1- n) a b) (c n a b))
		  (INTEGERP A)
		  (< 0 A)
		  (INTEGERP B)
		  (< 0 B)
		  (= E (EXPO A))
		  (= E (EXPO B))
		  (< 0 E)
		  (INTEGERP N)
		  (<= 0 N)
		  (< N E)
		  (NOT (= (REM A (EXPT 2 (+ 1 N)))
			  (REM B (EXPT 2 (+ 1 N))))))
	     (= (phi a b (- (c (1- n) a b)) n)
		(phi a b (- (c (1- n) a b)) (1- n))))
  :rule-classes ()))

(local (defthm lop3-24
    (IMPLIES (AND (INTEGERP N)
		  (< 0 N)
		  (not (= (c n a b) 0))
		  (not (= (c (1+ n) a b) 0))
		  (= (c (1- n) a b) (c n a b))
		  (INTEGERP A)
		  (< 0 A)
		  (INTEGERP B)
		  (< 0 B)
		  (INTEGERP N)
		  (<= 0 N))
	     (EQUAL (PHI A B (* -1 (C (+ -1 N) A B)) (+ -1 N))
		    (PHI A B (- (C N A B)) N)))))

(local (defthm lop3-25
	   (IMPLIES (AND (INTEGERP N)
			 (< 0 N)
			 (not (= (c n a b) 0))
			 (not (= (c (1+ n) a b) 0))
			 (= (c (1- n) a b) (c n a b))
			 (IMPLIES (AND (INTEGERP A)
				       (< 0 A)
				       (INTEGERP B)
				       (< 0 B)
				       (= E (EXPO A))
				       (= E (EXPO B))
				       (< 0 E)
				       (INTEGERP (+ -1 N))
				       (<= 0 (+ -1 N))
				       (< (+ -1 N) E)
				       (NOT (= (REM A (EXPT 2 (+ 1 -1 N)))
					       (REM B (EXPT 2 (+ 1 -1 N))))))
				  (and (not (= (REM (LAMB A B E) (EXPT 2 (+ 1 -1 N))) 0))
				       (= (EXPO (REM (LAMB A B E) (EXPT 2 (+ 1 -1 N))))
					  (IF (OR (= (C (+ -1 N) A B) 0)
						  (= (C (+ 1 -1 N) A B) 0))
					      (PHI A B (C (+ -1 N) A B) (+ -1 N))
					      (PHI A B (- (C (+ -1 N) A B))
						   (+ -1 N))))))
			 (INTEGERP A)
			 (< 0 A)
			 (INTEGERP B)
			 (< 0 B)
			 (= E (EXPO A))
			 (= E (EXPO B))
			 (< 0 E)
			 (INTEGERP N)
			 (<= 0 N)
			 (< N E)
			 (NOT (= (REM A (EXPT 2 (+ 1 N)))
				 (REM B (EXPT 2 (+ 1 N))))))
		    (and (not (= (rem (lamb a b e) (expt 2 (1+ n))) 0))
			 (= (EXPO (REM (LAMB A B E) (EXPT 2 (+ 1 N))))
			    (IF (OR (= (C N A B) 0)
				    (= (C (+ 1 N) A B) 0))
				(PHI A B (C N A B) N)
				(PHI A B (- (C N A B)) N)))))
	 :rule-classes ()
	 :hints (("Goal" :in-theory (disable phi c)
			 :use (lop3-20 lop3-22 lop3-23)))))

(local (defthm lop3-26
    (IMPLIES (AND (INTEGERP N)
		  (< 0 N)
		  (not (= (c n a b) 0))
		  (not (= (c (1+ n) a b) 0))
		  (not (= (c (1- n) a b) (c n a b)))
		  (INTEGERP A)
		  (< 0 A)
		  (INTEGERP B)
		  (< 0 B)
		  (= E (EXPO A))
		  (= E (EXPO B))
		  (< 0 E)
		  (INTEGERP N)
		  (<= 0 N)
		  (< N E)
		  (NOT (= (REM A (EXPT 2 (+ 1 N)))
			  (REM B (EXPT 2 (+ 1 N))))))
	     (= (bitn (lamb a b e) n) 1))
  :rule-classes ()
  :hints (("Goal" :use (bitn-lamb)))))

(local (defthm lop3-27
	   (IMPLIES (AND (INTEGERP N)
			 (< 0 N)
			 (not (= (c n a b) 0))
			 (not (= (c (1+ n) a b) 0))
			 (not (= (c (1- n) a b) (c n a b)))
			 (INTEGERP A)
			 (< 0 A)
			 (INTEGERP B)
			 (< 0 B)
			 (= E (EXPO A))
			 (= E (EXPO B))
			 (< 0 E)
			 (INTEGERP N)
			 (<= 0 N)
			 (< N E)
			 (NOT (= (REM A (EXPT 2 (+ 1 N)))
				 (REM B (EXPT 2 (+ 1 N))))))
		    (and (not (= (rem (lamb a b e) (expt 2 (1+ n))) 0))
			 (= (expo (rem (lamb a b e) (expt 2 (1+ n)))) n)))
	 :rule-classes ()
	 :hints (("Goal" :use (lop3-26
			       lamb-nat
			       (:instance lop3-2 (x (lamb a b e))))))))

(local (defthm lop3-28
    (IMPLIES (AND (INTEGERP N)
		  (< 0 N)
		  (not (= (c n a b) 0))
		  (not (= (c (1+ n) a b) 0))
		  (not (= (c (1- n) a b) (c n a b)))
		  (INTEGERP A)
		  (< 0 A)
		  (INTEGERP B)
		  (< 0 B)
		  (= E (EXPO A))
		  (= E (EXPO B))
		  (< 0 E)
		  (INTEGERP N)
		  (<= 0 N)
		  (< N E)
		  (NOT (= (REM A (EXPT 2 (+ 1 N)))
			  (REM B (EXPT 2 (+ 1 N))))))
	     (= (phi a b (- (c n a b)) n) n))
  :rule-classes ()))

(local (defthm lop3-29
	   (IMPLIES (AND (INTEGERP N)
			 (< 0 N)
			 (not (= (c n a b) 0))
			 (not (= (c (1+ n) a b) 0))
			 (not (= (c (1- n) a b) (c n a b)))
			 (INTEGERP A)
			 (< 0 A)
			 (INTEGERP B)
			 (< 0 B)
			 (= E (EXPO A))
			 (= E (EXPO B))
			 (< 0 E)
			 (INTEGERP N)
			 (<= 0 N)
			 (< N E)
			 (NOT (= (REM A (EXPT 2 (+ 1 N)))
				 (REM B (EXPT 2 (+ 1 N))))))
		    (and (not (= (rem (lamb a b e) (expt 2 (1+ n))) 0))
			 (= (EXPO (REM (LAMB A B E) (EXPT 2 (+ 1 N))))
			    (IF (OR (= (C N A B) 0)
				    (= (C (+ 1 N) A B) 0))
				(PHI A B (C N A B) N)
				(PHI A B (- (C N A B)) N)))))
	 :rule-classes ()
	 :hints (("Goal" :in-theory (disable phi c)
			 :use (lop3-27 lop3-28)))))

(local (defthm lop3-30
	   (IMPLIES (AND (INTEGERP N)
			 (< 0 N)
			 (not (= (c n a b) 0))
			 (not (= (c (1+ n) a b) 0))
			 (IMPLIES (AND (INTEGERP A)
				       (< 0 A)
				       (INTEGERP B)
				       (< 0 B)
				       (= E (EXPO A))
				       (= E (EXPO B))
				       (< 0 E)
				       (INTEGERP (+ -1 N))
				       (<= 0 (+ -1 N))
				       (< (+ -1 N) E)
				       (NOT (= (REM A (EXPT 2 (+ 1 -1 N)))
					       (REM B (EXPT 2 (+ 1 -1 N))))))
				  (and (not (= (REM (LAMB A B E) (EXPT 2 (+ 1 -1 N))) 0))
				       (= (EXPO (REM (LAMB A B E) (EXPT 2 (+ 1 -1 N))))
					  (IF (OR (= (C (+ -1 N) A B) 0)
						  (= (C (+ 1 -1 N) A B) 0))
					      (PHI A B (C (+ -1 N) A B) (+ -1 N))
					      (PHI A B (- (C (+ -1 N) A B))
						   (+ -1 N))))))
			 (INTEGERP A)
			 (< 0 A)
			 (INTEGERP B)
			 (< 0 B)
			 (= E (EXPO A))
			 (= E (EXPO B))
			 (< 0 E)
			 (INTEGERP N)
			 (<= 0 N)
			 (< N E)
			 (NOT (= (REM A (EXPT 2 (+ 1 N)))
				 (REM B (EXPT 2 (+ 1 N))))))
		    (and (not (= (rem (lamb a b e) (expt 2 (1+ n))) 0))
			 (= (EXPO (REM (LAMB A B E) (EXPT 2 (+ 1 N))))
			    (IF (OR (= (C N A B) 0)
				    (= (C (+ 1 N) A B) 0))
				(PHI A B (C N A B) N)
				(PHI A B (- (C N A B)) N)))))
	 :rule-classes ()
	 :hints (("Goal" :in-theory (disable phi c)
			 :use (lop3-25 lop3-29)))))

(local (defthm lop3-31
	   (IMPLIES (AND (INTEGERP N)
			 (< 0 N)
			 (IMPLIES (AND (INTEGERP A)
				       (< 0 A)
				       (INTEGERP B)
				       (< 0 B)
				       (= E (EXPO A))
				       (= E (EXPO B))
				       (< 0 E)
				       (INTEGERP (+ -1 N))
				       (<= 0 (+ -1 N))
				       (< (+ -1 N) E)
				       (NOT (= (REM A (EXPT 2 (+ 1 -1 N)))
					       (REM B (EXPT 2 (+ 1 -1 N))))))
				  (and (not (= (REM (LAMB A B E) (EXPT 2 (+ 1 -1 N))) 0))
				       (= (EXPO (REM (LAMB A B E) (EXPT 2 (+ 1 -1 N))))
					  (IF (OR (= (C (+ -1 N) A B) 0)
						  (= (C (+ 1 -1 N) A B) 0))
					      (PHI A B (C (+ -1 N) A B) (+ -1 N))
					      (PHI A B (- (C (+ -1 N) A B))
						   (+ -1 N))))))
			 (INTEGERP A)
			 (< 0 A)
			 (INTEGERP B)
			 (< 0 B)
			 (= E (EXPO A))
			 (= E (EXPO B))
			 (< 0 E)
			 (INTEGERP N)
			 (<= 0 N)
			 (< N E)
			 (NOT (= (REM A (EXPT 2 (+ 1 N)))
				 (REM B (EXPT 2 (+ 1 N))))))
		    (and (not (= (rem (lamb a b e) (expt 2 (1+ n))) 0))
			 (= (EXPO (REM (LAMB A B E) (EXPT 2 (+ 1 N))))
			    (IF (OR (= (C N A B) 0)
				    (= (C (+ 1 N) A B) 0))
				(PHI A B (C N A B) N)
				(PHI A B (- (C N A B)) N)))))
	 :rule-classes ()
	 :hints (("Goal" :in-theory (disable phi c)
			 :use (lop3-30 lop3-19 lop3-7)))))

(local (in-theory (disable lamb)))

(local (defthm lop3-32
    (implies (and (integerp x)
		  (> x 0)
		  (= (expo x) 1))
	     (or (= x 2) (= x 3)))
  :rule-classes ()
  :hints (("Goal" :use (expo-upper-bound expo-lower-bound)))))

(local (defthm lamb-natural
    (implies (and (integerp a)
		  (> a 0)
		  (integerp b)
		  (> b 0)
		  (not (= a b))
		  (= e (expo a))
		  (= e (expo b))
		  (> e 0))
	     (and (integerp (lamb a b e))
		  (>= (lamb a b e) 0)))
  :rule-classes ()
  :hints (("Goal" :use (lamb-nat
			(:instance lop3-32 (x a))
			(:instance lop3-32 (x b)))))))

(local (defthm lop3-33
	   (implies (and (integerp a)
			 (> a 0)
			 (integerp b)
			 (> b 0)
			 (= e (expo a))
			 (= e (expo b))
			 (> e 0)
			 (not (= (rem a 2) (rem b 2))))
		    (equal (expo (rem (lamb a b e) 2)) 0))
	 :hints (("Goal" :use (lamb-natural
			       (:instance rem012 (x (lamb a b e))))))))

(local (defthm lop3-33-1
    (implies (and (integerp a)
		  (> a 0)
		  (integerp b)
		  (> b 0)
		  (not (= a b))
		  (= e (expo a))
		  (= e (expo b))
		  (> e 1)
	          (not (= (bitn a 0) (bitn b 0))))
	     (= (bitn a 0) (bitn (comp1 b (1+ e)) 0)))
  :rule-classes ()
  :hints (("Goal" :use ((:instance expo-upper-bound (x b))
			(:instance bitn-comp1 (x b) (n (1+ e)) (k 0))
			(:instance bitn-0-1 (x a) (n 0))
			(:instance bitn-0-1 (x b) (n 0))
			(:instance bitn-0-1 (x (comp1 b (1+ e))) (n 0)))))))

(local (defthm lop3-33-2
    (implies (and (integerp a)
		  (> a 0)
		  (integerp b)
		  (> b 0)
		  (not (= a b))
		  (= e (expo a))
		  (= e (expo b))
		  (> e 1)
	          (not (= (rem a 2) (rem b 2))))
	     (= (bitn a 0) (bitn (comp1 b (1+ e)) 0)))
  :rule-classes ()
  :hints (("Goal" :use (lop3-33-1
			(:instance bitn-def (x a) (k 0))
			(:instance bitn-def (x b) (k 0)))))))

(local (defthm lop3-33-3
    (implies (and (integerp a)
		  (> a 0)
		  (integerp b)
		  (> b 0)
		  (not (= a b))
		  (= e (expo a))
		  (= e (expo b))
		  (> e 1)
	          (not (= (rem a 2) (rem b 2))))
	     (= (bitn (lamt a b e) 0) 0))
  :rule-classes ()
  :hints (("Goal" :in-theory (enable lamt)
		  :use (lop3-33-2
			(:instance expo-upper-bound (x b))
			(:instance bitn-logxor (x a) (y (comp1 b (1+ e))) (n 0))
			(:instance bitn-0-1 (x a) (n 0)))))))

(local (defthm lop3-33-4
    (implies (and (integerp a)
		  (> a 0)
		  (integerp b)
		  (> b 0)
		  (not (= a b))
		  (= e (expo a))
		  (= e (expo b))
		  (> e 1)
	          (not (= (rem a 2) (rem b 2))))
	     (not (= (rem (lamb a b e) 2) 0)))
  :rule-classes ()
  :hints (("Goal" :in-theory (enable lamb)
		  :use (lop3-33-3
			lam0-nat
			(:instance rem+ (m 1) (n 2) (a (lam0 a b e))))))))

(local (defthm lop3-34
	   (implies (and (integerp a)
			 (> a 0)
			 (integerp b)
			 (> b 0)
			 (= e (expo a))
			 (= e (expo b))
			 (> e 1)
			 (integerp n)
			 (>= n 0)
			 (< n e)
			 (not (= (rem a (expt 2 (1+ n)))
				 (rem b (expt 2 (1+ n))))))
		    (and (not (= (rem (lamb a b e) (expt 2 (1+ n))) 0))
			 (= (expo (rem (lamb a b e) (expt 2 (1+ n))))
			    (if (or (= (c n a b) 0)
				    (= (c (1+ n) a b) 0))
				(phi a b (c n a b) n)
			      (phi a b (- (c n a b)) n)))))
	 :rule-classes ()
	 :hints (("Goal" :in-theory (disable lamb)
			 :induct (nat-induct n))
		 ("Subgoal *1/2" :in-theory (disable phi c)
				 :use (lop3-31))
		 ("Subgoal *1/1" :use lop3-33-4))))

(local (in-theory (enable lam1 lam2 lam3 lam4 lam0 lamb)))

(defthm INTEGERP-COMP1
    (implies (and (integerp n)
		  (integerp x)
		  (>= n 0))
	     (integerp (comp1 x n)))
  :rule-classes (:type-prescription))

(defthm LAM1-BND
    (implies (and (integerp a)
		  (> a 0)
		  (integerp b)
		  (> b 0)
		  (not (= a b))
		  (= e (expo a))
		  (= e (expo b))
		  (> e 1)
		  (integerp k)
		  (<= k (- e 2))
		  (>= k 0))
	     (< (lam1 a b e) (expt 2 (- e 1))))
  :rule-classes ()
  :hints (("Goal" :in-theory (disable comp1 bits logand)
		  :use (lamz-nat
			lamt-nat
			lamg-nat
			(:instance comp1-bnds (x (bits (lamz a b e) (- e 2) 0)) (n (1- e)))
			(:instance bits-nat (x (lamt a b e)) (i e) (j 2))
			(:instance bits< (x (lamt a b e)) (i e) (j 2))
			(:instance bits-nat (x (lamg a b e)) (i (1- e)) (j 1))
			(:instance bits-nat (x (lamz a b e)) (i (- e 2)) (j 0))
			(:instance bits< (x (lamz a b e)) (i (- e 2)) (j 0))
			(:instance and-dist-a
				   (x (bits (lamt a b e) e 2))
				   (y (logand (bits (lamg a b e) (1- e) 1)
					      (comp1 (bits (lamz a b e) (- e 2) 0) (1- e)))))
			(:instance logand-nat
				   (i (bits (lamg a b e) (1- e) 1))
				   (j (comp1 (bits (lamz a b e) (- e 2) 0) (1- e))))))))

(defthm LAM3-BND
    (implies (and (integerp a)
		  (> a 0)
		  (integerp b)
		  (> b 0)
		  (not (= a b))
		  (= e (expo a))
		  (= e (expo b))
		  (> e 1)
		  (integerp k)
		  (<= k (- e 2))
		  (>= k 0))
	     (< (lam3 a b e) (expt 2 (- e 1))))
  :rule-classes ()
  :hints (("Goal" :in-theory (disable comp1 bits logand)
		  :use (lamg-nat
			lamt-nat
			lamz-nat
			(:instance comp1-bnds (x (bits (lamg a b e) (- e 2) 0)) (n (1- e)))
			(:instance bits-nat (x (lamt a b e)) (i e) (j 2))
			(:instance bits< (x (lamt a b e)) (i e) (j 2))
			(:instance bits-nat (x (lamz a b e)) (i (1- e)) (j 1))
			(:instance bits-nat (x (lamg a b e)) (i (- e 2)) (j 0))
			(:instance bits< (x (lamg a b e)) (i (- e 2)) (j 0))
			(:instance and-dist-a
				   (x (bits (lamt a b e) e 2))
				   (y (logand (bits (lamz a b e) (1- e) 1)
					      (comp1 (bits (lamg a b e) (- e 2) 0) (1- e)))))
			(:instance logand-nat
				   (i (bits (lamz a b e) (1- e) 1))
				   (j (comp1 (bits (lamg a b e) (- e 2) 0) (1- e))))))))

(defthm LAM2-BND
    (implies (and (integerp a)
		  (> a 0)
		  (integerp b)
		  (> b 0)
		  (not (= a b))
		  (= e (expo a))
		  (= e (expo b))
		  (> e 1)
		  (integerp k)
		  (<= k (- e 2))
		  (>= k 0))
	     (< (lam2 a b e) (expt 2 (- e 1))))
  :rule-classes ()
  :hints (("Goal" :in-theory (disable comp1 bits logand)
		  :use (lamz-nat
			lamt-nat
			(:instance comp1-bnds (x (bits (lamt a b e) e 2)) (n (1- e)))
			(:instance comp1-bnds (x (bits (lamz a b e) (- e 2) 0)) (n (1- e)))
			(:instance bits-nat (x (lamt a b e)) (i e) (j 2))
			(:instance bits< (x (lamt a b e)) (i e) (j 2))
			(:instance bits-nat (x (lamz a b e)) (i (1- e)) (j 1))
			(:instance bits-nat (x (lamz a b e)) (i (- e 2)) (j 0))
			(:instance bits< (x (lamz a b e)) (i (- e 2)) (j 0))
			(:instance and-dist-a
				   (x (comp1 (bits (lamt a b e) e 2) (1- e)))
				   (y (logand (bits (lamz a b e) (1- e) 1)
					      (comp1 (bits (lamz a b e) (- e 2) 0) (1- e)))))
			(:instance logand-nat
				   (i (bits (lamz a b e) (1- e) 1))
				   (j (comp1 (bits (lamz a b e) (- e 2) 0) (1- e))))))))

(defthm LAM4-BND
    (implies (and (integerp a)
		  (> a 0)
		  (integerp b)
		  (> b 0)
		  (not (= a b))
		  (= e (expo a))
		  (= e (expo b))
		  (> e 1)
		  (integerp k)
		  (<= k (- e 2))
		  (>= k 0))
	     (< (lam4 a b e) (expt 2 (- e 1))))
  :rule-classes ()
  :hints (("Goal" :in-theory (disable comp1 bits logand)
		  :use (lamg-nat
			lamt-nat
			(:instance comp1-bnds (x (bits (lamt a b e) e 2)) (n (1- e)))
			(:instance comp1-bnds (x (bits (lamg a b e) (- e 2) 0)) (n (1- e)))
			(:instance bits-nat (x (lamt a b e)) (i e) (j 2))
			(:instance bits< (x (lamt a b e)) (i e) (j 2))
			(:instance bits-nat (x (lamg a b e)) (i (1- e)) (j 1))
			(:instance bits-nat (x (lamg a b e)) (i (- e 2)) (j 0))
			(:instance bits< (x (lamg a b e)) (i (- e 2)) (j 0))
			(:instance and-dist-a
				   (x (comp1 (bits (lamt a b e) e 2) (1- e)))
				   (y (logand (bits (lamg a b e) (1- e) 1)
					      (comp1 (bits (lamg a b e) (- e 2) 0) (1- e)))))
			(:instance logand-nat
				   (i (bits (lamg a b e) (1- e) 1))
				   (j (comp1 (bits (lamg a b e) (- e 2) 0) (1- e))))))))

(local (defthm lam0-bnd-1
    (implies (and (integerp a)
		  (> a 0)
		  (integerp b)
		  (> b 0)
		  (not (= a b))
		  (= e (expo a))
		  (= e (expo b))
		  (> e 1))
	     (and (integerp (logior (lam3 a b e) (lam4 a b e)))
		  (>= (logior (lam3 a b e) (lam4 a b e))
		      0)
		  (< (logior (lam3 a b e) (lam4 a b e))
		     (expt 2 (- e 1)))))
  :rule-classes ()
  :hints (("Goal" :in-theory (disable lam1 lam2 lam3 lam4 logior)
		  :use ((:instance lam3-bnd (k 0))
			(:instance lam4-bnd (k 0))
			(:instance lam3-nat (k 0))
			(:instance lam4-nat (k 0))
			(:instance or-dist-a (n (- e 1)) (x (lam3 a b e)) (y (lam4 a b e)))
			(:instance logior-nat (i (lam3 a b e)) (j (lam4 a b e))))))))

(local (defthm lam0-bnd-2
    (implies (and (integerp a)
		  (> a 0)
		  (integerp b)
		  (> b 0)
		  (not (= a b))
		  (= e (expo a))
		  (= e (expo b))
		  (> e 1))
	     (and (integerp (logior (lam2 a b e)
				    (logior (lam3 a b e)
					    (lam4 a b e))))
		  (>= (logior (lam2 a b e)
			      (logior (lam3 a b e)
				      (lam4 a b e)))
		      0)
		  (< (logior (lam2 a b e)
			     (logior (lam3 a b e)
				     (lam4 a b e)))
		     (expt 2 (- e 1)))))
  :rule-classes ()
  :hints (("Goal" :in-theory (disable lam1 lam2 lam3 lam4 logior)
		  :use (lam0-bnd-1
			(:instance lam2-bnd (k 0))
			(:instance lam2-nat (k 0))
			(:instance or-dist-a
				   (n (- e 1))
				   (x (lam2 a b e))
				   (y (logior (lam3 a b e) (lam4 a b e))))
			(:instance logior-nat
				   (i (lam2 a b e))
				   (j (logior (lam3 a b e) (lam4 a b e)))))))))

(defthm LAM0-BND
    (implies (and (integerp a)
		  (> a 0)
		  (integerp b)
		  (> b 0)
		  (not (= a b))
		  (= e (expo a))
		  (= e (expo b))
		  (> e 1))
	     (< (lam0 a b e) (expt 2 (- e 1))))
  :rule-classes ()
  :hints (("Goal" :in-theory (disable lam1 lam2 lam3 lam4 logior)
		  :use (lam0-bnd-2
			(:instance lam1-nat (k 0))
			(:instance lam1-bnd (k 0))
			(:instance or-dist-a
				   (n (- e 1))
				   (x (lam1 a b e))
				   (y (logior (lam2 a b e)
					      (logior (lam3 a b e)
						      (lam4 a b e)))))))))

(local (in-theory (disable lam1 lam2 lam3 lam4 lam0)))

(defthm LAMB-BND
    (implies (and (integerp a)
		  (> a 0)
		  (integerp b)
		  (> b 0)
		  (not (= a b))
		  (= e (expo a))
		  (= e (expo b))
		  (> e 1))
	     (< (lamb a b e) (expt 2 e)))
  :rule-classes ()
  :hints (("Goal" :use (lam0-bnd
			lam0-nat
			(:instance bitn-0-1 (x (lamt a b e)) (n 0))))))

(local (in-theory (disable lamb)))

(local (defthm lamb-rem
    (implies (and (integerp a)
		  (> a 0)
		  (integerp b)
		  (> b 0)
		  (not (= a b))
		  (= e (expo a))
		  (= e (expo b))
		  (> e 1))
	     (= (rem (lamb a b e) (expt 2 e))
		(lamb a b e)))
  :rule-classes ()
  :hints (("Goal" :use (lamb-bnd
			lamb-nat
			(:instance rem< (m (lamb a b e)) (n (expt 2 e))))))))

(local (defthm lop3-35
    (implies (and (integerp a)
		  (> a 0)
		  (integerp b)
		  (> b 0)
		  (= e (expo a))
		  (= e (expo b))
		  (> e 1)
		  (= (c e a b) 0)
		  (not (= (rem a (expt 2 e))
			  (rem b (expt 2 e)))))
	     (and (not (= (rem (lamb a b e) (expt 2 e)) 0))
		  (= (expo (rem (lamb a b e) (expt 2 e)))
		     (phi a b (c (- e 1) a b) (- e 1)))))
  :rule-classes ()
  :hints (("Goal" :use ((:instance lop3-34 (n (- e 1))))))))

(local (defthm lop3-36
    (implies (and (integerp a)
		  (> a 0)
		  (integerp b)
		  (> b 0)
		  (not (= a b))
		  (= e (expo a))
		  (= e (expo b))
		  (> e 1)
		  (= (c e a b) 0)
		  (not (= (rem a (expt 2 e))
			  (rem b (expt 2 e)))))
	     (and (not (= (lamb a b e) 0))
		  (= (expo (lamb a b e))
		     (phi a b (c (- e 1) a b) (- e 1)))))
  :rule-classes ()
  :hints (("Goal" :use (lop3-35 lamb-rem)))))

(local (defthm lop3-37
    (implies (and (integerp a)
		  (> a 0)
		  (integerp b)
		  (> b 0)
		  (not (= a b))
		  (= e (expo a))
		  (= e (expo b))
		  (> e 1)
		  (not (= (rem a (expt 2 e))
			  (rem b (expt 2 e)))))
	     (and (not (= (lamb a b e) 0))
		  (= (expo (lamb a b e))
		     (phi a b (c (- e 1) a b) (- e 1)))))
  :rule-classes ()
  :hints (("Goal" :use (lop3-36
			(:instance expo-upper-bound (x a))
			(:instance expo-upper-bound (x b))
			(:instance expo-lower-bound (x a))
			(:instance expo-lower-bound (x b))
			(:instance bit-expo-b (x a) (n e))
			(:instance bit-expo-b (x b) (n e)))))))

(local (defthm lop3-38
    (implies (and (integerp a)
		  (> a 0)
		  (integerp b)
		  (> b 0)
		  (not (= a b))
		  (= e (expo a))
		  (= e (expo b))
		  (> e 1))
	     (and (not (= (lamb a b e) 0))
		  (= (expo (lamb a b e))
		     (phi a b (c (- e 1) a b) (- e 1)))))
  :rule-classes ()
  :hints (("Goal" :use (lop3-37
			(:instance expo-upper-bound (x a))
			(:instance expo-upper-bound (x b))
			(:instance expo-lower-bound (x a))
			(:instance expo-lower-bound (x b))
			(:instance bit-expo-b (x a) (n e))
			(:instance bit-expo-b (x b) (n e))
			(:instance rem< (m a) (n (expt 2 (1+ e))))
			(:instance rem< (m b) (n (expt 2 (1+ e))))
			(:instance lop3-1 (n e)))))))

(local (defthm lop3-39
    (implies (and (integerp a)
		  (> a 0)
		  (integerp b)
		  (> b 0)
		  (not (= a b))
		  (= e (expo a))
		  (= e (expo b))
		  (> e 1))
	     (= (phi a b 0 (1+ e))
		(phi a b (c (- e 1) a b) (- e 1))))
  :rule-classes ()
  :hints (("Goal" :use ((:instance expo-upper-bound (x a))
			(:instance expo-upper-bound (x b))
			(:instance expo-lower-bound (x a))
			(:instance expo-lower-bound (x b))
			(:instance bit-expo-b (x a) (n e))
			(:instance bit-expo-b (x b) (n e)))))))

(local (defthm lop3-40
    (implies (and (integerp a)
		  (> a 0)
		  (integerp b)
		  (> b 0)
		  (not (= a b))
		  (= e (expo a))
		  (= e (expo b))
		  (> e 1))
	     (= (expo (lamb a b e))
		(phi a b 0 (1+ e))))
  :rule-classes ()
  :hints (("Goal" :use (lop3-38 lop3-39)))))

(defthm LOP-THM-3
    (implies (and (integerp a)
		  (> a 0)
		  (integerp b)
		  (> b 0)
		  (not (= a b))
		  (= e (expo a))
		  (= e (expo b))
		  (> e 1))
	     (and (not (= (lamb a b e) 0))
		  (or (= (expo (- a b)) (expo (lamb a b e)))
		      (= (expo (- a b)) (1- (expo (lamb a b e)))))))
  :rule-classes ()
  :hints (("Goal" :use (lop3-40
			lop3-38
			(:instance lop-thm-1 (n (1+ e)))
			(:instance expo-upper-bound (x a))
			(:instance expo-upper-bound (x b))))))