!!****m* ABINIT/defs_scftypes
!! NAME
!! defs_scftypes
!!
!! FUNCTION
!! This module contains definitions of high-level structured datatypes for the
!! ABINIT package, related to the routine scfcv.F90.
!!
!! If you are sure a new high-level structured datatype is needed,
!! write it here, and DOCUMENT it properly (not all datastructure here are
!! well documented, it is a shame ...).
!! Do not forget : you will likely be the major winner if you document
!! properly.
!! Proper documentation of a structured datatype means :
!!  (1) Mention it in the list just below
!!  (2) Describe it in the NOTES section
!!  (3) Put it in alphabetical order in the the main section of this module
!!  (4) Document each of its records, except if they are described elsewhere
!!      (this exception is typically the case of the dataset associated with
!!      input variables, for which there is a help file)
!!  (5) Declare variables on separated lines in order to reduce the occurence of bzr conflicts.
!!
!! List of datatypes :
!! * ab_scfcv_args_in   : a container for all the input arguments of the
!!                   scfcv routine
!! * ab_scfcv_args_inout: a container for all the input/output arguments
!!                   of the scfcv routine
!!
!!                   These variables are excluded:
!!
!!                   type(electronpositron_type) :: electronpositron
!!                     (Definition too high 56>50)
!!                   type(wffile_type) :: wffnew,wffnow
!!                     (Definition too high 51>50)
!!                   type(paw_dmft_type) :: paw_dmft
!!                     (Definition too high 66>50)
!!
!!                   real(dp), pointer :: xred(:,:),xred_old(:,:)
!!                     (General argument)
!!                   real(dp), pointer :: rprimd(:,:)
!!                     (General argument)
!!
!!                  type(dataset_type) :: dtset
!!                     (Too basic, used inside mover)
!!
!! COPYRIGHT
!! Copyright (C) 2001-2014 ABINIT group (XG)
!! This file is distributed under the terms of the
!! GNU General Public License, see ~abinit/COPYING
!! or http://www.gnu.org/copyleft/gpl.txt .
!!
!! SOURCE

#if defined HAVE_CONFIG_H
#include "config.h"
#endif

#include "abi_common.h"


module defs_scftypes

 use defs_basis
 use defs_datatypes
 use defs_abitypes
 use m_profiling

 use defs_rectypes, only : recursion_type
 use defs_wvltypes, only : wvl_data
 use m_results_gs , only : results_gs_type
 use m_scf_history, only : scf_history_type
 use m_bfield,      only : bfield_type
 use m_efield,      only : efield_type
 use m_pawang,      only : pawang_type
 use m_pawrad,      only : pawrad_type
 use m_pawtab,      only : pawtab_type
 use m_pawrhoij,    only : pawrhoij_type
 use m_pawfgr,      only : pawfgr_type

 implicit none
!!***

!!****t* defs_scftypes/ab_scfcv_args_in
!! NAME
!! ab_scfcv_args_in
!!
!! FUNCTION
!! This datatype has the purpouse of store all the input only
!! arguments needed by the routine scfcv
!!
!! SOURCE

type ab_scfcv_args_in

!scalars
 integer,pointer :: iapp => null()
 integer,pointer :: mcg => null()
 integer,pointer :: my_natom => null()
 integer,pointer :: ndtpawuj => null()
 integer,pointer :: pwind_alloc => null()
 real(dp),pointer :: cpus => null()
 real(dp),pointer :: ecore  => null()
 real(dp),pointer :: fatvshift => null()
 type(pawang_type),pointer :: pawang => null()
 type(pseudopotential_type),pointer :: psps => null()

!arrays
 integer,pointer :: atindx(:) => null()
 integer,pointer :: atindx1(:) => null()
 integer,pointer :: indsym(:,:,:) => null()
!no_abirules
 integer, pointer :: kg(:,:) => null()
 integer, pointer :: nattyp(:) => null() 
 integer, pointer :: npwarr(:) => null()
 integer, pointer :: pwind(:,:,:) => null()
 real(dp), pointer :: phnons(:,:,:) => null()
 real(dp), pointer :: pwnsfac(:,:) => null()
 real(dp), pointer :: ylm(:,:) => null()
 real(dp), pointer :: ylmgr(:,:,:) => null()
 type(pawrad_type), pointer :: pawrad(:) => null()
 type(pawtab_type), pointer :: pawtab(:) => null()

end type ab_scfcv_args_in
!!***

!!****t* defs_scftypes/ab_scfcv_args_inout
!! NAME
!! ab_scfcv_args_inout
!!
!! FUNCTION
!! This datatype has the purpouse of store most of the
!! ioput/output arguments needed by the routine scfcv
!!
!! SOURCE

type ab_scfcv_args_inout

!scalars
  integer,pointer :: initialized => null()
  integer,pointer :: nfftf => null()
  type(MPI_type),pointer :: mpi_enreg => null()
  type(datafiles_type),pointer :: dtfil => null()
!  type(dataset_type),pointer :: dtset => null()
  type(bfield_type),pointer :: dtbfield => null()
  type(efield_type),pointer :: dtefield => null()
!  type(electronpositron_type),pointer :: electronpositron => null()
  type(hdr_type),pointer :: hdr => null()
  type(pawfgr_type),pointer :: pawfgr => null()
  type(recursion_type),pointer :: rec_set => null()
  type(results_gs_type),pointer :: results_gs => null()
  type(scf_history_type),pointer :: scf_history => null()
!  type(wffile_type),pointer :: wffnew,wffnow => null()
  type(wvl_data),pointer :: wvl => null()
!  type(paw_dmft_type), pointer :: paw_dmft => null()

!arrays
  integer, pointer :: irrzon(:,:,:) => null()
  integer, pointer :: symrec(:,:,:) => null()
  real(dp), pointer :: cg(:,:) => null()
  real(dp), pointer :: eigen(:) => null()
  real(dp), pointer :: occ(:) => null()
!  real(dp), pointer :: rprimd(:,:)
  real(dp), pointer :: rhog(:,:) => null()
  real(dp), pointer :: rhor(:,:) => null()
  real(dp), pointer :: taug(:,:) => null()
  real(dp), pointer :: taur(:,:) => null()
  real(dp), pointer :: resid(:) => null()
!  real(dp), pointer :: xred(:,:),xred_old(:,:) => null()
  type(macro_uj_type),pointer :: dtpawuj(:) => null()
  type(pawrhoij_type), pointer :: pawrhoij(:) => null()

end type ab_scfcv_args_inout
!!***

end module defs_scftypes
!!***
