// Generated by re2zig
// re2zig $INPUT -o $OUTPUT

const std = @import("std");

const SemVer = struct {
    major: u32,
    minor: u32,
    patch: u32,
};

const none = std.math.maxInt(usize);

fn s2n(str: []const u8) u32 { // convert a pre-parsed string to a number
    var n: u32 = 0;
    for (str) |c| { n = n * 10 + (c - 48); }
    return n;
}

fn parse(yyinput: [:0]const u8) ?SemVer {
    var yycursor: usize = 0;
    var yymarker: usize = 0;

    // Final tag variables available in semantic action.
    var t1: usize = none;var t2: usize = none;var t3: usize = none;var t4: usize = none;var t5: usize = none;

    // Intermediate tag variables used by the lexer (must be autogenerated).
    var yyt1: usize = none;var yyt2: usize = none;var yyt3: usize = none;var yyt4: usize = none;

    
    var yych: u8 = 0;
    var yystate: u32 = 0;
    yyl: while (true) {
        switch (yystate) {
            0 => {
                yych = yyinput[yycursor];
                switch (yych) {
                    0x30...0x39 => {
                        yyt1 = yycursor;
                        yycursor += 1;
                        yystate = 3;
                        continue :yyl;
                    },
                    else => {
                        yycursor += 1;
                        yystate = 1;
                        continue :yyl;
                    },
                }
            },
            1 => {
                yystate = 2;
                continue :yyl;
            },
            2 => { return null; },
            3 => {
                yymarker = yycursor;
                yych = yyinput[yycursor];
                switch (yych) {
                    0x2E => {
                        yycursor += 1;
                        yystate = 4;
                        continue :yyl;
                    },
                    0x30...0x39 => {
                        yycursor += 1;
                        yystate = 6;
                        continue :yyl;
                    },
                    else => {
                        yystate = 2;
                        continue :yyl;
                    },
                }
            },
            4 => {
                yych = yyinput[yycursor];
                switch (yych) {
                    0x30...0x39 => {
                        yyt2 = yycursor;
                        yycursor += 1;
                        yystate = 7;
                        continue :yyl;
                    },
                    else => {
                        yystate = 5;
                        continue :yyl;
                    },
                }
            },
            5 => {
                yycursor = yymarker;
                yystate = 2;
                continue :yyl;
            },
            6 => {
                yych = yyinput[yycursor];
                switch (yych) {
                    0x2E => {
                        yycursor += 1;
                        yystate = 4;
                        continue :yyl;
                    },
                    0x30...0x39 => {
                        yycursor += 1;
                        yystate = 6;
                        continue :yyl;
                    },
                    else => {
                        yystate = 5;
                        continue :yyl;
                    },
                }
            },
            7 => {
                yych = yyinput[yycursor];
                switch (yych) {
                    0x00 => {
                        yyt3 = yycursor;
                        yyt4 = std.math.maxInt(usize);
                        yycursor += 1;
                        yystate = 8;
                        continue :yyl;
                    },
                    0x2E => {
                        yyt3 = yycursor;
                        yycursor += 1;
                        yystate = 9;
                        continue :yyl;
                    },
                    0x30...0x39 => {
                        yycursor += 1;
                        yystate = 7;
                        continue :yyl;
                    },
                    else => {
                        yystate = 5;
                        continue :yyl;
                    },
                }
            },
            8 => {
                t1 = yyt1;
                t3 = yyt2;
                t4 = yyt3;
                t5 = yyt4;
                t2 = yyt2;
                t2 -= 1;
                
            return SemVer {
                .major = s2n(yyinput[t1..t2]),
                .minor = s2n(yyinput[t3..t4]),
                .patch = if (t5 == none) 0 else s2n(yyinput[t5..yycursor - 1]),
            };

            },
            9 => {
                yych = yyinput[yycursor];
                switch (yych) {
                    0x30...0x39 => {
                        yyt4 = yycursor;
                        yycursor += 1;
                        yystate = 10;
                        continue :yyl;
                    },
                    else => {
                        yystate = 5;
                        continue :yyl;
                    },
                }
            },
            10 => {
                yych = yyinput[yycursor];
                switch (yych) {
                    0x00 => {
                        yycursor += 1;
                        yystate = 8;
                        continue :yyl;
                    },
                    0x30...0x39 => {
                        yycursor += 1;
                        yystate = 10;
                        continue :yyl;
                    },
                    else => {
                        yystate = 5;
                        continue :yyl;
                    },
                }
            },
            else => { @panic("internal lexer error"); },
        }
    }

}

test {
    try std.testing.expectEqual(parse("23.34"), SemVer{.major = 23, .minor = 34, .patch = 0});
    try std.testing.expectEqual(parse("1.2.99999"), SemVer{.major = 1, .minor = 2, .patch = 99999});
    try std.testing.expectEqual(parse("1.a"), null);
}
