/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.collect.testing.google;

import com.google.common.annotations.GwtCompatible;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSortedMap;
import com.google.common.collect.testing.TestStringSortedMapGenerator;
import java.util.Map;

@GwtCompatible
public class SortedMapGenerators {

    public static class ImmutableSortedMapGenerator
    extends TestStringSortedMapGenerator {
        @Override
        public Map<String, String> create(Map.Entry<String, String>[] entries) {
            ImmutableSortedMap.Builder builder = ImmutableSortedMap.naturalOrder();
            for (Map.Entry<String, String> entry : entries) {
                Preconditions.checkNotNull(entry);
                builder.put((Object)entry.getKey(), (Object)entry.getValue());
            }
            return builder.build();
        }
    }
}

