%%
%% %CopyrightBegin%
%%
%% Copyright Ericsson AB 2008-2013. All Rights Reserved.
%%
%% Licensed under the Apache License, Version 2.0 (the "License");
%% you may not use this file except in compliance with the License.
%% You may obtain a copy of the License at
%%
%%     http://www.apache.org/licenses/LICENSE-2.0
%%
%% Unless required by applicable law or agreed to in writing, software
%% distributed under the License is distributed on an "AS IS" BASIS,
%% WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
%% See the License for the specific language governing permissions and
%% limitations under the License.
%%
%% %CopyrightEnd%
%%
-module(re_testoutput1_split_test).
-compile(export_all).
-compile(no_native).
%% This file is generated by running run_pcre_tests:gen_split_test("re_SUITE_data/testoutput1")
join([]) -> [];
join([A]) -> [A];
join([H|T]) -> [H,<<":">>|join(T)].
run() ->
    run0(),
    run1(),
    run2(),
    run3(),
    run4(),
    run5(),
    run6(),
    run7(),
    run8(),
    run9(),
    run10(),
    run11(),
    run12(),
    run13(),
    run14(),
    run15(),
    run16(),
    run17(),
    run18(),
    run19(),
    run20(),
    run21(),
    run22(),
    run23(),
    run24(),
    run25(),
    run26(),
    run27(),
    run28(),
    run29(),
    run30(),
    run31(),
    run32(),
    run33(),
    run34(),
    run35(),
    run36(),
    run37(),
    run38(),
    run39(),
    run40(),
    run41(),
    run42(),
    run43(),
    run44(),
    run45(),
    run46(),
    run47(),
    run48(),
    run49(),
    run50(),
    run51(),
    run52(),
    run53(),
    run54(),
    ok.
run0() ->
    <<"">> = iolist_to_binary(join(re:split("the quick brown fox","the quick brown fox",[trim]))), 
    <<":">> = iolist_to_binary(join(re:split("the quick brown fox","the quick brown fox",[{parts,
                                                                                                                                                                                                                            2}]))), 
    <<":">> = iolist_to_binary(join(re:split("the quick brown fox","the quick brown fox",[]))), 
    <<"The quick brown FOX">> = iolist_to_binary(join(re:split("The quick brown FOX","the quick brown fox",[trim]))), 
    <<"The quick brown FOX">> = iolist_to_binary(join(re:split("The quick brown FOX","the quick brown fox",[{parts,
                                                                                                                                                                                                                            2}]))), 
    <<"The quick brown FOX">> = iolist_to_binary(join(re:split("The quick brown FOX","the quick brown fox",[]))), 
    <<"What do you know about :?">> = iolist_to_binary(join(re:split("What do you know about the quick brown fox?","the quick brown fox",[trim]))), 
    <<"What do you know about :?">> = iolist_to_binary(join(re:split("What do you know about the quick brown fox?","the quick brown fox",[{parts,
                                                                                                                                                                                                                                                                            2}]))), 
    <<"What do you know about :?">> = iolist_to_binary(join(re:split("What do you know about the quick brown fox?","the quick brown fox",[]))), 
    <<"What do you know about THE QUICK BROWN FOX?">> = iolist_to_binary(join(re:split("What do you know about THE QUICK BROWN FOX?","the quick brown fox",[trim]))), 
    <<"What do you know about THE QUICK BROWN FOX?">> = iolist_to_binary(join(re:split("What do you know about THE QUICK BROWN FOX?","the quick brown fox",[{parts,
                                                                                                                                                                                                                                                                            2}]))), 
    <<"What do you know about THE QUICK BROWN FOX?">> = iolist_to_binary(join(re:split("What do you know about THE QUICK BROWN FOX?","the quick brown fox",[]))), 
    <<"">> = iolist_to_binary(join(re:split("the quick brown fox","The quick brown fox",[caseless,
                                                                                                                                                                                                                          trim]))), 
    <<":">> = iolist_to_binary(join(re:split("the quick brown fox","The quick brown fox",[caseless,
                                                                                                                                                                                                                            {parts,
                                                                                                                                                                                                                             2}]))), 
    <<":">> = iolist_to_binary(join(re:split("the quick brown fox","The quick brown fox",[caseless]))), 
    <<"">> = iolist_to_binary(join(re:split("The quick brown FOX","The quick brown fox",[caseless,
                                                                                                                                                                                                                          trim]))), 
    <<":">> = iolist_to_binary(join(re:split("The quick brown FOX","The quick brown fox",[caseless,
                                                                                                                                                                                                                            {parts,
                                                                                                                                                                                                                             2}]))), 
    <<":">> = iolist_to_binary(join(re:split("The quick brown FOX","The quick brown fox",[caseless]))), 
    <<"What do you know about :?">> = iolist_to_binary(join(re:split("What do you know about the quick brown fox?","The quick brown fox",[caseless,
                                                                                                                                                                                                                                                                          trim]))), 
    <<"What do you know about :?">> = iolist_to_binary(join(re:split("What do you know about the quick brown fox?","The quick brown fox",[caseless,
                                                                                                                                                                                                                                                                            {parts,
                                                                                                                                                                                                                                                                             2}]))), 
    <<"What do you know about :?">> = iolist_to_binary(join(re:split("What do you know about the quick brown fox?","The quick brown fox",[caseless]))), 
    <<"What do you know about :?">> = iolist_to_binary(join(re:split("What do you know about THE QUICK BROWN FOX?","The quick brown fox",[caseless,
                                                                                                                                                                                                                                                                          trim]))), 
    <<"What do you know about :?">> = iolist_to_binary(join(re:split("What do you know about THE QUICK BROWN FOX?","The quick brown fox",[caseless,
                                                                                                                                                                                                                                                                            {parts,
                                                                                                                                                                                                                                                                             2}]))), 
    <<"What do you know about :?">> = iolist_to_binary(join(re:split("What do you know about THE QUICK BROWN FOX?","The quick brown fox",[caseless]))), 
    <<"">> = iolist_to_binary(join(re:split("abcd	

9;$\\?caxyz","abcd\\t\\n\\r\\f\\a\\e\\071\\x3b\\$\\\\\\?caxyz",[trim]))), 
    <<":">> = iolist_to_binary(join(re:split("abcd	

9;$\\?caxyz","abcd\\t\\n\\r\\f\\a\\e\\071\\x3b\\$\\\\\\?caxyz",[{parts,
                                                                                                    2}]))), 
    <<":">> = iolist_to_binary(join(re:split("abcd	

9;$\\?caxyz","abcd\\t\\n\\r\\f\\a\\e\\071\\x3b\\$\\\\\\?caxyz",[]))), 
    <<"">> = iolist_to_binary(join(re:split("abxyzpqrrrabbxyyyypqAzz","a*abc?xyz+pqr{3}ab{2,}xy{4,5}pq{0,6}AB{0,}zz",[trim]))), 
    <<":">> = iolist_to_binary(join(re:split("abxyzpqrrrabbxyyyypqAzz","a*abc?xyz+pqr{3}ab{2,}xy{4,5}pq{0,6}AB{0,}zz",[{parts,
                                                                                                                                                                                                                                                                                      2}]))), 
    <<":">> = iolist_to_binary(join(re:split("abxyzpqrrrabbxyyyypqAzz","a*abc?xyz+pqr{3}ab{2,}xy{4,5}pq{0,6}AB{0,}zz",[]))), 
    <<"">> = iolist_to_binary(join(re:split("abxyzpqrrrabbxyyyypqAzz","a*abc?xyz+pqr{3}ab{2,}xy{4,5}pq{0,6}AB{0,}zz",[trim]))), 
    <<":">> = iolist_to_binary(join(re:split("abxyzpqrrrabbxyyyypqAzz","a*abc?xyz+pqr{3}ab{2,}xy{4,5}pq{0,6}AB{0,}zz",[{parts,
                                                                                                                                                                                                                                                                                      2}]))), 
    <<":">> = iolist_to_binary(join(re:split("abxyzpqrrrabbxyyyypqAzz","a*abc?xyz+pqr{3}ab{2,}xy{4,5}pq{0,6}AB{0,}zz",[]))), 
    <<"">> = iolist_to_binary(join(re:split("aabxyzpqrrrabbxyyyypqAzz","a*abc?xyz+pqr{3}ab{2,}xy{4,5}pq{0,6}AB{0,}zz",[trim]))), 
    <<":">> = iolist_to_binary(join(re:split("aabxyzpqrrrabbxyyyypqAzz","a*abc?xyz+pqr{3}ab{2,}xy{4,5}pq{0,6}AB{0,}zz",[{parts,
                                                                                                                                                                                                                                                                                        2}]))), 
    <<":">> = iolist_to_binary(join(re:split("aabxyzpqrrrabbxyyyypqAzz","a*abc?xyz+pqr{3}ab{2,}xy{4,5}pq{0,6}AB{0,}zz",[]))), 
    <<"">> = iolist_to_binary(join(re:split("aaabxyzpqrrrabbxyyyypqAzz","a*abc?xyz+pqr{3}ab{2,}xy{4,5}pq{0,6}AB{0,}zz",[trim]))), 
    <<":">> = iolist_to_binary(join(re:split("aaabxyzpqrrrabbxyyyypqAzz","a*abc?xyz+pqr{3}ab{2,}xy{4,5}pq{0,6}AB{0,}zz",[{parts,
                                                                                                                                                                                                                                                                                          2}]))), 
    <<":">> = iolist_to_binary(join(re:split("aaabxyzpqrrrabbxyyyypqAzz","a*abc?xyz+pqr{3}ab{2,}xy{4,5}pq{0,6}AB{0,}zz",[]))), 
    <<"">> = iolist_to_binary(join(re:split("aaaabxyzpqrrrabbxyyyypqAzz","a*abc?xyz+pqr{3}ab{2,}xy{4,5}pq{0,6}AB{0,}zz",[trim]))), 
    <<":">> = iolist_to_binary(join(re:split("aaaabxyzpqrrrabbxyyyypqAzz","a*abc?xyz+pqr{3}ab{2,}xy{4,5}pq{0,6}AB{0,}zz",[{parts,
                                                                                                                                                                                                                                                                                            2}]))), 
    <<":">> = iolist_to_binary(join(re:split("aaaabxyzpqrrrabbxyyyypqAzz","a*abc?xyz+pqr{3}ab{2,}xy{4,5}pq{0,6}AB{0,}zz",[]))), 
    <<"">> = iolist_to_binary(join(re:split("abcxyzpqrrrabbxyyyypqAzz","a*abc?xyz+pqr{3}ab{2,}xy{4,5}pq{0,6}AB{0,}zz",[trim]))), 
    <<":">> = iolist_to_binary(join(re:split("abcxyzpqrrrabbxyyyypqAzz","a*abc?xyz+pqr{3}ab{2,}xy{4,5}pq{0,6}AB{0,}zz",[{parts,
                                                                                                                                                                                                                                                                                        2}]))), 
    <<":">> = iolist_to_binary(join(re:split("abcxyzpqrrrabbxyyyypqAzz","a*abc?xyz+pqr{3}ab{2,}xy{4,5}pq{0,6}AB{0,}zz",[]))), 
    <<"">> = iolist_to_binary(join(re:split("aabcxyzpqrrrabbxyyyypqAzz","a*abc?xyz+pqr{3}ab{2,}xy{4,5}pq{0,6}AB{0,}zz",[trim]))), 
    <<":">> = iolist_to_binary(join(re:split("aabcxyzpqrrrabbxyyyypqAzz","a*abc?xyz+pqr{3}ab{2,}xy{4,5}pq{0,6}AB{0,}zz",[{parts,
                                                                                                                                                                                                                                                                                          2}]))), 
    <<":">> = iolist_to_binary(join(re:split("aabcxyzpqrrrabbxyyyypqAzz","a*abc?xyz+pqr{3}ab{2,}xy{4,5}pq{0,6}AB{0,}zz",[]))), 
    <<"">> = iolist_to_binary(join(re:split("aaabcxyzpqrrrabbxyyyypAzz","a*abc?xyz+pqr{3}ab{2,}xy{4,5}pq{0,6}AB{0,}zz",[trim]))), 
    <<":">> = iolist_to_binary(join(re:split("aaabcxyzpqrrrabbxyyyypAzz","a*abc?xyz+pqr{3}ab{2,}xy{4,5}pq{0,6}AB{0,}zz",[{parts,
                                                                                                                                                                                                                                                                                          2}]))), 
    <<":">> = iolist_to_binary(join(re:split("aaabcxyzpqrrrabbxyyyypAzz","a*abc?xyz+pqr{3}ab{2,}xy{4,5}pq{0,6}AB{0,}zz",[]))), 
    <<"">> = iolist_to_binary(join(re:split("aaabcxyzpqrrrabbxyyyypqAzz","a*abc?xyz+pqr{3}ab{2,}xy{4,5}pq{0,6}AB{0,}zz",[trim]))), 
    <<":">> = iolist_to_binary(join(re:split("aaabcxyzpqrrrabbxyyyypqAzz","a*abc?xyz+pqr{3}ab{2,}xy{4,5}pq{0,6}AB{0,}zz",[{parts,
                                                                                                                                                                                                                                                                                            2}]))), 
    <<":">> = iolist_to_binary(join(re:split("aaabcxyzpqrrrabbxyyyypqAzz","a*abc?xyz+pqr{3}ab{2,}xy{4,5}pq{0,6}AB{0,}zz",[]))), 
    <<"">> = iolist_to_binary(join(re:split("aaabcxyzpqrrrabbxyyyypqqAzz","a*abc?xyz+pqr{3}ab{2,}xy{4,5}pq{0,6}AB{0,}zz",[trim]))), 
    <<":">> = iolist_to_binary(join(re:split("aaabcxyzpqrrrabbxyyyypqqAzz","a*abc?xyz+pqr{3}ab{2,}xy{4,5}pq{0,6}AB{0,}zz",[{parts,
                                                                                                                                                                                                                                                                                              2}]))), 
    <<":">> = iolist_to_binary(join(re:split("aaabcxyzpqrrrabbxyyyypqqAzz","a*abc?xyz+pqr{3}ab{2,}xy{4,5}pq{0,6}AB{0,}zz",[]))), 
    <<"">> = iolist_to_binary(join(re:split("aaabcxyzpqrrrabbxyyyypqqqAzz","a*abc?xyz+pqr{3}ab{2,}xy{4,5}pq{0,6}AB{0,}zz",[trim]))), 
    <<":">> = iolist_to_binary(join(re:split("aaabcxyzpqrrrabbxyyyypqqqAzz","a*abc?xyz+pqr{3}ab{2,}xy{4,5}pq{0,6}AB{0,}zz",[{parts,
                                                                                                                                                                                                                                                                                                2}]))), 
    <<":">> = iolist_to_binary(join(re:split("aaabcxyzpqrrrabbxyyyypqqqAzz","a*abc?xyz+pqr{3}ab{2,}xy{4,5}pq{0,6}AB{0,}zz",[]))), 
    <<"">> = iolist_to_binary(join(re:split("aaabcxyzpqrrrabbxyyyypqqqqAzz","a*abc?xyz+pqr{3}ab{2,}xy{4,5}pq{0,6}AB{0,}zz",[trim]))), 
    <<":">> = iolist_to_binary(join(re:split("aaabcxyzpqrrrabbxyyyypqqqqAzz","a*abc?xyz+pqr{3}ab{2,}xy{4,5}pq{0,6}AB{0,}zz",[{parts,
                                                                                                                                                                                                                                                                                                  2}]))), 
    <<":">> = iolist_to_binary(join(re:split("aaabcxyzpqrrrabbxyyyypqqqqAzz","a*abc?xyz+pqr{3}ab{2,}xy{4,5}pq{0,6}AB{0,}zz",[]))), 
    <<"">> = iolist_to_binary(join(re:split("aaabcxyzpqrrrabbxyyyypqqqqqAzz","a*abc?xyz+pqr{3}ab{2,}xy{4,5}pq{0,6}AB{0,}zz",[trim]))), 
    <<":">> = iolist_to_binary(join(re:split("aaabcxyzpqrrrabbxyyyypqqqqqAzz","a*abc?xyz+pqr{3}ab{2,}xy{4,5}pq{0,6}AB{0,}zz",[{parts,
                                                                                                                                                                                                                                                                                                    2}]))), 
    <<":">> = iolist_to_binary(join(re:split("aaabcxyzpqrrrabbxyyyypqqqqqAzz","a*abc?xyz+pqr{3}ab{2,}xy{4,5}pq{0,6}AB{0,}zz",[]))), 
    <<"">> = iolist_to_binary(join(re:split("aaabcxyzpqrrrabbxyyyypqqqqqqAzz","a*abc?xyz+pqr{3}ab{2,}xy{4,5}pq{0,6}AB{0,}zz",[trim]))), 
    <<":">> = iolist_to_binary(join(re:split("aaabcxyzpqrrrabbxyyyypqqqqqqAzz","a*abc?xyz+pqr{3}ab{2,}xy{4,5}pq{0,6}AB{0,}zz",[{parts,
                                                                                                                                                                                                                                                                                                      2}]))), 
    <<":">> = iolist_to_binary(join(re:split("aaabcxyzpqrrrabbxyyyypqqqqqqAzz","a*abc?xyz+pqr{3}ab{2,}xy{4,5}pq{0,6}AB{0,}zz",[]))), 
    <<"">> = iolist_to_binary(join(re:split("aaaabcxyzpqrrrabbxyyyypqAzz","a*abc?xyz+pqr{3}ab{2,}xy{4,5}pq{0,6}AB{0,}zz",[trim]))), 
    <<":">> = iolist_to_binary(join(re:split("aaaabcxyzpqrrrabbxyyyypqAzz","a*abc?xyz+pqr{3}ab{2,}xy{4,5}pq{0,6}AB{0,}zz",[{parts,
                                                                                                                                                                                                                                                                                              2}]))), 
    <<":">> = iolist_to_binary(join(re:split("aaaabcxyzpqrrrabbxyyyypqAzz","a*abc?xyz+pqr{3}ab{2,}xy{4,5}pq{0,6}AB{0,}zz",[]))), 
    <<"">> = iolist_to_binary(join(re:split("abxyzzpqrrrabbxyyyypqAzz","a*abc?xyz+pqr{3}ab{2,}xy{4,5}pq{0,6}AB{0,}zz",[trim]))), 
    <<":">> = iolist_to_binary(join(re:split("abxyzzpqrrrabbxyyyypqAzz","a*abc?xyz+pqr{3}ab{2,}xy{4,5}pq{0,6}AB{0,}zz",[{parts,
                                                                                                                                                                                                                                                                                        2}]))), 
    <<":">> = iolist_to_binary(join(re:split("abxyzzpqrrrabbxyyyypqAzz","a*abc?xyz+pqr{3}ab{2,}xy{4,5}pq{0,6}AB{0,}zz",[]))), 
    <<"">> = iolist_to_binary(join(re:split("aabxyzzzpqrrrabbxyyyypqAzz","a*abc?xyz+pqr{3}ab{2,}xy{4,5}pq{0,6}AB{0,}zz",[trim]))), 
    <<":">> = iolist_to_binary(join(re:split("aabxyzzzpqrrrabbxyyyypqAzz","a*abc?xyz+pqr{3}ab{2,}xy{4,5}pq{0,6}AB{0,}zz",[{parts,
                                                                                                                                                                                                                                                                                            2}]))), 
    <<":">> = iolist_to_binary(join(re:split("aabxyzzzpqrrrabbxyyyypqAzz","a*abc?xyz+pqr{3}ab{2,}xy{4,5}pq{0,6}AB{0,}zz",[]))), 
    <<"">> = iolist_to_binary(join(re:split("aaabxyzzzzpqrrrabbxyyyypqAzz","a*abc?xyz+pqr{3}ab{2,}xy{4,5}pq{0,6}AB{0,}zz",[trim]))), 
    <<":">> = iolist_to_binary(join(re:split("aaabxyzzzzpqrrrabbxyyyypqAzz","a*abc?xyz+pqr{3}ab{2,}xy{4,5}pq{0,6}AB{0,}zz",[{parts,
                                                                                                                                                                                                                                                                                                2}]))), 
    <<":">> = iolist_to_binary(join(re:split("aaabxyzzzzpqrrrabbxyyyypqAzz","a*abc?xyz+pqr{3}ab{2,}xy{4,5}pq{0,6}AB{0,}zz",[]))), 
    <<"">> = iolist_to_binary(join(re:split("aaaabxyzzzzpqrrrabbxyyyypqAzz","a*abc?xyz+pqr{3}ab{2,}xy{4,5}pq{0,6}AB{0,}zz",[trim]))), 
    <<":">> = iolist_to_binary(join(re:split("aaaabxyzzzzpqrrrabbxyyyypqAzz","a*abc?xyz+pqr{3}ab{2,}xy{4,5}pq{0,6}AB{0,}zz",[{parts,
                                                                                                                                                                                                                                                                                                  2}]))), 
    <<":">> = iolist_to_binary(join(re:split("aaaabxyzzzzpqrrrabbxyyyypqAzz","a*abc?xyz+pqr{3}ab{2,}xy{4,5}pq{0,6}AB{0,}zz",[]))), 
    <<"">> = iolist_to_binary(join(re:split("abcxyzzpqrrrabbxyyyypqAzz","a*abc?xyz+pqr{3}ab{2,}xy{4,5}pq{0,6}AB{0,}zz",[trim]))), 
    <<":">> = iolist_to_binary(join(re:split("abcxyzzpqrrrabbxyyyypqAzz","a*abc?xyz+pqr{3}ab{2,}xy{4,5}pq{0,6}AB{0,}zz",[{parts,
                                                                                                                                                                                                                                                                                          2}]))), 
    <<":">> = iolist_to_binary(join(re:split("abcxyzzpqrrrabbxyyyypqAzz","a*abc?xyz+pqr{3}ab{2,}xy{4,5}pq{0,6}AB{0,}zz",[]))), 
    <<"">> = iolist_to_binary(join(re:split("aabcxyzzzpqrrrabbxyyyypqAzz","a*abc?xyz+pqr{3}ab{2,}xy{4,5}pq{0,6}AB{0,}zz",[trim]))), 
    <<":">> = iolist_to_binary(join(re:split("aabcxyzzzpqrrrabbxyyyypqAzz","a*abc?xyz+pqr{3}ab{2,}xy{4,5}pq{0,6}AB{0,}zz",[{parts,
                                                                                                                                                                                                                                                                                              2}]))), 
    <<":">> = iolist_to_binary(join(re:split("aabcxyzzzpqrrrabbxyyyypqAzz","a*abc?xyz+pqr{3}ab{2,}xy{4,5}pq{0,6}AB{0,}zz",[]))), 
    <<"">> = iolist_to_binary(join(re:split("aaabcxyzzzzpqrrrabbxyyyypqAzz","a*abc?xyz+pqr{3}ab{2,}xy{4,5}pq{0,6}AB{0,}zz",[trim]))), 
    <<":">> = iolist_to_binary(join(re:split("aaabcxyzzzzpqrrrabbxyyyypqAzz","a*abc?xyz+pqr{3}ab{2,}xy{4,5}pq{0,6}AB{0,}zz",[{parts,
                                                                                                                                                                                                                                                                                                  2}]))), 
    <<":">> = iolist_to_binary(join(re:split("aaabcxyzzzzpqrrrabbxyyyypqAzz","a*abc?xyz+pqr{3}ab{2,}xy{4,5}pq{0,6}AB{0,}zz",[]))), 
    <<"">> = iolist_to_binary(join(re:split("aaaabcxyzzzzpqrrrabbxyyyypqAzz","a*abc?xyz+pqr{3}ab{2,}xy{4,5}pq{0,6}AB{0,}zz",[trim]))), 
    <<":">> = iolist_to_binary(join(re:split("aaaabcxyzzzzpqrrrabbxyyyypqAzz","a*abc?xyz+pqr{3}ab{2,}xy{4,5}pq{0,6}AB{0,}zz",[{parts,
                                                                                                                                                                                                                                                                                                    2}]))), 
    <<":">> = iolist_to_binary(join(re:split("aaaabcxyzzzzpqrrrabbxyyyypqAzz","a*abc?xyz+pqr{3}ab{2,}xy{4,5}pq{0,6}AB{0,}zz",[]))), 
    <<"">> = iolist_to_binary(join(re:split("aaaabcxyzzzzpqrrrabbbxyyyypqAzz","a*abc?xyz+pqr{3}ab{2,}xy{4,5}pq{0,6}AB{0,}zz",[trim]))), 
    <<":">> = iolist_to_binary(join(re:split("aaaabcxyzzzzpqrrrabbbxyyyypqAzz","a*abc?xyz+pqr{3}ab{2,}xy{4,5}pq{0,6}AB{0,}zz",[{parts,
                                                                                                                                                                                                                                                                                                      2}]))), 
    <<":">> = iolist_to_binary(join(re:split("aaaabcxyzzzzpqrrrabbbxyyyypqAzz","a*abc?xyz+pqr{3}ab{2,}xy{4,5}pq{0,6}AB{0,}zz",[]))), 
    <<"">> = iolist_to_binary(join(re:split("aaaabcxyzzzzpqrrrabbbxyyyyypqAzz","a*abc?xyz+pqr{3}ab{2,}xy{4,5}pq{0,6}AB{0,}zz",[trim]))), 
    <<":">> = iolist_to_binary(join(re:split("aaaabcxyzzzzpqrrrabbbxyyyyypqAzz","a*abc?xyz+pqr{3}ab{2,}xy{4,5}pq{0,6}AB{0,}zz",[{parts,
                                                                                                                                                                                                                                                                                                        2}]))), 
    <<":">> = iolist_to_binary(join(re:split("aaaabcxyzzzzpqrrrabbbxyyyyypqAzz","a*abc?xyz+pqr{3}ab{2,}xy{4,5}pq{0,6}AB{0,}zz",[]))), 
    <<"">> = iolist_to_binary(join(re:split("aaabcxyzpqrrrabbxyyyypABzz","a*abc?xyz+pqr{3}ab{2,}xy{4,5}pq{0,6}AB{0,}zz",[trim]))), 
    <<":">> = iolist_to_binary(join(re:split("aaabcxyzpqrrrabbxyyyypABzz","a*abc?xyz+pqr{3}ab{2,}xy{4,5}pq{0,6}AB{0,}zz",[{parts,
                                                                                                                                                                                                                                                                                            2}]))), 
    <<":">> = iolist_to_binary(join(re:split("aaabcxyzpqrrrabbxyyyypABzz","a*abc?xyz+pqr{3}ab{2,}xy{4,5}pq{0,6}AB{0,}zz",[]))), 
    <<"">> = iolist_to_binary(join(re:split("aaabcxyzpqrrrabbxyyyypABBzz","a*abc?xyz+pqr{3}ab{2,}xy{4,5}pq{0,6}AB{0,}zz",[trim]))), 
    <<":">> = iolist_to_binary(join(re:split("aaabcxyzpqrrrabbxyyyypABBzz","a*abc?xyz+pqr{3}ab{2,}xy{4,5}pq{0,6}AB{0,}zz",[{parts,
                                                                                                                                                                                                                                                                                              2}]))), 
    <<":">> = iolist_to_binary(join(re:split("aaabcxyzpqrrrabbxyyyypABBzz","a*abc?xyz+pqr{3}ab{2,}xy{4,5}pq{0,6}AB{0,}zz",[]))), 
    <<">>>">> = iolist_to_binary(join(re:split(">>>aaabxyzpqrrrabbxyyyypqAzz","a*abc?xyz+pqr{3}ab{2,}xy{4,5}pq{0,6}AB{0,}zz",[trim]))), 
    <<">>>:">> = iolist_to_binary(join(re:split(">>>aaabxyzpqrrrabbxyyyypqAzz","a*abc?xyz+pqr{3}ab{2,}xy{4,5}pq{0,6}AB{0,}zz",[{parts,
                                                                                                                                                                                                                                                                                                2}]))), 
    <<">>>:">> = iolist_to_binary(join(re:split(">>>aaabxyzpqrrrabbxyyyypqAzz","a*abc?xyz+pqr{3}ab{2,}xy{4,5}pq{0,6}AB{0,}zz",[]))), 
    <<">">> = iolist_to_binary(join(re:split(">aaaabxyzpqrrrabbxyyyypqAzz","a*abc?xyz+pqr{3}ab{2,}xy{4,5}pq{0,6}AB{0,}zz",[trim]))), 
    <<">:">> = iolist_to_binary(join(re:split(">aaaabxyzpqrrrabbxyyyypqAzz","a*abc?xyz+pqr{3}ab{2,}xy{4,5}pq{0,6}AB{0,}zz",[{parts,
                                                                                                                                                                                                                                                                                              2}]))), 
    <<">:">> = iolist_to_binary(join(re:split(">aaaabxyzpqrrrabbxyyyypqAzz","a*abc?xyz+pqr{3}ab{2,}xy{4,5}pq{0,6}AB{0,}zz",[]))), 
    <<">>>>">> = iolist_to_binary(join(re:split(">>>>abcxyzpqrrrabbxyyyypqAzz","a*abc?xyz+pqr{3}ab{2,}xy{4,5}pq{0,6}AB{0,}zz",[trim]))), 
    <<">>>>:">> = iolist_to_binary(join(re:split(">>>>abcxyzpqrrrabbxyyyypqAzz","a*abc?xyz+pqr{3}ab{2,}xy{4,5}pq{0,6}AB{0,}zz",[{parts,
                                                                                                                                                                                                                                                                                                2}]))), 
    <<">>>>:">> = iolist_to_binary(join(re:split(">>>>abcxyzpqrrrabbxyyyypqAzz","a*abc?xyz+pqr{3}ab{2,}xy{4,5}pq{0,6}AB{0,}zz",[]))), 
    <<"*** Failers">> = iolist_to_binary(join(re:split("*** Failers","a*abc?xyz+pqr{3}ab{2,}xy{4,5}pq{0,6}AB{0,}zz",[trim]))), 
    <<"*** Failers">> = iolist_to_binary(join(re:split("*** Failers","a*abc?xyz+pqr{3}ab{2,}xy{4,5}pq{0,6}AB{0,}zz",[{parts,
                                                                                                                                                                                                                                                              2}]))), 
    <<"*** Failers">> = iolist_to_binary(join(re:split("*** Failers","a*abc?xyz+pqr{3}ab{2,}xy{4,5}pq{0,6}AB{0,}zz",[]))), 
    <<"abxyzpqrrabbxyyyypqAzz">> = iolist_to_binary(join(re:split("abxyzpqrrabbxyyyypqAzz","a*abc?xyz+pqr{3}ab{2,}xy{4,5}pq{0,6}AB{0,}zz",[trim]))), 
    <<"abxyzpqrrabbxyyyypqAzz">> = iolist_to_binary(join(re:split("abxyzpqrrabbxyyyypqAzz","a*abc?xyz+pqr{3}ab{2,}xy{4,5}pq{0,6}AB{0,}zz",[{parts,
                                                                                                                                                                                                                                                                                    2}]))), 
    <<"abxyzpqrrabbxyyyypqAzz">> = iolist_to_binary(join(re:split("abxyzpqrrabbxyyyypqAzz","a*abc?xyz+pqr{3}ab{2,}xy{4,5}pq{0,6}AB{0,}zz",[]))), 
    <<"abxyzpqrrrrabbxyyyypqAzz">> = iolist_to_binary(join(re:split("abxyzpqrrrrabbxyyyypqAzz","a*abc?xyz+pqr{3}ab{2,}xy{4,5}pq{0,6}AB{0,}zz",[trim]))), 
    <<"abxyzpqrrrrabbxyyyypqAzz">> = iolist_to_binary(join(re:split("abxyzpqrrrrabbxyyyypqAzz","a*abc?xyz+pqr{3}ab{2,}xy{4,5}pq{0,6}AB{0,}zz",[{parts,
                                                                                                                                                                                                                                                                                        2}]))), 
    <<"abxyzpqrrrrabbxyyyypqAzz">> = iolist_to_binary(join(re:split("abxyzpqrrrrabbxyyyypqAzz","a*abc?xyz+pqr{3}ab{2,}xy{4,5}pq{0,6}AB{0,}zz",[]))), 
    <<"abxyzpqrrrabxyyyypqAzz">> = iolist_to_binary(join(re:split("abxyzpqrrrabxyyyypqAzz","a*abc?xyz+pqr{3}ab{2,}xy{4,5}pq{0,6}AB{0,}zz",[trim]))), 
    <<"abxyzpqrrrabxyyyypqAzz">> = iolist_to_binary(join(re:split("abxyzpqrrrabxyyyypqAzz","a*abc?xyz+pqr{3}ab{2,}xy{4,5}pq{0,6}AB{0,}zz",[{parts,
                                                                                                                                                                                                                                                                                    2}]))), 
    <<"abxyzpqrrrabxyyyypqAzz">> = iolist_to_binary(join(re:split("abxyzpqrrrabxyyyypqAzz","a*abc?xyz+pqr{3}ab{2,}xy{4,5}pq{0,6}AB{0,}zz",[]))), 
    <<"aaaabcxyzzzzpqrrrabbbxyyyyyypqAzz">> = iolist_to_binary(join(re:split("aaaabcxyzzzzpqrrrabbbxyyyyyypqAzz","a*abc?xyz+pqr{3}ab{2,}xy{4,5}pq{0,6}AB{0,}zz",[trim]))), 
    <<"aaaabcxyzzzzpqrrrabbbxyyyyyypqAzz">> = iolist_to_binary(join(re:split("aaaabcxyzzzzpqrrrabbbxyyyyyypqAzz","a*abc?xyz+pqr{3}ab{2,}xy{4,5}pq{0,6}AB{0,}zz",[{parts,
                                                                                                                                                                                                                                                                                                          2}]))), 
    <<"aaaabcxyzzzzpqrrrabbbxyyyyyypqAzz">> = iolist_to_binary(join(re:split("aaaabcxyzzzzpqrrrabbbxyyyyyypqAzz","a*abc?xyz+pqr{3}ab{2,}xy{4,5}pq{0,6}AB{0,}zz",[]))), 
    <<"aaaabcxyzzzzpqrrrabbbxyyypqAzz">> = iolist_to_binary(join(re:split("aaaabcxyzzzzpqrrrabbbxyyypqAzz","a*abc?xyz+pqr{3}ab{2,}xy{4,5}pq{0,6}AB{0,}zz",[trim]))), 
    <<"aaaabcxyzzzzpqrrrabbbxyyypqAzz">> = iolist_to_binary(join(re:split("aaaabcxyzzzzpqrrrabbbxyyypqAzz","a*abc?xyz+pqr{3}ab{2,}xy{4,5}pq{0,6}AB{0,}zz",[{parts,
                                                                                                                                                                                                                                                                                                    2}]))), 
    <<"aaaabcxyzzzzpqrrrabbbxyyypqAzz">> = iolist_to_binary(join(re:split("aaaabcxyzzzzpqrrrabbbxyyypqAzz","a*abc?xyz+pqr{3}ab{2,}xy{4,5}pq{0,6}AB{0,}zz",[]))), 
    <<"aaabcxyzpqrrrabbxyyyypqqqqqqqAzz">> = iolist_to_binary(join(re:split("aaabcxyzpqrrrabbxyyyypqqqqqqqAzz","a*abc?xyz+pqr{3}ab{2,}xy{4,5}pq{0,6}AB{0,}zz",[trim]))), 
    <<"aaabcxyzpqrrrabbxyyyypqqqqqqqAzz">> = iolist_to_binary(join(re:split("aaabcxyzpqrrrabbxyyyypqqqqqqqAzz","a*abc?xyz+pqr{3}ab{2,}xy{4,5}pq{0,6}AB{0,}zz",[{parts,
                                                                                                                                                                                                                                                                                                        2}]))), 
    <<"aaabcxyzpqrrrabbxyyyypqqqqqqqAzz">> = iolist_to_binary(join(re:split("aaabcxyzpqrrrabbxyyyypqqqqqqqAzz","a*abc?xyz+pqr{3}ab{2,}xy{4,5}pq{0,6}AB{0,}zz",[]))), 
    <<":abc">> = iolist_to_binary(join(re:split("abczz","^(abc){1,2}zz",[trim]))), 
    <<":abc:">> = iolist_to_binary(join(re:split("abczz","^(abc){1,2}zz",[{parts,
                                                                                                                                                                                    2}]))), 
    <<":abc:">> = iolist_to_binary(join(re:split("abczz","^(abc){1,2}zz",[]))), 
    <<":abc">> = iolist_to_binary(join(re:split("abcabczz","^(abc){1,2}zz",[trim]))), 
    <<":abc:">> = iolist_to_binary(join(re:split("abcabczz","^(abc){1,2}zz",[{parts,
                                                                                                                                                                                          2}]))), 
    <<":abc:">> = iolist_to_binary(join(re:split("abcabczz","^(abc){1,2}zz",[]))), 
    <<"*** Failers">> = iolist_to_binary(join(re:split("*** Failers","^(abc){1,2}zz",[trim]))), 
    <<"*** Failers">> = iolist_to_binary(join(re:split("*** Failers","^(abc){1,2}zz",[{parts,
                                                                                                                                                                                                2}]))), 
    <<"*** Failers">> = iolist_to_binary(join(re:split("*** Failers","^(abc){1,2}zz",[]))), 
    <<"zz">> = iolist_to_binary(join(re:split("zz","^(abc){1,2}zz",[trim]))), 
    <<"zz">> = iolist_to_binary(join(re:split("zz","^(abc){1,2}zz",[{parts,
                                                                                                                                                                              2}]))), 
    <<"zz">> = iolist_to_binary(join(re:split("zz","^(abc){1,2}zz",[]))), 
    <<"abcabcabczz">> = iolist_to_binary(join(re:split("abcabcabczz","^(abc){1,2}zz",[trim]))), 
    <<"abcabcabczz">> = iolist_to_binary(join(re:split("abcabcabczz","^(abc){1,2}zz",[{parts,
                                                                                                                                                                                                2}]))), 
    <<"abcabcabczz">> = iolist_to_binary(join(re:split("abcabcabczz","^(abc){1,2}zz",[]))), 
    <<">>abczz">> = iolist_to_binary(join(re:split(">>abczz","^(abc){1,2}zz",[trim]))), 
    <<">>abczz">> = iolist_to_binary(join(re:split(">>abczz","^(abc){1,2}zz",[{parts,
                                                                                                                                                                                        2}]))), 
    <<">>abczz">> = iolist_to_binary(join(re:split(">>abczz","^(abc){1,2}zz",[]))), 
    <<":b">> = iolist_to_binary(join(re:split("bc","^(b+?|a){1,2}?c",[trim]))), 
    <<":b:">> = iolist_to_binary(join(re:split("bc","^(b+?|a){1,2}?c",[{parts,
                                                                                                                                                                                  2}]))), 
    <<":b:">> = iolist_to_binary(join(re:split("bc","^(b+?|a){1,2}?c",[]))), 
    <<":b">> = iolist_to_binary(join(re:split("bbc","^(b+?|a){1,2}?c",[trim]))), 
    <<":b:">> = iolist_to_binary(join(re:split("bbc","^(b+?|a){1,2}?c",[{parts,
                                                                                                                                                                                    2}]))), 
    <<":b:">> = iolist_to_binary(join(re:split("bbc","^(b+?|a){1,2}?c",[]))), 
    <<":bb">> = iolist_to_binary(join(re:split("bbbc","^(b+?|a){1,2}?c",[trim]))), 
    <<":bb:">> = iolist_to_binary(join(re:split("bbbc","^(b+?|a){1,2}?c",[{parts,
                                                                                                                                                                                      2}]))), 
    <<":bb:">> = iolist_to_binary(join(re:split("bbbc","^(b+?|a){1,2}?c",[]))), 
    <<":a">> = iolist_to_binary(join(re:split("bac","^(b+?|a){1,2}?c",[trim]))), 
    <<":a:">> = iolist_to_binary(join(re:split("bac","^(b+?|a){1,2}?c",[{parts,
                                                                                                                                                                                    2}]))), 
    <<":a:">> = iolist_to_binary(join(re:split("bac","^(b+?|a){1,2}?c",[]))), 
    <<":a">> = iolist_to_binary(join(re:split("bbac","^(b+?|a){1,2}?c",[trim]))), 
    <<":a:">> = iolist_to_binary(join(re:split("bbac","^(b+?|a){1,2}?c",[{parts,
                                                                                                                                                                                      2}]))), 
    <<":a:">> = iolist_to_binary(join(re:split("bbac","^(b+?|a){1,2}?c",[]))), 
    <<":a">> = iolist_to_binary(join(re:split("aac","^(b+?|a){1,2}?c",[trim]))), 
    <<":a:">> = iolist_to_binary(join(re:split("aac","^(b+?|a){1,2}?c",[{parts,
                                                                                                                                                                                    2}]))), 
    <<":a:">> = iolist_to_binary(join(re:split("aac","^(b+?|a){1,2}?c",[]))), 
    <<":bbbbbbbbbbb">> = iolist_to_binary(join(re:split("abbbbbbbbbbbc","^(b+?|a){1,2}?c",[trim]))), 
    <<":bbbbbbbbbbb:">> = iolist_to_binary(join(re:split("abbbbbbbbbbbc","^(b+?|a){1,2}?c",[{parts,
                                                                                                                                                                                                        2}]))), 
    <<":bbbbbbbbbbb:">> = iolist_to_binary(join(re:split("abbbbbbbbbbbc","^(b+?|a){1,2}?c",[]))), 
    <<":a">> = iolist_to_binary(join(re:split("bbbbbbbbbbbac","^(b+?|a){1,2}?c",[trim]))), 
    <<":a:">> = iolist_to_binary(join(re:split("bbbbbbbbbbbac","^(b+?|a){1,2}?c",[{parts,
                                                                                                                                                                                                        2}]))), 
    <<":a:">> = iolist_to_binary(join(re:split("bbbbbbbbbbbac","^(b+?|a){1,2}?c",[]))), 
    <<"*** Failers">> = iolist_to_binary(join(re:split("*** Failers","^(b+?|a){1,2}?c",[trim]))), 
    <<"*** Failers">> = iolist_to_binary(join(re:split("*** Failers","^(b+?|a){1,2}?c",[{parts,
                                                                                                                                                                                                    2}]))), 
    <<"*** Failers">> = iolist_to_binary(join(re:split("*** Failers","^(b+?|a){1,2}?c",[]))), 
    <<"aaac">> = iolist_to_binary(join(re:split("aaac","^(b+?|a){1,2}?c",[trim]))), 
    <<"aaac">> = iolist_to_binary(join(re:split("aaac","^(b+?|a){1,2}?c",[{parts,
                                                                                                                                                                                      2}]))), 
    <<"aaac">> = iolist_to_binary(join(re:split("aaac","^(b+?|a){1,2}?c",[]))), 
    <<"abbbbbbbbbbbac">> = iolist_to_binary(join(re:split("abbbbbbbbbbbac","^(b+?|a){1,2}?c",[trim]))), 
    <<"abbbbbbbbbbbac">> = iolist_to_binary(join(re:split("abbbbbbbbbbbac","^(b+?|a){1,2}?c",[{parts,
                                                                                                                                                                                                          2}]))), 
    <<"abbbbbbbbbbbac">> = iolist_to_binary(join(re:split("abbbbbbbbbbbac","^(b+?|a){1,2}?c",[]))), 
    <<":b">> = iolist_to_binary(join(re:split("bc","^(b+|a){1,2}c",[trim]))), 
    <<":b:">> = iolist_to_binary(join(re:split("bc","^(b+|a){1,2}c",[{parts,
                                                                                                                                                                              2}]))), 
    <<":b:">> = iolist_to_binary(join(re:split("bc","^(b+|a){1,2}c",[]))), 
    <<":bb">> = iolist_to_binary(join(re:split("bbc","^(b+|a){1,2}c",[trim]))), 
    <<":bb:">> = iolist_to_binary(join(re:split("bbc","^(b+|a){1,2}c",[{parts,
                                                                                                                                                                                2}]))), 
    <<":bb:">> = iolist_to_binary(join(re:split("bbc","^(b+|a){1,2}c",[]))), 
    <<":bbb">> = iolist_to_binary(join(re:split("bbbc","^(b+|a){1,2}c",[trim]))), 
    <<":bbb:">> = iolist_to_binary(join(re:split("bbbc","^(b+|a){1,2}c",[{parts,
                                                                                                                                                                                  2}]))), 
    <<":bbb:">> = iolist_to_binary(join(re:split("bbbc","^(b+|a){1,2}c",[]))), 
    <<":a">> = iolist_to_binary(join(re:split("bac","^(b+|a){1,2}c",[trim]))), 
    <<":a:">> = iolist_to_binary(join(re:split("bac","^(b+|a){1,2}c",[{parts,
                                                                                                                                                                                2}]))), 
    <<":a:">> = iolist_to_binary(join(re:split("bac","^(b+|a){1,2}c",[]))), 
    <<":a">> = iolist_to_binary(join(re:split("bbac","^(b+|a){1,2}c",[trim]))), 
    <<":a:">> = iolist_to_binary(join(re:split("bbac","^(b+|a){1,2}c",[{parts,
                                                                                                                                                                                  2}]))), 
    <<":a:">> = iolist_to_binary(join(re:split("bbac","^(b+|a){1,2}c",[]))), 
    <<":a">> = iolist_to_binary(join(re:split("aac","^(b+|a){1,2}c",[trim]))), 
    <<":a:">> = iolist_to_binary(join(re:split("aac","^(b+|a){1,2}c",[{parts,
                                                                                                                                                                                2}]))), 
    <<":a:">> = iolist_to_binary(join(re:split("aac","^(b+|a){1,2}c",[]))), 
    <<":bbbbbbbbbbb">> = iolist_to_binary(join(re:split("abbbbbbbbbbbc","^(b+|a){1,2}c",[trim]))), 
    <<":bbbbbbbbbbb:">> = iolist_to_binary(join(re:split("abbbbbbbbbbbc","^(b+|a){1,2}c",[{parts,
                                                                                                                                                                                                    2}]))), 
    <<":bbbbbbbbbbb:">> = iolist_to_binary(join(re:split("abbbbbbbbbbbc","^(b+|a){1,2}c",[]))), 
    <<":a">> = iolist_to_binary(join(re:split("bbbbbbbbbbbac","^(b+|a){1,2}c",[trim]))), 
    <<":a:">> = iolist_to_binary(join(re:split("bbbbbbbbbbbac","^(b+|a){1,2}c",[{parts,
                                                                                                                                                                                                    2}]))), 
    <<":a:">> = iolist_to_binary(join(re:split("bbbbbbbbbbbac","^(b+|a){1,2}c",[]))), 
    <<"*** Failers">> = iolist_to_binary(join(re:split("*** Failers","^(b+|a){1,2}c",[trim]))), 
    <<"*** Failers">> = iolist_to_binary(join(re:split("*** Failers","^(b+|a){1,2}c",[{parts,
                                                                                                                                                                                                2}]))), 
    <<"*** Failers">> = iolist_to_binary(join(re:split("*** Failers","^(b+|a){1,2}c",[]))), 
    <<"aaac">> = iolist_to_binary(join(re:split("aaac","^(b+|a){1,2}c",[trim]))), 
    <<"aaac">> = iolist_to_binary(join(re:split("aaac","^(b+|a){1,2}c",[{parts,
                                                                                                                                                                                  2}]))), 
    <<"aaac">> = iolist_to_binary(join(re:split("aaac","^(b+|a){1,2}c",[]))), 
    <<"abbbbbbbbbbbac">> = iolist_to_binary(join(re:split("abbbbbbbbbbbac","^(b+|a){1,2}c",[trim]))), 
    <<"abbbbbbbbbbbac">> = iolist_to_binary(join(re:split("abbbbbbbbbbbac","^(b+|a){1,2}c",[{parts,
                                                                                                                                                                                                      2}]))), 
    <<"abbbbbbbbbbbac">> = iolist_to_binary(join(re:split("abbbbbbbbbbbac","^(b+|a){1,2}c",[]))), 
    <<":b">> = iolist_to_binary(join(re:split("bbc","^(b+|a){1,2}?bc",[trim]))), 
    <<":b:">> = iolist_to_binary(join(re:split("bbc","^(b+|a){1,2}?bc",[{parts,
                                                                                                                                                                                    2}]))), 
    <<":b:">> = iolist_to_binary(join(re:split("bbc","^(b+|a){1,2}?bc",[]))), 
    <<":ba">> = iolist_to_binary(join(re:split("babc","^(b*|ba){1,2}?bc",[trim]))), 
    <<":ba:">> = iolist_to_binary(join(re:split("babc","^(b*|ba){1,2}?bc",[{parts,
                                                                                                                                                                                        2}]))), 
    <<":ba:">> = iolist_to_binary(join(re:split("babc","^(b*|ba){1,2}?bc",[]))), 
    <<":ba">> = iolist_to_binary(join(re:split("bbabc","^(b*|ba){1,2}?bc",[trim]))), 
    <<":ba:">> = iolist_to_binary(join(re:split("bbabc","^(b*|ba){1,2}?bc",[{parts,
                                                                                                                                                                                          2}]))), 
    <<":ba:">> = iolist_to_binary(join(re:split("bbabc","^(b*|ba){1,2}?bc",[]))), 
    <<":ba">> = iolist_to_binary(join(re:split("bababc","^(b*|ba){1,2}?bc",[trim]))), 
    <<":ba:">> = iolist_to_binary(join(re:split("bababc","^(b*|ba){1,2}?bc",[{parts,
                                                                                                                                                                                            2}]))), 
    <<":ba:">> = iolist_to_binary(join(re:split("bababc","^(b*|ba){1,2}?bc",[]))), 
    <<"*** Failers">> = iolist_to_binary(join(re:split("*** Failers","^(b*|ba){1,2}?bc",[trim]))), 
    <<"*** Failers">> = iolist_to_binary(join(re:split("*** Failers","^(b*|ba){1,2}?bc",[{parts,
                                                                                                                                                                                                      2}]))), 
    <<"*** Failers">> = iolist_to_binary(join(re:split("*** Failers","^(b*|ba){1,2}?bc",[]))), 
    <<"bababbc">> = iolist_to_binary(join(re:split("bababbc","^(b*|ba){1,2}?bc",[trim]))), 
    <<"bababbc">> = iolist_to_binary(join(re:split("bababbc","^(b*|ba){1,2}?bc",[{parts,
                                                                                                                                                                                              2}]))), 
    <<"bababbc">> = iolist_to_binary(join(re:split("bababbc","^(b*|ba){1,2}?bc",[]))), 
    <<"babababc">> = iolist_to_binary(join(re:split("babababc","^(b*|ba){1,2}?bc",[trim]))), 
    <<"babababc">> = iolist_to_binary(join(re:split("babababc","^(b*|ba){1,2}?bc",[{parts,
                                                                                                                                                                                                2}]))), 
    <<"babababc">> = iolist_to_binary(join(re:split("babababc","^(b*|ba){1,2}?bc",[]))), 
    <<":ba">> = iolist_to_binary(join(re:split("babc","^(ba|b*){1,2}?bc",[trim]))), 
    <<":ba:">> = iolist_to_binary(join(re:split("babc","^(ba|b*){1,2}?bc",[{parts,
                                                                                                                                                                                        2}]))), 
    <<":ba:">> = iolist_to_binary(join(re:split("babc","^(ba|b*){1,2}?bc",[]))), 
    <<":ba">> = iolist_to_binary(join(re:split("bbabc","^(ba|b*){1,2}?bc",[trim]))), 
    <<":ba:">> = iolist_to_binary(join(re:split("bbabc","^(ba|b*){1,2}?bc",[{parts,
                                                                                                                                                                                          2}]))), 
    <<":ba:">> = iolist_to_binary(join(re:split("bbabc","^(ba|b*){1,2}?bc",[]))), 
    <<":ba">> = iolist_to_binary(join(re:split("bababc","^(ba|b*){1,2}?bc",[trim]))), 
    <<":ba:">> = iolist_to_binary(join(re:split("bababc","^(ba|b*){1,2}?bc",[{parts,
                                                                                                                                                                                            2}]))), 
    <<":ba:">> = iolist_to_binary(join(re:split("bababc","^(ba|b*){1,2}?bc",[]))), 
    <<"*** Failers">> = iolist_to_binary(join(re:split("*** Failers","^(ba|b*){1,2}?bc",[trim]))), 
    <<"*** Failers">> = iolist_to_binary(join(re:split("*** Failers","^(ba|b*){1,2}?bc",[{parts,
                                                                                                                                                                                                      2}]))), 
    <<"*** Failers">> = iolist_to_binary(join(re:split("*** Failers","^(ba|b*){1,2}?bc",[]))), 
    <<"bababbc">> = iolist_to_binary(join(re:split("bababbc","^(ba|b*){1,2}?bc",[trim]))), 
    <<"bababbc">> = iolist_to_binary(join(re:split("bababbc","^(ba|b*){1,2}?bc",[{parts,
                                                                                                                                                                                              2}]))), 
    <<"bababbc">> = iolist_to_binary(join(re:split("bababbc","^(ba|b*){1,2}?bc",[]))), 
    <<"babababc">> = iolist_to_binary(join(re:split("babababc","^(ba|b*){1,2}?bc",[trim]))), 
    <<"babababc">> = iolist_to_binary(join(re:split("babababc","^(ba|b*){1,2}?bc",[{parts,
                                                                                                                                                                                                2}]))), 
    <<"babababc">> = iolist_to_binary(join(re:split("babababc","^(ba|b*){1,2}?bc",[]))), 
    <<"">> = iolist_to_binary(join(re:split(";z","^\\ca\\cA\\c[\\c{\\c:",[trim]))), 
    <<":">> = iolist_to_binary(join(re:split(";z","^\\ca\\cA\\c[\\c{\\c:",[{parts,
                                                                                                                                                                                                         2}]))), 
    <<":">> = iolist_to_binary(join(re:split(";z","^\\ca\\cA\\c[\\c{\\c:",[]))), 
    <<":thing">> = iolist_to_binary(join(re:split("athing","^[ab\\]cde]",[trim]))), 
    <<":thing">> = iolist_to_binary(join(re:split("athing","^[ab\\]cde]",[{parts,
                                                                                                                                                                                   2}]))), 
    <<":thing">> = iolist_to_binary(join(re:split("athing","^[ab\\]cde]",[]))), 
    <<":thing">> = iolist_to_binary(join(re:split("bthing","^[ab\\]cde]",[trim]))), 
    <<":thing">> = iolist_to_binary(join(re:split("bthing","^[ab\\]cde]",[{parts,
                                                                                                                                                                                   2}]))), 
    <<":thing">> = iolist_to_binary(join(re:split("bthing","^[ab\\]cde]",[]))), 
    <<":thing">> = iolist_to_binary(join(re:split("]thing","^[ab\\]cde]",[trim]))), 
    <<":thing">> = iolist_to_binary(join(re:split("]thing","^[ab\\]cde]",[{parts,
                                                                                                                                                                                   2}]))), 
    <<":thing">> = iolist_to_binary(join(re:split("]thing","^[ab\\]cde]",[]))), 
    <<":thing">> = iolist_to_binary(join(re:split("cthing","^[ab\\]cde]",[trim]))), 
    <<":thing">> = iolist_to_binary(join(re:split("cthing","^[ab\\]cde]",[{parts,
                                                                                                                                                                                   2}]))), 
    <<":thing">> = iolist_to_binary(join(re:split("cthing","^[ab\\]cde]",[]))), 
    <<":thing">> = iolist_to_binary(join(re:split("dthing","^[ab\\]cde]",[trim]))), 
    <<":thing">> = iolist_to_binary(join(re:split("dthing","^[ab\\]cde]",[{parts,
                                                                                                                                                                                   2}]))), 
    <<":thing">> = iolist_to_binary(join(re:split("dthing","^[ab\\]cde]",[]))), 
    <<":thing">> = iolist_to_binary(join(re:split("ething","^[ab\\]cde]",[trim]))), 
    <<":thing">> = iolist_to_binary(join(re:split("ething","^[ab\\]cde]",[{parts,
                                                                                                                                                                                   2}]))), 
    <<":thing">> = iolist_to_binary(join(re:split("ething","^[ab\\]cde]",[]))), 
    <<"*** Failers">> = iolist_to_binary(join(re:split("*** Failers","^[ab\\]cde]",[trim]))), 
    <<"*** Failers">> = iolist_to_binary(join(re:split("*** Failers","^[ab\\]cde]",[{parts,
                                                                                                                                                                                             2}]))), 
    <<"*** Failers">> = iolist_to_binary(join(re:split("*** Failers","^[ab\\]cde]",[]))), 
    <<"fthing">> = iolist_to_binary(join(re:split("fthing","^[ab\\]cde]",[trim]))), 
    <<"fthing">> = iolist_to_binary(join(re:split("fthing","^[ab\\]cde]",[{parts,
                                                                                                                                                                                   2}]))), 
    <<"fthing">> = iolist_to_binary(join(re:split("fthing","^[ab\\]cde]",[]))), 
    <<"[thing">> = iolist_to_binary(join(re:split("[thing","^[ab\\]cde]",[trim]))), 
    <<"[thing">> = iolist_to_binary(join(re:split("[thing","^[ab\\]cde]",[{parts,
                                                                                                                                                                                   2}]))), 
    <<"[thing">> = iolist_to_binary(join(re:split("[thing","^[ab\\]cde]",[]))), 
    <<"\\thing">> = iolist_to_binary(join(re:split("\\thing","^[ab\\]cde]",[trim]))), 
    <<"\\thing">> = iolist_to_binary(join(re:split("\\thing","^[ab\\]cde]",[{parts,
                                                                                                                                                                                       2}]))), 
    <<"\\thing">> = iolist_to_binary(join(re:split("\\thing","^[ab\\]cde]",[]))), 
    <<":thing">> = iolist_to_binary(join(re:split("]thing","^[]cde]",[trim]))), 
    <<":thing">> = iolist_to_binary(join(re:split("]thing","^[]cde]",[{parts,
                                                                                                                                                                          2}]))), 
    <<":thing">> = iolist_to_binary(join(re:split("]thing","^[]cde]",[]))), 
    <<":thing">> = iolist_to_binary(join(re:split("cthing","^[]cde]",[trim]))), 
    <<":thing">> = iolist_to_binary(join(re:split("cthing","^[]cde]",[{parts,
                                                                                                                                                                          2}]))), 
    <<":thing">> = iolist_to_binary(join(re:split("cthing","^[]cde]",[]))), 
    <<":thing">> = iolist_to_binary(join(re:split("dthing","^[]cde]",[trim]))), 
    <<":thing">> = iolist_to_binary(join(re:split("dthing","^[]cde]",[{parts,
                                                                                                                                                                          2}]))), 
    <<":thing">> = iolist_to_binary(join(re:split("dthing","^[]cde]",[]))), 
    <<":thing">> = iolist_to_binary(join(re:split("ething","^[]cde]",[trim]))), 
    <<":thing">> = iolist_to_binary(join(re:split("ething","^[]cde]",[{parts,
                                                                                                                                                                          2}]))), 
    <<":thing">> = iolist_to_binary(join(re:split("ething","^[]cde]",[]))), 
    <<"*** Failers">> = iolist_to_binary(join(re:split("*** Failers","^[]cde]",[trim]))), 
    <<"*** Failers">> = iolist_to_binary(join(re:split("*** Failers","^[]cde]",[{parts,
                                                                                                                                                                                    2}]))), 
    <<"*** Failers">> = iolist_to_binary(join(re:split("*** Failers","^[]cde]",[]))), 
    <<"athing">> = iolist_to_binary(join(re:split("athing","^[]cde]",[trim]))), 
    <<"athing">> = iolist_to_binary(join(re:split("athing","^[]cde]",[{parts,
                                                                                                                                                                          2}]))), 
    <<"athing">> = iolist_to_binary(join(re:split("athing","^[]cde]",[]))), 
    <<"fthing">> = iolist_to_binary(join(re:split("fthing","^[]cde]",[trim]))), 
    <<"fthing">> = iolist_to_binary(join(re:split("fthing","^[]cde]",[{parts,
                                                                                                                                                                          2}]))), 
    <<"fthing">> = iolist_to_binary(join(re:split("fthing","^[]cde]",[]))), 
    <<":thing">> = iolist_to_binary(join(re:split("fthing","^[^ab\\]cde]",[trim]))), 
    <<":thing">> = iolist_to_binary(join(re:split("fthing","^[^ab\\]cde]",[{parts,
                                                                                                                                                                                     2}]))), 
    <<":thing">> = iolist_to_binary(join(re:split("fthing","^[^ab\\]cde]",[]))), 
    <<":thing">> = iolist_to_binary(join(re:split("[thing","^[^ab\\]cde]",[trim]))), 
    <<":thing">> = iolist_to_binary(join(re:split("[thing","^[^ab\\]cde]",[{parts,
                                                                                                                                                                                     2}]))), 
    <<":thing">> = iolist_to_binary(join(re:split("[thing","^[^ab\\]cde]",[]))), 
    <<":thing">> = iolist_to_binary(join(re:split("\\thing","^[^ab\\]cde]",[trim]))), 
    <<":thing">> = iolist_to_binary(join(re:split("\\thing","^[^ab\\]cde]",[{parts,
                                                                                                                                                                                         2}]))), 
    <<":thing">> = iolist_to_binary(join(re:split("\\thing","^[^ab\\]cde]",[]))), 
    <<":** Failers">> = iolist_to_binary(join(re:split("*** Failers","^[^ab\\]cde]",[trim]))), 
    <<":** Failers">> = iolist_to_binary(join(re:split("*** Failers","^[^ab\\]cde]",[{parts,
                                                                                                                                                                                               2}]))), 
    <<":** Failers">> = iolist_to_binary(join(re:split("*** Failers","^[^ab\\]cde]",[]))), 
    <<"athing">> = iolist_to_binary(join(re:split("athing","^[^ab\\]cde]",[trim]))), 
    <<"athing">> = iolist_to_binary(join(re:split("athing","^[^ab\\]cde]",[{parts,
                                                                                                                                                                                     2}]))), 
    <<"athing">> = iolist_to_binary(join(re:split("athing","^[^ab\\]cde]",[]))), 
    <<"bthing">> = iolist_to_binary(join(re:split("bthing","^[^ab\\]cde]",[trim]))), 
    <<"bthing">> = iolist_to_binary(join(re:split("bthing","^[^ab\\]cde]",[{parts,
                                                                                                                                                                                     2}]))), 
    <<"bthing">> = iolist_to_binary(join(re:split("bthing","^[^ab\\]cde]",[]))), 
    <<"]thing">> = iolist_to_binary(join(re:split("]thing","^[^ab\\]cde]",[trim]))), 
    <<"]thing">> = iolist_to_binary(join(re:split("]thing","^[^ab\\]cde]",[{parts,
                                                                                                                                                                                     2}]))), 
    <<"]thing">> = iolist_to_binary(join(re:split("]thing","^[^ab\\]cde]",[]))), 
    <<"cthing">> = iolist_to_binary(join(re:split("cthing","^[^ab\\]cde]",[trim]))), 
    <<"cthing">> = iolist_to_binary(join(re:split("cthing","^[^ab\\]cde]",[{parts,
                                                                                                                                                                                     2}]))), 
    <<"cthing">> = iolist_to_binary(join(re:split("cthing","^[^ab\\]cde]",[]))), 
    <<"dthing">> = iolist_to_binary(join(re:split("dthing","^[^ab\\]cde]",[trim]))), 
    <<"dthing">> = iolist_to_binary(join(re:split("dthing","^[^ab\\]cde]",[{parts,
                                                                                                                                                                                     2}]))), 
    <<"dthing">> = iolist_to_binary(join(re:split("dthing","^[^ab\\]cde]",[]))), 
    <<"ething">> = iolist_to_binary(join(re:split("ething","^[^ab\\]cde]",[trim]))), 
    <<"ething">> = iolist_to_binary(join(re:split("ething","^[^ab\\]cde]",[{parts,
                                                                                                                                                                                     2}]))), 
    <<"ething">> = iolist_to_binary(join(re:split("ething","^[^ab\\]cde]",[]))), 
    <<":thing">> = iolist_to_binary(join(re:split("athing","^[^]cde]",[trim]))), 
    <<":thing">> = iolist_to_binary(join(re:split("athing","^[^]cde]",[{parts,
                                                                                                                                                                            2}]))), 
    <<":thing">> = iolist_to_binary(join(re:split("athing","^[^]cde]",[]))), 
    <<":thing">> = iolist_to_binary(join(re:split("fthing","^[^]cde]",[trim]))), 
    <<":thing">> = iolist_to_binary(join(re:split("fthing","^[^]cde]",[{parts,
                                                                                                                                                                            2}]))), 
    <<":thing">> = iolist_to_binary(join(re:split("fthing","^[^]cde]",[]))), 
    <<":** Failers">> = iolist_to_binary(join(re:split("*** Failers","^[^]cde]",[trim]))), 
    <<":** Failers">> = iolist_to_binary(join(re:split("*** Failers","^[^]cde]",[{parts,
                                                                                                                                                                                      2}]))), 
    <<":** Failers">> = iolist_to_binary(join(re:split("*** Failers","^[^]cde]",[]))), 
    <<"]thing">> = iolist_to_binary(join(re:split("]thing","^[^]cde]",[trim]))), 
    <<"]thing">> = iolist_to_binary(join(re:split("]thing","^[^]cde]",[{parts,
                                                                                                                                                                            2}]))), 
    <<"]thing">> = iolist_to_binary(join(re:split("]thing","^[^]cde]",[]))), 
    <<"cthing">> = iolist_to_binary(join(re:split("cthing","^[^]cde]",[trim]))), 
    <<"cthing">> = iolist_to_binary(join(re:split("cthing","^[^]cde]",[{parts,
                                                                                                                                                                            2}]))), 
    <<"cthing">> = iolist_to_binary(join(re:split("cthing","^[^]cde]",[]))), 
    <<"dthing">> = iolist_to_binary(join(re:split("dthing","^[^]cde]",[trim]))), 
    <<"dthing">> = iolist_to_binary(join(re:split("dthing","^[^]cde]",[{parts,
                                                                                                                                                                            2}]))), 
    <<"dthing">> = iolist_to_binary(join(re:split("dthing","^[^]cde]",[]))), 
    <<"ething">> = iolist_to_binary(join(re:split("ething","^[^]cde]",[trim]))), 
    <<"ething">> = iolist_to_binary(join(re:split("ething","^[^]cde]",[{parts,
                                                                                                                                                                            2}]))), 
    <<"ething">> = iolist_to_binary(join(re:split("ething","^[^]cde]",[]))), 
    <<"">> = iolist_to_binary(join(re:split("0","^[0-9]+$",[trim]))), 
    <<":">> = iolist_to_binary(join(re:split("0","^[0-9]+$",[{parts,
                                                                                                                                                                   2}]))), 
    <<":">> = iolist_to_binary(join(re:split("0","^[0-9]+$",[]))), 
    <<"">> = iolist_to_binary(join(re:split("1","^[0-9]+$",[trim]))), 
    <<":">> = iolist_to_binary(join(re:split("1","^[0-9]+$",[{parts,
                                                                                                                                                                   2}]))), 
    <<":">> = iolist_to_binary(join(re:split("1","^[0-9]+$",[]))), 
    <<"">> = iolist_to_binary(join(re:split("2","^[0-9]+$",[trim]))), 
    <<":">> = iolist_to_binary(join(re:split("2","^[0-9]+$",[{parts,
                                                                                                                                                                   2}]))), 
    <<":">> = iolist_to_binary(join(re:split("2","^[0-9]+$",[]))), 
    <<"">> = iolist_to_binary(join(re:split("3","^[0-9]+$",[trim]))), 
    <<":">> = iolist_to_binary(join(re:split("3","^[0-9]+$",[{parts,
                                                                                                                                                                   2}]))), 
    <<":">> = iolist_to_binary(join(re:split("3","^[0-9]+$",[]))), 
    <<"">> = iolist_to_binary(join(re:split("4","^[0-9]+$",[trim]))), 
    <<":">> = iolist_to_binary(join(re:split("4","^[0-9]+$",[{parts,
                                                                                                                                                                   2}]))), 
    <<":">> = iolist_to_binary(join(re:split("4","^[0-9]+$",[]))), 
    <<"">> = iolist_to_binary(join(re:split("5","^[0-9]+$",[trim]))), 
    <<":">> = iolist_to_binary(join(re:split("5","^[0-9]+$",[{parts,
                                                                                                                                                                   2}]))), 
    <<":">> = iolist_to_binary(join(re:split("5","^[0-9]+$",[]))), 
    <<"">> = iolist_to_binary(join(re:split("6","^[0-9]+$",[trim]))), 
    <<":">> = iolist_to_binary(join(re:split("6","^[0-9]+$",[{parts,
                                                                                                                                                                   2}]))), 
    <<":">> = iolist_to_binary(join(re:split("6","^[0-9]+$",[]))), 
    <<"">> = iolist_to_binary(join(re:split("7","^[0-9]+$",[trim]))), 
    <<":">> = iolist_to_binary(join(re:split("7","^[0-9]+$",[{parts,
                                                                                                                                                                   2}]))), 
    <<":">> = iolist_to_binary(join(re:split("7","^[0-9]+$",[]))), 
    <<"">> = iolist_to_binary(join(re:split("8","^[0-9]+$",[trim]))), 
    <<":">> = iolist_to_binary(join(re:split("8","^[0-9]+$",[{parts,
                                                                                                                                                                   2}]))), 
    <<":">> = iolist_to_binary(join(re:split("8","^[0-9]+$",[]))), 
    <<"">> = iolist_to_binary(join(re:split("9","^[0-9]+$",[trim]))), 
    <<":">> = iolist_to_binary(join(re:split("9","^[0-9]+$",[{parts,
                                                                                                                                                                   2}]))), 
    <<":">> = iolist_to_binary(join(re:split("9","^[0-9]+$",[]))), 
    <<"">> = iolist_to_binary(join(re:split("10","^[0-9]+$",[trim]))), 
    <<":">> = iolist_to_binary(join(re:split("10","^[0-9]+$",[{parts,
                                                                                                                                                                     2}]))), 
    <<":">> = iolist_to_binary(join(re:split("10","^[0-9]+$",[]))), 
    <<"">> = iolist_to_binary(join(re:split("100","^[0-9]+$",[trim]))), 
    <<":">> = iolist_to_binary(join(re:split("100","^[0-9]+$",[{parts,
                                                                                                                                                                       2}]))), 
    <<":">> = iolist_to_binary(join(re:split("100","^[0-9]+$",[]))), 
    <<"*** Failers">> = iolist_to_binary(join(re:split("*** Failers","^[0-9]+$",[trim]))), 
    <<"*** Failers">> = iolist_to_binary(join(re:split("*** Failers","^[0-9]+$",[{parts,
                                                                                                                                                                                       2}]))), 
    <<"*** Failers">> = iolist_to_binary(join(re:split("*** Failers","^[0-9]+$",[]))), 
    <<"abc">> = iolist_to_binary(join(re:split("abc","^[0-9]+$",[trim]))), 
    <<"abc">> = iolist_to_binary(join(re:split("abc","^[0-9]+$",[{parts,
                                                                                                                                                                       2}]))), 
    <<"abc">> = iolist_to_binary(join(re:split("abc","^[0-9]+$",[]))), 
    <<"">> = iolist_to_binary(join(re:split("enter","^.*nter",[trim]))), 
    <<":">> = iolist_to_binary(join(re:split("enter","^.*nter",[{parts,
                                                                                                                                                                        2}]))), 
    <<":">> = iolist_to_binary(join(re:split("enter","^.*nter",[]))), 
    <<"">> = iolist_to_binary(join(re:split("inter","^.*nter",[trim]))), 
    <<":">> = iolist_to_binary(join(re:split("inter","^.*nter",[{parts,
                                                                                                                                                                        2}]))), 
    <<":">> = iolist_to_binary(join(re:split("inter","^.*nter",[]))), 
    <<"">> = iolist_to_binary(join(re:split("uponter","^.*nter",[trim]))), 
    <<":">> = iolist_to_binary(join(re:split("uponter","^.*nter",[{parts,
                                                                                                                                                                            2}]))), 
    <<":">> = iolist_to_binary(join(re:split("uponter","^.*nter",[]))), 
    ok.
run1() ->
    <<"">> = iolist_to_binary(join(re:split("xxx0","^xxx[0-9]+$",[trim]))), 
    <<":">> = iolist_to_binary(join(re:split("xxx0","^xxx[0-9]+$",[{parts,
                                                                                                                                                                               2}]))), 
    <<":">> = iolist_to_binary(join(re:split("xxx0","^xxx[0-9]+$",[]))), 
    <<"">> = iolist_to_binary(join(re:split("xxx1234","^xxx[0-9]+$",[trim]))), 
    <<":">> = iolist_to_binary(join(re:split("xxx1234","^xxx[0-9]+$",[{parts,
                                                                                                                                                                                     2}]))), 
    <<":">> = iolist_to_binary(join(re:split("xxx1234","^xxx[0-9]+$",[]))), 
    <<"*** Failers">> = iolist_to_binary(join(re:split("*** Failers","^xxx[0-9]+$",[trim]))), 
    <<"*** Failers">> = iolist_to_binary(join(re:split("*** Failers","^xxx[0-9]+$",[{parts,
                                                                                                                                                                                             2}]))), 
    <<"*** Failers">> = iolist_to_binary(join(re:split("*** Failers","^xxx[0-9]+$",[]))), 
    <<"xxx">> = iolist_to_binary(join(re:split("xxx","^xxx[0-9]+$",[trim]))), 
    <<"xxx">> = iolist_to_binary(join(re:split("xxx","^xxx[0-9]+$",[{parts,
                                                                                                                                                                             2}]))), 
    <<"xxx">> = iolist_to_binary(join(re:split("xxx","^xxx[0-9]+$",[]))), 
    <<"">> = iolist_to_binary(join(re:split("x123","^.+[0-9][0-9][0-9]$",[trim]))), 
    <<":">> = iolist_to_binary(join(re:split("x123","^.+[0-9][0-9][0-9]$",[{parts,
                                                                                                                                                                                               2}]))), 
    <<":">> = iolist_to_binary(join(re:split("x123","^.+[0-9][0-9][0-9]$",[]))), 
    <<"">> = iolist_to_binary(join(re:split("xx123","^.+[0-9][0-9][0-9]$",[trim]))), 
    <<":">> = iolist_to_binary(join(re:split("xx123","^.+[0-9][0-9][0-9]$",[{parts,
                                                                                                                                                                                                 2}]))), 
    <<":">> = iolist_to_binary(join(re:split("xx123","^.+[0-9][0-9][0-9]$",[]))), 
    <<"">> = iolist_to_binary(join(re:split("123456","^.+[0-9][0-9][0-9]$",[trim]))), 
    <<":">> = iolist_to_binary(join(re:split("123456","^.+[0-9][0-9][0-9]$",[{parts,
                                                                                                                                                                                                   2}]))), 
    <<":">> = iolist_to_binary(join(re:split("123456","^.+[0-9][0-9][0-9]$",[]))), 
    <<"*** Failers">> = iolist_to_binary(join(re:split("*** Failers","^.+[0-9][0-9][0-9]$",[trim]))), 
    <<"*** Failers">> = iolist_to_binary(join(re:split("*** Failers","^.+[0-9][0-9][0-9]$",[{parts,
                                                                                                                                                                                                             2}]))), 
    <<"*** Failers">> = iolist_to_binary(join(re:split("*** Failers","^.+[0-9][0-9][0-9]$",[]))), 
    <<"123">> = iolist_to_binary(join(re:split("123","^.+[0-9][0-9][0-9]$",[trim]))), 
    <<"123">> = iolist_to_binary(join(re:split("123","^.+[0-9][0-9][0-9]$",[{parts,
                                                                                                                                                                                             2}]))), 
    <<"123">> = iolist_to_binary(join(re:split("123","^.+[0-9][0-9][0-9]$",[]))), 
    <<"">> = iolist_to_binary(join(re:split("x1234","^.+[0-9][0-9][0-9]$",[trim]))), 
    <<":">> = iolist_to_binary(join(re:split("x1234","^.+[0-9][0-9][0-9]$",[{parts,
                                                                                                                                                                                                 2}]))), 
    <<":">> = iolist_to_binary(join(re:split("x1234","^.+[0-9][0-9][0-9]$",[]))), 
    <<"">> = iolist_to_binary(join(re:split("x123","^.+?[0-9][0-9][0-9]$",[trim]))), 
    <<":">> = iolist_to_binary(join(re:split("x123","^.+?[0-9][0-9][0-9]$",[{parts,
                                                                                                                                                                                                 2}]))), 
    <<":">> = iolist_to_binary(join(re:split("x123","^.+?[0-9][0-9][0-9]$",[]))), 
    <<"">> = iolist_to_binary(join(re:split("xx123","^.+?[0-9][0-9][0-9]$",[trim]))), 
    <<":">> = iolist_to_binary(join(re:split("xx123","^.+?[0-9][0-9][0-9]$",[{parts,
                                                                                                                                                                                                   2}]))), 
    <<":">> = iolist_to_binary(join(re:split("xx123","^.+?[0-9][0-9][0-9]$",[]))), 
    <<"">> = iolist_to_binary(join(re:split("123456","^.+?[0-9][0-9][0-9]$",[trim]))), 
    <<":">> = iolist_to_binary(join(re:split("123456","^.+?[0-9][0-9][0-9]$",[{parts,
                                                                                                                                                                                                     2}]))), 
    <<":">> = iolist_to_binary(join(re:split("123456","^.+?[0-9][0-9][0-9]$",[]))), 
    <<"*** Failers">> = iolist_to_binary(join(re:split("*** Failers","^.+?[0-9][0-9][0-9]$",[trim]))), 
    <<"*** Failers">> = iolist_to_binary(join(re:split("*** Failers","^.+?[0-9][0-9][0-9]$",[{parts,
                                                                                                                                                                                                               2}]))), 
    <<"*** Failers">> = iolist_to_binary(join(re:split("*** Failers","^.+?[0-9][0-9][0-9]$",[]))), 
    <<"123">> = iolist_to_binary(join(re:split("123","^.+?[0-9][0-9][0-9]$",[trim]))), 
    <<"123">> = iolist_to_binary(join(re:split("123","^.+?[0-9][0-9][0-9]$",[{parts,
                                                                                                                                                                                               2}]))), 
    <<"123">> = iolist_to_binary(join(re:split("123","^.+?[0-9][0-9][0-9]$",[]))), 
    <<"">> = iolist_to_binary(join(re:split("x1234","^.+?[0-9][0-9][0-9]$",[trim]))), 
    <<":">> = iolist_to_binary(join(re:split("x1234","^.+?[0-9][0-9][0-9]$",[{parts,
                                                                                                                                                                                                   2}]))), 
    <<":">> = iolist_to_binary(join(re:split("x1234","^.+?[0-9][0-9][0-9]$",[]))), 
    <<":abc:pqr">> = iolist_to_binary(join(re:split("abc!pqr=apquxz.ixr.zzz.ac.uk","^([^!]+)!(.+)=apquxz\\.ixr\\.zzz\\.ac\\.uk$",[trim]))), 
    <<":abc:pqr:">> = iolist_to_binary(join(re:split("abc!pqr=apquxz.ixr.zzz.ac.uk","^([^!]+)!(.+)=apquxz\\.ixr\\.zzz\\.ac\\.uk$",[{parts,
                                                                                                                                                                                                                                                                                                   2}]))), 
    <<":abc:pqr:">> = iolist_to_binary(join(re:split("abc!pqr=apquxz.ixr.zzz.ac.uk","^([^!]+)!(.+)=apquxz\\.ixr\\.zzz\\.ac\\.uk$",[]))), 
    <<"*** Failers">> = iolist_to_binary(join(re:split("*** Failers","^([^!]+)!(.+)=apquxz\\.ixr\\.zzz\\.ac\\.uk$",[trim]))), 
    <<"*** Failers">> = iolist_to_binary(join(re:split("*** Failers","^([^!]+)!(.+)=apquxz\\.ixr\\.zzz\\.ac\\.uk$",[{parts,
                                                                                                                                                                                                                                                                 2}]))), 
    <<"*** Failers">> = iolist_to_binary(join(re:split("*** Failers","^([^!]+)!(.+)=apquxz\\.ixr\\.zzz\\.ac\\.uk$",[]))), 
    <<"!pqr=apquxz.ixr.zzz.ac.uk">> = iolist_to_binary(join(re:split("!pqr=apquxz.ixr.zzz.ac.uk","^([^!]+)!(.+)=apquxz\\.ixr\\.zzz\\.ac\\.uk$",[trim]))), 
    <<"!pqr=apquxz.ixr.zzz.ac.uk">> = iolist_to_binary(join(re:split("!pqr=apquxz.ixr.zzz.ac.uk","^([^!]+)!(.+)=apquxz\\.ixr\\.zzz\\.ac\\.uk$",[{parts,
                                                                                                                                                                                                                                                                                             2}]))), 
    <<"!pqr=apquxz.ixr.zzz.ac.uk">> = iolist_to_binary(join(re:split("!pqr=apquxz.ixr.zzz.ac.uk","^([^!]+)!(.+)=apquxz\\.ixr\\.zzz\\.ac\\.uk$",[]))), 
    <<"abc!=apquxz.ixr.zzz.ac.uk">> = iolist_to_binary(join(re:split("abc!=apquxz.ixr.zzz.ac.uk","^([^!]+)!(.+)=apquxz\\.ixr\\.zzz\\.ac\\.uk$",[trim]))), 
    <<"abc!=apquxz.ixr.zzz.ac.uk">> = iolist_to_binary(join(re:split("abc!=apquxz.ixr.zzz.ac.uk","^([^!]+)!(.+)=apquxz\\.ixr\\.zzz\\.ac\\.uk$",[{parts,
                                                                                                                                                                                                                                                                                             2}]))), 
    <<"abc!=apquxz.ixr.zzz.ac.uk">> = iolist_to_binary(join(re:split("abc!=apquxz.ixr.zzz.ac.uk","^([^!]+)!(.+)=apquxz\\.ixr\\.zzz\\.ac\\.uk$",[]))), 
    <<"abc!pqr=apquxz:ixr.zzz.ac.uk">> = iolist_to_binary(join(re:split("abc!pqr=apquxz:ixr.zzz.ac.uk","^([^!]+)!(.+)=apquxz\\.ixr\\.zzz\\.ac\\.uk$",[trim]))), 
    <<"abc!pqr=apquxz:ixr.zzz.ac.uk">> = iolist_to_binary(join(re:split("abc!pqr=apquxz:ixr.zzz.ac.uk","^([^!]+)!(.+)=apquxz\\.ixr\\.zzz\\.ac\\.uk$",[{parts,
                                                                                                                                                                                                                                                                                                   2}]))), 
    <<"abc!pqr=apquxz:ixr.zzz.ac.uk">> = iolist_to_binary(join(re:split("abc!pqr=apquxz:ixr.zzz.ac.uk","^([^!]+)!(.+)=apquxz\\.ixr\\.zzz\\.ac\\.uk$",[]))), 
    <<"abc!pqr=apquxz.ixr.zzz.ac.ukk">> = iolist_to_binary(join(re:split("abc!pqr=apquxz.ixr.zzz.ac.ukk","^([^!]+)!(.+)=apquxz\\.ixr\\.zzz\\.ac\\.uk$",[trim]))), 
    <<"abc!pqr=apquxz.ixr.zzz.ac.ukk">> = iolist_to_binary(join(re:split("abc!pqr=apquxz.ixr.zzz.ac.ukk","^([^!]+)!(.+)=apquxz\\.ixr\\.zzz\\.ac\\.uk$",[{parts,
                                                                                                                                                                                                                                                                                                     2}]))), 
    <<"abc!pqr=apquxz.ixr.zzz.ac.ukk">> = iolist_to_binary(join(re:split("abc!pqr=apquxz.ixr.zzz.ac.ukk","^([^!]+)!(.+)=apquxz\\.ixr\\.zzz\\.ac\\.uk$",[]))), 
    <<"Well, we need a colon: somewhere">> = iolist_to_binary(join(re:split("Well, we need a colon: somewhere",":",[trim]))), 
    <<"Well, we need a colon: somewhere">> = iolist_to_binary(join(re:split("Well, we need a colon: somewhere",":",[{parts,
                                                                                                                                                                                                                  2}]))), 
    <<"Well, we need a colon: somewhere">> = iolist_to_binary(join(re:split("Well, we need a colon: somewhere",":",[]))), 
    <<"*** Fail if we don't">> = iolist_to_binary(join(re:split("*** Fail if we don't",":",[trim]))), 
    <<"*** Fail if we don't">> = iolist_to_binary(join(re:split("*** Fail if we don't",":",[{parts,
                                                                                                                                                                                                  2}]))), 
    <<"*** Fail if we don't">> = iolist_to_binary(join(re:split("*** Fail if we don't",":",[]))), 
    <<":0abc">> = iolist_to_binary(join(re:split("0abc","([\\da-f:]+)$",[caseless,
                                                                                                                                                                                  trim]))), 
    <<":0abc:">> = iolist_to_binary(join(re:split("0abc","([\\da-f:]+)$",[caseless,
                                                                                                                                                                                    {parts,
                                                                                                                                                                                     2}]))), 
    <<":0abc:">> = iolist_to_binary(join(re:split("0abc","([\\da-f:]+)$",[caseless]))), 
    <<":abc">> = iolist_to_binary(join(re:split("abc","([\\da-f:]+)$",[caseless,
                                                                                                                                                                                trim]))), 
    <<":abc:">> = iolist_to_binary(join(re:split("abc","([\\da-f:]+)$",[caseless,
                                                                                                                                                                                  {parts,
                                                                                                                                                                                   2}]))), 
    <<":abc:">> = iolist_to_binary(join(re:split("abc","([\\da-f:]+)$",[caseless]))), 
    <<":fed">> = iolist_to_binary(join(re:split("fed","([\\da-f:]+)$",[caseless,
                                                                                                                                                                                trim]))), 
    <<":fed:">> = iolist_to_binary(join(re:split("fed","([\\da-f:]+)$",[caseless,
                                                                                                                                                                                  {parts,
                                                                                                                                                                                   2}]))), 
    <<":fed:">> = iolist_to_binary(join(re:split("fed","([\\da-f:]+)$",[caseless]))), 
    <<":E">> = iolist_to_binary(join(re:split("E","([\\da-f:]+)$",[caseless,
                                                                                                                                                                            trim]))), 
    <<":E:">> = iolist_to_binary(join(re:split("E","([\\da-f:]+)$",[caseless,
                                                                                                                                                                              {parts,
                                                                                                                                                                               2}]))), 
    <<":E:">> = iolist_to_binary(join(re:split("E","([\\da-f:]+)$",[caseless]))), 
    <<":::">> = iolist_to_binary(join(re:split("::","([\\da-f:]+)$",[caseless,
                                                                                                                                                                              trim]))), 
    <<"::::">> = iolist_to_binary(join(re:split("::","([\\da-f:]+)$",[caseless,
                                                                                                                                                                                {parts,
                                                                                                                                                                                 2}]))), 
    <<"::::">> = iolist_to_binary(join(re:split("::","([\\da-f:]+)$",[caseless]))), 
    <<":5f03:12C0::932e">> = iolist_to_binary(join(re:split("5f03:12C0::932e","([\\da-f:]+)$",[caseless,
                                                                                                                                                                                                        trim]))), 
    <<":5f03:12C0::932e:">> = iolist_to_binary(join(re:split("5f03:12C0::932e","([\\da-f:]+)$",[caseless,
                                                                                                                                                                                                          {parts,
                                                                                                                                                                                                           2}]))), 
    <<":5f03:12C0::932e:">> = iolist_to_binary(join(re:split("5f03:12C0::932e","([\\da-f:]+)$",[caseless]))), 
    <<"fed :def">> = iolist_to_binary(join(re:split("fed def","([\\da-f:]+)$",[caseless,
                                                                                                                                                                                        trim]))), 
    <<"fed :def:">> = iolist_to_binary(join(re:split("fed def","([\\da-f:]+)$",[caseless,
                                                                                                                                                                                          {parts,
                                                                                                                                                                                           2}]))), 
    <<"fed :def:">> = iolist_to_binary(join(re:split("fed def","([\\da-f:]+)$",[caseless]))), 
    <<"Any old stu:ff">> = iolist_to_binary(join(re:split("Any old stuff","([\\da-f:]+)$",[caseless,
                                                                                                                                                                                                    trim]))), 
    <<"Any old stu:ff:">> = iolist_to_binary(join(re:split("Any old stuff","([\\da-f:]+)$",[caseless,
                                                                                                                                                                                                      {parts,
                                                                                                                                                                                                       2}]))), 
    <<"Any old stu:ff:">> = iolist_to_binary(join(re:split("Any old stuff","([\\da-f:]+)$",[caseless]))), 
    <<"*** Failers">> = iolist_to_binary(join(re:split("*** Failers","([\\da-f:]+)$",[caseless,
                                                                                                                                                                                                trim]))), 
    <<"*** Failers">> = iolist_to_binary(join(re:split("*** Failers","([\\da-f:]+)$",[caseless,
                                                                                                                                                                                                  {parts,
                                                                                                                                                                                                   2}]))), 
    <<"*** Failers">> = iolist_to_binary(join(re:split("*** Failers","([\\da-f:]+)$",[caseless]))), 
    <<"0zzz">> = iolist_to_binary(join(re:split("0zzz","([\\da-f:]+)$",[caseless,
                                                                                                                                                                                  trim]))), 
    <<"0zzz">> = iolist_to_binary(join(re:split("0zzz","([\\da-f:]+)$",[caseless,
                                                                                                                                                                                    {parts,
                                                                                                                                                                                     2}]))), 
    <<"0zzz">> = iolist_to_binary(join(re:split("0zzz","([\\da-f:]+)$",[caseless]))), 
    <<"gzzz">> = iolist_to_binary(join(re:split("gzzz","([\\da-f:]+)$",[caseless,
                                                                                                                                                                                  trim]))), 
    <<"gzzz">> = iolist_to_binary(join(re:split("gzzz","([\\da-f:]+)$",[caseless,
                                                                                                                                                                                    {parts,
                                                                                                                                                                                     2}]))), 
    <<"gzzz">> = iolist_to_binary(join(re:split("gzzz","([\\da-f:]+)$",[caseless]))), 
    <<"fed ">> = iolist_to_binary(join(re:split("fed ","([\\da-f:]+)$",[caseless,
                                                                                                                                                                                  trim]))), 
    <<"fed ">> = iolist_to_binary(join(re:split("fed ","([\\da-f:]+)$",[caseless,
                                                                                                                                                                                    {parts,
                                                                                                                                                                                     2}]))), 
    <<"fed ">> = iolist_to_binary(join(re:split("fed ","([\\da-f:]+)$",[caseless]))), 
    <<"Any old rubbish">> = iolist_to_binary(join(re:split("Any old rubbish","([\\da-f:]+)$",[caseless,
                                                                                                                                                                                                        trim]))), 
    <<"Any old rubbish">> = iolist_to_binary(join(re:split("Any old rubbish","([\\da-f:]+)$",[caseless,
                                                                                                                                                                                                          {parts,
                                                                                                                                                                                                           2}]))), 
    <<"Any old rubbish">> = iolist_to_binary(join(re:split("Any old rubbish","([\\da-f:]+)$",[caseless]))), 
    <<":1:2:3">> = iolist_to_binary(join(re:split(".1.2.3","^.*\\.(\\d{1,3})\\.(\\d{1,3})\\.(\\d{1,3})$",[trim]))), 
    <<":1:2:3:">> = iolist_to_binary(join(re:split(".1.2.3","^.*\\.(\\d{1,3})\\.(\\d{1,3})\\.(\\d{1,3})$",[{parts,
                                                                                                                                                                                                                                                         2}]))), 
    <<":1:2:3:">> = iolist_to_binary(join(re:split(".1.2.3","^.*\\.(\\d{1,3})\\.(\\d{1,3})\\.(\\d{1,3})$",[]))), 
    <<":12:123:0">> = iolist_to_binary(join(re:split("A.12.123.0","^.*\\.(\\d{1,3})\\.(\\d{1,3})\\.(\\d{1,3})$",[trim]))), 
    <<":12:123:0:">> = iolist_to_binary(join(re:split("A.12.123.0","^.*\\.(\\d{1,3})\\.(\\d{1,3})\\.(\\d{1,3})$",[{parts,
                                                                                                                                                                                                                                                                 2}]))), 
    <<":12:123:0:">> = iolist_to_binary(join(re:split("A.12.123.0","^.*\\.(\\d{1,3})\\.(\\d{1,3})\\.(\\d{1,3})$",[]))), 
    <<"*** Failers">> = iolist_to_binary(join(re:split("*** Failers","^.*\\.(\\d{1,3})\\.(\\d{1,3})\\.(\\d{1,3})$",[trim]))), 
    <<"*** Failers">> = iolist_to_binary(join(re:split("*** Failers","^.*\\.(\\d{1,3})\\.(\\d{1,3})\\.(\\d{1,3})$",[{parts,
                                                                                                                                                                                                                                                                   2}]))), 
    <<"*** Failers">> = iolist_to_binary(join(re:split("*** Failers","^.*\\.(\\d{1,3})\\.(\\d{1,3})\\.(\\d{1,3})$",[]))), 
    <<".1.2.3333">> = iolist_to_binary(join(re:split(".1.2.3333","^.*\\.(\\d{1,3})\\.(\\d{1,3})\\.(\\d{1,3})$",[trim]))), 
    <<".1.2.3333">> = iolist_to_binary(join(re:split(".1.2.3333","^.*\\.(\\d{1,3})\\.(\\d{1,3})\\.(\\d{1,3})$",[{parts,
                                                                                                                                                                                                                                                               2}]))), 
    <<".1.2.3333">> = iolist_to_binary(join(re:split(".1.2.3333","^.*\\.(\\d{1,3})\\.(\\d{1,3})\\.(\\d{1,3})$",[]))), 
    <<"1.2.3">> = iolist_to_binary(join(re:split("1.2.3","^.*\\.(\\d{1,3})\\.(\\d{1,3})\\.(\\d{1,3})$",[trim]))), 
    <<"1.2.3">> = iolist_to_binary(join(re:split("1.2.3","^.*\\.(\\d{1,3})\\.(\\d{1,3})\\.(\\d{1,3})$",[{parts,
                                                                                                                                                                                                                                                       2}]))), 
    <<"1.2.3">> = iolist_to_binary(join(re:split("1.2.3","^.*\\.(\\d{1,3})\\.(\\d{1,3})\\.(\\d{1,3})$",[]))), 
    <<"1234.2.3">> = iolist_to_binary(join(re:split("1234.2.3","^.*\\.(\\d{1,3})\\.(\\d{1,3})\\.(\\d{1,3})$",[trim]))), 
    <<"1234.2.3">> = iolist_to_binary(join(re:split("1234.2.3","^.*\\.(\\d{1,3})\\.(\\d{1,3})\\.(\\d{1,3})$",[{parts,
                                                                                                                                                                                                                                                             2}]))), 
    <<"1234.2.3">> = iolist_to_binary(join(re:split("1234.2.3","^.*\\.(\\d{1,3})\\.(\\d{1,3})\\.(\\d{1,3})$",[]))), 
    <<":1:non-sp1:non-sp2">> = iolist_to_binary(join(re:split("1 IN SOA non-sp1 non-sp2(","^(\\d+)\\s+IN\\s+SOA\\s+(\\S+)\\s+(\\S+)\\s*\\(\\s*$",[trim]))), 
    <<":1:non-sp1:non-sp2:">> = iolist_to_binary(join(re:split("1 IN SOA non-sp1 non-sp2(","^(\\d+)\\s+IN\\s+SOA\\s+(\\S+)\\s+(\\S+)\\s*\\(\\s*$",[{parts,
                                                                                                                                                                                                                                                                                                                     2}]))), 
    <<":1:non-sp1:non-sp2:">> = iolist_to_binary(join(re:split("1 IN SOA non-sp1 non-sp2(","^(\\d+)\\s+IN\\s+SOA\\s+(\\S+)\\s+(\\S+)\\s*\\(\\s*$",[]))), 
    <<":1:non-sp1:non-sp2">> = iolist_to_binary(join(re:split("1    IN    SOA    non-sp1    non-sp2   (","^(\\d+)\\s+IN\\s+SOA\\s+(\\S+)\\s+(\\S+)\\s*\\(\\s*$",[trim]))), 
    <<":1:non-sp1:non-sp2:">> = iolist_to_binary(join(re:split("1    IN    SOA    non-sp1    non-sp2   (","^(\\d+)\\s+IN\\s+SOA\\s+(\\S+)\\s+(\\S+)\\s*\\(\\s*$",[{parts,
                                                                                                                                                                                                                                                                                                                                                   2}]))), 
    <<":1:non-sp1:non-sp2:">> = iolist_to_binary(join(re:split("1    IN    SOA    non-sp1    non-sp2   (","^(\\d+)\\s+IN\\s+SOA\\s+(\\S+)\\s+(\\S+)\\s*\\(\\s*$",[]))), 
    <<"*** Failers">> = iolist_to_binary(join(re:split("*** Failers","^(\\d+)\\s+IN\\s+SOA\\s+(\\S+)\\s+(\\S+)\\s*\\(\\s*$",[trim]))), 
    <<"*** Failers">> = iolist_to_binary(join(re:split("*** Failers","^(\\d+)\\s+IN\\s+SOA\\s+(\\S+)\\s+(\\S+)\\s*\\(\\s*$",[{parts,
                                                                                                                                                                                                                                                                                         2}]))), 
    <<"*** Failers">> = iolist_to_binary(join(re:split("*** Failers","^(\\d+)\\s+IN\\s+SOA\\s+(\\S+)\\s+(\\S+)\\s*\\(\\s*$",[]))), 
    <<"1IN SOA non-sp1 non-sp2(">> = iolist_to_binary(join(re:split("1IN SOA non-sp1 non-sp2(","^(\\d+)\\s+IN\\s+SOA\\s+(\\S+)\\s+(\\S+)\\s*\\(\\s*$",[trim]))), 
    <<"1IN SOA non-sp1 non-sp2(">> = iolist_to_binary(join(re:split("1IN SOA non-sp1 non-sp2(","^(\\d+)\\s+IN\\s+SOA\\s+(\\S+)\\s+(\\S+)\\s*\\(\\s*$",[{parts,
                                                                                                                                                                                                                                                                                                                   2}]))), 
    <<"1IN SOA non-sp1 non-sp2(">> = iolist_to_binary(join(re:split("1IN SOA non-sp1 non-sp2(","^(\\d+)\\s+IN\\s+SOA\\s+(\\S+)\\s+(\\S+)\\s*\\(\\s*$",[]))), 
    <<"">> = iolist_to_binary(join(re:split("a.","^[a-zA-Z\\d][a-zA-Z\\d\\-]*(\\.[a-zA-Z\\d][a-zA-z\\d\\-]*)*\\.$",[trim]))), 
    <<"::">> = iolist_to_binary(join(re:split("a.","^[a-zA-Z\\d][a-zA-Z\\d\\-]*(\\.[a-zA-Z\\d][a-zA-z\\d\\-]*)*\\.$",[{parts,
                                                                                                                                                                                                                                                                                           2}]))), 
    <<"::">> = iolist_to_binary(join(re:split("a.","^[a-zA-Z\\d][a-zA-Z\\d\\-]*(\\.[a-zA-Z\\d][a-zA-z\\d\\-]*)*\\.$",[]))), 
    <<"">> = iolist_to_binary(join(re:split("Z.","^[a-zA-Z\\d][a-zA-Z\\d\\-]*(\\.[a-zA-Z\\d][a-zA-z\\d\\-]*)*\\.$",[trim]))), 
    <<"::">> = iolist_to_binary(join(re:split("Z.","^[a-zA-Z\\d][a-zA-Z\\d\\-]*(\\.[a-zA-Z\\d][a-zA-z\\d\\-]*)*\\.$",[{parts,
                                                                                                                                                                                                                                                                                           2}]))), 
    <<"::">> = iolist_to_binary(join(re:split("Z.","^[a-zA-Z\\d][a-zA-Z\\d\\-]*(\\.[a-zA-Z\\d][a-zA-z\\d\\-]*)*\\.$",[]))), 
    <<"">> = iolist_to_binary(join(re:split("2.","^[a-zA-Z\\d][a-zA-Z\\d\\-]*(\\.[a-zA-Z\\d][a-zA-z\\d\\-]*)*\\.$",[trim]))), 
    <<"::">> = iolist_to_binary(join(re:split("2.","^[a-zA-Z\\d][a-zA-Z\\d\\-]*(\\.[a-zA-Z\\d][a-zA-z\\d\\-]*)*\\.$",[{parts,
                                                                                                                                                                                                                                                                                           2}]))), 
    <<"::">> = iolist_to_binary(join(re:split("2.","^[a-zA-Z\\d][a-zA-Z\\d\\-]*(\\.[a-zA-Z\\d][a-zA-z\\d\\-]*)*\\.$",[]))), 
    <<":.pq-r">> = iolist_to_binary(join(re:split("ab-c.pq-r.","^[a-zA-Z\\d][a-zA-Z\\d\\-]*(\\.[a-zA-Z\\d][a-zA-z\\d\\-]*)*\\.$",[trim]))), 
    <<":.pq-r:">> = iolist_to_binary(join(re:split("ab-c.pq-r.","^[a-zA-Z\\d][a-zA-Z\\d\\-]*(\\.[a-zA-Z\\d][a-zA-z\\d\\-]*)*\\.$",[{parts,
                                                                                                                                                                                                                                                                                                           2}]))), 
    <<":.pq-r:">> = iolist_to_binary(join(re:split("ab-c.pq-r.","^[a-zA-Z\\d][a-zA-Z\\d\\-]*(\\.[a-zA-Z\\d][a-zA-z\\d\\-]*)*\\.$",[]))), 
    <<":.uk">> = iolist_to_binary(join(re:split("sxk.zzz.ac.uk.","^[a-zA-Z\\d][a-zA-Z\\d\\-]*(\\.[a-zA-Z\\d][a-zA-z\\d\\-]*)*\\.$",[trim]))), 
    <<":.uk:">> = iolist_to_binary(join(re:split("sxk.zzz.ac.uk.","^[a-zA-Z\\d][a-zA-Z\\d\\-]*(\\.[a-zA-Z\\d][a-zA-z\\d\\-]*)*\\.$",[{parts,
                                                                                                                                                                                                                                                                                                                   2}]))), 
    <<":.uk:">> = iolist_to_binary(join(re:split("sxk.zzz.ac.uk.","^[a-zA-Z\\d][a-zA-Z\\d\\-]*(\\.[a-zA-Z\\d][a-zA-z\\d\\-]*)*\\.$",[]))), 
    <<":.y-">> = iolist_to_binary(join(re:split("x-.y-.","^[a-zA-Z\\d][a-zA-Z\\d\\-]*(\\.[a-zA-Z\\d][a-zA-z\\d\\-]*)*\\.$",[trim]))), 
    <<":.y-:">> = iolist_to_binary(join(re:split("x-.y-.","^[a-zA-Z\\d][a-zA-Z\\d\\-]*(\\.[a-zA-Z\\d][a-zA-z\\d\\-]*)*\\.$",[{parts,
                                                                                                                                                                                                                                                                                                   2}]))), 
    <<":.y-:">> = iolist_to_binary(join(re:split("x-.y-.","^[a-zA-Z\\d][a-zA-Z\\d\\-]*(\\.[a-zA-Z\\d][a-zA-z\\d\\-]*)*\\.$",[]))), 
    <<"*** Failers">> = iolist_to_binary(join(re:split("*** Failers","^[a-zA-Z\\d][a-zA-Z\\d\\-]*(\\.[a-zA-Z\\d][a-zA-z\\d\\-]*)*\\.$",[trim]))), 
    <<"*** Failers">> = iolist_to_binary(join(re:split("*** Failers","^[a-zA-Z\\d][a-zA-Z\\d\\-]*(\\.[a-zA-Z\\d][a-zA-z\\d\\-]*)*\\.$",[{parts,
                                                                                                                                                                                                                                                                                                             2}]))), 
    <<"*** Failers">> = iolist_to_binary(join(re:split("*** Failers","^[a-zA-Z\\d][a-zA-Z\\d\\-]*(\\.[a-zA-Z\\d][a-zA-z\\d\\-]*)*\\.$",[]))), 
    <<"-abc.peq.">> = iolist_to_binary(join(re:split("-abc.peq.","^[a-zA-Z\\d][a-zA-Z\\d\\-]*(\\.[a-zA-Z\\d][a-zA-z\\d\\-]*)*\\.$",[trim]))), 
    <<"-abc.peq.">> = iolist_to_binary(join(re:split("-abc.peq.","^[a-zA-Z\\d][a-zA-Z\\d\\-]*(\\.[a-zA-Z\\d][a-zA-z\\d\\-]*)*\\.$",[{parts,
                                                                                                                                                                                                                                                                                                         2}]))), 
    <<"-abc.peq.">> = iolist_to_binary(join(re:split("-abc.peq.","^[a-zA-Z\\d][a-zA-Z\\d\\-]*(\\.[a-zA-Z\\d][a-zA-z\\d\\-]*)*\\.$",[]))), 
    <<"">> = iolist_to_binary(join(re:split("*.a","^\\*\\.[a-z]([a-z\\-\\d]*[a-z\\d]+)?(\\.[a-z]([a-z\\-\\d]*[a-z\\d]+)?)*$",[trim]))), 
    <<"::::">> = iolist_to_binary(join(re:split("*.a","^\\*\\.[a-z]([a-z\\-\\d]*[a-z\\d]+)?(\\.[a-z]([a-z\\-\\d]*[a-z\\d]+)?)*$",[{parts,
                                                                                                                                                                                                                                                                                                                2}]))), 
    <<"::::">> = iolist_to_binary(join(re:split("*.a","^\\*\\.[a-z]([a-z\\-\\d]*[a-z\\d]+)?(\\.[a-z]([a-z\\-\\d]*[a-z\\d]+)?)*$",[]))), 
    <<":0-a">> = iolist_to_binary(join(re:split("*.b0-a","^\\*\\.[a-z]([a-z\\-\\d]*[a-z\\d]+)?(\\.[a-z]([a-z\\-\\d]*[a-z\\d]+)?)*$",[trim]))), 
    <<":0-a:::">> = iolist_to_binary(join(re:split("*.b0-a","^\\*\\.[a-z]([a-z\\-\\d]*[a-z\\d]+)?(\\.[a-z]([a-z\\-\\d]*[a-z\\d]+)?)*$",[{parts,
                                                                                                                                                                                                                                                                                                                      2}]))), 
    <<":0-a:::">> = iolist_to_binary(join(re:split("*.b0-a","^\\*\\.[a-z]([a-z\\-\\d]*[a-z\\d]+)?(\\.[a-z]([a-z\\-\\d]*[a-z\\d]+)?)*$",[]))), 
    <<":3-b:.c">> = iolist_to_binary(join(re:split("*.c3-b.c","^\\*\\.[a-z]([a-z\\-\\d]*[a-z\\d]+)?(\\.[a-z]([a-z\\-\\d]*[a-z\\d]+)?)*$",[trim]))), 
    <<":3-b:.c::">> = iolist_to_binary(join(re:split("*.c3-b.c","^\\*\\.[a-z]([a-z\\-\\d]*[a-z\\d]+)?(\\.[a-z]([a-z\\-\\d]*[a-z\\d]+)?)*$",[{parts,
                                                                                                                                                                                                                                                                                                                          2}]))), 
    <<":3-b:.c::">> = iolist_to_binary(join(re:split("*.c3-b.c","^\\*\\.[a-z]([a-z\\-\\d]*[a-z\\d]+)?(\\.[a-z]([a-z\\-\\d]*[a-z\\d]+)?)*$",[]))), 
    <<":-a:.b-c:-c">> = iolist_to_binary(join(re:split("*.c-a.b-c","^\\*\\.[a-z]([a-z\\-\\d]*[a-z\\d]+)?(\\.[a-z]([a-z\\-\\d]*[a-z\\d]+)?)*$",[trim]))), 
    <<":-a:.b-c:-c:">> = iolist_to_binary(join(re:split("*.c-a.b-c","^\\*\\.[a-z]([a-z\\-\\d]*[a-z\\d]+)?(\\.[a-z]([a-z\\-\\d]*[a-z\\d]+)?)*$",[{parts,
                                                                                                                                                                                                                                                                                                                            2}]))), 
    <<":-a:.b-c:-c:">> = iolist_to_binary(join(re:split("*.c-a.b-c","^\\*\\.[a-z]([a-z\\-\\d]*[a-z\\d]+)?(\\.[a-z]([a-z\\-\\d]*[a-z\\d]+)?)*$",[]))), 
    <<"*** Failers">> = iolist_to_binary(join(re:split("*** Failers","^\\*\\.[a-z]([a-z\\-\\d]*[a-z\\d]+)?(\\.[a-z]([a-z\\-\\d]*[a-z\\d]+)?)*$",[trim]))), 
    <<"*** Failers">> = iolist_to_binary(join(re:split("*** Failers","^\\*\\.[a-z]([a-z\\-\\d]*[a-z\\d]+)?(\\.[a-z]([a-z\\-\\d]*[a-z\\d]+)?)*$",[{parts,
                                                                                                                                                                                                                                                                                                                                2}]))), 
    <<"*** Failers">> = iolist_to_binary(join(re:split("*** Failers","^\\*\\.[a-z]([a-z\\-\\d]*[a-z\\d]+)?(\\.[a-z]([a-z\\-\\d]*[a-z\\d]+)?)*$",[]))), 
    <<"*.0">> = iolist_to_binary(join(re:split("*.0","^\\*\\.[a-z]([a-z\\-\\d]*[a-z\\d]+)?(\\.[a-z]([a-z\\-\\d]*[a-z\\d]+)?)*$",[trim]))), 
    <<"*.0">> = iolist_to_binary(join(re:split("*.0","^\\*\\.[a-z]([a-z\\-\\d]*[a-z\\d]+)?(\\.[a-z]([a-z\\-\\d]*[a-z\\d]+)?)*$",[{parts,
                                                                                                                                                                                                                                                                                                                2}]))), 
    <<"*.0">> = iolist_to_binary(join(re:split("*.0","^\\*\\.[a-z]([a-z\\-\\d]*[a-z\\d]+)?(\\.[a-z]([a-z\\-\\d]*[a-z\\d]+)?)*$",[]))), 
    <<"*.a-">> = iolist_to_binary(join(re:split("*.a-","^\\*\\.[a-z]([a-z\\-\\d]*[a-z\\d]+)?(\\.[a-z]([a-z\\-\\d]*[a-z\\d]+)?)*$",[trim]))), 
    <<"*.a-">> = iolist_to_binary(join(re:split("*.a-","^\\*\\.[a-z]([a-z\\-\\d]*[a-z\\d]+)?(\\.[a-z]([a-z\\-\\d]*[a-z\\d]+)?)*$",[{parts,
                                                                                                                                                                                                                                                                                                                  2}]))), 
    <<"*.a-">> = iolist_to_binary(join(re:split("*.a-","^\\*\\.[a-z]([a-z\\-\\d]*[a-z\\d]+)?(\\.[a-z]([a-z\\-\\d]*[a-z\\d]+)?)*$",[]))), 
    <<"*.a-b.c-">> = iolist_to_binary(join(re:split("*.a-b.c-","^\\*\\.[a-z]([a-z\\-\\d]*[a-z\\d]+)?(\\.[a-z]([a-z\\-\\d]*[a-z\\d]+)?)*$",[trim]))), 
    <<"*.a-b.c-">> = iolist_to_binary(join(re:split("*.a-b.c-","^\\*\\.[a-z]([a-z\\-\\d]*[a-z\\d]+)?(\\.[a-z]([a-z\\-\\d]*[a-z\\d]+)?)*$",[{parts,
                                                                                                                                                                                                                                                                                                                          2}]))), 
    <<"*.a-b.c-">> = iolist_to_binary(join(re:split("*.a-b.c-","^\\*\\.[a-z]([a-z\\-\\d]*[a-z\\d]+)?(\\.[a-z]([a-z\\-\\d]*[a-z\\d]+)?)*$",[]))), 
    <<"*.c-a.0-c">> = iolist_to_binary(join(re:split("*.c-a.0-c","^\\*\\.[a-z]([a-z\\-\\d]*[a-z\\d]+)?(\\.[a-z]([a-z\\-\\d]*[a-z\\d]+)?)*$",[trim]))), 
    <<"*.c-a.0-c">> = iolist_to_binary(join(re:split("*.c-a.0-c","^\\*\\.[a-z]([a-z\\-\\d]*[a-z\\d]+)?(\\.[a-z]([a-z\\-\\d]*[a-z\\d]+)?)*$",[{parts,
                                                                                                                                                                                                                                                                                                                            2}]))), 
    <<"*.c-a.0-c">> = iolist_to_binary(join(re:split("*.c-a.0-c","^\\*\\.[a-z]([a-z\\-\\d]*[a-z\\d]+)?(\\.[a-z]([a-z\\-\\d]*[a-z\\d]+)?)*$",[]))), 
    <<":de:abd:e">> = iolist_to_binary(join(re:split("abde","^(?=ab(de))(abd)(e)",[trim]))), 
    <<":de:abd:e:">> = iolist_to_binary(join(re:split("abde","^(?=ab(de))(abd)(e)",[{parts,
                                                                                                                                                                                              2}]))), 
    <<":de:abd:e:">> = iolist_to_binary(join(re:split("abde","^(?=ab(de))(abd)(e)",[]))), 
    <<"::abd:f">> = iolist_to_binary(join(re:split("abdf","^(?!(ab)de|x)(abd)(f)",[trim]))), 
    <<"::abd:f:">> = iolist_to_binary(join(re:split("abdf","^(?!(ab)de|x)(abd)(f)",[{parts,
                                                                                                                                                                                                  2}]))), 
    <<"::abd:f:">> = iolist_to_binary(join(re:split("abdf","^(?!(ab)de|x)(abd)(f)",[]))), 
    <<":abcd:cd:ab:cd">> = iolist_to_binary(join(re:split("abcd","^(?=(ab(cd)))(ab)",[trim]))), 
    <<":abcd:cd:ab:cd">> = iolist_to_binary(join(re:split("abcd","^(?=(ab(cd)))(ab)",[{parts,
                                                                                                                                                                                          2}]))), 
    <<":abcd:cd:ab:cd">> = iolist_to_binary(join(re:split("abcd","^(?=(ab(cd)))(ab)",[]))), 
    <<":.d">> = iolist_to_binary(join(re:split("a.b.c.d","^[\\da-f](\\.[\\da-f])*$",[caseless,
                                                                                                                                                                                                                trim]))), 
    <<":.d:">> = iolist_to_binary(join(re:split("a.b.c.d","^[\\da-f](\\.[\\da-f])*$",[caseless,
                                                                                                                                                                                                                  {parts,
                                                                                                                                                                                                                   2}]))), 
    <<":.d:">> = iolist_to_binary(join(re:split("a.b.c.d","^[\\da-f](\\.[\\da-f])*$",[caseless]))), 
    <<":.D">> = iolist_to_binary(join(re:split("A.B.C.D","^[\\da-f](\\.[\\da-f])*$",[caseless,
                                                                                                                                                                                                                trim]))), 
    <<":.D:">> = iolist_to_binary(join(re:split("A.B.C.D","^[\\da-f](\\.[\\da-f])*$",[caseless,
                                                                                                                                                                                                                  {parts,
                                                                                                                                                                                                                   2}]))), 
    <<":.D:">> = iolist_to_binary(join(re:split("A.B.C.D","^[\\da-f](\\.[\\da-f])*$",[caseless]))), 
    <<":.C">> = iolist_to_binary(join(re:split("a.b.c.1.2.3.C","^[\\da-f](\\.[\\da-f])*$",[caseless,
                                                                                                                                                                                                                            trim]))), 
    <<":.C:">> = iolist_to_binary(join(re:split("a.b.c.1.2.3.C","^[\\da-f](\\.[\\da-f])*$",[caseless,
                                                                                                                                                                                                                              {parts,
                                                                                                                                                                                                                               2}]))), 
    <<":.C:">> = iolist_to_binary(join(re:split("a.b.c.1.2.3.C","^[\\da-f](\\.[\\da-f])*$",[caseless]))), 
    <<"">> = iolist_to_binary(join(re:split("\"1234\"","^\\\".*\\\"\\s*(;.*)?$",[trim]))), 
    <<"::">> = iolist_to_binary(join(re:split("\"1234\"","^\\\".*\\\"\\s*(;.*)?$",[{parts,
                                                                                                                                                                                                                      2}]))), 
    <<"::">> = iolist_to_binary(join(re:split("\"1234\"","^\\\".*\\\"\\s*(;.*)?$",[]))), 
    <<":;">> = iolist_to_binary(join(re:split("\"abcd\" ;","^\\\".*\\\"\\s*(;.*)?$",[trim]))), 
    <<":;:">> = iolist_to_binary(join(re:split("\"abcd\" ;","^\\\".*\\\"\\s*(;.*)?$",[{parts,
                                                                                                                                                                                                                          2}]))), 
    <<":;:">> = iolist_to_binary(join(re:split("\"abcd\" ;","^\\\".*\\\"\\s*(;.*)?$",[]))), 
    <<":; rhubarb">> = iolist_to_binary(join(re:split("\"\" ; rhubarb","^\\\".*\\\"\\s*(;.*)?$",[trim]))), 
    <<":; rhubarb:">> = iolist_to_binary(join(re:split("\"\" ; rhubarb","^\\\".*\\\"\\s*(;.*)?$",[{parts,
                                                                                                                                                                                                                                  2}]))), 
    <<":; rhubarb:">> = iolist_to_binary(join(re:split("\"\" ; rhubarb","^\\\".*\\\"\\s*(;.*)?$",[]))), 
    <<"*** Failers">> = iolist_to_binary(join(re:split("*** Failers","^\\\".*\\\"\\s*(;.*)?$",[trim]))), 
    <<"*** Failers">> = iolist_to_binary(join(re:split("*** Failers","^\\\".*\\\"\\s*(;.*)?$",[{parts,
                                                                                                                                                                                                                        2}]))), 
    <<"*** Failers">> = iolist_to_binary(join(re:split("*** Failers","^\\\".*\\\"\\s*(;.*)?$",[]))), 
    <<"\"1234\" : things">> = iolist_to_binary(join(re:split("\"1234\" : things","^\\\".*\\\"\\s*(;.*)?$",[trim]))), 
    <<"\"1234\" : things">> = iolist_to_binary(join(re:split("\"1234\" : things","^\\\".*\\\"\\s*(;.*)?$",[{parts,
                                                                                                                                                                                                                                        2}]))), 
    <<"\"1234\" : things">> = iolist_to_binary(join(re:split("\"1234\" : things","^\\\".*\\\"\\s*(;.*)?$",[]))), 
    <<"">> = iolist_to_binary(join(re:split("","^$",[trim]))), 
    <<"">> = iolist_to_binary(join(re:split("","^$",[{parts,
                                                                                                                                                     2}]))), 
    <<"">> = iolist_to_binary(join(re:split("","^$",[]))), 
    <<"*** Failers">> = iolist_to_binary(join(re:split("*** Failers","^$",[trim]))), 
    <<"*** Failers">> = iolist_to_binary(join(re:split("*** Failers","^$",[{parts,
                                                                                                                                                                           2}]))), 
    <<"*** Failers">> = iolist_to_binary(join(re:split("*** Failers","^$",[]))), 
    <<"">> = iolist_to_binary(join(re:split("ab c","   ^    a   (?# begins with a)  b\\sc (?# then b c) $ (?# then end)",[extended,
                                                                                                                                                                                                                                                                                              trim]))), 
    <<":">> = iolist_to_binary(join(re:split("ab c","   ^    a   (?# begins with a)  b\\sc (?# then b c) $ (?# then end)",[extended,
                                                                                                                                                                                                                                                                                                {parts,
                                                                                                                                                                                                                                                                                                 2}]))), 
    <<":">> = iolist_to_binary(join(re:split("ab c","   ^    a   (?# begins with a)  b\\sc (?# then b c) $ (?# then end)",[extended]))), 
    <<"*** Failers">> = iolist_to_binary(join(re:split("*** Failers","   ^    a   (?# begins with a)  b\\sc (?# then b c) $ (?# then end)",[extended,
                                                                                                                                                                                                                                                                                                            trim]))), 
    <<"*** Failers">> = iolist_to_binary(join(re:split("*** Failers","   ^    a   (?# begins with a)  b\\sc (?# then b c) $ (?# then end)",[extended,
                                                                                                                                                                                                                                                                                                              {parts,
                                                                                                                                                                                                                                                                                                               2}]))), 
    <<"*** Failers">> = iolist_to_binary(join(re:split("*** Failers","   ^    a   (?# begins with a)  b\\sc (?# then b c) $ (?# then end)",[extended]))), 
    <<"abc">> = iolist_to_binary(join(re:split("abc","   ^    a   (?# begins with a)  b\\sc (?# then b c) $ (?# then end)",[extended,
                                                                                                                                                                                                                                                                                            trim]))), 
    <<"abc">> = iolist_to_binary(join(re:split("abc","   ^    a   (?# begins with a)  b\\sc (?# then b c) $ (?# then end)",[extended,
                                                                                                                                                                                                                                                                                              {parts,
                                                                                                                                                                                                                                                                                               2}]))), 
    <<"abc">> = iolist_to_binary(join(re:split("abc","   ^    a   (?# begins with a)  b\\sc (?# then b c) $ (?# then end)",[extended]))), 
    <<"ab cde">> = iolist_to_binary(join(re:split("ab cde","   ^    a   (?# begins with a)  b\\sc (?# then b c) $ (?# then end)",[extended,
                                                                                                                                                                                                                                                                                                  trim]))), 
    <<"ab cde">> = iolist_to_binary(join(re:split("ab cde","   ^    a   (?# begins with a)  b\\sc (?# then b c) $ (?# then end)",[extended,
                                                                                                                                                                                                                                                                                                    {parts,
                                                                                                                                                                                                                                                                                                     2}]))), 
    <<"ab cde">> = iolist_to_binary(join(re:split("ab cde","   ^    a   (?# begins with a)  b\\sc (?# then b c) $ (?# then end)",[extended]))), 
    <<"">> = iolist_to_binary(join(re:split("ab c","(?x)   ^    a   (?# begins with a)  b\\sc (?# then b c) $ (?# then end)",[trim]))), 
    <<":">> = iolist_to_binary(join(re:split("ab c","(?x)   ^    a   (?# begins with a)  b\\sc (?# then b c) $ (?# then end)",[{parts,
                                                                                                                                                                                                                                                                                                        2}]))), 
    <<":">> = iolist_to_binary(join(re:split("ab c","(?x)   ^    a   (?# begins with a)  b\\sc (?# then b c) $ (?# then end)",[]))), 
    <<"*** Failers">> = iolist_to_binary(join(re:split("*** Failers","(?x)   ^    a   (?# begins with a)  b\\sc (?# then b c) $ (?# then end)",[trim]))), 
    <<"*** Failers">> = iolist_to_binary(join(re:split("*** Failers","(?x)   ^    a   (?# begins with a)  b\\sc (?# then b c) $ (?# then end)",[{parts,
                                                                                                                                                                                                                                                                                                                      2}]))), 
    <<"*** Failers">> = iolist_to_binary(join(re:split("*** Failers","(?x)   ^    a   (?# begins with a)  b\\sc (?# then b c) $ (?# then end)",[]))), 
    <<"abc">> = iolist_to_binary(join(re:split("abc","(?x)   ^    a   (?# begins with a)  b\\sc (?# then b c) $ (?# then end)",[trim]))), 
    <<"abc">> = iolist_to_binary(join(re:split("abc","(?x)   ^    a   (?# begins with a)  b\\sc (?# then b c) $ (?# then end)",[{parts,
                                                                                                                                                                                                                                                                                                      2}]))), 
    <<"abc">> = iolist_to_binary(join(re:split("abc","(?x)   ^    a   (?# begins with a)  b\\sc (?# then b c) $ (?# then end)",[]))), 
    <<"ab cde">> = iolist_to_binary(join(re:split("ab cde","(?x)   ^    a   (?# begins with a)  b\\sc (?# then b c) $ (?# then end)",[trim]))), 
    <<"ab cde">> = iolist_to_binary(join(re:split("ab cde","(?x)   ^    a   (?# begins with a)  b\\sc (?# then b c) $ (?# then end)",[{parts,
                                                                                                                                                                                                                                                                                                            2}]))), 
    <<"ab cde">> = iolist_to_binary(join(re:split("ab cde","(?x)   ^    a   (?# begins with a)  b\\sc (?# then b c) $ (?# then end)",[]))), 
    <<"">> = iolist_to_binary(join(re:split("a bcd","^   a\\ b[c ]d       $",[extended,
                                                                                                                                                                                                      trim]))), 
    <<":">> = iolist_to_binary(join(re:split("a bcd","^   a\\ b[c ]d       $",[extended,
                                                                                                                                                                                                        {parts,
                                                                                                                                                                                                         2}]))), 
    <<":">> = iolist_to_binary(join(re:split("a bcd","^   a\\ b[c ]d       $",[extended]))), 
    <<"">> = iolist_to_binary(join(re:split("a b d","^   a\\ b[c ]d       $",[extended,
                                                                                                                                                                                                      trim]))), 
    <<":">> = iolist_to_binary(join(re:split("a b d","^   a\\ b[c ]d       $",[extended,
                                                                                                                                                                                                        {parts,
                                                                                                                                                                                                         2}]))), 
    <<":">> = iolist_to_binary(join(re:split("a b d","^   a\\ b[c ]d       $",[extended]))), 
    <<"*** Failers">> = iolist_to_binary(join(re:split("*** Failers","^   a\\ b[c ]d       $",[extended,
                                                                                                                                                                                                                  trim]))), 
    <<"*** Failers">> = iolist_to_binary(join(re:split("*** Failers","^   a\\ b[c ]d       $",[extended,
                                                                                                                                                                                                                    {parts,
                                                                                                                                                                                                                     2}]))), 
    <<"*** Failers">> = iolist_to_binary(join(re:split("*** Failers","^   a\\ b[c ]d       $",[extended]))), 
    <<"abcd">> = iolist_to_binary(join(re:split("abcd","^   a\\ b[c ]d       $",[extended,
                                                                                                                                                                                                    trim]))), 
    <<"abcd">> = iolist_to_binary(join(re:split("abcd","^   a\\ b[c ]d       $",[extended,
                                                                                                                                                                                                      {parts,
                                                                                                                                                                                                       2}]))), 
    <<"abcd">> = iolist_to_binary(join(re:split("abcd","^   a\\ b[c ]d       $",[extended]))), 
    <<"ab d">> = iolist_to_binary(join(re:split("ab d","^   a\\ b[c ]d       $",[extended,
                                                                                                                                                                                                    trim]))), 
    <<"ab d">> = iolist_to_binary(join(re:split("ab d","^   a\\ b[c ]d       $",[extended,
                                                                                                                                                                                                      {parts,
                                                                                                                                                                                                       2}]))), 
    <<"ab d">> = iolist_to_binary(join(re:split("ab d","^   a\\ b[c ]d       $",[extended]))), 
    <<":abc:bc:c:def:ef:f:hij:ij:j:klm:lm:m">> = iolist_to_binary(join(re:split("abcdefhijklm","^(a(b(c)))(d(e(f)))(h(i(j)))(k(l(m)))$",[trim]))), 
    <<":abc:bc:c:def:ef:f:hij:ij:j:klm:lm:m:">> = iolist_to_binary(join(re:split("abcdefhijklm","^(a(b(c)))(d(e(f)))(h(i(j)))(k(l(m)))$",[{parts,
                                                                                                                                                                                                                                                     2}]))), 
    <<":abc:bc:c:def:ef:f:hij:ij:j:klm:lm:m:">> = iolist_to_binary(join(re:split("abcdefhijklm","^(a(b(c)))(d(e(f)))(h(i(j)))(k(l(m)))$",[]))), 
    ok.
run2() ->
    <<":bc:c:ef:f:ij:j:lm:m">> = iolist_to_binary(join(re:split("abcdefhijklm","^(?:a(b(c)))(?:d(e(f)))(?:h(i(j)))(?:k(l(m)))$",[trim]))), 
    <<":bc:c:ef:f:ij:j:lm:m:">> = iolist_to_binary(join(re:split("abcdefhijklm","^(?:a(b(c)))(?:d(e(f)))(?:h(i(j)))(?:k(l(m)))$",[{parts,
                                                                                                                                                                                                                                                                     2}]))), 
    <<":bc:c:ef:f:ij:j:lm:m:">> = iolist_to_binary(join(re:split("abcdefhijklm","^(?:a(b(c)))(?:d(e(f)))(?:h(i(j)))(?:k(l(m)))$",[]))), 
    <<"">> = iolist_to_binary(join(re:split("a+ Z0+
","^[\\w][\\W][\\s][\\S][\\d][\\D][\\b][\\n][\\c]][\\022]",[trim]))), 
    <<":">> = iolist_to_binary(join(re:split("a+ Z0+
","^[\\w][\\W][\\s][\\S][\\d][\\D][\\b][\\n][\\c]][\\022]",[{parts,
                                                                                      2}]))), 
    <<":">> = iolist_to_binary(join(re:split("a+ Z0+
","^[\\w][\\W][\\s][\\S][\\d][\\D][\\b][\\n][\\c]][\\022]",[]))), 
    <<"">> = iolist_to_binary(join(re:split(".^$(*+)|{?,?}","^[.^$|()*+?{,}]+",[trim]))), 
    <<":">> = iolist_to_binary(join(re:split(".^$(*+)|{?,?}","^[.^$|()*+?{,}]+",[{parts,
                                                                                                                                                                                                             2}]))), 
    <<":">> = iolist_to_binary(join(re:split(".^$(*+)|{?,?}","^[.^$|()*+?{,}]+",[]))), 
    <<"">> = iolist_to_binary(join(re:split("z","^a*\\w",[trim]))), 
    <<":">> = iolist_to_binary(join(re:split("z","^a*\\w",[{parts,
                                                                                                                                                               2}]))), 
    <<":">> = iolist_to_binary(join(re:split("z","^a*\\w",[]))), 
    <<"">> = iolist_to_binary(join(re:split("az","^a*\\w",[trim]))), 
    <<":">> = iolist_to_binary(join(re:split("az","^a*\\w",[{parts,
                                                                                                                                                                 2}]))), 
    <<":">> = iolist_to_binary(join(re:split("az","^a*\\w",[]))), 
    <<"">> = iolist_to_binary(join(re:split("aaaz","^a*\\w",[trim]))), 
    <<":">> = iolist_to_binary(join(re:split("aaaz","^a*\\w",[{parts,
                                                                                                                                                                     2}]))), 
    <<":">> = iolist_to_binary(join(re:split("aaaz","^a*\\w",[]))), 
    <<"">> = iolist_to_binary(join(re:split("a","^a*\\w",[trim]))), 
    <<":">> = iolist_to_binary(join(re:split("a","^a*\\w",[{parts,
                                                                                                                                                               2}]))), 
    <<":">> = iolist_to_binary(join(re:split("a","^a*\\w",[]))), 
    <<"">> = iolist_to_binary(join(re:split("aa","^a*\\w",[trim]))), 
    <<":">> = iolist_to_binary(join(re:split("aa","^a*\\w",[{parts,
                                                                                                                                                                 2}]))), 
    <<":">> = iolist_to_binary(join(re:split("aa","^a*\\w",[]))), 
    <<"">> = iolist_to_binary(join(re:split("aaaa","^a*\\w",[trim]))), 
    <<":">> = iolist_to_binary(join(re:split("aaaa","^a*\\w",[{parts,
                                                                                                                                                                     2}]))), 
    <<":">> = iolist_to_binary(join(re:split("aaaa","^a*\\w",[]))), 
    <<":+">> = iolist_to_binary(join(re:split("a+","^a*\\w",[trim]))), 
    <<":+">> = iolist_to_binary(join(re:split("a+","^a*\\w",[{parts,
                                                                                                                                                                 2}]))), 
    <<":+">> = iolist_to_binary(join(re:split("a+","^a*\\w",[]))), 
    <<":+">> = iolist_to_binary(join(re:split("aa+","^a*\\w",[trim]))), 
    <<":+">> = iolist_to_binary(join(re:split("aa+","^a*\\w",[{parts,
                                                                                                                                                                   2}]))), 
    <<":+">> = iolist_to_binary(join(re:split("aa+","^a*\\w",[]))), 
    <<"">> = iolist_to_binary(join(re:split("z","^a*?\\w",[trim]))), 
    <<":">> = iolist_to_binary(join(re:split("z","^a*?\\w",[{parts,
                                                                                                                                                                 2}]))), 
    <<":">> = iolist_to_binary(join(re:split("z","^a*?\\w",[]))), 
    <<":z">> = iolist_to_binary(join(re:split("az","^a*?\\w",[trim]))), 
    <<":z">> = iolist_to_binary(join(re:split("az","^a*?\\w",[{parts,
                                                                                                                                                                   2}]))), 
    <<":z">> = iolist_to_binary(join(re:split("az","^a*?\\w",[]))), 
    <<":aaz">> = iolist_to_binary(join(re:split("aaaz","^a*?\\w",[trim]))), 
    <<":aaz">> = iolist_to_binary(join(re:split("aaaz","^a*?\\w",[{parts,
                                                                                                                                                                       2}]))), 
    <<":aaz">> = iolist_to_binary(join(re:split("aaaz","^a*?\\w",[]))), 
    <<"">> = iolist_to_binary(join(re:split("a","^a*?\\w",[trim]))), 
    <<":">> = iolist_to_binary(join(re:split("a","^a*?\\w",[{parts,
                                                                                                                                                                 2}]))), 
    <<":">> = iolist_to_binary(join(re:split("a","^a*?\\w",[]))), 
    <<":a">> = iolist_to_binary(join(re:split("aa","^a*?\\w",[trim]))), 
    <<":a">> = iolist_to_binary(join(re:split("aa","^a*?\\w",[{parts,
                                                                                                                                                                   2}]))), 
    <<":a">> = iolist_to_binary(join(re:split("aa","^a*?\\w",[]))), 
    <<":aaa">> = iolist_to_binary(join(re:split("aaaa","^a*?\\w",[trim]))), 
    <<":aaa">> = iolist_to_binary(join(re:split("aaaa","^a*?\\w",[{parts,
                                                                                                                                                                       2}]))), 
    <<":aaa">> = iolist_to_binary(join(re:split("aaaa","^a*?\\w",[]))), 
    <<":+">> = iolist_to_binary(join(re:split("a+","^a*?\\w",[trim]))), 
    <<":+">> = iolist_to_binary(join(re:split("a+","^a*?\\w",[{parts,
                                                                                                                                                                   2}]))), 
    <<":+">> = iolist_to_binary(join(re:split("a+","^a*?\\w",[]))), 
    <<":a+">> = iolist_to_binary(join(re:split("aa+","^a*?\\w",[trim]))), 
    <<":a+">> = iolist_to_binary(join(re:split("aa+","^a*?\\w",[{parts,
                                                                                                                                                                     2}]))), 
    <<":a+">> = iolist_to_binary(join(re:split("aa+","^a*?\\w",[]))), 
    <<"">> = iolist_to_binary(join(re:split("az","^a+\\w",[trim]))), 
    <<":">> = iolist_to_binary(join(re:split("az","^a+\\w",[{parts,
                                                                                                                                                                 2}]))), 
    <<":">> = iolist_to_binary(join(re:split("az","^a+\\w",[]))), 
    <<"">> = iolist_to_binary(join(re:split("aaaz","^a+\\w",[trim]))), 
    <<":">> = iolist_to_binary(join(re:split("aaaz","^a+\\w",[{parts,
                                                                                                                                                                     2}]))), 
    <<":">> = iolist_to_binary(join(re:split("aaaz","^a+\\w",[]))), 
    <<"">> = iolist_to_binary(join(re:split("aa","^a+\\w",[trim]))), 
    <<":">> = iolist_to_binary(join(re:split("aa","^a+\\w",[{parts,
                                                                                                                                                                 2}]))), 
    <<":">> = iolist_to_binary(join(re:split("aa","^a+\\w",[]))), 
    <<"">> = iolist_to_binary(join(re:split("aaaa","^a+\\w",[trim]))), 
    <<":">> = iolist_to_binary(join(re:split("aaaa","^a+\\w",[{parts,
                                                                                                                                                                     2}]))), 
    <<":">> = iolist_to_binary(join(re:split("aaaa","^a+\\w",[]))), 
    <<":+">> = iolist_to_binary(join(re:split("aa+","^a+\\w",[trim]))), 
    <<":+">> = iolist_to_binary(join(re:split("aa+","^a+\\w",[{parts,
                                                                                                                                                                   2}]))), 
    <<":+">> = iolist_to_binary(join(re:split("aa+","^a+\\w",[]))), 
    <<"">> = iolist_to_binary(join(re:split("az","^a+?\\w",[trim]))), 
    <<":">> = iolist_to_binary(join(re:split("az","^a+?\\w",[{parts,
                                                                                                                                                                   2}]))), 
    <<":">> = iolist_to_binary(join(re:split("az","^a+?\\w",[]))), 
    <<":az">> = iolist_to_binary(join(re:split("aaaz","^a+?\\w",[trim]))), 
    <<":az">> = iolist_to_binary(join(re:split("aaaz","^a+?\\w",[{parts,
                                                                                                                                                                       2}]))), 
    <<":az">> = iolist_to_binary(join(re:split("aaaz","^a+?\\w",[]))), 
    <<"">> = iolist_to_binary(join(re:split("aa","^a+?\\w",[trim]))), 
    <<":">> = iolist_to_binary(join(re:split("aa","^a+?\\w",[{parts,
                                                                                                                                                                   2}]))), 
    <<":">> = iolist_to_binary(join(re:split("aa","^a+?\\w",[]))), 
    <<":aa">> = iolist_to_binary(join(re:split("aaaa","^a+?\\w",[trim]))), 
    <<":aa">> = iolist_to_binary(join(re:split("aaaa","^a+?\\w",[{parts,
                                                                                                                                                                       2}]))), 
    <<":aa">> = iolist_to_binary(join(re:split("aaaa","^a+?\\w",[]))), 
    <<":+">> = iolist_to_binary(join(re:split("aa+","^a+?\\w",[trim]))), 
    <<":+">> = iolist_to_binary(join(re:split("aa+","^a+?\\w",[{parts,
                                                                                                                                                                     2}]))), 
    <<":+">> = iolist_to_binary(join(re:split("aa+","^a+?\\w",[]))), 
    <<"">> = iolist_to_binary(join(re:split("1234567890","^\\d{8}\\w{2,}",[trim]))), 
    <<":">> = iolist_to_binary(join(re:split("1234567890","^\\d{8}\\w{2,}",[{parts,
                                                                                                                                                                                                  2}]))), 
    <<":">> = iolist_to_binary(join(re:split("1234567890","^\\d{8}\\w{2,}",[]))), 
    <<"">> = iolist_to_binary(join(re:split("12345678ab","^\\d{8}\\w{2,}",[trim]))), 
    <<":">> = iolist_to_binary(join(re:split("12345678ab","^\\d{8}\\w{2,}",[{parts,
                                                                                                                                                                                                  2}]))), 
    <<":">> = iolist_to_binary(join(re:split("12345678ab","^\\d{8}\\w{2,}",[]))), 
    <<"">> = iolist_to_binary(join(re:split("12345678__","^\\d{8}\\w{2,}",[trim]))), 
    <<":">> = iolist_to_binary(join(re:split("12345678__","^\\d{8}\\w{2,}",[{parts,
                                                                                                                                                                                                  2}]))), 
    <<":">> = iolist_to_binary(join(re:split("12345678__","^\\d{8}\\w{2,}",[]))), 
    <<"*** Failers">> = iolist_to_binary(join(re:split("*** Failers","^\\d{8}\\w{2,}",[trim]))), 
    <<"*** Failers">> = iolist_to_binary(join(re:split("*** Failers","^\\d{8}\\w{2,}",[{parts,
                                                                                                                                                                                                    2}]))), 
    <<"*** Failers">> = iolist_to_binary(join(re:split("*** Failers","^\\d{8}\\w{2,}",[]))), 
    <<"1234567">> = iolist_to_binary(join(re:split("1234567","^\\d{8}\\w{2,}",[trim]))), 
    <<"1234567">> = iolist_to_binary(join(re:split("1234567","^\\d{8}\\w{2,}",[{parts,
                                                                                                                                                                                            2}]))), 
    <<"1234567">> = iolist_to_binary(join(re:split("1234567","^\\d{8}\\w{2,}",[]))), 
    <<"">> = iolist_to_binary(join(re:split("uoie","^[aeiou\\d]{4,5}$",[trim]))), 
    <<":">> = iolist_to_binary(join(re:split("uoie","^[aeiou\\d]{4,5}$",[{parts,
                                                                                                                                                                                            2}]))), 
    <<":">> = iolist_to_binary(join(re:split("uoie","^[aeiou\\d]{4,5}$",[]))), 
    <<"">> = iolist_to_binary(join(re:split("1234","^[aeiou\\d]{4,5}$",[trim]))), 
    <<":">> = iolist_to_binary(join(re:split("1234","^[aeiou\\d]{4,5}$",[{parts,
                                                                                                                                                                                            2}]))), 
    <<":">> = iolist_to_binary(join(re:split("1234","^[aeiou\\d]{4,5}$",[]))), 
    <<"">> = iolist_to_binary(join(re:split("12345","^[aeiou\\d]{4,5}$",[trim]))), 
    <<":">> = iolist_to_binary(join(re:split("12345","^[aeiou\\d]{4,5}$",[{parts,
                                                                                                                                                                                              2}]))), 
    <<":">> = iolist_to_binary(join(re:split("12345","^[aeiou\\d]{4,5}$",[]))), 
    <<"">> = iolist_to_binary(join(re:split("aaaaa","^[aeiou\\d]{4,5}$",[trim]))), 
    <<":">> = iolist_to_binary(join(re:split("aaaaa","^[aeiou\\d]{4,5}$",[{parts,
                                                                                                                                                                                              2}]))), 
    <<":">> = iolist_to_binary(join(re:split("aaaaa","^[aeiou\\d]{4,5}$",[]))), 
    <<"*** Failers">> = iolist_to_binary(join(re:split("*** Failers","^[aeiou\\d]{4,5}$",[trim]))), 
    <<"*** Failers">> = iolist_to_binary(join(re:split("*** Failers","^[aeiou\\d]{4,5}$",[{parts,
                                                                                                                                                                                                          2}]))), 
    <<"*** Failers">> = iolist_to_binary(join(re:split("*** Failers","^[aeiou\\d]{4,5}$",[]))), 
    <<"123456">> = iolist_to_binary(join(re:split("123456","^[aeiou\\d]{4,5}$",[trim]))), 
    <<"123456">> = iolist_to_binary(join(re:split("123456","^[aeiou\\d]{4,5}$",[{parts,
                                                                                                                                                                                                2}]))), 
    <<"123456">> = iolist_to_binary(join(re:split("123456","^[aeiou\\d]{4,5}$",[]))), 
    <<"">> = iolist_to_binary(join(re:split("uoie","^[aeiou\\d]{4,5}?",[trim]))), 
    <<":">> = iolist_to_binary(join(re:split("uoie","^[aeiou\\d]{4,5}?",[{parts,
                                                                                                                                                                                           2}]))), 
    <<":">> = iolist_to_binary(join(re:split("uoie","^[aeiou\\d]{4,5}?",[]))), 
    <<"">> = iolist_to_binary(join(re:split("1234","^[aeiou\\d]{4,5}?",[trim]))), 
    <<":">> = iolist_to_binary(join(re:split("1234","^[aeiou\\d]{4,5}?",[{parts,
                                                                                                                                                                                           2}]))), 
    <<":">> = iolist_to_binary(join(re:split("1234","^[aeiou\\d]{4,5}?",[]))), 
    <<":5">> = iolist_to_binary(join(re:split("12345","^[aeiou\\d]{4,5}?",[trim]))), 
    <<":5">> = iolist_to_binary(join(re:split("12345","^[aeiou\\d]{4,5}?",[{parts,
                                                                                                                                                                                             2}]))), 
    <<":5">> = iolist_to_binary(join(re:split("12345","^[aeiou\\d]{4,5}?",[]))), 
    <<":a">> = iolist_to_binary(join(re:split("aaaaa","^[aeiou\\d]{4,5}?",[trim]))), 
    <<":a">> = iolist_to_binary(join(re:split("aaaaa","^[aeiou\\d]{4,5}?",[{parts,
                                                                                                                                                                                             2}]))), 
    <<":a">> = iolist_to_binary(join(re:split("aaaaa","^[aeiou\\d]{4,5}?",[]))), 
    <<":56">> = iolist_to_binary(join(re:split("123456","^[aeiou\\d]{4,5}?",[trim]))), 
    <<":56">> = iolist_to_binary(join(re:split("123456","^[aeiou\\d]{4,5}?",[{parts,
                                                                                                                                                                                               2}]))), 
    <<":56">> = iolist_to_binary(join(re:split("123456","^[aeiou\\d]{4,5}?",[]))), 
    <<":abc:abc">> = iolist_to_binary(join(re:split("abc=abcabc","\\A(abc|def)=(\\1){2,3}\\Z",[trim]))), 
    <<":abc:abc:">> = iolist_to_binary(join(re:split("abc=abcabc","\\A(abc|def)=(\\1){2,3}\\Z",[{parts,
                                                                                                                                                                                                                           2}]))), 
    <<":abc:abc:">> = iolist_to_binary(join(re:split("abc=abcabc","\\A(abc|def)=(\\1){2,3}\\Z",[]))), 
    <<":def:def">> = iolist_to_binary(join(re:split("def=defdefdef","\\A(abc|def)=(\\1){2,3}\\Z",[trim]))), 
    <<":def:def:">> = iolist_to_binary(join(re:split("def=defdefdef","\\A(abc|def)=(\\1){2,3}\\Z",[{parts,
                                                                                                                                                                                                                                 2}]))), 
    <<":def:def:">> = iolist_to_binary(join(re:split("def=defdefdef","\\A(abc|def)=(\\1){2,3}\\Z",[]))), 
    <<"*** Failers">> = iolist_to_binary(join(re:split("*** Failers","\\A(abc|def)=(\\1){2,3}\\Z",[trim]))), 
    <<"*** Failers">> = iolist_to_binary(join(re:split("*** Failers","\\A(abc|def)=(\\1){2,3}\\Z",[{parts,
                                                                                                                                                                                                                             2}]))), 
    <<"*** Failers">> = iolist_to_binary(join(re:split("*** Failers","\\A(abc|def)=(\\1){2,3}\\Z",[]))), 
    <<"abc=defdef">> = iolist_to_binary(join(re:split("abc=defdef","\\A(abc|def)=(\\1){2,3}\\Z",[trim]))), 
    <<"abc=defdef">> = iolist_to_binary(join(re:split("abc=defdef","\\A(abc|def)=(\\1){2,3}\\Z",[{parts,
                                                                                                                                                                                                                           2}]))), 
    <<"abc=defdef">> = iolist_to_binary(join(re:split("abc=defdef","\\A(abc|def)=(\\1){2,3}\\Z",[]))), 
    <<":a:b:c:d:e:f:g:h:i:j:k:cd">> = iolist_to_binary(join(re:split("abcdefghijkcda2","^(a)(b)(c)(d)(e)(f)(g)(h)(i)(j)(k)\\11*(\\3\\4)\\1(?#)2$",[trim]))), 
    <<":a:b:c:d:e:f:g:h:i:j:k:cd:">> = iolist_to_binary(join(re:split("abcdefghijkcda2","^(a)(b)(c)(d)(e)(f)(g)(h)(i)(j)(k)\\11*(\\3\\4)\\1(?#)2$",[{parts,
                                                                                                                                                                                                                                                                                                   2}]))), 
    <<":a:b:c:d:e:f:g:h:i:j:k:cd:">> = iolist_to_binary(join(re:split("abcdefghijkcda2","^(a)(b)(c)(d)(e)(f)(g)(h)(i)(j)(k)\\11*(\\3\\4)\\1(?#)2$",[]))), 
    <<":a:b:c:d:e:f:g:h:i:j:k:cd">> = iolist_to_binary(join(re:split("abcdefghijkkkkcda2","^(a)(b)(c)(d)(e)(f)(g)(h)(i)(j)(k)\\11*(\\3\\4)\\1(?#)2$",[trim]))), 
    <<":a:b:c:d:e:f:g:h:i:j:k:cd:">> = iolist_to_binary(join(re:split("abcdefghijkkkkcda2","^(a)(b)(c)(d)(e)(f)(g)(h)(i)(j)(k)\\11*(\\3\\4)\\1(?#)2$",[{parts,
                                                                                                                                                                                                                                                                                                         2}]))), 
    <<":a:b:c:d:e:f:g:h:i:j:k:cd:">> = iolist_to_binary(join(re:split("abcdefghijkkkkcda2","^(a)(b)(c)(d)(e)(f)(g)(h)(i)(j)(k)\\11*(\\3\\4)\\1(?#)2$",[]))), 
    <<":cataract:aract:ract::3">> = iolist_to_binary(join(re:split("cataract cataract23","(cat(a(ract|tonic)|erpillar)) \\1()2(3)",[trim]))), 
    <<":cataract:aract:ract::3:">> = iolist_to_binary(join(re:split("cataract cataract23","(cat(a(ract|tonic)|erpillar)) \\1()2(3)",[{parts,
                                                                                                                                                                                                                                                                     2}]))), 
    <<":cataract:aract:ract::3:">> = iolist_to_binary(join(re:split("cataract cataract23","(cat(a(ract|tonic)|erpillar)) \\1()2(3)",[]))), 
    <<":catatonic:atonic:tonic::3">> = iolist_to_binary(join(re:split("catatonic catatonic23","(cat(a(ract|tonic)|erpillar)) \\1()2(3)",[trim]))), 
    <<":catatonic:atonic:tonic::3:">> = iolist_to_binary(join(re:split("catatonic catatonic23","(cat(a(ract|tonic)|erpillar)) \\1()2(3)",[{parts,
                                                                                                                                                                                                                                                                         2}]))), 
    <<":catatonic:atonic:tonic::3:">> = iolist_to_binary(join(re:split("catatonic catatonic23","(cat(a(ract|tonic)|erpillar)) \\1()2(3)",[]))), 
    <<":caterpillar:erpillar:::3">> = iolist_to_binary(join(re:split("caterpillar caterpillar23","(cat(a(ract|tonic)|erpillar)) \\1()2(3)",[trim]))), 
    <<":caterpillar:erpillar:::3:">> = iolist_to_binary(join(re:split("caterpillar caterpillar23","(cat(a(ract|tonic)|erpillar)) \\1()2(3)",[{parts,
                                                                                                                                                                                                                                                                                 2}]))), 
    <<":caterpillar:erpillar:::3:">> = iolist_to_binary(join(re:split("caterpillar caterpillar23","(cat(a(ract|tonic)|erpillar)) \\1()2(3)",[]))), 
    <<":abcd::02 1997">> = iolist_to_binary(join(re:split("From abcd  Mon Sep 01 12:33:02 1997","^From +([^ ]+) +[a-zA-Z][a-zA-Z][a-zA-Z] +[a-zA-Z][a-zA-Z][a-zA-Z] +[0-9]?[0-9] +[0-9][0-9]:[0-9][0-9]",[trim]))), 
    <<":abcd::02 1997">> = iolist_to_binary(join(re:split("From abcd  Mon Sep 01 12:33:02 1997","^From +([^ ]+) +[a-zA-Z][a-zA-Z][a-zA-Z] +[a-zA-Z][a-zA-Z][a-zA-Z] +[0-9]?[0-9] +[0-9][0-9]:[0-9][0-9]",[{parts,
                                                                                                                                                                                                                                                                                                                                                                                                                                  2}]))), 
    <<":abcd::02 1997">> = iolist_to_binary(join(re:split("From abcd  Mon Sep 01 12:33:02 1997","^From +([^ ]+) +[a-zA-Z][a-zA-Z][a-zA-Z] +[a-zA-Z][a-zA-Z][a-zA-Z] +[0-9]?[0-9] +[0-9][0-9]:[0-9][0-9]",[]))), 
    <<":Sep ::02 1997">> = iolist_to_binary(join(re:split("From abcd  Mon Sep 01 12:33:02 1997","^From\\s+\\S+\\s+([a-zA-Z]{3}\\s+){2}\\d{1,2}\\s+\\d\\d:\\d\\d",[trim]))), 
    <<":Sep ::02 1997">> = iolist_to_binary(join(re:split("From abcd  Mon Sep 01 12:33:02 1997","^From\\s+\\S+\\s+([a-zA-Z]{3}\\s+){2}\\d{1,2}\\s+\\d\\d:\\d\\d",[{parts,
                                                                                                                                                                                                                                                                                                                                                            2}]))), 
    <<":Sep ::02 1997">> = iolist_to_binary(join(re:split("From abcd  Mon Sep 01 12:33:02 1997","^From\\s+\\S+\\s+([a-zA-Z]{3}\\s+){2}\\d{1,2}\\s+\\d\\d:\\d\\d",[]))), 
    <<":Sep  ::02 1997">> = iolist_to_binary(join(re:split("From abcd  Mon Sep  1 12:33:02 1997","^From\\s+\\S+\\s+([a-zA-Z]{3}\\s+){2}\\d{1,2}\\s+\\d\\d:\\d\\d",[trim]))), 
    <<":Sep  ::02 1997">> = iolist_to_binary(join(re:split("From abcd  Mon Sep  1 12:33:02 1997","^From\\s+\\S+\\s+([a-zA-Z]{3}\\s+){2}\\d{1,2}\\s+\\d\\d:\\d\\d",[{parts,
                                                                                                                                                                                                                                                                                                                                                            2}]))), 
    <<":Sep  ::02 1997">> = iolist_to_binary(join(re:split("From abcd  Mon Sep  1 12:33:02 1997","^From\\s+\\S+\\s+([a-zA-Z]{3}\\s+){2}\\d{1,2}\\s+\\d\\d:\\d\\d",[]))), 
    <<"*** Failers">> = iolist_to_binary(join(re:split("*** Failers","^From\\s+\\S+\\s+([a-zA-Z]{3}\\s+){2}\\d{1,2}\\s+\\d\\d:\\d\\d",[trim]))), 
    <<"*** Failers">> = iolist_to_binary(join(re:split("*** Failers","^From\\s+\\S+\\s+([a-zA-Z]{3}\\s+){2}\\d{1,2}\\s+\\d\\d:\\d\\d",[{parts,
                                                                                                                                                                                                                                                                                                            2}]))), 
    <<"*** Failers">> = iolist_to_binary(join(re:split("*** Failers","^From\\s+\\S+\\s+([a-zA-Z]{3}\\s+){2}\\d{1,2}\\s+\\d\\d:\\d\\d",[]))), 
    <<"From abcd  Sep 01 12:33:02 1997">> = iolist_to_binary(join(re:split("From abcd  Sep 01 12:33:02 1997","^From\\s+\\S+\\s+([a-zA-Z]{3}\\s+){2}\\d{1,2}\\s+\\d\\d:\\d\\d",[trim]))), 
    <<"From abcd  Sep 01 12:33:02 1997">> = iolist_to_binary(join(re:split("From abcd  Sep 01 12:33:02 1997","^From\\s+\\S+\\s+([a-zA-Z]{3}\\s+){2}\\d{1,2}\\s+\\d\\d:\\d\\d",[{parts,
                                                                                                                                                                                                                                                                                                                                                    2}]))), 
    <<"From abcd  Sep 01 12:33:02 1997">> = iolist_to_binary(join(re:split("From abcd  Sep 01 12:33:02 1997","^From\\s+\\S+\\s+([a-zA-Z]{3}\\s+){2}\\d{1,2}\\s+\\d\\d:\\d\\d",[]))), 
    <<"">> = iolist_to_binary(join(re:split("12
34","^12.34",[dotall,trim]))), 
    <<":">> = iolist_to_binary(join(re:split("12
34","^12.34",[dotall,{parts,2}]))), 
    <<":">> = iolist_to_binary(join(re:split("12
34","^12.34",[dotall]))), 
    <<"">> = iolist_to_binary(join(re:split("12
34","^12.34",[dotall,
                                                                                                                                                                    trim]))), 
    <<":">> = iolist_to_binary(join(re:split("12
34","^12.34",[dotall,
                                                                                                                                                                      {parts,
                                                                                                                                                                       2}]))), 
    <<":">> = iolist_to_binary(join(re:split("12
34","^12.34",[dotall]))), 
    <<"the quick :	 fox">> = iolist_to_binary(join(re:split("the quick brown	 fox","\\w+(?=\\t)",[trim]))), 
    <<"the quick :	 fox">> = iolist_to_binary(join(re:split("the quick brown	 fox","\\w+(?=\\t)",[{parts,
                                                                                                                                                                                                                             2}]))), 
    <<"the quick :	 fox">> = iolist_to_binary(join(re:split("the quick brown	 fox","\\w+(?=\\t)",[]))), 
    <<"foobar is :lish see?">> = iolist_to_binary(join(re:split("foobar is foolish see?","foo(?!bar)(.*)",[trim]))), 
    <<"foobar is :lish see?:">> = iolist_to_binary(join(re:split("foobar is foolish see?","foo(?!bar)(.*)",[{parts,
                                                                                                                                                                                                                        2}]))), 
    <<"foobar is :lish see?:">> = iolist_to_binary(join(re:split("foobar is foolish see?","foo(?!bar)(.*)",[]))), 
    <<"foobar c: etc">> = iolist_to_binary(join(re:split("foobar crowbar etc","(?:(?!foo)...|^.{0,2})bar(.*)",[trim]))), 
    <<"foobar c: etc:">> = iolist_to_binary(join(re:split("foobar crowbar etc","(?:(?!foo)...|^.{0,2})bar(.*)",[{parts,
                                                                                                                                                                                                                                              2}]))), 
    <<"foobar c: etc:">> = iolist_to_binary(join(re:split("foobar crowbar etc","(?:(?!foo)...|^.{0,2})bar(.*)",[]))), 
    <<":rel">> = iolist_to_binary(join(re:split("barrel","(?:(?!foo)...|^.{0,2})bar(.*)",[trim]))), 
    <<":rel:">> = iolist_to_binary(join(re:split("barrel","(?:(?!foo)...|^.{0,2})bar(.*)",[{parts,
                                                                                                                                                                                                                      2}]))), 
    <<":rel:">> = iolist_to_binary(join(re:split("barrel","(?:(?!foo)...|^.{0,2})bar(.*)",[]))), 
    <<":rel">> = iolist_to_binary(join(re:split("2barrel","(?:(?!foo)...|^.{0,2})bar(.*)",[trim]))), 
    <<":rel:">> = iolist_to_binary(join(re:split("2barrel","(?:(?!foo)...|^.{0,2})bar(.*)",[{parts,
                                                                                                                                                                                                                        2}]))), 
    <<":rel:">> = iolist_to_binary(join(re:split("2barrel","(?:(?!foo)...|^.{0,2})bar(.*)",[]))), 
    <<":rel">> = iolist_to_binary(join(re:split("A barrel","(?:(?!foo)...|^.{0,2})bar(.*)",[trim]))), 
    <<":rel:">> = iolist_to_binary(join(re:split("A barrel","(?:(?!foo)...|^.{0,2})bar(.*)",[{parts,
                                                                                                                                                                                                                          2}]))), 
    <<":rel:">> = iolist_to_binary(join(re:split("A barrel","(?:(?!foo)...|^.{0,2})bar(.*)",[]))), 
    <<":abc:456">> = iolist_to_binary(join(re:split("abc456","^(\\D*)(?=\\d)(?!123)",[trim]))), 
    <<":abc:456">> = iolist_to_binary(join(re:split("abc456","^(\\D*)(?=\\d)(?!123)",[{parts,
                                                                                                                                                                                                        2}]))), 
    <<":abc:456">> = iolist_to_binary(join(re:split("abc456","^(\\D*)(?=\\d)(?!123)",[]))), 
    <<"*** Failers">> = iolist_to_binary(join(re:split("*** Failers","^(\\D*)(?=\\d)(?!123)",[trim]))), 
    <<"*** Failers">> = iolist_to_binary(join(re:split("*** Failers","^(\\D*)(?=\\d)(?!123)",[{parts,
                                                                                                                                                                                                                  2}]))), 
    <<"*** Failers">> = iolist_to_binary(join(re:split("*** Failers","^(\\D*)(?=\\d)(?!123)",[]))), 
    <<"abc123">> = iolist_to_binary(join(re:split("abc123","^(\\D*)(?=\\d)(?!123)",[trim]))), 
    <<"abc123">> = iolist_to_binary(join(re:split("abc123","^(\\D*)(?=\\d)(?!123)",[{parts,
                                                                                                                                                                                                        2}]))), 
    <<"abc123">> = iolist_to_binary(join(re:split("abc123","^(\\D*)(?=\\d)(?!123)",[]))), 
    ok.
run3() ->
    <<"">> = iolist_to_binary(join(re:split("1234","^1234(?# test newlines
  inside)",[trim]))), 
    <<":">> = iolist_to_binary(join(re:split("1234","^1234(?# test newlines
  inside)",[{parts,2}]))), 
    <<":">> = iolist_to_binary(join(re:split("1234","^1234(?# test newlines
  inside)",[]))), 
    <<"">> = iolist_to_binary(join(re:split("1234","^1234 #comment in extended re
  ",[extended,trim]))), 
    <<":">> = iolist_to_binary(join(re:split("1234","^1234 #comment in extended re
  ",[extended,{parts,2}]))), 
    <<":">> = iolist_to_binary(join(re:split("1234","^1234 #comment in extended re
  ",[extended]))), 
    <<"">> = iolist_to_binary(join(re:split("abcd","#rhubarb
  abcd",[extended,trim]))), 
    <<":">> = iolist_to_binary(join(re:split("abcd","#rhubarb
  abcd",[extended,{parts,2}]))), 
    <<":">> = iolist_to_binary(join(re:split("abcd","#rhubarb
  abcd",[extended]))), 
    <<"">> = iolist_to_binary(join(re:split("abcd","^abcd#rhubarb",[extended,
                                                                                                                                                                                trim]))), 
    <<":">> = iolist_to_binary(join(re:split("abcd","^abcd#rhubarb",[extended,
                                                                                                                                                                                  {parts,
                                                                                                                                                                                   2}]))), 
    <<":">> = iolist_to_binary(join(re:split("abcd","^abcd#rhubarb",[extended]))), 
    <<":a:b">> = iolist_to_binary(join(re:split("aaab","^(a)\\1{2,3}(.)",[trim]))), 
    <<":a:b:">> = iolist_to_binary(join(re:split("aaab","^(a)\\1{2,3}(.)",[{parts,
                                                                                                                                                                                       2}]))), 
    <<":a:b:">> = iolist_to_binary(join(re:split("aaab","^(a)\\1{2,3}(.)",[]))), 
    <<":a:b">> = iolist_to_binary(join(re:split("aaaab","^(a)\\1{2,3}(.)",[trim]))), 
    <<":a:b:">> = iolist_to_binary(join(re:split("aaaab","^(a)\\1{2,3}(.)",[{parts,
                                                                                                                                                                                         2}]))), 
    <<":a:b:">> = iolist_to_binary(join(re:split("aaaab","^(a)\\1{2,3}(.)",[]))), 
    <<":a:a:b">> = iolist_to_binary(join(re:split("aaaaab","^(a)\\1{2,3}(.)",[trim]))), 
    <<":a:a:b">> = iolist_to_binary(join(re:split("aaaaab","^(a)\\1{2,3}(.)",[{parts,
                                                                                                                                                                                           2}]))), 
    <<":a:a:b">> = iolist_to_binary(join(re:split("aaaaab","^(a)\\1{2,3}(.)",[]))), 
    <<":a:a:ab">> = iolist_to_binary(join(re:split("aaaaaab","^(a)\\1{2,3}(.)",[trim]))), 
    <<":a:a:ab">> = iolist_to_binary(join(re:split("aaaaaab","^(a)\\1{2,3}(.)",[{parts,
                                                                                                                                                                                             2}]))), 
    <<":a:a:ab">> = iolist_to_binary(join(re:split("aaaaaab","^(a)\\1{2,3}(.)",[]))), 
    <<"the ">> = iolist_to_binary(join(re:split("the abc","(?!^)abc",[trim]))), 
    <<"the :">> = iolist_to_binary(join(re:split("the abc","(?!^)abc",[{parts,
                                                                                                                                                                              2}]))), 
    <<"the :">> = iolist_to_binary(join(re:split("the abc","(?!^)abc",[]))), 
    <<"*** Failers">> = iolist_to_binary(join(re:split("*** Failers","(?!^)abc",[trim]))), 
    <<"*** Failers">> = iolist_to_binary(join(re:split("*** Failers","(?!^)abc",[{parts,
                                                                                                                                                                                      2}]))), 
    <<"*** Failers">> = iolist_to_binary(join(re:split("*** Failers","(?!^)abc",[]))), 
    <<"abc">> = iolist_to_binary(join(re:split("abc","(?!^)abc",[trim]))), 
    <<"abc">> = iolist_to_binary(join(re:split("abc","(?!^)abc",[{parts,
                                                                                                                                                                      2}]))), 
    <<"abc">> = iolist_to_binary(join(re:split("abc","(?!^)abc",[]))), 
    <<"">> = iolist_to_binary(join(re:split("abc","(?=^)abc",[trim]))), 
    <<":">> = iolist_to_binary(join(re:split("abc","(?=^)abc",[{parts,
                                                                                                                                                                      2}]))), 
    <<":">> = iolist_to_binary(join(re:split("abc","(?=^)abc",[]))), 
    <<"*** Failers">> = iolist_to_binary(join(re:split("*** Failers","(?=^)abc",[trim]))), 
    <<"*** Failers">> = iolist_to_binary(join(re:split("*** Failers","(?=^)abc",[{parts,
                                                                                                                                                                                      2}]))), 
    <<"*** Failers">> = iolist_to_binary(join(re:split("*** Failers","(?=^)abc",[]))), 
    <<"the abc">> = iolist_to_binary(join(re:split("the abc","(?=^)abc",[trim]))), 
    <<"the abc">> = iolist_to_binary(join(re:split("the abc","(?=^)abc",[{parts,
                                                                                                                                                                              2}]))), 
    <<"the abc">> = iolist_to_binary(join(re:split("the abc","(?=^)abc",[]))), 
    <<":b:bbb">> = iolist_to_binary(join(re:split("aabbbbb","^[ab]{1,3}(ab*|b)",[trim]))), 
    <<":b:bbb">> = iolist_to_binary(join(re:split("aabbbbb","^[ab]{1,3}(ab*|b)",[{parts,
                                                                                                                                                                                                2}]))), 
    <<":b:bbb">> = iolist_to_binary(join(re:split("aabbbbb","^[ab]{1,3}(ab*|b)",[]))), 
    <<":abbbbb">> = iolist_to_binary(join(re:split("aabbbbb","^[ab]{1,3}?(ab*|b)",[trim]))), 
    <<":abbbbb:">> = iolist_to_binary(join(re:split("aabbbbb","^[ab]{1,3}?(ab*|b)",[{parts,
                                                                                                                                                                                                  2}]))), 
    <<":abbbbb:">> = iolist_to_binary(join(re:split("aabbbbb","^[ab]{1,3}?(ab*|b)",[]))), 
    <<":a:bbbbb">> = iolist_to_binary(join(re:split("aabbbbb","^[ab]{1,3}?(ab*?|b)",[trim]))), 
    <<":a:bbbbb">> = iolist_to_binary(join(re:split("aabbbbb","^[ab]{1,3}?(ab*?|b)",[{parts,
                                                                                                                                                                                                    2}]))), 
    <<":a:bbbbb">> = iolist_to_binary(join(re:split("aabbbbb","^[ab]{1,3}?(ab*?|b)",[]))), 
    <<":b:bbb">> = iolist_to_binary(join(re:split("aabbbbb","^[ab]{1,3}(ab*?|b)",[trim]))), 
    <<":b:bbb">> = iolist_to_binary(join(re:split("aabbbbb","^[ab]{1,3}(ab*?|b)",[{parts,
                                                                                                                                                                                                  2}]))), 
    <<":b:bbb">> = iolist_to_binary(join(re:split("aabbbbb","^[ab]{1,3}(ab*?|b)",[]))), 
    <<"Alan Other <user.ain>">> = iolist_to_binary(join(re:split("Alan Other <user.ain>","  (?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*                          # optional leading comment
(?:    (?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|
\" (?:                      # opening quote...
[^\\\\\\x80-\\xff\\n\\015\"]                #   Anything except backslash and quote
|                     #    or
\\\\ [^\\x80-\\xff]           #   Escaped something (something != CR)
)* \"  # closing quote
)                    # initial word
(?:  (?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*  \\.  (?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*   (?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|
\" (?:                      # opening quote...
[^\\\\\\x80-\\xff\\n\\015\"]                #   Anything except backslash and quote
|                     #    or
\\\\ [^\\x80-\\xff]           #   Escaped something (something != CR)
)* \"  # closing quote
)  )* # further okay, if led by a period
(?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*  @  (?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*    (?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|   \\[                         # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*    #    stuff
\\]                        #           ]
)                           # initial subdomain
(?:                                  #
(?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*  \\.                        # if led by a period...
(?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*   (?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|   \\[                         # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*    #    stuff
\\]                        #           ]
)                     #   ...further okay
)*
# address
|                     #  or
(?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|
\" (?:                      # opening quote...
[^\\\\\\x80-\\xff\\n\\015\"]                #   Anything except backslash and quote
|                     #    or
\\\\ [^\\x80-\\xff]           #   Escaped something (something != CR)
)* \"  # closing quote
)             # one word, optionally followed by....
(?:
[^()<>@,;:\".\\\\\\[\\]\\x80-\\xff\\000-\\010\\012-\\037]  |  # atom and space parts, or...
\\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)       |  # comments, or...

\" (?:                      # opening quote...
[^\\\\\\x80-\\xff\\n\\015\"]                #   Anything except backslash and quote
|                     #    or
\\\\ [^\\x80-\\xff]           #   Escaped something (something != CR)
)* \"  # closing quote
# quoted strings
)*
<  (?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*                     # leading <
(?:  @  (?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*    (?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|   \\[                         # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*    #    stuff
\\]                        #           ]
)                           # initial subdomain
(?:                                  #
(?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*  \\.                        # if led by a period...
(?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*   (?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|   \\[                         # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*    #    stuff
\\]                        #           ]
)                     #   ...further okay
)*

(?:  (?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*  ,  (?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*  @  (?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*    (?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|   \\[                         # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*    #    stuff
\\]                        #           ]
)                           # initial subdomain
(?:                                  #
(?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*  \\.                        # if led by a period...
(?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*   (?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|   \\[                         # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*    #    stuff
\\]                        #           ]
)                     #   ...further okay
)*
)* # further okay, if led by comma
:                                # closing colon
(?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*  )? #       optional route
(?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|
\" (?:                      # opening quote...
[^\\\\\\x80-\\xff\\n\\015\"]                #   Anything except backslash and quote
|                     #    or
\\\\ [^\\x80-\\xff]           #   Escaped something (something != CR)
)* \"  # closing quote
)                    # initial word
(?:  (?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*  \\.  (?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*   (?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|
\" (?:                      # opening quote...
[^\\\\\\x80-\\xff\\n\\015\"]                #   Anything except backslash and quote
|                     #    or
\\\\ [^\\x80-\\xff]           #   Escaped something (something != CR)
)* \"  # closing quote
)  )* # further okay, if led by a period
(?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*  @  (?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*    (?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|   \\[                         # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*    #    stuff
\\]                        #           ]
)                           # initial subdomain
(?:                                  #
(?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*  \\.                        # if led by a period...
(?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*   (?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|   \\[                         # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*    #    stuff
\\]                        #           ]
)                     #   ...further okay
)*
#       address spec
(?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*  > #                  trailing >
# name and address
)  (?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*                       # optional trailing comment",[extended,trim]))), 
    <<"Alan Other <user.ain>">> = iolist_to_binary(join(re:split("Alan Other <user.ain>","  (?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*                          # optional leading comment
(?:    (?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|
\" (?:                      # opening quote...
[^\\\\\\x80-\\xff\\n\\015\"]                #   Anything except backslash and quote
|                     #    or
\\\\ [^\\x80-\\xff]           #   Escaped something (something != CR)
)* \"  # closing quote
)                    # initial word
(?:  (?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*  \\.  (?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*   (?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|
\" (?:                      # opening quote...
[^\\\\\\x80-\\xff\\n\\015\"]                #   Anything except backslash and quote
|                     #    or
\\\\ [^\\x80-\\xff]           #   Escaped something (something != CR)
)* \"  # closing quote
)  )* # further okay, if led by a period
(?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*  @  (?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*    (?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|   \\[                         # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*    #    stuff
\\]                        #           ]
)                           # initial subdomain
(?:                                  #
(?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*  \\.                        # if led by a period...
(?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*   (?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|   \\[                         # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*    #    stuff
\\]                        #           ]
)                     #   ...further okay
)*
# address
|                     #  or
(?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|
\" (?:                      # opening quote...
[^\\\\\\x80-\\xff\\n\\015\"]                #   Anything except backslash and quote
|                     #    or
\\\\ [^\\x80-\\xff]           #   Escaped something (something != CR)
)* \"  # closing quote
)             # one word, optionally followed by....
(?:
[^()<>@,;:\".\\\\\\[\\]\\x80-\\xff\\000-\\010\\012-\\037]  |  # atom and space parts, or...
\\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)       |  # comments, or...

\" (?:                      # opening quote...
[^\\\\\\x80-\\xff\\n\\015\"]                #   Anything except backslash and quote
|                     #    or
\\\\ [^\\x80-\\xff]           #   Escaped something (something != CR)
)* \"  # closing quote
# quoted strings
)*
<  (?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*                     # leading <
(?:  @  (?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*    (?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|   \\[                         # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*    #    stuff
\\]                        #           ]
)                           # initial subdomain
(?:                                  #
(?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*  \\.                        # if led by a period...
(?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*   (?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|   \\[                         # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*    #    stuff
\\]                        #           ]
)                     #   ...further okay
)*

(?:  (?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*  ,  (?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*  @  (?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*    (?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|   \\[                         # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*    #    stuff
\\]                        #           ]
)                           # initial subdomain
(?:                                  #
(?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*  \\.                        # if led by a period...
(?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*   (?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|   \\[                         # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*    #    stuff
\\]                        #           ]
)                     #   ...further okay
)*
)* # further okay, if led by comma
:                                # closing colon
(?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*  )? #       optional route
(?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|
\" (?:                      # opening quote...
[^\\\\\\x80-\\xff\\n\\015\"]                #   Anything except backslash and quote
|                     #    or
\\\\ [^\\x80-\\xff]           #   Escaped something (something != CR)
)* \"  # closing quote
)                    # initial word
(?:  (?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*  \\.  (?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*   (?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|
\" (?:                      # opening quote...
[^\\\\\\x80-\\xff\\n\\015\"]                #   Anything except backslash and quote
|                     #    or
\\\\ [^\\x80-\\xff]           #   Escaped something (something != CR)
)* \"  # closing quote
)  )* # further okay, if led by a period
(?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*  @  (?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*    (?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|   \\[                         # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*    #    stuff
\\]                        #           ]
)                           # initial subdomain
(?:                                  #
(?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*  \\.                        # if led by a period...
(?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*   (?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|   \\[                         # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*    #    stuff
\\]                        #           ]
)                     #   ...further okay
)*
#       address spec
(?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*  > #                  trailing >
# name and address
)  (?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*                       # optional trailing comment",[extended,
                                                               {parts,2}]))), 
    <<"Alan Other <user.ain>">> = iolist_to_binary(join(re:split("Alan Other <user.ain>","  (?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*                          # optional leading comment
(?:    (?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|
\" (?:                      # opening quote...
[^\\\\\\x80-\\xff\\n\\015\"]                #   Anything except backslash and quote
|                     #    or
\\\\ [^\\x80-\\xff]           #   Escaped something (something != CR)
)* \"  # closing quote
)                    # initial word
(?:  (?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*  \\.  (?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*   (?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|
\" (?:                      # opening quote...
[^\\\\\\x80-\\xff\\n\\015\"]                #   Anything except backslash and quote
|                     #    or
\\\\ [^\\x80-\\xff]           #   Escaped something (something != CR)
)* \"  # closing quote
)  )* # further okay, if led by a period
(?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*  @  (?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*    (?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|   \\[                         # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*    #    stuff
\\]                        #           ]
)                           # initial subdomain
(?:                                  #
(?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*  \\.                        # if led by a period...
(?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*   (?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|   \\[                         # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*    #    stuff
\\]                        #           ]
)                     #   ...further okay
)*
# address
|                     #  or
(?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|
\" (?:                      # opening quote...
[^\\\\\\x80-\\xff\\n\\015\"]                #   Anything except backslash and quote
|                     #    or
\\\\ [^\\x80-\\xff]           #   Escaped something (something != CR)
)* \"  # closing quote
)             # one word, optionally followed by....
(?:
[^()<>@,;:\".\\\\\\[\\]\\x80-\\xff\\000-\\010\\012-\\037]  |  # atom and space parts, or...
\\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)       |  # comments, or...

\" (?:                      # opening quote...
[^\\\\\\x80-\\xff\\n\\015\"]                #   Anything except backslash and quote
|                     #    or
\\\\ [^\\x80-\\xff]           #   Escaped something (something != CR)
)* \"  # closing quote
# quoted strings
)*
<  (?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*                     # leading <
(?:  @  (?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*    (?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|   \\[                         # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*    #    stuff
\\]                        #           ]
)                           # initial subdomain
(?:                                  #
(?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*  \\.                        # if led by a period...
(?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*   (?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|   \\[                         # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*    #    stuff
\\]                        #           ]
)                     #   ...further okay
)*

(?:  (?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*  ,  (?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*  @  (?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*    (?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|   \\[                         # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*    #    stuff
\\]                        #           ]
)                           # initial subdomain
(?:                                  #
(?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*  \\.                        # if led by a period...
(?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*   (?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|   \\[                         # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*    #    stuff
\\]                        #           ]
)                     #   ...further okay
)*
)* # further okay, if led by comma
:                                # closing colon
(?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*  )? #       optional route
(?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|
\" (?:                      # opening quote...
[^\\\\\\x80-\\xff\\n\\015\"]                #   Anything except backslash and quote
|                     #    or
\\\\ [^\\x80-\\xff]           #   Escaped something (something != CR)
)* \"  # closing quote
)                    # initial word
(?:  (?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*  \\.  (?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*   (?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|
\" (?:                      # opening quote...
[^\\\\\\x80-\\xff\\n\\015\"]                #   Anything except backslash and quote
|                     #    or
\\\\ [^\\x80-\\xff]           #   Escaped something (something != CR)
)* \"  # closing quote
)  )* # further okay, if led by a period
(?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*  @  (?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*    (?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|   \\[                         # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*    #    stuff
\\]                        #           ]
)                           # initial subdomain
(?:                                  #
(?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*  \\.                        # if led by a period...
(?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*   (?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|   \\[                         # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*    #    stuff
\\]                        #           ]
)                     #   ...further okay
)*
#       address spec
(?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*  > #                  trailing >
# name and address
)  (?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*                       # optional trailing comment",[extended]))), 
    <<"<user.ain>">> = iolist_to_binary(join(re:split("<user.ain>","  (?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*                          # optional leading comment
(?:    (?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|
\" (?:                      # opening quote...
[^\\\\\\x80-\\xff\\n\\015\"]                #   Anything except backslash and quote
|                     #    or
\\\\ [^\\x80-\\xff]           #   Escaped something (something != CR)
)* \"  # closing quote
)                    # initial word
(?:  (?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*  \\.  (?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*   (?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|
\" (?:                      # opening quote...
[^\\\\\\x80-\\xff\\n\\015\"]                #   Anything except backslash and quote
|                     #    or
\\\\ [^\\x80-\\xff]           #   Escaped something (something != CR)
)* \"  # closing quote
)  )* # further okay, if led by a period
(?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*  @  (?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*    (?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|   \\[                         # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*    #    stuff
\\]                        #           ]
)                           # initial subdomain
(?:                                  #
(?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*  \\.                        # if led by a period...
(?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*   (?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|   \\[                         # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*    #    stuff
\\]                        #           ]
)                     #   ...further okay
)*
# address
|                     #  or
(?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|
\" (?:                      # opening quote...
[^\\\\\\x80-\\xff\\n\\015\"]                #   Anything except backslash and quote
|                     #    or
\\\\ [^\\x80-\\xff]           #   Escaped something (something != CR)
)* \"  # closing quote
)             # one word, optionally followed by....
(?:
[^()<>@,;:\".\\\\\\[\\]\\x80-\\xff\\000-\\010\\012-\\037]  |  # atom and space parts, or...
\\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)       |  # comments, or...

\" (?:                      # opening quote...
[^\\\\\\x80-\\xff\\n\\015\"]                #   Anything except backslash and quote
|                     #    or
\\\\ [^\\x80-\\xff]           #   Escaped something (something != CR)
)* \"  # closing quote
# quoted strings
)*
<  (?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*                     # leading <
(?:  @  (?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*    (?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|   \\[                         # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*    #    stuff
\\]                        #           ]
)                           # initial subdomain
(?:                                  #
(?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*  \\.                        # if led by a period...
(?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*   (?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|   \\[                         # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*    #    stuff
\\]                        #           ]
)                     #   ...further okay
)*

(?:  (?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*  ,  (?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*  @  (?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*    (?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|   \\[                         # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*    #    stuff
\\]                        #           ]
)                           # initial subdomain
(?:                                  #
(?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*  \\.                        # if led by a period...
(?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*   (?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|   \\[                         # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*    #    stuff
\\]                        #           ]
)                     #   ...further okay
)*
)* # further okay, if led by comma
:                                # closing colon
(?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*  )? #       optional route
(?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|
\" (?:                      # opening quote...
[^\\\\\\x80-\\xff\\n\\015\"]                #   Anything except backslash and quote
|                     #    or
\\\\ [^\\x80-\\xff]           #   Escaped something (something != CR)
)* \"  # closing quote
)                    # initial word
(?:  (?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*  \\.  (?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*   (?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|
\" (?:                      # opening quote...
[^\\\\\\x80-\\xff\\n\\015\"]                #   Anything except backslash and quote
|                     #    or
\\\\ [^\\x80-\\xff]           #   Escaped something (something != CR)
)* \"  # closing quote
)  )* # further okay, if led by a period
(?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*  @  (?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*    (?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|   \\[                         # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*    #    stuff
\\]                        #           ]
)                           # initial subdomain
(?:                                  #
(?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*  \\.                        # if led by a period...
(?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*   (?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|   \\[                         # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*    #    stuff
\\]                        #           ]
)                     #   ...further okay
)*
#       address spec
(?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*  > #                  trailing >
# name and address
)  (?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*                       # optional trailing comment",[extended,trim]))), 
    <<"<user.ain>">> = iolist_to_binary(join(re:split("<user.ain>","  (?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*                          # optional leading comment
(?:    (?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|
\" (?:                      # opening quote...
[^\\\\\\x80-\\xff\\n\\015\"]                #   Anything except backslash and quote
|                     #    or
\\\\ [^\\x80-\\xff]           #   Escaped something (something != CR)
)* \"  # closing quote
)                    # initial word
(?:  (?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*  \\.  (?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*   (?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|
\" (?:                      # opening quote...
[^\\\\\\x80-\\xff\\n\\015\"]                #   Anything except backslash and quote
|                     #    or
\\\\ [^\\x80-\\xff]           #   Escaped something (something != CR)
)* \"  # closing quote
)  )* # further okay, if led by a period
(?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*  @  (?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*    (?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|   \\[                         # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*    #    stuff
\\]                        #           ]
)                           # initial subdomain
(?:                                  #
(?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*  \\.                        # if led by a period...
(?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*   (?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|   \\[                         # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*    #    stuff
\\]                        #           ]
)                     #   ...further okay
)*
# address
|                     #  or
(?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|
\" (?:                      # opening quote...
[^\\\\\\x80-\\xff\\n\\015\"]                #   Anything except backslash and quote
|                     #    or
\\\\ [^\\x80-\\xff]           #   Escaped something (something != CR)
)* \"  # closing quote
)             # one word, optionally followed by....
(?:
[^()<>@,;:\".\\\\\\[\\]\\x80-\\xff\\000-\\010\\012-\\037]  |  # atom and space parts, or...
\\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)       |  # comments, or...

\" (?:                      # opening quote...
[^\\\\\\x80-\\xff\\n\\015\"]                #   Anything except backslash and quote
|                     #    or
\\\\ [^\\x80-\\xff]           #   Escaped something (something != CR)
)* \"  # closing quote
# quoted strings
)*
<  (?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*                     # leading <
(?:  @  (?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*    (?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|   \\[                         # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*    #    stuff
\\]                        #           ]
)                           # initial subdomain
(?:                                  #
(?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*  \\.                        # if led by a period...
(?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*   (?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|   \\[                         # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*    #    stuff
\\]                        #           ]
)                     #   ...further okay
)*

(?:  (?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*  ,  (?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*  @  (?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*    (?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|   \\[                         # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*    #    stuff
\\]                        #           ]
)                           # initial subdomain
(?:                                  #
(?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*  \\.                        # if led by a period...
(?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*   (?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|   \\[                         # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*    #    stuff
\\]                        #           ]
)                     #   ...further okay
)*
)* # further okay, if led by comma
:                                # closing colon
(?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*  )? #       optional route
(?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|
\" (?:                      # opening quote...
[^\\\\\\x80-\\xff\\n\\015\"]                #   Anything except backslash and quote
|                     #    or
\\\\ [^\\x80-\\xff]           #   Escaped something (something != CR)
)* \"  # closing quote
)                    # initial word
(?:  (?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*  \\.  (?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*   (?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|
\" (?:                      # opening quote...
[^\\\\\\x80-\\xff\\n\\015\"]                #   Anything except backslash and quote
|                     #    or
\\\\ [^\\x80-\\xff]           #   Escaped something (something != CR)
)* \"  # closing quote
)  )* # further okay, if led by a period
(?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*  @  (?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*    (?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|   \\[                         # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*    #    stuff
\\]                        #           ]
)                           # initial subdomain
(?:                                  #
(?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*  \\.                        # if led by a period...
(?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*   (?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|   \\[                         # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*    #    stuff
\\]                        #           ]
)                     #   ...further okay
)*
#       address spec
(?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*  > #                  trailing >
# name and address
)  (?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*                       # optional trailing comment",[extended,
                                                               {parts,2}]))), 
    <<"<user.ain>">> = iolist_to_binary(join(re:split("<user.ain>","  (?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*                          # optional leading comment
(?:    (?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|
\" (?:                      # opening quote...
[^\\\\\\x80-\\xff\\n\\015\"]                #   Anything except backslash and quote
|                     #    or
\\\\ [^\\x80-\\xff]           #   Escaped something (something != CR)
)* \"  # closing quote
)                    # initial word
(?:  (?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*  \\.  (?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*   (?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|
\" (?:                      # opening quote...
[^\\\\\\x80-\\xff\\n\\015\"]                #   Anything except backslash and quote
|                     #    or
\\\\ [^\\x80-\\xff]           #   Escaped something (something != CR)
)* \"  # closing quote
)  )* # further okay, if led by a period
(?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*  @  (?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*    (?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|   \\[                         # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*    #    stuff
\\]                        #           ]
)                           # initial subdomain
(?:                                  #
(?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*  \\.                        # if led by a period...
(?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*   (?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|   \\[                         # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*    #    stuff
\\]                        #           ]
)                     #   ...further okay
)*
# address
|                     #  or
(?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|
\" (?:                      # opening quote...
[^\\\\\\x80-\\xff\\n\\015\"]                #   Anything except backslash and quote
|                     #    or
\\\\ [^\\x80-\\xff]           #   Escaped something (something != CR)
)* \"  # closing quote
)             # one word, optionally followed by....
(?:
[^()<>@,;:\".\\\\\\[\\]\\x80-\\xff\\000-\\010\\012-\\037]  |  # atom and space parts, or...
\\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)       |  # comments, or...

\" (?:                      # opening quote...
[^\\\\\\x80-\\xff\\n\\015\"]                #   Anything except backslash and quote
|                     #    or
\\\\ [^\\x80-\\xff]           #   Escaped something (something != CR)
)* \"  # closing quote
# quoted strings
)*
<  (?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*                     # leading <
(?:  @  (?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*    (?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|   \\[                         # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*    #    stuff
\\]                        #           ]
)                           # initial subdomain
(?:                                  #
(?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*  \\.                        # if led by a period...
(?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*   (?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|   \\[                         # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*    #    stuff
\\]                        #           ]
)                     #   ...further okay
)*

(?:  (?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*  ,  (?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*  @  (?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*    (?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|   \\[                         # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*    #    stuff
\\]                        #           ]
)                           # initial subdomain
(?:                                  #
(?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*  \\.                        # if led by a period...
(?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*   (?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|   \\[                         # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*    #    stuff
\\]                        #           ]
)                     #   ...further okay
)*
)* # further okay, if led by comma
:                                # closing colon
(?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*  )? #       optional route
(?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|
\" (?:                      # opening quote...
[^\\\\\\x80-\\xff\\n\\015\"]                #   Anything except backslash and quote
|                     #    or
\\\\ [^\\x80-\\xff]           #   Escaped something (something != CR)
)* \"  # closing quote
)                    # initial word
(?:  (?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*  \\.  (?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*   (?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|
\" (?:                      # opening quote...
[^\\\\\\x80-\\xff\\n\\015\"]                #   Anything except backslash and quote
|                     #    or
\\\\ [^\\x80-\\xff]           #   Escaped something (something != CR)
)* \"  # closing quote
)  )* # further okay, if led by a period
(?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*  @  (?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*    (?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|   \\[                         # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*    #    stuff
\\]                        #           ]
)                           # initial subdomain
(?:                                  #
(?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*  \\.                        # if led by a period...
(?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*   (?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|   \\[                         # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*    #    stuff
\\]                        #           ]
)                     #   ...further okay
)*
#       address spec
(?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*  > #                  trailing >
# name and address
)  (?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*                       # optional trailing comment",[extended]))), 
    <<"user.ain">> = iolist_to_binary(join(re:split("user.ain","  (?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*                          # optional leading comment
(?:    (?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|
\" (?:                      # opening quote...
[^\\\\\\x80-\\xff\\n\\015\"]                #   Anything except backslash and quote
|                     #    or
\\\\ [^\\x80-\\xff]           #   Escaped something (something != CR)
)* \"  # closing quote
)                    # initial word
(?:  (?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*  \\.  (?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*   (?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|
\" (?:                      # opening quote...
[^\\\\\\x80-\\xff\\n\\015\"]                #   Anything except backslash and quote
|                     #    or
\\\\ [^\\x80-\\xff]           #   Escaped something (something != CR)
)* \"  # closing quote
)  )* # further okay, if led by a period
(?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*  @  (?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*    (?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|   \\[                         # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*    #    stuff
\\]                        #           ]
)                           # initial subdomain
(?:                                  #
(?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*  \\.                        # if led by a period...
(?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*   (?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|   \\[                         # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*    #    stuff
\\]                        #           ]
)                     #   ...further okay
)*
# address
|                     #  or
(?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|
\" (?:                      # opening quote...
[^\\\\\\x80-\\xff\\n\\015\"]                #   Anything except backslash and quote
|                     #    or
\\\\ [^\\x80-\\xff]           #   Escaped something (something != CR)
)* \"  # closing quote
)             # one word, optionally followed by....
(?:
[^()<>@,;:\".\\\\\\[\\]\\x80-\\xff\\000-\\010\\012-\\037]  |  # atom and space parts, or...
\\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)       |  # comments, or...

\" (?:                      # opening quote...
[^\\\\\\x80-\\xff\\n\\015\"]                #   Anything except backslash and quote
|                     #    or
\\\\ [^\\x80-\\xff]           #   Escaped something (something != CR)
)* \"  # closing quote
# quoted strings
)*
<  (?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*                     # leading <
(?:  @  (?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*    (?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|   \\[                         # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*    #    stuff
\\]                        #           ]
)                           # initial subdomain
(?:                                  #
(?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*  \\.                        # if led by a period...
(?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*   (?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|   \\[                         # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*    #    stuff
\\]                        #           ]
)                     #   ...further okay
)*

(?:  (?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*  ,  (?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*  @  (?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*    (?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|   \\[                         # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*    #    stuff
\\]                        #           ]
)                           # initial subdomain
(?:                                  #
(?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*  \\.                        # if led by a period...
(?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*   (?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|   \\[                         # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*    #    stuff
\\]                        #           ]
)                     #   ...further okay
)*
)* # further okay, if led by comma
:                                # closing colon
(?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*  )? #       optional route
(?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|
\" (?:                      # opening quote...
[^\\\\\\x80-\\xff\\n\\015\"]                #   Anything except backslash and quote
|                     #    or
\\\\ [^\\x80-\\xff]           #   Escaped something (something != CR)
)* \"  # closing quote
)                    # initial word
(?:  (?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*  \\.  (?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*   (?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|
\" (?:                      # opening quote...
[^\\\\\\x80-\\xff\\n\\015\"]                #   Anything except backslash and quote
|                     #    or
\\\\ [^\\x80-\\xff]           #   Escaped something (something != CR)
)* \"  # closing quote
)  )* # further okay, if led by a period
(?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*  @  (?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*    (?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|   \\[                         # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*    #    stuff
\\]                        #           ]
)                           # initial subdomain
(?:                                  #
(?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*  \\.                        # if led by a period...
(?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*   (?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|   \\[                         # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*    #    stuff
\\]                        #           ]
)                     #   ...further okay
)*
#       address spec
(?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*  > #                  trailing >
# name and address
)  (?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*                       # optional trailing comment",[extended,trim]))), 
    <<"user.ain">> = iolist_to_binary(join(re:split("user.ain","  (?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*                          # optional leading comment
(?:    (?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|
\" (?:                      # opening quote...
[^\\\\\\x80-\\xff\\n\\015\"]                #   Anything except backslash and quote
|                     #    or
\\\\ [^\\x80-\\xff]           #   Escaped something (something != CR)
)* \"  # closing quote
)                    # initial word
(?:  (?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*  \\.  (?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*   (?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|
\" (?:                      # opening quote...
[^\\\\\\x80-\\xff\\n\\015\"]                #   Anything except backslash and quote
|                     #    or
\\\\ [^\\x80-\\xff]           #   Escaped something (something != CR)
)* \"  # closing quote
)  )* # further okay, if led by a period
(?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*  @  (?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*    (?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|   \\[                         # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*    #    stuff
\\]                        #           ]
)                           # initial subdomain
(?:                                  #
(?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*  \\.                        # if led by a period...
(?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*   (?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|   \\[                         # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*    #    stuff
\\]                        #           ]
)                     #   ...further okay
)*
# address
|                     #  or
(?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|
\" (?:                      # opening quote...
[^\\\\\\x80-\\xff\\n\\015\"]                #   Anything except backslash and quote
|                     #    or
\\\\ [^\\x80-\\xff]           #   Escaped something (something != CR)
)* \"  # closing quote
)             # one word, optionally followed by....
(?:
[^()<>@,;:\".\\\\\\[\\]\\x80-\\xff\\000-\\010\\012-\\037]  |  # atom and space parts, or...
\\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)       |  # comments, or...

\" (?:                      # opening quote...
[^\\\\\\x80-\\xff\\n\\015\"]                #   Anything except backslash and quote
|                     #    or
\\\\ [^\\x80-\\xff]           #   Escaped something (something != CR)
)* \"  # closing quote
# quoted strings
)*
<  (?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*                     # leading <
(?:  @  (?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*    (?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|   \\[                         # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*    #    stuff
\\]                        #           ]
)                           # initial subdomain
(?:                                  #
(?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*  \\.                        # if led by a period...
(?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*   (?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|   \\[                         # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*    #    stuff
\\]                        #           ]
)                     #   ...further okay
)*

(?:  (?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*  ,  (?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*  @  (?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*    (?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|   \\[                         # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*    #    stuff
\\]                        #           ]
)                           # initial subdomain
(?:                                  #
(?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*  \\.                        # if led by a period...
(?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*   (?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|   \\[                         # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*    #    stuff
\\]                        #           ]
)                     #   ...further okay
)*
)* # further okay, if led by comma
:                                # closing colon
(?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*  )? #       optional route
(?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|
\" (?:                      # opening quote...
[^\\\\\\x80-\\xff\\n\\015\"]                #   Anything except backslash and quote
|                     #    or
\\\\ [^\\x80-\\xff]           #   Escaped something (something != CR)
)* \"  # closing quote
)                    # initial word
(?:  (?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*  \\.  (?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*   (?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|
\" (?:                      # opening quote...
[^\\\\\\x80-\\xff\\n\\015\"]                #   Anything except backslash and quote
|                     #    or
\\\\ [^\\x80-\\xff]           #   Escaped something (something != CR)
)* \"  # closing quote
)  )* # further okay, if led by a period
(?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*  @  (?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*    (?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|   \\[                         # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*    #    stuff
\\]                        #           ]
)                           # initial subdomain
(?:                                  #
(?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*  \\.                        # if led by a period...
(?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*   (?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|   \\[                         # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*    #    stuff
\\]                        #           ]
)                     #   ...further okay
)*
#       address spec
(?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*  > #                  trailing >
# name and address
)  (?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*                       # optional trailing comment",[extended,
                                                               {parts,2}]))), 
    <<"user.ain">> = iolist_to_binary(join(re:split("user.ain","  (?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*                          # optional leading comment
(?:    (?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|
\" (?:                      # opening quote...
[^\\\\\\x80-\\xff\\n\\015\"]                #   Anything except backslash and quote
|                     #    or
\\\\ [^\\x80-\\xff]           #   Escaped something (something != CR)
)* \"  # closing quote
)                    # initial word
(?:  (?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*  \\.  (?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*   (?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|
\" (?:                      # opening quote...
[^\\\\\\x80-\\xff\\n\\015\"]                #   Anything except backslash and quote
|                     #    or
\\\\ [^\\x80-\\xff]           #   Escaped something (something != CR)
)* \"  # closing quote
)  )* # further okay, if led by a period
(?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*  @  (?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*    (?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|   \\[                         # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*    #    stuff
\\]                        #           ]
)                           # initial subdomain
(?:                                  #
(?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*  \\.                        # if led by a period...
(?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*   (?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|   \\[                         # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*    #    stuff
\\]                        #           ]
)                     #   ...further okay
)*
# address
|                     #  or
(?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|
\" (?:                      # opening quote...
[^\\\\\\x80-\\xff\\n\\015\"]                #   Anything except backslash and quote
|                     #    or
\\\\ [^\\x80-\\xff]           #   Escaped something (something != CR)
)* \"  # closing quote
)             # one word, optionally followed by....
(?:
[^()<>@,;:\".\\\\\\[\\]\\x80-\\xff\\000-\\010\\012-\\037]  |  # atom and space parts, or...
\\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)       |  # comments, or...

\" (?:                      # opening quote...
[^\\\\\\x80-\\xff\\n\\015\"]                #   Anything except backslash and quote
|                     #    or
\\\\ [^\\x80-\\xff]           #   Escaped something (something != CR)
)* \"  # closing quote
# quoted strings
)*
<  (?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*                     # leading <
(?:  @  (?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*    (?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|   \\[                         # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*    #    stuff
\\]                        #           ]
)                           # initial subdomain
(?:                                  #
(?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*  \\.                        # if led by a period...
(?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*   (?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|   \\[                         # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*    #    stuff
\\]                        #           ]
)                     #   ...further okay
)*

(?:  (?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*  ,  (?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*  @  (?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*    (?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|   \\[                         # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*    #    stuff
\\]                        #           ]
)                           # initial subdomain
(?:                                  #
(?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*  \\.                        # if led by a period...
(?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*   (?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|   \\[                         # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*    #    stuff
\\]                        #           ]
)                     #   ...further okay
)*
)* # further okay, if led by comma
:                                # closing colon
(?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*  )? #       optional route
(?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|
\" (?:                      # opening quote...
[^\\\\\\x80-\\xff\\n\\015\"]                #   Anything except backslash and quote
|                     #    or
\\\\ [^\\x80-\\xff]           #   Escaped something (something != CR)
)* \"  # closing quote
)                    # initial word
(?:  (?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*  \\.  (?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*   (?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|
\" (?:                      # opening quote...
[^\\\\\\x80-\\xff\\n\\015\"]                #   Anything except backslash and quote
|                     #    or
\\\\ [^\\x80-\\xff]           #   Escaped something (something != CR)
)* \"  # closing quote
)  )* # further okay, if led by a period
(?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*  @  (?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*    (?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|   \\[                         # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*    #    stuff
\\]                        #           ]
)                           # initial subdomain
(?:                                  #
(?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*  \\.                        # if led by a period...
(?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*   (?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|   \\[                         # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*    #    stuff
\\]                        #           ]
)                     #   ...further okay
)*
#       address spec
(?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*  > #                  trailing >
# name and address
)  (?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*                       # optional trailing comment",[extended]))), 
    <<"\"A. Other\" <user.1234.ain> (a comment)">> = iolist_to_binary(join(re:split("\"A. Other\" <user.1234.ain> (a comment)","  (?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*                          # optional leading comment
(?:    (?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|
\" (?:                      # opening quote...
[^\\\\\\x80-\\xff\\n\\015\"]                #   Anything except backslash and quote
|                     #    or
\\\\ [^\\x80-\\xff]           #   Escaped something (something != CR)
)* \"  # closing quote
)                    # initial word
(?:  (?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*  \\.  (?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*   (?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|
\" (?:                      # opening quote...
[^\\\\\\x80-\\xff\\n\\015\"]                #   Anything except backslash and quote
|                     #    or
\\\\ [^\\x80-\\xff]           #   Escaped something (something != CR)
)* \"  # closing quote
)  )* # further okay, if led by a period
(?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*  @  (?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*    (?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|   \\[                         # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*    #    stuff
\\]                        #           ]
)                           # initial subdomain
(?:                                  #
(?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*  \\.                        # if led by a period...
(?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*   (?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|   \\[                         # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*    #    stuff
\\]                        #           ]
)                     #   ...further okay
)*
# address
|                     #  or
(?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|
\" (?:                      # opening quote...
[^\\\\\\x80-\\xff\\n\\015\"]                #   Anything except backslash and quote
|                     #    or
\\\\ [^\\x80-\\xff]           #   Escaped something (something != CR)
)* \"  # closing quote
)             # one word, optionally followed by....
(?:
[^()<>@,;:\".\\\\\\[\\]\\x80-\\xff\\000-\\010\\012-\\037]  |  # atom and space parts, or...
\\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)       |  # comments, or...

\" (?:                      # opening quote...
[^\\\\\\x80-\\xff\\n\\015\"]                #   Anything except backslash and quote
|                     #    or
\\\\ [^\\x80-\\xff]           #   Escaped something (something != CR)
)* \"  # closing quote
# quoted strings
)*
<  (?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*                     # leading <
(?:  @  (?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*    (?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|   \\[                         # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*    #    stuff
\\]                        #           ]
)                           # initial subdomain
(?:                                  #
(?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*  \\.                        # if led by a period...
(?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*   (?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|   \\[                         # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*    #    stuff
\\]                        #           ]
)                     #   ...further okay
)*

(?:  (?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*  ,  (?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*  @  (?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*    (?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|   \\[                         # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*    #    stuff
\\]                        #           ]
)                           # initial subdomain
(?:                                  #
(?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*  \\.                        # if led by a period...
(?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*   (?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|   \\[                         # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*    #    stuff
\\]                        #           ]
)                     #   ...further okay
)*
)* # further okay, if led by comma
:                                # closing colon
(?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*  )? #       optional route
(?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|
\" (?:                      # opening quote...
[^\\\\\\x80-\\xff\\n\\015\"]                #   Anything except backslash and quote
|                     #    or
\\\\ [^\\x80-\\xff]           #   Escaped something (something != CR)
)* \"  # closing quote
)                    # initial word
(?:  (?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*  \\.  (?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*   (?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|
\" (?:                      # opening quote...
[^\\\\\\x80-\\xff\\n\\015\"]                #   Anything except backslash and quote
|                     #    or
\\\\ [^\\x80-\\xff]           #   Escaped something (something != CR)
)* \"  # closing quote
)  )* # further okay, if led by a period
(?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*  @  (?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*    (?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|   \\[                         # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*    #    stuff
\\]                        #           ]
)                           # initial subdomain
(?:                                  #
(?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*  \\.                        # if led by a period...
(?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*   (?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|   \\[                         # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*    #    stuff
\\]                        #           ]
)                     #   ...further okay
)*
#       address spec
(?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*  > #                  trailing >
# name and address
)  (?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*                       # optional trailing comment",[extended,trim]))), 
    <<"\"A. Other\" <user.1234.ain> (a comment)">> = iolist_to_binary(join(re:split("\"A. Other\" <user.1234.ain> (a comment)","  (?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*                          # optional leading comment
(?:    (?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|
\" (?:                      # opening quote...
[^\\\\\\x80-\\xff\\n\\015\"]                #   Anything except backslash and quote
|                     #    or
\\\\ [^\\x80-\\xff]           #   Escaped something (something != CR)
)* \"  # closing quote
)                    # initial word
(?:  (?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*  \\.  (?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*   (?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|
\" (?:                      # opening quote...
[^\\\\\\x80-\\xff\\n\\015\"]                #   Anything except backslash and quote
|                     #    or
\\\\ [^\\x80-\\xff]           #   Escaped something (something != CR)
)* \"  # closing quote
)  )* # further okay, if led by a period
(?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*  @  (?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*    (?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|   \\[                         # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*    #    stuff
\\]                        #           ]
)                           # initial subdomain
(?:                                  #
(?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*  \\.                        # if led by a period...
(?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*   (?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|   \\[                         # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*    #    stuff
\\]                        #           ]
)                     #   ...further okay
)*
# address
|                     #  or
(?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|
\" (?:                      # opening quote...
[^\\\\\\x80-\\xff\\n\\015\"]                #   Anything except backslash and quote
|                     #    or
\\\\ [^\\x80-\\xff]           #   Escaped something (something != CR)
)* \"  # closing quote
)             # one word, optionally followed by....
(?:
[^()<>@,;:\".\\\\\\[\\]\\x80-\\xff\\000-\\010\\012-\\037]  |  # atom and space parts, or...
\\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)       |  # comments, or...

\" (?:                      # opening quote...
[^\\\\\\x80-\\xff\\n\\015\"]                #   Anything except backslash and quote
|                     #    or
\\\\ [^\\x80-\\xff]           #   Escaped something (something != CR)
)* \"  # closing quote
# quoted strings
)*
<  (?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*                     # leading <
(?:  @  (?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*    (?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|   \\[                         # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*    #    stuff
\\]                        #           ]
)                           # initial subdomain
(?:                                  #
(?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*  \\.                        # if led by a period...
(?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*   (?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|   \\[                         # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*    #    stuff
\\]                        #           ]
)                     #   ...further okay
)*

(?:  (?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*  ,  (?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*  @  (?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*    (?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|   \\[                         # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*    #    stuff
\\]                        #           ]
)                           # initial subdomain
(?:                                  #
(?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*  \\.                        # if led by a period...
(?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*   (?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|   \\[                         # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*    #    stuff
\\]                        #           ]
)                     #   ...further okay
)*
)* # further okay, if led by comma
:                                # closing colon
(?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*  )? #       optional route
(?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|
\" (?:                      # opening quote...
[^\\\\\\x80-\\xff\\n\\015\"]                #   Anything except backslash and quote
|                     #    or
\\\\ [^\\x80-\\xff]           #   Escaped something (something != CR)
)* \"  # closing quote
)                    # initial word
(?:  (?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*  \\.  (?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*   (?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|
\" (?:                      # opening quote...
[^\\\\\\x80-\\xff\\n\\015\"]                #   Anything except backslash and quote
|                     #    or
\\\\ [^\\x80-\\xff]           #   Escaped something (something != CR)
)* \"  # closing quote
)  )* # further okay, if led by a period
(?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*  @  (?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*    (?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|   \\[                         # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*    #    stuff
\\]                        #           ]
)                           # initial subdomain
(?:                                  #
(?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*  \\.                        # if led by a period...
(?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*   (?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|   \\[                         # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*    #    stuff
\\]                        #           ]
)                     #   ...further okay
)*
#       address spec
(?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*  > #                  trailing >
# name and address
)  (?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*                       # optional trailing comment",[extended,
                                                               {parts,2}]))), 
    <<"\"A. Other\" <user.1234.ain> (a comment)">> = iolist_to_binary(join(re:split("\"A. Other\" <user.1234.ain> (a comment)","  (?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*                          # optional leading comment
(?:    (?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|
\" (?:                      # opening quote...
[^\\\\\\x80-\\xff\\n\\015\"]                #   Anything except backslash and quote
|                     #    or
\\\\ [^\\x80-\\xff]           #   Escaped something (something != CR)
)* \"  # closing quote
)                    # initial word
(?:  (?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*  \\.  (?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*   (?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|
\" (?:                      # opening quote...
[^\\\\\\x80-\\xff\\n\\015\"]                #   Anything except backslash and quote
|                     #    or
\\\\ [^\\x80-\\xff]           #   Escaped something (something != CR)
)* \"  # closing quote
)  )* # further okay, if led by a period
(?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*  @  (?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*    (?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|   \\[                         # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*    #    stuff
\\]                        #           ]
)                           # initial subdomain
(?:                                  #
(?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*  \\.                        # if led by a period...
(?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*   (?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|   \\[                         # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*    #    stuff
\\]                        #           ]
)                     #   ...further okay
)*
# address
|                     #  or
(?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|
\" (?:                      # opening quote...
[^\\\\\\x80-\\xff\\n\\015\"]                #   Anything except backslash and quote
|                     #    or
\\\\ [^\\x80-\\xff]           #   Escaped something (something != CR)
)* \"  # closing quote
)             # one word, optionally followed by....
(?:
[^()<>@,;:\".\\\\\\[\\]\\x80-\\xff\\000-\\010\\012-\\037]  |  # atom and space parts, or...
\\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)       |  # comments, or...

\" (?:                      # opening quote...
[^\\\\\\x80-\\xff\\n\\015\"]                #   Anything except backslash and quote
|                     #    or
\\\\ [^\\x80-\\xff]           #   Escaped something (something != CR)
)* \"  # closing quote
# quoted strings
)*
<  (?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*                     # leading <
(?:  @  (?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*    (?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|   \\[                         # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*    #    stuff
\\]                        #           ]
)                           # initial subdomain
(?:                                  #
(?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*  \\.                        # if led by a period...
(?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*   (?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|   \\[                         # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*    #    stuff
\\]                        #           ]
)                     #   ...further okay
)*

(?:  (?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*  ,  (?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*  @  (?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*    (?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|   \\[                         # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*    #    stuff
\\]                        #           ]
)                           # initial subdomain
(?:                                  #
(?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*  \\.                        # if led by a period...
(?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*   (?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|   \\[                         # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*    #    stuff
\\]                        #           ]
)                     #   ...further okay
)*
)* # further okay, if led by comma
:                                # closing colon
(?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*  )? #       optional route
(?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|
\" (?:                      # opening quote...
[^\\\\\\x80-\\xff\\n\\015\"]                #   Anything except backslash and quote
|                     #    or
\\\\ [^\\x80-\\xff]           #   Escaped something (something != CR)
)* \"  # closing quote
)                    # initial word
(?:  (?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*  \\.  (?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*   (?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|
\" (?:                      # opening quote...
[^\\\\\\x80-\\xff\\n\\015\"]                #   Anything except backslash and quote
|                     #    or
\\\\ [^\\x80-\\xff]           #   Escaped something (something != CR)
)* \"  # closing quote
)  )* # further okay, if led by a period
(?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*  @  (?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*    (?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|   \\[                         # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*    #    stuff
\\]                        #           ]
)                           # initial subdomain
(?:                                  #
(?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*  \\.                        # if led by a period...
(?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*   (?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|   \\[                         # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*    #    stuff
\\]                        #           ]
)                     #   ...further okay
)*
#       address spec
(?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*  > #                  trailing >
# name and address
)  (?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*                       # optional trailing comment",[extended]))), 
    <<"A. Other <user.1234.ain> (a comment)">> = iolist_to_binary(join(re:split("A. Other <user.1234.ain> (a comment)","  (?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*                          # optional leading comment
(?:    (?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|
\" (?:                      # opening quote...
[^\\\\\\x80-\\xff\\n\\015\"]                #   Anything except backslash and quote
|                     #    or
\\\\ [^\\x80-\\xff]           #   Escaped something (something != CR)
)* \"  # closing quote
)                    # initial word
(?:  (?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*  \\.  (?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*   (?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|
\" (?:                      # opening quote...
[^\\\\\\x80-\\xff\\n\\015\"]                #   Anything except backslash and quote
|                     #    or
\\\\ [^\\x80-\\xff]           #   Escaped something (something != CR)
)* \"  # closing quote
)  )* # further okay, if led by a period
(?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*  @  (?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*    (?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|   \\[                         # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*    #    stuff
\\]                        #           ]
)                           # initial subdomain
(?:                                  #
(?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*  \\.                        # if led by a period...
(?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*   (?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|   \\[                         # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*    #    stuff
\\]                        #           ]
)                     #   ...further okay
)*
# address
|                     #  or
(?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|
\" (?:                      # opening quote...
[^\\\\\\x80-\\xff\\n\\015\"]                #   Anything except backslash and quote
|                     #    or
\\\\ [^\\x80-\\xff]           #   Escaped something (something != CR)
)* \"  # closing quote
)             # one word, optionally followed by....
(?:
[^()<>@,;:\".\\\\\\[\\]\\x80-\\xff\\000-\\010\\012-\\037]  |  # atom and space parts, or...
\\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)       |  # comments, or...

\" (?:                      # opening quote...
[^\\\\\\x80-\\xff\\n\\015\"]                #   Anything except backslash and quote
|                     #    or
\\\\ [^\\x80-\\xff]           #   Escaped something (something != CR)
)* \"  # closing quote
# quoted strings
)*
<  (?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*                     # leading <
(?:  @  (?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*    (?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|   \\[                         # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*    #    stuff
\\]                        #           ]
)                           # initial subdomain
(?:                                  #
(?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*  \\.                        # if led by a period...
(?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*   (?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|   \\[                         # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*    #    stuff
\\]                        #           ]
)                     #   ...further okay
)*

(?:  (?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*  ,  (?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*  @  (?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*    (?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|   \\[                         # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*    #    stuff
\\]                        #           ]
)                           # initial subdomain
(?:                                  #
(?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*  \\.                        # if led by a period...
(?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*   (?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|   \\[                         # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*    #    stuff
\\]                        #           ]
)                     #   ...further okay
)*
)* # further okay, if led by comma
:                                # closing colon
(?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*  )? #       optional route
(?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|
\" (?:                      # opening quote...
[^\\\\\\x80-\\xff\\n\\015\"]                #   Anything except backslash and quote
|                     #    or
\\\\ [^\\x80-\\xff]           #   Escaped something (something != CR)
)* \"  # closing quote
)                    # initial word
(?:  (?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*  \\.  (?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*   (?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|
\" (?:                      # opening quote...
[^\\\\\\x80-\\xff\\n\\015\"]                #   Anything except backslash and quote
|                     #    or
\\\\ [^\\x80-\\xff]           #   Escaped something (something != CR)
)* \"  # closing quote
)  )* # further okay, if led by a period
(?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*  @  (?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*    (?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|   \\[                         # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*    #    stuff
\\]                        #           ]
)                           # initial subdomain
(?:                                  #
(?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*  \\.                        # if led by a period...
(?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*   (?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|   \\[                         # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*    #    stuff
\\]                        #           ]
)                     #   ...further okay
)*
#       address spec
(?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*  > #                  trailing >
# name and address
)  (?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*                       # optional trailing comment",[extended,trim]))), 
    <<"A. Other <user.1234.ain> (a comment)">> = iolist_to_binary(join(re:split("A. Other <user.1234.ain> (a comment)","  (?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*                          # optional leading comment
(?:    (?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|
\" (?:                      # opening quote...
[^\\\\\\x80-\\xff\\n\\015\"]                #   Anything except backslash and quote
|                     #    or
\\\\ [^\\x80-\\xff]           #   Escaped something (something != CR)
)* \"  # closing quote
)                    # initial word
(?:  (?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*  \\.  (?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*   (?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|
\" (?:                      # opening quote...
[^\\\\\\x80-\\xff\\n\\015\"]                #   Anything except backslash and quote
|                     #    or
\\\\ [^\\x80-\\xff]           #   Escaped something (something != CR)
)* \"  # closing quote
)  )* # further okay, if led by a period
(?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*  @  (?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*    (?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|   \\[                         # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*    #    stuff
\\]                        #           ]
)                           # initial subdomain
(?:                                  #
(?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*  \\.                        # if led by a period...
(?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*   (?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|   \\[                         # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*    #    stuff
\\]                        #           ]
)                     #   ...further okay
)*
# address
|                     #  or
(?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|
\" (?:                      # opening quote...
[^\\\\\\x80-\\xff\\n\\015\"]                #   Anything except backslash and quote
|                     #    or
\\\\ [^\\x80-\\xff]           #   Escaped something (something != CR)
)* \"  # closing quote
)             # one word, optionally followed by....
(?:
[^()<>@,;:\".\\\\\\[\\]\\x80-\\xff\\000-\\010\\012-\\037]  |  # atom and space parts, or...
\\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)       |  # comments, or...

\" (?:                      # opening quote...
[^\\\\\\x80-\\xff\\n\\015\"]                #   Anything except backslash and quote
|                     #    or
\\\\ [^\\x80-\\xff]           #   Escaped something (something != CR)
)* \"  # closing quote
# quoted strings
)*
<  (?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*                     # leading <
(?:  @  (?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*    (?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|   \\[                         # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*    #    stuff
\\]                        #           ]
)                           # initial subdomain
(?:                                  #
(?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*  \\.                        # if led by a period...
(?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*   (?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|   \\[                         # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*    #    stuff
\\]                        #           ]
)                     #   ...further okay
)*

(?:  (?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*  ,  (?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*  @  (?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*    (?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|   \\[                         # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*    #    stuff
\\]                        #           ]
)                           # initial subdomain
(?:                                  #
(?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*  \\.                        # if led by a period...
(?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*   (?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|   \\[                         # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*    #    stuff
\\]                        #           ]
)                     #   ...further okay
)*
)* # further okay, if led by comma
:                                # closing colon
(?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*  )? #       optional route
(?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|
\" (?:                      # opening quote...
[^\\\\\\x80-\\xff\\n\\015\"]                #   Anything except backslash and quote
|                     #    or
\\\\ [^\\x80-\\xff]           #   Escaped something (something != CR)
)* \"  # closing quote
)                    # initial word
(?:  (?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*  \\.  (?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*   (?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|
\" (?:                      # opening quote...
[^\\\\\\x80-\\xff\\n\\015\"]                #   Anything except backslash and quote
|                     #    or
\\\\ [^\\x80-\\xff]           #   Escaped something (something != CR)
)* \"  # closing quote
)  )* # further okay, if led by a period
(?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*  @  (?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*    (?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|   \\[                         # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*    #    stuff
\\]                        #           ]
)                           # initial subdomain
(?:                                  #
(?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*  \\.                        # if led by a period...
(?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*   (?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|   \\[                         # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*    #    stuff
\\]                        #           ]
)                     #   ...further okay
)*
#       address spec
(?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*  > #                  trailing >
# name and address
)  (?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*                       # optional trailing comment",[extended,
                                                               {parts,2}]))), 
    <<"A. Other <user.1234.ain> (a comment)">> = iolist_to_binary(join(re:split("A. Other <user.1234.ain> (a comment)","  (?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*                          # optional leading comment
(?:    (?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|
\" (?:                      # opening quote...
[^\\\\\\x80-\\xff\\n\\015\"]                #   Anything except backslash and quote
|                     #    or
\\\\ [^\\x80-\\xff]           #   Escaped something (something != CR)
)* \"  # closing quote
)                    # initial word
(?:  (?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*  \\.  (?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*   (?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|
\" (?:                      # opening quote...
[^\\\\\\x80-\\xff\\n\\015\"]                #   Anything except backslash and quote
|                     #    or
\\\\ [^\\x80-\\xff]           #   Escaped something (something != CR)
)* \"  # closing quote
)  )* # further okay, if led by a period
(?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*  @  (?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*    (?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|   \\[                         # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*    #    stuff
\\]                        #           ]
)                           # initial subdomain
(?:                                  #
(?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*  \\.                        # if led by a period...
(?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*   (?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|   \\[                         # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*    #    stuff
\\]                        #           ]
)                     #   ...further okay
)*
# address
|                     #  or
(?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|
\" (?:                      # opening quote...
[^\\\\\\x80-\\xff\\n\\015\"]                #   Anything except backslash and quote
|                     #    or
\\\\ [^\\x80-\\xff]           #   Escaped something (something != CR)
)* \"  # closing quote
)             # one word, optionally followed by....
(?:
[^()<>@,;:\".\\\\\\[\\]\\x80-\\xff\\000-\\010\\012-\\037]  |  # atom and space parts, or...
\\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)       |  # comments, or...

\" (?:                      # opening quote...
[^\\\\\\x80-\\xff\\n\\015\"]                #   Anything except backslash and quote
|                     #    or
\\\\ [^\\x80-\\xff]           #   Escaped something (something != CR)
)* \"  # closing quote
# quoted strings
)*
<  (?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*                     # leading <
(?:  @  (?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*    (?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|   \\[                         # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*    #    stuff
\\]                        #           ]
)                           # initial subdomain
(?:                                  #
(?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*  \\.                        # if led by a period...
(?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*   (?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|   \\[                         # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*    #    stuff
\\]                        #           ]
)                     #   ...further okay
)*

(?:  (?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*  ,  (?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*  @  (?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*    (?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|   \\[                         # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*    #    stuff
\\]                        #           ]
)                           # initial subdomain
(?:                                  #
(?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*  \\.                        # if led by a period...
(?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*   (?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|   \\[                         # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*    #    stuff
\\]                        #           ]
)                     #   ...further okay
)*
)* # further okay, if led by comma
:                                # closing colon
(?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*  )? #       optional route
(?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|
\" (?:                      # opening quote...
[^\\\\\\x80-\\xff\\n\\015\"]                #   Anything except backslash and quote
|                     #    or
\\\\ [^\\x80-\\xff]           #   Escaped something (something != CR)
)* \"  # closing quote
)                    # initial word
(?:  (?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*  \\.  (?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*   (?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|
\" (?:                      # opening quote...
[^\\\\\\x80-\\xff\\n\\015\"]                #   Anything except backslash and quote
|                     #    or
\\\\ [^\\x80-\\xff]           #   Escaped something (something != CR)
)* \"  # closing quote
)  )* # further okay, if led by a period
(?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*  @  (?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*    (?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|   \\[                         # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*    #    stuff
\\]                        #           ]
)                           # initial subdomain
(?:                                  #
(?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*  \\.                        # if led by a period...
(?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*   (?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|   \\[                         # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*    #    stuff
\\]                        #           ]
)                     #   ...further okay
)*
#       address spec
(?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*  > #                  trailing >
# name and address
)  (?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*                       # optional trailing comment",[extended]))), 
    <<"\"/s=user/ou=host/o=place/prmd=uu.yy/admd= /c=gb/\"-re.lay">> = iolist_to_binary(join(re:split("\"/s=user/ou=host/o=place/prmd=uu.yy/admd= /c=gb/\"-re.lay","  (?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*                          # optional leading comment
(?:    (?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|
\" (?:                      # opening quote...
[^\\\\\\x80-\\xff\\n\\015\"]                #   Anything except backslash and quote
|                     #    or
\\\\ [^\\x80-\\xff]           #   Escaped something (something != CR)
)* \"  # closing quote
)                    # initial word
(?:  (?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*  \\.  (?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*   (?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|
\" (?:                      # opening quote...
[^\\\\\\x80-\\xff\\n\\015\"]                #   Anything except backslash and quote
|                     #    or
\\\\ [^\\x80-\\xff]           #   Escaped something (something != CR)
)* \"  # closing quote
)  )* # further okay, if led by a period
(?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*  @  (?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*    (?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|   \\[                         # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*    #    stuff
\\]                        #           ]
)                           # initial subdomain
(?:                                  #
(?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*  \\.                        # if led by a period...
(?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*   (?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|   \\[                         # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*    #    stuff
\\]                        #           ]
)                     #   ...further okay
)*
# address
|                     #  or
(?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|
\" (?:                      # opening quote...
[^\\\\\\x80-\\xff\\n\\015\"]                #   Anything except backslash and quote
|                     #    or
\\\\ [^\\x80-\\xff]           #   Escaped something (something != CR)
)* \"  # closing quote
)             # one word, optionally followed by....
(?:
[^()<>@,;:\".\\\\\\[\\]\\x80-\\xff\\000-\\010\\012-\\037]  |  # atom and space parts, or...
\\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)       |  # comments, or...

\" (?:                      # opening quote...
[^\\\\\\x80-\\xff\\n\\015\"]                #   Anything except backslash and quote
|                     #    or
\\\\ [^\\x80-\\xff]           #   Escaped something (something != CR)
)* \"  # closing quote
# quoted strings
)*
<  (?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*                     # leading <
(?:  @  (?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*    (?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|   \\[                         # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*    #    stuff
\\]                        #           ]
)                           # initial subdomain
(?:                                  #
(?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*  \\.                        # if led by a period...
(?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*   (?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|   \\[                         # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*    #    stuff
\\]                        #           ]
)                     #   ...further okay
)*

(?:  (?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*  ,  (?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*  @  (?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*    (?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|   \\[                         # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*    #    stuff
\\]                        #           ]
)                           # initial subdomain
(?:                                  #
(?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*  \\.                        # if led by a period...
(?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*   (?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|   \\[                         # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*    #    stuff
\\]                        #           ]
)                     #   ...further okay
)*
)* # further okay, if led by comma
:                                # closing colon
(?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*  )? #       optional route
(?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|
\" (?:                      # opening quote...
[^\\\\\\x80-\\xff\\n\\015\"]                #   Anything except backslash and quote
|                     #    or
\\\\ [^\\x80-\\xff]           #   Escaped something (something != CR)
)* \"  # closing quote
)                    # initial word
(?:  (?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*  \\.  (?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*   (?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|
\" (?:                      # opening quote...
[^\\\\\\x80-\\xff\\n\\015\"]                #   Anything except backslash and quote
|                     #    or
\\\\ [^\\x80-\\xff]           #   Escaped something (something != CR)
)* \"  # closing quote
)  )* # further okay, if led by a period
(?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*  @  (?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*    (?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|   \\[                         # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*    #    stuff
\\]                        #           ]
)                           # initial subdomain
(?:                                  #
(?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*  \\.                        # if led by a period...
(?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*   (?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|   \\[                         # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*    #    stuff
\\]                        #           ]
)                     #   ...further okay
)*
#       address spec
(?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*  > #                  trailing >
# name and address
)  (?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*                       # optional trailing comment",[extended,trim]))), 
    <<"\"/s=user/ou=host/o=place/prmd=uu.yy/admd= /c=gb/\"-re.lay">> = iolist_to_binary(join(re:split("\"/s=user/ou=host/o=place/prmd=uu.yy/admd= /c=gb/\"-re.lay","  (?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*                          # optional leading comment
(?:    (?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|
\" (?:                      # opening quote...
[^\\\\\\x80-\\xff\\n\\015\"]                #   Anything except backslash and quote
|                     #    or
\\\\ [^\\x80-\\xff]           #   Escaped something (something != CR)
)* \"  # closing quote
)                    # initial word
(?:  (?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*  \\.  (?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*   (?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|
\" (?:                      # opening quote...
[^\\\\\\x80-\\xff\\n\\015\"]                #   Anything except backslash and quote
|                     #    or
\\\\ [^\\x80-\\xff]           #   Escaped something (something != CR)
)* \"  # closing quote
)  )* # further okay, if led by a period
(?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*  @  (?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*    (?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|   \\[                         # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*    #    stuff
\\]                        #           ]
)                           # initial subdomain
(?:                                  #
(?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*  \\.                        # if led by a period...
(?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*   (?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|   \\[                         # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*    #    stuff
\\]                        #           ]
)                     #   ...further okay
)*
# address
|                     #  or
(?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|
\" (?:                      # opening quote...
[^\\\\\\x80-\\xff\\n\\015\"]                #   Anything except backslash and quote
|                     #    or
\\\\ [^\\x80-\\xff]           #   Escaped something (something != CR)
)* \"  # closing quote
)             # one word, optionally followed by....
(?:
[^()<>@,;:\".\\\\\\[\\]\\x80-\\xff\\000-\\010\\012-\\037]  |  # atom and space parts, or...
\\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)       |  # comments, or...

\" (?:                      # opening quote...
[^\\\\\\x80-\\xff\\n\\015\"]                #   Anything except backslash and quote
|                     #    or
\\\\ [^\\x80-\\xff]           #   Escaped something (something != CR)
)* \"  # closing quote
# quoted strings
)*
<  (?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*                     # leading <
(?:  @  (?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*    (?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|   \\[                         # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*    #    stuff
\\]                        #           ]
)                           # initial subdomain
(?:                                  #
(?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*  \\.                        # if led by a period...
(?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*   (?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|   \\[                         # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*    #    stuff
\\]                        #           ]
)                     #   ...further okay
)*

(?:  (?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*  ,  (?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*  @  (?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*    (?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|   \\[                         # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*    #    stuff
\\]                        #           ]
)                           # initial subdomain
(?:                                  #
(?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*  \\.                        # if led by a period...
(?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*   (?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|   \\[                         # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*    #    stuff
\\]                        #           ]
)                     #   ...further okay
)*
)* # further okay, if led by comma
:                                # closing colon
(?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*  )? #       optional route
(?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|
\" (?:                      # opening quote...
[^\\\\\\x80-\\xff\\n\\015\"]                #   Anything except backslash and quote
|                     #    or
\\\\ [^\\x80-\\xff]           #   Escaped something (something != CR)
)* \"  # closing quote
)                    # initial word
(?:  (?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*  \\.  (?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*   (?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|
\" (?:                      # opening quote...
[^\\\\\\x80-\\xff\\n\\015\"]                #   Anything except backslash and quote
|                     #    or
\\\\ [^\\x80-\\xff]           #   Escaped something (something != CR)
)* \"  # closing quote
)  )* # further okay, if led by a period
(?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*  @  (?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*    (?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|   \\[                         # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*    #    stuff
\\]                        #           ]
)                           # initial subdomain
(?:                                  #
(?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*  \\.                        # if led by a period...
(?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*   (?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|   \\[                         # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*    #    stuff
\\]                        #           ]
)                     #   ...further okay
)*
#       address spec
(?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*  > #                  trailing >
# name and address
)  (?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*                       # optional trailing comment",[extended,
                                                               {parts,2}]))), 
    <<"\"/s=user/ou=host/o=place/prmd=uu.yy/admd= /c=gb/\"-re.lay">> = iolist_to_binary(join(re:split("\"/s=user/ou=host/o=place/prmd=uu.yy/admd= /c=gb/\"-re.lay","  (?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*                          # optional leading comment
(?:    (?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|
\" (?:                      # opening quote...
[^\\\\\\x80-\\xff\\n\\015\"]                #   Anything except backslash and quote
|                     #    or
\\\\ [^\\x80-\\xff]           #   Escaped something (something != CR)
)* \"  # closing quote
)                    # initial word
(?:  (?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*  \\.  (?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*   (?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|
\" (?:                      # opening quote...
[^\\\\\\x80-\\xff\\n\\015\"]                #   Anything except backslash and quote
|                     #    or
\\\\ [^\\x80-\\xff]           #   Escaped something (something != CR)
)* \"  # closing quote
)  )* # further okay, if led by a period
(?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*  @  (?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*    (?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|   \\[                         # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*    #    stuff
\\]                        #           ]
)                           # initial subdomain
(?:                                  #
(?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*  \\.                        # if led by a period...
(?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*   (?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|   \\[                         # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*    #    stuff
\\]                        #           ]
)                     #   ...further okay
)*
# address
|                     #  or
(?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|
\" (?:                      # opening quote...
[^\\\\\\x80-\\xff\\n\\015\"]                #   Anything except backslash and quote
|                     #    or
\\\\ [^\\x80-\\xff]           #   Escaped something (something != CR)
)* \"  # closing quote
)             # one word, optionally followed by....
(?:
[^()<>@,;:\".\\\\\\[\\]\\x80-\\xff\\000-\\010\\012-\\037]  |  # atom and space parts, or...
\\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)       |  # comments, or...

\" (?:                      # opening quote...
[^\\\\\\x80-\\xff\\n\\015\"]                #   Anything except backslash and quote
|                     #    or
\\\\ [^\\x80-\\xff]           #   Escaped something (something != CR)
)* \"  # closing quote
# quoted strings
)*
<  (?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*                     # leading <
(?:  @  (?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*    (?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|   \\[                         # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*    #    stuff
\\]                        #           ]
)                           # initial subdomain
(?:                                  #
(?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*  \\.                        # if led by a period...
(?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*   (?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|   \\[                         # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*    #    stuff
\\]                        #           ]
)                     #   ...further okay
)*

(?:  (?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*  ,  (?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*  @  (?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*    (?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|   \\[                         # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*    #    stuff
\\]                        #           ]
)                           # initial subdomain
(?:                                  #
(?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*  \\.                        # if led by a period...
(?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*   (?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|   \\[                         # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*    #    stuff
\\]                        #           ]
)                     #   ...further okay
)*
)* # further okay, if led by comma
:                                # closing colon
(?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*  )? #       optional route
(?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|
\" (?:                      # opening quote...
[^\\\\\\x80-\\xff\\n\\015\"]                #   Anything except backslash and quote
|                     #    or
\\\\ [^\\x80-\\xff]           #   Escaped something (something != CR)
)* \"  # closing quote
)                    # initial word
(?:  (?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*  \\.  (?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*   (?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|
\" (?:                      # opening quote...
[^\\\\\\x80-\\xff\\n\\015\"]                #   Anything except backslash and quote
|                     #    or
\\\\ [^\\x80-\\xff]           #   Escaped something (something != CR)
)* \"  # closing quote
)  )* # further okay, if led by a period
(?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*  @  (?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*    (?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|   \\[                         # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*    #    stuff
\\]                        #           ]
)                           # initial subdomain
(?:                                  #
(?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*  \\.                        # if led by a period...
(?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*   (?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|   \\[                         # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*    #    stuff
\\]                        #           ]
)                     #   ...further okay
)*
#       address spec
(?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*  > #                  trailing >
# name and address
)  (?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*                       # optional trailing comment",[extended]))), 
    <<"A missing angle <user.where">> = iolist_to_binary(join(re:split("A missing angle <user.where","  (?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*                          # optional leading comment
(?:    (?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|
\" (?:                      # opening quote...
[^\\\\\\x80-\\xff\\n\\015\"]                #   Anything except backslash and quote
|                     #    or
\\\\ [^\\x80-\\xff]           #   Escaped something (something != CR)
)* \"  # closing quote
)                    # initial word
(?:  (?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*  \\.  (?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*   (?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|
\" (?:                      # opening quote...
[^\\\\\\x80-\\xff\\n\\015\"]                #   Anything except backslash and quote
|                     #    or
\\\\ [^\\x80-\\xff]           #   Escaped something (something != CR)
)* \"  # closing quote
)  )* # further okay, if led by a period
(?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*  @  (?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*    (?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|   \\[                         # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*    #    stuff
\\]                        #           ]
)                           # initial subdomain
(?:                                  #
(?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*  \\.                        # if led by a period...
(?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*   (?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|   \\[                         # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*    #    stuff
\\]                        #           ]
)                     #   ...further okay
)*
# address
|                     #  or
(?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|
\" (?:                      # opening quote...
[^\\\\\\x80-\\xff\\n\\015\"]                #   Anything except backslash and quote
|                     #    or
\\\\ [^\\x80-\\xff]           #   Escaped something (something != CR)
)* \"  # closing quote
)             # one word, optionally followed by....
(?:
[^()<>@,;:\".\\\\\\[\\]\\x80-\\xff\\000-\\010\\012-\\037]  |  # atom and space parts, or...
\\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)       |  # comments, or...

\" (?:                      # opening quote...
[^\\\\\\x80-\\xff\\n\\015\"]                #   Anything except backslash and quote
|                     #    or
\\\\ [^\\x80-\\xff]           #   Escaped something (something != CR)
)* \"  # closing quote
# quoted strings
)*
<  (?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*                     # leading <
(?:  @  (?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*    (?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|   \\[                         # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*    #    stuff
\\]                        #           ]
)                           # initial subdomain
(?:                                  #
(?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*  \\.                        # if led by a period...
(?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*   (?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|   \\[                         # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*    #    stuff
\\]                        #           ]
)                     #   ...further okay
)*

(?:  (?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*  ,  (?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*  @  (?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*    (?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|   \\[                         # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*    #    stuff
\\]                        #           ]
)                           # initial subdomain
(?:                                  #
(?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*  \\.                        # if led by a period...
(?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*   (?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|   \\[                         # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*    #    stuff
\\]                        #           ]
)                     #   ...further okay
)*
)* # further okay, if led by comma
:                                # closing colon
(?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*  )? #       optional route
(?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|
\" (?:                      # opening quote...
[^\\\\\\x80-\\xff\\n\\015\"]                #   Anything except backslash and quote
|                     #    or
\\\\ [^\\x80-\\xff]           #   Escaped something (something != CR)
)* \"  # closing quote
)                    # initial word
(?:  (?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*  \\.  (?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*   (?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|
\" (?:                      # opening quote...
[^\\\\\\x80-\\xff\\n\\015\"]                #   Anything except backslash and quote
|                     #    or
\\\\ [^\\x80-\\xff]           #   Escaped something (something != CR)
)* \"  # closing quote
)  )* # further okay, if led by a period
(?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*  @  (?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*    (?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|   \\[                         # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*    #    stuff
\\]                        #           ]
)                           # initial subdomain
(?:                                  #
(?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*  \\.                        # if led by a period...
(?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*   (?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|   \\[                         # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*    #    stuff
\\]                        #           ]
)                     #   ...further okay
)*
#       address spec
(?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*  > #                  trailing >
# name and address
)  (?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*                       # optional trailing comment",[extended,trim]))), 
    <<"A missing angle <user.where">> = iolist_to_binary(join(re:split("A missing angle <user.where","  (?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*                          # optional leading comment
(?:    (?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|
\" (?:                      # opening quote...
[^\\\\\\x80-\\xff\\n\\015\"]                #   Anything except backslash and quote
|                     #    or
\\\\ [^\\x80-\\xff]           #   Escaped something (something != CR)
)* \"  # closing quote
)                    # initial word
(?:  (?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*  \\.  (?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*   (?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|
\" (?:                      # opening quote...
[^\\\\\\x80-\\xff\\n\\015\"]                #   Anything except backslash and quote
|                     #    or
\\\\ [^\\x80-\\xff]           #   Escaped something (something != CR)
)* \"  # closing quote
)  )* # further okay, if led by a period
(?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*  @  (?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*    (?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|   \\[                         # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*    #    stuff
\\]                        #           ]
)                           # initial subdomain
(?:                                  #
(?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*  \\.                        # if led by a period...
(?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*   (?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|   \\[                         # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*    #    stuff
\\]                        #           ]
)                     #   ...further okay
)*
# address
|                     #  or
(?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|
\" (?:                      # opening quote...
[^\\\\\\x80-\\xff\\n\\015\"]                #   Anything except backslash and quote
|                     #    or
\\\\ [^\\x80-\\xff]           #   Escaped something (something != CR)
)* \"  # closing quote
)             # one word, optionally followed by....
(?:
[^()<>@,;:\".\\\\\\[\\]\\x80-\\xff\\000-\\010\\012-\\037]  |  # atom and space parts, or...
\\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)       |  # comments, or...

\" (?:                      # opening quote...
[^\\\\\\x80-\\xff\\n\\015\"]                #   Anything except backslash and quote
|                     #    or
\\\\ [^\\x80-\\xff]           #   Escaped something (something != CR)
)* \"  # closing quote
# quoted strings
)*
<  (?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*                     # leading <
(?:  @  (?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*    (?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|   \\[                         # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*    #    stuff
\\]                        #           ]
)                           # initial subdomain
(?:                                  #
(?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*  \\.                        # if led by a period...
(?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*   (?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|   \\[                         # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*    #    stuff
\\]                        #           ]
)                     #   ...further okay
)*

(?:  (?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*  ,  (?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*  @  (?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*    (?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|   \\[                         # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*    #    stuff
\\]                        #           ]
)                           # initial subdomain
(?:                                  #
(?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*  \\.                        # if led by a period...
(?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*   (?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|   \\[                         # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*    #    stuff
\\]                        #           ]
)                     #   ...further okay
)*
)* # further okay, if led by comma
:                                # closing colon
(?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*  )? #       optional route
(?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|
\" (?:                      # opening quote...
[^\\\\\\x80-\\xff\\n\\015\"]                #   Anything except backslash and quote
|                     #    or
\\\\ [^\\x80-\\xff]           #   Escaped something (something != CR)
)* \"  # closing quote
)                    # initial word
(?:  (?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*  \\.  (?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*   (?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|
\" (?:                      # opening quote...
[^\\\\\\x80-\\xff\\n\\015\"]                #   Anything except backslash and quote
|                     #    or
\\\\ [^\\x80-\\xff]           #   Escaped something (something != CR)
)* \"  # closing quote
)  )* # further okay, if led by a period
(?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*  @  (?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*    (?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|   \\[                         # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*    #    stuff
\\]                        #           ]
)                           # initial subdomain
(?:                                  #
(?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*  \\.                        # if led by a period...
(?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*   (?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|   \\[                         # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*    #    stuff
\\]                        #           ]
)                     #   ...further okay
)*
#       address spec
(?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*  > #                  trailing >
# name and address
)  (?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*                       # optional trailing comment",[extended,
                                                               {parts,2}]))), 
    <<"A missing angle <user.where">> = iolist_to_binary(join(re:split("A missing angle <user.where","  (?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*                          # optional leading comment
(?:    (?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|
\" (?:                      # opening quote...
[^\\\\\\x80-\\xff\\n\\015\"]                #   Anything except backslash and quote
|                     #    or
\\\\ [^\\x80-\\xff]           #   Escaped something (something != CR)
)* \"  # closing quote
)                    # initial word
(?:  (?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*  \\.  (?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*   (?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|
\" (?:                      # opening quote...
[^\\\\\\x80-\\xff\\n\\015\"]                #   Anything except backslash and quote
|                     #    or
\\\\ [^\\x80-\\xff]           #   Escaped something (something != CR)
)* \"  # closing quote
)  )* # further okay, if led by a period
(?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*  @  (?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*    (?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|   \\[                         # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*    #    stuff
\\]                        #           ]
)                           # initial subdomain
(?:                                  #
(?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*  \\.                        # if led by a period...
(?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*   (?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|   \\[                         # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*    #    stuff
\\]                        #           ]
)                     #   ...further okay
)*
# address
|                     #  or
(?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|
\" (?:                      # opening quote...
[^\\\\\\x80-\\xff\\n\\015\"]                #   Anything except backslash and quote
|                     #    or
\\\\ [^\\x80-\\xff]           #   Escaped something (something != CR)
)* \"  # closing quote
)             # one word, optionally followed by....
(?:
[^()<>@,;:\".\\\\\\[\\]\\x80-\\xff\\000-\\010\\012-\\037]  |  # atom and space parts, or...
\\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)       |  # comments, or...

\" (?:                      # opening quote...
[^\\\\\\x80-\\xff\\n\\015\"]                #   Anything except backslash and quote
|                     #    or
\\\\ [^\\x80-\\xff]           #   Escaped something (something != CR)
)* \"  # closing quote
# quoted strings
)*
<  (?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*                     # leading <
(?:  @  (?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*    (?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|   \\[                         # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*    #    stuff
\\]                        #           ]
)                           # initial subdomain
(?:                                  #
(?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*  \\.                        # if led by a period...
(?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*   (?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|   \\[                         # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*    #    stuff
\\]                        #           ]
)                     #   ...further okay
)*

(?:  (?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*  ,  (?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*  @  (?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*    (?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|   \\[                         # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*    #    stuff
\\]                        #           ]
)                           # initial subdomain
(?:                                  #
(?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*  \\.                        # if led by a period...
(?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*   (?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|   \\[                         # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*    #    stuff
\\]                        #           ]
)                     #   ...further okay
)*
)* # further okay, if led by comma
:                                # closing colon
(?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*  )? #       optional route
(?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|
\" (?:                      # opening quote...
[^\\\\\\x80-\\xff\\n\\015\"]                #   Anything except backslash and quote
|                     #    or
\\\\ [^\\x80-\\xff]           #   Escaped something (something != CR)
)* \"  # closing quote
)                    # initial word
(?:  (?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*  \\.  (?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*   (?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|
\" (?:                      # opening quote...
[^\\\\\\x80-\\xff\\n\\015\"]                #   Anything except backslash and quote
|                     #    or
\\\\ [^\\x80-\\xff]           #   Escaped something (something != CR)
)* \"  # closing quote
)  )* # further okay, if led by a period
(?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*  @  (?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*    (?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|   \\[                         # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*    #    stuff
\\]                        #           ]
)                           # initial subdomain
(?:                                  #
(?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*  \\.                        # if led by a period...
(?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*   (?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|   \\[                         # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*    #    stuff
\\]                        #           ]
)                     #   ...further okay
)*
#       address spec
(?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*  > #                  trailing >
# name and address
)  (?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*                       # optional trailing comment",[extended]))), 
    <<"*** Failers">> = iolist_to_binary(join(re:split("*** Failers","  (?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*                          # optional leading comment
(?:    (?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|
\" (?:                      # opening quote...
[^\\\\\\x80-\\xff\\n\\015\"]                #   Anything except backslash and quote
|                     #    or
\\\\ [^\\x80-\\xff]           #   Escaped something (something != CR)
)* \"  # closing quote
)                    # initial word
(?:  (?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*  \\.  (?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*   (?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|
\" (?:                      # opening quote...
[^\\\\\\x80-\\xff\\n\\015\"]                #   Anything except backslash and quote
|                     #    or
\\\\ [^\\x80-\\xff]           #   Escaped something (something != CR)
)* \"  # closing quote
)  )* # further okay, if led by a period
(?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*  @  (?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*    (?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|   \\[                         # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*    #    stuff
\\]                        #           ]
)                           # initial subdomain
(?:                                  #
(?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*  \\.                        # if led by a period...
(?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*   (?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|   \\[                         # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*    #    stuff
\\]                        #           ]
)                     #   ...further okay
)*
# address
|                     #  or
(?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|
\" (?:                      # opening quote...
[^\\\\\\x80-\\xff\\n\\015\"]                #   Anything except backslash and quote
|                     #    or
\\\\ [^\\x80-\\xff]           #   Escaped something (something != CR)
)* \"  # closing quote
)             # one word, optionally followed by....
(?:
[^()<>@,;:\".\\\\\\[\\]\\x80-\\xff\\000-\\010\\012-\\037]  |  # atom and space parts, or...
\\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)       |  # comments, or...

\" (?:                      # opening quote...
[^\\\\\\x80-\\xff\\n\\015\"]                #   Anything except backslash and quote
|                     #    or
\\\\ [^\\x80-\\xff]           #   Escaped something (something != CR)
)* \"  # closing quote
# quoted strings
)*
<  (?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*                     # leading <
(?:  @  (?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*    (?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|   \\[                         # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*    #    stuff
\\]                        #           ]
)                           # initial subdomain
(?:                                  #
(?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*  \\.                        # if led by a period...
(?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*   (?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|   \\[                         # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*    #    stuff
\\]                        #           ]
)                     #   ...further okay
)*

(?:  (?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*  ,  (?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*  @  (?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*    (?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|   \\[                         # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*    #    stuff
\\]                        #           ]
)                           # initial subdomain
(?:                                  #
(?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*  \\.                        # if led by a period...
(?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*   (?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|   \\[                         # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*    #    stuff
\\]                        #           ]
)                     #   ...further okay
)*
)* # further okay, if led by comma
:                                # closing colon
(?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*  )? #       optional route
(?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|
\" (?:                      # opening quote...
[^\\\\\\x80-\\xff\\n\\015\"]                #   Anything except backslash and quote
|                     #    or
\\\\ [^\\x80-\\xff]           #   Escaped something (something != CR)
)* \"  # closing quote
)                    # initial word
(?:  (?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*  \\.  (?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*   (?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|
\" (?:                      # opening quote...
[^\\\\\\x80-\\xff\\n\\015\"]                #   Anything except backslash and quote
|                     #    or
\\\\ [^\\x80-\\xff]           #   Escaped something (something != CR)
)* \"  # closing quote
)  )* # further okay, if led by a period
(?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*  @  (?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*    (?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|   \\[                         # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*    #    stuff
\\]                        #           ]
)                           # initial subdomain
(?:                                  #
(?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*  \\.                        # if led by a period...
(?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*   (?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|   \\[                         # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*    #    stuff
\\]                        #           ]
)                     #   ...further okay
)*
#       address spec
(?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*  > #                  trailing >
# name and address
)  (?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*                       # optional trailing comment",[extended,trim]))), 
    <<"*** Failers">> = iolist_to_binary(join(re:split("*** Failers","  (?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*                          # optional leading comment
(?:    (?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|
\" (?:                      # opening quote...
[^\\\\\\x80-\\xff\\n\\015\"]                #   Anything except backslash and quote
|                     #    or
\\\\ [^\\x80-\\xff]           #   Escaped something (something != CR)
)* \"  # closing quote
)                    # initial word
(?:  (?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*  \\.  (?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*   (?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|
\" (?:                      # opening quote...
[^\\\\\\x80-\\xff\\n\\015\"]                #   Anything except backslash and quote
|                     #    or
\\\\ [^\\x80-\\xff]           #   Escaped something (something != CR)
)* \"  # closing quote
)  )* # further okay, if led by a period
(?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*  @  (?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*    (?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|   \\[                         # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*    #    stuff
\\]                        #           ]
)                           # initial subdomain
(?:                                  #
(?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*  \\.                        # if led by a period...
(?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*   (?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|   \\[                         # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*    #    stuff
\\]                        #           ]
)                     #   ...further okay
)*
# address
|                     #  or
(?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|
\" (?:                      # opening quote...
[^\\\\\\x80-\\xff\\n\\015\"]                #   Anything except backslash and quote
|                     #    or
\\\\ [^\\x80-\\xff]           #   Escaped something (something != CR)
)* \"  # closing quote
)             # one word, optionally followed by....
(?:
[^()<>@,;:\".\\\\\\[\\]\\x80-\\xff\\000-\\010\\012-\\037]  |  # atom and space parts, or...
\\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)       |  # comments, or...

\" (?:                      # opening quote...
[^\\\\\\x80-\\xff\\n\\015\"]                #   Anything except backslash and quote
|                     #    or
\\\\ [^\\x80-\\xff]           #   Escaped something (something != CR)
)* \"  # closing quote
# quoted strings
)*
<  (?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*                     # leading <
(?:  @  (?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*    (?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|   \\[                         # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*    #    stuff
\\]                        #           ]
)                           # initial subdomain
(?:                                  #
(?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*  \\.                        # if led by a period...
(?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*   (?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|   \\[                         # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*    #    stuff
\\]                        #           ]
)                     #   ...further okay
)*

(?:  (?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*  ,  (?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*  @  (?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*    (?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|   \\[                         # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*    #    stuff
\\]                        #           ]
)                           # initial subdomain
(?:                                  #
(?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*  \\.                        # if led by a period...
(?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*   (?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|   \\[                         # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*    #    stuff
\\]                        #           ]
)                     #   ...further okay
)*
)* # further okay, if led by comma
:                                # closing colon
(?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*  )? #       optional route
(?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|
\" (?:                      # opening quote...
[^\\\\\\x80-\\xff\\n\\015\"]                #   Anything except backslash and quote
|                     #    or
\\\\ [^\\x80-\\xff]           #   Escaped something (something != CR)
)* \"  # closing quote
)                    # initial word
(?:  (?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*  \\.  (?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*   (?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|
\" (?:                      # opening quote...
[^\\\\\\x80-\\xff\\n\\015\"]                #   Anything except backslash and quote
|                     #    or
\\\\ [^\\x80-\\xff]           #   Escaped something (something != CR)
)* \"  # closing quote
)  )* # further okay, if led by a period
(?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*  @  (?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*    (?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|   \\[                         # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*    #    stuff
\\]                        #           ]
)                           # initial subdomain
(?:                                  #
(?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*  \\.                        # if led by a period...
(?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*   (?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|   \\[                         # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*    #    stuff
\\]                        #           ]
)                     #   ...further okay
)*
#       address spec
(?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*  > #                  trailing >
# name and address
)  (?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*                       # optional trailing comment",[extended,
                                                               {parts,2}]))), 
    <<"*** Failers">> = iolist_to_binary(join(re:split("*** Failers","  (?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*                          # optional leading comment
(?:    (?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|
\" (?:                      # opening quote...
[^\\\\\\x80-\\xff\\n\\015\"]                #   Anything except backslash and quote
|                     #    or
\\\\ [^\\x80-\\xff]           #   Escaped something (something != CR)
)* \"  # closing quote
)                    # initial word
(?:  (?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*  \\.  (?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*   (?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|
\" (?:                      # opening quote...
[^\\\\\\x80-\\xff\\n\\015\"]                #   Anything except backslash and quote
|                     #    or
\\\\ [^\\x80-\\xff]           #   Escaped something (something != CR)
)* \"  # closing quote
)  )* # further okay, if led by a period
(?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*  @  (?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*    (?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|   \\[                         # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*    #    stuff
\\]                        #           ]
)                           # initial subdomain
(?:                                  #
(?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*  \\.                        # if led by a period...
(?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*   (?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|   \\[                         # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*    #    stuff
\\]                        #           ]
)                     #   ...further okay
)*
# address
|                     #  or
(?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|
\" (?:                      # opening quote...
[^\\\\\\x80-\\xff\\n\\015\"]                #   Anything except backslash and quote
|                     #    or
\\\\ [^\\x80-\\xff]           #   Escaped something (something != CR)
)* \"  # closing quote
)             # one word, optionally followed by....
(?:
[^()<>@,;:\".\\\\\\[\\]\\x80-\\xff\\000-\\010\\012-\\037]  |  # atom and space parts, or...
\\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)       |  # comments, or...

\" (?:                      # opening quote...
[^\\\\\\x80-\\xff\\n\\015\"]                #   Anything except backslash and quote
|                     #    or
\\\\ [^\\x80-\\xff]           #   Escaped something (something != CR)
)* \"  # closing quote
# quoted strings
)*
<  (?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*                     # leading <
(?:  @  (?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*    (?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|   \\[                         # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*    #    stuff
\\]                        #           ]
)                           # initial subdomain
(?:                                  #
(?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*  \\.                        # if led by a period...
(?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*   (?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|   \\[                         # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*    #    stuff
\\]                        #           ]
)                     #   ...further okay
)*

(?:  (?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*  ,  (?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*  @  (?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*    (?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|   \\[                         # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*    #    stuff
\\]                        #           ]
)                           # initial subdomain
(?:                                  #
(?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*  \\.                        # if led by a period...
(?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*   (?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|   \\[                         # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*    #    stuff
\\]                        #           ]
)                     #   ...further okay
)*
)* # further okay, if led by comma
:                                # closing colon
(?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*  )? #       optional route
(?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|
\" (?:                      # opening quote...
[^\\\\\\x80-\\xff\\n\\015\"]                #   Anything except backslash and quote
|                     #    or
\\\\ [^\\x80-\\xff]           #   Escaped something (something != CR)
)* \"  # closing quote
)                    # initial word
(?:  (?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*  \\.  (?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*   (?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|
\" (?:                      # opening quote...
[^\\\\\\x80-\\xff\\n\\015\"]                #   Anything except backslash and quote
|                     #    or
\\\\ [^\\x80-\\xff]           #   Escaped something (something != CR)
)* \"  # closing quote
)  )* # further okay, if led by a period
(?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*  @  (?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*    (?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|   \\[                         # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*    #    stuff
\\]                        #           ]
)                           # initial subdomain
(?:                                  #
(?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*  \\.                        # if led by a period...
(?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*   (?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|   \\[                         # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*    #    stuff
\\]                        #           ]
)                     #   ...further okay
)*
#       address spec
(?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*  > #                  trailing >
# name and address
)  (?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*                       # optional trailing comment",[extended]))), 
    <<"The quick brown fox">> = iolist_to_binary(join(re:split("The quick brown fox","  (?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*                          # optional leading comment
(?:    (?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|
\" (?:                      # opening quote...
[^\\\\\\x80-\\xff\\n\\015\"]                #   Anything except backslash and quote
|                     #    or
\\\\ [^\\x80-\\xff]           #   Escaped something (something != CR)
)* \"  # closing quote
)                    # initial word
(?:  (?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*  \\.  (?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*   (?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|
\" (?:                      # opening quote...
[^\\\\\\x80-\\xff\\n\\015\"]                #   Anything except backslash and quote
|                     #    or
\\\\ [^\\x80-\\xff]           #   Escaped something (something != CR)
)* \"  # closing quote
)  )* # further okay, if led by a period
(?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*  @  (?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*    (?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|   \\[                         # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*    #    stuff
\\]                        #           ]
)                           # initial subdomain
(?:                                  #
(?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*  \\.                        # if led by a period...
(?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*   (?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|   \\[                         # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*    #    stuff
\\]                        #           ]
)                     #   ...further okay
)*
# address
|                     #  or
(?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|
\" (?:                      # opening quote...
[^\\\\\\x80-\\xff\\n\\015\"]                #   Anything except backslash and quote
|                     #    or
\\\\ [^\\x80-\\xff]           #   Escaped something (something != CR)
)* \"  # closing quote
)             # one word, optionally followed by....
(?:
[^()<>@,;:\".\\\\\\[\\]\\x80-\\xff\\000-\\010\\012-\\037]  |  # atom and space parts, or...
\\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)       |  # comments, or...

\" (?:                      # opening quote...
[^\\\\\\x80-\\xff\\n\\015\"]                #   Anything except backslash and quote
|                     #    or
\\\\ [^\\x80-\\xff]           #   Escaped something (something != CR)
)* \"  # closing quote
# quoted strings
)*
<  (?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*                     # leading <
(?:  @  (?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*    (?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|   \\[                         # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*    #    stuff
\\]                        #           ]
)                           # initial subdomain
(?:                                  #
(?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*  \\.                        # if led by a period...
(?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*   (?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|   \\[                         # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*    #    stuff
\\]                        #           ]
)                     #   ...further okay
)*

(?:  (?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*  ,  (?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*  @  (?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*    (?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|   \\[                         # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*    #    stuff
\\]                        #           ]
)                           # initial subdomain
(?:                                  #
(?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*  \\.                        # if led by a period...
(?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*   (?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|   \\[                         # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*    #    stuff
\\]                        #           ]
)                     #   ...further okay
)*
)* # further okay, if led by comma
:                                # closing colon
(?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*  )? #       optional route
(?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|
\" (?:                      # opening quote...
[^\\\\\\x80-\\xff\\n\\015\"]                #   Anything except backslash and quote
|                     #    or
\\\\ [^\\x80-\\xff]           #   Escaped something (something != CR)
)* \"  # closing quote
)                    # initial word
(?:  (?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*  \\.  (?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*   (?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|
\" (?:                      # opening quote...
[^\\\\\\x80-\\xff\\n\\015\"]                #   Anything except backslash and quote
|                     #    or
\\\\ [^\\x80-\\xff]           #   Escaped something (something != CR)
)* \"  # closing quote
)  )* # further okay, if led by a period
(?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*  @  (?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*    (?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|   \\[                         # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*    #    stuff
\\]                        #           ]
)                           # initial subdomain
(?:                                  #
(?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*  \\.                        # if led by a period...
(?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*   (?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|   \\[                         # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*    #    stuff
\\]                        #           ]
)                     #   ...further okay
)*
#       address spec
(?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*  > #                  trailing >
# name and address
)  (?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*                       # optional trailing comment",[extended,trim]))), 
    <<"The quick brown fox">> = iolist_to_binary(join(re:split("The quick brown fox","  (?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*                          # optional leading comment
(?:    (?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|
\" (?:                      # opening quote...
[^\\\\\\x80-\\xff\\n\\015\"]                #   Anything except backslash and quote
|                     #    or
\\\\ [^\\x80-\\xff]           #   Escaped something (something != CR)
)* \"  # closing quote
)                    # initial word
(?:  (?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*  \\.  (?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*   (?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|
\" (?:                      # opening quote...
[^\\\\\\x80-\\xff\\n\\015\"]                #   Anything except backslash and quote
|                     #    or
\\\\ [^\\x80-\\xff]           #   Escaped something (something != CR)
)* \"  # closing quote
)  )* # further okay, if led by a period
(?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*  @  (?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*    (?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|   \\[                         # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*    #    stuff
\\]                        #           ]
)                           # initial subdomain
(?:                                  #
(?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*  \\.                        # if led by a period...
(?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*   (?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|   \\[                         # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*    #    stuff
\\]                        #           ]
)                     #   ...further okay
)*
# address
|                     #  or
(?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|
\" (?:                      # opening quote...
[^\\\\\\x80-\\xff\\n\\015\"]                #   Anything except backslash and quote
|                     #    or
\\\\ [^\\x80-\\xff]           #   Escaped something (something != CR)
)* \"  # closing quote
)             # one word, optionally followed by....
(?:
[^()<>@,;:\".\\\\\\[\\]\\x80-\\xff\\000-\\010\\012-\\037]  |  # atom and space parts, or...
\\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)       |  # comments, or...

\" (?:                      # opening quote...
[^\\\\\\x80-\\xff\\n\\015\"]                #   Anything except backslash and quote
|                     #    or
\\\\ [^\\x80-\\xff]           #   Escaped something (something != CR)
)* \"  # closing quote
# quoted strings
)*
<  (?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*                     # leading <
(?:  @  (?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*    (?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|   \\[                         # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*    #    stuff
\\]                        #           ]
)                           # initial subdomain
(?:                                  #
(?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*  \\.                        # if led by a period...
(?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*   (?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|   \\[                         # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*    #    stuff
\\]                        #           ]
)                     #   ...further okay
)*

(?:  (?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*  ,  (?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*  @  (?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*    (?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|   \\[                         # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*    #    stuff
\\]                        #           ]
)                           # initial subdomain
(?:                                  #
(?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*  \\.                        # if led by a period...
(?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*   (?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|   \\[                         # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*    #    stuff
\\]                        #           ]
)                     #   ...further okay
)*
)* # further okay, if led by comma
:                                # closing colon
(?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*  )? #       optional route
(?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|
\" (?:                      # opening quote...
[^\\\\\\x80-\\xff\\n\\015\"]                #   Anything except backslash and quote
|                     #    or
\\\\ [^\\x80-\\xff]           #   Escaped something (something != CR)
)* \"  # closing quote
)                    # initial word
(?:  (?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*  \\.  (?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*   (?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|
\" (?:                      # opening quote...
[^\\\\\\x80-\\xff\\n\\015\"]                #   Anything except backslash and quote
|                     #    or
\\\\ [^\\x80-\\xff]           #   Escaped something (something != CR)
)* \"  # closing quote
)  )* # further okay, if led by a period
(?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*  @  (?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*    (?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|   \\[                         # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*    #    stuff
\\]                        #           ]
)                           # initial subdomain
(?:                                  #
(?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*  \\.                        # if led by a period...
(?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*   (?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|   \\[                         # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*    #    stuff
\\]                        #           ]
)                     #   ...further okay
)*
#       address spec
(?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*  > #                  trailing >
# name and address
)  (?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*                       # optional trailing comment",[extended,
                                                               {parts,2}]))), 
    <<"The quick brown fox">> = iolist_to_binary(join(re:split("The quick brown fox","  (?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*                          # optional leading comment
(?:    (?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|
\" (?:                      # opening quote...
[^\\\\\\x80-\\xff\\n\\015\"]                #   Anything except backslash and quote
|                     #    or
\\\\ [^\\x80-\\xff]           #   Escaped something (something != CR)
)* \"  # closing quote
)                    # initial word
(?:  (?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*  \\.  (?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*   (?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|
\" (?:                      # opening quote...
[^\\\\\\x80-\\xff\\n\\015\"]                #   Anything except backslash and quote
|                     #    or
\\\\ [^\\x80-\\xff]           #   Escaped something (something != CR)
)* \"  # closing quote
)  )* # further okay, if led by a period
(?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*  @  (?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*    (?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|   \\[                         # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*    #    stuff
\\]                        #           ]
)                           # initial subdomain
(?:                                  #
(?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*  \\.                        # if led by a period...
(?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*   (?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|   \\[                         # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*    #    stuff
\\]                        #           ]
)                     #   ...further okay
)*
# address
|                     #  or
(?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|
\" (?:                      # opening quote...
[^\\\\\\x80-\\xff\\n\\015\"]                #   Anything except backslash and quote
|                     #    or
\\\\ [^\\x80-\\xff]           #   Escaped something (something != CR)
)* \"  # closing quote
)             # one word, optionally followed by....
(?:
[^()<>@,;:\".\\\\\\[\\]\\x80-\\xff\\000-\\010\\012-\\037]  |  # atom and space parts, or...
\\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)       |  # comments, or...

\" (?:                      # opening quote...
[^\\\\\\x80-\\xff\\n\\015\"]                #   Anything except backslash and quote
|                     #    or
\\\\ [^\\x80-\\xff]           #   Escaped something (something != CR)
)* \"  # closing quote
# quoted strings
)*
<  (?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*                     # leading <
(?:  @  (?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*    (?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|   \\[                         # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*    #    stuff
\\]                        #           ]
)                           # initial subdomain
(?:                                  #
(?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*  \\.                        # if led by a period...
(?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*   (?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|   \\[                         # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*    #    stuff
\\]                        #           ]
)                     #   ...further okay
)*

(?:  (?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*  ,  (?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*  @  (?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*    (?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|   \\[                         # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*    #    stuff
\\]                        #           ]
)                           # initial subdomain
(?:                                  #
(?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*  \\.                        # if led by a period...
(?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*   (?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|   \\[                         # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*    #    stuff
\\]                        #           ]
)                     #   ...further okay
)*
)* # further okay, if led by comma
:                                # closing colon
(?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*  )? #       optional route
(?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|
\" (?:                      # opening quote...
[^\\\\\\x80-\\xff\\n\\015\"]                #   Anything except backslash and quote
|                     #    or
\\\\ [^\\x80-\\xff]           #   Escaped something (something != CR)
)* \"  # closing quote
)                    # initial word
(?:  (?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*  \\.  (?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*   (?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|
\" (?:                      # opening quote...
[^\\\\\\x80-\\xff\\n\\015\"]                #   Anything except backslash and quote
|                     #    or
\\\\ [^\\x80-\\xff]           #   Escaped something (something != CR)
)* \"  # closing quote
)  )* # further okay, if led by a period
(?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*  @  (?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*    (?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|   \\[                         # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*    #    stuff
\\]                        #           ]
)                           # initial subdomain
(?:                                  #
(?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*  \\.                        # if led by a period...
(?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*   (?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|   \\[                         # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*    #    stuff
\\]                        #           ]
)                     #   ...further okay
)*
#       address spec
(?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*  > #                  trailing >
# name and address
)  (?: [\\040\\t] |  \\(
(?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  |  \\( (?:  [^\\\\\\x80-\\xff\\n\\015()]  |  \\\\ [^\\x80-\\xff]  )* \\)  )*
\\)  )*                       # optional trailing comment",[extended]))), 
    <<"Alan Other <user.ain>">> = iolist_to_binary(join(re:split("Alan Other <user.ain>","[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
# optional leading comment
(?:
(?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
# Atom
|                       #  or
\"                                     # \"
[^\\\\\\x80-\\xff\\n\\015\"] *                            #   normal
(?:  \\\\ [^\\x80-\\xff]  [^\\\\\\x80-\\xff\\n\\015\"] * )*        #   ( special normal* )*
\"                                     #        \"
# Quoted string
)
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
(?:
\\.
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
(?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
# Atom
|                       #  or
\"                                     # \"
[^\\\\\\x80-\\xff\\n\\015\"] *                            #   normal
(?:  \\\\ [^\\x80-\\xff]  [^\\\\\\x80-\\xff\\n\\015\"] * )*        #   ( special normal* )*
\"                                     #        \"
# Quoted string
)
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
# additional words
)*
@
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
(?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|
\\[                            # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*     #    stuff
\\]                           #           ]
)
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
# optional trailing comments
(?:
\\.
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
(?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|
\\[                            # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*     #    stuff
\\]                           #           ]
)
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
# optional trailing comments
)*
# address
|                             #  or
(?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
# Atom
|                       #  or
\"                                     # \"
[^\\\\\\x80-\\xff\\n\\015\"] *                            #   normal
(?:  \\\\ [^\\x80-\\xff]  [^\\\\\\x80-\\xff\\n\\015\"] * )*        #   ( special normal* )*
\"                                     #        \"
# Quoted string
)
# leading word
[^()<>@,;:\".\\\\\\[\\]\\x80-\\xff\\000-\\010\\012-\\037] *               # \"normal\" atoms and or spaces
(?:
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
|
\"                                     # \"
[^\\\\\\x80-\\xff\\n\\015\"] *                            #   normal
(?:  \\\\ [^\\x80-\\xff]  [^\\\\\\x80-\\xff\\n\\015\"] * )*        #   ( special normal* )*
\"                                     #        \"
) # \"special\" comment or quoted string
[^()<>@,;:\".\\\\\\[\\]\\x80-\\xff\\000-\\010\\012-\\037] *            #  more \"normal\"
)*
<
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
# <
(?:
@
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
(?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|
\\[                            # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*     #    stuff
\\]                           #           ]
)
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
# optional trailing comments
(?:
\\.
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
(?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|
\\[                            # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*     #    stuff
\\]                           #           ]
)
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
# optional trailing comments
)*
(?: ,
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
@
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
(?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|
\\[                            # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*     #    stuff
\\]                           #           ]
)
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
# optional trailing comments
(?:
\\.
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
(?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|
\\[                            # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*     #    stuff
\\]                           #           ]
)
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
# optional trailing comments
)*
)*  # additional domains
:
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
# optional trailing comments
)?     #       optional route
(?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
# Atom
|                       #  or
\"                                     # \"
[^\\\\\\x80-\\xff\\n\\015\"] *                            #   normal
(?:  \\\\ [^\\x80-\\xff]  [^\\\\\\x80-\\xff\\n\\015\"] * )*        #   ( special normal* )*
\"                                     #        \"
# Quoted string
)
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
(?:
\\.
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
(?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
# Atom
|                       #  or
\"                                     # \"
[^\\\\\\x80-\\xff\\n\\015\"] *                            #   normal
(?:  \\\\ [^\\x80-\\xff]  [^\\\\\\x80-\\xff\\n\\015\"] * )*        #   ( special normal* )*
\"                                     #        \"
# Quoted string
)
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
# additional words
)*
@
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
(?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|
\\[                            # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*     #    stuff
\\]                           #           ]
)
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
# optional trailing comments
(?:
\\.
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
(?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|
\\[                            # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*     #    stuff
\\]                           #           ]
)
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
# optional trailing comments
)*
#       address spec
>                    #                 >
# name and address
)",[extended,trim]))), 
    <<"Alan Other <user.ain>">> = iolist_to_binary(join(re:split("Alan Other <user.ain>","[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
# optional leading comment
(?:
(?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
# Atom
|                       #  or
\"                                     # \"
[^\\\\\\x80-\\xff\\n\\015\"] *                            #   normal
(?:  \\\\ [^\\x80-\\xff]  [^\\\\\\x80-\\xff\\n\\015\"] * )*        #   ( special normal* )*
\"                                     #        \"
# Quoted string
)
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
(?:
\\.
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
(?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
# Atom
|                       #  or
\"                                     # \"
[^\\\\\\x80-\\xff\\n\\015\"] *                            #   normal
(?:  \\\\ [^\\x80-\\xff]  [^\\\\\\x80-\\xff\\n\\015\"] * )*        #   ( special normal* )*
\"                                     #        \"
# Quoted string
)
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
# additional words
)*
@
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
(?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|
\\[                            # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*     #    stuff
\\]                           #           ]
)
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
# optional trailing comments
(?:
\\.
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
(?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|
\\[                            # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*     #    stuff
\\]                           #           ]
)
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
# optional trailing comments
)*
# address
|                             #  or
(?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
# Atom
|                       #  or
\"                                     # \"
[^\\\\\\x80-\\xff\\n\\015\"] *                            #   normal
(?:  \\\\ [^\\x80-\\xff]  [^\\\\\\x80-\\xff\\n\\015\"] * )*        #   ( special normal* )*
\"                                     #        \"
# Quoted string
)
# leading word
[^()<>@,;:\".\\\\\\[\\]\\x80-\\xff\\000-\\010\\012-\\037] *               # \"normal\" atoms and or spaces
(?:
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
|
\"                                     # \"
[^\\\\\\x80-\\xff\\n\\015\"] *                            #   normal
(?:  \\\\ [^\\x80-\\xff]  [^\\\\\\x80-\\xff\\n\\015\"] * )*        #   ( special normal* )*
\"                                     #        \"
) # \"special\" comment or quoted string
[^()<>@,;:\".\\\\\\[\\]\\x80-\\xff\\000-\\010\\012-\\037] *            #  more \"normal\"
)*
<
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
# <
(?:
@
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
(?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|
\\[                            # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*     #    stuff
\\]                           #           ]
)
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
# optional trailing comments
(?:
\\.
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
(?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|
\\[                            # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*     #    stuff
\\]                           #           ]
)
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
# optional trailing comments
)*
(?: ,
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
@
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
(?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|
\\[                            # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*     #    stuff
\\]                           #           ]
)
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
# optional trailing comments
(?:
\\.
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
(?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|
\\[                            # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*     #    stuff
\\]                           #           ]
)
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
# optional trailing comments
)*
)*  # additional domains
:
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
# optional trailing comments
)?     #       optional route
(?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
# Atom
|                       #  or
\"                                     # \"
[^\\\\\\x80-\\xff\\n\\015\"] *                            #   normal
(?:  \\\\ [^\\x80-\\xff]  [^\\\\\\x80-\\xff\\n\\015\"] * )*        #   ( special normal* )*
\"                                     #        \"
# Quoted string
)
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
(?:
\\.
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
(?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
# Atom
|                       #  or
\"                                     # \"
[^\\\\\\x80-\\xff\\n\\015\"] *                            #   normal
(?:  \\\\ [^\\x80-\\xff]  [^\\\\\\x80-\\xff\\n\\015\"] * )*        #   ( special normal* )*
\"                                     #        \"
# Quoted string
)
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
# additional words
)*
@
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
(?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|
\\[                            # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*     #    stuff
\\]                           #           ]
)
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
# optional trailing comments
(?:
\\.
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
(?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|
\\[                            # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*     #    stuff
\\]                           #           ]
)
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
# optional trailing comments
)*
#       address spec
>                    #                 >
# name and address
)",[extended,{parts,2}]))), 
    <<"Alan Other <user.ain>">> = iolist_to_binary(join(re:split("Alan Other <user.ain>","[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
# optional leading comment
(?:
(?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
# Atom
|                       #  or
\"                                     # \"
[^\\\\\\x80-\\xff\\n\\015\"] *                            #   normal
(?:  \\\\ [^\\x80-\\xff]  [^\\\\\\x80-\\xff\\n\\015\"] * )*        #   ( special normal* )*
\"                                     #        \"
# Quoted string
)
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
(?:
\\.
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
(?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
# Atom
|                       #  or
\"                                     # \"
[^\\\\\\x80-\\xff\\n\\015\"] *                            #   normal
(?:  \\\\ [^\\x80-\\xff]  [^\\\\\\x80-\\xff\\n\\015\"] * )*        #   ( special normal* )*
\"                                     #        \"
# Quoted string
)
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
# additional words
)*
@
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
(?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|
\\[                            # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*     #    stuff
\\]                           #           ]
)
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
# optional trailing comments
(?:
\\.
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
(?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|
\\[                            # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*     #    stuff
\\]                           #           ]
)
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
# optional trailing comments
)*
# address
|                             #  or
(?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
# Atom
|                       #  or
\"                                     # \"
[^\\\\\\x80-\\xff\\n\\015\"] *                            #   normal
(?:  \\\\ [^\\x80-\\xff]  [^\\\\\\x80-\\xff\\n\\015\"] * )*        #   ( special normal* )*
\"                                     #        \"
# Quoted string
)
# leading word
[^()<>@,;:\".\\\\\\[\\]\\x80-\\xff\\000-\\010\\012-\\037] *               # \"normal\" atoms and or spaces
(?:
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
|
\"                                     # \"
[^\\\\\\x80-\\xff\\n\\015\"] *                            #   normal
(?:  \\\\ [^\\x80-\\xff]  [^\\\\\\x80-\\xff\\n\\015\"] * )*        #   ( special normal* )*
\"                                     #        \"
) # \"special\" comment or quoted string
[^()<>@,;:\".\\\\\\[\\]\\x80-\\xff\\000-\\010\\012-\\037] *            #  more \"normal\"
)*
<
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
# <
(?:
@
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
(?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|
\\[                            # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*     #    stuff
\\]                           #           ]
)
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
# optional trailing comments
(?:
\\.
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
(?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|
\\[                            # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*     #    stuff
\\]                           #           ]
)
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
# optional trailing comments
)*
(?: ,
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
@
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
(?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|
\\[                            # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*     #    stuff
\\]                           #           ]
)
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
# optional trailing comments
(?:
\\.
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
(?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|
\\[                            # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*     #    stuff
\\]                           #           ]
)
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
# optional trailing comments
)*
)*  # additional domains
:
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
# optional trailing comments
)?     #       optional route
(?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
# Atom
|                       #  or
\"                                     # \"
[^\\\\\\x80-\\xff\\n\\015\"] *                            #   normal
(?:  \\\\ [^\\x80-\\xff]  [^\\\\\\x80-\\xff\\n\\015\"] * )*        #   ( special normal* )*
\"                                     #        \"
# Quoted string
)
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
(?:
\\.
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
(?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
# Atom
|                       #  or
\"                                     # \"
[^\\\\\\x80-\\xff\\n\\015\"] *                            #   normal
(?:  \\\\ [^\\x80-\\xff]  [^\\\\\\x80-\\xff\\n\\015\"] * )*        #   ( special normal* )*
\"                                     #        \"
# Quoted string
)
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
# additional words
)*
@
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
(?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|
\\[                            # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*     #    stuff
\\]                           #           ]
)
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
# optional trailing comments
(?:
\\.
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
(?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|
\\[                            # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*     #    stuff
\\]                           #           ]
)
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
# optional trailing comments
)*
#       address spec
>                    #                 >
# name and address
)",[extended]))), 
    <<"<user.ain>">> = iolist_to_binary(join(re:split("<user.ain>","[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
# optional leading comment
(?:
(?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
# Atom
|                       #  or
\"                                     # \"
[^\\\\\\x80-\\xff\\n\\015\"] *                            #   normal
(?:  \\\\ [^\\x80-\\xff]  [^\\\\\\x80-\\xff\\n\\015\"] * )*        #   ( special normal* )*
\"                                     #        \"
# Quoted string
)
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
(?:
\\.
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
(?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
# Atom
|                       #  or
\"                                     # \"
[^\\\\\\x80-\\xff\\n\\015\"] *                            #   normal
(?:  \\\\ [^\\x80-\\xff]  [^\\\\\\x80-\\xff\\n\\015\"] * )*        #   ( special normal* )*
\"                                     #        \"
# Quoted string
)
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
# additional words
)*
@
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
(?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|
\\[                            # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*     #    stuff
\\]                           #           ]
)
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
# optional trailing comments
(?:
\\.
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
(?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|
\\[                            # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*     #    stuff
\\]                           #           ]
)
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
# optional trailing comments
)*
# address
|                             #  or
(?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
# Atom
|                       #  or
\"                                     # \"
[^\\\\\\x80-\\xff\\n\\015\"] *                            #   normal
(?:  \\\\ [^\\x80-\\xff]  [^\\\\\\x80-\\xff\\n\\015\"] * )*        #   ( special normal* )*
\"                                     #        \"
# Quoted string
)
# leading word
[^()<>@,;:\".\\\\\\[\\]\\x80-\\xff\\000-\\010\\012-\\037] *               # \"normal\" atoms and or spaces
(?:
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
|
\"                                     # \"
[^\\\\\\x80-\\xff\\n\\015\"] *                            #   normal
(?:  \\\\ [^\\x80-\\xff]  [^\\\\\\x80-\\xff\\n\\015\"] * )*        #   ( special normal* )*
\"                                     #        \"
) # \"special\" comment or quoted string
[^()<>@,;:\".\\\\\\[\\]\\x80-\\xff\\000-\\010\\012-\\037] *            #  more \"normal\"
)*
<
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
# <
(?:
@
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
(?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|
\\[                            # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*     #    stuff
\\]                           #           ]
)
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
# optional trailing comments
(?:
\\.
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
(?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|
\\[                            # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*     #    stuff
\\]                           #           ]
)
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
# optional trailing comments
)*
(?: ,
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
@
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
(?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|
\\[                            # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*     #    stuff
\\]                           #           ]
)
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
# optional trailing comments
(?:
\\.
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
(?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|
\\[                            # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*     #    stuff
\\]                           #           ]
)
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
# optional trailing comments
)*
)*  # additional domains
:
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
# optional trailing comments
)?     #       optional route
(?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
# Atom
|                       #  or
\"                                     # \"
[^\\\\\\x80-\\xff\\n\\015\"] *                            #   normal
(?:  \\\\ [^\\x80-\\xff]  [^\\\\\\x80-\\xff\\n\\015\"] * )*        #   ( special normal* )*
\"                                     #        \"
# Quoted string
)
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
(?:
\\.
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
(?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
# Atom
|                       #  or
\"                                     # \"
[^\\\\\\x80-\\xff\\n\\015\"] *                            #   normal
(?:  \\\\ [^\\x80-\\xff]  [^\\\\\\x80-\\xff\\n\\015\"] * )*        #   ( special normal* )*
\"                                     #        \"
# Quoted string
)
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
# additional words
)*
@
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
(?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|
\\[                            # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*     #    stuff
\\]                           #           ]
)
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
# optional trailing comments
(?:
\\.
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
(?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|
\\[                            # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*     #    stuff
\\]                           #           ]
)
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
# optional trailing comments
)*
#       address spec
>                    #                 >
# name and address
)",[extended,trim]))), 
    <<"<user.ain>">> = iolist_to_binary(join(re:split("<user.ain>","[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
# optional leading comment
(?:
(?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
# Atom
|                       #  or
\"                                     # \"
[^\\\\\\x80-\\xff\\n\\015\"] *                            #   normal
(?:  \\\\ [^\\x80-\\xff]  [^\\\\\\x80-\\xff\\n\\015\"] * )*        #   ( special normal* )*
\"                                     #        \"
# Quoted string
)
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
(?:
\\.
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
(?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
# Atom
|                       #  or
\"                                     # \"
[^\\\\\\x80-\\xff\\n\\015\"] *                            #   normal
(?:  \\\\ [^\\x80-\\xff]  [^\\\\\\x80-\\xff\\n\\015\"] * )*        #   ( special normal* )*
\"                                     #        \"
# Quoted string
)
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
# additional words
)*
@
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
(?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|
\\[                            # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*     #    stuff
\\]                           #           ]
)
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
# optional trailing comments
(?:
\\.
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
(?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|
\\[                            # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*     #    stuff
\\]                           #           ]
)
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
# optional trailing comments
)*
# address
|                             #  or
(?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
# Atom
|                       #  or
\"                                     # \"
[^\\\\\\x80-\\xff\\n\\015\"] *                            #   normal
(?:  \\\\ [^\\x80-\\xff]  [^\\\\\\x80-\\xff\\n\\015\"] * )*        #   ( special normal* )*
\"                                     #        \"
# Quoted string
)
# leading word
[^()<>@,;:\".\\\\\\[\\]\\x80-\\xff\\000-\\010\\012-\\037] *               # \"normal\" atoms and or spaces
(?:
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
|
\"                                     # \"
[^\\\\\\x80-\\xff\\n\\015\"] *                            #   normal
(?:  \\\\ [^\\x80-\\xff]  [^\\\\\\x80-\\xff\\n\\015\"] * )*        #   ( special normal* )*
\"                                     #        \"
) # \"special\" comment or quoted string
[^()<>@,;:\".\\\\\\[\\]\\x80-\\xff\\000-\\010\\012-\\037] *            #  more \"normal\"
)*
<
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
# <
(?:
@
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
(?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|
\\[                            # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*     #    stuff
\\]                           #           ]
)
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
# optional trailing comments
(?:
\\.
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
(?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|
\\[                            # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*     #    stuff
\\]                           #           ]
)
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
# optional trailing comments
)*
(?: ,
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
@
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
(?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|
\\[                            # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*     #    stuff
\\]                           #           ]
)
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
# optional trailing comments
(?:
\\.
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
(?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|
\\[                            # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*     #    stuff
\\]                           #           ]
)
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
# optional trailing comments
)*
)*  # additional domains
:
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
# optional trailing comments
)?     #       optional route
(?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
# Atom
|                       #  or
\"                                     # \"
[^\\\\\\x80-\\xff\\n\\015\"] *                            #   normal
(?:  \\\\ [^\\x80-\\xff]  [^\\\\\\x80-\\xff\\n\\015\"] * )*        #   ( special normal* )*
\"                                     #        \"
# Quoted string
)
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
(?:
\\.
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
(?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
# Atom
|                       #  or
\"                                     # \"
[^\\\\\\x80-\\xff\\n\\015\"] *                            #   normal
(?:  \\\\ [^\\x80-\\xff]  [^\\\\\\x80-\\xff\\n\\015\"] * )*        #   ( special normal* )*
\"                                     #        \"
# Quoted string
)
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
# additional words
)*
@
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
(?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|
\\[                            # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*     #    stuff
\\]                           #           ]
)
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
# optional trailing comments
(?:
\\.
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
(?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|
\\[                            # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*     #    stuff
\\]                           #           ]
)
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
# optional trailing comments
)*
#       address spec
>                    #                 >
# name and address
)",[extended,{parts,2}]))), 
    <<"<user.ain>">> = iolist_to_binary(join(re:split("<user.ain>","[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
# optional leading comment
(?:
(?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
# Atom
|                       #  or
\"                                     # \"
[^\\\\\\x80-\\xff\\n\\015\"] *                            #   normal
(?:  \\\\ [^\\x80-\\xff]  [^\\\\\\x80-\\xff\\n\\015\"] * )*        #   ( special normal* )*
\"                                     #        \"
# Quoted string
)
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
(?:
\\.
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
(?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
# Atom
|                       #  or
\"                                     # \"
[^\\\\\\x80-\\xff\\n\\015\"] *                            #   normal
(?:  \\\\ [^\\x80-\\xff]  [^\\\\\\x80-\\xff\\n\\015\"] * )*        #   ( special normal* )*
\"                                     #        \"
# Quoted string
)
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
# additional words
)*
@
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
(?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|
\\[                            # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*     #    stuff
\\]                           #           ]
)
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
# optional trailing comments
(?:
\\.
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
(?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|
\\[                            # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*     #    stuff
\\]                           #           ]
)
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
# optional trailing comments
)*
# address
|                             #  or
(?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
# Atom
|                       #  or
\"                                     # \"
[^\\\\\\x80-\\xff\\n\\015\"] *                            #   normal
(?:  \\\\ [^\\x80-\\xff]  [^\\\\\\x80-\\xff\\n\\015\"] * )*        #   ( special normal* )*
\"                                     #        \"
# Quoted string
)
# leading word
[^()<>@,;:\".\\\\\\[\\]\\x80-\\xff\\000-\\010\\012-\\037] *               # \"normal\" atoms and or spaces
(?:
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
|
\"                                     # \"
[^\\\\\\x80-\\xff\\n\\015\"] *                            #   normal
(?:  \\\\ [^\\x80-\\xff]  [^\\\\\\x80-\\xff\\n\\015\"] * )*        #   ( special normal* )*
\"                                     #        \"
) # \"special\" comment or quoted string
[^()<>@,;:\".\\\\\\[\\]\\x80-\\xff\\000-\\010\\012-\\037] *            #  more \"normal\"
)*
<
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
# <
(?:
@
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
(?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|
\\[                            # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*     #    stuff
\\]                           #           ]
)
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
# optional trailing comments
(?:
\\.
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
(?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|
\\[                            # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*     #    stuff
\\]                           #           ]
)
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
# optional trailing comments
)*
(?: ,
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
@
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
(?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|
\\[                            # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*     #    stuff
\\]                           #           ]
)
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
# optional trailing comments
(?:
\\.
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
(?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|
\\[                            # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*     #    stuff
\\]                           #           ]
)
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
# optional trailing comments
)*
)*  # additional domains
:
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
# optional trailing comments
)?     #       optional route
(?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
# Atom
|                       #  or
\"                                     # \"
[^\\\\\\x80-\\xff\\n\\015\"] *                            #   normal
(?:  \\\\ [^\\x80-\\xff]  [^\\\\\\x80-\\xff\\n\\015\"] * )*        #   ( special normal* )*
\"                                     #        \"
# Quoted string
)
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
(?:
\\.
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
(?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
# Atom
|                       #  or
\"                                     # \"
[^\\\\\\x80-\\xff\\n\\015\"] *                            #   normal
(?:  \\\\ [^\\x80-\\xff]  [^\\\\\\x80-\\xff\\n\\015\"] * )*        #   ( special normal* )*
\"                                     #        \"
# Quoted string
)
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
# additional words
)*
@
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
(?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|
\\[                            # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*     #    stuff
\\]                           #           ]
)
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
# optional trailing comments
(?:
\\.
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
(?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|
\\[                            # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*     #    stuff
\\]                           #           ]
)
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
# optional trailing comments
)*
#       address spec
>                    #                 >
# name and address
)",[extended]))), 
    <<"user.ain">> = iolist_to_binary(join(re:split("user.ain","[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
# optional leading comment
(?:
(?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
# Atom
|                       #  or
\"                                     # \"
[^\\\\\\x80-\\xff\\n\\015\"] *                            #   normal
(?:  \\\\ [^\\x80-\\xff]  [^\\\\\\x80-\\xff\\n\\015\"] * )*        #   ( special normal* )*
\"                                     #        \"
# Quoted string
)
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
(?:
\\.
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
(?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
# Atom
|                       #  or
\"                                     # \"
[^\\\\\\x80-\\xff\\n\\015\"] *                            #   normal
(?:  \\\\ [^\\x80-\\xff]  [^\\\\\\x80-\\xff\\n\\015\"] * )*        #   ( special normal* )*
\"                                     #        \"
# Quoted string
)
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
# additional words
)*
@
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
(?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|
\\[                            # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*     #    stuff
\\]                           #           ]
)
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
# optional trailing comments
(?:
\\.
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
(?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|
\\[                            # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*     #    stuff
\\]                           #           ]
)
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
# optional trailing comments
)*
# address
|                             #  or
(?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
# Atom
|                       #  or
\"                                     # \"
[^\\\\\\x80-\\xff\\n\\015\"] *                            #   normal
(?:  \\\\ [^\\x80-\\xff]  [^\\\\\\x80-\\xff\\n\\015\"] * )*        #   ( special normal* )*
\"                                     #        \"
# Quoted string
)
# leading word
[^()<>@,;:\".\\\\\\[\\]\\x80-\\xff\\000-\\010\\012-\\037] *               # \"normal\" atoms and or spaces
(?:
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
|
\"                                     # \"
[^\\\\\\x80-\\xff\\n\\015\"] *                            #   normal
(?:  \\\\ [^\\x80-\\xff]  [^\\\\\\x80-\\xff\\n\\015\"] * )*        #   ( special normal* )*
\"                                     #        \"
) # \"special\" comment or quoted string
[^()<>@,;:\".\\\\\\[\\]\\x80-\\xff\\000-\\010\\012-\\037] *            #  more \"normal\"
)*
<
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
# <
(?:
@
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
(?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|
\\[                            # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*     #    stuff
\\]                           #           ]
)
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
# optional trailing comments
(?:
\\.
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
(?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|
\\[                            # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*     #    stuff
\\]                           #           ]
)
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
# optional trailing comments
)*
(?: ,
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
@
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
(?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|
\\[                            # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*     #    stuff
\\]                           #           ]
)
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
# optional trailing comments
(?:
\\.
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
(?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|
\\[                            # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*     #    stuff
\\]                           #           ]
)
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
# optional trailing comments
)*
)*  # additional domains
:
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
# optional trailing comments
)?     #       optional route
(?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
# Atom
|                       #  or
\"                                     # \"
[^\\\\\\x80-\\xff\\n\\015\"] *                            #   normal
(?:  \\\\ [^\\x80-\\xff]  [^\\\\\\x80-\\xff\\n\\015\"] * )*        #   ( special normal* )*
\"                                     #        \"
# Quoted string
)
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
(?:
\\.
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
(?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
# Atom
|                       #  or
\"                                     # \"
[^\\\\\\x80-\\xff\\n\\015\"] *                            #   normal
(?:  \\\\ [^\\x80-\\xff]  [^\\\\\\x80-\\xff\\n\\015\"] * )*        #   ( special normal* )*
\"                                     #        \"
# Quoted string
)
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
# additional words
)*
@
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
(?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|
\\[                            # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*     #    stuff
\\]                           #           ]
)
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
# optional trailing comments
(?:
\\.
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
(?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|
\\[                            # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*     #    stuff
\\]                           #           ]
)
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
# optional trailing comments
)*
#       address spec
>                    #                 >
# name and address
)",[extended,trim]))), 
    <<"user.ain">> = iolist_to_binary(join(re:split("user.ain","[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
# optional leading comment
(?:
(?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
# Atom
|                       #  or
\"                                     # \"
[^\\\\\\x80-\\xff\\n\\015\"] *                            #   normal
(?:  \\\\ [^\\x80-\\xff]  [^\\\\\\x80-\\xff\\n\\015\"] * )*        #   ( special normal* )*
\"                                     #        \"
# Quoted string
)
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
(?:
\\.
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
(?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
# Atom
|                       #  or
\"                                     # \"
[^\\\\\\x80-\\xff\\n\\015\"] *                            #   normal
(?:  \\\\ [^\\x80-\\xff]  [^\\\\\\x80-\\xff\\n\\015\"] * )*        #   ( special normal* )*
\"                                     #        \"
# Quoted string
)
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
# additional words
)*
@
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
(?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|
\\[                            # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*     #    stuff
\\]                           #           ]
)
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
# optional trailing comments
(?:
\\.
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
(?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|
\\[                            # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*     #    stuff
\\]                           #           ]
)
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
# optional trailing comments
)*
# address
|                             #  or
(?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
# Atom
|                       #  or
\"                                     # \"
[^\\\\\\x80-\\xff\\n\\015\"] *                            #   normal
(?:  \\\\ [^\\x80-\\xff]  [^\\\\\\x80-\\xff\\n\\015\"] * )*        #   ( special normal* )*
\"                                     #        \"
# Quoted string
)
# leading word
[^()<>@,;:\".\\\\\\[\\]\\x80-\\xff\\000-\\010\\012-\\037] *               # \"normal\" atoms and or spaces
(?:
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
|
\"                                     # \"
[^\\\\\\x80-\\xff\\n\\015\"] *                            #   normal
(?:  \\\\ [^\\x80-\\xff]  [^\\\\\\x80-\\xff\\n\\015\"] * )*        #   ( special normal* )*
\"                                     #        \"
) # \"special\" comment or quoted string
[^()<>@,;:\".\\\\\\[\\]\\x80-\\xff\\000-\\010\\012-\\037] *            #  more \"normal\"
)*
<
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
# <
(?:
@
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
(?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|
\\[                            # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*     #    stuff
\\]                           #           ]
)
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
# optional trailing comments
(?:
\\.
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
(?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|
\\[                            # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*     #    stuff
\\]                           #           ]
)
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
# optional trailing comments
)*
(?: ,
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
@
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
(?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|
\\[                            # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*     #    stuff
\\]                           #           ]
)
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
# optional trailing comments
(?:
\\.
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
(?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|
\\[                            # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*     #    stuff
\\]                           #           ]
)
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
# optional trailing comments
)*
)*  # additional domains
:
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
# optional trailing comments
)?     #       optional route
(?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
# Atom
|                       #  or
\"                                     # \"
[^\\\\\\x80-\\xff\\n\\015\"] *                            #   normal
(?:  \\\\ [^\\x80-\\xff]  [^\\\\\\x80-\\xff\\n\\015\"] * )*        #   ( special normal* )*
\"                                     #        \"
# Quoted string
)
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
(?:
\\.
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
(?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
# Atom
|                       #  or
\"                                     # \"
[^\\\\\\x80-\\xff\\n\\015\"] *                            #   normal
(?:  \\\\ [^\\x80-\\xff]  [^\\\\\\x80-\\xff\\n\\015\"] * )*        #   ( special normal* )*
\"                                     #        \"
# Quoted string
)
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
# additional words
)*
@
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
(?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|
\\[                            # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*     #    stuff
\\]                           #           ]
)
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
# optional trailing comments
(?:
\\.
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
(?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|
\\[                            # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*     #    stuff
\\]                           #           ]
)
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
# optional trailing comments
)*
#       address spec
>                    #                 >
# name and address
)",[extended,{parts,2}]))), 
    <<"user.ain">> = iolist_to_binary(join(re:split("user.ain","[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
# optional leading comment
(?:
(?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
# Atom
|                       #  or
\"                                     # \"
[^\\\\\\x80-\\xff\\n\\015\"] *                            #   normal
(?:  \\\\ [^\\x80-\\xff]  [^\\\\\\x80-\\xff\\n\\015\"] * )*        #   ( special normal* )*
\"                                     #        \"
# Quoted string
)
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
(?:
\\.
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
(?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
# Atom
|                       #  or
\"                                     # \"
[^\\\\\\x80-\\xff\\n\\015\"] *                            #   normal
(?:  \\\\ [^\\x80-\\xff]  [^\\\\\\x80-\\xff\\n\\015\"] * )*        #   ( special normal* )*
\"                                     #        \"
# Quoted string
)
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
# additional words
)*
@
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
(?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|
\\[                            # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*     #    stuff
\\]                           #           ]
)
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
# optional trailing comments
(?:
\\.
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
(?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|
\\[                            # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*     #    stuff
\\]                           #           ]
)
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
# optional trailing comments
)*
# address
|                             #  or
(?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
# Atom
|                       #  or
\"                                     # \"
[^\\\\\\x80-\\xff\\n\\015\"] *                            #   normal
(?:  \\\\ [^\\x80-\\xff]  [^\\\\\\x80-\\xff\\n\\015\"] * )*        #   ( special normal* )*
\"                                     #        \"
# Quoted string
)
# leading word
[^()<>@,;:\".\\\\\\[\\]\\x80-\\xff\\000-\\010\\012-\\037] *               # \"normal\" atoms and or spaces
(?:
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
|
\"                                     # \"
[^\\\\\\x80-\\xff\\n\\015\"] *                            #   normal
(?:  \\\\ [^\\x80-\\xff]  [^\\\\\\x80-\\xff\\n\\015\"] * )*        #   ( special normal* )*
\"                                     #        \"
) # \"special\" comment or quoted string
[^()<>@,;:\".\\\\\\[\\]\\x80-\\xff\\000-\\010\\012-\\037] *            #  more \"normal\"
)*
<
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
# <
(?:
@
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
(?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|
\\[                            # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*     #    stuff
\\]                           #           ]
)
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
# optional trailing comments
(?:
\\.
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
(?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|
\\[                            # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*     #    stuff
\\]                           #           ]
)
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
# optional trailing comments
)*
(?: ,
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
@
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
(?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|
\\[                            # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*     #    stuff
\\]                           #           ]
)
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
# optional trailing comments
(?:
\\.
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
(?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|
\\[                            # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*     #    stuff
\\]                           #           ]
)
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
# optional trailing comments
)*
)*  # additional domains
:
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
# optional trailing comments
)?     #       optional route
(?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
# Atom
|                       #  or
\"                                     # \"
[^\\\\\\x80-\\xff\\n\\015\"] *                            #   normal
(?:  \\\\ [^\\x80-\\xff]  [^\\\\\\x80-\\xff\\n\\015\"] * )*        #   ( special normal* )*
\"                                     #        \"
# Quoted string
)
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
(?:
\\.
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
(?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
# Atom
|                       #  or
\"                                     # \"
[^\\\\\\x80-\\xff\\n\\015\"] *                            #   normal
(?:  \\\\ [^\\x80-\\xff]  [^\\\\\\x80-\\xff\\n\\015\"] * )*        #   ( special normal* )*
\"                                     #        \"
# Quoted string
)
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
# additional words
)*
@
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
(?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|
\\[                            # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*     #    stuff
\\]                           #           ]
)
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
# optional trailing comments
(?:
\\.
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
(?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|
\\[                            # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*     #    stuff
\\]                           #           ]
)
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
# optional trailing comments
)*
#       address spec
>                    #                 >
# name and address
)",[extended]))), 
    <<"\"A. Other\" <user.1234.ain> (a comment)">> = iolist_to_binary(join(re:split("\"A. Other\" <user.1234.ain> (a comment)","[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
# optional leading comment
(?:
(?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
# Atom
|                       #  or
\"                                     # \"
[^\\\\\\x80-\\xff\\n\\015\"] *                            #   normal
(?:  \\\\ [^\\x80-\\xff]  [^\\\\\\x80-\\xff\\n\\015\"] * )*        #   ( special normal* )*
\"                                     #        \"
# Quoted string
)
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
(?:
\\.
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
(?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
# Atom
|                       #  or
\"                                     # \"
[^\\\\\\x80-\\xff\\n\\015\"] *                            #   normal
(?:  \\\\ [^\\x80-\\xff]  [^\\\\\\x80-\\xff\\n\\015\"] * )*        #   ( special normal* )*
\"                                     #        \"
# Quoted string
)
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
# additional words
)*
@
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
(?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|
\\[                            # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*     #    stuff
\\]                           #           ]
)
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
# optional trailing comments
(?:
\\.
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
(?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|
\\[                            # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*     #    stuff
\\]                           #           ]
)
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
# optional trailing comments
)*
# address
|                             #  or
(?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
# Atom
|                       #  or
\"                                     # \"
[^\\\\\\x80-\\xff\\n\\015\"] *                            #   normal
(?:  \\\\ [^\\x80-\\xff]  [^\\\\\\x80-\\xff\\n\\015\"] * )*        #   ( special normal* )*
\"                                     #        \"
# Quoted string
)
# leading word
[^()<>@,;:\".\\\\\\[\\]\\x80-\\xff\\000-\\010\\012-\\037] *               # \"normal\" atoms and or spaces
(?:
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
|
\"                                     # \"
[^\\\\\\x80-\\xff\\n\\015\"] *                            #   normal
(?:  \\\\ [^\\x80-\\xff]  [^\\\\\\x80-\\xff\\n\\015\"] * )*        #   ( special normal* )*
\"                                     #        \"
) # \"special\" comment or quoted string
[^()<>@,;:\".\\\\\\[\\]\\x80-\\xff\\000-\\010\\012-\\037] *            #  more \"normal\"
)*
<
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
# <
(?:
@
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
(?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|
\\[                            # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*     #    stuff
\\]                           #           ]
)
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
# optional trailing comments
(?:
\\.
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
(?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|
\\[                            # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*     #    stuff
\\]                           #           ]
)
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
# optional trailing comments
)*
(?: ,
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
@
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
(?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|
\\[                            # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*     #    stuff
\\]                           #           ]
)
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
# optional trailing comments
(?:
\\.
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
(?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|
\\[                            # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*     #    stuff
\\]                           #           ]
)
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
# optional trailing comments
)*
)*  # additional domains
:
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
# optional trailing comments
)?     #       optional route
(?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
# Atom
|                       #  or
\"                                     # \"
[^\\\\\\x80-\\xff\\n\\015\"] *                            #   normal
(?:  \\\\ [^\\x80-\\xff]  [^\\\\\\x80-\\xff\\n\\015\"] * )*        #   ( special normal* )*
\"                                     #        \"
# Quoted string
)
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
(?:
\\.
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
(?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
# Atom
|                       #  or
\"                                     # \"
[^\\\\\\x80-\\xff\\n\\015\"] *                            #   normal
(?:  \\\\ [^\\x80-\\xff]  [^\\\\\\x80-\\xff\\n\\015\"] * )*        #   ( special normal* )*
\"                                     #        \"
# Quoted string
)
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
# additional words
)*
@
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
(?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|
\\[                            # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*     #    stuff
\\]                           #           ]
)
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
# optional trailing comments
(?:
\\.
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
(?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|
\\[                            # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*     #    stuff
\\]                           #           ]
)
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
# optional trailing comments
)*
#       address spec
>                    #                 >
# name and address
)",[extended,trim]))), 
    <<"\"A. Other\" <user.1234.ain> (a comment)">> = iolist_to_binary(join(re:split("\"A. Other\" <user.1234.ain> (a comment)","[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
# optional leading comment
(?:
(?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
# Atom
|                       #  or
\"                                     # \"
[^\\\\\\x80-\\xff\\n\\015\"] *                            #   normal
(?:  \\\\ [^\\x80-\\xff]  [^\\\\\\x80-\\xff\\n\\015\"] * )*        #   ( special normal* )*
\"                                     #        \"
# Quoted string
)
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
(?:
\\.
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
(?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
# Atom
|                       #  or
\"                                     # \"
[^\\\\\\x80-\\xff\\n\\015\"] *                            #   normal
(?:  \\\\ [^\\x80-\\xff]  [^\\\\\\x80-\\xff\\n\\015\"] * )*        #   ( special normal* )*
\"                                     #        \"
# Quoted string
)
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
# additional words
)*
@
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
(?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|
\\[                            # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*     #    stuff
\\]                           #           ]
)
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
# optional trailing comments
(?:
\\.
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
(?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|
\\[                            # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*     #    stuff
\\]                           #           ]
)
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
# optional trailing comments
)*
# address
|                             #  or
(?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
# Atom
|                       #  or
\"                                     # \"
[^\\\\\\x80-\\xff\\n\\015\"] *                            #   normal
(?:  \\\\ [^\\x80-\\xff]  [^\\\\\\x80-\\xff\\n\\015\"] * )*        #   ( special normal* )*
\"                                     #        \"
# Quoted string
)
# leading word
[^()<>@,;:\".\\\\\\[\\]\\x80-\\xff\\000-\\010\\012-\\037] *               # \"normal\" atoms and or spaces
(?:
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
|
\"                                     # \"
[^\\\\\\x80-\\xff\\n\\015\"] *                            #   normal
(?:  \\\\ [^\\x80-\\xff]  [^\\\\\\x80-\\xff\\n\\015\"] * )*        #   ( special normal* )*
\"                                     #        \"
) # \"special\" comment or quoted string
[^()<>@,;:\".\\\\\\[\\]\\x80-\\xff\\000-\\010\\012-\\037] *            #  more \"normal\"
)*
<
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
# <
(?:
@
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
(?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|
\\[                            # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*     #    stuff
\\]                           #           ]
)
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
# optional trailing comments
(?:
\\.
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
(?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|
\\[                            # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*     #    stuff
\\]                           #           ]
)
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
# optional trailing comments
)*
(?: ,
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
@
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
(?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|
\\[                            # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*     #    stuff
\\]                           #           ]
)
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
# optional trailing comments
(?:
\\.
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
(?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|
\\[                            # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*     #    stuff
\\]                           #           ]
)
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
# optional trailing comments
)*
)*  # additional domains
:
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
# optional trailing comments
)?     #       optional route
(?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
# Atom
|                       #  or
\"                                     # \"
[^\\\\\\x80-\\xff\\n\\015\"] *                            #   normal
(?:  \\\\ [^\\x80-\\xff]  [^\\\\\\x80-\\xff\\n\\015\"] * )*        #   ( special normal* )*
\"                                     #        \"
# Quoted string
)
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
(?:
\\.
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
(?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
# Atom
|                       #  or
\"                                     # \"
[^\\\\\\x80-\\xff\\n\\015\"] *                            #   normal
(?:  \\\\ [^\\x80-\\xff]  [^\\\\\\x80-\\xff\\n\\015\"] * )*        #   ( special normal* )*
\"                                     #        \"
# Quoted string
)
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
# additional words
)*
@
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
(?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|
\\[                            # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*     #    stuff
\\]                           #           ]
)
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
# optional trailing comments
(?:
\\.
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
(?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|
\\[                            # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*     #    stuff
\\]                           #           ]
)
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
# optional trailing comments
)*
#       address spec
>                    #                 >
# name and address
)",[extended,{parts,2}]))), 
    <<"\"A. Other\" <user.1234.ain> (a comment)">> = iolist_to_binary(join(re:split("\"A. Other\" <user.1234.ain> (a comment)","[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
# optional leading comment
(?:
(?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
# Atom
|                       #  or
\"                                     # \"
[^\\\\\\x80-\\xff\\n\\015\"] *                            #   normal
(?:  \\\\ [^\\x80-\\xff]  [^\\\\\\x80-\\xff\\n\\015\"] * )*        #   ( special normal* )*
\"                                     #        \"
# Quoted string
)
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
(?:
\\.
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
(?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
# Atom
|                       #  or
\"                                     # \"
[^\\\\\\x80-\\xff\\n\\015\"] *                            #   normal
(?:  \\\\ [^\\x80-\\xff]  [^\\\\\\x80-\\xff\\n\\015\"] * )*        #   ( special normal* )*
\"                                     #        \"
# Quoted string
)
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
# additional words
)*
@
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
(?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|
\\[                            # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*     #    stuff
\\]                           #           ]
)
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
# optional trailing comments
(?:
\\.
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
(?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|
\\[                            # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*     #    stuff
\\]                           #           ]
)
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
# optional trailing comments
)*
# address
|                             #  or
(?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
# Atom
|                       #  or
\"                                     # \"
[^\\\\\\x80-\\xff\\n\\015\"] *                            #   normal
(?:  \\\\ [^\\x80-\\xff]  [^\\\\\\x80-\\xff\\n\\015\"] * )*        #   ( special normal* )*
\"                                     #        \"
# Quoted string
)
# leading word
[^()<>@,;:\".\\\\\\[\\]\\x80-\\xff\\000-\\010\\012-\\037] *               # \"normal\" atoms and or spaces
(?:
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
|
\"                                     # \"
[^\\\\\\x80-\\xff\\n\\015\"] *                            #   normal
(?:  \\\\ [^\\x80-\\xff]  [^\\\\\\x80-\\xff\\n\\015\"] * )*        #   ( special normal* )*
\"                                     #        \"
) # \"special\" comment or quoted string
[^()<>@,;:\".\\\\\\[\\]\\x80-\\xff\\000-\\010\\012-\\037] *            #  more \"normal\"
)*
<
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
# <
(?:
@
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
(?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|
\\[                            # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*     #    stuff
\\]                           #           ]
)
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
# optional trailing comments
(?:
\\.
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
(?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|
\\[                            # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*     #    stuff
\\]                           #           ]
)
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
# optional trailing comments
)*
(?: ,
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
@
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
(?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|
\\[                            # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*     #    stuff
\\]                           #           ]
)
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
# optional trailing comments
(?:
\\.
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
(?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|
\\[                            # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*     #    stuff
\\]                           #           ]
)
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
# optional trailing comments
)*
)*  # additional domains
:
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
# optional trailing comments
)?     #       optional route
(?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
# Atom
|                       #  or
\"                                     # \"
[^\\\\\\x80-\\xff\\n\\015\"] *                            #   normal
(?:  \\\\ [^\\x80-\\xff]  [^\\\\\\x80-\\xff\\n\\015\"] * )*        #   ( special normal* )*
\"                                     #        \"
# Quoted string
)
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
(?:
\\.
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
(?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
# Atom
|                       #  or
\"                                     # \"
[^\\\\\\x80-\\xff\\n\\015\"] *                            #   normal
(?:  \\\\ [^\\x80-\\xff]  [^\\\\\\x80-\\xff\\n\\015\"] * )*        #   ( special normal* )*
\"                                     #        \"
# Quoted string
)
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
# additional words
)*
@
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
(?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|
\\[                            # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*     #    stuff
\\]                           #           ]
)
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
# optional trailing comments
(?:
\\.
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
(?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|
\\[                            # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*     #    stuff
\\]                           #           ]
)
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
# optional trailing comments
)*
#       address spec
>                    #                 >
# name and address
)",[extended]))), 
    <<"A. Other <user.1234.ain> (a comment)">> = iolist_to_binary(join(re:split("A. Other <user.1234.ain> (a comment)","[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
# optional leading comment
(?:
(?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
# Atom
|                       #  or
\"                                     # \"
[^\\\\\\x80-\\xff\\n\\015\"] *                            #   normal
(?:  \\\\ [^\\x80-\\xff]  [^\\\\\\x80-\\xff\\n\\015\"] * )*        #   ( special normal* )*
\"                                     #        \"
# Quoted string
)
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
(?:
\\.
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
(?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
# Atom
|                       #  or
\"                                     # \"
[^\\\\\\x80-\\xff\\n\\015\"] *                            #   normal
(?:  \\\\ [^\\x80-\\xff]  [^\\\\\\x80-\\xff\\n\\015\"] * )*        #   ( special normal* )*
\"                                     #        \"
# Quoted string
)
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
# additional words
)*
@
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
(?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|
\\[                            # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*     #    stuff
\\]                           #           ]
)
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
# optional trailing comments
(?:
\\.
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
(?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|
\\[                            # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*     #    stuff
\\]                           #           ]
)
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
# optional trailing comments
)*
# address
|                             #  or
(?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
# Atom
|                       #  or
\"                                     # \"
[^\\\\\\x80-\\xff\\n\\015\"] *                            #   normal
(?:  \\\\ [^\\x80-\\xff]  [^\\\\\\x80-\\xff\\n\\015\"] * )*        #   ( special normal* )*
\"                                     #        \"
# Quoted string
)
# leading word
[^()<>@,;:\".\\\\\\[\\]\\x80-\\xff\\000-\\010\\012-\\037] *               # \"normal\" atoms and or spaces
(?:
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
|
\"                                     # \"
[^\\\\\\x80-\\xff\\n\\015\"] *                            #   normal
(?:  \\\\ [^\\x80-\\xff]  [^\\\\\\x80-\\xff\\n\\015\"] * )*        #   ( special normal* )*
\"                                     #        \"
) # \"special\" comment or quoted string
[^()<>@,;:\".\\\\\\[\\]\\x80-\\xff\\000-\\010\\012-\\037] *            #  more \"normal\"
)*
<
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
# <
(?:
@
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
(?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|
\\[                            # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*     #    stuff
\\]                           #           ]
)
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
# optional trailing comments
(?:
\\.
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
(?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|
\\[                            # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*     #    stuff
\\]                           #           ]
)
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
# optional trailing comments
)*
(?: ,
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
@
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
(?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|
\\[                            # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*     #    stuff
\\]                           #           ]
)
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
# optional trailing comments
(?:
\\.
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
(?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|
\\[                            # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*     #    stuff
\\]                           #           ]
)
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
# optional trailing comments
)*
)*  # additional domains
:
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
# optional trailing comments
)?     #       optional route
(?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
# Atom
|                       #  or
\"                                     # \"
[^\\\\\\x80-\\xff\\n\\015\"] *                            #   normal
(?:  \\\\ [^\\x80-\\xff]  [^\\\\\\x80-\\xff\\n\\015\"] * )*        #   ( special normal* )*
\"                                     #        \"
# Quoted string
)
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
(?:
\\.
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
(?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
# Atom
|                       #  or
\"                                     # \"
[^\\\\\\x80-\\xff\\n\\015\"] *                            #   normal
(?:  \\\\ [^\\x80-\\xff]  [^\\\\\\x80-\\xff\\n\\015\"] * )*        #   ( special normal* )*
\"                                     #        \"
# Quoted string
)
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
# additional words
)*
@
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
(?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|
\\[                            # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*     #    stuff
\\]                           #           ]
)
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
# optional trailing comments
(?:
\\.
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
(?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|
\\[                            # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*     #    stuff
\\]                           #           ]
)
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
# optional trailing comments
)*
#       address spec
>                    #                 >
# name and address
)",[extended,trim]))), 
    <<"A. Other <user.1234.ain> (a comment)">> = iolist_to_binary(join(re:split("A. Other <user.1234.ain> (a comment)","[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
# optional leading comment
(?:
(?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
# Atom
|                       #  or
\"                                     # \"
[^\\\\\\x80-\\xff\\n\\015\"] *                            #   normal
(?:  \\\\ [^\\x80-\\xff]  [^\\\\\\x80-\\xff\\n\\015\"] * )*        #   ( special normal* )*
\"                                     #        \"
# Quoted string
)
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
(?:
\\.
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
(?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
# Atom
|                       #  or
\"                                     # \"
[^\\\\\\x80-\\xff\\n\\015\"] *                            #   normal
(?:  \\\\ [^\\x80-\\xff]  [^\\\\\\x80-\\xff\\n\\015\"] * )*        #   ( special normal* )*
\"                                     #        \"
# Quoted string
)
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
# additional words
)*
@
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
(?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|
\\[                            # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*     #    stuff
\\]                           #           ]
)
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
# optional trailing comments
(?:
\\.
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
(?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|
\\[                            # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*     #    stuff
\\]                           #           ]
)
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
# optional trailing comments
)*
# address
|                             #  or
(?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
# Atom
|                       #  or
\"                                     # \"
[^\\\\\\x80-\\xff\\n\\015\"] *                            #   normal
(?:  \\\\ [^\\x80-\\xff]  [^\\\\\\x80-\\xff\\n\\015\"] * )*        #   ( special normal* )*
\"                                     #        \"
# Quoted string
)
# leading word
[^()<>@,;:\".\\\\\\[\\]\\x80-\\xff\\000-\\010\\012-\\037] *               # \"normal\" atoms and or spaces
(?:
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
|
\"                                     # \"
[^\\\\\\x80-\\xff\\n\\015\"] *                            #   normal
(?:  \\\\ [^\\x80-\\xff]  [^\\\\\\x80-\\xff\\n\\015\"] * )*        #   ( special normal* )*
\"                                     #        \"
) # \"special\" comment or quoted string
[^()<>@,;:\".\\\\\\[\\]\\x80-\\xff\\000-\\010\\012-\\037] *            #  more \"normal\"
)*
<
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
# <
(?:
@
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
(?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|
\\[                            # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*     #    stuff
\\]                           #           ]
)
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
# optional trailing comments
(?:
\\.
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
(?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|
\\[                            # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*     #    stuff
\\]                           #           ]
)
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
# optional trailing comments
)*
(?: ,
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
@
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
(?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|
\\[                            # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*     #    stuff
\\]                           #           ]
)
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
# optional trailing comments
(?:
\\.
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
(?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|
\\[                            # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*     #    stuff
\\]                           #           ]
)
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
# optional trailing comments
)*
)*  # additional domains
:
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
# optional trailing comments
)?     #       optional route
(?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
# Atom
|                       #  or
\"                                     # \"
[^\\\\\\x80-\\xff\\n\\015\"] *                            #   normal
(?:  \\\\ [^\\x80-\\xff]  [^\\\\\\x80-\\xff\\n\\015\"] * )*        #   ( special normal* )*
\"                                     #        \"
# Quoted string
)
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
(?:
\\.
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
(?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
# Atom
|                       #  or
\"                                     # \"
[^\\\\\\x80-\\xff\\n\\015\"] *                            #   normal
(?:  \\\\ [^\\x80-\\xff]  [^\\\\\\x80-\\xff\\n\\015\"] * )*        #   ( special normal* )*
\"                                     #        \"
# Quoted string
)
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
# additional words
)*
@
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
(?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|
\\[                            # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*     #    stuff
\\]                           #           ]
)
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
# optional trailing comments
(?:
\\.
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
(?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|
\\[                            # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*     #    stuff
\\]                           #           ]
)
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
# optional trailing comments
)*
#       address spec
>                    #                 >
# name and address
)",[extended,{parts,2}]))), 
    <<"A. Other <user.1234.ain> (a comment)">> = iolist_to_binary(join(re:split("A. Other <user.1234.ain> (a comment)","[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
# optional leading comment
(?:
(?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
# Atom
|                       #  or
\"                                     # \"
[^\\\\\\x80-\\xff\\n\\015\"] *                            #   normal
(?:  \\\\ [^\\x80-\\xff]  [^\\\\\\x80-\\xff\\n\\015\"] * )*        #   ( special normal* )*
\"                                     #        \"
# Quoted string
)
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
(?:
\\.
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
(?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
# Atom
|                       #  or
\"                                     # \"
[^\\\\\\x80-\\xff\\n\\015\"] *                            #   normal
(?:  \\\\ [^\\x80-\\xff]  [^\\\\\\x80-\\xff\\n\\015\"] * )*        #   ( special normal* )*
\"                                     #        \"
# Quoted string
)
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
# additional words
)*
@
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
(?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|
\\[                            # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*     #    stuff
\\]                           #           ]
)
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
# optional trailing comments
(?:
\\.
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
(?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|
\\[                            # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*     #    stuff
\\]                           #           ]
)
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
# optional trailing comments
)*
# address
|                             #  or
(?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
# Atom
|                       #  or
\"                                     # \"
[^\\\\\\x80-\\xff\\n\\015\"] *                            #   normal
(?:  \\\\ [^\\x80-\\xff]  [^\\\\\\x80-\\xff\\n\\015\"] * )*        #   ( special normal* )*
\"                                     #        \"
# Quoted string
)
# leading word
[^()<>@,;:\".\\\\\\[\\]\\x80-\\xff\\000-\\010\\012-\\037] *               # \"normal\" atoms and or spaces
(?:
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
|
\"                                     # \"
[^\\\\\\x80-\\xff\\n\\015\"] *                            #   normal
(?:  \\\\ [^\\x80-\\xff]  [^\\\\\\x80-\\xff\\n\\015\"] * )*        #   ( special normal* )*
\"                                     #        \"
) # \"special\" comment or quoted string
[^()<>@,;:\".\\\\\\[\\]\\x80-\\xff\\000-\\010\\012-\\037] *            #  more \"normal\"
)*
<
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
# <
(?:
@
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
(?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|
\\[                            # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*     #    stuff
\\]                           #           ]
)
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
# optional trailing comments
(?:
\\.
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
(?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|
\\[                            # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*     #    stuff
\\]                           #           ]
)
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
# optional trailing comments
)*
(?: ,
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
@
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
(?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|
\\[                            # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*     #    stuff
\\]                           #           ]
)
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
# optional trailing comments
(?:
\\.
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
(?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|
\\[                            # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*     #    stuff
\\]                           #           ]
)
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
# optional trailing comments
)*
)*  # additional domains
:
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
# optional trailing comments
)?     #       optional route
(?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
# Atom
|                       #  or
\"                                     # \"
[^\\\\\\x80-\\xff\\n\\015\"] *                            #   normal
(?:  \\\\ [^\\x80-\\xff]  [^\\\\\\x80-\\xff\\n\\015\"] * )*        #   ( special normal* )*
\"                                     #        \"
# Quoted string
)
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
(?:
\\.
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
(?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
# Atom
|                       #  or
\"                                     # \"
[^\\\\\\x80-\\xff\\n\\015\"] *                            #   normal
(?:  \\\\ [^\\x80-\\xff]  [^\\\\\\x80-\\xff\\n\\015\"] * )*        #   ( special normal* )*
\"                                     #        \"
# Quoted string
)
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
# additional words
)*
@
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
(?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|
\\[                            # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*     #    stuff
\\]                           #           ]
)
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
# optional trailing comments
(?:
\\.
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
(?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|
\\[                            # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*     #    stuff
\\]                           #           ]
)
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
# optional trailing comments
)*
#       address spec
>                    #                 >
# name and address
)",[extended]))), 
    <<"\"/s=user/ou=host/o=place/prmd=uu.yy/admd= /c=gb/\"-re.lay">> = iolist_to_binary(join(re:split("\"/s=user/ou=host/o=place/prmd=uu.yy/admd= /c=gb/\"-re.lay","[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
# optional leading comment
(?:
(?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
# Atom
|                       #  or
\"                                     # \"
[^\\\\\\x80-\\xff\\n\\015\"] *                            #   normal
(?:  \\\\ [^\\x80-\\xff]  [^\\\\\\x80-\\xff\\n\\015\"] * )*        #   ( special normal* )*
\"                                     #        \"
# Quoted string
)
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
(?:
\\.
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
(?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
# Atom
|                       #  or
\"                                     # \"
[^\\\\\\x80-\\xff\\n\\015\"] *                            #   normal
(?:  \\\\ [^\\x80-\\xff]  [^\\\\\\x80-\\xff\\n\\015\"] * )*        #   ( special normal* )*
\"                                     #        \"
# Quoted string
)
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
# additional words
)*
@
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
(?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|
\\[                            # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*     #    stuff
\\]                           #           ]
)
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
# optional trailing comments
(?:
\\.
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
(?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|
\\[                            # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*     #    stuff
\\]                           #           ]
)
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
# optional trailing comments
)*
# address
|                             #  or
(?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
# Atom
|                       #  or
\"                                     # \"
[^\\\\\\x80-\\xff\\n\\015\"] *                            #   normal
(?:  \\\\ [^\\x80-\\xff]  [^\\\\\\x80-\\xff\\n\\015\"] * )*        #   ( special normal* )*
\"                                     #        \"
# Quoted string
)
# leading word
[^()<>@,;:\".\\\\\\[\\]\\x80-\\xff\\000-\\010\\012-\\037] *               # \"normal\" atoms and or spaces
(?:
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
|
\"                                     # \"
[^\\\\\\x80-\\xff\\n\\015\"] *                            #   normal
(?:  \\\\ [^\\x80-\\xff]  [^\\\\\\x80-\\xff\\n\\015\"] * )*        #   ( special normal* )*
\"                                     #        \"
) # \"special\" comment or quoted string
[^()<>@,;:\".\\\\\\[\\]\\x80-\\xff\\000-\\010\\012-\\037] *            #  more \"normal\"
)*
<
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
# <
(?:
@
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
(?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|
\\[                            # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*     #    stuff
\\]                           #           ]
)
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
# optional trailing comments
(?:
\\.
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
(?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|
\\[                            # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*     #    stuff
\\]                           #           ]
)
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
# optional trailing comments
)*
(?: ,
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
@
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
(?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|
\\[                            # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*     #    stuff
\\]                           #           ]
)
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
# optional trailing comments
(?:
\\.
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
(?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|
\\[                            # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*     #    stuff
\\]                           #           ]
)
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
# optional trailing comments
)*
)*  # additional domains
:
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
# optional trailing comments
)?     #       optional route
(?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
# Atom
|                       #  or
\"                                     # \"
[^\\\\\\x80-\\xff\\n\\015\"] *                            #   normal
(?:  \\\\ [^\\x80-\\xff]  [^\\\\\\x80-\\xff\\n\\015\"] * )*        #   ( special normal* )*
\"                                     #        \"
# Quoted string
)
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
(?:
\\.
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
(?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
# Atom
|                       #  or
\"                                     # \"
[^\\\\\\x80-\\xff\\n\\015\"] *                            #   normal
(?:  \\\\ [^\\x80-\\xff]  [^\\\\\\x80-\\xff\\n\\015\"] * )*        #   ( special normal* )*
\"                                     #        \"
# Quoted string
)
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
# additional words
)*
@
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
(?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|
\\[                            # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*     #    stuff
\\]                           #           ]
)
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
# optional trailing comments
(?:
\\.
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
(?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|
\\[                            # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*     #    stuff
\\]                           #           ]
)
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
# optional trailing comments
)*
#       address spec
>                    #                 >
# name and address
)",[extended,trim]))), 
    <<"\"/s=user/ou=host/o=place/prmd=uu.yy/admd= /c=gb/\"-re.lay">> = iolist_to_binary(join(re:split("\"/s=user/ou=host/o=place/prmd=uu.yy/admd= /c=gb/\"-re.lay","[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
# optional leading comment
(?:
(?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
# Atom
|                       #  or
\"                                     # \"
[^\\\\\\x80-\\xff\\n\\015\"] *                            #   normal
(?:  \\\\ [^\\x80-\\xff]  [^\\\\\\x80-\\xff\\n\\015\"] * )*        #   ( special normal* )*
\"                                     #        \"
# Quoted string
)
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
(?:
\\.
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
(?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
# Atom
|                       #  or
\"                                     # \"
[^\\\\\\x80-\\xff\\n\\015\"] *                            #   normal
(?:  \\\\ [^\\x80-\\xff]  [^\\\\\\x80-\\xff\\n\\015\"] * )*        #   ( special normal* )*
\"                                     #        \"
# Quoted string
)
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
# additional words
)*
@
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
(?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|
\\[                            # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*     #    stuff
\\]                           #           ]
)
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
# optional trailing comments
(?:
\\.
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
(?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|
\\[                            # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*     #    stuff
\\]                           #           ]
)
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
# optional trailing comments
)*
# address
|                             #  or
(?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
# Atom
|                       #  or
\"                                     # \"
[^\\\\\\x80-\\xff\\n\\015\"] *                            #   normal
(?:  \\\\ [^\\x80-\\xff]  [^\\\\\\x80-\\xff\\n\\015\"] * )*        #   ( special normal* )*
\"                                     #        \"
# Quoted string
)
# leading word
[^()<>@,;:\".\\\\\\[\\]\\x80-\\xff\\000-\\010\\012-\\037] *               # \"normal\" atoms and or spaces
(?:
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
|
\"                                     # \"
[^\\\\\\x80-\\xff\\n\\015\"] *                            #   normal
(?:  \\\\ [^\\x80-\\xff]  [^\\\\\\x80-\\xff\\n\\015\"] * )*        #   ( special normal* )*
\"                                     #        \"
) # \"special\" comment or quoted string
[^()<>@,;:\".\\\\\\[\\]\\x80-\\xff\\000-\\010\\012-\\037] *            #  more \"normal\"
)*
<
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
# <
(?:
@
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
(?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|
\\[                            # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*     #    stuff
\\]                           #           ]
)
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
# optional trailing comments
(?:
\\.
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
(?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|
\\[                            # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*     #    stuff
\\]                           #           ]
)
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
# optional trailing comments
)*
(?: ,
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
@
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
(?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|
\\[                            # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*     #    stuff
\\]                           #           ]
)
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
# optional trailing comments
(?:
\\.
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
(?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|
\\[                            # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*     #    stuff
\\]                           #           ]
)
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
# optional trailing comments
)*
)*  # additional domains
:
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
# optional trailing comments
)?     #       optional route
(?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
# Atom
|                       #  or
\"                                     # \"
[^\\\\\\x80-\\xff\\n\\015\"] *                            #   normal
(?:  \\\\ [^\\x80-\\xff]  [^\\\\\\x80-\\xff\\n\\015\"] * )*        #   ( special normal* )*
\"                                     #        \"
# Quoted string
)
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
(?:
\\.
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
(?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
# Atom
|                       #  or
\"                                     # \"
[^\\\\\\x80-\\xff\\n\\015\"] *                            #   normal
(?:  \\\\ [^\\x80-\\xff]  [^\\\\\\x80-\\xff\\n\\015\"] * )*        #   ( special normal* )*
\"                                     #        \"
# Quoted string
)
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
# additional words
)*
@
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
(?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|
\\[                            # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*     #    stuff
\\]                           #           ]
)
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
# optional trailing comments
(?:
\\.
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
(?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|
\\[                            # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*     #    stuff
\\]                           #           ]
)
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
# optional trailing comments
)*
#       address spec
>                    #                 >
# name and address
)",[extended,{parts,2}]))), 
    <<"\"/s=user/ou=host/o=place/prmd=uu.yy/admd= /c=gb/\"-re.lay">> = iolist_to_binary(join(re:split("\"/s=user/ou=host/o=place/prmd=uu.yy/admd= /c=gb/\"-re.lay","[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
# optional leading comment
(?:
(?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
# Atom
|                       #  or
\"                                     # \"
[^\\\\\\x80-\\xff\\n\\015\"] *                            #   normal
(?:  \\\\ [^\\x80-\\xff]  [^\\\\\\x80-\\xff\\n\\015\"] * )*        #   ( special normal* )*
\"                                     #        \"
# Quoted string
)
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
(?:
\\.
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
(?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
# Atom
|                       #  or
\"                                     # \"
[^\\\\\\x80-\\xff\\n\\015\"] *                            #   normal
(?:  \\\\ [^\\x80-\\xff]  [^\\\\\\x80-\\xff\\n\\015\"] * )*        #   ( special normal* )*
\"                                     #        \"
# Quoted string
)
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
# additional words
)*
@
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
(?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|
\\[                            # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*     #    stuff
\\]                           #           ]
)
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
# optional trailing comments
(?:
\\.
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
(?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|
\\[                            # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*     #    stuff
\\]                           #           ]
)
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
# optional trailing comments
)*
# address
|                             #  or
(?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
# Atom
|                       #  or
\"                                     # \"
[^\\\\\\x80-\\xff\\n\\015\"] *                            #   normal
(?:  \\\\ [^\\x80-\\xff]  [^\\\\\\x80-\\xff\\n\\015\"] * )*        #   ( special normal* )*
\"                                     #        \"
# Quoted string
)
# leading word
[^()<>@,;:\".\\\\\\[\\]\\x80-\\xff\\000-\\010\\012-\\037] *               # \"normal\" atoms and or spaces
(?:
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
|
\"                                     # \"
[^\\\\\\x80-\\xff\\n\\015\"] *                            #   normal
(?:  \\\\ [^\\x80-\\xff]  [^\\\\\\x80-\\xff\\n\\015\"] * )*        #   ( special normal* )*
\"                                     #        \"
) # \"special\" comment or quoted string
[^()<>@,;:\".\\\\\\[\\]\\x80-\\xff\\000-\\010\\012-\\037] *            #  more \"normal\"
)*
<
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
# <
(?:
@
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
(?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|
\\[                            # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*     #    stuff
\\]                           #           ]
)
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
# optional trailing comments
(?:
\\.
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
(?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|
\\[                            # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*     #    stuff
\\]                           #           ]
)
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
# optional trailing comments
)*
(?: ,
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
@
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
(?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|
\\[                            # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*     #    stuff
\\]                           #           ]
)
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
# optional trailing comments
(?:
\\.
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
(?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|
\\[                            # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*     #    stuff
\\]                           #           ]
)
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
# optional trailing comments
)*
)*  # additional domains
:
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
# optional trailing comments
)?     #       optional route
(?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
# Atom
|                       #  or
\"                                     # \"
[^\\\\\\x80-\\xff\\n\\015\"] *                            #   normal
(?:  \\\\ [^\\x80-\\xff]  [^\\\\\\x80-\\xff\\n\\015\"] * )*        #   ( special normal* )*
\"                                     #        \"
# Quoted string
)
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
(?:
\\.
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
(?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
# Atom
|                       #  or
\"                                     # \"
[^\\\\\\x80-\\xff\\n\\015\"] *                            #   normal
(?:  \\\\ [^\\x80-\\xff]  [^\\\\\\x80-\\xff\\n\\015\"] * )*        #   ( special normal* )*
\"                                     #        \"
# Quoted string
)
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
# additional words
)*
@
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
(?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|
\\[                            # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*     #    stuff
\\]                           #           ]
)
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
# optional trailing comments
(?:
\\.
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
(?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|
\\[                            # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*     #    stuff
\\]                           #           ]
)
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
# optional trailing comments
)*
#       address spec
>                    #                 >
# name and address
)",[extended]))), 
    <<"A missing angle <user.where">> = iolist_to_binary(join(re:split("A missing angle <user.where","[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
# optional leading comment
(?:
(?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
# Atom
|                       #  or
\"                                     # \"
[^\\\\\\x80-\\xff\\n\\015\"] *                            #   normal
(?:  \\\\ [^\\x80-\\xff]  [^\\\\\\x80-\\xff\\n\\015\"] * )*        #   ( special normal* )*
\"                                     #        \"
# Quoted string
)
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
(?:
\\.
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
(?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
# Atom
|                       #  or
\"                                     # \"
[^\\\\\\x80-\\xff\\n\\015\"] *                            #   normal
(?:  \\\\ [^\\x80-\\xff]  [^\\\\\\x80-\\xff\\n\\015\"] * )*        #   ( special normal* )*
\"                                     #        \"
# Quoted string
)
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
# additional words
)*
@
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
(?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|
\\[                            # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*     #    stuff
\\]                           #           ]
)
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
# optional trailing comments
(?:
\\.
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
(?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|
\\[                            # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*     #    stuff
\\]                           #           ]
)
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
# optional trailing comments
)*
# address
|                             #  or
(?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
# Atom
|                       #  or
\"                                     # \"
[^\\\\\\x80-\\xff\\n\\015\"] *                            #   normal
(?:  \\\\ [^\\x80-\\xff]  [^\\\\\\x80-\\xff\\n\\015\"] * )*        #   ( special normal* )*
\"                                     #        \"
# Quoted string
)
# leading word
[^()<>@,;:\".\\\\\\[\\]\\x80-\\xff\\000-\\010\\012-\\037] *               # \"normal\" atoms and or spaces
(?:
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
|
\"                                     # \"
[^\\\\\\x80-\\xff\\n\\015\"] *                            #   normal
(?:  \\\\ [^\\x80-\\xff]  [^\\\\\\x80-\\xff\\n\\015\"] * )*        #   ( special normal* )*
\"                                     #        \"
) # \"special\" comment or quoted string
[^()<>@,;:\".\\\\\\[\\]\\x80-\\xff\\000-\\010\\012-\\037] *            #  more \"normal\"
)*
<
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
# <
(?:
@
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
(?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|
\\[                            # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*     #    stuff
\\]                           #           ]
)
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
# optional trailing comments
(?:
\\.
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
(?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|
\\[                            # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*     #    stuff
\\]                           #           ]
)
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
# optional trailing comments
)*
(?: ,
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
@
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
(?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|
\\[                            # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*     #    stuff
\\]                           #           ]
)
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
# optional trailing comments
(?:
\\.
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
(?:
[^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]+    # some number of atom characters...
(?![^(\\040)<>@,;:\".\\\\\\[\\]\\000-\\037\\x80-\\xff]) # ..not followed by something that could be part of an atom
|
\\[                            # [
(?: [^\\\\\\x80-\\xff\\n\\015\\[\\]] |  \\\\ [^\\x80-\\xff]  )*     #    stuff
\\]                           #           ]
)
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                                  #            )*
\\)                             #                )
[\\040\\t]* )*    # If comment found, allow more spaces.
# optional trailing comments
)*
)*  # additional domains
:
[\\040\\t]*                    # Nab whitespace.
(?:
\\(                              #  (
[^\\\\\\x80-\\xff\\n\\015()] *                             #     normal*
(?:                                 #       (
(?:  \\\\ [^\\x80-\\xff]  |
\\(                            #  (
[^\\\\\\x80-\\xff\\n\\015()] *                            #     normal*
(?:  \\\\ [^\\x80-\\xff]   [^\\\\\\x80-\\xff\\n\\015()] * )*        #     (special normal*)*
\\)                           #                       )
)    #         special
[^\\\\\\x80-\\xff\\n\\015()] *                         #         normal*
)*                 