.\" dpkg manual page - start-stop-daemon(8)
.\"
.\" Copyright © 1999 Klee Dienes <klee@mit.edu>
.\" Copyright © 1999 Ben Collins <bcollins@debian.org>
.\" Copyright © 2000-2001 Wichert Akkerman <wakkerma@debian.org>
.\" Copyright © 2002-2003 Adam Heath <doogie@debian.org>
.\" Copyright © 2004 Scott James Remnant <keybuk@debian.org>
.\" Copyright © 2008-2015 Guillem Jover <guillem@debian.org>
.\"
.\" This is free software; you can redistribute it and/or modify
.\" it under the terms of the GNU General Public License as published by
.\" the Free Software Foundation; either version 2 of the License, or
.\" (at your option) any later version.
.\"
.\" This is distributed in the hope that it will be useful,
.\" but WITHOUT ANY WARRANTY; without even the implied warranty of
.\" MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
.\" GNU General Public License for more details.
.\"
.\" You should have received a copy of the GNU General Public License
.\" along with this program.  If not, see <https://www.gnu.org/licenses/>.
.
.\"*******************************************************************
.\"
.\" This file was generated with po4a. Translate the source file.
.\"
.\"*******************************************************************
.TH start\-stop\-daemon 8 %RELEASE_DATE% %VERSION% "suite dpkg"
.nh
.SH NOM
start\-stop\-daemon \- lance ou arrête des démons système
.
.SH SYNOPSIS
\fBstart\-stop\-daemon\fP [\fIoption\fP...] \fIcommande\fP
.
.SH DESCRIPTION
On se sert de \fBstart\-stop\-daemon\fP pour contrôler la création ou l'arrêt de
processus système. En utilisant les options correspondantes,
\fBstart\-stop\-daemon\fP peut être configuré pour trouver les exemplaires
présents d'un processus en fonctionnement.
.PP
Veuillez noter qu'à moins d'utiliser \fB\-\-pid\fP ou \fB\-\-pidfile\fP, le programme
\fBstart\-stop\-daemon\fP se comporte comme \fBkillall\fP(1). \fBstart\-stop\-daemon\fP
recherche dans le tableau des processus tout processus qui correspond au
nom, pid parent, uid et/ou gid du processus (si indiqué). Toute
correspondance empêchera \fB\-\-start\fP de démarrer le démon. Tous les processus
qui correspondent recevront le signal TERM (ou le signal indiqué par
\fB\-\-signal\fP ou \fB\-\-retry\fP) si \fB\-\-stop\fP est indiqué. Pour les démons avec
des processus enfant qui doivent survivre à un \fB\-\-stop\fP, il est nécessaire
d'indiquer un fichier pid («\ pidfile\ »).
.
.SH COMMANDES
.TP 
\fB\-S\fP, \fB\-\-start\fP [\fB\-\-\fP] \fIparamètres\fP
Vérifier l'existence d'un processus particulier. Quand il existe un tel
processus, \fBstart\-stop\-daemon\fP ne fait rien et se termine avec un code
d'erreur égal à 1 (0 si \fB\-\-oknodo\fP est précisé). Quand un tel processus
n'existe pas, un exemplaire de l'exécutable est lancé, en utilisant le
paramètre de \fB\-\-exec\fP ou celui de \fB\-\-startas\fP si cette option est
précisée. Tout argument donné après \fB\-\-\fP sur la ligne de commande est passé
tel quel au programme qui doit être lancé.
.TP 
\fB\-K\fP, \fB\-\-stop\fP
Vérifier aussi l'existence d'un processus particulier. Quand un tel
processus existe, \fBstart\-stop\-daemon\fP lui envoie le signal précisé avec
\fB\-\-signal\fP et se termine avec un code d'erreur égal à 0. Quand un tel
processus n'existe pas, \fBstart\-stop\-daemon\fP se termine avec un code
d'erreur égal à 1 (0 si \fB\-\-oknodo\fP est précisé). Si \fB\-\-retry\fP est
indiquée, \fBstart\-stop\-daemon\fP recherche si le processus ou les processus se
sont bien terminés.
.TP 
\fB\-T\fP, \fB\-\-status\fP
Check for the existence of a specified process, and returns an exit status
code, according to the LSB Init Script Actions (since version 1.16.1).
.TP 
\fB\-H\fP, \fB\-\-help\fP
Affiche un message d'aide, puis quitte.
.TP 
\fB\-V\fP, \fB\-\-version\fP
Affiche la version du programme, puis quitte.
.
.SH OPTIONS
.SS "Options de correspondance"
.TP 
[\fB\-\-pid\fP] \fIpid\fP
Check for a process with the specified \fIpid\fP (since version 1.17.6).  The
\fIpid\fP must be a number greater than 0.
.TP 
[\fB\-\-ppid\fP] \fIpid parent\fP
Check for a process with the specified parent pid \fIppid\fP (since version
1.17.7).  The \fIppid\fP must be a number greater than 0.
.TP 
\fB\-p\fP, \fB\-\-pidfile\fP \fIpid\-file\fP
Contrôle si un processus a créé le fichier \fIfichier\-pid\fP. Note\ :
l'utilisation de l'option de correspondance seule peut provoquer des actions
sur des processus non prévus, si l'ancien processus s'est terminé dans
savoir retiré le \fIfichier\-pid\fP.
.TP 
\fB\-x\fP, \fB\-\-exec\fP \fIexécutable\fP
Contrôle l'existence de processus qui soient des exemplaires de cet
\fIexécutable\fP. Le paramètre \fIexécutable\fP doit être un chemin
absolu. Note\ :\ cela peut ne pas fonctionner avec des scripts interprétés,
car l'exécutable sera alors l'interpréteur. Des processus en exécution au
sein d'un environnement fermé d'exécution («\ chroot\ ») seront également
trouvés et il peut donc être nécessaire d'ajouter d'autres restrictions de
correspondance.
.TP 
\fB\-n\fP, \fB\-\-name\fP \fInom\-de\-processus\fP
Contrôle l'existence de processus avec \fInom\-de\-processus\fP comme nom. Le
\fInom\-de\-processus\fP est en général le nom du fichier du processus, mais peut
avoir été modifié par le processus lui\-même. Note\ : sur la plupart des
systèmes, cette information est récupérée par le nom de communication du
noyau, ce qui induit une limite de longueur assez courte (la portabilité
impose de ne pas supposer plus de 15 caractères).
.TP 
\fB\-u\fP, \fB\-\-user\fP \fIidentifiant\fP|\fIuid\fP
Contrôle l'existence de processus dont le propriétaire est \fIidentifiant\fP ou
\fIuid\fP. Note\ : si cette option est utilisée seule, tous les processus de cet
utilisateur seront concernés par l'action.
.
.SS "Options génériques"
.TP 
\fB\-g\fP, \fB\-\-group\fP \fIgroupe\fP|\fIgid\fP
Modifie le \fIgroupe\fP ou le \fIgid\fP au début du processus.
.TP 
\fB\-s\fP, \fB\-\-signal\fP \fIsignal\fP
L'action \fB\-\-stop\fP définit le signal à envoyer au processus qui doit être
arrêté (par défaut\ : TERM).
.TP 
\fB\-R\fP, \fB\-\-retry\fP \fIdurée\fP|\fIaction\-prévue\fP
Avec l'action \fB\-\-stop\fP, \fBstart\-stop\-daemon\fP doit vérifier que les
processus se sont terminés. Il le fait pour tous les processus
correspondants qui tournent, jusqu'à ce qu'il n'y en ait plus. Quand le
processus ne se termine pas, il prend d'autres mesures déterminées par
l'\fIaction\-prévue\fP.

Si \fIdurée\fP est indiquée plutôt que \fIaction\-prévue\fP, l'action\-prévue
\fIsignal\fP\fB/\fP\fIdurée\fP\fB/KILL/\fP\fIdurée\fP est utilisée, où \fIsignal\fP est le
signal indiqué par \fB\-\-signal\fP.

\fIaction\-prévue\fP est une liste d'au moins deux items séparés par des barres
obliques (\fB/\fP)\ ; chaque item peut être de la forme \fB\-\fP\fIsignal\-numéro\fP ou
de la forme [\fB\-\fP]\fIsignal\-nom\fP, ce qui demande d'envoyer ce signal\ ; ou
bien de la forme \fIdurée,\fP ce qui demande d'attendre tant de secondes avant
de terminer les processus, ou bien de la forme \fBforever\fP, ce qui demande de
répéter constamment le reste de action\-prévue, si nécessaire.

Quand la fin de l'action\-prévue est atteinte et que \fBforever\fP n'a pas été
précisé, \fBstart\-stop\-daemon\fP se termine avec un code d'erreur égal à
2. Quand une action\-prévue est indiquée, tout signal donné par \fB\-\-signal\fP
est ignoré.
.TP 
\fI\-a\fP, \fB\-\-startas\fP \fInom\-de\-chemin\fP
Avec l'action \fB\-\-start\fP, lance le processus spécifié par
\fInom\-de\-chemin\fP. Si rien n'est précisé, c'est par défaut l'argument donné à
\fB\-\-exec\fP.
.TP 
\fB\-t\fP, \fB\-\-test\fP
Affiche les actions qui seraient entreprises et détermine la bonne valeur de
retour, mais ne fait rien.
.TP 
\fB\-o\fP, \fB\-\-oknodo\fP
Retourne un code de sortie égal à 0 au lieu de 1 si rien n'est ou ne sera
fait.
.TP 
\fB\-q\fP, \fB\-\-quiet\fP
N'affiche pas de messages d'information\ ; affiche seulement les messages
d'erreur.
.TP 
\fB\-c\fP, \fB\-\-chuid\fP \fIidentifiant\fP|\fIuid\fP[\fB:\fP\fIgroupe\fP|\fIgid\fP]
Change to this username/uid before starting the process. You can also
specify a group by appending a \fB:\fP, then the group or gid in the same way
as you would for the \fBchown\fP(1) command (\fIuser\fP\fB:\fP\fIgroup\fP).  If a user
is specified without a group, the primary GID for that user is used.  When
using this option you must realize that the primary and supplemental groups
are set as well, even if the \fB\-\-group\fP option is not specified. The
\fB\-\-group\fP option is only for groups that the user isn't normally a member
of (like adding per process group membership for generic users like
\fBnobody\fP).
.TP 
\fB\-r\fP, \fB\-\-chroot\fP \fIroot\fP
Change de répertoire racine pour \fBroot\fP avant de lancer le
processus. Remarquez que le «\ pidfile\ » est aussi écrit après le changement
de racine.
.TP 
\fB\-d\fP, \fB\-\-chdir\fP \fIchemin\fP
Change de répertoire pour \fIchemin\fP avant de commencer le processus. Cela
est fait après le changement de répertoire racine si l'option
\fB\-r\fP|\fB\-\-chroot\fP est demandée. Si rien n'est demandé, \fBstart\-stop\-daemon\fP
changera de répertoire pour le répertoire racine avant de commencer le
processus.
.TP 
\fB\-b\fP, \fB\-\-background\fP
Typically used with programs that don't detach on their own. This option
will force \fBstart\-stop\-daemon\fP to fork before starting the process, and
force it into the background.  \fBWarning: start\-stop\-daemon\fP cannot check
the exit status if the process fails to execute for \fBany\fP reason. This is a
last resort, and is only meant for programs that either make no sense
forking on their own, or where it's not feasible to add the code for them to
do this themselves.
.TP 
\fB\-C\fP, \fB\-\-no\-close\fP
Do not close any file descriptor when forcing the daemon into the background
(since version 1.16.5).  Used for debugging purposes to see the process
output, or to redirect file descriptors to log the process output.  Only
relevant when using \fB\-\-background\fP.
.TP 
\fB\-N\fP, \fB\-\-nicelevel\fP \fIint\fP
Cela modifie la priorité du processus avant qu'il ne soit lancé.
.TP 
\fB\-P\fP, \fB\-\-procsched\fP \fIpolitique\fP\fB:\fP\fIpriorité\fP
This alters the process scheduler policy and priority of the process before
starting it (since version 1.15.0).  The priority can be optionally
specified by appending a \fB:\fP followed by the value. The default \fIpriority\fP
is 0. The currently supported policy values are \fBother\fP, \fBfifo\fP and \fBrr\fP.
.TP 
\fB\-I\fP, \fB\-\-iosched\fP \fIclasse\fP\fB:\fP\fIpriorité\fP
This alters the IO scheduler class and priority of the process before
starting it (since version 1.15.0).  The priority can be optionally
specified by appending a \fB:\fP followed by the value. The default \fIpriority\fP
is 4, unless \fIclass\fP is \fBidle\fP, then \fIpriority\fP will always be 7. The
currently supported values for \fIclass\fP are \fBidle\fP, \fBbest\-effort\fP and
\fBreal\-time\fP.
.TP 
\fB\-k\fP, \fB\-\-umask\fP \fImasque\fP
This sets the umask of the process before starting it (since version
1.13.22).
.TP 
\fB\-m\fP, \fB\-\-make\-pidfile\fP
Used when starting a program that does not create its own pid file. This
option will make \fBstart\-stop\-daemon\fP create the file referenced with
\fB\-\-pidfile\fP and place the pid into it just before executing the
process. Note, the file will only be removed when stopping the program if
\fB\-\-remove\-pidfile\fP is used.  \fBNote:\fP This feature may not work in all
cases. Most notably when the program being executed forks from its main
process. Because of this, it is usually only useful when combined with the
\fB\-\-background\fP option.
.TP 
\fB\-\-remove\-pidfile\fP
Used when stopping a program that does not remove its own pid file (since
version 1.17.19).  This option will make \fBstart\-stop\-daemon\fP remove the
file referenced with \fB\-\-pidfile\fP after terminating the process.
.TP 
\fB\-v\fP, \fB\-\-verbose\fP
Affiche des messages prolixes en renseignements.
.
.SH "CODE DE SORTIE"
.TP 
\fB0\fP
L'action demandée a été effectuée. Si \fB\-\-oknodo\fP était indiqué, il est
également possible que rien ne se soit passé. Cela peut se produire si
\fB\-\-start\fP était indiqué et qu'un processus correspondant était déjà en
train de s'exécuter ou si \fB\-\-stop\fP était indiqué et qu'aucun processus ne
correspondait.
.TP 
\fB1\fP
Si \fB\-\-oknodo\fP n'était pas indiqué et que rien ne s'est passé.
.TP 
\fB2\fP
Si \fB\-\-stop\fP et \fB\-\-retry\fP étaient indiqués mais que la fin de la
planification a été atteinte et que les processus étaient toujours en cours
d'exécution.
.TP 
\fB3\fP
Toute autre erreur.
.PP
Lorsque la commande \fB\-\-status\fP est utilisée, les codes d'état suivants sont
renvoyés\ :
.TP 
\fB0\fP
Le programme est en cours d'exécution.
.TP 
\fB1\fP
Le programme n'est pas en cours d'exécution et le fichier PID existe.
.TP 
\fB3\fP
Le programme n'est pas en cours d'exécution.
.TP 
\fB4\fP
Impossible de déterminer l'état du programme.
.
.SH EXEMPLE
Démarre le démon \fBfood\fP, à moins qu'il soit déjà en cours d'exécution (un
processus nommé \fBfood\fP, tournant sous le nom d'utilisateur \fBfood\fP, avec un
pid dans food.pid)\ :
.IP
.nf
start\-stop\-daemon \-\-start \-\-oknodo \-\-user food \-\-name food \e
	\-\-pidfile /run/food.pid \-\-startas /usr/sbin/food \e
	\-\-chuid food \-\- \-\-daemon
.fi
.PP
Envoie le signal \fBSIGTERM\fP à \fBfood\fP et attend durant 5 secondes son
arrêt\ :
.IP
.nf
start\-stop\-daemon \-\-stop \-\-oknodo \-\-user food \-\-name food \e
	\-\-pidfile /run/food.pid \-\-retry 5
.fi
.PP
Démonstration d'un ordonnanceur personnalisé pour l'arrêt de \fBfood\fP\ :
.IP
.nf
start\-stop\-daemon \-\-stop \-\-oknodo \-\-user food \-\-name food \e
	\-\-pidfile /run/food.pid \-\-retry=TERM/30/KILL/5
.fi
.SH TRADUCTION
Ariel VARDI <ariel.vardi@freesbee.fr>, 2002.
Philippe Batailler, 2006.
Nicolas François, 2006.
Veuillez signaler toute erreur à <debian\-l10n\-french@lists.debian.org>.
