//-- cbbcsd --------------------------------------------------------------------
void
LAPACK_DECL(cbbcsd)(const char       *JOBU1,
                    const char       *JOBU2,
                    const char       *JOBV1T,
                    const char       *JOBV2T,
                    const char       *TRANS,
                    const INTEGER    *M,
                    const INTEGER    *P,
                    const INTEGER    *Q,
                    FLOAT            *THETA,
                    FLOAT            *PHI,
                    FLOAT_COMPLEX    *U1,
                    const INTEGER    *LDU1,
                    FLOAT_COMPLEX    *U2,
                    const INTEGER    *LDU2,
                    FLOAT_COMPLEX    *V1T,
                    const INTEGER    *LDV1T,
                    FLOAT_COMPLEX    *V2T,
                    const INTEGER    *LDV2T,
                    FLOAT            *B11D,
                    FLOAT            *B11E,
                    FLOAT            *B12D,
                    FLOAT            *B12E,
                    const FLOAT      *B21D,
                    const FLOAT      *B21E,
                    const FLOAT      *B22D,
                    const FLOAT      *B22E,
                    FLOAT            *RWORK,
                    const INTEGER    *LRWORK,
                    INTEGER          *INFO)
{
    DEBUG_LAPACK_STUB("cbbcsd");
    LAPACK_IMPL(cbbcsd)(JOBU1,
                        JOBU2,
                        JOBV1T,
                        JOBV2T,
                        TRANS,
                        M,
                        P,
                        Q,
                        THETA,
                        PHI,
                        U1,
                        LDU1,
                        U2,
                        LDU2,
                        V1T,
                        LDV1T,
                        V2T,
                        LDV2T,
                        B11D,
                        B11E,
                        B12D,
                        B12E,
                        B21D,
                        B21E,
                        B22D,
                        B22E,
                        RWORK,
                        LRWORK,
                        INFO);
}

//-- cbdsqr --------------------------------------------------------------------
void
LAPACK_DECL(cbdsqr)(const char       *UPLO,
                    const INTEGER    *N,
                    const INTEGER    *NCVT,
                    const INTEGER    *NRU,
                    const INTEGER    *NCC,
                    FLOAT            *D,
                    FLOAT            *E,
                    FLOAT_COMPLEX    *VT,
                    const INTEGER    *LDVT,
                    FLOAT_COMPLEX    *U,
                    const INTEGER    *LDU,
                    FLOAT_COMPLEX    *C,
                    const INTEGER    *LDC,
                    FLOAT            *RWORK,
                    INTEGER          *INFO)
{
    DEBUG_LAPACK_STUB("cbdsqr");
    LAPACK_IMPL(cbdsqr)(UPLO,
                        N,
                        NCVT,
                        NRU,
                        NCC,
                        D,
                        E,
                        VT,
                        LDVT,
                        U,
                        LDU,
                        C,
                        LDC,
                        RWORK,
                        INFO);
}

//-- cgbbrd --------------------------------------------------------------------
void
LAPACK_DECL(cgbbrd)(const char       *VECT,
                    const INTEGER    *M,
                    const INTEGER    *N,
                    const INTEGER    *NCC,
                    const INTEGER    *KL,
                    const INTEGER    *KU,
                    FLOAT_COMPLEX    *AB,
                    const INTEGER    *LDAB,
                    FLOAT            *D,
                    FLOAT            *E,
                    FLOAT_COMPLEX    *Q,
                    const INTEGER    *LDQ,
                    FLOAT_COMPLEX    *PT,
                    const INTEGER    *LDPT,
                    FLOAT_COMPLEX    *C,
                    const INTEGER    *LDC,
                    FLOAT_COMPLEX    *WORK,
                    FLOAT            *RWORK,
                    INTEGER          *INFO)
{
    DEBUG_LAPACK_STUB("cgbbrd");
    LAPACK_IMPL(cgbbrd)(VECT,
                        M,
                        N,
                        NCC,
                        KL,
                        KU,
                        AB,
                        LDAB,
                        D,
                        E,
                        Q,
                        LDQ,
                        PT,
                        LDPT,
                        C,
                        LDC,
                        WORK,
                        RWORK,
                        INFO);
}

//-- cgbcon --------------------------------------------------------------------
void
LAPACK_DECL(cgbcon)(const char           *NORM,
                    const INTEGER        *N,
                    const INTEGER        *KL,
                    const INTEGER        *KU,
                    const FLOAT_COMPLEX  *AB,
                    const INTEGER        *LDAB,
                    const INTEGER        *IPIV,
                    const FLOAT          *ANORM,
                    FLOAT                *RCOND,
                    FLOAT_COMPLEX        *WORK,
                    FLOAT                *RWORK,
                    INTEGER              *INFO)
{
    DEBUG_LAPACK_STUB("cgbcon");
    LAPACK_IMPL(cgbcon)(NORM,
                        N,
                        KL,
                        KU,
                        AB,
                        LDAB,
                        IPIV,
                        ANORM,
                        RCOND,
                        WORK,
                        RWORK,
                        INFO);
}

//-- cgbequ --------------------------------------------------------------------
void
LAPACK_DECL(cgbequ)(const INTEGER        *M,
                    const INTEGER        *N,
                    const INTEGER        *KL,
                    const INTEGER        *KU,
                    const FLOAT_COMPLEX  *AB,
                    const INTEGER        *LDAB,
                    FLOAT                *R,
                    FLOAT                *C,
                    FLOAT                *ROWCND,
                    FLOAT                *COLCND,
                    FLOAT                *AMAX,
                    INTEGER              *INFO)
{
    DEBUG_LAPACK_STUB("cgbequ");
    LAPACK_IMPL(cgbequ)(M,
                        N,
                        KL,
                        KU,
                        AB,
                        LDAB,
                        R,
                        C,
                        ROWCND,
                        COLCND,
                        AMAX,
                        INFO);
}

//-- cgbequb -------------------------------------------------------------------
void
LAPACK_DECL(cgbequb)(const INTEGER            *M,
                     const INTEGER            *N,
                     const INTEGER            *KL,
                     const INTEGER            *KU,
                     const FLOAT_COMPLEX      *AB,
                     const INTEGER            *LDAB,
                     FLOAT                    *R,
                     FLOAT                    *C,
                     FLOAT                    *ROWCND,
                     FLOAT                    *COLCND,
                     FLOAT                    *AMAX,
                     INTEGER                  *INFO)
{
    DEBUG_LAPACK_STUB("cgbequb");
    LAPACK_IMPL(cgbequb)(M,
                         N,
                         KL,
                         KU,
                         AB,
                         LDAB,
                         R,
                         C,
                         ROWCND,
                         COLCND,
                         AMAX,
                         INFO);
}

//-- cgbrfs --------------------------------------------------------------------
void
LAPACK_DECL(cgbrfs)(const char           *TRANS,
                    const INTEGER        *N,
                    const INTEGER        *KL,
                    const INTEGER        *KU,
                    const INTEGER        *NRHS,
                    const FLOAT_COMPLEX  *AB,
                    const INTEGER        *LDAB,
                    const FLOAT_COMPLEX  *AFB,
                    const INTEGER        *LDAFB,
                    const INTEGER        *IPIV,
                    const FLOAT_COMPLEX  *B,
                    const INTEGER        *LDB,
                    FLOAT_COMPLEX        *X,
                    const INTEGER        *LDX,
                    FLOAT                *FERR,
                    FLOAT                *BERR,
                    FLOAT_COMPLEX        *WORK,
                    FLOAT                *RWORK,
                    INTEGER              *INFO)
{
    DEBUG_LAPACK_STUB("cgbrfs");
    LAPACK_IMPL(cgbrfs)(TRANS,
                        N,
                        KL,
                        KU,
                        NRHS,
                        AB,
                        LDAB,
                        AFB,
                        LDAFB,
                        IPIV,
                        B,
                        LDB,
                        X,
                        LDX,
                        FERR,
                        BERR,
                        WORK,
                        RWORK,
                        INFO);
}

//-- cgbrfsx -------------------------------------------------------------------
void
LAPACK_DECL(cgbrfsx)(const char               *TRANS,
                     const char               *EQUED,
                     const INTEGER            *N,
                     const INTEGER            *KL,
                     const INTEGER            *KU,
                     const INTEGER            *NRHS,
                     const FLOAT_COMPLEX      *AB,
                     const INTEGER            *LDAB,
                     const FLOAT_COMPLEX      *AFB,
                     const INTEGER            *LDAFB,
                     const INTEGER            *IPIV,
                     FLOAT                    *R,
                     FLOAT                    *C,
                     const FLOAT_COMPLEX      *B,
                     const INTEGER            *LDB,
                     FLOAT_COMPLEX            *X,
                     const INTEGER            *LDX,
                     FLOAT                    *RCOND,
                     FLOAT                    *BERR,
                     const INTEGER            *N_ERR_BNDS,
                     FLOAT                    *ERR_BNDS_NORM,
                     FLOAT                    *ERR_BNDS_COMP,
                     const INTEGER            *NPARAMS,
                     FLOAT                    *PARAMS,
                     FLOAT_COMPLEX            *WORK,
                     FLOAT                    *RWORK,
                     INTEGER                  *INFO)
{
    DEBUG_LAPACK_STUB("cgbrfsx");
    LAPACK_IMPL(cgbrfsx)(TRANS,
                         EQUED,
                         N,
                         KL,
                         KU,
                         NRHS,
                         AB,
                         LDAB,
                         AFB,
                         LDAFB,
                         IPIV,
                         R,
                         C,
                         B,
                         LDB,
                         X,
                         LDX,
                         RCOND,
                         BERR,
                         N_ERR_BNDS,
                         ERR_BNDS_NORM,
                         ERR_BNDS_COMP,
                         NPARAMS,
                         PARAMS,
                         WORK,
                         RWORK,
                         INFO);
}

//-- cgbsv ---------------------------------------------------------------------
void
LAPACK_DECL(cgbsv)(const INTEGER        *N,
                   const INTEGER        *KL,
                   const INTEGER        *KU,
                   const INTEGER        *NRHS,
                   FLOAT_COMPLEX        *AB,
                   const INTEGER        *LDAB,
                   INTEGER              *IPIV,
                   FLOAT_COMPLEX        *B,
                   const INTEGER        *LDB,
                   INTEGER              *INFO)
{
    DEBUG_LAPACK_STUB("cgbsv");
    LAPACK_IMPL(cgbsv)(N,
                       KL,
                       KU,
                       NRHS,
                       AB,
                       LDAB,
                       IPIV,
                       B,
                       LDB,
                       INFO);
}

//-- cgbsvx --------------------------------------------------------------------
void
LAPACK_DECL(cgbsvx)(const char       *FACT,
                    const char       *TRANS,
                    const INTEGER    *N,
                    const INTEGER    *KL,
                    const INTEGER    *KU,
                    const INTEGER    *NRHS,
                    FLOAT_COMPLEX    *AB,
                    const INTEGER    *LDAB,
                    FLOAT_COMPLEX    *AFB,
                    const INTEGER    *LDAFB,
                    INTEGER          *IPIV,
                    char             *EQUED,
                    FLOAT            *R,
                    FLOAT            *C,
                    FLOAT_COMPLEX    *B,
                    const INTEGER    *LDB,
                    FLOAT_COMPLEX    *X,
                    const INTEGER    *LDX,
                    FLOAT            *RCOND,
                    FLOAT            *FERR,
                    FLOAT            *BERR,
                    FLOAT_COMPLEX    *WORK,
                    FLOAT            *RWORK,
                    INTEGER          *INFO)
{
    DEBUG_LAPACK_STUB("cgbsvx");
    LAPACK_IMPL(cgbsvx)(FACT,
                        TRANS,
                        N,
                        KL,
                        KU,
                        NRHS,
                        AB,
                        LDAB,
                        AFB,
                        LDAFB,
                        IPIV,
                        EQUED,
                        R,
                        C,
                        B,
                        LDB,
                        X,
                        LDX,
                        RCOND,
                        FERR,
                        BERR,
                        WORK,
                        RWORK,
                        INFO);
}

//-- cgbtf2 --------------------------------------------------------------------
void
LAPACK_DECL(cgbtf2)(const INTEGER    *M,
                    const INTEGER    *N,
                    const INTEGER    *KL,
                    const INTEGER    *KU,
                    FLOAT_COMPLEX    *AB,
                    const INTEGER    *LDAB,
                    INTEGER          *IPIV,
                    INTEGER          *INFO)
{
    DEBUG_LAPACK_STUB("cgbtf2");
    LAPACK_IMPL(cgbtf2)(M,
                        N,
                        KL,
                        KU,
                        AB,
                        LDAB,
                        IPIV,
                        INFO);
}

//-- cgbtrf --------------------------------------------------------------------
void
LAPACK_DECL(cgbtrf)(const INTEGER    *M,
                    const INTEGER    *N,
                    const INTEGER    *KL,
                    const INTEGER    *KU,
                    FLOAT_COMPLEX    *AB,
                    const INTEGER    *LDAB,
                    INTEGER          *IPIV,
                    INTEGER          *INFO)
{
    DEBUG_LAPACK_STUB("cgbtrf");
    LAPACK_IMPL(cgbtrf)(M,
                        N,
                        KL,
                        KU,
                        AB,
                        LDAB,
                        IPIV,
                        INFO);
}

//-- cgbtrs --------------------------------------------------------------------
void
LAPACK_DECL(cgbtrs)(const char           *TRANS,
                    const INTEGER        *N,
                    const INTEGER        *KL,
                    const INTEGER        *KU,
                    const INTEGER        *NRHS,
                    const FLOAT_COMPLEX  *AB,
                    const INTEGER        *LDAB,
                    const INTEGER        *IPIV,
                    FLOAT_COMPLEX        *B,
                    const INTEGER        *LDB,
                    INTEGER              *INFO)
{
    DEBUG_LAPACK_STUB("cgbtrs");
    LAPACK_IMPL(cgbtrs)(TRANS,
                        N,
                        KL,
                        KU,
                        NRHS,
                        AB,
                        LDAB,
                        IPIV,
                        B,
                        LDB,
                        INFO);
}

//-- cgebak --------------------------------------------------------------------
void
LAPACK_DECL(cgebak)(const char       *JOB,
                    const char       *SIDE,
                    const INTEGER    *N,
                    const INTEGER    *ILO,
                    const INTEGER    *IHI,
                    const FLOAT      *SCALE,
                    const INTEGER    *M,
                    FLOAT_COMPLEX    *V,
                    const INTEGER    *LDV,
                    INTEGER          *INFO)
{
    DEBUG_LAPACK_STUB("cgebak");
    LAPACK_IMPL(cgebak)(JOB,
                        SIDE,
                        N,
                        ILO,
                        IHI,
                        SCALE,
                        M,
                        V,
                        LDV,
                        INFO);
}

//-- cgebal --------------------------------------------------------------------
void
LAPACK_DECL(cgebal)(const char       *JOB,
                    const INTEGER    *N,
                    FLOAT_COMPLEX    *A,
                    const INTEGER    *LDA,
                    INTEGER          *ILO,
                    INTEGER          *IHI,
                    FLOAT            *SCALE,
                    INTEGER          *INFO)
{
    DEBUG_LAPACK_STUB("cgebal");
    LAPACK_IMPL(cgebal)(JOB,
                        N,
                        A,
                        LDA,
                        ILO,
                        IHI,
                        SCALE,
                        INFO);
}

//-- cgebd2 --------------------------------------------------------------------
void
LAPACK_DECL(cgebd2)(const INTEGER    *M,
                    const INTEGER    *N,
                    FLOAT_COMPLEX    *A,
                    const INTEGER    *LDA,
                    FLOAT            *D,
                    FLOAT            *E,
                    FLOAT_COMPLEX    *TAUQ,
                    FLOAT_COMPLEX    *TAUP,
                    FLOAT_COMPLEX    *WORK,
                    INTEGER          *INFO)
{
    DEBUG_LAPACK_STUB("cgebd2");
    LAPACK_IMPL(cgebd2)(M,
                        N,
                        A,
                        LDA,
                        D,
                        E,
                        TAUQ,
                        TAUP,
                        WORK,
                        INFO);
}

//-- cgebrd --------------------------------------------------------------------
void
LAPACK_DECL(cgebrd)(const INTEGER    *M,
                    const INTEGER    *N,
                    FLOAT_COMPLEX    *A,
                    const INTEGER    *LDA,
                    FLOAT            *D,
                    FLOAT            *E,
                    FLOAT_COMPLEX    *TAUQ,
                    FLOAT_COMPLEX    *TAUP,
                    FLOAT_COMPLEX    *WORK,
                    const INTEGER    *LWORK,
                    INTEGER          *INFO)
{
    DEBUG_LAPACK_STUB("cgebrd");
    LAPACK_IMPL(cgebrd)(M,
                        N,
                        A,
                        LDA,
                        D,
                        E,
                        TAUQ,
                        TAUP,
                        WORK,
                        LWORK,
                        INFO);
}

//-- cgecon --------------------------------------------------------------------
void
LAPACK_DECL(cgecon)(const char           *NORM,
                    const INTEGER        *N,
                    const FLOAT_COMPLEX  *A,
                    const INTEGER        *LDA,
                    const FLOAT          *ANORM,
                    FLOAT                *RCOND,
                    FLOAT_COMPLEX        *WORK,
                    FLOAT                *RWORK,
                    INTEGER              *INFO)
{
    DEBUG_LAPACK_STUB("cgecon");
    LAPACK_IMPL(cgecon)(NORM,
                        N,
                        A,
                        LDA,
                        ANORM,
                        RCOND,
                        WORK,
                        RWORK,
                        INFO);
}

//-- cgeequ --------------------------------------------------------------------
void
LAPACK_DECL(cgeequ)(const INTEGER        *M,
                    const INTEGER        *N,
                    const FLOAT_COMPLEX  *A,
                    const INTEGER        *LDA,
                    FLOAT                *R,
                    FLOAT                *C,
                    FLOAT                *ROWCND,
                    FLOAT                *COLCND,
                    FLOAT                *AMAX,
                    INTEGER              *INFO)
{
    DEBUG_LAPACK_STUB("cgeequ");
    LAPACK_IMPL(cgeequ)(M,
                        N,
                        A,
                        LDA,
                        R,
                        C,
                        ROWCND,
                        COLCND,
                        AMAX,
                        INFO);
}

//-- cgeequb -------------------------------------------------------------------
void
LAPACK_DECL(cgeequb)(const INTEGER            *M,
                     const INTEGER            *N,
                     const FLOAT_COMPLEX      *A,
                     const INTEGER            *LDA,
                     FLOAT                    *R,
                     FLOAT                    *C,
                     FLOAT                    *ROWCND,
                     FLOAT                    *COLCND,
                     FLOAT                    *AMAX,
                     INTEGER                  *INFO)
{
    DEBUG_LAPACK_STUB("cgeequb");
    LAPACK_IMPL(cgeequb)(M,
                         N,
                         A,
                         LDA,
                         R,
                         C,
                         ROWCND,
                         COLCND,
                         AMAX,
                         INFO);
}

//-- cgees ---------------------------------------------------------------------
void
LAPACK_DECL(cgees)(const char           *JOBVS,
                   const char           *SORT,
                   const LOGICAL        *SELECT,
                   const INTEGER        *N,
                   FLOAT_COMPLEX        *A,
                   const INTEGER        *LDA,
                   INTEGER              *SDIM,
                   FLOAT_COMPLEX        *W,
                   FLOAT_COMPLEX        *VS,
                   const INTEGER        *LDVS,
                   FLOAT_COMPLEX        *WORK,
                   const INTEGER        *LWORK,
                   FLOAT                *RWORK,
                   LOGICAL              *BWORK,
                   INTEGER              *INFO)
{
    DEBUG_LAPACK_STUB("cgees");
    LAPACK_IMPL(cgees)(JOBVS,
                       SORT,
                       SELECT,
                       N,
                       A,
                       LDA,
                       SDIM,
                       W,
                       VS,
                       LDVS,
                       WORK,
                       LWORK,
                       RWORK,
                       BWORK,
                       INFO);
}

//-- cgeesx --------------------------------------------------------------------
void
LAPACK_DECL(cgeesx)(const char       *JOBVS,
                    const char       *SORT,
                    const LOGICAL    *SELECT,
                    const char       *SENSE,
                    const INTEGER    *N,
                    FLOAT_COMPLEX    *A,
                    const INTEGER    *LDA,
                    INTEGER          *SDIM,
                    FLOAT_COMPLEX    *W,
                    FLOAT_COMPLEX    *VS,
                    const INTEGER    *LDVS,
                    FLOAT            *RCONDE,
                    FLOAT            *RCONDV,
                    FLOAT_COMPLEX    *WORK,
                    const INTEGER    *LWORK,
                    FLOAT            *RWORK,
                    LOGICAL          *BWORK,
                    INTEGER          *INFO)
{
    DEBUG_LAPACK_STUB("cgeesx");
    LAPACK_IMPL(cgeesx)(JOBVS,
                        SORT,
                        SELECT,
                        SENSE,
                        N,
                        A,
                        LDA,
                        SDIM,
                        W,
                        VS,
                        LDVS,
                        RCONDE,
                        RCONDV,
                        WORK,
                        LWORK,
                        RWORK,
                        BWORK,
                        INFO);
}

//-- cgeev ---------------------------------------------------------------------
void
LAPACK_DECL(cgeev)(const char           *JOBVL,
                   const char           *JOBVR,
                   const INTEGER        *N,
                   FLOAT_COMPLEX        *A,
                   const INTEGER        *LDA,
                   FLOAT_COMPLEX        *W,
                   FLOAT_COMPLEX        *VL,
                   const INTEGER        *LDVL,
                   FLOAT_COMPLEX        *VR,
                   const INTEGER        *LDVR,
                   FLOAT_COMPLEX        *WORK,
                   const INTEGER        *LWORK,
                   FLOAT                *RWORK,
                   INTEGER              *INFO)
{
    DEBUG_LAPACK_STUB("cgeev");
    LAPACK_IMPL(cgeev)(JOBVL,
                       JOBVR,
                       N,
                       A,
                       LDA,
                       W,
                       VL,
                       LDVL,
                       VR,
                       LDVR,
                       WORK,
                       LWORK,
                       RWORK,
                       INFO);
}

//-- cgeevx --------------------------------------------------------------------
void
LAPACK_DECL(cgeevx)(const char       *BALANC,
                    const char       *JOBVL,
                    const char       *JOBVR,
                    const char       *SENSE,
                    const INTEGER    *N,
                    FLOAT_COMPLEX    *A,
                    const INTEGER    *LDA,
                    FLOAT_COMPLEX    *W,
                    FLOAT_COMPLEX    *VL,
                    const INTEGER    *LDVL,
                    FLOAT_COMPLEX    *VR,
                    const INTEGER    *LDVR,
                    INTEGER          *ILO,
                    INTEGER          *IHI,
                    FLOAT            *SCALE,
                    FLOAT            *ABNRM,
                    FLOAT            *RCONDE,
                    FLOAT            *RCONDV,
                    FLOAT_COMPLEX    *WORK,
                    const INTEGER    *LWORK,
                    FLOAT            *RWORK,
                    INTEGER          *INFO)
{
    DEBUG_LAPACK_STUB("cgeevx");
    LAPACK_IMPL(cgeevx)(BALANC,
                        JOBVL,
                        JOBVR,
                        SENSE,
                        N,
                        A,
                        LDA,
                        W,
                        VL,
                        LDVL,
                        VR,
                        LDVR,
                        ILO,
                        IHI,
                        SCALE,
                        ABNRM,
                        RCONDE,
                        RCONDV,
                        WORK,
                        LWORK,
                        RWORK,
                        INFO);
}

//-- cgegs ---------------------------------------------------------------------
void
LAPACK_DECL(cgegs)(const char           *JOBVSL,
                   const char           *JOBVSR,
                   const INTEGER        *N,
                   FLOAT_COMPLEX        *A,
                   const INTEGER        *LDA,
                   FLOAT_COMPLEX        *B,
                   const INTEGER        *LDB,
                   FLOAT_COMPLEX        *ALPHA,
                   FLOAT_COMPLEX        *BETA,
                   FLOAT_COMPLEX        *VSL,
                   const INTEGER        *LDVSL,
                   FLOAT_COMPLEX        *VSR,
                   const INTEGER        *LDVSR,
                   FLOAT_COMPLEX        *WORK,
                   const INTEGER        *LWORK,
                   FLOAT                *RWORK,
                   INTEGER              *INFO)
{
    DEBUG_LAPACK_STUB("cgegs");
    LAPACK_IMPL(cgegs)(JOBVSL,
                       JOBVSR,
                       N,
                       A,
                       LDA,
                       B,
                       LDB,
                       ALPHA,
                       BETA,
                       VSL,
                       LDVSL,
                       VSR,
                       LDVSR,
                       WORK,
                       LWORK,
                       RWORK,
                       INFO);
}

//-- cgegv ---------------------------------------------------------------------
void
LAPACK_DECL(cgegv)(const char           *JOBVL,
                   const char           *JOBVR,
                   const INTEGER        *N,
                   FLOAT_COMPLEX        *A,
                   const INTEGER        *LDA,
                   FLOAT_COMPLEX        *B,
                   const INTEGER        *LDB,
                   FLOAT_COMPLEX        *ALPHA,
                   FLOAT_COMPLEX        *BETA,
                   FLOAT_COMPLEX        *VL,
                   const INTEGER        *LDVL,
                   FLOAT_COMPLEX        *VR,
                   const INTEGER        *LDVR,
                   FLOAT_COMPLEX        *WORK,
                   const INTEGER        *LWORK,
                   FLOAT                *RWORK,
                   INTEGER              *INFO)
{
    DEBUG_LAPACK_STUB("cgegv");
    LAPACK_IMPL(cgegv)(JOBVL,
                       JOBVR,
                       N,
                       A,
                       LDA,
                       B,
                       LDB,
                       ALPHA,
                       BETA,
                       VL,
                       LDVL,
                       VR,
                       LDVR,
                       WORK,
                       LWORK,
                       RWORK,
                       INFO);
}

//-- cgehd2 --------------------------------------------------------------------
void
LAPACK_DECL(cgehd2)(const INTEGER    *N,
                    const INTEGER    *ILO,
                    const INTEGER    *IHI,
                    FLOAT_COMPLEX    *A,
                    const INTEGER    *LDA,
                    FLOAT_COMPLEX    *TAU,
                    FLOAT_COMPLEX    *WORK,
                    INTEGER          *INFO)
{
    DEBUG_LAPACK_STUB("cgehd2");
    LAPACK_IMPL(cgehd2)(N,
                        ILO,
                        IHI,
                        A,
                        LDA,
                        TAU,
                        WORK,
                        INFO);
}

//-- cgehrd --------------------------------------------------------------------
void
LAPACK_DECL(cgehrd)(const INTEGER    *N,
                    const INTEGER    *ILO,
                    const INTEGER    *IHI,
                    FLOAT_COMPLEX    *A,
                    const INTEGER    *LDA,
                    FLOAT_COMPLEX    *TAU,
                    FLOAT_COMPLEX    *WORK,
                    const INTEGER    *LWORK,
                    INTEGER          *INFO)
{
    DEBUG_LAPACK_STUB("cgehrd");
    LAPACK_IMPL(cgehrd)(N,
                        ILO,
                        IHI,
                        A,
                        LDA,
                        TAU,
                        WORK,
                        LWORK,
                        INFO);
}

//-- cgelq2 --------------------------------------------------------------------
void
LAPACK_DECL(cgelq2)(const INTEGER    *M,
                    const INTEGER    *N,
                    FLOAT_COMPLEX    *A,
                    const INTEGER    *LDA,
                    FLOAT_COMPLEX    *TAU,
                    FLOAT_COMPLEX    *WORK,
                    INTEGER          *INFO)
{
    DEBUG_LAPACK_STUB("cgelq2");
    LAPACK_IMPL(cgelq2)(M,
                        N,
                        A,
                        LDA,
                        TAU,
                        WORK,
                        INFO);
}

//-- cgelqf --------------------------------------------------------------------
void
LAPACK_DECL(cgelqf)(const INTEGER    *M,
                    const INTEGER    *N,
                    FLOAT_COMPLEX    *A,
                    const INTEGER    *LDA,
                    FLOAT_COMPLEX    *TAU,
                    FLOAT_COMPLEX    *WORK,
                    const INTEGER    *LWORK,
                    INTEGER          *INFO)
{
    DEBUG_LAPACK_STUB("cgelqf");
    LAPACK_IMPL(cgelqf)(M,
                        N,
                        A,
                        LDA,
                        TAU,
                        WORK,
                        LWORK,
                        INFO);
}

//-- cgels ---------------------------------------------------------------------
void
LAPACK_DECL(cgels)(const char           *TRANS,
                   const INTEGER        *M,
                   const INTEGER        *N,
                   const INTEGER        *NRHS,
                   FLOAT_COMPLEX        *A,
                   const INTEGER        *LDA,
                   FLOAT_COMPLEX        *B,
                   const INTEGER        *LDB,
                   FLOAT_COMPLEX        *WORK,
                   const INTEGER        *LWORK,
                   INTEGER              *INFO)
{
    DEBUG_LAPACK_STUB("cgels");
    LAPACK_IMPL(cgels)(TRANS,
                       M,
                       N,
                       NRHS,
                       A,
                       LDA,
                       B,
                       LDB,
                       WORK,
                       LWORK,
                       INFO);
}

//-- cgelsd --------------------------------------------------------------------
void
LAPACK_DECL(cgelsd)(const INTEGER    *M,
                    const INTEGER    *N,
                    const INTEGER    *NRHS,
                    FLOAT_COMPLEX    *A,
                    const INTEGER    *LDA,
                    FLOAT_COMPLEX    *B,
                    const INTEGER    *LDB,
                    FLOAT            *S,
                    const FLOAT      *RCOND,
                    INTEGER          *RANK,
                    FLOAT_COMPLEX    *WORK,
                    const INTEGER    *LWORK,
                    FLOAT            *RWORK,
                    INTEGER          *IWORK,
                    INTEGER          *INFO)
{
    DEBUG_LAPACK_STUB("cgelsd");
    LAPACK_IMPL(cgelsd)(M,
                        N,
                        NRHS,
                        A,
                        LDA,
                        B,
                        LDB,
                        S,
                        RCOND,
                        RANK,
                        WORK,
                        LWORK,
                        RWORK,
                        IWORK,
                        INFO);
}

//-- cgelss --------------------------------------------------------------------
void
LAPACK_DECL(cgelss)(const INTEGER    *M,
                    const INTEGER    *N,
                    const INTEGER    *NRHS,
                    FLOAT_COMPLEX    *A,
                    const INTEGER    *LDA,
                    FLOAT_COMPLEX    *B,
                    const INTEGER    *LDB,
                    FLOAT            *S,
                    const FLOAT      *RCOND,
                    INTEGER          *RANK,
                    FLOAT_COMPLEX    *WORK,
                    const INTEGER    *LWORK,
                    FLOAT            *RWORK,
                    INTEGER          *INFO)
{
    DEBUG_LAPACK_STUB("cgelss");
    LAPACK_IMPL(cgelss)(M,
                        N,
                        NRHS,
                        A,
                        LDA,
                        B,
                        LDB,
                        S,
                        RCOND,
                        RANK,
                        WORK,
                        LWORK,
                        RWORK,
                        INFO);
}

//-- cgelsx --------------------------------------------------------------------
void
LAPACK_DECL(cgelsx)(const INTEGER    *M,
                    const INTEGER    *N,
                    const INTEGER    *NRHS,
                    FLOAT_COMPLEX    *A,
                    const INTEGER    *LDA,
                    FLOAT_COMPLEX    *B,
                    const INTEGER    *LDB,
                    INTEGER          *JPVT,
                    const FLOAT      *RCOND,
                    INTEGER          *RANK,
                    FLOAT_COMPLEX    *WORK,
                    FLOAT            *RWORK,
                    INTEGER          *INFO)
{
    DEBUG_LAPACK_STUB("cgelsx");
    LAPACK_IMPL(cgelsx)(M,
                        N,
                        NRHS,
                        A,
                        LDA,
                        B,
                        LDB,
                        JPVT,
                        RCOND,
                        RANK,
                        WORK,
                        RWORK,
                        INFO);
}

//-- cgelsy --------------------------------------------------------------------
void
LAPACK_DECL(cgelsy)(const INTEGER    *M,
                    const INTEGER    *N,
                    const INTEGER    *NRHS,
                    FLOAT_COMPLEX    *A,
                    const INTEGER    *LDA,
                    FLOAT_COMPLEX    *B,
                    const INTEGER    *LDB,
                    INTEGER          *JPVT,
                    const FLOAT      *RCOND,
                    INTEGER          *RANK,
                    FLOAT_COMPLEX    *WORK,
                    const INTEGER    *LWORK,
                    FLOAT            *RWORK,
                    INTEGER          *INFO)
{
    DEBUG_LAPACK_STUB("cgelsy");
    LAPACK_IMPL(cgelsy)(M,
                        N,
                        NRHS,
                        A,
                        LDA,
                        B,
                        LDB,
                        JPVT,
                        RCOND,
                        RANK,
                        WORK,
                        LWORK,
                        RWORK,
                        INFO);
}

//-- cgeql2 --------------------------------------------------------------------
void
LAPACK_DECL(cgeql2)(const INTEGER    *M,
                    const INTEGER    *N,
                    FLOAT_COMPLEX    *A,
                    const INTEGER    *LDA,
                    FLOAT_COMPLEX    *TAU,
                    FLOAT_COMPLEX    *WORK,
                    INTEGER          *INFO)
{
    DEBUG_LAPACK_STUB("cgeql2");
    LAPACK_IMPL(cgeql2)(M,
                        N,
                        A,
                        LDA,
                        TAU,
                        WORK,
                        INFO);
}

//-- cgeqlf --------------------------------------------------------------------
void
LAPACK_DECL(cgeqlf)(const INTEGER    *M,
                    const INTEGER    *N,
                    FLOAT_COMPLEX    *A,
                    const INTEGER    *LDA,
                    FLOAT_COMPLEX    *TAU,
                    FLOAT_COMPLEX    *WORK,
                    const INTEGER    *LWORK,
                    INTEGER          *INFO)
{
    DEBUG_LAPACK_STUB("cgeqlf");
    LAPACK_IMPL(cgeqlf)(M,
                        N,
                        A,
                        LDA,
                        TAU,
                        WORK,
                        LWORK,
                        INFO);
}

//-- cgeqp3 --------------------------------------------------------------------
void
LAPACK_DECL(cgeqp3)(const INTEGER    *M,
                    const INTEGER    *N,
                    FLOAT_COMPLEX    *A,
                    const INTEGER    *LDA,
                    INTEGER          *JPVT,
                    FLOAT_COMPLEX    *TAU,
                    FLOAT_COMPLEX    *WORK,
                    const INTEGER    *LWORK,
                    FLOAT            *RWORK,
                    INTEGER          *INFO)
{
    DEBUG_LAPACK_STUB("cgeqp3");
    LAPACK_IMPL(cgeqp3)(M,
                        N,
                        A,
                        LDA,
                        JPVT,
                        TAU,
                        WORK,
                        LWORK,
                        RWORK,
                        INFO);
}

//-- cgeqpf --------------------------------------------------------------------
void
LAPACK_DECL(cgeqpf)(const INTEGER    *M,
                    const INTEGER    *N,
                    FLOAT_COMPLEX    *A,
                    const INTEGER    *LDA,
                    INTEGER          *JPVT,
                    FLOAT_COMPLEX    *TAU,
                    FLOAT_COMPLEX    *WORK,
                    FLOAT            *RWORK,
                    INTEGER          *INFO)
{
    DEBUG_LAPACK_STUB("cgeqpf");
    LAPACK_IMPL(cgeqpf)(M,
                        N,
                        A,
                        LDA,
                        JPVT,
                        TAU,
                        WORK,
                        RWORK,
                        INFO);
}

//-- cgeqr2 --------------------------------------------------------------------
void
LAPACK_DECL(cgeqr2)(const INTEGER    *M,
                    const INTEGER    *N,
                    FLOAT_COMPLEX    *A,
                    const INTEGER    *LDA,
                    FLOAT_COMPLEX    *TAU,
                    FLOAT_COMPLEX    *WORK,
                    INTEGER          *INFO)
{
    DEBUG_LAPACK_STUB("cgeqr2");
    LAPACK_IMPL(cgeqr2)(M,
                        N,
                        A,
                        LDA,
                        TAU,
                        WORK,
                        INFO);
}

//-- cgeqr2p -------------------------------------------------------------------
void
LAPACK_DECL(cgeqr2p)(const INTEGER    *M,
                     const INTEGER    *N,
                     FLOAT_COMPLEX    *A,
                     const INTEGER    *LDA,
                     FLOAT_COMPLEX    *TAU,
                     FLOAT_COMPLEX    *WORK,
                     INTEGER          *INFO)
{
    DEBUG_LAPACK_STUB("cgeqr2p");
    LAPACK_IMPL(cgeqr2p)(M,
                         N,
                         A,
                         LDA,
                         TAU,
                         WORK,
                         INFO);
}

//-- cgeqrf --------------------------------------------------------------------
void
LAPACK_DECL(cgeqrf)(const INTEGER    *M,
                    const INTEGER    *N,
                    FLOAT_COMPLEX    *A,
                    const INTEGER    *LDA,
                    FLOAT_COMPLEX    *TAU,
                    FLOAT_COMPLEX    *WORK,
                    const INTEGER    *LWORK,
                    INTEGER          *INFO)
{
    DEBUG_LAPACK_STUB("cgeqrf");
    LAPACK_IMPL(cgeqrf)(M,
                        N,
                        A,
                        LDA,
                        TAU,
                        WORK,
                        LWORK,
                        INFO);
}

//-- cgeqrfp -------------------------------------------------------------------
void
LAPACK_DECL(cgeqrfp)(const INTEGER    *M,
                     const INTEGER    *N,
                     FLOAT_COMPLEX    *A,
                     const INTEGER    *LDA,
                     FLOAT_COMPLEX    *TAU,
                     FLOAT_COMPLEX    *WORK,
                     const INTEGER    *LWORK,
                     INTEGER          *INFO)
{
    DEBUG_LAPACK_STUB("cgeqrfp");
    LAPACK_IMPL(cgeqrfp)(M,
                         N,
                         A,
                         LDA,
                         TAU,
                         WORK,
                         LWORK,
                         INFO);
}

//-- cgerfs --------------------------------------------------------------------
void
LAPACK_DECL(cgerfs)(const char           *TRANS,
                    const INTEGER        *N,
                    const INTEGER        *NRHS,
                    const FLOAT_COMPLEX  *A,
                    const INTEGER        *LDA,
                    const FLOAT_COMPLEX  *AF,
                    const INTEGER        *LDAF,
                    const INTEGER        *IPIV,
                    const FLOAT_COMPLEX  *B,
                    const INTEGER        *LDB,
                    FLOAT_COMPLEX        *X,
                    const INTEGER        *LDX,
                    FLOAT                *FERR,
                    FLOAT                *BERR,
                    FLOAT_COMPLEX        *WORK,
                    FLOAT                *RWORK,
                    INTEGER              *INFO)
{
    DEBUG_LAPACK_STUB("cgerfs");
    LAPACK_IMPL(cgerfs)(TRANS,
                        N,
                        NRHS,
                        A,
                        LDA,
                        AF,
                        LDAF,
                        IPIV,
                        B,
                        LDB,
                        X,
                        LDX,
                        FERR,
                        BERR,
                        WORK,
                        RWORK,
                        INFO);
}

//-- cgerfsx -------------------------------------------------------------------
void
LAPACK_DECL(cgerfsx)(const char               *TRANS,
                     const char               *EQUED,
                     const INTEGER            *N,
                     const INTEGER            *NRHS,
                     const FLOAT_COMPLEX      *A,
                     const INTEGER            *LDA,
                     const FLOAT_COMPLEX      *AF,
                     const INTEGER            *LDAF,
                     const INTEGER            *IPIV,
                     const FLOAT              *R,
                     const FLOAT              *C,
                     const FLOAT_COMPLEX      *B,
                     const INTEGER            *LDB,
                     FLOAT_COMPLEX            *X,
                     const INTEGER            *LDX,
                     FLOAT                    *RCOND,
                     FLOAT                    *BERR,
                     const INTEGER            *N_ERR_BNDS,
                     FLOAT                    *ERR_BNDS_NORM,
                     FLOAT                    *ERR_BNDS_COMP,
                     const INTEGER            *NPARAMS,
                     FLOAT                    *PARAMS,
                     FLOAT_COMPLEX            *WORK,
                     FLOAT                    *RWORK,
                     INTEGER                  *INFO)
{
    DEBUG_LAPACK_STUB("cgerfsx");
    LAPACK_IMPL(cgerfsx)(TRANS,
                         EQUED,
                         N,
                         NRHS,
                         A,
                         LDA,
                         AF,
                         LDAF,
                         IPIV,
                         R,
                         C,
                         B,
                         LDB,
                         X,
                         LDX,
                         RCOND,
                         BERR,
                         N_ERR_BNDS,
                         ERR_BNDS_NORM,
                         ERR_BNDS_COMP,
                         NPARAMS,
                         PARAMS,
                         WORK,
                         RWORK,
                         INFO);
}

//-- cgerq2 --------------------------------------------------------------------
void
LAPACK_DECL(cgerq2)(const INTEGER    *M,
                    const INTEGER    *N,
                    FLOAT_COMPLEX    *A,
                    const INTEGER    *LDA,
                    FLOAT_COMPLEX    *TAU,
                    FLOAT_COMPLEX    *WORK,
                    INTEGER          *INFO)
{
    DEBUG_LAPACK_STUB("cgerq2");
    LAPACK_IMPL(cgerq2)(M,
                        N,
                        A,
                        LDA,
                        TAU,
                        WORK,
                        INFO);
}

//-- cgerqf --------------------------------------------------------------------
void
LAPACK_DECL(cgerqf)(const INTEGER    *M,
                    const INTEGER    *N,
                    FLOAT_COMPLEX    *A,
                    const INTEGER    *LDA,
                    FLOAT_COMPLEX    *TAU,
                    FLOAT_COMPLEX    *WORK,
                    const INTEGER    *LWORK,
                    INTEGER          *INFO)
{
    DEBUG_LAPACK_STUB("cgerqf");
    LAPACK_IMPL(cgerqf)(M,
                        N,
                        A,
                        LDA,
                        TAU,
                        WORK,
                        LWORK,
                        INFO);
}

//-- cgesc2 --------------------------------------------------------------------
void
LAPACK_DECL(cgesc2)(const INTEGER        *N,
                    const FLOAT_COMPLEX  *A,
                    const INTEGER        *LDA,
                    FLOAT_COMPLEX        *RHS,
                    const INTEGER        *IPIV,
                    const INTEGER        *JPIV,
                    FLOAT                *SCALE)
{
    DEBUG_LAPACK_STUB("cgesc2");
    LAPACK_IMPL(cgesc2)(N,
                        A,
                        LDA,
                        RHS,
                        IPIV,
                        JPIV,
                        SCALE);
}

//-- cgesdd --------------------------------------------------------------------
void
LAPACK_DECL(cgesdd)(const char       *JOBZ,
                    const INTEGER    *M,
                    const INTEGER    *N,
                    FLOAT_COMPLEX    *A,
                    const INTEGER    *LDA,
                    FLOAT            *S,
                    FLOAT_COMPLEX    *U,
                    const INTEGER    *LDU,
                    FLOAT_COMPLEX    *VT,
                    const INTEGER    *LDVT,
                    FLOAT_COMPLEX    *WORK,
                    const INTEGER    *LWORK,
                    FLOAT            *RWORK,
                    INTEGER          *IWORK,
                    INTEGER          *INFO)
{
    DEBUG_LAPACK_STUB("cgesdd");
    LAPACK_IMPL(cgesdd)(JOBZ,
                        M,
                        N,
                        A,
                        LDA,
                        S,
                        U,
                        LDU,
                        VT,
                        LDVT,
                        WORK,
                        LWORK,
                        RWORK,
                        IWORK,
                        INFO);
}

//-- cgesv ---------------------------------------------------------------------
void
LAPACK_DECL(cgesv)(const INTEGER        *N,
                   const INTEGER        *NRHS,
                   FLOAT_COMPLEX        *A,
                   const INTEGER        *LDA,
                   INTEGER              *IPIV,
                   FLOAT_COMPLEX        *B,
                   const INTEGER        *LDB,
                   INTEGER              *INFO)
{
    DEBUG_LAPACK_STUB("cgesv");
    LAPACK_IMPL(cgesv)(N,
                       NRHS,
                       A,
                       LDA,
                       IPIV,
                       B,
                       LDB,
                       INFO);
}

//-- cgesvd --------------------------------------------------------------------
void
LAPACK_DECL(cgesvd)(const char       *JOBU,
                    const char       *JOBVT,
                    const INTEGER    *M,
                    const INTEGER    *N,
                    FLOAT_COMPLEX    *A,
                    const INTEGER    *LDA,
                    FLOAT            *S,
                    FLOAT_COMPLEX    *U,
                    const INTEGER    *LDU,
                    FLOAT_COMPLEX    *VT,
                    const INTEGER    *LDVT,
                    FLOAT_COMPLEX    *WORK,
                    const INTEGER    *LWORK,
                    FLOAT            *RWORK,
                    INTEGER          *INFO)
{
    DEBUG_LAPACK_STUB("cgesvd");
    LAPACK_IMPL(cgesvd)(JOBU,
                        JOBVT,
                        M,
                        N,
                        A,
                        LDA,
                        S,
                        U,
                        LDU,
                        VT,
                        LDVT,
                        WORK,
                        LWORK,
                        RWORK,
                        INFO);
}

//-- cgesvx --------------------------------------------------------------------
void
LAPACK_DECL(cgesvx)(const char       *FACT,
                    const char       *TRANS,
                    const INTEGER    *N,
                    const INTEGER    *NRHS,
                    FLOAT_COMPLEX    *A,
                    const INTEGER    *LDA,
                    FLOAT_COMPLEX    *AF,
                    const INTEGER    *LDAF,
                    INTEGER          *IPIV,
                    char             *EQUED,
                    FLOAT            *R,
                    FLOAT            *C,
                    FLOAT_COMPLEX    *B,
                    const INTEGER    *LDB,
                    FLOAT_COMPLEX    *X,
                    const INTEGER    *LDX,
                    FLOAT            *RCOND,
                    FLOAT            *FERR,
                    FLOAT            *BERR,
                    FLOAT_COMPLEX    *WORK,
                    FLOAT            *RWORK,
                    INTEGER          *INFO)
{
    DEBUG_LAPACK_STUB("cgesvx");
    LAPACK_IMPL(cgesvx)(FACT,
                        TRANS,
                        N,
                        NRHS,
                        A,
                        LDA,
                        AF,
                        LDAF,
                        IPIV,
                        EQUED,
                        R,
                        C,
                        B,
                        LDB,
                        X,
                        LDX,
                        RCOND,
                        FERR,
                        BERR,
                        WORK,
                        RWORK,
                        INFO);
}

//-- cgesvxx -------------------------------------------------------------------
void
LAPACK_DECL(cgesvxx)(const char       *FACT,
                     const char       *TRANS,
                     const INTEGER    *N,
                     const INTEGER    *NRHS,
                     FLOAT_COMPLEX    *A,
                     const INTEGER    *LDA,
                     FLOAT_COMPLEX    *AF,
                     const INTEGER    *LDAF,
                     INTEGER          *IPIV,
                     char             *EQUED,
                     FLOAT            *R,
                     FLOAT            *C,
                     FLOAT_COMPLEX    *B,
                     const INTEGER    *LDB,
                     FLOAT_COMPLEX    *X,
                     const INTEGER    *LDX,
                     FLOAT            *RCOND,
                     FLOAT            *RPVGRW,
                     FLOAT            *BERR,
                     const INTEGER    *N_ERR_BNDS,
                     FLOAT            *ERR_BNDS_NORM,
                     FLOAT            *ERR_BNDS_COMP,
                     const INTEGER    *NPARAMS,
                     FLOAT            *PARAMS,
                     FLOAT_COMPLEX    *WORK,
                     FLOAT            *RWORK,
                     INTEGER          *INFO)
{
    DEBUG_LAPACK_STUB("cgesvxx");
    LAPACK_IMPL(cgesvxx)(FACT,
                         TRANS,
                         N,
                         NRHS,
                         A,
                         LDA,
                         AF,
                         LDAF,
                         IPIV,
                         EQUED,
                         R,
                         C,
                         B,
                         LDB,
                         X,
                         LDX,
                         RCOND,
                         RPVGRW,
                         BERR,
                         N_ERR_BNDS,
                         ERR_BNDS_NORM,
                         ERR_BNDS_COMP,
                         NPARAMS,
                         PARAMS,
                         WORK,
                         RWORK,
                         INFO);
}

//-- cgetc2 --------------------------------------------------------------------
void
LAPACK_DECL(cgetc2)(const INTEGER    *N,
                    FLOAT_COMPLEX    *A,
                    const INTEGER    *LDA,
                    INTEGER          *IPIV,
                    INTEGER          *JPIV,
                    INTEGER          *INFO)
{
    DEBUG_LAPACK_STUB("cgetc2");
    LAPACK_IMPL(cgetc2)(N,
                        A,
                        LDA,
                        IPIV,
                        JPIV,
                        INFO);
}

//-- cgetf2 --------------------------------------------------------------------
void
LAPACK_DECL(cgetf2)(const INTEGER    *M,
                    const INTEGER    *N,
                    FLOAT_COMPLEX    *A,
                    const INTEGER    *LDA,
                    INTEGER          *IPIV,
                    INTEGER          *INFO)
{
    DEBUG_LAPACK_STUB("cgetf2");
    LAPACK_IMPL(cgetf2)(M,
                        N,
                        A,
                        LDA,
                        IPIV,
                        INFO);
}

//-- cgetrf --------------------------------------------------------------------
void
LAPACK_DECL(cgetrf)(const INTEGER    *M,
                    const INTEGER    *N,
                    FLOAT_COMPLEX    *A,
                    const INTEGER    *LDA,
                    INTEGER          *IPIV,
                    INTEGER          *INFO)
{
    DEBUG_LAPACK_STUB("cgetrf");
    LAPACK_IMPL(cgetrf)(M,
                        N,
                        A,
                        LDA,
                        IPIV,
                        INFO);
}

//-- cgetri --------------------------------------------------------------------
void
LAPACK_DECL(cgetri)(const INTEGER    *N,
                    FLOAT_COMPLEX    *A,
                    const INTEGER    *LDA,
                    const INTEGER    *IPIV,
                    FLOAT_COMPLEX    *WORK,
                    const INTEGER    *LWORK,
                    INTEGER          *INFO)
{
    DEBUG_LAPACK_STUB("cgetri");
    LAPACK_IMPL(cgetri)(N,
                        A,
                        LDA,
                        IPIV,
                        WORK,
                        LWORK,
                        INFO);
}

//-- cgetrs --------------------------------------------------------------------
void
LAPACK_DECL(cgetrs)(const char           *TRANS,
                    const INTEGER        *N,
                    const INTEGER        *NRHS,
                    const FLOAT_COMPLEX  *A,
                    const INTEGER        *LDA,
                    const INTEGER        *IPIV,
                    FLOAT_COMPLEX        *B,
                    const INTEGER        *LDB,
                    INTEGER              *INFO)
{
    DEBUG_LAPACK_STUB("cgetrs");
    LAPACK_IMPL(cgetrs)(TRANS,
                        N,
                        NRHS,
                        A,
                        LDA,
                        IPIV,
                        B,
                        LDB,
                        INFO);
}

//-- cggbak --------------------------------------------------------------------
void
LAPACK_DECL(cggbak)(const char       *JOB,
                    const char       *SIDE,
                    const INTEGER    *N,
                    const INTEGER    *ILO,
                    const INTEGER    *IHI,
                    const FLOAT      *LSCALE,
                    const FLOAT      *RSCALE,
                    const INTEGER    *M,
                    FLOAT_COMPLEX    *V,
                    const INTEGER    *LDV,
                    INTEGER          *INFO)
{
    DEBUG_LAPACK_STUB("cggbak");
    LAPACK_IMPL(cggbak)(JOB,
                        SIDE,
                        N,
                        ILO,
                        IHI,
                        LSCALE,
                        RSCALE,
                        M,
                        V,
                        LDV,
                        INFO);
}

//-- cggbal --------------------------------------------------------------------
void
LAPACK_DECL(cggbal)(const char       *JOB,
                    const INTEGER    *N,
                    FLOAT_COMPLEX    *A,
                    const INTEGER    *LDA,
                    FLOAT_COMPLEX    *B,
                    const INTEGER    *LDB,
                    INTEGER          *ILO,
                    INTEGER          *IHI,
                    FLOAT            *LSCALE,
                    FLOAT            *RSCALE,
                    FLOAT            *WORK,
                    INTEGER          *INFO)
{
    DEBUG_LAPACK_STUB("cggbal");
    LAPACK_IMPL(cggbal)(JOB,
                        N,
                        A,
                        LDA,
                        B,
                        LDB,
                        ILO,
                        IHI,
                        LSCALE,
                        RSCALE,
                        WORK,
                        INFO);
}

//-- cgges ---------------------------------------------------------------------
void
LAPACK_DECL(cgges)(const char           *JOBVSL,
                   const char           *JOBVSR,
                   const char           *SORT,
                   const LOGICAL        *SELCTG,
                   const INTEGER        *N,
                   FLOAT_COMPLEX        *A,
                   const INTEGER        *LDA,
                   FLOAT_COMPLEX        *B,
                   const INTEGER        *LDB,
                   INTEGER              *SDIM,
                   FLOAT_COMPLEX        *ALPHA,
                   FLOAT_COMPLEX        *BETA,
                   FLOAT_COMPLEX        *VSL,
                   const INTEGER        *LDVSL,
                   FLOAT_COMPLEX        *VSR,
                   const INTEGER        *LDVSR,
                   FLOAT_COMPLEX        *WORK,
                   const INTEGER        *LWORK,
                   FLOAT                *RWORK,
                   LOGICAL              *BWORK,
                   INTEGER              *INFO)
{
    DEBUG_LAPACK_STUB("cgges");
    LAPACK_IMPL(cgges)(JOBVSL,
                       JOBVSR,
                       SORT,
                       SELCTG,
                       N,
                       A,
                       LDA,
                       B,
                       LDB,
                       SDIM,
                       ALPHA,
                       BETA,
                       VSL,
                       LDVSL,
                       VSR,
                       LDVSR,
                       WORK,
                       LWORK,
                       RWORK,
                       BWORK,
                       INFO);
}

//-- cggesx --------------------------------------------------------------------
void
LAPACK_DECL(cggesx)(const char       *JOBVSL,
                    const char       *JOBVSR,
                    const char       *SORT,
                    const LOGICAL    *SELCTG,
                    const char       *SENSE,
                    const INTEGER    *N,
                    FLOAT_COMPLEX    *A,
                    const INTEGER    *LDA,
                    FLOAT_COMPLEX    *B,
                    const INTEGER    *LDB,
                    INTEGER          *SDIM,
                    FLOAT_COMPLEX    *ALPHA,
                    FLOAT_COMPLEX    *BETA,
                    FLOAT_COMPLEX    *VSL,
                    const INTEGER    *LDVSL,
                    FLOAT_COMPLEX    *VSR,
                    const INTEGER    *LDVSR,
                    FLOAT            *RCONDE,
                    FLOAT            *RCONDV,
                    FLOAT_COMPLEX    *WORK,
                    const INTEGER    *LWORK,
                    FLOAT            *RWORK,
                    INTEGER          *IWORK,
                    const INTEGER    *LIWORK,
                    LOGICAL          *BWORK,
                    INTEGER          *INFO)
{
    DEBUG_LAPACK_STUB("cggesx");
    LAPACK_IMPL(cggesx)(JOBVSL,
                        JOBVSR,
                        SORT,
                        SELCTG,
                        SENSE,
                        N,
                        A,
                        LDA,
                        B,
                        LDB,
                        SDIM,
                        ALPHA,
                        BETA,
                        VSL,
                        LDVSL,
                        VSR,
                        LDVSR,
                        RCONDE,
                        RCONDV,
                        WORK,
                        LWORK,
                        RWORK,
                        IWORK,
                        LIWORK,
                        BWORK,
                        INFO);
}

//-- cggev ---------------------------------------------------------------------
void
LAPACK_DECL(cggev)(const char           *JOBVL,
                   const char           *JOBVR,
                   const INTEGER        *N,
                   FLOAT_COMPLEX        *A,
                   const INTEGER        *LDA,
                   FLOAT_COMPLEX        *B,
                   const INTEGER        *LDB,
                   FLOAT_COMPLEX        *ALPHA,
                   FLOAT_COMPLEX        *BETA,
                   FLOAT_COMPLEX        *VL,
                   const INTEGER        *LDVL,
                   FLOAT_COMPLEX        *VR,
                   const INTEGER        *LDVR,
                   FLOAT_COMPLEX        *WORK,
                   const INTEGER        *LWORK,
                   FLOAT                *RWORK,
                   INTEGER              *INFO)
{
    DEBUG_LAPACK_STUB("cggev");
    LAPACK_IMPL(cggev)(JOBVL,
                       JOBVR,
                       N,
                       A,
                       LDA,
                       B,
                       LDB,
                       ALPHA,
                       BETA,
                       VL,
                       LDVL,
                       VR,
                       LDVR,
                       WORK,
                       LWORK,
                       RWORK,
                       INFO);
}

//-- cggevx --------------------------------------------------------------------
void
LAPACK_DECL(cggevx)(const char       *BALANC,
                    const char       *JOBVL,
                    const char       *JOBVR,
                    const char       *SENSE,
                    const INTEGER    *N,
                    FLOAT_COMPLEX    *A,
                    const INTEGER    *LDA,
                    FLOAT_COMPLEX    *B,
                    const INTEGER    *LDB,
                    FLOAT_COMPLEX    *ALPHA,
                    FLOAT_COMPLEX    *BETA,
                    FLOAT_COMPLEX    *VL,
                    const INTEGER    *LDVL,
                    FLOAT_COMPLEX    *VR,
                    const INTEGER    *LDVR,
                    INTEGER          *ILO,
                    INTEGER          *IHI,
                    FLOAT            *LSCALE,
                    FLOAT            *RSCALE,
                    FLOAT            *ABNRM,
                    FLOAT            *BBNRM,
                    FLOAT            *RCONDE,
                    FLOAT            *RCONDV,
                    FLOAT_COMPLEX    *WORK,
                    const INTEGER    *LWORK,
                    FLOAT            *RWORK,
                    INTEGER          *IWORK,
                    LOGICAL          *BWORK,
                    INTEGER          *INFO)
{
    DEBUG_LAPACK_STUB("cggevx");
    LAPACK_IMPL(cggevx)(BALANC,
                        JOBVL,
                        JOBVR,
                        SENSE,
                        N,
                        A,
                        LDA,
                        B,
                        LDB,
                        ALPHA,
                        BETA,
                        VL,
                        LDVL,
                        VR,
                        LDVR,
                        ILO,
                        IHI,
                        LSCALE,
                        RSCALE,
                        ABNRM,
                        BBNRM,
                        RCONDE,
                        RCONDV,
                        WORK,
                        LWORK,
                        RWORK,
                        IWORK,
                        BWORK,
                        INFO);
}

//-- cggglm --------------------------------------------------------------------
void
LAPACK_DECL(cggglm)(const INTEGER    *N,
                    const INTEGER    *M,
                    const INTEGER    *P,
                    FLOAT_COMPLEX    *A,
                    const INTEGER    *LDA,
                    FLOAT_COMPLEX    *B,
                    const INTEGER    *LDB,
                    FLOAT_COMPLEX    *D,
                    FLOAT_COMPLEX    *X,
                    FLOAT_COMPLEX    *Y,
                    FLOAT_COMPLEX    *WORK,
                    const INTEGER    *LWORK,
                    INTEGER          *INFO)
{
    DEBUG_LAPACK_STUB("cggglm");
    LAPACK_IMPL(cggglm)(N,
                        M,
                        P,
                        A,
                        LDA,
                        B,
                        LDB,
                        D,
                        X,
                        Y,
                        WORK,
                        LWORK,
                        INFO);
}

//-- cgghrd --------------------------------------------------------------------
void
LAPACK_DECL(cgghrd)(const char       *COMPQ,
                    const char       *COMPZ,
                    const INTEGER    *N,
                    const INTEGER    *ILO,
                    const INTEGER    *IHI,
                    FLOAT_COMPLEX    *A,
                    const INTEGER    *LDA,
                    FLOAT_COMPLEX    *B,
                    const INTEGER    *LDB,
                    FLOAT_COMPLEX    *Q,
                    const INTEGER    *LDQ,
                    FLOAT_COMPLEX    *Z,
                    const INTEGER    *LDZ,
                    INTEGER          *INFO)
{
    DEBUG_LAPACK_STUB("cgghrd");
    LAPACK_IMPL(cgghrd)(COMPQ,
                        COMPZ,
                        N,
                        ILO,
                        IHI,
                        A,
                        LDA,
                        B,
                        LDB,
                        Q,
                        LDQ,
                        Z,
                        LDZ,
                        INFO);
}

//-- cgglse --------------------------------------------------------------------
void
LAPACK_DECL(cgglse)(const INTEGER    *M,
                    const INTEGER    *N,
                    const INTEGER    *P,
                    FLOAT_COMPLEX    *A,
                    const INTEGER    *LDA,
                    FLOAT_COMPLEX    *B,
                    const INTEGER    *LDB,
                    FLOAT_COMPLEX    *C,
                    FLOAT_COMPLEX    *D,
                    FLOAT_COMPLEX    *X,
                    FLOAT_COMPLEX    *WORK,
                    const INTEGER    *LWORK,
                    INTEGER          *INFO)
{
    DEBUG_LAPACK_STUB("cgglse");
    LAPACK_IMPL(cgglse)(M,
                        N,
                        P,
                        A,
                        LDA,
                        B,
                        LDB,
                        C,
                        D,
                        X,
                        WORK,
                        LWORK,
                        INFO);
}

//-- cggqrf --------------------------------------------------------------------
void
LAPACK_DECL(cggqrf)(const INTEGER    *N,
                    const INTEGER    *M,
                    const INTEGER    *P,
                    FLOAT_COMPLEX    *A,
                    const INTEGER    *LDA,
                    FLOAT_COMPLEX    *TAUA,
                    FLOAT_COMPLEX    *B,
                    const INTEGER    *LDB,
                    FLOAT_COMPLEX    *TAUB,
                    FLOAT_COMPLEX    *WORK,
                    const INTEGER    *LWORK,
                    INTEGER          *INFO)
{
    DEBUG_LAPACK_STUB("cggqrf");
    LAPACK_IMPL(cggqrf)(N,
                        M,
                        P,
                        A,
                        LDA,
                        TAUA,
                        B,
                        LDB,
                        TAUB,
                        WORK,
                        LWORK,
                        INFO);
}

//-- cggrqf --------------------------------------------------------------------
void
LAPACK_DECL(cggrqf)(const INTEGER    *M,
                    const INTEGER    *P,
                    const INTEGER    *N,
                    FLOAT_COMPLEX    *A,
                    const INTEGER    *LDA,
                    FLOAT_COMPLEX    *TAUA,
                    FLOAT_COMPLEX    *B,
                    const INTEGER    *LDB,
                    FLOAT_COMPLEX    *TAUB,
                    FLOAT_COMPLEX    *WORK,
                    const INTEGER    *LWORK,
                    INTEGER          *INFO)
{
    DEBUG_LAPACK_STUB("cggrqf");
    LAPACK_IMPL(cggrqf)(M,
                        P,
                        N,
                        A,
                        LDA,
                        TAUA,
                        B,
                        LDB,
                        TAUB,
                        WORK,
                        LWORK,
                        INFO);
}

//-- cggsvd --------------------------------------------------------------------
void
LAPACK_DECL(cggsvd)(const char       *JOBU,
                    const char       *JOBV,
                    const char       *JOBQ,
                    const INTEGER    *M,
                    const INTEGER    *N,
                    const INTEGER    *P,
                    INTEGER          *K,
                    INTEGER          *L,
                    FLOAT_COMPLEX    *A,
                    const INTEGER    *LDA,
                    FLOAT_COMPLEX    *B,
                    const INTEGER    *LDB,
                    FLOAT            *ALPHA,
                    FLOAT            *BETA,
                    FLOAT_COMPLEX    *U,
                    const INTEGER    *LDU,
                    FLOAT_COMPLEX    *V,
                    const INTEGER    *LDV,
                    FLOAT_COMPLEX    *Q,
                    const INTEGER    *LDQ,
                    FLOAT_COMPLEX    *WORK,
                    FLOAT            *RWORK,
                    INTEGER          *IWORK,
                    INTEGER          *INFO)
{
    DEBUG_LAPACK_STUB("cggsvd");
    LAPACK_IMPL(cggsvd)(JOBU,
                        JOBV,
                        JOBQ,
                        M,
                        N,
                        P,
                        K,
                        L,
                        A,
                        LDA,
                        B,
                        LDB,
                        ALPHA,
                        BETA,
                        U,
                        LDU,
                        V,
                        LDV,
                        Q,
                        LDQ,
                        WORK,
                        RWORK,
                        IWORK,
                        INFO);
}

//-- cggsvp --------------------------------------------------------------------
void
LAPACK_DECL(cggsvp)(const char       *JOBU,
                    const char       *JOBV,
                    const char       *JOBQ,
                    const INTEGER    *M,
                    const INTEGER    *P,
                    const INTEGER    *N,
                    FLOAT_COMPLEX    *A,
                    const INTEGER    *LDA,
                    FLOAT_COMPLEX    *B,
                    const INTEGER    *LDB,
                    const FLOAT      *TOLA,
                    const FLOAT      *TOLB,
                    INTEGER          *K,
                    INTEGER          *L,
                    FLOAT_COMPLEX    *U,
                    const INTEGER    *LDU,
                    FLOAT_COMPLEX    *V,
                    const INTEGER    *LDV,
                    FLOAT_COMPLEX    *Q,
                    const INTEGER    *LDQ,
                    INTEGER          *IWORK,
                    FLOAT            *RWORK,
                    FLOAT_COMPLEX    *TAU,
                    FLOAT_COMPLEX    *WORK,
                    INTEGER          *INFO)
{
    DEBUG_LAPACK_STUB("cggsvp");
    LAPACK_IMPL(cggsvp)(JOBU,
                        JOBV,
                        JOBQ,
                        M,
                        P,
                        N,
                        A,
                        LDA,
                        B,
                        LDB,
                        TOLA,
                        TOLB,
                        K,
                        L,
                        U,
                        LDU,
                        V,
                        LDV,
                        Q,
                        LDQ,
                        IWORK,
                        RWORK,
                        TAU,
                        WORK,
                        INFO);
}

//-- cgtcon --------------------------------------------------------------------
void
LAPACK_DECL(cgtcon)(const char           *NORM,
                    const INTEGER        *N,
                    const FLOAT_COMPLEX  *DL,
                    const FLOAT_COMPLEX  *D,
                    const FLOAT_COMPLEX  *DU,
                    const FLOAT_COMPLEX  *DU2,
                    const INTEGER        *IPIV,
                    const FLOAT          *ANORM,
                    FLOAT                *RCOND,
                    FLOAT_COMPLEX        *WORK,
                    INTEGER              *INFO)
{
    DEBUG_LAPACK_STUB("cgtcon");
    LAPACK_IMPL(cgtcon)(NORM,
                        N,
                        DL,
                        D,
                        DU,
                        DU2,
                        IPIV,
                        ANORM,
                        RCOND,
                        WORK,
                        INFO);
}

//-- cgtrfs --------------------------------------------------------------------
void
LAPACK_DECL(cgtrfs)(const char           *TRANS,
                    const INTEGER        *N,
                    const INTEGER        *NRHS,
                    const FLOAT_COMPLEX  *DL,
                    const FLOAT_COMPLEX  *D,
                    const FLOAT_COMPLEX  *DU,
                    const FLOAT_COMPLEX  *DLF,
                    const FLOAT_COMPLEX  *DF,
                    const FLOAT_COMPLEX  *DUF,
                    const FLOAT_COMPLEX  *DU2,
                    const INTEGER        *IPIV,
                    const FLOAT_COMPLEX  *B,
                    const INTEGER        *LDB,
                    FLOAT_COMPLEX        *X,
                    const INTEGER        *LDX,
                    FLOAT                *FERR,
                    FLOAT                *BERR,
                    FLOAT_COMPLEX        *WORK,
                    FLOAT                *RWORK,
                    INTEGER              *INFO)
{
    DEBUG_LAPACK_STUB("cgtrfs");
    LAPACK_IMPL(cgtrfs)(TRANS,
                        N,
                        NRHS,
                        DL,
                        D,
                        DU,
                        DLF,
                        DF,
                        DUF,
                        DU2,
                        IPIV,
                        B,
                        LDB,
                        X,
                        LDX,
                        FERR,
                        BERR,
                        WORK,
                        RWORK,
                        INFO);
}

//-- cgtsv ---------------------------------------------------------------------
void
LAPACK_DECL(cgtsv)(const INTEGER        *N,
                   const INTEGER        *NRHS,
                   FLOAT_COMPLEX        *DL,
                   FLOAT_COMPLEX        *D,
                   FLOAT_COMPLEX        *DU,
                   FLOAT_COMPLEX        *B,
                   const INTEGER        *LDB,
                   INTEGER              *INFO)
{
    DEBUG_LAPACK_STUB("cgtsv");
    LAPACK_IMPL(cgtsv)(N,
                       NRHS,
                       DL,
                       D,
                       DU,
                       B,
                       LDB,
                       INFO);
}

//-- cgtsvx --------------------------------------------------------------------
void
LAPACK_DECL(cgtsvx)(const char           *FACT,
                    const char           *TRANS,
                    const INTEGER        *N,
                    const INTEGER        *NRHS,
                    const FLOAT_COMPLEX  *DL,
                    const FLOAT_COMPLEX  *D,
                    const FLOAT_COMPLEX  *DU,
                    FLOAT_COMPLEX        *DLF,
                    FLOAT_COMPLEX        *DF,
                    FLOAT_COMPLEX        *DUF,
                    FLOAT_COMPLEX        *DU2,
                    INTEGER              *IPIV,
                    const FLOAT_COMPLEX  *B,
                    const INTEGER        *LDB,
                    FLOAT_COMPLEX        *X,
                    const INTEGER        *LDX,
                    FLOAT                *RCOND,
                    FLOAT                *FERR,
                    FLOAT                *BERR,
                    FLOAT_COMPLEX        *WORK,
                    FLOAT                *RWORK,
                    INTEGER              *INFO)
{
    DEBUG_LAPACK_STUB("cgtsvx");
    LAPACK_IMPL(cgtsvx)(FACT,
                        TRANS,
                        N,
                        NRHS,
                        DL,
                        D,
                        DU,
                        DLF,
                        DF,
                        DUF,
                        DU2,
                        IPIV,
                        B,
                        LDB,
                        X,
                        LDX,
                        RCOND,
                        FERR,
                        BERR,
                        WORK,
                        RWORK,
                        INFO);
}

//-- cgttrf --------------------------------------------------------------------
void
LAPACK_DECL(cgttrf)(const INTEGER    *N,
                    FLOAT_COMPLEX    *DL,
                    FLOAT_COMPLEX    *D,
                    FLOAT_COMPLEX    *DU,
                    FLOAT_COMPLEX    *DU2,
                    INTEGER          *IPIV,
                    INTEGER          *INFO)
{
    DEBUG_LAPACK_STUB("cgttrf");
    LAPACK_IMPL(cgttrf)(N,
                        DL,
                        D,
                        DU,
                        DU2,
                        IPIV,
                        INFO);
}

//-- cgttrs --------------------------------------------------------------------
void
LAPACK_DECL(cgttrs)(const char           *TRANS,
                    const INTEGER        *N,
                    const INTEGER        *NRHS,
                    const FLOAT_COMPLEX  *DL,
                    const FLOAT_COMPLEX  *D,
                    const FLOAT_COMPLEX  *DU,
                    const FLOAT_COMPLEX  *DU2,
                    const INTEGER        *IPIV,
                    FLOAT_COMPLEX        *B,
                    const INTEGER        *LDB,
                    INTEGER              *INFO)
{
    DEBUG_LAPACK_STUB("cgttrs");
    LAPACK_IMPL(cgttrs)(TRANS,
                        N,
                        NRHS,
                        DL,
                        D,
                        DU,
                        DU2,
                        IPIV,
                        B,
                        LDB,
                        INFO);
}

//-- cgtts2 --------------------------------------------------------------------
void
LAPACK_DECL(cgtts2)(const INTEGER        *ITRANS,
                    const INTEGER        *N,
                    const INTEGER        *NRHS,
                    const FLOAT_COMPLEX  *DL,
                    const FLOAT_COMPLEX  *D,
                    const FLOAT_COMPLEX  *DU,
                    const FLOAT_COMPLEX  *DU2,
                    const INTEGER        *IPIV,
                    FLOAT_COMPLEX        *B,
                    const INTEGER        *LDB)
{
    DEBUG_LAPACK_STUB("cgtts2");
    LAPACK_IMPL(cgtts2)(ITRANS,
                        N,
                        NRHS,
                        DL,
                        D,
                        DU,
                        DU2,
                        IPIV,
                        B,
                        LDB);
}

//-- chbev ---------------------------------------------------------------------
void
LAPACK_DECL(chbev)(const char           *JOBZ,
                   const char           *UPLO,
                   const INTEGER        *N,
                   const INTEGER        *KD,
                   FLOAT_COMPLEX        *AB,
                   const INTEGER        *LDAB,
                   FLOAT                *W,
                   FLOAT_COMPLEX        *Z,
                   const INTEGER        *LDZ,
                   FLOAT_COMPLEX        *WORK,
                   FLOAT                *RWORK,
                   INTEGER              *INFO)
{
    DEBUG_LAPACK_STUB("chbev");
    LAPACK_IMPL(chbev)(JOBZ,
                       UPLO,
                       N,
                       KD,
                       AB,
                       LDAB,
                       W,
                       Z,
                       LDZ,
                       WORK,
                       RWORK,
                       INFO);
}

//-- chbevd --------------------------------------------------------------------
void
LAPACK_DECL(chbevd)(const char       *JOBZ,
                    const char       *UPLO,
                    const INTEGER    *N,
                    const INTEGER    *KD,
                    FLOAT_COMPLEX    *AB,
                    const INTEGER    *LDAB,
                    FLOAT            *W,
                    FLOAT_COMPLEX    *Z,
                    const INTEGER    *LDZ,
                    FLOAT_COMPLEX    *WORK,
                    const INTEGER    *LWORK,
                    FLOAT            *RWORK,
                    const INTEGER    *LRWORK,
                    INTEGER          *IWORK,
                    const INTEGER    *LIWORK,
                    INTEGER          *INFO)
{
    DEBUG_LAPACK_STUB("chbevd");
    LAPACK_IMPL(chbevd)(JOBZ,
                        UPLO,
                        N,
                        KD,
                        AB,
                        LDAB,
                        W,
                        Z,
                        LDZ,
                        WORK,
                        LWORK,
                        RWORK,
                        LRWORK,
                        IWORK,
                        LIWORK,
                        INFO);
}

//-- chbevx --------------------------------------------------------------------
void
LAPACK_DECL(chbevx)(const char       *JOBZ,
                    const char       *RANGE,
                    const char       *UPLO,
                    const INTEGER    *N,
                    const INTEGER    *KD,
                    FLOAT_COMPLEX    *AB,
                    const INTEGER    *LDAB,
                    FLOAT_COMPLEX    *Q,
                    const INTEGER    *LDQ,
                    const FLOAT      *VL,
                    const FLOAT      *VU,
                    const INTEGER    *IL,
                    const INTEGER    *IU,
                    const FLOAT      *ABSTOL,
                    INTEGER          *M,
                    FLOAT            *W,
                    FLOAT_COMPLEX    *Z,
                    const INTEGER    *LDZ,
                    FLOAT_COMPLEX    *WORK,
                    FLOAT            *RWORK,
                    INTEGER          *IWORK,
                    INTEGER          *IFAIL,
                    INTEGER          *INFO)
{
    DEBUG_LAPACK_STUB("chbevx");
    LAPACK_IMPL(chbevx)(JOBZ,
                        RANGE,
                        UPLO,
                        N,
                        KD,
                        AB,
                        LDAB,
                        Q,
                        LDQ,
                        VL,
                        VU,
                        IL,
                        IU,
                        ABSTOL,
                        M,
                        W,
                        Z,
                        LDZ,
                        WORK,
                        RWORK,
                        IWORK,
                        IFAIL,
                        INFO);
}

//-- chbgst --------------------------------------------------------------------
void
LAPACK_DECL(chbgst)(const char           *VECT,
                    const char           *UPLO,
                    const INTEGER        *N,
                    const INTEGER        *KA,
                    const INTEGER        *KB,
                    FLOAT_COMPLEX        *AB,
                    const INTEGER        *LDAB,
                    const FLOAT_COMPLEX  *BB,
                    const INTEGER        *LDBB,
                    FLOAT_COMPLEX        *X,
                    const INTEGER        *LDX,
                    FLOAT_COMPLEX        *WORK,
                    FLOAT                *RWORK,
                    INTEGER              *INFO)
{
    DEBUG_LAPACK_STUB("chbgst");
    LAPACK_IMPL(chbgst)(VECT,
                        UPLO,
                        N,
                        KA,
                        KB,
                        AB,
                        LDAB,
                        BB,
                        LDBB,
                        X,
                        LDX,
                        WORK,
                        RWORK,
                        INFO);
}

//-- chbgv ---------------------------------------------------------------------
void
LAPACK_DECL(chbgv)(const char           *JOBZ,
                   const char           *UPLO,
                   const INTEGER        *N,
                   const INTEGER        *KA,
                   const INTEGER        *KB,
                   FLOAT_COMPLEX        *AB,
                   const INTEGER        *LDAB,
                   FLOAT_COMPLEX        *BB,
                   const INTEGER        *LDBB,
                   FLOAT                *W,
                   FLOAT_COMPLEX        *Z,
                   const INTEGER        *LDZ,
                   FLOAT_COMPLEX        *WORK,
                   FLOAT                *RWORK,
                   INTEGER              *INFO)
{
    DEBUG_LAPACK_STUB("chbgv");
    LAPACK_IMPL(chbgv)(JOBZ,
                       UPLO,
                       N,
                       KA,
                       KB,
                       AB,
                       LDAB,
                       BB,
                       LDBB,
                       W,
                       Z,
                       LDZ,
                       WORK,
                       RWORK,
                       INFO);
}

//-- chbgvd --------------------------------------------------------------------
void
LAPACK_DECL(chbgvd)(const char       *JOBZ,
                    const char       *UPLO,
                    const INTEGER    *N,
                    const INTEGER    *KA,
                    const INTEGER    *KB,
                    FLOAT_COMPLEX    *AB,
                    const INTEGER    *LDAB,
                    FLOAT_COMPLEX    *BB,
                    const INTEGER    *LDBB,
                    FLOAT            *W,
                    FLOAT_COMPLEX    *Z,
                    const INTEGER    *LDZ,
                    FLOAT_COMPLEX    *WORK,
                    const INTEGER    *LWORK,
                    FLOAT            *RWORK,
                    const INTEGER    *LRWORK,
                    INTEGER          *IWORK,
                    const INTEGER    *LIWORK,
                    INTEGER          *INFO)
{
    DEBUG_LAPACK_STUB("chbgvd");
    LAPACK_IMPL(chbgvd)(JOBZ,
                        UPLO,
                        N,
                        KA,
                        KB,
                        AB,
                        LDAB,
                        BB,
                        LDBB,
                        W,
                        Z,
                        LDZ,
                        WORK,
                        LWORK,
                        RWORK,
                        LRWORK,
                        IWORK,
                        LIWORK,
                        INFO);
}

//-- chbgvx --------------------------------------------------------------------
void
LAPACK_DECL(chbgvx)(const char       *JOBZ,
                    const char       *RANGE,
                    const char       *UPLO,
                    const INTEGER    *N,
                    const INTEGER    *KA,
                    const INTEGER    *KB,
                    FLOAT_COMPLEX    *AB,
                    const INTEGER    *LDAB,
                    FLOAT_COMPLEX    *BB,
                    const INTEGER    *LDBB,
                    FLOAT_COMPLEX    *Q,
                    const INTEGER    *LDQ,
                    const FLOAT      *VL,
                    const FLOAT      *VU,
                    const INTEGER    *IL,
                    const INTEGER    *IU,
                    const FLOAT      *ABSTOL,
                    INTEGER          *M,
                    FLOAT            *W,
                    FLOAT_COMPLEX    *Z,
                    const INTEGER    *LDZ,
                    FLOAT_COMPLEX    *WORK,
                    FLOAT            *RWORK,
                    INTEGER          *IWORK,
                    INTEGER          *IFAIL,
                    INTEGER          *INFO)
{
    DEBUG_LAPACK_STUB("chbgvx");
    LAPACK_IMPL(chbgvx)(JOBZ,
                        RANGE,
                        UPLO,
                        N,
                        KA,
                        KB,
                        AB,
                        LDAB,
                        BB,
                        LDBB,
                        Q,
                        LDQ,
                        VL,
                        VU,
                        IL,
                        IU,
                        ABSTOL,
                        M,
                        W,
                        Z,
                        LDZ,
                        WORK,
                        RWORK,
                        IWORK,
                        IFAIL,
                        INFO);
}

//-- chbtrd --------------------------------------------------------------------
void
LAPACK_DECL(chbtrd)(const char       *VECT,
                    const char       *UPLO,
                    const INTEGER    *N,
                    const INTEGER    *KD,
                    FLOAT_COMPLEX    *AB,
                    const INTEGER    *LDAB,
                    FLOAT            *D,
                    FLOAT            *E,
                    FLOAT_COMPLEX    *Q,
                    const INTEGER    *LDQ,
                    FLOAT_COMPLEX    *WORK,
                    INTEGER          *INFO)
{
    DEBUG_LAPACK_STUB("chbtrd");
    LAPACK_IMPL(chbtrd)(VECT,
                        UPLO,
                        N,
                        KD,
                        AB,
                        LDAB,
                        D,
                        E,
                        Q,
                        LDQ,
                        WORK,
                        INFO);
}

//-- checon --------------------------------------------------------------------
void
LAPACK_DECL(checon)(const char           *UPLO,
                    const INTEGER        *N,
                    const FLOAT_COMPLEX  *A,
                    const INTEGER        *LDA,
                    const INTEGER        *IPIV,
                    const FLOAT          *ANORM,
                    FLOAT                *RCOND,
                    FLOAT_COMPLEX        *WORK,
                    INTEGER              *INFO)
{
    DEBUG_LAPACK_STUB("checon");
    LAPACK_IMPL(checon)(UPLO,
                        N,
                        A,
                        LDA,
                        IPIV,
                        ANORM,
                        RCOND,
                        WORK,
                        INFO);
}

//-- cheequb -------------------------------------------------------------------
void
LAPACK_DECL(cheequb)(const char               *UPLO,
                     const INTEGER            *N,
                     const FLOAT_COMPLEX      *A,
                     const INTEGER            *LDA,
                     FLOAT                    *S,
                     FLOAT                    *SCOND,
                     FLOAT                    *AMAX,
                     const FLOAT_COMPLEX      *WORK,
                     INTEGER                  *INFO)
{
    DEBUG_LAPACK_STUB("cheequb");
    LAPACK_IMPL(cheequb)(UPLO,
                         N,
                         A,
                         LDA,
                         S,
                         SCOND,
                         AMAX,
                         WORK,
                         INFO);
}

//-- cheev ---------------------------------------------------------------------
void
LAPACK_DECL(cheev)(const char           *JOBZ,
                   const char           *UPLO,
                   const INTEGER        *N,
                   FLOAT_COMPLEX        *A,
                   const INTEGER        *LDA,
                   FLOAT                *W,
                   FLOAT_COMPLEX        *WORK,
                   const INTEGER        *LWORK,
                   FLOAT                *RWORK,
                   INTEGER              *INFO)
{
    DEBUG_LAPACK_STUB("cheev");
    LAPACK_IMPL(cheev)(JOBZ,
                       UPLO,
                       N,
                       A,
                       LDA,
                       W,
                       WORK,
                       LWORK,
                       RWORK,
                       INFO);
}

//-- cheevd --------------------------------------------------------------------
void
LAPACK_DECL(cheevd)(const char       *JOBZ,
                    const char       *UPLO,
                    const INTEGER    *N,
                    FLOAT_COMPLEX    *A,
                    const INTEGER    *LDA,
                    FLOAT            *W,
                    FLOAT_COMPLEX    *WORK,
                    const INTEGER    *LWORK,
                    FLOAT            *RWORK,
                    const INTEGER    *LRWORK,
                    INTEGER          *IWORK,
                    const INTEGER    *LIWORK,
                    INTEGER          *INFO)
{
    DEBUG_LAPACK_STUB("cheevd");
    LAPACK_IMPL(cheevd)(JOBZ,
                        UPLO,
                        N,
                        A,
                        LDA,
                        W,
                        WORK,
                        LWORK,
                        RWORK,
                        LRWORK,
                        IWORK,
                        LIWORK,
                        INFO);
}

//-- cheevr --------------------------------------------------------------------
void
LAPACK_DECL(cheevr)(const char       *JOBZ,
                    const char       *RANGE,
                    const char       *UPLO,
                    const INTEGER    *N,
                    FLOAT_COMPLEX    *A,
                    const INTEGER    *LDA,
                    const FLOAT      *VL,
                    const FLOAT      *VU,
                    const INTEGER    *IL,
                    const INTEGER    *IU,
                    const FLOAT      *ABSTOL,
                    INTEGER          *M,
                    FLOAT            *W,
                    FLOAT_COMPLEX    *Z,
                    const INTEGER    *LDZ,
                    INTEGER          *ISUPPZ,
                    FLOAT_COMPLEX    *WORK,
                    const INTEGER    *LWORK,
                    FLOAT            *RWORK,
                    const INTEGER    *LRWORK,
                    INTEGER          *IWORK,
                    const INTEGER    *LIWORK,
                    INTEGER          *INFO)
{
    DEBUG_LAPACK_STUB("cheevr");
    LAPACK_IMPL(cheevr)(JOBZ,
                        RANGE,
                        UPLO,
                        N,
                        A,
                        LDA,
                        VL,
                        VU,
                        IL,
                        IU,
                        ABSTOL,
                        M,
                        W,
                        Z,
                        LDZ,
                        ISUPPZ,
                        WORK,
                        LWORK,
                        RWORK,
                        LRWORK,
                        IWORK,
                        LIWORK,
                        INFO);
}

//-- cheevx --------------------------------------------------------------------
void
LAPACK_DECL(cheevx)(const char       *JOBZ,
                    const char       *RANGE,
                    const char       *UPLO,
                    const INTEGER    *N,
                    FLOAT_COMPLEX    *A,
                    const INTEGER    *LDA,
                    const FLOAT      *VL,
                    const FLOAT      *VU,
                    const INTEGER    *IL,
                    const INTEGER    *IU,
                    const FLOAT      *ABSTOL,
                    INTEGER          *M,
                    FLOAT            *W,
                    FLOAT_COMPLEX    *Z,
                    const INTEGER    *LDZ,
                    FLOAT_COMPLEX    *WORK,
                    const INTEGER    *LWORK,
                    FLOAT            *RWORK,
                    INTEGER          *IWORK,
                    INTEGER          *IFAIL,
                    INTEGER          *INFO)
{
    DEBUG_LAPACK_STUB("cheevx");
    LAPACK_IMPL(cheevx)(JOBZ,
                        RANGE,
                        UPLO,
                        N,
                        A,
                        LDA,
                        VL,
                        VU,
                        IL,
                        IU,
                        ABSTOL,
                        M,
                        W,
                        Z,
                        LDZ,
                        WORK,
                        LWORK,
                        RWORK,
                        IWORK,
                        IFAIL,
                        INFO);
}

//-- chegs2 --------------------------------------------------------------------
void
LAPACK_DECL(chegs2)(const INTEGER        *ITYPE,
                    const char           *UPLO,
                    const INTEGER        *N,
                    FLOAT_COMPLEX        *A,
                    const INTEGER        *LDA,
                    const FLOAT_COMPLEX  *B,
                    const INTEGER        *LDB,
                    INTEGER              *INFO)
{
    DEBUG_LAPACK_STUB("chegs2");
    LAPACK_IMPL(chegs2)(ITYPE,
                        UPLO,
                        N,
                        A,
                        LDA,
                        B,
                        LDB,
                        INFO);
}

//-- chegst --------------------------------------------------------------------
void
LAPACK_DECL(chegst)(const INTEGER        *ITYPE,
                    const char           *UPLO,
                    const INTEGER        *N,
                    FLOAT_COMPLEX        *A,
                    const INTEGER        *LDA,
                    const FLOAT_COMPLEX  *B,
                    const INTEGER        *LDB,
                    INTEGER              *INFO)
{
    DEBUG_LAPACK_STUB("chegst");
    LAPACK_IMPL(chegst)(ITYPE,
                        UPLO,
                        N,
                        A,
                        LDA,
                        B,
                        LDB,
                        INFO);
}

//-- chegv ---------------------------------------------------------------------
void
LAPACK_DECL(chegv)(const INTEGER        *ITYPE,
                   const char           *JOBZ,
                   const char           *UPLO,
                   const INTEGER        *N,
                   FLOAT_COMPLEX        *A,
                   const INTEGER        *LDA,
                   FLOAT_COMPLEX        *B,
                   const INTEGER        *LDB,
                   FLOAT                *W,
                   FLOAT_COMPLEX        *WORK,
                   const INTEGER        *LWORK,
                   FLOAT                *RWORK,
                   INTEGER              *INFO)
{
    DEBUG_LAPACK_STUB("chegv");
    LAPACK_IMPL(chegv)(ITYPE,
                       JOBZ,
                       UPLO,
                       N,
                       A,
                       LDA,
                       B,
                       LDB,
                       W,
                       WORK,
                       LWORK,
                       RWORK,
                       INFO);
}

//-- chegvd --------------------------------------------------------------------
void
LAPACK_DECL(chegvd)(const INTEGER    *ITYPE,
                    const char       *JOBZ,
                    const char       *UPLO,
                    const INTEGER    *N,
                    FLOAT_COMPLEX    *A,
                    const INTEGER    *LDA,
                    FLOAT_COMPLEX    *B,
                    const INTEGER    *LDB,
                    FLOAT            *W,
                    FLOAT_COMPLEX    *WORK,
                    const INTEGER    *LWORK,
                    FLOAT            *RWORK,
                    const INTEGER    *LRWORK,
                    INTEGER          *IWORK,
                    const INTEGER    *LIWORK,
                    INTEGER          *INFO)
{
    DEBUG_LAPACK_STUB("chegvd");
    LAPACK_IMPL(chegvd)(ITYPE,
                        JOBZ,
                        UPLO,
                        N,
                        A,
                        LDA,
                        B,
                        LDB,
                        W,
                        WORK,
                        LWORK,
                        RWORK,
                        LRWORK,
                        IWORK,
                        LIWORK,
                        INFO);
}

//-- chegvx --------------------------------------------------------------------
void
LAPACK_DECL(chegvx)(const INTEGER    *ITYPE,
                    const char       *JOBZ,
                    const char       *RANGE,
                    const char       *UPLO,
                    const INTEGER    *N,
                    FLOAT_COMPLEX    *A,
                    const INTEGER    *LDA,
                    FLOAT_COMPLEX    *B,
                    const INTEGER    *LDB,
                    const FLOAT      *VL,
                    const FLOAT      *VU,
                    const INTEGER    *IL,
                    const INTEGER    *IU,
                    const FLOAT      *ABSTOL,
                    INTEGER          *M,
                    FLOAT            *W,
                    FLOAT_COMPLEX    *Z,
                    const INTEGER    *LDZ,
                    FLOAT_COMPLEX    *WORK,
                    const INTEGER    *LWORK,
                    FLOAT            *RWORK,
                    INTEGER          *IWORK,
                    INTEGER          *IFAIL,
                    INTEGER          *INFO)
{
    DEBUG_LAPACK_STUB("chegvx");
    LAPACK_IMPL(chegvx)(ITYPE,
                        JOBZ,
                        RANGE,
                        UPLO,
                        N,
                        A,
                        LDA,
                        B,
                        LDB,
                        VL,
                        VU,
                        IL,
                        IU,
                        ABSTOL,
                        M,
                        W,
                        Z,
                        LDZ,
                        WORK,
                        LWORK,
                        RWORK,
                        IWORK,
                        IFAIL,
                        INFO);
}

//-- cherfs --------------------------------------------------------------------
void
LAPACK_DECL(cherfs)(const char           *UPLO,
                    const INTEGER        *N,
                    const INTEGER        *NRHS,
                    const FLOAT_COMPLEX  *A,
                    const INTEGER        *LDA,
                    const FLOAT_COMPLEX  *AF,
                    const INTEGER        *LDAF,
                    const INTEGER        *IPIV,
                    const FLOAT_COMPLEX  *B,
                    const INTEGER        *LDB,
                    FLOAT_COMPLEX        *X,
                    const INTEGER        *LDX,
                    FLOAT                *FERR,
                    FLOAT                *BERR,
                    FLOAT_COMPLEX        *WORK,
                    FLOAT                *RWORK,
                    INTEGER              *INFO)
{
    DEBUG_LAPACK_STUB("cherfs");
    LAPACK_IMPL(cherfs)(UPLO,
                        N,
                        NRHS,
                        A,
                        LDA,
                        AF,
                        LDAF,
                        IPIV,
                        B,
                        LDB,
                        X,
                        LDX,
                        FERR,
                        BERR,
                        WORK,
                        RWORK,
                        INFO);
}

//-- cherfsx -------------------------------------------------------------------
void
LAPACK_DECL(cherfsx)(const char               *UPLO,
                     const char               *EQUED,
                     const INTEGER            *N,
                     const INTEGER            *NRHS,
                     const FLOAT_COMPLEX      *A,
                     const INTEGER            *LDA,
                     const FLOAT_COMPLEX      *AF,
                     const INTEGER            *LDAF,
                     const INTEGER            *IPIV,
                     FLOAT                    *S,
                     const FLOAT_COMPLEX      *B,
                     const INTEGER            *LDB,
                     FLOAT_COMPLEX            *X,
                     const INTEGER            *LDX,
                     FLOAT                    *RCOND,
                     FLOAT                    *BERR,
                     const INTEGER            *N_ERR_BNDS,
                     FLOAT                    *ERR_BNDS_NORM,
                     FLOAT                    *ERR_BNDS_COMP,
                     const INTEGER            *NPARAMS,
                     FLOAT                    *PARAMS,
                     FLOAT_COMPLEX            *WORK,
                     FLOAT                    *RWORK,
                     INTEGER                  *INFO)
{
    DEBUG_LAPACK_STUB("cherfsx");
    LAPACK_IMPL(cherfsx)(UPLO,
                         EQUED,
                         N,
                         NRHS,
                         A,
                         LDA,
                         AF,
                         LDAF,
                         IPIV,
                         S,
                         B,
                         LDB,
                         X,
                         LDX,
                         RCOND,
                         BERR,
                         N_ERR_BNDS,
                         ERR_BNDS_NORM,
                         ERR_BNDS_COMP,
                         NPARAMS,
                         PARAMS,
                         WORK,
                         RWORK,
                         INFO);
}

//-- chesv ---------------------------------------------------------------------
void
LAPACK_DECL(chesv)(const char           *UPLO,
                   const INTEGER        *N,
                   const INTEGER        *NRHS,
                   FLOAT_COMPLEX        *A,
                   const INTEGER        *LDA,
                   INTEGER              *IPIV,
                   FLOAT_COMPLEX        *B,
                   const INTEGER        *LDB,
                   FLOAT_COMPLEX        *WORK,
                   const INTEGER        *LWORK,
                   INTEGER              *INFO)
{
    DEBUG_LAPACK_STUB("chesv");
    LAPACK_IMPL(chesv)(UPLO,
                       N,
                       NRHS,
                       A,
                       LDA,
                       IPIV,
                       B,
                       LDB,
                       WORK,
                       LWORK,
                       INFO);
}

//-- chesvx --------------------------------------------------------------------
void
LAPACK_DECL(chesvx)(const char           *FACT,
                    const char           *UPLO,
                    const INTEGER        *N,
                    const INTEGER        *NRHS,
                    const FLOAT_COMPLEX  *A,
                    const INTEGER        *LDA,
                    FLOAT_COMPLEX        *AF,
                    const INTEGER        *LDAF,
                    INTEGER              *IPIV,
                    const FLOAT_COMPLEX  *B,
                    const INTEGER        *LDB,
                    FLOAT_COMPLEX        *X,
                    const INTEGER        *LDX,
                    FLOAT                *RCOND,
                    FLOAT                *FERR,
                    FLOAT                *BERR,
                    FLOAT_COMPLEX        *WORK,
                    const INTEGER        *LWORK,
                    FLOAT                *RWORK,
                    INTEGER              *INFO)
{
    DEBUG_LAPACK_STUB("chesvx");
    LAPACK_IMPL(chesvx)(FACT,
                        UPLO,
                        N,
                        NRHS,
                        A,
                        LDA,
                        AF,
                        LDAF,
                        IPIV,
                        B,
                        LDB,
                        X,
                        LDX,
                        RCOND,
                        FERR,
                        BERR,
                        WORK,
                        LWORK,
                        RWORK,
                        INFO);
}

//-- chesvxx -------------------------------------------------------------------
void
LAPACK_DECL(chesvxx)(const char       *FACT,
                     const char       *UPLO,
                     const INTEGER    *N,
                     const INTEGER    *NRHS,
                     FLOAT_COMPLEX    *A,
                     const INTEGER    *LDA,
                     FLOAT_COMPLEX    *AF,
                     const INTEGER    *LDAF,
                     INTEGER          *IPIV,
                     char             *EQUED,
                     FLOAT            *S,
                     FLOAT_COMPLEX    *B,
                     const INTEGER    *LDB,
                     FLOAT_COMPLEX    *X,
                     const INTEGER    *LDX,
                     FLOAT            *RCOND,
                     FLOAT            *RPVGRW,
                     FLOAT            *BERR,
                     const INTEGER    *N_ERR_BNDS,
                     FLOAT            *ERR_BNDS_NORM,
                     FLOAT            *ERR_BNDS_COMP,
                     const INTEGER    *NPARAMS,
                     FLOAT            *PARAMS,
                     FLOAT_COMPLEX    *WORK,
                     FLOAT            *RWORK,
                     INTEGER          *INFO)
{
    DEBUG_LAPACK_STUB("chesvxx");
    LAPACK_IMPL(chesvxx)(FACT,
                         UPLO,
                         N,
                         NRHS,
                         A,
                         LDA,
                         AF,
                         LDAF,
                         IPIV,
                         EQUED,
                         S,
                         B,
                         LDB,
                         X,
                         LDX,
                         RCOND,
                         RPVGRW,
                         BERR,
                         N_ERR_BNDS,
                         ERR_BNDS_NORM,
                         ERR_BNDS_COMP,
                         NPARAMS,
                         PARAMS,
                         WORK,
                         RWORK,
                         INFO);
}

//-- cheswapr ------------------------------------------------------------------
void
LAPACK_DECL(cheswapr)(const char       *UPLO,
                      const INTEGER    *N,
                      FLOAT_COMPLEX    *A,
                      const INTEGER    *LDA,
                      const INTEGER    *I1,
                      const INTEGER    *I2)
{
    DEBUG_LAPACK_STUB("cheswapr");
    LAPACK_IMPL(cheswapr)(UPLO,
                          N,
                          A,
                          LDA,
                          I1,
                          I2);
}

//-- chetd2 --------------------------------------------------------------------
void
LAPACK_DECL(chetd2)(const char       *UPLO,
                    const INTEGER    *N,
                    FLOAT_COMPLEX    *A,
                    const INTEGER    *LDA,
                    FLOAT            *D,
                    FLOAT            *E,
                    FLOAT_COMPLEX    *TAU,
                    INTEGER          *INFO)
{
    DEBUG_LAPACK_STUB("chetd2");
    LAPACK_IMPL(chetd2)(UPLO,
                        N,
                        A,
                        LDA,
                        D,
                        E,
                        TAU,
                        INFO);
}

//-- chetf2 --------------------------------------------------------------------
void
LAPACK_DECL(chetf2)(const char       *UPLO,
                    const INTEGER    *N,
                    FLOAT_COMPLEX    *A,
                    const INTEGER    *LDA,
                    INTEGER          *IPIV,
                    INTEGER          *INFO)
{
    DEBUG_LAPACK_STUB("chetf2");
    LAPACK_IMPL(chetf2)(UPLO,
                        N,
                        A,
                        LDA,
                        IPIV,
                        INFO);
}

//-- chetrd --------------------------------------------------------------------
void
LAPACK_DECL(chetrd)(const char       *UPLO,
                    const INTEGER    *N,
                    FLOAT_COMPLEX    *A,
                    const INTEGER    *LDA,
                    FLOAT            *D,
                    FLOAT            *E,
                    FLOAT_COMPLEX    *TAU,
                    FLOAT_COMPLEX    *WORK,
                    const INTEGER    *LWORK,
                    INTEGER          *INFO)
{
    DEBUG_LAPACK_STUB("chetrd");
    LAPACK_IMPL(chetrd)(UPLO,
                        N,
                        A,
                        LDA,
                        D,
                        E,
                        TAU,
                        WORK,
                        LWORK,
                        INFO);
}

//-- chetrf --------------------------------------------------------------------
void
LAPACK_DECL(chetrf)(const char       *UPLO,
                    const INTEGER    *N,
                    FLOAT_COMPLEX    *A,
                    const INTEGER    *LDA,
                    INTEGER          *IPIV,
                    FLOAT_COMPLEX    *WORK,
                    const INTEGER    *LWORK,
                    INTEGER          *INFO)
{
    DEBUG_LAPACK_STUB("chetrf");
    LAPACK_IMPL(chetrf)(UPLO,
                        N,
                        A,
                        LDA,
                        IPIV,
                        WORK,
                        LWORK,
                        INFO);
}

//-- chetri --------------------------------------------------------------------
void
LAPACK_DECL(chetri)(const char       *UPLO,
                    const INTEGER    *N,
                    FLOAT_COMPLEX    *A,
                    const INTEGER    *LDA,
                    const INTEGER    *IPIV,
                    FLOAT_COMPLEX    *WORK,
                    INTEGER          *INFO)
{
    DEBUG_LAPACK_STUB("chetri");
    LAPACK_IMPL(chetri)(UPLO,
                        N,
                        A,
                        LDA,
                        IPIV,
                        WORK,
                        INFO);
}

//-- chetri2 -------------------------------------------------------------------
void
LAPACK_DECL(chetri2)(const char       *UPLO,
                     const INTEGER    *N,
                     FLOAT_COMPLEX    *A,
                     const INTEGER    *LDA,
                     const INTEGER    *IPIV,
                     FLOAT_COMPLEX    *WORK,
                     const INTEGER    *LWORK,
                     INTEGER          *INFO)
{
    DEBUG_LAPACK_STUB("chetri2");
    LAPACK_IMPL(chetri2)(UPLO,
                         N,
                         A,
                         LDA,
                         IPIV,
                         WORK,
                         LWORK,
                         INFO);
}

//-- chetri2x ------------------------------------------------------------------
void
LAPACK_DECL(chetri2x)(const char       *UPLO,
                      const INTEGER    *N,
                      FLOAT_COMPLEX    *A,
                      const INTEGER    *LDA,
                      const INTEGER    *IPIV,
                      FLOAT_COMPLEX    *WORK,
                      const INTEGER    *NB,
                      INTEGER          *INFO)
{
    DEBUG_LAPACK_STUB("chetri2x");
    LAPACK_IMPL(chetri2x)(UPLO,
                          N,
                          A,
                          LDA,
                          IPIV,
                          WORK,
                          NB,
                          INFO);
}

//-- chetrs --------------------------------------------------------------------
void
LAPACK_DECL(chetrs)(const char           *UPLO,
                    const INTEGER        *N,
                    const INTEGER        *NRHS,
                    const FLOAT_COMPLEX  *A,
                    const INTEGER        *LDA,
                    const INTEGER        *IPIV,
                    FLOAT_COMPLEX        *B,
                    const INTEGER        *LDB,
                    INTEGER              *INFO)
{
    DEBUG_LAPACK_STUB("chetrs");
    LAPACK_IMPL(chetrs)(UPLO,
                        N,
                        NRHS,
                        A,
                        LDA,
                        IPIV,
                        B,
                        LDB,
                        INFO);
}

//-- chetrs2 -------------------------------------------------------------------
void
LAPACK_DECL(chetrs2)(const char               *UPLO,
                     const INTEGER            *N,
                     const INTEGER            *NRHS,
                     const FLOAT_COMPLEX      *A,
                     const INTEGER            *LDA,
                     const INTEGER            *IPIV,
                     FLOAT_COMPLEX            *B,
                     const INTEGER            *LDB,
                     FLOAT_COMPLEX            *WORK,
                     INTEGER                  *INFO)
{
    DEBUG_LAPACK_STUB("chetrs2");
    LAPACK_IMPL(chetrs2)(UPLO,
                         N,
                         NRHS,
                         A,
                         LDA,
                         IPIV,
                         B,
                         LDB,
                         WORK,
                         INFO);
}

//-- chfrk ---------------------------------------------------------------------
void
LAPACK_DECL(chfrk)(const char               *TRANSR,
                   const char               *UPLO,
                   const char               *TRANS,
                   const INTEGER            *N,
                   const INTEGER            *K,
                   const FLOAT              *ALPHA,
                   const FLOAT_COMPLEX      *A,
                   const INTEGER            *LDA,
                   const FLOAT              *BETA,
                   FLOAT_COMPLEX            *C)
{
    DEBUG_LAPACK_STUB("chfrk");
    LAPACK_IMPL(chfrk)(TRANSR,
                       UPLO,
                       TRANS,
                       N,
                       K,
                       ALPHA,
                       A,
                       LDA,
                       BETA,
                       C);
}

//-- chgeqz --------------------------------------------------------------------
void
LAPACK_DECL(chgeqz)(const char       *JOB,
                    const char       *COMPQ,
                    const char       *COMPZ,
                    const INTEGER    *N,
                    const INTEGER    *ILO,
                    const INTEGER    *IHI,
                    FLOAT_COMPLEX    *H,
                    const INTEGER    *LDH,
                    FLOAT_COMPLEX    *T,
                    const INTEGER    *LDT,
                    FLOAT_COMPLEX    *ALPHA,
                    FLOAT_COMPLEX    *BETA,
                    FLOAT_COMPLEX    *Q,
                    const INTEGER    *LDQ,
                    FLOAT_COMPLEX    *Z,
                    const INTEGER    *LDZ,
                    FLOAT_COMPLEX    *WORK,
                    const INTEGER    *LWORK,
                    FLOAT            *RWORK,
                    INTEGER          *INFO)
{
    DEBUG_LAPACK_STUB("chgeqz");
    LAPACK_IMPL(chgeqz)(JOB,
                        COMPQ,
                        COMPZ,
                        N,
                        ILO,
                        IHI,
                        H,
                        LDH,
                        T,
                        LDT,
                        ALPHA,
                        BETA,
                        Q,
                        LDQ,
                        Z,
                        LDZ,
                        WORK,
                        LWORK,
                        RWORK,
                        INFO);
}

//-- chla_transtype ------------------------------------------------------------
UNKNOWN
LAPACK_DECL(chla_transtype)(const INTEGER    *TRANS)
{
    DEBUG_LAPACK_STUB("chla_transtype");
    return LAPACK_IMPL(chla_transtype)(TRANS);
}

//-- chpcon --------------------------------------------------------------------
void
LAPACK_DECL(chpcon)(const char           *UPLO,
                    const INTEGER        *N,
                    const FLOAT_COMPLEX  *AP,
                    const INTEGER        *IPIV,
                    const FLOAT          *ANORM,
                    FLOAT                *RCOND,
                    FLOAT_COMPLEX        *WORK,
                    INTEGER              *INFO)
{
    DEBUG_LAPACK_STUB("chpcon");
    LAPACK_IMPL(chpcon)(UPLO,
                        N,
                        AP,
                        IPIV,
                        ANORM,
                        RCOND,
                        WORK,
                        INFO);
}

//-- chpev ---------------------------------------------------------------------
void
LAPACK_DECL(chpev)(const char           *JOBZ,
                   const char           *UPLO,
                   const INTEGER        *N,
                   FLOAT_COMPLEX        *AP,
                   FLOAT                *W,
                   FLOAT_COMPLEX        *Z,
                   const INTEGER        *LDZ,
                   FLOAT_COMPLEX        *WORK,
                   FLOAT                *RWORK,
                   INTEGER              *INFO)
{
    DEBUG_LAPACK_STUB("chpev");
    LAPACK_IMPL(chpev)(JOBZ,
                       UPLO,
                       N,
                       AP,
                       W,
                       Z,
                       LDZ,
                       WORK,
                       RWORK,
                       INFO);
}

//-- chpevd --------------------------------------------------------------------
void
LAPACK_DECL(chpevd)(const char       *JOBZ,
                    const char       *UPLO,
                    const INTEGER    *N,
                    FLOAT_COMPLEX    *AP,
                    FLOAT            *W,
                    FLOAT_COMPLEX    *Z,
                    const INTEGER    *LDZ,
                    FLOAT_COMPLEX    *WORK,
                    const INTEGER    *LWORK,
                    FLOAT            *RWORK,
                    const INTEGER    *LRWORK,
                    INTEGER          *IWORK,
                    const INTEGER    *LIWORK,
                    INTEGER          *INFO)
{
    DEBUG_LAPACK_STUB("chpevd");
    LAPACK_IMPL(chpevd)(JOBZ,
                        UPLO,
                        N,
                        AP,
                        W,
                        Z,
                        LDZ,
                        WORK,
                        LWORK,
                        RWORK,
                        LRWORK,
                        IWORK,
                        LIWORK,
                        INFO);
}

//-- chpevx --------------------------------------------------------------------
void
LAPACK_DECL(chpevx)(const char       *JOBZ,
                    const char       *RANGE,
                    const char       *UPLO,
                    const INTEGER    *N,
                    FLOAT_COMPLEX    *AP,
                    const FLOAT      *VL,
                    const FLOAT      *VU,
                    const INTEGER    *IL,
                    const INTEGER    *IU,
                    const FLOAT      *ABSTOL,
                    INTEGER          *M,
                    FLOAT            *W,
                    FLOAT_COMPLEX    *Z,
                    const INTEGER    *LDZ,
                    FLOAT_COMPLEX    *WORK,
                    FLOAT            *RWORK,
                    INTEGER          *IWORK,
                    INTEGER          *IFAIL,
                    INTEGER          *INFO)
{
    DEBUG_LAPACK_STUB("chpevx");
    LAPACK_IMPL(chpevx)(JOBZ,
                        RANGE,
                        UPLO,
                        N,
                        AP,
                        VL,
                        VU,
                        IL,
                        IU,
                        ABSTOL,
                        M,
                        W,
                        Z,
                        LDZ,
                        WORK,
                        RWORK,
                        IWORK,
                        IFAIL,
                        INFO);
}

//-- chpgst --------------------------------------------------------------------
void
LAPACK_DECL(chpgst)(const INTEGER        *ITYPE,
                    const char           *UPLO,
                    const INTEGER        *N,
                    FLOAT_COMPLEX        *AP,
                    const FLOAT_COMPLEX  *BP,
                    INTEGER              *INFO)
{
    DEBUG_LAPACK_STUB("chpgst");
    LAPACK_IMPL(chpgst)(ITYPE,
                        UPLO,
                        N,
                        AP,
                        BP,
                        INFO);
}

//-- chpgv ---------------------------------------------------------------------
void
LAPACK_DECL(chpgv)(const INTEGER        *ITYPE,
                   const char           *JOBZ,
                   const char           *UPLO,
                   const INTEGER        *N,
                   FLOAT_COMPLEX        *AP,
                   FLOAT_COMPLEX        *BP,
                   FLOAT                *W,
                   FLOAT_COMPLEX        *Z,
                   const INTEGER        *LDZ,
                   FLOAT_COMPLEX        *WORK,
                   FLOAT                *RWORK,
                   INTEGER              *INFO)
{
    DEBUG_LAPACK_STUB("chpgv");
    LAPACK_IMPL(chpgv)(ITYPE,
                       JOBZ,
                       UPLO,
                       N,
                       AP,
                       BP,
                       W,
                       Z,
                       LDZ,
                       WORK,
                       RWORK,
                       INFO);
}

//-- chpgvd --------------------------------------------------------------------
void
LAPACK_DECL(chpgvd)(const INTEGER    *ITYPE,
                    const char       *JOBZ,
                    const char       *UPLO,
                    const INTEGER    *N,
                    FLOAT_COMPLEX    *AP,
                    FLOAT_COMPLEX    *BP,
                    FLOAT            *W,
                    FLOAT_COMPLEX    *Z,
                    const INTEGER    *LDZ,
                    FLOAT_COMPLEX    *WORK,
                    const INTEGER    *LWORK,
                    FLOAT            *RWORK,
                    const INTEGER    *LRWORK,
                    INTEGER          *IWORK,
                    const INTEGER    *LIWORK,
                    INTEGER          *INFO)
{
    DEBUG_LAPACK_STUB("chpgvd");
    LAPACK_IMPL(chpgvd)(ITYPE,
                        JOBZ,
                        UPLO,
                        N,
                        AP,
                        BP,
                        W,
                        Z,
                        LDZ,
                        WORK,
                        LWORK,
                        RWORK,
                        LRWORK,
                        IWORK,
                        LIWORK,
                        INFO);
}

//-- chpgvx --------------------------------------------------------------------
void
LAPACK_DECL(chpgvx)(const INTEGER    *ITYPE,
                    const char       *JOBZ,
                    const char       *RANGE,
                    const char       *UPLO,
                    const INTEGER    *N,
                    FLOAT_COMPLEX    *AP,
                    FLOAT_COMPLEX    *BP,
                    const FLOAT      *VL,
                    const FLOAT      *VU,
                    const INTEGER    *IL,
                    const INTEGER    *IU,
                    const FLOAT      *ABSTOL,
                    INTEGER          *M,
                    FLOAT            *W,
                    FLOAT_COMPLEX    *Z,
                    const INTEGER    *LDZ,
                    FLOAT_COMPLEX    *WORK,
                    FLOAT            *RWORK,
                    INTEGER          *IWORK,
                    INTEGER          *IFAIL,
                    INTEGER          *INFO)
{
    DEBUG_LAPACK_STUB("chpgvx");
    LAPACK_IMPL(chpgvx)(ITYPE,
                        JOBZ,
                        RANGE,
                        UPLO,
                        N,
                        AP,
                        BP,
                        VL,
                        VU,
                        IL,
                        IU,
                        ABSTOL,
                        M,
                        W,
                        Z,
                        LDZ,
                        WORK,
                        RWORK,
                        IWORK,
                        IFAIL,
                        INFO);
}

//-- chprfs --------------------------------------------------------------------
void
LAPACK_DECL(chprfs)(const char           *UPLO,
                    const INTEGER        *N,
                    const INTEGER        *NRHS,
                    const FLOAT_COMPLEX  *AP,
                    const FLOAT_COMPLEX  *AFP,
                    const INTEGER        *IPIV,
                    const FLOAT_COMPLEX  *B,
                    const INTEGER        *LDB,
                    FLOAT_COMPLEX        *X,
                    const INTEGER        *LDX,
                    FLOAT                *FERR,
                    FLOAT                *BERR,
                    FLOAT_COMPLEX        *WORK,
                    FLOAT                *RWORK,
                    INTEGER              *INFO)
{
    DEBUG_LAPACK_STUB("chprfs");
    LAPACK_IMPL(chprfs)(UPLO,
                        N,
                        NRHS,
                        AP,
                        AFP,
                        IPIV,
                        B,
                        LDB,
                        X,
                        LDX,
                        FERR,
                        BERR,
                        WORK,
                        RWORK,
                        INFO);
}

//-- chpsv ---------------------------------------------------------------------
void
LAPACK_DECL(chpsv)(const char           *UPLO,
                   const INTEGER        *N,
                   const INTEGER        *NRHS,
                   FLOAT_COMPLEX        *AP,
                   INTEGER              *IPIV,
                   FLOAT_COMPLEX        *B,
                   const INTEGER        *LDB,
                   INTEGER              *INFO)
{
    DEBUG_LAPACK_STUB("chpsv");
    LAPACK_IMPL(chpsv)(UPLO,
                       N,
                       NRHS,
                       AP,
                       IPIV,
                       B,
                       LDB,
                       INFO);
}

//-- chpsvx --------------------------------------------------------------------
void
LAPACK_DECL(chpsvx)(const char           *FACT,
                    const char           *UPLO,
                    const INTEGER        *N,
                    const INTEGER        *NRHS,
                    const FLOAT_COMPLEX  *AP,
                    FLOAT_COMPLEX        *AFP,
                    INTEGER              *IPIV,
                    const FLOAT_COMPLEX  *B,
                    const INTEGER        *LDB,
                    FLOAT_COMPLEX        *X,
                    const INTEGER        *LDX,
                    FLOAT                *RCOND,
                    FLOAT                *FERR,
                    FLOAT                *BERR,
                    FLOAT_COMPLEX        *WORK,
                    FLOAT                *RWORK,
                    INTEGER              *INFO)
{
    DEBUG_LAPACK_STUB("chpsvx");
    LAPACK_IMPL(chpsvx)(FACT,
                        UPLO,
                        N,
                        NRHS,
                        AP,
                        AFP,
                        IPIV,
                        B,
                        LDB,
                        X,
                        LDX,
                        RCOND,
                        FERR,
                        BERR,
                        WORK,
                        RWORK,
                        INFO);
}

//-- chptrd --------------------------------------------------------------------
void
LAPACK_DECL(chptrd)(const char       *UPLO,
                    const INTEGER    *N,
                    FLOAT_COMPLEX    *AP,
                    FLOAT            *D,
                    FLOAT            *E,
                    FLOAT_COMPLEX    *TAU,
                    INTEGER          *INFO)
{
    DEBUG_LAPACK_STUB("chptrd");
    LAPACK_IMPL(chptrd)(UPLO,
                        N,
                        AP,
                        D,
                        E,
                        TAU,
                        INFO);
}

//-- chptrf --------------------------------------------------------------------
void
LAPACK_DECL(chptrf)(const char       *UPLO,
                    const INTEGER    *N,
                    FLOAT_COMPLEX    *AP,
                    INTEGER          *IPIV,
                    INTEGER          *INFO)
{
    DEBUG_LAPACK_STUB("chptrf");
    LAPACK_IMPL(chptrf)(UPLO,
                        N,
                        AP,
                        IPIV,
                        INFO);
}

//-- chptri --------------------------------------------------------------------
void
LAPACK_DECL(chptri)(const char       *UPLO,
                    const INTEGER    *N,
                    FLOAT_COMPLEX    *AP,
                    const INTEGER    *IPIV,
                    FLOAT_COMPLEX    *WORK,
                    INTEGER          *INFO)
{
    DEBUG_LAPACK_STUB("chptri");
    LAPACK_IMPL(chptri)(UPLO,
                        N,
                        AP,
                        IPIV,
                        WORK,
                        INFO);
}

//-- chptrs --------------------------------------------------------------------
void
LAPACK_DECL(chptrs)(const char           *UPLO,
                    const INTEGER        *N,
                    const INTEGER        *NRHS,
                    const FLOAT_COMPLEX  *AP,
                    const INTEGER        *IPIV,
                    FLOAT_COMPLEX        *B,
                    const INTEGER        *LDB,
                    INTEGER              *INFO)
{
    DEBUG_LAPACK_STUB("chptrs");
    LAPACK_IMPL(chptrs)(UPLO,
                        N,
                        NRHS,
                        AP,
                        IPIV,
                        B,
                        LDB,
                        INFO);
}

//-- chsein --------------------------------------------------------------------
void
LAPACK_DECL(chsein)(const char           *SIDE,
                    const char           *EIGSRC,
                    const char           *INITV,
                    const LOGICAL        *SELECT,
                    const INTEGER        *N,
                    const FLOAT_COMPLEX  *H,
                    const INTEGER        *LDH,
                    FLOAT_COMPLEX        *W,
                    FLOAT_COMPLEX        *VL,
                    const INTEGER        *LDVL,
                    FLOAT_COMPLEX        *VR,
                    const INTEGER        *LDVR,
                    const INTEGER        *MM,
                    INTEGER              *M,
                    FLOAT_COMPLEX        *WORK,
                    FLOAT                *RWORK,
                    INTEGER              *IFAILL,
                    INTEGER              *IFAILR,
                    INTEGER              *INFO)
{
    DEBUG_LAPACK_STUB("chsein");
    LAPACK_IMPL(chsein)(SIDE,
                        EIGSRC,
                        INITV,
                        SELECT,
                        N,
                        H,
                        LDH,
                        W,
                        VL,
                        LDVL,
                        VR,
                        LDVR,
                        MM,
                        M,
                        WORK,
                        RWORK,
                        IFAILL,
                        IFAILR,
                        INFO);
}

//-- chseqr --------------------------------------------------------------------
void
LAPACK_DECL(chseqr)(const char       *JOB,
                    const char       *COMPZ,
                    const INTEGER    *N,
                    const INTEGER    *ILO,
                    const INTEGER    *IHI,
                    FLOAT_COMPLEX    *H,
                    const INTEGER    *LDH,
                    FLOAT_COMPLEX    *W,
                    FLOAT_COMPLEX    *Z,
                    const INTEGER    *LDZ,
                    FLOAT_COMPLEX    *WORK,
                    const INTEGER    *LWORK,
                    INTEGER          *INFO)
{
    DEBUG_LAPACK_STUB("chseqr");
    LAPACK_IMPL(chseqr)(JOB,
                        COMPZ,
                        N,
                        ILO,
                        IHI,
                        H,
                        LDH,
                        W,
                        Z,
                        LDZ,
                        WORK,
                        LWORK,
                        INFO);
}

//-- cla_gbamv -----------------------------------------------------------------
void
LAPACK_DECL(cla_gbamv)(const INTEGER            *TRANS,
                       const INTEGER            *M,
                       const INTEGER            *N,
                       const INTEGER            *KL,
                       const INTEGER            *KU,
                       const FLOAT              *ALPHA,
                       const FLOAT_COMPLEX      *AB,
                       const INTEGER            *LDAB,
                       const FLOAT_COMPLEX      *X,
                       const INTEGER            *INCX,
                       const FLOAT              *BETA,
                       FLOAT                    *Y,
                       const INTEGER            *INCY)
{
    DEBUG_LAPACK_STUB("cla_gbamv");
    LAPACK_IMPL(cla_gbamv)(TRANS,
                           M,
                           N,
                           KL,
                           KU,
                           ALPHA,
                           AB,
                           LDAB,
                           X,
                           INCX,
                           BETA,
                           Y,
                           INCY);
}

//-- cla_gbrcond_c -------------------------------------------------------------
FLOAT
LAPACK_DECL(cla_gbrcond_c)(const char               *TRANS,
                           const INTEGER            *N,
                           const INTEGER            *KL,
                           const INTEGER            *KU,
                           const FLOAT_COMPLEX      *AB,
                           const INTEGER            *LDAB,
                           const FLOAT_COMPLEX      *AFB,
                           const INTEGER            *LDAFB,
                           const INTEGER            *IPIV,
                           const FLOAT              *C,
                           const LOGICAL            *CAPPLY,
                           INTEGER                  *INFO,
                           const FLOAT_COMPLEX      *WORK,
                           const FLOAT              *RWORK)
{
    DEBUG_LAPACK_STUB("cla_gbrcond_c");
    return LAPACK_IMPL(cla_gbrcond_c)(TRANS,
                                      N,
                                      KL,
                                      KU,
                                      AB,
                                      LDAB,
                                      AFB,
                                      LDAFB,
                                      IPIV,
                                      C,
                                      CAPPLY,
                                      INFO,
                                      WORK,
                                      RWORK);
}

//-- cla_gbrcond_x -------------------------------------------------------------
FLOAT
LAPACK_DECL(cla_gbrcond_x)(const char               *TRANS,
                           const INTEGER            *N,
                           const INTEGER            *KL,
                           const INTEGER            *KU,
                           const FLOAT_COMPLEX      *AB,
                           const INTEGER            *LDAB,
                           const FLOAT_COMPLEX      *AFB,
                           const INTEGER            *LDAFB,
                           const INTEGER            *IPIV,
                           const FLOAT_COMPLEX      *X,
                           INTEGER                  *INFO,
                           const FLOAT_COMPLEX      *WORK,
                           const FLOAT              *RWORK)
{
    DEBUG_LAPACK_STUB("cla_gbrcond_x");
    return LAPACK_IMPL(cla_gbrcond_x)(TRANS,
                                      N,
                                      KL,
                                      KU,
                                      AB,
                                      LDAB,
                                      AFB,
                                      LDAFB,
                                      IPIV,
                                      X,
                                      INFO,
                                      WORK,
                                      RWORK);
}

//-- cla_gbrfsx_extended -------------------------------------------------------
void
LAPACK_DECL(cla_gbrfsx_extended)(const INTEGER            *PREC_TYPE,
                                 const INTEGER            *TRANS_TYPE,
                                 const INTEGER            *N,
                                 const INTEGER            *KL,
                                 const INTEGER            *KU,
                                 const INTEGER            *NRHS,
                                 const FLOAT_COMPLEX      *AB,
                                 const INTEGER            *LDAB,
                                 const FLOAT_COMPLEX      *AFB,
                                 const INTEGER            *LDAFB,
                                 const INTEGER            *IPIV,
                                 const LOGICAL            *COLEQU,
                                 const FLOAT              *C,
                                 const FLOAT_COMPLEX      *B,
                                 const INTEGER            *LDB,
                                 FLOAT_COMPLEX            *Y,
                                 const INTEGER            *LDY,
                                 FLOAT                    *BERR_OUT,
                                 const INTEGER            *N_NORMS,
                                 FLOAT                    *ERR_BNDS_NORM,
                                 FLOAT                    *ERR_BNDS_COMP,
                                 const FLOAT_COMPLEX      *RES,
                                 const FLOAT              *AYB,
                                 const FLOAT_COMPLEX      *DY,
                                 const FLOAT_COMPLEX      *Y_TAIL,
                                 const FLOAT              *RCOND,
                                 const INTEGER            *ITHRESH,
                                 const FLOAT              *RTHRESH,
                                 const FLOAT              *DZ_UB,
                                 const LOGICAL            *IGNORE_CWISE,
                                 INTEGER                  *INFO)
{
    DEBUG_LAPACK_STUB("cla_gbrfsx_extended");
    ASSERT(0);
    /*
    LAPACK_IMPL(cla_gbrfsx_extended)(PREC_TYPE,
                                     TRANS_TYPE,
                                     N,
                                     KL,
                                     KU,
                                     NRHS,
                                     AB,
                                     LDAB,
                                     AFB,
                                     LDAFB,
                                     IPIV,
                                     COLEQU,
                                     C,
                                     B,
                                     LDB,
                                     Y,
                                     LDY,
                                     BERR_OUT,
                                     N_NORMS,
                                     ERR_BNDS_NORM,
                                     ERR_BNDS_COMP,
                                     RES,
                                     AYB,
                                     DY,
                                     Y_TAIL,
                                     RCOND,
                                     ITHRESH,
                                     RTHRESH,
                                     DZ_UB,
                                     IGNORE_CWISE,
                                     INFO);
    */
}

//-- cla_gbrpvgrw --------------------------------------------------------------
FLOAT
LAPACK_DECL(cla_gbrpvgrw)(const INTEGER            *N,
                          const INTEGER            *KL,
                          const INTEGER            *KU,
                          const INTEGER            *NCOLS,
                          const FLOAT_COMPLEX      *AB,
                          const INTEGER            *LDAB,
                          const FLOAT_COMPLEX      *AFB,
                          const INTEGER            *LDAFB)
{
    DEBUG_LAPACK_STUB("cla_gbrpvgrw");
    return LAPACK_IMPL(cla_gbrpvgrw)(N,
                                     KL,
                                     KU,
                                     NCOLS,
                                     AB,
                                     LDAB,
                                     AFB,
                                     LDAFB);
}

//-- cla_geamv -----------------------------------------------------------------
void
LAPACK_DECL(cla_geamv)(const INTEGER            *TRANS,
                       const INTEGER            *M,
                       const INTEGER            *N,
                       const FLOAT              *ALPHA,
                       const FLOAT_COMPLEX      *A,
                       const INTEGER            *LDA,
                       const FLOAT_COMPLEX      *X,
                       const INTEGER            *INCX,
                       const FLOAT              *BETA,
                       FLOAT                    *Y,
                       const INTEGER            *INCY)
{
    DEBUG_LAPACK_STUB("cla_geamv");
    LAPACK_IMPL(cla_geamv)(TRANS,
                           M,
                           N,
                           ALPHA,
                           A,
                           LDA,
                           X,
                           INCX,
                           BETA,
                           Y,
                           INCY);
}

//-- cla_gercond_c -------------------------------------------------------------
FLOAT
LAPACK_DECL(cla_gercond_c)(const char               *TRANS,
                           const INTEGER            *N,
                           const FLOAT_COMPLEX      *A,
                           const INTEGER            *LDA,
                           const FLOAT_COMPLEX      *AF,
                           const INTEGER            *LDAF,
                           const INTEGER            *IPIV,
                           const FLOAT              *C,
                           const LOGICAL            *CAPPLY,
                           INTEGER                  *INFO,
                           const FLOAT_COMPLEX      *WORK,
                           const FLOAT              *RWORK)
{
    DEBUG_LAPACK_STUB("cla_gercond_c");
    return LAPACK_IMPL(cla_gercond_c)(TRANS,
                                      N,
                                      A,
                                      LDA,
                                      AF,
                                      LDAF,
                                      IPIV,
                                      C,
                                      CAPPLY,
                                      INFO,
                                      WORK,
                                      RWORK);
}

//-- cla_gercond_x -------------------------------------------------------------
FLOAT
LAPACK_DECL(cla_gercond_x)(const char               *TRANS,
                           const INTEGER            *N,
                           const FLOAT_COMPLEX      *A,
                           const INTEGER            *LDA,
                           const FLOAT_COMPLEX      *AF,
                           const INTEGER            *LDAF,
                           const INTEGER            *IPIV,
                           const FLOAT_COMPLEX      *X,
                           INTEGER                  *INFO,
                           const FLOAT_COMPLEX      *WORK,
                           const FLOAT              *RWORK)
{
    DEBUG_LAPACK_STUB("cla_gercond_x");
    return LAPACK_IMPL(cla_gercond_x)(TRANS,
                                      N,
                                      A,
                                      LDA,
                                      AF,
                                      LDAF,
                                      IPIV,
                                      X,
                                      INFO,
                                      WORK,
                                      RWORK);
}

//-- cla_gerfsx_extended -------------------------------------------------------
void
LAPACK_DECL(cla_gerfsx_extended)(const INTEGER            *PREC_TYPE,
                                 const INTEGER            *TRANS_TYPE,
                                 const INTEGER            *N,
                                 const INTEGER            *NRHS,
                                 const FLOAT_COMPLEX      *A,
                                 const INTEGER            *LDA,
                                 const FLOAT_COMPLEX      *AF,
                                 const INTEGER            *LDAF,
                                 const INTEGER            *IPIV,
                                 const LOGICAL            *COLEQU,
                                 const FLOAT              *C,
                                 const FLOAT_COMPLEX      *B,
                                 const INTEGER            *LDB,
                                 FLOAT_COMPLEX            *Y,
                                 const INTEGER            *LDY,
                                 FLOAT                    *BERR_OUT,
                                 const INTEGER            *N_NORMS,
                                 const FLOAT              *ERRS_N,
                                 const FLOAT              *ERRS_C,
                                 const FLOAT_COMPLEX      *RES,
                                 const FLOAT              *AYB,
                                 const FLOAT_COMPLEX      *DY,
                                 const FLOAT_COMPLEX      *Y_TAIL,
                                 const FLOAT              *RCOND,
                                 const INTEGER            *ITHRESH,
                                 const FLOAT              *RTHRESH,
                                 const FLOAT              *DZ_UB,
                                 const LOGICAL            *IGNORE_CWISE,
                                 INTEGER                  *INFO)
{
    DEBUG_LAPACK_STUB("cla_gerfsx_extended");
    ASSERT(0);
    /*
    LAPACK_IMPL(cla_gerfsx_extended)(PREC_TYPE,
                                     TRANS_TYPE,
                                     N,
                                     NRHS,
                                     A,
                                     LDA,
                                     AF,
                                     LDAF,
                                     IPIV,
                                     COLEQU,
                                     C,
                                     B,
                                     LDB,
                                     Y,
                                     LDY,
                                     BERR_OUT,
                                     N_NORMS,
                                     ERRS_N,
                                     ERRS_C,
                                     RES,
                                     AYB,
                                     DY,
                                     Y_TAIL,
                                     RCOND,
                                     ITHRESH,
                                     RTHRESH,
                                     DZ_UB,
                                     IGNORE_CWISE,
                                     INFO);
    */
}

//-- cla_heamv -----------------------------------------------------------------
void
LAPACK_DECL(cla_heamv)(const INTEGER            *UPLO,
                       const INTEGER            *N,
                       const FLOAT              *ALPHA,
                       const FLOAT_COMPLEX      *A,
                       const INTEGER            *LDA,
                       const FLOAT_COMPLEX      *X,
                       const INTEGER            *INCX,
                       const FLOAT              *BETA,
                       FLOAT                    *Y,
                       const INTEGER            *INCY)
{
    DEBUG_LAPACK_STUB("cla_heamv");
    LAPACK_IMPL(cla_heamv)(UPLO,
                           N,
                           ALPHA,
                           A,
                           LDA,
                           X,
                           INCX,
                           BETA,
                           Y,
                           INCY);
}

//-- cla_hercond_c -------------------------------------------------------------
FLOAT
LAPACK_DECL(cla_hercond_c)(const char               *UPLO,
                           const INTEGER            *N,
                           const FLOAT_COMPLEX      *A,
                           const INTEGER            *LDA,
                           const FLOAT_COMPLEX      *AF,
                           const INTEGER            *LDAF,
                           const INTEGER            *IPIV,
                           const FLOAT              *C,
                           const LOGICAL            *CAPPLY,
                           INTEGER                  *INFO,
                           const FLOAT_COMPLEX      *WORK,
                           const FLOAT              *RWORK)
{
    DEBUG_LAPACK_STUB("cla_hercond_c");
    return LAPACK_IMPL(cla_hercond_c)(UPLO,
                                      N,
                                      A,
                                      LDA,
                                      AF,
                                      LDAF,
                                      IPIV,
                                      C,
                                      CAPPLY,
                                      INFO,
                                      WORK,
                                      RWORK);
}

//-- cla_hercond_x -------------------------------------------------------------
FLOAT
LAPACK_DECL(cla_hercond_x)(const char               *UPLO,
                           const INTEGER            *N,
                           const FLOAT_COMPLEX      *A,
                           const INTEGER            *LDA,
                           const FLOAT_COMPLEX      *AF,
                           const INTEGER            *LDAF,
                           const INTEGER            *IPIV,
                           const FLOAT_COMPLEX      *X,
                           INTEGER                  *INFO,
                           const FLOAT_COMPLEX      *WORK,
                           const FLOAT              *RWORK)
{
    DEBUG_LAPACK_STUB("cla_hercond_x");
    return LAPACK_IMPL(cla_hercond_x)(UPLO,
                                      N,
                                      A,
                                      LDA,
                                      AF,
                                      LDAF,
                                      IPIV,
                                      X,
                                      INFO,
                                      WORK,
                                      RWORK);
}

//-- cla_herfsx_extended -------------------------------------------------------
void
LAPACK_DECL(cla_herfsx_extended)(const INTEGER            *PREC_TYPE,
                                 const char               *UPLO,
                                 const INTEGER            *N,
                                 const INTEGER            *NRHS,
                                 const FLOAT_COMPLEX      *A,
                                 const INTEGER            *LDA,
                                 const FLOAT_COMPLEX      *AF,
                                 const INTEGER            *LDAF,
                                 const INTEGER            *IPIV,
                                 const LOGICAL            *COLEQU,
                                 const FLOAT              *C,
                                 const FLOAT_COMPLEX      *B,
                                 const INTEGER            *LDB,
                                 FLOAT_COMPLEX            *Y,
                                 const INTEGER            *LDY,
                                 FLOAT                    *BERR_OUT,
                                 const INTEGER            *N_NORMS,
                                 FLOAT                    *ERR_BNDS_NORM,
                                 FLOAT                    *ERR_BNDS_COMP,
                                 const FLOAT_COMPLEX      *RES,
                                 const FLOAT              *AYB,
                                 const FLOAT_COMPLEX      *DY,
                                 const FLOAT_COMPLEX      *Y_TAIL,
                                 const FLOAT              *RCOND,
                                 const INTEGER            *ITHRESH,
                                 const FLOAT              *RTHRESH,
                                 const FLOAT              *DZ_UB,
                                 const LOGICAL            *IGNORE_CWISE,
                                 INTEGER                  *INFO)
{
    DEBUG_LAPACK_STUB("cla_herfsx_extended");
    ASSERT(0);
    /*
    LAPACK_IMPL(cla_herfsx_extended)(PREC_TYPE,
                                     UPLO,
                                     N,
                                     NRHS,
                                     A,
                                     LDA,
                                     AF,
                                     LDAF,
                                     IPIV,
                                     COLEQU,
                                     C,
                                     B,
                                     LDB,
                                     Y,
                                     LDY,
                                     BERR_OUT,
                                     N_NORMS,
                                     ERR_BNDS_NORM,
                                     ERR_BNDS_COMP,
                                     RES,
                                     AYB,
                                     DY,
                                     Y_TAIL,
                                     RCOND,
                                     ITHRESH,
                                     RTHRESH,
                                     DZ_UB,
                                     IGNORE_CWISE,
                                     INFO);
    */
}

//-- cla_herpvgrw --------------------------------------------------------------
FLOAT
LAPACK_DECL(cla_herpvgrw)(const char               *UPLO,
                          const INTEGER            *N,
                          const INTEGER            *INFO,
                          const FLOAT_COMPLEX      *A,
                          const INTEGER            *LDA,
                          const FLOAT_COMPLEX      *AF,
                          const INTEGER            *LDAF,
                          const INTEGER            *IPIV,
                          const FLOAT              *WORK)
{
    DEBUG_LAPACK_STUB("cla_herpvgrw");
    return LAPACK_IMPL(cla_herpvgrw)(UPLO,
                                     N,
                                     INFO,
                                     A,
                                     LDA,
                                     AF,
                                     LDAF,
                                     IPIV,
                                     WORK);
}

//-- cla_lin_berr --------------------------------------------------------------
void
LAPACK_DECL(cla_lin_berr)(const INTEGER            *N,
                          const INTEGER            *NZ,
                          const INTEGER            *NRHS,
                          const FLOAT_COMPLEX      *RES,
                          const FLOAT              *AYB,
                          FLOAT                    *BERR)
{
    DEBUG_LAPACK_STUB("cla_lin_berr");
    LAPACK_IMPL(cla_lin_berr)(N,
                              NZ,
                              NRHS,
                              RES,
                              AYB,
                              BERR);
}

//-- cla_porcond_c -------------------------------------------------------------
FLOAT
LAPACK_DECL(cla_porcond_c)(const char               *UPLO,
                           const INTEGER            *N,
                           const FLOAT_COMPLEX      *A,
                           const INTEGER            *LDA,
                           const FLOAT_COMPLEX      *AF,
                           const INTEGER            *LDAF,
                           const FLOAT              *C,
                           const LOGICAL            *CAPPLY,
                           INTEGER                  *INFO,
                           const FLOAT_COMPLEX      *WORK,
                           const FLOAT              *RWORK)
{
    DEBUG_LAPACK_STUB("cla_porcond_c");
    return LAPACK_IMPL(cla_porcond_c)(UPLO,
                                      N,
                                      A,
                                      LDA,
                                      AF,
                                      LDAF,
                                      C,
                                      CAPPLY,
                                      INFO,
                                      WORK,
                                      RWORK);
}

//-- cla_porcond_x -------------------------------------------------------------
FLOAT
LAPACK_DECL(cla_porcond_x)(const char               *UPLO,
                           const INTEGER            *N,
                           const FLOAT_COMPLEX      *A,
                           const INTEGER            *LDA,
                           const FLOAT_COMPLEX      *AF,
                           const INTEGER            *LDAF,
                           const FLOAT_COMPLEX      *X,
                           INTEGER                  *INFO,
                           const FLOAT_COMPLEX      *WORK,
                           const FLOAT              *RWORK)
{
    DEBUG_LAPACK_STUB("cla_porcond_x");
    return LAPACK_IMPL(cla_porcond_x)(UPLO,
                                      N,
                                      A,
                                      LDA,
                                      AF,
                                      LDAF,
                                      X,
                                      INFO,
                                      WORK,
                                      RWORK);
}

//-- cla_porfsx_extended -------------------------------------------------------
void
LAPACK_DECL(cla_porfsx_extended)(const INTEGER            *PREC_TYPE,
                                 const char               *UPLO,
                                 const INTEGER            *N,
                                 const INTEGER            *NRHS,
                                 const FLOAT_COMPLEX      *A,
                                 const INTEGER            *LDA,
                                 const FLOAT_COMPLEX      *AF,
                                 const INTEGER            *LDAF,
                                 const LOGICAL            *COLEQU,
                                 const FLOAT              *C,
                                 const FLOAT_COMPLEX      *B,
                                 const INTEGER            *LDB,
                                 FLOAT_COMPLEX            *Y,
                                 const INTEGER            *LDY,
                                 FLOAT                    *BERR_OUT,
                                 const INTEGER            *N_NORMS,
                                 FLOAT                    *ERR_BNDS_NORM,
                                 FLOAT                    *ERR_BNDS_COMP,
                                 const FLOAT_COMPLEX      *RES,
                                 const FLOAT              *AYB,
                                 const FLOAT_COMPLEX      *DY,
                                 const FLOAT_COMPLEX      *Y_TAIL,
                                 const FLOAT              *RCOND,
                                 const INTEGER            *ITHRESH,
                                 const FLOAT              *RTHRESH,
                                 const FLOAT              *DZ_UB,
                                 const LOGICAL            *IGNORE_CWISE,
                                 INTEGER                  *INFO)
{
    DEBUG_LAPACK_STUB("cla_porfsx_extended");
    ASSERT(0);
    /*
    LAPACK_IMPL(cla_porfsx_extended)(PREC_TYPE,
                                     UPLO,
                                     N,
                                     NRHS,
                                     A,
                                     LDA,
                                     AF,
                                     LDAF,
                                     COLEQU,
                                     C,
                                     B,
                                     LDB,
                                     Y,
                                     LDY,
                                     BERR_OUT,
                                     N_NORMS,
                                     ERR_BNDS_NORM,
                                     ERR_BNDS_COMP,
                                     RES,
                                     AYB,
                                     DY,
                                     Y_TAIL,
                                     RCOND,
                                     ITHRESH,
                                     RTHRESH,
                                     DZ_UB,
                                     IGNORE_CWISE,
                                     INFO);
    */
}

//-- cla_porpvgrw --------------------------------------------------------------
FLOAT
LAPACK_DECL(cla_porpvgrw)(const char               *UPLO,
                          const INTEGER            *NCOLS,
                          const FLOAT_COMPLEX      *A,
                          const INTEGER            *LDA,
                          const FLOAT_COMPLEX      *AF,
                          const INTEGER            *LDAF,
                          const FLOAT              *WORK)
{
    DEBUG_LAPACK_STUB("cla_porpvgrw");
    return LAPACK_IMPL(cla_porpvgrw)(UPLO,
                                     NCOLS,
                                     A,
                                     LDA,
                                     AF,
                                     LDAF,
                                     WORK);
}

//-- cla_rpvgrw ----------------------------------------------------------------
FLOAT
LAPACK_DECL(cla_rpvgrw)(const INTEGER        *N,
                        const INTEGER        *NCOLS,
                        const FLOAT_COMPLEX  *A,
                        const INTEGER        *LDA,
                        const FLOAT_COMPLEX  *AF,
                        const INTEGER        *LDAF)
{
    DEBUG_LAPACK_STUB("cla_rpvgrw");
    return LAPACK_IMPL(cla_rpvgrw)(N,
                                   NCOLS,
                                   A,
                                   LDA,
                                   AF,
                                   LDAF);
}

//-- cla_syamv -----------------------------------------------------------------
void
LAPACK_DECL(cla_syamv)(const INTEGER            *UPLO,
                       const INTEGER            *N,
                       const FLOAT              *ALPHA,
                       const FLOAT_COMPLEX      *A,
                       const INTEGER            *LDA,
                       const FLOAT_COMPLEX      *X,
                       const INTEGER            *INCX,
                       const FLOAT              *BETA,
                       FLOAT                    *Y,
                       const INTEGER            *INCY)
{
    DEBUG_LAPACK_STUB("cla_syamv");
    LAPACK_IMPL(cla_syamv)(UPLO,
                           N,
                           ALPHA,
                           A,
                           LDA,
                           X,
                           INCX,
                           BETA,
                           Y,
                           INCY);
}

//-- cla_syrcond_c -------------------------------------------------------------
FLOAT
LAPACK_DECL(cla_syrcond_c)(const char               *UPLO,
                           const INTEGER            *N,
                           const FLOAT_COMPLEX      *A,
                           const INTEGER            *LDA,
                           const FLOAT_COMPLEX      *AF,
                           const INTEGER            *LDAF,
                           const INTEGER            *IPIV,
                           const FLOAT              *C,
                           const LOGICAL            *CAPPLY,
                           INTEGER                  *INFO,
                           const FLOAT_COMPLEX      *WORK,
                           const FLOAT              *RWORK)
{
    DEBUG_LAPACK_STUB("cla_syrcond_c");
    return LAPACK_IMPL(cla_syrcond_c)(UPLO,
                                      N,
                                      A,
                                      LDA,
                                      AF,
                                      LDAF,
                                      IPIV,
                                      C,
                                      CAPPLY,
                                      INFO,
                                      WORK,
                                      RWORK);
}

//-- cla_syrcond_x -------------------------------------------------------------
FLOAT
LAPACK_DECL(cla_syrcond_x)(const char               *UPLO,
                           const INTEGER            *N,
                           const FLOAT_COMPLEX      *A,
                           const INTEGER            *LDA,
                           const FLOAT_COMPLEX      *AF,
                           const INTEGER            *LDAF,
                           const INTEGER            *IPIV,
                           const FLOAT_COMPLEX      *X,
                           INTEGER                  *INFO,
                           const FLOAT_COMPLEX      *WORK,
                           const FLOAT              *RWORK)
{
    DEBUG_LAPACK_STUB("cla_syrcond_x");
    return LAPACK_IMPL(cla_syrcond_x)(UPLO,
                                      N,
                                      A,
                                      LDA,
                                      AF,
                                      LDAF,
                                      IPIV,
                                      X,
                                      INFO,
                                      WORK,
                                      RWORK);
}

//-- cla_syrfsx_extended -------------------------------------------------------
void
LAPACK_DECL(cla_syrfsx_extended)(const INTEGER            *PREC_TYPE,
                                 const char               *UPLO,
                                 const INTEGER            *N,
                                 const INTEGER            *NRHS,
                                 const FLOAT_COMPLEX      *A,
                                 const INTEGER            *LDA,
                                 const FLOAT_COMPLEX      *AF,
                                 const INTEGER            *LDAF,
                                 const INTEGER            *IPIV,
                                 const LOGICAL            *COLEQU,
                                 const FLOAT              *C,
                                 const FLOAT_COMPLEX      *B,
                                 const INTEGER            *LDB,
                                 FLOAT_COMPLEX            *Y,
                                 const INTEGER            *LDY,
                                 FLOAT                    *BERR_OUT,
                                 const INTEGER            *N_NORMS,
                                 FLOAT                    *ERR_BNDS_NORM,
                                 FLOAT                    *ERR_BNDS_COMP,
                                 const FLOAT_COMPLEX      *RES,
                                 const FLOAT              *AYB,
                                 const FLOAT_COMPLEX      *DY,
                                 const FLOAT_COMPLEX      *Y_TAIL,
                                 const FLOAT              *RCOND,
                                 const INTEGER            *ITHRESH,
                                 const FLOAT              *RTHRESH,
                                 const FLOAT              *DZ_UB,
                                 const LOGICAL            *IGNORE_CWISE,
                                 INTEGER                  *INFO)
{
    DEBUG_LAPACK_STUB("cla_syrfsx_extended");
    ASSERT(0);
    /*
    LAPACK_IMPL(cla_syrfsx_extended)(PREC_TYPE,
                                     UPLO,
                                     N,
                                     NRHS,
                                     A,
                                     LDA,
                                     AF,
                                     LDAF,
                                     IPIV,
                                     COLEQU,
                                     C,
                                     B,
                                     LDB,
                                     Y,
                                     LDY,
                                     BERR_OUT,
                                     N_NORMS,
                                     ERR_BNDS_NORM,
                                     ERR_BNDS_COMP,
                                     RES,
                                     AYB,
                                     DY,
                                     Y_TAIL,
                                     RCOND,
                                     ITHRESH,
                                     RTHRESH,
                                     DZ_UB,
                                     IGNORE_CWISE,
                                     INFO);
    */
}

//-- cla_syrpvgrw --------------------------------------------------------------
FLOAT
LAPACK_DECL(cla_syrpvgrw)(const char               *UPLO,
                          const INTEGER            *N,
                          const INTEGER            *INFO,
                          const FLOAT_COMPLEX      *A,
                          const INTEGER            *LDA,
                          const FLOAT_COMPLEX      *AF,
                          const INTEGER            *LDAF,
                          const INTEGER            *IPIV,
                          const FLOAT              *WORK)
{
    DEBUG_LAPACK_STUB("cla_syrpvgrw");
    return LAPACK_IMPL(cla_syrpvgrw)(UPLO,
                                     N,
                                     INFO,
                                     A,
                                     LDA,
                                     AF,
                                     LDAF,
                                     IPIV,
                                     WORK);
}

//-- cla_wwaddw ----------------------------------------------------------------
void
LAPACK_DECL(cla_wwaddw)(const INTEGER        *N,
                        FLOAT_COMPLEX        *X,
                        FLOAT_COMPLEX        *Y,
                        const FLOAT_COMPLEX  *W)
{
    DEBUG_LAPACK_STUB("cla_wwaddw");
    LAPACK_IMPL(cla_wwaddw)(N,
                            X,
                            Y,
                            W);
}

//-- clabrd --------------------------------------------------------------------
void
LAPACK_DECL(clabrd)(const INTEGER    *M,
                    const INTEGER    *N,
                    const INTEGER    *NB,
                    FLOAT_COMPLEX    *A,
                    const INTEGER    *LDA,
                    FLOAT            *D,
                    FLOAT            *E,
                    FLOAT_COMPLEX    *TAUQ,
                    FLOAT_COMPLEX    *TAUP,
                    FLOAT_COMPLEX    *X,
                    const INTEGER    *LDX,
                    FLOAT_COMPLEX    *Y,
                    const INTEGER    *LDY)
{
    DEBUG_LAPACK_STUB("clabrd");
    LAPACK_IMPL(clabrd)(M,
                        N,
                        NB,
                        A,
                        LDA,
                        D,
                        E,
                        TAUQ,
                        TAUP,
                        X,
                        LDX,
                        Y,
                        LDY);
}

//-- clacgv --------------------------------------------------------------------
void
LAPACK_DECL(clacgv)(const INTEGER    *N,
                    FLOAT_COMPLEX    *X,
                    const INTEGER    *INCX)
{
    DEBUG_LAPACK_STUB("clacgv");
    LAPACK_IMPL(clacgv)(N,
                        X,
                        INCX);
}

//-- clacn2 --------------------------------------------------------------------
void
LAPACK_DECL(clacn2)(const INTEGER    *N,
                    FLOAT_COMPLEX    *V,
                    FLOAT_COMPLEX    *X,
                    FLOAT            *EST,
                    INTEGER          *KASE,
                    INTEGER          *ISAVE)
{
    DEBUG_LAPACK_STUB("clacn2");
    LAPACK_IMPL(clacn2)(N,
                        V,
                        X,
                        EST,
                        KASE,
                        ISAVE);
}

//-- clacon --------------------------------------------------------------------
void
LAPACK_DECL(clacon)(const INTEGER    *N,
                    FLOAT_COMPLEX    *V,
                    FLOAT_COMPLEX    *X,
                    FLOAT            *EST,
                    INTEGER          *KASE)
{
    DEBUG_LAPACK_STUB("clacon");
    LAPACK_IMPL(clacon)(N,
                        V,
                        X,
                        EST,
                        KASE);
}

//-- clacp2 --------------------------------------------------------------------
void
LAPACK_DECL(clacp2)(const char       *UPLO,
                    const INTEGER    *M,
                    const INTEGER    *N,
                    const FLOAT      *A,
                    const INTEGER    *LDA,
                    FLOAT_COMPLEX    *B,
                    const INTEGER    *LDB)
{
    DEBUG_LAPACK_STUB("clacp2");
    LAPACK_IMPL(clacp2)(UPLO,
                        M,
                        N,
                        A,
                        LDA,
                        B,
                        LDB);
}

//-- clacpy --------------------------------------------------------------------
void
LAPACK_DECL(clacpy)(const char           *UPLO,
                    const INTEGER        *M,
                    const INTEGER        *N,
                    const FLOAT_COMPLEX  *A,
                    const INTEGER        *LDA,
                    FLOAT_COMPLEX        *B,
                    const INTEGER        *LDB)
{
    DEBUG_LAPACK_STUB("clacpy");
    LAPACK_IMPL(clacpy)(UPLO,
                        M,
                        N,
                        A,
                        LDA,
                        B,
                        LDB);
}

//-- clacrm --------------------------------------------------------------------
void
LAPACK_DECL(clacrm)(const INTEGER        *M,
                    const INTEGER        *N,
                    const FLOAT_COMPLEX  *A,
                    const INTEGER        *LDA,
                    const FLOAT          *B,
                    const INTEGER        *LDB,
                    const FLOAT_COMPLEX  *C,
                    const INTEGER        *LDC,
                    FLOAT                *RWORK)
{
    DEBUG_LAPACK_STUB("clacrm");
    LAPACK_IMPL(clacrm)(M,
                        N,
                        A,
                        LDA,
                        B,
                        LDB,
                        C,
                        LDC,
                        RWORK);
}

//-- clacrt --------------------------------------------------------------------
void
LAPACK_DECL(clacrt)(const INTEGER        *N,
                    FLOAT_COMPLEX        *CX,
                    const INTEGER        *INCX,
                    FLOAT_COMPLEX        *CY,
                    const INTEGER        *INCY,
                    const FLOAT_COMPLEX  *C,
                    const FLOAT_COMPLEX  *S)
{
    DEBUG_LAPACK_STUB("clacrt");
    LAPACK_IMPL(clacrt)(N,
                        CX,
                        INCX,
                        CY,
                        INCY,
                        C,
                        S);
}

//-- cladiv --------------------------------------------------------------------
UNKNOWN
LAPACK_DECL(cladiv)(const FLOAT_COMPLEX  *X,
                    const FLOAT_COMPLEX  *Y)
{
    DEBUG_LAPACK_STUB("cladiv");
    return LAPACK_IMPL(cladiv)(X,
                               Y);
}

//-- claed0 --------------------------------------------------------------------
void
LAPACK_DECL(claed0)(const INTEGER    *QSIZ,
                    const INTEGER    *N,
                    FLOAT            *D,
                    FLOAT            *E,
                    FLOAT_COMPLEX    *Q,
                    const INTEGER    *LDQ,
                    FLOAT_COMPLEX    *QSTORE,
                    const INTEGER    *LDQS,
                    FLOAT            *RWORK,
                    INTEGER          *IWORK,
                    INTEGER          *INFO)
{
    DEBUG_LAPACK_STUB("claed0");
    LAPACK_IMPL(claed0)(QSIZ,
                        N,
                        D,
                        E,
                        Q,
                        LDQ,
                        QSTORE,
                        LDQS,
                        RWORK,
                        IWORK,
                        INFO);
}

//-- claed7 --------------------------------------------------------------------
void
LAPACK_DECL(claed7)(const INTEGER    *N,
                    const INTEGER    *CUTPNT,
                    const INTEGER    *QSIZ,
                    const INTEGER    *TLVLS,
                    const INTEGER    *CURLVL,
                    const INTEGER    *CURPBM,
                    FLOAT            *D,
                    FLOAT_COMPLEX    *Q,
                    const INTEGER    *LDQ,
                    const FLOAT      *RHO,
                    INTEGER          *INDXQ,
                    FLOAT            *QSTORE,
                    INTEGER          *QPTR,
                    const INTEGER    *PRMPTR,
                    const INTEGER    *PERM,
                    const INTEGER    *GIVPTR,
                    const INTEGER    *GIVCOL,
                    const FLOAT      *GIVNUM,
                    FLOAT_COMPLEX    *WORK,
                    FLOAT            *RWORK,
                    INTEGER          *IWORK,
                    INTEGER          *INFO)
{
    DEBUG_LAPACK_STUB("claed7");
    LAPACK_IMPL(claed7)(N,
                        CUTPNT,
                        QSIZ,
                        TLVLS,
                        CURLVL,
                        CURPBM,
                        D,
                        Q,
                        LDQ,
                        RHO,
                        INDXQ,
                        QSTORE,
                        QPTR,
                        PRMPTR,
                        PERM,
                        GIVPTR,
                        GIVCOL,
                        GIVNUM,
                        WORK,
                        RWORK,
                        IWORK,
                        INFO);
}

//-- claed8 --------------------------------------------------------------------
void
LAPACK_DECL(claed8)(INTEGER          *K,
                    const INTEGER    *N,
                    const INTEGER    *QSIZ,
                    FLOAT_COMPLEX    *Q,
                    const INTEGER    *LDQ,
                    FLOAT            *D,
                    FLOAT            *RHO,
                    const INTEGER    *CUTPNT,
                    const FLOAT      *Z,
                    FLOAT            *DLAMDA,
                    FLOAT_COMPLEX    *Q2,
                    const INTEGER    *LDQ2,
                    FLOAT            *W,
                    INTEGER          *INDXP,
                    INTEGER          *INDX,
                    const INTEGER    *INDXQ,
                    INTEGER          *PERM,
                    INTEGER          *GIVPTR,
                    INTEGER          *GIVCOL,
                    FLOAT            *GIVNUM,
                    INTEGER          *INFO)
{
    DEBUG_LAPACK_STUB("claed8");
    LAPACK_IMPL(claed8)(K,
                        N,
                        QSIZ,
                        Q,
                        LDQ,
                        D,
                        RHO,
                        CUTPNT,
                        Z,
                        DLAMDA,
                        Q2,
                        LDQ2,
                        W,
                        INDXP,
                        INDX,
                        INDXQ,
                        PERM,
                        GIVPTR,
                        GIVCOL,
                        GIVNUM,
                        INFO);
}

//-- claein --------------------------------------------------------------------
void
LAPACK_DECL(claein)(const LOGICAL        *RIGHTV,
                    const LOGICAL        *NOINIT,
                    const INTEGER        *N,
                    const FLOAT_COMPLEX  *H,
                    const INTEGER        *LDH,
                    const FLOAT_COMPLEX  *W,
                    FLOAT_COMPLEX        *V,
                    FLOAT_COMPLEX        *B,
                    const INTEGER        *LDB,
                    FLOAT                *RWORK,
                    const FLOAT          *EPS3,
                    const FLOAT          *SMLNUM,
                    INTEGER              *INFO)
{
    DEBUG_LAPACK_STUB("claein");
    LAPACK_IMPL(claein)(RIGHTV,
                        NOINIT,
                        N,
                        H,
                        LDH,
                        W,
                        V,
                        B,
                        LDB,
                        RWORK,
                        EPS3,
                        SMLNUM,
                        INFO);
}

//-- claesy --------------------------------------------------------------------
void
LAPACK_DECL(claesy)(const FLOAT_COMPLEX  *A,
                    const FLOAT_COMPLEX  *B,
                    const FLOAT_COMPLEX  *C,
                    FLOAT_COMPLEX        *RT1,
                    FLOAT_COMPLEX        *RT2,
                    FLOAT_COMPLEX        *EVSCAL,
                    FLOAT_COMPLEX        *CS1,
                    FLOAT_COMPLEX        *SN1)
{
    DEBUG_LAPACK_STUB("claesy");
    LAPACK_IMPL(claesy)(A,
                        B,
                        C,
                        RT1,
                        RT2,
                        EVSCAL,
                        CS1,
                        SN1);
}

//-- claev2 --------------------------------------------------------------------
void
LAPACK_DECL(claev2)(const FLOAT_COMPLEX  *A,
                    const FLOAT_COMPLEX  *B,
                    const FLOAT_COMPLEX  *C,
                    FLOAT                *RT1,
                    FLOAT                *RT2,
                    FLOAT                *CS1,
                    FLOAT_COMPLEX        *SN1)
{
    DEBUG_LAPACK_STUB("claev2");
    LAPACK_IMPL(claev2)(A,
                        B,
                        C,
                        RT1,
                        RT2,
                        CS1,
                        SN1);
}

//-- clag2z --------------------------------------------------------------------
void
LAPACK_DECL(clag2z)(const INTEGER        *M,
                    const INTEGER        *N,
                    const FLOAT_COMPLEX  *SA,
                    const INTEGER        *LDSA,
                    DOUBLE_COMPLEX       *A,
                    const INTEGER        *LDA,
                    INTEGER              *INFO)
{
    DEBUG_LAPACK_STUB("clag2z");
    LAPACK_IMPL(clag2z)(M,
                        N,
                        SA,
                        LDSA,
                        A,
                        LDA,
                        INFO);
}

//-- clags2 --------------------------------------------------------------------
void
LAPACK_DECL(clags2)(const LOGICAL        *UPPER,
                    const FLOAT          *A1,
                    const FLOAT_COMPLEX  *A2,
                    const FLOAT          *A3,
                    const FLOAT          *B1,
                    const FLOAT_COMPLEX  *B2,
                    const FLOAT          *B3,
                    FLOAT                *CSU,
                    FLOAT_COMPLEX        *SNU,
                    FLOAT                *CSV,
                    FLOAT_COMPLEX        *SNV,
                    FLOAT                *CSQ,
                    FLOAT_COMPLEX        *SNQ)
{
    DEBUG_LAPACK_STUB("clags2");
    LAPACK_IMPL(clags2)(UPPER,
                        A1,
                        A2,
                        A3,
                        B1,
                        B2,
                        B3,
                        CSU,
                        SNU,
                        CSV,
                        SNV,
                        CSQ,
                        SNQ);
}

//-- clagtm --------------------------------------------------------------------
void
LAPACK_DECL(clagtm)(const char           *TRANS,
                    const INTEGER        *N,
                    const INTEGER        *NRHS,
                    const FLOAT          *ALPHA,
                    const FLOAT_COMPLEX  *DL,
                    const FLOAT_COMPLEX  *D,
                    const FLOAT_COMPLEX  *DU,
                    const FLOAT_COMPLEX  *X,
                    const INTEGER        *LDX,
                    const FLOAT          *BETA,
                    FLOAT_COMPLEX        *B,
                    const INTEGER        *LDB)
{
    DEBUG_LAPACK_STUB("clagtm");
    LAPACK_IMPL(clagtm)(TRANS,
                        N,
                        NRHS,
                        ALPHA,
                        DL,
                        D,
                        DU,
                        X,
                        LDX,
                        BETA,
                        B,
                        LDB);
}

//-- clahef --------------------------------------------------------------------
void
LAPACK_DECL(clahef)(const char       *UPLO,
                    const INTEGER    *N,
                    const INTEGER    *NB,
                    INTEGER          *KB,
                    FLOAT_COMPLEX    *A,
                    const INTEGER    *LDA,
                    INTEGER          *IPIV,
                    FLOAT_COMPLEX    *W,
                    const INTEGER    *LDW,
                    INTEGER          *INFO)
{
    DEBUG_LAPACK_STUB("clahef");
    LAPACK_IMPL(clahef)(UPLO,
                        N,
                        NB,
                        KB,
                        A,
                        LDA,
                        IPIV,
                        W,
                        LDW,
                        INFO);
}

//-- clahqr --------------------------------------------------------------------
void
LAPACK_DECL(clahqr)(const LOGICAL    *WANTT,
                    const LOGICAL    *WANTZ,
                    const INTEGER    *N,
                    const INTEGER    *ILO,
                    const INTEGER    *IHI,
                    FLOAT_COMPLEX    *H,
                    const INTEGER    *LDH,
                    FLOAT_COMPLEX    *W,
                    const INTEGER    *ILOZ,
                    const INTEGER    *IHIZ,
                    FLOAT_COMPLEX    *Z,
                    const INTEGER    *LDZ,
                    INTEGER          *INFO)
{
    DEBUG_LAPACK_STUB("clahqr");
    LAPACK_IMPL(clahqr)(WANTT,
                        WANTZ,
                        N,
                        ILO,
                        IHI,
                        H,
                        LDH,
                        W,
                        ILOZ,
                        IHIZ,
                        Z,
                        LDZ,
                        INFO);
}

//-- clahr2 --------------------------------------------------------------------
void
LAPACK_DECL(clahr2)(const INTEGER    *N,
                    const INTEGER    *K,
                    const INTEGER    *NB,
                    FLOAT_COMPLEX    *A,
                    const INTEGER    *LDA,
                    FLOAT_COMPLEX    *TAU,
                    FLOAT_COMPLEX    *T,
                    const INTEGER    *LDT,
                    FLOAT_COMPLEX    *Y,
                    const INTEGER    *LDY)
{
    DEBUG_LAPACK_STUB("clahr2");
    LAPACK_IMPL(clahr2)(N,
                        K,
                        NB,
                        A,
                        LDA,
                        TAU,
                        T,
                        LDT,
                        Y,
                        LDY);
}

//-- clahrd --------------------------------------------------------------------
void
LAPACK_DECL(clahrd)(const INTEGER    *N,
                    const INTEGER    *K,
                    const INTEGER    *NB,
                    FLOAT_COMPLEX    *A,
                    const INTEGER    *LDA,
                    FLOAT_COMPLEX    *TAU,
                    FLOAT_COMPLEX    *T,
                    const INTEGER    *LDT,
                    FLOAT_COMPLEX    *Y,
                    const INTEGER    *LDY)
{
    DEBUG_LAPACK_STUB("clahrd");
    LAPACK_IMPL(clahrd)(N,
                        K,
                        NB,
                        A,
                        LDA,
                        TAU,
                        T,
                        LDT,
                        Y,
                        LDY);
}

//-- claic1 --------------------------------------------------------------------
void
LAPACK_DECL(claic1)(const INTEGER        *JOB,
                    const INTEGER        *J,
                    const FLOAT_COMPLEX  *X,
                    const FLOAT          *SEST,
                    const FLOAT_COMPLEX  *W,
                    const FLOAT_COMPLEX  *GAMMA,
                    FLOAT                *SESTPR,
                    FLOAT_COMPLEX        *S,
                    FLOAT_COMPLEX        *C)
{
    DEBUG_LAPACK_STUB("claic1");
    LAPACK_IMPL(claic1)(JOB,
                        J,
                        X,
                        SEST,
                        W,
                        GAMMA,
                        SESTPR,
                        S,
                        C);
}

//-- clals0 --------------------------------------------------------------------
void
LAPACK_DECL(clals0)(const INTEGER    *ICOMPQ,
                    const INTEGER    *NL,
                    const INTEGER    *NR,
                    const INTEGER    *SQRE,
                    const INTEGER    *NRHS,
                    FLOAT_COMPLEX    *B,
                    const INTEGER    *LDB,
                    FLOAT_COMPLEX    *BX,
                    const INTEGER    *LDBX,
                    const INTEGER    *PERM,
                    const INTEGER    *GIVPTR,
                    const INTEGER    *GIVCOL,
                    const INTEGER    *LDGCOL,
                    const FLOAT      *GIVNUM,
                    const INTEGER    *LDGNUM,
                    const FLOAT      *POLES,
                    const FLOAT      *DIFL,
                    const FLOAT      *DIFR,
                    const FLOAT      *Z,
                    const INTEGER    *K,
                    const FLOAT      *C,
                    const FLOAT      *S,
                    FLOAT            *RWORK,
                    INTEGER          *INFO)
{
    DEBUG_LAPACK_STUB("clals0");
    LAPACK_IMPL(clals0)(ICOMPQ,
                        NL,
                        NR,
                        SQRE,
                        NRHS,
                        B,
                        LDB,
                        BX,
                        LDBX,
                        PERM,
                        GIVPTR,
                        GIVCOL,
                        LDGCOL,
                        GIVNUM,
                        LDGNUM,
                        POLES,
                        DIFL,
                        DIFR,
                        Z,
                        K,
                        C,
                        S,
                        RWORK,
                        INFO);
}

//-- clalsa --------------------------------------------------------------------
void
LAPACK_DECL(clalsa)(const INTEGER    *ICOMPQ,
                    const INTEGER    *SMLSIZ,
                    const INTEGER    *N,
                    const INTEGER    *NRHS,
                    FLOAT_COMPLEX    *B,
                    const INTEGER    *LDB,
                    FLOAT_COMPLEX    *BX,
                    const INTEGER    *LDBX,
                    const FLOAT      *U,
                    const INTEGER    *LDU,
                    const FLOAT      *VT,
                    const INTEGER    *K,
                    const FLOAT      *DIFL,
                    const FLOAT      *DIFR,
                    const FLOAT      *Z,
                    const FLOAT      *POLES,
                    const INTEGER    *GIVPTR,
                    const INTEGER    *GIVCOL,
                    const INTEGER    *LDGCOL,
                    const INTEGER    *PERM,
                    const FLOAT      *GIVNUM,
                    const FLOAT      *C,
                    const FLOAT      *S,
                    FLOAT            *RWORK,
                    INTEGER          *IWORK,
                    INTEGER          *INFO)
{
    DEBUG_LAPACK_STUB("clalsa");
    LAPACK_IMPL(clalsa)(ICOMPQ,
                        SMLSIZ,
                        N,
                        NRHS,
                        B,
                        LDB,
                        BX,
                        LDBX,
                        U,
                        LDU,
                        VT,
                        K,
                        DIFL,
                        DIFR,
                        Z,
                        POLES,
                        GIVPTR,
                        GIVCOL,
                        LDGCOL,
                        PERM,
                        GIVNUM,
                        C,
                        S,
                        RWORK,
                        IWORK,
                        INFO);
}

//-- clalsd --------------------------------------------------------------------
void
LAPACK_DECL(clalsd)(const char       *UPLO,
                    const INTEGER    *SMLSIZ,
                    const INTEGER    *N,
                    const INTEGER    *NRHS,
                    FLOAT            *D,
                    FLOAT            *E,
                    FLOAT_COMPLEX    *B,
                    const INTEGER    *LDB,
                    const FLOAT      *RCOND,
                    INTEGER          *RANK,
                    FLOAT_COMPLEX    *WORK,
                    FLOAT            *RWORK,
                    INTEGER          *IWORK,
                    INTEGER          *INFO)
{
    DEBUG_LAPACK_STUB("clalsd");
    LAPACK_IMPL(clalsd)(UPLO,
                        SMLSIZ,
                        N,
                        NRHS,
                        D,
                        E,
                        B,
                        LDB,
                        RCOND,
                        RANK,
                        WORK,
                        RWORK,
                        IWORK,
                        INFO);
}

//-- clangb --------------------------------------------------------------------
FLOAT
LAPACK_DECL(clangb)(const char           *NORM,
                    const INTEGER        *N,
                    const INTEGER        *KL,
                    const INTEGER        *KU,
                    const FLOAT_COMPLEX  *AB,
                    const INTEGER        *LDAB,
                    FLOAT                *WORK)
{
    DEBUG_LAPACK_STUB("clangb");
    return LAPACK_IMPL(clangb)(NORM,
                               N,
                               KL,
                               KU,
                               AB,
                               LDAB,
                               WORK);
}

//-- clange --------------------------------------------------------------------
FLOAT
LAPACK_DECL(clange)(const char           *NORM,
                    const INTEGER        *M,
                    const INTEGER        *N,
                    const FLOAT_COMPLEX  *A,
                    const INTEGER        *LDA,
                    FLOAT                *WORK)
{
    DEBUG_LAPACK_STUB("clange");
    return LAPACK_IMPL(clange)(NORM,
                               M,
                               N,
                               A,
                               LDA,
                               WORK);
}

//-- clangt --------------------------------------------------------------------
FLOAT
LAPACK_DECL(clangt)(const char           *NORM,
                    const INTEGER        *N,
                    const FLOAT_COMPLEX  *DL,
                    const FLOAT_COMPLEX  *D,
                    const FLOAT_COMPLEX  *DU)
{
    DEBUG_LAPACK_STUB("clangt");
    return LAPACK_IMPL(clangt)(NORM,
                               N,
                               DL,
                               D,
                               DU);
}

//-- clanhb --------------------------------------------------------------------
FLOAT
LAPACK_DECL(clanhb)(const char           *NORM,
                    const char           *UPLO,
                    const INTEGER        *N,
                    const INTEGER        *K,
                    const FLOAT_COMPLEX  *AB,
                    const INTEGER        *LDAB,
                    FLOAT                *WORK)
{
    DEBUG_LAPACK_STUB("clanhb");
    return LAPACK_IMPL(clanhb)(NORM,
                               UPLO,
                               N,
                               K,
                               AB,
                               LDAB,
                               WORK);
}

//-- clanhe --------------------------------------------------------------------
FLOAT
LAPACK_DECL(clanhe)(const char           *NORM,
                    const char           *UPLO,
                    const INTEGER        *N,
                    const FLOAT_COMPLEX  *A,
                    const INTEGER        *LDA,
                    FLOAT                *WORK)
{
    DEBUG_LAPACK_STUB("clanhe");
    return LAPACK_IMPL(clanhe)(NORM,
                               UPLO,
                               N,
                               A,
                               LDA,
                               WORK);
}

//-- clanhf --------------------------------------------------------------------
FLOAT
LAPACK_DECL(clanhf)(const char           *NORM,
                    const char           *TRANSR,
                    const char           *UPLO,
                    const INTEGER        *N,
                    const FLOAT_COMPLEX  *A,
                    FLOAT                *WORK)
{
    DEBUG_LAPACK_STUB("clanhf");
    return LAPACK_IMPL(clanhf)(NORM,
                               TRANSR,
                               UPLO,
                               N,
                               A,
                               WORK);
}

//-- clanhp --------------------------------------------------------------------
FLOAT
LAPACK_DECL(clanhp)(const char           *NORM,
                    const char           *UPLO,
                    const INTEGER        *N,
                    const FLOAT_COMPLEX  *AP,
                    FLOAT                *WORK)
{
    DEBUG_LAPACK_STUB("clanhp");
    return LAPACK_IMPL(clanhp)(NORM,
                               UPLO,
                               N,
                               AP,
                               WORK);
}

//-- clanhs --------------------------------------------------------------------
FLOAT
LAPACK_DECL(clanhs)(const char           *NORM,
                    const INTEGER        *N,
                    const FLOAT_COMPLEX  *A,
                    const INTEGER        *LDA,
                    FLOAT                *WORK)
{
    DEBUG_LAPACK_STUB("clanhs");
    return LAPACK_IMPL(clanhs)(NORM,
                               N,
                               A,
                               LDA,
                               WORK);
}

//-- clanht --------------------------------------------------------------------
FLOAT
LAPACK_DECL(clanht)(const char           *NORM,
                    const INTEGER        *N,
                    const FLOAT          *D,
                    const FLOAT_COMPLEX  *E)
{
    DEBUG_LAPACK_STUB("clanht");
    return LAPACK_IMPL(clanht)(NORM,
                               N,
                               D,
                               E);
}

//-- clansb --------------------------------------------------------------------
FLOAT
LAPACK_DECL(clansb)(const char           *NORM,
                    const char           *UPLO,
                    const INTEGER        *N,
                    const INTEGER        *K,
                    const FLOAT_COMPLEX  *AB,
                    const INTEGER        *LDAB,
                    FLOAT                *WORK)
{
    DEBUG_LAPACK_STUB("clansb");
    return LAPACK_IMPL(clansb)(NORM,
                               UPLO,
                               N,
                               K,
                               AB,
                               LDAB,
                               WORK);
}

//-- clansp --------------------------------------------------------------------
FLOAT
LAPACK_DECL(clansp)(const char           *NORM,
                    const char           *UPLO,
                    const INTEGER        *N,
                    const FLOAT_COMPLEX  *AP,
                    FLOAT                *WORK)
{
    DEBUG_LAPACK_STUB("clansp");
    return LAPACK_IMPL(clansp)(NORM,
                               UPLO,
                               N,
                               AP,
                               WORK);
}

//-- clansy --------------------------------------------------------------------
FLOAT
LAPACK_DECL(clansy)(const char           *NORM,
                    const char           *UPLO,
                    const INTEGER        *N,
                    const FLOAT_COMPLEX  *A,
                    const INTEGER        *LDA,
                    FLOAT                *WORK)
{
    DEBUG_LAPACK_STUB("clansy");
    return LAPACK_IMPL(clansy)(NORM,
                               UPLO,
                               N,
                               A,
                               LDA,
                               WORK);
}

//-- clantb --------------------------------------------------------------------
FLOAT
LAPACK_DECL(clantb)(const char           *NORM,
                    const char           *UPLO,
                    const char           *DIAG,
                    const INTEGER        *N,
                    const INTEGER        *K,
                    const FLOAT_COMPLEX  *AB,
                    const INTEGER        *LDAB,
                    FLOAT                *WORK)
{
    DEBUG_LAPACK_STUB("clantb");
    return LAPACK_IMPL(clantb)(NORM,
                               UPLO,
                               DIAG,
                               N,
                               K,
                               AB,
                               LDAB,
                               WORK);
}

//-- clantp --------------------------------------------------------------------
FLOAT
LAPACK_DECL(clantp)(const char           *NORM,
                    const char           *UPLO,
                    const char           *DIAG,
                    const INTEGER        *N,
                    const FLOAT_COMPLEX  *AP,
                    FLOAT                *WORK)
{
    DEBUG_LAPACK_STUB("clantp");
    return LAPACK_IMPL(clantp)(NORM,
                               UPLO,
                               DIAG,
                               N,
                               AP,
                               WORK);
}

//-- clantr --------------------------------------------------------------------
FLOAT
LAPACK_DECL(clantr)(const char           *NORM,
                    const char           *UPLO,
                    const char           *DIAG,
                    const INTEGER        *M,
                    const INTEGER        *N,
                    const FLOAT_COMPLEX  *A,
                    const INTEGER        *LDA,
                    FLOAT                *WORK)
{
    DEBUG_LAPACK_STUB("clantr");
    return LAPACK_IMPL(clantr)(NORM,
                               UPLO,
                               DIAG,
                               M,
                               N,
                               A,
                               LDA,
                               WORK);
}

//-- clapll --------------------------------------------------------------------
void
LAPACK_DECL(clapll)(const INTEGER    *N,
                    FLOAT_COMPLEX    *X,
                    const INTEGER    *INCX,
                    FLOAT_COMPLEX    *Y,
                    const INTEGER    *INCY,
                    FLOAT            *SSMIN)
{
    DEBUG_LAPACK_STUB("clapll");
    LAPACK_IMPL(clapll)(N,
                        X,
                        INCX,
                        Y,
                        INCY,
                        SSMIN);
}

//-- clapmr --------------------------------------------------------------------
void
LAPACK_DECL(clapmr)(const LOGICAL    *FORWRD,
                    const INTEGER    *M,
                    const INTEGER    *N,
                    FLOAT_COMPLEX    *X,
                    const INTEGER    *LDX,
                    INTEGER          *K)
{
    DEBUG_LAPACK_STUB("clapmr");
    LAPACK_IMPL(clapmr)(FORWRD,
                        M,
                        N,
                        X,
                        LDX,
                        K);
}

//-- clapmt --------------------------------------------------------------------
void
LAPACK_DECL(clapmt)(const LOGICAL    *FORWRD,
                    const INTEGER    *M,
                    const INTEGER    *N,
                    FLOAT_COMPLEX    *X,
                    const INTEGER    *LDX,
                    INTEGER          *K)
{
    DEBUG_LAPACK_STUB("clapmt");
    LAPACK_IMPL(clapmt)(FORWRD,
                        M,
                        N,
                        X,
                        LDX,
                        K);
}

//-- claqgb --------------------------------------------------------------------
void
LAPACK_DECL(claqgb)(const INTEGER    *M,
                    const INTEGER    *N,
                    const INTEGER    *KL,
                    const INTEGER    *KU,
                    FLOAT_COMPLEX    *AB,
                    const INTEGER    *LDAB,
                    const FLOAT      *R,
                    const FLOAT      *C,
                    const FLOAT      *ROWCND,
                    const FLOAT      *COLCND,
                    const FLOAT      *AMAX,
                    char             *EQUED)
{
    DEBUG_LAPACK_STUB("claqgb");
    LAPACK_IMPL(claqgb)(M,
                        N,
                        KL,
                        KU,
                        AB,
                        LDAB,
                        R,
                        C,
                        ROWCND,
                        COLCND,
                        AMAX,
                        EQUED);
}

//-- claqge --------------------------------------------------------------------
void
LAPACK_DECL(claqge)(const INTEGER    *M,
                    const INTEGER    *N,
                    FLOAT_COMPLEX    *A,
                    const INTEGER    *LDA,
                    const FLOAT      *R,
                    const FLOAT      *C,
                    const FLOAT      *ROWCND,
                    const FLOAT      *COLCND,
                    const FLOAT      *AMAX,
                    char             *EQUED)
{
    DEBUG_LAPACK_STUB("claqge");
    LAPACK_IMPL(claqge)(M,
                        N,
                        A,
                        LDA,
                        R,
                        C,
                        ROWCND,
                        COLCND,
                        AMAX,
                        EQUED);
}

//-- claqhb --------------------------------------------------------------------
void
LAPACK_DECL(claqhb)(const char       *UPLO,
                    const INTEGER    *N,
                    const INTEGER    *KD,
                    FLOAT_COMPLEX    *AB,
                    const INTEGER    *LDAB,
                    FLOAT            *S,
                    const FLOAT      *SCOND,
                    const FLOAT      *AMAX,
                    char             *EQUED)
{
    DEBUG_LAPACK_STUB("claqhb");
    LAPACK_IMPL(claqhb)(UPLO,
                        N,
                        KD,
                        AB,
                        LDAB,
                        S,
                        SCOND,
                        AMAX,
                        EQUED);
}

//-- claqhe --------------------------------------------------------------------
void
LAPACK_DECL(claqhe)(const char       *UPLO,
                    const INTEGER    *N,
                    FLOAT_COMPLEX    *A,
                    const INTEGER    *LDA,
                    const FLOAT      *S,
                    const FLOAT      *SCOND,
                    const FLOAT      *AMAX,
                    char             *EQUED)
{
    DEBUG_LAPACK_STUB("claqhe");
    LAPACK_IMPL(claqhe)(UPLO,
                        N,
                        A,
                        LDA,
                        S,
                        SCOND,
                        AMAX,
                        EQUED);
}

//-- claqhp --------------------------------------------------------------------
void
LAPACK_DECL(claqhp)(const char       *UPLO,
                    const INTEGER    *N,
                    FLOAT_COMPLEX    *AP,
                    const FLOAT      *S,
                    const FLOAT      *SCOND,
                    const FLOAT      *AMAX,
                    char             *EQUED)
{
    DEBUG_LAPACK_STUB("claqhp");
    LAPACK_IMPL(claqhp)(UPLO,
                        N,
                        AP,
                        S,
                        SCOND,
                        AMAX,
                        EQUED);
}

//-- claqp2 --------------------------------------------------------------------
void
LAPACK_DECL(claqp2)(const INTEGER    *M,
                    const INTEGER    *N,
                    const INTEGER    *OFFSET,
                    FLOAT_COMPLEX    *A,
                    const INTEGER    *LDA,
                    INTEGER          *JPVT,
                    FLOAT_COMPLEX    *TAU,
                    FLOAT            *VN1,
                    FLOAT            *VN2,
                    FLOAT_COMPLEX    *WORK)
{
    DEBUG_LAPACK_STUB("claqp2");
    LAPACK_IMPL(claqp2)(M,
                        N,
                        OFFSET,
                        A,
                        LDA,
                        JPVT,
                        TAU,
                        VN1,
                        VN2,
                        WORK);
}

//-- claqps --------------------------------------------------------------------
void
LAPACK_DECL(claqps)(const INTEGER    *M,
                    const INTEGER    *N,
                    const INTEGER    *OFFSET,
                    const INTEGER    *NB,
                    INTEGER          *KB,
                    FLOAT_COMPLEX    *A,
                    const INTEGER    *LDA,
                    INTEGER          *JPVT,
                    FLOAT_COMPLEX    *TAU,
                    FLOAT            *VN1,
                    FLOAT            *VN2,
                    FLOAT_COMPLEX    *AUXV,
                    FLOAT_COMPLEX    *F,
                    const INTEGER    *LDF)
{
    DEBUG_LAPACK_STUB("claqps");
    LAPACK_IMPL(claqps)(M,
                        N,
                        OFFSET,
                        NB,
                        KB,
                        A,
                        LDA,
                        JPVT,
                        TAU,
                        VN1,
                        VN2,
                        AUXV,
                        F,
                        LDF);
}

//-- claqr0 --------------------------------------------------------------------
void
LAPACK_DECL(claqr0)(const LOGICAL    *WANTT,
                    const LOGICAL    *WANTZ,
                    const INTEGER    *N,
                    const INTEGER    *ILO,
                    const INTEGER    *IHI,
                    FLOAT_COMPLEX    *H,
                    const INTEGER    *LDH,
                    FLOAT_COMPLEX    *W,
                    const INTEGER    *ILOZ,
                    const INTEGER    *IHIZ,
                    FLOAT_COMPLEX    *Z,
                    const INTEGER    *LDZ,
                    FLOAT_COMPLEX    *WORK,
                    const INTEGER    *LWORK,
                    INTEGER          *INFO)
{
    DEBUG_LAPACK_STUB("claqr0");
    LAPACK_IMPL(claqr0)(WANTT,
                        WANTZ,
                        N,
                        ILO,
                        IHI,
                        H,
                        LDH,
                        W,
                        ILOZ,
                        IHIZ,
                        Z,
                        LDZ,
                        WORK,
                        LWORK,
                        INFO);
}

//-- claqr1 --------------------------------------------------------------------
void
LAPACK_DECL(claqr1)(const INTEGER        *N,
                    const FLOAT_COMPLEX  *H,
                    const INTEGER        *LDH,
                    const FLOAT_COMPLEX  *S1,
                    const FLOAT_COMPLEX  *S2,
                    FLOAT_COMPLEX        *V)
{
    DEBUG_LAPACK_STUB("claqr1");
    LAPACK_IMPL(claqr1)(N,
                        H,
                        LDH,
                        S1,
                        S2,
                        V);
}

//-- claqr2 --------------------------------------------------------------------
void
LAPACK_DECL(claqr2)(const LOGICAL    *WANTT,
                    const LOGICAL    *WANTZ,
                    const INTEGER    *N,
                    const INTEGER    *KTOP,
                    const INTEGER    *KBOT,
                    const INTEGER    *NW,
                    FLOAT_COMPLEX    *H,
                    const INTEGER    *LDH,
                    const INTEGER    *ILOZ,
                    const INTEGER    *IHIZ,
                    FLOAT_COMPLEX    *Z,
                    const INTEGER    *LDZ,
                    INTEGER          *NS,
                    INTEGER          *ND,
                    FLOAT_COMPLEX    *SH,
                    FLOAT_COMPLEX    *V,
                    const INTEGER    *LDV,
                    const INTEGER    *NH,
                    FLOAT_COMPLEX    *T,
                    const INTEGER    *LDT,
                    const INTEGER    *NV,
                    FLOAT_COMPLEX    *WV,
                    const INTEGER    *LDWV,
                    FLOAT_COMPLEX    *WORK,
                    const INTEGER    *LWORK)
{
    DEBUG_LAPACK_STUB("claqr2");
    LAPACK_IMPL(claqr2)(WANTT,
                        WANTZ,
                        N,
                        KTOP,
                        KBOT,
                        NW,
                        H,
                        LDH,
                        ILOZ,
                        IHIZ,
                        Z,
                        LDZ,
                        NS,
                        ND,
                        SH,
                        V,
                        LDV,
                        NH,
                        T,
                        LDT,
                        NV,
                        WV,
                        LDWV,
                        WORK,
                        LWORK);
}

//-- claqr3 --------------------------------------------------------------------
void
LAPACK_DECL(claqr3)(const LOGICAL    *WANTT,
                    const LOGICAL    *WANTZ,
                    const INTEGER    *N,
                    const INTEGER    *KTOP,
                    const INTEGER    *KBOT,
                    const INTEGER    *NW,
                    FLOAT_COMPLEX    *H,
                    const INTEGER    *LDH,
                    const INTEGER    *ILOZ,
                    const INTEGER    *IHIZ,
                    FLOAT_COMPLEX    *Z,
                    const INTEGER    *LDZ,
                    INTEGER          *NS,
                    INTEGER          *ND,
                    FLOAT_COMPLEX    *SH,
                    FLOAT_COMPLEX    *V,
                    const INTEGER    *LDV,
                    const INTEGER    *NH,
                    FLOAT_COMPLEX    *T,
                    const INTEGER    *LDT,
                    const INTEGER    *NV,
                    FLOAT_COMPLEX    *WV,
                    const INTEGER    *LDWV,
                    FLOAT_COMPLEX    *WORK,
                    const INTEGER    *LWORK)
{
    DEBUG_LAPACK_STUB("claqr3");
    LAPACK_IMPL(claqr3)(WANTT,
                        WANTZ,
                        N,
                        KTOP,
                        KBOT,
                        NW,
                        H,
                        LDH,
                        ILOZ,
                        IHIZ,
                        Z,
                        LDZ,
                        NS,
                        ND,
                        SH,
                        V,
                        LDV,
                        NH,
                        T,
                        LDT,
                        NV,
                        WV,
                        LDWV,
                        WORK,
                        LWORK);
}

//-- claqr4 --------------------------------------------------------------------
void
LAPACK_DECL(claqr4)(const LOGICAL    *WANTT,
                    const LOGICAL    *WANTZ,
                    const INTEGER    *N,
                    const INTEGER    *ILO,
                    const INTEGER    *IHI,
                    FLOAT_COMPLEX    *H,
                    const INTEGER    *LDH,
                    FLOAT_COMPLEX    *W,
                    const INTEGER    *ILOZ,
                    const INTEGER    *IHIZ,
                    FLOAT_COMPLEX    *Z,
                    const INTEGER    *LDZ,
                    FLOAT_COMPLEX    *WORK,
                    const INTEGER    *LWORK,
                    INTEGER          *INFO)
{
    DEBUG_LAPACK_STUB("claqr4");
    LAPACK_IMPL(claqr4)(WANTT,
                        WANTZ,
                        N,
                        ILO,
                        IHI,
                        H,
                        LDH,
                        W,
                        ILOZ,
                        IHIZ,
                        Z,
                        LDZ,
                        WORK,
                        LWORK,
                        INFO);
}

//-- claqr5 --------------------------------------------------------------------
void
LAPACK_DECL(claqr5)(const LOGICAL    *WANTT,
                    const LOGICAL    *WANTZ,
                    const INTEGER    *KACC22,
                    const INTEGER    *N,
                    const INTEGER    *KTOP,
                    const INTEGER    *KBOT,
                    const INTEGER    *NSHFTS,
                    FLOAT_COMPLEX    *S,
                    FLOAT_COMPLEX    *H,
                    const INTEGER    *LDH,
                    const INTEGER    *ILOZ,
                    const INTEGER    *IHIZ,
                    FLOAT_COMPLEX    *Z,
                    const INTEGER    *LDZ,
                    FLOAT_COMPLEX    *V,
                    const INTEGER    *LDV,
                    FLOAT_COMPLEX    *U,
                    const INTEGER    *LDU,
                    const INTEGER    *NV,
                    FLOAT_COMPLEX    *WV,
                    const INTEGER    *LDWV,
                    const INTEGER    *NH,
                    FLOAT_COMPLEX    *WH,
                    const INTEGER    *LDWH)
{
    DEBUG_LAPACK_STUB("claqr5");
    LAPACK_IMPL(claqr5)(WANTT,
                        WANTZ,
                        KACC22,
                        N,
                        KTOP,
                        KBOT,
                        NSHFTS,
                        S,
                        H,
                        LDH,
                        ILOZ,
                        IHIZ,
                        Z,
                        LDZ,
                        V,
                        LDV,
                        U,
                        LDU,
                        NV,
                        WV,
                        LDWV,
                        NH,
                        WH,
                        LDWH);
}

//-- claqsb --------------------------------------------------------------------
void
LAPACK_DECL(claqsb)(const char       *UPLO,
                    const INTEGER    *N,
                    const INTEGER    *KD,
                    FLOAT_COMPLEX    *AB,
                    const INTEGER    *LDAB,
                    const FLOAT      *S,
                    const FLOAT      *SCOND,
                    const FLOAT      *AMAX,
                    char             *EQUED)
{
    DEBUG_LAPACK_STUB("claqsb");
    LAPACK_IMPL(claqsb)(UPLO,
                        N,
                        KD,
                        AB,
                        LDAB,
                        S,
                        SCOND,
                        AMAX,
                        EQUED);
}

//-- claqsp --------------------------------------------------------------------
void
LAPACK_DECL(claqsp)(const char       *UPLO,
                    const INTEGER    *N,
                    FLOAT_COMPLEX    *AP,
                    const FLOAT      *S,
                    const FLOAT      *SCOND,
                    const FLOAT      *AMAX,
                    char             *EQUED)
{
    DEBUG_LAPACK_STUB("claqsp");
    LAPACK_IMPL(claqsp)(UPLO,
                        N,
                        AP,
                        S,
                        SCOND,
                        AMAX,
                        EQUED);
}

//-- claqsy --------------------------------------------------------------------
void
LAPACK_DECL(claqsy)(const char       *UPLO,
                    const INTEGER    *N,
                    FLOAT_COMPLEX    *A,
                    const INTEGER    *LDA,
                    const FLOAT      *S,
                    const FLOAT      *SCOND,
                    const FLOAT      *AMAX,
                    char             *EQUED)
{
    DEBUG_LAPACK_STUB("claqsy");
    LAPACK_IMPL(claqsy)(UPLO,
                        N,
                        A,
                        LDA,
                        S,
                        SCOND,
                        AMAX,
                        EQUED);
}

//-- clar1v --------------------------------------------------------------------
void
LAPACK_DECL(clar1v)(const INTEGER    *N,
                    const INTEGER    *B1,
                    const INTEGER    *BN,
                    const FLOAT      *LAMBDA,
                    const FLOAT      *D,
                    const FLOAT      *L,
                    const FLOAT      *LD,
                    const FLOAT      *LLD,
                    const FLOAT      *PIVMIN,
                    const FLOAT      *GAPTOL,
                    FLOAT_COMPLEX    *Z,
                    const LOGICAL    *WANTNC,
                    INTEGER          *NEGCNT,
                    FLOAT            *ZTZ,
                    FLOAT            *MINGMA,
                    INTEGER          *R,
                    INTEGER          *ISUPPZ,
                    FLOAT            *NRMINV,
                    FLOAT            *RESID,
                    FLOAT            *RQCORR,
                    FLOAT            *WORK)
{
    DEBUG_LAPACK_STUB("clar1v");
    LAPACK_IMPL(clar1v)(N,
                        B1,
                        BN,
                        LAMBDA,
                        D,
                        L,
                        LD,
                        LLD,
                        PIVMIN,
                        GAPTOL,
                        Z,
                        WANTNC,
                        NEGCNT,
                        ZTZ,
                        MINGMA,
                        R,
                        ISUPPZ,
                        NRMINV,
                        RESID,
                        RQCORR,
                        WORK);
}

//-- clar2v --------------------------------------------------------------------
void
LAPACK_DECL(clar2v)(const INTEGER        *N,
                    FLOAT_COMPLEX        *X,
                    FLOAT_COMPLEX        *Y,
                    FLOAT_COMPLEX        *Z,
                    const INTEGER        *INCX,
                    const FLOAT          *C,
                    const FLOAT_COMPLEX  *S,
                    const INTEGER        *INCC)
{
    DEBUG_LAPACK_STUB("clar2v");
    LAPACK_IMPL(clar2v)(N,
                        X,
                        Y,
                        Z,
                        INCX,
                        C,
                        S,
                        INCC);
}

//-- clarcm --------------------------------------------------------------------
void
LAPACK_DECL(clarcm)(const INTEGER        *M,
                    const INTEGER        *N,
                    const FLOAT          *A,
                    const INTEGER        *LDA,
                    const FLOAT_COMPLEX  *B,
                    const INTEGER        *LDB,
                    const FLOAT_COMPLEX  *C,
                    const INTEGER        *LDC,
                    FLOAT                *RWORK)
{
    DEBUG_LAPACK_STUB("clarcm");
    LAPACK_IMPL(clarcm)(M,
                        N,
                        A,
                        LDA,
                        B,
                        LDB,
                        C,
                        LDC,
                        RWORK);
}

//-- clarf ---------------------------------------------------------------------
void
LAPACK_DECL(clarf)(const char               *SIDE,
                   const INTEGER            *M,
                   const INTEGER            *N,
                   const FLOAT_COMPLEX      *V,
                   const INTEGER            *INCV,
                   const FLOAT_COMPLEX      *TAU,
                   FLOAT_COMPLEX            *C,
                   const INTEGER            *LDC,
                   FLOAT_COMPLEX            *WORK)
{
    DEBUG_LAPACK_STUB("clarf");
    LAPACK_IMPL(clarf)(SIDE,
                       M,
                       N,
                       V,
                       INCV,
                       TAU,
                       C,
                       LDC,
                       WORK);
}

//-- clarfb --------------------------------------------------------------------
void
LAPACK_DECL(clarfb)(const char           *SIDE,
                    const char           *TRANS,
                    const char           *DIRECT,
                    const char           *STOREV,
                    const INTEGER        *M,
                    const INTEGER        *N,
                    const INTEGER        *K,
                    const FLOAT_COMPLEX  *V,
                    const INTEGER        *LDV,
                    const FLOAT_COMPLEX  *T,
                    const INTEGER        *LDT,
                    FLOAT_COMPLEX        *C,
                    const INTEGER        *LDC,
                    FLOAT_COMPLEX        *WORK,
                    const INTEGER        *LDWORK)
{
    DEBUG_LAPACK_STUB("clarfb");
    LAPACK_IMPL(clarfb)(SIDE,
                        TRANS,
                        DIRECT,
                        STOREV,
                        M,
                        N,
                        K,
                        V,
                        LDV,
                        T,
                        LDT,
                        C,
                        LDC,
                        WORK,
                        LDWORK);
}

//-- clarfg --------------------------------------------------------------------
void
LAPACK_DECL(clarfg)(const INTEGER    *N,
                    FLOAT_COMPLEX    *ALPHA,
                    FLOAT_COMPLEX    *X,
                    const INTEGER    *INCX,
                    FLOAT_COMPLEX    *TAU)
{
    DEBUG_LAPACK_STUB("clarfg");
    LAPACK_IMPL(clarfg)(N,
                        ALPHA,
                        X,
                        INCX,
                        TAU);
}

//-- clarfgp -------------------------------------------------------------------
void
LAPACK_DECL(clarfgp)(const INTEGER    *N,
                     FLOAT_COMPLEX    *ALPHA,
                     FLOAT_COMPLEX    *X,
                     const INTEGER    *INCX,
                     FLOAT_COMPLEX    *TAU)
{
    DEBUG_LAPACK_STUB("clarfgp");
    LAPACK_IMPL(clarfgp)(N,
                         ALPHA,
                         X,
                         INCX,
                         TAU);
}

//-- clarft --------------------------------------------------------------------
void
LAPACK_DECL(clarft)(const char           *DIRECT,
                    const char           *STOREV,
                    const INTEGER        *N,
                    const INTEGER        *K,
                    FLOAT_COMPLEX        *V,
                    const INTEGER        *LDV,
                    const FLOAT_COMPLEX  *TAU,
                    FLOAT_COMPLEX        *T,
                    const INTEGER        *LDT)
{
    DEBUG_LAPACK_STUB("clarft");
    LAPACK_IMPL(clarft)(DIRECT,
                        STOREV,
                        N,
                        K,
                        V,
                        LDV,
                        TAU,
                        T,
                        LDT);
}

//-- clarfx --------------------------------------------------------------------
void
LAPACK_DECL(clarfx)(const char           *SIDE,
                    const INTEGER        *M,
                    const INTEGER        *N,
                    const FLOAT_COMPLEX  *V,
                    const FLOAT_COMPLEX  *TAU,
                    FLOAT_COMPLEX        *C,
                    const INTEGER        *LDC,
                    FLOAT_COMPLEX        *WORK)
{
    DEBUG_LAPACK_STUB("clarfx");
    LAPACK_IMPL(clarfx)(SIDE,
                        M,
                        N,
                        V,
                        TAU,
                        C,
                        LDC,
                        WORK);
}

//-- clargv --------------------------------------------------------------------
void
LAPACK_DECL(clargv)(const INTEGER    *N,
                    FLOAT_COMPLEX    *X,
                    const INTEGER    *INCX,
                    FLOAT_COMPLEX    *Y,
                    const INTEGER    *INCY,
                    FLOAT            *C,
                    const INTEGER    *INCC)
{
    DEBUG_LAPACK_STUB("clargv");
    LAPACK_IMPL(clargv)(N,
                        X,
                        INCX,
                        Y,
                        INCY,
                        C,
                        INCC);
}

//-- clarnv --------------------------------------------------------------------
void
LAPACK_DECL(clarnv)(const INTEGER    *IDIST,
                    INTEGER          *ISEED,
                    const INTEGER    *N,
                    FLOAT_COMPLEX    *X)
{
    DEBUG_LAPACK_STUB("clarnv");
    LAPACK_IMPL(clarnv)(IDIST,
                        ISEED,
                        N,
                        X);
}

//-- clarrv --------------------------------------------------------------------
void
LAPACK_DECL(clarrv)(const INTEGER    *N,
                    const FLOAT      *VL,
                    const FLOAT      *VU,
                    FLOAT            *D,
                    FLOAT            *L,
                    const FLOAT      *PIVMIN,
                    const INTEGER    *ISPLIT,
                    const INTEGER    *M,
                    const INTEGER    *DOL,
                    const INTEGER    *DOU,
                    const FLOAT      *MINRGP,
                    const FLOAT      *RTOL1,
                    const FLOAT      *RTOL2,
                    FLOAT            *W,
                    FLOAT            *WERR,
                    FLOAT            *WGAP,
                    const INTEGER    *IBLOCK,
                    const INTEGER    *INDEXW,
                    const FLOAT      *GERS,
                    FLOAT_COMPLEX    *Z,
                    const INTEGER    *LDZ,
                    INTEGER          *ISUPPZ,
                    FLOAT            *WORK,
                    INTEGER          *IWORK,
                    INTEGER          *INFO)
{
    DEBUG_LAPACK_STUB("clarrv");
    LAPACK_IMPL(clarrv)(N,
                        VL,
                        VU,
                        D,
                        L,
                        PIVMIN,
                        ISPLIT,
                        M,
                        DOL,
                        DOU,
                        MINRGP,
                        RTOL1,
                        RTOL2,
                        W,
                        WERR,
                        WGAP,
                        IBLOCK,
                        INDEXW,
                        GERS,
                        Z,
                        LDZ,
                        ISUPPZ,
                        WORK,
                        IWORK,
                        INFO);
}

//-- clarscl2 ------------------------------------------------------------------
void
LAPACK_DECL(clarscl2)(const INTEGER    *M,
                      const INTEGER    *N,
                      const FLOAT      *D,
                      FLOAT_COMPLEX    *X,
                      const INTEGER    *LDX)
{
    DEBUG_LAPACK_STUB("clarscl2");
    LAPACK_IMPL(clarscl2)(M,
                          N,
                          D,
                          X,
                          LDX);
}

//-- clartg --------------------------------------------------------------------
void
LAPACK_DECL(clartg)(const FLOAT_COMPLEX  *F,
                    const FLOAT_COMPLEX  *G,
                    FLOAT                *CS,
                    FLOAT_COMPLEX        *SN,
                    FLOAT_COMPLEX        *R)
{
    DEBUG_LAPACK_STUB("clartg");
    LAPACK_IMPL(clartg)(F,
                        G,
                        CS,
                        SN,
                        R);
}

//-- clartv --------------------------------------------------------------------
void
LAPACK_DECL(clartv)(const INTEGER        *N,
                    FLOAT_COMPLEX        *X,
                    const INTEGER        *INCX,
                    FLOAT_COMPLEX        *Y,
                    const INTEGER        *INCY,
                    const FLOAT          *C,
                    const FLOAT_COMPLEX  *S,
                    const INTEGER        *INCC)
{
    DEBUG_LAPACK_STUB("clartv");
    LAPACK_IMPL(clartv)(N,
                        X,
                        INCX,
                        Y,
                        INCY,
                        C,
                        S,
                        INCC);
}

//-- clarz ---------------------------------------------------------------------
void
LAPACK_DECL(clarz)(const char               *SIDE,
                   const INTEGER            *M,
                   const INTEGER            *N,
                   const INTEGER            *L,
                   const FLOAT_COMPLEX      *V,
                   const INTEGER            *INCV,
                   const FLOAT_COMPLEX      *TAU,
                   FLOAT_COMPLEX            *C,
                   const INTEGER            *LDC,
                   FLOAT_COMPLEX            *WORK)
{
    DEBUG_LAPACK_STUB("clarz");
    LAPACK_IMPL(clarz)(SIDE,
                       M,
                       N,
                       L,
                       V,
                       INCV,
                       TAU,
                       C,
                       LDC,
                       WORK);
}

//-- clarzb --------------------------------------------------------------------
void
LAPACK_DECL(clarzb)(const char           *SIDE,
                    const char           *TRANS,
                    const char           *DIRECT,
                    const char           *STOREV,
                    const INTEGER        *M,
                    const INTEGER        *N,
                    const INTEGER        *K,
                    const INTEGER        *L,
                    const FLOAT_COMPLEX  *V,
                    const INTEGER        *LDV,
                    const FLOAT_COMPLEX  *T,
                    const INTEGER        *LDT,
                    FLOAT_COMPLEX        *C,
                    const INTEGER        *LDC,
                    FLOAT_COMPLEX        *WORK,
                    const INTEGER        *LDWORK)
{
    DEBUG_LAPACK_STUB("clarzb");
    LAPACK_IMPL(clarzb)(SIDE,
                        TRANS,
                        DIRECT,
                        STOREV,
                        M,
                        N,
                        K,
                        L,
                        V,
                        LDV,
                        T,
                        LDT,
                        C,
                        LDC,
                        WORK,
                        LDWORK);
}

//-- clarzt --------------------------------------------------------------------
void
LAPACK_DECL(clarzt)(const char           *DIRECT,
                    const char           *STOREV,
                    const INTEGER        *N,
                    const INTEGER        *K,
                    FLOAT_COMPLEX        *V,
                    const INTEGER        *LDV,
                    const FLOAT_COMPLEX  *TAU,
                    FLOAT_COMPLEX        *T,
                    const INTEGER        *LDT)
{
    DEBUG_LAPACK_STUB("clarzt");
    LAPACK_IMPL(clarzt)(DIRECT,
                        STOREV,
                        N,
                        K,
                        V,
                        LDV,
                        TAU,
                        T,
                        LDT);
}

//-- clascl --------------------------------------------------------------------
void
LAPACK_DECL(clascl)(const char       *TYPE,
                    const INTEGER    *KL,
                    const INTEGER    *KU,
                    const FLOAT      *CFROM,
                    const FLOAT      *CTO,
                    const INTEGER    *M,
                    const INTEGER    *N,
                    FLOAT_COMPLEX    *A,
                    const INTEGER    *LDA,
                    INTEGER          *INFO)
{
    DEBUG_LAPACK_STUB("clascl");
    LAPACK_IMPL(clascl)(TYPE,
                        KL,
                        KU,
                        CFROM,
                        CTO,
                        M,
                        N,
                        A,
                        LDA,
                        INFO);
}

//-- clascl2 -------------------------------------------------------------------
void
LAPACK_DECL(clascl2)(const INTEGER    *M,
                     const INTEGER    *N,
                     const FLOAT      *D,
                     FLOAT_COMPLEX    *X,
                     const INTEGER    *LDX)
{
    DEBUG_LAPACK_STUB("clascl2");
    LAPACK_IMPL(clascl2)(M,
                         N,
                         D,
                         X,
                         LDX);
}

//-- claset --------------------------------------------------------------------
void
LAPACK_DECL(claset)(const char           *UPLO,
                    const INTEGER        *M,
                    const INTEGER        *N,
                    const FLOAT_COMPLEX  *ALPHA,
                    const FLOAT_COMPLEX  *BETA,
                    FLOAT_COMPLEX        *A,
                    const INTEGER        *LDA)
{
    DEBUG_LAPACK_STUB("claset");
    LAPACK_IMPL(claset)(UPLO,
                        M,
                        N,
                        ALPHA,
                        BETA,
                        A,
                        LDA);
}

//-- clasr ---------------------------------------------------------------------
void
LAPACK_DECL(clasr)(const char           *SIDE,
                   const char           *PIVOT,
                   const char           *DIRECT,
                   const INTEGER        *M,
                   const INTEGER        *N,
                   const FLOAT          *C,
                   const FLOAT          *S,
                   FLOAT_COMPLEX        *A,
                   const INTEGER        *LDA)
{
    DEBUG_LAPACK_STUB("clasr");
    LAPACK_IMPL(clasr)(SIDE,
                       PIVOT,
                       DIRECT,
                       M,
                       N,
                       C,
                       S,
                       A,
                       LDA);
}

//-- classq --------------------------------------------------------------------
void
LAPACK_DECL(classq)(const INTEGER        *N,
                    const FLOAT_COMPLEX  *X,
                    const INTEGER        *INCX,
                    FLOAT                *SCALE,
                    FLOAT                *SUMSQ)
{
    DEBUG_LAPACK_STUB("classq");
    LAPACK_IMPL(classq)(N,
                        X,
                        INCX,
                        SCALE,
                        SUMSQ);
}

//-- claswp --------------------------------------------------------------------
void
LAPACK_DECL(claswp)(const INTEGER    *N,
                    FLOAT_COMPLEX    *A,
                    const INTEGER    *LDA,
                    const INTEGER    *K1,
                    const INTEGER    *K2,
                    const INTEGER    *IPIV,
                    const INTEGER    *INCX)
{
    DEBUG_LAPACK_STUB("claswp");
    LAPACK_IMPL(claswp)(N,
                        A,
                        LDA,
                        K1,
                        K2,
                        IPIV,
                        INCX);
}

//-- clasyf --------------------------------------------------------------------
void
LAPACK_DECL(clasyf)(const char       *UPLO,
                    const INTEGER    *N,
                    const INTEGER    *NB,
                    INTEGER          *KB,
                    FLOAT_COMPLEX    *A,
                    const INTEGER    *LDA,
                    INTEGER          *IPIV,
                    FLOAT_COMPLEX    *W,
                    const INTEGER    *LDW,
                    INTEGER          *INFO)
{
    DEBUG_LAPACK_STUB("clasyf");
    LAPACK_IMPL(clasyf)(UPLO,
                        N,
                        NB,
                        KB,
                        A,
                        LDA,
                        IPIV,
                        W,
                        LDW,
                        INFO);
}

//-- clatbs --------------------------------------------------------------------
void
LAPACK_DECL(clatbs)(const char           *UPLO,
                    const char           *TRANS,
                    const char           *DIAG,
                    const char           *NORMIN,
                    const INTEGER        *N,
                    const INTEGER        *KD,
                    const FLOAT_COMPLEX  *AB,
                    const INTEGER        *LDAB,
                    FLOAT_COMPLEX        *X,
                    FLOAT                *SCALE,
                    FLOAT                *CNORM,
                    INTEGER              *INFO)
{
    DEBUG_LAPACK_STUB("clatbs");
    LAPACK_IMPL(clatbs)(UPLO,
                        TRANS,
                        DIAG,
                        NORMIN,
                        N,
                        KD,
                        AB,
                        LDAB,
                        X,
                        SCALE,
                        CNORM,
                        INFO);
}

//-- clatdf --------------------------------------------------------------------
void
LAPACK_DECL(clatdf)(const INTEGER        *IJOB,
                    const INTEGER        *N,
                    const FLOAT_COMPLEX  *Z,
                    const INTEGER        *LDZ,
                    FLOAT_COMPLEX        *RHS,
                    FLOAT                *RDSUM,
                    FLOAT                *RDSCAL,
                    const INTEGER        *IPIV,
                    const INTEGER        *JPIV)
{
    DEBUG_LAPACK_STUB("clatdf");
    LAPACK_IMPL(clatdf)(IJOB,
                        N,
                        Z,
                        LDZ,
                        RHS,
                        RDSUM,
                        RDSCAL,
                        IPIV,
                        JPIV);
}

//-- clatps --------------------------------------------------------------------
void
LAPACK_DECL(clatps)(const char           *UPLO,
                    const char           *TRANS,
                    const char           *DIAG,
                    const char           *NORMIN,
                    const INTEGER        *N,
                    const FLOAT_COMPLEX  *AP,
                    FLOAT_COMPLEX        *X,
                    FLOAT                *SCALE,
                    FLOAT                *CNORM,
                    INTEGER              *INFO)
{
    DEBUG_LAPACK_STUB("clatps");
    LAPACK_IMPL(clatps)(UPLO,
                        TRANS,
                        DIAG,
                        NORMIN,
                        N,
                        AP,
                        X,
                        SCALE,
                        CNORM,
                        INFO);
}

//-- clatrd --------------------------------------------------------------------
void
LAPACK_DECL(clatrd)(const char       *UPLO,
                    const INTEGER    *N,
                    const INTEGER    *NB,
                    FLOAT_COMPLEX    *A,
                    const INTEGER    *LDA,
                    FLOAT            *E,
                    FLOAT_COMPLEX    *TAU,
                    FLOAT_COMPLEX    *W,
                    const INTEGER    *LDW)
{
    DEBUG_LAPACK_STUB("clatrd");
    LAPACK_IMPL(clatrd)(UPLO,
                        N,
                        NB,
                        A,
                        LDA,
                        E,
                        TAU,
                        W,
                        LDW);
}

//-- clatrs --------------------------------------------------------------------
void
LAPACK_DECL(clatrs)(const char           *UPLO,
                    const char           *TRANS,
                    const char           *DIAG,
                    const char           *NORMIN,
                    const INTEGER        *N,
                    const FLOAT_COMPLEX  *A,
                    const INTEGER        *LDA,
                    FLOAT_COMPLEX        *X,
                    FLOAT                *SCALE,
                    FLOAT                *CNORM,
                    INTEGER              *INFO)
{
    DEBUG_LAPACK_STUB("clatrs");
    LAPACK_IMPL(clatrs)(UPLO,
                        TRANS,
                        DIAG,
                        NORMIN,
                        N,
                        A,
                        LDA,
                        X,
                        SCALE,
                        CNORM,
                        INFO);
}

//-- clatrz --------------------------------------------------------------------
void
LAPACK_DECL(clatrz)(const INTEGER    *M,
                    const INTEGER    *N,
                    const INTEGER    *L,
                    FLOAT_COMPLEX    *A,
                    const INTEGER    *LDA,
                    FLOAT_COMPLEX    *TAU,
                    FLOAT_COMPLEX    *WORK)
{
    DEBUG_LAPACK_STUB("clatrz");
    LAPACK_IMPL(clatrz)(M,
                        N,
                        L,
                        A,
                        LDA,
                        TAU,
                        WORK);
}

//-- clatzm --------------------------------------------------------------------
void
LAPACK_DECL(clatzm)(const char           *SIDE,
                    const INTEGER        *M,
                    const INTEGER        *N,
                    const FLOAT_COMPLEX  *V,
                    const INTEGER        *INCV,
                    const FLOAT_COMPLEX  *TAU,
                    FLOAT_COMPLEX        *C1,
                    FLOAT_COMPLEX        *C2,
                    const INTEGER        *LDC,
                    FLOAT_COMPLEX        *WORK)
{
    DEBUG_LAPACK_STUB("clatzm");
    LAPACK_IMPL(clatzm)(SIDE,
                        M,
                        N,
                        V,
                        INCV,
                        TAU,
                        C1,
                        C2,
                        LDC,
                        WORK);
}

//-- clauu2 --------------------------------------------------------------------
void
LAPACK_DECL(clauu2)(const char       *UPLO,
                    const INTEGER    *N,
                    FLOAT_COMPLEX    *A,
                    const INTEGER    *LDA,
                    INTEGER          *INFO)
{
    DEBUG_LAPACK_STUB("clauu2");
    LAPACK_IMPL(clauu2)(UPLO,
                        N,
                        A,
                        LDA,
                        INFO);
}

//-- clauum --------------------------------------------------------------------
void
LAPACK_DECL(clauum)(const char       *UPLO,
                    const INTEGER    *N,
                    FLOAT_COMPLEX    *A,
                    const INTEGER    *LDA,
                    INTEGER          *INFO)
{
    DEBUG_LAPACK_STUB("clauum");
    LAPACK_IMPL(clauum)(UPLO,
                        N,
                        A,
                        LDA,
                        INFO);
}

//-- cpbcon --------------------------------------------------------------------
void
LAPACK_DECL(cpbcon)(const char           *UPLO,
                    const INTEGER        *N,
                    const INTEGER        *KD,
                    const FLOAT_COMPLEX  *AB,
                    const INTEGER        *LDAB,
                    const FLOAT          *ANORM,
                    FLOAT                *RCOND,
                    FLOAT_COMPLEX        *WORK,
                    FLOAT                *RWORK,
                    INTEGER              *INFO)
{
    DEBUG_LAPACK_STUB("cpbcon");
    LAPACK_IMPL(cpbcon)(UPLO,
                        N,
                        KD,
                        AB,
                        LDAB,
                        ANORM,
                        RCOND,
                        WORK,
                        RWORK,
                        INFO);
}

//-- cpbequ --------------------------------------------------------------------
void
LAPACK_DECL(cpbequ)(const char           *UPLO,
                    const INTEGER        *N,
                    const INTEGER        *KD,
                    const FLOAT_COMPLEX  *AB,
                    const INTEGER        *LDAB,
                    FLOAT                *S,
                    FLOAT                *SCOND,
                    FLOAT                *AMAX,
                    INTEGER              *INFO)
{
    DEBUG_LAPACK_STUB("cpbequ");
    LAPACK_IMPL(cpbequ)(UPLO,
                        N,
                        KD,
                        AB,
                        LDAB,
                        S,
                        SCOND,
                        AMAX,
                        INFO);
}

//-- cpbrfs --------------------------------------------------------------------
void
LAPACK_DECL(cpbrfs)(const char           *UPLO,
                    const INTEGER        *N,
                    const INTEGER        *KD,
                    const INTEGER        *NRHS,
                    const FLOAT_COMPLEX  *AB,
                    const INTEGER        *LDAB,
                    const FLOAT_COMPLEX  *AFB,
                    const INTEGER        *LDAFB,
                    const FLOAT_COMPLEX  *B,
                    const INTEGER        *LDB,
                    FLOAT_COMPLEX        *X,
                    const INTEGER        *LDX,
                    FLOAT                *FERR,
                    FLOAT                *BERR,
                    FLOAT_COMPLEX        *WORK,
                    FLOAT                *RWORK,
                    INTEGER              *INFO)
{
    DEBUG_LAPACK_STUB("cpbrfs");
    LAPACK_IMPL(cpbrfs)(UPLO,
                        N,
                        KD,
                        NRHS,
                        AB,
                        LDAB,
                        AFB,
                        LDAFB,
                        B,
                        LDB,
                        X,
                        LDX,
                        FERR,
                        BERR,
                        WORK,
                        RWORK,
                        INFO);
}

//-- cpbstf --------------------------------------------------------------------
void
LAPACK_DECL(cpbstf)(const char       *UPLO,
                    const INTEGER    *N,
                    const INTEGER    *KD,
                    FLOAT_COMPLEX    *AB,
                    const INTEGER    *LDAB,
                    INTEGER          *INFO)
{
    DEBUG_LAPACK_STUB("cpbstf");
    LAPACK_IMPL(cpbstf)(UPLO,
                        N,
                        KD,
                        AB,
                        LDAB,
                        INFO);
}

//-- cpbsv ---------------------------------------------------------------------
void
LAPACK_DECL(cpbsv)(const char           *UPLO,
                   const INTEGER        *N,
                   const INTEGER        *KD,
                   const INTEGER        *NRHS,
                   FLOAT_COMPLEX        *AB,
                   const INTEGER        *LDAB,
                   FLOAT_COMPLEX        *B,
                   const INTEGER        *LDB,
                   INTEGER              *INFO)
{
    DEBUG_LAPACK_STUB("cpbsv");
    LAPACK_IMPL(cpbsv)(UPLO,
                       N,
                       KD,
                       NRHS,
                       AB,
                       LDAB,
                       B,
                       LDB,
                       INFO);
}

//-- cpbsvx --------------------------------------------------------------------
void
LAPACK_DECL(cpbsvx)(const char       *FACT,
                    const char       *UPLO,
                    const INTEGER    *N,
                    const INTEGER    *KD,
                    const INTEGER    *NRHS,
                    FLOAT_COMPLEX    *AB,
                    const INTEGER    *LDAB,
                    FLOAT_COMPLEX    *AFB,
                    const INTEGER    *LDAFB,
                    char             *EQUED,
                    FLOAT            *S,
                    FLOAT_COMPLEX    *B,
                    const INTEGER    *LDB,
                    FLOAT_COMPLEX    *X,
                    const INTEGER    *LDX,
                    FLOAT            *RCOND,
                    FLOAT            *FERR,
                    FLOAT            *BERR,
                    FLOAT_COMPLEX    *WORK,
                    FLOAT            *RWORK,
                    INTEGER          *INFO)
{
    DEBUG_LAPACK_STUB("cpbsvx");
    LAPACK_IMPL(cpbsvx)(FACT,
                        UPLO,
                        N,
                        KD,
                        NRHS,
                        AB,
                        LDAB,
                        AFB,
                        LDAFB,
                        EQUED,
                        S,
                        B,
                        LDB,
                        X,
                        LDX,
                        RCOND,
                        FERR,
                        BERR,
                        WORK,
                        RWORK,
                        INFO);
}

//-- cpbtf2 --------------------------------------------------------------------
void
LAPACK_DECL(cpbtf2)(const char       *UPLO,
                    const INTEGER    *N,
                    const INTEGER    *KD,
                    FLOAT_COMPLEX    *AB,
                    const INTEGER    *LDAB,
                    INTEGER          *INFO)
{
    DEBUG_LAPACK_STUB("cpbtf2");
    LAPACK_IMPL(cpbtf2)(UPLO,
                        N,
                        KD,
                        AB,
                        LDAB,
                        INFO);
}

//-- cpbtrf --------------------------------------------------------------------
void
LAPACK_DECL(cpbtrf)(const char       *UPLO,
                    const INTEGER    *N,
                    const INTEGER    *KD,
                    FLOAT_COMPLEX    *AB,
                    const INTEGER    *LDAB,
                    INTEGER          *INFO)
{
    DEBUG_LAPACK_STUB("cpbtrf");
    LAPACK_IMPL(cpbtrf)(UPLO,
                        N,
                        KD,
                        AB,
                        LDAB,
                        INFO);
}

//-- cpbtrs --------------------------------------------------------------------
void
LAPACK_DECL(cpbtrs)(const char           *UPLO,
                    const INTEGER        *N,
                    const INTEGER        *KD,
                    const INTEGER        *NRHS,
                    const FLOAT_COMPLEX  *AB,
                    const INTEGER        *LDAB,
                    FLOAT_COMPLEX        *B,
                    const INTEGER        *LDB,
                    INTEGER              *INFO)
{
    DEBUG_LAPACK_STUB("cpbtrs");
    LAPACK_IMPL(cpbtrs)(UPLO,
                        N,
                        KD,
                        NRHS,
                        AB,
                        LDAB,
                        B,
                        LDB,
                        INFO);
}

//-- cpftrf --------------------------------------------------------------------
void
LAPACK_DECL(cpftrf)(const char       *TRANSR,
                    const char       *UPLO,
                    const INTEGER    *N,
                    FLOAT_COMPLEX    *A,
                    INTEGER          *INFO)
{
    DEBUG_LAPACK_STUB("cpftrf");
    LAPACK_IMPL(cpftrf)(TRANSR,
                        UPLO,
                        N,
                        A,
                        INFO);
}

//-- cpftri --------------------------------------------------------------------
void
LAPACK_DECL(cpftri)(const char       *TRANSR,
                    const char       *UPLO,
                    const INTEGER    *N,
                    FLOAT_COMPLEX    *A,
                    INTEGER          *INFO)
{
    DEBUG_LAPACK_STUB("cpftri");
    LAPACK_IMPL(cpftri)(TRANSR,
                        UPLO,
                        N,
                        A,
                        INFO);
}

//-- cpftrs --------------------------------------------------------------------
void
LAPACK_DECL(cpftrs)(const char           *TRANSR,
                    const char           *UPLO,
                    const INTEGER        *N,
                    const INTEGER        *NRHS,
                    const FLOAT_COMPLEX  *A,
                    FLOAT_COMPLEX        *B,
                    const INTEGER        *LDB,
                    INTEGER              *INFO)
{
    DEBUG_LAPACK_STUB("cpftrs");
    LAPACK_IMPL(cpftrs)(TRANSR,
                        UPLO,
                        N,
                        NRHS,
                        A,
                        B,
                        LDB,
                        INFO);
}

//-- cpocon --------------------------------------------------------------------
void
LAPACK_DECL(cpocon)(const char           *UPLO,
                    const INTEGER        *N,
                    const FLOAT_COMPLEX  *A,
                    const INTEGER        *LDA,
                    const FLOAT          *ANORM,
                    FLOAT                *RCOND,
                    FLOAT_COMPLEX        *WORK,
                    FLOAT                *RWORK,
                    INTEGER              *INFO)
{
    DEBUG_LAPACK_STUB("cpocon");
    LAPACK_IMPL(cpocon)(UPLO,
                        N,
                        A,
                        LDA,
                        ANORM,
                        RCOND,
                        WORK,
                        RWORK,
                        INFO);
}

//-- cpoequ --------------------------------------------------------------------
void
LAPACK_DECL(cpoequ)(const INTEGER        *N,
                    const FLOAT_COMPLEX  *A,
                    const INTEGER        *LDA,
                    FLOAT                *S,
                    FLOAT                *SCOND,
                    FLOAT                *AMAX,
                    INTEGER              *INFO)
{
    DEBUG_LAPACK_STUB("cpoequ");
    LAPACK_IMPL(cpoequ)(N,
                        A,
                        LDA,
                        S,
                        SCOND,
                        AMAX,
                        INFO);
}

//-- cpoequb -------------------------------------------------------------------
void
LAPACK_DECL(cpoequb)(const INTEGER            *N,
                     const FLOAT_COMPLEX      *A,
                     const INTEGER            *LDA,
                     FLOAT                    *S,
                     FLOAT                    *SCOND,
                     FLOAT                    *AMAX,
                     INTEGER                  *INFO)
{
    DEBUG_LAPACK_STUB("cpoequb");
    LAPACK_IMPL(cpoequb)(N,
                         A,
                         LDA,
                         S,
                         SCOND,
                         AMAX,
                         INFO);
}

//-- cporfs --------------------------------------------------------------------
void
LAPACK_DECL(cporfs)(const char           *UPLO,
                    const INTEGER        *N,
                    const INTEGER        *NRHS,
                    const FLOAT_COMPLEX  *A,
                    const INTEGER        *LDA,
                    const FLOAT_COMPLEX  *AF,
                    const INTEGER        *LDAF,
                    const FLOAT_COMPLEX  *B,
                    const INTEGER        *LDB,
                    FLOAT_COMPLEX        *X,
                    const INTEGER        *LDX,
                    FLOAT                *FERR,
                    FLOAT                *BERR,
                    FLOAT_COMPLEX        *WORK,
                    FLOAT                *RWORK,
                    INTEGER              *INFO)
{
    DEBUG_LAPACK_STUB("cporfs");
    LAPACK_IMPL(cporfs)(UPLO,
                        N,
                        NRHS,
                        A,
                        LDA,
                        AF,
                        LDAF,
                        B,
                        LDB,
                        X,
                        LDX,
                        FERR,
                        BERR,
                        WORK,
                        RWORK,
                        INFO);
}

//-- cporfsx -------------------------------------------------------------------
void
LAPACK_DECL(cporfsx)(const char               *UPLO,
                     const char               *EQUED,
                     const INTEGER            *N,
                     const INTEGER            *NRHS,
                     const FLOAT_COMPLEX      *A,
                     const INTEGER            *LDA,
                     const FLOAT_COMPLEX      *AF,
                     const INTEGER            *LDAF,
                     FLOAT                    *S,
                     const FLOAT_COMPLEX      *B,
                     const INTEGER            *LDB,
                     FLOAT_COMPLEX            *X,
                     const INTEGER            *LDX,
                     FLOAT                    *RCOND,
                     FLOAT                    *BERR,
                     const INTEGER            *N_ERR_BNDS,
                     FLOAT                    *ERR_BNDS_NORM,
                     FLOAT                    *ERR_BNDS_COMP,
                     const INTEGER            *NPARAMS,
                     FLOAT                    *PARAMS,
                     FLOAT_COMPLEX            *WORK,
                     FLOAT                    *RWORK,
                     INTEGER                  *INFO)
{
    DEBUG_LAPACK_STUB("cporfsx");
    LAPACK_IMPL(cporfsx)(UPLO,
                         EQUED,
                         N,
                         NRHS,
                         A,
                         LDA,
                         AF,
                         LDAF,
                         S,
                         B,
                         LDB,
                         X,
                         LDX,
                         RCOND,
                         BERR,
                         N_ERR_BNDS,
                         ERR_BNDS_NORM,
                         ERR_BNDS_COMP,
                         NPARAMS,
                         PARAMS,
                         WORK,
                         RWORK,
                         INFO);
}

//-- cposv ---------------------------------------------------------------------
void
LAPACK_DECL(cposv)(const char           *UPLO,
                   const INTEGER        *N,
                   const INTEGER        *NRHS,
                   FLOAT_COMPLEX        *A,
                   const INTEGER        *LDA,
                   FLOAT_COMPLEX        *B,
                   const INTEGER        *LDB,
                   INTEGER              *INFO)
{
    DEBUG_LAPACK_STUB("cposv");
    LAPACK_IMPL(cposv)(UPLO,
                       N,
                       NRHS,
                       A,
                       LDA,
                       B,
                       LDB,
                       INFO);
}

//-- cposvx --------------------------------------------------------------------
void
LAPACK_DECL(cposvx)(const char       *FACT,
                    const char       *UPLO,
                    const INTEGER    *N,
                    const INTEGER    *NRHS,
                    FLOAT_COMPLEX    *A,
                    const INTEGER    *LDA,
                    FLOAT_COMPLEX    *AF,
                    const INTEGER    *LDAF,
                    char             *EQUED,
                    FLOAT            *S,
                    FLOAT_COMPLEX    *B,
                    const INTEGER    *LDB,
                    FLOAT_COMPLEX    *X,
                    const INTEGER    *LDX,
                    FLOAT            *RCOND,
                    FLOAT            *FERR,
                    FLOAT            *BERR,
                    FLOAT_COMPLEX    *WORK,
                    FLOAT            *RWORK,
                    INTEGER          *INFO)
{
    DEBUG_LAPACK_STUB("cposvx");
    LAPACK_IMPL(cposvx)(FACT,
                        UPLO,
                        N,
                        NRHS,
                        A,
                        LDA,
                        AF,
                        LDAF,
                        EQUED,
                        S,
                        B,
                        LDB,
                        X,
                        LDX,
                        RCOND,
                        FERR,
                        BERR,
                        WORK,
                        RWORK,
                        INFO);
}

//-- cposvxx -------------------------------------------------------------------
void
LAPACK_DECL(cposvxx)(const char       *FACT,
                     const char       *UPLO,
                     const INTEGER    *N,
                     const INTEGER    *NRHS,
                     FLOAT_COMPLEX    *A,
                     const INTEGER    *LDA,
                     FLOAT_COMPLEX    *AF,
                     const INTEGER    *LDAF,
                     char             *EQUED,
                     FLOAT            *S,
                     FLOAT_COMPLEX    *B,
                     const INTEGER    *LDB,
                     FLOAT_COMPLEX    *X,
                     const INTEGER    *LDX,
                     FLOAT            *RCOND,
                     FLOAT            *RPVGRW,
                     FLOAT            *BERR,
                     const INTEGER    *N_ERR_BNDS,
                     FLOAT            *ERR_BNDS_NORM,
                     FLOAT            *ERR_BNDS_COMP,
                     const INTEGER    *NPARAMS,
                     FLOAT            *PARAMS,
                     FLOAT_COMPLEX    *WORK,
                     FLOAT            *RWORK,
                     INTEGER          *INFO)
{
    DEBUG_LAPACK_STUB("cposvxx");
    LAPACK_IMPL(cposvxx)(FACT,
                         UPLO,
                         N,
                         NRHS,
                         A,
                         LDA,
                         AF,
                         LDAF,
                         EQUED,
                         S,
                         B,
                         LDB,
                         X,
                         LDX,
                         RCOND,
                         RPVGRW,
                         BERR,
                         N_ERR_BNDS,
                         ERR_BNDS_NORM,
                         ERR_BNDS_COMP,
                         NPARAMS,
                         PARAMS,
                         WORK,
                         RWORK,
                         INFO);
}

//-- cpotf2 --------------------------------------------------------------------
void
LAPACK_DECL(cpotf2)(const char       *UPLO,
                    const INTEGER    *N,
                    FLOAT_COMPLEX    *A,
                    const INTEGER    *LDA,
                    INTEGER          *INFO)
{
    DEBUG_LAPACK_STUB("cpotf2");
    LAPACK_IMPL(cpotf2)(UPLO,
                        N,
                        A,
                        LDA,
                        INFO);
}

//-- cpotrf --------------------------------------------------------------------
void
LAPACK_DECL(cpotrf)(const char       *UPLO,
                    const INTEGER    *N,
                    FLOAT_COMPLEX    *A,
                    const INTEGER    *LDA,
                    INTEGER          *INFO)
{
    DEBUG_LAPACK_STUB("cpotrf");
    LAPACK_IMPL(cpotrf)(UPLO,
                        N,
                        A,
                        LDA,
                        INFO);
}

//-- cpotri --------------------------------------------------------------------
void
LAPACK_DECL(cpotri)(const char       *UPLO,
                    const INTEGER    *N,
                    FLOAT_COMPLEX    *A,
                    const INTEGER    *LDA,
                    INTEGER          *INFO)
{
    DEBUG_LAPACK_STUB("cpotri");
    LAPACK_IMPL(cpotri)(UPLO,
                        N,
                        A,
                        LDA,
                        INFO);
}

//-- cpotrs --------------------------------------------------------------------
void
LAPACK_DECL(cpotrs)(const char           *UPLO,
                    const INTEGER        *N,
                    const INTEGER        *NRHS,
                    const FLOAT_COMPLEX  *A,
                    const INTEGER        *LDA,
                    FLOAT_COMPLEX        *B,
                    const INTEGER        *LDB,
                    INTEGER              *INFO)
{
    DEBUG_LAPACK_STUB("cpotrs");
    LAPACK_IMPL(cpotrs)(UPLO,
                        N,
                        NRHS,
                        A,
                        LDA,
                        B,
                        LDB,
                        INFO);
}

//-- cppcon --------------------------------------------------------------------
void
LAPACK_DECL(cppcon)(const char           *UPLO,
                    const INTEGER        *N,
                    const FLOAT_COMPLEX  *AP,
                    const FLOAT          *ANORM,
                    FLOAT                *RCOND,
                    FLOAT_COMPLEX        *WORK,
                    FLOAT                *RWORK,
                    INTEGER              *INFO)
{
    DEBUG_LAPACK_STUB("cppcon");
    LAPACK_IMPL(cppcon)(UPLO,
                        N,
                        AP,
                        ANORM,
                        RCOND,
                        WORK,
                        RWORK,
                        INFO);
}

//-- cppequ --------------------------------------------------------------------
void
LAPACK_DECL(cppequ)(const char           *UPLO,
                    const INTEGER        *N,
                    const FLOAT_COMPLEX  *AP,
                    FLOAT                *S,
                    FLOAT                *SCOND,
                    FLOAT                *AMAX,
                    INTEGER              *INFO)
{
    DEBUG_LAPACK_STUB("cppequ");
    LAPACK_IMPL(cppequ)(UPLO,
                        N,
                        AP,
                        S,
                        SCOND,
                        AMAX,
                        INFO);
}

//-- cpprfs --------------------------------------------------------------------
void
LAPACK_DECL(cpprfs)(const char           *UPLO,
                    const INTEGER        *N,
                    const INTEGER        *NRHS,
                    const FLOAT_COMPLEX  *AP,
                    const FLOAT_COMPLEX  *AFP,
                    const FLOAT_COMPLEX  *B,
                    const INTEGER        *LDB,
                    FLOAT_COMPLEX        *X,
                    const INTEGER        *LDX,
                    FLOAT                *FERR,
                    FLOAT                *BERR,
                    FLOAT_COMPLEX        *WORK,
                    FLOAT                *RWORK,
                    INTEGER              *INFO)
{
    DEBUG_LAPACK_STUB("cpprfs");
    LAPACK_IMPL(cpprfs)(UPLO,
                        N,
                        NRHS,
                        AP,
                        AFP,
                        B,
                        LDB,
                        X,
                        LDX,
                        FERR,
                        BERR,
                        WORK,
                        RWORK,
                        INFO);
}

//-- cppsv ---------------------------------------------------------------------
void
LAPACK_DECL(cppsv)(const char           *UPLO,
                   const INTEGER        *N,
                   const INTEGER        *NRHS,
                   FLOAT_COMPLEX        *AP,
                   FLOAT_COMPLEX        *B,
                   const INTEGER        *LDB,
                   INTEGER              *INFO)
{
    DEBUG_LAPACK_STUB("cppsv");
    LAPACK_IMPL(cppsv)(UPLO,
                       N,
                       NRHS,
                       AP,
                       B,
                       LDB,
                       INFO);
}

//-- cppsvx --------------------------------------------------------------------
void
LAPACK_DECL(cppsvx)(const char       *FACT,
                    const char       *UPLO,
                    const INTEGER    *N,
                    const INTEGER    *NRHS,
                    FLOAT_COMPLEX    *AP,
                    FLOAT_COMPLEX    *AFP,
                    char             *EQUED,
                    FLOAT            *S,
                    FLOAT_COMPLEX    *B,
                    const INTEGER    *LDB,
                    FLOAT_COMPLEX    *X,
                    const INTEGER    *LDX,
                    FLOAT            *RCOND,
                    FLOAT            *FERR,
                    FLOAT            *BERR,
                    FLOAT_COMPLEX    *WORK,
                    FLOAT            *RWORK,
                    INTEGER          *INFO)
{
    DEBUG_LAPACK_STUB("cppsvx");
    LAPACK_IMPL(cppsvx)(FACT,
                        UPLO,
                        N,
                        NRHS,
                        AP,
                        AFP,
                        EQUED,
                        S,
                        B,
                        LDB,
                        X,
                        LDX,
                        RCOND,
                        FERR,
                        BERR,
                        WORK,
                        RWORK,
                        INFO);
}

//-- cpptrf --------------------------------------------------------------------
void
LAPACK_DECL(cpptrf)(const char       *UPLO,
                    const INTEGER    *N,
                    FLOAT_COMPLEX    *AP,
                    INTEGER          *INFO)
{
    DEBUG_LAPACK_STUB("cpptrf");
    LAPACK_IMPL(cpptrf)(UPLO,
                        N,
                        AP,
                        INFO);
}

//-- cpptri --------------------------------------------------------------------
void
LAPACK_DECL(cpptri)(const char       *UPLO,
                    const INTEGER    *N,
                    FLOAT_COMPLEX    *AP,
                    INTEGER          *INFO)
{
    DEBUG_LAPACK_STUB("cpptri");
    LAPACK_IMPL(cpptri)(UPLO,
                        N,
                        AP,
                        INFO);
}

//-- cpptrs --------------------------------------------------------------------
void
LAPACK_DECL(cpptrs)(const char           *UPLO,
                    const INTEGER        *N,
                    const INTEGER        *NRHS,
                    const FLOAT_COMPLEX  *AP,
                    FLOAT_COMPLEX        *B,
                    const INTEGER        *LDB,
                    INTEGER              *INFO)
{
    DEBUG_LAPACK_STUB("cpptrs");
    LAPACK_IMPL(cpptrs)(UPLO,
                        N,
                        NRHS,
                        AP,
                        B,
                        LDB,
                        INFO);
}

//-- cpstf2 --------------------------------------------------------------------
void
LAPACK_DECL(cpstf2)(const char       *UPLO,
                    const INTEGER    *N,
                    FLOAT_COMPLEX    *A,
                    const INTEGER    *LDA,
                    INTEGER          *PIV,
                    INTEGER          *RANK,
                    const FLOAT      *TOL,
                    FLOAT            *WORK,
                    INTEGER          *INFO)
{
    DEBUG_LAPACK_STUB("cpstf2");
    LAPACK_IMPL(cpstf2)(UPLO,
                        N,
                        A,
                        LDA,
                        PIV,
                        RANK,
                        TOL,
                        WORK,
                        INFO);
}

//-- cpstrf --------------------------------------------------------------------
void
LAPACK_DECL(cpstrf)(const char       *UPLO,
                    const INTEGER    *N,
                    FLOAT_COMPLEX    *A,
                    const INTEGER    *LDA,
                    INTEGER          *PIV,
                    INTEGER          *RANK,
                    const FLOAT      *TOL,
                    FLOAT            *WORK,
                    INTEGER          *INFO)
{
    DEBUG_LAPACK_STUB("cpstrf");
    LAPACK_IMPL(cpstrf)(UPLO,
                        N,
                        A,
                        LDA,
                        PIV,
                        RANK,
                        TOL,
                        WORK,
                        INFO);
}

//-- cptcon --------------------------------------------------------------------
void
LAPACK_DECL(cptcon)(const INTEGER        *N,
                    const FLOAT          *D,
                    const FLOAT_COMPLEX  *E,
                    const FLOAT          *ANORM,
                    FLOAT                *RCOND,
                    FLOAT                *RWORK,
                    INTEGER              *INFO)
{
    DEBUG_LAPACK_STUB("cptcon");
    LAPACK_IMPL(cptcon)(N,
                        D,
                        E,
                        ANORM,
                        RCOND,
                        RWORK,
                        INFO);
}

//-- cpteqr --------------------------------------------------------------------
void
LAPACK_DECL(cpteqr)(const char       *COMPZ,
                    const INTEGER    *N,
                    FLOAT            *D,
                    FLOAT            *E,
                    FLOAT_COMPLEX    *Z,
                    const INTEGER    *LDZ,
                    FLOAT            *WORK,
                    INTEGER          *INFO)
{
    DEBUG_LAPACK_STUB("cpteqr");
    LAPACK_IMPL(cpteqr)(COMPZ,
                        N,
                        D,
                        E,
                        Z,
                        LDZ,
                        WORK,
                        INFO);
}

//-- cptrfs --------------------------------------------------------------------
void
LAPACK_DECL(cptrfs)(const char           *UPLO,
                    const INTEGER        *N,
                    const INTEGER        *NRHS,
                    const FLOAT          *D,
                    const FLOAT_COMPLEX  *E,
                    const FLOAT          *DF,
                    const FLOAT_COMPLEX  *EF,
                    const FLOAT_COMPLEX  *B,
                    const INTEGER        *LDB,
                    FLOAT_COMPLEX        *X,
                    const INTEGER        *LDX,
                    FLOAT                *FERR,
                    FLOAT                *BERR,
                    FLOAT_COMPLEX        *WORK,
                    FLOAT                *RWORK,
                    INTEGER              *INFO)
{
    DEBUG_LAPACK_STUB("cptrfs");
    LAPACK_IMPL(cptrfs)(UPLO,
                        N,
                        NRHS,
                        D,
                        E,
                        DF,
                        EF,
                        B,
                        LDB,
                        X,
                        LDX,
                        FERR,
                        BERR,
                        WORK,
                        RWORK,
                        INFO);
}

//-- cptsv ---------------------------------------------------------------------
void
LAPACK_DECL(cptsv)(const INTEGER        *N,
                   const INTEGER        *NRHS,
                   FLOAT                *D,
                   FLOAT_COMPLEX        *E,
                   FLOAT_COMPLEX        *B,
                   const INTEGER        *LDB,
                   INTEGER              *INFO)
{
    DEBUG_LAPACK_STUB("cptsv");
    LAPACK_IMPL(cptsv)(N,
                       NRHS,
                       D,
                       E,
                       B,
                       LDB,
                       INFO);
}

//-- cptsvx --------------------------------------------------------------------
void
LAPACK_DECL(cptsvx)(const char           *FACT,
                    const INTEGER        *N,
                    const INTEGER        *NRHS,
                    const FLOAT          *D,
                    const FLOAT_COMPLEX  *E,
                    FLOAT                *DF,
                    FLOAT_COMPLEX        *EF,
                    const FLOAT_COMPLEX  *B,
                    const INTEGER        *LDB,
                    FLOAT_COMPLEX        *X,
                    const INTEGER        *LDX,
                    FLOAT                *RCOND,
                    FLOAT                *FERR,
                    FLOAT                *BERR,
                    FLOAT_COMPLEX        *WORK,
                    FLOAT                *RWORK,
                    INTEGER              *INFO)
{
    DEBUG_LAPACK_STUB("cptsvx");
    LAPACK_IMPL(cptsvx)(FACT,
                        N,
                        NRHS,
                        D,
                        E,
                        DF,
                        EF,
                        B,
                        LDB,
                        X,
                        LDX,
                        RCOND,
                        FERR,
                        BERR,
                        WORK,
                        RWORK,
                        INFO);
}

//-- cpttrf --------------------------------------------------------------------
void
LAPACK_DECL(cpttrf)(const INTEGER    *N,
                    FLOAT            *D,
                    FLOAT_COMPLEX    *E,
                    INTEGER          *INFO)
{
    DEBUG_LAPACK_STUB("cpttrf");
    LAPACK_IMPL(cpttrf)(N,
                        D,
                        E,
                        INFO);
}

//-- cpttrs --------------------------------------------------------------------
void
LAPACK_DECL(cpttrs)(const char           *UPLO,
                    const INTEGER        *N,
                    const INTEGER        *NRHS,
                    const FLOAT          *D,
                    const FLOAT_COMPLEX  *E,
                    FLOAT_COMPLEX        *B,
                    const INTEGER        *LDB,
                    INTEGER              *INFO)
{
    DEBUG_LAPACK_STUB("cpttrs");
    LAPACK_IMPL(cpttrs)(UPLO,
                        N,
                        NRHS,
                        D,
                        E,
                        B,
                        LDB,
                        INFO);
}

//-- cptts2 --------------------------------------------------------------------
void
LAPACK_DECL(cptts2)(const INTEGER        *IUPLO,
                    const INTEGER        *N,
                    const INTEGER        *NRHS,
                    const FLOAT          *D,
                    const FLOAT_COMPLEX  *E,
                    FLOAT_COMPLEX        *B,
                    const INTEGER        *LDB)
{
    DEBUG_LAPACK_STUB("cptts2");
    LAPACK_IMPL(cptts2)(IUPLO,
                        N,
                        NRHS,
                        D,
                        E,
                        B,
                        LDB);
}

//-- crot ----------------------------------------------------------------------
void
LAPACK_DECL(crot)(const INTEGER            *N,
                  FLOAT_COMPLEX            *CX,
                  const INTEGER            *INCX,
                  FLOAT_COMPLEX            *CY,
                  const INTEGER            *INCY,
                  const FLOAT              *C,
                  const FLOAT_COMPLEX      *S)
{
    DEBUG_LAPACK_STUB("crot");
    LAPACK_IMPL(crot)(N,
                      CX,
                      INCX,
                      CY,
                      INCY,
                      C,
                      S);
}

//-- cspcon --------------------------------------------------------------------
void
LAPACK_DECL(cspcon)(const char           *UPLO,
                    const INTEGER        *N,
                    const FLOAT_COMPLEX  *AP,
                    const INTEGER        *IPIV,
                    const FLOAT          *ANORM,
                    FLOAT                *RCOND,
                    FLOAT_COMPLEX        *WORK,
                    INTEGER              *INFO)
{
    DEBUG_LAPACK_STUB("cspcon");
    LAPACK_IMPL(cspcon)(UPLO,
                        N,
                        AP,
                        IPIV,
                        ANORM,
                        RCOND,
                        WORK,
                        INFO);
}

//-- cspmv ---------------------------------------------------------------------
void
LAPACK_DECL(cspmv)(const char               *UPLO,
                   const INTEGER            *N,
                   const FLOAT_COMPLEX      *ALPHA,
                   const FLOAT_COMPLEX      *AP,
                   const FLOAT_COMPLEX      *X,
                   const INTEGER            *INCX,
                   const FLOAT_COMPLEX      *BETA,
                   FLOAT_COMPLEX            *Y,
                   const INTEGER            *INCY)
{
    DEBUG_LAPACK_STUB("cspmv");
    LAPACK_IMPL(cspmv)(UPLO,
                       N,
                       ALPHA,
                       AP,
                       X,
                       INCX,
                       BETA,
                       Y,
                       INCY);
}

//-- cspr ----------------------------------------------------------------------
void
LAPACK_DECL(cspr)(const char               *UPLO,
                  const INTEGER            *N,
                  const FLOAT_COMPLEX      *ALPHA,
                  const FLOAT_COMPLEX      *X,
                  const INTEGER            *INCX,
                  FLOAT_COMPLEX            *AP)
{
    DEBUG_LAPACK_STUB("cspr");
    LAPACK_IMPL(cspr)(UPLO,
                      N,
                      ALPHA,
                      X,
                      INCX,
                      AP);
}

//-- csprfs --------------------------------------------------------------------
void
LAPACK_DECL(csprfs)(const char           *UPLO,
                    const INTEGER        *N,
                    const INTEGER        *NRHS,
                    const FLOAT_COMPLEX  *AP,
                    const FLOAT_COMPLEX  *AFP,
                    const INTEGER        *IPIV,
                    const FLOAT_COMPLEX  *B,
                    const INTEGER        *LDB,
                    FLOAT_COMPLEX        *X,
                    const INTEGER        *LDX,
                    FLOAT                *FERR,
                    FLOAT                *BERR,
                    FLOAT_COMPLEX        *WORK,
                    FLOAT                *RWORK,
                    INTEGER              *INFO)
{
    DEBUG_LAPACK_STUB("csprfs");
    LAPACK_IMPL(csprfs)(UPLO,
                        N,
                        NRHS,
                        AP,
                        AFP,
                        IPIV,
                        B,
                        LDB,
                        X,
                        LDX,
                        FERR,
                        BERR,
                        WORK,
                        RWORK,
                        INFO);
}

//-- cspsv ---------------------------------------------------------------------
void
LAPACK_DECL(cspsv)(const char           *UPLO,
                   const INTEGER        *N,
                   const INTEGER        *NRHS,
                   FLOAT_COMPLEX        *AP,
                   INTEGER              *IPIV,
                   FLOAT_COMPLEX        *B,
                   const INTEGER        *LDB,
                   INTEGER              *INFO)
{
    DEBUG_LAPACK_STUB("cspsv");
    LAPACK_IMPL(cspsv)(UPLO,
                       N,
                       NRHS,
                       AP,
                       IPIV,
                       B,
                       LDB,
                       INFO);
}

//-- cspsvx --------------------------------------------------------------------
void
LAPACK_DECL(cspsvx)(const char           *FACT,
                    const char           *UPLO,
                    const INTEGER        *N,
                    const INTEGER        *NRHS,
                    const FLOAT_COMPLEX  *AP,
                    FLOAT_COMPLEX        *AFP,
                    INTEGER              *IPIV,
                    const FLOAT_COMPLEX  *B,
                    const INTEGER        *LDB,
                    FLOAT_COMPLEX        *X,
                    const INTEGER        *LDX,
                    FLOAT                *RCOND,
                    FLOAT                *FERR,
                    FLOAT                *BERR,
                    FLOAT_COMPLEX        *WORK,
                    FLOAT                *RWORK,
                    INTEGER              *INFO)
{
    DEBUG_LAPACK_STUB("cspsvx");
    LAPACK_IMPL(cspsvx)(FACT,
                        UPLO,
                        N,
                        NRHS,
                        AP,
                        AFP,
                        IPIV,
                        B,
                        LDB,
                        X,
                        LDX,
                        RCOND,
                        FERR,
                        BERR,
                        WORK,
                        RWORK,
                        INFO);
}

//-- csptrf --------------------------------------------------------------------
void
LAPACK_DECL(csptrf)(const char       *UPLO,
                    const INTEGER    *N,
                    FLOAT_COMPLEX    *AP,
                    INTEGER          *IPIV,
                    INTEGER          *INFO)
{
    DEBUG_LAPACK_STUB("csptrf");
    LAPACK_IMPL(csptrf)(UPLO,
                        N,
                        AP,
                        IPIV,
                        INFO);
}

//-- csptri --------------------------------------------------------------------
void
LAPACK_DECL(csptri)(const char       *UPLO,
                    const INTEGER    *N,
                    FLOAT_COMPLEX    *AP,
                    const INTEGER    *IPIV,
                    FLOAT_COMPLEX    *WORK,
                    INTEGER          *INFO)
{
    DEBUG_LAPACK_STUB("csptri");
    LAPACK_IMPL(csptri)(UPLO,
                        N,
                        AP,
                        IPIV,
                        WORK,
                        INFO);
}

//-- csptrs --------------------------------------------------------------------
void
LAPACK_DECL(csptrs)(const char           *UPLO,
                    const INTEGER        *N,
                    const INTEGER        *NRHS,
                    const FLOAT_COMPLEX  *AP,
                    const INTEGER        *IPIV,
                    FLOAT_COMPLEX        *B,
                    const INTEGER        *LDB,
                    INTEGER              *INFO)
{
    DEBUG_LAPACK_STUB("csptrs");
    LAPACK_IMPL(csptrs)(UPLO,
                        N,
                        NRHS,
                        AP,
                        IPIV,
                        B,
                        LDB,
                        INFO);
}

//-- csrscl --------------------------------------------------------------------
void
LAPACK_DECL(csrscl)(const INTEGER    *N,
                    const FLOAT      *SA,
                    FLOAT_COMPLEX    *SX,
                    const INTEGER    *INCX)
{
    DEBUG_LAPACK_STUB("csrscl");
    LAPACK_IMPL(csrscl)(N,
                        SA,
                        SX,
                        INCX);
}

//-- cstedc --------------------------------------------------------------------
void
LAPACK_DECL(cstedc)(const char       *COMPZ,
                    const INTEGER    *N,
                    FLOAT            *D,
                    FLOAT            *E,
                    FLOAT_COMPLEX    *Z,
                    const INTEGER    *LDZ,
                    FLOAT_COMPLEX    *WORK,
                    const INTEGER    *LWORK,
                    FLOAT            *RWORK,
                    const INTEGER    *LRWORK,
                    INTEGER          *IWORK,
                    const INTEGER    *LIWORK,
                    INTEGER          *INFO)
{
    DEBUG_LAPACK_STUB("cstedc");
    LAPACK_IMPL(cstedc)(COMPZ,
                        N,
                        D,
                        E,
                        Z,
                        LDZ,
                        WORK,
                        LWORK,
                        RWORK,
                        LRWORK,
                        IWORK,
                        LIWORK,
                        INFO);
}

//-- cstegr --------------------------------------------------------------------
void
LAPACK_DECL(cstegr)(const char       *JOBZ,
                    const char       *RANGE,
                    const INTEGER    *N,
                    FLOAT            *D,
                    FLOAT            *E,
                    const FLOAT      *VL,
                    const FLOAT      *VU,
                    const INTEGER    *IL,
                    const INTEGER    *IU,
                    const FLOAT      *ABSTOL,
                    INTEGER          *M,
                    FLOAT            *W,
                    FLOAT_COMPLEX    *Z,
                    const INTEGER    *LDZ,
                    INTEGER          *ISUPPZ,
                    FLOAT            *WORK,
                    const INTEGER    *LWORK,
                    INTEGER          *IWORK,
                    const INTEGER    *LIWORK,
                    INTEGER          *INFO)
{
    DEBUG_LAPACK_STUB("cstegr");
    LAPACK_IMPL(cstegr)(JOBZ,
                        RANGE,
                        N,
                        D,
                        E,
                        VL,
                        VU,
                        IL,
                        IU,
                        ABSTOL,
                        M,
                        W,
                        Z,
                        LDZ,
                        ISUPPZ,
                        WORK,
                        LWORK,
                        IWORK,
                        LIWORK,
                        INFO);
}

//-- cstein --------------------------------------------------------------------
void
LAPACK_DECL(cstein)(const INTEGER    *N,
                    const FLOAT      *D,
                    const FLOAT      *E,
                    const INTEGER    *M,
                    const FLOAT      *W,
                    const INTEGER    *IBLOCK,
                    const INTEGER    *ISPLIT,
                    FLOAT_COMPLEX    *Z,
                    const INTEGER    *LDZ,
                    FLOAT            *WORK,
                    INTEGER          *IWORK,
                    INTEGER          *IFAIL,
                    INTEGER          *INFO)
{
    DEBUG_LAPACK_STUB("cstein");
    LAPACK_IMPL(cstein)(N,
                        D,
                        E,
                        M,
                        W,
                        IBLOCK,
                        ISPLIT,
                        Z,
                        LDZ,
                        WORK,
                        IWORK,
                        IFAIL,
                        INFO);
}

//-- cstemr --------------------------------------------------------------------
void
LAPACK_DECL(cstemr)(const char       *JOBZ,
                    const char       *RANGE,
                    const INTEGER    *N,
                    FLOAT            *D,
                    FLOAT            *E,
                    const FLOAT      *VL,
                    const FLOAT      *VU,
                    const INTEGER    *IL,
                    const INTEGER    *IU,
                    INTEGER          *M,
                    FLOAT            *W,
                    FLOAT_COMPLEX    *Z,
                    const INTEGER    *LDZ,
                    const INTEGER    *NZC,
                    INTEGER          *ISUPPZ,
                    LOGICAL          *TRYRAC,
                    FLOAT            *WORK,
                    const INTEGER    *LWORK,
                    INTEGER          *IWORK,
                    const INTEGER    *LIWORK,
                    INTEGER          *INFO)
{
    DEBUG_LAPACK_STUB("cstemr");
    LAPACK_IMPL(cstemr)(JOBZ,
                        RANGE,
                        N,
                        D,
                        E,
                        VL,
                        VU,
                        IL,
                        IU,
                        M,
                        W,
                        Z,
                        LDZ,
                        NZC,
                        ISUPPZ,
                        TRYRAC,
                        WORK,
                        LWORK,
                        IWORK,
                        LIWORK,
                        INFO);
}

//-- csteqr --------------------------------------------------------------------
void
LAPACK_DECL(csteqr)(const char       *COMPZ,
                    const INTEGER    *N,
                    FLOAT            *D,
                    FLOAT            *E,
                    FLOAT_COMPLEX    *Z,
                    const INTEGER    *LDZ,
                    FLOAT            *WORK,
                    INTEGER          *INFO)
{
    DEBUG_LAPACK_STUB("csteqr");
    LAPACK_IMPL(csteqr)(COMPZ,
                        N,
                        D,
                        E,
                        Z,
                        LDZ,
                        WORK,
                        INFO);
}

//-- csycon --------------------------------------------------------------------
void
LAPACK_DECL(csycon)(const char           *UPLO,
                    const INTEGER        *N,
                    const FLOAT_COMPLEX  *A,
                    const INTEGER        *LDA,
                    const INTEGER        *IPIV,
                    const FLOAT          *ANORM,
                    FLOAT                *RCOND,
                    FLOAT_COMPLEX        *WORK,
                    INTEGER              *INFO)
{
    DEBUG_LAPACK_STUB("csycon");
    LAPACK_IMPL(csycon)(UPLO,
                        N,
                        A,
                        LDA,
                        IPIV,
                        ANORM,
                        RCOND,
                        WORK,
                        INFO);
}

//-- csyconv -------------------------------------------------------------------
void
LAPACK_DECL(csyconv)(const char               *UPLO,
                     const char               *WAY,
                     const INTEGER            *N,
                     const FLOAT_COMPLEX      *A,
                     const INTEGER            *LDA,
                     const INTEGER            *IPIV,
                     FLOAT_COMPLEX            *WORK,
                     INTEGER                  *INFO)
{
    DEBUG_LAPACK_STUB("csyconv");
    LAPACK_IMPL(csyconv)(UPLO,
                         WAY,
                         N,
                         A,
                         LDA,
                         IPIV,
                         WORK,
                         INFO);
}

//-- csyequb -------------------------------------------------------------------
void
LAPACK_DECL(csyequb)(const char               *UPLO,
                     const INTEGER            *N,
                     const FLOAT_COMPLEX      *A,
                     const INTEGER            *LDA,
                     FLOAT                    *S,
                     FLOAT                    *SCOND,
                     FLOAT                    *AMAX,
                     FLOAT_COMPLEX            *WORK,
                     INTEGER                  *INFO)
{
    DEBUG_LAPACK_STUB("csyequb");
    LAPACK_IMPL(csyequb)(UPLO,
                         N,
                         A,
                         LDA,
                         S,
                         SCOND,
                         AMAX,
                         WORK,
                         INFO);
}

//-- csymv ---------------------------------------------------------------------
void
LAPACK_DECL(csymv)(const char               *UPLO,
                   const INTEGER            *N,
                   const FLOAT_COMPLEX      *ALPHA,
                   const FLOAT_COMPLEX      *A,
                   const INTEGER            *LDA,
                   const FLOAT_COMPLEX      *X,
                   const INTEGER            *INCX,
                   const FLOAT_COMPLEX      *BETA,
                   FLOAT_COMPLEX            *Y,
                   const INTEGER            *INCY)
{
    DEBUG_LAPACK_STUB("csymv");
    LAPACK_IMPL(csymv)(UPLO,
                       N,
                       ALPHA,
                       A,
                       LDA,
                       X,
                       INCX,
                       BETA,
                       Y,
                       INCY);
}

//-- csyr ----------------------------------------------------------------------
void
LAPACK_DECL(csyr)(const char               *UPLO,
                  const INTEGER            *N,
                  const FLOAT_COMPLEX      *ALPHA,
                  const FLOAT_COMPLEX      *X,
                  const INTEGER            *INCX,
                  FLOAT_COMPLEX            *A,
                  const INTEGER            *LDA)
{
    DEBUG_LAPACK_STUB("csyr");
    LAPACK_IMPL(csyr)(UPLO,
                      N,
                      ALPHA,
                      X,
                      INCX,
                      A,
                      LDA);
}

//-- csyrfs --------------------------------------------------------------------
void
LAPACK_DECL(csyrfs)(const char           *UPLO,
                    const INTEGER        *N,
                    const INTEGER        *NRHS,
                    const FLOAT_COMPLEX  *A,
                    const INTEGER        *LDA,
                    const FLOAT_COMPLEX  *AF,
                    const INTEGER        *LDAF,
                    const INTEGER        *IPIV,
                    const FLOAT_COMPLEX  *B,
                    const INTEGER        *LDB,
                    FLOAT_COMPLEX        *X,
                    const INTEGER        *LDX,
                    FLOAT                *FERR,
                    FLOAT                *BERR,
                    FLOAT_COMPLEX        *WORK,
                    FLOAT                *RWORK,
                    INTEGER              *INFO)
{
    DEBUG_LAPACK_STUB("csyrfs");
    LAPACK_IMPL(csyrfs)(UPLO,
                        N,
                        NRHS,
                        A,
                        LDA,
                        AF,
                        LDAF,
                        IPIV,
                        B,
                        LDB,
                        X,
                        LDX,
                        FERR,
                        BERR,
                        WORK,
                        RWORK,
                        INFO);
}

//-- csyrfsx -------------------------------------------------------------------
void
LAPACK_DECL(csyrfsx)(const char               *UPLO,
                     const char               *EQUED,
                     const INTEGER            *N,
                     const INTEGER            *NRHS,
                     const FLOAT_COMPLEX      *A,
                     const INTEGER            *LDA,
                     const FLOAT_COMPLEX      *AF,
                     const INTEGER            *LDAF,
                     const INTEGER            *IPIV,
                     FLOAT                    *S,
                     const FLOAT_COMPLEX      *B,
                     const INTEGER            *LDB,
                     FLOAT_COMPLEX            *X,
                     const INTEGER            *LDX,
                     FLOAT                    *RCOND,
                     FLOAT                    *BERR,
                     const INTEGER            *N_ERR_BNDS,
                     FLOAT                    *ERR_BNDS_NORM,
                     FLOAT                    *ERR_BNDS_COMP,
                     const INTEGER            *NPARAMS,
                     FLOAT                    *PARAMS,
                     FLOAT_COMPLEX            *WORK,
                     FLOAT                    *RWORK,
                     INTEGER                  *INFO)
{
    DEBUG_LAPACK_STUB("csyrfsx");
    LAPACK_IMPL(csyrfsx)(UPLO,
                         EQUED,
                         N,
                         NRHS,
                         A,
                         LDA,
                         AF,
                         LDAF,
                         IPIV,
                         S,
                         B,
                         LDB,
                         X,
                         LDX,
                         RCOND,
                         BERR,
                         N_ERR_BNDS,
                         ERR_BNDS_NORM,
                         ERR_BNDS_COMP,
                         NPARAMS,
                         PARAMS,
                         WORK,
                         RWORK,
                         INFO);
}

//-- csysv ---------------------------------------------------------------------
void
LAPACK_DECL(csysv)(const char           *UPLO,
                   const INTEGER        *N,
                   const INTEGER        *NRHS,
                   FLOAT_COMPLEX        *A,
                   const INTEGER        *LDA,
                   INTEGER              *IPIV,
                   FLOAT_COMPLEX        *B,
                   const INTEGER        *LDB,
                   FLOAT_COMPLEX        *WORK,
                   const INTEGER        *LWORK,
                   INTEGER              *INFO)
{
    DEBUG_LAPACK_STUB("csysv");
    LAPACK_IMPL(csysv)(UPLO,
                       N,
                       NRHS,
                       A,
                       LDA,
                       IPIV,
                       B,
                       LDB,
                       WORK,
                       LWORK,
                       INFO);
}

//-- csysvx --------------------------------------------------------------------
void
LAPACK_DECL(csysvx)(const char           *FACT,
                    const char           *UPLO,
                    const INTEGER        *N,
                    const INTEGER        *NRHS,
                    const FLOAT_COMPLEX  *A,
                    const INTEGER        *LDA,
                    FLOAT_COMPLEX        *AF,
                    const INTEGER        *LDAF,
                    INTEGER              *IPIV,
                    const FLOAT_COMPLEX  *B,
                    const INTEGER        *LDB,
                    FLOAT_COMPLEX        *X,
                    const INTEGER        *LDX,
                    FLOAT                *RCOND,
                    FLOAT                *FERR,
                    FLOAT                *BERR,
                    FLOAT_COMPLEX        *WORK,
                    const INTEGER        *LWORK,
                    FLOAT                *RWORK,
                    INTEGER              *INFO)
{
    DEBUG_LAPACK_STUB("csysvx");
    LAPACK_IMPL(csysvx)(FACT,
                        UPLO,
                        N,
                        NRHS,
                        A,
                        LDA,
                        AF,
                        LDAF,
                        IPIV,
                        B,
                        LDB,
                        X,
                        LDX,
                        RCOND,
                        FERR,
                        BERR,
                        WORK,
                        LWORK,
                        RWORK,
                        INFO);
}

//-- csysvxx -------------------------------------------------------------------
void
LAPACK_DECL(csysvxx)(const char       *FACT,
                     const char       *UPLO,
                     const INTEGER    *N,
                     const INTEGER    *NRHS,
                     FLOAT_COMPLEX    *A,
                     const INTEGER    *LDA,
                     FLOAT_COMPLEX    *AF,
                     const INTEGER    *LDAF,
                     INTEGER          *IPIV,
                     char             *EQUED,
                     FLOAT            *S,
                     FLOAT_COMPLEX    *B,
                     const INTEGER    *LDB,
                     FLOAT_COMPLEX    *X,
                     const INTEGER    *LDX,
                     FLOAT            *RCOND,
                     FLOAT            *RPVGRW,
                     FLOAT            *BERR,
                     const INTEGER    *N_ERR_BNDS,
                     FLOAT            *ERR_BNDS_NORM,
                     FLOAT            *ERR_BNDS_COMP,
                     const INTEGER    *NPARAMS,
                     FLOAT            *PARAMS,
                     FLOAT_COMPLEX    *WORK,
                     FLOAT            *RWORK,
                     INTEGER          *INFO)
{
    DEBUG_LAPACK_STUB("csysvxx");
    LAPACK_IMPL(csysvxx)(FACT,
                         UPLO,
                         N,
                         NRHS,
                         A,
                         LDA,
                         AF,
                         LDAF,
                         IPIV,
                         EQUED,
                         S,
                         B,
                         LDB,
                         X,
                         LDX,
                         RCOND,
                         RPVGRW,
                         BERR,
                         N_ERR_BNDS,
                         ERR_BNDS_NORM,
                         ERR_BNDS_COMP,
                         NPARAMS,
                         PARAMS,
                         WORK,
                         RWORK,
                         INFO);
}

//-- csyswapr ------------------------------------------------------------------
void
LAPACK_DECL(csyswapr)(const char       *UPLO,
                      const INTEGER    *N,
                      FLOAT_COMPLEX    *A,
                      const INTEGER    *LDA,
                      const INTEGER    *I1,
                      const INTEGER    *I2)
{
    DEBUG_LAPACK_STUB("csyswapr");
    LAPACK_IMPL(csyswapr)(UPLO,
                          N,
                          A,
                          LDA,
                          I1,
                          I2);
}

//-- csytf2 --------------------------------------------------------------------
void
LAPACK_DECL(csytf2)(const char       *UPLO,
                    const INTEGER    *N,
                    FLOAT_COMPLEX    *A,
                    const INTEGER    *LDA,
                    INTEGER          *IPIV,
                    INTEGER          *INFO)
{
    DEBUG_LAPACK_STUB("csytf2");
    LAPACK_IMPL(csytf2)(UPLO,
                        N,
                        A,
                        LDA,
                        IPIV,
                        INFO);
}

//-- csytrf --------------------------------------------------------------------
void
LAPACK_DECL(csytrf)(const char       *UPLO,
                    const INTEGER    *N,
                    FLOAT_COMPLEX    *A,
                    const INTEGER    *LDA,
                    INTEGER          *IPIV,
                    FLOAT_COMPLEX    *WORK,
                    const INTEGER    *LWORK,
                    INTEGER          *INFO)
{
    DEBUG_LAPACK_STUB("csytrf");
    LAPACK_IMPL(csytrf)(UPLO,
                        N,
                        A,
                        LDA,
                        IPIV,
                        WORK,
                        LWORK,
                        INFO);
}

//-- csytri --------------------------------------------------------------------
void
LAPACK_DECL(csytri)(const char       *UPLO,
                    const INTEGER    *N,
                    FLOAT_COMPLEX    *A,
                    const INTEGER    *LDA,
                    const INTEGER    *IPIV,
                    FLOAT_COMPLEX    *WORK,
                    INTEGER          *INFO)
{
    DEBUG_LAPACK_STUB("csytri");
    LAPACK_IMPL(csytri)(UPLO,
                        N,
                        A,
                        LDA,
                        IPIV,
                        WORK,
                        INFO);
}

//-- csytri2 -------------------------------------------------------------------
void
LAPACK_DECL(csytri2)(const char       *UPLO,
                     const INTEGER    *N,
                     FLOAT_COMPLEX    *A,
                     const INTEGER    *LDA,
                     const INTEGER    *IPIV,
                     FLOAT_COMPLEX    *WORK,
                     const INTEGER    *LWORK,
                     INTEGER          *INFO)
{
    DEBUG_LAPACK_STUB("csytri2");
    LAPACK_IMPL(csytri2)(UPLO,
                         N,
                         A,
                         LDA,
                         IPIV,
                         WORK,
                         LWORK,
                         INFO);
}

//-- csytri2x ------------------------------------------------------------------
void
LAPACK_DECL(csytri2x)(const char       *UPLO,
                      const INTEGER    *N,
                      FLOAT_COMPLEX    *A,
                      const INTEGER    *LDA,
                      const INTEGER    *IPIV,
                      FLOAT_COMPLEX    *WORK,
                      const INTEGER    *NB,
                      INTEGER          *INFO)
{
    DEBUG_LAPACK_STUB("csytri2x");
    LAPACK_IMPL(csytri2x)(UPLO,
                          N,
                          A,
                          LDA,
                          IPIV,
                          WORK,
                          NB,
                          INFO);
}

//-- csytrs --------------------------------------------------------------------
void
LAPACK_DECL(csytrs)(const char           *UPLO,
                    const INTEGER        *N,
                    const INTEGER        *NRHS,
                    const FLOAT_COMPLEX  *A,
                    const INTEGER        *LDA,
                    const INTEGER        *IPIV,
                    FLOAT_COMPLEX        *B,
                    const INTEGER        *LDB,
                    INTEGER              *INFO)
{
    DEBUG_LAPACK_STUB("csytrs");
    LAPACK_IMPL(csytrs)(UPLO,
                        N,
                        NRHS,
                        A,
                        LDA,
                        IPIV,
                        B,
                        LDB,
                        INFO);
}

//-- csytrs2 -------------------------------------------------------------------
void
LAPACK_DECL(csytrs2)(const char               *UPLO,
                     const INTEGER            *N,
                     const INTEGER            *NRHS,
                     const FLOAT_COMPLEX      *A,
                     const INTEGER            *LDA,
                     const INTEGER            *IPIV,
                     FLOAT_COMPLEX            *B,
                     const INTEGER            *LDB,
                     FLOAT_COMPLEX            *WORK,
                     INTEGER                  *INFO)
{
    DEBUG_LAPACK_STUB("csytrs2");
    LAPACK_IMPL(csytrs2)(UPLO,
                         N,
                         NRHS,
                         A,
                         LDA,
                         IPIV,
                         B,
                         LDB,
                         WORK,
                         INFO);
}

//-- ctbcon --------------------------------------------------------------------
void
LAPACK_DECL(ctbcon)(const char           *NORM,
                    const char           *UPLO,
                    const char           *DIAG,
                    const INTEGER        *N,
                    const INTEGER        *KD,
                    const FLOAT_COMPLEX  *AB,
                    const INTEGER        *LDAB,
                    FLOAT                *RCOND,
                    FLOAT_COMPLEX        *WORK,
                    FLOAT                *RWORK,
                    INTEGER              *INFO)
{
    DEBUG_LAPACK_STUB("ctbcon");
    LAPACK_IMPL(ctbcon)(NORM,
                        UPLO,
                        DIAG,
                        N,
                        KD,
                        AB,
                        LDAB,
                        RCOND,
                        WORK,
                        RWORK,
                        INFO);
}

//-- ctbrfs --------------------------------------------------------------------
void
LAPACK_DECL(ctbrfs)(const char           *UPLO,
                    const char           *TRANS,
                    const char           *DIAG,
                    const INTEGER        *N,
                    const INTEGER        *KD,
                    const INTEGER        *NRHS,
                    const FLOAT_COMPLEX  *AB,
                    const INTEGER        *LDAB,
                    const FLOAT_COMPLEX  *B,
                    const INTEGER        *LDB,
                    const FLOAT_COMPLEX  *X,
                    const INTEGER        *LDX,
                    FLOAT                *FERR,
                    FLOAT                *BERR,
                    FLOAT_COMPLEX        *WORK,
                    FLOAT                *RWORK,
                    INTEGER              *INFO)
{
    DEBUG_LAPACK_STUB("ctbrfs");
    LAPACK_IMPL(ctbrfs)(UPLO,
                        TRANS,
                        DIAG,
                        N,
                        KD,
                        NRHS,
                        AB,
                        LDAB,
                        B,
                        LDB,
                        X,
                        LDX,
                        FERR,
                        BERR,
                        WORK,
                        RWORK,
                        INFO);
}

//-- ctbtrs --------------------------------------------------------------------
void
LAPACK_DECL(ctbtrs)(const char           *UPLO,
                    const char           *TRANS,
                    const char           *DIAG,
                    const INTEGER        *N,
                    const INTEGER        *KD,
                    const INTEGER        *NRHS,
                    const FLOAT_COMPLEX  *AB,
                    const INTEGER        *LDAB,
                    FLOAT_COMPLEX        *B,
                    const INTEGER        *LDB,
                    INTEGER              *INFO)
{
    DEBUG_LAPACK_STUB("ctbtrs");
    LAPACK_IMPL(ctbtrs)(UPLO,
                        TRANS,
                        DIAG,
                        N,
                        KD,
                        NRHS,
                        AB,
                        LDAB,
                        B,
                        LDB,
                        INFO);
}

//-- ctfsm ---------------------------------------------------------------------
void
LAPACK_DECL(ctfsm)(const char               *TRANSR,
                   const char               *SIDE,
                   const char               *UPLO,
                   const char               *TRANS,
                   const char               *DIAG,
                   const INTEGER            *M,
                   const INTEGER            *N,
                   const FLOAT_COMPLEX      *ALPHA,
                   const FLOAT_COMPLEX      *A,
                   FLOAT_COMPLEX            *B,
                   const INTEGER            *LDB)
{
    DEBUG_LAPACK_STUB("ctfsm");
    LAPACK_IMPL(ctfsm)(TRANSR,
                       SIDE,
                       UPLO,
                       TRANS,
                       DIAG,
                       M,
                       N,
                       ALPHA,
                       A,
                       B,
                       LDB);
}

//-- ctftri --------------------------------------------------------------------
void
LAPACK_DECL(ctftri)(const char       *TRANSR,
                    const char       *UPLO,
                    const char       *DIAG,
                    const INTEGER    *N,
                    FLOAT_COMPLEX    *A,
                    INTEGER          *INFO)
{
    DEBUG_LAPACK_STUB("ctftri");
    LAPACK_IMPL(ctftri)(TRANSR,
                        UPLO,
                        DIAG,
                        N,
                        A,
                        INFO);
}

//-- ctfttp --------------------------------------------------------------------
void
LAPACK_DECL(ctfttp)(const char           *TRANSR,
                    const char           *UPLO,
                    const INTEGER        *N,
                    const FLOAT_COMPLEX  *ARF,
                    FLOAT_COMPLEX        *AP,
                    INTEGER              *INFO)
{
    DEBUG_LAPACK_STUB("ctfttp");
    LAPACK_IMPL(ctfttp)(TRANSR,
                        UPLO,
                        N,
                        ARF,
                        AP,
                        INFO);
}

//-- ctfttr --------------------------------------------------------------------
void
LAPACK_DECL(ctfttr)(const char           *TRANSR,
                    const char           *UPLO,
                    const INTEGER        *N,
                    const FLOAT_COMPLEX  *ARF,
                    FLOAT_COMPLEX        *A,
                    const INTEGER        *LDA,
                    INTEGER              *INFO)
{
    DEBUG_LAPACK_STUB("ctfttr");
    LAPACK_IMPL(ctfttr)(TRANSR,
                        UPLO,
                        N,
                        ARF,
                        A,
                        LDA,
                        INFO);
}

//-- ctgevc --------------------------------------------------------------------
void
LAPACK_DECL(ctgevc)(const char           *SIDE,
                    const char           *HOWMNY,
                    const LOGICAL        *SELECT,
                    const INTEGER        *N,
                    const FLOAT_COMPLEX  *S,
                    const INTEGER        *LDS,
                    const FLOAT_COMPLEX  *P,
                    const INTEGER        *LDP,
                    FLOAT_COMPLEX        *VL,
                    const INTEGER        *LDVL,
                    FLOAT_COMPLEX        *VR,
                    const INTEGER        *LDVR,
                    const INTEGER        *MM,
                    INTEGER              *M,
                    FLOAT_COMPLEX        *WORK,
                    FLOAT                *RWORK,
                    INTEGER              *INFO)
{
    DEBUG_LAPACK_STUB("ctgevc");
    LAPACK_IMPL(ctgevc)(SIDE,
                        HOWMNY,
                        SELECT,
                        N,
                        S,
                        LDS,
                        P,
                        LDP,
                        VL,
                        LDVL,
                        VR,
                        LDVR,
                        MM,
                        M,
                        WORK,
                        RWORK,
                        INFO);
}

//-- ctgex2 --------------------------------------------------------------------
void
LAPACK_DECL(ctgex2)(const LOGICAL    *WANTQ,
                    const LOGICAL    *WANTZ,
                    const INTEGER    *N,
                    FLOAT_COMPLEX    *A,
                    const INTEGER    *LDA,
                    FLOAT_COMPLEX    *B,
                    const INTEGER    *LDB,
                    FLOAT_COMPLEX    *Q,
                    const INTEGER    *LDQ,
                    FLOAT_COMPLEX    *Z,
                    const INTEGER    *LDZ,
                    const INTEGER    *J1,
                    INTEGER          *INFO)
{
    DEBUG_LAPACK_STUB("ctgex2");
    LAPACK_IMPL(ctgex2)(WANTQ,
                        WANTZ,
                        N,
                        A,
                        LDA,
                        B,
                        LDB,
                        Q,
                        LDQ,
                        Z,
                        LDZ,
                        J1,
                        INFO);
}

//-- ctgexc --------------------------------------------------------------------
void
LAPACK_DECL(ctgexc)(const LOGICAL    *WANTQ,
                    const LOGICAL    *WANTZ,
                    const INTEGER    *N,
                    FLOAT_COMPLEX    *A,
                    const INTEGER    *LDA,
                    FLOAT_COMPLEX    *B,
                    const INTEGER    *LDB,
                    FLOAT_COMPLEX    *Q,
                    const INTEGER    *LDQ,
                    FLOAT_COMPLEX    *Z,
                    const INTEGER    *LDZ,
                    const INTEGER    *IFST,
                    INTEGER          *ILST,
                    INTEGER          *INFO)
{
    DEBUG_LAPACK_STUB("ctgexc");
    LAPACK_IMPL(ctgexc)(WANTQ,
                        WANTZ,
                        N,
                        A,
                        LDA,
                        B,
                        LDB,
                        Q,
                        LDQ,
                        Z,
                        LDZ,
                        IFST,
                        ILST,
                        INFO);
}

//-- ctgsen --------------------------------------------------------------------
void
LAPACK_DECL(ctgsen)(const INTEGER    *IJOB,
                    const LOGICAL    *WANTQ,
                    const LOGICAL    *WANTZ,
                    const LOGICAL    *SELECT,
                    const INTEGER    *N,
                    FLOAT_COMPLEX    *A,
                    const INTEGER    *LDA,
                    FLOAT_COMPLEX    *B,
                    const INTEGER    *LDB,
                    FLOAT_COMPLEX    *ALPHA,
                    FLOAT_COMPLEX    *BETA,
                    FLOAT_COMPLEX    *Q,
                    const INTEGER    *LDQ,
                    FLOAT_COMPLEX    *Z,
                    const INTEGER    *LDZ,
                    INTEGER          *M,
                    FLOAT            *PL,
                    FLOAT            *PR,
                    FLOAT            *DIF,
                    FLOAT_COMPLEX    *WORK,
                    const INTEGER    *LWORK,
                    INTEGER          *IWORK,
                    const INTEGER    *LIWORK,
                    INTEGER          *INFO)
{
    DEBUG_LAPACK_STUB("ctgsen");
    LAPACK_IMPL(ctgsen)(IJOB,
                        WANTQ,
                        WANTZ,
                        SELECT,
                        N,
                        A,
                        LDA,
                        B,
                        LDB,
                        ALPHA,
                        BETA,
                        Q,
                        LDQ,
                        Z,
                        LDZ,
                        M,
                        PL,
                        PR,
                        DIF,
                        WORK,
                        LWORK,
                        IWORK,
                        LIWORK,
                        INFO);
}

//-- ctgsja --------------------------------------------------------------------
void
LAPACK_DECL(ctgsja)(const char       *JOBU,
                    const char       *JOBV,
                    const char       *JOBQ,
                    const INTEGER    *M,
                    const INTEGER    *P,
                    const INTEGER    *N,
                    const INTEGER    *K,
                    const INTEGER    *L,
                    FLOAT_COMPLEX    *A,
                    const INTEGER    *LDA,
                    FLOAT_COMPLEX    *B,
                    const INTEGER    *LDB,
                    const FLOAT      *TOLA,
                    const FLOAT      *TOLB,
                    FLOAT            *ALPHA,
                    FLOAT            *BETA,
                    FLOAT_COMPLEX    *U,
                    const INTEGER    *LDU,
                    FLOAT_COMPLEX    *V,
                    const INTEGER    *LDV,
                    FLOAT_COMPLEX    *Q,
                    const INTEGER    *LDQ,
                    FLOAT_COMPLEX    *WORK,
                    INTEGER          *NCYCLE,
                    INTEGER          *INFO)
{
    DEBUG_LAPACK_STUB("ctgsja");
    LAPACK_IMPL(ctgsja)(JOBU,
                        JOBV,
                        JOBQ,
                        M,
                        P,
                        N,
                        K,
                        L,
                        A,
                        LDA,
                        B,
                        LDB,
                        TOLA,
                        TOLB,
                        ALPHA,
                        BETA,
                        U,
                        LDU,
                        V,
                        LDV,
                        Q,
                        LDQ,
                        WORK,
                        NCYCLE,
                        INFO);
}

//-- ctgsna --------------------------------------------------------------------
void
LAPACK_DECL(ctgsna)(const char           *JOB,
                    const char           *HOWMNY,
                    const LOGICAL        *SELECT,
                    const INTEGER        *N,
                    const FLOAT_COMPLEX  *A,
                    const INTEGER        *LDA,
                    const FLOAT_COMPLEX  *B,
                    const INTEGER        *LDB,
                    const FLOAT_COMPLEX  *VL,
                    const INTEGER        *LDVL,
                    const FLOAT_COMPLEX  *VR,
                    const INTEGER        *LDVR,
                    FLOAT                *S,
                    FLOAT                *DIF,
                    const INTEGER        *MM,
                    INTEGER              *M,
                    FLOAT_COMPLEX        *WORK,
                    const INTEGER        *LWORK,
                    INTEGER              *IWORK,
                    INTEGER              *INFO)
{
    DEBUG_LAPACK_STUB("ctgsna");
    LAPACK_IMPL(ctgsna)(JOB,
                        HOWMNY,
                        SELECT,
                        N,
                        A,
                        LDA,
                        B,
                        LDB,
                        VL,
                        LDVL,
                        VR,
                        LDVR,
                        S,
                        DIF,
                        MM,
                        M,
                        WORK,
                        LWORK,
                        IWORK,
                        INFO);
}

//-- ctgsy2 --------------------------------------------------------------------
void
LAPACK_DECL(ctgsy2)(const char           *TRANS,
                    const INTEGER        *IJOB,
                    const INTEGER        *M,
                    const INTEGER        *N,
                    const FLOAT_COMPLEX  *A,
                    const INTEGER        *LDA,
                    const FLOAT_COMPLEX  *B,
                    const INTEGER        *LDB,
                    FLOAT_COMPLEX        *C,
                    const INTEGER        *LDC,
                    const FLOAT_COMPLEX  *D,
                    const INTEGER        *LDD,
                    const FLOAT_COMPLEX  *E,
                    const INTEGER        *LDE,
                    FLOAT_COMPLEX        *F,
                    const INTEGER        *LDF,
                    FLOAT                *SCALE,
                    FLOAT                *RDSUM,
                    FLOAT                *RDSCAL,
                    INTEGER              *INFO)
{
    DEBUG_LAPACK_STUB("ctgsy2");
    LAPACK_IMPL(ctgsy2)(TRANS,
                        IJOB,
                        M,
                        N,
                        A,
                        LDA,
                        B,
                        LDB,
                        C,
                        LDC,
                        D,
                        LDD,
                        E,
                        LDE,
                        F,
                        LDF,
                        SCALE,
                        RDSUM,
                        RDSCAL,
                        INFO);
}

//-- ctgsyl --------------------------------------------------------------------
void
LAPACK_DECL(ctgsyl)(const char           *TRANS,
                    const INTEGER        *IJOB,
                    const INTEGER        *M,
                    const INTEGER        *N,
                    const FLOAT_COMPLEX  *A,
                    const INTEGER        *LDA,
                    const FLOAT_COMPLEX  *B,
                    const INTEGER        *LDB,
                    FLOAT_COMPLEX        *C,
                    const INTEGER        *LDC,
                    const FLOAT_COMPLEX  *D,
                    const INTEGER        *LDD,
                    const FLOAT_COMPLEX  *E,
                    const INTEGER        *LDE,
                    FLOAT_COMPLEX        *F,
                    const INTEGER        *LDF,
                    FLOAT                *SCALE,
                    FLOAT                *DIF,
                    FLOAT_COMPLEX        *WORK,
                    const INTEGER        *LWORK,
                    INTEGER              *IWORK,
                    INTEGER              *INFO)
{
    DEBUG_LAPACK_STUB("ctgsyl");
    LAPACK_IMPL(ctgsyl)(TRANS,
                        IJOB,
                        M,
                        N,
                        A,
                        LDA,
                        B,
                        LDB,
                        C,
                        LDC,
                        D,
                        LDD,
                        E,
                        LDE,
                        F,
                        LDF,
                        SCALE,
                        DIF,
                        WORK,
                        LWORK,
                        IWORK,
                        INFO);
}

//-- ctpcon --------------------------------------------------------------------
void
LAPACK_DECL(ctpcon)(const char           *NORM,
                    const char           *UPLO,
                    const char           *DIAG,
                    const INTEGER        *N,
                    const FLOAT_COMPLEX  *AP,
                    FLOAT                *RCOND,
                    FLOAT_COMPLEX        *WORK,
                    FLOAT                *RWORK,
                    INTEGER              *INFO)
{
    DEBUG_LAPACK_STUB("ctpcon");
    LAPACK_IMPL(ctpcon)(NORM,
                        UPLO,
                        DIAG,
                        N,
                        AP,
                        RCOND,
                        WORK,
                        RWORK,
                        INFO);
}

//-- ctprfs --------------------------------------------------------------------
void
LAPACK_DECL(ctprfs)(const char           *UPLO,
                    const char           *TRANS,
                    const char           *DIAG,
                    const INTEGER        *N,
                    const INTEGER        *NRHS,
                    const FLOAT_COMPLEX  *AP,
                    const FLOAT_COMPLEX  *B,
                    const INTEGER        *LDB,
                    const FLOAT_COMPLEX  *X,
                    const INTEGER        *LDX,
                    FLOAT                *FERR,
                    FLOAT                *BERR,
                    FLOAT_COMPLEX        *WORK,
                    FLOAT                *RWORK,
                    INTEGER              *INFO)
{
    DEBUG_LAPACK_STUB("ctprfs");
    LAPACK_IMPL(ctprfs)(UPLO,
                        TRANS,
                        DIAG,
                        N,
                        NRHS,
                        AP,
                        B,
                        LDB,
                        X,
                        LDX,
                        FERR,
                        BERR,
                        WORK,
                        RWORK,
                        INFO);
}

//-- ctptri --------------------------------------------------------------------
void
LAPACK_DECL(ctptri)(const char       *UPLO,
                    const char       *DIAG,
                    const INTEGER    *N,
                    FLOAT_COMPLEX    *AP,
                    INTEGER          *INFO)
{
    DEBUG_LAPACK_STUB("ctptri");
    LAPACK_IMPL(ctptri)(UPLO,
                        DIAG,
                        N,
                        AP,
                        INFO);
}

//-- ctptrs --------------------------------------------------------------------
void
LAPACK_DECL(ctptrs)(const char           *UPLO,
                    const char           *TRANS,
                    const char           *DIAG,
                    const INTEGER        *N,
                    const INTEGER        *NRHS,
                    const FLOAT_COMPLEX  *AP,
                    FLOAT_COMPLEX        *B,
                    const INTEGER        *LDB,
                    INTEGER              *INFO)
{
    DEBUG_LAPACK_STUB("ctptrs");
    LAPACK_IMPL(ctptrs)(UPLO,
                        TRANS,
                        DIAG,
                        N,
                        NRHS,
                        AP,
                        B,
                        LDB,
                        INFO);
}

//-- ctpttf --------------------------------------------------------------------
void
LAPACK_DECL(ctpttf)(const char           *TRANSR,
                    const char           *UPLO,
                    const INTEGER        *N,
                    const FLOAT_COMPLEX  *AP,
                    FLOAT_COMPLEX        *ARF,
                    INTEGER              *INFO)
{
    DEBUG_LAPACK_STUB("ctpttf");
    LAPACK_IMPL(ctpttf)(TRANSR,
                        UPLO,
                        N,
                        AP,
                        ARF,
                        INFO);
}

//-- ctpttr --------------------------------------------------------------------
void
LAPACK_DECL(ctpttr)(const char           *UPLO,
                    const INTEGER        *N,
                    const FLOAT_COMPLEX  *AP,
                    FLOAT_COMPLEX        *A,
                    const INTEGER        *LDA,
                    INTEGER              *INFO)
{
    DEBUG_LAPACK_STUB("ctpttr");
    LAPACK_IMPL(ctpttr)(UPLO,
                        N,
                        AP,
                        A,
                        LDA,
                        INFO);
}

//-- ctrcon --------------------------------------------------------------------
void
LAPACK_DECL(ctrcon)(const char           *NORM,
                    const char           *UPLO,
                    const char           *DIAG,
                    const INTEGER        *N,
                    const FLOAT_COMPLEX  *A,
                    const INTEGER        *LDA,
                    FLOAT                *RCOND,
                    FLOAT_COMPLEX        *WORK,
                    FLOAT                *RWORK,
                    INTEGER              *INFO)
{
    DEBUG_LAPACK_STUB("ctrcon");
    LAPACK_IMPL(ctrcon)(NORM,
                        UPLO,
                        DIAG,
                        N,
                        A,
                        LDA,
                        RCOND,
                        WORK,
                        RWORK,
                        INFO);
}

//-- ctrevc --------------------------------------------------------------------
void
LAPACK_DECL(ctrevc)(const char       *SIDE,
                    const char       *HOWMNY,
                    const LOGICAL    *SELECT,
                    const INTEGER    *N,
                    FLOAT_COMPLEX    *T,
                    const INTEGER    *LDT,
                    FLOAT_COMPLEX    *VL,
                    const INTEGER    *LDVL,
                    FLOAT_COMPLEX    *VR,
                    const INTEGER    *LDVR,
                    const INTEGER    *MM,
                    INTEGER          *M,
                    FLOAT_COMPLEX    *WORK,
                    FLOAT            *RWORK,
                    INTEGER          *INFO)
{
    DEBUG_LAPACK_STUB("ctrevc");
    LAPACK_IMPL(ctrevc)(SIDE,
                        HOWMNY,
                        SELECT,
                        N,
                        T,
                        LDT,
                        VL,
                        LDVL,
                        VR,
                        LDVR,
                        MM,
                        M,
                        WORK,
                        RWORK,
                        INFO);
}

//-- ctrexc --------------------------------------------------------------------
void
LAPACK_DECL(ctrexc)(const char       *COMPQ,
                    const INTEGER    *N,
                    FLOAT_COMPLEX    *T,
                    const INTEGER    *LDT,
                    FLOAT_COMPLEX    *Q,
                    const INTEGER    *LDQ,
                    const INTEGER    *IFST,
                    const INTEGER    *ILST,
                    INTEGER          *INFO)
{
    DEBUG_LAPACK_STUB("ctrexc");
    LAPACK_IMPL(ctrexc)(COMPQ,
                        N,
                        T,
                        LDT,
                        Q,
                        LDQ,
                        IFST,
                        ILST,
                        INFO);
}

//-- ctrrfs --------------------------------------------------------------------
void
LAPACK_DECL(ctrrfs)(const char           *UPLO,
                    const char           *TRANS,
                    const char           *DIAG,
                    const INTEGER        *N,
                    const INTEGER        *NRHS,
                    const FLOAT_COMPLEX  *A,
                    const INTEGER        *LDA,
                    const FLOAT_COMPLEX  *B,
                    const INTEGER        *LDB,
                    const FLOAT_COMPLEX  *X,
                    const INTEGER        *LDX,
                    FLOAT                *FERR,
                    FLOAT                *BERR,
                    FLOAT_COMPLEX        *WORK,
                    FLOAT                *RWORK,
                    INTEGER              *INFO)
{
    DEBUG_LAPACK_STUB("ctrrfs");
    LAPACK_IMPL(ctrrfs)(UPLO,
                        TRANS,
                        DIAG,
                        N,
                        NRHS,
                        A,
                        LDA,
                        B,
                        LDB,
                        X,
                        LDX,
                        FERR,
                        BERR,
                        WORK,
                        RWORK,
                        INFO);
}

//-- ctrsen --------------------------------------------------------------------
void
LAPACK_DECL(ctrsen)(const char       *JOB,
                    const char       *COMPQ,
                    const LOGICAL    *SELECT,
                    const INTEGER    *N,
                    FLOAT_COMPLEX    *T,
                    const INTEGER    *LDT,
                    FLOAT_COMPLEX    *Q,
                    const INTEGER    *LDQ,
                    FLOAT_COMPLEX    *W,
                    INTEGER          *M,
                    FLOAT            *S,
                    FLOAT            *SEP,
                    FLOAT_COMPLEX    *WORK,
                    const INTEGER    *LWORK,
                    INTEGER          *INFO)
{
    DEBUG_LAPACK_STUB("ctrsen");
    LAPACK_IMPL(ctrsen)(JOB,
                        COMPQ,
                        SELECT,
                        N,
                        T,
                        LDT,
                        Q,
                        LDQ,
                        W,
                        M,
                        S,
                        SEP,
                        WORK,
                        LWORK,
                        INFO);
}

//-- ctrsna --------------------------------------------------------------------
void
LAPACK_DECL(ctrsna)(const char           *JOB,
                    const char           *HOWMNY,
                    const LOGICAL        *SELECT,
                    const INTEGER        *N,
                    const FLOAT_COMPLEX  *T,
                    const INTEGER        *LDT,
                    const FLOAT_COMPLEX  *VL,
                    const INTEGER        *LDVL,
                    const FLOAT_COMPLEX  *VR,
                    const INTEGER        *LDVR,
                    FLOAT                *S,
                    FLOAT                *SEP,
                    const INTEGER        *MM,
                    INTEGER              *M,
                    FLOAT_COMPLEX        *WORK,
                    const INTEGER        *LDWORK,
                    FLOAT                *RWORK,
                    INTEGER              *INFO)
{
    DEBUG_LAPACK_STUB("ctrsna");
    LAPACK_IMPL(ctrsna)(JOB,
                        HOWMNY,
                        SELECT,
                        N,
                        T,
                        LDT,
                        VL,
                        LDVL,
                        VR,
                        LDVR,
                        S,
                        SEP,
                        MM,
                        M,
                        WORK,
                        LDWORK,
                        RWORK,
                        INFO);
}

//-- ctrsyl --------------------------------------------------------------------
void
LAPACK_DECL(ctrsyl)(const char           *TRANA,
                    const char           *TRANB,
                    const INTEGER        *ISGN,
                    const INTEGER        *M,
                    const INTEGER        *N,
                    const FLOAT_COMPLEX  *A,
                    const INTEGER        *LDA,
                    const FLOAT_COMPLEX  *B,
                    const INTEGER        *LDB,
                    FLOAT_COMPLEX        *C,
                    const INTEGER        *LDC,
                    FLOAT                *SCALE,
                    INTEGER              *INFO)
{
    DEBUG_LAPACK_STUB("ctrsyl");
    LAPACK_IMPL(ctrsyl)(TRANA,
                        TRANB,
                        ISGN,
                        M,
                        N,
                        A,
                        LDA,
                        B,
                        LDB,
                        C,
                        LDC,
                        SCALE,
                        INFO);
}

//-- ctrti2 --------------------------------------------------------------------
void
LAPACK_DECL(ctrti2)(const char       *UPLO,
                    const char       *DIAG,
                    const INTEGER    *N,
                    FLOAT_COMPLEX    *A,
                    const INTEGER    *LDA,
                    INTEGER          *INFO)
{
    DEBUG_LAPACK_STUB("ctrti2");
    LAPACK_IMPL(ctrti2)(UPLO,
                        DIAG,
                        N,
                        A,
                        LDA,
                        INFO);
}

//-- ctrtri --------------------------------------------------------------------
void
LAPACK_DECL(ctrtri)(const char       *UPLO,
                    const char       *DIAG,
                    const INTEGER    *N,
                    FLOAT_COMPLEX    *A,
                    const INTEGER    *LDA,
                    INTEGER          *INFO)
{
    DEBUG_LAPACK_STUB("ctrtri");
    LAPACK_IMPL(ctrtri)(UPLO,
                        DIAG,
                        N,
                        A,
                        LDA,
                        INFO);
}

//-- ctrtrs --------------------------------------------------------------------
void
LAPACK_DECL(ctrtrs)(const char           *UPLO,
                    const char           *TRANS,
                    const char           *DIAG,
                    const INTEGER        *N,
                    const INTEGER        *NRHS,
                    const FLOAT_COMPLEX  *A,
                    const INTEGER        *LDA,
                    FLOAT_COMPLEX        *B,
                    const INTEGER        *LDB,
                    INTEGER              *INFO)
{
    DEBUG_LAPACK_STUB("ctrtrs");
    LAPACK_IMPL(ctrtrs)(UPLO,
                        TRANS,
                        DIAG,
                        N,
                        NRHS,
                        A,
                        LDA,
                        B,
                        LDB,
                        INFO);
}

//-- ctrttf --------------------------------------------------------------------
void
LAPACK_DECL(ctrttf)(const char           *TRANSR,
                    const char           *UPLO,
                    const INTEGER        *N,
                    const FLOAT_COMPLEX  *A,
                    const INTEGER        *LDA,
                    FLOAT_COMPLEX        *ARF,
                    INTEGER              *INFO)
{
    DEBUG_LAPACK_STUB("ctrttf");
    LAPACK_IMPL(ctrttf)(TRANSR,
                        UPLO,
                        N,
                        A,
                        LDA,
                        ARF,
                        INFO);
}

//-- ctrttp --------------------------------------------------------------------
void
LAPACK_DECL(ctrttp)(const char           *UPLO,
                    const INTEGER        *N,
                    const FLOAT_COMPLEX  *A,
                    const INTEGER        *LDA,
                    FLOAT_COMPLEX        *AP,
                    INTEGER              *INFO)
{
    DEBUG_LAPACK_STUB("ctrttp");
    LAPACK_IMPL(ctrttp)(UPLO,
                        N,
                        A,
                        LDA,
                        AP,
                        INFO);
}

//-- ctzrqf --------------------------------------------------------------------
void
LAPACK_DECL(ctzrqf)(const INTEGER    *M,
                    const INTEGER    *N,
                    FLOAT_COMPLEX    *A,
                    const INTEGER    *LDA,
                    FLOAT_COMPLEX    *TAU,
                    INTEGER          *INFO)
{
    DEBUG_LAPACK_STUB("ctzrqf");
    LAPACK_IMPL(ctzrqf)(M,
                        N,
                        A,
                        LDA,
                        TAU,
                        INFO);
}

//-- ctzrzf --------------------------------------------------------------------
void
LAPACK_DECL(ctzrzf)(const INTEGER    *M,
                    const INTEGER    *N,
                    FLOAT_COMPLEX    *A,
                    const INTEGER    *LDA,
                    FLOAT_COMPLEX    *TAU,
                    FLOAT_COMPLEX    *WORK,
                    const INTEGER    *LWORK,
                    INTEGER          *INFO)
{
    DEBUG_LAPACK_STUB("ctzrzf");
    LAPACK_IMPL(ctzrzf)(M,
                        N,
                        A,
                        LDA,
                        TAU,
                        WORK,
                        LWORK,
                        INFO);
}

//-- cunbdb --------------------------------------------------------------------
void
LAPACK_DECL(cunbdb)(const char       *TRANS,
                    const char       *SIGNS,
                    const INTEGER    *M,
                    const INTEGER    *P,
                    const INTEGER    *Q,
                    FLOAT_COMPLEX    *X11,
                    const INTEGER    *LDX11,
                    FLOAT_COMPLEX    *X12,
                    const INTEGER    *LDX12,
                    FLOAT_COMPLEX    *X21,
                    const INTEGER    *LDX21,
                    FLOAT_COMPLEX    *X22,
                    const INTEGER    *LDX22,
                    FLOAT            *THETA,
                    FLOAT            *PHI,
                    FLOAT_COMPLEX    *TAUP1,
                    FLOAT_COMPLEX    *TAUP2,
                    FLOAT_COMPLEX    *TAUQ1,
                    FLOAT_COMPLEX    *TAUQ2,
                    FLOAT_COMPLEX    *WORK,
                    const INTEGER    *LWORK,
                    INTEGER          *INFO)
{
    DEBUG_LAPACK_STUB("cunbdb");
    LAPACK_IMPL(cunbdb)(TRANS,
                        SIGNS,
                        M,
                        P,
                        Q,
                        X11,
                        LDX11,
                        X12,
                        LDX12,
                        X21,
                        LDX21,
                        X22,
                        LDX22,
                        THETA,
                        PHI,
                        TAUP1,
                        TAUP2,
                        TAUQ1,
                        TAUQ2,
                        WORK,
                        LWORK,
                        INFO);
}

//-- cuncsd --------------------------------------------------------------------
void
LAPACK_DECL(cuncsd)(const char           *JOBU1,
                    const char           *JOBU2,
                    const char           *JOBV1T,
                    const char           *JOBV2T,
                    const char           *TRANS,
                    const char           *SIGNS,
                    const INTEGER        *M,
                    const INTEGER        *P,
                    const INTEGER        *Q,
                    const FLOAT_COMPLEX  *X11,
                    const INTEGER        *LDX11,
                    const FLOAT_COMPLEX  *X12,
                    const INTEGER        *LDX12,
                    const FLOAT_COMPLEX  *X21,
                    const INTEGER        *LDX21,
                    const FLOAT_COMPLEX  *X22,
                    const INTEGER        *LDX22,
                    FLOAT                *THETA,
                    FLOAT_COMPLEX        *U1,
                    const INTEGER        *LDU1,
                    FLOAT_COMPLEX        *U2,
                    const INTEGER        *LDU2,
                    FLOAT_COMPLEX        *V1T,
                    const INTEGER        *LDV1T,
                    FLOAT_COMPLEX        *V2T,
                    const INTEGER        *LDV2T,
                    FLOAT_COMPLEX        *WORK,
                    const INTEGER        *LWORK,
                    FLOAT                *RWORK,
                    const INTEGER        *LRWORK,
                    INTEGER              *IWORK,
                    INTEGER              *INFO)
{
    DEBUG_LAPACK_STUB("cuncsd");
    LAPACK_IMPL(cuncsd)(JOBU1,
                        JOBU2,
                        JOBV1T,
                        JOBV2T,
                        TRANS,
                        SIGNS,
                        M,
                        P,
                        Q,
                        X11,
                        LDX11,
                        X12,
                        LDX12,
                        X21,
                        LDX21,
                        X22,
                        LDX22,
                        THETA,
                        U1,
                        LDU1,
                        U2,
                        LDU2,
                        V1T,
                        LDV1T,
                        V2T,
                        LDV2T,
                        WORK,
                        LWORK,
                        RWORK,
                        LRWORK,
                        IWORK,
                        INFO);
}

//-- cung2l --------------------------------------------------------------------
void
LAPACK_DECL(cung2l)(const INTEGER        *M,
                    const INTEGER        *N,
                    const INTEGER        *K,
                    FLOAT_COMPLEX        *A,
                    const INTEGER        *LDA,
                    const FLOAT_COMPLEX  *TAU,
                    FLOAT_COMPLEX        *WORK,
                    INTEGER              *INFO)
{
    DEBUG_LAPACK_STUB("cung2l");
    LAPACK_IMPL(cung2l)(M,
                        N,
                        K,
                        A,
                        LDA,
                        TAU,
                        WORK,
                        INFO);
}

//-- cung2r --------------------------------------------------------------------
void
LAPACK_DECL(cung2r)(const INTEGER        *M,
                    const INTEGER        *N,
                    const INTEGER        *K,
                    FLOAT_COMPLEX        *A,
                    const INTEGER        *LDA,
                    const FLOAT_COMPLEX  *TAU,
                    FLOAT_COMPLEX        *WORK,
                    INTEGER              *INFO)
{
    DEBUG_LAPACK_STUB("cung2r");
    LAPACK_IMPL(cung2r)(M,
                        N,
                        K,
                        A,
                        LDA,
                        TAU,
                        WORK,
                        INFO);
}

//-- cungbr --------------------------------------------------------------------
void
LAPACK_DECL(cungbr)(const char           *VECT,
                    const INTEGER        *M,
                    const INTEGER        *N,
                    const INTEGER        *K,
                    FLOAT_COMPLEX        *A,
                    const INTEGER        *LDA,
                    const FLOAT_COMPLEX  *TAU,
                    FLOAT_COMPLEX        *WORK,
                    const INTEGER        *LWORK,
                    INTEGER              *INFO)
{
    DEBUG_LAPACK_STUB("cungbr");
    LAPACK_IMPL(cungbr)(VECT,
                        M,
                        N,
                        K,
                        A,
                        LDA,
                        TAU,
                        WORK,
                        LWORK,
                        INFO);
}

//-- cunghr --------------------------------------------------------------------
void
LAPACK_DECL(cunghr)(const INTEGER        *N,
                    const INTEGER        *ILO,
                    const INTEGER        *IHI,
                    FLOAT_COMPLEX        *A,
                    const INTEGER        *LDA,
                    const FLOAT_COMPLEX  *TAU,
                    FLOAT_COMPLEX        *WORK,
                    const INTEGER        *LWORK,
                    INTEGER              *INFO)
{
    DEBUG_LAPACK_STUB("cunghr");
    LAPACK_IMPL(cunghr)(N,
                        ILO,
                        IHI,
                        A,
                        LDA,
                        TAU,
                        WORK,
                        LWORK,
                        INFO);
}

//-- cungl2 --------------------------------------------------------------------
void
LAPACK_DECL(cungl2)(const INTEGER        *M,
                    const INTEGER        *N,
                    const INTEGER        *K,
                    FLOAT_COMPLEX        *A,
                    const INTEGER        *LDA,
                    const FLOAT_COMPLEX  *TAU,
                    FLOAT_COMPLEX        *WORK,
                    INTEGER              *INFO)
{
    DEBUG_LAPACK_STUB("cungl2");
    LAPACK_IMPL(cungl2)(M,
                        N,
                        K,
                        A,
                        LDA,
                        TAU,
                        WORK,
                        INFO);
}

//-- cunglq --------------------------------------------------------------------
void
LAPACK_DECL(cunglq)(const INTEGER        *M,
                    const INTEGER        *N,
                    const INTEGER        *K,
                    FLOAT_COMPLEX        *A,
                    const INTEGER        *LDA,
                    const FLOAT_COMPLEX  *TAU,
                    FLOAT_COMPLEX        *WORK,
                    const INTEGER        *LWORK,
                    INTEGER              *INFO)
{
    DEBUG_LAPACK_STUB("cunglq");
    LAPACK_IMPL(cunglq)(M,
                        N,
                        K,
                        A,
                        LDA,
                        TAU,
                        WORK,
                        LWORK,
                        INFO);
}

//-- cungql --------------------------------------------------------------------
void
LAPACK_DECL(cungql)(const INTEGER        *M,
                    const INTEGER        *N,
                    const INTEGER        *K,
                    FLOAT_COMPLEX        *A,
                    const INTEGER        *LDA,
                    const FLOAT_COMPLEX  *TAU,
                    FLOAT_COMPLEX        *WORK,
                    const INTEGER        *LWORK,
                    INTEGER              *INFO)
{
    DEBUG_LAPACK_STUB("cungql");
    LAPACK_IMPL(cungql)(M,
                        N,
                        K,
                        A,
                        LDA,
                        TAU,
                        WORK,
                        LWORK,
                        INFO);
}

//-- cungqr --------------------------------------------------------------------
void
LAPACK_DECL(cungqr)(const INTEGER        *M,
                    const INTEGER        *N,
                    const INTEGER        *K,
                    FLOAT_COMPLEX        *A,
                    const INTEGER        *LDA,
                    const FLOAT_COMPLEX  *TAU,
                    FLOAT_COMPLEX        *WORK,
                    const INTEGER        *LWORK,
                    INTEGER              *INFO)
{
    DEBUG_LAPACK_STUB("cungqr");
    LAPACK_IMPL(cungqr)(M,
                        N,
                        K,
                        A,
                        LDA,
                        TAU,
                        WORK,
                        LWORK,
                        INFO);
}

//-- cungr2 --------------------------------------------------------------------
void
LAPACK_DECL(cungr2)(const INTEGER        *M,
                    const INTEGER        *N,
                    const INTEGER        *K,
                    FLOAT_COMPLEX        *A,
                    const INTEGER        *LDA,
                    const FLOAT_COMPLEX  *TAU,
                    FLOAT_COMPLEX        *WORK,
                    INTEGER              *INFO)
{
    DEBUG_LAPACK_STUB("cungr2");
    LAPACK_IMPL(cungr2)(M,
                        N,
                        K,
                        A,
                        LDA,
                        TAU,
                        WORK,
                        INFO);
}

//-- cungrq --------------------------------------------------------------------
void
LAPACK_DECL(cungrq)(const INTEGER        *M,
                    const INTEGER        *N,
                    const INTEGER        *K,
                    FLOAT_COMPLEX        *A,
                    const INTEGER        *LDA,
                    const FLOAT_COMPLEX  *TAU,
                    FLOAT_COMPLEX        *WORK,
                    const INTEGER        *LWORK,
                    INTEGER              *INFO)
{
    DEBUG_LAPACK_STUB("cungrq");
    LAPACK_IMPL(cungrq)(M,
                        N,
                        K,
                        A,
                        LDA,
                        TAU,
                        WORK,
                        LWORK,
                        INFO);
}

//-- cungtr --------------------------------------------------------------------
void
LAPACK_DECL(cungtr)(const char           *UPLO,
                    const INTEGER        *N,
                    FLOAT_COMPLEX        *A,
                    const INTEGER        *LDA,
                    const FLOAT_COMPLEX  *TAU,
                    FLOAT_COMPLEX        *WORK,
                    const INTEGER        *LWORK,
                    INTEGER              *INFO)
{
    DEBUG_LAPACK_STUB("cungtr");
    LAPACK_IMPL(cungtr)(UPLO,
                        N,
                        A,
                        LDA,
                        TAU,
                        WORK,
                        LWORK,
                        INFO);
}

//-- cunm2l --------------------------------------------------------------------
void
LAPACK_DECL(cunm2l)(const char           *SIDE,
                    const char           *TRANS,
                    const INTEGER        *M,
                    const INTEGER        *N,
                    const INTEGER        *K,
                    const FLOAT_COMPLEX  *A,
                    const INTEGER        *LDA,
                    const FLOAT_COMPLEX  *TAU,
                    FLOAT_COMPLEX        *C,
                    const INTEGER        *LDC,
                    FLOAT_COMPLEX        *WORK,
                    INTEGER              *INFO)
{
    DEBUG_LAPACK_STUB("cunm2l");
    LAPACK_IMPL(cunm2l)(SIDE,
                        TRANS,
                        M,
                        N,
                        K,
                        A,
                        LDA,
                        TAU,
                        C,
                        LDC,
                        WORK,
                        INFO);
}

//-- cunm2r --------------------------------------------------------------------
void
LAPACK_DECL(cunm2r)(const char           *SIDE,
                    const char           *TRANS,
                    const INTEGER        *M,
                    const INTEGER        *N,
                    const INTEGER        *K,
                    const FLOAT_COMPLEX  *A,
                    const INTEGER        *LDA,
                    const FLOAT_COMPLEX  *TAU,
                    FLOAT_COMPLEX        *C,
                    const INTEGER        *LDC,
                    FLOAT_COMPLEX        *WORK,
                    INTEGER              *INFO)
{
    DEBUG_LAPACK_STUB("cunm2r");
    LAPACK_IMPL(cunm2r)(SIDE,
                        TRANS,
                        M,
                        N,
                        K,
                        A,
                        LDA,
                        TAU,
                        C,
                        LDC,
                        WORK,
                        INFO);
}

//-- cunmbr --------------------------------------------------------------------
void
LAPACK_DECL(cunmbr)(const char           *VECT,
                    const char           *SIDE,
                    const char           *TRANS,
                    const INTEGER        *M,
                    const INTEGER        *N,
                    const INTEGER        *K,
                    const FLOAT_COMPLEX  *A,
                    const INTEGER        *LDA,
                    const FLOAT_COMPLEX  *TAU,
                    FLOAT_COMPLEX        *C,
                    const INTEGER        *LDC,
                    FLOAT_COMPLEX        *WORK,
                    const INTEGER        *LWORK,
                    INTEGER              *INFO)
{
    DEBUG_LAPACK_STUB("cunmbr");
    LAPACK_IMPL(cunmbr)(VECT,
                        SIDE,
                        TRANS,
                        M,
                        N,
                        K,
                        A,
                        LDA,
                        TAU,
                        C,
                        LDC,
                        WORK,
                        LWORK,
                        INFO);
}

//-- cunmhr --------------------------------------------------------------------
void
LAPACK_DECL(cunmhr)(const char           *SIDE,
                    const char           *TRANS,
                    const INTEGER        *M,
                    const INTEGER        *N,
                    const INTEGER        *ILO,
                    const INTEGER        *IHI,
                    const FLOAT_COMPLEX  *A,
                    const INTEGER        *LDA,
                    const FLOAT_COMPLEX  *TAU,
                    FLOAT_COMPLEX        *C,
                    const INTEGER        *LDC,
                    FLOAT_COMPLEX        *WORK,
                    const INTEGER        *LWORK,
                    INTEGER              *INFO)
{
    DEBUG_LAPACK_STUB("cunmhr");
    LAPACK_IMPL(cunmhr)(SIDE,
                        TRANS,
                        M,
                        N,
                        ILO,
                        IHI,
                        A,
                        LDA,
                        TAU,
                        C,
                        LDC,
                        WORK,
                        LWORK,
                        INFO);
}

//-- cunml2 --------------------------------------------------------------------
void
LAPACK_DECL(cunml2)(const char           *SIDE,
                    const char           *TRANS,
                    const INTEGER        *M,
                    const INTEGER        *N,
                    const INTEGER        *K,
                    const FLOAT_COMPLEX  *A,
                    const INTEGER        *LDA,
                    const FLOAT_COMPLEX  *TAU,
                    FLOAT_COMPLEX        *C,
                    const INTEGER        *LDC,
                    FLOAT_COMPLEX        *WORK,
                    INTEGER              *INFO)
{
    DEBUG_LAPACK_STUB("cunml2");
    LAPACK_IMPL(cunml2)(SIDE,
                        TRANS,
                        M,
                        N,
                        K,
                        A,
                        LDA,
                        TAU,
                        C,
                        LDC,
                        WORK,
                        INFO);
}

//-- cunmlq --------------------------------------------------------------------
void
LAPACK_DECL(cunmlq)(const char           *SIDE,
                    const char           *TRANS,
                    const INTEGER        *M,
                    const INTEGER        *N,
                    const INTEGER        *K,
                    const FLOAT_COMPLEX  *A,
                    const INTEGER        *LDA,
                    const FLOAT_COMPLEX  *TAU,
                    FLOAT_COMPLEX        *C,
                    const INTEGER        *LDC,
                    FLOAT_COMPLEX        *WORK,
                    const INTEGER        *LWORK,
                    INTEGER              *INFO)
{
    DEBUG_LAPACK_STUB("cunmlq");
    LAPACK_IMPL(cunmlq)(SIDE,
                        TRANS,
                        M,
                        N,
                        K,
                        A,
                        LDA,
                        TAU,
                        C,
                        LDC,
                        WORK,
                        LWORK,
                        INFO);
}

//-- cunmql --------------------------------------------------------------------
void
LAPACK_DECL(cunmql)(const char           *SIDE,
                    const char           *TRANS,
                    const INTEGER        *M,
                    const INTEGER        *N,
                    const INTEGER        *K,
                    const FLOAT_COMPLEX  *A,
                    const INTEGER        *LDA,
                    const FLOAT_COMPLEX  *TAU,
                    FLOAT_COMPLEX        *C,
                    const INTEGER        *LDC,
                    FLOAT_COMPLEX        *WORK,
                    const INTEGER        *LWORK,
                    INTEGER              *INFO)
{
    DEBUG_LAPACK_STUB("cunmql");
    LAPACK_IMPL(cunmql)(SIDE,
                        TRANS,
                        M,
                        N,
                        K,
                        A,
                        LDA,
                        TAU,
                        C,
                        LDC,
                        WORK,
                        LWORK,
                        INFO);
}

//-- cunmqr --------------------------------------------------------------------
void
LAPACK_DECL(cunmqr)(const char           *SIDE,
                    const char           *TRANS,
                    const INTEGER        *M,
                    const INTEGER        *N,
                    const INTEGER        *K,
                    const FLOAT_COMPLEX  *A,
                    const INTEGER        *LDA,
                    const FLOAT_COMPLEX  *TAU,
                    FLOAT_COMPLEX        *C,
                    const INTEGER        *LDC,
                    FLOAT_COMPLEX        *WORK,
                    const INTEGER        *LWORK,
                    INTEGER              *INFO)
{
    DEBUG_LAPACK_STUB("cunmqr");
    LAPACK_IMPL(cunmqr)(SIDE,
                        TRANS,
                        M,
                        N,
                        K,
                        A,
                        LDA,
                        TAU,
                        C,
                        LDC,
                        WORK,
                        LWORK,
                        INFO);
}

//-- cunmr2 --------------------------------------------------------------------
void
LAPACK_DECL(cunmr2)(const char           *SIDE,
                    const char           *TRANS,
                    const INTEGER        *M,
                    const INTEGER        *N,
                    const INTEGER        *K,
                    const FLOAT_COMPLEX  *A,
                    const INTEGER        *LDA,
                    const FLOAT_COMPLEX  *TAU,
                    FLOAT_COMPLEX        *C,
                    const INTEGER        *LDC,
                    FLOAT_COMPLEX        *WORK,
                    INTEGER              *INFO)
{
    DEBUG_LAPACK_STUB("cunmr2");
    LAPACK_IMPL(cunmr2)(SIDE,
                        TRANS,
                        M,
                        N,
                        K,
                        A,
                        LDA,
                        TAU,
                        C,
                        LDC,
                        WORK,
                        INFO);
}

//-- cunmr3 --------------------------------------------------------------------
void
LAPACK_DECL(cunmr3)(const char           *SIDE,
                    const char           *TRANS,
                    const INTEGER        *M,
                    const INTEGER        *N,
                    const INTEGER        *K,
                    const INTEGER        *L,
                    const FLOAT_COMPLEX  *A,
                    const INTEGER        *LDA,
                    const FLOAT_COMPLEX  *TAU,
                    FLOAT_COMPLEX        *C,
                    const INTEGER        *LDC,
                    FLOAT_COMPLEX        *WORK,
                    INTEGER              *INFO)
{
    DEBUG_LAPACK_STUB("cunmr3");
    LAPACK_IMPL(cunmr3)(SIDE,
                        TRANS,
                        M,
                        N,
                        K,
                        L,
                        A,
                        LDA,
                        TAU,
                        C,
                        LDC,
                        WORK,
                        INFO);
}

//-- cunmrq --------------------------------------------------------------------
void
LAPACK_DECL(cunmrq)(const char           *SIDE,
                    const char           *TRANS,
                    const INTEGER        *M,
                    const INTEGER        *N,
                    const INTEGER        *K,
                    const FLOAT_COMPLEX  *A,
                    const INTEGER        *LDA,
                    const FLOAT_COMPLEX  *TAU,
                    FLOAT_COMPLEX        *C,
                    const INTEGER        *LDC,
                    FLOAT_COMPLEX        *WORK,
                    const INTEGER        *LWORK,
                    INTEGER              *INFO)
{
    DEBUG_LAPACK_STUB("cunmrq");
    LAPACK_IMPL(cunmrq)(SIDE,
                        TRANS,
                        M,
                        N,
                        K,
                        A,
                        LDA,
                        TAU,
                        C,
                        LDC,
                        WORK,
                        LWORK,
                        INFO);
}

//-- cunmrz --------------------------------------------------------------------
void
LAPACK_DECL(cunmrz)(const char           *SIDE,
                    const char           *TRANS,
                    const INTEGER        *M,
                    const INTEGER        *N,
                    const INTEGER        *K,
                    const INTEGER        *L,
                    const FLOAT_COMPLEX  *A,
                    const INTEGER        *LDA,
                    const FLOAT_COMPLEX  *TAU,
                    FLOAT_COMPLEX        *C,
                    const INTEGER        *LDC,
                    FLOAT_COMPLEX        *WORK,
                    const INTEGER        *LWORK,
                    INTEGER              *INFO)
{
    DEBUG_LAPACK_STUB("cunmrz");
    LAPACK_IMPL(cunmrz)(SIDE,
                        TRANS,
                        M,
                        N,
                        K,
                        L,
                        A,
                        LDA,
                        TAU,
                        C,
                        LDC,
                        WORK,
                        LWORK,
                        INFO);
}

//-- cunmtr --------------------------------------------------------------------
void
LAPACK_DECL(cunmtr)(const char           *SIDE,
                    const char           *UPLO,
                    const char           *TRANS,
                    const INTEGER        *M,
                    const INTEGER        *N,
                    const FLOAT_COMPLEX  *A,
                    const INTEGER        *LDA,
                    const FLOAT_COMPLEX  *TAU,
                    FLOAT_COMPLEX        *C,
                    const INTEGER        *LDC,
                    FLOAT_COMPLEX        *WORK,
                    const INTEGER        *LWORK,
                    INTEGER              *INFO)
{
    DEBUG_LAPACK_STUB("cunmtr");
    LAPACK_IMPL(cunmtr)(SIDE,
                        UPLO,
                        TRANS,
                        M,
                        N,
                        A,
                        LDA,
                        TAU,
                        C,
                        LDC,
                        WORK,
                        LWORK,
                        INFO);
}

//-- cupgtr --------------------------------------------------------------------
void
LAPACK_DECL(cupgtr)(const char           *UPLO,
                    const INTEGER        *N,
                    const FLOAT_COMPLEX  *AP,
                    const FLOAT_COMPLEX  *TAU,
                    FLOAT_COMPLEX        *Q,
                    const INTEGER        *LDQ,
                    FLOAT_COMPLEX        *WORK,
                    INTEGER              *INFO)
{
    DEBUG_LAPACK_STUB("cupgtr");
    LAPACK_IMPL(cupgtr)(UPLO,
                        N,
                        AP,
                        TAU,
                        Q,
                        LDQ,
                        WORK,
                        INFO);
}

//-- cupmtr --------------------------------------------------------------------
void
LAPACK_DECL(cupmtr)(const char           *SIDE,
                    const char           *UPLO,
                    const char           *TRANS,
                    const INTEGER        *M,
                    const INTEGER        *N,
                    const FLOAT_COMPLEX  *AP,
                    const FLOAT_COMPLEX  *TAU,
                    FLOAT_COMPLEX        *C,
                    const INTEGER        *LDC,
                    FLOAT_COMPLEX        *WORK,
                    INTEGER              *INFO)
{
    DEBUG_LAPACK_STUB("cupmtr");
    LAPACK_IMPL(cupmtr)(SIDE,
                        UPLO,
                        TRANS,
                        M,
                        N,
                        AP,
                        TAU,
                        C,
                        LDC,
                        WORK,
                        INFO);
}

//-- dbbcsd --------------------------------------------------------------------
void
LAPACK_DECL(dbbcsd)(const char       *JOBU1,
                    const char       *JOBU2,
                    const char       *JOBV1T,
                    const char       *JOBV2T,
                    const char       *TRANS,
                    const INTEGER    *M,
                    const INTEGER    *P,
                    const INTEGER    *Q,
                    DOUBLE           *THETA,
                    DOUBLE           *PHI,
                    DOUBLE           *U1,
                    const INTEGER    *LDU1,
                    DOUBLE           *U2,
                    const INTEGER    *LDU2,
                    DOUBLE           *V1T,
                    const INTEGER    *LDV1T,
                    DOUBLE           *V2T,
                    const INTEGER    *LDV2T,
                    DOUBLE           *B11D,
                    DOUBLE           *B11E,
                    DOUBLE           *B12D,
                    DOUBLE           *B12E,
                    const DOUBLE     *B21D,
                    const DOUBLE     *B21E,
                    const DOUBLE     *B22D,
                    const DOUBLE     *B22E,
                    DOUBLE           *WORK,
                    const INTEGER    *LWORK,
                    INTEGER          *INFO)
{
    DEBUG_LAPACK_STUB("dbbcsd");
    LAPACK_IMPL(dbbcsd)(JOBU1,
                        JOBU2,
                        JOBV1T,
                        JOBV2T,
                        TRANS,
                        M,
                        P,
                        Q,
                        THETA,
                        PHI,
                        U1,
                        LDU1,
                        U2,
                        LDU2,
                        V1T,
                        LDV1T,
                        V2T,
                        LDV2T,
                        B11D,
                        B11E,
                        B12D,
                        B12E,
                        B21D,
                        B21E,
                        B22D,
                        B22E,
                        WORK,
                        LWORK,
                        INFO);
}

//-- dbdsdc --------------------------------------------------------------------
void
LAPACK_DECL(dbdsdc)(const char       *UPLO,
                    const char       *COMPQ,
                    const INTEGER    *N,
                    DOUBLE           *D,
                    DOUBLE           *E,
                    DOUBLE           *U,
                    const INTEGER    *LDU,
                    DOUBLE           *VT,
                    const INTEGER    *LDVT,
                    DOUBLE           *Q,
                    INTEGER          *IQ,
                    DOUBLE           *WORK,
                    INTEGER          *IWORK,
                    INTEGER          *INFO)
{
    DEBUG_LAPACK_STUB("dbdsdc");
    LAPACK_IMPL(dbdsdc)(UPLO,
                        COMPQ,
                        N,
                        D,
                        E,
                        U,
                        LDU,
                        VT,
                        LDVT,
                        Q,
                        IQ,
                        WORK,
                        IWORK,
                        INFO);
}

//-- dbdsqr --------------------------------------------------------------------
void
LAPACK_DECL(dbdsqr)(const char       *UPLO,
                    const INTEGER    *N,
                    const INTEGER    *NCVT,
                    const INTEGER    *NRU,
                    const INTEGER    *NCC,
                    DOUBLE           *D,
                    DOUBLE           *E,
                    DOUBLE           *VT,
                    const INTEGER    *LDVT,
                    DOUBLE           *U,
                    const INTEGER    *LDU,
                    DOUBLE           *C,
                    const INTEGER    *LDC,
                    DOUBLE           *WORK,
                    INTEGER          *INFO)
{
    DEBUG_LAPACK_STUB("dbdsqr");
    LAPACK_IMPL(dbdsqr)(UPLO,
                        N,
                        NCVT,
                        NRU,
                        NCC,
                        D,
                        E,
                        VT,
                        LDVT,
                        U,
                        LDU,
                        C,
                        LDC,
                        WORK,
                        INFO);
}

//-- ddisna --------------------------------------------------------------------
void
LAPACK_DECL(ddisna)(const char       *JOB,
                    const INTEGER    *M,
                    const INTEGER    *N,
                    const DOUBLE     *D,
                    DOUBLE           *SEP,
                    INTEGER          *INFO)
{
    DEBUG_LAPACK_STUB("ddisna");
    LAPACK_IMPL(ddisna)(JOB,
                        M,
                        N,
                        D,
                        SEP,
                        INFO);
}

//-- dgbbrd --------------------------------------------------------------------
void
LAPACK_DECL(dgbbrd)(const char       *VECT,
                    const INTEGER    *M,
                    const INTEGER    *N,
                    const INTEGER    *NCC,
                    const INTEGER    *KL,
                    const INTEGER    *KU,
                    DOUBLE           *AB,
                    const INTEGER    *LDAB,
                    DOUBLE           *D,
                    DOUBLE           *E,
                    DOUBLE           *Q,
                    const INTEGER    *LDQ,
                    DOUBLE           *PT,
                    const INTEGER    *LDPT,
                    DOUBLE           *C,
                    const INTEGER    *LDC,
                    DOUBLE           *WORK,
                    INTEGER          *INFO)
{
    DEBUG_LAPACK_STUB("dgbbrd");
    LAPACK_IMPL(dgbbrd)(VECT,
                        M,
                        N,
                        NCC,
                        KL,
                        KU,
                        AB,
                        LDAB,
                        D,
                        E,
                        Q,
                        LDQ,
                        PT,
                        LDPT,
                        C,
                        LDC,
                        WORK,
                        INFO);
}

//-- dgbcon --------------------------------------------------------------------
void
LAPACK_DECL(dgbcon)(const char       *NORM,
                    const INTEGER    *N,
                    const INTEGER    *KL,
                    const INTEGER    *KU,
                    const DOUBLE     *AB,
                    const INTEGER    *LDAB,
                    const INTEGER    *IPIV,
                    const DOUBLE     *ANORM,
                    DOUBLE           *RCOND,
                    DOUBLE           *WORK,
                    INTEGER          *IWORK,
                    INTEGER          *INFO)
{
    DEBUG_LAPACK_STUB("dgbcon");
    LAPACK_IMPL(dgbcon)(NORM,
                        N,
                        KL,
                        KU,
                        AB,
                        LDAB,
                        IPIV,
                        ANORM,
                        RCOND,
                        WORK,
                        IWORK,
                        INFO);
}

//-- dgbequ --------------------------------------------------------------------
void
LAPACK_DECL(dgbequ)(const INTEGER    *M,
                    const INTEGER    *N,
                    const INTEGER    *KL,
                    const INTEGER    *KU,
                    const DOUBLE     *AB,
                    const INTEGER    *LDAB,
                    DOUBLE           *R,
                    DOUBLE           *C,
                    DOUBLE           *ROWCND,
                    DOUBLE           *COLCND,
                    DOUBLE           *AMAX,
                    INTEGER          *INFO)
{
    DEBUG_LAPACK_STUB("dgbequ");
    LAPACK_IMPL(dgbequ)(M,
                        N,
                        KL,
                        KU,
                        AB,
                        LDAB,
                        R,
                        C,
                        ROWCND,
                        COLCND,
                        AMAX,
                        INFO);
}

//-- dgbequb -------------------------------------------------------------------
void
LAPACK_DECL(dgbequb)(const INTEGER    *M,
                     const INTEGER    *N,
                     const INTEGER    *KL,
                     const INTEGER    *KU,
                     const DOUBLE     *AB,
                     const INTEGER    *LDAB,
                     DOUBLE           *R,
                     DOUBLE           *C,
                     DOUBLE           *ROWCND,
                     DOUBLE           *COLCND,
                     DOUBLE           *AMAX,
                     INTEGER          *INFO)
{
    DEBUG_LAPACK_STUB("dgbequb");
    LAPACK_IMPL(dgbequb)(M,
                         N,
                         KL,
                         KU,
                         AB,
                         LDAB,
                         R,
                         C,
                         ROWCND,
                         COLCND,
                         AMAX,
                         INFO);
}

//-- dgbrfs --------------------------------------------------------------------
void
LAPACK_DECL(dgbrfs)(const char       *TRANS,
                    const INTEGER    *N,
                    const INTEGER    *KL,
                    const INTEGER    *KU,
                    const INTEGER    *NRHS,
                    const DOUBLE     *AB,
                    const INTEGER    *LDAB,
                    const DOUBLE     *AFB,
                    const INTEGER    *LDAFB,
                    const INTEGER    *IPIV,
                    const DOUBLE     *B,
                    const INTEGER    *LDB,
                    DOUBLE           *X,
                    const INTEGER    *LDX,
                    DOUBLE           *FERR,
                    DOUBLE           *BERR,
                    DOUBLE           *WORK,
                    INTEGER          *IWORK,
                    INTEGER          *INFO)
{
    DEBUG_LAPACK_STUB("dgbrfs");
    LAPACK_IMPL(dgbrfs)(TRANS,
                        N,
                        KL,
                        KU,
                        NRHS,
                        AB,
                        LDAB,
                        AFB,
                        LDAFB,
                        IPIV,
                        B,
                        LDB,
                        X,
                        LDX,
                        FERR,
                        BERR,
                        WORK,
                        IWORK,
                        INFO);
}

//-- dgbrfsx -------------------------------------------------------------------
void
LAPACK_DECL(dgbrfsx)(const char       *TRANS,
                     const char       *EQUED,
                     const INTEGER    *N,
                     const INTEGER    *KL,
                     const INTEGER    *KU,
                     const INTEGER    *NRHS,
                     const DOUBLE     *AB,
                     const INTEGER    *LDAB,
                     const DOUBLE     *AFB,
                     const INTEGER    *LDAFB,
                     const INTEGER    *IPIV,
                     DOUBLE           *R,
                     DOUBLE           *C,
                     const DOUBLE     *B,
                     const INTEGER    *LDB,
                     DOUBLE           *X,
                     const INTEGER    *LDX,
                     DOUBLE           *RCOND,
                     DOUBLE           *BERR,
                     const INTEGER    *N_ERR_BNDS,
                     DOUBLE           *ERR_BNDS_NORM,
                     DOUBLE           *ERR_BNDS_COMP,
                     const INTEGER    *NPARAMS,
                     DOUBLE           *PARAMS,
                     DOUBLE           *WORK,
                     INTEGER          *IWORK,
                     INTEGER          *INFO)
{
    DEBUG_LAPACK_STUB("dgbrfsx");
    LAPACK_IMPL(dgbrfsx)(TRANS,
                         EQUED,
                         N,
                         KL,
                         KU,
                         NRHS,
                         AB,
                         LDAB,
                         AFB,
                         LDAFB,
                         IPIV,
                         R,
                         C,
                         B,
                         LDB,
                         X,
                         LDX,
                         RCOND,
                         BERR,
                         N_ERR_BNDS,
                         ERR_BNDS_NORM,
                         ERR_BNDS_COMP,
                         NPARAMS,
                         PARAMS,
                         WORK,
                         IWORK,
                         INFO);
}

//-- dgbsv ---------------------------------------------------------------------
void
LAPACK_DECL(dgbsv)(const INTEGER        *N,
                   const INTEGER        *KL,
                   const INTEGER        *KU,
                   const INTEGER        *NRHS,
                   DOUBLE               *AB,
                   const INTEGER        *LDAB,
                   INTEGER              *IPIV,
                   DOUBLE               *B,
                   const INTEGER        *LDB,
                   INTEGER              *INFO)
{
    DEBUG_LAPACK_STUB("dgbsv");
    LAPACK_IMPL(dgbsv)(N,
                       KL,
                       KU,
                       NRHS,
                       AB,
                       LDAB,
                       IPIV,
                       B,
                       LDB,
                       INFO);
}

//-- dgbsvx --------------------------------------------------------------------
void
LAPACK_DECL(dgbsvx)(const char       *FACT,
                    const char       *TRANS,
                    const INTEGER    *N,
                    const INTEGER    *KL,
                    const INTEGER    *KU,
                    const INTEGER    *NRHS,
                    DOUBLE           *AB,
                    const INTEGER    *LDAB,
                    DOUBLE           *AFB,
                    const INTEGER    *LDAFB,
                    INTEGER          *IPIV,
                    char             *EQUED,
                    DOUBLE           *R,
                    DOUBLE           *C,
                    DOUBLE           *B,
                    const INTEGER    *LDB,
                    DOUBLE           *X,
                    const INTEGER    *LDX,
                    DOUBLE           *RCOND,
                    DOUBLE           *FERR,
                    DOUBLE           *BERR,
                    DOUBLE           *WORK,
                    INTEGER          *IWORK,
                    INTEGER          *INFO)
{
    DEBUG_LAPACK_STUB("dgbsvx");
    LAPACK_IMPL(dgbsvx)(FACT,
                        TRANS,
                        N,
                        KL,
                        KU,
                        NRHS,
                        AB,
                        LDAB,
                        AFB,
                        LDAFB,
                        IPIV,
                        EQUED,
                        R,
                        C,
                        B,
                        LDB,
                        X,
                        LDX,
                        RCOND,
                        FERR,
                        BERR,
                        WORK,
                        IWORK,
                        INFO);
}

//-- dgbsvxx -------------------------------------------------------------------
void
LAPACK_DECL(dgbsvxx)(const char       *FACT,
                     const char       *TRANS,
                     const INTEGER    *N,
                     const INTEGER    *KL,
                     const INTEGER    *KU,
                     const INTEGER    *NRHS,
                     DOUBLE           *AB,
                     const INTEGER    *LDAB,
                     DOUBLE           *AFB,
                     const INTEGER    *LDAFB,
                     INTEGER          *IPIV,
                     char             *EQUED,
                     DOUBLE           *R,
                     DOUBLE           *C,
                     DOUBLE           *B,
                     const INTEGER    *LDB,
                     DOUBLE           *X,
                     const INTEGER    *LDX,
                     DOUBLE           *RCOND,
                     DOUBLE           *RPVGRW,
                     DOUBLE           *BERR,
                     const INTEGER    *N_ERR_BNDS,
                     DOUBLE           *ERR_BNDS_NORM,
                     DOUBLE           *ERR_BNDS_COMP,
                     const INTEGER    *NPARAMS,
                     DOUBLE           *PARAMS,
                     DOUBLE           *WORK,
                     INTEGER          *IWORK,
                     INTEGER          *INFO)
{
    DEBUG_LAPACK_STUB("dgbsvxx");
    LAPACK_IMPL(dgbsvxx)(FACT,
                         TRANS,
                         N,
                         KL,
                         KU,
                         NRHS,
                         AB,
                         LDAB,
                         AFB,
                         LDAFB,
                         IPIV,
                         EQUED,
                         R,
                         C,
                         B,
                         LDB,
                         X,
                         LDX,
                         RCOND,
                         RPVGRW,
                         BERR,
                         N_ERR_BNDS,
                         ERR_BNDS_NORM,
                         ERR_BNDS_COMP,
                         NPARAMS,
                         PARAMS,
                         WORK,
                         IWORK,
                         INFO);
}

//-- dgbtf2 --------------------------------------------------------------------
void
LAPACK_DECL(dgbtf2)(const INTEGER    *M,
                    const INTEGER    *N,
                    const INTEGER    *KL,
                    const INTEGER    *KU,
                    DOUBLE           *AB,
                    const INTEGER    *LDAB,
                    INTEGER          *IPIV,
                    INTEGER          *INFO)
{
    DEBUG_LAPACK_STUB("dgbtf2");
    LAPACK_IMPL(dgbtf2)(M,
                        N,
                        KL,
                        KU,
                        AB,
                        LDAB,
                        IPIV,
                        INFO);
}

//-- dgbtrf --------------------------------------------------------------------
void
LAPACK_DECL(dgbtrf)(const INTEGER    *M,
                    const INTEGER    *N,
                    const INTEGER    *KL,
                    const INTEGER    *KU,
                    DOUBLE           *AB,
                    const INTEGER    *LDAB,
                    INTEGER          *IPIV,
                    INTEGER          *INFO)
{
    DEBUG_LAPACK_STUB("dgbtrf");
    LAPACK_IMPL(dgbtrf)(M,
                        N,
                        KL,
                        KU,
                        AB,
                        LDAB,
                        IPIV,
                        INFO);
}

//-- dgbtrs --------------------------------------------------------------------
void
LAPACK_DECL(dgbtrs)(const char       *TRANS,
                    const INTEGER    *N,
                    const INTEGER    *KL,
                    const INTEGER    *KU,
                    const INTEGER    *NRHS,
                    const DOUBLE     *AB,
                    const INTEGER    *LDAB,
                    const INTEGER    *IPIV,
                    DOUBLE           *B,
                    const INTEGER    *LDB,
                    INTEGER          *INFO)
{
    DEBUG_LAPACK_STUB("dgbtrs");
    LAPACK_IMPL(dgbtrs)(TRANS,
                        N,
                        KL,
                        KU,
                        NRHS,
                        AB,
                        LDAB,
                        IPIV,
                        B,
                        LDB,
                        INFO);
}

//-- dgebak --------------------------------------------------------------------
void
LAPACK_DECL(dgebak)(const char       *JOB,
                    const char       *SIDE,
                    const INTEGER    *N,
                    const INTEGER    *ILO,
                    const INTEGER    *IHI,
                    const DOUBLE     *SCALE,
                    const INTEGER    *M,
                    DOUBLE           *V,
                    const INTEGER    *LDV,
                    INTEGER          *INFO)
{
    DEBUG_LAPACK_STUB("dgebak");
    LAPACK_IMPL(dgebak)(JOB,
                        SIDE,
                        N,
                        ILO,
                        IHI,
                        SCALE,
                        M,
                        V,
                        LDV,
                        INFO);
}

//-- dgebal --------------------------------------------------------------------
void
LAPACK_DECL(dgebal)(const char       *JOB,
                    const INTEGER    *N,
                    DOUBLE           *A,
                    const INTEGER    *LDA,
                    INTEGER          *ILO,
                    INTEGER          *IHI,
                    DOUBLE           *SCALE,
                    INTEGER          *INFO)
{
    DEBUG_LAPACK_STUB("dgebal");
    LAPACK_IMPL(dgebal)(JOB,
                        N,
                        A,
                        LDA,
                        ILO,
                        IHI,
                        SCALE,
                        INFO);
}

//-- dgebd2 --------------------------------------------------------------------
void
LAPACK_DECL(dgebd2)(const INTEGER    *M,
                    const INTEGER    *N,
                    DOUBLE           *A,
                    const INTEGER    *LDA,
                    DOUBLE           *D,
                    DOUBLE           *E,
                    DOUBLE           *TAUQ,
                    DOUBLE           *TAUP,
                    DOUBLE           *WORK,
                    INTEGER          *INFO)
{
    DEBUG_LAPACK_STUB("dgebd2");
    LAPACK_IMPL(dgebd2)(M,
                        N,
                        A,
                        LDA,
                        D,
                        E,
                        TAUQ,
                        TAUP,
                        WORK,
                        INFO);
}

//-- dgebrd --------------------------------------------------------------------
void
LAPACK_DECL(dgebrd)(const INTEGER    *M,
                    const INTEGER    *N,
                    DOUBLE           *A,
                    const INTEGER    *LDA,
                    DOUBLE           *D,
                    DOUBLE           *E,
                    DOUBLE           *TAUQ,
                    DOUBLE           *TAUP,
                    DOUBLE           *WORK,
                    const INTEGER    *LWORK,
                    INTEGER          *INFO)
{
    DEBUG_LAPACK_STUB("dgebrd");
    LAPACK_IMPL(dgebrd)(M,
                        N,
                        A,
                        LDA,
                        D,
                        E,
                        TAUQ,
                        TAUP,
                        WORK,
                        LWORK,
                        INFO);
}

//-- dgecon --------------------------------------------------------------------
void
LAPACK_DECL(dgecon)(const char       *NORM,
                    const INTEGER    *N,
                    const DOUBLE     *A,
                    const INTEGER    *LDA,
                    const DOUBLE     *ANORM,
                    DOUBLE           *RCOND,
                    DOUBLE           *WORK,
                    INTEGER          *IWORK,
                    INTEGER          *INFO)
{
    DEBUG_LAPACK_STUB("dgecon");
    LAPACK_IMPL(dgecon)(NORM,
                        N,
                        A,
                        LDA,
                        ANORM,
                        RCOND,
                        WORK,
                        IWORK,
                        INFO);
}

//-- dgeequ --------------------------------------------------------------------
void
LAPACK_DECL(dgeequ)(const INTEGER    *M,
                    const INTEGER    *N,
                    const DOUBLE     *A,
                    const INTEGER    *LDA,
                    DOUBLE           *R,
                    DOUBLE           *C,
                    DOUBLE           *ROWCND,
                    DOUBLE           *COLCND,
                    DOUBLE           *AMAX,
                    INTEGER          *INFO)
{
    DEBUG_LAPACK_STUB("dgeequ");
    LAPACK_IMPL(dgeequ)(M,
                        N,
                        A,
                        LDA,
                        R,
                        C,
                        ROWCND,
                        COLCND,
                        AMAX,
                        INFO);
}

//-- dgeequb -------------------------------------------------------------------
void
LAPACK_DECL(dgeequb)(const INTEGER    *M,
                     const INTEGER    *N,
                     const DOUBLE     *A,
                     const INTEGER    *LDA,
                     DOUBLE           *R,
                     DOUBLE           *C,
                     DOUBLE           *ROWCND,
                     DOUBLE           *COLCND,
                     DOUBLE           *AMAX,
                     INTEGER          *INFO)
{
    DEBUG_LAPACK_STUB("dgeequb");
    LAPACK_IMPL(dgeequb)(M,
                         N,
                         A,
                         LDA,
                         R,
                         C,
                         ROWCND,
                         COLCND,
                         AMAX,
                         INFO);
}

//-- dgees ---------------------------------------------------------------------
void
LAPACK_DECL(dgees)(const char           *JOBVS,
                   const char           *SORT,
                   const LOGICAL        *SELECT,
                   const INTEGER        *N,
                   DOUBLE               *A,
                   const INTEGER        *LDA,
                   INTEGER              *SDIM,
                   DOUBLE               *WR,
                   DOUBLE               *WI,
                   DOUBLE               *VS,
                   const INTEGER        *LDVS,
                   DOUBLE               *WORK,
                   const INTEGER        *LWORK,
                   LOGICAL              *BWORK,
                   INTEGER              *INFO)
{
    DEBUG_LAPACK_STUB("dgees");
    LAPACK_IMPL(dgees)(JOBVS,
                       SORT,
                       SELECT,
                       N,
                       A,
                       LDA,
                       SDIM,
                       WR,
                       WI,
                       VS,
                       LDVS,
                       WORK,
                       LWORK,
                       BWORK,
                       INFO);
}

//-- dgeesx --------------------------------------------------------------------
void
LAPACK_DECL(dgeesx)(const char       *JOBVS,
                    const char       *SORT,
                    const LOGICAL    *SELECT,
                    const char       *SENSE,
                    const INTEGER    *N,
                    DOUBLE           *A,
                    const INTEGER    *LDA,
                    INTEGER          *SDIM,
                    DOUBLE           *WR,
                    DOUBLE           *WI,
                    DOUBLE           *VS,
                    const INTEGER    *LDVS,
                    DOUBLE           *RCONDE,
                    DOUBLE           *RCONDV,
                    DOUBLE           *WORK,
                    const INTEGER    *LWORK,
                    INTEGER          *IWORK,
                    const INTEGER    *LIWORK,
                    LOGICAL          *BWORK,
                    INTEGER          *INFO)
{
    DEBUG_LAPACK_STUB("dgeesx");
    LAPACK_IMPL(dgeesx)(JOBVS,
                        SORT,
                        SELECT,
                        SENSE,
                        N,
                        A,
                        LDA,
                        SDIM,
                        WR,
                        WI,
                        VS,
                        LDVS,
                        RCONDE,
                        RCONDV,
                        WORK,
                        LWORK,
                        IWORK,
                        LIWORK,
                        BWORK,
                        INFO);
}

//-- dgeev ---------------------------------------------------------------------
void
LAPACK_DECL(dgeev)(const char           *JOBVL,
                   const char           *JOBVR,
                   const INTEGER        *N,
                   DOUBLE               *A,
                   const INTEGER        *LDA,
                   DOUBLE               *WR,
                   DOUBLE               *WI,
                   DOUBLE               *VL,
                   const INTEGER        *LDVL,
                   DOUBLE               *VR,
                   const INTEGER        *LDVR,
                   DOUBLE               *WORK,
                   const INTEGER        *LWORK,
                   INTEGER              *INFO)
{
    DEBUG_LAPACK_STUB("dgeev");
    LAPACK_IMPL(dgeev)(JOBVL,
                       JOBVR,
                       N,
                       A,
                       LDA,
                       WR,
                       WI,
                       VL,
                       LDVL,
                       VR,
                       LDVR,
                       WORK,
                       LWORK,
                       INFO);
}

//-- dgeevx --------------------------------------------------------------------
void
LAPACK_DECL(dgeevx)(const char       *BALANC,
                    const char       *JOBVL,
                    const char       *JOBVR,
                    const char       *SENSE,
                    const INTEGER    *N,
                    DOUBLE           *A,
                    const INTEGER    *LDA,
                    DOUBLE           *WR,
                    DOUBLE           *WI,
                    DOUBLE           *VL,
                    const INTEGER    *LDVL,
                    DOUBLE           *VR,
                    const INTEGER    *LDVR,
                    INTEGER          *ILO,
                    INTEGER          *IHI,
                    DOUBLE           *SCALE,
                    DOUBLE           *ABNRM,
                    DOUBLE           *RCONDE,
                    DOUBLE           *RCONDV,
                    DOUBLE           *WORK,
                    const INTEGER    *LWORK,
                    INTEGER          *IWORK,
                    INTEGER          *INFO)
{
    DEBUG_LAPACK_STUB("dgeevx");
    LAPACK_IMPL(dgeevx)(BALANC,
                        JOBVL,
                        JOBVR,
                        SENSE,
                        N,
                        A,
                        LDA,
                        WR,
                        WI,
                        VL,
                        LDVL,
                        VR,
                        LDVR,
                        ILO,
                        IHI,
                        SCALE,
                        ABNRM,
                        RCONDE,
                        RCONDV,
                        WORK,
                        LWORK,
                        IWORK,
                        INFO);
}

//-- dgegs ---------------------------------------------------------------------
void
LAPACK_DECL(dgegs)(const char           *JOBVSL,
                   const char           *JOBVSR,
                   const INTEGER        *N,
                   DOUBLE               *A,
                   const INTEGER        *LDA,
                   DOUBLE               *B,
                   const INTEGER        *LDB,
                   DOUBLE               *ALPHAR,
                   DOUBLE               *ALPHAI,
                   DOUBLE               *BETA,
                   DOUBLE               *VSL,
                   const INTEGER        *LDVSL,
                   DOUBLE               *VSR,
                   const INTEGER        *LDVSR,
                   DOUBLE               *WORK,
                   const INTEGER        *LWORK,
                   INTEGER              *INFO)
{
    DEBUG_LAPACK_STUB("dgegs");
    LAPACK_IMPL(dgegs)(JOBVSL,
                       JOBVSR,
                       N,
                       A,
                       LDA,
                       B,
                       LDB,
                       ALPHAR,
                       ALPHAI,
                       BETA,
                       VSL,
                       LDVSL,
                       VSR,
                       LDVSR,
                       WORK,
                       LWORK,
                       INFO);
}

//-- dgegv ---------------------------------------------------------------------
void
LAPACK_DECL(dgegv)(const char           *JOBVL,
                   const char           *JOBVR,
                   const INTEGER        *N,
                   DOUBLE               *A,
                   const INTEGER        *LDA,
                   DOUBLE               *B,
                   const INTEGER        *LDB,
                   DOUBLE               *ALPHAR,
                   DOUBLE               *ALPHAI,
                   DOUBLE               *BETA,
                   DOUBLE               *VL,
                   const INTEGER        *LDVL,
                   DOUBLE               *VR,
                   const INTEGER        *LDVR,
                   DOUBLE               *WORK,
                   const INTEGER        *LWORK,
                   INTEGER              *INFO)
{
    DEBUG_LAPACK_STUB("dgegv");
    LAPACK_IMPL(dgegv)(JOBVL,
                       JOBVR,
                       N,
                       A,
                       LDA,
                       B,
                       LDB,
                       ALPHAR,
                       ALPHAI,
                       BETA,
                       VL,
                       LDVL,
                       VR,
                       LDVR,
                       WORK,
                       LWORK,
                       INFO);
}

//-- dgehd2 --------------------------------------------------------------------
void
LAPACK_DECL(dgehd2)(const INTEGER    *N,
                    const INTEGER    *ILO,
                    const INTEGER    *IHI,
                    DOUBLE           *A,
                    const INTEGER    *LDA,
                    DOUBLE           *TAU,
                    DOUBLE           *WORK,
                    INTEGER          *INFO)
{
    DEBUG_LAPACK_STUB("dgehd2");
    LAPACK_IMPL(dgehd2)(N,
                        ILO,
                        IHI,
                        A,
                        LDA,
                        TAU,
                        WORK,
                        INFO);
}

//-- dgehrd --------------------------------------------------------------------
void
LAPACK_DECL(dgehrd)(const INTEGER    *N,
                    const INTEGER    *ILO,
                    const INTEGER    *IHI,
                    DOUBLE           *A,
                    const INTEGER    *LDA,
                    DOUBLE           *TAU,
                    DOUBLE           *WORK,
                    const INTEGER    *LWORK,
                    INTEGER          *INFO)
{
    DEBUG_LAPACK_STUB("dgehrd");
    LAPACK_IMPL(dgehrd)(N,
                        ILO,
                        IHI,
                        A,
                        LDA,
                        TAU,
                        WORK,
                        LWORK,
                        INFO);
}

//-- dgejsv --------------------------------------------------------------------
void
LAPACK_DECL(dgejsv)(const char       *JOBA,
                    const char       *JOBU,
                    const char       *JOBV,
                    const char       *JOBR,
                    const char       *JOBT,
                    const char       *JOBP,
                    const INTEGER    *M,
                    const INTEGER    *N,
                    DOUBLE           *A,
                    const INTEGER    *LDA,
                    DOUBLE           *SVA,
                    DOUBLE           *U,
                    const INTEGER    *LDU,
                    DOUBLE           *V,
                    const INTEGER    *LDV,
                    DOUBLE           *WORK,
                    const INTEGER    *LWORK,
                    INTEGER          *IWORK,
                    INTEGER          *INFO)
{
    DEBUG_LAPACK_STUB("dgejsv");
    LAPACK_IMPL(dgejsv)(JOBA,
                        JOBU,
                        JOBV,
                        JOBR,
                        JOBT,
                        JOBP,
                        M,
                        N,
                        A,
                        LDA,
                        SVA,
                        U,
                        LDU,
                        V,
                        LDV,
                        WORK,
                        LWORK,
                        IWORK,
                        INFO);
}

//-- dgelq2 --------------------------------------------------------------------
void
LAPACK_DECL(dgelq2)(const INTEGER    *M,
                    const INTEGER    *N,
                    DOUBLE           *A,
                    const INTEGER    *LDA,
                    DOUBLE           *TAU,
                    DOUBLE           *WORK,
                    INTEGER          *INFO)
{
    DEBUG_LAPACK_STUB("dgelq2");
    LAPACK_IMPL(dgelq2)(M,
                        N,
                        A,
                        LDA,
                        TAU,
                        WORK,
                        INFO);
}

//-- dgelqf --------------------------------------------------------------------
void
LAPACK_DECL(dgelqf)(const INTEGER    *M,
                    const INTEGER    *N,
                    DOUBLE           *A,
                    const INTEGER    *LDA,
                    DOUBLE           *TAU,
                    DOUBLE           *WORK,
                    const INTEGER    *LWORK,
                    INTEGER          *INFO)
{
    DEBUG_LAPACK_STUB("dgelqf");
    LAPACK_IMPL(dgelqf)(M,
                        N,
                        A,
                        LDA,
                        TAU,
                        WORK,
                        LWORK,
                        INFO);
}

//-- dgels ---------------------------------------------------------------------
void
LAPACK_DECL(dgels)(const char           *TRANS,
                   const INTEGER        *M,
                   const INTEGER        *N,
                   const INTEGER        *NRHS,
                   DOUBLE               *A,
                   const INTEGER        *LDA,
                   DOUBLE               *B,
                   const INTEGER        *LDB,
                   DOUBLE               *WORK,
                   const INTEGER        *LWORK,
                   INTEGER              *INFO)
{
    DEBUG_LAPACK_STUB("dgels");
    LAPACK_IMPL(dgels)(TRANS,
                       M,
                       N,
                       NRHS,
                       A,
                       LDA,
                       B,
                       LDB,
                       WORK,
                       LWORK,
                       INFO);
}

//-- dgelsd --------------------------------------------------------------------
void
LAPACK_DECL(dgelsd)(const INTEGER    *M,
                    const INTEGER    *N,
                    const INTEGER    *NRHS,
                    const DOUBLE     *A,
                    const INTEGER    *LDA,
                    DOUBLE           *B,
                    const INTEGER    *LDB,
                    DOUBLE           *S,
                    const DOUBLE     *RCOND,
                    INTEGER          *RANK,
                    DOUBLE           *WORK,
                    const INTEGER    *LWORK,
                    INTEGER          *IWORK,
                    INTEGER          *INFO)
{
    DEBUG_LAPACK_STUB("dgelsd");
    LAPACK_IMPL(dgelsd)(M,
                        N,
                        NRHS,
                        A,
                        LDA,
                        B,
                        LDB,
                        S,
                        RCOND,
                        RANK,
                        WORK,
                        LWORK,
                        IWORK,
                        INFO);
}

//-- dgelss --------------------------------------------------------------------
void
LAPACK_DECL(dgelss)(const INTEGER    *M,
                    const INTEGER    *N,
                    const INTEGER    *NRHS,
                    DOUBLE           *A,
                    const INTEGER    *LDA,
                    DOUBLE           *B,
                    const INTEGER    *LDB,
                    DOUBLE           *S,
                    const DOUBLE     *RCOND,
                    INTEGER          *RANK,
                    DOUBLE           *WORK,
                    const INTEGER    *LWORK,
                    INTEGER          *INFO)
{
    DEBUG_LAPACK_STUB("dgelss");
    LAPACK_IMPL(dgelss)(M,
                        N,
                        NRHS,
                        A,
                        LDA,
                        B,
                        LDB,
                        S,
                        RCOND,
                        RANK,
                        WORK,
                        LWORK,
                        INFO);
}

//-- dgelsx --------------------------------------------------------------------
void
LAPACK_DECL(dgelsx)(const INTEGER    *M,
                    const INTEGER    *N,
                    const INTEGER    *NRHS,
                    DOUBLE           *A,
                    const INTEGER    *LDA,
                    DOUBLE           *B,
                    const INTEGER    *LDB,
                    INTEGER          *JPVT,
                    const DOUBLE     *RCOND,
                    INTEGER          *RANK,
                    DOUBLE           *WORK,
                    INTEGER          *INFO)
{
    DEBUG_LAPACK_STUB("dgelsx");
    LAPACK_IMPL(dgelsx)(M,
                        N,
                        NRHS,
                        A,
                        LDA,
                        B,
                        LDB,
                        JPVT,
                        RCOND,
                        RANK,
                        WORK,
                        INFO);
}

//-- dgelsy --------------------------------------------------------------------
void
LAPACK_DECL(dgelsy)(const INTEGER    *M,
                    const INTEGER    *N,
                    const INTEGER    *NRHS,
                    DOUBLE           *A,
                    const INTEGER    *LDA,
                    DOUBLE           *B,
                    const INTEGER    *LDB,
                    INTEGER          *JPVT,
                    const DOUBLE     *RCOND,
                    INTEGER          *RANK,
                    DOUBLE           *WORK,
                    const INTEGER    *LWORK,
                    INTEGER          *INFO)
{
    DEBUG_LAPACK_STUB("dgelsy");
    LAPACK_IMPL(dgelsy)(M,
                        N,
                        NRHS,
                        A,
                        LDA,
                        B,
                        LDB,
                        JPVT,
                        RCOND,
                        RANK,
                        WORK,
                        LWORK,
                        INFO);
}

//-- dgeql2 --------------------------------------------------------------------
void
LAPACK_DECL(dgeql2)(const INTEGER    *M,
                    const INTEGER    *N,
                    DOUBLE           *A,
                    const INTEGER    *LDA,
                    DOUBLE           *TAU,
                    DOUBLE           *WORK,
                    INTEGER          *INFO)
{
    DEBUG_LAPACK_STUB("dgeql2");
    LAPACK_IMPL(dgeql2)(M,
                        N,
                        A,
                        LDA,
                        TAU,
                        WORK,
                        INFO);
}

//-- dgeqlf --------------------------------------------------------------------
void
LAPACK_DECL(dgeqlf)(const INTEGER    *M,
                    const INTEGER    *N,
                    DOUBLE           *A,
                    const INTEGER    *LDA,
                    DOUBLE           *TAU,
                    DOUBLE           *WORK,
                    const INTEGER    *LWORK,
                    INTEGER          *INFO)
{
    DEBUG_LAPACK_STUB("dgeqlf");
    LAPACK_IMPL(dgeqlf)(M,
                        N,
                        A,
                        LDA,
                        TAU,
                        WORK,
                        LWORK,
                        INFO);
}

//-- dgeqp3 --------------------------------------------------------------------
void
LAPACK_DECL(dgeqp3)(const INTEGER    *M,
                    const INTEGER    *N,
                    DOUBLE           *A,
                    const INTEGER    *LDA,
                    INTEGER          *JPVT,
                    DOUBLE           *TAU,
                    DOUBLE           *WORK,
                    const INTEGER    *LWORK,
                    INTEGER          *INFO)
{
    DEBUG_LAPACK_STUB("dgeqp3");
    LAPACK_IMPL(dgeqp3)(M,
                        N,
                        A,
                        LDA,
                        JPVT,
                        TAU,
                        WORK,
                        LWORK,
                        INFO);
}

//-- dgeqpf --------------------------------------------------------------------
void
LAPACK_DECL(dgeqpf)(const INTEGER    *M,
                    const INTEGER    *N,
                    DOUBLE           *A,
                    const INTEGER    *LDA,
                    INTEGER          *JPVT,
                    DOUBLE           *TAU,
                    DOUBLE           *WORK,
                    INTEGER          *INFO)
{
    DEBUG_LAPACK_STUB("dgeqpf");
    LAPACK_IMPL(dgeqpf)(M,
                        N,
                        A,
                        LDA,
                        JPVT,
                        TAU,
                        WORK,
                        INFO);
}

//-- dgeqr2 --------------------------------------------------------------------
void
LAPACK_DECL(dgeqr2)(const INTEGER    *M,
                    const INTEGER    *N,
                    DOUBLE           *A,
                    const INTEGER    *LDA,
                    DOUBLE           *TAU,
                    DOUBLE           *WORK,
                    INTEGER          *INFO)
{
    DEBUG_LAPACK_STUB("dgeqr2");
    LAPACK_IMPL(dgeqr2)(M,
                        N,
                        A,
                        LDA,
                        TAU,
                        WORK,
                        INFO);
}

//-- dgeqr2p -------------------------------------------------------------------
void
LAPACK_DECL(dgeqr2p)(const INTEGER    *M,
                     const INTEGER    *N,
                     DOUBLE           *A,
                     const INTEGER    *LDA,
                     DOUBLE           *TAU,
                     DOUBLE           *WORK,
                     INTEGER          *INFO)
{
    DEBUG_LAPACK_STUB("dgeqr2p");
    LAPACK_IMPL(dgeqr2p)(M,
                         N,
                         A,
                         LDA,
                         TAU,
                         WORK,
                         INFO);
}

//-- dgeqrf --------------------------------------------------------------------
void
LAPACK_DECL(dgeqrf)(const INTEGER    *M,
                    const INTEGER    *N,
                    DOUBLE           *A,
                    const INTEGER    *LDA,
                    DOUBLE           *TAU,
                    DOUBLE           *WORK,
                    const INTEGER    *LWORK,
                    INTEGER          *INFO)
{
    DEBUG_LAPACK_STUB("dgeqrf");
    LAPACK_IMPL(dgeqrf)(M,
                        N,
                        A,
                        LDA,
                        TAU,
                        WORK,
                        LWORK,
                        INFO);
}

//-- dgeqrfp -------------------------------------------------------------------
void
LAPACK_DECL(dgeqrfp)(const INTEGER    *M,
                     const INTEGER    *N,
                     DOUBLE           *A,
                     const INTEGER    *LDA,
                     DOUBLE           *TAU,
                     DOUBLE           *WORK,
                     const INTEGER    *LWORK,
                     INTEGER          *INFO)
{
    DEBUG_LAPACK_STUB("dgeqrfp");
    LAPACK_IMPL(dgeqrfp)(M,
                         N,
                         A,
                         LDA,
                         TAU,
                         WORK,
                         LWORK,
                         INFO);
}

//-- dgerfs --------------------------------------------------------------------
void
LAPACK_DECL(dgerfs)(const char       *TRANS,
                    const INTEGER    *N,
                    const INTEGER    *NRHS,
                    const DOUBLE     *A,
                    const INTEGER    *LDA,
                    const DOUBLE     *AF,
                    const INTEGER    *LDAF,
                    const INTEGER    *IPIV,
                    const DOUBLE     *B,
                    const INTEGER    *LDB,
                    DOUBLE           *X,
                    const INTEGER    *LDX,
                    DOUBLE           *FERR,
                    DOUBLE           *BERR,
                    DOUBLE           *WORK,
                    INTEGER          *IWORK,
                    INTEGER          *INFO)
{
    DEBUG_LAPACK_STUB("dgerfs");
    LAPACK_IMPL(dgerfs)(TRANS,
                        N,
                        NRHS,
                        A,
                        LDA,
                        AF,
                        LDAF,
                        IPIV,
                        B,
                        LDB,
                        X,
                        LDX,
                        FERR,
                        BERR,
                        WORK,
                        IWORK,
                        INFO);
}

//-- dgerfsx -------------------------------------------------------------------
void
LAPACK_DECL(dgerfsx)(const char       *TRANS,
                     const char       *EQUED,
                     const INTEGER    *N,
                     const INTEGER    *NRHS,
                     const DOUBLE     *A,
                     const INTEGER    *LDA,
                     const DOUBLE     *AF,
                     const INTEGER    *LDAF,
                     const INTEGER    *IPIV,
                     const DOUBLE     *R,
                     const DOUBLE     *C,
                     const DOUBLE     *B,
                     const INTEGER    *LDB,
                     DOUBLE           *X,
                     const INTEGER    *LDX,
                     DOUBLE           *RCOND,
                     DOUBLE           *BERR,
                     const INTEGER    *N_ERR_BNDS,
                     DOUBLE           *ERR_BNDS_NORM,
                     DOUBLE           *ERR_BNDS_COMP,
                     const INTEGER    *NPARAMS,
                     DOUBLE           *PARAMS,
                     DOUBLE           *WORK,
                     INTEGER          *IWORK,
                     INTEGER          *INFO)
{
    DEBUG_LAPACK_STUB("dgerfsx");
    LAPACK_IMPL(dgerfsx)(TRANS,
                         EQUED,
                         N,
                         NRHS,
                         A,
                         LDA,
                         AF,
                         LDAF,
                         IPIV,
                         R,
                         C,
                         B,
                         LDB,
                         X,
                         LDX,
                         RCOND,
                         BERR,
                         N_ERR_BNDS,
                         ERR_BNDS_NORM,
                         ERR_BNDS_COMP,
                         NPARAMS,
                         PARAMS,
                         WORK,
                         IWORK,
                         INFO);
}

//-- dgerq2 --------------------------------------------------------------------
void
LAPACK_DECL(dgerq2)(const INTEGER    *M,
                    const INTEGER    *N,
                    DOUBLE           *A,
                    const INTEGER    *LDA,
                    DOUBLE           *TAU,
                    DOUBLE           *WORK,
                    INTEGER          *INFO)
{
    DEBUG_LAPACK_STUB("dgerq2");
    LAPACK_IMPL(dgerq2)(M,
                        N,
                        A,
                        LDA,
                        TAU,
                        WORK,
                        INFO);
}

//-- dgerqf --------------------------------------------------------------------
void
LAPACK_DECL(dgerqf)(const INTEGER    *M,
                    const INTEGER    *N,
                    DOUBLE           *A,
                    const INTEGER    *LDA,
                    DOUBLE           *TAU,
                    DOUBLE           *WORK,
                    const INTEGER    *LWORK,
                    INTEGER          *INFO)
{
    DEBUG_LAPACK_STUB("dgerqf");
    LAPACK_IMPL(dgerqf)(M,
                        N,
                        A,
                        LDA,
                        TAU,
                        WORK,
                        LWORK,
                        INFO);
}

//-- dgesc2 --------------------------------------------------------------------
void
LAPACK_DECL(dgesc2)(const INTEGER    *N,
                    const DOUBLE     *A,
                    const INTEGER    *LDA,
                    DOUBLE           *RHS,
                    const INTEGER    *IPIV,
                    const INTEGER    *JPIV,
                    DOUBLE           *SCALE)
{
    DEBUG_LAPACK_STUB("dgesc2");
    LAPACK_IMPL(dgesc2)(N,
                        A,
                        LDA,
                        RHS,
                        IPIV,
                        JPIV,
                        SCALE);
}

//-- dgesdd --------------------------------------------------------------------
void
LAPACK_DECL(dgesdd)(const char       *JOBZ,
                    const INTEGER    *M,
                    const INTEGER    *N,
                    DOUBLE           *A,
                    const INTEGER    *LDA,
                    DOUBLE           *S,
                    DOUBLE           *U,
                    const INTEGER    *LDU,
                    DOUBLE           *VT,
                    const INTEGER    *LDVT,
                    DOUBLE           *WORK,
                    const INTEGER    *LWORK,
                    INTEGER          *IWORK,
                    INTEGER          *INFO)
{
    DEBUG_LAPACK_STUB("dgesdd");
    LAPACK_IMPL(dgesdd)(JOBZ,
                        M,
                        N,
                        A,
                        LDA,
                        S,
                        U,
                        LDU,
                        VT,
                        LDVT,
                        WORK,
                        LWORK,
                        IWORK,
                        INFO);
}

//-- dgesv ---------------------------------------------------------------------
void
LAPACK_DECL(dgesv)(const INTEGER        *N,
                   const INTEGER        *NRHS,
                   DOUBLE               *A,
                   const INTEGER        *LDA,
                   INTEGER              *IPIV,
                   DOUBLE               *B,
                   const INTEGER        *LDB,
                   INTEGER              *INFO)
{
    DEBUG_LAPACK_STUB("dgesv");
    LAPACK_IMPL(dgesv)(N,
                       NRHS,
                       A,
                       LDA,
                       IPIV,
                       B,
                       LDB,
                       INFO);
}

//-- dgesvd --------------------------------------------------------------------
void
LAPACK_DECL(dgesvd)(const char       *JOBU,
                    const char       *JOBVT,
                    const INTEGER    *M,
                    const INTEGER    *N,
                    DOUBLE           *A,
                    const INTEGER    *LDA,
                    DOUBLE           *S,
                    DOUBLE           *U,
                    const INTEGER    *LDU,
                    DOUBLE           *VT,
                    const INTEGER    *LDVT,
                    DOUBLE           *WORK,
                    const INTEGER    *LWORK,
                    INTEGER          *INFO)
{
    DEBUG_LAPACK_STUB("dgesvd");
    LAPACK_IMPL(dgesvd)(JOBU,
                        JOBVT,
                        M,
                        N,
                        A,
                        LDA,
                        S,
                        U,
                        LDU,
                        VT,
                        LDVT,
                        WORK,
                        LWORK,
                        INFO);
}

//-- dgesvj --------------------------------------------------------------------
void
LAPACK_DECL(dgesvj)(const char       *JOBA,
                    const char       *JOBU,
                    const char       *JOBV,
                    const INTEGER    *M,
                    const INTEGER    *N,
                    DOUBLE           *A,
                    const INTEGER    *LDA,
                    DOUBLE           *SVA,
                    const INTEGER    *MV,
                    DOUBLE           *V,
                    const INTEGER    *LDV,
                    DOUBLE           *WORK,
                    const INTEGER    *LWORK,
                    INTEGER          *INFO)
{
    DEBUG_LAPACK_STUB("dgesvj");
    LAPACK_IMPL(dgesvj)(JOBA,
                        JOBU,
                        JOBV,
                        M,
                        N,
                        A,
                        LDA,
                        SVA,
                        MV,
                        V,
                        LDV,
                        WORK,
                        LWORK,
                        INFO);
}

//-- dgesvx --------------------------------------------------------------------
void
LAPACK_DECL(dgesvx)(const char       *FACT,
                    const char       *TRANS,
                    const INTEGER    *N,
                    const INTEGER    *NRHS,
                    DOUBLE           *A,
                    const INTEGER    *LDA,
                    DOUBLE           *AF,
                    const INTEGER    *LDAF,
                    INTEGER          *IPIV,
                    char             *EQUED,
                    DOUBLE           *R,
                    DOUBLE           *C,
                    DOUBLE           *B,
                    const INTEGER    *LDB,
                    DOUBLE           *X,
                    const INTEGER    *LDX,
                    DOUBLE           *RCOND,
                    DOUBLE           *FERR,
                    DOUBLE           *BERR,
                    DOUBLE           *WORK,
                    INTEGER          *IWORK,
                    INTEGER          *INFO)
{
    DEBUG_LAPACK_STUB("dgesvx");
    LAPACK_IMPL(dgesvx)(FACT,
                        TRANS,
                        N,
                        NRHS,
                        A,
                        LDA,
                        AF,
                        LDAF,
                        IPIV,
                        EQUED,
                        R,
                        C,
                        B,
                        LDB,
                        X,
                        LDX,
                        RCOND,
                        FERR,
                        BERR,
                        WORK,
                        IWORK,
                        INFO);
}

//-- dgesvxx -------------------------------------------------------------------
void
LAPACK_DECL(dgesvxx)(const char       *FACT,
                     const char       *TRANS,
                     const INTEGER    *N,
                     const INTEGER    *NRHS,
                     DOUBLE           *A,
                     const INTEGER    *LDA,
                     DOUBLE           *AF,
                     const INTEGER    *LDAF,
                     INTEGER          *IPIV,
                     char             *EQUED,
                     DOUBLE           *R,
                     DOUBLE           *C,
                     DOUBLE           *B,
                     const INTEGER    *LDB,
                     DOUBLE           *X,
                     const INTEGER    *LDX,
                     DOUBLE           *RCOND,
                     DOUBLE           *RPVGRW,
                     DOUBLE           *BERR,
                     const INTEGER    *N_ERR_BNDS,
                     DOUBLE           *ERR_BNDS_NORM,
                     DOUBLE           *ERR_BNDS_COMP,
                     const INTEGER    *NPARAMS,
                     DOUBLE           *PARAMS,
                     DOUBLE           *WORK,
                     INTEGER          *IWORK,
                     INTEGER          *INFO)
{
    DEBUG_LAPACK_STUB("dgesvxx");
    LAPACK_IMPL(dgesvxx)(FACT,
                         TRANS,
                         N,
                         NRHS,
                         A,
                         LDA,
                         AF,
                         LDAF,
                         IPIV,
                         EQUED,
                         R,
                         C,
                         B,
                         LDB,
                         X,
                         LDX,
                         RCOND,
                         RPVGRW,
                         BERR,
                         N_ERR_BNDS,
                         ERR_BNDS_NORM,
                         ERR_BNDS_COMP,
                         NPARAMS,
                         PARAMS,
                         WORK,
                         IWORK,
                         INFO);
}

//-- dgetc2 --------------------------------------------------------------------
void
LAPACK_DECL(dgetc2)(const INTEGER    *N,
                    DOUBLE           *A,
                    const INTEGER    *LDA,
                    INTEGER          *IPIV,
                    INTEGER          *JPIV,
                    INTEGER          *INFO)
{
    DEBUG_LAPACK_STUB("dgetc2");
    LAPACK_IMPL(dgetc2)(N,
                        A,
                        LDA,
                        IPIV,
                        JPIV,
                        INFO);
}

//-- dgetf2 --------------------------------------------------------------------
void
LAPACK_DECL(dgetf2)(const INTEGER    *M,
                    const INTEGER    *N,
                    DOUBLE           *A,
                    const INTEGER    *LDA,
                    INTEGER          *IPIV,
                    INTEGER          *INFO)
{
    DEBUG_LAPACK_STUB("dgetf2");
    LAPACK_IMPL(dgetf2)(M,
                        N,
                        A,
                        LDA,
                        IPIV,
                        INFO);
}

//-- dgetrf --------------------------------------------------------------------
void
LAPACK_DECL(dgetrf)(const INTEGER    *M,
                    const INTEGER    *N,
                    DOUBLE           *A,
                    const INTEGER    *LDA,
                    INTEGER          *IPIV,
                    INTEGER          *INFO)
{
    DEBUG_LAPACK_STUB("dgetrf");
    LAPACK_IMPL(dgetrf)(M,
                        N,
                        A,
                        LDA,
                        IPIV,
                        INFO);
}

//-- dgetri --------------------------------------------------------------------
void
LAPACK_DECL(dgetri)(const INTEGER    *N,
                    DOUBLE           *A,
                    const INTEGER    *LDA,
                    const INTEGER    *IPIV,
                    DOUBLE           *WORK,
                    const INTEGER    *LWORK,
                    INTEGER          *INFO)
{
    DEBUG_LAPACK_STUB("dgetri");
    LAPACK_IMPL(dgetri)(N,
                        A,
                        LDA,
                        IPIV,
                        WORK,
                        LWORK,
                        INFO);
}

//-- dgetrs --------------------------------------------------------------------
void
LAPACK_DECL(dgetrs)(const char       *TRANS,
                    const INTEGER    *N,
                    const INTEGER    *NRHS,
                    const DOUBLE     *A,
                    const INTEGER    *LDA,
                    const INTEGER    *IPIV,
                    DOUBLE           *B,
                    const INTEGER    *LDB,
                    INTEGER          *INFO)
{
    DEBUG_LAPACK_STUB("dgetrs");
    LAPACK_IMPL(dgetrs)(TRANS,
                        N,
                        NRHS,
                        A,
                        LDA,
                        IPIV,
                        B,
                        LDB,
                        INFO);
}

//-- dggbak --------------------------------------------------------------------
void
LAPACK_DECL(dggbak)(const char       *JOB,
                    const char       *SIDE,
                    const INTEGER    *N,
                    const INTEGER    *ILO,
                    const INTEGER    *IHI,
                    const DOUBLE     *LSCALE,
                    const DOUBLE     *RSCALE,
                    const INTEGER    *M,
                    DOUBLE           *V,
                    const INTEGER    *LDV,
                    INTEGER          *INFO)
{
    DEBUG_LAPACK_STUB("dggbak");
    LAPACK_IMPL(dggbak)(JOB,
                        SIDE,
                        N,
                        ILO,
                        IHI,
                        LSCALE,
                        RSCALE,
                        M,
                        V,
                        LDV,
                        INFO);
}

//-- dggbal --------------------------------------------------------------------
void
LAPACK_DECL(dggbal)(const char       *JOB,
                    const INTEGER    *N,
                    DOUBLE           *A,
                    const INTEGER    *LDA,
                    DOUBLE           *B,
                    const INTEGER    *LDB,
                    INTEGER          *ILO,
                    INTEGER          *IHI,
                    DOUBLE           *LSCALE,
                    DOUBLE           *RSCALE,
                    DOUBLE           *WORK,
                    INTEGER          *INFO)
{
    DEBUG_LAPACK_STUB("dggbal");
    LAPACK_IMPL(dggbal)(JOB,
                        N,
                        A,
                        LDA,
                        B,
                        LDB,
                        ILO,
                        IHI,
                        LSCALE,
                        RSCALE,
                        WORK,
                        INFO);
}

//-- dgges ---------------------------------------------------------------------
void
LAPACK_DECL(dgges)(const char           *JOBVSL,
                   const char           *JOBVSR,
                   const char           *SORT,
                   const LOGICAL        *SELCTG,
                   const INTEGER        *N,
                   DOUBLE               *A,
                   const INTEGER        *LDA,
                   DOUBLE               *B,
                   const INTEGER        *LDB,
                   INTEGER              *SDIM,
                   DOUBLE               *ALPHAR,
                   DOUBLE               *ALPHAI,
                   DOUBLE               *BETA,
                   DOUBLE               *VSL,
                   const INTEGER        *LDVSL,
                   DOUBLE               *VSR,
                   const INTEGER        *LDVSR,
                   DOUBLE               *WORK,
                   const INTEGER        *LWORK,
                   LOGICAL              *BWORK,
                   INTEGER              *INFO)
{
    DEBUG_LAPACK_STUB("dgges");
    LAPACK_IMPL(dgges)(JOBVSL,
                       JOBVSR,
                       SORT,
                       SELCTG,
                       N,
                       A,
                       LDA,
                       B,
                       LDB,
                       SDIM,
                       ALPHAR,
                       ALPHAI,
                       BETA,
                       VSL,
                       LDVSL,
                       VSR,
                       LDVSR,
                       WORK,
                       LWORK,
                       BWORK,
                       INFO);
}

//-- dggesx --------------------------------------------------------------------
void
LAPACK_DECL(dggesx)(const char       *JOBVSL,
                    const char       *JOBVSR,
                    const char       *SORT,
                    const LOGICAL    *SELCTG,
                    const char       *SENSE,
                    const INTEGER    *N,
                    DOUBLE           *A,
                    const INTEGER    *LDA,
                    DOUBLE           *B,
                    const INTEGER    *LDB,
                    INTEGER          *SDIM,
                    DOUBLE           *ALPHAR,
                    DOUBLE           *ALPHAI,
                    DOUBLE           *BETA,
                    DOUBLE           *VSL,
                    const INTEGER    *LDVSL,
                    DOUBLE           *VSR,
                    const INTEGER    *LDVSR,
                    DOUBLE           *RCONDE,
                    DOUBLE           *RCONDV,
                    DOUBLE           *WORK,
                    const INTEGER    *LWORK,
                    INTEGER          *IWORK,
                    const INTEGER    *LIWORK,
                    LOGICAL          *BWORK,
                    INTEGER          *INFO)
{
    DEBUG_LAPACK_STUB("dggesx");
    LAPACK_IMPL(dggesx)(JOBVSL,
                        JOBVSR,
                        SORT,
                        SELCTG,
                        SENSE,
                        N,
                        A,
                        LDA,
                        B,
                        LDB,
                        SDIM,
                        ALPHAR,
                        ALPHAI,
                        BETA,
                        VSL,
                        LDVSL,
                        VSR,
                        LDVSR,
                        RCONDE,
                        RCONDV,
                        WORK,
                        LWORK,
                        IWORK,
                        LIWORK,
                        BWORK,
                        INFO);
}

//-- dggev ---------------------------------------------------------------------
void
LAPACK_DECL(dggev)(const char           *JOBVL,
                   const char           *JOBVR,
                   const INTEGER        *N,
                   DOUBLE               *A,
                   const INTEGER        *LDA,
                   DOUBLE               *B,
                   const INTEGER        *LDB,
                   DOUBLE               *ALPHAR,
                   DOUBLE               *ALPHAI,
                   DOUBLE               *BETA,
                   DOUBLE               *VL,
                   const INTEGER        *LDVL,
                   DOUBLE               *VR,
                   const INTEGER        *LDVR,
                   DOUBLE               *WORK,
                   const INTEGER        *LWORK,
                   INTEGER              *INFO)
{
    DEBUG_LAPACK_STUB("dggev");
    LAPACK_IMPL(dggev)(JOBVL,
                       JOBVR,
                       N,
                       A,
                       LDA,
                       B,
                       LDB,
                       ALPHAR,
                       ALPHAI,
                       BETA,
                       VL,
                       LDVL,
                       VR,
                       LDVR,
                       WORK,
                       LWORK,
                       INFO);
}

//-- dggevx --------------------------------------------------------------------
void
LAPACK_DECL(dggevx)(const char       *BALANC,
                    const char       *JOBVL,
                    const char       *JOBVR,
                    const char       *SENSE,
                    const INTEGER    *N,
                    DOUBLE           *A,
                    const INTEGER    *LDA,
                    DOUBLE           *B,
                    const INTEGER    *LDB,
                    DOUBLE           *ALPHAR,
                    DOUBLE           *ALPHAI,
                    DOUBLE           *BETA,
                    DOUBLE           *VL,
                    const INTEGER    *LDVL,
                    DOUBLE           *VR,
                    const INTEGER    *LDVR,
                    INTEGER          *ILO,
                    INTEGER          *IHI,
                    DOUBLE           *LSCALE,
                    DOUBLE           *RSCALE,
                    DOUBLE           *ABNRM,
                    DOUBLE           *BBNRM,
                    DOUBLE           *RCONDE,
                    DOUBLE           *RCONDV,
                    DOUBLE           *WORK,
                    const INTEGER    *LWORK,
                    INTEGER          *IWORK,
                    LOGICAL          *BWORK,
                    INTEGER          *INFO)
{
    DEBUG_LAPACK_STUB("dggevx");
    LAPACK_IMPL(dggevx)(BALANC,
                        JOBVL,
                        JOBVR,
                        SENSE,
                        N,
                        A,
                        LDA,
                        B,
                        LDB,
                        ALPHAR,
                        ALPHAI,
                        BETA,
                        VL,
                        LDVL,
                        VR,
                        LDVR,
                        ILO,
                        IHI,
                        LSCALE,
                        RSCALE,
                        ABNRM,
                        BBNRM,
                        RCONDE,
                        RCONDV,
                        WORK,
                        LWORK,
                        IWORK,
                        BWORK,
                        INFO);
}

//-- dggglm --------------------------------------------------------------------
void
LAPACK_DECL(dggglm)(const INTEGER    *N,
                    const INTEGER    *M,
                    const INTEGER    *P,
                    DOUBLE           *A,
                    const INTEGER    *LDA,
                    DOUBLE           *B,
                    const INTEGER    *LDB,
                    DOUBLE           *D,
                    DOUBLE           *X,
                    DOUBLE           *Y,
                    DOUBLE           *WORK,
                    const INTEGER    *LWORK,
                    INTEGER          *INFO)
{
    DEBUG_LAPACK_STUB("dggglm");
    LAPACK_IMPL(dggglm)(N,
                        M,
                        P,
                        A,
                        LDA,
                        B,
                        LDB,
                        D,
                        X,
                        Y,
                        WORK,
                        LWORK,
                        INFO);
}

//-- dgghrd --------------------------------------------------------------------
void
LAPACK_DECL(dgghrd)(const char       *COMPQ,
                    const char       *COMPZ,
                    const INTEGER    *N,
                    const INTEGER    *ILO,
                    const INTEGER    *IHI,
                    DOUBLE           *A,
                    const INTEGER    *LDA,
                    DOUBLE           *B,
                    const INTEGER    *LDB,
                    DOUBLE           *Q,
                    const INTEGER    *LDQ,
                    DOUBLE           *Z,
                    const INTEGER    *LDZ,
                    INTEGER          *INFO)
{
    DEBUG_LAPACK_STUB("dgghrd");
    LAPACK_IMPL(dgghrd)(COMPQ,
                        COMPZ,
                        N,
                        ILO,
                        IHI,
                        A,
                        LDA,
                        B,
                        LDB,
                        Q,
                        LDQ,
                        Z,
                        LDZ,
                        INFO);
}

//-- dgglse --------------------------------------------------------------------
void
LAPACK_DECL(dgglse)(const INTEGER    *M,
                    const INTEGER    *N,
                    const INTEGER    *P,
                    DOUBLE           *A,
                    const INTEGER    *LDA,
                    DOUBLE           *B,
                    const INTEGER    *LDB,
                    DOUBLE           *C,
                    DOUBLE           *D,
                    DOUBLE           *X,
                    DOUBLE           *WORK,
                    const INTEGER    *LWORK,
                    INTEGER          *INFO)
{
    DEBUG_LAPACK_STUB("dgglse");
    LAPACK_IMPL(dgglse)(M,
                        N,
                        P,
                        A,
                        LDA,
                        B,
                        LDB,
                        C,
                        D,
                        X,
                        WORK,
                        LWORK,
                        INFO);
}

//-- dggqrf --------------------------------------------------------------------
void
LAPACK_DECL(dggqrf)(const INTEGER    *N,
                    const INTEGER    *M,
                    const INTEGER    *P,
                    DOUBLE           *A,
                    const INTEGER    *LDA,
                    DOUBLE           *TAUA,
                    DOUBLE           *B,
                    const INTEGER    *LDB,
                    DOUBLE           *TAUB,
                    DOUBLE           *WORK,
                    const INTEGER    *LWORK,
                    INTEGER          *INFO)
{
    DEBUG_LAPACK_STUB("dggqrf");
    LAPACK_IMPL(dggqrf)(N,
                        M,
                        P,
                        A,
                        LDA,
                        TAUA,
                        B,
                        LDB,
                        TAUB,
                        WORK,
                        LWORK,
                        INFO);
}

//-- dggrqf --------------------------------------------------------------------
void
LAPACK_DECL(dggrqf)(const INTEGER    *M,
                    const INTEGER    *P,
                    const INTEGER    *N,
                    DOUBLE           *A,
                    const INTEGER    *LDA,
                    DOUBLE           *TAUA,
                    DOUBLE           *B,
                    const INTEGER    *LDB,
                    DOUBLE           *TAUB,
                    DOUBLE           *WORK,
                    const INTEGER    *LWORK,
                    INTEGER          *INFO)
{
    DEBUG_LAPACK_STUB("dggrqf");
    LAPACK_IMPL(dggrqf)(M,
                        P,
                        N,
                        A,
                        LDA,
                        TAUA,
                        B,
                        LDB,
                        TAUB,
                        WORK,
                        LWORK,
                        INFO);
}

//-- dggsvd --------------------------------------------------------------------
void
LAPACK_DECL(dggsvd)(const char       *JOBU,
                    const char       *JOBV,
                    const char       *JOBQ,
                    const INTEGER    *M,
                    const INTEGER    *N,
                    const INTEGER    *P,
                    INTEGER          *K,
                    INTEGER          *L,
                    DOUBLE           *A,
                    const INTEGER    *LDA,
                    DOUBLE           *B,
                    const INTEGER    *LDB,
                    DOUBLE           *ALPHA,
                    DOUBLE           *BETA,
                    DOUBLE           *U,
                    const INTEGER    *LDU,
                    DOUBLE           *V,
                    const INTEGER    *LDV,
                    DOUBLE           *Q,
                    const INTEGER    *LDQ,
                    DOUBLE           *WORK,
                    INTEGER          *IWORK,
                    INTEGER          *INFO)
{
    DEBUG_LAPACK_STUB("dggsvd");
    LAPACK_IMPL(dggsvd)(JOBU,
                        JOBV,
                        JOBQ,
                        M,
                        N,
                        P,
                        K,
                        L,
                        A,
                        LDA,
                        B,
                        LDB,
                        ALPHA,
                        BETA,
                        U,
                        LDU,
                        V,
                        LDV,
                        Q,
                        LDQ,
                        WORK,
                        IWORK,
                        INFO);
}

//-- dggsvp --------------------------------------------------------------------
void
LAPACK_DECL(dggsvp)(const char       *JOBU,
                    const char       *JOBV,
                    const char       *JOBQ,
                    const INTEGER    *M,
                    const INTEGER    *P,
                    const INTEGER    *N,
                    DOUBLE           *A,
                    const INTEGER    *LDA,
                    DOUBLE           *B,
                    const INTEGER    *LDB,
                    const DOUBLE     *TOLA,
                    const DOUBLE     *TOLB,
                    INTEGER          *K,
                    INTEGER          *L,
                    DOUBLE           *U,
                    const INTEGER    *LDU,
                    DOUBLE           *V,
                    const INTEGER    *LDV,
                    DOUBLE           *Q,
                    const INTEGER    *LDQ,
                    INTEGER          *IWORK,
                    DOUBLE           *TAU,
                    DOUBLE           *WORK,
                    INTEGER          *INFO)
{
    DEBUG_LAPACK_STUB("dggsvp");
    LAPACK_IMPL(dggsvp)(JOBU,
                        JOBV,
                        JOBQ,
                        M,
                        P,
                        N,
                        A,
                        LDA,
                        B,
                        LDB,
                        TOLA,
                        TOLB,
                        K,
                        L,
                        U,
                        LDU,
                        V,
                        LDV,
                        Q,
                        LDQ,
                        IWORK,
                        TAU,
                        WORK,
                        INFO);
}

//-- dgsvj0 --------------------------------------------------------------------
void
LAPACK_DECL(dgsvj0)(const char       *JOBV,
                    const INTEGER    *M,
                    const INTEGER    *N,
                    DOUBLE           *A,
                    const INTEGER    *LDA,
                    DOUBLE           *D,
                    DOUBLE           *SVA,
                    const INTEGER    *MV,
                    DOUBLE           *V,
                    const INTEGER    *LDV,
                    const DOUBLE     *EPS,
                    const DOUBLE     *SFMIN,
                    const DOUBLE     *TOL,
                    const INTEGER    *NSWEEP,
                    DOUBLE           *WORK,
                    const INTEGER    *LWORK,
                    INTEGER          *INFO)
{
    DEBUG_LAPACK_STUB("dgsvj0");
    LAPACK_IMPL(dgsvj0)(JOBV,
                        M,
                        N,
                        A,
                        LDA,
                        D,
                        SVA,
                        MV,
                        V,
                        LDV,
                        EPS,
                        SFMIN,
                        TOL,
                        NSWEEP,
                        WORK,
                        LWORK,
                        INFO);
}

//-- dgsvj1 --------------------------------------------------------------------
void
LAPACK_DECL(dgsvj1)(const char       *JOBV,
                    const INTEGER    *M,
                    const INTEGER    *N,
                    const INTEGER    *N1,
                    DOUBLE           *A,
                    const INTEGER    *LDA,
                    DOUBLE           *D,
                    DOUBLE           *SVA,
                    const INTEGER    *MV,
                    DOUBLE           *V,
                    const INTEGER    *LDV,
                    const DOUBLE     *EPS,
                    const DOUBLE     *SFMIN,
                    const DOUBLE     *TOL,
                    const INTEGER    *NSWEEP,
                    DOUBLE           *WORK,
                    const INTEGER    *LWORK,
                    INTEGER          *INFO)
{
    DEBUG_LAPACK_STUB("dgsvj1");
    LAPACK_IMPL(dgsvj1)(JOBV,
                        M,
                        N,
                        N1,
                        A,
                        LDA,
                        D,
                        SVA,
                        MV,
                        V,
                        LDV,
                        EPS,
                        SFMIN,
                        TOL,
                        NSWEEP,
                        WORK,
                        LWORK,
                        INFO);
}

//-- dgtcon --------------------------------------------------------------------
void
LAPACK_DECL(dgtcon)(const char       *NORM,
                    const INTEGER    *N,
                    const DOUBLE     *DL,
                    const DOUBLE     *D,
                    const DOUBLE     *DU,
                    const DOUBLE     *DU2,
                    const INTEGER    *IPIV,
                    const DOUBLE     *ANORM,
                    DOUBLE           *RCOND,
                    DOUBLE           *WORK,
                    INTEGER          *IWORK,
                    INTEGER          *INFO)
{
    DEBUG_LAPACK_STUB("dgtcon");
    LAPACK_IMPL(dgtcon)(NORM,
                        N,
                        DL,
                        D,
                        DU,
                        DU2,
                        IPIV,
                        ANORM,
                        RCOND,
                        WORK,
                        IWORK,
                        INFO);
}

//-- dgtrfs --------------------------------------------------------------------
void
LAPACK_DECL(dgtrfs)(const char       *TRANS,
                    const INTEGER    *N,
                    const INTEGER    *NRHS,
                    const DOUBLE     *DL,
                    const DOUBLE     *D,
                    const DOUBLE     *DU,
                    const DOUBLE     *DLF,
                    const DOUBLE     *DF,
                    const DOUBLE     *DUF,
                    const DOUBLE     *DU2,
                    const INTEGER    *IPIV,
                    const DOUBLE     *B,
                    const INTEGER    *LDB,
                    DOUBLE           *X,
                    const INTEGER    *LDX,
                    DOUBLE           *FERR,
                    DOUBLE           *BERR,
                    DOUBLE           *WORK,
                    INTEGER          *IWORK,
                    INTEGER          *INFO)
{
    DEBUG_LAPACK_STUB("dgtrfs");
    LAPACK_IMPL(dgtrfs)(TRANS,
                        N,
                        NRHS,
                        DL,
                        D,
                        DU,
                        DLF,
                        DF,
                        DUF,
                        DU2,
                        IPIV,
                        B,
                        LDB,
                        X,
                        LDX,
                        FERR,
                        BERR,
                        WORK,
                        IWORK,
                        INFO);
}

//-- dgtsv ---------------------------------------------------------------------
void
LAPACK_DECL(dgtsv)(const INTEGER        *N,
                   const INTEGER        *NRHS,
                   DOUBLE               *DL,
                   DOUBLE               *D,
                   DOUBLE               *DU,
                   DOUBLE               *B,
                   const INTEGER        *LDB,
                   INTEGER              *INFO)
{
    DEBUG_LAPACK_STUB("dgtsv");
    LAPACK_IMPL(dgtsv)(N,
                       NRHS,
                       DL,
                       D,
                       DU,
                       B,
                       LDB,
                       INFO);
}

//-- dgtsvx --------------------------------------------------------------------
void
LAPACK_DECL(dgtsvx)(const char       *FACT,
                    const char       *TRANS,
                    const INTEGER    *N,
                    const INTEGER    *NRHS,
                    const DOUBLE     *DL,
                    const DOUBLE     *D,
                    const DOUBLE     *DU,
                    DOUBLE           *DLF,
                    DOUBLE           *DF,
                    DOUBLE           *DUF,
                    DOUBLE           *DU2,
                    INTEGER          *IPIV,
                    const DOUBLE     *B,
                    const INTEGER    *LDB,
                    DOUBLE           *X,
                    const INTEGER    *LDX,
                    DOUBLE           *RCOND,
                    DOUBLE           *FERR,
                    DOUBLE           *BERR,
                    DOUBLE           *WORK,
                    INTEGER          *IWORK,
                    INTEGER          *INFO)
{
    DEBUG_LAPACK_STUB("dgtsvx");
    LAPACK_IMPL(dgtsvx)(FACT,
                        TRANS,
                        N,
                        NRHS,
                        DL,
                        D,
                        DU,
                        DLF,
                        DF,
                        DUF,
                        DU2,
                        IPIV,
                        B,
                        LDB,
                        X,
                        LDX,
                        RCOND,
                        FERR,
                        BERR,
                        WORK,
                        IWORK,
                        INFO);
}

//-- dgttrf --------------------------------------------------------------------
void
LAPACK_DECL(dgttrf)(const INTEGER    *N,
                    DOUBLE           *DL,
                    DOUBLE           *D,
                    DOUBLE           *DU,
                    DOUBLE           *DU2,
                    INTEGER          *IPIV,
                    INTEGER          *INFO)
{
    DEBUG_LAPACK_STUB("dgttrf");
    LAPACK_IMPL(dgttrf)(N,
                        DL,
                        D,
                        DU,
                        DU2,
                        IPIV,
                        INFO);
}

//-- dgttrs --------------------------------------------------------------------
void
LAPACK_DECL(dgttrs)(const char       *TRANS,
                    const INTEGER    *N,
                    const INTEGER    *NRHS,
                    const DOUBLE     *DL,
                    const DOUBLE     *D,
                    const DOUBLE     *DU,
                    const DOUBLE     *DU2,
                    const INTEGER    *IPIV,
                    DOUBLE           *B,
                    const INTEGER    *LDB,
                    INTEGER          *INFO)
{
    DEBUG_LAPACK_STUB("dgttrs");
    LAPACK_IMPL(dgttrs)(TRANS,
                        N,
                        NRHS,
                        DL,
                        D,
                        DU,
                        DU2,
                        IPIV,
                        B,
                        LDB,
                        INFO);
}

//-- dgtts2 --------------------------------------------------------------------
void
LAPACK_DECL(dgtts2)(const INTEGER    *ITRANS,
                    const INTEGER    *N,
                    const INTEGER    *NRHS,
                    const DOUBLE     *DL,
                    const DOUBLE     *D,
                    const DOUBLE     *DU,
                    const DOUBLE     *DU2,
                    const INTEGER    *IPIV,
                    DOUBLE           *B,
                    const INTEGER    *LDB)
{
    DEBUG_LAPACK_STUB("dgtts2");
    LAPACK_IMPL(dgtts2)(ITRANS,
                        N,
                        NRHS,
                        DL,
                        D,
                        DU,
                        DU2,
                        IPIV,
                        B,
                        LDB);
}

//-- dhgeqz --------------------------------------------------------------------
void
LAPACK_DECL(dhgeqz)(const char       *JOB,
                    const char       *COMPQ,
                    const char       *COMPZ,
                    const INTEGER    *N,
                    const INTEGER    *ILO,
                    const INTEGER    *IHI,
                    DOUBLE           *H,
                    const INTEGER    *LDH,
                    DOUBLE           *T,
                    const INTEGER    *LDT,
                    DOUBLE           *ALPHAR,
                    DOUBLE           *ALPHAI,
                    DOUBLE           *BETA,
                    DOUBLE           *Q,
                    const INTEGER    *LDQ,
                    DOUBLE           *Z,
                    const INTEGER    *LDZ,
                    DOUBLE           *WORK,
                    const INTEGER    *LWORK,
                    INTEGER          *INFO)
{
    DEBUG_LAPACK_STUB("dhgeqz");
    LAPACK_IMPL(dhgeqz)(JOB,
                        COMPQ,
                        COMPZ,
                        N,
                        ILO,
                        IHI,
                        H,
                        LDH,
                        T,
                        LDT,
                        ALPHAR,
                        ALPHAI,
                        BETA,
                        Q,
                        LDQ,
                        Z,
                        LDZ,
                        WORK,
                        LWORK,
                        INFO);
}

//-- dhsein --------------------------------------------------------------------
void
LAPACK_DECL(dhsein)(const char       *SIDE,
                    const char       *EIGSRC,
                    const char       *INITV,
                    LOGICAL          *SELECT,
                    const INTEGER    *N,
                    const DOUBLE     *H,
                    const INTEGER    *LDH,
                    DOUBLE           *WR,
                    const DOUBLE     *WI,
                    DOUBLE           *VL,
                    const INTEGER    *LDVL,
                    DOUBLE           *VR,
                    const INTEGER    *LDVR,
                    const INTEGER    *MM,
                    INTEGER          *M,
                    DOUBLE           *WORK,
                    INTEGER          *IFAILL,
                    INTEGER          *IFAILR,
                    INTEGER          *INFO)
{
    DEBUG_LAPACK_STUB("dhsein");
    LAPACK_IMPL(dhsein)(SIDE,
                        EIGSRC,
                        INITV,
                        SELECT,
                        N,
                        H,
                        LDH,
                        WR,
                        WI,
                        VL,
                        LDVL,
                        VR,
                        LDVR,
                        MM,
                        M,
                        WORK,
                        IFAILL,
                        IFAILR,
                        INFO);
}

//-- dhseqr --------------------------------------------------------------------
void
LAPACK_DECL(dhseqr)(const char       *JOB,
                    const char       *COMPZ,
                    const INTEGER    *N,
                    const INTEGER    *ILO,
                    const INTEGER    *IHI,
                    DOUBLE           *H,
                    const INTEGER    *LDH,
                    DOUBLE           *WR,
                    DOUBLE           *WI,
                    DOUBLE           *Z,
                    const INTEGER    *LDZ,
                    DOUBLE           *WORK,
                    const INTEGER    *LWORK,
                    INTEGER          *INFO)
{
    DEBUG_LAPACK_STUB("dhseqr");
    LAPACK_IMPL(dhseqr)(JOB,
                        COMPZ,
                        N,
                        ILO,
                        IHI,
                        H,
                        LDH,
                        WR,
                        WI,
                        Z,
                        LDZ,
                        WORK,
                        LWORK,
                        INFO);
}

//-- disnan --------------------------------------------------------------------
LOGICAL
LAPACK_DECL(disnan)(const DOUBLE     *DIN)
{
    DEBUG_LAPACK_STUB("disnan");
    return LAPACK_IMPL(disnan)(DIN);
}

//-- dla_gbamv -----------------------------------------------------------------
void
LAPACK_DECL(dla_gbamv)(const INTEGER        *TRANS,
                       const INTEGER        *M,
                       const INTEGER        *N,
                       const INTEGER        *KL,
                       const INTEGER        *KU,
                       const DOUBLE         *ALPHA,
                       const DOUBLE         *AB,
                       const INTEGER        *LDAB,
                       const DOUBLE         *X,
                       const INTEGER        *INCX,
                       const DOUBLE         *BETA,
                       DOUBLE               *Y,
                       const INTEGER        *INCY)
{
    DEBUG_LAPACK_STUB("dla_gbamv");
    LAPACK_IMPL(dla_gbamv)(TRANS,
                           M,
                           N,
                           KL,
                           KU,
                           ALPHA,
                           AB,
                           LDAB,
                           X,
                           INCX,
                           BETA,
                           Y,
                           INCY);
}

//-- dla_gbrcond ---------------------------------------------------------------
DOUBLE
LAPACK_DECL(dla_gbrcond)(const char       *TRANS,
                         const INTEGER    *N,
                         const INTEGER    *KL,
                         const INTEGER    *KU,
                         const DOUBLE     *AB,
                         const INTEGER    *LDAB,
                         const DOUBLE     *AFB,
                         const INTEGER    *LDAFB,
                         const INTEGER    *IPIV,
                         const INTEGER    *CMODE,
                         const DOUBLE     *C,
                         INTEGER          *INFO,
                         const DOUBLE     *WORK,
                         const INTEGER    *IWORK)
{
    DEBUG_LAPACK_STUB("dla_gbrcond");
    return LAPACK_IMPL(dla_gbrcond)(TRANS,
                                    N,
                                    KL,
                                    KU,
                                    AB,
                                    LDAB,
                                    AFB,
                                    LDAFB,
                                    IPIV,
                                    CMODE,
                                    C,
                                    INFO,
                                    WORK,
                                    IWORK);
}

//-- dla_gbrfsx_extended -------------------------------------------------------
void
LAPACK_DECL(dla_gbrfsx_extended)(const INTEGER    *PREC_TYPE,
                                 const INTEGER    *TRANS_TYPE,
                                 const INTEGER    *N,
                                 const INTEGER    *KL,
                                 const INTEGER    *KU,
                                 const INTEGER    *NRHS,
                                 const DOUBLE     *AB,
                                 const INTEGER    *LDAB,
                                 const DOUBLE     *AFB,
                                 const INTEGER    *LDAFB,
                                 const INTEGER    *IPIV,
                                 const LOGICAL    *COLEQU,
                                 const DOUBLE     *C,
                                 const DOUBLE     *B,
                                 const INTEGER    *LDB,
                                 DOUBLE           *Y,
                                 const INTEGER    *LDY,
                                 DOUBLE           *BERR_OUT,
                                 const INTEGER    *N_NORMS,
                                 DOUBLE           *ERR_BNDS_NORM,
                                 DOUBLE           *ERR_BNDS_COMP,
                                 const DOUBLE     *RES,
                                 const DOUBLE     *AYB,
                                 const DOUBLE     *DY,
                                 const DOUBLE     *Y_TAIL,
                                 const DOUBLE     *RCOND,
                                 const INTEGER    *ITHRESH,
                                 const DOUBLE     *RTHRESH,
                                 const DOUBLE     *DZ_UB,
                                 const LOGICAL    *IGNORE_CWISE,
                                 INTEGER          *INFO)
{
    DEBUG_LAPACK_STUB("dla_gbrfsx_extended");
    ASSERT(0);
    /*
    LAPACK_IMPL(dla_gbrfsx_extended)(PREC_TYPE,
                                     TRANS_TYPE,
                                     N,
                                     KL,
                                     KU,
                                     NRHS,
                                     AB,
                                     LDAB,
                                     AFB,
                                     LDAFB,
                                     IPIV,
                                     COLEQU,
                                     C,
                                     B,
                                     LDB,
                                     Y,
                                     LDY,
                                     BERR_OUT,
                                     N_NORMS,
                                     ERR_BNDS_NORM,
                                     ERR_BNDS_COMP,
                                     RES,
                                     AYB,
                                     DY,
                                     Y_TAIL,
                                     RCOND,
                                     ITHRESH,
                                     RTHRESH,
                                     DZ_UB,
                                     IGNORE_CWISE,
                                     INFO);
    */
}

//-- dla_gbrpvgrw --------------------------------------------------------------
DOUBLE
LAPACK_DECL(dla_gbrpvgrw)(const INTEGER    *N,
                          const INTEGER    *KL,
                          const INTEGER    *KU,
                          const INTEGER    *NCOLS,
                          const DOUBLE     *AB,
                          const INTEGER    *LDAB,
                          const DOUBLE     *AFB,
                          const INTEGER    *LDAFB)
{
    DEBUG_LAPACK_STUB("dla_gbrpvgrw");
    return LAPACK_IMPL(dla_gbrpvgrw)(N,
                                     KL,
                                     KU,
                                     NCOLS,
                                     AB,
                                     LDAB,
                                     AFB,
                                     LDAFB);
}

//-- dla_geamv -----------------------------------------------------------------
void
LAPACK_DECL(dla_geamv)(const INTEGER        *TRANS,
                       const INTEGER        *M,
                       const INTEGER        *N,
                       const DOUBLE         *ALPHA,
                       const DOUBLE         *A,
                       const INTEGER        *LDA,
                       const DOUBLE         *X,
                       const INTEGER        *INCX,
                       const DOUBLE         *BETA,
                       DOUBLE               *Y,
                       const INTEGER        *INCY)
{
    DEBUG_LAPACK_STUB("dla_geamv");
    LAPACK_IMPL(dla_geamv)(TRANS,
                           M,
                           N,
                           ALPHA,
                           A,
                           LDA,
                           X,
                           INCX,
                           BETA,
                           Y,
                           INCY);
}

//-- dla_gercond ---------------------------------------------------------------
DOUBLE
LAPACK_DECL(dla_gercond)(const char       *TRANS,
                         const INTEGER    *N,
                         const DOUBLE     *A,
                         const INTEGER    *LDA,
                         const DOUBLE     *AF,
                         const INTEGER    *LDAF,
                         const INTEGER    *IPIV,
                         const INTEGER    *CMODE,
                         const DOUBLE     *C,
                         INTEGER          *INFO,
                         const DOUBLE     *WORK,
                         const INTEGER    *IWORK)
{
    DEBUG_LAPACK_STUB("dla_gercond");
    return LAPACK_IMPL(dla_gercond)(TRANS,
                                    N,
                                    A,
                                    LDA,
                                    AF,
                                    LDAF,
                                    IPIV,
                                    CMODE,
                                    C,
                                    INFO,
                                    WORK,
                                    IWORK);
}

//-- dla_gerfsx_extended -------------------------------------------------------
void
LAPACK_DECL(dla_gerfsx_extended)(const INTEGER    *PREC_TYPE,
                                 const INTEGER    *TRANS_TYPE,
                                 const INTEGER    *N,
                                 const INTEGER    *NRHS,
                                 const DOUBLE     *A,
                                 const INTEGER    *LDA,
                                 const DOUBLE     *AF,
                                 const INTEGER    *LDAF,
                                 const INTEGER    *IPIV,
                                 const LOGICAL    *COLEQU,
                                 const DOUBLE     *C,
                                 const DOUBLE     *B,
                                 const INTEGER    *LDB,
                                 DOUBLE           *Y,
                                 const INTEGER    *LDY,
                                 DOUBLE           *BERR_OUT,
                                 const INTEGER    *N_NORMS,
                                 const DOUBLE     *ERRS_N,
                                 const DOUBLE     *ERRS_C,
                                 const DOUBLE     *RES,
                                 const DOUBLE     *AYB,
                                 const DOUBLE     *DY,
                                 const DOUBLE     *Y_TAIL,
                                 const DOUBLE     *RCOND,
                                 const INTEGER    *ITHRESH,
                                 const DOUBLE     *RTHRESH,
                                 const DOUBLE     *DZ_UB,
                                 const LOGICAL    *IGNORE_CWISE,
                                 INTEGER          *INFO)
{
    DEBUG_LAPACK_STUB("dla_gerfsx_extended");
    ASSERT(0);
    /*
    LAPACK_IMPL(dla_gerfsx_extended)(PREC_TYPE,
                                     TRANS_TYPE,
                                     N,
                                     NRHS,
                                     A,
                                     LDA,
                                     AF,
                                     LDAF,
                                     IPIV,
                                     COLEQU,
                                     C,
                                     B,
                                     LDB,
                                     Y,
                                     LDY,
                                     BERR_OUT,
                                     N_NORMS,
                                     ERRS_N,
                                     ERRS_C,
                                     RES,
                                     AYB,
                                     DY,
                                     Y_TAIL,
                                     RCOND,
                                     ITHRESH,
                                     RTHRESH,
                                     DZ_UB,
                                     IGNORE_CWISE,
                                     INFO);
    */
}

//-- dla_lin_berr --------------------------------------------------------------
void
LAPACK_DECL(dla_lin_berr)(const INTEGER    *N,
                          const INTEGER    *NZ,
                          const INTEGER    *NRHS,
                          const DOUBLE     *RES,
                          const DOUBLE     *AYB,
                          DOUBLE           *BERR)
{
    DEBUG_LAPACK_STUB("dla_lin_berr");
    LAPACK_IMPL(dla_lin_berr)(N,
                              NZ,
                              NRHS,
                              RES,
                              AYB,
                              BERR);
}

//-- dla_porcond ---------------------------------------------------------------
DOUBLE
LAPACK_DECL(dla_porcond)(const char       *UPLO,
                         const INTEGER    *N,
                         const DOUBLE     *A,
                         const INTEGER    *LDA,
                         const DOUBLE     *AF,
                         const INTEGER    *LDAF,
                         const INTEGER    *CMODE,
                         const DOUBLE     *C,
                         INTEGER          *INFO,
                         const DOUBLE     *WORK,
                         const INTEGER    *IWORK)
{
    DEBUG_LAPACK_STUB("dla_porcond");
    return LAPACK_IMPL(dla_porcond)(UPLO,
                                    N,
                                    A,
                                    LDA,
                                    AF,
                                    LDAF,
                                    CMODE,
                                    C,
                                    INFO,
                                    WORK,
                                    IWORK);
}

//-- dla_porfsx_extended -------------------------------------------------------
void
LAPACK_DECL(dla_porfsx_extended)(const INTEGER    *PREC_TYPE,
                                 const char       *UPLO,
                                 const INTEGER    *N,
                                 const INTEGER    *NRHS,
                                 const DOUBLE     *A,
                                 const INTEGER    *LDA,
                                 const DOUBLE     *AF,
                                 const INTEGER    *LDAF,
                                 const LOGICAL    *COLEQU,
                                 const DOUBLE     *C,
                                 const DOUBLE     *B,
                                 const INTEGER    *LDB,
                                 DOUBLE           *Y,
                                 const INTEGER    *LDY,
                                 DOUBLE           *BERR_OUT,
                                 const INTEGER    *N_NORMS,
                                 DOUBLE           *ERR_BNDS_NORM,
                                 DOUBLE           *ERR_BNDS_COMP,
                                 const DOUBLE     *RES,
                                 const DOUBLE     *AYB,
                                 const DOUBLE     *DY,
                                 const DOUBLE     *Y_TAIL,
                                 const DOUBLE     *RCOND,
                                 const INTEGER    *ITHRESH,
                                 const DOUBLE     *RTHRESH,
                                 const DOUBLE     *DZ_UB,
                                 const LOGICAL    *IGNORE_CWISE,
                                 INTEGER          *INFO)
{
    DEBUG_LAPACK_STUB("dla_porfsx_extended");
    ASSERT(0);
    /*
    LAPACK_IMPL(dla_porfsx_extended)(PREC_TYPE,
                                     UPLO,
                                     N,
                                     NRHS,
                                     A,
                                     LDA,
                                     AF,
                                     LDAF,
                                     COLEQU,
                                     C,
                                     B,
                                     LDB,
                                     Y,
                                     LDY,
                                     BERR_OUT,
                                     N_NORMS,
                                     ERR_BNDS_NORM,
                                     ERR_BNDS_COMP,
                                     RES,
                                     AYB,
                                     DY,
                                     Y_TAIL,
                                     RCOND,
                                     ITHRESH,
                                     RTHRESH,
                                     DZ_UB,
                                     IGNORE_CWISE,
                                     INFO);
    */
}

//-- dla_porpvgrw --------------------------------------------------------------
DOUBLE
LAPACK_DECL(dla_porpvgrw)(const char       *UPLO,
                          const INTEGER    *NCOLS,
                          const DOUBLE     *A,
                          const INTEGER    *LDA,
                          const DOUBLE     *AF,
                          const INTEGER    *LDAF,
                          const DOUBLE     *WORK)
{
    DEBUG_LAPACK_STUB("dla_porpvgrw");
    return LAPACK_IMPL(dla_porpvgrw)(UPLO,
                                     NCOLS,
                                     A,
                                     LDA,
                                     AF,
                                     LDAF,
                                     WORK);
}

//-- dla_rpvgrw ----------------------------------------------------------------
DOUBLE
LAPACK_DECL(dla_rpvgrw)(const INTEGER    *N,
                        const INTEGER    *NCOLS,
                        const DOUBLE     *A,
                        const INTEGER    *LDA,
                        const DOUBLE     *AF,
                        const INTEGER    *LDAF)
{
    DEBUG_LAPACK_STUB("dla_rpvgrw");
    return LAPACK_IMPL(dla_rpvgrw)(N,
                                   NCOLS,
                                   A,
                                   LDA,
                                   AF,
                                   LDAF);
}

//-- dla_syamv -----------------------------------------------------------------
void
LAPACK_DECL(dla_syamv)(const INTEGER        *UPLO,
                       const INTEGER        *N,
                       const DOUBLE         *ALPHA,
                       const DOUBLE         *A,
                       const INTEGER        *LDA,
                       const DOUBLE         *X,
                       const INTEGER        *INCX,
                       const DOUBLE         *BETA,
                       DOUBLE               *Y,
                       const INTEGER        *INCY)
{
    DEBUG_LAPACK_STUB("dla_syamv");
    LAPACK_IMPL(dla_syamv)(UPLO,
                           N,
                           ALPHA,
                           A,
                           LDA,
                           X,
                           INCX,
                           BETA,
                           Y,
                           INCY);
}

//-- dla_syrcond ---------------------------------------------------------------
DOUBLE
LAPACK_DECL(dla_syrcond)(const char       *UPLO,
                         const INTEGER    *N,
                         const DOUBLE     *A,
                         const INTEGER    *LDA,
                         const DOUBLE     *AF,
                         const INTEGER    *LDAF,
                         const INTEGER    *IPIV,
                         const INTEGER    *CMODE,
                         const DOUBLE     *C,
                         INTEGER          *INFO,
                         const DOUBLE     *WORK,
                         const INTEGER    *IWORK)
{
    DEBUG_LAPACK_STUB("dla_syrcond");
    return LAPACK_IMPL(dla_syrcond)(UPLO,
                                    N,
                                    A,
                                    LDA,
                                    AF,
                                    LDAF,
                                    IPIV,
                                    CMODE,
                                    C,
                                    INFO,
                                    WORK,
                                    IWORK);
}

//-- dla_syrfsx_extended -------------------------------------------------------
void
LAPACK_DECL(dla_syrfsx_extended)(const INTEGER    *PREC_TYPE,
                                 const char       *UPLO,
                                 const INTEGER    *N,
                                 const INTEGER    *NRHS,
                                 const DOUBLE     *A,
                                 const INTEGER    *LDA,
                                 const DOUBLE     *AF,
                                 const INTEGER    *LDAF,
                                 const INTEGER    *IPIV,
                                 const LOGICAL    *COLEQU,
                                 const DOUBLE     *C,
                                 const DOUBLE     *B,
                                 const INTEGER    *LDB,
                                 DOUBLE           *Y,
                                 const INTEGER    *LDY,
                                 DOUBLE           *BERR_OUT,
                                 const INTEGER    *N_NORMS,
                                 DOUBLE           *ERR_BNDS_NORM,
                                 DOUBLE           *ERR_BNDS_COMP,
                                 const DOUBLE     *RES,
                                 const DOUBLE     *AYB,
                                 const DOUBLE     *DY,
                                 const DOUBLE     *Y_TAIL,
                                 const DOUBLE     *RCOND,
                                 const INTEGER    *ITHRESH,
                                 const DOUBLE     *RTHRESH,
                                 const DOUBLE     *DZ_UB,
                                 const LOGICAL    *IGNORE_CWISE,
                                 INTEGER          *INFO)
{
    DEBUG_LAPACK_STUB("dla_syrfsx_extended");
    ASSERT(0);
    /*
    LAPACK_IMPL(dla_syrfsx_extended)(PREC_TYPE,
                                     UPLO,
                                     N,
                                     NRHS,
                                     A,
                                     LDA,
                                     AF,
                                     LDAF,
                                     IPIV,
                                     COLEQU,
                                     C,
                                     B,
                                     LDB,
                                     Y,
                                     LDY,
                                     BERR_OUT,
                                     N_NORMS,
                                     ERR_BNDS_NORM,
                                     ERR_BNDS_COMP,
                                     RES,
                                     AYB,
                                     DY,
                                     Y_TAIL,
                                     RCOND,
                                     ITHRESH,
                                     RTHRESH,
                                     DZ_UB,
                                     IGNORE_CWISE,
                                     INFO);
    */
}

//-- dla_syrpvgrw --------------------------------------------------------------
DOUBLE
LAPACK_DECL(dla_syrpvgrw)(const char       *UPLO,
                          const INTEGER    *N,
                          const INTEGER    *INFO,
                          const DOUBLE     *A,
                          const INTEGER    *LDA,
                          const DOUBLE     *AF,
                          const INTEGER    *LDAF,
                          const INTEGER    *IPIV,
                          const DOUBLE     *WORK)
{
    DEBUG_LAPACK_STUB("dla_syrpvgrw");
    return LAPACK_IMPL(dla_syrpvgrw)(UPLO,
                                     N,
                                     INFO,
                                     A,
                                     LDA,
                                     AF,
                                     LDAF,
                                     IPIV,
                                     WORK);
}

//-- dla_wwaddw ----------------------------------------------------------------
void
LAPACK_DECL(dla_wwaddw)(const INTEGER    *N,
                        DOUBLE           *X,
                        DOUBLE           *Y,
                        const DOUBLE     *W)
{
    DEBUG_LAPACK_STUB("dla_wwaddw");
    LAPACK_IMPL(dla_wwaddw)(N,
                            X,
                            Y,
                            W);
}

//-- dlabad --------------------------------------------------------------------
void
LAPACK_DECL(dlabad)(DOUBLE   *SMALL,
                    DOUBLE   *LARGE)
{
    DEBUG_LAPACK_STUB("dlabad");
    LAPACK_IMPL(dlabad)(SMALL,
                        LARGE);
}

//-- dlabrd --------------------------------------------------------------------
void
LAPACK_DECL(dlabrd)(const INTEGER    *M,
                    const INTEGER    *N,
                    const INTEGER    *NB,
                    DOUBLE           *A,
                    const INTEGER    *LDA,
                    DOUBLE           *D,
                    DOUBLE           *E,
                    DOUBLE           *TAUQ,
                    DOUBLE           *TAUP,
                    DOUBLE           *X,
                    const INTEGER    *LDX,
                    DOUBLE           *Y,
                    const INTEGER    *LDY)
{
    DEBUG_LAPACK_STUB("dlabrd");
    LAPACK_IMPL(dlabrd)(M,
                        N,
                        NB,
                        A,
                        LDA,
                        D,
                        E,
                        TAUQ,
                        TAUP,
                        X,
                        LDX,
                        Y,
                        LDY);
}

//-- dlacn2 --------------------------------------------------------------------
void
LAPACK_DECL(dlacn2)(const INTEGER    *N,
                    DOUBLE           *V,
                    DOUBLE           *X,
                    INTEGER          *ISGN,
                    DOUBLE           *EST,
                    INTEGER          *KASE,
                    INTEGER          *ISAVE)
{
    DEBUG_LAPACK_STUB("dlacn2");
    LAPACK_IMPL(dlacn2)(N,
                        V,
                        X,
                        ISGN,
                        EST,
                        KASE,
                        ISAVE);
}

//-- dlacon --------------------------------------------------------------------
void
LAPACK_DECL(dlacon)(const INTEGER    *N,
                    DOUBLE           *V,
                    DOUBLE           *X,
                    INTEGER          *ISGN,
                    DOUBLE           *EST,
                    INTEGER          *KASE)
{
    DEBUG_LAPACK_STUB("dlacon");
    LAPACK_IMPL(dlacon)(N,
                        V,
                        X,
                        ISGN,
                        EST,
                        KASE);
}

//-- dlacpy --------------------------------------------------------------------
void
LAPACK_DECL(dlacpy)(const char       *UPLO,
                    const INTEGER    *M,
                    const INTEGER    *N,
                    const DOUBLE     *A,
                    const INTEGER    *LDA,
                    DOUBLE           *B,
                    const INTEGER    *LDB)
{
    DEBUG_LAPACK_STUB("dlacpy");
    LAPACK_IMPL(dlacpy)(UPLO,
                        M,
                        N,
                        A,
                        LDA,
                        B,
                        LDB);
}

//-- dladiv --------------------------------------------------------------------
void
LAPACK_DECL(dladiv)(const DOUBLE     *A,
                    const DOUBLE     *B,
                    const DOUBLE     *C,
                    const DOUBLE     *D,
                    DOUBLE           *P,
                    DOUBLE           *Q)
{
    DEBUG_LAPACK_STUB("dladiv");
    LAPACK_IMPL(dladiv)(A,
                        B,
                        C,
                        D,
                        P,
                        Q);
}

//-- dlae2 ---------------------------------------------------------------------
void
LAPACK_DECL(dlae2)(const DOUBLE     *A,
                   const DOUBLE     *B,
                   const DOUBLE     *C,
                   DOUBLE           *RT1,
                   DOUBLE           *RT2)
{
    DEBUG_LAPACK_STUB("dlae2");
    LAPACK_IMPL(dlae2)(A,
                       B,
                       C,
                       RT1,
                       RT2);
}

//-- dlaebz --------------------------------------------------------------------
void
LAPACK_DECL(dlaebz)(const INTEGER    *IJOB,
                    const INTEGER    *NITMAX,
                    const INTEGER    *N,
                    const INTEGER    *MMAX,
                    const INTEGER    *MINP,
                    const INTEGER    *NBMIN,
                    const DOUBLE     *ABSTOL,
                    const DOUBLE     *RELTOL,
                    const DOUBLE     *PIVMIN,
                    const DOUBLE     *D,
                    const DOUBLE     *E,
                    const DOUBLE     *E2,
                    INTEGER          *NVAL,
                    DOUBLE           *AB,
                    DOUBLE           *C,
                    INTEGER          *MOUT,
                    INTEGER          *NAB,
                    DOUBLE           *WORK,
                    INTEGER          *IWORK,
                    INTEGER          *INFO)
{
    DEBUG_LAPACK_STUB("dlaebz");
    LAPACK_IMPL(dlaebz)(IJOB,
                        NITMAX,
                        N,
                        MMAX,
                        MINP,
                        NBMIN,
                        ABSTOL,
                        RELTOL,
                        PIVMIN,
                        D,
                        E,
                        E2,
                        NVAL,
                        AB,
                        C,
                        MOUT,
                        NAB,
                        WORK,
                        IWORK,
                        INFO);
}

//-- dlaed0 --------------------------------------------------------------------
void
LAPACK_DECL(dlaed0)(const INTEGER    *ICOMPQ,
                    const INTEGER    *QSIZ,
                    const INTEGER    *N,
                    DOUBLE           *D,
                    const DOUBLE     *E,
                    DOUBLE           *Q,
                    const INTEGER    *LDQ,
                    DOUBLE           *QSTORE,
                    const INTEGER    *LDQS,
                    DOUBLE           *WORK,
                    INTEGER          *IWORK,
                    INTEGER          *INFO)
{
    DEBUG_LAPACK_STUB("dlaed0");
    LAPACK_IMPL(dlaed0)(ICOMPQ,
                        QSIZ,
                        N,
                        D,
                        E,
                        Q,
                        LDQ,
                        QSTORE,
                        LDQS,
                        WORK,
                        IWORK,
                        INFO);
}

//-- dlaed1 --------------------------------------------------------------------
void
LAPACK_DECL(dlaed1)(const INTEGER    *N,
                    DOUBLE           *D,
                    DOUBLE           *Q,
                    const INTEGER    *LDQ,
                    INTEGER          *INDXQ,
                    const DOUBLE     *RHO,
                    const INTEGER    *CUTPNT,
                    DOUBLE           *WORK,
                    INTEGER          *IWORK,
                    INTEGER          *INFO)
{
    DEBUG_LAPACK_STUB("dlaed1");
    LAPACK_IMPL(dlaed1)(N,
                        D,
                        Q,
                        LDQ,
                        INDXQ,
                        RHO,
                        CUTPNT,
                        WORK,
                        IWORK,
                        INFO);
}

//-- dlaed2 --------------------------------------------------------------------
void
LAPACK_DECL(dlaed2)(INTEGER          *K,
                    const INTEGER    *N,
                    const INTEGER    *N1,
                    DOUBLE           *D,
                    DOUBLE           *Q,
                    const INTEGER    *LDQ,
                    INTEGER          *INDXQ,
                    DOUBLE           *RHO,
                    const DOUBLE     *Z,
                    DOUBLE           *DLAMDA,
                    DOUBLE           *W,
                    DOUBLE           *Q2,
                    INTEGER          *INDX,
                    INTEGER          *INDXC,
                    INTEGER          *INDXP,
                    INTEGER          *COLTYP,
                    INTEGER          *INFO)
{
    DEBUG_LAPACK_STUB("dlaed2");
    LAPACK_IMPL(dlaed2)(K,
                        N,
                        N1,
                        D,
                        Q,
                        LDQ,
                        INDXQ,
                        RHO,
                        Z,
                        DLAMDA,
                        W,
                        Q2,
                        INDX,
                        INDXC,
                        INDXP,
                        COLTYP,
                        INFO);
}

//-- dlaed3 --------------------------------------------------------------------
void
LAPACK_DECL(dlaed3)(const INTEGER    *K,
                    const INTEGER    *N,
                    const INTEGER    *N1,
                    DOUBLE           *D,
                    DOUBLE           *Q,
                    const INTEGER    *LDQ,
                    const DOUBLE     *RHO,
                    DOUBLE           *DLAMDA,
                    const DOUBLE     *Q2,
                    const INTEGER    *INDX,
                    const INTEGER    *CTOT,
                    DOUBLE           *W,
                    DOUBLE           *S,
                    INTEGER          *INFO)
{
    DEBUG_LAPACK_STUB("dlaed3");
    LAPACK_IMPL(dlaed3)(K,
                        N,
                        N1,
                        D,
                        Q,
                        LDQ,
                        RHO,
                        DLAMDA,
                        Q2,
                        INDX,
                        CTOT,
                        W,
                        S,
                        INFO);
}

//-- dlaed4 --------------------------------------------------------------------
void
LAPACK_DECL(dlaed4)(const INTEGER    *N,
                    const INTEGER    *I,
                    const DOUBLE     *D,
                    const DOUBLE     *Z,
                    DOUBLE           *DELTA,
                    const DOUBLE     *RHO,
                    DOUBLE           *DLAM,
                    INTEGER          *INFO)
{
    DEBUG_LAPACK_STUB("dlaed4");
    LAPACK_IMPL(dlaed4)(N,
                        I,
                        D,
                        Z,
                        DELTA,
                        RHO,
                        DLAM,
                        INFO);
}

//-- dlaed5 --------------------------------------------------------------------
void
LAPACK_DECL(dlaed5)(const INTEGER    *I,
                    const DOUBLE     *D,
                    const DOUBLE     *Z,
                    DOUBLE           *DELTA,
                    const DOUBLE     *RHO,
                    DOUBLE           *DLAM)
{
    DEBUG_LAPACK_STUB("dlaed5");
    LAPACK_IMPL(dlaed5)(I,
                        D,
                        Z,
                        DELTA,
                        RHO,
                        DLAM);
}

//-- dlaed6 --------------------------------------------------------------------
void
LAPACK_DECL(dlaed6)(const INTEGER    *KNITER,
                    const LOGICAL    *ORGATI,
                    const DOUBLE     *RHO,
                    const DOUBLE     *D,
                    const DOUBLE     *Z,
                    const DOUBLE     *FINIT,
                    DOUBLE           *TAU,
                    INTEGER          *INFO)
{
    DEBUG_LAPACK_STUB("dlaed6");
    LAPACK_IMPL(dlaed6)(KNITER,
                        ORGATI,
                        RHO,
                        D,
                        Z,
                        FINIT,
                        TAU,
                        INFO);
}

//-- dlaed7 --------------------------------------------------------------------
void
LAPACK_DECL(dlaed7)(const INTEGER    *ICOMPQ,
                    const INTEGER    *N,
                    const INTEGER    *QSIZ,
                    const INTEGER    *TLVLS,
                    const INTEGER    *CURLVL,
                    const INTEGER    *CURPBM,
                    DOUBLE           *D,
                    DOUBLE           *Q,
                    const INTEGER    *LDQ,
                    INTEGER          *INDXQ,
                    const DOUBLE     *RHO,
                    const INTEGER    *CUTPNT,
                    DOUBLE           *QSTORE,
                    INTEGER          *QPTR,
                    const INTEGER    *PRMPTR,
                    const INTEGER    *PERM,
                    const INTEGER    *GIVPTR,
                    const INTEGER    *GIVCOL,
                    const DOUBLE     *GIVNUM,
                    DOUBLE           *WORK,
                    INTEGER          *IWORK,
                    INTEGER          *INFO)
{
    DEBUG_LAPACK_STUB("dlaed7");
    LAPACK_IMPL(dlaed7)(ICOMPQ,
                        N,
                        QSIZ,
                        TLVLS,
                        CURLVL,
                        CURPBM,
                        D,
                        Q,
                        LDQ,
                        INDXQ,
                        RHO,
                        CUTPNT,
                        QSTORE,
                        QPTR,
                        PRMPTR,
                        PERM,
                        GIVPTR,
                        GIVCOL,
                        GIVNUM,
                        WORK,
                        IWORK,
                        INFO);
}

//-- dlaed8 --------------------------------------------------------------------
void
LAPACK_DECL(dlaed8)(const INTEGER    *ICOMPQ,
                    INTEGER          *K,
                    const INTEGER    *N,
                    const INTEGER    *QSIZ,
                    DOUBLE           *D,
                    DOUBLE           *Q,
                    const INTEGER    *LDQ,
                    const INTEGER    *INDXQ,
                    DOUBLE           *RHO,
                    const INTEGER    *CUTPNT,
                    const DOUBLE     *Z,
                    DOUBLE           *DLAMDA,
                    DOUBLE           *Q2,
                    const INTEGER    *LDQ2,
                    DOUBLE           *W,
                    INTEGER          *PERM,
                    INTEGER          *GIVPTR,
                    INTEGER          *GIVCOL,
                    DOUBLE           *GIVNUM,
                    INTEGER          *INDXP,
                    INTEGER          *INDX,
                    INTEGER          *INFO)
{
    DEBUG_LAPACK_STUB("dlaed8");
    LAPACK_IMPL(dlaed8)(ICOMPQ,
                        K,
                        N,
                        QSIZ,
                        D,
                        Q,
                        LDQ,
                        INDXQ,
                        RHO,
                        CUTPNT,
                        Z,
                        DLAMDA,
                        Q2,
                        LDQ2,
                        W,
                        PERM,
                        GIVPTR,
                        GIVCOL,
                        GIVNUM,
                        INDXP,
                        INDX,
                        INFO);
}

//-- dlaed9 --------------------------------------------------------------------
void
LAPACK_DECL(dlaed9)(const INTEGER    *K,
                    const INTEGER    *KSTART,
                    const INTEGER    *KSTOP,
                    const INTEGER    *N,
                    DOUBLE           *D,
                    DOUBLE           *Q,
                    const INTEGER    *LDQ,
                    const DOUBLE     *RHO,
                    const DOUBLE     *DLAMDA,
                    const DOUBLE     *W,
                    DOUBLE           *S,
                    const INTEGER    *LDS,
                    INTEGER          *INFO)
{
    DEBUG_LAPACK_STUB("dlaed9");
    LAPACK_IMPL(dlaed9)(K,
                        KSTART,
                        KSTOP,
                        N,
                        D,
                        Q,
                        LDQ,
                        RHO,
                        DLAMDA,
                        W,
                        S,
                        LDS,
                        INFO);
}

//-- dlaeda --------------------------------------------------------------------
void
LAPACK_DECL(dlaeda)(const INTEGER    *N,
                    const INTEGER    *TLVLS,
                    const INTEGER    *CURLVL,
                    const INTEGER    *CURPBM,
                    const INTEGER    *PRMPTR,
                    const INTEGER    *PERM,
                    const INTEGER    *GIVPTR,
                    const INTEGER    *GIVCOL,
                    const DOUBLE     *GIVNUM,
                    const DOUBLE     *Q,
                    const INTEGER    *QPTR,
                    DOUBLE           *Z,
                    DOUBLE           *ZTEMP,
                    INTEGER          *INFO)
{
    DEBUG_LAPACK_STUB("dlaeda");
    LAPACK_IMPL(dlaeda)(N,
                        TLVLS,
                        CURLVL,
                        CURPBM,
                        PRMPTR,
                        PERM,
                        GIVPTR,
                        GIVCOL,
                        GIVNUM,
                        Q,
                        QPTR,
                        Z,
                        ZTEMP,
                        INFO);
}

//-- dlaein --------------------------------------------------------------------
void
LAPACK_DECL(dlaein)(const LOGICAL    *RIGHTV,
                    const LOGICAL    *NOINIT,
                    const INTEGER    *N,
                    const DOUBLE     *H,
                    const INTEGER    *LDH,
                    const DOUBLE     *WR,
                    const DOUBLE     *WI,
                    DOUBLE           *VR,
                    DOUBLE           *VI,
                    DOUBLE           *B,
                    const INTEGER    *LDB,
                    DOUBLE           *WORK,
                    const DOUBLE     *EPS3,
                    const DOUBLE     *SMLNUM,
                    const DOUBLE     *BIGNUM,
                    INTEGER          *INFO)
{
    DEBUG_LAPACK_STUB("dlaein");
    LAPACK_IMPL(dlaein)(RIGHTV,
                        NOINIT,
                        N,
                        H,
                        LDH,
                        WR,
                        WI,
                        VR,
                        VI,
                        B,
                        LDB,
                        WORK,
                        EPS3,
                        SMLNUM,
                        BIGNUM,
                        INFO);
}

//-- dlaev2 --------------------------------------------------------------------
void
LAPACK_DECL(dlaev2)(const DOUBLE     *A,
                    const DOUBLE     *B,
                    const DOUBLE     *C,
                    DOUBLE           *RT1,
                    DOUBLE           *RT2,
                    DOUBLE           *CS1,
                    DOUBLE           *SN1)
{
    DEBUG_LAPACK_STUB("dlaev2");
    LAPACK_IMPL(dlaev2)(A,
                        B,
                        C,
                        RT1,
                        RT2,
                        CS1,
                        SN1);
}

//-- dlaexc --------------------------------------------------------------------
void
LAPACK_DECL(dlaexc)(const LOGICAL    *WANTQ,
                    const INTEGER    *N,
                    DOUBLE           *T,
                    const INTEGER    *LDT,
                    DOUBLE           *Q,
                    const INTEGER    *LDQ,
                    const INTEGER    *J1,
                    const INTEGER    *N1,
                    const INTEGER    *N2,
                    DOUBLE           *WORK,
                    INTEGER          *INFO)
{
    DEBUG_LAPACK_STUB("dlaexc");
    LAPACK_IMPL(dlaexc)(WANTQ,
                        N,
                        T,
                        LDT,
                        Q,
                        LDQ,
                        J1,
                        N1,
                        N2,
                        WORK,
                        INFO);
}

//-- dlag2 ---------------------------------------------------------------------
void
LAPACK_DECL(dlag2)(const DOUBLE         *A,
                   const INTEGER        *LDA,
                   const DOUBLE         *B,
                   const INTEGER        *LDB,
                   const DOUBLE         *SAFMIN,
                   DOUBLE               *SCALE1,
                   DOUBLE               *SCALE2,
                   DOUBLE               *WR1,
                   DOUBLE               *WR2,
                   DOUBLE               *WI)
{
    DEBUG_LAPACK_STUB("dlag2");
    LAPACK_IMPL(dlag2)(A,
                       LDA,
                       B,
                       LDB,
                       SAFMIN,
                       SCALE1,
                       SCALE2,
                       WR1,
                       WR2,
                       WI);
}

//-- dlag2s --------------------------------------------------------------------
void
LAPACK_DECL(dlag2s)(const INTEGER    *M,
                    const INTEGER    *N,
                    const DOUBLE     *A,
                    const INTEGER    *LDA,
                    FLOAT            *SA,
                    const INTEGER    *LDSA,
                    INTEGER          *INFO)
{
    DEBUG_LAPACK_STUB("dlag2s");
    LAPACK_IMPL(dlag2s)(M,
                        N,
                        A,
                        LDA,
                        SA,
                        LDSA,
                        INFO);
}

//-- dlags2 --------------------------------------------------------------------
void
LAPACK_DECL(dlags2)(const LOGICAL    *UPPER,
                    const DOUBLE     *A1,
                    const DOUBLE     *A2,
                    const DOUBLE     *A3,
                    const DOUBLE     *B1,
                    const DOUBLE     *B2,
                    const DOUBLE     *B3,
                    DOUBLE           *CSU,
                    DOUBLE           *SNU,
                    DOUBLE           *CSV,
                    DOUBLE           *SNV,
                    DOUBLE           *CSQ,
                    DOUBLE           *SNQ)
{
    DEBUG_LAPACK_STUB("dlags2");
    LAPACK_IMPL(dlags2)(UPPER,
                        A1,
                        A2,
                        A3,
                        B1,
                        B2,
                        B3,
                        CSU,
                        SNU,
                        CSV,
                        SNV,
                        CSQ,
                        SNQ);
}

//-- dlagtf --------------------------------------------------------------------
void
LAPACK_DECL(dlagtf)(const INTEGER    *N,
                    DOUBLE           *A,
                    const DOUBLE     *LAMBDA,
                    DOUBLE           *B,
                    DOUBLE           *C,
                    const DOUBLE     *TOL,
                    DOUBLE           *D,
                    INTEGER          *IN,
                    INTEGER          *INFO)
{
    DEBUG_LAPACK_STUB("dlagtf");
    LAPACK_IMPL(dlagtf)(N,
                        A,
                        LAMBDA,
                        B,
                        C,
                        TOL,
                        D,
                        IN,
                        INFO);
}

//-- dlagtm --------------------------------------------------------------------
void
LAPACK_DECL(dlagtm)(const char       *TRANS,
                    const INTEGER    *N,
                    const INTEGER    *NRHS,
                    const DOUBLE     *ALPHA,
                    const DOUBLE     *DL,
                    const DOUBLE     *D,
                    const DOUBLE     *DU,
                    const DOUBLE     *X,
                    const INTEGER    *LDX,
                    const DOUBLE     *BETA,
                    DOUBLE           *B,
                    const INTEGER    *LDB)
{
    DEBUG_LAPACK_STUB("dlagtm");
    LAPACK_IMPL(dlagtm)(TRANS,
                        N,
                        NRHS,
                        ALPHA,
                        DL,
                        D,
                        DU,
                        X,
                        LDX,
                        BETA,
                        B,
                        LDB);
}

//-- dlagts --------------------------------------------------------------------
void
LAPACK_DECL(dlagts)(const INTEGER    *JOB,
                    const INTEGER    *N,
                    const DOUBLE     *A,
                    const DOUBLE     *B,
                    const DOUBLE     *C,
                    const DOUBLE     *D,
                    const INTEGER    *IN,
                    DOUBLE           *Y,
                    DOUBLE           *TOL,
                    INTEGER          *INFO)
{
    DEBUG_LAPACK_STUB("dlagts");
    LAPACK_IMPL(dlagts)(JOB,
                        N,
                        A,
                        B,
                        C,
                        D,
                        IN,
                        Y,
                        TOL,
                        INFO);
}

//-- dlagv2 --------------------------------------------------------------------
void
LAPACK_DECL(dlagv2)(DOUBLE           *A,
                    const INTEGER    *LDA,
                    DOUBLE           *B,
                    const INTEGER    *LDB,
                    DOUBLE           *ALPHAR,
                    DOUBLE           *ALPHAI,
                    DOUBLE           *BETA,
                    DOUBLE           *CSL,
                    DOUBLE           *SNL,
                    DOUBLE           *CSR,
                    DOUBLE           *SNR)
{
    DEBUG_LAPACK_STUB("dlagv2");
    LAPACK_IMPL(dlagv2)(A,
                        LDA,
                        B,
                        LDB,
                        ALPHAR,
                        ALPHAI,
                        BETA,
                        CSL,
                        SNL,
                        CSR,
                        SNR);
}

//-- dlahqr --------------------------------------------------------------------
void
LAPACK_DECL(dlahqr)(const LOGICAL    *WANTT,
                    const LOGICAL    *WANTZ,
                    const INTEGER    *N,
                    const INTEGER    *ILO,
                    const INTEGER    *IHI,
                    DOUBLE           *H,
                    const INTEGER    *LDH,
                    DOUBLE           *WR,
                    DOUBLE           *WI,
                    const INTEGER    *ILOZ,
                    const INTEGER    *IHIZ,
                    DOUBLE           *Z,
                    const INTEGER    *LDZ,
                    INTEGER          *INFO)
{
    DEBUG_LAPACK_STUB("dlahqr");
    LAPACK_IMPL(dlahqr)(WANTT,
                        WANTZ,
                        N,
                        ILO,
                        IHI,
                        H,
                        LDH,
                        WR,
                        WI,
                        ILOZ,
                        IHIZ,
                        Z,
                        LDZ,
                        INFO);
}

//-- dlahr2 --------------------------------------------------------------------
void
LAPACK_DECL(dlahr2)(const INTEGER    *N,
                    const INTEGER    *K,
                    const INTEGER    *NB,
                    DOUBLE           *A,
                    const INTEGER    *LDA,
                    DOUBLE           *TAU,
                    DOUBLE           *T,
                    const INTEGER    *LDT,
                    DOUBLE           *Y,
                    const INTEGER    *LDY)
{
    DEBUG_LAPACK_STUB("dlahr2");
    LAPACK_IMPL(dlahr2)(N,
                        K,
                        NB,
                        A,
                        LDA,
                        TAU,
                        T,
                        LDT,
                        Y,
                        LDY);
}

//-- dlahrd --------------------------------------------------------------------
void
LAPACK_DECL(dlahrd)(const INTEGER    *N,
                    const INTEGER    *K,
                    const INTEGER    *NB,
                    DOUBLE           *A,
                    const INTEGER    *LDA,
                    DOUBLE           *TAU,
                    DOUBLE           *T,
                    const INTEGER    *LDT,
                    DOUBLE           *Y,
                    const INTEGER    *LDY)
{
    DEBUG_LAPACK_STUB("dlahrd");
    LAPACK_IMPL(dlahrd)(N,
                        K,
                        NB,
                        A,
                        LDA,
                        TAU,
                        T,
                        LDT,
                        Y,
                        LDY);
}

//-- dlaic1 --------------------------------------------------------------------
void
LAPACK_DECL(dlaic1)(const INTEGER    *JOB,
                    const INTEGER    *J,
                    const DOUBLE     *X,
                    const DOUBLE     *SEST,
                    const DOUBLE     *W,
                    const DOUBLE     *GAMMA,
                    DOUBLE           *SESTPR,
                    DOUBLE           *S,
                    DOUBLE           *C)
{
    DEBUG_LAPACK_STUB("dlaic1");
    LAPACK_IMPL(dlaic1)(JOB,
                        J,
                        X,
                        SEST,
                        W,
                        GAMMA,
                        SESTPR,
                        S,
                        C);
}

//-- dlaisnan ------------------------------------------------------------------
LOGICAL
LAPACK_DECL(dlaisnan)(const DOUBLE     *DIN1,
                      const DOUBLE     *DIN2)
{
    DEBUG_LAPACK_STUB("dlaisnan");
    return LAPACK_IMPL(dlaisnan)(DIN1,
                                 DIN2);
}

//-- dlaln2 --------------------------------------------------------------------
void
LAPACK_DECL(dlaln2)(const LOGICAL    *LTRANS,
                    const INTEGER    *NA,
                    const INTEGER    *NW,
                    const DOUBLE     *SMIN,
                    const DOUBLE     *CA,
                    const DOUBLE     *A,
                    const INTEGER    *LDA,
                    const DOUBLE     *D1,
                    const DOUBLE     *D2,
                    const DOUBLE     *B,
                    const INTEGER    *LDB,
                    const DOUBLE     *WR,
                    const DOUBLE     *WI,
                    DOUBLE           *X,
                    const INTEGER    *LDX,
                    DOUBLE           *SCALE,
                    DOUBLE           *XNORM,
                    INTEGER          *INFO)
{
    DEBUG_LAPACK_STUB("dlaln2");
    LAPACK_IMPL(dlaln2)(LTRANS,
                        NA,
                        NW,
                        SMIN,
                        CA,
                        A,
                        LDA,
                        D1,
                        D2,
                        B,
                        LDB,
                        WR,
                        WI,
                        X,
                        LDX,
                        SCALE,
                        XNORM,
                        INFO);
}

//-- dlals0 --------------------------------------------------------------------
void
LAPACK_DECL(dlals0)(const INTEGER    *ICOMPQ,
                    const INTEGER    *NL,
                    const INTEGER    *NR,
                    const INTEGER    *SQRE,
                    const INTEGER    *NRHS,
                    DOUBLE           *B,
                    const INTEGER    *LDB,
                    DOUBLE           *BX,
                    const INTEGER    *LDBX,
                    const INTEGER    *PERM,
                    const INTEGER    *GIVPTR,
                    const INTEGER    *GIVCOL,
                    const INTEGER    *LDGCOL,
                    const DOUBLE     *GIVNUM,
                    const INTEGER    *LDGNUM,
                    const DOUBLE     *POLES,
                    const DOUBLE     *DIFL,
                    const DOUBLE     *DIFR,
                    const DOUBLE     *Z,
                    const INTEGER    *K,
                    const DOUBLE     *C,
                    const DOUBLE     *S,
                    DOUBLE           *WORK,
                    INTEGER          *INFO)
{
    DEBUG_LAPACK_STUB("dlals0");
    LAPACK_IMPL(dlals0)(ICOMPQ,
                        NL,
                        NR,
                        SQRE,
                        NRHS,
                        B,
                        LDB,
                        BX,
                        LDBX,
                        PERM,
                        GIVPTR,
                        GIVCOL,
                        LDGCOL,
                        GIVNUM,
                        LDGNUM,
                        POLES,
                        DIFL,
                        DIFR,
                        Z,
                        K,
                        C,
                        S,
                        WORK,
                        INFO);
}

//-- dlalsa --------------------------------------------------------------------
void
LAPACK_DECL(dlalsa)(const INTEGER    *ICOMPQ,
                    const INTEGER    *SMLSIZ,
                    const INTEGER    *N,
                    const INTEGER    *NRHS,
                    DOUBLE           *B,
                    const INTEGER    *LDB,
                    DOUBLE           *BX,
                    const INTEGER    *LDBX,
                    const DOUBLE     *U,
                    const INTEGER    *LDU,
                    const DOUBLE     *VT,
                    const INTEGER    *K,
                    const DOUBLE     *DIFL,
                    const DOUBLE     *DIFR,
                    const DOUBLE     *Z,
                    const DOUBLE     *POLES,
                    const INTEGER    *GIVPTR,
                    const INTEGER    *GIVCOL,
                    const INTEGER    *LDGCOL,
                    const INTEGER    *PERM,
                    const DOUBLE     *GIVNUM,
                    const DOUBLE     *C,
                    const DOUBLE     *S,
                    DOUBLE           *WORK,
                    INTEGER          *IWORK,
                    INTEGER          *INFO)
{
    DEBUG_LAPACK_STUB("dlalsa");
    LAPACK_IMPL(dlalsa)(ICOMPQ,
                        SMLSIZ,
                        N,
                        NRHS,
                        B,
                        LDB,
                        BX,
                        LDBX,
                        U,
                        LDU,
                        VT,
                        K,
                        DIFL,
                        DIFR,
                        Z,
                        POLES,
                        GIVPTR,
                        GIVCOL,
                        LDGCOL,
                        PERM,
                        GIVNUM,
                        C,
                        S,
                        WORK,
                        IWORK,
                        INFO);
}

//-- dlalsd --------------------------------------------------------------------
void
LAPACK_DECL(dlalsd)(const char       *UPLO,
                    const INTEGER    *SMLSIZ,
                    const INTEGER    *N,
                    const INTEGER    *NRHS,
                    DOUBLE           *D,
                    DOUBLE           *E,
                    DOUBLE           *B,
                    const INTEGER    *LDB,
                    const DOUBLE     *RCOND,
                    INTEGER          *RANK,
                    DOUBLE           *WORK,
                    INTEGER          *IWORK,
                    INTEGER          *INFO)
{
    DEBUG_LAPACK_STUB("dlalsd");
    LAPACK_IMPL(dlalsd)(UPLO,
                        SMLSIZ,
                        N,
                        NRHS,
                        D,
                        E,
                        B,
                        LDB,
                        RCOND,
                        RANK,
                        WORK,
                        IWORK,
                        INFO);
}

//-- dlamrg --------------------------------------------------------------------
void
LAPACK_DECL(dlamrg)(const INTEGER    *N1,
                    const INTEGER    *N2,
                    const DOUBLE     *A,
                    const INTEGER    *DTRD1,
                    const INTEGER    *DTRD2,
                    INTEGER          *INDEX)
{
    DEBUG_LAPACK_STUB("dlamrg");
    LAPACK_IMPL(dlamrg)(N1,
                        N2,
                        A,
                        DTRD1,
                        DTRD2,
                        INDEX);
}

//-- dlaneg --------------------------------------------------------------------
INTEGER
LAPACK_DECL(dlaneg)(const INTEGER    *N,
                    const DOUBLE     *D,
                    const DOUBLE     *LLD,
                    const DOUBLE     *SIGMA,
                    const DOUBLE     *PIVMIN,
                    const INTEGER    *R)
{
    DEBUG_LAPACK_STUB("dlaneg");
    return LAPACK_IMPL(dlaneg)(N,
                               D,
                               LLD,
                               SIGMA,
                               PIVMIN,
                               R);
}

//-- dlangb --------------------------------------------------------------------
DOUBLE
LAPACK_DECL(dlangb)(const char       *NORM,
                    const INTEGER    *N,
                    const INTEGER    *KL,
                    const INTEGER    *KU,
                    const DOUBLE     *AB,
                    const INTEGER    *LDAB,
                    DOUBLE           *WORK)
{
    DEBUG_LAPACK_STUB("dlangb");
    return LAPACK_IMPL(dlangb)(NORM,
                               N,
                               KL,
                               KU,
                               AB,
                               LDAB,
                               WORK);
}

//-- dlange --------------------------------------------------------------------
DOUBLE
LAPACK_DECL(dlange)(const char       *NORM,
                    const INTEGER    *M,
                    const INTEGER    *N,
                    const DOUBLE     *A,
                    const INTEGER    *LDA,
                    DOUBLE           *WORK)
{
    DEBUG_LAPACK_STUB("dlange");
    return LAPACK_IMPL(dlange)(NORM,
                               M,
                               N,
                               A,
                               LDA,
                               WORK);
}

//-- dlangt --------------------------------------------------------------------
DOUBLE
LAPACK_DECL(dlangt)(const char       *NORM,
                    const INTEGER    *N,
                    const DOUBLE     *DL,
                    const DOUBLE     *D,
                    const DOUBLE     *DU)
{
    DEBUG_LAPACK_STUB("dlangt");
    return LAPACK_IMPL(dlangt)(NORM,
                               N,
                               DL,
                               D,
                               DU);
}

//-- dlanhs --------------------------------------------------------------------
DOUBLE
LAPACK_DECL(dlanhs)(const char       *NORM,
                    const INTEGER    *N,
                    const DOUBLE     *A,
                    const INTEGER    *LDA,
                    DOUBLE           *WORK)
{
    DEBUG_LAPACK_STUB("dlanhs");
    return LAPACK_IMPL(dlanhs)(NORM,
                               N,
                               A,
                               LDA,
                               WORK);
}

//-- dlansb --------------------------------------------------------------------
DOUBLE
LAPACK_DECL(dlansb)(const char       *NORM,
                    const char       *UPLO,
                    const INTEGER    *N,
                    const INTEGER    *K,
                    const DOUBLE     *AB,
                    const INTEGER    *LDAB,
                    DOUBLE           *WORK)
{
    DEBUG_LAPACK_STUB("dlansb");
    return LAPACK_IMPL(dlansb)(NORM,
                               UPLO,
                               N,
                               K,
                               AB,
                               LDAB,
                               WORK);
}

//-- dlansf --------------------------------------------------------------------
DOUBLE
LAPACK_DECL(dlansf)(const char       *NORM,
                    const char       *TRANSR,
                    const char       *UPLO,
                    const INTEGER    *N,
                    const DOUBLE     *A,
                    DOUBLE           *WORK)
{
    DEBUG_LAPACK_STUB("dlansf");
    return LAPACK_IMPL(dlansf)(NORM,
                               TRANSR,
                               UPLO,
                               N,
                               A,
                               WORK);
}

//-- dlansp --------------------------------------------------------------------
DOUBLE
LAPACK_DECL(dlansp)(const char       *NORM,
                    const char       *UPLO,
                    const INTEGER    *N,
                    const DOUBLE     *AP,
                    DOUBLE           *WORK)
{
    DEBUG_LAPACK_STUB("dlansp");
    return LAPACK_IMPL(dlansp)(NORM,
                               UPLO,
                               N,
                               AP,
                               WORK);
}

//-- dlanst --------------------------------------------------------------------
DOUBLE
LAPACK_DECL(dlanst)(const char       *NORM,
                    const INTEGER    *N,
                    const DOUBLE     *D,
                    const DOUBLE     *E)
{
    DEBUG_LAPACK_STUB("dlanst");
    return LAPACK_IMPL(dlanst)(NORM,
                               N,
                               D,
                               E);
}

//-- dlansy --------------------------------------------------------------------
DOUBLE
LAPACK_DECL(dlansy)(const char       *NORM,
                    const char       *UPLO,
                    const INTEGER    *N,
                    const DOUBLE     *A,
                    const INTEGER    *LDA,
                    DOUBLE           *WORK)
{
    DEBUG_LAPACK_STUB("dlansy");
    return LAPACK_IMPL(dlansy)(NORM,
                               UPLO,
                               N,
                               A,
                               LDA,
                               WORK);
}

//-- dlantb --------------------------------------------------------------------
DOUBLE
LAPACK_DECL(dlantb)(const char       *NORM,
                    const char       *UPLO,
                    const char       *DIAG,
                    const INTEGER    *N,
                    const INTEGER    *K,
                    const DOUBLE     *AB,
                    const INTEGER    *LDAB,
                    DOUBLE           *WORK)
{
    DEBUG_LAPACK_STUB("dlantb");
    return LAPACK_IMPL(dlantb)(NORM,
                               UPLO,
                               DIAG,
                               N,
                               K,
                               AB,
                               LDAB,
                               WORK);
}

//-- dlantp --------------------------------------------------------------------
DOUBLE
LAPACK_DECL(dlantp)(const char       *NORM,
                    const char       *UPLO,
                    const char       *DIAG,
                    const INTEGER    *N,
                    const DOUBLE     *AP,
                    DOUBLE           *WORK)
{
    DEBUG_LAPACK_STUB("dlantp");
    return LAPACK_IMPL(dlantp)(NORM,
                               UPLO,
                               DIAG,
                               N,
                               AP,
                               WORK);
}

//-- dlantr --------------------------------------------------------------------
DOUBLE
LAPACK_DECL(dlantr)(const char       *NORM,
                    const char       *UPLO,
                    const char       *DIAG,
                    const INTEGER    *M,
                    const INTEGER    *N,
                    const DOUBLE     *A,
                    const INTEGER    *LDA,
                    DOUBLE           *WORK)
{
    DEBUG_LAPACK_STUB("dlantr");
    return LAPACK_IMPL(dlantr)(NORM,
                               UPLO,
                               DIAG,
                               M,
                               N,
                               A,
                               LDA,
                               WORK);
}

//-- dlanv2 --------------------------------------------------------------------
void
LAPACK_DECL(dlanv2)(DOUBLE   *A,
                    DOUBLE   *B,
                    DOUBLE   *C,
                    DOUBLE   *D,
                    DOUBLE   *RT1R,
                    DOUBLE   *RT1I,
                    DOUBLE   *RT2R,
                    DOUBLE   *RT2I,
                    DOUBLE   *CS,
                    DOUBLE   *SN)
{
    DEBUG_LAPACK_STUB("dlanv2");
    LAPACK_IMPL(dlanv2)(A,
                        B,
                        C,
                        D,
                        RT1R,
                        RT1I,
                        RT2R,
                        RT2I,
                        CS,
                        SN);
}

//-- dlapll --------------------------------------------------------------------
void
LAPACK_DECL(dlapll)(const INTEGER    *N,
                    DOUBLE           *X,
                    const INTEGER    *INCX,
                    DOUBLE           *Y,
                    const INTEGER    *INCY,
                    DOUBLE           *SSMIN)
{
    DEBUG_LAPACK_STUB("dlapll");
    LAPACK_IMPL(dlapll)(N,
                        X,
                        INCX,
                        Y,
                        INCY,
                        SSMIN);
}

//-- dlapmr --------------------------------------------------------------------
void
LAPACK_DECL(dlapmr)(const LOGICAL    *FORWRD,
                    const INTEGER    *M,
                    const INTEGER    *N,
                    DOUBLE           *X,
                    const INTEGER    *LDX,
                    INTEGER          *K)
{
    DEBUG_LAPACK_STUB("dlapmr");
    LAPACK_IMPL(dlapmr)(FORWRD,
                        M,
                        N,
                        X,
                        LDX,
                        K);
}

//-- dlapmt --------------------------------------------------------------------
void
LAPACK_DECL(dlapmt)(const LOGICAL    *FORWRD,
                    const INTEGER    *M,
                    const INTEGER    *N,
                    DOUBLE           *X,
                    const INTEGER    *LDX,
                    INTEGER          *K)
{
    DEBUG_LAPACK_STUB("dlapmt");
    LAPACK_IMPL(dlapmt)(FORWRD,
                        M,
                        N,
                        X,
                        LDX,
                        K);
}

//-- dlapy2 --------------------------------------------------------------------
DOUBLE
LAPACK_DECL(dlapy2)(const DOUBLE     *X,
                    const DOUBLE     *Y)
{
    DEBUG_LAPACK_STUB("dlapy2");
    return LAPACK_IMPL(dlapy2)(X,
                               Y);
}

//-- dlapy3 --------------------------------------------------------------------
DOUBLE
LAPACK_DECL(dlapy3)(const DOUBLE     *X,
                    const DOUBLE     *Y,
                    const DOUBLE     *Z)
{
    DEBUG_LAPACK_STUB("dlapy3");
    return LAPACK_IMPL(dlapy3)(X,
                               Y,
                               Z);
}

//-- dlaqgb --------------------------------------------------------------------
void
LAPACK_DECL(dlaqgb)(const INTEGER    *M,
                    const INTEGER    *N,
                    const INTEGER    *KL,
                    const INTEGER    *KU,
                    DOUBLE           *AB,
                    const INTEGER    *LDAB,
                    const DOUBLE     *R,
                    const DOUBLE     *C,
                    const DOUBLE     *ROWCND,
                    const DOUBLE     *COLCND,
                    const DOUBLE     *AMAX,
                    char             *EQUED)
{
    DEBUG_LAPACK_STUB("dlaqgb");
    LAPACK_IMPL(dlaqgb)(M,
                        N,
                        KL,
                        KU,
                        AB,
                        LDAB,
                        R,
                        C,
                        ROWCND,
                        COLCND,
                        AMAX,
                        EQUED);
}

//-- dlaqge --------------------------------------------------------------------
void
LAPACK_DECL(dlaqge)(const INTEGER    *M,
                    const INTEGER    *N,
                    DOUBLE           *A,
                    const INTEGER    *LDA,
                    const DOUBLE     *R,
                    const DOUBLE     *C,
                    const DOUBLE     *ROWCND,
                    const DOUBLE     *COLCND,
                    const DOUBLE     *AMAX,
                    char             *EQUED)
{
    DEBUG_LAPACK_STUB("dlaqge");
    LAPACK_IMPL(dlaqge)(M,
                        N,
                        A,
                        LDA,
                        R,
                        C,
                        ROWCND,
                        COLCND,
                        AMAX,
                        EQUED);
}

//-- dlaqp2 --------------------------------------------------------------------
void
LAPACK_DECL(dlaqp2)(const INTEGER    *M,
                    const INTEGER    *N,
                    const INTEGER    *OFFSET,
                    DOUBLE           *A,
                    const INTEGER    *LDA,
                    INTEGER          *JPVT,
                    DOUBLE           *TAU,
                    DOUBLE           *VN1,
                    DOUBLE           *VN2,
                    DOUBLE           *WORK)
{
    DEBUG_LAPACK_STUB("dlaqp2");
    LAPACK_IMPL(dlaqp2)(M,
                        N,
                        OFFSET,
                        A,
                        LDA,
                        JPVT,
                        TAU,
                        VN1,
                        VN2,
                        WORK);
}

//-- dlaqps --------------------------------------------------------------------
void
LAPACK_DECL(dlaqps)(const INTEGER    *M,
                    const INTEGER    *N,
                    const INTEGER    *OFFSET,
                    const INTEGER    *NB,
                    INTEGER          *KB,
                    DOUBLE           *A,
                    const INTEGER    *LDA,
                    INTEGER          *JPVT,
                    DOUBLE           *TAU,
                    DOUBLE           *VN1,
                    DOUBLE           *VN2,
                    DOUBLE           *AUXV,
                    DOUBLE           *F,
                    const INTEGER    *LDF)
{
    DEBUG_LAPACK_STUB("dlaqps");
    LAPACK_IMPL(dlaqps)(M,
                        N,
                        OFFSET,
                        NB,
                        KB,
                        A,
                        LDA,
                        JPVT,
                        TAU,
                        VN1,
                        VN2,
                        AUXV,
                        F,
                        LDF);
}

//-- dlaqr0 --------------------------------------------------------------------
void
LAPACK_DECL(dlaqr0)(const LOGICAL    *WANTT,
                    const LOGICAL    *WANTZ,
                    const INTEGER    *N,
                    const INTEGER    *ILO,
                    const INTEGER    *IHI,
                    DOUBLE           *H,
                    const INTEGER    *LDH,
                    DOUBLE           *WR,
                    DOUBLE           *WI,
                    const INTEGER    *ILOZ,
                    const INTEGER    *IHIZ,
                    DOUBLE           *Z,
                    const INTEGER    *LDZ,
                    DOUBLE           *WORK,
                    const INTEGER    *LWORK,
                    INTEGER          *INFO)
{
    DEBUG_LAPACK_STUB("dlaqr0");
    LAPACK_IMPL(dlaqr0)(WANTT,
                        WANTZ,
                        N,
                        ILO,
                        IHI,
                        H,
                        LDH,
                        WR,
                        WI,
                        ILOZ,
                        IHIZ,
                        Z,
                        LDZ,
                        WORK,
                        LWORK,
                        INFO);
}

//-- dlaqr1 --------------------------------------------------------------------
void
LAPACK_DECL(dlaqr1)(const INTEGER    *N,
                    const DOUBLE     *H,
                    const INTEGER    *LDH,
                    const DOUBLE     *SR1,
                    const DOUBLE     *SI1,
                    const DOUBLE     *SR2,
                    const DOUBLE     *SI2,
                    DOUBLE           *V)
{
    DEBUG_LAPACK_STUB("dlaqr1");
    LAPACK_IMPL(dlaqr1)(N,
                        H,
                        LDH,
                        SR1,
                        SI1,
                        SR2,
                        SI2,
                        V);
}

//-- dlaqr2 --------------------------------------------------------------------
void
LAPACK_DECL(dlaqr2)(const LOGICAL    *WANTT,
                    const LOGICAL    *WANTZ,
                    const INTEGER    *N,
                    const INTEGER    *KTOP,
                    const INTEGER    *KBOT,
                    const INTEGER    *NW,
                    DOUBLE           *H,
                    const INTEGER    *LDH,
                    const INTEGER    *ILOZ,
                    const INTEGER    *IHIZ,
                    DOUBLE           *Z,
                    const INTEGER    *LDZ,
                    INTEGER          *NS,
                    INTEGER          *ND,
                    DOUBLE           *SR,
                    DOUBLE           *SI,
                    DOUBLE           *V,
                    const INTEGER    *LDV,
                    const INTEGER    *NH,
                    DOUBLE           *T,
                    const INTEGER    *LDT,
                    const INTEGER    *NV,
                    DOUBLE           *WV,
                    const INTEGER    *LDWV,
                    DOUBLE           *WORK,
                    const INTEGER    *LWORK)
{
    DEBUG_LAPACK_STUB("dlaqr2");
    LAPACK_IMPL(dlaqr2)(WANTT,
                        WANTZ,
                        N,
                        KTOP,
                        KBOT,
                        NW,
                        H,
                        LDH,
                        ILOZ,
                        IHIZ,
                        Z,
                        LDZ,
                        NS,
                        ND,
                        SR,
                        SI,
                        V,
                        LDV,
                        NH,
                        T,
                        LDT,
                        NV,
                        WV,
                        LDWV,
                        WORK,
                        LWORK);
}

//-- dlaqr3 --------------------------------------------------------------------
void
LAPACK_DECL(dlaqr3)(const LOGICAL    *WANTT,
                    const LOGICAL    *WANTZ,
                    const INTEGER    *N,
                    const INTEGER    *KTOP,
                    const INTEGER    *KBOT,
                    const INTEGER    *NW,
                    DOUBLE           *H,
                    const INTEGER    *LDH,
                    const INTEGER    *ILOZ,
                    const INTEGER    *IHIZ,
                    DOUBLE           *Z,
                    const INTEGER    *LDZ,
                    INTEGER          *NS,
                    INTEGER          *ND,
                    DOUBLE           *SR,
                    DOUBLE           *SI,
                    DOUBLE           *V,
                    const INTEGER    *LDV,
                    const INTEGER    *NH,
                    DOUBLE           *T,
                    const INTEGER    *LDT,
                    const INTEGER    *NV,
                    DOUBLE           *WV,
                    const INTEGER    *LDWV,
                    DOUBLE           *WORK,
                    const INTEGER    *LWORK)
{
    DEBUG_LAPACK_STUB("dlaqr3");
    LAPACK_IMPL(dlaqr3)(WANTT,
                        WANTZ,
                        N,
                        KTOP,
                        KBOT,
                        NW,
                        H,
                        LDH,
                        ILOZ,
                        IHIZ,
                        Z,
                        LDZ,
                        NS,
                        ND,
                        SR,
                        SI,
                        V,
                        LDV,
                        NH,
                        T,
                        LDT,
                        NV,
                        WV,
                        LDWV,
                        WORK,
                        LWORK);
}

//-- dlaqr4 --------------------------------------------------------------------
void
LAPACK_DECL(dlaqr4)(const LOGICAL    *WANTT,
                    const LOGICAL    *WANTZ,
                    const INTEGER    *N,
                    const INTEGER    *ILO,
                    const INTEGER    *IHI,
                    DOUBLE           *H,
                    const INTEGER    *LDH,
                    DOUBLE           *WR,
                    DOUBLE           *WI,
                    const INTEGER    *ILOZ,
                    const INTEGER    *IHIZ,
                    DOUBLE           *Z,
                    const INTEGER    *LDZ,
                    DOUBLE           *WORK,
                    const INTEGER    *LWORK,
                    INTEGER          *INFO)
{
    DEBUG_LAPACK_STUB("dlaqr4");
    LAPACK_IMPL(dlaqr4)(WANTT,
                        WANTZ,
                        N,
                        ILO,
                        IHI,
                        H,
                        LDH,
                        WR,
                        WI,
                        ILOZ,
                        IHIZ,
                        Z,
                        LDZ,
                        WORK,
                        LWORK,
                        INFO);
}

//-- dlaqr5 --------------------------------------------------------------------
void
LAPACK_DECL(dlaqr5)(const LOGICAL    *WANTT,
                    const LOGICAL    *WANTZ,
                    const INTEGER    *KACC22,
                    const INTEGER    *N,
                    const INTEGER    *KTOP,
                    const INTEGER    *KBOT,
                    const INTEGER    *NSHFTS,
                    DOUBLE           *SR,
                    DOUBLE           *SI,
                    DOUBLE           *H,
                    const INTEGER    *LDH,
                    const INTEGER    *ILOZ,
                    const INTEGER    *IHIZ,
                    DOUBLE           *Z,
                    const INTEGER    *LDZ,
                    DOUBLE           *V,
                    const INTEGER    *LDV,
                    DOUBLE           *U,
                    const INTEGER    *LDU,
                    const INTEGER    *NV,
                    DOUBLE           *WV,
                    const INTEGER    *LDWV,
                    const INTEGER    *NH,
                    DOUBLE           *WH,
                    const INTEGER    *LDWH)
{
    DEBUG_LAPACK_STUB("dlaqr5");
    LAPACK_IMPL(dlaqr5)(WANTT,
                        WANTZ,
                        KACC22,
                        N,
                        KTOP,
                        KBOT,
                        NSHFTS,
                        SR,
                        SI,
                        H,
                        LDH,
                        ILOZ,
                        IHIZ,
                        Z,
                        LDZ,
                        V,
                        LDV,
                        U,
                        LDU,
                        NV,
                        WV,
                        LDWV,
                        NH,
                        WH,
                        LDWH);
}

//-- dlaqsb --------------------------------------------------------------------
void
LAPACK_DECL(dlaqsb)(const char       *UPLO,
                    const INTEGER    *N,
                    const INTEGER    *KD,
                    DOUBLE           *AB,
                    const INTEGER    *LDAB,
                    const DOUBLE     *S,
                    const DOUBLE     *SCOND,
                    const DOUBLE     *AMAX,
                    char             *EQUED)
{
    DEBUG_LAPACK_STUB("dlaqsb");
    LAPACK_IMPL(dlaqsb)(UPLO,
                        N,
                        KD,
                        AB,
                        LDAB,
                        S,
                        SCOND,
                        AMAX,
                        EQUED);
}

//-- dlaqsp --------------------------------------------------------------------
void
LAPACK_DECL(dlaqsp)(const char       *UPLO,
                    const INTEGER    *N,
                    DOUBLE           *AP,
                    const DOUBLE     *S,
                    const DOUBLE     *SCOND,
                    const DOUBLE     *AMAX,
                    char             *EQUED)
{
    DEBUG_LAPACK_STUB("dlaqsp");
    LAPACK_IMPL(dlaqsp)(UPLO,
                        N,
                        AP,
                        S,
                        SCOND,
                        AMAX,
                        EQUED);
}

//-- dlaqsy --------------------------------------------------------------------
void
LAPACK_DECL(dlaqsy)(const char       *UPLO,
                    const INTEGER    *N,
                    DOUBLE           *A,
                    const INTEGER    *LDA,
                    const DOUBLE     *S,
                    const DOUBLE     *SCOND,
                    const DOUBLE     *AMAX,
                    char             *EQUED)
{
    DEBUG_LAPACK_STUB("dlaqsy");
    LAPACK_IMPL(dlaqsy)(UPLO,
                        N,
                        A,
                        LDA,
                        S,
                        SCOND,
                        AMAX,
                        EQUED);
}

//-- dlaqtr --------------------------------------------------------------------
void
LAPACK_DECL(dlaqtr)(const LOGICAL    *LTRAN,
                    const LOGICAL    *LREAL,
                    const INTEGER    *N,
                    const DOUBLE     *T,
                    const INTEGER    *LDT,
                    const DOUBLE     *B,
                    const DOUBLE     *W,
                    DOUBLE           *SCALE,
                    DOUBLE           *X,
                    DOUBLE           *WORK,
                    INTEGER          *INFO)
{
    DEBUG_LAPACK_STUB("dlaqtr");
    LAPACK_IMPL(dlaqtr)(LTRAN,
                        LREAL,
                        N,
                        T,
                        LDT,
                        B,
                        W,
                        SCALE,
                        X,
                        WORK,
                        INFO);
}

//-- dlar1v --------------------------------------------------------------------
void
LAPACK_DECL(dlar1v)(const INTEGER    *N,
                    const INTEGER    *B1,
                    const INTEGER    *BN,
                    const DOUBLE     *LAMBDA,
                    const DOUBLE     *D,
                    const DOUBLE     *L,
                    const DOUBLE     *LD,
                    const DOUBLE     *LLD,
                    const DOUBLE     *PIVMIN,
                    const DOUBLE     *GAPTOL,
                    DOUBLE           *Z,
                    const LOGICAL    *WANTNC,
                    INTEGER          *NEGCNT,
                    DOUBLE           *ZTZ,
                    DOUBLE           *MINGMA,
                    INTEGER          *R,
                    INTEGER          *ISUPPZ,
                    DOUBLE           *NRMINV,
                    DOUBLE           *RESID,
                    DOUBLE           *RQCORR,
                    DOUBLE           *WORK)
{
    DEBUG_LAPACK_STUB("dlar1v");
    LAPACK_IMPL(dlar1v)(N,
                        B1,
                        BN,
                        LAMBDA,
                        D,
                        L,
                        LD,
                        LLD,
                        PIVMIN,
                        GAPTOL,
                        Z,
                        WANTNC,
                        NEGCNT,
                        ZTZ,
                        MINGMA,
                        R,
                        ISUPPZ,
                        NRMINV,
                        RESID,
                        RQCORR,
                        WORK);
}

//-- dlar2v --------------------------------------------------------------------
void
LAPACK_DECL(dlar2v)(const INTEGER    *N,
                    DOUBLE           *X,
                    DOUBLE           *Y,
                    DOUBLE           *Z,
                    const INTEGER    *INCX,
                    const DOUBLE     *C,
                    const DOUBLE     *S,
                    const INTEGER    *INCC)
{
    DEBUG_LAPACK_STUB("dlar2v");
    LAPACK_IMPL(dlar2v)(N,
                        X,
                        Y,
                        Z,
                        INCX,
                        C,
                        S,
                        INCC);
}

//-- dlarf ---------------------------------------------------------------------
void
LAPACK_DECL(dlarf)(const char           *SIDE,
                   const INTEGER        *M,
                   const INTEGER        *N,
                   const DOUBLE         *V,
                   const INTEGER        *INCV,
                   const DOUBLE         *TAU,
                   DOUBLE               *C,
                   const INTEGER        *LDC,
                   DOUBLE               *WORK)
{
    DEBUG_LAPACK_STUB("dlarf");
    LAPACK_IMPL(dlarf)(SIDE,
                       M,
                       N,
                       V,
                       INCV,
                       TAU,
                       C,
                       LDC,
                       WORK);
}

//-- dlarfb --------------------------------------------------------------------
void
LAPACK_DECL(dlarfb)(const char       *SIDE,
                    const char       *TRANS,
                    const char       *DIRECT,
                    const char       *STOREV,
                    const INTEGER    *M,
                    const INTEGER    *N,
                    const INTEGER    *K,
                    const DOUBLE     *V,
                    const INTEGER    *LDV,
                    const DOUBLE     *T,
                    const INTEGER    *LDT,
                    DOUBLE           *C,
                    const INTEGER    *LDC,
                    DOUBLE           *WORK,
                    const INTEGER    *LDWORK)
{
    DEBUG_LAPACK_STUB("dlarfb");
    LAPACK_IMPL(dlarfb)(SIDE,
                        TRANS,
                        DIRECT,
                        STOREV,
                        M,
                        N,
                        K,
                        V,
                        LDV,
                        T,
                        LDT,
                        C,
                        LDC,
                        WORK,
                        LDWORK);
}

//-- dlarfg --------------------------------------------------------------------
void
LAPACK_DECL(dlarfg)(const INTEGER    *N,
                    DOUBLE           *ALPHA,
                    DOUBLE           *X,
                    const INTEGER    *INCX,
                    DOUBLE           *TAU)
{
    DEBUG_LAPACK_STUB("dlarfg");
    LAPACK_IMPL(dlarfg)(N,
                        ALPHA,
                        X,
                        INCX,
                        TAU);
}

//-- dlarfgp -------------------------------------------------------------------
void
LAPACK_DECL(dlarfgp)(const INTEGER    *N,
                     DOUBLE           *ALPHA,
                     DOUBLE           *X,
                     const INTEGER    *INCX,
                     DOUBLE           *TAU)
{
    DEBUG_LAPACK_STUB("dlarfgp");
    LAPACK_IMPL(dlarfgp)(N,
                         ALPHA,
                         X,
                         INCX,
                         TAU);
}

//-- dlarft --------------------------------------------------------------------
void
LAPACK_DECL(dlarft)(const char       *DIRECT,
                    const char       *STOREV,
                    const INTEGER    *N,
                    const INTEGER    *K,
                    DOUBLE           *V,
                    const INTEGER    *LDV,
                    const DOUBLE     *TAU,
                    DOUBLE           *T,
                    const INTEGER    *LDT)
{
    DEBUG_LAPACK_STUB("dlarft");
    LAPACK_IMPL(dlarft)(DIRECT,
                        STOREV,
                        N,
                        K,
                        V,
                        LDV,
                        TAU,
                        T,
                        LDT);
}

//-- dlarfx --------------------------------------------------------------------
void
LAPACK_DECL(dlarfx)(const char       *SIDE,
                    const INTEGER    *M,
                    const INTEGER    *N,
                    const DOUBLE     *V,
                    const DOUBLE     *TAU,
                    DOUBLE           *C,
                    const INTEGER    *LDC,
                    DOUBLE           *WORK)
{
    DEBUG_LAPACK_STUB("dlarfx");
    LAPACK_IMPL(dlarfx)(SIDE,
                        M,
                        N,
                        V,
                        TAU,
                        C,
                        LDC,
                        WORK);
}

//-- dlargv --------------------------------------------------------------------
void
LAPACK_DECL(dlargv)(const INTEGER    *N,
                    DOUBLE           *X,
                    const INTEGER    *INCX,
                    DOUBLE           *Y,
                    const INTEGER    *INCY,
                    DOUBLE           *C,
                    const INTEGER    *INCC)
{
    DEBUG_LAPACK_STUB("dlargv");
    LAPACK_IMPL(dlargv)(N,
                        X,
                        INCX,
                        Y,
                        INCY,
                        C,
                        INCC);
}

//-- dlarnv --------------------------------------------------------------------
void
LAPACK_DECL(dlarnv)(const INTEGER    *IDIST,
                    INTEGER          *ISEED,
                    const INTEGER    *N,
                    DOUBLE           *X)
{
    DEBUG_LAPACK_STUB("dlarnv");
    LAPACK_IMPL(dlarnv)(IDIST,
                        ISEED,
                        N,
                        X);
}

//-- dlarra --------------------------------------------------------------------
void
LAPACK_DECL(dlarra)(const INTEGER    *N,
                    const DOUBLE     *D,
                    DOUBLE           *E,
                    DOUBLE           *E2,
                    const DOUBLE     *SPLTOL,
                    const DOUBLE     *TNRM,
                    INTEGER          *NSPLIT,
                    INTEGER          *ISPLIT,
                    INTEGER          *INFO)
{
    DEBUG_LAPACK_STUB("dlarra");
    LAPACK_IMPL(dlarra)(N,
                        D,
                        E,
                        E2,
                        SPLTOL,
                        TNRM,
                        NSPLIT,
                        ISPLIT,
                        INFO);
}

//-- dlarrb --------------------------------------------------------------------
void
LAPACK_DECL(dlarrb)(const INTEGER    *N,
                    const DOUBLE     *D,
                    const DOUBLE     *LLD,
                    const INTEGER    *IFIRST,
                    const INTEGER    *ILAST,
                    const DOUBLE     *RTOL1,
                    const DOUBLE     *RTOL2,
                    const INTEGER    *OFFSET,
                    DOUBLE           *W,
                    DOUBLE           *WGAP,
                    DOUBLE           *WERR,
                    DOUBLE           *WORK,
                    INTEGER          *IWORK,
                    const DOUBLE     *PIVMIN,
                    const DOUBLE     *SPDIAM,
                    const INTEGER    *TWIST,
                    INTEGER          *INFO)
{
    DEBUG_LAPACK_STUB("dlarrb");
    LAPACK_IMPL(dlarrb)(N,
                        D,
                        LLD,
                        IFIRST,
                        ILAST,
                        RTOL1,
                        RTOL2,
                        OFFSET,
                        W,
                        WGAP,
                        WERR,
                        WORK,
                        IWORK,
                        PIVMIN,
                        SPDIAM,
                        TWIST,
                        INFO);
}

//-- dlarrc --------------------------------------------------------------------
void
LAPACK_DECL(dlarrc)(const char       *JOBT,
                    const INTEGER    *N,
                    const DOUBLE     *VL,
                    const DOUBLE     *VU,
                    const DOUBLE     *D,
                    const DOUBLE     *E,
                    const DOUBLE     *PIVMIN,
                    INTEGER          *EIGCNT,
                    INTEGER          *LCNT,
                    INTEGER          *RCNT,
                    INTEGER          *INFO)
{
    DEBUG_LAPACK_STUB("dlarrc");
    LAPACK_IMPL(dlarrc)(JOBT,
                        N,
                        VL,
                        VU,
                        D,
                        E,
                        PIVMIN,
                        EIGCNT,
                        LCNT,
                        RCNT,
                        INFO);
}

//-- dlarrd --------------------------------------------------------------------
void
LAPACK_DECL(dlarrd)(const char       *RANGE,
                    const char       *ORDER,
                    const INTEGER    *N,
                    const DOUBLE     *VL,
                    const DOUBLE     *VU,
                    const INTEGER    *IL,
                    const INTEGER    *IU,
                    const DOUBLE     *GERS,
                    const DOUBLE     *RELTOL,
                    const DOUBLE     *D,
                    const DOUBLE     *E,
                    const DOUBLE     *E2,
                    const DOUBLE     *PIVMIN,
                    const INTEGER    *NSPLIT,
                    const INTEGER    *ISPLIT,
                    INTEGER          *M,
                    DOUBLE           *W,
                    DOUBLE           *WERR,
                    DOUBLE           *WL,
                    DOUBLE           *WU,
                    INTEGER          *IBLOCK,
                    INTEGER          *INDEXW,
                    DOUBLE           *WORK,
                    INTEGER          *IWORK,
                    INTEGER          *INFO)
{
    DEBUG_LAPACK_STUB("dlarrd");
    LAPACK_IMPL(dlarrd)(RANGE,
                        ORDER,
                        N,
                        VL,
                        VU,
                        IL,
                        IU,
                        GERS,
                        RELTOL,
                        D,
                        E,
                        E2,
                        PIVMIN,
                        NSPLIT,
                        ISPLIT,
                        M,
                        W,
                        WERR,
                        WL,
                        WU,
                        IBLOCK,
                        INDEXW,
                        WORK,
                        IWORK,
                        INFO);
}

//-- dlarre --------------------------------------------------------------------
void
LAPACK_DECL(dlarre)(const char       *RANGE,
                    const INTEGER    *N,
                    DOUBLE           *VL,
                    DOUBLE           *VU,
                    const INTEGER    *IL,
                    const INTEGER    *IU,
                    DOUBLE           *D,
                    DOUBLE           *E,
                    DOUBLE           *E2,
                    const DOUBLE     *RTOL1,
                    const DOUBLE     *RTOL2,
                    const DOUBLE     *SPLTOL,
                    INTEGER          *NSPLIT,
                    INTEGER          *ISPLIT,
                    INTEGER          *M,
                    DOUBLE           *W,
                    DOUBLE           *WERR,
                    DOUBLE           *WGAP,
                    INTEGER          *IBLOCK,
                    INTEGER          *INDEXW,
                    DOUBLE           *GERS,
                    DOUBLE           *PIVMIN,
                    DOUBLE           *WORK,
                    INTEGER          *IWORK,
                    INTEGER          *INFO)
{
    DEBUG_LAPACK_STUB("dlarre");
    LAPACK_IMPL(dlarre)(RANGE,
                        N,
                        VL,
                        VU,
                        IL,
                        IU,
                        D,
                        E,
                        E2,
                        RTOL1,
                        RTOL2,
                        SPLTOL,
                        NSPLIT,
                        ISPLIT,
                        M,
                        W,
                        WERR,
                        WGAP,
                        IBLOCK,
                        INDEXW,
                        GERS,
                        PIVMIN,
                        WORK,
                        IWORK,
                        INFO);
}

//-- dlarrf --------------------------------------------------------------------
void
LAPACK_DECL(dlarrf)(const INTEGER    *N,
                    const DOUBLE     *D,
                    const DOUBLE     *L,
                    const DOUBLE     *LD,
                    const INTEGER    *CLSTRT,
                    const INTEGER    *CLEND,
                    const DOUBLE     *W,
                    DOUBLE           *WGAP,
                    const DOUBLE     *WERR,
                    const DOUBLE     *SPDIAM,
                    const DOUBLE     *CLGAPL,
                    const DOUBLE     *CLGAPR,
                    const DOUBLE     *PIVMIN,
                    DOUBLE           *SIGMA,
                    DOUBLE           *DPLUS,
                    DOUBLE           *LPLUS,
                    DOUBLE           *WORK,
                    INTEGER          *INFO)
{
    DEBUG_LAPACK_STUB("dlarrf");
    LAPACK_IMPL(dlarrf)(N,
                        D,
                        L,
                        LD,
                        CLSTRT,
                        CLEND,
                        W,
                        WGAP,
                        WERR,
                        SPDIAM,
                        CLGAPL,
                        CLGAPR,
                        PIVMIN,
                        SIGMA,
                        DPLUS,
                        LPLUS,
                        WORK,
                        INFO);
}

//-- dlarrj --------------------------------------------------------------------
void
LAPACK_DECL(dlarrj)(const INTEGER    *N,
                    const DOUBLE     *D,
                    const DOUBLE     *E2,
                    const INTEGER    *IFIRST,
                    const INTEGER    *ILAST,
                    const DOUBLE     *RTOL,
                    const INTEGER    *OFFSET,
                    DOUBLE           *W,
                    DOUBLE           *WERR,
                    DOUBLE           *WORK,
                    INTEGER          *IWORK,
                    const DOUBLE     *PIVMIN,
                    const DOUBLE     *SPDIAM,
                    INTEGER          *INFO)
{
    DEBUG_LAPACK_STUB("dlarrj");
    LAPACK_IMPL(dlarrj)(N,
                        D,
                        E2,
                        IFIRST,
                        ILAST,
                        RTOL,
                        OFFSET,
                        W,
                        WERR,
                        WORK,
                        IWORK,
                        PIVMIN,
                        SPDIAM,
                        INFO);
}

//-- dlarrk --------------------------------------------------------------------
void
LAPACK_DECL(dlarrk)(const INTEGER    *N,
                    const INTEGER    *IW,
                    const DOUBLE     *GL,
                    const DOUBLE     *GU,
                    const DOUBLE     *D,
                    const DOUBLE     *E2,
                    const DOUBLE     *PIVMIN,
                    const DOUBLE     *RELTOL,
                    DOUBLE           *W,
                    DOUBLE           *WERR,
                    INTEGER          *INFO)
{
    DEBUG_LAPACK_STUB("dlarrk");
    LAPACK_IMPL(dlarrk)(N,
                        IW,
                        GL,
                        GU,
                        D,
                        E2,
                        PIVMIN,
                        RELTOL,
                        W,
                        WERR,
                        INFO);
}

//-- dlarrr --------------------------------------------------------------------
void
LAPACK_DECL(dlarrr)(const INTEGER    *N,
                    const DOUBLE     *D,
                    DOUBLE           *E,
                    INTEGER          *INFO)
{
    DEBUG_LAPACK_STUB("dlarrr");
    LAPACK_IMPL(dlarrr)(N,
                        D,
                        E,
                        INFO);
}

//-- dlarrv --------------------------------------------------------------------
void
LAPACK_DECL(dlarrv)(const INTEGER    *N,
                    const DOUBLE     *VL,
                    const DOUBLE     *VU,
                    DOUBLE           *D,
                    DOUBLE           *L,
                    const DOUBLE     *PIVMIN,
                    const INTEGER    *ISPLIT,
                    const INTEGER    *M,
                    const INTEGER    *DOL,
                    const INTEGER    *DOU,
                    const DOUBLE     *MINRGP,
                    const DOUBLE     *RTOL1,
                    const DOUBLE     *RTOL2,
                    DOUBLE           *W,
                    DOUBLE           *WERR,
                    DOUBLE           *WGAP,
                    const INTEGER    *IBLOCK,
                    const INTEGER    *INDEXW,
                    const DOUBLE     *GERS,
                    DOUBLE           *Z,
                    const INTEGER    *LDZ,
                    INTEGER          *ISUPPZ,
                    DOUBLE           *WORK,
                    INTEGER          *IWORK,
                    INTEGER          *INFO)
{
    DEBUG_LAPACK_STUB("dlarrv");
    LAPACK_IMPL(dlarrv)(N,
                        VL,
                        VU,
                        D,
                        L,
                        PIVMIN,
                        ISPLIT,
                        M,
                        DOL,
                        DOU,
                        MINRGP,
                        RTOL1,
                        RTOL2,
                        W,
                        WERR,
                        WGAP,
                        IBLOCK,
                        INDEXW,
                        GERS,
                        Z,
                        LDZ,
                        ISUPPZ,
                        WORK,
                        IWORK,
                        INFO);
}

//-- dlarscl2 ------------------------------------------------------------------
void
LAPACK_DECL(dlarscl2)(const INTEGER    *M,
                      const INTEGER    *N,
                      const DOUBLE     *D,
                      DOUBLE           *X,
                      const INTEGER    *LDX)
{
    DEBUG_LAPACK_STUB("dlarscl2");
    LAPACK_IMPL(dlarscl2)(M,
                          N,
                          D,
                          X,
                          LDX);
}

//-- dlartg --------------------------------------------------------------------
void
LAPACK_DECL(dlartg)(const DOUBLE     *F,
                    const DOUBLE     *G,
                    DOUBLE           *CS,
                    DOUBLE           *SN,
                    DOUBLE           *R)
{
    DEBUG_LAPACK_STUB("dlartg");
    LAPACK_IMPL(dlartg)(F,
                        G,
                        CS,
                        SN,
                        R);
}

//-- dlartgp -------------------------------------------------------------------
void
LAPACK_DECL(dlartgp)(const DOUBLE     *F,
                     const DOUBLE     *G,
                     DOUBLE           *CS,
                     DOUBLE           *SN,
                     DOUBLE           *R)
{
    DEBUG_LAPACK_STUB("dlartgp");
    LAPACK_IMPL(dlartgp)(F,
                         G,
                         CS,
                         SN,
                         R);
}

//-- dlartgs -------------------------------------------------------------------
void
LAPACK_DECL(dlartgs)(const DOUBLE     *X,
                     const DOUBLE     *Y,
                     const DOUBLE     *SIGMA,
                     DOUBLE           *CS,
                     DOUBLE           *SN)
{
    DEBUG_LAPACK_STUB("dlartgs");
    LAPACK_IMPL(dlartgs)(X,
                         Y,
                         SIGMA,
                         CS,
                         SN);
}

//-- dlartv --------------------------------------------------------------------
void
LAPACK_DECL(dlartv)(const INTEGER    *N,
                    DOUBLE           *X,
                    const INTEGER    *INCX,
                    DOUBLE           *Y,
                    const INTEGER    *INCY,
                    const DOUBLE     *C,
                    const DOUBLE     *S,
                    const INTEGER    *INCC)
{
    DEBUG_LAPACK_STUB("dlartv");
    LAPACK_IMPL(dlartv)(N,
                        X,
                        INCX,
                        Y,
                        INCY,
                        C,
                        S,
                        INCC);
}

//-- dlaruv --------------------------------------------------------------------
void
LAPACK_DECL(dlaruv)(INTEGER          *ISEED,
                    const INTEGER    *N,
                    DOUBLE           *X)
{
    DEBUG_LAPACK_STUB("dlaruv");
    LAPACK_IMPL(dlaruv)(ISEED,
                        N,
                        X);
}

//-- dlarz ---------------------------------------------------------------------
void
LAPACK_DECL(dlarz)(const char           *SIDE,
                   const INTEGER        *M,
                   const INTEGER        *N,
                   const INTEGER        *L,
                   const DOUBLE         *V,
                   const INTEGER        *INCV,
                   const DOUBLE         *TAU,
                   DOUBLE               *C,
                   const INTEGER        *LDC,
                   DOUBLE               *WORK)
{
    DEBUG_LAPACK_STUB("dlarz");
    LAPACK_IMPL(dlarz)(SIDE,
                       M,
                       N,
                       L,
                       V,
                       INCV,
                       TAU,
                       C,
                       LDC,
                       WORK);
}

//-- dlarzb --------------------------------------------------------------------
void
LAPACK_DECL(dlarzb)(const char       *SIDE,
                    const char       *TRANS,
                    const char       *DIRECT,
                    const char       *STOREV,
                    const INTEGER    *M,
                    const INTEGER    *N,
                    const INTEGER    *K,
                    const INTEGER    *L,
                    const DOUBLE     *V,
                    const INTEGER    *LDV,
                    const DOUBLE     *T,
                    const INTEGER    *LDT,
                    DOUBLE           *C,
                    const INTEGER    *LDC,
                    DOUBLE           *WORK,
                    const INTEGER    *LDWORK)
{
    DEBUG_LAPACK_STUB("dlarzb");
    LAPACK_IMPL(dlarzb)(SIDE,
                        TRANS,
                        DIRECT,
                        STOREV,
                        M,
                        N,
                        K,
                        L,
                        V,
                        LDV,
                        T,
                        LDT,
                        C,
                        LDC,
                        WORK,
                        LDWORK);
}

//-- dlarzt --------------------------------------------------------------------
void
LAPACK_DECL(dlarzt)(const char       *DIRECT,
                    const char       *STOREV,
                    const INTEGER    *N,
                    const INTEGER    *K,
                    DOUBLE           *V,
                    const INTEGER    *LDV,
                    const DOUBLE     *TAU,
                    DOUBLE           *T,
                    const INTEGER    *LDT)
{
    DEBUG_LAPACK_STUB("dlarzt");
    LAPACK_IMPL(dlarzt)(DIRECT,
                        STOREV,
                        N,
                        K,
                        V,
                        LDV,
                        TAU,
                        T,
                        LDT);
}

//-- dlas2 ---------------------------------------------------------------------
void
LAPACK_DECL(dlas2)(const DOUBLE     *F,
                   const DOUBLE     *G,
                   const DOUBLE     *H,
                   DOUBLE           *SSMIN,
                   DOUBLE           *SSMAX)
{
    DEBUG_LAPACK_STUB("dlas2");
    LAPACK_IMPL(dlas2)(F,
                       G,
                       H,
                       SSMIN,
                       SSMAX);
}

//-- dlascl --------------------------------------------------------------------
void
LAPACK_DECL(dlascl)(const char       *TYPE,
                    const INTEGER    *KL,
                    const INTEGER    *KU,
                    const DOUBLE     *CFROM,
                    const DOUBLE     *CTO,
                    const INTEGER    *M,
                    const INTEGER    *N,
                    DOUBLE           *A,
                    const INTEGER    *LDA,
                    INTEGER          *INFO)
{
    DEBUG_LAPACK_STUB("dlascl");
    LAPACK_IMPL(dlascl)(TYPE,
                        KL,
                        KU,
                        CFROM,
                        CTO,
                        M,
                        N,
                        A,
                        LDA,
                        INFO);
}

//-- dlascl2 -------------------------------------------------------------------
void
LAPACK_DECL(dlascl2)(const INTEGER    *M,
                     const INTEGER    *N,
                     const DOUBLE     *D,
                     DOUBLE           *X,
                     const INTEGER    *LDX)
{
    DEBUG_LAPACK_STUB("dlascl2");
    LAPACK_IMPL(dlascl2)(M,
                         N,
                         D,
                         X,
                         LDX);
}

//-- dlasd0 --------------------------------------------------------------------
void
LAPACK_DECL(dlasd0)(const INTEGER    *N,
                    const INTEGER    *SQRE,
                    DOUBLE           *D,
                    const DOUBLE     *E,
                    DOUBLE           *U,
                    const INTEGER    *LDU,
                    DOUBLE           *VT,
                    const INTEGER    *LDVT,
                    const INTEGER    *SMLSIZ,
                    INTEGER          *IWORK,
                    DOUBLE           *WORK,
                    INTEGER          *INFO)
{
    DEBUG_LAPACK_STUB("dlasd0");
    LAPACK_IMPL(dlasd0)(N,
                        SQRE,
                        D,
                        E,
                        U,
                        LDU,
                        VT,
                        LDVT,
                        SMLSIZ,
                        IWORK,
                        WORK,
                        INFO);
}

//-- dlasd1 --------------------------------------------------------------------
void
LAPACK_DECL(dlasd1)(const INTEGER    *NL,
                    const INTEGER    *NR,
                    const INTEGER    *SQRE,
                    DOUBLE           *D,
                    DOUBLE           *ALPHA,
                    DOUBLE           *BETA,
                    DOUBLE           *U,
                    const INTEGER    *LDU,
                    DOUBLE           *VT,
                    const INTEGER    *LDVT,
                    INTEGER          *IDXQ,
                    INTEGER          *IWORK,
                    DOUBLE           *WORK,
                    INTEGER          *INFO)
{
    DEBUG_LAPACK_STUB("dlasd1");
    LAPACK_IMPL(dlasd1)(NL,
                        NR,
                        SQRE,
                        D,
                        ALPHA,
                        BETA,
                        U,
                        LDU,
                        VT,
                        LDVT,
                        IDXQ,
                        IWORK,
                        WORK,
                        INFO);
}

//-- dlasd2 --------------------------------------------------------------------
void
LAPACK_DECL(dlasd2)(const INTEGER    *NL,
                    const INTEGER    *NR,
                    const INTEGER    *SQRE,
                    INTEGER          *K,
                    DOUBLE           *D,
                    DOUBLE           *Z,
                    const DOUBLE     *ALPHA,
                    const DOUBLE     *BETA,
                    DOUBLE           *U,
                    const INTEGER    *LDU,
                    DOUBLE           *VT,
                    const INTEGER    *LDVT,
                    DOUBLE           *DSIGMA,
                    DOUBLE           *U2,
                    const INTEGER    *LDU2,
                    DOUBLE           *VT2,
                    const INTEGER    *LDVT2,
                    INTEGER          *IDXP,
                    INTEGER          *IDX,
                    INTEGER          *IDXC,
                    INTEGER          *IDXQ,
                    INTEGER          *COLTYP,
                    INTEGER          *INFO)
{
    DEBUG_LAPACK_STUB("dlasd2");
    LAPACK_IMPL(dlasd2)(NL,
                        NR,
                        SQRE,
                        K,
                        D,
                        Z,
                        ALPHA,
                        BETA,
                        U,
                        LDU,
                        VT,
                        LDVT,
                        DSIGMA,
                        U2,
                        LDU2,
                        VT2,
                        LDVT2,
                        IDXP,
                        IDX,
                        IDXC,
                        IDXQ,
                        COLTYP,
                        INFO);
}

//-- dlasd3 --------------------------------------------------------------------
void
LAPACK_DECL(dlasd3)(const INTEGER    *NL,
                    const INTEGER    *NR,
                    const INTEGER    *SQRE,
                    const INTEGER    *K,
                    DOUBLE           *D,
                    DOUBLE           *Q,
                    const INTEGER    *LDQ,
                    const DOUBLE     *DSIGMA,
                    DOUBLE           *U,
                    const INTEGER    *LDU,
                    DOUBLE           *U2,
                    const INTEGER    *LDU2,
                    DOUBLE           *VT,
                    const INTEGER    *LDVT,
                    DOUBLE           *VT2,
                    const INTEGER    *LDVT2,
                    const INTEGER    *IDXC,
                    const INTEGER    *CTOT,
                    const DOUBLE     *Z,
                    INTEGER          *INFO)
{
    DEBUG_LAPACK_STUB("dlasd3");
    LAPACK_IMPL(dlasd3)(NL,
                        NR,
                        SQRE,
                        K,
                        D,
                        Q,
                        LDQ,
                        DSIGMA,
                        U,
                        LDU,
                        U2,
                        LDU2,
                        VT,
                        LDVT,
                        VT2,
                        LDVT2,
                        IDXC,
                        CTOT,
                        Z,
                        INFO);
}

//-- dlasd4 --------------------------------------------------------------------
void
LAPACK_DECL(dlasd4)(const INTEGER    *N,
                    const INTEGER    *I,
                    const DOUBLE     *D,
                    const DOUBLE     *Z,
                    DOUBLE           *DELTA,
                    const DOUBLE     *RHO,
                    DOUBLE           *SIGMA,
                    DOUBLE           *WORK,
                    INTEGER          *INFO)
{
    DEBUG_LAPACK_STUB("dlasd4");
    LAPACK_IMPL(dlasd4)(N,
                        I,
                        D,
                        Z,
                        DELTA,
                        RHO,
                        SIGMA,
                        WORK,
                        INFO);
}

//-- dlasd5 --------------------------------------------------------------------
void
LAPACK_DECL(dlasd5)(const INTEGER    *I,
                    const DOUBLE     *D,
                    const DOUBLE     *Z,
                    DOUBLE           *DELTA,
                    const DOUBLE     *RHO,
                    DOUBLE           *DSIGMA,
                    DOUBLE           *WORK)
{
    DEBUG_LAPACK_STUB("dlasd5");
    LAPACK_IMPL(dlasd5)(I,
                        D,
                        Z,
                        DELTA,
                        RHO,
                        DSIGMA,
                        WORK);
}

//-- dlasd6 --------------------------------------------------------------------
void
LAPACK_DECL(dlasd6)(const INTEGER    *ICOMPQ,
                    const INTEGER    *NL,
                    const INTEGER    *NR,
                    const INTEGER    *SQRE,
                    DOUBLE           *D,
                    DOUBLE           *VF,
                    DOUBLE           *VL,
                    DOUBLE           *ALPHA,
                    DOUBLE           *BETA,
                    INTEGER          *IDXQ,
                    INTEGER          *PERM,
                    INTEGER          *GIVPTR,
                    INTEGER          *GIVCOL,
                    const INTEGER    *LDGCOL,
                    DOUBLE           *GIVNUM,
                    const INTEGER    *LDGNUM,
                    DOUBLE           *POLES,
                    DOUBLE           *DIFL,
                    DOUBLE           *DIFR,
                    DOUBLE           *Z,
                    INTEGER          *K,
                    DOUBLE           *C,
                    DOUBLE           *S,
                    DOUBLE           *WORK,
                    INTEGER          *IWORK,
                    INTEGER          *INFO)
{
    DEBUG_LAPACK_STUB("dlasd6");
    LAPACK_IMPL(dlasd6)(ICOMPQ,
                        NL,
                        NR,
                        SQRE,
                        D,
                        VF,
                        VL,
                        ALPHA,
                        BETA,
                        IDXQ,
                        PERM,
                        GIVPTR,
                        GIVCOL,
                        LDGCOL,
                        GIVNUM,
                        LDGNUM,
                        POLES,
                        DIFL,
                        DIFR,
                        Z,
                        K,
                        C,
                        S,
                        WORK,
                        IWORK,
                        INFO);
}

//-- dlasd7 --------------------------------------------------------------------
void
LAPACK_DECL(dlasd7)(const INTEGER    *ICOMPQ,
                    const INTEGER    *NL,
                    const INTEGER    *NR,
                    const INTEGER    *SQRE,
                    INTEGER          *K,
                    DOUBLE           *D,
                    DOUBLE           *Z,
                    DOUBLE           *ZW,
                    DOUBLE           *VF,
                    DOUBLE           *VFW,
                    DOUBLE           *VL,
                    DOUBLE           *VLW,
                    const DOUBLE     *ALPHA,
                    const DOUBLE     *BETA,
                    DOUBLE           *DSIGMA,
                    INTEGER          *IDX,
                    INTEGER          *IDXP,
                    const INTEGER    *IDXQ,
                    INTEGER          *PERM,
                    INTEGER          *GIVPTR,
                    INTEGER          *GIVCOL,
                    const INTEGER    *LDGCOL,
                    DOUBLE           *GIVNUM,
                    const INTEGER    *LDGNUM,
                    DOUBLE           *C,
                    DOUBLE           *S,
                    INTEGER          *INFO)
{
    DEBUG_LAPACK_STUB("dlasd7");
    LAPACK_IMPL(dlasd7)(ICOMPQ,
                        NL,
                        NR,
                        SQRE,
                        K,
                        D,
                        Z,
                        ZW,
                        VF,
                        VFW,
                        VL,
                        VLW,
                        ALPHA,
                        BETA,
                        DSIGMA,
                        IDX,
                        IDXP,
                        IDXQ,
                        PERM,
                        GIVPTR,
                        GIVCOL,
                        LDGCOL,
                        GIVNUM,
                        LDGNUM,
                        C,
                        S,
                        INFO);
}

//-- dlasd8 --------------------------------------------------------------------
void
LAPACK_DECL(dlasd8)(const INTEGER    *ICOMPQ,
                    const INTEGER    *K,
                    DOUBLE           *D,
                    DOUBLE           *Z,
                    DOUBLE           *VF,
                    DOUBLE           *VL,
                    DOUBLE           *DIFL,
                    DOUBLE           *DIFR,
                    const INTEGER    *LDDIFR,
                    DOUBLE           *DSIGMA,
                    DOUBLE           *WORK,
                    INTEGER          *INFO)
{
    DEBUG_LAPACK_STUB("dlasd8");
    LAPACK_IMPL(dlasd8)(ICOMPQ,
                        K,
                        D,
                        Z,
                        VF,
                        VL,
                        DIFL,
                        DIFR,
                        LDDIFR,
                        DSIGMA,
                        WORK,
                        INFO);
}

//-- dlasda --------------------------------------------------------------------
void
LAPACK_DECL(dlasda)(const INTEGER    *ICOMPQ,
                    const INTEGER    *SMLSIZ,
                    const INTEGER    *N,
                    const INTEGER    *SQRE,
                    DOUBLE           *D,
                    const DOUBLE     *E,
                    DOUBLE           *U,
                    const INTEGER    *LDU,
                    DOUBLE           *VT,
                    INTEGER          *K,
                    DOUBLE           *DIFL,
                    DOUBLE           *DIFR,
                    DOUBLE           *Z,
                    DOUBLE           *POLES,
                    INTEGER          *GIVPTR,
                    INTEGER          *GIVCOL,
                    const INTEGER    *LDGCOL,
                    INTEGER          *PERM,
                    DOUBLE           *GIVNUM,
                    DOUBLE           *C,
                    DOUBLE           *S,
                    DOUBLE           *WORK,
                    INTEGER          *IWORK,
                    INTEGER          *INFO)
{
    DEBUG_LAPACK_STUB("dlasda");
    LAPACK_IMPL(dlasda)(ICOMPQ,
                        SMLSIZ,
                        N,
                        SQRE,
                        D,
                        E,
                        U,
                        LDU,
                        VT,
                        K,
                        DIFL,
                        DIFR,
                        Z,
                        POLES,
                        GIVPTR,
                        GIVCOL,
                        LDGCOL,
                        PERM,
                        GIVNUM,
                        C,
                        S,
                        WORK,
                        IWORK,
                        INFO);
}

//-- dlasdq --------------------------------------------------------------------
void
LAPACK_DECL(dlasdq)(const char       *UPLO,
                    const INTEGER    *SQRE,
                    const INTEGER    *N,
                    const INTEGER    *NCVT,
                    const INTEGER    *NRU,
                    const INTEGER    *NCC,
                    DOUBLE           *D,
                    DOUBLE           *E,
                    DOUBLE           *VT,
                    const INTEGER    *LDVT,
                    DOUBLE           *U,
                    const INTEGER    *LDU,
                    DOUBLE           *C,
                    const INTEGER    *LDC,
                    DOUBLE           *WORK,
                    INTEGER          *INFO)
{
    DEBUG_LAPACK_STUB("dlasdq");
    LAPACK_IMPL(dlasdq)(UPLO,
                        SQRE,
                        N,
                        NCVT,
                        NRU,
                        NCC,
                        D,
                        E,
                        VT,
                        LDVT,
                        U,
                        LDU,
                        C,
                        LDC,
                        WORK,
                        INFO);
}

//-- dlasdt --------------------------------------------------------------------
void
LAPACK_DECL(dlasdt)(const INTEGER    *N,
                    INTEGER          *LVL,
                    INTEGER          *ND,
                    INTEGER          *INODE,
                    INTEGER          *NDIML,
                    INTEGER          *NDIMR,
                    const INTEGER    *MSUB)
{
    DEBUG_LAPACK_STUB("dlasdt");
    LAPACK_IMPL(dlasdt)(N,
                        LVL,
                        ND,
                        INODE,
                        NDIML,
                        NDIMR,
                        MSUB);
}

//-- dlaset --------------------------------------------------------------------
void
LAPACK_DECL(dlaset)(const char       *UPLO,
                    const INTEGER    *M,
                    const INTEGER    *N,
                    const DOUBLE     *ALPHA,
                    const DOUBLE     *BETA,
                    DOUBLE           *A,
                    const INTEGER    *LDA)
{
    DEBUG_LAPACK_STUB("dlaset");
    LAPACK_IMPL(dlaset)(UPLO,
                        M,
                        N,
                        ALPHA,
                        BETA,
                        A,
                        LDA);
}

//-- dlasq1 --------------------------------------------------------------------
void
LAPACK_DECL(dlasq1)(const INTEGER    *N,
                    DOUBLE           *D,
                    DOUBLE           *E,
                    DOUBLE           *WORK,
                    INTEGER          *INFO)
{
    DEBUG_LAPACK_STUB("dlasq1");
    LAPACK_IMPL(dlasq1)(N,
                        D,
                        E,
                        WORK,
                        INFO);
}

//-- dlasq2 --------------------------------------------------------------------
void
LAPACK_DECL(dlasq2)(const INTEGER    *N,
                    DOUBLE           *Z,
                    INTEGER          *INFO)
{
    DEBUG_LAPACK_STUB("dlasq2");
    LAPACK_IMPL(dlasq2)(N,
                        Z,
                        INFO);
}

//-- dlasq3 --------------------------------------------------------------------
void
LAPACK_DECL(dlasq3)(const INTEGER    *I0,
                    INTEGER          *N0,
                    const DOUBLE     *Z,
                    INTEGER          *PP,
                    DOUBLE           *DMIN,
                    DOUBLE           *SIGMA,
                    DOUBLE           *DESIG,
                    const DOUBLE     *QMAX,
                    INTEGER          *NFAIL,
                    INTEGER          *ITER,
                    INTEGER          *NDIV,
                    const LOGICAL    *IEEE,
                    INTEGER          *TTYPE,
                    DOUBLE           *DMIN1,
                    DOUBLE           *DMIN2,
                    DOUBLE           *DN,
                    DOUBLE           *DN1,
                    DOUBLE           *DN2,
                    DOUBLE           *G,
                    DOUBLE           *TAU)
{
    DEBUG_LAPACK_STUB("dlasq3");
    LAPACK_IMPL(dlasq3)(I0,
                        N0,
                        Z,
                        PP,
                        DMIN,
                        SIGMA,
                        DESIG,
                        QMAX,
                        NFAIL,
                        ITER,
                        NDIV,
                        IEEE,
                        TTYPE,
                        DMIN1,
                        DMIN2,
                        DN,
                        DN1,
                        DN2,
                        G,
                        TAU);
}

//-- dlasq4 --------------------------------------------------------------------
void
LAPACK_DECL(dlasq4)(const INTEGER    *I0,
                    const INTEGER    *N0,
                    const DOUBLE     *Z,
                    const INTEGER    *PP,
                    const INTEGER    *N0IN,
                    const DOUBLE     *DMIN,
                    const DOUBLE     *DMIN1,
                    const DOUBLE     *DMIN2,
                    const DOUBLE     *DN,
                    const DOUBLE     *DN1,
                    const DOUBLE     *DN2,
                    DOUBLE           *TAU,
                    INTEGER          *TTYPE,
                    DOUBLE           *G)
{
    DEBUG_LAPACK_STUB("dlasq4");
    LAPACK_IMPL(dlasq4)(I0,
                        N0,
                        Z,
                        PP,
                        N0IN,
                        DMIN,
                        DMIN1,
                        DMIN2,
                        DN,
                        DN1,
                        DN2,
                        TAU,
                        TTYPE,
                        G);
}

//-- dlasq5 --------------------------------------------------------------------
void
LAPACK_DECL(dlasq5)(const INTEGER    *I0,
                    const INTEGER    *N0,
                    const DOUBLE     *Z,
                    const INTEGER    *PP,
                    const DOUBLE     *TAU,
                    DOUBLE           *DMIN,
                    DOUBLE           *DMIN1,
                    DOUBLE           *DMIN2,
                    DOUBLE           *DN,
                    DOUBLE           *DNM1,
                    DOUBLE           *DNM2,
                    const LOGICAL    *IEEE)
{
    DEBUG_LAPACK_STUB("dlasq5");
    LAPACK_IMPL(dlasq5)(I0,
                        N0,
                        Z,
                        PP,
                        TAU,
                        DMIN,
                        DMIN1,
                        DMIN2,
                        DN,
                        DNM1,
                        DNM2,
                        IEEE);
}

//-- dlasq6 --------------------------------------------------------------------
void
LAPACK_DECL(dlasq6)(const INTEGER    *I0,
                    const INTEGER    *N0,
                    const DOUBLE     *Z,
                    const INTEGER    *PP,
                    DOUBLE           *DMIN,
                    DOUBLE           *DMIN1,
                    DOUBLE           *DMIN2,
                    DOUBLE           *DN,
                    DOUBLE           *DNM1,
                    DOUBLE           *DNM2)
{
    DEBUG_LAPACK_STUB("dlasq6");
    LAPACK_IMPL(dlasq6)(I0,
                        N0,
                        Z,
                        PP,
                        DMIN,
                        DMIN1,
                        DMIN2,
                        DN,
                        DNM1,
                        DNM2);
}

//-- dlasr ---------------------------------------------------------------------
void
LAPACK_DECL(dlasr)(const char           *SIDE,
                   const char           *PIVOT,
                   const char           *DIRECT,
                   const INTEGER        *M,
                   const INTEGER        *N,
                   const DOUBLE         *C,
                   const DOUBLE         *S,
                   DOUBLE               *A,
                   const INTEGER        *LDA)
{
    DEBUG_LAPACK_STUB("dlasr");
    LAPACK_IMPL(dlasr)(SIDE,
                       PIVOT,
                       DIRECT,
                       M,
                       N,
                       C,
                       S,
                       A,
                       LDA);
}

//-- dlasrt --------------------------------------------------------------------
void
LAPACK_DECL(dlasrt)(const char       *ID,
                    const INTEGER    *N,
                    DOUBLE           *D,
                    INTEGER          *INFO)
{
    DEBUG_LAPACK_STUB("dlasrt");
    LAPACK_IMPL(dlasrt)(ID,
                        N,
                        D,
                        INFO);
}

//-- dlassq --------------------------------------------------------------------
void
LAPACK_DECL(dlassq)(const INTEGER    *N,
                    const DOUBLE     *X,
                    const INTEGER    *INCX,
                    DOUBLE           *SCALE,
                    DOUBLE           *SUMSQ)
{
    DEBUG_LAPACK_STUB("dlassq");
    LAPACK_IMPL(dlassq)(N,
                        X,
                        INCX,
                        SCALE,
                        SUMSQ);
}

//-- dlasv2 --------------------------------------------------------------------
void
LAPACK_DECL(dlasv2)(const DOUBLE     *F,
                    const DOUBLE     *G,
                    const DOUBLE     *H,
                    DOUBLE           *SSMIN,
                    DOUBLE           *SSMAX,
                    DOUBLE           *SNR,
                    DOUBLE           *CSR,
                    DOUBLE           *SNL,
                    DOUBLE           *CSL)
{
    DEBUG_LAPACK_STUB("dlasv2");
    LAPACK_IMPL(dlasv2)(F,
                        G,
                        H,
                        SSMIN,
                        SSMAX,
                        SNR,
                        CSR,
                        SNL,
                        CSL);
}

//-- dlaswp --------------------------------------------------------------------
void
LAPACK_DECL(dlaswp)(const INTEGER    *N,
                    DOUBLE           *A,
                    const INTEGER    *LDA,
                    const INTEGER    *K1,
                    const INTEGER    *K2,
                    const INTEGER    *IPIV,
                    const INTEGER    *INCX)
{
    DEBUG_LAPACK_STUB("dlaswp");
    LAPACK_IMPL(dlaswp)(N,
                        A,
                        LDA,
                        K1,
                        K2,
                        IPIV,
                        INCX);
}

//-- dlasy2 --------------------------------------------------------------------
void
LAPACK_DECL(dlasy2)(const LOGICAL    *LTRANL,
                    const LOGICAL    *LTRANR,
                    const INTEGER    *ISGN,
                    const INTEGER    *N1,
                    const INTEGER    *N2,
                    const DOUBLE     *TL,
                    const INTEGER    *LDTL,
                    const DOUBLE     *TR,
                    const INTEGER    *LDTR,
                    const DOUBLE     *B,
                    const INTEGER    *LDB,
                    DOUBLE           *SCALE,
                    DOUBLE           *X,
                    const INTEGER    *LDX,
                    DOUBLE           *XNORM,
                    INTEGER          *INFO)
{
    DEBUG_LAPACK_STUB("dlasy2");
    LAPACK_IMPL(dlasy2)(LTRANL,
                        LTRANR,
                        ISGN,
                        N1,
                        N2,
                        TL,
                        LDTL,
                        TR,
                        LDTR,
                        B,
                        LDB,
                        SCALE,
                        X,
                        LDX,
                        XNORM,
                        INFO);
}

//-- dlasyf --------------------------------------------------------------------
void
LAPACK_DECL(dlasyf)(const char       *UPLO,
                    const INTEGER    *N,
                    const INTEGER    *NB,
                    INTEGER          *KB,
                    DOUBLE           *A,
                    const INTEGER    *LDA,
                    INTEGER          *IPIV,
                    DOUBLE           *W,
                    const INTEGER    *LDW,
                    INTEGER          *INFO)
{
    DEBUG_LAPACK_STUB("dlasyf");
    LAPACK_IMPL(dlasyf)(UPLO,
                        N,
                        NB,
                        KB,
                        A,
                        LDA,
                        IPIV,
                        W,
                        LDW,
                        INFO);
}

//-- dlat2s --------------------------------------------------------------------
void
LAPACK_DECL(dlat2s)(const char       *UPLO,
                    const INTEGER    *N,
                    const DOUBLE     *A,
                    const INTEGER    *LDA,
                    FLOAT            *SA,
                    const INTEGER    *LDSA,
                    INTEGER          *INFO)
{
    DEBUG_LAPACK_STUB("dlat2s");
    LAPACK_IMPL(dlat2s)(UPLO,
                        N,
                        A,
                        LDA,
                        SA,
                        LDSA,
                        INFO);
}

//-- dlatbs --------------------------------------------------------------------
void
LAPACK_DECL(dlatbs)(const char       *UPLO,
                    const char       *TRANS,
                    const char       *DIAG,
                    const char       *NORMIN,
                    const INTEGER    *N,
                    const INTEGER    *KD,
                    const DOUBLE     *AB,
                    const INTEGER    *LDAB,
                    DOUBLE           *X,
                    DOUBLE           *SCALE,
                    DOUBLE           *CNORM,
                    INTEGER          *INFO)
{
    DEBUG_LAPACK_STUB("dlatbs");
    LAPACK_IMPL(dlatbs)(UPLO,
                        TRANS,
                        DIAG,
                        NORMIN,
                        N,
                        KD,
                        AB,
                        LDAB,
                        X,
                        SCALE,
                        CNORM,
                        INFO);
}

//-- dlatdf --------------------------------------------------------------------
void
LAPACK_DECL(dlatdf)(const INTEGER    *IJOB,
                    const INTEGER    *N,
                    const DOUBLE     *Z,
                    const INTEGER    *LDZ,
                    DOUBLE           *RHS,
                    DOUBLE           *RDSUM,
                    DOUBLE           *RDSCAL,
                    const INTEGER    *IPIV,
                    const INTEGER    *JPIV)
{
    DEBUG_LAPACK_STUB("dlatdf");
    LAPACK_IMPL(dlatdf)(IJOB,
                        N,
                        Z,
                        LDZ,
                        RHS,
                        RDSUM,
                        RDSCAL,
                        IPIV,
                        JPIV);
}

//-- dlatps --------------------------------------------------------------------
void
LAPACK_DECL(dlatps)(const char       *UPLO,
                    const char       *TRANS,
                    const char       *DIAG,
                    const char       *NORMIN,
                    const INTEGER    *N,
                    const DOUBLE     *AP,
                    DOUBLE           *X,
                    DOUBLE           *SCALE,
                    DOUBLE           *CNORM,
                    INTEGER          *INFO)
{
    DEBUG_LAPACK_STUB("dlatps");
    LAPACK_IMPL(dlatps)(UPLO,
                        TRANS,
                        DIAG,
                        NORMIN,
                        N,
                        AP,
                        X,
                        SCALE,
                        CNORM,
                        INFO);
}

//-- dlatrd --------------------------------------------------------------------
void
LAPACK_DECL(dlatrd)(const char       *UPLO,
                    const INTEGER    *N,
                    const INTEGER    *NB,
                    DOUBLE           *A,
                    const INTEGER    *LDA,
                    DOUBLE           *E,
                    DOUBLE           *TAU,
                    DOUBLE           *W,
                    const INTEGER    *LDW)
{
    DEBUG_LAPACK_STUB("dlatrd");
    LAPACK_IMPL(dlatrd)(UPLO,
                        N,
                        NB,
                        A,
                        LDA,
                        E,
                        TAU,
                        W,
                        LDW);
}

//-- dlatrs --------------------------------------------------------------------
void
LAPACK_DECL(dlatrs)(const char       *UPLO,
                    const char       *TRANS,
                    const char       *DIAG,
                    const char       *NORMIN,
                    const INTEGER    *N,
                    const DOUBLE     *A,
                    const INTEGER    *LDA,
                    DOUBLE           *X,
                    DOUBLE           *SCALE,
                    DOUBLE           *CNORM,
                    INTEGER          *INFO)
{
    DEBUG_LAPACK_STUB("dlatrs");
    LAPACK_IMPL(dlatrs)(UPLO,
                        TRANS,
                        DIAG,
                        NORMIN,
                        N,
                        A,
                        LDA,
                        X,
                        SCALE,
                        CNORM,
                        INFO);
}

//-- dlatrz --------------------------------------------------------------------
void
LAPACK_DECL(dlatrz)(const INTEGER    *M,
                    const INTEGER    *N,
                    const INTEGER    *L,
                    DOUBLE           *A,
                    const INTEGER    *LDA,
                    DOUBLE           *TAU,
                    DOUBLE           *WORK)
{
    DEBUG_LAPACK_STUB("dlatrz");
    LAPACK_IMPL(dlatrz)(M,
                        N,
                        L,
                        A,
                        LDA,
                        TAU,
                        WORK);
}

//-- dlatzm --------------------------------------------------------------------
void
LAPACK_DECL(dlatzm)(const char       *SIDE,
                    const INTEGER    *M,
                    const INTEGER    *N,
                    const DOUBLE     *V,
                    const INTEGER    *INCV,
                    const DOUBLE     *TAU,
                    DOUBLE           *C1,
                    DOUBLE           *C2,
                    const INTEGER    *LDC,
                    DOUBLE           *WORK)
{
    DEBUG_LAPACK_STUB("dlatzm");
    LAPACK_IMPL(dlatzm)(SIDE,
                        M,
                        N,
                        V,
                        INCV,
                        TAU,
                        C1,
                        C2,
                        LDC,
                        WORK);
}

//-- dlauu2 --------------------------------------------------------------------
void
LAPACK_DECL(dlauu2)(const char       *UPLO,
                    const INTEGER    *N,
                    DOUBLE           *A,
                    const INTEGER    *LDA,
                    INTEGER          *INFO)
{
    DEBUG_LAPACK_STUB("dlauu2");
    LAPACK_IMPL(dlauu2)(UPLO,
                        N,
                        A,
                        LDA,
                        INFO);
}

//-- dlauum --------------------------------------------------------------------
void
LAPACK_DECL(dlauum)(const char       *UPLO,
                    const INTEGER    *N,
                    DOUBLE           *A,
                    const INTEGER    *LDA,
                    INTEGER          *INFO)
{
    DEBUG_LAPACK_STUB("dlauum");
    LAPACK_IMPL(dlauum)(UPLO,
                        N,
                        A,
                        LDA,
                        INFO);
}

//-- dopgtr --------------------------------------------------------------------
void
LAPACK_DECL(dopgtr)(const char       *UPLO,
                    const INTEGER    *N,
                    const DOUBLE     *AP,
                    const DOUBLE     *TAU,
                    DOUBLE           *Q,
                    const INTEGER    *LDQ,
                    DOUBLE           *WORK,
                    INTEGER          *INFO)
{
    DEBUG_LAPACK_STUB("dopgtr");
    LAPACK_IMPL(dopgtr)(UPLO,
                        N,
                        AP,
                        TAU,
                        Q,
                        LDQ,
                        WORK,
                        INFO);
}

//-- dopmtr --------------------------------------------------------------------
void
LAPACK_DECL(dopmtr)(const char       *SIDE,
                    const char       *UPLO,
                    const char       *TRANS,
                    const INTEGER    *M,
                    const INTEGER    *N,
                    const DOUBLE     *AP,
                    const DOUBLE     *TAU,
                    DOUBLE           *C,
                    const INTEGER    *LDC,
                    DOUBLE           *WORK,
                    INTEGER          *INFO)
{
    DEBUG_LAPACK_STUB("dopmtr");
    LAPACK_IMPL(dopmtr)(SIDE,
                        UPLO,
                        TRANS,
                        M,
                        N,
                        AP,
                        TAU,
                        C,
                        LDC,
                        WORK,
                        INFO);
}

//-- dorbdb --------------------------------------------------------------------
void
LAPACK_DECL(dorbdb)(const char       *TRANS,
                    const char       *SIGNS,
                    const INTEGER    *M,
                    const INTEGER    *P,
                    const INTEGER    *Q,
                    DOUBLE           *X11,
                    const INTEGER    *LDX11,
                    DOUBLE           *X12,
                    const INTEGER    *LDX12,
                    DOUBLE           *X21,
                    const INTEGER    *LDX21,
                    DOUBLE           *X22,
                    const INTEGER    *LDX22,
                    DOUBLE           *THETA,
                    DOUBLE           *PHI,
                    DOUBLE           *TAUP1,
                    DOUBLE           *TAUP2,
                    DOUBLE           *TAUQ1,
                    DOUBLE           *TAUQ2,
                    DOUBLE           *WORK,
                    const INTEGER    *LWORK,
                    INTEGER          *INFO)
{
    DEBUG_LAPACK_STUB("dorbdb");
    LAPACK_IMPL(dorbdb)(TRANS,
                        SIGNS,
                        M,
                        P,
                        Q,
                        X11,
                        LDX11,
                        X12,
                        LDX12,
                        X21,
                        LDX21,
                        X22,
                        LDX22,
                        THETA,
                        PHI,
                        TAUP1,
                        TAUP2,
                        TAUQ1,
                        TAUQ2,
                        WORK,
                        LWORK,
                        INFO);
}

//-- dorcsd --------------------------------------------------------------------
void
LAPACK_DECL(dorcsd)(const char       *JOBU1,
                    const char       *JOBU2,
                    const char       *JOBV1T,
                    const char       *JOBV2T,
                    const char       *TRANS,
                    const char       *SIGNS,
                    const INTEGER    *M,
                    const INTEGER    *P,
                    const INTEGER    *Q,
                    const DOUBLE     *X11,
                    const INTEGER    *LDX11,
                    const DOUBLE     *X12,
                    const INTEGER    *LDX12,
                    const DOUBLE     *X21,
                    const INTEGER    *LDX21,
                    const DOUBLE     *X22,
                    const INTEGER    *LDX22,
                    DOUBLE           *THETA,
                    DOUBLE           *U1,
                    const INTEGER    *LDU1,
                    DOUBLE           *U2,
                    const INTEGER    *LDU2,
                    DOUBLE           *V1T,
                    const INTEGER    *LDV1T,
                    DOUBLE           *V2T,
                    const INTEGER    *LDV2T,
                    DOUBLE           *WORK,
                    const INTEGER    *LWORK,
                    INTEGER          *IWORK,
                    INTEGER          *INFO)
{
    DEBUG_LAPACK_STUB("dorcsd");
    LAPACK_IMPL(dorcsd)(JOBU1,
                        JOBU2,
                        JOBV1T,
                        JOBV2T,
                        TRANS,
                        SIGNS,
                        M,
                        P,
                        Q,
                        X11,
                        LDX11,
                        X12,
                        LDX12,
                        X21,
                        LDX21,
                        X22,
                        LDX22,
                        THETA,
                        U1,
                        LDU1,
                        U2,
                        LDU2,
                        V1T,
                        LDV1T,
                        V2T,
                        LDV2T,
                        WORK,
                        LWORK,
                        IWORK,
                        INFO);
}

//-- dorg2l --------------------------------------------------------------------
void
LAPACK_DECL(dorg2l)(const INTEGER    *M,
                    const INTEGER    *N,
                    const INTEGER    *K,
                    DOUBLE           *A,
                    const INTEGER    *LDA,
                    const DOUBLE     *TAU,
                    DOUBLE           *WORK,
                    INTEGER          *INFO)
{
    DEBUG_LAPACK_STUB("dorg2l");
    LAPACK_IMPL(dorg2l)(M,
                        N,
                        K,
                        A,
                        LDA,
                        TAU,
                        WORK,
                        INFO);
}

//-- dorg2r --------------------------------------------------------------------
void
LAPACK_DECL(dorg2r)(const INTEGER    *M,
                    const INTEGER    *N,
                    const INTEGER    *K,
                    DOUBLE           *A,
                    const INTEGER    *LDA,
                    const DOUBLE     *TAU,
                    DOUBLE           *WORK,
                    INTEGER          *INFO)
{
    DEBUG_LAPACK_STUB("dorg2r");
    LAPACK_IMPL(dorg2r)(M,
                        N,
                        K,
                        A,
                        LDA,
                        TAU,
                        WORK,
                        INFO);
}

//-- dorgbr --------------------------------------------------------------------
void
LAPACK_DECL(dorgbr)(const char       *VECT,
                    const INTEGER    *M,
                    const INTEGER    *N,
                    const INTEGER    *K,
                    DOUBLE           *A,
                    const INTEGER    *LDA,
                    const DOUBLE     *TAU,
                    DOUBLE           *WORK,
                    const INTEGER    *LWORK,
                    INTEGER          *INFO)
{
    DEBUG_LAPACK_STUB("dorgbr");
    LAPACK_IMPL(dorgbr)(VECT,
                        M,
                        N,
                        K,
                        A,
                        LDA,
                        TAU,
                        WORK,
                        LWORK,
                        INFO);
}

//-- dorghr --------------------------------------------------------------------
void
LAPACK_DECL(dorghr)(const INTEGER    *N,
                    const INTEGER    *ILO,
                    const INTEGER    *IHI,
                    DOUBLE           *A,
                    const INTEGER    *LDA,
                    const DOUBLE     *TAU,
                    DOUBLE           *WORK,
                    const INTEGER    *LWORK,
                    INTEGER          *INFO)
{
    DEBUG_LAPACK_STUB("dorghr");
    LAPACK_IMPL(dorghr)(N,
                        ILO,
                        IHI,
                        A,
                        LDA,
                        TAU,
                        WORK,
                        LWORK,
                        INFO);
}

//-- dorgl2 --------------------------------------------------------------------
void
LAPACK_DECL(dorgl2)(const INTEGER    *M,
                    const INTEGER    *N,
                    const INTEGER    *K,
                    DOUBLE           *A,
                    const INTEGER    *LDA,
                    const DOUBLE     *TAU,
                    DOUBLE           *WORK,
                    INTEGER          *INFO)
{
    DEBUG_LAPACK_STUB("dorgl2");
    LAPACK_IMPL(dorgl2)(M,
                        N,
                        K,
                        A,
                        LDA,
                        TAU,
                        WORK,
                        INFO);
}

//-- dorglq --------------------------------------------------------------------
void
LAPACK_DECL(dorglq)(const INTEGER    *M,
                    const INTEGER    *N,
                    const INTEGER    *K,
                    DOUBLE           *A,
                    const INTEGER    *LDA,
                    const DOUBLE     *TAU,
                    DOUBLE           *WORK,
                    const INTEGER    *LWORK,
                    INTEGER          *INFO)
{
    DEBUG_LAPACK_STUB("dorglq");
    LAPACK_IMPL(dorglq)(M,
                        N,
                        K,
                        A,
                        LDA,
                        TAU,
                        WORK,
                        LWORK,
                        INFO);
}

//-- dorgql --------------------------------------------------------------------
void
LAPACK_DECL(dorgql)(const INTEGER    *M,
                    const INTEGER    *N,
                    const INTEGER    *K,
                    DOUBLE           *A,
                    const INTEGER    *LDA,
                    const DOUBLE     *TAU,
                    DOUBLE           *WORK,
                    const INTEGER    *LWORK,
                    INTEGER          *INFO)
{
    DEBUG_LAPACK_STUB("dorgql");
    LAPACK_IMPL(dorgql)(M,
                        N,
                        K,
                        A,
                        LDA,
                        TAU,
                        WORK,
                        LWORK,
                        INFO);
}

//-- dorgqr --------------------------------------------------------------------
void
LAPACK_DECL(dorgqr)(const INTEGER    *M,
                    const INTEGER    *N,
                    const INTEGER    *K,
                    DOUBLE           *A,
                    const INTEGER    *LDA,
                    const DOUBLE     *TAU,
                    DOUBLE           *WORK,
                    const INTEGER    *LWORK,
                    INTEGER          *INFO)
{
    DEBUG_LAPACK_STUB("dorgqr");
    LAPACK_IMPL(dorgqr)(M,
                        N,
                        K,
                        A,
                        LDA,
                        TAU,
                        WORK,
                        LWORK,
                        INFO);
}

//-- dorgr2 --------------------------------------------------------------------
void
LAPACK_DECL(dorgr2)(const INTEGER    *M,
                    const INTEGER    *N,
                    const INTEGER    *K,
                    DOUBLE           *A,
                    const INTEGER    *LDA,
                    const DOUBLE     *TAU,
                    DOUBLE           *WORK,
                    INTEGER          *INFO)
{
    DEBUG_LAPACK_STUB("dorgr2");
    LAPACK_IMPL(dorgr2)(M,
                        N,
                        K,
                        A,
                        LDA,
                        TAU,
                        WORK,
                        INFO);
}

//-- dorgrq --------------------------------------------------------------------
void
LAPACK_DECL(dorgrq)(const INTEGER    *M,
                    const INTEGER    *N,
                    const INTEGER    *K,
                    DOUBLE           *A,
                    const INTEGER    *LDA,
                    const DOUBLE     *TAU,
                    DOUBLE           *WORK,
                    const INTEGER    *LWORK,
                    INTEGER          *INFO)
{
    DEBUG_LAPACK_STUB("dorgrq");
    LAPACK_IMPL(dorgrq)(M,
                        N,
                        K,
                        A,
                        LDA,
                        TAU,
                        WORK,
                        LWORK,
                        INFO);
}

//-- dorgtr --------------------------------------------------------------------
void
LAPACK_DECL(dorgtr)(const char       *UPLO,
                    const INTEGER    *N,
                    DOUBLE           *A,
                    const INTEGER    *LDA,
                    const DOUBLE     *TAU,
                    DOUBLE           *WORK,
                    const INTEGER    *LWORK,
                    INTEGER          *INFO)
{
    DEBUG_LAPACK_STUB("dorgtr");
    LAPACK_IMPL(dorgtr)(UPLO,
                        N,
                        A,
                        LDA,
                        TAU,
                        WORK,
                        LWORK,
                        INFO);
}

//-- dorm2l --------------------------------------------------------------------
void
LAPACK_DECL(dorm2l)(const char       *SIDE,
                    const char       *TRANS,
                    const INTEGER    *M,
                    const INTEGER    *N,
                    const INTEGER    *K,
                    const DOUBLE     *A,
                    const INTEGER    *LDA,
                    const DOUBLE     *TAU,
                    DOUBLE           *C,
                    const INTEGER    *LDC,
                    DOUBLE           *WORK,
                    INTEGER          *INFO)
{
    DEBUG_LAPACK_STUB("dorm2l");
    LAPACK_IMPL(dorm2l)(SIDE,
                        TRANS,
                        M,
                        N,
                        K,
                        A,
                        LDA,
                        TAU,
                        C,
                        LDC,
                        WORK,
                        INFO);
}

//-- dorm2r --------------------------------------------------------------------
void
LAPACK_DECL(dorm2r)(const char       *SIDE,
                    const char       *TRANS,
                    const INTEGER    *M,
                    const INTEGER    *N,
                    const INTEGER    *K,
                    const DOUBLE     *A,
                    const INTEGER    *LDA,
                    const DOUBLE     *TAU,
                    DOUBLE           *C,
                    const INTEGER    *LDC,
                    DOUBLE           *WORK,
                    INTEGER          *INFO)
{
    DEBUG_LAPACK_STUB("dorm2r");
    LAPACK_IMPL(dorm2r)(SIDE,
                        TRANS,
                        M,
                        N,
                        K,
                        A,
                        LDA,
                        TAU,
                        C,
                        LDC,
                        WORK,
                        INFO);
}

//-- dormbr --------------------------------------------------------------------
void
LAPACK_DECL(dormbr)(const char       *VECT,
                    const char       *SIDE,
                    const char       *TRANS,
                    const INTEGER    *M,
                    const INTEGER    *N,
                    const INTEGER    *K,
                    const DOUBLE     *A,
                    const INTEGER    *LDA,
                    const DOUBLE     *TAU,
                    DOUBLE           *C,
                    const INTEGER    *LDC,
                    DOUBLE           *WORK,
                    const INTEGER    *LWORK,
                    INTEGER          *INFO)
{
    DEBUG_LAPACK_STUB("dormbr");
    LAPACK_IMPL(dormbr)(VECT,
                        SIDE,
                        TRANS,
                        M,
                        N,
                        K,
                        A,
                        LDA,
                        TAU,
                        C,
                        LDC,
                        WORK,
                        LWORK,
                        INFO);
}

//-- dormhr --------------------------------------------------------------------
void
LAPACK_DECL(dormhr)(const char       *SIDE,
                    const char       *TRANS,
                    const INTEGER    *M,
                    const INTEGER    *N,
                    const INTEGER    *ILO,
                    const INTEGER    *IHI,
                    const DOUBLE     *A,
                    const INTEGER    *LDA,
                    const DOUBLE     *TAU,
                    DOUBLE           *C,
                    const INTEGER    *LDC,
                    DOUBLE           *WORK,
                    const INTEGER    *LWORK,
                    INTEGER          *INFO)
{
    DEBUG_LAPACK_STUB("dormhr");
    LAPACK_IMPL(dormhr)(SIDE,
                        TRANS,
                        M,
                        N,
                        ILO,
                        IHI,
                        A,
                        LDA,
                        TAU,
                        C,
                        LDC,
                        WORK,
                        LWORK,
                        INFO);
}

//-- dorml2 --------------------------------------------------------------------
void
LAPACK_DECL(dorml2)(const char       *SIDE,
                    const char       *TRANS,
                    const INTEGER    *M,
                    const INTEGER    *N,
                    const INTEGER    *K,
                    const DOUBLE     *A,
                    const INTEGER    *LDA,
                    const DOUBLE     *TAU,
                    DOUBLE           *C,
                    const INTEGER    *LDC,
                    DOUBLE           *WORK,
                    INTEGER          *INFO)
{
    DEBUG_LAPACK_STUB("dorml2");
    LAPACK_IMPL(dorml2)(SIDE,
                        TRANS,
                        M,
                        N,
                        K,
                        A,
                        LDA,
                        TAU,
                        C,
                        LDC,
                        WORK,
                        INFO);
}

//-- dormlq --------------------------------------------------------------------
void
LAPACK_DECL(dormlq)(const char       *SIDE,
                    const char       *TRANS,
                    const INTEGER    *M,
                    const INTEGER    *N,
                    const INTEGER    *K,
                    const DOUBLE     *A,
                    const INTEGER    *LDA,
                    const DOUBLE     *TAU,
                    DOUBLE           *C,
                    const INTEGER    *LDC,
                    DOUBLE           *WORK,
                    const INTEGER    *LWORK,
                    INTEGER          *INFO)
{
    DEBUG_LAPACK_STUB("dormlq");
    LAPACK_IMPL(dormlq)(SIDE,
                        TRANS,
                        M,
                        N,
                        K,
                        A,
                        LDA,
                        TAU,
                        C,
                        LDC,
                        WORK,
                        LWORK,
                        INFO);
}

//-- dormql --------------------------------------------------------------------
void
LAPACK_DECL(dormql)(const char       *SIDE,
                    const char       *TRANS,
                    const INTEGER    *M,
                    const INTEGER    *N,
                    const INTEGER    *K,
                    const DOUBLE     *A,
                    const INTEGER    *LDA,
                    const DOUBLE     *TAU,
                    DOUBLE           *C,
                    const INTEGER    *LDC,
                    DOUBLE           *WORK,
                    const INTEGER    *LWORK,
                    INTEGER          *INFO)
{
    DEBUG_LAPACK_STUB("dormql");
    LAPACK_IMPL(dormql)(SIDE,
                        TRANS,
                        M,
                        N,
                        K,
                        A,
                        LDA,
                        TAU,
                        C,
                        LDC,
                        WORK,
                        LWORK,
                        INFO);
}

//-- dormqr --------------------------------------------------------------------
void
LAPACK_DECL(dormqr)(const char       *SIDE,
                    const char       *TRANS,
                    const INTEGER    *M,
                    const INTEGER    *N,
                    const INTEGER    *K,
                    const DOUBLE     *A,
                    const INTEGER    *LDA,
                    const DOUBLE     *TAU,
                    DOUBLE           *C,
                    const INTEGER    *LDC,
                    DOUBLE           *WORK,
                    const INTEGER    *LWORK,
                    INTEGER          *INFO)
{
    DEBUG_LAPACK_STUB("dormqr");
    LAPACK_IMPL(dormqr)(SIDE,
                        TRANS,
                        M,
                        N,
                        K,
                        A,
                        LDA,
                        TAU,
                        C,
                        LDC,
                        WORK,
                        LWORK,
                        INFO);
}

//-- dormr2 --------------------------------------------------------------------
void
LAPACK_DECL(dormr2)(const char       *SIDE,
                    const char       *TRANS,
                    const INTEGER    *M,
                    const INTEGER    *N,
                    const INTEGER    *K,
                    const DOUBLE     *A,
                    const INTEGER    *LDA,
                    const DOUBLE     *TAU,
                    DOUBLE           *C,
                    const INTEGER    *LDC,
                    DOUBLE           *WORK,
                    INTEGER          *INFO)
{
    DEBUG_LAPACK_STUB("dormr2");
    LAPACK_IMPL(dormr2)(SIDE,
                        TRANS,
                        M,
                        N,
                        K,
                        A,
                        LDA,
                        TAU,
                        C,
                        LDC,
                        WORK,
                        INFO);
}

//-- dormr3 --------------------------------------------------------------------
void
LAPACK_DECL(dormr3)(const char       *SIDE,
                    const char       *TRANS,
                    const INTEGER    *M,
                    const INTEGER    *N,
                    const INTEGER    *K,
                    const INTEGER    *L,
                    const DOUBLE     *A,
                    const INTEGER    *LDA,
                    const DOUBLE     *TAU,
                    DOUBLE           *C,
                    const INTEGER    *LDC,
                    DOUBLE           *WORK,
                    INTEGER          *INFO)
{
    DEBUG_LAPACK_STUB("dormr3");
    LAPACK_IMPL(dormr3)(SIDE,
                        TRANS,
                        M,
                        N,
                        K,
                        L,
                        A,
                        LDA,
                        TAU,
                        C,
                        LDC,
                        WORK,
                        INFO);
}

//-- dormrq --------------------------------------------------------------------
void
LAPACK_DECL(dormrq)(const char       *SIDE,
                    const char       *TRANS,
                    const INTEGER    *M,
                    const INTEGER    *N,
                    const INTEGER    *K,
                    const DOUBLE     *A,
                    const INTEGER    *LDA,
                    const DOUBLE     *TAU,
                    DOUBLE           *C,
                    const INTEGER    *LDC,
                    DOUBLE           *WORK,
                    const INTEGER    *LWORK,
                    INTEGER          *INFO)
{
    DEBUG_LAPACK_STUB("dormrq");
    LAPACK_IMPL(dormrq)(SIDE,
                        TRANS,
                        M,
                        N,
                        K,
                        A,
                        LDA,
                        TAU,
                        C,
                        LDC,
                        WORK,
                        LWORK,
                        INFO);
}

//-- dormrz --------------------------------------------------------------------
void
LAPACK_DECL(dormrz)(const char       *SIDE,
                    const char       *TRANS,
                    const INTEGER    *M,
                    const INTEGER    *N,
                    const INTEGER    *K,
                    const INTEGER    *L,
                    const DOUBLE     *A,
                    const INTEGER    *LDA,
                    const DOUBLE     *TAU,
                    DOUBLE           *C,
                    const INTEGER    *LDC,
                    DOUBLE           *WORK,
                    const INTEGER    *LWORK,
                    INTEGER          *INFO)
{
    DEBUG_LAPACK_STUB("dormrz");
    LAPACK_IMPL(dormrz)(SIDE,
                        TRANS,
                        M,
                        N,
                        K,
                        L,
                        A,
                        LDA,
                        TAU,
                        C,
                        LDC,
                        WORK,
                        LWORK,
                        INFO);
}

//-- dormtr --------------------------------------------------------------------
void
LAPACK_DECL(dormtr)(const char       *SIDE,
                    const char       *UPLO,
                    const char       *TRANS,
                    const INTEGER    *M,
                    const INTEGER    *N,
                    const DOUBLE     *A,
                    const INTEGER    *LDA,
                    const DOUBLE     *TAU,
                    DOUBLE           *C,
                    const INTEGER    *LDC,
                    DOUBLE           *WORK,
                    const INTEGER    *LWORK,
                    INTEGER          *INFO)
{
    DEBUG_LAPACK_STUB("dormtr");
    LAPACK_IMPL(dormtr)(SIDE,
                        UPLO,
                        TRANS,
                        M,
                        N,
                        A,
                        LDA,
                        TAU,
                        C,
                        LDC,
                        WORK,
                        LWORK,
                        INFO);
}

//-- dpbcon --------------------------------------------------------------------
void
LAPACK_DECL(dpbcon)(const char       *UPLO,
                    const INTEGER    *N,
                    const INTEGER    *KD,
                    const DOUBLE     *AB,
                    const INTEGER    *LDAB,
                    const DOUBLE     *ANORM,
                    DOUBLE           *RCOND,
                    DOUBLE           *WORK,
                    INTEGER          *IWORK,
                    INTEGER          *INFO)
{
    DEBUG_LAPACK_STUB("dpbcon");
    LAPACK_IMPL(dpbcon)(UPLO,
                        N,
                        KD,
                        AB,
                        LDAB,
                        ANORM,
                        RCOND,
                        WORK,
                        IWORK,
                        INFO);
}

//-- dpbequ --------------------------------------------------------------------
void
LAPACK_DECL(dpbequ)(const char       *UPLO,
                    const INTEGER    *N,
                    const INTEGER    *KD,
                    const DOUBLE     *AB,
                    const INTEGER    *LDAB,
                    DOUBLE           *S,
                    DOUBLE           *SCOND,
                    DOUBLE           *AMAX,
                    INTEGER          *INFO)
{
    DEBUG_LAPACK_STUB("dpbequ");
    LAPACK_IMPL(dpbequ)(UPLO,
                        N,
                        KD,
                        AB,
                        LDAB,
                        S,
                        SCOND,
                        AMAX,
                        INFO);
}

//-- dpbrfs --------------------------------------------------------------------
void
LAPACK_DECL(dpbrfs)(const char       *UPLO,
                    const INTEGER    *N,
                    const INTEGER    *KD,
                    const INTEGER    *NRHS,
                    const DOUBLE     *AB,
                    const INTEGER    *LDAB,
                    const DOUBLE     *AFB,
                    const INTEGER    *LDAFB,
                    const DOUBLE     *B,
                    const INTEGER    *LDB,
                    DOUBLE           *X,
                    const INTEGER    *LDX,
                    DOUBLE           *FERR,
                    DOUBLE           *BERR,
                    DOUBLE           *WORK,
                    INTEGER          *IWORK,
                    INTEGER          *INFO)
{
    DEBUG_LAPACK_STUB("dpbrfs");
    LAPACK_IMPL(dpbrfs)(UPLO,
                        N,
                        KD,
                        NRHS,
                        AB,
                        LDAB,
                        AFB,
                        LDAFB,
                        B,
                        LDB,
                        X,
                        LDX,
                        FERR,
                        BERR,
                        WORK,
                        IWORK,
                        INFO);
}

//-- dpbstf --------------------------------------------------------------------
void
LAPACK_DECL(dpbstf)(const char       *UPLO,
                    const INTEGER    *N,
                    const INTEGER    *KD,
                    DOUBLE           *AB,
                    const INTEGER    *LDAB,
                    INTEGER          *INFO)
{
    DEBUG_LAPACK_STUB("dpbstf");
    LAPACK_IMPL(dpbstf)(UPLO,
                        N,
                        KD,
                        AB,
                        LDAB,
                        INFO);
}

//-- dpbsv ---------------------------------------------------------------------
void
LAPACK_DECL(dpbsv)(const char           *UPLO,
                   const INTEGER        *N,
                   const INTEGER        *KD,
                   const INTEGER        *NRHS,
                   DOUBLE               *AB,
                   const INTEGER        *LDAB,
                   DOUBLE               *B,
                   const INTEGER        *LDB,
                   INTEGER              *INFO)
{
    DEBUG_LAPACK_STUB("dpbsv");
    LAPACK_IMPL(dpbsv)(UPLO,
                       N,
                       KD,
                       NRHS,
                       AB,
                       LDAB,
                       B,
                       LDB,
                       INFO);
}

//-- dpbsvx --------------------------------------------------------------------
void
LAPACK_DECL(dpbsvx)(const char       *FACT,
                    const char       *UPLO,
                    const INTEGER    *N,
                    const INTEGER    *KD,
                    const INTEGER    *NRHS,
                    DOUBLE           *AB,
                    const INTEGER    *LDAB,
                    DOUBLE           *AFB,
                    const INTEGER    *LDAFB,
                    char             *EQUED,
                    DOUBLE           *S,
                    DOUBLE           *B,
                    const INTEGER    *LDB,
                    DOUBLE           *X,
                    const INTEGER    *LDX,
                    DOUBLE           *RCOND,
                    DOUBLE           *FERR,
                    DOUBLE           *BERR,
                    DOUBLE           *WORK,
                    INTEGER          *IWORK,
                    INTEGER          *INFO)
{
    DEBUG_LAPACK_STUB("dpbsvx");
    LAPACK_IMPL(dpbsvx)(FACT,
                        UPLO,
                        N,
                        KD,
                        NRHS,
                        AB,
                        LDAB,
                        AFB,
                        LDAFB,
                        EQUED,
                        S,
                        B,
                        LDB,
                        X,
                        LDX,
                        RCOND,
                        FERR,
                        BERR,
                        WORK,
                        IWORK,
                        INFO);
}

//-- dpbtf2 --------------------------------------------------------------------
void
LAPACK_DECL(dpbtf2)(const char       *UPLO,
                    const INTEGER    *N,
                    const INTEGER    *KD,
                    DOUBLE           *AB,
                    const INTEGER    *LDAB,
                    INTEGER          *INFO)
{
    DEBUG_LAPACK_STUB("dpbtf2");
    LAPACK_IMPL(dpbtf2)(UPLO,
                        N,
                        KD,
                        AB,
                        LDAB,
                        INFO);
}

//-- dpbtrf --------------------------------------------------------------------
void
LAPACK_DECL(dpbtrf)(const char       *UPLO,
                    const INTEGER    *N,
                    const INTEGER    *KD,
                    DOUBLE           *AB,
                    const INTEGER    *LDAB,
                    INTEGER          *INFO)
{
    DEBUG_LAPACK_STUB("dpbtrf");
    LAPACK_IMPL(dpbtrf)(UPLO,
                        N,
                        KD,
                        AB,
                        LDAB,
                        INFO);
}

//-- dpbtrs --------------------------------------------------------------------
void
LAPACK_DECL(dpbtrs)(const char       *UPLO,
                    const INTEGER    *N,
                    const INTEGER    *KD,
                    const INTEGER    *NRHS,
                    const DOUBLE     *AB,
                    const INTEGER    *LDAB,
                    DOUBLE           *B,
                    const INTEGER    *LDB,
                    INTEGER          *INFO)
{
    DEBUG_LAPACK_STUB("dpbtrs");
    LAPACK_IMPL(dpbtrs)(UPLO,
                        N,
                        KD,
                        NRHS,
                        AB,
                        LDAB,
                        B,
                        LDB,
                        INFO);
}

//-- dpftrf --------------------------------------------------------------------
void
LAPACK_DECL(dpftrf)(const char       *TRANSR,
                    const char       *UPLO,
                    const INTEGER    *N,
                    DOUBLE           *A,
                    INTEGER          *INFO)
{
    DEBUG_LAPACK_STUB("dpftrf");
    LAPACK_IMPL(dpftrf)(TRANSR,
                        UPLO,
                        N,
                        A,
                        INFO);
}

//-- dpftri --------------------------------------------------------------------
void
LAPACK_DECL(dpftri)(const char       *TRANSR,
                    const char       *UPLO,
                    const INTEGER    *N,
                    DOUBLE           *A,
                    INTEGER          *INFO)
{
    DEBUG_LAPACK_STUB("dpftri");
    LAPACK_IMPL(dpftri)(TRANSR,
                        UPLO,
                        N,
                        A,
                        INFO);
}

//-- dpftrs --------------------------------------------------------------------
void
LAPACK_DECL(dpftrs)(const char       *TRANSR,
                    const char       *UPLO,
                    const INTEGER    *N,
                    const INTEGER    *NRHS,
                    const DOUBLE     *A,
                    DOUBLE           *B,
                    const INTEGER    *LDB,
                    INTEGER          *INFO)
{
    DEBUG_LAPACK_STUB("dpftrs");
    LAPACK_IMPL(dpftrs)(TRANSR,
                        UPLO,
                        N,
                        NRHS,
                        A,
                        B,
                        LDB,
                        INFO);
}

//-- dpocon --------------------------------------------------------------------
void
LAPACK_DECL(dpocon)(const char       *UPLO,
                    const INTEGER    *N,
                    const DOUBLE     *A,
                    const INTEGER    *LDA,
                    const DOUBLE     *ANORM,
                    DOUBLE           *RCOND,
                    DOUBLE           *WORK,
                    INTEGER          *IWORK,
                    INTEGER          *INFO)
{
    DEBUG_LAPACK_STUB("dpocon");
    LAPACK_IMPL(dpocon)(UPLO,
                        N,
                        A,
                        LDA,
                        ANORM,
                        RCOND,
                        WORK,
                        IWORK,
                        INFO);
}

//-- dpoequ --------------------------------------------------------------------
void
LAPACK_DECL(dpoequ)(const INTEGER    *N,
                    const DOUBLE     *A,
                    const INTEGER    *LDA,
                    DOUBLE           *S,
                    DOUBLE           *SCOND,
                    DOUBLE           *AMAX,
                    INTEGER          *INFO)
{
    DEBUG_LAPACK_STUB("dpoequ");
    LAPACK_IMPL(dpoequ)(N,
                        A,
                        LDA,
                        S,
                        SCOND,
                        AMAX,
                        INFO);
}

//-- dpoequb -------------------------------------------------------------------
void
LAPACK_DECL(dpoequb)(const INTEGER    *N,
                     const DOUBLE     *A,
                     const INTEGER    *LDA,
                     DOUBLE           *S,
                     DOUBLE           *SCOND,
                     DOUBLE           *AMAX,
                     INTEGER          *INFO)
{
    DEBUG_LAPACK_STUB("dpoequb");
    LAPACK_IMPL(dpoequb)(N,
                         A,
                         LDA,
                         S,
                         SCOND,
                         AMAX,
                         INFO);
}

//-- dporfs --------------------------------------------------------------------
void
LAPACK_DECL(dporfs)(const char       *UPLO,
                    const INTEGER    *N,
                    const INTEGER    *NRHS,
                    const DOUBLE     *A,
                    const INTEGER    *LDA,
                    const DOUBLE     *AF,
                    const INTEGER    *LDAF,
                    const DOUBLE     *B,
                    const INTEGER    *LDB,
                    DOUBLE           *X,
                    const INTEGER    *LDX,
                    DOUBLE           *FERR,
                    DOUBLE           *BERR,
                    DOUBLE           *WORK,
                    INTEGER          *IWORK,
                    INTEGER          *INFO)
{
    DEBUG_LAPACK_STUB("dporfs");
    LAPACK_IMPL(dporfs)(UPLO,
                        N,
                        NRHS,
                        A,
                        LDA,
                        AF,
                        LDAF,
                        B,
                        LDB,
                        X,
                        LDX,
                        FERR,
                        BERR,
                        WORK,
                        IWORK,
                        INFO);
}

//-- dporfsx -------------------------------------------------------------------
void
LAPACK_DECL(dporfsx)(const char       *UPLO,
                     const char       *EQUED,
                     const INTEGER    *N,
                     const INTEGER    *NRHS,
                     const DOUBLE     *A,
                     const INTEGER    *LDA,
                     const DOUBLE     *AF,
                     const INTEGER    *LDAF,
                     DOUBLE           *S,
                     const DOUBLE     *B,
                     const INTEGER    *LDB,
                     DOUBLE           *X,
                     const INTEGER    *LDX,
                     DOUBLE           *RCOND,
                     DOUBLE           *BERR,
                     const INTEGER    *N_ERR_BNDS,
                     DOUBLE           *ERR_BNDS_NORM,
                     DOUBLE           *ERR_BNDS_COMP,
                     const INTEGER    *NPARAMS,
                     DOUBLE           *PARAMS,
                     DOUBLE           *WORK,
                     INTEGER          *IWORK,
                     INTEGER          *INFO)
{
    DEBUG_LAPACK_STUB("dporfsx");
    LAPACK_IMPL(dporfsx)(UPLO,
                         EQUED,
                         N,
                         NRHS,
                         A,
                         LDA,
                         AF,
                         LDAF,
                         S,
                         B,
                         LDB,
                         X,
                         LDX,
                         RCOND,
                         BERR,
                         N_ERR_BNDS,
                         ERR_BNDS_NORM,
                         ERR_BNDS_COMP,
                         NPARAMS,
                         PARAMS,
                         WORK,
                         IWORK,
                         INFO);
}

//-- dposv ---------------------------------------------------------------------
void
LAPACK_DECL(dposv)(const char           *UPLO,
                   const INTEGER        *N,
                   const INTEGER        *NRHS,
                   DOUBLE               *A,
                   const INTEGER        *LDA,
                   DOUBLE               *B,
                   const INTEGER        *LDB,
                   INTEGER              *INFO)
{
    DEBUG_LAPACK_STUB("dposv");
    LAPACK_IMPL(dposv)(UPLO,
                       N,
                       NRHS,
                       A,
                       LDA,
                       B,
                       LDB,
                       INFO);
}

//-- dposvx --------------------------------------------------------------------
void
LAPACK_DECL(dposvx)(const char       *FACT,
                    const char       *UPLO,
                    const INTEGER    *N,
                    const INTEGER    *NRHS,
                    DOUBLE           *A,
                    const INTEGER    *LDA,
                    DOUBLE           *AF,
                    const INTEGER    *LDAF,
                    char             *EQUED,
                    DOUBLE           *S,
                    DOUBLE           *B,
                    const INTEGER    *LDB,
                    DOUBLE           *X,
                    const INTEGER    *LDX,
                    DOUBLE           *RCOND,
                    DOUBLE           *FERR,
                    DOUBLE           *BERR,
                    DOUBLE           *WORK,
                    INTEGER          *IWORK,
                    INTEGER          *INFO)
{
    DEBUG_LAPACK_STUB("dposvx");
    LAPACK_IMPL(dposvx)(FACT,
                        UPLO,
                        N,
                        NRHS,
                        A,
                        LDA,
                        AF,
                        LDAF,
                        EQUED,
                        S,
                        B,
                        LDB,
                        X,
                        LDX,
                        RCOND,
                        FERR,
                        BERR,
                        WORK,
                        IWORK,
                        INFO);
}

//-- dposvxx -------------------------------------------------------------------
void
LAPACK_DECL(dposvxx)(const char       *FACT,
                     const char       *UPLO,
                     const INTEGER    *N,
                     const INTEGER    *NRHS,
                     DOUBLE           *A,
                     const INTEGER    *LDA,
                     DOUBLE           *AF,
                     const INTEGER    *LDAF,
                     char             *EQUED,
                     DOUBLE           *S,
                     DOUBLE           *B,
                     const INTEGER    *LDB,
                     DOUBLE           *X,
                     const INTEGER    *LDX,
                     DOUBLE           *RCOND,
                     DOUBLE           *RPVGRW,
                     DOUBLE           *BERR,
                     const INTEGER    *N_ERR_BNDS,
                     DOUBLE           *ERR_BNDS_NORM,
                     DOUBLE           *ERR_BNDS_COMP,
                     const INTEGER    *NPARAMS,
                     DOUBLE           *PARAMS,
                     DOUBLE           *WORK,
                     INTEGER          *IWORK,
                     INTEGER          *INFO)
{
    DEBUG_LAPACK_STUB("dposvxx");
    LAPACK_IMPL(dposvxx)(FACT,
                         UPLO,
                         N,
                         NRHS,
                         A,
                         LDA,
                         AF,
                         LDAF,
                         EQUED,
                         S,
                         B,
                         LDB,
                         X,
                         LDX,
                         RCOND,
                         RPVGRW,
                         BERR,
                         N_ERR_BNDS,
                         ERR_BNDS_NORM,
                         ERR_BNDS_COMP,
                         NPARAMS,
                         PARAMS,
                         WORK,
                         IWORK,
                         INFO);
}

//-- dpotf2 --------------------------------------------------------------------
void
LAPACK_DECL(dpotf2)(const char       *UPLO,
                    const INTEGER    *N,
                    DOUBLE           *A,
                    const INTEGER    *LDA,
                    INTEGER          *INFO)
{
    DEBUG_LAPACK_STUB("dpotf2");
    LAPACK_IMPL(dpotf2)(UPLO,
                        N,
                        A,
                        LDA,
                        INFO);
}

//-- dpotrf --------------------------------------------------------------------
void
LAPACK_DECL(dpotrf)(const char       *UPLO,
                    const INTEGER    *N,
                    DOUBLE           *A,
                    const INTEGER    *LDA,
                    INTEGER          *INFO)
{
    DEBUG_LAPACK_STUB("dpotrf");
    LAPACK_IMPL(dpotrf)(UPLO,
                        N,
                        A,
                        LDA,
                        INFO);
}

//-- dpotri --------------------------------------------------------------------
void
LAPACK_DECL(dpotri)(const char       *UPLO,
                    const INTEGER    *N,
                    DOUBLE           *A,
                    const INTEGER    *LDA,
                    INTEGER          *INFO)
{
    DEBUG_LAPACK_STUB("dpotri");
    LAPACK_IMPL(dpotri)(UPLO,
                        N,
                        A,
                        LDA,
                        INFO);
}

//-- dpotrs --------------------------------------------------------------------
void
LAPACK_DECL(dpotrs)(const char       *UPLO,
                    const INTEGER    *N,
                    const INTEGER    *NRHS,
                    const DOUBLE     *A,
                    const INTEGER    *LDA,
                    DOUBLE           *B,
                    const INTEGER    *LDB,
                    INTEGER          *INFO)
{
    DEBUG_LAPACK_STUB("dpotrs");
    LAPACK_IMPL(dpotrs)(UPLO,
                        N,
                        NRHS,
                        A,
                        LDA,
                        B,
                        LDB,
                        INFO);
}

//-- dppcon --------------------------------------------------------------------
void
LAPACK_DECL(dppcon)(const char       *UPLO,
                    const INTEGER    *N,
                    const DOUBLE     *AP,
                    const DOUBLE     *ANORM,
                    DOUBLE           *RCOND,
                    DOUBLE           *WORK,
                    INTEGER          *IWORK,
                    INTEGER          *INFO)
{
    DEBUG_LAPACK_STUB("dppcon");
    LAPACK_IMPL(dppcon)(UPLO,
                        N,
                        AP,
                        ANORM,
                        RCOND,
                        WORK,
                        IWORK,
                        INFO);
}

//-- dppequ --------------------------------------------------------------------
void
LAPACK_DECL(dppequ)(const char       *UPLO,
                    const INTEGER    *N,
                    const DOUBLE     *AP,
                    DOUBLE           *S,
                    DOUBLE           *SCOND,
                    DOUBLE           *AMAX,
                    INTEGER          *INFO)
{
    DEBUG_LAPACK_STUB("dppequ");
    LAPACK_IMPL(dppequ)(UPLO,
                        N,
                        AP,
                        S,
                        SCOND,
                        AMAX,
                        INFO);
}

//-- dpprfs --------------------------------------------------------------------
void
LAPACK_DECL(dpprfs)(const char       *UPLO,
                    const INTEGER    *N,
                    const INTEGER    *NRHS,
                    const DOUBLE     *AP,
                    const DOUBLE     *AFP,
                    const DOUBLE     *B,
                    const INTEGER    *LDB,
                    DOUBLE           *X,
                    const INTEGER    *LDX,
                    DOUBLE           *FERR,
                    DOUBLE           *BERR,
                    DOUBLE           *WORK,
                    INTEGER          *IWORK,
                    INTEGER          *INFO)
{
    DEBUG_LAPACK_STUB("dpprfs");
    LAPACK_IMPL(dpprfs)(UPLO,
                        N,
                        NRHS,
                        AP,
                        AFP,
                        B,
                        LDB,
                        X,
                        LDX,
                        FERR,
                        BERR,
                        WORK,
                        IWORK,
                        INFO);
}

//-- dppsv ---------------------------------------------------------------------
void
LAPACK_DECL(dppsv)(const char           *UPLO,
                   const INTEGER        *N,
                   const INTEGER        *NRHS,
                   DOUBLE               *AP,
                   DOUBLE               *B,
                   const INTEGER        *LDB,
                   INTEGER              *INFO)
{
    DEBUG_LAPACK_STUB("dppsv");
    LAPACK_IMPL(dppsv)(UPLO,
                       N,
                       NRHS,
                       AP,
                       B,
                       LDB,
                       INFO);
}

//-- dppsvx --------------------------------------------------------------------
void
LAPACK_DECL(dppsvx)(const char       *FACT,
                    const char       *UPLO,
                    const INTEGER    *N,
                    const INTEGER    *NRHS,
                    DOUBLE           *AP,
                    DOUBLE           *AFP,
                    char             *EQUED,
                    DOUBLE           *S,
                    DOUBLE           *B,
                    const INTEGER    *LDB,
                    DOUBLE           *X,
                    const INTEGER    *LDX,
                    DOUBLE           *RCOND,
                    DOUBLE           *FERR,
                    DOUBLE           *BERR,
                    DOUBLE           *WORK,
                    INTEGER          *IWORK,
                    INTEGER          *INFO)
{
    DEBUG_LAPACK_STUB("dppsvx");
    LAPACK_IMPL(dppsvx)(FACT,
                        UPLO,
                        N,
                        NRHS,
                        AP,
                        AFP,
                        EQUED,
                        S,
                        B,
                        LDB,
                        X,
                        LDX,
                        RCOND,
                        FERR,
                        BERR,
                        WORK,
                        IWORK,
                        INFO);
}

//-- dpptrf --------------------------------------------------------------------
void
LAPACK_DECL(dpptrf)(const char       *UPLO,
                    const INTEGER    *N,
                    DOUBLE           *AP,
                    INTEGER          *INFO)
{
    DEBUG_LAPACK_STUB("dpptrf");
    LAPACK_IMPL(dpptrf)(UPLO,
                        N,
                        AP,
                        INFO);
}

//-- dpptri --------------------------------------------------------------------
void
LAPACK_DECL(dpptri)(const char       *UPLO,
                    const INTEGER    *N,
                    DOUBLE           *AP,
                    INTEGER          *INFO)
{
    DEBUG_LAPACK_STUB("dpptri");
    LAPACK_IMPL(dpptri)(UPLO,
                        N,
                        AP,
                        INFO);
}

//-- dpptrs --------------------------------------------------------------------
void
LAPACK_DECL(dpptrs)(const char       *UPLO,
                    const INTEGER    *N,
                    const INTEGER    *NRHS,
                    const DOUBLE     *AP,
                    DOUBLE           *B,
                    const INTEGER    *LDB,
                    INTEGER          *INFO)
{
    DEBUG_LAPACK_STUB("dpptrs");
    LAPACK_IMPL(dpptrs)(UPLO,
                        N,
                        NRHS,
                        AP,
                        B,
                        LDB,
                        INFO);
}

//-- dpstf2 --------------------------------------------------------------------
void
LAPACK_DECL(dpstf2)(const char       *UPLO,
                    const INTEGER    *N,
                    DOUBLE           *A,
                    const INTEGER    *LDA,
                    INTEGER          *PIV,
                    INTEGER          *RANK,
                    const DOUBLE     *TOL,
                    DOUBLE           *WORK,
                    INTEGER          *INFO)
{
    DEBUG_LAPACK_STUB("dpstf2");
    LAPACK_IMPL(dpstf2)(UPLO,
                        N,
                        A,
                        LDA,
                        PIV,
                        RANK,
                        TOL,
                        WORK,
                        INFO);
}

//-- dpstrf --------------------------------------------------------------------
void
LAPACK_DECL(dpstrf)(const char       *UPLO,
                    const INTEGER    *N,
                    DOUBLE           *A,
                    const INTEGER    *LDA,
                    INTEGER          *PIV,
                    INTEGER          *RANK,
                    const DOUBLE     *TOL,
                    DOUBLE           *WORK,
                    INTEGER          *INFO)
{
    DEBUG_LAPACK_STUB("dpstrf");
    LAPACK_IMPL(dpstrf)(UPLO,
                        N,
                        A,
                        LDA,
                        PIV,
                        RANK,
                        TOL,
                        WORK,
                        INFO);
}

//-- dptcon --------------------------------------------------------------------
void
LAPACK_DECL(dptcon)(const INTEGER    *N,
                    const DOUBLE     *D,
                    const DOUBLE     *E,
                    const DOUBLE     *ANORM,
                    DOUBLE           *RCOND,
                    DOUBLE           *WORK,
                    INTEGER          *INFO)
{
    DEBUG_LAPACK_STUB("dptcon");
    LAPACK_IMPL(dptcon)(N,
                        D,
                        E,
                        ANORM,
                        RCOND,
                        WORK,
                        INFO);
}

//-- dpteqr --------------------------------------------------------------------
void
LAPACK_DECL(dpteqr)(const char       *COMPZ,
                    const INTEGER    *N,
                    DOUBLE           *D,
                    DOUBLE           *E,
                    DOUBLE           *Z,
                    const INTEGER    *LDZ,
                    DOUBLE           *WORK,
                    INTEGER          *INFO)
{
    DEBUG_LAPACK_STUB("dpteqr");
    LAPACK_IMPL(dpteqr)(COMPZ,
                        N,
                        D,
                        E,
                        Z,
                        LDZ,
                        WORK,
                        INFO);
}

//-- dptrfs --------------------------------------------------------------------
void
LAPACK_DECL(dptrfs)(const INTEGER    *N,
                    const INTEGER    *NRHS,
                    const DOUBLE     *D,
                    const DOUBLE     *E,
                    const DOUBLE     *DF,
                    const DOUBLE     *EF,
                    const DOUBLE     *B,
                    const INTEGER    *LDB,
                    DOUBLE           *X,
                    const INTEGER    *LDX,
                    DOUBLE           *FERR,
                    DOUBLE           *BERR,
                    DOUBLE           *WORK,
                    INTEGER          *INFO)
{
    DEBUG_LAPACK_STUB("dptrfs");
    LAPACK_IMPL(dptrfs)(N,
                        NRHS,
                        D,
                        E,
                        DF,
                        EF,
                        B,
                        LDB,
                        X,
                        LDX,
                        FERR,
                        BERR,
                        WORK,
                        INFO);
}

//-- dptsv ---------------------------------------------------------------------
void
LAPACK_DECL(dptsv)(const INTEGER        *N,
                   const INTEGER        *NRHS,
                   DOUBLE               *D,
                   DOUBLE               *E,
                   DOUBLE               *B,
                   const INTEGER        *LDB,
                   INTEGER              *INFO)
{
    DEBUG_LAPACK_STUB("dptsv");
    LAPACK_IMPL(dptsv)(N,
                       NRHS,
                       D,
                       E,
                       B,
                       LDB,
                       INFO);
}

//-- dptsvx --------------------------------------------------------------------
void
LAPACK_DECL(dptsvx)(const char       *FACT,
                    const INTEGER    *N,
                    const INTEGER    *NRHS,
                    const DOUBLE     *D,
                    const DOUBLE     *E,
                    DOUBLE           *DF,
                    DOUBLE           *EF,
                    const DOUBLE     *B,
                    const INTEGER    *LDB,
                    DOUBLE           *X,
                    const INTEGER    *LDX,
                    DOUBLE           *RCOND,
                    DOUBLE           *FERR,
                    DOUBLE           *BERR,
                    DOUBLE           *WORK,
                    INTEGER          *INFO)
{
    DEBUG_LAPACK_STUB("dptsvx");
    LAPACK_IMPL(dptsvx)(FACT,
                        N,
                        NRHS,
                        D,
                        E,
                        DF,
                        EF,
                        B,
                        LDB,
                        X,
                        LDX,
                        RCOND,
                        FERR,
                        BERR,
                        WORK,
                        INFO);
}

//-- dpttrf --------------------------------------------------------------------
void
LAPACK_DECL(dpttrf)(const INTEGER    *N,
                    DOUBLE           *D,
                    DOUBLE           *E,
                    INTEGER          *INFO)
{
    DEBUG_LAPACK_STUB("dpttrf");
    LAPACK_IMPL(dpttrf)(N,
                        D,
                        E,
                        INFO);
}

//-- dpttrs --------------------------------------------------------------------
void
LAPACK_DECL(dpttrs)(const INTEGER    *N,
                    const INTEGER    *NRHS,
                    const DOUBLE     *D,
                    const DOUBLE     *E,
                    DOUBLE           *B,
                    const INTEGER    *LDB,
                    INTEGER          *INFO)
{
    DEBUG_LAPACK_STUB("dpttrs");
    LAPACK_IMPL(dpttrs)(N,
                        NRHS,
                        D,
                        E,
                        B,
                        LDB,
                        INFO);
}

//-- dptts2 --------------------------------------------------------------------
void
LAPACK_DECL(dptts2)(const INTEGER    *N,
                    const INTEGER    *NRHS,
                    const DOUBLE     *D,
                    const DOUBLE     *E,
                    DOUBLE           *B,
                    const INTEGER    *LDB)
{
    DEBUG_LAPACK_STUB("dptts2");
    LAPACK_IMPL(dptts2)(N,
                        NRHS,
                        D,
                        E,
                        B,
                        LDB);
}

//-- drscl ---------------------------------------------------------------------
void
LAPACK_DECL(drscl)(const INTEGER        *N,
                   const DOUBLE         *SA,
                   DOUBLE               *SX,
                   const INTEGER        *INCX)
{
    DEBUG_LAPACK_STUB("drscl");
    LAPACK_IMPL(drscl)(N,
                       SA,
                       SX,
                       INCX);
}

//-- dsbev ---------------------------------------------------------------------
void
LAPACK_DECL(dsbev)(const char           *JOBZ,
                   const char           *UPLO,
                   const INTEGER        *N,
                   const INTEGER        *KD,
                   DOUBLE               *AB,
                   const INTEGER        *LDAB,
                   DOUBLE               *W,
                   DOUBLE               *Z,
                   const INTEGER        *LDZ,
                   DOUBLE               *WORK,
                   INTEGER              *INFO)
{
    DEBUG_LAPACK_STUB("dsbev");
    LAPACK_IMPL(dsbev)(JOBZ,
                       UPLO,
                       N,
                       KD,
                       AB,
                       LDAB,
                       W,
                       Z,
                       LDZ,
                       WORK,
                       INFO);
}

//-- dsbevd --------------------------------------------------------------------
void
LAPACK_DECL(dsbevd)(const char       *JOBZ,
                    const char       *UPLO,
                    const INTEGER    *N,
                    const INTEGER    *KD,
                    DOUBLE           *AB,
                    const INTEGER    *LDAB,
                    DOUBLE           *W,
                    DOUBLE           *Z,
                    const INTEGER    *LDZ,
                    DOUBLE           *WORK,
                    const INTEGER    *LWORK,
                    INTEGER          *IWORK,
                    const INTEGER    *LIWORK,
                    INTEGER          *INFO)
{
    DEBUG_LAPACK_STUB("dsbevd");
    LAPACK_IMPL(dsbevd)(JOBZ,
                        UPLO,
                        N,
                        KD,
                        AB,
                        LDAB,
                        W,
                        Z,
                        LDZ,
                        WORK,
                        LWORK,
                        IWORK,
                        LIWORK,
                        INFO);
}

//-- dsbevx --------------------------------------------------------------------
void
LAPACK_DECL(dsbevx)(const char       *JOBZ,
                    const char       *RANGE,
                    const char       *UPLO,
                    const INTEGER    *N,
                    const INTEGER    *KD,
                    DOUBLE           *AB,
                    const INTEGER    *LDAB,
                    DOUBLE           *Q,
                    const INTEGER    *LDQ,
                    const DOUBLE     *VL,
                    const DOUBLE     *VU,
                    const INTEGER    *IL,
                    const INTEGER    *IU,
                    const DOUBLE     *ABSTOL,
                    INTEGER          *M,
                    DOUBLE           *W,
                    DOUBLE           *Z,
                    const INTEGER    *LDZ,
                    DOUBLE           *WORK,
                    INTEGER          *IWORK,
                    INTEGER          *IFAIL,
                    INTEGER          *INFO)
{
    DEBUG_LAPACK_STUB("dsbevx");
    LAPACK_IMPL(dsbevx)(JOBZ,
                        RANGE,
                        UPLO,
                        N,
                        KD,
                        AB,
                        LDAB,
                        Q,
                        LDQ,
                        VL,
                        VU,
                        IL,
                        IU,
                        ABSTOL,
                        M,
                        W,
                        Z,
                        LDZ,
                        WORK,
                        IWORK,
                        IFAIL,
                        INFO);
}

//-- dsbgst --------------------------------------------------------------------
void
LAPACK_DECL(dsbgst)(const char       *VECT,
                    const char       *UPLO,
                    const INTEGER    *N,
                    const INTEGER    *KA,
                    const INTEGER    *KB,
                    DOUBLE           *AB,
                    const INTEGER    *LDAB,
                    const DOUBLE     *BB,
                    const INTEGER    *LDBB,
                    DOUBLE           *X,
                    const INTEGER    *LDX,
                    DOUBLE           *WORK,
                    INTEGER          *INFO)
{
    DEBUG_LAPACK_STUB("dsbgst");
    LAPACK_IMPL(dsbgst)(VECT,
                        UPLO,
                        N,
                        KA,
                        KB,
                        AB,
                        LDAB,
                        BB,
                        LDBB,
                        X,
                        LDX,
                        WORK,
                        INFO);
}

//-- dsbgv ---------------------------------------------------------------------
void
LAPACK_DECL(dsbgv)(const char           *JOBZ,
                   const char           *UPLO,
                   const INTEGER        *N,
                   const INTEGER        *KA,
                   const INTEGER        *KB,
                   DOUBLE               *AB,
                   const INTEGER        *LDAB,
                   DOUBLE               *BB,
                   const INTEGER        *LDBB,
                   DOUBLE               *W,
                   DOUBLE               *Z,
                   const INTEGER        *LDZ,
                   DOUBLE               *WORK,
                   INTEGER              *INFO)
{
    DEBUG_LAPACK_STUB("dsbgv");
    LAPACK_IMPL(dsbgv)(JOBZ,
                       UPLO,
                       N,
                       KA,
                       KB,
                       AB,
                       LDAB,
                       BB,
                       LDBB,
                       W,
                       Z,
                       LDZ,
                       WORK,
                       INFO);
}

//-- dsbgvd --------------------------------------------------------------------
void
LAPACK_DECL(dsbgvd)(const char       *JOBZ,
                    const char       *UPLO,
                    const INTEGER    *N,
                    const INTEGER    *KA,
                    const INTEGER    *KB,
                    DOUBLE           *AB,
                    const INTEGER    *LDAB,
                    DOUBLE           *BB,
                    const INTEGER    *LDBB,
                    DOUBLE           *W,
                    DOUBLE           *Z,
                    const INTEGER    *LDZ,
                    DOUBLE           *WORK,
                    const INTEGER    *LWORK,
                    INTEGER          *IWORK,
                    const INTEGER    *LIWORK,
                    INTEGER          *INFO)
{
    DEBUG_LAPACK_STUB("dsbgvd");
    LAPACK_IMPL(dsbgvd)(JOBZ,
                        UPLO,
                        N,
                        KA,
                        KB,
                        AB,
                        LDAB,
                        BB,
                        LDBB,
                        W,
                        Z,
                        LDZ,
                        WORK,
                        LWORK,
                        IWORK,
                        LIWORK,
                        INFO);
}

//-- dsbgvx --------------------------------------------------------------------
void
LAPACK_DECL(dsbgvx)(const char       *JOBZ,
                    const char       *RANGE,
                    const char       *UPLO,
                    const INTEGER    *N,
                    const INTEGER    *KA,
                    const INTEGER    *KB,
                    DOUBLE           *AB,
                    const INTEGER    *LDAB,
                    DOUBLE           *BB,
                    const INTEGER    *LDBB,
                    DOUBLE           *Q,
                    const INTEGER    *LDQ,
                    const DOUBLE     *VL,
                    const DOUBLE     *VU,
                    const INTEGER    *IL,
                    const INTEGER    *IU,
                    const DOUBLE     *ABSTOL,
                    INTEGER          *M,
                    DOUBLE           *W,
                    DOUBLE           *Z,
                    const INTEGER    *LDZ,
                    DOUBLE           *WORK,
                    INTEGER          *IWORK,
                    INTEGER          *IFAIL,
                    INTEGER          *INFO)
{
    DEBUG_LAPACK_STUB("dsbgvx");
    LAPACK_IMPL(dsbgvx)(JOBZ,
                        RANGE,
                        UPLO,
                        N,
                        KA,
                        KB,
                        AB,
                        LDAB,
                        BB,
                        LDBB,
                        Q,
                        LDQ,
                        VL,
                        VU,
                        IL,
                        IU,
                        ABSTOL,
                        M,
                        W,
                        Z,
                        LDZ,
                        WORK,
                        IWORK,
                        IFAIL,
                        INFO);
}

//-- dsbtrd --------------------------------------------------------------------
void
LAPACK_DECL(dsbtrd)(const char       *VECT,
                    const char       *UPLO,
                    const INTEGER    *N,
                    const INTEGER    *KD,
                    DOUBLE           *AB,
                    const INTEGER    *LDAB,
                    DOUBLE           *D,
                    DOUBLE           *E,
                    DOUBLE           *Q,
                    const INTEGER    *LDQ,
                    DOUBLE           *WORK,
                    INTEGER          *INFO)
{
    DEBUG_LAPACK_STUB("dsbtrd");
    LAPACK_IMPL(dsbtrd)(VECT,
                        UPLO,
                        N,
                        KD,
                        AB,
                        LDAB,
                        D,
                        E,
                        Q,
                        LDQ,
                        WORK,
                        INFO);
}

//-- dsfrk ---------------------------------------------------------------------
void
LAPACK_DECL(dsfrk)(const char           *TRANSR,
                   const char           *UPLO,
                   const char           *TRANS,
                   const INTEGER        *N,
                   const INTEGER        *K,
                   const DOUBLE         *ALPHA,
                   const DOUBLE         *A,
                   const INTEGER        *LDA,
                   const DOUBLE         *BETA,
                   DOUBLE               *C)
{
    DEBUG_LAPACK_STUB("dsfrk");
    LAPACK_IMPL(dsfrk)(TRANSR,
                       UPLO,
                       TRANS,
                       N,
                       K,
                       ALPHA,
                       A,
                       LDA,
                       BETA,
                       C);
}

//-- dsgesv --------------------------------------------------------------------
void
LAPACK_DECL(dsgesv)(const INTEGER    *N,
                    const INTEGER    *NRHS,
                    DOUBLE           *A,
                    const INTEGER    *LDA,
                    INTEGER          *IPIV,
                    const DOUBLE     *B,
                    const INTEGER    *LDB,
                    DOUBLE           *X,
                    const INTEGER    *LDX,
                    DOUBLE           *WORK,
                    FLOAT            *SWORK,
                    INTEGER          *ITER,
                    INTEGER          *INFO)
{
    DEBUG_LAPACK_STUB("dsgesv");
    LAPACK_IMPL(dsgesv)(N,
                        NRHS,
                        A,
                        LDA,
                        IPIV,
                        B,
                        LDB,
                        X,
                        LDX,
                        WORK,
                        SWORK,
                        ITER,
                        INFO);
}

//-- dspcon --------------------------------------------------------------------
void
LAPACK_DECL(dspcon)(const char       *UPLO,
                    const INTEGER    *N,
                    const DOUBLE     *AP,
                    const INTEGER    *IPIV,
                    const DOUBLE     *ANORM,
                    DOUBLE           *RCOND,
                    DOUBLE           *WORK,
                    INTEGER          *IWORK,
                    INTEGER          *INFO)
{
    DEBUG_LAPACK_STUB("dspcon");
    LAPACK_IMPL(dspcon)(UPLO,
                        N,
                        AP,
                        IPIV,
                        ANORM,
                        RCOND,
                        WORK,
                        IWORK,
                        INFO);
}

//-- dspev ---------------------------------------------------------------------
void
LAPACK_DECL(dspev)(const char           *JOBZ,
                   const char           *UPLO,
                   const INTEGER        *N,
                   DOUBLE               *AP,
                   DOUBLE               *W,
                   DOUBLE               *Z,
                   const INTEGER        *LDZ,
                   DOUBLE               *WORK,
                   INTEGER              *INFO)
{
    DEBUG_LAPACK_STUB("dspev");
    LAPACK_IMPL(dspev)(JOBZ,
                       UPLO,
                       N,
                       AP,
                       W,
                       Z,
                       LDZ,
                       WORK,
                       INFO);
}

//-- dspevd --------------------------------------------------------------------
void
LAPACK_DECL(dspevd)(const char       *JOBZ,
                    const char       *UPLO,
                    const INTEGER    *N,
                    DOUBLE           *AP,
                    DOUBLE           *W,
                    DOUBLE           *Z,
                    const INTEGER    *LDZ,
                    DOUBLE           *WORK,
                    const INTEGER    *LWORK,
                    INTEGER          *IWORK,
                    const INTEGER    *LIWORK,
                    INTEGER          *INFO)
{
    DEBUG_LAPACK_STUB("dspevd");
    LAPACK_IMPL(dspevd)(JOBZ,
                        UPLO,
                        N,
                        AP,
                        W,
                        Z,
                        LDZ,
                        WORK,
                        LWORK,
                        IWORK,
                        LIWORK,
                        INFO);
}

//-- dspevx --------------------------------------------------------------------
void
LAPACK_DECL(dspevx)(const char       *JOBZ,
                    const char       *RANGE,
                    const char       *UPLO,
                    const INTEGER    *N,
                    DOUBLE           *AP,
                    const DOUBLE     *VL,
                    const DOUBLE     *VU,
                    const INTEGER    *IL,
                    const INTEGER    *IU,
                    const DOUBLE     *ABSTOL,
                    INTEGER          *M,
                    DOUBLE           *W,
                    DOUBLE           *Z,
                    const INTEGER    *LDZ,
                    DOUBLE           *WORK,
                    INTEGER          *IWORK,
                    INTEGER          *IFAIL,
                    INTEGER          *INFO)
{
    DEBUG_LAPACK_STUB("dspevx");
    LAPACK_IMPL(dspevx)(JOBZ,
                        RANGE,
                        UPLO,
                        N,
                        AP,
                        VL,
                        VU,
                        IL,
                        IU,
                        ABSTOL,
                        M,
                        W,
                        Z,
                        LDZ,
                        WORK,
                        IWORK,
                        IFAIL,
                        INFO);
}

//-- dspgst --------------------------------------------------------------------
void
LAPACK_DECL(dspgst)(const INTEGER    *ITYPE,
                    const char       *UPLO,
                    const INTEGER    *N,
                    DOUBLE           *AP,
                    const DOUBLE     *BP,
                    INTEGER          *INFO)
{
    DEBUG_LAPACK_STUB("dspgst");
    LAPACK_IMPL(dspgst)(ITYPE,
                        UPLO,
                        N,
                        AP,
                        BP,
                        INFO);
}

//-- dspgv ---------------------------------------------------------------------
void
LAPACK_DECL(dspgv)(const INTEGER        *ITYPE,
                   const char           *JOBZ,
                   const char           *UPLO,
                   const INTEGER        *N,
                   DOUBLE               *AP,
                   DOUBLE               *BP,
                   DOUBLE               *W,
                   DOUBLE               *Z,
                   const INTEGER        *LDZ,
                   DOUBLE               *WORK,
                   INTEGER              *INFO)
{
    DEBUG_LAPACK_STUB("dspgv");
    LAPACK_IMPL(dspgv)(ITYPE,
                       JOBZ,
                       UPLO,
                       N,
                       AP,
                       BP,
                       W,
                       Z,
                       LDZ,
                       WORK,
                       INFO);
}

//-- dspgvd --------------------------------------------------------------------
void
LAPACK_DECL(dspgvd)(const INTEGER    *ITYPE,
                    const char       *JOBZ,
                    const char       *UPLO,
                    const INTEGER    *N,
                    DOUBLE           *AP,
                    DOUBLE           *BP,
                    DOUBLE           *W,
                    DOUBLE           *Z,
                    const INTEGER    *LDZ,
                    DOUBLE           *WORK,
                    const INTEGER    *LWORK,
                    INTEGER          *IWORK,
                    const INTEGER    *LIWORK,
                    INTEGER          *INFO)
{
    DEBUG_LAPACK_STUB("dspgvd");
    LAPACK_IMPL(dspgvd)(ITYPE,
                        JOBZ,
                        UPLO,
                        N,
                        AP,
                        BP,
                        W,
                        Z,
                        LDZ,
                        WORK,
                        LWORK,
                        IWORK,
                        LIWORK,
                        INFO);
}

//-- dspgvx --------------------------------------------------------------------
void
LAPACK_DECL(dspgvx)(const INTEGER    *ITYPE,
                    const char       *JOBZ,
                    const char       *RANGE,
                    const char       *UPLO,
                    const INTEGER    *N,
                    DOUBLE           *AP,
                    DOUBLE           *BP,
                    const DOUBLE     *VL,
                    const DOUBLE     *VU,
                    const INTEGER    *IL,
                    const INTEGER    *IU,
                    const DOUBLE     *ABSTOL,
                    INTEGER          *M,
                    DOUBLE           *W,
                    DOUBLE           *Z,
                    const INTEGER    *LDZ,
                    DOUBLE           *WORK,
                    INTEGER          *IWORK,
                    INTEGER          *IFAIL,
                    INTEGER          *INFO)
{
    DEBUG_LAPACK_STUB("dspgvx");
    LAPACK_IMPL(dspgvx)(ITYPE,
                        JOBZ,
                        RANGE,
                        UPLO,
                        N,
                        AP,
                        BP,
                        VL,
                        VU,
                        IL,
                        IU,
                        ABSTOL,
                        M,
                        W,
                        Z,
                        LDZ,
                        WORK,
                        IWORK,
                        IFAIL,
                        INFO);
}

//-- dsposv --------------------------------------------------------------------
void
LAPACK_DECL(dsposv)(const char       *UPLO,
                    const INTEGER    *N,
                    const INTEGER    *NRHS,
                    DOUBLE           *A,
                    const INTEGER    *LDA,
                    const DOUBLE     *B,
                    const INTEGER    *LDB,
                    DOUBLE           *X,
                    const INTEGER    *LDX,
                    DOUBLE           *WORK,
                    FLOAT            *SWORK,
                    INTEGER          *ITER,
                    INTEGER          *INFO)
{
    DEBUG_LAPACK_STUB("dsposv");
    LAPACK_IMPL(dsposv)(UPLO,
                        N,
                        NRHS,
                        A,
                        LDA,
                        B,
                        LDB,
                        X,
                        LDX,
                        WORK,
                        SWORK,
                        ITER,
                        INFO);
}

//-- dsprfs --------------------------------------------------------------------
void
LAPACK_DECL(dsprfs)(const char       *UPLO,
                    const INTEGER    *N,
                    const INTEGER    *NRHS,
                    const DOUBLE     *AP,
                    const DOUBLE     *AFP,
                    const INTEGER    *IPIV,
                    const DOUBLE     *B,
                    const INTEGER    *LDB,
                    DOUBLE           *X,
                    const INTEGER    *LDX,
                    DOUBLE           *FERR,
                    DOUBLE           *BERR,
                    DOUBLE           *WORK,
                    INTEGER          *IWORK,
                    INTEGER          *INFO)
{
    DEBUG_LAPACK_STUB("dsprfs");
    LAPACK_IMPL(dsprfs)(UPLO,
                        N,
                        NRHS,
                        AP,
                        AFP,
                        IPIV,
                        B,
                        LDB,
                        X,
                        LDX,
                        FERR,
                        BERR,
                        WORK,
                        IWORK,
                        INFO);
}

//-- dspsv ---------------------------------------------------------------------
void
LAPACK_DECL(dspsv)(const char           *UPLO,
                   const INTEGER        *N,
                   const INTEGER        *NRHS,
                   DOUBLE               *AP,
                   INTEGER              *IPIV,
                   DOUBLE               *B,
                   const INTEGER        *LDB,
                   INTEGER              *INFO)
{
    DEBUG_LAPACK_STUB("dspsv");
    LAPACK_IMPL(dspsv)(UPLO,
                       N,
                       NRHS,
                       AP,
                       IPIV,
                       B,
                       LDB,
                       INFO);
}

//-- dspsvx --------------------------------------------------------------------
void
LAPACK_DECL(dspsvx)(const char       *FACT,
                    const char       *UPLO,
                    const INTEGER    *N,
                    const INTEGER    *NRHS,
                    const DOUBLE     *AP,
                    DOUBLE           *AFP,
                    INTEGER          *IPIV,
                    const DOUBLE     *B,
                    const INTEGER    *LDB,
                    DOUBLE           *X,
                    const INTEGER    *LDX,
                    DOUBLE           *RCOND,
                    DOUBLE           *FERR,
                    DOUBLE           *BERR,
                    DOUBLE           *WORK,
                    INTEGER          *IWORK,
                    INTEGER          *INFO)
{
    DEBUG_LAPACK_STUB("dspsvx");
    LAPACK_IMPL(dspsvx)(FACT,
                        UPLO,
                        N,
                        NRHS,
                        AP,
                        AFP,
                        IPIV,
                        B,
                        LDB,
                        X,
                        LDX,
                        RCOND,
                        FERR,
                        BERR,
                        WORK,
                        IWORK,
                        INFO);
}

//-- dsptrd --------------------------------------------------------------------
void
LAPACK_DECL(dsptrd)(const char       *UPLO,
                    const INTEGER    *N,
                    DOUBLE           *AP,
                    DOUBLE           *D,
                    DOUBLE           *E,
                    DOUBLE           *TAU,
                    INTEGER          *INFO)
{
    DEBUG_LAPACK_STUB("dsptrd");
    LAPACK_IMPL(dsptrd)(UPLO,
                        N,
                        AP,
                        D,
                        E,
                        TAU,
                        INFO);
}

//-- dsptrf --------------------------------------------------------------------
void
LAPACK_DECL(dsptrf)(const char       *UPLO,
                    const INTEGER    *N,
                    DOUBLE           *AP,
                    INTEGER          *IPIV,
                    INTEGER          *INFO)
{
    DEBUG_LAPACK_STUB("dsptrf");
    LAPACK_IMPL(dsptrf)(UPLO,
                        N,
                        AP,
                        IPIV,
                        INFO);
}

//-- dsptri --------------------------------------------------------------------
void
LAPACK_DECL(dsptri)(const char       *UPLO,
                    const INTEGER    *N,
                    DOUBLE           *AP,
                    const INTEGER    *IPIV,
                    DOUBLE           *WORK,
                    INTEGER          *INFO)
{
    DEBUG_LAPACK_STUB("dsptri");
    LAPACK_IMPL(dsptri)(UPLO,
                        N,
                        AP,
                        IPIV,
                        WORK,
                        INFO);
}

//-- dsptrs --------------------------------------------------------------------
void
LAPACK_DECL(dsptrs)(const char       *UPLO,
                    const INTEGER    *N,
                    const INTEGER    *NRHS,
                    const DOUBLE     *AP,
                    const INTEGER    *IPIV,
                    DOUBLE           *B,
                    const INTEGER    *LDB,
                    INTEGER          *INFO)
{
    DEBUG_LAPACK_STUB("dsptrs");
    LAPACK_IMPL(dsptrs)(UPLO,
                        N,
                        NRHS,
                        AP,
                        IPIV,
                        B,
                        LDB,
                        INFO);
}

//-- dstebz --------------------------------------------------------------------
void
LAPACK_DECL(dstebz)(const char       *RANGE,
                    const char       *ORDER,
                    const INTEGER    *N,
                    const DOUBLE     *VL,
                    const DOUBLE     *VU,
                    const INTEGER    *IL,
                    const INTEGER    *IU,
                    const DOUBLE     *ABSTOL,
                    const DOUBLE     *D,
                    const DOUBLE     *E,
                    INTEGER          *M,
                    INTEGER          *NSPLIT,
                    DOUBLE           *W,
                    INTEGER          *IBLOCK,
                    INTEGER          *ISPLIT,
                    DOUBLE           *WORK,
                    INTEGER          *IWORK,
                    INTEGER          *INFO)
{
    DEBUG_LAPACK_STUB("dstebz");
    LAPACK_IMPL(dstebz)(RANGE,
                        ORDER,
                        N,
                        VL,
                        VU,
                        IL,
                        IU,
                        ABSTOL,
                        D,
                        E,
                        M,
                        NSPLIT,
                        W,
                        IBLOCK,
                        ISPLIT,
                        WORK,
                        IWORK,
                        INFO);
}

//-- dstedc --------------------------------------------------------------------
void
LAPACK_DECL(dstedc)(const char       *COMPZ,
                    const INTEGER    *N,
                    DOUBLE           *D,
                    DOUBLE           *E,
                    DOUBLE           *Z,
                    const INTEGER    *LDZ,
                    DOUBLE           *WORK,
                    const INTEGER    *LWORK,
                    INTEGER          *IWORK,
                    const INTEGER    *LIWORK,
                    INTEGER          *INFO)
{
    DEBUG_LAPACK_STUB("dstedc");
    LAPACK_IMPL(dstedc)(COMPZ,
                        N,
                        D,
                        E,
                        Z,
                        LDZ,
                        WORK,
                        LWORK,
                        IWORK,
                        LIWORK,
                        INFO);
}

//-- dstegr --------------------------------------------------------------------
void
LAPACK_DECL(dstegr)(const char       *JOBZ,
                    const char       *RANGE,
                    const INTEGER    *N,
                    DOUBLE           *D,
                    DOUBLE           *E,
                    const DOUBLE     *VL,
                    const DOUBLE     *VU,
                    const INTEGER    *IL,
                    const INTEGER    *IU,
                    const DOUBLE     *ABSTOL,
                    INTEGER          *M,
                    DOUBLE           *W,
                    DOUBLE           *Z,
                    const INTEGER    *LDZ,
                    INTEGER          *ISUPPZ,
                    DOUBLE           *WORK,
                    const INTEGER    *LWORK,
                    INTEGER          *IWORK,
                    const INTEGER    *LIWORK,
                    INTEGER          *INFO)
{
    DEBUG_LAPACK_STUB("dstegr");
    LAPACK_IMPL(dstegr)(JOBZ,
                        RANGE,
                        N,
                        D,
                        E,
                        VL,
                        VU,
                        IL,
                        IU,
                        ABSTOL,
                        M,
                        W,
                        Z,
                        LDZ,
                        ISUPPZ,
                        WORK,
                        LWORK,
                        IWORK,
                        LIWORK,
                        INFO);
}

//-- dstein --------------------------------------------------------------------
void
LAPACK_DECL(dstein)(const INTEGER    *N,
                    const DOUBLE     *D,
                    const DOUBLE     *E,
                    const INTEGER    *M,
                    const DOUBLE     *W,
                    const INTEGER    *IBLOCK,
                    const INTEGER    *ISPLIT,
                    DOUBLE           *Z,
                    const INTEGER    *LDZ,
                    DOUBLE           *WORK,
                    INTEGER          *IWORK,
                    INTEGER          *IFAIL,
                    INTEGER          *INFO)
{
    DEBUG_LAPACK_STUB("dstein");
    LAPACK_IMPL(dstein)(N,
                        D,
                        E,
                        M,
                        W,
                        IBLOCK,
                        ISPLIT,
                        Z,
                        LDZ,
                        WORK,
                        IWORK,
                        IFAIL,
                        INFO);
}

//-- dstemr --------------------------------------------------------------------
void
LAPACK_DECL(dstemr)(const char       *JOBZ,
                    const char       *RANGE,
                    const INTEGER    *N,
                    DOUBLE           *D,
                    DOUBLE           *E,
                    const DOUBLE     *VL,
                    const DOUBLE     *VU,
                    const INTEGER    *IL,
                    const INTEGER    *IU,
                    INTEGER          *M,
                    DOUBLE           *W,
                    DOUBLE           *Z,
                    const INTEGER    *LDZ,
                    const INTEGER    *NZC,
                    INTEGER          *ISUPPZ,
                    LOGICAL          *TRYRAC,
                    DOUBLE           *WORK,
                    const INTEGER    *LWORK,
                    INTEGER          *IWORK,
                    const INTEGER    *LIWORK,
                    INTEGER          *INFO)
{
    DEBUG_LAPACK_STUB("dstemr");
    LAPACK_IMPL(dstemr)(JOBZ,
                        RANGE,
                        N,
                        D,
                        E,
                        VL,
                        VU,
                        IL,
                        IU,
                        M,
                        W,
                        Z,
                        LDZ,
                        NZC,
                        ISUPPZ,
                        TRYRAC,
                        WORK,
                        LWORK,
                        IWORK,
                        LIWORK,
                        INFO);
}

//-- dsteqr --------------------------------------------------------------------
void
LAPACK_DECL(dsteqr)(const char       *COMPZ,
                    const INTEGER    *N,
                    DOUBLE           *D,
                    DOUBLE           *E,
                    DOUBLE           *Z,
                    const INTEGER    *LDZ,
                    DOUBLE           *WORK,
                    INTEGER          *INFO)
{
    DEBUG_LAPACK_STUB("dsteqr");
    LAPACK_IMPL(dsteqr)(COMPZ,
                        N,
                        D,
                        E,
                        Z,
                        LDZ,
                        WORK,
                        INFO);
}

//-- dsterf --------------------------------------------------------------------
void
LAPACK_DECL(dsterf)(const INTEGER    *N,
                    DOUBLE           *D,
                    DOUBLE           *E,
                    INTEGER          *INFO)
{
    DEBUG_LAPACK_STUB("dsterf");
    LAPACK_IMPL(dsterf)(N,
                        D,
                        E,
                        INFO);
}

//-- dstev ---------------------------------------------------------------------
void
LAPACK_DECL(dstev)(const char           *JOBZ,
                   const INTEGER        *N,
                   DOUBLE               *D,
                   DOUBLE               *E,
                   DOUBLE               *Z,
                   const INTEGER        *LDZ,
                   DOUBLE               *WORK,
                   INTEGER              *INFO)
{
    DEBUG_LAPACK_STUB("dstev");
    LAPACK_IMPL(dstev)(JOBZ,
                       N,
                       D,
                       E,
                       Z,
                       LDZ,
                       WORK,
                       INFO);
}

//-- dstevd --------------------------------------------------------------------
void
LAPACK_DECL(dstevd)(const char       *JOBZ,
                    const INTEGER    *N,
                    DOUBLE           *D,
                    DOUBLE           *E,
                    DOUBLE           *Z,
                    const INTEGER    *LDZ,
                    DOUBLE           *WORK,
                    const INTEGER    *LWORK,
                    INTEGER          *IWORK,
                    const INTEGER    *LIWORK,
                    INTEGER          *INFO)
{
    DEBUG_LAPACK_STUB("dstevd");
    LAPACK_IMPL(dstevd)(JOBZ,
                        N,
                        D,
                        E,
                        Z,
                        LDZ,
                        WORK,
                        LWORK,
                        IWORK,
                        LIWORK,
                        INFO);
}

//-- dstevr --------------------------------------------------------------------
void
LAPACK_DECL(dstevr)(const char       *JOBZ,
                    const char       *RANGE,
                    const INTEGER    *N,
                    DOUBLE           *D,
                    DOUBLE           *E,
                    const DOUBLE     *VL,
                    const DOUBLE     *VU,
                    const INTEGER    *IL,
                    const INTEGER    *IU,
                    const DOUBLE     *ABSTOL,
                    INTEGER          *M,
                    DOUBLE           *W,
                    DOUBLE           *Z,
                    const INTEGER    *LDZ,
                    INTEGER          *ISUPPZ,
                    DOUBLE           *WORK,
                    const INTEGER    *LWORK,
                    INTEGER          *IWORK,
                    const INTEGER    *LIWORK,
                    INTEGER          *INFO)
{
    DEBUG_LAPACK_STUB("dstevr");
    LAPACK_IMPL(dstevr)(JOBZ,
                        RANGE,
                        N,
                        D,
                        E,
                        VL,
                        VU,
                        IL,
                        IU,
                        ABSTOL,
                        M,
                        W,
                        Z,
                        LDZ,
                        ISUPPZ,
                        WORK,
                        LWORK,
                        IWORK,
                        LIWORK,
                        INFO);
}

//-- dstevx --------------------------------------------------------------------
void
LAPACK_DECL(dstevx)(const char       *JOBZ,
                    const char       *RANGE,
                    const INTEGER    *N,
                    DOUBLE           *D,
                    DOUBLE           *E,
                    const DOUBLE     *VL,
                    const DOUBLE     *VU,
                    const INTEGER    *IL,
                    const INTEGER    *IU,
                    const DOUBLE     *ABSTOL,
                    INTEGER          *M,
                    DOUBLE           *W,
                    DOUBLE           *Z,
                    const INTEGER    *LDZ,
                    DOUBLE           *WORK,
                    INTEGER          *IWORK,
                    INTEGER          *IFAIL,
                    INTEGER          *INFO)
{
    DEBUG_LAPACK_STUB("dstevx");
    LAPACK_IMPL(dstevx)(JOBZ,
                        RANGE,
                        N,
                        D,
                        E,
                        VL,
                        VU,
                        IL,
                        IU,
                        ABSTOL,
                        M,
                        W,
                        Z,
                        LDZ,
                        WORK,
                        IWORK,
                        IFAIL,
                        INFO);
}

//-- dsycon --------------------------------------------------------------------
void
LAPACK_DECL(dsycon)(const char       *UPLO,
                    const INTEGER    *N,
                    const DOUBLE     *A,
                    const INTEGER    *LDA,
                    const INTEGER    *IPIV,
                    const DOUBLE     *ANORM,
                    DOUBLE           *RCOND,
                    DOUBLE           *WORK,
                    INTEGER          *IWORK,
                    INTEGER          *INFO)
{
    DEBUG_LAPACK_STUB("dsycon");
    LAPACK_IMPL(dsycon)(UPLO,
                        N,
                        A,
                        LDA,
                        IPIV,
                        ANORM,
                        RCOND,
                        WORK,
                        IWORK,
                        INFO);
}

//-- dsyconv -------------------------------------------------------------------
void
LAPACK_DECL(dsyconv)(const char       *UPLO,
                     const char       *WAY,
                     const INTEGER    *N,
                     const DOUBLE     *A,
                     const INTEGER    *LDA,
                     const INTEGER    *IPIV,
                     DOUBLE           *WORK,
                     INTEGER          *INFO)
{
    DEBUG_LAPACK_STUB("dsyconv");
    LAPACK_IMPL(dsyconv)(UPLO,
                         WAY,
                         N,
                         A,
                         LDA,
                         IPIV,
                         WORK,
                         INFO);
}

//-- dsyequb -------------------------------------------------------------------
void
LAPACK_DECL(dsyequb)(const char       *UPLO,
                     const INTEGER    *N,
                     const DOUBLE     *A,
                     const INTEGER    *LDA,
                     DOUBLE           *S,
                     DOUBLE           *SCOND,
                     DOUBLE           *AMAX,
                     DOUBLE           *WORK,
                     INTEGER          *INFO)
{
    DEBUG_LAPACK_STUB("dsyequb");
    LAPACK_IMPL(dsyequb)(UPLO,
                         N,
                         A,
                         LDA,
                         S,
                         SCOND,
                         AMAX,
                         WORK,
                         INFO);
}

//-- dsyev ---------------------------------------------------------------------
void
LAPACK_DECL(dsyev)(const char           *JOBZ,
                   const char           *UPLO,
                   const INTEGER        *N,
                   DOUBLE               *A,
                   const INTEGER        *LDA,
                   DOUBLE               *W,
                   DOUBLE               *WORK,
                   const INTEGER        *LWORK,
                   INTEGER              *INFO)
{
    DEBUG_LAPACK_STUB("dsyev");
    LAPACK_IMPL(dsyev)(JOBZ,
                       UPLO,
                       N,
                       A,
                       LDA,
                       W,
                       WORK,
                       LWORK,
                       INFO);
}

//-- dsyevd --------------------------------------------------------------------
void
LAPACK_DECL(dsyevd)(const char       *JOBZ,
                    const char       *UPLO,
                    const INTEGER    *N,
                    DOUBLE           *A,
                    const INTEGER    *LDA,
                    DOUBLE           *W,
                    DOUBLE           *WORK,
                    const INTEGER    *LWORK,
                    INTEGER          *IWORK,
                    const INTEGER    *LIWORK,
                    INTEGER          *INFO)
{
    DEBUG_LAPACK_STUB("dsyevd");
    LAPACK_IMPL(dsyevd)(JOBZ,
                        UPLO,
                        N,
                        A,
                        LDA,
                        W,
                        WORK,
                        LWORK,
                        IWORK,
                        LIWORK,
                        INFO);
}

//-- dsyevr --------------------------------------------------------------------
void
LAPACK_DECL(dsyevr)(const char       *JOBZ,
                    const char       *RANGE,
                    const char       *UPLO,
                    const INTEGER    *N,
                    DOUBLE           *A,
                    const INTEGER    *LDA,
                    const DOUBLE     *VL,
                    const DOUBLE     *VU,
                    const INTEGER    *IL,
                    const INTEGER    *IU,
                    const DOUBLE     *ABSTOL,
                    INTEGER          *M,
                    DOUBLE           *W,
                    DOUBLE           *Z,
                    const INTEGER    *LDZ,
                    INTEGER          *ISUPPZ,
                    DOUBLE           *WORK,
                    const INTEGER    *LWORK,
                    INTEGER          *IWORK,
                    const INTEGER    *LIWORK,
                    INTEGER          *INFO)
{
    DEBUG_LAPACK_STUB("dsyevr");
    LAPACK_IMPL(dsyevr)(JOBZ,
                        RANGE,
                        UPLO,
                        N,
                        A,
                        LDA,
                        VL,
                        VU,
                        IL,
                        IU,
                        ABSTOL,
                        M,
                        W,
                        Z,
                        LDZ,
                        ISUPPZ,
                        WORK,
                        LWORK,
                        IWORK,
                        LIWORK,
                        INFO);
}

//-- dsyevx --------------------------------------------------------------------
void
LAPACK_DECL(dsyevx)(const char       *JOBZ,
                    const char       *RANGE,
                    const char       *UPLO,
                    const INTEGER    *N,
                    DOUBLE           *A,
                    const INTEGER    *LDA,
                    const DOUBLE     *VL,
                    const DOUBLE     *VU,
                    const INTEGER    *IL,
                    const INTEGER    *IU,
                    const DOUBLE     *ABSTOL,
                    INTEGER          *M,
                    DOUBLE           *W,
                    DOUBLE           *Z,
                    const INTEGER    *LDZ,
                    DOUBLE           *WORK,
                    const INTEGER    *LWORK,
                    INTEGER          *IWORK,
                    INTEGER          *IFAIL,
                    INTEGER          *INFO)
{
    DEBUG_LAPACK_STUB("dsyevx");
    LAPACK_IMPL(dsyevx)(JOBZ,
                        RANGE,
                        UPLO,
                        N,
                        A,
                        LDA,
                        VL,
                        VU,
                        IL,
                        IU,
                        ABSTOL,
                        M,
                        W,
                        Z,
                        LDZ,
                        WORK,
                        LWORK,
                        IWORK,
                        IFAIL,
                        INFO);
}

//-- dsygs2 --------------------------------------------------------------------
void
LAPACK_DECL(dsygs2)(const INTEGER    *ITYPE,
                    const char       *UPLO,
                    const INTEGER    *N,
                    DOUBLE           *A,
                    const INTEGER    *LDA,
                    const DOUBLE     *B,
                    const INTEGER    *LDB,
                    INTEGER          *INFO)
{
    DEBUG_LAPACK_STUB("dsygs2");
    LAPACK_IMPL(dsygs2)(ITYPE,
                        UPLO,
                        N,
                        A,
                        LDA,
                        B,
                        LDB,
                        INFO);
}

//-- dsygst --------------------------------------------------------------------
void
LAPACK_DECL(dsygst)(const INTEGER    *ITYPE,
                    const char       *UPLO,
                    const INTEGER    *N,
                    DOUBLE           *A,
                    const INTEGER    *LDA,
                    const DOUBLE     *B,
                    const INTEGER    *LDB,
                    INTEGER          *INFO)
{
    DEBUG_LAPACK_STUB("dsygst");
    LAPACK_IMPL(dsygst)(ITYPE,
                        UPLO,
                        N,
                        A,
                        LDA,
                        B,
                        LDB,
                        INFO);
}

//-- dsygv ---------------------------------------------------------------------
void
LAPACK_DECL(dsygv)(const INTEGER        *ITYPE,
                   const char           *JOBZ,
                   const char           *UPLO,
                   const INTEGER        *N,
                   DOUBLE               *A,
                   const INTEGER        *LDA,
                   DOUBLE               *B,
                   const INTEGER        *LDB,
                   DOUBLE               *W,
                   DOUBLE               *WORK,
                   const INTEGER        *LWORK,
                   INTEGER              *INFO)
{
    DEBUG_LAPACK_STUB("dsygv");
    LAPACK_IMPL(dsygv)(ITYPE,
                       JOBZ,
                       UPLO,
                       N,
                       A,
                       LDA,
                       B,
                       LDB,
                       W,
                       WORK,
                       LWORK,
                       INFO);
}

//-- dsygvd --------------------------------------------------------------------
void
LAPACK_DECL(dsygvd)(const INTEGER    *ITYPE,
                    const char       *JOBZ,
                    const char       *UPLO,
                    const INTEGER    *N,
                    DOUBLE           *A,
                    const INTEGER    *LDA,
                    DOUBLE           *B,
                    const INTEGER    *LDB,
                    DOUBLE           *W,
                    DOUBLE           *WORK,
                    const INTEGER    *LWORK,
                    INTEGER          *IWORK,
                    const INTEGER    *LIWORK,
                    INTEGER          *INFO)
{
    DEBUG_LAPACK_STUB("dsygvd");
    LAPACK_IMPL(dsygvd)(ITYPE,
                        JOBZ,
                        UPLO,
                        N,
                        A,
                        LDA,
                        B,
                        LDB,
                        W,
                        WORK,
                        LWORK,
                        IWORK,
                        LIWORK,
                        INFO);
}

//-- dsygvx --------------------------------------------------------------------
void
LAPACK_DECL(dsygvx)(const INTEGER    *ITYPE,
                    const char       *JOBZ,
                    const char       *RANGE,
                    const char       *UPLO,
                    const INTEGER    *N,
                    DOUBLE           *A,
                    const INTEGER    *LDA,
                    DOUBLE           *B,
                    const INTEGER    *LDB,
                    const DOUBLE     *VL,
                    const DOUBLE     *VU,
                    const INTEGER    *IL,
                    const INTEGER    *IU,
                    const DOUBLE     *ABSTOL,
                    INTEGER          *M,
                    DOUBLE           *W,
                    DOUBLE           *Z,
                    const INTEGER    *LDZ,
                    DOUBLE           *WORK,
                    const INTEGER    *LWORK,
                    INTEGER          *IWORK,
                    INTEGER          *IFAIL,
                    INTEGER          *INFO)
{
    DEBUG_LAPACK_STUB("dsygvx");
    LAPACK_IMPL(dsygvx)(ITYPE,
                        JOBZ,
                        RANGE,
                        UPLO,
                        N,
                        A,
                        LDA,
                        B,
                        LDB,
                        VL,
                        VU,
                        IL,
                        IU,
                        ABSTOL,
                        M,
                        W,
                        Z,
                        LDZ,
                        WORK,
                        LWORK,
                        IWORK,
                        IFAIL,
                        INFO);
}

//-- dsyrfs --------------------------------------------------------------------
void
LAPACK_DECL(dsyrfs)(const char       *UPLO,
                    const INTEGER    *N,
                    const INTEGER    *NRHS,
                    const DOUBLE     *A,
                    const INTEGER    *LDA,
                    const DOUBLE     *AF,
                    const INTEGER    *LDAF,
                    const INTEGER    *IPIV,
                    const DOUBLE     *B,
                    const INTEGER    *LDB,
                    DOUBLE           *X,
                    const INTEGER    *LDX,
                    DOUBLE           *FERR,
                    DOUBLE           *BERR,
                    DOUBLE           *WORK,
                    INTEGER          *IWORK,
                    INTEGER          *INFO)
{
    DEBUG_LAPACK_STUB("dsyrfs");
    LAPACK_IMPL(dsyrfs)(UPLO,
                        N,
                        NRHS,
                        A,
                        LDA,
                        AF,
                        LDAF,
                        IPIV,
                        B,
                        LDB,
                        X,
                        LDX,
                        FERR,
                        BERR,
                        WORK,
                        IWORK,
                        INFO);
}

//-- dsyrfsx -------------------------------------------------------------------
void
LAPACK_DECL(dsyrfsx)(const char       *UPLO,
                     const char       *EQUED,
                     const INTEGER    *N,
                     const INTEGER    *NRHS,
                     const DOUBLE     *A,
                     const INTEGER    *LDA,
                     const DOUBLE     *AF,
                     const INTEGER    *LDAF,
                     const INTEGER    *IPIV,
                     DOUBLE           *S,
                     const DOUBLE     *B,
                     const INTEGER    *LDB,
                     DOUBLE           *X,
                     const INTEGER    *LDX,
                     DOUBLE           *RCOND,
                     DOUBLE           *BERR,
                     const INTEGER    *N_ERR_BNDS,
                     DOUBLE           *ERR_BNDS_NORM,
                     DOUBLE           *ERR_BNDS_COMP,
                     const INTEGER    *NPARAMS,
                     DOUBLE           *PARAMS,
                     DOUBLE           *WORK,
                     INTEGER          *IWORK,
                     INTEGER          *INFO)
{
    DEBUG_LAPACK_STUB("dsyrfsx");
    LAPACK_IMPL(dsyrfsx)(UPLO,
                         EQUED,
                         N,
                         NRHS,
                         A,
                         LDA,
                         AF,
                         LDAF,
                         IPIV,
                         S,
                         B,
                         LDB,
                         X,
                         LDX,
                         RCOND,
                         BERR,
                         N_ERR_BNDS,
                         ERR_BNDS_NORM,
                         ERR_BNDS_COMP,
                         NPARAMS,
                         PARAMS,
                         WORK,
                         IWORK,
                         INFO);
}

//-- dsysv ---------------------------------------------------------------------
void
LAPACK_DECL(dsysv)(const char           *UPLO,
                   const INTEGER        *N,
                   const INTEGER        *NRHS,
                   DOUBLE               *A,
                   const INTEGER        *LDA,
                   INTEGER              *IPIV,
                   DOUBLE               *B,
                   const INTEGER        *LDB,
                   DOUBLE               *WORK,
                   const INTEGER        *LWORK,
                   INTEGER              *INFO)
{
    DEBUG_LAPACK_STUB("dsysv");
    LAPACK_IMPL(dsysv)(UPLO,
                       N,
                       NRHS,
                       A,
                       LDA,
                       IPIV,
                       B,
                       LDB,
                       WORK,
                       LWORK,
                       INFO);
}

//-- dsysvx --------------------------------------------------------------------
void
LAPACK_DECL(dsysvx)(const char       *FACT,
                    const char       *UPLO,
                    const INTEGER    *N,
                    const INTEGER    *NRHS,
                    const DOUBLE     *A,
                    const INTEGER    *LDA,
                    DOUBLE           *AF,
                    const INTEGER    *LDAF,
                    INTEGER          *IPIV,
                    const DOUBLE     *B,
                    const INTEGER    *LDB,
                    DOUBLE           *X,
                    const INTEGER    *LDX,
                    DOUBLE           *RCOND,
                    DOUBLE           *FERR,
                    DOUBLE           *BERR,
                    DOUBLE           *WORK,
                    const INTEGER    *LWORK,
                    INTEGER          *IWORK,
                    INTEGER          *INFO)
{
    DEBUG_LAPACK_STUB("dsysvx");
    LAPACK_IMPL(dsysvx)(FACT,
                        UPLO,
                        N,
                        NRHS,
                        A,
                        LDA,
                        AF,
                        LDAF,
                        IPIV,
                        B,
                        LDB,
                        X,
                        LDX,
                        RCOND,
                        FERR,
                        BERR,
                        WORK,
                        LWORK,
                        IWORK,
                        INFO);
}

//-- dsysvxx -------------------------------------------------------------------
void
LAPACK_DECL(dsysvxx)(const char       *FACT,
                     const char       *UPLO,
                     const INTEGER    *N,
                     const INTEGER    *NRHS,
                     DOUBLE           *A,
                     const INTEGER    *LDA,
                     DOUBLE           *AF,
                     const INTEGER    *LDAF,
                     INTEGER          *IPIV,
                     char             *EQUED,
                     DOUBLE           *S,
                     DOUBLE           *B,
                     const INTEGER    *LDB,
                     DOUBLE           *X,
                     const INTEGER    *LDX,
                     DOUBLE           *RCOND,
                     DOUBLE           *RPVGRW,
                     DOUBLE           *BERR,
                     const INTEGER    *N_ERR_BNDS,
                     DOUBLE           *ERR_BNDS_NORM,
                     DOUBLE           *ERR_BNDS_COMP,
                     const INTEGER    *NPARAMS,
                     DOUBLE           *PARAMS,
                     DOUBLE           *WORK,
                     INTEGER          *IWORK,
                     INTEGER          *INFO)
{
    DEBUG_LAPACK_STUB("dsysvxx");
    LAPACK_IMPL(dsysvxx)(FACT,
                         UPLO,
                         N,
                         NRHS,
                         A,
                         LDA,
                         AF,
                         LDAF,
                         IPIV,
                         EQUED,
                         S,
                         B,
                         LDB,
                         X,
                         LDX,
                         RCOND,
                         RPVGRW,
                         BERR,
                         N_ERR_BNDS,
                         ERR_BNDS_NORM,
                         ERR_BNDS_COMP,
                         NPARAMS,
                         PARAMS,
                         WORK,
                         IWORK,
                         INFO);
}

//-- dsyswapr ------------------------------------------------------------------
void
LAPACK_DECL(dsyswapr)(const char       *UPLO,
                      const INTEGER    *N,
                      DOUBLE           *A,
                      const INTEGER    *LDA,
                      const INTEGER    *I1,
                      const INTEGER    *I2)
{
    DEBUG_LAPACK_STUB("dsyswapr");
    LAPACK_IMPL(dsyswapr)(UPLO,
                          N,
                          A,
                          LDA,
                          I1,
                          I2);
}

//-- dsytd2 --------------------------------------------------------------------
void
LAPACK_DECL(dsytd2)(const char       *UPLO,
                    const INTEGER    *N,
                    DOUBLE           *A,
                    const INTEGER    *LDA,
                    DOUBLE           *D,
                    DOUBLE           *E,
                    DOUBLE           *TAU,
                    INTEGER          *INFO)
{
    DEBUG_LAPACK_STUB("dsytd2");
    LAPACK_IMPL(dsytd2)(UPLO,
                        N,
                        A,
                        LDA,
                        D,
                        E,
                        TAU,
                        INFO);
}

//-- dsytf2 --------------------------------------------------------------------
void
LAPACK_DECL(dsytf2)(const char       *UPLO,
                    const INTEGER    *N,
                    DOUBLE           *A,
                    const INTEGER    *LDA,
                    INTEGER          *IPIV,
                    INTEGER          *INFO)
{
    DEBUG_LAPACK_STUB("dsytf2");
    LAPACK_IMPL(dsytf2)(UPLO,
                        N,
                        A,
                        LDA,
                        IPIV,
                        INFO);
}

//-- dsytrd --------------------------------------------------------------------
void
LAPACK_DECL(dsytrd)(const char       *UPLO,
                    const INTEGER    *N,
                    DOUBLE           *A,
                    const INTEGER    *LDA,
                    DOUBLE           *D,
                    DOUBLE           *E,
                    DOUBLE           *TAU,
                    DOUBLE           *WORK,
                    const INTEGER    *LWORK,
                    INTEGER          *INFO)
{
    DEBUG_LAPACK_STUB("dsytrd");
    LAPACK_IMPL(dsytrd)(UPLO,
                        N,
                        A,
                        LDA,
                        D,
                        E,
                        TAU,
                        WORK,
                        LWORK,
                        INFO);
}

//-- dsytrf --------------------------------------------------------------------
void
LAPACK_DECL(dsytrf)(const char       *UPLO,
                    const INTEGER    *N,
                    DOUBLE           *A,
                    const INTEGER    *LDA,
                    INTEGER          *IPIV,
                    DOUBLE           *WORK,
                    const INTEGER    *LWORK,
                    INTEGER          *INFO)
{
    DEBUG_LAPACK_STUB("dsytrf");
    LAPACK_IMPL(dsytrf)(UPLO,
                        N,
                        A,
                        LDA,
                        IPIV,
                        WORK,
                        LWORK,
                        INFO);
}

//-- dsytri --------------------------------------------------------------------
void
LAPACK_DECL(dsytri)(const char       *UPLO,
                    const INTEGER    *N,
                    DOUBLE           *A,
                    const INTEGER    *LDA,
                    const INTEGER    *IPIV,
                    DOUBLE           *WORK,
                    INTEGER          *INFO)
{
    DEBUG_LAPACK_STUB("dsytri");
    LAPACK_IMPL(dsytri)(UPLO,
                        N,
                        A,
                        LDA,
                        IPIV,
                        WORK,
                        INFO);
}

//-- dsytri2 -------------------------------------------------------------------
void
LAPACK_DECL(dsytri2)(const char       *UPLO,
                     const INTEGER    *N,
                     DOUBLE           *A,
                     const INTEGER    *LDA,
                     const INTEGER    *IPIV,
                     DOUBLE           *WORK,
                     const INTEGER    *LWORK,
                     INTEGER          *INFO)
{
    DEBUG_LAPACK_STUB("dsytri2");
    LAPACK_IMPL(dsytri2)(UPLO,
                         N,
                         A,
                         LDA,
                         IPIV,
                         WORK,
                         LWORK,
                         INFO);
}

//-- dsytri2x ------------------------------------------------------------------
void
LAPACK_DECL(dsytri2x)(const char       *UPLO,
                      const INTEGER    *N,
                      DOUBLE           *A,
                      const INTEGER    *LDA,
                      const INTEGER    *IPIV,
                      DOUBLE           *WORK,
                      const INTEGER    *NB,
                      INTEGER          *INFO)
{
    DEBUG_LAPACK_STUB("dsytri2x");
    LAPACK_IMPL(dsytri2x)(UPLO,
                          N,
                          A,
                          LDA,
                          IPIV,
                          WORK,
                          NB,
                          INFO);
}

//-- dsytrs --------------------------------------------------------------------
void
LAPACK_DECL(dsytrs)(const char       *UPLO,
                    const INTEGER    *N,
                    const INTEGER    *NRHS,
                    const DOUBLE     *A,
                    const INTEGER    *LDA,
                    const INTEGER    *IPIV,
                    DOUBLE           *B,
                    const INTEGER    *LDB,
                    INTEGER          *INFO)
{
    DEBUG_LAPACK_STUB("dsytrs");
    LAPACK_IMPL(dsytrs)(UPLO,
                        N,
                        NRHS,
                        A,
                        LDA,
                        IPIV,
                        B,
                        LDB,
                        INFO);
}

//-- dsytrs2 -------------------------------------------------------------------
void
LAPACK_DECL(dsytrs2)(const char       *UPLO,
                     const INTEGER    *N,
                     const INTEGER    *NRHS,
                     const DOUBLE     *A,
                     const INTEGER    *LDA,
                     const INTEGER    *IPIV,
                     DOUBLE           *B,
                     const INTEGER    *LDB,
                     DOUBLE           *WORK,
                     INTEGER          *INFO)
{
    DEBUG_LAPACK_STUB("dsytrs2");
    LAPACK_IMPL(dsytrs2)(UPLO,
                         N,
                         NRHS,
                         A,
                         LDA,
                         IPIV,
                         B,
                         LDB,
                         WORK,
                         INFO);
}

//-- dtbcon --------------------------------------------------------------------
void
LAPACK_DECL(dtbcon)(const char       *NORM,
                    const char       *UPLO,
                    const char       *DIAG,
                    const INTEGER    *N,
                    const INTEGER    *KD,
                    const DOUBLE     *AB,
                    const INTEGER    *LDAB,
                    DOUBLE           *RCOND,
                    DOUBLE           *WORK,
                    INTEGER          *IWORK,
                    INTEGER          *INFO)
{
    DEBUG_LAPACK_STUB("dtbcon");
    LAPACK_IMPL(dtbcon)(NORM,
                        UPLO,
                        DIAG,
                        N,
                        KD,
                        AB,
                        LDAB,
                        RCOND,
                        WORK,
                        IWORK,
                        INFO);
}

//-- dtbrfs --------------------------------------------------------------------
void
LAPACK_DECL(dtbrfs)(const char       *UPLO,
                    const char       *TRANS,
                    const char       *DIAG,
                    const INTEGER    *N,
                    const INTEGER    *KD,
                    const INTEGER    *NRHS,
                    const DOUBLE     *AB,
                    const INTEGER    *LDAB,
                    const DOUBLE     *B,
                    const INTEGER    *LDB,
                    const DOUBLE     *X,
                    const INTEGER    *LDX,
                    DOUBLE           *FERR,
                    DOUBLE           *BERR,
                    DOUBLE           *WORK,
                    INTEGER          *IWORK,
                    INTEGER          *INFO)
{
    DEBUG_LAPACK_STUB("dtbrfs");
    LAPACK_IMPL(dtbrfs)(UPLO,
                        TRANS,
                        DIAG,
                        N,
                        KD,
                        NRHS,
                        AB,
                        LDAB,
                        B,
                        LDB,
                        X,
                        LDX,
                        FERR,
                        BERR,
                        WORK,
                        IWORK,
                        INFO);
}

//-- dtbtrs --------------------------------------------------------------------
void
LAPACK_DECL(dtbtrs)(const char       *UPLO,
                    const char       *TRANS,
                    const char       *DIAG,
                    const INTEGER    *N,
                    const INTEGER    *KD,
                    const INTEGER    *NRHS,
                    const DOUBLE     *AB,
                    const INTEGER    *LDAB,
                    DOUBLE           *B,
                    const INTEGER    *LDB,
                    INTEGER          *INFO)
{
    DEBUG_LAPACK_STUB("dtbtrs");
    LAPACK_IMPL(dtbtrs)(UPLO,
                        TRANS,
                        DIAG,
                        N,
                        KD,
                        NRHS,
                        AB,
                        LDAB,
                        B,
                        LDB,
                        INFO);
}

//-- dtfsm ---------------------------------------------------------------------
void
LAPACK_DECL(dtfsm)(const char           *TRANSR,
                   const char           *SIDE,
                   const char           *UPLO,
                   const char           *TRANS,
                   const char           *DIAG,
                   const INTEGER        *M,
                   const INTEGER        *N,
                   const DOUBLE         *ALPHA,
                   const DOUBLE         *A,
                   DOUBLE               *B,
                   const INTEGER        *LDB)
{
    DEBUG_LAPACK_STUB("dtfsm");
    LAPACK_IMPL(dtfsm)(TRANSR,
                       SIDE,
                       UPLO,
                       TRANS,
                       DIAG,
                       M,
                       N,
                       ALPHA,
                       A,
                       B,
                       LDB);
}

//-- dtftri --------------------------------------------------------------------
void
LAPACK_DECL(dtftri)(const char       *TRANSR,
                    const char       *UPLO,
                    const char       *DIAG,
                    const INTEGER    *N,
                    DOUBLE           *A,
                    INTEGER          *INFO)
{
    DEBUG_LAPACK_STUB("dtftri");
    LAPACK_IMPL(dtftri)(TRANSR,
                        UPLO,
                        DIAG,
                        N,
                        A,
                        INFO);
}

//-- dtfttp --------------------------------------------------------------------
void
LAPACK_DECL(dtfttp)(const char       *TRANSR,
                    const char       *UPLO,
                    const INTEGER    *N,
                    const DOUBLE     *ARF,
                    DOUBLE           *AP,
                    INTEGER          *INFO)
{
    DEBUG_LAPACK_STUB("dtfttp");
    LAPACK_IMPL(dtfttp)(TRANSR,
                        UPLO,
                        N,
                        ARF,
                        AP,
                        INFO);
}

//-- dtfttr --------------------------------------------------------------------
void
LAPACK_DECL(dtfttr)(const char       *TRANSR,
                    const char       *UPLO,
                    const INTEGER    *N,
                    const DOUBLE     *ARF,
                    DOUBLE           *A,
                    const INTEGER    *LDA,
                    INTEGER          *INFO)
{
    DEBUG_LAPACK_STUB("dtfttr");
    LAPACK_IMPL(dtfttr)(TRANSR,
                        UPLO,
                        N,
                        ARF,
                        A,
                        LDA,
                        INFO);
}

//-- dtgevc --------------------------------------------------------------------
void
LAPACK_DECL(dtgevc)(const char       *SIDE,
                    const char       *HOWMNY,
                    const LOGICAL    *SELECT,
                    const INTEGER    *N,
                    const DOUBLE     *S,
                    const INTEGER    *LDS,
                    const DOUBLE     *P,
                    const INTEGER    *LDP,
                    DOUBLE           *VL,
                    const INTEGER    *LDVL,
                    DOUBLE           *VR,
                    const INTEGER    *LDVR,
                    const INTEGER    *MM,
                    INTEGER          *M,
                    DOUBLE           *WORK,
                    INTEGER          *INFO)
{
    DEBUG_LAPACK_STUB("dtgevc");
    LAPACK_IMPL(dtgevc)(SIDE,
                        HOWMNY,
                        SELECT,
                        N,
                        S,
                        LDS,
                        P,
                        LDP,
                        VL,
                        LDVL,
                        VR,
                        LDVR,
                        MM,
                        M,
                        WORK,
                        INFO);
}

//-- dtgex2 --------------------------------------------------------------------
void
LAPACK_DECL(dtgex2)(const LOGICAL    *WANTQ,
                    const LOGICAL    *WANTZ,
                    const INTEGER    *N,
                    DOUBLE           *A,
                    const INTEGER    *LDA,
                    DOUBLE           *B,
                    const INTEGER    *LDB,
                    DOUBLE           *Q,
                    const INTEGER    *LDQ,
                    DOUBLE           *Z,
                    const INTEGER    *LDZ,
                    const INTEGER    *J1,
                    const INTEGER    *N1,
                    const INTEGER    *N2,
                    DOUBLE           *WORK,
                    const INTEGER    *LWORK,
                    INTEGER          *INFO)
{
    DEBUG_LAPACK_STUB("dtgex2");
    LAPACK_IMPL(dtgex2)(WANTQ,
                        WANTZ,
                        N,
                        A,
                        LDA,
                        B,
                        LDB,
                        Q,
                        LDQ,
                        Z,
                        LDZ,
                        J1,
                        N1,
                        N2,
                        WORK,
                        LWORK,
                        INFO);
}

//-- dtgexc --------------------------------------------------------------------
void
LAPACK_DECL(dtgexc)(const LOGICAL    *WANTQ,
                    const LOGICAL    *WANTZ,
                    const INTEGER    *N,
                    DOUBLE           *A,
                    const INTEGER    *LDA,
                    DOUBLE           *B,
                    const INTEGER    *LDB,
                    DOUBLE           *Q,
                    const INTEGER    *LDQ,
                    DOUBLE           *Z,
                    const INTEGER    *LDZ,
                    INTEGER          *IFST,
                    INTEGER          *ILST,
                    DOUBLE           *WORK,
                    const INTEGER    *LWORK,
                    INTEGER          *INFO)
{
    DEBUG_LAPACK_STUB("dtgexc");
    LAPACK_IMPL(dtgexc)(WANTQ,
                        WANTZ,
                        N,
                        A,
                        LDA,
                        B,
                        LDB,
                        Q,
                        LDQ,
                        Z,
                        LDZ,
                        IFST,
                        ILST,
                        WORK,
                        LWORK,
                        INFO);
}

//-- dtgsen --------------------------------------------------------------------
void
LAPACK_DECL(dtgsen)(const INTEGER    *IJOB,
                    const LOGICAL    *WANTQ,
                    const LOGICAL    *WANTZ,
                    const LOGICAL    *SELECT,
                    const INTEGER    *N,
                    DOUBLE           *A,
                    const INTEGER    *LDA,
                    DOUBLE           *B,
                    const INTEGER    *LDB,
                    DOUBLE           *ALPHAR,
                    DOUBLE           *ALPHAI,
                    DOUBLE           *BETA,
                    DOUBLE           *Q,
                    const INTEGER    *LDQ,
                    DOUBLE           *Z,
                    const INTEGER    *LDZ,
                    INTEGER          *M,
                    DOUBLE           *PL,
                    DOUBLE           *PR,
                    DOUBLE           *DIF,
                    DOUBLE           *WORK,
                    const INTEGER    *LWORK,
                    INTEGER          *IWORK,
                    const INTEGER    *LIWORK,
                    INTEGER          *INFO)
{
    DEBUG_LAPACK_STUB("dtgsen");
    LAPACK_IMPL(dtgsen)(IJOB,
                        WANTQ,
                        WANTZ,
                        SELECT,
                        N,
                        A,
                        LDA,
                        B,
                        LDB,
                        ALPHAR,
                        ALPHAI,
                        BETA,
                        Q,
                        LDQ,
                        Z,
                        LDZ,
                        M,
                        PL,
                        PR,
                        DIF,
                        WORK,
                        LWORK,
                        IWORK,
                        LIWORK,
                        INFO);
}

//-- dtgsja --------------------------------------------------------------------
void
LAPACK_DECL(dtgsja)(const char       *JOBU,
                    const char       *JOBV,
                    const char       *JOBQ,
                    const INTEGER    *M,
                    const INTEGER    *P,
                    const INTEGER    *N,
                    const INTEGER    *K,
                    const INTEGER    *L,
                    DOUBLE           *A,
                    const INTEGER    *LDA,
                    DOUBLE           *B,
                    const INTEGER    *LDB,
                    const DOUBLE     *TOLA,
                    const DOUBLE     *TOLB,
                    DOUBLE           *ALPHA,
                    DOUBLE           *BETA,
                    DOUBLE           *U,
                    const INTEGER    *LDU,
                    DOUBLE           *V,
                    const INTEGER    *LDV,
                    DOUBLE           *Q,
                    const INTEGER    *LDQ,
                    DOUBLE           *WORK,
                    INTEGER          *NCYCLE,
                    INTEGER          *INFO)
{
    DEBUG_LAPACK_STUB("dtgsja");
    LAPACK_IMPL(dtgsja)(JOBU,
                        JOBV,
                        JOBQ,
                        M,
                        P,
                        N,
                        K,
                        L,
                        A,
                        LDA,
                        B,
                        LDB,
                        TOLA,
                        TOLB,
                        ALPHA,
                        BETA,
                        U,
                        LDU,
                        V,
                        LDV,
                        Q,
                        LDQ,
                        WORK,
                        NCYCLE,
                        INFO);
}

//-- dtgsna --------------------------------------------------------------------
void
LAPACK_DECL(dtgsna)(const char       *JOB,
                    const char       *HOWMNY,
                    const LOGICAL    *SELECT,
                    const INTEGER    *N,
                    const DOUBLE     *A,
                    const INTEGER    *LDA,
                    const DOUBLE     *B,
                    const INTEGER    *LDB,
                    const DOUBLE     *VL,
                    const INTEGER    *LDVL,
                    const DOUBLE     *VR,
                    const INTEGER    *LDVR,
                    DOUBLE           *S,
                    DOUBLE           *DIF,
                    const INTEGER    *MM,
                    INTEGER          *M,
                    DOUBLE           *WORK,
                    const INTEGER    *LWORK,
                    INTEGER          *IWORK,
                    INTEGER          *INFO)
{
    DEBUG_LAPACK_STUB("dtgsna");
    LAPACK_IMPL(dtgsna)(JOB,
                        HOWMNY,
                        SELECT,
                        N,
                        A,
                        LDA,
                        B,
                        LDB,
                        VL,
                        LDVL,
                        VR,
                        LDVR,
                        S,
                        DIF,
                        MM,
                        M,
                        WORK,
                        LWORK,
                        IWORK,
                        INFO);
}

//-- dtgsy2 --------------------------------------------------------------------
void
LAPACK_DECL(dtgsy2)(const char       *TRANS,
                    const INTEGER    *IJOB,
                    const INTEGER    *M,
                    const INTEGER    *N,
                    const DOUBLE     *A,
                    const INTEGER    *LDA,
                    const DOUBLE     *B,
                    const INTEGER    *LDB,
                    DOUBLE           *C,
                    const INTEGER    *LDC,
                    const DOUBLE     *D,
                    const INTEGER    *LDD,
                    const DOUBLE     *E,
                    const INTEGER    *LDE,
                    DOUBLE           *F,
                    const INTEGER    *LDF,
                    DOUBLE           *SCALE,
                    DOUBLE           *RDSUM,
                    DOUBLE           *RDSCAL,
                    INTEGER          *IWORK,
                    INTEGER          *PQ,
                    INTEGER          *INFO)
{
    DEBUG_LAPACK_STUB("dtgsy2");
    LAPACK_IMPL(dtgsy2)(TRANS,
                        IJOB,
                        M,
                        N,
                        A,
                        LDA,
                        B,
                        LDB,
                        C,
                        LDC,
                        D,
                        LDD,
                        E,
                        LDE,
                        F,
                        LDF,
                        SCALE,
                        RDSUM,
                        RDSCAL,
                        IWORK,
                        PQ,
                        INFO);
}

//-- dtgsyl --------------------------------------------------------------------
void
LAPACK_DECL(dtgsyl)(const char       *TRANS,
                    const INTEGER    *IJOB,
                    const INTEGER    *M,
                    const INTEGER    *N,
                    const DOUBLE     *A,
                    const INTEGER    *LDA,
                    const DOUBLE     *B,
                    const INTEGER    *LDB,
                    DOUBLE           *C,
                    const INTEGER    *LDC,
                    const DOUBLE     *D,
                    const INTEGER    *LDD,
                    const DOUBLE     *E,
                    const INTEGER    *LDE,
                    DOUBLE           *F,
                    const INTEGER    *LDF,
                    DOUBLE           *SCALE,
                    DOUBLE           *DIF,
                    DOUBLE           *WORK,
                    const INTEGER    *LWORK,
                    INTEGER          *IWORK,
                    INTEGER          *INFO)
{
    DEBUG_LAPACK_STUB("dtgsyl");
    LAPACK_IMPL(dtgsyl)(TRANS,
                        IJOB,
                        M,
                        N,
                        A,
                        LDA,
                        B,
                        LDB,
                        C,
                        LDC,
                        D,
                        LDD,
                        E,
                        LDE,
                        F,
                        LDF,
                        SCALE,
                        DIF,
                        WORK,
                        LWORK,
                        IWORK,
                        INFO);
}

//-- dtpcon --------------------------------------------------------------------
void
LAPACK_DECL(dtpcon)(const char       *NORM,
                    const char       *UPLO,
                    const char       *DIAG,
                    const INTEGER    *N,
                    const DOUBLE     *AP,
                    DOUBLE           *RCOND,
                    DOUBLE           *WORK,
                    INTEGER          *IWORK,
                    INTEGER          *INFO)
{
    DEBUG_LAPACK_STUB("dtpcon");
    LAPACK_IMPL(dtpcon)(NORM,
                        UPLO,
                        DIAG,
                        N,
                        AP,
                        RCOND,
                        WORK,
                        IWORK,
                        INFO);
}

//-- dtprfs --------------------------------------------------------------------
void
LAPACK_DECL(dtprfs)(const char       *UPLO,
                    const char       *TRANS,
                    const char       *DIAG,
                    const INTEGER    *N,
                    const INTEGER    *NRHS,
                    const DOUBLE     *AP,
                    const DOUBLE     *B,
                    const INTEGER    *LDB,
                    const DOUBLE     *X,
                    const INTEGER    *LDX,
                    DOUBLE           *FERR,
                    DOUBLE           *BERR,
                    DOUBLE           *WORK,
                    INTEGER          *IWORK,
                    INTEGER          *INFO)
{
    DEBUG_LAPACK_STUB("dtprfs");
    LAPACK_IMPL(dtprfs)(UPLO,
                        TRANS,
                        DIAG,
                        N,
                        NRHS,
                        AP,
                        B,
                        LDB,
                        X,
                        LDX,
                        FERR,
                        BERR,
                        WORK,
                        IWORK,
                        INFO);
}

//-- dtptri --------------------------------------------------------------------
void
LAPACK_DECL(dtptri)(const char       *UPLO,
                    const char       *DIAG,
                    const INTEGER    *N,
                    DOUBLE           *AP,
                    INTEGER          *INFO)
{
    DEBUG_LAPACK_STUB("dtptri");
    LAPACK_IMPL(dtptri)(UPLO,
                        DIAG,
                        N,
                        AP,
                        INFO);
}

//-- dtptrs --------------------------------------------------------------------
void
LAPACK_DECL(dtptrs)(const char       *UPLO,
                    const char       *TRANS,
                    const char       *DIAG,
                    const INTEGER    *N,
                    const INTEGER    *NRHS,
                    const DOUBLE     *AP,
                    DOUBLE           *B,
                    const INTEGER    *LDB,
                    INTEGER          *INFO)
{
    DEBUG_LAPACK_STUB("dtptrs");
    LAPACK_IMPL(dtptrs)(UPLO,
                        TRANS,
                        DIAG,
                        N,
                        NRHS,
                        AP,
                        B,
                        LDB,
                        INFO);
}

//-- dtpttf --------------------------------------------------------------------
void
LAPACK_DECL(dtpttf)(const char       *TRANSR,
                    const char       *UPLO,
                    const INTEGER    *N,
                    const DOUBLE     *AP,
                    DOUBLE           *ARF,
                    INTEGER          *INFO)
{
    DEBUG_LAPACK_STUB("dtpttf");
    LAPACK_IMPL(dtpttf)(TRANSR,
                        UPLO,
                        N,
                        AP,
                        ARF,
                        INFO);
}

//-- dtpttr --------------------------------------------------------------------
void
LAPACK_DECL(dtpttr)(const char       *UPLO,
                    const INTEGER    *N,
                    const DOUBLE     *AP,
                    DOUBLE           *A,
                    const INTEGER    *LDA,
                    INTEGER          *INFO)
{
    DEBUG_LAPACK_STUB("dtpttr");
    LAPACK_IMPL(dtpttr)(UPLO,
                        N,
                        AP,
                        A,
                        LDA,
                        INFO);
}

//-- dtrcon --------------------------------------------------------------------
void
LAPACK_DECL(dtrcon)(const char       *NORM,
                    const char       *UPLO,
                    const char       *DIAG,
                    const INTEGER    *N,
                    const DOUBLE     *A,
                    const INTEGER    *LDA,
                    DOUBLE           *RCOND,
                    DOUBLE           *WORK,
                    INTEGER          *IWORK,
                    INTEGER          *INFO)
{
    DEBUG_LAPACK_STUB("dtrcon");
    LAPACK_IMPL(dtrcon)(NORM,
                        UPLO,
                        DIAG,
                        N,
                        A,
                        LDA,
                        RCOND,
                        WORK,
                        IWORK,
                        INFO);
}

//-- dtrevc --------------------------------------------------------------------
void
LAPACK_DECL(dtrevc)(const char       *SIDE,
                    const char       *HOWMNY,
                    LOGICAL          *SELECT,
                    const INTEGER    *N,
                    const DOUBLE     *T,
                    const INTEGER    *LDT,
                    DOUBLE           *VL,
                    const INTEGER    *LDVL,
                    DOUBLE           *VR,
                    const INTEGER    *LDVR,
                    const INTEGER    *MM,
                    INTEGER          *M,
                    DOUBLE           *WORK,
                    INTEGER          *INFO)
{
    DEBUG_LAPACK_STUB("dtrevc");
    LAPACK_IMPL(dtrevc)(SIDE,
                        HOWMNY,
                        SELECT,
                        N,
                        T,
                        LDT,
                        VL,
                        LDVL,
                        VR,
                        LDVR,
                        MM,
                        M,
                        WORK,
                        INFO);
}

//-- dtrexc --------------------------------------------------------------------
void
LAPACK_DECL(dtrexc)(const char       *COMPQ,
                    const INTEGER    *N,
                    DOUBLE           *T,
                    const INTEGER    *LDT,
                    DOUBLE           *Q,
                    const INTEGER    *LDQ,
                    INTEGER          *IFST,
                    INTEGER          *ILST,
                    DOUBLE           *WORK,
                    INTEGER          *INFO)
{
    DEBUG_LAPACK_STUB("dtrexc");
    LAPACK_IMPL(dtrexc)(COMPQ,
                        N,
                        T,
                        LDT,
                        Q,
                        LDQ,
                        IFST,
                        ILST,
                        WORK,
                        INFO);
}

//-- dtrrfs --------------------------------------------------------------------
void
LAPACK_DECL(dtrrfs)(const char       *UPLO,
                    const char       *TRANS,
                    const char       *DIAG,
                    const INTEGER    *N,
                    const INTEGER    *NRHS,
                    const DOUBLE     *A,
                    const INTEGER    *LDA,
                    const DOUBLE     *B,
                    const INTEGER    *LDB,
                    const DOUBLE     *X,
                    const INTEGER    *LDX,
                    DOUBLE           *FERR,
                    DOUBLE           *BERR,
                    DOUBLE           *WORK,
                    INTEGER          *IWORK,
                    INTEGER          *INFO)
{
    DEBUG_LAPACK_STUB("dtrrfs");
    LAPACK_IMPL(dtrrfs)(UPLO,
                        TRANS,
                        DIAG,
                        N,
                        NRHS,
                        A,
                        LDA,
                        B,
                        LDB,
                        X,
                        LDX,
                        FERR,
                        BERR,
                        WORK,
                        IWORK,
                        INFO);
}

//-- dtrsen --------------------------------------------------------------------
void
LAPACK_DECL(dtrsen)(const char       *JOB,
                    const char       *COMPQ,
                    const LOGICAL    *SELECT,
                    const INTEGER    *N,
                    DOUBLE           *T,
                    const INTEGER    *LDT,
                    DOUBLE           *Q,
                    const INTEGER    *LDQ,
                    DOUBLE           *WR,
                    DOUBLE           *WI,
                    INTEGER          *M,
                    DOUBLE           *S,
                    DOUBLE           *SEP,
                    DOUBLE           *WORK,
                    const INTEGER    *LWORK,
                    INTEGER          *IWORK,
                    const INTEGER    *LIWORK,
                    INTEGER          *INFO)
{
    DEBUG_LAPACK_STUB("dtrsen");
    LAPACK_IMPL(dtrsen)(JOB,
                        COMPQ,
                        SELECT,
                        N,
                        T,
                        LDT,
                        Q,
                        LDQ,
                        WR,
                        WI,
                        M,
                        S,
                        SEP,
                        WORK,
                        LWORK,
                        IWORK,
                        LIWORK,
                        INFO);
}

//-- dtrsna --------------------------------------------------------------------
void
LAPACK_DECL(dtrsna)(const char       *JOB,
                    const char       *HOWMNY,
                    const LOGICAL    *SELECT,
                    const INTEGER    *N,
                    const DOUBLE     *T,
                    const INTEGER    *LDT,
                    const DOUBLE     *VL,
                    const INTEGER    *LDVL,
                    const DOUBLE     *VR,
                    const INTEGER    *LDVR,
                    DOUBLE           *S,
                    DOUBLE           *SEP,
                    const INTEGER    *MM,
                    INTEGER          *M,
                    DOUBLE           *WORK,
                    const INTEGER    *LDWORK,
                    INTEGER          *IWORK,
                    INTEGER          *INFO)
{
    DEBUG_LAPACK_STUB("dtrsna");
    LAPACK_IMPL(dtrsna)(JOB,
                        HOWMNY,
                        SELECT,
                        N,
                        T,
                        LDT,
                        VL,
                        LDVL,
                        VR,
                        LDVR,
                        S,
                        SEP,
                        MM,
                        M,
                        WORK,
                        LDWORK,
                        IWORK,
                        INFO);
}

//-- dtrsyl --------------------------------------------------------------------
void
LAPACK_DECL(dtrsyl)(const char       *TRANA,
                    const char       *TRANB,
                    const INTEGER    *ISGN,
                    const INTEGER    *M,
                    const INTEGER    *N,
                    const DOUBLE     *A,
                    const INTEGER    *LDA,
                    const DOUBLE     *B,
                    const INTEGER    *LDB,
                    DOUBLE           *C,
                    const INTEGER    *LDC,
                    DOUBLE           *SCALE,
                    INTEGER          *INFO)
{
    DEBUG_LAPACK_STUB("dtrsyl");
    LAPACK_IMPL(dtrsyl)(TRANA,
                        TRANB,
                        ISGN,
                        M,
                        N,
                        A,
                        LDA,
                        B,
                        LDB,
                        C,
                        LDC,
                        SCALE,
                        INFO);
}

//-- dtrti2 --------------------------------------------------------------------
void
LAPACK_DECL(dtrti2)(const char       *UPLO,
                    const char       *DIAG,
                    const INTEGER    *N,
                    DOUBLE           *A,
                    const INTEGER    *LDA,
                    INTEGER          *INFO)
{
    DEBUG_LAPACK_STUB("dtrti2");
    LAPACK_IMPL(dtrti2)(UPLO,
                        DIAG,
                        N,
                        A,
                        LDA,
                        INFO);
}

//-- dtrtri --------------------------------------------------------------------
void
LAPACK_DECL(dtrtri)(const char       *UPLO,
                    const char       *DIAG,
                    const INTEGER    *N,
                    DOUBLE           *A,
                    const INTEGER    *LDA,
                    INTEGER          *INFO)
{
    DEBUG_LAPACK_STUB("dtrtri");
    LAPACK_IMPL(dtrtri)(UPLO,
                        DIAG,
                        N,
                        A,
                        LDA,
                        INFO);
}

//-- dtrtrs --------------------------------------------------------------------
void
LAPACK_DECL(dtrtrs)(const char       *UPLO,
                    const char       *TRANS,
                    const char       *DIAG,
                    const INTEGER    *N,
                    const INTEGER    *NRHS,
                    const DOUBLE     *A,
                    const INTEGER    *LDA,
                    DOUBLE           *B,
                    const INTEGER    *LDB,
                    INTEGER          *INFO)
{
    DEBUG_LAPACK_STUB("dtrtrs");
    LAPACK_IMPL(dtrtrs)(UPLO,
                        TRANS,
                        DIAG,
                        N,
                        NRHS,
                        A,
                        LDA,
                        B,
                        LDB,
                        INFO);
}

//-- dtrttf --------------------------------------------------------------------
void
LAPACK_DECL(dtrttf)(const char       *TRANSR,
                    const char       *UPLO,
                    const INTEGER    *N,
                    const DOUBLE     *A,
                    const INTEGER    *LDA,
                    DOUBLE           *ARF,
                    INTEGER          *INFO)
{
    DEBUG_LAPACK_STUB("dtrttf");
    LAPACK_IMPL(dtrttf)(TRANSR,
                        UPLO,
                        N,
                        A,
                        LDA,
                        ARF,
                        INFO);
}

//-- dtrttp --------------------------------------------------------------------
void
LAPACK_DECL(dtrttp)(const char       *UPLO,
                    const INTEGER    *N,
                    const DOUBLE     *A,
                    const INTEGER    *LDA,
                    DOUBLE           *AP,
                    INTEGER          *INFO)
{
    DEBUG_LAPACK_STUB("dtrttp");
    LAPACK_IMPL(dtrttp)(UPLO,
                        N,
                        A,
                        LDA,
                        AP,
                        INFO);
}

//-- dtzrqf --------------------------------------------------------------------
void
LAPACK_DECL(dtzrqf)(const INTEGER    *M,
                    const INTEGER    *N,
                    DOUBLE           *A,
                    const INTEGER    *LDA,
                    DOUBLE           *TAU,
                    INTEGER          *INFO)
{
    DEBUG_LAPACK_STUB("dtzrqf");
    LAPACK_IMPL(dtzrqf)(M,
                        N,
                        A,
                        LDA,
                        TAU,
                        INFO);
}

//-- dtzrzf --------------------------------------------------------------------
void
LAPACK_DECL(dtzrzf)(const INTEGER    *M,
                    const INTEGER    *N,
                    DOUBLE           *A,
                    const INTEGER    *LDA,
                    DOUBLE           *TAU,
                    DOUBLE           *WORK,
                    const INTEGER    *LWORK,
                    INTEGER          *INFO)
{
    DEBUG_LAPACK_STUB("dtzrzf");
    LAPACK_IMPL(dtzrzf)(M,
                        N,
                        A,
                        LDA,
                        TAU,
                        WORK,
                        LWORK,
                        INFO);
}

//-- dzsum1 --------------------------------------------------------------------
DOUBLE
LAPACK_DECL(dzsum1)(const INTEGER            *N,
                    const DOUBLE_COMPLEX     *CX,
                    const INTEGER            *INCX)
{
    DEBUG_LAPACK_STUB("dzsum1");
    return LAPACK_IMPL(dzsum1)(N,
                               CX,
                               INCX);
}

//-- icmax1 --------------------------------------------------------------------
INTEGER
LAPACK_DECL(icmax1)(const INTEGER        *N,
                    const FLOAT_COMPLEX  *CX,
                    const INTEGER        *INCX)
{
    DEBUG_LAPACK_STUB("icmax1");
    return LAPACK_IMPL(icmax1)(N,
                               CX,
                               INCX);
}

//-- ieeeck --------------------------------------------------------------------
INTEGER
LAPACK_DECL(ieeeck)(const INTEGER    *ISPEC,
                    const FLOAT      *ZERO,
                    const FLOAT      *ONE)
{
    DEBUG_LAPACK_STUB("ieeeck");
    return LAPACK_IMPL(ieeeck)(ISPEC,
                               ZERO,
                               ONE);
}

//-- ilaclc --------------------------------------------------------------------
INTEGER
LAPACK_DECL(ilaclc)(const INTEGER        *M,
                    const INTEGER        *N,
                    const FLOAT_COMPLEX  *A,
                    const INTEGER        *LDA)
{
    DEBUG_LAPACK_STUB("ilaclc");
    return LAPACK_IMPL(ilaclc)(M,
                               N,
                               A,
                               LDA);
}

//-- ilaclr --------------------------------------------------------------------
INTEGER
LAPACK_DECL(ilaclr)(const INTEGER        *M,
                    const INTEGER        *N,
                    const FLOAT_COMPLEX  *A,
                    const INTEGER        *LDA)
{
    DEBUG_LAPACK_STUB("ilaclr");
    return LAPACK_IMPL(ilaclr)(M,
                               N,
                               A,
                               LDA);
}

//-- iladiag -------------------------------------------------------------------
INTEGER
LAPACK_DECL(iladiag)(const char   *DIAG)
{
    DEBUG_LAPACK_STUB("iladiag");
    return LAPACK_IMPL(iladiag)(DIAG);
}

//-- iladlc --------------------------------------------------------------------
INTEGER
LAPACK_DECL(iladlc)(const INTEGER    *M,
                    const INTEGER    *N,
                    const DOUBLE     *A,
                    const INTEGER    *LDA)
{
    DEBUG_LAPACK_STUB("iladlc");
    return LAPACK_IMPL(iladlc)(M,
                               N,
                               A,
                               LDA);
}

//-- iladlr --------------------------------------------------------------------
INTEGER
LAPACK_DECL(iladlr)(const INTEGER    *M,
                    const INTEGER    *N,
                    const DOUBLE     *A,
                    const INTEGER    *LDA)
{
    DEBUG_LAPACK_STUB("iladlr");
    return LAPACK_IMPL(iladlr)(M,
                               N,
                               A,
                               LDA);
}

//-- ilaprec -------------------------------------------------------------------
INTEGER
LAPACK_DECL(ilaprec)(const char   *PREC)
{
    DEBUG_LAPACK_STUB("ilaprec");
    return LAPACK_IMPL(ilaprec)(PREC);
}

//-- ilaslc --------------------------------------------------------------------
INTEGER
LAPACK_DECL(ilaslc)(const INTEGER    *M,
                    const INTEGER    *N,
                    const FLOAT      *A,
                    const INTEGER    *LDA)
{
    DEBUG_LAPACK_STUB("ilaslc");
    return LAPACK_IMPL(ilaslc)(M,
                               N,
                               A,
                               LDA);
}

//-- ilaslr --------------------------------------------------------------------
INTEGER
LAPACK_DECL(ilaslr)(const INTEGER    *M,
                    const INTEGER    *N,
                    const FLOAT      *A,
                    const INTEGER    *LDA)
{
    DEBUG_LAPACK_STUB("ilaslr");
    return LAPACK_IMPL(ilaslr)(M,
                               N,
                               A,
                               LDA);
}

//-- ilatrans ------------------------------------------------------------------
INTEGER
LAPACK_DECL(ilatrans)(const char       *TRANS)
{
    DEBUG_LAPACK_STUB("ilatrans");
    return LAPACK_IMPL(ilatrans)(TRANS);
}

//-- ilauplo -------------------------------------------------------------------
INTEGER
LAPACK_DECL(ilauplo)(const char   *UPLO)
{
    DEBUG_LAPACK_STUB("ilauplo");
    return LAPACK_IMPL(ilauplo)(UPLO);
}

//-- ilaver --------------------------------------------------------------------
void
LAPACK_DECL(ilaver)(INTEGER  *VERS_MAJOR,
                    INTEGER  *VERS_MINOR,
                    INTEGER  *VERS_PATCH)
{
    DEBUG_LAPACK_STUB("ilaver");
    LAPACK_IMPL(ilaver)(VERS_MAJOR,
                        VERS_MINOR,
                        VERS_PATCH);
}

//-- ilazlc --------------------------------------------------------------------
INTEGER
LAPACK_DECL(ilazlc)(const INTEGER            *M,
                    const INTEGER            *N,
                    const DOUBLE_COMPLEX     *A,
                    const INTEGER            *LDA)
{
    DEBUG_LAPACK_STUB("ilazlc");
    return LAPACK_IMPL(ilazlc)(M,
                               N,
                               A,
                               LDA);
}

//-- ilazlr --------------------------------------------------------------------
INTEGER
LAPACK_DECL(ilazlr)(const INTEGER            *M,
                    const INTEGER            *N,
                    const DOUBLE_COMPLEX     *A,
                    const INTEGER            *LDA)
{
    DEBUG_LAPACK_STUB("ilazlr");
    return LAPACK_IMPL(ilazlr)(M,
                               N,
                               A,
                               LDA);
}

//-- izmax1 --------------------------------------------------------------------
INTEGER
LAPACK_DECL(izmax1)(const INTEGER            *N,
                    const DOUBLE_COMPLEX     *CX,
                    const INTEGER            *INCX)
{
    DEBUG_LAPACK_STUB("izmax1");
    return LAPACK_IMPL(izmax1)(N,
                               CX,
                               INCX);
}

//-- lsamen --------------------------------------------------------------------
LOGICAL
LAPACK_DECL(lsamen)(const INTEGER    *N,
                    const char          *CA,
                    const char          *CB)
{
    DEBUG_LAPACK_STUB("lsamen");
    return LAPACK_IMPL(lsamen)(N,
                               CA,
                               CB);
}

//-- sbbcsd --------------------------------------------------------------------
void
LAPACK_DECL(sbbcsd)(const char       *JOBU1,
                    const char       *JOBU2,
                    const char       *JOBV1T,
                    const char       *JOBV2T,
                    const char       *TRANS,
                    const INTEGER    *M,
                    const INTEGER    *P,
                    const INTEGER    *Q,
                    FLOAT            *THETA,
                    FLOAT            *PHI,
                    FLOAT            *U1,
                    const INTEGER    *LDU1,
                    FLOAT            *U2,
                    const INTEGER    *LDU2,
                    FLOAT            *V1T,
                    const INTEGER    *LDV1T,
                    FLOAT            *V2T,
                    const INTEGER    *LDV2T,
                    FLOAT            *B11D,
                    FLOAT            *B11E,
                    FLOAT            *B12D,
                    FLOAT            *B12E,
                    const FLOAT      *B21D,
                    const FLOAT      *B21E,
                    const FLOAT      *B22D,
                    const FLOAT      *B22E,
                    FLOAT            *WORK,
                    const INTEGER    *LWORK,
                    INTEGER          *INFO)
{
    DEBUG_LAPACK_STUB("sbbcsd");
    LAPACK_IMPL(sbbcsd)(JOBU1,
                        JOBU2,
                        JOBV1T,
                        JOBV2T,
                        TRANS,
                        M,
                        P,
                        Q,
                        THETA,
                        PHI,
                        U1,
                        LDU1,
                        U2,
                        LDU2,
                        V1T,
                        LDV1T,
                        V2T,
                        LDV2T,
                        B11D,
                        B11E,
                        B12D,
                        B12E,
                        B21D,
                        B21E,
                        B22D,
                        B22E,
                        WORK,
                        LWORK,
                        INFO);
}

//-- sbdsdc --------------------------------------------------------------------
void
LAPACK_DECL(sbdsdc)(const char       *UPLO,
                    const char       *COMPQ,
                    const INTEGER    *N,
                    FLOAT            *D,
                    FLOAT            *E,
                    FLOAT            *U,
                    const INTEGER    *LDU,
                    FLOAT            *VT,
                    const INTEGER    *LDVT,
                    FLOAT            *Q,
                    INTEGER          *IQ,
                    FLOAT            *WORK,
                    INTEGER          *IWORK,
                    INTEGER          *INFO)
{
    DEBUG_LAPACK_STUB("sbdsdc");
    LAPACK_IMPL(sbdsdc)(UPLO,
                        COMPQ,
                        N,
                        D,
                        E,
                        U,
                        LDU,
                        VT,
                        LDVT,
                        Q,
                        IQ,
                        WORK,
                        IWORK,
                        INFO);
}

//-- sbdsqr --------------------------------------------------------------------
void
LAPACK_DECL(sbdsqr)(const char       *UPLO,
                    const INTEGER    *N,
                    const INTEGER    *NCVT,
                    const INTEGER    *NRU,
                    const INTEGER    *NCC,
                    FLOAT            *D,
                    FLOAT            *E,
                    FLOAT            *VT,
                    const INTEGER    *LDVT,
                    FLOAT            *U,
                    const INTEGER    *LDU,
                    FLOAT            *C,
                    const INTEGER    *LDC,
                    FLOAT            *WORK,
                    INTEGER          *INFO)
{
    DEBUG_LAPACK_STUB("sbdsqr");
    LAPACK_IMPL(sbdsqr)(UPLO,
                        N,
                        NCVT,
                        NRU,
                        NCC,
                        D,
                        E,
                        VT,
                        LDVT,
                        U,
                        LDU,
                        C,
                        LDC,
                        WORK,
                        INFO);
}

//-- scsum1 --------------------------------------------------------------------
FLOAT
LAPACK_DECL(scsum1)(const INTEGER        *N,
                    const FLOAT_COMPLEX  *CX,
                    const INTEGER        *INCX)
{
    DEBUG_LAPACK_STUB("scsum1");
    return LAPACK_IMPL(scsum1)(N,
                               CX,
                               INCX);
}

//-- sdisna --------------------------------------------------------------------
void
LAPACK_DECL(sdisna)(const char       *JOB,
                    const INTEGER    *M,
                    const INTEGER    *N,
                    const FLOAT      *D,
                    FLOAT            *SEP,
                    INTEGER          *INFO)
{
    DEBUG_LAPACK_STUB("sdisna");
    LAPACK_IMPL(sdisna)(JOB,
                        M,
                        N,
                        D,
                        SEP,
                        INFO);
}

//-- sgbbrd --------------------------------------------------------------------
void
LAPACK_DECL(sgbbrd)(const char       *VECT,
                    const INTEGER    *M,
                    const INTEGER    *N,
                    const INTEGER    *NCC,
                    const INTEGER    *KL,
                    const INTEGER    *KU,
                    FLOAT            *AB,
                    const INTEGER    *LDAB,
                    FLOAT            *D,
                    FLOAT            *E,
                    FLOAT            *Q,
                    const INTEGER    *LDQ,
                    FLOAT            *PT,
                    const INTEGER    *LDPT,
                    FLOAT            *C,
                    const INTEGER    *LDC,
                    FLOAT            *WORK,
                    INTEGER          *INFO)
{
    DEBUG_LAPACK_STUB("sgbbrd");
    LAPACK_IMPL(sgbbrd)(VECT,
                        M,
                        N,
                        NCC,
                        KL,
                        KU,
                        AB,
                        LDAB,
                        D,
                        E,
                        Q,
                        LDQ,
                        PT,
                        LDPT,
                        C,
                        LDC,
                        WORK,
                        INFO);
}

//-- sgbcon --------------------------------------------------------------------
void
LAPACK_DECL(sgbcon)(const char       *NORM,
                    const INTEGER    *N,
                    const INTEGER    *KL,
                    const INTEGER    *KU,
                    const FLOAT      *AB,
                    const INTEGER    *LDAB,
                    const INTEGER    *IPIV,
                    const FLOAT      *ANORM,
                    FLOAT            *RCOND,
                    FLOAT            *WORK,
                    INTEGER          *IWORK,
                    INTEGER          *INFO)
{
    DEBUG_LAPACK_STUB("sgbcon");
    LAPACK_IMPL(sgbcon)(NORM,
                        N,
                        KL,
                        KU,
                        AB,
                        LDAB,
                        IPIV,
                        ANORM,
                        RCOND,
                        WORK,
                        IWORK,
                        INFO);
}

//-- sgbequ --------------------------------------------------------------------
void
LAPACK_DECL(sgbequ)(const INTEGER    *M,
                    const INTEGER    *N,
                    const INTEGER    *KL,
                    const INTEGER    *KU,
                    const FLOAT      *AB,
                    const INTEGER    *LDAB,
                    FLOAT            *R,
                    FLOAT            *C,
                    FLOAT            *ROWCND,
                    FLOAT            *COLCND,
                    FLOAT            *AMAX,
                    INTEGER          *INFO)
{
    DEBUG_LAPACK_STUB("sgbequ");
    LAPACK_IMPL(sgbequ)(M,
                        N,
                        KL,
                        KU,
                        AB,
                        LDAB,
                        R,
                        C,
                        ROWCND,
                        COLCND,
                        AMAX,
                        INFO);
}

//-- sgbequb -------------------------------------------------------------------
void
LAPACK_DECL(sgbequb)(const INTEGER    *M,
                     const INTEGER    *N,
                     const INTEGER    *KL,
                     const INTEGER    *KU,
                     const FLOAT      *AB,
                     const INTEGER    *LDAB,
                     FLOAT            *R,
                     FLOAT            *C,
                     FLOAT            *ROWCND,
                     FLOAT            *COLCND,
                     FLOAT            *AMAX,
                     INTEGER          *INFO)
{
    DEBUG_LAPACK_STUB("sgbequb");
    LAPACK_IMPL(sgbequb)(M,
                         N,
                         KL,
                         KU,
                         AB,
                         LDAB,
                         R,
                         C,
                         ROWCND,
                         COLCND,
                         AMAX,
                         INFO);
}

//-- sgbrfs --------------------------------------------------------------------
void
LAPACK_DECL(sgbrfs)(const char       *TRANS,
                    const INTEGER    *N,
                    const INTEGER    *KL,
                    const INTEGER    *KU,
                    const INTEGER    *NRHS,
                    const FLOAT      *AB,
                    const INTEGER    *LDAB,
                    const FLOAT      *AFB,
                    const INTEGER    *LDAFB,
                    const INTEGER    *IPIV,
                    const FLOAT      *B,
                    const INTEGER    *LDB,
                    FLOAT            *X,
                    const INTEGER    *LDX,
                    FLOAT            *FERR,
                    FLOAT            *BERR,
                    FLOAT            *WORK,
                    INTEGER          *IWORK,
                    INTEGER          *INFO)
{
    DEBUG_LAPACK_STUB("sgbrfs");
    LAPACK_IMPL(sgbrfs)(TRANS,
                        N,
                        KL,
                        KU,
                        NRHS,
                        AB,
                        LDAB,
                        AFB,
                        LDAFB,
                        IPIV,
                        B,
                        LDB,
                        X,
                        LDX,
                        FERR,
                        BERR,
                        WORK,
                        IWORK,
                        INFO);
}

//-- sgbrfsx -------------------------------------------------------------------
void
LAPACK_DECL(sgbrfsx)(const char       *TRANS,
                     const char       *EQUED,
                     const INTEGER    *N,
                     const INTEGER    *KL,
                     const INTEGER    *KU,
                     const INTEGER    *NRHS,
                     const FLOAT      *AB,
                     const INTEGER    *LDAB,
                     const FLOAT      *AFB,
                     const INTEGER    *LDAFB,
                     const INTEGER    *IPIV,
                     FLOAT            *R,
                     FLOAT            *C,
                     const FLOAT      *B,
                     const INTEGER    *LDB,
                     FLOAT            *X,
                     const INTEGER    *LDX,
                     FLOAT            *RCOND,
                     FLOAT            *BERR,
                     const INTEGER    *N_ERR_BNDS,
                     FLOAT            *ERR_BNDS_NORM,
                     FLOAT            *ERR_BNDS_COMP,
                     const INTEGER    *NPARAMS,
                     FLOAT            *PARAMS,
                     FLOAT            *WORK,
                     INTEGER          *IWORK,
                     INTEGER          *INFO)
{
    DEBUG_LAPACK_STUB("sgbrfsx");
    LAPACK_IMPL(sgbrfsx)(TRANS,
                         EQUED,
                         N,
                         KL,
                         KU,
                         NRHS,
                         AB,
                         LDAB,
                         AFB,
                         LDAFB,
                         IPIV,
                         R,
                         C,
                         B,
                         LDB,
                         X,
                         LDX,
                         RCOND,
                         BERR,
                         N_ERR_BNDS,
                         ERR_BNDS_NORM,
                         ERR_BNDS_COMP,
                         NPARAMS,
                         PARAMS,
                         WORK,
                         IWORK,
                         INFO);
}

//-- sgbsv ---------------------------------------------------------------------
void
LAPACK_DECL(sgbsv)(const INTEGER        *N,
                   const INTEGER        *KL,
                   const INTEGER        *KU,
                   const INTEGER        *NRHS,
                   FLOAT                *AB,
                   const INTEGER        *LDAB,
                   INTEGER              *IPIV,
                   FLOAT                *B,
                   const INTEGER        *LDB,
                   INTEGER              *INFO)
{
    DEBUG_LAPACK_STUB("sgbsv");
    LAPACK_IMPL(sgbsv)(N,
                       KL,
                       KU,
                       NRHS,
                       AB,
                       LDAB,
                       IPIV,
                       B,
                       LDB,
                       INFO);
}

//-- sgbsvx --------------------------------------------------------------------
void
LAPACK_DECL(sgbsvx)(const char       *FACT,
                    const char       *TRANS,
                    const INTEGER    *N,
                    const INTEGER    *KL,
                    const INTEGER    *KU,
                    const INTEGER    *NRHS,
                    FLOAT            *AB,
                    const INTEGER    *LDAB,
                    FLOAT            *AFB,
                    const INTEGER    *LDAFB,
                    INTEGER          *IPIV,
                    char             *EQUED,
                    FLOAT            *R,
                    FLOAT            *C,
                    FLOAT            *B,
                    const INTEGER    *LDB,
                    FLOAT            *X,
                    const INTEGER    *LDX,
                    FLOAT            *RCOND,
                    FLOAT            *FERR,
                    FLOAT            *BERR,
                    FLOAT            *WORK,
                    INTEGER          *IWORK,
                    INTEGER          *INFO)
{
    DEBUG_LAPACK_STUB("sgbsvx");
    LAPACK_IMPL(sgbsvx)(FACT,
                        TRANS,
                        N,
                        KL,
                        KU,
                        NRHS,
                        AB,
                        LDAB,
                        AFB,
                        LDAFB,
                        IPIV,
                        EQUED,
                        R,
                        C,
                        B,
                        LDB,
                        X,
                        LDX,
                        RCOND,
                        FERR,
                        BERR,
                        WORK,
                        IWORK,
                        INFO);
}

//-- sgbtf2 --------------------------------------------------------------------
void
LAPACK_DECL(sgbtf2)(const INTEGER    *M,
                    const INTEGER    *N,
                    const INTEGER    *KL,
                    const INTEGER    *KU,
                    FLOAT            *AB,
                    const INTEGER    *LDAB,
                    INTEGER          *IPIV,
                    INTEGER          *INFO)
{
    DEBUG_LAPACK_STUB("sgbtf2");
    LAPACK_IMPL(sgbtf2)(M,
                        N,
                        KL,
                        KU,
                        AB,
                        LDAB,
                        IPIV,
                        INFO);
}

//-- sgbtrf --------------------------------------------------------------------
void
LAPACK_DECL(sgbtrf)(const INTEGER    *M,
                    const INTEGER    *N,
                    const INTEGER    *KL,
                    const INTEGER    *KU,
                    FLOAT            *AB,
                    const INTEGER    *LDAB,
                    INTEGER          *IPIV,
                    INTEGER          *INFO)
{
    DEBUG_LAPACK_STUB("sgbtrf");
    LAPACK_IMPL(sgbtrf)(M,
                        N,
                        KL,
                        KU,
                        AB,
                        LDAB,
                        IPIV,
                        INFO);
}

//-- sgbtrs --------------------------------------------------------------------
void
LAPACK_DECL(sgbtrs)(const char       *TRANS,
                    const INTEGER    *N,
                    const INTEGER    *KL,
                    const INTEGER    *KU,
                    const INTEGER    *NRHS,
                    const FLOAT      *AB,
                    const INTEGER    *LDAB,
                    const INTEGER    *IPIV,
                    FLOAT            *B,
                    const INTEGER    *LDB,
                    INTEGER          *INFO)
{
    DEBUG_LAPACK_STUB("sgbtrs");
    LAPACK_IMPL(sgbtrs)(TRANS,
                        N,
                        KL,
                        KU,
                        NRHS,
                        AB,
                        LDAB,
                        IPIV,
                        B,
                        LDB,
                        INFO);
}

//-- sgebak --------------------------------------------------------------------
void
LAPACK_DECL(sgebak)(const char       *JOB,
                    const char       *SIDE,
                    const INTEGER    *N,
                    const INTEGER    *ILO,
                    const INTEGER    *IHI,
                    const FLOAT      *SCALE,
                    const INTEGER    *M,
                    FLOAT            *V,
                    const INTEGER    *LDV,
                    INTEGER          *INFO)
{
    DEBUG_LAPACK_STUB("sgebak");
    LAPACK_IMPL(sgebak)(JOB,
                        SIDE,
                        N,
                        ILO,
                        IHI,
                        SCALE,
                        M,
                        V,
                        LDV,
                        INFO);
}

//-- sgebal --------------------------------------------------------------------
void
LAPACK_DECL(sgebal)(const char       *JOB,
                    const INTEGER    *N,
                    FLOAT            *A,
                    const INTEGER    *LDA,
                    INTEGER          *ILO,
                    INTEGER          *IHI,
                    FLOAT            *SCALE,
                    INTEGER          *INFO)
{
    DEBUG_LAPACK_STUB("sgebal");
    LAPACK_IMPL(sgebal)(JOB,
                        N,
                        A,
                        LDA,
                        ILO,
                        IHI,
                        SCALE,
                        INFO);
}

//-- sgebd2 --------------------------------------------------------------------
void
LAPACK_DECL(sgebd2)(const INTEGER    *M,
                    const INTEGER    *N,
                    FLOAT            *A,
                    const INTEGER    *LDA,
                    FLOAT            *D,
                    FLOAT            *E,
                    FLOAT            *TAUQ,
                    FLOAT            *TAUP,
                    FLOAT            *WORK,
                    INTEGER          *INFO)
{
    DEBUG_LAPACK_STUB("sgebd2");
    LAPACK_IMPL(sgebd2)(M,
                        N,
                        A,
                        LDA,
                        D,
                        E,
                        TAUQ,
                        TAUP,
                        WORK,
                        INFO);
}

//-- sgebrd --------------------------------------------------------------------
void
LAPACK_DECL(sgebrd)(const INTEGER    *M,
                    const INTEGER    *N,
                    FLOAT            *A,
                    const INTEGER    *LDA,
                    FLOAT            *D,
                    FLOAT            *E,
                    FLOAT            *TAUQ,
                    FLOAT            *TAUP,
                    FLOAT            *WORK,
                    const INTEGER    *LWORK,
                    INTEGER          *INFO)
{
    DEBUG_LAPACK_STUB("sgebrd");
    LAPACK_IMPL(sgebrd)(M,
                        N,
                        A,
                        LDA,
                        D,
                        E,
                        TAUQ,
                        TAUP,
                        WORK,
                        LWORK,
                        INFO);
}

//-- sgecon --------------------------------------------------------------------
void
LAPACK_DECL(sgecon)(const char       *NORM,
                    const INTEGER    *N,
                    const FLOAT      *A,
                    const INTEGER    *LDA,
                    const FLOAT      *ANORM,
                    FLOAT            *RCOND,
                    FLOAT            *WORK,
                    INTEGER          *IWORK,
                    INTEGER          *INFO)
{
    DEBUG_LAPACK_STUB("sgecon");
    LAPACK_IMPL(sgecon)(NORM,
                        N,
                        A,
                        LDA,
                        ANORM,
                        RCOND,
                        WORK,
                        IWORK,
                        INFO);
}

//-- sgeequ --------------------------------------------------------------------
void
LAPACK_DECL(sgeequ)(const INTEGER    *M,
                    const INTEGER    *N,
                    const FLOAT      *A,
                    const INTEGER    *LDA,
                    FLOAT            *R,
                    FLOAT            *C,
                    FLOAT            *ROWCND,
                    FLOAT            *COLCND,
                    FLOAT            *AMAX,
                    INTEGER          *INFO)
{
    DEBUG_LAPACK_STUB("sgeequ");
    LAPACK_IMPL(sgeequ)(M,
                        N,
                        A,
                        LDA,
                        R,
                        C,
                        ROWCND,
                        COLCND,
                        AMAX,
                        INFO);
}

//-- sgeequb -------------------------------------------------------------------
void
LAPACK_DECL(sgeequb)(const INTEGER    *M,
                     const INTEGER    *N,
                     const FLOAT      *A,
                     const INTEGER    *LDA,
                     FLOAT            *R,
                     FLOAT            *C,
                     FLOAT            *ROWCND,
                     FLOAT            *COLCND,
                     FLOAT            *AMAX,
                     INTEGER          *INFO)
{
    DEBUG_LAPACK_STUB("sgeequb");
    LAPACK_IMPL(sgeequb)(M,
                         N,
                         A,
                         LDA,
                         R,
                         C,
                         ROWCND,
                         COLCND,
                         AMAX,
                         INFO);
}

//-- sgees ---------------------------------------------------------------------
void
LAPACK_DECL(sgees)(const char           *JOBVS,
                   const char           *SORT,
                   const LOGICAL        *SELECT,
                   const INTEGER        *N,
                   FLOAT                *A,
                   const INTEGER        *LDA,
                   INTEGER              *SDIM,
                   FLOAT                *WR,
                   FLOAT                *WI,
                   FLOAT                *VS,
                   const INTEGER        *LDVS,
                   FLOAT                *WORK,
                   const INTEGER        *LWORK,
                   LOGICAL              *BWORK,
                   INTEGER              *INFO)
{
    DEBUG_LAPACK_STUB("sgees");
    LAPACK_IMPL(sgees)(JOBVS,
                       SORT,
                       SELECT,
                       N,
                       A,
                       LDA,
                       SDIM,
                       WR,
                       WI,
                       VS,
                       LDVS,
                       WORK,
                       LWORK,
                       BWORK,
                       INFO);
}

//-- sgeesx --------------------------------------------------------------------
void
LAPACK_DECL(sgeesx)(const char       *JOBVS,
                    const char       *SORT,
                    const LOGICAL    *SELECT,
                    const char       *SENSE,
                    const INTEGER    *N,
                    FLOAT            *A,
                    const INTEGER    *LDA,
                    INTEGER          *SDIM,
                    FLOAT            *WR,
                    FLOAT            *WI,
                    FLOAT            *VS,
                    const INTEGER    *LDVS,
                    FLOAT            *RCONDE,
                    FLOAT            *RCONDV,
                    FLOAT            *WORK,
                    const INTEGER    *LWORK,
                    INTEGER          *IWORK,
                    const INTEGER    *LIWORK,
                    LOGICAL          *BWORK,
                    INTEGER          *INFO)
{
    DEBUG_LAPACK_STUB("sgeesx");
    LAPACK_IMPL(sgeesx)(JOBVS,
                        SORT,
                        SELECT,
                        SENSE,
                        N,
                        A,
                        LDA,
                        SDIM,
                        WR,
                        WI,
                        VS,
                        LDVS,
                        RCONDE,
                        RCONDV,
                        WORK,
                        LWORK,
                        IWORK,
                        LIWORK,
                        BWORK,
                        INFO);
}

//-- sgeev ---------------------------------------------------------------------
void
LAPACK_DECL(sgeev)(const char           *JOBVL,
                   const char           *JOBVR,
                   const INTEGER        *N,
                   FLOAT                *A,
                   const INTEGER        *LDA,
                   FLOAT                *WR,
                   FLOAT                *WI,
                   FLOAT                *VL,
                   const INTEGER        *LDVL,
                   FLOAT                *VR,
                   const INTEGER        *LDVR,
                   FLOAT                *WORK,
                   const INTEGER        *LWORK,
                   INTEGER              *INFO)
{
    DEBUG_LAPACK_STUB("sgeev");
    LAPACK_IMPL(sgeev)(JOBVL,
                       JOBVR,
                       N,
                       A,
                       LDA,
                       WR,
                       WI,
                       VL,
                       LDVL,
                       VR,
                       LDVR,
                       WORK,
                       LWORK,
                       INFO);
}

//-- sgeevx --------------------------------------------------------------------
void
LAPACK_DECL(sgeevx)(const char       *BALANC,
                    const char       *JOBVL,
                    const char       *JOBVR,
                    const char       *SENSE,
                    const INTEGER    *N,
                    FLOAT            *A,
                    const INTEGER    *LDA,
                    FLOAT            *WR,
                    FLOAT            *WI,
                    FLOAT            *VL,
                    const INTEGER    *LDVL,
                    FLOAT            *VR,
                    const INTEGER    *LDVR,
                    INTEGER          *ILO,
                    INTEGER          *IHI,
                    FLOAT            *SCALE,
                    FLOAT            *ABNRM,
                    FLOAT            *RCONDE,
                    FLOAT            *RCONDV,
                    FLOAT            *WORK,
                    const INTEGER    *LWORK,
                    INTEGER          *IWORK,
                    INTEGER          *INFO)
{
    DEBUG_LAPACK_STUB("sgeevx");
    LAPACK_IMPL(sgeevx)(BALANC,
                        JOBVL,
                        JOBVR,
                        SENSE,
                        N,
                        A,
                        LDA,
                        WR,
                        WI,
                        VL,
                        LDVL,
                        VR,
                        LDVR,
                        ILO,
                        IHI,
                        SCALE,
                        ABNRM,
                        RCONDE,
                        RCONDV,
                        WORK,
                        LWORK,
                        IWORK,
                        INFO);
}

//-- sgegs ---------------------------------------------------------------------
void
LAPACK_DECL(sgegs)(const char           *JOBVSL,
                   const char           *JOBVSR,
                   const INTEGER        *N,
                   FLOAT                *A,
                   const INTEGER        *LDA,
                   FLOAT                *B,
                   const INTEGER        *LDB,
                   FLOAT                *ALPHAR,
                   FLOAT                *ALPHAI,
                   FLOAT                *BETA,
                   FLOAT                *VSL,
                   const INTEGER        *LDVSL,
                   FLOAT                *VSR,
                   const INTEGER        *LDVSR,
                   FLOAT                *WORK,
                   const INTEGER        *LWORK,
                   INTEGER              *INFO)
{
    DEBUG_LAPACK_STUB("sgegs");
    LAPACK_IMPL(sgegs)(JOBVSL,
                       JOBVSR,
                       N,
                       A,
                       LDA,
                       B,
                       LDB,
                       ALPHAR,
                       ALPHAI,
                       BETA,
                       VSL,
                       LDVSL,
                       VSR,
                       LDVSR,
                       WORK,
                       LWORK,
                       INFO);
}

//-- sgegv ---------------------------------------------------------------------
void
LAPACK_DECL(sgegv)(const char           *JOBVL,
                   const char           *JOBVR,
                   const INTEGER        *N,
                   FLOAT                *A,
                   const INTEGER        *LDA,
                   FLOAT                *B,
                   const INTEGER        *LDB,
                   FLOAT                *ALPHAR,
                   FLOAT                *ALPHAI,
                   FLOAT                *BETA,
                   FLOAT                *VL,
                   const INTEGER        *LDVL,
                   FLOAT                *VR,
                   const INTEGER        *LDVR,
                   FLOAT                *WORK,
                   const INTEGER        *LWORK,
                   INTEGER              *INFO)
{
    DEBUG_LAPACK_STUB("sgegv");
    LAPACK_IMPL(sgegv)(JOBVL,
                       JOBVR,
                       N,
                       A,
                       LDA,
                       B,
                       LDB,
                       ALPHAR,
                       ALPHAI,
                       BETA,
                       VL,
                       LDVL,
                       VR,
                       LDVR,
                       WORK,
                       LWORK,
                       INFO);
}

//-- sgehd2 --------------------------------------------------------------------
void
LAPACK_DECL(sgehd2)(const INTEGER    *N,
                    const INTEGER    *ILO,
                    const INTEGER    *IHI,
                    FLOAT            *A,
                    const INTEGER    *LDA,
                    FLOAT            *TAU,
                    FLOAT            *WORK,
                    INTEGER          *INFO)
{
    DEBUG_LAPACK_STUB("sgehd2");
    LAPACK_IMPL(sgehd2)(N,
                        ILO,
                        IHI,
                        A,
                        LDA,
                        TAU,
                        WORK,
                        INFO);
}

//-- sgehrd --------------------------------------------------------------------
void
LAPACK_DECL(sgehrd)(const INTEGER    *N,
                    const INTEGER    *ILO,
                    const INTEGER    *IHI,
                    FLOAT            *A,
                    const INTEGER    *LDA,
                    FLOAT            *TAU,
                    FLOAT            *WORK,
                    const INTEGER    *LWORK,
                    INTEGER          *INFO)
{
    DEBUG_LAPACK_STUB("sgehrd");
    LAPACK_IMPL(sgehrd)(N,
                        ILO,
                        IHI,
                        A,
                        LDA,
                        TAU,
                        WORK,
                        LWORK,
                        INFO);
}

//-- sgejsv --------------------------------------------------------------------
void
LAPACK_DECL(sgejsv)(const char       *JOBA,
                    const char       *JOBU,
                    const char       *JOBV,
                    const char       *JOBR,
                    const char       *JOBT,
                    const char       *JOBP,
                    const INTEGER    *M,
                    const INTEGER    *N,
                    const FLOAT      *A,
                    const INTEGER    *LDA,
                    const FLOAT      *SVA,
                    const FLOAT      *U,
                    const INTEGER    *LDU,
                    const FLOAT      *V,
                    const INTEGER    *LDV,
                    const FLOAT      *WORK,
                    const INTEGER    *LWORK,
                    const INTEGER    *IWORK,
                    const INTEGER    *INFO)
{
    DEBUG_LAPACK_STUB("sgejsv");
    LAPACK_IMPL(sgejsv)(JOBA,
                        JOBU,
                        JOBV,
                        JOBR,
                        JOBT,
                        JOBP,
                        M,
                        N,
                        A,
                        LDA,
                        SVA,
                        U,
                        LDU,
                        V,
                        LDV,
                        WORK,
                        LWORK,
                        IWORK,
                        INFO);
}

//-- sgelq2 --------------------------------------------------------------------
void
LAPACK_DECL(sgelq2)(const INTEGER    *M,
                    const INTEGER    *N,
                    FLOAT            *A,
                    const INTEGER    *LDA,
                    FLOAT            *TAU,
                    FLOAT            *WORK,
                    INTEGER          *INFO)
{
    DEBUG_LAPACK_STUB("sgelq2");
    LAPACK_IMPL(sgelq2)(M,
                        N,
                        A,
                        LDA,
                        TAU,
                        WORK,
                        INFO);
}

//-- sgelqf --------------------------------------------------------------------
void
LAPACK_DECL(sgelqf)(const INTEGER    *M,
                    const INTEGER    *N,
                    FLOAT            *A,
                    const INTEGER    *LDA,
                    FLOAT            *TAU,
                    FLOAT            *WORK,
                    const INTEGER    *LWORK,
                    INTEGER          *INFO)
{
    DEBUG_LAPACK_STUB("sgelqf");
    LAPACK_IMPL(sgelqf)(M,
                        N,
                        A,
                        LDA,
                        TAU,
                        WORK,
                        LWORK,
                        INFO);
}

//-- sgels ---------------------------------------------------------------------
void
LAPACK_DECL(sgels)(const char           *TRANS,
                   const INTEGER        *M,
                   const INTEGER        *N,
                   const INTEGER        *NRHS,
                   FLOAT                *A,
                   const INTEGER        *LDA,
                   FLOAT                *B,
                   const INTEGER        *LDB,
                   FLOAT                *WORK,
                   const INTEGER        *LWORK,
                   INTEGER              *INFO)
{
    DEBUG_LAPACK_STUB("sgels");
    LAPACK_IMPL(sgels)(TRANS,
                       M,
                       N,
                       NRHS,
                       A,
                       LDA,
                       B,
                       LDB,
                       WORK,
                       LWORK,
                       INFO);
}

//-- sgelsd --------------------------------------------------------------------
void
LAPACK_DECL(sgelsd)(const INTEGER    *M,
                    const INTEGER    *N,
                    const INTEGER    *NRHS,
                    const FLOAT      *A,
                    const INTEGER    *LDA,
                    FLOAT            *B,
                    const INTEGER    *LDB,
                    FLOAT            *S,
                    const FLOAT      *RCOND,
                    INTEGER          *RANK,
                    FLOAT            *WORK,
                    const INTEGER    *LWORK,
                    INTEGER          *IWORK,
                    INTEGER          *INFO)
{
    DEBUG_LAPACK_STUB("sgelsd");
    LAPACK_IMPL(sgelsd)(M,
                        N,
                        NRHS,
                        A,
                        LDA,
                        B,
                        LDB,
                        S,
                        RCOND,
                        RANK,
                        WORK,
                        LWORK,
                        IWORK,
                        INFO);
}

//-- sgelss --------------------------------------------------------------------
void
LAPACK_DECL(sgelss)(const INTEGER    *M,
                    const INTEGER    *N,
                    const INTEGER    *NRHS,
                    FLOAT            *A,
                    const INTEGER    *LDA,
                    FLOAT            *B,
                    const INTEGER    *LDB,
                    FLOAT            *S,
                    const FLOAT      *RCOND,
                    INTEGER          *RANK,
                    FLOAT            *WORK,
                    const INTEGER    *LWORK,
                    INTEGER          *INFO)
{
    DEBUG_LAPACK_STUB("sgelss");
    LAPACK_IMPL(sgelss)(M,
                        N,
                        NRHS,
                        A,
                        LDA,
                        B,
                        LDB,
                        S,
                        RCOND,
                        RANK,
                        WORK,
                        LWORK,
                        INFO);
}

//-- sgelsx --------------------------------------------------------------------
void
LAPACK_DECL(sgelsx)(const INTEGER    *M,
                    const INTEGER    *N,
                    const INTEGER    *NRHS,
                    FLOAT            *A,
                    const INTEGER    *LDA,
                    FLOAT            *B,
                    const INTEGER    *LDB,
                    INTEGER          *JPVT,
                    const FLOAT      *RCOND,
                    INTEGER          *RANK,
                    FLOAT            *WORK,
                    INTEGER          *INFO)
{
    DEBUG_LAPACK_STUB("sgelsx");
    LAPACK_IMPL(sgelsx)(M,
                        N,
                        NRHS,
                        A,
                        LDA,
                        B,
                        LDB,
                        JPVT,
                        RCOND,
                        RANK,
                        WORK,
                        INFO);
}

//-- sgelsy --------------------------------------------------------------------
void
LAPACK_DECL(sgelsy)(const INTEGER    *M,
                    const INTEGER    *N,
                    const INTEGER    *NRHS,
                    FLOAT            *A,
                    const INTEGER    *LDA,
                    FLOAT            *B,
                    const INTEGER    *LDB,
                    INTEGER          *JPVT,
                    const FLOAT      *RCOND,
                    INTEGER          *RANK,
                    FLOAT            *WORK,
                    const INTEGER    *LWORK,
                    INTEGER          *INFO)
{
    DEBUG_LAPACK_STUB("sgelsy");
    LAPACK_IMPL(sgelsy)(M,
                        N,
                        NRHS,
                        A,
                        LDA,
                        B,
                        LDB,
                        JPVT,
                        RCOND,
                        RANK,
                        WORK,
                        LWORK,
                        INFO);
}

//-- sgeql2 --------------------------------------------------------------------
void
LAPACK_DECL(sgeql2)(const INTEGER    *M,
                    const INTEGER    *N,
                    FLOAT            *A,
                    const INTEGER    *LDA,
                    FLOAT            *TAU,
                    FLOAT            *WORK,
                    INTEGER          *INFO)
{
    DEBUG_LAPACK_STUB("sgeql2");
    LAPACK_IMPL(sgeql2)(M,
                        N,
                        A,
                        LDA,
                        TAU,
                        WORK,
                        INFO);
}

//-- sgeqlf --------------------------------------------------------------------
void
LAPACK_DECL(sgeqlf)(const INTEGER    *M,
                    const INTEGER    *N,
                    FLOAT            *A,
                    const INTEGER    *LDA,
                    FLOAT            *TAU,
                    FLOAT            *WORK,
                    const INTEGER    *LWORK,
                    INTEGER          *INFO)
{
    DEBUG_LAPACK_STUB("sgeqlf");
    LAPACK_IMPL(sgeqlf)(M,
                        N,
                        A,
                        LDA,
                        TAU,
                        WORK,
                        LWORK,
                        INFO);
}

//-- sgeqp3 --------------------------------------------------------------------
void
LAPACK_DECL(sgeqp3)(const INTEGER    *M,
                    const INTEGER    *N,
                    FLOAT            *A,
                    const INTEGER    *LDA,
                    INTEGER          *JPVT,
                    FLOAT            *TAU,
                    FLOAT            *WORK,
                    const INTEGER    *LWORK,
                    INTEGER          *INFO)
{
    DEBUG_LAPACK_STUB("sgeqp3");
    LAPACK_IMPL(sgeqp3)(M,
                        N,
                        A,
                        LDA,
                        JPVT,
                        TAU,
                        WORK,
                        LWORK,
                        INFO);
}

//-- sgeqpf --------------------------------------------------------------------
void
LAPACK_DECL(sgeqpf)(const INTEGER    *M,
                    const INTEGER    *N,
                    FLOAT            *A,
                    const INTEGER    *LDA,
                    INTEGER          *JPVT,
                    FLOAT            *TAU,
                    FLOAT            *WORK,
                    INTEGER          *INFO)
{
    DEBUG_LAPACK_STUB("sgeqpf");
    LAPACK_IMPL(sgeqpf)(M,
                        N,
                        A,
                        LDA,
                        JPVT,
                        TAU,
                        WORK,
                        INFO);
}

//-- sgeqr2 --------------------------------------------------------------------
void
LAPACK_DECL(sgeqr2)(const INTEGER    *M,
                    const INTEGER    *N,
                    FLOAT            *A,
                    const INTEGER    *LDA,
                    FLOAT            *TAU,
                    FLOAT            *WORK,
                    INTEGER          *INFO)
{
    DEBUG_LAPACK_STUB("sgeqr2");
    LAPACK_IMPL(sgeqr2)(M,
                        N,
                        A,
                        LDA,
                        TAU,
                        WORK,
                        INFO);
}

//-- sgeqr2p -------------------------------------------------------------------
void
LAPACK_DECL(sgeqr2p)(const INTEGER    *M,
                     const INTEGER    *N,
                     FLOAT            *A,
                     const INTEGER    *LDA,
                     FLOAT            *TAU,
                     FLOAT            *WORK,
                     INTEGER          *INFO)
{
    DEBUG_LAPACK_STUB("sgeqr2p");
    LAPACK_IMPL(sgeqr2p)(M,
                         N,
                         A,
                         LDA,
                         TAU,
                         WORK,
                         INFO);
}

//-- sgeqrf --------------------------------------------------------------------
void
LAPACK_DECL(sgeqrf)(const INTEGER    *M,
                    const INTEGER    *N,
                    FLOAT            *A,
                    const INTEGER    *LDA,
                    FLOAT            *TAU,
                    FLOAT            *WORK,
                    const INTEGER    *LWORK,
                    INTEGER          *INFO)
{
    DEBUG_LAPACK_STUB("sgeqrf");
    LAPACK_IMPL(sgeqrf)(M,
                        N,
                        A,
                        LDA,
                        TAU,
                        WORK,
                        LWORK,
                        INFO);
}

//-- sgeqrfp -------------------------------------------------------------------
void
LAPACK_DECL(sgeqrfp)(const INTEGER    *M,
                     const INTEGER    *N,
                     FLOAT            *A,
                     const INTEGER    *LDA,
                     FLOAT            *TAU,
                     FLOAT            *WORK,
                     const INTEGER    *LWORK,
                     INTEGER          *INFO)
{
    DEBUG_LAPACK_STUB("sgeqrfp");
    LAPACK_IMPL(sgeqrfp)(M,
                         N,
                         A,
                         LDA,
                         TAU,
                         WORK,
                         LWORK,
                         INFO);
}

//-- sgerfs --------------------------------------------------------------------
void
LAPACK_DECL(sgerfs)(const char       *TRANS,
                    const INTEGER    *N,
                    const INTEGER    *NRHS,
                    const FLOAT      *A,
                    const INTEGER    *LDA,
                    const FLOAT      *AF,
                    const INTEGER    *LDAF,
                    const INTEGER    *IPIV,
                    const FLOAT      *B,
                    const INTEGER    *LDB,
                    FLOAT            *X,
                    const INTEGER    *LDX,
                    FLOAT            *FERR,
                    FLOAT            *BERR,
                    FLOAT            *WORK,
                    INTEGER          *IWORK,
                    INTEGER          *INFO)
{
    DEBUG_LAPACK_STUB("sgerfs");
    LAPACK_IMPL(sgerfs)(TRANS,
                        N,
                        NRHS,
                        A,
                        LDA,
                        AF,
                        LDAF,
                        IPIV,
                        B,
                        LDB,
                        X,
                        LDX,
                        FERR,
                        BERR,
                        WORK,
                        IWORK,
                        INFO);
}

//-- sgerfsx -------------------------------------------------------------------
void
LAPACK_DECL(sgerfsx)(const char       *TRANS,
                     const char       *EQUED,
                     const INTEGER    *N,
                     const INTEGER    *NRHS,
                     const FLOAT      *A,
                     const INTEGER    *LDA,
                     const FLOAT      *AF,
                     const INTEGER    *LDAF,
                     const INTEGER    *IPIV,
                     const FLOAT      *R,
                     const FLOAT      *C,
                     const FLOAT      *B,
                     const INTEGER    *LDB,
                     FLOAT            *X,
                     const INTEGER    *LDX,
                     FLOAT            *RCOND,
                     FLOAT            *BERR,
                     const INTEGER    *N_ERR_BNDS,
                     FLOAT            *ERR_BNDS_NORM,
                     FLOAT            *ERR_BNDS_COMP,
                     const INTEGER    *NPARAMS,
                     FLOAT            *PARAMS,
                     FLOAT            *WORK,
                     INTEGER          *IWORK,
                     INTEGER          *INFO)
{
    DEBUG_LAPACK_STUB("sgerfsx");
    LAPACK_IMPL(sgerfsx)(TRANS,
                         EQUED,
                         N,
                         NRHS,
                         A,
                         LDA,
                         AF,
                         LDAF,
                         IPIV,
                         R,
                         C,
                         B,
                         LDB,
                         X,
                         LDX,
                         RCOND,
                         BERR,
                         N_ERR_BNDS,
                         ERR_BNDS_NORM,
                         ERR_BNDS_COMP,
                         NPARAMS,
                         PARAMS,
                         WORK,
                         IWORK,
                         INFO);
}

//-- sgerq2 --------------------------------------------------------------------
void
LAPACK_DECL(sgerq2)(const INTEGER    *M,
                    const INTEGER    *N,
                    FLOAT            *A,
                    const INTEGER    *LDA,
                    FLOAT            *TAU,
                    FLOAT            *WORK,
                    INTEGER          *INFO)
{
    DEBUG_LAPACK_STUB("sgerq2");
    LAPACK_IMPL(sgerq2)(M,
                        N,
                        A,
                        LDA,
                        TAU,
                        WORK,
                        INFO);
}

//-- sgerqf --------------------------------------------------------------------
void
LAPACK_DECL(sgerqf)(const INTEGER    *M,
                    const INTEGER    *N,
                    FLOAT            *A,
                    const INTEGER    *LDA,
                    FLOAT            *TAU,
                    FLOAT            *WORK,
                    const INTEGER    *LWORK,
                    INTEGER          *INFO)
{
    DEBUG_LAPACK_STUB("sgerqf");
    LAPACK_IMPL(sgerqf)(M,
                        N,
                        A,
                        LDA,
                        TAU,
                        WORK,
                        LWORK,
                        INFO);
}

//-- sgesc2 --------------------------------------------------------------------
void
LAPACK_DECL(sgesc2)(const INTEGER    *N,
                    const FLOAT      *A,
                    const INTEGER    *LDA,
                    FLOAT            *RHS,
                    const INTEGER    *IPIV,
                    const INTEGER    *JPIV,
                    FLOAT            *SCALE)
{
    DEBUG_LAPACK_STUB("sgesc2");
    LAPACK_IMPL(sgesc2)(N,
                        A,
                        LDA,
                        RHS,
                        IPIV,
                        JPIV,
                        SCALE);
}

//-- sgesdd --------------------------------------------------------------------
void
LAPACK_DECL(sgesdd)(const char       *JOBZ,
                    const INTEGER    *M,
                    const INTEGER    *N,
                    FLOAT            *A,
                    const INTEGER    *LDA,
                    FLOAT            *S,
                    FLOAT            *U,
                    const INTEGER    *LDU,
                    FLOAT            *VT,
                    const INTEGER    *LDVT,
                    FLOAT            *WORK,
                    const INTEGER    *LWORK,
                    INTEGER          *IWORK,
                    INTEGER          *INFO)
{
    DEBUG_LAPACK_STUB("sgesdd");
    LAPACK_IMPL(sgesdd)(JOBZ,
                        M,
                        N,
                        A,
                        LDA,
                        S,
                        U,
                        LDU,
                        VT,
                        LDVT,
                        WORK,
                        LWORK,
                        IWORK,
                        INFO);
}

//-- sgesv ---------------------------------------------------------------------
void
LAPACK_DECL(sgesv)(const INTEGER        *N,
                   const INTEGER        *NRHS,
                   FLOAT                *A,
                   const INTEGER        *LDA,
                   INTEGER              *IPIV,
                   FLOAT                *B,
                   const INTEGER        *LDB,
                   INTEGER              *INFO)
{
    DEBUG_LAPACK_STUB("sgesv");
    LAPACK_IMPL(sgesv)(N,
                       NRHS,
                       A,
                       LDA,
                       IPIV,
                       B,
                       LDB,
                       INFO);
}

//-- sgesvd --------------------------------------------------------------------
void
LAPACK_DECL(sgesvd)(const char       *JOBU,
                    const char       *JOBVT,
                    const INTEGER    *M,
                    const INTEGER    *N,
                    FLOAT            *A,
                    const INTEGER    *LDA,
                    FLOAT            *S,
                    FLOAT            *U,
                    const INTEGER    *LDU,
                    FLOAT            *VT,
                    const INTEGER    *LDVT,
                    FLOAT            *WORK,
                    const INTEGER    *LWORK,
                    INTEGER          *INFO)
{
    DEBUG_LAPACK_STUB("sgesvd");
    LAPACK_IMPL(sgesvd)(JOBU,
                        JOBVT,
                        M,
                        N,
                        A,
                        LDA,
                        S,
                        U,
                        LDU,
                        VT,
                        LDVT,
                        WORK,
                        LWORK,
                        INFO);
}

//-- sgesvj --------------------------------------------------------------------
void
LAPACK_DECL(sgesvj)(const char       *JOBA,
                    const char       *JOBU,
                    const char       *JOBV,
                    const INTEGER    *M,
                    const INTEGER    *N,
                    FLOAT            *A,
                    const INTEGER    *LDA,
                    FLOAT            *SVA,
                    const INTEGER    *MV,
                    FLOAT            *V,
                    const INTEGER    *LDV,
                    FLOAT            *WORK,
                    const INTEGER    *LWORK,
                    INTEGER          *INFO)
{
    DEBUG_LAPACK_STUB("sgesvj");
    LAPACK_IMPL(sgesvj)(JOBA,
                        JOBU,
                        JOBV,
                        M,
                        N,
                        A,
                        LDA,
                        SVA,
                        MV,
                        V,
                        LDV,
                        WORK,
                        LWORK,
                        INFO);
}

//-- sgesvx --------------------------------------------------------------------
void
LAPACK_DECL(sgesvx)(const char       *FACT,
                    const char       *TRANS,
                    const INTEGER    *N,
                    const INTEGER    *NRHS,
                    FLOAT            *A,
                    const INTEGER    *LDA,
                    FLOAT            *AF,
                    const INTEGER    *LDAF,
                    INTEGER          *IPIV,
                    char             *EQUED,
                    FLOAT            *R,
                    FLOAT            *C,
                    FLOAT            *B,
                    const INTEGER    *LDB,
                    FLOAT            *X,
                    const INTEGER    *LDX,
                    FLOAT            *RCOND,
                    FLOAT            *FERR,
                    FLOAT            *BERR,
                    FLOAT            *WORK,
                    INTEGER          *IWORK,
                    INTEGER          *INFO)
{
    DEBUG_LAPACK_STUB("sgesvx");
    LAPACK_IMPL(sgesvx)(FACT,
                        TRANS,
                        N,
                        NRHS,
                        A,
                        LDA,
                        AF,
                        LDAF,
                        IPIV,
                        EQUED,
                        R,
                        C,
                        B,
                        LDB,
                        X,
                        LDX,
                        RCOND,
                        FERR,
                        BERR,
                        WORK,
                        IWORK,
                        INFO);
}

//-- sgesvxx -------------------------------------------------------------------
void
LAPACK_DECL(sgesvxx)(const char       *FACT,
                     const char       *TRANS,
                     const INTEGER    *N,
                     const INTEGER    *NRHS,
                     FLOAT            *A,
                     const INTEGER    *LDA,
                     FLOAT            *AF,
                     const INTEGER    *LDAF,
                     INTEGER          *IPIV,
                     char             *EQUED,
                     FLOAT            *R,
                     FLOAT            *C,
                     FLOAT            *B,
                     const INTEGER    *LDB,
                     FLOAT            *X,
                     const INTEGER    *LDX,
                     FLOAT            *RCOND,
                     FLOAT            *RPVGRW,
                     FLOAT            *BERR,
                     const INTEGER    *N_ERR_BNDS,
                     FLOAT            *ERR_BNDS_NORM,
                     FLOAT            *ERR_BNDS_COMP,
                     const INTEGER    *NPARAMS,
                     FLOAT            *PARAMS,
                     FLOAT            *WORK,
                     INTEGER          *IWORK,
                     INTEGER          *INFO)
{
    DEBUG_LAPACK_STUB("sgesvxx");
    LAPACK_IMPL(sgesvxx)(FACT,
                         TRANS,
                         N,
                         NRHS,
                         A,
                         LDA,
                         AF,
                         LDAF,
                         IPIV,
                         EQUED,
                         R,
                         C,
                         B,
                         LDB,
                         X,
                         LDX,
                         RCOND,
                         RPVGRW,
                         BERR,
                         N_ERR_BNDS,
                         ERR_BNDS_NORM,
                         ERR_BNDS_COMP,
                         NPARAMS,
                         PARAMS,
                         WORK,
                         IWORK,
                         INFO);
}

//-- sgetc2 --------------------------------------------------------------------
void
LAPACK_DECL(sgetc2)(const INTEGER    *N,
                    FLOAT            *A,
                    const INTEGER    *LDA,
                    INTEGER          *IPIV,
                    INTEGER          *JPIV,
                    INTEGER          *INFO)
{
    DEBUG_LAPACK_STUB("sgetc2");
    LAPACK_IMPL(sgetc2)(N,
                        A,
                        LDA,
                        IPIV,
                        JPIV,
                        INFO);
}

//-- sgetf2 --------------------------------------------------------------------
void
LAPACK_DECL(sgetf2)(const INTEGER    *M,
                    const INTEGER    *N,
                    FLOAT            *A,
                    const INTEGER    *LDA,
                    INTEGER          *IPIV,
                    INTEGER          *INFO)
{
    DEBUG_LAPACK_STUB("sgetf2");
    LAPACK_IMPL(sgetf2)(M,
                        N,
                        A,
                        LDA,
                        IPIV,
                        INFO);
}

//-- sgetrf --------------------------------------------------------------------
void
LAPACK_DECL(sgetrf)(const INTEGER    *M,
                    const INTEGER    *N,
                    FLOAT            *A,
                    const INTEGER    *LDA,
                    INTEGER          *IPIV,
                    INTEGER          *INFO)
{
    DEBUG_LAPACK_STUB("sgetrf");
    LAPACK_IMPL(sgetrf)(M,
                        N,
                        A,
                        LDA,
                        IPIV,
                        INFO);
}

//-- sgetri --------------------------------------------------------------------
void
LAPACK_DECL(sgetri)(const INTEGER    *N,
                    FLOAT            *A,
                    const INTEGER    *LDA,
                    const INTEGER    *IPIV,
                    FLOAT            *WORK,
                    const INTEGER    *LWORK,
                    INTEGER          *INFO)
{
    DEBUG_LAPACK_STUB("sgetri");
    LAPACK_IMPL(sgetri)(N,
                        A,
                        LDA,
                        IPIV,
                        WORK,
                        LWORK,
                        INFO);
}

//-- sgetrs --------------------------------------------------------------------
void
LAPACK_DECL(sgetrs)(const char       *TRANS,
                    const INTEGER    *N,
                    const INTEGER    *NRHS,
                    const FLOAT      *A,
                    const INTEGER    *LDA,
                    const INTEGER    *IPIV,
                    FLOAT            *B,
                    const INTEGER    *LDB,
                    INTEGER          *INFO)
{
    DEBUG_LAPACK_STUB("sgetrs");
    LAPACK_IMPL(sgetrs)(TRANS,
                        N,
                        NRHS,
                        A,
                        LDA,
                        IPIV,
                        B,
                        LDB,
                        INFO);
}

//-- sggbak --------------------------------------------------------------------
void
LAPACK_DECL(sggbak)(const char       *JOB,
                    const char       *SIDE,
                    const INTEGER    *N,
                    const INTEGER    *ILO,
                    const INTEGER    *IHI,
                    const FLOAT      *LSCALE,
                    const FLOAT      *RSCALE,
                    const INTEGER    *M,
                    FLOAT            *V,
                    const INTEGER    *LDV,
                    INTEGER          *INFO)
{
    DEBUG_LAPACK_STUB("sggbak");
    LAPACK_IMPL(sggbak)(JOB,
                        SIDE,
                        N,
                        ILO,
                        IHI,
                        LSCALE,
                        RSCALE,
                        M,
                        V,
                        LDV,
                        INFO);
}

//-- sggbal --------------------------------------------------------------------
void
LAPACK_DECL(sggbal)(const char       *JOB,
                    const INTEGER    *N,
                    FLOAT            *A,
                    const INTEGER    *LDA,
                    FLOAT            *B,
                    const INTEGER    *LDB,
                    INTEGER          *ILO,
                    INTEGER          *IHI,
                    FLOAT            *LSCALE,
                    FLOAT            *RSCALE,
                    FLOAT            *WORK,
                    INTEGER          *INFO)
{
    DEBUG_LAPACK_STUB("sggbal");
    LAPACK_IMPL(sggbal)(JOB,
                        N,
                        A,
                        LDA,
                        B,
                        LDB,
                        ILO,
                        IHI,
                        LSCALE,
                        RSCALE,
                        WORK,
                        INFO);
}

//-- sgges ---------------------------------------------------------------------
void
LAPACK_DECL(sgges)(const char           *JOBVSL,
                   const char           *JOBVSR,
                   const char           *SORT,
                   const LOGICAL        *SELCTG,
                   const INTEGER        *N,
                   FLOAT                *A,
                   const INTEGER        *LDA,
                   FLOAT                *B,
                   const INTEGER        *LDB,
                   INTEGER              *SDIM,
                   FLOAT                *ALPHAR,
                   FLOAT                *ALPHAI,
                   FLOAT                *BETA,
                   FLOAT                *VSL,
                   const INTEGER        *LDVSL,
                   FLOAT                *VSR,
                   const INTEGER        *LDVSR,
                   FLOAT                *WORK,
                   const INTEGER        *LWORK,
                   LOGICAL              *BWORK,
                   INTEGER              *INFO)
{
    DEBUG_LAPACK_STUB("sgges");
    LAPACK_IMPL(sgges)(JOBVSL,
                       JOBVSR,
                       SORT,
                       SELCTG,
                       N,
                       A,
                       LDA,
                       B,
                       LDB,
                       SDIM,
                       ALPHAR,
                       ALPHAI,
                       BETA,
                       VSL,
                       LDVSL,
                       VSR,
                       LDVSR,
                       WORK,
                       LWORK,
                       BWORK,
                       INFO);
}

//-- sggesx --------------------------------------------------------------------
void
LAPACK_DECL(sggesx)(const char       *JOBVSL,
                    const char       *JOBVSR,
                    const char       *SORT,
                    const LOGICAL    *SELCTG,
                    const char       *SENSE,
                    const INTEGER    *N,
                    FLOAT            *A,
                    const INTEGER    *LDA,
                    FLOAT            *B,
                    const INTEGER    *LDB,
                    INTEGER          *SDIM,
                    FLOAT            *ALPHAR,
                    FLOAT            *ALPHAI,
                    FLOAT            *BETA,
                    FLOAT            *VSL,
                    const INTEGER    *LDVSL,
                    FLOAT            *VSR,
                    const INTEGER    *LDVSR,
                    FLOAT            *RCONDE,
                    FLOAT            *RCONDV,
                    FLOAT            *WORK,
                    const INTEGER    *LWORK,
                    INTEGER          *IWORK,
                    const INTEGER    *LIWORK,
                    LOGICAL          *BWORK,
                    INTEGER          *INFO)
{
    DEBUG_LAPACK_STUB("sggesx");
    LAPACK_IMPL(sggesx)(JOBVSL,
                        JOBVSR,
                        SORT,
                        SELCTG,
                        SENSE,
                        N,
                        A,
                        LDA,
                        B,
                        LDB,
                        SDIM,
                        ALPHAR,
                        ALPHAI,
                        BETA,
                        VSL,
                        LDVSL,
                        VSR,
                        LDVSR,
                        RCONDE,
                        RCONDV,
                        WORK,
                        LWORK,
                        IWORK,
                        LIWORK,
                        BWORK,
                        INFO);
}

//-- sggev ---------------------------------------------------------------------
void
LAPACK_DECL(sggev)(const char           *JOBVL,
                   const char           *JOBVR,
                   const INTEGER        *N,
                   FLOAT                *A,
                   const INTEGER        *LDA,
                   FLOAT                *B,
                   const INTEGER        *LDB,
                   FLOAT                *ALPHAR,
                   FLOAT                *ALPHAI,
                   FLOAT                *BETA,
                   FLOAT                *VL,
                   const INTEGER        *LDVL,
                   FLOAT                *VR,
                   const INTEGER        *LDVR,
                   FLOAT                *WORK,
                   const INTEGER        *LWORK,
                   INTEGER              *INFO)
{
    DEBUG_LAPACK_STUB("sggev");
    LAPACK_IMPL(sggev)(JOBVL,
                       JOBVR,
                       N,
                       A,
                       LDA,
                       B,
                       LDB,
                       ALPHAR,
                       ALPHAI,
                       BETA,
                       VL,
                       LDVL,
                       VR,
                       LDVR,
                       WORK,
                       LWORK,
                       INFO);
}

//-- sggevx --------------------------------------------------------------------
void
LAPACK_DECL(sggevx)(const char       *BALANC,
                    const char       *JOBVL,
                    const char       *JOBVR,
                    const char       *SENSE,
                    const INTEGER    *N,
                    FLOAT            *A,
                    const INTEGER    *LDA,
                    FLOAT            *B,
                    const INTEGER    *LDB,
                    FLOAT            *ALPHAR,
                    FLOAT            *ALPHAI,
                    FLOAT            *BETA,
                    FLOAT            *VL,
                    const INTEGER    *LDVL,
                    FLOAT            *VR,
                    const INTEGER    *LDVR,
                    INTEGER          *ILO,
                    INTEGER          *IHI,
                    FLOAT            *LSCALE,
                    FLOAT            *RSCALE,
                    FLOAT            *ABNRM,
                    FLOAT            *BBNRM,
                    FLOAT            *RCONDE,
                    FLOAT            *RCONDV,
                    FLOAT            *WORK,
                    const INTEGER    *LWORK,
                    INTEGER          *IWORK,
                    LOGICAL          *BWORK,
                    INTEGER          *INFO)
{
    DEBUG_LAPACK_STUB("sggevx");
    LAPACK_IMPL(sggevx)(BALANC,
                        JOBVL,
                        JOBVR,
                        SENSE,
                        N,
                        A,
                        LDA,
                        B,
                        LDB,
                        ALPHAR,
                        ALPHAI,
                        BETA,
                        VL,
                        LDVL,
                        VR,
                        LDVR,
                        ILO,
                        IHI,
                        LSCALE,
                        RSCALE,
                        ABNRM,
                        BBNRM,
                        RCONDE,
                        RCONDV,
                        WORK,
                        LWORK,
                        IWORK,
                        BWORK,
                        INFO);
}

//-- sggglm --------------------------------------------------------------------
void
LAPACK_DECL(sggglm)(const INTEGER    *N,
                    const INTEGER    *M,
                    const INTEGER    *P,
                    FLOAT            *A,
                    const INTEGER    *LDA,
                    FLOAT            *B,
                    const INTEGER    *LDB,
                    FLOAT            *D,
                    FLOAT            *X,
                    FLOAT            *Y,
                    FLOAT            *WORK,
                    const INTEGER    *LWORK,
                    INTEGER          *INFO)
{
    DEBUG_LAPACK_STUB("sggglm");
    LAPACK_IMPL(sggglm)(N,
                        M,
                        P,
                        A,
                        LDA,
                        B,
                        LDB,
                        D,
                        X,
                        Y,
                        WORK,
                        LWORK,
                        INFO);
}

//-- sgghrd --------------------------------------------------------------------
void
LAPACK_DECL(sgghrd)(const char       *COMPQ,
                    const char       *COMPZ,
                    const INTEGER    *N,
                    const INTEGER    *ILO,
                    const INTEGER    *IHI,
                    FLOAT            *A,
                    const INTEGER    *LDA,
                    FLOAT            *B,
                    const INTEGER    *LDB,
                    FLOAT            *Q,
                    const INTEGER    *LDQ,
                    FLOAT            *Z,
                    const INTEGER    *LDZ,
                    INTEGER          *INFO)
{
    DEBUG_LAPACK_STUB("sgghrd");
    LAPACK_IMPL(sgghrd)(COMPQ,
                        COMPZ,
                        N,
                        ILO,
                        IHI,
                        A,
                        LDA,
                        B,
                        LDB,
                        Q,
                        LDQ,
                        Z,
                        LDZ,
                        INFO);
}

//-- sgglse --------------------------------------------------------------------
void
LAPACK_DECL(sgglse)(const INTEGER    *M,
                    const INTEGER    *N,
                    const INTEGER    *P,
                    FLOAT            *A,
                    const INTEGER    *LDA,
                    FLOAT            *B,
                    const INTEGER    *LDB,
                    FLOAT            *C,
                    FLOAT            *D,
                    FLOAT            *X,
                    FLOAT            *WORK,
                    const INTEGER    *LWORK,
                    INTEGER          *INFO)
{
    DEBUG_LAPACK_STUB("sgglse");
    LAPACK_IMPL(sgglse)(M,
                        N,
                        P,
                        A,
                        LDA,
                        B,
                        LDB,
                        C,
                        D,
                        X,
                        WORK,
                        LWORK,
                        INFO);
}

//-- sggqrf --------------------------------------------------------------------
void
LAPACK_DECL(sggqrf)(const INTEGER    *N,
                    const INTEGER    *M,
                    const INTEGER    *P,
                    FLOAT            *A,
                    const INTEGER    *LDA,
                    FLOAT            *TAUA,
                    FLOAT            *B,
                    const INTEGER    *LDB,
                    FLOAT            *TAUB,
                    FLOAT            *WORK,
                    const INTEGER    *LWORK,
                    INTEGER          *INFO)
{
    DEBUG_LAPACK_STUB("sggqrf");
    LAPACK_IMPL(sggqrf)(N,
                        M,
                        P,
                        A,
                        LDA,
                        TAUA,
                        B,
                        LDB,
                        TAUB,
                        WORK,
                        LWORK,
                        INFO);
}

//-- sggrqf --------------------------------------------------------------------
void
LAPACK_DECL(sggrqf)(const INTEGER    *M,
                    const INTEGER    *P,
                    const INTEGER    *N,
                    FLOAT            *A,
                    const INTEGER    *LDA,
                    FLOAT            *TAUA,
                    FLOAT            *B,
                    const INTEGER    *LDB,
                    FLOAT            *TAUB,
                    FLOAT            *WORK,
                    const INTEGER    *LWORK,
                    INTEGER          *INFO)
{
    DEBUG_LAPACK_STUB("sggrqf");
    LAPACK_IMPL(sggrqf)(M,
                        P,
                        N,
                        A,
                        LDA,
                        TAUA,
                        B,
                        LDB,
                        TAUB,
                        WORK,
                        LWORK,
                        INFO);
}

//-- sggsvd --------------------------------------------------------------------
void
LAPACK_DECL(sggsvd)(const char       *JOBU,
                    const char       *JOBV,
                    const char       *JOBQ,
                    const INTEGER    *M,
                    const INTEGER    *N,
                    const INTEGER    *P,
                    INTEGER          *K,
                    INTEGER          *L,
                    FLOAT            *A,
                    const INTEGER    *LDA,
                    FLOAT            *B,
                    const INTEGER    *LDB,
                    FLOAT            *ALPHA,
                    FLOAT            *BETA,
                    FLOAT            *U,
                    const INTEGER    *LDU,
                    FLOAT            *V,
                    const INTEGER    *LDV,
                    FLOAT            *Q,
                    const INTEGER    *LDQ,
                    FLOAT            *WORK,
                    INTEGER          *IWORK,
                    INTEGER          *INFO)
{
    DEBUG_LAPACK_STUB("sggsvd");
    LAPACK_IMPL(sggsvd)(JOBU,
                        JOBV,
                        JOBQ,
                        M,
                        N,
                        P,
                        K,
                        L,
                        A,
                        LDA,
                        B,
                        LDB,
                        ALPHA,
                        BETA,
                        U,
                        LDU,
                        V,
                        LDV,
                        Q,
                        LDQ,
                        WORK,
                        IWORK,
                        INFO);
}

//-- sggsvp --------------------------------------------------------------------
void
LAPACK_DECL(sggsvp)(const char       *JOBU,
                    const char       *JOBV,
                    const char       *JOBQ,
                    const INTEGER    *M,
                    const INTEGER    *P,
                    const INTEGER    *N,
                    FLOAT            *A,
                    const INTEGER    *LDA,
                    FLOAT            *B,
                    const INTEGER    *LDB,
                    const FLOAT      *TOLA,
                    const FLOAT      *TOLB,
                    INTEGER          *K,
                    INTEGER          *L,
                    FLOAT            *U,
                    const INTEGER    *LDU,
                    FLOAT            *V,
                    const INTEGER    *LDV,
                    FLOAT            *Q,
                    const INTEGER    *LDQ,
                    INTEGER          *IWORK,
                    FLOAT            *TAU,
                    FLOAT            *WORK,
                    INTEGER          *INFO)
{
    DEBUG_LAPACK_STUB("sggsvp");
    LAPACK_IMPL(sggsvp)(JOBU,
                        JOBV,
                        JOBQ,
                        M,
                        P,
                        N,
                        A,
                        LDA,
                        B,
                        LDB,
                        TOLA,
                        TOLB,
                        K,
                        L,
                        U,
                        LDU,
                        V,
                        LDV,
                        Q,
                        LDQ,
                        IWORK,
                        TAU,
                        WORK,
                        INFO);
}

//-- sgsvj0 --------------------------------------------------------------------
void
LAPACK_DECL(sgsvj0)(const char       *JOBV,
                    const INTEGER    *M,
                    const INTEGER    *N,
                    FLOAT            *A,
                    const INTEGER    *LDA,
                    FLOAT            *D,
                    FLOAT            *SVA,
                    const INTEGER    *MV,
                    FLOAT            *V,
                    const INTEGER    *LDV,
                    const FLOAT      *EPS,
                    const FLOAT      *SFMIN,
                    const FLOAT      *TOL,
                    const INTEGER    *NSWEEP,
                    FLOAT            *WORK,
                    const INTEGER    *LWORK,
                    INTEGER          *INFO)
{
    DEBUG_LAPACK_STUB("sgsvj0");
    LAPACK_IMPL(sgsvj0)(JOBV,
                        M,
                        N,
                        A,
                        LDA,
                        D,
                        SVA,
                        MV,
                        V,
                        LDV,
                        EPS,
                        SFMIN,
                        TOL,
                        NSWEEP,
                        WORK,
                        LWORK,
                        INFO);
}

//-- sgsvj1 --------------------------------------------------------------------
void
LAPACK_DECL(sgsvj1)(const char       *JOBV,
                    const INTEGER    *M,
                    const INTEGER    *N,
                    const INTEGER    *N1,
                    FLOAT            *A,
                    const INTEGER    *LDA,
                    FLOAT            *D,
                    FLOAT            *SVA,
                    const INTEGER    *MV,
                    FLOAT            *V,
                    const INTEGER    *LDV,
                    const FLOAT      *EPS,
                    const FLOAT      *SFMIN,
                    const FLOAT      *TOL,
                    const INTEGER    *NSWEEP,
                    FLOAT            *WORK,
                    const INTEGER    *LWORK,
                    INTEGER          *INFO)
{
    DEBUG_LAPACK_STUB("sgsvj1");
    LAPACK_IMPL(sgsvj1)(JOBV,
                        M,
                        N,
                        N1,
                        A,
                        LDA,
                        D,
                        SVA,
                        MV,
                        V,
                        LDV,
                        EPS,
                        SFMIN,
                        TOL,
                        NSWEEP,
                        WORK,
                        LWORK,
                        INFO);
}

//-- sgtcon --------------------------------------------------------------------
void
LAPACK_DECL(sgtcon)(const char       *NORM,
                    const INTEGER    *N,
                    const FLOAT      *DL,
                    const FLOAT      *D,
                    const FLOAT      *DU,
                    const FLOAT      *DU2,
                    const INTEGER    *IPIV,
                    const FLOAT      *ANORM,
                    FLOAT            *RCOND,
                    FLOAT            *WORK,
                    INTEGER          *IWORK,
                    INTEGER          *INFO)
{
    DEBUG_LAPACK_STUB("sgtcon");
    LAPACK_IMPL(sgtcon)(NORM,
                        N,
                        DL,
                        D,
                        DU,
                        DU2,
                        IPIV,
                        ANORM,
                        RCOND,
                        WORK,
                        IWORK,
                        INFO);
}

//-- sgtrfs --------------------------------------------------------------------
void
LAPACK_DECL(sgtrfs)(const char       *TRANS,
                    const INTEGER    *N,
                    const INTEGER    *NRHS,
                    const FLOAT      *DL,
                    const FLOAT      *D,
                    const FLOAT      *DU,
                    const FLOAT      *DLF,
                    const FLOAT      *DF,
                    const FLOAT      *DUF,
                    const FLOAT      *DU2,
                    const INTEGER    *IPIV,
                    const FLOAT      *B,
                    const INTEGER    *LDB,
                    FLOAT            *X,
                    const INTEGER    *LDX,
                    FLOAT            *FERR,
                    FLOAT            *BERR,
                    FLOAT            *WORK,
                    INTEGER          *IWORK,
                    INTEGER          *INFO)
{
    DEBUG_LAPACK_STUB("sgtrfs");
    LAPACK_IMPL(sgtrfs)(TRANS,
                        N,
                        NRHS,
                        DL,
                        D,
                        DU,
                        DLF,
                        DF,
                        DUF,
                        DU2,
                        IPIV,
                        B,
                        LDB,
                        X,
                        LDX,
                        FERR,
                        BERR,
                        WORK,
                        IWORK,
                        INFO);
}

//-- sgtsv ---------------------------------------------------------------------
void
LAPACK_DECL(sgtsv)(const INTEGER        *N,
                   const INTEGER        *NRHS,
                   FLOAT                *DL,
                   FLOAT                *D,
                   FLOAT                *DU,
                   FLOAT                *B,
                   const INTEGER        *LDB,
                   INTEGER              *INFO)
{
    DEBUG_LAPACK_STUB("sgtsv");
    LAPACK_IMPL(sgtsv)(N,
                       NRHS,
                       DL,
                       D,
                       DU,
                       B,
                       LDB,
                       INFO);
}

//-- sgtsvx --------------------------------------------------------------------
void
LAPACK_DECL(sgtsvx)(const char       *FACT,
                    const char       *TRANS,
                    const INTEGER    *N,
                    const INTEGER    *NRHS,
                    const FLOAT      *DL,
                    const FLOAT      *D,
                    const FLOAT      *DU,
                    FLOAT            *DLF,
                    FLOAT            *DF,
                    FLOAT            *DUF,
                    FLOAT            *DU2,
                    INTEGER          *IPIV,
                    const FLOAT      *B,
                    const INTEGER    *LDB,
                    FLOAT            *X,
                    const INTEGER    *LDX,
                    FLOAT            *RCOND,
                    FLOAT            *FERR,
                    FLOAT            *BERR,
                    FLOAT            *WORK,
                    INTEGER          *IWORK,
                    INTEGER          *INFO)
{
    DEBUG_LAPACK_STUB("sgtsvx");
    LAPACK_IMPL(sgtsvx)(FACT,
                        TRANS,
                        N,
                        NRHS,
                        DL,
                        D,
                        DU,
                        DLF,
                        DF,
                        DUF,
                        DU2,
                        IPIV,
                        B,
                        LDB,
                        X,
                        LDX,
                        RCOND,
                        FERR,
                        BERR,
                        WORK,
                        IWORK,
                        INFO);
}

//-- sgttrf --------------------------------------------------------------------
void
LAPACK_DECL(sgttrf)(const INTEGER    *N,
                    FLOAT            *DL,
                    FLOAT            *D,
                    FLOAT            *DU,
                    FLOAT            *DU2,
                    INTEGER          *IPIV,
                    INTEGER          *INFO)
{
    DEBUG_LAPACK_STUB("sgttrf");
    LAPACK_IMPL(sgttrf)(N,
                        DL,
                        D,
                        DU,
                        DU2,
                        IPIV,
                        INFO);
}

//-- sgttrs --------------------------------------------------------------------
void
LAPACK_DECL(sgttrs)(const char       *TRANS,
                    const INTEGER    *N,
                    const INTEGER    *NRHS,
                    const FLOAT      *DL,
                    const FLOAT      *D,
                    const FLOAT      *DU,
                    const FLOAT      *DU2,
                    const INTEGER    *IPIV,
                    FLOAT            *B,
                    const INTEGER    *LDB,
                    INTEGER          *INFO)
{
    DEBUG_LAPACK_STUB("sgttrs");
    LAPACK_IMPL(sgttrs)(TRANS,
                        N,
                        NRHS,
                        DL,
                        D,
                        DU,
                        DU2,
                        IPIV,
                        B,
                        LDB,
                        INFO);
}

//-- sgtts2 --------------------------------------------------------------------
void
LAPACK_DECL(sgtts2)(const INTEGER    *ITRANS,
                    const INTEGER    *N,
                    const INTEGER    *NRHS,
                    const FLOAT      *DL,
                    const FLOAT      *D,
                    const FLOAT      *DU,
                    const FLOAT      *DU2,
                    const INTEGER    *IPIV,
                    FLOAT            *B,
                    const INTEGER    *LDB)
{
    DEBUG_LAPACK_STUB("sgtts2");
    LAPACK_IMPL(sgtts2)(ITRANS,
                        N,
                        NRHS,
                        DL,
                        D,
                        DU,
                        DU2,
                        IPIV,
                        B,
                        LDB);
}

//-- shgeqz --------------------------------------------------------------------
void
LAPACK_DECL(shgeqz)(const char       *JOB,
                    const char       *COMPQ,
                    const char       *COMPZ,
                    const INTEGER    *N,
                    const INTEGER    *ILO,
                    const INTEGER    *IHI,
                    FLOAT            *H,
                    const INTEGER    *LDH,
                    FLOAT            *T,
                    const INTEGER    *LDT,
                    FLOAT            *ALPHAR,
                    FLOAT            *ALPHAI,
                    FLOAT            *BETA,
                    FLOAT            *Q,
                    const INTEGER    *LDQ,
                    FLOAT            *Z,
                    const INTEGER    *LDZ,
                    FLOAT            *WORK,
                    const INTEGER    *LWORK,
                    INTEGER          *INFO)
{
    DEBUG_LAPACK_STUB("shgeqz");
    LAPACK_IMPL(shgeqz)(JOB,
                        COMPQ,
                        COMPZ,
                        N,
                        ILO,
                        IHI,
                        H,
                        LDH,
                        T,
                        LDT,
                        ALPHAR,
                        ALPHAI,
                        BETA,
                        Q,
                        LDQ,
                        Z,
                        LDZ,
                        WORK,
                        LWORK,
                        INFO);
}

//-- shsein --------------------------------------------------------------------
void
LAPACK_DECL(shsein)(const char       *SIDE,
                    const char       *EIGSRC,
                    const char       *INITV,
                    LOGICAL          *SELECT,
                    const INTEGER    *N,
                    const FLOAT      *H,
                    const INTEGER    *LDH,
                    FLOAT            *WR,
                    const FLOAT      *WI,
                    FLOAT            *VL,
                    const INTEGER    *LDVL,
                    FLOAT            *VR,
                    const INTEGER    *LDVR,
                    const INTEGER    *MM,
                    INTEGER          *M,
                    FLOAT            *WORK,
                    INTEGER          *IFAILL,
                    INTEGER          *IFAILR,
                    INTEGER          *INFO)
{
    DEBUG_LAPACK_STUB("shsein");
    LAPACK_IMPL(shsein)(SIDE,
                        EIGSRC,
                        INITV,
                        SELECT,
                        N,
                        H,
                        LDH,
                        WR,
                        WI,
                        VL,
                        LDVL,
                        VR,
                        LDVR,
                        MM,
                        M,
                        WORK,
                        IFAILL,
                        IFAILR,
                        INFO);
}

//-- shseqr --------------------------------------------------------------------
void
LAPACK_DECL(shseqr)(const char       *JOB,
                    const char       *COMPZ,
                    const INTEGER    *N,
                    const INTEGER    *ILO,
                    const INTEGER    *IHI,
                    FLOAT            *H,
                    const INTEGER    *LDH,
                    FLOAT            *WR,
                    FLOAT            *WI,
                    FLOAT            *Z,
                    const INTEGER    *LDZ,
                    FLOAT            *WORK,
                    const INTEGER    *LWORK,
                    INTEGER          *INFO)
{
    DEBUG_LAPACK_STUB("shseqr");
    LAPACK_IMPL(shseqr)(JOB,
                        COMPZ,
                        N,
                        ILO,
                        IHI,
                        H,
                        LDH,
                        WR,
                        WI,
                        Z,
                        LDZ,
                        WORK,
                        LWORK,
                        INFO);
}

//-- sisnan --------------------------------------------------------------------
LOGICAL
LAPACK_DECL(sisnan)(const FLOAT  *SIN)
{
    DEBUG_LAPACK_STUB("sisnan");
    return LAPACK_IMPL(sisnan)(SIN);
}

//-- sla_gbamv -----------------------------------------------------------------
void
LAPACK_DECL(sla_gbamv)(const INTEGER        *TRANS,
                       const INTEGER        *M,
                       const INTEGER        *N,
                       const INTEGER        *KL,
                       const INTEGER        *KU,
                       const FLOAT          *ALPHA,
                       const FLOAT          *AB,
                       const INTEGER        *LDAB,
                       const FLOAT          *X,
                       const INTEGER        *INCX,
                       const FLOAT          *BETA,
                       FLOAT                *Y,
                       const INTEGER        *INCY)
{
    DEBUG_LAPACK_STUB("sla_gbamv");
    LAPACK_IMPL(sla_gbamv)(TRANS,
                           M,
                           N,
                           KL,
                           KU,
                           ALPHA,
                           AB,
                           LDAB,
                           X,
                           INCX,
                           BETA,
                           Y,
                           INCY);
}

//-- sla_gbrcond ---------------------------------------------------------------
FLOAT
LAPACK_DECL(sla_gbrcond)(const char       *TRANS,
                         const INTEGER    *N,
                         const INTEGER    *KL,
                         const INTEGER    *KU,
                         const FLOAT      *AB,
                         const INTEGER    *LDAB,
                         const FLOAT      *AFB,
                         const INTEGER    *LDAFB,
                         const INTEGER    *IPIV,
                         const INTEGER    *CMODE,
                         const FLOAT      *C,
                         INTEGER          *INFO,
                         const FLOAT      *WORK,
                         const INTEGER    *IWORK)
{
    DEBUG_LAPACK_STUB("sla_gbrcond");
    return LAPACK_IMPL(sla_gbrcond)(TRANS,
                                    N,
                                    KL,
                                    KU,
                                    AB,
                                    LDAB,
                                    AFB,
                                    LDAFB,
                                    IPIV,
                                    CMODE,
                                    C,
                                    INFO,
                                    WORK,
                                    IWORK);
}

//-- sla_gbrfsx_extended -------------------------------------------------------
void
LAPACK_DECL(sla_gbrfsx_extended)(const INTEGER    *PREC_TYPE,
                                 const INTEGER    *TRANS_TYPE,
                                 const INTEGER    *N,
                                 const INTEGER    *KL,
                                 const INTEGER    *KU,
                                 const INTEGER    *NRHS,
                                 const FLOAT      *AB,
                                 const INTEGER    *LDAB,
                                 const FLOAT      *AFB,
                                 const INTEGER    *LDAFB,
                                 const INTEGER    *IPIV,
                                 const LOGICAL    *COLEQU,
                                 const FLOAT      *C,
                                 const FLOAT      *B,
                                 const INTEGER    *LDB,
                                 FLOAT            *Y,
                                 const INTEGER    *LDY,
                                 FLOAT            *BERR_OUT,
                                 const INTEGER    *N_NORMS,
                                 FLOAT            *ERR_BNDS_NORM,
                                 FLOAT            *ERR_BNDS_COMP,
                                 const FLOAT      *RES,
                                 const FLOAT      *AYB,
                                 const FLOAT      *DY,
                                 const FLOAT      *Y_TAIL,
                                 const FLOAT      *RCOND,
                                 const INTEGER    *ITHRESH,
                                 const FLOAT      *RTHRESH,
                                 const FLOAT      *DZ_UB,
                                 const LOGICAL    *IGNORE_CWISE,
                                 INTEGER          *INFO)
{
    DEBUG_LAPACK_STUB("sla_gbrfsx_extended");
    ASSERT(0);
    /*
    LAPACK_IMPL(sla_gbrfsx_extended)(PREC_TYPE,
                                     TRANS_TYPE,
                                     N,
                                     KL,
                                     KU,
                                     NRHS,
                                     AB,
                                     LDAB,
                                     AFB,
                                     LDAFB,
                                     IPIV,
                                     COLEQU,
                                     C,
                                     B,
                                     LDB,
                                     Y,
                                     LDY,
                                     BERR_OUT,
                                     N_NORMS,
                                     ERR_BNDS_NORM,
                                     ERR_BNDS_COMP,
                                     RES,
                                     AYB,
                                     DY,
                                     Y_TAIL,
                                     RCOND,
                                     ITHRESH,
                                     RTHRESH,
                                     DZ_UB,
                                     IGNORE_CWISE,
                                     INFO);
    */
}

//-- sla_gbrpvgrw --------------------------------------------------------------
FLOAT
LAPACK_DECL(sla_gbrpvgrw)(const INTEGER    *N,
                          const INTEGER    *KL,
                          const INTEGER    *KU,
                          const INTEGER    *NCOLS,
                          const FLOAT      *AB,
                          const INTEGER    *LDAB,
                          const FLOAT      *AFB,
                          const INTEGER    *LDAFB)
{
    DEBUG_LAPACK_STUB("sla_gbrpvgrw");
    return LAPACK_IMPL(sla_gbrpvgrw)(N,
                                     KL,
                                     KU,
                                     NCOLS,
                                     AB,
                                     LDAB,
                                     AFB,
                                     LDAFB);
}

//-- sla_geamv -----------------------------------------------------------------
void
LAPACK_DECL(sla_geamv)(const INTEGER        *TRANS,
                       const INTEGER        *M,
                       const INTEGER        *N,
                       const FLOAT          *ALPHA,
                       const FLOAT          *A,
                       const INTEGER        *LDA,
                       const FLOAT          *X,
                       const INTEGER        *INCX,
                       const FLOAT          *BETA,
                       FLOAT                *Y,
                       const INTEGER        *INCY)
{
    DEBUG_LAPACK_STUB("sla_geamv");
    LAPACK_IMPL(sla_geamv)(TRANS,
                           M,
                           N,
                           ALPHA,
                           A,
                           LDA,
                           X,
                           INCX,
                           BETA,
                           Y,
                           INCY);
}

//-- sla_gercond ---------------------------------------------------------------
FLOAT
LAPACK_DECL(sla_gercond)(const char       *TRANS,
                         const INTEGER    *N,
                         const FLOAT      *A,
                         const INTEGER    *LDA,
                         const FLOAT      *AF,
                         const INTEGER    *LDAF,
                         const INTEGER    *IPIV,
                         const INTEGER    *CMODE,
                         const FLOAT      *C,
                         INTEGER          *INFO,
                         const FLOAT      *WORK,
                         const INTEGER    *IWORK)
{
    DEBUG_LAPACK_STUB("sla_gercond");
    return LAPACK_IMPL(sla_gercond)(TRANS,
                                    N,
                                    A,
                                    LDA,
                                    AF,
                                    LDAF,
                                    IPIV,
                                    CMODE,
                                    C,
                                    INFO,
                                    WORK,
                                    IWORK);
}

//-- sla_gerfsx_extended -------------------------------------------------------
void
LAPACK_DECL(sla_gerfsx_extended)(const INTEGER    *PREC_TYPE,
                                 const INTEGER    *TRANS_TYPE,
                                 const INTEGER    *N,
                                 const INTEGER    *NRHS,
                                 const FLOAT      *A,
                                 const INTEGER    *LDA,
                                 const FLOAT      *AF,
                                 const INTEGER    *LDAF,
                                 const INTEGER    *IPIV,
                                 const LOGICAL    *COLEQU,
                                 const FLOAT      *C,
                                 const FLOAT      *B,
                                 const INTEGER    *LDB,
                                 FLOAT            *Y,
                                 const INTEGER    *LDY,
                                 FLOAT            *BERR_OUT,
                                 const INTEGER    *N_NORMS,
                                 FLOAT            *ERR_BNDS_NORM,
                                 FLOAT            *ERR_BNDS_COMP,
                                 const FLOAT      *RES,
                                 const FLOAT      *AYB,
                                 const FLOAT      *DY,
                                 const FLOAT      *Y_TAIL,
                                 const FLOAT      *RCOND,
                                 const INTEGER    *ITHRESH,
                                 const FLOAT      *RTHRESH,
                                 const FLOAT      *DZ_UB,
                                 const LOGICAL    *IGNORE_CWISE,
                                 INTEGER          *INFO)
{
    DEBUG_LAPACK_STUB("sla_gerfsx_extended");
    ASSERT(0);
    /*
    LAPACK_IMPL(sla_gerfsx_extended)(PREC_TYPE,
                                     TRANS_TYPE,
                                     N,
                                     NRHS,
                                     A,
                                     LDA,
                                     AF,
                                     LDAF,
                                     IPIV,
                                     COLEQU,
                                     C,
                                     B,
                                     LDB,
                                     Y,
                                     LDY,
                                     BERR_OUT,
                                     N_NORMS,
                                     ERR_BNDS_NORM,
                                     ERR_BNDS_COMP,
                                     RES,
                                     AYB,
                                     DY,
                                     Y_TAIL,
                                     RCOND,
                                     ITHRESH,
                                     RTHRESH,
                                     DZ_UB,
                                     IGNORE_CWISE,
                                     INFO);
    */
}

//-- sla_lin_berr --------------------------------------------------------------
void
LAPACK_DECL(sla_lin_berr)(const INTEGER    *N,
                          const INTEGER    *NZ,
                          const INTEGER    *NRHS,
                          const FLOAT      *RES,
                          const FLOAT      *AYB,
                          FLOAT            *BERR)
{
    DEBUG_LAPACK_STUB("sla_lin_berr");
    LAPACK_IMPL(sla_lin_berr)(N,
                              NZ,
                              NRHS,
                              RES,
                              AYB,
                              BERR);
}

//-- sla_porcond ---------------------------------------------------------------
FLOAT
LAPACK_DECL(sla_porcond)(const char       *UPLO,
                         const INTEGER    *N,
                         const FLOAT      *A,
                         const INTEGER    *LDA,
                         const FLOAT      *AF,
                         const INTEGER    *LDAF,
                         const INTEGER    *CMODE,
                         const FLOAT      *C,
                         INTEGER          *INFO,
                         const FLOAT      *WORK,
                         const INTEGER    *IWORK)
{
    DEBUG_LAPACK_STUB("sla_porcond");
    return LAPACK_IMPL(sla_porcond)(UPLO,
                                    N,
                                    A,
                                    LDA,
                                    AF,
                                    LDAF,
                                    CMODE,
                                    C,
                                    INFO,
                                    WORK,
                                    IWORK);
}

//-- sla_porfsx_extended -------------------------------------------------------
void
LAPACK_DECL(sla_porfsx_extended)(const INTEGER    *PREC_TYPE,
                                 const char       *UPLO,
                                 const INTEGER    *N,
                                 const INTEGER    *NRHS,
                                 const FLOAT      *A,
                                 const INTEGER    *LDA,
                                 const FLOAT      *AF,
                                 const INTEGER    *LDAF,
                                 const LOGICAL    *COLEQU,
                                 const FLOAT      *C,
                                 const FLOAT      *B,
                                 const INTEGER    *LDB,
                                 FLOAT            *Y,
                                 const INTEGER    *LDY,
                                 FLOAT            *BERR_OUT,
                                 const INTEGER    *N_NORMS,
                                 FLOAT            *ERR_BNDS_NORM,
                                 FLOAT            *ERR_BNDS_COMP,
                                 const FLOAT      *RES,
                                 const FLOAT      *AYB,
                                 const FLOAT      *DY,
                                 const FLOAT      *Y_TAIL,
                                 const FLOAT      *RCOND,
                                 const INTEGER    *ITHRESH,
                                 const FLOAT      *RTHRESH,
                                 const FLOAT      *DZ_UB,
                                 const LOGICAL    *IGNORE_CWISE,
                                 INTEGER          *INFO)
{
    DEBUG_LAPACK_STUB("sla_porfsx_extended");
    ASSERT(0);
    /*
    LAPACK_IMPL(sla_porfsx_extended)(PREC_TYPE,
                                     UPLO,
                                     N,
                                     NRHS,
                                     A,
                                     LDA,
                                     AF,
                                     LDAF,
                                     COLEQU,
                                     C,
                                     B,
                                     LDB,
                                     Y,
                                     LDY,
                                     BERR_OUT,
                                     N_NORMS,
                                     ERR_BNDS_NORM,
                                     ERR_BNDS_COMP,
                                     RES,
                                     AYB,
                                     DY,
                                     Y_TAIL,
                                     RCOND,
                                     ITHRESH,
                                     RTHRESH,
                                     DZ_UB,
                                     IGNORE_CWISE,
                                     INFO);
    */
}

//-- sla_porpvgrw --------------------------------------------------------------
FLOAT
LAPACK_DECL(sla_porpvgrw)(const char       *UPLO,
                          const INTEGER    *NCOLS,
                          const FLOAT      *A,
                          const INTEGER    *LDA,
                          const FLOAT      *AF,
                          const INTEGER    *LDAF,
                          const FLOAT      *WORK)
{
    DEBUG_LAPACK_STUB("sla_porpvgrw");
    return LAPACK_IMPL(sla_porpvgrw)(UPLO,
                                     NCOLS,
                                     A,
                                     LDA,
                                     AF,
                                     LDAF,
                                     WORK);
}

//-- sla_rpvgrw ----------------------------------------------------------------
FLOAT
LAPACK_DECL(sla_rpvgrw)(const INTEGER    *N,
                        const INTEGER    *NCOLS,
                        const FLOAT      *A,
                        const INTEGER    *LDA,
                        const FLOAT      *AF,
                        const INTEGER    *LDAF)
{
    DEBUG_LAPACK_STUB("sla_rpvgrw");
    return LAPACK_IMPL(sla_rpvgrw)(N,
                                   NCOLS,
                                   A,
                                   LDA,
                                   AF,
                                   LDAF);
}

//-- sla_syamv -----------------------------------------------------------------
void
LAPACK_DECL(sla_syamv)(const INTEGER        *UPLO,
                       const INTEGER        *N,
                       const FLOAT          *ALPHA,
                       const FLOAT          *A,
                       const INTEGER        *LDA,
                       const FLOAT          *X,
                       const INTEGER        *INCX,
                       const FLOAT          *BETA,
                       FLOAT                *Y,
                       const INTEGER        *INCY)
{
    DEBUG_LAPACK_STUB("sla_syamv");
    LAPACK_IMPL(sla_syamv)(UPLO,
                           N,
                           ALPHA,
                           A,
                           LDA,
                           X,
                           INCX,
                           BETA,
                           Y,
                           INCY);
}

//-- sla_syrcond ---------------------------------------------------------------
FLOAT
LAPACK_DECL(sla_syrcond)(const char       *UPLO,
                         const INTEGER    *N,
                         const FLOAT      *A,
                         const INTEGER    *LDA,
                         const FLOAT      *AF,
                         const INTEGER    *LDAF,
                         const INTEGER    *IPIV,
                         const INTEGER    *CMODE,
                         const FLOAT      *C,
                         INTEGER          *INFO,
                         const FLOAT      *WORK,
                         const INTEGER    *IWORK)
{
    DEBUG_LAPACK_STUB("sla_syrcond");
    return LAPACK_IMPL(sla_syrcond)(UPLO,
                                    N,
                                    A,
                                    LDA,
                                    AF,
                                    LDAF,
                                    IPIV,
                                    CMODE,
                                    C,
                                    INFO,
                                    WORK,
                                    IWORK);
}

//-- sla_syrfsx_extended -------------------------------------------------------
void
LAPACK_DECL(sla_syrfsx_extended)(const INTEGER    *PREC_TYPE,
                                 const char       *UPLO,
                                 const INTEGER    *N,
                                 const INTEGER    *NRHS,
                                 const FLOAT      *A,
                                 const INTEGER    *LDA,
                                 const FLOAT      *AF,
                                 const INTEGER    *LDAF,
                                 const INTEGER    *IPIV,
                                 const LOGICAL    *COLEQU,
                                 const FLOAT      *C,
                                 const FLOAT      *B,
                                 const INTEGER    *LDB,
                                 FLOAT            *Y,
                                 const INTEGER    *LDY,
                                 FLOAT            *BERR_OUT,
                                 const INTEGER    *N_NORMS,
                                 FLOAT            *ERR_BNDS_NORM,
                                 FLOAT            *ERR_BNDS_COMP,
                                 const FLOAT      *RES,
                                 const FLOAT      *AYB,
                                 const FLOAT      *DY,
                                 const FLOAT      *Y_TAIL,
                                 const FLOAT      *RCOND,
                                 const INTEGER    *ITHRESH,
                                 const FLOAT      *RTHRESH,
                                 const FLOAT      *DZ_UB,
                                 const LOGICAL    *IGNORE_CWISE,
                                 INTEGER          *INFO)
{
    DEBUG_LAPACK_STUB("sla_syrfsx_extended");
    ASSERT(0);
    /*
    LAPACK_IMPL(sla_syrfsx_extended)(PREC_TYPE,
                                     UPLO,
                                     N,
                                     NRHS,
                                     A,
                                     LDA,
                                     AF,
                                     LDAF,
                                     IPIV,
                                     COLEQU,
                                     C,
                                     B,
                                     LDB,
                                     Y,
                                     LDY,
                                     BERR_OUT,
                                     N_NORMS,
                                     ERR_BNDS_NORM,
                                     ERR_BNDS_COMP,
                                     RES,
                                     AYB,
                                     DY,
                                     Y_TAIL,
                                     RCOND,
                                     ITHRESH,
                                     RTHRESH,
                                     DZ_UB,
                                     IGNORE_CWISE,
                                     INFO);
    */
}

//-- sla_syrpvgrw --------------------------------------------------------------
FLOAT
LAPACK_DECL(sla_syrpvgrw)(const char       *UPLO,
                          const INTEGER    *N,
                          const INTEGER    *INFO,
                          const FLOAT      *A,
                          const INTEGER    *LDA,
                          const FLOAT      *AF,
                          const INTEGER    *LDAF,
                          const INTEGER    *IPIV,
                          const FLOAT      *WORK)
{
    DEBUG_LAPACK_STUB("sla_syrpvgrw");
    return LAPACK_IMPL(sla_syrpvgrw)(UPLO,
                                     N,
                                     INFO,
                                     A,
                                     LDA,
                                     AF,
                                     LDAF,
                                     IPIV,
                                     WORK);
}

//-- sla_wwaddw ----------------------------------------------------------------
void
LAPACK_DECL(sla_wwaddw)(const INTEGER    *N,
                        FLOAT            *X,
                        FLOAT            *Y,
                        const FLOAT      *W)
{
    DEBUG_LAPACK_STUB("sla_wwaddw");
    LAPACK_IMPL(sla_wwaddw)(N,
                            X,
                            Y,
                            W);
}

//-- slabad --------------------------------------------------------------------
void
LAPACK_DECL(slabad)(FLOAT    *SMALL,
                    FLOAT    *LARGE)
{
    DEBUG_LAPACK_STUB("slabad");
    LAPACK_IMPL(slabad)(SMALL,
                        LARGE);
}

//-- slabrd --------------------------------------------------------------------
void
LAPACK_DECL(slabrd)(const INTEGER    *M,
                    const INTEGER    *N,
                    const INTEGER    *NB,
                    FLOAT            *A,
                    const INTEGER    *LDA,
                    FLOAT            *D,
                    FLOAT            *E,
                    FLOAT            *TAUQ,
                    FLOAT            *TAUP,
                    FLOAT            *X,
                    const INTEGER    *LDX,
                    FLOAT            *Y,
                    const INTEGER    *LDY)
{
    DEBUG_LAPACK_STUB("slabrd");
    LAPACK_IMPL(slabrd)(M,
                        N,
                        NB,
                        A,
                        LDA,
                        D,
                        E,
                        TAUQ,
                        TAUP,
                        X,
                        LDX,
                        Y,
                        LDY);
}

//-- slacn2 --------------------------------------------------------------------
void
LAPACK_DECL(slacn2)(const INTEGER    *N,
                    FLOAT            *V,
                    FLOAT            *X,
                    INTEGER          *ISGN,
                    FLOAT            *EST,
                    INTEGER          *KASE,
                    INTEGER          *ISAVE)
{
    DEBUG_LAPACK_STUB("slacn2");
    LAPACK_IMPL(slacn2)(N,
                        V,
                        X,
                        ISGN,
                        EST,
                        KASE,
                        ISAVE);
}

//-- slacon --------------------------------------------------------------------
void
LAPACK_DECL(slacon)(const INTEGER    *N,
                    FLOAT            *V,
                    FLOAT            *X,
                    INTEGER          *ISGN,
                    FLOAT            *EST,
                    INTEGER          *KASE)
{
    DEBUG_LAPACK_STUB("slacon");
    LAPACK_IMPL(slacon)(N,
                        V,
                        X,
                        ISGN,
                        EST,
                        KASE);
}

//-- slacpy --------------------------------------------------------------------
void
LAPACK_DECL(slacpy)(const char       *UPLO,
                    const INTEGER    *M,
                    const INTEGER    *N,
                    const FLOAT      *A,
                    const INTEGER    *LDA,
                    FLOAT            *B,
                    const INTEGER    *LDB)
{
    DEBUG_LAPACK_STUB("slacpy");
    LAPACK_IMPL(slacpy)(UPLO,
                        M,
                        N,
                        A,
                        LDA,
                        B,
                        LDB);
}

//-- sladiv --------------------------------------------------------------------
void
LAPACK_DECL(sladiv)(const FLOAT  *A,
                    const FLOAT  *B,
                    const FLOAT  *C,
                    const FLOAT  *D,
                    FLOAT        *P,
                    FLOAT        *Q)
{
    DEBUG_LAPACK_STUB("sladiv");
    LAPACK_IMPL(sladiv)(A,
                        B,
                        C,
                        D,
                        P,
                        Q);
}

//-- slae2 ---------------------------------------------------------------------
void
LAPACK_DECL(slae2)(const FLOAT      *A,
                   const FLOAT      *B,
                   const FLOAT      *C,
                   FLOAT            *RT1,
                   FLOAT            *RT2)
{
    DEBUG_LAPACK_STUB("slae2");
    LAPACK_IMPL(slae2)(A,
                       B,
                       C,
                       RT1,
                       RT2);
}

//-- slaebz --------------------------------------------------------------------
void
LAPACK_DECL(slaebz)(const INTEGER    *IJOB,
                    const INTEGER    *NITMAX,
                    const INTEGER    *N,
                    const INTEGER    *MMAX,
                    const INTEGER    *MINP,
                    const INTEGER    *NBMIN,
                    const FLOAT      *ABSTOL,
                    const FLOAT      *RELTOL,
                    const FLOAT      *PIVMIN,
                    const FLOAT      *D,
                    const FLOAT      *E,
                    const FLOAT      *E2,
                    INTEGER          *NVAL,
                    FLOAT            *AB,
                    FLOAT            *C,
                    INTEGER          *MOUT,
                    INTEGER          *NAB,
                    FLOAT            *WORK,
                    INTEGER          *IWORK,
                    INTEGER          *INFO)
{
    DEBUG_LAPACK_STUB("slaebz");
    LAPACK_IMPL(slaebz)(IJOB,
                        NITMAX,
                        N,
                        MMAX,
                        MINP,
                        NBMIN,
                        ABSTOL,
                        RELTOL,
                        PIVMIN,
                        D,
                        E,
                        E2,
                        NVAL,
                        AB,
                        C,
                        MOUT,
                        NAB,
                        WORK,
                        IWORK,
                        INFO);
}

//-- slaed0 --------------------------------------------------------------------
void
LAPACK_DECL(slaed0)(const INTEGER    *ICOMPQ,
                    const INTEGER    *QSIZ,
                    const INTEGER    *N,
                    FLOAT            *D,
                    const FLOAT      *E,
                    FLOAT            *Q,
                    const INTEGER    *LDQ,
                    FLOAT            *QSTORE,
                    const INTEGER    *LDQS,
                    FLOAT            *WORK,
                    INTEGER          *IWORK,
                    INTEGER          *INFO)
{
    DEBUG_LAPACK_STUB("slaed0");
    LAPACK_IMPL(slaed0)(ICOMPQ,
                        QSIZ,
                        N,
                        D,
                        E,
                        Q,
                        LDQ,
                        QSTORE,
                        LDQS,
                        WORK,
                        IWORK,
                        INFO);
}

//-- slaed1 --------------------------------------------------------------------
void
LAPACK_DECL(slaed1)(const INTEGER    *N,
                    FLOAT            *D,
                    FLOAT            *Q,
                    const INTEGER    *LDQ,
                    INTEGER          *INDXQ,
                    const FLOAT      *RHO,
                    const INTEGER    *CUTPNT,
                    FLOAT            *WORK,
                    INTEGER          *IWORK,
                    INTEGER          *INFO)
{
    DEBUG_LAPACK_STUB("slaed1");
    LAPACK_IMPL(slaed1)(N,
                        D,
                        Q,
                        LDQ,
                        INDXQ,
                        RHO,
                        CUTPNT,
                        WORK,
                        IWORK,
                        INFO);
}

//-- slaed2 --------------------------------------------------------------------
void
LAPACK_DECL(slaed2)(INTEGER          *K,
                    const INTEGER    *N,
                    const INTEGER    *N1,
                    FLOAT            *D,
                    FLOAT            *Q,
                    const INTEGER    *LDQ,
                    INTEGER          *INDXQ,
                    FLOAT            *RHO,
                    const FLOAT      *Z,
                    FLOAT            *DLAMDA,
                    FLOAT            *W,
                    FLOAT            *Q2,
                    INTEGER          *INDX,
                    INTEGER          *INDXC,
                    INTEGER          *INDXP,
                    INTEGER          *COLTYP,
                    INTEGER          *INFO)
{
    DEBUG_LAPACK_STUB("slaed2");
    LAPACK_IMPL(slaed2)(K,
                        N,
                        N1,
                        D,
                        Q,
                        LDQ,
                        INDXQ,
                        RHO,
                        Z,
                        DLAMDA,
                        W,
                        Q2,
                        INDX,
                        INDXC,
                        INDXP,
                        COLTYP,
                        INFO);
}

//-- slaed3 --------------------------------------------------------------------
void
LAPACK_DECL(slaed3)(const INTEGER    *K,
                    const INTEGER    *N,
                    const INTEGER    *N1,
                    FLOAT            *D,
                    FLOAT            *Q,
                    const INTEGER    *LDQ,
                    const FLOAT      *RHO,
                    FLOAT            *DLAMDA,
                    const FLOAT      *Q2,
                    const INTEGER    *INDX,
                    const INTEGER    *CTOT,
                    FLOAT            *W,
                    FLOAT            *S,
                    INTEGER          *INFO)
{
    DEBUG_LAPACK_STUB("slaed3");
    LAPACK_IMPL(slaed3)(K,
                        N,
                        N1,
                        D,
                        Q,
                        LDQ,
                        RHO,
                        DLAMDA,
                        Q2,
                        INDX,
                        CTOT,
                        W,
                        S,
                        INFO);
}

//-- slaed4 --------------------------------------------------------------------
void
LAPACK_DECL(slaed4)(const INTEGER    *N,
                    const INTEGER    *I,
                    const FLOAT      *D,
                    const FLOAT      *Z,
                    FLOAT            *DELTA,
                    const FLOAT      *RHO,
                    FLOAT            *DLAM,
                    INTEGER          *INFO)
{
    DEBUG_LAPACK_STUB("slaed4");
    LAPACK_IMPL(slaed4)(N,
                        I,
                        D,
                        Z,
                        DELTA,
                        RHO,
                        DLAM,
                        INFO);
}

//-- slaed5 --------------------------------------------------------------------
void
LAPACK_DECL(slaed5)(const INTEGER    *I,
                    const FLOAT      *D,
                    const FLOAT      *Z,
                    FLOAT            *DELTA,
                    const FLOAT      *RHO,
                    FLOAT            *DLAM)
{
    DEBUG_LAPACK_STUB("slaed5");
    LAPACK_IMPL(slaed5)(I,
                        D,
                        Z,
                        DELTA,
                        RHO,
                        DLAM);
}

//-- slaed6 --------------------------------------------------------------------
void
LAPACK_DECL(slaed6)(const INTEGER    *KNITER,
                    const LOGICAL    *ORGATI,
                    const FLOAT      *RHO,
                    const FLOAT      *D,
                    const FLOAT      *Z,
                    const FLOAT      *FINIT,
                    FLOAT            *TAU,
                    INTEGER          *INFO)
{
    DEBUG_LAPACK_STUB("slaed6");
    LAPACK_IMPL(slaed6)(KNITER,
                        ORGATI,
                        RHO,
                        D,
                        Z,
                        FINIT,
                        TAU,
                        INFO);
}

//-- slaed7 --------------------------------------------------------------------
void
LAPACK_DECL(slaed7)(const INTEGER    *ICOMPQ,
                    const INTEGER    *N,
                    const INTEGER    *QSIZ,
                    const INTEGER    *TLVLS,
                    const INTEGER    *CURLVL,
                    const INTEGER    *CURPBM,
                    FLOAT            *D,
                    FLOAT            *Q,
                    const INTEGER    *LDQ,
                    INTEGER          *INDXQ,
                    const FLOAT      *RHO,
                    const INTEGER    *CUTPNT,
                    FLOAT            *QSTORE,
                    INTEGER          *QPTR,
                    const INTEGER    *PRMPTR,
                    const INTEGER    *PERM,
                    const INTEGER    *GIVPTR,
                    const INTEGER    *GIVCOL,
                    const FLOAT      *GIVNUM,
                    FLOAT            *WORK,
                    INTEGER          *IWORK,
                    INTEGER          *INFO)
{
    DEBUG_LAPACK_STUB("slaed7");
    LAPACK_IMPL(slaed7)(ICOMPQ,
                        N,
                        QSIZ,
                        TLVLS,
                        CURLVL,
                        CURPBM,
                        D,
                        Q,
                        LDQ,
                        INDXQ,
                        RHO,
                        CUTPNT,
                        QSTORE,
                        QPTR,
                        PRMPTR,
                        PERM,
                        GIVPTR,
                        GIVCOL,
                        GIVNUM,
                        WORK,
                        IWORK,
                        INFO);
}

//-- slaed8 --------------------------------------------------------------------
void
LAPACK_DECL(slaed8)(const INTEGER    *ICOMPQ,
                    INTEGER          *K,
                    const INTEGER    *N,
                    const INTEGER    *QSIZ,
                    FLOAT            *D,
                    FLOAT            *Q,
                    const INTEGER    *LDQ,
                    const INTEGER    *INDXQ,
                    FLOAT            *RHO,
                    const INTEGER    *CUTPNT,
                    const FLOAT      *Z,
                    FLOAT            *DLAMDA,
                    FLOAT            *Q2,
                    const INTEGER    *LDQ2,
                    FLOAT            *W,
                    INTEGER          *PERM,
                    INTEGER          *GIVPTR,
                    INTEGER          *GIVCOL,
                    FLOAT            *GIVNUM,
                    INTEGER          *INDXP,
                    INTEGER          *INDX,
                    INTEGER          *INFO)
{
    DEBUG_LAPACK_STUB("slaed8");
    LAPACK_IMPL(slaed8)(ICOMPQ,
                        K,
                        N,
                        QSIZ,
                        D,
                        Q,
                        LDQ,
                        INDXQ,
                        RHO,
                        CUTPNT,
                        Z,
                        DLAMDA,
                        Q2,
                        LDQ2,
                        W,
                        PERM,
                        GIVPTR,
                        GIVCOL,
                        GIVNUM,
                        INDXP,
                        INDX,
                        INFO);
}

//-- slaed9 --------------------------------------------------------------------
void
LAPACK_DECL(slaed9)(const INTEGER    *K,
                    const INTEGER    *KSTART,
                    const INTEGER    *KSTOP,
                    const INTEGER    *N,
                    FLOAT            *D,
                    FLOAT            *Q,
                    const INTEGER    *LDQ,
                    const FLOAT      *RHO,
                    const FLOAT      *DLAMDA,
                    const FLOAT      *W,
                    FLOAT            *S,
                    const INTEGER    *LDS,
                    INTEGER          *INFO)
{
    DEBUG_LAPACK_STUB("slaed9");
    LAPACK_IMPL(slaed9)(K,
                        KSTART,
                        KSTOP,
                        N,
                        D,
                        Q,
                        LDQ,
                        RHO,
                        DLAMDA,
                        W,
                        S,
                        LDS,
                        INFO);
}

//-- slaeda --------------------------------------------------------------------
void
LAPACK_DECL(slaeda)(const INTEGER    *N,
                    const INTEGER    *TLVLS,
                    const INTEGER    *CURLVL,
                    const INTEGER    *CURPBM,
                    const INTEGER    *PRMPTR,
                    const INTEGER    *PERM,
                    const INTEGER    *GIVPTR,
                    const INTEGER    *GIVCOL,
                    const FLOAT      *GIVNUM,
                    const FLOAT      *Q,
                    const INTEGER    *QPTR,
                    FLOAT            *Z,
                    FLOAT            *ZTEMP,
                    INTEGER          *INFO)
{
    DEBUG_LAPACK_STUB("slaeda");
    LAPACK_IMPL(slaeda)(N,
                        TLVLS,
                        CURLVL,
                        CURPBM,
                        PRMPTR,
                        PERM,
                        GIVPTR,
                        GIVCOL,
                        GIVNUM,
                        Q,
                        QPTR,
                        Z,
                        ZTEMP,
                        INFO);
}

//-- slaein --------------------------------------------------------------------
void
LAPACK_DECL(slaein)(const LOGICAL    *RIGHTV,
                    const LOGICAL    *NOINIT,
                    const INTEGER    *N,
                    const FLOAT      *H,
                    const INTEGER    *LDH,
                    const FLOAT      *WR,
                    const FLOAT      *WI,
                    FLOAT            *VR,
                    FLOAT            *VI,
                    FLOAT            *B,
                    const INTEGER    *LDB,
                    FLOAT            *WORK,
                    const FLOAT      *EPS3,
                    const FLOAT      *SMLNUM,
                    const FLOAT      *BIGNUM,
                    INTEGER          *INFO)
{
    DEBUG_LAPACK_STUB("slaein");
    LAPACK_IMPL(slaein)(RIGHTV,
                        NOINIT,
                        N,
                        H,
                        LDH,
                        WR,
                        WI,
                        VR,
                        VI,
                        B,
                        LDB,
                        WORK,
                        EPS3,
                        SMLNUM,
                        BIGNUM,
                        INFO);
}

//-- slaev2 --------------------------------------------------------------------
void
LAPACK_DECL(slaev2)(const FLOAT  *A,
                    const FLOAT  *B,
                    const FLOAT  *C,
                    FLOAT        *RT1,
                    FLOAT        *RT2,
                    FLOAT        *CS1,
                    FLOAT        *SN1)
{
    DEBUG_LAPACK_STUB("slaev2");
    LAPACK_IMPL(slaev2)(A,
                        B,
                        C,
                        RT1,
                        RT2,
                        CS1,
                        SN1);
}

//-- slaexc --------------------------------------------------------------------
void
LAPACK_DECL(slaexc)(const LOGICAL    *WANTQ,
                    const INTEGER    *N,
                    FLOAT            *T,
                    const INTEGER    *LDT,
                    FLOAT            *Q,
                    const INTEGER    *LDQ,
                    const INTEGER    *J1,
                    const INTEGER    *N1,
                    const INTEGER    *N2,
                    FLOAT            *WORK,
                    INTEGER          *INFO)
{
    DEBUG_LAPACK_STUB("slaexc");
    LAPACK_IMPL(slaexc)(WANTQ,
                        N,
                        T,
                        LDT,
                        Q,
                        LDQ,
                        J1,
                        N1,
                        N2,
                        WORK,
                        INFO);
}

//-- slag2 ---------------------------------------------------------------------
void
LAPACK_DECL(slag2)(const FLOAT          *A,
                   const INTEGER        *LDA,
                   const FLOAT          *B,
                   const INTEGER        *LDB,
                   const FLOAT          *SAFMIN,
                   FLOAT                *SCALE1,
                   FLOAT                *SCALE2,
                   FLOAT                *WR1,
                   FLOAT                *WR2,
                   FLOAT                *WI)
{
    DEBUG_LAPACK_STUB("slag2");
    LAPACK_IMPL(slag2)(A,
                       LDA,
                       B,
                       LDB,
                       SAFMIN,
                       SCALE1,
                       SCALE2,
                       WR1,
                       WR2,
                       WI);
}

//-- slag2d --------------------------------------------------------------------
void
LAPACK_DECL(slag2d)(const INTEGER    *M,
                    const INTEGER    *N,
                    const FLOAT      *SA,
                    const INTEGER    *LDSA,
                    DOUBLE           *A,
                    const INTEGER    *LDA,
                    INTEGER          *INFO)
{
    DEBUG_LAPACK_STUB("slag2d");
    LAPACK_IMPL(slag2d)(M,
                        N,
                        SA,
                        LDSA,
                        A,
                        LDA,
                        INFO);
}

//-- slags2 --------------------------------------------------------------------
void
LAPACK_DECL(slags2)(const LOGICAL    *UPPER,
                    const FLOAT      *A1,
                    const FLOAT      *A2,
                    const FLOAT      *A3,
                    const FLOAT      *B1,
                    const FLOAT      *B2,
                    const FLOAT      *B3,
                    FLOAT            *CSU,
                    FLOAT            *SNU,
                    FLOAT            *CSV,
                    FLOAT            *SNV,
                    FLOAT            *CSQ,
                    FLOAT            *SNQ)
{
    DEBUG_LAPACK_STUB("slags2");
    LAPACK_IMPL(slags2)(UPPER,
                        A1,
                        A2,
                        A3,
                        B1,
                        B2,
                        B3,
                        CSU,
                        SNU,
                        CSV,
                        SNV,
                        CSQ,
                        SNQ);
}

//-- slagtf --------------------------------------------------------------------
void
LAPACK_DECL(slagtf)(const INTEGER    *N,
                    FLOAT            *A,
                    const FLOAT      *LAMBDA,
                    FLOAT            *B,
                    FLOAT            *C,
                    const FLOAT      *TOL,
                    FLOAT            *D,
                    INTEGER          *IN,
                    INTEGER          *INFO)
{
    DEBUG_LAPACK_STUB("slagtf");
    LAPACK_IMPL(slagtf)(N,
                        A,
                        LAMBDA,
                        B,
                        C,
                        TOL,
                        D,
                        IN,
                        INFO);
}

//-- slagtm --------------------------------------------------------------------
void
LAPACK_DECL(slagtm)(const char       *TRANS,
                    const INTEGER    *N,
                    const INTEGER    *NRHS,
                    const FLOAT      *ALPHA,
                    const FLOAT      *DL,
                    const FLOAT      *D,
                    const FLOAT      *DU,
                    const FLOAT      *X,
                    const INTEGER    *LDX,
                    const FLOAT      *BETA,
                    FLOAT            *B,
                    const INTEGER    *LDB)
{
    DEBUG_LAPACK_STUB("slagtm");
    LAPACK_IMPL(slagtm)(TRANS,
                        N,
                        NRHS,
                        ALPHA,
                        DL,
                        D,
                        DU,
                        X,
                        LDX,
                        BETA,
                        B,
                        LDB);
}

//-- slagts --------------------------------------------------------------------
void
LAPACK_DECL(slagts)(const INTEGER    *JOB,
                    const INTEGER    *N,
                    const FLOAT      *A,
                    const FLOAT      *B,
                    const FLOAT      *C,
                    const FLOAT      *D,
                    const INTEGER    *IN,
                    FLOAT            *Y,
                    FLOAT            *TOL,
                    INTEGER          *INFO)
{
    DEBUG_LAPACK_STUB("slagts");
    LAPACK_IMPL(slagts)(JOB,
                        N,
                        A,
                        B,
                        C,
                        D,
                        IN,
                        Y,
                        TOL,
                        INFO);
}

//-- slagv2 --------------------------------------------------------------------
void
LAPACK_DECL(slagv2)(FLOAT            *A,
                    const INTEGER    *LDA,
                    FLOAT            *B,
                    const INTEGER    *LDB,
                    FLOAT            *ALPHAR,
                    FLOAT            *ALPHAI,
                    FLOAT            *BETA,
                    FLOAT            *CSL,
                    FLOAT            *SNL,
                    FLOAT            *CSR,
                    FLOAT            *SNR)
{
    DEBUG_LAPACK_STUB("slagv2");
    LAPACK_IMPL(slagv2)(A,
                        LDA,
                        B,
                        LDB,
                        ALPHAR,
                        ALPHAI,
                        BETA,
                        CSL,
                        SNL,
                        CSR,
                        SNR);
}

//-- slahqr --------------------------------------------------------------------
void
LAPACK_DECL(slahqr)(const LOGICAL    *WANTT,
                    const LOGICAL    *WANTZ,
                    const INTEGER    *N,
                    const INTEGER    *ILO,
                    const INTEGER    *IHI,
                    FLOAT            *H,
                    const INTEGER    *LDH,
                    FLOAT            *WR,
                    FLOAT            *WI,
                    const INTEGER    *ILOZ,
                    const INTEGER    *IHIZ,
                    FLOAT            *Z,
                    const INTEGER    *LDZ,
                    INTEGER          *INFO)
{
    DEBUG_LAPACK_STUB("slahqr");
    LAPACK_IMPL(slahqr)(WANTT,
                        WANTZ,
                        N,
                        ILO,
                        IHI,
                        H,
                        LDH,
                        WR,
                        WI,
                        ILOZ,
                        IHIZ,
                        Z,
                        LDZ,
                        INFO);
}

//-- slahr2 --------------------------------------------------------------------
void
LAPACK_DECL(slahr2)(const INTEGER    *N,
                    const INTEGER    *K,
                    const INTEGER    *NB,
                    FLOAT            *A,
                    const INTEGER    *LDA,
                    FLOAT            *TAU,
                    FLOAT            *T,
                    const INTEGER    *LDT,
                    FLOAT            *Y,
                    const INTEGER    *LDY)
{
    DEBUG_LAPACK_STUB("slahr2");
    LAPACK_IMPL(slahr2)(N,
                        K,
                        NB,
                        A,
                        LDA,
                        TAU,
                        T,
                        LDT,
                        Y,
                        LDY);
}

//-- slahrd --------------------------------------------------------------------
void
LAPACK_DECL(slahrd)(const INTEGER    *N,
                    const INTEGER    *K,
                    const INTEGER    *NB,
                    FLOAT            *A,
                    const INTEGER    *LDA,
                    FLOAT            *TAU,
                    FLOAT            *T,
                    const INTEGER    *LDT,
                    FLOAT            *Y,
                    const INTEGER    *LDY)
{
    DEBUG_LAPACK_STUB("slahrd");
    LAPACK_IMPL(slahrd)(N,
                        K,
                        NB,
                        A,
                        LDA,
                        TAU,
                        T,
                        LDT,
                        Y,
                        LDY);
}

//-- slaic1 --------------------------------------------------------------------
void
LAPACK_DECL(slaic1)(const INTEGER    *JOB,
                    const INTEGER    *J,
                    const FLOAT      *X,
                    const FLOAT      *SEST,
                    const FLOAT      *W,
                    const FLOAT      *GAMMA,
                    FLOAT            *SESTPR,
                    FLOAT            *S,
                    FLOAT            *C)
{
    DEBUG_LAPACK_STUB("slaic1");
    LAPACK_IMPL(slaic1)(JOB,
                        J,
                        X,
                        SEST,
                        W,
                        GAMMA,
                        SESTPR,
                        S,
                        C);
}

//-- slaisnan ------------------------------------------------------------------
LOGICAL
LAPACK_DECL(slaisnan)(const FLOAT      *SIN1,
                      const FLOAT      *SIN2)
{
    DEBUG_LAPACK_STUB("slaisnan");
    return LAPACK_IMPL(slaisnan)(SIN1,
                                 SIN2);
}

//-- slaln2 --------------------------------------------------------------------
void
LAPACK_DECL(slaln2)(const LOGICAL    *LTRANS,
                    const INTEGER    *NA,
                    const INTEGER    *NW,
                    const FLOAT      *SMIN,
                    const FLOAT      *CA,
                    const FLOAT      *A,
                    const INTEGER    *LDA,
                    const FLOAT      *D1,
                    const FLOAT      *D2,
                    const FLOAT      *B,
                    const INTEGER    *LDB,
                    const FLOAT      *WR,
                    const FLOAT      *WI,
                    FLOAT            *X,
                    const INTEGER    *LDX,
                    FLOAT            *SCALE,
                    FLOAT            *XNORM,
                    INTEGER          *INFO)
{
    DEBUG_LAPACK_STUB("slaln2");
    LAPACK_IMPL(slaln2)(LTRANS,
                        NA,
                        NW,
                        SMIN,
                        CA,
                        A,
                        LDA,
                        D1,
                        D2,
                        B,
                        LDB,
                        WR,
                        WI,
                        X,
                        LDX,
                        SCALE,
                        XNORM,
                        INFO);
}

//-- slals0 --------------------------------------------------------------------
void
LAPACK_DECL(slals0)(const INTEGER    *ICOMPQ,
                    const INTEGER    *NL,
                    const INTEGER    *NR,
                    const INTEGER    *SQRE,
                    const INTEGER    *NRHS,
                    FLOAT            *B,
                    const INTEGER    *LDB,
                    FLOAT            *BX,
                    const INTEGER    *LDBX,
                    const INTEGER    *PERM,
                    const INTEGER    *GIVPTR,
                    const INTEGER    *GIVCOL,
                    const INTEGER    *LDGCOL,
                    const FLOAT      *GIVNUM,
                    const INTEGER    *LDGNUM,
                    const FLOAT      *POLES,
                    const FLOAT      *DIFL,
                    const FLOAT      *DIFR,
                    const FLOAT      *Z,
                    const INTEGER    *K,
                    const FLOAT      *C,
                    const FLOAT      *S,
                    FLOAT            *WORK,
                    INTEGER          *INFO)
{
    DEBUG_LAPACK_STUB("slals0");
    LAPACK_IMPL(slals0)(ICOMPQ,
                        NL,
                        NR,
                        SQRE,
                        NRHS,
                        B,
                        LDB,
                        BX,
                        LDBX,
                        PERM,
                        GIVPTR,
                        GIVCOL,
                        LDGCOL,
                        GIVNUM,
                        LDGNUM,
                        POLES,
                        DIFL,
                        DIFR,
                        Z,
                        K,
                        C,
                        S,
                        WORK,
                        INFO);
}

//-- slalsa --------------------------------------------------------------------
void
LAPACK_DECL(slalsa)(const INTEGER    *ICOMPQ,
                    const INTEGER    *SMLSIZ,
                    const INTEGER    *N,
                    const INTEGER    *NRHS,
                    FLOAT            *B,
                    const INTEGER    *LDB,
                    FLOAT            *BX,
                    const INTEGER    *LDBX,
                    const FLOAT      *U,
                    const INTEGER    *LDU,
                    const FLOAT      *VT,
                    const INTEGER    *K,
                    const FLOAT      *DIFL,
                    const FLOAT      *DIFR,
                    const FLOAT      *Z,
                    const FLOAT      *POLES,
                    const INTEGER    *GIVPTR,
                    const INTEGER    *GIVCOL,
                    const INTEGER    *LDGCOL,
                    const INTEGER    *PERM,
                    const FLOAT      *GIVNUM,
                    const FLOAT      *C,
                    const FLOAT      *S,
                    FLOAT            *WORK,
                    INTEGER          *IWORK,
                    INTEGER          *INFO)
{
    DEBUG_LAPACK_STUB("slalsa");
    LAPACK_IMPL(slalsa)(ICOMPQ,
                        SMLSIZ,
                        N,
                        NRHS,
                        B,
                        LDB,
                        BX,
                        LDBX,
                        U,
                        LDU,
                        VT,
                        K,
                        DIFL,
                        DIFR,
                        Z,
                        POLES,
                        GIVPTR,
                        GIVCOL,
                        LDGCOL,
                        PERM,
                        GIVNUM,
                        C,
                        S,
                        WORK,
                        IWORK,
                        INFO);
}

//-- slalsd --------------------------------------------------------------------
void
LAPACK_DECL(slalsd)(const char       *UPLO,
                    const INTEGER    *SMLSIZ,
                    const INTEGER    *N,
                    const INTEGER    *NRHS,
                    FLOAT            *D,
                    FLOAT            *E,
                    FLOAT            *B,
                    const INTEGER    *LDB,
                    const FLOAT      *RCOND,
                    INTEGER          *RANK,
                    FLOAT            *WORK,
                    INTEGER          *IWORK,
                    INTEGER          *INFO)
{
    DEBUG_LAPACK_STUB("slalsd");
    LAPACK_IMPL(slalsd)(UPLO,
                        SMLSIZ,
                        N,
                        NRHS,
                        D,
                        E,
                        B,
                        LDB,
                        RCOND,
                        RANK,
                        WORK,
                        IWORK,
                        INFO);
}

//-- slamrg --------------------------------------------------------------------
void
LAPACK_DECL(slamrg)(const INTEGER    *N1,
                    const INTEGER    *N2,
                    const FLOAT      *A,
                    const INTEGER    *STRD1,
                    const INTEGER    *STRD2,
                    INTEGER          *INDEX)
{
    DEBUG_LAPACK_STUB("slamrg");
    LAPACK_IMPL(slamrg)(N1,
                        N2,
                        A,
                        STRD1,
                        STRD2,
                        INDEX);
}

//-- slaneg --------------------------------------------------------------------
INTEGER
LAPACK_DECL(slaneg)(const INTEGER    *N,
                    const FLOAT      *D,
                    const FLOAT      *LLD,
                    const FLOAT      *SIGMA,
                    const FLOAT      *PIVMIN,
                    const INTEGER    *R)
{
    DEBUG_LAPACK_STUB("slaneg");
    return LAPACK_IMPL(slaneg)(N,
                               D,
                               LLD,
                               SIGMA,
                               PIVMIN,
                               R);
}

//-- slangb --------------------------------------------------------------------
FLOAT
LAPACK_DECL(slangb)(const char       *NORM,
                    const INTEGER    *N,
                    const INTEGER    *KL,
                    const INTEGER    *KU,
                    const FLOAT      *AB,
                    const INTEGER    *LDAB,
                    FLOAT            *WORK)
{
    DEBUG_LAPACK_STUB("slangb");
    return LAPACK_IMPL(slangb)(NORM,
                               N,
                               KL,
                               KU,
                               AB,
                               LDAB,
                               WORK);
}

//-- slange --------------------------------------------------------------------
FLOAT
LAPACK_DECL(slange)(const char       *NORM,
                    const INTEGER    *M,
                    const INTEGER    *N,
                    const FLOAT      *A,
                    const INTEGER    *LDA,
                    FLOAT            *WORK)
{
    DEBUG_LAPACK_STUB("slange");
    return LAPACK_IMPL(slange)(NORM,
                               M,
                               N,
                               A,
                               LDA,
                               WORK);
}

//-- slangt --------------------------------------------------------------------
FLOAT
LAPACK_DECL(slangt)(const char       *NORM,
                    const INTEGER    *N,
                    const FLOAT      *DL,
                    const FLOAT      *D,
                    const FLOAT      *DU)
{
    DEBUG_LAPACK_STUB("slangt");
    return LAPACK_IMPL(slangt)(NORM,
                               N,
                               DL,
                               D,
                               DU);
}

//-- slanhs --------------------------------------------------------------------
FLOAT
LAPACK_DECL(slanhs)(const char       *NORM,
                    const INTEGER    *N,
                    const FLOAT      *A,
                    const INTEGER    *LDA,
                    FLOAT            *WORK)
{
    DEBUG_LAPACK_STUB("slanhs");
    return LAPACK_IMPL(slanhs)(NORM,
                               N,
                               A,
                               LDA,
                               WORK);
}

//-- slansb --------------------------------------------------------------------
FLOAT
LAPACK_DECL(slansb)(const char       *NORM,
                    const char       *UPLO,
                    const INTEGER    *N,
                    const INTEGER    *K,
                    const FLOAT      *AB,
                    const INTEGER    *LDAB,
                    FLOAT            *WORK)
{
    DEBUG_LAPACK_STUB("slansb");
    return LAPACK_IMPL(slansb)(NORM,
                               UPLO,
                               N,
                               K,
                               AB,
                               LDAB,
                               WORK);
}

//-- slansf --------------------------------------------------------------------
FLOAT
LAPACK_DECL(slansf)(const char       *NORM,
                    const char       *TRANSR,
                    const char       *UPLO,
                    const INTEGER    *N,
                    const FLOAT      *A,
                    FLOAT            *WORK)
{
    DEBUG_LAPACK_STUB("slansf");
    return LAPACK_IMPL(slansf)(NORM,
                               TRANSR,
                               UPLO,
                               N,
                               A,
                               WORK);
}

//-- slansp --------------------------------------------------------------------
FLOAT
LAPACK_DECL(slansp)(const char       *NORM,
                    const char       *UPLO,
                    const INTEGER    *N,
                    const FLOAT      *AP,
                    FLOAT            *WORK)
{
    DEBUG_LAPACK_STUB("slansp");
    return LAPACK_IMPL(slansp)(NORM,
                               UPLO,
                               N,
                               AP,
                               WORK);
}

//-- slanst --------------------------------------------------------------------
FLOAT
LAPACK_DECL(slanst)(const char       *NORM,
                    const INTEGER    *N,
                    const FLOAT      *D,
                    const FLOAT      *E)
{
    DEBUG_LAPACK_STUB("slanst");
    return LAPACK_IMPL(slanst)(NORM,
                               N,
                               D,
                               E);
}

//-- slansy --------------------------------------------------------------------
FLOAT
LAPACK_DECL(slansy)(const char       *NORM,
                    const char       *UPLO,
                    const INTEGER    *N,
                    const FLOAT      *A,
                    const INTEGER    *LDA,
                    FLOAT            *WORK)
{
    DEBUG_LAPACK_STUB("slansy");
    return LAPACK_IMPL(slansy)(NORM,
                               UPLO,
                               N,
                               A,
                               LDA,
                               WORK);
}

//-- slantb --------------------------------------------------------------------
FLOAT
LAPACK_DECL(slantb)(const char       *NORM,
                    const char       *UPLO,
                    const char       *DIAG,
                    const INTEGER    *N,
                    const INTEGER    *K,
                    const FLOAT      *AB,
                    const INTEGER    *LDAB,
                    FLOAT            *WORK)
{
    DEBUG_LAPACK_STUB("slantb");
    return LAPACK_IMPL(slantb)(NORM,
                               UPLO,
                               DIAG,
                               N,
                               K,
                               AB,
                               LDAB,
                               WORK);
}

//-- slantp --------------------------------------------------------------------
FLOAT
LAPACK_DECL(slantp)(const char       *NORM,
                    const char       *UPLO,
                    const char       *DIAG,
                    const INTEGER    *N,
                    const FLOAT      *AP,
                    FLOAT            *WORK)
{
    DEBUG_LAPACK_STUB("slantp");
    return LAPACK_IMPL(slantp)(NORM,
                               UPLO,
                               DIAG,
                               N,
                               AP,
                               WORK);
}

//-- slantr --------------------------------------------------------------------
FLOAT
LAPACK_DECL(slantr)(const char       *NORM,
                    const char       *UPLO,
                    const char       *DIAG,
                    const INTEGER    *M,
                    const INTEGER    *N,
                    const FLOAT      *A,
                    const INTEGER    *LDA,
                    FLOAT            *WORK)
{
    DEBUG_LAPACK_STUB("slantr");
    return LAPACK_IMPL(slantr)(NORM,
                               UPLO,
                               DIAG,
                               M,
                               N,
                               A,
                               LDA,
                               WORK);
}

//-- slanv2 --------------------------------------------------------------------
void
LAPACK_DECL(slanv2)(FLOAT    *A,
                    FLOAT    *B,
                    FLOAT    *C,
                    FLOAT    *D,
                    FLOAT    *RT1R,
                    FLOAT    *RT1I,
                    FLOAT    *RT2R,
                    FLOAT    *RT2I,
                    FLOAT    *CS,
                    FLOAT    *SN)
{
    DEBUG_LAPACK_STUB("slanv2");
    LAPACK_IMPL(slanv2)(A,
                        B,
                        C,
                        D,
                        RT1R,
                        RT1I,
                        RT2R,
                        RT2I,
                        CS,
                        SN);
}

//-- slapll --------------------------------------------------------------------
void
LAPACK_DECL(slapll)(const INTEGER    *N,
                    FLOAT            *X,
                    const INTEGER    *INCX,
                    FLOAT            *Y,
                    const INTEGER    *INCY,
                    FLOAT            *SSMIN)
{
    DEBUG_LAPACK_STUB("slapll");
    LAPACK_IMPL(slapll)(N,
                        X,
                        INCX,
                        Y,
                        INCY,
                        SSMIN);
}

//-- slapmr --------------------------------------------------------------------
void
LAPACK_DECL(slapmr)(const LOGICAL    *FORWRD,
                    const INTEGER    *M,
                    const INTEGER    *N,
                    FLOAT            *X,
                    const INTEGER    *LDX,
                    INTEGER          *K)
{
    DEBUG_LAPACK_STUB("slapmr");
    LAPACK_IMPL(slapmr)(FORWRD,
                        M,
                        N,
                        X,
                        LDX,
                        K);
}

//-- slapmt --------------------------------------------------------------------
void
LAPACK_DECL(slapmt)(const LOGICAL    *FORWRD,
                    const INTEGER    *M,
                    const INTEGER    *N,
                    FLOAT            *X,
                    const INTEGER    *LDX,
                    INTEGER          *K)
{
    DEBUG_LAPACK_STUB("slapmt");
    LAPACK_IMPL(slapmt)(FORWRD,
                        M,
                        N,
                        X,
                        LDX,
                        K);
}

//-- slapy2 --------------------------------------------------------------------
FLOAT
LAPACK_DECL(slapy2)(const FLOAT  *X,
                    const FLOAT  *Y)
{
    DEBUG_LAPACK_STUB("slapy2");
    return LAPACK_IMPL(slapy2)(X,
                               Y);
}

//-- slapy3 --------------------------------------------------------------------
FLOAT
LAPACK_DECL(slapy3)(const FLOAT  *X,
                    const FLOAT  *Y,
                    const FLOAT  *Z)
{
    DEBUG_LAPACK_STUB("slapy3");
    return LAPACK_IMPL(slapy3)(X,
                               Y,
                               Z);
}

//-- slaqgb --------------------------------------------------------------------
void
LAPACK_DECL(slaqgb)(const INTEGER    *M,
                    const INTEGER    *N,
                    const INTEGER    *KL,
                    const INTEGER    *KU,
                    FLOAT            *AB,
                    const INTEGER    *LDAB,
                    const FLOAT      *R,
                    const FLOAT      *C,
                    const FLOAT      *ROWCND,
                    const FLOAT      *COLCND,
                    const FLOAT      *AMAX,
                    char             *EQUED)
{
    DEBUG_LAPACK_STUB("slaqgb");
    LAPACK_IMPL(slaqgb)(M,
                        N,
                        KL,
                        KU,
                        AB,
                        LDAB,
                        R,
                        C,
                        ROWCND,
                        COLCND,
                        AMAX,
                        EQUED);
}

//-- slaqge --------------------------------------------------------------------
void
LAPACK_DECL(slaqge)(const INTEGER    *M,
                    const INTEGER    *N,
                    FLOAT            *A,
                    const INTEGER    *LDA,
                    const FLOAT      *R,
                    const FLOAT      *C,
                    const FLOAT      *ROWCND,
                    const FLOAT      *COLCND,
                    const FLOAT      *AMAX,
                    char             *EQUED)
{
    DEBUG_LAPACK_STUB("slaqge");
    LAPACK_IMPL(slaqge)(M,
                        N,
                        A,
                        LDA,
                        R,
                        C,
                        ROWCND,
                        COLCND,
                        AMAX,
                        EQUED);
}

//-- slaqp2 --------------------------------------------------------------------
void
LAPACK_DECL(slaqp2)(const INTEGER    *M,
                    const INTEGER    *N,
                    const INTEGER    *OFFSET,
                    FLOAT            *A,
                    const INTEGER    *LDA,
                    INTEGER          *JPVT,
                    FLOAT            *TAU,
                    FLOAT            *VN1,
                    FLOAT            *VN2,
                    FLOAT            *WORK)
{
    DEBUG_LAPACK_STUB("slaqp2");
    LAPACK_IMPL(slaqp2)(M,
                        N,
                        OFFSET,
                        A,
                        LDA,
                        JPVT,
                        TAU,
                        VN1,
                        VN2,
                        WORK);
}

//-- slaqps --------------------------------------------------------------------
void
LAPACK_DECL(slaqps)(const INTEGER    *M,
                    const INTEGER    *N,
                    const INTEGER    *OFFSET,
                    const INTEGER    *NB,
                    INTEGER          *KB,
                    FLOAT            *A,
                    const INTEGER    *LDA,
                    INTEGER          *JPVT,
                    FLOAT            *TAU,
                    FLOAT            *VN1,
                    FLOAT            *VN2,
                    FLOAT            *AUXV,
                    FLOAT            *F,
                    const INTEGER    *LDF)
{
    DEBUG_LAPACK_STUB("slaqps");
    LAPACK_IMPL(slaqps)(M,
                        N,
                        OFFSET,
                        NB,
                        KB,
                        A,
                        LDA,
                        JPVT,
                        TAU,
                        VN1,
                        VN2,
                        AUXV,
                        F,
                        LDF);
}

//-- slaqr0 --------------------------------------------------------------------
void
LAPACK_DECL(slaqr0)(const LOGICAL    *WANTT,
                    const LOGICAL    *WANTZ,
                    const INTEGER    *N,
                    const INTEGER    *ILO,
                    const INTEGER    *IHI,
                    FLOAT            *H,
                    const INTEGER    *LDH,
                    FLOAT            *WR,
                    FLOAT            *WI,
                    const INTEGER    *ILOZ,
                    const INTEGER    *IHIZ,
                    FLOAT            *Z,
                    const INTEGER    *LDZ,
                    FLOAT            *WORK,
                    const INTEGER    *LWORK,
                    INTEGER          *INFO)
{
    DEBUG_LAPACK_STUB("slaqr0");
    LAPACK_IMPL(slaqr0)(WANTT,
                        WANTZ,
                        N,
                        ILO,
                        IHI,
                        H,
                        LDH,
                        WR,
                        WI,
                        ILOZ,
                        IHIZ,
                        Z,
                        LDZ,
                        WORK,
                        LWORK,
                        INFO);
}

//-- slaqr1 --------------------------------------------------------------------
void
LAPACK_DECL(slaqr1)(const INTEGER    *N,
                    const FLOAT      *H,
                    const INTEGER    *LDH,
                    const FLOAT      *SR1,
                    const FLOAT      *SI1,
                    const FLOAT      *SR2,
                    const FLOAT      *SI2,
                    FLOAT            *V)
{
    DEBUG_LAPACK_STUB("slaqr1");
    LAPACK_IMPL(slaqr1)(N,
                        H,
                        LDH,
                        SR1,
                        SI1,
                        SR2,
                        SI2,
                        V);
}

//-- slaqr2 --------------------------------------------------------------------
void
LAPACK_DECL(slaqr2)(const LOGICAL    *WANTT,
                    const LOGICAL    *WANTZ,
                    const INTEGER    *N,
                    const INTEGER    *KTOP,
                    const INTEGER    *KBOT,
                    const INTEGER    *NW,
                    FLOAT            *H,
                    const INTEGER    *LDH,
                    const INTEGER    *ILOZ,
                    const INTEGER    *IHIZ,
                    FLOAT            *Z,
                    const INTEGER    *LDZ,
                    INTEGER          *NS,
                    INTEGER          *ND,
                    FLOAT            *SR,
                    FLOAT            *SI,
                    FLOAT            *V,
                    const INTEGER    *LDV,
                    const INTEGER    *NH,
                    FLOAT            *T,
                    const INTEGER    *LDT,
                    const INTEGER    *NV,
                    FLOAT            *WV,
                    const INTEGER    *LDWV,
                    FLOAT            *WORK,
                    const INTEGER    *LWORK)
{
    DEBUG_LAPACK_STUB("slaqr2");
    LAPACK_IMPL(slaqr2)(WANTT,
                        WANTZ,
                        N,
                        KTOP,
                        KBOT,
                        NW,
                        H,
                        LDH,
                        ILOZ,
                        IHIZ,
                        Z,
                        LDZ,
                        NS,
                        ND,
                        SR,
                        SI,
                        V,
                        LDV,
                        NH,
                        T,
                        LDT,
                        NV,
                        WV,
                        LDWV,
                        WORK,
                        LWORK);
}

//-- slaqr3 --------------------------------------------------------------------
void
LAPACK_DECL(slaqr3)(const LOGICAL    *WANTT,
                    const LOGICAL    *WANTZ,
                    const INTEGER    *N,
                    const INTEGER    *KTOP,
                    const INTEGER    *KBOT,
                    const INTEGER    *NW,
                    FLOAT            *H,
                    const INTEGER    *LDH,
                    const INTEGER    *ILOZ,
                    const INTEGER    *IHIZ,
                    FLOAT            *Z,
                    const INTEGER    *LDZ,
                    INTEGER          *NS,
                    INTEGER          *ND,
                    FLOAT            *SR,
                    FLOAT            *SI,
                    FLOAT            *V,
                    const INTEGER    *LDV,
                    const INTEGER    *NH,
                    FLOAT            *T,
                    const INTEGER    *LDT,
                    const INTEGER    *NV,
                    FLOAT            *WV,
                    const INTEGER    *LDWV,
                    FLOAT            *WORK,
                    const INTEGER    *LWORK)
{
    DEBUG_LAPACK_STUB("slaqr3");
    LAPACK_IMPL(slaqr3)(WANTT,
                        WANTZ,
                        N,
                        KTOP,
                        KBOT,
                        NW,
    