/*
  Copyright (C) 2000-2007

  Code contributed by Greg Collecutt, Joseph Hope and the xmds-devel team

  This file is part of xmds.

  This program is free software; you can redistribute it and/or
  modify it under the terms of the GNU General Public License
  as published by the Free Software Foundation; either version 2
  of the License, or (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
*/

/*
  $Id: xmds_sequence.h 1507 2007-08-15 09:47:34Z paultcochrane $
*/

/*! @file xmds_sequence.h
  @brief 

  More detailed explanation...
*/

#ifndef XMDS_SEQUENCE_H
#define XMDS_SEQUENCE_H

#include <xmds_segment.h>

// *****************************************************************************
// *****************************************************************************
//                              xmdsSequence
// *****************************************************************************
// *****************************************************************************

//! I think this organises the sequence in which elements of the simulation are processed.
class xmdsSequence : public xmdsSegment {

  public :

    //! Constructor for xmdsSequence object
    xmdsSequence(
     const xmdsSimulation *const yourSimulation,
     const bool& yourVerboseMode);

  //! Destructor
  ~xmdsSequence();

  //! Processes elements within an xmds sequence
  void processElement(
                      const Element *const yourElement);

  //! Returns the output sample count of the sequence
  void outputSampleCount() const;

  //! Whether or not the segment needs to run when the simulation is in overtime
  bool runsInOvertime() const;

  private :

    unsigned long nCycles;                   //!< The number of cycles in the sequence
  list<const xmdsSegment*> mySegmentList;  //!< The list of segments

  //! Write the sequence defines to file
  void writeDefines(
                    FILE *const outfile) const;

  //! Write the sequence globals to file
  void writeGlobals(
                    FILE *const outfile) const;

  //! Write the sequence prototypes to file
  void writePrototypes(
                       FILE *const outfile) const;

  //! Write the sequence routines to file
  void writeRoutines(
                     FILE *const outfile) const;

  //! Create an xmds sequence object
  xmdsSegment* createxmdsSequence();

  //! Create an xmds integrate RK4 EX object
  xmdsSegment* createxmdsIntegrateRK4EX();

  //! Create an xmds integrate RK4 IP object
  xmdsSegment* createxmdsIntegrateRK4IP();

  //! Create an xmds integrate RK9 EX object
  xmdsSegment* createxmdsIntegrateRK9EX();

  //! Create an xmds integrate RK9 IP object
  xmdsSegment* createxmdsIntegrateRK9IP();

  //! Create an xmds integrate ARK45 EX object
  xmdsSegment* createxmdsIntegrateARK45EX();

  //! Create an xmds integrate ARK45 IP object
  xmdsSegment* createxmdsIntegrateARK45IP();

  //! Create an xmds integrate ARK89 EX object
  xmdsSegment* createxmdsIntegrateARK89EX();

  //! Create an xmds integrate ARK89 IP object
  xmdsSegment* createxmdsIntegrateARK89IP();

  //! Create an xmds integrate SI EX object
  xmdsSegment* createxmdsIntegrateSIEX();

  //! Create an xmds integrate SI IP object
  xmdsSegment* createxmdsIntegrateSIIP();

  //! Create an xmds filte object
  xmdsSegment* createxmdsFilter();

  //! Create an xmds breakpoint object
  xmdsSegment* createxmdsBreakpoint();
};

//! Structure containing components of an xmdsSequence
struct coStruct {

  unsigned long componentNumber;           //!< The component number
  list<unsigned long> operatorNumbersList; //!< The operator numbers list
  list<unsigned long> coKeysList;          //!< The component keys list
};

//! Structure containing components of an integrate moment group
struct integrateMomentGroup {

  list<XMLString> momentNameList;           //!< The list of moment names
  list<bool>      integrateDimensionList;   //!< List of whether dimensions are integrated
  XMLString       integrateMomentGroupCode; //!< The integrate moment group code
};


#endif // XMDS_SEQUENCE_H
