/* xkeycaps, Copyright (c) 1991, 1992, 1993, 1995, 1996
 * Jamie Zawinski <jwz@jwz.org>
 *
 * This file describes the default keymap of the Apple Standard ADB keyboard
 * for X11R6 server on NetBSD/mac68k.  By Ken Nakata <kenn@remus.rutgers.edu>.
 */

static const struct default_keycode_map macstd_map [] = {
  {   0, 0,		{ XK_A }},
  {   1, 0,		{ XK_S }},
  {   2, 0,		{ XK_D }},
  {   3, 0,		{ XK_F }},
  {   4, 0,		{ XK_H }},
  {   5, 0,		{ XK_G }},
  {   6, 0,		{ XK_Z }},
  {   7, 0,		{ XK_X }},
  {   8, 0,		{ XK_C }},
  {   9, 0,		{ XK_V }},
  {  11, 0,		{ XK_B }},
  {  12, 0,		{ XK_Q }},
  {  13, 0,		{ XK_W }},
  {  14, 0,		{ XK_E }},
  {  15, 0,		{ XK_R }},
  {  16, 0,		{ XK_Y }},
  {  17, 0,		{ XK_T }},
  {  18, 0,		{ XK_1,	XK_exclam }},
  {  19, 0,		{ XK_2,	XK_at }},
  {  20, 0,		{ XK_3,	XK_numbersign }},
  {  21, 0,		{ XK_4,	XK_dollar }},
  {  22, 0,		{ XK_6,	XK_asciicircum }},
  {  23, 0,		{ XK_5,	XK_percent }},
  {  24, 0,		{ XK_equal,	XK_plus }},
  {  25, 0,		{ XK_9,	XK_parenleft }},
  {  26, 0,		{ XK_7,	XK_ampersand }},
  {  27, 0,		{ XK_minus,	XK_underscore }},
  {  28, 0,		{ XK_8,	XK_asterisk }},
  {  29, 0,		{ XK_0,	XK_parenright }},
  {  30, 0,		{ XK_bracketright,	XK_braceright }},
  {  31, 0,		{ XK_O }},
  {  32, 0,		{ XK_U }},
  {  33, 0,		{ XK_bracketleft,	XK_braceleft }},
  {  34, 0,		{ XK_I }},
  {  35, 0,		{ XK_P }},
  {  36, 0,		{ XK_Return }},
  {  37, 0,		{ XK_L }},
  {  38, 0,		{ XK_J }},
  {  39, 0,		{ XK_apostrophe,	XK_quotedbl }},
  {  40, 0,		{ XK_K }},
  {  41, 0,		{ XK_semicolon,	XK_colon }},
  {  42, 0,		{ XK_backslash,	XK_bar }},
  {  43, 0,		{ XK_comma,	XK_less }},
  {  44, 0,		{ XK_slash,	XK_question }},
  {  45, 0,		{ XK_N }},
  {  46, 0,		{ XK_M }},
  {  47, 0,		{ XK_period,	XK_greater }},
  {  48, 0,		{ XK_Tab }},
  {  49, 0,		{ XK_space }},
  {  50, 0,		{ XK_grave,	XK_asciitilde }},
  {  51, 0,		{ XK_Delete }},
  {  53, 0,		{ XK_Escape }},
  {  54, ControlMask,	{ XK_Control_L }},
  {  55, 0,		{ XK_Meta_L }},
  {  56, ShiftMask,	{ XK_Shift_L }},
  {  57, LockMask,	{ XK_Caps_Lock }},
  {  58, Mod1Mask,	{ XK_Alt_L }},
  {  59, 0,		{ XK_Left }},
  {  60, 0,		{ XK_Right }},
  {  61, 0,		{ XK_Control_R }},
  {  62, 0,		{ XK_Meta_R }},
  {  65, 0,		{ XK_KP_Decimal }},
  {  67, 0,		{ XK_KP_Multiply }},
  {  69, 0,		{ XK_KP_Add }},
  {  71, 0,		{ XK_Clear }},
  {  75, 0,		{ XK_KP_Divide }},
  {  76, 0,		{ XK_KP_Enter }},
  {  78, 0,		{ XK_KP_Subtract }},
  {  81, 0,		{ XK_KP_Equal }},
  {  82, 0,		{ XK_KP_0 }},
  {  83, 0,		{ XK_KP_1 }},
  {  84, 0,		{ XK_KP_2 }},
  {  85, 0,		{ XK_KP_3 }},
  {  86, 0,		{ XK_KP_4 }},
  {  87, 0,		{ XK_KP_5 }},
  {  88, 0,		{ XK_KP_6 }},
  {  89, 0,		{ XK_KP_7 }},
  {  91, 0,		{ XK_KP_8 }},
  {  92, 0,		{ XK_KP_9 }},
  {  96, 0,		{ XK_F5 }},
  {  97, 0,		{ XK_F6 }},
  {  98, 0,		{ XK_F7 }},
  {  99, 0,		{ XK_F3 }},
  { 100, 0,		{ XK_F8 }},
  { 101, 0,		{ XK_F9 }},
  { 103, 0,		{ XK_F11 }},
  { 105, 0,		{ XK_F13,	XK_Print }},
  { 107, 0,		{ XK_F14,	XK_Pause }},
  { 109, 0,		{ XK_F10 }},
  { 111, 0,		{ XK_F12 }},
  { 112, 0,		{ XK_Up }},
  { 113, 0,		{ XK_F15,	XK_Pause }},
  { 114, 0,		{ XK_Help,	XK_Insert }},
  { 115, 0,		{ XK_Home }},
  { 116, 0,		{ XK_Prior }},
  { 117, 0,		{ XK_Delete }},
  { 118, 0,		{ XK_F4 }},
  { 119, 0,		{ XK_End }},
  { 120, 0,		{ XK_F2 }},
  { 121, 0,		{ XK_Next }},
  { 122, 0,		{ XK_F1 }},
  { 123, 0,		{ XK_Right }},
  { 124, 0,		{ XK_Left }},
  { 125, 0,		{ XK_Down }},
  };
