/*
 * Decompiled with CFR 0.152.
 */
package org.j3d.geom.particle;

public class TexCoordInterpolator {
    private float[] keyValues;
    private final int texCoordSize;
    protected int currentSize;
    protected float[] keys;

    TexCoordInterpolator(int n) {
        this.texCoordSize = n;
    }

    void setupInterpolants(float[] fArray, int n, float[] fArray2) {
        if (this.keys == null || this.keys.length < n) {
            this.keys = new float[n];
            this.keyValues = new float[n * this.texCoordSize * 2];
        }
        System.arraycopy(fArray, 0, this.keys, 0, n);
        System.arraycopy(fArray2, 0, this.keyValues, 0, n * this.texCoordSize * 2);
        this.currentSize = n;
    }

    public void interpolate(float f, int n, float[] fArray) {
        int n2 = this.findKeyIndex(f);
        switch (this.texCoordSize) {
            case 2: {
                fArray[n] = this.keyValues[n2 * 4];
                fArray[n + 1] = this.keyValues[n2 * 4 + 1];
                fArray[n + 2] = this.keyValues[n2 * 4 + 2];
                fArray[n + 3] = this.keyValues[n2 * 4 + 3];
                break;
            }
            case 3: {
                fArray[n] = this.keyValues[n2 * 6];
                fArray[n + 1] = this.keyValues[n2 * 6 + 1];
                fArray[n + 2] = this.keyValues[n2 * 6 + 2];
                fArray[n + 3] = this.keyValues[n2 * 6 + 3];
                fArray[n + 4] = this.keyValues[n2 * 6 + 4];
                fArray[n + 5] = this.keyValues[n2 * 6 + 5];
                break;
            }
            case 4: {
                fArray[n] = this.keyValues[n2 * 8];
                fArray[n + 1] = this.keyValues[n2 * 8 + 1];
                fArray[n + 2] = this.keyValues[n2 * 8 + 2];
                fArray[n + 3] = this.keyValues[n2 * 8 + 3];
                fArray[n + 4] = this.keyValues[n2 * 8 + 4];
                fArray[n + 5] = this.keyValues[n2 * 8 + 5];
                fArray[n + 6] = this.keyValues[n2 * 8 + 6];
                fArray[n + 7] = this.keyValues[n2 * 8 + 7];
            }
        }
    }

    private final int findKeyIndex(float f) {
        if (this.currentSize == 0 || f <= this.keys[0]) {
            return 0;
        }
        if (f >= this.keys[this.currentSize - 1]) {
            return this.currentSize - 1;
        }
        int n = 0;
        int n2 = this.currentSize - 1;
        int n3 = this.currentSize >> 1;
        while (n < n2) {
            float f2 = this.keys[n3];
            if (f2 >= f) {
                n2 = n3 - 1;
            } else {
                n = n3;
            }
            n3 = n + n2 + 1 >> 1;
        }
        return n3;
    }
}

