// Copyright 2015, VIXL authors
// All rights reserved.
//
// Redistribution and use in source and binary forms, with or without
// modification, are permitted provided that the following conditions are met:
//
//   * Redistributions of source code must retain the above copyright notice,
//     this list of conditions and the following disclaimer.
//   * Redistributions in binary form must reproduce the above copyright notice,
//     this list of conditions and the following disclaimer in the documentation
//     and/or other materials provided with the distribution.
//   * Neither the name of ARM Limited nor the names of its contributors may be
//     used to endorse or promote products derived from this software without
//     specific prior written permission.
//
// THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS CONTRIBUTORS "AS IS" AND
// ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
// WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
// DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE
// FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
// DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
// SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
// CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
// OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
// OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.


// ---------------------------------------------------------------------
// This file is auto generated using tools/generate_simulator_traces.py.
//
// PLEASE DO NOT EDIT.
// ---------------------------------------------------------------------

#ifndef VIXL_SIM_SADDL2_8H_TRACE_AARCH64_H_
#define VIXL_SIM_SADDL2_8H_TRACE_AARCH64_H_

const uint16_t kExpected_NEON_saddl2_8H[] = {
  0xff06, 0xff54, 0xff98, 0xfff0, 0xfffa, 0xfffc, 0xfffe, 0x0000,
  0xff2d, 0xff76, 0xffc4, 0xfff5, 0xfffb, 0xfffd, 0xffff, 0x0001,
  0xff4f, 0xffa2, 0xffc9, 0xfff6, 0xfffc, 0xfffe, 0x0000, 0x0002,
  0xff7b, 0xffa7, 0xffca, 0xfff7, 0xfffd, 0xffff, 0x0001, 0x0008,
  0xff80, 0xffa8, 0xffcb, 0xfff8, 0xfffe, 0x0000, 0x0007, 0x0033,
  0xff81, 0xffa9, 0xffcc, 0xfff9, 0xffff, 0x0006, 0x0032, 0x0055,
  0xff82, 0xffaa, 0xffcd, 0xfffa, 0x0005, 0x0031, 0x0054, 0x007d,
  0xff83, 0xffab, 0xffce, 0x0000, 0x0030, 0x0053, 0x007c, 0x007e,
  0xff84, 0xffac, 0xffd4, 0x002b, 0x0052, 0x007b, 0x007d, 0x007f,
  0xff85, 0xffb2, 0xffff, 0x004d, 0x007a, 0x007c, 0x007e, 0xff80,
  0xff8b, 0xffdd, 0x0021, 0x0075, 0x007b, 0x007d, 0xff7f, 0xff81,
  0xffb6, 0xffff, 0x0049, 0x0076, 0x007c, 0xff7e, 0xff80, 0xff82,
  0xffd8, 0x0027, 0x004a, 0x0077, 0xff7d, 0xff7f, 0xff81, 0xff83,
  0x0000, 0x0028, 0x004b, 0xff78, 0xff7e, 0xff80, 0xff82, 0xffaa,
  0x0001, 0x0029, 0xff4c, 0xff79, 0xff7f, 0xff81, 0xffa9, 0xffcc,
  0x0002, 0xff2a, 0xff4d, 0xff7a, 0xff80, 0xffa8, 0xffcb, 0xfff8,
  0xff03, 0xff2b, 0xff4e, 0xff7b, 0xffa7, 0xffca, 0xfff7, 0xfffd,
  0xff04, 0xff2c, 0xff4f, 0xffa2, 0xffc9, 0xfff6, 0xfffc, 0xfffe,
  0xff05, 0xff2d, 0xff76, 0xffc4, 0xfff5, 0xfffb, 0xfffd, 0xffff,
  0xff2d, 0xff76, 0xffc4, 0xfff5, 0xfffb, 0xfffd, 0xffff, 0x0001,
  0xff54, 0xff98, 0xfff0, 0xfffa, 0xfffc, 0xfffe, 0x0000, 0x0002,
  0xff76, 0xffc4, 0xfff5, 0xfffb, 0xfffd, 0xffff, 0x0001, 0x0003,
  0xffa2, 0xffc9, 0xfff6, 0xfffc, 0xfffe, 0x0000, 0x0002, 0x0009,
  0xffa7, 0xffca, 0xfff7, 0xfffd, 0xffff, 0x0001, 0x0008, 0x0034,
  0xffa8, 0xffcb, 0xfff8, 0xfffe, 0x0000, 0x0007, 0x0033, 0x0056,
  0xffa9, 0xffcc, 0xfff9, 0xffff, 0x0006, 0x0032, 0x0055, 0x007e,
  0xffaa, 0xffcd, 0xfffa, 0x0005, 0x0031, 0x0054, 0x007d, 0x007f,
  0xffab, 0xffce, 0x0000, 0x0030, 0x0053, 0x007c, 0x007e, 0x0080,
  0xffac, 0xffd4, 0x002b, 0x0052, 0x007b, 0x007d, 0x007f, 0xff81,
  0xffb2, 0xffff, 0x004d, 0x007a, 0x007c, 0x007e, 0xff80, 0xff82,
  0xffdd, 0x0021, 0x0075, 0x007b, 0x007d, 0xff7f, 0xff81, 0xff83,
  0xffff, 0x0049, 0x0076, 0x007c, 0xff7e, 0xff80, 0xff82, 0xff84,
  0x0027, 0x004a, 0x0077, 0xff7d, 0xff7f, 0xff81, 0xff83, 0xffab,
  0x0028, 0x004b, 0xff78, 0xff7e, 0xff80, 0xff82, 0xffaa, 0xffcd,
  0x0029, 0xff4c, 0xff79, 0xff7f, 0xff81, 0xffa9, 0xffcc, 0xfff9,
  0xff2a, 0xff4d, 0xff7a, 0xff80, 0xffa8, 0xffcb, 0xfff8, 0xfffe,
  0xff2b, 0xff4e, 0xff7b, 0xffa7, 0xffca, 0xfff7, 0xfffd, 0xffff,
  0xff2c, 0xff4f, 0xffa2, 0xffc9, 0xfff6, 0xfffc, 0xfffe, 0x0000,
  0xff4f, 0xffa2, 0xffc9, 0xfff6, 0xfffc, 0xfffe, 0x0000, 0x0002,
  0xff76, 0xffc4, 0xfff5, 0xfffb, 0xfffd, 0xffff, 0x0001, 0x0003,
  0xff98, 0xfff0, 0xfffa, 0xfffc, 0xfffe, 0x0000, 0x0002, 0x0004,
  0xffc4, 0xfff5, 0xfffb, 0xfffd, 0xffff, 0x0001, 0x0003, 0x000a,
  0xffc9, 0xfff6, 0xfffc, 0xfffe, 0x0000, 0x0002, 0x0009, 0x0035,
  0xffca, 0xfff7, 0xfffd, 0xffff, 0x0001, 0x0008, 0x0034, 0x0057,
  0xffcb, 0xfff8, 0xfffe, 0x0000, 0x0007, 0x0033, 0x0056, 0x007f,
  0xffcc, 0xfff9, 0xffff, 0x0006, 0x0032, 0x0055, 0x007e, 0x0080,
  0xffcd, 0xfffa, 0x0005, 0x0031, 0x0054, 0x007d, 0x007f, 0x0081,
  0xffce, 0x0000, 0x0030, 0x0053, 0x007c, 0x007e, 0x0080, 0xff82,
  0xffd4, 0x002b, 0x0052, 0x007b, 0x007d, 0x007f, 0xff81, 0xff83,
  0xffff, 0x004d, 0x007a, 0x007c, 0x007e, 0xff80, 0xff82, 0xff84,
  0x0021, 0x0075, 0x007b, 0x007d, 0xff7f, 0xff81, 0xff83, 0xff85,
  0x0049, 0x0076, 0x007c, 0xff7e, 0xff80, 0xff82, 0xff84, 0xffac,
  0x004a, 0x0077, 0xff7d, 0xff7f, 0xff81, 0xff83, 0xffab, 0xffce,
  0x004b, 0xff78, 0xff7e, 0xff80, 0xff82, 0xffaa, 0xffcd, 0xfffa,
  0xff4c, 0xff79, 0xff7f, 0xff81, 0xffa9, 0xffcc, 0xfff9, 0xffff,
  0xff4d, 0xff7a, 0xff80, 0xffa8, 0xffcb, 0xfff8, 0xfffe, 0x0000,
  0xff4e, 0xff7b, 0xffa7, 0xffca, 0xfff7, 0xfffd, 0xffff, 0x0001,
  0xff7b, 0xffa7, 0xffca, 0xfff7, 0xfffd, 0xffff, 0x0001, 0x0008,
  0xffa2, 0xffc9, 0xfff6, 0xfffc, 0xfffe, 0x0000, 0x0002, 0x0009,
  0xffc4, 0xfff5, 0xfffb, 0xfffd, 0xffff, 0x0001, 0x0003, 0x000a,
  0xfff0, 0xfffa, 0xfffc, 0xfffe, 0x0000, 0x0002, 0x0004, 0x0010,
  0xfff5, 0xfffb, 0xfffd, 0xffff, 0x0001, 0x0003, 0x000a, 0x003b,
  0xfff6, 0xfffc, 0xfffe, 0x0000, 0x0002, 0x0009, 0x0035, 0x005d,
  0xfff7, 0xfffd, 0xffff, 0x0001, 0x0008, 0x0034, 0x0057, 0x0085,
  0xfff8, 0xfffe, 0x0000, 0x0007, 0x0033, 0x0056, 0x007f, 0x0086,
  0xfff9, 0xffff, 0x0006, 0x0032, 0x0055, 0x007e, 0x0080, 0x0087,
  0xfffa, 0x0005, 0x0031, 0x0054, 0x007d, 0x007f, 0x0081, 0xff88,
  0x0000, 0x0030, 0x0053, 0x007c, 0x007e, 0x0080, 0xff82, 0xff89,
  0x002b, 0x0052, 0x007b, 0x007d, 0x007f, 0xff81, 0xff83, 0xff8a,
  0x004d, 0x007a, 0x007c, 0x007e, 0xff80, 0xff82, 0xff84, 0xff8b,
  0x0075, 0x007b, 0x007d, 0xff7f, 0xff81, 0xff83, 0xff85, 0xffb2,
  0x0076, 0x007c, 0xff7e, 0xff80, 0xff82, 0xff84, 0xffac, 0xffd4,
  0x0077, 0xff7d, 0xff7f, 0xff81, 0xff83, 0xffab, 0xffce, 0x0000,
  0xff78, 0xff7e, 0xff80, 0xff82, 0xffaa, 0xffcd, 0xfffa, 0x0005,
  0xff79, 0xff7f, 0xff81, 0xffa9, 0xffcc, 0xfff9, 0xffff, 0x0006,
  0xff7a, 0xff80, 0xffa8, 0xffcb, 0xfff8, 0xfffe, 0x0000, 0x0007,
  0xff80, 0xffa8, 0xffcb, 0xfff8, 0xfffe, 0x0000, 0x0007, 0x0033,
  0xffa7, 0xffca, 0xfff7, 0xfffd, 0xffff, 0x0001, 0x0008, 0x0034,
  0xffc9, 0xfff6, 0xfffc, 0xfffe, 0x0000, 0x0002, 0x0009, 0x0035,
  0xfff5, 0xfffb, 0xfffd, 0xffff, 0x0001, 0x0003, 0x000a, 0x003b,
  0xfffa, 0xfffc, 0xfffe, 0x0000, 0x0002, 0x0004, 0x0010, 0x0066,
  0xfffb, 0xfffd, 0xffff, 0x0001, 0x0003, 0x000a, 0x003b, 0x0088,
  0xfffc, 0xfffe, 0x0000, 0x0002, 0x0009, 0x0035, 0x005d, 0x00b0,
  0xfffd, 0xffff, 0x0001, 0x0008, 0x0034, 0x0057, 0x0085, 0x00b1,
  0xfffe, 0x0000, 0x0007, 0x0033, 0x0056, 0x007f, 0x0086, 0x00b2,
  0xffff, 0x0006, 0x0032, 0x0055, 0x007e, 0x0080, 0x0087, 0xffb3,
  0x0005, 0x0031, 0x0054, 0x007d, 0x007f, 0x0081, 0xff88, 0xffb4,
  0x0030, 0x0053, 0x007c, 0x007e, 0x0080, 0xff82, 0xff89, 0xffb5,
  0x0052, 0x007b, 0x007d, 0x007f, 0xff81, 0xff83, 0xff8a, 0xffb6,
  0x007a, 0x007c, 0x007e, 0xff80, 0xff82, 0xff84, 0xff8b, 0xffdd,
  0x007b, 0x007d, 0xff7f, 0xff81, 0xff83, 0xff85, 0xffb2, 0xffff,
  0x007c, 0xff7e, 0xff80, 0xff82, 0xff84, 0xffac, 0xffd4, 0x002b,
  0xff7d, 0xff7f, 0xff81, 0xff83, 0xffab, 0xffce, 0x0000, 0x0030,
  0xff7e, 0xff80, 0xff82, 0xffaa, 0xffcd, 0xfffa, 0x0005, 0x0031,
  0xff7f, 0xff81, 0xffa9, 0xffcc, 0xfff9, 0xffff, 0x0006, 0x0032,
  0xff81, 0xffa9, 0xffcc, 0xfff9, 0xffff, 0x0006, 0x0032, 0x0055,
  0xffa8, 0xffcb, 0xfff8, 0xfffe, 0x0000, 0x0007, 0x0033, 0x0056,
  0xffca, 0xfff7, 0xfffd, 0xffff, 0x0001, 0x0008, 0x0034, 0x0057,
  0xfff6, 0xfffc, 0xfffe, 0x0000, 0x0002, 0x0009, 0x0035, 0x005d,
  0xfffb, 0xfffd, 0xffff, 0x0001, 0x0003, 0x000a, 0x003b, 0x0088,
  0xfffc, 0xfffe, 0x0000, 0x0002, 0x0004, 0x0010, 0x0066, 0x00aa,
  0xfffd, 0xffff, 0x0001, 0x0003, 0x000a, 0x003b, 0x0088, 0x00d2,
  0xfffe, 0x0000, 0x0002, 0x0009, 0x0035, 0x005d, 0x00b0, 0x00d3,
  0xffff, 0x0001, 0x0008, 0x0034, 0x0057, 0x0085, 0x00b1, 0x00d4,
  0x0000, 0x0007, 0x0033, 0x0056, 0x007f, 0x0086, 0x00b2, 0xffd5,
  0x0006, 0x0032, 0x0055, 0x007e, 0x0080, 0x0087, 0xffb3, 0xffd6,
  0x0031, 0x0054, 0x007d, 0x007f, 0x0081, 0xff88, 0xffb4, 0xffd7,
  0x0053, 0x007c, 0x007e, 0x0080, 0xff82, 0xff89, 0xffb5, 0xffd8,
  0x007b, 0x007d, 0x007f, 0xff81, 0xff83, 0xff8a, 0xffb6, 0xffff,
  0x007c, 0x007e, 0xff80, 0xff82, 0xff84, 0xff8b, 0xffdd, 0x0021,
  0x007d, 0xff7f, 0xff81, 0xff83, 0xff85, 0xffb2, 0xffff, 0x004d,
  0xff7e, 0xff80, 0xff82, 0xff84, 0xffac, 0xffd4, 0x002b, 0x0052,
  0xff7f, 0xff81, 0xff83, 0xffab, 0xffce, 0x0000, 0x0030, 0x0053,
  0xff80, 0xff82, 0xffaa, 0xffcd, 0xfffa, 0x0005, 0x0031, 0x0054,
  0xff82, 0xffaa, 0xffcd, 0xfffa, 0x0005, 0x0031, 0x0054, 0x007d,
  0xffa9, 0xffcc, 0xfff9, 0xffff, 0x0006, 0x0032, 0x0055, 0x007e,
  0xffcb, 0xfff8, 0xfffe, 0x0000, 0x0007, 0x0033, 0x0056, 0x007f,
  0xfff7, 0xfffd, 0xffff, 0x0001, 0x0008, 0x0034, 0x0057, 0x0085,
  0xfffc, 0xfffe, 0x0000, 0x0002, 0x0009, 0x0035, 0x005d, 0x00b0,
  0xfffd, 0xffff, 0x0001, 0x0003, 0x000a, 0x003b, 0x0088, 0x00d2,
  0xfffe, 0x0000, 0x0002, 0x0004, 0x0010, 0x0066, 0x00aa, 0x00fa,
  0xffff, 0x0001, 0x0003, 0x000a, 0x003b, 0x0088, 0x00d2, 0x00fb,
  0x0000, 0x0002, 0x0009, 0x0035, 0x005d, 0x00b0, 0x00d3, 0x00fc,
  0x0001, 0x0008, 0x0034, 0x0057, 0x0085, 0x00b1, 0x00d4, 0xfffd,
  0x0007, 0x0033, 0x0056, 0x007f, 0x0086, 0x00b2, 0xffd5, 0xfffe,
  0x0032, 0x0055, 0x007e, 0x0080, 0x0087, 0xffb3, 0xffd6, 0xffff,
  0x0054, 0x007d, 0x007f, 0x0081, 0xff88, 0xffb4, 0xffd7, 0x0000,
  0x007c, 0x007e, 0x0080, 0xff82, 0xff89, 0xffb5, 0xffd8, 0x0027,
  0x007d, 0x007f, 0xff81, 0xff83, 0xff8a, 0xffb6, 0xffff, 0x0049,
  0x007e, 0xff80, 0xff82, 0xff84, 0xff8b, 0xffdd, 0x0021, 0x0075,
  0xff7f, 0xff81, 0xff83, 0xff85, 0xffb2, 0xffff, 0x004d, 0x007a,
  0xff80, 0xff82, 0xff84, 0xffac, 0xffd4, 0x002b, 0x0052, 0x007b,
  0xff81, 0xff83, 0xffab, 0xffce, 0x0000, 0x0030, 0x0053, 0x007c,
  0xff83, 0xffab, 0xffce, 0x0000, 0x0030, 0x0053, 0x007c, 0x007e,
  0xffaa, 0xffcd, 0xfffa, 0x0005, 0x0031, 0x0054, 0x007d, 0x007f,
  0xffcc, 0xfff9, 0xffff, 0x0006, 0x0032, 0x0055, 0x007e, 0x0080,
  0xfff8, 0xfffe, 0x0000, 0x0007, 0x0033, 0x0056, 0x007f, 0x0086,
  0xfffd, 0xffff, 0x0001, 0x0008, 0x0034, 0x0057, 0x0085, 0x00b1,
  0xfffe, 0x0000, 0x0002, 0x0009, 0x0035, 0x005d, 0x00b0, 0x00d3,
  0xffff, 0x0001, 0x0003, 0x000a, 0x003b, 0x0088, 0x00d2, 0x00fb,
  0x0000, 0x0002, 0x0004, 0x0010, 0x0066, 0x00aa, 0x00fa, 0x00fc,
  0x0001, 0x0003, 0x000a, 0x003b, 0x0088, 0x00d2, 0x00fb, 0x00fd,
  0x0002, 0x0009, 0x0035, 0x005d, 0x00b0, 0x00d3, 0x00fc, 0xfffe,
  0x0008, 0x0034, 0x0057, 0x0085, 0x00b1, 0x00d4, 0xfffd, 0xffff,
  0x0033, 0x0056, 0x007f, 0x0086, 0x00b2, 0xffd5, 0xfffe, 0x0000,
  0x0055, 0x007e, 0x0080, 0x0087, 0xffb3, 0xffd6, 0xffff, 0x0001,
  0x007d, 0x007f, 0x0081, 0xff88, 0xffb4, 0xffd7, 0x0000, 0x0028,
  0x007e, 0x0080, 0xff82, 0xff89, 0xffb5, 0xffd8, 0x0027, 0x004a,
  0x007f, 0xff81, 0xff83, 0xff8a, 0xffb6, 0xffff, 0x0049, 0x0076,
  0xff80, 0xff82, 0xff84, 0xff8b, 0xffdd, 0x0021, 0x0075, 0x007b,
  0xff81, 0xff83, 0xff85, 0xffb2, 0xffff, 0x004d, 0x007a, 0x007c,
  0xff82, 0xff84, 0xffac, 0xffd4, 0x002b, 0x0052, 0x007b, 0x007d,
  0xff84, 0xffac, 0xffd4, 0x002b, 0x0052, 0x007b, 0x007d, 0x007f,
  0xffab, 0xffce, 0x0000, 0x0030, 0x0053, 0x007c, 0x007e, 0x0080,
  0xffcd, 0xfffa, 0x0005, 0x0031, 0x0054, 0x007d, 0x007f, 0x0081,
  0xfff9, 0xffff, 0x0006, 0x0032, 0x0055, 0x007e, 0x0080, 0x0087,
  0xfffe, 0x0000, 0x0007, 0x0033, 0x0056, 0x007f, 0x0086, 0x00b2,
  0xffff, 0x0001, 0x0008, 0x0034, 0x0057, 0x0085, 0x00b1, 0x00d4,
  0x0000, 0x0002, 0x0009, 0x0035, 0x005d, 0x00b0, 0x00d3, 0x00fc,
  0x0001, 0x0003, 0x000a, 0x003b, 0x0088, 0x00d2, 0x00fb, 0x00fd,
  0x0002, 0x0004, 0x0010, 0x0066, 0x00aa, 0x00fa, 0x00fc, 0x00fe,
  0x0003, 0x000a, 0x003b, 0x0088, 0x00d2, 0x00fb, 0x00fd, 0xffff,
  0x0009, 0x0035, 0x005d, 0x00b0, 0x00d3, 0x00fc, 0xfffe, 0x0000,
  0x0034, 0x0057, 0x0085, 0x00b1, 0x00d4, 0xfffd, 0xffff, 0x0001,
  0x0056, 0x007f, 0x0086, 0x00b2, 0xffd5, 0xfffe, 0x0000, 0x0002,
  0x007e, 0x0080, 0x0087, 0xffb3, 0xffd6, 0xffff, 0x0001, 0x0029,
  0x007f, 0x0081, 0xff88, 0xffb4, 0xffd7, 0x0000, 0x0028, 0x004b,
  0x0080, 0xff82, 0xff89, 0xffb5, 0xffd8, 0x0027, 0x004a, 0x0077,
  0xff81, 0xff83, 0xff8a, 0xffb6, 0xffff, 0x0049, 0x0076, 0x007c,
  0xff82, 0xff84, 0xff8b, 0xffdd, 0x0021, 0x0075, 0x007b, 0x007d,
  0xff83, 0xff85, 0xffb2, 0xffff, 0x004d, 0x007a, 0x007c, 0x007e,
  0xff85, 0xffb2, 0xffff, 0x004d, 0x007a, 0x007c, 0x007e, 0xff80,
  0xffac, 0xffd4, 0x002b, 0x0052, 0x007b, 0x007d, 0x007f, 0xff81,
  0xffce, 0x0000, 0x0030, 0x0053, 0x007c, 0x007e, 0x0080, 0xff82,
  0xfffa, 0x0005, 0x0031, 0x0054, 0x007d, 0x007f, 0x0081, 0xff88,
  0xffff, 0x0006, 0x0032, 0x0055, 0x007e, 0x0080, 0x0087, 0xffb3,
  0x0000, 0x0007, 0x0033, 0x0056, 0x007f, 0x0086, 0x00b2, 0xffd5,
  0x0001, 0x0008, 0x0034, 0x0057, 0x0085, 0x00b1, 0x00d4, 0xfffd,
  0x0002, 0x0009, 0x0035, 0x005d, 0x00b0, 0x00d3, 0x00fc, 0xfffe,
  0x0003, 0x000a, 0x003b, 0x0088, 0x00d2, 0x00fb, 0x00fd, 0xffff,
  0x0004, 0x0010, 0x0066, 0x00aa, 0x00fa, 0x00fc, 0x00fe, 0xff00,
  0x000a, 0x003b, 0x0088, 0x00d2, 0x00fb, 0x00fd, 0xffff, 0xff01,
  0x0035, 0x005d, 0x00b0, 0x00d3, 0x00fc, 0xfffe, 0x0000, 0xff02,
  0x0057, 0x0085, 0x00b1, 0x00d4, 0xfffd, 0xffff, 0x0001, 0xff03,
  0x007f, 0x0086, 0x00b2, 0xffd5, 0xfffe, 0x0000, 0x0002, 0xff2a,
  0x0080, 0x0087, 0xffb3, 0xffd6, 0xffff, 0x0001, 0x0029, 0xff4c,
  0x0081, 0xff88, 0xffb4, 0xffd7, 0x0000, 0x0028, 0x004b, 0xff78,
  0xff82, 0xff89, 0xffb5, 0xffd8, 0x0027, 0x004a, 0x0077, 0xff7d,
  0xff83, 0xff8a, 0xffb6, 0xffff, 0x0049, 0x0076, 0x007c, 0xff7e,
  0xff84, 0xff8b, 0xffdd, 0x0021, 0x0075, 0x007b, 0x007d, 0xff7f,
  0xff8b, 0xffdd, 0x0021, 0x0075, 0x007b, 0x007d, 0xff7f, 0xff81,
  0xffb2, 0xffff, 0x004d, 0x007a, 0x007c, 0x007e, 0xff80, 0xff82,
  0xffd4, 0x002b, 0x0052, 0x007b, 0x007d, 0x007f, 0xff81, 0xff83,
  0x0000, 0x0030, 0x0053, 0x007c, 0x007e, 0x0080, 0xff82, 0xff89,
  0x0005, 0x0031, 0x0054, 0x007d, 0x007f, 0x0081, 0xff88, 0xffb4,
  0x0006, 0x0032, 0x0055, 0x007e, 0x0080, 0x0087, 0xffb3, 0xffd6,
  0x0007, 0x0033, 0x0056, 0x007f, 0x0086, 0x00b2, 0xffd5, 0xfffe,
  0x0008, 0x0034, 0x0057, 0x0085, 0x00b1, 0x00d4, 0xfffd, 0xffff,
  0x0009, 0x0035, 0x005d, 0x00b0, 0x00d3, 0x00fc, 0xfffe, 0x0000,
  0x000a, 0x003b, 0x0088, 0x00d2, 0x00fb, 0x00fd, 0xffff, 0xff01,
  0x0010, 0x0066, 0x00aa, 0x00fa, 0x00fc, 0x00fe, 0xff00, 0xff02,
  0x003b, 0x0088, 0x00d2, 0x00fb, 0x00fd, 0xffff, 0xff01, 0xff03,
  0x005d, 0x00b0, 0x00d3, 0x00fc, 0xfffe, 0x0000, 0xff02, 0xff04,
  0x0085, 0x00b1, 0x00d4, 0xfffd, 0xffff, 0x0001, 0xff03, 0xff2b,
  0x0086, 0x00b2, 0xffd5, 0xfffe, 0x0000, 0x0002, 0xff2a, 0xff4d,
  0x0087, 0xffb3, 0xffd6, 0xffff, 0x0001, 0x0029, 0xff4c, 0xff79,
  0xff88, 0xffb4, 0xffd7, 0x0000, 0x0028, 0x004b, 0xff78, 0xff7e,
  0xff89, 0xffb5, 0xffd8, 0x0027, 0x004a, 0x0077, 0xff7d, 0xff7f,
  0xff8a, 0xffb6, 0xffff, 0x0049, 0x0076, 0x007c, 0xff7e, 0xff80,
  0xffb6, 0xffff, 0x0049, 0x0076, 0x007c, 0xff7e, 0xff80, 0xff82,
  0xffdd, 0x0021, 0x0075, 0x007b, 0x007d, 0xff7f, 0xff81, 0xff83,
  0xffff, 0x004d, 0x007a, 0x007c, 0x007e, 0xff80, 0xff82, 0xff84,
  0x002b, 0x0052, 0x007b, 0x007d, 0x007f, 0xff81, 0xff83, 0xff8a,
  0x0030, 0x0053, 0x007c, 0x007e, 0x0080, 0xff82, 0xff89, 0xffb5,
  0x0031, 0x0054, 0x007d, 0x007f, 0x0081, 0xff88, 0xffb4, 0xffd7,
  0x0032, 0x0055, 0x007e, 0x0080, 0x0087, 0xffb3, 0xffd6, 0xffff,
  0x0033, 0x0056, 0x007f, 0x0086, 0x00b2, 0xffd5, 0xfffe, 0x0000,
  0x0034, 0x0057, 0x0085, 0x00b1, 0x00d4, 0xfffd, 0xffff, 0x0001,
  0x0035, 0x005d, 0x00b0, 0x00d3, 0x00fc, 0xfffe, 0x0000, 0xff02,
  0x003b, 0x0088, 0x00d2, 0x00fb, 0x00fd, 0xffff, 0xff01, 0xff03,
  0x0066, 0x00aa, 0x00fa, 0x00fc, 0x00fe, 0xff00, 0xff02, 0xff04,
  0x0088, 0x00d2, 0x00fb, 0x00fd, 0xffff, 0xff01, 0xff03, 0xff05,
  0x00b0, 0x00d3, 0x00fc, 0xfffe, 0x0000, 0xff02, 0xff04, 0xff2c,
  0x00b1, 0x00d4, 0xfffd, 0xffff, 0x0001, 0xff03, 0xff2b, 0xff4e,
  0x00b2, 0xffd5, 0xfffe, 0x0000, 0x0002, 0xff2a, 0xff4d, 0xff7a,
  0xffb3, 0xffd6, 0xffff, 0x0001, 0x0029, 0xff4c, 0xff79, 0xff7f,
  0xffb4, 0xffd7, 0x0000, 0x0028, 0x004b, 0xff78, 0xff7e, 0xff80,
  0xffb5, 0xffd8, 0x0027, 0x004a, 0x0077, 0xff7d, 0xff7f, 0xff81,
  0xffd8, 0x0027, 0x004a, 0x0077, 0xff7d, 0xff7f, 0xff81, 0xff83,
  0xffff, 0x0049, 0x0076, 0x007c, 0xff7e, 0xff80, 0xff82, 0xff84,
  0x0021, 0x0075, 0x007b, 0x007d, 0xff7f, 0xff81, 0xff83, 0xff85,
  0x004d, 0x007a, 0x007c, 0x007e, 0xff80, 0xff82, 0xff84, 0xff8b,
  0x0052, 0x007b, 0x007d, 0x007f, 0xff81, 0xff83, 0xff8a, 0xffb6,
  0x0053, 0x007c, 0x007e, 0x0080, 0xff82, 0xff89, 0xffb5, 0xffd8,
  0x0054, 0x007d, 0x007f, 0x0081, 0xff88, 0xffb4, 0xffd7, 0x0000,
  0x0055, 0x007e, 0x0080, 0x0087, 0xffb3, 0xffd6, 0xffff, 0x0001,
  0x0056, 0x007f, 0x0086, 0x00b2, 0xffd5, 0xfffe, 0x0000, 0x0002,
  0x0057, 0x0085, 0x00b1, 0x00d4, 0xfffd, 0xffff, 0x0001, 0xff03,
  0x005d, 0x00b0, 0x00d3, 0x00fc, 0xfffe, 0x0000, 0xff02, 0xff04,
  0x0088, 0x00d2, 0x00fb, 0x00fd, 0xffff, 0xff01, 0xff03, 0xff05,
  0x00aa, 0x00fa, 0x00fc, 0x00fe, 0xff00, 0xff02, 0xff04, 0xff06,
  0x00d2, 0x00fb, 0x00fd, 0xffff, 0xff01, 0xff03, 0xff05, 0xff2d,
  0x00d3, 0x00fc, 0xfffe, 0x0000, 0xff02, 0xff04, 0xff2c, 0xff4f,
  0x00d4, 0xfffd, 0xffff, 0x0001, 0xff03, 0xff2b, 0xff4e, 0xff7b,
  0xffd5, 0xfffe, 0x0000, 0x0002, 0xff2a, 0xff4d, 0xff7a, 0xff80,
  0xffd6, 0xffff, 0x0001, 0x0029, 0xff4c, 0xff79, 0xff7f, 0xff81,
  0xffd7, 0x0000, 0x0028, 0x004b, 0xff78, 0xff7e, 0xff80, 0xff82,
  0x0000, 0x0028, 0x004b, 0xff78, 0xff7e, 0xff80, 0xff82, 0xffaa,
  0x0027, 0x004a, 0x0077, 0xff7d, 0xff7f, 0xff81, 0xff83, 0xffab,
  0x0049, 0x0076, 0x007c, 0xff7e, 0xff80, 0xff82, 0xff84, 0xffac,
  0x0075, 0x007b, 0x007d, 0xff7f, 0xff81, 0xff83, 0xff85, 0xffb2,
  0x007a, 0x007c, 0x007e, 0xff80, 0xff82, 0xff84, 0xff8b, 0xffdd,
  0x007b, 0x007d, 0x007f, 0xff81, 0xff83, 0xff8a, 0xffb6, 0xffff,
  0x007c, 0x007e, 0x0080, 0xff82, 0xff89, 0xffb5, 0xffd8, 0x0027,
  0x007d, 0x007f, 0x0081, 0xff88, 0xffb4, 0xffd7, 0x0000, 0x0028,
  0x007e, 0x0080, 0x0087, 0xffb3, 0xffd6, 0xffff, 0x0001, 0x0029,
  0x007f, 0x0086, 0x00b2, 0xffd5, 0xfffe, 0x0000, 0x0002, 0xff2a,
  0x0085, 0x00b1, 0x00d4, 0xfffd, 0xffff, 0x0001, 0xff03, 0xff2b,
  0x00b0, 0x00d3, 0x00fc, 0xfffe, 0x0000, 0xff02, 0xff04, 0xff2c,
  0x00d2, 0x00fb, 0x00fd, 0xffff, 0xff01, 0xff03, 0xff05, 0xff2d,
  0x00fa, 0x00fc, 0x00fe, 0xff00, 0xff02, 0xff04, 0xff06, 0xff54,
  0x00fb, 0x00fd, 0xffff, 0xff01, 0xff03, 0xff05, 0xff2d, 0xff76,
  0x00fc, 0xfffe, 0x0000, 0xff02, 0xff04, 0xff2c, 0xff4f, 0xffa2,
  0xfffd, 0xffff, 0x0001, 0xff03, 0xff2b, 0xff4e, 0xff7b, 0xffa7,
  0xfffe, 0x0000, 0x0002, 0xff2a, 0xff4d, 0xff7a, 0xff80, 0xffa8,
  0xffff, 0x0001, 0x0029, 0xff4c, 0xff79, 0xff7f, 0xff81, 0xffa9,
  0x0001, 0x0029, 0xff4c, 0xff79, 0xff7f, 0xff81, 0xffa9, 0xffcc,
  0x0028, 0x004b, 0xff78, 0xff7e, 0xff80, 0xff82, 0xffaa, 0xffcd,
  0x004a, 0x0077, 0xff7d, 0xff7f, 0xff81, 0xff83, 0xffab, 0xffce,
  0x0076, 0x007c, 0xff7e, 0xff80, 0xff82, 0xff84, 0xffac, 0xffd4,
  0x007b, 0x007d, 0xff7f, 0xff81, 0xff83, 0xff85, 0xffb2, 0xffff,
  0x007c, 0x007e, 0xff80, 0xff82, 0xff84, 0xff8b, 0xffdd, 0x0021,
  0x007d, 0x007f, 0xff81, 0xff83, 0xff8a, 0xffb6, 0xffff, 0x0049,
  0x007e, 0x0080, 0xff82, 0xff89, 0xffb5, 0xffd8, 0x0027, 0x004a,
  0x007f, 0x0081, 0xff88, 0xffb4, 0xffd7, 0x0000, 0x0028, 0x004b,
  0x0080, 0x0087, 0xffb3, 0xffd6, 0xffff, 0x0001, 0x0029, 0xff4c,
  0x0086, 0x00b2, 0xffd5, 0xfffe, 0x0000, 0x0002, 0xff2a, 0xff4d,
  0x00b1, 0x00d4, 0xfffd, 0xffff, 0x0001, 0xff03, 0xff2b, 0xff4e,
  0x00d3, 0x00fc, 0xfffe, 0x0000, 0xff02, 0xff04, 0xff2c, 0xff4f,
  0x00fb, 0x00fd, 0xffff, 0xff01, 0xff03, 0xff05, 0xff2d, 0xff76,
  0x00fc, 0x00fe, 0xff00, 0xff02, 0xff04, 0xff06, 0xff54, 0xff98,
  0x00fd, 0xffff, 0xff01, 0xff03, 0xff05, 0xff2d, 0xff76, 0xffc4,
  0xfffe, 0x0000, 0xff02, 0xff04, 0xff2c, 0xff4f, 0xffa2, 0xffc9,
  0xffff, 0x0001, 0xff03, 0xff2b, 0xff4e, 0xff7b, 0xffa7, 0xffca,
  0x0000, 0x0002, 0xff2a, 0xff4d, 0xff7a, 0xff80, 0xffa8, 0xffcb,
  0x0002, 0xff2a, 0xff4d, 0xff7a, 0xff80, 0xffa8, 0xffcb, 0xfff8,
  0x0029, 0xff4c, 0xff79, 0xff7f, 0xff81, 0xffa9, 0xffcc, 0xfff9,
  0x004b, 0xff78, 0xff7e, 0xff80, 0xff82, 0xffaa, 0xffcd, 0xfffa,
  0x0077, 0xff7d, 0xff7f, 0xff81, 0xff83, 0xffab, 0xffce, 0x0000,
  0x007c, 0xff7e, 0xff80, 0xff82, 0xff84, 0xffac, 0xffd4, 0x002b,
  0x007d, 0xff7f, 0xff81, 0xff83, 0xff85, 0xffb2, 0xffff, 0x004d,
  0x007e, 0xff80, 0xff82, 0xff84, 0xff8b, 0xffdd, 0x0021, 0x0075,
  0x007f, 0xff81, 0xff83, 0xff8a, 0xffb6, 0xffff, 0x0049, 0x0076,
  0x0080, 0xff82, 0xff89, 0xffb5, 0xffd8, 0x0027, 0x004a, 0x0077,
  0x0081, 0xff88, 0xffb4, 0xffd7, 0x0000, 0x0028, 0x004b, 0xff78,
  0x0087, 0xffb3, 0xffd6, 0xffff, 0x0001, 0x0029, 0xff4c, 0xff79,
  0x00b2, 0xffd5, 0xfffe, 0x0000, 0x0002, 0xff2a, 0xff4d, 0xff7a,
  0x00d4, 0xfffd, 0xffff, 0x0001, 0xff03, 0xff2b, 0xff4e, 0xff7b,
  0x00fc, 0xfffe, 0x0000, 0xff02, 0xff04, 0xff2c, 0xff4f, 0xffa2,
  0x00fd, 0xffff, 0xff01, 0xff03, 0xff05, 0xff2d, 0xff76, 0xffc4,
  0x00fe, 0xff00, 0xff02, 0xff04, 0xff06, 0xff54, 0xff98, 0xfff0,
  0xffff, 0xff01, 0xff03, 0xff05, 0xff2d, 0xff76, 0xffc4, 0xfff5,
  0x0000, 0xff02, 0xff04, 0xff2c, 0xff4f, 0xffa2, 0xffc9, 0xfff6,
  0x0001, 0xff03, 0xff2b, 0xff4e, 0xff7b, 0xffa7, 0xffca, 0xfff7,
  0xff03, 0xff2b, 0xff4e, 0xff7b, 0xffa7, 0xffca, 0xfff7, 0xfffd,
  0xff2a, 0xff4d, 0xff7a, 0xff80, 0xffa8, 0xffcb, 0xfff8, 0xfffe,
  0xff4c, 0xff79, 0xff7f, 0xff81, 0xffa9, 0xffcc, 0xfff9, 0xffff,
  0xff78, 0xff7e, 0xff80, 0xff82, 0xffaa, 0xffcd, 0xfffa, 0x0005,
  0xff7d, 0xff7f, 0xff81, 0xff83, 0xffab, 0xffce, 0x0000, 0x0030,
  0xff7e, 0xff80, 0xff82, 0xff84, 0xffac, 0xffd4, 0x002b, 0x0052,
  0xff7f, 0xff81, 0xff83, 0xff85, 0xffb2, 0xffff, 0x004d, 0x007a,
  0xff80, 0xff82, 0xff84, 0xff8b, 0xffdd, 0x0021, 0x0075, 0x007b,
  0xff81, 0xff83, 0xff8a, 0xffb6, 0xffff, 0x0049, 0x0076, 0x007c,
  0xff82, 0xff89, 0xffb5, 0xffd8, 0x0027, 0x004a, 0x0077, 0xff7d,
  0xff88, 0xffb4, 0xffd7, 0x0000, 0x0028, 0x004b, 0xff78, 0xff7e,
  0xffb3, 0xffd6, 0xffff, 0x0001, 0x0029, 0xff4c, 0xff79, 0xff7f,
  0xffd5, 0xfffe, 0x0000, 0x0002, 0xff2a, 0xff4d, 0xff7a, 0xff80,
  0xfffd, 0xffff, 0x0001, 0xff03, 0xff2b, 0xff4e, 0xff7b, 0xffa7,
  0xfffe, 0x0000, 0xff02, 0xff04, 0xff2c, 0xff4f, 0xffa2, 0xffc9,
  0xffff, 0xff01, 0xff03, 0xff05, 0xff2d, 0xff76, 0xffc4, 0xfff5,
  0xff00, 0xff02, 0xff04, 0xff06, 0xff54, 0xff98, 0xfff0, 0xfffa,
  0xff01, 0xff03, 0xff05, 0xff2d, 0xff76, 0xffc4, 0xfff5, 0xfffb,
  0xff02, 0xff04, 0xff2c, 0xff4f, 0xffa2, 0xffc9, 0xfff6, 0xfffc,
  0xff04, 0xff2c, 0xff4f, 0xffa2, 0xffc9, 0xfff6, 0xfffc, 0xfffe,
  0xff2b, 0xff4e, 0xff7b, 0xffa7, 0xffca, 0xfff7, 0xfffd, 0xffff,
  0xff4d, 0xff7a, 0xff80, 0xffa8, 0xffcb, 0xfff8, 0xfffe, 0x0000,
  0xff79, 0xff7f, 0xff81, 0xffa9, 0xffcc, 0xfff9, 0xffff, 0x0006,
  0xff7e, 0xff80, 0xff82, 0xffaa, 0xffcd, 0xfffa, 0x0005, 0x0031,
  0xff7f, 0xff81, 0xff83, 0xffab, 0xffce, 0x0000, 0x0030, 0x0053,
  0xff80, 0xff82, 0xff84, 0xffac, 0xffd4, 0x002b, 0x0052, 0x007b,
  0xff81, 0xff83, 0xff85, 0xffb2, 0xffff, 0x004d, 0x007a, 0x007c,
  0xff82, 0xff84, 0xff8b, 0xffdd, 0x0021, 0x0075, 0x007b, 0x007d,
  0xff83, 0xff8a, 0xffb6, 0xffff, 0x0049, 0x0076, 0x007c, 0xff7e,
  0xff89, 0xffb5, 0xffd8, 0x0027, 0x004a, 0x0077, 0xff7d, 0xff7f,
  0xffb4, 0xffd7, 0x0000, 0x0028, 0x004b, 0xff78, 0xff7e, 0xff80,
  0xffd6, 0xffff, 0x0001, 0x0029, 0xff4c, 0xff79, 0xff7f, 0xff81,
  0xfffe, 0x0000, 0x0002, 0xff2a, 0xff4d, 0xff7a, 0xff80, 0xffa8,
  0xffff, 0x0001, 0xff03, 0xff2b, 0xff4e, 0xff7b, 0xffa7, 0xffca,
  0x0000, 0xff02, 0xff04, 0xff2c, 0xff4f, 0xffa2, 0xffc9, 0xfff6,
  0xff01, 0xff03, 0xff05, 0xff2d, 0xff76, 0xffc4, 0xfff5, 0xfffb,
  0xff02, 0xff04, 0xff06, 0xff54, 0xff98, 0xfff0, 0xfffa, 0xfffc,
  0xff03, 0xff05, 0xff2d, 0xff76, 0xffc4, 0xfff5, 0xfffb, 0xfffd,
  0xff05, 0xff2d, 0xff76, 0xffc4, 0xfff5, 0xfffb, 0xfffd, 0xffff,
  0xff2c, 0xff4f, 0xffa2, 0xffc9, 0xfff6, 0xfffc, 0xfffe, 0x0000,
  0xff4e, 0xff7b, 0xffa7, 0xffca, 0xfff7, 0xfffd, 0xffff, 0x0001,
  0xff7a, 0xff80, 0xffa8, 0xffcb, 0xfff8, 0xfffe, 0x0000, 0x0007,
  0xff7f, 0xff81, 0xffa9, 0xffcc, 0xfff9, 0xffff, 0x0006, 0x0032,
  0xff80, 0xff82, 0xffaa, 0xffcd, 0xfffa, 0x0005, 0x0031, 0x0054,
  0xff81, 0xff83, 0xffab, 0xffce, 0x0000, 0x0030, 0x0053, 0x007c,
  0xff82, 0xff84, 0xffac, 0xffd4, 0x002b, 0x0052, 0x007b, 0x007d,
  0xff83, 0xff85, 0xffb2, 0xffff, 0x004d, 0x007a, 0x007c, 0x007e,
  0xff84, 0xff8b, 0xffdd, 0x0021, 0x0075, 0x007b, 0x007d, 0xff7f,
  0xff8a, 0xffb6, 0xffff, 0x0049, 0x0076, 0x007c, 0xff7e, 0xff80,
  0xffb5, 0xffd8, 0x0027, 0x004a, 0x0077, 0xff7d, 0xff7f, 0xff81,
  0xffd7, 0x0000, 0x0028, 0x004b, 0xff78, 0xff7e, 0xff80, 0xff82,
  0xffff, 0x0001, 0x0029, 0xff4c, 0xff79, 0xff7f, 0xff81, 0xffa9,
  0x0000, 0x0002, 0xff2a, 0xff4d, 0xff7a, 0xff80, 0xffa8, 0xffcb,
  0x0001, 0xff03, 0xff2b, 0xff4e, 0xff7b, 0xffa7, 0xffca, 0xfff7,
  0xff02, 0xff04, 0xff2c, 0xff4f, 0xffa2, 0xffc9, 0xfff6, 0xfffc,
  0xff03, 0xff05, 0xff2d, 0xff76, 0xffc4, 0xfff5, 0xfffb, 0xfffd,
  0xff04, 0xff06, 0xff54, 0xff98, 0xfff0, 0xfffa, 0xfffc, 0xfffe,
};
const unsigned kExpectedCount_NEON_saddl2_8H = 361;

#endif  // VIXL_SIM_SADDL2_8H_TRACE_AARCH64_H_
