/* vifm
 * Copyright (C) 2001 Ken Steen.
 * Copyright (C) 2011 xaizek.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA
 */

#include "undolist_menu.h"

#include <stddef.h> /* size_t */
#include <stdlib.h> /* realloc() */
#include <string.h> /* strdup() strlen() */

#include "../ui/ui.h"
#include "../utils/string_array.h"
#include "../undo.h"
#include "menus.h"

int
show_undolist_menu(view_t *view, int with_details)
{
	static menu_data_t m;
	menus_init_data(&m, view, strdup("Undolist"), strdup("Undolist is empty"));

	m.items = undolist(with_details);
	m.len = count_strings(m.items);

	/* Add additional entry before setting position. */
	if(m.len > 0)
	{
		m.len = add_to_string_array(&m.items, m.len, 1, "list end");
	}

	menus_set_pos(m.state, get_undolist_pos(with_details));

	/* Add current position mark to menu item. */
	if(m.len > 0)
	{
		const size_t len = (m.items[m.pos] != NULL) ? strlen(m.items[m.pos]) : 0;
		char *const new_line = realloc(m.items[m.pos], len + 1U + 1U);
		if(new_line != NULL)
		{
			m.items[m.pos] = new_line;
			memmove(m.items[m.pos] + 1, m.items[m.pos], len + 1U);
			m.items[m.pos][0] = '*';
		}
	}

	return menus_enter(m.state, view);
}

/* vim: set tabstop=2 softtabstop=2 shiftwidth=2 noexpandtab cinoptions-=(0 : */
/* vim: set cinoptions+=t0 filetype=c : */
