/*
    rain.h - Rainscatter map
    Copyright (C) 2016 Ladislav Vaiz <ok1zia@nagano.cz>

    This program is free software; you can redistribute it and/or
    modify it under the terms of the GNU General Public License
    version 2 as published by the Free Software Foundation.

*/

#include "header.h"

#ifndef __RAIN_H
#define __RAIN_H


#define RAIN_COLORS 15

#ifdef Z_HAVE_SDL

struct zhttp;
struct rain;

struct rain_km{
	float kx1, ky1;	  // left upper
	float kx2, ky2;	  // right upper
	float kx3, ky3;	  // left lower
	float kx4, ky4;	  // right lower
};

struct rain_provider{
	char *name; // const not freeed
	double h1, h2, w1, w2; // synchro points geo coordinates
	int hpx1, hpx2, wpx1, wpx2; // synchro points pixels 
	int top, left, bottom, right; // crop
	int *srccols;
	int srccolslen;
	int *translation; // index = src color, value = rain->colors index
	SDL_Surface *img;
    int *pal;

	struct rain *rain;
	int timer_id;
    struct zhttp *http;
	int w, h;
	GHashTable *hashes[RAIN_COLORS]; // of struct zbinbuf of struct rain_pixel
	gpointer (*hash_func)(short kx, short ky, int ci);
	int mask, step;
	double hmult, wmult;
	char *title;

	int ofs_min;
};

struct rain{
    int *colors, *bwcolors;
	int debug;

	struct rain_provider *meteox;
	struct rain_provider *wetteronline;
	struct rain_provider *chmi;
};

extern struct rain *grain;

struct rain *init_rain(void);
void free_rain(struct rain *rain);
void free_rain_provider(struct rain_provider *provider);

void rain_meteox_timer(void *arg);
void rain_meteox_downloaded(struct zhttp *http);
void rain_meteox_load(struct rain_provider *provider);
gpointer rain_meteox_hash(short px, short py, int color);

void rain_wetteronline_timer(void *arg);
void rain_wetteronline_downloaded(struct zhttp *http);
void rain_wetteronline_load(struct rain_provider *provider);
gpointer rain_wetteronline_hash(short px, short py, int color);

void rain_chmi_timer(void *arg);
void rain_chmi_downloaded(struct zhttp *http);
void rain_chmi_load(struct rain_provider *provider);
gpointer rain_chmi_hash(short px, short py, int color);

#endif
#endif
		
