/*****************************************************************************
    TRAVIS - Trajectory Analyzer and Visualizer
    http://www.travis-analyzer.de/

    Copyright (c) 2009-2014 Martin Brehm
                  2012-2014 Martin Thomas

    This file written by Martin Brehm.

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
*****************************************************************************/

#ifndef MICROHET_H
#define MICROHET_H

#include "xobject.h"
#include "xobarray.h"
#include "timestep.h"
#include "atomgroup.h"
#include "df.h"
#include "xintarray.h"
#include "2df.h"

// Change this to allow more bin entries
#define MH_BIN_TYPE unsigned short


class CMicroHet;


class CMicroHetObservation : public CxObject
{
public:
	void BuildSlices(char *s);
	void BuildZeroPlot(const char *s, bool absolute);
	void BuildName();
	char *m_sName;
	bool m_bUniform;
	bool m_bEdgeUniform;
	bool m_bCDF;
	bool m_bCDF_Dens;
	bool m_bCDF_Tot;
	bool m_bCDF_Mode3;
	int m_iCDFRes;
	double m_fRangeFac;
	void BuildCDF(int mode, int obs, const char *multibuf);
	void Create();
	void Parse();
	CMicroHetObservation();
	~CMicroHetObservation();
	CxObArray m_oaAtomGroups;
	bool m_bMass;
	bool m_bDensity;
	double m_fMaxVal;
	int m_iHistoRes;
	CDF **m_pHistogram;
	C2DF *m_pCDF;
	CMicroHet *m_pParent;
	int m_iCDFOffset;
	bool m_bCubicRoot;
	bool m_bCSV;
	bool m_bCDF_Dens_Uniform;
	CxDoubleArray m_faEmptyBinHalf;
	CxDoubleArray m_faEmptyBinZero;
	C2DF *m_pEmptyBinTD;
	bool m_bEmpty2D;
	int m_iEmpty2DRes;
	int m_iEmpty2DStride;
};


class CMicroHet : public CxObject
{
public:
	void ProcessAtom(int px, int py, int pz, int mass, int cl);
	void Process(CTimeStep *ts);
	void Bin(CMicroHetObservation *o, int zi, unsigned long *zero);
	void Zero();
	void Create();
	void Parse();
	CMicroHet();
	~CMicroHet();

	CxObArray m_oaObservations;

	bool m_bSphere;
	int m_iRes;
	int m_iResSqr;
	unsigned long m_iResTri;
	double m_fBinVolume;
	CxIntArray m_iaCuboidLength;
	CxDoubleArray m_faCuboidVolume;
//	bool m_bIntBin;

//	float *m_pBin;
	MH_BIN_TYPE *m_pIBin;

	int m_iCounter;
};


#endif
