# Tkabber OSD Module
# Author: Jan Hudec
# http://www.ucw.cz/~0rfelyus/twiki/view/Wishlist/TkabberOsdModule

if {![info exists ::osd] || $::osd == ""} {return}

namespace eval ::osd {
    set options ""
    set delay 5
    set osdfont ""
    set pipe ""
    array set statuses {}
}

proc ::osd::open_osd_cat {} {
    variable pipe
    variable options
    variable delay
    variable osdfont
    if {$pipe != ""} {
	close $pipe
	set pipe ""
    }
    set command "|osd_cat $options -d $delay -a$delay"
    if {$osdfont != ""} {
	append command " -f $osdfont"
    }
    debugmsg osd $command
    set pipe [open $command w]
    fconfigure $pipe -buffering line
}

proc ::osd::try_write {text} {
    variable pipe
    if {[catch {puts $pipe $text}]} {
	osd::open_osd_cat
	if {[catch {puts $pipe $text}]} {
	    debugmsg osd "Can't write to OSD"
	}
    }
}

proc ::osd::presence_notify {connid from type x args} {
    variable statuses

    if {[catch  { set nick [get_nick $connid $from chat] }]} {
        set nick "$from" 
    }
    
    if { "$nick"!="$from" } { 
        set thefrom "$nick ($from)" 
    } else { 
        set thefrom "$from" 
    }
    if { "$type"=="" } { set type "available" }

    set status ""
    set show ""
    foreach {attr val} $args {
	switch -- $attr {
	    -status   {set status $val}
	    -show     {set show   $val}
	}
    }

    if {"$status"!=""} { set status " ($status)" }
    if {"$show"!=""} { set type "$type/$show" }

    set newstatus "$thefrom: $type$status"
    
    if {[catch { set oldstatus $statuses($from) } ]} {
        set oldstatus "$newstatus"
    }

    if { "$newstatus"!="$oldstatus" } {
        osd::try_write "$newstatus"
    }

    set statuses($from) "$newstatus"
}

proc ::osd::chat_message_notify {chatid from type body extras} {
    if {[chat::is_our_jid $chatid $from] || ![cequal $type chat]} {
	return
    }

    foreach xelem $extras {
	jlib::wrapper:splitxml $xelem tag vars isempty chdata children
	
	# Don't notify if this 'empty' tag is present. It indicates
	# messages history in chat window.
	if {[cequal $tag ""] && \
		[cequal [jlib::wrapper:getattr $vars xmlns] tkabber:x:nolog]} {
	    return
	}
    }

    set nick [get_nick [chat::get_connid $chatid] $from $type]
    osd::try_write "New message from $nick"
}

proc ::osd::get_nick {connid jid type} {
    if {[catch {chat::get_nick $connid $jid $type} nick]} {
	return [chat::get_nick $jid $type]
    } else {
	return $nick
    }
}

hook::add postload_hook ::osd::open_osd_cat 100
foreach event $::osd {
    switch -- $event {
        presence { hook::add client_presence_hook ::osd::presence_notify 100 }
        chat_message { hook::add draw_message_hook ::osd::chat_message_notify 20 }
	default { debugmsg osd "Unsupported notify type $event" }
    }
}
# vim: set sw=4 sts=4:
