package vpc

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ListDhcpOptionsSets invokes the vpc.ListDhcpOptionsSets API synchronously
func (client *Client) ListDhcpOptionsSets(request *ListDhcpOptionsSetsRequest) (response *ListDhcpOptionsSetsResponse, err error) {
	response = CreateListDhcpOptionsSetsResponse()
	err = client.DoAction(request, response)
	return
}

// ListDhcpOptionsSetsWithChan invokes the vpc.ListDhcpOptionsSets API asynchronously
func (client *Client) ListDhcpOptionsSetsWithChan(request *ListDhcpOptionsSetsRequest) (<-chan *ListDhcpOptionsSetsResponse, <-chan error) {
	responseChan := make(chan *ListDhcpOptionsSetsResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ListDhcpOptionsSets(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ListDhcpOptionsSetsWithCallback invokes the vpc.ListDhcpOptionsSets API asynchronously
func (client *Client) ListDhcpOptionsSetsWithCallback(request *ListDhcpOptionsSetsRequest, callback func(response *ListDhcpOptionsSetsResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ListDhcpOptionsSetsResponse
		var err error
		defer close(result)
		response, err = client.ListDhcpOptionsSets(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ListDhcpOptionsSetsRequest is the request struct for api ListDhcpOptionsSets
type ListDhcpOptionsSetsRequest struct {
	*requests.RpcRequest
	ResourceOwnerId      requests.Integer `position:"Query" name:"ResourceOwnerId"`
	NextToken            string           `position:"Query" name:"NextToken"`
	DhcpOptionsSetId     *[]string        `position:"Query" name:"DhcpOptionsSetId"  type:"Repeated"`
	ResourceOwnerAccount string           `position:"Query" name:"ResourceOwnerAccount"`
	OwnerAccount         string           `position:"Query" name:"OwnerAccount"`
	DomainName           string           `position:"Query" name:"DomainName"`
	OwnerId              requests.Integer `position:"Query" name:"OwnerId"`
	DhcpOptionsSetName   string           `position:"Query" name:"DhcpOptionsSetName"`
	MaxResults           requests.Integer `position:"Query" name:"MaxResults"`
}

// ListDhcpOptionsSetsResponse is the response struct for api ListDhcpOptionsSets
type ListDhcpOptionsSetsResponse struct {
	*responses.BaseResponse
	NextToken       string           `json:"NextToken" xml:"NextToken"`
	RequestId       string           `json:"RequestId" xml:"RequestId"`
	DhcpOptionsSets []DhcpOptionsSet `json:"DhcpOptionsSets" xml:"DhcpOptionsSets"`
}

// CreateListDhcpOptionsSetsRequest creates a request to invoke ListDhcpOptionsSets API
func CreateListDhcpOptionsSetsRequest() (request *ListDhcpOptionsSetsRequest) {
	request = &ListDhcpOptionsSetsRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Vpc", "2016-04-28", "ListDhcpOptionsSets", "vpc", "openAPI")
	request.Method = requests.POST
	return
}

// CreateListDhcpOptionsSetsResponse creates a response to parse from ListDhcpOptionsSets response
func CreateListDhcpOptionsSetsResponse() (response *ListDhcpOptionsSetsResponse) {
	response = &ListDhcpOptionsSetsResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
