package vpc

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// EnableNatGatewayEcsMetric invokes the vpc.EnableNatGatewayEcsMetric API synchronously
func (client *Client) EnableNatGatewayEcsMetric(request *EnableNatGatewayEcsMetricRequest) (response *EnableNatGatewayEcsMetricResponse, err error) {
	response = CreateEnableNatGatewayEcsMetricResponse()
	err = client.DoAction(request, response)
	return
}

// EnableNatGatewayEcsMetricWithChan invokes the vpc.EnableNatGatewayEcsMetric API asynchronously
func (client *Client) EnableNatGatewayEcsMetricWithChan(request *EnableNatGatewayEcsMetricRequest) (<-chan *EnableNatGatewayEcsMetricResponse, <-chan error) {
	responseChan := make(chan *EnableNatGatewayEcsMetricResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.EnableNatGatewayEcsMetric(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// EnableNatGatewayEcsMetricWithCallback invokes the vpc.EnableNatGatewayEcsMetric API asynchronously
func (client *Client) EnableNatGatewayEcsMetricWithCallback(request *EnableNatGatewayEcsMetricRequest, callback func(response *EnableNatGatewayEcsMetricResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *EnableNatGatewayEcsMetricResponse
		var err error
		defer close(result)
		response, err = client.EnableNatGatewayEcsMetric(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// EnableNatGatewayEcsMetricRequest is the request struct for api EnableNatGatewayEcsMetric
type EnableNatGatewayEcsMetricRequest struct {
	*requests.RpcRequest
	DryRun       requests.Boolean `position:"Query" name:"DryRun"`
	NatGatewayId string           `position:"Query" name:"NatGatewayId"`
}

// EnableNatGatewayEcsMetricResponse is the response struct for api EnableNatGatewayEcsMetric
type EnableNatGatewayEcsMetricResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateEnableNatGatewayEcsMetricRequest creates a request to invoke EnableNatGatewayEcsMetric API
func CreateEnableNatGatewayEcsMetricRequest() (request *EnableNatGatewayEcsMetricRequest) {
	request = &EnableNatGatewayEcsMetricRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Vpc", "2016-04-28", "EnableNatGatewayEcsMetric", "vpc", "openAPI")
	request.Method = requests.POST
	return
}

// CreateEnableNatGatewayEcsMetricResponse creates a response to parse from EnableNatGatewayEcsMetric response
func CreateEnableNatGatewayEcsMetricResponse() (response *EnableNatGatewayEcsMetricResponse) {
	response = &EnableNatGatewayEcsMetricResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
