/* prefs.c generated by valac 0.30.1, the Vala compiler
 * generated from prefs.vala, do not modify */

/*
 * Copyright (C) 2000 Arjan Scherpenisse <acscherp@wins.uva.nl>
 * Copyright (C) 2016 Colin Watson <cjwatson@debian.org>
 *  
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *  
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *  
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */
/* The preferences dialog. */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <gio/gio.h>
#include <gtk/gtk.h>
#include <dconf.h>


#define TG_TYPE_COLUMN (tg_column_get_type ())

#define TG_TYPE_PREFS (tg_prefs_get_type ())
#define TG_PREFS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TG_TYPE_PREFS, TgPrefs))
#define TG_PREFS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TG_TYPE_PREFS, TgPrefsClass))
#define TG_IS_PREFS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TG_TYPE_PREFS))
#define TG_IS_PREFS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TG_TYPE_PREFS))
#define TG_PREFS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TG_TYPE_PREFS, TgPrefsClass))

typedef struct _TgPrefs TgPrefs;
typedef struct _TgPrefsClass TgPrefsClass;
typedef struct _TgPrefsPrivate TgPrefsPrivate;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define TG_TYPE_GUI (tg_gui_get_type ())
#define TG_GUI(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TG_TYPE_GUI, TgGui))
#define TG_GUI_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TG_TYPE_GUI, TgGuiClass))
#define TG_IS_GUI(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TG_TYPE_GUI))
#define TG_IS_GUI_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TG_TYPE_GUI))
#define TG_GUI_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TG_TYPE_GUI, TgGuiClass))

typedef struct _TgGui TgGui;
typedef struct _TgGuiClass TgGuiClass;
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

#define TG_TYPE_CHANNEL (tg_channel_get_type ())
#define TG_CHANNEL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TG_TYPE_CHANNEL, TgChannel))
#define TG_CHANNEL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TG_TYPE_CHANNEL, TgChannelClass))
#define TG_IS_CHANNEL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TG_TYPE_CHANNEL))
#define TG_IS_CHANNEL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TG_TYPE_CHANNEL))
#define TG_CHANNEL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TG_TYPE_CHANNEL, TgChannelClass))

typedef struct _TgChannel TgChannel;
typedef struct _TgChannelClass TgChannelClass;
#define _g_free0(var) (var = (g_free (var), NULL))
#define _gtk_tree_path_free0(var) ((var == NULL) ? NULL : (var = (gtk_tree_path_free (var), NULL)))
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);
#define _vala_return_if_fail(expr, msg) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return; }
#define _vala_return_val_if_fail(expr, msg, val) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return val; }
#define _vala_warn_if_fail(expr, msg) if G_LIKELY (expr) ; else g_warn_message (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

typedef enum  {
	TG_COLUMN_COUNTRY,
	TG_COLUMN_NAME,
	TG_COLUMN_CHANNEL
} TgColumn;

struct _TgPrefs {
	GObject parent_instance;
	TgPrefsPrivate * priv;
};

struct _TgPrefsClass {
	GObjectClass parent_class;
};

struct _TgPrefsPrivate {
	GSettings* settings;
	GtkBuilder* builder;
	GtkDialog* dialog;
	GtkListStore* channel_store;
	GtkTreeView* channel_view;
	GtkLabel* channel_label;
	GtkDialog* channel_dialog;
	GtkEntry* name_entry;
	GtkEntry* description_entry;
	GtkEntry* page_url_entry;
	GtkEntry* subpage_url_entry;
	GtkEntry* country_entry;
};


static gpointer tg_prefs_parent_class = NULL;

#define TG_prefs_ui "/org/gnome/telegnome/prefs.ui"
GType tg_column_get_type (void) G_GNUC_CONST;
GType tg_prefs_get_type (void) G_GNUC_CONST;
#define TG_PREFS_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TG_TYPE_PREFS, TgPrefsPrivate))
enum  {
	TG_PREFS_DUMMY_PROPERTY
};
GType tg_gui_get_type (void) G_GNUC_CONST;
TgPrefs* tg_prefs_new (TgGui* gui);
TgPrefs* tg_prefs_construct (GType object_type, TgGui* gui);
GtkWindow* tg_gui_get_window (TgGui* self);
static void __lambda11_ (TgPrefs* self, GtkTreeSelection* selection);
static void tg_prefs_on_channel_selection_changed (TgPrefs* self, GtkTreeSelection* selection);
static void ___lambda11__gtk_tree_selection_changed (GtkTreeSelection* _sender, gpointer self);
static void __lambda12_ (TgPrefs* self);
static void tg_prefs_on_channel_move_up (TgPrefs* self);
static void ___lambda12__gtk_button_clicked (GtkButton* _sender, gpointer self);
static void __lambda13_ (TgPrefs* self);
static void tg_prefs_on_channel_move_down (TgPrefs* self);
static void ___lambda13__gtk_button_clicked (GtkButton* _sender, gpointer self);
static void __lambda14_ (TgPrefs* self);
static void tg_prefs_on_channel_add (TgPrefs* self);
static void ___lambda14__gtk_button_clicked (GtkButton* _sender, gpointer self);
static void __lambda15_ (TgPrefs* self);
static void tg_prefs_on_channel_delete (TgPrefs* self);
static void ___lambda15__gtk_button_clicked (GtkButton* _sender, gpointer self);
static void __lambda16_ (TgPrefs* self);
static void tg_prefs_on_channel_edit (TgPrefs* self);
static void ___lambda16__gtk_button_clicked (GtkButton* _sender, gpointer self);
GType tg_channel_get_type (void) G_GNUC_CONST;
static void tg_prefs_append_channel (TgPrefs* self, TgChannel* channel);
const gchar* tg_channel_get_country (TgChannel* self);
const gchar* tg_channel_get_name (TgChannel* self);
static void tg_prefs_fill_channel_list (TgPrefs* self);
TgChannel* tg_channel_new (const gchar* uuid);
TgChannel* tg_channel_construct (GType object_type, const gchar* uuid);
static gboolean tg_prefs_edit_channel (TgPrefs* self, TgChannel* orig);
GSettings* tg_channel_get_settings (TgChannel* self);
const gchar* tg_channel_get_description (TgChannel* self);
static void tg_prefs_sync_channel_children (TgPrefs* self);
const gchar* tg_channel_get_uuid (TgChannel* self);
static gint* _vala_array_dup2 (gint* self, int length);
void tg_prefs_show (TgPrefs* self);
static void tg_prefs_finalize (GObject* obj);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);
static gint _vala_array_length (gpointer array);


GType tg_column_get_type (void) {
	static volatile gsize tg_column_type_id__volatile = 0;
	if (g_once_init_enter (&tg_column_type_id__volatile)) {
		static const GEnumValue values[] = {{TG_COLUMN_COUNTRY, "TG_COLUMN_COUNTRY", "country"}, {TG_COLUMN_NAME, "TG_COLUMN_NAME", "name"}, {TG_COLUMN_CHANNEL, "TG_COLUMN_CHANNEL", "channel"}, {0, NULL, NULL}};
		GType tg_column_type_id;
		tg_column_type_id = g_enum_register_static ("TgColumn", values);
		g_once_init_leave (&tg_column_type_id__volatile, tg_column_type_id);
	}
	return tg_column_type_id__volatile;
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static void __lambda11_ (TgPrefs* self, GtkTreeSelection* selection) {
	GtkTreeSelection* _tmp0_ = NULL;
	g_return_if_fail (selection != NULL);
	_tmp0_ = selection;
	tg_prefs_on_channel_selection_changed (self, _tmp0_);
}


static void ___lambda11__gtk_tree_selection_changed (GtkTreeSelection* _sender, gpointer self) {
	__lambda11_ ((TgPrefs*) self, _sender);
}


static void __lambda12_ (TgPrefs* self) {
	tg_prefs_on_channel_move_up (self);
}


static void ___lambda12__gtk_button_clicked (GtkButton* _sender, gpointer self) {
	__lambda12_ ((TgPrefs*) self);
}


static void __lambda13_ (TgPrefs* self) {
	tg_prefs_on_channel_move_down (self);
}


static void ___lambda13__gtk_button_clicked (GtkButton* _sender, gpointer self) {
	__lambda13_ ((TgPrefs*) self);
}


static void __lambda14_ (TgPrefs* self) {
	tg_prefs_on_channel_add (self);
}


static void ___lambda14__gtk_button_clicked (GtkButton* _sender, gpointer self) {
	__lambda14_ ((TgPrefs*) self);
}


static void __lambda15_ (TgPrefs* self) {
	tg_prefs_on_channel_delete (self);
}


static void ___lambda15__gtk_button_clicked (GtkButton* _sender, gpointer self) {
	__lambda15_ ((TgPrefs*) self);
}


static void __lambda16_ (TgPrefs* self) {
	tg_prefs_on_channel_edit (self);
}


static void ___lambda16__gtk_button_clicked (GtkButton* _sender, gpointer self) {
	__lambda16_ ((TgPrefs*) self);
}


TgPrefs* tg_prefs_construct (GType object_type, TgGui* gui) {
	TgPrefs * self = NULL;
	GSettings* _tmp0_ = NULL;
	GtkBuilder* _tmp1_ = NULL;
	GtkBuilder* _tmp2_ = NULL;
	TgGui* _tmp3_ = NULL;
	GtkWindow* _tmp4_ = NULL;
	GtkWindow* _tmp5_ = NULL;
	GtkBuilder* _tmp8_ = NULL;
	GObject* _tmp9_ = NULL;
	GtkDialog* _tmp10_ = NULL;
	GtkBuilder* _tmp11_ = NULL;
	GObject* _tmp12_ = NULL;
	GtkListStore* _tmp13_ = NULL;
	GtkBuilder* _tmp14_ = NULL;
	GObject* _tmp15_ = NULL;
	GtkTreeView* _tmp16_ = NULL;
	GtkBuilder* _tmp17_ = NULL;
	GObject* _tmp18_ = NULL;
	GtkLabel* _tmp19_ = NULL;
	GtkBuilder* _tmp20_ = NULL;
	GObject* _tmp21_ = NULL;
	GtkDialog* _tmp22_ = NULL;
	GtkBuilder* _tmp23_ = NULL;
	GObject* _tmp24_ = NULL;
	GtkEntry* _tmp25_ = NULL;
	GtkBuilder* _tmp26_ = NULL;
	GObject* _tmp27_ = NULL;
	GtkEntry* _tmp28_ = NULL;
	GtkBuilder* _tmp29_ = NULL;
	GObject* _tmp30_ = NULL;
	GtkEntry* _tmp31_ = NULL;
	GtkBuilder* _tmp32_ = NULL;
	GObject* _tmp33_ = NULL;
	GtkEntry* _tmp34_ = NULL;
	GtkBuilder* _tmp35_ = NULL;
	GObject* _tmp36_ = NULL;
	GtkEntry* _tmp37_ = NULL;
	GtkTreeView* _tmp38_ = NULL;
	GtkTreeSelection* _tmp39_ = NULL;
	GtkButton* move_up_button = NULL;
	GtkBuilder* _tmp40_ = NULL;
	GObject* _tmp41_ = NULL;
	GtkButton* _tmp42_ = NULL;
	GtkButton* move_down_button = NULL;
	GtkBuilder* _tmp43_ = NULL;
	GObject* _tmp44_ = NULL;
	GtkButton* _tmp45_ = NULL;
	GtkButton* add_button = NULL;
	GtkBuilder* _tmp46_ = NULL;
	GObject* _tmp47_ = NULL;
	GtkButton* _tmp48_ = NULL;
	GtkButton* delete_button = NULL;
	GtkBuilder* _tmp49_ = NULL;
	GObject* _tmp50_ = NULL;
	GtkButton* _tmp51_ = NULL;
	GtkButton* edit_button = NULL;
	GtkBuilder* _tmp52_ = NULL;
	GObject* _tmp53_ = NULL;
	GtkButton* _tmp54_ = NULL;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (gui != NULL, NULL);
	self = (TgPrefs*) g_object_new (object_type, NULL);
	_tmp0_ = g_settings_new ("org.gnome.telegnome");
	_g_object_unref0 (self->priv->settings);
	self->priv->settings = _tmp0_;
	_tmp1_ = gtk_builder_new ();
	_g_object_unref0 (self->priv->builder);
	self->priv->builder = _tmp1_;
	_tmp2_ = self->priv->builder;
	_tmp3_ = gui;
	_tmp4_ = tg_gui_get_window (_tmp3_);
	_tmp5_ = _tmp4_;
	gtk_builder_expose_object (_tmp2_, "main_window", (GObject*) _tmp5_);
	{
		GtkBuilder* _tmp6_ = NULL;
		_tmp6_ = self->priv->builder;
		gtk_builder_add_from_resource (_tmp6_, TG_prefs_ui, &_inner_error_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			goto __catch13_g_error;
		}
	}
	goto __finally13;
	__catch13_g_error:
	{
		GError* e = NULL;
		const gchar* _tmp7_ = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp7_ = e->message;
		g_error ("prefs.vala:55: failed to add UI: %s", _tmp7_);
		_g_error_free0 (e);
	}
	__finally13:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
	_tmp8_ = self->priv->builder;
	_tmp9_ = gtk_builder_get_object (_tmp8_, "prefs_dialog");
	_tmp10_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp9_, gtk_dialog_get_type ()) ? ((GtkDialog*) _tmp9_) : NULL);
	_g_object_unref0 (self->priv->dialog);
	self->priv->dialog = _tmp10_;
	_tmp11_ = self->priv->builder;
	_tmp12_ = gtk_builder_get_object (_tmp11_, "prefs_channel_store");
	_tmp13_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp12_, gtk_list_store_get_type ()) ? ((GtkListStore*) _tmp12_) : NULL);
	_g_object_unref0 (self->priv->channel_store);
	self->priv->channel_store = _tmp13_;
	_tmp14_ = self->priv->builder;
	_tmp15_ = gtk_builder_get_object (_tmp14_, "prefs_channel_view");
	_tmp16_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp15_, gtk_tree_view_get_type ()) ? ((GtkTreeView*) _tmp15_) : NULL);
	_g_object_unref0 (self->priv->channel_view);
	self->priv->channel_view = _tmp16_;
	_tmp17_ = self->priv->builder;
	_tmp18_ = gtk_builder_get_object (_tmp17_, "prefs_channel_label");
	_tmp19_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp18_, gtk_label_get_type ()) ? ((GtkLabel*) _tmp18_) : NULL);
	_g_object_unref0 (self->priv->channel_label);
	self->priv->channel_label = _tmp19_;
	_tmp20_ = self->priv->builder;
	_tmp21_ = gtk_builder_get_object (_tmp20_, "channel_dialog");
	_tmp22_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp21_, gtk_dialog_get_type ()) ? ((GtkDialog*) _tmp21_) : NULL);
	_g_object_unref0 (self->priv->channel_dialog);
	self->priv->channel_dialog = _tmp22_;
	_tmp23_ = self->priv->builder;
	_tmp24_ = gtk_builder_get_object (_tmp23_, "name_entry");
	_tmp25_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp24_, gtk_entry_get_type ()) ? ((GtkEntry*) _tmp24_) : NULL);
	_g_object_unref0 (self->priv->name_entry);
	self->priv->name_entry = _tmp25_;
	_tmp26_ = self->priv->builder;
	_tmp27_ = gtk_builder_get_object (_tmp26_, "description_entry");
	_tmp28_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp27_, gtk_entry_get_type ()) ? ((GtkEntry*) _tmp27_) : NULL);
	_g_object_unref0 (self->priv->description_entry);
	self->priv->description_entry = _tmp28_;
	_tmp29_ = self->priv->builder;
	_tmp30_ = gtk_builder_get_object (_tmp29_, "page_url_entry");
	_tmp31_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp30_, gtk_entry_get_type ()) ? ((GtkEntry*) _tmp30_) : NULL);
	_g_object_unref0 (self->priv->page_url_entry);
	self->priv->page_url_entry = _tmp31_;
	_tmp32_ = self->priv->builder;
	_tmp33_ = gtk_builder_get_object (_tmp32_, "subpage_url_entry");
	_tmp34_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp33_, gtk_entry_get_type ()) ? ((GtkEntry*) _tmp33_) : NULL);
	_g_object_unref0 (self->priv->subpage_url_entry);
	self->priv->subpage_url_entry = _tmp34_;
	_tmp35_ = self->priv->builder;
	_tmp36_ = gtk_builder_get_object (_tmp35_, "country_entry");
	_tmp37_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp36_, gtk_entry_get_type ()) ? ((GtkEntry*) _tmp36_) : NULL);
	_g_object_unref0 (self->priv->country_entry);
	self->priv->country_entry = _tmp37_;
	_tmp38_ = self->priv->channel_view;
	_tmp39_ = gtk_tree_view_get_selection (_tmp38_);
	g_signal_connect_object (_tmp39_, "changed", (GCallback) ___lambda11__gtk_tree_selection_changed, self, 0);
	_tmp40_ = self->priv->builder;
	_tmp41_ = gtk_builder_get_object (_tmp40_, "move_up_button");
	_tmp42_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp41_, gtk_button_get_type ()) ? ((GtkButton*) _tmp41_) : NULL);
	move_up_button = _tmp42_;
	g_signal_connect_object (move_up_button, "clicked", (GCallback) ___lambda12__gtk_button_clicked, self, 0);
	_tmp43_ = self->priv->builder;
	_tmp44_ = gtk_builder_get_object (_tmp43_, "move_down_button");
	_tmp45_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp44_, gtk_button_get_type ()) ? ((GtkButton*) _tmp44_) : NULL);
	move_down_button = _tmp45_;
	g_signal_connect_object (move_down_button, "clicked", (GCallback) ___lambda13__gtk_button_clicked, self, 0);
	_tmp46_ = self->priv->builder;
	_tmp47_ = gtk_builder_get_object (_tmp46_, "add_button");
	_tmp48_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp47_, gtk_button_get_type ()) ? ((GtkButton*) _tmp47_) : NULL);
	add_button = _tmp48_;
	g_signal_connect_object (add_button, "clicked", (GCallback) ___lambda14__gtk_button_clicked, self, 0);
	_tmp49_ = self->priv->builder;
	_tmp50_ = gtk_builder_get_object (_tmp49_, "delete_button");
	_tmp51_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp50_, gtk_button_get_type ()) ? ((GtkButton*) _tmp50_) : NULL);
	delete_button = _tmp51_;
	g_signal_connect_object (delete_button, "clicked", (GCallback) ___lambda15__gtk_button_clicked, self, 0);
	_tmp52_ = self->priv->builder;
	_tmp53_ = gtk_builder_get_object (_tmp52_, "edit_button");
	_tmp54_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp53_, gtk_button_get_type ()) ? ((GtkButton*) _tmp53_) : NULL);
	edit_button = _tmp54_;
	g_signal_connect_object (edit_button, "clicked", (GCallback) ___lambda16__gtk_button_clicked, self, 0);
	_g_object_unref0 (edit_button);
	_g_object_unref0 (delete_button);
	_g_object_unref0 (add_button);
	_g_object_unref0 (move_down_button);
	_g_object_unref0 (move_up_button);
	return self;
}


TgPrefs* tg_prefs_new (TgGui* gui) {
	return tg_prefs_construct (TG_TYPE_PREFS, gui);
}


static void tg_prefs_append_channel (TgPrefs* self, TgChannel* channel) {
	GtkTreeIter iter = {0};
	GtkListStore* _tmp0_ = NULL;
	GtkTreeIter _tmp1_ = {0};
	GtkListStore* _tmp2_ = NULL;
	GtkTreeIter _tmp3_ = {0};
	TgChannel* _tmp4_ = NULL;
	const gchar* _tmp5_ = NULL;
	const gchar* _tmp6_ = NULL;
	TgChannel* _tmp7_ = NULL;
	const gchar* _tmp8_ = NULL;
	const gchar* _tmp9_ = NULL;
	TgChannel* _tmp10_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (channel != NULL);
	_tmp0_ = self->priv->channel_store;
	gtk_list_store_append (_tmp0_, &_tmp1_);
	iter = _tmp1_;
	_tmp2_ = self->priv->channel_store;
	_tmp3_ = iter;
	_tmp4_ = channel;
	_tmp5_ = tg_channel_get_country (_tmp4_);
	_tmp6_ = _tmp5_;
	_tmp7_ = channel;
	_tmp8_ = tg_channel_get_name (_tmp7_);
	_tmp9_ = _tmp8_;
	_tmp10_ = channel;
	gtk_list_store_set (_tmp2_, &_tmp3_, TG_COLUMN_COUNTRY, _tmp6_, TG_COLUMN_NAME, _tmp9_, TG_COLUMN_CHANNEL, _tmp10_, -1, -1);
}


static void tg_prefs_fill_channel_list (TgPrefs* self) {
	GtkListStore* _tmp0_ = NULL;
	gchar** children = NULL;
	GSettings* _tmp1_ = NULL;
	gchar** _tmp2_ = NULL;
	gchar** _tmp3_ = NULL;
	gint children_length1 = 0;
	gint _children_size_ = 0;
	gchar** _tmp4_ = NULL;
	gint _tmp4__length1 = 0;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->channel_store;
	gtk_list_store_clear (_tmp0_);
	_tmp1_ = self->priv->settings;
	_tmp3_ = _tmp2_ = g_settings_get_strv (_tmp1_, "channel-children");
	children = _tmp3_;
	children_length1 = _vala_array_length (_tmp2_);
	_children_size_ = children_length1;
	_tmp4_ = children;
	_tmp4__length1 = children_length1;
	{
		gchar** child_collection = NULL;
		gint child_collection_length1 = 0;
		gint _child_collection_size_ = 0;
		gint child_it = 0;
		child_collection = _tmp4_;
		child_collection_length1 = _tmp4__length1;
		for (child_it = 0; child_it < _tmp4__length1; child_it = child_it + 1) {
			gchar* _tmp5_ = NULL;
			gchar* child = NULL;
			_tmp5_ = g_strdup (child_collection[child_it]);
			child = _tmp5_;
			{
				const gchar* _tmp6_ = NULL;
				TgChannel* _tmp7_ = NULL;
				TgChannel* _tmp8_ = NULL;
				_tmp6_ = child;
				_tmp7_ = tg_channel_new (_tmp6_);
				_tmp8_ = _tmp7_;
				tg_prefs_append_channel (self, _tmp8_);
				_g_object_unref0 (_tmp8_);
				_g_free0 (child);
			}
		}
	}
	children = (_vala_array_free (children, children_length1, (GDestroyNotify) g_free), NULL);
}


static gboolean tg_prefs_edit_channel (TgPrefs* self, TgChannel* orig) {
	gboolean result = FALSE;
	GSettings* settings = NULL;
	TgChannel* _tmp0_ = NULL;
	GSettings* _tmp1_ = NULL;
	GSettings* _tmp2_ = NULL;
	GSettings* _tmp3_ = NULL;
	GSettings* _tmp4_ = NULL;
	GSettings* _tmp5_ = NULL;
	GtkEntry* _tmp6_ = NULL;
	GSettings* _tmp7_ = NULL;
	GtkEntry* _tmp8_ = NULL;
	GSettings* _tmp9_ = NULL;
	GtkEntry* _tmp10_ = NULL;
	GSettings* _tmp11_ = NULL;
	GtkEntry* _tmp12_ = NULL;
	GSettings* _tmp13_ = NULL;
	GtkEntry* _tmp14_ = NULL;
	GtkDialog* _tmp15_ = NULL;
	gint reply = 0;
	GtkDialog* _tmp16_ = NULL;
	gint _tmp17_ = 0;
	gboolean changed = FALSE;
	gint _tmp18_ = 0;
	GtkDialog* _tmp21_ = NULL;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (orig != NULL, FALSE);
	_tmp0_ = orig;
	_tmp1_ = tg_channel_get_settings (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = _g_object_ref0 (_tmp2_);
	settings = _tmp3_;
	_tmp4_ = settings;
	g_settings_delay (_tmp4_);
	_tmp5_ = settings;
	_tmp6_ = self->priv->name_entry;
	g_settings_bind (_tmp5_, "name", (GObject*) _tmp6_, "text", G_SETTINGS_BIND_DEFAULT);
	_tmp7_ = settings;
	_tmp8_ = self->priv->description_entry;
	g_settings_bind (_tmp7_, "description", (GObject*) _tmp8_, "text", G_SETTINGS_BIND_DEFAULT);
	_tmp9_ = settings;
	_tmp10_ = self->priv->page_url_entry;
	g_settings_bind (_tmp9_, "page-url", (GObject*) _tmp10_, "text", G_SETTINGS_BIND_DEFAULT);
	_tmp11_ = settings;
	_tmp12_ = self->priv->subpage_url_entry;
	g_settings_bind (_tmp11_, "subpage-url", (GObject*) _tmp12_, "text", G_SETTINGS_BIND_DEFAULT);
	_tmp13_ = settings;
	_tmp14_ = self->priv->country_entry;
	g_settings_bind (_tmp13_, "country", (GObject*) _tmp14_, "text", G_SETTINGS_BIND_DEFAULT);
	_tmp15_ = self->priv->channel_dialog;
	gtk_widget_show_all ((GtkWidget*) _tmp15_);
	_tmp16_ = self->priv->channel_dialog;
	_tmp17_ = gtk_dialog_run (_tmp16_);
	reply = _tmp17_;
	_tmp18_ = reply;
	switch (_tmp18_) {
		case GTK_RESPONSE_OK:
		{
			GSettings* _tmp19_ = NULL;
			_tmp19_ = settings;
			g_settings_apply (_tmp19_);
			changed = TRUE;
			break;
		}
		default:
		{
			GSettings* _tmp20_ = NULL;
			_tmp20_ = settings;
			g_settings_revert (_tmp20_);
			changed = FALSE;
			break;
		}
	}
	_tmp21_ = self->priv->channel_dialog;
	gtk_widget_hide ((GtkWidget*) _tmp21_);
	result = changed;
	_g_object_unref0 (settings);
	return result;
}


static void tg_prefs_on_channel_selection_changed (TgPrefs* self, GtkTreeSelection* selection) {
	GtkTreeIter iter = {0};
	gchar* description = NULL;
	GtkTreeSelection* _tmp0_ = NULL;
	GtkTreeIter _tmp1_ = {0};
	gboolean _tmp2_ = FALSE;
	GtkLabel* _tmp10_ = NULL;
	const gchar* _tmp11_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (selection != NULL);
	_tmp0_ = selection;
	_tmp2_ = gtk_tree_selection_get_selected (_tmp0_, NULL, &_tmp1_);
	iter = _tmp1_;
	if (_tmp2_) {
		TgChannel* channel = NULL;
		GtkListStore* _tmp3_ = NULL;
		GtkTreeIter _tmp4_ = {0};
		TgChannel* _tmp5_ = NULL;
		const gchar* _tmp6_ = NULL;
		const gchar* _tmp7_ = NULL;
		gchar* _tmp8_ = NULL;
		_tmp3_ = self->priv->channel_store;
		_tmp4_ = iter;
		gtk_tree_model_get ((GtkTreeModel*) _tmp3_, &_tmp4_, TG_COLUMN_CHANNEL, &channel, -1, -1);
		_tmp5_ = channel;
		_tmp6_ = tg_channel_get_description (_tmp5_);
		_tmp7_ = _tmp6_;
		_tmp8_ = g_strdup (_tmp7_);
		_g_free0 (description);
		description = _tmp8_;
		_g_object_unref0 (channel);
	} else {
		gchar* _tmp9_ = NULL;
		_tmp9_ = g_strdup ("");
		_g_free0 (description);
		description = _tmp9_;
	}
	_tmp10_ = self->priv->channel_label;
	_tmp11_ = description;
	gtk_label_set_text (_tmp10_, _tmp11_);
	_g_free0 (description);
}


static void tg_prefs_sync_channel_children (TgPrefs* self) {
	gint rows = 0;
	GtkTreeIter iter = {0};
	gboolean valid = FALSE;
	GtkListStore* _tmp0_ = NULL;
	GtkTreeIter _tmp1_ = {0};
	gboolean _tmp2_ = FALSE;
	gchar** children = NULL;
	gint _tmp7_ = 0;
	gchar** _tmp8_ = NULL;
	gint children_length1 = 0;
	gint _children_size_ = 0;
	gint i = 0;
	GtkListStore* _tmp9_ = NULL;
	GtkTreeIter _tmp10_ = {0};
	gboolean _tmp11_ = FALSE;
	GSettings* _tmp26_ = NULL;
	gchar** _tmp27_ = NULL;
	gint _tmp27__length1 = 0;
	g_return_if_fail (self != NULL);
	rows = 0;
	_tmp0_ = self->priv->channel_store;
	_tmp2_ = gtk_tree_model_get_iter_first ((GtkTreeModel*) _tmp0_, &_tmp1_);
	iter = _tmp1_;
	valid = _tmp2_;
	while (TRUE) {
		gboolean _tmp3_ = FALSE;
		gint _tmp4_ = 0;
		GtkListStore* _tmp5_ = NULL;
		gboolean _tmp6_ = FALSE;
		_tmp3_ = valid;
		if (!_tmp3_) {
			break;
		}
		_tmp4_ = rows;
		rows = _tmp4_ + 1;
		_tmp5_ = self->priv->channel_store;
		_tmp6_ = gtk_tree_model_iter_next ((GtkTreeModel*) _tmp5_, &iter);
		valid = _tmp6_;
	}
	_tmp7_ = rows;
	_tmp8_ = g_new0 (gchar*, (_tmp7_ + 1) + 1);
	children = _tmp8_;
	children_length1 = _tmp7_ + 1;
	_children_size_ = children_length1;
	i = 0;
	_tmp9_ = self->priv->channel_store;
	_tmp11_ = gtk_tree_model_get_iter_first ((GtkTreeModel*) _tmp9_, &_tmp10_);
	iter = _tmp10_;
	valid = _tmp11_;
	while (TRUE) {
		gboolean _tmp12_ = FALSE;
		gint _tmp13_ = 0;
		gint _tmp14_ = 0;
		TgChannel* channel = NULL;
		GtkListStore* _tmp15_ = NULL;
		GtkTreeIter _tmp16_ = {0};
		gchar** _tmp17_ = NULL;
		gint _tmp17__length1 = 0;
		gint _tmp18_ = 0;
		TgChannel* _tmp19_ = NULL;
		const gchar* _tmp20_ = NULL;
		const gchar* _tmp21_ = NULL;
		gchar* _tmp22_ = NULL;
		gchar* _tmp23_ = NULL;
		GtkListStore* _tmp24_ = NULL;
		gboolean _tmp25_ = FALSE;
		_tmp12_ = valid;
		if (!_tmp12_) {
			break;
		}
		_tmp13_ = i;
		_tmp14_ = rows;
		_vala_assert (_tmp13_ < _tmp14_, "i < rows");
		_tmp15_ = self->priv->channel_store;
		_tmp16_ = iter;
		gtk_tree_model_get ((GtkTreeModel*) _tmp15_, &_tmp16_, TG_COLUMN_CHANNEL, &channel, -1, -1);
		_tmp17_ = children;
		_tmp17__length1 = children_length1;
		_tmp18_ = i;
		i = _tmp18_ + 1;
		_tmp19_ = channel;
		_tmp20_ = tg_channel_get_uuid (_tmp19_);
		_tmp21_ = _tmp20_;
		_tmp22_ = g_strdup (_tmp21_);
		_g_free0 (_tmp17_[_tmp18_]);
		_tmp17_[_tmp18_] = _tmp22_;
		_tmp23_ = _tmp17_[_tmp18_];
		_tmp24_ = self->priv->channel_store;
		_tmp25_ = gtk_tree_model_iter_next ((GtkTreeModel*) _tmp24_, &iter);
		valid = _tmp25_;
		_g_object_unref0 (channel);
	}
	_tmp26_ = self->priv->settings;
	_tmp27_ = children;
	_tmp27__length1 = children_length1;
	g_settings_set_strv (_tmp26_, "channel-children", _tmp27_);
	children = (_vala_array_free (children, children_length1, (GDestroyNotify) g_free), NULL);
}


static void tg_prefs_on_channel_add (TgPrefs* self) {
	TgChannel* channel = NULL;
	TgChannel* _tmp0_ = NULL;
	gboolean _tmp1_ = FALSE;
	TgChannel* _tmp2_ = NULL;
	gboolean _tmp3_ = FALSE;
	g_return_if_fail (self != NULL);
	_tmp0_ = tg_channel_new (NULL);
	channel = _tmp0_;
	_tmp2_ = channel;
	_tmp3_ = tg_prefs_edit_channel (self, _tmp2_);
	if (_tmp3_) {
		TgChannel* _tmp4_ = NULL;
		const gchar* _tmp5_ = NULL;
		const gchar* _tmp6_ = NULL;
		gint _tmp7_ = 0;
		gint _tmp8_ = 0;
		_tmp4_ = channel;
		_tmp5_ = tg_channel_get_name (_tmp4_);
		_tmp6_ = _tmp5_;
		_tmp7_ = strlen (_tmp6_);
		_tmp8_ = _tmp7_;
		_tmp1_ = _tmp8_ > 0;
	} else {
		_tmp1_ = FALSE;
	}
	if (_tmp1_) {
		TgChannel* _tmp9_ = NULL;
		_tmp9_ = channel;
		tg_prefs_append_channel (self, _tmp9_);
	}
	_g_object_unref0 (channel);
}


static gint* _vala_array_dup2 (gint* self, int length) {
	return g_memdup (self, length * sizeof (gint));
}


static void tg_prefs_on_channel_move_up (TgPrefs* self) {
	GtkTreeSelection* selection = NULL;
	GtkTreeView* _tmp0_ = NULL;
	GtkTreeSelection* _tmp1_ = NULL;
	GtkTreeSelection* _tmp2_ = NULL;
	GtkTreeIter iter = {0};
	GtkTreeSelection* _tmp3_ = NULL;
	GtkTreeIter _tmp4_ = {0};
	gboolean _tmp5_ = FALSE;
	GtkTreePath* path = NULL;
	GtkListStore* _tmp6_ = NULL;
	GtkTreeIter _tmp7_ = {0};
	GtkTreePath* _tmp8_ = NULL;
	GtkTreePath* _tmp9_ = NULL;
	gint depth = 0;
	GtkTreePath* _tmp10_ = NULL;
	gint _tmp11_ = 0;
	gint _tmp12_ = 0;
	gint* indices = NULL;
	GtkTreePath* _tmp13_ = NULL;
	gint _tmp14_ = 0;
	gint* _tmp15_ = NULL;
	gint* _tmp16_ = NULL;
	gint _tmp16__length1 = 0;
	gint indices_length1 = 0;
	gint _indices_size_ = 0;
	gint* _tmp17_ = NULL;
	gint _tmp17__length1 = 0;
	gint _tmp18_ = 0;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->channel_view;
	_tmp1_ = gtk_tree_view_get_selection (_tmp0_);
	_tmp2_ = _g_object_ref0 (_tmp1_);
	selection = _tmp2_;
	_tmp3_ = selection;
	_tmp5_ = gtk_tree_selection_get_selected (_tmp3_, NULL, &_tmp4_);
	iter = _tmp4_;
	if (!_tmp5_) {
		_g_object_unref0 (selection);
		return;
	}
	_tmp6_ = self->priv->channel_store;
	_tmp7_ = iter;
	_tmp8_ = gtk_tree_model_get_path ((GtkTreeModel*) _tmp6_, &_tmp7_);
	path = _tmp8_;
	_tmp9_ = path;
	_vala_assert (_tmp9_ != NULL, "path != null");
	_tmp10_ = path;
	_tmp11_ = gtk_tree_path_get_depth (_tmp10_);
	depth = _tmp11_;
	_tmp12_ = depth;
	_vala_assert (_tmp12_ == 1, "depth == 1");
	_tmp13_ = path;
	_tmp15_ = gtk_tree_path_get_indices_with_depth (_tmp13_, &_tmp14_);
	_tmp16_ = (_tmp15_ != NULL) ? _vala_array_dup2 (_tmp15_, _tmp14_) : ((gpointer) _tmp15_);
	_tmp16__length1 = _tmp14_;
	indices = _tmp16_;
	indices_length1 = _tmp16__length1;
	_indices_size_ = indices_length1;
	_tmp17_ = indices;
	_tmp17__length1 = indices_length1;
	_tmp18_ = _tmp17_[0];
	if (_tmp18_ > 0) {
		GtkTreeIter previous_iter = {0};
		GtkListStore* _tmp19_ = NULL;
		gint* _tmp20_ = NULL;
		gint _tmp20__length1 = 0;
		gint _tmp21_ = 0;
		GtkTreeIter _tmp22_ = {0};
		GtkListStore* _tmp23_ = NULL;
		GtkTreeIter _tmp24_ = {0};
		GtkTreeIter _tmp25_ = {0};
		_tmp19_ = self->priv->channel_store;
		_tmp20_ = indices;
		_tmp20__length1 = indices_length1;
		_tmp21_ = _tmp20_[0];
		gtk_tree_model_iter_nth_child ((GtkTreeModel*) _tmp19_, &_tmp22_, NULL, _tmp21_ - 1);
		previous_iter = _tmp22_;
		_tmp23_ = self->priv->channel_store;
		_tmp24_ = iter;
		_tmp25_ = previous_iter;
		gtk_list_store_swap (_tmp23_, &_tmp24_, &_tmp25_);
		tg_prefs_sync_channel_children (self);
	}
	indices = (g_free (indices), NULL);
	_gtk_tree_path_free0 (path);
	_g_object_unref0 (selection);
}


static void tg_prefs_on_channel_move_down (TgPrefs* self) {
	GtkTreeSelection* selection = NULL;
	GtkTreeView* _tmp0_ = NULL;
	GtkTreeSelection* _tmp1_ = NULL;
	GtkTreeSelection* _tmp2_ = NULL;
	GtkTreeIter iter = {0};
	GtkTreeSelection* _tmp3_ = NULL;
	GtkTreeIter _tmp4_ = {0};
	gboolean _tmp5_ = FALSE;
	GtkTreeIter next_iter = {0};
	GtkTreeIter _tmp6_ = {0};
	GtkListStore* _tmp7_ = NULL;
	gboolean _tmp8_ = FALSE;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->channel_view;
	_tmp1_ = gtk_tree_view_get_selection (_tmp0_);
	_tmp2_ = _g_object_ref0 (_tmp1_);
	selection = _tmp2_;
	_tmp3_ = selection;
	_tmp5_ = gtk_tree_selection_get_selected (_tmp3_, NULL, &_tmp4_);
	iter = _tmp4_;
	if (!_tmp5_) {
		_g_object_unref0 (selection);
		return;
	}
	_tmp6_ = iter;
	next_iter = _tmp6_;
	_tmp7_ = self->priv->channel_store;
	_tmp8_ = gtk_tree_model_iter_next ((GtkTreeModel*) _tmp7_, &next_iter);
	if (_tmp8_) {
		GtkListStore* _tmp9_ = NULL;
		GtkTreeIter _tmp10_ = {0};
		GtkTreeIter _tmp11_ = {0};
		_tmp9_ = self->priv->channel_store;
		_tmp10_ = iter;
		_tmp11_ = next_iter;
		gtk_list_store_swap (_tmp9_, &_tmp10_, &_tmp11_);
		tg_prefs_sync_channel_children (self);
	}
	_g_object_unref0 (selection);
}


static void tg_prefs_on_channel_edit (TgPrefs* self) {
	GtkTreeSelection* selection = NULL;
	GtkTreeView* _tmp0_ = NULL;
	GtkTreeSelection* _tmp1_ = NULL;
	GtkTreeSelection* _tmp2_ = NULL;
	GtkTreeIter iter = {0};
	GtkTreeSelection* _tmp3_ = NULL;
	GtkTreeIter _tmp4_ = {0};
	gboolean _tmp5_ = FALSE;
	TgChannel* channel = NULL;
	GtkListStore* _tmp6_ = NULL;
	GtkTreeIter _tmp7_ = {0};
	TgChannel* _tmp8_ = NULL;
	gboolean _tmp9_ = FALSE;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->channel_view;
	_tmp1_ = gtk_tree_view_get_selection (_tmp0_);
	_tmp2_ = _g_object_ref0 (_tmp1_);
	selection = _tmp2_;
	_tmp3_ = selection;
	_tmp5_ = gtk_tree_selection_get_selected (_tmp3_, NULL, &_tmp4_);
	iter = _tmp4_;
	if (!_tmp5_) {
		_g_object_unref0 (selection);
		return;
	}
	_tmp6_ = self->priv->channel_store;
	_tmp7_ = iter;
	gtk_tree_model_get ((GtkTreeModel*) _tmp6_, &_tmp7_, TG_COLUMN_CHANNEL, &channel, -1, -1);
	_tmp8_ = channel;
	_tmp9_ = tg_prefs_edit_channel (self, _tmp8_);
	if (_tmp9_) {
		GtkListStore* _tmp10_ = NULL;
		GtkTreeIter _tmp11_ = {0};
		TgChannel* _tmp12_ = NULL;
		const gchar* _tmp13_ = NULL;
		const gchar* _tmp14_ = NULL;
		TgChannel* _tmp15_ = NULL;
		const gchar* _tmp16_ = NULL;
		const gchar* _tmp17_ = NULL;
		_tmp10_ = self->priv->channel_store;
		_tmp11_ = iter;
		_tmp12_ = channel;
		_tmp13_ = tg_channel_get_country (_tmp12_);
		_tmp14_ = _tmp13_;
		_tmp15_ = channel;
		_tmp16_ = tg_channel_get_name (_tmp15_);
		_tmp17_ = _tmp16_;
		gtk_list_store_set (_tmp10_, &_tmp11_, TG_COLUMN_COUNTRY, _tmp14_, TG_COLUMN_NAME, _tmp17_, -1, -1);
	}
	_g_object_unref0 (channel);
	_g_object_unref0 (selection);
}


static const gchar* string_to_string (const gchar* self) {
	const gchar* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	result = self;
	return result;
}


static void tg_prefs_on_channel_delete (TgPrefs* self) {
	GtkTreeSelection* selection = NULL;
	GtkTreeView* _tmp0_ = NULL;
	GtkTreeSelection* _tmp1_ = NULL;
	GtkTreeSelection* _tmp2_ = NULL;
	GtkTreeIter iter = {0};
	GtkTreeSelection* _tmp3_ = NULL;
	GtkTreeIter _tmp4_ = {0};
	gboolean _tmp5_ = FALSE;
	TgChannel* channel = NULL;
	GtkListStore* _tmp6_ = NULL;
	GtkTreeIter _tmp7_ = {0};
	gchar* old_uuid = NULL;
	TgChannel* _tmp8_ = NULL;
	const gchar* _tmp9_ = NULL;
	const gchar* _tmp10_ = NULL;
	gchar* _tmp11_ = NULL;
	GtkListStore* _tmp12_ = NULL;
	GtkTreeIter _tmp13_ = {0};
	GSettings* _tmp14_ = NULL;
	GSettingsBackend* _tmp15_ = NULL;
	GSettingsBackend* _tmp16_ = NULL;
	GSettingsBackend* _tmp17_ = NULL;
	GType _tmp18_ = 0UL;
	const gchar* _tmp19_ = NULL;
	gboolean _tmp20_ = FALSE;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->channel_view;
	_tmp1_ = gtk_tree_view_get_selection (_tmp0_);
	_tmp2_ = _g_object_ref0 (_tmp1_);
	selection = _tmp2_;
	_tmp3_ = selection;
	_tmp5_ = gtk_tree_selection_get_selected (_tmp3_, NULL, &_tmp4_);
	iter = _tmp4_;
	if (!_tmp5_) {
		_g_object_unref0 (selection);
		return;
	}
	_tmp6_ = self->priv->channel_store;
	_tmp7_ = iter;
	gtk_tree_model_get ((GtkTreeModel*) _tmp6_, &_tmp7_, TG_COLUMN_CHANNEL, &channel, -1, -1);
	_tmp8_ = channel;
	_tmp9_ = tg_channel_get_uuid (_tmp8_);
	_tmp10_ = _tmp9_;
	_tmp11_ = g_strdup (_tmp10_);
	old_uuid = _tmp11_;
	_tmp12_ = self->priv->channel_store;
	_tmp13_ = iter;
	gtk_list_store_remove (_tmp12_, &_tmp13_);
	tg_prefs_sync_channel_children (self);
	_tmp14_ = self->priv->settings;
	g_object_get (_tmp14_, "backend", &_tmp15_, NULL);
	_tmp16_ = _tmp15_;
	_tmp17_ = _tmp16_;
	_tmp18_ = G_TYPE_FROM_INSTANCE ((GObject*) _tmp17_);
	_tmp19_ = g_type_name (_tmp18_);
	_tmp20_ = g_strcmp0 (_tmp19_, "DConfSettingsBackend") == 0;
	_g_object_unref0 (_tmp17_);
	if (_tmp20_) {
		gchar* path = NULL;
		const gchar* _tmp21_ = NULL;
		const gchar* _tmp22_ = NULL;
		gchar* _tmp23_ = NULL;
		DConfClient* client = NULL;
		DConfClient* _tmp24_ = NULL;
		_tmp21_ = old_uuid;
		_tmp22_ = string_to_string (_tmp21_);
		_tmp23_ = g_strconcat ("/org/gnome/telegnome/channel/", _tmp22_, "/", NULL);
		path = _tmp23_;
		_tmp24_ = dconf_client_new ();
		client = _tmp24_;
		{
			DConfClient* _tmp25_ = NULL;
			const gchar* _tmp26_ = NULL;
			_tmp25_ = client;
			_tmp26_ = path;
			dconf_client_write_sync (_tmp25_, _tmp26_, NULL, NULL, NULL, &_inner_error_);
			if (G_UNLIKELY (_inner_error_ != NULL)) {
				goto __catch14_g_error;
			}
		}
		goto __finally14;
		__catch14_g_error:
		{
			GError* e = NULL;
			GError* _tmp27_ = NULL;
			e = _inner_error_;
			_inner_error_ = NULL;
			_tmp27_ = e;
			_vala_assert (_tmp27_, "e");
			_g_error_free0 (e);
		}
		__finally14:
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			_g_object_unref0 (client);
			_g_free0 (path);
			_g_free0 (old_uuid);
			_g_object_unref0 (channel);
			_g_object_unref0 (selection);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
		_g_object_unref0 (client);
		_g_free0 (path);
	}
	_g_free0 (old_uuid);
	_g_object_unref0 (channel);
	_g_object_unref0 (selection);
}


void tg_prefs_show (TgPrefs* self) {
	GtkDialog* _tmp0_ = NULL;
	GtkDialog* _tmp1_ = NULL;
	GtkDialog* _tmp2_ = NULL;
	g_return_if_fail (self != NULL);
	tg_prefs_fill_channel_list (self);
	_tmp0_ = self->priv->dialog;
	gtk_widget_show_all ((GtkWidget*) _tmp0_);
	_tmp1_ = self->priv->dialog;
	gtk_dialog_run (_tmp1_);
	_tmp2_ = self->priv->dialog;
	gtk_widget_hide ((GtkWidget*) _tmp2_);
}


static void tg_prefs_class_init (TgPrefsClass * klass) {
	tg_prefs_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (TgPrefsPrivate));
	G_OBJECT_CLASS (klass)->finalize = tg_prefs_finalize;
}


static void tg_prefs_instance_init (TgPrefs * self) {
	self->priv = TG_PREFS_GET_PRIVATE (self);
}


static void tg_prefs_finalize (GObject* obj) {
	TgPrefs * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TG_TYPE_PREFS, TgPrefs);
	_g_object_unref0 (self->priv->settings);
	_g_object_unref0 (self->priv->builder);
	_g_object_unref0 (self->priv->dialog);
	_g_object_unref0 (self->priv->channel_store);
	_g_object_unref0 (self->priv->channel_view);
	_g_object_unref0 (self->priv->channel_label);
	_g_object_unref0 (self->priv->channel_dialog);
	_g_object_unref0 (self->priv->name_entry);
	_g_object_unref0 (self->priv->description_entry);
	_g_object_unref0 (self->priv->page_url_entry);
	_g_object_unref0 (self->priv->subpage_url_entry);
	_g_object_unref0 (self->priv->country_entry);
	G_OBJECT_CLASS (tg_prefs_parent_class)->finalize (obj);
}


GType tg_prefs_get_type (void) {
	static volatile gsize tg_prefs_type_id__volatile = 0;
	if (g_once_init_enter (&tg_prefs_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (TgPrefsClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) tg_prefs_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (TgPrefs), 0, (GInstanceInitFunc) tg_prefs_instance_init, NULL };
		GType tg_prefs_type_id;
		tg_prefs_type_id = g_type_register_static (G_TYPE_OBJECT, "TgPrefs", &g_define_type_info, 0);
		g_once_init_leave (&tg_prefs_type_id__volatile, tg_prefs_type_id);
	}
	return tg_prefs_type_id__volatile;
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}


static gint _vala_array_length (gpointer array) {
	int length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}



