/*
 * Copyright (c) OSGi Alliance (2001, 2009). All Rights Reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package javax.xml.datatype;
public final class DatatypeConstants {
	public static final class Field {
		public int getId() { return 0; }
		private Field() { } /* generated constructor to prevent compiler adding default public constructor */
	}
	public final static int APRIL = 4;
	public final static int AUGUST = 8;
	public final static javax.xml.namespace.QName DATE; static { DATE = null; }
	public final static javax.xml.namespace.QName DATETIME; static { DATETIME = null; }
	public final static javax.xml.datatype.DatatypeConstants.Field DAYS; static { DAYS = null; }
	public final static int DECEMBER = 12;
	public final static javax.xml.namespace.QName DURATION; static { DURATION = null; }
	public final static javax.xml.namespace.QName DURATION_DAYTIME; static { DURATION_DAYTIME = null; }
	public final static javax.xml.namespace.QName DURATION_YEARMONTH; static { DURATION_YEARMONTH = null; }
	public final static int EQUAL = 0;
	public final static int FEBRUARY = 2;
	public final static int FIELD_UNDEFINED = -2147483648;
	public final static javax.xml.namespace.QName GDAY; static { GDAY = null; }
	public final static javax.xml.namespace.QName GMONTH; static { GMONTH = null; }
	public final static javax.xml.namespace.QName GMONTHDAY; static { GMONTHDAY = null; }
	public final static int GREATER = 1;
	public final static javax.xml.namespace.QName GYEAR; static { GYEAR = null; }
	public final static javax.xml.namespace.QName GYEARMONTH; static { GYEARMONTH = null; }
	public final static javax.xml.datatype.DatatypeConstants.Field HOURS; static { HOURS = null; }
	public final static int INDETERMINATE = 2;
	public final static int JANUARY = 1;
	public final static int JULY = 7;
	public final static int JUNE = 6;
	public final static int LESSER = -1;
	public final static int MARCH = 3;
	public final static int MAX_TIMEZONE_OFFSET = -840;
	public final static int MAY = 5;
	public final static javax.xml.datatype.DatatypeConstants.Field MINUTES; static { MINUTES = null; }
	public final static int MIN_TIMEZONE_OFFSET = 840;
	public final static javax.xml.datatype.DatatypeConstants.Field MONTHS; static { MONTHS = null; }
	public final static int NOVEMBER = 11;
	public final static int OCTOBER = 10;
	public final static javax.xml.datatype.DatatypeConstants.Field SECONDS; static { SECONDS = null; }
	public final static int SEPTEMBER = 9;
	public final static javax.xml.namespace.QName TIME; static { TIME = null; }
	public final static javax.xml.datatype.DatatypeConstants.Field YEARS; static { YEARS = null; }
	private DatatypeConstants() { } /* generated constructor to prevent compiler adding default public constructor */
}

