
/*
 * $Header: /cvsroot/mpdist/mpdist/mptool/text.h,v 1.1.1.1 2002/04/12 16:47:25 richbastard Exp $
 * 
 * Copyright (c) 1987-2002 Rich Burridge, Sun Microsystems Inc.
 * All rights reserved.
 *
 * This software is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Library General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or (at your
 * option) any later version.
 *
 * This software is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Library General Public
 * License for more details.
 *
 * You should have received a copy of the GNU Library General Public License
 * along with this software; if not, write to the Free Software Foundation,
 * Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#ifndef __MPTOOL_TEXT_H__
#define __MPTOOL_TEXT_H__

#include <glib.h>

#define MPTOOL_STRS_LEN              18

enum str_type {
    S_USAGE,    S_NOTHING,  S_NONE,    S_INVCOL,
    S_INVTAB,   S_INVLINE,  S_INVPAGE, S_INVCOPIES,
    S_NOFILES,  S_START,    S_EXECUTE, S_INVCHARS,
    S_INVWORDS, S_DRAGDROP, S_BMARGIN, S_LMARGIN,
    S_RMARGIN,  S_TMARGIN
};

void init_text (void);

/* Main frame help strings. */

extern gchar *wi_main_frame_help;
extern gchar *wi_filename_help;
extern gchar *wi_headers_help;
extern gchar *wi_preferences_help;
extern gchar *wi_file_type_help;
extern gchar *wi_org_type_help;
extern gchar *wi_output_help;
extern gchar *wi_paper_size_help;
extern gchar *wi_subject_help;
extern gchar *wi_copies_help;
extern gchar *wi_no_sides_help;
extern gchar *wi_print_help;
extern gchar *wi_reset_help;
extern gchar *wi_menu_bar_help;
extern gchar *wi_exit_help;
extern gchar *wi_help_help;

/* Printing popup help strings. */

extern gchar *wi_props_frame_help;
extern gchar *wi_props_col_help;
extern gchar *wi_props_tab_help;
extern gchar *wi_props_margin_help;
extern gchar *wi_props_wrap_help;
extern gchar *wi_props_flip_help;
extern gchar *wi_props_forcepage_help;
extern gchar *wi_props_number_help;
extern gchar *wi_props_reverse_help;
extern gchar *wi_props_apply_help;
extern gchar *wi_props_defs_help;
extern gchar *wi_props_reset_help;
extern gchar *wi_props_dismiss_help;
extern gchar *wi_opt_header_help;

/* Username popup help strings. */
 
extern gchar *wi_un_form_help;
extern gchar *wi_un_apply_help;
extern gchar *wi_un_reset_help;
extern gchar *wi_un_dismiss_help;
extern gchar *wi_aliasname_help;
extern gchar *wi_props_passc_help;
extern gchar *wi_props_passw_help;

/* Output popup help strings. */

extern gchar *wi_output_frame_help;
extern gchar *wi_output_apply_help;
extern gchar *wi_output_reset_help;
extern gchar *wi_output_dismiss_help;
extern gchar *wi_output_bsd_help;
extern gchar *wi_line_length_help;
extern gchar *wi_page_length_help;
extern gchar *wi_printer_name_help;

/* Input popup help strings. */

extern gchar *wi_input_frame_help;
extern gchar *wi_prologue_help;
extern gchar *wi_opt_folder_help;
extern gchar *wi_opt_digest_help;
extern gchar *wi_props_elm_help;
extern gchar *wi_props_from_help;
extern gchar *wi_props_content_help;
extern gchar *wi_props_modtime_help;
extern gchar *wi_input_apply_help;
extern gchar *wi_input_reset_help;
extern gchar *wi_input_dismiss_help;

/* Header popup help strings. */

extern gchar *wi_header_frame_help;
extern gchar *wi_headers_all_help;
extern gchar *wi_hdr_list_help;
extern gchar *wi_hdr_add_help;
extern gchar *wi_hdr_apply_help;
extern gchar *wi_hdr_dismiss_help;
extern gchar *wi_hdr_remove_help;
extern gchar *wi_hdr_reset_help;

/* Help popup help strings. */

extern gchar *wi_help_text_help;
extern gchar *wi_help_dismiss_help;

extern gchar *mptool_strs[];

#endif /* __MPTOOL_TEXT_H__ */
