// Copyright 2022 Mathias Bynens. All rights reserved.
// This code is governed by the BSD license found in the LICENSE file.

/*---
author: Mathias Bynens
description: >
  Unicode property escapes for `Script=Phoenician`
info: |
  Generated by https://github.com/mathiasbynens/unicode-property-escapes-tests
  Unicode v15.0.0
esid: sec-static-semantics-unicodematchproperty-p
features: [regexp-unicode-property-escapes]
includes: [regExpUtils.js]
---*/

const matchSymbols = buildString({
  loneCodePoints: [
    0x01091F
  ],
  ranges: [
    [0x010900, 0x01091B]
  ]
});
testPropertyEscapes(
  /^\p{Script=Phoenician}+$/u,
  matchSymbols,
  "\\p{Script=Phoenician}"
);
testPropertyEscapes(
  /^\p{Script=Phnx}+$/u,
  matchSymbols,
  "\\p{Script=Phnx}"
);
testPropertyEscapes(
  /^\p{sc=Phoenician}+$/u,
  matchSymbols,
  "\\p{sc=Phoenician}"
);
testPropertyEscapes(
  /^\p{sc=Phnx}+$/u,
  matchSymbols,
  "\\p{sc=Phnx}"
);

const nonMatchSymbols = buildString({
  loneCodePoints: [],
  ranges: [
    [0x00DC00, 0x00DFFF],
    [0x000000, 0x00DBFF],
    [0x00E000, 0x0108FF],
    [0x01091C, 0x01091E],
    [0x010920, 0x10FFFF]
  ]
});
testPropertyEscapes(
  /^\P{Script=Phoenician}+$/u,
  nonMatchSymbols,
  "\\P{Script=Phoenician}"
);
testPropertyEscapes(
  /^\P{Script=Phnx}+$/u,
  nonMatchSymbols,
  "\\P{Script=Phnx}"
);
testPropertyEscapes(
  /^\P{sc=Phoenician}+$/u,
  nonMatchSymbols,
  "\\P{sc=Phoenician}"
);
testPropertyEscapes(
  /^\P{sc=Phnx}+$/u,
  nonMatchSymbols,
  "\\P{sc=Phnx}"
);

reportCompare(0, 0);
