# Automatically generated code: EDIT AT YOUR OWN RISK
from traits import api as traits
from traitsui.item import Item, spring
from traitsui.group import HGroup
from traitsui.view import View

from tvtk import vtk_module as vtk
from tvtk import tvtk_base
from tvtk.tvtk_base_handler import TVTKBaseHandler
from tvtk import messenger
from tvtk.tvtk_base import deref_vtk
from tvtk import array_handler
from tvtk.array_handler import deref_array
from tvtk.tvtk_classes.tvtk_helper import wrap_vtk

nan = float('nan')


def InstanceEditor(*args, **kw):
    from traitsui.editors.api import InstanceEditor as Editor
    return Editor(view_name="handler.view")

try:
    long
except NameError:
    # Silly workaround for Python3.
    long = int

inf = float('inf')

from tvtk.tvtk_classes.point_set_algorithm import PointSetAlgorithm


class PointSmoothingFilter(PointSetAlgorithm):
    r"""
    PointSmoothingFilter - adjust point positions to form a pleasing,
    packed arrangement
    
    Superclass: PointSetAlgorithm
    
    PointSmoothingFilter modifies the coordinates of the input points
    of a PointSet by adjusting their position to create a smooth
    distribution (and thereby form a pleasing packing of the points).
    Smoothing is performed by considering the effects of neighboring
    points on one another. Smoothing in its simplest form (geometric) is
    simply a variant of Laplacian smoothing where each point moves
    towards the average position of its neighboring points. Next, uniform
    smoothing uses a cubic cutoff function to produce repulsive forces
    between close points and attractive forces that are a little further
    away. Smoothing can be further controlled either by a scalar field,
    by a tensor field, or a frame field (the user can specify the nature
    of the smoothing operation). If controlled by a scalar field, then
    each input point is assumed to be surrounded by a isotropic sphere
    scaled by the scalar field; if controlled by a tensor field, then
    each input point is assumed to be surrounded by an anisotropic,
    oriented ellipsoid aligned to the the tensor eigenvectors and scaled
    by the determinate of the tensor. A frame field also assumes a
    surrounding, ellipsoidal shape except that the inversion of the
    ellipsoid tensor is already performed. Typical usage of this filter
    is to perform a smoothing (also referred to as packing) operation
    (i.e., first execute this filter) and then combine it with a glyph
    filter (e.g., TensorGlyph or Glyph3D) to visualize the packed
    points.
    
    Smoothing depends on a local neighborhood of nearby points. In
    general, the larger the neighborhood size, the greater the reduction
    in high frequency information. (The memory and/or computational
    requirements of the algorithm may also significantly increase.) The
    packing_radius (and packing_factor) controls what points are considered
    close. The packing_radius can be computed automatically, or specified
    by the user. (The product of packing_radius*packing_factor is referred
    to as the scaling factor alpha in the paper cited below. This
    provides a convenient way to combine automatic packing_radius
    computation based on average between particle neighborhoods, and then
    adjust it with the packing_factor.)
    
    Any PointSet type can be provided as input, and the output will
    contain the same number of new points each of which is adjusted to a
    new position.
    
    Note that the algorithm requires the use of a spatial point locator.
    The point locator is used to build a local neighborhood of the points
    surrounding each point. It is also used to perform interpolation as
    the point positions are adjusted.
    
    The algorithm incrementally adjusts the point positions through an
    iterative process. Basically points are moved due to the influence of
    neighboring points. Iterations continue until the specified number of
    iterations is reached, or convergence occurs. Convergence occurs when
    the maximum displacement of any point is less than the convergence
    value. As points move, both the local connectivity and data
    attributes associated with each point must be updated. Rather than
    performing these expensive operations after every iteration, a number
    of sub-iterations Si can be specified. If Si > 1, then the
    neighborhood and attribute value updates occur only every Si'th
    iteration. Using sub-iterations can improve performance
    significantly.
    
    @warning
    Geometric smoothing defines a one-sided attractive force between
    particles. Thus particles tend to clump together, and the entire set
    of points (with enough iterations and appropriate packing_radius) can
    converge to a single position. This can be mitigated by turning on
    point constraints, which limit the movement of "boundary" points.
    
    @warning
    This class has been loosely inspired by the paper by Kindlmann and
    Westin "Diffusion Tensor Visualization with Glyph Packing". However,
    several computational shortcuts, and generalizations have been used
    for performance and utility reasons.
    
    @warning
    This class has been threaded with SMPTools. Using TBB or other
    non-sequential type (set in the CMake variable
    VTK_SMP_IMPLEMENTATION_TYPE) may improve performance significantly.
    
    @sa
    TensorWidget TensorGlyph SmoothPolyDataFilter Glyph3D
    
    """
    def __init__(self, obj=None, update=True, **traits):
        tvtk_base.TVTKBase.__init__(self, vtk.vtkPointSmoothingFilter, obj, update, **traits)
    
    compute_packing_radius = tvtk_base.true_bool_trait(desc=\
        r"""
        Enable / disable the computation of a packing radius. By default,
        a packing radius is computed as one half of the average distance
        between neighboring points. (Point neighbors are defined by the
        neighborhood size.)
        """
    )

    def _compute_packing_radius_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetComputePackingRadius,
                        self.compute_packing_radius_)

    enable_constraints = tvtk_base.false_bool_trait(desc=\
        r"""
        Enable or disable constraints on points. Point constraints are
        used to prevent points from moving, or to move only on a plane.
        This can prevent shrinking or growing point clouds. If enabled, a
        local topological anlysis is performed to determine whether a
        point should be marked "Fixed" i.e., never moves; "Plane", the
        point only moves on a plane; or "Unconstrained", the point can
        move freely. If all points in the neighborhood surrounding a
        point are in the cone defined by fixed_angle, then the point is
        classified "Fixed." If all points in the neighborhood surrounding
        a point are in the cone defined by boundary_angle, then the point
        is classified "Plane." (The angles are expressed in degrees.)
        """
    )

    def _enable_constraints_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetEnableConstraints,
                        self.enable_constraints_)

    generate_constraint_normals = tvtk_base.false_bool_trait(desc=\
        r"""
        If point constraints are enabled, an output vector indicating the
        average normal at each point can be generated.
        """
    )

    def _generate_constraint_normals_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetGenerateConstraintNormals,
                        self.generate_constraint_normals_)

    generate_constraint_scalars = tvtk_base.false_bool_trait(desc=\
        r"""
        If point constraints are enabled, an output scalar indicating the
        classification of points can be generated.
        """
    )

    def _generate_constraint_scalars_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetGenerateConstraintScalars,
                        self.generate_constraint_scalars_)

    motion_constraint = tvtk_base.RevPrefixMap({'unconstrained': 0, 'plane': 1}, default_value='unconstrained', desc=\
        r"""
        Specify how to constrain the motion of points. By default, point
        motion is unconstrained. Points can also be constrained to a
        plane. If constrained to a plane, then an instance of Plane
        must be specified.
        """
    )

    def _motion_constraint_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetMotionConstraint,
                        self.motion_constraint_)

    smoothing_mode = tvtk_base.RevPrefixMap({'default': 0, 'frame_field': 5, 'geometric': 1, 'scalars': 3, 'tensors': 4, 'uniform': 2}, default_value='default', desc=\
        r"""
        Control how smoothing is to be performed. By default, if a point
        frame field is available then frame field smoothing will be
        performed; then if point tensors are available then anisotropic
        tensor smoothing will be used; the next choice is to use
        isotropic scalar smoothing; and finally if no frame field,
        tensors, or scalars are available, uniform smoothing will be
        used. If both scalars, tensors, and /or a frame field are
        present, the user can specifiy which to use; or to use uniform or
        geometric smoothing.
        """
    )

    def _smoothing_mode_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetSmoothingMode,
                        self.smoothing_mode_)

    attraction_factor = traits.Trait(0.5, traits.Range(0.1, 10.0, enter_set=True, auto_set=False), desc=\
        r"""
        Control the relative distance of inter-particle attraction. A
        value of 1.0 means that the radius of the attraction region is
        the same as the radius of repulsion. By default, a value of 0.5
        is used (e.g., in the region 0<=r<=R a repulsive force is
        generated, while in R<r<=R*1.5 an attractive force is generated).
        """
    )

    def _attraction_factor_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetAttractionFactor,
                        self.attraction_factor)

    boundary_angle = traits.Trait(110.0, traits.Range(0.0, 120.0, enter_set=True, auto_set=False), desc=\
        r"""
        
        """
    )

    def _boundary_angle_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetBoundaryAngle,
                        self.boundary_angle)

    convergence = traits.Trait(0.0, traits.Range(0.0, 1.0, enter_set=True, auto_set=False), desc=\
        r"""
        Specify a convergence criterion for the iteration process.
        Smaller numbers result in more smoothing iterations.
        """
    )

    def _convergence_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetConvergence,
                        self.convergence)

    fixed_angle = traits.Trait(60.0, traits.Range(0.0, 90.0, enter_set=True, auto_set=False), desc=\
        r"""
        
        """
    )

    def _fixed_angle_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetFixedAngle,
                        self.fixed_angle)

    def _get_frame_field_array(self):
        return wrap_vtk(self._vtk_obj.GetFrameFieldArray())
    def _set_frame_field_array(self, arg):
        old_val = self._get_frame_field_array()
        my_arg = deref_array([arg], [['vtkDataArray']])
        self._wrap_call(self._vtk_obj.SetFrameFieldArray,
                        my_arg[0])
        self.trait_property_changed('frame_field_array', old_val, arg)
    frame_field_array = traits.Property(_get_frame_field_array, _set_frame_field_array, desc=\
        r"""
        
        """
    )

    def _get_locator(self):
        return wrap_vtk(self._vtk_obj.GetLocator())
    def _set_locator(self, arg):
        old_val = self._get_locator()
        self._wrap_call(self._vtk_obj.SetLocator,
                        deref_vtk(arg))
        self.trait_property_changed('locator', old_val, arg)
    locator = traits.Property(_get_locator, _set_locator, desc=\
        r"""
        
        """
    )

    maximum_step_size = traits.Trait(0.01, traits.Range(0.0, 1e+299, enter_set=True, auto_set=False), desc=\
        r"""
        Specify the maximum smoothing step size for each smoothing
        iteration. This step size limits the the distance over which a
        point can move in each iteration.  As in all iterative methods,
        the stability of the process is sensitive to this parameter. In
        general, small step size and large numbers of iterations are more
        stable than a larger step size and a smaller numbers of
        iterations.
        """
    )

    def _maximum_step_size_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetMaximumStepSize,
                        self.maximum_step_size)

    neighborhood_size = traits.Trait(8, traits.Range(4, 128, enter_set=True, auto_set=False), desc=\
        r"""
        Specify the neighborhood size. This controls the number of
        surrounding points that can affect a point to be smoothed.
        """
    )

    def _neighborhood_size_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetNeighborhoodSize,
                        self.neighborhood_size)

    number_of_iterations = traits.Trait(20, traits.Range(0, 2147483647, enter_set=True, auto_set=False), desc=\
        r"""
        Specify the number of smoothing iterations.
        """
    )

    def _number_of_iterations_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetNumberOfIterations,
                        self.number_of_iterations)

    number_of_sub_iterations = traits.Trait(10, traits.Range(1, 2147483647, enter_set=True, auto_set=False), desc=\
        r"""
        Specify the number of smoothing subiterations. This specifies the
        frequency of connectivity and data attribute updates.
        """
    )

    def _number_of_sub_iterations_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetNumberOfSubIterations,
                        self.number_of_sub_iterations)

    packing_factor = traits.Trait(1.0, traits.Range(0.1, 10.0, enter_set=True, auto_set=False), desc=\
        r"""
        Specify the packing factor. Larger numbers tend to loosen the
        overall packing of points. Note however that if the point density
        in a region is high, then the packing factor may have little
        effect (due to mutual inter-particle constraints). The default
        value is 1.0. (Note that a characteristic inter-particle radius R
        is computed at the onset of the algorithm (or can be manually
        specified). Within 0<=r<=R*packing_factor a repulsive force is
        generated.)
        """
    )

    def _packing_factor_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetPackingFactor,
                        self.packing_factor)

    packing_radius = traits.Trait(1.0, traits.Range(0.0, 1e+299, enter_set=True, auto_set=False), desc=\
        r"""
        Specify the packing radius R. This only takes effect if
        compute_packing_radius is off. Note that the for two points
        separated by radius r, a repulsive force is generated when
        0<=r<=R, and a repulsive force when R<=r<=(1+attraction_factor*R).
        By default, the packing_radius is automatically computed, but when
        compute_packing_radius is off, then manually setting the
        packing_radius is allowed. Note that the packing_radius is updated
        after the algorithm runs (useful to examine the computed packing
        radius).
        """
    )

    def _packing_radius_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetPackingRadius,
                        self.packing_radius)

    def _get_plane(self):
        return wrap_vtk(self._vtk_obj.GetPlane())
    def _set_plane(self, arg):
        old_val = self._get_plane()
        self._wrap_call(self._vtk_obj.SetPlane,
                        deref_vtk(arg))
        self.trait_property_changed('plane', old_val, arg)
    plane = traits.Property(_get_plane, _set_plane, desc=\
        r"""
        
        """
    )

    def _get_input(self):
        return wrap_vtk(self._vtk_obj.GetInput())
    input = traits.Property(_get_input, desc=\
        r"""
        
        """
    )

    _updateable_traits_ = \
    (('compute_packing_radius', 'GetComputePackingRadius'),
    ('enable_constraints', 'GetEnableConstraints'),
    ('generate_constraint_normals', 'GetGenerateConstraintNormals'),
    ('generate_constraint_scalars', 'GetGenerateConstraintScalars'),
    ('abort_execute', 'GetAbortExecute'), ('release_data_flag',
    'GetReleaseDataFlag'), ('debug', 'GetDebug'),
    ('global_warning_display', 'GetGlobalWarningDisplay'),
    ('motion_constraint', 'GetMotionConstraint'), ('smoothing_mode',
    'GetSmoothingMode'), ('attraction_factor', 'GetAttractionFactor'),
    ('boundary_angle', 'GetBoundaryAngle'), ('convergence',
    'GetConvergence'), ('fixed_angle', 'GetFixedAngle'),
    ('maximum_step_size', 'GetMaximumStepSize'), ('neighborhood_size',
    'GetNeighborhoodSize'), ('number_of_iterations',
    'GetNumberOfIterations'), ('number_of_sub_iterations',
    'GetNumberOfSubIterations'), ('packing_factor', 'GetPackingFactor'),
    ('packing_radius', 'GetPackingRadius'), ('progress_text',
    'GetProgressText'), ('object_name', 'GetObjectName'),
    ('reference_count', 'GetReferenceCount'))
    
    _allow_update_failure_ = \
    ()
    
    _full_traitnames_list_ = \
    (['abort_execute', 'compute_packing_radius', 'debug',
    'enable_constraints', 'generate_constraint_normals',
    'generate_constraint_scalars', 'global_warning_display',
    'release_data_flag', 'motion_constraint', 'smoothing_mode',
    'attraction_factor', 'boundary_angle', 'convergence', 'fixed_angle',
    'maximum_step_size', 'neighborhood_size', 'number_of_iterations',
    'number_of_sub_iterations', 'object_name', 'packing_factor',
    'packing_radius', 'progress_text'])
    
    def trait_view(self, name=None, view_element=None):
        if view_element is not None or name not in (None, '', 'traits_view', 'full_traits_view', 'view'):
            return super(PointSmoothingFilter, self).trait_view(name, view_element)
        if name == 'full_traits_view':
            full_traits_view = \
            View((Item("handler._full_traits_list",show_label=False)),
            title='Edit PointSmoothingFilter properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return full_traits_view
        elif name == 'view':
            view = \
            View((['compute_packing_radius', 'enable_constraints',
            'generate_constraint_normals', 'generate_constraint_scalars'],
            ['motion_constraint', 'smoothing_mode'], ['attraction_factor',
            'boundary_angle', 'convergence', 'fixed_angle', 'maximum_step_size',
            'neighborhood_size', 'number_of_iterations',
            'number_of_sub_iterations', 'object_name', 'packing_factor',
            'packing_radius']),
            title='Edit PointSmoothingFilter properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return view
        elif name in (None, 'traits_view'):
            traits_view = \
            View((HGroup(spring, "handler.view_type", show_border=True), 
            Item("handler.info.object", editor = InstanceEditor(view_name="handler.view"), style = "custom", show_label=False)),
            title='Edit PointSmoothingFilter properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return traits_view
            

